/**
 * @license
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * An image generated by Imagen, represented as inline data.
 *
 * @public
 */
export interface ImagenInlineImage {
  /**
   * The MIME type of the image; either `"image/png"` or `"image/jpeg"`.
   *
   * To request a different format, set the `imageFormat` property in your {@link ImagenGenerationConfig}.
   */
  mimeType: string;
  /**
   * The base64-encoded image data.
   */
  bytesBase64Encoded: string;
}

/**
 * An image generated by Imagen, stored in a Cloud Storage for Firebase bucket.
 *
 * This feature is not available yet.
 * @public
 */
export interface ImagenGCSImage {
  /**
   * The MIME type of the image; either `"image/png"` or `"image/jpeg"`.
   *
   * To request a different format, set the `imageFormat` property in your {@link ImagenGenerationConfig}.
   */
  mimeType: string;
  /**
   * The URI of the file stored in a Cloud Storage for Firebase bucket.
   *
   * @example `"gs://bucket-name/path/sample_0.jpg"`.
   */
  gcsURI: string;
}

/**
 * The response from a request to generate images with Imagen.
 *
 * @public
 */
export interface ImagenGenerationResponse<
  T extends ImagenInlineImage | ImagenGCSImage
> {
  /**
   * The images generated by Imagen.
   *
   * The number of images generated may be fewer than the number requested if one or more were
   * filtered out; see `filteredReason`.
   */
  images: T[];
  /**
   * The reason that images were filtered out. This property will only be defined if one
   * or more images were filtered.
   *
   * Images may be filtered out due to the {@link (ImagenSafetyFilterLevel:type)},
   * {@link (ImagenPersonFilterLevel:type)}, or filtering included in the model.
   * The filter levels may be adjusted in your {@link ImagenSafetySettings}.
   *
   * See the {@link https://cloud.google.com/vertex-ai/generative-ai/docs/image/responsible-ai-imagen | Responsible AI and usage guidelines for Imagen}
   * for more details.
   */
  filteredReason?: string;
}
