/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/instance.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * A resizable group of nodes in a particular cloud location, capable
 * of serving all [Tables][google.bigtable.admin.v2.Table] in the parent
 * [Instance][google.bigtable.admin.v2.Instance].
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.Cluster}
 */
public final class Cluster extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Cluster)
    ClusterOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Cluster.newBuilder() to construct.
  private Cluster(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cluster() {
    name_ = "";
    location_ = "";
    state_ = 0;
    nodeScalingFactor_ = 0;
    defaultStorageType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Cluster();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.InstanceProto
        .internal_static_google_bigtable_admin_v2_Cluster_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.InstanceProto
        .internal_static_google_bigtable_admin_v2_Cluster_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.Cluster.class,
            com.google.bigtable.admin.v2.Cluster.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a cluster.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.Cluster.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the cluster could not be determined.
     * </pre>
     *
     * <code>STATE_NOT_KNOWN = 0;</code>
     */
    STATE_NOT_KNOWN(0),
    /**
     *
     *
     * <pre>
     * The cluster has been successfully created and is ready to serve requests.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    READY(1),
    /**
     *
     *
     * <pre>
     * The cluster is currently being created, and may be destroyed
     * if the creation process encounters an error.
     * A cluster may not be able to serve requests while being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    CREATING(2),
    /**
     *
     *
     * <pre>
     * The cluster is currently being resized, and may revert to its previous
     * node count if the process encounters an error.
     * A cluster is still capable of serving requests while being resized,
     * but may exhibit performance as if its number of allocated nodes is
     * between the starting and requested states.
     * </pre>
     *
     * <code>RESIZING = 3;</code>
     */
    RESIZING(3),
    /**
     *
     *
     * <pre>
     * The cluster has no backing nodes. The data (tables) still
     * exist, but no operations can be performed on the cluster.
     * </pre>
     *
     * <code>DISABLED = 4;</code>
     */
    DISABLED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the cluster could not be determined.
     * </pre>
     *
     * <code>STATE_NOT_KNOWN = 0;</code>
     */
    public static final int STATE_NOT_KNOWN_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The cluster has been successfully created and is ready to serve requests.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    public static final int READY_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The cluster is currently being created, and may be destroyed
     * if the creation process encounters an error.
     * A cluster may not be able to serve requests while being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    public static final int CREATING_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The cluster is currently being resized, and may revert to its previous
     * node count if the process encounters an error.
     * A cluster is still capable of serving requests while being resized,
     * but may exhibit performance as if its number of allocated nodes is
     * between the starting and requested states.
     * </pre>
     *
     * <code>RESIZING = 3;</code>
     */
    public static final int RESIZING_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The cluster has no backing nodes. The data (tables) still
     * exist, but no operations can be performed on the cluster.
     * </pre>
     *
     * <code>DISABLED = 4;</code>
     */
    public static final int DISABLED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_NOT_KNOWN;
        case 1:
          return READY;
        case 2:
          return CREATING;
        case 3:
          return RESIZING;
        case 4:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.Cluster.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Cluster.State)
  }

  /**
   *
   *
   * <pre>
   * Possible node scaling factors of the clusters. Node scaling delivers better
   * latency and more throughput by removing node boundaries.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.Cluster.NodeScalingFactor}
   */
  public enum NodeScalingFactor implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No node scaling specified. Defaults to NODE_SCALING_FACTOR_1X.
     * </pre>
     *
     * <code>NODE_SCALING_FACTOR_UNSPECIFIED = 0;</code>
     */
    NODE_SCALING_FACTOR_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The cluster is running with a scaling factor of 1.
     * </pre>
     *
     * <code>NODE_SCALING_FACTOR_1X = 1;</code>
     */
    NODE_SCALING_FACTOR_1X(1),
    /**
     *
     *
     * <pre>
     * The cluster is running with a scaling factor of 2.
     * All node count values must be in increments of 2 with this scaling factor
     * enabled, otherwise an INVALID_ARGUMENT error will be returned.
     * </pre>
     *
     * <code>NODE_SCALING_FACTOR_2X = 2;</code>
     */
    NODE_SCALING_FACTOR_2X(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No node scaling specified. Defaults to NODE_SCALING_FACTOR_1X.
     * </pre>
     *
     * <code>NODE_SCALING_FACTOR_UNSPECIFIED = 0;</code>
     */
    public static final int NODE_SCALING_FACTOR_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The cluster is running with a scaling factor of 1.
     * </pre>
     *
     * <code>NODE_SCALING_FACTOR_1X = 1;</code>
     */
    public static final int NODE_SCALING_FACTOR_1X_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The cluster is running with a scaling factor of 2.
     * All node count values must be in increments of 2 with this scaling factor
     * enabled, otherwise an INVALID_ARGUMENT error will be returned.
     * </pre>
     *
     * <code>NODE_SCALING_FACTOR_2X = 2;</code>
     */
    public static final int NODE_SCALING_FACTOR_2X_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NodeScalingFactor valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NodeScalingFactor forNumber(int value) {
      switch (value) {
        case 0:
          return NODE_SCALING_FACTOR_UNSPECIFIED;
        case 1:
          return NODE_SCALING_FACTOR_1X;
        case 2:
          return NODE_SCALING_FACTOR_2X;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NodeScalingFactor>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NodeScalingFactor>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<NodeScalingFactor>() {
              public NodeScalingFactor findValueByNumber(int number) {
                return NodeScalingFactor.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.Cluster.getDescriptor().getEnumTypes().get(1);
    }

    private static final NodeScalingFactor[] VALUES = values();

    public static NodeScalingFactor valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NodeScalingFactor(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Cluster.NodeScalingFactor)
  }

  public interface ClusterAutoscalingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoscalingLimits field is set.
     */
    boolean hasAutoscalingLimits();

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoscalingLimits.
     */
    com.google.bigtable.admin.v2.AutoscalingLimits getAutoscalingLimits();

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.bigtable.admin.v2.AutoscalingLimitsOrBuilder getAutoscalingLimitsOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Autoscaling targets for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoscalingTargets field is set.
     */
    boolean hasAutoscalingTargets();

    /**
     *
     *
     * <pre>
     * Required. Autoscaling targets for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoscalingTargets.
     */
    com.google.bigtable.admin.v2.AutoscalingTargets getAutoscalingTargets();

    /**
     *
     *
     * <pre>
     * Required. Autoscaling targets for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.bigtable.admin.v2.AutoscalingTargetsOrBuilder getAutoscalingTargetsOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Autoscaling config for a cluster.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig}
   */
  public static final class ClusterAutoscalingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig)
      ClusterAutoscalingConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ClusterAutoscalingConfig.newBuilder() to construct.
    private ClusterAutoscalingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClusterAutoscalingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClusterAutoscalingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_ClusterAutoscalingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_ClusterAutoscalingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.class,
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.Builder.class);
    }

    private int bitField0_;
    public static final int AUTOSCALING_LIMITS_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.AutoscalingLimits autoscalingLimits_;

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoscalingLimits field is set.
     */
    @java.lang.Override
    public boolean hasAutoscalingLimits() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoscalingLimits.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AutoscalingLimits getAutoscalingLimits() {
      return autoscalingLimits_ == null
          ? com.google.bigtable.admin.v2.AutoscalingLimits.getDefaultInstance()
          : autoscalingLimits_;
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AutoscalingLimitsOrBuilder getAutoscalingLimitsOrBuilder() {
      return autoscalingLimits_ == null
          ? com.google.bigtable.admin.v2.AutoscalingLimits.getDefaultInstance()
          : autoscalingLimits_;
    }

    public static final int AUTOSCALING_TARGETS_FIELD_NUMBER = 2;
    private com.google.bigtable.admin.v2.AutoscalingTargets autoscalingTargets_;

    /**
     *
     *
     * <pre>
     * Required. Autoscaling targets for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoscalingTargets field is set.
     */
    @java.lang.Override
    public boolean hasAutoscalingTargets() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling targets for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoscalingTargets.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AutoscalingTargets getAutoscalingTargets() {
      return autoscalingTargets_ == null
          ? com.google.bigtable.admin.v2.AutoscalingTargets.getDefaultInstance()
          : autoscalingTargets_;
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling targets for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AutoscalingTargetsOrBuilder
        getAutoscalingTargetsOrBuilder() {
      return autoscalingTargets_ == null
          ? com.google.bigtable.admin.v2.AutoscalingTargets.getDefaultInstance()
          : autoscalingTargets_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getAutoscalingLimits());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getAutoscalingTargets());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAutoscalingLimits());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAutoscalingTargets());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig other =
          (com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig) obj;

      if (hasAutoscalingLimits() != other.hasAutoscalingLimits()) return false;
      if (hasAutoscalingLimits()) {
        if (!getAutoscalingLimits().equals(other.getAutoscalingLimits())) return false;
      }
      if (hasAutoscalingTargets() != other.hasAutoscalingTargets()) return false;
      if (hasAutoscalingTargets()) {
        if (!getAutoscalingTargets().equals(other.getAutoscalingTargets())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAutoscalingLimits()) {
        hash = (37 * hash) + AUTOSCALING_LIMITS_FIELD_NUMBER;
        hash = (53 * hash) + getAutoscalingLimits().hashCode();
      }
      if (hasAutoscalingTargets()) {
        hash = (37 * hash) + AUTOSCALING_TARGETS_FIELD_NUMBER;
        hash = (53 * hash) + getAutoscalingTargets().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Autoscaling config for a cluster.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig)
        com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_ClusterAutoscalingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_ClusterAutoscalingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.class,
                com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAutoscalingLimitsFieldBuilder();
          getAutoscalingTargetsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        autoscalingLimits_ = null;
        if (autoscalingLimitsBuilder_ != null) {
          autoscalingLimitsBuilder_.dispose();
          autoscalingLimitsBuilder_ = null;
        }
        autoscalingTargets_ = null;
        if (autoscalingTargetsBuilder_ != null) {
          autoscalingTargetsBuilder_.dispose();
          autoscalingTargetsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_ClusterAutoscalingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
          getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig build() {
        com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig buildPartial() {
        com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig result =
            new com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.autoscalingLimits_ =
              autoscalingLimitsBuilder_ == null
                  ? autoscalingLimits_
                  : autoscalingLimitsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.autoscalingTargets_ =
              autoscalingTargetsBuilder_ == null
                  ? autoscalingTargets_
                  : autoscalingTargetsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig) {
          return mergeFrom((com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig other) {
        if (other
            == com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.getDefaultInstance())
          return this;
        if (other.hasAutoscalingLimits()) {
          mergeAutoscalingLimits(other.getAutoscalingLimits());
        }
        if (other.hasAutoscalingTargets()) {
          mergeAutoscalingTargets(other.getAutoscalingTargets());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getAutoscalingLimitsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getAutoscalingTargetsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.AutoscalingLimits autoscalingLimits_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.AutoscalingLimits,
              com.google.bigtable.admin.v2.AutoscalingLimits.Builder,
              com.google.bigtable.admin.v2.AutoscalingLimitsOrBuilder>
          autoscalingLimitsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the autoscalingLimits field is set.
       */
      public boolean hasAutoscalingLimits() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The autoscalingLimits.
       */
      public com.google.bigtable.admin.v2.AutoscalingLimits getAutoscalingLimits() {
        if (autoscalingLimitsBuilder_ == null) {
          return autoscalingLimits_ == null
              ? com.google.bigtable.admin.v2.AutoscalingLimits.getDefaultInstance()
              : autoscalingLimits_;
        } else {
          return autoscalingLimitsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAutoscalingLimits(com.google.bigtable.admin.v2.AutoscalingLimits value) {
        if (autoscalingLimitsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          autoscalingLimits_ = value;
        } else {
          autoscalingLimitsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAutoscalingLimits(
          com.google.bigtable.admin.v2.AutoscalingLimits.Builder builderForValue) {
        if (autoscalingLimitsBuilder_ == null) {
          autoscalingLimits_ = builderForValue.build();
        } else {
          autoscalingLimitsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeAutoscalingLimits(com.google.bigtable.admin.v2.AutoscalingLimits value) {
        if (autoscalingLimitsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && autoscalingLimits_ != null
              && autoscalingLimits_
                  != com.google.bigtable.admin.v2.AutoscalingLimits.getDefaultInstance()) {
            getAutoscalingLimitsBuilder().mergeFrom(value);
          } else {
            autoscalingLimits_ = value;
          }
        } else {
          autoscalingLimitsBuilder_.mergeFrom(value);
        }
        if (autoscalingLimits_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearAutoscalingLimits() {
        bitField0_ = (bitField0_ & ~0x00000001);
        autoscalingLimits_ = null;
        if (autoscalingLimitsBuilder_ != null) {
          autoscalingLimitsBuilder_.dispose();
          autoscalingLimitsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.admin.v2.AutoscalingLimits.Builder getAutoscalingLimitsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getAutoscalingLimitsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.admin.v2.AutoscalingLimitsOrBuilder
          getAutoscalingLimitsOrBuilder() {
        if (autoscalingLimitsBuilder_ != null) {
          return autoscalingLimitsBuilder_.getMessageOrBuilder();
        } else {
          return autoscalingLimits_ == null
              ? com.google.bigtable.admin.v2.AutoscalingLimits.getDefaultInstance()
              : autoscalingLimits_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling limits for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.AutoscalingLimits,
              com.google.bigtable.admin.v2.AutoscalingLimits.Builder,
              com.google.bigtable.admin.v2.AutoscalingLimitsOrBuilder>
          getAutoscalingLimitsFieldBuilder() {
        if (autoscalingLimitsBuilder_ == null) {
          autoscalingLimitsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.AutoscalingLimits,
                  com.google.bigtable.admin.v2.AutoscalingLimits.Builder,
                  com.google.bigtable.admin.v2.AutoscalingLimitsOrBuilder>(
                  getAutoscalingLimits(), getParentForChildren(), isClean());
          autoscalingLimits_ = null;
        }
        return autoscalingLimitsBuilder_;
      }

      private com.google.bigtable.admin.v2.AutoscalingTargets autoscalingTargets_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.AutoscalingTargets,
              com.google.bigtable.admin.v2.AutoscalingTargets.Builder,
              com.google.bigtable.admin.v2.AutoscalingTargetsOrBuilder>
          autoscalingTargetsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the autoscalingTargets field is set.
       */
      public boolean hasAutoscalingTargets() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The autoscalingTargets.
       */
      public com.google.bigtable.admin.v2.AutoscalingTargets getAutoscalingTargets() {
        if (autoscalingTargetsBuilder_ == null) {
          return autoscalingTargets_ == null
              ? com.google.bigtable.admin.v2.AutoscalingTargets.getDefaultInstance()
              : autoscalingTargets_;
        } else {
          return autoscalingTargetsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAutoscalingTargets(com.google.bigtable.admin.v2.AutoscalingTargets value) {
        if (autoscalingTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          autoscalingTargets_ = value;
        } else {
          autoscalingTargetsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAutoscalingTargets(
          com.google.bigtable.admin.v2.AutoscalingTargets.Builder builderForValue) {
        if (autoscalingTargetsBuilder_ == null) {
          autoscalingTargets_ = builderForValue.build();
        } else {
          autoscalingTargetsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeAutoscalingTargets(
          com.google.bigtable.admin.v2.AutoscalingTargets value) {
        if (autoscalingTargetsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && autoscalingTargets_ != null
              && autoscalingTargets_
                  != com.google.bigtable.admin.v2.AutoscalingTargets.getDefaultInstance()) {
            getAutoscalingTargetsBuilder().mergeFrom(value);
          } else {
            autoscalingTargets_ = value;
          }
        } else {
          autoscalingTargetsBuilder_.mergeFrom(value);
        }
        if (autoscalingTargets_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearAutoscalingTargets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        autoscalingTargets_ = null;
        if (autoscalingTargetsBuilder_ != null) {
          autoscalingTargetsBuilder_.dispose();
          autoscalingTargetsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.admin.v2.AutoscalingTargets.Builder
          getAutoscalingTargetsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getAutoscalingTargetsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.admin.v2.AutoscalingTargetsOrBuilder
          getAutoscalingTargetsOrBuilder() {
        if (autoscalingTargetsBuilder_ != null) {
          return autoscalingTargetsBuilder_.getMessageOrBuilder();
        } else {
          return autoscalingTargets_ == null
              ? com.google.bigtable.admin.v2.AutoscalingTargets.getDefaultInstance()
              : autoscalingTargets_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Autoscaling targets for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.AutoscalingTargets,
              com.google.bigtable.admin.v2.AutoscalingTargets.Builder,
              com.google.bigtable.admin.v2.AutoscalingTargetsOrBuilder>
          getAutoscalingTargetsFieldBuilder() {
        if (autoscalingTargetsBuilder_ == null) {
          autoscalingTargetsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.AutoscalingTargets,
                  com.google.bigtable.admin.v2.AutoscalingTargets.Builder,
                  com.google.bigtable.admin.v2.AutoscalingTargetsOrBuilder>(
                  getAutoscalingTargets(), getParentForChildren(), isClean());
          autoscalingTargets_ = null;
        }
        return autoscalingTargetsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig)
    private static final com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig();
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClusterAutoscalingConfig> PARSER =
        new com.google.protobuf.AbstractParser<ClusterAutoscalingConfig>() {
          @java.lang.Override
          public ClusterAutoscalingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ClusterAutoscalingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClusterAutoscalingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ClusterConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Cluster.ClusterConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Autoscaling configuration for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
     * </code>
     *
     * @return Whether the clusterAutoscalingConfig field is set.
     */
    boolean hasClusterAutoscalingConfig();

    /**
     *
     *
     * <pre>
     * Autoscaling configuration for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
     * </code>
     *
     * @return The clusterAutoscalingConfig.
     */
    com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig getClusterAutoscalingConfig();

    /**
     *
     *
     * <pre>
     * Autoscaling configuration for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
     * </code>
     */
    com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfigOrBuilder
        getClusterAutoscalingConfigOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Configuration for a cluster.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Cluster.ClusterConfig}
   */
  public static final class ClusterConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Cluster.ClusterConfig)
      ClusterConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ClusterConfig.newBuilder() to construct.
    private ClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClusterConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClusterConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_ClusterConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_ClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Cluster.ClusterConfig.class,
              com.google.bigtable.admin.v2.Cluster.ClusterConfig.Builder.class);
    }

    private int bitField0_;
    public static final int CLUSTER_AUTOSCALING_CONFIG_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig clusterAutoscalingConfig_;

    /**
     *
     *
     * <pre>
     * Autoscaling configuration for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
     * </code>
     *
     * @return Whether the clusterAutoscalingConfig field is set.
     */
    @java.lang.Override
    public boolean hasClusterAutoscalingConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Autoscaling configuration for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
     * </code>
     *
     * @return The clusterAutoscalingConfig.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
        getClusterAutoscalingConfig() {
      return clusterAutoscalingConfig_ == null
          ? com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.getDefaultInstance()
          : clusterAutoscalingConfig_;
    }

    /**
     *
     *
     * <pre>
     * Autoscaling configuration for this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfigOrBuilder
        getClusterAutoscalingConfigOrBuilder() {
      return clusterAutoscalingConfig_ == null
          ? com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.getDefaultInstance()
          : clusterAutoscalingConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getClusterAutoscalingConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getClusterAutoscalingConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Cluster.ClusterConfig)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Cluster.ClusterConfig other =
          (com.google.bigtable.admin.v2.Cluster.ClusterConfig) obj;

      if (hasClusterAutoscalingConfig() != other.hasClusterAutoscalingConfig()) return false;
      if (hasClusterAutoscalingConfig()) {
        if (!getClusterAutoscalingConfig().equals(other.getClusterAutoscalingConfig()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasClusterAutoscalingConfig()) {
        hash = (37 * hash) + CLUSTER_AUTOSCALING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getClusterAutoscalingConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Cluster.ClusterConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for a cluster.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Cluster.ClusterConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Cluster.ClusterConfig)
        com.google.bigtable.admin.v2.Cluster.ClusterConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_ClusterConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_ClusterConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Cluster.ClusterConfig.class,
                com.google.bigtable.admin.v2.Cluster.ClusterConfig.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Cluster.ClusterConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getClusterAutoscalingConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        clusterAutoscalingConfig_ = null;
        if (clusterAutoscalingConfigBuilder_ != null) {
          clusterAutoscalingConfigBuilder_.dispose();
          clusterAutoscalingConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_ClusterConfig_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.ClusterConfig getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.ClusterConfig build() {
        com.google.bigtable.admin.v2.Cluster.ClusterConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.ClusterConfig buildPartial() {
        com.google.bigtable.admin.v2.Cluster.ClusterConfig result =
            new com.google.bigtable.admin.v2.Cluster.ClusterConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Cluster.ClusterConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.clusterAutoscalingConfig_ =
              clusterAutoscalingConfigBuilder_ == null
                  ? clusterAutoscalingConfig_
                  : clusterAutoscalingConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Cluster.ClusterConfig) {
          return mergeFrom((com.google.bigtable.admin.v2.Cluster.ClusterConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Cluster.ClusterConfig other) {
        if (other == com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance())
          return this;
        if (other.hasClusterAutoscalingConfig()) {
          mergeClusterAutoscalingConfig(other.getClusterAutoscalingConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getClusterAutoscalingConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
          clusterAutoscalingConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig,
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.Builder,
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfigOrBuilder>
          clusterAutoscalingConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       *
       * @return Whether the clusterAutoscalingConfig field is set.
       */
      public boolean hasClusterAutoscalingConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       *
       * @return The clusterAutoscalingConfig.
       */
      public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
          getClusterAutoscalingConfig() {
        if (clusterAutoscalingConfigBuilder_ == null) {
          return clusterAutoscalingConfig_ == null
              ? com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.getDefaultInstance()
              : clusterAutoscalingConfig_;
        } else {
          return clusterAutoscalingConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       */
      public Builder setClusterAutoscalingConfig(
          com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig value) {
        if (clusterAutoscalingConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          clusterAutoscalingConfig_ = value;
        } else {
          clusterAutoscalingConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       */
      public Builder setClusterAutoscalingConfig(
          com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.Builder builderForValue) {
        if (clusterAutoscalingConfigBuilder_ == null) {
          clusterAutoscalingConfig_ = builderForValue.build();
        } else {
          clusterAutoscalingConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       */
      public Builder mergeClusterAutoscalingConfig(
          com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig value) {
        if (clusterAutoscalingConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && clusterAutoscalingConfig_ != null
              && clusterAutoscalingConfig_
                  != com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
                      .getDefaultInstance()) {
            getClusterAutoscalingConfigBuilder().mergeFrom(value);
          } else {
            clusterAutoscalingConfig_ = value;
          }
        } else {
          clusterAutoscalingConfigBuilder_.mergeFrom(value);
        }
        if (clusterAutoscalingConfig_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       */
      public Builder clearClusterAutoscalingConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        clusterAutoscalingConfig_ = null;
        if (clusterAutoscalingConfigBuilder_ != null) {
          clusterAutoscalingConfigBuilder_.dispose();
          clusterAutoscalingConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       */
      public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.Builder
          getClusterAutoscalingConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getClusterAutoscalingConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       */
      public com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfigOrBuilder
          getClusterAutoscalingConfigOrBuilder() {
        if (clusterAutoscalingConfigBuilder_ != null) {
          return clusterAutoscalingConfigBuilder_.getMessageOrBuilder();
        } else {
          return clusterAutoscalingConfig_ == null
              ? com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.getDefaultInstance()
              : clusterAutoscalingConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Autoscaling configuration for this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig cluster_autoscaling_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig,
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.Builder,
              com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfigOrBuilder>
          getClusterAutoscalingConfigFieldBuilder() {
        if (clusterAutoscalingConfigBuilder_ == null) {
          clusterAutoscalingConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig,
                  com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.Builder,
                  com.google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfigOrBuilder>(
                  getClusterAutoscalingConfig(), getParentForChildren(), isClean());
          clusterAutoscalingConfig_ = null;
        }
        return clusterAutoscalingConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Cluster.ClusterConfig)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Cluster.ClusterConfig)
    private static final com.google.bigtable.admin.v2.Cluster.ClusterConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Cluster.ClusterConfig();
    }

    public static com.google.bigtable.admin.v2.Cluster.ClusterConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClusterConfig> PARSER =
        new com.google.protobuf.AbstractParser<ClusterConfig>() {
          @java.lang.Override
          public ClusterConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ClusterConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClusterConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.ClusterConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EncryptionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Cluster.EncryptionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Describes the Cloud KMS encryption key that will be used to protect the
     * destination Bigtable cluster. The requirements for this key are:
     *  1) The Cloud Bigtable service account associated with the project that
     *  contains this cluster must be granted the
     *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
     *  2) Only regional keys can be used and the region of the CMEK key must
     *  match the region of the cluster.
     * Values are of the form
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyName.
     */
    java.lang.String getKmsKeyName();

    /**
     *
     *
     * <pre>
     * Describes the Cloud KMS encryption key that will be used to protect the
     * destination Bigtable cluster. The requirements for this key are:
     *  1) The Cloud Bigtable service account associated with the project that
     *  contains this cluster must be granted the
     *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
     *  2) Only regional keys can be used and the region of the CMEK key must
     *  match the region of the cluster.
     * Values are of the form
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyName.
     */
    com.google.protobuf.ByteString getKmsKeyNameBytes();
  }

  /**
   *
   *
   * <pre>
   * Cloud Key Management Service (Cloud KMS) settings for a CMEK-protected
   * cluster.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Cluster.EncryptionConfig}
   */
  public static final class EncryptionConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Cluster.EncryptionConfig)
      EncryptionConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use EncryptionConfig.newBuilder() to construct.
    private EncryptionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EncryptionConfig() {
      kmsKeyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EncryptionConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_EncryptionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_EncryptionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Cluster.EncryptionConfig.class,
              com.google.bigtable.admin.v2.Cluster.EncryptionConfig.Builder.class);
    }

    public static final int KMS_KEY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kmsKeyName_ = "";

    /**
     *
     *
     * <pre>
     * Describes the Cloud KMS encryption key that will be used to protect the
     * destination Bigtable cluster. The requirements for this key are:
     *  1) The Cloud Bigtable service account associated with the project that
     *  contains this cluster must be granted the
     *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
     *  2) Only regional keys can be used and the region of the CMEK key must
     *  match the region of the cluster.
     * Values are of the form
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyName.
     */
    @java.lang.Override
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Describes the Cloud KMS encryption key that will be used to protect the
     * destination Bigtable cluster. The requirements for this key are:
     *  1) The Cloud Bigtable service account associated with the project that
     *  contains this cluster must be granted the
     *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
     *  2) Only regional keys can be used and the region of the CMEK key must
     *  match the region of the cluster.
     * Values are of the form
     * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kmsKeyName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kmsKeyName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Cluster.EncryptionConfig)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Cluster.EncryptionConfig other =
          (com.google.bigtable.admin.v2.Cluster.EncryptionConfig) obj;

      if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKeyName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.Cluster.EncryptionConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Cloud Key Management Service (Cloud KMS) settings for a CMEK-protected
     * cluster.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Cluster.EncryptionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Cluster.EncryptionConfig)
        com.google.bigtable.admin.v2.Cluster.EncryptionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_EncryptionConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_EncryptionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Cluster.EncryptionConfig.class,
                com.google.bigtable.admin.v2.Cluster.EncryptionConfig.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Cluster.EncryptionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kmsKeyName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_Cluster_EncryptionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.EncryptionConfig getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Cluster.EncryptionConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.EncryptionConfig build() {
        com.google.bigtable.admin.v2.Cluster.EncryptionConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Cluster.EncryptionConfig buildPartial() {
        com.google.bigtable.admin.v2.Cluster.EncryptionConfig result =
            new com.google.bigtable.admin.v2.Cluster.EncryptionConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Cluster.EncryptionConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kmsKeyName_ = kmsKeyName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Cluster.EncryptionConfig) {
          return mergeFrom((com.google.bigtable.admin.v2.Cluster.EncryptionConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Cluster.EncryptionConfig other) {
        if (other == com.google.bigtable.admin.v2.Cluster.EncryptionConfig.getDefaultInstance())
          return this;
        if (!other.getKmsKeyName().isEmpty()) {
          kmsKeyName_ = other.kmsKeyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  kmsKeyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object kmsKeyName_ = "";

      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to protect the
       * destination Bigtable cluster. The requirements for this key are:
       *  1) The Cloud Bigtable service account associated with the project that
       *  contains this cluster must be granted the
       *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
       *  2) Only regional keys can be used and the region of the CMEK key must
       *  match the region of the cluster.
       * Values are of the form
       * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The kmsKeyName.
       */
      public java.lang.String getKmsKeyName() {
        java.lang.Object ref = kmsKeyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKeyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to protect the
       * destination Bigtable cluster. The requirements for this key are:
       *  1) The Cloud Bigtable service account associated with the project that
       *  contains this cluster must be granted the
       *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
       *  2) Only regional keys can be used and the region of the CMEK key must
       *  match the region of the cluster.
       * Values are of the form
       * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for kmsKeyName.
       */
      public com.google.protobuf.ByteString getKmsKeyNameBytes() {
        java.lang.Object ref = kmsKeyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKeyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to protect the
       * destination Bigtable cluster. The requirements for this key are:
       *  1) The Cloud Bigtable service account associated with the project that
       *  contains this cluster must be granted the
       *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
       *  2) Only regional keys can be used and the region of the CMEK key must
       *  match the region of the cluster.
       * Values are of the form
       * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The kmsKeyName to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kmsKeyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to protect the
       * destination Bigtable cluster. The requirements for this key are:
       *  1) The Cloud Bigtable service account associated with the project that
       *  contains this cluster must be granted the
       *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
       *  2) Only regional keys can be used and the region of the CMEK key must
       *  match the region of the cluster.
       * Values are of the form
       * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKeyName() {
        kmsKeyName_ = getDefaultInstance().getKmsKeyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the Cloud KMS encryption key that will be used to protect the
       * destination Bigtable cluster. The requirements for this key are:
       *  1) The Cloud Bigtable service account associated with the project that
       *  contains this cluster must be granted the
       *  `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
       *  2) Only regional keys can be used and the region of the CMEK key must
       *  match the region of the cluster.
       * Values are of the form
       * `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for kmsKeyName to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kmsKeyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Cluster.EncryptionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Cluster.EncryptionConfig)
    private static final com.google.bigtable.admin.v2.Cluster.EncryptionConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Cluster.EncryptionConfig();
    }

    public static com.google.bigtable.admin.v2.Cluster.EncryptionConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EncryptionConfig> PARSER =
        new com.google.protobuf.AbstractParser<EncryptionConfig>() {
          @java.lang.Override
          public EncryptionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EncryptionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EncryptionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.EncryptionConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int configCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object config_;

  public enum ConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLUSTER_CONFIG(7),
    CONFIG_NOT_SET(0);
    private final int value;

    private ConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConfigCase forNumber(int value) {
      switch (value) {
        case 7:
          return CLUSTER_CONFIG;
        case 0:
          return CONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConfigCase getConfigCase() {
    return ConfigCase.forNumber(configCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The unique name of the cluster. Values are of the form
   * `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The unique name of the cluster. Values are of the form
   * `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The location where this cluster's nodes and storage reside. For
   * best performance, clients should be located as close as possible to this
   * cluster. Currently only zones are supported, so values should be of the
   * form `projects/{project}/locations/{zone}`.
   * </pre>
   *
   * <code>
   * string location = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The location where this cluster's nodes and storage reside. For
   * best performance, clients should be located as close as possible to this
   * cluster. Currently only zones are supported, so values should be of the
   * form `projects/{project}/locations/{zone}`.
   * </pre>
   *
   * <code>
   * string location = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The current state of the cluster.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Cluster.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The current state of the cluster.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Cluster.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster.State getState() {
    com.google.bigtable.admin.v2.Cluster.State result =
        com.google.bigtable.admin.v2.Cluster.State.forNumber(state_);
    return result == null ? com.google.bigtable.admin.v2.Cluster.State.UNRECOGNIZED : result;
  }

  public static final int SERVE_NODES_FIELD_NUMBER = 4;
  private int serveNodes_ = 0;

  /**
   *
   *
   * <pre>
   * The number of nodes in the cluster. If no value is set,
   * Cloud Bigtable automatically allocates nodes based on your data footprint
   * and optimized for 50% storage utilization.
   * </pre>
   *
   * <code>int32 serve_nodes = 4;</code>
   *
   * @return The serveNodes.
   */
  @java.lang.Override
  public int getServeNodes() {
    return serveNodes_;
  }

  public static final int NODE_SCALING_FACTOR_FIELD_NUMBER = 9;
  private int nodeScalingFactor_ = 0;

  /**
   *
   *
   * <pre>
   * Immutable. The node scaling factor of this cluster.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Cluster.NodeScalingFactor node_scaling_factor = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for nodeScalingFactor.
   */
  @java.lang.Override
  public int getNodeScalingFactorValue() {
    return nodeScalingFactor_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The node scaling factor of this cluster.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Cluster.NodeScalingFactor node_scaling_factor = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The nodeScalingFactor.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster.NodeScalingFactor getNodeScalingFactor() {
    com.google.bigtable.admin.v2.Cluster.NodeScalingFactor result =
        com.google.bigtable.admin.v2.Cluster.NodeScalingFactor.forNumber(nodeScalingFactor_);
    return result == null
        ? com.google.bigtable.admin.v2.Cluster.NodeScalingFactor.UNRECOGNIZED
        : result;
  }

  public static final int CLUSTER_CONFIG_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Configuration for this cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
   *
   * @return Whether the clusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasClusterConfig() {
    return configCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Configuration for this cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
   *
   * @return The clusterConfig.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster.ClusterConfig getClusterConfig() {
    if (configCase_ == 7) {
      return (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_;
    }
    return com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Configuration for this cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster.ClusterConfigOrBuilder getClusterConfigOrBuilder() {
    if (configCase_ == 7) {
      return (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_;
    }
    return com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance();
  }

  public static final int DEFAULT_STORAGE_TYPE_FIELD_NUMBER = 5;
  private int defaultStorageType_ = 0;

  /**
   *
   *
   * <pre>
   * Immutable. The type of storage used by this cluster to serve its
   * parent instance's tables, unless explicitly overridden.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.StorageType default_storage_type = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for defaultStorageType.
   */
  @java.lang.Override
  public int getDefaultStorageTypeValue() {
    return defaultStorageType_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The type of storage used by this cluster to serve its
   * parent instance's tables, unless explicitly overridden.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.StorageType default_storage_type = 5 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The defaultStorageType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.StorageType getDefaultStorageType() {
    com.google.bigtable.admin.v2.StorageType result =
        com.google.bigtable.admin.v2.StorageType.forNumber(defaultStorageType_);
    return result == null ? com.google.bigtable.admin.v2.StorageType.UNRECOGNIZED : result;
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 6;
  private com.google.bigtable.admin.v2.Cluster.EncryptionConfig encryptionConfig_;

  /**
   *
   *
   * <pre>
   * Immutable. The encryption configuration for CMEK-protected clusters.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. The encryption configuration for CMEK-protected clusters.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.bigtable.admin.v2.Cluster.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The encryption configuration for CMEK-protected clusters.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.bigtable.admin.v2.Cluster.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
    }
    if (state_ != com.google.bigtable.admin.v2.Cluster.State.STATE_NOT_KNOWN.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (serveNodes_ != 0) {
      output.writeInt32(4, serveNodes_);
    }
    if (defaultStorageType_
        != com.google.bigtable.admin.v2.StorageType.STORAGE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, defaultStorageType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getEncryptionConfig());
    }
    if (configCase_ == 7) {
      output.writeMessage(7, (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_);
    }
    if (nodeScalingFactor_
        != com.google.bigtable.admin.v2.Cluster.NodeScalingFactor.NODE_SCALING_FACTOR_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, nodeScalingFactor_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
    }
    if (state_ != com.google.bigtable.admin.v2.Cluster.State.STATE_NOT_KNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (serveNodes_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, serveNodes_);
    }
    if (defaultStorageType_
        != com.google.bigtable.admin.v2.StorageType.STORAGE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, defaultStorageType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEncryptionConfig());
    }
    if (configCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_);
    }
    if (nodeScalingFactor_
        != com.google.bigtable.admin.v2.Cluster.NodeScalingFactor.NODE_SCALING_FACTOR_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, nodeScalingFactor_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.Cluster)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.Cluster other = (com.google.bigtable.admin.v2.Cluster) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (state_ != other.state_) return false;
    if (getServeNodes() != other.getServeNodes()) return false;
    if (nodeScalingFactor_ != other.nodeScalingFactor_) return false;
    if (defaultStorageType_ != other.defaultStorageType_) return false;
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (!getConfigCase().equals(other.getConfigCase())) return false;
    switch (configCase_) {
      case 7:
        if (!getClusterConfig().equals(other.getClusterConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SERVE_NODES_FIELD_NUMBER;
    hash = (53 * hash) + getServeNodes();
    hash = (37 * hash) + NODE_SCALING_FACTOR_FIELD_NUMBER;
    hash = (53 * hash) + nodeScalingFactor_;
    hash = (37 * hash) + DEFAULT_STORAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + defaultStorageType_;
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    switch (configCase_) {
      case 7:
        hash = (37 * hash) + CLUSTER_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getClusterConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Cluster parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.Cluster prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A resizable group of nodes in a particular cloud location, capable
   * of serving all [Tables][google.bigtable.admin.v2.Table] in the parent
   * [Instance][google.bigtable.admin.v2.Instance].
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Cluster}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Cluster)
      com.google.bigtable.admin.v2.ClusterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Cluster.class,
              com.google.bigtable.admin.v2.Cluster.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.Cluster.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEncryptionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      location_ = "";
      state_ = 0;
      serveNodes_ = 0;
      nodeScalingFactor_ = 0;
      if (clusterConfigBuilder_ != null) {
        clusterConfigBuilder_.clear();
      }
      defaultStorageType_ = 0;
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      configCase_ = 0;
      config_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.Cluster.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster build() {
      com.google.bigtable.admin.v2.Cluster result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster buildPartial() {
      com.google.bigtable.admin.v2.Cluster result = new com.google.bigtable.admin.v2.Cluster(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.Cluster result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serveNodes_ = serveNodes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nodeScalingFactor_ = nodeScalingFactor_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.defaultStorageType_ = defaultStorageType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.admin.v2.Cluster result) {
      result.configCase_ = configCase_;
      result.config_ = this.config_;
      if (configCase_ == 7 && clusterConfigBuilder_ != null) {
        result.config_ = clusterConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.Cluster) {
        return mergeFrom((com.google.bigtable.admin.v2.Cluster) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.Cluster other) {
      if (other == com.google.bigtable.admin.v2.Cluster.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getServeNodes() != 0) {
        setServeNodes(other.getServeNodes());
      }
      if (other.nodeScalingFactor_ != 0) {
        setNodeScalingFactorValue(other.getNodeScalingFactorValue());
      }
      if (other.defaultStorageType_ != 0) {
        setDefaultStorageTypeValue(other.getDefaultStorageTypeValue());
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      switch (other.getConfigCase()) {
        case CLUSTER_CONFIG:
          {
            mergeClusterConfig(other.getClusterConfig());
            break;
          }
        case CONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                serveNodes_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                defaultStorageType_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                configCase_ = 7;
                break;
              } // case 58
            case 72:
              {
                nodeScalingFactor_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int configCase_ = 0;
    private java.lang.Object config_;

    public ConfigCase getConfigCase() {
      return ConfigCase.forNumber(configCase_);
    }

    public Builder clearConfig() {
      configCase_ = 0;
      config_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The unique name of the cluster. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique name of the cluster. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique name of the cluster. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique name of the cluster. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique name of the cluster. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The location where this cluster's nodes and storage reside. For
     * best performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/{project}/locations/{zone}`.
     * </pre>
     *
     * <code>
     * string location = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The location where this cluster's nodes and storage reside. For
     * best performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/{project}/locations/{zone}`.
     * </pre>
     *
     * <code>
     * string location = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The location where this cluster's nodes and storage reside. For
     * best performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/{project}/locations/{zone}`.
     * </pre>
     *
     * <code>
     * string location = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The location where this cluster's nodes and storage reside. For
     * best performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/{project}/locations/{zone}`.
     * </pre>
     *
     * <code>
     * string location = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The location where this cluster's nodes and storage reside. For
     * best performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/{project}/locations/{zone}`.
     * </pre>
     *
     * <code>
     * string location = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The current state of the cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.State getState() {
      com.google.bigtable.admin.v2.Cluster.State result =
          com.google.bigtable.admin.v2.Cluster.State.forNumber(state_);
      return result == null ? com.google.bigtable.admin.v2.Cluster.State.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.bigtable.admin.v2.Cluster.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private int serveNodes_;

    /**
     *
     *
     * <pre>
     * The number of nodes in the cluster. If no value is set,
     * Cloud Bigtable automatically allocates nodes based on your data footprint
     * and optimized for 50% storage utilization.
     * </pre>
     *
     * <code>int32 serve_nodes = 4;</code>
     *
     * @return The serveNodes.
     */
    @java.lang.Override
    public int getServeNodes() {
      return serveNodes_;
    }

    /**
     *
     *
     * <pre>
     * The number of nodes in the cluster. If no value is set,
     * Cloud Bigtable automatically allocates nodes based on your data footprint
     * and optimized for 50% storage utilization.
     * </pre>
     *
     * <code>int32 serve_nodes = 4;</code>
     *
     * @param value The serveNodes to set.
     * @return This builder for chaining.
     */
    public Builder setServeNodes(int value) {

      serveNodes_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of nodes in the cluster. If no value is set,
     * Cloud Bigtable automatically allocates nodes based on your data footprint
     * and optimized for 50% storage utilization.
     * </pre>
     *
     * <code>int32 serve_nodes = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServeNodes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      serveNodes_ = 0;
      onChanged();
      return this;
    }

    private int nodeScalingFactor_ = 0;

    /**
     *
     *
     * <pre>
     * Immutable. The node scaling factor of this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.NodeScalingFactor node_scaling_factor = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for nodeScalingFactor.
     */
    @java.lang.Override
    public int getNodeScalingFactorValue() {
      return nodeScalingFactor_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The node scaling factor of this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.NodeScalingFactor node_scaling_factor = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for nodeScalingFactor to set.
     * @return This builder for chaining.
     */
    public Builder setNodeScalingFactorValue(int value) {
      nodeScalingFactor_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The node scaling factor of this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.NodeScalingFactor node_scaling_factor = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The nodeScalingFactor.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.NodeScalingFactor getNodeScalingFactor() {
      com.google.bigtable.admin.v2.Cluster.NodeScalingFactor result =
          com.google.bigtable.admin.v2.Cluster.NodeScalingFactor.forNumber(nodeScalingFactor_);
      return result == null
          ? com.google.bigtable.admin.v2.Cluster.NodeScalingFactor.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The node scaling factor of this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.NodeScalingFactor node_scaling_factor = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The nodeScalingFactor to set.
     * @return This builder for chaining.
     */
    public Builder setNodeScalingFactor(
        com.google.bigtable.admin.v2.Cluster.NodeScalingFactor value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      nodeScalingFactor_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The node scaling factor of this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.NodeScalingFactor node_scaling_factor = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeScalingFactor() {
      bitField0_ = (bitField0_ & ~0x00000010);
      nodeScalingFactor_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Cluster.ClusterConfig,
            com.google.bigtable.admin.v2.Cluster.ClusterConfig.Builder,
            com.google.bigtable.admin.v2.Cluster.ClusterConfigOrBuilder>
        clusterConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     *
     * @return Whether the clusterConfig field is set.
     */
    @java.lang.Override
    public boolean hasClusterConfig() {
      return configCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     *
     * @return The clusterConfig.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.ClusterConfig getClusterConfig() {
      if (clusterConfigBuilder_ == null) {
        if (configCase_ == 7) {
          return (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_;
        }
        return com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance();
      } else {
        if (configCase_ == 7) {
          return clusterConfigBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     */
    public Builder setClusterConfig(com.google.bigtable.admin.v2.Cluster.ClusterConfig value) {
      if (clusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        clusterConfigBuilder_.setMessage(value);
      }
      configCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     */
    public Builder setClusterConfig(
        com.google.bigtable.admin.v2.Cluster.ClusterConfig.Builder builderForValue) {
      if (clusterConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        clusterConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     */
    public Builder mergeClusterConfig(com.google.bigtable.admin.v2.Cluster.ClusterConfig value) {
      if (clusterConfigBuilder_ == null) {
        if (configCase_ == 7
            && config_ != com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance()) {
          config_ =
              com.google.bigtable.admin.v2.Cluster.ClusterConfig.newBuilder(
                      (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 7) {
          clusterConfigBuilder_.mergeFrom(value);
        } else {
          clusterConfigBuilder_.setMessage(value);
        }
      }
      configCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     */
    public Builder clearClusterConfig() {
      if (clusterConfigBuilder_ == null) {
        if (configCase_ == 7) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 7) {
          configCase_ = 0;
          config_ = null;
        }
        clusterConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     */
    public com.google.bigtable.admin.v2.Cluster.ClusterConfig.Builder getClusterConfigBuilder() {
      return getClusterConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster.ClusterConfigOrBuilder getClusterConfigOrBuilder() {
      if ((configCase_ == 7) && (clusterConfigBuilder_ != null)) {
        return clusterConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 7) {
          return (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_;
        }
        return com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration for this cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.ClusterConfig cluster_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Cluster.ClusterConfig,
            com.google.bigtable.admin.v2.Cluster.ClusterConfig.Builder,
            com.google.bigtable.admin.v2.Cluster.ClusterConfigOrBuilder>
        getClusterConfigFieldBuilder() {
      if (clusterConfigBuilder_ == null) {
        if (!(configCase_ == 7)) {
          config_ = com.google.bigtable.admin.v2.Cluster.ClusterConfig.getDefaultInstance();
        }
        clusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Cluster.ClusterConfig,
                com.google.bigtable.admin.v2.Cluster.ClusterConfig.Builder,
                com.google.bigtable.admin.v2.Cluster.ClusterConfigOrBuilder>(
                (com.google.bigtable.admin.v2.Cluster.ClusterConfig) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 7;
      onChanged();
      return clusterConfigBuilder_;
    }

    private int defaultStorageType_ = 0;

    /**
     *
     *
     * <pre>
     * Immutable. The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.StorageType default_storage_type = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for defaultStorageType.
     */
    @java.lang.Override
    public int getDefaultStorageTypeValue() {
      return defaultStorageType_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.StorageType default_storage_type = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for defaultStorageType to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultStorageTypeValue(int value) {
      defaultStorageType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.StorageType default_storage_type = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The defaultStorageType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.StorageType getDefaultStorageType() {
      com.google.bigtable.admin.v2.StorageType result =
          com.google.bigtable.admin.v2.StorageType.forNumber(defaultStorageType_);
      return result == null ? com.google.bigtable.admin.v2.StorageType.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.StorageType default_storage_type = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The defaultStorageType to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultStorageType(com.google.bigtable.admin.v2.StorageType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      defaultStorageType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.StorageType default_storage_type = 5 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultStorageType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      defaultStorageType_ = 0;
      onChanged();
      return this;
    }

    private com.google.bigtable.admin.v2.Cluster.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Cluster.EncryptionConfig,
            com.google.bigtable.admin.v2.Cluster.EncryptionConfig.Builder,
            com.google.bigtable.admin.v2.Cluster.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.bigtable.admin.v2.Cluster.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.bigtable.admin.v2.Cluster.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.bigtable.admin.v2.Cluster.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.bigtable.admin.v2.Cluster.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.bigtable.admin.v2.Cluster.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.bigtable.admin.v2.Cluster.EncryptionConfig.getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.bigtable.admin.v2.Cluster.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.bigtable.admin.v2.Cluster.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.bigtable.admin.v2.Cluster.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The encryption configuration for CMEK-protected clusters.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Cluster.EncryptionConfig encryption_config = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Cluster.EncryptionConfig,
            com.google.bigtable.admin.v2.Cluster.EncryptionConfig.Builder,
            com.google.bigtable.admin.v2.Cluster.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Cluster.EncryptionConfig,
                com.google.bigtable.admin.v2.Cluster.EncryptionConfig.Builder,
                com.google.bigtable.admin.v2.Cluster.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Cluster)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Cluster)
  private static final com.google.bigtable.admin.v2.Cluster DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Cluster();
  }

  public static com.google.bigtable.admin.v2.Cluster getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cluster> PARSER =
      new com.google.protobuf.AbstractParser<Cluster>() {
        @java.lang.Override
        public Cluster parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Cluster> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cluster> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
