/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * Request message for
 * [google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable][google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable]
 *
 * Note: This is a private alpha release of Cloud Bigtable snapshots. This
 * feature is not currently available to most Cloud Bigtable customers. This
 * feature might be changed in backward-incompatible ways and is not recommended
 * for production use. It is not subject to any SLA or deprecation policy.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.SnapshotTableRequest}
 */
public final class SnapshotTableRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.SnapshotTableRequest)
    SnapshotTableRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SnapshotTableRequest.newBuilder() to construct.
  private SnapshotTableRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SnapshotTableRequest() {
    name_ = "";
    cluster_ = "";
    snapshotId_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SnapshotTableRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_SnapshotTableRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_SnapshotTableRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.SnapshotTableRequest.class,
            com.google.bigtable.admin.v2.SnapshotTableRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to have the snapshot taken.
   * Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to have the snapshot taken.
   * Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cluster_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the cluster where the snapshot will be created in.
   * Values are of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>
   * string cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The cluster.
   */
  @java.lang.Override
  public java.lang.String getCluster() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cluster_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the cluster where the snapshot will be created in.
   * Values are of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>
   * string cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for cluster.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClusterBytes() {
    java.lang.Object ref = cluster_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cluster_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SNAPSHOT_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object snapshotId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The ID by which the new snapshot should be referred to within the
   * parent cluster, e.g., `mysnapshot` of the form:
   * `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
   * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
   * </pre>
   *
   * <code>string snapshot_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The snapshotId.
   */
  @java.lang.Override
  public java.lang.String getSnapshotId() {
    java.lang.Object ref = snapshotId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      snapshotId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The ID by which the new snapshot should be referred to within the
   * parent cluster, e.g., `mysnapshot` of the form:
   * `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
   * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
   * </pre>
   *
   * <code>string snapshot_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for snapshotId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSnapshotIdBytes() {
    java.lang.Object ref = snapshotId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      snapshotId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TTL_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration ttl_;

  /**
   *
   *
   * <pre>
   * The amount of time that the new snapshot can stay active after it is
   * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
   * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
   * specified, the default value of 24 hours will be used.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 4;</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The amount of time that the new snapshot can stay active after it is
   * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
   * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
   * specified, the default value of 24 hours will be used.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 4;</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }

  /**
   *
   *
   * <pre>
   * The amount of time that the new snapshot can stay active after it is
   * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
   * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
   * specified, the default value of 24 hours will be used.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Description of the snapshot.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Description of the snapshot.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, cluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snapshotId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, snapshotId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cluster_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, cluster_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snapshotId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, snapshotId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.SnapshotTableRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.SnapshotTableRequest other =
        (com.google.bigtable.admin.v2.SnapshotTableRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCluster().equals(other.getCluster())) return false;
    if (!getSnapshotId().equals(other.getSnapshotId())) return false;
    if (hasTtl() != other.hasTtl()) return false;
    if (hasTtl()) {
      if (!getTtl().equals(other.getTtl())) return false;
    }
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CLUSTER_FIELD_NUMBER;
    hash = (53 * hash) + getCluster().hashCode();
    hash = (37 * hash) + SNAPSHOT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSnapshotId().hashCode();
    if (hasTtl()) {
      hash = (37 * hash) + TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTtl().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.SnapshotTableRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable][google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable]
   *
   * Note: This is a private alpha release of Cloud Bigtable snapshots. This
   * feature is not currently available to most Cloud Bigtable customers. This
   * feature might be changed in backward-incompatible ways and is not recommended
   * for production use. It is not subject to any SLA or deprecation policy.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.SnapshotTableRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.SnapshotTableRequest)
      com.google.bigtable.admin.v2.SnapshotTableRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_SnapshotTableRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_SnapshotTableRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.SnapshotTableRequest.class,
              com.google.bigtable.admin.v2.SnapshotTableRequest.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.SnapshotTableRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTtlFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      cluster_ = "";
      snapshotId_ = "";
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      description_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_SnapshotTableRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.SnapshotTableRequest getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.SnapshotTableRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.SnapshotTableRequest build() {
      com.google.bigtable.admin.v2.SnapshotTableRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.SnapshotTableRequest buildPartial() {
      com.google.bigtable.admin.v2.SnapshotTableRequest result =
          new com.google.bigtable.admin.v2.SnapshotTableRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.SnapshotTableRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cluster_ = cluster_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.snapshotId_ = snapshotId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ttl_ = ttlBuilder_ == null ? ttl_ : ttlBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.SnapshotTableRequest) {
        return mergeFrom((com.google.bigtable.admin.v2.SnapshotTableRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.SnapshotTableRequest other) {
      if (other == com.google.bigtable.admin.v2.SnapshotTableRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCluster().isEmpty()) {
        cluster_ = other.cluster_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSnapshotId().isEmpty()) {
        snapshotId_ = other.snapshotId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasTtl()) {
        mergeTtl(other.getTtl());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                cluster_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                snapshotId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to have the snapshot taken.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to have the snapshot taken.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to have the snapshot taken.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to have the snapshot taken.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to have the snapshot taken.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object cluster_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the cluster where the snapshot will be created in.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>
     * string cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The cluster.
     */
    public java.lang.String getCluster() {
      java.lang.Object ref = cluster_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cluster_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the cluster where the snapshot will be created in.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>
     * string cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for cluster.
     */
    public com.google.protobuf.ByteString getClusterBytes() {
      java.lang.Object ref = cluster_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cluster_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the cluster where the snapshot will be created in.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>
     * string cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The cluster to set.
     * @return This builder for chaining.
     */
    public Builder setCluster(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cluster_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the cluster where the snapshot will be created in.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>
     * string cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCluster() {
      cluster_ = getDefaultInstance().getCluster();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the cluster where the snapshot will be created in.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>
     * string cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for cluster to set.
     * @return This builder for chaining.
     */
    public Builder setClusterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cluster_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object snapshotId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The ID by which the new snapshot should be referred to within the
     * parent cluster, e.g., `mysnapshot` of the form:
     * `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
     * </pre>
     *
     * <code>string snapshot_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The snapshotId.
     */
    public java.lang.String getSnapshotId() {
      java.lang.Object ref = snapshotId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        snapshotId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID by which the new snapshot should be referred to within the
     * parent cluster, e.g., `mysnapshot` of the form:
     * `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
     * </pre>
     *
     * <code>string snapshot_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for snapshotId.
     */
    public com.google.protobuf.ByteString getSnapshotIdBytes() {
      java.lang.Object ref = snapshotId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        snapshotId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID by which the new snapshot should be referred to within the
     * parent cluster, e.g., `mysnapshot` of the form:
     * `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
     * </pre>
     *
     * <code>string snapshot_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The snapshotId to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      snapshotId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID by which the new snapshot should be referred to within the
     * parent cluster, e.g., `mysnapshot` of the form:
     * `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
     * </pre>
     *
     * <code>string snapshot_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSnapshotId() {
      snapshotId_ = getDefaultInstance().getSnapshotId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID by which the new snapshot should be referred to within the
     * parent cluster, e.g., `mysnapshot` of the form:
     * `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
     * </pre>
     *
     * <code>string snapshot_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for snapshotId to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      snapshotId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration ttl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     *
     * @return Whether the ttl field is set.
     */
    public boolean hasTtl() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     *
     * @return The ttl.
     */
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      } else {
        return ttlBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ttl_ = value;
      } else {
        ttlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        ttl_ = builderForValue.build();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ttl_ != null
            && ttl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTtlBuilder().mergeFrom(value);
        } else {
          ttl_ = value;
        }
      } else {
        ttlBuilder_.mergeFrom(value);
      }
      if (ttl_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     */
    public Builder clearTtl() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTtlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if (ttlBuilder_ != null) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      }
    }

    /**
     *
     *
     * <pre>
     * The amount of time that the new snapshot can stay active after it is
     * created. Once 'ttl' expires, the snapshot will get deleted. The maximum
     * amount of time a snapshot can stay active is 7 days. If 'ttl' is not
     * specified, the default value of 24 hours will be used.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(getTtl(), getParentForChildren(), isClean());
        ttl_ = null;
      }
      return ttlBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Description of the snapshot.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description of the snapshot.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description of the snapshot.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description of the snapshot.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description of the snapshot.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.SnapshotTableRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.SnapshotTableRequest)
  private static final com.google.bigtable.admin.v2.SnapshotTableRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.SnapshotTableRequest();
  }

  public static com.google.bigtable.admin.v2.SnapshotTableRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SnapshotTableRequest> PARSER =
      new com.google.protobuf.AbstractParser<SnapshotTableRequest>() {
        @java.lang.Override
        public SnapshotTableRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SnapshotTableRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SnapshotTableRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.SnapshotTableRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
