/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Request message for Bigtable.PrepareQuery
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.PrepareQueryRequest}
 */
public final class PrepareQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.PrepareQueryRequest)
    PrepareQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PrepareQueryRequest.newBuilder() to construct.
  private PrepareQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PrepareQueryRequest() {
    instanceName_ = "";
    appProfileId_ = "";
    query_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PrepareQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_PrepareQueryRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetParamTypes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_PrepareQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.PrepareQueryRequest.class,
            com.google.bigtable.v2.PrepareQueryRequest.Builder.class);
  }

  private int dataFormatCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dataFormat_;

  public enum DataFormatCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROTO_FORMAT(4),
    DATAFORMAT_NOT_SET(0);
    private final int value;

    private DataFormatCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataFormatCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataFormatCase forNumber(int value) {
      switch (value) {
        case 4:
          return PROTO_FORMAT;
        case 0:
          return DATAFORMAT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataFormatCase getDataFormatCase() {
    return DataFormatCase.forNumber(dataFormatCase_);
  }

  public static final int INSTANCE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The unique name of the instance against which the query should be
   * executed.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`
   * </pre>
   *
   * <code>
   * string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The instanceName.
   */
  @java.lang.Override
  public java.lang.String getInstanceName() {
    java.lang.Object ref = instanceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The unique name of the instance against which the query should be
   * executed.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`
   * </pre>
   *
   * <code>
   * string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for instanceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceNameBytes() {
    java.lang.Object ref = instanceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object appProfileId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. This value specifies routing for preparing the query. Note that
   * this `app_profile_id` is only used for preparing the query. The actual
   * query execution will use the app profile specified in the
   * `ExecuteQueryRequest`. If not specified, the `default` application profile
   * will be used.
   * </pre>
   *
   * <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. This value specifies routing for preparing the query. Note that
   * this `app_profile_id` is only used for preparing the query. The actual
   * query execution will use the app profile specified in the
   * `ExecuteQueryRequest`. If not specified, the `default` application profile
   * will be used.
   * </pre>
   *
   * <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";

  /**
   *
   *
   * <pre>
   * Required. The query string.
   * </pre>
   *
   * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The query string.
   * </pre>
   *
   * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROTO_FORMAT_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Protocol buffer format as described by ProtoSchema and ProtoRows
   * messages.
   * </pre>
   *
   * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
   *
   * @return Whether the protoFormat field is set.
   */
  @java.lang.Override
  public boolean hasProtoFormat() {
    return dataFormatCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Protocol buffer format as described by ProtoSchema and ProtoRows
   * messages.
   * </pre>
   *
   * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
   *
   * @return The protoFormat.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ProtoFormat getProtoFormat() {
    if (dataFormatCase_ == 4) {
      return (com.google.bigtable.v2.ProtoFormat) dataFormat_;
    }
    return com.google.bigtable.v2.ProtoFormat.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Protocol buffer format as described by ProtoSchema and ProtoRows
   * messages.
   * </pre>
   *
   * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ProtoFormatOrBuilder getProtoFormatOrBuilder() {
    if (dataFormatCase_ == 4) {
      return (com.google.bigtable.v2.ProtoFormat) dataFormat_;
    }
    return com.google.bigtable.v2.ProtoFormat.getDefaultInstance();
  }

  public static final int PARAM_TYPES_FIELD_NUMBER = 6;

  private static final class ParamTypesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.bigtable.v2.Type>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.bigtable.v2.Type>newDefaultInstance(
                    com.google.bigtable.v2.BigtableProto
                        .internal_static_google_bigtable_v2_PrepareQueryRequest_ParamTypesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.bigtable.v2.Type.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.v2.Type> paramTypes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.v2.Type>
      internalGetParamTypes() {
    if (paramTypes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamTypesDefaultEntryHolder.defaultEntry);
    }
    return paramTypes_;
  }

  public int getParamTypesCount() {
    return internalGetParamTypes().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Required. `param_types` is a map of parameter identifier strings to their
   * `Type`s.
   *
   * In query string, a parameter placeholder consists of the
   * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
   * the query string.
   *
   * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
   * query parameter of type Bytes. The specific `Value` to be used for the
   * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public boolean containsParamTypes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParamTypes().getMap().containsKey(key);
  }

  /** Use {@link #getParamTypesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.bigtable.v2.Type> getParamTypes() {
    return getParamTypesMap();
  }

  /**
   *
   *
   * <pre>
   * Required. `param_types` is a map of parameter identifier strings to their
   * `Type`s.
   *
   * In query string, a parameter placeholder consists of the
   * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
   * the query string.
   *
   * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
   * query parameter of type Bytes. The specific `Value` to be used for the
   * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.bigtable.v2.Type> getParamTypesMap() {
    return internalGetParamTypes().getMap();
  }

  /**
   *
   *
   * <pre>
   * Required. `param_types` is a map of parameter identifier strings to their
   * `Type`s.
   *
   * In query string, a parameter placeholder consists of the
   * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
   * the query string.
   *
   * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
   * query parameter of type Bytes. The specific `Value` to be used for the
   * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.bigtable.v2.Type getParamTypesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.bigtable.v2.Type defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.v2.Type> map =
        internalGetParamTypes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Required. `param_types` is a map of parameter identifier strings to their
   * `Type`s.
   *
   * In query string, a parameter placeholder consists of the
   * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
   * the query string.
   *
   * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
   * query parameter of type Bytes. The specific `Value` to be used for the
   * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Type getParamTypesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.v2.Type> map =
        internalGetParamTypes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, appProfileId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, query_);
    }
    if (dataFormatCase_ == 4) {
      output.writeMessage(4, (com.google.bigtable.v2.ProtoFormat) dataFormat_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParamTypes(), ParamTypesDefaultEntryHolder.defaultEntry, 6);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, appProfileId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, query_);
    }
    if (dataFormatCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.bigtable.v2.ProtoFormat) dataFormat_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.bigtable.v2.Type> entry :
        internalGetParamTypes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.bigtable.v2.Type> paramTypes__ =
          ParamTypesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, paramTypes__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.PrepareQueryRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.PrepareQueryRequest other =
        (com.google.bigtable.v2.PrepareQueryRequest) obj;

    if (!getInstanceName().equals(other.getInstanceName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!internalGetParamTypes().equals(other.internalGetParamTypes())) return false;
    if (!getDataFormatCase().equals(other.getDataFormatCase())) return false;
    switch (dataFormatCase_) {
      case 4:
        if (!getProtoFormat().equals(other.getProtoFormat())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    if (!internalGetParamTypes().getMap().isEmpty()) {
      hash = (37 * hash) + PARAM_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParamTypes().hashCode();
    }
    switch (dataFormatCase_) {
      case 4:
        hash = (37 * hash) + PROTO_FORMAT_FIELD_NUMBER;
        hash = (53 * hash) + getProtoFormat().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.PrepareQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.PrepareQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for Bigtable.PrepareQuery
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.PrepareQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.PrepareQueryRequest)
      com.google.bigtable.v2.PrepareQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_PrepareQueryRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableParamTypes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_PrepareQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.PrepareQueryRequest.class,
              com.google.bigtable.v2.PrepareQueryRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.PrepareQueryRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instanceName_ = "";
      appProfileId_ = "";
      query_ = "";
      if (protoFormatBuilder_ != null) {
        protoFormatBuilder_.clear();
      }
      internalGetMutableParamTypes().clear();
      dataFormatCase_ = 0;
      dataFormat_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_PrepareQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.PrepareQueryRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.PrepareQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.PrepareQueryRequest build() {
      com.google.bigtable.v2.PrepareQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.PrepareQueryRequest buildPartial() {
      com.google.bigtable.v2.PrepareQueryRequest result =
          new com.google.bigtable.v2.PrepareQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.PrepareQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instanceName_ = instanceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.appProfileId_ = appProfileId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.paramTypes_ =
            internalGetParamTypes().build(ParamTypesDefaultEntryHolder.defaultEntry);
      }
    }

    private void buildPartialOneofs(com.google.bigtable.v2.PrepareQueryRequest result) {
      result.dataFormatCase_ = dataFormatCase_;
      result.dataFormat_ = this.dataFormat_;
      if (dataFormatCase_ == 4 && protoFormatBuilder_ != null) {
        result.dataFormat_ = protoFormatBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.PrepareQueryRequest) {
        return mergeFrom((com.google.bigtable.v2.PrepareQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.PrepareQueryRequest other) {
      if (other == com.google.bigtable.v2.PrepareQueryRequest.getDefaultInstance()) return this;
      if (!other.getInstanceName().isEmpty()) {
        instanceName_ = other.instanceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableParamTypes().mergeFrom(other.internalGetParamTypes());
      bitField0_ |= 0x00000010;
      switch (other.getDataFormatCase()) {
        case PROTO_FORMAT:
          {
            mergeProtoFormat(other.getProtoFormat());
            break;
          }
        case DATAFORMAT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                instanceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                appProfileId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getProtoFormatFieldBuilder().getBuilder(), extensionRegistry);
                dataFormatCase_ = 4;
                break;
              } // case 34
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.bigtable.v2.Type>
                    paramTypes__ =
                        input.readMessage(
                            ParamTypesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableParamTypes()
                    .ensureBuilderMap()
                    .put(paramTypes__.getKey(), paramTypes__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataFormatCase_ = 0;
    private java.lang.Object dataFormat_;

    public DataFormatCase getDataFormatCase() {
      return DataFormatCase.forNumber(dataFormatCase_);
    }

    public Builder clearDataFormat() {
      dataFormatCase_ = 0;
      dataFormat_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object instanceName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`
     * </pre>
     *
     * <code>
     * string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The instanceName.
     */
    public java.lang.String getInstanceName() {
      java.lang.Object ref = instanceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`
     * </pre>
     *
     * <code>
     * string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for instanceName.
     */
    public com.google.protobuf.ByteString getInstanceNameBytes() {
      java.lang.Object ref = instanceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`
     * </pre>
     *
     * <code>
     * string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The instanceName to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`
     * </pre>
     *
     * <code>
     * string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceName() {
      instanceName_ = getDefaultInstance().getInstanceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`
     * </pre>
     *
     * <code>
     * string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for instanceName to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     * </pre>
     *
     * <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     * </pre>
     *
     * <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     * </pre>
     *
     * <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      appProfileId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     * </pre>
     *
     * <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {
      appProfileId_ = getDefaultInstance().getAppProfileId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     * </pre>
     *
     * <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      appProfileId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";

    /**
     *
     *
     * <pre>
     * Required. The query string.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The query string.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The query string.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The query string.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The query string.
     * </pre>
     *
     * <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ProtoFormat,
            com.google.bigtable.v2.ProtoFormat.Builder,
            com.google.bigtable.v2.ProtoFormatOrBuilder>
        protoFormatBuilder_;

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     *
     * @return Whether the protoFormat field is set.
     */
    @java.lang.Override
    public boolean hasProtoFormat() {
      return dataFormatCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     *
     * @return The protoFormat.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ProtoFormat getProtoFormat() {
      if (protoFormatBuilder_ == null) {
        if (dataFormatCase_ == 4) {
          return (com.google.bigtable.v2.ProtoFormat) dataFormat_;
        }
        return com.google.bigtable.v2.ProtoFormat.getDefaultInstance();
      } else {
        if (dataFormatCase_ == 4) {
          return protoFormatBuilder_.getMessage();
        }
        return com.google.bigtable.v2.ProtoFormat.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     */
    public Builder setProtoFormat(com.google.bigtable.v2.ProtoFormat value) {
      if (protoFormatBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataFormat_ = value;
        onChanged();
      } else {
        protoFormatBuilder_.setMessage(value);
      }
      dataFormatCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     */
    public Builder setProtoFormat(com.google.bigtable.v2.ProtoFormat.Builder builderForValue) {
      if (protoFormatBuilder_ == null) {
        dataFormat_ = builderForValue.build();
        onChanged();
      } else {
        protoFormatBuilder_.setMessage(builderForValue.build());
      }
      dataFormatCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     */
    public Builder mergeProtoFormat(com.google.bigtable.v2.ProtoFormat value) {
      if (protoFormatBuilder_ == null) {
        if (dataFormatCase_ == 4
            && dataFormat_ != com.google.bigtable.v2.ProtoFormat.getDefaultInstance()) {
          dataFormat_ =
              com.google.bigtable.v2.ProtoFormat.newBuilder(
                      (com.google.bigtable.v2.ProtoFormat) dataFormat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataFormat_ = value;
        }
        onChanged();
      } else {
        if (dataFormatCase_ == 4) {
          protoFormatBuilder_.mergeFrom(value);
        } else {
          protoFormatBuilder_.setMessage(value);
        }
      }
      dataFormatCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     */
    public Builder clearProtoFormat() {
      if (protoFormatBuilder_ == null) {
        if (dataFormatCase_ == 4) {
          dataFormatCase_ = 0;
          dataFormat_ = null;
          onChanged();
        }
      } else {
        if (dataFormatCase_ == 4) {
          dataFormatCase_ = 0;
          dataFormat_ = null;
        }
        protoFormatBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     */
    public com.google.bigtable.v2.ProtoFormat.Builder getProtoFormatBuilder() {
      return getProtoFormatFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ProtoFormatOrBuilder getProtoFormatOrBuilder() {
      if ((dataFormatCase_ == 4) && (protoFormatBuilder_ != null)) {
        return protoFormatBuilder_.getMessageOrBuilder();
      } else {
        if (dataFormatCase_ == 4) {
          return (com.google.bigtable.v2.ProtoFormat) dataFormat_;
        }
        return com.google.bigtable.v2.ProtoFormat.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ProtoFormat,
            com.google.bigtable.v2.ProtoFormat.Builder,
            com.google.bigtable.v2.ProtoFormatOrBuilder>
        getProtoFormatFieldBuilder() {
      if (protoFormatBuilder_ == null) {
        if (!(dataFormatCase_ == 4)) {
          dataFormat_ = com.google.bigtable.v2.ProtoFormat.getDefaultInstance();
        }
        protoFormatBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.ProtoFormat,
                com.google.bigtable.v2.ProtoFormat.Builder,
                com.google.bigtable.v2.ProtoFormatOrBuilder>(
                (com.google.bigtable.v2.ProtoFormat) dataFormat_,
                getParentForChildren(),
                isClean());
        dataFormat_ = null;
      }
      dataFormatCase_ = 4;
      onChanged();
      return protoFormatBuilder_;
    }

    private static final class ParamTypesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.bigtable.v2.TypeOrBuilder, com.google.bigtable.v2.Type> {
      @java.lang.Override
      public com.google.bigtable.v2.Type build(com.google.bigtable.v2.TypeOrBuilder val) {
        if (val instanceof com.google.bigtable.v2.Type) {
          return (com.google.bigtable.v2.Type) val;
        }
        return ((com.google.bigtable.v2.Type.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.bigtable.v2.Type>
          defaultEntry() {
        return ParamTypesDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final ParamTypesConverter paramTypesConverter = new ParamTypesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.bigtable.v2.TypeOrBuilder,
            com.google.bigtable.v2.Type,
            com.google.bigtable.v2.Type.Builder>
        paramTypes_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.bigtable.v2.TypeOrBuilder,
            com.google.bigtable.v2.Type,
            com.google.bigtable.v2.Type.Builder>
        internalGetParamTypes() {
      if (paramTypes_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(paramTypesConverter);
      }
      return paramTypes_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.bigtable.v2.TypeOrBuilder,
            com.google.bigtable.v2.Type,
            com.google.bigtable.v2.Type.Builder>
        internalGetMutableParamTypes() {
      if (paramTypes_ == null) {
        paramTypes_ = new com.google.protobuf.MapFieldBuilder<>(paramTypesConverter);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return paramTypes_;
    }

    public int getParamTypesCount() {
      return internalGetParamTypes().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public boolean containsParamTypes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParamTypes().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getParamTypesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.v2.Type> getParamTypes() {
      return getParamTypesMap();
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.bigtable.v2.Type> getParamTypesMap() {
      return internalGetParamTypes().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.bigtable.v2.Type getParamTypesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.bigtable.v2.Type defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.v2.TypeOrBuilder> map =
          internalGetMutableParamTypes().ensureBuilderMap();
      return map.containsKey(key) ? paramTypesConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Type getParamTypesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.v2.TypeOrBuilder> map =
          internalGetMutableParamTypes().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return paramTypesConverter.build(map.get(key));
    }

    public Builder clearParamTypes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableParamTypes().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeParamTypes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParamTypes().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.v2.Type> getMutableParamTypes() {
      bitField0_ |= 0x00000010;
      return internalGetMutableParamTypes().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putParamTypes(java.lang.String key, com.google.bigtable.v2.Type value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParamTypes().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putAllParamTypes(
        java.util.Map<java.lang.String, com.google.bigtable.v2.Type> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.bigtable.v2.Type> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableParamTypes().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     *
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     *
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.v2.Type&gt; param_types = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.Type.Builder putParamTypesBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.bigtable.v2.TypeOrBuilder> builderMap =
          internalGetMutableParamTypes().ensureBuilderMap();
      com.google.bigtable.v2.TypeOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.bigtable.v2.Type.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.bigtable.v2.Type) {
        entry = ((com.google.bigtable.v2.Type) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.bigtable.v2.Type.Builder) entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.PrepareQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.PrepareQueryRequest)
  private static final com.google.bigtable.v2.PrepareQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.PrepareQueryRequest();
  }

  public static com.google.bigtable.v2.PrepareQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrepareQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<PrepareQueryRequest>() {
        @java.lang.Override
        public PrepareQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PrepareQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrepareQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.PrepareQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
