/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/table.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * AuthorizedViews represent subsets of a particular Cloud Bigtable table. Users
 * can configure access to each Authorized View independently from the table and
 * use the existing Data APIs to access the subset of data.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.AuthorizedView}
 */
public final class AuthorizedView extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AuthorizedView)
    AuthorizedViewOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AuthorizedView.newBuilder() to construct.
  private AuthorizedView(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuthorizedView() {
    name_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuthorizedView();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_AuthorizedView_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_AuthorizedView_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.AuthorizedView.class,
            com.google.bigtable.admin.v2.AuthorizedView.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines a subset of an AuthorizedView's fields.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.AuthorizedView.ResponseView}
   */
  public enum ResponseView implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Uses the default view for each method as documented in the request.
     * </pre>
     *
     * <code>RESPONSE_VIEW_UNSPECIFIED = 0;</code>
     */
    RESPONSE_VIEW_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Only populates `name`.
     * </pre>
     *
     * <code>NAME_ONLY = 1;</code>
     */
    NAME_ONLY(1),
    /**
     *
     *
     * <pre>
     * Only populates the AuthorizedView's basic metadata. This includes:
     * name, deletion_protection, etag.
     * </pre>
     *
     * <code>BASIC = 2;</code>
     */
    BASIC(2),
    /**
     *
     *
     * <pre>
     * Populates every fields.
     * </pre>
     *
     * <code>FULL = 3;</code>
     */
    FULL(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Uses the default view for each method as documented in the request.
     * </pre>
     *
     * <code>RESPONSE_VIEW_UNSPECIFIED = 0;</code>
     */
    public static final int RESPONSE_VIEW_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Only populates `name`.
     * </pre>
     *
     * <code>NAME_ONLY = 1;</code>
     */
    public static final int NAME_ONLY_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Only populates the AuthorizedView's basic metadata. This includes:
     * name, deletion_protection, etag.
     * </pre>
     *
     * <code>BASIC = 2;</code>
     */
    public static final int BASIC_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Populates every fields.
     * </pre>
     *
     * <code>FULL = 3;</code>
     */
    public static final int FULL_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseView valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResponseView forNumber(int value) {
      switch (value) {
        case 0:
          return RESPONSE_VIEW_UNSPECIFIED;
        case 1:
          return NAME_ONLY;
        case 2:
          return BASIC;
        case 3:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResponseView> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResponseView> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResponseView>() {
          public ResponseView findValueByNumber(int number) {
            return ResponseView.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.AuthorizedView.getDescriptor().getEnumTypes().get(0);
    }

    private static final ResponseView[] VALUES = values();

    public static ResponseView valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResponseView(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.AuthorizedView.ResponseView)
  }

  public interface FamilySubsetsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.AuthorizedView.FamilySubsets)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Individual exact column qualifiers to be included in the AuthorizedView.
     * </pre>
     *
     * <code>repeated bytes qualifiers = 1;</code>
     *
     * @return A list containing the qualifiers.
     */
    java.util.List<com.google.protobuf.ByteString> getQualifiersList();

    /**
     *
     *
     * <pre>
     * Individual exact column qualifiers to be included in the AuthorizedView.
     * </pre>
     *
     * <code>repeated bytes qualifiers = 1;</code>
     *
     * @return The count of qualifiers.
     */
    int getQualifiersCount();

    /**
     *
     *
     * <pre>
     * Individual exact column qualifiers to be included in the AuthorizedView.
     * </pre>
     *
     * <code>repeated bytes qualifiers = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The qualifiers at the given index.
     */
    com.google.protobuf.ByteString getQualifiers(int index);

    /**
     *
     *
     * <pre>
     * Prefixes for qualifiers to be included in the AuthorizedView. Every
     * qualifier starting with one of these prefixes is included in the
     * AuthorizedView. To provide access to all qualifiers, include the empty
     * string as a prefix
     * ("").
     * </pre>
     *
     * <code>repeated bytes qualifier_prefixes = 2;</code>
     *
     * @return A list containing the qualifierPrefixes.
     */
    java.util.List<com.google.protobuf.ByteString> getQualifierPrefixesList();

    /**
     *
     *
     * <pre>
     * Prefixes for qualifiers to be included in the AuthorizedView. Every
     * qualifier starting with one of these prefixes is included in the
     * AuthorizedView. To provide access to all qualifiers, include the empty
     * string as a prefix
     * ("").
     * </pre>
     *
     * <code>repeated bytes qualifier_prefixes = 2;</code>
     *
     * @return The count of qualifierPrefixes.
     */
    int getQualifierPrefixesCount();

    /**
     *
     *
     * <pre>
     * Prefixes for qualifiers to be included in the AuthorizedView. Every
     * qualifier starting with one of these prefixes is included in the
     * AuthorizedView. To provide access to all qualifiers, include the empty
     * string as a prefix
     * ("").
     * </pre>
     *
     * <code>repeated bytes qualifier_prefixes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The qualifierPrefixes at the given index.
     */
    com.google.protobuf.ByteString getQualifierPrefixes(int index);
  }

  /**
   *
   *
   * <pre>
   * Subsets of a column family that are included in this AuthorizedView.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AuthorizedView.FamilySubsets}
   */
  public static final class FamilySubsets extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AuthorizedView.FamilySubsets)
      FamilySubsetsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use FamilySubsets.newBuilder() to construct.
    private FamilySubsets(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FamilySubsets() {
      qualifiers_ = emptyList(com.google.protobuf.ByteString.class);
      qualifierPrefixes_ = emptyList(com.google.protobuf.ByteString.class);
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FamilySubsets();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_AuthorizedView_FamilySubsets_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_AuthorizedView_FamilySubsets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.class,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder.class);
    }

    public static final int QUALIFIERS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> qualifiers_ =
        emptyList(com.google.protobuf.ByteString.class);

    /**
     *
     *
     * <pre>
     * Individual exact column qualifiers to be included in the AuthorizedView.
     * </pre>
     *
     * <code>repeated bytes qualifiers = 1;</code>
     *
     * @return A list containing the qualifiers.
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.ByteString> getQualifiersList() {
      return qualifiers_;
    }

    /**
     *
     *
     * <pre>
     * Individual exact column qualifiers to be included in the AuthorizedView.
     * </pre>
     *
     * <code>repeated bytes qualifiers = 1;</code>
     *
     * @return The count of qualifiers.
     */
    public int getQualifiersCount() {
      return qualifiers_.size();
    }

    /**
     *
     *
     * <pre>
     * Individual exact column qualifiers to be included in the AuthorizedView.
     * </pre>
     *
     * <code>repeated bytes qualifiers = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The qualifiers at the given index.
     */
    public com.google.protobuf.ByteString getQualifiers(int index) {
      return qualifiers_.get(index);
    }

    public static final int QUALIFIER_PREFIXES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString>
        qualifierPrefixes_ = emptyList(com.google.protobuf.ByteString.class);

    /**
     *
     *
     * <pre>
     * Prefixes for qualifiers to be included in the AuthorizedView. Every
     * qualifier starting with one of these prefixes is included in the
     * AuthorizedView. To provide access to all qualifiers, include the empty
     * string as a prefix
     * ("").
     * </pre>
     *
     * <code>repeated bytes qualifier_prefixes = 2;</code>
     *
     * @return A list containing the qualifierPrefixes.
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.ByteString> getQualifierPrefixesList() {
      return qualifierPrefixes_;
    }

    /**
     *
     *
     * <pre>
     * Prefixes for qualifiers to be included in the AuthorizedView. Every
     * qualifier starting with one of these prefixes is included in the
     * AuthorizedView. To provide access to all qualifiers, include the empty
     * string as a prefix
     * ("").
     * </pre>
     *
     * <code>repeated bytes qualifier_prefixes = 2;</code>
     *
     * @return The count of qualifierPrefixes.
     */
    public int getQualifierPrefixesCount() {
      return qualifierPrefixes_.size();
    }

    /**
     *
     *
     * <pre>
     * Prefixes for qualifiers to be included in the AuthorizedView. Every
     * qualifier starting with one of these prefixes is included in the
     * AuthorizedView. To provide access to all qualifiers, include the empty
     * string as a prefix
     * ("").
     * </pre>
     *
     * <code>repeated bytes qualifier_prefixes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The qualifierPrefixes at the given index.
     */
    public com.google.protobuf.ByteString getQualifierPrefixes(int index) {
      return qualifierPrefixes_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < qualifiers_.size(); i++) {
        output.writeBytes(1, qualifiers_.get(i));
      }
      for (int i = 0; i < qualifierPrefixes_.size(); i++) {
        output.writeBytes(2, qualifierPrefixes_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < qualifiers_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(qualifiers_.get(i));
        }
        size += dataSize;
        size += 1 * getQualifiersList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < qualifierPrefixes_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(
                  qualifierPrefixes_.get(i));
        }
        size += dataSize;
        size += 1 * getQualifierPrefixesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets other =
          (com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets) obj;

      if (!getQualifiersList().equals(other.getQualifiersList())) return false;
      if (!getQualifierPrefixesList().equals(other.getQualifierPrefixesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getQualifiersCount() > 0) {
        hash = (37 * hash) + QUALIFIERS_FIELD_NUMBER;
        hash = (53 * hash) + getQualifiersList().hashCode();
      }
      if (getQualifierPrefixesCount() > 0) {
        hash = (37 * hash) + QUALIFIER_PREFIXES_FIELD_NUMBER;
        hash = (53 * hash) + getQualifierPrefixesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Subsets of a column family that are included in this AuthorizedView.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.AuthorizedView.FamilySubsets}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AuthorizedView.FamilySubsets)
        com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_AuthorizedView_FamilySubsets_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_AuthorizedView_FamilySubsets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.class,
                com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        qualifiers_ = emptyList(com.google.protobuf.ByteString.class);
        qualifierPrefixes_ = emptyList(com.google.protobuf.ByteString.class);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_AuthorizedView_FamilySubsets_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets build() {
        com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets buildPartial() {
        com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets result =
            new com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          qualifiers_.makeImmutable();
          result.qualifiers_ = qualifiers_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          qualifierPrefixes_.makeImmutable();
          result.qualifierPrefixes_ = qualifierPrefixes_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets) {
          return mergeFrom((com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets other) {
        if (other == com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.getDefaultInstance())
          return this;
        if (!other.qualifiers_.isEmpty()) {
          if (qualifiers_.isEmpty()) {
            qualifiers_ = other.qualifiers_;
            qualifiers_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensureQualifiersIsMutable();
            qualifiers_.addAll(other.qualifiers_);
          }
          onChanged();
        }
        if (!other.qualifierPrefixes_.isEmpty()) {
          if (qualifierPrefixes_.isEmpty()) {
            qualifierPrefixes_ = other.qualifierPrefixes_;
            qualifierPrefixes_.makeImmutable();
            bitField0_ |= 0x00000002;
          } else {
            ensureQualifierPrefixesIsMutable();
            qualifierPrefixes_.addAll(other.qualifierPrefixes_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.ByteString v = input.readBytes();
                  ensureQualifiersIsMutable();
                  qualifiers_.add(v);
                  break;
                } // case 10
              case 18:
                {
                  com.google.protobuf.ByteString v = input.readBytes();
                  ensureQualifierPrefixesIsMutable();
                  qualifierPrefixes_.add(v);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString>
          qualifiers_ = emptyList(com.google.protobuf.ByteString.class);

      private void ensureQualifiersIsMutable() {
        if (!qualifiers_.isModifiable()) {
          qualifiers_ = makeMutableCopy(qualifiers_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Individual exact column qualifiers to be included in the AuthorizedView.
       * </pre>
       *
       * <code>repeated bytes qualifiers = 1;</code>
       *
       * @return A list containing the qualifiers.
       */
      public java.util.List<com.google.protobuf.ByteString> getQualifiersList() {
        qualifiers_.makeImmutable();
        return qualifiers_;
      }

      /**
       *
       *
       * <pre>
       * Individual exact column qualifiers to be included in the AuthorizedView.
       * </pre>
       *
       * <code>repeated bytes qualifiers = 1;</code>
       *
       * @return The count of qualifiers.
       */
      public int getQualifiersCount() {
        return qualifiers_.size();
      }

      /**
       *
       *
       * <pre>
       * Individual exact column qualifiers to be included in the AuthorizedView.
       * </pre>
       *
       * <code>repeated bytes qualifiers = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The qualifiers at the given index.
       */
      public com.google.protobuf.ByteString getQualifiers(int index) {
        return qualifiers_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Individual exact column qualifiers to be included in the AuthorizedView.
       * </pre>
       *
       * <code>repeated bytes qualifiers = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The qualifiers to set.
       * @return This builder for chaining.
       */
      public Builder setQualifiers(int index, com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQualifiersIsMutable();
        qualifiers_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Individual exact column qualifiers to be included in the AuthorizedView.
       * </pre>
       *
       * <code>repeated bytes qualifiers = 1;</code>
       *
       * @param value The qualifiers to add.
       * @return This builder for chaining.
       */
      public Builder addQualifiers(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQualifiersIsMutable();
        qualifiers_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Individual exact column qualifiers to be included in the AuthorizedView.
       * </pre>
       *
       * <code>repeated bytes qualifiers = 1;</code>
       *
       * @param values The qualifiers to add.
       * @return This builder for chaining.
       */
      public Builder addAllQualifiers(
          java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
        ensureQualifiersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qualifiers_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Individual exact column qualifiers to be included in the AuthorizedView.
       * </pre>
       *
       * <code>repeated bytes qualifiers = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQualifiers() {
        qualifiers_ = emptyList(com.google.protobuf.ByteString.class);
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString>
          qualifierPrefixes_ = emptyList(com.google.protobuf.ByteString.class);

      private void ensureQualifierPrefixesIsMutable() {
        if (!qualifierPrefixes_.isModifiable()) {
          qualifierPrefixes_ = makeMutableCopy(qualifierPrefixes_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Prefixes for qualifiers to be included in the AuthorizedView. Every
       * qualifier starting with one of these prefixes is included in the
       * AuthorizedView. To provide access to all qualifiers, include the empty
       * string as a prefix
       * ("").
       * </pre>
       *
       * <code>repeated bytes qualifier_prefixes = 2;</code>
       *
       * @return A list containing the qualifierPrefixes.
       */
      public java.util.List<com.google.protobuf.ByteString> getQualifierPrefixesList() {
        qualifierPrefixes_.makeImmutable();
        return qualifierPrefixes_;
      }

      /**
       *
       *
       * <pre>
       * Prefixes for qualifiers to be included in the AuthorizedView. Every
       * qualifier starting with one of these prefixes is included in the
       * AuthorizedView. To provide access to all qualifiers, include the empty
       * string as a prefix
       * ("").
       * </pre>
       *
       * <code>repeated bytes qualifier_prefixes = 2;</code>
       *
       * @return The count of qualifierPrefixes.
       */
      public int getQualifierPrefixesCount() {
        return qualifierPrefixes_.size();
      }

      /**
       *
       *
       * <pre>
       * Prefixes for qualifiers to be included in the AuthorizedView. Every
       * qualifier starting with one of these prefixes is included in the
       * AuthorizedView. To provide access to all qualifiers, include the empty
       * string as a prefix
       * ("").
       * </pre>
       *
       * <code>repeated bytes qualifier_prefixes = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The qualifierPrefixes at the given index.
       */
      public com.google.protobuf.ByteString getQualifierPrefixes(int index) {
        return qualifierPrefixes_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Prefixes for qualifiers to be included in the AuthorizedView. Every
       * qualifier starting with one of these prefixes is included in the
       * AuthorizedView. To provide access to all qualifiers, include the empty
       * string as a prefix
       * ("").
       * </pre>
       *
       * <code>repeated bytes qualifier_prefixes = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The qualifierPrefixes to set.
       * @return This builder for chaining.
       */
      public Builder setQualifierPrefixes(int index, com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQualifierPrefixesIsMutable();
        qualifierPrefixes_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Prefixes for qualifiers to be included in the AuthorizedView. Every
       * qualifier starting with one of these prefixes is included in the
       * AuthorizedView. To provide access to all qualifiers, include the empty
       * string as a prefix
       * ("").
       * </pre>
       *
       * <code>repeated bytes qualifier_prefixes = 2;</code>
       *
       * @param value The qualifierPrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addQualifierPrefixes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQualifierPrefixesIsMutable();
        qualifierPrefixes_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Prefixes for qualifiers to be included in the AuthorizedView. Every
       * qualifier starting with one of these prefixes is included in the
       * AuthorizedView. To provide access to all qualifiers, include the empty
       * string as a prefix
       * ("").
       * </pre>
       *
       * <code>repeated bytes qualifier_prefixes = 2;</code>
       *
       * @param values The qualifierPrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addAllQualifierPrefixes(
          java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
        ensureQualifierPrefixesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qualifierPrefixes_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Prefixes for qualifiers to be included in the AuthorizedView. Every
       * qualifier starting with one of these prefixes is included in the
       * AuthorizedView. To provide access to all qualifiers, include the empty
       * string as a prefix
       * ("").
       * </pre>
       *
       * <code>repeated bytes qualifier_prefixes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQualifierPrefixes() {
        qualifierPrefixes_ = emptyList(com.google.protobuf.ByteString.class);
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AuthorizedView.FamilySubsets)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AuthorizedView.FamilySubsets)
    private static final com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets();
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FamilySubsets> PARSER =
        new com.google.protobuf.AbstractParser<FamilySubsets>() {
          @java.lang.Override
          public FamilySubsets parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FamilySubsets> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FamilySubsets> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SubsetViewOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.AuthorizedView.SubsetView)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Row prefixes to be included in the AuthorizedView.
     * To provide access to all rows, include the empty string as a prefix ("").
     * </pre>
     *
     * <code>repeated bytes row_prefixes = 1;</code>
     *
     * @return A list containing the rowPrefixes.
     */
    java.util.List<com.google.protobuf.ByteString> getRowPrefixesList();

    /**
     *
     *
     * <pre>
     * Row prefixes to be included in the AuthorizedView.
     * To provide access to all rows, include the empty string as a prefix ("").
     * </pre>
     *
     * <code>repeated bytes row_prefixes = 1;</code>
     *
     * @return The count of rowPrefixes.
     */
    int getRowPrefixesCount();

    /**
     *
     *
     * <pre>
     * Row prefixes to be included in the AuthorizedView.
     * To provide access to all rows, include the empty string as a prefix ("").
     * </pre>
     *
     * <code>repeated bytes row_prefixes = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The rowPrefixes at the given index.
     */
    com.google.protobuf.ByteString getRowPrefixes(int index);

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    int getFamilySubsetsCount();

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    boolean containsFamilySubsets(java.lang.String key);

    /** Use {@link #getFamilySubsetsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
        getFamilySubsets();

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
        getFamilySubsetsMap();

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    /* nullable */
    com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets getFamilySubsetsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets defaultValue);

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets getFamilySubsetsOrThrow(
        java.lang.String key);
  }

  /**
   *
   *
   * <pre>
   * Defines a simple AuthorizedView that is a subset of the underlying Table.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AuthorizedView.SubsetView}
   */
  public static final class SubsetView extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AuthorizedView.SubsetView)
      SubsetViewOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SubsetView.newBuilder() to construct.
    private SubsetView(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SubsetView() {
      rowPrefixes_ = emptyList(com.google.protobuf.ByteString.class);
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SubsetView();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_AuthorizedView_SubsetView_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetFamilySubsets();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_AuthorizedView_SubsetView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AuthorizedView.SubsetView.class,
              com.google.bigtable.admin.v2.AuthorizedView.SubsetView.Builder.class);
    }

    public static final int ROW_PREFIXES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> rowPrefixes_ =
        emptyList(com.google.protobuf.ByteString.class);

    /**
     *
     *
     * <pre>
     * Row prefixes to be included in the AuthorizedView.
     * To provide access to all rows, include the empty string as a prefix ("").
     * </pre>
     *
     * <code>repeated bytes row_prefixes = 1;</code>
     *
     * @return A list containing the rowPrefixes.
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.ByteString> getRowPrefixesList() {
      return rowPrefixes_;
    }

    /**
     *
     *
     * <pre>
     * Row prefixes to be included in the AuthorizedView.
     * To provide access to all rows, include the empty string as a prefix ("").
     * </pre>
     *
     * <code>repeated bytes row_prefixes = 1;</code>
     *
     * @return The count of rowPrefixes.
     */
    public int getRowPrefixesCount() {
      return rowPrefixes_.size();
    }

    /**
     *
     *
     * <pre>
     * Row prefixes to be included in the AuthorizedView.
     * To provide access to all rows, include the empty string as a prefix ("").
     * </pre>
     *
     * <code>repeated bytes row_prefixes = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The rowPrefixes at the given index.
     */
    public com.google.protobuf.ByteString getRowPrefixes(int index) {
      return rowPrefixes_.get(index);
    }

    public static final int FAMILY_SUBSETS_FIELD_NUMBER = 2;

    private static final class FamilySubsetsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
                      newDefaultInstance(
                          com.google.bigtable.admin.v2.TableProto
                              .internal_static_google_bigtable_admin_v2_AuthorizedView_SubsetView_FamilySubsetsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets
                              .getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
        familySubsets_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
        internalGetFamilySubsets() {
      if (familySubsets_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FamilySubsetsDefaultEntryHolder.defaultEntry);
      }
      return familySubsets_;
    }

    public int getFamilySubsetsCount() {
      return internalGetFamilySubsets().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    @java.lang.Override
    public boolean containsFamilySubsets(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFamilySubsets().getMap().containsKey(key);
    }

    /** Use {@link #getFamilySubsetsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
        getFamilySubsets() {
      return getFamilySubsetsMap();
    }

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
        getFamilySubsetsMap() {
      return internalGetFamilySubsets().getMap();
    }

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets
        getFamilySubsetsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
          map = internalGetFamilySubsets().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Map from column family name to the columns in this family to be included
     * in the AuthorizedView.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets getFamilySubsetsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
          map = internalGetFamilySubsets().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < rowPrefixes_.size(); i++) {
        output.writeBytes(1, rowPrefixes_.get(i));
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetFamilySubsets(), FamilySubsetsDefaultEntryHolder.defaultEntry, 2);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < rowPrefixes_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(rowPrefixes_.get(i));
        }
        size += dataSize;
        size += 1 * getRowPrefixesList().size();
      }
      for (java.util.Map.Entry<
              java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
          entry : internalGetFamilySubsets().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
            familySubsets__ =
                FamilySubsetsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, familySubsets__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.AuthorizedView.SubsetView)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.AuthorizedView.SubsetView other =
          (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) obj;

      if (!getRowPrefixesList().equals(other.getRowPrefixesList())) return false;
      if (!internalGetFamilySubsets().equals(other.internalGetFamilySubsets())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRowPrefixesCount() > 0) {
        hash = (37 * hash) + ROW_PREFIXES_FIELD_NUMBER;
        hash = (53 * hash) + getRowPrefixesList().hashCode();
      }
      if (!internalGetFamilySubsets().getMap().isEmpty()) {
        hash = (37 * hash) + FAMILY_SUBSETS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetFamilySubsets().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.AuthorizedView.SubsetView prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Defines a simple AuthorizedView that is a subset of the underlying Table.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.AuthorizedView.SubsetView}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AuthorizedView.SubsetView)
        com.google.bigtable.admin.v2.AuthorizedView.SubsetViewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_AuthorizedView_SubsetView_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetFamilySubsets();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetMutableFamilySubsets();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_AuthorizedView_SubsetView_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.AuthorizedView.SubsetView.class,
                com.google.bigtable.admin.v2.AuthorizedView.SubsetView.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.AuthorizedView.SubsetView.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        rowPrefixes_ = emptyList(com.google.protobuf.ByteString.class);
        internalGetMutableFamilySubsets().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_AuthorizedView_SubsetView_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AuthorizedView.SubsetView getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AuthorizedView.SubsetView build() {
        com.google.bigtable.admin.v2.AuthorizedView.SubsetView result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AuthorizedView.SubsetView buildPartial() {
        com.google.bigtable.admin.v2.AuthorizedView.SubsetView result =
            new com.google.bigtable.admin.v2.AuthorizedView.SubsetView(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.AuthorizedView.SubsetView result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          rowPrefixes_.makeImmutable();
          result.rowPrefixes_ = rowPrefixes_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.familySubsets_ =
              internalGetFamilySubsets().build(FamilySubsetsDefaultEntryHolder.defaultEntry);
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.AuthorizedView.SubsetView) {
          return mergeFrom((com.google.bigtable.admin.v2.AuthorizedView.SubsetView) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.AuthorizedView.SubsetView other) {
        if (other == com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance())
          return this;
        if (!other.rowPrefixes_.isEmpty()) {
          if (rowPrefixes_.isEmpty()) {
            rowPrefixes_ = other.rowPrefixes_;
            rowPrefixes_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensureRowPrefixesIsMutable();
            rowPrefixes_.addAll(other.rowPrefixes_);
          }
          onChanged();
        }
        internalGetMutableFamilySubsets().mergeFrom(other.internalGetFamilySubsets());
        bitField0_ |= 0x00000002;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.ByteString v = input.readBytes();
                  ensureRowPrefixesIsMutable();
                  rowPrefixes_.add(v);
                  break;
                } // case 10
              case 18:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
                      familySubsets__ =
                          input.readMessage(
                              FamilySubsetsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableFamilySubsets()
                      .ensureBuilderMap()
                      .put(familySubsets__.getKey(), familySubsets__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString>
          rowPrefixes_ = emptyList(com.google.protobuf.ByteString.class);

      private void ensureRowPrefixesIsMutable() {
        if (!rowPrefixes_.isModifiable()) {
          rowPrefixes_ = makeMutableCopy(rowPrefixes_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Row prefixes to be included in the AuthorizedView.
       * To provide access to all rows, include the empty string as a prefix ("").
       * </pre>
       *
       * <code>repeated bytes row_prefixes = 1;</code>
       *
       * @return A list containing the rowPrefixes.
       */
      public java.util.List<com.google.protobuf.ByteString> getRowPrefixesList() {
        rowPrefixes_.makeImmutable();
        return rowPrefixes_;
      }

      /**
       *
       *
       * <pre>
       * Row prefixes to be included in the AuthorizedView.
       * To provide access to all rows, include the empty string as a prefix ("").
       * </pre>
       *
       * <code>repeated bytes row_prefixes = 1;</code>
       *
       * @return The count of rowPrefixes.
       */
      public int getRowPrefixesCount() {
        return rowPrefixes_.size();
      }

      /**
       *
       *
       * <pre>
       * Row prefixes to be included in the AuthorizedView.
       * To provide access to all rows, include the empty string as a prefix ("").
       * </pre>
       *
       * <code>repeated bytes row_prefixes = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The rowPrefixes at the given index.
       */
      public com.google.protobuf.ByteString getRowPrefixes(int index) {
        return rowPrefixes_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Row prefixes to be included in the AuthorizedView.
       * To provide access to all rows, include the empty string as a prefix ("").
       * </pre>
       *
       * <code>repeated bytes row_prefixes = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The rowPrefixes to set.
       * @return This builder for chaining.
       */
      public Builder setRowPrefixes(int index, com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowPrefixesIsMutable();
        rowPrefixes_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Row prefixes to be included in the AuthorizedView.
       * To provide access to all rows, include the empty string as a prefix ("").
       * </pre>
       *
       * <code>repeated bytes row_prefixes = 1;</code>
       *
       * @param value The rowPrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addRowPrefixes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowPrefixesIsMutable();
        rowPrefixes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Row prefixes to be included in the AuthorizedView.
       * To provide access to all rows, include the empty string as a prefix ("").
       * </pre>
       *
       * <code>repeated bytes row_prefixes = 1;</code>
       *
       * @param values The rowPrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addAllRowPrefixes(
          java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
        ensureRowPrefixesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rowPrefixes_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Row prefixes to be included in the AuthorizedView.
       * To provide access to all rows, include the empty string as a prefix ("").
       * </pre>
       *
       * <code>repeated bytes row_prefixes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowPrefixes() {
        rowPrefixes_ = emptyList(com.google.protobuf.ByteString.class);
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      private static final class FamilySubsetsConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets> {
        @java.lang.Override
        public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets build(
            com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder val) {
          if (val instanceof com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets) {
            return (com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets) val;
          }
          return ((com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
            defaultEntry() {
          return FamilySubsetsDefaultEntryHolder.defaultEntry;
        }
      }
      ;

      private static final FamilySubsetsConverter familySubsetsConverter =
          new FamilySubsetsConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder>
          familySubsets_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder>
          internalGetFamilySubsets() {
        if (familySubsets_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(familySubsetsConverter);
        }
        return familySubsets_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets,
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder>
          internalGetMutableFamilySubsets() {
        if (familySubsets_ == null) {
          familySubsets_ = new com.google.protobuf.MapFieldBuilder<>(familySubsetsConverter);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return familySubsets_;
      }

      public int getFamilySubsetsCount() {
        return internalGetFamilySubsets().ensureBuilderMap().size();
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      @java.lang.Override
      public boolean containsFamilySubsets(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetFamilySubsets().ensureBuilderMap().containsKey(key);
      }

      /** Use {@link #getFamilySubsetsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
          getFamilySubsets() {
        return getFamilySubsetsMap();
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
          getFamilySubsetsMap() {
        return internalGetFamilySubsets().getImmutableMap();
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets
          getFamilySubsetsOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder>
            map = internalGetMutableFamilySubsets().ensureBuilderMap();
        return map.containsKey(key) ? familySubsetsConverter.build(map.get(key)) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets getFamilySubsetsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder>
            map = internalGetMutableFamilySubsets().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return familySubsetsConverter.build(map.get(key));
      }

      public Builder clearFamilySubsets() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableFamilySubsets().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      public Builder removeFamilySubsets(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableFamilySubsets().ensureBuilderMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
          getMutableFamilySubsets() {
        bitField0_ |= 0x00000002;
        return internalGetMutableFamilySubsets().ensureMessageMap();
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      public Builder putFamilySubsets(
          java.lang.String key, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableFamilySubsets().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      public Builder putAllFamilySubsets(
          java.util.Map<java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
              values) {
        for (java.util.Map.Entry<
                java.lang.String, com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableFamilySubsets().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Map from column family name to the columns in this family to be included
       * in the AuthorizedView.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.bigtable.admin.v2.AuthorizedView.FamilySubsets&gt; family_subsets = 2;
       * </code>
       */
      public com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder
          putFamilySubsetsBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder>
            builderMap = internalGetMutableFamilySubsets().ensureBuilderMap();
        com.google.bigtable.admin.v2.AuthorizedView.FamilySubsetsOrBuilder entry =
            builderMap.get(key);
        if (entry == null) {
          entry = com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets) {
          entry = ((com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.bigtable.admin.v2.AuthorizedView.FamilySubsets.Builder) entry;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AuthorizedView.SubsetView)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AuthorizedView.SubsetView)
    private static final com.google.bigtable.admin.v2.AuthorizedView.SubsetView DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AuthorizedView.SubsetView();
    }

    public static com.google.bigtable.admin.v2.AuthorizedView.SubsetView getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SubsetView> PARSER =
        new com.google.protobuf.AbstractParser<SubsetView>() {
          @java.lang.Override
          public SubsetView parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SubsetView> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SubsetView> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView.SubsetView getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int authorizedViewCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object authorizedView_;

  public enum AuthorizedViewCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SUBSET_VIEW(2),
    AUTHORIZEDVIEW_NOT_SET(0);
    private final int value;

    private AuthorizedViewCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthorizedViewCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthorizedViewCase forNumber(int value) {
      switch (value) {
        case 2:
          return SUBSET_VIEW;
        case 0:
          return AUTHORIZEDVIEW_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthorizedViewCase getAuthorizedViewCase() {
    return AuthorizedViewCase.forNumber(authorizedViewCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The name of this AuthorizedView.
   * Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The name of this AuthorizedView.
   * Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBSET_VIEW_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * An AuthorizedView permitting access to an explicit subset of a Table.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
   *
   * @return Whether the subsetView field is set.
   */
  @java.lang.Override
  public boolean hasSubsetView() {
    return authorizedViewCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * An AuthorizedView permitting access to an explicit subset of a Table.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
   *
   * @return The subsetView.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AuthorizedView.SubsetView getSubsetView() {
    if (authorizedViewCase_ == 2) {
      return (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_;
    }
    return com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * An AuthorizedView permitting access to an explicit subset of a Table.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AuthorizedView.SubsetViewOrBuilder getSubsetViewOrBuilder() {
    if (authorizedViewCase_ == 2) {
      return (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_;
    }
    return com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance();
  }

  public static final int ETAG_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * The etag for this AuthorizedView.
   * If this is provided on update, it must match the server's etag. The server
   * returns ABORTED error on a mismatched etag.
   * </pre>
   *
   * <code>string etag = 3;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The etag for this AuthorizedView.
   * If this is provided on update, it must match the server's etag. The server
   * returns ABORTED error on a mismatched etag.
   * </pre>
   *
   * <code>string etag = 3;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETION_PROTECTION_FIELD_NUMBER = 4;
  private boolean deletionProtection_ = false;

  /**
   *
   *
   * <pre>
   * Set to true to make the AuthorizedView protected against deletion.
   * The parent Table and containing Instance cannot be deleted if an
   * AuthorizedView has this bit set.
   * </pre>
   *
   * <code>bool deletion_protection = 4;</code>
   *
   * @return The deletionProtection.
   */
  @java.lang.Override
  public boolean getDeletionProtection() {
    return deletionProtection_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (authorizedViewCase_ == 2) {
      output.writeMessage(
          2, (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, etag_);
    }
    if (deletionProtection_ != false) {
      output.writeBool(4, deletionProtection_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (authorizedViewCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, etag_);
    }
    if (deletionProtection_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, deletionProtection_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.AuthorizedView)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.AuthorizedView other =
        (com.google.bigtable.admin.v2.AuthorizedView) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (getDeletionProtection() != other.getDeletionProtection()) return false;
    if (!getAuthorizedViewCase().equals(other.getAuthorizedViewCase())) return false;
    switch (authorizedViewCase_) {
      case 2:
        if (!getSubsetView().equals(other.getSubsetView())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + DELETION_PROTECTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeletionProtection());
    switch (authorizedViewCase_) {
      case 2:
        hash = (37 * hash) + SUBSET_VIEW_FIELD_NUMBER;
        hash = (53 * hash) + getSubsetView().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.AuthorizedView parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.AuthorizedView prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * AuthorizedViews represent subsets of a particular Cloud Bigtable table. Users
   * can configure access to each Authorized View independently from the table and
   * use the existing Data APIs to access the subset of data.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AuthorizedView}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AuthorizedView)
      com.google.bigtable.admin.v2.AuthorizedViewOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_AuthorizedView_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_AuthorizedView_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AuthorizedView.class,
              com.google.bigtable.admin.v2.AuthorizedView.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.AuthorizedView.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (subsetViewBuilder_ != null) {
        subsetViewBuilder_.clear();
      }
      etag_ = "";
      deletionProtection_ = false;
      authorizedViewCase_ = 0;
      authorizedView_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_AuthorizedView_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.AuthorizedView.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView build() {
      com.google.bigtable.admin.v2.AuthorizedView result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView buildPartial() {
      com.google.bigtable.admin.v2.AuthorizedView result =
          new com.google.bigtable.admin.v2.AuthorizedView(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.AuthorizedView result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.deletionProtection_ = deletionProtection_;
      }
    }

    private void buildPartialOneofs(com.google.bigtable.admin.v2.AuthorizedView result) {
      result.authorizedViewCase_ = authorizedViewCase_;
      result.authorizedView_ = this.authorizedView_;
      if (authorizedViewCase_ == 2 && subsetViewBuilder_ != null) {
        result.authorizedView_ = subsetViewBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.AuthorizedView) {
        return mergeFrom((com.google.bigtable.admin.v2.AuthorizedView) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.AuthorizedView other) {
      if (other == com.google.bigtable.admin.v2.AuthorizedView.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getDeletionProtection() != false) {
        setDeletionProtection(other.getDeletionProtection());
      }
      switch (other.getAuthorizedViewCase()) {
        case SUBSET_VIEW:
          {
            mergeSubsetView(other.getSubsetView());
            break;
          }
        case AUTHORIZEDVIEW_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSubsetViewFieldBuilder().getBuilder(), extensionRegistry);
                authorizedViewCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                deletionProtection_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int authorizedViewCase_ = 0;
    private java.lang.Object authorizedView_;

    public AuthorizedViewCase getAuthorizedViewCase() {
      return AuthorizedViewCase.forNumber(authorizedViewCase_);
    }

    public Builder clearAuthorizedView() {
      authorizedViewCase_ = 0;
      authorizedView_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.AuthorizedView.SubsetView,
            com.google.bigtable.admin.v2.AuthorizedView.SubsetView.Builder,
            com.google.bigtable.admin.v2.AuthorizedView.SubsetViewOrBuilder>
        subsetViewBuilder_;

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     *
     * @return Whether the subsetView field is set.
     */
    @java.lang.Override
    public boolean hasSubsetView() {
      return authorizedViewCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     *
     * @return The subsetView.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView.SubsetView getSubsetView() {
      if (subsetViewBuilder_ == null) {
        if (authorizedViewCase_ == 2) {
          return (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_;
        }
        return com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance();
      } else {
        if (authorizedViewCase_ == 2) {
          return subsetViewBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     */
    public Builder setSubsetView(com.google.bigtable.admin.v2.AuthorizedView.SubsetView value) {
      if (subsetViewBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authorizedView_ = value;
        onChanged();
      } else {
        subsetViewBuilder_.setMessage(value);
      }
      authorizedViewCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     */
    public Builder setSubsetView(
        com.google.bigtable.admin.v2.AuthorizedView.SubsetView.Builder builderForValue) {
      if (subsetViewBuilder_ == null) {
        authorizedView_ = builderForValue.build();
        onChanged();
      } else {
        subsetViewBuilder_.setMessage(builderForValue.build());
      }
      authorizedViewCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     */
    public Builder mergeSubsetView(com.google.bigtable.admin.v2.AuthorizedView.SubsetView value) {
      if (subsetViewBuilder_ == null) {
        if (authorizedViewCase_ == 2
            && authorizedView_
                != com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance()) {
          authorizedView_ =
              com.google.bigtable.admin.v2.AuthorizedView.SubsetView.newBuilder(
                      (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authorizedView_ = value;
        }
        onChanged();
      } else {
        if (authorizedViewCase_ == 2) {
          subsetViewBuilder_.mergeFrom(value);
        } else {
          subsetViewBuilder_.setMessage(value);
        }
      }
      authorizedViewCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     */
    public Builder clearSubsetView() {
      if (subsetViewBuilder_ == null) {
        if (authorizedViewCase_ == 2) {
          authorizedViewCase_ = 0;
          authorizedView_ = null;
          onChanged();
        }
      } else {
        if (authorizedViewCase_ == 2) {
          authorizedViewCase_ = 0;
          authorizedView_ = null;
        }
        subsetViewBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     */
    public com.google.bigtable.admin.v2.AuthorizedView.SubsetView.Builder getSubsetViewBuilder() {
      return getSubsetViewFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AuthorizedView.SubsetViewOrBuilder
        getSubsetViewOrBuilder() {
      if ((authorizedViewCase_ == 2) && (subsetViewBuilder_ != null)) {
        return subsetViewBuilder_.getMessageOrBuilder();
      } else {
        if (authorizedViewCase_ == 2) {
          return (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_;
        }
        return com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An AuthorizedView permitting access to an explicit subset of a Table.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.AuthorizedView.SubsetView,
            com.google.bigtable.admin.v2.AuthorizedView.SubsetView.Builder,
            com.google.bigtable.admin.v2.AuthorizedView.SubsetViewOrBuilder>
        getSubsetViewFieldBuilder() {
      if (subsetViewBuilder_ == null) {
        if (!(authorizedViewCase_ == 2)) {
          authorizedView_ =
              com.google.bigtable.admin.v2.AuthorizedView.SubsetView.getDefaultInstance();
        }
        subsetViewBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.AuthorizedView.SubsetView,
                com.google.bigtable.admin.v2.AuthorizedView.SubsetView.Builder,
                com.google.bigtable.admin.v2.AuthorizedView.SubsetViewOrBuilder>(
                (com.google.bigtable.admin.v2.AuthorizedView.SubsetView) authorizedView_,
                getParentForChildren(),
                isClean());
        authorizedView_ = null;
      }
      authorizedViewCase_ = 2;
      onChanged();
      return subsetViewBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean deletionProtection_;

    /**
     *
     *
     * <pre>
     * Set to true to make the AuthorizedView protected against deletion.
     * The parent Table and containing Instance cannot be deleted if an
     * AuthorizedView has this bit set.
     * </pre>
     *
     * <code>bool deletion_protection = 4;</code>
     *
     * @return The deletionProtection.
     */
    @java.lang.Override
    public boolean getDeletionProtection() {
      return deletionProtection_;
    }

    /**
     *
     *
     * <pre>
     * Set to true to make the AuthorizedView protected against deletion.
     * The parent Table and containing Instance cannot be deleted if an
     * AuthorizedView has this bit set.
     * </pre>
     *
     * <code>bool deletion_protection = 4;</code>
     *
     * @param value The deletionProtection to set.
     * @return This builder for chaining.
     */
    public Builder setDeletionProtection(boolean value) {

      deletionProtection_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Set to true to make the AuthorizedView protected against deletion.
     * The parent Table and containing Instance cannot be deleted if an
     * AuthorizedView has this bit set.
     * </pre>
     *
     * <code>bool deletion_protection = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeletionProtection() {
      bitField0_ = (bitField0_ & ~0x00000008);
      deletionProtection_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AuthorizedView)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AuthorizedView)
  private static final com.google.bigtable.admin.v2.AuthorizedView DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AuthorizedView();
  }

  public static com.google.bigtable.admin.v2.AuthorizedView getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuthorizedView> PARSER =
      new com.google.protobuf.AbstractParser<AuthorizedView>() {
        @java.lang.Override
        public AuthorizedView parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuthorizedView> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuthorizedView> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.AuthorizedView getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
