/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * The request for
 * [ListBackups][google.bigtable.admin.v2.BigtableTableAdmin.ListBackups].
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.ListBackupsRequest}
 */
public final class ListBackupsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.ListBackupsRequest)
    ListBackupsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListBackupsRequest.newBuilder() to construct.
  private ListBackupsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListBackupsRequest() {
    parent_ = "";
    filter_ = "";
    orderBy_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListBackupsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_ListBackupsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_ListBackupsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.ListBackupsRequest.class,
            com.google.bigtable.admin.v2.ListBackupsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The cluster to list backups from.  Values are of the
   * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * Use `{cluster} = '-'` to list backups for all clusters in an instance,
   * e.g., `projects/{project}/instances/{instance}/clusters/-`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The cluster to list backups from.  Values are of the
   * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * Use `{cluster} = '-'` to list backups for all clusters in an instance,
   * e.g., `projects/{project}/instances/{instance}/clusters/-`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * A filter expression that filters backups listed in the response.
   * The expression must specify the field name, a comparison operator,
   * and the value that you want to use for filtering. The value must be a
   * string, a number, or a boolean. The comparison operator must be
   * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
   * roughly synonymous with equality. Filter rules are case insensitive.
   *
   * The fields eligible for filtering are:
   *
   * * `name`
   * * `source_table`
   * * `state`
   * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `size_bytes`
   *
   * To filter on multiple expressions, provide each separate expression within
   * parentheses. By default, each expression is an AND expression. However,
   * you can include AND, OR, and NOT expressions explicitly.
   *
   * Some examples of using filters are:
   *
   * * `name:"exact"` --&gt; The backup's name is the string "exact".
   * * `name:howl` --&gt; The backup's name contains the string "howl".
   * * `source_table:prod`
   *        --&gt; The source_table's name contains the string "prod".
   * * `state:CREATING` --&gt; The backup is pending creation.
   * * `state:READY` --&gt; The backup is fully created and ready for use.
   * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
   *        --&gt; The backup name contains the string "howl" and start_time
   *            of the backup is before 2018-03-28T14:50:00Z.
   * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A filter expression that filters backups listed in the response.
   * The expression must specify the field name, a comparison operator,
   * and the value that you want to use for filtering. The value must be a
   * string, a number, or a boolean. The comparison operator must be
   * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
   * roughly synonymous with equality. Filter rules are case insensitive.
   *
   * The fields eligible for filtering are:
   *
   * * `name`
   * * `source_table`
   * * `state`
   * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `size_bytes`
   *
   * To filter on multiple expressions, provide each separate expression within
   * parentheses. By default, each expression is an AND expression. However,
   * you can include AND, OR, and NOT expressions explicitly.
   *
   * Some examples of using filters are:
   *
   * * `name:"exact"` --&gt; The backup's name is the string "exact".
   * * `name:howl` --&gt; The backup's name contains the string "howl".
   * * `source_table:prod`
   *        --&gt; The source_table's name contains the string "prod".
   * * `state:CREATING` --&gt; The backup is pending creation.
   * * `state:READY` --&gt; The backup is fully created and ready for use.
   * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
   *        --&gt; The backup name contains the string "howl" and start_time
   *            of the backup is before 2018-03-28T14:50:00Z.
   * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";

  /**
   *
   *
   * <pre>
   * An expression for specifying the sort order of the results of the request.
   * The string value should specify one or more fields in
   * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
   * https://aip.dev/132#ordering.
   *
   * Fields supported are:
   *
   * * name
   * * source_table
   * * expire_time
   * * start_time
   * * end_time
   * * size_bytes
   * * state
   *
   * For example, "start_time". The default sorting order is ascending.
   * To specify descending order for the field, a suffix " desc" should
   * be appended to the field name. For example, "start_time desc".
   * Redundant space characters in the syntax are insigificant.
   *
   * If order_by is empty, results will be sorted by `start_time` in descending
   * order starting from the most recently created backup.
   * </pre>
   *
   * <code>string order_by = 3;</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An expression for specifying the sort order of the results of the request.
   * The string value should specify one or more fields in
   * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
   * https://aip.dev/132#ordering.
   *
   * Fields supported are:
   *
   * * name
   * * source_table
   * * expire_time
   * * start_time
   * * end_time
   * * size_bytes
   * * state
   *
   * For example, "start_time". The default sorting order is ascending.
   * To specify descending order for the field, a suffix " desc" should
   * be appended to the field name. For example, "start_time desc".
   * Redundant space characters in the syntax are insigificant.
   *
   * If order_by is empty, results will be sorted by `start_time` in descending
   * order starting from the most recently created backup.
   * </pre>
   *
   * <code>string order_by = 3;</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 4;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * Number of backups to be returned in the response. If 0 or
   * less, defaults to the server's maximum allowed page size.
   * </pre>
   *
   * <code>int32 page_size = 4;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
   * from a previous
   * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
   * same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
   * from a previous
   * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
   * same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, orderBy_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, orderBy_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.ListBackupsRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.ListBackupsRequest other =
        (com.google.bigtable.admin.v2.ListBackupsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.ListBackupsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for
   * [ListBackups][google.bigtable.admin.v2.BigtableTableAdmin.ListBackups].
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.ListBackupsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.ListBackupsRequest)
      com.google.bigtable.admin.v2.ListBackupsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ListBackupsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ListBackupsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.ListBackupsRequest.class,
              com.google.bigtable.admin.v2.ListBackupsRequest.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.ListBackupsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      filter_ = "";
      orderBy_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ListBackupsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ListBackupsRequest getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.ListBackupsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ListBackupsRequest build() {
      com.google.bigtable.admin.v2.ListBackupsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ListBackupsRequest buildPartial() {
      com.google.bigtable.admin.v2.ListBackupsRequest result =
          new com.google.bigtable.admin.v2.ListBackupsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.ListBackupsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.orderBy_ = orderBy_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pageToken_ = pageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.ListBackupsRequest) {
        return mergeFrom((com.google.bigtable.admin.v2.ListBackupsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.ListBackupsRequest other) {
      if (other == com.google.bigtable.admin.v2.ListBackupsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The cluster to list backups from.  Values are of the
     * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * Use `{cluster} = '-'` to list backups for all clusters in an instance,
     * e.g., `projects/{project}/instances/{instance}/clusters/-`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The cluster to list backups from.  Values are of the
     * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * Use `{cluster} = '-'` to list backups for all clusters in an instance,
     * e.g., `projects/{project}/instances/{instance}/clusters/-`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The cluster to list backups from.  Values are of the
     * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * Use `{cluster} = '-'` to list backups for all clusters in an instance,
     * e.g., `projects/{project}/instances/{instance}/clusters/-`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The cluster to list backups from.  Values are of the
     * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * Use `{cluster} = '-'` to list backups for all clusters in an instance,
     * e.g., `projects/{project}/instances/{instance}/clusters/-`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The cluster to list backups from.  Values are of the
     * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * Use `{cluster} = '-'` to list backups for all clusters in an instance,
     * e.g., `projects/{project}/instances/{instance}/clusters/-`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * A filter expression that filters backups listed in the response.
     * The expression must specify the field name, a comparison operator,
     * and the value that you want to use for filtering. The value must be a
     * string, a number, or a boolean. The comparison operator must be
     * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
     * roughly synonymous with equality. Filter rules are case insensitive.
     *
     * The fields eligible for filtering are:
     *
     * * `name`
     * * `source_table`
     * * `state`
     * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `size_bytes`
     *
     * To filter on multiple expressions, provide each separate expression within
     * parentheses. By default, each expression is an AND expression. However,
     * you can include AND, OR, and NOT expressions explicitly.
     *
     * Some examples of using filters are:
     *
     * * `name:"exact"` --&gt; The backup's name is the string "exact".
     * * `name:howl` --&gt; The backup's name contains the string "howl".
     * * `source_table:prod`
     *        --&gt; The source_table's name contains the string "prod".
     * * `state:CREATING` --&gt; The backup is pending creation.
     * * `state:READY` --&gt; The backup is fully created and ready for use.
     * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
     *        --&gt; The backup name contains the string "howl" and start_time
     *            of the backup is before 2018-03-28T14:50:00Z.
     * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A filter expression that filters backups listed in the response.
     * The expression must specify the field name, a comparison operator,
     * and the value that you want to use for filtering. The value must be a
     * string, a number, or a boolean. The comparison operator must be
     * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
     * roughly synonymous with equality. Filter rules are case insensitive.
     *
     * The fields eligible for filtering are:
     *
     * * `name`
     * * `source_table`
     * * `state`
     * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `size_bytes`
     *
     * To filter on multiple expressions, provide each separate expression within
     * parentheses. By default, each expression is an AND expression. However,
     * you can include AND, OR, and NOT expressions explicitly.
     *
     * Some examples of using filters are:
     *
     * * `name:"exact"` --&gt; The backup's name is the string "exact".
     * * `name:howl` --&gt; The backup's name contains the string "howl".
     * * `source_table:prod`
     *        --&gt; The source_table's name contains the string "prod".
     * * `state:CREATING` --&gt; The backup is pending creation.
     * * `state:READY` --&gt; The backup is fully created and ready for use.
     * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
     *        --&gt; The backup name contains the string "howl" and start_time
     *            of the backup is before 2018-03-28T14:50:00Z.
     * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A filter expression that filters backups listed in the response.
     * The expression must specify the field name, a comparison operator,
     * and the value that you want to use for filtering. The value must be a
     * string, a number, or a boolean. The comparison operator must be
     * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
     * roughly synonymous with equality. Filter rules are case insensitive.
     *
     * The fields eligible for filtering are:
     *
     * * `name`
     * * `source_table`
     * * `state`
     * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `size_bytes`
     *
     * To filter on multiple expressions, provide each separate expression within
     * parentheses. By default, each expression is an AND expression. However,
     * you can include AND, OR, and NOT expressions explicitly.
     *
     * Some examples of using filters are:
     *
     * * `name:"exact"` --&gt; The backup's name is the string "exact".
     * * `name:howl` --&gt; The backup's name contains the string "howl".
     * * `source_table:prod`
     *        --&gt; The source_table's name contains the string "prod".
     * * `state:CREATING` --&gt; The backup is pending creation.
     * * `state:READY` --&gt; The backup is fully created and ready for use.
     * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
     *        --&gt; The backup name contains the string "howl" and start_time
     *            of the backup is before 2018-03-28T14:50:00Z.
     * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A filter expression that filters backups listed in the response.
     * The expression must specify the field name, a comparison operator,
     * and the value that you want to use for filtering. The value must be a
     * string, a number, or a boolean. The comparison operator must be
     * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
     * roughly synonymous with equality. Filter rules are case insensitive.
     *
     * The fields eligible for filtering are:
     *
     * * `name`
     * * `source_table`
     * * `state`
     * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `size_bytes`
     *
     * To filter on multiple expressions, provide each separate expression within
     * parentheses. By default, each expression is an AND expression. However,
     * you can include AND, OR, and NOT expressions explicitly.
     *
     * Some examples of using filters are:
     *
     * * `name:"exact"` --&gt; The backup's name is the string "exact".
     * * `name:howl` --&gt; The backup's name contains the string "howl".
     * * `source_table:prod`
     *        --&gt; The source_table's name contains the string "prod".
     * * `state:CREATING` --&gt; The backup is pending creation.
     * * `state:READY` --&gt; The backup is fully created and ready for use.
     * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
     *        --&gt; The backup name contains the string "howl" and start_time
     *            of the backup is before 2018-03-28T14:50:00Z.
     * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A filter expression that filters backups listed in the response.
     * The expression must specify the field name, a comparison operator,
     * and the value that you want to use for filtering. The value must be a
     * string, a number, or a boolean. The comparison operator must be
     * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
     * roughly synonymous with equality. Filter rules are case insensitive.
     *
     * The fields eligible for filtering are:
     *
     * * `name`
     * * `source_table`
     * * `state`
     * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
     * * `size_bytes`
     *
     * To filter on multiple expressions, provide each separate expression within
     * parentheses. By default, each expression is an AND expression. However,
     * you can include AND, OR, and NOT expressions explicitly.
     *
     * Some examples of using filters are:
     *
     * * `name:"exact"` --&gt; The backup's name is the string "exact".
     * * `name:howl` --&gt; The backup's name contains the string "howl".
     * * `source_table:prod`
     *        --&gt; The source_table's name contains the string "prod".
     * * `state:CREATING` --&gt; The backup is pending creation.
     * * `state:READY` --&gt; The backup is fully created and ready for use.
     * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
     *        --&gt; The backup name contains the string "howl" and start_time
     *            of the backup is before 2018-03-28T14:50:00Z.
     * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";

    /**
     *
     *
     * <pre>
     * An expression for specifying the sort order of the results of the request.
     * The string value should specify one or more fields in
     * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
     * https://aip.dev/132#ordering.
     *
     * Fields supported are:
     *
     * * name
     * * source_table
     * * expire_time
     * * start_time
     * * end_time
     * * size_bytes
     * * state
     *
     * For example, "start_time". The default sorting order is ascending.
     * To specify descending order for the field, a suffix " desc" should
     * be appended to the field name. For example, "start_time desc".
     * Redundant space characters in the syntax are insigificant.
     *
     * If order_by is empty, results will be sorted by `start_time` in descending
     * order starting from the most recently created backup.
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An expression for specifying the sort order of the results of the request.
     * The string value should specify one or more fields in
     * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
     * https://aip.dev/132#ordering.
     *
     * Fields supported are:
     *
     * * name
     * * source_table
     * * expire_time
     * * start_time
     * * end_time
     * * size_bytes
     * * state
     *
     * For example, "start_time". The default sorting order is ascending.
     * To specify descending order for the field, a suffix " desc" should
     * be appended to the field name. For example, "start_time desc".
     * Redundant space characters in the syntax are insigificant.
     *
     * If order_by is empty, results will be sorted by `start_time` in descending
     * order starting from the most recently created backup.
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An expression for specifying the sort order of the results of the request.
     * The string value should specify one or more fields in
     * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
     * https://aip.dev/132#ordering.
     *
     * Fields supported are:
     *
     * * name
     * * source_table
     * * expire_time
     * * start_time
     * * end_time
     * * size_bytes
     * * state
     *
     * For example, "start_time". The default sorting order is ascending.
     * To specify descending order for the field, a suffix " desc" should
     * be appended to the field name. For example, "start_time desc".
     * Redundant space characters in the syntax are insigificant.
     *
     * If order_by is empty, results will be sorted by `start_time` in descending
     * order starting from the most recently created backup.
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An expression for specifying the sort order of the results of the request.
     * The string value should specify one or more fields in
     * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
     * https://aip.dev/132#ordering.
     *
     * Fields supported are:
     *
     * * name
     * * source_table
     * * expire_time
     * * start_time
     * * end_time
     * * size_bytes
     * * state
     *
     * For example, "start_time". The default sorting order is ascending.
     * To specify descending order for the field, a suffix " desc" should
     * be appended to the field name. For example, "start_time desc".
     * Redundant space characters in the syntax are insigificant.
     *
     * If order_by is empty, results will be sorted by `start_time` in descending
     * order starting from the most recently created backup.
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An expression for specifying the sort order of the results of the request.
     * The string value should specify one or more fields in
     * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
     * https://aip.dev/132#ordering.
     *
     * Fields supported are:
     *
     * * name
     * * source_table
     * * expire_time
     * * start_time
     * * end_time
     * * size_bytes
     * * state
     *
     * For example, "start_time". The default sorting order is ascending.
     * To specify descending order for the field, a suffix " desc" should
     * be appended to the field name. For example, "start_time desc".
     * Redundant space characters in the syntax are insigificant.
     *
     * If order_by is empty, results will be sorted by `start_time` in descending
     * order starting from the most recently created backup.
     * </pre>
     *
     * <code>string order_by = 3;</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * Number of backups to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * Number of backups to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Number of backups to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000008);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
     * from a previous
     * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
     * from a previous
     * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
     * from a previous
     * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
     * from a previous
     * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
     * from a previous
     * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.ListBackupsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.ListBackupsRequest)
  private static final com.google.bigtable.admin.v2.ListBackupsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.ListBackupsRequest();
  }

  public static com.google.bigtable.admin.v2.ListBackupsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListBackupsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListBackupsRequest>() {
        @java.lang.Override
        public ListBackupsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListBackupsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListBackupsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.ListBackupsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
