/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/data.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.v2;

public interface PartialResultSetOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.bigtable.v2.PartialResultSet)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Partial rows in serialized ProtoRows format.
   * </pre>
   *
   * <code>.google.bigtable.v2.ProtoRowsBatch proto_rows_batch = 3;</code>
   *
   * @return Whether the protoRowsBatch field is set.
   */
  boolean hasProtoRowsBatch();

  /**
   *
   *
   * <pre>
   * Partial rows in serialized ProtoRows format.
   * </pre>
   *
   * <code>.google.bigtable.v2.ProtoRowsBatch proto_rows_batch = 3;</code>
   *
   * @return The protoRowsBatch.
   */
  com.google.bigtable.v2.ProtoRowsBatch getProtoRowsBatch();

  /**
   *
   *
   * <pre>
   * Partial rows in serialized ProtoRows format.
   * </pre>
   *
   * <code>.google.bigtable.v2.ProtoRowsBatch proto_rows_batch = 3;</code>
   */
  com.google.bigtable.v2.ProtoRowsBatchOrBuilder getProtoRowsBatchOrBuilder();

  /**
   *
   *
   * <pre>
   * CRC32C checksum of concatenated `partial_rows` data for the current batch.
   *
   * When present, the buffered data from `partial_rows` forms a complete
   * parseable message of the appropriate type.
   *
   * The client should mark the end of a parseable message and prepare to
   * receive a new one starting from the next `PartialResultSet` message.
   * Clients must verify the checksum of the serialized batch before yielding it
   * to the caller.
   *
   * This does NOT mean the values can be yielded to the callers since a
   * `resume_token` is required to safely do so.
   *
   * If `resume_token` is non-empty and any data has been received since the
   * last one, this field is guaranteed to be non-empty. In other words, clients
   * may assume that a batch will never cross a `resume_token` boundary.
   * </pre>
   *
   * <code>optional uint32 batch_checksum = 6;</code>
   *
   * @return Whether the batchChecksum field is set.
   */
  boolean hasBatchChecksum();

  /**
   *
   *
   * <pre>
   * CRC32C checksum of concatenated `partial_rows` data for the current batch.
   *
   * When present, the buffered data from `partial_rows` forms a complete
   * parseable message of the appropriate type.
   *
   * The client should mark the end of a parseable message and prepare to
   * receive a new one starting from the next `PartialResultSet` message.
   * Clients must verify the checksum of the serialized batch before yielding it
   * to the caller.
   *
   * This does NOT mean the values can be yielded to the callers since a
   * `resume_token` is required to safely do so.
   *
   * If `resume_token` is non-empty and any data has been received since the
   * last one, this field is guaranteed to be non-empty. In other words, clients
   * may assume that a batch will never cross a `resume_token` boundary.
   * </pre>
   *
   * <code>optional uint32 batch_checksum = 6;</code>
   *
   * @return The batchChecksum.
   */
  int getBatchChecksum();

  /**
   *
   *
   * <pre>
   * An opaque token sent by the server to allow query resumption and signal
   * that the buffered values constructed from received `partial_rows` can be
   * yielded to the caller. Clients can provide this token in a subsequent
   * request to resume the result stream from the current point.
   *
   * When `resume_token` is non-empty, the buffered values received from
   * `partial_rows` since the last non-empty `resume_token` can be yielded to
   * the callers, provided that the client keeps the value of `resume_token` and
   * uses it on subsequent retries.
   *
   * A `resume_token` may be sent without information in `partial_rows` to
   * checkpoint the progress of a sparse query. Any previous `partial_rows` data
   * should still be yielded in this case, and the new `resume_token` should be
   * saved for future retries as normal.
   *
   * A `resume_token` will only be sent on a boundary where there is either no
   * ongoing result batch, or `batch_checksum` is also populated.
   *
   * The server will also send a sentinel `resume_token` when last batch of
   * `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
   * the sentinel `resume_token`, the server will emit it again without any
   * data in `partial_rows`, then return OK.
   * </pre>
   *
   * <code>bytes resume_token = 5;</code>
   *
   * @return The resumeToken.
   */
  com.google.protobuf.ByteString getResumeToken();

  /**
   *
   *
   * <pre>
   * If `true`, any data buffered since the last non-empty `resume_token` must
   * be discarded before the other parts of this message, if any, are handled.
   * </pre>
   *
   * <code>bool reset = 7;</code>
   *
   * @return The reset.
   */
  boolean getReset();

  /**
   *
   *
   * <pre>
   * Estimated size of the buffer required to hold the next batch of results.
   *
   * This value will be sent with the first `partial_rows` of a batch. That is,
   * on the first `partial_rows` received in a stream, on the first message
   * after a `batch_checksum` message, and any time `reset` is true.
   *
   * The client can use this estimate to allocate a buffer for the next batch of
   * results. This helps minimize the number of allocations required, though the
   * buffer size may still need to be increased if the estimate is too low.
   * </pre>
   *
   * <code>int32 estimated_batch_size = 4;</code>
   *
   * @return The estimatedBatchSize.
   */
  int getEstimatedBatchSize();

  com.google.bigtable.v2.PartialResultSet.PartialRowsCase getPartialRowsCase();
}
