/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/peer_info.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * PeerInfo contains information about the peer that the client is
 * connecting to.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.PeerInfo}
 */
public final class PeerInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.PeerInfo)
    PeerInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PeerInfo.newBuilder() to construct.
  private PeerInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PeerInfo() {
    applicationFrontendZone_ = "";
    applicationFrontendSubzone_ = "";
    transportType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PeerInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.PeerInfoProto
        .internal_static_google_bigtable_v2_PeerInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.PeerInfoProto
        .internal_static_google_bigtable_v2_PeerInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.PeerInfo.class, com.google.bigtable.v2.PeerInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The transport type that the client used to connect to this peer.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.v2.PeerInfo.TransportType}
   */
  public enum TransportType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The transport type is unknown.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_UNKNOWN = 0;</code>
     */
    TRANSPORT_TYPE_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * The client connected to this peer via an external network
     * (e.g. outside Google Coud).
     * </pre>
     *
     * <code>TRANSPORT_TYPE_EXTERNAL = 1;</code>
     */
    TRANSPORT_TYPE_EXTERNAL(1),
    /**
     *
     *
     * <pre>
     * The client connected to this peer via CloudPath.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_CLOUD_PATH = 2;</code>
     */
    TRANSPORT_TYPE_CLOUD_PATH(2),
    /**
     *
     *
     * <pre>
     * The client connected to this peer via DirectAccess.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_DIRECT_ACCESS = 3;</code>
     */
    TRANSPORT_TYPE_DIRECT_ACCESS(3),
    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions using an unknown
     * transport type.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_UNKNOWN = 4;</code>
     */
    TRANSPORT_TYPE_SESSION_UNKNOWN(4),
    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions on an external
     * network (e.g. outside Google Cloud).
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_EXTERNAL = 5;</code>
     */
    TRANSPORT_TYPE_SESSION_EXTERNAL(5),
    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions using CloudPath.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_CLOUD_PATH = 6;</code>
     */
    TRANSPORT_TYPE_SESSION_CLOUD_PATH(6),
    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions using
     * DirectAccess.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_DIRECT_ACCESS = 7;</code>
     */
    TRANSPORT_TYPE_SESSION_DIRECT_ACCESS(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The transport type is unknown.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_UNKNOWN = 0;</code>
     */
    public static final int TRANSPORT_TYPE_UNKNOWN_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The client connected to this peer via an external network
     * (e.g. outside Google Coud).
     * </pre>
     *
     * <code>TRANSPORT_TYPE_EXTERNAL = 1;</code>
     */
    public static final int TRANSPORT_TYPE_EXTERNAL_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The client connected to this peer via CloudPath.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_CLOUD_PATH = 2;</code>
     */
    public static final int TRANSPORT_TYPE_CLOUD_PATH_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The client connected to this peer via DirectAccess.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_DIRECT_ACCESS = 3;</code>
     */
    public static final int TRANSPORT_TYPE_DIRECT_ACCESS_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions using an unknown
     * transport type.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_UNKNOWN = 4;</code>
     */
    public static final int TRANSPORT_TYPE_SESSION_UNKNOWN_VALUE = 4;

    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions on an external
     * network (e.g. outside Google Cloud).
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_EXTERNAL = 5;</code>
     */
    public static final int TRANSPORT_TYPE_SESSION_EXTERNAL_VALUE = 5;

    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions using CloudPath.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_CLOUD_PATH = 6;</code>
     */
    public static final int TRANSPORT_TYPE_SESSION_CLOUD_PATH_VALUE = 6;

    /**
     *
     *
     * <pre>
     * The client connected to this peer via Bigtable Sessions using
     * DirectAccess.
     * </pre>
     *
     * <code>TRANSPORT_TYPE_SESSION_DIRECT_ACCESS = 7;</code>
     */
    public static final int TRANSPORT_TYPE_SESSION_DIRECT_ACCESS_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransportType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TransportType forNumber(int value) {
      switch (value) {
        case 0:
          return TRANSPORT_TYPE_UNKNOWN;
        case 1:
          return TRANSPORT_TYPE_EXTERNAL;
        case 2:
          return TRANSPORT_TYPE_CLOUD_PATH;
        case 3:
          return TRANSPORT_TYPE_DIRECT_ACCESS;
        case 4:
          return TRANSPORT_TYPE_SESSION_UNKNOWN;
        case 5:
          return TRANSPORT_TYPE_SESSION_EXTERNAL;
        case 6:
          return TRANSPORT_TYPE_SESSION_CLOUD_PATH;
        case 7:
          return TRANSPORT_TYPE_SESSION_DIRECT_ACCESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TransportType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TransportType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TransportType>() {
          public TransportType findValueByNumber(int number) {
            return TransportType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.v2.PeerInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final TransportType[] VALUES = values();

    public static TransportType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TransportType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.v2.PeerInfo.TransportType)
  }

  public static final int GOOGLE_FRONTEND_ID_FIELD_NUMBER = 1;
  private long googleFrontendId_ = 0L;

  /**
   *
   *
   * <pre>
   * An opaque identifier for the Google Frontend which serviced this request.
   * Only set when not using DirectAccess.
   * </pre>
   *
   * <code>int64 google_frontend_id = 1;</code>
   *
   * @return The googleFrontendId.
   */
  @java.lang.Override
  public long getGoogleFrontendId() {
    return googleFrontendId_;
  }

  public static final int APPLICATION_FRONTEND_ID_FIELD_NUMBER = 2;
  private long applicationFrontendId_ = 0L;

  /**
   *
   *
   * <pre>
   * An opaque identifier for the application frontend which serviced this
   * request.
   * </pre>
   *
   * <code>int64 application_frontend_id = 2;</code>
   *
   * @return The applicationFrontendId.
   */
  @java.lang.Override
  public long getApplicationFrontendId() {
    return applicationFrontendId_;
  }

  public static final int APPLICATION_FRONTEND_ZONE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object applicationFrontendZone_ = "";

  /**
   *
   *
   * <pre>
   * The Cloud zone of the application frontend that served this request.
   * </pre>
   *
   * <code>string application_frontend_zone = 3;</code>
   *
   * @return The applicationFrontendZone.
   */
  @java.lang.Override
  public java.lang.String getApplicationFrontendZone() {
    java.lang.Object ref = applicationFrontendZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      applicationFrontendZone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Cloud zone of the application frontend that served this request.
   * </pre>
   *
   * <code>string application_frontend_zone = 3;</code>
   *
   * @return The bytes for applicationFrontendZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApplicationFrontendZoneBytes() {
    java.lang.Object ref = applicationFrontendZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      applicationFrontendZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPLICATION_FRONTEND_SUBZONE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object applicationFrontendSubzone_ = "";

  /**
   *
   *
   * <pre>
   * The subzone of the application frontend that served this request, e.g. an
   * identifier for where within the zone the application frontend is.
   * </pre>
   *
   * <code>string application_frontend_subzone = 4;</code>
   *
   * @return The applicationFrontendSubzone.
   */
  @java.lang.Override
  public java.lang.String getApplicationFrontendSubzone() {
    java.lang.Object ref = applicationFrontendSubzone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      applicationFrontendSubzone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The subzone of the application frontend that served this request, e.g. an
   * identifier for where within the zone the application frontend is.
   * </pre>
   *
   * <code>string application_frontend_subzone = 4;</code>
   *
   * @return The bytes for applicationFrontendSubzone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getApplicationFrontendSubzoneBytes() {
    java.lang.Object ref = applicationFrontendSubzone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      applicationFrontendSubzone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSPORT_TYPE_FIELD_NUMBER = 5;
  private int transportType_ = 0;

  /**
   * <code>.google.bigtable.v2.PeerInfo.TransportType transport_type = 5;</code>
   *
   * @return The enum numeric value on the wire for transportType.
   */
  @java.lang.Override
  public int getTransportTypeValue() {
    return transportType_;
  }

  /**
   * <code>.google.bigtable.v2.PeerInfo.TransportType transport_type = 5;</code>
   *
   * @return The transportType.
   */
  @java.lang.Override
  public com.google.bigtable.v2.PeerInfo.TransportType getTransportType() {
    com.google.bigtable.v2.PeerInfo.TransportType result =
        com.google.bigtable.v2.PeerInfo.TransportType.forNumber(transportType_);
    return result == null ? com.google.bigtable.v2.PeerInfo.TransportType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (googleFrontendId_ != 0L) {
      output.writeInt64(1, googleFrontendId_);
    }
    if (applicationFrontendId_ != 0L) {
      output.writeInt64(2, applicationFrontendId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(applicationFrontendZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, applicationFrontendZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(applicationFrontendSubzone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, applicationFrontendSubzone_);
    }
    if (transportType_
        != com.google.bigtable.v2.PeerInfo.TransportType.TRANSPORT_TYPE_UNKNOWN.getNumber()) {
      output.writeEnum(5, transportType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (googleFrontendId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, googleFrontendId_);
    }
    if (applicationFrontendId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, applicationFrontendId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(applicationFrontendZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, applicationFrontendZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(applicationFrontendSubzone_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(4, applicationFrontendSubzone_);
    }
    if (transportType_
        != com.google.bigtable.v2.PeerInfo.TransportType.TRANSPORT_TYPE_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, transportType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.PeerInfo)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.PeerInfo other = (com.google.bigtable.v2.PeerInfo) obj;

    if (getGoogleFrontendId() != other.getGoogleFrontendId()) return false;
    if (getApplicationFrontendId() != other.getApplicationFrontendId()) return false;
    if (!getApplicationFrontendZone().equals(other.getApplicationFrontendZone())) return false;
    if (!getApplicationFrontendSubzone().equals(other.getApplicationFrontendSubzone()))
      return false;
    if (transportType_ != other.transportType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + GOOGLE_FRONTEND_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGoogleFrontendId());
    hash = (37 * hash) + APPLICATION_FRONTEND_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getApplicationFrontendId());
    hash = (37 * hash) + APPLICATION_FRONTEND_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getApplicationFrontendZone().hashCode();
    hash = (37 * hash) + APPLICATION_FRONTEND_SUBZONE_FIELD_NUMBER;
    hash = (53 * hash) + getApplicationFrontendSubzone().hashCode();
    hash = (37 * hash) + TRANSPORT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + transportType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.PeerInfo parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.PeerInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.PeerInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.PeerInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * PeerInfo contains information about the peer that the client is
   * connecting to.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.PeerInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.PeerInfo)
      com.google.bigtable.v2.PeerInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.PeerInfoProto
          .internal_static_google_bigtable_v2_PeerInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.PeerInfoProto
          .internal_static_google_bigtable_v2_PeerInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.PeerInfo.class, com.google.bigtable.v2.PeerInfo.Builder.class);
    }

    // Construct using com.google.bigtable.v2.PeerInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      googleFrontendId_ = 0L;
      applicationFrontendId_ = 0L;
      applicationFrontendZone_ = "";
      applicationFrontendSubzone_ = "";
      transportType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.PeerInfoProto
          .internal_static_google_bigtable_v2_PeerInfo_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.PeerInfo getDefaultInstanceForType() {
      return com.google.bigtable.v2.PeerInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.PeerInfo build() {
      com.google.bigtable.v2.PeerInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.PeerInfo buildPartial() {
      com.google.bigtable.v2.PeerInfo result = new com.google.bigtable.v2.PeerInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.PeerInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.googleFrontendId_ = googleFrontendId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.applicationFrontendId_ = applicationFrontendId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.applicationFrontendZone_ = applicationFrontendZone_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.applicationFrontendSubzone_ = applicationFrontendSubzone_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.transportType_ = transportType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.PeerInfo) {
        return mergeFrom((com.google.bigtable.v2.PeerInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.PeerInfo other) {
      if (other == com.google.bigtable.v2.PeerInfo.getDefaultInstance()) return this;
      if (other.getGoogleFrontendId() != 0L) {
        setGoogleFrontendId(other.getGoogleFrontendId());
      }
      if (other.getApplicationFrontendId() != 0L) {
        setApplicationFrontendId(other.getApplicationFrontendId());
      }
      if (!other.getApplicationFrontendZone().isEmpty()) {
        applicationFrontendZone_ = other.applicationFrontendZone_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getApplicationFrontendSubzone().isEmpty()) {
        applicationFrontendSubzone_ = other.applicationFrontendSubzone_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.transportType_ != 0) {
        setTransportTypeValue(other.getTransportTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                googleFrontendId_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                applicationFrontendId_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                applicationFrontendZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                applicationFrontendSubzone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                transportType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long googleFrontendId_;

    /**
     *
     *
     * <pre>
     * An opaque identifier for the Google Frontend which serviced this request.
     * Only set when not using DirectAccess.
     * </pre>
     *
     * <code>int64 google_frontend_id = 1;</code>
     *
     * @return The googleFrontendId.
     */
    @java.lang.Override
    public long getGoogleFrontendId() {
      return googleFrontendId_;
    }

    /**
     *
     *
     * <pre>
     * An opaque identifier for the Google Frontend which serviced this request.
     * Only set when not using DirectAccess.
     * </pre>
     *
     * <code>int64 google_frontend_id = 1;</code>
     *
     * @param value The googleFrontendId to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleFrontendId(long value) {

      googleFrontendId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An opaque identifier for the Google Frontend which serviced this request.
     * Only set when not using DirectAccess.
     * </pre>
     *
     * <code>int64 google_frontend_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoogleFrontendId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      googleFrontendId_ = 0L;
      onChanged();
      return this;
    }

    private long applicationFrontendId_;

    /**
     *
     *
     * <pre>
     * An opaque identifier for the application frontend which serviced this
     * request.
     * </pre>
     *
     * <code>int64 application_frontend_id = 2;</code>
     *
     * @return The applicationFrontendId.
     */
    @java.lang.Override
    public long getApplicationFrontendId() {
      return applicationFrontendId_;
    }

    /**
     *
     *
     * <pre>
     * An opaque identifier for the application frontend which serviced this
     * request.
     * </pre>
     *
     * <code>int64 application_frontend_id = 2;</code>
     *
     * @param value The applicationFrontendId to set.
     * @return This builder for chaining.
     */
    public Builder setApplicationFrontendId(long value) {

      applicationFrontendId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An opaque identifier for the application frontend which serviced this
     * request.
     * </pre>
     *
     * <code>int64 application_frontend_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApplicationFrontendId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      applicationFrontendId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object applicationFrontendZone_ = "";

    /**
     *
     *
     * <pre>
     * The Cloud zone of the application frontend that served this request.
     * </pre>
     *
     * <code>string application_frontend_zone = 3;</code>
     *
     * @return The applicationFrontendZone.
     */
    public java.lang.String getApplicationFrontendZone() {
      java.lang.Object ref = applicationFrontendZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        applicationFrontendZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud zone of the application frontend that served this request.
     * </pre>
     *
     * <code>string application_frontend_zone = 3;</code>
     *
     * @return The bytes for applicationFrontendZone.
     */
    public com.google.protobuf.ByteString getApplicationFrontendZoneBytes() {
      java.lang.Object ref = applicationFrontendZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        applicationFrontendZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Cloud zone of the application frontend that served this request.
     * </pre>
     *
     * <code>string application_frontend_zone = 3;</code>
     *
     * @param value The applicationFrontendZone to set.
     * @return This builder for chaining.
     */
    public Builder setApplicationFrontendZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      applicationFrontendZone_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud zone of the application frontend that served this request.
     * </pre>
     *
     * <code>string application_frontend_zone = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApplicationFrontendZone() {
      applicationFrontendZone_ = getDefaultInstance().getApplicationFrontendZone();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Cloud zone of the application frontend that served this request.
     * </pre>
     *
     * <code>string application_frontend_zone = 3;</code>
     *
     * @param value The bytes for applicationFrontendZone to set.
     * @return This builder for chaining.
     */
    public Builder setApplicationFrontendZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      applicationFrontendZone_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object applicationFrontendSubzone_ = "";

    /**
     *
     *
     * <pre>
     * The subzone of the application frontend that served this request, e.g. an
     * identifier for where within the zone the application frontend is.
     * </pre>
     *
     * <code>string application_frontend_subzone = 4;</code>
     *
     * @return The applicationFrontendSubzone.
     */
    public java.lang.String getApplicationFrontendSubzone() {
      java.lang.Object ref = applicationFrontendSubzone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        applicationFrontendSubzone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The subzone of the application frontend that served this request, e.g. an
     * identifier for where within the zone the application frontend is.
     * </pre>
     *
     * <code>string application_frontend_subzone = 4;</code>
     *
     * @return The bytes for applicationFrontendSubzone.
     */
    public com.google.protobuf.ByteString getApplicationFrontendSubzoneBytes() {
      java.lang.Object ref = applicationFrontendSubzone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        applicationFrontendSubzone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The subzone of the application frontend that served this request, e.g. an
     * identifier for where within the zone the application frontend is.
     * </pre>
     *
     * <code>string application_frontend_subzone = 4;</code>
     *
     * @param value The applicationFrontendSubzone to set.
     * @return This builder for chaining.
     */
    public Builder setApplicationFrontendSubzone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      applicationFrontendSubzone_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The subzone of the application frontend that served this request, e.g. an
     * identifier for where within the zone the application frontend is.
     * </pre>
     *
     * <code>string application_frontend_subzone = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApplicationFrontendSubzone() {
      applicationFrontendSubzone_ = getDefaultInstance().getApplicationFrontendSubzone();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The subzone of the application frontend that served this request, e.g. an
     * identifier for where within the zone the application frontend is.
     * </pre>
     *
     * <code>string application_frontend_subzone = 4;</code>
     *
     * @param value The bytes for applicationFrontendSubzone to set.
     * @return This builder for chaining.
     */
    public Builder setApplicationFrontendSubzoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      applicationFrontendSubzone_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int transportType_ = 0;

    /**
     * <code>.google.bigtable.v2.PeerInfo.TransportType transport_type = 5;</code>
     *
     * @return The enum numeric value on the wire for transportType.
     */
    @java.lang.Override
    public int getTransportTypeValue() {
      return transportType_;
    }

    /**
     * <code>.google.bigtable.v2.PeerInfo.TransportType transport_type = 5;</code>
     *
     * @param value The enum numeric value on the wire for transportType to set.
     * @return This builder for chaining.
     */
    public Builder setTransportTypeValue(int value) {
      transportType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     * <code>.google.bigtable.v2.PeerInfo.TransportType transport_type = 5;</code>
     *
     * @return The transportType.
     */
    @java.lang.Override
    public com.google.bigtable.v2.PeerInfo.TransportType getTransportType() {
      com.google.bigtable.v2.PeerInfo.TransportType result =
          com.google.bigtable.v2.PeerInfo.TransportType.forNumber(transportType_);
      return result == null ? com.google.bigtable.v2.PeerInfo.TransportType.UNRECOGNIZED : result;
    }

    /**
     * <code>.google.bigtable.v2.PeerInfo.TransportType transport_type = 5;</code>
     *
     * @param value The transportType to set.
     * @return This builder for chaining.
     */
    public Builder setTransportType(com.google.bigtable.v2.PeerInfo.TransportType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      transportType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     * <code>.google.bigtable.v2.PeerInfo.TransportType transport_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransportType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      transportType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.PeerInfo)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.PeerInfo)
  private static final com.google.bigtable.v2.PeerInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.PeerInfo();
  }

  public static com.google.bigtable.v2.PeerInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PeerInfo> PARSER =
      new com.google.protobuf.AbstractParser<PeerInfo>() {
        @java.lang.Override
        public PeerInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PeerInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PeerInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.PeerInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
