/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * NOTE: This API is intended to be used by Apache Beam BigtableIO.
 * Response message for Bigtable.ReadChangeStream.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse}
 */
public final class ReadChangeStreamResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadChangeStreamResponse)
    ReadChangeStreamResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ReadChangeStreamResponse.newBuilder() to construct.
  private ReadChangeStreamResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadChangeStreamResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadChangeStreamResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadChangeStreamResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadChangeStreamResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.ReadChangeStreamResponse.class,
            com.google.bigtable.v2.ReadChangeStreamResponse.Builder.class);
  }

  public interface MutationChunkOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If set, then the mutation is a `SetCell` with a chunked value across
     * multiple messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
     * </code>
     *
     * @return Whether the chunkInfo field is set.
     */
    boolean hasChunkInfo();

    /**
     *
     *
     * <pre>
     * If set, then the mutation is a `SetCell` with a chunked value across
     * multiple messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
     * </code>
     *
     * @return The chunkInfo.
     */
    com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo getChunkInfo();

    /**
     *
     *
     * <pre>
     * If set, then the mutation is a `SetCell` with a chunked value across
     * multiple messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
     * </code>
     */
    com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfoOrBuilder
        getChunkInfoOrBuilder();

    /**
     *
     *
     * <pre>
     * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
     * 0), ignore all fields except the `SetCell`'s value and merge it with
     * the previous message by concatenating the value fields.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
     *
     * @return Whether the mutation field is set.
     */
    boolean hasMutation();

    /**
     *
     *
     * <pre>
     * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
     * 0), ignore all fields except the `SetCell`'s value and merge it with
     * the previous message by concatenating the value fields.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
     *
     * @return The mutation.
     */
    com.google.bigtable.v2.Mutation getMutation();

    /**
     *
     *
     * <pre>
     * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
     * 0), ignore all fields except the `SetCell`'s value and merge it with
     * the previous message by concatenating the value fields.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
     */
    com.google.bigtable.v2.MutationOrBuilder getMutationOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A partial or complete mutation.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.MutationChunk}
   */
  public static final class MutationChunk extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk)
      MutationChunkOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MutationChunk.newBuilder() to construct.
    private MutationChunk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MutationChunk() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MutationChunk();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.class,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder.class);
    }

    public interface ChunkInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The total value size of all the chunks that make up the `SetCell`.
       * </pre>
       *
       * <code>int32 chunked_value_size = 1;</code>
       *
       * @return The chunkedValueSize.
       */
      int getChunkedValueSize();

      /**
       *
       *
       * <pre>
       * The byte offset of this chunk into the total value size of the
       * mutation.
       * </pre>
       *
       * <code>int32 chunked_value_offset = 2;</code>
       *
       * @return The chunkedValueOffset.
       */
      int getChunkedValueOffset();

      /**
       *
       *
       * <pre>
       * When true, this is the last chunk of a chunked `SetCell`.
       * </pre>
       *
       * <code>bool last_chunk = 3;</code>
       *
       * @return The lastChunk.
       */
      boolean getLastChunk();
    }

    /**
     *
     *
     * <pre>
     * Information about the chunking of this mutation.
     * Only `SetCell` mutations can be chunked, and all chunks for a `SetCell`
     * will be delivered contiguously with no other mutation types interleaved.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo}
     */
    public static final class ChunkInfo extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo)
        ChunkInfoOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ChunkInfo.newBuilder() to construct.
      private ChunkInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ChunkInfo() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ChunkInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_ChunkInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_ChunkInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.class,
                com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.Builder
                    .class);
      }

      public static final int CHUNKED_VALUE_SIZE_FIELD_NUMBER = 1;
      private int chunkedValueSize_ = 0;

      /**
       *
       *
       * <pre>
       * The total value size of all the chunks that make up the `SetCell`.
       * </pre>
       *
       * <code>int32 chunked_value_size = 1;</code>
       *
       * @return The chunkedValueSize.
       */
      @java.lang.Override
      public int getChunkedValueSize() {
        return chunkedValueSize_;
      }

      public static final int CHUNKED_VALUE_OFFSET_FIELD_NUMBER = 2;
      private int chunkedValueOffset_ = 0;

      /**
       *
       *
       * <pre>
       * The byte offset of this chunk into the total value size of the
       * mutation.
       * </pre>
       *
       * <code>int32 chunked_value_offset = 2;</code>
       *
       * @return The chunkedValueOffset.
       */
      @java.lang.Override
      public int getChunkedValueOffset() {
        return chunkedValueOffset_;
      }

      public static final int LAST_CHUNK_FIELD_NUMBER = 3;
      private boolean lastChunk_ = false;

      /**
       *
       *
       * <pre>
       * When true, this is the last chunk of a chunked `SetCell`.
       * </pre>
       *
       * <code>bool last_chunk = 3;</code>
       *
       * @return The lastChunk.
       */
      @java.lang.Override
      public boolean getLastChunk() {
        return lastChunk_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (chunkedValueSize_ != 0) {
          output.writeInt32(1, chunkedValueSize_);
        }
        if (chunkedValueOffset_ != 0) {
          output.writeInt32(2, chunkedValueOffset_);
        }
        if (lastChunk_ != false) {
          output.writeBool(3, lastChunk_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (chunkedValueSize_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, chunkedValueSize_);
        }
        if (chunkedValueOffset_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, chunkedValueOffset_);
        }
        if (lastChunk_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, lastChunk_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo)) {
          return super.equals(obj);
        }
        com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo other =
            (com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo) obj;

        if (getChunkedValueSize() != other.getChunkedValueSize()) return false;
        if (getChunkedValueOffset() != other.getChunkedValueOffset()) return false;
        if (getLastChunk() != other.getLastChunk()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CHUNKED_VALUE_SIZE_FIELD_NUMBER;
        hash = (53 * hash) + getChunkedValueSize();
        hash = (37 * hash) + CHUNKED_VALUE_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getChunkedValueOffset();
        hash = (37 * hash) + LAST_CHUNK_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLastChunk());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Information about the chunking of this mutation.
       * Only `SetCell` mutations can be chunked, and all chunks for a `SetCell`
       * will be delivered contiguously with no other mutation types interleaved.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo)
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.v2.BigtableProto
              .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_ChunkInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.v2.BigtableProto
              .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_ChunkInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.class,
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.Builder
                      .class);
        }

        // Construct using
        // com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          chunkedValueSize_ = 0;
          chunkedValueOffset_ = 0;
          lastChunk_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.v2.BigtableProto
              .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_ChunkInfo_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
            getDefaultInstanceForType() {
          return com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo build() {
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
            buildPartial() {
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo result =
              new com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.chunkedValueSize_ = chunkedValueSize_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.chunkedValueOffset_ = chunkedValueOffset_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.lastChunk_ = lastChunk_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo) {
            return mergeFrom(
                (com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo other) {
          if (other
              == com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
                  .getDefaultInstance()) return this;
          if (other.getChunkedValueSize() != 0) {
            setChunkedValueSize(other.getChunkedValueSize());
          }
          if (other.getChunkedValueOffset() != 0) {
            setChunkedValueOffset(other.getChunkedValueOffset());
          }
          if (other.getLastChunk() != false) {
            setLastChunk(other.getLastChunk());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    chunkedValueSize_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    chunkedValueOffset_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    lastChunk_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int chunkedValueSize_;

        /**
         *
         *
         * <pre>
         * The total value size of all the chunks that make up the `SetCell`.
         * </pre>
         *
         * <code>int32 chunked_value_size = 1;</code>
         *
         * @return The chunkedValueSize.
         */
        @java.lang.Override
        public int getChunkedValueSize() {
          return chunkedValueSize_;
        }

        /**
         *
         *
         * <pre>
         * The total value size of all the chunks that make up the `SetCell`.
         * </pre>
         *
         * <code>int32 chunked_value_size = 1;</code>
         *
         * @param value The chunkedValueSize to set.
         * @return This builder for chaining.
         */
        public Builder setChunkedValueSize(int value) {

          chunkedValueSize_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The total value size of all the chunks that make up the `SetCell`.
         * </pre>
         *
         * <code>int32 chunked_value_size = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearChunkedValueSize() {
          bitField0_ = (bitField0_ & ~0x00000001);
          chunkedValueSize_ = 0;
          onChanged();
          return this;
        }

        private int chunkedValueOffset_;

        /**
         *
         *
         * <pre>
         * The byte offset of this chunk into the total value size of the
         * mutation.
         * </pre>
         *
         * <code>int32 chunked_value_offset = 2;</code>
         *
         * @return The chunkedValueOffset.
         */
        @java.lang.Override
        public int getChunkedValueOffset() {
          return chunkedValueOffset_;
        }

        /**
         *
         *
         * <pre>
         * The byte offset of this chunk into the total value size of the
         * mutation.
         * </pre>
         *
         * <code>int32 chunked_value_offset = 2;</code>
         *
         * @param value The chunkedValueOffset to set.
         * @return This builder for chaining.
         */
        public Builder setChunkedValueOffset(int value) {

          chunkedValueOffset_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The byte offset of this chunk into the total value size of the
         * mutation.
         * </pre>
         *
         * <code>int32 chunked_value_offset = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearChunkedValueOffset() {
          bitField0_ = (bitField0_ & ~0x00000002);
          chunkedValueOffset_ = 0;
          onChanged();
          return this;
        }

        private boolean lastChunk_;

        /**
         *
         *
         * <pre>
         * When true, this is the last chunk of a chunked `SetCell`.
         * </pre>
         *
         * <code>bool last_chunk = 3;</code>
         *
         * @return The lastChunk.
         */
        @java.lang.Override
        public boolean getLastChunk() {
          return lastChunk_;
        }

        /**
         *
         *
         * <pre>
         * When true, this is the last chunk of a chunked `SetCell`.
         * </pre>
         *
         * <code>bool last_chunk = 3;</code>
         *
         * @param value The lastChunk to set.
         * @return This builder for chaining.
         */
        public Builder setLastChunk(boolean value) {

          lastChunk_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * When true, this is the last chunk of a chunked `SetCell`.
         * </pre>
         *
         * <code>bool last_chunk = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLastChunk() {
          bitField0_ = (bitField0_ & ~0x00000004);
          lastChunk_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo)
      private static final com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo();
      }

      public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ChunkInfo> PARSER =
          new com.google.protobuf.AbstractParser<ChunkInfo>() {
            @java.lang.Override
            public ChunkInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ChunkInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ChunkInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CHUNK_INFO_FIELD_NUMBER = 1;
    private com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunkInfo_;

    /**
     *
     *
     * <pre>
     * If set, then the mutation is a `SetCell` with a chunked value across
     * multiple messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
     * </code>
     *
     * @return Whether the chunkInfo field is set.
     */
    @java.lang.Override
    public boolean hasChunkInfo() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * If set, then the mutation is a `SetCell` with a chunked value across
     * multiple messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
     * </code>
     *
     * @return The chunkInfo.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo getChunkInfo() {
      return chunkInfo_ == null
          ? com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
              .getDefaultInstance()
          : chunkInfo_;
    }

    /**
     *
     *
     * <pre>
     * If set, then the mutation is a `SetCell` with a chunked value across
     * multiple messages.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfoOrBuilder
        getChunkInfoOrBuilder() {
      return chunkInfo_ == null
          ? com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
              .getDefaultInstance()
          : chunkInfo_;
    }

    public static final int MUTATION_FIELD_NUMBER = 2;
    private com.google.bigtable.v2.Mutation mutation_;

    /**
     *
     *
     * <pre>
     * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
     * 0), ignore all fields except the `SetCell`'s value and merge it with
     * the previous message by concatenating the value fields.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
     *
     * @return Whether the mutation field is set.
     */
    @java.lang.Override
    public boolean hasMutation() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
     * 0), ignore all fields except the `SetCell`'s value and merge it with
     * the previous message by concatenating the value fields.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
     *
     * @return The mutation.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation getMutation() {
      return mutation_ == null ? com.google.bigtable.v2.Mutation.getDefaultInstance() : mutation_;
    }

    /**
     *
     *
     * <pre>
     * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
     * 0), ignore all fields except the `SetCell`'s value and merge it with
     * the previous message by concatenating the value fields.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.MutationOrBuilder getMutationOrBuilder() {
      return mutation_ == null ? com.google.bigtable.v2.Mutation.getDefaultInstance() : mutation_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getChunkInfo());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getMutation());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getChunkInfo());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMutation());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk other =
          (com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk) obj;

      if (hasChunkInfo() != other.hasChunkInfo()) return false;
      if (hasChunkInfo()) {
        if (!getChunkInfo().equals(other.getChunkInfo())) return false;
      }
      if (hasMutation() != other.hasMutation()) return false;
      if (hasMutation()) {
        if (!getMutation().equals(other.getMutation())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasChunkInfo()) {
        hash = (37 * hash) + CHUNK_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getChunkInfo().hashCode();
      }
      if (hasMutation()) {
        hash = (37 * hash) + MUTATION_FIELD_NUMBER;
        hash = (53 * hash) + getMutation().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A partial or complete mutation.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.MutationChunk}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk)
        com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.class,
                com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder.class);
      }

      // Construct using com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getChunkInfoFieldBuilder();
          getMutationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        chunkInfo_ = null;
        if (chunkInfoBuilder_ != null) {
          chunkInfoBuilder_.dispose();
          chunkInfoBuilder_ = null;
        }
        mutation_ = null;
        if (mutationBuilder_ != null) {
          mutationBuilder_.dispose();
          mutationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_MutationChunk_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk
          getDefaultInstanceForType() {
        return com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk build() {
        com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk buildPartial() {
        com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk result =
            new com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.chunkInfo_ = chunkInfoBuilder_ == null ? chunkInfo_ : chunkInfoBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.mutation_ = mutationBuilder_ == null ? mutation_ : mutationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk) {
          return mergeFrom((com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk other) {
        if (other
            == com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.getDefaultInstance())
          return this;
        if (other.hasChunkInfo()) {
          mergeChunkInfo(other.getChunkInfo());
        }
        if (other.hasMutation()) {
          mergeMutation(other.getMutation());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getChunkInfoFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getMutationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunkInfo_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.Builder,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfoOrBuilder>
          chunkInfoBuilder_;

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       *
       * @return Whether the chunkInfo field is set.
       */
      public boolean hasChunkInfo() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       *
       * @return The chunkInfo.
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
          getChunkInfo() {
        if (chunkInfoBuilder_ == null) {
          return chunkInfo_ == null
              ? com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
                  .getDefaultInstance()
              : chunkInfo_;
        } else {
          return chunkInfoBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       */
      public Builder setChunkInfo(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo value) {
        if (chunkInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          chunkInfo_ = value;
        } else {
          chunkInfoBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       */
      public Builder setChunkInfo(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.Builder
              builderForValue) {
        if (chunkInfoBuilder_ == null) {
          chunkInfo_ = builderForValue.build();
        } else {
          chunkInfoBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       */
      public Builder mergeChunkInfo(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo value) {
        if (chunkInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && chunkInfo_ != null
              && chunkInfo_
                  != com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
                      .getDefaultInstance()) {
            getChunkInfoBuilder().mergeFrom(value);
          } else {
            chunkInfo_ = value;
          }
        } else {
          chunkInfoBuilder_.mergeFrom(value);
        }
        if (chunkInfo_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       */
      public Builder clearChunkInfo() {
        bitField0_ = (bitField0_ & ~0x00000001);
        chunkInfo_ = null;
        if (chunkInfoBuilder_ != null) {
          chunkInfoBuilder_.dispose();
          chunkInfoBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.Builder
          getChunkInfoBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getChunkInfoFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfoOrBuilder
          getChunkInfoOrBuilder() {
        if (chunkInfoBuilder_ != null) {
          return chunkInfoBuilder_.getMessageOrBuilder();
        } else {
          return chunkInfo_ == null
              ? com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
                  .getDefaultInstance()
              : chunkInfo_;
        }
      }

      /**
       *
       *
       * <pre>
       * If set, then the mutation is a `SetCell` with a chunked value across
       * multiple messages.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo chunk_info = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.Builder,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfoOrBuilder>
          getChunkInfoFieldBuilder() {
        if (chunkInfoBuilder_ == null) {
          chunkInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo,
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo.Builder,
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfoOrBuilder>(
                  getChunkInfo(), getParentForChildren(), isClean());
          chunkInfo_ = null;
        }
        return chunkInfoBuilder_;
      }

      private com.google.bigtable.v2.Mutation mutation_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Mutation,
              com.google.bigtable.v2.Mutation.Builder,
              com.google.bigtable.v2.MutationOrBuilder>
          mutationBuilder_;

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       *
       * @return Whether the mutation field is set.
       */
      public boolean hasMutation() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       *
       * @return The mutation.
       */
      public com.google.bigtable.v2.Mutation getMutation() {
        if (mutationBuilder_ == null) {
          return mutation_ == null
              ? com.google.bigtable.v2.Mutation.getDefaultInstance()
              : mutation_;
        } else {
          return mutationBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       */
      public Builder setMutation(com.google.bigtable.v2.Mutation value) {
        if (mutationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mutation_ = value;
        } else {
          mutationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       */
      public Builder setMutation(com.google.bigtable.v2.Mutation.Builder builderForValue) {
        if (mutationBuilder_ == null) {
          mutation_ = builderForValue.build();
        } else {
          mutationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       */
      public Builder mergeMutation(com.google.bigtable.v2.Mutation value) {
        if (mutationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && mutation_ != null
              && mutation_ != com.google.bigtable.v2.Mutation.getDefaultInstance()) {
            getMutationBuilder().mergeFrom(value);
          } else {
            mutation_ = value;
          }
        } else {
          mutationBuilder_.mergeFrom(value);
        }
        if (mutation_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       */
      public Builder clearMutation() {
        bitField0_ = (bitField0_ & ~0x00000002);
        mutation_ = null;
        if (mutationBuilder_ != null) {
          mutationBuilder_.dispose();
          mutationBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       */
      public com.google.bigtable.v2.Mutation.Builder getMutationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMutationFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       */
      public com.google.bigtable.v2.MutationOrBuilder getMutationOrBuilder() {
        if (mutationBuilder_ != null) {
          return mutationBuilder_.getMessageOrBuilder();
        } else {
          return mutation_ == null
              ? com.google.bigtable.v2.Mutation.getDefaultInstance()
              : mutation_;
        }
      }

      /**
       *
       *
       * <pre>
       * If this is a continuation of a chunked message (`chunked_value_offset` &gt;
       * 0), ignore all fields except the `SetCell`'s value and merge it with
       * the previous message by concatenating the value fields.
       * </pre>
       *
       * <code>.google.bigtable.v2.Mutation mutation = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Mutation,
              com.google.bigtable.v2.Mutation.Builder,
              com.google.bigtable.v2.MutationOrBuilder>
          getMutationFieldBuilder() {
        if (mutationBuilder_ == null) {
          mutationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.Mutation,
                  com.google.bigtable.v2.Mutation.Builder,
                  com.google.bigtable.v2.MutationOrBuilder>(
                  getMutation(), getParentForChildren(), isClean());
          mutation_ = null;
        }
        return mutationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadChangeStreamResponse.MutationChunk)
    private static final com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk();
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MutationChunk> PARSER =
        new com.google.protobuf.AbstractParser<MutationChunk>() {
          @java.lang.Override
          public MutationChunk parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MutationChunk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MutationChunk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataChangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.ReadChangeStreamResponse.DataChange)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The type of the mutation.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();

    /**
     *
     *
     * <pre>
     * The type of the mutation.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
     *
     * @return The type.
     */
    com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type getType();

    /**
     *
     *
     * <pre>
     * The cluster where the mutation was applied.
     * Not set when `type` is `GARBAGE_COLLECTION`.
     * </pre>
     *
     * <code>string source_cluster_id = 2;</code>
     *
     * @return The sourceClusterId.
     */
    java.lang.String getSourceClusterId();

    /**
     *
     *
     * <pre>
     * The cluster where the mutation was applied.
     * Not set when `type` is `GARBAGE_COLLECTION`.
     * </pre>
     *
     * <code>string source_cluster_id = 2;</code>
     *
     * @return The bytes for sourceClusterId.
     */
    com.google.protobuf.ByteString getSourceClusterIdBytes();

    /**
     *
     *
     * <pre>
     * The row key for all mutations that are part of this `DataChange`.
     * If the `DataChange` is chunked across multiple messages, then this field
     * will only be set for the first message.
     * </pre>
     *
     * <code>bytes row_key = 3;</code>
     *
     * @return The rowKey.
     */
    com.google.protobuf.ByteString getRowKey();

    /**
     *
     *
     * <pre>
     * The timestamp at which the mutation was applied on the Bigtable server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     *
     * @return Whether the commitTimestamp field is set.
     */
    boolean hasCommitTimestamp();

    /**
     *
     *
     * <pre>
     * The timestamp at which the mutation was applied on the Bigtable server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     *
     * @return The commitTimestamp.
     */
    com.google.protobuf.Timestamp getCommitTimestamp();

    /**
     *
     *
     * <pre>
     * The timestamp at which the mutation was applied on the Bigtable server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * A value that lets stream consumers reconstruct Bigtable's
     * conflict resolution semantics.
     * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
     * In the event that the same row key, column family, column qualifier,
     * timestamp are modified on different clusters at the same
     * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
     * one chosen for the eventually consistent state of the system.
     * </pre>
     *
     * <code>int32 tiebreaker = 5;</code>
     *
     * @return The tiebreaker.
     */
    int getTiebreaker();

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    java.util.List<com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk> getChunksList();

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk getChunks(int index);

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    int getChunksCount();

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    java.util.List<? extends com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder>
        getChunksOrBuilderList();

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder getChunksOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * When true, indicates that the entire `DataChange` has been read
     * and the client can safely process the message.
     * </pre>
     *
     * <code>bool done = 8;</code>
     *
     * @return The done.
     */
    boolean getDone();

    /**
     *
     *
     * <pre>
     * An encoded position for this stream's partition to restart reading from.
     * This token is for the StreamPartition from the request.
     * </pre>
     *
     * <code>string token = 9;</code>
     *
     * @return The token.
     */
    java.lang.String getToken();

    /**
     *
     *
     * <pre>
     * An encoded position for this stream's partition to restart reading from.
     * This token is for the StreamPartition from the request.
     * </pre>
     *
     * <code>string token = 9;</code>
     *
     * @return The bytes for token.
     */
    com.google.protobuf.ByteString getTokenBytes();

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     *
     * @return Whether the estimatedLowWatermark field is set.
     */
    boolean hasEstimatedLowWatermark();

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     *
     * @return The estimatedLowWatermark.
     */
    com.google.protobuf.Timestamp getEstimatedLowWatermark();

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEstimatedLowWatermarkOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A message corresponding to one or more mutations to the partition
   * being streamed. A single logical `DataChange` message may also be split
   * across a sequence of multiple individual messages. Messages other than
   * the first in a sequence will only have the `type` and `chunks` fields
   * populated, with the final message in the sequence also containing `done`
   * set to true.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.DataChange}
   */
  public static final class DataChange extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadChangeStreamResponse.DataChange)
      DataChangeOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DataChange.newBuilder() to construct.
    private DataChange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataChange() {
      type_ = 0;
      sourceClusterId_ = "";
      rowKey_ = com.google.protobuf.ByteString.EMPTY;
      chunks_ = java.util.Collections.emptyList();
      token_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataChange();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_DataChange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_DataChange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.class,
              com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of mutation.
     * </pre>
     *
     * Protobuf enum {@code google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The type is unspecified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * A user-initiated mutation.
       * </pre>
       *
       * <code>USER = 1;</code>
       */
      USER(1),
      /**
       *
       *
       * <pre>
       * A system-initiated mutation as part of garbage collection.
       * https://cloud.google.com/bigtable/docs/garbage-collection
       * </pre>
       *
       * <code>GARBAGE_COLLECTION = 2;</code>
       */
      GARBAGE_COLLECTION(2),
      /**
       *
       *
       * <pre>
       * This is a continuation of a multi-message change.
       * </pre>
       *
       * <code>CONTINUATION = 3;</code>
       */
      CONTINUATION(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The type is unspecified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * A user-initiated mutation.
       * </pre>
       *
       * <code>USER = 1;</code>
       */
      public static final int USER_VALUE = 1;

      /**
       *
       *
       * <pre>
       * A system-initiated mutation as part of garbage collection.
       * https://cloud.google.com/bigtable/docs/garbage-collection
       * </pre>
       *
       * <code>GARBAGE_COLLECTION = 2;</code>
       */
      public static final int GARBAGE_COLLECTION_VALUE = 2;

      /**
       *
       *
       * <pre>
       * This is a continuation of a multi-message change.
       * </pre>
       *
       * <code>CONTINUATION = 3;</code>
       */
      public static final int CONTINUATION_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return USER;
          case 2:
            return GARBAGE_COLLECTION;
          case 3:
            return CONTINUATION;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The type of the mutation.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type of the mutation.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type getType() {
      com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type result =
          com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type.forNumber(type_);
      return result == null
          ? com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type.UNRECOGNIZED
          : result;
    }

    public static final int SOURCE_CLUSTER_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceClusterId_ = "";

    /**
     *
     *
     * <pre>
     * The cluster where the mutation was applied.
     * Not set when `type` is `GARBAGE_COLLECTION`.
     * </pre>
     *
     * <code>string source_cluster_id = 2;</code>
     *
     * @return The sourceClusterId.
     */
    @java.lang.Override
    public java.lang.String getSourceClusterId() {
      java.lang.Object ref = sourceClusterId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceClusterId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The cluster where the mutation was applied.
     * Not set when `type` is `GARBAGE_COLLECTION`.
     * </pre>
     *
     * <code>string source_cluster_id = 2;</code>
     *
     * @return The bytes for sourceClusterId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceClusterIdBytes() {
      java.lang.Object ref = sourceClusterId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceClusterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROW_KEY_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString rowKey_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * The row key for all mutations that are part of this `DataChange`.
     * If the `DataChange` is chunked across multiple messages, then this field
     * will only be set for the first message.
     * </pre>
     *
     * <code>bytes row_key = 3;</code>
     *
     * @return The rowKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRowKey() {
      return rowKey_;
    }

    public static final int COMMIT_TIMESTAMP_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp commitTimestamp_;

    /**
     *
     *
     * <pre>
     * The timestamp at which the mutation was applied on the Bigtable server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     *
     * @return Whether the commitTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasCommitTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The timestamp at which the mutation was applied on the Bigtable server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     *
     * @return The commitTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCommitTimestamp() {
      return commitTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : commitTimestamp_;
    }

    /**
     *
     *
     * <pre>
     * The timestamp at which the mutation was applied on the Bigtable server.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
      return commitTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : commitTimestamp_;
    }

    public static final int TIEBREAKER_FIELD_NUMBER = 5;
    private int tiebreaker_ = 0;

    /**
     *
     *
     * <pre>
     * A value that lets stream consumers reconstruct Bigtable's
     * conflict resolution semantics.
     * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
     * In the event that the same row key, column family, column qualifier,
     * timestamp are modified on different clusters at the same
     * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
     * one chosen for the eventually consistent state of the system.
     * </pre>
     *
     * <code>int32 tiebreaker = 5;</code>
     *
     * @return The tiebreaker.
     */
    @java.lang.Override
    public int getTiebreaker() {
      return tiebreaker_;
    }

    public static final int CHUNKS_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private java.util.List<com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk> chunks_;

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk>
        getChunksList() {
      return chunks_;
    }

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder>
        getChunksOrBuilderList() {
      return chunks_;
    }

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    @java.lang.Override
    public int getChunksCount() {
      return chunks_.size();
    }

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk getChunks(int index) {
      return chunks_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder
        getChunksOrBuilder(int index) {
      return chunks_.get(index);
    }

    public static final int DONE_FIELD_NUMBER = 8;
    private boolean done_ = false;

    /**
     *
     *
     * <pre>
     * When true, indicates that the entire `DataChange` has been read
     * and the client can safely process the message.
     * </pre>
     *
     * <code>bool done = 8;</code>
     *
     * @return The done.
     */
    @java.lang.Override
    public boolean getDone() {
      return done_;
    }

    public static final int TOKEN_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private volatile java.lang.Object token_ = "";

    /**
     *
     *
     * <pre>
     * An encoded position for this stream's partition to restart reading from.
     * This token is for the StreamPartition from the request.
     * </pre>
     *
     * <code>string token = 9;</code>
     *
     * @return The token.
     */
    @java.lang.Override
    public java.lang.String getToken() {
      java.lang.Object ref = token_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        token_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * An encoded position for this stream's partition to restart reading from.
     * This token is for the StreamPartition from the request.
     * </pre>
     *
     * <code>string token = 9;</code>
     *
     * @return The bytes for token.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTokenBytes() {
      java.lang.Object ref = token_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        token_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ESTIMATED_LOW_WATERMARK_FIELD_NUMBER = 10;
    private com.google.protobuf.Timestamp estimatedLowWatermark_;

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     *
     * @return Whether the estimatedLowWatermark field is set.
     */
    @java.lang.Override
    public boolean hasEstimatedLowWatermark() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     *
     * @return The estimatedLowWatermark.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEstimatedLowWatermark() {
      return estimatedLowWatermark_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : estimatedLowWatermark_;
    }

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEstimatedLowWatermarkOrBuilder() {
      return estimatedLowWatermark_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : estimatedLowWatermark_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceClusterId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceClusterId_);
      }
      if (!rowKey_.isEmpty()) {
        output.writeBytes(3, rowKey_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getCommitTimestamp());
      }
      if (tiebreaker_ != 0) {
        output.writeInt32(5, tiebreaker_);
      }
      for (int i = 0; i < chunks_.size(); i++) {
        output.writeMessage(6, chunks_.get(i));
      }
      if (done_ != false) {
        output.writeBool(8, done_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, token_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(10, getEstimatedLowWatermark());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceClusterId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceClusterId_);
      }
      if (!rowKey_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, rowKey_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCommitTimestamp());
      }
      if (tiebreaker_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, tiebreaker_);
      }
      for (int i = 0; i < chunks_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, chunks_.get(i));
      }
      if (done_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, done_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, token_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, getEstimatedLowWatermark());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.ReadChangeStreamResponse.DataChange)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.ReadChangeStreamResponse.DataChange other =
          (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) obj;

      if (type_ != other.type_) return false;
      if (!getSourceClusterId().equals(other.getSourceClusterId())) return false;
      if (!getRowKey().equals(other.getRowKey())) return false;
      if (hasCommitTimestamp() != other.hasCommitTimestamp()) return false;
      if (hasCommitTimestamp()) {
        if (!getCommitTimestamp().equals(other.getCommitTimestamp())) return false;
      }
      if (getTiebreaker() != other.getTiebreaker()) return false;
      if (!getChunksList().equals(other.getChunksList())) return false;
      if (getDone() != other.getDone()) return false;
      if (!getToken().equals(other.getToken())) return false;
      if (hasEstimatedLowWatermark() != other.hasEstimatedLowWatermark()) return false;
      if (hasEstimatedLowWatermark()) {
        if (!getEstimatedLowWatermark().equals(other.getEstimatedLowWatermark())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + SOURCE_CLUSTER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSourceClusterId().hashCode();
      hash = (37 * hash) + ROW_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getRowKey().hashCode();
      if (hasCommitTimestamp()) {
        hash = (37 * hash) + COMMIT_TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getCommitTimestamp().hashCode();
      }
      hash = (37 * hash) + TIEBREAKER_FIELD_NUMBER;
      hash = (53 * hash) + getTiebreaker();
      if (getChunksCount() > 0) {
        hash = (37 * hash) + CHUNKS_FIELD_NUMBER;
        hash = (53 * hash) + getChunksList().hashCode();
      }
      hash = (37 * hash) + DONE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDone());
      hash = (37 * hash) + TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getToken().hashCode();
      if (hasEstimatedLowWatermark()) {
        hash = (37 * hash) + ESTIMATED_LOW_WATERMARK_FIELD_NUMBER;
        hash = (53 * hash) + getEstimatedLowWatermark().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.v2.ReadChangeStreamResponse.DataChange prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A message corresponding to one or more mutations to the partition
     * being streamed. A single logical `DataChange` message may also be split
     * across a sequence of multiple individual messages. Messages other than
     * the first in a sequence will only have the `type` and `chunks` fields
     * populated, with the final message in the sequence also containing `done`
     * set to true.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.DataChange}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadChangeStreamResponse.DataChange)
        com.google.bigtable.v2.ReadChangeStreamResponse.DataChangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_DataChange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_DataChange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.class,
                com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Builder.class);
      }

      // Construct using com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getCommitTimestampFieldBuilder();
          getChunksFieldBuilder();
          getEstimatedLowWatermarkFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        sourceClusterId_ = "";
        rowKey_ = com.google.protobuf.ByteString.EMPTY;
        commitTimestamp_ = null;
        if (commitTimestampBuilder_ != null) {
          commitTimestampBuilder_.dispose();
          commitTimestampBuilder_ = null;
        }
        tiebreaker_ = 0;
        if (chunksBuilder_ == null) {
          chunks_ = java.util.Collections.emptyList();
        } else {
          chunks_ = null;
          chunksBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        done_ = false;
        token_ = "";
        estimatedLowWatermark_ = null;
        if (estimatedLowWatermarkBuilder_ != null) {
          estimatedLowWatermarkBuilder_.dispose();
          estimatedLowWatermarkBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_DataChange_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange
          getDefaultInstanceForType() {
        return com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange build() {
        com.google.bigtable.v2.ReadChangeStreamResponse.DataChange result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange buildPartial() {
        com.google.bigtable.v2.ReadChangeStreamResponse.DataChange result =
            new com.google.bigtable.v2.ReadChangeStreamResponse.DataChange(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.bigtable.v2.ReadChangeStreamResponse.DataChange result) {
        if (chunksBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)) {
            chunks_ = java.util.Collections.unmodifiableList(chunks_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.chunks_ = chunks_;
        } else {
          result.chunks_ = chunksBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.bigtable.v2.ReadChangeStreamResponse.DataChange result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.sourceClusterId_ = sourceClusterId_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.rowKey_ = rowKey_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.commitTimestamp_ =
              commitTimestampBuilder_ == null ? commitTimestamp_ : commitTimestampBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.tiebreaker_ = tiebreaker_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.done_ = done_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.token_ = token_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.estimatedLowWatermark_ =
              estimatedLowWatermarkBuilder_ == null
                  ? estimatedLowWatermark_
                  : estimatedLowWatermarkBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) {
          return mergeFrom((com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.ReadChangeStreamResponse.DataChange other) {
        if (other
            == com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.getSourceClusterId().isEmpty()) {
          sourceClusterId_ = other.sourceClusterId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getRowKey() != com.google.protobuf.ByteString.EMPTY) {
          setRowKey(other.getRowKey());
        }
        if (other.hasCommitTimestamp()) {
          mergeCommitTimestamp(other.getCommitTimestamp());
        }
        if (other.getTiebreaker() != 0) {
          setTiebreaker(other.getTiebreaker());
        }
        if (chunksBuilder_ == null) {
          if (!other.chunks_.isEmpty()) {
            if (chunks_.isEmpty()) {
              chunks_ = other.chunks_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureChunksIsMutable();
              chunks_.addAll(other.chunks_);
            }
            onChanged();
          }
        } else {
          if (!other.chunks_.isEmpty()) {
            if (chunksBuilder_.isEmpty()) {
              chunksBuilder_.dispose();
              chunksBuilder_ = null;
              chunks_ = other.chunks_;
              bitField0_ = (bitField0_ & ~0x00000020);
              chunksBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getChunksFieldBuilder()
                      : null;
            } else {
              chunksBuilder_.addAllMessages(other.chunks_);
            }
          }
        }
        if (other.getDone() != false) {
          setDone(other.getDone());
        }
        if (!other.getToken().isEmpty()) {
          token_ = other.token_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        if (other.hasEstimatedLowWatermark()) {
          mergeEstimatedLowWatermark(other.getEstimatedLowWatermark());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  sourceClusterId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  rowKey_ = input.readBytes();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getCommitTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  tiebreaker_ = input.readInt32();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 50:
                {
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk m =
                      input.readMessage(
                          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.parser(),
                          extensionRegistry);
                  if (chunksBuilder_ == null) {
                    ensureChunksIsMutable();
                    chunks_.add(m);
                  } else {
                    chunksBuilder_.addMessage(m);
                  }
                  break;
                } // case 50
              case 64:
                {
                  done_ = input.readBool();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 64
              case 74:
                {
                  token_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 74
              case 82:
                {
                  input.readMessage(
                      getEstimatedLowWatermarkFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * The type of the mutation.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * The type of the mutation.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the mutation.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type getType() {
        com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type result =
            com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type.forNumber(type_);
        return result == null
            ? com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The type of the mutation.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the mutation.
       * </pre>
       *
       * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object sourceClusterId_ = "";

      /**
       *
       *
       * <pre>
       * The cluster where the mutation was applied.
       * Not set when `type` is `GARBAGE_COLLECTION`.
       * </pre>
       *
       * <code>string source_cluster_id = 2;</code>
       *
       * @return The sourceClusterId.
       */
      public java.lang.String getSourceClusterId() {
        java.lang.Object ref = sourceClusterId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceClusterId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The cluster where the mutation was applied.
       * Not set when `type` is `GARBAGE_COLLECTION`.
       * </pre>
       *
       * <code>string source_cluster_id = 2;</code>
       *
       * @return The bytes for sourceClusterId.
       */
      public com.google.protobuf.ByteString getSourceClusterIdBytes() {
        java.lang.Object ref = sourceClusterId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceClusterId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The cluster where the mutation was applied.
       * Not set when `type` is `GARBAGE_COLLECTION`.
       * </pre>
       *
       * <code>string source_cluster_id = 2;</code>
       *
       * @param value The sourceClusterId to set.
       * @return This builder for chaining.
       */
      public Builder setSourceClusterId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceClusterId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The cluster where the mutation was applied.
       * Not set when `type` is `GARBAGE_COLLECTION`.
       * </pre>
       *
       * <code>string source_cluster_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceClusterId() {
        sourceClusterId_ = getDefaultInstance().getSourceClusterId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The cluster where the mutation was applied.
       * Not set when `type` is `GARBAGE_COLLECTION`.
       * </pre>
       *
       * <code>string source_cluster_id = 2;</code>
       *
       * @param value The bytes for sourceClusterId to set.
       * @return This builder for chaining.
       */
      public Builder setSourceClusterIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceClusterId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString rowKey_ = com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * The row key for all mutations that are part of this `DataChange`.
       * If the `DataChange` is chunked across multiple messages, then this field
       * will only be set for the first message.
       * </pre>
       *
       * <code>bytes row_key = 3;</code>
       *
       * @return The rowKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRowKey() {
        return rowKey_;
      }

      /**
       *
       *
       * <pre>
       * The row key for all mutations that are part of this `DataChange`.
       * If the `DataChange` is chunked across multiple messages, then this field
       * will only be set for the first message.
       * </pre>
       *
       * <code>bytes row_key = 3;</code>
       *
       * @param value The rowKey to set.
       * @return This builder for chaining.
       */
      public Builder setRowKey(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        rowKey_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The row key for all mutations that are part of this `DataChange`.
       * If the `DataChange` is chunked across multiple messages, then this field
       * will only be set for the first message.
       * </pre>
       *
       * <code>bytes row_key = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowKey() {
        bitField0_ = (bitField0_ & ~0x00000004);
        rowKey_ = getDefaultInstance().getRowKey();
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp commitTimestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          commitTimestampBuilder_;

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       *
       * @return Whether the commitTimestamp field is set.
       */
      public boolean hasCommitTimestamp() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       *
       * @return The commitTimestamp.
       */
      public com.google.protobuf.Timestamp getCommitTimestamp() {
        if (commitTimestampBuilder_ == null) {
          return commitTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTimestamp_;
        } else {
          return commitTimestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       */
      public Builder setCommitTimestamp(com.google.protobuf.Timestamp value) {
        if (commitTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          commitTimestamp_ = value;
        } else {
          commitTimestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       */
      public Builder setCommitTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (commitTimestampBuilder_ == null) {
          commitTimestamp_ = builderForValue.build();
        } else {
          commitTimestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       */
      public Builder mergeCommitTimestamp(com.google.protobuf.Timestamp value) {
        if (commitTimestampBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && commitTimestamp_ != null
              && commitTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCommitTimestampBuilder().mergeFrom(value);
          } else {
            commitTimestamp_ = value;
          }
        } else {
          commitTimestampBuilder_.mergeFrom(value);
        }
        if (commitTimestamp_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       */
      public Builder clearCommitTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000008);
        commitTimestamp_ = null;
        if (commitTimestampBuilder_ != null) {
          commitTimestampBuilder_.dispose();
          commitTimestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCommitTimestampBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCommitTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
        if (commitTimestampBuilder_ != null) {
          return commitTimestampBuilder_.getMessageOrBuilder();
        } else {
          return commitTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTimestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * The timestamp at which the mutation was applied on the Bigtable server.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCommitTimestampFieldBuilder() {
        if (commitTimestampBuilder_ == null) {
          commitTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCommitTimestamp(), getParentForChildren(), isClean());
          commitTimestamp_ = null;
        }
        return commitTimestampBuilder_;
      }

      private int tiebreaker_;

      /**
       *
       *
       * <pre>
       * A value that lets stream consumers reconstruct Bigtable's
       * conflict resolution semantics.
       * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
       * In the event that the same row key, column family, column qualifier,
       * timestamp are modified on different clusters at the same
       * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
       * one chosen for the eventually consistent state of the system.
       * </pre>
       *
       * <code>int32 tiebreaker = 5;</code>
       *
       * @return The tiebreaker.
       */
      @java.lang.Override
      public int getTiebreaker() {
        return tiebreaker_;
      }

      /**
       *
       *
       * <pre>
       * A value that lets stream consumers reconstruct Bigtable's
       * conflict resolution semantics.
       * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
       * In the event that the same row key, column family, column qualifier,
       * timestamp are modified on different clusters at the same
       * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
       * one chosen for the eventually consistent state of the system.
       * </pre>
       *
       * <code>int32 tiebreaker = 5;</code>
       *
       * @param value The tiebreaker to set.
       * @return This builder for chaining.
       */
      public Builder setTiebreaker(int value) {

        tiebreaker_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A value that lets stream consumers reconstruct Bigtable's
       * conflict resolution semantics.
       * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
       * In the event that the same row key, column family, column qualifier,
       * timestamp are modified on different clusters at the same
       * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
       * one chosen for the eventually consistent state of the system.
       * </pre>
       *
       * <code>int32 tiebreaker = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTiebreaker() {
        bitField0_ = (bitField0_ & ~0x00000010);
        tiebreaker_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk>
          chunks_ = java.util.Collections.emptyList();

      private void ensureChunksIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          chunks_ =
              new java.util.ArrayList<
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk>(chunks_);
          bitField0_ |= 0x00000020;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder>
          chunksBuilder_;

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public java.util.List<com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk>
          getChunksList() {
        if (chunksBuilder_ == null) {
          return java.util.Collections.unmodifiableList(chunks_);
        } else {
          return chunksBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public int getChunksCount() {
        if (chunksBuilder_ == null) {
          return chunks_.size();
        } else {
          return chunksBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk getChunks(int index) {
        if (chunksBuilder_ == null) {
          return chunks_.get(index);
        } else {
          return chunksBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder setChunks(
          int index, com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk value) {
        if (chunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChunksIsMutable();
          chunks_.set(index, value);
          onChanged();
        } else {
          chunksBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder setChunks(
          int index,
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder builderForValue) {
        if (chunksBuilder_ == null) {
          ensureChunksIsMutable();
          chunks_.set(index, builderForValue.build());
          onChanged();
        } else {
          chunksBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder addChunks(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk value) {
        if (chunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChunksIsMutable();
          chunks_.add(value);
          onChanged();
        } else {
          chunksBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder addChunks(
          int index, com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk value) {
        if (chunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChunksIsMutable();
          chunks_.add(index, value);
          onChanged();
        } else {
          chunksBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder addChunks(
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder builderForValue) {
        if (chunksBuilder_ == null) {
          ensureChunksIsMutable();
          chunks_.add(builderForValue.build());
          onChanged();
        } else {
          chunksBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder addChunks(
          int index,
          com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder builderForValue) {
        if (chunksBuilder_ == null) {
          ensureChunksIsMutable();
          chunks_.add(index, builderForValue.build());
          onChanged();
        } else {
          chunksBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder addAllChunks(
          java.lang.Iterable<
                  ? extends com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk>
              values) {
        if (chunksBuilder_ == null) {
          ensureChunksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, chunks_);
          onChanged();
        } else {
          chunksBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder clearChunks() {
        if (chunksBuilder_ == null) {
          chunks_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          chunksBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public Builder removeChunks(int index) {
        if (chunksBuilder_ == null) {
          ensureChunksIsMutable();
          chunks_.remove(index);
          onChanged();
        } else {
          chunksBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder getChunksBuilder(
          int index) {
        return getChunksFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder
          getChunksOrBuilder(int index) {
        if (chunksBuilder_ == null) {
          return chunks_.get(index);
        } else {
          return chunksBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public java.util.List<
              ? extends com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder>
          getChunksOrBuilderList() {
        if (chunksBuilder_ != null) {
          return chunksBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(chunks_);
        }
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder
          addChunksBuilder() {
        return getChunksFieldBuilder()
            .addBuilder(
                com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder addChunksBuilder(
          int index) {
        return getChunksFieldBuilder()
            .addBuilder(
                index,
                com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The mutations associated with this change to the partition.
       * May contain complete mutations or chunks of a multi-message chunked
       * `DataChange` record.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;
       * </code>
       */
      public java.util.List<com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder>
          getChunksBuilderList() {
        return getChunksFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder,
              com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder>
          getChunksFieldBuilder() {
        if (chunksBuilder_ == null) {
          chunksBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk,
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.Builder,
                  com.google.bigtable.v2.ReadChangeStreamResponse.MutationChunkOrBuilder>(
                  chunks_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
          chunks_ = null;
        }
        return chunksBuilder_;
      }

      private boolean done_;

      /**
       *
       *
       * <pre>
       * When true, indicates that the entire `DataChange` has been read
       * and the client can safely process the message.
       * </pre>
       *
       * <code>bool done = 8;</code>
       *
       * @return The done.
       */
      @java.lang.Override
      public boolean getDone() {
        return done_;
      }

      /**
       *
       *
       * <pre>
       * When true, indicates that the entire `DataChange` has been read
       * and the client can safely process the message.
       * </pre>
       *
       * <code>bool done = 8;</code>
       *
       * @param value The done to set.
       * @return This builder for chaining.
       */
      public Builder setDone(boolean value) {

        done_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * When true, indicates that the entire `DataChange` has been read
       * and the client can safely process the message.
       * </pre>
       *
       * <code>bool done = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDone() {
        bitField0_ = (bitField0_ & ~0x00000040);
        done_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object token_ = "";

      /**
       *
       *
       * <pre>
       * An encoded position for this stream's partition to restart reading from.
       * This token is for the StreamPartition from the request.
       * </pre>
       *
       * <code>string token = 9;</code>
       *
       * @return The token.
       */
      public java.lang.String getToken() {
        java.lang.Object ref = token_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          token_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * An encoded position for this stream's partition to restart reading from.
       * This token is for the StreamPartition from the request.
       * </pre>
       *
       * <code>string token = 9;</code>
       *
       * @return The bytes for token.
       */
      public com.google.protobuf.ByteString getTokenBytes() {
        java.lang.Object ref = token_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          token_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * An encoded position for this stream's partition to restart reading from.
       * This token is for the StreamPartition from the request.
       * </pre>
       *
       * <code>string token = 9;</code>
       *
       * @param value The token to set.
       * @return This builder for chaining.
       */
      public Builder setToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        token_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An encoded position for this stream's partition to restart reading from.
       * This token is for the StreamPartition from the request.
       * </pre>
       *
       * <code>string token = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearToken() {
        token_ = getDefaultInstance().getToken();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An encoded position for this stream's partition to restart reading from.
       * This token is for the StreamPartition from the request.
       * </pre>
       *
       * <code>string token = 9;</code>
       *
       * @param value The bytes for token to set.
       * @return This builder for chaining.
       */
      public Builder setTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        token_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp estimatedLowWatermark_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          estimatedLowWatermarkBuilder_;

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       *
       * @return Whether the estimatedLowWatermark field is set.
       */
      public boolean hasEstimatedLowWatermark() {
        return ((bitField0_ & 0x00000100) != 0);
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       *
       * @return The estimatedLowWatermark.
       */
      public com.google.protobuf.Timestamp getEstimatedLowWatermark() {
        if (estimatedLowWatermarkBuilder_ == null) {
          return estimatedLowWatermark_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : estimatedLowWatermark_;
        } else {
          return estimatedLowWatermarkBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       */
      public Builder setEstimatedLowWatermark(com.google.protobuf.Timestamp value) {
        if (estimatedLowWatermarkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          estimatedLowWatermark_ = value;
        } else {
          estimatedLowWatermarkBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       */
      public Builder setEstimatedLowWatermark(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (estimatedLowWatermarkBuilder_ == null) {
          estimatedLowWatermark_ = builderForValue.build();
        } else {
          estimatedLowWatermarkBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       */
      public Builder mergeEstimatedLowWatermark(com.google.protobuf.Timestamp value) {
        if (estimatedLowWatermarkBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && estimatedLowWatermark_ != null
              && estimatedLowWatermark_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEstimatedLowWatermarkBuilder().mergeFrom(value);
          } else {
            estimatedLowWatermark_ = value;
          }
        } else {
          estimatedLowWatermarkBuilder_.mergeFrom(value);
        }
        if (estimatedLowWatermark_ != null) {
          bitField0_ |= 0x00000100;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       */
      public Builder clearEstimatedLowWatermark() {
        bitField0_ = (bitField0_ & ~0x00000100);
        estimatedLowWatermark_ = null;
        if (estimatedLowWatermarkBuilder_ != null) {
          estimatedLowWatermarkBuilder_.dispose();
          estimatedLowWatermarkBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEstimatedLowWatermarkBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getEstimatedLowWatermarkFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEstimatedLowWatermarkOrBuilder() {
        if (estimatedLowWatermarkBuilder_ != null) {
          return estimatedLowWatermarkBuilder_.getMessageOrBuilder();
        } else {
          return estimatedLowWatermark_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : estimatedLowWatermark_;
        }
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEstimatedLowWatermarkFieldBuilder() {
        if (estimatedLowWatermarkBuilder_ == null) {
          estimatedLowWatermarkBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEstimatedLowWatermark(), getParentForChildren(), isClean());
          estimatedLowWatermark_ = null;
        }
        return estimatedLowWatermarkBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadChangeStreamResponse.DataChange)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadChangeStreamResponse.DataChange)
    private static final com.google.bigtable.v2.ReadChangeStreamResponse.DataChange
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadChangeStreamResponse.DataChange();
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.DataChange getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataChange> PARSER =
        new com.google.protobuf.AbstractParser<DataChange>() {
          @java.lang.Override
          public DataChange parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataChange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataChange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HeartbeatOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.ReadChangeStreamResponse.Heartbeat)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A token that can be provided to a subsequent `ReadChangeStream` call
     * to pick up reading at the current stream position.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
     *
     * @return Whether the continuationToken field is set.
     */
    boolean hasContinuationToken();

    /**
     *
     *
     * <pre>
     * A token that can be provided to a subsequent `ReadChangeStream` call
     * to pick up reading at the current stream position.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
     *
     * @return The continuationToken.
     */
    com.google.bigtable.v2.StreamContinuationToken getContinuationToken();

    /**
     *
     *
     * <pre>
     * A token that can be provided to a subsequent `ReadChangeStream` call
     * to pick up reading at the current stream position.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
     */
    com.google.bigtable.v2.StreamContinuationTokenOrBuilder getContinuationTokenOrBuilder();

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
     *
     * @return Whether the estimatedLowWatermark field is set.
     */
    boolean hasEstimatedLowWatermark();

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
     *
     * @return The estimatedLowWatermark.
     */
    com.google.protobuf.Timestamp getEstimatedLowWatermark();

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEstimatedLowWatermarkOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A periodic message with information that can be used to checkpoint
   * the state of a stream.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.Heartbeat}
   */
  public static final class Heartbeat extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadChangeStreamResponse.Heartbeat)
      HeartbeatOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Heartbeat.newBuilder() to construct.
    private Heartbeat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Heartbeat() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Heartbeat();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_Heartbeat_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_Heartbeat_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.class,
              com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.Builder.class);
    }

    private int bitField0_;
    public static final int CONTINUATION_TOKEN_FIELD_NUMBER = 1;
    private com.google.bigtable.v2.StreamContinuationToken continuationToken_;

    /**
     *
     *
     * <pre>
     * A token that can be provided to a subsequent `ReadChangeStream` call
     * to pick up reading at the current stream position.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
     *
     * @return Whether the continuationToken field is set.
     */
    @java.lang.Override
    public boolean hasContinuationToken() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * A token that can be provided to a subsequent `ReadChangeStream` call
     * to pick up reading at the current stream position.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
     *
     * @return The continuationToken.
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamContinuationToken getContinuationToken() {
      return continuationToken_ == null
          ? com.google.bigtable.v2.StreamContinuationToken.getDefaultInstance()
          : continuationToken_;
    }

    /**
     *
     *
     * <pre>
     * A token that can be provided to a subsequent `ReadChangeStream` call
     * to pick up reading at the current stream position.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamContinuationTokenOrBuilder getContinuationTokenOrBuilder() {
      return continuationToken_ == null
          ? com.google.bigtable.v2.StreamContinuationToken.getDefaultInstance()
          : continuationToken_;
    }

    public static final int ESTIMATED_LOW_WATERMARK_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp estimatedLowWatermark_;

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
     *
     * @return Whether the estimatedLowWatermark field is set.
     */
    @java.lang.Override
    public boolean hasEstimatedLowWatermark() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
     *
     * @return The estimatedLowWatermark.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEstimatedLowWatermark() {
      return estimatedLowWatermark_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : estimatedLowWatermark_;
    }

    /**
     *
     *
     * <pre>
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp that is lower than a previously seen timestamp.
     * For an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     * </pre>
     *
     * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEstimatedLowWatermarkOrBuilder() {
      return estimatedLowWatermark_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : estimatedLowWatermark_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getContinuationToken());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getEstimatedLowWatermark());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getContinuationToken());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEstimatedLowWatermark());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat other =
          (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) obj;

      if (hasContinuationToken() != other.hasContinuationToken()) return false;
      if (hasContinuationToken()) {
        if (!getContinuationToken().equals(other.getContinuationToken())) return false;
      }
      if (hasEstimatedLowWatermark() != other.hasEstimatedLowWatermark()) return false;
      if (hasEstimatedLowWatermark()) {
        if (!getEstimatedLowWatermark().equals(other.getEstimatedLowWatermark())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasContinuationToken()) {
        hash = (37 * hash) + CONTINUATION_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getContinuationToken().hashCode();
      }
      if (hasEstimatedLowWatermark()) {
        hash = (37 * hash) + ESTIMATED_LOW_WATERMARK_FIELD_NUMBER;
        hash = (53 * hash) + getEstimatedLowWatermark().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A periodic message with information that can be used to checkpoint
     * the state of a stream.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.Heartbeat}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadChangeStreamResponse.Heartbeat)
        com.google.bigtable.v2.ReadChangeStreamResponse.HeartbeatOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_Heartbeat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_Heartbeat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.class,
                com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.Builder.class);
      }

      // Construct using com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getContinuationTokenFieldBuilder();
          getEstimatedLowWatermarkFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        continuationToken_ = null;
        if (continuationTokenBuilder_ != null) {
          continuationTokenBuilder_.dispose();
          continuationTokenBuilder_ = null;
        }
        estimatedLowWatermark_ = null;
        if (estimatedLowWatermarkBuilder_ != null) {
          estimatedLowWatermarkBuilder_.dispose();
          estimatedLowWatermarkBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_Heartbeat_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat getDefaultInstanceForType() {
        return com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat build() {
        com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat buildPartial() {
        com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat result =
            new com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.continuationToken_ =
              continuationTokenBuilder_ == null
                  ? continuationToken_
                  : continuationTokenBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.estimatedLowWatermark_ =
              estimatedLowWatermarkBuilder_ == null
                  ? estimatedLowWatermark_
                  : estimatedLowWatermarkBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) {
          return mergeFrom((com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat other) {
        if (other == com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance())
          return this;
        if (other.hasContinuationToken()) {
          mergeContinuationToken(other.getContinuationToken());
        }
        if (other.hasEstimatedLowWatermark()) {
          mergeEstimatedLowWatermark(other.getEstimatedLowWatermark());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getContinuationTokenFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getEstimatedLowWatermarkFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.v2.StreamContinuationToken continuationToken_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.StreamContinuationToken,
              com.google.bigtable.v2.StreamContinuationToken.Builder,
              com.google.bigtable.v2.StreamContinuationTokenOrBuilder>
          continuationTokenBuilder_;

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       *
       * @return Whether the continuationToken field is set.
       */
      public boolean hasContinuationToken() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       *
       * @return The continuationToken.
       */
      public com.google.bigtable.v2.StreamContinuationToken getContinuationToken() {
        if (continuationTokenBuilder_ == null) {
          return continuationToken_ == null
              ? com.google.bigtable.v2.StreamContinuationToken.getDefaultInstance()
              : continuationToken_;
        } else {
          return continuationTokenBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       */
      public Builder setContinuationToken(com.google.bigtable.v2.StreamContinuationToken value) {
        if (continuationTokenBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          continuationToken_ = value;
        } else {
          continuationTokenBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       */
      public Builder setContinuationToken(
          com.google.bigtable.v2.StreamContinuationToken.Builder builderForValue) {
        if (continuationTokenBuilder_ == null) {
          continuationToken_ = builderForValue.build();
        } else {
          continuationTokenBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       */
      public Builder mergeContinuationToken(com.google.bigtable.v2.StreamContinuationToken value) {
        if (continuationTokenBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && continuationToken_ != null
              && continuationToken_
                  != com.google.bigtable.v2.StreamContinuationToken.getDefaultInstance()) {
            getContinuationTokenBuilder().mergeFrom(value);
          } else {
            continuationToken_ = value;
          }
        } else {
          continuationTokenBuilder_.mergeFrom(value);
        }
        if (continuationToken_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       */
      public Builder clearContinuationToken() {
        bitField0_ = (bitField0_ & ~0x00000001);
        continuationToken_ = null;
        if (continuationTokenBuilder_ != null) {
          continuationTokenBuilder_.dispose();
          continuationTokenBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       */
      public com.google.bigtable.v2.StreamContinuationToken.Builder getContinuationTokenBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getContinuationTokenFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       */
      public com.google.bigtable.v2.StreamContinuationTokenOrBuilder
          getContinuationTokenOrBuilder() {
        if (continuationTokenBuilder_ != null) {
          return continuationTokenBuilder_.getMessageOrBuilder();
        } else {
          return continuationToken_ == null
              ? com.google.bigtable.v2.StreamContinuationToken.getDefaultInstance()
              : continuationToken_;
        }
      }

      /**
       *
       *
       * <pre>
       * A token that can be provided to a subsequent `ReadChangeStream` call
       * to pick up reading at the current stream position.
       * </pre>
       *
       * <code>.google.bigtable.v2.StreamContinuationToken continuation_token = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.StreamContinuationToken,
              com.google.bigtable.v2.StreamContinuationToken.Builder,
              com.google.bigtable.v2.StreamContinuationTokenOrBuilder>
          getContinuationTokenFieldBuilder() {
        if (continuationTokenBuilder_ == null) {
          continuationTokenBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.StreamContinuationToken,
                  com.google.bigtable.v2.StreamContinuationToken.Builder,
                  com.google.bigtable.v2.StreamContinuationTokenOrBuilder>(
                  getContinuationToken(), getParentForChildren(), isClean());
          continuationToken_ = null;
        }
        return continuationTokenBuilder_;
      }

      private com.google.protobuf.Timestamp estimatedLowWatermark_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          estimatedLowWatermarkBuilder_;

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       *
       * @return Whether the estimatedLowWatermark field is set.
       */
      public boolean hasEstimatedLowWatermark() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       *
       * @return The estimatedLowWatermark.
       */
      public com.google.protobuf.Timestamp getEstimatedLowWatermark() {
        if (estimatedLowWatermarkBuilder_ == null) {
          return estimatedLowWatermark_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : estimatedLowWatermark_;
        } else {
          return estimatedLowWatermarkBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       */
      public Builder setEstimatedLowWatermark(com.google.protobuf.Timestamp value) {
        if (estimatedLowWatermarkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          estimatedLowWatermark_ = value;
        } else {
          estimatedLowWatermarkBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       */
      public Builder setEstimatedLowWatermark(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (estimatedLowWatermarkBuilder_ == null) {
          estimatedLowWatermark_ = builderForValue.build();
        } else {
          estimatedLowWatermarkBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       */
      public Builder mergeEstimatedLowWatermark(com.google.protobuf.Timestamp value) {
        if (estimatedLowWatermarkBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && estimatedLowWatermark_ != null
              && estimatedLowWatermark_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEstimatedLowWatermarkBuilder().mergeFrom(value);
          } else {
            estimatedLowWatermark_ = value;
          }
        } else {
          estimatedLowWatermarkBuilder_.mergeFrom(value);
        }
        if (estimatedLowWatermark_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       */
      public Builder clearEstimatedLowWatermark() {
        bitField0_ = (bitField0_ & ~0x00000002);
        estimatedLowWatermark_ = null;
        if (estimatedLowWatermarkBuilder_ != null) {
          estimatedLowWatermarkBuilder_.dispose();
          estimatedLowWatermarkBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEstimatedLowWatermarkBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getEstimatedLowWatermarkFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEstimatedLowWatermarkOrBuilder() {
        if (estimatedLowWatermarkBuilder_ != null) {
          return estimatedLowWatermarkBuilder_.getMessageOrBuilder();
        } else {
          return estimatedLowWatermark_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : estimatedLowWatermark_;
        }
      }

      /**
       *
       *
       * <pre>
       * An estimate of the commit timestamp that is usually lower than or equal
       * to any timestamp for a record that will be delivered in the future on the
       * stream. It is possible that, under particular circumstances that a future
       * record has a timestamp that is lower than a previously seen timestamp.
       * For an example usage see
       * https://beam.apache.org/documentation/basics/#watermarks
       * </pre>
       *
       * <code>.google.protobuf.Timestamp estimated_low_watermark = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEstimatedLowWatermarkFieldBuilder() {
        if (estimatedLowWatermarkBuilder_ == null) {
          estimatedLowWatermarkBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEstimatedLowWatermark(), getParentForChildren(), isClean());
          estimatedLowWatermark_ = null;
        }
        return estimatedLowWatermarkBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadChangeStreamResponse.Heartbeat)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadChangeStreamResponse.Heartbeat)
    private static final com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat();
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Heartbeat> PARSER =
        new com.google.protobuf.AbstractParser<Heartbeat>() {
          @java.lang.Override
          public Heartbeat parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Heartbeat> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Heartbeat> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloseStreamOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.ReadChangeStreamResponse.CloseStream)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The status of the stream.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();

    /**
     *
     *
     * <pre>
     * The status of the stream.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return The status.
     */
    com.google.rpc.Status getStatus();

    /**
     *
     *
     * <pre>
     * The status of the stream.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    com.google.rpc.StatusOrBuilder getStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    java.util.List<com.google.bigtable.v2.StreamContinuationToken> getContinuationTokensList();

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    com.google.bigtable.v2.StreamContinuationToken getContinuationTokens(int index);

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    int getContinuationTokensCount();

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    java.util.List<? extends com.google.bigtable.v2.StreamContinuationTokenOrBuilder>
        getContinuationTokensOrBuilderList();

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    com.google.bigtable.v2.StreamContinuationTokenOrBuilder getContinuationTokensOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    java.util.List<com.google.bigtable.v2.StreamPartition> getNewPartitionsList();

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    com.google.bigtable.v2.StreamPartition getNewPartitions(int index);

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    int getNewPartitionsCount();

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    java.util.List<? extends com.google.bigtable.v2.StreamPartitionOrBuilder>
        getNewPartitionsOrBuilderList();

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    com.google.bigtable.v2.StreamPartitionOrBuilder getNewPartitionsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * A message indicating that the client should stop reading from the stream.
   * If status is OK and `continuation_tokens` &amp; `new_partitions` are empty, the
   * stream has finished (for example if there was an `end_time` specified).
   * If `continuation_tokens` &amp; `new_partitions` are present, then a change in
   * partitioning requires the client to open a new stream for each token to
   * resume reading. Example:
   *
   *                                      [B,      D) ends
   *                                           |
   *                                           v
   *                   new_partitions:  [A,  C) [C,  E)
   *     continuation_tokens.partitions:  [B,C) [C,D)
   *                                      ^---^ ^---^
   *                                      ^     ^
   *                                      |     |
   *                                      |     StreamContinuationToken 2
   *                                      |
   *                                      StreamContinuationToken 1
   *
   * To read the new partition [A,C), supply the continuation tokens whose
   * ranges cover the new partition, for example ContinuationToken[A,B) &amp;
   * ContinuationToken[B,C).
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.CloseStream}
   */
  public static final class CloseStream extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadChangeStreamResponse.CloseStream)
      CloseStreamOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CloseStream.newBuilder() to construct.
    private CloseStream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloseStream() {
      continuationTokens_ = java.util.Collections.emptyList();
      newPartitions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloseStream();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_CloseStream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_CloseStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.class,
              com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.Builder.class);
    }

    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private com.google.rpc.Status status_;

    /**
     *
     *
     * <pre>
     * The status of the stream.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The status of the stream.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.rpc.Status getStatus() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }

    /**
     *
     *
     * <pre>
     * The status of the stream.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }

    public static final int CONTINUATION_TOKENS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.bigtable.v2.StreamContinuationToken> continuationTokens_;

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.v2.StreamContinuationToken>
        getContinuationTokensList() {
      return continuationTokens_;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.bigtable.v2.StreamContinuationTokenOrBuilder>
        getContinuationTokensOrBuilderList() {
      return continuationTokens_;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    @java.lang.Override
    public int getContinuationTokensCount() {
      return continuationTokens_.size();
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamContinuationToken getContinuationTokens(int index) {
      return continuationTokens_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the information needed to resume reading their
     * associated partitions.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamContinuationTokenOrBuilder getContinuationTokensOrBuilder(
        int index) {
      return continuationTokens_.get(index);
    }

    public static final int NEW_PARTITIONS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.bigtable.v2.StreamPartition> newPartitions_;

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.v2.StreamPartition> getNewPartitionsList() {
      return newPartitions_;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.bigtable.v2.StreamPartitionOrBuilder>
        getNewPartitionsOrBuilderList() {
      return newPartitions_;
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    @java.lang.Override
    public int getNewPartitionsCount() {
      return newPartitions_.size();
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamPartition getNewPartitions(int index) {
      return newPartitions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If non-empty, contains the new partitions to start reading from, which
     * are related to but not necessarily identical to the partitions for the
     * above `continuation_tokens`.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamPartitionOrBuilder getNewPartitionsOrBuilder(int index) {
      return newPartitions_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getStatus());
      }
      for (int i = 0; i < continuationTokens_.size(); i++) {
        output.writeMessage(2, continuationTokens_.get(i));
      }
      for (int i = 0; i < newPartitions_.size(); i++) {
        output.writeMessage(3, newPartitions_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStatus());
      }
      for (int i = 0; i < continuationTokens_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, continuationTokens_.get(i));
      }
      for (int i = 0; i < newPartitions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, newPartitions_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream other =
          (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) obj;

      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (!getContinuationTokensList().equals(other.getContinuationTokensList())) return false;
      if (!getNewPartitionsList().equals(other.getNewPartitionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (getContinuationTokensCount() > 0) {
        hash = (37 * hash) + CONTINUATION_TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getContinuationTokensList().hashCode();
      }
      if (getNewPartitionsCount() > 0) {
        hash = (37 * hash) + NEW_PARTITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getNewPartitionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A message indicating that the client should stop reading from the stream.
     * If status is OK and `continuation_tokens` &amp; `new_partitions` are empty, the
     * stream has finished (for example if there was an `end_time` specified).
     * If `continuation_tokens` &amp; `new_partitions` are present, then a change in
     * partitioning requires the client to open a new stream for each token to
     * resume reading. Example:
     *
     *                                      [B,      D) ends
     *                                           |
     *                                           v
     *                   new_partitions:  [A,  C) [C,  E)
     *     continuation_tokens.partitions:  [B,C) [C,D)
     *                                      ^---^ ^---^
     *                                      ^     ^
     *                                      |     |
     *                                      |     StreamContinuationToken 2
     *                                      |
     *                                      StreamContinuationToken 1
     *
     * To read the new partition [A,C), supply the continuation tokens whose
     * ranges cover the new partition, for example ContinuationToken[A,B) &amp;
     * ContinuationToken[B,C).
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse.CloseStream}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadChangeStreamResponse.CloseStream)
        com.google.bigtable.v2.ReadChangeStreamResponse.CloseStreamOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_CloseStream_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_CloseStream_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.class,
                com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.Builder.class);
      }

      // Construct using com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStatusFieldBuilder();
          getContinuationTokensFieldBuilder();
          getNewPartitionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        if (continuationTokensBuilder_ == null) {
          continuationTokens_ = java.util.Collections.emptyList();
        } else {
          continuationTokens_ = null;
          continuationTokensBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (newPartitionsBuilder_ == null) {
          newPartitions_ = java.util.Collections.emptyList();
        } else {
          newPartitions_ = null;
          newPartitionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadChangeStreamResponse_CloseStream_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream
          getDefaultInstanceForType() {
        return com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream build() {
        com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream buildPartial() {
        com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream result =
            new com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream result) {
        if (continuationTokensBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            continuationTokens_ = java.util.Collections.unmodifiableList(continuationTokens_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.continuationTokens_ = continuationTokens_;
        } else {
          result.continuationTokens_ = continuationTokensBuilder_.build();
        }
        if (newPartitionsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            newPartitions_ = java.util.Collections.unmodifiableList(newPartitions_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.newPartitions_ = newPartitions_;
        } else {
          result.newPartitions_ = newPartitionsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) {
          return mergeFrom((com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream other) {
        if (other
            == com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance())
          return this;
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        if (continuationTokensBuilder_ == null) {
          if (!other.continuationTokens_.isEmpty()) {
            if (continuationTokens_.isEmpty()) {
              continuationTokens_ = other.continuationTokens_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureContinuationTokensIsMutable();
              continuationTokens_.addAll(other.continuationTokens_);
            }
            onChanged();
          }
        } else {
          if (!other.continuationTokens_.isEmpty()) {
            if (continuationTokensBuilder_.isEmpty()) {
              continuationTokensBuilder_.dispose();
              continuationTokensBuilder_ = null;
              continuationTokens_ = other.continuationTokens_;
              bitField0_ = (bitField0_ & ~0x00000002);
              continuationTokensBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getContinuationTokensFieldBuilder()
                      : null;
            } else {
              continuationTokensBuilder_.addAllMessages(other.continuationTokens_);
            }
          }
        }
        if (newPartitionsBuilder_ == null) {
          if (!other.newPartitions_.isEmpty()) {
            if (newPartitions_.isEmpty()) {
              newPartitions_ = other.newPartitions_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureNewPartitionsIsMutable();
              newPartitions_.addAll(other.newPartitions_);
            }
            onChanged();
          }
        } else {
          if (!other.newPartitions_.isEmpty()) {
            if (newPartitionsBuilder_.isEmpty()) {
              newPartitionsBuilder_.dispose();
              newPartitionsBuilder_ = null;
              newPartitions_ = other.newPartitions_;
              bitField0_ = (bitField0_ & ~0x00000004);
              newPartitionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNewPartitionsFieldBuilder()
                      : null;
            } else {
              newPartitionsBuilder_.addAllMessages(other.newPartitions_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.bigtable.v2.StreamContinuationToken m =
                      input.readMessage(
                          com.google.bigtable.v2.StreamContinuationToken.parser(),
                          extensionRegistry);
                  if (continuationTokensBuilder_ == null) {
                    ensureContinuationTokensIsMutable();
                    continuationTokens_.add(m);
                  } else {
                    continuationTokensBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  com.google.bigtable.v2.StreamPartition m =
                      input.readMessage(
                          com.google.bigtable.v2.StreamPartition.parser(), extensionRegistry);
                  if (newPartitionsBuilder_ == null) {
                    ensureNewPartitionsIsMutable();
                    newPartitions_.add(m);
                  } else {
                    newPartitionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.rpc.Status status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          statusBuilder_;

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       *
       * @return The status.
       */
      public com.google.rpc.Status getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder setStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder mergeStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && status_ != null
              && status_ != com.google.rpc.Status.getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        if (status_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public com.google.rpc.Status.Builder getStatusBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        }
      }

      /**
       *
       *
       * <pre>
       * The status of the stream.
       * </pre>
       *
       * <code>.google.rpc.Status status = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      private java.util.List<com.google.bigtable.v2.StreamContinuationToken> continuationTokens_ =
          java.util.Collections.emptyList();

      private void ensureContinuationTokensIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          continuationTokens_ =
              new java.util.ArrayList<com.google.bigtable.v2.StreamContinuationToken>(
                  continuationTokens_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.StreamContinuationToken,
              com.google.bigtable.v2.StreamContinuationToken.Builder,
              com.google.bigtable.v2.StreamContinuationTokenOrBuilder>
          continuationTokensBuilder_;

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public java.util.List<com.google.bigtable.v2.StreamContinuationToken>
          getContinuationTokensList() {
        if (continuationTokensBuilder_ == null) {
          return java.util.Collections.unmodifiableList(continuationTokens_);
        } else {
          return continuationTokensBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public int getContinuationTokensCount() {
        if (continuationTokensBuilder_ == null) {
          return continuationTokens_.size();
        } else {
          return continuationTokensBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public com.google.bigtable.v2.StreamContinuationToken getContinuationTokens(int index) {
        if (continuationTokensBuilder_ == null) {
          return continuationTokens_.get(index);
        } else {
          return continuationTokensBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder setContinuationTokens(
          int index, com.google.bigtable.v2.StreamContinuationToken value) {
        if (continuationTokensBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContinuationTokensIsMutable();
          continuationTokens_.set(index, value);
          onChanged();
        } else {
          continuationTokensBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder setContinuationTokens(
          int index, com.google.bigtable.v2.StreamContinuationToken.Builder builderForValue) {
        if (continuationTokensBuilder_ == null) {
          ensureContinuationTokensIsMutable();
          continuationTokens_.set(index, builderForValue.build());
          onChanged();
        } else {
          continuationTokensBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder addContinuationTokens(com.google.bigtable.v2.StreamContinuationToken value) {
        if (continuationTokensBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContinuationTokensIsMutable();
          continuationTokens_.add(value);
          onChanged();
        } else {
          continuationTokensBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder addContinuationTokens(
          int index, com.google.bigtable.v2.StreamContinuationToken value) {
        if (continuationTokensBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContinuationTokensIsMutable();
          continuationTokens_.add(index, value);
          onChanged();
        } else {
          continuationTokensBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder addContinuationTokens(
          com.google.bigtable.v2.StreamContinuationToken.Builder builderForValue) {
        if (continuationTokensBuilder_ == null) {
          ensureContinuationTokensIsMutable();
          continuationTokens_.add(builderForValue.build());
          onChanged();
        } else {
          continuationTokensBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder addContinuationTokens(
          int index, com.google.bigtable.v2.StreamContinuationToken.Builder builderForValue) {
        if (continuationTokensBuilder_ == null) {
          ensureContinuationTokensIsMutable();
          continuationTokens_.add(index, builderForValue.build());
          onChanged();
        } else {
          continuationTokensBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder addAllContinuationTokens(
          java.lang.Iterable<? extends com.google.bigtable.v2.StreamContinuationToken> values) {
        if (continuationTokensBuilder_ == null) {
          ensureContinuationTokensIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, continuationTokens_);
          onChanged();
        } else {
          continuationTokensBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder clearContinuationTokens() {
        if (continuationTokensBuilder_ == null) {
          continuationTokens_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          continuationTokensBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public Builder removeContinuationTokens(int index) {
        if (continuationTokensBuilder_ == null) {
          ensureContinuationTokensIsMutable();
          continuationTokens_.remove(index);
          onChanged();
        } else {
          continuationTokensBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public com.google.bigtable.v2.StreamContinuationToken.Builder getContinuationTokensBuilder(
          int index) {
        return getContinuationTokensFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public com.google.bigtable.v2.StreamContinuationTokenOrBuilder getContinuationTokensOrBuilder(
          int index) {
        if (continuationTokensBuilder_ == null) {
          return continuationTokens_.get(index);
        } else {
          return continuationTokensBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public java.util.List<? extends com.google.bigtable.v2.StreamContinuationTokenOrBuilder>
          getContinuationTokensOrBuilderList() {
        if (continuationTokensBuilder_ != null) {
          return continuationTokensBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(continuationTokens_);
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public com.google.bigtable.v2.StreamContinuationToken.Builder addContinuationTokensBuilder() {
        return getContinuationTokensFieldBuilder()
            .addBuilder(com.google.bigtable.v2.StreamContinuationToken.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public com.google.bigtable.v2.StreamContinuationToken.Builder addContinuationTokensBuilder(
          int index) {
        return getContinuationTokensFieldBuilder()
            .addBuilder(index, com.google.bigtable.v2.StreamContinuationToken.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the information needed to resume reading their
       * associated partitions.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamContinuationToken continuation_tokens = 2;</code>
       */
      public java.util.List<com.google.bigtable.v2.StreamContinuationToken.Builder>
          getContinuationTokensBuilderList() {
        return getContinuationTokensFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.StreamContinuationToken,
              com.google.bigtable.v2.StreamContinuationToken.Builder,
              com.google.bigtable.v2.StreamContinuationTokenOrBuilder>
          getContinuationTokensFieldBuilder() {
        if (continuationTokensBuilder_ == null) {
          continuationTokensBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.bigtable.v2.StreamContinuationToken,
                  com.google.bigtable.v2.StreamContinuationToken.Builder,
                  com.google.bigtable.v2.StreamContinuationTokenOrBuilder>(
                  continuationTokens_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          continuationTokens_ = null;
        }
        return continuationTokensBuilder_;
      }

      private java.util.List<com.google.bigtable.v2.StreamPartition> newPartitions_ =
          java.util.Collections.emptyList();

      private void ensureNewPartitionsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          newPartitions_ =
              new java.util.ArrayList<com.google.bigtable.v2.StreamPartition>(newPartitions_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.StreamPartition,
              com.google.bigtable.v2.StreamPartition.Builder,
              com.google.bigtable.v2.StreamPartitionOrBuilder>
          newPartitionsBuilder_;

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public java.util.List<com.google.bigtable.v2.StreamPartition> getNewPartitionsList() {
        if (newPartitionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(newPartitions_);
        } else {
          return newPartitionsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public int getNewPartitionsCount() {
        if (newPartitionsBuilder_ == null) {
          return newPartitions_.size();
        } else {
          return newPartitionsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public com.google.bigtable.v2.StreamPartition getNewPartitions(int index) {
        if (newPartitionsBuilder_ == null) {
          return newPartitions_.get(index);
        } else {
          return newPartitionsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder setNewPartitions(int index, com.google.bigtable.v2.StreamPartition value) {
        if (newPartitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNewPartitionsIsMutable();
          newPartitions_.set(index, value);
          onChanged();
        } else {
          newPartitionsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder setNewPartitions(
          int index, com.google.bigtable.v2.StreamPartition.Builder builderForValue) {
        if (newPartitionsBuilder_ == null) {
          ensureNewPartitionsIsMutable();
          newPartitions_.set(index, builderForValue.build());
          onChanged();
        } else {
          newPartitionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder addNewPartitions(com.google.bigtable.v2.StreamPartition value) {
        if (newPartitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNewPartitionsIsMutable();
          newPartitions_.add(value);
          onChanged();
        } else {
          newPartitionsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder addNewPartitions(int index, com.google.bigtable.v2.StreamPartition value) {
        if (newPartitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNewPartitionsIsMutable();
          newPartitions_.add(index, value);
          onChanged();
        } else {
          newPartitionsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder addNewPartitions(
          com.google.bigtable.v2.StreamPartition.Builder builderForValue) {
        if (newPartitionsBuilder_ == null) {
          ensureNewPartitionsIsMutable();
          newPartitions_.add(builderForValue.build());
          onChanged();
        } else {
          newPartitionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder addNewPartitions(
          int index, com.google.bigtable.v2.StreamPartition.Builder builderForValue) {
        if (newPartitionsBuilder_ == null) {
          ensureNewPartitionsIsMutable();
          newPartitions_.add(index, builderForValue.build());
          onChanged();
        } else {
          newPartitionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder addAllNewPartitions(
          java.lang.Iterable<? extends com.google.bigtable.v2.StreamPartition> values) {
        if (newPartitionsBuilder_ == null) {
          ensureNewPartitionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, newPartitions_);
          onChanged();
        } else {
          newPartitionsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder clearNewPartitions() {
        if (newPartitionsBuilder_ == null) {
          newPartitions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          newPartitionsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public Builder removeNewPartitions(int index) {
        if (newPartitionsBuilder_ == null) {
          ensureNewPartitionsIsMutable();
          newPartitions_.remove(index);
          onChanged();
        } else {
          newPartitionsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public com.google.bigtable.v2.StreamPartition.Builder getNewPartitionsBuilder(int index) {
        return getNewPartitionsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public com.google.bigtable.v2.StreamPartitionOrBuilder getNewPartitionsOrBuilder(int index) {
        if (newPartitionsBuilder_ == null) {
          return newPartitions_.get(index);
        } else {
          return newPartitionsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public java.util.List<? extends com.google.bigtable.v2.StreamPartitionOrBuilder>
          getNewPartitionsOrBuilderList() {
        if (newPartitionsBuilder_ != null) {
          return newPartitionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(newPartitions_);
        }
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public com.google.bigtable.v2.StreamPartition.Builder addNewPartitionsBuilder() {
        return getNewPartitionsFieldBuilder()
            .addBuilder(com.google.bigtable.v2.StreamPartition.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public com.google.bigtable.v2.StreamPartition.Builder addNewPartitionsBuilder(int index) {
        return getNewPartitionsFieldBuilder()
            .addBuilder(index, com.google.bigtable.v2.StreamPartition.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * If non-empty, contains the new partitions to start reading from, which
       * are related to but not necessarily identical to the partitions for the
       * above `continuation_tokens`.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.StreamPartition new_partitions = 3;</code>
       */
      public java.util.List<com.google.bigtable.v2.StreamPartition.Builder>
          getNewPartitionsBuilderList() {
        return getNewPartitionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.StreamPartition,
              com.google.bigtable.v2.StreamPartition.Builder,
              com.google.bigtable.v2.StreamPartitionOrBuilder>
          getNewPartitionsFieldBuilder() {
        if (newPartitionsBuilder_ == null) {
          newPartitionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.bigtable.v2.StreamPartition,
                  com.google.bigtable.v2.StreamPartition.Builder,
                  com.google.bigtable.v2.StreamPartitionOrBuilder>(
                  newPartitions_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          newPartitions_ = null;
        }
        return newPartitionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadChangeStreamResponse.CloseStream)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadChangeStreamResponse.CloseStream)
    private static final com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream();
    }

    public static com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloseStream> PARSER =
        new com.google.protobuf.AbstractParser<CloseStream>() {
          @java.lang.Override
          public CloseStream parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloseStream> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloseStream> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int streamRecordCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object streamRecord_;

  public enum StreamRecordCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATA_CHANGE(1),
    HEARTBEAT(2),
    CLOSE_STREAM(3),
    STREAMRECORD_NOT_SET(0);
    private final int value;

    private StreamRecordCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StreamRecordCase valueOf(int value) {
      return forNumber(value);
    }

    public static StreamRecordCase forNumber(int value) {
      switch (value) {
        case 1:
          return DATA_CHANGE;
        case 2:
          return HEARTBEAT;
        case 3:
          return CLOSE_STREAM;
        case 0:
          return STREAMRECORD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StreamRecordCase getStreamRecordCase() {
    return StreamRecordCase.forNumber(streamRecordCase_);
  }

  public static final int DATA_CHANGE_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * A mutation to the partition.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
   *
   * @return Whether the dataChange field is set.
   */
  @java.lang.Override
  public boolean hasDataChange() {
    return streamRecordCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * A mutation to the partition.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
   *
   * @return The dataChange.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange getDataChange() {
    if (streamRecordCase_ == 1) {
      return (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_;
    }
    return com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * A mutation to the partition.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamResponse.DataChangeOrBuilder
      getDataChangeOrBuilder() {
    if (streamRecordCase_ == 1) {
      return (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_;
    }
    return com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance();
  }

  public static final int HEARTBEAT_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * A periodic heartbeat message.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
   *
   * @return Whether the heartbeat field is set.
   */
  @java.lang.Override
  public boolean hasHeartbeat() {
    return streamRecordCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * A periodic heartbeat message.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
   *
   * @return The heartbeat.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat getHeartbeat() {
    if (streamRecordCase_ == 2) {
      return (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_;
    }
    return com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * A periodic heartbeat message.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamResponse.HeartbeatOrBuilder
      getHeartbeatOrBuilder() {
    if (streamRecordCase_ == 2) {
      return (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_;
    }
    return com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
  }

  public static final int CLOSE_STREAM_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * An indication that the stream should be closed.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
   *
   * @return Whether the closeStream field is set.
   */
  @java.lang.Override
  public boolean hasCloseStream() {
    return streamRecordCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * An indication that the stream should be closed.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
   *
   * @return The closeStream.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream getCloseStream() {
    if (streamRecordCase_ == 3) {
      return (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_;
    }
    return com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * An indication that the stream should be closed.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStreamOrBuilder
      getCloseStreamOrBuilder() {
    if (streamRecordCase_ == 3) {
      return (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_;
    }
    return com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (streamRecordCase_ == 1) {
      output.writeMessage(
          1, (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_);
    }
    if (streamRecordCase_ == 2) {
      output.writeMessage(
          2, (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_);
    }
    if (streamRecordCase_ == 3) {
      output.writeMessage(
          3, (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (streamRecordCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_);
    }
    if (streamRecordCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_);
    }
    if (streamRecordCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.ReadChangeStreamResponse)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.ReadChangeStreamResponse other =
        (com.google.bigtable.v2.ReadChangeStreamResponse) obj;

    if (!getStreamRecordCase().equals(other.getStreamRecordCase())) return false;
    switch (streamRecordCase_) {
      case 1:
        if (!getDataChange().equals(other.getDataChange())) return false;
        break;
      case 2:
        if (!getHeartbeat().equals(other.getHeartbeat())) return false;
        break;
      case 3:
        if (!getCloseStream().equals(other.getCloseStream())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (streamRecordCase_) {
      case 1:
        hash = (37 * hash) + DATA_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getDataChange().hashCode();
        break;
      case 2:
        hash = (37 * hash) + HEARTBEAT_FIELD_NUMBER;
        hash = (53 * hash) + getHeartbeat().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CLOSE_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getCloseStream().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.ReadChangeStreamResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * NOTE: This API is intended to be used by Apache Beam BigtableIO.
   * Response message for Bigtable.ReadChangeStream.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadChangeStreamResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadChangeStreamResponse)
      com.google.bigtable.v2.ReadChangeStreamResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadChangeStreamResponse.class,
              com.google.bigtable.v2.ReadChangeStreamResponse.Builder.class);
    }

    // Construct using com.google.bigtable.v2.ReadChangeStreamResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dataChangeBuilder_ != null) {
        dataChangeBuilder_.clear();
      }
      if (heartbeatBuilder_ != null) {
        heartbeatBuilder_.clear();
      }
      if (closeStreamBuilder_ != null) {
        closeStreamBuilder_.clear();
      }
      streamRecordCase_ = 0;
      streamRecord_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamResponse_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse getDefaultInstanceForType() {
      return com.google.bigtable.v2.ReadChangeStreamResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse build() {
      com.google.bigtable.v2.ReadChangeStreamResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse buildPartial() {
      com.google.bigtable.v2.ReadChangeStreamResponse result =
          new com.google.bigtable.v2.ReadChangeStreamResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.ReadChangeStreamResponse result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.v2.ReadChangeStreamResponse result) {
      result.streamRecordCase_ = streamRecordCase_;
      result.streamRecord_ = this.streamRecord_;
      if (streamRecordCase_ == 1 && dataChangeBuilder_ != null) {
        result.streamRecord_ = dataChangeBuilder_.build();
      }
      if (streamRecordCase_ == 2 && heartbeatBuilder_ != null) {
        result.streamRecord_ = heartbeatBuilder_.build();
      }
      if (streamRecordCase_ == 3 && closeStreamBuilder_ != null) {
        result.streamRecord_ = closeStreamBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.ReadChangeStreamResponse) {
        return mergeFrom((com.google.bigtable.v2.ReadChangeStreamResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.ReadChangeStreamResponse other) {
      if (other == com.google.bigtable.v2.ReadChangeStreamResponse.getDefaultInstance())
        return this;
      switch (other.getStreamRecordCase()) {
        case DATA_CHANGE:
          {
            mergeDataChange(other.getDataChange());
            break;
          }
        case HEARTBEAT:
          {
            mergeHeartbeat(other.getHeartbeat());
            break;
          }
        case CLOSE_STREAM:
          {
            mergeCloseStream(other.getCloseStream());
            break;
          }
        case STREAMRECORD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDataChangeFieldBuilder().getBuilder(), extensionRegistry);
                streamRecordCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getHeartbeatFieldBuilder().getBuilder(), extensionRegistry);
                streamRecordCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCloseStreamFieldBuilder().getBuilder(), extensionRegistry);
                streamRecordCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int streamRecordCase_ = 0;
    private java.lang.Object streamRecord_;

    public StreamRecordCase getStreamRecordCase() {
      return StreamRecordCase.forNumber(streamRecordCase_);
    }

    public Builder clearStreamRecord() {
      streamRecordCase_ = 0;
      streamRecord_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadChangeStreamResponse.DataChange,
            com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Builder,
            com.google.bigtable.v2.ReadChangeStreamResponse.DataChangeOrBuilder>
        dataChangeBuilder_;

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     *
     * @return Whether the dataChange field is set.
     */
    @java.lang.Override
    public boolean hasDataChange() {
      return streamRecordCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     *
     * @return The dataChange.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange getDataChange() {
      if (dataChangeBuilder_ == null) {
        if (streamRecordCase_ == 1) {
          return (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_;
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance();
      } else {
        if (streamRecordCase_ == 1) {
          return dataChangeBuilder_.getMessage();
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     */
    public Builder setDataChange(com.google.bigtable.v2.ReadChangeStreamResponse.DataChange value) {
      if (dataChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamRecord_ = value;
        onChanged();
      } else {
        dataChangeBuilder_.setMessage(value);
      }
      streamRecordCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     */
    public Builder setDataChange(
        com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Builder builderForValue) {
      if (dataChangeBuilder_ == null) {
        streamRecord_ = builderForValue.build();
        onChanged();
      } else {
        dataChangeBuilder_.setMessage(builderForValue.build());
      }
      streamRecordCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     */
    public Builder mergeDataChange(
        com.google.bigtable.v2.ReadChangeStreamResponse.DataChange value) {
      if (dataChangeBuilder_ == null) {
        if (streamRecordCase_ == 1
            && streamRecord_
                != com.google.bigtable.v2.ReadChangeStreamResponse.DataChange
                    .getDefaultInstance()) {
          streamRecord_ =
              com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.newBuilder(
                      (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          streamRecord_ = value;
        }
        onChanged();
      } else {
        if (streamRecordCase_ == 1) {
          dataChangeBuilder_.mergeFrom(value);
        } else {
          dataChangeBuilder_.setMessage(value);
        }
      }
      streamRecordCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     */
    public Builder clearDataChange() {
      if (dataChangeBuilder_ == null) {
        if (streamRecordCase_ == 1) {
          streamRecordCase_ = 0;
          streamRecord_ = null;
          onChanged();
        }
      } else {
        if (streamRecordCase_ == 1) {
          streamRecordCase_ = 0;
          streamRecord_ = null;
        }
        dataChangeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     */
    public com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Builder
        getDataChangeBuilder() {
      return getDataChangeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.DataChangeOrBuilder
        getDataChangeOrBuilder() {
      if ((streamRecordCase_ == 1) && (dataChangeBuilder_ != null)) {
        return dataChangeBuilder_.getMessageOrBuilder();
      } else {
        if (streamRecordCase_ == 1) {
          return (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_;
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A mutation to the partition.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange data_change = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadChangeStreamResponse.DataChange,
            com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Builder,
            com.google.bigtable.v2.ReadChangeStreamResponse.DataChangeOrBuilder>
        getDataChangeFieldBuilder() {
      if (dataChangeBuilder_ == null) {
        if (!(streamRecordCase_ == 1)) {
          streamRecord_ =
              com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.getDefaultInstance();
        }
        dataChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.ReadChangeStreamResponse.DataChange,
                com.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Builder,
                com.google.bigtable.v2.ReadChangeStreamResponse.DataChangeOrBuilder>(
                (com.google.bigtable.v2.ReadChangeStreamResponse.DataChange) streamRecord_,
                getParentForChildren(),
                isClean());
        streamRecord_ = null;
      }
      streamRecordCase_ = 1;
      onChanged();
      return dataChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat,
            com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.Builder,
            com.google.bigtable.v2.ReadChangeStreamResponse.HeartbeatOrBuilder>
        heartbeatBuilder_;

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     *
     * @return Whether the heartbeat field is set.
     */
    @java.lang.Override
    public boolean hasHeartbeat() {
      return streamRecordCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     *
     * @return The heartbeat.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat getHeartbeat() {
      if (heartbeatBuilder_ == null) {
        if (streamRecordCase_ == 2) {
          return (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_;
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
      } else {
        if (streamRecordCase_ == 2) {
          return heartbeatBuilder_.getMessage();
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     */
    public Builder setHeartbeat(com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat value) {
      if (heartbeatBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamRecord_ = value;
        onChanged();
      } else {
        heartbeatBuilder_.setMessage(value);
      }
      streamRecordCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     */
    public Builder setHeartbeat(
        com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.Builder builderForValue) {
      if (heartbeatBuilder_ == null) {
        streamRecord_ = builderForValue.build();
        onChanged();
      } else {
        heartbeatBuilder_.setMessage(builderForValue.build());
      }
      streamRecordCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     */
    public Builder mergeHeartbeat(com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat value) {
      if (heartbeatBuilder_ == null) {
        if (streamRecordCase_ == 2
            && streamRecord_
                != com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance()) {
          streamRecord_ =
              com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.newBuilder(
                      (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          streamRecord_ = value;
        }
        onChanged();
      } else {
        if (streamRecordCase_ == 2) {
          heartbeatBuilder_.mergeFrom(value);
        } else {
          heartbeatBuilder_.setMessage(value);
        }
      }
      streamRecordCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     */
    public Builder clearHeartbeat() {
      if (heartbeatBuilder_ == null) {
        if (streamRecordCase_ == 2) {
          streamRecordCase_ = 0;
          streamRecord_ = null;
          onChanged();
        }
      } else {
        if (streamRecordCase_ == 2) {
          streamRecordCase_ = 0;
          streamRecord_ = null;
        }
        heartbeatBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     */
    public com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.Builder getHeartbeatBuilder() {
      return getHeartbeatFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.HeartbeatOrBuilder
        getHeartbeatOrBuilder() {
      if ((streamRecordCase_ == 2) && (heartbeatBuilder_ != null)) {
        return heartbeatBuilder_.getMessageOrBuilder();
      } else {
        if (streamRecordCase_ == 2) {
          return (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_;
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A periodic heartbeat message.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat heartbeat = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat,
            com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.Builder,
            com.google.bigtable.v2.ReadChangeStreamResponse.HeartbeatOrBuilder>
        getHeartbeatFieldBuilder() {
      if (heartbeatBuilder_ == null) {
        if (!(streamRecordCase_ == 2)) {
          streamRecord_ =
              com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
        }
        heartbeatBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat,
                com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.Builder,
                com.google.bigtable.v2.ReadChangeStreamResponse.HeartbeatOrBuilder>(
                (com.google.bigtable.v2.ReadChangeStreamResponse.Heartbeat) streamRecord_,
                getParentForChildren(),
                isClean());
        streamRecord_ = null;
      }
      streamRecordCase_ = 2;
      onChanged();
      return heartbeatBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream,
            com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.Builder,
            com.google.bigtable.v2.ReadChangeStreamResponse.CloseStreamOrBuilder>
        closeStreamBuilder_;

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     *
     * @return Whether the closeStream field is set.
     */
    @java.lang.Override
    public boolean hasCloseStream() {
      return streamRecordCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     *
     * @return The closeStream.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream getCloseStream() {
      if (closeStreamBuilder_ == null) {
        if (streamRecordCase_ == 3) {
          return (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_;
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance();
      } else {
        if (streamRecordCase_ == 3) {
          return closeStreamBuilder_.getMessage();
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     */
    public Builder setCloseStream(
        com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream value) {
      if (closeStreamBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamRecord_ = value;
        onChanged();
      } else {
        closeStreamBuilder_.setMessage(value);
      }
      streamRecordCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     */
    public Builder setCloseStream(
        com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.Builder builderForValue) {
      if (closeStreamBuilder_ == null) {
        streamRecord_ = builderForValue.build();
        onChanged();
      } else {
        closeStreamBuilder_.setMessage(builderForValue.build());
      }
      streamRecordCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     */
    public Builder mergeCloseStream(
        com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream value) {
      if (closeStreamBuilder_ == null) {
        if (streamRecordCase_ == 3
            && streamRecord_
                != com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream
                    .getDefaultInstance()) {
          streamRecord_ =
              com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.newBuilder(
                      (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          streamRecord_ = value;
        }
        onChanged();
      } else {
        if (streamRecordCase_ == 3) {
          closeStreamBuilder_.mergeFrom(value);
        } else {
          closeStreamBuilder_.setMessage(value);
        }
      }
      streamRecordCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     */
    public Builder clearCloseStream() {
      if (closeStreamBuilder_ == null) {
        if (streamRecordCase_ == 3) {
          streamRecordCase_ = 0;
          streamRecord_ = null;
          onChanged();
        }
      } else {
        if (streamRecordCase_ == 3) {
          streamRecordCase_ = 0;
          streamRecord_ = null;
        }
        closeStreamBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     */
    public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.Builder
        getCloseStreamBuilder() {
      return getCloseStreamFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamResponse.CloseStreamOrBuilder
        getCloseStreamOrBuilder() {
      if ((streamRecordCase_ == 3) && (closeStreamBuilder_ != null)) {
        return closeStreamBuilder_.getMessageOrBuilder();
      } else {
        if (streamRecordCase_ == 3) {
          return (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_;
        }
        return com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An indication that the stream should be closed.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadChangeStreamResponse.CloseStream close_stream = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream,
            com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.Builder,
            com.google.bigtable.v2.ReadChangeStreamResponse.CloseStreamOrBuilder>
        getCloseStreamFieldBuilder() {
      if (closeStreamBuilder_ == null) {
        if (!(streamRecordCase_ == 3)) {
          streamRecord_ =
              com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.getDefaultInstance();
        }
        closeStreamBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream,
                com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream.Builder,
                com.google.bigtable.v2.ReadChangeStreamResponse.CloseStreamOrBuilder>(
                (com.google.bigtable.v2.ReadChangeStreamResponse.CloseStream) streamRecord_,
                getParentForChildren(),
                isClean());
        streamRecord_ = null;
      }
      streamRecordCase_ = 3;
      onChanged();
      return closeStreamBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadChangeStreamResponse)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadChangeStreamResponse)
  private static final com.google.bigtable.v2.ReadChangeStreamResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadChangeStreamResponse();
  }

  public static com.google.bigtable.v2.ReadChangeStreamResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadChangeStreamResponse> PARSER =
      new com.google.protobuf.AbstractParser<ReadChangeStreamResponse>() {
        @java.lang.Override
        public ReadChangeStreamResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadChangeStreamResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadChangeStreamResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
