/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.example.bigtable;

import static org.junit.Assert.assertThat;

import org.hamcrest.CoreMatchers;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class ConfigureConnectionPoolTest extends BigtableBaseTest {

  @BeforeClass
  public static void beforeClass() {
    initializeVariables();
  }

  @Test
  public void testConfigureConnectionPool() {
    ConfigureConnectionPool.configureConnectionPool(projectId, instanceId);

    String output = bout.toString();
    assertThat(output, CoreMatchers.containsString("Connected with pool size of 10"));
  }
}
