/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/bigtable/admin/v2/bigtable_table_admin.proto
// Protobuf Java Version: 4.33.2

package com.google.bigtable.admin.v2;

@com.google.protobuf.Generated
public interface ListBackupsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.ListBackupsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The cluster to list backups from.  Values are of the
   * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * Use `{cluster} = '-'` to list backups for all clusters in an instance,
   * e.g., `projects/{project}/instances/{instance}/clusters/-`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The cluster to list backups from.  Values are of the
   * form `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * Use `{cluster} = '-'` to list backups for all clusters in an instance,
   * e.g., `projects/{project}/instances/{instance}/clusters/-`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * A filter expression that filters backups listed in the response.
   * The expression must specify the field name, a comparison operator,
   * and the value that you want to use for filtering. The value must be a
   * string, a number, or a boolean. The comparison operator must be
   * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
   * roughly synonymous with equality. Filter rules are case insensitive.
   *
   * The fields eligible for filtering are:
   *
   * * `name`
   * * `source_table`
   * * `state`
   * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `size_bytes`
   *
   * To filter on multiple expressions, provide each separate expression within
   * parentheses. By default, each expression is an AND expression. However,
   * you can include AND, OR, and NOT expressions explicitly.
   *
   * Some examples of using filters are:
   *
   * * `name:"exact"` --&gt; The backup's name is the string "exact".
   * * `name:howl` --&gt; The backup's name contains the string "howl".
   * * `source_table:prod`
   * --&gt; The source_table's name contains the string "prod".
   * * `state:CREATING` --&gt; The backup is pending creation.
   * * `state:READY` --&gt; The backup is fully created and ready for use.
   * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
   * --&gt; The backup name contains the string "howl" and start_time
   * of the backup is before 2018-03-28T14:50:00Z.
   * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();

  /**
   *
   *
   * <pre>
   * A filter expression that filters backups listed in the response.
   * The expression must specify the field name, a comparison operator,
   * and the value that you want to use for filtering. The value must be a
   * string, a number, or a boolean. The comparison operator must be
   * &lt;, &gt;, &lt;=, &gt;=, !=, =, or :. Colon ':' represents a HAS operator which is
   * roughly synonymous with equality. Filter rules are case insensitive.
   *
   * The fields eligible for filtering are:
   *
   * * `name`
   * * `source_table`
   * * `state`
   * * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
   * * `size_bytes`
   *
   * To filter on multiple expressions, provide each separate expression within
   * parentheses. By default, each expression is an AND expression. However,
   * you can include AND, OR, and NOT expressions explicitly.
   *
   * Some examples of using filters are:
   *
   * * `name:"exact"` --&gt; The backup's name is the string "exact".
   * * `name:howl` --&gt; The backup's name contains the string "howl".
   * * `source_table:prod`
   * --&gt; The source_table's name contains the string "prod".
   * * `state:CREATING` --&gt; The backup is pending creation.
   * * `state:READY` --&gt; The backup is fully created and ready for use.
   * * `(name:howl) AND (start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;")`
   * --&gt; The backup name contains the string "howl" and start_time
   * of the backup is before 2018-03-28T14:50:00Z.
   * * `size_bytes &gt; 10000000000` --&gt; The backup's size is greater than 10GB
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * An expression for specifying the sort order of the results of the request.
   * The string value should specify one or more fields in
   * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
   * https://aip.dev/132#ordering.
   *
   * Fields supported are:
   *
   * * name
   * * source_table
   * * expire_time
   * * start_time
   * * end_time
   * * size_bytes
   * * state
   *
   * For example, "start_time". The default sorting order is ascending.
   * To specify descending order for the field, a suffix " desc" should
   * be appended to the field name. For example, "start_time desc".
   * Redundant space characters in the syntax are insigificant.
   *
   * If order_by is empty, results will be sorted by `start_time` in descending
   * order starting from the most recently created backup.
   * </pre>
   *
   * <code>string order_by = 3;</code>
   *
   * @return The orderBy.
   */
  java.lang.String getOrderBy();

  /**
   *
   *
   * <pre>
   * An expression for specifying the sort order of the results of the request.
   * The string value should specify one or more fields in
   * [Backup][google.bigtable.admin.v2.Backup]. The full syntax is described at
   * https://aip.dev/132#ordering.
   *
   * Fields supported are:
   *
   * * name
   * * source_table
   * * expire_time
   * * start_time
   * * end_time
   * * size_bytes
   * * state
   *
   * For example, "start_time". The default sorting order is ascending.
   * To specify descending order for the field, a suffix " desc" should
   * be appended to the field name. For example, "start_time desc".
   * Redundant space characters in the syntax are insigificant.
   *
   * If order_by is empty, results will be sorted by `start_time` in descending
   * order starting from the most recently created backup.
   * </pre>
   *
   * <code>string order_by = 3;</code>
   *
   * @return The bytes for orderBy.
   */
  com.google.protobuf.ByteString getOrderByBytes();

  /**
   *
   *
   * <pre>
   * Number of backups to be returned in the response. If 0 or
   * less, defaults to the server's maximum allowed page size.
   * </pre>
   *
   * <code>int32 page_size = 4;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
   * from a previous
   * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
   * same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();

  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.bigtable.admin.v2.ListBackupsResponse.next_page_token]
   * from a previous
   * [ListBackupsResponse][google.bigtable.admin.v2.ListBackupsResponse] to the
   * same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 5;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();
}
