/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/bigtable/admin/v2/bigtable_table_admin.proto
// Protobuf Java Version: 4.33.2

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * Metadata type for the long-running operation returned by
 * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable].
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.RestoreTableMetadata}
 */
@com.google.protobuf.Generated
public final class RestoreTableMetadata extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.RestoreTableMetadata)
    RestoreTableMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "RestoreTableMetadata");
  }

  // Use RestoreTableMetadata.newBuilder() to construct.
  private RestoreTableMetadata(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private RestoreTableMetadata() {
    name_ = "";
    sourceType_ = 0;
    optimizeTableOperationName_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_RestoreTableMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_RestoreTableMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.RestoreTableMetadata.class,
            com.google.bigtable.admin.v2.RestoreTableMetadata.Builder.class);
  }

  private int bitField0_;
  private int sourceInfoCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceInfo_;

  public enum SourceInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BACKUP_INFO(3),
    SOURCEINFO_NOT_SET(0);
    private final int value;

    private SourceInfoCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceInfoCase forNumber(int value) {
      switch (value) {
        case 3:
          return BACKUP_INFO;
        case 0:
          return SOURCEINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceInfoCase getSourceInfoCase() {
    return SourceInfoCase.forNumber(sourceInfoCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the table being created and restored to.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the table being created and restored to.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TYPE_FIELD_NUMBER = 2;
  private int sourceType_ = 0;

  /**
   *
   *
   * <pre>
   * The type of the restore source.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.RestoreSourceType source_type = 2;</code>
   *
   * @return The enum numeric value on the wire for sourceType.
   */
  @java.lang.Override
  public int getSourceTypeValue() {
    return sourceType_;
  }

  /**
   *
   *
   * <pre>
   * The type of the restore source.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.RestoreSourceType source_type = 2;</code>
   *
   * @return The sourceType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.RestoreSourceType getSourceType() {
    com.google.bigtable.admin.v2.RestoreSourceType result =
        com.google.bigtable.admin.v2.RestoreSourceType.forNumber(sourceType_);
    return result == null ? com.google.bigtable.admin.v2.RestoreSourceType.UNRECOGNIZED : result;
  }

  public static final int BACKUP_INFO_FIELD_NUMBER = 3;

  /**
   * <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code>
   *
   * @return Whether the backupInfo field is set.
   */
  @java.lang.Override
  public boolean hasBackupInfo() {
    return sourceInfoCase_ == 3;
  }

  /**
   * <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code>
   *
   * @return The backupInfo.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.BackupInfo getBackupInfo() {
    if (sourceInfoCase_ == 3) {
      return (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_;
    }
    return com.google.bigtable.admin.v2.BackupInfo.getDefaultInstance();
  }

  /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
  @java.lang.Override
  public com.google.bigtable.admin.v2.BackupInfoOrBuilder getBackupInfoOrBuilder() {
    if (sourceInfoCase_ == 3) {
      return (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_;
    }
    return com.google.bigtable.admin.v2.BackupInfo.getDefaultInstance();
  }

  public static final int OPTIMIZE_TABLE_OPERATION_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object optimizeTableOperationName_ = "";

  /**
   *
   *
   * <pre>
   * If exists, the name of the long-running operation that will be used to
   * track the post-restore optimization process to optimize the performance of
   * the restored table. The metadata type of the long-running operation is
   * [OptimizeRestoreTableMetadata][]. The response type is
   * [Empty][google.protobuf.Empty]. This long-running operation may be
   * automatically created by the system if applicable after the
   * RestoreTable long-running operation completes successfully. This operation
   * may not be created if the table is already optimized or the restore was
   * not successful.
   * </pre>
   *
   * <code>string optimize_table_operation_name = 4;</code>
   *
   * @return The optimizeTableOperationName.
   */
  @java.lang.Override
  public java.lang.String getOptimizeTableOperationName() {
    java.lang.Object ref = optimizeTableOperationName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      optimizeTableOperationName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If exists, the name of the long-running operation that will be used to
   * track the post-restore optimization process to optimize the performance of
   * the restored table. The metadata type of the long-running operation is
   * [OptimizeRestoreTableMetadata][]. The response type is
   * [Empty][google.protobuf.Empty]. This long-running operation may be
   * automatically created by the system if applicable after the
   * RestoreTable long-running operation completes successfully. This operation
   * may not be created if the table is already optimized or the restore was
   * not successful.
   * </pre>
   *
   * <code>string optimize_table_operation_name = 4;</code>
   *
   * @return The bytes for optimizeTableOperationName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOptimizeTableOperationNameBytes() {
    java.lang.Object ref = optimizeTableOperationName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      optimizeTableOperationName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROGRESS_FIELD_NUMBER = 5;
  private com.google.bigtable.admin.v2.OperationProgress progress_;

  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
   * operation.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
   *
   * @return Whether the progress field is set.
   */
  @java.lang.Override
  public boolean hasProgress() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
   * operation.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
   *
   * @return The progress.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.OperationProgress getProgress() {
    return progress_ == null
        ? com.google.bigtable.admin.v2.OperationProgress.getDefaultInstance()
        : progress_;
  }

  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
   * operation.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.OperationProgressOrBuilder getProgressOrBuilder() {
    return progress_ == null
        ? com.google.bigtable.admin.v2.OperationProgress.getDefaultInstance()
        : progress_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
    }
    if (sourceType_
        != com.google.bigtable.admin.v2.RestoreSourceType.RESTORE_SOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, sourceType_);
    }
    if (sourceInfoCase_ == 3) {
      output.writeMessage(3, (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(optimizeTableOperationName_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, optimizeTableOperationName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getProgress());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
    }
    if (sourceType_
        != com.google.bigtable.admin.v2.RestoreSourceType.RESTORE_SOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, sourceType_);
    }
    if (sourceInfoCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(optimizeTableOperationName_)) {
      size +=
          com.google.protobuf.GeneratedMessage.computeStringSize(4, optimizeTableOperationName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProgress());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.RestoreTableMetadata)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.RestoreTableMetadata other =
        (com.google.bigtable.admin.v2.RestoreTableMetadata) obj;

    if (!getName().equals(other.getName())) return false;
    if (sourceType_ != other.sourceType_) return false;
    if (!getOptimizeTableOperationName().equals(other.getOptimizeTableOperationName()))
      return false;
    if (hasProgress() != other.hasProgress()) return false;
    if (hasProgress()) {
      if (!getProgress().equals(other.getProgress())) return false;
    }
    if (!getSourceInfoCase().equals(other.getSourceInfoCase())) return false;
    switch (sourceInfoCase_) {
      case 3:
        if (!getBackupInfo().equals(other.getBackupInfo())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + sourceType_;
    hash = (37 * hash) + OPTIMIZE_TABLE_OPERATION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getOptimizeTableOperationName().hashCode();
    if (hasProgress()) {
      hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + getProgress().hashCode();
    }
    switch (sourceInfoCase_) {
      case 3:
        hash = (37 * hash) + BACKUP_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getBackupInfo().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.RestoreTableMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata type for the long-running operation returned by
   * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable].
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.RestoreTableMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.RestoreTableMetadata)
      com.google.bigtable.admin.v2.RestoreTableMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_RestoreTableMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_RestoreTableMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.RestoreTableMetadata.class,
              com.google.bigtable.admin.v2.RestoreTableMetadata.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.RestoreTableMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetProgressFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      sourceType_ = 0;
      if (backupInfoBuilder_ != null) {
        backupInfoBuilder_.clear();
      }
      optimizeTableOperationName_ = "";
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      sourceInfoCase_ = 0;
      sourceInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_RestoreTableMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.RestoreTableMetadata getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.RestoreTableMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.RestoreTableMetadata build() {
      com.google.bigtable.admin.v2.RestoreTableMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.RestoreTableMetadata buildPartial() {
      com.google.bigtable.admin.v2.RestoreTableMetadata result =
          new com.google.bigtable.admin.v2.RestoreTableMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.RestoreTableMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sourceType_ = sourceType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.optimizeTableOperationName_ = optimizeTableOperationName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.progress_ = progressBuilder_ == null ? progress_ : progressBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.admin.v2.RestoreTableMetadata result) {
      result.sourceInfoCase_ = sourceInfoCase_;
      result.sourceInfo_ = this.sourceInfo_;
      if (sourceInfoCase_ == 3 && backupInfoBuilder_ != null) {
        result.sourceInfo_ = backupInfoBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.RestoreTableMetadata) {
        return mergeFrom((com.google.bigtable.admin.v2.RestoreTableMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.RestoreTableMetadata other) {
      if (other == com.google.bigtable.admin.v2.RestoreTableMetadata.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.sourceType_ != 0) {
        setSourceTypeValue(other.getSourceTypeValue());
      }
      if (!other.getOptimizeTableOperationName().isEmpty()) {
        optimizeTableOperationName_ = other.optimizeTableOperationName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasProgress()) {
        mergeProgress(other.getProgress());
      }
      switch (other.getSourceInfoCase()) {
        case BACKUP_INFO:
          {
            mergeBackupInfo(other.getBackupInfo());
            break;
          }
        case SOURCEINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                sourceType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    internalGetBackupInfoFieldBuilder().getBuilder(), extensionRegistry);
                sourceInfoCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                optimizeTableOperationName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    internalGetProgressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceInfoCase_ = 0;
    private java.lang.Object sourceInfo_;

    public SourceInfoCase getSourceInfoCase() {
      return SourceInfoCase.forNumber(sourceInfoCase_);
    }

    public Builder clearSourceInfo() {
      sourceInfoCase_ = 0;
      sourceInfo_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the table being created and restored to.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the table being created and restored to.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the table being created and restored to.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the table being created and restored to.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the table being created and restored to.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int sourceType_ = 0;

    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.RestoreSourceType source_type = 2;</code>
     *
     * @return The enum numeric value on the wire for sourceType.
     */
    @java.lang.Override
    public int getSourceTypeValue() {
      return sourceType_;
    }

    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.RestoreSourceType source_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTypeValue(int value) {
      sourceType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.RestoreSourceType source_type = 2;</code>
     *
     * @return The sourceType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.RestoreSourceType getSourceType() {
      com.google.bigtable.admin.v2.RestoreSourceType result =
          com.google.bigtable.admin.v2.RestoreSourceType.forNumber(sourceType_);
      return result == null ? com.google.bigtable.admin.v2.RestoreSourceType.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.RestoreSourceType source_type = 2;</code>
     *
     * @param value The sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceType(com.google.bigtable.admin.v2.RestoreSourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      sourceType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.RestoreSourceType source_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      sourceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.BackupInfo,
            com.google.bigtable.admin.v2.BackupInfo.Builder,
            com.google.bigtable.admin.v2.BackupInfoOrBuilder>
        backupInfoBuilder_;

    /**
     * <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code>
     *
     * @return Whether the backupInfo field is set.
     */
    @java.lang.Override
    public boolean hasBackupInfo() {
      return sourceInfoCase_ == 3;
    }

    /**
     * <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code>
     *
     * @return The backupInfo.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.BackupInfo getBackupInfo() {
      if (backupInfoBuilder_ == null) {
        if (sourceInfoCase_ == 3) {
          return (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_;
        }
        return com.google.bigtable.admin.v2.BackupInfo.getDefaultInstance();
      } else {
        if (sourceInfoCase_ == 3) {
          return backupInfoBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.BackupInfo.getDefaultInstance();
      }
    }

    /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
    public Builder setBackupInfo(com.google.bigtable.admin.v2.BackupInfo value) {
      if (backupInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceInfo_ = value;
        onChanged();
      } else {
        backupInfoBuilder_.setMessage(value);
      }
      sourceInfoCase_ = 3;
      return this;
    }

    /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
    public Builder setBackupInfo(com.google.bigtable.admin.v2.BackupInfo.Builder builderForValue) {
      if (backupInfoBuilder_ == null) {
        sourceInfo_ = builderForValue.build();
        onChanged();
      } else {
        backupInfoBuilder_.setMessage(builderForValue.build());
      }
      sourceInfoCase_ = 3;
      return this;
    }

    /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
    public Builder mergeBackupInfo(com.google.bigtable.admin.v2.BackupInfo value) {
      if (backupInfoBuilder_ == null) {
        if (sourceInfoCase_ == 3
            && sourceInfo_ != com.google.bigtable.admin.v2.BackupInfo.getDefaultInstance()) {
          sourceInfo_ =
              com.google.bigtable.admin.v2.BackupInfo.newBuilder(
                      (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceInfo_ = value;
        }
        onChanged();
      } else {
        if (sourceInfoCase_ == 3) {
          backupInfoBuilder_.mergeFrom(value);
        } else {
          backupInfoBuilder_.setMessage(value);
        }
      }
      sourceInfoCase_ = 3;
      return this;
    }

    /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
    public Builder clearBackupInfo() {
      if (backupInfoBuilder_ == null) {
        if (sourceInfoCase_ == 3) {
          sourceInfoCase_ = 0;
          sourceInfo_ = null;
          onChanged();
        }
      } else {
        if (sourceInfoCase_ == 3) {
          sourceInfoCase_ = 0;
          sourceInfo_ = null;
        }
        backupInfoBuilder_.clear();
      }
      return this;
    }

    /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
    public com.google.bigtable.admin.v2.BackupInfo.Builder getBackupInfoBuilder() {
      return internalGetBackupInfoFieldBuilder().getBuilder();
    }

    /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
    @java.lang.Override
    public com.google.bigtable.admin.v2.BackupInfoOrBuilder getBackupInfoOrBuilder() {
      if ((sourceInfoCase_ == 3) && (backupInfoBuilder_ != null)) {
        return backupInfoBuilder_.getMessageOrBuilder();
      } else {
        if (sourceInfoCase_ == 3) {
          return (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_;
        }
        return com.google.bigtable.admin.v2.BackupInfo.getDefaultInstance();
      }
    }

    /** <code>.google.bigtable.admin.v2.BackupInfo backup_info = 3;</code> */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.BackupInfo,
            com.google.bigtable.admin.v2.BackupInfo.Builder,
            com.google.bigtable.admin.v2.BackupInfoOrBuilder>
        internalGetBackupInfoFieldBuilder() {
      if (backupInfoBuilder_ == null) {
        if (!(sourceInfoCase_ == 3)) {
          sourceInfo_ = com.google.bigtable.admin.v2.BackupInfo.getDefaultInstance();
        }
        backupInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.BackupInfo,
                com.google.bigtable.admin.v2.BackupInfo.Builder,
                com.google.bigtable.admin.v2.BackupInfoOrBuilder>(
                (com.google.bigtable.admin.v2.BackupInfo) sourceInfo_,
                getParentForChildren(),
                isClean());
        sourceInfo_ = null;
      }
      sourceInfoCase_ = 3;
      onChanged();
      return backupInfoBuilder_;
    }

    private java.lang.Object optimizeTableOperationName_ = "";

    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored table. The metadata type of the long-running operation is
     * [OptimizeRestoreTableMetadata][]. The response type is
     * [Empty][google.protobuf.Empty]. This long-running operation may be
     * automatically created by the system if applicable after the
     * RestoreTable long-running operation completes successfully. This operation
     * may not be created if the table is already optimized or the restore was
     * not successful.
     * </pre>
     *
     * <code>string optimize_table_operation_name = 4;</code>
     *
     * @return The optimizeTableOperationName.
     */
    public java.lang.String getOptimizeTableOperationName() {
      java.lang.Object ref = optimizeTableOperationName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizeTableOperationName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored table. The metadata type of the long-running operation is
     * [OptimizeRestoreTableMetadata][]. The response type is
     * [Empty][google.protobuf.Empty]. This long-running operation may be
     * automatically created by the system if applicable after the
     * RestoreTable long-running operation completes successfully. This operation
     * may not be created if the table is already optimized or the restore was
     * not successful.
     * </pre>
     *
     * <code>string optimize_table_operation_name = 4;</code>
     *
     * @return The bytes for optimizeTableOperationName.
     */
    public com.google.protobuf.ByteString getOptimizeTableOperationNameBytes() {
      java.lang.Object ref = optimizeTableOperationName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizeTableOperationName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored table. The metadata type of the long-running operation is
     * [OptimizeRestoreTableMetadata][]. The response type is
     * [Empty][google.protobuf.Empty]. This long-running operation may be
     * automatically created by the system if applicable after the
     * RestoreTable long-running operation completes successfully. This operation
     * may not be created if the table is already optimized or the restore was
     * not successful.
     * </pre>
     *
     * <code>string optimize_table_operation_name = 4;</code>
     *
     * @param value The optimizeTableOperationName to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeTableOperationName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      optimizeTableOperationName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored table. The metadata type of the long-running operation is
     * [OptimizeRestoreTableMetadata][]. The response type is
     * [Empty][google.protobuf.Empty]. This long-running operation may be
     * automatically created by the system if applicable after the
     * RestoreTable long-running operation completes successfully. This operation
     * may not be created if the table is already optimized or the restore was
     * not successful.
     * </pre>
     *
     * <code>string optimize_table_operation_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptimizeTableOperationName() {
      optimizeTableOperationName_ = getDefaultInstance().getOptimizeTableOperationName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored table. The metadata type of the long-running operation is
     * [OptimizeRestoreTableMetadata][]. The response type is
     * [Empty][google.protobuf.Empty]. This long-running operation may be
     * automatically created by the system if applicable after the
     * RestoreTable long-running operation completes successfully. This operation
     * may not be created if the table is already optimized or the restore was
     * not successful.
     * </pre>
     *
     * <code>string optimize_table_operation_name = 4;</code>
     *
     * @param value The bytes for optimizeTableOperationName to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeTableOperationNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      optimizeTableOperationName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.bigtable.admin.v2.OperationProgress progress_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.OperationProgress,
            com.google.bigtable.admin.v2.OperationProgress.Builder,
            com.google.bigtable.admin.v2.OperationProgressOrBuilder>
        progressBuilder_;

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     *
     * @return Whether the progress field is set.
     */
    public boolean hasProgress() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     *
     * @return The progress.
     */
    public com.google.bigtable.admin.v2.OperationProgress getProgress() {
      if (progressBuilder_ == null) {
        return progress_ == null
            ? com.google.bigtable.admin.v2.OperationProgress.getDefaultInstance()
            : progress_;
      } else {
        return progressBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     */
    public Builder setProgress(com.google.bigtable.admin.v2.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progress_ = value;
      } else {
        progressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     */
    public Builder setProgress(
        com.google.bigtable.admin.v2.OperationProgress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        progress_ = builderForValue.build();
      } else {
        progressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     */
    public Builder mergeProgress(com.google.bigtable.admin.v2.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && progress_ != null
            && progress_ != com.google.bigtable.admin.v2.OperationProgress.getDefaultInstance()) {
          getProgressBuilder().mergeFrom(value);
        } else {
          progress_ = value;
        }
      } else {
        progressBuilder_.mergeFrom(value);
      }
      if (progress_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     */
    public Builder clearProgress() {
      bitField0_ = (bitField0_ & ~0x00000010);
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     */
    public com.google.bigtable.admin.v2.OperationProgress.Builder getProgressBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return internalGetProgressFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     */
    public com.google.bigtable.admin.v2.OperationProgressOrBuilder getProgressOrBuilder() {
      if (progressBuilder_ != null) {
        return progressBuilder_.getMessageOrBuilder();
      } else {
        return progress_ == null
            ? com.google.bigtable.admin.v2.OperationProgress.getDefaultInstance()
            : progress_;
      }
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable]
     * operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.OperationProgress progress = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.OperationProgress,
            com.google.bigtable.admin.v2.OperationProgress.Builder,
            com.google.bigtable.admin.v2.OperationProgressOrBuilder>
        internalGetProgressFieldBuilder() {
      if (progressBuilder_ == null) {
        progressBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.OperationProgress,
                com.google.bigtable.admin.v2.OperationProgress.Builder,
                com.google.bigtable.admin.v2.OperationProgressOrBuilder>(
                getProgress(), getParentForChildren(), isClean());
        progress_ = null;
      }
      return progressBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.RestoreTableMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.RestoreTableMetadata)
  private static final com.google.bigtable.admin.v2.RestoreTableMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.RestoreTableMetadata();
  }

  public static com.google.bigtable.admin.v2.RestoreTableMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreTableMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RestoreTableMetadata>() {
        @java.lang.Override
        public RestoreTableMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreTableMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreTableMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.RestoreTableMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
