/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/bigtable/v2/bigtable.proto
// Protobuf Java Version: 4.33.2

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Request message for Bigtable.ReadRows.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.ReadRowsRequest}
 */
@com.google.protobuf.Generated
public final class ReadRowsRequest extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadRowsRequest)
    ReadRowsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "ReadRowsRequest");
  }

  // Use ReadRowsRequest.newBuilder() to construct.
  private ReadRowsRequest(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private ReadRowsRequest() {
    tableName_ = "";
    authorizedViewName_ = "";
    materializedViewName_ = "";
    appProfileId_ = "";
    requestStatsView_ = 0;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadRowsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadRowsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.ReadRowsRequest.class,
            com.google.bigtable.v2.ReadRowsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The desired view into RequestStats that should be returned in the response.
   *
   * See also: RequestStats message.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.v2.ReadRowsRequest.RequestStatsView}
   */
  public enum RequestStatsView implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default / unset value. The API will default to the NONE option below.
     * </pre>
     *
     * <code>REQUEST_STATS_VIEW_UNSPECIFIED = 0;</code>
     */
    REQUEST_STATS_VIEW_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Do not include any RequestStats in the response. This will leave the
     * RequestStats embedded message unset in the response.
     * </pre>
     *
     * <code>REQUEST_STATS_NONE = 1;</code>
     */
    REQUEST_STATS_NONE(1),
    /**
     *
     *
     * <pre>
     * Include the full set of available RequestStats in the response,
     * applicable to this read.
     * </pre>
     *
     * <code>REQUEST_STATS_FULL = 2;</code>
     */
    REQUEST_STATS_FULL(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "RequestStatsView");
    }

    /**
     *
     *
     * <pre>
     * The default / unset value. The API will default to the NONE option below.
     * </pre>
     *
     * <code>REQUEST_STATS_VIEW_UNSPECIFIED = 0;</code>
     */
    public static final int REQUEST_STATS_VIEW_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Do not include any RequestStats in the response. This will leave the
     * RequestStats embedded message unset in the response.
     * </pre>
     *
     * <code>REQUEST_STATS_NONE = 1;</code>
     */
    public static final int REQUEST_STATS_NONE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Include the full set of available RequestStats in the response,
     * applicable to this read.
     * </pre>
     *
     * <code>REQUEST_STATS_FULL = 2;</code>
     */
    public static final int REQUEST_STATS_FULL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestStatsView valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RequestStatsView forNumber(int value) {
      switch (value) {
        case 0:
          return REQUEST_STATS_VIEW_UNSPECIFIED;
        case 1:
          return REQUEST_STATS_NONE;
        case 2:
          return REQUEST_STATS_FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RequestStatsView> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RequestStatsView>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RequestStatsView>() {
              public RequestStatsView findValueByNumber(int number) {
                return RequestStatsView.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.v2.ReadRowsRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final RequestStatsView[] VALUES = values();

    public static RequestStatsView valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RequestStatsView(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.v2.ReadRowsRequest.RequestStatsView)
  }

  private int bitField0_;
  public static final int TABLE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The unique name of the table from which to read.
   *
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The unique name of the table from which to read.
   *
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTHORIZED_VIEW_NAME_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object authorizedViewName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The unique name of the AuthorizedView from which to read.
   *
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;/authorizedViews/&lt;authorized_view&gt;`.
   * </pre>
   *
   * <code>
   * string authorized_view_name = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The authorizedViewName.
   */
  @java.lang.Override
  public java.lang.String getAuthorizedViewName() {
    java.lang.Object ref = authorizedViewName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authorizedViewName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The unique name of the AuthorizedView from which to read.
   *
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;/authorizedViews/&lt;authorized_view&gt;`.
   * </pre>
   *
   * <code>
   * string authorized_view_name = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for authorizedViewName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthorizedViewNameBytes() {
    java.lang.Object ref = authorizedViewName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authorizedViewName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATERIALIZED_VIEW_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object materializedViewName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The unique name of the MaterializedView from which to read.
   *
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/materializedViews/&lt;materialized_view&gt;`.
   * </pre>
   *
   * <code>
   * string materialized_view_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The materializedViewName.
   */
  @java.lang.Override
  public java.lang.String getMaterializedViewName() {
    java.lang.Object ref = materializedViewName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      materializedViewName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The unique name of the MaterializedView from which to read.
   *
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/materializedViews/&lt;materialized_view&gt;`.
   * </pre>
   *
   * <code>
   * string materialized_view_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for materializedViewName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMaterializedViewNameBytes() {
    java.lang.Object ref = materializedViewName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      materializedViewName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object appProfileId_ = "";

  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 5;</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 5;</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROWS_FIELD_NUMBER = 2;
  private com.google.bigtable.v2.RowSet rows_;

  /**
   *
   *
   * <pre>
   * The row keys and/or ranges to read sequentially. If not specified, reads
   * from all rows.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowSet rows = 2;</code>
   *
   * @return Whether the rows field is set.
   */
  @java.lang.Override
  public boolean hasRows() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The row keys and/or ranges to read sequentially. If not specified, reads
   * from all rows.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowSet rows = 2;</code>
   *
   * @return The rows.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowSet getRows() {
    return rows_ == null ? com.google.bigtable.v2.RowSet.getDefaultInstance() : rows_;
  }

  /**
   *
   *
   * <pre>
   * The row keys and/or ranges to read sequentially. If not specified, reads
   * from all rows.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowSet rows = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowSetOrBuilder getRowsOrBuilder() {
    return rows_ == null ? com.google.bigtable.v2.RowSet.getDefaultInstance() : rows_;
  }

  public static final int FILTER_FIELD_NUMBER = 3;
  private com.google.bigtable.v2.RowFilter filter_;

  /**
   *
   *
   * <pre>
   * The filter to apply to the contents of the specified row(s). If unset,
   * reads the entirety of each row.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The filter to apply to the contents of the specified row(s). If unset,
   * reads the entirety of each row.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter getFilter() {
    return filter_ == null ? com.google.bigtable.v2.RowFilter.getDefaultInstance() : filter_;
  }

  /**
   *
   *
   * <pre>
   * The filter to apply to the contents of the specified row(s). If unset,
   * reads the entirety of each row.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilterOrBuilder getFilterOrBuilder() {
    return filter_ == null ? com.google.bigtable.v2.RowFilter.getDefaultInstance() : filter_;
  }

  public static final int ROWS_LIMIT_FIELD_NUMBER = 4;
  private long rowsLimit_ = 0L;

  /**
   *
   *
   * <pre>
   * The read will stop after committing to N rows' worth of results. The
   * default (zero) is to return all results.
   * </pre>
   *
   * <code>int64 rows_limit = 4;</code>
   *
   * @return The rowsLimit.
   */
  @java.lang.Override
  public long getRowsLimit() {
    return rowsLimit_;
  }

  public static final int REQUEST_STATS_VIEW_FIELD_NUMBER = 6;
  private int requestStatsView_ = 0;

  /**
   *
   *
   * <pre>
   * The view into RequestStats, as described above.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadRowsRequest.RequestStatsView request_stats_view = 6;</code>
   *
   * @return The enum numeric value on the wire for requestStatsView.
   */
  @java.lang.Override
  public int getRequestStatsViewValue() {
    return requestStatsView_;
  }

  /**
   *
   *
   * <pre>
   * The view into RequestStats, as described above.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadRowsRequest.RequestStatsView request_stats_view = 6;</code>
   *
   * @return The requestStatsView.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadRowsRequest.RequestStatsView getRequestStatsView() {
    com.google.bigtable.v2.ReadRowsRequest.RequestStatsView result =
        com.google.bigtable.v2.ReadRowsRequest.RequestStatsView.forNumber(requestStatsView_);
    return result == null
        ? com.google.bigtable.v2.ReadRowsRequest.RequestStatsView.UNRECOGNIZED
        : result;
  }

  public static final int REVERSED_FIELD_NUMBER = 7;
  private boolean reversed_ = false;

  /**
   *
   *
   * <pre>
   * Experimental API - Please note that this API is currently experimental
   * and can change in the future.
   *
   * Return rows in lexiographical descending order of the row keys. The row
   * contents will not be affected by this flag.
   *
   * Example result set:
   *
   * [
   * {key: "k2", "f:col1": "v1", "f:col2": "v1"},
   * {key: "k1", "f:col1": "v2", "f:col2": "v2"}
   * ]
   * </pre>
   *
   * <code>bool reversed = 7;</code>
   *
   * @return The reversed.
   */
  @java.lang.Override
  public boolean getReversed() {
    return reversed_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(tableName_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, tableName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getRows());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getFilter());
    }
    if (rowsLimit_ != 0L) {
      output.writeInt64(4, rowsLimit_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(appProfileId_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 5, appProfileId_);
    }
    if (requestStatsView_
        != com.google.bigtable.v2.ReadRowsRequest.RequestStatsView.REQUEST_STATS_VIEW_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, requestStatsView_);
    }
    if (reversed_ != false) {
      output.writeBool(7, reversed_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(authorizedViewName_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 9, authorizedViewName_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(materializedViewName_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 11, materializedViewName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(tableName_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, tableName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRows());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFilter());
    }
    if (rowsLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, rowsLimit_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(appProfileId_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(5, appProfileId_);
    }
    if (requestStatsView_
        != com.google.bigtable.v2.ReadRowsRequest.RequestStatsView.REQUEST_STATS_VIEW_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, requestStatsView_);
    }
    if (reversed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, reversed_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(authorizedViewName_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(9, authorizedViewName_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(materializedViewName_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(11, materializedViewName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.ReadRowsRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.ReadRowsRequest other = (com.google.bigtable.v2.ReadRowsRequest) obj;

    if (!getTableName().equals(other.getTableName())) return false;
    if (!getAuthorizedViewName().equals(other.getAuthorizedViewName())) return false;
    if (!getMaterializedViewName().equals(other.getMaterializedViewName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (hasRows() != other.hasRows()) return false;
    if (hasRows()) {
      if (!getRows().equals(other.getRows())) return false;
    }
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (getRowsLimit() != other.getRowsLimit()) return false;
    if (requestStatsView_ != other.requestStatsView_) return false;
    if (getReversed() != other.getReversed()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (37 * hash) + AUTHORIZED_VIEW_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getAuthorizedViewName().hashCode();
    hash = (37 * hash) + MATERIALIZED_VIEW_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getMaterializedViewName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    if (hasRows()) {
      hash = (37 * hash) + ROWS_FIELD_NUMBER;
      hash = (53 * hash) + getRows().hashCode();
    }
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    hash = (37 * hash) + ROWS_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowsLimit());
    hash = (37 * hash) + REQUEST_STATS_VIEW_FIELD_NUMBER;
    hash = (53 * hash) + requestStatsView_;
    hash = (37 * hash) + REVERSED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReversed());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.ReadRowsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for Bigtable.ReadRows.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadRowsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadRowsRequest)
      com.google.bigtable.v2.ReadRowsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadRowsRequest.class,
              com.google.bigtable.v2.ReadRowsRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.ReadRowsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetRowsFieldBuilder();
        internalGetFilterFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tableName_ = "";
      authorizedViewName_ = "";
      materializedViewName_ = "";
      appProfileId_ = "";
      rows_ = null;
      if (rowsBuilder_ != null) {
        rowsBuilder_.dispose();
        rowsBuilder_ = null;
      }
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      rowsLimit_ = 0L;
      requestStatsView_ = 0;
      reversed_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.ReadRowsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsRequest build() {
      com.google.bigtable.v2.ReadRowsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsRequest buildPartial() {
      com.google.bigtable.v2.ReadRowsRequest result =
          new com.google.bigtable.v2.ReadRowsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.ReadRowsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tableName_ = tableName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.authorizedViewName_ = authorizedViewName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.materializedViewName_ = materializedViewName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.appProfileId_ = appProfileId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.rows_ = rowsBuilder_ == null ? rows_ : rowsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.rowsLimit_ = rowsLimit_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.requestStatsView_ = requestStatsView_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.reversed_ = reversed_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.ReadRowsRequest) {
        return mergeFrom((com.google.bigtable.v2.ReadRowsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.ReadRowsRequest other) {
      if (other == com.google.bigtable.v2.ReadRowsRequest.getDefaultInstance()) return this;
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAuthorizedViewName().isEmpty()) {
        authorizedViewName_ = other.authorizedViewName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getMaterializedViewName().isEmpty()) {
        materializedViewName_ = other.materializedViewName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasRows()) {
        mergeRows(other.getRows());
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.getRowsLimit() != 0L) {
        setRowsLimit(other.getRowsLimit());
      }
      if (other.requestStatsView_ != 0) {
        setRequestStatsViewValue(other.getRequestStatsViewValue());
      }
      if (other.getReversed() != false) {
        setReversed(other.getReversed());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tableName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(internalGetRowsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(internalGetFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 32:
              {
                rowsLimit_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 32
            case 42:
              {
                appProfileId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                requestStatsView_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 48
            case 56:
              {
                reversed_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 56
            case 74:
              {
                authorizedViewName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 74
            case 90:
              {
                materializedViewName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object tableName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the table from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the table from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the table from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the table from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {
      tableName_ = getDefaultInstance().getTableName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the table from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object authorizedViewName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the AuthorizedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;/authorizedViews/&lt;authorized_view&gt;`.
     * </pre>
     *
     * <code>
     * string authorized_view_name = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The authorizedViewName.
     */
    public java.lang.String getAuthorizedViewName() {
      java.lang.Object ref = authorizedViewName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authorizedViewName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the AuthorizedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;/authorizedViews/&lt;authorized_view&gt;`.
     * </pre>
     *
     * <code>
     * string authorized_view_name = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for authorizedViewName.
     */
    public com.google.protobuf.ByteString getAuthorizedViewNameBytes() {
      java.lang.Object ref = authorizedViewName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authorizedViewName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the AuthorizedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;/authorizedViews/&lt;authorized_view&gt;`.
     * </pre>
     *
     * <code>
     * string authorized_view_name = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The authorizedViewName to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedViewName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authorizedViewName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the AuthorizedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;/authorizedViews/&lt;authorized_view&gt;`.
     * </pre>
     *
     * <code>
     * string authorized_view_name = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizedViewName() {
      authorizedViewName_ = getDefaultInstance().getAuthorizedViewName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the AuthorizedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;/authorizedViews/&lt;authorized_view&gt;`.
     * </pre>
     *
     * <code>
     * string authorized_view_name = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for authorizedViewName to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedViewNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authorizedViewName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object materializedViewName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the MaterializedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/materializedViews/&lt;materialized_view&gt;`.
     * </pre>
     *
     * <code>
     * string materialized_view_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The materializedViewName.
     */
    public java.lang.String getMaterializedViewName() {
      java.lang.Object ref = materializedViewName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        materializedViewName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the MaterializedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/materializedViews/&lt;materialized_view&gt;`.
     * </pre>
     *
     * <code>
     * string materialized_view_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for materializedViewName.
     */
    public com.google.protobuf.ByteString getMaterializedViewNameBytes() {
      java.lang.Object ref = materializedViewName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        materializedViewName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the MaterializedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/materializedViews/&lt;materialized_view&gt;`.
     * </pre>
     *
     * <code>
     * string materialized_view_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The materializedViewName to set.
     * @return This builder for chaining.
     */
    public Builder setMaterializedViewName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      materializedViewName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the MaterializedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/materializedViews/&lt;materialized_view&gt;`.
     * </pre>
     *
     * <code>
     * string materialized_view_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaterializedViewName() {
      materializedViewName_ = getDefaultInstance().getMaterializedViewName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name of the MaterializedView from which to read.
     *
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/materializedViews/&lt;materialized_view&gt;`.
     * </pre>
     *
     * <code>
     * string materialized_view_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for materializedViewName to set.
     * @return This builder for chaining.
     */
    public Builder setMaterializedViewNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      materializedViewName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      appProfileId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {
      appProfileId_ = getDefaultInstance().getAppProfileId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      appProfileId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.bigtable.v2.RowSet rows_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.RowSet,
            com.google.bigtable.v2.RowSet.Builder,
            com.google.bigtable.v2.RowSetOrBuilder>
        rowsBuilder_;

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     *
     * @return Whether the rows field is set.
     */
    public boolean hasRows() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     *
     * @return The rows.
     */
    public com.google.bigtable.v2.RowSet getRows() {
      if (rowsBuilder_ == null) {
        return rows_ == null ? com.google.bigtable.v2.RowSet.getDefaultInstance() : rows_;
      } else {
        return rowsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder setRows(com.google.bigtable.v2.RowSet value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
      } else {
        rowsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder setRows(com.google.bigtable.v2.RowSet.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        rows_ = builderForValue.build();
      } else {
        rowsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder mergeRows(com.google.bigtable.v2.RowSet value) {
      if (rowsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && rows_ != null
            && rows_ != com.google.bigtable.v2.RowSet.getDefaultInstance()) {
          getRowsBuilder().mergeFrom(value);
        } else {
          rows_ = value;
        }
      } else {
        rowsBuilder_.mergeFrom(value);
      }
      if (rows_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder clearRows() {
      bitField0_ = (bitField0_ & ~0x00000010);
      rows_ = null;
      if (rowsBuilder_ != null) {
        rowsBuilder_.dispose();
        rowsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public com.google.bigtable.v2.RowSet.Builder getRowsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return internalGetRowsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public com.google.bigtable.v2.RowSetOrBuilder getRowsOrBuilder() {
      if (rowsBuilder_ != null) {
        return rowsBuilder_.getMessageOrBuilder();
      } else {
        return rows_ == null ? com.google.bigtable.v2.RowSet.getDefaultInstance() : rows_;
      }
    }

    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read sequentially. If not specified, reads
     * from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.RowSet,
            com.google.bigtable.v2.RowSet.Builder,
            com.google.bigtable.v2.RowSetOrBuilder>
        internalGetRowsFieldBuilder() {
      if (rowsBuilder_ == null) {
        rowsBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.v2.RowSet,
                com.google.bigtable.v2.RowSet.Builder,
                com.google.bigtable.v2.RowSetOrBuilder>(
                getRows(), getParentForChildren(), isClean());
        rows_ = null;
      }
      return rowsBuilder_;
    }

    private com.google.bigtable.v2.RowFilter filter_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.RowFilter,
            com.google.bigtable.v2.RowFilter.Builder,
            com.google.bigtable.v2.RowFilterOrBuilder>
        filterBuilder_;

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     *
     * @return The filter.
     */
    public com.google.bigtable.v2.RowFilter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null ? com.google.bigtable.v2.RowFilter.getDefaultInstance() : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder setFilter(com.google.bigtable.v2.RowFilter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder setFilter(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder mergeFilter(com.google.bigtable.v2.RowFilter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && filter_ != null
            && filter_ != com.google.bigtable.v2.RowFilter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000020);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public com.google.bigtable.v2.RowFilter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return internalGetFilterFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public com.google.bigtable.v2.RowFilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null ? com.google.bigtable.v2.RowFilter.getDefaultInstance() : filter_;
      }
    }

    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.RowFilter,
            com.google.bigtable.v2.RowFilter.Builder,
            com.google.bigtable.v2.RowFilterOrBuilder>
        internalGetFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.v2.RowFilter,
                com.google.bigtable.v2.RowFilter.Builder,
                com.google.bigtable.v2.RowFilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private long rowsLimit_;

    /**
     *
     *
     * <pre>
     * The read will stop after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * </pre>
     *
     * <code>int64 rows_limit = 4;</code>
     *
     * @return The rowsLimit.
     */
    @java.lang.Override
    public long getRowsLimit() {
      return rowsLimit_;
    }

    /**
     *
     *
     * <pre>
     * The read will stop after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * </pre>
     *
     * <code>int64 rows_limit = 4;</code>
     *
     * @param value The rowsLimit to set.
     * @return This builder for chaining.
     */
    public Builder setRowsLimit(long value) {

      rowsLimit_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The read will stop after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * </pre>
     *
     * <code>int64 rows_limit = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowsLimit() {
      bitField0_ = (bitField0_ & ~0x00000040);
      rowsLimit_ = 0L;
      onChanged();
      return this;
    }

    private int requestStatsView_ = 0;

    /**
     *
     *
     * <pre>
     * The view into RequestStats, as described above.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadRowsRequest.RequestStatsView request_stats_view = 6;</code>
     *
     * @return The enum numeric value on the wire for requestStatsView.
     */
    @java.lang.Override
    public int getRequestStatsViewValue() {
      return requestStatsView_;
    }

    /**
     *
     *
     * <pre>
     * The view into RequestStats, as described above.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadRowsRequest.RequestStatsView request_stats_view = 6;</code>
     *
     * @param value The enum numeric value on the wire for requestStatsView to set.
     * @return This builder for chaining.
     */
    public Builder setRequestStatsViewValue(int value) {
      requestStatsView_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The view into RequestStats, as described above.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadRowsRequest.RequestStatsView request_stats_view = 6;</code>
     *
     * @return The requestStatsView.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsRequest.RequestStatsView getRequestStatsView() {
      com.google.bigtable.v2.ReadRowsRequest.RequestStatsView result =
          com.google.bigtable.v2.ReadRowsRequest.RequestStatsView.forNumber(requestStatsView_);
      return result == null
          ? com.google.bigtable.v2.ReadRowsRequest.RequestStatsView.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The view into RequestStats, as described above.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadRowsRequest.RequestStatsView request_stats_view = 6;</code>
     *
     * @param value The requestStatsView to set.
     * @return This builder for chaining.
     */
    public Builder setRequestStatsView(
        com.google.bigtable.v2.ReadRowsRequest.RequestStatsView value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      requestStatsView_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The view into RequestStats, as described above.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadRowsRequest.RequestStatsView request_stats_view = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestStatsView() {
      bitField0_ = (bitField0_ & ~0x00000080);
      requestStatsView_ = 0;
      onChanged();
      return this;
    }

    private boolean reversed_;

    /**
     *
     *
     * <pre>
     * Experimental API - Please note that this API is currently experimental
     * and can change in the future.
     *
     * Return rows in lexiographical descending order of the row keys. The row
     * contents will not be affected by this flag.
     *
     * Example result set:
     *
     * [
     * {key: "k2", "f:col1": "v1", "f:col2": "v1"},
     * {key: "k1", "f:col1": "v2", "f:col2": "v2"}
     * ]
     * </pre>
     *
     * <code>bool reversed = 7;</code>
     *
     * @return The reversed.
     */
    @java.lang.Override
    public boolean getReversed() {
      return reversed_;
    }

    /**
     *
     *
     * <pre>
     * Experimental API - Please note that this API is currently experimental
     * and can change in the future.
     *
     * Return rows in lexiographical descending order of the row keys. The row
     * contents will not be affected by this flag.
     *
     * Example result set:
     *
     * [
     * {key: "k2", "f:col1": "v1", "f:col2": "v1"},
     * {key: "k1", "f:col1": "v2", "f:col2": "v2"}
     * ]
     * </pre>
     *
     * <code>bool reversed = 7;</code>
     *
     * @param value The reversed to set.
     * @return This builder for chaining.
     */
    public Builder setReversed(boolean value) {

      reversed_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Experimental API - Please note that this API is currently experimental
     * and can change in the future.
     *
     * Return rows in lexiographical descending order of the row keys. The row
     * contents will not be affected by this flag.
     *
     * Example result set:
     *
     * [
     * {key: "k2", "f:col1": "v1", "f:col2": "v1"},
     * {key: "k1", "f:col1": "v2", "f:col2": "v2"}
     * ]
     * </pre>
     *
     * <code>bool reversed = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReversed() {
      bitField0_ = (bitField0_ & ~0x00000100);
      reversed_ = false;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadRowsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadRowsRequest)
  private static final com.google.bigtable.v2.ReadRowsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadRowsRequest();
  }

  public static com.google.bigtable.v2.ReadRowsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadRowsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReadRowsRequest>() {
        @java.lang.Override
        public ReadRowsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadRowsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadRowsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.ReadRowsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
