/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/bigtable/admin/v2/instance.proto
// Protobuf Java Version: 4.33.2

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * A configuration object describing how Cloud Bigtable should treat traffic
 * from a particular end user application.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.AppProfile}
 */
@com.google.protobuf.Generated
public final class AppProfile extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AppProfile)
    AppProfileOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "AppProfile");
  }

  // Use AppProfile.newBuilder() to construct.
  private AppProfile(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private AppProfile() {
    name_ = "";
    etag_ = "";
    description_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.InstanceProto
        .internal_static_google_bigtable_admin_v2_AppProfile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.InstanceProto
        .internal_static_google_bigtable_admin_v2_AppProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.AppProfile.class,
            com.google.bigtable.admin.v2.AppProfile.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible priorities for an app profile. Note that higher priority writes
   * can sometimes queue behind lower priority writes to the same tablet, as
   * writes must be strictly sequenced in the durability log.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.AppProfile.Priority}
   */
  public enum Priority implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. Mapped to PRIORITY_HIGH (the legacy behavior) on creation.
     * </pre>
     *
     * <code>PRIORITY_UNSPECIFIED = 0;</code>
     */
    PRIORITY_UNSPECIFIED(0),
    /** <code>PRIORITY_LOW = 1;</code> */
    PRIORITY_LOW(1),
    /** <code>PRIORITY_MEDIUM = 2;</code> */
    PRIORITY_MEDIUM(2),
    /** <code>PRIORITY_HIGH = 3;</code> */
    PRIORITY_HIGH(3),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Priority");
    }

    /**
     *
     *
     * <pre>
     * Default value. Mapped to PRIORITY_HIGH (the legacy behavior) on creation.
     * </pre>
     *
     * <code>PRIORITY_UNSPECIFIED = 0;</code>
     */
    public static final int PRIORITY_UNSPECIFIED_VALUE = 0;

    /** <code>PRIORITY_LOW = 1;</code> */
    public static final int PRIORITY_LOW_VALUE = 1;

    /** <code>PRIORITY_MEDIUM = 2;</code> */
    public static final int PRIORITY_MEDIUM_VALUE = 2;

    /** <code>PRIORITY_HIGH = 3;</code> */
    public static final int PRIORITY_HIGH_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Priority valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Priority forNumber(int value) {
      switch (value) {
        case 0:
          return PRIORITY_UNSPECIFIED;
        case 1:
          return PRIORITY_LOW;
        case 2:
          return PRIORITY_MEDIUM;
        case 3:
          return PRIORITY_HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Priority> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Priority> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Priority>() {
          public Priority findValueByNumber(int number) {
            return Priority.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.AppProfile.getDescriptor().getEnumTypes().get(0);
    }

    private static final Priority[] VALUES = values();

    public static Priority valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Priority(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.AppProfile.Priority)
  }

  public interface MultiClusterRoutingUseAnyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @return A list containing the clusterIds.
     */
    java.util.List<java.lang.String> getClusterIdsList();

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @return The count of clusterIds.
     */
    int getClusterIdsCount();

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The clusterIds at the given index.
     */
    java.lang.String getClusterIds(int index);

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the clusterIds at the given index.
     */
    com.google.protobuf.ByteString getClusterIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * Row affinity sticky routing based on the row key of the request.
     * Requests that span multiple rows are routed non-deterministically.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
     * </code>
     *
     * @return Whether the rowAffinity field is set.
     */
    boolean hasRowAffinity();

    /**
     *
     *
     * <pre>
     * Row affinity sticky routing based on the row key of the request.
     * Requests that span multiple rows are routed non-deterministically.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
     * </code>
     *
     * @return The rowAffinity.
     */
    com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity getRowAffinity();

    /**
     *
     *
     * <pre>
     * Row affinity sticky routing based on the row key of the request.
     * Requests that span multiple rows are routed non-deterministically.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
     * </code>
     */
    com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinityOrBuilder
        getRowAffinityOrBuilder();

    com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.AffinityCase
        getAffinityCase();
  }

  /**
   *
   *
   * <pre>
   * Read/write requests are routed to the nearest cluster in the instance, and
   * will fail over to the nearest cluster that is available in the event of
   * transient errors or delays. Clusters in a region are considered
   * equidistant. Choosing this option sacrifices read-your-writes consistency
   * to improve availability.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny}
   */
  public static final class MultiClusterRoutingUseAny extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny)
      MultiClusterRoutingUseAnyOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "MultiClusterRoutingUseAny");
    }

    // Use MultiClusterRoutingUseAny.newBuilder() to construct.
    private MultiClusterRoutingUseAny(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private MultiClusterRoutingUseAny() {
      clusterIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.class,
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.Builder.class);
    }

    public interface RowAffinityOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * If enabled, Bigtable will route the request based on the row key of the
     * request, rather than randomly. Instead, each row key will be assigned
     * to a cluster, and will stick to that cluster. If clusters are added or
     * removed, then this may affect which row keys stick to which clusters.
     * To avoid this, users can use a cluster group to specify which clusters
     * are to be used. In this case, new clusters that are not a part of the
     * cluster group will not be routed to, and routing will be unaffected by
     * the new cluster. Moreover, clusters specified in the cluster group cannot
     * be deleted unless removed from the cluster group.
     * </pre>
     *
     * Protobuf type {@code
     * google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity}
     */
    public static final class RowAffinity extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
        RowAffinityOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "RowAffinity");
      }

      // Use RowAffinity.newBuilder() to construct.
      private RowAffinity(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private RowAffinity() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_RowAffinity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_RowAffinity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity.class,
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                    .Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity other =
            (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * If enabled, Bigtable will route the request based on the row key of the
       * request, rather than randomly. Instead, each row key will be assigned
       * to a cluster, and will stick to that cluster. If clusters are added or
       * removed, then this may affect which row keys stick to which clusters.
       * To avoid this, users can use a cluster group to specify which clusters
       * are to be used. In this case, new clusters that are not a part of the
       * cluster group will not be routed to, and routing will be unaffected by
       * the new cluster. Moreover, clusters specified in the cluster group cannot
       * be deleted unless removed from the cluster group.
       * </pre>
       *
       * Protobuf type {@code
       * google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinityOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.InstanceProto
              .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_RowAffinity_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.InstanceProto
              .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_RowAffinity_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                      .class,
                  com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                      .Builder.class);
        }

        // Construct using
        // com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.InstanceProto
              .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_RowAffinity_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
            getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
            build() {
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
            buildPartial() {
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity result =
              new com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity(
                  this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity) {
            return mergeFrom(
                (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity other) {
          if (other
              == com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
      private static final com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
              .RowAffinity
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity();
      }

      public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RowAffinity> PARSER =
          new com.google.protobuf.AbstractParser<RowAffinity>() {
            @java.lang.Override
            public RowAffinity parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RowAffinity> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RowAffinity> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int affinityCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object affinity_;

    public enum AffinityCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ROW_AFFINITY(3),
      AFFINITY_NOT_SET(0);
      private final int value;

      private AffinityCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AffinityCase valueOf(int value) {
        return forNumber(value);
      }

      public static AffinityCase forNumber(int value) {
        switch (value) {
          case 3:
            return ROW_AFFINITY;
          case 0:
            return AFFINITY_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AffinityCase getAffinityCase() {
      return AffinityCase.forNumber(affinityCase_);
    }

    public static final int CLUSTER_IDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList clusterIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @return A list containing the clusterIds.
     */
    public com.google.protobuf.ProtocolStringList getClusterIdsList() {
      return clusterIds_;
    }

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @return The count of clusterIds.
     */
    public int getClusterIdsCount() {
      return clusterIds_.size();
    }

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The clusterIds at the given index.
     */
    public java.lang.String getClusterIds(int index) {
      return clusterIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The set of clusters to route to. The order is ignored; clusters will be
     * tried in order of distance. If left empty, all clusters are eligible.
     * </pre>
     *
     * <code>repeated string cluster_ids = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the clusterIds at the given index.
     */
    public com.google.protobuf.ByteString getClusterIdsBytes(int index) {
      return clusterIds_.getByteString(index);
    }

    public static final int ROW_AFFINITY_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Row affinity sticky routing based on the row key of the request.
     * Requests that span multiple rows are routed non-deterministically.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
     * </code>
     *
     * @return Whether the rowAffinity field is set.
     */
    @java.lang.Override
    public boolean hasRowAffinity() {
      return affinityCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Row affinity sticky routing based on the row key of the request.
     * Requests that span multiple rows are routed non-deterministically.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
     * </code>
     *
     * @return The rowAffinity.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
        getRowAffinity() {
      if (affinityCase_ == 3) {
        return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
            affinity_;
      }
      return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Row affinity sticky routing based on the row key of the request.
     * Requests that span multiple rows are routed non-deterministically.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinityOrBuilder
        getRowAffinityOrBuilder() {
      if (affinityCase_ == 3) {
        return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
            affinity_;
      }
      return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < clusterIds_.size(); i++) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, clusterIds_.getRaw(i));
      }
      if (affinityCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
                affinity_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < clusterIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(clusterIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getClusterIdsList().size();
      }
      if (affinityCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
                    affinity_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny other =
          (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) obj;

      if (!getClusterIdsList().equals(other.getClusterIdsList())) return false;
      if (!getAffinityCase().equals(other.getAffinityCase())) return false;
      switch (affinityCase_) {
        case 3:
          if (!getRowAffinity().equals(other.getRowAffinity())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getClusterIdsCount() > 0) {
        hash = (37 * hash) + CLUSTER_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getClusterIdsList().hashCode();
      }
      switch (affinityCase_) {
        case 3:
          hash = (37 * hash) + ROW_AFFINITY_FIELD_NUMBER;
          hash = (53 * hash) + getRowAffinity().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Read/write requests are routed to the nearest cluster in the instance, and
     * will fail over to the nearest cluster that is available in the event of
     * transient errors or delays. Clusters in a region are considered
     * equidistant. Choosing this option sacrifices read-your-writes consistency
     * to improve availability.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny)
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAnyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.class,
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.Builder.class);
      }

      // Construct using
      // com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        clusterIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        if (rowAffinityBuilder_ != null) {
          rowAffinityBuilder_.clear();
        }
        affinityCase_ = 0;
        affinity_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_MultiClusterRoutingUseAny_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
          getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny build() {
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny buildPartial() {
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny result =
            new com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          clusterIds_.makeImmutable();
          result.clusterIds_ = clusterIds_;
        }
      }

      private void buildPartialOneofs(
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny result) {
        result.affinityCase_ = affinityCase_;
        result.affinity_ = this.affinity_;
        if (affinityCase_ == 3 && rowAffinityBuilder_ != null) {
          result.affinity_ = rowAffinityBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) {
          return mergeFrom(
              (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny other) {
        if (other
            == com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
                .getDefaultInstance()) return this;
        if (!other.clusterIds_.isEmpty()) {
          if (clusterIds_.isEmpty()) {
            clusterIds_ = other.clusterIds_;
            bitField0_ |= 0x00000001;
          } else {
            ensureClusterIdsIsMutable();
            clusterIds_.addAll(other.clusterIds_);
          }
          onChanged();
        }
        switch (other.getAffinityCase()) {
          case ROW_AFFINITY:
            {
              mergeRowAffinity(other.getRowAffinity());
              break;
            }
          case AFFINITY_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureClusterIdsIsMutable();
                  clusterIds_.add(s);
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      internalGetRowAffinityFieldBuilder().getBuilder(), extensionRegistry);
                  affinityCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int affinityCase_ = 0;
      private java.lang.Object affinity_;

      public AffinityCase getAffinityCase() {
        return AffinityCase.forNumber(affinityCase_);
      }

      public Builder clearAffinity() {
        affinityCase_ = 0;
        affinity_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList clusterIds_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureClusterIdsIsMutable() {
        if (!clusterIds_.isModifiable()) {
          clusterIds_ = new com.google.protobuf.LazyStringArrayList(clusterIds_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @return A list containing the clusterIds.
       */
      public com.google.protobuf.ProtocolStringList getClusterIdsList() {
        clusterIds_.makeImmutable();
        return clusterIds_;
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @return The count of clusterIds.
       */
      public int getClusterIdsCount() {
        return clusterIds_.size();
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The clusterIds at the given index.
       */
      public java.lang.String getClusterIds(int index) {
        return clusterIds_.get(index);
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the clusterIds at the given index.
       */
      public com.google.protobuf.ByteString getClusterIdsBytes(int index) {
        return clusterIds_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The clusterIds to set.
       * @return This builder for chaining.
       */
      public Builder setClusterIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterIdsIsMutable();
        clusterIds_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @param value The clusterIds to add.
       * @return This builder for chaining.
       */
      public Builder addClusterIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterIdsIsMutable();
        clusterIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @param values The clusterIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllClusterIds(java.lang.Iterable<java.lang.String> values) {
        ensureClusterIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, clusterIds_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterIds() {
        clusterIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The set of clusters to route to. The order is ignored; clusters will be
       * tried in order of distance. If left empty, all clusters are eligible.
       * </pre>
       *
       * <code>repeated string cluster_ids = 1;</code>
       *
       * @param value The bytes of the clusterIds to add.
       * @return This builder for chaining.
       */
      public Builder addClusterIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureClusterIdsIsMutable();
        clusterIds_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity,
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity.Builder,
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
                  .RowAffinityOrBuilder>
          rowAffinityBuilder_;

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       *
       * @return Whether the rowAffinity field is set.
       */
      @java.lang.Override
      public boolean hasRowAffinity() {
        return affinityCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       *
       * @return The rowAffinity.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
          getRowAffinity() {
        if (rowAffinityBuilder_ == null) {
          if (affinityCase_ == 3) {
            return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
                affinity_;
          }
          return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
              .getDefaultInstance();
        } else {
          if (affinityCase_ == 3) {
            return rowAffinityBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       */
      public Builder setRowAffinity(
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity value) {
        if (rowAffinityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          affinity_ = value;
          onChanged();
        } else {
          rowAffinityBuilder_.setMessage(value);
        }
        affinityCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       */
      public Builder setRowAffinity(
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity.Builder
              builderForValue) {
        if (rowAffinityBuilder_ == null) {
          affinity_ = builderForValue.build();
          onChanged();
        } else {
          rowAffinityBuilder_.setMessage(builderForValue.build());
        }
        affinityCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       */
      public Builder mergeRowAffinity(
          com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity value) {
        if (rowAffinityBuilder_ == null) {
          if (affinityCase_ == 3
              && affinity_
                  != com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                      .getDefaultInstance()) {
            affinity_ =
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                    .newBuilder(
                        (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
                                .RowAffinity)
                            affinity_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            affinity_ = value;
          }
          onChanged();
        } else {
          if (affinityCase_ == 3) {
            rowAffinityBuilder_.mergeFrom(value);
          } else {
            rowAffinityBuilder_.setMessage(value);
          }
        }
        affinityCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       */
      public Builder clearRowAffinity() {
        if (rowAffinityBuilder_ == null) {
          if (affinityCase_ == 3) {
            affinityCase_ = 0;
            affinity_ = null;
            onChanged();
          }
        } else {
          if (affinityCase_ == 3) {
            affinityCase_ = 0;
            affinity_ = null;
          }
          rowAffinityBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       */
      public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity.Builder
          getRowAffinityBuilder() {
        return internalGetRowAffinityFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinityOrBuilder
          getRowAffinityOrBuilder() {
        if ((affinityCase_ == 3) && (rowAffinityBuilder_ != null)) {
          return rowAffinityBuilder_.getMessageOrBuilder();
        } else {
          if (affinityCase_ == 3) {
            return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
                affinity_;
          }
          return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Row affinity sticky routing based on the row key of the request.
       * Requests that span multiple rows are routed non-deterministically.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity row_affinity = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity,
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity.Builder,
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
                  .RowAffinityOrBuilder>
          internalGetRowAffinityFieldBuilder() {
        if (rowAffinityBuilder_ == null) {
          if (!(affinityCase_ == 3)) {
            affinity_ =
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                    .getDefaultInstance();
          }
          rowAffinityBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity,
                  com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
                      .Builder,
                  com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
                      .RowAffinityOrBuilder>(
                  (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity)
                      affinity_,
                  getParentForChildren(),
                  isClean());
          affinity_ = null;
        }
        affinityCase_ = 3;
        onChanged();
        return rowAffinityBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny)
    private static final com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny();
    }

    public static com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MultiClusterRoutingUseAny> PARSER =
        new com.google.protobuf.AbstractParser<MultiClusterRoutingUseAny>() {
          @java.lang.Override
          public MultiClusterRoutingUseAny parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MultiClusterRoutingUseAny> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MultiClusterRoutingUseAny> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SingleClusterRoutingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.AppProfile.SingleClusterRouting)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The cluster to which read/write requests should be routed.
     * </pre>
     *
     * <code>string cluster_id = 1;</code>
     *
     * @return The clusterId.
     */
    java.lang.String getClusterId();

    /**
     *
     *
     * <pre>
     * The cluster to which read/write requests should be routed.
     * </pre>
     *
     * <code>string cluster_id = 1;</code>
     *
     * @return The bytes for clusterId.
     */
    com.google.protobuf.ByteString getClusterIdBytes();

    /**
     *
     *
     * <pre>
     * Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
     * allowed by this app profile. It is unsafe to send these requests to
     * the same table/row/column in multiple clusters.
     * </pre>
     *
     * <code>bool allow_transactional_writes = 2;</code>
     *
     * @return The allowTransactionalWrites.
     */
    boolean getAllowTransactionalWrites();
  }

  /**
   *
   *
   * <pre>
   * Unconditionally routes all read/write requests to a specific cluster.
   * This option preserves read-your-writes consistency but does not improve
   * availability.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AppProfile.SingleClusterRouting}
   */
  public static final class SingleClusterRouting extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AppProfile.SingleClusterRouting)
      SingleClusterRoutingOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "SingleClusterRouting");
    }

    // Use SingleClusterRouting.newBuilder() to construct.
    private SingleClusterRouting(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private SingleClusterRouting() {
      clusterId_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_SingleClusterRouting_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_SingleClusterRouting_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.class,
              com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.Builder.class);
    }

    public static final int CLUSTER_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object clusterId_ = "";

    /**
     *
     *
     * <pre>
     * The cluster to which read/write requests should be routed.
     * </pre>
     *
     * <code>string cluster_id = 1;</code>
     *
     * @return The clusterId.
     */
    @java.lang.Override
    public java.lang.String getClusterId() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The cluster to which read/write requests should be routed.
     * </pre>
     *
     * <code>string cluster_id = 1;</code>
     *
     * @return The bytes for clusterId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClusterIdBytes() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_TRANSACTIONAL_WRITES_FIELD_NUMBER = 2;
    private boolean allowTransactionalWrites_ = false;

    /**
     *
     *
     * <pre>
     * Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
     * allowed by this app profile. It is unsafe to send these requests to
     * the same table/row/column in multiple clusters.
     * </pre>
     *
     * <code>bool allow_transactional_writes = 2;</code>
     *
     * @return The allowTransactionalWrites.
     */
    @java.lang.Override
    public boolean getAllowTransactionalWrites() {
      return allowTransactionalWrites_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(clusterId_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, clusterId_);
      }
      if (allowTransactionalWrites_ != false) {
        output.writeBool(2, allowTransactionalWrites_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(clusterId_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, clusterId_);
      }
      if (allowTransactionalWrites_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowTransactionalWrites_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting other =
          (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) obj;

      if (!getClusterId().equals(other.getClusterId())) return false;
      if (getAllowTransactionalWrites() != other.getAllowTransactionalWrites()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CLUSTER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getClusterId().hashCode();
      hash = (37 * hash) + ALLOW_TRANSACTIONAL_WRITES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowTransactionalWrites());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Unconditionally routes all read/write requests to a specific cluster.
     * This option preserves read-your-writes consistency but does not improve
     * availability.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.AppProfile.SingleClusterRouting}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AppProfile.SingleClusterRouting)
        com.google.bigtable.admin.v2.AppProfile.SingleClusterRoutingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_SingleClusterRouting_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_SingleClusterRouting_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.class,
                com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        clusterId_ = "";
        allowTransactionalWrites_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_SingleClusterRouting_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting
          getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting build() {
        com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting buildPartial() {
        com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting result =
            new com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.clusterId_ = clusterId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.allowTransactionalWrites_ = allowTransactionalWrites_;
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) {
          return mergeFrom((com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting other) {
        if (other
            == com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance())
          return this;
        if (!other.getClusterId().isEmpty()) {
          clusterId_ = other.clusterId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getAllowTransactionalWrites() != false) {
          setAllowTransactionalWrites(other.getAllowTransactionalWrites());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  clusterId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  allowTransactionalWrites_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object clusterId_ = "";

      /**
       *
       *
       * <pre>
       * The cluster to which read/write requests should be routed.
       * </pre>
       *
       * <code>string cluster_id = 1;</code>
       *
       * @return The clusterId.
       */
      public java.lang.String getClusterId() {
        java.lang.Object ref = clusterId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clusterId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The cluster to which read/write requests should be routed.
       * </pre>
       *
       * <code>string cluster_id = 1;</code>
       *
       * @return The bytes for clusterId.
       */
      public com.google.protobuf.ByteString getClusterIdBytes() {
        java.lang.Object ref = clusterId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clusterId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The cluster to which read/write requests should be routed.
       * </pre>
       *
       * <code>string cluster_id = 1;</code>
       *
       * @param value The clusterId to set.
       * @return This builder for chaining.
       */
      public Builder setClusterId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        clusterId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The cluster to which read/write requests should be routed.
       * </pre>
       *
       * <code>string cluster_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterId() {
        clusterId_ = getDefaultInstance().getClusterId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The cluster to which read/write requests should be routed.
       * </pre>
       *
       * <code>string cluster_id = 1;</code>
       *
       * @param value The bytes for clusterId to set.
       * @return This builder for chaining.
       */
      public Builder setClusterIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        clusterId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean allowTransactionalWrites_;

      /**
       *
       *
       * <pre>
       * Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
       * allowed by this app profile. It is unsafe to send these requests to
       * the same table/row/column in multiple clusters.
       * </pre>
       *
       * <code>bool allow_transactional_writes = 2;</code>
       *
       * @return The allowTransactionalWrites.
       */
      @java.lang.Override
      public boolean getAllowTransactionalWrites() {
        return allowTransactionalWrites_;
      }

      /**
       *
       *
       * <pre>
       * Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
       * allowed by this app profile. It is unsafe to send these requests to
       * the same table/row/column in multiple clusters.
       * </pre>
       *
       * <code>bool allow_transactional_writes = 2;</code>
       *
       * @param value The allowTransactionalWrites to set.
       * @return This builder for chaining.
       */
      public Builder setAllowTransactionalWrites(boolean value) {

        allowTransactionalWrites_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
       * allowed by this app profile. It is unsafe to send these requests to
       * the same table/row/column in multiple clusters.
       * </pre>
       *
       * <code>bool allow_transactional_writes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowTransactionalWrites() {
        bitField0_ = (bitField0_ & ~0x00000002);
        allowTransactionalWrites_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AppProfile.SingleClusterRouting)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AppProfile.SingleClusterRouting)
    private static final com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting();
    }

    public static com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SingleClusterRouting> PARSER =
        new com.google.protobuf.AbstractParser<SingleClusterRouting>() {
          @java.lang.Override
          public SingleClusterRouting parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SingleClusterRouting> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SingleClusterRouting> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StandardIsolationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.AppProfile.StandardIsolation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
     *
     * @return The enum numeric value on the wire for priority.
     */
    int getPriorityValue();

    /**
     *
     *
     * <pre>
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
     *
     * @return The priority.
     */
    com.google.bigtable.admin.v2.AppProfile.Priority getPriority();
  }

  /**
   *
   *
   * <pre>
   * Standard options for isolating this app profile's traffic from other use
   * cases.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AppProfile.StandardIsolation}
   */
  public static final class StandardIsolation extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AppProfile.StandardIsolation)
      StandardIsolationOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "StandardIsolation");
    }

    // Use StandardIsolation.newBuilder() to construct.
    private StandardIsolation(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private StandardIsolation() {
      priority_ = 0;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_StandardIsolation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_StandardIsolation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AppProfile.StandardIsolation.class,
              com.google.bigtable.admin.v2.AppProfile.StandardIsolation.Builder.class);
    }

    public static final int PRIORITY_FIELD_NUMBER = 1;
    private int priority_ = 0;

    /**
     *
     *
     * <pre>
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
     *
     * @return The enum numeric value on the wire for priority.
     */
    @java.lang.Override
    public int getPriorityValue() {
      return priority_;
    }

    /**
     *
     *
     * <pre>
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.Priority getPriority() {
      com.google.bigtable.admin.v2.AppProfile.Priority result =
          com.google.bigtable.admin.v2.AppProfile.Priority.forNumber(priority_);
      return result == null
          ? com.google.bigtable.admin.v2.AppProfile.Priority.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (priority_
          != com.google.bigtable.admin.v2.AppProfile.Priority.PRIORITY_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, priority_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (priority_
          != com.google.bigtable.admin.v2.AppProfile.Priority.PRIORITY_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, priority_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.AppProfile.StandardIsolation)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.AppProfile.StandardIsolation other =
          (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) obj;

      if (priority_ != other.priority_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + priority_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.AppProfile.StandardIsolation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Standard options for isolating this app profile's traffic from other use
     * cases.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.AppProfile.StandardIsolation}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AppProfile.StandardIsolation)
        com.google.bigtable.admin.v2.AppProfile.StandardIsolationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_StandardIsolation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_StandardIsolation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.AppProfile.StandardIsolation.class,
                com.google.bigtable.admin.v2.AppProfile.StandardIsolation.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.AppProfile.StandardIsolation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        priority_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_StandardIsolation_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.StandardIsolation getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.StandardIsolation build() {
        com.google.bigtable.admin.v2.AppProfile.StandardIsolation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.StandardIsolation buildPartial() {
        com.google.bigtable.admin.v2.AppProfile.StandardIsolation result =
            new com.google.bigtable.admin.v2.AppProfile.StandardIsolation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.AppProfile.StandardIsolation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.priority_ = priority_;
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.AppProfile.StandardIsolation) {
          return mergeFrom((com.google.bigtable.admin.v2.AppProfile.StandardIsolation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.AppProfile.StandardIsolation other) {
        if (other == com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance())
          return this;
        if (other.priority_ != 0) {
          setPriorityValue(other.getPriorityValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  priority_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int priority_ = 0;

      /**
       *
       *
       * <pre>
       * The priority of requests sent using this app profile.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
       *
       * @return The enum numeric value on the wire for priority.
       */
      @java.lang.Override
      public int getPriorityValue() {
        return priority_;
      }

      /**
       *
       *
       * <pre>
       * The priority of requests sent using this app profile.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
       *
       * @param value The enum numeric value on the wire for priority to set.
       * @return This builder for chaining.
       */
      public Builder setPriorityValue(int value) {
        priority_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The priority of requests sent using this app profile.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
       *
       * @return The priority.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.Priority getPriority() {
        com.google.bigtable.admin.v2.AppProfile.Priority result =
            com.google.bigtable.admin.v2.AppProfile.Priority.forNumber(priority_);
        return result == null
            ? com.google.bigtable.admin.v2.AppProfile.Priority.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The priority of requests sent using this app profile.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
       *
       * @param value The priority to set.
       * @return This builder for chaining.
       */
      public Builder setPriority(com.google.bigtable.admin.v2.AppProfile.Priority value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        priority_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The priority of requests sent using this app profile.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPriority() {
        bitField0_ = (bitField0_ & ~0x00000001);
        priority_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AppProfile.StandardIsolation)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AppProfile.StandardIsolation)
    private static final com.google.bigtable.admin.v2.AppProfile.StandardIsolation DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AppProfile.StandardIsolation();
    }

    public static com.google.bigtable.admin.v2.AppProfile.StandardIsolation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StandardIsolation> PARSER =
        new com.google.protobuf.AbstractParser<StandardIsolation>() {
          @java.lang.Override
          public StandardIsolation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StandardIsolation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StandardIsolation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.StandardIsolation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataBoostIsolationReadOnlyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Compute Billing Owner for this Data Boost App Profile.
     * </pre>
     *
     * <code>
     * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
     * </code>
     *
     * @return Whether the computeBillingOwner field is set.
     */
    boolean hasComputeBillingOwner();

    /**
     *
     *
     * <pre>
     * The Compute Billing Owner for this Data Boost App Profile.
     * </pre>
     *
     * <code>
     * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for computeBillingOwner.
     */
    int getComputeBillingOwnerValue();

    /**
     *
     *
     * <pre>
     * The Compute Billing Owner for this Data Boost App Profile.
     * </pre>
     *
     * <code>
     * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
     * </code>
     *
     * @return The computeBillingOwner.
     */
    com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
        getComputeBillingOwner();
  }

  /**
   *
   *
   * <pre>
   * Data Boost is a serverless compute capability that lets you run
   * high-throughput read jobs and queries on your Bigtable data, without
   * impacting the performance of the clusters that handle your application
   * traffic. Data Boost supports read-only use cases with single-cluster
   * routing.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly}
   */
  public static final class DataBoostIsolationReadOnly extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly)
      DataBoostIsolationReadOnlyOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "DataBoostIsolationReadOnly");
    }

    // Use DataBoostIsolationReadOnly.newBuilder() to construct.
    private DataBoostIsolationReadOnly(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private DataBoostIsolationReadOnly() {
      computeBillingOwner_ = 0;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_DataBoostIsolationReadOnly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_DataBoostIsolationReadOnly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.class,
              com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Compute Billing Owner specifies how usage should be accounted when using
     * Data Boost. Compute Billing Owner also configures which Cloud Project is
     * charged for relevant quota.
     * </pre>
     *
     * Protobuf enum {@code
     * google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner}
     */
    public enum ComputeBillingOwner implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified value.
       * </pre>
       *
       * <code>COMPUTE_BILLING_OWNER_UNSPECIFIED = 0;</code>
       */
      COMPUTE_BILLING_OWNER_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The host Cloud Project containing the targeted Bigtable Instance /
       * Table pays for compute.
       * </pre>
       *
       * <code>HOST_PAYS = 1;</code>
       */
      HOST_PAYS(1),
      UNRECOGNIZED(-1),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "ComputeBillingOwner");
      }

      /**
       *
       *
       * <pre>
       * Unspecified value.
       * </pre>
       *
       * <code>COMPUTE_BILLING_OWNER_UNSPECIFIED = 0;</code>
       */
      public static final int COMPUTE_BILLING_OWNER_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The host Cloud Project containing the targeted Bigtable Instance /
       * Table pays for compute.
       * </pre>
       *
       * <code>HOST_PAYS = 1;</code>
       */
      public static final int HOST_PAYS_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ComputeBillingOwner valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ComputeBillingOwner forNumber(int value) {
        switch (value) {
          case 0:
            return COMPUTE_BILLING_OWNER_UNSPECIFIED;
          case 1:
            return HOST_PAYS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ComputeBillingOwner>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ComputeBillingOwner>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ComputeBillingOwner>() {
                public ComputeBillingOwner findValueByNumber(int number) {
                  return ComputeBillingOwner.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ComputeBillingOwner[] VALUES = values();

      public static ComputeBillingOwner valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ComputeBillingOwner(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner)
    }

    private int bitField0_;
    public static final int COMPUTE_BILLING_OWNER_FIELD_NUMBER = 1;
    private int computeBillingOwner_ = 0;

    /**
     *
     *
     * <pre>
     * The Compute Billing Owner for this Data Boost App Profile.
     * </pre>
     *
     * <code>
     * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
     * </code>
     *
     * @return Whether the computeBillingOwner field is set.
     */
    @java.lang.Override
    public boolean hasComputeBillingOwner() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The Compute Billing Owner for this Data Boost App Profile.
     * </pre>
     *
     * <code>
     * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for computeBillingOwner.
     */
    @java.lang.Override
    public int getComputeBillingOwnerValue() {
      return computeBillingOwner_;
    }

    /**
     *
     *
     * <pre>
     * The Compute Billing Owner for this Data Boost App Profile.
     * </pre>
     *
     * <code>
     * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
     * </code>
     *
     * @return The computeBillingOwner.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
        getComputeBillingOwner() {
      com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
          result =
              com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
                  .forNumber(computeBillingOwner_);
      return result == null
          ? com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, computeBillingOwner_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, computeBillingOwner_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly other =
          (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) obj;

      if (hasComputeBillingOwner() != other.hasComputeBillingOwner()) return false;
      if (hasComputeBillingOwner()) {
        if (computeBillingOwner_ != other.computeBillingOwner_) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasComputeBillingOwner()) {
        hash = (37 * hash) + COMPUTE_BILLING_OWNER_FIELD_NUMBER;
        hash = (53 * hash) + computeBillingOwner_;
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Data Boost is a serverless compute capability that lets you run
     * high-throughput read jobs and queries on your Bigtable data, without
     * impacting the performance of the clusters that handle your application
     * traffic. Data Boost supports read-only use cases with single-cluster
     * routing.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly)
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnlyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_DataBoostIsolationReadOnly_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_DataBoostIsolationReadOnly_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.class,
                com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.Builder.class);
      }

      // Construct using
      // com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        computeBillingOwner_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.InstanceProto
            .internal_static_google_bigtable_admin_v2_AppProfile_DataBoostIsolationReadOnly_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
          getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly build() {
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly buildPartial() {
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly result =
            new com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.computeBillingOwner_ = computeBillingOwner_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) {
          return mergeFrom(
              (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly other) {
        if (other
            == com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
                .getDefaultInstance()) return this;
        if (other.hasComputeBillingOwner()) {
          setComputeBillingOwnerValue(other.getComputeBillingOwnerValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  computeBillingOwner_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int computeBillingOwner_ = 0;

      /**
       *
       *
       * <pre>
       * The Compute Billing Owner for this Data Boost App Profile.
       * </pre>
       *
       * <code>
       * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
       * </code>
       *
       * @return Whether the computeBillingOwner field is set.
       */
      @java.lang.Override
      public boolean hasComputeBillingOwner() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The Compute Billing Owner for this Data Boost App Profile.
       * </pre>
       *
       * <code>
       * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for computeBillingOwner.
       */
      @java.lang.Override
      public int getComputeBillingOwnerValue() {
        return computeBillingOwner_;
      }

      /**
       *
       *
       * <pre>
       * The Compute Billing Owner for this Data Boost App Profile.
       * </pre>
       *
       * <code>
       * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for computeBillingOwner to set.
       * @return This builder for chaining.
       */
      public Builder setComputeBillingOwnerValue(int value) {
        computeBillingOwner_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Compute Billing Owner for this Data Boost App Profile.
       * </pre>
       *
       * <code>
       * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
       * </code>
       *
       * @return The computeBillingOwner.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
          getComputeBillingOwner() {
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
            result =
                com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
                    .ComputeBillingOwner.forNumber(computeBillingOwner_);
        return result == null
            ? com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The Compute Billing Owner for this Data Boost App Profile.
       * </pre>
       *
       * <code>
       * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
       * </code>
       *
       * @param value The computeBillingOwner to set.
       * @return This builder for chaining.
       */
      public Builder setComputeBillingOwner(
          com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        computeBillingOwner_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Compute Billing Owner for this Data Boost App Profile.
       * </pre>
       *
       * <code>
       * optional .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner compute_billing_owner = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearComputeBillingOwner() {
        bitField0_ = (bitField0_ & ~0x00000001);
        computeBillingOwner_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly)
    private static final com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly();
    }

    public static com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataBoostIsolationReadOnly> PARSER =
        new com.google.protobuf.AbstractParser<DataBoostIsolationReadOnly>() {
          @java.lang.Override
          public DataBoostIsolationReadOnly parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataBoostIsolationReadOnly> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataBoostIsolationReadOnly> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int routingPolicyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object routingPolicy_;

  public enum RoutingPolicyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MULTI_CLUSTER_ROUTING_USE_ANY(5),
    SINGLE_CLUSTER_ROUTING(6),
    ROUTINGPOLICY_NOT_SET(0);
    private final int value;

    private RoutingPolicyCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RoutingPolicyCase valueOf(int value) {
      return forNumber(value);
    }

    public static RoutingPolicyCase forNumber(int value) {
      switch (value) {
        case 5:
          return MULTI_CLUSTER_ROUTING_USE_ANY;
        case 6:
          return SINGLE_CLUSTER_ROUTING;
        case 0:
          return ROUTINGPOLICY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RoutingPolicyCase getRoutingPolicyCase() {
    return RoutingPolicyCase.forNumber(routingPolicyCase_);
  }

  private int isolationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object isolation_;

  public enum IsolationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    @java.lang.Deprecated
    PRIORITY(7),
    STANDARD_ISOLATION(11),
    DATA_BOOST_ISOLATION_READ_ONLY(10),
    ISOLATION_NOT_SET(0);
    private final int value;

    private IsolationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IsolationCase valueOf(int value) {
      return forNumber(value);
    }

    public static IsolationCase forNumber(int value) {
      switch (value) {
        case 7:
          return PRIORITY;
        case 11:
          return STANDARD_ISOLATION;
        case 10:
          return DATA_BOOST_ISOLATION_READ_ONLY;
        case 0:
          return ISOLATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IsolationCase getIsolationCase() {
    return IsolationCase.forNumber(isolationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The unique name of the app profile. Values are of the form
   * `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The unique name of the app profile. Values are of the form
   * `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Strongly validated etag for optimistic concurrency control. Preserve the
   * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
   * fail the request if there has been a modification in the mean time. The
   * `update_mask` of the request need not include `etag` for this protection
   * to apply.
   * See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
   * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
   * details.
   * </pre>
   *
   * <code>string etag = 2;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Strongly validated etag for optimistic concurrency control. Preserve the
   * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
   * fail the request if there has been a modification in the mean time. The
   * `update_mask` of the request need not include `etag` for this protection
   * to apply.
   * See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
   * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
   * details.
   * </pre>
   *
   * <code>string etag = 2;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Long form description of the use case for this AppProfile.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Long form description of the use case for this AppProfile.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MULTI_CLUSTER_ROUTING_USE_ANY_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Use a multi-cluster routing policy.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
   * </code>
   *
   * @return Whether the multiClusterRoutingUseAny field is set.
   */
  @java.lang.Override
  public boolean hasMultiClusterRoutingUseAny() {
    return routingPolicyCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Use a multi-cluster routing policy.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
   * </code>
   *
   * @return The multiClusterRoutingUseAny.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
      getMultiClusterRoutingUseAny() {
    if (routingPolicyCase_ == 5) {
      return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) routingPolicy_;
    }
    return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Use a multi-cluster routing policy.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAnyOrBuilder
      getMultiClusterRoutingUseAnyOrBuilder() {
    if (routingPolicyCase_ == 5) {
      return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) routingPolicy_;
    }
    return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.getDefaultInstance();
  }

  public static final int SINGLE_CLUSTER_ROUTING_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Use a single-cluster routing policy.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
   * </code>
   *
   * @return Whether the singleClusterRouting field is set.
   */
  @java.lang.Override
  public boolean hasSingleClusterRouting() {
    return routingPolicyCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Use a single-cluster routing policy.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
   * </code>
   *
   * @return The singleClusterRouting.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting getSingleClusterRouting() {
    if (routingPolicyCase_ == 6) {
      return (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_;
    }
    return com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Use a single-cluster routing policy.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.SingleClusterRoutingOrBuilder
      getSingleClusterRoutingOrBuilder() {
    if (routingPolicyCase_ == 6) {
      return (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_;
    }
    return com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance();
  }

  public static final int PRIORITY_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * This field has been deprecated in favor of `standard_isolation.priority`.
   * If you set this field, `standard_isolation.priority` will be set instead.
   *
   * The priority of requests sent using this app profile.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
   *
   * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
   *     google/bigtable/admin/v2/instance.proto;l=421
   * @return Whether the priority field is set.
   */
  @java.lang.Deprecated
  public boolean hasPriority() {
    return isolationCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * This field has been deprecated in favor of `standard_isolation.priority`.
   * If you set this field, `standard_isolation.priority` will be set instead.
   *
   * The priority of requests sent using this app profile.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
   *
   * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
   *     google/bigtable/admin/v2/instance.proto;l=421
   * @return The enum numeric value on the wire for priority.
   */
  @java.lang.Deprecated
  public int getPriorityValue() {
    if (isolationCase_ == 7) {
      return (java.lang.Integer) isolation_;
    }
    return 0;
  }

  /**
   *
   *
   * <pre>
   * This field has been deprecated in favor of `standard_isolation.priority`.
   * If you set this field, `standard_isolation.priority` will be set instead.
   *
   * The priority of requests sent using this app profile.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
   *
   * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
   *     google/bigtable/admin/v2/instance.proto;l=421
   * @return The priority.
   */
  @java.lang.Deprecated
  public com.google.bigtable.admin.v2.AppProfile.Priority getPriority() {
    if (isolationCase_ == 7) {
      com.google.bigtable.admin.v2.AppProfile.Priority result =
          com.google.bigtable.admin.v2.AppProfile.Priority.forNumber(
              (java.lang.Integer) isolation_);
      return result == null
          ? com.google.bigtable.admin.v2.AppProfile.Priority.UNRECOGNIZED
          : result;
    }
    return com.google.bigtable.admin.v2.AppProfile.Priority.PRIORITY_UNSPECIFIED;
  }

  public static final int STANDARD_ISOLATION_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * The standard options used for isolating this app profile's traffic from
   * other use cases.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
   *
   * @return Whether the standardIsolation field is set.
   */
  @java.lang.Override
  public boolean hasStandardIsolation() {
    return isolationCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * The standard options used for isolating this app profile's traffic from
   * other use cases.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
   *
   * @return The standardIsolation.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.StandardIsolation getStandardIsolation() {
    if (isolationCase_ == 11) {
      return (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_;
    }
    return com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The standard options used for isolating this app profile's traffic from
   * other use cases.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.StandardIsolationOrBuilder
      getStandardIsolationOrBuilder() {
    if (isolationCase_ == 11) {
      return (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_;
    }
    return com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance();
  }

  public static final int DATA_BOOST_ISOLATION_READ_ONLY_FIELD_NUMBER = 10;

  /**
   *
   *
   * <pre>
   * Specifies that this app profile is intended for read-only usage via the
   * Data Boost feature.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
   * </code>
   *
   * @return Whether the dataBoostIsolationReadOnly field is set.
   */
  @java.lang.Override
  public boolean hasDataBoostIsolationReadOnly() {
    return isolationCase_ == 10;
  }

  /**
   *
   *
   * <pre>
   * Specifies that this app profile is intended for read-only usage via the
   * Data Boost feature.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
   * </code>
   *
   * @return The dataBoostIsolationReadOnly.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
      getDataBoostIsolationReadOnly() {
    if (isolationCase_ == 10) {
      return (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) isolation_;
    }
    return com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Specifies that this app profile is intended for read-only usage via the
   * Data Boost feature.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnlyOrBuilder
      getDataBoostIsolationReadOnlyOrBuilder() {
    if (isolationCase_ == 10) {
      return (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) isolation_;
    }
    return com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, etag_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, description_);
    }
    if (routingPolicyCase_ == 5) {
      output.writeMessage(
          5, (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) routingPolicy_);
    }
    if (routingPolicyCase_ == 6) {
      output.writeMessage(
          6, (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_);
    }
    if (isolationCase_ == 7) {
      output.writeEnum(7, ((java.lang.Integer) isolation_));
    }
    if (isolationCase_ == 10) {
      output.writeMessage(
          10, (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) isolation_);
    }
    if (isolationCase_ == 11) {
      output.writeMessage(
          11, (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, etag_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, description_);
    }
    if (routingPolicyCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) routingPolicy_);
    }
    if (routingPolicyCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_);
    }
    if (isolationCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              7, ((java.lang.Integer) isolation_));
    }
    if (isolationCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) isolation_);
    }
    if (isolationCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.AppProfile)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.AppProfile other = (com.google.bigtable.admin.v2.AppProfile) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getRoutingPolicyCase().equals(other.getRoutingPolicyCase())) return false;
    switch (routingPolicyCase_) {
      case 5:
        if (!getMultiClusterRoutingUseAny().equals(other.getMultiClusterRoutingUseAny()))
          return false;
        break;
      case 6:
        if (!getSingleClusterRouting().equals(other.getSingleClusterRouting())) return false;
        break;
      case 0:
      default:
    }
    if (!getIsolationCase().equals(other.getIsolationCase())) return false;
    switch (isolationCase_) {
      case 7:
        if (getPriorityValue() != other.getPriorityValue()) return false;
        break;
      case 11:
        if (!getStandardIsolation().equals(other.getStandardIsolation())) return false;
        break;
      case 10:
        if (!getDataBoostIsolationReadOnly().equals(other.getDataBoostIsolationReadOnly()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    switch (routingPolicyCase_) {
      case 5:
        hash = (37 * hash) + MULTI_CLUSTER_ROUTING_USE_ANY_FIELD_NUMBER;
        hash = (53 * hash) + getMultiClusterRoutingUseAny().hashCode();
        break;
      case 6:
        hash = (37 * hash) + SINGLE_CLUSTER_ROUTING_FIELD_NUMBER;
        hash = (53 * hash) + getSingleClusterRouting().hashCode();
        break;
      case 0:
      default:
    }
    switch (isolationCase_) {
      case 7:
        hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
        hash = (53 * hash) + getPriorityValue();
        break;
      case 11:
        hash = (37 * hash) + STANDARD_ISOLATION_FIELD_NUMBER;
        hash = (53 * hash) + getStandardIsolation().hashCode();
        break;
      case 10:
        hash = (37 * hash) + DATA_BOOST_ISOLATION_READ_ONLY_FIELD_NUMBER;
        hash = (53 * hash) + getDataBoostIsolationReadOnly().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.AppProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.AppProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A configuration object describing how Cloud Bigtable should treat traffic
   * from a particular end user application.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.AppProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.AppProfile)
      com.google.bigtable.admin.v2.AppProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.AppProfile.class,
              com.google.bigtable.admin.v2.AppProfile.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.AppProfile.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      etag_ = "";
      description_ = "";
      if (multiClusterRoutingUseAnyBuilder_ != null) {
        multiClusterRoutingUseAnyBuilder_.clear();
      }
      if (singleClusterRoutingBuilder_ != null) {
        singleClusterRoutingBuilder_.clear();
      }
      if (standardIsolationBuilder_ != null) {
        standardIsolationBuilder_.clear();
      }
      if (dataBoostIsolationReadOnlyBuilder_ != null) {
        dataBoostIsolationReadOnlyBuilder_.clear();
      }
      routingPolicyCase_ = 0;
      routingPolicy_ = null;
      isolationCase_ = 0;
      isolation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_AppProfile_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.AppProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile build() {
      com.google.bigtable.admin.v2.AppProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile buildPartial() {
      com.google.bigtable.admin.v2.AppProfile result =
          new com.google.bigtable.admin.v2.AppProfile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.AppProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
    }

    private void buildPartialOneofs(com.google.bigtable.admin.v2.AppProfile result) {
      result.routingPolicyCase_ = routingPolicyCase_;
      result.routingPolicy_ = this.routingPolicy_;
      if (routingPolicyCase_ == 5 && multiClusterRoutingUseAnyBuilder_ != null) {
        result.routingPolicy_ = multiClusterRoutingUseAnyBuilder_.build();
      }
      if (routingPolicyCase_ == 6 && singleClusterRoutingBuilder_ != null) {
        result.routingPolicy_ = singleClusterRoutingBuilder_.build();
      }
      result.isolationCase_ = isolationCase_;
      result.isolation_ = this.isolation_;
      if (isolationCase_ == 11 && standardIsolationBuilder_ != null) {
        result.isolation_ = standardIsolationBuilder_.build();
      }
      if (isolationCase_ == 10 && dataBoostIsolationReadOnlyBuilder_ != null) {
        result.isolation_ = dataBoostIsolationReadOnlyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.AppProfile) {
        return mergeFrom((com.google.bigtable.admin.v2.AppProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.AppProfile other) {
      if (other == com.google.bigtable.admin.v2.AppProfile.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getRoutingPolicyCase()) {
        case MULTI_CLUSTER_ROUTING_USE_ANY:
          {
            mergeMultiClusterRoutingUseAny(other.getMultiClusterRoutingUseAny());
            break;
          }
        case SINGLE_CLUSTER_ROUTING:
          {
            mergeSingleClusterRouting(other.getSingleClusterRouting());
            break;
          }
        case ROUTINGPOLICY_NOT_SET:
          {
            break;
          }
      }
      switch (other.getIsolationCase()) {
        case PRIORITY:
          {
            setPriorityValue(other.getPriorityValue());
            break;
          }
        case STANDARD_ISOLATION:
          {
            mergeStandardIsolation(other.getStandardIsolation());
            break;
          }
        case DATA_BOOST_ISOLATION_READ_ONLY:
          {
            mergeDataBoostIsolationReadOnly(other.getDataBoostIsolationReadOnly());
            break;
          }
        case ISOLATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    internalGetMultiClusterRoutingUseAnyFieldBuilder().getBuilder(),
                    extensionRegistry);
                routingPolicyCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    internalGetSingleClusterRoutingFieldBuilder().getBuilder(), extensionRegistry);
                routingPolicyCase_ = 6;
                break;
              } // case 50
            case 56:
              {
                int rawValue = input.readEnum();
                isolationCase_ = 7;
                isolation_ = rawValue;
                break;
              } // case 56
            case 82:
              {
                input.readMessage(
                    internalGetDataBoostIsolationReadOnlyFieldBuilder().getBuilder(),
                    extensionRegistry);
                isolationCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    internalGetStandardIsolationFieldBuilder().getBuilder(), extensionRegistry);
                isolationCase_ = 11;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int routingPolicyCase_ = 0;
    private java.lang.Object routingPolicy_;

    public RoutingPolicyCase getRoutingPolicyCase() {
      return RoutingPolicyCase.forNumber(routingPolicyCase_);
    }

    public Builder clearRoutingPolicy() {
      routingPolicyCase_ = 0;
      routingPolicy_ = null;
      onChanged();
      return this;
    }

    private int isolationCase_ = 0;
    private java.lang.Object isolation_;

    public IsolationCase getIsolationCase() {
      return IsolationCase.forNumber(isolationCase_);
    }

    public Builder clearIsolation() {
      isolationCase_ = 0;
      isolation_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The unique name of the app profile. Values are of the form
     * `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique name of the app profile. Values are of the form
     * `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique name of the app profile. Values are of the form
     * `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique name of the app profile. Values are of the form
     * `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique name of the app profile. Values are of the form
     * `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Strongly validated etag for optimistic concurrency control. Preserve the
     * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
     * fail the request if there has been a modification in the mean time. The
     * `update_mask` of the request need not include `etag` for this protection
     * to apply.
     * See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
     * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
     * details.
     * </pre>
     *
     * <code>string etag = 2;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Strongly validated etag for optimistic concurrency control. Preserve the
     * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
     * fail the request if there has been a modification in the mean time. The
     * `update_mask` of the request need not include `etag` for this protection
     * to apply.
     * See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
     * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
     * details.
     * </pre>
     *
     * <code>string etag = 2;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Strongly validated etag for optimistic concurrency control. Preserve the
     * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
     * fail the request if there has been a modification in the mean time. The
     * `update_mask` of the request need not include `etag` for this protection
     * to apply.
     * See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
     * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
     * details.
     * </pre>
     *
     * <code>string etag = 2;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Strongly validated etag for optimistic concurrency control. Preserve the
     * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
     * fail the request if there has been a modification in the mean time. The
     * `update_mask` of the request need not include `etag` for this protection
     * to apply.
     * See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
     * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
     * details.
     * </pre>
     *
     * <code>string etag = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Strongly validated etag for optimistic concurrency control. Preserve the
     * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
     * fail the request if there has been a modification in the mean time. The
     * `update_mask` of the request need not include `etag` for this protection
     * to apply.
     * See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
     * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
     * details.
     * </pre>
     *
     * <code>string etag = 2;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Long form description of the use case for this AppProfile.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Long form description of the use case for this AppProfile.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Long form description of the use case for this AppProfile.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Long form description of the use case for this AppProfile.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Long form description of the use case for this AppProfile.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny,
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.Builder,
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAnyOrBuilder>
        multiClusterRoutingUseAnyBuilder_;

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     *
     * @return Whether the multiClusterRoutingUseAny field is set.
     */
    @java.lang.Override
    public boolean hasMultiClusterRoutingUseAny() {
      return routingPolicyCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     *
     * @return The multiClusterRoutingUseAny.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
        getMultiClusterRoutingUseAny() {
      if (multiClusterRoutingUseAnyBuilder_ == null) {
        if (routingPolicyCase_ == 5) {
          return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) routingPolicy_;
        }
        return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
            .getDefaultInstance();
      } else {
        if (routingPolicyCase_ == 5) {
          return multiClusterRoutingUseAnyBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     */
    public Builder setMultiClusterRoutingUseAny(
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny value) {
      if (multiClusterRoutingUseAnyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routingPolicy_ = value;
        onChanged();
      } else {
        multiClusterRoutingUseAnyBuilder_.setMessage(value);
      }
      routingPolicyCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     */
    public Builder setMultiClusterRoutingUseAny(
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.Builder builderForValue) {
      if (multiClusterRoutingUseAnyBuilder_ == null) {
        routingPolicy_ = builderForValue.build();
        onChanged();
      } else {
        multiClusterRoutingUseAnyBuilder_.setMessage(builderForValue.build());
      }
      routingPolicyCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     */
    public Builder mergeMultiClusterRoutingUseAny(
        com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny value) {
      if (multiClusterRoutingUseAnyBuilder_ == null) {
        if (routingPolicyCase_ == 5
            && routingPolicy_
                != com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
                    .getDefaultInstance()) {
          routingPolicy_ =
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.newBuilder(
                      (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny)
                          routingPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          routingPolicy_ = value;
        }
        onChanged();
      } else {
        if (routingPolicyCase_ == 5) {
          multiClusterRoutingUseAnyBuilder_.mergeFrom(value);
        } else {
          multiClusterRoutingUseAnyBuilder_.setMessage(value);
        }
      }
      routingPolicyCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     */
    public Builder clearMultiClusterRoutingUseAny() {
      if (multiClusterRoutingUseAnyBuilder_ == null) {
        if (routingPolicyCase_ == 5) {
          routingPolicyCase_ = 0;
          routingPolicy_ = null;
          onChanged();
        }
      } else {
        if (routingPolicyCase_ == 5) {
          routingPolicyCase_ = 0;
          routingPolicy_ = null;
        }
        multiClusterRoutingUseAnyBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     */
    public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.Builder
        getMultiClusterRoutingUseAnyBuilder() {
      return internalGetMultiClusterRoutingUseAnyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAnyOrBuilder
        getMultiClusterRoutingUseAnyOrBuilder() {
      if ((routingPolicyCase_ == 5) && (multiClusterRoutingUseAnyBuilder_ != null)) {
        return multiClusterRoutingUseAnyBuilder_.getMessageOrBuilder();
      } else {
        if (routingPolicyCase_ == 5) {
          return (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) routingPolicy_;
        }
        return com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Use a multi-cluster routing policy.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny multi_cluster_routing_use_any = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny,
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.Builder,
            com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAnyOrBuilder>
        internalGetMultiClusterRoutingUseAnyFieldBuilder() {
      if (multiClusterRoutingUseAnyBuilder_ == null) {
        if (!(routingPolicyCase_ == 5)) {
          routingPolicy_ =
              com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
                  .getDefaultInstance();
        }
        multiClusterRoutingUseAnyBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny,
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.Builder,
                com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAnyOrBuilder>(
                (com.google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny) routingPolicy_,
                getParentForChildren(),
                isClean());
        routingPolicy_ = null;
      }
      routingPolicyCase_ = 5;
      onChanged();
      return multiClusterRoutingUseAnyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting,
            com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.Builder,
            com.google.bigtable.admin.v2.AppProfile.SingleClusterRoutingOrBuilder>
        singleClusterRoutingBuilder_;

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     *
     * @return Whether the singleClusterRouting field is set.
     */
    @java.lang.Override
    public boolean hasSingleClusterRouting() {
      return routingPolicyCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     *
     * @return The singleClusterRouting.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting getSingleClusterRouting() {
      if (singleClusterRoutingBuilder_ == null) {
        if (routingPolicyCase_ == 6) {
          return (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_;
        }
        return com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance();
      } else {
        if (routingPolicyCase_ == 6) {
          return singleClusterRoutingBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     */
    public Builder setSingleClusterRouting(
        com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting value) {
      if (singleClusterRoutingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routingPolicy_ = value;
        onChanged();
      } else {
        singleClusterRoutingBuilder_.setMessage(value);
      }
      routingPolicyCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     */
    public Builder setSingleClusterRouting(
        com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.Builder builderForValue) {
      if (singleClusterRoutingBuilder_ == null) {
        routingPolicy_ = builderForValue.build();
        onChanged();
      } else {
        singleClusterRoutingBuilder_.setMessage(builderForValue.build());
      }
      routingPolicyCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     */
    public Builder mergeSingleClusterRouting(
        com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting value) {
      if (singleClusterRoutingBuilder_ == null) {
        if (routingPolicyCase_ == 6
            && routingPolicy_
                != com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting
                    .getDefaultInstance()) {
          routingPolicy_ =
              com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.newBuilder(
                      (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          routingPolicy_ = value;
        }
        onChanged();
      } else {
        if (routingPolicyCase_ == 6) {
          singleClusterRoutingBuilder_.mergeFrom(value);
        } else {
          singleClusterRoutingBuilder_.setMessage(value);
        }
      }
      routingPolicyCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     */
    public Builder clearSingleClusterRouting() {
      if (singleClusterRoutingBuilder_ == null) {
        if (routingPolicyCase_ == 6) {
          routingPolicyCase_ = 0;
          routingPolicy_ = null;
          onChanged();
        }
      } else {
        if (routingPolicyCase_ == 6) {
          routingPolicyCase_ = 0;
          routingPolicy_ = null;
        }
        singleClusterRoutingBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     */
    public com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.Builder
        getSingleClusterRoutingBuilder() {
      return internalGetSingleClusterRoutingFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.SingleClusterRoutingOrBuilder
        getSingleClusterRoutingOrBuilder() {
      if ((routingPolicyCase_ == 6) && (singleClusterRoutingBuilder_ != null)) {
        return singleClusterRoutingBuilder_.getMessageOrBuilder();
      } else {
        if (routingPolicyCase_ == 6) {
          return (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_;
        }
        return com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Use a single-cluster routing policy.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.SingleClusterRouting single_cluster_routing = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting,
            com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.Builder,
            com.google.bigtable.admin.v2.AppProfile.SingleClusterRoutingOrBuilder>
        internalGetSingleClusterRoutingFieldBuilder() {
      if (singleClusterRoutingBuilder_ == null) {
        if (!(routingPolicyCase_ == 6)) {
          routingPolicy_ =
              com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.getDefaultInstance();
        }
        singleClusterRoutingBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting,
                com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting.Builder,
                com.google.bigtable.admin.v2.AppProfile.SingleClusterRoutingOrBuilder>(
                (com.google.bigtable.admin.v2.AppProfile.SingleClusterRouting) routingPolicy_,
                getParentForChildren(),
                isClean());
        routingPolicy_ = null;
      }
      routingPolicyCase_ = 6;
      onChanged();
      return singleClusterRoutingBuilder_;
    }

    /**
     *
     *
     * <pre>
     * This field has been deprecated in favor of `standard_isolation.priority`.
     * If you set this field, `standard_isolation.priority` will be set instead.
     *
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
     *
     * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
     *     google/bigtable/admin/v2/instance.proto;l=421
     * @return Whether the priority field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasPriority() {
      return isolationCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * This field has been deprecated in favor of `standard_isolation.priority`.
     * If you set this field, `standard_isolation.priority` will be set instead.
     *
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
     *
     * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
     *     google/bigtable/admin/v2/instance.proto;l=421
     * @return The enum numeric value on the wire for priority.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getPriorityValue() {
      if (isolationCase_ == 7) {
        return ((java.lang.Integer) isolation_).intValue();
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * This field has been deprecated in favor of `standard_isolation.priority`.
     * If you set this field, `standard_isolation.priority` will be set instead.
     *
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
     *
     * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
     *     google/bigtable/admin/v2/instance.proto;l=421
     * @param value The enum numeric value on the wire for priority to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPriorityValue(int value) {
      isolationCase_ = 7;
      isolation_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field has been deprecated in favor of `standard_isolation.priority`.
     * If you set this field, `standard_isolation.priority` will be set instead.
     *
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
     *
     * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
     *     google/bigtable/admin/v2/instance.proto;l=421
     * @return The priority.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.bigtable.admin.v2.AppProfile.Priority getPriority() {
      if (isolationCase_ == 7) {
        com.google.bigtable.admin.v2.AppProfile.Priority result =
            com.google.bigtable.admin.v2.AppProfile.Priority.forNumber(
                (java.lang.Integer) isolation_);
        return result == null
            ? com.google.bigtable.admin.v2.AppProfile.Priority.UNRECOGNIZED
            : result;
      }
      return com.google.bigtable.admin.v2.AppProfile.Priority.PRIORITY_UNSPECIFIED;
    }

    /**
     *
     *
     * <pre>
     * This field has been deprecated in favor of `standard_isolation.priority`.
     * If you set this field, `standard_isolation.priority` will be set instead.
     *
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
     *
     * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
     *     google/bigtable/admin/v2/instance.proto;l=421
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPriority(com.google.bigtable.admin.v2.AppProfile.Priority value) {
      if (value == null) {
        throw new NullPointerException();
      }
      isolationCase_ = 7;
      isolation_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This field has been deprecated in favor of `standard_isolation.priority`.
     * If you set this field, `standard_isolation.priority` will be set instead.
     *
     * The priority of requests sent using this app profile.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.Priority priority = 7 [deprecated = true];</code>
     *
     * @deprecated google.bigtable.admin.v2.AppProfile.priority is deprecated. See
     *     google/bigtable/admin/v2/instance.proto;l=421
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearPriority() {
      if (isolationCase_ == 7) {
        isolationCase_ = 0;
        isolation_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.StandardIsolation,
            com.google.bigtable.admin.v2.AppProfile.StandardIsolation.Builder,
            com.google.bigtable.admin.v2.AppProfile.StandardIsolationOrBuilder>
        standardIsolationBuilder_;

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     *
     * @return Whether the standardIsolation field is set.
     */
    @java.lang.Override
    public boolean hasStandardIsolation() {
      return isolationCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     *
     * @return The standardIsolation.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.StandardIsolation getStandardIsolation() {
      if (standardIsolationBuilder_ == null) {
        if (isolationCase_ == 11) {
          return (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_;
        }
        return com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance();
      } else {
        if (isolationCase_ == 11) {
          return standardIsolationBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     */
    public Builder setStandardIsolation(
        com.google.bigtable.admin.v2.AppProfile.StandardIsolation value) {
      if (standardIsolationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        isolation_ = value;
        onChanged();
      } else {
        standardIsolationBuilder_.setMessage(value);
      }
      isolationCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     */
    public Builder setStandardIsolation(
        com.google.bigtable.admin.v2.AppProfile.StandardIsolation.Builder builderForValue) {
      if (standardIsolationBuilder_ == null) {
        isolation_ = builderForValue.build();
        onChanged();
      } else {
        standardIsolationBuilder_.setMessage(builderForValue.build());
      }
      isolationCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     */
    public Builder mergeStandardIsolation(
        com.google.bigtable.admin.v2.AppProfile.StandardIsolation value) {
      if (standardIsolationBuilder_ == null) {
        if (isolationCase_ == 11
            && isolation_
                != com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance()) {
          isolation_ =
              com.google.bigtable.admin.v2.AppProfile.StandardIsolation.newBuilder(
                      (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          isolation_ = value;
        }
        onChanged();
      } else {
        if (isolationCase_ == 11) {
          standardIsolationBuilder_.mergeFrom(value);
        } else {
          standardIsolationBuilder_.setMessage(value);
        }
      }
      isolationCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     */
    public Builder clearStandardIsolation() {
      if (standardIsolationBuilder_ == null) {
        if (isolationCase_ == 11) {
          isolationCase_ = 0;
          isolation_ = null;
          onChanged();
        }
      } else {
        if (isolationCase_ == 11) {
          isolationCase_ = 0;
          isolation_ = null;
        }
        standardIsolationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     */
    public com.google.bigtable.admin.v2.AppProfile.StandardIsolation.Builder
        getStandardIsolationBuilder() {
      return internalGetStandardIsolationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.StandardIsolationOrBuilder
        getStandardIsolationOrBuilder() {
      if ((isolationCase_ == 11) && (standardIsolationBuilder_ != null)) {
        return standardIsolationBuilder_.getMessageOrBuilder();
      } else {
        if (isolationCase_ == 11) {
          return (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_;
        }
        return com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The standard options used for isolating this app profile's traffic from
     * other use cases.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.AppProfile.StandardIsolation standard_isolation = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.StandardIsolation,
            com.google.bigtable.admin.v2.AppProfile.StandardIsolation.Builder,
            com.google.bigtable.admin.v2.AppProfile.StandardIsolationOrBuilder>
        internalGetStandardIsolationFieldBuilder() {
      if (standardIsolationBuilder_ == null) {
        if (!(isolationCase_ == 11)) {
          isolation_ =
              com.google.bigtable.admin.v2.AppProfile.StandardIsolation.getDefaultInstance();
        }
        standardIsolationBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.AppProfile.StandardIsolation,
                com.google.bigtable.admin.v2.AppProfile.StandardIsolation.Builder,
                com.google.bigtable.admin.v2.AppProfile.StandardIsolationOrBuilder>(
                (com.google.bigtable.admin.v2.AppProfile.StandardIsolation) isolation_,
                getParentForChildren(),
                isClean());
        isolation_ = null;
      }
      isolationCase_ = 11;
      onChanged();
      return standardIsolationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly,
            com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.Builder,
            com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnlyOrBuilder>
        dataBoostIsolationReadOnlyBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     *
     * @return Whether the dataBoostIsolationReadOnly field is set.
     */
    @java.lang.Override
    public boolean hasDataBoostIsolationReadOnly() {
      return isolationCase_ == 10;
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     *
     * @return The dataBoostIsolationReadOnly.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
        getDataBoostIsolationReadOnly() {
      if (dataBoostIsolationReadOnlyBuilder_ == null) {
        if (isolationCase_ == 10) {
          return (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) isolation_;
        }
        return com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
            .getDefaultInstance();
      } else {
        if (isolationCase_ == 10) {
          return dataBoostIsolationReadOnlyBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     */
    public Builder setDataBoostIsolationReadOnly(
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly value) {
      if (dataBoostIsolationReadOnlyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        isolation_ = value;
        onChanged();
      } else {
        dataBoostIsolationReadOnlyBuilder_.setMessage(value);
      }
      isolationCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     */
    public Builder setDataBoostIsolationReadOnly(
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.Builder
            builderForValue) {
      if (dataBoostIsolationReadOnlyBuilder_ == null) {
        isolation_ = builderForValue.build();
        onChanged();
      } else {
        dataBoostIsolationReadOnlyBuilder_.setMessage(builderForValue.build());
      }
      isolationCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     */
    public Builder mergeDataBoostIsolationReadOnly(
        com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly value) {
      if (dataBoostIsolationReadOnlyBuilder_ == null) {
        if (isolationCase_ == 10
            && isolation_
                != com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
                    .getDefaultInstance()) {
          isolation_ =
              com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.newBuilder(
                      (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly)
                          isolation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          isolation_ = value;
        }
        onChanged();
      } else {
        if (isolationCase_ == 10) {
          dataBoostIsolationReadOnlyBuilder_.mergeFrom(value);
        } else {
          dataBoostIsolationReadOnlyBuilder_.setMessage(value);
        }
      }
      isolationCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     */
    public Builder clearDataBoostIsolationReadOnly() {
      if (dataBoostIsolationReadOnlyBuilder_ == null) {
        if (isolationCase_ == 10) {
          isolationCase_ = 0;
          isolation_ = null;
          onChanged();
        }
      } else {
        if (isolationCase_ == 10) {
          isolationCase_ = 0;
          isolation_ = null;
        }
        dataBoostIsolationReadOnlyBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     */
    public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.Builder
        getDataBoostIsolationReadOnlyBuilder() {
      return internalGetDataBoostIsolationReadOnlyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnlyOrBuilder
        getDataBoostIsolationReadOnlyOrBuilder() {
      if ((isolationCase_ == 10) && (dataBoostIsolationReadOnlyBuilder_ != null)) {
        return dataBoostIsolationReadOnlyBuilder_.getMessageOrBuilder();
      } else {
        if (isolationCase_ == 10) {
          return (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) isolation_;
        }
        return com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies that this app profile is intended for read-only usage via the
     * Data Boost feature.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly data_boost_isolation_read_only = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly,
            com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.Builder,
            com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnlyOrBuilder>
        internalGetDataBoostIsolationReadOnlyFieldBuilder() {
      if (dataBoostIsolationReadOnlyBuilder_ == null) {
        if (!(isolationCase_ == 10)) {
          isolation_ =
              com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
                  .getDefaultInstance();
        }
        dataBoostIsolationReadOnlyBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly,
                com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.Builder,
                com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnlyOrBuilder>(
                (com.google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly) isolation_,
                getParentForChildren(),
                isClean());
        isolation_ = null;
      }
      isolationCase_ = 10;
      onChanged();
      return dataBoostIsolationReadOnlyBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.AppProfile)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.AppProfile)
  private static final com.google.bigtable.admin.v2.AppProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.AppProfile();
  }

  public static com.google.bigtable.admin.v2.AppProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AppProfile> PARSER =
      new com.google.protobuf.AbstractParser<AppProfile>() {
        @java.lang.Override
        public AppProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AppProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AppProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.AppProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
