/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/bigtable/admin/v2/types.proto
// Protobuf Java Version: 4.33.2

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * `Type` represents the type of data that is written to, read from, or stored
 * in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
 * familiarity and consistency across products and features.
 *
 * For compatibility with Bigtable's existing untyped APIs, each `Type` includes
 * an `Encoding` which describes how to convert to or from the underlying data.
 *
 * Each encoding can operate in one of two modes:
 *
 * - Sorted: In this mode, Bigtable guarantees that `Encode(X) &lt;= Encode(Y)`
 * if and only if `X &lt;= Y`. This is useful anywhere sort order is important,
 * for example when encoding keys.
 * - Distinct: In this mode, Bigtable guarantees that if `X != Y` then
 * `Encode(X) != Encode(Y)`. However, the converse is not guaranteed. For
 * example, both "{'foo': '1', 'bar': '2'}" and "{'bar': '2', 'foo': '1'}"
 * are valid encodings of the same JSON value.
 *
 * The API clearly documents which mode is used wherever an encoding can be
 * configured. Each encoding also documents which values are supported in which
 * modes. For example, when encoding INT64 as a numeric STRING, negative numbers
 * cannot be encoded in sorted mode. This is because `INT64(1) &gt; INT64(-1)`, but
 * `STRING("-00001") &gt; STRING("00001")`.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.Type}
 */
@com.google.protobuf.Generated
public final class Type extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type)
    TypeOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "Type");
  }

  // Use Type.newBuilder() to construct.
  private Type(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private Type() {}

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.TypesProto
        .internal_static_google_bigtable_admin_v2_Type_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.TypesProto
        .internal_static_google_bigtable_admin_v2_Type_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.Type.class,
            com.google.bigtable.admin.v2.Type.Builder.class);
  }

  public interface BytesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Bytes)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    boolean hasEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    com.google.bigtable.admin.v2.Type.Bytes.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder getEncodingOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Bytes
   * Values of type `Bytes` are stored in `Value.bytes_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes}
   */
  public static final class Bytes extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Bytes)
      BytesOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Bytes");
    }

    // Use Bytes.newBuilder() to construct.
    private Bytes(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Bytes() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Bytes_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Bytes_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Bytes.class,
              com.google.bigtable.admin.v2.Type.Bytes.Builder.class);
    }

    public interface EncodingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Bytes.Encoding)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return Whether the raw field is set.
       */
      boolean hasRaw();

      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return The raw.
       */
      com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getRaw();

      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       */
      com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder getRawOrBuilder();

      com.google.bigtable.admin.v2.Type.Bytes.Encoding.EncodingCase getEncodingCase();
    }

    /**
     *
     *
     * <pre>
     * Rules used to convert to or from lower level types.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding}
     */
    public static final class Encoding extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Bytes.Encoding)
        EncodingOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Encoding");
      }

      // Use Encoding.newBuilder() to construct.
      private Encoding(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Encoding() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.class,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder.class);
      }

      public interface RawOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
          com.google.protobuf.MessageOrBuilder {}

      /**
       *
       *
       * <pre>
       * Leaves the value as-is.
       *
       * Sorted mode: all values are supported.
       *
       * Distinct mode: all values are supported.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding.Raw}
       */
      public static final class Raw extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
          RawOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "Raw");
        }

        // Use Raw.newBuilder() to construct.
        private Raw(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private Raw() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.class,
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder.class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw other =
              (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Leaves the value as-is.
         *
         * Sorted mode: all values are supported.
         *
         * Distinct mode: all values are supported.
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding.Raw}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.class,
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder.class);
          }

          // Construct using com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw build() {
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw buildPartial() {
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw result =
                new com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) {
              return mergeFrom((com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw other) {
            if (other == com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance())
              return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
        private static final com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw();
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Raw> PARSER =
            new com.google.protobuf.AbstractParser<Raw>() {
              @java.lang.Override
              public Raw parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Raw> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Raw> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int encodingCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object encoding_;

      public enum EncodingCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        RAW(1),
        ENCODING_NOT_SET(0);
        private final int value;

        private EncodingCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EncodingCase valueOf(int value) {
          return forNumber(value);
        }

        public static EncodingCase forNumber(int value) {
          switch (value) {
            case 1:
              return RAW;
            case 0:
              return ENCODING_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EncodingCase getEncodingCase() {
        return EncodingCase.forNumber(encodingCase_);
      }

      public static final int RAW_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return Whether the raw field is set.
       */
      @java.lang.Override
      public boolean hasRaw() {
        return encodingCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return The raw.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getRaw() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder getRawOrBuilder() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (encodingCase_ == 1) {
          output.writeMessage(1, (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (encodingCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Bytes.Encoding other =
            (com.google.bigtable.admin.v2.Type.Bytes.Encoding) obj;

        if (!getEncodingCase().equals(other.getEncodingCase())) return false;
        switch (encodingCase_) {
          case 1:
            if (!getRaw().equals(other.getRaw())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (encodingCase_) {
          case 1:
            hash = (37 * hash) + RAW_FIELD_NUMBER;
            hash = (53 * hash) + getRaw().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Bytes.Encoding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Rules used to convert to or from lower level types.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Bytes.Encoding)
          com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.class,
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Bytes.Encoding.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (rawBuilder_ != null) {
            rawBuilder_.clear();
          }
          encodingCase_ = 0;
          encoding_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding build() {
          com.google.bigtable.admin.v2.Type.Bytes.Encoding result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding buildPartial() {
          com.google.bigtable.admin.v2.Type.Bytes.Encoding result =
              new com.google.bigtable.admin.v2.Type.Bytes.Encoding(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.Bytes.Encoding result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.Bytes.Encoding result) {
          result.encodingCase_ = encodingCase_;
          result.encoding_ = this.encoding_;
          if (encodingCase_ == 1 && rawBuilder_ != null) {
            result.encoding_ = rawBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Bytes.Encoding) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Bytes.Encoding other) {
          if (other == com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance())
            return this;
          switch (other.getEncodingCase()) {
            case RAW:
              {
                mergeRaw(other.getRaw());
                break;
              }
            case ENCODING_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(internalGetRawFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 1;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int encodingCase_ = 0;
        private java.lang.Object encoding_;

        public EncodingCase getEncodingCase() {
          return EncodingCase.forNumber(encodingCase_);
        }

        public Builder clearEncoding() {
          encodingCase_ = 0;
          encoding_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder>
            rawBuilder_;

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         *
         * @return Whether the raw field is set.
         */
        @java.lang.Override
        public boolean hasRaw() {
          return encodingCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         *
         * @return The raw.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getRaw() {
          if (rawBuilder_ == null) {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          } else {
            if (encodingCase_ == 1) {
              return rawBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder setRaw(com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw value) {
          if (rawBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            rawBuilder_.setMessage(value);
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder setRaw(
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder builderForValue) {
          if (rawBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            rawBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder mergeRaw(com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw value) {
          if (rawBuilder_ == null) {
            if (encodingCase_ == 1
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 1) {
              rawBuilder_.mergeFrom(value);
            } else {
              rawBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder clearRaw() {
          if (rawBuilder_ == null) {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            rawBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder getRawBuilder() {
          return internalGetRawFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder getRawOrBuilder() {
          if ((encodingCase_ == 1) && (rawBuilder_ != null)) {
            return rawBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder>
            internalGetRawFieldBuilder() {
          if (rawBuilder_ == null) {
            if (!(encodingCase_ == 1)) {
              encoding_ = com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
            }
            rawBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw,
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder,
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 1;
          onChanged();
          return rawBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Bytes.Encoding)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Bytes.Encoding)
      private static final com.google.bigtable.admin.v2.Type.Bytes.Encoding DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Bytes.Encoding();
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Encoding> PARSER =
          new com.google.protobuf.AbstractParser<Encoding>() {
            @java.lang.Override
            public Encoding parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Encoding> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Encoding> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int ENCODING_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type.Bytes.Encoding encoding_;

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    @java.lang.Override
    public boolean hasEncoding() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes.Encoding getEncoding() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
          : encoding_;
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder getEncodingOrBuilder() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
          : encoding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEncoding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEncoding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Bytes)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Bytes other = (com.google.bigtable.admin.v2.Type.Bytes) obj;

      if (hasEncoding() != other.hasEncoding()) return false;
      if (hasEncoding()) {
        if (!getEncoding().equals(other.getEncoding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEncoding()) {
        hash = (37 * hash) + ENCODING_FIELD_NUMBER;
        hash = (53 * hash) + getEncoding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Bytes prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * Values of type `Bytes` are stored in `Value.bytes_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Bytes)
        com.google.bigtable.admin.v2.Type.BytesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Bytes.class,
                com.google.bigtable.admin.v2.Type.Bytes.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Bytes.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetEncodingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes build() {
        com.google.bigtable.admin.v2.Type.Bytes result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes buildPartial() {
        com.google.bigtable.admin.v2.Type.Bytes result =
            new com.google.bigtable.admin.v2.Type.Bytes(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Bytes result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.encoding_ = encodingBuilder_ == null ? encoding_ : encodingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Bytes) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Bytes) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Bytes other) {
        if (other == com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()) return this;
        if (other.hasEncoding()) {
          mergeEncoding(other.getEncoding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetEncodingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type.Bytes.Encoding encoding_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Bytes.Encoding,
              com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder>
          encodingBuilder_;

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       *
       * @return Whether the encoding field is set.
       */
      public boolean hasEncoding() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       *
       * @return The encoding.
       */
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding getEncoding() {
        if (encodingBuilder_ == null) {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
              : encoding_;
        } else {
          return encodingBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(com.google.bigtable.admin.v2.Type.Bytes.Encoding value) {
        if (encodingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encoding_ = value;
        } else {
          encodingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(
          com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder builderForValue) {
        if (encodingBuilder_ == null) {
          encoding_ = builderForValue.build();
        } else {
          encodingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder mergeEncoding(com.google.bigtable.admin.v2.Type.Bytes.Encoding value) {
        if (encodingBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && encoding_ != null
              && encoding_
                  != com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()) {
            getEncodingBuilder().mergeFrom(value);
          } else {
            encoding_ = value;
          }
        } else {
          encodingBuilder_.mergeFrom(value);
        }
        if (encoding_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000001);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder getEncodingBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetEncodingFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder getEncodingOrBuilder() {
        if (encodingBuilder_ != null) {
          return encodingBuilder_.getMessageOrBuilder();
        } else {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
              : encoding_;
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Bytes.Encoding,
              com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder>
          internalGetEncodingFieldBuilder() {
        if (encodingBuilder_ == null) {
          encodingBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding,
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder,
                  com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder>(
                  getEncoding(), getParentForChildren(), isClean());
          encoding_ = null;
        }
        return encodingBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Bytes)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Bytes)
    private static final com.google.bigtable.admin.v2.Type.Bytes DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Bytes();
    }

    public static com.google.bigtable.admin.v2.Type.Bytes getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Bytes> PARSER =
        new com.google.protobuf.AbstractParser<Bytes>() {
          @java.lang.Override
          public Bytes parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Bytes> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Bytes> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StringOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.String)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    boolean hasEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    com.google.bigtable.admin.v2.Type.String.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.String.EncodingOrBuilder getEncodingOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * String
   * Values of type `String` are stored in `Value.string_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.String}
   */
  public static final class String extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.String)
      StringOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "String");
    }

    // Use String.newBuilder() to construct.
    private String(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private String() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_String_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_String_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.String.class,
              com.google.bigtable.admin.v2.Type.String.Builder.class);
    }

    public interface EncodingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.String.Encoding)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Deprecated: if set, converts to an empty `utf8_bytes`.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.bigtable.admin.v2.Type.String.Encoding.utf8_raw is deprecated. See
       *     google/bigtable/admin/v2/types.proto;l=102
       * @return Whether the utf8Raw field is set.
       */
      @java.lang.Deprecated
      boolean hasUtf8Raw();

      /**
       *
       *
       * <pre>
       * Deprecated: if set, converts to an empty `utf8_bytes`.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.bigtable.admin.v2.Type.String.Encoding.utf8_raw is deprecated. See
       *     google/bigtable/admin/v2/types.proto;l=102
       * @return The utf8Raw.
       */
      @java.lang.Deprecated
      com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw getUtf8Raw();

      /**
       *
       *
       * <pre>
       * Deprecated: if set, converts to an empty `utf8_bytes`.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      com.google.bigtable.admin.v2.Type.String.Encoding.Utf8RawOrBuilder getUtf8RawOrBuilder();

      /**
       *
       *
       * <pre>
       * Use `Utf8Bytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
       *
       * @return Whether the utf8Bytes field is set.
       */
      boolean hasUtf8Bytes();

      /**
       *
       *
       * <pre>
       * Use `Utf8Bytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
       *
       * @return The utf8Bytes.
       */
      com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes getUtf8Bytes();

      /**
       *
       *
       * <pre>
       * Use `Utf8Bytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
       */
      com.google.bigtable.admin.v2.Type.String.Encoding.Utf8BytesOrBuilder getUtf8BytesOrBuilder();

      com.google.bigtable.admin.v2.Type.String.Encoding.EncodingCase getEncodingCase();
    }

    /**
     *
     *
     * <pre>
     * Rules used to convert to or from lower level types.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.String.Encoding}
     */
    public static final class Encoding extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.String.Encoding)
        EncodingOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Encoding");
      }

      // Use Encoding.newBuilder() to construct.
      private Encoding(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Encoding() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_String_Encoding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_String_Encoding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.String.Encoding.class,
                com.google.bigtable.admin.v2.Type.String.Encoding.Builder.class);
      }

      @java.lang.Deprecated
      public interface Utf8RawOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw)
          com.google.protobuf.MessageOrBuilder {}

      /**
       *
       *
       * <pre>
       * Deprecated: prefer the equivalent `Utf8Bytes`.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw}
       */
      @java.lang.Deprecated
      public static final class Utf8Raw extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw)
          Utf8RawOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "Utf8Raw");
        }

        // Use Utf8Raw.newBuilder() to construct.
        private Utf8Raw(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private Utf8Raw() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Raw_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Raw_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.class,
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.Builder.class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw other =
              (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Deprecated: prefer the equivalent `Utf8Bytes`.
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw)
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8RawOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Raw_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Raw_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.class,
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.Builder.class);
          }

          // Construct using com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Raw_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw build() {
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw buildPartial() {
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw result =
                new com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) {
              return mergeFrom((com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw other) {
            if (other
                == com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance())
              return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw)
        private static final com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw();
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Utf8Raw> PARSER =
            new com.google.protobuf.AbstractParser<Utf8Raw>() {
              @java.lang.Override
              public Utf8Raw parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Utf8Raw> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Utf8Raw> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface Utf8BytesOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes)
          com.google.protobuf.MessageOrBuilder {}

      /**
       *
       *
       * <pre>
       * UTF-8 encoding.
       *
       * Sorted mode:
       * - All values are supported.
       * - Code point order is preserved.
       *
       * Distinct mode: all values are supported.
       *
       * Compatible with:
       *
       * - BigQuery `TEXT` encoding
       * - HBase `Bytes.toBytes`
       * - Java `String#getBytes(StandardCharsets.UTF_8)`
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes}
       */
      public static final class Utf8Bytes extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes)
          Utf8BytesOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "Utf8Bytes");
        }

        // Use Utf8Bytes.newBuilder() to construct.
        private Utf8Bytes(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private Utf8Bytes() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Bytes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Bytes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.class,
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.Builder.class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes other =
              (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * UTF-8 encoding.
         *
         * Sorted mode:
         * - All values are supported.
         * - Code point order is preserved.
         *
         * Distinct mode: all values are supported.
         *
         * Compatible with:
         *
         * - BigQuery `TEXT` encoding
         * - HBase `Bytes.toBytes`
         * - Java `String#getBytes(StandardCharsets.UTF_8)`
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes)
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8BytesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Bytes_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Bytes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.class,
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.Builder.class);
          }

          // Construct using
          // com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_String_Encoding_Utf8Bytes_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes build() {
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes buildPartial() {
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes result =
                new com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) {
              return mergeFrom((com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes other) {
            if (other
                == com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance())
              return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes)
        private static final com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes();
        }

        public static com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Utf8Bytes> PARSER =
            new com.google.protobuf.AbstractParser<Utf8Bytes>() {
              @java.lang.Override
              public Utf8Bytes parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Utf8Bytes> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Utf8Bytes> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int encodingCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object encoding_;

      public enum EncodingCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        @java.lang.Deprecated
        UTF8_RAW(1),
        UTF8_BYTES(2),
        ENCODING_NOT_SET(0);
        private final int value;

        private EncodingCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EncodingCase valueOf(int value) {
          return forNumber(value);
        }

        public static EncodingCase forNumber(int value) {
          switch (value) {
            case 1:
              return UTF8_RAW;
            case 2:
              return UTF8_BYTES;
            case 0:
              return ENCODING_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EncodingCase getEncodingCase() {
        return EncodingCase.forNumber(encodingCase_);
      }

      public static final int UTF8_RAW_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Deprecated: if set, converts to an empty `utf8_bytes`.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.bigtable.admin.v2.Type.String.Encoding.utf8_raw is deprecated. See
       *     google/bigtable/admin/v2/types.proto;l=102
       * @return Whether the utf8Raw field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasUtf8Raw() {
        return encodingCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: if set, converts to an empty `utf8_bytes`.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.bigtable.admin.v2.Type.String.Encoding.utf8_raw is deprecated. See
       *     google/bigtable/admin/v2/types.proto;l=102
       * @return The utf8Raw.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw getUtf8Raw() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Deprecated: if set, converts to an empty `utf8_bytes`.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8RawOrBuilder
          getUtf8RawOrBuilder() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance();
      }

      public static final int UTF8_BYTES_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Use `Utf8Bytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
       *
       * @return Whether the utf8Bytes field is set.
       */
      @java.lang.Override
      public boolean hasUtf8Bytes() {
        return encodingCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Use `Utf8Bytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
       *
       * @return The utf8Bytes.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes getUtf8Bytes() {
        if (encodingCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Use `Utf8Bytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8BytesOrBuilder
          getUtf8BytesOrBuilder() {
        if (encodingCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (encodingCase_ == 1) {
          output.writeMessage(
              1, (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_);
        }
        if (encodingCase_ == 2) {
          output.writeMessage(
              2, (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (encodingCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_);
        }
        if (encodingCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.String.Encoding)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.String.Encoding other =
            (com.google.bigtable.admin.v2.Type.String.Encoding) obj;

        if (!getEncodingCase().equals(other.getEncodingCase())) return false;
        switch (encodingCase_) {
          case 1:
            if (!getUtf8Raw().equals(other.getUtf8Raw())) return false;
            break;
          case 2:
            if (!getUtf8Bytes().equals(other.getUtf8Bytes())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (encodingCase_) {
          case 1:
            hash = (37 * hash) + UTF8_RAW_FIELD_NUMBER;
            hash = (53 * hash) + getUtf8Raw().hashCode();
            break;
          case 2:
            hash = (37 * hash) + UTF8_BYTES_FIELD_NUMBER;
            hash = (53 * hash) + getUtf8Bytes().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.bigtable.admin.v2.Type.String.Encoding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Rules used to convert to or from lower level types.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.String.Encoding}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.String.Encoding)
          com.google.bigtable.admin.v2.Type.String.EncodingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_String_Encoding_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_String_Encoding_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.String.Encoding.class,
                  com.google.bigtable.admin.v2.Type.String.Encoding.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.String.Encoding.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (utf8RawBuilder_ != null) {
            utf8RawBuilder_.clear();
          }
          if (utf8BytesBuilder_ != null) {
            utf8BytesBuilder_.clear();
          }
          encodingCase_ = 0;
          encoding_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_String_Encoding_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.String.Encoding getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.String.Encoding.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.String.Encoding build() {
          com.google.bigtable.admin.v2.Type.String.Encoding result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.String.Encoding buildPartial() {
          com.google.bigtable.admin.v2.Type.String.Encoding result =
              new com.google.bigtable.admin.v2.Type.String.Encoding(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.String.Encoding result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.String.Encoding result) {
          result.encodingCase_ = encodingCase_;
          result.encoding_ = this.encoding_;
          if (encodingCase_ == 1 && utf8RawBuilder_ != null) {
            result.encoding_ = utf8RawBuilder_.build();
          }
          if (encodingCase_ == 2 && utf8BytesBuilder_ != null) {
            result.encoding_ = utf8BytesBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.String.Encoding) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.String.Encoding) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.String.Encoding other) {
          if (other == com.google.bigtable.admin.v2.Type.String.Encoding.getDefaultInstance())
            return this;
          switch (other.getEncodingCase()) {
            case UTF8_RAW:
              {
                mergeUtf8Raw(other.getUtf8Raw());
                break;
              }
            case UTF8_BYTES:
              {
                mergeUtf8Bytes(other.getUtf8Bytes());
                break;
              }
            case ENCODING_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        internalGetUtf8RawFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        internalGetUtf8BytesFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int encodingCase_ = 0;
        private java.lang.Object encoding_;

        public EncodingCase getEncodingCase() {
          return EncodingCase.forNumber(encodingCase_);
        }

        public Builder clearEncoding() {
          encodingCase_ = 0;
          encoding_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.Builder,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8RawOrBuilder>
            utf8RawBuilder_;

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         *
         * @deprecated google.bigtable.admin.v2.Type.String.Encoding.utf8_raw is deprecated. See
         *     google/bigtable/admin/v2/types.proto;l=102
         * @return Whether the utf8Raw field is set.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public boolean hasUtf8Raw() {
          return encodingCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         *
         * @deprecated google.bigtable.admin.v2.Type.String.Encoding.utf8_raw is deprecated. See
         *     google/bigtable/admin/v2/types.proto;l=102
         * @return The utf8Raw.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw getUtf8Raw() {
          if (utf8RawBuilder_ == null) {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance();
          } else {
            if (encodingCase_ == 1) {
              return utf8RawBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setUtf8Raw(com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw value) {
          if (utf8RawBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            utf8RawBuilder_.setMessage(value);
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setUtf8Raw(
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.Builder builderForValue) {
          if (utf8RawBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            utf8RawBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder mergeUtf8Raw(
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw value) {
          if (utf8RawBuilder_ == null) {
            if (encodingCase_ == 1
                && encoding_
                    != com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.newBuilder(
                          (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 1) {
              utf8RawBuilder_.mergeFrom(value);
            } else {
              utf8RawBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder clearUtf8Raw() {
          if (utf8RawBuilder_ == null) {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            utf8RawBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.Builder
            getUtf8RawBuilder() {
          return internalGetUtf8RawFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Override
        @java.lang.Deprecated
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8RawOrBuilder
            getUtf8RawOrBuilder() {
          if ((encodingCase_ == 1) && (utf8RawBuilder_ != null)) {
            return utf8RawBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Deprecated: if set, converts to an empty `utf8_bytes`.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw utf8_raw = 1 [deprecated = true];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.Builder,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8RawOrBuilder>
            internalGetUtf8RawFieldBuilder() {
          if (utf8RawBuilder_ == null) {
            if (!(encodingCase_ == 1)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.getDefaultInstance();
            }
            utf8RawBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw,
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw.Builder,
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8RawOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Raw) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 1;
          onChanged();
          return utf8RawBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.Builder,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8BytesOrBuilder>
            utf8BytesBuilder_;

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         *
         * @return Whether the utf8Bytes field is set.
         */
        @java.lang.Override
        public boolean hasUtf8Bytes() {
          return encodingCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         *
         * @return The utf8Bytes.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes getUtf8Bytes() {
          if (utf8BytesBuilder_ == null) {
            if (encodingCase_ == 2) {
              return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance();
          } else {
            if (encodingCase_ == 2) {
              return utf8BytesBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         */
        public Builder setUtf8Bytes(
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes value) {
          if (utf8BytesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            utf8BytesBuilder_.setMessage(value);
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         */
        public Builder setUtf8Bytes(
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.Builder builderForValue) {
          if (utf8BytesBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            utf8BytesBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         */
        public Builder mergeUtf8Bytes(
            com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes value) {
          if (utf8BytesBuilder_ == null) {
            if (encodingCase_ == 2
                && encoding_
                    != com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.newBuilder(
                          (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 2) {
              utf8BytesBuilder_.mergeFrom(value);
            } else {
              utf8BytesBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         */
        public Builder clearUtf8Bytes() {
          if (utf8BytesBuilder_ == null) {
            if (encodingCase_ == 2) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 2) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            utf8BytesBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         */
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.Builder
            getUtf8BytesBuilder() {
          return internalGetUtf8BytesFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.String.Encoding.Utf8BytesOrBuilder
            getUtf8BytesOrBuilder() {
          if ((encodingCase_ == 2) && (utf8BytesBuilder_ != null)) {
            return utf8BytesBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 2) {
              return (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `Utf8Bytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes utf8_bytes = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.Builder,
                com.google.bigtable.admin.v2.Type.String.Encoding.Utf8BytesOrBuilder>
            internalGetUtf8BytesFieldBuilder() {
          if (utf8BytesBuilder_ == null) {
            if (!(encodingCase_ == 2)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.getDefaultInstance();
            }
            utf8BytesBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes,
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes.Builder,
                    com.google.bigtable.admin.v2.Type.String.Encoding.Utf8BytesOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.String.Encoding.Utf8Bytes) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 2;
          onChanged();
          return utf8BytesBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.String.Encoding)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.String.Encoding)
      private static final com.google.bigtable.admin.v2.Type.String.Encoding DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.String.Encoding();
      }

      public static com.google.bigtable.admin.v2.Type.String.Encoding getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Encoding> PARSER =
          new com.google.protobuf.AbstractParser<Encoding>() {
            @java.lang.Override
            public Encoding parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Encoding> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Encoding> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.String.Encoding getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int ENCODING_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type.String.Encoding encoding_;

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    @java.lang.Override
    public boolean hasEncoding() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.String.Encoding getEncoding() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.String.Encoding.getDefaultInstance()
          : encoding_;
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.String.EncodingOrBuilder getEncodingOrBuilder() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.String.Encoding.getDefaultInstance()
          : encoding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEncoding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEncoding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.String)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.String other =
          (com.google.bigtable.admin.v2.Type.String) obj;

      if (hasEncoding() != other.hasEncoding()) return false;
      if (hasEncoding()) {
        if (!getEncoding().equals(other.getEncoding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEncoding()) {
        hash = (37 * hash) + ENCODING_FIELD_NUMBER;
        hash = (53 * hash) + getEncoding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.String parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.String parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.String parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.String prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * String
     * Values of type `String` are stored in `Value.string_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.String}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.String)
        com.google.bigtable.admin.v2.Type.StringOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_String_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_String_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.String.class,
                com.google.bigtable.admin.v2.Type.String.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.String.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetEncodingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_String_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.String getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.String.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.String build() {
        com.google.bigtable.admin.v2.Type.String result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.String buildPartial() {
        com.google.bigtable.admin.v2.Type.String result =
            new com.google.bigtable.admin.v2.Type.String(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.String result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.encoding_ = encodingBuilder_ == null ? encoding_ : encodingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.String) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.String) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.String other) {
        if (other == com.google.bigtable.admin.v2.Type.String.getDefaultInstance()) return this;
        if (other.hasEncoding()) {
          mergeEncoding(other.getEncoding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetEncodingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type.String.Encoding encoding_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.String.Encoding,
              com.google.bigtable.admin.v2.Type.String.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.String.EncodingOrBuilder>
          encodingBuilder_;

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       *
       * @return Whether the encoding field is set.
       */
      public boolean hasEncoding() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       *
       * @return The encoding.
       */
      public com.google.bigtable.admin.v2.Type.String.Encoding getEncoding() {
        if (encodingBuilder_ == null) {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.String.Encoding.getDefaultInstance()
              : encoding_;
        } else {
          return encodingBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(com.google.bigtable.admin.v2.Type.String.Encoding value) {
        if (encodingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encoding_ = value;
        } else {
          encodingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(
          com.google.bigtable.admin.v2.Type.String.Encoding.Builder builderForValue) {
        if (encodingBuilder_ == null) {
          encoding_ = builderForValue.build();
        } else {
          encodingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       */
      public Builder mergeEncoding(com.google.bigtable.admin.v2.Type.String.Encoding value) {
        if (encodingBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && encoding_ != null
              && encoding_
                  != com.google.bigtable.admin.v2.Type.String.Encoding.getDefaultInstance()) {
            getEncodingBuilder().mergeFrom(value);
          } else {
            encoding_ = value;
          }
        } else {
          encodingBuilder_.mergeFrom(value);
        }
        if (encoding_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000001);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.String.Encoding.Builder getEncodingBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetEncodingFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.String.EncodingOrBuilder getEncodingOrBuilder() {
        if (encodingBuilder_ != null) {
          return encodingBuilder_.getMessageOrBuilder();
        } else {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.String.Encoding.getDefaultInstance()
              : encoding_;
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.String.Encoding encoding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.String.Encoding,
              com.google.bigtable.admin.v2.Type.String.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.String.EncodingOrBuilder>
          internalGetEncodingFieldBuilder() {
        if (encodingBuilder_ == null) {
          encodingBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.String.Encoding,
                  com.google.bigtable.admin.v2.Type.String.Encoding.Builder,
                  com.google.bigtable.admin.v2.Type.String.EncodingOrBuilder>(
                  getEncoding(), getParentForChildren(), isClean());
          encoding_ = null;
        }
        return encodingBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.String)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.String)
    private static final com.google.bigtable.admin.v2.Type.String DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.String();
    }

    public static com.google.bigtable.admin.v2.Type.String getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<String> PARSER =
        new com.google.protobuf.AbstractParser<String>() {
          @java.lang.Override
          public String parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<String> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<String> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.String getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface Int64OrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Int64)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    boolean hasEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    com.google.bigtable.admin.v2.Type.Int64.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder getEncodingOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Int64
   * Values of type `Int64` are stored in `Value.int_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Int64}
   */
  public static final class Int64 extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Int64)
      Int64OrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Int64");
    }

    // Use Int64.newBuilder() to construct.
    private Int64(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Int64() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Int64_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Int64_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Int64.class,
              com.google.bigtable.admin.v2.Type.Int64.Builder.class);
    }

    public interface EncodingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Int64.Encoding)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return Whether the bigEndianBytes field is set.
       */
      boolean hasBigEndianBytes();

      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return The bigEndianBytes.
       */
      com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes getBigEndianBytes();

      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       */
      com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder
          getBigEndianBytesOrBuilder();

      /**
       *
       *
       * <pre>
       * Use `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
       * </code>
       *
       * @return Whether the orderedCodeBytes field is set.
       */
      boolean hasOrderedCodeBytes();

      /**
       *
       *
       * <pre>
       * Use `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
       * </code>
       *
       * @return The orderedCodeBytes.
       */
      com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes getOrderedCodeBytes();

      /**
       *
       *
       * <pre>
       * Use `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
       * </code>
       */
      com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytesOrBuilder
          getOrderedCodeBytesOrBuilder();

      com.google.bigtable.admin.v2.Type.Int64.Encoding.EncodingCase getEncodingCase();
    }

    /**
     *
     *
     * <pre>
     * Rules used to convert to or from lower level types.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding}
     */
    public static final class Encoding extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Int64.Encoding)
        EncodingOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Encoding");
      }

      // Use Encoding.newBuilder() to construct.
      private Encoding(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Encoding() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Int64.Encoding.class,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder.class);
      }

      public interface BigEndianBytesOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Deprecated: ignored if set.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
         *
         * @deprecated google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type is
         *     deprecated. See google/bigtable/admin/v2/types.proto;l=131
         * @return Whether the bytesType field is set.
         */
        @java.lang.Deprecated
        boolean hasBytesType();

        /**
         *
         *
         * <pre>
         * Deprecated: ignored if set.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
         *
         * @deprecated google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type is
         *     deprecated. See google/bigtable/admin/v2/types.proto;l=131
         * @return The bytesType.
         */
        @java.lang.Deprecated
        com.google.bigtable.admin.v2.Type.Bytes getBytesType();

        /**
         *
         *
         * <pre>
         * Deprecated: ignored if set.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
         */
        @java.lang.Deprecated
        com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder();
      }

      /**
       *
       *
       * <pre>
       * Encodes the value as an 8-byte big-endian two's complement value.
       *
       * Sorted mode: non-negative values are supported.
       *
       * Distinct mode: all values are supported.
       *
       * Compatible with:
       *
       * - BigQuery `BINARY` encoding
       * - HBase `Bytes.toBytes`
       * - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes}
       */
      public static final class BigEndianBytes extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
          BigEndianBytesOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "BigEndianBytes");
        }

        // Use BigEndianBytes.newBuilder() to construct.
        private BigEndianBytes(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private BigEndianBytes() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.class,
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder.class);
        }

        private int bitField0_;
        public static final int BYTES_TYPE_FIELD_NUMBER = 1;
        private com.google.bigtable.admin.v2.Type.Bytes bytesType_;

        /**
         *
         *
         * <pre>
         * Deprecated: ignored if set.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
         *
         * @deprecated google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type is
         *     deprecated. See google/bigtable/admin/v2/types.proto;l=131
         * @return Whether the bytesType field is set.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public boolean hasBytesType() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Deprecated: ignored if set.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
         *
         * @deprecated google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type is
         *     deprecated. See google/bigtable/admin/v2/types.proto;l=131
         * @return The bytesType.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
          return bytesType_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
              : bytesType_;
        }

        /**
         *
         *
         * <pre>
         * Deprecated: ignored if set.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
         */
        @java.lang.Override
        @java.lang.Deprecated
        public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
          return bytesType_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
              : bytesType_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(1, getBytesType());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBytesType());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes other =
              (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) obj;

          if (hasBytesType() != other.hasBytesType()) return false;
          if (hasBytesType()) {
            if (!getBytesType().equals(other.getBytesType())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasBytesType()) {
            hash = (37 * hash) + BYTES_TYPE_FIELD_NUMBER;
            hash = (53 * hash) + getBytesType().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Encodes the value as an 8-byte big-endian two's complement value.
         *
         * Sorted mode: non-negative values are supported.
         *
         * Distinct mode: all values are supported.
         *
         * Compatible with:
         *
         * - BigQuery `BINARY` encoding
         * - HBase `Bytes.toBytes`
         * - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.class,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder.class);
          }

          // Construct using
          // com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
              internalGetBytesTypeFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            bytesType_ = null;
            if (bytesTypeBuilder_ != null) {
              bytesTypeBuilder_.dispose();
              bytesTypeBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes build() {
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes buildPartial() {
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes result =
                new com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.bytesType_ =
                  bytesTypeBuilder_ == null ? bytesType_ : bytesTypeBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) {
              return mergeFrom(
                  (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes other) {
            if (other
                == com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                    .getDefaultInstance()) return this;
            if (other.hasBytesType()) {
              mergeBytesType(other.getBytesType());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(
                          internalGetBytesTypeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.bigtable.admin.v2.Type.Bytes bytesType_;
          private com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Bytes,
                  com.google.bigtable.admin.v2.Type.Bytes.Builder,
                  com.google.bigtable.admin.v2.Type.BytesOrBuilder>
              bytesTypeBuilder_;

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           *
           * @deprecated google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type is
           *     deprecated. See google/bigtable/admin/v2/types.proto;l=131
           * @return Whether the bytesType field is set.
           */
          @java.lang.Deprecated
          public boolean hasBytesType() {
            return ((bitField0_ & 0x00000001) != 0);
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           *
           * @deprecated google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.bytes_type is
           *     deprecated. See google/bigtable/admin/v2/types.proto;l=131
           * @return The bytesType.
           */
          @java.lang.Deprecated
          public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
            if (bytesTypeBuilder_ == null) {
              return bytesType_ == null
                  ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
                  : bytesType_;
            } else {
              return bytesTypeBuilder_.getMessage();
            }
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           */
          @java.lang.Deprecated
          public Builder setBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
            if (bytesTypeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              bytesType_ = value;
            } else {
              bytesTypeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           */
          @java.lang.Deprecated
          public Builder setBytesType(
              com.google.bigtable.admin.v2.Type.Bytes.Builder builderForValue) {
            if (bytesTypeBuilder_ == null) {
              bytesType_ = builderForValue.build();
            } else {
              bytesTypeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           */
          @java.lang.Deprecated
          public Builder mergeBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
            if (bytesTypeBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && bytesType_ != null
                  && bytesType_ != com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()) {
                getBytesTypeBuilder().mergeFrom(value);
              } else {
                bytesType_ = value;
              }
            } else {
              bytesTypeBuilder_.mergeFrom(value);
            }
            if (bytesType_ != null) {
              bitField0_ |= 0x00000001;
              onChanged();
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           */
          @java.lang.Deprecated
          public Builder clearBytesType() {
            bitField0_ = (bitField0_ & ~0x00000001);
            bytesType_ = null;
            if (bytesTypeBuilder_ != null) {
              bytesTypeBuilder_.dispose();
              bytesTypeBuilder_ = null;
            }
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           */
          @java.lang.Deprecated
          public com.google.bigtable.admin.v2.Type.Bytes.Builder getBytesTypeBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return internalGetBytesTypeFieldBuilder().getBuilder();
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           */
          @java.lang.Deprecated
          public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
            if (bytesTypeBuilder_ != null) {
              return bytesTypeBuilder_.getMessageOrBuilder();
            } else {
              return bytesType_ == null
                  ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
                  : bytesType_;
            }
          }

          /**
           *
           *
           * <pre>
           * Deprecated: ignored if set.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1 [deprecated = true];</code>
           */
          private com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Bytes,
                  com.google.bigtable.admin.v2.Type.Bytes.Builder,
                  com.google.bigtable.admin.v2.Type.BytesOrBuilder>
              internalGetBytesTypeFieldBuilder() {
            if (bytesTypeBuilder_ == null) {
              bytesTypeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilder<
                      com.google.bigtable.admin.v2.Type.Bytes,
                      com.google.bigtable.admin.v2.Type.Bytes.Builder,
                      com.google.bigtable.admin.v2.Type.BytesOrBuilder>(
                      getBytesType(), getParentForChildren(), isClean());
              bytesType_ = null;
            }
            return bytesTypeBuilder_;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
        private static final com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes();
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<BigEndianBytes> PARSER =
            new com.google.protobuf.AbstractParser<BigEndianBytes>() {
              @java.lang.Override
              public BigEndianBytes parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<BigEndianBytes> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<BigEndianBytes> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface OrderedCodeBytesOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes)
          com.google.protobuf.MessageOrBuilder {}

      /**
       *
       *
       * <pre>
       * Encodes the value in a variable length binary format of up to 10 bytes.
       * Values that are closer to zero use fewer bytes.
       *
       * Sorted mode: all values are supported.
       *
       * Distinct mode: all values are supported.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes}
       */
      public static final class OrderedCodeBytes extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes)
          OrderedCodeBytesOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "OrderedCodeBytes");
        }

        // Use OrderedCodeBytes.newBuilder() to construct.
        private OrderedCodeBytes(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private OrderedCodeBytes() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_OrderedCodeBytes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_OrderedCodeBytes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.class,
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.Builder.class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes other =
              (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Encodes the value in a variable length binary format of up to 10 bytes.
         * Values that are closer to zero use fewer bytes.
         *
         * Sorted mode: all values are supported.
         *
         * Distinct mode: all values are supported.
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes)
            com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_OrderedCodeBytes_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_OrderedCodeBytes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.class,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.Builder
                        .class);
          }

          // Construct using
          // com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_OrderedCodeBytes_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes build() {
            com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes buildPartial() {
            com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes result =
                new com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) {
              return mergeFrom(
                  (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes other) {
            if (other
                == com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
                    .getDefaultInstance()) return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes)
        private static final com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes();
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<OrderedCodeBytes> PARSER =
            new com.google.protobuf.AbstractParser<OrderedCodeBytes>() {
              @java.lang.Override
              public OrderedCodeBytes parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<OrderedCodeBytes> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<OrderedCodeBytes> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int encodingCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object encoding_;

      public enum EncodingCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        BIG_ENDIAN_BYTES(1),
        ORDERED_CODE_BYTES(2),
        ENCODING_NOT_SET(0);
        private final int value;

        private EncodingCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EncodingCase valueOf(int value) {
          return forNumber(value);
        }

        public static EncodingCase forNumber(int value) {
          switch (value) {
            case 1:
              return BIG_ENDIAN_BYTES;
            case 2:
              return ORDERED_CODE_BYTES;
            case 0:
              return ENCODING_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EncodingCase getEncodingCase() {
        return EncodingCase.forNumber(encodingCase_);
      }

      public static final int BIG_ENDIAN_BYTES_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return Whether the bigEndianBytes field is set.
       */
      @java.lang.Override
      public boolean hasBigEndianBytes() {
        return encodingCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return The bigEndianBytes.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes getBigEndianBytes() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder
          getBigEndianBytesOrBuilder() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.getDefaultInstance();
      }

      public static final int ORDERED_CODE_BYTES_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Use `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
       * </code>
       *
       * @return Whether the orderedCodeBytes field is set.
       */
      @java.lang.Override
      public boolean hasOrderedCodeBytes() {
        return encodingCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Use `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
       * </code>
       *
       * @return The orderedCodeBytes.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
          getOrderedCodeBytes() {
        if (encodingCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            .getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Use `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytesOrBuilder
          getOrderedCodeBytesOrBuilder() {
        if (encodingCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            .getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (encodingCase_ == 1) {
          output.writeMessage(
              1, (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_);
        }
        if (encodingCase_ == 2) {
          output.writeMessage(
              2, (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) encoding_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (encodingCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_);
        }
        if (encodingCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) encoding_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Int64.Encoding other =
            (com.google.bigtable.admin.v2.Type.Int64.Encoding) obj;

        if (!getEncodingCase().equals(other.getEncodingCase())) return false;
        switch (encodingCase_) {
          case 1:
            if (!getBigEndianBytes().equals(other.getBigEndianBytes())) return false;
            break;
          case 2:
            if (!getOrderedCodeBytes().equals(other.getOrderedCodeBytes())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (encodingCase_) {
          case 1:
            hash = (37 * hash) + BIG_ENDIAN_BYTES_FIELD_NUMBER;
            hash = (53 * hash) + getBigEndianBytes().hashCode();
            break;
          case 2:
            hash = (37 * hash) + ORDERED_CODE_BYTES_FIELD_NUMBER;
            hash = (53 * hash) + getOrderedCodeBytes().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Int64.Encoding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Rules used to convert to or from lower level types.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Int64.Encoding)
          com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.class,
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Int64.Encoding.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (bigEndianBytesBuilder_ != null) {
            bigEndianBytesBuilder_.clear();
          }
          if (orderedCodeBytesBuilder_ != null) {
            orderedCodeBytesBuilder_.clear();
          }
          encodingCase_ = 0;
          encoding_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding build() {
          com.google.bigtable.admin.v2.Type.Int64.Encoding result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding buildPartial() {
          com.google.bigtable.admin.v2.Type.Int64.Encoding result =
              new com.google.bigtable.admin.v2.Type.Int64.Encoding(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.Int64.Encoding result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.Int64.Encoding result) {
          result.encodingCase_ = encodingCase_;
          result.encoding_ = this.encoding_;
          if (encodingCase_ == 1 && bigEndianBytesBuilder_ != null) {
            result.encoding_ = bigEndianBytesBuilder_.build();
          }
          if (encodingCase_ == 2 && orderedCodeBytesBuilder_ != null) {
            result.encoding_ = orderedCodeBytesBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Int64.Encoding) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Int64.Encoding other) {
          if (other == com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance())
            return this;
          switch (other.getEncodingCase()) {
            case BIG_ENDIAN_BYTES:
              {
                mergeBigEndianBytes(other.getBigEndianBytes());
                break;
              }
            case ORDERED_CODE_BYTES:
              {
                mergeOrderedCodeBytes(other.getOrderedCodeBytes());
                break;
              }
            case ENCODING_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        internalGetBigEndianBytesFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        internalGetOrderedCodeBytesFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int encodingCase_ = 0;
        private java.lang.Object encoding_;

        public EncodingCase getEncodingCase() {
          return EncodingCase.forNumber(encodingCase_);
        }

        public Builder clearEncoding() {
          encodingCase_ = 0;
          encoding_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder>
            bigEndianBytesBuilder_;

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         *
         * @return Whether the bigEndianBytes field is set.
         */
        @java.lang.Override
        public boolean hasBigEndianBytes() {
          return encodingCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         *
         * @return The bigEndianBytes.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes getBigEndianBytes() {
          if (bigEndianBytesBuilder_ == null) {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          } else {
            if (encodingCase_ == 1) {
              return bigEndianBytesBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder setBigEndianBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes value) {
          if (bigEndianBytesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            bigEndianBytesBuilder_.setMessage(value);
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder setBigEndianBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder
                builderForValue) {
          if (bigEndianBytesBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            bigEndianBytesBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder mergeBigEndianBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes value) {
          if (bigEndianBytesBuilder_ == null) {
            if (encodingCase_ == 1
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
                              encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 1) {
              bigEndianBytesBuilder_.mergeFrom(value);
            } else {
              bigEndianBytesBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder clearBigEndianBytes() {
          if (bigEndianBytesBuilder_ == null) {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            bigEndianBytesBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder
            getBigEndianBytesBuilder() {
          return internalGetBigEndianBytesFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder
            getBigEndianBytesOrBuilder() {
          if ((encodingCase_ == 1) && (bigEndianBytesBuilder_ != null)) {
            return bigEndianBytesBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder>
            internalGetBigEndianBytesFieldBuilder() {
          if (bigEndianBytesBuilder_ == null) {
            if (!(encodingCase_ == 1)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                      .getDefaultInstance();
            }
            bigEndianBytesBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 1;
          onChanged();
          return bigEndianBytesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.Builder,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytesOrBuilder>
            orderedCodeBytesBuilder_;

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         *
         * @return Whether the orderedCodeBytes field is set.
         */
        @java.lang.Override
        public boolean hasOrderedCodeBytes() {
          return encodingCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         *
         * @return The orderedCodeBytes.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
            getOrderedCodeBytes() {
          if (orderedCodeBytesBuilder_ == null) {
            if (encodingCase_ == 2) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          } else {
            if (encodingCase_ == 2) {
              return orderedCodeBytesBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         */
        public Builder setOrderedCodeBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes value) {
          if (orderedCodeBytesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            orderedCodeBytesBuilder_.setMessage(value);
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         */
        public Builder setOrderedCodeBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.Builder
                builderForValue) {
          if (orderedCodeBytesBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            orderedCodeBytesBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         */
        public Builder mergeOrderedCodeBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes value) {
          if (orderedCodeBytesBuilder_ == null) {
            if (encodingCase_ == 2
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes)
                              encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 2) {
              orderedCodeBytesBuilder_.mergeFrom(value);
            } else {
              orderedCodeBytesBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         */
        public Builder clearOrderedCodeBytes() {
          if (orderedCodeBytesBuilder_ == null) {
            if (encodingCase_ == 2) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 2) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            orderedCodeBytesBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         */
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.Builder
            getOrderedCodeBytesBuilder() {
          return internalGetOrderedCodeBytesFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytesOrBuilder
            getOrderedCodeBytesOrBuilder() {
          if ((encodingCase_ == 2) && (orderedCodeBytesBuilder_ != null)) {
            return orderedCodeBytesBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 2) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes ordered_code_bytes = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.Builder,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytesOrBuilder>
            internalGetOrderedCodeBytesFieldBuilder() {
          if (orderedCodeBytesBuilder_ == null) {
            if (!(encodingCase_ == 2)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes
                      .getDefaultInstance();
            }
            orderedCodeBytesBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes.Builder,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytesOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Int64.Encoding.OrderedCodeBytes) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 2;
          onChanged();
          return orderedCodeBytesBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Int64.Encoding)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Int64.Encoding)
      private static final com.google.bigtable.admin.v2.Type.Int64.Encoding DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Int64.Encoding();
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Encoding> PARSER =
          new com.google.protobuf.AbstractParser<Encoding>() {
            @java.lang.Override
            public Encoding parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Encoding> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Encoding> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int ENCODING_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type.Int64.Encoding encoding_;

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    @java.lang.Override
    public boolean hasEncoding() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64.Encoding getEncoding() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
          : encoding_;
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder getEncodingOrBuilder() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
          : encoding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEncoding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEncoding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Int64)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Int64 other = (com.google.bigtable.admin.v2.Type.Int64) obj;

      if (hasEncoding() != other.hasEncoding()) return false;
      if (hasEncoding()) {
        if (!getEncoding().equals(other.getEncoding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEncoding()) {
        hash = (37 * hash) + ENCODING_FIELD_NUMBER;
        hash = (53 * hash) + getEncoding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Int64 prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Int64
     * Values of type `Int64` are stored in `Value.int_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Int64}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Int64)
        com.google.bigtable.admin.v2.Type.Int64OrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Int64.class,
                com.google.bigtable.admin.v2.Type.Int64.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Int64.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetEncodingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64 getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64 build() {
        com.google.bigtable.admin.v2.Type.Int64 result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64 buildPartial() {
        com.google.bigtable.admin.v2.Type.Int64 result =
            new com.google.bigtable.admin.v2.Type.Int64(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Int64 result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.encoding_ = encodingBuilder_ == null ? encoding_ : encodingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Int64) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Int64) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Int64 other) {
        if (other == com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance()) return this;
        if (other.hasEncoding()) {
          mergeEncoding(other.getEncoding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetEncodingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type.Int64.Encoding encoding_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Int64.Encoding,
              com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>
          encodingBuilder_;

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       *
       * @return Whether the encoding field is set.
       */
      public boolean hasEncoding() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       *
       * @return The encoding.
       */
      public com.google.bigtable.admin.v2.Type.Int64.Encoding getEncoding() {
        if (encodingBuilder_ == null) {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
              : encoding_;
        } else {
          return encodingBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(com.google.bigtable.admin.v2.Type.Int64.Encoding value) {
        if (encodingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encoding_ = value;
        } else {
          encodingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(
          com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder builderForValue) {
        if (encodingBuilder_ == null) {
          encoding_ = builderForValue.build();
        } else {
          encodingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder mergeEncoding(com.google.bigtable.admin.v2.Type.Int64.Encoding value) {
        if (encodingBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && encoding_ != null
              && encoding_
                  != com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()) {
            getEncodingBuilder().mergeFrom(value);
          } else {
            encoding_ = value;
          }
        } else {
          encodingBuilder_.mergeFrom(value);
        }
        if (encoding_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000001);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder getEncodingBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetEncodingFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder getEncodingOrBuilder() {
        if (encodingBuilder_ != null) {
          return encodingBuilder_.getMessageOrBuilder();
        } else {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
              : encoding_;
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Int64.Encoding,
              com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>
          internalGetEncodingFieldBuilder() {
        if (encodingBuilder_ == null) {
          encodingBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Int64.Encoding,
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
                  com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>(
                  getEncoding(), getParentForChildren(), isClean());
          encoding_ = null;
        }
        return encodingBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Int64)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Int64)
    private static final com.google.bigtable.admin.v2.Type.Int64 DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Int64();
    }

    public static com.google.bigtable.admin.v2.Type.Int64 getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Int64> PARSER =
        new com.google.protobuf.AbstractParser<Int64>() {
          @java.lang.Override
          public Int64 parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Int64> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Int64> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64 getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BoolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Bool)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * bool
   * Values of type `Bool` are stored in `Value.bool_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Bool}
   */
  public static final class Bool extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Bool)
      BoolOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Bool");
    }

    // Use Bool.newBuilder() to construct.
    private Bool(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Bool() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Bool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Bool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Bool.class,
              com.google.bigtable.admin.v2.Type.Bool.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Bool)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Bool other = (com.google.bigtable.admin.v2.Type.Bool) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Bool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * bool
     * Values of type `Bool` are stored in `Value.bool_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Bool}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Bool)
        com.google.bigtable.admin.v2.Type.BoolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Bool.class,
                com.google.bigtable.admin.v2.Type.Bool.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Bool.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bool_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bool getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bool build() {
        com.google.bigtable.admin.v2.Type.Bool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bool buildPartial() {
        com.google.bigtable.admin.v2.Type.Bool result =
            new com.google.bigtable.admin.v2.Type.Bool(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Bool) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Bool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Bool other) {
        if (other == com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Bool)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Bool)
    private static final com.google.bigtable.admin.v2.Type.Bool DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Bool();
    }

    public static com.google.bigtable.admin.v2.Type.Bool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Bool> PARSER =
        new com.google.protobuf.AbstractParser<Bool>() {
          @java.lang.Override
          public Bool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Bool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Bool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface Float32OrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Float32)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Float32
   * Values of type `Float32` are stored in `Value.float_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Float32}
   */
  public static final class Float32 extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Float32)
      Float32OrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Float32");
    }

    // Use Float32.newBuilder() to construct.
    private Float32(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Float32() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Float32_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Float32_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Float32.class,
              com.google.bigtable.admin.v2.Type.Float32.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Float32)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Float32 other =
          (com.google.bigtable.admin.v2.Type.Float32) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Float32 parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Float32 prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Float32
     * Values of type `Float32` are stored in `Value.float_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Float32}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Float32)
        com.google.bigtable.admin.v2.Type.Float32OrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Float32_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Float32_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Float32.class,
                com.google.bigtable.admin.v2.Type.Float32.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Float32.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Float32_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Float32 getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Float32 build() {
        com.google.bigtable.admin.v2.Type.Float32 result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Float32 buildPartial() {
        com.google.bigtable.admin.v2.Type.Float32 result =
            new com.google.bigtable.admin.v2.Type.Float32(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Float32) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Float32) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Float32 other) {
        if (other == com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Float32)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Float32)
    private static final com.google.bigtable.admin.v2.Type.Float32 DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Float32();
    }

    public static com.google.bigtable.admin.v2.Type.Float32 getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Float32> PARSER =
        new com.google.protobuf.AbstractParser<Float32>() {
          @java.lang.Override
          public Float32 parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Float32> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Float32> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Float32 getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface Float64OrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Float64)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Float64
   * Values of type `Float64` are stored in `Value.float_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Float64}
   */
  public static final class Float64 extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Float64)
      Float64OrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Float64");
    }

    // Use Float64.newBuilder() to construct.
    private Float64(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Float64() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Float64_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Float64_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Float64.class,
              com.google.bigtable.admin.v2.Type.Float64.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Float64)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Float64 other =
          (com.google.bigtable.admin.v2.Type.Float64) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Float64 parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Float64 prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Float64
     * Values of type `Float64` are stored in `Value.float_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Float64}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Float64)
        com.google.bigtable.admin.v2.Type.Float64OrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Float64_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Float64_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Float64.class,
                com.google.bigtable.admin.v2.Type.Float64.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Float64.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Float64_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Float64 getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Float64 build() {
        com.google.bigtable.admin.v2.Type.Float64 result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Float64 buildPartial() {
        com.google.bigtable.admin.v2.Type.Float64 result =
            new com.google.bigtable.admin.v2.Type.Float64(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Float64) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Float64) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Float64 other) {
        if (other == com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Float64)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Float64)
    private static final com.google.bigtable.admin.v2.Type.Float64 DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Float64();
    }

    public static com.google.bigtable.admin.v2.Type.Float64 getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Float64> PARSER =
        new com.google.protobuf.AbstractParser<Float64>() {
          @java.lang.Override
          public Float64 parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Float64> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Float64> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Float64 getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TimestampOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Timestamp)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    boolean hasEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    com.google.bigtable.admin.v2.Type.Timestamp.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.Timestamp.EncodingOrBuilder getEncodingOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Timestamp
   * Values of type `Timestamp` are stored in `Value.timestamp_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Timestamp}
   */
  public static final class Timestamp extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Timestamp)
      TimestampOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Timestamp");
    }

    // Use Timestamp.newBuilder() to construct.
    private Timestamp(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Timestamp() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Timestamp_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Timestamp_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Timestamp.class,
              com.google.bigtable.admin.v2.Type.Timestamp.Builder.class);
    }

    public interface EncodingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Timestamp.Encoding)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Encodes the number of microseconds since the Unix epoch using the
       * given `Int64` encoding. Values must be microsecond-aligned.
       *
       * Compatible with:
       *
       * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
       *
       * @return Whether the unixMicrosInt64 field is set.
       */
      boolean hasUnixMicrosInt64();

      /**
       *
       *
       * <pre>
       * Encodes the number of microseconds since the Unix epoch using the
       * given `Int64` encoding. Values must be microsecond-aligned.
       *
       * Compatible with:
       *
       * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
       *
       * @return The unixMicrosInt64.
       */
      com.google.bigtable.admin.v2.Type.Int64.Encoding getUnixMicrosInt64();

      /**
       *
       *
       * <pre>
       * Encodes the number of microseconds since the Unix epoch using the
       * given `Int64` encoding. Values must be microsecond-aligned.
       *
       * Compatible with:
       *
       * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
       */
      com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder getUnixMicrosInt64OrBuilder();

      com.google.bigtable.admin.v2.Type.Timestamp.Encoding.EncodingCase getEncodingCase();
    }

    /**
     *
     *
     * <pre>
     * Rules used to convert to or from lower level types.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Timestamp.Encoding}
     */
    public static final class Encoding extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Timestamp.Encoding)
        EncodingOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Encoding");
      }

      // Use Encoding.newBuilder() to construct.
      private Encoding(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Encoding() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Timestamp_Encoding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Timestamp_Encoding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Timestamp.Encoding.class,
                com.google.bigtable.admin.v2.Type.Timestamp.Encoding.Builder.class);
      }

      private int encodingCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object encoding_;

      public enum EncodingCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        UNIX_MICROS_INT64(1),
        ENCODING_NOT_SET(0);
        private final int value;

        private EncodingCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EncodingCase valueOf(int value) {
          return forNumber(value);
        }

        public static EncodingCase forNumber(int value) {
          switch (value) {
            case 1:
              return UNIX_MICROS_INT64;
            case 0:
              return ENCODING_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EncodingCase getEncodingCase() {
        return EncodingCase.forNumber(encodingCase_);
      }

      public static final int UNIX_MICROS_INT64_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Encodes the number of microseconds since the Unix epoch using the
       * given `Int64` encoding. Values must be microsecond-aligned.
       *
       * Compatible with:
       *
       * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
       *
       * @return Whether the unixMicrosInt64 field is set.
       */
      @java.lang.Override
      public boolean hasUnixMicrosInt64() {
        return encodingCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Encodes the number of microseconds since the Unix epoch using the
       * given `Int64` encoding. Values must be microsecond-aligned.
       *
       * Compatible with:
       *
       * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
       *
       * @return The unixMicrosInt64.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding getUnixMicrosInt64() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Encodes the number of microseconds since the Unix epoch using the
       * given `Int64` encoding. Values must be microsecond-aligned.
       *
       * Compatible with:
       *
       * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder
          getUnixMicrosInt64OrBuilder() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (encodingCase_ == 1) {
          output.writeMessage(1, (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (encodingCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Timestamp.Encoding)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Timestamp.Encoding other =
            (com.google.bigtable.admin.v2.Type.Timestamp.Encoding) obj;

        if (!getEncodingCase().equals(other.getEncodingCase())) return false;
        switch (encodingCase_) {
          case 1:
            if (!getUnixMicrosInt64().equals(other.getUnixMicrosInt64())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (encodingCase_) {
          case 1:
            hash = (37 * hash) + UNIX_MICROS_INT64_FIELD_NUMBER;
            hash = (53 * hash) + getUnixMicrosInt64().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.bigtable.admin.v2.Type.Timestamp.Encoding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Rules used to convert to or from lower level types.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Timestamp.Encoding}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Timestamp.Encoding)
          com.google.bigtable.admin.v2.Type.Timestamp.EncodingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Timestamp_Encoding_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Timestamp_Encoding_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Timestamp.Encoding.class,
                  com.google.bigtable.admin.v2.Type.Timestamp.Encoding.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Timestamp.Encoding.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (unixMicrosInt64Builder_ != null) {
            unixMicrosInt64Builder_.clear();
          }
          encodingCase_ = 0;
          encoding_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Timestamp_Encoding_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Timestamp.Encoding getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Timestamp.Encoding.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Timestamp.Encoding build() {
          com.google.bigtable.admin.v2.Type.Timestamp.Encoding result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Timestamp.Encoding buildPartial() {
          com.google.bigtable.admin.v2.Type.Timestamp.Encoding result =
              new com.google.bigtable.admin.v2.Type.Timestamp.Encoding(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.Timestamp.Encoding result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.bigtable.admin.v2.Type.Timestamp.Encoding result) {
          result.encodingCase_ = encodingCase_;
          result.encoding_ = this.encoding_;
          if (encodingCase_ == 1 && unixMicrosInt64Builder_ != null) {
            result.encoding_ = unixMicrosInt64Builder_.build();
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Timestamp.Encoding) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Timestamp.Encoding) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Timestamp.Encoding other) {
          if (other == com.google.bigtable.admin.v2.Type.Timestamp.Encoding.getDefaultInstance())
            return this;
          switch (other.getEncodingCase()) {
            case UNIX_MICROS_INT64:
              {
                mergeUnixMicrosInt64(other.getUnixMicrosInt64());
                break;
              }
            case ENCODING_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        internalGetUnixMicrosInt64FieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 1;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int encodingCase_ = 0;
        private java.lang.Object encoding_;

        public EncodingCase getEncodingCase() {
          return EncodingCase.forNumber(encodingCase_);
        }

        public Builder clearEncoding() {
          encodingCase_ = 0;
          encoding_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Int64.Encoding,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
                com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>
            unixMicrosInt64Builder_;

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         *
         * @return Whether the unixMicrosInt64 field is set.
         */
        @java.lang.Override
        public boolean hasUnixMicrosInt64() {
          return encodingCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         *
         * @return The unixMicrosInt64.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding getUnixMicrosInt64() {
          if (unixMicrosInt64Builder_ == null) {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
          } else {
            if (encodingCase_ == 1) {
              return unixMicrosInt64Builder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         */
        public Builder setUnixMicrosInt64(com.google.bigtable.admin.v2.Type.Int64.Encoding value) {
          if (unixMicrosInt64Builder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            unixMicrosInt64Builder_.setMessage(value);
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         */
        public Builder setUnixMicrosInt64(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder builderForValue) {
          if (unixMicrosInt64Builder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            unixMicrosInt64Builder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         */
        public Builder mergeUnixMicrosInt64(
            com.google.bigtable.admin.v2.Type.Int64.Encoding value) {
          if (unixMicrosInt64Builder_ == null) {
            if (encodingCase_ == 1
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 1) {
              unixMicrosInt64Builder_.mergeFrom(value);
            } else {
              unixMicrosInt64Builder_.setMessage(value);
            }
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         */
        public Builder clearUnixMicrosInt64() {
          if (unixMicrosInt64Builder_ == null) {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            unixMicrosInt64Builder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         */
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder
            getUnixMicrosInt64Builder() {
          return internalGetUnixMicrosInt64FieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder
            getUnixMicrosInt64OrBuilder() {
          if ((encodingCase_ == 1) && (unixMicrosInt64Builder_ != null)) {
            return unixMicrosInt64Builder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Encodes the number of microseconds since the Unix epoch using the
         * given `Int64` encoding. Values must be microsecond-aligned.
         *
         * Compatible with:
         *
         * - Java `Instant.truncatedTo()` with `ChronoUnit.MICROS`
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding unix_micros_int64 = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Int64.Encoding,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
                com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>
            internalGetUnixMicrosInt64FieldBuilder() {
          if (unixMicrosInt64Builder_ == null) {
            if (!(encodingCase_ == 1)) {
              encoding_ = com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
            }
            unixMicrosInt64Builder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.Int64.Encoding,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
                    com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Int64.Encoding) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 1;
          onChanged();
          return unixMicrosInt64Builder_;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Timestamp.Encoding)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Timestamp.Encoding)
      private static final com.google.bigtable.admin.v2.Type.Timestamp.Encoding DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Timestamp.Encoding();
      }

      public static com.google.bigtable.admin.v2.Type.Timestamp.Encoding getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Encoding> PARSER =
          new com.google.protobuf.AbstractParser<Encoding>() {
            @java.lang.Override
            public Encoding parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Encoding> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Encoding> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Timestamp.Encoding getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int ENCODING_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding_;

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    @java.lang.Override
    public boolean hasEncoding() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Timestamp.Encoding getEncoding() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Timestamp.Encoding.getDefaultInstance()
          : encoding_;
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Timestamp.EncodingOrBuilder getEncodingOrBuilder() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Timestamp.Encoding.getDefaultInstance()
          : encoding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEncoding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEncoding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Timestamp)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Timestamp other =
          (com.google.bigtable.admin.v2.Type.Timestamp) obj;

      if (hasEncoding() != other.hasEncoding()) return false;
      if (hasEncoding()) {
        if (!getEncoding().equals(other.getEncoding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEncoding()) {
        hash = (37 * hash) + ENCODING_FIELD_NUMBER;
        hash = (53 * hash) + getEncoding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Timestamp prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * Values of type `Timestamp` are stored in `Value.timestamp_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Timestamp}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Timestamp)
        com.google.bigtable.admin.v2.Type.TimestampOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Timestamp_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Timestamp_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Timestamp.class,
                com.google.bigtable.admin.v2.Type.Timestamp.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Timestamp.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetEncodingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Timestamp_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Timestamp getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Timestamp build() {
        com.google.bigtable.admin.v2.Type.Timestamp result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Timestamp buildPartial() {
        com.google.bigtable.admin.v2.Type.Timestamp result =
            new com.google.bigtable.admin.v2.Type.Timestamp(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Timestamp result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.encoding_ = encodingBuilder_ == null ? encoding_ : encodingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Timestamp) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Timestamp) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Timestamp other) {
        if (other == com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance()) return this;
        if (other.hasEncoding()) {
          mergeEncoding(other.getEncoding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetEncodingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Timestamp.Encoding,
              com.google.bigtable.admin.v2.Type.Timestamp.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Timestamp.EncodingOrBuilder>
          encodingBuilder_;

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       *
       * @return Whether the encoding field is set.
       */
      public boolean hasEncoding() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       *
       * @return The encoding.
       */
      public com.google.bigtable.admin.v2.Type.Timestamp.Encoding getEncoding() {
        if (encodingBuilder_ == null) {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Timestamp.Encoding.getDefaultInstance()
              : encoding_;
        } else {
          return encodingBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(com.google.bigtable.admin.v2.Type.Timestamp.Encoding value) {
        if (encodingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encoding_ = value;
        } else {
          encodingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(
          com.google.bigtable.admin.v2.Type.Timestamp.Encoding.Builder builderForValue) {
        if (encodingBuilder_ == null) {
          encoding_ = builderForValue.build();
        } else {
          encodingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       */
      public Builder mergeEncoding(com.google.bigtable.admin.v2.Type.Timestamp.Encoding value) {
        if (encodingBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && encoding_ != null
              && encoding_
                  != com.google.bigtable.admin.v2.Type.Timestamp.Encoding.getDefaultInstance()) {
            getEncodingBuilder().mergeFrom(value);
          } else {
            encoding_ = value;
          }
        } else {
          encodingBuilder_.mergeFrom(value);
        }
        if (encoding_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000001);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Timestamp.Encoding.Builder getEncodingBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetEncodingFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Timestamp.EncodingOrBuilder getEncodingOrBuilder() {
        if (encodingBuilder_ != null) {
          return encodingBuilder_.getMessageOrBuilder();
        } else {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Timestamp.Encoding.getDefaultInstance()
              : encoding_;
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Timestamp.Encoding encoding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Timestamp.Encoding,
              com.google.bigtable.admin.v2.Type.Timestamp.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Timestamp.EncodingOrBuilder>
          internalGetEncodingFieldBuilder() {
        if (encodingBuilder_ == null) {
          encodingBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Timestamp.Encoding,
                  com.google.bigtable.admin.v2.Type.Timestamp.Encoding.Builder,
                  com.google.bigtable.admin.v2.Type.Timestamp.EncodingOrBuilder>(
                  getEncoding(), getParentForChildren(), isClean());
          encoding_ = null;
        }
        return encodingBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Timestamp)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Timestamp)
    private static final com.google.bigtable.admin.v2.Type.Timestamp DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Timestamp();
    }

    public static com.google.bigtable.admin.v2.Type.Timestamp getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Timestamp> PARSER =
        new com.google.protobuf.AbstractParser<Timestamp>() {
          @java.lang.Override
          public Timestamp parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Timestamp> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Timestamp> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Timestamp getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Date)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Date
   * Values of type `Date` are stored in `Value.date_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Date}
   */
  public static final class Date extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Date)
      DateOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Date");
    }

    // Use Date.newBuilder() to construct.
    private Date(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Date() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Date_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Date_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Date.class,
              com.google.bigtable.admin.v2.Type.Date.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Date)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Date other = (com.google.bigtable.admin.v2.Type.Date) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Date parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Date prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Date
     * Values of type `Date` are stored in `Value.date_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Date}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Date)
        com.google.bigtable.admin.v2.Type.DateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Date_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Date_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Date.class,
                com.google.bigtable.admin.v2.Type.Date.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Date.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Date_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Date getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Date.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Date build() {
        com.google.bigtable.admin.v2.Type.Date result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Date buildPartial() {
        com.google.bigtable.admin.v2.Type.Date result =
            new com.google.bigtable.admin.v2.Type.Date(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Date) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Date) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Date other) {
        if (other == com.google.bigtable.admin.v2.Type.Date.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Date)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Date)
    private static final com.google.bigtable.admin.v2.Type.Date DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Date();
    }

    public static com.google.bigtable.admin.v2.Type.Date getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Date> PARSER =
        new com.google.protobuf.AbstractParser<Date>() {
          @java.lang.Override
          public Date parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Date> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Date> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Date getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StructOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Struct)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    java.util.List<com.google.bigtable.admin.v2.Type.Struct.Field> getFieldsList();

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.Struct.Field getFields(int index);

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    int getFieldsCount();

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    java.util.List<? extends com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder>
        getFieldsOrBuilderList();

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder getFieldsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
     *
     * @return Whether the encoding field is set.
     */
    boolean hasEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
     *
     * @return The encoding.
     */
    com.google.bigtable.admin.v2.Type.Struct.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
     */
    com.google.bigtable.admin.v2.Type.Struct.EncodingOrBuilder getEncodingOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A structured data value, consisting of fields which map to dynamically
   * typed values.
   * Values of type `Struct` are stored in `Value.array_value` where entries are
   * in the same order and number as `field_types`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Struct}
   */
  public static final class Struct extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Struct)
      StructOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Struct");
    }

    // Use Struct.newBuilder() to construct.
    private Struct(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Struct() {
      fields_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Struct_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Struct_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Struct.class,
              com.google.bigtable.admin.v2.Type.Struct.Builder.class);
    }

    public interface FieldOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Struct.Field)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The field name (optional). Fields without a `field_name` are considered
       * anonymous and cannot be referenced by name.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @return The fieldName.
       */
      java.lang.String getFieldName();

      /**
       *
       *
       * <pre>
       * The field name (optional). Fields without a `field_name` are considered
       * anonymous and cannot be referenced by name.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @return The bytes for fieldName.
       */
      com.google.protobuf.ByteString getFieldNameBytes();

      /**
       *
       *
       * <pre>
       * The type of values in this field.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type type = 2;</code>
       *
       * @return Whether the type field is set.
       */
      boolean hasType();

      /**
       *
       *
       * <pre>
       * The type of values in this field.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type type = 2;</code>
       *
       * @return The type.
       */
      com.google.bigtable.admin.v2.Type getType();

      /**
       *
       *
       * <pre>
       * The type of values in this field.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type type = 2;</code>
       */
      com.google.bigtable.admin.v2.TypeOrBuilder getTypeOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * A struct field and its type.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Field}
     */
    public static final class Field extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Struct.Field)
        FieldOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Field");
      }

      // Use Field.newBuilder() to construct.
      private Field(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Field() {
        fieldName_ = "";
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Struct_Field_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Struct_Field_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Struct.Field.class,
                com.google.bigtable.admin.v2.Type.Struct.Field.Builder.class);
      }

      private int bitField0_;
      public static final int FIELD_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object fieldName_ = "";

      /**
       *
       *
       * <pre>
       * The field name (optional). Fields without a `field_name` are considered
       * anonymous and cannot be referenced by name.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @return The fieldName.
       */
      @java.lang.Override
      public java.lang.String getFieldName() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldName_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The field name (optional). Fields without a `field_name` are considered
       * anonymous and cannot be referenced by name.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @return The bytes for fieldName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFieldNameBytes() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TYPE_FIELD_NUMBER = 2;
      private com.google.bigtable.admin.v2.Type type_;

      /**
       *
       *
       * <pre>
       * The type of values in this field.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type type = 2;</code>
       *
       * @return Whether the type field is set.
       */
      @java.lang.Override
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The type of values in this field.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type type = 2;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type getType() {
        return type_ == null ? com.google.bigtable.admin.v2.Type.getDefaultInstance() : type_;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this field.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type type = 2;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.TypeOrBuilder getTypeOrBuilder() {
        return type_ == null ? com.google.bigtable.admin.v2.Type.getDefaultInstance() : type_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessage.isStringEmpty(fieldName_)) {
          com.google.protobuf.GeneratedMessage.writeString(output, 1, fieldName_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getType());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessage.isStringEmpty(fieldName_)) {
          size += com.google.protobuf.GeneratedMessage.computeStringSize(1, fieldName_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getType());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Struct.Field)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Struct.Field other =
            (com.google.bigtable.admin.v2.Type.Struct.Field) obj;

        if (!getFieldName().equals(other.getFieldName())) return false;
        if (hasType() != other.hasType()) return false;
        if (hasType()) {
          if (!getType().equals(other.getType())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getFieldName().hashCode();
        if (hasType()) {
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getType().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Struct.Field prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * A struct field and its type.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Field}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Struct.Field)
          com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Field_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Field_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Struct.Field.class,
                  com.google.bigtable.admin.v2.Type.Struct.Field.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Struct.Field.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
            internalGetTypeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          fieldName_ = "";
          type_ = null;
          if (typeBuilder_ != null) {
            typeBuilder_.dispose();
            typeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Field_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Field getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Struct.Field.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Field build() {
          com.google.bigtable.admin.v2.Type.Struct.Field result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Field buildPartial() {
          com.google.bigtable.admin.v2.Type.Struct.Field result =
              new com.google.bigtable.admin.v2.Type.Struct.Field(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.Struct.Field result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.fieldName_ = fieldName_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.type_ = typeBuilder_ == null ? type_ : typeBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Struct.Field) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Struct.Field) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Struct.Field other) {
          if (other == com.google.bigtable.admin.v2.Type.Struct.Field.getDefaultInstance())
            return this;
          if (!other.getFieldName().isEmpty()) {
            fieldName_ = other.fieldName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasType()) {
            mergeType(other.getType());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    fieldName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        internalGetTypeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object fieldName_ = "";

        /**
         *
         *
         * <pre>
         * The field name (optional). Fields without a `field_name` are considered
         * anonymous and cannot be referenced by name.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        public java.lang.String getFieldName() {
          java.lang.Object ref = fieldName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The field name (optional). Fields without a `field_name` are considered
         * anonymous and cannot be referenced by name.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        public com.google.protobuf.ByteString getFieldNameBytes() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The field name (optional). Fields without a `field_name` are considered
         * anonymous and cannot be referenced by name.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @param value The fieldName to set.
         * @return This builder for chaining.
         */
        public Builder setFieldName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          fieldName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The field name (optional). Fields without a `field_name` are considered
         * anonymous and cannot be referenced by name.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFieldName() {
          fieldName_ = getDefaultInstance().getFieldName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The field name (optional). Fields without a `field_name` are considered
         * anonymous and cannot be referenced by name.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @param value The bytes for fieldName to set.
         * @return This builder for chaining.
         */
        public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          fieldName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.bigtable.admin.v2.Type type_;
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type,
                com.google.bigtable.admin.v2.Type.Builder,
                com.google.bigtable.admin.v2.TypeOrBuilder>
            typeBuilder_;

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         *
         * @return Whether the type field is set.
         */
        public boolean hasType() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         *
         * @return The type.
         */
        public com.google.bigtable.admin.v2.Type getType() {
          if (typeBuilder_ == null) {
            return type_ == null ? com.google.bigtable.admin.v2.Type.getDefaultInstance() : type_;
          } else {
            return typeBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         */
        public Builder setType(com.google.bigtable.admin.v2.Type value) {
          if (typeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
          } else {
            typeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         */
        public Builder setType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
          if (typeBuilder_ == null) {
            type_ = builderForValue.build();
          } else {
            typeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         */
        public Builder mergeType(com.google.bigtable.admin.v2.Type value) {
          if (typeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && type_ != null
                && type_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
              getTypeBuilder().mergeFrom(value);
            } else {
              type_ = value;
            }
          } else {
            typeBuilder_.mergeFrom(value);
          }
          if (type_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000002);
          type_ = null;
          if (typeBuilder_ != null) {
            typeBuilder_.dispose();
            typeBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         */
        public com.google.bigtable.admin.v2.Type.Builder getTypeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return internalGetTypeFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         */
        public com.google.bigtable.admin.v2.TypeOrBuilder getTypeOrBuilder() {
          if (typeBuilder_ != null) {
            return typeBuilder_.getMessageOrBuilder();
          } else {
            return type_ == null ? com.google.bigtable.admin.v2.Type.getDefaultInstance() : type_;
          }
        }

        /**
         *
         *
         * <pre>
         * The type of values in this field.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type type = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type,
                com.google.bigtable.admin.v2.Type.Builder,
                com.google.bigtable.admin.v2.TypeOrBuilder>
            internalGetTypeFieldBuilder() {
          if (typeBuilder_ == null) {
            typeBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type,
                    com.google.bigtable.admin.v2.Type.Builder,
                    com.google.bigtable.admin.v2.TypeOrBuilder>(
                    getType(), getParentForChildren(), isClean());
            type_ = null;
          }
          return typeBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Struct.Field)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Struct.Field)
      private static final com.google.bigtable.admin.v2.Type.Struct.Field DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Struct.Field();
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Field getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Field> PARSER =
          new com.google.protobuf.AbstractParser<Field>() {
            @java.lang.Override
            public Field parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Field> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Field> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Field getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface EncodingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Struct.Encoding)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Use `Singleton` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
       *
       * @return Whether the singleton field is set.
       */
      boolean hasSingleton();

      /**
       *
       *
       * <pre>
       * Use `Singleton` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
       *
       * @return The singleton.
       */
      com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton getSingleton();

      /**
       *
       *
       * <pre>
       * Use `Singleton` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
       */
      com.google.bigtable.admin.v2.Type.Struct.Encoding.SingletonOrBuilder getSingletonOrBuilder();

      /**
       *
       *
       * <pre>
       * Use `DelimitedBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
       * </code>
       *
       * @return Whether the delimitedBytes field is set.
       */
      boolean hasDelimitedBytes();

      /**
       *
       *
       * <pre>
       * Use `DelimitedBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
       * </code>
       *
       * @return The delimitedBytes.
       */
      com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes getDelimitedBytes();

      /**
       *
       *
       * <pre>
       * Use `DelimitedBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
       * </code>
       */
      com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytesOrBuilder
          getDelimitedBytesOrBuilder();

      /**
       *
       *
       * <pre>
       * User `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
       * </code>
       *
       * @return Whether the orderedCodeBytes field is set.
       */
      boolean hasOrderedCodeBytes();

      /**
       *
       *
       * <pre>
       * User `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
       * </code>
       *
       * @return The orderedCodeBytes.
       */
      com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes getOrderedCodeBytes();

      /**
       *
       *
       * <pre>
       * User `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
       * </code>
       */
      com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytesOrBuilder
          getOrderedCodeBytesOrBuilder();

      com.google.bigtable.admin.v2.Type.Struct.Encoding.EncodingCase getEncodingCase();
    }

    /**
     *
     *
     * <pre>
     * Rules used to convert to or from lower level types.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding}
     */
    public static final class Encoding extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Struct.Encoding)
        EncodingOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Encoding");
      }

      // Use Encoding.newBuilder() to construct.
      private Encoding(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Encoding() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Struct.Encoding.class,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.Builder.class);
      }

      public interface SingletonOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Struct.Encoding.Singleton)
          com.google.protobuf.MessageOrBuilder {}

      /**
       *
       *
       * <pre>
       * Uses the encoding of `fields[0].type` as-is.
       * Only valid if `fields.size == 1`.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding.Singleton}
       */
      public static final class Singleton extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Struct.Encoding.Singleton)
          SingletonOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "Singleton");
        }

        // Use Singleton.newBuilder() to construct.
        private Singleton(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private Singleton() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_Singleton_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_Singleton_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.class,
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.Builder.class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton other =
              (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Uses the encoding of `fields[0].type` as-is.
         * Only valid if `fields.size == 1`.
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding.Singleton}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Struct.Encoding.Singleton)
            com.google.bigtable.admin.v2.Type.Struct.Encoding.SingletonOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_Singleton_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_Singleton_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.class,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.Builder.class);
          }

          // Construct using
          // com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_Singleton_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton build() {
            com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton buildPartial() {
            com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton result =
                new com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) {
              return mergeFrom((com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton other) {
            if (other
                == com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance())
              return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Struct.Encoding.Singleton)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Struct.Encoding.Singleton)
        private static final com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton();
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Singleton> PARSER =
            new com.google.protobuf.AbstractParser<Singleton>() {
              @java.lang.Override
              public Singleton parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Singleton> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Singleton> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface DelimitedBytesOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Byte sequence used to delimit concatenated fields. The delimiter must
         * contain at least 1 character and at most 50 characters.
         * </pre>
         *
         * <code>bytes delimiter = 1;</code>
         *
         * @return The delimiter.
         */
        com.google.protobuf.ByteString getDelimiter();
      }

      /**
       *
       *
       * <pre>
       * Fields are encoded independently and concatenated with a configurable
       * `delimiter` in between.
       *
       * A struct with no fields defined is encoded as a single `delimiter`.
       *
       * Sorted mode:
       *
       * - Fields are encoded in sorted mode.
       * - Encoded field values must not contain any bytes &lt;= `delimiter[0]`
       * - Element-wise order is preserved: `A &lt; B` if `A[0] &lt; B[0]`, or if
       * `A[0] == B[0] &amp;&amp; A[1] &lt; B[1]`, etc. Strict prefixes sort first.
       *
       * Distinct mode:
       *
       * - Fields are encoded in distinct mode.
       * - Encoded field values must not contain `delimiter[0]`.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes}
       */
      public static final class DelimitedBytes extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes)
          DelimitedBytesOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "DelimitedBytes");
        }

        // Use DelimitedBytes.newBuilder() to construct.
        private DelimitedBytes(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private DelimitedBytes() {
          delimiter_ = com.google.protobuf.ByteString.EMPTY;
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_DelimitedBytes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_DelimitedBytes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.class,
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.Builder.class);
        }

        public static final int DELIMITER_FIELD_NUMBER = 1;
        private com.google.protobuf.ByteString delimiter_ = com.google.protobuf.ByteString.EMPTY;

        /**
         *
         *
         * <pre>
         * Byte sequence used to delimit concatenated fields. The delimiter must
         * contain at least 1 character and at most 50 characters.
         * </pre>
         *
         * <code>bytes delimiter = 1;</code>
         *
         * @return The delimiter.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDelimiter() {
          return delimiter_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!delimiter_.isEmpty()) {
            output.writeBytes(1, delimiter_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!delimiter_.isEmpty()) {
            size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, delimiter_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes other =
              (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) obj;

          if (!getDelimiter().equals(other.getDelimiter())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + DELIMITER_FIELD_NUMBER;
          hash = (53 * hash) + getDelimiter().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Fields are encoded independently and concatenated with a configurable
         * `delimiter` in between.
         *
         * A struct with no fields defined is encoded as a single `delimiter`.
         *
         * Sorted mode:
         *
         * - Fields are encoded in sorted mode.
         * - Encoded field values must not contain any bytes &lt;= `delimiter[0]`
         * - Element-wise order is preserved: `A &lt; B` if `A[0] &lt; B[0]`, or if
         * `A[0] == B[0] &amp;&amp; A[1] &lt; B[1]`, etc. Strict prefixes sort first.
         *
         * Distinct mode:
         *
         * - Fields are encoded in distinct mode.
         * - Encoded field values must not contain `delimiter[0]`.
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes)
            com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_DelimitedBytes_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_DelimitedBytes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.class,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.Builder.class);
          }

          // Construct using
          // com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            delimiter_ = com.google.protobuf.ByteString.EMPTY;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_DelimitedBytes_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes build() {
            com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes buildPartial() {
            com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes result =
                new com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.delimiter_ = delimiter_;
            }
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) {
              return mergeFrom(
                  (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes other) {
            if (other
                == com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
                    .getDefaultInstance()) return this;
            if (!other.getDelimiter().isEmpty()) {
              setDelimiter(other.getDelimiter());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      delimiter_ = input.readBytes();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.ByteString delimiter_ = com.google.protobuf.ByteString.EMPTY;

          /**
           *
           *
           * <pre>
           * Byte sequence used to delimit concatenated fields. The delimiter must
           * contain at least 1 character and at most 50 characters.
           * </pre>
           *
           * <code>bytes delimiter = 1;</code>
           *
           * @return The delimiter.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getDelimiter() {
            return delimiter_;
          }

          /**
           *
           *
           * <pre>
           * Byte sequence used to delimit concatenated fields. The delimiter must
           * contain at least 1 character and at most 50 characters.
           * </pre>
           *
           * <code>bytes delimiter = 1;</code>
           *
           * @param value The delimiter to set.
           * @return This builder for chaining.
           */
          public Builder setDelimiter(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            delimiter_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Byte sequence used to delimit concatenated fields. The delimiter must
           * contain at least 1 character and at most 50 characters.
           * </pre>
           *
           * <code>bytes delimiter = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDelimiter() {
            bitField0_ = (bitField0_ & ~0x00000001);
            delimiter_ = getDefaultInstance().getDelimiter();
            onChanged();
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes)
        private static final com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes();
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DelimitedBytes> PARSER =
            new com.google.protobuf.AbstractParser<DelimitedBytes>() {
              @java.lang.Override
              public DelimitedBytes parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DelimitedBytes> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DelimitedBytes> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface OrderedCodeBytesOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes)
          com.google.protobuf.MessageOrBuilder {}

      /**
       *
       *
       * <pre>
       * Fields are encoded independently and concatenated with the fixed byte
       * pair {0x00, 0x01} in between.
       *
       * Any null (0x00) byte in an encoded field is replaced by the fixed byte
       * pair {0x00, 0xFF}.
       *
       * Fields that encode to the empty string "" have special handling:
       *
       * - If *every* field encodes to "", or if the STRUCT has no fields
       * defined, then the STRUCT is encoded as the fixed byte pair
       * {0x00, 0x00}.
       * - Otherwise, the STRUCT only encodes until the last non-empty field,
       * omitting any trailing empty fields. Any empty fields that aren't
       * omitted are replaced with the fixed byte pair {0x00, 0x00}.
       *
       * Examples:
       *
       * - STRUCT()             -&gt; "&#92;00&#92;00"
       * - STRUCT("")           -&gt; "&#92;00&#92;00"
       * - STRUCT("", "")       -&gt; "&#92;00&#92;00"
       * - STRUCT("", "B")      -&gt; "&#92;00&#92;00" + "&#92;00&#92;01" + "B"
       * - STRUCT("A", "")      -&gt; "A"
       * - STRUCT("", "B", "")  -&gt; "&#92;00&#92;00" + "&#92;00&#92;01" + "B"
       * - STRUCT("A", "", "C") -&gt; "A" + "&#92;00&#92;01" + "&#92;00&#92;00" + "&#92;00&#92;01" + "C"
       *
       *
       * Since null bytes are always escaped, this encoding can cause size
       * blowup for encodings like `Int64.BigEndianBytes` that are likely to
       * produce many such bytes.
       *
       * Sorted mode:
       *
       * - Fields are encoded in sorted mode.
       * - All values supported by the field encodings are allowed
       * - Element-wise order is preserved: `A &lt; B` if `A[0] &lt; B[0]`, or if
       * `A[0] == B[0] &amp;&amp; A[1] &lt; B[1]`, etc. Strict prefixes sort first.
       *
       * Distinct mode:
       *
       * - Fields are encoded in distinct mode.
       * - All values supported by the field encodings are allowed.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes}
       */
      public static final class OrderedCodeBytes extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes)
          OrderedCodeBytesOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "OrderedCodeBytes");
        }

        // Use OrderedCodeBytes.newBuilder() to construct.
        private OrderedCodeBytes(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private OrderedCodeBytes() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_OrderedCodeBytes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_OrderedCodeBytes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.class,
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.Builder.class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes other =
              (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Fields are encoded independently and concatenated with the fixed byte
         * pair {0x00, 0x01} in between.
         *
         * Any null (0x00) byte in an encoded field is replaced by the fixed byte
         * pair {0x00, 0xFF}.
         *
         * Fields that encode to the empty string "" have special handling:
         *
         * - If *every* field encodes to "", or if the STRUCT has no fields
         * defined, then the STRUCT is encoded as the fixed byte pair
         * {0x00, 0x00}.
         * - Otherwise, the STRUCT only encodes until the last non-empty field,
         * omitting any trailing empty fields. Any empty fields that aren't
         * omitted are replaced with the fixed byte pair {0x00, 0x00}.
         *
         * Examples:
         *
         * - STRUCT()             -&gt; "&#92;00&#92;00"
         * - STRUCT("")           -&gt; "&#92;00&#92;00"
         * - STRUCT("", "")       -&gt; "&#92;00&#92;00"
         * - STRUCT("", "B")      -&gt; "&#92;00&#92;00" + "&#92;00&#92;01" + "B"
         * - STRUCT("A", "")      -&gt; "A"
         * - STRUCT("", "B", "")  -&gt; "&#92;00&#92;00" + "&#92;00&#92;01" + "B"
         * - STRUCT("A", "", "C") -&gt; "A" + "&#92;00&#92;01" + "&#92;00&#92;00" + "&#92;00&#92;01" + "C"
         *
         *
         * Since null bytes are always escaped, this encoding can cause size
         * blowup for encodings like `Int64.BigEndianBytes` that are likely to
         * produce many such bytes.
         *
         * Sorted mode:
         *
         * - Fields are encoded in sorted mode.
         * - All values supported by the field encodings are allowed
         * - Element-wise order is preserved: `A &lt; B` if `A[0] &lt; B[0]`, or if
         * `A[0] == B[0] &amp;&amp; A[1] &lt; B[1]`, etc. Strict prefixes sort first.
         *
         * Distinct mode:
         *
         * - Fields are encoded in distinct mode.
         * - All values supported by the field encodings are allowed.
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes)
            com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_OrderedCodeBytes_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_OrderedCodeBytes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.class,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.Builder
                        .class);
          }

          // Construct using
          // com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_OrderedCodeBytes_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes build() {
            com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes buildPartial() {
            com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes result =
                new com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) {
              return mergeFrom(
                  (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes other) {
            if (other
                == com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
                    .getDefaultInstance()) return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes)
        private static final com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes();
        }

        public static com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<OrderedCodeBytes> PARSER =
            new com.google.protobuf.AbstractParser<OrderedCodeBytes>() {
              @java.lang.Override
              public OrderedCodeBytes parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<OrderedCodeBytes> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<OrderedCodeBytes> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int encodingCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object encoding_;

      public enum EncodingCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        SINGLETON(1),
        DELIMITED_BYTES(2),
        ORDERED_CODE_BYTES(3),
        ENCODING_NOT_SET(0);
        private final int value;

        private EncodingCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EncodingCase valueOf(int value) {
          return forNumber(value);
        }

        public static EncodingCase forNumber(int value) {
          switch (value) {
            case 1:
              return SINGLETON;
            case 2:
              return DELIMITED_BYTES;
            case 3:
              return ORDERED_CODE_BYTES;
            case 0:
              return ENCODING_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EncodingCase getEncodingCase() {
        return EncodingCase.forNumber(encodingCase_);
      }

      public static final int SINGLETON_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Use `Singleton` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
       *
       * @return Whether the singleton field is set.
       */
      @java.lang.Override
      public boolean hasSingleton() {
        return encodingCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Use `Singleton` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
       *
       * @return The singleton.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton getSingleton() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Use `Singleton` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Encoding.SingletonOrBuilder
          getSingletonOrBuilder() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance();
      }

      public static final int DELIMITED_BYTES_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Use `DelimitedBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
       * </code>
       *
       * @return Whether the delimitedBytes field is set.
       */
      @java.lang.Override
      public boolean hasDelimitedBytes() {
        return encodingCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Use `DelimitedBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
       * </code>
       *
       * @return The delimitedBytes.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes getDelimitedBytes() {
        if (encodingCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            .getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Use `DelimitedBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytesOrBuilder
          getDelimitedBytesOrBuilder() {
        if (encodingCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            .getDefaultInstance();
      }

      public static final int ORDERED_CODE_BYTES_FIELD_NUMBER = 3;

      /**
       *
       *
       * <pre>
       * User `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
       * </code>
       *
       * @return Whether the orderedCodeBytes field is set.
       */
      @java.lang.Override
      public boolean hasOrderedCodeBytes() {
        return encodingCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * User `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
       * </code>
       *
       * @return The orderedCodeBytes.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
          getOrderedCodeBytes() {
        if (encodingCase_ == 3) {
          return (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            .getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * User `OrderedCodeBytes` encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytesOrBuilder
          getOrderedCodeBytesOrBuilder() {
        if (encodingCase_ == 3) {
          return (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            .getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (encodingCase_ == 1) {
          output.writeMessage(
              1, (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_);
        }
        if (encodingCase_ == 2) {
          output.writeMessage(
              2, (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) encoding_);
        }
        if (encodingCase_ == 3) {
          output.writeMessage(
              3, (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) encoding_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (encodingCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_);
        }
        if (encodingCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) encoding_);
        }
        if (encodingCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3,
                  (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) encoding_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Struct.Encoding other =
            (com.google.bigtable.admin.v2.Type.Struct.Encoding) obj;

        if (!getEncodingCase().equals(other.getEncodingCase())) return false;
        switch (encodingCase_) {
          case 1:
            if (!getSingleton().equals(other.getSingleton())) return false;
            break;
          case 2:
            if (!getDelimitedBytes().equals(other.getDelimitedBytes())) return false;
            break;
          case 3:
            if (!getOrderedCodeBytes().equals(other.getOrderedCodeBytes())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (encodingCase_) {
          case 1:
            hash = (37 * hash) + SINGLETON_FIELD_NUMBER;
            hash = (53 * hash) + getSingleton().hashCode();
            break;
          case 2:
            hash = (37 * hash) + DELIMITED_BYTES_FIELD_NUMBER;
            hash = (53 * hash) + getDelimitedBytes().hashCode();
            break;
          case 3:
            hash = (37 * hash) + ORDERED_CODE_BYTES_FIELD_NUMBER;
            hash = (53 * hash) + getOrderedCodeBytes().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.bigtable.admin.v2.Type.Struct.Encoding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Rules used to convert to or from lower level types.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Struct.Encoding}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Struct.Encoding)
          com.google.bigtable.admin.v2.Type.Struct.EncodingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.class,
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Struct.Encoding.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (singletonBuilder_ != null) {
            singletonBuilder_.clear();
          }
          if (delimitedBytesBuilder_ != null) {
            delimitedBytesBuilder_.clear();
          }
          if (orderedCodeBytesBuilder_ != null) {
            orderedCodeBytesBuilder_.clear();
          }
          encodingCase_ = 0;
          encoding_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Struct_Encoding_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Struct.Encoding.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding build() {
          com.google.bigtable.admin.v2.Type.Struct.Encoding result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding buildPartial() {
          com.google.bigtable.admin.v2.Type.Struct.Encoding result =
              new com.google.bigtable.admin.v2.Type.Struct.Encoding(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.Struct.Encoding result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.Struct.Encoding result) {
          result.encodingCase_ = encodingCase_;
          result.encoding_ = this.encoding_;
          if (encodingCase_ == 1 && singletonBuilder_ != null) {
            result.encoding_ = singletonBuilder_.build();
          }
          if (encodingCase_ == 2 && delimitedBytesBuilder_ != null) {
            result.encoding_ = delimitedBytesBuilder_.build();
          }
          if (encodingCase_ == 3 && orderedCodeBytesBuilder_ != null) {
            result.encoding_ = orderedCodeBytesBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Struct.Encoding) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Struct.Encoding) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Struct.Encoding other) {
          if (other == com.google.bigtable.admin.v2.Type.Struct.Encoding.getDefaultInstance())
            return this;
          switch (other.getEncodingCase()) {
            case SINGLETON:
              {
                mergeSingleton(other.getSingleton());
                break;
              }
            case DELIMITED_BYTES:
              {
                mergeDelimitedBytes(other.getDelimitedBytes());
                break;
              }
            case ORDERED_CODE_BYTES:
              {
                mergeOrderedCodeBytes(other.getOrderedCodeBytes());
                break;
              }
            case ENCODING_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        internalGetSingletonFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        internalGetDelimitedBytesFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        internalGetOrderedCodeBytesFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 3;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int encodingCase_ = 0;
        private java.lang.Object encoding_;

        public EncodingCase getEncodingCase() {
          return EncodingCase.forNumber(encodingCase_);
        }

        public Builder clearEncoding() {
          encodingCase_ = 0;
          encoding_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.Builder,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.SingletonOrBuilder>
            singletonBuilder_;

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         *
         * @return Whether the singleton field is set.
         */
        @java.lang.Override
        public boolean hasSingleton() {
          return encodingCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         *
         * @return The singleton.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton getSingleton() {
          if (singletonBuilder_ == null) {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance();
          } else {
            if (encodingCase_ == 1) {
              return singletonBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         */
        public Builder setSingleton(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton value) {
          if (singletonBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            singletonBuilder_.setMessage(value);
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         */
        public Builder setSingleton(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.Builder builderForValue) {
          if (singletonBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            singletonBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         */
        public Builder mergeSingleton(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton value) {
          if (singletonBuilder_ == null) {
            if (encodingCase_ == 1
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 1) {
              singletonBuilder_.mergeFrom(value);
            } else {
              singletonBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         */
        public Builder clearSingleton() {
          if (singletonBuilder_ == null) {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            singletonBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         */
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.Builder
            getSingletonBuilder() {
          return internalGetSingletonFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.SingletonOrBuilder
            getSingletonOrBuilder() {
          if ((encodingCase_ == 1) && (singletonBuilder_ != null)) {
            return singletonBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `Singleton` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton singleton = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.Builder,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.SingletonOrBuilder>
            internalGetSingletonFieldBuilder() {
          if (singletonBuilder_ == null) {
            if (!(encodingCase_ == 1)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.getDefaultInstance();
            }
            singletonBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton.Builder,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.SingletonOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Struct.Encoding.Singleton) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 1;
          onChanged();
          return singletonBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.Builder,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytesOrBuilder>
            delimitedBytesBuilder_;

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         *
         * @return Whether the delimitedBytes field is set.
         */
        @java.lang.Override
        public boolean hasDelimitedBytes() {
          return encodingCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         *
         * @return The delimitedBytes.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
            getDelimitedBytes() {
          if (delimitedBytesBuilder_ == null) {
            if (encodingCase_ == 2) {
              return (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
                .getDefaultInstance();
          } else {
            if (encodingCase_ == 2) {
              return delimitedBytesBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         */
        public Builder setDelimitedBytes(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes value) {
          if (delimitedBytesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            delimitedBytesBuilder_.setMessage(value);
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         */
        public Builder setDelimitedBytes(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.Builder
                builderForValue) {
          if (delimitedBytesBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            delimitedBytesBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         */
        public Builder mergeDelimitedBytes(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes value) {
          if (delimitedBytesBuilder_ == null) {
            if (encodingCase_ == 2
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes)
                              encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 2) {
              delimitedBytesBuilder_.mergeFrom(value);
            } else {
              delimitedBytesBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         */
        public Builder clearDelimitedBytes() {
          if (delimitedBytesBuilder_ == null) {
            if (encodingCase_ == 2) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 2) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            delimitedBytesBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         */
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.Builder
            getDelimitedBytesBuilder() {
          return internalGetDelimitedBytesFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytesOrBuilder
            getDelimitedBytesOrBuilder() {
          if ((encodingCase_ == 2) && (delimitedBytesBuilder_ != null)) {
            return delimitedBytesBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 2) {
              return (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Use `DelimitedBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes delimited_bytes = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.Builder,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytesOrBuilder>
            internalGetDelimitedBytesFieldBuilder() {
          if (delimitedBytesBuilder_ == null) {
            if (!(encodingCase_ == 2)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes
                      .getDefaultInstance();
            }
            delimitedBytesBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes.Builder,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytesOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Struct.Encoding.DelimitedBytes) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 2;
          onChanged();
          return delimitedBytesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.Builder,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytesOrBuilder>
            orderedCodeBytesBuilder_;

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         *
         * @return Whether the orderedCodeBytes field is set.
         */
        @java.lang.Override
        public boolean hasOrderedCodeBytes() {
          return encodingCase_ == 3;
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         *
         * @return The orderedCodeBytes.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
            getOrderedCodeBytes() {
          if (orderedCodeBytesBuilder_ == null) {
            if (encodingCase_ == 3) {
              return (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          } else {
            if (encodingCase_ == 3) {
              return orderedCodeBytesBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         */
        public Builder setOrderedCodeBytes(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes value) {
          if (orderedCodeBytesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            orderedCodeBytesBuilder_.setMessage(value);
          }
          encodingCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         */
        public Builder setOrderedCodeBytes(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.Builder
                builderForValue) {
          if (orderedCodeBytesBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            orderedCodeBytesBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         */
        public Builder mergeOrderedCodeBytes(
            com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes value) {
          if (orderedCodeBytesBuilder_ == null) {
            if (encodingCase_ == 3
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes)
                              encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 3) {
              orderedCodeBytesBuilder_.mergeFrom(value);
            } else {
              orderedCodeBytesBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 3;
          return this;
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         */
        public Builder clearOrderedCodeBytes() {
          if (orderedCodeBytesBuilder_ == null) {
            if (encodingCase_ == 3) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 3) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            orderedCodeBytesBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         */
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.Builder
            getOrderedCodeBytesBuilder() {
          return internalGetOrderedCodeBytesFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytesOrBuilder
            getOrderedCodeBytesOrBuilder() {
          if ((encodingCase_ == 3) && (orderedCodeBytesBuilder_ != null)) {
            return orderedCodeBytesBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 3) {
              return (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * User `OrderedCodeBytes` encoding.
         * </pre>
         *
         * <code>
         * .google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes ordered_code_bytes = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.Builder,
                com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytesOrBuilder>
            internalGetOrderedCodeBytesFieldBuilder() {
          if (orderedCodeBytesBuilder_ == null) {
            if (!(encodingCase_ == 3)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes
                      .getDefaultInstance();
            }
            orderedCodeBytesBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes.Builder,
                    com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytesOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Struct.Encoding.OrderedCodeBytes) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 3;
          onChanged();
          return orderedCodeBytesBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Struct.Encoding)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Struct.Encoding)
      private static final com.google.bigtable.admin.v2.Type.Struct.Encoding DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Struct.Encoding();
      }

      public static com.google.bigtable.admin.v2.Type.Struct.Encoding getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Encoding> PARSER =
          new com.google.protobuf.AbstractParser<Encoding>() {
            @java.lang.Override
            public Encoding parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Encoding> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Encoding> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct.Encoding getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int FIELDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.bigtable.admin.v2.Type.Struct.Field> fields_;

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.admin.v2.Type.Struct.Field> getFieldsList() {
      return fields_;
    }

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder>
        getFieldsOrBuilderList() {
      return fields_;
    }

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    @java.lang.Override
    public int getFieldsCount() {
      return fields_.size();
    }

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Struct.Field getFields(int index) {
      return fields_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The names and types of the fields in this struct.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder getFieldsOrBuilder(int index) {
      return fields_.get(index);
    }

    public static final int ENCODING_FIELD_NUMBER = 2;
    private com.google.bigtable.admin.v2.Type.Struct.Encoding encoding_;

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
     *
     * @return Whether the encoding field is set.
     */
    @java.lang.Override
    public boolean hasEncoding() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Struct.Encoding getEncoding() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Struct.Encoding.getDefaultInstance()
          : encoding_;
    }

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to or from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Struct.EncodingOrBuilder getEncodingOrBuilder() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Struct.Encoding.getDefaultInstance()
          : encoding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < fields_.size(); i++) {
        output.writeMessage(1, fields_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getEncoding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fields_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, fields_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEncoding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Struct)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Struct other =
          (com.google.bigtable.admin.v2.Type.Struct) obj;

      if (!getFieldsList().equals(other.getFieldsList())) return false;
      if (hasEncoding() != other.hasEncoding()) return false;
      if (hasEncoding()) {
        if (!getEncoding().equals(other.getEncoding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFieldsCount() > 0) {
        hash = (37 * hash) + FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getFieldsList().hashCode();
      }
      if (hasEncoding()) {
        hash = (37 * hash) + ENCODING_FIELD_NUMBER;
        hash = (53 * hash) + getEncoding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Struct parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Struct prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A structured data value, consisting of fields which map to dynamically
     * typed values.
     * Values of type `Struct` are stored in `Value.array_value` where entries are
     * in the same order and number as `field_types`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Struct}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Struct)
        com.google.bigtable.admin.v2.Type.StructOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Struct_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Struct_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Struct.class,
                com.google.bigtable.admin.v2.Type.Struct.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Struct.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetFieldsFieldBuilder();
          internalGetEncodingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (fieldsBuilder_ == null) {
          fields_ = java.util.Collections.emptyList();
        } else {
          fields_ = null;
          fieldsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Struct_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct build() {
        com.google.bigtable.admin.v2.Type.Struct result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Struct buildPartial() {
        com.google.bigtable.admin.v2.Type.Struct result =
            new com.google.bigtable.admin.v2.Type.Struct(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.bigtable.admin.v2.Type.Struct result) {
        if (fieldsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            fields_ = java.util.Collections.unmodifiableList(fields_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fields_ = fields_;
        } else {
          result.fields_ = fieldsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Struct result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.encoding_ = encodingBuilder_ == null ? encoding_ : encodingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Struct) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Struct) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Struct other) {
        if (other == com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance()) return this;
        if (fieldsBuilder_ == null) {
          if (!other.fields_.isEmpty()) {
            if (fields_.isEmpty()) {
              fields_ = other.fields_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFieldsIsMutable();
              fields_.addAll(other.fields_);
            }
            onChanged();
          }
        } else {
          if (!other.fields_.isEmpty()) {
            if (fieldsBuilder_.isEmpty()) {
              fieldsBuilder_.dispose();
              fieldsBuilder_ = null;
              fields_ = other.fields_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fieldsBuilder_ =
                  com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                      ? internalGetFieldsFieldBuilder()
                      : null;
            } else {
              fieldsBuilder_.addAllMessages(other.fields_);
            }
          }
        }
        if (other.hasEncoding()) {
          mergeEncoding(other.getEncoding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.bigtable.admin.v2.Type.Struct.Field m =
                      input.readMessage(
                          com.google.bigtable.admin.v2.Type.Struct.Field.parser(),
                          extensionRegistry);
                  if (fieldsBuilder_ == null) {
                    ensureFieldsIsMutable();
                    fields_.add(m);
                  } else {
                    fieldsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      internalGetEncodingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.bigtable.admin.v2.Type.Struct.Field> fields_ =
          java.util.Collections.emptyList();

      private void ensureFieldsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          fields_ =
              new java.util.ArrayList<com.google.bigtable.admin.v2.Type.Struct.Field>(fields_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
              com.google.bigtable.admin.v2.Type.Struct.Field,
              com.google.bigtable.admin.v2.Type.Struct.Field.Builder,
              com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder>
          fieldsBuilder_;

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public java.util.List<com.google.bigtable.admin.v2.Type.Struct.Field> getFieldsList() {
        if (fieldsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fields_);
        } else {
          return fieldsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public int getFieldsCount() {
        if (fieldsBuilder_ == null) {
          return fields_.size();
        } else {
          return fieldsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Struct.Field getFields(int index) {
        if (fieldsBuilder_ == null) {
          return fields_.get(index);
        } else {
          return fieldsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder setFields(int index, com.google.bigtable.admin.v2.Type.Struct.Field value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.set(index, value);
          onChanged();
        } else {
          fieldsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder setFields(
          int index, com.google.bigtable.admin.v2.Type.Struct.Field.Builder builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.set(index, builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder addFields(com.google.bigtable.admin.v2.Type.Struct.Field value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.add(value);
          onChanged();
        } else {
          fieldsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder addFields(int index, com.google.bigtable.admin.v2.Type.Struct.Field value) {
        if (fieldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFieldsIsMutable();
          fields_.add(index, value);
          onChanged();
        } else {
          fieldsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder addFields(
          com.google.bigtable.admin.v2.Type.Struct.Field.Builder builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.add(builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder addFields(
          int index, com.google.bigtable.admin.v2.Type.Struct.Field.Builder builderForValue) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.add(index, builderForValue.build());
          onChanged();
        } else {
          fieldsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder addAllFields(
          java.lang.Iterable<? extends com.google.bigtable.admin.v2.Type.Struct.Field> values) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
          onChanged();
        } else {
          fieldsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder clearFields() {
        if (fieldsBuilder_ == null) {
          fields_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fieldsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public Builder removeFields(int index) {
        if (fieldsBuilder_ == null) {
          ensureFieldsIsMutable();
          fields_.remove(index);
          onChanged();
        } else {
          fieldsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Struct.Field.Builder getFieldsBuilder(int index) {
        return internalGetFieldsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder getFieldsOrBuilder(int index) {
        if (fieldsBuilder_ == null) {
          return fields_.get(index);
        } else {
          return fieldsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public java.util.List<? extends com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder>
          getFieldsOrBuilderList() {
        if (fieldsBuilder_ != null) {
          return fieldsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fields_);
        }
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Struct.Field.Builder addFieldsBuilder() {
        return internalGetFieldsFieldBuilder()
            .addBuilder(com.google.bigtable.admin.v2.Type.Struct.Field.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Struct.Field.Builder addFieldsBuilder(int index) {
        return internalGetFieldsFieldBuilder()
            .addBuilder(index, com.google.bigtable.admin.v2.Type.Struct.Field.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The names and types of the fields in this struct.
       * </pre>
       *
       * <code>repeated .google.bigtable.admin.v2.Type.Struct.Field fields = 1;</code>
       */
      public java.util.List<com.google.bigtable.admin.v2.Type.Struct.Field.Builder>
          getFieldsBuilderList() {
        return internalGetFieldsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilder<
              com.google.bigtable.admin.v2.Type.Struct.Field,
              com.google.bigtable.admin.v2.Type.Struct.Field.Builder,
              com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder>
          internalGetFieldsFieldBuilder() {
        if (fieldsBuilder_ == null) {
          fieldsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Struct.Field,
                  com.google.bigtable.admin.v2.Type.Struct.Field.Builder,
                  com.google.bigtable.admin.v2.Type.Struct.FieldOrBuilder>(
                  fields_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          fields_ = null;
        }
        return fieldsBuilder_;
      }

      private com.google.bigtable.admin.v2.Type.Struct.Encoding encoding_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Struct.Encoding,
              com.google.bigtable.admin.v2.Type.Struct.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Struct.EncodingOrBuilder>
          encodingBuilder_;

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       *
       * @return Whether the encoding field is set.
       */
      public boolean hasEncoding() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       *
       * @return The encoding.
       */
      public com.google.bigtable.admin.v2.Type.Struct.Encoding getEncoding() {
        if (encodingBuilder_ == null) {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Struct.Encoding.getDefaultInstance()
              : encoding_;
        } else {
          return encodingBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       */
      public Builder setEncoding(com.google.bigtable.admin.v2.Type.Struct.Encoding value) {
        if (encodingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encoding_ = value;
        } else {
          encodingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       */
      public Builder setEncoding(
          com.google.bigtable.admin.v2.Type.Struct.Encoding.Builder builderForValue) {
        if (encodingBuilder_ == null) {
          encoding_ = builderForValue.build();
        } else {
          encodingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       */
      public Builder mergeEncoding(com.google.bigtable.admin.v2.Type.Struct.Encoding value) {
        if (encodingBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && encoding_ != null
              && encoding_
                  != com.google.bigtable.admin.v2.Type.Struct.Encoding.getDefaultInstance()) {
            getEncodingBuilder().mergeFrom(value);
          } else {
            encoding_ = value;
          }
        } else {
          encodingBuilder_.mergeFrom(value);
        }
        if (encoding_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000002);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       */
      public com.google.bigtable.admin.v2.Type.Struct.Encoding.Builder getEncodingBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetEncodingFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       */
      public com.google.bigtable.admin.v2.Type.Struct.EncodingOrBuilder getEncodingOrBuilder() {
        if (encodingBuilder_ != null) {
          return encodingBuilder_.getMessageOrBuilder();
        } else {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Struct.Encoding.getDefaultInstance()
              : encoding_;
        }
      }

      /**
       *
       *
       * <pre>
       * The encoding to use when converting to or from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Struct.Encoding encoding = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Struct.Encoding,
              com.google.bigtable.admin.v2.Type.Struct.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Struct.EncodingOrBuilder>
          internalGetEncodingFieldBuilder() {
        if (encodingBuilder_ == null) {
          encodingBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Struct.Encoding,
                  com.google.bigtable.admin.v2.Type.Struct.Encoding.Builder,
                  com.google.bigtable.admin.v2.Type.Struct.EncodingOrBuilder>(
                  getEncoding(), getParentForChildren(), isClean());
          encoding_ = null;
        }
        return encodingBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Struct)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Struct)
    private static final com.google.bigtable.admin.v2.Type.Struct DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Struct();
    }

    public static com.google.bigtable.admin.v2.Type.Struct getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Struct> PARSER =
        new com.google.protobuf.AbstractParser<Struct>() {
          @java.lang.Override
          public Struct parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Struct> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Struct> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Struct getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ProtoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Proto)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this proto is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The schemaBundleId.
     */
    java.lang.String getSchemaBundleId();

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this proto is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The bytes for schemaBundleId.
     */
    com.google.protobuf.ByteString getSchemaBundleIdBytes();

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf message, including package. In
     * the format of "foo.bar.Message".
     * </pre>
     *
     * <code>string message_name = 2;</code>
     *
     * @return The messageName.
     */
    java.lang.String getMessageName();

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf message, including package. In
     * the format of "foo.bar.Message".
     * </pre>
     *
     * <code>string message_name = 2;</code>
     *
     * @return The bytes for messageName.
     */
    com.google.protobuf.ByteString getMessageNameBytes();
  }

  /**
   *
   *
   * <pre>
   * A protobuf message type.
   * Values of type `Proto` are stored in `Value.bytes_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Proto}
   */
  public static final class Proto extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Proto)
      ProtoOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Proto");
    }

    // Use Proto.newBuilder() to construct.
    private Proto(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Proto() {
      schemaBundleId_ = "";
      messageName_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Proto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Proto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Proto.class,
              com.google.bigtable.admin.v2.Type.Proto.Builder.class);
    }

    public static final int SCHEMA_BUNDLE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object schemaBundleId_ = "";

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this proto is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The schemaBundleId.
     */
    @java.lang.Override
    public java.lang.String getSchemaBundleId() {
      java.lang.Object ref = schemaBundleId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaBundleId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this proto is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The bytes for schemaBundleId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemaBundleIdBytes() {
      java.lang.Object ref = schemaBundleId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaBundleId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MESSAGE_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object messageName_ = "";

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf message, including package. In
     * the format of "foo.bar.Message".
     * </pre>
     *
     * <code>string message_name = 2;</code>
     *
     * @return The messageName.
     */
    @java.lang.Override
    public java.lang.String getMessageName() {
      java.lang.Object ref = messageName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        messageName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf message, including package. In
     * the format of "foo.bar.Message".
     * </pre>
     *
     * <code>string message_name = 2;</code>
     *
     * @return The bytes for messageName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMessageNameBytes() {
      java.lang.Object ref = messageName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        messageName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(schemaBundleId_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, schemaBundleId_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(messageName_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, messageName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(schemaBundleId_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, schemaBundleId_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(messageName_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, messageName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Proto)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Proto other = (com.google.bigtable.admin.v2.Type.Proto) obj;

      if (!getSchemaBundleId().equals(other.getSchemaBundleId())) return false;
      if (!getMessageName().equals(other.getMessageName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCHEMA_BUNDLE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaBundleId().hashCode();
      hash = (37 * hash) + MESSAGE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getMessageName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Proto parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Proto prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A protobuf message type.
     * Values of type `Proto` are stored in `Value.bytes_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Proto}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Proto)
        com.google.bigtable.admin.v2.Type.ProtoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Proto_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Proto_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Proto.class,
                com.google.bigtable.admin.v2.Type.Proto.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Proto.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        schemaBundleId_ = "";
        messageName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Proto_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Proto getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Proto build() {
        com.google.bigtable.admin.v2.Type.Proto result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Proto buildPartial() {
        com.google.bigtable.admin.v2.Type.Proto result =
            new com.google.bigtable.admin.v2.Type.Proto(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Proto result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.schemaBundleId_ = schemaBundleId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.messageName_ = messageName_;
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Proto) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Proto) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Proto other) {
        if (other == com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance()) return this;
        if (!other.getSchemaBundleId().isEmpty()) {
          schemaBundleId_ = other.schemaBundleId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getMessageName().isEmpty()) {
          messageName_ = other.messageName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  schemaBundleId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  messageName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object schemaBundleId_ = "";

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this proto is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @return The schemaBundleId.
       */
      public java.lang.String getSchemaBundleId() {
        java.lang.Object ref = schemaBundleId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schemaBundleId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this proto is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @return The bytes for schemaBundleId.
       */
      public com.google.protobuf.ByteString getSchemaBundleIdBytes() {
        java.lang.Object ref = schemaBundleId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          schemaBundleId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this proto is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @param value The schemaBundleId to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBundleId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaBundleId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this proto is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSchemaBundleId() {
        schemaBundleId_ = getDefaultInstance().getSchemaBundleId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this proto is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @param value The bytes for schemaBundleId to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBundleIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        schemaBundleId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object messageName_ = "";

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf message, including package. In
       * the format of "foo.bar.Message".
       * </pre>
       *
       * <code>string message_name = 2;</code>
       *
       * @return The messageName.
       */
      public java.lang.String getMessageName() {
        java.lang.Object ref = messageName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          messageName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf message, including package. In
       * the format of "foo.bar.Message".
       * </pre>
       *
       * <code>string message_name = 2;</code>
       *
       * @return The bytes for messageName.
       */
      public com.google.protobuf.ByteString getMessageNameBytes() {
        java.lang.Object ref = messageName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          messageName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf message, including package. In
       * the format of "foo.bar.Message".
       * </pre>
       *
       * <code>string message_name = 2;</code>
       *
       * @param value The messageName to set.
       * @return This builder for chaining.
       */
      public Builder setMessageName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf message, including package. In
       * the format of "foo.bar.Message".
       * </pre>
       *
       * <code>string message_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMessageName() {
        messageName_ = getDefaultInstance().getMessageName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf message, including package. In
       * the format of "foo.bar.Message".
       * </pre>
       *
       * <code>string message_name = 2;</code>
       *
       * @param value The bytes for messageName to set.
       * @return This builder for chaining.
       */
      public Builder setMessageNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        messageName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Proto)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Proto)
    private static final com.google.bigtable.admin.v2.Type.Proto DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Proto();
    }

    public static com.google.bigtable.admin.v2.Type.Proto getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Proto> PARSER =
        new com.google.protobuf.AbstractParser<Proto>() {
          @java.lang.Override
          public Proto parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Proto> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Proto> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Proto getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EnumOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Enum)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this enum is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The schemaBundleId.
     */
    java.lang.String getSchemaBundleId();

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this enum is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The bytes for schemaBundleId.
     */
    com.google.protobuf.ByteString getSchemaBundleIdBytes();

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf enum message, including package.
     * In the format of "foo.bar.EnumMessage".
     * </pre>
     *
     * <code>string enum_name = 2;</code>
     *
     * @return The enumName.
     */
    java.lang.String getEnumName();

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf enum message, including package.
     * In the format of "foo.bar.EnumMessage".
     * </pre>
     *
     * <code>string enum_name = 2;</code>
     *
     * @return The bytes for enumName.
     */
    com.google.protobuf.ByteString getEnumNameBytes();
  }

  /**
   *
   *
   * <pre>
   * A protobuf enum type.
   * Values of type `Enum` are stored in `Value.int_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Enum}
   */
  public static final class Enum extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Enum)
      EnumOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Enum");
    }

    // Use Enum.newBuilder() to construct.
    private Enum(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Enum() {
      schemaBundleId_ = "";
      enumName_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Enum_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Enum_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Enum.class,
              com.google.bigtable.admin.v2.Type.Enum.Builder.class);
    }

    public static final int SCHEMA_BUNDLE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object schemaBundleId_ = "";

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this enum is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The schemaBundleId.
     */
    @java.lang.Override
    public java.lang.String getSchemaBundleId() {
      java.lang.Object ref = schemaBundleId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaBundleId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the schema bundle that this enum is defined in.
     * </pre>
     *
     * <code>string schema_bundle_id = 1;</code>
     *
     * @return The bytes for schemaBundleId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemaBundleIdBytes() {
      java.lang.Object ref = schemaBundleId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaBundleId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENUM_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object enumName_ = "";

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf enum message, including package.
     * In the format of "foo.bar.EnumMessage".
     * </pre>
     *
     * <code>string enum_name = 2;</code>
     *
     * @return The enumName.
     */
    @java.lang.Override
    public java.lang.String getEnumName() {
      java.lang.Object ref = enumName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        enumName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The fully qualified name of the protobuf enum message, including package.
     * In the format of "foo.bar.EnumMessage".
     * </pre>
     *
     * <code>string enum_name = 2;</code>
     *
     * @return The bytes for enumName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEnumNameBytes() {
      java.lang.Object ref = enumName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        enumName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(schemaBundleId_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, schemaBundleId_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(enumName_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, enumName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(schemaBundleId_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, schemaBundleId_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(enumName_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, enumName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Enum)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Enum other = (com.google.bigtable.admin.v2.Type.Enum) obj;

      if (!getSchemaBundleId().equals(other.getSchemaBundleId())) return false;
      if (!getEnumName().equals(other.getEnumName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCHEMA_BUNDLE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaBundleId().hashCode();
      hash = (37 * hash) + ENUM_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getEnumName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Enum parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Enum prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A protobuf enum type.
     * Values of type `Enum` are stored in `Value.int_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Enum}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Enum)
        com.google.bigtable.admin.v2.Type.EnumOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Enum_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Enum_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Enum.class,
                com.google.bigtable.admin.v2.Type.Enum.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Enum.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        schemaBundleId_ = "";
        enumName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Enum_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Enum getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Enum build() {
        com.google.bigtable.admin.v2.Type.Enum result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Enum buildPartial() {
        com.google.bigtable.admin.v2.Type.Enum result =
            new com.google.bigtable.admin.v2.Type.Enum(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Enum result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.schemaBundleId_ = schemaBundleId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enumName_ = enumName_;
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Enum) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Enum) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Enum other) {
        if (other == com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance()) return this;
        if (!other.getSchemaBundleId().isEmpty()) {
          schemaBundleId_ = other.schemaBundleId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getEnumName().isEmpty()) {
          enumName_ = other.enumName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  schemaBundleId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  enumName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object schemaBundleId_ = "";

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this enum is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @return The schemaBundleId.
       */
      public java.lang.String getSchemaBundleId() {
        java.lang.Object ref = schemaBundleId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schemaBundleId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this enum is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @return The bytes for schemaBundleId.
       */
      public com.google.protobuf.ByteString getSchemaBundleIdBytes() {
        java.lang.Object ref = schemaBundleId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          schemaBundleId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this enum is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @param value The schemaBundleId to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBundleId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaBundleId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this enum is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSchemaBundleId() {
        schemaBundleId_ = getDefaultInstance().getSchemaBundleId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The ID of the schema bundle that this enum is defined in.
       * </pre>
       *
       * <code>string schema_bundle_id = 1;</code>
       *
       * @param value The bytes for schemaBundleId to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBundleIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        schemaBundleId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object enumName_ = "";

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf enum message, including package.
       * In the format of "foo.bar.EnumMessage".
       * </pre>
       *
       * <code>string enum_name = 2;</code>
       *
       * @return The enumName.
       */
      public java.lang.String getEnumName() {
        java.lang.Object ref = enumName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          enumName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf enum message, including package.
       * In the format of "foo.bar.EnumMessage".
       * </pre>
       *
       * <code>string enum_name = 2;</code>
       *
       * @return The bytes for enumName.
       */
      public com.google.protobuf.ByteString getEnumNameBytes() {
        java.lang.Object ref = enumName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          enumName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf enum message, including package.
       * In the format of "foo.bar.EnumMessage".
       * </pre>
       *
       * <code>string enum_name = 2;</code>
       *
       * @param value The enumName to set.
       * @return This builder for chaining.
       */
      public Builder setEnumName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        enumName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf enum message, including package.
       * In the format of "foo.bar.EnumMessage".
       * </pre>
       *
       * <code>string enum_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnumName() {
        enumName_ = getDefaultInstance().getEnumName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The fully qualified name of the protobuf enum message, including package.
       * In the format of "foo.bar.EnumMessage".
       * </pre>
       *
       * <code>string enum_name = 2;</code>
       *
       * @param value The bytes for enumName to set.
       * @return This builder for chaining.
       */
      public Builder setEnumNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        enumName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Enum)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Enum)
    private static final com.google.bigtable.admin.v2.Type.Enum DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Enum();
    }

    public static com.google.bigtable.admin.v2.Type.Enum getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Enum> PARSER =
        new com.google.protobuf.AbstractParser<Enum>() {
          @java.lang.Override
          public Enum parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Enum> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Enum> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Enum getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ArrayOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Array)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The type of the elements in the array. This must not be `Array`.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
     *
     * @return Whether the elementType field is set.
     */
    boolean hasElementType();

    /**
     *
     *
     * <pre>
     * The type of the elements in the array. This must not be `Array`.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
     *
     * @return The elementType.
     */
    com.google.bigtable.admin.v2.Type getElementType();

    /**
     *
     *
     * <pre>
     * The type of the elements in the array. This must not be `Array`.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
     */
    com.google.bigtable.admin.v2.TypeOrBuilder getElementTypeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * An ordered list of elements of a given type.
   * Values of type `Array` are stored in `Value.array_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Array}
   */
  public static final class Array extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Array)
      ArrayOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Array");
    }

    // Use Array.newBuilder() to construct.
    private Array(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Array() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Array_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Array_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Array.class,
              com.google.bigtable.admin.v2.Type.Array.Builder.class);
    }

    private int bitField0_;
    public static final int ELEMENT_TYPE_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type elementType_;

    /**
     *
     *
     * <pre>
     * The type of the elements in the array. This must not be `Array`.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
     *
     * @return Whether the elementType field is set.
     */
    @java.lang.Override
    public boolean hasElementType() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The type of the elements in the array. This must not be `Array`.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
     *
     * @return The elementType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getElementType() {
      return elementType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : elementType_;
    }

    /**
     *
     *
     * <pre>
     * The type of the elements in the array. This must not be `Array`.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.TypeOrBuilder getElementTypeOrBuilder() {
      return elementType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : elementType_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getElementType());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getElementType());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Array)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Array other = (com.google.bigtable.admin.v2.Type.Array) obj;

      if (hasElementType() != other.hasElementType()) return false;
      if (hasElementType()) {
        if (!getElementType().equals(other.getElementType())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasElementType()) {
        hash = (37 * hash) + ELEMENT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getElementType().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Array parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Array prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * An ordered list of elements of a given type.
     * Values of type `Array` are stored in `Value.array_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Array}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Array)
        com.google.bigtable.admin.v2.Type.ArrayOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Array_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Array_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Array.class,
                com.google.bigtable.admin.v2.Type.Array.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Array.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetElementTypeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        elementType_ = null;
        if (elementTypeBuilder_ != null) {
          elementTypeBuilder_.dispose();
          elementTypeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Array_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Array getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Array.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Array build() {
        com.google.bigtable.admin.v2.Type.Array result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Array buildPartial() {
        com.google.bigtable.admin.v2.Type.Array result =
            new com.google.bigtable.admin.v2.Type.Array(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Array result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.elementType_ =
              elementTypeBuilder_ == null ? elementType_ : elementTypeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Array) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Array) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Array other) {
        if (other == com.google.bigtable.admin.v2.Type.Array.getDefaultInstance()) return this;
        if (other.hasElementType()) {
          mergeElementType(other.getElementType());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetElementTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type elementType_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          elementTypeBuilder_;

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       *
       * @return Whether the elementType field is set.
       */
      public boolean hasElementType() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       *
       * @return The elementType.
       */
      public com.google.bigtable.admin.v2.Type getElementType() {
        if (elementTypeBuilder_ == null) {
          return elementType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : elementType_;
        } else {
          return elementTypeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       */
      public Builder setElementType(com.google.bigtable.admin.v2.Type value) {
        if (elementTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          elementType_ = value;
        } else {
          elementTypeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       */
      public Builder setElementType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
        if (elementTypeBuilder_ == null) {
          elementType_ = builderForValue.build();
        } else {
          elementTypeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       */
      public Builder mergeElementType(com.google.bigtable.admin.v2.Type value) {
        if (elementTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && elementType_ != null
              && elementType_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
            getElementTypeBuilder().mergeFrom(value);
          } else {
            elementType_ = value;
          }
        } else {
          elementTypeBuilder_.mergeFrom(value);
        }
        if (elementType_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       */
      public Builder clearElementType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        elementType_ = null;
        if (elementTypeBuilder_ != null) {
          elementTypeBuilder_.dispose();
          elementTypeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Builder getElementTypeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetElementTypeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.TypeOrBuilder getElementTypeOrBuilder() {
        if (elementTypeBuilder_ != null) {
          return elementTypeBuilder_.getMessageOrBuilder();
        } else {
          return elementType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : elementType_;
        }
      }

      /**
       *
       *
       * <pre>
       * The type of the elements in the array. This must not be `Array`.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type element_type = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          internalGetElementTypeFieldBuilder() {
        if (elementTypeBuilder_ == null) {
          elementTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type,
                  com.google.bigtable.admin.v2.Type.Builder,
                  com.google.bigtable.admin.v2.TypeOrBuilder>(
                  getElementType(), getParentForChildren(), isClean());
          elementType_ = null;
        }
        return elementTypeBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Array)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Array)
    private static final com.google.bigtable.admin.v2.Type.Array DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Array();
    }

    public static com.google.bigtable.admin.v2.Type.Array getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Array> PARSER =
        new com.google.protobuf.AbstractParser<Array>() {
          @java.lang.Override
          public Array parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Array> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Array> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Array getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MapOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Map)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The type of a map key.
     * Only `Bytes`, `String`, and `Int64` are allowed as key types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
     *
     * @return Whether the keyType field is set.
     */
    boolean hasKeyType();

    /**
     *
     *
     * <pre>
     * The type of a map key.
     * Only `Bytes`, `String`, and `Int64` are allowed as key types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
     *
     * @return The keyType.
     */
    com.google.bigtable.admin.v2.Type getKeyType();

    /**
     *
     *
     * <pre>
     * The type of a map key.
     * Only `Bytes`, `String`, and `Int64` are allowed as key types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
     */
    com.google.bigtable.admin.v2.TypeOrBuilder getKeyTypeOrBuilder();

    /**
     *
     *
     * <pre>
     * The type of the values in a map.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
     *
     * @return Whether the valueType field is set.
     */
    boolean hasValueType();

    /**
     *
     *
     * <pre>
     * The type of the values in a map.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
     *
     * @return The valueType.
     */
    com.google.bigtable.admin.v2.Type getValueType();

    /**
     *
     *
     * <pre>
     * The type of the values in a map.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
     */
    com.google.bigtable.admin.v2.TypeOrBuilder getValueTypeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A mapping of keys to values of a given type.
   * Values of type `Map` are stored in a `Value.array_value` where each entry
   * is another `Value.array_value` with two elements (the key and the value,
   * in that order).
   * Normally encoded Map values won't have repeated keys, however, clients are
   * expected to handle the case in which they do. If the same key appears
   * multiple times, the _last_ value takes precedence.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Map}
   */
  public static final class Map extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Map)
      MapOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Map");
    }

    // Use Map.newBuilder() to construct.
    private Map(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Map() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Map_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Map_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Map.class,
              com.google.bigtable.admin.v2.Type.Map.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_TYPE_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type keyType_;

    /**
     *
     *
     * <pre>
     * The type of a map key.
     * Only `Bytes`, `String`, and `Int64` are allowed as key types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
     *
     * @return Whether the keyType field is set.
     */
    @java.lang.Override
    public boolean hasKeyType() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The type of a map key.
     * Only `Bytes`, `String`, and `Int64` are allowed as key types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
     *
     * @return The keyType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getKeyType() {
      return keyType_ == null ? com.google.bigtable.admin.v2.Type.getDefaultInstance() : keyType_;
    }

    /**
     *
     *
     * <pre>
     * The type of a map key.
     * Only `Bytes`, `String`, and `Int64` are allowed as key types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.TypeOrBuilder getKeyTypeOrBuilder() {
      return keyType_ == null ? com.google.bigtable.admin.v2.Type.getDefaultInstance() : keyType_;
    }

    public static final int VALUE_TYPE_FIELD_NUMBER = 2;
    private com.google.bigtable.admin.v2.Type valueType_;

    /**
     *
     *
     * <pre>
     * The type of the values in a map.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
     *
     * @return Whether the valueType field is set.
     */
    @java.lang.Override
    public boolean hasValueType() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The type of the values in a map.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getValueType() {
      return valueType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : valueType_;
    }

    /**
     *
     *
     * <pre>
     * The type of the values in a map.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.TypeOrBuilder getValueTypeOrBuilder() {
      return valueType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : valueType_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getKeyType());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getValueType());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getKeyType());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getValueType());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Map)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Map other = (com.google.bigtable.admin.v2.Type.Map) obj;

      if (hasKeyType() != other.hasKeyType()) return false;
      if (hasKeyType()) {
        if (!getKeyType().equals(other.getKeyType())) return false;
      }
      if (hasValueType() != other.hasValueType()) return false;
      if (hasValueType()) {
        if (!getValueType().equals(other.getValueType())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKeyType()) {
        hash = (37 * hash) + KEY_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getKeyType().hashCode();
      }
      if (hasValueType()) {
        hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getValueType().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Map parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Map prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A mapping of keys to values of a given type.
     * Values of type `Map` are stored in a `Value.array_value` where each entry
     * is another `Value.array_value` with two elements (the key and the value,
     * in that order).
     * Normally encoded Map values won't have repeated keys, however, clients are
     * expected to handle the case in which they do. If the same key appears
     * multiple times, the _last_ value takes precedence.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Map}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Map)
        com.google.bigtable.admin.v2.Type.MapOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Map_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Map_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Map.class,
                com.google.bigtable.admin.v2.Type.Map.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Map.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetKeyTypeFieldBuilder();
          internalGetValueTypeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keyType_ = null;
        if (keyTypeBuilder_ != null) {
          keyTypeBuilder_.dispose();
          keyTypeBuilder_ = null;
        }
        valueType_ = null;
        if (valueTypeBuilder_ != null) {
          valueTypeBuilder_.dispose();
          valueTypeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Map_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Map getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Map.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Map build() {
        com.google.bigtable.admin.v2.Type.Map result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Map buildPartial() {
        com.google.bigtable.admin.v2.Type.Map result =
            new com.google.bigtable.admin.v2.Type.Map(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Map result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keyType_ = keyTypeBuilder_ == null ? keyType_ : keyTypeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.valueType_ = valueTypeBuilder_ == null ? valueType_ : valueTypeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Map) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Map) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Map other) {
        if (other == com.google.bigtable.admin.v2.Type.Map.getDefaultInstance()) return this;
        if (other.hasKeyType()) {
          mergeKeyType(other.getKeyType());
        }
        if (other.hasValueType()) {
          mergeValueType(other.getValueType());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetKeyTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      internalGetValueTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type keyType_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          keyTypeBuilder_;

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       *
       * @return Whether the keyType field is set.
       */
      public boolean hasKeyType() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       *
       * @return The keyType.
       */
      public com.google.bigtable.admin.v2.Type getKeyType() {
        if (keyTypeBuilder_ == null) {
          return keyType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : keyType_;
        } else {
          return keyTypeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       */
      public Builder setKeyType(com.google.bigtable.admin.v2.Type value) {
        if (keyTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          keyType_ = value;
        } else {
          keyTypeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       */
      public Builder setKeyType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
        if (keyTypeBuilder_ == null) {
          keyType_ = builderForValue.build();
        } else {
          keyTypeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       */
      public Builder mergeKeyType(com.google.bigtable.admin.v2.Type value) {
        if (keyTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && keyType_ != null
              && keyType_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
            getKeyTypeBuilder().mergeFrom(value);
          } else {
            keyType_ = value;
          }
        } else {
          keyTypeBuilder_.mergeFrom(value);
        }
        if (keyType_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       */
      public Builder clearKeyType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keyType_ = null;
        if (keyTypeBuilder_ != null) {
          keyTypeBuilder_.dispose();
          keyTypeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Builder getKeyTypeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetKeyTypeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.TypeOrBuilder getKeyTypeOrBuilder() {
        if (keyTypeBuilder_ != null) {
          return keyTypeBuilder_.getMessageOrBuilder();
        } else {
          return keyType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : keyType_;
        }
      }

      /**
       *
       *
       * <pre>
       * The type of a map key.
       * Only `Bytes`, `String`, and `Int64` are allowed as key types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type key_type = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          internalGetKeyTypeFieldBuilder() {
        if (keyTypeBuilder_ == null) {
          keyTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type,
                  com.google.bigtable.admin.v2.Type.Builder,
                  com.google.bigtable.admin.v2.TypeOrBuilder>(
                  getKeyType(), getParentForChildren(), isClean());
          keyType_ = null;
        }
        return keyTypeBuilder_;
      }

      private com.google.bigtable.admin.v2.Type valueType_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          valueTypeBuilder_;

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       *
       * @return Whether the valueType field is set.
       */
      public boolean hasValueType() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       *
       * @return The valueType.
       */
      public com.google.bigtable.admin.v2.Type getValueType() {
        if (valueTypeBuilder_ == null) {
          return valueType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : valueType_;
        } else {
          return valueTypeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       */
      public Builder setValueType(com.google.bigtable.admin.v2.Type value) {
        if (valueTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          valueType_ = value;
        } else {
          valueTypeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       */
      public Builder setValueType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
        if (valueTypeBuilder_ == null) {
          valueType_ = builderForValue.build();
        } else {
          valueTypeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       */
      public Builder mergeValueType(com.google.bigtable.admin.v2.Type value) {
        if (valueTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && valueType_ != null
              && valueType_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
            getValueTypeBuilder().mergeFrom(value);
          } else {
            valueType_ = value;
          }
        } else {
          valueTypeBuilder_.mergeFrom(value);
        }
        if (valueType_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       */
      public Builder clearValueType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        valueType_ = null;
        if (valueTypeBuilder_ != null) {
          valueTypeBuilder_.dispose();
          valueTypeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       */
      public com.google.bigtable.admin.v2.Type.Builder getValueTypeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetValueTypeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       */
      public com.google.bigtable.admin.v2.TypeOrBuilder getValueTypeOrBuilder() {
        if (valueTypeBuilder_ != null) {
          return valueTypeBuilder_.getMessageOrBuilder();
        } else {
          return valueType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : valueType_;
        }
      }

      /**
       *
       *
       * <pre>
       * The type of the values in a map.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type value_type = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          internalGetValueTypeFieldBuilder() {
        if (valueTypeBuilder_ == null) {
          valueTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type,
                  com.google.bigtable.admin.v2.Type.Builder,
                  com.google.bigtable.admin.v2.TypeOrBuilder>(
                  getValueType(), getParentForChildren(), isClean());
          valueType_ = null;
        }
        return valueTypeBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Map)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Map)
    private static final com.google.bigtable.admin.v2.Type.Map DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Map();
    }

    public static com.google.bigtable.admin.v2.Type.Map getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Map> PARSER =
        new com.google.protobuf.AbstractParser<Map>() {
          @java.lang.Override
          public Map parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Map> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Map> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Map getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AggregateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Aggregate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return Whether the inputType field is set.
     */
    boolean hasInputType();

    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return The inputType.
     */
    com.google.bigtable.admin.v2.Type getInputType();

    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     */
    com.google.bigtable.admin.v2.TypeOrBuilder getInputTypeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateType field is set.
     */
    boolean hasStateType();

    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateType.
     */
    com.google.bigtable.admin.v2.Type getStateType();

    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.bigtable.admin.v2.TypeOrBuilder getStateTypeOrBuilder();

    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return Whether the sum field is set.
     */
    boolean hasSum();

    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return The sum.
     */
    com.google.bigtable.admin.v2.Type.Aggregate.Sum getSum();

    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     */
    com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder getSumOrBuilder();

    /**
     *
     *
     * <pre>
     * HyperLogLogPlusPlusUniqueCount aggregator.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
     * </code>
     *
     * @return Whether the hllppUniqueCount field is set.
     */
    boolean hasHllppUniqueCount();

    /**
     *
     *
     * <pre>
     * HyperLogLogPlusPlusUniqueCount aggregator.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
     * </code>
     *
     * @return The hllppUniqueCount.
     */
    com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
        getHllppUniqueCount();

    /**
     *
     *
     * <pre>
     * HyperLogLogPlusPlusUniqueCount aggregator.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
     * </code>
     */
    com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCountOrBuilder
        getHllppUniqueCountOrBuilder();

    /**
     *
     *
     * <pre>
     * Max aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
     *
     * @return Whether the max field is set.
     */
    boolean hasMax();

    /**
     *
     *
     * <pre>
     * Max aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
     *
     * @return The max.
     */
    com.google.bigtable.admin.v2.Type.Aggregate.Max getMax();

    /**
     *
     *
     * <pre>
     * Max aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
     */
    com.google.bigtable.admin.v2.Type.Aggregate.MaxOrBuilder getMaxOrBuilder();

    /**
     *
     *
     * <pre>
     * Min aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
     *
     * @return Whether the min field is set.
     */
    boolean hasMin();

    /**
     *
     *
     * <pre>
     * Min aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
     *
     * @return The min.
     */
    com.google.bigtable.admin.v2.Type.Aggregate.Min getMin();

    /**
     *
     *
     * <pre>
     * Min aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
     */
    com.google.bigtable.admin.v2.Type.Aggregate.MinOrBuilder getMinOrBuilder();

    com.google.bigtable.admin.v2.Type.Aggregate.AggregatorCase getAggregatorCase();
  }

  /**
   *
   *
   * <pre>
   * A value that combines incremental updates into a summarized value.
   *
   * Data is never directly written or read using type `Aggregate`. Writes will
   * provide either the `input_type` or `state_type`, and reads will always
   * return the `state_type` .
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate}
   */
  public static final class Aggregate extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Aggregate)
      AggregateOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Aggregate");
    }

    // Use Aggregate.newBuilder() to construct.
    private Aggregate(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Aggregate() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Aggregate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Aggregate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Aggregate.class,
              com.google.bigtable.admin.v2.Type.Aggregate.Builder.class);
    }

    public interface SumOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Aggregate.Sum)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Computes the sum of the input values.
     * Allowed input: `Int64`
     * State: same as input
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Sum}
     */
    public static final class Sum extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Aggregate.Sum)
        SumOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Sum");
      }

      // Use Sum.newBuilder() to construct.
      private Sum(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Sum() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Aggregate.Sum.class,
                com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Aggregate.Sum)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Aggregate.Sum other =
            (com.google.bigtable.admin.v2.Type.Aggregate.Sum) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Aggregate.Sum prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Computes the sum of the input values.
       * Allowed input: `Int64`
       * State: same as input
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Sum}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Aggregate.Sum)
          com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum.class,
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Aggregate.Sum.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Sum getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Sum build() {
          com.google.bigtable.admin.v2.Type.Aggregate.Sum result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Sum buildPartial() {
          com.google.bigtable.admin.v2.Type.Aggregate.Sum result =
              new com.google.bigtable.admin.v2.Type.Aggregate.Sum(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Aggregate.Sum) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Aggregate.Sum) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Aggregate.Sum other) {
          if (other == com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance())
            return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Aggregate.Sum)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Aggregate.Sum)
      private static final com.google.bigtable.admin.v2.Type.Aggregate.Sum DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Aggregate.Sum();
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Sum> PARSER =
          new com.google.protobuf.AbstractParser<Sum>() {
            @java.lang.Override
            public Sum parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Sum> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Sum> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Sum getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MaxOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Aggregate.Max)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Computes the max of the input values.
     * Allowed input: `Int64`
     * State: same as input
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Max}
     */
    public static final class Max extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Aggregate.Max)
        MaxOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Max");
      }

      // Use Max.newBuilder() to construct.
      private Max(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Max() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Max_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Max_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Aggregate.Max.class,
                com.google.bigtable.admin.v2.Type.Aggregate.Max.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Aggregate.Max)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Aggregate.Max other =
            (com.google.bigtable.admin.v2.Type.Aggregate.Max) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Aggregate.Max prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Computes the max of the input values.
       * Allowed input: `Int64`
       * State: same as input
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Max}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Aggregate.Max)
          com.google.bigtable.admin.v2.Type.Aggregate.MaxOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Max_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Max_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Aggregate.Max.class,
                  com.google.bigtable.admin.v2.Type.Aggregate.Max.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Aggregate.Max.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Max_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Max getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Max build() {
          com.google.bigtable.admin.v2.Type.Aggregate.Max result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Max buildPartial() {
          com.google.bigtable.admin.v2.Type.Aggregate.Max result =
              new com.google.bigtable.admin.v2.Type.Aggregate.Max(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Aggregate.Max) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Aggregate.Max) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Aggregate.Max other) {
          if (other == com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance())
            return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Aggregate.Max)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Aggregate.Max)
      private static final com.google.bigtable.admin.v2.Type.Aggregate.Max DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Aggregate.Max();
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Max getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Max> PARSER =
          new com.google.protobuf.AbstractParser<Max>() {
            @java.lang.Override
            public Max parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Max> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Max> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Max getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MinOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Aggregate.Min)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Computes the min of the input values.
     * Allowed input: `Int64`
     * State: same as input
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Min}
     */
    public static final class Min extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Aggregate.Min)
        MinOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Min");
      }

      // Use Min.newBuilder() to construct.
      private Min(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private Min() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Min_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Min_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Aggregate.Min.class,
                com.google.bigtable.admin.v2.Type.Aggregate.Min.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Aggregate.Min)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Aggregate.Min other =
            (com.google.bigtable.admin.v2.Type.Aggregate.Min) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Aggregate.Min prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Computes the min of the input values.
       * Allowed input: `Int64`
       * State: same as input
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Min}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Aggregate.Min)
          com.google.bigtable.admin.v2.Type.Aggregate.MinOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Min_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Min_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Aggregate.Min.class,
                  com.google.bigtable.admin.v2.Type.Aggregate.Min.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Aggregate.Min.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Min_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Min getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Min build() {
          com.google.bigtable.admin.v2.Type.Aggregate.Min result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Min buildPartial() {
          com.google.bigtable.admin.v2.Type.Aggregate.Min result =
              new com.google.bigtable.admin.v2.Type.Aggregate.Min(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Aggregate.Min) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Aggregate.Min) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Aggregate.Min other) {
          if (other == com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance())
            return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Aggregate.Min)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Aggregate.Min)
      private static final com.google.bigtable.admin.v2.Type.Aggregate.Min DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Aggregate.Min();
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Min getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Min> PARSER =
          new com.google.protobuf.AbstractParser<Min>() {
            @java.lang.Override
            public Min parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Min> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Min> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Min getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface HyperLogLogPlusPlusUniqueCountOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Computes an approximate unique count over the input values. When using
     * raw data as input, be careful to use a consistent encoding. Otherwise
     * the same value encoded differently could count more than once, or two
     * distinct values could count as identical.
     * Input: Any, or omit for Raw
     * State: TBD
     * Special state conversions: `Int64` (the unique count estimate)
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount}
     */
    public static final class HyperLogLogPlusPlusUniqueCount
        extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
        HyperLogLogPlusPlusUniqueCountOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "HyperLogLogPlusPlusUniqueCount");
      }

      // Use HyperLogLogPlusPlusUniqueCount.newBuilder() to construct.
      private HyperLogLogPlusPlusUniqueCount(
          com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private HyperLogLogPlusPlusUniqueCount() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_HyperLogLogPlusPlusUniqueCount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_HyperLogLogPlusPlusUniqueCount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.class,
                com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.Builder
                    .class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount other =
            (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Computes an approximate unique count over the input values. When using
       * raw data as input, be careful to use a consistent encoding. Otherwise
       * the same value encoded differently could count more than once, or two
       * distinct values could count as identical.
       * Input: Any, or omit for Raw
       * State: TBD
       * Special state conversions: `Int64` (the unique count estimate)
       * </pre>
       *
       * Protobuf type {@code
       * google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
          com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCountOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_HyperLogLogPlusPlusUniqueCount_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_HyperLogLogPlusPlusUniqueCount_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.class,
                  com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.Builder
                      .class);
        }

        // Construct using
        // com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_HyperLogLogPlusPlusUniqueCount_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
            getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount build() {
          com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
            buildPartial() {
          com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount result =
              new com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount) {
            return mergeFrom(
                (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount other) {
          if (other
              == com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
      private static final com.google.bigtable.admin.v2.Type.Aggregate
              .HyperLogLogPlusPlusUniqueCount
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount();
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<HyperLogLogPlusPlusUniqueCount> PARSER =
          new com.google.protobuf.AbstractParser<HyperLogLogPlusPlusUniqueCount>() {
            @java.lang.Override
            public HyperLogLogPlusPlusUniqueCount parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<HyperLogLogPlusPlusUniqueCount> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<HyperLogLogPlusPlusUniqueCount> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int aggregatorCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object aggregator_;

    public enum AggregatorCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SUM(4),
      HLLPP_UNIQUE_COUNT(5),
      MAX(6),
      MIN(7),
      AGGREGATOR_NOT_SET(0);
      private final int value;

      private AggregatorCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AggregatorCase valueOf(int value) {
        return forNumber(value);
      }

      public static AggregatorCase forNumber(int value) {
        switch (value) {
          case 4:
            return SUM;
          case 5:
            return HLLPP_UNIQUE_COUNT;
          case 6:
            return MAX;
          case 7:
            return MIN;
          case 0:
            return AGGREGATOR_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AggregatorCase getAggregatorCase() {
      return AggregatorCase.forNumber(aggregatorCase_);
    }

    public static final int INPUT_TYPE_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type inputType_;

    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return Whether the inputType field is set.
     */
    @java.lang.Override
    public boolean hasInputType() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return The inputType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getInputType() {
      return inputType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : inputType_;
    }

    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.TypeOrBuilder getInputTypeOrBuilder() {
      return inputType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : inputType_;
    }

    public static final int STATE_TYPE_FIELD_NUMBER = 2;
    private com.google.bigtable.admin.v2.Type stateType_;

    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateType field is set.
     */
    @java.lang.Override
    public boolean hasStateType() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getStateType() {
      return stateType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : stateType_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.TypeOrBuilder getStateTypeOrBuilder() {
      return stateType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : stateType_;
    }

    public static final int SUM_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return Whether the sum field is set.
     */
    @java.lang.Override
    public boolean hasSum() {
      return aggregatorCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return The sum.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.Sum getSum() {
      if (aggregatorCase_ == 4) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder getSumOrBuilder() {
      if (aggregatorCase_ == 4) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
    }

    public static final int HLLPP_UNIQUE_COUNT_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * HyperLogLogPlusPlusUniqueCount aggregator.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
     * </code>
     *
     * @return Whether the hllppUniqueCount field is set.
     */
    @java.lang.Override
    public boolean hasHllppUniqueCount() {
      return aggregatorCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * HyperLogLogPlusPlusUniqueCount aggregator.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
     * </code>
     *
     * @return The hllppUniqueCount.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
        getHllppUniqueCount() {
      if (aggregatorCase_ == 5) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
            aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * HyperLogLogPlusPlusUniqueCount aggregator.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCountOrBuilder
        getHllppUniqueCountOrBuilder() {
      if (aggregatorCase_ == 5) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
            aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          .getDefaultInstance();
    }

    public static final int MAX_FIELD_NUMBER = 6;

    /**
     *
     *
     * <pre>
     * Max aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
     *
     * @return Whether the max field is set.
     */
    @java.lang.Override
    public boolean hasMax() {
      return aggregatorCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Max aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
     *
     * @return The max.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.Max getMax() {
      if (aggregatorCase_ == 6) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Max aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.MaxOrBuilder getMaxOrBuilder() {
      if (aggregatorCase_ == 6) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance();
    }

    public static final int MIN_FIELD_NUMBER = 7;

    /**
     *
     *
     * <pre>
     * Min aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
     *
     * @return Whether the min field is set.
     */
    @java.lang.Override
    public boolean hasMin() {
      return aggregatorCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Min aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
     *
     * @return The min.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.Min getMin() {
      if (aggregatorCase_ == 7) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Min aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.MinOrBuilder getMinOrBuilder() {
      if (aggregatorCase_ == 7) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getInputType());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getStateType());
      }
      if (aggregatorCase_ == 4) {
        output.writeMessage(4, (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_);
      }
      if (aggregatorCase_ == 5) {
        output.writeMessage(
            5,
            (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
                aggregator_);
      }
      if (aggregatorCase_ == 6) {
        output.writeMessage(6, (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_);
      }
      if (aggregatorCase_ == 7) {
        output.writeMessage(7, (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputType());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStateType());
      }
      if (aggregatorCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_);
      }
      if (aggregatorCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5,
                (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
                    aggregator_);
      }
      if (aggregatorCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_);
      }
      if (aggregatorCase_ == 7) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Aggregate)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Aggregate other =
          (com.google.bigtable.admin.v2.Type.Aggregate) obj;

      if (hasInputType() != other.hasInputType()) return false;
      if (hasInputType()) {
        if (!getInputType().equals(other.getInputType())) return false;
      }
      if (hasStateType() != other.hasStateType()) return false;
      if (hasStateType()) {
        if (!getStateType().equals(other.getStateType())) return false;
      }
      if (!getAggregatorCase().equals(other.getAggregatorCase())) return false;
      switch (aggregatorCase_) {
        case 4:
          if (!getSum().equals(other.getSum())) return false;
          break;
        case 5:
          if (!getHllppUniqueCount().equals(other.getHllppUniqueCount())) return false;
          break;
        case 6:
          if (!getMax().equals(other.getMax())) return false;
          break;
        case 7:
          if (!getMin().equals(other.getMin())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasInputType()) {
        hash = (37 * hash) + INPUT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getInputType().hashCode();
      }
      if (hasStateType()) {
        hash = (37 * hash) + STATE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getStateType().hashCode();
      }
      switch (aggregatorCase_) {
        case 4:
          hash = (37 * hash) + SUM_FIELD_NUMBER;
          hash = (53 * hash) + getSum().hashCode();
          break;
        case 5:
          hash = (37 * hash) + HLLPP_UNIQUE_COUNT_FIELD_NUMBER;
          hash = (53 * hash) + getHllppUniqueCount().hashCode();
          break;
        case 6:
          hash = (37 * hash) + MAX_FIELD_NUMBER;
          hash = (53 * hash) + getMax().hashCode();
          break;
        case 7:
          hash = (37 * hash) + MIN_FIELD_NUMBER;
          hash = (53 * hash) + getMin().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Aggregate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A value that combines incremental updates into a summarized value.
     *
     * Data is never directly written or read using type `Aggregate`. Writes will
     * provide either the `input_type` or `state_type`, and reads will always
     * return the `state_type` .
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Aggregate)
        com.google.bigtable.admin.v2.Type.AggregateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Aggregate.class,
                com.google.bigtable.admin.v2.Type.Aggregate.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Aggregate.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetInputTypeFieldBuilder();
          internalGetStateTypeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        inputType_ = null;
        if (inputTypeBuilder_ != null) {
          inputTypeBuilder_.dispose();
          inputTypeBuilder_ = null;
        }
        stateType_ = null;
        if (stateTypeBuilder_ != null) {
          stateTypeBuilder_.dispose();
          stateTypeBuilder_ = null;
        }
        if (sumBuilder_ != null) {
          sumBuilder_.clear();
        }
        if (hllppUniqueCountBuilder_ != null) {
          hllppUniqueCountBuilder_.clear();
        }
        if (maxBuilder_ != null) {
          maxBuilder_.clear();
        }
        if (minBuilder_ != null) {
          minBuilder_.clear();
        }
        aggregatorCase_ = 0;
        aggregator_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate build() {
        com.google.bigtable.admin.v2.Type.Aggregate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate buildPartial() {
        com.google.bigtable.admin.v2.Type.Aggregate result =
            new com.google.bigtable.admin.v2.Type.Aggregate(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Aggregate result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.inputType_ = inputTypeBuilder_ == null ? inputType_ : inputTypeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stateType_ = stateTypeBuilder_ == null ? stateType_ : stateTypeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.Aggregate result) {
        result.aggregatorCase_ = aggregatorCase_;
        result.aggregator_ = this.aggregator_;
        if (aggregatorCase_ == 4 && sumBuilder_ != null) {
          result.aggregator_ = sumBuilder_.build();
        }
        if (aggregatorCase_ == 5 && hllppUniqueCountBuilder_ != null) {
          result.aggregator_ = hllppUniqueCountBuilder_.build();
        }
        if (aggregatorCase_ == 6 && maxBuilder_ != null) {
          result.aggregator_ = maxBuilder_.build();
        }
        if (aggregatorCase_ == 7 && minBuilder_ != null) {
          result.aggregator_ = minBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Aggregate) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Aggregate) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Aggregate other) {
        if (other == com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance()) return this;
        if (other.hasInputType()) {
          mergeInputType(other.getInputType());
        }
        if (other.hasStateType()) {
          mergeStateType(other.getStateType());
        }
        switch (other.getAggregatorCase()) {
          case SUM:
            {
              mergeSum(other.getSum());
              break;
            }
          case HLLPP_UNIQUE_COUNT:
            {
              mergeHllppUniqueCount(other.getHllppUniqueCount());
              break;
            }
          case MAX:
            {
              mergeMax(other.getMax());
              break;
            }
          case MIN:
            {
              mergeMin(other.getMin());
              break;
            }
          case AGGREGATOR_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetInputTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      internalGetStateTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 34:
                {
                  input.readMessage(internalGetSumFieldBuilder().getBuilder(), extensionRegistry);
                  aggregatorCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      internalGetHllppUniqueCountFieldBuilder().getBuilder(), extensionRegistry);
                  aggregatorCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(internalGetMaxFieldBuilder().getBuilder(), extensionRegistry);
                  aggregatorCase_ = 6;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(internalGetMinFieldBuilder().getBuilder(), extensionRegistry);
                  aggregatorCase_ = 7;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int aggregatorCase_ = 0;
      private java.lang.Object aggregator_;

      public AggregatorCase getAggregatorCase() {
        return AggregatorCase.forNumber(aggregatorCase_);
      }

      public Builder clearAggregator() {
        aggregatorCase_ = 0;
        aggregator_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type inputType_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          inputTypeBuilder_;

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       *
       * @return Whether the inputType field is set.
       */
      public boolean hasInputType() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       *
       * @return The inputType.
       */
      public com.google.bigtable.admin.v2.Type getInputType() {
        if (inputTypeBuilder_ == null) {
          return inputType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : inputType_;
        } else {
          return inputTypeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder setInputType(com.google.bigtable.admin.v2.Type value) {
        if (inputTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputType_ = value;
        } else {
          inputTypeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder setInputType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
        if (inputTypeBuilder_ == null) {
          inputType_ = builderForValue.build();
        } else {
          inputTypeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder mergeInputType(com.google.bigtable.admin.v2.Type value) {
        if (inputTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && inputType_ != null
              && inputType_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
            getInputTypeBuilder().mergeFrom(value);
          } else {
            inputType_ = value;
          }
        } else {
          inputTypeBuilder_.mergeFrom(value);
        }
        if (inputType_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder clearInputType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        inputType_ = null;
        if (inputTypeBuilder_ != null) {
          inputTypeBuilder_.dispose();
          inputTypeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Builder getInputTypeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetInputTypeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.TypeOrBuilder getInputTypeOrBuilder() {
        if (inputTypeBuilder_ != null) {
          return inputTypeBuilder_.getMessageOrBuilder();
        } else {
          return inputType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : inputType_;
        }
      }

      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          internalGetInputTypeFieldBuilder() {
        if (inputTypeBuilder_ == null) {
          inputTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type,
                  com.google.bigtable.admin.v2.Type.Builder,
                  com.google.bigtable.admin.v2.TypeOrBuilder>(
                  getInputType(), getParentForChildren(), isClean());
          inputType_ = null;
        }
        return inputTypeBuilder_;
      }

      private com.google.bigtable.admin.v2.Type stateType_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          stateTypeBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the stateType field is set.
       */
      public boolean hasStateType() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The stateType.
       */
      public com.google.bigtable.admin.v2.Type getStateType() {
        if (stateTypeBuilder_ == null) {
          return stateType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : stateType_;
        } else {
          return stateTypeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateType(com.google.bigtable.admin.v2.Type value) {
        if (stateTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stateType_ = value;
        } else {
          stateTypeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
        if (stateTypeBuilder_ == null) {
          stateType_ = builderForValue.build();
        } else {
          stateTypeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeStateType(com.google.bigtable.admin.v2.Type value) {
        if (stateTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && stateType_ != null
              && stateType_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
            getStateTypeBuilder().mergeFrom(value);
          } else {
            stateType_ = value;
          }
        } else {
          stateTypeBuilder_.mergeFrom(value);
        }
        if (stateType_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearStateType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        stateType_ = null;
        if (stateTypeBuilder_ != null) {
          stateTypeBuilder_.dispose();
          stateTypeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.Type.Builder getStateTypeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetStateTypeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.TypeOrBuilder getStateTypeOrBuilder() {
        if (stateTypeBuilder_ != null) {
          return stateTypeBuilder_.getMessageOrBuilder();
        } else {
          return stateType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : stateType_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          internalGetStateTypeFieldBuilder() {
        if (stateTypeBuilder_ == null) {
          stateTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type,
                  com.google.bigtable.admin.v2.Type.Builder,
                  com.google.bigtable.admin.v2.TypeOrBuilder>(
                  getStateType(), getParentForChildren(), isClean());
          stateType_ = null;
        }
        return stateTypeBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.Sum,
              com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder>
          sumBuilder_;

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       *
       * @return Whether the sum field is set.
       */
      @java.lang.Override
      public boolean hasSum() {
        return aggregatorCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       *
       * @return The sum.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Sum getSum() {
        if (sumBuilder_ == null) {
          if (aggregatorCase_ == 4) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        } else {
          if (aggregatorCase_ == 4) {
            return sumBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder setSum(com.google.bigtable.admin.v2.Type.Aggregate.Sum value) {
        if (sumBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          aggregator_ = value;
          onChanged();
        } else {
          sumBuilder_.setMessage(value);
        }
        aggregatorCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder setSum(
          com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder builderForValue) {
        if (sumBuilder_ == null) {
          aggregator_ = builderForValue.build();
          onChanged();
        } else {
          sumBuilder_.setMessage(builderForValue.build());
        }
        aggregatorCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder mergeSum(com.google.bigtable.admin.v2.Type.Aggregate.Sum value) {
        if (sumBuilder_ == null) {
          if (aggregatorCase_ == 4
              && aggregator_
                  != com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance()) {
            aggregator_ =
                com.google.bigtable.admin.v2.Type.Aggregate.Sum.newBuilder(
                        (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            aggregator_ = value;
          }
          onChanged();
        } else {
          if (aggregatorCase_ == 4) {
            sumBuilder_.mergeFrom(value);
          } else {
            sumBuilder_.setMessage(value);
          }
        }
        aggregatorCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder clearSum() {
        if (sumBuilder_ == null) {
          if (aggregatorCase_ == 4) {
            aggregatorCase_ = 0;
            aggregator_ = null;
            onChanged();
          }
        } else {
          if (aggregatorCase_ == 4) {
            aggregatorCase_ = 0;
            aggregator_ = null;
          }
          sumBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder getSumBuilder() {
        return internalGetSumFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder getSumOrBuilder() {
        if ((aggregatorCase_ == 4) && (sumBuilder_ != null)) {
          return sumBuilder_.getMessageOrBuilder();
        } else {
          if (aggregatorCase_ == 4) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.Sum,
              com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder>
          internalGetSumFieldBuilder() {
        if (sumBuilder_ == null) {
          if (!(aggregatorCase_ == 4)) {
            aggregator_ = com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
          }
          sumBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum,
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder,
                  com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder>(
                  (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_,
                  getParentForChildren(),
                  isClean());
          aggregator_ = null;
        }
        aggregatorCase_ = 4;
        onChanged();
        return sumBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount,
              com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCountOrBuilder>
          hllppUniqueCountBuilder_;

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       *
       * @return Whether the hllppUniqueCount field is set.
       */
      @java.lang.Override
      public boolean hasHllppUniqueCount() {
        return aggregatorCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       *
       * @return The hllppUniqueCount.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
          getHllppUniqueCount() {
        if (hllppUniqueCountBuilder_ == null) {
          if (aggregatorCase_ == 5) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
                aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
              .getDefaultInstance();
        } else {
          if (aggregatorCase_ == 5) {
            return hllppUniqueCountBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       */
      public Builder setHllppUniqueCount(
          com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount value) {
        if (hllppUniqueCountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          aggregator_ = value;
          onChanged();
        } else {
          hllppUniqueCountBuilder_.setMessage(value);
        }
        aggregatorCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       */
      public Builder setHllppUniqueCount(
          com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.Builder
              builderForValue) {
        if (hllppUniqueCountBuilder_ == null) {
          aggregator_ = builderForValue.build();
          onChanged();
        } else {
          hllppUniqueCountBuilder_.setMessage(builderForValue.build());
        }
        aggregatorCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       */
      public Builder mergeHllppUniqueCount(
          com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount value) {
        if (hllppUniqueCountBuilder_ == null) {
          if (aggregatorCase_ == 5
              && aggregator_
                  != com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
                      .getDefaultInstance()) {
            aggregator_ =
                com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
                    .newBuilder(
                        (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
                            aggregator_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            aggregator_ = value;
          }
          onChanged();
        } else {
          if (aggregatorCase_ == 5) {
            hllppUniqueCountBuilder_.mergeFrom(value);
          } else {
            hllppUniqueCountBuilder_.setMessage(value);
          }
        }
        aggregatorCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       */
      public Builder clearHllppUniqueCount() {
        if (hllppUniqueCountBuilder_ == null) {
          if (aggregatorCase_ == 5) {
            aggregatorCase_ = 0;
            aggregator_ = null;
            onChanged();
          }
        } else {
          if (aggregatorCase_ == 5) {
            aggregatorCase_ = 0;
            aggregator_ = null;
          }
          hllppUniqueCountBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       */
      public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.Builder
          getHllppUniqueCountBuilder() {
        return internalGetHllppUniqueCountFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCountOrBuilder
          getHllppUniqueCountOrBuilder() {
        if ((aggregatorCase_ == 5) && (hllppUniqueCountBuilder_ != null)) {
          return hllppUniqueCountBuilder_.getMessageOrBuilder();
        } else {
          if (aggregatorCase_ == 5) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
                aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * HyperLogLogPlusPlusUniqueCount aggregator.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount hllpp_unique_count = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount,
              com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCountOrBuilder>
          internalGetHllppUniqueCountFieldBuilder() {
        if (hllppUniqueCountBuilder_ == null) {
          if (!(aggregatorCase_ == 5)) {
            aggregator_ =
                com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
                    .getDefaultInstance();
          }
          hllppUniqueCountBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount,
                  com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount
                      .Builder,
                  com.google.bigtable.admin.v2.Type.Aggregate
                      .HyperLogLogPlusPlusUniqueCountOrBuilder>(
                  (com.google.bigtable.admin.v2.Type.Aggregate.HyperLogLogPlusPlusUniqueCount)
                      aggregator_,
                  getParentForChildren(),
                  isClean());
          aggregator_ = null;
        }
        aggregatorCase_ = 5;
        onChanged();
        return hllppUniqueCountBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.Max,
              com.google.bigtable.admin.v2.Type.Aggregate.Max.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.MaxOrBuilder>
          maxBuilder_;

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       *
       * @return Whether the max field is set.
       */
      @java.lang.Override
      public boolean hasMax() {
        return aggregatorCase_ == 6;
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       *
       * @return The max.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Max getMax() {
        if (maxBuilder_ == null) {
          if (aggregatorCase_ == 6) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance();
        } else {
          if (aggregatorCase_ == 6) {
            return maxBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       */
      public Builder setMax(com.google.bigtable.admin.v2.Type.Aggregate.Max value) {
        if (maxBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          aggregator_ = value;
          onChanged();
        } else {
          maxBuilder_.setMessage(value);
        }
        aggregatorCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       */
      public Builder setMax(
          com.google.bigtable.admin.v2.Type.Aggregate.Max.Builder builderForValue) {
        if (maxBuilder_ == null) {
          aggregator_ = builderForValue.build();
          onChanged();
        } else {
          maxBuilder_.setMessage(builderForValue.build());
        }
        aggregatorCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       */
      public Builder mergeMax(com.google.bigtable.admin.v2.Type.Aggregate.Max value) {
        if (maxBuilder_ == null) {
          if (aggregatorCase_ == 6
              && aggregator_
                  != com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance()) {
            aggregator_ =
                com.google.bigtable.admin.v2.Type.Aggregate.Max.newBuilder(
                        (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            aggregator_ = value;
          }
          onChanged();
        } else {
          if (aggregatorCase_ == 6) {
            maxBuilder_.mergeFrom(value);
          } else {
            maxBuilder_.setMessage(value);
          }
        }
        aggregatorCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       */
      public Builder clearMax() {
        if (maxBuilder_ == null) {
          if (aggregatorCase_ == 6) {
            aggregatorCase_ = 0;
            aggregator_ = null;
            onChanged();
          }
        } else {
          if (aggregatorCase_ == 6) {
            aggregatorCase_ = 0;
            aggregator_ = null;
          }
          maxBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       */
      public com.google.bigtable.admin.v2.Type.Aggregate.Max.Builder getMaxBuilder() {
        return internalGetMaxFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.MaxOrBuilder getMaxOrBuilder() {
        if ((aggregatorCase_ == 6) && (maxBuilder_ != null)) {
          return maxBuilder_.getMessageOrBuilder();
        } else {
          if (aggregatorCase_ == 6) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Max aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Max max = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.Max,
              com.google.bigtable.admin.v2.Type.Aggregate.Max.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.MaxOrBuilder>
          internalGetMaxFieldBuilder() {
        if (maxBuilder_ == null) {
          if (!(aggregatorCase_ == 6)) {
            aggregator_ = com.google.bigtable.admin.v2.Type.Aggregate.Max.getDefaultInstance();
          }
          maxBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Aggregate.Max,
                  com.google.bigtable.admin.v2.Type.Aggregate.Max.Builder,
                  com.google.bigtable.admin.v2.Type.Aggregate.MaxOrBuilder>(
                  (com.google.bigtable.admin.v2.Type.Aggregate.Max) aggregator_,
                  getParentForChildren(),
                  isClean());
          aggregator_ = null;
        }
        aggregatorCase_ = 6;
        onChanged();
        return maxBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.Min,
              com.google.bigtable.admin.v2.Type.Aggregate.Min.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.MinOrBuilder>
          minBuilder_;

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       *
       * @return Whether the min field is set.
       */
      @java.lang.Override
      public boolean hasMin() {
        return aggregatorCase_ == 7;
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       *
       * @return The min.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Min getMin() {
        if (minBuilder_ == null) {
          if (aggregatorCase_ == 7) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance();
        } else {
          if (aggregatorCase_ == 7) {
            return minBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       */
      public Builder setMin(com.google.bigtable.admin.v2.Type.Aggregate.Min value) {
        if (minBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          aggregator_ = value;
          onChanged();
        } else {
          minBuilder_.setMessage(value);
        }
        aggregatorCase_ = 7;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       */
      public Builder setMin(
          com.google.bigtable.admin.v2.Type.Aggregate.Min.Builder builderForValue) {
        if (minBuilder_ == null) {
          aggregator_ = builderForValue.build();
          onChanged();
        } else {
          minBuilder_.setMessage(builderForValue.build());
        }
        aggregatorCase_ = 7;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       */
      public Builder mergeMin(com.google.bigtable.admin.v2.Type.Aggregate.Min value) {
        if (minBuilder_ == null) {
          if (aggregatorCase_ == 7
              && aggregator_
                  != com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance()) {
            aggregator_ =
                com.google.bigtable.admin.v2.Type.Aggregate.Min.newBuilder(
                        (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            aggregator_ = value;
          }
          onChanged();
        } else {
          if (aggregatorCase_ == 7) {
            minBuilder_.mergeFrom(value);
          } else {
            minBuilder_.setMessage(value);
          }
        }
        aggregatorCase_ = 7;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       */
      public Builder clearMin() {
        if (minBuilder_ == null) {
          if (aggregatorCase_ == 7) {
            aggregatorCase_ = 0;
            aggregator_ = null;
            onChanged();
          }
        } else {
          if (aggregatorCase_ == 7) {
            aggregatorCase_ = 0;
            aggregator_ = null;
          }
          minBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       */
      public com.google.bigtable.admin.v2.Type.Aggregate.Min.Builder getMinBuilder() {
        return internalGetMinFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.MinOrBuilder getMinOrBuilder() {
        if ((aggregatorCase_ == 7) && (minBuilder_ != null)) {
          return minBuilder_.getMessageOrBuilder();
        } else {
          if (aggregatorCase_ == 7) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Min aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Min min = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.bigtable.admin.v2.Type.Aggregate.Min,
              com.google.bigtable.admin.v2.Type.Aggregate.Min.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.MinOrBuilder>
          internalGetMinFieldBuilder() {
        if (minBuilder_ == null) {
          if (!(aggregatorCase_ == 7)) {
            aggregator_ = com.google.bigtable.admin.v2.Type.Aggregate.Min.getDefaultInstance();
          }
          minBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.bigtable.admin.v2.Type.Aggregate.Min,
                  com.google.bigtable.admin.v2.Type.Aggregate.Min.Builder,
                  com.google.bigtable.admin.v2.Type.Aggregate.MinOrBuilder>(
                  (com.google.bigtable.admin.v2.Type.Aggregate.Min) aggregator_,
                  getParentForChildren(),
                  isClean());
          aggregator_ = null;
        }
        aggregatorCase_ = 7;
        onChanged();
        return minBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Aggregate)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Aggregate)
    private static final com.google.bigtable.admin.v2.Type.Aggregate DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Aggregate();
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Aggregate> PARSER =
        new com.google.protobuf.AbstractParser<Aggregate>() {
          @java.lang.Override
          public Aggregate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Aggregate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Aggregate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int kindCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object kind_;

  public enum KindCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BYTES_TYPE(1),
    STRING_TYPE(2),
    INT64_TYPE(5),
    FLOAT32_TYPE(12),
    FLOAT64_TYPE(9),
    BOOL_TYPE(8),
    TIMESTAMP_TYPE(10),
    DATE_TYPE(11),
    AGGREGATE_TYPE(6),
    STRUCT_TYPE(7),
    ARRAY_TYPE(3),
    MAP_TYPE(4),
    PROTO_TYPE(13),
    ENUM_TYPE(14),
    KIND_NOT_SET(0);
    private final int value;

    private KindCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KindCase valueOf(int value) {
      return forNumber(value);
    }

    public static KindCase forNumber(int value) {
      switch (value) {
        case 1:
          return BYTES_TYPE;
        case 2:
          return STRING_TYPE;
        case 5:
          return INT64_TYPE;
        case 12:
          return FLOAT32_TYPE;
        case 9:
          return FLOAT64_TYPE;
        case 8:
          return BOOL_TYPE;
        case 10:
          return TIMESTAMP_TYPE;
        case 11:
          return DATE_TYPE;
        case 6:
          return AGGREGATE_TYPE;
        case 7:
          return STRUCT_TYPE;
        case 3:
          return ARRAY_TYPE;
        case 4:
          return MAP_TYPE;
        case 13:
          return PROTO_TYPE;
        case 14:
          return ENUM_TYPE;
        case 0:
          return KIND_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public KindCase getKindCase() {
    return KindCase.forNumber(kindCase_);
  }

  public static final int BYTES_TYPE_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Bytes
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
   *
   * @return Whether the bytesType field is set.
   */
  @java.lang.Override
  public boolean hasBytesType() {
    return kindCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Bytes
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
   *
   * @return The bytesType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
    if (kindCase_ == 1) {
      return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Bytes
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
    if (kindCase_ == 1) {
      return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
  }

  public static final int STRING_TYPE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * String
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
   *
   * @return Whether the stringType field is set.
   */
  @java.lang.Override
  public boolean hasStringType() {
    return kindCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * String
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
   *
   * @return The stringType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.String getStringType() {
    if (kindCase_ == 2) {
      return (com.google.bigtable.admin.v2.Type.String) kind_;
    }
    return com.google.bigtable.admin.v2.Type.String.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * String
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.StringOrBuilder getStringTypeOrBuilder() {
    if (kindCase_ == 2) {
      return (com.google.bigtable.admin.v2.Type.String) kind_;
    }
    return com.google.bigtable.admin.v2.Type.String.getDefaultInstance();
  }

  public static final int INT64_TYPE_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Int64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
   *
   * @return Whether the int64Type field is set.
   */
  @java.lang.Override
  public boolean hasInt64Type() {
    return kindCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Int64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
   *
   * @return The int64Type.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Int64 getInt64Type() {
    if (kindCase_ == 5) {
      return (com.google.bigtable.admin.v2.Type.Int64) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Int64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Int64OrBuilder getInt64TypeOrBuilder() {
    if (kindCase_ == 5) {
      return (com.google.bigtable.admin.v2.Type.Int64) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
  }

  public static final int FLOAT32_TYPE_FIELD_NUMBER = 12;

  /**
   *
   *
   * <pre>
   * Float32
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
   *
   * @return Whether the float32Type field is set.
   */
  @java.lang.Override
  public boolean hasFloat32Type() {
    return kindCase_ == 12;
  }

  /**
   *
   *
   * <pre>
   * Float32
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
   *
   * @return The float32Type.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Float32 getFloat32Type() {
    if (kindCase_ == 12) {
      return (com.google.bigtable.admin.v2.Type.Float32) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Float32
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Float32OrBuilder getFloat32TypeOrBuilder() {
    if (kindCase_ == 12) {
      return (com.google.bigtable.admin.v2.Type.Float32) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance();
  }

  public static final int FLOAT64_TYPE_FIELD_NUMBER = 9;

  /**
   *
   *
   * <pre>
   * Float64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
   *
   * @return Whether the float64Type field is set.
   */
  @java.lang.Override
  public boolean hasFloat64Type() {
    return kindCase_ == 9;
  }

  /**
   *
   *
   * <pre>
   * Float64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
   *
   * @return The float64Type.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Float64 getFloat64Type() {
    if (kindCase_ == 9) {
      return (com.google.bigtable.admin.v2.Type.Float64) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Float64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Float64OrBuilder getFloat64TypeOrBuilder() {
    if (kindCase_ == 9) {
      return (com.google.bigtable.admin.v2.Type.Float64) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance();
  }

  public static final int BOOL_TYPE_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * Bool
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
   *
   * @return Whether the boolType field is set.
   */
  @java.lang.Override
  public boolean hasBoolType() {
    return kindCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * Bool
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
   *
   * @return The boolType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Bool getBoolType() {
    if (kindCase_ == 8) {
      return (com.google.bigtable.admin.v2.Type.Bool) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Bool
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.BoolOrBuilder getBoolTypeOrBuilder() {
    if (kindCase_ == 8) {
      return (com.google.bigtable.admin.v2.Type.Bool) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance();
  }

  public static final int TIMESTAMP_TYPE_FIELD_NUMBER = 10;

  /**
   *
   *
   * <pre>
   * Timestamp
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
   *
   * @return Whether the timestampType field is set.
   */
  @java.lang.Override
  public boolean hasTimestampType() {
    return kindCase_ == 10;
  }

  /**
   *
   *
   * <pre>
   * Timestamp
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
   *
   * @return The timestampType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Timestamp getTimestampType() {
    if (kindCase_ == 10) {
      return (com.google.bigtable.admin.v2.Type.Timestamp) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Timestamp
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.TimestampOrBuilder getTimestampTypeOrBuilder() {
    if (kindCase_ == 10) {
      return (com.google.bigtable.admin.v2.Type.Timestamp) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance();
  }

  public static final int DATE_TYPE_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * Date
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
   *
   * @return Whether the dateType field is set.
   */
  @java.lang.Override
  public boolean hasDateType() {
    return kindCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * Date
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
   *
   * @return The dateType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Date getDateType() {
    if (kindCase_ == 11) {
      return (com.google.bigtable.admin.v2.Type.Date) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Date.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Date
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.DateOrBuilder getDateTypeOrBuilder() {
    if (kindCase_ == 11) {
      return (com.google.bigtable.admin.v2.Type.Date) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Date.getDefaultInstance();
  }

  public static final int AGGREGATE_TYPE_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Aggregate
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
   *
   * @return Whether the aggregateType field is set.
   */
  @java.lang.Override
  public boolean hasAggregateType() {
    return kindCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Aggregate
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
   *
   * @return The aggregateType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Aggregate getAggregateType() {
    if (kindCase_ == 6) {
      return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Aggregate
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.AggregateOrBuilder getAggregateTypeOrBuilder() {
    if (kindCase_ == 6) {
      return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
  }

  public static final int STRUCT_TYPE_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Struct
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
   *
   * @return Whether the structType field is set.
   */
  @java.lang.Override
  public boolean hasStructType() {
    return kindCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Struct
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
   *
   * @return The structType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Struct getStructType() {
    if (kindCase_ == 7) {
      return (com.google.bigtable.admin.v2.Type.Struct) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Struct
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.StructOrBuilder getStructTypeOrBuilder() {
    if (kindCase_ == 7) {
      return (com.google.bigtable.admin.v2.Type.Struct) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance();
  }

  public static final int ARRAY_TYPE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Array
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
   *
   * @return Whether the arrayType field is set.
   */
  @java.lang.Override
  public boolean hasArrayType() {
    return kindCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Array
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
   *
   * @return The arrayType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Array getArrayType() {
    if (kindCase_ == 3) {
      return (com.google.bigtable.admin.v2.Type.Array) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Array.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Array
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.ArrayOrBuilder getArrayTypeOrBuilder() {
    if (kindCase_ == 3) {
      return (com.google.bigtable.admin.v2.Type.Array) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Array.getDefaultInstance();
  }

  public static final int MAP_TYPE_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Map
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
   *
   * @return Whether the mapType field is set.
   */
  @java.lang.Override
  public boolean hasMapType() {
    return kindCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Map
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
   *
   * @return The mapType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Map getMapType() {
    if (kindCase_ == 4) {
      return (com.google.bigtable.admin.v2.Type.Map) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Map.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Map
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.MapOrBuilder getMapTypeOrBuilder() {
    if (kindCase_ == 4) {
      return (com.google.bigtable.admin.v2.Type.Map) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Map.getDefaultInstance();
  }

  public static final int PROTO_TYPE_FIELD_NUMBER = 13;

  /**
   *
   *
   * <pre>
   * Proto
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
   *
   * @return Whether the protoType field is set.
   */
  @java.lang.Override
  public boolean hasProtoType() {
    return kindCase_ == 13;
  }

  /**
   *
   *
   * <pre>
   * Proto
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
   *
   * @return The protoType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Proto getProtoType() {
    if (kindCase_ == 13) {
      return (com.google.bigtable.admin.v2.Type.Proto) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Proto
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.ProtoOrBuilder getProtoTypeOrBuilder() {
    if (kindCase_ == 13) {
      return (com.google.bigtable.admin.v2.Type.Proto) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance();
  }

  public static final int ENUM_TYPE_FIELD_NUMBER = 14;

  /**
   *
   *
   * <pre>
   * Enum
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
   *
   * @return Whether the enumType field is set.
   */
  @java.lang.Override
  public boolean hasEnumType() {
    return kindCase_ == 14;
  }

  /**
   *
   *
   * <pre>
   * Enum
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
   *
   * @return The enumType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Enum getEnumType() {
    if (kindCase_ == 14) {
      return (com.google.bigtable.admin.v2.Type.Enum) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Enum
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.EnumOrBuilder getEnumTypeOrBuilder() {
    if (kindCase_ == 14) {
      return (com.google.bigtable.admin.v2.Type.Enum) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (kindCase_ == 1) {
      output.writeMessage(1, (com.google.bigtable.admin.v2.Type.Bytes) kind_);
    }
    if (kindCase_ == 2) {
      output.writeMessage(2, (com.google.bigtable.admin.v2.Type.String) kind_);
    }
    if (kindCase_ == 3) {
      output.writeMessage(3, (com.google.bigtable.admin.v2.Type.Array) kind_);
    }
    if (kindCase_ == 4) {
      output.writeMessage(4, (com.google.bigtable.admin.v2.Type.Map) kind_);
    }
    if (kindCase_ == 5) {
      output.writeMessage(5, (com.google.bigtable.admin.v2.Type.Int64) kind_);
    }
    if (kindCase_ == 6) {
      output.writeMessage(6, (com.google.bigtable.admin.v2.Type.Aggregate) kind_);
    }
    if (kindCase_ == 7) {
      output.writeMessage(7, (com.google.bigtable.admin.v2.Type.Struct) kind_);
    }
    if (kindCase_ == 8) {
      output.writeMessage(8, (com.google.bigtable.admin.v2.Type.Bool) kind_);
    }
    if (kindCase_ == 9) {
      output.writeMessage(9, (com.google.bigtable.admin.v2.Type.Float64) kind_);
    }
    if (kindCase_ == 10) {
      output.writeMessage(10, (com.google.bigtable.admin.v2.Type.Timestamp) kind_);
    }
    if (kindCase_ == 11) {
      output.writeMessage(11, (com.google.bigtable.admin.v2.Type.Date) kind_);
    }
    if (kindCase_ == 12) {
      output.writeMessage(12, (com.google.bigtable.admin.v2.Type.Float32) kind_);
    }
    if (kindCase_ == 13) {
      output.writeMessage(13, (com.google.bigtable.admin.v2.Type.Proto) kind_);
    }
    if (kindCase_ == 14) {
      output.writeMessage(14, (com.google.bigtable.admin.v2.Type.Enum) kind_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (kindCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.bigtable.admin.v2.Type.Bytes) kind_);
    }
    if (kindCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.bigtable.admin.v2.Type.String) kind_);
    }
    if (kindCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.bigtable.admin.v2.Type.Array) kind_);
    }
    if (kindCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.bigtable.admin.v2.Type.Map) kind_);
    }
    if (kindCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.bigtable.admin.v2.Type.Int64) kind_);
    }
    if (kindCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.bigtable.admin.v2.Type.Aggregate) kind_);
    }
    if (kindCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.bigtable.admin.v2.Type.Struct) kind_);
    }
    if (kindCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.bigtable.admin.v2.Type.Bool) kind_);
    }
    if (kindCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.bigtable.admin.v2.Type.Float64) kind_);
    }
    if (kindCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.bigtable.admin.v2.Type.Timestamp) kind_);
    }
    if (kindCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.bigtable.admin.v2.Type.Date) kind_);
    }
    if (kindCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.bigtable.admin.v2.Type.Float32) kind_);
    }
    if (kindCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.bigtable.admin.v2.Type.Proto) kind_);
    }
    if (kindCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.bigtable.admin.v2.Type.Enum) kind_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.Type)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.Type other = (com.google.bigtable.admin.v2.Type) obj;

    if (!getKindCase().equals(other.getKindCase())) return false;
    switch (kindCase_) {
      case 1:
        if (!getBytesType().equals(other.getBytesType())) return false;
        break;
      case 2:
        if (!getStringType().equals(other.getStringType())) return false;
        break;
      case 5:
        if (!getInt64Type().equals(other.getInt64Type())) return false;
        break;
      case 12:
        if (!getFloat32Type().equals(other.getFloat32Type())) return false;
        break;
      case 9:
        if (!getFloat64Type().equals(other.getFloat64Type())) return false;
        break;
      case 8:
        if (!getBoolType().equals(other.getBoolType())) return false;
        break;
      case 10:
        if (!getTimestampType().equals(other.getTimestampType())) return false;
        break;
      case 11:
        if (!getDateType().equals(other.getDateType())) return false;
        break;
      case 6:
        if (!getAggregateType().equals(other.getAggregateType())) return false;
        break;
      case 7:
        if (!getStructType().equals(other.getStructType())) return false;
        break;
      case 3:
        if (!getArrayType().equals(other.getArrayType())) return false;
        break;
      case 4:
        if (!getMapType().equals(other.getMapType())) return false;
        break;
      case 13:
        if (!getProtoType().equals(other.getProtoType())) return false;
        break;
      case 14:
        if (!getEnumType().equals(other.getEnumType())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (kindCase_) {
      case 1:
        hash = (37 * hash) + BYTES_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getBytesType().hashCode();
        break;
      case 2:
        hash = (37 * hash) + STRING_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getStringType().hashCode();
        break;
      case 5:
        hash = (37 * hash) + INT64_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getInt64Type().hashCode();
        break;
      case 12:
        hash = (37 * hash) + FLOAT32_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getFloat32Type().hashCode();
        break;
      case 9:
        hash = (37 * hash) + FLOAT64_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getFloat64Type().hashCode();
        break;
      case 8:
        hash = (37 * hash) + BOOL_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getBoolType().hashCode();
        break;
      case 10:
        hash = (37 * hash) + TIMESTAMP_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampType().hashCode();
        break;
      case 11:
        hash = (37 * hash) + DATE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getDateType().hashCode();
        break;
      case 6:
        hash = (37 * hash) + AGGREGATE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getAggregateType().hashCode();
        break;
      case 7:
        hash = (37 * hash) + STRUCT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getStructType().hashCode();
        break;
      case 3:
        hash = (37 * hash) + ARRAY_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getArrayType().hashCode();
        break;
      case 4:
        hash = (37 * hash) + MAP_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getMapType().hashCode();
        break;
      case 13:
        hash = (37 * hash) + PROTO_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getProtoType().hashCode();
        break;
      case 14:
        hash = (37 * hash) + ENUM_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getEnumType().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Type parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.Type prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * `Type` represents the type of data that is written to, read from, or stored
   * in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
   * familiarity and consistency across products and features.
   *
   * For compatibility with Bigtable's existing untyped APIs, each `Type` includes
   * an `Encoding` which describes how to convert to or from the underlying data.
   *
   * Each encoding can operate in one of two modes:
   *
   * - Sorted: In this mode, Bigtable guarantees that `Encode(X) &lt;= Encode(Y)`
   * if and only if `X &lt;= Y`. This is useful anywhere sort order is important,
   * for example when encoding keys.
   * - Distinct: In this mode, Bigtable guarantees that if `X != Y` then
   * `Encode(X) != Encode(Y)`. However, the converse is not guaranteed. For
   * example, both "{'foo': '1', 'bar': '2'}" and "{'bar': '2', 'foo': '1'}"
   * are valid encodings of the same JSON value.
   *
   * The API clearly documents which mode is used wherever an encoding can be
   * configured. Each encoding also documents which values are supported in which
   * modes. For example, when encoding INT64 as a numeric STRING, negative numbers
   * cannot be encoded in sorted mode. This is because `INT64(1) &gt; INT64(-1)`, but
   * `STRING("-00001") &gt; STRING("00001")`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type)
      com.google.bigtable.admin.v2.TypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.class,
              com.google.bigtable.admin.v2.Type.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.Type.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bytesTypeBuilder_ != null) {
        bytesTypeBuilder_.clear();
      }
      if (stringTypeBuilder_ != null) {
        stringTypeBuilder_.clear();
      }
      if (int64TypeBuilder_ != null) {
        int64TypeBuilder_.clear();
      }
      if (float32TypeBuilder_ != null) {
        float32TypeBuilder_.clear();
      }
      if (float64TypeBuilder_ != null) {
        float64TypeBuilder_.clear();
      }
      if (boolTypeBuilder_ != null) {
        boolTypeBuilder_.clear();
      }
      if (timestampTypeBuilder_ != null) {
        timestampTypeBuilder_.clear();
      }
      if (dateTypeBuilder_ != null) {
        dateTypeBuilder_.clear();
      }
      if (aggregateTypeBuilder_ != null) {
        aggregateTypeBuilder_.clear();
      }
      if (structTypeBuilder_ != null) {
        structTypeBuilder_.clear();
      }
      if (arrayTypeBuilder_ != null) {
        arrayTypeBuilder_.clear();
      }
      if (mapTypeBuilder_ != null) {
        mapTypeBuilder_.clear();
      }
      if (protoTypeBuilder_ != null) {
        protoTypeBuilder_.clear();
      }
      if (enumTypeBuilder_ != null) {
        enumTypeBuilder_.clear();
      }
      kindCase_ = 0;
      kind_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.Type.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type build() {
      com.google.bigtable.admin.v2.Type result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type buildPartial() {
      com.google.bigtable.admin.v2.Type result = new com.google.bigtable.admin.v2.Type(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.Type result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.admin.v2.Type result) {
      result.kindCase_ = kindCase_;
      result.kind_ = this.kind_;
      if (kindCase_ == 1 && bytesTypeBuilder_ != null) {
        result.kind_ = bytesTypeBuilder_.build();
      }
      if (kindCase_ == 2 && stringTypeBuilder_ != null) {
        result.kind_ = stringTypeBuilder_.build();
      }
      if (kindCase_ == 5 && int64TypeBuilder_ != null) {
        result.kind_ = int64TypeBuilder_.build();
      }
      if (kindCase_ == 12 && float32TypeBuilder_ != null) {
        result.kind_ = float32TypeBuilder_.build();
      }
      if (kindCase_ == 9 && float64TypeBuilder_ != null) {
        result.kind_ = float64TypeBuilder_.build();
      }
      if (kindCase_ == 8 && boolTypeBuilder_ != null) {
        result.kind_ = boolTypeBuilder_.build();
      }
      if (kindCase_ == 10 && timestampTypeBuilder_ != null) {
        result.kind_ = timestampTypeBuilder_.build();
      }
      if (kindCase_ == 11 && dateTypeBuilder_ != null) {
        result.kind_ = dateTypeBuilder_.build();
      }
      if (kindCase_ == 6 && aggregateTypeBuilder_ != null) {
        result.kind_ = aggregateTypeBuilder_.build();
      }
      if (kindCase_ == 7 && structTypeBuilder_ != null) {
        result.kind_ = structTypeBuilder_.build();
      }
      if (kindCase_ == 3 && arrayTypeBuilder_ != null) {
        result.kind_ = arrayTypeBuilder_.build();
      }
      if (kindCase_ == 4 && mapTypeBuilder_ != null) {
        result.kind_ = mapTypeBuilder_.build();
      }
      if (kindCase_ == 13 && protoTypeBuilder_ != null) {
        result.kind_ = protoTypeBuilder_.build();
      }
      if (kindCase_ == 14 && enumTypeBuilder_ != null) {
        result.kind_ = enumTypeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.Type) {
        return mergeFrom((com.google.bigtable.admin.v2.Type) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.Type other) {
      if (other == com.google.bigtable.admin.v2.Type.getDefaultInstance()) return this;
      switch (other.getKindCase()) {
        case BYTES_TYPE:
          {
            mergeBytesType(other.getBytesType());
            break;
          }
        case STRING_TYPE:
          {
            mergeStringType(other.getStringType());
            break;
          }
        case INT64_TYPE:
          {
            mergeInt64Type(other.getInt64Type());
            break;
          }
        case FLOAT32_TYPE:
          {
            mergeFloat32Type(other.getFloat32Type());
            break;
          }
        case FLOAT64_TYPE:
          {
            mergeFloat64Type(other.getFloat64Type());
            break;
          }
        case BOOL_TYPE:
          {
            mergeBoolType(other.getBoolType());
            break;
          }
        case TIMESTAMP_TYPE:
          {
            mergeTimestampType(other.getTimestampType());
            break;
          }
        case DATE_TYPE:
          {
            mergeDateType(other.getDateType());
            break;
          }
        case AGGREGATE_TYPE:
          {
            mergeAggregateType(other.getAggregateType());
            break;
          }
        case STRUCT_TYPE:
          {
            mergeStructType(other.getStructType());
            break;
          }
        case ARRAY_TYPE:
          {
            mergeArrayType(other.getArrayType());
            break;
          }
        case MAP_TYPE:
          {
            mergeMapType(other.getMapType());
            break;
          }
        case PROTO_TYPE:
          {
            mergeProtoType(other.getProtoType());
            break;
          }
        case ENUM_TYPE:
          {
            mergeEnumType(other.getEnumType());
            break;
          }
        case KIND_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    internalGetBytesTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    internalGetStringTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    internalGetArrayTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(internalGetMapTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    internalGetInt64TypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    internalGetAggregateTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    internalGetStructTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    internalGetBoolTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    internalGetFloat64TypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    internalGetTimestampTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    internalGetDateTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    internalGetFloat32TypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    internalGetProtoTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    internalGetEnumTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 14;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public Builder clearKind() {
      kindCase_ = 0;
      kind_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Bytes,
            com.google.bigtable.admin.v2.Type.Bytes.Builder,
            com.google.bigtable.admin.v2.Type.BytesOrBuilder>
        bytesTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     *
     * @return Whether the bytesType field is set.
     */
    @java.lang.Override
    public boolean hasBytesType() {
      return kindCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     *
     * @return The bytesType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
      if (bytesTypeBuilder_ == null) {
        if (kindCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      } else {
        if (kindCase_ == 1) {
          return bytesTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder setBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
      if (bytesTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        bytesTypeBuilder_.setMessage(value);
      }
      kindCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder setBytesType(com.google.bigtable.admin.v2.Type.Bytes.Builder builderForValue) {
      if (bytesTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        bytesTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder mergeBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
      if (bytesTypeBuilder_ == null) {
        if (kindCase_ == 1
            && kind_ != com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Bytes.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Bytes) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 1) {
          bytesTypeBuilder_.mergeFrom(value);
        } else {
          bytesTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder clearBytesType() {
      if (bytesTypeBuilder_ == null) {
        if (kindCase_ == 1) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 1) {
          kindCase_ = 0;
          kind_ = null;
        }
        bytesTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public com.google.bigtable.admin.v2.Type.Bytes.Builder getBytesTypeBuilder() {
      return internalGetBytesTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
      if ((kindCase_ == 1) && (bytesTypeBuilder_ != null)) {
        return bytesTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Bytes,
            com.google.bigtable.admin.v2.Type.Bytes.Builder,
            com.google.bigtable.admin.v2.Type.BytesOrBuilder>
        internalGetBytesTypeFieldBuilder() {
      if (bytesTypeBuilder_ == null) {
        if (!(kindCase_ == 1)) {
          kind_ = com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
        }
        bytesTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Bytes,
                com.google.bigtable.admin.v2.Type.Bytes.Builder,
                com.google.bigtable.admin.v2.Type.BytesOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Bytes) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 1;
      onChanged();
      return bytesTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.String,
            com.google.bigtable.admin.v2.Type.String.Builder,
            com.google.bigtable.admin.v2.Type.StringOrBuilder>
        stringTypeBuilder_;

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     *
     * @return Whether the stringType field is set.
     */
    @java.lang.Override
    public boolean hasStringType() {
      return kindCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     *
     * @return The stringType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.String getStringType() {
      if (stringTypeBuilder_ == null) {
        if (kindCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.String) kind_;
        }
        return com.google.bigtable.admin.v2.Type.String.getDefaultInstance();
      } else {
        if (kindCase_ == 2) {
          return stringTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.String.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     */
    public Builder setStringType(com.google.bigtable.admin.v2.Type.String value) {
      if (stringTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        stringTypeBuilder_.setMessage(value);
      }
      kindCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     */
    public Builder setStringType(com.google.bigtable.admin.v2.Type.String.Builder builderForValue) {
      if (stringTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        stringTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     */
    public Builder mergeStringType(com.google.bigtable.admin.v2.Type.String value) {
      if (stringTypeBuilder_ == null) {
        if (kindCase_ == 2
            && kind_ != com.google.bigtable.admin.v2.Type.String.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.String.newBuilder(
                      (com.google.bigtable.admin.v2.Type.String) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 2) {
          stringTypeBuilder_.mergeFrom(value);
        } else {
          stringTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     */
    public Builder clearStringType() {
      if (stringTypeBuilder_ == null) {
        if (kindCase_ == 2) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 2) {
          kindCase_ = 0;
          kind_ = null;
        }
        stringTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     */
    public com.google.bigtable.admin.v2.Type.String.Builder getStringTypeBuilder() {
      return internalGetStringTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.StringOrBuilder getStringTypeOrBuilder() {
      if ((kindCase_ == 2) && (stringTypeBuilder_ != null)) {
        return stringTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 2) {
          return (com.google.bigtable.admin.v2.Type.String) kind_;
        }
        return com.google.bigtable.admin.v2.Type.String.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * String
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.String string_type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.String,
            com.google.bigtable.admin.v2.Type.String.Builder,
            com.google.bigtable.admin.v2.Type.StringOrBuilder>
        internalGetStringTypeFieldBuilder() {
      if (stringTypeBuilder_ == null) {
        if (!(kindCase_ == 2)) {
          kind_ = com.google.bigtable.admin.v2.Type.String.getDefaultInstance();
        }
        stringTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.String,
                com.google.bigtable.admin.v2.Type.String.Builder,
                com.google.bigtable.admin.v2.Type.StringOrBuilder>(
                (com.google.bigtable.admin.v2.Type.String) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 2;
      onChanged();
      return stringTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Int64,
            com.google.bigtable.admin.v2.Type.Int64.Builder,
            com.google.bigtable.admin.v2.Type.Int64OrBuilder>
        int64TypeBuilder_;

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     *
     * @return Whether the int64Type field is set.
     */
    @java.lang.Override
    public boolean hasInt64Type() {
      return kindCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     *
     * @return The int64Type.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64 getInt64Type() {
      if (int64TypeBuilder_ == null) {
        if (kindCase_ == 5) {
          return (com.google.bigtable.admin.v2.Type.Int64) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      } else {
        if (kindCase_ == 5) {
          return int64TypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder setInt64Type(com.google.bigtable.admin.v2.Type.Int64 value) {
      if (int64TypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        int64TypeBuilder_.setMessage(value);
      }
      kindCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder setInt64Type(com.google.bigtable.admin.v2.Type.Int64.Builder builderForValue) {
      if (int64TypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        int64TypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder mergeInt64Type(com.google.bigtable.admin.v2.Type.Int64 value) {
      if (int64TypeBuilder_ == null) {
        if (kindCase_ == 5
            && kind_ != com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Int64.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Int64) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 5) {
          int64TypeBuilder_.mergeFrom(value);
        } else {
          int64TypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder clearInt64Type() {
      if (int64TypeBuilder_ == null) {
        if (kindCase_ == 5) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 5) {
          kindCase_ = 0;
          kind_ = null;
        }
        int64TypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public com.google.bigtable.admin.v2.Type.Int64.Builder getInt64TypeBuilder() {
      return internalGetInt64TypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64OrBuilder getInt64TypeOrBuilder() {
      if ((kindCase_ == 5) && (int64TypeBuilder_ != null)) {
        return int64TypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 5) {
          return (com.google.bigtable.admin.v2.Type.Int64) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Int64,
            com.google.bigtable.admin.v2.Type.Int64.Builder,
            com.google.bigtable.admin.v2.Type.Int64OrBuilder>
        internalGetInt64TypeFieldBuilder() {
      if (int64TypeBuilder_ == null) {
        if (!(kindCase_ == 5)) {
          kind_ = com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
        }
        int64TypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Int64,
                com.google.bigtable.admin.v2.Type.Int64.Builder,
                com.google.bigtable.admin.v2.Type.Int64OrBuilder>(
                (com.google.bigtable.admin.v2.Type.Int64) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 5;
      onChanged();
      return int64TypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Float32,
            com.google.bigtable.admin.v2.Type.Float32.Builder,
            com.google.bigtable.admin.v2.Type.Float32OrBuilder>
        float32TypeBuilder_;

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     *
     * @return Whether the float32Type field is set.
     */
    @java.lang.Override
    public boolean hasFloat32Type() {
      return kindCase_ == 12;
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     *
     * @return The float32Type.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Float32 getFloat32Type() {
      if (float32TypeBuilder_ == null) {
        if (kindCase_ == 12) {
          return (com.google.bigtable.admin.v2.Type.Float32) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance();
      } else {
        if (kindCase_ == 12) {
          return float32TypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     */
    public Builder setFloat32Type(com.google.bigtable.admin.v2.Type.Float32 value) {
      if (float32TypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        float32TypeBuilder_.setMessage(value);
      }
      kindCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     */
    public Builder setFloat32Type(
        com.google.bigtable.admin.v2.Type.Float32.Builder builderForValue) {
      if (float32TypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        float32TypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     */
    public Builder mergeFloat32Type(com.google.bigtable.admin.v2.Type.Float32 value) {
      if (float32TypeBuilder_ == null) {
        if (kindCase_ == 12
            && kind_ != com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Float32.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Float32) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 12) {
          float32TypeBuilder_.mergeFrom(value);
        } else {
          float32TypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     */
    public Builder clearFloat32Type() {
      if (float32TypeBuilder_ == null) {
        if (kindCase_ == 12) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 12) {
          kindCase_ = 0;
          kind_ = null;
        }
        float32TypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     */
    public com.google.bigtable.admin.v2.Type.Float32.Builder getFloat32TypeBuilder() {
      return internalGetFloat32TypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Float32OrBuilder getFloat32TypeOrBuilder() {
      if ((kindCase_ == 12) && (float32TypeBuilder_ != null)) {
        return float32TypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 12) {
          return (com.google.bigtable.admin.v2.Type.Float32) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Float32
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float32 float32_type = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Float32,
            com.google.bigtable.admin.v2.Type.Float32.Builder,
            com.google.bigtable.admin.v2.Type.Float32OrBuilder>
        internalGetFloat32TypeFieldBuilder() {
      if (float32TypeBuilder_ == null) {
        if (!(kindCase_ == 12)) {
          kind_ = com.google.bigtable.admin.v2.Type.Float32.getDefaultInstance();
        }
        float32TypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Float32,
                com.google.bigtable.admin.v2.Type.Float32.Builder,
                com.google.bigtable.admin.v2.Type.Float32OrBuilder>(
                (com.google.bigtable.admin.v2.Type.Float32) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 12;
      onChanged();
      return float32TypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Float64,
            com.google.bigtable.admin.v2.Type.Float64.Builder,
            com.google.bigtable.admin.v2.Type.Float64OrBuilder>
        float64TypeBuilder_;

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     *
     * @return Whether the float64Type field is set.
     */
    @java.lang.Override
    public boolean hasFloat64Type() {
      return kindCase_ == 9;
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     *
     * @return The float64Type.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Float64 getFloat64Type() {
      if (float64TypeBuilder_ == null) {
        if (kindCase_ == 9) {
          return (com.google.bigtable.admin.v2.Type.Float64) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance();
      } else {
        if (kindCase_ == 9) {
          return float64TypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     */
    public Builder setFloat64Type(com.google.bigtable.admin.v2.Type.Float64 value) {
      if (float64TypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        float64TypeBuilder_.setMessage(value);
      }
      kindCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     */
    public Builder setFloat64Type(
        com.google.bigtable.admin.v2.Type.Float64.Builder builderForValue) {
      if (float64TypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        float64TypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     */
    public Builder mergeFloat64Type(com.google.bigtable.admin.v2.Type.Float64 value) {
      if (float64TypeBuilder_ == null) {
        if (kindCase_ == 9
            && kind_ != com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Float64.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Float64) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 9) {
          float64TypeBuilder_.mergeFrom(value);
        } else {
          float64TypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     */
    public Builder clearFloat64Type() {
      if (float64TypeBuilder_ == null) {
        if (kindCase_ == 9) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 9) {
          kindCase_ = 0;
          kind_ = null;
        }
        float64TypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     */
    public com.google.bigtable.admin.v2.Type.Float64.Builder getFloat64TypeBuilder() {
      return internalGetFloat64TypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Float64OrBuilder getFloat64TypeOrBuilder() {
      if ((kindCase_ == 9) && (float64TypeBuilder_ != null)) {
        return float64TypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 9) {
          return (com.google.bigtable.admin.v2.Type.Float64) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Float64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Float64 float64_type = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Float64,
            com.google.bigtable.admin.v2.Type.Float64.Builder,
            com.google.bigtable.admin.v2.Type.Float64OrBuilder>
        internalGetFloat64TypeFieldBuilder() {
      if (float64TypeBuilder_ == null) {
        if (!(kindCase_ == 9)) {
          kind_ = com.google.bigtable.admin.v2.Type.Float64.getDefaultInstance();
        }
        float64TypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Float64,
                com.google.bigtable.admin.v2.Type.Float64.Builder,
                com.google.bigtable.admin.v2.Type.Float64OrBuilder>(
                (com.google.bigtable.admin.v2.Type.Float64) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 9;
      onChanged();
      return float64TypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Bool,
            com.google.bigtable.admin.v2.Type.Bool.Builder,
            com.google.bigtable.admin.v2.Type.BoolOrBuilder>
        boolTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     *
     * @return Whether the boolType field is set.
     */
    @java.lang.Override
    public boolean hasBoolType() {
      return kindCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     *
     * @return The boolType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bool getBoolType() {
      if (boolTypeBuilder_ == null) {
        if (kindCase_ == 8) {
          return (com.google.bigtable.admin.v2.Type.Bool) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance();
      } else {
        if (kindCase_ == 8) {
          return boolTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     */
    public Builder setBoolType(com.google.bigtable.admin.v2.Type.Bool value) {
      if (boolTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        boolTypeBuilder_.setMessage(value);
      }
      kindCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     */
    public Builder setBoolType(com.google.bigtable.admin.v2.Type.Bool.Builder builderForValue) {
      if (boolTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        boolTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     */
    public Builder mergeBoolType(com.google.bigtable.admin.v2.Type.Bool value) {
      if (boolTypeBuilder_ == null) {
        if (kindCase_ == 8
            && kind_ != com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Bool.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Bool) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 8) {
          boolTypeBuilder_.mergeFrom(value);
        } else {
          boolTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     */
    public Builder clearBoolType() {
      if (boolTypeBuilder_ == null) {
        if (kindCase_ == 8) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 8) {
          kindCase_ = 0;
          kind_ = null;
        }
        boolTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     */
    public com.google.bigtable.admin.v2.Type.Bool.Builder getBoolTypeBuilder() {
      return internalGetBoolTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.BoolOrBuilder getBoolTypeOrBuilder() {
      if ((kindCase_ == 8) && (boolTypeBuilder_ != null)) {
        return boolTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 8) {
          return (com.google.bigtable.admin.v2.Type.Bool) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Bool
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bool bool_type = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Bool,
            com.google.bigtable.admin.v2.Type.Bool.Builder,
            com.google.bigtable.admin.v2.Type.BoolOrBuilder>
        internalGetBoolTypeFieldBuilder() {
      if (boolTypeBuilder_ == null) {
        if (!(kindCase_ == 8)) {
          kind_ = com.google.bigtable.admin.v2.Type.Bool.getDefaultInstance();
        }
        boolTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Bool,
                com.google.bigtable.admin.v2.Type.Bool.Builder,
                com.google.bigtable.admin.v2.Type.BoolOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Bool) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 8;
      onChanged();
      return boolTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Timestamp,
            com.google.bigtable.admin.v2.Type.Timestamp.Builder,
            com.google.bigtable.admin.v2.Type.TimestampOrBuilder>
        timestampTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     *
     * @return Whether the timestampType field is set.
     */
    @java.lang.Override
    public boolean hasTimestampType() {
      return kindCase_ == 10;
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     *
     * @return The timestampType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Timestamp getTimestampType() {
      if (timestampTypeBuilder_ == null) {
        if (kindCase_ == 10) {
          return (com.google.bigtable.admin.v2.Type.Timestamp) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance();
      } else {
        if (kindCase_ == 10) {
          return timestampTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     */
    public Builder setTimestampType(com.google.bigtable.admin.v2.Type.Timestamp value) {
      if (timestampTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        timestampTypeBuilder_.setMessage(value);
      }
      kindCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     */
    public Builder setTimestampType(
        com.google.bigtable.admin.v2.Type.Timestamp.Builder builderForValue) {
      if (timestampTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        timestampTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     */
    public Builder mergeTimestampType(com.google.bigtable.admin.v2.Type.Timestamp value) {
      if (timestampTypeBuilder_ == null) {
        if (kindCase_ == 10
            && kind_ != com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Timestamp.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Timestamp) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 10) {
          timestampTypeBuilder_.mergeFrom(value);
        } else {
          timestampTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     */
    public Builder clearTimestampType() {
      if (timestampTypeBuilder_ == null) {
        if (kindCase_ == 10) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 10) {
          kindCase_ = 0;
          kind_ = null;
        }
        timestampTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     */
    public com.google.bigtable.admin.v2.Type.Timestamp.Builder getTimestampTypeBuilder() {
      return internalGetTimestampTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.TimestampOrBuilder getTimestampTypeOrBuilder() {
      if ((kindCase_ == 10) && (timestampTypeBuilder_ != null)) {
        return timestampTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 10) {
          return (com.google.bigtable.admin.v2.Type.Timestamp) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Timestamp
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Timestamp timestamp_type = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Timestamp,
            com.google.bigtable.admin.v2.Type.Timestamp.Builder,
            com.google.bigtable.admin.v2.Type.TimestampOrBuilder>
        internalGetTimestampTypeFieldBuilder() {
      if (timestampTypeBuilder_ == null) {
        if (!(kindCase_ == 10)) {
          kind_ = com.google.bigtable.admin.v2.Type.Timestamp.getDefaultInstance();
        }
        timestampTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Timestamp,
                com.google.bigtable.admin.v2.Type.Timestamp.Builder,
                com.google.bigtable.admin.v2.Type.TimestampOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Timestamp) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 10;
      onChanged();
      return timestampTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Date,
            com.google.bigtable.admin.v2.Type.Date.Builder,
            com.google.bigtable.admin.v2.Type.DateOrBuilder>
        dateTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     *
     * @return Whether the dateType field is set.
     */
    @java.lang.Override
    public boolean hasDateType() {
      return kindCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     *
     * @return The dateType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Date getDateType() {
      if (dateTypeBuilder_ == null) {
        if (kindCase_ == 11) {
          return (com.google.bigtable.admin.v2.Type.Date) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Date.getDefaultInstance();
      } else {
        if (kindCase_ == 11) {
          return dateTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Date.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     */
    public Builder setDateType(com.google.bigtable.admin.v2.Type.Date value) {
      if (dateTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        dateTypeBuilder_.setMessage(value);
      }
      kindCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     */
    public Builder setDateType(com.google.bigtable.admin.v2.Type.Date.Builder builderForValue) {
      if (dateTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        dateTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     */
    public Builder mergeDateType(com.google.bigtable.admin.v2.Type.Date value) {
      if (dateTypeBuilder_ == null) {
        if (kindCase_ == 11
            && kind_ != com.google.bigtable.admin.v2.Type.Date.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Date.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Date) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 11) {
          dateTypeBuilder_.mergeFrom(value);
        } else {
          dateTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     */
    public Builder clearDateType() {
      if (dateTypeBuilder_ == null) {
        if (kindCase_ == 11) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 11) {
          kindCase_ = 0;
          kind_ = null;
        }
        dateTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     */
    public com.google.bigtable.admin.v2.Type.Date.Builder getDateTypeBuilder() {
      return internalGetDateTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.DateOrBuilder getDateTypeOrBuilder() {
      if ((kindCase_ == 11) && (dateTypeBuilder_ != null)) {
        return dateTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 11) {
          return (com.google.bigtable.admin.v2.Type.Date) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Date.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Date
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Date date_type = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Date,
            com.google.bigtable.admin.v2.Type.Date.Builder,
            com.google.bigtable.admin.v2.Type.DateOrBuilder>
        internalGetDateTypeFieldBuilder() {
      if (dateTypeBuilder_ == null) {
        if (!(kindCase_ == 11)) {
          kind_ = com.google.bigtable.admin.v2.Type.Date.getDefaultInstance();
        }
        dateTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Date,
                com.google.bigtable.admin.v2.Type.Date.Builder,
                com.google.bigtable.admin.v2.Type.DateOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Date) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 11;
      onChanged();
      return dateTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Aggregate,
            com.google.bigtable.admin.v2.Type.Aggregate.Builder,
            com.google.bigtable.admin.v2.Type.AggregateOrBuilder>
        aggregateTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     *
     * @return Whether the aggregateType field is set.
     */
    @java.lang.Override
    public boolean hasAggregateType() {
      return kindCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     *
     * @return The aggregateType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate getAggregateType() {
      if (aggregateTypeBuilder_ == null) {
        if (kindCase_ == 6) {
          return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      } else {
        if (kindCase_ == 6) {
          return aggregateTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder setAggregateType(com.google.bigtable.admin.v2.Type.Aggregate value) {
      if (aggregateTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        aggregateTypeBuilder_.setMessage(value);
      }
      kindCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder setAggregateType(
        com.google.bigtable.admin.v2.Type.Aggregate.Builder builderForValue) {
      if (aggregateTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        aggregateTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder mergeAggregateType(com.google.bigtable.admin.v2.Type.Aggregate value) {
      if (aggregateTypeBuilder_ == null) {
        if (kindCase_ == 6
            && kind_ != com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Aggregate.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Aggregate) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 6) {
          aggregateTypeBuilder_.mergeFrom(value);
        } else {
          aggregateTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder clearAggregateType() {
      if (aggregateTypeBuilder_ == null) {
        if (kindCase_ == 6) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 6) {
          kindCase_ = 0;
          kind_ = null;
        }
        aggregateTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public com.google.bigtable.admin.v2.Type.Aggregate.Builder getAggregateTypeBuilder() {
      return internalGetAggregateTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.AggregateOrBuilder getAggregateTypeOrBuilder() {
      if ((kindCase_ == 6) && (aggregateTypeBuilder_ != null)) {
        return aggregateTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 6) {
          return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Aggregate,
            com.google.bigtable.admin.v2.Type.Aggregate.Builder,
            com.google.bigtable.admin.v2.Type.AggregateOrBuilder>
        internalGetAggregateTypeFieldBuilder() {
      if (aggregateTypeBuilder_ == null) {
        if (!(kindCase_ == 6)) {
          kind_ = com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
        }
        aggregateTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Aggregate,
                com.google.bigtable.admin.v2.Type.Aggregate.Builder,
                com.google.bigtable.admin.v2.Type.AggregateOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Aggregate) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 6;
      onChanged();
      return aggregateTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Struct,
            com.google.bigtable.admin.v2.Type.Struct.Builder,
            com.google.bigtable.admin.v2.Type.StructOrBuilder>
        structTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     *
     * @return Whether the structType field is set.
     */
    @java.lang.Override
    public boolean hasStructType() {
      return kindCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     *
     * @return The structType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Struct getStructType() {
      if (structTypeBuilder_ == null) {
        if (kindCase_ == 7) {
          return (com.google.bigtable.admin.v2.Type.Struct) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance();
      } else {
        if (kindCase_ == 7) {
          return structTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     */
    public Builder setStructType(com.google.bigtable.admin.v2.Type.Struct value) {
      if (structTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        structTypeBuilder_.setMessage(value);
      }
      kindCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     */
    public Builder setStructType(com.google.bigtable.admin.v2.Type.Struct.Builder builderForValue) {
      if (structTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        structTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     */
    public Builder mergeStructType(com.google.bigtable.admin.v2.Type.Struct value) {
      if (structTypeBuilder_ == null) {
        if (kindCase_ == 7
            && kind_ != com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Struct.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Struct) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 7) {
          structTypeBuilder_.mergeFrom(value);
        } else {
          structTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     */
    public Builder clearStructType() {
      if (structTypeBuilder_ == null) {
        if (kindCase_ == 7) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 7) {
          kindCase_ = 0;
          kind_ = null;
        }
        structTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     */
    public com.google.bigtable.admin.v2.Type.Struct.Builder getStructTypeBuilder() {
      return internalGetStructTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.StructOrBuilder getStructTypeOrBuilder() {
      if ((kindCase_ == 7) && (structTypeBuilder_ != null)) {
        return structTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 7) {
          return (com.google.bigtable.admin.v2.Type.Struct) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Struct
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Struct struct_type = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Struct,
            com.google.bigtable.admin.v2.Type.Struct.Builder,
            com.google.bigtable.admin.v2.Type.StructOrBuilder>
        internalGetStructTypeFieldBuilder() {
      if (structTypeBuilder_ == null) {
        if (!(kindCase_ == 7)) {
          kind_ = com.google.bigtable.admin.v2.Type.Struct.getDefaultInstance();
        }
        structTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Struct,
                com.google.bigtable.admin.v2.Type.Struct.Builder,
                com.google.bigtable.admin.v2.Type.StructOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Struct) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 7;
      onChanged();
      return structTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Array,
            com.google.bigtable.admin.v2.Type.Array.Builder,
            com.google.bigtable.admin.v2.Type.ArrayOrBuilder>
        arrayTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     *
     * @return Whether the arrayType field is set.
     */
    @java.lang.Override
    public boolean hasArrayType() {
      return kindCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     *
     * @return The arrayType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Array getArrayType() {
      if (arrayTypeBuilder_ == null) {
        if (kindCase_ == 3) {
          return (com.google.bigtable.admin.v2.Type.Array) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Array.getDefaultInstance();
      } else {
        if (kindCase_ == 3) {
          return arrayTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Array.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     */
    public Builder setArrayType(com.google.bigtable.admin.v2.Type.Array value) {
      if (arrayTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        arrayTypeBuilder_.setMessage(value);
      }
      kindCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     */
    public Builder setArrayType(com.google.bigtable.admin.v2.Type.Array.Builder builderForValue) {
      if (arrayTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        arrayTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     */
    public Builder mergeArrayType(com.google.bigtable.admin.v2.Type.Array value) {
      if (arrayTypeBuilder_ == null) {
        if (kindCase_ == 3
            && kind_ != com.google.bigtable.admin.v2.Type.Array.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Array.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Array) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 3) {
          arrayTypeBuilder_.mergeFrom(value);
        } else {
          arrayTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     */
    public Builder clearArrayType() {
      if (arrayTypeBuilder_ == null) {
        if (kindCase_ == 3) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 3) {
          kindCase_ = 0;
          kind_ = null;
        }
        arrayTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     */
    public com.google.bigtable.admin.v2.Type.Array.Builder getArrayTypeBuilder() {
      return internalGetArrayTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.ArrayOrBuilder getArrayTypeOrBuilder() {
      if ((kindCase_ == 3) && (arrayTypeBuilder_ != null)) {
        return arrayTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 3) {
          return (com.google.bigtable.admin.v2.Type.Array) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Array.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Array
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Array array_type = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Array,
            com.google.bigtable.admin.v2.Type.Array.Builder,
            com.google.bigtable.admin.v2.Type.ArrayOrBuilder>
        internalGetArrayTypeFieldBuilder() {
      if (arrayTypeBuilder_ == null) {
        if (!(kindCase_ == 3)) {
          kind_ = com.google.bigtable.admin.v2.Type.Array.getDefaultInstance();
        }
        arrayTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Array,
                com.google.bigtable.admin.v2.Type.Array.Builder,
                com.google.bigtable.admin.v2.Type.ArrayOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Array) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 3;
      onChanged();
      return arrayTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Map,
            com.google.bigtable.admin.v2.Type.Map.Builder,
            com.google.bigtable.admin.v2.Type.MapOrBuilder>
        mapTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     *
     * @return Whether the mapType field is set.
     */
    @java.lang.Override
    public boolean hasMapType() {
      return kindCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     *
     * @return The mapType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Map getMapType() {
      if (mapTypeBuilder_ == null) {
        if (kindCase_ == 4) {
          return (com.google.bigtable.admin.v2.Type.Map) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Map.getDefaultInstance();
      } else {
        if (kindCase_ == 4) {
          return mapTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Map.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     */
    public Builder setMapType(com.google.bigtable.admin.v2.Type.Map value) {
      if (mapTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        mapTypeBuilder_.setMessage(value);
      }
      kindCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     */
    public Builder setMapType(com.google.bigtable.admin.v2.Type.Map.Builder builderForValue) {
      if (mapTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        mapTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     */
    public Builder mergeMapType(com.google.bigtable.admin.v2.Type.Map value) {
      if (mapTypeBuilder_ == null) {
        if (kindCase_ == 4 && kind_ != com.google.bigtable.admin.v2.Type.Map.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Map.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Map) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 4) {
          mapTypeBuilder_.mergeFrom(value);
        } else {
          mapTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     */
    public Builder clearMapType() {
      if (mapTypeBuilder_ == null) {
        if (kindCase_ == 4) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 4) {
          kindCase_ = 0;
          kind_ = null;
        }
        mapTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     */
    public com.google.bigtable.admin.v2.Type.Map.Builder getMapTypeBuilder() {
      return internalGetMapTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.MapOrBuilder getMapTypeOrBuilder() {
      if ((kindCase_ == 4) && (mapTypeBuilder_ != null)) {
        return mapTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 4) {
          return (com.google.bigtable.admin.v2.Type.Map) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Map.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Map
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Map map_type = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Map,
            com.google.bigtable.admin.v2.Type.Map.Builder,
            com.google.bigtable.admin.v2.Type.MapOrBuilder>
        internalGetMapTypeFieldBuilder() {
      if (mapTypeBuilder_ == null) {
        if (!(kindCase_ == 4)) {
          kind_ = com.google.bigtable.admin.v2.Type.Map.getDefaultInstance();
        }
        mapTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Map,
                com.google.bigtable.admin.v2.Type.Map.Builder,
                com.google.bigtable.admin.v2.Type.MapOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Map) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 4;
      onChanged();
      return mapTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Proto,
            com.google.bigtable.admin.v2.Type.Proto.Builder,
            com.google.bigtable.admin.v2.Type.ProtoOrBuilder>
        protoTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     *
     * @return Whether the protoType field is set.
     */
    @java.lang.Override
    public boolean hasProtoType() {
      return kindCase_ == 13;
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     *
     * @return The protoType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Proto getProtoType() {
      if (protoTypeBuilder_ == null) {
        if (kindCase_ == 13) {
          return (com.google.bigtable.admin.v2.Type.Proto) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance();
      } else {
        if (kindCase_ == 13) {
          return protoTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     */
    public Builder setProtoType(com.google.bigtable.admin.v2.Type.Proto value) {
      if (protoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        protoTypeBuilder_.setMessage(value);
      }
      kindCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     */
    public Builder setProtoType(com.google.bigtable.admin.v2.Type.Proto.Builder builderForValue) {
      if (protoTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        protoTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     */
    public Builder mergeProtoType(com.google.bigtable.admin.v2.Type.Proto value) {
      if (protoTypeBuilder_ == null) {
        if (kindCase_ == 13
            && kind_ != com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Proto.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Proto) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 13) {
          protoTypeBuilder_.mergeFrom(value);
        } else {
          protoTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     */
    public Builder clearProtoType() {
      if (protoTypeBuilder_ == null) {
        if (kindCase_ == 13) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 13) {
          kindCase_ = 0;
          kind_ = null;
        }
        protoTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     */
    public com.google.bigtable.admin.v2.Type.Proto.Builder getProtoTypeBuilder() {
      return internalGetProtoTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.ProtoOrBuilder getProtoTypeOrBuilder() {
      if ((kindCase_ == 13) && (protoTypeBuilder_ != null)) {
        return protoTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 13) {
          return (com.google.bigtable.admin.v2.Type.Proto) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Proto
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Proto proto_type = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Proto,
            com.google.bigtable.admin.v2.Type.Proto.Builder,
            com.google.bigtable.admin.v2.Type.ProtoOrBuilder>
        internalGetProtoTypeFieldBuilder() {
      if (protoTypeBuilder_ == null) {
        if (!(kindCase_ == 13)) {
          kind_ = com.google.bigtable.admin.v2.Type.Proto.getDefaultInstance();
        }
        protoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Proto,
                com.google.bigtable.admin.v2.Type.Proto.Builder,
                com.google.bigtable.admin.v2.Type.ProtoOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Proto) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 13;
      onChanged();
      return protoTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Enum,
            com.google.bigtable.admin.v2.Type.Enum.Builder,
            com.google.bigtable.admin.v2.Type.EnumOrBuilder>
        enumTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     *
     * @return Whether the enumType field is set.
     */
    @java.lang.Override
    public boolean hasEnumType() {
      return kindCase_ == 14;
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     *
     * @return The enumType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Enum getEnumType() {
      if (enumTypeBuilder_ == null) {
        if (kindCase_ == 14) {
          return (com.google.bigtable.admin.v2.Type.Enum) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance();
      } else {
        if (kindCase_ == 14) {
          return enumTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     */
    public Builder setEnumType(com.google.bigtable.admin.v2.Type.Enum value) {
      if (enumTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        enumTypeBuilder_.setMessage(value);
      }
      kindCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     */
    public Builder setEnumType(com.google.bigtable.admin.v2.Type.Enum.Builder builderForValue) {
      if (enumTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        enumTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     */
    public Builder mergeEnumType(com.google.bigtable.admin.v2.Type.Enum value) {
      if (enumTypeBuilder_ == null) {
        if (kindCase_ == 14
            && kind_ != com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Enum.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Enum) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 14) {
          enumTypeBuilder_.mergeFrom(value);
        } else {
          enumTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     */
    public Builder clearEnumType() {
      if (enumTypeBuilder_ == null) {
        if (kindCase_ == 14) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 14) {
          kindCase_ = 0;
          kind_ = null;
        }
        enumTypeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     */
    public com.google.bigtable.admin.v2.Type.Enum.Builder getEnumTypeBuilder() {
      return internalGetEnumTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.EnumOrBuilder getEnumTypeOrBuilder() {
      if ((kindCase_ == 14) && (enumTypeBuilder_ != null)) {
        return enumTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 14) {
          return (com.google.bigtable.admin.v2.Type.Enum) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Enum
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Enum enum_type = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.admin.v2.Type.Enum,
            com.google.bigtable.admin.v2.Type.Enum.Builder,
            com.google.bigtable.admin.v2.Type.EnumOrBuilder>
        internalGetEnumTypeFieldBuilder() {
      if (enumTypeBuilder_ == null) {
        if (!(kindCase_ == 14)) {
          kind_ = com.google.bigtable.admin.v2.Type.Enum.getDefaultInstance();
        }
        enumTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.admin.v2.Type.Enum,
                com.google.bigtable.admin.v2.Type.Enum.Builder,
                com.google.bigtable.admin.v2.Type.EnumOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Enum) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 14;
      onChanged();
      return enumTypeBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type)
  private static final com.google.bigtable.admin.v2.Type DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type();
  }

  public static com.google.bigtable.admin.v2.Type getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Type> PARSER =
      new com.google.protobuf.AbstractParser<Type>() {
        @java.lang.Override
        public Type parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Type> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Type> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.Type getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
