/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/bigtable/v2/bigtable.proto
// Protobuf Java Version: 4.33.2

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * NOTE: This API is intended to be used by Apache Beam BigtableIO.
 * Request message for Bigtable.ReadChangeStream.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.ReadChangeStreamRequest}
 */
@com.google.protobuf.Generated
public final class ReadChangeStreamRequest extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadChangeStreamRequest)
    ReadChangeStreamRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "ReadChangeStreamRequest");
  }

  // Use ReadChangeStreamRequest.newBuilder() to construct.
  private ReadChangeStreamRequest(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private ReadChangeStreamRequest() {
    tableName_ = "";
    appProfileId_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadChangeStreamRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadChangeStreamRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.ReadChangeStreamRequest.class,
            com.google.bigtable.v2.ReadChangeStreamRequest.Builder.class);
  }

  private int bitField0_;
  private int startFromCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object startFrom_;

  public enum StartFromCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    START_TIME(4),
    CONTINUATION_TOKENS(6),
    STARTFROM_NOT_SET(0);
    private final int value;

    private StartFromCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StartFromCase valueOf(int value) {
      return forNumber(value);
    }

    public static StartFromCase forNumber(int value) {
      switch (value) {
        case 4:
          return START_TIME;
        case 6:
          return CONTINUATION_TOKENS;
        case 0:
          return STARTFROM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StartFromCase getStartFromCase() {
    return StartFromCase.forNumber(startFromCase_);
  }

  public static final int TABLE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The unique name of the table from which to read a change stream.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * Change streaming must be enabled on the table.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The unique name of the table from which to read a change stream.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * Change streaming must be enabled on the table.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object appProfileId_ = "";

  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * Single cluster routing must be configured on the profile.
   * </pre>
   *
   * <code>string app_profile_id = 2;</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * Single cluster routing must be configured on the profile.
   * </pre>
   *
   * <code>string app_profile_id = 2;</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTITION_FIELD_NUMBER = 3;
  private com.google.bigtable.v2.StreamPartition partition_;

  /**
   *
   *
   * <pre>
   * The partition to read changes from.
   * </pre>
   *
   * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
   *
   * @return Whether the partition field is set.
   */
  @java.lang.Override
  public boolean hasPartition() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The partition to read changes from.
   * </pre>
   *
   * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
   *
   * @return The partition.
   */
  @java.lang.Override
  public com.google.bigtable.v2.StreamPartition getPartition() {
    return partition_ == null
        ? com.google.bigtable.v2.StreamPartition.getDefaultInstance()
        : partition_;
  }

  /**
   *
   *
   * <pre>
   * The partition to read changes from.
   * </pre>
   *
   * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.StreamPartitionOrBuilder getPartitionOrBuilder() {
    return partition_ == null
        ? com.google.bigtable.v2.StreamPartition.getDefaultInstance()
        : partition_;
  }

  public static final int START_TIME_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Start reading the stream at the specified timestamp. This timestamp must
   * be within the change stream retention period, less than or equal to the
   * current time, and after change stream creation, whichever is greater.
   * This value is inclusive and will be truncated to microsecond granularity.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startFromCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Start reading the stream at the specified timestamp. This timestamp must
   * be within the change stream retention period, less than or equal to the
   * current time, and after change stream creation, whichever is greater.
   * This value is inclusive and will be truncated to microsecond granularity.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    if (startFromCase_ == 4) {
      return (com.google.protobuf.Timestamp) startFrom_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Start reading the stream at the specified timestamp. This timestamp must
   * be within the change stream retention period, less than or equal to the
   * current time, and after change stream creation, whichever is greater.
   * This value is inclusive and will be truncated to microsecond granularity.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    if (startFromCase_ == 4) {
      return (com.google.protobuf.Timestamp) startFrom_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int CONTINUATION_TOKENS_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Tokens that describe how to resume reading a stream where reading
   * previously left off. If specified, changes will be read starting at the
   * the position. Tokens are delivered on the stream as part of `Heartbeat`
   * and `CloseStream` messages.
   *
   * If a single token is provided, the token's partition must exactly match
   * the request's partition. If multiple tokens are provided, as in the case
   * of a partition merge, the union of the token partitions must exactly
   * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
   * returned.
   * </pre>
   *
   * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
   *
   * @return Whether the continuationTokens field is set.
   */
  @java.lang.Override
  public boolean hasContinuationTokens() {
    return startFromCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Tokens that describe how to resume reading a stream where reading
   * previously left off. If specified, changes will be read starting at the
   * the position. Tokens are delivered on the stream as part of `Heartbeat`
   * and `CloseStream` messages.
   *
   * If a single token is provided, the token's partition must exactly match
   * the request's partition. If multiple tokens are provided, as in the case
   * of a partition merge, the union of the token partitions must exactly
   * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
   * returned.
   * </pre>
   *
   * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
   *
   * @return The continuationTokens.
   */
  @java.lang.Override
  public com.google.bigtable.v2.StreamContinuationTokens getContinuationTokens() {
    if (startFromCase_ == 6) {
      return (com.google.bigtable.v2.StreamContinuationTokens) startFrom_;
    }
    return com.google.bigtable.v2.StreamContinuationTokens.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Tokens that describe how to resume reading a stream where reading
   * previously left off. If specified, changes will be read starting at the
   * the position. Tokens are delivered on the stream as part of `Heartbeat`
   * and `CloseStream` messages.
   *
   * If a single token is provided, the token's partition must exactly match
   * the request's partition. If multiple tokens are provided, as in the case
   * of a partition merge, the union of the token partitions must exactly
   * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
   * returned.
   * </pre>
   *
   * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.StreamContinuationTokensOrBuilder getContinuationTokensOrBuilder() {
    if (startFromCase_ == 6) {
      return (com.google.bigtable.v2.StreamContinuationTokens) startFrom_;
    }
    return com.google.bigtable.v2.StreamContinuationTokens.getDefaultInstance();
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * If specified, OK will be returned when the stream advances beyond
   * this time. Otherwise, changes will be continuously delivered on the stream.
   * This value is inclusive and will be truncated to microsecond granularity.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * If specified, OK will be returned when the stream advances beyond
   * this time. Otherwise, changes will be continuously delivered on the stream.
   * This value is inclusive and will be truncated to microsecond granularity.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * If specified, OK will be returned when the stream advances beyond
   * this time. Otherwise, changes will be continuously delivered on the stream.
   * This value is inclusive and will be truncated to microsecond granularity.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int HEARTBEAT_DURATION_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration heartbeatDuration_;

  /**
   *
   *
   * <pre>
   * If specified, the duration between `Heartbeat` messages on the stream.
   * Otherwise, defaults to 5 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
   *
   * @return Whether the heartbeatDuration field is set.
   */
  @java.lang.Override
  public boolean hasHeartbeatDuration() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * If specified, the duration between `Heartbeat` messages on the stream.
   * Otherwise, defaults to 5 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
   *
   * @return The heartbeatDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getHeartbeatDuration() {
    return heartbeatDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : heartbeatDuration_;
  }

  /**
   *
   *
   * <pre>
   * If specified, the duration between `Heartbeat` messages on the stream.
   * Otherwise, defaults to 5 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getHeartbeatDurationOrBuilder() {
    return heartbeatDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : heartbeatDuration_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(tableName_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, tableName_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(appProfileId_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, appProfileId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getPartition());
    }
    if (startFromCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.Timestamp) startFrom_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getEndTime());
    }
    if (startFromCase_ == 6) {
      output.writeMessage(6, (com.google.bigtable.v2.StreamContinuationTokens) startFrom_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getHeartbeatDuration());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(tableName_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, tableName_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(appProfileId_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, appProfileId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPartition());
    }
    if (startFromCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.protobuf.Timestamp) startFrom_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (startFromCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.bigtable.v2.StreamContinuationTokens) startFrom_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getHeartbeatDuration());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.ReadChangeStreamRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.ReadChangeStreamRequest other =
        (com.google.bigtable.v2.ReadChangeStreamRequest) obj;

    if (!getTableName().equals(other.getTableName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (hasPartition() != other.hasPartition()) return false;
    if (hasPartition()) {
      if (!getPartition().equals(other.getPartition())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasHeartbeatDuration() != other.hasHeartbeatDuration()) return false;
    if (hasHeartbeatDuration()) {
      if (!getHeartbeatDuration().equals(other.getHeartbeatDuration())) return false;
    }
    if (!getStartFromCase().equals(other.getStartFromCase())) return false;
    switch (startFromCase_) {
      case 4:
        if (!getStartTime().equals(other.getStartTime())) return false;
        break;
      case 6:
        if (!getContinuationTokens().equals(other.getContinuationTokens())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    if (hasPartition()) {
      hash = (37 * hash) + PARTITION_FIELD_NUMBER;
      hash = (53 * hash) + getPartition().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasHeartbeatDuration()) {
      hash = (37 * hash) + HEARTBEAT_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getHeartbeatDuration().hashCode();
    }
    switch (startFromCase_) {
      case 4:
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
        break;
      case 6:
        hash = (37 * hash) + CONTINUATION_TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getContinuationTokens().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.ReadChangeStreamRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * NOTE: This API is intended to be used by Apache Beam BigtableIO.
   * Request message for Bigtable.ReadChangeStream.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadChangeStreamRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadChangeStreamRequest)
      com.google.bigtable.v2.ReadChangeStreamRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadChangeStreamRequest.class,
              com.google.bigtable.v2.ReadChangeStreamRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.ReadChangeStreamRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetPartitionFieldBuilder();
        internalGetEndTimeFieldBuilder();
        internalGetHeartbeatDurationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tableName_ = "";
      appProfileId_ = "";
      partition_ = null;
      if (partitionBuilder_ != null) {
        partitionBuilder_.dispose();
        partitionBuilder_ = null;
      }
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.clear();
      }
      if (continuationTokensBuilder_ != null) {
        continuationTokensBuilder_.clear();
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      heartbeatDuration_ = null;
      if (heartbeatDurationBuilder_ != null) {
        heartbeatDurationBuilder_.dispose();
        heartbeatDurationBuilder_ = null;
      }
      startFromCase_ = 0;
      startFrom_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadChangeStreamRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.ReadChangeStreamRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamRequest build() {
      com.google.bigtable.v2.ReadChangeStreamRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadChangeStreamRequest buildPartial() {
      com.google.bigtable.v2.ReadChangeStreamRequest result =
          new com.google.bigtable.v2.ReadChangeStreamRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.ReadChangeStreamRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tableName_ = tableName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.appProfileId_ = appProfileId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.partition_ = partitionBuilder_ == null ? partition_ : partitionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.heartbeatDuration_ =
            heartbeatDurationBuilder_ == null
                ? heartbeatDuration_
                : heartbeatDurationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.v2.ReadChangeStreamRequest result) {
      result.startFromCase_ = startFromCase_;
      result.startFrom_ = this.startFrom_;
      if (startFromCase_ == 4 && startTimeBuilder_ != null) {
        result.startFrom_ = startTimeBuilder_.build();
      }
      if (startFromCase_ == 6 && continuationTokensBuilder_ != null) {
        result.startFrom_ = continuationTokensBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.ReadChangeStreamRequest) {
        return mergeFrom((com.google.bigtable.v2.ReadChangeStreamRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.ReadChangeStreamRequest other) {
      if (other == com.google.bigtable.v2.ReadChangeStreamRequest.getDefaultInstance()) return this;
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPartition()) {
        mergePartition(other.getPartition());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasHeartbeatDuration()) {
        mergeHeartbeatDuration(other.getHeartbeatDuration());
      }
      switch (other.getStartFromCase()) {
        case START_TIME:
          {
            mergeStartTime(other.getStartTime());
            break;
          }
        case CONTINUATION_TOKENS:
          {
            mergeContinuationTokens(other.getContinuationTokens());
            break;
          }
        case STARTFROM_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tableName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                appProfileId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    internalGetPartitionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    internalGetStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                startFromCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(internalGetEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    internalGetContinuationTokensFieldBuilder().getBuilder(), extensionRegistry);
                startFromCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    internalGetHeartbeatDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int startFromCase_ = 0;
    private java.lang.Object startFrom_;

    public StartFromCase getStartFromCase() {
      return StartFromCase.forNumber(startFromCase_);
    }

    public Builder clearStartFrom() {
      startFromCase_ = 0;
      startFrom_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object tableName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * Change streaming must be enabled on the table.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * Change streaming must be enabled on the table.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * Change streaming must be enabled on the table.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * Change streaming must be enabled on the table.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {
      tableName_ = getDefaultInstance().getTableName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * Change streaming must be enabled on the table.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     * </pre>
     *
     * <code>string app_profile_id = 2;</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     * </pre>
     *
     * <code>string app_profile_id = 2;</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     * </pre>
     *
     * <code>string app_profile_id = 2;</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      appProfileId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     * </pre>
     *
     * <code>string app_profile_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {
      appProfileId_ = getDefaultInstance().getAppProfileId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     * </pre>
     *
     * <code>string app_profile_id = 2;</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      appProfileId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.bigtable.v2.StreamPartition partition_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.StreamPartition,
            com.google.bigtable.v2.StreamPartition.Builder,
            com.google.bigtable.v2.StreamPartitionOrBuilder>
        partitionBuilder_;

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     *
     * @return Whether the partition field is set.
     */
    public boolean hasPartition() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     *
     * @return The partition.
     */
    public com.google.bigtable.v2.StreamPartition getPartition() {
      if (partitionBuilder_ == null) {
        return partition_ == null
            ? com.google.bigtable.v2.StreamPartition.getDefaultInstance()
            : partition_;
      } else {
        return partitionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    public Builder setPartition(com.google.bigtable.v2.StreamPartition value) {
      if (partitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partition_ = value;
      } else {
        partitionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    public Builder setPartition(com.google.bigtable.v2.StreamPartition.Builder builderForValue) {
      if (partitionBuilder_ == null) {
        partition_ = builderForValue.build();
      } else {
        partitionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    public Builder mergePartition(com.google.bigtable.v2.StreamPartition value) {
      if (partitionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && partition_ != null
            && partition_ != com.google.bigtable.v2.StreamPartition.getDefaultInstance()) {
          getPartitionBuilder().mergeFrom(value);
        } else {
          partition_ = value;
        }
      } else {
        partitionBuilder_.mergeFrom(value);
      }
      if (partition_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    public Builder clearPartition() {
      bitField0_ = (bitField0_ & ~0x00000004);
      partition_ = null;
      if (partitionBuilder_ != null) {
        partitionBuilder_.dispose();
        partitionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    public com.google.bigtable.v2.StreamPartition.Builder getPartitionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return internalGetPartitionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    public com.google.bigtable.v2.StreamPartitionOrBuilder getPartitionOrBuilder() {
      if (partitionBuilder_ != null) {
        return partitionBuilder_.getMessageOrBuilder();
      } else {
        return partition_ == null
            ? com.google.bigtable.v2.StreamPartition.getDefaultInstance()
            : partition_;
      }
    }

    /**
     *
     *
     * <pre>
     * The partition to read changes from.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.StreamPartition,
            com.google.bigtable.v2.StreamPartition.Builder,
            com.google.bigtable.v2.StreamPartitionOrBuilder>
        internalGetPartitionFieldBuilder() {
      if (partitionBuilder_ == null) {
        partitionBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.v2.StreamPartition,
                com.google.bigtable.v2.StreamPartition.Builder,
                com.google.bigtable.v2.StreamPartitionOrBuilder>(
                getPartition(), getParentForChildren(), isClean());
        partition_ = null;
      }
      return partitionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startFromCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        if (startFromCase_ == 4) {
          return (com.google.protobuf.Timestamp) startFrom_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (startFromCase_ == 4) {
          return startTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startFrom_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }
      startFromCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startFrom_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      startFromCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startFromCase_ == 4
            && startFrom_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          startFrom_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) startFrom_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          startFrom_ = value;
        }
        onChanged();
      } else {
        if (startFromCase_ == 4) {
          startTimeBuilder_.mergeFrom(value);
        } else {
          startTimeBuilder_.setMessage(value);
        }
      }
      startFromCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        if (startFromCase_ == 4) {
          startFromCase_ = 0;
          startFrom_ = null;
          onChanged();
        }
      } else {
        if (startFromCase_ == 4) {
          startFromCase_ = 0;
          startFrom_ = null;
        }
        startTimeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      return internalGetStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if ((startFromCase_ == 4) && (startTimeBuilder_ != null)) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        if (startFromCase_ == 4) {
          return (com.google.protobuf.Timestamp) startFrom_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        if (!(startFromCase_ == 4)) {
          startFrom_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) startFrom_, getParentForChildren(), isClean());
        startFrom_ = null;
      }
      startFromCase_ = 4;
      onChanged();
      return startTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.StreamContinuationTokens,
            com.google.bigtable.v2.StreamContinuationTokens.Builder,
            com.google.bigtable.v2.StreamContinuationTokensOrBuilder>
        continuationTokensBuilder_;

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     *
     * @return Whether the continuationTokens field is set.
     */
    @java.lang.Override
    public boolean hasContinuationTokens() {
      return startFromCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     *
     * @return The continuationTokens.
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamContinuationTokens getContinuationTokens() {
      if (continuationTokensBuilder_ == null) {
        if (startFromCase_ == 6) {
          return (com.google.bigtable.v2.StreamContinuationTokens) startFrom_;
        }
        return com.google.bigtable.v2.StreamContinuationTokens.getDefaultInstance();
      } else {
        if (startFromCase_ == 6) {
          return continuationTokensBuilder_.getMessage();
        }
        return com.google.bigtable.v2.StreamContinuationTokens.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     */
    public Builder setContinuationTokens(com.google.bigtable.v2.StreamContinuationTokens value) {
      if (continuationTokensBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startFrom_ = value;
        onChanged();
      } else {
        continuationTokensBuilder_.setMessage(value);
      }
      startFromCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     */
    public Builder setContinuationTokens(
        com.google.bigtable.v2.StreamContinuationTokens.Builder builderForValue) {
      if (continuationTokensBuilder_ == null) {
        startFrom_ = builderForValue.build();
        onChanged();
      } else {
        continuationTokensBuilder_.setMessage(builderForValue.build());
      }
      startFromCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     */
    public Builder mergeContinuationTokens(com.google.bigtable.v2.StreamContinuationTokens value) {
      if (continuationTokensBuilder_ == null) {
        if (startFromCase_ == 6
            && startFrom_ != com.google.bigtable.v2.StreamContinuationTokens.getDefaultInstance()) {
          startFrom_ =
              com.google.bigtable.v2.StreamContinuationTokens.newBuilder(
                      (com.google.bigtable.v2.StreamContinuationTokens) startFrom_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          startFrom_ = value;
        }
        onChanged();
      } else {
        if (startFromCase_ == 6) {
          continuationTokensBuilder_.mergeFrom(value);
        } else {
          continuationTokensBuilder_.setMessage(value);
        }
      }
      startFromCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     */
    public Builder clearContinuationTokens() {
      if (continuationTokensBuilder_ == null) {
        if (startFromCase_ == 6) {
          startFromCase_ = 0;
          startFrom_ = null;
          onChanged();
        }
      } else {
        if (startFromCase_ == 6) {
          startFromCase_ = 0;
          startFrom_ = null;
        }
        continuationTokensBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     */
    public com.google.bigtable.v2.StreamContinuationTokens.Builder getContinuationTokensBuilder() {
      return internalGetContinuationTokensFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.StreamContinuationTokensOrBuilder
        getContinuationTokensOrBuilder() {
      if ((startFromCase_ == 6) && (continuationTokensBuilder_ != null)) {
        return continuationTokensBuilder_.getMessageOrBuilder();
      } else {
        if (startFromCase_ == 6) {
          return (com.google.bigtable.v2.StreamContinuationTokens) startFrom_;
        }
        return com.google.bigtable.v2.StreamContinuationTokens.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     *
     * If a single token is provided, the token's partition must exactly match
     * the request's partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request's partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     * </pre>
     *
     * <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.bigtable.v2.StreamContinuationTokens,
            com.google.bigtable.v2.StreamContinuationTokens.Builder,
            com.google.bigtable.v2.StreamContinuationTokensOrBuilder>
        internalGetContinuationTokensFieldBuilder() {
      if (continuationTokensBuilder_ == null) {
        if (!(startFromCase_ == 6)) {
          startFrom_ = com.google.bigtable.v2.StreamContinuationTokens.getDefaultInstance();
        }
        continuationTokensBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.bigtable.v2.StreamContinuationTokens,
                com.google.bigtable.v2.StreamContinuationTokens.Builder,
                com.google.bigtable.v2.StreamContinuationTokensOrBuilder>(
                (com.google.bigtable.v2.StreamContinuationTokens) startFrom_,
                getParentForChildren(),
                isClean());
        startFrom_ = null;
      }
      startFromCase_ = 6;
      onChanged();
      return continuationTokensBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return internalGetEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.protobuf.Duration heartbeatDuration_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        heartbeatDurationBuilder_;

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     *
     * @return Whether the heartbeatDuration field is set.
     */
    public boolean hasHeartbeatDuration() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     *
     * @return The heartbeatDuration.
     */
    public com.google.protobuf.Duration getHeartbeatDuration() {
      if (heartbeatDurationBuilder_ == null) {
        return heartbeatDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : heartbeatDuration_;
      } else {
        return heartbeatDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    public Builder setHeartbeatDuration(com.google.protobuf.Duration value) {
      if (heartbeatDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        heartbeatDuration_ = value;
      } else {
        heartbeatDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    public Builder setHeartbeatDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (heartbeatDurationBuilder_ == null) {
        heartbeatDuration_ = builderForValue.build();
      } else {
        heartbeatDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    public Builder mergeHeartbeatDuration(com.google.protobuf.Duration value) {
      if (heartbeatDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && heartbeatDuration_ != null
            && heartbeatDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getHeartbeatDurationBuilder().mergeFrom(value);
        } else {
          heartbeatDuration_ = value;
        }
      } else {
        heartbeatDurationBuilder_.mergeFrom(value);
      }
      if (heartbeatDuration_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    public Builder clearHeartbeatDuration() {
      bitField0_ = (bitField0_ & ~0x00000040);
      heartbeatDuration_ = null;
      if (heartbeatDurationBuilder_ != null) {
        heartbeatDurationBuilder_.dispose();
        heartbeatDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getHeartbeatDurationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return internalGetHeartbeatDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getHeartbeatDurationOrBuilder() {
      if (heartbeatDurationBuilder_ != null) {
        return heartbeatDurationBuilder_.getMessageOrBuilder();
      } else {
        return heartbeatDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : heartbeatDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        internalGetHeartbeatDurationFieldBuilder() {
      if (heartbeatDurationBuilder_ == null) {
        heartbeatDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getHeartbeatDuration(), getParentForChildren(), isClean());
        heartbeatDuration_ = null;
      }
      return heartbeatDurationBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadChangeStreamRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadChangeStreamRequest)
  private static final com.google.bigtable.v2.ReadChangeStreamRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadChangeStreamRequest();
  }

  public static com.google.bigtable.v2.ReadChangeStreamRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadChangeStreamRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReadChangeStreamRequest>() {
        @java.lang.Override
        public ReadChangeStreamRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadChangeStreamRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadChangeStreamRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.ReadChangeStreamRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
