# Google Cloud Java Client -- Core

A set of classes and utilities used in Google Cloud Java libraries.

*Note*: This library is only meant to be consumed by other Google Libraries.

[![Maven](https://img.shields.io/maven-central/v/com.google.cloud/google-cloud-core.svg)](https://img.shields.io/maven-central/v/com.google.cloud/google-cloud-core.svg)

- [API Documentation][api-docs]

## Java Versions

Java 7 or above is required for using this client.

## Contributing

Contributions to this library are always welcome and highly encouraged.

See [CONTRIBUTING][contributing] documentation for more information on how to get started.

Please note that this project is released with a Contributor Code of Conduct. By participating in
this project you agree to abide by its terms. See [Code of Conduct][code-of-conduct] for more
information.

## Versioning

This library follows [Semantic Versioning][semver].

It is currently in major version one (``1.y.z``), which means that the public API should be
considered stable.

## License

Apache 2.0 - See [LICENSE][license] for more information.

## CI Status

Java Version | Status
------------ | ------
Java 7 | [![Kokoro CI](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java7.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java7.html)
Java 8 | [![Kokoro CI](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java8.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java8.html)
Java 8 OSX | [![Kokoro CI](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java8-osx.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java8-osx.html)
Java 8 Windows | [![Kokoro CI](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java8-win.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java8-win.html)
Java 11 | [![Kokoro CI](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java11.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/java-core/java11.html)


[contributing]: https://github.com/googleapis/java-core/blob/main/CONTRIBUTING.md
[code-of-conduct]: https://github.com/googleapis/java-core/blob/main/CODE_OF_CONDUCT.md
[license]: https://github.com/googleapis/java-core/blob/main/LICENSE
[semver]: http://semver.org/
[cloud-platform]: https://cloud.google.com/
[api-docs]: https://googleapis.dev/java/google-cloud-core/latest
