/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.firestore.v1;

import com.google.api.core.BetaApi;
import com.google.firestore.admin.v1.Backup;
import com.google.firestore.admin.v1.BackupSchedule;
import com.google.firestore.admin.v1.BulkDeleteDocumentsRequest;
import com.google.firestore.admin.v1.CloneDatabaseRequest;
import com.google.firestore.admin.v1.CreateBackupScheduleRequest;
import com.google.firestore.admin.v1.CreateDatabaseRequest;
import com.google.firestore.admin.v1.CreateIndexRequest;
import com.google.firestore.admin.v1.CreateUserCredsRequest;
import com.google.firestore.admin.v1.Database;
import com.google.firestore.admin.v1.DeleteBackupRequest;
import com.google.firestore.admin.v1.DeleteBackupScheduleRequest;
import com.google.firestore.admin.v1.DeleteDatabaseRequest;
import com.google.firestore.admin.v1.DeleteIndexRequest;
import com.google.firestore.admin.v1.DeleteUserCredsRequest;
import com.google.firestore.admin.v1.DisableUserCredsRequest;
import com.google.firestore.admin.v1.EnableUserCredsRequest;
import com.google.firestore.admin.v1.ExportDocumentsRequest;
import com.google.firestore.admin.v1.Field;
import com.google.firestore.admin.v1.FirestoreAdminGrpc.FirestoreAdminImplBase;
import com.google.firestore.admin.v1.GetBackupRequest;
import com.google.firestore.admin.v1.GetBackupScheduleRequest;
import com.google.firestore.admin.v1.GetDatabaseRequest;
import com.google.firestore.admin.v1.GetFieldRequest;
import com.google.firestore.admin.v1.GetIndexRequest;
import com.google.firestore.admin.v1.GetUserCredsRequest;
import com.google.firestore.admin.v1.ImportDocumentsRequest;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.admin.v1.ListBackupSchedulesRequest;
import com.google.firestore.admin.v1.ListBackupSchedulesResponse;
import com.google.firestore.admin.v1.ListBackupsRequest;
import com.google.firestore.admin.v1.ListBackupsResponse;
import com.google.firestore.admin.v1.ListDatabasesRequest;
import com.google.firestore.admin.v1.ListDatabasesResponse;
import com.google.firestore.admin.v1.ListFieldsRequest;
import com.google.firestore.admin.v1.ListFieldsResponse;
import com.google.firestore.admin.v1.ListIndexesRequest;
import com.google.firestore.admin.v1.ListIndexesResponse;
import com.google.firestore.admin.v1.ListUserCredsRequest;
import com.google.firestore.admin.v1.ListUserCredsResponse;
import com.google.firestore.admin.v1.ResetUserPasswordRequest;
import com.google.firestore.admin.v1.RestoreDatabaseRequest;
import com.google.firestore.admin.v1.UpdateBackupScheduleRequest;
import com.google.firestore.admin.v1.UpdateDatabaseRequest;
import com.google.firestore.admin.v1.UpdateFieldRequest;
import com.google.firestore.admin.v1.UserCreds;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.annotation.Generated;

@BetaApi
@Generated("by gapic-generator-java")
public class MockFirestoreAdminImpl extends FirestoreAdminImplBase {
  private List<AbstractMessage> requests;
  private Queue<Object> responses;

  public MockFirestoreAdminImpl() {
    requests = new ArrayList<>();
    responses = new LinkedList<>();
  }

  public List<AbstractMessage> getRequests() {
    return requests;
  }

  public void addResponse(AbstractMessage response) {
    responses.add(response);
  }

  public void setResponses(List<AbstractMessage> responses) {
    this.responses = new LinkedList<Object>(responses);
  }

  public void addException(Exception exception) {
    responses.add(exception);
  }

  public void reset() {
    requests = new ArrayList<>();
    responses = new LinkedList<>();
  }

  @Override
  public void createIndex(CreateIndexRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method CreateIndex, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void listIndexes(
      ListIndexesRequest request, StreamObserver<ListIndexesResponse> responseObserver) {
    Object response = responses.poll();
    if (response instanceof ListIndexesResponse) {
      requests.add(request);
      responseObserver.onNext(((ListIndexesResponse) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ListIndexes, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  ListIndexesResponse.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void getIndex(GetIndexRequest request, StreamObserver<Index> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Index) {
      requests.add(request);
      responseObserver.onNext(((Index) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method GetIndex, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Index.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void deleteIndex(DeleteIndexRequest request, StreamObserver<Empty> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Empty) {
      requests.add(request);
      responseObserver.onNext(((Empty) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method DeleteIndex, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Empty.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void getField(GetFieldRequest request, StreamObserver<Field> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Field) {
      requests.add(request);
      responseObserver.onNext(((Field) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method GetField, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Field.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void updateField(UpdateFieldRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method UpdateField, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void listFields(
      ListFieldsRequest request, StreamObserver<ListFieldsResponse> responseObserver) {
    Object response = responses.poll();
    if (response instanceof ListFieldsResponse) {
      requests.add(request);
      responseObserver.onNext(((ListFieldsResponse) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ListFields, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  ListFieldsResponse.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void exportDocuments(
      ExportDocumentsRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ExportDocuments, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void importDocuments(
      ImportDocumentsRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ImportDocuments, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void bulkDeleteDocuments(
      BulkDeleteDocumentsRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method BulkDeleteDocuments, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void createDatabase(
      CreateDatabaseRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method CreateDatabase, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void getDatabase(GetDatabaseRequest request, StreamObserver<Database> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Database) {
      requests.add(request);
      responseObserver.onNext(((Database) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method GetDatabase, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Database.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void listDatabases(
      ListDatabasesRequest request, StreamObserver<ListDatabasesResponse> responseObserver) {
    Object response = responses.poll();
    if (response instanceof ListDatabasesResponse) {
      requests.add(request);
      responseObserver.onNext(((ListDatabasesResponse) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ListDatabases, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  ListDatabasesResponse.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void updateDatabase(
      UpdateDatabaseRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method UpdateDatabase, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void deleteDatabase(
      DeleteDatabaseRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method DeleteDatabase, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void createUserCreds(
      CreateUserCredsRequest request, StreamObserver<UserCreds> responseObserver) {
    Object response = responses.poll();
    if (response instanceof UserCreds) {
      requests.add(request);
      responseObserver.onNext(((UserCreds) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method CreateUserCreds, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  UserCreds.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void getUserCreds(
      GetUserCredsRequest request, StreamObserver<UserCreds> responseObserver) {
    Object response = responses.poll();
    if (response instanceof UserCreds) {
      requests.add(request);
      responseObserver.onNext(((UserCreds) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method GetUserCreds, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  UserCreds.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void listUserCreds(
      ListUserCredsRequest request, StreamObserver<ListUserCredsResponse> responseObserver) {
    Object response = responses.poll();
    if (response instanceof ListUserCredsResponse) {
      requests.add(request);
      responseObserver.onNext(((ListUserCredsResponse) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ListUserCreds, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  ListUserCredsResponse.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void enableUserCreds(
      EnableUserCredsRequest request, StreamObserver<UserCreds> responseObserver) {
    Object response = responses.poll();
    if (response instanceof UserCreds) {
      requests.add(request);
      responseObserver.onNext(((UserCreds) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method EnableUserCreds, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  UserCreds.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void disableUserCreds(
      DisableUserCredsRequest request, StreamObserver<UserCreds> responseObserver) {
    Object response = responses.poll();
    if (response instanceof UserCreds) {
      requests.add(request);
      responseObserver.onNext(((UserCreds) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method DisableUserCreds, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  UserCreds.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void resetUserPassword(
      ResetUserPasswordRequest request, StreamObserver<UserCreds> responseObserver) {
    Object response = responses.poll();
    if (response instanceof UserCreds) {
      requests.add(request);
      responseObserver.onNext(((UserCreds) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ResetUserPassword, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  UserCreds.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void deleteUserCreds(
      DeleteUserCredsRequest request, StreamObserver<Empty> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Empty) {
      requests.add(request);
      responseObserver.onNext(((Empty) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method DeleteUserCreds, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Empty.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void getBackup(GetBackupRequest request, StreamObserver<Backup> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Backup) {
      requests.add(request);
      responseObserver.onNext(((Backup) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method GetBackup, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Backup.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void listBackups(
      ListBackupsRequest request, StreamObserver<ListBackupsResponse> responseObserver) {
    Object response = responses.poll();
    if (response instanceof ListBackupsResponse) {
      requests.add(request);
      responseObserver.onNext(((ListBackupsResponse) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ListBackups, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  ListBackupsResponse.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void deleteBackup(DeleteBackupRequest request, StreamObserver<Empty> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Empty) {
      requests.add(request);
      responseObserver.onNext(((Empty) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method DeleteBackup, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Empty.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void restoreDatabase(
      RestoreDatabaseRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method RestoreDatabase, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void createBackupSchedule(
      CreateBackupScheduleRequest request, StreamObserver<BackupSchedule> responseObserver) {
    Object response = responses.poll();
    if (response instanceof BackupSchedule) {
      requests.add(request);
      responseObserver.onNext(((BackupSchedule) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method CreateBackupSchedule, expected %s or"
                      + " %s",
                  response == null ? "null" : response.getClass().getName(),
                  BackupSchedule.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void getBackupSchedule(
      GetBackupScheduleRequest request, StreamObserver<BackupSchedule> responseObserver) {
    Object response = responses.poll();
    if (response instanceof BackupSchedule) {
      requests.add(request);
      responseObserver.onNext(((BackupSchedule) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method GetBackupSchedule, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  BackupSchedule.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void listBackupSchedules(
      ListBackupSchedulesRequest request,
      StreamObserver<ListBackupSchedulesResponse> responseObserver) {
    Object response = responses.poll();
    if (response instanceof ListBackupSchedulesResponse) {
      requests.add(request);
      responseObserver.onNext(((ListBackupSchedulesResponse) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method ListBackupSchedules, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  ListBackupSchedulesResponse.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void updateBackupSchedule(
      UpdateBackupScheduleRequest request, StreamObserver<BackupSchedule> responseObserver) {
    Object response = responses.poll();
    if (response instanceof BackupSchedule) {
      requests.add(request);
      responseObserver.onNext(((BackupSchedule) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method UpdateBackupSchedule, expected %s or"
                      + " %s",
                  response == null ? "null" : response.getClass().getName(),
                  BackupSchedule.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void deleteBackupSchedule(
      DeleteBackupScheduleRequest request, StreamObserver<Empty> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Empty) {
      requests.add(request);
      responseObserver.onNext(((Empty) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method DeleteBackupSchedule, expected %s or"
                      + " %s",
                  response == null ? "null" : response.getClass().getName(),
                  Empty.class.getName(),
                  Exception.class.getName())));
    }
  }

  @Override
  public void cloneDatabase(
      CloneDatabaseRequest request, StreamObserver<Operation> responseObserver) {
    Object response = responses.poll();
    if (response instanceof Operation) {
      requests.add(request);
      responseObserver.onNext(((Operation) response));
      responseObserver.onCompleted();
    } else if (response instanceof Exception) {
      responseObserver.onError(((Exception) response));
    } else {
      responseObserver.onError(
          new IllegalArgumentException(
              String.format(
                  "Unrecognized response type %s for method CloneDatabase, expected %s or %s",
                  response == null ? "null" : response.getClass().getName(),
                  Operation.class.getName(),
                  Exception.class.getName())));
    }
  }
}
