/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/firestore_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [FirestoreAdmin.BulkDeleteDocuments][google.firestore.admin.v1.FirestoreAdmin.BulkDeleteDocuments].
 *
 * When both collection_ids and namespace_ids are set, only documents satisfying
 * both conditions will be deleted.
 *
 * Requests with namespace_ids and collection_ids both empty will be rejected.
 * Please use
 * [FirestoreAdmin.DeleteDatabase][google.firestore.admin.v1.FirestoreAdmin.DeleteDatabase]
 * instead.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.BulkDeleteDocumentsRequest}
 */
public final class BulkDeleteDocumentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.BulkDeleteDocumentsRequest)
    BulkDeleteDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BulkDeleteDocumentsRequest.newBuilder() to construct.
  private BulkDeleteDocumentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkDeleteDocumentsRequest() {
    name_ = "";
    collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkDeleteDocumentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_BulkDeleteDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_BulkDeleteDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.BulkDeleteDocumentsRequest.class,
            com.google.firestore.admin.v1.BulkDeleteDocumentsRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. Database to operate. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Database to operate. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLLECTION_IDS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList collectionIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. IDs of the collection groups to delete. Unspecified means all
   * collection groups.
   *
   * Each collection group in this list must be unique.
   * </pre>
   *
   * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the collectionIds.
   */
  public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
    return collectionIds_;
  }

  /**
   *
   *
   * <pre>
   * Optional. IDs of the collection groups to delete. Unspecified means all
   * collection groups.
   *
   * Each collection group in this list must be unique.
   * </pre>
   *
   * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of collectionIds.
   */
  public int getCollectionIdsCount() {
    return collectionIds_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. IDs of the collection groups to delete. Unspecified means all
   * collection groups.
   *
   * Each collection group in this list must be unique.
   * </pre>
   *
   * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The collectionIds at the given index.
   */
  public java.lang.String getCollectionIds(int index) {
    return collectionIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. IDs of the collection groups to delete. Unspecified means all
   * collection groups.
   *
   * Each collection group in this list must be unique.
   * </pre>
   *
   * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionIds at the given index.
   */
  public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
    return collectionIds_.getByteString(index);
  }

  public static final int NAMESPACE_IDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList namespaceIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. Namespaces to delete.
   *
   * An empty list means all namespaces. This is the recommended
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to delete from them.
   *
   * Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the namespaceIds.
   */
  public com.google.protobuf.ProtocolStringList getNamespaceIdsList() {
    return namespaceIds_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Namespaces to delete.
   *
   * An empty list means all namespaces. This is the recommended
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to delete from them.
   *
   * Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of namespaceIds.
   */
  public int getNamespaceIdsCount() {
    return namespaceIds_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Namespaces to delete.
   *
   * An empty list means all namespaces. This is the recommended
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to delete from them.
   *
   * Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The namespaceIds at the given index.
   */
  public java.lang.String getNamespaceIds(int index) {
    return namespaceIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Namespaces to delete.
   *
   * An empty list means all namespaces. This is the recommended
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to delete from them.
   *
   * Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the namespaceIds at the given index.
   */
  public com.google.protobuf.ByteString getNamespaceIdsBytes(int index) {
    return namespaceIds_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < collectionIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, collectionIds_.getRaw(i));
    }
    for (int i = 0; i < namespaceIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, namespaceIds_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < collectionIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(collectionIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCollectionIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < namespaceIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(namespaceIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNamespaceIdsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.BulkDeleteDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.BulkDeleteDocumentsRequest other =
        (com.google.firestore.admin.v1.BulkDeleteDocumentsRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCollectionIdsList().equals(other.getCollectionIdsList())) return false;
    if (!getNamespaceIdsList().equals(other.getNamespaceIdsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getCollectionIdsCount() > 0) {
      hash = (37 * hash) + COLLECTION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getCollectionIdsList().hashCode();
    }
    if (getNamespaceIdsCount() > 0) {
      hash = (37 * hash) + NAMESPACE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getNamespaceIdsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.firestore.admin.v1.BulkDeleteDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for
   * [FirestoreAdmin.BulkDeleteDocuments][google.firestore.admin.v1.FirestoreAdmin.BulkDeleteDocuments].
   *
   * When both collection_ids and namespace_ids are set, only documents satisfying
   * both conditions will be deleted.
   *
   * Requests with namespace_ids and collection_ids both empty will be rejected.
   * Please use
   * [FirestoreAdmin.DeleteDatabase][google.firestore.admin.v1.FirestoreAdmin.DeleteDatabase]
   * instead.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.BulkDeleteDocumentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.BulkDeleteDocumentsRequest)
      com.google.firestore.admin.v1.BulkDeleteDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_BulkDeleteDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_BulkDeleteDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.BulkDeleteDocumentsRequest.class,
              com.google.firestore.admin.v1.BulkDeleteDocumentsRequest.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.BulkDeleteDocumentsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_BulkDeleteDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.BulkDeleteDocumentsRequest getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.BulkDeleteDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.BulkDeleteDocumentsRequest build() {
      com.google.firestore.admin.v1.BulkDeleteDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.BulkDeleteDocumentsRequest buildPartial() {
      com.google.firestore.admin.v1.BulkDeleteDocumentsRequest result =
          new com.google.firestore.admin.v1.BulkDeleteDocumentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.BulkDeleteDocumentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        collectionIds_.makeImmutable();
        result.collectionIds_ = collectionIds_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        namespaceIds_.makeImmutable();
        result.namespaceIds_ = namespaceIds_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.BulkDeleteDocumentsRequest) {
        return mergeFrom((com.google.firestore.admin.v1.BulkDeleteDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.BulkDeleteDocumentsRequest other) {
      if (other == com.google.firestore.admin.v1.BulkDeleteDocumentsRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.collectionIds_.isEmpty()) {
        if (collectionIds_.isEmpty()) {
          collectionIds_ = other.collectionIds_;
          bitField0_ |= 0x00000002;
        } else {
          ensureCollectionIdsIsMutable();
          collectionIds_.addAll(other.collectionIds_);
        }
        onChanged();
      }
      if (!other.namespaceIds_.isEmpty()) {
        if (namespaceIds_.isEmpty()) {
          namespaceIds_ = other.namespaceIds_;
          bitField0_ |= 0x00000004;
        } else {
          ensureNamespaceIdsIsMutable();
          namespaceIds_.addAll(other.namespaceIds_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCollectionIdsIsMutable();
                collectionIds_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNamespaceIdsIsMutable();
                namespaceIds_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. Database to operate. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Database to operate. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Database to operate. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Database to operate. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Database to operate. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList collectionIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCollectionIdsIsMutable() {
      if (!collectionIds_.isModifiable()) {
        collectionIds_ = new com.google.protobuf.LazyStringArrayList(collectionIds_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the collectionIds.
     */
    public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
      collectionIds_.makeImmutable();
      return collectionIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of collectionIds.
     */
    public int getCollectionIdsCount() {
      return collectionIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The collectionIds at the given index.
     */
    public java.lang.String getCollectionIds(int index) {
      return collectionIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the collectionIds at the given index.
     */
    public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
      return collectionIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The collectionIds to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllCollectionIds(java.lang.Iterable<java.lang.String> values) {
      ensureCollectionIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, collectionIds_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollectionIds() {
      collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. IDs of the collection groups to delete. Unspecified means all
     * collection groups.
     *
     * Each collection group in this list must be unique.
     * </pre>
     *
     * <code>repeated string collection_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList namespaceIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNamespaceIdsIsMutable() {
      if (!namespaceIds_.isModifiable()) {
        namespaceIds_ = new com.google.protobuf.LazyStringArrayList(namespaceIds_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the namespaceIds.
     */
    public com.google.protobuf.ProtocolStringList getNamespaceIdsList() {
      namespaceIds_.makeImmutable();
      return namespaceIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of namespaceIds.
     */
    public int getNamespaceIdsCount() {
      return namespaceIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The namespaceIds at the given index.
     */
    public java.lang.String getNamespaceIds(int index) {
      return namespaceIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the namespaceIds at the given index.
     */
    public com.google.protobuf.ByteString getNamespaceIdsBytes(int index) {
      return namespaceIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The namespaceIds to set.
     * @return This builder for chaining.
     */
    public Builder setNamespaceIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNamespaceIdsIsMutable();
      namespaceIds_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addNamespaceIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNamespaceIdsIsMutable();
      namespaceIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllNamespaceIds(java.lang.Iterable<java.lang.String> values) {
      ensureNamespaceIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, namespaceIds_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespaceIds() {
      namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Namespaces to delete.
     *
     * An empty list means all namespaces. This is the recommended
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to delete from them.
     *
     * Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addNamespaceIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNamespaceIdsIsMutable();
      namespaceIds_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.BulkDeleteDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.BulkDeleteDocumentsRequest)
  private static final com.google.firestore.admin.v1.BulkDeleteDocumentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.BulkDeleteDocumentsRequest();
  }

  public static com.google.firestore.admin.v1.BulkDeleteDocumentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkDeleteDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BulkDeleteDocumentsRequest>() {
        @java.lang.Override
        public BulkDeleteDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkDeleteDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkDeleteDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.BulkDeleteDocumentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
