/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/admin/v1/operation.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * Metadata for the [long-running operation][google.longrunning.Operation] from
 * the [CloneDatabase][google.firestore.admin.v1.CloneDatabase] request.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.CloneDatabaseMetadata}
 */
@com.google.protobuf.Generated
public final class CloneDatabaseMetadata extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.CloneDatabaseMetadata)
    CloneDatabaseMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "CloneDatabaseMetadata");
  }

  // Use CloneDatabaseMetadata.newBuilder() to construct.
  private CloneDatabaseMetadata(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private CloneDatabaseMetadata() {
    operationState_ = 0;
    database_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_CloneDatabaseMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_CloneDatabaseMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.CloneDatabaseMetadata.class,
            com.google.firestore.admin.v1.CloneDatabaseMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * The time the clone was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time the clone was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * The time the clone was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * The time the clone finished, unset for ongoing clones.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time the clone finished, unset for ongoing clones.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * The time the clone finished, unset for ongoing clones.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int OPERATION_STATE_FIELD_NUMBER = 3;
  private int operationState_ = 0;

  /**
   *
   *
   * <pre>
   * The operation state of the clone.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The enum numeric value on the wire for operationState.
   */
  @java.lang.Override
  public int getOperationStateValue() {
    return operationState_;
  }

  /**
   *
   *
   * <pre>
   * The operation state of the clone.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The operationState.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.OperationState getOperationState() {
    com.google.firestore.admin.v1.OperationState result =
        com.google.firestore.admin.v1.OperationState.forNumber(operationState_);
    return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
  }

  public static final int DATABASE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";

  /**
   *
   *
   * <pre>
   * The name of the database being cloned to.
   * </pre>
   *
   * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the database being cloned to.
   * </pre>
   *
   * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PITR_SNAPSHOT_FIELD_NUMBER = 7;
  private com.google.firestore.admin.v1.PitrSnapshot pitrSnapshot_;

  /**
   *
   *
   * <pre>
   * The snapshot from which this database was cloned.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
   *
   * @return Whether the pitrSnapshot field is set.
   */
  @java.lang.Override
  public boolean hasPitrSnapshot() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The snapshot from which this database was cloned.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
   *
   * @return The pitrSnapshot.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.PitrSnapshot getPitrSnapshot() {
    return pitrSnapshot_ == null
        ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
        : pitrSnapshot_;
  }

  /**
   *
   *
   * <pre>
   * The snapshot from which this database was cloned.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.PitrSnapshotOrBuilder getPitrSnapshotOrBuilder() {
    return pitrSnapshot_ == null
        ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
        : pitrSnapshot_;
  }

  public static final int PROGRESS_PERCENTAGE_FIELD_NUMBER = 6;
  private com.google.firestore.admin.v1.Progress progressPercentage_;

  /**
   *
   *
   * <pre>
   * How far along the clone is as an estimated percentage of remaining time.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
   *
   * @return Whether the progressPercentage field is set.
   */
  @java.lang.Override
  public boolean hasProgressPercentage() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * How far along the clone is as an estimated percentage of remaining time.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
   *
   * @return The progressPercentage.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressPercentage() {
    return progressPercentage_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressPercentage_;
  }

  /**
   *
   *
   * <pre>
   * How far along the clone is as an estimated percentage of remaining time.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressPercentageOrBuilder() {
    return progressPercentage_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressPercentage_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, operationState_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, database_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getProgressPercentage());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getPitrSnapshot());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, operationState_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, database_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getProgressPercentage());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPitrSnapshot());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.CloneDatabaseMetadata)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.CloneDatabaseMetadata other =
        (com.google.firestore.admin.v1.CloneDatabaseMetadata) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (operationState_ != other.operationState_) return false;
    if (!getDatabase().equals(other.getDatabase())) return false;
    if (hasPitrSnapshot() != other.hasPitrSnapshot()) return false;
    if (hasPitrSnapshot()) {
      if (!getPitrSnapshot().equals(other.getPitrSnapshot())) return false;
    }
    if (hasProgressPercentage() != other.hasProgressPercentage()) return false;
    if (hasProgressPercentage()) {
      if (!getProgressPercentage().equals(other.getProgressPercentage())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + OPERATION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + operationState_;
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (hasPitrSnapshot()) {
      hash = (37 * hash) + PITR_SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getPitrSnapshot().hashCode();
    }
    if (hasProgressPercentage()) {
      hash = (37 * hash) + PROGRESS_PERCENTAGE_FIELD_NUMBER;
      hash = (53 * hash) + getProgressPercentage().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.CloneDatabaseMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata for the [long-running operation][google.longrunning.Operation] from
   * the [CloneDatabase][google.firestore.admin.v1.CloneDatabase] request.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.CloneDatabaseMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.CloneDatabaseMetadata)
      com.google.firestore.admin.v1.CloneDatabaseMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_CloneDatabaseMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_CloneDatabaseMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.CloneDatabaseMetadata.class,
              com.google.firestore.admin.v1.CloneDatabaseMetadata.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.CloneDatabaseMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetStartTimeFieldBuilder();
        internalGetEndTimeFieldBuilder();
        internalGetPitrSnapshotFieldBuilder();
        internalGetProgressPercentageFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      operationState_ = 0;
      database_ = "";
      pitrSnapshot_ = null;
      if (pitrSnapshotBuilder_ != null) {
        pitrSnapshotBuilder_.dispose();
        pitrSnapshotBuilder_ = null;
      }
      progressPercentage_ = null;
      if (progressPercentageBuilder_ != null) {
        progressPercentageBuilder_.dispose();
        progressPercentageBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_CloneDatabaseMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.CloneDatabaseMetadata getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.CloneDatabaseMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.CloneDatabaseMetadata build() {
      com.google.firestore.admin.v1.CloneDatabaseMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.CloneDatabaseMetadata buildPartial() {
      com.google.firestore.admin.v1.CloneDatabaseMetadata result =
          new com.google.firestore.admin.v1.CloneDatabaseMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.CloneDatabaseMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operationState_ = operationState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.pitrSnapshot_ =
            pitrSnapshotBuilder_ == null ? pitrSnapshot_ : pitrSnapshotBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.progressPercentage_ =
            progressPercentageBuilder_ == null
                ? progressPercentage_
                : progressPercentageBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.CloneDatabaseMetadata) {
        return mergeFrom((com.google.firestore.admin.v1.CloneDatabaseMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.CloneDatabaseMetadata other) {
      if (other == com.google.firestore.admin.v1.CloneDatabaseMetadata.getDefaultInstance())
        return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.operationState_ != 0) {
        setOperationStateValue(other.getOperationStateValue());
      }
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasPitrSnapshot()) {
        mergePitrSnapshot(other.getPitrSnapshot());
      }
      if (other.hasProgressPercentage()) {
        mergeProgressPercentage(other.getProgressPercentage());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    internalGetStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(internalGetEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                operationState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    internalGetProgressPercentageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    internalGetPitrSnapshotFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return internalGetStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time the clone was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return internalGetEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time the clone finished, unset for ongoing clones.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int operationState_ = 0;

    /**
     *
     *
     * <pre>
     * The operation state of the clone.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The enum numeric value on the wire for operationState.
     */
    @java.lang.Override
    public int getOperationStateValue() {
      return operationState_;
    }

    /**
     *
     *
     * <pre>
     * The operation state of the clone.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The enum numeric value on the wire for operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationStateValue(int value) {
      operationState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The operation state of the clone.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The operationState.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.OperationState getOperationState() {
      com.google.firestore.admin.v1.OperationState result =
          com.google.firestore.admin.v1.OperationState.forNumber(operationState_);
      return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The operation state of the clone.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationState(com.google.firestore.admin.v1.OperationState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      operationState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The operation state of the clone.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operationState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object database_ = "";

    /**
     *
     *
     * <pre>
     * The name of the database being cloned to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the database being cloned to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the database being cloned to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the database being cloned to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the database being cloned to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.PitrSnapshot pitrSnapshot_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.PitrSnapshot,
            com.google.firestore.admin.v1.PitrSnapshot.Builder,
            com.google.firestore.admin.v1.PitrSnapshotOrBuilder>
        pitrSnapshotBuilder_;

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     *
     * @return Whether the pitrSnapshot field is set.
     */
    public boolean hasPitrSnapshot() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     *
     * @return The pitrSnapshot.
     */
    public com.google.firestore.admin.v1.PitrSnapshot getPitrSnapshot() {
      if (pitrSnapshotBuilder_ == null) {
        return pitrSnapshot_ == null
            ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
            : pitrSnapshot_;
      } else {
        return pitrSnapshotBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     */
    public Builder setPitrSnapshot(com.google.firestore.admin.v1.PitrSnapshot value) {
      if (pitrSnapshotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pitrSnapshot_ = value;
      } else {
        pitrSnapshotBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     */
    public Builder setPitrSnapshot(
        com.google.firestore.admin.v1.PitrSnapshot.Builder builderForValue) {
      if (pitrSnapshotBuilder_ == null) {
        pitrSnapshot_ = builderForValue.build();
      } else {
        pitrSnapshotBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     */
    public Builder mergePitrSnapshot(com.google.firestore.admin.v1.PitrSnapshot value) {
      if (pitrSnapshotBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && pitrSnapshot_ != null
            && pitrSnapshot_ != com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()) {
          getPitrSnapshotBuilder().mergeFrom(value);
        } else {
          pitrSnapshot_ = value;
        }
      } else {
        pitrSnapshotBuilder_.mergeFrom(value);
      }
      if (pitrSnapshot_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     */
    public Builder clearPitrSnapshot() {
      bitField0_ = (bitField0_ & ~0x00000010);
      pitrSnapshot_ = null;
      if (pitrSnapshotBuilder_ != null) {
        pitrSnapshotBuilder_.dispose();
        pitrSnapshotBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     */
    public com.google.firestore.admin.v1.PitrSnapshot.Builder getPitrSnapshotBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return internalGetPitrSnapshotFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     */
    public com.google.firestore.admin.v1.PitrSnapshotOrBuilder getPitrSnapshotOrBuilder() {
      if (pitrSnapshotBuilder_ != null) {
        return pitrSnapshotBuilder_.getMessageOrBuilder();
      } else {
        return pitrSnapshot_ == null
            ? com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()
            : pitrSnapshot_;
      }
    }

    /**
     *
     *
     * <pre>
     * The snapshot from which this database was cloned.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.PitrSnapshot pitr_snapshot = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.PitrSnapshot,
            com.google.firestore.admin.v1.PitrSnapshot.Builder,
            com.google.firestore.admin.v1.PitrSnapshotOrBuilder>
        internalGetPitrSnapshotFieldBuilder() {
      if (pitrSnapshotBuilder_ == null) {
        pitrSnapshotBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.admin.v1.PitrSnapshot,
                com.google.firestore.admin.v1.PitrSnapshot.Builder,
                com.google.firestore.admin.v1.PitrSnapshotOrBuilder>(
                getPitrSnapshot(), getParentForChildren(), isClean());
        pitrSnapshot_ = null;
      }
      return pitrSnapshotBuilder_;
    }

    private com.google.firestore.admin.v1.Progress progressPercentage_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressPercentageBuilder_;

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     *
     * @return Whether the progressPercentage field is set.
     */
    public boolean hasProgressPercentage() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     *
     * @return The progressPercentage.
     */
    public com.google.firestore.admin.v1.Progress getProgressPercentage() {
      if (progressPercentageBuilder_ == null) {
        return progressPercentage_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressPercentage_;
      } else {
        return progressPercentageBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     */
    public Builder setProgressPercentage(com.google.firestore.admin.v1.Progress value) {
      if (progressPercentageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressPercentage_ = value;
      } else {
        progressPercentageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     */
    public Builder setProgressPercentage(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressPercentageBuilder_ == null) {
        progressPercentage_ = builderForValue.build();
      } else {
        progressPercentageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     */
    public Builder mergeProgressPercentage(com.google.firestore.admin.v1.Progress value) {
      if (progressPercentageBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && progressPercentage_ != null
            && progressPercentage_ != com.google.firestore.admin.v1.Progress.getDefaultInstance()) {
          getProgressPercentageBuilder().mergeFrom(value);
        } else {
          progressPercentage_ = value;
        }
      } else {
        progressPercentageBuilder_.mergeFrom(value);
      }
      if (progressPercentage_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     */
    public Builder clearProgressPercentage() {
      bitField0_ = (bitField0_ & ~0x00000020);
      progressPercentage_ = null;
      if (progressPercentageBuilder_ != null) {
        progressPercentageBuilder_.dispose();
        progressPercentageBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressPercentageBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return internalGetProgressPercentageFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressPercentageOrBuilder() {
      if (progressPercentageBuilder_ != null) {
        return progressPercentageBuilder_.getMessageOrBuilder();
      } else {
        return progressPercentage_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressPercentage_;
      }
    }

    /**
     *
     *
     * <pre>
     * How far along the clone is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        internalGetProgressPercentageFieldBuilder() {
      if (progressPercentageBuilder_ == null) {
        progressPercentageBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressPercentage(), getParentForChildren(), isClean());
        progressPercentage_ = null;
      }
      return progressPercentageBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.CloneDatabaseMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.CloneDatabaseMetadata)
  private static final com.google.firestore.admin.v1.CloneDatabaseMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.CloneDatabaseMetadata();
  }

  public static com.google.firestore.admin.v1.CloneDatabaseMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloneDatabaseMetadata> PARSER =
      new com.google.protobuf.AbstractParser<CloneDatabaseMetadata>() {
        @java.lang.Override
        public CloneDatabaseMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloneDatabaseMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloneDatabaseMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.CloneDatabaseMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
