/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/admin/v1/database.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * A Cloud Firestore Database.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.Database}
 */
@com.google.protobuf.Generated
public final class Database extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database)
    DatabaseOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "Database");
  }

  // Use Database.newBuilder() to construct.
  private Database(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private Database() {
    name_ = "";
    uid_ = "";
    locationId_ = "";
    type_ = 0;
    concurrencyMode_ = 0;
    pointInTimeRecoveryEnablement_ = 0;
    appEngineIntegrationMode_ = 0;
    keyPrefix_ = "";
    deleteProtectionState_ = 0;
    previousId_ = "";
    etag_ = "";
    databaseEdition_ = 0;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.DatabaseProto
        .internal_static_google_firestore_admin_v1_Database_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 29:
        return internalGetTags();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.DatabaseProto
        .internal_static_google_firestore_admin_v1_Database_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.Database.class,
            com.google.firestore.admin.v1.Database.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   *
   * Mode changes are only allowed if the database is empty.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.DatabaseType}
   */
  public enum DatabaseType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    DATABASE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Firestore Native Mode
     * </pre>
     *
     * <code>FIRESTORE_NATIVE = 1;</code>
     */
    FIRESTORE_NATIVE(1),
    /**
     *
     *
     * <pre>
     * Firestore in Datastore Mode.
     * </pre>
     *
     * <code>DATASTORE_MODE = 2;</code>
     */
    DATASTORE_MODE(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "DatabaseType");
    }

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATABASE_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Firestore Native Mode
     * </pre>
     *
     * <code>FIRESTORE_NATIVE = 1;</code>
     */
    public static final int FIRESTORE_NATIVE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Firestore in Datastore Mode.
     * </pre>
     *
     * <code>DATASTORE_MODE = 2;</code>
     */
    public static final int DATASTORE_MODE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseType forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_TYPE_UNSPECIFIED;
        case 1:
          return FIRESTORE_NATIVE;
        case 2:
          return DATASTORE_MODE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DatabaseType>() {
          public DatabaseType findValueByNumber(int number) {
            return DatabaseType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(0);
    }

    private static final DatabaseType[] VALUES = values();

    public static DatabaseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.DatabaseType)
  }

  /**
   *
   *
   * <pre>
   * The type of concurrency control mode for transactions.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.ConcurrencyMode}
   */
  public enum ConcurrencyMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    CONCURRENCY_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     * </pre>
     *
     * <code>OPTIMISTIC = 1;</code>
     */
    OPTIMISTIC(1),
    /**
     *
     *
     * <pre>
     * Use pessimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     *
     * This is the default setting for Cloud Firestore.
     * </pre>
     *
     * <code>PESSIMISTIC = 2;</code>
     */
    PESSIMISTIC(2),
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control with entity groups by default.
     *
     * This is the only available mode for Cloud Datastore.
     *
     * This mode is also available for Cloud Firestore with Datastore Mode but
     * is not recommended.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    OPTIMISTIC_WITH_ENTITY_GROUPS(3),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "ConcurrencyMode");
    }

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int CONCURRENCY_MODE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     * </pre>
     *
     * <code>OPTIMISTIC = 1;</code>
     */
    public static final int OPTIMISTIC_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Use pessimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     *
     * This is the default setting for Cloud Firestore.
     * </pre>
     *
     * <code>PESSIMISTIC = 2;</code>
     */
    public static final int PESSIMISTIC_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control with entity groups by default.
     *
     * This is the only available mode for Cloud Datastore.
     *
     * This mode is also available for Cloud Firestore with Datastore Mode but
     * is not recommended.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    public static final int OPTIMISTIC_WITH_ENTITY_GROUPS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConcurrencyMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConcurrencyMode forNumber(int value) {
      switch (value) {
        case 0:
          return CONCURRENCY_MODE_UNSPECIFIED;
        case 1:
          return OPTIMISTIC;
        case 2:
          return PESSIMISTIC;
        case 3:
          return OPTIMISTIC_WITH_ENTITY_GROUPS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>() {
              public ConcurrencyMode findValueByNumber(int number) {
                return ConcurrencyMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(1);
    }

    private static final ConcurrencyMode[] VALUES = values();

    public static ConcurrencyMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConcurrencyMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.ConcurrencyMode)
  }

  /**
   *
   *
   * <pre>
   * Point In Time Recovery feature enablement.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement}
   */
  public enum PointInTimeRecoveryEnablement implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED = 0;</code>
     */
    POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Reads are supported on selected versions of the data from within the past
     * 7 days:
     *
     * * Reads against any timestamp within the past hour
     * * Reads against 1-minute snapshots beyond 1 hour and within 7 days
     *
     * `version_retention_period` and `earliest_version_time` can be
     * used to determine the supported versions.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLED = 1;</code>
     */
    POINT_IN_TIME_RECOVERY_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Reads are supported on any version of the data from within the past 1
     * hour.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_DISABLED = 2;</code>
     */
    POINT_IN_TIME_RECOVERY_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "PointInTimeRecoveryEnablement");
    }

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED = 0;</code>
     */
    public static final int POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Reads are supported on selected versions of the data from within the past
     * 7 days:
     *
     * * Reads against any timestamp within the past hour
     * * Reads against 1-minute snapshots beyond 1 hour and within 7 days
     *
     * `version_retention_period` and `earliest_version_time` can be
     * used to determine the supported versions.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLED = 1;</code>
     */
    public static final int POINT_IN_TIME_RECOVERY_ENABLED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Reads are supported on any version of the data from within the past 1
     * hour.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_DISABLED = 2;</code>
     */
    public static final int POINT_IN_TIME_RECOVERY_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PointInTimeRecoveryEnablement valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PointInTimeRecoveryEnablement forNumber(int value) {
      switch (value) {
        case 0:
          return POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED;
        case 1:
          return POINT_IN_TIME_RECOVERY_ENABLED;
        case 2:
          return POINT_IN_TIME_RECOVERY_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PointInTimeRecoveryEnablement>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PointInTimeRecoveryEnablement>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PointInTimeRecoveryEnablement>() {
              public PointInTimeRecoveryEnablement findValueByNumber(int number) {
                return PointInTimeRecoveryEnablement.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(2);
    }

    private static final PointInTimeRecoveryEnablement[] VALUES = values();

    public static PointInTimeRecoveryEnablement valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PointInTimeRecoveryEnablement(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement)
  }

  /**
   *
   *
   * <pre>
   * The type of App Engine integration mode.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.AppEngineIntegrationMode}
   */
  public enum AppEngineIntegrationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED = 0;</code>
     */
    APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If an App Engine application exists in the same region as this database,
     * App Engine configuration will impact this database. This includes
     * disabling of the application &amp; database, as well as disabling writes to
     * the database.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * App Engine has no effect on the ability of this database to serve
     * requests.
     *
     * This is the default setting for databases created with the Firestore API.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "AppEngineIntegrationMode");
    }

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * If an App Engine application exists in the same region as this database,
     * App Engine configuration will impact this database. This includes
     * disabling of the application &amp; database, as well as disabling writes to
     * the database.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * App Engine has no effect on the ability of this database to serve
     * requests.
     *
     * This is the default setting for databases created with the Firestore API.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AppEngineIntegrationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AppEngineIntegrationMode forNumber(int value) {
      switch (value) {
        case 0:
          return APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AppEngineIntegrationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AppEngineIntegrationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AppEngineIntegrationMode>() {
              public AppEngineIntegrationMode findValueByNumber(int number) {
                return AppEngineIntegrationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(3);
    }

    private static final AppEngineIntegrationMode[] VALUES = values();

    public static AppEngineIntegrationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AppEngineIntegrationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.AppEngineIntegrationMode)
  }

  /**
   *
   *
   * <pre>
   * The delete protection state of the database.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.DeleteProtectionState}
   */
  public enum DeleteProtectionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. Delete protection type is not specified
     * </pre>
     *
     * <code>DELETE_PROTECTION_STATE_UNSPECIFIED = 0;</code>
     */
    DELETE_PROTECTION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Delete protection is disabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_DISABLED = 1;</code>
     */
    DELETE_PROTECTION_DISABLED(1),
    /**
     *
     *
     * <pre>
     * Delete protection is enabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_ENABLED = 2;</code>
     */
    DELETE_PROTECTION_ENABLED(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "DeleteProtectionState");
    }

    /**
     *
     *
     * <pre>
     * The default value. Delete protection type is not specified
     * </pre>
     *
     * <code>DELETE_PROTECTION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int DELETE_PROTECTION_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Delete protection is disabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_DISABLED = 1;</code>
     */
    public static final int DELETE_PROTECTION_DISABLED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Delete protection is enabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_ENABLED = 2;</code>
     */
    public static final int DELETE_PROTECTION_ENABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeleteProtectionState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DeleteProtectionState forNumber(int value) {
      switch (value) {
        case 0:
          return DELETE_PROTECTION_STATE_UNSPECIFIED;
        case 1:
          return DELETE_PROTECTION_DISABLED;
        case 2:
          return DELETE_PROTECTION_ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeleteProtectionState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DeleteProtectionState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DeleteProtectionState>() {
              public DeleteProtectionState findValueByNumber(int number) {
                return DeleteProtectionState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(4);
    }

    private static final DeleteProtectionState[] VALUES = values();

    public static DeleteProtectionState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeleteProtectionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.DeleteProtectionState)
  }

  /**
   *
   *
   * <pre>
   * The edition of the database.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.DatabaseEdition}
   */
  public enum DatabaseEdition implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>DATABASE_EDITION_UNSPECIFIED = 0;</code>
     */
    DATABASE_EDITION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Standard edition.
     *
     * This is the default setting if not specified.
     * </pre>
     *
     * <code>STANDARD = 1;</code>
     */
    STANDARD(1),
    /**
     *
     *
     * <pre>
     * Enterprise edition.
     * </pre>
     *
     * <code>ENTERPRISE = 2;</code>
     */
    ENTERPRISE(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "DatabaseEdition");
    }

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>DATABASE_EDITION_UNSPECIFIED = 0;</code>
     */
    public static final int DATABASE_EDITION_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Standard edition.
     *
     * This is the default setting if not specified.
     * </pre>
     *
     * <code>STANDARD = 1;</code>
     */
    public static final int STANDARD_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Enterprise edition.
     * </pre>
     *
     * <code>ENTERPRISE = 2;</code>
     */
    public static final int ENTERPRISE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseEdition valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseEdition forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_EDITION_UNSPECIFIED;
        case 1:
          return STANDARD;
        case 2:
          return ENTERPRISE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseEdition> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseEdition>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DatabaseEdition>() {
              public DatabaseEdition findValueByNumber(int number) {
                return DatabaseEdition.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(5);
    }

    private static final DatabaseEdition[] VALUES = values();

    public static DatabaseEdition valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseEdition(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.DatabaseEdition)
  }

  public interface CmekConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Database.CmekConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Only keys in the same location as this database are allowed to
     * be used for encryption.
     *
     * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     * multi-region us. For Firestore's eur3 multi-region, this corresponds to
     * Cloud KMS multi-region europe. See
     * https://cloud.google.com/kms/docs/locations.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The kmsKeyName.
     */
    java.lang.String getKmsKeyName();

    /**
     *
     *
     * <pre>
     * Required. Only keys in the same location as this database are allowed to
     * be used for encryption.
     *
     * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     * multi-region us. For Firestore's eur3 multi-region, this corresponds to
     * Cloud KMS multi-region europe. See
     * https://cloud.google.com/kms/docs/locations.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for kmsKeyName.
     */
    com.google.protobuf.ByteString getKmsKeyNameBytes();

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the activeKeyVersion.
     */
    java.util.List<java.lang.String> getActiveKeyVersionList();

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of activeKeyVersion.
     */
    int getActiveKeyVersionCount();

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The activeKeyVersion at the given index.
     */
    java.lang.String getActiveKeyVersion(int index);

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the activeKeyVersion at the given index.
     */
    com.google.protobuf.ByteString getActiveKeyVersionBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * The CMEK (Customer Managed Encryption Key) configuration for a Firestore
   * database. If not present, the database is secured by the default Google
   * encryption key.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Database.CmekConfig}
   */
  public static final class CmekConfig extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database.CmekConfig)
      CmekConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "CmekConfig");
    }

    // Use CmekConfig.newBuilder() to construct.
    private CmekConfig(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private CmekConfig() {
      kmsKeyName_ = "";
      activeKeyVersion_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_CmekConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_CmekConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Database.CmekConfig.class,
              com.google.firestore.admin.v1.Database.CmekConfig.Builder.class);
    }

    public static final int KMS_KEY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kmsKeyName_ = "";

    /**
     *
     *
     * <pre>
     * Required. Only keys in the same location as this database are allowed to
     * be used for encryption.
     *
     * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     * multi-region us. For Firestore's eur3 multi-region, this corresponds to
     * Cloud KMS multi-region europe. See
     * https://cloud.google.com/kms/docs/locations.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The kmsKeyName.
     */
    @java.lang.Override
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Only keys in the same location as this database are allowed to
     * be used for encryption.
     *
     * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     * multi-region us. For Firestore's eur3 multi-region, this corresponds to
     * Cloud KMS multi-region europe. See
     * https://cloud.google.com/kms/docs/locations.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for kmsKeyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ACTIVE_KEY_VERSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList activeKeyVersion_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the activeKeyVersion.
     */
    public com.google.protobuf.ProtocolStringList getActiveKeyVersionList() {
      return activeKeyVersion_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of activeKeyVersion.
     */
    public int getActiveKeyVersionCount() {
      return activeKeyVersion_.size();
    }

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The activeKeyVersion at the given index.
     */
    public java.lang.String getActiveKeyVersion(int index) {
      return activeKeyVersion_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     *
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * </pre>
     *
     * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the activeKeyVersion at the given index.
     */
    public com.google.protobuf.ByteString getActiveKeyVersionBytes(int index) {
      return activeKeyVersion_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(kmsKeyName_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, kmsKeyName_);
      }
      for (int i = 0; i < activeKeyVersion_.size(); i++) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, activeKeyVersion_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(kmsKeyName_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, kmsKeyName_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < activeKeyVersion_.size(); i++) {
          dataSize += computeStringSizeNoTag(activeKeyVersion_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getActiveKeyVersionList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.admin.v1.Database.CmekConfig)) {
        return super.equals(obj);
      }
      com.google.firestore.admin.v1.Database.CmekConfig other =
          (com.google.firestore.admin.v1.Database.CmekConfig) obj;

      if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
      if (!getActiveKeyVersionList().equals(other.getActiveKeyVersionList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKeyName().hashCode();
      if (getActiveKeyVersionCount() > 0) {
        hash = (37 * hash) + ACTIVE_KEY_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getActiveKeyVersionList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.admin.v1.Database.CmekConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The CMEK (Customer Managed Encryption Key) configuration for a Firestore
     * database. If not present, the database is secured by the default Google
     * encryption key.
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.Database.CmekConfig}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database.CmekConfig)
        com.google.firestore.admin.v1.Database.CmekConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_CmekConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_CmekConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Database.CmekConfig.class,
                com.google.firestore.admin.v1.Database.CmekConfig.Builder.class);
      }

      // Construct using com.google.firestore.admin.v1.Database.CmekConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kmsKeyName_ = "";
        activeKeyVersion_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_CmekConfig_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.CmekConfig getDefaultInstanceForType() {
        return com.google.firestore.admin.v1.Database.CmekConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.CmekConfig build() {
        com.google.firestore.admin.v1.Database.CmekConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.CmekConfig buildPartial() {
        com.google.firestore.admin.v1.Database.CmekConfig result =
            new com.google.firestore.admin.v1.Database.CmekConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.firestore.admin.v1.Database.CmekConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kmsKeyName_ = kmsKeyName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          activeKeyVersion_.makeImmutable();
          result.activeKeyVersion_ = activeKeyVersion_;
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.admin.v1.Database.CmekConfig) {
          return mergeFrom((com.google.firestore.admin.v1.Database.CmekConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.admin.v1.Database.CmekConfig other) {
        if (other == com.google.firestore.admin.v1.Database.CmekConfig.getDefaultInstance())
          return this;
        if (!other.getKmsKeyName().isEmpty()) {
          kmsKeyName_ = other.kmsKeyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.activeKeyVersion_.isEmpty()) {
          if (activeKeyVersion_.isEmpty()) {
            activeKeyVersion_ = other.activeKeyVersion_;
            bitField0_ |= 0x00000002;
          } else {
            ensureActiveKeyVersionIsMutable();
            activeKeyVersion_.addAll(other.activeKeyVersion_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  kmsKeyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureActiveKeyVersionIsMutable();
                  activeKeyVersion_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object kmsKeyName_ = "";

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as this database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The kmsKeyName.
       */
      public java.lang.String getKmsKeyName() {
        java.lang.Object ref = kmsKeyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKeyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as this database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for kmsKeyName.
       */
      public com.google.protobuf.ByteString getKmsKeyNameBytes() {
        java.lang.Object ref = kmsKeyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKeyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as this database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The kmsKeyName to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kmsKeyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as this database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKeyName() {
        kmsKeyName_ = getDefaultInstance().getKmsKeyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as this database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for kmsKeyName to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kmsKeyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList activeKeyVersion_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureActiveKeyVersionIsMutable() {
        if (!activeKeyVersion_.isModifiable()) {
          activeKeyVersion_ = new com.google.protobuf.LazyStringArrayList(activeKeyVersion_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return A list containing the activeKeyVersion.
       */
      public com.google.protobuf.ProtocolStringList getActiveKeyVersionList() {
        activeKeyVersion_.makeImmutable();
        return activeKeyVersion_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The count of activeKeyVersion.
       */
      public int getActiveKeyVersionCount() {
        return activeKeyVersion_.size();
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The activeKeyVersion at the given index.
       */
      public java.lang.String getActiveKeyVersion(int index) {
        return activeKeyVersion_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the activeKeyVersion at the given index.
       */
      public com.google.protobuf.ByteString getActiveKeyVersionBytes(int index) {
        return activeKeyVersion_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The activeKeyVersion to set.
       * @return This builder for chaining.
       */
      public Builder setActiveKeyVersion(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActiveKeyVersionIsMutable();
        activeKeyVersion_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The activeKeyVersion to add.
       * @return This builder for chaining.
       */
      public Builder addActiveKeyVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActiveKeyVersionIsMutable();
        activeKeyVersion_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param values The activeKeyVersion to add.
       * @return This builder for chaining.
       */
      public Builder addAllActiveKeyVersion(java.lang.Iterable<java.lang.String> values) {
        ensureActiveKeyVersionIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, activeKeyVersion_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearActiveKeyVersion() {
        activeKeyVersion_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Currently in-use [KMS key
       * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
       * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
       * there can be multiple in-use key versions.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
       * </pre>
       *
       * <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes of the activeKeyVersion to add.
       * @return This builder for chaining.
       */
      public Builder addActiveKeyVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureActiveKeyVersionIsMutable();
        activeKeyVersion_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database.CmekConfig)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database.CmekConfig)
    private static final com.google.firestore.admin.v1.Database.CmekConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Database.CmekConfig();
    }

    public static com.google.firestore.admin.v1.Database.CmekConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CmekConfig> PARSER =
        new com.google.protobuf.AbstractParser<CmekConfig>() {
          @java.lang.Override
          public CmekConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CmekConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CmekConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database.CmekConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SourceInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Database.SourceInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If set, this database was restored from the specified backup (or a
     * snapshot thereof).
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
     *
     * @return Whether the backup field is set.
     */
    boolean hasBackup();

    /**
     *
     *
     * <pre>
     * If set, this database was restored from the specified backup (or a
     * snapshot thereof).
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
     *
     * @return The backup.
     */
    com.google.firestore.admin.v1.Database.SourceInfo.BackupSource getBackup();

    /**
     *
     *
     * <pre>
     * If set, this database was restored from the specified backup (or a
     * snapshot thereof).
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
     */
    com.google.firestore.admin.v1.Database.SourceInfo.BackupSourceOrBuilder getBackupOrBuilder();

    /**
     *
     *
     * <pre>
     * The associated long-running operation. This field may not be set after
     * the operation has completed. Format:
     * `projects/{project}/databases/{database}/operations/{operation}`.
     * </pre>
     *
     * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The operation.
     */
    java.lang.String getOperation();

    /**
     *
     *
     * <pre>
     * The associated long-running operation. This field may not be set after
     * the operation has completed. Format:
     * `projects/{project}/databases/{database}/operations/{operation}`.
     * </pre>
     *
     * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for operation.
     */
    com.google.protobuf.ByteString getOperationBytes();

    com.google.firestore.admin.v1.Database.SourceInfo.SourceCase getSourceCase();
  }

  /**
   *
   *
   * <pre>
   * Information about the provenance of this database.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Database.SourceInfo}
   */
  public static final class SourceInfo extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database.SourceInfo)
      SourceInfoOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "SourceInfo");
    }

    // Use SourceInfo.newBuilder() to construct.
    private SourceInfo(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private SourceInfo() {
      operation_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_SourceInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_SourceInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Database.SourceInfo.class,
              com.google.firestore.admin.v1.Database.SourceInfo.Builder.class);
    }

    public interface BackupSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Database.SourceInfo.BackupSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The resource name of the backup that was used to restore this
       * database. Format:
       * `projects/{project}/locations/{location}/backups/{backup}`.
       * </pre>
       *
       * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The backup.
       */
      java.lang.String getBackup();

      /**
       *
       *
       * <pre>
       * The resource name of the backup that was used to restore this
       * database. Format:
       * `projects/{project}/locations/{location}/backups/{backup}`.
       * </pre>
       *
       * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for backup.
       */
      com.google.protobuf.ByteString getBackupBytes();
    }

    /**
     *
     *
     * <pre>
     * Information about a backup that was used to restore a database.
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.Database.SourceInfo.BackupSource}
     */
    public static final class BackupSource extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database.SourceInfo.BackupSource)
        BackupSourceOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "BackupSource");
      }

      // Use BackupSource.newBuilder() to construct.
      private BackupSource(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private BackupSource() {
        backup_ = "";
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_SourceInfo_BackupSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_SourceInfo_BackupSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.class,
                com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.Builder.class);
      }

      public static final int BACKUP_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object backup_ = "";

      /**
       *
       *
       * <pre>
       * The resource name of the backup that was used to restore this
       * database. Format:
       * `projects/{project}/locations/{location}/backups/{backup}`.
       * </pre>
       *
       * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The backup.
       */
      @java.lang.Override
      public java.lang.String getBackup() {
        java.lang.Object ref = backup_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          backup_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of the backup that was used to restore this
       * database. Format:
       * `projects/{project}/locations/{location}/backups/{backup}`.
       * </pre>
       *
       * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for backup.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBackupBytes() {
        java.lang.Object ref = backup_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          backup_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessage.isStringEmpty(backup_)) {
          com.google.protobuf.GeneratedMessage.writeString(output, 1, backup_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessage.isStringEmpty(backup_)) {
          size += com.google.protobuf.GeneratedMessage.computeStringSize(1, backup_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.firestore.admin.v1.Database.SourceInfo.BackupSource)) {
          return super.equals(obj);
        }
        com.google.firestore.admin.v1.Database.SourceInfo.BackupSource other =
            (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) obj;

        if (!getBackup().equals(other.getBackup())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getBackup().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.firestore.admin.v1.Database.SourceInfo.BackupSource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Information about a backup that was used to restore a database.
       * </pre>
       *
       * Protobuf type {@code google.firestore.admin.v1.Database.SourceInfo.BackupSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database.SourceInfo.BackupSource)
          com.google.firestore.admin.v1.Database.SourceInfo.BackupSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_SourceInfo_BackupSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_SourceInfo_BackupSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.class,
                  com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.Builder.class);
        }

        // Construct using
        // com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          backup_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_SourceInfo_BackupSource_descriptor;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
            getDefaultInstanceForType() {
          return com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.SourceInfo.BackupSource build() {
          com.google.firestore.admin.v1.Database.SourceInfo.BackupSource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.SourceInfo.BackupSource buildPartial() {
          com.google.firestore.admin.v1.Database.SourceInfo.BackupSource result =
              new com.google.firestore.admin.v1.Database.SourceInfo.BackupSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.firestore.admin.v1.Database.SourceInfo.BackupSource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.backup_ = backup_;
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) {
            return mergeFrom(
                (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.firestore.admin.v1.Database.SourceInfo.BackupSource other) {
          if (other
              == com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
                  .getDefaultInstance()) return this;
          if (!other.getBackup().isEmpty()) {
            backup_ = other.backup_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    backup_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object backup_ = "";

        /**
         *
         *
         * <pre>
         * The resource name of the backup that was used to restore this
         * database. Format:
         * `projects/{project}/locations/{location}/backups/{backup}`.
         * </pre>
         *
         * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The backup.
         */
        public java.lang.String getBackup() {
          java.lang.Object ref = backup_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            backup_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The resource name of the backup that was used to restore this
         * database. Format:
         * `projects/{project}/locations/{location}/backups/{backup}`.
         * </pre>
         *
         * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for backup.
         */
        public com.google.protobuf.ByteString getBackupBytes() {
          java.lang.Object ref = backup_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            backup_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The resource name of the backup that was used to restore this
         * database. Format:
         * `projects/{project}/locations/{location}/backups/{backup}`.
         * </pre>
         *
         * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The backup to set.
         * @return This builder for chaining.
         */
        public Builder setBackup(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          backup_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The resource name of the backup that was used to restore this
         * database. Format:
         * `projects/{project}/locations/{location}/backups/{backup}`.
         * </pre>
         *
         * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBackup() {
          backup_ = getDefaultInstance().getBackup();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The resource name of the backup that was used to restore this
         * database. Format:
         * `projects/{project}/locations/{location}/backups/{backup}`.
         * </pre>
         *
         * <code>string backup = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for backup to set.
         * @return This builder for chaining.
         */
        public Builder setBackupBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          backup_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database.SourceInfo.BackupSource)
      }

      // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database.SourceInfo.BackupSource)
      private static final com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Database.SourceInfo.BackupSource();
      }

      public static com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BackupSource> PARSER =
          new com.google.protobuf.AbstractParser<BackupSource>() {
            @java.lang.Override
            public BackupSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BackupSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BackupSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      BACKUP(1),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return BACKUP;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int BACKUP_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * If set, this database was restored from the specified backup (or a
     * snapshot thereof).
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
     *
     * @return Whether the backup field is set.
     */
    @java.lang.Override
    public boolean hasBackup() {
      return sourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * If set, this database was restored from the specified backup (or a
     * snapshot thereof).
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
     *
     * @return The backup.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.SourceInfo.BackupSource getBackup() {
      if (sourceCase_ == 1) {
        return (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_;
      }
      return com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * If set, this database was restored from the specified backup (or a
     * snapshot thereof).
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.SourceInfo.BackupSourceOrBuilder
        getBackupOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_;
      }
      return com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.getDefaultInstance();
    }

    public static final int OPERATION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object operation_ = "";

    /**
     *
     *
     * <pre>
     * The associated long-running operation. This field may not be set after
     * the operation has completed. Format:
     * `projects/{project}/databases/{database}/operations/{operation}`.
     * </pre>
     *
     * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The operation.
     */
    @java.lang.Override
    public java.lang.String getOperation() {
      java.lang.Object ref = operation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operation_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The associated long-running operation. This field may not be set after
     * the operation has completed. Format:
     * `projects/{project}/databases/{database}/operations/{operation}`.
     * </pre>
     *
     * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for operation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOperationBytes() {
      java.lang.Object ref = operation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(
            1, (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(operation_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, operation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(operation_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(3, operation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.admin.v1.Database.SourceInfo)) {
        return super.equals(obj);
      }
      com.google.firestore.admin.v1.Database.SourceInfo other =
          (com.google.firestore.admin.v1.Database.SourceInfo) obj;

      if (!getOperation().equals(other.getOperation())) return false;
      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getBackup().equals(other.getBackup())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OPERATION_FIELD_NUMBER;
      hash = (53 * hash) + getOperation().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + BACKUP_FIELD_NUMBER;
          hash = (53 * hash) + getBackup().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.admin.v1.Database.SourceInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information about the provenance of this database.
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.Database.SourceInfo}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database.SourceInfo)
        com.google.firestore.admin.v1.Database.SourceInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_SourceInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_SourceInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Database.SourceInfo.class,
                com.google.firestore.admin.v1.Database.SourceInfo.Builder.class);
      }

      // Construct using com.google.firestore.admin.v1.Database.SourceInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (backupBuilder_ != null) {
          backupBuilder_.clear();
        }
        operation_ = "";
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_SourceInfo_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.SourceInfo getDefaultInstanceForType() {
        return com.google.firestore.admin.v1.Database.SourceInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.SourceInfo build() {
        com.google.firestore.admin.v1.Database.SourceInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.SourceInfo buildPartial() {
        com.google.firestore.admin.v1.Database.SourceInfo result =
            new com.google.firestore.admin.v1.Database.SourceInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.firestore.admin.v1.Database.SourceInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.operation_ = operation_;
        }
      }

      private void buildPartialOneofs(com.google.firestore.admin.v1.Database.SourceInfo result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && backupBuilder_ != null) {
          result.source_ = backupBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.admin.v1.Database.SourceInfo) {
          return mergeFrom((com.google.firestore.admin.v1.Database.SourceInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.admin.v1.Database.SourceInfo other) {
        if (other == com.google.firestore.admin.v1.Database.SourceInfo.getDefaultInstance())
          return this;
        if (!other.getOperation().isEmpty()) {
          operation_ = other.operation_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getSourceCase()) {
          case BACKUP:
            {
              mergeBackup(other.getBackup());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetBackupFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              case 26:
                {
                  operation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.SourceInfo.BackupSource,
              com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.Builder,
              com.google.firestore.admin.v1.Database.SourceInfo.BackupSourceOrBuilder>
          backupBuilder_;

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       *
       * @return Whether the backup field is set.
       */
      @java.lang.Override
      public boolean hasBackup() {
        return sourceCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       *
       * @return The backup.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.SourceInfo.BackupSource getBackup() {
        if (backupBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_;
          }
          return com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
              .getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return backupBuilder_.getMessage();
          }
          return com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       */
      public Builder setBackup(
          com.google.firestore.admin.v1.Database.SourceInfo.BackupSource value) {
        if (backupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          backupBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       */
      public Builder setBackup(
          com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.Builder builderForValue) {
        if (backupBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          backupBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       */
      public Builder mergeBackup(
          com.google.firestore.admin.v1.Database.SourceInfo.BackupSource value) {
        if (backupBuilder_ == null) {
          if (sourceCase_ == 1
              && source_
                  != com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
                      .getDefaultInstance()) {
            source_ =
                com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.newBuilder(
                        (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            backupBuilder_.mergeFrom(value);
          } else {
            backupBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       */
      public Builder clearBackup() {
        if (backupBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          backupBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       */
      public com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.Builder
          getBackupBuilder() {
        return internalGetBackupFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.SourceInfo.BackupSourceOrBuilder
          getBackupOrBuilder() {
        if ((sourceCase_ == 1) && (backupBuilder_ != null)) {
          return backupBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_;
          }
          return com.google.firestore.admin.v1.Database.SourceInfo.BackupSource
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * If set, this database was restored from the specified backup (or a
       * snapshot thereof).
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Database.SourceInfo.BackupSource backup = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.SourceInfo.BackupSource,
              com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.Builder,
              com.google.firestore.admin.v1.Database.SourceInfo.BackupSourceOrBuilder>
          internalGetBackupFieldBuilder() {
        if (backupBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ =
                com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.getDefaultInstance();
          }
          backupBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.firestore.admin.v1.Database.SourceInfo.BackupSource,
                  com.google.firestore.admin.v1.Database.SourceInfo.BackupSource.Builder,
                  com.google.firestore.admin.v1.Database.SourceInfo.BackupSourceOrBuilder>(
                  (com.google.firestore.admin.v1.Database.SourceInfo.BackupSource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return backupBuilder_;
      }

      private java.lang.Object operation_ = "";

      /**
       *
       *
       * <pre>
       * The associated long-running operation. This field may not be set after
       * the operation has completed. Format:
       * `projects/{project}/databases/{database}/operations/{operation}`.
       * </pre>
       *
       * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The operation.
       */
      public java.lang.String getOperation() {
        java.lang.Object ref = operation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          operation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The associated long-running operation. This field may not be set after
       * the operation has completed. Format:
       * `projects/{project}/databases/{database}/operations/{operation}`.
       * </pre>
       *
       * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for operation.
       */
      public com.google.protobuf.ByteString getOperationBytes() {
        java.lang.Object ref = operation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          operation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The associated long-running operation. This field may not be set after
       * the operation has completed. Format:
       * `projects/{project}/databases/{database}/operations/{operation}`.
       * </pre>
       *
       * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The operation to set.
       * @return This builder for chaining.
       */
      public Builder setOperation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The associated long-running operation. This field may not be set after
       * the operation has completed. Format:
       * `projects/{project}/databases/{database}/operations/{operation}`.
       * </pre>
       *
       * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOperation() {
        operation_ = getDefaultInstance().getOperation();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The associated long-running operation. This field may not be set after
       * the operation has completed. Format:
       * `projects/{project}/databases/{database}/operations/{operation}`.
       * </pre>
       *
       * <code>string operation = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for operation to set.
       * @return This builder for chaining.
       */
      public Builder setOperationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        operation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database.SourceInfo)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database.SourceInfo)
    private static final com.google.firestore.admin.v1.Database.SourceInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Database.SourceInfo();
    }

    public static com.google.firestore.admin.v1.Database.SourceInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SourceInfo> PARSER =
        new com.google.protobuf.AbstractParser<SourceInfo>() {
          @java.lang.Override
          public SourceInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SourceInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SourceInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database.SourceInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EncryptionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Database.EncryptionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Use Google default encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
     * </code>
     *
     * @return Whether the googleDefaultEncryption field is set.
     */
    boolean hasGoogleDefaultEncryption();

    /**
     *
     *
     * <pre>
     * Use Google default encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
     * </code>
     *
     * @return The googleDefaultEncryption.
     */
    com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
        getGoogleDefaultEncryption();

    /**
     *
     *
     * <pre>
     * Use Google default encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
     * </code>
     */
    com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptionsOrBuilder
        getGoogleDefaultEncryptionOrBuilder();

    /**
     *
     *
     * <pre>
     * The database will use the same encryption configuration as the source.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
     * </code>
     *
     * @return Whether the useSourceEncryption field is set.
     */
    boolean hasUseSourceEncryption();

    /**
     *
     *
     * <pre>
     * The database will use the same encryption configuration as the source.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
     * </code>
     *
     * @return The useSourceEncryption.
     */
    com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
        getUseSourceEncryption();

    /**
     *
     *
     * <pre>
     * The database will use the same encryption configuration as the source.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
     * </code>
     */
    com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptionsOrBuilder
        getUseSourceEncryptionOrBuilder();

    /**
     *
     *
     * <pre>
     * Use Customer Managed Encryption Keys (CMEK) for encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
     * </code>
     *
     * @return Whether the customerManagedEncryption field is set.
     */
    boolean hasCustomerManagedEncryption();

    /**
     *
     *
     * <pre>
     * Use Customer Managed Encryption Keys (CMEK) for encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
     * </code>
     *
     * @return The customerManagedEncryption.
     */
    com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
        getCustomerManagedEncryption();

    /**
     *
     *
     * <pre>
     * Use Customer Managed Encryption Keys (CMEK) for encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
     * </code>
     */
    com.google.firestore.admin.v1.Database.EncryptionConfig
            .CustomerManagedEncryptionOptionsOrBuilder
        getCustomerManagedEncryptionOrBuilder();

    com.google.firestore.admin.v1.Database.EncryptionConfig.EncryptionTypeCase
        getEncryptionTypeCase();
  }

  /**
   *
   *
   * <pre>
   * Encryption configuration for a new database being created from another
   * source.
   *
   * The source could be a [Backup][google.firestore.admin.v1.Backup] .
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Database.EncryptionConfig}
   */
  public static final class EncryptionConfig extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database.EncryptionConfig)
      EncryptionConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "EncryptionConfig");
    }

    // Use EncryptionConfig.newBuilder() to construct.
    private EncryptionConfig(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private EncryptionConfig() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Database.EncryptionConfig.class,
              com.google.firestore.admin.v1.Database.EncryptionConfig.Builder.class);
    }

    public interface GoogleDefaultEncryptionOptionsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * The configuration options for using Google default encryption.
     * </pre>
     *
     * Protobuf type {@code
     * google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions}
     */
    public static final class GoogleDefaultEncryptionOptions
        extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions)
        GoogleDefaultEncryptionOptionsOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "GoogleDefaultEncryptionOptions");
      }

      // Use GoogleDefaultEncryptionOptions.newBuilder() to construct.
      private GoogleDefaultEncryptionOptions(
          com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private GoogleDefaultEncryptionOptions() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_GoogleDefaultEncryptionOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_GoogleDefaultEncryptionOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .GoogleDefaultEncryptionOptions.class,
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .GoogleDefaultEncryptionOptions.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.firestore.admin.v1.Database.EncryptionConfig
                .GoogleDefaultEncryptionOptions)) {
          return super.equals(obj);
        }
        com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
            other =
                (com.google.firestore.admin.v1.Database.EncryptionConfig
                        .GoogleDefaultEncryptionOptions)
                    obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The configuration options for using Google default encryption.
       * </pre>
       *
       * Protobuf type {@code
       * google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions)
          com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptionsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_GoogleDefaultEncryptionOptions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_GoogleDefaultEncryptionOptions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .GoogleDefaultEncryptionOptions.class,
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .GoogleDefaultEncryptionOptions.Builder.class);
        }

        // Construct using
        // com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_GoogleDefaultEncryptionOptions_descriptor;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig
                .GoogleDefaultEncryptionOptions
            getDefaultInstanceForType() {
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig
                .GoogleDefaultEncryptionOptions
            build() {
          com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig
                .GoogleDefaultEncryptionOptions
            buildPartial() {
          com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
              result =
                  new com.google.firestore.admin.v1.Database.EncryptionConfig
                      .GoogleDefaultEncryptionOptions(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .GoogleDefaultEncryptionOptions) {
            return mergeFrom(
                (com.google.firestore.admin.v1.Database.EncryptionConfig
                        .GoogleDefaultEncryptionOptions)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
                other) {
          if (other
              == com.google.firestore.admin.v1.Database.EncryptionConfig
                  .GoogleDefaultEncryptionOptions.getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions)
      }

      // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions)
      private static final com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.firestore.admin.v1.Database.EncryptionConfig
                .GoogleDefaultEncryptionOptions();
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GoogleDefaultEncryptionOptions> PARSER =
          new com.google.protobuf.AbstractParser<GoogleDefaultEncryptionOptions>() {
            @java.lang.Override
            public GoogleDefaultEncryptionOptions parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GoogleDefaultEncryptionOptions> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GoogleDefaultEncryptionOptions> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SourceEncryptionOptionsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * The configuration options for using the same encryption method as the
     * source.
     * </pre>
     *
     * Protobuf type {@code
     * google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions}
     */
    public static final class SourceEncryptionOptions extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
        SourceEncryptionOptionsOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "SourceEncryptionOptions");
      }

      // Use SourceEncryptionOptions.newBuilder() to construct.
      private SourceEncryptionOptions(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private SourceEncryptionOptions() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_SourceEncryptionOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_SourceEncryptionOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                    .class,
                com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                    .Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)) {
          return super.equals(obj);
        }
        com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions other =
            (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The configuration options for using the same encryption method as the
       * source.
       * </pre>
       *
       * Protobuf type {@code
       * google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
          com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptionsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_SourceEncryptionOptions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_SourceEncryptionOptions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                      .class,
                  com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                      .Builder.class);
        }

        // Construct using
        // com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_SourceEncryptionOptions_descriptor;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
            getDefaultInstanceForType() {
          return com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
            build() {
          com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
            buildPartial() {
          com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions result =
              new com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions(
                  this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions) {
            return mergeFrom(
                (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions other) {
          if (other
              == com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
      }

      // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
      private static final com.google.firestore.admin.v1.Database.EncryptionConfig
              .SourceEncryptionOptions
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions();
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SourceEncryptionOptions> PARSER =
          new com.google.protobuf.AbstractParser<SourceEncryptionOptions>() {
            @java.lang.Override
            public SourceEncryptionOptions parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SourceEncryptionOptions> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SourceEncryptionOptions> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CustomerManagedEncryptionOptionsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as the database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The kmsKeyName.
       */
      java.lang.String getKmsKeyName();

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as the database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for kmsKeyName.
       */
      com.google.protobuf.ByteString getKmsKeyNameBytes();
    }

    /**
     *
     *
     * <pre>
     * The configuration options for using CMEK (Customer Managed Encryption
     * Key) encryption.
     * </pre>
     *
     * Protobuf type {@code
     * google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions}
     */
    public static final class CustomerManagedEncryptionOptions
        extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions)
        CustomerManagedEncryptionOptionsOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "CustomerManagedEncryptionOptions");
      }

      // Use CustomerManagedEncryptionOptions.newBuilder() to construct.
      private CustomerManagedEncryptionOptions(
          com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private CustomerManagedEncryptionOptions() {
        kmsKeyName_ = "";
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_CustomerManagedEncryptionOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_CustomerManagedEncryptionOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .CustomerManagedEncryptionOptions.class,
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .CustomerManagedEncryptionOptions.Builder.class);
      }

      public static final int KMS_KEY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object kmsKeyName_ = "";

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as the database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The kmsKeyName.
       */
      @java.lang.Override
      public java.lang.String getKmsKeyName() {
        java.lang.Object ref = kmsKeyName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKeyName_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Only keys in the same location as the database are allowed to
       * be used for encryption.
       *
       * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
       * multi-region us. For Firestore's eur3 multi-region, this corresponds to
       * Cloud KMS multi-region europe. See
       * https://cloud.google.com/kms/docs/locations.
       *
       * The expected format is
       * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
       * </pre>
       *
       * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for kmsKeyName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKmsKeyNameBytes() {
        java.lang.Object ref = kmsKeyName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKeyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessage.isStringEmpty(kmsKeyName_)) {
          com.google.protobuf.GeneratedMessage.writeString(output, 1, kmsKeyName_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessage.isStringEmpty(kmsKeyName_)) {
          size += com.google.protobuf.GeneratedMessage.computeStringSize(1, kmsKeyName_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.firestore.admin.v1.Database.EncryptionConfig
                .CustomerManagedEncryptionOptions)) {
          return super.equals(obj);
        }
        com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
            other =
                (com.google.firestore.admin.v1.Database.EncryptionConfig
                        .CustomerManagedEncryptionOptions)
                    obj;

        if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getKmsKeyName().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The configuration options for using CMEK (Customer Managed Encryption
       * Key) encryption.
       * </pre>
       *
       * Protobuf type {@code
       * google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions)
          com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptionsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_CustomerManagedEncryptionOptions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_CustomerManagedEncryptionOptions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .CustomerManagedEncryptionOptions.class,
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .CustomerManagedEncryptionOptions.Builder.class);
        }

        // Construct using
        // com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          kmsKeyName_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.firestore.admin.v1.DatabaseProto
              .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_CustomerManagedEncryptionOptions_descriptor;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig
                .CustomerManagedEncryptionOptions
            getDefaultInstanceForType() {
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig
                .CustomerManagedEncryptionOptions
            build() {
          com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Database.EncryptionConfig
                .CustomerManagedEncryptionOptions
            buildPartial() {
          com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
              result =
                  new com.google.firestore.admin.v1.Database.EncryptionConfig
                      .CustomerManagedEncryptionOptions(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.kmsKeyName_ = kmsKeyName_;
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptions) {
            return mergeFrom(
                (com.google.firestore.admin.v1.Database.EncryptionConfig
                        .CustomerManagedEncryptionOptions)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
                other) {
          if (other
              == com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptions.getDefaultInstance()) return this;
          if (!other.getKmsKeyName().isEmpty()) {
            kmsKeyName_ = other.kmsKeyName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    kmsKeyName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object kmsKeyName_ = "";

        /**
         *
         *
         * <pre>
         * Required. Only keys in the same location as the database are allowed to
         * be used for encryption.
         *
         * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
         * multi-region us. For Firestore's eur3 multi-region, this corresponds to
         * Cloud KMS multi-region europe. See
         * https://cloud.google.com/kms/docs/locations.
         *
         * The expected format is
         * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
         * </pre>
         *
         * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The kmsKeyName.
         */
        public java.lang.String getKmsKeyName() {
          java.lang.Object ref = kmsKeyName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            kmsKeyName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. Only keys in the same location as the database are allowed to
         * be used for encryption.
         *
         * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
         * multi-region us. For Firestore's eur3 multi-region, this corresponds to
         * Cloud KMS multi-region europe. See
         * https://cloud.google.com/kms/docs/locations.
         *
         * The expected format is
         * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
         * </pre>
         *
         * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for kmsKeyName.
         */
        public com.google.protobuf.ByteString getKmsKeyNameBytes() {
          java.lang.Object ref = kmsKeyName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            kmsKeyName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. Only keys in the same location as the database are allowed to
         * be used for encryption.
         *
         * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
         * multi-region us. For Firestore's eur3 multi-region, this corresponds to
         * Cloud KMS multi-region europe. See
         * https://cloud.google.com/kms/docs/locations.
         *
         * The expected format is
         * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
         * </pre>
         *
         * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The kmsKeyName to set.
         * @return This builder for chaining.
         */
        public Builder setKmsKeyName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          kmsKeyName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Only keys in the same location as the database are allowed to
         * be used for encryption.
         *
         * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
         * multi-region us. For Firestore's eur3 multi-region, this corresponds to
         * Cloud KMS multi-region europe. See
         * https://cloud.google.com/kms/docs/locations.
         *
         * The expected format is
         * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
         * </pre>
         *
         * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKmsKeyName() {
          kmsKeyName_ = getDefaultInstance().getKmsKeyName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Only keys in the same location as the database are allowed to
         * be used for encryption.
         *
         * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
         * multi-region us. For Firestore's eur3 multi-region, this corresponds to
         * Cloud KMS multi-region europe. See
         * https://cloud.google.com/kms/docs/locations.
         *
         * The expected format is
         * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
         * </pre>
         *
         * <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for kmsKeyName to set.
         * @return This builder for chaining.
         */
        public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          kmsKeyName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions)
      }

      // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions)
      private static final com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.firestore.admin.v1.Database.EncryptionConfig
                .CustomerManagedEncryptionOptions();
      }

      public static com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CustomerManagedEncryptionOptions> PARSER =
          new com.google.protobuf.AbstractParser<CustomerManagedEncryptionOptions>() {
            @java.lang.Override
            public CustomerManagedEncryptionOptions parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CustomerManagedEncryptionOptions> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CustomerManagedEncryptionOptions> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int encryptionTypeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object encryptionType_;

    public enum EncryptionTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GOOGLE_DEFAULT_ENCRYPTION(1),
      USE_SOURCE_ENCRYPTION(2),
      CUSTOMER_MANAGED_ENCRYPTION(3),
      ENCRYPTIONTYPE_NOT_SET(0);
      private final int value;

      private EncryptionTypeCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EncryptionTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static EncryptionTypeCase forNumber(int value) {
        switch (value) {
          case 1:
            return GOOGLE_DEFAULT_ENCRYPTION;
          case 2:
            return USE_SOURCE_ENCRYPTION;
          case 3:
            return CUSTOMER_MANAGED_ENCRYPTION;
          case 0:
            return ENCRYPTIONTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public EncryptionTypeCase getEncryptionTypeCase() {
      return EncryptionTypeCase.forNumber(encryptionTypeCase_);
    }

    public static final int GOOGLE_DEFAULT_ENCRYPTION_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Use Google default encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
     * </code>
     *
     * @return Whether the googleDefaultEncryption field is set.
     */
    @java.lang.Override
    public boolean hasGoogleDefaultEncryption() {
      return encryptionTypeCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Use Google default encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
     * </code>
     *
     * @return The googleDefaultEncryption.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
        getGoogleDefaultEncryption() {
      if (encryptionTypeCase_ == 1) {
        return (com.google.firestore.admin.v1.Database.EncryptionConfig
                .GoogleDefaultEncryptionOptions)
            encryptionType_;
      }
      return com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Use Google default encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.EncryptionConfig
            .GoogleDefaultEncryptionOptionsOrBuilder
        getGoogleDefaultEncryptionOrBuilder() {
      if (encryptionTypeCase_ == 1) {
        return (com.google.firestore.admin.v1.Database.EncryptionConfig
                .GoogleDefaultEncryptionOptions)
            encryptionType_;
      }
      return com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
          .getDefaultInstance();
    }

    public static final int USE_SOURCE_ENCRYPTION_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * The database will use the same encryption configuration as the source.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
     * </code>
     *
     * @return Whether the useSourceEncryption field is set.
     */
    @java.lang.Override
    public boolean hasUseSourceEncryption() {
      return encryptionTypeCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The database will use the same encryption configuration as the source.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
     * </code>
     *
     * @return The useSourceEncryption.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
        getUseSourceEncryption() {
      if (encryptionTypeCase_ == 2) {
        return (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
            encryptionType_;
      }
      return com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * The database will use the same encryption configuration as the source.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptionsOrBuilder
        getUseSourceEncryptionOrBuilder() {
      if (encryptionTypeCase_ == 2) {
        return (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
            encryptionType_;
      }
      return com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          .getDefaultInstance();
    }

    public static final int CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Use Customer Managed Encryption Keys (CMEK) for encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
     * </code>
     *
     * @return Whether the customerManagedEncryption field is set.
     */
    @java.lang.Override
    public boolean hasCustomerManagedEncryption() {
      return encryptionTypeCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Use Customer Managed Encryption Keys (CMEK) for encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
     * </code>
     *
     * @return The customerManagedEncryption.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
        getCustomerManagedEncryption() {
      if (encryptionTypeCase_ == 3) {
        return (com.google.firestore.admin.v1.Database.EncryptionConfig
                .CustomerManagedEncryptionOptions)
            encryptionType_;
      }
      return com.google.firestore.admin.v1.Database.EncryptionConfig
          .CustomerManagedEncryptionOptions.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Use Customer Managed Encryption Keys (CMEK) for encryption.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.EncryptionConfig
            .CustomerManagedEncryptionOptionsOrBuilder
        getCustomerManagedEncryptionOrBuilder() {
      if (encryptionTypeCase_ == 3) {
        return (com.google.firestore.admin.v1.Database.EncryptionConfig
                .CustomerManagedEncryptionOptions)
            encryptionType_;
      }
      return com.google.firestore.admin.v1.Database.EncryptionConfig
          .CustomerManagedEncryptionOptions.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (encryptionTypeCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions)
                encryptionType_);
      }
      if (encryptionTypeCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
                encryptionType_);
      }
      if (encryptionTypeCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.firestore.admin.v1.Database.EncryptionConfig
                    .CustomerManagedEncryptionOptions)
                encryptionType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (encryptionTypeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.firestore.admin.v1.Database.EncryptionConfig
                        .GoogleDefaultEncryptionOptions)
                    encryptionType_);
      }
      if (encryptionTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
                    encryptionType_);
      }
      if (encryptionTypeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.firestore.admin.v1.Database.EncryptionConfig
                        .CustomerManagedEncryptionOptions)
                    encryptionType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.admin.v1.Database.EncryptionConfig)) {
        return super.equals(obj);
      }
      com.google.firestore.admin.v1.Database.EncryptionConfig other =
          (com.google.firestore.admin.v1.Database.EncryptionConfig) obj;

      if (!getEncryptionTypeCase().equals(other.getEncryptionTypeCase())) return false;
      switch (encryptionTypeCase_) {
        case 1:
          if (!getGoogleDefaultEncryption().equals(other.getGoogleDefaultEncryption()))
            return false;
          break;
        case 2:
          if (!getUseSourceEncryption().equals(other.getUseSourceEncryption())) return false;
          break;
        case 3:
          if (!getCustomerManagedEncryption().equals(other.getCustomerManagedEncryption()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (encryptionTypeCase_) {
        case 1:
          hash = (37 * hash) + GOOGLE_DEFAULT_ENCRYPTION_FIELD_NUMBER;
          hash = (53 * hash) + getGoogleDefaultEncryption().hashCode();
          break;
        case 2:
          hash = (37 * hash) + USE_SOURCE_ENCRYPTION_FIELD_NUMBER;
          hash = (53 * hash) + getUseSourceEncryption().hashCode();
          break;
        case 3:
          hash = (37 * hash) + CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER;
          hash = (53 * hash) + getCustomerManagedEncryption().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.admin.v1.Database.EncryptionConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Encryption configuration for a new database being created from another
     * source.
     *
     * The source could be a [Backup][google.firestore.admin.v1.Backup] .
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.Database.EncryptionConfig}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database.EncryptionConfig)
        com.google.firestore.admin.v1.Database.EncryptionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Database.EncryptionConfig.class,
                com.google.firestore.admin.v1.Database.EncryptionConfig.Builder.class);
      }

      // Construct using com.google.firestore.admin.v1.Database.EncryptionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (googleDefaultEncryptionBuilder_ != null) {
          googleDefaultEncryptionBuilder_.clear();
        }
        if (useSourceEncryptionBuilder_ != null) {
          useSourceEncryptionBuilder_.clear();
        }
        if (customerManagedEncryptionBuilder_ != null) {
          customerManagedEncryptionBuilder_.clear();
        }
        encryptionTypeCase_ = 0;
        encryptionType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.admin.v1.DatabaseProto
            .internal_static_google_firestore_admin_v1_Database_EncryptionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig getDefaultInstanceForType() {
        return com.google.firestore.admin.v1.Database.EncryptionConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig build() {
        com.google.firestore.admin.v1.Database.EncryptionConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig buildPartial() {
        com.google.firestore.admin.v1.Database.EncryptionConfig result =
            new com.google.firestore.admin.v1.Database.EncryptionConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.firestore.admin.v1.Database.EncryptionConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.firestore.admin.v1.Database.EncryptionConfig result) {
        result.encryptionTypeCase_ = encryptionTypeCase_;
        result.encryptionType_ = this.encryptionType_;
        if (encryptionTypeCase_ == 1 && googleDefaultEncryptionBuilder_ != null) {
          result.encryptionType_ = googleDefaultEncryptionBuilder_.build();
        }
        if (encryptionTypeCase_ == 2 && useSourceEncryptionBuilder_ != null) {
          result.encryptionType_ = useSourceEncryptionBuilder_.build();
        }
        if (encryptionTypeCase_ == 3 && customerManagedEncryptionBuilder_ != null) {
          result.encryptionType_ = customerManagedEncryptionBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.admin.v1.Database.EncryptionConfig) {
          return mergeFrom((com.google.firestore.admin.v1.Database.EncryptionConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.admin.v1.Database.EncryptionConfig other) {
        if (other == com.google.firestore.admin.v1.Database.EncryptionConfig.getDefaultInstance())
          return this;
        switch (other.getEncryptionTypeCase()) {
          case GOOGLE_DEFAULT_ENCRYPTION:
            {
              mergeGoogleDefaultEncryption(other.getGoogleDefaultEncryption());
              break;
            }
          case USE_SOURCE_ENCRYPTION:
            {
              mergeUseSourceEncryption(other.getUseSourceEncryption());
              break;
            }
          case CUSTOMER_MANAGED_ENCRYPTION:
            {
              mergeCustomerManagedEncryption(other.getCustomerManagedEncryption());
              break;
            }
          case ENCRYPTIONTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetGoogleDefaultEncryptionFieldBuilder().getBuilder(),
                      extensionRegistry);
                  encryptionTypeCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      internalGetUseSourceEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                  encryptionTypeCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      internalGetCustomerManagedEncryptionFieldBuilder().getBuilder(),
                      extensionRegistry);
                  encryptionTypeCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int encryptionTypeCase_ = 0;
      private java.lang.Object encryptionType_;

      public EncryptionTypeCase getEncryptionTypeCase() {
        return EncryptionTypeCase.forNumber(encryptionTypeCase_);
      }

      public Builder clearEncryptionType() {
        encryptionTypeCase_ = 0;
        encryptionType_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .GoogleDefaultEncryptionOptions,
              com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
                  .Builder,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .GoogleDefaultEncryptionOptionsOrBuilder>
          googleDefaultEncryptionBuilder_;

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       *
       * @return Whether the googleDefaultEncryption field is set.
       */
      @java.lang.Override
      public boolean hasGoogleDefaultEncryption() {
        return encryptionTypeCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       *
       * @return The googleDefaultEncryption.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
          getGoogleDefaultEncryption() {
        if (googleDefaultEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 1) {
            return (com.google.firestore.admin.v1.Database.EncryptionConfig
                    .GoogleDefaultEncryptionOptions)
                encryptionType_;
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions.getDefaultInstance();
        } else {
          if (encryptionTypeCase_ == 1) {
            return googleDefaultEncryptionBuilder_.getMessage();
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       */
      public Builder setGoogleDefaultEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
              value) {
        if (googleDefaultEncryptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encryptionType_ = value;
          onChanged();
        } else {
          googleDefaultEncryptionBuilder_.setMessage(value);
        }
        encryptionTypeCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       */
      public Builder setGoogleDefaultEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
                  .Builder
              builderForValue) {
        if (googleDefaultEncryptionBuilder_ == null) {
          encryptionType_ = builderForValue.build();
          onChanged();
        } else {
          googleDefaultEncryptionBuilder_.setMessage(builderForValue.build());
        }
        encryptionTypeCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       */
      public Builder mergeGoogleDefaultEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
              value) {
        if (googleDefaultEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 1
              && encryptionType_
                  != com.google.firestore.admin.v1.Database.EncryptionConfig
                      .GoogleDefaultEncryptionOptions.getDefaultInstance()) {
            encryptionType_ =
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .GoogleDefaultEncryptionOptions.newBuilder(
                        (com.google.firestore.admin.v1.Database.EncryptionConfig
                                .GoogleDefaultEncryptionOptions)
                            encryptionType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            encryptionType_ = value;
          }
          onChanged();
        } else {
          if (encryptionTypeCase_ == 1) {
            googleDefaultEncryptionBuilder_.mergeFrom(value);
          } else {
            googleDefaultEncryptionBuilder_.setMessage(value);
          }
        }
        encryptionTypeCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       */
      public Builder clearGoogleDefaultEncryption() {
        if (googleDefaultEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 1) {
            encryptionTypeCase_ = 0;
            encryptionType_ = null;
            onChanged();
          }
        } else {
          if (encryptionTypeCase_ == 1) {
            encryptionTypeCase_ = 0;
            encryptionType_ = null;
          }
          googleDefaultEncryptionBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       */
      public com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
              .Builder
          getGoogleDefaultEncryptionBuilder() {
        return internalGetGoogleDefaultEncryptionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptionsOrBuilder
          getGoogleDefaultEncryptionOrBuilder() {
        if ((encryptionTypeCase_ == 1) && (googleDefaultEncryptionBuilder_ != null)) {
          return googleDefaultEncryptionBuilder_.getMessageOrBuilder();
        } else {
          if (encryptionTypeCase_ == 1) {
            return (com.google.firestore.admin.v1.Database.EncryptionConfig
                    .GoogleDefaultEncryptionOptions)
                encryptionType_;
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .GoogleDefaultEncryptionOptions.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Use Google default encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions google_default_encryption = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .GoogleDefaultEncryptionOptions,
              com.google.firestore.admin.v1.Database.EncryptionConfig.GoogleDefaultEncryptionOptions
                  .Builder,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .GoogleDefaultEncryptionOptionsOrBuilder>
          internalGetGoogleDefaultEncryptionFieldBuilder() {
        if (googleDefaultEncryptionBuilder_ == null) {
          if (!(encryptionTypeCase_ == 1)) {
            encryptionType_ =
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .GoogleDefaultEncryptionOptions.getDefaultInstance();
          }
          googleDefaultEncryptionBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .GoogleDefaultEncryptionOptions,
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .GoogleDefaultEncryptionOptions.Builder,
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .GoogleDefaultEncryptionOptionsOrBuilder>(
                  (com.google.firestore.admin.v1.Database.EncryptionConfig
                          .GoogleDefaultEncryptionOptions)
                      encryptionType_,
                  getParentForChildren(),
                  isClean());
          encryptionType_ = null;
        }
        encryptionTypeCase_ = 1;
        onChanged();
        return googleDefaultEncryptionBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions,
              com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                  .Builder,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .SourceEncryptionOptionsOrBuilder>
          useSourceEncryptionBuilder_;

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       *
       * @return Whether the useSourceEncryption field is set.
       */
      @java.lang.Override
      public boolean hasUseSourceEncryption() {
        return encryptionTypeCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       *
       * @return The useSourceEncryption.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
          getUseSourceEncryption() {
        if (useSourceEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 2) {
            return (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
                encryptionType_;
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
              .getDefaultInstance();
        } else {
          if (encryptionTypeCase_ == 2) {
            return useSourceEncryptionBuilder_.getMessage();
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       */
      public Builder setUseSourceEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions value) {
        if (useSourceEncryptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encryptionType_ = value;
          onChanged();
        } else {
          useSourceEncryptionBuilder_.setMessage(value);
        }
        encryptionTypeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       */
      public Builder setUseSourceEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions.Builder
              builderForValue) {
        if (useSourceEncryptionBuilder_ == null) {
          encryptionType_ = builderForValue.build();
          onChanged();
        } else {
          useSourceEncryptionBuilder_.setMessage(builderForValue.build());
        }
        encryptionTypeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       */
      public Builder mergeUseSourceEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions value) {
        if (useSourceEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 2
              && encryptionType_
                  != com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                      .getDefaultInstance()) {
            encryptionType_ =
                com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                    .newBuilder(
                        (com.google.firestore.admin.v1.Database.EncryptionConfig
                                .SourceEncryptionOptions)
                            encryptionType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            encryptionType_ = value;
          }
          onChanged();
        } else {
          if (encryptionTypeCase_ == 2) {
            useSourceEncryptionBuilder_.mergeFrom(value);
          } else {
            useSourceEncryptionBuilder_.setMessage(value);
          }
        }
        encryptionTypeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       */
      public Builder clearUseSourceEncryption() {
        if (useSourceEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 2) {
            encryptionTypeCase_ = 0;
            encryptionType_ = null;
            onChanged();
          }
        } else {
          if (encryptionTypeCase_ == 2) {
            encryptionTypeCase_ = 0;
            encryptionType_ = null;
          }
          useSourceEncryptionBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       */
      public com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions.Builder
          getUseSourceEncryptionBuilder() {
        return internalGetUseSourceEncryptionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig
              .SourceEncryptionOptionsOrBuilder
          getUseSourceEncryptionOrBuilder() {
        if ((encryptionTypeCase_ == 2) && (useSourceEncryptionBuilder_ != null)) {
          return useSourceEncryptionBuilder_.getMessageOrBuilder();
        } else {
          if (encryptionTypeCase_ == 2) {
            return (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
                encryptionType_;
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * The database will use the same encryption configuration as the source.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions use_source_encryption = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions,
              com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                  .Builder,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .SourceEncryptionOptionsOrBuilder>
          internalGetUseSourceEncryptionFieldBuilder() {
        if (useSourceEncryptionBuilder_ == null) {
          if (!(encryptionTypeCase_ == 2)) {
            encryptionType_ =
                com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                    .getDefaultInstance();
          }
          useSourceEncryptionBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions,
                  com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions
                      .Builder,
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .SourceEncryptionOptionsOrBuilder>(
                  (com.google.firestore.admin.v1.Database.EncryptionConfig.SourceEncryptionOptions)
                      encryptionType_,
                  getParentForChildren(),
                  isClean());
          encryptionType_ = null;
        }
        encryptionTypeCase_ = 2;
        onChanged();
        return useSourceEncryptionBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptions,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptions.Builder,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptionsOrBuilder>
          customerManagedEncryptionBuilder_;

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       *
       * @return Whether the customerManagedEncryption field is set.
       */
      @java.lang.Override
      public boolean hasCustomerManagedEncryption() {
        return encryptionTypeCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       *
       * @return The customerManagedEncryption.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions
          getCustomerManagedEncryption() {
        if (customerManagedEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 3) {
            return (com.google.firestore.admin.v1.Database.EncryptionConfig
                    .CustomerManagedEncryptionOptions)
                encryptionType_;
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions.getDefaultInstance();
        } else {
          if (encryptionTypeCase_ == 3) {
            return customerManagedEncryptionBuilder_.getMessage();
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       */
      public Builder setCustomerManagedEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
              value) {
        if (customerManagedEncryptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encryptionType_ = value;
          onChanged();
        } else {
          customerManagedEncryptionBuilder_.setMessage(value);
        }
        encryptionTypeCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       */
      public Builder setCustomerManagedEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
                  .Builder
              builderForValue) {
        if (customerManagedEncryptionBuilder_ == null) {
          encryptionType_ = builderForValue.build();
          onChanged();
        } else {
          customerManagedEncryptionBuilder_.setMessage(builderForValue.build());
        }
        encryptionTypeCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       */
      public Builder mergeCustomerManagedEncryption(
          com.google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions
              value) {
        if (customerManagedEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 3
              && encryptionType_
                  != com.google.firestore.admin.v1.Database.EncryptionConfig
                      .CustomerManagedEncryptionOptions.getDefaultInstance()) {
            encryptionType_ =
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .CustomerManagedEncryptionOptions.newBuilder(
                        (com.google.firestore.admin.v1.Database.EncryptionConfig
                                .CustomerManagedEncryptionOptions)
                            encryptionType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            encryptionType_ = value;
          }
          onChanged();
        } else {
          if (encryptionTypeCase_ == 3) {
            customerManagedEncryptionBuilder_.mergeFrom(value);
          } else {
            customerManagedEncryptionBuilder_.setMessage(value);
          }
        }
        encryptionTypeCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       */
      public Builder clearCustomerManagedEncryption() {
        if (customerManagedEncryptionBuilder_ == null) {
          if (encryptionTypeCase_ == 3) {
            encryptionTypeCase_ = 0;
            encryptionType_ = null;
            onChanged();
          }
        } else {
          if (encryptionTypeCase_ == 3) {
            encryptionTypeCase_ = 0;
            encryptionType_ = null;
          }
          customerManagedEncryptionBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       */
      public com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions.Builder
          getCustomerManagedEncryptionBuilder() {
        return internalGetCustomerManagedEncryptionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptionsOrBuilder
          getCustomerManagedEncryptionOrBuilder() {
        if ((encryptionTypeCase_ == 3) && (customerManagedEncryptionBuilder_ != null)) {
          return customerManagedEncryptionBuilder_.getMessageOrBuilder();
        } else {
          if (encryptionTypeCase_ == 3) {
            return (com.google.firestore.admin.v1.Database.EncryptionConfig
                    .CustomerManagedEncryptionOptions)
                encryptionType_;
          }
          return com.google.firestore.admin.v1.Database.EncryptionConfig
              .CustomerManagedEncryptionOptions.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Use Customer Managed Encryption Keys (CMEK) for encryption.
       * </pre>
       *
       * <code>
       * .google.firestore.admin.v1.Database.EncryptionConfig.CustomerManagedEncryptionOptions customer_managed_encryption = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptions,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptions.Builder,
              com.google.firestore.admin.v1.Database.EncryptionConfig
                  .CustomerManagedEncryptionOptionsOrBuilder>
          internalGetCustomerManagedEncryptionFieldBuilder() {
        if (customerManagedEncryptionBuilder_ == null) {
          if (!(encryptionTypeCase_ == 3)) {
            encryptionType_ =
                com.google.firestore.admin.v1.Database.EncryptionConfig
                    .CustomerManagedEncryptionOptions.getDefaultInstance();
          }
          customerManagedEncryptionBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .CustomerManagedEncryptionOptions,
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .CustomerManagedEncryptionOptions.Builder,
                  com.google.firestore.admin.v1.Database.EncryptionConfig
                      .CustomerManagedEncryptionOptionsOrBuilder>(
                  (com.google.firestore.admin.v1.Database.EncryptionConfig
                          .CustomerManagedEncryptionOptions)
                      encryptionType_,
                  getParentForChildren(),
                  isClean());
          encryptionType_ = null;
        }
        encryptionTypeCase_ = 3;
        onChanged();
        return customerManagedEncryptionBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database.EncryptionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database.EncryptionConfig)
    private static final com.google.firestore.admin.v1.Database.EncryptionConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Database.EncryptionConfig();
    }

    public static com.google.firestore.admin.v1.Database.EncryptionConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EncryptionConfig> PARSER =
        new com.google.protobuf.AbstractParser<EncryptionConfig>() {
          @java.lang.Override
          public EncryptionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EncryptionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EncryptionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database.EncryptionConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The resource name of the Database.
   * Format: `projects/{project}/databases/{database}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The resource name of the Database.
   * Format: `projects/{project}/databases/{database}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The system-generated UUID4 for this Database.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The system-generated UUID4 for this Database.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was created. Databases
   * created before 2016 do not populate create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was created. Databases
   * created before 2016 do not populate create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was created. Databases
   * created before 2016 do not populate create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was most recently
   * updated. Note this only includes updates to the database resource and not
   * data contained by the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was most recently
   * updated. Note this only includes updates to the database resource and not
   * data contained by the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was most recently
   * updated. Note this only includes updates to the database resource and not
   * data contained by the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was deleted. Only set if
   * the database has been deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was deleted. Only set if
   * the database has been deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was deleted. Only set if
   * the database has been deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationId_ = "";

  /**
   *
   *
   * <pre>
   * The location of the database. Available locations are listed at
   * https://cloud.google.com/firestore/docs/locations.
   * </pre>
   *
   * <code>string location_id = 9;</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The location of the database. Available locations are listed at
   * https://cloud.google.com/firestore/docs/locations.
   * </pre>
   *
   * <code>string location_id = 9;</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 10;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.DatabaseType getType() {
    com.google.firestore.admin.v1.Database.DatabaseType result =
        com.google.firestore.admin.v1.Database.DatabaseType.forNumber(type_);
    return result == null
        ? com.google.firestore.admin.v1.Database.DatabaseType.UNRECOGNIZED
        : result;
  }

  public static final int CONCURRENCY_MODE_FIELD_NUMBER = 15;
  private int concurrencyMode_ = 0;

  /**
   *
   *
   * <pre>
   * The concurrency control mode to use for this database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
   *
   * @return The enum numeric value on the wire for concurrencyMode.
   */
  @java.lang.Override
  public int getConcurrencyModeValue() {
    return concurrencyMode_;
  }

  /**
   *
   *
   * <pre>
   * The concurrency control mode to use for this database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
   *
   * @return The concurrencyMode.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.ConcurrencyMode getConcurrencyMode() {
    com.google.firestore.admin.v1.Database.ConcurrencyMode result =
        com.google.firestore.admin.v1.Database.ConcurrencyMode.forNumber(concurrencyMode_);
    return result == null
        ? com.google.firestore.admin.v1.Database.ConcurrencyMode.UNRECOGNIZED
        : result;
  }

  public static final int VERSION_RETENTION_PERIOD_FIELD_NUMBER = 17;
  private com.google.protobuf.Duration versionRetentionPeriod_;

  /**
   *
   *
   * <pre>
   * Output only. The period during which past versions of data are retained in
   * the database.
   *
   * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
   * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
   * a `read_time` within this window, and will read the state of the database
   * at that time.
   *
   * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
   * the retention period is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the versionRetentionPeriod field is set.
   */
  @java.lang.Override
  public boolean hasVersionRetentionPeriod() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The period during which past versions of data are retained in
   * the database.
   *
   * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
   * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
   * a `read_time` within this window, and will read the state of the database
   * at that time.
   *
   * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
   * the retention period is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionRetentionPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getVersionRetentionPeriod() {
    return versionRetentionPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : versionRetentionPeriod_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The period during which past versions of data are retained in
   * the database.
   *
   * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
   * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
   * a `read_time` within this window, and will read the state of the database
   * at that time.
   *
   * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
   * the retention period is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getVersionRetentionPeriodOrBuilder() {
    return versionRetentionPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : versionRetentionPeriod_;
  }

  public static final int EARLIEST_VERSION_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp earliestVersionTime_;

  /**
   *
   *
   * <pre>
   * Output only. The earliest timestamp at which older versions of the data can
   * be read from the database. See [version_retention_period] above; this field
   * is populated with `now - version_retention_period`.
   *
   * This value is continuously updated, and becomes stale the moment it is
   * queried. If you are using this value to recover data, make sure to account
   * for the time from the moment when the value is queried to the moment when
   * you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the earliestVersionTime field is set.
   */
  @java.lang.Override
  public boolean hasEarliestVersionTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The earliest timestamp at which older versions of the data can
   * be read from the database. See [version_retention_period] above; this field
   * is populated with `now - version_retention_period`.
   *
   * This value is continuously updated, and becomes stale the moment it is
   * queried. If you are using this value to recover data, make sure to account
   * for the time from the moment when the value is queried to the moment when
   * you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The earliestVersionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEarliestVersionTime() {
    return earliestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestVersionTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The earliest timestamp at which older versions of the data can
   * be read from the database. See [version_retention_period] above; this field
   * is populated with `now - version_retention_period`.
   *
   * This value is continuously updated, and becomes stale the moment it is
   * queried. If you are using this value to recover data, make sure to account
   * for the time from the moment when the value is queried to the moment when
   * you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
    return earliestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestVersionTime_;
  }

  public static final int POINT_IN_TIME_RECOVERY_ENABLEMENT_FIELD_NUMBER = 21;
  private int pointInTimeRecoveryEnablement_ = 0;

  /**
   *
   *
   * <pre>
   * Whether to enable the PITR feature on this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
   * </code>
   *
   * @return The enum numeric value on the wire for pointInTimeRecoveryEnablement.
   */
  @java.lang.Override
  public int getPointInTimeRecoveryEnablementValue() {
    return pointInTimeRecoveryEnablement_;
  }

  /**
   *
   *
   * <pre>
   * Whether to enable the PITR feature on this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
   * </code>
   *
   * @return The pointInTimeRecoveryEnablement.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
      getPointInTimeRecoveryEnablement() {
    com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement result =
        com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.forNumber(
            pointInTimeRecoveryEnablement_);
    return result == null
        ? com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.UNRECOGNIZED
        : result;
  }

  public static final int APP_ENGINE_INTEGRATION_MODE_FIELD_NUMBER = 19;
  private int appEngineIntegrationMode_ = 0;

  /**
   *
   *
   * <pre>
   * The App Engine integration mode to use for this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
   * </code>
   *
   * @return The enum numeric value on the wire for appEngineIntegrationMode.
   */
  @java.lang.Override
  public int getAppEngineIntegrationModeValue() {
    return appEngineIntegrationMode_;
  }

  /**
   *
   *
   * <pre>
   * The App Engine integration mode to use for this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
   * </code>
   *
   * @return The appEngineIntegrationMode.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
      getAppEngineIntegrationMode() {
    com.google.firestore.admin.v1.Database.AppEngineIntegrationMode result =
        com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.forNumber(
            appEngineIntegrationMode_);
    return result == null
        ? com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.UNRECOGNIZED
        : result;
  }

  public static final int KEY_PREFIX_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyPrefix_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The key_prefix for this database. This key_prefix is used, in
   * combination with the project ID ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
   * the application ID that is returned from the Cloud Datastore APIs in Google
   * App Engine first generation runtimes.
   *
   * This value may be empty in which case the appid to use for URL-encoded keys
   * is the project_id (eg: foo instead of v~foo).
   * </pre>
   *
   * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The keyPrefix.
   */
  @java.lang.Override
  public java.lang.String getKeyPrefix() {
    java.lang.Object ref = keyPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyPrefix_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The key_prefix for this database. This key_prefix is used, in
   * combination with the project ID ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
   * the application ID that is returned from the Cloud Datastore APIs in Google
   * App Engine first generation runtimes.
   *
   * This value may be empty in which case the appid to use for URL-encoded keys
   * is the project_id (eg: foo instead of v~foo).
   * </pre>
   *
   * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for keyPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyPrefixBytes() {
    java.lang.Object ref = keyPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETE_PROTECTION_STATE_FIELD_NUMBER = 22;
  private int deleteProtectionState_ = 0;

  /**
   *
   *
   * <pre>
   * State of delete protection for the database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
   * </code>
   *
   * @return The enum numeric value on the wire for deleteProtectionState.
   */
  @java.lang.Override
  public int getDeleteProtectionStateValue() {
    return deleteProtectionState_;
  }

  /**
   *
   *
   * <pre>
   * State of delete protection for the database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
   * </code>
   *
   * @return The deleteProtectionState.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.DeleteProtectionState getDeleteProtectionState() {
    com.google.firestore.admin.v1.Database.DeleteProtectionState result =
        com.google.firestore.admin.v1.Database.DeleteProtectionState.forNumber(
            deleteProtectionState_);
    return result == null
        ? com.google.firestore.admin.v1.Database.DeleteProtectionState.UNRECOGNIZED
        : result;
  }

  public static final int CMEK_CONFIG_FIELD_NUMBER = 23;
  private com.google.firestore.admin.v1.Database.CmekConfig cmekConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Presence indicates CMEK is enabled for this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cmekConfig field is set.
   */
  @java.lang.Override
  public boolean hasCmekConfig() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Presence indicates CMEK is enabled for this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cmekConfig.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.CmekConfig getCmekConfig() {
    return cmekConfig_ == null
        ? com.google.firestore.admin.v1.Database.CmekConfig.getDefaultInstance()
        : cmekConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Presence indicates CMEK is enabled for this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.CmekConfigOrBuilder getCmekConfigOrBuilder() {
    return cmekConfig_ == null
        ? com.google.firestore.admin.v1.Database.CmekConfig.getDefaultInstance()
        : cmekConfig_;
  }

  public static final int PREVIOUS_ID_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object previousId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The database resource's prior database ID. This field is only
   * populated for deleted databases.
   * </pre>
   *
   * <code>string previous_id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The previousId.
   */
  @java.lang.Override
  public java.lang.String getPreviousId() {
    java.lang.Object ref = previousId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      previousId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The database resource's prior database ID. This field is only
   * populated for deleted databases.
   * </pre>
   *
   * <code>string previous_id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for previousId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPreviousIdBytes() {
    java.lang.Object ref = previousId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      previousId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_INFO_FIELD_NUMBER = 26;
  private com.google.firestore.admin.v1.Database.SourceInfo sourceInfo_;

  /**
   *
   *
   * <pre>
   * Output only. Information about the provenance of this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the sourceInfo field is set.
   */
  @java.lang.Override
  public boolean hasSourceInfo() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Information about the provenance of this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The sourceInfo.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.SourceInfo getSourceInfo() {
    return sourceInfo_ == null
        ? com.google.firestore.admin.v1.Database.SourceInfo.getDefaultInstance()
        : sourceInfo_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Information about the provenance of this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.SourceInfoOrBuilder getSourceInfoOrBuilder() {
    return sourceInfo_ == null
        ? com.google.firestore.admin.v1.Database.SourceInfo.getDefaultInstance()
        : sourceInfo_;
  }

  public static final int TAGS_FIELD_NUMBER = 29;

  private static final class TagsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.firestore.admin.v1.DatabaseProto
                .internal_static_google_firestore_admin_v1_Database_TagsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> tags_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetTags() {
    if (tags_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TagsDefaultEntryHolder.defaultEntry);
    }
    return tags_;
  }

  public int getTagsCount() {
    return internalGetTags().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Tag keys/values directly bound to this
   * resource. For example:
   * "123/environment": "production",
   * "123/costCenter": "marketing"
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsTags(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTags().getMap().containsKey(key);
  }

  /** Use {@link #getTagsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getTags() {
    return getTagsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Tag keys/values directly bound to this
   * resource. For example:
   * "123/environment": "production",
   * "123/costCenter": "marketing"
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getTagsMap() {
    return internalGetTags().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Tag keys/values directly bound to this
   * resource. For example:
   * "123/environment": "production",
   * "123/costCenter": "marketing"
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getTagsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Input only. Immutable. Tag keys/values directly bound to this
   * resource. For example:
   * "123/environment": "production",
   * "123/costCenter": "marketing"
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getTagsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FREE_TIER_FIELD_NUMBER = 30;
  private boolean freeTier_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Background: Free tier is the ability of a Firestore database
   * to use a small amount of resources every day without being charged. Once
   * usage exceeds the free tier limit further usage is charged.
   *
   * Whether this database can make use of the free tier. Only one database
   * per project can be eligible for the free tier.
   *
   * The first (or next) database that is created in a project without a free
   * tier database will be marked as eligible for the free tier. Databases that
   * are created while there is a free tier database will not be eligible for
   * the free tier.
   * </pre>
   *
   * <code>optional bool free_tier = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the freeTier field is set.
   */
  @java.lang.Override
  public boolean hasFreeTier() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Background: Free tier is the ability of a Firestore database
   * to use a small amount of resources every day without being charged. Once
   * usage exceeds the free tier limit further usage is charged.
   *
   * Whether this database can make use of the free tier. Only one database
   * per project can be eligible for the free tier.
   *
   * The first (or next) database that is created in a project without a free
   * tier database will be marked as eligible for the free tier. Databases that
   * are created while there is a free tier database will not be eligible for
   * the free tier.
   * </pre>
   *
   * <code>optional bool free_tier = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The freeTier.
   */
  @java.lang.Override
  public boolean getFreeTier() {
    return freeTier_;
  }

  public static final int ETAG_FIELD_NUMBER = 99;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 99;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 99;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_EDITION_FIELD_NUMBER = 28;
  private int databaseEdition_ = 0;

  /**
   *
   *
   * <pre>
   * Immutable. The edition of the database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.DatabaseEdition database_edition = 28 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseEdition.
   */
  @java.lang.Override
  public int getDatabaseEditionValue() {
    return databaseEdition_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The edition of the database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.DatabaseEdition database_edition = 28 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The databaseEdition.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.DatabaseEdition getDatabaseEdition() {
    com.google.firestore.admin.v1.Database.DatabaseEdition result =
        com.google.firestore.admin.v1.Database.DatabaseEdition.forNumber(databaseEdition_);
    return result == null
        ? com.google.firestore.admin.v1.Database.DatabaseEdition.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 9, locationId_);
    }
    if (type_
        != com.google.firestore.admin.v1.Database.DatabaseType.DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, type_);
    }
    if (concurrencyMode_
        != com.google.firestore.admin.v1.Database.ConcurrencyMode.CONCURRENCY_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, concurrencyMode_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(17, getVersionRetentionPeriod());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(18, getEarliestVersionTime());
    }
    if (appEngineIntegrationMode_
        != com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
            .APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(19, appEngineIntegrationMode_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(keyPrefix_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 20, keyPrefix_);
    }
    if (pointInTimeRecoveryEnablement_
        != com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
            .POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(21, pointInTimeRecoveryEnablement_);
    }
    if (deleteProtectionState_
        != com.google.firestore.admin.v1.Database.DeleteProtectionState
            .DELETE_PROTECTION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(22, deleteProtectionState_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(23, getCmekConfig());
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(previousId_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 25, previousId_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(26, getSourceInfo());
    }
    if (databaseEdition_
        != com.google.firestore.admin.v1.Database.DatabaseEdition.DATABASE_EDITION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(28, databaseEdition_);
    }
    com.google.protobuf.GeneratedMessage.serializeStringMapTo(
        output, internalGetTags(), TagsDefaultEntryHolder.defaultEntry, 29);
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(30, freeTier_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 99, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(9, locationId_);
    }
    if (type_
        != com.google.firestore.admin.v1.Database.DatabaseType.DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, type_);
    }
    if (concurrencyMode_
        != com.google.firestore.admin.v1.Database.ConcurrencyMode.CONCURRENCY_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, concurrencyMode_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(17, getVersionRetentionPeriod());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(18, getEarliestVersionTime());
    }
    if (appEngineIntegrationMode_
        != com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
            .APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, appEngineIntegrationMode_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(keyPrefix_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(20, keyPrefix_);
    }
    if (pointInTimeRecoveryEnablement_
        != com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
            .POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(21, pointInTimeRecoveryEnablement_);
    }
    if (deleteProtectionState_
        != com.google.firestore.admin.v1.Database.DeleteProtectionState
            .DELETE_PROTECTION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(22, deleteProtectionState_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getCmekConfig());
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(previousId_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(25, previousId_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getSourceInfo());
    }
    if (databaseEdition_
        != com.google.firestore.admin.v1.Database.DatabaseEdition.DATABASE_EDITION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(28, databaseEdition_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetTags().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> tags__ =
          TagsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, tags__);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(30, freeTier_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(99, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.Database)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.Database other = (com.google.firestore.admin.v1.Database) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (type_ != other.type_) return false;
    if (concurrencyMode_ != other.concurrencyMode_) return false;
    if (hasVersionRetentionPeriod() != other.hasVersionRetentionPeriod()) return false;
    if (hasVersionRetentionPeriod()) {
      if (!getVersionRetentionPeriod().equals(other.getVersionRetentionPeriod())) return false;
    }
    if (hasEarliestVersionTime() != other.hasEarliestVersionTime()) return false;
    if (hasEarliestVersionTime()) {
      if (!getEarliestVersionTime().equals(other.getEarliestVersionTime())) return false;
    }
    if (pointInTimeRecoveryEnablement_ != other.pointInTimeRecoveryEnablement_) return false;
    if (appEngineIntegrationMode_ != other.appEngineIntegrationMode_) return false;
    if (!getKeyPrefix().equals(other.getKeyPrefix())) return false;
    if (deleteProtectionState_ != other.deleteProtectionState_) return false;
    if (hasCmekConfig() != other.hasCmekConfig()) return false;
    if (hasCmekConfig()) {
      if (!getCmekConfig().equals(other.getCmekConfig())) return false;
    }
    if (!getPreviousId().equals(other.getPreviousId())) return false;
    if (hasSourceInfo() != other.hasSourceInfo()) return false;
    if (hasSourceInfo()) {
      if (!getSourceInfo().equals(other.getSourceInfo())) return false;
    }
    if (!internalGetTags().equals(other.internalGetTags())) return false;
    if (hasFreeTier() != other.hasFreeTier()) return false;
    if (hasFreeTier()) {
      if (getFreeTier() != other.getFreeTier()) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (databaseEdition_ != other.databaseEdition_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + CONCURRENCY_MODE_FIELD_NUMBER;
    hash = (53 * hash) + concurrencyMode_;
    if (hasVersionRetentionPeriod()) {
      hash = (37 * hash) + VERSION_RETENTION_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getVersionRetentionPeriod().hashCode();
    }
    if (hasEarliestVersionTime()) {
      hash = (37 * hash) + EARLIEST_VERSION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEarliestVersionTime().hashCode();
    }
    hash = (37 * hash) + POINT_IN_TIME_RECOVERY_ENABLEMENT_FIELD_NUMBER;
    hash = (53 * hash) + pointInTimeRecoveryEnablement_;
    hash = (37 * hash) + APP_ENGINE_INTEGRATION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + appEngineIntegrationMode_;
    hash = (37 * hash) + KEY_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getKeyPrefix().hashCode();
    hash = (37 * hash) + DELETE_PROTECTION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + deleteProtectionState_;
    if (hasCmekConfig()) {
      hash = (37 * hash) + CMEK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCmekConfig().hashCode();
    }
    hash = (37 * hash) + PREVIOUS_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPreviousId().hashCode();
    if (hasSourceInfo()) {
      hash = (37 * hash) + SOURCE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSourceInfo().hashCode();
    }
    if (!internalGetTags().getMap().isEmpty()) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTags().hashCode();
    }
    if (hasFreeTier()) {
      hash = (37 * hash) + FREE_TIER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFreeTier());
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + DATABASE_EDITION_FIELD_NUMBER;
    hash = (53 * hash) + databaseEdition_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.Database parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.Database prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A Cloud Firestore Database.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Database}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database)
      com.google.firestore.admin.v1.DatabaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 29:
          return internalGetTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 29:
          return internalGetMutableTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Database.class,
              com.google.firestore.admin.v1.Database.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.Database.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetCreateTimeFieldBuilder();
        internalGetUpdateTimeFieldBuilder();
        internalGetDeleteTimeFieldBuilder();
        internalGetVersionRetentionPeriodFieldBuilder();
        internalGetEarliestVersionTimeFieldBuilder();
        internalGetCmekConfigFieldBuilder();
        internalGetSourceInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      locationId_ = "";
      type_ = 0;
      concurrencyMode_ = 0;
      versionRetentionPeriod_ = null;
      if (versionRetentionPeriodBuilder_ != null) {
        versionRetentionPeriodBuilder_.dispose();
        versionRetentionPeriodBuilder_ = null;
      }
      earliestVersionTime_ = null;
      if (earliestVersionTimeBuilder_ != null) {
        earliestVersionTimeBuilder_.dispose();
        earliestVersionTimeBuilder_ = null;
      }
      pointInTimeRecoveryEnablement_ = 0;
      appEngineIntegrationMode_ = 0;
      keyPrefix_ = "";
      deleteProtectionState_ = 0;
      cmekConfig_ = null;
      if (cmekConfigBuilder_ != null) {
        cmekConfigBuilder_.dispose();
        cmekConfigBuilder_ = null;
      }
      previousId_ = "";
      sourceInfo_ = null;
      if (sourceInfoBuilder_ != null) {
        sourceInfoBuilder_.dispose();
        sourceInfoBuilder_ = null;
      }
      internalGetMutableTags().clear();
      freeTier_ = false;
      etag_ = "";
      databaseEdition_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.Database.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database build() {
      com.google.firestore.admin.v1.Database result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database buildPartial() {
      com.google.firestore.admin.v1.Database result =
          new com.google.firestore.admin.v1.Database(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.Database result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.locationId_ = locationId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.concurrencyMode_ = concurrencyMode_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.versionRetentionPeriod_ =
            versionRetentionPeriodBuilder_ == null
                ? versionRetentionPeriod_
                : versionRetentionPeriodBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.earliestVersionTime_ =
            earliestVersionTimeBuilder_ == null
                ? earliestVersionTime_
                : earliestVersionTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.pointInTimeRecoveryEnablement_ = pointInTimeRecoveryEnablement_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.appEngineIntegrationMode_ = appEngineIntegrationMode_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.keyPrefix_ = keyPrefix_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.deleteProtectionState_ = deleteProtectionState_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.cmekConfig_ = cmekConfigBuilder_ == null ? cmekConfig_ : cmekConfigBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.previousId_ = previousId_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.sourceInfo_ = sourceInfoBuilder_ == null ? sourceInfo_ : sourceInfoBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.tags_ = internalGetTags();
        result.tags_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.freeTier_ = freeTier_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.databaseEdition_ = databaseEdition_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.Database) {
        return mergeFrom((com.google.firestore.admin.v1.Database) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.Database other) {
      if (other == com.google.firestore.admin.v1.Database.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.concurrencyMode_ != 0) {
        setConcurrencyModeValue(other.getConcurrencyModeValue());
      }
      if (other.hasVersionRetentionPeriod()) {
        mergeVersionRetentionPeriod(other.getVersionRetentionPeriod());
      }
      if (other.hasEarliestVersionTime()) {
        mergeEarliestVersionTime(other.getEarliestVersionTime());
      }
      if (other.pointInTimeRecoveryEnablement_ != 0) {
        setPointInTimeRecoveryEnablementValue(other.getPointInTimeRecoveryEnablementValue());
      }
      if (other.appEngineIntegrationMode_ != 0) {
        setAppEngineIntegrationModeValue(other.getAppEngineIntegrationModeValue());
      }
      if (!other.getKeyPrefix().isEmpty()) {
        keyPrefix_ = other.keyPrefix_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.deleteProtectionState_ != 0) {
        setDeleteProtectionStateValue(other.getDeleteProtectionStateValue());
      }
      if (other.hasCmekConfig()) {
        mergeCmekConfig(other.getCmekConfig());
      }
      if (!other.getPreviousId().isEmpty()) {
        previousId_ = other.previousId_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasSourceInfo()) {
        mergeSourceInfo(other.getSourceInfo());
      }
      internalGetMutableTags().mergeFrom(other.internalGetTags());
      bitField0_ |= 0x00020000;
      if (other.hasFreeTier()) {
        setFreeTier(other.getFreeTier());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.databaseEdition_ != 0) {
        setDatabaseEditionValue(other.getDatabaseEditionValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    internalGetCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    internalGetUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    internalGetDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 74:
              {
                locationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 80:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            case 120:
              {
                concurrencyMode_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 120
            case 138:
              {
                input.readMessage(
                    internalGetVersionRetentionPeriodFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    internalGetEarliestVersionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 146
            case 152:
              {
                appEngineIntegrationMode_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 152
            case 162:
              {
                keyPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 162
            case 168:
              {
                pointInTimeRecoveryEnablement_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 168
            case 176:
              {
                deleteProtectionState_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 176
            case 186:
              {
                input.readMessage(
                    internalGetCmekConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 186
            case 202:
              {
                previousId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(
                    internalGetSourceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 210
            case 224:
              {
                databaseEdition_ = input.readEnum();
                bitField0_ |= 0x00100000;
                break;
              } // case 224
            case 234:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> tags__ =
                    input.readMessage(
                        TagsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableTags().getMutableMap().put(tags__.getKey(), tags__.getValue());
                bitField0_ |= 0x00020000;
                break;
              } // case 234
            case 240:
              {
                freeTier_ = input.readBool();
                bitField0_ |= 0x00040000;
                break;
              } // case 240
            case 794:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 794
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return internalGetCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return internalGetUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return internalGetDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was deleted. Only set if
     * the database has been deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private java.lang.Object locationId_ = "";

    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {
      locationId_ = getDefaultInstance().getLocationId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.DatabaseType getType() {
      com.google.firestore.admin.v1.Database.DatabaseType result =
          com.google.firestore.admin.v1.Database.DatabaseType.forNumber(type_);
      return result == null
          ? com.google.firestore.admin.v1.Database.DatabaseType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.firestore.admin.v1.Database.DatabaseType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      type_ = 0;
      onChanged();
      return this;
    }

    private int concurrencyMode_ = 0;

    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return The enum numeric value on the wire for concurrencyMode.
     */
    @java.lang.Override
    public int getConcurrencyModeValue() {
      return concurrencyMode_;
    }

    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @param value The enum numeric value on the wire for concurrencyMode to set.
     * @return This builder for chaining.
     */
    public Builder setConcurrencyModeValue(int value) {
      concurrencyMode_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return The concurrencyMode.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.ConcurrencyMode getConcurrencyMode() {
      com.google.firestore.admin.v1.Database.ConcurrencyMode result =
          com.google.firestore.admin.v1.Database.ConcurrencyMode.forNumber(concurrencyMode_);
      return result == null
          ? com.google.firestore.admin.v1.Database.ConcurrencyMode.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @param value The concurrencyMode to set.
     * @return This builder for chaining.
     */
    public Builder setConcurrencyMode(
        com.google.firestore.admin.v1.Database.ConcurrencyMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      concurrencyMode_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConcurrencyMode() {
      bitField0_ = (bitField0_ & ~0x00000080);
      concurrencyMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration versionRetentionPeriod_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        versionRetentionPeriodBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the versionRetentionPeriod field is set.
     */
    public boolean hasVersionRetentionPeriod() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionRetentionPeriod.
     */
    public com.google.protobuf.Duration getVersionRetentionPeriod() {
      if (versionRetentionPeriodBuilder_ == null) {
        return versionRetentionPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : versionRetentionPeriod_;
      } else {
        return versionRetentionPeriodBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionRetentionPeriod(com.google.protobuf.Duration value) {
      if (versionRetentionPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionRetentionPeriod_ = value;
      } else {
        versionRetentionPeriodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionRetentionPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (versionRetentionPeriodBuilder_ == null) {
        versionRetentionPeriod_ = builderForValue.build();
      } else {
        versionRetentionPeriodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVersionRetentionPeriod(com.google.protobuf.Duration value) {
      if (versionRetentionPeriodBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && versionRetentionPeriod_ != null
            && versionRetentionPeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getVersionRetentionPeriodBuilder().mergeFrom(value);
        } else {
          versionRetentionPeriod_ = value;
        }
      } else {
        versionRetentionPeriodBuilder_.mergeFrom(value);
      }
      if (versionRetentionPeriod_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVersionRetentionPeriod() {
      bitField0_ = (bitField0_ & ~0x00000100);
      versionRetentionPeriod_ = null;
      if (versionRetentionPeriodBuilder_ != null) {
        versionRetentionPeriodBuilder_.dispose();
        versionRetentionPeriodBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getVersionRetentionPeriodBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return internalGetVersionRetentionPeriodFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getVersionRetentionPeriodOrBuilder() {
      if (versionRetentionPeriodBuilder_ != null) {
        return versionRetentionPeriodBuilder_.getMessageOrBuilder();
      } else {
        return versionRetentionPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : versionRetentionPeriod_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        internalGetVersionRetentionPeriodFieldBuilder() {
      if (versionRetentionPeriodBuilder_ == null) {
        versionRetentionPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getVersionRetentionPeriod(), getParentForChildren(), isClean());
        versionRetentionPeriod_ = null;
      }
      return versionRetentionPeriodBuilder_;
    }

    private com.google.protobuf.Timestamp earliestVersionTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        earliestVersionTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the earliestVersionTime field is set.
     */
    public boolean hasEarliestVersionTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The earliestVersionTime.
     */
    public com.google.protobuf.Timestamp getEarliestVersionTime() {
      if (earliestVersionTimeBuilder_ == null) {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      } else {
        return earliestVersionTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        earliestVersionTime_ = value;
      } else {
        earliestVersionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTime_ = builderForValue.build();
      } else {
        earliestVersionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && earliestVersionTime_ != null
            && earliestVersionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEarliestVersionTimeBuilder().mergeFrom(value);
        } else {
          earliestVersionTime_ = value;
        }
      } else {
        earliestVersionTimeBuilder_.mergeFrom(value);
      }
      if (earliestVersionTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEarliestVersionTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      earliestVersionTime_ = null;
      if (earliestVersionTimeBuilder_ != null) {
        earliestVersionTimeBuilder_.dispose();
        earliestVersionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEarliestVersionTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return internalGetEarliestVersionTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
      if (earliestVersionTimeBuilder_ != null) {
        return earliestVersionTimeBuilder_.getMessageOrBuilder();
      } else {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetEarliestVersionTimeFieldBuilder() {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEarliestVersionTime(), getParentForChildren(), isClean());
        earliestVersionTime_ = null;
      }
      return earliestVersionTimeBuilder_;
    }

    private int pointInTimeRecoveryEnablement_ = 0;

    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @return The enum numeric value on the wire for pointInTimeRecoveryEnablement.
     */
    @java.lang.Override
    public int getPointInTimeRecoveryEnablementValue() {
      return pointInTimeRecoveryEnablement_;
    }

    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @param value The enum numeric value on the wire for pointInTimeRecoveryEnablement to set.
     * @return This builder for chaining.
     */
    public Builder setPointInTimeRecoveryEnablementValue(int value) {
      pointInTimeRecoveryEnablement_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @return The pointInTimeRecoveryEnablement.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
        getPointInTimeRecoveryEnablement() {
      com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement result =
          com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.forNumber(
              pointInTimeRecoveryEnablement_);
      return result == null
          ? com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @param value The pointInTimeRecoveryEnablement to set.
     * @return This builder for chaining.
     */
    public Builder setPointInTimeRecoveryEnablement(
        com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      pointInTimeRecoveryEnablement_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPointInTimeRecoveryEnablement() {
      bitField0_ = (bitField0_ & ~0x00000400);
      pointInTimeRecoveryEnablement_ = 0;
      onChanged();
      return this;
    }

    private int appEngineIntegrationMode_ = 0;

    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @return The enum numeric value on the wire for appEngineIntegrationMode.
     */
    @java.lang.Override
    public int getAppEngineIntegrationModeValue() {
      return appEngineIntegrationMode_;
    }

    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @param value The enum numeric value on the wire for appEngineIntegrationMode to set.
     * @return This builder for chaining.
     */
    public Builder setAppEngineIntegrationModeValue(int value) {
      appEngineIntegrationMode_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @return The appEngineIntegrationMode.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
        getAppEngineIntegrationMode() {
      com.google.firestore.admin.v1.Database.AppEngineIntegrationMode result =
          com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.forNumber(
              appEngineIntegrationMode_);
      return result == null
          ? com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @param value The appEngineIntegrationMode to set.
     * @return This builder for chaining.
     */
    public Builder setAppEngineIntegrationMode(
        com.google.firestore.admin.v1.Database.AppEngineIntegrationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      appEngineIntegrationMode_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppEngineIntegrationMode() {
      bitField0_ = (bitField0_ & ~0x00000800);
      appEngineIntegrationMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object keyPrefix_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project ID ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application ID that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The keyPrefix.
     */
    public java.lang.String getKeyPrefix() {
      java.lang.Object ref = keyPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project ID ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application ID that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for keyPrefix.
     */
    public com.google.protobuf.ByteString getKeyPrefixBytes() {
      java.lang.Object ref = keyPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project ID ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application ID that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The keyPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setKeyPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyPrefix_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project ID ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application ID that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyPrefix() {
      keyPrefix_ = getDefaultInstance().getKeyPrefix();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project ID ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application ID that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for keyPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setKeyPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyPrefix_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private int deleteProtectionState_ = 0;

    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @return The enum numeric value on the wire for deleteProtectionState.
     */
    @java.lang.Override
    public int getDeleteProtectionStateValue() {
      return deleteProtectionState_;
    }

    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @param value The enum numeric value on the wire for deleteProtectionState to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteProtectionStateValue(int value) {
      deleteProtectionState_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @return The deleteProtectionState.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.DeleteProtectionState getDeleteProtectionState() {
      com.google.firestore.admin.v1.Database.DeleteProtectionState result =
          com.google.firestore.admin.v1.Database.DeleteProtectionState.forNumber(
              deleteProtectionState_);
      return result == null
          ? com.google.firestore.admin.v1.Database.DeleteProtectionState.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @param value The deleteProtectionState to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteProtectionState(
        com.google.firestore.admin.v1.Database.DeleteProtectionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      deleteProtectionState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleteProtectionState() {
      bitField0_ = (bitField0_ & ~0x00002000);
      deleteProtectionState_ = 0;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.Database.CmekConfig cmekConfig_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.Database.CmekConfig,
            com.google.firestore.admin.v1.Database.CmekConfig.Builder,
            com.google.firestore.admin.v1.Database.CmekConfigOrBuilder>
        cmekConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cmekConfig field is set.
     */
    public boolean hasCmekConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cmekConfig.
     */
    public com.google.firestore.admin.v1.Database.CmekConfig getCmekConfig() {
      if (cmekConfigBuilder_ == null) {
        return cmekConfig_ == null
            ? com.google.firestore.admin.v1.Database.CmekConfig.getDefaultInstance()
            : cmekConfig_;
      } else {
        return cmekConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCmekConfig(com.google.firestore.admin.v1.Database.CmekConfig value) {
      if (cmekConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cmekConfig_ = value;
      } else {
        cmekConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCmekConfig(
        com.google.firestore.admin.v1.Database.CmekConfig.Builder builderForValue) {
      if (cmekConfigBuilder_ == null) {
        cmekConfig_ = builderForValue.build();
      } else {
        cmekConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCmekConfig(com.google.firestore.admin.v1.Database.CmekConfig value) {
      if (cmekConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && cmekConfig_ != null
            && cmekConfig_
                != com.google.firestore.admin.v1.Database.CmekConfig.getDefaultInstance()) {
          getCmekConfigBuilder().mergeFrom(value);
        } else {
          cmekConfig_ = value;
        }
      } else {
        cmekConfigBuilder_.mergeFrom(value);
      }
      if (cmekConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCmekConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      cmekConfig_ = null;
      if (cmekConfigBuilder_ != null) {
        cmekConfigBuilder_.dispose();
        cmekConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.admin.v1.Database.CmekConfig.Builder getCmekConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return internalGetCmekConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.admin.v1.Database.CmekConfigOrBuilder getCmekConfigOrBuilder() {
      if (cmekConfigBuilder_ != null) {
        return cmekConfigBuilder_.getMessageOrBuilder();
      } else {
        return cmekConfig_ == null
            ? com.google.firestore.admin.v1.Database.CmekConfig.getDefaultInstance()
            : cmekConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Presence indicates CMEK is enabled for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.CmekConfig cmek_config = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.Database.CmekConfig,
            com.google.firestore.admin.v1.Database.CmekConfig.Builder,
            com.google.firestore.admin.v1.Database.CmekConfigOrBuilder>
        internalGetCmekConfigFieldBuilder() {
      if (cmekConfigBuilder_ == null) {
        cmekConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.admin.v1.Database.CmekConfig,
                com.google.firestore.admin.v1.Database.CmekConfig.Builder,
                com.google.firestore.admin.v1.Database.CmekConfigOrBuilder>(
                getCmekConfig(), getParentForChildren(), isClean());
        cmekConfig_ = null;
      }
      return cmekConfigBuilder_;
    }

    private java.lang.Object previousId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The database resource's prior database ID. This field is only
     * populated for deleted databases.
     * </pre>
     *
     * <code>string previous_id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The previousId.
     */
    public java.lang.String getPreviousId() {
      java.lang.Object ref = previousId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        previousId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The database resource's prior database ID. This field is only
     * populated for deleted databases.
     * </pre>
     *
     * <code>string previous_id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for previousId.
     */
    public com.google.protobuf.ByteString getPreviousIdBytes() {
      java.lang.Object ref = previousId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        previousId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The database resource's prior database ID. This field is only
     * populated for deleted databases.
     * </pre>
     *
     * <code>string previous_id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The previousId to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      previousId_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The database resource's prior database ID. This field is only
     * populated for deleted databases.
     * </pre>
     *
     * <code>string previous_id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreviousId() {
      previousId_ = getDefaultInstance().getPreviousId();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The database resource's prior database ID. This field is only
     * populated for deleted databases.
     * </pre>
     *
     * <code>string previous_id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for previousId to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      previousId_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.Database.SourceInfo sourceInfo_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.Database.SourceInfo,
            com.google.firestore.admin.v1.Database.SourceInfo.Builder,
            com.google.firestore.admin.v1.Database.SourceInfoOrBuilder>
        sourceInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sourceInfo field is set.
     */
    public boolean hasSourceInfo() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sourceInfo.
     */
    public com.google.firestore.admin.v1.Database.SourceInfo getSourceInfo() {
      if (sourceInfoBuilder_ == null) {
        return sourceInfo_ == null
            ? com.google.firestore.admin.v1.Database.SourceInfo.getDefaultInstance()
            : sourceInfo_;
      } else {
        return sourceInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceInfo(com.google.firestore.admin.v1.Database.SourceInfo value) {
      if (sourceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceInfo_ = value;
      } else {
        sourceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceInfo(
        com.google.firestore.admin.v1.Database.SourceInfo.Builder builderForValue) {
      if (sourceInfoBuilder_ == null) {
        sourceInfo_ = builderForValue.build();
      } else {
        sourceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSourceInfo(com.google.firestore.admin.v1.Database.SourceInfo value) {
      if (sourceInfoBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && sourceInfo_ != null
            && sourceInfo_
                != com.google.firestore.admin.v1.Database.SourceInfo.getDefaultInstance()) {
          getSourceInfoBuilder().mergeFrom(value);
        } else {
          sourceInfo_ = value;
        }
      } else {
        sourceInfoBuilder_.mergeFrom(value);
      }
      if (sourceInfo_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSourceInfo() {
      bitField0_ = (bitField0_ & ~0x00010000);
      sourceInfo_ = null;
      if (sourceInfoBuilder_ != null) {
        sourceInfoBuilder_.dispose();
        sourceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.firestore.admin.v1.Database.SourceInfo.Builder getSourceInfoBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return internalGetSourceInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.firestore.admin.v1.Database.SourceInfoOrBuilder getSourceInfoOrBuilder() {
      if (sourceInfoBuilder_ != null) {
        return sourceInfoBuilder_.getMessageOrBuilder();
      } else {
        return sourceInfo_ == null
            ? com.google.firestore.admin.v1.Database.SourceInfo.getDefaultInstance()
            : sourceInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Information about the provenance of this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.SourceInfo source_info = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.admin.v1.Database.SourceInfo,
            com.google.firestore.admin.v1.Database.SourceInfo.Builder,
            com.google.firestore.admin.v1.Database.SourceInfoOrBuilder>
        internalGetSourceInfoFieldBuilder() {
      if (sourceInfoBuilder_ == null) {
        sourceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.admin.v1.Database.SourceInfo,
                com.google.firestore.admin.v1.Database.SourceInfo.Builder,
                com.google.firestore.admin.v1.Database.SourceInfoOrBuilder>(
                getSourceInfo(), getParentForChildren(), isClean());
        sourceInfo_ = null;
      }
      return sourceInfoBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> tags_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetTags() {
      if (tags_ == null) {
        return com.google.protobuf.MapField.emptyMapField(TagsDefaultEntryHolder.defaultEntry);
      }
      return tags_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableTags() {
      if (tags_ == null) {
        tags_ = com.google.protobuf.MapField.newMapField(TagsDefaultEntryHolder.defaultEntry);
      }
      if (!tags_.isMutable()) {
        tags_ = tags_.copy();
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return tags_;
    }

    public int getTagsCount() {
      return internalGetTags().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTags().getMap().containsKey(key);
    }

    /** Use {@link #getTagsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getTags() {
      return getTagsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getTagsMap() {
      return internalGetTags().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getTagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getTagsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetTags().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTags() {
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableTags().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTags().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableTags() {
      bitField0_ |= 0x00020000;
      return internalGetMutableTags().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putTags(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTags().getMutableMap().put(key, value);
      bitField0_ |= 0x00020000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     * "123/environment": "production",
     * "123/costCenter": "marketing"
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; tags = 29 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllTags(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableTags().getMutableMap().putAll(values);
      bitField0_ |= 0x00020000;
      return this;
    }

    private boolean freeTier_;

    /**
     *
     *
     * <pre>
     * Output only. Background: Free tier is the ability of a Firestore database
     * to use a small amount of resources every day without being charged. Once
     * usage exceeds the free tier limit further usage is charged.
     *
     * Whether this database can make use of the free tier. Only one database
     * per project can be eligible for the free tier.
     *
     * The first (or next) database that is created in a project without a free
     * tier database will be marked as eligible for the free tier. Databases that
     * are created while there is a free tier database will not be eligible for
     * the free tier.
     * </pre>
     *
     * <code>optional bool free_tier = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the freeTier field is set.
     */
    @java.lang.Override
    public boolean hasFreeTier() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Background: Free tier is the ability of a Firestore database
     * to use a small amount of resources every day without being charged. Once
     * usage exceeds the free tier limit further usage is charged.
     *
     * Whether this database can make use of the free tier. Only one database
     * per project can be eligible for the free tier.
     *
     * The first (or next) database that is created in a project without a free
     * tier database will be marked as eligible for the free tier. Databases that
     * are created while there is a free tier database will not be eligible for
     * the free tier.
     * </pre>
     *
     * <code>optional bool free_tier = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The freeTier.
     */
    @java.lang.Override
    public boolean getFreeTier() {
      return freeTier_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Background: Free tier is the ability of a Firestore database
     * to use a small amount of resources every day without being charged. Once
     * usage exceeds the free tier limit further usage is charged.
     *
     * Whether this database can make use of the free tier. Only one database
     * per project can be eligible for the free tier.
     *
     * The first (or next) database that is created in a project without a free
     * tier database will be marked as eligible for the free tier. Databases that
     * are created while there is a free tier database will not be eligible for
     * the free tier.
     * </pre>
     *
     * <code>optional bool free_tier = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The freeTier to set.
     * @return This builder for chaining.
     */
    public Builder setFreeTier(boolean value) {

      freeTier_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Background: Free tier is the ability of a Firestore database
     * to use a small amount of resources every day without being charged. Once
     * usage exceeds the free tier limit further usage is charged.
     *
     * Whether this database can make use of the free tier. Only one database
     * per project can be eligible for the free tier.
     *
     * The first (or next) database that is created in a project without a free
     * tier database will be marked as eligible for the free tier. Databases that
     * are created while there is a free tier database will not be eligible for
     * the free tier.
     * </pre>
     *
     * <code>optional bool free_tier = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFreeTier() {
      bitField0_ = (bitField0_ & ~0x00040000);
      freeTier_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private int databaseEdition_ = 0;

    /**
     *
     *
     * <pre>
     * Immutable. The edition of the database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.DatabaseEdition database_edition = 28 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for databaseEdition.
     */
    @java.lang.Override
    public int getDatabaseEditionValue() {
      return databaseEdition_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The edition of the database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.DatabaseEdition database_edition = 28 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseEdition to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseEditionValue(int value) {
      databaseEdition_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The edition of the database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.DatabaseEdition database_edition = 28 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The databaseEdition.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.DatabaseEdition getDatabaseEdition() {
      com.google.firestore.admin.v1.Database.DatabaseEdition result =
          com.google.firestore.admin.v1.Database.DatabaseEdition.forNumber(databaseEdition_);
      return result == null
          ? com.google.firestore.admin.v1.Database.DatabaseEdition.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The edition of the database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.DatabaseEdition database_edition = 28 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The databaseEdition to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseEdition(
        com.google.firestore.admin.v1.Database.DatabaseEdition value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00100000;
      databaseEdition_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The edition of the database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.DatabaseEdition database_edition = 28 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseEdition() {
      bitField0_ = (bitField0_ & ~0x00100000);
      databaseEdition_ = 0;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database)
  private static final com.google.firestore.admin.v1.Database DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Database();
  }

  public static com.google.firestore.admin.v1.Database getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Database> PARSER =
      new com.google.protobuf.AbstractParser<Database>() {
        @java.lang.Override
        public Database parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Database> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Database> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.Database getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
