/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/admin/v1/index.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * Cloud Firestore indexes enable simple and complex queries against
 * documents in a database.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.Index}
 */
@com.google.protobuf.Generated
public final class Index extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Index)
    IndexOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "Index");
  }

  // Use Index.newBuilder() to construct.
  private Index(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private Index() {
    name_ = "";
    queryScope_ = 0;
    apiScope_ = 0;
    fields_ = java.util.Collections.emptyList();
    state_ = 0;
    density_ = 0;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.IndexProto
        .internal_static_google_firestore_admin_v1_Index_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.IndexProto
        .internal_static_google_firestore_admin_v1_Index_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.Index.class,
            com.google.firestore.admin.v1.Index.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Query Scope defines the scope at which a query is run. This is specified on
   * a StructuredQuery's `from` field.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Index.QueryScope}
   */
  public enum QueryScope implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The query scope is unspecified. Not a valid option.
     * </pre>
     *
     * <code>QUERY_SCOPE_UNSPECIFIED = 0;</code>
     */
    QUERY_SCOPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indexes with a collection query scope specified allow queries
     * against a collection that is the child of a specific document, specified
     * at query time, and that has the collection ID specified by the index.
     * </pre>
     *
     * <code>COLLECTION = 1;</code>
     */
    COLLECTION(1),
    /**
     *
     *
     * <pre>
     * Indexes with a collection group query scope specified allow queries
     * against all collections that has the collection ID specified by the
     * index.
     * </pre>
     *
     * <code>COLLECTION_GROUP = 2;</code>
     */
    COLLECTION_GROUP(2),
    /**
     *
     *
     * <pre>
     * Include all the collections's ancestor in the index. Only available for
     * Datastore Mode databases.
     * </pre>
     *
     * <code>COLLECTION_RECURSIVE = 3;</code>
     */
    COLLECTION_RECURSIVE(3),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "QueryScope");
    }

    /**
     *
     *
     * <pre>
     * The query scope is unspecified. Not a valid option.
     * </pre>
     *
     * <code>QUERY_SCOPE_UNSPECIFIED = 0;</code>
     */
    public static final int QUERY_SCOPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Indexes with a collection query scope specified allow queries
     * against a collection that is the child of a specific document, specified
     * at query time, and that has the collection ID specified by the index.
     * </pre>
     *
     * <code>COLLECTION = 1;</code>
     */
    public static final int COLLECTION_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Indexes with a collection group query scope specified allow queries
     * against all collections that has the collection ID specified by the
     * index.
     * </pre>
     *
     * <code>COLLECTION_GROUP = 2;</code>
     */
    public static final int COLLECTION_GROUP_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Include all the collections's ancestor in the index. Only available for
     * Datastore Mode databases.
     * </pre>
     *
     * <code>COLLECTION_RECURSIVE = 3;</code>
     */
    public static final int COLLECTION_RECURSIVE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryScope valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static QueryScope forNumber(int value) {
      switch (value) {
        case 0:
          return QUERY_SCOPE_UNSPECIFIED;
        case 1:
          return COLLECTION;
        case 2:
          return COLLECTION_GROUP;
        case 3:
          return COLLECTION_RECURSIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QueryScope> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<QueryScope> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<QueryScope>() {
          public QueryScope findValueByNumber(int number) {
            return QueryScope.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Index.getDescriptor().getEnumTypes().get(0);
    }

    private static final QueryScope[] VALUES = values();

    public static QueryScope valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private QueryScope(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Index.QueryScope)
  }

  /**
   *
   *
   * <pre>
   * API Scope defines the APIs (Firestore Native, or Firestore in
   * Datastore Mode) that are supported for queries.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Index.ApiScope}
   */
  public enum ApiScope implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The index can only be used by the Firestore Native query API.
     * This is the default.
     * </pre>
     *
     * <code>ANY_API = 0;</code>
     */
    ANY_API(0),
    /**
     *
     *
     * <pre>
     * The index can only be used by the Firestore in Datastore Mode query API.
     * </pre>
     *
     * <code>DATASTORE_MODE_API = 1;</code>
     */
    DATASTORE_MODE_API(1),
    /**
     *
     *
     * <pre>
     * The index can only be used by the MONGODB_COMPATIBLE_API.
     * </pre>
     *
     * <code>MONGODB_COMPATIBLE_API = 2;</code>
     */
    MONGODB_COMPATIBLE_API(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "ApiScope");
    }

    /**
     *
     *
     * <pre>
     * The index can only be used by the Firestore Native query API.
     * This is the default.
     * </pre>
     *
     * <code>ANY_API = 0;</code>
     */
    public static final int ANY_API_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The index can only be used by the Firestore in Datastore Mode query API.
     * </pre>
     *
     * <code>DATASTORE_MODE_API = 1;</code>
     */
    public static final int DATASTORE_MODE_API_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The index can only be used by the MONGODB_COMPATIBLE_API.
     * </pre>
     *
     * <code>MONGODB_COMPATIBLE_API = 2;</code>
     */
    public static final int MONGODB_COMPATIBLE_API_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ApiScope valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ApiScope forNumber(int value) {
      switch (value) {
        case 0:
          return ANY_API;
        case 1:
          return DATASTORE_MODE_API;
        case 2:
          return MONGODB_COMPATIBLE_API;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ApiScope> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ApiScope> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ApiScope>() {
          public ApiScope findValueByNumber(int number) {
            return ApiScope.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Index.getDescriptor().getEnumTypes().get(1);
    }

    private static final ApiScope[] VALUES = values();

    public static ApiScope valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ApiScope(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Index.ApiScope)
  }

  /**
   *
   *
   * <pre>
   * The state of an index. During index creation, an index will be in the
   * `CREATING` state. If the index is created successfully, it will transition
   * to the `READY` state. If the index creation encounters a problem, the index
   * will transition to the `NEEDS_REPAIR` state.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Index.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The index is being created.
     * There is an active long-running operation for the index.
     * The index is updated when writing a document.
     * Some index data may exist.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The index is ready to be used.
     * The index is updated when writing a document.
     * The index is fully populated from all stored documents it applies to.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * The index was being created, but something went wrong.
     * There is no active long-running operation for the index,
     * and the most recently finished long-running operation failed.
     * The index is not updated when writing a document.
     * Some index data may exist.
     * Use the google.longrunning.Operations API to determine why the operation
     * that last attempted to create this index failed, then re-create the
     * index.
     * </pre>
     *
     * <code>NEEDS_REPAIR = 3;</code>
     */
    NEEDS_REPAIR(3),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "State");
    }

    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The index is being created.
     * There is an active long-running operation for the index.
     * The index is updated when writing a document.
     * Some index data may exist.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The index is ready to be used.
     * The index is updated when writing a document.
     * The index is fully populated from all stored documents it applies to.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The index was being created, but something went wrong.
     * There is no active long-running operation for the index,
     * and the most recently finished long-running operation failed.
     * The index is not updated when writing a document.
     * Some index data may exist.
     * Use the google.longrunning.Operations API to determine why the operation
     * that last attempted to create this index failed, then re-create the
     * index.
     * </pre>
     *
     * <code>NEEDS_REPAIR = 3;</code>
     */
    public static final int NEEDS_REPAIR_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return NEEDS_REPAIR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Index.getDescriptor().getEnumTypes().get(2);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Index.State)
  }

  /**
   *
   *
   * <pre>
   * The density configuration for the index.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Index.Density}
   */
  public enum Density implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. It will use database default setting. This value is input
     * only.
     * </pre>
     *
     * <code>DENSITY_UNSPECIFIED = 0;</code>
     */
    DENSITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * In order for an index entry to be added, the document must
     * contain all fields specified in the index.
     *
     * This is the only allowed value for indexes having ApiScope `ANY_API` and
     * `DATASTORE_MODE_API`.
     * </pre>
     *
     * <code>SPARSE_ALL = 1;</code>
     */
    SPARSE_ALL(1),
    /**
     *
     *
     * <pre>
     * In order for an index entry to be added, the document must
     * contain at least one of the fields specified in the index.
     * Non-existent fields are treated as having a NULL value when generating
     * index entries.
     * </pre>
     *
     * <code>SPARSE_ANY = 2;</code>
     */
    SPARSE_ANY(2),
    /**
     *
     *
     * <pre>
     * An index entry will be added regardless of whether the
     * document contains any of the fields specified in the index.
     * Non-existent fields are treated as having a NULL value when generating
     * index entries.
     * </pre>
     *
     * <code>DENSE = 3;</code>
     */
    DENSE(3),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Density");
    }

    /**
     *
     *
     * <pre>
     * Unspecified. It will use database default setting. This value is input
     * only.
     * </pre>
     *
     * <code>DENSITY_UNSPECIFIED = 0;</code>
     */
    public static final int DENSITY_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * In order for an index entry to be added, the document must
     * contain all fields specified in the index.
     *
     * This is the only allowed value for indexes having ApiScope `ANY_API` and
     * `DATASTORE_MODE_API`.
     * </pre>
     *
     * <code>SPARSE_ALL = 1;</code>
     */
    public static final int SPARSE_ALL_VALUE = 1;

    /**
     *
     *
     * <pre>
     * In order for an index entry to be added, the document must
     * contain at least one of the fields specified in the index.
     * Non-existent fields are treated as having a NULL value when generating
     * index entries.
     * </pre>
     *
     * <code>SPARSE_ANY = 2;</code>
     */
    public static final int SPARSE_ANY_VALUE = 2;

    /**
     *
     *
     * <pre>
     * An index entry will be added regardless of whether the
     * document contains any of the fields specified in the index.
     * Non-existent fields are treated as having a NULL value when generating
     * index entries.
     * </pre>
     *
     * <code>DENSE = 3;</code>
     */
    public static final int DENSE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Density valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Density forNumber(int value) {
      switch (value) {
        case 0:
          return DENSITY_UNSPECIFIED;
        case 1:
          return SPARSE_ALL;
        case 2:
          return SPARSE_ANY;
        case 3:
          return DENSE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Density> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Density> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Density>() {
          public Density findValueByNumber(int number) {
            return Density.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Index.getDescriptor().getEnumTypes().get(3);
    }

    private static final Density[] VALUES = values();

    public static Density valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Density(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Index.Density)
  }

  public interface IndexFieldOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Index.IndexField)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Can be __name__.
     * For single field indexes, this must match the name of the field or may
     * be omitted.
     * </pre>
     *
     * <code>string field_path = 1;</code>
     *
     * @return The fieldPath.
     */
    java.lang.String getFieldPath();

    /**
     *
     *
     * <pre>
     * Can be __name__.
     * For single field indexes, this must match the name of the field or may
     * be omitted.
     * </pre>
     *
     * <code>string field_path = 1;</code>
     *
     * @return The bytes for fieldPath.
     */
    com.google.protobuf.ByteString getFieldPathBytes();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports ordering by the specified order or
     * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
     *
     * @return Whether the order field is set.
     */
    boolean hasOrder();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports ordering by the specified order or
     * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
     *
     * @return The enum numeric value on the wire for order.
     */
    int getOrderValue();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports ordering by the specified order or
     * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
     *
     * @return The order.
     */
    com.google.firestore.admin.v1.Index.IndexField.Order getOrder();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports operations on `array_value`s.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
     *
     * @return Whether the arrayConfig field is set.
     */
    boolean hasArrayConfig();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports operations on `array_value`s.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
     *
     * @return The enum numeric value on the wire for arrayConfig.
     */
    int getArrayConfigValue();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports operations on `array_value`s.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
     *
     * @return The arrayConfig.
     */
    com.google.firestore.admin.v1.Index.IndexField.ArrayConfig getArrayConfig();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports nearest neighbor and distance
     * operations on vector.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
     *
     * @return Whether the vectorConfig field is set.
     */
    boolean hasVectorConfig();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports nearest neighbor and distance
     * operations on vector.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
     *
     * @return The vectorConfig.
     */
    com.google.firestore.admin.v1.Index.IndexField.VectorConfig getVectorConfig();

    /**
     *
     *
     * <pre>
     * Indicates that this field supports nearest neighbor and distance
     * operations on vector.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
     */
    com.google.firestore.admin.v1.Index.IndexField.VectorConfigOrBuilder getVectorConfigOrBuilder();

    com.google.firestore.admin.v1.Index.IndexField.ValueModeCase getValueModeCase();
  }

  /**
   *
   *
   * <pre>
   * A field in an index.
   * The field_path describes which field is indexed, the value_mode describes
   * how the field value is indexed.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Index.IndexField}
   */
  public static final class IndexField extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Index.IndexField)
      IndexFieldOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "IndexField");
    }

    // Use IndexField.newBuilder() to construct.
    private IndexField(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private IndexField() {
      fieldPath_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.IndexProto
          .internal_static_google_firestore_admin_v1_Index_IndexField_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.IndexProto
          .internal_static_google_firestore_admin_v1_Index_IndexField_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Index.IndexField.class,
              com.google.firestore.admin.v1.Index.IndexField.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The supported orderings.
     * </pre>
     *
     * Protobuf enum {@code google.firestore.admin.v1.Index.IndexField.Order}
     */
    public enum Order implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The ordering is unspecified. Not a valid option.
       * </pre>
       *
       * <code>ORDER_UNSPECIFIED = 0;</code>
       */
      ORDER_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The field is ordered by ascending field value.
       * </pre>
       *
       * <code>ASCENDING = 1;</code>
       */
      ASCENDING(1),
      /**
       *
       *
       * <pre>
       * The field is ordered by descending field value.
       * </pre>
       *
       * <code>DESCENDING = 2;</code>
       */
      DESCENDING(2),
      UNRECOGNIZED(-1),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "Order");
      }

      /**
       *
       *
       * <pre>
       * The ordering is unspecified. Not a valid option.
       * </pre>
       *
       * <code>ORDER_UNSPECIFIED = 0;</code>
       */
      public static final int ORDER_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The field is ordered by ascending field value.
       * </pre>
       *
       * <code>ASCENDING = 1;</code>
       */
      public static final int ASCENDING_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The field is ordered by descending field value.
       * </pre>
       *
       * <code>DESCENDING = 2;</code>
       */
      public static final int DESCENDING_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Order valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Order forNumber(int value) {
        switch (value) {
          case 0:
            return ORDER_UNSPECIFIED;
          case 1:
            return ASCENDING;
          case 2:
            return DESCENDING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Order> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Order> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Order>() {
            public Order findValueByNumber(int number) {
              return Order.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.firestore.admin.v1.Index.IndexField.getDescriptor().getEnumTypes().get(0);
      }

      private static final Order[] VALUES = values();

      public static Order valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Order(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Index.IndexField.Order)
    }

    /**
     *
     *
     * <pre>
     * The supported array value configurations.
     * </pre>
     *
     * Protobuf enum {@code google.firestore.admin.v1.Index.IndexField.ArrayConfig}
     */
    public enum ArrayConfig implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The index does not support additional array queries.
       * </pre>
       *
       * <code>ARRAY_CONFIG_UNSPECIFIED = 0;</code>
       */
      ARRAY_CONFIG_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The index supports array containment queries.
       * </pre>
       *
       * <code>CONTAINS = 1;</code>
       */
      CONTAINS(1),
      UNRECOGNIZED(-1),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "ArrayConfig");
      }

      /**
       *
       *
       * <pre>
       * The index does not support additional array queries.
       * </pre>
       *
       * <code>ARRAY_CONFIG_UNSPECIFIED = 0;</code>
       */
      public static final int ARRAY_CONFIG_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The index supports array containment queries.
       * </pre>
       *
       * <code>CONTAINS = 1;</code>
       */
      public static final int CONTAINS_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ArrayConfig valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ArrayConfig forNumber(int value) {
        switch (value) {
          case 0:
            return ARRAY_CONFIG_UNSPECIFIED;
          case 1:
            return CONTAINS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ArrayConfig> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ArrayConfig> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ArrayConfig>() {
            public ArrayConfig findValueByNumber(int number) {
              return ArrayConfig.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.firestore.admin.v1.Index.IndexField.getDescriptor().getEnumTypes().get(1);
      }

      private static final ArrayConfig[] VALUES = values();

      public static ArrayConfig valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ArrayConfig(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Index.IndexField.ArrayConfig)
    }

    public interface VectorConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Index.IndexField.VectorConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The vector dimension this configuration applies to.
       *
       * The resulting index will only include vectors of this dimension, and
       * can be used for vector search with the same dimension.
       * </pre>
       *
       * <code>int32 dimension = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The dimension.
       */
      int getDimension();

      /**
       *
       *
       * <pre>
       * Indicates the vector index is a flat index.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
       *
       * @return Whether the flat field is set.
       */
      boolean hasFlat();

      /**
       *
       *
       * <pre>
       * Indicates the vector index is a flat index.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
       *
       * @return The flat.
       */
      com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex getFlat();

      /**
       *
       *
       * <pre>
       * Indicates the vector index is a flat index.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
       */
      com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndexOrBuilder
          getFlatOrBuilder();

      com.google.firestore.admin.v1.Index.IndexField.VectorConfig.TypeCase getTypeCase();
    }

    /**
     *
     *
     * <pre>
     * The index configuration to support vector search operations
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.Index.IndexField.VectorConfig}
     */
    public static final class VectorConfig extends com.google.protobuf.GeneratedMessage
        implements
        // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Index.IndexField.VectorConfig)
        VectorConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "VectorConfig");
      }

      // Use VectorConfig.newBuilder() to construct.
      private VectorConfig(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }

      private VectorConfig() {}

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.IndexProto
            .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.IndexProto
            .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.class,
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.Builder.class);
      }

      public interface FlatIndexOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex)
          com.google.protobuf.MessageOrBuilder {}

      /**
       *
       *
       * <pre>
       * An index that stores vectors in a flat data structure, and supports
       * exhaustive search.
       * </pre>
       *
       * Protobuf type {@code google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex}
       */
      public static final class FlatIndex extends com.google.protobuf.GeneratedMessage
          implements
          // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex)
          FlatIndexOrBuilder {
        private static final long serialVersionUID = 0L;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
              com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
              /* major= */ 4,
              /* minor= */ 33,
              /* patch= */ 2,
              /* suffix= */ "",
              "FlatIndex");
        }

        // Use FlatIndex.newBuilder() to construct.
        private FlatIndex(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
          super(builder);
        }

        private FlatIndex() {}

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.firestore.admin.v1.IndexProto
              .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_FlatIndex_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.firestore.admin.v1.IndexProto
              .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_FlatIndex_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.class,
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.Builder
                      .class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex)) {
            return super.equals(obj);
          }
          com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex other =
              (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessage.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * An index that stores vectors in a flat data structure, and supports
         * exhaustive search.
         * </pre>
         *
         * Protobuf type {@code google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessage.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex)
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndexOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.firestore.admin.v1.IndexProto
                .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_FlatIndex_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.firestore.admin.v1.IndexProto
                .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_FlatIndex_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.class,
                    com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.Builder
                        .class);
          }

          // Construct using
          // com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.firestore.admin.v1.IndexProto
                .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_FlatIndex_descriptor;
          }

          @java.lang.Override
          public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
              getDefaultInstanceForType() {
            return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex build() {
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
              buildPartial() {
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex result =
                new com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) {
              return mergeFrom(
                  (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex other) {
            if (other
                == com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
                    .getDefaultInstance()) return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex)
        }

        // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex)
        private static final com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex();
        }

        public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<FlatIndex> PARSER =
            new com.google.protobuf.AbstractParser<FlatIndex>() {
              @java.lang.Override
              public FlatIndex parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<FlatIndex> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<FlatIndex> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int typeCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object type_;

      public enum TypeCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        FLAT(2),
        TYPE_NOT_SET(0);
        private final int value;

        private TypeCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static TypeCase valueOf(int value) {
          return forNumber(value);
        }

        public static TypeCase forNumber(int value) {
          switch (value) {
            case 2:
              return FLAT;
            case 0:
              return TYPE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public static final int DIMENSION_FIELD_NUMBER = 1;
      private int dimension_ = 0;

      /**
       *
       *
       * <pre>
       * Required. The vector dimension this configuration applies to.
       *
       * The resulting index will only include vectors of this dimension, and
       * can be used for vector search with the same dimension.
       * </pre>
       *
       * <code>int32 dimension = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The dimension.
       */
      @java.lang.Override
      public int getDimension() {
        return dimension_;
      }

      public static final int FLAT_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Indicates the vector index is a flat index.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
       *
       * @return Whether the flat field is set.
       */
      @java.lang.Override
      public boolean hasFlat() {
        return typeCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Indicates the vector index is a flat index.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
       *
       * @return The flat.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex getFlat() {
        if (typeCase_ == 2) {
          return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) type_;
        }
        return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            .getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Indicates the vector index is a flat index.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndexOrBuilder
          getFlatOrBuilder() {
        if (typeCase_ == 2) {
          return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) type_;
        }
        return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
            .getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (dimension_ != 0) {
          output.writeInt32(1, dimension_);
        }
        if (typeCase_ == 2) {
          output.writeMessage(
              2, (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) type_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (dimension_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, dimension_);
        }
        if (typeCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) type_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.firestore.admin.v1.Index.IndexField.VectorConfig)) {
          return super.equals(obj);
        }
        com.google.firestore.admin.v1.Index.IndexField.VectorConfig other =
            (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) obj;

        if (getDimension() != other.getDimension()) return false;
        if (!getTypeCase().equals(other.getTypeCase())) return false;
        switch (typeCase_) {
          case 2:
            if (!getFlat().equals(other.getFlat())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DIMENSION_FIELD_NUMBER;
        hash = (53 * hash) + getDimension();
        switch (typeCase_) {
          case 2:
            hash = (37 * hash) + FLAT_FIELD_NUMBER;
            hash = (53 * hash) + getFlat().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.firestore.admin.v1.Index.IndexField.VectorConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The index configuration to support vector search operations
       * </pre>
       *
       * Protobuf type {@code google.firestore.admin.v1.Index.IndexField.VectorConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessage.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Index.IndexField.VectorConfig)
          com.google.firestore.admin.v1.Index.IndexField.VectorConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.firestore.admin.v1.IndexProto
              .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.firestore.admin.v1.IndexProto
              .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig.class,
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig.Builder.class);
        }

        // Construct using com.google.firestore.admin.v1.Index.IndexField.VectorConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          dimension_ = 0;
          if (flatBuilder_ != null) {
            flatBuilder_.clear();
          }
          typeCase_ = 0;
          type_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.firestore.admin.v1.IndexProto
              .internal_static_google_firestore_admin_v1_Index_IndexField_VectorConfig_descriptor;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Index.IndexField.VectorConfig
            getDefaultInstanceForType() {
          return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Index.IndexField.VectorConfig build() {
          com.google.firestore.admin.v1.Index.IndexField.VectorConfig result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.firestore.admin.v1.Index.IndexField.VectorConfig buildPartial() {
          com.google.firestore.admin.v1.Index.IndexField.VectorConfig result =
              new com.google.firestore.admin.v1.Index.IndexField.VectorConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.dimension_ = dimension_;
          }
        }

        private void buildPartialOneofs(
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig result) {
          result.typeCase_ = typeCase_;
          result.type_ = this.type_;
          if (typeCase_ == 2 && flatBuilder_ != null) {
            result.type_ = flatBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.firestore.admin.v1.Index.IndexField.VectorConfig) {
            return mergeFrom((com.google.firestore.admin.v1.Index.IndexField.VectorConfig) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig other) {
          if (other
              == com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance())
            return this;
          if (other.getDimension() != 0) {
            setDimension(other.getDimension());
          }
          switch (other.getTypeCase()) {
            case FLAT:
              {
                mergeFlat(other.getFlat());
                break;
              }
            case TYPE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    dimension_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    input.readMessage(
                        internalGetFlatFieldBuilder().getBuilder(), extensionRegistry);
                    typeCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int typeCase_ = 0;
        private java.lang.Object type_;

        public TypeCase getTypeCase() {
          return TypeCase.forNumber(typeCase_);
        }

        public Builder clearType() {
          typeCase_ = 0;
          type_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private int dimension_;

        /**
         *
         *
         * <pre>
         * Required. The vector dimension this configuration applies to.
         *
         * The resulting index will only include vectors of this dimension, and
         * can be used for vector search with the same dimension.
         * </pre>
         *
         * <code>int32 dimension = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The dimension.
         */
        @java.lang.Override
        public int getDimension() {
          return dimension_;
        }

        /**
         *
         *
         * <pre>
         * Required. The vector dimension this configuration applies to.
         *
         * The resulting index will only include vectors of this dimension, and
         * can be used for vector search with the same dimension.
         * </pre>
         *
         * <code>int32 dimension = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The dimension to set.
         * @return This builder for chaining.
         */
        public Builder setDimension(int value) {

          dimension_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The vector dimension this configuration applies to.
         *
         * The resulting index will only include vectors of this dimension, and
         * can be used for vector search with the same dimension.
         * </pre>
         *
         * <code>int32 dimension = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDimension() {
          bitField0_ = (bitField0_ & ~0x00000001);
          dimension_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex,
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.Builder,
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndexOrBuilder>
            flatBuilder_;

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         *
         * @return Whether the flat field is set.
         */
        @java.lang.Override
        public boolean hasFlat() {
          return typeCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         *
         * @return The flat.
         */
        @java.lang.Override
        public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex getFlat() {
          if (flatBuilder_ == null) {
            if (typeCase_ == 2) {
              return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) type_;
            }
            return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
                .getDefaultInstance();
          } else {
            if (typeCase_ == 2) {
              return flatBuilder_.getMessage();
            }
            return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         */
        public Builder setFlat(
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex value) {
          if (flatBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
            onChanged();
          } else {
            flatBuilder_.setMessage(value);
          }
          typeCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         */
        public Builder setFlat(
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.Builder
                builderForValue) {
          if (flatBuilder_ == null) {
            type_ = builderForValue.build();
            onChanged();
          } else {
            flatBuilder_.setMessage(builderForValue.build());
          }
          typeCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         */
        public Builder mergeFlat(
            com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex value) {
          if (flatBuilder_ == null) {
            if (typeCase_ == 2
                && type_
                    != com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
                        .getDefaultInstance()) {
              type_ =
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.newBuilder(
                          (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex)
                              type_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              type_ = value;
            }
            onChanged();
          } else {
            if (typeCase_ == 2) {
              flatBuilder_.mergeFrom(value);
            } else {
              flatBuilder_.setMessage(value);
            }
          }
          typeCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         */
        public Builder clearFlat() {
          if (flatBuilder_ == null) {
            if (typeCase_ == 2) {
              typeCase_ = 0;
              type_ = null;
              onChanged();
            }
          } else {
            if (typeCase_ == 2) {
              typeCase_ = 0;
              type_ = null;
            }
            flatBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         */
        public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.Builder
            getFlatBuilder() {
          return internalGetFlatFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         */
        @java.lang.Override
        public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndexOrBuilder
            getFlatOrBuilder() {
          if ((typeCase_ == 2) && (flatBuilder_ != null)) {
            return flatBuilder_.getMessageOrBuilder();
          } else {
            if (typeCase_ == 2) {
              return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) type_;
            }
            return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Indicates the vector index is a flat index.
         * </pre>
         *
         * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex flat = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex,
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.Builder,
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndexOrBuilder>
            internalGetFlatFieldBuilder() {
          if (flatBuilder_ == null) {
            if (!(typeCase_ == 2)) {
              type_ =
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex
                      .getDefaultInstance();
            }
            flatBuilder_ =
                new com.google.protobuf.SingleFieldBuilder<
                    com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex,
                    com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex.Builder,
                    com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndexOrBuilder>(
                    (com.google.firestore.admin.v1.Index.IndexField.VectorConfig.FlatIndex) type_,
                    getParentForChildren(),
                    isClean());
            type_ = null;
          }
          typeCase_ = 2;
          onChanged();
          return flatBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Index.IndexField.VectorConfig)
      }

      // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Index.IndexField.VectorConfig)
      private static final com.google.firestore.admin.v1.Index.IndexField.VectorConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Index.IndexField.VectorConfig();
      }

      public static com.google.firestore.admin.v1.Index.IndexField.VectorConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<VectorConfig> PARSER =
          new com.google.protobuf.AbstractParser<VectorConfig>() {
            @java.lang.Override
            public VectorConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<VectorConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<VectorConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField.VectorConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int valueModeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object valueMode_;

    public enum ValueModeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ORDER(2),
      ARRAY_CONFIG(3),
      VECTOR_CONFIG(4),
      VALUEMODE_NOT_SET(0);
      private final int value;

      private ValueModeCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueModeCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueModeCase forNumber(int value) {
        switch (value) {
          case 2:
            return ORDER;
          case 3:
            return ARRAY_CONFIG;
          case 4:
            return VECTOR_CONFIG;
          case 0:
            return VALUEMODE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueModeCase getValueModeCase() {
      return ValueModeCase.forNumber(valueModeCase_);
    }

    public static final int FIELD_PATH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fieldPath_ = "";

    /**
     *
     *
     * <pre>
     * Can be __name__.
     * For single field indexes, this must match the name of the field or may
     * be omitted.
     * </pre>
     *
     * <code>string field_path = 1;</code>
     *
     * @return The fieldPath.
     */
    @java.lang.Override
    public java.lang.String getFieldPath() {
      java.lang.Object ref = fieldPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldPath_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Can be __name__.
     * For single field indexes, this must match the name of the field or may
     * be omitted.
     * </pre>
     *
     * <code>string field_path = 1;</code>
     *
     * @return The bytes for fieldPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFieldPathBytes() {
      java.lang.Object ref = fieldPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ORDER_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Indicates that this field supports ordering by the specified order or
     * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
     *
     * @return Whether the order field is set.
     */
    public boolean hasOrder() {
      return valueModeCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Indicates that this field supports ordering by the specified order or
     * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
     *
     * @return The enum numeric value on the wire for order.
     */
    public int getOrderValue() {
      if (valueModeCase_ == 2) {
        return (java.lang.Integer) valueMode_;
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Indicates that this field supports ordering by the specified order or
     * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
     *
     * @return The order.
     */
    public com.google.firestore.admin.v1.Index.IndexField.Order getOrder() {
      if (valueModeCase_ == 2) {
        com.google.firestore.admin.v1.Index.IndexField.Order result =
            com.google.firestore.admin.v1.Index.IndexField.Order.forNumber(
                (java.lang.Integer) valueMode_);
        return result == null
            ? com.google.firestore.admin.v1.Index.IndexField.Order.UNRECOGNIZED
            : result;
      }
      return com.google.firestore.admin.v1.Index.IndexField.Order.ORDER_UNSPECIFIED;
    }

    public static final int ARRAY_CONFIG_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Indicates that this field supports operations on `array_value`s.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
     *
     * @return Whether the arrayConfig field is set.
     */
    public boolean hasArrayConfig() {
      return valueModeCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Indicates that this field supports operations on `array_value`s.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
     *
     * @return The enum numeric value on the wire for arrayConfig.
     */
    public int getArrayConfigValue() {
      if (valueModeCase_ == 3) {
        return (java.lang.Integer) valueMode_;
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Indicates that this field supports operations on `array_value`s.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
     *
     * @return The arrayConfig.
     */
    public com.google.firestore.admin.v1.Index.IndexField.ArrayConfig getArrayConfig() {
      if (valueModeCase_ == 3) {
        com.google.firestore.admin.v1.Index.IndexField.ArrayConfig result =
            com.google.firestore.admin.v1.Index.IndexField.ArrayConfig.forNumber(
                (java.lang.Integer) valueMode_);
        return result == null
            ? com.google.firestore.admin.v1.Index.IndexField.ArrayConfig.UNRECOGNIZED
            : result;
      }
      return com.google.firestore.admin.v1.Index.IndexField.ArrayConfig.ARRAY_CONFIG_UNSPECIFIED;
    }

    public static final int VECTOR_CONFIG_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Indicates that this field supports nearest neighbor and distance
     * operations on vector.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
     *
     * @return Whether the vectorConfig field is set.
     */
    @java.lang.Override
    public boolean hasVectorConfig() {
      return valueModeCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Indicates that this field supports nearest neighbor and distance
     * operations on vector.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
     *
     * @return The vectorConfig.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Index.IndexField.VectorConfig getVectorConfig() {
      if (valueModeCase_ == 4) {
        return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_;
      }
      return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Indicates that this field supports nearest neighbor and distance
     * operations on vector.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Index.IndexField.VectorConfigOrBuilder
        getVectorConfigOrBuilder() {
      if (valueModeCase_ == 4) {
        return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_;
      }
      return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(fieldPath_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, fieldPath_);
      }
      if (valueModeCase_ == 2) {
        output.writeEnum(2, ((java.lang.Integer) valueMode_));
      }
      if (valueModeCase_ == 3) {
        output.writeEnum(3, ((java.lang.Integer) valueMode_));
      }
      if (valueModeCase_ == 4) {
        output.writeMessage(
            4, (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(fieldPath_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, fieldPath_);
      }
      if (valueModeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(
                2, ((java.lang.Integer) valueMode_));
      }
      if (valueModeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(
                3, ((java.lang.Integer) valueMode_));
      }
      if (valueModeCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.admin.v1.Index.IndexField)) {
        return super.equals(obj);
      }
      com.google.firestore.admin.v1.Index.IndexField other =
          (com.google.firestore.admin.v1.Index.IndexField) obj;

      if (!getFieldPath().equals(other.getFieldPath())) return false;
      if (!getValueModeCase().equals(other.getValueModeCase())) return false;
      switch (valueModeCase_) {
        case 2:
          if (getOrderValue() != other.getOrderValue()) return false;
          break;
        case 3:
          if (getArrayConfigValue() != other.getArrayConfigValue()) return false;
          break;
        case 4:
          if (!getVectorConfig().equals(other.getVectorConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIELD_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getFieldPath().hashCode();
      switch (valueModeCase_) {
        case 2:
          hash = (37 * hash) + ORDER_FIELD_NUMBER;
          hash = (53 * hash) + getOrderValue();
          break;
        case 3:
          hash = (37 * hash) + ARRAY_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getArrayConfigValue();
          break;
        case 4:
          hash = (37 * hash) + VECTOR_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getVectorConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Index.IndexField parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.admin.v1.Index.IndexField prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A field in an index.
     * The field_path describes which field is indexed, the value_mode describes
     * how the field value is indexed.
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.Index.IndexField}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Index.IndexField)
        com.google.firestore.admin.v1.Index.IndexFieldOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.IndexProto
            .internal_static_google_firestore_admin_v1_Index_IndexField_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.IndexProto
            .internal_static_google_firestore_admin_v1_Index_IndexField_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Index.IndexField.class,
                com.google.firestore.admin.v1.Index.IndexField.Builder.class);
      }

      // Construct using com.google.firestore.admin.v1.Index.IndexField.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        fieldPath_ = "";
        if (vectorConfigBuilder_ != null) {
          vectorConfigBuilder_.clear();
        }
        valueModeCase_ = 0;
        valueMode_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.admin.v1.IndexProto
            .internal_static_google_firestore_admin_v1_Index_IndexField_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField getDefaultInstanceForType() {
        return com.google.firestore.admin.v1.Index.IndexField.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField build() {
        com.google.firestore.admin.v1.Index.IndexField result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField buildPartial() {
        com.google.firestore.admin.v1.Index.IndexField result =
            new com.google.firestore.admin.v1.Index.IndexField(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.firestore.admin.v1.Index.IndexField result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.fieldPath_ = fieldPath_;
        }
      }

      private void buildPartialOneofs(com.google.firestore.admin.v1.Index.IndexField result) {
        result.valueModeCase_ = valueModeCase_;
        result.valueMode_ = this.valueMode_;
        if (valueModeCase_ == 4 && vectorConfigBuilder_ != null) {
          result.valueMode_ = vectorConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.admin.v1.Index.IndexField) {
          return mergeFrom((com.google.firestore.admin.v1.Index.IndexField) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.admin.v1.Index.IndexField other) {
        if (other == com.google.firestore.admin.v1.Index.IndexField.getDefaultInstance())
          return this;
        if (!other.getFieldPath().isEmpty()) {
          fieldPath_ = other.fieldPath_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        switch (other.getValueModeCase()) {
          case ORDER:
            {
              setOrderValue(other.getOrderValue());
              break;
            }
          case ARRAY_CONFIG:
            {
              setArrayConfigValue(other.getArrayConfigValue());
              break;
            }
          case VECTOR_CONFIG:
            {
              mergeVectorConfig(other.getVectorConfig());
              break;
            }
          case VALUEMODE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  fieldPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  int rawValue = input.readEnum();
                  valueModeCase_ = 2;
                  valueMode_ = rawValue;
                  break;
                } // case 16
              case 24:
                {
                  int rawValue = input.readEnum();
                  valueModeCase_ = 3;
                  valueMode_ = rawValue;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(
                      internalGetVectorConfigFieldBuilder().getBuilder(), extensionRegistry);
                  valueModeCase_ = 4;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueModeCase_ = 0;
      private java.lang.Object valueMode_;

      public ValueModeCase getValueModeCase() {
        return ValueModeCase.forNumber(valueModeCase_);
      }

      public Builder clearValueMode() {
        valueModeCase_ = 0;
        valueMode_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object fieldPath_ = "";

      /**
       *
       *
       * <pre>
       * Can be __name__.
       * For single field indexes, this must match the name of the field or may
       * be omitted.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @return The fieldPath.
       */
      public java.lang.String getFieldPath() {
        java.lang.Object ref = fieldPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Can be __name__.
       * For single field indexes, this must match the name of the field or may
       * be omitted.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @return The bytes for fieldPath.
       */
      public com.google.protobuf.ByteString getFieldPathBytes() {
        java.lang.Object ref = fieldPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Can be __name__.
       * For single field indexes, this must match the name of the field or may
       * be omitted.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @param value The fieldPath to set.
       * @return This builder for chaining.
       */
      public Builder setFieldPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fieldPath_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Can be __name__.
       * For single field indexes, this must match the name of the field or may
       * be omitted.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFieldPath() {
        fieldPath_ = getDefaultInstance().getFieldPath();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Can be __name__.
       * For single field indexes, this must match the name of the field or may
       * be omitted.
       * </pre>
       *
       * <code>string field_path = 1;</code>
       *
       * @param value The bytes for fieldPath to set.
       * @return This builder for chaining.
       */
      public Builder setFieldPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fieldPath_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports ordering by the specified order or
       * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
       *
       * @return Whether the order field is set.
       */
      @java.lang.Override
      public boolean hasOrder() {
        return valueModeCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports ordering by the specified order or
       * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
       *
       * @return The enum numeric value on the wire for order.
       */
      @java.lang.Override
      public int getOrderValue() {
        if (valueModeCase_ == 2) {
          return ((java.lang.Integer) valueMode_).intValue();
        }
        return 0;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports ordering by the specified order or
       * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
       *
       * @param value The enum numeric value on the wire for order to set.
       * @return This builder for chaining.
       */
      public Builder setOrderValue(int value) {
        valueModeCase_ = 2;
        valueMode_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports ordering by the specified order or
       * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
       *
       * @return The order.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField.Order getOrder() {
        if (valueModeCase_ == 2) {
          com.google.firestore.admin.v1.Index.IndexField.Order result =
              com.google.firestore.admin.v1.Index.IndexField.Order.forNumber(
                  (java.lang.Integer) valueMode_);
          return result == null
              ? com.google.firestore.admin.v1.Index.IndexField.Order.UNRECOGNIZED
              : result;
        }
        return com.google.firestore.admin.v1.Index.IndexField.Order.ORDER_UNSPECIFIED;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports ordering by the specified order or
       * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
       *
       * @param value The order to set.
       * @return This builder for chaining.
       */
      public Builder setOrder(com.google.firestore.admin.v1.Index.IndexField.Order value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueModeCase_ = 2;
        valueMode_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports ordering by the specified order or
       * comparing using =, !=, &lt;, &lt;=, &gt;, &gt;=.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.Order order = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOrder() {
        if (valueModeCase_ == 2) {
          valueModeCase_ = 0;
          valueMode_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports operations on `array_value`s.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
       *
       * @return Whether the arrayConfig field is set.
       */
      @java.lang.Override
      public boolean hasArrayConfig() {
        return valueModeCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports operations on `array_value`s.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
       *
       * @return The enum numeric value on the wire for arrayConfig.
       */
      @java.lang.Override
      public int getArrayConfigValue() {
        if (valueModeCase_ == 3) {
          return ((java.lang.Integer) valueMode_).intValue();
        }
        return 0;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports operations on `array_value`s.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
       *
       * @param value The enum numeric value on the wire for arrayConfig to set.
       * @return This builder for chaining.
       */
      public Builder setArrayConfigValue(int value) {
        valueModeCase_ = 3;
        valueMode_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports operations on `array_value`s.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
       *
       * @return The arrayConfig.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField.ArrayConfig getArrayConfig() {
        if (valueModeCase_ == 3) {
          com.google.firestore.admin.v1.Index.IndexField.ArrayConfig result =
              com.google.firestore.admin.v1.Index.IndexField.ArrayConfig.forNumber(
                  (java.lang.Integer) valueMode_);
          return result == null
              ? com.google.firestore.admin.v1.Index.IndexField.ArrayConfig.UNRECOGNIZED
              : result;
        }
        return com.google.firestore.admin.v1.Index.IndexField.ArrayConfig.ARRAY_CONFIG_UNSPECIFIED;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports operations on `array_value`s.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
       *
       * @param value The arrayConfig to set.
       * @return This builder for chaining.
       */
      public Builder setArrayConfig(
          com.google.firestore.admin.v1.Index.IndexField.ArrayConfig value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueModeCase_ = 3;
        valueMode_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports operations on `array_value`s.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.ArrayConfig array_config = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearArrayConfig() {
        if (valueModeCase_ == 3) {
          valueModeCase_ = 0;
          valueMode_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Index.IndexField.VectorConfig,
              com.google.firestore.admin.v1.Index.IndexField.VectorConfig.Builder,
              com.google.firestore.admin.v1.Index.IndexField.VectorConfigOrBuilder>
          vectorConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       *
       * @return Whether the vectorConfig field is set.
       */
      @java.lang.Override
      public boolean hasVectorConfig() {
        return valueModeCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       *
       * @return The vectorConfig.
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField.VectorConfig getVectorConfig() {
        if (vectorConfigBuilder_ == null) {
          if (valueModeCase_ == 4) {
            return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_;
          }
          return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance();
        } else {
          if (valueModeCase_ == 4) {
            return vectorConfigBuilder_.getMessage();
          }
          return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       */
      public Builder setVectorConfig(
          com.google.firestore.admin.v1.Index.IndexField.VectorConfig value) {
        if (vectorConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          valueMode_ = value;
          onChanged();
        } else {
          vectorConfigBuilder_.setMessage(value);
        }
        valueModeCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       */
      public Builder setVectorConfig(
          com.google.firestore.admin.v1.Index.IndexField.VectorConfig.Builder builderForValue) {
        if (vectorConfigBuilder_ == null) {
          valueMode_ = builderForValue.build();
          onChanged();
        } else {
          vectorConfigBuilder_.setMessage(builderForValue.build());
        }
        valueModeCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       */
      public Builder mergeVectorConfig(
          com.google.firestore.admin.v1.Index.IndexField.VectorConfig value) {
        if (vectorConfigBuilder_ == null) {
          if (valueModeCase_ == 4
              && valueMode_
                  != com.google.firestore.admin.v1.Index.IndexField.VectorConfig
                      .getDefaultInstance()) {
            valueMode_ =
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.newBuilder(
                        (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            valueMode_ = value;
          }
          onChanged();
        } else {
          if (valueModeCase_ == 4) {
            vectorConfigBuilder_.mergeFrom(value);
          } else {
            vectorConfigBuilder_.setMessage(value);
          }
        }
        valueModeCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       */
      public Builder clearVectorConfig() {
        if (vectorConfigBuilder_ == null) {
          if (valueModeCase_ == 4) {
            valueModeCase_ = 0;
            valueMode_ = null;
            onChanged();
          }
        } else {
          if (valueModeCase_ == 4) {
            valueModeCase_ = 0;
            valueMode_ = null;
          }
          vectorConfigBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       */
      public com.google.firestore.admin.v1.Index.IndexField.VectorConfig.Builder
          getVectorConfigBuilder() {
        return internalGetVectorConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       */
      @java.lang.Override
      public com.google.firestore.admin.v1.Index.IndexField.VectorConfigOrBuilder
          getVectorConfigOrBuilder() {
        if ((valueModeCase_ == 4) && (vectorConfigBuilder_ != null)) {
          return vectorConfigBuilder_.getMessageOrBuilder();
        } else {
          if (valueModeCase_ == 4) {
            return (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_;
          }
          return com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates that this field supports nearest neighbor and distance
       * operations on vector.
       * </pre>
       *
       * <code>.google.firestore.admin.v1.Index.IndexField.VectorConfig vector_config = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.firestore.admin.v1.Index.IndexField.VectorConfig,
              com.google.firestore.admin.v1.Index.IndexField.VectorConfig.Builder,
              com.google.firestore.admin.v1.Index.IndexField.VectorConfigOrBuilder>
          internalGetVectorConfigFieldBuilder() {
        if (vectorConfigBuilder_ == null) {
          if (!(valueModeCase_ == 4)) {
            valueMode_ =
                com.google.firestore.admin.v1.Index.IndexField.VectorConfig.getDefaultInstance();
          }
          vectorConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig,
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfig.Builder,
                  com.google.firestore.admin.v1.Index.IndexField.VectorConfigOrBuilder>(
                  (com.google.firestore.admin.v1.Index.IndexField.VectorConfig) valueMode_,
                  getParentForChildren(),
                  isClean());
          valueMode_ = null;
        }
        valueModeCase_ = 4;
        onChanged();
        return vectorConfigBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Index.IndexField)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Index.IndexField)
    private static final com.google.firestore.admin.v1.Index.IndexField DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Index.IndexField();
    }

    public static com.google.firestore.admin.v1.Index.IndexField getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IndexField> PARSER =
        new com.google.protobuf.AbstractParser<IndexField>() {
          @java.lang.Override
          public IndexField parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IndexField> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IndexField> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Index.IndexField getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. A server defined name for this index.
   * The form of this name for composite indexes will be:
   * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{composite_index_id}`
   * For single field indexes, this field will be empty.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. A server defined name for this index.
   * The form of this name for composite indexes will be:
   * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{composite_index_id}`
   * For single field indexes, this field will be empty.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_SCOPE_FIELD_NUMBER = 2;
  private int queryScope_ = 0;

  /**
   *
   *
   * <pre>
   * Indexes with a collection query scope specified allow queries
   * against a collection that is the child of a specific document, specified at
   * query time, and that has the same collection ID.
   *
   * Indexes with a collection group query scope specified allow queries against
   * all collections descended from a specific document, specified at query
   * time, and that have the same collection ID as this index.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Index.QueryScope query_scope = 2;</code>
   *
   * @return The enum numeric value on the wire for queryScope.
   */
  @java.lang.Override
  public int getQueryScopeValue() {
    return queryScope_;
  }

  /**
   *
   *
   * <pre>
   * Indexes with a collection query scope specified allow queries
   * against a collection that is the child of a specific document, specified at
   * query time, and that has the same collection ID.
   *
   * Indexes with a collection group query scope specified allow queries against
   * all collections descended from a specific document, specified at query
   * time, and that have the same collection ID as this index.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Index.QueryScope query_scope = 2;</code>
   *
   * @return The queryScope.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Index.QueryScope getQueryScope() {
    com.google.firestore.admin.v1.Index.QueryScope result =
        com.google.firestore.admin.v1.Index.QueryScope.forNumber(queryScope_);
    return result == null ? com.google.firestore.admin.v1.Index.QueryScope.UNRECOGNIZED : result;
  }

  public static final int API_SCOPE_FIELD_NUMBER = 5;
  private int apiScope_ = 0;

  /**
   *
   *
   * <pre>
   * The API scope supported by this index.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Index.ApiScope api_scope = 5;</code>
   *
   * @return The enum numeric value on the wire for apiScope.
   */
  @java.lang.Override
  public int getApiScopeValue() {
    return apiScope_;
  }

  /**
   *
   *
   * <pre>
   * The API scope supported by this index.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Index.ApiScope api_scope = 5;</code>
   *
   * @return The apiScope.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Index.ApiScope getApiScope() {
    com.google.firestore.admin.v1.Index.ApiScope result =
        com.google.firestore.admin.v1.Index.ApiScope.forNumber(apiScope_);
    return result == null ? com.google.firestore.admin.v1.Index.ApiScope.UNRECOGNIZED : result;
  }

  public static final int FIELDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.firestore.admin.v1.Index.IndexField> fields_;

  /**
   *
   *
   * <pre>
   * The fields supported by this index.
   *
   * For composite indexes, this requires a minimum of 2 and a maximum of 100
   * fields. The last field entry is always for the field path `__name__`. If,
   * on creation, `__name__` was not specified as the last field, it will be
   * added automatically with the same direction as that of the last field
   * defined. If the final field in a composite index is not directional, the
   * `__name__` will be ordered ASCENDING (unless explicitly specified).
   *
   * For single field indexes, this will always be exactly one entry with a
   * field path equal to the field path of the associated field.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.admin.v1.Index.IndexField> getFieldsList() {
    return fields_;
  }

  /**
   *
   *
   * <pre>
   * The fields supported by this index.
   *
   * For composite indexes, this requires a minimum of 2 and a maximum of 100
   * fields. The last field entry is always for the field path `__name__`. If,
   * on creation, `__name__` was not specified as the last field, it will be
   * added automatically with the same direction as that of the last field
   * defined. If the final field in a composite index is not directional, the
   * `__name__` will be ordered ASCENDING (unless explicitly specified).
   *
   * For single field indexes, this will always be exactly one entry with a
   * field path equal to the field path of the associated field.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.firestore.admin.v1.Index.IndexFieldOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }

  /**
   *
   *
   * <pre>
   * The fields supported by this index.
   *
   * For composite indexes, this requires a minimum of 2 and a maximum of 100
   * fields. The last field entry is always for the field path `__name__`. If,
   * on creation, `__name__` was not specified as the last field, it will be
   * added automatically with the same direction as that of the last field
   * defined. If the final field in a composite index is not directional, the
   * `__name__` will be ordered ASCENDING (unless explicitly specified).
   *
   * For single field indexes, this will always be exactly one entry with a
   * field path equal to the field path of the associated field.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }

  /**
   *
   *
   * <pre>
   * The fields supported by this index.
   *
   * For composite indexes, this requires a minimum of 2 and a maximum of 100
   * fields. The last field entry is always for the field path `__name__`. If,
   * on creation, `__name__` was not specified as the last field, it will be
   * added automatically with the same direction as that of the last field
   * defined. If the final field in a composite index is not directional, the
   * `__name__` will be ordered ASCENDING (unless explicitly specified).
   *
   * For single field indexes, this will always be exactly one entry with a
   * field path equal to the field path of the associated field.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Index.IndexField getFields(int index) {
    return fields_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The fields supported by this index.
   *
   * For composite indexes, this requires a minimum of 2 and a maximum of 100
   * fields. The last field entry is always for the field path `__name__`. If,
   * on creation, `__name__` was not specified as the last field, it will be
   * added automatically with the same direction as that of the last field
   * defined. If the final field in a composite index is not directional, the
   * `__name__` will be ordered ASCENDING (unless explicitly specified).
   *
   * For single field indexes, this will always be exactly one entry with a
   * field path equal to the field path of the associated field.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Index.IndexFieldOrBuilder getFieldsOrBuilder(int index) {
    return fields_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The serving state of the index.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Index.State state = 4;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The serving state of the index.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Index.State state = 4;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Index.State getState() {
    com.google.firestore.admin.v1.Index.State result =
        com.google.firestore.admin.v1.Index.State.forNumber(state_);
    return result == null ? com.google.firestore.admin.v1.Index.State.UNRECOGNIZED : result;
  }

  public static final int DENSITY_FIELD_NUMBER = 6;
  private int density_ = 0;

  /**
   *
   *
   * <pre>
   * Immutable. The density configuration of the index.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Index.Density density = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for density.
   */
  @java.lang.Override
  public int getDensityValue() {
    return density_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The density configuration of the index.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Index.Density density = 6 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The density.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Index.Density getDensity() {
    com.google.firestore.admin.v1.Index.Density result =
        com.google.firestore.admin.v1.Index.Density.forNumber(density_);
    return result == null ? com.google.firestore.admin.v1.Index.Density.UNRECOGNIZED : result;
  }

  public static final int MULTIKEY_FIELD_NUMBER = 7;
  private boolean multikey_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether the index is multikey. By default, the index is not
   * multikey. For non-multikey indexes, none of the paths in the index
   * definition reach or traverse an array, except via an explicit array index.
   * For multikey indexes, at most one of the paths in the index definition
   * reach or traverse an array, except via an explicit array index. Violations
   * will result in errors.
   *
   * Note this field only applies to index with MONGODB_COMPATIBLE_API ApiScope.
   * </pre>
   *
   * <code>bool multikey = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The multikey.
   */
  @java.lang.Override
  public boolean getMultikey() {
    return multikey_;
  }

  public static final int SHARD_COUNT_FIELD_NUMBER = 8;
  private int shardCount_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The number of shards for the index.
   * </pre>
   *
   * <code>int32 shard_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The shardCount.
   */
  @java.lang.Override
  public int getShardCount() {
    return shardCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
    }
    if (queryScope_
        != com.google.firestore.admin.v1.Index.QueryScope.QUERY_SCOPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, queryScope_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(3, fields_.get(i));
    }
    if (state_ != com.google.firestore.admin.v1.Index.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (apiScope_ != com.google.firestore.admin.v1.Index.ApiScope.ANY_API.getNumber()) {
      output.writeEnum(5, apiScope_);
    }
    if (density_ != com.google.firestore.admin.v1.Index.Density.DENSITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, density_);
    }
    if (multikey_ != false) {
      output.writeBool(7, multikey_);
    }
    if (shardCount_ != 0) {
      output.writeInt32(8, shardCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
    }
    if (queryScope_
        != com.google.firestore.admin.v1.Index.QueryScope.QUERY_SCOPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, queryScope_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, fields_.get(i));
    }
    if (state_ != com.google.firestore.admin.v1.Index.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (apiScope_ != com.google.firestore.admin.v1.Index.ApiScope.ANY_API.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, apiScope_);
    }
    if (density_ != com.google.firestore.admin.v1.Index.Density.DENSITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, density_);
    }
    if (multikey_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, multikey_);
    }
    if (shardCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, shardCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.Index)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.Index other = (com.google.firestore.admin.v1.Index) obj;

    if (!getName().equals(other.getName())) return false;
    if (queryScope_ != other.queryScope_) return false;
    if (apiScope_ != other.apiScope_) return false;
    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (state_ != other.state_) return false;
    if (density_ != other.density_) return false;
    if (getMultikey() != other.getMultikey()) return false;
    if (getShardCount() != other.getShardCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + QUERY_SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + queryScope_;
    hash = (37 * hash) + API_SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + apiScope_;
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + DENSITY_FIELD_NUMBER;
    hash = (53 * hash) + density_;
    hash = (37 * hash) + MULTIKEY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMultikey());
    hash = (37 * hash) + SHARD_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getShardCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.Index parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Index parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Index parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Index parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.Index prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Cloud Firestore indexes enable simple and complex queries against
   * documents in a database.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Index}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Index)
      com.google.firestore.admin.v1.IndexOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.IndexProto
          .internal_static_google_firestore_admin_v1_Index_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.IndexProto
          .internal_static_google_firestore_admin_v1_Index_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Index.class,
              com.google.firestore.admin.v1.Index.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.Index.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      queryScope_ = 0;
      apiScope_ = 0;
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
      } else {
        fields_ = null;
        fieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      density_ = 0;
      multikey_ = false;
      shardCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.IndexProto
          .internal_static_google_firestore_admin_v1_Index_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Index getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.Index.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Index build() {
      com.google.firestore.admin.v1.Index result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Index buildPartial() {
      com.google.firestore.admin.v1.Index result = new com.google.firestore.admin.v1.Index(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.firestore.admin.v1.Index result) {
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.firestore.admin.v1.Index result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryScope_ = queryScope_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.apiScope_ = apiScope_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.density_ = density_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.multikey_ = multikey_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.shardCount_ = shardCount_;
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.Index) {
        return mergeFrom((com.google.firestore.admin.v1.Index) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.Index other) {
      if (other == com.google.firestore.admin.v1.Index.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.queryScope_ != 0) {
        setQueryScopeValue(other.getQueryScopeValue());
      }
      if (other.apiScope_ != 0) {
        setApiScopeValue(other.getApiScopeValue());
      }
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000008);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                    ? internalGetFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.density_ != 0) {
        setDensityValue(other.getDensityValue());
      }
      if (other.getMultikey() != false) {
        setMultikey(other.getMultikey());
      }
      if (other.getShardCount() != 0) {
        setShardCount(other.getShardCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                queryScope_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.firestore.admin.v1.Index.IndexField m =
                    input.readMessage(
                        com.google.firestore.admin.v1.Index.IndexField.parser(), extensionRegistry);
                if (fieldsBuilder_ == null) {
                  ensureFieldsIsMutable();
                  fields_.add(m);
                } else {
                  fieldsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 40:
              {
                apiScope_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 40
            case 48:
              {
                density_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                multikey_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                shardCount_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A server defined name for this index.
     * The form of this name for composite indexes will be:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{composite_index_id}`
     * For single field indexes, this field will be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A server defined name for this index.
     * The form of this name for composite indexes will be:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{composite_index_id}`
     * For single field indexes, this field will be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A server defined name for this index.
     * The form of this name for composite indexes will be:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{composite_index_id}`
     * For single field indexes, this field will be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A server defined name for this index.
     * The form of this name for composite indexes will be:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{composite_index_id}`
     * For single field indexes, this field will be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A server defined name for this index.
     * The form of this name for composite indexes will be:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{composite_index_id}`
     * For single field indexes, this field will be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int queryScope_ = 0;

    /**
     *
     *
     * <pre>
     * Indexes with a collection query scope specified allow queries
     * against a collection that is the child of a specific document, specified at
     * query time, and that has the same collection ID.
     *
     * Indexes with a collection group query scope specified allow queries against
     * all collections descended from a specific document, specified at query
     * time, and that have the same collection ID as this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.QueryScope query_scope = 2;</code>
     *
     * @return The enum numeric value on the wire for queryScope.
     */
    @java.lang.Override
    public int getQueryScopeValue() {
      return queryScope_;
    }

    /**
     *
     *
     * <pre>
     * Indexes with a collection query scope specified allow queries
     * against a collection that is the child of a specific document, specified at
     * query time, and that has the same collection ID.
     *
     * Indexes with a collection group query scope specified allow queries against
     * all collections descended from a specific document, specified at query
     * time, and that have the same collection ID as this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.QueryScope query_scope = 2;</code>
     *
     * @param value The enum numeric value on the wire for queryScope to set.
     * @return This builder for chaining.
     */
    public Builder setQueryScopeValue(int value) {
      queryScope_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indexes with a collection query scope specified allow queries
     * against a collection that is the child of a specific document, specified at
     * query time, and that has the same collection ID.
     *
     * Indexes with a collection group query scope specified allow queries against
     * all collections descended from a specific document, specified at query
     * time, and that have the same collection ID as this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.QueryScope query_scope = 2;</code>
     *
     * @return The queryScope.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Index.QueryScope getQueryScope() {
      com.google.firestore.admin.v1.Index.QueryScope result =
          com.google.firestore.admin.v1.Index.QueryScope.forNumber(queryScope_);
      return result == null ? com.google.firestore.admin.v1.Index.QueryScope.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Indexes with a collection query scope specified allow queries
     * against a collection that is the child of a specific document, specified at
     * query time, and that has the same collection ID.
     *
     * Indexes with a collection group query scope specified allow queries against
     * all collections descended from a specific document, specified at query
     * time, and that have the same collection ID as this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.QueryScope query_scope = 2;</code>
     *
     * @param value The queryScope to set.
     * @return This builder for chaining.
     */
    public Builder setQueryScope(com.google.firestore.admin.v1.Index.QueryScope value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      queryScope_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indexes with a collection query scope specified allow queries
     * against a collection that is the child of a specific document, specified at
     * query time, and that has the same collection ID.
     *
     * Indexes with a collection group query scope specified allow queries against
     * all collections descended from a specific document, specified at query
     * time, and that have the same collection ID as this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.QueryScope query_scope = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryScope() {
      bitField0_ = (bitField0_ & ~0x00000002);
      queryScope_ = 0;
      onChanged();
      return this;
    }

    private int apiScope_ = 0;

    /**
     *
     *
     * <pre>
     * The API scope supported by this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.ApiScope api_scope = 5;</code>
     *
     * @return The enum numeric value on the wire for apiScope.
     */
    @java.lang.Override
    public int getApiScopeValue() {
      return apiScope_;
    }

    /**
     *
     *
     * <pre>
     * The API scope supported by this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.ApiScope api_scope = 5;</code>
     *
     * @param value The enum numeric value on the wire for apiScope to set.
     * @return This builder for chaining.
     */
    public Builder setApiScopeValue(int value) {
      apiScope_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The API scope supported by this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.ApiScope api_scope = 5;</code>
     *
     * @return The apiScope.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Index.ApiScope getApiScope() {
      com.google.firestore.admin.v1.Index.ApiScope result =
          com.google.firestore.admin.v1.Index.ApiScope.forNumber(apiScope_);
      return result == null ? com.google.firestore.admin.v1.Index.ApiScope.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The API scope supported by this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.ApiScope api_scope = 5;</code>
     *
     * @param value The apiScope to set.
     * @return This builder for chaining.
     */
    public Builder setApiScope(com.google.firestore.admin.v1.Index.ApiScope value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      apiScope_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The API scope supported by this index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.ApiScope api_scope = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiScope() {
      bitField0_ = (bitField0_ & ~0x00000004);
      apiScope_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.firestore.admin.v1.Index.IndexField> fields_ =
        java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        fields_ = new java.util.ArrayList<com.google.firestore.admin.v1.Index.IndexField>(fields_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.firestore.admin.v1.Index.IndexField,
            com.google.firestore.admin.v1.Index.IndexField.Builder,
            com.google.firestore.admin.v1.Index.IndexFieldOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public java.util.List<com.google.firestore.admin.v1.Index.IndexField> getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public com.google.firestore.admin.v1.Index.IndexField getFields(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder setFields(int index, com.google.firestore.admin.v1.Index.IndexField value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder setFields(
        int index, com.google.firestore.admin.v1.Index.IndexField.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder addFields(com.google.firestore.admin.v1.Index.IndexField value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder addFields(int index, com.google.firestore.admin.v1.Index.IndexField value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder addFields(
        com.google.firestore.admin.v1.Index.IndexField.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder addFields(
        int index, com.google.firestore.admin.v1.Index.IndexField.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder addAllFields(
        java.lang.Iterable<? extends com.google.firestore.admin.v1.Index.IndexField> values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public com.google.firestore.admin.v1.Index.IndexField.Builder getFieldsBuilder(int index) {
      return internalGetFieldsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public com.google.firestore.admin.v1.Index.IndexFieldOrBuilder getFieldsOrBuilder(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public java.util.List<? extends com.google.firestore.admin.v1.Index.IndexFieldOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public com.google.firestore.admin.v1.Index.IndexField.Builder addFieldsBuilder() {
      return internalGetFieldsFieldBuilder()
          .addBuilder(com.google.firestore.admin.v1.Index.IndexField.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public com.google.firestore.admin.v1.Index.IndexField.Builder addFieldsBuilder(int index) {
      return internalGetFieldsFieldBuilder()
          .addBuilder(index, com.google.firestore.admin.v1.Index.IndexField.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The fields supported by this index.
     *
     * For composite indexes, this requires a minimum of 2 and a maximum of 100
     * fields. The last field entry is always for the field path `__name__`. If,
     * on creation, `__name__` was not specified as the last field, it will be
     * added automatically with the same direction as that of the last field
     * defined. If the final field in a composite index is not directional, the
     * `__name__` will be ordered ASCENDING (unless explicitly specified).
     *
     * For single field indexes, this will always be exactly one entry with a
     * field path equal to the field path of the associated field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index.IndexField fields = 3;</code>
     */
    public java.util.List<com.google.firestore.admin.v1.Index.IndexField.Builder>
        getFieldsBuilderList() {
      return internalGetFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.firestore.admin.v1.Index.IndexField,
            com.google.firestore.admin.v1.Index.IndexField.Builder,
            com.google.firestore.admin.v1.Index.IndexFieldOrBuilder>
        internalGetFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilder<
                com.google.firestore.admin.v1.Index.IndexField,
                com.google.firestore.admin.v1.Index.IndexField.Builder,
                com.google.firestore.admin.v1.Index.IndexFieldOrBuilder>(
                fields_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The serving state of the index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The serving state of the index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.State state = 4;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The serving state of the index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.State state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Index.State getState() {
      com.google.firestore.admin.v1.Index.State result =
          com.google.firestore.admin.v1.Index.State.forNumber(state_);
      return result == null ? com.google.firestore.admin.v1.Index.State.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The serving state of the index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.State state = 4;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.firestore.admin.v1.Index.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The serving state of the index.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Index.State state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private int density_ = 0;

    /**
     *
     *
     * <pre>
     * Immutable. The density configuration of the index.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Index.Density density = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for density.
     */
    @java.lang.Override
    public int getDensityValue() {
      return density_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The density configuration of the index.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Index.Density density = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for density to set.
     * @return This builder for chaining.
     */
    public Builder setDensityValue(int value) {
      density_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The density configuration of the index.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Index.Density density = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The density.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Index.Density getDensity() {
      com.google.firestore.admin.v1.Index.Density result =
          com.google.firestore.admin.v1.Index.Density.forNumber(density_);
      return result == null ? com.google.firestore.admin.v1.Index.Density.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The density configuration of the index.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Index.Density density = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The density to set.
     * @return This builder for chaining.
     */
    public Builder setDensity(com.google.firestore.admin.v1.Index.Density value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      density_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The density configuration of the index.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Index.Density density = 6 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDensity() {
      bitField0_ = (bitField0_ & ~0x00000020);
      density_ = 0;
      onChanged();
      return this;
    }

    private boolean multikey_;

    /**
     *
     *
     * <pre>
     * Optional. Whether the index is multikey. By default, the index is not
     * multikey. For non-multikey indexes, none of the paths in the index
     * definition reach or traverse an array, except via an explicit array index.
     * For multikey indexes, at most one of the paths in the index definition
     * reach or traverse an array, except via an explicit array index. Violations
     * will result in errors.
     *
     * Note this field only applies to index with MONGODB_COMPATIBLE_API ApiScope.
     * </pre>
     *
     * <code>bool multikey = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The multikey.
     */
    @java.lang.Override
    public boolean getMultikey() {
      return multikey_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether the index is multikey. By default, the index is not
     * multikey. For non-multikey indexes, none of the paths in the index
     * definition reach or traverse an array, except via an explicit array index.
     * For multikey indexes, at most one of the paths in the index definition
     * reach or traverse an array, except via an explicit array index. Violations
     * will result in errors.
     *
     * Note this field only applies to index with MONGODB_COMPATIBLE_API ApiScope.
     * </pre>
     *
     * <code>bool multikey = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The multikey to set.
     * @return This builder for chaining.
     */
    public Builder setMultikey(boolean value) {

      multikey_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether the index is multikey. By default, the index is not
     * multikey. For non-multikey indexes, none of the paths in the index
     * definition reach or traverse an array, except via an explicit array index.
     * For multikey indexes, at most one of the paths in the index definition
     * reach or traverse an array, except via an explicit array index. Violations
     * will result in errors.
     *
     * Note this field only applies to index with MONGODB_COMPATIBLE_API ApiScope.
     * </pre>
     *
     * <code>bool multikey = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultikey() {
      bitField0_ = (bitField0_ & ~0x00000040);
      multikey_ = false;
      onChanged();
      return this;
    }

    private int shardCount_;

    /**
     *
     *
     * <pre>
     * Optional. The number of shards for the index.
     * </pre>
     *
     * <code>int32 shard_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The shardCount.
     */
    @java.lang.Override
    public int getShardCount() {
      return shardCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The number of shards for the index.
     * </pre>
     *
     * <code>int32 shard_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The shardCount to set.
     * @return This builder for chaining.
     */
    public Builder setShardCount(int value) {

      shardCount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The number of shards for the index.
     * </pre>
     *
     * <code>int32 shard_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShardCount() {
      bitField0_ = (bitField0_ & ~0x00000080);
      shardCount_ = 0;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Index)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Index)
  private static final com.google.firestore.admin.v1.Index DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Index();
  }

  public static com.google.firestore.admin.v1.Index getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Index> PARSER =
      new com.google.protobuf.AbstractParser<Index>() {
        @java.lang.Override
        public Index parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Index> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Index> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.Index getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
