/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/admin/v1/snapshot.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * A consistent snapshot of a database at a specific point in time.
 * A PITR (Point-in-time recovery) snapshot with previous versions of a
 * database's data is available for every minute up to the associated database's
 * data retention period. If the PITR feature is enabled, the retention period
 * is 7 days; otherwise, it is one hour.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.PitrSnapshot}
 */
@com.google.protobuf.Generated
public final class PitrSnapshot extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.PitrSnapshot)
    PitrSnapshotOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "PitrSnapshot");
  }

  // Use PitrSnapshot.newBuilder() to construct.
  private PitrSnapshot(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private PitrSnapshot() {
    database_ = "";
    databaseUid_ = com.google.protobuf.ByteString.EMPTY;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.PitrSnapshotProto
        .internal_static_google_firestore_admin_v1_PitrSnapshot_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.PitrSnapshotProto
        .internal_static_google_firestore_admin_v1_PitrSnapshot_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.PitrSnapshot.class,
            com.google.firestore.admin.v1.PitrSnapshot.Builder.class);
  }

  private int bitField0_;
  public static final int DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the database that this was a snapshot of. Format:
   * `projects/{project}/databases/{database}`.
   * </pre>
   *
   * <code>
   * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the database that this was a snapshot of. Format:
   * `projects/{project}/databases/{database}`.
   * </pre>
   *
   * <code>
   * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_UID_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString databaseUid_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Output only. Public UUID of the database the snapshot was associated with.
   * </pre>
   *
   * <code>bytes database_uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The databaseUid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseUid() {
    return databaseUid_;
  }

  public static final int SNAPSHOT_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp snapshotTime_;

  /**
   *
   *
   * <pre>
   * Required. Snapshot time of the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the snapshotTime field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Snapshot time of the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The snapshotTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSnapshotTime() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }

  /**
   *
   *
   * <pre>
   * Required. Snapshot time of the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, database_);
    }
    if (!databaseUid_.isEmpty()) {
      output.writeBytes(2, databaseUid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSnapshotTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, database_);
    }
    if (!databaseUid_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, databaseUid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSnapshotTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.PitrSnapshot)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.PitrSnapshot other =
        (com.google.firestore.admin.v1.PitrSnapshot) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getDatabaseUid().equals(other.getDatabaseUid())) return false;
    if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
    if (hasSnapshotTime()) {
      if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    hash = (37 * hash) + DATABASE_UID_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseUid().hashCode();
    if (hasSnapshotTime()) {
      hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.PitrSnapshot parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.PitrSnapshot prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A consistent snapshot of a database at a specific point in time.
   * A PITR (Point-in-time recovery) snapshot with previous versions of a
   * database's data is available for every minute up to the associated database's
   * data retention period. If the PITR feature is enabled, the retention period
   * is 7 days; otherwise, it is one hour.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.PitrSnapshot}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.PitrSnapshot)
      com.google.firestore.admin.v1.PitrSnapshotOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.PitrSnapshotProto
          .internal_static_google_firestore_admin_v1_PitrSnapshot_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.PitrSnapshotProto
          .internal_static_google_firestore_admin_v1_PitrSnapshot_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.PitrSnapshot.class,
              com.google.firestore.admin.v1.PitrSnapshot.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.PitrSnapshot.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetSnapshotTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      databaseUid_ = com.google.protobuf.ByteString.EMPTY;
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.PitrSnapshotProto
          .internal_static_google_firestore_admin_v1_PitrSnapshot_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.PitrSnapshot getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.PitrSnapshot build() {
      com.google.firestore.admin.v1.PitrSnapshot result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.PitrSnapshot buildPartial() {
      com.google.firestore.admin.v1.PitrSnapshot result =
          new com.google.firestore.admin.v1.PitrSnapshot(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.PitrSnapshot result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.databaseUid_ = databaseUid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.snapshotTime_ =
            snapshotTimeBuilder_ == null ? snapshotTime_ : snapshotTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.PitrSnapshot) {
        return mergeFrom((com.google.firestore.admin.v1.PitrSnapshot) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.PitrSnapshot other) {
      if (other == com.google.firestore.admin.v1.PitrSnapshot.getDefaultInstance()) return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDatabaseUid().isEmpty()) {
        setDatabaseUid(other.getDatabaseUid());
      }
      if (other.hasSnapshotTime()) {
        mergeSnapshotTime(other.getSnapshotTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                databaseUid_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    internalGetSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>
     * string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString databaseUid_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Output only. Public UUID of the database the snapshot was associated with.
     * </pre>
     *
     * <code>bytes database_uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The databaseUid.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatabaseUid() {
      return databaseUid_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Public UUID of the database the snapshot was associated with.
     * </pre>
     *
     * <code>bytes database_uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The databaseUid to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseUid(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseUid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Public UUID of the database the snapshot was associated with.
     * </pre>
     *
     * <code>bytes database_uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseUid() {
      bitField0_ = (bitField0_ & ~0x00000002);
      databaseUid_ = getDefaultInstance().getDatabaseUid();
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp snapshotTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        snapshotTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the snapshotTime field is set.
     */
    public boolean hasSnapshotTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The snapshotTime.
     */
    public com.google.protobuf.Timestamp getSnapshotTime() {
      if (snapshotTimeBuilder_ == null) {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      } else {
        return snapshotTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotTime_ = value;
      } else {
        snapshotTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (snapshotTimeBuilder_ == null) {
        snapshotTime_ = builderForValue.build();
      } else {
        snapshotTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && snapshotTime_ != null
            && snapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSnapshotTimeBuilder().mergeFrom(value);
        } else {
          snapshotTime_ = value;
        }
      } else {
        snapshotTimeBuilder_.mergeFrom(value);
      }
      if (snapshotTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSnapshotTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return internalGetSnapshotTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      if (snapshotTimeBuilder_ != null) {
        return snapshotTimeBuilder_.getMessageOrBuilder();
      } else {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Snapshot time of the database.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetSnapshotTimeFieldBuilder() {
      if (snapshotTimeBuilder_ == null) {
        snapshotTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSnapshotTime(), getParentForChildren(), isClean());
        snapshotTime_ = null;
      }
      return snapshotTimeBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.PitrSnapshot)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.PitrSnapshot)
  private static final com.google.firestore.admin.v1.PitrSnapshot DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.PitrSnapshot();
  }

  public static com.google.firestore.admin.v1.PitrSnapshot getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PitrSnapshot> PARSER =
      new com.google.protobuf.AbstractParser<PitrSnapshot>() {
        @java.lang.Override
        public PitrSnapshot parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PitrSnapshot> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PitrSnapshot> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.PitrSnapshot getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
