/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/v1/firestore.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [Firestore.ExecutePipeline][google.firestore.v1.Firestore.ExecutePipeline].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.ExecutePipelineRequest}
 */
@com.google.protobuf.Generated
public final class ExecutePipelineRequest extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.ExecutePipelineRequest)
    ExecutePipelineRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "ExecutePipelineRequest");
  }

  // Use ExecutePipelineRequest.newBuilder() to construct.
  private ExecutePipelineRequest(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private ExecutePipelineRequest() {
    database_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ExecutePipelineRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ExecutePipelineRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.ExecutePipelineRequest.class,
            com.google.firestore.v1.ExecutePipelineRequest.Builder.class);
  }

  private int pipelineTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object pipelineType_;

  public enum PipelineTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRUCTURED_PIPELINE(2),
    PIPELINETYPE_NOT_SET(0);
    private final int value;

    private PipelineTypeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PipelineTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static PipelineTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return STRUCTURED_PIPELINE;
        case 0:
          return PIPELINETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PipelineTypeCase getPipelineTypeCase() {
    return PipelineTypeCase.forNumber(pipelineTypeCase_);
  }

  private int consistencySelectorCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object consistencySelector_;

  public enum ConsistencySelectorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSACTION(5),
    NEW_TRANSACTION(6),
    READ_TIME(7),
    CONSISTENCYSELECTOR_NOT_SET(0);
    private final int value;

    private ConsistencySelectorCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConsistencySelectorCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConsistencySelectorCase forNumber(int value) {
      switch (value) {
        case 5:
          return TRANSACTION;
        case 6:
          return NEW_TRANSACTION;
        case 7:
          return READ_TIME;
        case 0:
          return CONSISTENCYSELECTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConsistencySelectorCase getConsistencySelectorCase() {
    return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";

  /**
   *
   *
   * <pre>
   * Required. Database identifier, in the form
   * `projects/{project}/databases/{database}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Database identifier, in the form
   * `projects/{project}/databases/{database}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRUCTURED_PIPELINE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * A pipelined operation.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
   *
   * @return Whether the structuredPipeline field is set.
   */
  @java.lang.Override
  public boolean hasStructuredPipeline() {
    return pipelineTypeCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * A pipelined operation.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
   *
   * @return The structuredPipeline.
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredPipeline getStructuredPipeline() {
    if (pipelineTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredPipeline) pipelineType_;
    }
    return com.google.firestore.v1.StructuredPipeline.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * A pipelined operation.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredPipelineOrBuilder getStructuredPipelineOrBuilder() {
    if (pipelineTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredPipeline) pipelineType_;
    }
    return com.google.firestore.v1.StructuredPipeline.getDefaultInstance();
  }

  public static final int TRANSACTION_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Run the query within an already active transaction.
   *
   * The value here is the opaque transaction ID to execute the query in.
   * </pre>
   *
   * <code>bytes transaction = 5;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return consistencySelectorCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Run the query within an already active transaction.
   *
   * The value here is the opaque transaction ID to execute the query in.
   * </pre>
   *
   * <code>bytes transaction = 5;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    if (consistencySelectorCase_ == 5) {
      return (com.google.protobuf.ByteString) consistencySelector_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int NEW_TRANSACTION_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Execute the pipeline in a new transaction.
   *
   * The identifier of the newly created transaction will be returned in the
   * first response on the stream. This defaults to a read-only transaction.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
   *
   * @return Whether the newTransaction field is set.
   */
  @java.lang.Override
  public boolean hasNewTransaction() {
    return consistencySelectorCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Execute the pipeline in a new transaction.
   *
   * The identifier of the newly created transaction will be returned in the
   * first response on the stream. This defaults to a read-only transaction.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
   *
   * @return The newTransaction.
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions getNewTransaction() {
    if (consistencySelectorCase_ == 6) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Execute the pipeline in a new transaction.
   *
   * The identifier of the newly created transaction will be returned in the
   * first response on the stream. This defaults to a read-only transaction.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
    if (consistencySelectorCase_ == 6) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }

  public static final int READ_TIME_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Execute the pipeline in a snapshot transaction at the given time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return consistencySelectorCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Execute the pipeline in a snapshot transaction at the given time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    if (consistencySelectorCase_ == 7) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Execute the pipeline in a snapshot transaction at the given time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    if (consistencySelectorCase_ == 7) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, database_);
    }
    if (pipelineTypeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.StructuredPipeline) pipelineType_);
    }
    if (consistencySelectorCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 6) {
      output.writeMessage(6, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 7) {
      output.writeMessage(7, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, database_);
    }
    if (pipelineTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.StructuredPipeline) pipelineType_);
    }
    if (consistencySelectorCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.ExecutePipelineRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.ExecutePipelineRequest other =
        (com.google.firestore.v1.ExecutePipelineRequest) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getPipelineTypeCase().equals(other.getPipelineTypeCase())) return false;
    switch (pipelineTypeCase_) {
      case 2:
        if (!getStructuredPipeline().equals(other.getStructuredPipeline())) return false;
        break;
      case 0:
      default:
    }
    if (!getConsistencySelectorCase().equals(other.getConsistencySelectorCase())) return false;
    switch (consistencySelectorCase_) {
      case 5:
        if (!getTransaction().equals(other.getTransaction())) return false;
        break;
      case 6:
        if (!getNewTransaction().equals(other.getNewTransaction())) return false;
        break;
      case 7:
        if (!getReadTime().equals(other.getReadTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    switch (pipelineTypeCase_) {
      case 2:
        hash = (37 * hash) + STRUCTURED_PIPELINE_FIELD_NUMBER;
        hash = (53 * hash) + getStructuredPipeline().hashCode();
        break;
      case 0:
      default:
    }
    switch (consistencySelectorCase_) {
      case 5:
        hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTransaction().hashCode();
        break;
      case 6:
        hash = (37 * hash) + NEW_TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getNewTransaction().hashCode();
        break;
      case 7:
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ExecutePipelineRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.ExecutePipelineRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for
   * [Firestore.ExecutePipeline][google.firestore.v1.Firestore.ExecutePipeline].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.ExecutePipelineRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.ExecutePipelineRequest)
      com.google.firestore.v1.ExecutePipelineRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ExecutePipelineRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ExecutePipelineRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.ExecutePipelineRequest.class,
              com.google.firestore.v1.ExecutePipelineRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.ExecutePipelineRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      if (structuredPipelineBuilder_ != null) {
        structuredPipelineBuilder_.clear();
      }
      if (newTransactionBuilder_ != null) {
        newTransactionBuilder_.clear();
      }
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.clear();
      }
      pipelineTypeCase_ = 0;
      pipelineType_ = null;
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ExecutePipelineRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.ExecutePipelineRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.ExecutePipelineRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.ExecutePipelineRequest build() {
      com.google.firestore.v1.ExecutePipelineRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.ExecutePipelineRequest buildPartial() {
      com.google.firestore.v1.ExecutePipelineRequest result =
          new com.google.firestore.v1.ExecutePipelineRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.ExecutePipelineRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
    }

    private void buildPartialOneofs(com.google.firestore.v1.ExecutePipelineRequest result) {
      result.pipelineTypeCase_ = pipelineTypeCase_;
      result.pipelineType_ = this.pipelineType_;
      if (pipelineTypeCase_ == 2 && structuredPipelineBuilder_ != null) {
        result.pipelineType_ = structuredPipelineBuilder_.build();
      }
      result.consistencySelectorCase_ = consistencySelectorCase_;
      result.consistencySelector_ = this.consistencySelector_;
      if (consistencySelectorCase_ == 6 && newTransactionBuilder_ != null) {
        result.consistencySelector_ = newTransactionBuilder_.build();
      }
      if (consistencySelectorCase_ == 7 && readTimeBuilder_ != null) {
        result.consistencySelector_ = readTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.ExecutePipelineRequest) {
        return mergeFrom((com.google.firestore.v1.ExecutePipelineRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.ExecutePipelineRequest other) {
      if (other == com.google.firestore.v1.ExecutePipelineRequest.getDefaultInstance()) return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getPipelineTypeCase()) {
        case STRUCTURED_PIPELINE:
          {
            mergeStructuredPipeline(other.getStructuredPipeline());
            break;
          }
        case PIPELINETYPE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getConsistencySelectorCase()) {
        case TRANSACTION:
          {
            setTransaction(other.getTransaction());
            break;
          }
        case NEW_TRANSACTION:
          {
            mergeNewTransaction(other.getNewTransaction());
            break;
          }
        case READ_TIME:
          {
            mergeReadTime(other.getReadTime());
            break;
          }
        case CONSISTENCYSELECTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    internalGetStructuredPipelineFieldBuilder().getBuilder(), extensionRegistry);
                pipelineTypeCase_ = 2;
                break;
              } // case 18
            case 42:
              {
                consistencySelector_ = input.readBytes();
                consistencySelectorCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    internalGetNewTransactionFieldBuilder().getBuilder(), extensionRegistry);
                consistencySelectorCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    internalGetReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                consistencySelectorCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int pipelineTypeCase_ = 0;
    private java.lang.Object pipelineType_;

    public PipelineTypeCase getPipelineTypeCase() {
      return PipelineTypeCase.forNumber(pipelineTypeCase_);
    }

    public Builder clearPipelineType() {
      pipelineTypeCase_ = 0;
      pipelineType_ = null;
      onChanged();
      return this;
    }

    private int consistencySelectorCase_ = 0;
    private java.lang.Object consistencySelector_;

    public ConsistencySelectorCase getConsistencySelectorCase() {
      return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
    }

    public Builder clearConsistencySelector() {
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";

    /**
     *
     *
     * <pre>
     * Required. Database identifier, in the form
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Database identifier, in the form
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Database identifier, in the form
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Database identifier, in the form
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Database identifier, in the form
     * `projects/{project}/databases/{database}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.StructuredPipeline,
            com.google.firestore.v1.StructuredPipeline.Builder,
            com.google.firestore.v1.StructuredPipelineOrBuilder>
        structuredPipelineBuilder_;

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     *
     * @return Whether the structuredPipeline field is set.
     */
    @java.lang.Override
    public boolean hasStructuredPipeline() {
      return pipelineTypeCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     *
     * @return The structuredPipeline.
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredPipeline getStructuredPipeline() {
      if (structuredPipelineBuilder_ == null) {
        if (pipelineTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredPipeline) pipelineType_;
        }
        return com.google.firestore.v1.StructuredPipeline.getDefaultInstance();
      } else {
        if (pipelineTypeCase_ == 2) {
          return structuredPipelineBuilder_.getMessage();
        }
        return com.google.firestore.v1.StructuredPipeline.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     */
    public Builder setStructuredPipeline(com.google.firestore.v1.StructuredPipeline value) {
      if (structuredPipelineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pipelineType_ = value;
        onChanged();
      } else {
        structuredPipelineBuilder_.setMessage(value);
      }
      pipelineTypeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     */
    public Builder setStructuredPipeline(
        com.google.firestore.v1.StructuredPipeline.Builder builderForValue) {
      if (structuredPipelineBuilder_ == null) {
        pipelineType_ = builderForValue.build();
        onChanged();
      } else {
        structuredPipelineBuilder_.setMessage(builderForValue.build());
      }
      pipelineTypeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     */
    public Builder mergeStructuredPipeline(com.google.firestore.v1.StructuredPipeline value) {
      if (structuredPipelineBuilder_ == null) {
        if (pipelineTypeCase_ == 2
            && pipelineType_ != com.google.firestore.v1.StructuredPipeline.getDefaultInstance()) {
          pipelineType_ =
              com.google.firestore.v1.StructuredPipeline.newBuilder(
                      (com.google.firestore.v1.StructuredPipeline) pipelineType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pipelineType_ = value;
        }
        onChanged();
      } else {
        if (pipelineTypeCase_ == 2) {
          structuredPipelineBuilder_.mergeFrom(value);
        } else {
          structuredPipelineBuilder_.setMessage(value);
        }
      }
      pipelineTypeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     */
    public Builder clearStructuredPipeline() {
      if (structuredPipelineBuilder_ == null) {
        if (pipelineTypeCase_ == 2) {
          pipelineTypeCase_ = 0;
          pipelineType_ = null;
          onChanged();
        }
      } else {
        if (pipelineTypeCase_ == 2) {
          pipelineTypeCase_ = 0;
          pipelineType_ = null;
        }
        structuredPipelineBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     */
    public com.google.firestore.v1.StructuredPipeline.Builder getStructuredPipelineBuilder() {
      return internalGetStructuredPipelineFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredPipelineOrBuilder getStructuredPipelineOrBuilder() {
      if ((pipelineTypeCase_ == 2) && (structuredPipelineBuilder_ != null)) {
        return structuredPipelineBuilder_.getMessageOrBuilder();
      } else {
        if (pipelineTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredPipeline) pipelineType_;
        }
        return com.google.firestore.v1.StructuredPipeline.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * A pipelined operation.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredPipeline structured_pipeline = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.StructuredPipeline,
            com.google.firestore.v1.StructuredPipeline.Builder,
            com.google.firestore.v1.StructuredPipelineOrBuilder>
        internalGetStructuredPipelineFieldBuilder() {
      if (structuredPipelineBuilder_ == null) {
        if (!(pipelineTypeCase_ == 2)) {
          pipelineType_ = com.google.firestore.v1.StructuredPipeline.getDefaultInstance();
        }
        structuredPipelineBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.v1.StructuredPipeline,
                com.google.firestore.v1.StructuredPipeline.Builder,
                com.google.firestore.v1.StructuredPipelineOrBuilder>(
                (com.google.firestore.v1.StructuredPipeline) pipelineType_,
                getParentForChildren(),
                isClean());
        pipelineType_ = null;
      }
      pipelineTypeCase_ = 2;
      onChanged();
      return structuredPipelineBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Run the query within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return consistencySelectorCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Run the query within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return The transaction.
     */
    public com.google.protobuf.ByteString getTransaction() {
      if (consistencySelectorCase_ == 5) {
        return (com.google.protobuf.ByteString) consistencySelector_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    /**
     *
     *
     * <pre>
     * Run the query within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencySelectorCase_ = 5;
      consistencySelector_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Run the query within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      if (consistencySelectorCase_ == 5) {
        consistencySelectorCase_ = 0;
        consistencySelector_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        newTransactionBuilder_;

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     *
     * @return Whether the newTransaction field is set.
     */
    @java.lang.Override
    public boolean hasNewTransaction() {
      return consistencySelectorCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     *
     * @return The newTransaction.
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions getNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 6) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 6) {
          return newTransactionBuilder_.getMessage();
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder setNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder setNewTransaction(
        com.google.firestore.v1.TransactionOptions.Builder builderForValue) {
      if (newTransactionBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder mergeNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 6
            && consistencySelector_
                != com.google.firestore.v1.TransactionOptions.getDefaultInstance()) {
          consistencySelector_ =
              com.google.firestore.v1.TransactionOptions.newBuilder(
                      (com.google.firestore.v1.TransactionOptions) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 6) {
          newTransactionBuilder_.mergeFrom(value);
        } else {
          newTransactionBuilder_.setMessage(value);
        }
      }
      consistencySelectorCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder clearNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 6) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 6) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        newTransactionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public com.google.firestore.v1.TransactionOptions.Builder getNewTransactionBuilder() {
      return internalGetNewTransactionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
      if ((consistencySelectorCase_ == 6) && (newTransactionBuilder_ != null)) {
        return newTransactionBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 6) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a new transaction.
     *
     * The identifier of the newly created transaction will be returned in the
     * first response on the stream. This defaults to a read-only transaction.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        internalGetNewTransactionFieldBuilder() {
      if (newTransactionBuilder_ == null) {
        if (!(consistencySelectorCase_ == 6)) {
          consistencySelector_ = com.google.firestore.v1.TransactionOptions.getDefaultInstance();
        }
        newTransactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.v1.TransactionOptions,
                com.google.firestore.v1.TransactionOptions.Builder,
                com.google.firestore.v1.TransactionOptionsOrBuilder>(
                (com.google.firestore.v1.TransactionOptions) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 6;
      onChanged();
      return newTransactionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return consistencySelectorCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 7) {
          return readTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7
            && consistencySelector_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          consistencySelector_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 7) {
          readTimeBuilder_.mergeFrom(value);
        } else {
          readTimeBuilder_.setMessage(value);
        }
      }
      consistencySelectorCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 7) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        readTimeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      return internalGetReadTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if ((consistencySelectorCase_ == 7) && (readTimeBuilder_ != null)) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 7) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Execute the pipeline in a snapshot transaction at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        if (!(consistencySelectorCase_ == 7)) {
          consistencySelector_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 7;
      onChanged();
      return readTimeBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.ExecutePipelineRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.ExecutePipelineRequest)
  private static final com.google.firestore.v1.ExecutePipelineRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.ExecutePipelineRequest();
  }

  public static com.google.firestore.v1.ExecutePipelineRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecutePipelineRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExecutePipelineRequest>() {
        @java.lang.Override
        public ExecutePipelineRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecutePipelineRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecutePipelineRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.ExecutePipelineRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
