/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/v1/firestore.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The response for [Firestore.Execute][].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.ExecutePipelineResponse}
 */
@com.google.protobuf.Generated
public final class ExecutePipelineResponse extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.ExecutePipelineResponse)
    ExecutePipelineResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "ExecutePipelineResponse");
  }

  // Use ExecutePipelineResponse.newBuilder() to construct.
  private ExecutePipelineResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private ExecutePipelineResponse() {
    transaction_ = com.google.protobuf.ByteString.EMPTY;
    results_ = java.util.Collections.emptyList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ExecutePipelineResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ExecutePipelineResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.ExecutePipelineResponse.class,
            com.google.firestore.v1.ExecutePipelineResponse.Builder.class);
  }

  private int bitField0_;
  public static final int TRANSACTION_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Newly created transaction identifier.
   *
   * This field is only specified as part of the first response from the server,
   * alongside the `results` field when the original request specified
   * [ExecuteRequest.new_transaction][].
   * </pre>
   *
   * <code>bytes transaction = 1;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    return transaction_;
  }

  public static final int RESULTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.firestore.v1.Document> results_;

  /**
   *
   *
   * <pre>
   * An ordered batch of results returned executing a pipeline.
   *
   * The batch size is variable, and can even be zero for when only a partial
   * progress message is returned.
   *
   * The fields present in the returned documents are only those that were
   * explicitly requested in the pipeline, this includes those like
   * [`__name__`][google.firestore.v1.Document.name] and
   * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
   * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
   * RPCs which always return such fields even when they are not specified in
   * the [`mask`][google.firestore.v1.DocumentMask].
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Document results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.v1.Document> getResultsList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * An ordered batch of results returned executing a pipeline.
   *
   * The batch size is variable, and can even be zero for when only a partial
   * progress message is returned.
   *
   * The fields present in the returned documents are only those that were
   * explicitly requested in the pipeline, this includes those like
   * [`__name__`][google.firestore.v1.Document.name] and
   * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
   * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
   * RPCs which always return such fields even when they are not specified in
   * the [`mask`][google.firestore.v1.DocumentMask].
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Document results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.firestore.v1.DocumentOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * An ordered batch of results returned executing a pipeline.
   *
   * The batch size is variable, and can even be zero for when only a partial
   * progress message is returned.
   *
   * The fields present in the returned documents are only those that were
   * explicitly requested in the pipeline, this includes those like
   * [`__name__`][google.firestore.v1.Document.name] and
   * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
   * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
   * RPCs which always return such fields even when they are not specified in
   * the [`mask`][google.firestore.v1.DocumentMask].
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Document results = 2;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }

  /**
   *
   *
   * <pre>
   * An ordered batch of results returned executing a pipeline.
   *
   * The batch size is variable, and can even be zero for when only a partial
   * progress message is returned.
   *
   * The fields present in the returned documents are only those that were
   * explicitly requested in the pipeline, this includes those like
   * [`__name__`][google.firestore.v1.Document.name] and
   * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
   * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
   * RPCs which always return such fields even when they are not specified in
   * the [`mask`][google.firestore.v1.DocumentMask].
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Document results = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Document getResults(int index) {
    return results_.get(index);
  }

  /**
   *
   *
   * <pre>
   * An ordered batch of results returned executing a pipeline.
   *
   * The batch size is variable, and can even be zero for when only a partial
   * progress message is returned.
   *
   * The fields present in the returned documents are only those that were
   * explicitly requested in the pipeline, this includes those like
   * [`__name__`][google.firestore.v1.Document.name] and
   * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
   * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
   * RPCs which always return such fields even when they are not specified in
   * the [`mask`][google.firestore.v1.DocumentMask].
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Document results = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentOrBuilder getResultsOrBuilder(int index) {
    return results_.get(index);
  }

  public static final int EXECUTION_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp executionTime_;

  /**
   *
   *
   * <pre>
   * The time at which the results are valid.
   *
   * This is a (not strictly) monotonically increasing value across multiple
   * responses in the same stream. The API guarantees that all previously
   * returned results are still valid at the latest `execution_time`. This
   * allows the API consumer to treat the query if it ran at the latest
   * `execution_time` returned.
   *
   * If the query returns no results, a response with `execution_time` and no
   * `results` will be sent, and this represents the time at which the operation
   * was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp execution_time = 3;</code>
   *
   * @return Whether the executionTime field is set.
   */
  @java.lang.Override
  public boolean hasExecutionTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time at which the results are valid.
   *
   * This is a (not strictly) monotonically increasing value across multiple
   * responses in the same stream. The API guarantees that all previously
   * returned results are still valid at the latest `execution_time`. This
   * allows the API consumer to treat the query if it ran at the latest
   * `execution_time` returned.
   *
   * If the query returns no results, a response with `execution_time` and no
   * `results` will be sent, and this represents the time at which the operation
   * was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp execution_time = 3;</code>
   *
   * @return The executionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExecutionTime() {
    return executionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : executionTime_;
  }

  /**
   *
   *
   * <pre>
   * The time at which the results are valid.
   *
   * This is a (not strictly) monotonically increasing value across multiple
   * responses in the same stream. The API guarantees that all previously
   * returned results are still valid at the latest `execution_time`. This
   * allows the API consumer to treat the query if it ran at the latest
   * `execution_time` returned.
   *
   * If the query returns no results, a response with `execution_time` and no
   * `results` will be sent, and this represents the time at which the operation
   * was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp execution_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExecutionTimeOrBuilder() {
    return executionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : executionTime_;
  }

  public static final int EXPLAIN_STATS_FIELD_NUMBER = 4;
  private com.google.firestore.v1.ExplainStats explainStats_;

  /**
   *
   *
   * <pre>
   * Query explain stats.
   *
   * This is present on the **last** response if the request configured explain
   * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
   * does not return any results, a response with `explain_stats` and no
   * `results` will still be sent.
   * </pre>
   *
   * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
   *
   * @return Whether the explainStats field is set.
   */
  @java.lang.Override
  public boolean hasExplainStats() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Query explain stats.
   *
   * This is present on the **last** response if the request configured explain
   * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
   * does not return any results, a response with `explain_stats` and no
   * `results` will still be sent.
   * </pre>
   *
   * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
   *
   * @return The explainStats.
   */
  @java.lang.Override
  public com.google.firestore.v1.ExplainStats getExplainStats() {
    return explainStats_ == null
        ? com.google.firestore.v1.ExplainStats.getDefaultInstance()
        : explainStats_;
  }

  /**
   *
   *
   * <pre>
   * Query explain stats.
   *
   * This is present on the **last** response if the request configured explain
   * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
   * does not return any results, a response with `explain_stats` and no
   * `results` will still be sent.
   * </pre>
   *
   * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.ExplainStatsOrBuilder getExplainStatsOrBuilder() {
    return explainStats_ == null
        ? com.google.firestore.v1.ExplainStats.getDefaultInstance()
        : explainStats_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!transaction_.isEmpty()) {
      output.writeBytes(1, transaction_);
    }
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(2, results_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getExecutionTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getExplainStats());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!transaction_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, transaction_);
    }
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, results_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExecutionTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getExplainStats());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.ExecutePipelineResponse)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.ExecutePipelineResponse other =
        (com.google.firestore.v1.ExecutePipelineResponse) obj;

    if (!getTransaction().equals(other.getTransaction())) return false;
    if (!getResultsList().equals(other.getResultsList())) return false;
    if (hasExecutionTime() != other.hasExecutionTime()) return false;
    if (hasExecutionTime()) {
      if (!getExecutionTime().equals(other.getExecutionTime())) return false;
    }
    if (hasExplainStats() != other.hasExplainStats()) return false;
    if (hasExplainStats()) {
      if (!getExplainStats().equals(other.getExplainStats())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
    hash = (53 * hash) + getTransaction().hashCode();
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    if (hasExecutionTime()) {
      hash = (37 * hash) + EXECUTION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionTime().hashCode();
    }
    if (hasExplainStats()) {
      hash = (37 * hash) + EXPLAIN_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getExplainStats().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ExecutePipelineResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.ExecutePipelineResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The response for [Firestore.Execute][].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.ExecutePipelineResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.ExecutePipelineResponse)
      com.google.firestore.v1.ExecutePipelineResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ExecutePipelineResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ExecutePipelineResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.ExecutePipelineResponse.class,
              com.google.firestore.v1.ExecutePipelineResponse.Builder.class);
    }

    // Construct using com.google.firestore.v1.ExecutePipelineResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetResultsFieldBuilder();
        internalGetExecutionTimeFieldBuilder();
        internalGetExplainStatsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      transaction_ = com.google.protobuf.ByteString.EMPTY;
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      executionTime_ = null;
      if (executionTimeBuilder_ != null) {
        executionTimeBuilder_.dispose();
        executionTimeBuilder_ = null;
      }
      explainStats_ = null;
      if (explainStatsBuilder_ != null) {
        explainStatsBuilder_.dispose();
        explainStatsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ExecutePipelineResponse_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.ExecutePipelineResponse getDefaultInstanceForType() {
      return com.google.firestore.v1.ExecutePipelineResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.ExecutePipelineResponse build() {
      com.google.firestore.v1.ExecutePipelineResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.ExecutePipelineResponse buildPartial() {
      com.google.firestore.v1.ExecutePipelineResponse result =
          new com.google.firestore.v1.ExecutePipelineResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.firestore.v1.ExecutePipelineResponse result) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.firestore.v1.ExecutePipelineResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.transaction_ = transaction_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.executionTime_ =
            executionTimeBuilder_ == null ? executionTime_ : executionTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.explainStats_ =
            explainStatsBuilder_ == null ? explainStats_ : explainStatsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.ExecutePipelineResponse) {
        return mergeFrom((com.google.firestore.v1.ExecutePipelineResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.ExecutePipelineResponse other) {
      if (other == com.google.firestore.v1.ExecutePipelineResponse.getDefaultInstance())
        return this;
      if (!other.getTransaction().isEmpty()) {
        setTransaction(other.getTransaction());
      }
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000002);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                    ? internalGetResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (other.hasExecutionTime()) {
        mergeExecutionTime(other.getExecutionTime());
      }
      if (other.hasExplainStats()) {
        mergeExplainStats(other.getExplainStats());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                transaction_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.firestore.v1.Document m =
                    input.readMessage(com.google.firestore.v1.Document.parser(), extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    internalGetExecutionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    internalGetExplainStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Newly created transaction identifier.
     *
     * This field is only specified as part of the first response from the server,
     * alongside the `results` field when the original request specified
     * [ExecuteRequest.new_transaction][].
     * </pre>
     *
     * <code>bytes transaction = 1;</code>
     *
     * @return The transaction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTransaction() {
      return transaction_;
    }

    /**
     *
     *
     * <pre>
     * Newly created transaction identifier.
     *
     * This field is only specified as part of the first response from the server,
     * alongside the `results` field when the original request specified
     * [ExecuteRequest.new_transaction][].
     * </pre>
     *
     * <code>bytes transaction = 1;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transaction_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Newly created transaction identifier.
     *
     * This field is only specified as part of the first response from the server,
     * alongside the `results` field when the original request specified
     * [ExecuteRequest.new_transaction][].
     * </pre>
     *
     * <code>bytes transaction = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      bitField0_ = (bitField0_ & ~0x00000001);
      transaction_ = getDefaultInstance().getTransaction();
      onChanged();
      return this;
    }

    private java.util.List<com.google.firestore.v1.Document> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        results_ = new java.util.ArrayList<com.google.firestore.v1.Document>(results_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public java.util.List<com.google.firestore.v1.Document> getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public com.google.firestore.v1.Document getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder setResults(int index, com.google.firestore.v1.Document value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder setResults(int index, com.google.firestore.v1.Document.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder addResults(com.google.firestore.v1.Document value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder addResults(int index, com.google.firestore.v1.Document value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder addResults(com.google.firestore.v1.Document.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder addResults(int index, com.google.firestore.v1.Document.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.firestore.v1.Document> values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public com.google.firestore.v1.Document.Builder getResultsBuilder(int index) {
      return internalGetResultsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public com.google.firestore.v1.DocumentOrBuilder getResultsOrBuilder(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public java.util.List<? extends com.google.firestore.v1.DocumentOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public com.google.firestore.v1.Document.Builder addResultsBuilder() {
      return internalGetResultsFieldBuilder()
          .addBuilder(com.google.firestore.v1.Document.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public com.google.firestore.v1.Document.Builder addResultsBuilder(int index) {
      return internalGetResultsFieldBuilder()
          .addBuilder(index, com.google.firestore.v1.Document.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An ordered batch of results returned executing a pipeline.
     *
     * The batch size is variable, and can even be zero for when only a partial
     * progress message is returned.
     *
     * The fields present in the returned documents are only those that were
     * explicitly requested in the pipeline, this includes those like
     * [`__name__`][google.firestore.v1.Document.name] and
     * [`__update_time__`][google.firestore.v1.Document.update_time]. This is
     * explicitly a divergence from `Firestore.RunQuery` / `Firestore.GetDocument`
     * RPCs which always return such fields even when they are not specified in
     * the [`mask`][google.firestore.v1.DocumentMask].
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Document results = 2;</code>
     */
    public java.util.List<com.google.firestore.v1.Document.Builder> getResultsBuilderList() {
      return internalGetResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        internalGetResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilder<
                com.google.firestore.v1.Document,
                com.google.firestore.v1.Document.Builder,
                com.google.firestore.v1.DocumentOrBuilder>(
                results_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private com.google.protobuf.Timestamp executionTime_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        executionTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     *
     * @return Whether the executionTime field is set.
     */
    public boolean hasExecutionTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     *
     * @return The executionTime.
     */
    public com.google.protobuf.Timestamp getExecutionTime() {
      if (executionTimeBuilder_ == null) {
        return executionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : executionTime_;
      } else {
        return executionTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     */
    public Builder setExecutionTime(com.google.protobuf.Timestamp value) {
      if (executionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executionTime_ = value;
      } else {
        executionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     */
    public Builder setExecutionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (executionTimeBuilder_ == null) {
        executionTime_ = builderForValue.build();
      } else {
        executionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     */
    public Builder mergeExecutionTime(com.google.protobuf.Timestamp value) {
      if (executionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && executionTime_ != null
            && executionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExecutionTimeBuilder().mergeFrom(value);
        } else {
          executionTime_ = value;
        }
      } else {
        executionTimeBuilder_.mergeFrom(value);
      }
      if (executionTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     */
    public Builder clearExecutionTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      executionTime_ = null;
      if (executionTimeBuilder_ != null) {
        executionTimeBuilder_.dispose();
        executionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExecutionTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return internalGetExecutionTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getExecutionTimeOrBuilder() {
      if (executionTimeBuilder_ != null) {
        return executionTimeBuilder_.getMessageOrBuilder();
      } else {
        return executionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : executionTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which the results are valid.
     *
     * This is a (not strictly) monotonically increasing value across multiple
     * responses in the same stream. The API guarantees that all previously
     * returned results are still valid at the latest `execution_time`. This
     * allows the API consumer to treat the query if it ran at the latest
     * `execution_time` returned.
     *
     * If the query returns no results, a response with `execution_time` and no
     * `results` will be sent, and this represents the time at which the operation
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp execution_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetExecutionTimeFieldBuilder() {
      if (executionTimeBuilder_ == null) {
        executionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExecutionTime(), getParentForChildren(), isClean());
        executionTime_ = null;
      }
      return executionTimeBuilder_;
    }

    private com.google.firestore.v1.ExplainStats explainStats_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.ExplainStats,
            com.google.firestore.v1.ExplainStats.Builder,
            com.google.firestore.v1.ExplainStatsOrBuilder>
        explainStatsBuilder_;

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     *
     * @return Whether the explainStats field is set.
     */
    public boolean hasExplainStats() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     *
     * @return The explainStats.
     */
    public com.google.firestore.v1.ExplainStats getExplainStats() {
      if (explainStatsBuilder_ == null) {
        return explainStats_ == null
            ? com.google.firestore.v1.ExplainStats.getDefaultInstance()
            : explainStats_;
      } else {
        return explainStatsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     */
    public Builder setExplainStats(com.google.firestore.v1.ExplainStats value) {
      if (explainStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explainStats_ = value;
      } else {
        explainStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     */
    public Builder setExplainStats(com.google.firestore.v1.ExplainStats.Builder builderForValue) {
      if (explainStatsBuilder_ == null) {
        explainStats_ = builderForValue.build();
      } else {
        explainStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     */
    public Builder mergeExplainStats(com.google.firestore.v1.ExplainStats value) {
      if (explainStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && explainStats_ != null
            && explainStats_ != com.google.firestore.v1.ExplainStats.getDefaultInstance()) {
          getExplainStatsBuilder().mergeFrom(value);
        } else {
          explainStats_ = value;
        }
      } else {
        explainStatsBuilder_.mergeFrom(value);
      }
      if (explainStats_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     */
    public Builder clearExplainStats() {
      bitField0_ = (bitField0_ & ~0x00000008);
      explainStats_ = null;
      if (explainStatsBuilder_ != null) {
        explainStatsBuilder_.dispose();
        explainStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     */
    public com.google.firestore.v1.ExplainStats.Builder getExplainStatsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return internalGetExplainStatsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     */
    public com.google.firestore.v1.ExplainStatsOrBuilder getExplainStatsOrBuilder() {
      if (explainStatsBuilder_ != null) {
        return explainStatsBuilder_.getMessageOrBuilder();
      } else {
        return explainStats_ == null
            ? com.google.firestore.v1.ExplainStats.getDefaultInstance()
            : explainStats_;
      }
    }

    /**
     *
     *
     * <pre>
     * Query explain stats.
     *
     * This is present on the **last** response if the request configured explain
     * to run in 'analyze' or 'explain' mode in the pipeline options. If the query
     * does not return any results, a response with `explain_stats` and no
     * `results` will still be sent.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainStats explain_stats = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.ExplainStats,
            com.google.firestore.v1.ExplainStats.Builder,
            com.google.firestore.v1.ExplainStatsOrBuilder>
        internalGetExplainStatsFieldBuilder() {
      if (explainStatsBuilder_ == null) {
        explainStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.v1.ExplainStats,
                com.google.firestore.v1.ExplainStats.Builder,
                com.google.firestore.v1.ExplainStatsOrBuilder>(
                getExplainStats(), getParentForChildren(), isClean());
        explainStats_ = null;
      }
      return explainStatsBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.ExecutePipelineResponse)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.ExecutePipelineResponse)
  private static final com.google.firestore.v1.ExecutePipelineResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.ExecutePipelineResponse();
  }

  public static com.google.firestore.v1.ExecutePipelineResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecutePipelineResponse> PARSER =
      new com.google.protobuf.AbstractParser<ExecutePipelineResponse>() {
        @java.lang.Override
        public ExecutePipelineResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecutePipelineResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecutePipelineResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.ExecutePipelineResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
