/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/v1/firestore.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [Firestore.ListDocuments][google.firestore.v1.Firestore.ListDocuments].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.ListDocumentsRequest}
 */
@com.google.protobuf.Generated
public final class ListDocumentsRequest extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.ListDocumentsRequest)
    ListDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "ListDocumentsRequest");
  }

  // Use ListDocumentsRequest.newBuilder() to construct.
  private ListDocumentsRequest(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private ListDocumentsRequest() {
    parent_ = "";
    collectionId_ = "";
    pageToken_ = "";
    orderBy_ = "";
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ListDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ListDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.ListDocumentsRequest.class,
            com.google.firestore.v1.ListDocumentsRequest.Builder.class);
  }

  private int bitField0_;
  private int consistencySelectorCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object consistencySelector_;

  public enum ConsistencySelectorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSACTION(8),
    READ_TIME(10),
    CONSISTENCYSELECTOR_NOT_SET(0);
    private final int value;

    private ConsistencySelectorCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConsistencySelectorCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConsistencySelectorCase forNumber(int value) {
      switch (value) {
        case 8:
          return TRANSACTION;
        case 10:
          return READ_TIME;
        case 0:
          return CONSISTENCYSELECTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConsistencySelectorCase getConsistencySelectorCase() {
    return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   *
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   *
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLLECTION_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object collectionId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The collection ID, relative to `parent`, to list.
   *
   * For example: `chatrooms` or `messages`.
   *
   * This is optional, and when not provided, Firestore will list documents
   * from all collections under the provided `parent`.
   * </pre>
   *
   * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The collectionId.
   */
  @java.lang.Override
  public java.lang.String getCollectionId() {
    java.lang.Object ref = collectionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      collectionId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The collection ID, relative to `parent`, to list.
   *
   * For example: `chatrooms` or `messages`.
   *
   * This is optional, and when not provided, Firestore will list documents
   * from all collections under the provided `parent`.
   * </pre>
   *
   * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for collectionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCollectionIdBytes() {
    java.lang.Object ref = collectionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      collectionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of documents to return in a single response.
   *
   * Firestore may return fewer than this value.
   * </pre>
   *
   * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous `ListDocuments` response.
   *
   * Provide this to retrieve the subsequent page. When paginating, all other
   * parameters (with the exception of `page_size`) must match the values set
   * in the request that generated the page token.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous `ListDocuments` response.
   *
   * Provide this to retrieve the subsequent page. When paginating, all other
   * parameters (with the exception of `page_size`) must match the values set
   * in the request that generated the page token.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The optional ordering of the documents to return.
   *
   * For example: `priority desc, __name__ desc`.
   *
   * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
   * used in Firestore queries but in a string representation. When absent,
   * documents are ordered based on `__name__ ASC`.
   * </pre>
   *
   * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The optional ordering of the documents to return.
   *
   * For example: `priority desc, __name__ desc`.
   *
   * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
   * used in Firestore queries but in a string representation. When absent,
   * documents are ordered based on `__name__ ASC`.
   * </pre>
   *
   * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MASK_FIELD_NUMBER = 7;
  private com.google.firestore.v1.DocumentMask mask_;

  /**
   *
   *
   * <pre>
   * Optional. The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the mask field is set.
   */
  @java.lang.Override
  public boolean hasMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The mask.
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMask getMask() {
    return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMaskOrBuilder getMaskOrBuilder() {
    return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
  }

  public static final int TRANSACTION_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * Perform the read as part of an already active transaction.
   * </pre>
   *
   * <code>bytes transaction = 8;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return consistencySelectorCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * Perform the read as part of an already active transaction.
   * </pre>
   *
   * <code>bytes transaction = 8;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    if (consistencySelectorCase_ == 8) {
      return (com.google.protobuf.ByteString) consistencySelector_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int READ_TIME_FIELD_NUMBER = 10;

  /**
   *
   *
   * <pre>
   * Perform the read at the provided time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 10;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return consistencySelectorCase_ == 10;
  }

  /**
   *
   *
   * <pre>
   * Perform the read at the provided time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 10;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    if (consistencySelectorCase_ == 10) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Perform the read at the provided time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    if (consistencySelectorCase_ == 10) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int SHOW_MISSING_FIELD_NUMBER = 12;
  private boolean showMissing_ = false;

  /**
   *
   *
   * <pre>
   * If the list should show missing documents.
   *
   * A document is missing if it does not exist, but there are sub-documents
   * nested underneath it. When true, such missing documents will be returned
   * with a key but will not have fields,
   * [`create_time`][google.firestore.v1.Document.create_time], or
   * [`update_time`][google.firestore.v1.Document.update_time] set.
   *
   * Requests with `show_missing` may not specify `where` or `order_by`.
   * </pre>
   *
   * <code>bool show_missing = 12;</code>
   *
   * @return The showMissing.
   */
  @java.lang.Override
  public boolean getShowMissing() {
    return showMissing_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(collectionId_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, collectionId_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 6, orderBy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getMask());
    }
    if (consistencySelectorCase_ == 8) {
      output.writeBytes(8, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 10) {
      output.writeMessage(10, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    if (showMissing_ != false) {
      output.writeBool(12, showMissing_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(collectionId_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, collectionId_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(6, orderBy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getMask());
    }
    if (consistencySelectorCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              8, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    if (showMissing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, showMissing_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.ListDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.ListDocumentsRequest other =
        (com.google.firestore.v1.ListDocumentsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getCollectionId().equals(other.getCollectionId())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (hasMask() != other.hasMask()) return false;
    if (hasMask()) {
      if (!getMask().equals(other.getMask())) return false;
    }
    if (getShowMissing() != other.getShowMissing()) return false;
    if (!getConsistencySelectorCase().equals(other.getConsistencySelectorCase())) return false;
    switch (consistencySelectorCase_) {
      case 8:
        if (!getTransaction().equals(other.getTransaction())) return false;
        break;
      case 10:
        if (!getReadTime().equals(other.getReadTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + COLLECTION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCollectionId().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    if (hasMask()) {
      hash = (37 * hash) + MASK_FIELD_NUMBER;
      hash = (53 * hash) + getMask().hashCode();
    }
    hash = (37 * hash) + SHOW_MISSING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getShowMissing());
    switch (consistencySelectorCase_) {
      case 8:
        hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTransaction().hashCode();
        break;
      case 10:
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.ListDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for
   * [Firestore.ListDocuments][google.firestore.v1.Firestore.ListDocuments].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.ListDocumentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.ListDocumentsRequest)
      com.google.firestore.v1.ListDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.ListDocumentsRequest.class,
              com.google.firestore.v1.ListDocumentsRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.ListDocumentsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      collectionId_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      orderBy_ = "";
      mask_ = null;
      if (maskBuilder_ != null) {
        maskBuilder_.dispose();
        maskBuilder_ = null;
      }
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.clear();
      }
      showMissing_ = false;
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.ListDocumentsRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.ListDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.ListDocumentsRequest build() {
      com.google.firestore.v1.ListDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.ListDocumentsRequest buildPartial() {
      com.google.firestore.v1.ListDocumentsRequest result =
          new com.google.firestore.v1.ListDocumentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.ListDocumentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.collectionId_ = collectionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.orderBy_ = orderBy_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.mask_ = maskBuilder_ == null ? mask_ : maskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.showMissing_ = showMissing_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.v1.ListDocumentsRequest result) {
      result.consistencySelectorCase_ = consistencySelectorCase_;
      result.consistencySelector_ = this.consistencySelector_;
      if (consistencySelectorCase_ == 10 && readTimeBuilder_ != null) {
        result.consistencySelector_ = readTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.ListDocumentsRequest) {
        return mergeFrom((com.google.firestore.v1.ListDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.ListDocumentsRequest other) {
      if (other == com.google.firestore.v1.ListDocumentsRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCollectionId().isEmpty()) {
        collectionId_ = other.collectionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasMask()) {
        mergeMask(other.getMask());
      }
      if (other.getShowMissing() != false) {
        setShowMissing(other.getShowMissing());
      }
      switch (other.getConsistencySelectorCase()) {
        case TRANSACTION:
          {
            setTransaction(other.getTransaction());
            break;
          }
        case READ_TIME:
          {
            mergeReadTime(other.getReadTime());
            break;
          }
        case CONSISTENCYSELECTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                collectionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(internalGetMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                consistencySelector_ = input.readBytes();
                consistencySelectorCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(
                    internalGetReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                consistencySelectorCase_ = 10;
                break;
              } // case 82
            case 96:
              {
                showMissing_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int consistencySelectorCase_ = 0;
    private java.lang.Object consistencySelector_;

    public ConsistencySelectorCase getConsistencySelectorCase() {
      return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
    }

    public Builder clearConsistencySelector() {
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object collectionId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The collection ID, relative to `parent`, to list.
     *
     * For example: `chatrooms` or `messages`.
     *
     * This is optional, and when not provided, Firestore will list documents
     * from all collections under the provided `parent`.
     * </pre>
     *
     * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The collectionId.
     */
    public java.lang.String getCollectionId() {
      java.lang.Object ref = collectionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        collectionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The collection ID, relative to `parent`, to list.
     *
     * For example: `chatrooms` or `messages`.
     *
     * This is optional, and when not provided, Firestore will list documents
     * from all collections under the provided `parent`.
     * </pre>
     *
     * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for collectionId.
     */
    public com.google.protobuf.ByteString getCollectionIdBytes() {
      java.lang.Object ref = collectionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        collectionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The collection ID, relative to `parent`, to list.
     *
     * For example: `chatrooms` or `messages`.
     *
     * This is optional, and when not provided, Firestore will list documents
     * from all collections under the provided `parent`.
     * </pre>
     *
     * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The collectionId to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      collectionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The collection ID, relative to `parent`, to list.
     *
     * For example: `chatrooms` or `messages`.
     *
     * This is optional, and when not provided, Firestore will list documents
     * from all collections under the provided `parent`.
     * </pre>
     *
     * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollectionId() {
      collectionId_ = getDefaultInstance().getCollectionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The collection ID, relative to `parent`, to list.
     *
     * For example: `chatrooms` or `messages`.
     *
     * This is optional, and when not provided, Firestore will list documents
     * from all collections under the provided `parent`.
     * </pre>
     *
     * <code>string collection_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for collectionId to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      collectionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of documents to return in a single response.
     *
     * Firestore may return fewer than this value.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of documents to return in a single response.
     *
     * Firestore may return fewer than this value.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of documents to return in a single response.
     *
     * Firestore may return fewer than this value.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `ListDocuments` response.
     *
     * Provide this to retrieve the subsequent page. When paginating, all other
     * parameters (with the exception of `page_size`) must match the values set
     * in the request that generated the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `ListDocuments` response.
     *
     * Provide this to retrieve the subsequent page. When paginating, all other
     * parameters (with the exception of `page_size`) must match the values set
     * in the request that generated the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `ListDocuments` response.
     *
     * Provide this to retrieve the subsequent page. When paginating, all other
     * parameters (with the exception of `page_size`) must match the values set
     * in the request that generated the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `ListDocuments` response.
     *
     * Provide this to retrieve the subsequent page. When paginating, all other
     * parameters (with the exception of `page_size`) must match the values set
     * in the request that generated the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `ListDocuments` response.
     *
     * Provide this to retrieve the subsequent page. When paginating, all other
     * parameters (with the exception of `page_size`) must match the values set
     * in the request that generated the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The optional ordering of the documents to return.
     *
     * For example: `priority desc, __name__ desc`.
     *
     * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
     * used in Firestore queries but in a string representation. When absent,
     * documents are ordered based on `__name__ ASC`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The optional ordering of the documents to return.
     *
     * For example: `priority desc, __name__ desc`.
     *
     * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
     * used in Firestore queries but in a string representation. When absent,
     * documents are ordered based on `__name__ ASC`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The optional ordering of the documents to return.
     *
     * For example: `priority desc, __name__ desc`.
     *
     * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
     * used in Firestore queries but in a string representation. When absent,
     * documents are ordered based on `__name__ ASC`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The optional ordering of the documents to return.
     *
     * For example: `priority desc, __name__ desc`.
     *
     * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
     * used in Firestore queries but in a string representation. When absent,
     * documents are ordered based on `__name__ ASC`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The optional ordering of the documents to return.
     *
     * For example: `priority desc, __name__ desc`.
     *
     * This mirrors the [`ORDER BY`][google.firestore.v1.StructuredQuery.order_by]
     * used in Firestore queries but in a string representation. When absent,
     * documents are ordered based on `__name__ ASC`.
     * </pre>
     *
     * <code>string order_by = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.firestore.v1.DocumentMask mask_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        maskBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the mask field is set.
     */
    public boolean hasMask() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The mask.
     */
    public com.google.firestore.v1.DocumentMask getMask() {
      if (maskBuilder_ == null) {
        return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
      } else {
        return maskBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMask(com.google.firestore.v1.DocumentMask value) {
      if (maskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mask_ = value;
      } else {
        maskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMask(com.google.firestore.v1.DocumentMask.Builder builderForValue) {
      if (maskBuilder_ == null) {
        mask_ = builderForValue.build();
      } else {
        maskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMask(com.google.firestore.v1.DocumentMask value) {
      if (maskBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && mask_ != null
            && mask_ != com.google.firestore.v1.DocumentMask.getDefaultInstance()) {
          getMaskBuilder().mergeFrom(value);
        } else {
          mask_ = value;
        }
      } else {
        maskBuilder_.mergeFrom(value);
      }
      if (mask_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMask() {
      bitField0_ = (bitField0_ & ~0x00000020);
      mask_ = null;
      if (maskBuilder_ != null) {
        maskBuilder_.dispose();
        maskBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.DocumentMask.Builder getMaskBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return internalGetMaskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.DocumentMaskOrBuilder getMaskOrBuilder() {
      if (maskBuilder_ != null) {
        return maskBuilder_.getMessageOrBuilder();
      } else {
        return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        internalGetMaskFieldBuilder() {
      if (maskBuilder_ == null) {
        maskBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.v1.DocumentMask,
                com.google.firestore.v1.DocumentMask.Builder,
                com.google.firestore.v1.DocumentMaskOrBuilder>(
                getMask(), getParentForChildren(), isClean());
        mask_ = null;
      }
      return maskBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Perform the read as part of an already active transaction.
     * </pre>
     *
     * <code>bytes transaction = 8;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return consistencySelectorCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * Perform the read as part of an already active transaction.
     * </pre>
     *
     * <code>bytes transaction = 8;</code>
     *
     * @return The transaction.
     */
    public com.google.protobuf.ByteString getTransaction() {
      if (consistencySelectorCase_ == 8) {
        return (com.google.protobuf.ByteString) consistencySelector_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    /**
     *
     *
     * <pre>
     * Perform the read as part of an already active transaction.
     * </pre>
     *
     * <code>bytes transaction = 8;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencySelectorCase_ = 8;
      consistencySelector_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Perform the read as part of an already active transaction.
     * </pre>
     *
     * <code>bytes transaction = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      if (consistencySelectorCase_ == 8) {
        consistencySelectorCase_ = 0;
        consistencySelector_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return consistencySelectorCase_ == 10;
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 10) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 10) {
          return readTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 10
            && consistencySelector_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          consistencySelector_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 10) {
          readTimeBuilder_.mergeFrom(value);
        } else {
          readTimeBuilder_.setMessage(value);
        }
      }
      consistencySelectorCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 10) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 10) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        readTimeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      return internalGetReadTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if ((consistencySelectorCase_ == 10) && (readTimeBuilder_ != null)) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 10) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Perform the read at the provided time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        internalGetReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        if (!(consistencySelectorCase_ == 10)) {
          consistencySelector_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 10;
      onChanged();
      return readTimeBuilder_;
    }

    private boolean showMissing_;

    /**
     *
     *
     * <pre>
     * If the list should show missing documents.
     *
     * A document is missing if it does not exist, but there are sub-documents
     * nested underneath it. When true, such missing documents will be returned
     * with a key but will not have fields,
     * [`create_time`][google.firestore.v1.Document.create_time], or
     * [`update_time`][google.firestore.v1.Document.update_time] set.
     *
     * Requests with `show_missing` may not specify `where` or `order_by`.
     * </pre>
     *
     * <code>bool show_missing = 12;</code>
     *
     * @return The showMissing.
     */
    @java.lang.Override
    public boolean getShowMissing() {
      return showMissing_;
    }

    /**
     *
     *
     * <pre>
     * If the list should show missing documents.
     *
     * A document is missing if it does not exist, but there are sub-documents
     * nested underneath it. When true, such missing documents will be returned
     * with a key but will not have fields,
     * [`create_time`][google.firestore.v1.Document.create_time], or
     * [`update_time`][google.firestore.v1.Document.update_time] set.
     *
     * Requests with `show_missing` may not specify `where` or `order_by`.
     * </pre>
     *
     * <code>bool show_missing = 12;</code>
     *
     * @param value The showMissing to set.
     * @return This builder for chaining.
     */
    public Builder setShowMissing(boolean value) {

      showMissing_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If the list should show missing documents.
     *
     * A document is missing if it does not exist, but there are sub-documents
     * nested underneath it. When true, such missing documents will be returned
     * with a key but will not have fields,
     * [`create_time`][google.firestore.v1.Document.create_time], or
     * [`update_time`][google.firestore.v1.Document.update_time] set.
     *
     * Requests with `show_missing` may not specify `where` or `order_by`.
     * </pre>
     *
     * <code>bool show_missing = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShowMissing() {
      bitField0_ = (bitField0_ & ~0x00000100);
      showMissing_ = false;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.ListDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.ListDocumentsRequest)
  private static final com.google.firestore.v1.ListDocumentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.ListDocumentsRequest();
  }

  public static com.google.firestore.v1.ListDocumentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListDocumentsRequest>() {
        @java.lang.Override
        public ListDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.ListDocumentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
