/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/v1/document.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * A Firestore query represented as an ordered list of operations / stages.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.Pipeline}
 */
@com.google.protobuf.Generated
public final class Pipeline extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.Pipeline)
    PipelineOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "Pipeline");
  }

  // Use Pipeline.newBuilder() to construct.
  private Pipeline(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private Pipeline() {
    stages_ = java.util.Collections.emptyList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.DocumentProto
        .internal_static_google_firestore_v1_Pipeline_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.DocumentProto
        .internal_static_google_firestore_v1_Pipeline_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.Pipeline.class, com.google.firestore.v1.Pipeline.Builder.class);
  }

  public interface StageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1.Pipeline.Stage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the stage to evaluate.
     *
     * **Requires:**
     *
     * * must be in snake case (lower case with underscore separator).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Required. The name of the stage to evaluate.
     *
     * **Requires:**
     *
     * * must be in snake case (lower case with underscore separator).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.firestore.v1.Value> getArgsList();

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.firestore.v1.Value getArgs(int index);

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getArgsCount();

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.firestore.v1.ValueOrBuilder> getArgsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.firestore.v1.ValueOrBuilder getArgsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getOptionsCount();

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsOptions(java.lang.String key);

    /** Use {@link #getOptionsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptions();

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptionsMap();

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    com.google.firestore.v1.Value getOptionsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.firestore.v1.Value defaultValue);

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.firestore.v1.Value getOptionsOrThrow(java.lang.String key);
  }

  /**
   *
   *
   * <pre>
   * A single operation within a pipeline.
   *
   * A stage is made up of a unique name, and a list of arguments. The exact
   * number of arguments &amp; types is dependent on the stage type.
   *
   * To give an example, the stage `filter(state = "MD")` would be encoded as:
   *
   * ```
   * name: "filter"
   * args {
   * function_value {
   * name: "eq"
   * args { field_reference_value: "state" }
   * args { string_value: "MD" }
   * }
   * }
   * ```
   *
   * See public documentation for the full list.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.Pipeline.Stage}
   */
  public static final class Stage extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1.Pipeline.Stage)
      StageOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Stage");
    }

    // Use Stage.newBuilder() to construct.
    private Stage(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Stage() {
      name_ = "";
      args_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Pipeline_Stage_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetOptions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Pipeline_Stage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.Pipeline.Stage.class,
              com.google.firestore.v1.Pipeline.Stage.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the stage to evaluate.
     *
     * **Requires:**
     *
     * * must be in snake case (lower case with underscore separator).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the stage to evaluate.
     *
     * **Requires:**
     *
     * * must be in snake case (lower case with underscore separator).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ARGS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.firestore.v1.Value> args_;

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.firestore.v1.Value> getArgsList() {
      return args_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.firestore.v1.ValueOrBuilder> getArgsOrBuilderList() {
      return args_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getArgsCount() {
      return args_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.v1.Value getArgs(int index) {
      return args_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Ordered list of arguments the given stage expects.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.v1.ValueOrBuilder getArgsOrBuilder(int index) {
      return args_.get(index);
    }

    public static final int OPTIONS_FIELD_NUMBER = 3;

    private static final class OptionsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.firestore.v1.Value>newDefaultInstance(
                      com.google.firestore.v1.DocumentProto
                          .internal_static_google_firestore_v1_Pipeline_Stage_OptionsEntry_descriptor,
                      com.google.protobuf.WireFormat.FieldType.STRING,
                      "",
                      com.google.protobuf.WireFormat.FieldType.MESSAGE,
                      com.google.firestore.v1.Value.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, com.google.firestore.v1.Value> options_;

    private com.google.protobuf.MapField<java.lang.String, com.google.firestore.v1.Value>
        internalGetOptions() {
      if (options_ == null) {
        return com.google.protobuf.MapField.emptyMapField(OptionsDefaultEntryHolder.defaultEntry);
      }
      return options_;
    }

    public int getOptionsCount() {
      return internalGetOptions().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsOptions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetOptions().getMap().containsKey(key);
    }

    /** Use {@link #getOptionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptions() {
      return getOptionsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptionsMap() {
      return internalGetOptions().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.firestore.v1.Value getOptionsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.firestore.v1.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.firestore.v1.Value> map =
          internalGetOptions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional named arguments that certain functions may support.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.v1.Value getOptionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.firestore.v1.Value> map =
          internalGetOptions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(2, args_.get(i));
      }
      com.google.protobuf.GeneratedMessage.serializeStringMapTo(
          output, internalGetOptions(), OptionsDefaultEntryHolder.defaultEntry, 3);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, args_.get(i));
      }
      for (java.util.Map.Entry<java.lang.String, com.google.firestore.v1.Value> entry :
          internalGetOptions().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value> options__ =
            OptionsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, options__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1.Pipeline.Stage)) {
        return super.equals(obj);
      }
      com.google.firestore.v1.Pipeline.Stage other = (com.google.firestore.v1.Pipeline.Stage) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getArgsList().equals(other.getArgsList())) return false;
      if (!internalGetOptions().equals(other.internalGetOptions())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getArgsCount() > 0) {
        hash = (37 * hash) + ARGS_FIELD_NUMBER;
        hash = (53 * hash) + getArgsList().hashCode();
      }
      if (!internalGetOptions().getMap().isEmpty()) {
        hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetOptions().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Pipeline.Stage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.v1.Pipeline.Stage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A single operation within a pipeline.
     *
     * A stage is made up of a unique name, and a list of arguments. The exact
     * number of arguments &amp; types is dependent on the stage type.
     *
     * To give an example, the stage `filter(state = "MD")` would be encoded as:
     *
     * ```
     * name: "filter"
     * args {
     * function_value {
     * name: "eq"
     * args { field_reference_value: "state" }
     * args { string_value: "MD" }
     * }
     * }
     * ```
     *
     * See public documentation for the full list.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1.Pipeline.Stage}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1.Pipeline.Stage)
        com.google.firestore.v1.Pipeline.StageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1.DocumentProto
            .internal_static_google_firestore_v1_Pipeline_Stage_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetOptions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetMutableOptions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1.DocumentProto
            .internal_static_google_firestore_v1_Pipeline_Stage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1.Pipeline.Stage.class,
                com.google.firestore.v1.Pipeline.Stage.Builder.class);
      }

      // Construct using com.google.firestore.v1.Pipeline.Stage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
        } else {
          args_ = null;
          argsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableOptions().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1.DocumentProto
            .internal_static_google_firestore_v1_Pipeline_Stage_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1.Pipeline.Stage getDefaultInstanceForType() {
        return com.google.firestore.v1.Pipeline.Stage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1.Pipeline.Stage build() {
        com.google.firestore.v1.Pipeline.Stage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1.Pipeline.Stage buildPartial() {
        com.google.firestore.v1.Pipeline.Stage result =
            new com.google.firestore.v1.Pipeline.Stage(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.firestore.v1.Pipeline.Stage result) {
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.firestore.v1.Pipeline.Stage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.options_ = internalGetOptions().build(OptionsDefaultEntryHolder.defaultEntry);
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1.Pipeline.Stage) {
          return mergeFrom((com.google.firestore.v1.Pipeline.Stage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1.Pipeline.Stage other) {
        if (other == com.google.firestore.v1.Pipeline.Stage.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000002);
              argsBuilder_ =
                  com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                      ? internalGetArgsFieldBuilder()
                      : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        internalGetMutableOptions().mergeFrom(other.internalGetOptions());
        bitField0_ |= 0x00000004;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.firestore.v1.Value m =
                      input.readMessage(com.google.firestore.v1.Value.parser(), extensionRegistry);
                  if (argsBuilder_ == null) {
                    ensureArgsIsMutable();
                    args_.add(m);
                  } else {
                    argsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
                      options__ =
                          input.readMessage(
                              OptionsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableOptions()
                      .ensureBuilderMap()
                      .put(options__.getKey(), options__.getValue());
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the stage to evaluate.
       *
       * **Requires:**
       *
       * * must be in snake case (lower case with underscore separator).
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the stage to evaluate.
       *
       * **Requires:**
       *
       * * must be in snake case (lower case with underscore separator).
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the stage to evaluate.
       *
       * **Requires:**
       *
       * * must be in snake case (lower case with underscore separator).
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the stage to evaluate.
       *
       * **Requires:**
       *
       * * must be in snake case (lower case with underscore separator).
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the stage to evaluate.
       *
       * **Requires:**
       *
       * * must be in snake case (lower case with underscore separator).
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.firestore.v1.Value> args_ =
          java.util.Collections.emptyList();

      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          args_ = new java.util.ArrayList<com.google.firestore.v1.Value>(args_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
              com.google.firestore.v1.Value,
              com.google.firestore.v1.Value.Builder,
              com.google.firestore.v1.ValueOrBuilder>
          argsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.firestore.v1.Value> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.firestore.v1.Value getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setArgs(int index, com.google.firestore.v1.Value value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setArgs(int index, com.google.firestore.v1.Value.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArgs(com.google.firestore.v1.Value value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArgs(int index, com.google.firestore.v1.Value value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArgs(com.google.firestore.v1.Value.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addArgs(int index, com.google.firestore.v1.Value.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.google.firestore.v1.Value> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.firestore.v1.Value.Builder getArgsBuilder(int index) {
        return internalGetArgsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.firestore.v1.ValueOrBuilder getArgsOrBuilder(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.firestore.v1.ValueOrBuilder>
          getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.firestore.v1.Value.Builder addArgsBuilder() {
        return internalGetArgsFieldBuilder()
            .addBuilder(com.google.firestore.v1.Value.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.firestore.v1.Value.Builder addArgsBuilder(int index) {
        return internalGetArgsFieldBuilder()
            .addBuilder(index, com.google.firestore.v1.Value.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Ordered list of arguments the given stage expects.
       * </pre>
       *
       * <code>
       * repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.firestore.v1.Value.Builder> getArgsBuilderList() {
        return internalGetArgsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilder<
              com.google.firestore.v1.Value,
              com.google.firestore.v1.Value.Builder,
              com.google.firestore.v1.ValueOrBuilder>
          internalGetArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilder<
                  com.google.firestore.v1.Value,
                  com.google.firestore.v1.Value.Builder,
                  com.google.firestore.v1.ValueOrBuilder>(
                  args_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private static final class OptionsConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.firestore.v1.ValueOrBuilder,
              com.google.firestore.v1.Value> {
        @java.lang.Override
        public com.google.firestore.v1.Value build(com.google.firestore.v1.ValueOrBuilder val) {
          if (val instanceof com.google.firestore.v1.Value) {
            return (com.google.firestore.v1.Value) val;
          }
          return ((com.google.firestore.v1.Value.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
            defaultEntry() {
          return OptionsDefaultEntryHolder.defaultEntry;
        }
      }
      ;

      private static final OptionsConverter optionsConverter = new OptionsConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.firestore.v1.ValueOrBuilder,
              com.google.firestore.v1.Value,
              com.google.firestore.v1.Value.Builder>
          options_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.firestore.v1.ValueOrBuilder,
              com.google.firestore.v1.Value,
              com.google.firestore.v1.Value.Builder>
          internalGetOptions() {
        if (options_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(optionsConverter);
        }
        return options_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.firestore.v1.ValueOrBuilder,
              com.google.firestore.v1.Value,
              com.google.firestore.v1.Value.Builder>
          internalGetMutableOptions() {
        if (options_ == null) {
          options_ = new com.google.protobuf.MapFieldBuilder<>(optionsConverter);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return options_;
      }

      public int getOptionsCount() {
        return internalGetOptions().ensureBuilderMap().size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsOptions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetOptions().ensureBuilderMap().containsKey(key);
      }

      /** Use {@link #getOptionsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptions() {
        return getOptionsMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptionsMap() {
        return internalGetOptions().getImmutableMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.firestore.v1.Value getOptionsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.firestore.v1.Value defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> map =
            internalGetMutableOptions().ensureBuilderMap();
        return map.containsKey(key) ? optionsConverter.build(map.get(key)) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.firestore.v1.Value getOptionsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> map =
            internalGetMutableOptions().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return optionsConverter.build(map.get(key));
      }

      public Builder clearOptions() {
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableOptions().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeOptions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableOptions().ensureBuilderMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getMutableOptions() {
        bitField0_ |= 0x00000004;
        return internalGetMutableOptions().ensureMessageMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putOptions(java.lang.String key, com.google.firestore.v1.Value value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableOptions().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000004;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllOptions(
          java.util.Map<java.lang.String, com.google.firestore.v1.Value> values) {
        for (java.util.Map.Entry<java.lang.String, com.google.firestore.v1.Value> e :
            values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableOptions().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000004;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Optional named arguments that certain functions may support.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.firestore.v1.Value&gt; options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.firestore.v1.Value.Builder putOptionsBuilderIfAbsent(java.lang.String key) {
        java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> builderMap =
            internalGetMutableOptions().ensureBuilderMap();
        com.google.firestore.v1.ValueOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.firestore.v1.Value.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.firestore.v1.Value) {
          entry = ((com.google.firestore.v1.Value) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.firestore.v1.Value.Builder) entry;
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1.Pipeline.Stage)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1.Pipeline.Stage)
    private static final com.google.firestore.v1.Pipeline.Stage DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1.Pipeline.Stage();
    }

    public static com.google.firestore.v1.Pipeline.Stage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Stage> PARSER =
        new com.google.protobuf.AbstractParser<Stage>() {
          @java.lang.Override
          public Stage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Stage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Stage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1.Pipeline.Stage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int STAGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.firestore.v1.Pipeline.Stage> stages_;

  /**
   *
   *
   * <pre>
   * Required. Ordered list of stages to evaluate.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.v1.Pipeline.Stage> getStagesList() {
    return stages_;
  }

  /**
   *
   *
   * <pre>
   * Required. Ordered list of stages to evaluate.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.firestore.v1.Pipeline.StageOrBuilder>
      getStagesOrBuilderList() {
    return stages_;
  }

  /**
   *
   *
   * <pre>
   * Required. Ordered list of stages to evaluate.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getStagesCount() {
    return stages_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. Ordered list of stages to evaluate.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Pipeline.Stage getStages(int index) {
    return stages_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. Ordered list of stages to evaluate.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Pipeline.StageOrBuilder getStagesOrBuilder(int index) {
    return stages_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < stages_.size(); i++) {
      output.writeMessage(1, stages_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < stages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, stages_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.Pipeline)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.Pipeline other = (com.google.firestore.v1.Pipeline) obj;

    if (!getStagesList().equals(other.getStagesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getStagesCount() > 0) {
      hash = (37 * hash) + STAGES_FIELD_NUMBER;
      hash = (53 * hash) + getStagesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.Pipeline parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Pipeline parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Pipeline parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Pipeline parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.Pipeline prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A Firestore query represented as an ordered list of operations / stages.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.Pipeline}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.Pipeline)
      com.google.firestore.v1.PipelineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Pipeline_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Pipeline_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.Pipeline.class,
              com.google.firestore.v1.Pipeline.Builder.class);
    }

    // Construct using com.google.firestore.v1.Pipeline.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (stagesBuilder_ == null) {
        stages_ = java.util.Collections.emptyList();
      } else {
        stages_ = null;
        stagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Pipeline_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.Pipeline getDefaultInstanceForType() {
      return com.google.firestore.v1.Pipeline.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.Pipeline build() {
      com.google.firestore.v1.Pipeline result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.Pipeline buildPartial() {
      com.google.firestore.v1.Pipeline result = new com.google.firestore.v1.Pipeline(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.firestore.v1.Pipeline result) {
      if (stagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          stages_ = java.util.Collections.unmodifiableList(stages_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.stages_ = stages_;
      } else {
        result.stages_ = stagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.firestore.v1.Pipeline result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.Pipeline) {
        return mergeFrom((com.google.firestore.v1.Pipeline) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.Pipeline other) {
      if (other == com.google.firestore.v1.Pipeline.getDefaultInstance()) return this;
      if (stagesBuilder_ == null) {
        if (!other.stages_.isEmpty()) {
          if (stages_.isEmpty()) {
            stages_ = other.stages_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureStagesIsMutable();
            stages_.addAll(other.stages_);
          }
          onChanged();
        }
      } else {
        if (!other.stages_.isEmpty()) {
          if (stagesBuilder_.isEmpty()) {
            stagesBuilder_.dispose();
            stagesBuilder_ = null;
            stages_ = other.stages_;
            bitField0_ = (bitField0_ & ~0x00000001);
            stagesBuilder_ =
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                    ? internalGetStagesFieldBuilder()
                    : null;
          } else {
            stagesBuilder_.addAllMessages(other.stages_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.firestore.v1.Pipeline.Stage m =
                    input.readMessage(
                        com.google.firestore.v1.Pipeline.Stage.parser(), extensionRegistry);
                if (stagesBuilder_ == null) {
                  ensureStagesIsMutable();
                  stages_.add(m);
                } else {
                  stagesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.firestore.v1.Pipeline.Stage> stages_ =
        java.util.Collections.emptyList();

    private void ensureStagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        stages_ = new java.util.ArrayList<com.google.firestore.v1.Pipeline.Stage>(stages_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.firestore.v1.Pipeline.Stage,
            com.google.firestore.v1.Pipeline.Stage.Builder,
            com.google.firestore.v1.Pipeline.StageOrBuilder>
        stagesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.firestore.v1.Pipeline.Stage> getStagesList() {
      if (stagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stages_);
      } else {
        return stagesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getStagesCount() {
      if (stagesBuilder_ == null) {
        return stages_.size();
      } else {
        return stagesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.Pipeline.Stage getStages(int index) {
      if (stagesBuilder_ == null) {
        return stages_.get(index);
      } else {
        return stagesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStages(int index, com.google.firestore.v1.Pipeline.Stage value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.set(index, value);
        onChanged();
      } else {
        stagesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStages(
        int index, com.google.firestore.v1.Pipeline.Stage.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.set(index, builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addStages(com.google.firestore.v1.Pipeline.Stage value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.add(value);
        onChanged();
      } else {
        stagesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addStages(int index, com.google.firestore.v1.Pipeline.Stage value) {
      if (stagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStagesIsMutable();
        stages_.add(index, value);
        onChanged();
      } else {
        stagesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addStages(com.google.firestore.v1.Pipeline.Stage.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.add(builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addStages(
        int index, com.google.firestore.v1.Pipeline.Stage.Builder builderForValue) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.add(index, builderForValue.build());
        onChanged();
      } else {
        stagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllStages(
        java.lang.Iterable<? extends com.google.firestore.v1.Pipeline.Stage> values) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stages_);
        onChanged();
      } else {
        stagesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearStages() {
      if (stagesBuilder_ == null) {
        stages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        stagesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeStages(int index) {
      if (stagesBuilder_ == null) {
        ensureStagesIsMutable();
        stages_.remove(index);
        onChanged();
      } else {
        stagesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.Pipeline.Stage.Builder getStagesBuilder(int index) {
      return internalGetStagesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.Pipeline.StageOrBuilder getStagesOrBuilder(int index) {
      if (stagesBuilder_ == null) {
        return stages_.get(index);
      } else {
        return stagesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.firestore.v1.Pipeline.StageOrBuilder>
        getStagesOrBuilderList() {
      if (stagesBuilder_ != null) {
        return stagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stages_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.Pipeline.Stage.Builder addStagesBuilder() {
      return internalGetStagesFieldBuilder()
          .addBuilder(com.google.firestore.v1.Pipeline.Stage.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.Pipeline.Stage.Builder addStagesBuilder(int index) {
      return internalGetStagesFieldBuilder()
          .addBuilder(index, com.google.firestore.v1.Pipeline.Stage.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. Ordered list of stages to evaluate.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.Pipeline.Stage stages = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.firestore.v1.Pipeline.Stage.Builder> getStagesBuilderList() {
      return internalGetStagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.firestore.v1.Pipeline.Stage,
            com.google.firestore.v1.Pipeline.Stage.Builder,
            com.google.firestore.v1.Pipeline.StageOrBuilder>
        internalGetStagesFieldBuilder() {
      if (stagesBuilder_ == null) {
        stagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilder<
                com.google.firestore.v1.Pipeline.Stage,
                com.google.firestore.v1.Pipeline.Stage.Builder,
                com.google.firestore.v1.Pipeline.StageOrBuilder>(
                stages_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        stages_ = null;
      }
      return stagesBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.Pipeline)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.Pipeline)
  private static final com.google.firestore.v1.Pipeline DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.Pipeline();
  }

  public static com.google.firestore.v1.Pipeline getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Pipeline> PARSER =
      new com.google.protobuf.AbstractParser<Pipeline>() {
        @java.lang.Override
        public Pipeline parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Pipeline> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Pipeline> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.Pipeline getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
