/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/firestore/v1/pipeline.proto
// Protobuf Java Version: 4.33.2

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * A Firestore query represented as an ordered list of operations / stages.
 *
 * This is considered the top-level function which plans and executes a query.
 * It is logically equivalent to `query(stages, options)`, but prevents the
 * client from having to build a function wrapper.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.StructuredPipeline}
 */
@com.google.protobuf.Generated
public final class StructuredPipeline extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.StructuredPipeline)
    StructuredPipelineOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "StructuredPipeline");
  }

  // Use StructuredPipeline.newBuilder() to construct.
  private StructuredPipeline(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private StructuredPipeline() {}

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.PipelineProto
        .internal_static_google_firestore_v1_StructuredPipeline_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetOptions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.PipelineProto
        .internal_static_google_firestore_v1_StructuredPipeline_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.StructuredPipeline.class,
            com.google.firestore.v1.StructuredPipeline.Builder.class);
  }

  private int bitField0_;
  public static final int PIPELINE_FIELD_NUMBER = 1;
  private com.google.firestore.v1.Pipeline pipeline_;

  /**
   *
   *
   * <pre>
   * Required. The pipeline query to execute.
   * </pre>
   *
   * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the pipeline field is set.
   */
  @java.lang.Override
  public boolean hasPipeline() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The pipeline query to execute.
   * </pre>
   *
   * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The pipeline.
   */
  @java.lang.Override
  public com.google.firestore.v1.Pipeline getPipeline() {
    return pipeline_ == null ? com.google.firestore.v1.Pipeline.getDefaultInstance() : pipeline_;
  }

  /**
   *
   *
   * <pre>
   * Required. The pipeline query to execute.
   * </pre>
   *
   * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.PipelineOrBuilder getPipelineOrBuilder() {
    return pipeline_ == null ? com.google.firestore.v1.Pipeline.getDefaultInstance() : pipeline_;
  }

  public static final int OPTIONS_FIELD_NUMBER = 2;

  private static final class OptionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.firestore.v1.Value>newDefaultInstance(
                    com.google.firestore.v1.PipelineProto
                        .internal_static_google_firestore_v1_StructuredPipeline_OptionsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.firestore.v1.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.firestore.v1.Value> options_;

  private com.google.protobuf.MapField<java.lang.String, com.google.firestore.v1.Value>
      internalGetOptions() {
    if (options_ == null) {
      return com.google.protobuf.MapField.emptyMapField(OptionsDefaultEntryHolder.defaultEntry);
    }
    return options_;
  }

  public int getOptionsCount() {
    return internalGetOptions().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional query-level arguments.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsOptions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetOptions().getMap().containsKey(key);
  }

  /** Use {@link #getOptionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptions() {
    return getOptionsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional query-level arguments.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptionsMap() {
    return internalGetOptions().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional query-level arguments.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.firestore.v1.Value getOptionsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.firestore.v1.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.firestore.v1.Value> map =
        internalGetOptions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional query-level arguments.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Value getOptionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.firestore.v1.Value> map =
        internalGetOptions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getPipeline());
    }
    com.google.protobuf.GeneratedMessage.serializeStringMapTo(
        output, internalGetOptions(), OptionsDefaultEntryHolder.defaultEntry, 2);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPipeline());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.firestore.v1.Value> entry :
        internalGetOptions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value> options__ =
          OptionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, options__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.StructuredPipeline)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.StructuredPipeline other =
        (com.google.firestore.v1.StructuredPipeline) obj;

    if (hasPipeline() != other.hasPipeline()) return false;
    if (hasPipeline()) {
      if (!getPipeline().equals(other.getPipeline())) return false;
    }
    if (!internalGetOptions().equals(other.internalGetOptions())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPipeline()) {
      hash = (37 * hash) + PIPELINE_FIELD_NUMBER;
      hash = (53 * hash) + getPipeline().hashCode();
    }
    if (!internalGetOptions().getMap().isEmpty()) {
      hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredPipeline parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.StructuredPipeline parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.StructuredPipeline parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.StructuredPipeline prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A Firestore query represented as an ordered list of operations / stages.
   *
   * This is considered the top-level function which plans and executes a query.
   * It is logically equivalent to `query(stages, options)`, but prevents the
   * client from having to build a function wrapper.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.StructuredPipeline}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.StructuredPipeline)
      com.google.firestore.v1.StructuredPipelineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.PipelineProto
          .internal_static_google_firestore_v1_StructuredPipeline_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetOptions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableOptions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.PipelineProto
          .internal_static_google_firestore_v1_StructuredPipeline_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.StructuredPipeline.class,
              com.google.firestore.v1.StructuredPipeline.Builder.class);
    }

    // Construct using com.google.firestore.v1.StructuredPipeline.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetPipelineFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      pipeline_ = null;
      if (pipelineBuilder_ != null) {
        pipelineBuilder_.dispose();
        pipelineBuilder_ = null;
      }
      internalGetMutableOptions().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.PipelineProto
          .internal_static_google_firestore_v1_StructuredPipeline_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.StructuredPipeline getDefaultInstanceForType() {
      return com.google.firestore.v1.StructuredPipeline.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.StructuredPipeline build() {
      com.google.firestore.v1.StructuredPipeline result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.StructuredPipeline buildPartial() {
      com.google.firestore.v1.StructuredPipeline result =
          new com.google.firestore.v1.StructuredPipeline(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.StructuredPipeline result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.pipeline_ = pipelineBuilder_ == null ? pipeline_ : pipelineBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.options_ = internalGetOptions().build(OptionsDefaultEntryHolder.defaultEntry);
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.StructuredPipeline) {
        return mergeFrom((com.google.firestore.v1.StructuredPipeline) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.StructuredPipeline other) {
      if (other == com.google.firestore.v1.StructuredPipeline.getDefaultInstance()) return this;
      if (other.hasPipeline()) {
        mergePipeline(other.getPipeline());
      }
      internalGetMutableOptions().mergeFrom(other.internalGetOptions());
      bitField0_ |= 0x00000002;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    internalGetPipelineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
                    options__ =
                        input.readMessage(
                            OptionsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableOptions()
                    .ensureBuilderMap()
                    .put(options__.getKey(), options__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.firestore.v1.Pipeline pipeline_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.Pipeline,
            com.google.firestore.v1.Pipeline.Builder,
            com.google.firestore.v1.PipelineOrBuilder>
        pipelineBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the pipeline field is set.
     */
    public boolean hasPipeline() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The pipeline.
     */
    public com.google.firestore.v1.Pipeline getPipeline() {
      if (pipelineBuilder_ == null) {
        return pipeline_ == null
            ? com.google.firestore.v1.Pipeline.getDefaultInstance()
            : pipeline_;
      } else {
        return pipelineBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPipeline(com.google.firestore.v1.Pipeline value) {
      if (pipelineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pipeline_ = value;
      } else {
        pipelineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPipeline(com.google.firestore.v1.Pipeline.Builder builderForValue) {
      if (pipelineBuilder_ == null) {
        pipeline_ = builderForValue.build();
      } else {
        pipelineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergePipeline(com.google.firestore.v1.Pipeline value) {
      if (pipelineBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && pipeline_ != null
            && pipeline_ != com.google.firestore.v1.Pipeline.getDefaultInstance()) {
          getPipelineBuilder().mergeFrom(value);
        } else {
          pipeline_ = value;
        }
      } else {
        pipelineBuilder_.mergeFrom(value);
      }
      if (pipeline_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPipeline() {
      bitField0_ = (bitField0_ & ~0x00000001);
      pipeline_ = null;
      if (pipelineBuilder_ != null) {
        pipelineBuilder_.dispose();
        pipelineBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.Pipeline.Builder getPipelineBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return internalGetPipelineFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.PipelineOrBuilder getPipelineOrBuilder() {
      if (pipelineBuilder_ != null) {
        return pipelineBuilder_.getMessageOrBuilder();
      } else {
        return pipeline_ == null
            ? com.google.firestore.v1.Pipeline.getDefaultInstance()
            : pipeline_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The pipeline query to execute.
     * </pre>
     *
     * <code>.google.firestore.v1.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.firestore.v1.Pipeline,
            com.google.firestore.v1.Pipeline.Builder,
            com.google.firestore.v1.PipelineOrBuilder>
        internalGetPipelineFieldBuilder() {
      if (pipelineBuilder_ == null) {
        pipelineBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.firestore.v1.Pipeline,
                com.google.firestore.v1.Pipeline.Builder,
                com.google.firestore.v1.PipelineOrBuilder>(
                getPipeline(), getParentForChildren(), isClean());
        pipeline_ = null;
      }
      return pipelineBuilder_;
    }

    private static final class OptionsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value> {
      @java.lang.Override
      public com.google.firestore.v1.Value build(com.google.firestore.v1.ValueOrBuilder val) {
        if (val instanceof com.google.firestore.v1.Value) {
          return (com.google.firestore.v1.Value) val;
        }
        return ((com.google.firestore.v1.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
          defaultEntry() {
        return OptionsDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final OptionsConverter optionsConverter = new OptionsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value,
            com.google.firestore.v1.Value.Builder>
        options_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value,
            com.google.firestore.v1.Value.Builder>
        internalGetOptions() {
      if (options_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(optionsConverter);
      }
      return options_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value,
            com.google.firestore.v1.Value.Builder>
        internalGetMutableOptions() {
      if (options_ == null) {
        options_ = new com.google.protobuf.MapFieldBuilder<>(optionsConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return options_;
    }

    public int getOptionsCount() {
      return internalGetOptions().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsOptions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetOptions().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getOptionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptions() {
      return getOptionsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getOptionsMap() {
      return internalGetOptions().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.firestore.v1.Value getOptionsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.firestore.v1.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> map =
          internalGetMutableOptions().ensureBuilderMap();
      return map.containsKey(key) ? optionsConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.v1.Value getOptionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> map =
          internalGetMutableOptions().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return optionsConverter.build(map.get(key));
    }

    public Builder clearOptions() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableOptions().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeOptions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableOptions().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getMutableOptions() {
      bitField0_ |= 0x00000002;
      return internalGetMutableOptions().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putOptions(java.lang.String key, com.google.firestore.v1.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableOptions().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllOptions(
        java.util.Map<java.lang.String, com.google.firestore.v1.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.firestore.v1.Value> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableOptions().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional query-level arguments.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.firestore.v1.Value&gt; options = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.Value.Builder putOptionsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> builderMap =
          internalGetMutableOptions().ensureBuilderMap();
      com.google.firestore.v1.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.firestore.v1.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.firestore.v1.Value) {
        entry = ((com.google.firestore.v1.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.firestore.v1.Value.Builder) entry;
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.StructuredPipeline)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.StructuredPipeline)
  private static final com.google.firestore.v1.StructuredPipeline DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.StructuredPipeline();
  }

  public static com.google.firestore.v1.StructuredPipeline getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StructuredPipeline> PARSER =
      new com.google.protobuf.AbstractParser<StructuredPipeline>() {
        @java.lang.Override
        public StructuredPipeline parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StructuredPipeline> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StructuredPipeline> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.StructuredPipeline getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
