// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_access_context_manager_protos || ($protobuf.roots._google_cloud_access_context_manager_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.identity = (function() {
    
            /**
             * Namespace identity.
             * @memberof google
             * @namespace
             */
            var identity = {};
    
            identity.accesscontextmanager = (function() {
    
                /**
                 * Namespace accesscontextmanager.
                 * @memberof google.identity
                 * @namespace
                 */
                var accesscontextmanager = {};
    
                accesscontextmanager.type = (function() {
    
                    /**
                     * Namespace type.
                     * @memberof google.identity.accesscontextmanager
                     * @namespace
                     */
                    var type = {};
    
                    /**
                     * DeviceEncryptionStatus enum.
                     * @name google.identity.accesscontextmanager.type.DeviceEncryptionStatus
                     * @enum {number}
                     * @property {number} ENCRYPTION_UNSPECIFIED=0 ENCRYPTION_UNSPECIFIED value
                     * @property {number} ENCRYPTION_UNSUPPORTED=1 ENCRYPTION_UNSUPPORTED value
                     * @property {number} UNENCRYPTED=2 UNENCRYPTED value
                     * @property {number} ENCRYPTED=3 ENCRYPTED value
                     */
                    type.DeviceEncryptionStatus = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "ENCRYPTION_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ENCRYPTION_UNSUPPORTED"] = 1;
                        values[valuesById[2] = "UNENCRYPTED"] = 2;
                        values[valuesById[3] = "ENCRYPTED"] = 3;
                        return values;
                    })();
    
                    /**
                     * OsType enum.
                     * @name google.identity.accesscontextmanager.type.OsType
                     * @enum {number}
                     * @property {number} OS_UNSPECIFIED=0 OS_UNSPECIFIED value
                     * @property {number} DESKTOP_MAC=1 DESKTOP_MAC value
                     * @property {number} DESKTOP_WINDOWS=2 DESKTOP_WINDOWS value
                     * @property {number} DESKTOP_LINUX=3 DESKTOP_LINUX value
                     * @property {number} DESKTOP_CHROME_OS=6 DESKTOP_CHROME_OS value
                     * @property {number} ANDROID=4 ANDROID value
                     * @property {number} IOS=5 IOS value
                     */
                    type.OsType = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "OS_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "DESKTOP_MAC"] = 1;
                        values[valuesById[2] = "DESKTOP_WINDOWS"] = 2;
                        values[valuesById[3] = "DESKTOP_LINUX"] = 3;
                        values[valuesById[6] = "DESKTOP_CHROME_OS"] = 6;
                        values[valuesById[4] = "ANDROID"] = 4;
                        values[valuesById[5] = "IOS"] = 5;
                        return values;
                    })();
    
                    /**
                     * DeviceManagementLevel enum.
                     * @name google.identity.accesscontextmanager.type.DeviceManagementLevel
                     * @enum {number}
                     * @property {number} MANAGEMENT_UNSPECIFIED=0 MANAGEMENT_UNSPECIFIED value
                     * @property {number} NONE=1 NONE value
                     * @property {number} BASIC=2 BASIC value
                     * @property {number} COMPLETE=3 COMPLETE value
                     */
                    type.DeviceManagementLevel = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "MANAGEMENT_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "NONE"] = 1;
                        values[valuesById[2] = "BASIC"] = 2;
                        values[valuesById[3] = "COMPLETE"] = 3;
                        return values;
                    })();
    
                    return type;
                })();
    
                accesscontextmanager.v1 = (function() {
    
                    /**
                     * Namespace v1.
                     * @memberof google.identity.accesscontextmanager
                     * @namespace
                     */
                    var v1 = {};
    
                    v1.AccessContextManager = (function() {
    
                        /**
                         * Constructs a new AccessContextManager service.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an AccessContextManager
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function AccessContextManager(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (AccessContextManager.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = AccessContextManager;
    
                        /**
                         * Creates new AccessContextManager service using the specified rpc implementation.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {AccessContextManager} RPC service. Useful where requests and/or responses are streamed.
                         */
                        AccessContextManager.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|listAccessPolicies}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef ListAccessPoliciesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse} [response] ListAccessPoliciesResponse
                         */
    
                        /**
                         * Calls ListAccessPolicies.
                         * @function listAccessPolicies
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest} request ListAccessPoliciesRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.ListAccessPoliciesCallback} callback Node-style callback called with the error, if any, and ListAccessPoliciesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.listAccessPolicies = function listAccessPolicies(request, callback) {
                            return this.rpcCall(listAccessPolicies, $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest, $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse, request, callback);
                        }, "name", { value: "ListAccessPolicies" });
    
                        /**
                         * Calls ListAccessPolicies.
                         * @function listAccessPolicies
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest} request ListAccessPoliciesRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|getAccessPolicy}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef GetAccessPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.AccessPolicy} [response] AccessPolicy
                         */
    
                        /**
                         * Calls GetAccessPolicy.
                         * @function getAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest} request GetAccessPolicyRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.GetAccessPolicyCallback} callback Node-style callback called with the error, if any, and AccessPolicy
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.getAccessPolicy = function getAccessPolicy(request, callback) {
                            return this.rpcCall(getAccessPolicy, $root.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest, $root.google.identity.accesscontextmanager.v1.AccessPolicy, request, callback);
                        }, "name", { value: "GetAccessPolicy" });
    
                        /**
                         * Calls GetAccessPolicy.
                         * @function getAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest} request GetAccessPolicyRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.AccessPolicy>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|createAccessPolicy}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef CreateAccessPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateAccessPolicy.
                         * @function createAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IAccessPolicy} request AccessPolicy message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.CreateAccessPolicyCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.createAccessPolicy = function createAccessPolicy(request, callback) {
                            return this.rpcCall(createAccessPolicy, $root.google.identity.accesscontextmanager.v1.AccessPolicy, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateAccessPolicy" });
    
                        /**
                         * Calls CreateAccessPolicy.
                         * @function createAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IAccessPolicy} request AccessPolicy message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|updateAccessPolicy}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef UpdateAccessPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UpdateAccessPolicy.
                         * @function updateAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest} request UpdateAccessPolicyRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.UpdateAccessPolicyCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.updateAccessPolicy = function updateAccessPolicy(request, callback) {
                            return this.rpcCall(updateAccessPolicy, $root.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UpdateAccessPolicy" });
    
                        /**
                         * Calls UpdateAccessPolicy.
                         * @function updateAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest} request UpdateAccessPolicyRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|deleteAccessPolicy}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef DeleteAccessPolicyCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteAccessPolicy.
                         * @function deleteAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest} request DeleteAccessPolicyRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.DeleteAccessPolicyCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.deleteAccessPolicy = function deleteAccessPolicy(request, callback) {
                            return this.rpcCall(deleteAccessPolicy, $root.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteAccessPolicy" });
    
                        /**
                         * Calls DeleteAccessPolicy.
                         * @function deleteAccessPolicy
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest} request DeleteAccessPolicyRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|listAccessLevels}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef ListAccessLevelsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.ListAccessLevelsResponse} [response] ListAccessLevelsResponse
                         */
    
                        /**
                         * Calls ListAccessLevels.
                         * @function listAccessLevels
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsRequest} request ListAccessLevelsRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.ListAccessLevelsCallback} callback Node-style callback called with the error, if any, and ListAccessLevelsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.listAccessLevels = function listAccessLevels(request, callback) {
                            return this.rpcCall(listAccessLevels, $root.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest, $root.google.identity.accesscontextmanager.v1.ListAccessLevelsResponse, request, callback);
                        }, "name", { value: "ListAccessLevels" });
    
                        /**
                         * Calls ListAccessLevels.
                         * @function listAccessLevels
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsRequest} request ListAccessLevelsRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.ListAccessLevelsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|getAccessLevel}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef GetAccessLevelCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.AccessLevel} [response] AccessLevel
                         */
    
                        /**
                         * Calls GetAccessLevel.
                         * @function getAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessLevelRequest} request GetAccessLevelRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.GetAccessLevelCallback} callback Node-style callback called with the error, if any, and AccessLevel
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.getAccessLevel = function getAccessLevel(request, callback) {
                            return this.rpcCall(getAccessLevel, $root.google.identity.accesscontextmanager.v1.GetAccessLevelRequest, $root.google.identity.accesscontextmanager.v1.AccessLevel, request, callback);
                        }, "name", { value: "GetAccessLevel" });
    
                        /**
                         * Calls GetAccessLevel.
                         * @function getAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessLevelRequest} request GetAccessLevelRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.AccessLevel>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|createAccessLevel}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef CreateAccessLevelCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateAccessLevel.
                         * @function createAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest} request CreateAccessLevelRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.CreateAccessLevelCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.createAccessLevel = function createAccessLevel(request, callback) {
                            return this.rpcCall(createAccessLevel, $root.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateAccessLevel" });
    
                        /**
                         * Calls CreateAccessLevel.
                         * @function createAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest} request CreateAccessLevelRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|updateAccessLevel}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef UpdateAccessLevelCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UpdateAccessLevel.
                         * @function updateAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest} request UpdateAccessLevelRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.UpdateAccessLevelCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.updateAccessLevel = function updateAccessLevel(request, callback) {
                            return this.rpcCall(updateAccessLevel, $root.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UpdateAccessLevel" });
    
                        /**
                         * Calls UpdateAccessLevel.
                         * @function updateAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest} request UpdateAccessLevelRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|deleteAccessLevel}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef DeleteAccessLevelCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteAccessLevel.
                         * @function deleteAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest} request DeleteAccessLevelRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.DeleteAccessLevelCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.deleteAccessLevel = function deleteAccessLevel(request, callback) {
                            return this.rpcCall(deleteAccessLevel, $root.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteAccessLevel" });
    
                        /**
                         * Calls DeleteAccessLevel.
                         * @function deleteAccessLevel
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest} request DeleteAccessLevelRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|replaceAccessLevels}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef ReplaceAccessLevelsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ReplaceAccessLevels.
                         * @function replaceAccessLevels
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest} request ReplaceAccessLevelsRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.ReplaceAccessLevelsCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.replaceAccessLevels = function replaceAccessLevels(request, callback) {
                            return this.rpcCall(replaceAccessLevels, $root.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ReplaceAccessLevels" });
    
                        /**
                         * Calls ReplaceAccessLevels.
                         * @function replaceAccessLevels
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest} request ReplaceAccessLevelsRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|listServicePerimeters}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef ListServicePerimetersCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.ListServicePerimetersResponse} [response] ListServicePerimetersResponse
                         */
    
                        /**
                         * Calls ListServicePerimeters.
                         * @function listServicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersRequest} request ListServicePerimetersRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.ListServicePerimetersCallback} callback Node-style callback called with the error, if any, and ListServicePerimetersResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.listServicePerimeters = function listServicePerimeters(request, callback) {
                            return this.rpcCall(listServicePerimeters, $root.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest, $root.google.identity.accesscontextmanager.v1.ListServicePerimetersResponse, request, callback);
                        }, "name", { value: "ListServicePerimeters" });
    
                        /**
                         * Calls ListServicePerimeters.
                         * @function listServicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersRequest} request ListServicePerimetersRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.ListServicePerimetersResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|getServicePerimeter}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef GetServicePerimeterCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.ServicePerimeter} [response] ServicePerimeter
                         */
    
                        /**
                         * Calls GetServicePerimeter.
                         * @function getServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest} request GetServicePerimeterRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.GetServicePerimeterCallback} callback Node-style callback called with the error, if any, and ServicePerimeter
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.getServicePerimeter = function getServicePerimeter(request, callback) {
                            return this.rpcCall(getServicePerimeter, $root.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest, $root.google.identity.accesscontextmanager.v1.ServicePerimeter, request, callback);
                        }, "name", { value: "GetServicePerimeter" });
    
                        /**
                         * Calls GetServicePerimeter.
                         * @function getServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest} request GetServicePerimeterRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.ServicePerimeter>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|createServicePerimeter}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef CreateServicePerimeterCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateServicePerimeter.
                         * @function createServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest} request CreateServicePerimeterRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.CreateServicePerimeterCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.createServicePerimeter = function createServicePerimeter(request, callback) {
                            return this.rpcCall(createServicePerimeter, $root.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateServicePerimeter" });
    
                        /**
                         * Calls CreateServicePerimeter.
                         * @function createServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest} request CreateServicePerimeterRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|updateServicePerimeter}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef UpdateServicePerimeterCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UpdateServicePerimeter.
                         * @function updateServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest} request UpdateServicePerimeterRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.UpdateServicePerimeterCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.updateServicePerimeter = function updateServicePerimeter(request, callback) {
                            return this.rpcCall(updateServicePerimeter, $root.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UpdateServicePerimeter" });
    
                        /**
                         * Calls UpdateServicePerimeter.
                         * @function updateServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest} request UpdateServicePerimeterRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|deleteServicePerimeter}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef DeleteServicePerimeterCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteServicePerimeter.
                         * @function deleteServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest} request DeleteServicePerimeterRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.DeleteServicePerimeterCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.deleteServicePerimeter = function deleteServicePerimeter(request, callback) {
                            return this.rpcCall(deleteServicePerimeter, $root.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteServicePerimeter" });
    
                        /**
                         * Calls DeleteServicePerimeter.
                         * @function deleteServicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest} request DeleteServicePerimeterRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|replaceServicePerimeters}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef ReplaceServicePerimetersCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ReplaceServicePerimeters.
                         * @function replaceServicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest} request ReplaceServicePerimetersRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.ReplaceServicePerimetersCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.replaceServicePerimeters = function replaceServicePerimeters(request, callback) {
                            return this.rpcCall(replaceServicePerimeters, $root.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ReplaceServicePerimeters" });
    
                        /**
                         * Calls ReplaceServicePerimeters.
                         * @function replaceServicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest} request ReplaceServicePerimetersRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|commitServicePerimeters}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef CommitServicePerimetersCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CommitServicePerimeters.
                         * @function commitServicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest} request CommitServicePerimetersRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.CommitServicePerimetersCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.commitServicePerimeters = function commitServicePerimeters(request, callback) {
                            return this.rpcCall(commitServicePerimeters, $root.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CommitServicePerimeters" });
    
                        /**
                         * Calls CommitServicePerimeters.
                         * @function commitServicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest} request CommitServicePerimetersRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|listGcpUserAccessBindings}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef ListGcpUserAccessBindingsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse} [response] ListGcpUserAccessBindingsResponse
                         */
    
                        /**
                         * Calls ListGcpUserAccessBindings.
                         * @function listGcpUserAccessBindings
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest} request ListGcpUserAccessBindingsRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.ListGcpUserAccessBindingsCallback} callback Node-style callback called with the error, if any, and ListGcpUserAccessBindingsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.listGcpUserAccessBindings = function listGcpUserAccessBindings(request, callback) {
                            return this.rpcCall(listGcpUserAccessBindings, $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest, $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse, request, callback);
                        }, "name", { value: "ListGcpUserAccessBindings" });
    
                        /**
                         * Calls ListGcpUserAccessBindings.
                         * @function listGcpUserAccessBindings
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest} request ListGcpUserAccessBindingsRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|getGcpUserAccessBinding}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef GetGcpUserAccessBindingCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} [response] GcpUserAccessBinding
                         */
    
                        /**
                         * Calls GetGcpUserAccessBinding.
                         * @function getGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest} request GetGcpUserAccessBindingRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.GetGcpUserAccessBindingCallback} callback Node-style callback called with the error, if any, and GcpUserAccessBinding
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.getGcpUserAccessBinding = function getGcpUserAccessBinding(request, callback) {
                            return this.rpcCall(getGcpUserAccessBinding, $root.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest, $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding, request, callback);
                        }, "name", { value: "GetGcpUserAccessBinding" });
    
                        /**
                         * Calls GetGcpUserAccessBinding.
                         * @function getGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest} request GetGcpUserAccessBindingRequest message or plain object
                         * @returns {Promise<google.identity.accesscontextmanager.v1.GcpUserAccessBinding>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|createGcpUserAccessBinding}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef CreateGcpUserAccessBindingCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls CreateGcpUserAccessBinding.
                         * @function createGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest} request CreateGcpUserAccessBindingRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.CreateGcpUserAccessBindingCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.createGcpUserAccessBinding = function createGcpUserAccessBinding(request, callback) {
                            return this.rpcCall(createGcpUserAccessBinding, $root.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "CreateGcpUserAccessBinding" });
    
                        /**
                         * Calls CreateGcpUserAccessBinding.
                         * @function createGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest} request CreateGcpUserAccessBindingRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|updateGcpUserAccessBinding}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef UpdateGcpUserAccessBindingCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls UpdateGcpUserAccessBinding.
                         * @function updateGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest} request UpdateGcpUserAccessBindingRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.UpdateGcpUserAccessBindingCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.updateGcpUserAccessBinding = function updateGcpUserAccessBinding(request, callback) {
                            return this.rpcCall(updateGcpUserAccessBinding, $root.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "UpdateGcpUserAccessBinding" });
    
                        /**
                         * Calls UpdateGcpUserAccessBinding.
                         * @function updateGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest} request UpdateGcpUserAccessBindingRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.identity.accesscontextmanager.v1.AccessContextManager|deleteGcpUserAccessBinding}.
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @typedef DeleteGcpUserAccessBindingCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls DeleteGcpUserAccessBinding.
                         * @function deleteGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest} request DeleteGcpUserAccessBindingRequest message or plain object
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManager.DeleteGcpUserAccessBindingCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AccessContextManager.prototype.deleteGcpUserAccessBinding = function deleteGcpUserAccessBinding(request, callback) {
                            return this.rpcCall(deleteGcpUserAccessBinding, $root.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "DeleteGcpUserAccessBinding" });
    
                        /**
                         * Calls DeleteGcpUserAccessBinding.
                         * @function deleteGcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManager
                         * @instance
                         * @param {google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest} request DeleteGcpUserAccessBindingRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        return AccessContextManager;
                    })();
    
                    v1.ListAccessPoliciesRequest = (function() {
    
                        /**
                         * Properties of a ListAccessPoliciesRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListAccessPoliciesRequest
                         * @property {string|null} [parent] ListAccessPoliciesRequest parent
                         * @property {number|null} [pageSize] ListAccessPoliciesRequest pageSize
                         * @property {string|null} [pageToken] ListAccessPoliciesRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListAccessPoliciesRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListAccessPoliciesRequest.
                         * @implements IListAccessPoliciesRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest=} [properties] Properties to set
                         */
                        function ListAccessPoliciesRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAccessPoliciesRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @instance
                         */
                        ListAccessPoliciesRequest.prototype.parent = "";
    
                        /**
                         * ListAccessPoliciesRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @instance
                         */
                        ListAccessPoliciesRequest.prototype.pageSize = 0;
    
                        /**
                         * ListAccessPoliciesRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @instance
                         */
                        ListAccessPoliciesRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListAccessPoliciesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest} ListAccessPoliciesRequest instance
                         */
                        ListAccessPoliciesRequest.create = function create(properties) {
                            return new ListAccessPoliciesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListAccessPoliciesRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest} message ListAccessPoliciesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessPoliciesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAccessPoliciesRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest} message ListAccessPoliciesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessPoliciesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAccessPoliciesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest} ListAccessPoliciesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessPoliciesRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAccessPoliciesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest} ListAccessPoliciesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessPoliciesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAccessPoliciesRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAccessPoliciesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAccessPoliciesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest} ListAccessPoliciesRequest
                         */
                        ListAccessPoliciesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAccessPoliciesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest} message ListAccessPoliciesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAccessPoliciesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListAccessPoliciesRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAccessPoliciesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAccessPoliciesRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAccessPoliciesRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest";
                        };
    
                        return ListAccessPoliciesRequest;
                    })();
    
                    v1.ListAccessPoliciesResponse = (function() {
    
                        /**
                         * Properties of a ListAccessPoliciesResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListAccessPoliciesResponse
                         * @property {Array.<google.identity.accesscontextmanager.v1.IAccessPolicy>|null} [accessPolicies] ListAccessPoliciesResponse accessPolicies
                         * @property {string|null} [nextPageToken] ListAccessPoliciesResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListAccessPoliciesResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListAccessPoliciesResponse.
                         * @implements IListAccessPoliciesResponse
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse=} [properties] Properties to set
                         */
                        function ListAccessPoliciesResponse(properties) {
                            this.accessPolicies = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAccessPoliciesResponse accessPolicies.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IAccessPolicy>} accessPolicies
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @instance
                         */
                        ListAccessPoliciesResponse.prototype.accessPolicies = $util.emptyArray;
    
                        /**
                         * ListAccessPoliciesResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @instance
                         */
                        ListAccessPoliciesResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListAccessPoliciesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse} ListAccessPoliciesResponse instance
                         */
                        ListAccessPoliciesResponse.create = function create(properties) {
                            return new ListAccessPoliciesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListAccessPoliciesResponse message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse} message ListAccessPoliciesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessPoliciesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.accessPolicies != null && message.accessPolicies.length)
                                for (var i = 0; i < message.accessPolicies.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.AccessPolicy.encode(message.accessPolicies[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAccessPoliciesResponse message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse} message ListAccessPoliciesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessPoliciesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAccessPoliciesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse} ListAccessPoliciesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessPoliciesResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.accessPolicies && message.accessPolicies.length))
                                            message.accessPolicies = [];
                                        message.accessPolicies.push($root.google.identity.accesscontextmanager.v1.AccessPolicy.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAccessPoliciesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse} ListAccessPoliciesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessPoliciesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAccessPoliciesResponse message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAccessPoliciesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.accessPolicies != null && message.hasOwnProperty("accessPolicies")) {
                                if (!Array.isArray(message.accessPolicies))
                                    return "accessPolicies: array expected";
                                for (var i = 0; i < message.accessPolicies.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.AccessPolicy.verify(message.accessPolicies[i]);
                                    if (error)
                                        return "accessPolicies." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAccessPoliciesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse} ListAccessPoliciesResponse
                         */
                        ListAccessPoliciesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse();
                            if (object.accessPolicies) {
                                if (!Array.isArray(object.accessPolicies))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse.accessPolicies: array expected");
                                message.accessPolicies = [];
                                for (var i = 0; i < object.accessPolicies.length; ++i) {
                                    if (typeof object.accessPolicies[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse.accessPolicies: object expected");
                                    message.accessPolicies[i] = $root.google.identity.accesscontextmanager.v1.AccessPolicy.fromObject(object.accessPolicies[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAccessPoliciesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse} message ListAccessPoliciesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAccessPoliciesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.accessPolicies = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.accessPolicies && message.accessPolicies.length) {
                                object.accessPolicies = [];
                                for (var j = 0; j < message.accessPolicies.length; ++j)
                                    object.accessPolicies[j] = $root.google.identity.accesscontextmanager.v1.AccessPolicy.toObject(message.accessPolicies[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListAccessPoliciesResponse to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAccessPoliciesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAccessPoliciesResponse
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAccessPoliciesResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse";
                        };
    
                        return ListAccessPoliciesResponse;
                    })();
    
                    v1.GetAccessPolicyRequest = (function() {
    
                        /**
                         * Properties of a GetAccessPolicyRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IGetAccessPolicyRequest
                         * @property {string|null} [name] GetAccessPolicyRequest name
                         */
    
                        /**
                         * Constructs a new GetAccessPolicyRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a GetAccessPolicyRequest.
                         * @implements IGetAccessPolicyRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest=} [properties] Properties to set
                         */
                        function GetAccessPolicyRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetAccessPolicyRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @instance
                         */
                        GetAccessPolicyRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetAccessPolicyRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessPolicyRequest} GetAccessPolicyRequest instance
                         */
                        GetAccessPolicyRequest.create = function create(properties) {
                            return new GetAccessPolicyRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetAccessPolicyRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetAccessPolicyRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest} message GetAccessPolicyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAccessPolicyRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetAccessPolicyRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetAccessPolicyRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest} message GetAccessPolicyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAccessPolicyRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetAccessPolicyRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessPolicyRequest} GetAccessPolicyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAccessPolicyRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetAccessPolicyRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessPolicyRequest} GetAccessPolicyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAccessPolicyRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetAccessPolicyRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAccessPolicyRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetAccessPolicyRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessPolicyRequest} GetAccessPolicyRequest
                         */
                        GetAccessPolicyRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetAccessPolicyRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.GetAccessPolicyRequest} message GetAccessPolicyRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAccessPolicyRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetAccessPolicyRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAccessPolicyRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetAccessPolicyRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessPolicyRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetAccessPolicyRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.GetAccessPolicyRequest";
                        };
    
                        return GetAccessPolicyRequest;
                    })();
    
                    v1.UpdateAccessPolicyRequest = (function() {
    
                        /**
                         * Properties of an UpdateAccessPolicyRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IUpdateAccessPolicyRequest
                         * @property {google.identity.accesscontextmanager.v1.IAccessPolicy|null} [policy] UpdateAccessPolicyRequest policy
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateAccessPolicyRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateAccessPolicyRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an UpdateAccessPolicyRequest.
                         * @implements IUpdateAccessPolicyRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest=} [properties] Properties to set
                         */
                        function UpdateAccessPolicyRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateAccessPolicyRequest policy.
                         * @member {google.identity.accesscontextmanager.v1.IAccessPolicy|null|undefined} policy
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @instance
                         */
                        UpdateAccessPolicyRequest.prototype.policy = null;
    
                        /**
                         * UpdateAccessPolicyRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @instance
                         */
                        UpdateAccessPolicyRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateAccessPolicyRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest} UpdateAccessPolicyRequest instance
                         */
                        UpdateAccessPolicyRequest.create = function create(properties) {
                            return new UpdateAccessPolicyRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateAccessPolicyRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest} message UpdateAccessPolicyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAccessPolicyRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.policy != null && Object.hasOwnProperty.call(message, "policy"))
                                $root.google.identity.accesscontextmanager.v1.AccessPolicy.encode(message.policy, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateAccessPolicyRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest} message UpdateAccessPolicyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAccessPolicyRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateAccessPolicyRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest} UpdateAccessPolicyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAccessPolicyRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.policy = $root.google.identity.accesscontextmanager.v1.AccessPolicy.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateAccessPolicyRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest} UpdateAccessPolicyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAccessPolicyRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateAccessPolicyRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateAccessPolicyRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.policy != null && message.hasOwnProperty("policy")) {
                                var error = $root.google.identity.accesscontextmanager.v1.AccessPolicy.verify(message.policy);
                                if (error)
                                    return "policy." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateAccessPolicyRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest} UpdateAccessPolicyRequest
                         */
                        UpdateAccessPolicyRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest();
                            if (object.policy != null) {
                                if (typeof object.policy !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest.policy: object expected");
                                message.policy = $root.google.identity.accesscontextmanager.v1.AccessPolicy.fromObject(object.policy);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateAccessPolicyRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest} message UpdateAccessPolicyRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateAccessPolicyRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.policy = null;
                                object.updateMask = null;
                            }
                            if (message.policy != null && message.hasOwnProperty("policy"))
                                object.policy = $root.google.identity.accesscontextmanager.v1.AccessPolicy.toObject(message.policy, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateAccessPolicyRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateAccessPolicyRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateAccessPolicyRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateAccessPolicyRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest";
                        };
    
                        return UpdateAccessPolicyRequest;
                    })();
    
                    v1.DeleteAccessPolicyRequest = (function() {
    
                        /**
                         * Properties of a DeleteAccessPolicyRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IDeleteAccessPolicyRequest
                         * @property {string|null} [name] DeleteAccessPolicyRequest name
                         */
    
                        /**
                         * Constructs a new DeleteAccessPolicyRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a DeleteAccessPolicyRequest.
                         * @implements IDeleteAccessPolicyRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest=} [properties] Properties to set
                         */
                        function DeleteAccessPolicyRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteAccessPolicyRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @instance
                         */
                        DeleteAccessPolicyRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteAccessPolicyRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest} DeleteAccessPolicyRequest instance
                         */
                        DeleteAccessPolicyRequest.create = function create(properties) {
                            return new DeleteAccessPolicyRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteAccessPolicyRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest} message DeleteAccessPolicyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAccessPolicyRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteAccessPolicyRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest} message DeleteAccessPolicyRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAccessPolicyRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteAccessPolicyRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest} DeleteAccessPolicyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAccessPolicyRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteAccessPolicyRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest} DeleteAccessPolicyRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAccessPolicyRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteAccessPolicyRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteAccessPolicyRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteAccessPolicyRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest} DeleteAccessPolicyRequest
                         */
                        DeleteAccessPolicyRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteAccessPolicyRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest} message DeleteAccessPolicyRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteAccessPolicyRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteAccessPolicyRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteAccessPolicyRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteAccessPolicyRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteAccessPolicyRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest";
                        };
    
                        return DeleteAccessPolicyRequest;
                    })();
    
                    v1.ListAccessLevelsRequest = (function() {
    
                        /**
                         * Properties of a ListAccessLevelsRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListAccessLevelsRequest
                         * @property {string|null} [parent] ListAccessLevelsRequest parent
                         * @property {number|null} [pageSize] ListAccessLevelsRequest pageSize
                         * @property {string|null} [pageToken] ListAccessLevelsRequest pageToken
                         * @property {google.identity.accesscontextmanager.v1.LevelFormat|null} [accessLevelFormat] ListAccessLevelsRequest accessLevelFormat
                         */
    
                        /**
                         * Constructs a new ListAccessLevelsRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListAccessLevelsRequest.
                         * @implements IListAccessLevelsRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsRequest=} [properties] Properties to set
                         */
                        function ListAccessLevelsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAccessLevelsRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @instance
                         */
                        ListAccessLevelsRequest.prototype.parent = "";
    
                        /**
                         * ListAccessLevelsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @instance
                         */
                        ListAccessLevelsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListAccessLevelsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @instance
                         */
                        ListAccessLevelsRequest.prototype.pageToken = "";
    
                        /**
                         * ListAccessLevelsRequest accessLevelFormat.
                         * @member {google.identity.accesscontextmanager.v1.LevelFormat} accessLevelFormat
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @instance
                         */
                        ListAccessLevelsRequest.prototype.accessLevelFormat = 0;
    
                        /**
                         * Creates a new ListAccessLevelsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsRequest} ListAccessLevelsRequest instance
                         */
                        ListAccessLevelsRequest.create = function create(properties) {
                            return new ListAccessLevelsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListAccessLevelsRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessLevelsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsRequest} message ListAccessLevelsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessLevelsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            if (message.accessLevelFormat != null && Object.hasOwnProperty.call(message, "accessLevelFormat"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.accessLevelFormat);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAccessLevelsRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessLevelsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsRequest} message ListAccessLevelsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessLevelsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAccessLevelsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsRequest} ListAccessLevelsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessLevelsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.accessLevelFormat = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAccessLevelsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsRequest} ListAccessLevelsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessLevelsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAccessLevelsRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAccessLevelsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            if (message.accessLevelFormat != null && message.hasOwnProperty("accessLevelFormat"))
                                switch (message.accessLevelFormat) {
                                default:
                                    return "accessLevelFormat: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a ListAccessLevelsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsRequest} ListAccessLevelsRequest
                         */
                        ListAccessLevelsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            switch (object.accessLevelFormat) {
                            case "LEVEL_FORMAT_UNSPECIFIED":
                            case 0:
                                message.accessLevelFormat = 0;
                                break;
                            case "AS_DEFINED":
                            case 1:
                                message.accessLevelFormat = 1;
                                break;
                            case "CEL":
                            case 2:
                                message.accessLevelFormat = 2;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAccessLevelsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListAccessLevelsRequest} message ListAccessLevelsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAccessLevelsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                                object.accessLevelFormat = options.enums === String ? "LEVEL_FORMAT_UNSPECIFIED" : 0;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            if (message.accessLevelFormat != null && message.hasOwnProperty("accessLevelFormat"))
                                object.accessLevelFormat = options.enums === String ? $root.google.identity.accesscontextmanager.v1.LevelFormat[message.accessLevelFormat] : message.accessLevelFormat;
                            return object;
                        };
    
                        /**
                         * Converts this ListAccessLevelsRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAccessLevelsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAccessLevelsRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAccessLevelsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListAccessLevelsRequest";
                        };
    
                        return ListAccessLevelsRequest;
                    })();
    
                    v1.ListAccessLevelsResponse = (function() {
    
                        /**
                         * Properties of a ListAccessLevelsResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListAccessLevelsResponse
                         * @property {Array.<google.identity.accesscontextmanager.v1.IAccessLevel>|null} [accessLevels] ListAccessLevelsResponse accessLevels
                         * @property {string|null} [nextPageToken] ListAccessLevelsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListAccessLevelsResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListAccessLevelsResponse.
                         * @implements IListAccessLevelsResponse
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsResponse=} [properties] Properties to set
                         */
                        function ListAccessLevelsResponse(properties) {
                            this.accessLevels = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAccessLevelsResponse accessLevels.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IAccessLevel>} accessLevels
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @instance
                         */
                        ListAccessLevelsResponse.prototype.accessLevels = $util.emptyArray;
    
                        /**
                         * ListAccessLevelsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @instance
                         */
                        ListAccessLevelsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListAccessLevelsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsResponse=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsResponse} ListAccessLevelsResponse instance
                         */
                        ListAccessLevelsResponse.create = function create(properties) {
                            return new ListAccessLevelsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListAccessLevelsResponse message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessLevelsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsResponse} message ListAccessLevelsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessLevelsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.accessLevels != null && message.accessLevels.length)
                                for (var i = 0; i < message.accessLevels.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.AccessLevel.encode(message.accessLevels[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAccessLevelsResponse message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListAccessLevelsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListAccessLevelsResponse} message ListAccessLevelsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAccessLevelsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAccessLevelsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsResponse} ListAccessLevelsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessLevelsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListAccessLevelsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.accessLevels && message.accessLevels.length))
                                            message.accessLevels = [];
                                        message.accessLevels.push($root.google.identity.accesscontextmanager.v1.AccessLevel.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAccessLevelsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsResponse} ListAccessLevelsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAccessLevelsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAccessLevelsResponse message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAccessLevelsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.accessLevels != null && message.hasOwnProperty("accessLevels")) {
                                if (!Array.isArray(message.accessLevels))
                                    return "accessLevels: array expected";
                                for (var i = 0; i < message.accessLevels.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.AccessLevel.verify(message.accessLevels[i]);
                                    if (error)
                                        return "accessLevels." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAccessLevelsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListAccessLevelsResponse} ListAccessLevelsResponse
                         */
                        ListAccessLevelsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListAccessLevelsResponse)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListAccessLevelsResponse();
                            if (object.accessLevels) {
                                if (!Array.isArray(object.accessLevels))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ListAccessLevelsResponse.accessLevels: array expected");
                                message.accessLevels = [];
                                for (var i = 0; i < object.accessLevels.length; ++i) {
                                    if (typeof object.accessLevels[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ListAccessLevelsResponse.accessLevels: object expected");
                                    message.accessLevels[i] = $root.google.identity.accesscontextmanager.v1.AccessLevel.fromObject(object.accessLevels[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAccessLevelsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListAccessLevelsResponse} message ListAccessLevelsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAccessLevelsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.accessLevels = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.accessLevels && message.accessLevels.length) {
                                object.accessLevels = [];
                                for (var j = 0; j < message.accessLevels.length; ++j)
                                    object.accessLevels[j] = $root.google.identity.accesscontextmanager.v1.AccessLevel.toObject(message.accessLevels[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListAccessLevelsResponse to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAccessLevelsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListAccessLevelsResponse
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListAccessLevelsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListAccessLevelsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListAccessLevelsResponse";
                        };
    
                        return ListAccessLevelsResponse;
                    })();
    
                    v1.GetAccessLevelRequest = (function() {
    
                        /**
                         * Properties of a GetAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IGetAccessLevelRequest
                         * @property {string|null} [name] GetAccessLevelRequest name
                         * @property {google.identity.accesscontextmanager.v1.LevelFormat|null} [accessLevelFormat] GetAccessLevelRequest accessLevelFormat
                         */
    
                        /**
                         * Constructs a new GetAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a GetAccessLevelRequest.
                         * @implements IGetAccessLevelRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessLevelRequest=} [properties] Properties to set
                         */
                        function GetAccessLevelRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetAccessLevelRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @instance
                         */
                        GetAccessLevelRequest.prototype.name = "";
    
                        /**
                         * GetAccessLevelRequest accessLevelFormat.
                         * @member {google.identity.accesscontextmanager.v1.LevelFormat} accessLevelFormat
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @instance
                         */
                        GetAccessLevelRequest.prototype.accessLevelFormat = 0;
    
                        /**
                         * Creates a new GetAccessLevelRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessLevelRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessLevelRequest} GetAccessLevelRequest instance
                         */
                        GetAccessLevelRequest.create = function create(properties) {
                            return new GetAccessLevelRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetAccessLevelRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetAccessLevelRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessLevelRequest} message GetAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAccessLevelRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.accessLevelFormat != null && Object.hasOwnProperty.call(message, "accessLevelFormat"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.accessLevelFormat);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetAccessLevelRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetAccessLevelRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetAccessLevelRequest} message GetAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAccessLevelRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetAccessLevelRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessLevelRequest} GetAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAccessLevelRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.GetAccessLevelRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.accessLevelFormat = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetAccessLevelRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessLevelRequest} GetAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAccessLevelRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetAccessLevelRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAccessLevelRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.accessLevelFormat != null && message.hasOwnProperty("accessLevelFormat"))
                                switch (message.accessLevelFormat) {
                                default:
                                    return "accessLevelFormat: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a GetAccessLevelRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.GetAccessLevelRequest} GetAccessLevelRequest
                         */
                        GetAccessLevelRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.GetAccessLevelRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.GetAccessLevelRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            switch (object.accessLevelFormat) {
                            case "LEVEL_FORMAT_UNSPECIFIED":
                            case 0:
                                message.accessLevelFormat = 0;
                                break;
                            case "AS_DEFINED":
                            case 1:
                                message.accessLevelFormat = 1;
                                break;
                            case "CEL":
                            case 2:
                                message.accessLevelFormat = 2;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetAccessLevelRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.GetAccessLevelRequest} message GetAccessLevelRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAccessLevelRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.accessLevelFormat = options.enums === String ? "LEVEL_FORMAT_UNSPECIFIED" : 0;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.accessLevelFormat != null && message.hasOwnProperty("accessLevelFormat"))
                                object.accessLevelFormat = options.enums === String ? $root.google.identity.accesscontextmanager.v1.LevelFormat[message.accessLevelFormat] : message.accessLevelFormat;
                            return object;
                        };
    
                        /**
                         * Converts this GetAccessLevelRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAccessLevelRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetAccessLevelRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.GetAccessLevelRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetAccessLevelRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.GetAccessLevelRequest";
                        };
    
                        return GetAccessLevelRequest;
                    })();
    
                    v1.CreateAccessLevelRequest = (function() {
    
                        /**
                         * Properties of a CreateAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface ICreateAccessLevelRequest
                         * @property {string|null} [parent] CreateAccessLevelRequest parent
                         * @property {google.identity.accesscontextmanager.v1.IAccessLevel|null} [accessLevel] CreateAccessLevelRequest accessLevel
                         */
    
                        /**
                         * Constructs a new CreateAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a CreateAccessLevelRequest.
                         * @implements ICreateAccessLevelRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest=} [properties] Properties to set
                         */
                        function CreateAccessLevelRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateAccessLevelRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @instance
                         */
                        CreateAccessLevelRequest.prototype.parent = "";
    
                        /**
                         * CreateAccessLevelRequest accessLevel.
                         * @member {google.identity.accesscontextmanager.v1.IAccessLevel|null|undefined} accessLevel
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @instance
                         */
                        CreateAccessLevelRequest.prototype.accessLevel = null;
    
                        /**
                         * Creates a new CreateAccessLevelRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.CreateAccessLevelRequest} CreateAccessLevelRequest instance
                         */
                        CreateAccessLevelRequest.create = function create(properties) {
                            return new CreateAccessLevelRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateAccessLevelRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.CreateAccessLevelRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest} message CreateAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateAccessLevelRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.accessLevel != null && Object.hasOwnProperty.call(message, "accessLevel"))
                                $root.google.identity.accesscontextmanager.v1.AccessLevel.encode(message.accessLevel, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateAccessLevelRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.CreateAccessLevelRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest} message CreateAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateAccessLevelRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateAccessLevelRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.CreateAccessLevelRequest} CreateAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateAccessLevelRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.accessLevel = $root.google.identity.accesscontextmanager.v1.AccessLevel.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateAccessLevelRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.CreateAccessLevelRequest} CreateAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateAccessLevelRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateAccessLevelRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateAccessLevelRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.accessLevel != null && message.hasOwnProperty("accessLevel")) {
                                var error = $root.google.identity.accesscontextmanager.v1.AccessLevel.verify(message.accessLevel);
                                if (error)
                                    return "accessLevel." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateAccessLevelRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.CreateAccessLevelRequest} CreateAccessLevelRequest
                         */
                        CreateAccessLevelRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.accessLevel != null) {
                                if (typeof object.accessLevel !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.CreateAccessLevelRequest.accessLevel: object expected");
                                message.accessLevel = $root.google.identity.accesscontextmanager.v1.AccessLevel.fromObject(object.accessLevel);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateAccessLevelRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.CreateAccessLevelRequest} message CreateAccessLevelRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateAccessLevelRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.accessLevel = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.accessLevel != null && message.hasOwnProperty("accessLevel"))
                                object.accessLevel = $root.google.identity.accesscontextmanager.v1.AccessLevel.toObject(message.accessLevel, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateAccessLevelRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateAccessLevelRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateAccessLevelRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.CreateAccessLevelRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateAccessLevelRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.CreateAccessLevelRequest";
                        };
    
                        return CreateAccessLevelRequest;
                    })();
    
                    v1.UpdateAccessLevelRequest = (function() {
    
                        /**
                         * Properties of an UpdateAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IUpdateAccessLevelRequest
                         * @property {google.identity.accesscontextmanager.v1.IAccessLevel|null} [accessLevel] UpdateAccessLevelRequest accessLevel
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateAccessLevelRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an UpdateAccessLevelRequest.
                         * @implements IUpdateAccessLevelRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest=} [properties] Properties to set
                         */
                        function UpdateAccessLevelRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateAccessLevelRequest accessLevel.
                         * @member {google.identity.accesscontextmanager.v1.IAccessLevel|null|undefined} accessLevel
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @instance
                         */
                        UpdateAccessLevelRequest.prototype.accessLevel = null;
    
                        /**
                         * UpdateAccessLevelRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @instance
                         */
                        UpdateAccessLevelRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateAccessLevelRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest} UpdateAccessLevelRequest instance
                         */
                        UpdateAccessLevelRequest.create = function create(properties) {
                            return new UpdateAccessLevelRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateAccessLevelRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest} message UpdateAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAccessLevelRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.accessLevel != null && Object.hasOwnProperty.call(message, "accessLevel"))
                                $root.google.identity.accesscontextmanager.v1.AccessLevel.encode(message.accessLevel, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateAccessLevelRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest} message UpdateAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAccessLevelRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateAccessLevelRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest} UpdateAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAccessLevelRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.accessLevel = $root.google.identity.accesscontextmanager.v1.AccessLevel.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateAccessLevelRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest} UpdateAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAccessLevelRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateAccessLevelRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateAccessLevelRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.accessLevel != null && message.hasOwnProperty("accessLevel")) {
                                var error = $root.google.identity.accesscontextmanager.v1.AccessLevel.verify(message.accessLevel);
                                if (error)
                                    return "accessLevel." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateAccessLevelRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest} UpdateAccessLevelRequest
                         */
                        UpdateAccessLevelRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest();
                            if (object.accessLevel != null) {
                                if (typeof object.accessLevel !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest.accessLevel: object expected");
                                message.accessLevel = $root.google.identity.accesscontextmanager.v1.AccessLevel.fromObject(object.accessLevel);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateAccessLevelRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest} message UpdateAccessLevelRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateAccessLevelRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.accessLevel = null;
                                object.updateMask = null;
                            }
                            if (message.accessLevel != null && message.hasOwnProperty("accessLevel"))
                                object.accessLevel = $root.google.identity.accesscontextmanager.v1.AccessLevel.toObject(message.accessLevel, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateAccessLevelRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateAccessLevelRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateAccessLevelRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateAccessLevelRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest";
                        };
    
                        return UpdateAccessLevelRequest;
                    })();
    
                    v1.DeleteAccessLevelRequest = (function() {
    
                        /**
                         * Properties of a DeleteAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IDeleteAccessLevelRequest
                         * @property {string|null} [name] DeleteAccessLevelRequest name
                         */
    
                        /**
                         * Constructs a new DeleteAccessLevelRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a DeleteAccessLevelRequest.
                         * @implements IDeleteAccessLevelRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest=} [properties] Properties to set
                         */
                        function DeleteAccessLevelRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteAccessLevelRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @instance
                         */
                        DeleteAccessLevelRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteAccessLevelRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest} DeleteAccessLevelRequest instance
                         */
                        DeleteAccessLevelRequest.create = function create(properties) {
                            return new DeleteAccessLevelRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteAccessLevelRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest} message DeleteAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAccessLevelRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteAccessLevelRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest} message DeleteAccessLevelRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAccessLevelRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteAccessLevelRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest} DeleteAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAccessLevelRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteAccessLevelRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest} DeleteAccessLevelRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAccessLevelRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteAccessLevelRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteAccessLevelRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteAccessLevelRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest} DeleteAccessLevelRequest
                         */
                        DeleteAccessLevelRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteAccessLevelRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest} message DeleteAccessLevelRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteAccessLevelRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteAccessLevelRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteAccessLevelRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteAccessLevelRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteAccessLevelRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest";
                        };
    
                        return DeleteAccessLevelRequest;
                    })();
    
                    v1.ReplaceAccessLevelsRequest = (function() {
    
                        /**
                         * Properties of a ReplaceAccessLevelsRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IReplaceAccessLevelsRequest
                         * @property {string|null} [parent] ReplaceAccessLevelsRequest parent
                         * @property {Array.<google.identity.accesscontextmanager.v1.IAccessLevel>|null} [accessLevels] ReplaceAccessLevelsRequest accessLevels
                         * @property {string|null} [etag] ReplaceAccessLevelsRequest etag
                         */
    
                        /**
                         * Constructs a new ReplaceAccessLevelsRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ReplaceAccessLevelsRequest.
                         * @implements IReplaceAccessLevelsRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest=} [properties] Properties to set
                         */
                        function ReplaceAccessLevelsRequest(properties) {
                            this.accessLevels = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ReplaceAccessLevelsRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @instance
                         */
                        ReplaceAccessLevelsRequest.prototype.parent = "";
    
                        /**
                         * ReplaceAccessLevelsRequest accessLevels.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IAccessLevel>} accessLevels
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @instance
                         */
                        ReplaceAccessLevelsRequest.prototype.accessLevels = $util.emptyArray;
    
                        /**
                         * ReplaceAccessLevelsRequest etag.
                         * @member {string} etag
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @instance
                         */
                        ReplaceAccessLevelsRequest.prototype.etag = "";
    
                        /**
                         * Creates a new ReplaceAccessLevelsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest} ReplaceAccessLevelsRequest instance
                         */
                        ReplaceAccessLevelsRequest.create = function create(properties) {
                            return new ReplaceAccessLevelsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ReplaceAccessLevelsRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest} message ReplaceAccessLevelsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceAccessLevelsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.accessLevels != null && message.accessLevels.length)
                                for (var i = 0; i < message.accessLevels.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.AccessLevel.encode(message.accessLevels[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReplaceAccessLevelsRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest} message ReplaceAccessLevelsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceAccessLevelsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReplaceAccessLevelsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest} ReplaceAccessLevelsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceAccessLevelsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.accessLevels && message.accessLevels.length))
                                            message.accessLevels = [];
                                        message.accessLevels.push($root.google.identity.accesscontextmanager.v1.AccessLevel.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 4: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReplaceAccessLevelsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest} ReplaceAccessLevelsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceAccessLevelsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReplaceAccessLevelsRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReplaceAccessLevelsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.accessLevels != null && message.hasOwnProperty("accessLevels")) {
                                if (!Array.isArray(message.accessLevels))
                                    return "accessLevels: array expected";
                                for (var i = 0; i < message.accessLevels.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.AccessLevel.verify(message.accessLevels[i]);
                                    if (error)
                                        return "accessLevels." + error;
                                }
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ReplaceAccessLevelsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest} ReplaceAccessLevelsRequest
                         */
                        ReplaceAccessLevelsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.accessLevels) {
                                if (!Array.isArray(object.accessLevels))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest.accessLevels: array expected");
                                message.accessLevels = [];
                                for (var i = 0; i < object.accessLevels.length; ++i) {
                                    if (typeof object.accessLevels[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest.accessLevels: object expected");
                                    message.accessLevels[i] = $root.google.identity.accesscontextmanager.v1.AccessLevel.fromObject(object.accessLevels[i]);
                                }
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ReplaceAccessLevelsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest} message ReplaceAccessLevelsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReplaceAccessLevelsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.accessLevels = [];
                            if (options.defaults) {
                                object.parent = "";
                                object.etag = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.accessLevels && message.accessLevels.length) {
                                object.accessLevels = [];
                                for (var j = 0; j < message.accessLevels.length; ++j)
                                    object.accessLevels[j] = $root.google.identity.accesscontextmanager.v1.AccessLevel.toObject(message.accessLevels[j], options);
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this ReplaceAccessLevelsRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReplaceAccessLevelsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ReplaceAccessLevelsRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ReplaceAccessLevelsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest";
                        };
    
                        return ReplaceAccessLevelsRequest;
                    })();
    
                    v1.ReplaceAccessLevelsResponse = (function() {
    
                        /**
                         * Properties of a ReplaceAccessLevelsResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IReplaceAccessLevelsResponse
                         * @property {Array.<google.identity.accesscontextmanager.v1.IAccessLevel>|null} [accessLevels] ReplaceAccessLevelsResponse accessLevels
                         */
    
                        /**
                         * Constructs a new ReplaceAccessLevelsResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ReplaceAccessLevelsResponse.
                         * @implements IReplaceAccessLevelsResponse
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse=} [properties] Properties to set
                         */
                        function ReplaceAccessLevelsResponse(properties) {
                            this.accessLevels = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ReplaceAccessLevelsResponse accessLevels.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IAccessLevel>} accessLevels
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @instance
                         */
                        ReplaceAccessLevelsResponse.prototype.accessLevels = $util.emptyArray;
    
                        /**
                         * Creates a new ReplaceAccessLevelsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse} ReplaceAccessLevelsResponse instance
                         */
                        ReplaceAccessLevelsResponse.create = function create(properties) {
                            return new ReplaceAccessLevelsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ReplaceAccessLevelsResponse message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse} message ReplaceAccessLevelsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceAccessLevelsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.accessLevels != null && message.accessLevels.length)
                                for (var i = 0; i < message.accessLevels.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.AccessLevel.encode(message.accessLevels[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReplaceAccessLevelsResponse message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse} message ReplaceAccessLevelsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceAccessLevelsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReplaceAccessLevelsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse} ReplaceAccessLevelsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceAccessLevelsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.accessLevels && message.accessLevels.length))
                                            message.accessLevels = [];
                                        message.accessLevels.push($root.google.identity.accesscontextmanager.v1.AccessLevel.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReplaceAccessLevelsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse} ReplaceAccessLevelsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceAccessLevelsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReplaceAccessLevelsResponse message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReplaceAccessLevelsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.accessLevels != null && message.hasOwnProperty("accessLevels")) {
                                if (!Array.isArray(message.accessLevels))
                                    return "accessLevels: array expected";
                                for (var i = 0; i < message.accessLevels.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.AccessLevel.verify(message.accessLevels[i]);
                                    if (error)
                                        return "accessLevels." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ReplaceAccessLevelsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse} ReplaceAccessLevelsResponse
                         */
                        ReplaceAccessLevelsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse();
                            if (object.accessLevels) {
                                if (!Array.isArray(object.accessLevels))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse.accessLevels: array expected");
                                message.accessLevels = [];
                                for (var i = 0; i < object.accessLevels.length; ++i) {
                                    if (typeof object.accessLevels[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse.accessLevels: object expected");
                                    message.accessLevels[i] = $root.google.identity.accesscontextmanager.v1.AccessLevel.fromObject(object.accessLevels[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ReplaceAccessLevelsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse} message ReplaceAccessLevelsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReplaceAccessLevelsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.accessLevels = [];
                            if (message.accessLevels && message.accessLevels.length) {
                                object.accessLevels = [];
                                for (var j = 0; j < message.accessLevels.length; ++j)
                                    object.accessLevels[j] = $root.google.identity.accesscontextmanager.v1.AccessLevel.toObject(message.accessLevels[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ReplaceAccessLevelsResponse to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReplaceAccessLevelsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ReplaceAccessLevelsResponse
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ReplaceAccessLevelsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse";
                        };
    
                        return ReplaceAccessLevelsResponse;
                    })();
    
                    v1.ListServicePerimetersRequest = (function() {
    
                        /**
                         * Properties of a ListServicePerimetersRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListServicePerimetersRequest
                         * @property {string|null} [parent] ListServicePerimetersRequest parent
                         * @property {number|null} [pageSize] ListServicePerimetersRequest pageSize
                         * @property {string|null} [pageToken] ListServicePerimetersRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListServicePerimetersRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListServicePerimetersRequest.
                         * @implements IListServicePerimetersRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersRequest=} [properties] Properties to set
                         */
                        function ListServicePerimetersRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListServicePerimetersRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @instance
                         */
                        ListServicePerimetersRequest.prototype.parent = "";
    
                        /**
                         * ListServicePerimetersRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @instance
                         */
                        ListServicePerimetersRequest.prototype.pageSize = 0;
    
                        /**
                         * ListServicePerimetersRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @instance
                         */
                        ListServicePerimetersRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListServicePerimetersRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersRequest} ListServicePerimetersRequest instance
                         */
                        ListServicePerimetersRequest.create = function create(properties) {
                            return new ListServicePerimetersRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListServicePerimetersRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListServicePerimetersRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersRequest} message ListServicePerimetersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicePerimetersRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListServicePerimetersRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListServicePerimetersRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersRequest} message ListServicePerimetersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicePerimetersRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListServicePerimetersRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersRequest} ListServicePerimetersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicePerimetersRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListServicePerimetersRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersRequest} ListServicePerimetersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicePerimetersRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListServicePerimetersRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListServicePerimetersRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListServicePerimetersRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersRequest} ListServicePerimetersRequest
                         */
                        ListServicePerimetersRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListServicePerimetersRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListServicePerimetersRequest} message ListServicePerimetersRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListServicePerimetersRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListServicePerimetersRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListServicePerimetersRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListServicePerimetersRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListServicePerimetersRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListServicePerimetersRequest";
                        };
    
                        return ListServicePerimetersRequest;
                    })();
    
                    v1.ListServicePerimetersResponse = (function() {
    
                        /**
                         * Properties of a ListServicePerimetersResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListServicePerimetersResponse
                         * @property {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>|null} [servicePerimeters] ListServicePerimetersResponse servicePerimeters
                         * @property {string|null} [nextPageToken] ListServicePerimetersResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListServicePerimetersResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListServicePerimetersResponse.
                         * @implements IListServicePerimetersResponse
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersResponse=} [properties] Properties to set
                         */
                        function ListServicePerimetersResponse(properties) {
                            this.servicePerimeters = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListServicePerimetersResponse servicePerimeters.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>} servicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @instance
                         */
                        ListServicePerimetersResponse.prototype.servicePerimeters = $util.emptyArray;
    
                        /**
                         * ListServicePerimetersResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @instance
                         */
                        ListServicePerimetersResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListServicePerimetersResponse instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersResponse=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersResponse} ListServicePerimetersResponse instance
                         */
                        ListServicePerimetersResponse.create = function create(properties) {
                            return new ListServicePerimetersResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListServicePerimetersResponse message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListServicePerimetersResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersResponse} message ListServicePerimetersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicePerimetersResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.servicePerimeters != null && message.servicePerimeters.length)
                                for (var i = 0; i < message.servicePerimeters.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeter.encode(message.servicePerimeters[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListServicePerimetersResponse message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListServicePerimetersResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListServicePerimetersResponse} message ListServicePerimetersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicePerimetersResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListServicePerimetersResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersResponse} ListServicePerimetersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicePerimetersResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListServicePerimetersResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.servicePerimeters && message.servicePerimeters.length))
                                            message.servicePerimeters = [];
                                        message.servicePerimeters.push($root.google.identity.accesscontextmanager.v1.ServicePerimeter.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListServicePerimetersResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersResponse} ListServicePerimetersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicePerimetersResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListServicePerimetersResponse message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListServicePerimetersResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.servicePerimeters != null && message.hasOwnProperty("servicePerimeters")) {
                                if (!Array.isArray(message.servicePerimeters))
                                    return "servicePerimeters: array expected";
                                for (var i = 0; i < message.servicePerimeters.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.verify(message.servicePerimeters[i]);
                                    if (error)
                                        return "servicePerimeters." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListServicePerimetersResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListServicePerimetersResponse} ListServicePerimetersResponse
                         */
                        ListServicePerimetersResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListServicePerimetersResponse)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListServicePerimetersResponse();
                            if (object.servicePerimeters) {
                                if (!Array.isArray(object.servicePerimeters))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ListServicePerimetersResponse.servicePerimeters: array expected");
                                message.servicePerimeters = [];
                                for (var i = 0; i < object.servicePerimeters.length; ++i) {
                                    if (typeof object.servicePerimeters[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ListServicePerimetersResponse.servicePerimeters: object expected");
                                    message.servicePerimeters[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.fromObject(object.servicePerimeters[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListServicePerimetersResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListServicePerimetersResponse} message ListServicePerimetersResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListServicePerimetersResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.servicePerimeters = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.servicePerimeters && message.servicePerimeters.length) {
                                object.servicePerimeters = [];
                                for (var j = 0; j < message.servicePerimeters.length; ++j)
                                    object.servicePerimeters[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.toObject(message.servicePerimeters[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListServicePerimetersResponse to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListServicePerimetersResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListServicePerimetersResponse
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListServicePerimetersResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListServicePerimetersResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListServicePerimetersResponse";
                        };
    
                        return ListServicePerimetersResponse;
                    })();
    
                    v1.GetServicePerimeterRequest = (function() {
    
                        /**
                         * Properties of a GetServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IGetServicePerimeterRequest
                         * @property {string|null} [name] GetServicePerimeterRequest name
                         */
    
                        /**
                         * Constructs a new GetServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a GetServicePerimeterRequest.
                         * @implements IGetServicePerimeterRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest=} [properties] Properties to set
                         */
                        function GetServicePerimeterRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetServicePerimeterRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @instance
                         */
                        GetServicePerimeterRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetServicePerimeterRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.GetServicePerimeterRequest} GetServicePerimeterRequest instance
                         */
                        GetServicePerimeterRequest.create = function create(properties) {
                            return new GetServicePerimeterRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetServicePerimeterRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetServicePerimeterRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest} message GetServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServicePerimeterRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetServicePerimeterRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetServicePerimeterRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest} message GetServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServicePerimeterRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetServicePerimeterRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.GetServicePerimeterRequest} GetServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServicePerimeterRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetServicePerimeterRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.GetServicePerimeterRequest} GetServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServicePerimeterRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetServicePerimeterRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetServicePerimeterRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetServicePerimeterRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.GetServicePerimeterRequest} GetServicePerimeterRequest
                         */
                        GetServicePerimeterRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetServicePerimeterRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.GetServicePerimeterRequest} message GetServicePerimeterRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetServicePerimeterRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetServicePerimeterRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetServicePerimeterRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetServicePerimeterRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.GetServicePerimeterRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetServicePerimeterRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.GetServicePerimeterRequest";
                        };
    
                        return GetServicePerimeterRequest;
                    })();
    
                    v1.CreateServicePerimeterRequest = (function() {
    
                        /**
                         * Properties of a CreateServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface ICreateServicePerimeterRequest
                         * @property {string|null} [parent] CreateServicePerimeterRequest parent
                         * @property {google.identity.accesscontextmanager.v1.IServicePerimeter|null} [servicePerimeter] CreateServicePerimeterRequest servicePerimeter
                         */
    
                        /**
                         * Constructs a new CreateServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a CreateServicePerimeterRequest.
                         * @implements ICreateServicePerimeterRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest=} [properties] Properties to set
                         */
                        function CreateServicePerimeterRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateServicePerimeterRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @instance
                         */
                        CreateServicePerimeterRequest.prototype.parent = "";
    
                        /**
                         * CreateServicePerimeterRequest servicePerimeter.
                         * @member {google.identity.accesscontextmanager.v1.IServicePerimeter|null|undefined} servicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @instance
                         */
                        CreateServicePerimeterRequest.prototype.servicePerimeter = null;
    
                        /**
                         * Creates a new CreateServicePerimeterRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest} CreateServicePerimeterRequest instance
                         */
                        CreateServicePerimeterRequest.create = function create(properties) {
                            return new CreateServicePerimeterRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateServicePerimeterRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest} message CreateServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateServicePerimeterRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.servicePerimeter != null && Object.hasOwnProperty.call(message, "servicePerimeter"))
                                $root.google.identity.accesscontextmanager.v1.ServicePerimeter.encode(message.servicePerimeter, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateServicePerimeterRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest} message CreateServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateServicePerimeterRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateServicePerimeterRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest} CreateServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateServicePerimeterRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.servicePerimeter = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateServicePerimeterRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest} CreateServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateServicePerimeterRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateServicePerimeterRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateServicePerimeterRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.servicePerimeter != null && message.hasOwnProperty("servicePerimeter")) {
                                var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.verify(message.servicePerimeter);
                                if (error)
                                    return "servicePerimeter." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateServicePerimeterRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest} CreateServicePerimeterRequest
                         */
                        CreateServicePerimeterRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.servicePerimeter != null) {
                                if (typeof object.servicePerimeter !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest.servicePerimeter: object expected");
                                message.servicePerimeter = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.fromObject(object.servicePerimeter);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateServicePerimeterRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest} message CreateServicePerimeterRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateServicePerimeterRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.servicePerimeter = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.servicePerimeter != null && message.hasOwnProperty("servicePerimeter"))
                                object.servicePerimeter = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.toObject(message.servicePerimeter, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateServicePerimeterRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateServicePerimeterRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateServicePerimeterRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateServicePerimeterRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest";
                        };
    
                        return CreateServicePerimeterRequest;
                    })();
    
                    v1.UpdateServicePerimeterRequest = (function() {
    
                        /**
                         * Properties of an UpdateServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IUpdateServicePerimeterRequest
                         * @property {google.identity.accesscontextmanager.v1.IServicePerimeter|null} [servicePerimeter] UpdateServicePerimeterRequest servicePerimeter
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateServicePerimeterRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an UpdateServicePerimeterRequest.
                         * @implements IUpdateServicePerimeterRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest=} [properties] Properties to set
                         */
                        function UpdateServicePerimeterRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateServicePerimeterRequest servicePerimeter.
                         * @member {google.identity.accesscontextmanager.v1.IServicePerimeter|null|undefined} servicePerimeter
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @instance
                         */
                        UpdateServicePerimeterRequest.prototype.servicePerimeter = null;
    
                        /**
                         * UpdateServicePerimeterRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @instance
                         */
                        UpdateServicePerimeterRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateServicePerimeterRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest} UpdateServicePerimeterRequest instance
                         */
                        UpdateServicePerimeterRequest.create = function create(properties) {
                            return new UpdateServicePerimeterRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateServicePerimeterRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest} message UpdateServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateServicePerimeterRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.servicePerimeter != null && Object.hasOwnProperty.call(message, "servicePerimeter"))
                                $root.google.identity.accesscontextmanager.v1.ServicePerimeter.encode(message.servicePerimeter, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateServicePerimeterRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest} message UpdateServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateServicePerimeterRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateServicePerimeterRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest} UpdateServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateServicePerimeterRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.servicePerimeter = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateServicePerimeterRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest} UpdateServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateServicePerimeterRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateServicePerimeterRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateServicePerimeterRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.servicePerimeter != null && message.hasOwnProperty("servicePerimeter")) {
                                var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.verify(message.servicePerimeter);
                                if (error)
                                    return "servicePerimeter." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateServicePerimeterRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest} UpdateServicePerimeterRequest
                         */
                        UpdateServicePerimeterRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest();
                            if (object.servicePerimeter != null) {
                                if (typeof object.servicePerimeter !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest.servicePerimeter: object expected");
                                message.servicePerimeter = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.fromObject(object.servicePerimeter);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateServicePerimeterRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest} message UpdateServicePerimeterRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateServicePerimeterRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.servicePerimeter = null;
                                object.updateMask = null;
                            }
                            if (message.servicePerimeter != null && message.hasOwnProperty("servicePerimeter"))
                                object.servicePerimeter = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.toObject(message.servicePerimeter, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateServicePerimeterRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateServicePerimeterRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateServicePerimeterRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateServicePerimeterRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest";
                        };
    
                        return UpdateServicePerimeterRequest;
                    })();
    
                    v1.DeleteServicePerimeterRequest = (function() {
    
                        /**
                         * Properties of a DeleteServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IDeleteServicePerimeterRequest
                         * @property {string|null} [name] DeleteServicePerimeterRequest name
                         */
    
                        /**
                         * Constructs a new DeleteServicePerimeterRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a DeleteServicePerimeterRequest.
                         * @implements IDeleteServicePerimeterRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest=} [properties] Properties to set
                         */
                        function DeleteServicePerimeterRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteServicePerimeterRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @instance
                         */
                        DeleteServicePerimeterRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteServicePerimeterRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest} DeleteServicePerimeterRequest instance
                         */
                        DeleteServicePerimeterRequest.create = function create(properties) {
                            return new DeleteServicePerimeterRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteServicePerimeterRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest} message DeleteServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteServicePerimeterRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteServicePerimeterRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest} message DeleteServicePerimeterRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteServicePerimeterRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteServicePerimeterRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest} DeleteServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteServicePerimeterRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteServicePerimeterRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest} DeleteServicePerimeterRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteServicePerimeterRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteServicePerimeterRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteServicePerimeterRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteServicePerimeterRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest} DeleteServicePerimeterRequest
                         */
                        DeleteServicePerimeterRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteServicePerimeterRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest} message DeleteServicePerimeterRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteServicePerimeterRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteServicePerimeterRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteServicePerimeterRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteServicePerimeterRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteServicePerimeterRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest";
                        };
    
                        return DeleteServicePerimeterRequest;
                    })();
    
                    v1.ReplaceServicePerimetersRequest = (function() {
    
                        /**
                         * Properties of a ReplaceServicePerimetersRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IReplaceServicePerimetersRequest
                         * @property {string|null} [parent] ReplaceServicePerimetersRequest parent
                         * @property {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>|null} [servicePerimeters] ReplaceServicePerimetersRequest servicePerimeters
                         * @property {string|null} [etag] ReplaceServicePerimetersRequest etag
                         */
    
                        /**
                         * Constructs a new ReplaceServicePerimetersRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ReplaceServicePerimetersRequest.
                         * @implements IReplaceServicePerimetersRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest=} [properties] Properties to set
                         */
                        function ReplaceServicePerimetersRequest(properties) {
                            this.servicePerimeters = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ReplaceServicePerimetersRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @instance
                         */
                        ReplaceServicePerimetersRequest.prototype.parent = "";
    
                        /**
                         * ReplaceServicePerimetersRequest servicePerimeters.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>} servicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @instance
                         */
                        ReplaceServicePerimetersRequest.prototype.servicePerimeters = $util.emptyArray;
    
                        /**
                         * ReplaceServicePerimetersRequest etag.
                         * @member {string} etag
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @instance
                         */
                        ReplaceServicePerimetersRequest.prototype.etag = "";
    
                        /**
                         * Creates a new ReplaceServicePerimetersRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest} ReplaceServicePerimetersRequest instance
                         */
                        ReplaceServicePerimetersRequest.create = function create(properties) {
                            return new ReplaceServicePerimetersRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ReplaceServicePerimetersRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest} message ReplaceServicePerimetersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceServicePerimetersRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.servicePerimeters != null && message.servicePerimeters.length)
                                for (var i = 0; i < message.servicePerimeters.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeter.encode(message.servicePerimeters[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReplaceServicePerimetersRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest} message ReplaceServicePerimetersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceServicePerimetersRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReplaceServicePerimetersRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest} ReplaceServicePerimetersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceServicePerimetersRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.servicePerimeters && message.servicePerimeters.length))
                                            message.servicePerimeters = [];
                                        message.servicePerimeters.push($root.google.identity.accesscontextmanager.v1.ServicePerimeter.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 3: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReplaceServicePerimetersRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest} ReplaceServicePerimetersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceServicePerimetersRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReplaceServicePerimetersRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReplaceServicePerimetersRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.servicePerimeters != null && message.hasOwnProperty("servicePerimeters")) {
                                if (!Array.isArray(message.servicePerimeters))
                                    return "servicePerimeters: array expected";
                                for (var i = 0; i < message.servicePerimeters.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.verify(message.servicePerimeters[i]);
                                    if (error)
                                        return "servicePerimeters." + error;
                                }
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ReplaceServicePerimetersRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest} ReplaceServicePerimetersRequest
                         */
                        ReplaceServicePerimetersRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.servicePerimeters) {
                                if (!Array.isArray(object.servicePerimeters))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest.servicePerimeters: array expected");
                                message.servicePerimeters = [];
                                for (var i = 0; i < object.servicePerimeters.length; ++i) {
                                    if (typeof object.servicePerimeters[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest.servicePerimeters: object expected");
                                    message.servicePerimeters[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.fromObject(object.servicePerimeters[i]);
                                }
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ReplaceServicePerimetersRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest} message ReplaceServicePerimetersRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReplaceServicePerimetersRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.servicePerimeters = [];
                            if (options.defaults) {
                                object.parent = "";
                                object.etag = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.servicePerimeters && message.servicePerimeters.length) {
                                object.servicePerimeters = [];
                                for (var j = 0; j < message.servicePerimeters.length; ++j)
                                    object.servicePerimeters[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.toObject(message.servicePerimeters[j], options);
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this ReplaceServicePerimetersRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReplaceServicePerimetersRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ReplaceServicePerimetersRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ReplaceServicePerimetersRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest";
                        };
    
                        return ReplaceServicePerimetersRequest;
                    })();
    
                    v1.ReplaceServicePerimetersResponse = (function() {
    
                        /**
                         * Properties of a ReplaceServicePerimetersResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IReplaceServicePerimetersResponse
                         * @property {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>|null} [servicePerimeters] ReplaceServicePerimetersResponse servicePerimeters
                         */
    
                        /**
                         * Constructs a new ReplaceServicePerimetersResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ReplaceServicePerimetersResponse.
                         * @implements IReplaceServicePerimetersResponse
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse=} [properties] Properties to set
                         */
                        function ReplaceServicePerimetersResponse(properties) {
                            this.servicePerimeters = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ReplaceServicePerimetersResponse servicePerimeters.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>} servicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @instance
                         */
                        ReplaceServicePerimetersResponse.prototype.servicePerimeters = $util.emptyArray;
    
                        /**
                         * Creates a new ReplaceServicePerimetersResponse instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse} ReplaceServicePerimetersResponse instance
                         */
                        ReplaceServicePerimetersResponse.create = function create(properties) {
                            return new ReplaceServicePerimetersResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ReplaceServicePerimetersResponse message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse} message ReplaceServicePerimetersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceServicePerimetersResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.servicePerimeters != null && message.servicePerimeters.length)
                                for (var i = 0; i < message.servicePerimeters.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeter.encode(message.servicePerimeters[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ReplaceServicePerimetersResponse message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse} message ReplaceServicePerimetersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ReplaceServicePerimetersResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ReplaceServicePerimetersResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse} ReplaceServicePerimetersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceServicePerimetersResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.servicePerimeters && message.servicePerimeters.length))
                                            message.servicePerimeters = [];
                                        message.servicePerimeters.push($root.google.identity.accesscontextmanager.v1.ServicePerimeter.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ReplaceServicePerimetersResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse} ReplaceServicePerimetersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ReplaceServicePerimetersResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ReplaceServicePerimetersResponse message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ReplaceServicePerimetersResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.servicePerimeters != null && message.hasOwnProperty("servicePerimeters")) {
                                if (!Array.isArray(message.servicePerimeters))
                                    return "servicePerimeters: array expected";
                                for (var i = 0; i < message.servicePerimeters.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.verify(message.servicePerimeters[i]);
                                    if (error)
                                        return "servicePerimeters." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ReplaceServicePerimetersResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse} ReplaceServicePerimetersResponse
                         */
                        ReplaceServicePerimetersResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse();
                            if (object.servicePerimeters) {
                                if (!Array.isArray(object.servicePerimeters))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse.servicePerimeters: array expected");
                                message.servicePerimeters = [];
                                for (var i = 0; i < object.servicePerimeters.length; ++i) {
                                    if (typeof object.servicePerimeters[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse.servicePerimeters: object expected");
                                    message.servicePerimeters[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.fromObject(object.servicePerimeters[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ReplaceServicePerimetersResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse} message ReplaceServicePerimetersResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ReplaceServicePerimetersResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.servicePerimeters = [];
                            if (message.servicePerimeters && message.servicePerimeters.length) {
                                object.servicePerimeters = [];
                                for (var j = 0; j < message.servicePerimeters.length; ++j)
                                    object.servicePerimeters[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.toObject(message.servicePerimeters[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ReplaceServicePerimetersResponse to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ReplaceServicePerimetersResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ReplaceServicePerimetersResponse
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ReplaceServicePerimetersResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse";
                        };
    
                        return ReplaceServicePerimetersResponse;
                    })();
    
                    v1.CommitServicePerimetersRequest = (function() {
    
                        /**
                         * Properties of a CommitServicePerimetersRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface ICommitServicePerimetersRequest
                         * @property {string|null} [parent] CommitServicePerimetersRequest parent
                         * @property {string|null} [etag] CommitServicePerimetersRequest etag
                         */
    
                        /**
                         * Constructs a new CommitServicePerimetersRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a CommitServicePerimetersRequest.
                         * @implements ICommitServicePerimetersRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest=} [properties] Properties to set
                         */
                        function CommitServicePerimetersRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CommitServicePerimetersRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @instance
                         */
                        CommitServicePerimetersRequest.prototype.parent = "";
    
                        /**
                         * CommitServicePerimetersRequest etag.
                         * @member {string} etag
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @instance
                         */
                        CommitServicePerimetersRequest.prototype.etag = "";
    
                        /**
                         * Creates a new CommitServicePerimetersRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest} CommitServicePerimetersRequest instance
                         */
                        CommitServicePerimetersRequest.create = function create(properties) {
                            return new CommitServicePerimetersRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CommitServicePerimetersRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest} message CommitServicePerimetersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CommitServicePerimetersRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CommitServicePerimetersRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest} message CommitServicePerimetersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CommitServicePerimetersRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CommitServicePerimetersRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest} CommitServicePerimetersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CommitServicePerimetersRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CommitServicePerimetersRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest} CommitServicePerimetersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CommitServicePerimetersRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CommitServicePerimetersRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CommitServicePerimetersRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a CommitServicePerimetersRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest} CommitServicePerimetersRequest
                         */
                        CommitServicePerimetersRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CommitServicePerimetersRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest} message CommitServicePerimetersRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CommitServicePerimetersRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.etag = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this CommitServicePerimetersRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CommitServicePerimetersRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CommitServicePerimetersRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CommitServicePerimetersRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest";
                        };
    
                        return CommitServicePerimetersRequest;
                    })();
    
                    v1.CommitServicePerimetersResponse = (function() {
    
                        /**
                         * Properties of a CommitServicePerimetersResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface ICommitServicePerimetersResponse
                         * @property {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>|null} [servicePerimeters] CommitServicePerimetersResponse servicePerimeters
                         */
    
                        /**
                         * Constructs a new CommitServicePerimetersResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a CommitServicePerimetersResponse.
                         * @implements ICommitServicePerimetersResponse
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse=} [properties] Properties to set
                         */
                        function CommitServicePerimetersResponse(properties) {
                            this.servicePerimeters = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CommitServicePerimetersResponse servicePerimeters.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IServicePerimeter>} servicePerimeters
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @instance
                         */
                        CommitServicePerimetersResponse.prototype.servicePerimeters = $util.emptyArray;
    
                        /**
                         * Creates a new CommitServicePerimetersResponse instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse} CommitServicePerimetersResponse instance
                         */
                        CommitServicePerimetersResponse.create = function create(properties) {
                            return new CommitServicePerimetersResponse(properties);
                        };
    
                        /**
                         * Encodes the specified CommitServicePerimetersResponse message. Does not implicitly {@link google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse} message CommitServicePerimetersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CommitServicePerimetersResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.servicePerimeters != null && message.servicePerimeters.length)
                                for (var i = 0; i < message.servicePerimeters.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeter.encode(message.servicePerimeters[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CommitServicePerimetersResponse message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse} message CommitServicePerimetersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CommitServicePerimetersResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CommitServicePerimetersResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse} CommitServicePerimetersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CommitServicePerimetersResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.servicePerimeters && message.servicePerimeters.length))
                                            message.servicePerimeters = [];
                                        message.servicePerimeters.push($root.google.identity.accesscontextmanager.v1.ServicePerimeter.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CommitServicePerimetersResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse} CommitServicePerimetersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CommitServicePerimetersResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CommitServicePerimetersResponse message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CommitServicePerimetersResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.servicePerimeters != null && message.hasOwnProperty("servicePerimeters")) {
                                if (!Array.isArray(message.servicePerimeters))
                                    return "servicePerimeters: array expected";
                                for (var i = 0; i < message.servicePerimeters.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.verify(message.servicePerimeters[i]);
                                    if (error)
                                        return "servicePerimeters." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CommitServicePerimetersResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse} CommitServicePerimetersResponse
                         */
                        CommitServicePerimetersResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse();
                            if (object.servicePerimeters) {
                                if (!Array.isArray(object.servicePerimeters))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse.servicePerimeters: array expected");
                                message.servicePerimeters = [];
                                for (var i = 0; i < object.servicePerimeters.length; ++i) {
                                    if (typeof object.servicePerimeters[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse.servicePerimeters: object expected");
                                    message.servicePerimeters[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.fromObject(object.servicePerimeters[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CommitServicePerimetersResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse} message CommitServicePerimetersResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CommitServicePerimetersResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.servicePerimeters = [];
                            if (message.servicePerimeters && message.servicePerimeters.length) {
                                object.servicePerimeters = [];
                                for (var j = 0; j < message.servicePerimeters.length; ++j)
                                    object.servicePerimeters[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeter.toObject(message.servicePerimeters[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this CommitServicePerimetersResponse to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CommitServicePerimetersResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CommitServicePerimetersResponse
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CommitServicePerimetersResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse";
                        };
    
                        return CommitServicePerimetersResponse;
                    })();
    
                    v1.ListGcpUserAccessBindingsRequest = (function() {
    
                        /**
                         * Properties of a ListGcpUserAccessBindingsRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListGcpUserAccessBindingsRequest
                         * @property {string|null} [parent] ListGcpUserAccessBindingsRequest parent
                         * @property {number|null} [pageSize] ListGcpUserAccessBindingsRequest pageSize
                         * @property {string|null} [pageToken] ListGcpUserAccessBindingsRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListGcpUserAccessBindingsRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListGcpUserAccessBindingsRequest.
                         * @implements IListGcpUserAccessBindingsRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest=} [properties] Properties to set
                         */
                        function ListGcpUserAccessBindingsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListGcpUserAccessBindingsRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @instance
                         */
                        ListGcpUserAccessBindingsRequest.prototype.parent = "";
    
                        /**
                         * ListGcpUserAccessBindingsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @instance
                         */
                        ListGcpUserAccessBindingsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListGcpUserAccessBindingsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @instance
                         */
                        ListGcpUserAccessBindingsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListGcpUserAccessBindingsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest} ListGcpUserAccessBindingsRequest instance
                         */
                        ListGcpUserAccessBindingsRequest.create = function create(properties) {
                            return new ListGcpUserAccessBindingsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListGcpUserAccessBindingsRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest} message ListGcpUserAccessBindingsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGcpUserAccessBindingsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListGcpUserAccessBindingsRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest} message ListGcpUserAccessBindingsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGcpUserAccessBindingsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListGcpUserAccessBindingsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest} ListGcpUserAccessBindingsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGcpUserAccessBindingsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.pageSize = reader.int32();
                                        break;
                                    }
                                case 3: {
                                        message.pageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListGcpUserAccessBindingsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest} ListGcpUserAccessBindingsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGcpUserAccessBindingsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListGcpUserAccessBindingsRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListGcpUserAccessBindingsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListGcpUserAccessBindingsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest} ListGcpUserAccessBindingsRequest
                         */
                        ListGcpUserAccessBindingsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListGcpUserAccessBindingsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest} message ListGcpUserAccessBindingsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListGcpUserAccessBindingsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListGcpUserAccessBindingsRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListGcpUserAccessBindingsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListGcpUserAccessBindingsRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListGcpUserAccessBindingsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest";
                        };
    
                        return ListGcpUserAccessBindingsRequest;
                    })();
    
                    /**
                     * LevelFormat enum.
                     * @name google.identity.accesscontextmanager.v1.LevelFormat
                     * @enum {number}
                     * @property {number} LEVEL_FORMAT_UNSPECIFIED=0 LEVEL_FORMAT_UNSPECIFIED value
                     * @property {number} AS_DEFINED=1 AS_DEFINED value
                     * @property {number} CEL=2 CEL value
                     */
                    v1.LevelFormat = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "LEVEL_FORMAT_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "AS_DEFINED"] = 1;
                        values[valuesById[2] = "CEL"] = 2;
                        return values;
                    })();
    
                    v1.ListGcpUserAccessBindingsResponse = (function() {
    
                        /**
                         * Properties of a ListGcpUserAccessBindingsResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IListGcpUserAccessBindingsResponse
                         * @property {Array.<google.identity.accesscontextmanager.v1.IGcpUserAccessBinding>|null} [gcpUserAccessBindings] ListGcpUserAccessBindingsResponse gcpUserAccessBindings
                         * @property {string|null} [nextPageToken] ListGcpUserAccessBindingsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListGcpUserAccessBindingsResponse.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ListGcpUserAccessBindingsResponse.
                         * @implements IListGcpUserAccessBindingsResponse
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse=} [properties] Properties to set
                         */
                        function ListGcpUserAccessBindingsResponse(properties) {
                            this.gcpUserAccessBindings = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListGcpUserAccessBindingsResponse gcpUserAccessBindings.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IGcpUserAccessBinding>} gcpUserAccessBindings
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @instance
                         */
                        ListGcpUserAccessBindingsResponse.prototype.gcpUserAccessBindings = $util.emptyArray;
    
                        /**
                         * ListGcpUserAccessBindingsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @instance
                         */
                        ListGcpUserAccessBindingsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListGcpUserAccessBindingsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse} ListGcpUserAccessBindingsResponse instance
                         */
                        ListGcpUserAccessBindingsResponse.create = function create(properties) {
                            return new ListGcpUserAccessBindingsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListGcpUserAccessBindingsResponse message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse} message ListGcpUserAccessBindingsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGcpUserAccessBindingsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.gcpUserAccessBindings != null && message.gcpUserAccessBindings.length)
                                for (var i = 0; i < message.gcpUserAccessBindings.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.encode(message.gcpUserAccessBindings[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListGcpUserAccessBindingsResponse message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse} message ListGcpUserAccessBindingsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGcpUserAccessBindingsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListGcpUserAccessBindingsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse} ListGcpUserAccessBindingsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGcpUserAccessBindingsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.gcpUserAccessBindings && message.gcpUserAccessBindings.length))
                                            message.gcpUserAccessBindings = [];
                                        message.gcpUserAccessBindings.push($root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.nextPageToken = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListGcpUserAccessBindingsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse} ListGcpUserAccessBindingsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGcpUserAccessBindingsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListGcpUserAccessBindingsResponse message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListGcpUserAccessBindingsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.gcpUserAccessBindings != null && message.hasOwnProperty("gcpUserAccessBindings")) {
                                if (!Array.isArray(message.gcpUserAccessBindings))
                                    return "gcpUserAccessBindings: array expected";
                                for (var i = 0; i < message.gcpUserAccessBindings.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.verify(message.gcpUserAccessBindings[i]);
                                    if (error)
                                        return "gcpUserAccessBindings." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListGcpUserAccessBindingsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse} ListGcpUserAccessBindingsResponse
                         */
                        ListGcpUserAccessBindingsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse();
                            if (object.gcpUserAccessBindings) {
                                if (!Array.isArray(object.gcpUserAccessBindings))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.gcpUserAccessBindings: array expected");
                                message.gcpUserAccessBindings = [];
                                for (var i = 0; i < object.gcpUserAccessBindings.length; ++i) {
                                    if (typeof object.gcpUserAccessBindings[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.gcpUserAccessBindings: object expected");
                                    message.gcpUserAccessBindings[i] = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.fromObject(object.gcpUserAccessBindings[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListGcpUserAccessBindingsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse} message ListGcpUserAccessBindingsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListGcpUserAccessBindingsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.gcpUserAccessBindings = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.gcpUserAccessBindings && message.gcpUserAccessBindings.length) {
                                object.gcpUserAccessBindings = [];
                                for (var j = 0; j < message.gcpUserAccessBindings.length; ++j)
                                    object.gcpUserAccessBindings[j] = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.toObject(message.gcpUserAccessBindings[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListGcpUserAccessBindingsResponse to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListGcpUserAccessBindingsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ListGcpUserAccessBindingsResponse
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ListGcpUserAccessBindingsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse";
                        };
    
                        return ListGcpUserAccessBindingsResponse;
                    })();
    
                    v1.GetGcpUserAccessBindingRequest = (function() {
    
                        /**
                         * Properties of a GetGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IGetGcpUserAccessBindingRequest
                         * @property {string|null} [name] GetGcpUserAccessBindingRequest name
                         */
    
                        /**
                         * Constructs a new GetGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a GetGcpUserAccessBindingRequest.
                         * @implements IGetGcpUserAccessBindingRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest=} [properties] Properties to set
                         */
                        function GetGcpUserAccessBindingRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetGcpUserAccessBindingRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @instance
                         */
                        GetGcpUserAccessBindingRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetGcpUserAccessBindingRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest} GetGcpUserAccessBindingRequest instance
                         */
                        GetGcpUserAccessBindingRequest.create = function create(properties) {
                            return new GetGcpUserAccessBindingRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetGcpUserAccessBindingRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest} message GetGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetGcpUserAccessBindingRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetGcpUserAccessBindingRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest} message GetGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetGcpUserAccessBindingRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetGcpUserAccessBindingRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest} GetGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetGcpUserAccessBindingRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetGcpUserAccessBindingRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest} GetGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetGcpUserAccessBindingRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetGcpUserAccessBindingRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetGcpUserAccessBindingRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetGcpUserAccessBindingRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest} GetGcpUserAccessBindingRequest
                         */
                        GetGcpUserAccessBindingRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetGcpUserAccessBindingRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest} message GetGcpUserAccessBindingRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetGcpUserAccessBindingRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetGcpUserAccessBindingRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetGcpUserAccessBindingRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GetGcpUserAccessBindingRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GetGcpUserAccessBindingRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest";
                        };
    
                        return GetGcpUserAccessBindingRequest;
                    })();
    
                    v1.CreateGcpUserAccessBindingRequest = (function() {
    
                        /**
                         * Properties of a CreateGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface ICreateGcpUserAccessBindingRequest
                         * @property {string|null} [parent] CreateGcpUserAccessBindingRequest parent
                         * @property {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding|null} [gcpUserAccessBinding] CreateGcpUserAccessBindingRequest gcpUserAccessBinding
                         */
    
                        /**
                         * Constructs a new CreateGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a CreateGcpUserAccessBindingRequest.
                         * @implements ICreateGcpUserAccessBindingRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest=} [properties] Properties to set
                         */
                        function CreateGcpUserAccessBindingRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateGcpUserAccessBindingRequest parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @instance
                         */
                        CreateGcpUserAccessBindingRequest.prototype.parent = "";
    
                        /**
                         * CreateGcpUserAccessBindingRequest gcpUserAccessBinding.
                         * @member {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding|null|undefined} gcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @instance
                         */
                        CreateGcpUserAccessBindingRequest.prototype.gcpUserAccessBinding = null;
    
                        /**
                         * Creates a new CreateGcpUserAccessBindingRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest} CreateGcpUserAccessBindingRequest instance
                         */
                        CreateGcpUserAccessBindingRequest.create = function create(properties) {
                            return new CreateGcpUserAccessBindingRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateGcpUserAccessBindingRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest} message CreateGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateGcpUserAccessBindingRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.gcpUserAccessBinding != null && Object.hasOwnProperty.call(message, "gcpUserAccessBinding"))
                                $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.encode(message.gcpUserAccessBinding, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateGcpUserAccessBindingRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest} message CreateGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateGcpUserAccessBindingRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateGcpUserAccessBindingRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest} CreateGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateGcpUserAccessBindingRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.gcpUserAccessBinding = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateGcpUserAccessBindingRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest} CreateGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateGcpUserAccessBindingRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateGcpUserAccessBindingRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateGcpUserAccessBindingRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.gcpUserAccessBinding != null && message.hasOwnProperty("gcpUserAccessBinding")) {
                                var error = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.verify(message.gcpUserAccessBinding);
                                if (error)
                                    return "gcpUserAccessBinding." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateGcpUserAccessBindingRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest} CreateGcpUserAccessBindingRequest
                         */
                        CreateGcpUserAccessBindingRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.gcpUserAccessBinding != null) {
                                if (typeof object.gcpUserAccessBinding !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest.gcpUserAccessBinding: object expected");
                                message.gcpUserAccessBinding = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.fromObject(object.gcpUserAccessBinding);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateGcpUserAccessBindingRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest} message CreateGcpUserAccessBindingRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateGcpUserAccessBindingRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.gcpUserAccessBinding = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.gcpUserAccessBinding != null && message.hasOwnProperty("gcpUserAccessBinding"))
                                object.gcpUserAccessBinding = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.toObject(message.gcpUserAccessBinding, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateGcpUserAccessBindingRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateGcpUserAccessBindingRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CreateGcpUserAccessBindingRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CreateGcpUserAccessBindingRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest";
                        };
    
                        return CreateGcpUserAccessBindingRequest;
                    })();
    
                    v1.UpdateGcpUserAccessBindingRequest = (function() {
    
                        /**
                         * Properties of an UpdateGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IUpdateGcpUserAccessBindingRequest
                         * @property {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding|null} [gcpUserAccessBinding] UpdateGcpUserAccessBindingRequest gcpUserAccessBinding
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateGcpUserAccessBindingRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an UpdateGcpUserAccessBindingRequest.
                         * @implements IUpdateGcpUserAccessBindingRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest=} [properties] Properties to set
                         */
                        function UpdateGcpUserAccessBindingRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateGcpUserAccessBindingRequest gcpUserAccessBinding.
                         * @member {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding|null|undefined} gcpUserAccessBinding
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @instance
                         */
                        UpdateGcpUserAccessBindingRequest.prototype.gcpUserAccessBinding = null;
    
                        /**
                         * UpdateGcpUserAccessBindingRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @instance
                         */
                        UpdateGcpUserAccessBindingRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateGcpUserAccessBindingRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest} UpdateGcpUserAccessBindingRequest instance
                         */
                        UpdateGcpUserAccessBindingRequest.create = function create(properties) {
                            return new UpdateGcpUserAccessBindingRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateGcpUserAccessBindingRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest} message UpdateGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateGcpUserAccessBindingRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.gcpUserAccessBinding != null && Object.hasOwnProperty.call(message, "gcpUserAccessBinding"))
                                $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.encode(message.gcpUserAccessBinding, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateGcpUserAccessBindingRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest} message UpdateGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateGcpUserAccessBindingRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateGcpUserAccessBindingRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest} UpdateGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateGcpUserAccessBindingRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.gcpUserAccessBinding = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 2: {
                                        message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateGcpUserAccessBindingRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest} UpdateGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateGcpUserAccessBindingRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateGcpUserAccessBindingRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateGcpUserAccessBindingRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.gcpUserAccessBinding != null && message.hasOwnProperty("gcpUserAccessBinding")) {
                                var error = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.verify(message.gcpUserAccessBinding);
                                if (error)
                                    return "gcpUserAccessBinding." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateGcpUserAccessBindingRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest} UpdateGcpUserAccessBindingRequest
                         */
                        UpdateGcpUserAccessBindingRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest();
                            if (object.gcpUserAccessBinding != null) {
                                if (typeof object.gcpUserAccessBinding !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest.gcpUserAccessBinding: object expected");
                                message.gcpUserAccessBinding = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.fromObject(object.gcpUserAccessBinding);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateGcpUserAccessBindingRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest} message UpdateGcpUserAccessBindingRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateGcpUserAccessBindingRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.gcpUserAccessBinding = null;
                                object.updateMask = null;
                            }
                            if (message.gcpUserAccessBinding != null && message.hasOwnProperty("gcpUserAccessBinding"))
                                object.gcpUserAccessBinding = $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding.toObject(message.gcpUserAccessBinding, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateGcpUserAccessBindingRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateGcpUserAccessBindingRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for UpdateGcpUserAccessBindingRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        UpdateGcpUserAccessBindingRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest";
                        };
    
                        return UpdateGcpUserAccessBindingRequest;
                    })();
    
                    v1.DeleteGcpUserAccessBindingRequest = (function() {
    
                        /**
                         * Properties of a DeleteGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IDeleteGcpUserAccessBindingRequest
                         * @property {string|null} [name] DeleteGcpUserAccessBindingRequest name
                         */
    
                        /**
                         * Constructs a new DeleteGcpUserAccessBindingRequest.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a DeleteGcpUserAccessBindingRequest.
                         * @implements IDeleteGcpUserAccessBindingRequest
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest=} [properties] Properties to set
                         */
                        function DeleteGcpUserAccessBindingRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteGcpUserAccessBindingRequest name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @instance
                         */
                        DeleteGcpUserAccessBindingRequest.prototype.name = "";
    
                        /**
                         * Creates a new DeleteGcpUserAccessBindingRequest instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest} DeleteGcpUserAccessBindingRequest instance
                         */
                        DeleteGcpUserAccessBindingRequest.create = function create(properties) {
                            return new DeleteGcpUserAccessBindingRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteGcpUserAccessBindingRequest message. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest} message DeleteGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGcpUserAccessBindingRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteGcpUserAccessBindingRequest message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest} message DeleteGcpUserAccessBindingRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGcpUserAccessBindingRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteGcpUserAccessBindingRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest} DeleteGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGcpUserAccessBindingRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteGcpUserAccessBindingRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest} DeleteGcpUserAccessBindingRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGcpUserAccessBindingRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteGcpUserAccessBindingRequest message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteGcpUserAccessBindingRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteGcpUserAccessBindingRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest} DeleteGcpUserAccessBindingRequest
                         */
                        DeleteGcpUserAccessBindingRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteGcpUserAccessBindingRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest} message DeleteGcpUserAccessBindingRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteGcpUserAccessBindingRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteGcpUserAccessBindingRequest to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteGcpUserAccessBindingRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DeleteGcpUserAccessBindingRequest
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DeleteGcpUserAccessBindingRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest";
                        };
    
                        return DeleteGcpUserAccessBindingRequest;
                    })();
    
                    v1.GcpUserAccessBindingOperationMetadata = (function() {
    
                        /**
                         * Properties of a GcpUserAccessBindingOperationMetadata.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IGcpUserAccessBindingOperationMetadata
                         */
    
                        /**
                         * Constructs a new GcpUserAccessBindingOperationMetadata.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a GcpUserAccessBindingOperationMetadata.
                         * @implements IGcpUserAccessBindingOperationMetadata
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata=} [properties] Properties to set
                         */
                        function GcpUserAccessBindingOperationMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new GcpUserAccessBindingOperationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata} GcpUserAccessBindingOperationMetadata instance
                         */
                        GcpUserAccessBindingOperationMetadata.create = function create(properties) {
                            return new GcpUserAccessBindingOperationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified GcpUserAccessBindingOperationMetadata message. Does not implicitly {@link google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata} message GcpUserAccessBindingOperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcpUserAccessBindingOperationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GcpUserAccessBindingOperationMetadata message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata} message GcpUserAccessBindingOperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcpUserAccessBindingOperationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GcpUserAccessBindingOperationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata} GcpUserAccessBindingOperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcpUserAccessBindingOperationMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GcpUserAccessBindingOperationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata} GcpUserAccessBindingOperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcpUserAccessBindingOperationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GcpUserAccessBindingOperationMetadata message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GcpUserAccessBindingOperationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a GcpUserAccessBindingOperationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata} GcpUserAccessBindingOperationMetadata
                         */
                        GcpUserAccessBindingOperationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata)
                                return object;
                            return new $root.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata();
                        };
    
                        /**
                         * Creates a plain object from a GcpUserAccessBindingOperationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata} message GcpUserAccessBindingOperationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GcpUserAccessBindingOperationMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this GcpUserAccessBindingOperationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GcpUserAccessBindingOperationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GcpUserAccessBindingOperationMetadata
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GcpUserAccessBindingOperationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata";
                        };
    
                        return GcpUserAccessBindingOperationMetadata;
                    })();
    
                    v1.AccessContextManagerOperationMetadata = (function() {
    
                        /**
                         * Properties of an AccessContextManagerOperationMetadata.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IAccessContextManagerOperationMetadata
                         */
    
                        /**
                         * Constructs a new AccessContextManagerOperationMetadata.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an AccessContextManagerOperationMetadata.
                         * @implements IAccessContextManagerOperationMetadata
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata=} [properties] Properties to set
                         */
                        function AccessContextManagerOperationMetadata(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new AccessContextManagerOperationMetadata instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata} AccessContextManagerOperationMetadata instance
                         */
                        AccessContextManagerOperationMetadata.create = function create(properties) {
                            return new AccessContextManagerOperationMetadata(properties);
                        };
    
                        /**
                         * Encodes the specified AccessContextManagerOperationMetadata message. Does not implicitly {@link google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata} message AccessContextManagerOperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessContextManagerOperationMetadata.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AccessContextManagerOperationMetadata message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata} message AccessContextManagerOperationMetadata message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessContextManagerOperationMetadata.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AccessContextManagerOperationMetadata message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata} AccessContextManagerOperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessContextManagerOperationMetadata.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AccessContextManagerOperationMetadata message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata} AccessContextManagerOperationMetadata
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessContextManagerOperationMetadata.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AccessContextManagerOperationMetadata message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AccessContextManagerOperationMetadata.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates an AccessContextManagerOperationMetadata message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata} AccessContextManagerOperationMetadata
                         */
                        AccessContextManagerOperationMetadata.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata)
                                return object;
                            return new $root.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata();
                        };
    
                        /**
                         * Creates a plain object from an AccessContextManagerOperationMetadata message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata} message AccessContextManagerOperationMetadata
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AccessContextManagerOperationMetadata.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this AccessContextManagerOperationMetadata to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AccessContextManagerOperationMetadata.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AccessContextManagerOperationMetadata
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AccessContextManagerOperationMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata";
                        };
    
                        return AccessContextManagerOperationMetadata;
                    })();
    
                    v1.AccessLevel = (function() {
    
                        /**
                         * Properties of an AccessLevel.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IAccessLevel
                         * @property {string|null} [name] AccessLevel name
                         * @property {string|null} [title] AccessLevel title
                         * @property {string|null} [description] AccessLevel description
                         * @property {google.identity.accesscontextmanager.v1.IBasicLevel|null} [basic] AccessLevel basic
                         * @property {google.identity.accesscontextmanager.v1.ICustomLevel|null} [custom] AccessLevel custom
                         * @property {google.protobuf.ITimestamp|null} [createTime] AccessLevel createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] AccessLevel updateTime
                         */
    
                        /**
                         * Constructs a new AccessLevel.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an AccessLevel.
                         * @implements IAccessLevel
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IAccessLevel=} [properties] Properties to set
                         */
                        function AccessLevel(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AccessLevel name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        AccessLevel.prototype.name = "";
    
                        /**
                         * AccessLevel title.
                         * @member {string} title
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        AccessLevel.prototype.title = "";
    
                        /**
                         * AccessLevel description.
                         * @member {string} description
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        AccessLevel.prototype.description = "";
    
                        /**
                         * AccessLevel basic.
                         * @member {google.identity.accesscontextmanager.v1.IBasicLevel|null|undefined} basic
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        AccessLevel.prototype.basic = null;
    
                        /**
                         * AccessLevel custom.
                         * @member {google.identity.accesscontextmanager.v1.ICustomLevel|null|undefined} custom
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        AccessLevel.prototype.custom = null;
    
                        /**
                         * AccessLevel createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        AccessLevel.prototype.createTime = null;
    
                        /**
                         * AccessLevel updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        AccessLevel.prototype.updateTime = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AccessLevel level.
                         * @member {"basic"|"custom"|undefined} level
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         */
                        Object.defineProperty(AccessLevel.prototype, "level", {
                            get: $util.oneOfGetter($oneOfFields = ["basic", "custom"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AccessLevel instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessLevel=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.AccessLevel} AccessLevel instance
                         */
                        AccessLevel.create = function create(properties) {
                            return new AccessLevel(properties);
                        };
    
                        /**
                         * Encodes the specified AccessLevel message. Does not implicitly {@link google.identity.accesscontextmanager.v1.AccessLevel.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessLevel} message AccessLevel message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessLevel.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.title);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            if (message.basic != null && Object.hasOwnProperty.call(message, "basic"))
                                $root.google.identity.accesscontextmanager.v1.BasicLevel.encode(message.basic, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.custom != null && Object.hasOwnProperty.call(message, "custom"))
                                $root.google.identity.accesscontextmanager.v1.CustomLevel.encode(message.custom, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AccessLevel message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.AccessLevel.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessLevel} message AccessLevel message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessLevel.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AccessLevel message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.AccessLevel} AccessLevel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessLevel.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.AccessLevel();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.title = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.basic = $root.google.identity.accesscontextmanager.v1.BasicLevel.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        message.custom = $root.google.identity.accesscontextmanager.v1.CustomLevel.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 7: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AccessLevel message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.AccessLevel} AccessLevel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessLevel.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AccessLevel message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AccessLevel.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.title != null && message.hasOwnProperty("title"))
                                if (!$util.isString(message.title))
                                    return "title: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.basic != null && message.hasOwnProperty("basic")) {
                                properties.level = 1;
                                {
                                    var error = $root.google.identity.accesscontextmanager.v1.BasicLevel.verify(message.basic);
                                    if (error)
                                        return "basic." + error;
                                }
                            }
                            if (message.custom != null && message.hasOwnProperty("custom")) {
                                if (properties.level === 1)
                                    return "level: multiple values";
                                properties.level = 1;
                                {
                                    var error = $root.google.identity.accesscontextmanager.v1.CustomLevel.verify(message.custom);
                                    if (error)
                                        return "custom." + error;
                                }
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AccessLevel message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.AccessLevel} AccessLevel
                         */
                        AccessLevel.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.AccessLevel)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.AccessLevel();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.title != null)
                                message.title = String(object.title);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.basic != null) {
                                if (typeof object.basic !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.AccessLevel.basic: object expected");
                                message.basic = $root.google.identity.accesscontextmanager.v1.BasicLevel.fromObject(object.basic);
                            }
                            if (object.custom != null) {
                                if (typeof object.custom !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.AccessLevel.custom: object expected");
                                message.custom = $root.google.identity.accesscontextmanager.v1.CustomLevel.fromObject(object.custom);
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.AccessLevel.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.AccessLevel.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AccessLevel message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.AccessLevel} message AccessLevel
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AccessLevel.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.title = "";
                                object.description = "";
                                object.createTime = null;
                                object.updateTime = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.title != null && message.hasOwnProperty("title"))
                                object.title = message.title;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.basic != null && message.hasOwnProperty("basic")) {
                                object.basic = $root.google.identity.accesscontextmanager.v1.BasicLevel.toObject(message.basic, options);
                                if (options.oneofs)
                                    object.level = "basic";
                            }
                            if (message.custom != null && message.hasOwnProperty("custom")) {
                                object.custom = $root.google.identity.accesscontextmanager.v1.CustomLevel.toObject(message.custom, options);
                                if (options.oneofs)
                                    object.level = "custom";
                            }
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            return object;
                        };
    
                        /**
                         * Converts this AccessLevel to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AccessLevel.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AccessLevel
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.AccessLevel
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AccessLevel.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.AccessLevel";
                        };
    
                        return AccessLevel;
                    })();
    
                    v1.BasicLevel = (function() {
    
                        /**
                         * Properties of a BasicLevel.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IBasicLevel
                         * @property {Array.<google.identity.accesscontextmanager.v1.ICondition>|null} [conditions] BasicLevel conditions
                         * @property {google.identity.accesscontextmanager.v1.BasicLevel.ConditionCombiningFunction|null} [combiningFunction] BasicLevel combiningFunction
                         */
    
                        /**
                         * Constructs a new BasicLevel.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a BasicLevel.
                         * @implements IBasicLevel
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IBasicLevel=} [properties] Properties to set
                         */
                        function BasicLevel(properties) {
                            this.conditions = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * BasicLevel conditions.
                         * @member {Array.<google.identity.accesscontextmanager.v1.ICondition>} conditions
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @instance
                         */
                        BasicLevel.prototype.conditions = $util.emptyArray;
    
                        /**
                         * BasicLevel combiningFunction.
                         * @member {google.identity.accesscontextmanager.v1.BasicLevel.ConditionCombiningFunction} combiningFunction
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @instance
                         */
                        BasicLevel.prototype.combiningFunction = 0;
    
                        /**
                         * Creates a new BasicLevel instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IBasicLevel=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.BasicLevel} BasicLevel instance
                         */
                        BasicLevel.create = function create(properties) {
                            return new BasicLevel(properties);
                        };
    
                        /**
                         * Encodes the specified BasicLevel message. Does not implicitly {@link google.identity.accesscontextmanager.v1.BasicLevel.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IBasicLevel} message BasicLevel message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BasicLevel.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.conditions != null && message.conditions.length)
                                for (var i = 0; i < message.conditions.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.Condition.encode(message.conditions[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.combiningFunction != null && Object.hasOwnProperty.call(message, "combiningFunction"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.combiningFunction);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified BasicLevel message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.BasicLevel.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IBasicLevel} message BasicLevel message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        BasicLevel.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a BasicLevel message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.BasicLevel} BasicLevel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BasicLevel.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.BasicLevel();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.conditions && message.conditions.length))
                                            message.conditions = [];
                                        message.conditions.push($root.google.identity.accesscontextmanager.v1.Condition.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 2: {
                                        message.combiningFunction = reader.int32();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a BasicLevel message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.BasicLevel} BasicLevel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        BasicLevel.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a BasicLevel message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        BasicLevel.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.conditions != null && message.hasOwnProperty("conditions")) {
                                if (!Array.isArray(message.conditions))
                                    return "conditions: array expected";
                                for (var i = 0; i < message.conditions.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.Condition.verify(message.conditions[i]);
                                    if (error)
                                        return "conditions." + error;
                                }
                            }
                            if (message.combiningFunction != null && message.hasOwnProperty("combiningFunction"))
                                switch (message.combiningFunction) {
                                default:
                                    return "combiningFunction: enum value expected";
                                case 0:
                                case 1:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a BasicLevel message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.BasicLevel} BasicLevel
                         */
                        BasicLevel.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.BasicLevel)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.BasicLevel();
                            if (object.conditions) {
                                if (!Array.isArray(object.conditions))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.BasicLevel.conditions: array expected");
                                message.conditions = [];
                                for (var i = 0; i < object.conditions.length; ++i) {
                                    if (typeof object.conditions[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.BasicLevel.conditions: object expected");
                                    message.conditions[i] = $root.google.identity.accesscontextmanager.v1.Condition.fromObject(object.conditions[i]);
                                }
                            }
                            switch (object.combiningFunction) {
                            case "AND":
                            case 0:
                                message.combiningFunction = 0;
                                break;
                            case "OR":
                            case 1:
                                message.combiningFunction = 1;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a BasicLevel message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.BasicLevel} message BasicLevel
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        BasicLevel.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.conditions = [];
                            if (options.defaults)
                                object.combiningFunction = options.enums === String ? "AND" : 0;
                            if (message.conditions && message.conditions.length) {
                                object.conditions = [];
                                for (var j = 0; j < message.conditions.length; ++j)
                                    object.conditions[j] = $root.google.identity.accesscontextmanager.v1.Condition.toObject(message.conditions[j], options);
                            }
                            if (message.combiningFunction != null && message.hasOwnProperty("combiningFunction"))
                                object.combiningFunction = options.enums === String ? $root.google.identity.accesscontextmanager.v1.BasicLevel.ConditionCombiningFunction[message.combiningFunction] : message.combiningFunction;
                            return object;
                        };
    
                        /**
                         * Converts this BasicLevel to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        BasicLevel.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for BasicLevel
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.BasicLevel
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        BasicLevel.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.BasicLevel";
                        };
    
                        /**
                         * ConditionCombiningFunction enum.
                         * @name google.identity.accesscontextmanager.v1.BasicLevel.ConditionCombiningFunction
                         * @enum {number}
                         * @property {number} AND=0 AND value
                         * @property {number} OR=1 OR value
                         */
                        BasicLevel.ConditionCombiningFunction = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "AND"] = 0;
                            values[valuesById[1] = "OR"] = 1;
                            return values;
                        })();
    
                        return BasicLevel;
                    })();
    
                    v1.Condition = (function() {
    
                        /**
                         * Properties of a Condition.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface ICondition
                         * @property {Array.<string>|null} [ipSubnetworks] Condition ipSubnetworks
                         * @property {google.identity.accesscontextmanager.v1.IDevicePolicy|null} [devicePolicy] Condition devicePolicy
                         * @property {Array.<string>|null} [requiredAccessLevels] Condition requiredAccessLevels
                         * @property {boolean|null} [negate] Condition negate
                         * @property {Array.<string>|null} [members] Condition members
                         * @property {Array.<string>|null} [regions] Condition regions
                         */
    
                        /**
                         * Constructs a new Condition.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a Condition.
                         * @implements ICondition
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.ICondition=} [properties] Properties to set
                         */
                        function Condition(properties) {
                            this.ipSubnetworks = [];
                            this.requiredAccessLevels = [];
                            this.members = [];
                            this.regions = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Condition ipSubnetworks.
                         * @member {Array.<string>} ipSubnetworks
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @instance
                         */
                        Condition.prototype.ipSubnetworks = $util.emptyArray;
    
                        /**
                         * Condition devicePolicy.
                         * @member {google.identity.accesscontextmanager.v1.IDevicePolicy|null|undefined} devicePolicy
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @instance
                         */
                        Condition.prototype.devicePolicy = null;
    
                        /**
                         * Condition requiredAccessLevels.
                         * @member {Array.<string>} requiredAccessLevels
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @instance
                         */
                        Condition.prototype.requiredAccessLevels = $util.emptyArray;
    
                        /**
                         * Condition negate.
                         * @member {boolean} negate
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @instance
                         */
                        Condition.prototype.negate = false;
    
                        /**
                         * Condition members.
                         * @member {Array.<string>} members
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @instance
                         */
                        Condition.prototype.members = $util.emptyArray;
    
                        /**
                         * Condition regions.
                         * @member {Array.<string>} regions
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @instance
                         */
                        Condition.prototype.regions = $util.emptyArray;
    
                        /**
                         * Creates a new Condition instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICondition=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.Condition} Condition instance
                         */
                        Condition.create = function create(properties) {
                            return new Condition(properties);
                        };
    
                        /**
                         * Encodes the specified Condition message. Does not implicitly {@link google.identity.accesscontextmanager.v1.Condition.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICondition} message Condition message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Condition.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.ipSubnetworks != null && message.ipSubnetworks.length)
                                for (var i = 0; i < message.ipSubnetworks.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.ipSubnetworks[i]);
                            if (message.devicePolicy != null && Object.hasOwnProperty.call(message, "devicePolicy"))
                                $root.google.identity.accesscontextmanager.v1.DevicePolicy.encode(message.devicePolicy, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.requiredAccessLevels != null && message.requiredAccessLevels.length)
                                for (var i = 0; i < message.requiredAccessLevels.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.requiredAccessLevels[i]);
                            if (message.negate != null && Object.hasOwnProperty.call(message, "negate"))
                                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.negate);
                            if (message.members != null && message.members.length)
                                for (var i = 0; i < message.members.length; ++i)
                                    writer.uint32(/* id 6, wireType 2 =*/50).string(message.members[i]);
                            if (message.regions != null && message.regions.length)
                                for (var i = 0; i < message.regions.length; ++i)
                                    writer.uint32(/* id 7, wireType 2 =*/58).string(message.regions[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Condition message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.Condition.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICondition} message Condition message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Condition.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Condition message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.Condition} Condition
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Condition.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.Condition();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.ipSubnetworks && message.ipSubnetworks.length))
                                            message.ipSubnetworks = [];
                                        message.ipSubnetworks.push(reader.string());
                                        break;
                                    }
                                case 2: {
                                        message.devicePolicy = $root.google.identity.accesscontextmanager.v1.DevicePolicy.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 3: {
                                        if (!(message.requiredAccessLevels && message.requiredAccessLevels.length))
                                            message.requiredAccessLevels = [];
                                        message.requiredAccessLevels.push(reader.string());
                                        break;
                                    }
                                case 5: {
                                        message.negate = reader.bool();
                                        break;
                                    }
                                case 6: {
                                        if (!(message.members && message.members.length))
                                            message.members = [];
                                        message.members.push(reader.string());
                                        break;
                                    }
                                case 7: {
                                        if (!(message.regions && message.regions.length))
                                            message.regions = [];
                                        message.regions.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Condition message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.Condition} Condition
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Condition.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Condition message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Condition.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.ipSubnetworks != null && message.hasOwnProperty("ipSubnetworks")) {
                                if (!Array.isArray(message.ipSubnetworks))
                                    return "ipSubnetworks: array expected";
                                for (var i = 0; i < message.ipSubnetworks.length; ++i)
                                    if (!$util.isString(message.ipSubnetworks[i]))
                                        return "ipSubnetworks: string[] expected";
                            }
                            if (message.devicePolicy != null && message.hasOwnProperty("devicePolicy")) {
                                var error = $root.google.identity.accesscontextmanager.v1.DevicePolicy.verify(message.devicePolicy);
                                if (error)
                                    return "devicePolicy." + error;
                            }
                            if (message.requiredAccessLevels != null && message.hasOwnProperty("requiredAccessLevels")) {
                                if (!Array.isArray(message.requiredAccessLevels))
                                    return "requiredAccessLevels: array expected";
                                for (var i = 0; i < message.requiredAccessLevels.length; ++i)
                                    if (!$util.isString(message.requiredAccessLevels[i]))
                                        return "requiredAccessLevels: string[] expected";
                            }
                            if (message.negate != null && message.hasOwnProperty("negate"))
                                if (typeof message.negate !== "boolean")
                                    return "negate: boolean expected";
                            if (message.members != null && message.hasOwnProperty("members")) {
                                if (!Array.isArray(message.members))
                                    return "members: array expected";
                                for (var i = 0; i < message.members.length; ++i)
                                    if (!$util.isString(message.members[i]))
                                        return "members: string[] expected";
                            }
                            if (message.regions != null && message.hasOwnProperty("regions")) {
                                if (!Array.isArray(message.regions))
                                    return "regions: array expected";
                                for (var i = 0; i < message.regions.length; ++i)
                                    if (!$util.isString(message.regions[i]))
                                        return "regions: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Condition message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.Condition} Condition
                         */
                        Condition.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.Condition)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.Condition();
                            if (object.ipSubnetworks) {
                                if (!Array.isArray(object.ipSubnetworks))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.Condition.ipSubnetworks: array expected");
                                message.ipSubnetworks = [];
                                for (var i = 0; i < object.ipSubnetworks.length; ++i)
                                    message.ipSubnetworks[i] = String(object.ipSubnetworks[i]);
                            }
                            if (object.devicePolicy != null) {
                                if (typeof object.devicePolicy !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.Condition.devicePolicy: object expected");
                                message.devicePolicy = $root.google.identity.accesscontextmanager.v1.DevicePolicy.fromObject(object.devicePolicy);
                            }
                            if (object.requiredAccessLevels) {
                                if (!Array.isArray(object.requiredAccessLevels))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.Condition.requiredAccessLevels: array expected");
                                message.requiredAccessLevels = [];
                                for (var i = 0; i < object.requiredAccessLevels.length; ++i)
                                    message.requiredAccessLevels[i] = String(object.requiredAccessLevels[i]);
                            }
                            if (object.negate != null)
                                message.negate = Boolean(object.negate);
                            if (object.members) {
                                if (!Array.isArray(object.members))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.Condition.members: array expected");
                                message.members = [];
                                for (var i = 0; i < object.members.length; ++i)
                                    message.members[i] = String(object.members[i]);
                            }
                            if (object.regions) {
                                if (!Array.isArray(object.regions))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.Condition.regions: array expected");
                                message.regions = [];
                                for (var i = 0; i < object.regions.length; ++i)
                                    message.regions[i] = String(object.regions[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Condition message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.Condition} message Condition
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Condition.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.ipSubnetworks = [];
                                object.requiredAccessLevels = [];
                                object.members = [];
                                object.regions = [];
                            }
                            if (options.defaults) {
                                object.devicePolicy = null;
                                object.negate = false;
                            }
                            if (message.ipSubnetworks && message.ipSubnetworks.length) {
                                object.ipSubnetworks = [];
                                for (var j = 0; j < message.ipSubnetworks.length; ++j)
                                    object.ipSubnetworks[j] = message.ipSubnetworks[j];
                            }
                            if (message.devicePolicy != null && message.hasOwnProperty("devicePolicy"))
                                object.devicePolicy = $root.google.identity.accesscontextmanager.v1.DevicePolicy.toObject(message.devicePolicy, options);
                            if (message.requiredAccessLevels && message.requiredAccessLevels.length) {
                                object.requiredAccessLevels = [];
                                for (var j = 0; j < message.requiredAccessLevels.length; ++j)
                                    object.requiredAccessLevels[j] = message.requiredAccessLevels[j];
                            }
                            if (message.negate != null && message.hasOwnProperty("negate"))
                                object.negate = message.negate;
                            if (message.members && message.members.length) {
                                object.members = [];
                                for (var j = 0; j < message.members.length; ++j)
                                    object.members[j] = message.members[j];
                            }
                            if (message.regions && message.regions.length) {
                                object.regions = [];
                                for (var j = 0; j < message.regions.length; ++j)
                                    object.regions[j] = message.regions[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Condition to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Condition.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for Condition
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.Condition
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        Condition.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.Condition";
                        };
    
                        return Condition;
                    })();
    
                    v1.CustomLevel = (function() {
    
                        /**
                         * Properties of a CustomLevel.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface ICustomLevel
                         * @property {google.type.IExpr|null} [expr] CustomLevel expr
                         */
    
                        /**
                         * Constructs a new CustomLevel.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a CustomLevel.
                         * @implements ICustomLevel
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.ICustomLevel=} [properties] Properties to set
                         */
                        function CustomLevel(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CustomLevel expr.
                         * @member {google.type.IExpr|null|undefined} expr
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @instance
                         */
                        CustomLevel.prototype.expr = null;
    
                        /**
                         * Creates a new CustomLevel instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICustomLevel=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.CustomLevel} CustomLevel instance
                         */
                        CustomLevel.create = function create(properties) {
                            return new CustomLevel(properties);
                        };
    
                        /**
                         * Encodes the specified CustomLevel message. Does not implicitly {@link google.identity.accesscontextmanager.v1.CustomLevel.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICustomLevel} message CustomLevel message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomLevel.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.expr != null && Object.hasOwnProperty.call(message, "expr"))
                                $root.google.type.Expr.encode(message.expr, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CustomLevel message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.CustomLevel.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ICustomLevel} message CustomLevel message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CustomLevel.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CustomLevel message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.CustomLevel} CustomLevel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomLevel.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.CustomLevel();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.expr = $root.google.type.Expr.decode(reader, reader.uint32());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CustomLevel message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.CustomLevel} CustomLevel
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CustomLevel.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CustomLevel message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CustomLevel.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.expr != null && message.hasOwnProperty("expr")) {
                                var error = $root.google.type.Expr.verify(message.expr);
                                if (error)
                                    return "expr." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CustomLevel message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.CustomLevel} CustomLevel
                         */
                        CustomLevel.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.CustomLevel)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.CustomLevel();
                            if (object.expr != null) {
                                if (typeof object.expr !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.CustomLevel.expr: object expected");
                                message.expr = $root.google.type.Expr.fromObject(object.expr);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CustomLevel message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.CustomLevel} message CustomLevel
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CustomLevel.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.expr = null;
                            if (message.expr != null && message.hasOwnProperty("expr"))
                                object.expr = $root.google.type.Expr.toObject(message.expr, options);
                            return object;
                        };
    
                        /**
                         * Converts this CustomLevel to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CustomLevel.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for CustomLevel
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.CustomLevel
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        CustomLevel.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.CustomLevel";
                        };
    
                        return CustomLevel;
                    })();
    
                    v1.DevicePolicy = (function() {
    
                        /**
                         * Properties of a DevicePolicy.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IDevicePolicy
                         * @property {boolean|null} [requireScreenlock] DevicePolicy requireScreenlock
                         * @property {Array.<google.identity.accesscontextmanager.type.DeviceEncryptionStatus>|null} [allowedEncryptionStatuses] DevicePolicy allowedEncryptionStatuses
                         * @property {Array.<google.identity.accesscontextmanager.v1.IOsConstraint>|null} [osConstraints] DevicePolicy osConstraints
                         * @property {Array.<google.identity.accesscontextmanager.type.DeviceManagementLevel>|null} [allowedDeviceManagementLevels] DevicePolicy allowedDeviceManagementLevels
                         * @property {boolean|null} [requireAdminApproval] DevicePolicy requireAdminApproval
                         * @property {boolean|null} [requireCorpOwned] DevicePolicy requireCorpOwned
                         */
    
                        /**
                         * Constructs a new DevicePolicy.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a DevicePolicy.
                         * @implements IDevicePolicy
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IDevicePolicy=} [properties] Properties to set
                         */
                        function DevicePolicy(properties) {
                            this.allowedEncryptionStatuses = [];
                            this.osConstraints = [];
                            this.allowedDeviceManagementLevels = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DevicePolicy requireScreenlock.
                         * @member {boolean} requireScreenlock
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @instance
                         */
                        DevicePolicy.prototype.requireScreenlock = false;
    
                        /**
                         * DevicePolicy allowedEncryptionStatuses.
                         * @member {Array.<google.identity.accesscontextmanager.type.DeviceEncryptionStatus>} allowedEncryptionStatuses
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @instance
                         */
                        DevicePolicy.prototype.allowedEncryptionStatuses = $util.emptyArray;
    
                        /**
                         * DevicePolicy osConstraints.
                         * @member {Array.<google.identity.accesscontextmanager.v1.IOsConstraint>} osConstraints
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @instance
                         */
                        DevicePolicy.prototype.osConstraints = $util.emptyArray;
    
                        /**
                         * DevicePolicy allowedDeviceManagementLevels.
                         * @member {Array.<google.identity.accesscontextmanager.type.DeviceManagementLevel>} allowedDeviceManagementLevels
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @instance
                         */
                        DevicePolicy.prototype.allowedDeviceManagementLevels = $util.emptyArray;
    
                        /**
                         * DevicePolicy requireAdminApproval.
                         * @member {boolean} requireAdminApproval
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @instance
                         */
                        DevicePolicy.prototype.requireAdminApproval = false;
    
                        /**
                         * DevicePolicy requireCorpOwned.
                         * @member {boolean} requireCorpOwned
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @instance
                         */
                        DevicePolicy.prototype.requireCorpOwned = false;
    
                        /**
                         * Creates a new DevicePolicy instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDevicePolicy=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.DevicePolicy} DevicePolicy instance
                         */
                        DevicePolicy.create = function create(properties) {
                            return new DevicePolicy(properties);
                        };
    
                        /**
                         * Encodes the specified DevicePolicy message. Does not implicitly {@link google.identity.accesscontextmanager.v1.DevicePolicy.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDevicePolicy} message DevicePolicy message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DevicePolicy.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.requireScreenlock != null && Object.hasOwnProperty.call(message, "requireScreenlock"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.requireScreenlock);
                            if (message.allowedEncryptionStatuses != null && message.allowedEncryptionStatuses.length) {
                                writer.uint32(/* id 2, wireType 2 =*/18).fork();
                                for (var i = 0; i < message.allowedEncryptionStatuses.length; ++i)
                                    writer.int32(message.allowedEncryptionStatuses[i]);
                                writer.ldelim();
                            }
                            if (message.osConstraints != null && message.osConstraints.length)
                                for (var i = 0; i < message.osConstraints.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.OsConstraint.encode(message.osConstraints[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.allowedDeviceManagementLevels != null && message.allowedDeviceManagementLevels.length) {
                                writer.uint32(/* id 6, wireType 2 =*/50).fork();
                                for (var i = 0; i < message.allowedDeviceManagementLevels.length; ++i)
                                    writer.int32(message.allowedDeviceManagementLevels[i]);
                                writer.ldelim();
                            }
                            if (message.requireAdminApproval != null && Object.hasOwnProperty.call(message, "requireAdminApproval"))
                                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.requireAdminApproval);
                            if (message.requireCorpOwned != null && Object.hasOwnProperty.call(message, "requireCorpOwned"))
                                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.requireCorpOwned);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DevicePolicy message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.DevicePolicy.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IDevicePolicy} message DevicePolicy message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DevicePolicy.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DevicePolicy message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.DevicePolicy} DevicePolicy
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DevicePolicy.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.DevicePolicy();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.requireScreenlock = reader.bool();
                                        break;
                                    }
                                case 2: {
                                        if (!(message.allowedEncryptionStatuses && message.allowedEncryptionStatuses.length))
                                            message.allowedEncryptionStatuses = [];
                                        if ((tag & 7) === 2) {
                                            var end2 = reader.uint32() + reader.pos;
                                            while (reader.pos < end2)
                                                message.allowedEncryptionStatuses.push(reader.int32());
                                        } else
                                            message.allowedEncryptionStatuses.push(reader.int32());
                                        break;
                                    }
                                case 3: {
                                        if (!(message.osConstraints && message.osConstraints.length))
                                            message.osConstraints = [];
                                        message.osConstraints.push($root.google.identity.accesscontextmanager.v1.OsConstraint.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 6: {
                                        if (!(message.allowedDeviceManagementLevels && message.allowedDeviceManagementLevels.length))
                                            message.allowedDeviceManagementLevels = [];
                                        if ((tag & 7) === 2) {
                                            var end2 = reader.uint32() + reader.pos;
                                            while (reader.pos < end2)
                                                message.allowedDeviceManagementLevels.push(reader.int32());
                                        } else
                                            message.allowedDeviceManagementLevels.push(reader.int32());
                                        break;
                                    }
                                case 7: {
                                        message.requireAdminApproval = reader.bool();
                                        break;
                                    }
                                case 8: {
                                        message.requireCorpOwned = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DevicePolicy message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.DevicePolicy} DevicePolicy
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DevicePolicy.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DevicePolicy message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DevicePolicy.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.requireScreenlock != null && message.hasOwnProperty("requireScreenlock"))
                                if (typeof message.requireScreenlock !== "boolean")
                                    return "requireScreenlock: boolean expected";
                            if (message.allowedEncryptionStatuses != null && message.hasOwnProperty("allowedEncryptionStatuses")) {
                                if (!Array.isArray(message.allowedEncryptionStatuses))
                                    return "allowedEncryptionStatuses: array expected";
                                for (var i = 0; i < message.allowedEncryptionStatuses.length; ++i)
                                    switch (message.allowedEncryptionStatuses[i]) {
                                    default:
                                        return "allowedEncryptionStatuses: enum value[] expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                        break;
                                    }
                            }
                            if (message.osConstraints != null && message.hasOwnProperty("osConstraints")) {
                                if (!Array.isArray(message.osConstraints))
                                    return "osConstraints: array expected";
                                for (var i = 0; i < message.osConstraints.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.OsConstraint.verify(message.osConstraints[i]);
                                    if (error)
                                        return "osConstraints." + error;
                                }
                            }
                            if (message.allowedDeviceManagementLevels != null && message.hasOwnProperty("allowedDeviceManagementLevels")) {
                                if (!Array.isArray(message.allowedDeviceManagementLevels))
                                    return "allowedDeviceManagementLevels: array expected";
                                for (var i = 0; i < message.allowedDeviceManagementLevels.length; ++i)
                                    switch (message.allowedDeviceManagementLevels[i]) {
                                    default:
                                        return "allowedDeviceManagementLevels: enum value[] expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                        break;
                                    }
                            }
                            if (message.requireAdminApproval != null && message.hasOwnProperty("requireAdminApproval"))
                                if (typeof message.requireAdminApproval !== "boolean")
                                    return "requireAdminApproval: boolean expected";
                            if (message.requireCorpOwned != null && message.hasOwnProperty("requireCorpOwned"))
                                if (typeof message.requireCorpOwned !== "boolean")
                                    return "requireCorpOwned: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a DevicePolicy message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.DevicePolicy} DevicePolicy
                         */
                        DevicePolicy.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.DevicePolicy)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.DevicePolicy();
                            if (object.requireScreenlock != null)
                                message.requireScreenlock = Boolean(object.requireScreenlock);
                            if (object.allowedEncryptionStatuses) {
                                if (!Array.isArray(object.allowedEncryptionStatuses))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.DevicePolicy.allowedEncryptionStatuses: array expected");
                                message.allowedEncryptionStatuses = [];
                                for (var i = 0; i < object.allowedEncryptionStatuses.length; ++i)
                                    switch (object.allowedEncryptionStatuses[i]) {
                                    default:
                                    case "ENCRYPTION_UNSPECIFIED":
                                    case 0:
                                        message.allowedEncryptionStatuses[i] = 0;
                                        break;
                                    case "ENCRYPTION_UNSUPPORTED":
                                    case 1:
                                        message.allowedEncryptionStatuses[i] = 1;
                                        break;
                                    case "UNENCRYPTED":
                                    case 2:
                                        message.allowedEncryptionStatuses[i] = 2;
                                        break;
                                    case "ENCRYPTED":
                                    case 3:
                                        message.allowedEncryptionStatuses[i] = 3;
                                        break;
                                    }
                            }
                            if (object.osConstraints) {
                                if (!Array.isArray(object.osConstraints))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.DevicePolicy.osConstraints: array expected");
                                message.osConstraints = [];
                                for (var i = 0; i < object.osConstraints.length; ++i) {
                                    if (typeof object.osConstraints[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.DevicePolicy.osConstraints: object expected");
                                    message.osConstraints[i] = $root.google.identity.accesscontextmanager.v1.OsConstraint.fromObject(object.osConstraints[i]);
                                }
                            }
                            if (object.allowedDeviceManagementLevels) {
                                if (!Array.isArray(object.allowedDeviceManagementLevels))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.DevicePolicy.allowedDeviceManagementLevels: array expected");
                                message.allowedDeviceManagementLevels = [];
                                for (var i = 0; i < object.allowedDeviceManagementLevels.length; ++i)
                                    switch (object.allowedDeviceManagementLevels[i]) {
                                    default:
                                    case "MANAGEMENT_UNSPECIFIED":
                                    case 0:
                                        message.allowedDeviceManagementLevels[i] = 0;
                                        break;
                                    case "NONE":
                                    case 1:
                                        message.allowedDeviceManagementLevels[i] = 1;
                                        break;
                                    case "BASIC":
                                    case 2:
                                        message.allowedDeviceManagementLevels[i] = 2;
                                        break;
                                    case "COMPLETE":
                                    case 3:
                                        message.allowedDeviceManagementLevels[i] = 3;
                                        break;
                                    }
                            }
                            if (object.requireAdminApproval != null)
                                message.requireAdminApproval = Boolean(object.requireAdminApproval);
                            if (object.requireCorpOwned != null)
                                message.requireCorpOwned = Boolean(object.requireCorpOwned);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DevicePolicy message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.DevicePolicy} message DevicePolicy
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DevicePolicy.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.allowedEncryptionStatuses = [];
                                object.osConstraints = [];
                                object.allowedDeviceManagementLevels = [];
                            }
                            if (options.defaults) {
                                object.requireScreenlock = false;
                                object.requireAdminApproval = false;
                                object.requireCorpOwned = false;
                            }
                            if (message.requireScreenlock != null && message.hasOwnProperty("requireScreenlock"))
                                object.requireScreenlock = message.requireScreenlock;
                            if (message.allowedEncryptionStatuses && message.allowedEncryptionStatuses.length) {
                                object.allowedEncryptionStatuses = [];
                                for (var j = 0; j < message.allowedEncryptionStatuses.length; ++j)
                                    object.allowedEncryptionStatuses[j] = options.enums === String ? $root.google.identity.accesscontextmanager.type.DeviceEncryptionStatus[message.allowedEncryptionStatuses[j]] : message.allowedEncryptionStatuses[j];
                            }
                            if (message.osConstraints && message.osConstraints.length) {
                                object.osConstraints = [];
                                for (var j = 0; j < message.osConstraints.length; ++j)
                                    object.osConstraints[j] = $root.google.identity.accesscontextmanager.v1.OsConstraint.toObject(message.osConstraints[j], options);
                            }
                            if (message.allowedDeviceManagementLevels && message.allowedDeviceManagementLevels.length) {
                                object.allowedDeviceManagementLevels = [];
                                for (var j = 0; j < message.allowedDeviceManagementLevels.length; ++j)
                                    object.allowedDeviceManagementLevels[j] = options.enums === String ? $root.google.identity.accesscontextmanager.type.DeviceManagementLevel[message.allowedDeviceManagementLevels[j]] : message.allowedDeviceManagementLevels[j];
                            }
                            if (message.requireAdminApproval != null && message.hasOwnProperty("requireAdminApproval"))
                                object.requireAdminApproval = message.requireAdminApproval;
                            if (message.requireCorpOwned != null && message.hasOwnProperty("requireCorpOwned"))
                                object.requireCorpOwned = message.requireCorpOwned;
                            return object;
                        };
    
                        /**
                         * Converts this DevicePolicy to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DevicePolicy.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for DevicePolicy
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.DevicePolicy
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        DevicePolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.DevicePolicy";
                        };
    
                        return DevicePolicy;
                    })();
    
                    v1.OsConstraint = (function() {
    
                        /**
                         * Properties of an OsConstraint.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IOsConstraint
                         * @property {google.identity.accesscontextmanager.type.OsType|null} [osType] OsConstraint osType
                         * @property {string|null} [minimumVersion] OsConstraint minimumVersion
                         * @property {boolean|null} [requireVerifiedChromeOs] OsConstraint requireVerifiedChromeOs
                         */
    
                        /**
                         * Constructs a new OsConstraint.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an OsConstraint.
                         * @implements IOsConstraint
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IOsConstraint=} [properties] Properties to set
                         */
                        function OsConstraint(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OsConstraint osType.
                         * @member {google.identity.accesscontextmanager.type.OsType} osType
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @instance
                         */
                        OsConstraint.prototype.osType = 0;
    
                        /**
                         * OsConstraint minimumVersion.
                         * @member {string} minimumVersion
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @instance
                         */
                        OsConstraint.prototype.minimumVersion = "";
    
                        /**
                         * OsConstraint requireVerifiedChromeOs.
                         * @member {boolean} requireVerifiedChromeOs
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @instance
                         */
                        OsConstraint.prototype.requireVerifiedChromeOs = false;
    
                        /**
                         * Creates a new OsConstraint instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IOsConstraint=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.OsConstraint} OsConstraint instance
                         */
                        OsConstraint.create = function create(properties) {
                            return new OsConstraint(properties);
                        };
    
                        /**
                         * Encodes the specified OsConstraint message. Does not implicitly {@link google.identity.accesscontextmanager.v1.OsConstraint.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IOsConstraint} message OsConstraint message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OsConstraint.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.osType != null && Object.hasOwnProperty.call(message, "osType"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.osType);
                            if (message.minimumVersion != null && Object.hasOwnProperty.call(message, "minimumVersion"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.minimumVersion);
                            if (message.requireVerifiedChromeOs != null && Object.hasOwnProperty.call(message, "requireVerifiedChromeOs"))
                                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.requireVerifiedChromeOs);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OsConstraint message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.OsConstraint.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IOsConstraint} message OsConstraint message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OsConstraint.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OsConstraint message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.OsConstraint} OsConstraint
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OsConstraint.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.OsConstraint();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.osType = reader.int32();
                                        break;
                                    }
                                case 2: {
                                        message.minimumVersion = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.requireVerifiedChromeOs = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OsConstraint message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.OsConstraint} OsConstraint
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OsConstraint.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OsConstraint message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OsConstraint.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.osType != null && message.hasOwnProperty("osType"))
                                switch (message.osType) {
                                default:
                                    return "osType: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 6:
                                case 4:
                                case 5:
                                    break;
                                }
                            if (message.minimumVersion != null && message.hasOwnProperty("minimumVersion"))
                                if (!$util.isString(message.minimumVersion))
                                    return "minimumVersion: string expected";
                            if (message.requireVerifiedChromeOs != null && message.hasOwnProperty("requireVerifiedChromeOs"))
                                if (typeof message.requireVerifiedChromeOs !== "boolean")
                                    return "requireVerifiedChromeOs: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates an OsConstraint message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.OsConstraint} OsConstraint
                         */
                        OsConstraint.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.OsConstraint)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.OsConstraint();
                            switch (object.osType) {
                            case "OS_UNSPECIFIED":
                            case 0:
                                message.osType = 0;
                                break;
                            case "DESKTOP_MAC":
                            case 1:
                                message.osType = 1;
                                break;
                            case "DESKTOP_WINDOWS":
                            case 2:
                                message.osType = 2;
                                break;
                            case "DESKTOP_LINUX":
                            case 3:
                                message.osType = 3;
                                break;
                            case "DESKTOP_CHROME_OS":
                            case 6:
                                message.osType = 6;
                                break;
                            case "ANDROID":
                            case 4:
                                message.osType = 4;
                                break;
                            case "IOS":
                            case 5:
                                message.osType = 5;
                                break;
                            }
                            if (object.minimumVersion != null)
                                message.minimumVersion = String(object.minimumVersion);
                            if (object.requireVerifiedChromeOs != null)
                                message.requireVerifiedChromeOs = Boolean(object.requireVerifiedChromeOs);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OsConstraint message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.OsConstraint} message OsConstraint
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OsConstraint.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.osType = options.enums === String ? "OS_UNSPECIFIED" : 0;
                                object.minimumVersion = "";
                                object.requireVerifiedChromeOs = false;
                            }
                            if (message.osType != null && message.hasOwnProperty("osType"))
                                object.osType = options.enums === String ? $root.google.identity.accesscontextmanager.type.OsType[message.osType] : message.osType;
                            if (message.minimumVersion != null && message.hasOwnProperty("minimumVersion"))
                                object.minimumVersion = message.minimumVersion;
                            if (message.requireVerifiedChromeOs != null && message.hasOwnProperty("requireVerifiedChromeOs"))
                                object.requireVerifiedChromeOs = message.requireVerifiedChromeOs;
                            return object;
                        };
    
                        /**
                         * Converts this OsConstraint to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OsConstraint.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for OsConstraint
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.OsConstraint
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        OsConstraint.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.OsConstraint";
                        };
    
                        return OsConstraint;
                    })();
    
                    v1.AccessPolicy = (function() {
    
                        /**
                         * Properties of an AccessPolicy.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IAccessPolicy
                         * @property {string|null} [name] AccessPolicy name
                         * @property {string|null} [parent] AccessPolicy parent
                         * @property {string|null} [title] AccessPolicy title
                         * @property {google.protobuf.ITimestamp|null} [createTime] AccessPolicy createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] AccessPolicy updateTime
                         * @property {string|null} [etag] AccessPolicy etag
                         */
    
                        /**
                         * Constructs a new AccessPolicy.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents an AccessPolicy.
                         * @implements IAccessPolicy
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IAccessPolicy=} [properties] Properties to set
                         */
                        function AccessPolicy(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AccessPolicy name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @instance
                         */
                        AccessPolicy.prototype.name = "";
    
                        /**
                         * AccessPolicy parent.
                         * @member {string} parent
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @instance
                         */
                        AccessPolicy.prototype.parent = "";
    
                        /**
                         * AccessPolicy title.
                         * @member {string} title
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @instance
                         */
                        AccessPolicy.prototype.title = "";
    
                        /**
                         * AccessPolicy createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @instance
                         */
                        AccessPolicy.prototype.createTime = null;
    
                        /**
                         * AccessPolicy updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @instance
                         */
                        AccessPolicy.prototype.updateTime = null;
    
                        /**
                         * AccessPolicy etag.
                         * @member {string} etag
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @instance
                         */
                        AccessPolicy.prototype.etag = "";
    
                        /**
                         * Creates a new AccessPolicy instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessPolicy=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.AccessPolicy} AccessPolicy instance
                         */
                        AccessPolicy.create = function create(properties) {
                            return new AccessPolicy(properties);
                        };
    
                        /**
                         * Encodes the specified AccessPolicy message. Does not implicitly {@link google.identity.accesscontextmanager.v1.AccessPolicy.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessPolicy} message AccessPolicy message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessPolicy.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.parent);
                            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.title);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.etag != null && Object.hasOwnProperty.call(message, "etag"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.etag);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AccessPolicy message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.AccessPolicy.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IAccessPolicy} message AccessPolicy message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AccessPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AccessPolicy message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.AccessPolicy} AccessPolicy
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessPolicy.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.AccessPolicy();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.parent = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.title = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.etag = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AccessPolicy message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.AccessPolicy} AccessPolicy
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AccessPolicy.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AccessPolicy message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AccessPolicy.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.title != null && message.hasOwnProperty("title"))
                                if (!$util.isString(message.title))
                                    return "title: string expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                if (!$util.isString(message.etag))
                                    return "etag: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AccessPolicy message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.AccessPolicy} AccessPolicy
                         */
                        AccessPolicy.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.AccessPolicy)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.AccessPolicy();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.title != null)
                                message.title = String(object.title);
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.AccessPolicy.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.AccessPolicy.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            if (object.etag != null)
                                message.etag = String(object.etag);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AccessPolicy message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.AccessPolicy} message AccessPolicy
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AccessPolicy.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.parent = "";
                                object.title = "";
                                object.createTime = null;
                                object.updateTime = null;
                                object.etag = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.title != null && message.hasOwnProperty("title"))
                                object.title = message.title;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.etag != null && message.hasOwnProperty("etag"))
                                object.etag = message.etag;
                            return object;
                        };
    
                        /**
                         * Converts this AccessPolicy to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AccessPolicy.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AccessPolicy
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.AccessPolicy
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AccessPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.AccessPolicy";
                        };
    
                        return AccessPolicy;
                    })();
    
                    v1.GcpUserAccessBinding = (function() {
    
                        /**
                         * Properties of a GcpUserAccessBinding.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IGcpUserAccessBinding
                         * @property {string|null} [name] GcpUserAccessBinding name
                         * @property {string|null} [groupKey] GcpUserAccessBinding groupKey
                         * @property {Array.<string>|null} [accessLevels] GcpUserAccessBinding accessLevels
                         */
    
                        /**
                         * Constructs a new GcpUserAccessBinding.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a GcpUserAccessBinding.
                         * @implements IGcpUserAccessBinding
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding=} [properties] Properties to set
                         */
                        function GcpUserAccessBinding(properties) {
                            this.accessLevels = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GcpUserAccessBinding name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @instance
                         */
                        GcpUserAccessBinding.prototype.name = "";
    
                        /**
                         * GcpUserAccessBinding groupKey.
                         * @member {string} groupKey
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @instance
                         */
                        GcpUserAccessBinding.prototype.groupKey = "";
    
                        /**
                         * GcpUserAccessBinding accessLevels.
                         * @member {Array.<string>} accessLevels
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @instance
                         */
                        GcpUserAccessBinding.prototype.accessLevels = $util.emptyArray;
    
                        /**
                         * Creates a new GcpUserAccessBinding instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} GcpUserAccessBinding instance
                         */
                        GcpUserAccessBinding.create = function create(properties) {
                            return new GcpUserAccessBinding(properties);
                        };
    
                        /**
                         * Encodes the specified GcpUserAccessBinding message. Does not implicitly {@link google.identity.accesscontextmanager.v1.GcpUserAccessBinding.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding} message GcpUserAccessBinding message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcpUserAccessBinding.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.groupKey != null && Object.hasOwnProperty.call(message, "groupKey"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.groupKey);
                            if (message.accessLevels != null && message.accessLevels.length)
                                for (var i = 0; i < message.accessLevels.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.accessLevels[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GcpUserAccessBinding message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.GcpUserAccessBinding.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IGcpUserAccessBinding} message GcpUserAccessBinding message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GcpUserAccessBinding.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GcpUserAccessBinding message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} GcpUserAccessBinding
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcpUserAccessBinding.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.groupKey = reader.string();
                                        break;
                                    }
                                case 3: {
                                        if (!(message.accessLevels && message.accessLevels.length))
                                            message.accessLevels = [];
                                        message.accessLevels.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GcpUserAccessBinding message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} GcpUserAccessBinding
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GcpUserAccessBinding.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GcpUserAccessBinding message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GcpUserAccessBinding.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.groupKey != null && message.hasOwnProperty("groupKey"))
                                if (!$util.isString(message.groupKey))
                                    return "groupKey: string expected";
                            if (message.accessLevels != null && message.hasOwnProperty("accessLevels")) {
                                if (!Array.isArray(message.accessLevels))
                                    return "accessLevels: array expected";
                                for (var i = 0; i < message.accessLevels.length; ++i)
                                    if (!$util.isString(message.accessLevels[i]))
                                        return "accessLevels: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a GcpUserAccessBinding message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} GcpUserAccessBinding
                         */
                        GcpUserAccessBinding.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.GcpUserAccessBinding();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.groupKey != null)
                                message.groupKey = String(object.groupKey);
                            if (object.accessLevels) {
                                if (!Array.isArray(object.accessLevels))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.GcpUserAccessBinding.accessLevels: array expected");
                                message.accessLevels = [];
                                for (var i = 0; i < object.accessLevels.length; ++i)
                                    message.accessLevels[i] = String(object.accessLevels[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GcpUserAccessBinding message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} message GcpUserAccessBinding
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GcpUserAccessBinding.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.accessLevels = [];
                            if (options.defaults) {
                                object.name = "";
                                object.groupKey = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.groupKey != null && message.hasOwnProperty("groupKey"))
                                object.groupKey = message.groupKey;
                            if (message.accessLevels && message.accessLevels.length) {
                                object.accessLevels = [];
                                for (var j = 0; j < message.accessLevels.length; ++j)
                                    object.accessLevels[j] = message.accessLevels[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this GcpUserAccessBinding to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GcpUserAccessBinding.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for GcpUserAccessBinding
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.GcpUserAccessBinding
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        GcpUserAccessBinding.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.GcpUserAccessBinding";
                        };
    
                        return GcpUserAccessBinding;
                    })();
    
                    v1.ServicePerimeter = (function() {
    
                        /**
                         * Properties of a ServicePerimeter.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IServicePerimeter
                         * @property {string|null} [name] ServicePerimeter name
                         * @property {string|null} [title] ServicePerimeter title
                         * @property {string|null} [description] ServicePerimeter description
                         * @property {google.protobuf.ITimestamp|null} [createTime] ServicePerimeter createTime
                         * @property {google.protobuf.ITimestamp|null} [updateTime] ServicePerimeter updateTime
                         * @property {google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType|null} [perimeterType] ServicePerimeter perimeterType
                         * @property {google.identity.accesscontextmanager.v1.IServicePerimeterConfig|null} [status] ServicePerimeter status
                         * @property {google.identity.accesscontextmanager.v1.IServicePerimeterConfig|null} [spec] ServicePerimeter spec
                         * @property {boolean|null} [useExplicitDryRunSpec] ServicePerimeter useExplicitDryRunSpec
                         */
    
                        /**
                         * Constructs a new ServicePerimeter.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ServicePerimeter.
                         * @implements IServicePerimeter
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeter=} [properties] Properties to set
                         */
                        function ServicePerimeter(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ServicePerimeter name.
                         * @member {string} name
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.name = "";
    
                        /**
                         * ServicePerimeter title.
                         * @member {string} title
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.title = "";
    
                        /**
                         * ServicePerimeter description.
                         * @member {string} description
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.description = "";
    
                        /**
                         * ServicePerimeter createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.createTime = null;
    
                        /**
                         * ServicePerimeter updateTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} updateTime
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.updateTime = null;
    
                        /**
                         * ServicePerimeter perimeterType.
                         * @member {google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType} perimeterType
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.perimeterType = 0;
    
                        /**
                         * ServicePerimeter status.
                         * @member {google.identity.accesscontextmanager.v1.IServicePerimeterConfig|null|undefined} status
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.status = null;
    
                        /**
                         * ServicePerimeter spec.
                         * @member {google.identity.accesscontextmanager.v1.IServicePerimeterConfig|null|undefined} spec
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.spec = null;
    
                        /**
                         * ServicePerimeter useExplicitDryRunSpec.
                         * @member {boolean} useExplicitDryRunSpec
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         */
                        ServicePerimeter.prototype.useExplicitDryRunSpec = false;
    
                        /**
                         * Creates a new ServicePerimeter instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeter=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeter} ServicePerimeter instance
                         */
                        ServicePerimeter.create = function create(properties) {
                            return new ServicePerimeter(properties);
                        };
    
                        /**
                         * Encodes the specified ServicePerimeter message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeter.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeter} message ServicePerimeter message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ServicePerimeter.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.title);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.updateTime != null && Object.hasOwnProperty.call(message, "updateTime"))
                                $root.google.protobuf.Timestamp.encode(message.updateTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.perimeterType != null && Object.hasOwnProperty.call(message, "perimeterType"))
                                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.perimeterType);
                            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                                $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.encode(message.status, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.spec != null && Object.hasOwnProperty.call(message, "spec"))
                                $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.encode(message.spec, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.useExplicitDryRunSpec != null && Object.hasOwnProperty.call(message, "useExplicitDryRunSpec"))
                                writer.uint32(/* id 9, wireType 0 =*/72).bool(message.useExplicitDryRunSpec);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ServicePerimeter message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeter.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeter} message ServicePerimeter message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ServicePerimeter.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ServicePerimeter message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeter} ServicePerimeter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ServicePerimeter.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeter();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.name = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.title = reader.string();
                                        break;
                                    }
                                case 3: {
                                        message.description = reader.string();
                                        break;
                                    }
                                case 4: {
                                        message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 5: {
                                        message.updateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 6: {
                                        message.perimeterType = reader.int32();
                                        break;
                                    }
                                case 7: {
                                        message.status = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        message.spec = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 9: {
                                        message.useExplicitDryRunSpec = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ServicePerimeter message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeter} ServicePerimeter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ServicePerimeter.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ServicePerimeter message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ServicePerimeter.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.title != null && message.hasOwnProperty("title"))
                                if (!$util.isString(message.title))
                                    return "title: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.updateTime != null && message.hasOwnProperty("updateTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.updateTime);
                                if (error)
                                    return "updateTime." + error;
                            }
                            if (message.perimeterType != null && message.hasOwnProperty("perimeterType"))
                                switch (message.perimeterType) {
                                default:
                                    return "perimeterType: enum value expected";
                                case 0:
                                case 1:
                                    break;
                                }
                            if (message.status != null && message.hasOwnProperty("status")) {
                                var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.verify(message.status);
                                if (error)
                                    return "status." + error;
                            }
                            if (message.spec != null && message.hasOwnProperty("spec")) {
                                var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.verify(message.spec);
                                if (error)
                                    return "spec." + error;
                            }
                            if (message.useExplicitDryRunSpec != null && message.hasOwnProperty("useExplicitDryRunSpec"))
                                if (typeof message.useExplicitDryRunSpec !== "boolean")
                                    return "useExplicitDryRunSpec: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a ServicePerimeter message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeter} ServicePerimeter
                         */
                        ServicePerimeter.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeter)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeter();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.title != null)
                                message.title = String(object.title);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeter.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.updateTime != null) {
                                if (typeof object.updateTime !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeter.updateTime: object expected");
                                message.updateTime = $root.google.protobuf.Timestamp.fromObject(object.updateTime);
                            }
                            switch (object.perimeterType) {
                            case "PERIMETER_TYPE_REGULAR":
                            case 0:
                                message.perimeterType = 0;
                                break;
                            case "PERIMETER_TYPE_BRIDGE":
                            case 1:
                                message.perimeterType = 1;
                                break;
                            }
                            if (object.status != null) {
                                if (typeof object.status !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeter.status: object expected");
                                message.status = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.fromObject(object.status);
                            }
                            if (object.spec != null) {
                                if (typeof object.spec !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeter.spec: object expected");
                                message.spec = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.fromObject(object.spec);
                            }
                            if (object.useExplicitDryRunSpec != null)
                                message.useExplicitDryRunSpec = Boolean(object.useExplicitDryRunSpec);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ServicePerimeter message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ServicePerimeter} message ServicePerimeter
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ServicePerimeter.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.title = "";
                                object.description = "";
                                object.createTime = null;
                                object.updateTime = null;
                                object.perimeterType = options.enums === String ? "PERIMETER_TYPE_REGULAR" : 0;
                                object.status = null;
                                object.spec = null;
                                object.useExplicitDryRunSpec = false;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.title != null && message.hasOwnProperty("title"))
                                object.title = message.title;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.updateTime != null && message.hasOwnProperty("updateTime"))
                                object.updateTime = $root.google.protobuf.Timestamp.toObject(message.updateTime, options);
                            if (message.perimeterType != null && message.hasOwnProperty("perimeterType"))
                                object.perimeterType = options.enums === String ? $root.google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType[message.perimeterType] : message.perimeterType;
                            if (message.status != null && message.hasOwnProperty("status"))
                                object.status = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.toObject(message.status, options);
                            if (message.spec != null && message.hasOwnProperty("spec"))
                                object.spec = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.toObject(message.spec, options);
                            if (message.useExplicitDryRunSpec != null && message.hasOwnProperty("useExplicitDryRunSpec"))
                                object.useExplicitDryRunSpec = message.useExplicitDryRunSpec;
                            return object;
                        };
    
                        /**
                         * Converts this ServicePerimeter to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ServicePerimeter.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ServicePerimeter
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeter
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ServicePerimeter.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeter";
                        };
    
                        /**
                         * PerimeterType enum.
                         * @name google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType
                         * @enum {number}
                         * @property {number} PERIMETER_TYPE_REGULAR=0 PERIMETER_TYPE_REGULAR value
                         * @property {number} PERIMETER_TYPE_BRIDGE=1 PERIMETER_TYPE_BRIDGE value
                         */
                        ServicePerimeter.PerimeterType = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "PERIMETER_TYPE_REGULAR"] = 0;
                            values[valuesById[1] = "PERIMETER_TYPE_BRIDGE"] = 1;
                            return values;
                        })();
    
                        return ServicePerimeter;
                    })();
    
                    v1.ServicePerimeterConfig = (function() {
    
                        /**
                         * Properties of a ServicePerimeterConfig.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @interface IServicePerimeterConfig
                         * @property {Array.<string>|null} [resources] ServicePerimeterConfig resources
                         * @property {Array.<string>|null} [accessLevels] ServicePerimeterConfig accessLevels
                         * @property {Array.<string>|null} [restrictedServices] ServicePerimeterConfig restrictedServices
                         * @property {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IVpcAccessibleServices|null} [vpcAccessibleServices] ServicePerimeterConfig vpcAccessibleServices
                         * @property {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressPolicy>|null} [ingressPolicies] ServicePerimeterConfig ingressPolicies
                         * @property {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressPolicy>|null} [egressPolicies] ServicePerimeterConfig egressPolicies
                         */
    
                        /**
                         * Constructs a new ServicePerimeterConfig.
                         * @memberof google.identity.accesscontextmanager.v1
                         * @classdesc Represents a ServicePerimeterConfig.
                         * @implements IServicePerimeterConfig
                         * @constructor
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeterConfig=} [properties] Properties to set
                         */
                        function ServicePerimeterConfig(properties) {
                            this.resources = [];
                            this.accessLevels = [];
                            this.restrictedServices = [];
                            this.ingressPolicies = [];
                            this.egressPolicies = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ServicePerimeterConfig resources.
                         * @member {Array.<string>} resources
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @instance
                         */
                        ServicePerimeterConfig.prototype.resources = $util.emptyArray;
    
                        /**
                         * ServicePerimeterConfig accessLevels.
                         * @member {Array.<string>} accessLevels
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @instance
                         */
                        ServicePerimeterConfig.prototype.accessLevels = $util.emptyArray;
    
                        /**
                         * ServicePerimeterConfig restrictedServices.
                         * @member {Array.<string>} restrictedServices
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @instance
                         */
                        ServicePerimeterConfig.prototype.restrictedServices = $util.emptyArray;
    
                        /**
                         * ServicePerimeterConfig vpcAccessibleServices.
                         * @member {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IVpcAccessibleServices|null|undefined} vpcAccessibleServices
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @instance
                         */
                        ServicePerimeterConfig.prototype.vpcAccessibleServices = null;
    
                        /**
                         * ServicePerimeterConfig ingressPolicies.
                         * @member {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressPolicy>} ingressPolicies
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @instance
                         */
                        ServicePerimeterConfig.prototype.ingressPolicies = $util.emptyArray;
    
                        /**
                         * ServicePerimeterConfig egressPolicies.
                         * @member {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressPolicy>} egressPolicies
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @instance
                         */
                        ServicePerimeterConfig.prototype.egressPolicies = $util.emptyArray;
    
                        /**
                         * Creates a new ServicePerimeterConfig instance using the specified properties.
                         * @function create
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeterConfig=} [properties] Properties to set
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig} ServicePerimeterConfig instance
                         */
                        ServicePerimeterConfig.create = function create(properties) {
                            return new ServicePerimeterConfig(properties);
                        };
    
                        /**
                         * Encodes the specified ServicePerimeterConfig message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeterConfig} message ServicePerimeterConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ServicePerimeterConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.resources != null && message.resources.length)
                                for (var i = 0; i < message.resources.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.resources[i]);
                            if (message.accessLevels != null && message.accessLevels.length)
                                for (var i = 0; i < message.accessLevels.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.accessLevels[i]);
                            if (message.restrictedServices != null && message.restrictedServices.length)
                                for (var i = 0; i < message.restrictedServices.length; ++i)
                                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.restrictedServices[i]);
                            if (message.ingressPolicies != null && message.ingressPolicies.length)
                                for (var i = 0; i < message.ingressPolicies.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.encode(message.ingressPolicies[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.egressPolicies != null && message.egressPolicies.length)
                                for (var i = 0; i < message.egressPolicies.length; ++i)
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.encode(message.egressPolicies[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            if (message.vpcAccessibleServices != null && Object.hasOwnProperty.call(message, "vpcAccessibleServices"))
                                $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.encode(message.vpcAccessibleServices, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ServicePerimeterConfig message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.IServicePerimeterConfig} message ServicePerimeterConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ServicePerimeterConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ServicePerimeterConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig} ServicePerimeterConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ServicePerimeterConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.resources && message.resources.length))
                                            message.resources = [];
                                        message.resources.push(reader.string());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.accessLevels && message.accessLevels.length))
                                            message.accessLevels = [];
                                        message.accessLevels.push(reader.string());
                                        break;
                                    }
                                case 4: {
                                        if (!(message.restrictedServices && message.restrictedServices.length))
                                            message.restrictedServices = [];
                                        message.restrictedServices.push(reader.string());
                                        break;
                                    }
                                case 10: {
                                        message.vpcAccessibleServices = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.decode(reader, reader.uint32());
                                        break;
                                    }
                                case 8: {
                                        if (!(message.ingressPolicies && message.ingressPolicies.length))
                                            message.ingressPolicies = [];
                                        message.ingressPolicies.push($root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.decode(reader, reader.uint32()));
                                        break;
                                    }
                                case 9: {
                                        if (!(message.egressPolicies && message.egressPolicies.length))
                                            message.egressPolicies = [];
                                        message.egressPolicies.push($root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.decode(reader, reader.uint32()));
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ServicePerimeterConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig} ServicePerimeterConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ServicePerimeterConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ServicePerimeterConfig message.
                         * @function verify
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ServicePerimeterConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.resources != null && message.hasOwnProperty("resources")) {
                                if (!Array.isArray(message.resources))
                                    return "resources: array expected";
                                for (var i = 0; i < message.resources.length; ++i)
                                    if (!$util.isString(message.resources[i]))
                                        return "resources: string[] expected";
                            }
                            if (message.accessLevels != null && message.hasOwnProperty("accessLevels")) {
                                if (!Array.isArray(message.accessLevels))
                                    return "accessLevels: array expected";
                                for (var i = 0; i < message.accessLevels.length; ++i)
                                    if (!$util.isString(message.accessLevels[i]))
                                        return "accessLevels: string[] expected";
                            }
                            if (message.restrictedServices != null && message.hasOwnProperty("restrictedServices")) {
                                if (!Array.isArray(message.restrictedServices))
                                    return "restrictedServices: array expected";
                                for (var i = 0; i < message.restrictedServices.length; ++i)
                                    if (!$util.isString(message.restrictedServices[i]))
                                        return "restrictedServices: string[] expected";
                            }
                            if (message.vpcAccessibleServices != null && message.hasOwnProperty("vpcAccessibleServices")) {
                                var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.verify(message.vpcAccessibleServices);
                                if (error)
                                    return "vpcAccessibleServices." + error;
                            }
                            if (message.ingressPolicies != null && message.hasOwnProperty("ingressPolicies")) {
                                if (!Array.isArray(message.ingressPolicies))
                                    return "ingressPolicies: array expected";
                                for (var i = 0; i < message.ingressPolicies.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.verify(message.ingressPolicies[i]);
                                    if (error)
                                        return "ingressPolicies." + error;
                                }
                            }
                            if (message.egressPolicies != null && message.hasOwnProperty("egressPolicies")) {
                                if (!Array.isArray(message.egressPolicies))
                                    return "egressPolicies: array expected";
                                for (var i = 0; i < message.egressPolicies.length; ++i) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.verify(message.egressPolicies[i]);
                                    if (error)
                                        return "egressPolicies." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ServicePerimeterConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig} ServicePerimeterConfig
                         */
                        ServicePerimeterConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig)
                                return object;
                            var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig();
                            if (object.resources) {
                                if (!Array.isArray(object.resources))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.resources: array expected");
                                message.resources = [];
                                for (var i = 0; i < object.resources.length; ++i)
                                    message.resources[i] = String(object.resources[i]);
                            }
                            if (object.accessLevels) {
                                if (!Array.isArray(object.accessLevels))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.accessLevels: array expected");
                                message.accessLevels = [];
                                for (var i = 0; i < object.accessLevels.length; ++i)
                                    message.accessLevels[i] = String(object.accessLevels[i]);
                            }
                            if (object.restrictedServices) {
                                if (!Array.isArray(object.restrictedServices))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.restrictedServices: array expected");
                                message.restrictedServices = [];
                                for (var i = 0; i < object.restrictedServices.length; ++i)
                                    message.restrictedServices[i] = String(object.restrictedServices[i]);
                            }
                            if (object.vpcAccessibleServices != null) {
                                if (typeof object.vpcAccessibleServices !== "object")
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.vpcAccessibleServices: object expected");
                                message.vpcAccessibleServices = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.fromObject(object.vpcAccessibleServices);
                            }
                            if (object.ingressPolicies) {
                                if (!Array.isArray(object.ingressPolicies))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ingressPolicies: array expected");
                                message.ingressPolicies = [];
                                for (var i = 0; i < object.ingressPolicies.length; ++i) {
                                    if (typeof object.ingressPolicies[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ingressPolicies: object expected");
                                    message.ingressPolicies[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.fromObject(object.ingressPolicies[i]);
                                }
                            }
                            if (object.egressPolicies) {
                                if (!Array.isArray(object.egressPolicies))
                                    throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.egressPolicies: array expected");
                                message.egressPolicies = [];
                                for (var i = 0; i < object.egressPolicies.length; ++i) {
                                    if (typeof object.egressPolicies[i] !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.egressPolicies: object expected");
                                    message.egressPolicies[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.fromObject(object.egressPolicies[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ServicePerimeterConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig} message ServicePerimeterConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ServicePerimeterConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.resources = [];
                                object.accessLevels = [];
                                object.restrictedServices = [];
                                object.ingressPolicies = [];
                                object.egressPolicies = [];
                            }
                            if (options.defaults)
                                object.vpcAccessibleServices = null;
                            if (message.resources && message.resources.length) {
                                object.resources = [];
                                for (var j = 0; j < message.resources.length; ++j)
                                    object.resources[j] = message.resources[j];
                            }
                            if (message.accessLevels && message.accessLevels.length) {
                                object.accessLevels = [];
                                for (var j = 0; j < message.accessLevels.length; ++j)
                                    object.accessLevels[j] = message.accessLevels[j];
                            }
                            if (message.restrictedServices && message.restrictedServices.length) {
                                object.restrictedServices = [];
                                for (var j = 0; j < message.restrictedServices.length; ++j)
                                    object.restrictedServices[j] = message.restrictedServices[j];
                            }
                            if (message.ingressPolicies && message.ingressPolicies.length) {
                                object.ingressPolicies = [];
                                for (var j = 0; j < message.ingressPolicies.length; ++j)
                                    object.ingressPolicies[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.toObject(message.ingressPolicies[j], options);
                            }
                            if (message.egressPolicies && message.egressPolicies.length) {
                                object.egressPolicies = [];
                                for (var j = 0; j < message.egressPolicies.length; ++j)
                                    object.egressPolicies[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.toObject(message.egressPolicies[j], options);
                            }
                            if (message.vpcAccessibleServices != null && message.hasOwnProperty("vpcAccessibleServices"))
                                object.vpcAccessibleServices = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.toObject(message.vpcAccessibleServices, options);
                            return object;
                        };
    
                        /**
                         * Converts this ServicePerimeterConfig to JSON.
                         * @function toJSON
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ServicePerimeterConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ServicePerimeterConfig
                         * @function getTypeUrl
                         * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ServicePerimeterConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig";
                        };
    
                        ServicePerimeterConfig.VpcAccessibleServices = (function() {
    
                            /**
                             * Properties of a VpcAccessibleServices.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IVpcAccessibleServices
                             * @property {boolean|null} [enableRestriction] VpcAccessibleServices enableRestriction
                             * @property {Array.<string>|null} [allowedServices] VpcAccessibleServices allowedServices
                             */
    
                            /**
                             * Constructs a new VpcAccessibleServices.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents a VpcAccessibleServices.
                             * @implements IVpcAccessibleServices
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IVpcAccessibleServices=} [properties] Properties to set
                             */
                            function VpcAccessibleServices(properties) {
                                this.allowedServices = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * VpcAccessibleServices enableRestriction.
                             * @member {boolean} enableRestriction
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @instance
                             */
                            VpcAccessibleServices.prototype.enableRestriction = false;
    
                            /**
                             * VpcAccessibleServices allowedServices.
                             * @member {Array.<string>} allowedServices
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @instance
                             */
                            VpcAccessibleServices.prototype.allowedServices = $util.emptyArray;
    
                            /**
                             * Creates a new VpcAccessibleServices instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IVpcAccessibleServices=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices} VpcAccessibleServices instance
                             */
                            VpcAccessibleServices.create = function create(properties) {
                                return new VpcAccessibleServices(properties);
                            };
    
                            /**
                             * Encodes the specified VpcAccessibleServices message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IVpcAccessibleServices} message VpcAccessibleServices message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            VpcAccessibleServices.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.enableRestriction != null && Object.hasOwnProperty.call(message, "enableRestriction"))
                                    writer.uint32(/* id 1, wireType 0 =*/8).bool(message.enableRestriction);
                                if (message.allowedServices != null && message.allowedServices.length)
                                    for (var i = 0; i < message.allowedServices.length; ++i)
                                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.allowedServices[i]);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified VpcAccessibleServices message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IVpcAccessibleServices} message VpcAccessibleServices message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            VpcAccessibleServices.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a VpcAccessibleServices message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices} VpcAccessibleServices
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            VpcAccessibleServices.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.enableRestriction = reader.bool();
                                            break;
                                        }
                                    case 2: {
                                            if (!(message.allowedServices && message.allowedServices.length))
                                                message.allowedServices = [];
                                            message.allowedServices.push(reader.string());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a VpcAccessibleServices message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices} VpcAccessibleServices
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            VpcAccessibleServices.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a VpcAccessibleServices message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            VpcAccessibleServices.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.enableRestriction != null && message.hasOwnProperty("enableRestriction"))
                                    if (typeof message.enableRestriction !== "boolean")
                                        return "enableRestriction: boolean expected";
                                if (message.allowedServices != null && message.hasOwnProperty("allowedServices")) {
                                    if (!Array.isArray(message.allowedServices))
                                        return "allowedServices: array expected";
                                    for (var i = 0; i < message.allowedServices.length; ++i)
                                        if (!$util.isString(message.allowedServices[i]))
                                            return "allowedServices: string[] expected";
                                }
                                return null;
                            };
    
                            /**
                             * Creates a VpcAccessibleServices message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices} VpcAccessibleServices
                             */
                            VpcAccessibleServices.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices();
                                if (object.enableRestriction != null)
                                    message.enableRestriction = Boolean(object.enableRestriction);
                                if (object.allowedServices) {
                                    if (!Array.isArray(object.allowedServices))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices.allowedServices: array expected");
                                    message.allowedServices = [];
                                    for (var i = 0; i < object.allowedServices.length; ++i)
                                        message.allowedServices[i] = String(object.allowedServices[i]);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a VpcAccessibleServices message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices} message VpcAccessibleServices
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            VpcAccessibleServices.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.allowedServices = [];
                                if (options.defaults)
                                    object.enableRestriction = false;
                                if (message.enableRestriction != null && message.hasOwnProperty("enableRestriction"))
                                    object.enableRestriction = message.enableRestriction;
                                if (message.allowedServices && message.allowedServices.length) {
                                    object.allowedServices = [];
                                    for (var j = 0; j < message.allowedServices.length; ++j)
                                        object.allowedServices[j] = message.allowedServices[j];
                                }
                                return object;
                            };
    
                            /**
                             * Converts this VpcAccessibleServices to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            VpcAccessibleServices.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for VpcAccessibleServices
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            VpcAccessibleServices.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices";
                            };
    
                            return VpcAccessibleServices;
                        })();
    
                        ServicePerimeterConfig.MethodSelector = (function() {
    
                            /**
                             * Properties of a MethodSelector.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IMethodSelector
                             * @property {string|null} [method] MethodSelector method
                             * @property {string|null} [permission] MethodSelector permission
                             */
    
                            /**
                             * Constructs a new MethodSelector.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents a MethodSelector.
                             * @implements IMethodSelector
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IMethodSelector=} [properties] Properties to set
                             */
                            function MethodSelector(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * MethodSelector method.
                             * @member {string|null|undefined} method
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @instance
                             */
                            MethodSelector.prototype.method = null;
    
                            /**
                             * MethodSelector permission.
                             * @member {string|null|undefined} permission
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @instance
                             */
                            MethodSelector.prototype.permission = null;
    
                            // OneOf field names bound to virtual getters and setters
                            var $oneOfFields;
    
                            /**
                             * MethodSelector kind.
                             * @member {"method"|"permission"|undefined} kind
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @instance
                             */
                            Object.defineProperty(MethodSelector.prototype, "kind", {
                                get: $util.oneOfGetter($oneOfFields = ["method", "permission"]),
                                set: $util.oneOfSetter($oneOfFields)
                            });
    
                            /**
                             * Creates a new MethodSelector instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IMethodSelector=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector} MethodSelector instance
                             */
                            MethodSelector.create = function create(properties) {
                                return new MethodSelector(properties);
                            };
    
                            /**
                             * Encodes the specified MethodSelector message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IMethodSelector} message MethodSelector message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            MethodSelector.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.method != null && Object.hasOwnProperty.call(message, "method"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.method);
                                if (message.permission != null && Object.hasOwnProperty.call(message, "permission"))
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.permission);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified MethodSelector message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IMethodSelector} message MethodSelector message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            MethodSelector.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes a MethodSelector message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector} MethodSelector
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            MethodSelector.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.method = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            message.permission = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes a MethodSelector message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector} MethodSelector
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            MethodSelector.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies a MethodSelector message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            MethodSelector.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                var properties = {};
                                if (message.method != null && message.hasOwnProperty("method")) {
                                    properties.kind = 1;
                                    if (!$util.isString(message.method))
                                        return "method: string expected";
                                }
                                if (message.permission != null && message.hasOwnProperty("permission")) {
                                    if (properties.kind === 1)
                                        return "kind: multiple values";
                                    properties.kind = 1;
                                    if (!$util.isString(message.permission))
                                        return "permission: string expected";
                                }
                                return null;
                            };
    
                            /**
                             * Creates a MethodSelector message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector} MethodSelector
                             */
                            MethodSelector.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector();
                                if (object.method != null)
                                    message.method = String(object.method);
                                if (object.permission != null)
                                    message.permission = String(object.permission);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from a MethodSelector message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector} message MethodSelector
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            MethodSelector.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (message.method != null && message.hasOwnProperty("method")) {
                                    object.method = message.method;
                                    if (options.oneofs)
                                        object.kind = "method";
                                }
                                if (message.permission != null && message.hasOwnProperty("permission")) {
                                    object.permission = message.permission;
                                    if (options.oneofs)
                                        object.kind = "permission";
                                }
                                return object;
                            };
    
                            /**
                             * Converts this MethodSelector to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            MethodSelector.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for MethodSelector
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            MethodSelector.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector";
                            };
    
                            return MethodSelector;
                        })();
    
                        ServicePerimeterConfig.ApiOperation = (function() {
    
                            /**
                             * Properties of an ApiOperation.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IApiOperation
                             * @property {string|null} [serviceName] ApiOperation serviceName
                             * @property {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IMethodSelector>|null} [methodSelectors] ApiOperation methodSelectors
                             */
    
                            /**
                             * Constructs a new ApiOperation.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an ApiOperation.
                             * @implements IApiOperation
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation=} [properties] Properties to set
                             */
                            function ApiOperation(properties) {
                                this.methodSelectors = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * ApiOperation serviceName.
                             * @member {string} serviceName
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @instance
                             */
                            ApiOperation.prototype.serviceName = "";
    
                            /**
                             * ApiOperation methodSelectors.
                             * @member {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IMethodSelector>} methodSelectors
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @instance
                             */
                            ApiOperation.prototype.methodSelectors = $util.emptyArray;
    
                            /**
                             * Creates a new ApiOperation instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation} ApiOperation instance
                             */
                            ApiOperation.create = function create(properties) {
                                return new ApiOperation(properties);
                            };
    
                            /**
                             * Encodes the specified ApiOperation message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation} message ApiOperation message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            ApiOperation.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.serviceName != null && Object.hasOwnProperty.call(message, "serviceName"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.serviceName);
                                if (message.methodSelectors != null && message.methodSelectors.length)
                                    for (var i = 0; i < message.methodSelectors.length; ++i)
                                        $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector.encode(message.methodSelectors[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified ApiOperation message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation} message ApiOperation message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            ApiOperation.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an ApiOperation message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation} ApiOperation
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            ApiOperation.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.serviceName = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            if (!(message.methodSelectors && message.methodSelectors.length))
                                                message.methodSelectors = [];
                                            message.methodSelectors.push($root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an ApiOperation message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation} ApiOperation
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            ApiOperation.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an ApiOperation message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            ApiOperation.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.serviceName != null && message.hasOwnProperty("serviceName"))
                                    if (!$util.isString(message.serviceName))
                                        return "serviceName: string expected";
                                if (message.methodSelectors != null && message.hasOwnProperty("methodSelectors")) {
                                    if (!Array.isArray(message.methodSelectors))
                                        return "methodSelectors: array expected";
                                    for (var i = 0; i < message.methodSelectors.length; ++i) {
                                        var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector.verify(message.methodSelectors[i]);
                                        if (error)
                                            return "methodSelectors." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates an ApiOperation message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation} ApiOperation
                             */
                            ApiOperation.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation();
                                if (object.serviceName != null)
                                    message.serviceName = String(object.serviceName);
                                if (object.methodSelectors) {
                                    if (!Array.isArray(object.methodSelectors))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.methodSelectors: array expected");
                                    message.methodSelectors = [];
                                    for (var i = 0; i < object.methodSelectors.length; ++i) {
                                        if (typeof object.methodSelectors[i] !== "object")
                                            throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.methodSelectors: object expected");
                                        message.methodSelectors[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector.fromObject(object.methodSelectors[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an ApiOperation message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation} message ApiOperation
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            ApiOperation.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.methodSelectors = [];
                                if (options.defaults)
                                    object.serviceName = "";
                                if (message.serviceName != null && message.hasOwnProperty("serviceName"))
                                    object.serviceName = message.serviceName;
                                if (message.methodSelectors && message.methodSelectors.length) {
                                    object.methodSelectors = [];
                                    for (var j = 0; j < message.methodSelectors.length; ++j)
                                        object.methodSelectors[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector.toObject(message.methodSelectors[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this ApiOperation to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            ApiOperation.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for ApiOperation
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            ApiOperation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation";
                            };
    
                            return ApiOperation;
                        })();
    
                        ServicePerimeterConfig.IngressSource = (function() {
    
                            /**
                             * Properties of an IngressSource.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IIngressSource
                             * @property {string|null} [accessLevel] IngressSource accessLevel
                             * @property {string|null} [resource] IngressSource resource
                             */
    
                            /**
                             * Constructs a new IngressSource.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an IngressSource.
                             * @implements IIngressSource
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressSource=} [properties] Properties to set
                             */
                            function IngressSource(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * IngressSource accessLevel.
                             * @member {string|null|undefined} accessLevel
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @instance
                             */
                            IngressSource.prototype.accessLevel = null;
    
                            /**
                             * IngressSource resource.
                             * @member {string|null|undefined} resource
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @instance
                             */
                            IngressSource.prototype.resource = null;
    
                            // OneOf field names bound to virtual getters and setters
                            var $oneOfFields;
    
                            /**
                             * IngressSource source.
                             * @member {"accessLevel"|"resource"|undefined} source
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @instance
                             */
                            Object.defineProperty(IngressSource.prototype, "source", {
                                get: $util.oneOfGetter($oneOfFields = ["accessLevel", "resource"]),
                                set: $util.oneOfSetter($oneOfFields)
                            });
    
                            /**
                             * Creates a new IngressSource instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressSource=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource} IngressSource instance
                             */
                            IngressSource.create = function create(properties) {
                                return new IngressSource(properties);
                            };
    
                            /**
                             * Encodes the specified IngressSource message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressSource} message IngressSource message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressSource.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.accessLevel != null && Object.hasOwnProperty.call(message, "accessLevel"))
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.accessLevel);
                                if (message.resource != null && Object.hasOwnProperty.call(message, "resource"))
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.resource);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified IngressSource message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressSource} message IngressSource message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressSource.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an IngressSource message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource} IngressSource
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressSource.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.accessLevel = reader.string();
                                            break;
                                        }
                                    case 2: {
                                            message.resource = reader.string();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an IngressSource message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource} IngressSource
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressSource.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an IngressSource message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            IngressSource.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                var properties = {};
                                if (message.accessLevel != null && message.hasOwnProperty("accessLevel")) {
                                    properties.source = 1;
                                    if (!$util.isString(message.accessLevel))
                                        return "accessLevel: string expected";
                                }
                                if (message.resource != null && message.hasOwnProperty("resource")) {
                                    if (properties.source === 1)
                                        return "source: multiple values";
                                    properties.source = 1;
                                    if (!$util.isString(message.resource))
                                        return "resource: string expected";
                                }
                                return null;
                            };
    
                            /**
                             * Creates an IngressSource message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource} IngressSource
                             */
                            IngressSource.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource();
                                if (object.accessLevel != null)
                                    message.accessLevel = String(object.accessLevel);
                                if (object.resource != null)
                                    message.resource = String(object.resource);
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an IngressSource message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource} message IngressSource
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            IngressSource.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (message.accessLevel != null && message.hasOwnProperty("accessLevel")) {
                                    object.accessLevel = message.accessLevel;
                                    if (options.oneofs)
                                        object.source = "accessLevel";
                                }
                                if (message.resource != null && message.hasOwnProperty("resource")) {
                                    object.resource = message.resource;
                                    if (options.oneofs)
                                        object.source = "resource";
                                }
                                return object;
                            };
    
                            /**
                             * Converts this IngressSource to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            IngressSource.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for IngressSource
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            IngressSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource";
                            };
    
                            return IngressSource;
                        })();
    
                        ServicePerimeterConfig.EgressTo = (function() {
    
                            /**
                             * Properties of an EgressTo.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IEgressTo
                             * @property {Array.<string>|null} [resources] EgressTo resources
                             * @property {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation>|null} [operations] EgressTo operations
                             */
    
                            /**
                             * Constructs a new EgressTo.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an EgressTo.
                             * @implements IEgressTo
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressTo=} [properties] Properties to set
                             */
                            function EgressTo(properties) {
                                this.resources = [];
                                this.operations = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * EgressTo resources.
                             * @member {Array.<string>} resources
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @instance
                             */
                            EgressTo.prototype.resources = $util.emptyArray;
    
                            /**
                             * EgressTo operations.
                             * @member {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation>} operations
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @instance
                             */
                            EgressTo.prototype.operations = $util.emptyArray;
    
                            /**
                             * Creates a new EgressTo instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressTo=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo} EgressTo instance
                             */
                            EgressTo.create = function create(properties) {
                                return new EgressTo(properties);
                            };
    
                            /**
                             * Encodes the specified EgressTo message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressTo} message EgressTo message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            EgressTo.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.resources != null && message.resources.length)
                                    for (var i = 0; i < message.resources.length; ++i)
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.resources[i]);
                                if (message.operations != null && message.operations.length)
                                    for (var i = 0; i < message.operations.length; ++i)
                                        $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.encode(message.operations[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified EgressTo message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressTo} message EgressTo message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            EgressTo.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an EgressTo message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo} EgressTo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            EgressTo.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.resources && message.resources.length))
                                                message.resources = [];
                                            message.resources.push(reader.string());
                                            break;
                                        }
                                    case 2: {
                                            if (!(message.operations && message.operations.length))
                                                message.operations = [];
                                            message.operations.push($root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an EgressTo message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo} EgressTo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            EgressTo.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an EgressTo message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            EgressTo.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.resources != null && message.hasOwnProperty("resources")) {
                                    if (!Array.isArray(message.resources))
                                        return "resources: array expected";
                                    for (var i = 0; i < message.resources.length; ++i)
                                        if (!$util.isString(message.resources[i]))
                                            return "resources: string[] expected";
                                }
                                if (message.operations != null && message.hasOwnProperty("operations")) {
                                    if (!Array.isArray(message.operations))
                                        return "operations: array expected";
                                    for (var i = 0; i < message.operations.length; ++i) {
                                        var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.verify(message.operations[i]);
                                        if (error)
                                            return "operations." + error;
                                    }
                                }
                                return null;
                            };
    
                            /**
                             * Creates an EgressTo message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo} EgressTo
                             */
                            EgressTo.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo();
                                if (object.resources) {
                                    if (!Array.isArray(object.resources))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.resources: array expected");
                                    message.resources = [];
                                    for (var i = 0; i < object.resources.length; ++i)
                                        message.resources[i] = String(object.resources[i]);
                                }
                                if (object.operations) {
                                    if (!Array.isArray(object.operations))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.operations: array expected");
                                    message.operations = [];
                                    for (var i = 0; i < object.operations.length; ++i) {
                                        if (typeof object.operations[i] !== "object")
                                            throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.operations: object expected");
                                        message.operations[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.fromObject(object.operations[i]);
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an EgressTo message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo} message EgressTo
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            EgressTo.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults) {
                                    object.resources = [];
                                    object.operations = [];
                                }
                                if (message.resources && message.resources.length) {
                                    object.resources = [];
                                    for (var j = 0; j < message.resources.length; ++j)
                                        object.resources[j] = message.resources[j];
                                }
                                if (message.operations && message.operations.length) {
                                    object.operations = [];
                                    for (var j = 0; j < message.operations.length; ++j)
                                        object.operations[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.toObject(message.operations[j], options);
                                }
                                return object;
                            };
    
                            /**
                             * Converts this EgressTo to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            EgressTo.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for EgressTo
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            EgressTo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo";
                            };
    
                            return EgressTo;
                        })();
    
                        ServicePerimeterConfig.IngressFrom = (function() {
    
                            /**
                             * Properties of an IngressFrom.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IIngressFrom
                             * @property {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressSource>|null} [sources] IngressFrom sources
                             * @property {Array.<string>|null} [identities] IngressFrom identities
                             * @property {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType|null} [identityType] IngressFrom identityType
                             */
    
                            /**
                             * Constructs a new IngressFrom.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an IngressFrom.
                             * @implements IIngressFrom
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressFrom=} [properties] Properties to set
                             */
                            function IngressFrom(properties) {
                                this.sources = [];
                                this.identities = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * IngressFrom sources.
                             * @member {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressSource>} sources
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @instance
                             */
                            IngressFrom.prototype.sources = $util.emptyArray;
    
                            /**
                             * IngressFrom identities.
                             * @member {Array.<string>} identities
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @instance
                             */
                            IngressFrom.prototype.identities = $util.emptyArray;
    
                            /**
                             * IngressFrom identityType.
                             * @member {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType} identityType
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @instance
                             */
                            IngressFrom.prototype.identityType = 0;
    
                            /**
                             * Creates a new IngressFrom instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressFrom=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom} IngressFrom instance
                             */
                            IngressFrom.create = function create(properties) {
                                return new IngressFrom(properties);
                            };
    
                            /**
                             * Encodes the specified IngressFrom message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressFrom} message IngressFrom message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressFrom.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.sources != null && message.sources.length)
                                    for (var i = 0; i < message.sources.length; ++i)
                                        $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource.encode(message.sources[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                if (message.identities != null && message.identities.length)
                                    for (var i = 0; i < message.identities.length; ++i)
                                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.identities[i]);
                                if (message.identityType != null && Object.hasOwnProperty.call(message, "identityType"))
                                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.identityType);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified IngressFrom message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressFrom} message IngressFrom message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressFrom.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an IngressFrom message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom} IngressFrom
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressFrom.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.sources && message.sources.length))
                                                message.sources = [];
                                            message.sources.push($root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    case 2: {
                                            if (!(message.identities && message.identities.length))
                                                message.identities = [];
                                            message.identities.push(reader.string());
                                            break;
                                        }
                                    case 3: {
                                            message.identityType = reader.int32();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an IngressFrom message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom} IngressFrom
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressFrom.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an IngressFrom message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            IngressFrom.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.sources != null && message.hasOwnProperty("sources")) {
                                    if (!Array.isArray(message.sources))
                                        return "sources: array expected";
                                    for (var i = 0; i < message.sources.length; ++i) {
                                        var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource.verify(message.sources[i]);
                                        if (error)
                                            return "sources." + error;
                                    }
                                }
                                if (message.identities != null && message.hasOwnProperty("identities")) {
                                    if (!Array.isArray(message.identities))
                                        return "identities: array expected";
                                    for (var i = 0; i < message.identities.length; ++i)
                                        if (!$util.isString(message.identities[i]))
                                            return "identities: string[] expected";
                                }
                                if (message.identityType != null && message.hasOwnProperty("identityType"))
                                    switch (message.identityType) {
                                    default:
                                        return "identityType: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                        break;
                                    }
                                return null;
                            };
    
                            /**
                             * Creates an IngressFrom message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom} IngressFrom
                             */
                            IngressFrom.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom();
                                if (object.sources) {
                                    if (!Array.isArray(object.sources))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.sources: array expected");
                                    message.sources = [];
                                    for (var i = 0; i < object.sources.length; ++i) {
                                        if (typeof object.sources[i] !== "object")
                                            throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.sources: object expected");
                                        message.sources[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource.fromObject(object.sources[i]);
                                    }
                                }
                                if (object.identities) {
                                    if (!Array.isArray(object.identities))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.identities: array expected");
                                    message.identities = [];
                                    for (var i = 0; i < object.identities.length; ++i)
                                        message.identities[i] = String(object.identities[i]);
                                }
                                switch (object.identityType) {
                                case "IDENTITY_TYPE_UNSPECIFIED":
                                case 0:
                                    message.identityType = 0;
                                    break;
                                case "ANY_IDENTITY":
                                case 1:
                                    message.identityType = 1;
                                    break;
                                case "ANY_USER_ACCOUNT":
                                case 2:
                                    message.identityType = 2;
                                    break;
                                case "ANY_SERVICE_ACCOUNT":
                                case 3:
                                    message.identityType = 3;
                                    break;
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an IngressFrom message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom} message IngressFrom
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            IngressFrom.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults) {
                                    object.sources = [];
                                    object.identities = [];
                                }
                                if (options.defaults)
                                    object.identityType = options.enums === String ? "IDENTITY_TYPE_UNSPECIFIED" : 0;
                                if (message.sources && message.sources.length) {
                                    object.sources = [];
                                    for (var j = 0; j < message.sources.length; ++j)
                                        object.sources[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource.toObject(message.sources[j], options);
                                }
                                if (message.identities && message.identities.length) {
                                    object.identities = [];
                                    for (var j = 0; j < message.identities.length; ++j)
                                        object.identities[j] = message.identities[j];
                                }
                                if (message.identityType != null && message.hasOwnProperty("identityType"))
                                    object.identityType = options.enums === String ? $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType[message.identityType] : message.identityType;
                                return object;
                            };
    
                            /**
                             * Converts this IngressFrom to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            IngressFrom.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for IngressFrom
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            IngressFrom.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom";
                            };
    
                            return IngressFrom;
                        })();
    
                        ServicePerimeterConfig.IngressTo = (function() {
    
                            /**
                             * Properties of an IngressTo.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IIngressTo
                             * @property {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation>|null} [operations] IngressTo operations
                             * @property {Array.<string>|null} [resources] IngressTo resources
                             */
    
                            /**
                             * Constructs a new IngressTo.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an IngressTo.
                             * @implements IIngressTo
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressTo=} [properties] Properties to set
                             */
                            function IngressTo(properties) {
                                this.operations = [];
                                this.resources = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * IngressTo operations.
                             * @member {Array.<google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IApiOperation>} operations
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @instance
                             */
                            IngressTo.prototype.operations = $util.emptyArray;
    
                            /**
                             * IngressTo resources.
                             * @member {Array.<string>} resources
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @instance
                             */
                            IngressTo.prototype.resources = $util.emptyArray;
    
                            /**
                             * Creates a new IngressTo instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressTo=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo} IngressTo instance
                             */
                            IngressTo.create = function create(properties) {
                                return new IngressTo(properties);
                            };
    
                            /**
                             * Encodes the specified IngressTo message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressTo} message IngressTo message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressTo.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.operations != null && message.operations.length)
                                    for (var i = 0; i < message.operations.length; ++i)
                                        $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.encode(message.operations[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                if (message.resources != null && message.resources.length)
                                    for (var i = 0; i < message.resources.length; ++i)
                                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.resources[i]);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified IngressTo message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressTo} message IngressTo message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressTo.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an IngressTo message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo} IngressTo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressTo.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.operations && message.operations.length))
                                                message.operations = [];
                                            message.operations.push($root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.decode(reader, reader.uint32()));
                                            break;
                                        }
                                    case 2: {
                                            if (!(message.resources && message.resources.length))
                                                message.resources = [];
                                            message.resources.push(reader.string());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an IngressTo message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo} IngressTo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressTo.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an IngressTo message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            IngressTo.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.operations != null && message.hasOwnProperty("operations")) {
                                    if (!Array.isArray(message.operations))
                                        return "operations: array expected";
                                    for (var i = 0; i < message.operations.length; ++i) {
                                        var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.verify(message.operations[i]);
                                        if (error)
                                            return "operations." + error;
                                    }
                                }
                                if (message.resources != null && message.hasOwnProperty("resources")) {
                                    if (!Array.isArray(message.resources))
                                        return "resources: array expected";
                                    for (var i = 0; i < message.resources.length; ++i)
                                        if (!$util.isString(message.resources[i]))
                                            return "resources: string[] expected";
                                }
                                return null;
                            };
    
                            /**
                             * Creates an IngressTo message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo} IngressTo
                             */
                            IngressTo.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo();
                                if (object.operations) {
                                    if (!Array.isArray(object.operations))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.operations: array expected");
                                    message.operations = [];
                                    for (var i = 0; i < object.operations.length; ++i) {
                                        if (typeof object.operations[i] !== "object")
                                            throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.operations: object expected");
                                        message.operations[i] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.fromObject(object.operations[i]);
                                    }
                                }
                                if (object.resources) {
                                    if (!Array.isArray(object.resources))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.resources: array expected");
                                    message.resources = [];
                                    for (var i = 0; i < object.resources.length; ++i)
                                        message.resources[i] = String(object.resources[i]);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an IngressTo message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo} message IngressTo
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            IngressTo.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults) {
                                    object.operations = [];
                                    object.resources = [];
                                }
                                if (message.operations && message.operations.length) {
                                    object.operations = [];
                                    for (var j = 0; j < message.operations.length; ++j)
                                        object.operations[j] = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.toObject(message.operations[j], options);
                                }
                                if (message.resources && message.resources.length) {
                                    object.resources = [];
                                    for (var j = 0; j < message.resources.length; ++j)
                                        object.resources[j] = message.resources[j];
                                }
                                return object;
                            };
    
                            /**
                             * Converts this IngressTo to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            IngressTo.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for IngressTo
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            IngressTo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo";
                            };
    
                            return IngressTo;
                        })();
    
                        ServicePerimeterConfig.IngressPolicy = (function() {
    
                            /**
                             * Properties of an IngressPolicy.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IIngressPolicy
                             * @property {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressFrom|null} [ingressFrom] IngressPolicy ingressFrom
                             * @property {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressTo|null} [ingressTo] IngressPolicy ingressTo
                             */
    
                            /**
                             * Constructs a new IngressPolicy.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an IngressPolicy.
                             * @implements IIngressPolicy
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressPolicy=} [properties] Properties to set
                             */
                            function IngressPolicy(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * IngressPolicy ingressFrom.
                             * @member {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressFrom|null|undefined} ingressFrom
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @instance
                             */
                            IngressPolicy.prototype.ingressFrom = null;
    
                            /**
                             * IngressPolicy ingressTo.
                             * @member {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressTo|null|undefined} ingressTo
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @instance
                             */
                            IngressPolicy.prototype.ingressTo = null;
    
                            /**
                             * Creates a new IngressPolicy instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressPolicy=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy} IngressPolicy instance
                             */
                            IngressPolicy.create = function create(properties) {
                                return new IngressPolicy(properties);
                            };
    
                            /**
                             * Encodes the specified IngressPolicy message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressPolicy} message IngressPolicy message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressPolicy.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.ingressFrom != null && Object.hasOwnProperty.call(message, "ingressFrom"))
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.encode(message.ingressFrom, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                if (message.ingressTo != null && Object.hasOwnProperty.call(message, "ingressTo"))
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.encode(message.ingressTo, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified IngressPolicy message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IIngressPolicy} message IngressPolicy message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            IngressPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an IngressPolicy message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy} IngressPolicy
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressPolicy.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.ingressFrom = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.decode(reader, reader.uint32());
                                            break;
                                        }
                                    case 2: {
                                            message.ingressTo = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.decode(reader, reader.uint32());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an IngressPolicy message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy} IngressPolicy
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            IngressPolicy.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an IngressPolicy message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            IngressPolicy.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.ingressFrom != null && message.hasOwnProperty("ingressFrom")) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.verify(message.ingressFrom);
                                    if (error)
                                        return "ingressFrom." + error;
                                }
                                if (message.ingressTo != null && message.hasOwnProperty("ingressTo")) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.verify(message.ingressTo);
                                    if (error)
                                        return "ingressTo." + error;
                                }
                                return null;
                            };
    
                            /**
                             * Creates an IngressPolicy message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy} IngressPolicy
                             */
                            IngressPolicy.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy();
                                if (object.ingressFrom != null) {
                                    if (typeof object.ingressFrom !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.ingressFrom: object expected");
                                    message.ingressFrom = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.fromObject(object.ingressFrom);
                                }
                                if (object.ingressTo != null) {
                                    if (typeof object.ingressTo !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.ingressTo: object expected");
                                    message.ingressTo = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.fromObject(object.ingressTo);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an IngressPolicy message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy} message IngressPolicy
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            IngressPolicy.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.ingressFrom = null;
                                    object.ingressTo = null;
                                }
                                if (message.ingressFrom != null && message.hasOwnProperty("ingressFrom"))
                                    object.ingressFrom = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.toObject(message.ingressFrom, options);
                                if (message.ingressTo != null && message.hasOwnProperty("ingressTo"))
                                    object.ingressTo = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.toObject(message.ingressTo, options);
                                return object;
                            };
    
                            /**
                             * Converts this IngressPolicy to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            IngressPolicy.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for IngressPolicy
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            IngressPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy";
                            };
    
                            return IngressPolicy;
                        })();
    
                        ServicePerimeterConfig.EgressPolicy = (function() {
    
                            /**
                             * Properties of an EgressPolicy.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IEgressPolicy
                             * @property {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressFrom|null} [egressFrom] EgressPolicy egressFrom
                             * @property {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressTo|null} [egressTo] EgressPolicy egressTo
                             */
    
                            /**
                             * Constructs a new EgressPolicy.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an EgressPolicy.
                             * @implements IEgressPolicy
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressPolicy=} [properties] Properties to set
                             */
                            function EgressPolicy(properties) {
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * EgressPolicy egressFrom.
                             * @member {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressFrom|null|undefined} egressFrom
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @instance
                             */
                            EgressPolicy.prototype.egressFrom = null;
    
                            /**
                             * EgressPolicy egressTo.
                             * @member {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressTo|null|undefined} egressTo
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @instance
                             */
                            EgressPolicy.prototype.egressTo = null;
    
                            /**
                             * Creates a new EgressPolicy instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressPolicy=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy} EgressPolicy instance
                             */
                            EgressPolicy.create = function create(properties) {
                                return new EgressPolicy(properties);
                            };
    
                            /**
                             * Encodes the specified EgressPolicy message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressPolicy} message EgressPolicy message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            EgressPolicy.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.egressFrom != null && Object.hasOwnProperty.call(message, "egressFrom"))
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.encode(message.egressFrom, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                                if (message.egressTo != null && Object.hasOwnProperty.call(message, "egressTo"))
                                    $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.encode(message.egressTo, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                                return writer;
                            };
    
                            /**
                             * Encodes the specified EgressPolicy message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressPolicy} message EgressPolicy message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            EgressPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an EgressPolicy message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy} EgressPolicy
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            EgressPolicy.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            message.egressFrom = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.decode(reader, reader.uint32());
                                            break;
                                        }
                                    case 2: {
                                            message.egressTo = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.decode(reader, reader.uint32());
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an EgressPolicy message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy} EgressPolicy
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            EgressPolicy.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an EgressPolicy message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            EgressPolicy.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.egressFrom != null && message.hasOwnProperty("egressFrom")) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.verify(message.egressFrom);
                                    if (error)
                                        return "egressFrom." + error;
                                }
                                if (message.egressTo != null && message.hasOwnProperty("egressTo")) {
                                    var error = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.verify(message.egressTo);
                                    if (error)
                                        return "egressTo." + error;
                                }
                                return null;
                            };
    
                            /**
                             * Creates an EgressPolicy message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy} EgressPolicy
                             */
                            EgressPolicy.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy();
                                if (object.egressFrom != null) {
                                    if (typeof object.egressFrom !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.egressFrom: object expected");
                                    message.egressFrom = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.fromObject(object.egressFrom);
                                }
                                if (object.egressTo != null) {
                                    if (typeof object.egressTo !== "object")
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.egressTo: object expected");
                                    message.egressTo = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.fromObject(object.egressTo);
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an EgressPolicy message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy} message EgressPolicy
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            EgressPolicy.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.defaults) {
                                    object.egressFrom = null;
                                    object.egressTo = null;
                                }
                                if (message.egressFrom != null && message.hasOwnProperty("egressFrom"))
                                    object.egressFrom = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.toObject(message.egressFrom, options);
                                if (message.egressTo != null && message.hasOwnProperty("egressTo"))
                                    object.egressTo = $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.toObject(message.egressTo, options);
                                return object;
                            };
    
                            /**
                             * Converts this EgressPolicy to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            EgressPolicy.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for EgressPolicy
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            EgressPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy";
                            };
    
                            return EgressPolicy;
                        })();
    
                        ServicePerimeterConfig.EgressFrom = (function() {
    
                            /**
                             * Properties of an EgressFrom.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @interface IEgressFrom
                             * @property {Array.<string>|null} [identities] EgressFrom identities
                             * @property {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType|null} [identityType] EgressFrom identityType
                             */
    
                            /**
                             * Constructs a new EgressFrom.
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig
                             * @classdesc Represents an EgressFrom.
                             * @implements IEgressFrom
                             * @constructor
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressFrom=} [properties] Properties to set
                             */
                            function EgressFrom(properties) {
                                this.identities = [];
                                if (properties)
                                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                        if (properties[keys[i]] != null)
                                            this[keys[i]] = properties[keys[i]];
                            }
    
                            /**
                             * EgressFrom identities.
                             * @member {Array.<string>} identities
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @instance
                             */
                            EgressFrom.prototype.identities = $util.emptyArray;
    
                            /**
                             * EgressFrom identityType.
                             * @member {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType} identityType
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @instance
                             */
                            EgressFrom.prototype.identityType = 0;
    
                            /**
                             * Creates a new EgressFrom instance using the specified properties.
                             * @function create
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressFrom=} [properties] Properties to set
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom} EgressFrom instance
                             */
                            EgressFrom.create = function create(properties) {
                                return new EgressFrom(properties);
                            };
    
                            /**
                             * Encodes the specified EgressFrom message. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.verify|verify} messages.
                             * @function encode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressFrom} message EgressFrom message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            EgressFrom.encode = function encode(message, writer) {
                                if (!writer)
                                    writer = $Writer.create();
                                if (message.identities != null && message.identities.length)
                                    for (var i = 0; i < message.identities.length; ++i)
                                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.identities[i]);
                                if (message.identityType != null && Object.hasOwnProperty.call(message, "identityType"))
                                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.identityType);
                                return writer;
                            };
    
                            /**
                             * Encodes the specified EgressFrom message, length delimited. Does not implicitly {@link google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.verify|verify} messages.
                             * @function encodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IEgressFrom} message EgressFrom message or plain object to encode
                             * @param {$protobuf.Writer} [writer] Writer to encode to
                             * @returns {$protobuf.Writer} Writer
                             */
                            EgressFrom.encodeDelimited = function encodeDelimited(message, writer) {
                                return this.encode(message, writer).ldelim();
                            };
    
                            /**
                             * Decodes an EgressFrom message from the specified reader or buffer.
                             * @function decode
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @param {number} [length] Message length if known beforehand
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom} EgressFrom
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            EgressFrom.decode = function decode(reader, length) {
                                if (!(reader instanceof $Reader))
                                    reader = $Reader.create(reader);
                                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom();
                                while (reader.pos < end) {
                                    var tag = reader.uint32();
                                    switch (tag >>> 3) {
                                    case 1: {
                                            if (!(message.identities && message.identities.length))
                                                message.identities = [];
                                            message.identities.push(reader.string());
                                            break;
                                        }
                                    case 2: {
                                            message.identityType = reader.int32();
                                            break;
                                        }
                                    default:
                                        reader.skipType(tag & 7);
                                        break;
                                    }
                                }
                                return message;
                            };
    
                            /**
                             * Decodes an EgressFrom message from the specified reader or buffer, length delimited.
                             * @function decodeDelimited
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom} EgressFrom
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            EgressFrom.decodeDelimited = function decodeDelimited(reader) {
                                if (!(reader instanceof $Reader))
                                    reader = new $Reader(reader);
                                return this.decode(reader, reader.uint32());
                            };
    
                            /**
                             * Verifies an EgressFrom message.
                             * @function verify
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {Object.<string,*>} message Plain object to verify
                             * @returns {string|null} `null` if valid, otherwise the reason why it is not
                             */
                            EgressFrom.verify = function verify(message) {
                                if (typeof message !== "object" || message === null)
                                    return "object expected";
                                if (message.identities != null && message.hasOwnProperty("identities")) {
                                    if (!Array.isArray(message.identities))
                                        return "identities: array expected";
                                    for (var i = 0; i < message.identities.length; ++i)
                                        if (!$util.isString(message.identities[i]))
                                            return "identities: string[] expected";
                                }
                                if (message.identityType != null && message.hasOwnProperty("identityType"))
                                    switch (message.identityType) {
                                    default:
                                        return "identityType: enum value expected";
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                        break;
                                    }
                                return null;
                            };
    
                            /**
                             * Creates an EgressFrom message from a plain object. Also converts values to their respective internal types.
                             * @function fromObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {Object.<string,*>} object Plain object
                             * @returns {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom} EgressFrom
                             */
                            EgressFrom.fromObject = function fromObject(object) {
                                if (object instanceof $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom)
                                    return object;
                                var message = new $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom();
                                if (object.identities) {
                                    if (!Array.isArray(object.identities))
                                        throw TypeError(".google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.identities: array expected");
                                    message.identities = [];
                                    for (var i = 0; i < object.identities.length; ++i)
                                        message.identities[i] = String(object.identities[i]);
                                }
                                switch (object.identityType) {
                                case "IDENTITY_TYPE_UNSPECIFIED":
                                case 0:
                                    message.identityType = 0;
                                    break;
                                case "ANY_IDENTITY":
                                case 1:
                                    message.identityType = 1;
                                    break;
                                case "ANY_USER_ACCOUNT":
                                case 2:
                                    message.identityType = 2;
                                    break;
                                case "ANY_SERVICE_ACCOUNT":
                                case 3:
                                    message.identityType = 3;
                                    break;
                                }
                                return message;
                            };
    
                            /**
                             * Creates a plain object from an EgressFrom message. Also converts values to other types if specified.
                             * @function toObject
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom} message EgressFrom
                             * @param {$protobuf.IConversionOptions} [options] Conversion options
                             * @returns {Object.<string,*>} Plain object
                             */
                            EgressFrom.toObject = function toObject(message, options) {
                                if (!options)
                                    options = {};
                                var object = {};
                                if (options.arrays || options.defaults)
                                    object.identities = [];
                                if (options.defaults)
                                    object.identityType = options.enums === String ? "IDENTITY_TYPE_UNSPECIFIED" : 0;
                                if (message.identities && message.identities.length) {
                                    object.identities = [];
                                    for (var j = 0; j < message.identities.length; ++j)
                                        object.identities[j] = message.identities[j];
                                }
                                if (message.identityType != null && message.hasOwnProperty("identityType"))
                                    object.identityType = options.enums === String ? $root.google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType[message.identityType] : message.identityType;
                                return object;
                            };
    
                            /**
                             * Converts this EgressFrom to JSON.
                             * @function toJSON
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @instance
                             * @returns {Object.<string,*>} JSON object
                             */
                            EgressFrom.prototype.toJSON = function toJSON() {
                                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                            };
    
                            /**
                             * Gets the default type url for EgressFrom
                             * @function getTypeUrl
                             * @memberof google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
                             * @static
                             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                             * @returns {string} The default type url
                             */
                            EgressFrom.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                                if (typeUrlPrefix === undefined) {
                                    typeUrlPrefix = "type.googleapis.com";
                                }
                                return typeUrlPrefix + "/google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom";
                            };
    
                            return EgressFrom;
                        })();
    
                        /**
                         * IdentityType enum.
                         * @name google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType
                         * @enum {number}
                         * @property {number} IDENTITY_TYPE_UNSPECIFIED=0 IDENTITY_TYPE_UNSPECIFIED value
                         * @property {number} ANY_IDENTITY=1 ANY_IDENTITY value
                         * @property {number} ANY_USER_ACCOUNT=2 ANY_USER_ACCOUNT value
                         * @property {number} ANY_SERVICE_ACCOUNT=3 ANY_SERVICE_ACCOUNT value
                         */
                        ServicePerimeterConfig.IdentityType = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "IDENTITY_TYPE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "ANY_IDENTITY"] = 1;
                            values[valuesById[2] = "ANY_USER_ACCOUNT"] = 2;
                            values[valuesById[3] = "ANY_SERVICE_ACCOUNT"] = 3;
                            return values;
                        })();
    
                        return ServicePerimeterConfig;
                    })();
    
                    return v1;
                })();
    
                return accesscontextmanager;
            })();
    
            return identity;
        })();
    
        google.api = (function() {
    
            /**
             * Namespace api.
             * @memberof google
             * @namespace
             */
            var api = {};
    
            api.Http = (function() {
    
                /**
                 * Properties of a Http.
                 * @memberof google.api
                 * @interface IHttp
                 * @property {Array.<google.api.IHttpRule>|null} [rules] Http rules
                 * @property {boolean|null} [fullyDecodeReservedExpansion] Http fullyDecodeReservedExpansion
                 */
    
                /**
                 * Constructs a new Http.
                 * @memberof google.api
                 * @classdesc Represents a Http.
                 * @implements IHttp
                 * @constructor
                 * @param {google.api.IHttp=} [properties] Properties to set
                 */
                function Http(properties) {
                    this.rules = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Http rules.
                 * @member {Array.<google.api.IHttpRule>} rules
                 * @memberof google.api.Http
                 * @instance
                 */
                Http.prototype.rules = $util.emptyArray;
    
                /**
                 * Http fullyDecodeReservedExpansion.
                 * @member {boolean} fullyDecodeReservedExpansion
                 * @memberof google.api.Http
                 * @instance
                 */
                Http.prototype.fullyDecodeReservedExpansion = false;
    
                /**
                 * Creates a new Http instance using the specified properties.
                 * @function create
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp=} [properties] Properties to set
                 * @returns {google.api.Http} Http instance
                 */
                Http.create = function create(properties) {
                    return new Http(properties);
                };
    
                /**
                 * Encodes the specified Http message. Does not implicitly {@link google.api.Http.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp} message Http message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Http.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.rules != null && message.rules.length)
                        for (var i = 0; i < message.rules.length; ++i)
                            $root.google.api.HttpRule.encode(message.rules[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.fullyDecodeReservedExpansion != null && Object.hasOwnProperty.call(message, "fullyDecodeReservedExpansion"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.fullyDecodeReservedExpansion);
                    return writer;
                };
    
                /**
                 * Encodes the specified Http message, length delimited. Does not implicitly {@link google.api.Http.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp} message Http message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Http.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a Http message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.Http
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.Http} Http
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Http.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.Http();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                if (!(message.rules && message.rules.length))
                                    message.rules = [];
                                message.rules.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
                                break;
                            }
                        case 2: {
                                message.fullyDecodeReservedExpansion = reader.bool();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a Http message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.Http
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.Http} Http
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Http.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a Http message.
                 * @function verify
                 * @memberof google.api.Http
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Http.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.rules != null && message.hasOwnProperty("rules")) {
                        if (!Array.isArray(message.rules))
                            return "rules: array expected";
                        for (var i = 0; i < message.rules.length; ++i) {
                            var error = $root.google.api.HttpRule.verify(message.rules[i]);
                            if (error)
                                return "rules." + error;
                        }
                    }
                    if (message.fullyDecodeReservedExpansion != null && message.hasOwnProperty("fullyDecodeReservedExpansion"))
                        if (typeof message.fullyDecodeReservedExpansion !== "boolean")
                            return "fullyDecodeReservedExpansion: boolean expected";
                    return null;
                };
    
                /**
                 * Creates a Http message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.Http
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.Http} Http
                 */
                Http.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.Http)
                        return object;
                    var message = new $root.google.api.Http();
                    if (object.rules) {
                        if (!Array.isArray(object.rules))
                            throw TypeError(".google.api.Http.rules: array expected");
                        message.rules = [];
                        for (var i = 0; i < object.rules.length; ++i) {
                            if (typeof object.rules[i] !== "object")
                                throw TypeError(".google.api.Http.rules: object expected");
                            message.rules[i] = $root.google.api.HttpRule.fromObject(object.rules[i]);
                        }
                    }
                    if (object.fullyDecodeReservedExpansion != null)
                        message.fullyDecodeReservedExpansion = Boolean(object.fullyDecodeReservedExpansion);
                    return message;
                };
    
                /**
                 * Creates a plain object from a Http message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.Http} message Http
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Http.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.rules = [];
                    if (options.defaults)
                        object.fullyDecodeReservedExpansion = false;
                    if (message.rules && message.rules.length) {
                        object.rules = [];
                        for (var j = 0; j < message.rules.length; ++j)
                            object.rules[j] = $root.google.api.HttpRule.toObject(message.rules[j], options);
                    }
                    if (message.fullyDecodeReservedExpansion != null && message.hasOwnProperty("fullyDecodeReservedExpansion"))
                        object.fullyDecodeReservedExpansion = message.fullyDecodeReservedExpansion;
                    return object;
                };
    
                /**
                 * Converts this Http to JSON.
                 * @function toJSON
                 * @memberof google.api.Http
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Http.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                /**
                 * Gets the default type url for Http
                 * @function getTypeUrl
                 * @memberof google.api.Http
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                Http.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/google.api.Http";
                };
    
                return Http;
            })();
    
            api.HttpRule = (function() {
    
                /**
                 * Properties of a HttpRule.
                 * @memberof google.api
                 * @interface IHttpRule
                 * @property {string|null} [selector] HttpRule selector
                 * @property {string|null} [get] HttpRule get
                 * @property {string|null} [put] HttpRule put
                 * @property {string|null} [post] HttpRule post
                 * @property {string|null} ["delete"] HttpRule delete
                 * @property {string|null} [patch] HttpRule patch
                 * @property {google.api.ICustomHttpPattern|null} [custom] HttpRule custom
                 * @property {string|null} [body] HttpRule body
                 * @property {string|null} [responseBody] HttpRule responseBody
                 * @property {Array.<google.api.IHttpRule>|null} [additionalBindings] HttpRule additionalBindings
                 */
    
                /**
                 * Constructs a new HttpRule.
                 * @memberof google.api
                 * @classdesc Represents a HttpRule.
                 * @implements IHttpRule
                 * @constructor
                 * @param {google.api.IHttpRule=} [properties] Properties to set
                 */
                function HttpRule(properties) {
                    this.additionalBindings = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * HttpRule selector.
                 * @member {string} selector
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.selector = "";
    
                /**
                 * HttpRule get.
                 * @member {string|null|undefined} get
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.get = null;
    
                /**
                 * HttpRule put.
                 * @member {string|null|undefined} put
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.put = null;
    
                /**
                 * HttpRule post.
                 * @member {string|null|undefined} post
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.post = null;
    
                /**
                 * HttpRule delete.
                 * @member {string|null|undefined} delete
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype["delete"] = null;
    
                /**
                 * HttpRule patch.
                 * @member {string|null|undefined} patch
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.patch = null;
    
                /**
                 * HttpRule custom.
                 * @member {google.api.ICustomHttpPattern|null|undefined} custom
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.custom = null;
    
                /**
                 * HttpRule body.
                 * @member {string} body
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.body = "";
    
                /**
                 * HttpRule responseBody.
                 * @member {string} responseBody
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.responseBody = "";
    
                /**
                 * HttpRule additionalBindings.
                 * @member {Array.<google.api.IHttpRule>} additionalBindings
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.additionalBindings = $util.emptyArray;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * HttpRule pattern.
                 * @member {"get"|"put"|"post"|"delete"|"patch"|"custom"|undefined} pattern
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                Object.defineProperty(HttpRule.prototype, "pattern", {
                    get: $util.oneOfGetter($oneOfFields = ["get", "put", "post", "delete", "patch", "custom"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new HttpRule instance using the specified properties.
                 * @function create
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule=} [properties] Properties to set
                 * @returns {google.api.HttpRule} HttpRule instance
                 */
                HttpRule.create = function create(properties) {
                    return new HttpRule(properties);
                };
    
                /**
                 * Encodes the specified HttpRule message. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                HttpRule.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.selector != null && Object.hasOwnProperty.call(message, "selector"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.selector);
                    if (message.get != null && Object.hasOwnProperty.call(message, "get"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.get);
                    if (message.put != null && Object.hasOwnProperty.call(message, "put"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.put);
                    if (message.post != null && Object.hasOwnProperty.call(message, "post"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.post);
                    if (message["delete"] != null && Object.hasOwnProperty.call(message, "delete"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message["delete"]);
                    if (message.patch != null && Object.hasOwnProperty.call(message, "patch"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.patch);
                    if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                        writer.uint32(/* id 7, wireType 2 =*/58).string(message.body);
                    if (message.custom != null && Object.hasOwnProperty.call(message, "custom"))
                        $root.google.api.CustomHttpPattern.encode(message.custom, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.additionalBindings != null && message.additionalBindings.length)
                        for (var i = 0; i < message.additionalBindings.length; ++i)
                            $root.google.api.HttpRule.encode(message.additionalBindings[i], writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                    if (message.responseBody != null && Object.hasOwnProperty.call(message, "responseBody"))
                        writer.uint32(/* id 12, wireType 2 =*/98).string(message.responseBody);
                    return writer;
                };
    
                /**
                 * Encodes the specified HttpRule message, length delimited. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                HttpRule.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a HttpRule message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.HttpRule} HttpRule
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                HttpRule.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.HttpRule();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.selector = reader.string();
                                break;
                            }
                        case 2: {
                                message.get = reader.string();
                                break;
                            }
                        case 3: {
                                message.put = reader.string();
                                break;
                            }
                        case 4: {
                                message.post = reader.string();
                                break;
                            }
                        case 5: {
                                message["delete"] = reader.string();
                                break;
                            }
                        case 6: {
                                message.patch = reader.string();
                                break;
                            }
                        case 8: {
                                message.custom = $root.google.api.CustomHttpPattern.decode(reader, reader.uint32());
                                break;
                            }
                        case 7: {
                                message.body = reader.string();
                                break;
                            }
                        case 12: {
                                message.responseBody = reader.string();
                                break;
                            }
                        case 11: {
                                if (!(message.additionalBindings && message.additionalBindings.length))
                                    message.additionalBindings = [];
                                message.additionalBindings.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a HttpRule message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.HttpRule} HttpRule
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                HttpRule.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a HttpRule message.
                 * @function verify
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                HttpRule.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.selector != null && message.hasOwnProperty("selector"))
                        if (!$util.isString(message.selector))
                            return "selector: string expected";
                    if (message.get != null && message.hasOwnProperty("get")) {
                        properties.pattern = 1;
                        if (!$util.isString(message.get))
                            return "get: string expected";
                    }
                    if (message.put != null && message.hasOwnProperty("put")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.put))
                            return "put: string expected";
                    }
                    if (message.post != null && message.hasOwnProperty("post")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.post))
                            return "post: string expected";
                    }
                    if (message["delete"] != null && message.hasOwnProperty("delete")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message["delete"]))
                            return "delete: string expected";
                    }
                    if (message.patch != null && message.hasOwnProperty("patch")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.patch))
                            return "patch: string expected";
                    }
                    if (message.custom != null && message.hasOwnProperty("custom")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        {
                            var error = $root.google.api.CustomHttpPattern.verify(message.custom);
                            if (error)
                                return "custom." + error;
                        }
                    }
                    if (message.body != null && message.hasOwnProperty("body"))
                        if (!$util.isString(message.body))
                            return "body: string expected";
                    if (message.responseBody != null && message.hasOwnProperty("responseBody"))
                        if (!$util.isString(message.responseBody))
                            return "responseBody: string expected";
                    if (message.additionalBindings != null && message.hasOwnProperty("additionalBindings")) {
                        if (!Array.isArray(message.additionalBindings))
                            return "additionalBindings: array expected";
                        for (var i = 0; i < message.additionalBindings.length; ++i) {
                            var error = $root.google.api.HttpRule.verify(message.additionalBindings[i]);
                            if (error)
                                return "additionalBindings." + error;
                        }
                    }
                    return null;
                };
    
                /**
                 * Creates a HttpRule message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.HttpRule} HttpRule
                 */
                HttpRule.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.HttpRule)
                        return object;
                    var message = new $root.google.api.HttpRule();
                    if (object.selector != null)
                        message.selector = String(object.selector);
                    if (object.get != null)
                        message.get = String(object.get);
                    if (object.put != null)
                        message.put = String(object.put);
                    if (object.post != null)
                        message.post = String(object.post);
                    if (object["delete"] != null)
                        message["delete"] = String(object["delete"]);
                    if (object.patch != null)
                        message.patch = String(object.patch);
                    if (object.custom != null) {
                        if (typeof object.custom !== "object")
                            throw TypeError(".google.api.HttpRule.custom: object expected");
                        message.custom = $root.google.api.CustomHttpPattern.fromObject(object.custom);
                    }
                    if (object.body != null)
                        message.body = String(object.body);
                    if (object.responseBody != null)
                        message.responseBody = String(object.responseBody);
                    if (object.additionalBindings) {
                        if (!Array.isArray(object.additionalBindings))
                            throw TypeError(".google.api.HttpRule.additionalBindings: array expected");
                        message.additionalBindings = [];
                        for (var i = 0; i < object.additionalBindings.length; ++i) {
                            if (typeof object.additionalBindings[i] !== "object")
                                throw TypeError(".google.api.HttpRule.additionalBindings: object expected");
                            message.additionalBindings[i] = $root.google.api.HttpRule.fromObject(object.additionalBindings[i]);
                        }
                    }
                    return message;
                };
    
                /**
                 * Creates a plain object from a HttpRule message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.HttpRule} message HttpRule
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                HttpRule.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.additionalBindings = [];
                    if (options.defaults) {
                        object.selector = "";
                        object.body = "";
                        object.responseBody = "";
                    }
                    if (message.selector != null && message.hasOwnProperty("selector"))
                        object.selector = message.selector;
                    if (message.get != null && message.hasOwnProperty("get")) {
                        object.get = message.get;
                        if (options.oneofs)
                            object.pattern = "get";
                    }
                    if (message.put != null && message.hasOwnProperty("put")) {
                        object.put = message.put;
                        if (options.oneofs)
                            object.pattern = "put";
                    }
                    if (message.post != null && message.hasOwnProperty("post")) {
                        object.post = message.post;
                        if (options.oneofs)
                            object.pattern = "post";
                    }
                    if (message["delete"] != null && message.hasOwnProperty("delete")) {
                        object["delete"] = message["delete"];
                        if (options.oneofs)
                            object.pattern = "delete";
                    }
                    if (message.patch != null && message.hasOwnProperty("patch")) {
                        object.patch = message.patch;
                        if (options.oneofs)
                            object.pattern = "patch";
                    }
                    if (message.body != null && message.hasOwnProperty("body"))
                        object.body = message.body;
                    if (message.custom != null && message.hasOwnProperty("custom")) {
                        object.custom = $root.google.api.CustomHttpPattern.toObject(message.custom, options);
                        if (options.oneofs)
                            object.pattern = "custom";
                    }
                    if (message.additionalBindings && message.additionalBindings.length) {
                        object.additionalBindings = [];
                        for (var j = 0; j < message.additionalBindings.length; ++j)
                            object.additionalBindings[j] = $root.google.api.HttpRule.toObject(message.additionalBindings[j], options);
                    }
                    if (message.responseBody != null && message.hasOwnProperty("responseBody"))
                        object.responseBody = message.responseBody;
                    return object;
                };
    
                /**
                 * Converts this HttpRule to JSON.
                 * @function toJSON
                 * @memberof google.api.HttpRule
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                HttpRule.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                /**
                 * Gets the default type url for HttpRule
                 * @function getTypeUrl
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                HttpRule.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/google.api.HttpRule";
                };
    
                return HttpRule;
            })();
    
            api.CustomHttpPattern = (function() {
    
                /**
                 * Properties of a CustomHttpPattern.
                 * @memberof google.api
                 * @interface ICustomHttpPattern
                 * @property {string|null} [kind] CustomHttpPattern kind
                 * @property {string|null} [path] CustomHttpPattern path
                 */
    
                /**
                 * Constructs a new CustomHttpPattern.
                 * @memberof google.api
                 * @classdesc Represents a CustomHttpPattern.
                 * @implements ICustomHttpPattern
                 * @constructor
                 * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
                 */
                function CustomHttpPattern(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CustomHttpPattern kind.
                 * @member {string} kind
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 */
                CustomHttpPattern.prototype.kind = "";
    
                /**
                 * CustomHttpPattern path.
                 * @member {string} path
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 */
                CustomHttpPattern.prototype.path = "";
    
                /**
                 * Creates a new CustomHttpPattern instance using the specified properties.
                 * @function create
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern instance
                 */
                CustomHttpPattern.create = function create(properties) {
                    return new CustomHttpPattern(properties);
                };
    
                /**
                 * Encodes the specified CustomHttpPattern message. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CustomHttpPattern.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.kind);
                    if (message.path != null && Object.hasOwnProperty.call(message, "path"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.path);
                    return writer;
                };
    
                /**
                 * Encodes the specified CustomHttpPattern message, length delimited. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CustomHttpPattern.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a CustomHttpPattern message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CustomHttpPattern.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.CustomHttpPattern();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.kind = reader.string();
                                break;
                            }
                        case 2: {
                                message.path = reader.string();
                                break;
                            }
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Decodes a CustomHttpPattern message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CustomHttpPattern.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };
    
                /**
                 * Verifies a CustomHttpPattern message.
                 * @function verify
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CustomHttpPattern.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        if (!$util.isString(message.kind))
                            return "kind: string expected";
                    if (message.path != null && message.hasOwnProperty("path"))
                        if (!$util.isString(message.path))
                            return "path: string expected";
                    return null;
                };
    
                /**
                 * Creates a CustomHttpPattern message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 */
                CustomHttpPattern.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.CustomHttpPattern)
                        return object;
                    var message = new $root.google.api.CustomHttpPattern();
                    if (object.kind != null)
                        message.kind = String(object.kind);
                    if (object.path != null)
                        message.path = String(object.path);
                    return message;
                };
    
                /**
                 * Creates a plain object from a CustomHttpPattern message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.CustomHttpPattern} message CustomHttpPattern
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                CustomHttpPattern.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.kind = "";
                        object.path = "";
                    }
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        object.kind = message.kind;
                    if (message.path != null && message.hasOwnProperty("path"))
                        object.path = message.path;
                    return object;
                };
    
                /**
                 * Converts this CustomHttpPattern to JSON.
                 * @function toJSON
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                CustomHttpPattern.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };
    
                /**
                 * Gets the default type url for CustomHttpPattern
                 * @function getTypeUrl
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns {string} The default type url
                 */
                CustomHttpPattern.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/google.api.CustomHttpPattern";
                };
    
                return CustomHttpPattern;
            })();
    
            /**
             * FieldBehavior enum.
             * @name google.api.FieldBehavior
             * @enum {number}
             * @property {number} FIELD_BEHAVIOR_UNSPECIFIED=0 FIELD_BEHAVIOR_UNSPECIFIED value
             * @property {number} OPTIONAL=1 OPTIONAL value
             * @property {number} REQUIRED=2 REQUIRED value
             * @property {number} OUTPUT_ONLY=3 OUTPUT_ONLY value
             * @property {number} INPUT_ONLY=4 INPUT_ONLY value
             * @property {number} IMMUTABLE=5 IMMUTABLE value
             * @property {number} UNORDERED_LIST=6 UNORDERED_LIST value
             * @property {number} NON_EMPTY_DEFAULT=7 NON_EMPTY_DEFAULT value
             */
            api.FieldBehavior = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "FIELD_BEHAVIOR_UNSPECIFIED"] = 0;
                values[valuesById[1] = "OPTIONAL"] = 1;
                values[valuesById[2] = "REQUIRED"] = 2;
                values[valuesById[3] = "OUTPUT_ONLY"] = 3;
                values[valuesById[4] = "INPUT_ONLY"] = 4;
                values[valuesById[5] = "IMMUTABLE"] = 5;
                values[valuesById[6] = "UNORDERED_LIST"] = 6;
                values[valuesById[7] = "NON_EMPTY_DEFAULT"] = 7;
                return values;
            })();
    
            api.ResourceDescriptor = (function() {
    
                /**
                 * Properties of a ResourceDescriptor.
                 * @memberof google.api
                 * @interface IResourceDescriptor
                 * @property {string|null} [type] ResourceDescriptor type
                 * @property {Array.<string>|null} [pattern] ResourceDescriptor pattern
                 * @property {string|null} [nameField] ResourceDescriptor nameField
                 * @property {google.api.ResourceDescriptor.History|null} [history] ResourceDescriptor history
                 * @property {string|null} [plural] ResourceDescriptor plural
                 * @property {string|null} [singular] ResourceDescriptor singular
                 * @property {Array.<google.api.ResourceDescriptor.Style>|null} [style] ResourceDescriptor style
                 */
    
                /**
                 * Constructs a new ResourceDescriptor.
                 * @memberof google.api
                 * @classdesc Represents a ResourceDescriptor.
                 * @implements IResourceDescriptor
                 * @constructor
                 * @param {google.api.IResourceDescriptor=} [properties] Properties to set
                 */
                function ResourceDescriptor(properties) {
                    this.pattern = [];
                    this.style = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ResourceDescriptor type.
                 * @member {string} type
                 * @memberof google.api.ResourceDescriptor
                 * @instance
                 */
                ResourceDescriptor.prototype.type = "";
    
                /**
                 * ResourceDescriptor pattern.
                 * @member {Array.<string>} pattern
                 * @memberof google.api.ResourceDescriptor
                 * @instance
                 */
                ResourceDescriptor.prototype.pattern = $util.emptyArray;
    
                /**
                 * ResourceDescriptor nameField.
                 * @member {string} nameField
                 * @memberof google.api.ResourceDescriptor
                 * @instance
                 */
                ResourceDescriptor.prototype.nameField = "";
    
                /**
                 * ResourceDescriptor history.
                 * @member {google.api.ResourceDescriptor.History} history
                 * @memberof google.api.ResourceDescriptor
                 * @instance
                 */
                ResourceDescriptor.prototype.history = 0;
    
                /**
                 * ResourceDescriptor plural.
                 * @member {string} plural
                 * @memberof google.api.ResourceDescriptor
                 * @instance
                 */
                ResourceDescriptor.prototype.plural = "";
    
                /**
                 * ResourceDescriptor singular.
                 * @member {string} singular
                 * @memberof google.api.ResourceDescriptor
                 * @instance
                 */
                ResourceDescriptor.prototype.singular = "";
    
                /**
                 * ResourceDescriptor style.
                 * @member {Array.<google.api.ResourceDescriptor.Style>} style
                 * @memberof google.api.ResourceDescriptor
                 * @instance
                 */
                ResourceDescriptor.prototype.style = $util.emptyArray;
    
                /**
                 * Creates a new ResourceDescriptor instance using the specified properties.
                 * @function create
                 * @memberof google.api.ResourceDescriptor
                 * @static
                 * @param {google.api.IResourceDescriptor=} [properties] Properties to set
                 * @returns {google.api.ResourceDescriptor} ResourceDescriptor instance
                 */
                ResourceDescriptor.create = function create(properties) {
                    return new ResourceDescriptor(properties);
                };
    
                /**
                 * Encodes the specified ResourceDescriptor message. Does not implicitly {@link google.api.ResourceDescriptor.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.ResourceDescriptor
                 * @static
                 * @param {google.api.IResourceDescriptor} message ResourceDescriptor message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ResourceDescriptor.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.type);
                    if (message.pattern != null && message.pattern.length)
                        for (var i = 0; i < message.pattern.length; ++i)
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.pattern[i]);
                    if (message.nameField != null && Object.hasOwnProperty.call(message, "nameField"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.nameField);
                    if (message.history != null && Object.hasOwnProperty.call(message, "history"))
                        writer.uint32(/* id 4, wireType 0 =*/32).int32(message.history);
                    if (message.plural != null && Object.hasOwnProperty.call(message, "plural"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.plural);
                    if (message.singular != null && Object.hasOwnProperty.call(message, "singular"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.singular);
                    if (message.style != null && message.style.length) {
                        writer.uint32(/* id 10, wireType 2 =*/82).fork();
                        for (var i = 0; i < message.style.length; ++i)
                            writer.int32(message.style[i]);
                        writer.ldelim();
                    }
                    return writer;
                };
    
                /**
                 * Encodes the specified ResourceDescriptor message, length delimited. Does not implicitly {@link google.api.ResourceDescriptor.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.ResourceDescriptor
                 * @static
                 * @param {google.api.IResourceDescriptor} message ResourceDescriptor message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ResourceDescriptor.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };
    
                /**
                 * Decodes a ResourceDescriptor message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.ResourceDescriptor
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.ResourceDescriptor} ResourceDescriptor
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ResourceDescriptor.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.ResourceDescriptor();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1: {
                                message.type = reader.string();
                                break;
                            }
                        case 2: {
                                if (!(message.pattern && message.pattern.length))
                                    message.pattern = [];
                                message.pattern.push(reader.string());
                                break;
                            }
                        case 3: {
                                message.nameField = reader.string();
                                break;
                            }
                        case 4: {
                                message.history = reader.int32();
                                break;
                            }
                        case 5: {
                                message.plural = reader.string();
                                break;
                            }
                        case 6: {
                                message.singular = reader.string();
                                break;
                            }
                        case 10: {
                                if (!(message.style && message.style.length))
                                    