// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

/* global window */
import * as gax from 'google-gax';
import {
  Callback,
  CallOptions,
  Descriptors,
  ClientOptions,
  GrpcClientOptions,
  LROperation,
  PaginationCallback,
  GaxCall,
} from 'google-gax';

import {Transform} from 'stream';
import * as protos from '../../protos/protos';
import jsonProtos = require('../../protos/protos.json');
/**
 * Client JSON configuration object, loaded from
 * `src/v1/access_context_manager_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
import * as gapicConfig from './access_context_manager_client_config.json';
import {operationsProtos} from 'google-gax';
const version = require('../../../package.json').version;

/**
 *  API for setting [Access Levels]
 *  [google.identity.accesscontextmanager.v1.AccessLevel] and [Service
 *  Perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
 *  for Google Cloud Projects. Each organization has one [AccessPolicy]
 *  [google.identity.accesscontextmanager.v1.AccessPolicy] containing the
 *  [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
 *  and [Service Perimeters]
 *  [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
 *  [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
 *  applicable to all resources in the organization.
 *  AccessPolicies
 * @class
 * @memberof v1
 */
export class AccessContextManagerClient {
  private _terminated = false;
  private _opts: ClientOptions;
  private _providedCustomServicePath: boolean;
  private _gaxModule: typeof gax | typeof gax.fallback;
  private _gaxGrpc: gax.GrpcClient | gax.fallback.GrpcClient;
  private _protos: {};
  private _defaults: {[method: string]: gax.CallSettings};
  auth: gax.GoogleAuth;
  descriptors: Descriptors = {
    page: {},
    stream: {},
    longrunning: {},
    batching: {},
  };
  warn: (code: string, message: string, warnType?: string) => void;
  innerApiCalls: {[name: string]: Function};
  pathTemplates: {[name: string]: gax.PathTemplate};
  operationsClient: gax.OperationsClient;
  accessContextManagerStub?: Promise<{[name: string]: Function}>;

  /**
   * Construct an instance of AccessContextManagerClient.
   *
   * @param {object} [options] - The configuration object.
   * The options accepted by the constructor are described in detail
   * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
   * The common options are:
   * @param {object} [options.credentials] - Credentials object.
   * @param {string} [options.credentials.client_email]
   * @param {string} [options.credentials.private_key]
   * @param {string} [options.email] - Account email address. Required when
   *     using a .pem or .p12 keyFilename.
   * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
   *     .p12 key downloaded from the Google Developers Console. If you provide
   *     a path to a JSON file, the projectId option below is not necessary.
   *     NOTE: .pem and .p12 require you to specify options.email as well.
   * @param {number} [options.port] - The port on which to connect to
   *     the remote host.
   * @param {string} [options.projectId] - The project ID from the Google
   *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
   *     the environment variable GCLOUD_PROJECT for your project ID. If your
   *     app is running in an environment which supports
   *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
   *     your project ID will be detected automatically.
   * @param {string} [options.apiEndpoint] - The domain name of the
   *     API remote host.
   * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
   *     Follows the structure of {@link gapicConfig}.
   * @param {boolean | "rest"} [options.fallback] - Use HTTP fallback mode.
   *     Pass "rest" to use HTTP/1.1 REST API instead of gRPC.
   *     For more information, please check the
   *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
   */
  constructor(opts?: ClientOptions) {
    // Ensure that options include all the required fields.
    const staticMembers = this.constructor as typeof AccessContextManagerClient;
    const servicePath =
      opts?.servicePath || opts?.apiEndpoint || staticMembers.servicePath;
    this._providedCustomServicePath = !!(
      opts?.servicePath || opts?.apiEndpoint
    );
    const port = opts?.port || staticMembers.port;
    const clientConfig = opts?.clientConfig ?? {};
    const fallback =
      opts?.fallback ??
      (typeof window !== 'undefined' && typeof window?.fetch === 'function');
    opts = Object.assign({servicePath, port, clientConfig, fallback}, opts);

    // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
    if (servicePath !== staticMembers.servicePath && !('scopes' in opts)) {
      opts['scopes'] = staticMembers.scopes;
    }

    // Choose either gRPC or proto-over-HTTP implementation of google-gax.
    this._gaxModule = opts.fallback ? gax.fallback : gax;

    // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
    this._gaxGrpc = new this._gaxModule.GrpcClient(opts);

    // Save options to use in initialize() method.
    this._opts = opts;

    // Save the auth object to the client, for use by other methods.
    this.auth = this._gaxGrpc.auth as gax.GoogleAuth;

    // Set useJWTAccessWithScope on the auth object.
    this.auth.useJWTAccessWithScope = true;

    // Set defaultServicePath on the auth object.
    this.auth.defaultServicePath = staticMembers.servicePath;

    // Set the default scopes in auth client if needed.
    if (servicePath === staticMembers.servicePath) {
      this.auth.defaultScopes = staticMembers.scopes;
    }

    // Determine the client header string.
    const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
    if (typeof process !== 'undefined' && 'versions' in process) {
      clientHeader.push(`gl-node/${process.versions.node}`);
    } else {
      clientHeader.push(`gl-web/${this._gaxModule.version}`);
    }
    if (!opts.fallback) {
      clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
    } else if (opts.fallback === 'rest') {
      clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
    }
    if (opts.libName && opts.libVersion) {
      clientHeader.push(`${opts.libName}/${opts.libVersion}`);
    }
    // Load the applicable protos.
    this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);

    // This API contains "path templates"; forward-slash-separated
    // identifiers to uniquely identify resources within the API.
    // Create useful helper objects for these.
    this.pathTemplates = {
      accessLevelPathTemplate: new this._gaxModule.PathTemplate(
        'accessPolicies/{access_policy}/accessLevels/{access_level}'
      ),
      accessPolicyPathTemplate: new this._gaxModule.PathTemplate(
        'accessPolicies/{access_policy}'
      ),
      gcpUserAccessBindingPathTemplate: new this._gaxModule.PathTemplate(
        'organizations/{organization}/gcpUserAccessBindings/{gcp_user_access_binding}'
      ),
      organizationPathTemplate: new this._gaxModule.PathTemplate(
        'organizations/{organization}'
      ),
      servicePerimeterPathTemplate: new this._gaxModule.PathTemplate(
        'accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}'
      ),
    };

    // Some of the methods on this service return "paged" results,
    // (e.g. 50 results at a time, with tokens to get subsequent
    // pages). Denote the keys used for pagination and results.
    this.descriptors.page = {
      listAccessPolicies: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'accessPolicies'
      ),
      listAccessLevels: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'accessLevels'
      ),
      listServicePerimeters: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'servicePerimeters'
      ),
      listGcpUserAccessBindings: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'gcpUserAccessBindings'
      ),
    };

    const protoFilesRoot = this._gaxModule.protobuf.Root.fromJSON(jsonProtos);
    // This API contains "long-running operations", which return a
    // an Operation object that allows for tracking of the operation,
    // rather than holding a request open.
    const lroOptions: GrpcClientOptions = {
      auth: this.auth,
      grpc: 'grpc' in this._gaxGrpc ? this._gaxGrpc.grpc : undefined,
    };
    if (opts.fallback === 'rest') {
      lroOptions.protoJson = protoFilesRoot;
      lroOptions.httpRules = [
        {
          selector: 'google.longrunning.Operations.GetOperation',
          get: '/v1/{name=operations/**}',
        },
      ];
    }
    this.operationsClient = this._gaxModule
      .lro(lroOptions)
      .operationsClient(opts);
    const createAccessPolicyResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessPolicy'
    ) as gax.protobuf.Type;
    const createAccessPolicyMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const updateAccessPolicyResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessPolicy'
    ) as gax.protobuf.Type;
    const updateAccessPolicyMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const deleteAccessPolicyResponse = protoFilesRoot.lookup(
      '.google.protobuf.Empty'
    ) as gax.protobuf.Type;
    const deleteAccessPolicyMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const createAccessLevelResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessLevel'
    ) as gax.protobuf.Type;
    const createAccessLevelMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const updateAccessLevelResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessLevel'
    ) as gax.protobuf.Type;
    const updateAccessLevelMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const deleteAccessLevelResponse = protoFilesRoot.lookup(
      '.google.protobuf.Empty'
    ) as gax.protobuf.Type;
    const deleteAccessLevelMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const replaceAccessLevelsResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse'
    ) as gax.protobuf.Type;
    const replaceAccessLevelsMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const createServicePerimeterResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.ServicePerimeter'
    ) as gax.protobuf.Type;
    const createServicePerimeterMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const updateServicePerimeterResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.ServicePerimeter'
    ) as gax.protobuf.Type;
    const updateServicePerimeterMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const deleteServicePerimeterResponse = protoFilesRoot.lookup(
      '.google.protobuf.Empty'
    ) as gax.protobuf.Type;
    const deleteServicePerimeterMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const replaceServicePerimetersResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse'
    ) as gax.protobuf.Type;
    const replaceServicePerimetersMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const commitServicePerimetersResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse'
    ) as gax.protobuf.Type;
    const commitServicePerimetersMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata'
    ) as gax.protobuf.Type;
    const createGcpUserAccessBindingResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.GcpUserAccessBinding'
    ) as gax.protobuf.Type;
    const createGcpUserAccessBindingMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata'
    ) as gax.protobuf.Type;
    const updateGcpUserAccessBindingResponse = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.GcpUserAccessBinding'
    ) as gax.protobuf.Type;
    const updateGcpUserAccessBindingMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata'
    ) as gax.protobuf.Type;
    const deleteGcpUserAccessBindingResponse = protoFilesRoot.lookup(
      '.google.protobuf.Empty'
    ) as gax.protobuf.Type;
    const deleteGcpUserAccessBindingMetadata = protoFilesRoot.lookup(
      '.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata'
    ) as gax.protobuf.Type;

    this.descriptors.longrunning = {
      createAccessPolicy: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createAccessPolicyResponse.decode.bind(createAccessPolicyResponse),
        createAccessPolicyMetadata.decode.bind(createAccessPolicyMetadata)
      ),
      updateAccessPolicy: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        updateAccessPolicyResponse.decode.bind(updateAccessPolicyResponse),
        updateAccessPolicyMetadata.decode.bind(updateAccessPolicyMetadata)
      ),
      deleteAccessPolicy: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        deleteAccessPolicyResponse.decode.bind(deleteAccessPolicyResponse),
        deleteAccessPolicyMetadata.decode.bind(deleteAccessPolicyMetadata)
      ),
      createAccessLevel: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createAccessLevelResponse.decode.bind(createAccessLevelResponse),
        createAccessLevelMetadata.decode.bind(createAccessLevelMetadata)
      ),
      updateAccessLevel: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        updateAccessLevelResponse.decode.bind(updateAccessLevelResponse),
        updateAccessLevelMetadata.decode.bind(updateAccessLevelMetadata)
      ),
      deleteAccessLevel: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        deleteAccessLevelResponse.decode.bind(deleteAccessLevelResponse),
        deleteAccessLevelMetadata.decode.bind(deleteAccessLevelMetadata)
      ),
      replaceAccessLevels: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        replaceAccessLevelsResponse.decode.bind(replaceAccessLevelsResponse),
        replaceAccessLevelsMetadata.decode.bind(replaceAccessLevelsMetadata)
      ),
      createServicePerimeter: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createServicePerimeterResponse.decode.bind(
          createServicePerimeterResponse
        ),
        createServicePerimeterMetadata.decode.bind(
          createServicePerimeterMetadata
        )
      ),
      updateServicePerimeter: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        updateServicePerimeterResponse.decode.bind(
          updateServicePerimeterResponse
        ),
        updateServicePerimeterMetadata.decode.bind(
          updateServicePerimeterMetadata
        )
      ),
      deleteServicePerimeter: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        deleteServicePerimeterResponse.decode.bind(
          deleteServicePerimeterResponse
        ),
        deleteServicePerimeterMetadata.decode.bind(
          deleteServicePerimeterMetadata
        )
      ),
      replaceServicePerimeters: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        replaceServicePerimetersResponse.decode.bind(
          replaceServicePerimetersResponse
        ),
        replaceServicePerimetersMetadata.decode.bind(
          replaceServicePerimetersMetadata
        )
      ),
      commitServicePerimeters: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        commitServicePerimetersResponse.decode.bind(
          commitServicePerimetersResponse
        ),
        commitServicePerimetersMetadata.decode.bind(
          commitServicePerimetersMetadata
        )
      ),
      createGcpUserAccessBinding: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createGcpUserAccessBindingResponse.decode.bind(
          createGcpUserAccessBindingResponse
        ),
        createGcpUserAccessBindingMetadata.decode.bind(
          createGcpUserAccessBindingMetadata
        )
      ),
      updateGcpUserAccessBinding: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        updateGcpUserAccessBindingResponse.decode.bind(
          updateGcpUserAccessBindingResponse
        ),
        updateGcpUserAccessBindingMetadata.decode.bind(
          updateGcpUserAccessBindingMetadata
        )
      ),
      deleteGcpUserAccessBinding: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        deleteGcpUserAccessBindingResponse.decode.bind(
          deleteGcpUserAccessBindingResponse
        ),
        deleteGcpUserAccessBindingMetadata.decode.bind(
          deleteGcpUserAccessBindingMetadata
        )
      ),
    };

    // Put together the default options sent with requests.
    this._defaults = this._gaxGrpc.constructSettings(
      'google.identity.accesscontextmanager.v1.AccessContextManager',
      gapicConfig as gax.ClientConfig,
      opts.clientConfig || {},
      {'x-goog-api-client': clientHeader.join(' ')}
    );

    // Set up a dictionary of "inner API calls"; the core implementation
    // of calling the API is handled in `google-gax`, with this code
    // merely providing the destination and request information.
    this.innerApiCalls = {};

    // Add a warn function to the client constructor so it can be easily tested.
    this.warn = gax.warn;
  }

  /**
   * Initialize the client.
   * Performs asynchronous operations (such as authentication) and prepares the client.
   * This function will be called automatically when any class method is called for the
   * first time, but if you need to initialize it before calling an actual method,
   * feel free to call initialize() directly.
   *
   * You can await on this method if you want to make sure the client is initialized.
   *
   * @returns {Promise} A promise that resolves to an authenticated service stub.
   */
  initialize() {
    // If the client stub promise is already initialized, return immediately.
    if (this.accessContextManagerStub) {
      return this.accessContextManagerStub;
    }

    // Put together the "service stub" for
    // google.identity.accesscontextmanager.v1.AccessContextManager.
    this.accessContextManagerStub = this._gaxGrpc.createStub(
      this._opts.fallback
        ? (this._protos as protobuf.Root).lookupService(
            'google.identity.accesscontextmanager.v1.AccessContextManager'
          )
        : // eslint-disable-next-line @typescript-eslint/no-explicit-any
          (this._protos as any).google.identity.accesscontextmanager.v1
            .AccessContextManager,
      this._opts,
      this._providedCustomServicePath
    ) as Promise<{[method: string]: Function}>;

    // Iterate over each of the methods that the service provides
    // and create an API call method for each.
    const accessContextManagerStubMethods = [
      'listAccessPolicies',
      'getAccessPolicy',
      'createAccessPolicy',
      'updateAccessPolicy',
      'deleteAccessPolicy',
      'listAccessLevels',
      'getAccessLevel',
      'createAccessLevel',
      'updateAccessLevel',
      'deleteAccessLevel',
      'replaceAccessLevels',
      'listServicePerimeters',
      'getServicePerimeter',
      'createServicePerimeter',
      'updateServicePerimeter',
      'deleteServicePerimeter',
      'replaceServicePerimeters',
      'commitServicePerimeters',
      'listGcpUserAccessBindings',
      'getGcpUserAccessBinding',
      'createGcpUserAccessBinding',
      'updateGcpUserAccessBinding',
      'deleteGcpUserAccessBinding',
    ];
    for (const methodName of accessContextManagerStubMethods) {
      const callPromise = this.accessContextManagerStub.then(
        stub =>
          (...args: Array<{}>) => {
            if (this._terminated) {
              return Promise.reject('The client has already been closed.');
            }
            const func = stub[methodName];
            return func.apply(stub, args);
          },
        (err: Error | null | undefined) => () => {
          throw err;
        }
      );

      const descriptor =
        this.descriptors.page[methodName] ||
        this.descriptors.longrunning[methodName] ||
        undefined;
      const apiCall = this._gaxModule.createApiCall(
        callPromise,
        this._defaults[methodName],
        descriptor,
        this._opts.fallback
      );

      this.innerApiCalls[methodName] = apiCall;
    }

    return this.accessContextManagerStub;
  }

  /**
   * The DNS address for this API service.
   * @returns {string} The DNS address for this service.
   */
  static get servicePath() {
    return 'accesscontextmanager.googleapis.com';
  }

  /**
   * The DNS address for this API service - same as servicePath(),
   * exists for compatibility reasons.
   * @returns {string} The DNS address for this service.
   */
  static get apiEndpoint() {
    return 'accesscontextmanager.googleapis.com';
  }

  /**
   * The port for this API service.
   * @returns {number} The default port for this service.
   */
  static get port() {
    return 443;
  }

  /**
   * The scopes needed to make gRPC calls for every method defined
   * in this service.
   * @returns {string[]} List of default scopes.
   */
  static get scopes() {
    return ['https://www.googleapis.com/auth/cloud-platform'];
  }

  getProjectId(): Promise<string>;
  getProjectId(callback: Callback<string, undefined, undefined>): void;
  /**
   * Return the project ID used by this class.
   * @returns {Promise} A promise that resolves to string containing the project ID.
   */
  getProjectId(
    callback?: Callback<string, undefined, undefined>
  ): Promise<string> | void {
    if (callback) {
      this.auth.getProjectId(callback);
      return;
    }
    return this.auth.getProjectId();
  }

  // -------------------
  // -- Service calls --
  // -------------------
  /**
   * Get an [AccessPolicy]
   * [google.identity.accesscontextmanager.v1.AccessPolicy] by name.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Resource name for the access policy to get.
   *
   *   Format `accessPolicies/{policy_id}`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [AccessPolicy]{@link google.identity.accesscontextmanager.v1.AccessPolicy}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.get_access_policy.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_GetAccessPolicy_async
   */
  getAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest
        | undefined
      ),
      {} | undefined
    ]
  >;
  getAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
      | protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
      | protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
          | protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
      | protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetAccessPolicyRequest
        | undefined
      ),
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.getAccessPolicy(request, options, callback);
  }
  /**
   * Get an [Access Level]
   * [google.identity.accesscontextmanager.v1.AccessLevel] by resource
   * name.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Resource name for the [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel].
   *
   *   Format:
   *   `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
   * @param {google.identity.accesscontextmanager.v1.LevelFormat} request.accessLevelFormat
   *   Whether to return `BasicLevels` in the Cloud Common Expression
   *   Language rather than as `BasicLevels`. Defaults to AS_DEFINED, where
   *   [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
   *   are returned as `BasicLevels` or `CustomLevels` based on how they were
   *   created. If set to CEL, all [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] are returned as
   *   `CustomLevels`. In the CEL case, `BasicLevels` are translated to equivalent
   *   `CustomLevels`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [AccessLevel]{@link google.identity.accesscontextmanager.v1.AccessLevel}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.get_access_level.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_GetAccessLevel_async
   */
  getAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessLevel,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest
        | undefined
      ),
      {} | undefined
    ]
  >;
  getAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IAccessLevel,
      | protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IAccessLevel,
      | protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.identity.accesscontextmanager.v1.IAccessLevel,
          | protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.identity.accesscontextmanager.v1.IAccessLevel,
      | protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessLevel,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetAccessLevelRequest
        | undefined
      ),
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.getAccessLevel(request, options, callback);
  }
  /**
   * Get a [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
   * name.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Resource name for the [Service Perimeter]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter].
   *
   *   Format:
   *   `accessPolicies/{policy_id}/servicePerimeters/{service_perimeters_id}`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [ServicePerimeter]{@link google.identity.accesscontextmanager.v1.ServicePerimeter}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.get_service_perimeter.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_GetServicePerimeter_async
   */
  getServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest
        | undefined
      ),
      {} | undefined
    ]
  >;
  getServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
      | protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
      | protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
          | protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
      | protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetServicePerimeterRequest
        | undefined
      ),
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.getServicePerimeter(request, options, callback);
  }
  /**
   * Gets the [GcpUserAccessBinding]
   * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
   * the given name.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [GcpUserAccessBinding]{@link google.identity.accesscontextmanager.v1.GcpUserAccessBinding}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.get_gcp_user_access_binding.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_GetGcpUserAccessBinding_async
   */
  getGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest
        | undefined
      ),
      {} | undefined
    ]
  >;
  getGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
      | protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest,
    callback: Callback<
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
      | protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  getGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
          | protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
      | protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
      (
        | protos.google.identity.accesscontextmanager.v1.IGetGcpUserAccessBindingRequest
        | undefined
      ),
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.getGcpUserAccessBinding(
      request,
      options,
      callback
    );
  }

  /**
   * Create an `AccessPolicy`. Fails if this organization already has a
   * `AccessPolicy`. The longrunning Operation will have a successful status
   * once the `AccessPolicy` has propagated to long-lasting storage.
   * Syntactic and basic semantic errors will be returned in `metadata` as a
   * BadRequest proto.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Output only. Resource name of the `AccessPolicy`. Format:
   *   `accessPolicies/{access_policy}`
   * @param {string} request.parent
   *   Required. The parent of this `AccessPolicy` in the Cloud Resource
   *   Hierarchy. Currently immutable once created. Format:
   *   `organizations/{organization_id}`
   * @param {string} request.title
   *   Required. Human readable title. Does not affect behavior.
   * @param {google.protobuf.Timestamp} request.createTime
   *   Output only. Time the `AccessPolicy` was created in UTC.
   * @param {google.protobuf.Timestamp} request.updateTime
   *   Output only. Time the `AccessPolicy` was updated in UTC.
   * @param {string} request.etag
   *   Output only. An opaque identifier for the current version of the
   *   `AccessPolicy`. This will always be a strongly validated etag, meaning that
   *   two Access Polices will be identical if and only if their etags are
   *   identical. Clients should not expect this to be in any specific format.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_access_policy.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateAccessPolicy_async
   */
  createAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  createAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    this.initialize();
    return this.innerApiCalls.createAccessPolicy(request, options, callback);
  }
  /**
   * Check the status of the long running operation returned by `createAccessPolicy()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_access_policy.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateAccessPolicy_async
   */
  async checkCreateAccessPolicyProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessPolicy,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.createAccessPolicy,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessPolicy,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Update an [AccessPolicy]
   * [google.identity.accesscontextmanager.v1.AccessPolicy]. The
   * longrunning Operation from this RPC will have a successful status once the
   * changes to the [AccessPolicy]
   * [google.identity.accesscontextmanager.v1.AccessPolicy] have propagated
   * to long-lasting storage. Syntactic and basic semantic errors will be
   * returned in `metadata` as a BadRequest proto.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.identity.accesscontextmanager.v1.AccessPolicy} request.policy
   *   Required. The updated AccessPolicy.
   * @param {google.protobuf.FieldMask} request.updateMask
   *   Required. Mask to control which fields get updated. Must be non-empty.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_access_policy.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateAccessPolicy_async
   */
  updateAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  updateAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateAccessPolicyRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        'policy.name': request.policy!.name || '',
      });
    this.initialize();
    return this.innerApiCalls.updateAccessPolicy(request, options, callback);
  }
  /**
   * Check the status of the long running operation returned by `updateAccessPolicy()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_access_policy.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateAccessPolicy_async
   */
  async checkUpdateAccessPolicyProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessPolicy,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.updateAccessPolicy,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessPolicy,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Delete an [AccessPolicy]
   * [google.identity.accesscontextmanager.v1.AccessPolicy] by resource
   * name. The longrunning Operation will have a successful status once the
   * [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy]
   * has been removed from long-lasting storage.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Resource name for the access policy to delete.
   *
   *   Format `accessPolicies/{policy_id}`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_access_policy.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteAccessPolicy_async
   */
  deleteAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  deleteAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteAccessPolicy(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteAccessPolicy(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteAccessPolicyRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.protobuf.IEmpty,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.deleteAccessPolicy(request, options, callback);
  }
  /**
   * Check the status of the long running operation returned by `deleteAccessPolicy()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_access_policy.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteAccessPolicy_async
   */
  async checkDeleteAccessPolicyProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.deleteAccessPolicy,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Create an [Access Level]
   * [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
   * operation from this RPC will have a successful status once the [Access
   * Level] [google.identity.accesscontextmanager.v1.AccessLevel] has
   * propagated to long-lasting storage. [Access Levels]
   * [google.identity.accesscontextmanager.v1.AccessLevel] containing
   * errors will result in an error response for the first error encountered.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy which owns this [Access
   *   Level] [google.identity.accesscontextmanager.v1.AccessLevel].
   *
   *   Format: `accessPolicies/{policy_id}`
   * @param {google.identity.accesscontextmanager.v1.AccessLevel} request.accessLevel
   *   Required. The [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] to create.
   *   Syntactic correctness of the [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] is a
   *   precondition for creation.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_access_level.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateAccessLevel_async
   */
  createAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  createAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.ICreateAccessLevelRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IAccessLevel,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.createAccessLevel(request, options, callback);
  }
  /**
   * Check the status of the long running operation returned by `createAccessLevel()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_access_level.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateAccessLevel_async
   */
  async checkCreateAccessLevelProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessLevel,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.createAccessLevel,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessLevel,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Update an [Access Level]
   * [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
   * operation from this RPC will have a successful status once the changes to
   * the [Access Level]
   * [google.identity.accesscontextmanager.v1.AccessLevel] have propagated
   * to long-lasting storage. [Access Levels]
   * [google.identity.accesscontextmanager.v1.AccessLevel] containing
   * errors will result in an error response for the first error encountered.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.identity.accesscontextmanager.v1.AccessLevel} request.accessLevel
   *   Required. The updated [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel]. Syntactic
   *   correctness of the [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] is a
   *   precondition for creation.
   * @param {google.protobuf.FieldMask} request.updateMask
   *   Required. Mask to control which fields get updated. Must be non-empty.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_access_level.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateAccessLevel_async
   */
  updateAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  updateAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateAccessLevelRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IAccessLevel,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        'access_level.name': request.accessLevel!.name || '',
      });
    this.initialize();
    return this.innerApiCalls.updateAccessLevel(request, options, callback);
  }
  /**
   * Check the status of the long running operation returned by `updateAccessLevel()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_access_level.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateAccessLevel_async
   */
  async checkUpdateAccessLevelProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessLevel,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.updateAccessLevel,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.AccessLevel,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Delete an [Access Level]
   * [google.identity.accesscontextmanager.v1.AccessLevel] by resource
   * name. The longrunning operation from this RPC will have a successful status
   * once the [Access Level]
   * [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
   * from long-lasting storage.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Resource name for the [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel].
   *
   *   Format:
   *   `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_access_level.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteAccessLevel_async
   */
  deleteAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  deleteAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteAccessLevel(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteAccessLevel(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteAccessLevelRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.protobuf.IEmpty,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.deleteAccessLevel(request, options, callback);
  }
  /**
   * Check the status of the long running operation returned by `deleteAccessLevel()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_access_level.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteAccessLevel_async
   */
  async checkDeleteAccessLevelProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.deleteAccessLevel,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Replace all existing [Access Levels]
   * [google.identity.accesscontextmanager.v1.AccessLevel] in an [Access
   * Policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
   * the [Access Levels]
   * [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
   * is done atomically. The longrunning operation from this RPC will have a
   * successful status once all replacements have propagated to long-lasting
   * storage. Replacements containing errors will result in an error response
   * for the first error encountered.  Replacement will be cancelled on error,
   * existing [Access Levels]
   * [google.identity.accesscontextmanager.v1.AccessLevel] will not be
   * affected. Operation.response field will contain
   * ReplaceAccessLevelsResponse. Removing [Access Levels]
   * [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
   * [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] will result in
   * error.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy which owns these
   *   [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel].
   *
   *   Format: `accessPolicies/{policy_id}`
   * @param {number[]} request.accessLevels
   *   Required. The desired [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] that should
   *   replace all existing [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] in the
   *   [Access Policy]
   *   [google.identity.accesscontextmanager.v1.AccessPolicy].
   * @param {string} request.etag
   *   Optional. The etag for the version of the [Access Policy]
   *   [google.identity.accesscontextmanager.v1.AccessPolicy] that this
   *   replace operation is to be performed on. If, at the time of replace, the
   *   etag for the Access Policy stored in Access Context Manager is different
   *   from the specified etag, then the replace operation will not be performed
   *   and the call will fail. This field is not required. If etag is not
   *   provided, the operation will be performed as if a valid etag is provided.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.replace_access_levels.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ReplaceAccessLevels_async
   */
  replaceAccessLevels(
    request?: protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  replaceAccessLevels(
    request: protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  replaceAccessLevels(
    request: protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  replaceAccessLevels(
    request?: protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.replaceAccessLevels(request, options, callback);
  }
  /**
   * Check the status of the long running operation returned by `replaceAccessLevels()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.replace_access_levels.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ReplaceAccessLevels_async
   */
  async checkReplaceAccessLevelsProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.replaceAccessLevels,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Create a [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
   * longrunning operation from this RPC will have a successful status once the
   * [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] has
   * propagated to long-lasting storage. [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
   * errors will result in an error response for the first error encountered.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy which owns this [Service
   *   Perimeter] [google.identity.accesscontextmanager.v1.ServicePerimeter].
   *
   *   Format: `accessPolicies/{policy_id}`
   * @param {google.identity.accesscontextmanager.v1.ServicePerimeter} request.servicePerimeter
   *   Required. The [Service Perimeter]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] to create.
   *   Syntactic correctness of the [Service Perimeter]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] is a
   *   precondition for creation.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_service_perimeter.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateServicePerimeter_async
   */
  createServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  createServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.ICreateServicePerimeterRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.createServicePerimeter(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `createServicePerimeter()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_service_perimeter.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateServicePerimeter_async
   */
  async checkCreateServicePerimeterProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.ServicePerimeter,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.createServicePerimeter,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.ServicePerimeter,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Update a [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
   * longrunning operation from this RPC will have a successful status once the
   * changes to the [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] have
   * propagated to long-lasting storage. [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
   * errors will result in an error response for the first error encountered.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.identity.accesscontextmanager.v1.ServicePerimeter} request.servicePerimeter
   *   Required. The updated `ServicePerimeter`. Syntactic correctness of the
   *   `ServicePerimeter` is a precondition for creation.
   * @param {google.protobuf.FieldMask} request.updateMask
   *   Required. Mask to control which fields get updated. Must be non-empty.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_service_perimeter.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateServicePerimeter_async
   */
  updateServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  updateServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateServicePerimeterRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        'service_perimeter.name': request.servicePerimeter!.name || '',
      });
    this.initialize();
    return this.innerApiCalls.updateServicePerimeter(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `updateServicePerimeter()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_service_perimeter.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateServicePerimeter_async
   */
  async checkUpdateServicePerimeterProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.ServicePerimeter,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.updateServicePerimeter,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.ServicePerimeter,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Delete a [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
   * name. The longrunning operation from this RPC will have a successful status
   * once the [Service Perimeter]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] has been
   * removed from long-lasting storage.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Resource name for the [Service Perimeter]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter].
   *
   *   Format:
   *   `accessPolicies/{policy_id}/servicePerimeters/{service_perimeter_id}`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_service_perimeter.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteServicePerimeter_async
   */
  deleteServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  deleteServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteServicePerimeter(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteServicePerimeter(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteServicePerimeterRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.protobuf.IEmpty,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.deleteServicePerimeter(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `deleteServicePerimeter()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_service_perimeter.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteServicePerimeter_async
   */
  async checkDeleteServicePerimeterProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.deleteServicePerimeter,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Replace all existing [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
   * [Access Policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
   * with the [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] provided.
   * This is done atomically. The longrunning operation from this
   * RPC will have a successful status once all replacements have propagated to
   * long-lasting storage. Replacements containing errors will result in an
   * error response for the first error encountered. Replacement will be
   * cancelled on error, existing [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] will not be
   * affected. Operation.response field will contain
   * ReplaceServicePerimetersResponse.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy which owns these
   *   [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter].
   *
   *   Format: `accessPolicies/{policy_id}`
   * @param {number[]} request.servicePerimeters
   *   Required. The desired [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] that should
   *   replace all existing [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] in the
   *   [Access Policy]
   *   [google.identity.accesscontextmanager.v1.AccessPolicy].
   * @param {string} request.etag
   *   Optional. The etag for the version of the [Access Policy]
   *   [google.identity.accesscontextmanager.v1.AccessPolicy] that this
   *   replace operation is to be performed on. If, at the time of replace, the
   *   etag for the Access Policy stored in Access Context Manager is different
   *   from the specified etag, then the replace operation will not be performed
   *   and the call will fail. This field is not required. If etag is not
   *   provided, the operation will be performed as if a valid etag is provided.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.replace_service_perimeters.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ReplaceServicePerimeters_async
   */
  replaceServicePerimeters(
    request?: protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  replaceServicePerimeters(
    request: protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  replaceServicePerimeters(
    request: protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  replaceServicePerimeters(
    request?: protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.replaceServicePerimeters(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `replaceServicePerimeters()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.replace_service_perimeters.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ReplaceServicePerimeters_async
   */
  async checkReplaceServicePerimetersProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.replaceServicePerimeters,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Commit the dry-run spec for all the [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
   * {@link google.identity.accesscontextmanager.v1.AccessPolicy|Access Policy}.
   * A commit operation on a Service Perimeter involves copying its `spec` field
   * to that Service Perimeter's `status` field. Only [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] with
   * `use_explicit_dry_run_spec` field set to true are affected by a commit
   * operation. The longrunning operation from this RPC will have a successful
   * status once the dry-run specs for all the [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
   * committed. If a commit fails, it will cause the longrunning operation to
   * return an error response and the entire commit operation will be cancelled.
   * When successful, Operation.response field will contain
   * CommitServicePerimetersResponse. The `dry_run` and the `spec` fields will
   * be cleared after a successful commit operation.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the parent [Access Policy]
   *   [google.identity.accesscontextmanager.v1.AccessPolicy] which owns all
   *   [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] in scope for
   *   the commit operation.
   *
   *   Format: `accessPolicies/{policy_id}`
   * @param {string} request.etag
   *   Optional. The etag for the version of the [Access Policy]
   *   [google.identity.accesscontextmanager.v1alpha.AccessPolicy] that this
   *   commit operation is to be performed on. If, at the time of commit, the
   *   etag for the Access Policy stored in Access Context Manager is different
   *   from the specified etag, then the commit operation will not be performed
   *   and the call will fail. This field is not required. If etag is not
   *   provided, the operation will be performed as if a valid etag is provided.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.commit_service_perimeters.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CommitServicePerimeters_async
   */
  commitServicePerimeters(
    request?: protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  commitServicePerimeters(
    request: protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  commitServicePerimeters(
    request: protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  commitServicePerimeters(
    request?: protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
            protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.commitServicePerimeters(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `commitServicePerimeters()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.commit_service_perimeters.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CommitServicePerimeters_async
   */
  async checkCommitServicePerimetersProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.commitServicePerimeters,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse,
      protos.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata
    >;
  }
  /**
   * Creates a [GcpUserAccessBinding]
   * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
   * client specifies a [name]
   * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
   * the server will ignore it. Fails if a resource already exists with the same
   * [group_key]
   * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
   * Completion of this long-running operation does not necessarily signify that
   * the new binding is deployed onto all affected users, which may take more
   * time.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Example: "organizations/256"
   * @param {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} request.gcpUserAccessBinding
   *   Required. [GcpUserAccessBinding]
   *   [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_gcp_user_access_binding.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateGcpUserAccessBinding_async
   */
  createGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  createGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  createGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.ICreateGcpUserAccessBindingRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
            protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.createGcpUserAccessBinding(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `createGcpUserAccessBinding()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.create_gcp_user_access_binding.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_CreateGcpUserAccessBinding_async
   */
  async checkCreateGcpUserAccessBindingProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding,
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.createGcpUserAccessBinding,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding,
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
    >;
  }
  /**
   * Updates a [GcpUserAccessBinding]
   * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
   * Completion of this long-running operation does not necessarily signify that
   * the changed binding is deployed onto all affected users, which may take
   * more time.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.identity.accesscontextmanager.v1.GcpUserAccessBinding} request.gcpUserAccessBinding
   *   Required. [GcpUserAccessBinding]
   *   [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
   * @param {google.protobuf.FieldMask} request.updateMask
   *   Required. Only the fields specified in this mask are updated. Because name and
   *   group_key cannot be changed, update_mask is required and must always be:
   *
   *   update_mask {
   *   paths: "access_levels"
   *   }
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_gcp_user_access_binding.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateGcpUserAccessBinding_async
   */
  updateGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  updateGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest,
    callback: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  updateGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.IUpdateGcpUserAccessBindingRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
            protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        'gcp_user_access_binding.name':
          request.gcpUserAccessBinding!.name || '',
      });
    this.initialize();
    return this.innerApiCalls.updateGcpUserAccessBinding(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `updateGcpUserAccessBinding()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.update_gcp_user_access_binding.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_UpdateGcpUserAccessBinding_async
   */
  async checkUpdateGcpUserAccessBindingProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding,
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.updateGcpUserAccessBinding,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding,
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
    >;
  }
  /**
   * Deletes a [GcpUserAccessBinding]
   * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
   * Completion of this long-running operation does not necessarily signify that
   * the binding deletion is deployed onto all affected users, which may take
   * more time.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_gcp_user_access_binding.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteGcpUserAccessBinding_async
   */
  deleteGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest,
    options?: CallOptions
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  >;
  deleteGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteGcpUserAccessBinding(
    request: protos.google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest,
    callback: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): void;
  deleteGcpUserAccessBinding(
    request?: protos.google.identity.accesscontextmanager.v1.IDeleteGcpUserAccessBindingRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.protobuf.IEmpty,
            protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.deleteGcpUserAccessBinding(
      request,
      options,
      callback
    );
  }
  /**
   * Check the status of the long running operation returned by `deleteGcpUserAccessBinding()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.delete_gcp_user_access_binding.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_DeleteGcpUserAccessBinding_async
   */
  async checkDeleteGcpUserAccessBindingProgress(
    name: string
  ): Promise<
    LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
    >
  > {
    const request = new operationsProtos.google.longrunning.GetOperationRequest(
      {name}
    );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new gax.Operation(
      operation,
      this.descriptors.longrunning.deleteGcpUserAccessBinding,
      this._gaxModule.createDefaultBackoffSettings()
    );
    return decodeOperation as LROperation<
      protos.google.protobuf.Empty,
      protos.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata
    >;
  }
  /**
   * List all [AccessPolicies]
   * [google.identity.accesscontextmanager.v1.AccessPolicy] under a
   * container.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the container to list AccessPolicy instances
   *   from.
   *
   *   Format:
   *   `organizations/{org_id}`
   * @param {number} request.pageSize
   *   Number of AccessPolicy instances to include in the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of AccessPolicy instances. Defaults to
   *   the first page of results.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of [AccessPolicy]{@link google.identity.accesscontextmanager.v1.AccessPolicy}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listAccessPoliciesAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listAccessPolicies(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy[],
      protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse
    ]
  >;
  listAccessPolicies(
    request: protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
      | protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy
    >
  ): void;
  listAccessPolicies(
    request: protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
      | protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy
    >
  ): void;
  listAccessPolicies(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
          | protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse
          | null
          | undefined,
          protos.google.identity.accesscontextmanager.v1.IAccessPolicy
        >,
    callback?: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
      | protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessPolicy[],
      protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesResponse
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    this.initialize();
    return this.innerApiCalls.listAccessPolicies(request, options, callback);
  }

  /**
   * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the container to list AccessPolicy instances
   *   from.
   *
   *   Format:
   *   `organizations/{org_id}`
   * @param {number} request.pageSize
   *   Number of AccessPolicy instances to include in the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of AccessPolicy instances. Defaults to
   *   the first page of results.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing [AccessPolicy]{@link google.identity.accesscontextmanager.v1.AccessPolicy} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listAccessPoliciesAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listAccessPoliciesStream(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
    options?: CallOptions
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    const defaultCallSettings = this._defaults['listAccessPolicies'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listAccessPolicies.createStream(
      this.innerApiCalls.listAccessPolicies as GaxCall,
      request,
      callSettings
    );
  }

  /**
   * Equivalent to `listAccessPolicies`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the container to list AccessPolicy instances
   *   from.
   *
   *   Format:
   *   `organizations/{org_id}`
   * @param {number} request.pageSize
   *   Number of AccessPolicy instances to include in the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of AccessPolicy instances. Defaults to
   *   the first page of results.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
   *   When you iterate the returned iterable, each element will be an object representing
   *   [AccessPolicy]{@link google.identity.accesscontextmanager.v1.AccessPolicy}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.list_access_policies.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ListAccessPolicies_async
   */
  listAccessPoliciesAsync(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessPoliciesRequest,
    options?: CallOptions
  ): AsyncIterable<protos.google.identity.accesscontextmanager.v1.IAccessPolicy> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    const defaultCallSettings = this._defaults['listAccessPolicies'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listAccessPolicies.asyncIterate(
      this.innerApiCalls['listAccessPolicies'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.identity.accesscontextmanager.v1.IAccessPolicy>;
  }
  /**
   * List all [Access Levels]
   * [google.identity.accesscontextmanager.v1.AccessLevel] for an access
   * policy.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy to list [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] from.
   *
   *   Format:
   *   `accessPolicies/{policy_id}`
   * @param {number} request.pageSize
   *   Number of [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] to include in
   *   the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] instances.
   *   Defaults to the first page of results.
   * @param {google.identity.accesscontextmanager.v1.LevelFormat} request.accessLevelFormat
   *   Whether to return `BasicLevels` in the Cloud Common Expression language, as
   *   `CustomLevels`, rather than as `BasicLevels`. Defaults to returning
   *   `AccessLevels` in the format they were defined.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of [AccessLevel]{@link google.identity.accesscontextmanager.v1.AccessLevel}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listAccessLevelsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listAccessLevels(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessLevel[],
      protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListAccessLevelsResponse
    ]
  >;
  listAccessLevels(
    request: protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
      | protos.google.identity.accesscontextmanager.v1.IListAccessLevelsResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IAccessLevel
    >
  ): void;
  listAccessLevels(
    request: protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
      | protos.google.identity.accesscontextmanager.v1.IListAccessLevelsResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IAccessLevel
    >
  ): void;
  listAccessLevels(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
          | protos.google.identity.accesscontextmanager.v1.IListAccessLevelsResponse
          | null
          | undefined,
          protos.google.identity.accesscontextmanager.v1.IAccessLevel
        >,
    callback?: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
      | protos.google.identity.accesscontextmanager.v1.IListAccessLevelsResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IAccessLevel
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IAccessLevel[],
      protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListAccessLevelsResponse
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.listAccessLevels(request, options, callback);
  }

  /**
   * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy to list [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] from.
   *
   *   Format:
   *   `accessPolicies/{policy_id}`
   * @param {number} request.pageSize
   *   Number of [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] to include in
   *   the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] instances.
   *   Defaults to the first page of results.
   * @param {google.identity.accesscontextmanager.v1.LevelFormat} request.accessLevelFormat
   *   Whether to return `BasicLevels` in the Cloud Common Expression language, as
   *   `CustomLevels`, rather than as `BasicLevels`. Defaults to returning
   *   `AccessLevels` in the format they were defined.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing [AccessLevel]{@link google.identity.accesscontextmanager.v1.AccessLevel} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listAccessLevelsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listAccessLevelsStream(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
    options?: CallOptions
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listAccessLevels'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listAccessLevels.createStream(
      this.innerApiCalls.listAccessLevels as GaxCall,
      request,
      callSettings
    );
  }

  /**
   * Equivalent to `listAccessLevels`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy to list [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] from.
   *
   *   Format:
   *   `accessPolicies/{policy_id}`
   * @param {number} request.pageSize
   *   Number of [Access Levels]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] to include in
   *   the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of [Access Level]
   *   [google.identity.accesscontextmanager.v1.AccessLevel] instances.
   *   Defaults to the first page of results.
   * @param {google.identity.accesscontextmanager.v1.LevelFormat} request.accessLevelFormat
   *   Whether to return `BasicLevels` in the Cloud Common Expression language, as
   *   `CustomLevels`, rather than as `BasicLevels`. Defaults to returning
   *   `AccessLevels` in the format they were defined.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
   *   When you iterate the returned iterable, each element will be an object representing
   *   [AccessLevel]{@link google.identity.accesscontextmanager.v1.AccessLevel}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.list_access_levels.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ListAccessLevels_async
   */
  listAccessLevelsAsync(
    request?: protos.google.identity.accesscontextmanager.v1.IListAccessLevelsRequest,
    options?: CallOptions
  ): AsyncIterable<protos.google.identity.accesscontextmanager.v1.IAccessLevel> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listAccessLevels'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listAccessLevels.asyncIterate(
      this.innerApiCalls['listAccessLevels'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.identity.accesscontextmanager.v1.IAccessLevel>;
  }
  /**
   * List all [Service Perimeters]
   * [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
   * access policy.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy to list [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
   *
   *   Format:
   *   `accessPolicies/{policy_id}`
   * @param {number} request.pageSize
   *   Number of [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] to include
   *   in the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of [Service Perimeter]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] instances.
   *   Defaults to the first page of results.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of [ServicePerimeter]{@link google.identity.accesscontextmanager.v1.ServicePerimeter}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listServicePerimetersAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listServicePerimeters(
    request?: protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter[],
      protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListServicePerimetersResponse
    ]
  >;
  listServicePerimeters(
    request: protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
      | protos.google.identity.accesscontextmanager.v1.IListServicePerimetersResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter
    >
  ): void;
  listServicePerimeters(
    request: protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
      | protos.google.identity.accesscontextmanager.v1.IListServicePerimetersResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter
    >
  ): void;
  listServicePerimeters(
    request?: protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
          | protos.google.identity.accesscontextmanager.v1.IListServicePerimetersResponse
          | null
          | undefined,
          protos.google.identity.accesscontextmanager.v1.IServicePerimeter
        >,
    callback?: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
      | protos.google.identity.accesscontextmanager.v1.IListServicePerimetersResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IServicePerimeter[],
      protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListServicePerimetersResponse
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.listServicePerimeters(request, options, callback);
  }

  /**
   * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy to list [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
   *
   *   Format:
   *   `accessPolicies/{policy_id}`
   * @param {number} request.pageSize
   *   Number of [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] to include
   *   in the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of [Service Perimeter]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] instances.
   *   Defaults to the first page of results.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing [ServicePerimeter]{@link google.identity.accesscontextmanager.v1.ServicePerimeter} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listServicePerimetersAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listServicePerimetersStream(
    request?: protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
    options?: CallOptions
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listServicePerimeters'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listServicePerimeters.createStream(
      this.innerApiCalls.listServicePerimeters as GaxCall,
      request,
      callSettings
    );
  }

  /**
   * Equivalent to `listServicePerimeters`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Resource name for the access policy to list [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
   *
   *   Format:
   *   `accessPolicies/{policy_id}`
   * @param {number} request.pageSize
   *   Number of [Service Perimeters]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] to include
   *   in the list. Default 100.
   * @param {string} request.pageToken
   *   Next page token for the next batch of [Service Perimeter]
   *   [google.identity.accesscontextmanager.v1.ServicePerimeter] instances.
   *   Defaults to the first page of results.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
   *   When you iterate the returned iterable, each element will be an object representing
   *   [ServicePerimeter]{@link google.identity.accesscontextmanager.v1.ServicePerimeter}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.list_service_perimeters.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ListServicePerimeters_async
   */
  listServicePerimetersAsync(
    request?: protos.google.identity.accesscontextmanager.v1.IListServicePerimetersRequest,
    options?: CallOptions
  ): AsyncIterable<protos.google.identity.accesscontextmanager.v1.IServicePerimeter> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listServicePerimeters'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listServicePerimeters.asyncIterate(
      this.innerApiCalls['listServicePerimeters'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.identity.accesscontextmanager.v1.IServicePerimeter>;
  }
  /**
   * Lists all [GcpUserAccessBindings]
   * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
   * Google Cloud organization.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Example: "organizations/256"
   * @param {number} [request.pageSize]
   *   Optional. Maximum number of items to return. The server may return fewer items.
   *   If left blank, the server may return any number of items.
   * @param {string} [request.pageToken]
   *   Optional. If left blank, returns the first page. To enumerate all items, use the
   *   [next_page_token]
   *   [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.next_page_token]
   *   from your previous list operation.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of [GcpUserAccessBinding]{@link google.identity.accesscontextmanager.v1.GcpUserAccessBinding}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listGcpUserAccessBindingsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listGcpUserAccessBindings(
    request?: protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding[],
      protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse
    ]
  >;
  listGcpUserAccessBindings(
    request: protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
      | protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding
    >
  ): void;
  listGcpUserAccessBindings(
    request: protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
    callback: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
      | protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding
    >
  ): void;
  listGcpUserAccessBindings(
    request?: protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
          | protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse
          | null
          | undefined,
          protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding
        >,
    callback?: PaginationCallback<
      protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
      | protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse
      | null
      | undefined,
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding
    >
  ): Promise<
    [
      protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding[],
      protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest | null,
      protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsResponse
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.listGcpUserAccessBindings(
      request,
      options,
      callback
    );
  }

  /**
   * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Example: "organizations/256"
   * @param {number} [request.pageSize]
   *   Optional. Maximum number of items to return. The server may return fewer items.
   *   If left blank, the server may return any number of items.
   * @param {string} [request.pageToken]
   *   Optional. If left blank, returns the first page. To enumerate all items, use the
   *   [next_page_token]
   *   [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.next_page_token]
   *   from your previous list operation.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing [GcpUserAccessBinding]{@link google.identity.accesscontextmanager.v1.GcpUserAccessBinding} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listGcpUserAccessBindingsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listGcpUserAccessBindingsStream(
    request?: protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
    options?: CallOptions
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listGcpUserAccessBindings'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listGcpUserAccessBindings.createStream(
      this.innerApiCalls.listGcpUserAccessBindings as GaxCall,
      request,
      callSettings
    );
  }

  /**
   * Equivalent to `listGcpUserAccessBindings`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. Example: "organizations/256"
   * @param {number} [request.pageSize]
   *   Optional. Maximum number of items to return. The server may return fewer items.
   *   If left blank, the server may return any number of items.
   * @param {string} [request.pageToken]
   *   Optional. If left blank, returns the first page. To enumerate all items, use the
   *   [next_page_token]
   *   [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.next_page_token]
   *   from your previous list operation.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
   *   When you iterate the returned iterable, each element will be an object representing
   *   [GcpUserAccessBinding]{@link google.identity.accesscontextmanager.v1.GcpUserAccessBinding}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v1/access_context_manager.list_gcp_user_access_bindings.js</caption>
   * region_tag:accesscontextmanager_v1_generated_AccessContextManager_ListGcpUserAccessBindings_async
   */
  listGcpUserAccessBindingsAsync(
    request?: protos.google.identity.accesscontextmanager.v1.IListGcpUserAccessBindingsRequest,
    options?: CallOptions
  ): AsyncIterable<protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listGcpUserAccessBindings'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listGcpUserAccessBindings.asyncIterate(
      this.innerApiCalls['listGcpUserAccessBindings'] as GaxCall,
      request as {},
      callSettings
    ) as AsyncIterable<protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding>;
  }
  // --------------------
  // -- Path templates --
  // --------------------

  /**
   * Return a fully-qualified accessLevel resource name string.
   *
   * @param {string} access_policy
   * @param {string} access_level
   * @returns {string} Resource name string.
   */
  accessLevelPath(accessPolicy: string, accessLevel: string) {
    return this.pathTemplates.accessLevelPathTemplate.render({
      access_policy: accessPolicy,
      access_level: accessLevel,
    });
  }

  /**
   * Parse the access_policy from AccessLevel resource.
   *
   * @param {string} accessLevelName
   *   A fully-qualified path representing AccessLevel resource.
   * @returns {string} A string representing the access_policy.
   */
  matchAccessPolicyFromAccessLevelName(accessLevelName: string) {
    return this.pathTemplates.accessLevelPathTemplate.match(accessLevelName)
      .access_policy;
  }

  /**
   * Parse the access_level from AccessLevel resource.
   *
   * @param {string} accessLevelName
   *   A fully-qualified path representing AccessLevel resource.
   * @returns {string} A string representing the access_level.
   */
  matchAccessLevelFromAccessLevelName(accessLevelName: string) {
    return this.pathTemplates.accessLevelPathTemplate.match(accessLevelName)
      .access_level;
  }

  /**
   * Return a fully-qualified accessPolicy resource name string.
   *
   * @param {string} access_policy
   * @returns {string} Resource name string.
   */
  accessPolicyPath(accessPolicy: string) {
    return this.pathTemplates.accessPolicyPathTemplate.render({
      access_policy: accessPolicy,
    });
  }

  /**
   * Parse the access_policy from AccessPolicy resource.
   *
   * @param {string} accessPolicyName
   *   A fully-qualified path representing AccessPolicy resource.
   * @returns {string} A string representing the access_policy.
   */
  matchAccessPolicyFromAccessPolicyName(accessPolicyName: string) {
    return this.pathTemplates.accessPolicyPathTemplate.match(accessPolicyName)
      .access_policy;
  }

  /**
   * Return a fully-qualified gcpUserAccessBinding resource name string.
   *
   * @param {string} organization
   * @param {string} gcp_user_access_binding
   * @returns {string} Resource name string.
   */
  gcpUserAccessBindingPath(organization: string, gcpUserAccessBinding: string) {
    return this.pathTemplates.gcpUserAccessBindingPathTemplate.render({
      organization: organization,
      gcp_user_access_binding: gcpUserAccessBinding,
    });
  }

  /**
   * Parse the organization from GcpUserAccessBinding resource.
   *
   * @param {string} gcpUserAccessBindingName
   *   A fully-qualified path representing GcpUserAccessBinding resource.
   * @returns {string} A string representing the organization.
   */
  matchOrganizationFromGcpUserAccessBindingName(
    gcpUserAccessBindingName: string
  ) {
    return this.pathTemplates.gcpUserAccessBindingPathTemplate.match(
      gcpUserAccessBindingName
    ).organization;
  }

  /**
   * Parse the gcp_user_access_binding from GcpUserAccessBinding resource.
   *
   * @param {string} gcpUserAccessBindingName
   *   A fully-qualified path representing GcpUserAccessBinding resource.
   * @returns {string} A string representing the gcp_user_access_binding.
   */
  matchGcpUserAccessBindingFromGcpUserAccessBindingName(
    gcpUserAccessBindingName: string
  ) {
    return this.pathTemplates.gcpUserAccessBindingPathTemplate.match(
      gcpUserAccessBindingName
    ).gcp_user_access_binding;
  }

  /**
   * Return a fully-qualified organization resource name string.
   *
   * @param {string} organization
   * @returns {string} Resource name string.
   */
  organizationPath(organization: string) {
    return this.pathTemplates.organizationPathTemplate.render({
      organization: organization,
    });
  }

  /**
   * Parse the organization from Organization resource.
   *
   * @param {string} organizationName
   *   A fully-qualified path representing Organization resource.
   * @returns {string} A string representing the organization.
   */
  matchOrganizationFromOrganizationName(organizationName: string) {
    return this.pathTemplates.organizationPathTemplate.match(organizationName)
      .organization;
  }

  /**
   * Return a fully-qualified servicePerimeter resource name string.
   *
   * @param {string} access_policy
   * @param {string} service_perimeter
   * @returns {string} Resource name string.
   */
  servicePerimeterPath(accessPolicy: string, servicePerimeter: string) {
    return this.pathTemplates.servicePerimeterPathTemplate.render({
      access_policy: accessPolicy,
      service_perimeter: servicePerimeter,
    });
  }

  /**
   * Parse the access_policy from ServicePerimeter resource.
   *
   * @param {string} servicePerimeterName
   *   A fully-qualified path representing ServicePerimeter resource.
   * @returns {string} A string representing the access_policy.
   */
  matchAccessPolicyFromServicePerimeterName(servicePerimeterName: string) {
    return this.pathTemplates.servicePerimeterPathTemplate.match(
      servicePerimeterName
    ).access_policy;
  }

  /**
   * Parse the service_perimeter from ServicePerimeter resource.
   *
   * @param {string} servicePerimeterName
   *   A fully-qualified path representing ServicePerimeter resource.
   * @returns {string} A string representing the service_perimeter.
   */
  matchServicePerimeterFromServicePerimeterName(servicePerimeterName: string) {
    return this.pathTemplates.servicePerimeterPathTemplate.match(
      servicePerimeterName
    ).service_perimeter;
  }

  /**
   * Terminate the gRPC channel and close the client.
   *
   * The client will no longer be usable and all future behavior is undefined.
   * @returns {Promise} A promise that resolves when the client is closed.
   */
  close(): Promise<void> {
    if (this.accessContextManagerStub && !this._terminated) {
      return this.accessContextManagerStub.then(stub => {
        this._terminated = true;
        stub.close();
        this.operationsClient.close();
      });
    }
    return Promise.resolve();
  }
}
