// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

import * as protos from '../protos/protos';
import * as assert from 'assert';
import * as sinon from 'sinon';
import {SinonStub} from 'sinon';
import {describe, it} from 'mocha';
import * as accesscontextmanagerModule from '../src';

import {PassThrough} from 'stream';

import {protobuf, LROperation, operationsProtos} from 'google-gax';

function generateSampleMessage<T extends object>(instance: T) {
  const filledObject = (
    instance.constructor as typeof protobuf.Message
  ).toObject(instance as protobuf.Message<T>, {defaults: true});
  return (instance.constructor as typeof protobuf.Message).fromObject(
    filledObject
  ) as T;
}

function stubSimpleCall<ResponseType>(response?: ResponseType, error?: Error) {
  return error
    ? sinon.stub().rejects(error)
    : sinon.stub().resolves([response]);
}

function stubSimpleCallWithCallback<ResponseType>(
  response?: ResponseType,
  error?: Error
) {
  return error
    ? sinon.stub().callsArgWith(2, error)
    : sinon.stub().callsArgWith(2, null, response);
}

function stubLongRunningCall<ResponseType>(
  response?: ResponseType,
  callError?: Error,
  lroError?: Error
) {
  const innerStub = lroError
    ? sinon.stub().rejects(lroError)
    : sinon.stub().resolves([response]);
  const mockOperation = {
    promise: innerStub,
  };
  return callError
    ? sinon.stub().rejects(callError)
    : sinon.stub().resolves([mockOperation]);
}

function stubLongRunningCallWithCallback<ResponseType>(
  response?: ResponseType,
  callError?: Error,
  lroError?: Error
) {
  const innerStub = lroError
    ? sinon.stub().rejects(lroError)
    : sinon.stub().resolves([response]);
  const mockOperation = {
    promise: innerStub,
  };
  return callError
    ? sinon.stub().callsArgWith(2, callError)
    : sinon.stub().callsArgWith(2, null, mockOperation);
}

function stubPageStreamingCall<ResponseType>(
  responses?: ResponseType[],
  error?: Error
) {
  const pagingStub = sinon.stub();
  if (responses) {
    for (let i = 0; i < responses.length; ++i) {
      pagingStub.onCall(i).callsArgWith(2, null, responses[i]);
    }
  }
  const transformStub = error
    ? sinon.stub().callsArgWith(2, error)
    : pagingStub;
  const mockStream = new PassThrough({
    objectMode: true,
    transform: transformStub,
  });
  // trigger as many responses as needed
  if (responses) {
    for (let i = 0; i < responses.length; ++i) {
      setImmediate(() => {
        mockStream.write({});
      });
    }
    setImmediate(() => {
      mockStream.end();
    });
  } else {
    setImmediate(() => {
      mockStream.write({});
    });
    setImmediate(() => {
      mockStream.end();
    });
  }
  return sinon.stub().returns(mockStream);
}

function stubAsyncIterationCall<ResponseType>(
  responses?: ResponseType[],
  error?: Error
) {
  let counter = 0;
  const asyncIterable = {
    [Symbol.asyncIterator]() {
      return {
        async next() {
          if (error) {
            return Promise.reject(error);
          }
          if (counter >= responses!.length) {
            return Promise.resolve({done: true, value: undefined});
          }
          return Promise.resolve({done: false, value: responses![counter++]});
        },
      };
    },
  };
  return sinon.stub().returns(asyncIterable);
}

describe('v1.AccessContextManagerClient', () => {
  describe('Common methods', () => {
    it('has servicePath', () => {
      const servicePath =
        accesscontextmanagerModule.v1.AccessContextManagerClient.servicePath;
      assert(servicePath);
    });

    it('has apiEndpoint', () => {
      const apiEndpoint =
        accesscontextmanagerModule.v1.AccessContextManagerClient.apiEndpoint;
      assert(apiEndpoint);
    });

    it('has port', () => {
      const port =
        accesscontextmanagerModule.v1.AccessContextManagerClient.port;
      assert(port);
      assert(typeof port === 'number');
    });

    it('should create a client with no option', () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient();
      assert(client);
    });

    it('should create a client with gRPC fallback', () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          fallback: true,
        });
      assert(client);
    });

    it('has initialize method and supports deferred initialization', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      assert.strictEqual(client.accessContextManagerStub, undefined);
      await client.initialize();
      assert(client.accessContextManagerStub);
    });

    it('has close method for the initialized client', done => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      assert(client.accessContextManagerStub);
      client.close().then(() => {
        done();
      });
    });

    it('has close method for the non-initialized client', done => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      assert.strictEqual(client.accessContextManagerStub, undefined);
      client.close().then(() => {
        done();
      });
    });

    it('has getProjectId method', async () => {
      const fakeProjectId = 'fake-project-id';
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.auth.getProjectId = sinon.stub().resolves(fakeProjectId);
      const result = await client.getProjectId();
      assert.strictEqual(result, fakeProjectId);
      assert((client.auth.getProjectId as SinonStub).calledWithExactly());
    });

    it('has getProjectId method with callback', async () => {
      const fakeProjectId = 'fake-project-id';
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.auth.getProjectId = sinon
        .stub()
        .callsArgWith(0, null, fakeProjectId);
      const promise = new Promise((resolve, reject) => {
        client.getProjectId((err?: Error | null, projectId?: string | null) => {
          if (err) {
            reject(err);
          } else {
            resolve(projectId);
          }
        });
      });
      const result = await promise;
      assert.strictEqual(result, fakeProjectId);
    });
  });

  describe('getAccessPolicy', () => {
    it('invokes getAccessPolicy without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
      );
      client.innerApiCalls.getAccessPolicy = stubSimpleCall(expectedResponse);
      const [response] = await client.getAccessPolicy(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getAccessPolicy without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
      );
      client.innerApiCalls.getAccessPolicy =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getAccessPolicy(
          request,
          (
            err?: Error | null,
            result?: protos.google.identity.accesscontextmanager.v1.IAccessPolicy | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes getAccessPolicy with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.getAccessPolicy = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.getAccessPolicy(request), expectedError);
      assert(
        (client.innerApiCalls.getAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getAccessPolicy with closed client', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest()
      );
      request.name = '';
      const expectedError = new Error('The client has already been closed.');
      client.close();
      await assert.rejects(client.getAccessPolicy(request), expectedError);
    });
  });

  describe('getAccessLevel', () => {
    it('invokes getAccessLevel without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessLevelRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessLevel()
      );
      client.innerApiCalls.getAccessLevel = stubSimpleCall(expectedResponse);
      const [response] = await client.getAccessLevel(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getAccessLevel without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessLevelRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessLevel()
      );
      client.innerApiCalls.getAccessLevel =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getAccessLevel(
          request,
          (
            err?: Error | null,
            result?: protos.google.identity.accesscontextmanager.v1.IAccessLevel | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes getAccessLevel with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessLevelRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.getAccessLevel = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.getAccessLevel(request), expectedError);
      assert(
        (client.innerApiCalls.getAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getAccessLevel with closed client', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetAccessLevelRequest()
      );
      request.name = '';
      const expectedError = new Error('The client has already been closed.');
      client.close();
      await assert.rejects(client.getAccessLevel(request), expectedError);
    });
  });

  describe('getServicePerimeter', () => {
    it('invokes getServicePerimeter without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
      );
      client.innerApiCalls.getServicePerimeter =
        stubSimpleCall(expectedResponse);
      const [response] = await client.getServicePerimeter(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getServicePerimeter without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
      );
      client.innerApiCalls.getServicePerimeter =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getServicePerimeter(
          request,
          (
            err?: Error | null,
            result?: protos.google.identity.accesscontextmanager.v1.IServicePerimeter | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes getServicePerimeter with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.getServicePerimeter = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.getServicePerimeter(request), expectedError);
      assert(
        (client.innerApiCalls.getServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getServicePerimeter with closed client', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest()
      );
      request.name = '';
      const expectedError = new Error('The client has already been closed.');
      client.close();
      await assert.rejects(client.getServicePerimeter(request), expectedError);
    });
  });

  describe('getGcpUserAccessBinding', () => {
    it('invokes getGcpUserAccessBinding without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
      );
      client.innerApiCalls.getGcpUserAccessBinding =
        stubSimpleCall(expectedResponse);
      const [response] = await client.getGcpUserAccessBinding(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getGcpUserAccessBinding without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
      );
      client.innerApiCalls.getGcpUserAccessBinding =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getGcpUserAccessBinding(
          request,
          (
            err?: Error | null,
            result?: protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.getGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes getGcpUserAccessBinding with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.getGcpUserAccessBinding = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.getGcpUserAccessBinding(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.getGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes getGcpUserAccessBinding with closed client', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedError = new Error('The client has already been closed.');
      client.close();
      await assert.rejects(
        client.getGcpUserAccessBinding(request),
        expectedError
      );
    });
  });

  describe('createAccessPolicy', () => {
    it('invokes createAccessPolicy without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
      );
      const expectedOptions = {otherArgs: {headers: {}}};
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createAccessPolicy =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createAccessPolicy(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createAccessPolicy without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
      );
      const expectedOptions = {otherArgs: {headers: {}}};
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createAccessPolicy =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createAccessPolicy(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes createAccessPolicy with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
      );
      const expectedOptions = {otherArgs: {headers: {}}};
      const expectedError = new Error('expected');
      client.innerApiCalls.createAccessPolicy = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.createAccessPolicy(request), expectedError);
      assert(
        (client.innerApiCalls.createAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createAccessPolicy with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
      );
      const expectedOptions = {otherArgs: {headers: {}}};
      const expectedError = new Error('expected');
      client.innerApiCalls.createAccessPolicy = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.createAccessPolicy(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.createAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkCreateAccessPolicyProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCreateAccessPolicyProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateAccessPolicyProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkCreateAccessPolicyProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateAccessPolicy', () => {
    it('invokes updateAccessPolicy without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest()
      );
      request.policy = {};
      request.policy.name = '';
      const expectedHeaderRequestParams = 'policy.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateAccessPolicy =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateAccessPolicy(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateAccessPolicy without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest()
      );
      request.policy = {};
      request.policy.name = '';
      const expectedHeaderRequestParams = 'policy.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateAccessPolicy =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateAccessPolicy(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessPolicy,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes updateAccessPolicy with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest()
      );
      request.policy = {};
      request.policy.name = '';
      const expectedHeaderRequestParams = 'policy.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateAccessPolicy = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.updateAccessPolicy(request), expectedError);
      assert(
        (client.innerApiCalls.updateAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateAccessPolicy with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest()
      );
      request.policy = {};
      request.policy.name = '';
      const expectedHeaderRequestParams = 'policy.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateAccessPolicy = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.updateAccessPolicy(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.updateAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkUpdateAccessPolicyProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkUpdateAccessPolicyProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateAccessPolicyProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkUpdateAccessPolicyProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('deleteAccessPolicy', () => {
    it('invokes deleteAccessPolicy without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteAccessPolicy =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.deleteAccessPolicy(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteAccessPolicy without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteAccessPolicy =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteAccessPolicy(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.protobuf.IEmpty,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes deleteAccessPolicy with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteAccessPolicy = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.deleteAccessPolicy(request), expectedError);
      assert(
        (client.innerApiCalls.deleteAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteAccessPolicy with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteAccessPolicy = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.deleteAccessPolicy(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.deleteAccessPolicy as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkDeleteAccessPolicyProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkDeleteAccessPolicyProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkDeleteAccessPolicyProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkDeleteAccessPolicyProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('createAccessLevel', () => {
    it('invokes createAccessLevel without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createAccessLevel =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createAccessLevel(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createAccessLevel without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createAccessLevel =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createAccessLevel(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IAccessLevel,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes createAccessLevel with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.createAccessLevel = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.createAccessLevel(request), expectedError);
      assert(
        (client.innerApiCalls.createAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createAccessLevel with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.createAccessLevel = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.createAccessLevel(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.createAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkCreateAccessLevelProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCreateAccessLevelProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateAccessLevelProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkCreateAccessLevelProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateAccessLevel', () => {
    it('invokes updateAccessLevel without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest()
      );
      request.accessLevel = {};
      request.accessLevel.name = '';
      const expectedHeaderRequestParams = 'access_level.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateAccessLevel =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateAccessLevel(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateAccessLevel without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest()
      );
      request.accessLevel = {};
      request.accessLevel.name = '';
      const expectedHeaderRequestParams = 'access_level.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateAccessLevel =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateAccessLevel(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IAccessLevel,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IAccessLevel,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes updateAccessLevel with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest()
      );
      request.accessLevel = {};
      request.accessLevel.name = '';
      const expectedHeaderRequestParams = 'access_level.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateAccessLevel = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.updateAccessLevel(request), expectedError);
      assert(
        (client.innerApiCalls.updateAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateAccessLevel with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest()
      );
      request.accessLevel = {};
      request.accessLevel.name = '';
      const expectedHeaderRequestParams = 'access_level.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateAccessLevel = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.updateAccessLevel(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.updateAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkUpdateAccessLevelProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkUpdateAccessLevelProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateAccessLevelProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkUpdateAccessLevelProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('deleteAccessLevel', () => {
    it('invokes deleteAccessLevel without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteAccessLevel =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.deleteAccessLevel(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteAccessLevel without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteAccessLevel =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteAccessLevel(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.protobuf.IEmpty,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes deleteAccessLevel with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteAccessLevel = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.deleteAccessLevel(request), expectedError);
      assert(
        (client.innerApiCalls.deleteAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteAccessLevel with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteAccessLevel = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.deleteAccessLevel(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.deleteAccessLevel as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkDeleteAccessLevelProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkDeleteAccessLevelProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkDeleteAccessLevelProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkDeleteAccessLevelProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('replaceAccessLevels', () => {
    it('invokes replaceAccessLevels without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.replaceAccessLevels =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.replaceAccessLevels(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.replaceAccessLevels as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes replaceAccessLevels without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.replaceAccessLevels =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.replaceAccessLevels(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceAccessLevelsResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.replaceAccessLevels as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes replaceAccessLevels with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.replaceAccessLevels = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.replaceAccessLevels(request), expectedError);
      assert(
        (client.innerApiCalls.replaceAccessLevels as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes replaceAccessLevels with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.replaceAccessLevels = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.replaceAccessLevels(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.replaceAccessLevels as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkReplaceAccessLevelsProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkReplaceAccessLevelsProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkReplaceAccessLevelsProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkReplaceAccessLevelsProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('createServicePerimeter', () => {
    it('invokes createServicePerimeter without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createServicePerimeter =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createServicePerimeter(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createServicePerimeter without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createServicePerimeter =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createServicePerimeter(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes createServicePerimeter with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.createServicePerimeter = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.createServicePerimeter(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.createServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createServicePerimeter with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.createServicePerimeter = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.createServicePerimeter(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.createServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkCreateServicePerimeterProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCreateServicePerimeterProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateServicePerimeterProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkCreateServicePerimeterProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateServicePerimeter', () => {
    it('invokes updateServicePerimeter without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest()
      );
      request.servicePerimeter = {};
      request.servicePerimeter.name = '';
      const expectedHeaderRequestParams = 'service_perimeter.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateServicePerimeter =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateServicePerimeter(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateServicePerimeter without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest()
      );
      request.servicePerimeter = {};
      request.servicePerimeter.name = '';
      const expectedHeaderRequestParams = 'service_perimeter.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateServicePerimeter =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateServicePerimeter(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IServicePerimeter,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes updateServicePerimeter with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest()
      );
      request.servicePerimeter = {};
      request.servicePerimeter.name = '';
      const expectedHeaderRequestParams = 'service_perimeter.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateServicePerimeter = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.updateServicePerimeter(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.updateServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateServicePerimeter with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest()
      );
      request.servicePerimeter = {};
      request.servicePerimeter.name = '';
      const expectedHeaderRequestParams = 'service_perimeter.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateServicePerimeter = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.updateServicePerimeter(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.updateServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkUpdateServicePerimeterProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkUpdateServicePerimeterProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateServicePerimeterProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkUpdateServicePerimeterProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('deleteServicePerimeter', () => {
    it('invokes deleteServicePerimeter without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteServicePerimeter =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.deleteServicePerimeter(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteServicePerimeter without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteServicePerimeter =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteServicePerimeter(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.protobuf.IEmpty,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes deleteServicePerimeter with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteServicePerimeter = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.deleteServicePerimeter(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.deleteServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteServicePerimeter with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteServicePerimeter = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.deleteServicePerimeter(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.deleteServicePerimeter as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkDeleteServicePerimeterProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkDeleteServicePerimeterProgress(
        expectedResponse.name
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkDeleteServicePerimeterProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkDeleteServicePerimeterProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('replaceServicePerimeters', () => {
    it('invokes replaceServicePerimeters without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.replaceServicePerimeters =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.replaceServicePerimeters(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.replaceServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes replaceServicePerimeters without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.replaceServicePerimeters =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.replaceServicePerimeters(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IReplaceServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.replaceServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes replaceServicePerimeters with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.replaceServicePerimeters = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.replaceServicePerimeters(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.replaceServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes replaceServicePerimeters with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.replaceServicePerimeters = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.replaceServicePerimeters(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.replaceServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkReplaceServicePerimetersProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation =
        await client.checkReplaceServicePerimetersProgress(
          expectedResponse.name
        );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkReplaceServicePerimetersProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkReplaceServicePerimetersProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('commitServicePerimeters', () => {
    it('invokes commitServicePerimeters without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.commitServicePerimeters =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.commitServicePerimeters(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.commitServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes commitServicePerimeters without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.commitServicePerimeters =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.commitServicePerimeters(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
              protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.ICommitServicePerimetersResponse,
        protos.google.identity.accesscontextmanager.v1.IAccessContextManagerOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.commitServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes commitServicePerimeters with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.commitServicePerimeters = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.commitServicePerimeters(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.commitServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes commitServicePerimeters with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.commitServicePerimeters = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.commitServicePerimeters(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.commitServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkCommitServicePerimetersProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation =
        await client.checkCommitServicePerimetersProgress(
          expectedResponse.name
        );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCommitServicePerimetersProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkCommitServicePerimetersProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('createGcpUserAccessBinding', () => {
    it('invokes createGcpUserAccessBinding without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createGcpUserAccessBinding =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createGcpUserAccessBinding(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createGcpUserAccessBinding without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.createGcpUserAccessBinding =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createGcpUserAccessBinding(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
              protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.createGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes createGcpUserAccessBinding with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.createGcpUserAccessBinding = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.createGcpUserAccessBinding(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.createGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes createGcpUserAccessBinding with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.createGcpUserAccessBinding = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.createGcpUserAccessBinding(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.createGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkCreateGcpUserAccessBindingProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation =
        await client.checkCreateGcpUserAccessBindingProgress(
          expectedResponse.name
        );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateGcpUserAccessBindingProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkCreateGcpUserAccessBindingProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateGcpUserAccessBinding', () => {
    it('invokes updateGcpUserAccessBinding without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest()
      );
      request.gcpUserAccessBinding = {};
      request.gcpUserAccessBinding.name = '';
      const expectedHeaderRequestParams = 'gcp_user_access_binding.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateGcpUserAccessBinding =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateGcpUserAccessBinding(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateGcpUserAccessBinding without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest()
      );
      request.gcpUserAccessBinding = {};
      request.gcpUserAccessBinding.name = '';
      const expectedHeaderRequestParams = 'gcp_user_access_binding.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.updateGcpUserAccessBinding =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateGcpUserAccessBinding(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
              protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.updateGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes updateGcpUserAccessBinding with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest()
      );
      request.gcpUserAccessBinding = {};
      request.gcpUserAccessBinding.name = '';
      const expectedHeaderRequestParams = 'gcp_user_access_binding.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateGcpUserAccessBinding = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.updateGcpUserAccessBinding(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.updateGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes updateGcpUserAccessBinding with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest()
      );
      request.gcpUserAccessBinding = {};
      request.gcpUserAccessBinding.name = '';
      const expectedHeaderRequestParams = 'gcp_user_access_binding.name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.updateGcpUserAccessBinding = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.updateGcpUserAccessBinding(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.updateGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkUpdateGcpUserAccessBindingProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation =
        await client.checkUpdateGcpUserAccessBindingProgress(
          expectedResponse.name
        );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateGcpUserAccessBindingProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkUpdateGcpUserAccessBindingProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('deleteGcpUserAccessBinding', () => {
    it('invokes deleteGcpUserAccessBinding without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteGcpUserAccessBinding =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.deleteGcpUserAccessBinding(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteGcpUserAccessBinding without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation()
      );
      client.innerApiCalls.deleteGcpUserAccessBinding =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteGcpUserAccessBinding(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.protobuf.IEmpty,
              protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
            > | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBindingOperationMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.deleteGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes deleteGcpUserAccessBinding with call error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteGcpUserAccessBinding = stubLongRunningCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.deleteGcpUserAccessBinding(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.deleteGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes deleteGcpUserAccessBinding with LRO error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest()
      );
      request.name = '';
      const expectedHeaderRequestParams = 'name=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteGcpUserAccessBinding = stubLongRunningCall(
        undefined,
        undefined,
        expectedError
      );
      const [operation] = await client.deleteGcpUserAccessBinding(request);
      await assert.rejects(operation.promise(), expectedError);
      assert(
        (client.innerApiCalls.deleteGcpUserAccessBinding as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes checkDeleteGcpUserAccessBindingProgress without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation()
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation =
        await client.checkDeleteGcpUserAccessBindingProgress(
          expectedResponse.name
        );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkDeleteGcpUserAccessBindingProgress with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.checkDeleteGcpUserAccessBindingProgress(''),
        expectedError
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('listAccessPolicies', () => {
    it('invokes listAccessPolicies without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest()
      );
      const expectedOptions = {otherArgs: {headers: {}}};
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
      ];
      client.innerApiCalls.listAccessPolicies =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listAccessPolicies(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listAccessPolicies as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listAccessPolicies without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest()
      );
      const expectedOptions = {otherArgs: {headers: {}}};
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
      ];
      client.innerApiCalls.listAccessPolicies =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listAccessPolicies(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.identity.accesscontextmanager.v1.IAccessPolicy[]
              | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listAccessPolicies as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes listAccessPolicies with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest()
      );
      const expectedOptions = {otherArgs: {headers: {}}};
      const expectedError = new Error('expected');
      client.innerApiCalls.listAccessPolicies = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.listAccessPolicies(request), expectedError);
      assert(
        (client.innerApiCalls.listAccessPolicies as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listAccessPoliciesStream without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest()
      );
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
      ];
      client.descriptors.page.listAccessPolicies.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listAccessPoliciesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.AccessPolicy[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.AccessPolicy
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listAccessPolicies.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listAccessPolicies, request)
      );
    });

    it('invokes listAccessPoliciesStream with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest()
      );
      const expectedError = new Error('expected');
      client.descriptors.page.listAccessPolicies.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listAccessPoliciesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.AccessPolicy[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.AccessPolicy
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listAccessPolicies.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listAccessPolicies, request)
      );
    });

    it('uses async iteration with listAccessPolicies without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest()
      );
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessPolicy()
        ),
      ];
      client.descriptors.page.listAccessPolicies.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.identity.accesscontextmanager.v1.IAccessPolicy[] =
        [];
      const iterable = client.listAccessPoliciesAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listAccessPolicies.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
    });

    it('uses async iteration with listAccessPolicies with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest()
      );
      const expectedError = new Error('expected');
      client.descriptors.page.listAccessPolicies.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listAccessPoliciesAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.identity.accesscontextmanager.v1.IAccessPolicy[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listAccessPolicies.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
    });
  });

  describe('listAccessLevels', () => {
    it('invokes listAccessLevels without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
      ];
      client.innerApiCalls.listAccessLevels = stubSimpleCall(expectedResponse);
      const [response] = await client.listAccessLevels(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listAccessLevels as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listAccessLevels without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
      ];
      client.innerApiCalls.listAccessLevels =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listAccessLevels(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.identity.accesscontextmanager.v1.IAccessLevel[]
              | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listAccessLevels as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes listAccessLevels with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.listAccessLevels = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(client.listAccessLevels(request), expectedError);
      assert(
        (client.innerApiCalls.listAccessLevels as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listAccessLevelsStream without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
      ];
      client.descriptors.page.listAccessLevels.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listAccessLevelsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.AccessLevel[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.AccessLevel
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listAccessLevels.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listAccessLevels, request)
      );
      assert.strictEqual(
        (
          client.descriptors.page.listAccessLevels.createStream as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('invokes listAccessLevelsStream with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedError = new Error('expected');
      client.descriptors.page.listAccessLevels.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listAccessLevelsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.AccessLevel[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.AccessLevel
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listAccessLevels.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listAccessLevels, request)
      );
      assert.strictEqual(
        (
          client.descriptors.page.listAccessLevels.createStream as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('uses async iteration with listAccessLevels without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.AccessLevel()
        ),
      ];
      client.descriptors.page.listAccessLevels.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.identity.accesscontextmanager.v1.IAccessLevel[] =
        [];
      const iterable = client.listAccessLevelsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listAccessLevels.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
      assert.strictEqual(
        (
          client.descriptors.page.listAccessLevels.asyncIterate as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('uses async iteration with listAccessLevels with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedError = new Error('expected');
      client.descriptors.page.listAccessLevels.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listAccessLevelsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.identity.accesscontextmanager.v1.IAccessLevel[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listAccessLevels.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
      assert.strictEqual(
        (
          client.descriptors.page.listAccessLevels.asyncIterate as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });
  });

  describe('listServicePerimeters', () => {
    it('invokes listServicePerimeters without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
      ];
      client.innerApiCalls.listServicePerimeters =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listServicePerimeters(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listServicePerimeters without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
      ];
      client.innerApiCalls.listServicePerimeters =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listServicePerimeters(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.identity.accesscontextmanager.v1.IServicePerimeter[]
              | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes listServicePerimeters with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.listServicePerimeters = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.listServicePerimeters(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.listServicePerimeters as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listServicePerimetersStream without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
      ];
      client.descriptors.page.listServicePerimeters.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listServicePerimetersStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.ServicePerimeter[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.ServicePerimeter
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (
          client.descriptors.page.listServicePerimeters
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listServicePerimeters, request)
      );
      assert.strictEqual(
        (
          client.descriptors.page.listServicePerimeters
            .createStream as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('invokes listServicePerimetersStream with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedError = new Error('expected');
      client.descriptors.page.listServicePerimeters.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listServicePerimetersStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.ServicePerimeter[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.ServicePerimeter
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (
          client.descriptors.page.listServicePerimeters
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listServicePerimeters, request)
      );
      assert.strictEqual(
        (
          client.descriptors.page.listServicePerimeters
            .createStream as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('uses async iteration with listServicePerimeters without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.ServicePerimeter()
        ),
      ];
      client.descriptors.page.listServicePerimeters.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.identity.accesscontextmanager.v1.IServicePerimeter[] =
        [];
      const iterable = client.listServicePerimetersAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listServicePerimeters
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
      assert.strictEqual(
        (
          client.descriptors.page.listServicePerimeters
            .asyncIterate as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('uses async iteration with listServicePerimeters with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedError = new Error('expected');
      client.descriptors.page.listServicePerimeters.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listServicePerimetersAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.identity.accesscontextmanager.v1.IServicePerimeter[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listServicePerimeters
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
      assert.strictEqual(
        (
          client.descriptors.page.listServicePerimeters
            .asyncIterate as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });
  });

  describe('listGcpUserAccessBindings', () => {
    it('invokes listGcpUserAccessBindings without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
      ];
      client.innerApiCalls.listGcpUserAccessBindings =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listGcpUserAccessBindings(request);
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listGcpUserAccessBindings as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listGcpUserAccessBindings without error using callback', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
      ];
      client.innerApiCalls.listGcpUserAccessBindings =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listGcpUserAccessBindings(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding[]
              | null
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          }
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert(
        (client.innerApiCalls.listGcpUserAccessBindings as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions /*, callback defined above */)
      );
    });

    it('invokes listGcpUserAccessBindings with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedOptions = {
        otherArgs: {
          headers: {
            'x-goog-request-params': expectedHeaderRequestParams,
          },
        },
      };
      const expectedError = new Error('expected');
      client.innerApiCalls.listGcpUserAccessBindings = stubSimpleCall(
        undefined,
        expectedError
      );
      await assert.rejects(
        client.listGcpUserAccessBindings(request),
        expectedError
      );
      assert(
        (client.innerApiCalls.listGcpUserAccessBindings as SinonStub)
          .getCall(0)
          .calledWith(request, expectedOptions, undefined)
      );
    });

    it('invokes listGcpUserAccessBindingsStream without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
      ];
      client.descriptors.page.listGcpUserAccessBindings.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listGcpUserAccessBindingsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listGcpUserAccessBindings, request)
      );
      assert.strictEqual(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .createStream as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('invokes listGcpUserAccessBindingsStream with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedError = new Error('expected');
      client.descriptors.page.listGcpUserAccessBindings.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listGcpUserAccessBindingsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding
          ) => {
            responses.push(response);
          }
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listGcpUserAccessBindings, request)
      );
      assert.strictEqual(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .createStream as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('uses async iteration with listGcpUserAccessBindings without error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
        generateSampleMessage(
          new protos.google.identity.accesscontextmanager.v1.GcpUserAccessBinding()
        ),
      ];
      client.descriptors.page.listGcpUserAccessBindings.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding[] =
        [];
      const iterable = client.listGcpUserAccessBindingsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
      assert.strictEqual(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .asyncIterate as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });

    it('uses async iteration with listGcpUserAccessBindings with error', async () => {
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      const request = generateSampleMessage(
        new protos.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest()
      );
      request.parent = '';
      const expectedHeaderRequestParams = 'parent=';
      const expectedError = new Error('expected');
      client.descriptors.page.listGcpUserAccessBindings.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listGcpUserAccessBindingsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.identity.accesscontextmanager.v1.IGcpUserAccessBinding[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request
      );
      assert.strictEqual(
        (
          client.descriptors.page.listGcpUserAccessBindings
            .asyncIterate as SinonStub
        ).getCall(0).args[2].otherArgs.headers['x-goog-request-params'],
        expectedHeaderRequestParams
      );
    });
  });

  describe('Path templates', () => {
    describe('accessLevel', () => {
      const fakePath = '/rendered/path/accessLevel';
      const expectedParameters = {
        access_policy: 'accessPolicyValue',
        access_level: 'accessLevelValue',
      };
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      client.pathTemplates.accessLevelPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.accessLevelPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('accessLevelPath', () => {
        const result = client.accessLevelPath(
          'accessPolicyValue',
          'accessLevelValue'
        );
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.accessLevelPathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters)
        );
      });

      it('matchAccessPolicyFromAccessLevelName', () => {
        const result = client.matchAccessPolicyFromAccessLevelName(fakePath);
        assert.strictEqual(result, 'accessPolicyValue');
        assert(
          (client.pathTemplates.accessLevelPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath)
        );
      });

      it('matchAccessLevelFromAccessLevelName', () => {
        const result = client.matchAccessLevelFromAccessLevelName(fakePath);
        assert.strictEqual(result, 'accessLevelValue');
        assert(
          (client.pathTemplates.accessLevelPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath)
        );
      });
    });

    describe('accessPolicy', () => {
      const fakePath = '/rendered/path/accessPolicy';
      const expectedParameters = {
        access_policy: 'accessPolicyValue',
      };
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      client.pathTemplates.accessPolicyPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.accessPolicyPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('accessPolicyPath', () => {
        const result = client.accessPolicyPath('accessPolicyValue');
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.accessPolicyPathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters)
        );
      });

      it('matchAccessPolicyFromAccessPolicyName', () => {
        const result = client.matchAccessPolicyFromAccessPolicyName(fakePath);
        assert.strictEqual(result, 'accessPolicyValue');
        assert(
          (client.pathTemplates.accessPolicyPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath)
        );
      });
    });

    describe('gcpUserAccessBinding', () => {
      const fakePath = '/rendered/path/gcpUserAccessBinding';
      const expectedParameters = {
        organization: 'organizationValue',
        gcp_user_access_binding: 'gcpUserAccessBindingValue',
      };
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      client.pathTemplates.gcpUserAccessBindingPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.gcpUserAccessBindingPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('gcpUserAccessBindingPath', () => {
        const result = client.gcpUserAccessBindingPath(
          'organizationValue',
          'gcpUserAccessBindingValue'
        );
        assert.strictEqual(result, fakePath);
        assert(
          (
            client.pathTemplates.gcpUserAccessBindingPathTemplate
              .render as SinonStub
          )
            .getCall(-1)
            .calledWith(expectedParameters)
        );
      });

      it('matchOrganizationFromGcpUserAccessBindingName', () => {
        const result =
          client.matchOrganizationFromGcpUserAccessBindingName(fakePath);
        assert.strictEqual(result, 'organizationValue');
        assert(
          (
            client.pathTemplates.gcpUserAccessBindingPathTemplate
              .match as SinonStub
          )
            .getCall(-1)
            .calledWith(fakePath)
        );
      });

      it('matchGcpUserAccessBindingFromGcpUserAccessBindingName', () => {
        const result =
          client.matchGcpUserAccessBindingFromGcpUserAccessBindingName(
            fakePath
          );
        assert.strictEqual(result, 'gcpUserAccessBindingValue');
        assert(
          (
            client.pathTemplates.gcpUserAccessBindingPathTemplate
              .match as SinonStub
          )
            .getCall(-1)
            .calledWith(fakePath)
        );
      });
    });

    describe('organization', () => {
      const fakePath = '/rendered/path/organization';
      const expectedParameters = {
        organization: 'organizationValue',
      };
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      client.pathTemplates.organizationPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.organizationPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('organizationPath', () => {
        const result = client.organizationPath('organizationValue');
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.organizationPathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters)
        );
      });

      it('matchOrganizationFromOrganizationName', () => {
        const result = client.matchOrganizationFromOrganizationName(fakePath);
        assert.strictEqual(result, 'organizationValue');
        assert(
          (client.pathTemplates.organizationPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath)
        );
      });
    });

    describe('servicePerimeter', () => {
      const fakePath = '/rendered/path/servicePerimeter';
      const expectedParameters = {
        access_policy: 'accessPolicyValue',
        service_perimeter: 'servicePerimeterValue',
      };
      const client =
        new accesscontextmanagerModule.v1.AccessContextManagerClient({
          credentials: {client_email: 'bogus', private_key: 'bogus'},
          projectId: 'bogus',
        });
      client.initialize();
      client.pathTemplates.servicePerimeterPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.servicePerimeterPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('servicePerimeterPath', () => {
        const result = client.servicePerimeterPath(
          'accessPolicyValue',
          'servicePerimeterValue'
        );
        assert.strictEqual(result, fakePath);
        assert(
          (
            client.pathTemplates.servicePerimeterPathTemplate
              .render as SinonStub
          )
            .getCall(-1)
            .calledWith(expectedParameters)
        );
      });

      it('matchAccessPolicyFromServicePerimeterName', () => {
        const result =
          client.matchAccessPolicyFromServicePerimeterName(fakePath);
        assert.strictEqual(result, 'accessPolicyValue');
        assert(
          (client.pathTemplates.servicePerimeterPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath)
        );
      });

      it('matchServicePerimeterFromServicePerimeterName', () => {
        const result =
          client.matchServicePerimeterFromServicePerimeterName(fakePath);
        assert.strictEqual(result, 'servicePerimeterValue');
        assert(
          (client.pathTemplates.servicePerimeterPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath)
        );
      });
    });
  });
});
