// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import * as Long from "long";
import {protobuf as $protobuf} from "google-gax";
/** Namespace google. */
export namespace google {

    /** Namespace cloud. */
    namespace cloud {

        /** Namespace dialogflow. */
        namespace dialogflow {

            /** Namespace v2. */
            namespace v2 {

                /** Represents an Agents */
                class Agents extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new Agents service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new Agents service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Agents;

                    /**
                     * Calls GetAgent.
                     * @param request GetAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Agent
                     */
                    public getAgent(request: google.cloud.dialogflow.v2.IGetAgentRequest, callback: google.cloud.dialogflow.v2.Agents.GetAgentCallback): void;

                    /**
                     * Calls GetAgent.
                     * @param request GetAgentRequest message or plain object
                     * @returns Promise
                     */
                    public getAgent(request: google.cloud.dialogflow.v2.IGetAgentRequest): Promise<google.cloud.dialogflow.v2.Agent>;

                    /**
                     * Calls SetAgent.
                     * @param request SetAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Agent
                     */
                    public setAgent(request: google.cloud.dialogflow.v2.ISetAgentRequest, callback: google.cloud.dialogflow.v2.Agents.SetAgentCallback): void;

                    /**
                     * Calls SetAgent.
                     * @param request SetAgentRequest message or plain object
                     * @returns Promise
                     */
                    public setAgent(request: google.cloud.dialogflow.v2.ISetAgentRequest): Promise<google.cloud.dialogflow.v2.Agent>;

                    /**
                     * Calls DeleteAgent.
                     * @param request DeleteAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteAgent(request: google.cloud.dialogflow.v2.IDeleteAgentRequest, callback: google.cloud.dialogflow.v2.Agents.DeleteAgentCallback): void;

                    /**
                     * Calls DeleteAgent.
                     * @param request DeleteAgentRequest message or plain object
                     * @returns Promise
                     */
                    public deleteAgent(request: google.cloud.dialogflow.v2.IDeleteAgentRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls SearchAgents.
                     * @param request SearchAgentsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and SearchAgentsResponse
                     */
                    public searchAgents(request: google.cloud.dialogflow.v2.ISearchAgentsRequest, callback: google.cloud.dialogflow.v2.Agents.SearchAgentsCallback): void;

                    /**
                     * Calls SearchAgents.
                     * @param request SearchAgentsRequest message or plain object
                     * @returns Promise
                     */
                    public searchAgents(request: google.cloud.dialogflow.v2.ISearchAgentsRequest): Promise<google.cloud.dialogflow.v2.SearchAgentsResponse>;

                    /**
                     * Calls TrainAgent.
                     * @param request TrainAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public trainAgent(request: google.cloud.dialogflow.v2.ITrainAgentRequest, callback: google.cloud.dialogflow.v2.Agents.TrainAgentCallback): void;

                    /**
                     * Calls TrainAgent.
                     * @param request TrainAgentRequest message or plain object
                     * @returns Promise
                     */
                    public trainAgent(request: google.cloud.dialogflow.v2.ITrainAgentRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls ExportAgent.
                     * @param request ExportAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public exportAgent(request: google.cloud.dialogflow.v2.IExportAgentRequest, callback: google.cloud.dialogflow.v2.Agents.ExportAgentCallback): void;

                    /**
                     * Calls ExportAgent.
                     * @param request ExportAgentRequest message or plain object
                     * @returns Promise
                     */
                    public exportAgent(request: google.cloud.dialogflow.v2.IExportAgentRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls ImportAgent.
                     * @param request ImportAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public importAgent(request: google.cloud.dialogflow.v2.IImportAgentRequest, callback: google.cloud.dialogflow.v2.Agents.ImportAgentCallback): void;

                    /**
                     * Calls ImportAgent.
                     * @param request ImportAgentRequest message or plain object
                     * @returns Promise
                     */
                    public importAgent(request: google.cloud.dialogflow.v2.IImportAgentRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls RestoreAgent.
                     * @param request RestoreAgentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public restoreAgent(request: google.cloud.dialogflow.v2.IRestoreAgentRequest, callback: google.cloud.dialogflow.v2.Agents.RestoreAgentCallback): void;

                    /**
                     * Calls RestoreAgent.
                     * @param request RestoreAgentRequest message or plain object
                     * @returns Promise
                     */
                    public restoreAgent(request: google.cloud.dialogflow.v2.IRestoreAgentRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls GetValidationResult.
                     * @param request GetValidationResultRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ValidationResult
                     */
                    public getValidationResult(request: google.cloud.dialogflow.v2.IGetValidationResultRequest, callback: google.cloud.dialogflow.v2.Agents.GetValidationResultCallback): void;

                    /**
                     * Calls GetValidationResult.
                     * @param request GetValidationResultRequest message or plain object
                     * @returns Promise
                     */
                    public getValidationResult(request: google.cloud.dialogflow.v2.IGetValidationResultRequest): Promise<google.cloud.dialogflow.v2.ValidationResult>;
                }

                namespace Agents {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#getAgent}.
                     * @param error Error, if any
                     * @param [response] Agent
                     */
                    type GetAgentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Agent) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#setAgent}.
                     * @param error Error, if any
                     * @param [response] Agent
                     */
                    type SetAgentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Agent) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#deleteAgent}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteAgentCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#searchAgents}.
                     * @param error Error, if any
                     * @param [response] SearchAgentsResponse
                     */
                    type SearchAgentsCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.SearchAgentsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#trainAgent}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type TrainAgentCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#exportAgent}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type ExportAgentCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#importAgent}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type ImportAgentCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#restoreAgent}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type RestoreAgentCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Agents#getValidationResult}.
                     * @param error Error, if any
                     * @param [response] ValidationResult
                     */
                    type GetValidationResultCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ValidationResult) => void;
                }

                /** Properties of an Agent. */
                interface IAgent {

                    /** Agent parent */
                    parent?: (string|null);

                    /** Agent displayName */
                    displayName?: (string|null);

                    /** Agent defaultLanguageCode */
                    defaultLanguageCode?: (string|null);

                    /** Agent supportedLanguageCodes */
                    supportedLanguageCodes?: (string[]|null);

                    /** Agent timeZone */
                    timeZone?: (string|null);

                    /** Agent description */
                    description?: (string|null);

                    /** Agent avatarUri */
                    avatarUri?: (string|null);

                    /** Agent enableLogging */
                    enableLogging?: (boolean|null);

                    /** Agent matchMode */
                    matchMode?: (google.cloud.dialogflow.v2.Agent.MatchMode|keyof typeof google.cloud.dialogflow.v2.Agent.MatchMode|null);

                    /** Agent classificationThreshold */
                    classificationThreshold?: (number|null);

                    /** Agent apiVersion */
                    apiVersion?: (google.cloud.dialogflow.v2.Agent.ApiVersion|keyof typeof google.cloud.dialogflow.v2.Agent.ApiVersion|null);

                    /** Agent tier */
                    tier?: (google.cloud.dialogflow.v2.Agent.Tier|keyof typeof google.cloud.dialogflow.v2.Agent.Tier|null);
                }

                /** Represents an Agent. */
                class Agent implements IAgent {

                    /**
                     * Constructs a new Agent.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAgent);

                    /** Agent parent. */
                    public parent: string;

                    /** Agent displayName. */
                    public displayName: string;

                    /** Agent defaultLanguageCode. */
                    public defaultLanguageCode: string;

                    /** Agent supportedLanguageCodes. */
                    public supportedLanguageCodes: string[];

                    /** Agent timeZone. */
                    public timeZone: string;

                    /** Agent description. */
                    public description: string;

                    /** Agent avatarUri. */
                    public avatarUri: string;

                    /** Agent enableLogging. */
                    public enableLogging: boolean;

                    /** Agent matchMode. */
                    public matchMode: (google.cloud.dialogflow.v2.Agent.MatchMode|keyof typeof google.cloud.dialogflow.v2.Agent.MatchMode);

                    /** Agent classificationThreshold. */
                    public classificationThreshold: number;

                    /** Agent apiVersion. */
                    public apiVersion: (google.cloud.dialogflow.v2.Agent.ApiVersion|keyof typeof google.cloud.dialogflow.v2.Agent.ApiVersion);

                    /** Agent tier. */
                    public tier: (google.cloud.dialogflow.v2.Agent.Tier|keyof typeof google.cloud.dialogflow.v2.Agent.Tier);

                    /**
                     * Creates a new Agent instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Agent instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAgent): google.cloud.dialogflow.v2.Agent;

                    /**
                     * Encodes the specified Agent message. Does not implicitly {@link google.cloud.dialogflow.v2.Agent.verify|verify} messages.
                     * @param message Agent message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Agent message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Agent.verify|verify} messages.
                     * @param message Agent message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAgent, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Agent message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Agent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Agent;

                    /**
                     * Decodes an Agent message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Agent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Agent;

                    /**
                     * Verifies an Agent message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Agent message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Agent
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Agent;

                    /**
                     * Creates a plain object from an Agent message. Also converts values to other types if specified.
                     * @param message Agent
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.Agent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Agent to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace Agent {

                    /** MatchMode enum. */
                    enum MatchMode {
                        MATCH_MODE_UNSPECIFIED = 0,
                        MATCH_MODE_HYBRID = 1,
                        MATCH_MODE_ML_ONLY = 2
                    }

                    /** ApiVersion enum. */
                    enum ApiVersion {
                        API_VERSION_UNSPECIFIED = 0,
                        API_VERSION_V1 = 1,
                        API_VERSION_V2 = 2,
                        API_VERSION_V2_BETA_1 = 3
                    }

                    /** Tier enum. */
                    enum Tier {
                        TIER_UNSPECIFIED = 0,
                        TIER_STANDARD = 1,
                        TIER_ENTERPRISE = 2,
                        TIER_ENTERPRISE_PLUS = 3
                    }
                }

                /** Properties of a GetAgentRequest. */
                interface IGetAgentRequest {

                    /** GetAgentRequest parent */
                    parent?: (string|null);
                }

                /** Represents a GetAgentRequest. */
                class GetAgentRequest implements IGetAgentRequest {

                    /**
                     * Constructs a new GetAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetAgentRequest);

                    /** GetAgentRequest parent. */
                    public parent: string;

                    /**
                     * Creates a new GetAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetAgentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetAgentRequest): google.cloud.dialogflow.v2.GetAgentRequest;

                    /**
                     * Encodes the specified GetAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetAgentRequest.verify|verify} messages.
                     * @param message GetAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetAgentRequest.verify|verify} messages.
                     * @param message GetAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetAgentRequest;

                    /**
                     * Decodes a GetAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetAgentRequest;

                    /**
                     * Verifies a GetAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetAgentRequest;

                    /**
                     * Creates a plain object from a GetAgentRequest message. Also converts values to other types if specified.
                     * @param message GetAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SetAgentRequest. */
                interface ISetAgentRequest {

                    /** SetAgentRequest agent */
                    agent?: (google.cloud.dialogflow.v2.IAgent|null);

                    /** SetAgentRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents a SetAgentRequest. */
                class SetAgentRequest implements ISetAgentRequest {

                    /**
                     * Constructs a new SetAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISetAgentRequest);

                    /** SetAgentRequest agent. */
                    public agent?: (google.cloud.dialogflow.v2.IAgent|null);

                    /** SetAgentRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new SetAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SetAgentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISetAgentRequest): google.cloud.dialogflow.v2.SetAgentRequest;

                    /**
                     * Encodes the specified SetAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SetAgentRequest.verify|verify} messages.
                     * @param message SetAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISetAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SetAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SetAgentRequest.verify|verify} messages.
                     * @param message SetAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISetAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SetAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SetAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SetAgentRequest;

                    /**
                     * Decodes a SetAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SetAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SetAgentRequest;

                    /**
                     * Verifies a SetAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SetAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SetAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SetAgentRequest;

                    /**
                     * Creates a plain object from a SetAgentRequest message. Also converts values to other types if specified.
                     * @param message SetAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SetAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SetAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DeleteAgentRequest. */
                interface IDeleteAgentRequest {

                    /** DeleteAgentRequest parent */
                    parent?: (string|null);
                }

                /** Represents a DeleteAgentRequest. */
                class DeleteAgentRequest implements IDeleteAgentRequest {

                    /**
                     * Constructs a new DeleteAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDeleteAgentRequest);

                    /** DeleteAgentRequest parent. */
                    public parent: string;

                    /**
                     * Creates a new DeleteAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteAgentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDeleteAgentRequest): google.cloud.dialogflow.v2.DeleteAgentRequest;

                    /**
                     * Encodes the specified DeleteAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteAgentRequest.verify|verify} messages.
                     * @param message DeleteAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDeleteAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteAgentRequest.verify|verify} messages.
                     * @param message DeleteAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDeleteAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DeleteAgentRequest;

                    /**
                     * Decodes a DeleteAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DeleteAgentRequest;

                    /**
                     * Verifies a DeleteAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DeleteAgentRequest;

                    /**
                     * Creates a plain object from a DeleteAgentRequest message. Also converts values to other types if specified.
                     * @param message DeleteAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DeleteAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SearchAgentsRequest. */
                interface ISearchAgentsRequest {

                    /** SearchAgentsRequest parent */
                    parent?: (string|null);

                    /** SearchAgentsRequest pageSize */
                    pageSize?: (number|null);

                    /** SearchAgentsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a SearchAgentsRequest. */
                class SearchAgentsRequest implements ISearchAgentsRequest {

                    /**
                     * Constructs a new SearchAgentsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISearchAgentsRequest);

                    /** SearchAgentsRequest parent. */
                    public parent: string;

                    /** SearchAgentsRequest pageSize. */
                    public pageSize: number;

                    /** SearchAgentsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new SearchAgentsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SearchAgentsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISearchAgentsRequest): google.cloud.dialogflow.v2.SearchAgentsRequest;

                    /**
                     * Encodes the specified SearchAgentsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsRequest.verify|verify} messages.
                     * @param message SearchAgentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISearchAgentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SearchAgentsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsRequest.verify|verify} messages.
                     * @param message SearchAgentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISearchAgentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SearchAgentsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SearchAgentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SearchAgentsRequest;

                    /**
                     * Decodes a SearchAgentsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SearchAgentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SearchAgentsRequest;

                    /**
                     * Verifies a SearchAgentsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SearchAgentsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SearchAgentsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SearchAgentsRequest;

                    /**
                     * Creates a plain object from a SearchAgentsRequest message. Also converts values to other types if specified.
                     * @param message SearchAgentsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SearchAgentsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SearchAgentsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SearchAgentsResponse. */
                interface ISearchAgentsResponse {

                    /** SearchAgentsResponse agents */
                    agents?: (google.cloud.dialogflow.v2.IAgent[]|null);

                    /** SearchAgentsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a SearchAgentsResponse. */
                class SearchAgentsResponse implements ISearchAgentsResponse {

                    /**
                     * Constructs a new SearchAgentsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISearchAgentsResponse);

                    /** SearchAgentsResponse agents. */
                    public agents: google.cloud.dialogflow.v2.IAgent[];

                    /** SearchAgentsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new SearchAgentsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SearchAgentsResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISearchAgentsResponse): google.cloud.dialogflow.v2.SearchAgentsResponse;

                    /**
                     * Encodes the specified SearchAgentsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsResponse.verify|verify} messages.
                     * @param message SearchAgentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISearchAgentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SearchAgentsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsResponse.verify|verify} messages.
                     * @param message SearchAgentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISearchAgentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SearchAgentsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SearchAgentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SearchAgentsResponse;

                    /**
                     * Decodes a SearchAgentsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SearchAgentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SearchAgentsResponse;

                    /**
                     * Verifies a SearchAgentsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SearchAgentsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SearchAgentsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SearchAgentsResponse;

                    /**
                     * Creates a plain object from a SearchAgentsResponse message. Also converts values to other types if specified.
                     * @param message SearchAgentsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SearchAgentsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SearchAgentsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a TrainAgentRequest. */
                interface ITrainAgentRequest {

                    /** TrainAgentRequest parent */
                    parent?: (string|null);
                }

                /** Represents a TrainAgentRequest. */
                class TrainAgentRequest implements ITrainAgentRequest {

                    /**
                     * Constructs a new TrainAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ITrainAgentRequest);

                    /** TrainAgentRequest parent. */
                    public parent: string;

                    /**
                     * Creates a new TrainAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TrainAgentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ITrainAgentRequest): google.cloud.dialogflow.v2.TrainAgentRequest;

                    /**
                     * Encodes the specified TrainAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.TrainAgentRequest.verify|verify} messages.
                     * @param message TrainAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ITrainAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TrainAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.TrainAgentRequest.verify|verify} messages.
                     * @param message TrainAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ITrainAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TrainAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TrainAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.TrainAgentRequest;

                    /**
                     * Decodes a TrainAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TrainAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.TrainAgentRequest;

                    /**
                     * Verifies a TrainAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TrainAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TrainAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.TrainAgentRequest;

                    /**
                     * Creates a plain object from a TrainAgentRequest message. Also converts values to other types if specified.
                     * @param message TrainAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.TrainAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TrainAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an ExportAgentRequest. */
                interface IExportAgentRequest {

                    /** ExportAgentRequest parent */
                    parent?: (string|null);

                    /** ExportAgentRequest agentUri */
                    agentUri?: (string|null);
                }

                /** Represents an ExportAgentRequest. */
                class ExportAgentRequest implements IExportAgentRequest {

                    /**
                     * Constructs a new ExportAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IExportAgentRequest);

                    /** ExportAgentRequest parent. */
                    public parent: string;

                    /** ExportAgentRequest agentUri. */
                    public agentUri: string;

                    /**
                     * Creates a new ExportAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ExportAgentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IExportAgentRequest): google.cloud.dialogflow.v2.ExportAgentRequest;

                    /**
                     * Encodes the specified ExportAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentRequest.verify|verify} messages.
                     * @param message ExportAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IExportAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ExportAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentRequest.verify|verify} messages.
                     * @param message ExportAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IExportAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ExportAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ExportAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ExportAgentRequest;

                    /**
                     * Decodes an ExportAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ExportAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ExportAgentRequest;

                    /**
                     * Verifies an ExportAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ExportAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ExportAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ExportAgentRequest;

                    /**
                     * Creates a plain object from an ExportAgentRequest message. Also converts values to other types if specified.
                     * @param message ExportAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ExportAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ExportAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an ExportAgentResponse. */
                interface IExportAgentResponse {

                    /** ExportAgentResponse agentUri */
                    agentUri?: (string|null);

                    /** ExportAgentResponse agentContent */
                    agentContent?: (Uint8Array|string|null);
                }

                /** Represents an ExportAgentResponse. */
                class ExportAgentResponse implements IExportAgentResponse {

                    /**
                     * Constructs a new ExportAgentResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IExportAgentResponse);

                    /** ExportAgentResponse agentUri. */
                    public agentUri?: (string|null);

                    /** ExportAgentResponse agentContent. */
                    public agentContent?: (Uint8Array|string|null);

                    /** ExportAgentResponse agent. */
                    public agent?: ("agentUri"|"agentContent");

                    /**
                     * Creates a new ExportAgentResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ExportAgentResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IExportAgentResponse): google.cloud.dialogflow.v2.ExportAgentResponse;

                    /**
                     * Encodes the specified ExportAgentResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentResponse.verify|verify} messages.
                     * @param message ExportAgentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IExportAgentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ExportAgentResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentResponse.verify|verify} messages.
                     * @param message ExportAgentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IExportAgentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ExportAgentResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ExportAgentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ExportAgentResponse;

                    /**
                     * Decodes an ExportAgentResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ExportAgentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ExportAgentResponse;

                    /**
                     * Verifies an ExportAgentResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ExportAgentResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ExportAgentResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ExportAgentResponse;

                    /**
                     * Creates a plain object from an ExportAgentResponse message. Also converts values to other types if specified.
                     * @param message ExportAgentResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ExportAgentResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ExportAgentResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an ImportAgentRequest. */
                interface IImportAgentRequest {

                    /** ImportAgentRequest parent */
                    parent?: (string|null);

                    /** ImportAgentRequest agentUri */
                    agentUri?: (string|null);

                    /** ImportAgentRequest agentContent */
                    agentContent?: (Uint8Array|string|null);
                }

                /** Represents an ImportAgentRequest. */
                class ImportAgentRequest implements IImportAgentRequest {

                    /**
                     * Constructs a new ImportAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IImportAgentRequest);

                    /** ImportAgentRequest parent. */
                    public parent: string;

                    /** ImportAgentRequest agentUri. */
                    public agentUri?: (string|null);

                    /** ImportAgentRequest agentContent. */
                    public agentContent?: (Uint8Array|string|null);

                    /** ImportAgentRequest agent. */
                    public agent?: ("agentUri"|"agentContent");

                    /**
                     * Creates a new ImportAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ImportAgentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IImportAgentRequest): google.cloud.dialogflow.v2.ImportAgentRequest;

                    /**
                     * Encodes the specified ImportAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ImportAgentRequest.verify|verify} messages.
                     * @param message ImportAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IImportAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ImportAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ImportAgentRequest.verify|verify} messages.
                     * @param message ImportAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IImportAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ImportAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ImportAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ImportAgentRequest;

                    /**
                     * Decodes an ImportAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ImportAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ImportAgentRequest;

                    /**
                     * Verifies an ImportAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ImportAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ImportAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ImportAgentRequest;

                    /**
                     * Creates a plain object from an ImportAgentRequest message. Also converts values to other types if specified.
                     * @param message ImportAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ImportAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ImportAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a RestoreAgentRequest. */
                interface IRestoreAgentRequest {

                    /** RestoreAgentRequest parent */
                    parent?: (string|null);

                    /** RestoreAgentRequest agentUri */
                    agentUri?: (string|null);

                    /** RestoreAgentRequest agentContent */
                    agentContent?: (Uint8Array|string|null);
                }

                /** Represents a RestoreAgentRequest. */
                class RestoreAgentRequest implements IRestoreAgentRequest {

                    /**
                     * Constructs a new RestoreAgentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IRestoreAgentRequest);

                    /** RestoreAgentRequest parent. */
                    public parent: string;

                    /** RestoreAgentRequest agentUri. */
                    public agentUri?: (string|null);

                    /** RestoreAgentRequest agentContent. */
                    public agentContent?: (Uint8Array|string|null);

                    /** RestoreAgentRequest agent. */
                    public agent?: ("agentUri"|"agentContent");

                    /**
                     * Creates a new RestoreAgentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns RestoreAgentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IRestoreAgentRequest): google.cloud.dialogflow.v2.RestoreAgentRequest;

                    /**
                     * Encodes the specified RestoreAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.RestoreAgentRequest.verify|verify} messages.
                     * @param message RestoreAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IRestoreAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified RestoreAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.RestoreAgentRequest.verify|verify} messages.
                     * @param message RestoreAgentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IRestoreAgentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a RestoreAgentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns RestoreAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.RestoreAgentRequest;

                    /**
                     * Decodes a RestoreAgentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns RestoreAgentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.RestoreAgentRequest;

                    /**
                     * Verifies a RestoreAgentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a RestoreAgentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns RestoreAgentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.RestoreAgentRequest;

                    /**
                     * Creates a plain object from a RestoreAgentRequest message. Also converts values to other types if specified.
                     * @param message RestoreAgentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.RestoreAgentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this RestoreAgentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetValidationResultRequest. */
                interface IGetValidationResultRequest {

                    /** GetValidationResultRequest parent */
                    parent?: (string|null);

                    /** GetValidationResultRequest languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a GetValidationResultRequest. */
                class GetValidationResultRequest implements IGetValidationResultRequest {

                    /**
                     * Constructs a new GetValidationResultRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetValidationResultRequest);

                    /** GetValidationResultRequest parent. */
                    public parent: string;

                    /** GetValidationResultRequest languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new GetValidationResultRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetValidationResultRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetValidationResultRequest): google.cloud.dialogflow.v2.GetValidationResultRequest;

                    /**
                     * Encodes the specified GetValidationResultRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetValidationResultRequest.verify|verify} messages.
                     * @param message GetValidationResultRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetValidationResultRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetValidationResultRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetValidationResultRequest.verify|verify} messages.
                     * @param message GetValidationResultRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetValidationResultRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetValidationResultRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetValidationResultRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetValidationResultRequest;

                    /**
                     * Decodes a GetValidationResultRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetValidationResultRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetValidationResultRequest;

                    /**
                     * Verifies a GetValidationResultRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetValidationResultRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetValidationResultRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetValidationResultRequest;

                    /**
                     * Creates a plain object from a GetValidationResultRequest message. Also converts values to other types if specified.
                     * @param message GetValidationResultRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetValidationResultRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetValidationResultRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ValidationError. */
                interface IValidationError {

                    /** ValidationError severity */
                    severity?: (google.cloud.dialogflow.v2.ValidationError.Severity|keyof typeof google.cloud.dialogflow.v2.ValidationError.Severity|null);

                    /** ValidationError entries */
                    entries?: (string[]|null);

                    /** ValidationError errorMessage */
                    errorMessage?: (string|null);
                }

                /** Represents a ValidationError. */
                class ValidationError implements IValidationError {

                    /**
                     * Constructs a new ValidationError.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IValidationError);

                    /** ValidationError severity. */
                    public severity: (google.cloud.dialogflow.v2.ValidationError.Severity|keyof typeof google.cloud.dialogflow.v2.ValidationError.Severity);

                    /** ValidationError entries. */
                    public entries: string[];

                    /** ValidationError errorMessage. */
                    public errorMessage: string;

                    /**
                     * Creates a new ValidationError instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ValidationError instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IValidationError): google.cloud.dialogflow.v2.ValidationError;

                    /**
                     * Encodes the specified ValidationError message. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationError.verify|verify} messages.
                     * @param message ValidationError message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IValidationError, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ValidationError message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationError.verify|verify} messages.
                     * @param message ValidationError message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IValidationError, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ValidationError message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ValidationError
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ValidationError;

                    /**
                     * Decodes a ValidationError message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ValidationError
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ValidationError;

                    /**
                     * Verifies a ValidationError message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ValidationError message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ValidationError
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ValidationError;

                    /**
                     * Creates a plain object from a ValidationError message. Also converts values to other types if specified.
                     * @param message ValidationError
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ValidationError, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ValidationError to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace ValidationError {

                    /** Severity enum. */
                    enum Severity {
                        SEVERITY_UNSPECIFIED = 0,
                        INFO = 1,
                        WARNING = 2,
                        ERROR = 3,
                        CRITICAL = 4
                    }
                }

                /** Properties of a ValidationResult. */
                interface IValidationResult {

                    /** ValidationResult validationErrors */
                    validationErrors?: (google.cloud.dialogflow.v2.IValidationError[]|null);
                }

                /** Represents a ValidationResult. */
                class ValidationResult implements IValidationResult {

                    /**
                     * Constructs a new ValidationResult.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IValidationResult);

                    /** ValidationResult validationErrors. */
                    public validationErrors: google.cloud.dialogflow.v2.IValidationError[];

                    /**
                     * Creates a new ValidationResult instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ValidationResult instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IValidationResult): google.cloud.dialogflow.v2.ValidationResult;

                    /**
                     * Encodes the specified ValidationResult message. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationResult.verify|verify} messages.
                     * @param message ValidationResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IValidationResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ValidationResult message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationResult.verify|verify} messages.
                     * @param message ValidationResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IValidationResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ValidationResult message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ValidationResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ValidationResult;

                    /**
                     * Decodes a ValidationResult message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ValidationResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ValidationResult;

                    /**
                     * Verifies a ValidationResult message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ValidationResult message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ValidationResult
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ValidationResult;

                    /**
                     * Creates a plain object from a ValidationResult message. Also converts values to other types if specified.
                     * @param message ValidationResult
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ValidationResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ValidationResult to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents an AnswerRecords */
                class AnswerRecords extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new AnswerRecords service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new AnswerRecords service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): AnswerRecords;

                    /**
                     * Calls ListAnswerRecords.
                     * @param request ListAnswerRecordsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListAnswerRecordsResponse
                     */
                    public listAnswerRecords(request: google.cloud.dialogflow.v2.IListAnswerRecordsRequest, callback: google.cloud.dialogflow.v2.AnswerRecords.ListAnswerRecordsCallback): void;

                    /**
                     * Calls ListAnswerRecords.
                     * @param request ListAnswerRecordsRequest message or plain object
                     * @returns Promise
                     */
                    public listAnswerRecords(request: google.cloud.dialogflow.v2.IListAnswerRecordsRequest): Promise<google.cloud.dialogflow.v2.ListAnswerRecordsResponse>;

                    /**
                     * Calls UpdateAnswerRecord.
                     * @param request UpdateAnswerRecordRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and AnswerRecord
                     */
                    public updateAnswerRecord(request: google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest, callback: google.cloud.dialogflow.v2.AnswerRecords.UpdateAnswerRecordCallback): void;

                    /**
                     * Calls UpdateAnswerRecord.
                     * @param request UpdateAnswerRecordRequest message or plain object
                     * @returns Promise
                     */
                    public updateAnswerRecord(request: google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest): Promise<google.cloud.dialogflow.v2.AnswerRecord>;
                }

                namespace AnswerRecords {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.AnswerRecords#listAnswerRecords}.
                     * @param error Error, if any
                     * @param [response] ListAnswerRecordsResponse
                     */
                    type ListAnswerRecordsCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListAnswerRecordsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.AnswerRecords#updateAnswerRecord}.
                     * @param error Error, if any
                     * @param [response] AnswerRecord
                     */
                    type UpdateAnswerRecordCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.AnswerRecord) => void;
                }

                /** Properties of an AnswerRecord. */
                interface IAnswerRecord {

                    /** AnswerRecord name */
                    name?: (string|null);

                    /** AnswerRecord answerFeedback */
                    answerFeedback?: (google.cloud.dialogflow.v2.IAnswerFeedback|null);

                    /** AnswerRecord agentAssistantRecord */
                    agentAssistantRecord?: (google.cloud.dialogflow.v2.IAgentAssistantRecord|null);
                }

                /** Represents an AnswerRecord. */
                class AnswerRecord implements IAnswerRecord {

                    /**
                     * Constructs a new AnswerRecord.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAnswerRecord);

                    /** AnswerRecord name. */
                    public name: string;

                    /** AnswerRecord answerFeedback. */
                    public answerFeedback?: (google.cloud.dialogflow.v2.IAnswerFeedback|null);

                    /** AnswerRecord agentAssistantRecord. */
                    public agentAssistantRecord?: (google.cloud.dialogflow.v2.IAgentAssistantRecord|null);

                    /** AnswerRecord record. */
                    public record?: "agentAssistantRecord";

                    /**
                     * Creates a new AnswerRecord instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnswerRecord instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAnswerRecord): google.cloud.dialogflow.v2.AnswerRecord;

                    /**
                     * Encodes the specified AnswerRecord message. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerRecord.verify|verify} messages.
                     * @param message AnswerRecord message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAnswerRecord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnswerRecord message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerRecord.verify|verify} messages.
                     * @param message AnswerRecord message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAnswerRecord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnswerRecord message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnswerRecord
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AnswerRecord;

                    /**
                     * Decodes an AnswerRecord message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnswerRecord
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AnswerRecord;

                    /**
                     * Verifies an AnswerRecord message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnswerRecord message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnswerRecord
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AnswerRecord;

                    /**
                     * Creates a plain object from an AnswerRecord message. Also converts values to other types if specified.
                     * @param message AnswerRecord
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AnswerRecord, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnswerRecord to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListAnswerRecordsRequest. */
                interface IListAnswerRecordsRequest {

                    /** ListAnswerRecordsRequest parent */
                    parent?: (string|null);

                    /** ListAnswerRecordsRequest filter */
                    filter?: (string|null);

                    /** ListAnswerRecordsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListAnswerRecordsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListAnswerRecordsRequest. */
                class ListAnswerRecordsRequest implements IListAnswerRecordsRequest {

                    /**
                     * Constructs a new ListAnswerRecordsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListAnswerRecordsRequest);

                    /** ListAnswerRecordsRequest parent. */
                    public parent: string;

                    /** ListAnswerRecordsRequest filter. */
                    public filter: string;

                    /** ListAnswerRecordsRequest pageSize. */
                    public pageSize: number;

                    /** ListAnswerRecordsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListAnswerRecordsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAnswerRecordsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListAnswerRecordsRequest): google.cloud.dialogflow.v2.ListAnswerRecordsRequest;

                    /**
                     * Encodes the specified ListAnswerRecordsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsRequest.verify|verify} messages.
                     * @param message ListAnswerRecordsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListAnswerRecordsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAnswerRecordsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsRequest.verify|verify} messages.
                     * @param message ListAnswerRecordsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListAnswerRecordsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAnswerRecordsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAnswerRecordsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListAnswerRecordsRequest;

                    /**
                     * Decodes a ListAnswerRecordsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAnswerRecordsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListAnswerRecordsRequest;

                    /**
                     * Verifies a ListAnswerRecordsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAnswerRecordsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAnswerRecordsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListAnswerRecordsRequest;

                    /**
                     * Creates a plain object from a ListAnswerRecordsRequest message. Also converts values to other types if specified.
                     * @param message ListAnswerRecordsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListAnswerRecordsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAnswerRecordsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListAnswerRecordsResponse. */
                interface IListAnswerRecordsResponse {

                    /** ListAnswerRecordsResponse answerRecords */
                    answerRecords?: (google.cloud.dialogflow.v2.IAnswerRecord[]|null);

                    /** ListAnswerRecordsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListAnswerRecordsResponse. */
                class ListAnswerRecordsResponse implements IListAnswerRecordsResponse {

                    /**
                     * Constructs a new ListAnswerRecordsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListAnswerRecordsResponse);

                    /** ListAnswerRecordsResponse answerRecords. */
                    public answerRecords: google.cloud.dialogflow.v2.IAnswerRecord[];

                    /** ListAnswerRecordsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListAnswerRecordsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListAnswerRecordsResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListAnswerRecordsResponse): google.cloud.dialogflow.v2.ListAnswerRecordsResponse;

                    /**
                     * Encodes the specified ListAnswerRecordsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsResponse.verify|verify} messages.
                     * @param message ListAnswerRecordsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListAnswerRecordsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListAnswerRecordsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsResponse.verify|verify} messages.
                     * @param message ListAnswerRecordsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListAnswerRecordsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListAnswerRecordsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListAnswerRecordsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListAnswerRecordsResponse;

                    /**
                     * Decodes a ListAnswerRecordsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListAnswerRecordsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListAnswerRecordsResponse;

                    /**
                     * Verifies a ListAnswerRecordsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListAnswerRecordsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListAnswerRecordsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListAnswerRecordsResponse;

                    /**
                     * Creates a plain object from a ListAnswerRecordsResponse message. Also converts values to other types if specified.
                     * @param message ListAnswerRecordsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListAnswerRecordsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListAnswerRecordsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an UpdateAnswerRecordRequest. */
                interface IUpdateAnswerRecordRequest {

                    /** UpdateAnswerRecordRequest answerRecord */
                    answerRecord?: (google.cloud.dialogflow.v2.IAnswerRecord|null);

                    /** UpdateAnswerRecordRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateAnswerRecordRequest. */
                class UpdateAnswerRecordRequest implements IUpdateAnswerRecordRequest {

                    /**
                     * Constructs a new UpdateAnswerRecordRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest);

                    /** UpdateAnswerRecordRequest answerRecord. */
                    public answerRecord?: (google.cloud.dialogflow.v2.IAnswerRecord|null);

                    /** UpdateAnswerRecordRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateAnswerRecordRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateAnswerRecordRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest): google.cloud.dialogflow.v2.UpdateAnswerRecordRequest;

                    /**
                     * Encodes the specified UpdateAnswerRecordRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.verify|verify} messages.
                     * @param message UpdateAnswerRecordRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateAnswerRecordRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.verify|verify} messages.
                     * @param message UpdateAnswerRecordRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateAnswerRecordRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateAnswerRecordRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.UpdateAnswerRecordRequest;

                    /**
                     * Decodes an UpdateAnswerRecordRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateAnswerRecordRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.UpdateAnswerRecordRequest;

                    /**
                     * Verifies an UpdateAnswerRecordRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateAnswerRecordRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateAnswerRecordRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.UpdateAnswerRecordRequest;

                    /**
                     * Creates a plain object from an UpdateAnswerRecordRequest message. Also converts values to other types if specified.
                     * @param message UpdateAnswerRecordRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.UpdateAnswerRecordRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateAnswerRecordRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an AnswerFeedback. */
                interface IAnswerFeedback {

                    /** AnswerFeedback correctnessLevel */
                    correctnessLevel?: (google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel|keyof typeof google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel|null);

                    /** AnswerFeedback agentAssistantDetailFeedback */
                    agentAssistantDetailFeedback?: (google.cloud.dialogflow.v2.IAgentAssistantFeedback|null);

                    /** AnswerFeedback clicked */
                    clicked?: (boolean|null);

                    /** AnswerFeedback clickTime */
                    clickTime?: (google.protobuf.ITimestamp|null);

                    /** AnswerFeedback displayed */
                    displayed?: (boolean|null);

                    /** AnswerFeedback displayTime */
                    displayTime?: (google.protobuf.ITimestamp|null);
                }

                /** Represents an AnswerFeedback. */
                class AnswerFeedback implements IAnswerFeedback {

                    /**
                     * Constructs a new AnswerFeedback.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAnswerFeedback);

                    /** AnswerFeedback correctnessLevel. */
                    public correctnessLevel: (google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel|keyof typeof google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel);

                    /** AnswerFeedback agentAssistantDetailFeedback. */
                    public agentAssistantDetailFeedback?: (google.cloud.dialogflow.v2.IAgentAssistantFeedback|null);

                    /** AnswerFeedback clicked. */
                    public clicked: boolean;

                    /** AnswerFeedback clickTime. */
                    public clickTime?: (google.protobuf.ITimestamp|null);

                    /** AnswerFeedback displayed. */
                    public displayed: boolean;

                    /** AnswerFeedback displayTime. */
                    public displayTime?: (google.protobuf.ITimestamp|null);

                    /** AnswerFeedback detailFeedback. */
                    public detailFeedback?: "agentAssistantDetailFeedback";

                    /**
                     * Creates a new AnswerFeedback instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnswerFeedback instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAnswerFeedback): google.cloud.dialogflow.v2.AnswerFeedback;

                    /**
                     * Encodes the specified AnswerFeedback message. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerFeedback.verify|verify} messages.
                     * @param message AnswerFeedback message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAnswerFeedback, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnswerFeedback message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerFeedback.verify|verify} messages.
                     * @param message AnswerFeedback message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAnswerFeedback, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnswerFeedback message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnswerFeedback
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AnswerFeedback;

                    /**
                     * Decodes an AnswerFeedback message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnswerFeedback
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AnswerFeedback;

                    /**
                     * Verifies an AnswerFeedback message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnswerFeedback message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnswerFeedback
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AnswerFeedback;

                    /**
                     * Creates a plain object from an AnswerFeedback message. Also converts values to other types if specified.
                     * @param message AnswerFeedback
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AnswerFeedback, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnswerFeedback to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace AnswerFeedback {

                    /** CorrectnessLevel enum. */
                    enum CorrectnessLevel {
                        CORRECTNESS_LEVEL_UNSPECIFIED = 0,
                        NOT_CORRECT = 1,
                        PARTIALLY_CORRECT = 2,
                        FULLY_CORRECT = 3
                    }
                }

                /** Properties of an AgentAssistantFeedback. */
                interface IAgentAssistantFeedback {

                    /** AgentAssistantFeedback answerRelevance */
                    answerRelevance?: (google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance|keyof typeof google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance|null);

                    /** AgentAssistantFeedback documentCorrectness */
                    documentCorrectness?: (google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness|keyof typeof google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness|null);

                    /** AgentAssistantFeedback documentEfficiency */
                    documentEfficiency?: (google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency|keyof typeof google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency|null);
                }

                /** Represents an AgentAssistantFeedback. */
                class AgentAssistantFeedback implements IAgentAssistantFeedback {

                    /**
                     * Constructs a new AgentAssistantFeedback.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAgentAssistantFeedback);

                    /** AgentAssistantFeedback answerRelevance. */
                    public answerRelevance: (google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance|keyof typeof google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance);

                    /** AgentAssistantFeedback documentCorrectness. */
                    public documentCorrectness: (google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness|keyof typeof google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness);

                    /** AgentAssistantFeedback documentEfficiency. */
                    public documentEfficiency: (google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency|keyof typeof google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency);

                    /**
                     * Creates a new AgentAssistantFeedback instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AgentAssistantFeedback instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAgentAssistantFeedback): google.cloud.dialogflow.v2.AgentAssistantFeedback;

                    /**
                     * Encodes the specified AgentAssistantFeedback message. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantFeedback.verify|verify} messages.
                     * @param message AgentAssistantFeedback message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAgentAssistantFeedback, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AgentAssistantFeedback message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantFeedback.verify|verify} messages.
                     * @param message AgentAssistantFeedback message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAgentAssistantFeedback, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AgentAssistantFeedback message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AgentAssistantFeedback
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AgentAssistantFeedback;

                    /**
                     * Decodes an AgentAssistantFeedback message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AgentAssistantFeedback
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AgentAssistantFeedback;

                    /**
                     * Verifies an AgentAssistantFeedback message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AgentAssistantFeedback message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AgentAssistantFeedback
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AgentAssistantFeedback;

                    /**
                     * Creates a plain object from an AgentAssistantFeedback message. Also converts values to other types if specified.
                     * @param message AgentAssistantFeedback
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AgentAssistantFeedback, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AgentAssistantFeedback to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace AgentAssistantFeedback {

                    /** AnswerRelevance enum. */
                    enum AnswerRelevance {
                        ANSWER_RELEVANCE_UNSPECIFIED = 0,
                        IRRELEVANT = 1,
                        RELEVANT = 2
                    }

                    /** DocumentCorrectness enum. */
                    enum DocumentCorrectness {
                        DOCUMENT_CORRECTNESS_UNSPECIFIED = 0,
                        INCORRECT = 1,
                        CORRECT = 2
                    }

                    /** DocumentEfficiency enum. */
                    enum DocumentEfficiency {
                        DOCUMENT_EFFICIENCY_UNSPECIFIED = 0,
                        INEFFICIENT = 1,
                        EFFICIENT = 2
                    }
                }

                /** Properties of an AgentAssistantRecord. */
                interface IAgentAssistantRecord {

                    /** AgentAssistantRecord articleSuggestionAnswer */
                    articleSuggestionAnswer?: (google.cloud.dialogflow.v2.IArticleAnswer|null);

                    /** AgentAssistantRecord faqAnswer */
                    faqAnswer?: (google.cloud.dialogflow.v2.IFaqAnswer|null);
                }

                /** Represents an AgentAssistantRecord. */
                class AgentAssistantRecord implements IAgentAssistantRecord {

                    /**
                     * Constructs a new AgentAssistantRecord.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAgentAssistantRecord);

                    /** AgentAssistantRecord articleSuggestionAnswer. */
                    public articleSuggestionAnswer?: (google.cloud.dialogflow.v2.IArticleAnswer|null);

                    /** AgentAssistantRecord faqAnswer. */
                    public faqAnswer?: (google.cloud.dialogflow.v2.IFaqAnswer|null);

                    /** AgentAssistantRecord answer. */
                    public answer?: ("articleSuggestionAnswer"|"faqAnswer");

                    /**
                     * Creates a new AgentAssistantRecord instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AgentAssistantRecord instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAgentAssistantRecord): google.cloud.dialogflow.v2.AgentAssistantRecord;

                    /**
                     * Encodes the specified AgentAssistantRecord message. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantRecord.verify|verify} messages.
                     * @param message AgentAssistantRecord message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAgentAssistantRecord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AgentAssistantRecord message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantRecord.verify|verify} messages.
                     * @param message AgentAssistantRecord message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAgentAssistantRecord, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AgentAssistantRecord message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AgentAssistantRecord
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AgentAssistantRecord;

                    /**
                     * Decodes an AgentAssistantRecord message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AgentAssistantRecord
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AgentAssistantRecord;

                    /**
                     * Verifies an AgentAssistantRecord message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AgentAssistantRecord message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AgentAssistantRecord
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AgentAssistantRecord;

                    /**
                     * Creates a plain object from an AgentAssistantRecord message. Also converts values to other types if specified.
                     * @param message AgentAssistantRecord
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AgentAssistantRecord, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AgentAssistantRecord to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents a Participants */
                class Participants extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new Participants service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new Participants service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Participants;

                    /**
                     * Calls CreateParticipant.
                     * @param request CreateParticipantRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Participant
                     */
                    public createParticipant(request: google.cloud.dialogflow.v2.ICreateParticipantRequest, callback: google.cloud.dialogflow.v2.Participants.CreateParticipantCallback): void;

                    /**
                     * Calls CreateParticipant.
                     * @param request CreateParticipantRequest message or plain object
                     * @returns Promise
                     */
                    public createParticipant(request: google.cloud.dialogflow.v2.ICreateParticipantRequest): Promise<google.cloud.dialogflow.v2.Participant>;

                    /**
                     * Calls GetParticipant.
                     * @param request GetParticipantRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Participant
                     */
                    public getParticipant(request: google.cloud.dialogflow.v2.IGetParticipantRequest, callback: google.cloud.dialogflow.v2.Participants.GetParticipantCallback): void;

                    /**
                     * Calls GetParticipant.
                     * @param request GetParticipantRequest message or plain object
                     * @returns Promise
                     */
                    public getParticipant(request: google.cloud.dialogflow.v2.IGetParticipantRequest): Promise<google.cloud.dialogflow.v2.Participant>;

                    /**
                     * Calls ListParticipants.
                     * @param request ListParticipantsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListParticipantsResponse
                     */
                    public listParticipants(request: google.cloud.dialogflow.v2.IListParticipantsRequest, callback: google.cloud.dialogflow.v2.Participants.ListParticipantsCallback): void;

                    /**
                     * Calls ListParticipants.
                     * @param request ListParticipantsRequest message or plain object
                     * @returns Promise
                     */
                    public listParticipants(request: google.cloud.dialogflow.v2.IListParticipantsRequest): Promise<google.cloud.dialogflow.v2.ListParticipantsResponse>;

                    /**
                     * Calls UpdateParticipant.
                     * @param request UpdateParticipantRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Participant
                     */
                    public updateParticipant(request: google.cloud.dialogflow.v2.IUpdateParticipantRequest, callback: google.cloud.dialogflow.v2.Participants.UpdateParticipantCallback): void;

                    /**
                     * Calls UpdateParticipant.
                     * @param request UpdateParticipantRequest message or plain object
                     * @returns Promise
                     */
                    public updateParticipant(request: google.cloud.dialogflow.v2.IUpdateParticipantRequest): Promise<google.cloud.dialogflow.v2.Participant>;

                    /**
                     * Calls AnalyzeContent.
                     * @param request AnalyzeContentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and AnalyzeContentResponse
                     */
                    public analyzeContent(request: google.cloud.dialogflow.v2.IAnalyzeContentRequest, callback: google.cloud.dialogflow.v2.Participants.AnalyzeContentCallback): void;

                    /**
                     * Calls AnalyzeContent.
                     * @param request AnalyzeContentRequest message or plain object
                     * @returns Promise
                     */
                    public analyzeContent(request: google.cloud.dialogflow.v2.IAnalyzeContentRequest): Promise<google.cloud.dialogflow.v2.AnalyzeContentResponse>;

                    /**
                     * Calls SuggestArticles.
                     * @param request SuggestArticlesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and SuggestArticlesResponse
                     */
                    public suggestArticles(request: google.cloud.dialogflow.v2.ISuggestArticlesRequest, callback: google.cloud.dialogflow.v2.Participants.SuggestArticlesCallback): void;

                    /**
                     * Calls SuggestArticles.
                     * @param request SuggestArticlesRequest message or plain object
                     * @returns Promise
                     */
                    public suggestArticles(request: google.cloud.dialogflow.v2.ISuggestArticlesRequest): Promise<google.cloud.dialogflow.v2.SuggestArticlesResponse>;

                    /**
                     * Calls SuggestFaqAnswers.
                     * @param request SuggestFaqAnswersRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and SuggestFaqAnswersResponse
                     */
                    public suggestFaqAnswers(request: google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest, callback: google.cloud.dialogflow.v2.Participants.SuggestFaqAnswersCallback): void;

                    /**
                     * Calls SuggestFaqAnswers.
                     * @param request SuggestFaqAnswersRequest message or plain object
                     * @returns Promise
                     */
                    public suggestFaqAnswers(request: google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest): Promise<google.cloud.dialogflow.v2.SuggestFaqAnswersResponse>;

                    /**
                     * Calls SuggestSmartReplies.
                     * @param request SuggestSmartRepliesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and SuggestSmartRepliesResponse
                     */
                    public suggestSmartReplies(request: google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest, callback: google.cloud.dialogflow.v2.Participants.SuggestSmartRepliesCallback): void;

                    /**
                     * Calls SuggestSmartReplies.
                     * @param request SuggestSmartRepliesRequest message or plain object
                     * @returns Promise
                     */
                    public suggestSmartReplies(request: google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest): Promise<google.cloud.dialogflow.v2.SuggestSmartRepliesResponse>;
                }

                namespace Participants {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#createParticipant}.
                     * @param error Error, if any
                     * @param [response] Participant
                     */
                    type CreateParticipantCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Participant) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#getParticipant}.
                     * @param error Error, if any
                     * @param [response] Participant
                     */
                    type GetParticipantCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Participant) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#listParticipants}.
                     * @param error Error, if any
                     * @param [response] ListParticipantsResponse
                     */
                    type ListParticipantsCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListParticipantsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#updateParticipant}.
                     * @param error Error, if any
                     * @param [response] Participant
                     */
                    type UpdateParticipantCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Participant) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#analyzeContent}.
                     * @param error Error, if any
                     * @param [response] AnalyzeContentResponse
                     */
                    type AnalyzeContentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.AnalyzeContentResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#suggestArticles}.
                     * @param error Error, if any
                     * @param [response] SuggestArticlesResponse
                     */
                    type SuggestArticlesCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.SuggestArticlesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#suggestFaqAnswers}.
                     * @param error Error, if any
                     * @param [response] SuggestFaqAnswersResponse
                     */
                    type SuggestFaqAnswersCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.SuggestFaqAnswersResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Participants#suggestSmartReplies}.
                     * @param error Error, if any
                     * @param [response] SuggestSmartRepliesResponse
                     */
                    type SuggestSmartRepliesCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.SuggestSmartRepliesResponse) => void;
                }

                /** Properties of a Participant. */
                interface IParticipant {

                    /** Participant name */
                    name?: (string|null);

                    /** Participant role */
                    role?: (google.cloud.dialogflow.v2.Participant.Role|keyof typeof google.cloud.dialogflow.v2.Participant.Role|null);

                    /** Participant sipRecordingMediaLabel */
                    sipRecordingMediaLabel?: (string|null);

                    /** Participant documentsMetadataFilters */
                    documentsMetadataFilters?: ({ [k: string]: string }|null);
                }

                /** Represents a Participant. */
                class Participant implements IParticipant {

                    /**
                     * Constructs a new Participant.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IParticipant);

                    /** Participant name. */
                    public name: string;

                    /** Participant role. */
                    public role: (google.cloud.dialogflow.v2.Participant.Role|keyof typeof google.cloud.dialogflow.v2.Participant.Role);

                    /** Participant sipRecordingMediaLabel. */
                    public sipRecordingMediaLabel: string;

                    /** Participant documentsMetadataFilters. */
                    public documentsMetadataFilters: { [k: string]: string };

                    /**
                     * Creates a new Participant instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Participant instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IParticipant): google.cloud.dialogflow.v2.Participant;

                    /**
                     * Encodes the specified Participant message. Does not implicitly {@link google.cloud.dialogflow.v2.Participant.verify|verify} messages.
                     * @param message Participant message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Participant message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Participant.verify|verify} messages.
                     * @param message Participant message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Participant message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Participant
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Participant;

                    /**
                     * Decodes a Participant message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Participant
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Participant;

                    /**
                     * Verifies a Participant message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Participant message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Participant
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Participant;

                    /**
                     * Creates a plain object from a Participant message. Also converts values to other types if specified.
                     * @param message Participant
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.Participant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Participant to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace Participant {

                    /** Role enum. */
                    enum Role {
                        ROLE_UNSPECIFIED = 0,
                        HUMAN_AGENT = 1,
                        AUTOMATED_AGENT = 2,
                        END_USER = 3
                    }
                }

                /** Properties of a Message. */
                interface IMessage {

                    /** Message name */
                    name?: (string|null);

                    /** Message content */
                    content?: (string|null);

                    /** Message languageCode */
                    languageCode?: (string|null);

                    /** Message participant */
                    participant?: (string|null);

                    /** Message participantRole */
                    participantRole?: (google.cloud.dialogflow.v2.Participant.Role|keyof typeof google.cloud.dialogflow.v2.Participant.Role|null);

                    /** Message createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** Message sendTime */
                    sendTime?: (google.protobuf.ITimestamp|null);

                    /** Message messageAnnotation */
                    messageAnnotation?: (google.cloud.dialogflow.v2.IMessageAnnotation|null);

                    /** Message sentimentAnalysis */
                    sentimentAnalysis?: (google.cloud.dialogflow.v2.ISentimentAnalysisResult|null);
                }

                /** Represents a Message. */
                class Message implements IMessage {

                    /**
                     * Constructs a new Message.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IMessage);

                    /** Message name. */
                    public name: string;

                    /** Message content. */
                    public content: string;

                    /** Message languageCode. */
                    public languageCode: string;

                    /** Message participant. */
                    public participant: string;

                    /** Message participantRole. */
                    public participantRole: (google.cloud.dialogflow.v2.Participant.Role|keyof typeof google.cloud.dialogflow.v2.Participant.Role);

                    /** Message createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** Message sendTime. */
                    public sendTime?: (google.protobuf.ITimestamp|null);

                    /** Message messageAnnotation. */
                    public messageAnnotation?: (google.cloud.dialogflow.v2.IMessageAnnotation|null);

                    /** Message sentimentAnalysis. */
                    public sentimentAnalysis?: (google.cloud.dialogflow.v2.ISentimentAnalysisResult|null);

                    /**
                     * Creates a new Message instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Message instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IMessage): google.cloud.dialogflow.v2.Message;

                    /**
                     * Encodes the specified Message message. Does not implicitly {@link google.cloud.dialogflow.v2.Message.verify|verify} messages.
                     * @param message Message message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Message message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Message.verify|verify} messages.
                     * @param message Message message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Message message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Message
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Message;

                    /**
                     * Decodes a Message message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Message
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Message;

                    /**
                     * Verifies a Message message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Message message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Message
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Message;

                    /**
                     * Creates a plain object from a Message message. Also converts values to other types if specified.
                     * @param message Message
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.Message, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Message to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a CreateParticipantRequest. */
                interface ICreateParticipantRequest {

                    /** CreateParticipantRequest parent */
                    parent?: (string|null);

                    /** CreateParticipantRequest participant */
                    participant?: (google.cloud.dialogflow.v2.IParticipant|null);
                }

                /** Represents a CreateParticipantRequest. */
                class CreateParticipantRequest implements ICreateParticipantRequest {

                    /**
                     * Constructs a new CreateParticipantRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICreateParticipantRequest);

                    /** CreateParticipantRequest parent. */
                    public parent: string;

                    /** CreateParticipantRequest participant. */
                    public participant?: (google.cloud.dialogflow.v2.IParticipant|null);

                    /**
                     * Creates a new CreateParticipantRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateParticipantRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICreateParticipantRequest): google.cloud.dialogflow.v2.CreateParticipantRequest;

                    /**
                     * Encodes the specified CreateParticipantRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateParticipantRequest.verify|verify} messages.
                     * @param message CreateParticipantRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICreateParticipantRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateParticipantRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateParticipantRequest.verify|verify} messages.
                     * @param message CreateParticipantRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICreateParticipantRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateParticipantRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateParticipantRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CreateParticipantRequest;

                    /**
                     * Decodes a CreateParticipantRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateParticipantRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CreateParticipantRequest;

                    /**
                     * Verifies a CreateParticipantRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateParticipantRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateParticipantRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CreateParticipantRequest;

                    /**
                     * Creates a plain object from a CreateParticipantRequest message. Also converts values to other types if specified.
                     * @param message CreateParticipantRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CreateParticipantRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateParticipantRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetParticipantRequest. */
                interface IGetParticipantRequest {

                    /** GetParticipantRequest name */
                    name?: (string|null);
                }

                /** Represents a GetParticipantRequest. */
                class GetParticipantRequest implements IGetParticipantRequest {

                    /**
                     * Constructs a new GetParticipantRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetParticipantRequest);

                    /** GetParticipantRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetParticipantRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetParticipantRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetParticipantRequest): google.cloud.dialogflow.v2.GetParticipantRequest;

                    /**
                     * Encodes the specified GetParticipantRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetParticipantRequest.verify|verify} messages.
                     * @param message GetParticipantRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetParticipantRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetParticipantRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetParticipantRequest.verify|verify} messages.
                     * @param message GetParticipantRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetParticipantRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetParticipantRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetParticipantRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetParticipantRequest;

                    /**
                     * Decodes a GetParticipantRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetParticipantRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetParticipantRequest;

                    /**
                     * Verifies a GetParticipantRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetParticipantRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetParticipantRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetParticipantRequest;

                    /**
                     * Creates a plain object from a GetParticipantRequest message. Also converts values to other types if specified.
                     * @param message GetParticipantRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetParticipantRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetParticipantRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListParticipantsRequest. */
                interface IListParticipantsRequest {

                    /** ListParticipantsRequest parent */
                    parent?: (string|null);

                    /** ListParticipantsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListParticipantsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListParticipantsRequest. */
                class ListParticipantsRequest implements IListParticipantsRequest {

                    /**
                     * Constructs a new ListParticipantsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListParticipantsRequest);

                    /** ListParticipantsRequest parent. */
                    public parent: string;

                    /** ListParticipantsRequest pageSize. */
                    public pageSize: number;

                    /** ListParticipantsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListParticipantsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListParticipantsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListParticipantsRequest): google.cloud.dialogflow.v2.ListParticipantsRequest;

                    /**
                     * Encodes the specified ListParticipantsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsRequest.verify|verify} messages.
                     * @param message ListParticipantsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListParticipantsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListParticipantsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsRequest.verify|verify} messages.
                     * @param message ListParticipantsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListParticipantsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListParticipantsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListParticipantsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListParticipantsRequest;

                    /**
                     * Decodes a ListParticipantsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListParticipantsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListParticipantsRequest;

                    /**
                     * Verifies a ListParticipantsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListParticipantsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListParticipantsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListParticipantsRequest;

                    /**
                     * Creates a plain object from a ListParticipantsRequest message. Also converts values to other types if specified.
                     * @param message ListParticipantsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListParticipantsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListParticipantsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListParticipantsResponse. */
                interface IListParticipantsResponse {

                    /** ListParticipantsResponse participants */
                    participants?: (google.cloud.dialogflow.v2.IParticipant[]|null);

                    /** ListParticipantsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListParticipantsResponse. */
                class ListParticipantsResponse implements IListParticipantsResponse {

                    /**
                     * Constructs a new ListParticipantsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListParticipantsResponse);

                    /** ListParticipantsResponse participants. */
                    public participants: google.cloud.dialogflow.v2.IParticipant[];

                    /** ListParticipantsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListParticipantsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListParticipantsResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListParticipantsResponse): google.cloud.dialogflow.v2.ListParticipantsResponse;

                    /**
                     * Encodes the specified ListParticipantsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsResponse.verify|verify} messages.
                     * @param message ListParticipantsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListParticipantsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListParticipantsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsResponse.verify|verify} messages.
                     * @param message ListParticipantsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListParticipantsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListParticipantsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListParticipantsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListParticipantsResponse;

                    /**
                     * Decodes a ListParticipantsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListParticipantsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListParticipantsResponse;

                    /**
                     * Verifies a ListParticipantsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListParticipantsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListParticipantsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListParticipantsResponse;

                    /**
                     * Creates a plain object from a ListParticipantsResponse message. Also converts values to other types if specified.
                     * @param message ListParticipantsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListParticipantsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListParticipantsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an UpdateParticipantRequest. */
                interface IUpdateParticipantRequest {

                    /** UpdateParticipantRequest participant */
                    participant?: (google.cloud.dialogflow.v2.IParticipant|null);

                    /** UpdateParticipantRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateParticipantRequest. */
                class UpdateParticipantRequest implements IUpdateParticipantRequest {

                    /**
                     * Constructs a new UpdateParticipantRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IUpdateParticipantRequest);

                    /** UpdateParticipantRequest participant. */
                    public participant?: (google.cloud.dialogflow.v2.IParticipant|null);

                    /** UpdateParticipantRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateParticipantRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateParticipantRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IUpdateParticipantRequest): google.cloud.dialogflow.v2.UpdateParticipantRequest;

                    /**
                     * Encodes the specified UpdateParticipantRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateParticipantRequest.verify|verify} messages.
                     * @param message UpdateParticipantRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IUpdateParticipantRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateParticipantRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateParticipantRequest.verify|verify} messages.
                     * @param message UpdateParticipantRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IUpdateParticipantRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateParticipantRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateParticipantRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.UpdateParticipantRequest;

                    /**
                     * Decodes an UpdateParticipantRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateParticipantRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.UpdateParticipantRequest;

                    /**
                     * Verifies an UpdateParticipantRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateParticipantRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateParticipantRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.UpdateParticipantRequest;

                    /**
                     * Creates a plain object from an UpdateParticipantRequest message. Also converts values to other types if specified.
                     * @param message UpdateParticipantRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.UpdateParticipantRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateParticipantRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an AnalyzeContentRequest. */
                interface IAnalyzeContentRequest {

                    /** AnalyzeContentRequest participant */
                    participant?: (string|null);

                    /** AnalyzeContentRequest textInput */
                    textInput?: (google.cloud.dialogflow.v2.ITextInput|null);

                    /** AnalyzeContentRequest eventInput */
                    eventInput?: (google.cloud.dialogflow.v2.IEventInput|null);

                    /** AnalyzeContentRequest replyAudioConfig */
                    replyAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** AnalyzeContentRequest queryParams */
                    queryParams?: (google.cloud.dialogflow.v2.IQueryParameters|null);

                    /** AnalyzeContentRequest assistQueryParams */
                    assistQueryParams?: (google.cloud.dialogflow.v2.IAssistQueryParameters|null);

                    /** AnalyzeContentRequest cxParameters */
                    cxParameters?: (google.protobuf.IStruct|null);

                    /** AnalyzeContentRequest requestId */
                    requestId?: (string|null);
                }

                /** Represents an AnalyzeContentRequest. */
                class AnalyzeContentRequest implements IAnalyzeContentRequest {

                    /**
                     * Constructs a new AnalyzeContentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAnalyzeContentRequest);

                    /** AnalyzeContentRequest participant. */
                    public participant: string;

                    /** AnalyzeContentRequest textInput. */
                    public textInput?: (google.cloud.dialogflow.v2.ITextInput|null);

                    /** AnalyzeContentRequest eventInput. */
                    public eventInput?: (google.cloud.dialogflow.v2.IEventInput|null);

                    /** AnalyzeContentRequest replyAudioConfig. */
                    public replyAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** AnalyzeContentRequest queryParams. */
                    public queryParams?: (google.cloud.dialogflow.v2.IQueryParameters|null);

                    /** AnalyzeContentRequest assistQueryParams. */
                    public assistQueryParams?: (google.cloud.dialogflow.v2.IAssistQueryParameters|null);

                    /** AnalyzeContentRequest cxParameters. */
                    public cxParameters?: (google.protobuf.IStruct|null);

                    /** AnalyzeContentRequest requestId. */
                    public requestId: string;

                    /** AnalyzeContentRequest input. */
                    public input?: ("textInput"|"eventInput");

                    /**
                     * Creates a new AnalyzeContentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnalyzeContentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAnalyzeContentRequest): google.cloud.dialogflow.v2.AnalyzeContentRequest;

                    /**
                     * Encodes the specified AnalyzeContentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentRequest.verify|verify} messages.
                     * @param message AnalyzeContentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAnalyzeContentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnalyzeContentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentRequest.verify|verify} messages.
                     * @param message AnalyzeContentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAnalyzeContentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnalyzeContentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnalyzeContentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AnalyzeContentRequest;

                    /**
                     * Decodes an AnalyzeContentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnalyzeContentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AnalyzeContentRequest;

                    /**
                     * Verifies an AnalyzeContentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnalyzeContentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnalyzeContentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AnalyzeContentRequest;

                    /**
                     * Creates a plain object from an AnalyzeContentRequest message. Also converts values to other types if specified.
                     * @param message AnalyzeContentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AnalyzeContentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnalyzeContentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DtmfParameters. */
                interface IDtmfParameters {

                    /** DtmfParameters acceptsDtmfInput */
                    acceptsDtmfInput?: (boolean|null);
                }

                /** Represents a DtmfParameters. */
                class DtmfParameters implements IDtmfParameters {

                    /**
                     * Constructs a new DtmfParameters.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDtmfParameters);

                    /** DtmfParameters acceptsDtmfInput. */
                    public acceptsDtmfInput: boolean;

                    /**
                     * Creates a new DtmfParameters instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DtmfParameters instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDtmfParameters): google.cloud.dialogflow.v2.DtmfParameters;

                    /**
                     * Encodes the specified DtmfParameters message. Does not implicitly {@link google.cloud.dialogflow.v2.DtmfParameters.verify|verify} messages.
                     * @param message DtmfParameters message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDtmfParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DtmfParameters message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DtmfParameters.verify|verify} messages.
                     * @param message DtmfParameters message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDtmfParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DtmfParameters message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DtmfParameters
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DtmfParameters;

                    /**
                     * Decodes a DtmfParameters message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DtmfParameters
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DtmfParameters;

                    /**
                     * Verifies a DtmfParameters message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DtmfParameters message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DtmfParameters
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DtmfParameters;

                    /**
                     * Creates a plain object from a DtmfParameters message. Also converts values to other types if specified.
                     * @param message DtmfParameters
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DtmfParameters, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DtmfParameters to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an AnalyzeContentResponse. */
                interface IAnalyzeContentResponse {

                    /** AnalyzeContentResponse replyText */
                    replyText?: (string|null);

                    /** AnalyzeContentResponse replyAudio */
                    replyAudio?: (google.cloud.dialogflow.v2.IOutputAudio|null);

                    /** AnalyzeContentResponse automatedAgentReply */
                    automatedAgentReply?: (google.cloud.dialogflow.v2.IAutomatedAgentReply|null);

                    /** AnalyzeContentResponse message */
                    message?: (google.cloud.dialogflow.v2.IMessage|null);

                    /** AnalyzeContentResponse humanAgentSuggestionResults */
                    humanAgentSuggestionResults?: (google.cloud.dialogflow.v2.ISuggestionResult[]|null);

                    /** AnalyzeContentResponse endUserSuggestionResults */
                    endUserSuggestionResults?: (google.cloud.dialogflow.v2.ISuggestionResult[]|null);

                    /** AnalyzeContentResponse dtmfParameters */
                    dtmfParameters?: (google.cloud.dialogflow.v2.IDtmfParameters|null);
                }

                /** Represents an AnalyzeContentResponse. */
                class AnalyzeContentResponse implements IAnalyzeContentResponse {

                    /**
                     * Constructs a new AnalyzeContentResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAnalyzeContentResponse);

                    /** AnalyzeContentResponse replyText. */
                    public replyText: string;

                    /** AnalyzeContentResponse replyAudio. */
                    public replyAudio?: (google.cloud.dialogflow.v2.IOutputAudio|null);

                    /** AnalyzeContentResponse automatedAgentReply. */
                    public automatedAgentReply?: (google.cloud.dialogflow.v2.IAutomatedAgentReply|null);

                    /** AnalyzeContentResponse message. */
                    public message?: (google.cloud.dialogflow.v2.IMessage|null);

                    /** AnalyzeContentResponse humanAgentSuggestionResults. */
                    public humanAgentSuggestionResults: google.cloud.dialogflow.v2.ISuggestionResult[];

                    /** AnalyzeContentResponse endUserSuggestionResults. */
                    public endUserSuggestionResults: google.cloud.dialogflow.v2.ISuggestionResult[];

                    /** AnalyzeContentResponse dtmfParameters. */
                    public dtmfParameters?: (google.cloud.dialogflow.v2.IDtmfParameters|null);

                    /**
                     * Creates a new AnalyzeContentResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnalyzeContentResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAnalyzeContentResponse): google.cloud.dialogflow.v2.AnalyzeContentResponse;

                    /**
                     * Encodes the specified AnalyzeContentResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentResponse.verify|verify} messages.
                     * @param message AnalyzeContentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAnalyzeContentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnalyzeContentResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentResponse.verify|verify} messages.
                     * @param message AnalyzeContentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAnalyzeContentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnalyzeContentResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnalyzeContentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AnalyzeContentResponse;

                    /**
                     * Decodes an AnalyzeContentResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnalyzeContentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AnalyzeContentResponse;

                    /**
                     * Verifies an AnalyzeContentResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnalyzeContentResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnalyzeContentResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AnalyzeContentResponse;

                    /**
                     * Creates a plain object from an AnalyzeContentResponse message. Also converts values to other types if specified.
                     * @param message AnalyzeContentResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AnalyzeContentResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnalyzeContentResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SuggestArticlesRequest. */
                interface ISuggestArticlesRequest {

                    /** SuggestArticlesRequest parent */
                    parent?: (string|null);

                    /** SuggestArticlesRequest latestMessage */
                    latestMessage?: (string|null);

                    /** SuggestArticlesRequest contextSize */
                    contextSize?: (number|null);

                    /** SuggestArticlesRequest assistQueryParams */
                    assistQueryParams?: (google.cloud.dialogflow.v2.IAssistQueryParameters|null);
                }

                /** Represents a SuggestArticlesRequest. */
                class SuggestArticlesRequest implements ISuggestArticlesRequest {

                    /**
                     * Constructs a new SuggestArticlesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISuggestArticlesRequest);

                    /** SuggestArticlesRequest parent. */
                    public parent: string;

                    /** SuggestArticlesRequest latestMessage. */
                    public latestMessage: string;

                    /** SuggestArticlesRequest contextSize. */
                    public contextSize: number;

                    /** SuggestArticlesRequest assistQueryParams. */
                    public assistQueryParams?: (google.cloud.dialogflow.v2.IAssistQueryParameters|null);

                    /**
                     * Creates a new SuggestArticlesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SuggestArticlesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISuggestArticlesRequest): google.cloud.dialogflow.v2.SuggestArticlesRequest;

                    /**
                     * Encodes the specified SuggestArticlesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesRequest.verify|verify} messages.
                     * @param message SuggestArticlesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISuggestArticlesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SuggestArticlesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesRequest.verify|verify} messages.
                     * @param message SuggestArticlesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISuggestArticlesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SuggestArticlesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SuggestArticlesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SuggestArticlesRequest;

                    /**
                     * Decodes a SuggestArticlesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SuggestArticlesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SuggestArticlesRequest;

                    /**
                     * Verifies a SuggestArticlesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SuggestArticlesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SuggestArticlesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SuggestArticlesRequest;

                    /**
                     * Creates a plain object from a SuggestArticlesRequest message. Also converts values to other types if specified.
                     * @param message SuggestArticlesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SuggestArticlesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SuggestArticlesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SuggestArticlesResponse. */
                interface ISuggestArticlesResponse {

                    /** SuggestArticlesResponse articleAnswers */
                    articleAnswers?: (google.cloud.dialogflow.v2.IArticleAnswer[]|null);

                    /** SuggestArticlesResponse latestMessage */
                    latestMessage?: (string|null);

                    /** SuggestArticlesResponse contextSize */
                    contextSize?: (number|null);
                }

                /** Represents a SuggestArticlesResponse. */
                class SuggestArticlesResponse implements ISuggestArticlesResponse {

                    /**
                     * Constructs a new SuggestArticlesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISuggestArticlesResponse);

                    /** SuggestArticlesResponse articleAnswers. */
                    public articleAnswers: google.cloud.dialogflow.v2.IArticleAnswer[];

                    /** SuggestArticlesResponse latestMessage. */
                    public latestMessage: string;

                    /** SuggestArticlesResponse contextSize. */
                    public contextSize: number;

                    /**
                     * Creates a new SuggestArticlesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SuggestArticlesResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISuggestArticlesResponse): google.cloud.dialogflow.v2.SuggestArticlesResponse;

                    /**
                     * Encodes the specified SuggestArticlesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesResponse.verify|verify} messages.
                     * @param message SuggestArticlesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISuggestArticlesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SuggestArticlesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesResponse.verify|verify} messages.
                     * @param message SuggestArticlesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISuggestArticlesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SuggestArticlesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SuggestArticlesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SuggestArticlesResponse;

                    /**
                     * Decodes a SuggestArticlesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SuggestArticlesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SuggestArticlesResponse;

                    /**
                     * Verifies a SuggestArticlesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SuggestArticlesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SuggestArticlesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SuggestArticlesResponse;

                    /**
                     * Creates a plain object from a SuggestArticlesResponse message. Also converts values to other types if specified.
                     * @param message SuggestArticlesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SuggestArticlesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SuggestArticlesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SuggestFaqAnswersRequest. */
                interface ISuggestFaqAnswersRequest {

                    /** SuggestFaqAnswersRequest parent */
                    parent?: (string|null);

                    /** SuggestFaqAnswersRequest latestMessage */
                    latestMessage?: (string|null);

                    /** SuggestFaqAnswersRequest contextSize */
                    contextSize?: (number|null);

                    /** SuggestFaqAnswersRequest assistQueryParams */
                    assistQueryParams?: (google.cloud.dialogflow.v2.IAssistQueryParameters|null);
                }

                /** Represents a SuggestFaqAnswersRequest. */
                class SuggestFaqAnswersRequest implements ISuggestFaqAnswersRequest {

                    /**
                     * Constructs a new SuggestFaqAnswersRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest);

                    /** SuggestFaqAnswersRequest parent. */
                    public parent: string;

                    /** SuggestFaqAnswersRequest latestMessage. */
                    public latestMessage: string;

                    /** SuggestFaqAnswersRequest contextSize. */
                    public contextSize: number;

                    /** SuggestFaqAnswersRequest assistQueryParams. */
                    public assistQueryParams?: (google.cloud.dialogflow.v2.IAssistQueryParameters|null);

                    /**
                     * Creates a new SuggestFaqAnswersRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SuggestFaqAnswersRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest): google.cloud.dialogflow.v2.SuggestFaqAnswersRequest;

                    /**
                     * Encodes the specified SuggestFaqAnswersRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersRequest.verify|verify} messages.
                     * @param message SuggestFaqAnswersRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SuggestFaqAnswersRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersRequest.verify|verify} messages.
                     * @param message SuggestFaqAnswersRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SuggestFaqAnswersRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SuggestFaqAnswersRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SuggestFaqAnswersRequest;

                    /**
                     * Decodes a SuggestFaqAnswersRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SuggestFaqAnswersRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SuggestFaqAnswersRequest;

                    /**
                     * Verifies a SuggestFaqAnswersRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SuggestFaqAnswersRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SuggestFaqAnswersRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SuggestFaqAnswersRequest;

                    /**
                     * Creates a plain object from a SuggestFaqAnswersRequest message. Also converts values to other types if specified.
                     * @param message SuggestFaqAnswersRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SuggestFaqAnswersRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SuggestFaqAnswersRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SuggestFaqAnswersResponse. */
                interface ISuggestFaqAnswersResponse {

                    /** SuggestFaqAnswersResponse faqAnswers */
                    faqAnswers?: (google.cloud.dialogflow.v2.IFaqAnswer[]|null);

                    /** SuggestFaqAnswersResponse latestMessage */
                    latestMessage?: (string|null);

                    /** SuggestFaqAnswersResponse contextSize */
                    contextSize?: (number|null);
                }

                /** Represents a SuggestFaqAnswersResponse. */
                class SuggestFaqAnswersResponse implements ISuggestFaqAnswersResponse {

                    /**
                     * Constructs a new SuggestFaqAnswersResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse);

                    /** SuggestFaqAnswersResponse faqAnswers. */
                    public faqAnswers: google.cloud.dialogflow.v2.IFaqAnswer[];

                    /** SuggestFaqAnswersResponse latestMessage. */
                    public latestMessage: string;

                    /** SuggestFaqAnswersResponse contextSize. */
                    public contextSize: number;

                    /**
                     * Creates a new SuggestFaqAnswersResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SuggestFaqAnswersResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse): google.cloud.dialogflow.v2.SuggestFaqAnswersResponse;

                    /**
                     * Encodes the specified SuggestFaqAnswersResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.verify|verify} messages.
                     * @param message SuggestFaqAnswersResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SuggestFaqAnswersResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.verify|verify} messages.
                     * @param message SuggestFaqAnswersResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SuggestFaqAnswersResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SuggestFaqAnswersResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SuggestFaqAnswersResponse;

                    /**
                     * Decodes a SuggestFaqAnswersResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SuggestFaqAnswersResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SuggestFaqAnswersResponse;

                    /**
                     * Verifies a SuggestFaqAnswersResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SuggestFaqAnswersResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SuggestFaqAnswersResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SuggestFaqAnswersResponse;

                    /**
                     * Creates a plain object from a SuggestFaqAnswersResponse message. Also converts values to other types if specified.
                     * @param message SuggestFaqAnswersResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SuggestFaqAnswersResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SuggestFaqAnswersResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SuggestSmartRepliesRequest. */
                interface ISuggestSmartRepliesRequest {

                    /** SuggestSmartRepliesRequest parent */
                    parent?: (string|null);

                    /** SuggestSmartRepliesRequest currentTextInput */
                    currentTextInput?: (google.cloud.dialogflow.v2.ITextInput|null);

                    /** SuggestSmartRepliesRequest latestMessage */
                    latestMessage?: (string|null);

                    /** SuggestSmartRepliesRequest contextSize */
                    contextSize?: (number|null);
                }

                /** Represents a SuggestSmartRepliesRequest. */
                class SuggestSmartRepliesRequest implements ISuggestSmartRepliesRequest {

                    /**
                     * Constructs a new SuggestSmartRepliesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest);

                    /** SuggestSmartRepliesRequest parent. */
                    public parent: string;

                    /** SuggestSmartRepliesRequest currentTextInput. */
                    public currentTextInput?: (google.cloud.dialogflow.v2.ITextInput|null);

                    /** SuggestSmartRepliesRequest latestMessage. */
                    public latestMessage: string;

                    /** SuggestSmartRepliesRequest contextSize. */
                    public contextSize: number;

                    /**
                     * Creates a new SuggestSmartRepliesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SuggestSmartRepliesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest): google.cloud.dialogflow.v2.SuggestSmartRepliesRequest;

                    /**
                     * Encodes the specified SuggestSmartRepliesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.verify|verify} messages.
                     * @param message SuggestSmartRepliesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SuggestSmartRepliesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.verify|verify} messages.
                     * @param message SuggestSmartRepliesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SuggestSmartRepliesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SuggestSmartRepliesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SuggestSmartRepliesRequest;

                    /**
                     * Decodes a SuggestSmartRepliesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SuggestSmartRepliesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SuggestSmartRepliesRequest;

                    /**
                     * Verifies a SuggestSmartRepliesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SuggestSmartRepliesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SuggestSmartRepliesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SuggestSmartRepliesRequest;

                    /**
                     * Creates a plain object from a SuggestSmartRepliesRequest message. Also converts values to other types if specified.
                     * @param message SuggestSmartRepliesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SuggestSmartRepliesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SuggestSmartRepliesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SuggestSmartRepliesResponse. */
                interface ISuggestSmartRepliesResponse {

                    /** SuggestSmartRepliesResponse smartReplyAnswers */
                    smartReplyAnswers?: (google.cloud.dialogflow.v2.ISmartReplyAnswer[]|null);

                    /** SuggestSmartRepliesResponse latestMessage */
                    latestMessage?: (string|null);

                    /** SuggestSmartRepliesResponse contextSize */
                    contextSize?: (number|null);
                }

                /** Represents a SuggestSmartRepliesResponse. */
                class SuggestSmartRepliesResponse implements ISuggestSmartRepliesResponse {

                    /**
                     * Constructs a new SuggestSmartRepliesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse);

                    /** SuggestSmartRepliesResponse smartReplyAnswers. */
                    public smartReplyAnswers: google.cloud.dialogflow.v2.ISmartReplyAnswer[];

                    /** SuggestSmartRepliesResponse latestMessage. */
                    public latestMessage: string;

                    /** SuggestSmartRepliesResponse contextSize. */
                    public contextSize: number;

                    /**
                     * Creates a new SuggestSmartRepliesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SuggestSmartRepliesResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse): google.cloud.dialogflow.v2.SuggestSmartRepliesResponse;

                    /**
                     * Encodes the specified SuggestSmartRepliesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.verify|verify} messages.
                     * @param message SuggestSmartRepliesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SuggestSmartRepliesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.verify|verify} messages.
                     * @param message SuggestSmartRepliesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SuggestSmartRepliesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SuggestSmartRepliesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SuggestSmartRepliesResponse;

                    /**
                     * Decodes a SuggestSmartRepliesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SuggestSmartRepliesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SuggestSmartRepliesResponse;

                    /**
                     * Verifies a SuggestSmartRepliesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SuggestSmartRepliesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SuggestSmartRepliesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SuggestSmartRepliesResponse;

                    /**
                     * Creates a plain object from a SuggestSmartRepliesResponse message. Also converts values to other types if specified.
                     * @param message SuggestSmartRepliesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SuggestSmartRepliesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SuggestSmartRepliesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an OutputAudio. */
                interface IOutputAudio {

                    /** OutputAudio config */
                    config?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** OutputAudio audio */
                    audio?: (Uint8Array|string|null);
                }

                /** Represents an OutputAudio. */
                class OutputAudio implements IOutputAudio {

                    /**
                     * Constructs a new OutputAudio.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IOutputAudio);

                    /** OutputAudio config. */
                    public config?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** OutputAudio audio. */
                    public audio: (Uint8Array|string);

                    /**
                     * Creates a new OutputAudio instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns OutputAudio instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IOutputAudio): google.cloud.dialogflow.v2.OutputAudio;

                    /**
                     * Encodes the specified OutputAudio message. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudio.verify|verify} messages.
                     * @param message OutputAudio message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IOutputAudio, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified OutputAudio message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudio.verify|verify} messages.
                     * @param message OutputAudio message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IOutputAudio, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an OutputAudio message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns OutputAudio
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.OutputAudio;

                    /**
                     * Decodes an OutputAudio message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns OutputAudio
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.OutputAudio;

                    /**
                     * Verifies an OutputAudio message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an OutputAudio message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns OutputAudio
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.OutputAudio;

                    /**
                     * Creates a plain object from an OutputAudio message. Also converts values to other types if specified.
                     * @param message OutputAudio
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.OutputAudio, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this OutputAudio to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an AutomatedAgentReply. */
                interface IAutomatedAgentReply {

                    /** AutomatedAgentReply detectIntentResponse */
                    detectIntentResponse?: (google.cloud.dialogflow.v2.IDetectIntentResponse|null);

                    /** AutomatedAgentReply automatedAgentReplyType */
                    automatedAgentReplyType?: (google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType|keyof typeof google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType|null);

                    /** AutomatedAgentReply allowCancellation */
                    allowCancellation?: (boolean|null);
                }

                /** Represents an AutomatedAgentReply. */
                class AutomatedAgentReply implements IAutomatedAgentReply {

                    /**
                     * Constructs a new AutomatedAgentReply.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAutomatedAgentReply);

                    /** AutomatedAgentReply detectIntentResponse. */
                    public detectIntentResponse?: (google.cloud.dialogflow.v2.IDetectIntentResponse|null);

                    /** AutomatedAgentReply automatedAgentReplyType. */
                    public automatedAgentReplyType: (google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType|keyof typeof google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType);

                    /** AutomatedAgentReply allowCancellation. */
                    public allowCancellation: boolean;

                    /**
                     * Creates a new AutomatedAgentReply instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AutomatedAgentReply instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAutomatedAgentReply): google.cloud.dialogflow.v2.AutomatedAgentReply;

                    /**
                     * Encodes the specified AutomatedAgentReply message. Does not implicitly {@link google.cloud.dialogflow.v2.AutomatedAgentReply.verify|verify} messages.
                     * @param message AutomatedAgentReply message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAutomatedAgentReply, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AutomatedAgentReply message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AutomatedAgentReply.verify|verify} messages.
                     * @param message AutomatedAgentReply message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAutomatedAgentReply, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AutomatedAgentReply message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AutomatedAgentReply
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AutomatedAgentReply;

                    /**
                     * Decodes an AutomatedAgentReply message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AutomatedAgentReply
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AutomatedAgentReply;

                    /**
                     * Verifies an AutomatedAgentReply message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AutomatedAgentReply message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AutomatedAgentReply
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AutomatedAgentReply;

                    /**
                     * Creates a plain object from an AutomatedAgentReply message. Also converts values to other types if specified.
                     * @param message AutomatedAgentReply
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AutomatedAgentReply, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AutomatedAgentReply to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace AutomatedAgentReply {

                    /** AutomatedAgentReplyType enum. */
                    enum AutomatedAgentReplyType {
                        AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED = 0,
                        PARTIAL = 1,
                        FINAL = 2
                    }
                }

                /** Properties of an ArticleAnswer. */
                interface IArticleAnswer {

                    /** ArticleAnswer title */
                    title?: (string|null);

                    /** ArticleAnswer uri */
                    uri?: (string|null);

                    /** ArticleAnswer snippets */
                    snippets?: (string[]|null);

                    /** ArticleAnswer confidence */
                    confidence?: (number|null);

                    /** ArticleAnswer metadata */
                    metadata?: ({ [k: string]: string }|null);

                    /** ArticleAnswer answerRecord */
                    answerRecord?: (string|null);
                }

                /** Represents an ArticleAnswer. */
                class ArticleAnswer implements IArticleAnswer {

                    /**
                     * Constructs a new ArticleAnswer.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IArticleAnswer);

                    /** ArticleAnswer title. */
                    public title: string;

                    /** ArticleAnswer uri. */
                    public uri: string;

                    /** ArticleAnswer snippets. */
                    public snippets: string[];

                    /** ArticleAnswer confidence. */
                    public confidence: number;

                    /** ArticleAnswer metadata. */
                    public metadata: { [k: string]: string };

                    /** ArticleAnswer answerRecord. */
                    public answerRecord: string;

                    /**
                     * Creates a new ArticleAnswer instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ArticleAnswer instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IArticleAnswer): google.cloud.dialogflow.v2.ArticleAnswer;

                    /**
                     * Encodes the specified ArticleAnswer message. Does not implicitly {@link google.cloud.dialogflow.v2.ArticleAnswer.verify|verify} messages.
                     * @param message ArticleAnswer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IArticleAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ArticleAnswer message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ArticleAnswer.verify|verify} messages.
                     * @param message ArticleAnswer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IArticleAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an ArticleAnswer message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ArticleAnswer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ArticleAnswer;

                    /**
                     * Decodes an ArticleAnswer message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ArticleAnswer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ArticleAnswer;

                    /**
                     * Verifies an ArticleAnswer message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an ArticleAnswer message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ArticleAnswer
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ArticleAnswer;

                    /**
                     * Creates a plain object from an ArticleAnswer message. Also converts values to other types if specified.
                     * @param message ArticleAnswer
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ArticleAnswer, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ArticleAnswer to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a FaqAnswer. */
                interface IFaqAnswer {

                    /** FaqAnswer answer */
                    answer?: (string|null);

                    /** FaqAnswer confidence */
                    confidence?: (number|null);

                    /** FaqAnswer question */
                    question?: (string|null);

                    /** FaqAnswer source */
                    source?: (string|null);

                    /** FaqAnswer metadata */
                    metadata?: ({ [k: string]: string }|null);

                    /** FaqAnswer answerRecord */
                    answerRecord?: (string|null);
                }

                /** Represents a FaqAnswer. */
                class FaqAnswer implements IFaqAnswer {

                    /**
                     * Constructs a new FaqAnswer.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IFaqAnswer);

                    /** FaqAnswer answer. */
                    public answer: string;

                    /** FaqAnswer confidence. */
                    public confidence: number;

                    /** FaqAnswer question. */
                    public question: string;

                    /** FaqAnswer source. */
                    public source: string;

                    /** FaqAnswer metadata. */
                    public metadata: { [k: string]: string };

                    /** FaqAnswer answerRecord. */
                    public answerRecord: string;

                    /**
                     * Creates a new FaqAnswer instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns FaqAnswer instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IFaqAnswer): google.cloud.dialogflow.v2.FaqAnswer;

                    /**
                     * Encodes the specified FaqAnswer message. Does not implicitly {@link google.cloud.dialogflow.v2.FaqAnswer.verify|verify} messages.
                     * @param message FaqAnswer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IFaqAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified FaqAnswer message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.FaqAnswer.verify|verify} messages.
                     * @param message FaqAnswer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IFaqAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a FaqAnswer message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns FaqAnswer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.FaqAnswer;

                    /**
                     * Decodes a FaqAnswer message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns FaqAnswer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.FaqAnswer;

                    /**
                     * Verifies a FaqAnswer message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a FaqAnswer message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns FaqAnswer
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.FaqAnswer;

                    /**
                     * Creates a plain object from a FaqAnswer message. Also converts values to other types if specified.
                     * @param message FaqAnswer
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.FaqAnswer, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this FaqAnswer to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SmartReplyAnswer. */
                interface ISmartReplyAnswer {

                    /** SmartReplyAnswer reply */
                    reply?: (string|null);

                    /** SmartReplyAnswer confidence */
                    confidence?: (number|null);

                    /** SmartReplyAnswer answerRecord */
                    answerRecord?: (string|null);
                }

                /** Represents a SmartReplyAnswer. */
                class SmartReplyAnswer implements ISmartReplyAnswer {

                    /**
                     * Constructs a new SmartReplyAnswer.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISmartReplyAnswer);

                    /** SmartReplyAnswer reply. */
                    public reply: string;

                    /** SmartReplyAnswer confidence. */
                    public confidence: number;

                    /** SmartReplyAnswer answerRecord. */
                    public answerRecord: string;

                    /**
                     * Creates a new SmartReplyAnswer instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SmartReplyAnswer instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISmartReplyAnswer): google.cloud.dialogflow.v2.SmartReplyAnswer;

                    /**
                     * Encodes the specified SmartReplyAnswer message. Does not implicitly {@link google.cloud.dialogflow.v2.SmartReplyAnswer.verify|verify} messages.
                     * @param message SmartReplyAnswer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISmartReplyAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SmartReplyAnswer message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SmartReplyAnswer.verify|verify} messages.
                     * @param message SmartReplyAnswer message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISmartReplyAnswer, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SmartReplyAnswer message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SmartReplyAnswer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SmartReplyAnswer;

                    /**
                     * Decodes a SmartReplyAnswer message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SmartReplyAnswer
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SmartReplyAnswer;

                    /**
                     * Verifies a SmartReplyAnswer message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SmartReplyAnswer message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SmartReplyAnswer
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SmartReplyAnswer;

                    /**
                     * Creates a plain object from a SmartReplyAnswer message. Also converts values to other types if specified.
                     * @param message SmartReplyAnswer
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SmartReplyAnswer, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SmartReplyAnswer to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SuggestionResult. */
                interface ISuggestionResult {

                    /** SuggestionResult error */
                    error?: (google.rpc.IStatus|null);

                    /** SuggestionResult suggestArticlesResponse */
                    suggestArticlesResponse?: (google.cloud.dialogflow.v2.ISuggestArticlesResponse|null);

                    /** SuggestionResult suggestFaqAnswersResponse */
                    suggestFaqAnswersResponse?: (google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse|null);

                    /** SuggestionResult suggestSmartRepliesResponse */
                    suggestSmartRepliesResponse?: (google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse|null);
                }

                /** Represents a SuggestionResult. */
                class SuggestionResult implements ISuggestionResult {

                    /**
                     * Constructs a new SuggestionResult.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISuggestionResult);

                    /** SuggestionResult error. */
                    public error?: (google.rpc.IStatus|null);

                    /** SuggestionResult suggestArticlesResponse. */
                    public suggestArticlesResponse?: (google.cloud.dialogflow.v2.ISuggestArticlesResponse|null);

                    /** SuggestionResult suggestFaqAnswersResponse. */
                    public suggestFaqAnswersResponse?: (google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse|null);

                    /** SuggestionResult suggestSmartRepliesResponse. */
                    public suggestSmartRepliesResponse?: (google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse|null);

                    /** SuggestionResult suggestionResponse. */
                    public suggestionResponse?: ("error"|"suggestArticlesResponse"|"suggestFaqAnswersResponse"|"suggestSmartRepliesResponse");

                    /**
                     * Creates a new SuggestionResult instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SuggestionResult instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISuggestionResult): google.cloud.dialogflow.v2.SuggestionResult;

                    /**
                     * Encodes the specified SuggestionResult message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestionResult.verify|verify} messages.
                     * @param message SuggestionResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISuggestionResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SuggestionResult message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestionResult.verify|verify} messages.
                     * @param message SuggestionResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISuggestionResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SuggestionResult message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SuggestionResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SuggestionResult;

                    /**
                     * Decodes a SuggestionResult message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SuggestionResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SuggestionResult;

                    /**
                     * Verifies a SuggestionResult message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SuggestionResult message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SuggestionResult
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SuggestionResult;

                    /**
                     * Creates a plain object from a SuggestionResult message. Also converts values to other types if specified.
                     * @param message SuggestionResult
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SuggestionResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SuggestionResult to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an AnnotatedMessagePart. */
                interface IAnnotatedMessagePart {

                    /** AnnotatedMessagePart text */
                    text?: (string|null);

                    /** AnnotatedMessagePart entityType */
                    entityType?: (string|null);

                    /** AnnotatedMessagePart formattedValue */
                    formattedValue?: (google.protobuf.IValue|null);
                }

                /** Represents an AnnotatedMessagePart. */
                class AnnotatedMessagePart implements IAnnotatedMessagePart {

                    /**
                     * Constructs a new AnnotatedMessagePart.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAnnotatedMessagePart);

                    /** AnnotatedMessagePart text. */
                    public text: string;

                    /** AnnotatedMessagePart entityType. */
                    public entityType: string;

                    /** AnnotatedMessagePart formattedValue. */
                    public formattedValue?: (google.protobuf.IValue|null);

                    /**
                     * Creates a new AnnotatedMessagePart instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AnnotatedMessagePart instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAnnotatedMessagePart): google.cloud.dialogflow.v2.AnnotatedMessagePart;

                    /**
                     * Encodes the specified AnnotatedMessagePart message. Does not implicitly {@link google.cloud.dialogflow.v2.AnnotatedMessagePart.verify|verify} messages.
                     * @param message AnnotatedMessagePart message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAnnotatedMessagePart, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AnnotatedMessagePart message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnnotatedMessagePart.verify|verify} messages.
                     * @param message AnnotatedMessagePart message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAnnotatedMessagePart, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AnnotatedMessagePart message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AnnotatedMessagePart
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AnnotatedMessagePart;

                    /**
                     * Decodes an AnnotatedMessagePart message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AnnotatedMessagePart
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AnnotatedMessagePart;

                    /**
                     * Verifies an AnnotatedMessagePart message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AnnotatedMessagePart message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AnnotatedMessagePart
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AnnotatedMessagePart;

                    /**
                     * Creates a plain object from an AnnotatedMessagePart message. Also converts values to other types if specified.
                     * @param message AnnotatedMessagePart
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AnnotatedMessagePart, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AnnotatedMessagePart to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a MessageAnnotation. */
                interface IMessageAnnotation {

                    /** MessageAnnotation parts */
                    parts?: (google.cloud.dialogflow.v2.IAnnotatedMessagePart[]|null);

                    /** MessageAnnotation containEntities */
                    containEntities?: (boolean|null);
                }

                /** Represents a MessageAnnotation. */
                class MessageAnnotation implements IMessageAnnotation {

                    /**
                     * Constructs a new MessageAnnotation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IMessageAnnotation);

                    /** MessageAnnotation parts. */
                    public parts: google.cloud.dialogflow.v2.IAnnotatedMessagePart[];

                    /** MessageAnnotation containEntities. */
                    public containEntities: boolean;

                    /**
                     * Creates a new MessageAnnotation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns MessageAnnotation instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IMessageAnnotation): google.cloud.dialogflow.v2.MessageAnnotation;

                    /**
                     * Encodes the specified MessageAnnotation message. Does not implicitly {@link google.cloud.dialogflow.v2.MessageAnnotation.verify|verify} messages.
                     * @param message MessageAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IMessageAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified MessageAnnotation message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.MessageAnnotation.verify|verify} messages.
                     * @param message MessageAnnotation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IMessageAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a MessageAnnotation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns MessageAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.MessageAnnotation;

                    /**
                     * Decodes a MessageAnnotation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns MessageAnnotation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.MessageAnnotation;

                    /**
                     * Verifies a MessageAnnotation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a MessageAnnotation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns MessageAnnotation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.MessageAnnotation;

                    /**
                     * Creates a plain object from a MessageAnnotation message. Also converts values to other types if specified.
                     * @param message MessageAnnotation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.MessageAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this MessageAnnotation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an AssistQueryParameters. */
                interface IAssistQueryParameters {

                    /** AssistQueryParameters documentsMetadataFilters */
                    documentsMetadataFilters?: ({ [k: string]: string }|null);
                }

                /** Represents an AssistQueryParameters. */
                class AssistQueryParameters implements IAssistQueryParameters {

                    /**
                     * Constructs a new AssistQueryParameters.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IAssistQueryParameters);

                    /** AssistQueryParameters documentsMetadataFilters. */
                    public documentsMetadataFilters: { [k: string]: string };

                    /**
                     * Creates a new AssistQueryParameters instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns AssistQueryParameters instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IAssistQueryParameters): google.cloud.dialogflow.v2.AssistQueryParameters;

                    /**
                     * Encodes the specified AssistQueryParameters message. Does not implicitly {@link google.cloud.dialogflow.v2.AssistQueryParameters.verify|verify} messages.
                     * @param message AssistQueryParameters message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IAssistQueryParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified AssistQueryParameters message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AssistQueryParameters.verify|verify} messages.
                     * @param message AssistQueryParameters message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IAssistQueryParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an AssistQueryParameters message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns AssistQueryParameters
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.AssistQueryParameters;

                    /**
                     * Decodes an AssistQueryParameters message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns AssistQueryParameters
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.AssistQueryParameters;

                    /**
                     * Verifies an AssistQueryParameters message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an AssistQueryParameters message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns AssistQueryParameters
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.AssistQueryParameters;

                    /**
                     * Creates a plain object from an AssistQueryParameters message. Also converts values to other types if specified.
                     * @param message AssistQueryParameters
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.AssistQueryParameters, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this AssistQueryParameters to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** AudioEncoding enum. */
                enum AudioEncoding {
                    AUDIO_ENCODING_UNSPECIFIED = 0,
                    AUDIO_ENCODING_LINEAR_16 = 1,
                    AUDIO_ENCODING_FLAC = 2,
                    AUDIO_ENCODING_MULAW = 3,
                    AUDIO_ENCODING_AMR = 4,
                    AUDIO_ENCODING_AMR_WB = 5,
                    AUDIO_ENCODING_OGG_OPUS = 6,
                    AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE = 7
                }

                /** Properties of a SpeechContext. */
                interface ISpeechContext {

                    /** SpeechContext phrases */
                    phrases?: (string[]|null);

                    /** SpeechContext boost */
                    boost?: (number|null);
                }

                /** Represents a SpeechContext. */
                class SpeechContext implements ISpeechContext {

                    /**
                     * Constructs a new SpeechContext.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISpeechContext);

                    /** SpeechContext phrases. */
                    public phrases: string[];

                    /** SpeechContext boost. */
                    public boost: number;

                    /**
                     * Creates a new SpeechContext instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SpeechContext instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISpeechContext): google.cloud.dialogflow.v2.SpeechContext;

                    /**
                     * Encodes the specified SpeechContext message. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechContext.verify|verify} messages.
                     * @param message SpeechContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISpeechContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SpeechContext message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechContext.verify|verify} messages.
                     * @param message SpeechContext message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISpeechContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SpeechContext message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SpeechContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SpeechContext;

                    /**
                     * Decodes a SpeechContext message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SpeechContext
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SpeechContext;

                    /**
                     * Verifies a SpeechContext message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SpeechContext message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SpeechContext
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SpeechContext;

                    /**
                     * Creates a plain object from a SpeechContext message. Also converts values to other types if specified.
                     * @param message SpeechContext
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SpeechContext, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SpeechContext to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** SpeechModelVariant enum. */
                enum SpeechModelVariant {
                    SPEECH_MODEL_VARIANT_UNSPECIFIED = 0,
                    USE_BEST_AVAILABLE = 1,
                    USE_STANDARD = 2,
                    USE_ENHANCED = 3
                }

                /** Properties of a SpeechWordInfo. */
                interface ISpeechWordInfo {

                    /** SpeechWordInfo word */
                    word?: (string|null);

                    /** SpeechWordInfo startOffset */
                    startOffset?: (google.protobuf.IDuration|null);

                    /** SpeechWordInfo endOffset */
                    endOffset?: (google.protobuf.IDuration|null);

                    /** SpeechWordInfo confidence */
                    confidence?: (number|null);
                }

                /** Represents a SpeechWordInfo. */
                class SpeechWordInfo implements ISpeechWordInfo {

                    /**
                     * Constructs a new SpeechWordInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISpeechWordInfo);

                    /** SpeechWordInfo word. */
                    public word: string;

                    /** SpeechWordInfo startOffset. */
                    public startOffset?: (google.protobuf.IDuration|null);

                    /** SpeechWordInfo endOffset. */
                    public endOffset?: (google.protobuf.IDuration|null);

                    /** SpeechWordInfo confidence. */
                    public confidence: number;

                    /**
                     * Creates a new SpeechWordInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SpeechWordInfo instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISpeechWordInfo): google.cloud.dialogflow.v2.SpeechWordInfo;

                    /**
                     * Encodes the specified SpeechWordInfo message. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechWordInfo.verify|verify} messages.
                     * @param message SpeechWordInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISpeechWordInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SpeechWordInfo message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechWordInfo.verify|verify} messages.
                     * @param message SpeechWordInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISpeechWordInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SpeechWordInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SpeechWordInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SpeechWordInfo;

                    /**
                     * Decodes a SpeechWordInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SpeechWordInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SpeechWordInfo;

                    /**
                     * Verifies a SpeechWordInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SpeechWordInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SpeechWordInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SpeechWordInfo;

                    /**
                     * Creates a plain object from a SpeechWordInfo message. Also converts values to other types if specified.
                     * @param message SpeechWordInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SpeechWordInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SpeechWordInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an InputAudioConfig. */
                interface IInputAudioConfig {

                    /** InputAudioConfig audioEncoding */
                    audioEncoding?: (google.cloud.dialogflow.v2.AudioEncoding|keyof typeof google.cloud.dialogflow.v2.AudioEncoding|null);

                    /** InputAudioConfig sampleRateHertz */
                    sampleRateHertz?: (number|null);

                    /** InputAudioConfig languageCode */
                    languageCode?: (string|null);

                    /** InputAudioConfig enableWordInfo */
                    enableWordInfo?: (boolean|null);

                    /** InputAudioConfig phraseHints */
                    phraseHints?: (string[]|null);

                    /** InputAudioConfig speechContexts */
                    speechContexts?: (google.cloud.dialogflow.v2.ISpeechContext[]|null);

                    /** InputAudioConfig model */
                    model?: (string|null);

                    /** InputAudioConfig modelVariant */
                    modelVariant?: (google.cloud.dialogflow.v2.SpeechModelVariant|keyof typeof google.cloud.dialogflow.v2.SpeechModelVariant|null);

                    /** InputAudioConfig singleUtterance */
                    singleUtterance?: (boolean|null);

                    /** InputAudioConfig disableNoSpeechRecognizedEvent */
                    disableNoSpeechRecognizedEvent?: (boolean|null);
                }

                /** Represents an InputAudioConfig. */
                class InputAudioConfig implements IInputAudioConfig {

                    /**
                     * Constructs a new InputAudioConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IInputAudioConfig);

                    /** InputAudioConfig audioEncoding. */
                    public audioEncoding: (google.cloud.dialogflow.v2.AudioEncoding|keyof typeof google.cloud.dialogflow.v2.AudioEncoding);

                    /** InputAudioConfig sampleRateHertz. */
                    public sampleRateHertz: number;

                    /** InputAudioConfig languageCode. */
                    public languageCode: string;

                    /** InputAudioConfig enableWordInfo. */
                    public enableWordInfo: boolean;

                    /** InputAudioConfig phraseHints. */
                    public phraseHints: string[];

                    /** InputAudioConfig speechContexts. */
                    public speechContexts: google.cloud.dialogflow.v2.ISpeechContext[];

                    /** InputAudioConfig model. */
                    public model: string;

                    /** InputAudioConfig modelVariant. */
                    public modelVariant: (google.cloud.dialogflow.v2.SpeechModelVariant|keyof typeof google.cloud.dialogflow.v2.SpeechModelVariant);

                    /** InputAudioConfig singleUtterance. */
                    public singleUtterance: boolean;

                    /** InputAudioConfig disableNoSpeechRecognizedEvent. */
                    public disableNoSpeechRecognizedEvent: boolean;

                    /**
                     * Creates a new InputAudioConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns InputAudioConfig instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IInputAudioConfig): google.cloud.dialogflow.v2.InputAudioConfig;

                    /**
                     * Encodes the specified InputAudioConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.InputAudioConfig.verify|verify} messages.
                     * @param message InputAudioConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IInputAudioConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified InputAudioConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.InputAudioConfig.verify|verify} messages.
                     * @param message InputAudioConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IInputAudioConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an InputAudioConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns InputAudioConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.InputAudioConfig;

                    /**
                     * Decodes an InputAudioConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns InputAudioConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.InputAudioConfig;

                    /**
                     * Verifies an InputAudioConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an InputAudioConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns InputAudioConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.InputAudioConfig;

                    /**
                     * Creates a plain object from an InputAudioConfig message. Also converts values to other types if specified.
                     * @param message InputAudioConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.InputAudioConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this InputAudioConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** SsmlVoiceGender enum. */
                enum SsmlVoiceGender {
                    SSML_VOICE_GENDER_UNSPECIFIED = 0,
                    SSML_VOICE_GENDER_MALE = 1,
                    SSML_VOICE_GENDER_FEMALE = 2,
                    SSML_VOICE_GENDER_NEUTRAL = 3
                }

                /** Properties of a VoiceSelectionParams. */
                interface IVoiceSelectionParams {

                    /** VoiceSelectionParams name */
                    name?: (string|null);

                    /** VoiceSelectionParams ssmlGender */
                    ssmlGender?: (google.cloud.dialogflow.v2.SsmlVoiceGender|keyof typeof google.cloud.dialogflow.v2.SsmlVoiceGender|null);
                }

                /** Represents a VoiceSelectionParams. */
                class VoiceSelectionParams implements IVoiceSelectionParams {

                    /**
                     * Constructs a new VoiceSelectionParams.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IVoiceSelectionParams);

                    /** VoiceSelectionParams name. */
                    public name: string;

                    /** VoiceSelectionParams ssmlGender. */
                    public ssmlGender: (google.cloud.dialogflow.v2.SsmlVoiceGender|keyof typeof google.cloud.dialogflow.v2.SsmlVoiceGender);

                    /**
                     * Creates a new VoiceSelectionParams instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns VoiceSelectionParams instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IVoiceSelectionParams): google.cloud.dialogflow.v2.VoiceSelectionParams;

                    /**
                     * Encodes the specified VoiceSelectionParams message. Does not implicitly {@link google.cloud.dialogflow.v2.VoiceSelectionParams.verify|verify} messages.
                     * @param message VoiceSelectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IVoiceSelectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified VoiceSelectionParams message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.VoiceSelectionParams.verify|verify} messages.
                     * @param message VoiceSelectionParams message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IVoiceSelectionParams, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a VoiceSelectionParams message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns VoiceSelectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.VoiceSelectionParams;

                    /**
                     * Decodes a VoiceSelectionParams message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns VoiceSelectionParams
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.VoiceSelectionParams;

                    /**
                     * Verifies a VoiceSelectionParams message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a VoiceSelectionParams message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns VoiceSelectionParams
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.VoiceSelectionParams;

                    /**
                     * Creates a plain object from a VoiceSelectionParams message. Also converts values to other types if specified.
                     * @param message VoiceSelectionParams
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.VoiceSelectionParams, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this VoiceSelectionParams to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SynthesizeSpeechConfig. */
                interface ISynthesizeSpeechConfig {

                    /** SynthesizeSpeechConfig speakingRate */
                    speakingRate?: (number|null);

                    /** SynthesizeSpeechConfig pitch */
                    pitch?: (number|null);

                    /** SynthesizeSpeechConfig volumeGainDb */
                    volumeGainDb?: (number|null);

                    /** SynthesizeSpeechConfig effectsProfileId */
                    effectsProfileId?: (string[]|null);

                    /** SynthesizeSpeechConfig voice */
                    voice?: (google.cloud.dialogflow.v2.IVoiceSelectionParams|null);
                }

                /** Represents a SynthesizeSpeechConfig. */
                class SynthesizeSpeechConfig implements ISynthesizeSpeechConfig {

                    /**
                     * Constructs a new SynthesizeSpeechConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISynthesizeSpeechConfig);

                    /** SynthesizeSpeechConfig speakingRate. */
                    public speakingRate: number;

                    /** SynthesizeSpeechConfig pitch. */
                    public pitch: number;

                    /** SynthesizeSpeechConfig volumeGainDb. */
                    public volumeGainDb: number;

                    /** SynthesizeSpeechConfig effectsProfileId. */
                    public effectsProfileId: string[];

                    /** SynthesizeSpeechConfig voice. */
                    public voice?: (google.cloud.dialogflow.v2.IVoiceSelectionParams|null);

                    /**
                     * Creates a new SynthesizeSpeechConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SynthesizeSpeechConfig instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISynthesizeSpeechConfig): google.cloud.dialogflow.v2.SynthesizeSpeechConfig;

                    /**
                     * Encodes the specified SynthesizeSpeechConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.SynthesizeSpeechConfig.verify|verify} messages.
                     * @param message SynthesizeSpeechConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISynthesizeSpeechConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SynthesizeSpeechConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SynthesizeSpeechConfig.verify|verify} messages.
                     * @param message SynthesizeSpeechConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISynthesizeSpeechConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SynthesizeSpeechConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SynthesizeSpeechConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SynthesizeSpeechConfig;

                    /**
                     * Decodes a SynthesizeSpeechConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SynthesizeSpeechConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SynthesizeSpeechConfig;

                    /**
                     * Verifies a SynthesizeSpeechConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SynthesizeSpeechConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SynthesizeSpeechConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SynthesizeSpeechConfig;

                    /**
                     * Creates a plain object from a SynthesizeSpeechConfig message. Also converts values to other types if specified.
                     * @param message SynthesizeSpeechConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SynthesizeSpeechConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SynthesizeSpeechConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** OutputAudioEncoding enum. */
                enum OutputAudioEncoding {
                    OUTPUT_AUDIO_ENCODING_UNSPECIFIED = 0,
                    OUTPUT_AUDIO_ENCODING_LINEAR_16 = 1,
                    OUTPUT_AUDIO_ENCODING_MP3 = 2,
                    OUTPUT_AUDIO_ENCODING_MP3_64_KBPS = 4,
                    OUTPUT_AUDIO_ENCODING_OGG_OPUS = 3,
                    OUTPUT_AUDIO_ENCODING_MULAW = 5
                }

                /** Properties of an OutputAudioConfig. */
                interface IOutputAudioConfig {

                    /** OutputAudioConfig audioEncoding */
                    audioEncoding?: (google.cloud.dialogflow.v2.OutputAudioEncoding|keyof typeof google.cloud.dialogflow.v2.OutputAudioEncoding|null);

                    /** OutputAudioConfig sampleRateHertz */
                    sampleRateHertz?: (number|null);

                    /** OutputAudioConfig synthesizeSpeechConfig */
                    synthesizeSpeechConfig?: (google.cloud.dialogflow.v2.ISynthesizeSpeechConfig|null);
                }

                /** Represents an OutputAudioConfig. */
                class OutputAudioConfig implements IOutputAudioConfig {

                    /**
                     * Constructs a new OutputAudioConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IOutputAudioConfig);

                    /** OutputAudioConfig audioEncoding. */
                    public audioEncoding: (google.cloud.dialogflow.v2.OutputAudioEncoding|keyof typeof google.cloud.dialogflow.v2.OutputAudioEncoding);

                    /** OutputAudioConfig sampleRateHertz. */
                    public sampleRateHertz: number;

                    /** OutputAudioConfig synthesizeSpeechConfig. */
                    public synthesizeSpeechConfig?: (google.cloud.dialogflow.v2.ISynthesizeSpeechConfig|null);

                    /**
                     * Creates a new OutputAudioConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns OutputAudioConfig instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IOutputAudioConfig): google.cloud.dialogflow.v2.OutputAudioConfig;

                    /**
                     * Encodes the specified OutputAudioConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudioConfig.verify|verify} messages.
                     * @param message OutputAudioConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IOutputAudioConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified OutputAudioConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudioConfig.verify|verify} messages.
                     * @param message OutputAudioConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IOutputAudioConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an OutputAudioConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns OutputAudioConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.OutputAudioConfig;

                    /**
                     * Decodes an OutputAudioConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns OutputAudioConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.OutputAudioConfig;

                    /**
                     * Verifies an OutputAudioConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an OutputAudioConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns OutputAudioConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.OutputAudioConfig;

                    /**
                     * Creates a plain object from an OutputAudioConfig message. Also converts values to other types if specified.
                     * @param message OutputAudioConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.OutputAudioConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this OutputAudioConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SpeechToTextConfig. */
                interface ISpeechToTextConfig {

                    /** SpeechToTextConfig speechModelVariant */
                    speechModelVariant?: (google.cloud.dialogflow.v2.SpeechModelVariant|keyof typeof google.cloud.dialogflow.v2.SpeechModelVariant|null);
                }

                /** Represents a SpeechToTextConfig. */
                class SpeechToTextConfig implements ISpeechToTextConfig {

                    /**
                     * Constructs a new SpeechToTextConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISpeechToTextConfig);

                    /** SpeechToTextConfig speechModelVariant. */
                    public speechModelVariant: (google.cloud.dialogflow.v2.SpeechModelVariant|keyof typeof google.cloud.dialogflow.v2.SpeechModelVariant);

                    /**
                     * Creates a new SpeechToTextConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SpeechToTextConfig instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISpeechToTextConfig): google.cloud.dialogflow.v2.SpeechToTextConfig;

                    /**
                     * Encodes the specified SpeechToTextConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechToTextConfig.verify|verify} messages.
                     * @param message SpeechToTextConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISpeechToTextConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SpeechToTextConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechToTextConfig.verify|verify} messages.
                     * @param message SpeechToTextConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISpeechToTextConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SpeechToTextConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SpeechToTextConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SpeechToTextConfig;

                    /**
                     * Decodes a SpeechToTextConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SpeechToTextConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SpeechToTextConfig;

                    /**
                     * Verifies a SpeechToTextConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SpeechToTextConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SpeechToTextConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SpeechToTextConfig;

                    /**
                     * Creates a plain object from a SpeechToTextConfig message. Also converts values to other types if specified.
                     * @param message SpeechToTextConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SpeechToTextConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SpeechToTextConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents a Sessions */
                class Sessions extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new Sessions service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new Sessions service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Sessions;

                    /**
                     * Calls DetectIntent.
                     * @param request DetectIntentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and DetectIntentResponse
                     */
                    public detectIntent(request: google.cloud.dialogflow.v2.IDetectIntentRequest, callback: google.cloud.dialogflow.v2.Sessions.DetectIntentCallback): void;

                    /**
                     * Calls DetectIntent.
                     * @param request DetectIntentRequest message or plain object
                     * @returns Promise
                     */
                    public detectIntent(request: google.cloud.dialogflow.v2.IDetectIntentRequest): Promise<google.cloud.dialogflow.v2.DetectIntentResponse>;

                    /**
                     * Calls StreamingDetectIntent.
                     * @param request StreamingDetectIntentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and StreamingDetectIntentResponse
                     */
                    public streamingDetectIntent(request: google.cloud.dialogflow.v2.IStreamingDetectIntentRequest, callback: google.cloud.dialogflow.v2.Sessions.StreamingDetectIntentCallback): void;

                    /**
                     * Calls StreamingDetectIntent.
                     * @param request StreamingDetectIntentRequest message or plain object
                     * @returns Promise
                     */
                    public streamingDetectIntent(request: google.cloud.dialogflow.v2.IStreamingDetectIntentRequest): Promise<google.cloud.dialogflow.v2.StreamingDetectIntentResponse>;
                }

                namespace Sessions {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Sessions#detectIntent}.
                     * @param error Error, if any
                     * @param [response] DetectIntentResponse
                     */
                    type DetectIntentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.DetectIntentResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Sessions#streamingDetectIntent}.
                     * @param error Error, if any
                     * @param [response] StreamingDetectIntentResponse
                     */
                    type StreamingDetectIntentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.StreamingDetectIntentResponse) => void;
                }

                /** Properties of a DetectIntentRequest. */
                interface IDetectIntentRequest {

                    /** DetectIntentRequest session */
                    session?: (string|null);

                    /** DetectIntentRequest queryParams */
                    queryParams?: (google.cloud.dialogflow.v2.IQueryParameters|null);

                    /** DetectIntentRequest queryInput */
                    queryInput?: (google.cloud.dialogflow.v2.IQueryInput|null);

                    /** DetectIntentRequest outputAudioConfig */
                    outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** DetectIntentRequest outputAudioConfigMask */
                    outputAudioConfigMask?: (google.protobuf.IFieldMask|null);

                    /** DetectIntentRequest inputAudio */
                    inputAudio?: (Uint8Array|string|null);
                }

                /** Represents a DetectIntentRequest. */
                class DetectIntentRequest implements IDetectIntentRequest {

                    /**
                     * Constructs a new DetectIntentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDetectIntentRequest);

                    /** DetectIntentRequest session. */
                    public session: string;

                    /** DetectIntentRequest queryParams. */
                    public queryParams?: (google.cloud.dialogflow.v2.IQueryParameters|null);

                    /** DetectIntentRequest queryInput. */
                    public queryInput?: (google.cloud.dialogflow.v2.IQueryInput|null);

                    /** DetectIntentRequest outputAudioConfig. */
                    public outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** DetectIntentRequest outputAudioConfigMask. */
                    public outputAudioConfigMask?: (google.protobuf.IFieldMask|null);

                    /** DetectIntentRequest inputAudio. */
                    public inputAudio: (Uint8Array|string);

                    /**
                     * Creates a new DetectIntentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DetectIntentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDetectIntentRequest): google.cloud.dialogflow.v2.DetectIntentRequest;

                    /**
                     * Encodes the specified DetectIntentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentRequest.verify|verify} messages.
                     * @param message DetectIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDetectIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DetectIntentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentRequest.verify|verify} messages.
                     * @param message DetectIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDetectIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DetectIntentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DetectIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DetectIntentRequest;

                    /**
                     * Decodes a DetectIntentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DetectIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DetectIntentRequest;

                    /**
                     * Verifies a DetectIntentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DetectIntentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DetectIntentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DetectIntentRequest;

                    /**
                     * Creates a plain object from a DetectIntentRequest message. Also converts values to other types if specified.
                     * @param message DetectIntentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DetectIntentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DetectIntentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DetectIntentResponse. */
                interface IDetectIntentResponse {

                    /** DetectIntentResponse responseId */
                    responseId?: (string|null);

                    /** DetectIntentResponse queryResult */
                    queryResult?: (google.cloud.dialogflow.v2.IQueryResult|null);

                    /** DetectIntentResponse webhookStatus */
                    webhookStatus?: (google.rpc.IStatus|null);

                    /** DetectIntentResponse outputAudio */
                    outputAudio?: (Uint8Array|string|null);

                    /** DetectIntentResponse outputAudioConfig */
                    outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);
                }

                /** Represents a DetectIntentResponse. */
                class DetectIntentResponse implements IDetectIntentResponse {

                    /**
                     * Constructs a new DetectIntentResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDetectIntentResponse);

                    /** DetectIntentResponse responseId. */
                    public responseId: string;

                    /** DetectIntentResponse queryResult. */
                    public queryResult?: (google.cloud.dialogflow.v2.IQueryResult|null);

                    /** DetectIntentResponse webhookStatus. */
                    public webhookStatus?: (google.rpc.IStatus|null);

                    /** DetectIntentResponse outputAudio. */
                    public outputAudio: (Uint8Array|string);

                    /** DetectIntentResponse outputAudioConfig. */
                    public outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /**
                     * Creates a new DetectIntentResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DetectIntentResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDetectIntentResponse): google.cloud.dialogflow.v2.DetectIntentResponse;

                    /**
                     * Encodes the specified DetectIntentResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentResponse.verify|verify} messages.
                     * @param message DetectIntentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDetectIntentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DetectIntentResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentResponse.verify|verify} messages.
                     * @param message DetectIntentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDetectIntentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DetectIntentResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DetectIntentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DetectIntentResponse;

                    /**
                     * Decodes a DetectIntentResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DetectIntentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DetectIntentResponse;

                    /**
                     * Verifies a DetectIntentResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DetectIntentResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DetectIntentResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DetectIntentResponse;

                    /**
                     * Creates a plain object from a DetectIntentResponse message. Also converts values to other types if specified.
                     * @param message DetectIntentResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DetectIntentResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DetectIntentResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a QueryParameters. */
                interface IQueryParameters {

                    /** QueryParameters timeZone */
                    timeZone?: (string|null);

                    /** QueryParameters geoLocation */
                    geoLocation?: (google.type.ILatLng|null);

                    /** QueryParameters contexts */
                    contexts?: (google.cloud.dialogflow.v2.IContext[]|null);

                    /** QueryParameters resetContexts */
                    resetContexts?: (boolean|null);

                    /** QueryParameters sessionEntityTypes */
                    sessionEntityTypes?: (google.cloud.dialogflow.v2.ISessionEntityType[]|null);

                    /** QueryParameters payload */
                    payload?: (google.protobuf.IStruct|null);

                    /** QueryParameters sentimentAnalysisRequestConfig */
                    sentimentAnalysisRequestConfig?: (google.cloud.dialogflow.v2.ISentimentAnalysisRequestConfig|null);

                    /** QueryParameters webhookHeaders */
                    webhookHeaders?: ({ [k: string]: string }|null);
                }

                /** Represents a QueryParameters. */
                class QueryParameters implements IQueryParameters {

                    /**
                     * Constructs a new QueryParameters.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IQueryParameters);

                    /** QueryParameters timeZone. */
                    public timeZone: string;

                    /** QueryParameters geoLocation. */
                    public geoLocation?: (google.type.ILatLng|null);

                    /** QueryParameters contexts. */
                    public contexts: google.cloud.dialogflow.v2.IContext[];

                    /** QueryParameters resetContexts. */
                    public resetContexts: boolean;

                    /** QueryParameters sessionEntityTypes. */
                    public sessionEntityTypes: google.cloud.dialogflow.v2.ISessionEntityType[];

                    /** QueryParameters payload. */
                    public payload?: (google.protobuf.IStruct|null);

                    /** QueryParameters sentimentAnalysisRequestConfig. */
                    public sentimentAnalysisRequestConfig?: (google.cloud.dialogflow.v2.ISentimentAnalysisRequestConfig|null);

                    /** QueryParameters webhookHeaders. */
                    public webhookHeaders: { [k: string]: string };

                    /**
                     * Creates a new QueryParameters instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns QueryParameters instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IQueryParameters): google.cloud.dialogflow.v2.QueryParameters;

                    /**
                     * Encodes the specified QueryParameters message. Does not implicitly {@link google.cloud.dialogflow.v2.QueryParameters.verify|verify} messages.
                     * @param message QueryParameters message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IQueryParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified QueryParameters message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.QueryParameters.verify|verify} messages.
                     * @param message QueryParameters message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IQueryParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a QueryParameters message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns QueryParameters
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.QueryParameters;

                    /**
                     * Decodes a QueryParameters message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns QueryParameters
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.QueryParameters;

                    /**
                     * Verifies a QueryParameters message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a QueryParameters message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns QueryParameters
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.QueryParameters;

                    /**
                     * Creates a plain object from a QueryParameters message. Also converts values to other types if specified.
                     * @param message QueryParameters
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.QueryParameters, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this QueryParameters to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a QueryInput. */
                interface IQueryInput {

                    /** QueryInput audioConfig */
                    audioConfig?: (google.cloud.dialogflow.v2.IInputAudioConfig|null);

                    /** QueryInput text */
                    text?: (google.cloud.dialogflow.v2.ITextInput|null);

                    /** QueryInput event */
                    event?: (google.cloud.dialogflow.v2.IEventInput|null);
                }

                /** Represents a QueryInput. */
                class QueryInput implements IQueryInput {

                    /**
                     * Constructs a new QueryInput.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IQueryInput);

                    /** QueryInput audioConfig. */
                    public audioConfig?: (google.cloud.dialogflow.v2.IInputAudioConfig|null);

                    /** QueryInput text. */
                    public text?: (google.cloud.dialogflow.v2.ITextInput|null);

                    /** QueryInput event. */
                    public event?: (google.cloud.dialogflow.v2.IEventInput|null);

                    /** QueryInput input. */
                    public input?: ("audioConfig"|"text"|"event");

                    /**
                     * Creates a new QueryInput instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns QueryInput instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IQueryInput): google.cloud.dialogflow.v2.QueryInput;

                    /**
                     * Encodes the specified QueryInput message. Does not implicitly {@link google.cloud.dialogflow.v2.QueryInput.verify|verify} messages.
                     * @param message QueryInput message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IQueryInput, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified QueryInput message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.QueryInput.verify|verify} messages.
                     * @param message QueryInput message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IQueryInput, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a QueryInput message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns QueryInput
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.QueryInput;

                    /**
                     * Decodes a QueryInput message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns QueryInput
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.QueryInput;

                    /**
                     * Verifies a QueryInput message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a QueryInput message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns QueryInput
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.QueryInput;

                    /**
                     * Creates a plain object from a QueryInput message. Also converts values to other types if specified.
                     * @param message QueryInput
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.QueryInput, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this QueryInput to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a QueryResult. */
                interface IQueryResult {

                    /** QueryResult queryText */
                    queryText?: (string|null);

                    /** QueryResult languageCode */
                    languageCode?: (string|null);

                    /** QueryResult speechRecognitionConfidence */
                    speechRecognitionConfidence?: (number|null);

                    /** QueryResult action */
                    action?: (string|null);

                    /** QueryResult parameters */
                    parameters?: (google.protobuf.IStruct|null);

                    /** QueryResult allRequiredParamsPresent */
                    allRequiredParamsPresent?: (boolean|null);

                    /** QueryResult cancelsSlotFilling */
                    cancelsSlotFilling?: (boolean|null);

                    /** QueryResult fulfillmentText */
                    fulfillmentText?: (string|null);

                    /** QueryResult fulfillmentMessages */
                    fulfillmentMessages?: (google.cloud.dialogflow.v2.Intent.IMessage[]|null);

                    /** QueryResult webhookSource */
                    webhookSource?: (string|null);

                    /** QueryResult webhookPayload */
                    webhookPayload?: (google.protobuf.IStruct|null);

                    /** QueryResult outputContexts */
                    outputContexts?: (google.cloud.dialogflow.v2.IContext[]|null);

                    /** QueryResult intent */
                    intent?: (google.cloud.dialogflow.v2.IIntent|null);

                    /** QueryResult intentDetectionConfidence */
                    intentDetectionConfidence?: (number|null);

                    /** QueryResult diagnosticInfo */
                    diagnosticInfo?: (google.protobuf.IStruct|null);

                    /** QueryResult sentimentAnalysisResult */
                    sentimentAnalysisResult?: (google.cloud.dialogflow.v2.ISentimentAnalysisResult|null);
                }

                /** Represents a QueryResult. */
                class QueryResult implements IQueryResult {

                    /**
                     * Constructs a new QueryResult.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IQueryResult);

                    /** QueryResult queryText. */
                    public queryText: string;

                    /** QueryResult languageCode. */
                    public languageCode: string;

                    /** QueryResult speechRecognitionConfidence. */
                    public speechRecognitionConfidence: number;

                    /** QueryResult action. */
                    public action: string;

                    /** QueryResult parameters. */
                    public parameters?: (google.protobuf.IStruct|null);

                    /** QueryResult allRequiredParamsPresent. */
                    public allRequiredParamsPresent: boolean;

                    /** QueryResult cancelsSlotFilling. */
                    public cancelsSlotFilling: boolean;

                    /** QueryResult fulfillmentText. */
                    public fulfillmentText: string;

                    /** QueryResult fulfillmentMessages. */
                    public fulfillmentMessages: google.cloud.dialogflow.v2.Intent.IMessage[];

                    /** QueryResult webhookSource. */
                    public webhookSource: string;

                    /** QueryResult webhookPayload. */
                    public webhookPayload?: (google.protobuf.IStruct|null);

                    /** QueryResult outputContexts. */
                    public outputContexts: google.cloud.dialogflow.v2.IContext[];

                    /** QueryResult intent. */
                    public intent?: (google.cloud.dialogflow.v2.IIntent|null);

                    /** QueryResult intentDetectionConfidence. */
                    public intentDetectionConfidence: number;

                    /** QueryResult diagnosticInfo. */
                    public diagnosticInfo?: (google.protobuf.IStruct|null);

                    /** QueryResult sentimentAnalysisResult. */
                    public sentimentAnalysisResult?: (google.cloud.dialogflow.v2.ISentimentAnalysisResult|null);

                    /**
                     * Creates a new QueryResult instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns QueryResult instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IQueryResult): google.cloud.dialogflow.v2.QueryResult;

                    /**
                     * Encodes the specified QueryResult message. Does not implicitly {@link google.cloud.dialogflow.v2.QueryResult.verify|verify} messages.
                     * @param message QueryResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IQueryResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified QueryResult message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.QueryResult.verify|verify} messages.
                     * @param message QueryResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IQueryResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a QueryResult message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns QueryResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.QueryResult;

                    /**
                     * Decodes a QueryResult message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns QueryResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.QueryResult;

                    /**
                     * Verifies a QueryResult message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a QueryResult message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns QueryResult
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.QueryResult;

                    /**
                     * Creates a plain object from a QueryResult message. Also converts values to other types if specified.
                     * @param message QueryResult
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.QueryResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this QueryResult to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a StreamingDetectIntentRequest. */
                interface IStreamingDetectIntentRequest {

                    /** StreamingDetectIntentRequest session */
                    session?: (string|null);

                    /** StreamingDetectIntentRequest queryParams */
                    queryParams?: (google.cloud.dialogflow.v2.IQueryParameters|null);

                    /** StreamingDetectIntentRequest queryInput */
                    queryInput?: (google.cloud.dialogflow.v2.IQueryInput|null);

                    /** StreamingDetectIntentRequest singleUtterance */
                    singleUtterance?: (boolean|null);

                    /** StreamingDetectIntentRequest outputAudioConfig */
                    outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** StreamingDetectIntentRequest outputAudioConfigMask */
                    outputAudioConfigMask?: (google.protobuf.IFieldMask|null);

                    /** StreamingDetectIntentRequest inputAudio */
                    inputAudio?: (Uint8Array|string|null);
                }

                /** Represents a StreamingDetectIntentRequest. */
                class StreamingDetectIntentRequest implements IStreamingDetectIntentRequest {

                    /**
                     * Constructs a new StreamingDetectIntentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IStreamingDetectIntentRequest);

                    /** StreamingDetectIntentRequest session. */
                    public session: string;

                    /** StreamingDetectIntentRequest queryParams. */
                    public queryParams?: (google.cloud.dialogflow.v2.IQueryParameters|null);

                    /** StreamingDetectIntentRequest queryInput. */
                    public queryInput?: (google.cloud.dialogflow.v2.IQueryInput|null);

                    /** StreamingDetectIntentRequest singleUtterance. */
                    public singleUtterance: boolean;

                    /** StreamingDetectIntentRequest outputAudioConfig. */
                    public outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /** StreamingDetectIntentRequest outputAudioConfigMask. */
                    public outputAudioConfigMask?: (google.protobuf.IFieldMask|null);

                    /** StreamingDetectIntentRequest inputAudio. */
                    public inputAudio: (Uint8Array|string);

                    /**
                     * Creates a new StreamingDetectIntentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns StreamingDetectIntentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IStreamingDetectIntentRequest): google.cloud.dialogflow.v2.StreamingDetectIntentRequest;

                    /**
                     * Encodes the specified StreamingDetectIntentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.StreamingDetectIntentRequest.verify|verify} messages.
                     * @param message StreamingDetectIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IStreamingDetectIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified StreamingDetectIntentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.StreamingDetectIntentRequest.verify|verify} messages.
                     * @param message StreamingDetectIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IStreamingDetectIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a StreamingDetectIntentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns StreamingDetectIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.StreamingDetectIntentRequest;

                    /**
                     * Decodes a StreamingDetectIntentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns StreamingDetectIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.StreamingDetectIntentRequest;

                    /**
                     * Verifies a StreamingDetectIntentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a StreamingDetectIntentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns StreamingDetectIntentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.StreamingDetectIntentRequest;

                    /**
                     * Creates a plain object from a StreamingDetectIntentRequest message. Also converts values to other types if specified.
                     * @param message StreamingDetectIntentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.StreamingDetectIntentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this StreamingDetectIntentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a StreamingDetectIntentResponse. */
                interface IStreamingDetectIntentResponse {

                    /** StreamingDetectIntentResponse responseId */
                    responseId?: (string|null);

                    /** StreamingDetectIntentResponse recognitionResult */
                    recognitionResult?: (google.cloud.dialogflow.v2.IStreamingRecognitionResult|null);

                    /** StreamingDetectIntentResponse queryResult */
                    queryResult?: (google.cloud.dialogflow.v2.IQueryResult|null);

                    /** StreamingDetectIntentResponse webhookStatus */
                    webhookStatus?: (google.rpc.IStatus|null);

                    /** StreamingDetectIntentResponse outputAudio */
                    outputAudio?: (Uint8Array|string|null);

                    /** StreamingDetectIntentResponse outputAudioConfig */
                    outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);
                }

                /** Represents a StreamingDetectIntentResponse. */
                class StreamingDetectIntentResponse implements IStreamingDetectIntentResponse {

                    /**
                     * Constructs a new StreamingDetectIntentResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IStreamingDetectIntentResponse);

                    /** StreamingDetectIntentResponse responseId. */
                    public responseId: string;

                    /** StreamingDetectIntentResponse recognitionResult. */
                    public recognitionResult?: (google.cloud.dialogflow.v2.IStreamingRecognitionResult|null);

                    /** StreamingDetectIntentResponse queryResult. */
                    public queryResult?: (google.cloud.dialogflow.v2.IQueryResult|null);

                    /** StreamingDetectIntentResponse webhookStatus. */
                    public webhookStatus?: (google.rpc.IStatus|null);

                    /** StreamingDetectIntentResponse outputAudio. */
                    public outputAudio: (Uint8Array|string);

                    /** StreamingDetectIntentResponse outputAudioConfig. */
                    public outputAudioConfig?: (google.cloud.dialogflow.v2.IOutputAudioConfig|null);

                    /**
                     * Creates a new StreamingDetectIntentResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns StreamingDetectIntentResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IStreamingDetectIntentResponse): google.cloud.dialogflow.v2.StreamingDetectIntentResponse;

                    /**
                     * Encodes the specified StreamingDetectIntentResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.StreamingDetectIntentResponse.verify|verify} messages.
                     * @param message StreamingDetectIntentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IStreamingDetectIntentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified StreamingDetectIntentResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.StreamingDetectIntentResponse.verify|verify} messages.
                     * @param message StreamingDetectIntentResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IStreamingDetectIntentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a StreamingDetectIntentResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns StreamingDetectIntentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.StreamingDetectIntentResponse;

                    /**
                     * Decodes a StreamingDetectIntentResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns StreamingDetectIntentResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.StreamingDetectIntentResponse;

                    /**
                     * Verifies a StreamingDetectIntentResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a StreamingDetectIntentResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns StreamingDetectIntentResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.StreamingDetectIntentResponse;

                    /**
                     * Creates a plain object from a StreamingDetectIntentResponse message. Also converts values to other types if specified.
                     * @param message StreamingDetectIntentResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.StreamingDetectIntentResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this StreamingDetectIntentResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a StreamingRecognitionResult. */
                interface IStreamingRecognitionResult {

                    /** StreamingRecognitionResult messageType */
                    messageType?: (google.cloud.dialogflow.v2.StreamingRecognitionResult.MessageType|keyof typeof google.cloud.dialogflow.v2.StreamingRecognitionResult.MessageType|null);

                    /** StreamingRecognitionResult transcript */
                    transcript?: (string|null);

                    /** StreamingRecognitionResult isFinal */
                    isFinal?: (boolean|null);

                    /** StreamingRecognitionResult confidence */
                    confidence?: (number|null);

                    /** StreamingRecognitionResult speechWordInfo */
                    speechWordInfo?: (google.cloud.dialogflow.v2.ISpeechWordInfo[]|null);

                    /** StreamingRecognitionResult speechEndOffset */
                    speechEndOffset?: (google.protobuf.IDuration|null);

                    /** StreamingRecognitionResult languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a StreamingRecognitionResult. */
                class StreamingRecognitionResult implements IStreamingRecognitionResult {

                    /**
                     * Constructs a new StreamingRecognitionResult.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IStreamingRecognitionResult);

                    /** StreamingRecognitionResult messageType. */
                    public messageType: (google.cloud.dialogflow.v2.StreamingRecognitionResult.MessageType|keyof typeof google.cloud.dialogflow.v2.StreamingRecognitionResult.MessageType);

                    /** StreamingRecognitionResult transcript. */
                    public transcript: string;

                    /** StreamingRecognitionResult isFinal. */
                    public isFinal: boolean;

                    /** StreamingRecognitionResult confidence. */
                    public confidence: number;

                    /** StreamingRecognitionResult speechWordInfo. */
                    public speechWordInfo: google.cloud.dialogflow.v2.ISpeechWordInfo[];

                    /** StreamingRecognitionResult speechEndOffset. */
                    public speechEndOffset?: (google.protobuf.IDuration|null);

                    /** StreamingRecognitionResult languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new StreamingRecognitionResult instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns StreamingRecognitionResult instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IStreamingRecognitionResult): google.cloud.dialogflow.v2.StreamingRecognitionResult;

                    /**
                     * Encodes the specified StreamingRecognitionResult message. Does not implicitly {@link google.cloud.dialogflow.v2.StreamingRecognitionResult.verify|verify} messages.
                     * @param message StreamingRecognitionResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IStreamingRecognitionResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified StreamingRecognitionResult message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.StreamingRecognitionResult.verify|verify} messages.
                     * @param message StreamingRecognitionResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IStreamingRecognitionResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a StreamingRecognitionResult message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns StreamingRecognitionResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.StreamingRecognitionResult;

                    /**
                     * Decodes a StreamingRecognitionResult message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns StreamingRecognitionResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.StreamingRecognitionResult;

                    /**
                     * Verifies a StreamingRecognitionResult message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a StreamingRecognitionResult message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns StreamingRecognitionResult
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.StreamingRecognitionResult;

                    /**
                     * Creates a plain object from a StreamingRecognitionResult message. Also converts values to other types if specified.
                     * @param message StreamingRecognitionResult
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.StreamingRecognitionResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this StreamingRecognitionResult to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace StreamingRecognitionResult {

                    /** MessageType enum. */
                    enum MessageType {
                        MESSAGE_TYPE_UNSPECIFIED = 0,
                        TRANSCRIPT = 1,
                        END_OF_SINGLE_UTTERANCE = 2
                    }
                }

                /** Properties of a TextInput. */
                interface ITextInput {

                    /** TextInput text */
                    text?: (string|null);

                    /** TextInput languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a TextInput. */
                class TextInput implements ITextInput {

                    /**
                     * Constructs a new TextInput.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ITextInput);

                    /** TextInput text. */
                    public text: string;

                    /** TextInput languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new TextInput instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns TextInput instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ITextInput): google.cloud.dialogflow.v2.TextInput;

                    /**
                     * Encodes the specified TextInput message. Does not implicitly {@link google.cloud.dialogflow.v2.TextInput.verify|verify} messages.
                     * @param message TextInput message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ITextInput, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified TextInput message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.TextInput.verify|verify} messages.
                     * @param message TextInput message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ITextInput, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a TextInput message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns TextInput
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.TextInput;

                    /**
                     * Decodes a TextInput message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns TextInput
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.TextInput;

                    /**
                     * Verifies a TextInput message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a TextInput message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns TextInput
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.TextInput;

                    /**
                     * Creates a plain object from a TextInput message. Also converts values to other types if specified.
                     * @param message TextInput
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.TextInput, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this TextInput to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an EventInput. */
                interface IEventInput {

                    /** EventInput name */
                    name?: (string|null);

                    /** EventInput parameters */
                    parameters?: (google.protobuf.IStruct|null);

                    /** EventInput languageCode */
                    languageCode?: (string|null);
                }

                /** Represents an EventInput. */
                class EventInput implements IEventInput {

                    /**
                     * Constructs a new EventInput.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IEventInput);

                    /** EventInput name. */
                    public name: string;

                    /** EventInput parameters. */
                    public parameters?: (google.protobuf.IStruct|null);

                    /** EventInput languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new EventInput instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EventInput instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IEventInput): google.cloud.dialogflow.v2.EventInput;

                    /**
                     * Encodes the specified EventInput message. Does not implicitly {@link google.cloud.dialogflow.v2.EventInput.verify|verify} messages.
                     * @param message EventInput message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IEventInput, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EventInput message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.EventInput.verify|verify} messages.
                     * @param message EventInput message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IEventInput, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EventInput message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EventInput
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.EventInput;

                    /**
                     * Decodes an EventInput message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EventInput
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.EventInput;

                    /**
                     * Verifies an EventInput message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EventInput message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EventInput
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.EventInput;

                    /**
                     * Creates a plain object from an EventInput message. Also converts values to other types if specified.
                     * @param message EventInput
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.EventInput, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EventInput to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SentimentAnalysisRequestConfig. */
                interface ISentimentAnalysisRequestConfig {

                    /** SentimentAnalysisRequestConfig analyzeQueryTextSentiment */
                    analyzeQueryTextSentiment?: (boolean|null);
                }

                /** Represents a SentimentAnalysisRequestConfig. */
                class SentimentAnalysisRequestConfig implements ISentimentAnalysisRequestConfig {

                    /**
                     * Constructs a new SentimentAnalysisRequestConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISentimentAnalysisRequestConfig);

                    /** SentimentAnalysisRequestConfig analyzeQueryTextSentiment. */
                    public analyzeQueryTextSentiment: boolean;

                    /**
                     * Creates a new SentimentAnalysisRequestConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SentimentAnalysisRequestConfig instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISentimentAnalysisRequestConfig): google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig;

                    /**
                     * Encodes the specified SentimentAnalysisRequestConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.verify|verify} messages.
                     * @param message SentimentAnalysisRequestConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISentimentAnalysisRequestConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SentimentAnalysisRequestConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig.verify|verify} messages.
                     * @param message SentimentAnalysisRequestConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISentimentAnalysisRequestConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SentimentAnalysisRequestConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SentimentAnalysisRequestConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig;

                    /**
                     * Decodes a SentimentAnalysisRequestConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SentimentAnalysisRequestConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig;

                    /**
                     * Verifies a SentimentAnalysisRequestConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SentimentAnalysisRequestConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SentimentAnalysisRequestConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig;

                    /**
                     * Creates a plain object from a SentimentAnalysisRequestConfig message. Also converts values to other types if specified.
                     * @param message SentimentAnalysisRequestConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SentimentAnalysisRequestConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a SentimentAnalysisResult. */
                interface ISentimentAnalysisResult {

                    /** SentimentAnalysisResult queryTextSentiment */
                    queryTextSentiment?: (google.cloud.dialogflow.v2.ISentiment|null);
                }

                /** Represents a SentimentAnalysisResult. */
                class SentimentAnalysisResult implements ISentimentAnalysisResult {

                    /**
                     * Constructs a new SentimentAnalysisResult.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISentimentAnalysisResult);

                    /** SentimentAnalysisResult queryTextSentiment. */
                    public queryTextSentiment?: (google.cloud.dialogflow.v2.ISentiment|null);

                    /**
                     * Creates a new SentimentAnalysisResult instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SentimentAnalysisResult instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISentimentAnalysisResult): google.cloud.dialogflow.v2.SentimentAnalysisResult;

                    /**
                     * Encodes the specified SentimentAnalysisResult message. Does not implicitly {@link google.cloud.dialogflow.v2.SentimentAnalysisResult.verify|verify} messages.
                     * @param message SentimentAnalysisResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISentimentAnalysisResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SentimentAnalysisResult message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SentimentAnalysisResult.verify|verify} messages.
                     * @param message SentimentAnalysisResult message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISentimentAnalysisResult, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SentimentAnalysisResult message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SentimentAnalysisResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SentimentAnalysisResult;

                    /**
                     * Decodes a SentimentAnalysisResult message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SentimentAnalysisResult
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SentimentAnalysisResult;

                    /**
                     * Verifies a SentimentAnalysisResult message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SentimentAnalysisResult message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SentimentAnalysisResult
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SentimentAnalysisResult;

                    /**
                     * Creates a plain object from a SentimentAnalysisResult message. Also converts values to other types if specified.
                     * @param message SentimentAnalysisResult
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SentimentAnalysisResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SentimentAnalysisResult to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a Sentiment. */
                interface ISentiment {

                    /** Sentiment score */
                    score?: (number|null);

                    /** Sentiment magnitude */
                    magnitude?: (number|null);
                }

                /** Represents a Sentiment. */
                class Sentiment implements ISentiment {

                    /**
                     * Constructs a new Sentiment.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISentiment);

                    /** Sentiment score. */
                    public score: number;

                    /** Sentiment magnitude. */
                    public magnitude: number;

                    /**
                     * Creates a new Sentiment instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Sentiment instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISentiment): google.cloud.dialogflow.v2.Sentiment;

                    /**
                     * Encodes the specified Sentiment message. Does not implicitly {@link google.cloud.dialogflow.v2.Sentiment.verify|verify} messages.
                     * @param message Sentiment message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISentiment, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Sentiment message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Sentiment.verify|verify} messages.
                     * @param message Sentiment message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISentiment, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Sentiment message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Sentiment
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Sentiment;

                    /**
                     * Decodes a Sentiment message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Sentiment
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Sentiment;

                    /**
                     * Verifies a Sentiment message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Sentiment message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Sentiment
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Sentiment;

                    /**
                     * Creates a plain object from a Sentiment message. Also converts values to other types if specified.
                     * @param message Sentiment
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.Sentiment, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Sentiment to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents a Contexts */
                class Contexts extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new Contexts service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new Contexts service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Contexts;

                    /**
                     * Calls ListContexts.
                     * @param request ListContextsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListContextsResponse
                     */
                    public listContexts(request: google.cloud.dialogflow.v2.IListContextsRequest, callback: google.cloud.dialogflow.v2.Contexts.ListContextsCallback): void;

                    /**
                     * Calls ListContexts.
                     * @param request ListContextsRequest message or plain object
                     * @returns Promise
                     */
                    public listContexts(request: google.cloud.dialogflow.v2.IListContextsRequest): Promise<google.cloud.dialogflow.v2.ListContextsResponse>;

                    /**
                     * Calls GetContext.
                     * @param request GetContextRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Context
                     */
                    public getContext(request: google.cloud.dialogflow.v2.IGetContextRequest, callback: google.cloud.dialogflow.v2.Contexts.GetContextCallback): void;

                    /**
                     * Calls GetContext.
                     * @param request GetContextRequest message or plain object
                     * @returns Promise
                     */
                    public getContext(request: google.cloud.dialogflow.v2.IGetContextRequest): Promise<google.cloud.dialogflow.v2.Context>;

                    /**
                     * Calls CreateContext.
                     * @param request CreateContextRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Context
                     */
                    public createContext(request: google.cloud.dialogflow.v2.ICreateContextRequest, callback: google.cloud.dialogflow.v2.Contexts.CreateContextCallback): void;

                    /**
                     * Calls CreateContext.
                     * @param request CreateContextRequest message or plain object
                     * @returns Promise
                     */
                    public createContext(request: google.cloud.dialogflow.v2.ICreateContextRequest): Promise<google.cloud.dialogflow.v2.Context>;

                    /**
                     * Calls UpdateContext.
                     * @param request UpdateContextRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Context
                     */
                    public updateContext(request: google.cloud.dialogflow.v2.IUpdateContextRequest, callback: google.cloud.dialogflow.v2.Contexts.UpdateContextCallback): void;

                    /**
                     * Calls UpdateContext.
                     * @param request UpdateContextRequest message or plain object
                     * @returns Promise
                     */
                    public updateContext(request: google.cloud.dialogflow.v2.IUpdateContextRequest): Promise<google.cloud.dialogflow.v2.Context>;

                    /**
                     * Calls DeleteContext.
                     * @param request DeleteContextRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteContext(request: google.cloud.dialogflow.v2.IDeleteContextRequest, callback: google.cloud.dialogflow.v2.Contexts.DeleteContextCallback): void;

                    /**
                     * Calls DeleteContext.
                     * @param request DeleteContextRequest message or plain object
                     * @returns Promise
                     */
                    public deleteContext(request: google.cloud.dialogflow.v2.IDeleteContextRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls DeleteAllContexts.
                     * @param request DeleteAllContextsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteAllContexts(request: google.cloud.dialogflow.v2.IDeleteAllContextsRequest, callback: google.cloud.dialogflow.v2.Contexts.DeleteAllContextsCallback): void;

                    /**
                     * Calls DeleteAllContexts.
                     * @param request DeleteAllContextsRequest message or plain object
                     * @returns Promise
                     */
                    public deleteAllContexts(request: google.cloud.dialogflow.v2.IDeleteAllContextsRequest): Promise<google.protobuf.Empty>;
                }

                namespace Contexts {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Contexts#listContexts}.
                     * @param error Error, if any
                     * @param [response] ListContextsResponse
                     */
                    type ListContextsCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListContextsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Contexts#getContext}.
                     * @param error Error, if any
                     * @param [response] Context
                     */
                    type GetContextCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Context) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Contexts#createContext}.
                     * @param error Error, if any
                     * @param [response] Context
                     */
                    type CreateContextCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Context) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Contexts#updateContext}.
                     * @param error Error, if any
                     * @param [response] Context
                     */
                    type UpdateContextCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Context) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Contexts#deleteContext}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteContextCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Contexts#deleteAllContexts}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteAllContextsCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;
                }

                /** Properties of a Context. */
                interface IContext {

                    /** Context name */
                    name?: (string|null);

                    /** Context lifespanCount */
                    lifespanCount?: (number|null);

                    /** Context parameters */
                    parameters?: (google.protobuf.IStruct|null);
                }

                /** Represents a Context. */
                class Context implements IContext {

                    /**
                     * Constructs a new Context.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IContext);

                    /** Context name. */
                    public name: string;

                    /** Context lifespanCount. */
                    public lifespanCount: number;

                    /** Context parameters. */
                    public parameters?: (google.protobuf.IStruct|null);

                    /**
                     * Creates a new Context instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Context instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IContext): google.cloud.dialogflow.v2.Context;

                    /**
                     * Encodes the specified Context message. Does not implicitly {@link google.cloud.dialogflow.v2.Context.verify|verify} messages.
                     * @param message Context message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Context message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Context.verify|verify} messages.
                     * @param message Context message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IContext, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Context message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Context
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Context;

                    /**
                     * Decodes a Context message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Context
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Context;

                    /**
                     * Verifies a Context message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Context message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Context
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Context;

                    /**
                     * Creates a plain object from a Context message. Also converts values to other types if specified.
                     * @param message Context
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.Context, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Context to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListContextsRequest. */
                interface IListContextsRequest {

                    /** ListContextsRequest parent */
                    parent?: (string|null);

                    /** ListContextsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListContextsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListContextsRequest. */
                class ListContextsRequest implements IListContextsRequest {

                    /**
                     * Constructs a new ListContextsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListContextsRequest);

                    /** ListContextsRequest parent. */
                    public parent: string;

                    /** ListContextsRequest pageSize. */
                    public pageSize: number;

                    /** ListContextsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListContextsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListContextsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListContextsRequest): google.cloud.dialogflow.v2.ListContextsRequest;

                    /**
                     * Encodes the specified ListContextsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListContextsRequest.verify|verify} messages.
                     * @param message ListContextsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListContextsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListContextsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListContextsRequest.verify|verify} messages.
                     * @param message ListContextsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListContextsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListContextsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListContextsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListContextsRequest;

                    /**
                     * Decodes a ListContextsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListContextsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListContextsRequest;

                    /**
                     * Verifies a ListContextsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListContextsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListContextsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListContextsRequest;

                    /**
                     * Creates a plain object from a ListContextsRequest message. Also converts values to other types if specified.
                     * @param message ListContextsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListContextsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListContextsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListContextsResponse. */
                interface IListContextsResponse {

                    /** ListContextsResponse contexts */
                    contexts?: (google.cloud.dialogflow.v2.IContext[]|null);

                    /** ListContextsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListContextsResponse. */
                class ListContextsResponse implements IListContextsResponse {

                    /**
                     * Constructs a new ListContextsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListContextsResponse);

                    /** ListContextsResponse contexts. */
                    public contexts: google.cloud.dialogflow.v2.IContext[];

                    /** ListContextsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListContextsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListContextsResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListContextsResponse): google.cloud.dialogflow.v2.ListContextsResponse;

                    /**
                     * Encodes the specified ListContextsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListContextsResponse.verify|verify} messages.
                     * @param message ListContextsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListContextsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListContextsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListContextsResponse.verify|verify} messages.
                     * @param message ListContextsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListContextsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListContextsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListContextsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListContextsResponse;

                    /**
                     * Decodes a ListContextsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListContextsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListContextsResponse;

                    /**
                     * Verifies a ListContextsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListContextsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListContextsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListContextsResponse;

                    /**
                     * Creates a plain object from a ListContextsResponse message. Also converts values to other types if specified.
                     * @param message ListContextsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListContextsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListContextsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetContextRequest. */
                interface IGetContextRequest {

                    /** GetContextRequest name */
                    name?: (string|null);
                }

                /** Represents a GetContextRequest. */
                class GetContextRequest implements IGetContextRequest {

                    /**
                     * Constructs a new GetContextRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetContextRequest);

                    /** GetContextRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetContextRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetContextRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetContextRequest): google.cloud.dialogflow.v2.GetContextRequest;

                    /**
                     * Encodes the specified GetContextRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetContextRequest.verify|verify} messages.
                     * @param message GetContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetContextRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetContextRequest.verify|verify} messages.
                     * @param message GetContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetContextRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetContextRequest;

                    /**
                     * Decodes a GetContextRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetContextRequest;

                    /**
                     * Verifies a GetContextRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetContextRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetContextRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetContextRequest;

                    /**
                     * Creates a plain object from a GetContextRequest message. Also converts values to other types if specified.
                     * @param message GetContextRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetContextRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetContextRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a CreateContextRequest. */
                interface ICreateContextRequest {

                    /** CreateContextRequest parent */
                    parent?: (string|null);

                    /** CreateContextRequest context */
                    context?: (google.cloud.dialogflow.v2.IContext|null);
                }

                /** Represents a CreateContextRequest. */
                class CreateContextRequest implements ICreateContextRequest {

                    /**
                     * Constructs a new CreateContextRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICreateContextRequest);

                    /** CreateContextRequest parent. */
                    public parent: string;

                    /** CreateContextRequest context. */
                    public context?: (google.cloud.dialogflow.v2.IContext|null);

                    /**
                     * Creates a new CreateContextRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateContextRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICreateContextRequest): google.cloud.dialogflow.v2.CreateContextRequest;

                    /**
                     * Encodes the specified CreateContextRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateContextRequest.verify|verify} messages.
                     * @param message CreateContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICreateContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateContextRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateContextRequest.verify|verify} messages.
                     * @param message CreateContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICreateContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateContextRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CreateContextRequest;

                    /**
                     * Decodes a CreateContextRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CreateContextRequest;

                    /**
                     * Verifies a CreateContextRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateContextRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateContextRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CreateContextRequest;

                    /**
                     * Creates a plain object from a CreateContextRequest message. Also converts values to other types if specified.
                     * @param message CreateContextRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CreateContextRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateContextRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an UpdateContextRequest. */
                interface IUpdateContextRequest {

                    /** UpdateContextRequest context */
                    context?: (google.cloud.dialogflow.v2.IContext|null);

                    /** UpdateContextRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateContextRequest. */
                class UpdateContextRequest implements IUpdateContextRequest {

                    /**
                     * Constructs a new UpdateContextRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IUpdateContextRequest);

                    /** UpdateContextRequest context. */
                    public context?: (google.cloud.dialogflow.v2.IContext|null);

                    /** UpdateContextRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateContextRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateContextRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IUpdateContextRequest): google.cloud.dialogflow.v2.UpdateContextRequest;

                    /**
                     * Encodes the specified UpdateContextRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateContextRequest.verify|verify} messages.
                     * @param message UpdateContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IUpdateContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateContextRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateContextRequest.verify|verify} messages.
                     * @param message UpdateContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IUpdateContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateContextRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.UpdateContextRequest;

                    /**
                     * Decodes an UpdateContextRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.UpdateContextRequest;

                    /**
                     * Verifies an UpdateContextRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateContextRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateContextRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.UpdateContextRequest;

                    /**
                     * Creates a plain object from an UpdateContextRequest message. Also converts values to other types if specified.
                     * @param message UpdateContextRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.UpdateContextRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateContextRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DeleteContextRequest. */
                interface IDeleteContextRequest {

                    /** DeleteContextRequest name */
                    name?: (string|null);
                }

                /** Represents a DeleteContextRequest. */
                class DeleteContextRequest implements IDeleteContextRequest {

                    /**
                     * Constructs a new DeleteContextRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDeleteContextRequest);

                    /** DeleteContextRequest name. */
                    public name: string;

                    /**
                     * Creates a new DeleteContextRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteContextRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDeleteContextRequest): google.cloud.dialogflow.v2.DeleteContextRequest;

                    /**
                     * Encodes the specified DeleteContextRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteContextRequest.verify|verify} messages.
                     * @param message DeleteContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDeleteContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteContextRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteContextRequest.verify|verify} messages.
                     * @param message DeleteContextRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDeleteContextRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteContextRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DeleteContextRequest;

                    /**
                     * Decodes a DeleteContextRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteContextRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DeleteContextRequest;

                    /**
                     * Verifies a DeleteContextRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteContextRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteContextRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DeleteContextRequest;

                    /**
                     * Creates a plain object from a DeleteContextRequest message. Also converts values to other types if specified.
                     * @param message DeleteContextRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DeleteContextRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteContextRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DeleteAllContextsRequest. */
                interface IDeleteAllContextsRequest {

                    /** DeleteAllContextsRequest parent */
                    parent?: (string|null);
                }

                /** Represents a DeleteAllContextsRequest. */
                class DeleteAllContextsRequest implements IDeleteAllContextsRequest {

                    /**
                     * Constructs a new DeleteAllContextsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDeleteAllContextsRequest);

                    /** DeleteAllContextsRequest parent. */
                    public parent: string;

                    /**
                     * Creates a new DeleteAllContextsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteAllContextsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDeleteAllContextsRequest): google.cloud.dialogflow.v2.DeleteAllContextsRequest;

                    /**
                     * Encodes the specified DeleteAllContextsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteAllContextsRequest.verify|verify} messages.
                     * @param message DeleteAllContextsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDeleteAllContextsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteAllContextsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteAllContextsRequest.verify|verify} messages.
                     * @param message DeleteAllContextsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDeleteAllContextsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteAllContextsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteAllContextsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DeleteAllContextsRequest;

                    /**
                     * Decodes a DeleteAllContextsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteAllContextsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DeleteAllContextsRequest;

                    /**
                     * Verifies a DeleteAllContextsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteAllContextsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteAllContextsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DeleteAllContextsRequest;

                    /**
                     * Creates a plain object from a DeleteAllContextsRequest message. Also converts values to other types if specified.
                     * @param message DeleteAllContextsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DeleteAllContextsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteAllContextsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents an Intents */
                class Intents extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new Intents service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new Intents service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Intents;

                    /**
                     * Calls ListIntents.
                     * @param request ListIntentsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListIntentsResponse
                     */
                    public listIntents(request: google.cloud.dialogflow.v2.IListIntentsRequest, callback: google.cloud.dialogflow.v2.Intents.ListIntentsCallback): void;

                    /**
                     * Calls ListIntents.
                     * @param request ListIntentsRequest message or plain object
                     * @returns Promise
                     */
                    public listIntents(request: google.cloud.dialogflow.v2.IListIntentsRequest): Promise<google.cloud.dialogflow.v2.ListIntentsResponse>;

                    /**
                     * Calls GetIntent.
                     * @param request GetIntentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Intent
                     */
                    public getIntent(request: google.cloud.dialogflow.v2.IGetIntentRequest, callback: google.cloud.dialogflow.v2.Intents.GetIntentCallback): void;

                    /**
                     * Calls GetIntent.
                     * @param request GetIntentRequest message or plain object
                     * @returns Promise
                     */
                    public getIntent(request: google.cloud.dialogflow.v2.IGetIntentRequest): Promise<google.cloud.dialogflow.v2.Intent>;

                    /**
                     * Calls CreateIntent.
                     * @param request CreateIntentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Intent
                     */
                    public createIntent(request: google.cloud.dialogflow.v2.ICreateIntentRequest, callback: google.cloud.dialogflow.v2.Intents.CreateIntentCallback): void;

                    /**
                     * Calls CreateIntent.
                     * @param request CreateIntentRequest message or plain object
                     * @returns Promise
                     */
                    public createIntent(request: google.cloud.dialogflow.v2.ICreateIntentRequest): Promise<google.cloud.dialogflow.v2.Intent>;

                    /**
                     * Calls UpdateIntent.
                     * @param request UpdateIntentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Intent
                     */
                    public updateIntent(request: google.cloud.dialogflow.v2.IUpdateIntentRequest, callback: google.cloud.dialogflow.v2.Intents.UpdateIntentCallback): void;

                    /**
                     * Calls UpdateIntent.
                     * @param request UpdateIntentRequest message or plain object
                     * @returns Promise
                     */
                    public updateIntent(request: google.cloud.dialogflow.v2.IUpdateIntentRequest): Promise<google.cloud.dialogflow.v2.Intent>;

                    /**
                     * Calls DeleteIntent.
                     * @param request DeleteIntentRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteIntent(request: google.cloud.dialogflow.v2.IDeleteIntentRequest, callback: google.cloud.dialogflow.v2.Intents.DeleteIntentCallback): void;

                    /**
                     * Calls DeleteIntent.
                     * @param request DeleteIntentRequest message or plain object
                     * @returns Promise
                     */
                    public deleteIntent(request: google.cloud.dialogflow.v2.IDeleteIntentRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls BatchUpdateIntents.
                     * @param request BatchUpdateIntentsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchUpdateIntents(request: google.cloud.dialogflow.v2.IBatchUpdateIntentsRequest, callback: google.cloud.dialogflow.v2.Intents.BatchUpdateIntentsCallback): void;

                    /**
                     * Calls BatchUpdateIntents.
                     * @param request BatchUpdateIntentsRequest message or plain object
                     * @returns Promise
                     */
                    public batchUpdateIntents(request: google.cloud.dialogflow.v2.IBatchUpdateIntentsRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls BatchDeleteIntents.
                     * @param request BatchDeleteIntentsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchDeleteIntents(request: google.cloud.dialogflow.v2.IBatchDeleteIntentsRequest, callback: google.cloud.dialogflow.v2.Intents.BatchDeleteIntentsCallback): void;

                    /**
                     * Calls BatchDeleteIntents.
                     * @param request BatchDeleteIntentsRequest message or plain object
                     * @returns Promise
                     */
                    public batchDeleteIntents(request: google.cloud.dialogflow.v2.IBatchDeleteIntentsRequest): Promise<google.longrunning.Operation>;
                }

                namespace Intents {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Intents#listIntents}.
                     * @param error Error, if any
                     * @param [response] ListIntentsResponse
                     */
                    type ListIntentsCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListIntentsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Intents#getIntent}.
                     * @param error Error, if any
                     * @param [response] Intent
                     */
                    type GetIntentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Intent) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Intents#createIntent}.
                     * @param error Error, if any
                     * @param [response] Intent
                     */
                    type CreateIntentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Intent) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Intents#updateIntent}.
                     * @param error Error, if any
                     * @param [response] Intent
                     */
                    type UpdateIntentCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Intent) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Intents#deleteIntent}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteIntentCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Intents#batchUpdateIntents}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchUpdateIntentsCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Intents#batchDeleteIntents}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchDeleteIntentsCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;
                }

                /** Properties of an Intent. */
                interface IIntent {

                    /** Intent name */
                    name?: (string|null);

                    /** Intent displayName */
                    displayName?: (string|null);

                    /** Intent webhookState */
                    webhookState?: (google.cloud.dialogflow.v2.Intent.WebhookState|keyof typeof google.cloud.dialogflow.v2.Intent.WebhookState|null);

                    /** Intent priority */
                    priority?: (number|null);

                    /** Intent isFallback */
                    isFallback?: (boolean|null);

                    /** Intent mlDisabled */
                    mlDisabled?: (boolean|null);

                    /** Intent liveAgentHandoff */
                    liveAgentHandoff?: (boolean|null);

                    /** Intent endInteraction */
                    endInteraction?: (boolean|null);

                    /** Intent inputContextNames */
                    inputContextNames?: (string[]|null);

                    /** Intent events */
                    events?: (string[]|null);

                    /** Intent trainingPhrases */
                    trainingPhrases?: (google.cloud.dialogflow.v2.Intent.ITrainingPhrase[]|null);

                    /** Intent action */
                    action?: (string|null);

                    /** Intent outputContexts */
                    outputContexts?: (google.cloud.dialogflow.v2.IContext[]|null);

                    /** Intent resetContexts */
                    resetContexts?: (boolean|null);

                    /** Intent parameters */
                    parameters?: (google.cloud.dialogflow.v2.Intent.IParameter[]|null);

                    /** Intent messages */
                    messages?: (google.cloud.dialogflow.v2.Intent.IMessage[]|null);

                    /** Intent defaultResponsePlatforms */
                    defaultResponsePlatforms?: (google.cloud.dialogflow.v2.Intent.Message.Platform[]|null);

                    /** Intent rootFollowupIntentName */
                    rootFollowupIntentName?: (string|null);

                    /** Intent parentFollowupIntentName */
                    parentFollowupIntentName?: (string|null);

                    /** Intent followupIntentInfo */
                    followupIntentInfo?: (google.cloud.dialogflow.v2.Intent.IFollowupIntentInfo[]|null);
                }

                /** Represents an Intent. */
                class Intent implements IIntent {

                    /**
                     * Constructs a new Intent.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IIntent);

                    /** Intent name. */
                    public name: string;

                    /** Intent displayName. */
                    public displayName: string;

                    /** Intent webhookState. */
                    public webhookState: (google.cloud.dialogflow.v2.Intent.WebhookState|keyof typeof google.cloud.dialogflow.v2.Intent.WebhookState);

                    /** Intent priority. */
                    public priority: number;

                    /** Intent isFallback. */
                    public isFallback: boolean;

                    /** Intent mlDisabled. */
                    public mlDisabled: boolean;

                    /** Intent liveAgentHandoff. */
                    public liveAgentHandoff: boolean;

                    /** Intent endInteraction. */
                    public endInteraction: boolean;

                    /** Intent inputContextNames. */
                    public inputContextNames: string[];

                    /** Intent events. */
                    public events: string[];

                    /** Intent trainingPhrases. */
                    public trainingPhrases: google.cloud.dialogflow.v2.Intent.ITrainingPhrase[];

                    /** Intent action. */
                    public action: string;

                    /** Intent outputContexts. */
                    public outputContexts: google.cloud.dialogflow.v2.IContext[];

                    /** Intent resetContexts. */
                    public resetContexts: boolean;

                    /** Intent parameters. */
                    public parameters: google.cloud.dialogflow.v2.Intent.IParameter[];

                    /** Intent messages. */
                    public messages: google.cloud.dialogflow.v2.Intent.IMessage[];

                    /** Intent defaultResponsePlatforms. */
                    public defaultResponsePlatforms: google.cloud.dialogflow.v2.Intent.Message.Platform[];

                    /** Intent rootFollowupIntentName. */
                    public rootFollowupIntentName: string;

                    /** Intent parentFollowupIntentName. */
                    public parentFollowupIntentName: string;

                    /** Intent followupIntentInfo. */
                    public followupIntentInfo: google.cloud.dialogflow.v2.Intent.IFollowupIntentInfo[];

                    /**
                     * Creates a new Intent instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Intent instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IIntent): google.cloud.dialogflow.v2.Intent;

                    /**
                     * Encodes the specified Intent message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.verify|verify} messages.
                     * @param message Intent message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IIntent, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Intent message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.verify|verify} messages.
                     * @param message Intent message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IIntent, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an Intent message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Intent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent;

                    /**
                     * Decodes an Intent message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Intent
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent;

                    /**
                     * Verifies an Intent message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an Intent message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Intent
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent;

                    /**
                     * Creates a plain object from an Intent message. Also converts values to other types if specified.
                     * @param message Intent
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.Intent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Intent to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace Intent {

                    /** WebhookState enum. */
                    enum WebhookState {
                        WEBHOOK_STATE_UNSPECIFIED = 0,
                        WEBHOOK_STATE_ENABLED = 1,
                        WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING = 2
                    }

                    /** Properties of a TrainingPhrase. */
                    interface ITrainingPhrase {

                        /** TrainingPhrase name */
                        name?: (string|null);

                        /** TrainingPhrase type */
                        type?: (google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type|keyof typeof google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type|null);

                        /** TrainingPhrase parts */
                        parts?: (google.cloud.dialogflow.v2.Intent.TrainingPhrase.IPart[]|null);

                        /** TrainingPhrase timesAddedCount */
                        timesAddedCount?: (number|null);
                    }

                    /** Represents a TrainingPhrase. */
                    class TrainingPhrase implements ITrainingPhrase {

                        /**
                         * Constructs a new TrainingPhrase.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.dialogflow.v2.Intent.ITrainingPhrase);

                        /** TrainingPhrase name. */
                        public name: string;

                        /** TrainingPhrase type. */
                        public type: (google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type|keyof typeof google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type);

                        /** TrainingPhrase parts. */
                        public parts: google.cloud.dialogflow.v2.Intent.TrainingPhrase.IPart[];

                        /** TrainingPhrase timesAddedCount. */
                        public timesAddedCount: number;

                        /**
                         * Creates a new TrainingPhrase instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns TrainingPhrase instance
                         */
                        public static create(properties?: google.cloud.dialogflow.v2.Intent.ITrainingPhrase): google.cloud.dialogflow.v2.Intent.TrainingPhrase;

                        /**
                         * Encodes the specified TrainingPhrase message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.TrainingPhrase.verify|verify} messages.
                         * @param message TrainingPhrase message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.dialogflow.v2.Intent.ITrainingPhrase, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified TrainingPhrase message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.TrainingPhrase.verify|verify} messages.
                         * @param message TrainingPhrase message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.ITrainingPhrase, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a TrainingPhrase message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns TrainingPhrase
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.TrainingPhrase;

                        /**
                         * Decodes a TrainingPhrase message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns TrainingPhrase
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.TrainingPhrase;

                        /**
                         * Verifies a TrainingPhrase message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a TrainingPhrase message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns TrainingPhrase
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.TrainingPhrase;

                        /**
                         * Creates a plain object from a TrainingPhrase message. Also converts values to other types if specified.
                         * @param message TrainingPhrase
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.dialogflow.v2.Intent.TrainingPhrase, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this TrainingPhrase to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    namespace TrainingPhrase {

                        /** Type enum. */
                        enum Type {
                            TYPE_UNSPECIFIED = 0,
                            EXAMPLE = 1,
                            TEMPLATE = 2
                        }

                        /** Properties of a Part. */
                        interface IPart {

                            /** Part text */
                            text?: (string|null);

                            /** Part entityType */
                            entityType?: (string|null);

                            /** Part alias */
                            alias?: (string|null);

                            /** Part userDefined */
                            userDefined?: (boolean|null);
                        }

                        /** Represents a Part. */
                        class Part implements IPart {

                            /**
                             * Constructs a new Part.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.TrainingPhrase.IPart);

                            /** Part text. */
                            public text: string;

                            /** Part entityType. */
                            public entityType: string;

                            /** Part alias. */
                            public alias: string;

                            /** Part userDefined. */
                            public userDefined: boolean;

                            /**
                             * Creates a new Part instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns Part instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.TrainingPhrase.IPart): google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part;

                            /**
                             * Encodes the specified Part message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.verify|verify} messages.
                             * @param message Part message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.TrainingPhrase.IPart, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified Part message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.verify|verify} messages.
                             * @param message Part message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.TrainingPhrase.IPart, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a Part message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns Part
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part;

                            /**
                             * Decodes a Part message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns Part
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part;

                            /**
                             * Verifies a Part message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a Part message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns Part
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part;

                            /**
                             * Creates a plain object from a Part message. Also converts values to other types if specified.
                             * @param message Part
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this Part to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }
                    }

                    /** Properties of a Parameter. */
                    interface IParameter {

                        /** Parameter name */
                        name?: (string|null);

                        /** Parameter displayName */
                        displayName?: (string|null);

                        /** Parameter value */
                        value?: (string|null);

                        /** Parameter defaultValue */
                        defaultValue?: (string|null);

                        /** Parameter entityTypeDisplayName */
                        entityTypeDisplayName?: (string|null);

                        /** Parameter mandatory */
                        mandatory?: (boolean|null);

                        /** Parameter prompts */
                        prompts?: (string[]|null);

                        /** Parameter isList */
                        isList?: (boolean|null);
                    }

                    /** Represents a Parameter. */
                    class Parameter implements IParameter {

                        /**
                         * Constructs a new Parameter.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.dialogflow.v2.Intent.IParameter);

                        /** Parameter name. */
                        public name: string;

                        /** Parameter displayName. */
                        public displayName: string;

                        /** Parameter value. */
                        public value: string;

                        /** Parameter defaultValue. */
                        public defaultValue: string;

                        /** Parameter entityTypeDisplayName. */
                        public entityTypeDisplayName: string;

                        /** Parameter mandatory. */
                        public mandatory: boolean;

                        /** Parameter prompts. */
                        public prompts: string[];

                        /** Parameter isList. */
                        public isList: boolean;

                        /**
                         * Creates a new Parameter instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Parameter instance
                         */
                        public static create(properties?: google.cloud.dialogflow.v2.Intent.IParameter): google.cloud.dialogflow.v2.Intent.Parameter;

                        /**
                         * Encodes the specified Parameter message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Parameter.verify|verify} messages.
                         * @param message Parameter message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.dialogflow.v2.Intent.IParameter, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Parameter message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Parameter.verify|verify} messages.
                         * @param message Parameter message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.IParameter, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Parameter message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Parameter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Parameter;

                        /**
                         * Decodes a Parameter message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Parameter
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Parameter;

                        /**
                         * Verifies a Parameter message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Parameter message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Parameter
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Parameter;

                        /**
                         * Creates a plain object from a Parameter message. Also converts values to other types if specified.
                         * @param message Parameter
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.dialogflow.v2.Intent.Parameter, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Parameter to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a Message. */
                    interface IMessage {

                        /** Message text */
                        text?: (google.cloud.dialogflow.v2.Intent.Message.IText|null);

                        /** Message image */
                        image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                        /** Message quickReplies */
                        quickReplies?: (google.cloud.dialogflow.v2.Intent.Message.IQuickReplies|null);

                        /** Message card */
                        card?: (google.cloud.dialogflow.v2.Intent.Message.ICard|null);

                        /** Message payload */
                        payload?: (google.protobuf.IStruct|null);

                        /** Message simpleResponses */
                        simpleResponses?: (google.cloud.dialogflow.v2.Intent.Message.ISimpleResponses|null);

                        /** Message basicCard */
                        basicCard?: (google.cloud.dialogflow.v2.Intent.Message.IBasicCard|null);

                        /** Message suggestions */
                        suggestions?: (google.cloud.dialogflow.v2.Intent.Message.ISuggestions|null);

                        /** Message linkOutSuggestion */
                        linkOutSuggestion?: (google.cloud.dialogflow.v2.Intent.Message.ILinkOutSuggestion|null);

                        /** Message listSelect */
                        listSelect?: (google.cloud.dialogflow.v2.Intent.Message.IListSelect|null);

                        /** Message carouselSelect */
                        carouselSelect?: (google.cloud.dialogflow.v2.Intent.Message.ICarouselSelect|null);

                        /** Message browseCarouselCard */
                        browseCarouselCard?: (google.cloud.dialogflow.v2.Intent.Message.IBrowseCarouselCard|null);

                        /** Message tableCard */
                        tableCard?: (google.cloud.dialogflow.v2.Intent.Message.ITableCard|null);

                        /** Message mediaContent */
                        mediaContent?: (google.cloud.dialogflow.v2.Intent.Message.IMediaContent|null);

                        /** Message platform */
                        platform?: (google.cloud.dialogflow.v2.Intent.Message.Platform|keyof typeof google.cloud.dialogflow.v2.Intent.Message.Platform|null);
                    }

                    /** Represents a Message. */
                    class Message implements IMessage {

                        /**
                         * Constructs a new Message.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.dialogflow.v2.Intent.IMessage);

                        /** Message text. */
                        public text?: (google.cloud.dialogflow.v2.Intent.Message.IText|null);

                        /** Message image. */
                        public image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                        /** Message quickReplies. */
                        public quickReplies?: (google.cloud.dialogflow.v2.Intent.Message.IQuickReplies|null);

                        /** Message card. */
                        public card?: (google.cloud.dialogflow.v2.Intent.Message.ICard|null);

                        /** Message payload. */
                        public payload?: (google.protobuf.IStruct|null);

                        /** Message simpleResponses. */
                        public simpleResponses?: (google.cloud.dialogflow.v2.Intent.Message.ISimpleResponses|null);

                        /** Message basicCard. */
                        public basicCard?: (google.cloud.dialogflow.v2.Intent.Message.IBasicCard|null);

                        /** Message suggestions. */
                        public suggestions?: (google.cloud.dialogflow.v2.Intent.Message.ISuggestions|null);

                        /** Message linkOutSuggestion. */
                        public linkOutSuggestion?: (google.cloud.dialogflow.v2.Intent.Message.ILinkOutSuggestion|null);

                        /** Message listSelect. */
                        public listSelect?: (google.cloud.dialogflow.v2.Intent.Message.IListSelect|null);

                        /** Message carouselSelect. */
                        public carouselSelect?: (google.cloud.dialogflow.v2.Intent.Message.ICarouselSelect|null);

                        /** Message browseCarouselCard. */
                        public browseCarouselCard?: (google.cloud.dialogflow.v2.Intent.Message.IBrowseCarouselCard|null);

                        /** Message tableCard. */
                        public tableCard?: (google.cloud.dialogflow.v2.Intent.Message.ITableCard|null);

                        /** Message mediaContent. */
                        public mediaContent?: (google.cloud.dialogflow.v2.Intent.Message.IMediaContent|null);

                        /** Message platform. */
                        public platform: (google.cloud.dialogflow.v2.Intent.Message.Platform|keyof typeof google.cloud.dialogflow.v2.Intent.Message.Platform);

                        /** Message message. */
                        public message?: ("text"|"image"|"quickReplies"|"card"|"payload"|"simpleResponses"|"basicCard"|"suggestions"|"linkOutSuggestion"|"listSelect"|"carouselSelect"|"browseCarouselCard"|"tableCard"|"mediaContent");

                        /**
                         * Creates a new Message instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Message instance
                         */
                        public static create(properties?: google.cloud.dialogflow.v2.Intent.IMessage): google.cloud.dialogflow.v2.Intent.Message;

                        /**
                         * Encodes the specified Message message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.verify|verify} messages.
                         * @param message Message message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.dialogflow.v2.Intent.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Message message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.verify|verify} messages.
                         * @param message Message message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Message message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Message
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message;

                        /**
                         * Decodes a Message message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Message
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message;

                        /**
                         * Verifies a Message message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Message message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Message
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message;

                        /**
                         * Creates a plain object from a Message message. Also converts values to other types if specified.
                         * @param message Message
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.dialogflow.v2.Intent.Message, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Message to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    namespace Message {

                        /** Platform enum. */
                        enum Platform {
                            PLATFORM_UNSPECIFIED = 0,
                            FACEBOOK = 1,
                            SLACK = 2,
                            TELEGRAM = 3,
                            KIK = 4,
                            SKYPE = 5,
                            LINE = 6,
                            VIBER = 7,
                            ACTIONS_ON_GOOGLE = 8,
                            GOOGLE_HANGOUTS = 11
                        }

                        /** Properties of a Text. */
                        interface IText {

                            /** Text text */
                            text?: (string[]|null);
                        }

                        /** Represents a Text. */
                        class Text implements IText {

                            /**
                             * Constructs a new Text.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IText);

                            /** Text text. */
                            public text: string[];

                            /**
                             * Creates a new Text instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns Text instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IText): google.cloud.dialogflow.v2.Intent.Message.Text;

                            /**
                             * Encodes the specified Text message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Text.verify|verify} messages.
                             * @param message Text message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IText, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified Text message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Text.verify|verify} messages.
                             * @param message Text message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IText, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a Text message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns Text
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.Text;

                            /**
                             * Decodes a Text message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns Text
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.Text;

                            /**
                             * Verifies a Text message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a Text message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns Text
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.Text;

                            /**
                             * Creates a plain object from a Text message. Also converts values to other types if specified.
                             * @param message Text
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.Text, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this Text to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of an Image. */
                        interface IImage {

                            /** Image imageUri */
                            imageUri?: (string|null);

                            /** Image accessibilityText */
                            accessibilityText?: (string|null);
                        }

                        /** Represents an Image. */
                        class Image implements IImage {

                            /**
                             * Constructs a new Image.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IImage);

                            /** Image imageUri. */
                            public imageUri: string;

                            /** Image accessibilityText. */
                            public accessibilityText: string;

                            /**
                             * Creates a new Image instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns Image instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IImage): google.cloud.dialogflow.v2.Intent.Message.Image;

                            /**
                             * Encodes the specified Image message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Image.verify|verify} messages.
                             * @param message Image message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified Image message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Image.verify|verify} messages.
                             * @param message Image message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IImage, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an Image message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns Image
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.Image;

                            /**
                             * Decodes an Image message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns Image
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.Image;

                            /**
                             * Verifies an Image message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an Image message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns Image
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.Image;

                            /**
                             * Creates a plain object from an Image message. Also converts values to other types if specified.
                             * @param message Image
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.Image, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this Image to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a QuickReplies. */
                        interface IQuickReplies {

                            /** QuickReplies title */
                            title?: (string|null);

                            /** QuickReplies quickReplies */
                            quickReplies?: (string[]|null);
                        }

                        /** Represents a QuickReplies. */
                        class QuickReplies implements IQuickReplies {

                            /**
                             * Constructs a new QuickReplies.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IQuickReplies);

                            /** QuickReplies title. */
                            public title: string;

                            /** QuickReplies quickReplies. */
                            public quickReplies: string[];

                            /**
                             * Creates a new QuickReplies instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns QuickReplies instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IQuickReplies): google.cloud.dialogflow.v2.Intent.Message.QuickReplies;

                            /**
                             * Encodes the specified QuickReplies message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.QuickReplies.verify|verify} messages.
                             * @param message QuickReplies message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IQuickReplies, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified QuickReplies message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.QuickReplies.verify|verify} messages.
                             * @param message QuickReplies message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IQuickReplies, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a QuickReplies message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns QuickReplies
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.QuickReplies;

                            /**
                             * Decodes a QuickReplies message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns QuickReplies
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.QuickReplies;

                            /**
                             * Verifies a QuickReplies message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a QuickReplies message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns QuickReplies
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.QuickReplies;

                            /**
                             * Creates a plain object from a QuickReplies message. Also converts values to other types if specified.
                             * @param message QuickReplies
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.QuickReplies, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this QuickReplies to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a Card. */
                        interface ICard {

                            /** Card title */
                            title?: (string|null);

                            /** Card subtitle */
                            subtitle?: (string|null);

                            /** Card imageUri */
                            imageUri?: (string|null);

                            /** Card buttons */
                            buttons?: (google.cloud.dialogflow.v2.Intent.Message.Card.IButton[]|null);
                        }

                        /** Represents a Card. */
                        class Card implements ICard {

                            /**
                             * Constructs a new Card.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ICard);

                            /** Card title. */
                            public title: string;

                            /** Card subtitle. */
                            public subtitle: string;

                            /** Card imageUri. */
                            public imageUri: string;

                            /** Card buttons. */
                            public buttons: google.cloud.dialogflow.v2.Intent.Message.Card.IButton[];

                            /**
                             * Creates a new Card instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns Card instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ICard): google.cloud.dialogflow.v2.Intent.Message.Card;

                            /**
                             * Encodes the specified Card message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Card.verify|verify} messages.
                             * @param message Card message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ICard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified Card message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Card.verify|verify} messages.
                             * @param message Card message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ICard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a Card message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns Card
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.Card;

                            /**
                             * Decodes a Card message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns Card
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.Card;

                            /**
                             * Verifies a Card message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a Card message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns Card
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.Card;

                            /**
                             * Creates a plain object from a Card message. Also converts values to other types if specified.
                             * @param message Card
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.Card, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this Card to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace Card {

                            /** Properties of a Button. */
                            interface IButton {

                                /** Button text */
                                text?: (string|null);

                                /** Button postback */
                                postback?: (string|null);
                            }

                            /** Represents a Button. */
                            class Button implements IButton {

                                /**
                                 * Constructs a new Button.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.Card.IButton);

                                /** Button text. */
                                public text: string;

                                /** Button postback. */
                                public postback: string;

                                /**
                                 * Creates a new Button instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns Button instance
                                 */
                                public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.Card.IButton): google.cloud.dialogflow.v2.Intent.Message.Card.Button;

                                /**
                                 * Encodes the specified Button message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Card.Button.verify|verify} messages.
                                 * @param message Button message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: google.cloud.dialogflow.v2.Intent.Message.Card.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified Button message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Card.Button.verify|verify} messages.
                                 * @param message Button message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.Card.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a Button message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns Button
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.Card.Button;

                                /**
                                 * Decodes a Button message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns Button
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.Card.Button;

                                /**
                                 * Verifies a Button message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a Button message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns Button
                                 */
                                public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.Card.Button;

                                /**
                                 * Creates a plain object from a Button message. Also converts values to other types if specified.
                                 * @param message Button
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.Card.Button, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this Button to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }
                        }

                        /** Properties of a SimpleResponse. */
                        interface ISimpleResponse {

                            /** SimpleResponse textToSpeech */
                            textToSpeech?: (string|null);

                            /** SimpleResponse ssml */
                            ssml?: (string|null);

                            /** SimpleResponse displayText */
                            displayText?: (string|null);
                        }

                        /** Represents a SimpleResponse. */
                        class SimpleResponse implements ISimpleResponse {

                            /**
                             * Constructs a new SimpleResponse.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponse);

                            /** SimpleResponse textToSpeech. */
                            public textToSpeech: string;

                            /** SimpleResponse ssml. */
                            public ssml: string;

                            /** SimpleResponse displayText. */
                            public displayText: string;

                            /**
                             * Creates a new SimpleResponse instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns SimpleResponse instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponse): google.cloud.dialogflow.v2.Intent.Message.SimpleResponse;

                            /**
                             * Encodes the specified SimpleResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.verify|verify} messages.
                             * @param message SimpleResponse message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified SimpleResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.SimpleResponse.verify|verify} messages.
                             * @param message SimpleResponse message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a SimpleResponse message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns SimpleResponse
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.SimpleResponse;

                            /**
                             * Decodes a SimpleResponse message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns SimpleResponse
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.SimpleResponse;

                            /**
                             * Verifies a SimpleResponse message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a SimpleResponse message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns SimpleResponse
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.SimpleResponse;

                            /**
                             * Creates a plain object from a SimpleResponse message. Also converts values to other types if specified.
                             * @param message SimpleResponse
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.SimpleResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this SimpleResponse to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a SimpleResponses. */
                        interface ISimpleResponses {

                            /** SimpleResponses simpleResponses */
                            simpleResponses?: (google.cloud.dialogflow.v2.Intent.Message.ISimpleResponse[]|null);
                        }

                        /** Represents a SimpleResponses. */
                        class SimpleResponses implements ISimpleResponses {

                            /**
                             * Constructs a new SimpleResponses.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponses);

                            /** SimpleResponses simpleResponses. */
                            public simpleResponses: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponse[];

                            /**
                             * Creates a new SimpleResponses instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns SimpleResponses instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponses): google.cloud.dialogflow.v2.Intent.Message.SimpleResponses;

                            /**
                             * Encodes the specified SimpleResponses message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.verify|verify} messages.
                             * @param message SimpleResponses message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponses, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified SimpleResponses message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.verify|verify} messages.
                             * @param message SimpleResponses message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ISimpleResponses, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a SimpleResponses message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns SimpleResponses
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.SimpleResponses;

                            /**
                             * Decodes a SimpleResponses message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns SimpleResponses
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.SimpleResponses;

                            /**
                             * Verifies a SimpleResponses message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a SimpleResponses message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns SimpleResponses
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.SimpleResponses;

                            /**
                             * Creates a plain object from a SimpleResponses message. Also converts values to other types if specified.
                             * @param message SimpleResponses
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.SimpleResponses, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this SimpleResponses to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a BasicCard. */
                        interface IBasicCard {

                            /** BasicCard title */
                            title?: (string|null);

                            /** BasicCard subtitle */
                            subtitle?: (string|null);

                            /** BasicCard formattedText */
                            formattedText?: (string|null);

                            /** BasicCard image */
                            image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                            /** BasicCard buttons */
                            buttons?: (google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton[]|null);
                        }

                        /** Represents a BasicCard. */
                        class BasicCard implements IBasicCard {

                            /**
                             * Constructs a new BasicCard.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IBasicCard);

                            /** BasicCard title. */
                            public title: string;

                            /** BasicCard subtitle. */
                            public subtitle: string;

                            /** BasicCard formattedText. */
                            public formattedText: string;

                            /** BasicCard image. */
                            public image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                            /** BasicCard buttons. */
                            public buttons: google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton[];

                            /**
                             * Creates a new BasicCard instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns BasicCard instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IBasicCard): google.cloud.dialogflow.v2.Intent.Message.BasicCard;

                            /**
                             * Encodes the specified BasicCard message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BasicCard.verify|verify} messages.
                             * @param message BasicCard message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IBasicCard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified BasicCard message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BasicCard.verify|verify} messages.
                             * @param message BasicCard message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IBasicCard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a BasicCard message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns BasicCard
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.BasicCard;

                            /**
                             * Decodes a BasicCard message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns BasicCard
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.BasicCard;

                            /**
                             * Verifies a BasicCard message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a BasicCard message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns BasicCard
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.BasicCard;

                            /**
                             * Creates a plain object from a BasicCard message. Also converts values to other types if specified.
                             * @param message BasicCard
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.BasicCard, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this BasicCard to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace BasicCard {

                            /** Properties of a Button. */
                            interface IButton {

                                /** Button title */
                                title?: (string|null);

                                /** Button openUriAction */
                                openUriAction?: (google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.IOpenUriAction|null);
                            }

                            /** Represents a Button. */
                            class Button implements IButton {

                                /**
                                 * Constructs a new Button.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton);

                                /** Button title. */
                                public title: string;

                                /** Button openUriAction. */
                                public openUriAction?: (google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.IOpenUriAction|null);

                                /**
                                 * Creates a new Button instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns Button instance
                                 */
                                public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button;

                                /**
                                 * Encodes the specified Button message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.verify|verify} messages.
                                 * @param message Button message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified Button message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.verify|verify} messages.
                                 * @param message Button message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a Button message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns Button
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button;

                                /**
                                 * Decodes a Button message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns Button
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button;

                                /**
                                 * Verifies a Button message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a Button message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns Button
                                 */
                                public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button;

                                /**
                                 * Creates a plain object from a Button message. Also converts values to other types if specified.
                                 * @param message Button
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this Button to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }

                            namespace Button {

                                /** Properties of an OpenUriAction. */
                                interface IOpenUriAction {

                                    /** OpenUriAction uri */
                                    uri?: (string|null);
                                }

                                /** Represents an OpenUriAction. */
                                class OpenUriAction implements IOpenUriAction {

                                    /**
                                     * Constructs a new OpenUriAction.
                                     * @param [properties] Properties to set
                                     */
                                    constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.IOpenUriAction);

                                    /** OpenUriAction uri. */
                                    public uri: string;

                                    /**
                                     * Creates a new OpenUriAction instance using the specified properties.
                                     * @param [properties] Properties to set
                                     * @returns OpenUriAction instance
                                     */
                                    public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.IOpenUriAction): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction;

                                    /**
                                     * Encodes the specified OpenUriAction message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction.verify|verify} messages.
                                     * @param message OpenUriAction message or plain object to encode
                                     * @param [writer] Writer to encode to
                                     * @returns Writer
                                     */
                                    public static encode(message: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.IOpenUriAction, writer?: $protobuf.Writer): $protobuf.Writer;

                                    /**
                                     * Encodes the specified OpenUriAction message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction.verify|verify} messages.
                                     * @param message OpenUriAction message or plain object to encode
                                     * @param [writer] Writer to encode to
                                     * @returns Writer
                                     */
                                    public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.IOpenUriAction, writer?: $protobuf.Writer): $protobuf.Writer;

                                    /**
                                     * Decodes an OpenUriAction message from the specified reader or buffer.
                                     * @param reader Reader or buffer to decode from
                                     * @param [length] Message length if known beforehand
                                     * @returns OpenUriAction
                                     * @throws {Error} If the payload is not a reader or valid buffer
                                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                     */
                                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction;

                                    /**
                                     * Decodes an OpenUriAction message from the specified reader or buffer, length delimited.
                                     * @param reader Reader or buffer to decode from
                                     * @returns OpenUriAction
                                     * @throws {Error} If the payload is not a reader or valid buffer
                                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                     */
                                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction;

                                    /**
                                     * Verifies an OpenUriAction message.
                                     * @param message Plain object to verify
                                     * @returns `null` if valid, otherwise the reason why it is not
                                     */
                                    public static verify(message: { [k: string]: any }): (string|null);

                                    /**
                                     * Creates an OpenUriAction message from a plain object. Also converts values to their respective internal types.
                                     * @param object Plain object
                                     * @returns OpenUriAction
                                     */
                                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction;

                                    /**
                                     * Creates a plain object from an OpenUriAction message. Also converts values to other types if specified.
                                     * @param message OpenUriAction
                                     * @param [options] Conversion options
                                     * @returns Plain object
                                     */
                                    public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                    /**
                                     * Converts this OpenUriAction to JSON.
                                     * @returns JSON object
                                     */
                                    public toJSON(): { [k: string]: any };
                                }
                            }
                        }

                        /** Properties of a Suggestion. */
                        interface ISuggestion {

                            /** Suggestion title */
                            title?: (string|null);
                        }

                        /** Represents a Suggestion. */
                        class Suggestion implements ISuggestion {

                            /**
                             * Constructs a new Suggestion.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ISuggestion);

                            /** Suggestion title. */
                            public title: string;

                            /**
                             * Creates a new Suggestion instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns Suggestion instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ISuggestion): google.cloud.dialogflow.v2.Intent.Message.Suggestion;

                            /**
                             * Encodes the specified Suggestion message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Suggestion.verify|verify} messages.
                             * @param message Suggestion message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ISuggestion, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified Suggestion message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Suggestion.verify|verify} messages.
                             * @param message Suggestion message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ISuggestion, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a Suggestion message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns Suggestion
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.Suggestion;

                            /**
                             * Decodes a Suggestion message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns Suggestion
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.Suggestion;

                            /**
                             * Verifies a Suggestion message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a Suggestion message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns Suggestion
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.Suggestion;

                            /**
                             * Creates a plain object from a Suggestion message. Also converts values to other types if specified.
                             * @param message Suggestion
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.Suggestion, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this Suggestion to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a Suggestions. */
                        interface ISuggestions {

                            /** Suggestions suggestions */
                            suggestions?: (google.cloud.dialogflow.v2.Intent.Message.ISuggestion[]|null);
                        }

                        /** Represents a Suggestions. */
                        class Suggestions implements ISuggestions {

                            /**
                             * Constructs a new Suggestions.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ISuggestions);

                            /** Suggestions suggestions. */
                            public suggestions: google.cloud.dialogflow.v2.Intent.Message.ISuggestion[];

                            /**
                             * Creates a new Suggestions instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns Suggestions instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ISuggestions): google.cloud.dialogflow.v2.Intent.Message.Suggestions;

                            /**
                             * Encodes the specified Suggestions message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Suggestions.verify|verify} messages.
                             * @param message Suggestions message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ISuggestions, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified Suggestions message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.Suggestions.verify|verify} messages.
                             * @param message Suggestions message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ISuggestions, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a Suggestions message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns Suggestions
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.Suggestions;

                            /**
                             * Decodes a Suggestions message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns Suggestions
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.Suggestions;

                            /**
                             * Verifies a Suggestions message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a Suggestions message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns Suggestions
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.Suggestions;

                            /**
                             * Creates a plain object from a Suggestions message. Also converts values to other types if specified.
                             * @param message Suggestions
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.Suggestions, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this Suggestions to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a LinkOutSuggestion. */
                        interface ILinkOutSuggestion {

                            /** LinkOutSuggestion destinationName */
                            destinationName?: (string|null);

                            /** LinkOutSuggestion uri */
                            uri?: (string|null);
                        }

                        /** Represents a LinkOutSuggestion. */
                        class LinkOutSuggestion implements ILinkOutSuggestion {

                            /**
                             * Constructs a new LinkOutSuggestion.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ILinkOutSuggestion);

                            /** LinkOutSuggestion destinationName. */
                            public destinationName: string;

                            /** LinkOutSuggestion uri. */
                            public uri: string;

                            /**
                             * Creates a new LinkOutSuggestion instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns LinkOutSuggestion instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ILinkOutSuggestion): google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion;

                            /**
                             * Encodes the specified LinkOutSuggestion message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.verify|verify} messages.
                             * @param message LinkOutSuggestion message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ILinkOutSuggestion, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified LinkOutSuggestion message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion.verify|verify} messages.
                             * @param message LinkOutSuggestion message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ILinkOutSuggestion, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a LinkOutSuggestion message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns LinkOutSuggestion
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion;

                            /**
                             * Decodes a LinkOutSuggestion message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns LinkOutSuggestion
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion;

                            /**
                             * Verifies a LinkOutSuggestion message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a LinkOutSuggestion message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns LinkOutSuggestion
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion;

                            /**
                             * Creates a plain object from a LinkOutSuggestion message. Also converts values to other types if specified.
                             * @param message LinkOutSuggestion
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this LinkOutSuggestion to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a ListSelect. */
                        interface IListSelect {

                            /** ListSelect title */
                            title?: (string|null);

                            /** ListSelect items */
                            items?: (google.cloud.dialogflow.v2.Intent.Message.ListSelect.IItem[]|null);

                            /** ListSelect subtitle */
                            subtitle?: (string|null);
                        }

                        /** Represents a ListSelect. */
                        class ListSelect implements IListSelect {

                            /**
                             * Constructs a new ListSelect.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IListSelect);

                            /** ListSelect title. */
                            public title: string;

                            /** ListSelect items. */
                            public items: google.cloud.dialogflow.v2.Intent.Message.ListSelect.IItem[];

                            /** ListSelect subtitle. */
                            public subtitle: string;

                            /**
                             * Creates a new ListSelect instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns ListSelect instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IListSelect): google.cloud.dialogflow.v2.Intent.Message.ListSelect;

                            /**
                             * Encodes the specified ListSelect message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.ListSelect.verify|verify} messages.
                             * @param message ListSelect message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IListSelect, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified ListSelect message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.ListSelect.verify|verify} messages.
                             * @param message ListSelect message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IListSelect, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a ListSelect message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns ListSelect
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.ListSelect;

                            /**
                             * Decodes a ListSelect message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns ListSelect
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.ListSelect;

                            /**
                             * Verifies a ListSelect message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a ListSelect message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns ListSelect
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.ListSelect;

                            /**
                             * Creates a plain object from a ListSelect message. Also converts values to other types if specified.
                             * @param message ListSelect
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.ListSelect, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this ListSelect to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace ListSelect {

                            /** Properties of an Item. */
                            interface IItem {

                                /** Item info */
                                info?: (google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo|null);

                                /** Item title */
                                title?: (string|null);

                                /** Item description */
                                description?: (string|null);

                                /** Item image */
                                image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);
                            }

                            /** Represents an Item. */
                            class Item implements IItem {

                                /**
                                 * Constructs a new Item.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ListSelect.IItem);

                                /** Item info. */
                                public info?: (google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo|null);

                                /** Item title. */
                                public title: string;

                                /** Item description. */
                                public description: string;

                                /** Item image. */
                                public image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /**
                                 * Creates a new Item instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns Item instance
                                 */
                                public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ListSelect.IItem): google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item;

                                /**
                                 * Encodes the specified Item message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.verify|verify} messages.
                                 * @param message Item message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ListSelect.IItem, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified Item message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.verify|verify} messages.
                                 * @param message Item message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ListSelect.IItem, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes an Item message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns Item
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item;

                                /**
                                 * Decodes an Item message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns Item
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item;

                                /**
                                 * Verifies an Item message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates an Item message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns Item
                                 */
                                public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item;

                                /**
                                 * Creates a plain object from an Item message. Also converts values to other types if specified.
                                 * @param message Item
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this Item to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }
                        }

                        /** Properties of a CarouselSelect. */
                        interface ICarouselSelect {

                            /** CarouselSelect items */
                            items?: (google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.IItem[]|null);
                        }

                        /** Represents a CarouselSelect. */
                        class CarouselSelect implements ICarouselSelect {

                            /**
                             * Constructs a new CarouselSelect.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ICarouselSelect);

                            /** CarouselSelect items. */
                            public items: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.IItem[];

                            /**
                             * Creates a new CarouselSelect instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns CarouselSelect instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ICarouselSelect): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect;

                            /**
                             * Encodes the specified CarouselSelect message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.verify|verify} messages.
                             * @param message CarouselSelect message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ICarouselSelect, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified CarouselSelect message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.verify|verify} messages.
                             * @param message CarouselSelect message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ICarouselSelect, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a CarouselSelect message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns CarouselSelect
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect;

                            /**
                             * Decodes a CarouselSelect message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns CarouselSelect
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect;

                            /**
                             * Verifies a CarouselSelect message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a CarouselSelect message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns CarouselSelect
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect;

                            /**
                             * Creates a plain object from a CarouselSelect message. Also converts values to other types if specified.
                             * @param message CarouselSelect
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this CarouselSelect to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace CarouselSelect {

                            /** Properties of an Item. */
                            interface IItem {

                                /** Item info */
                                info?: (google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo|null);

                                /** Item title */
                                title?: (string|null);

                                /** Item description */
                                description?: (string|null);

                                /** Item image */
                                image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);
                            }

                            /** Represents an Item. */
                            class Item implements IItem {

                                /**
                                 * Constructs a new Item.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.IItem);

                                /** Item info. */
                                public info?: (google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo|null);

                                /** Item title. */
                                public title: string;

                                /** Item description. */
                                public description: string;

                                /** Item image. */
                                public image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /**
                                 * Creates a new Item instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns Item instance
                                 */
                                public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.IItem): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item;

                                /**
                                 * Encodes the specified Item message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.verify|verify} messages.
                                 * @param message Item message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.IItem, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified Item message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.verify|verify} messages.
                                 * @param message Item message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.IItem, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes an Item message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns Item
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item;

                                /**
                                 * Decodes an Item message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns Item
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item;

                                /**
                                 * Verifies an Item message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates an Item message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns Item
                                 */
                                public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item;

                                /**
                                 * Creates a plain object from an Item message. Also converts values to other types if specified.
                                 * @param message Item
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this Item to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }
                        }

                        /** Properties of a SelectItemInfo. */
                        interface ISelectItemInfo {

                            /** SelectItemInfo key */
                            key?: (string|null);

                            /** SelectItemInfo synonyms */
                            synonyms?: (string[]|null);
                        }

                        /** Represents a SelectItemInfo. */
                        class SelectItemInfo implements ISelectItemInfo {

                            /**
                             * Constructs a new SelectItemInfo.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo);

                            /** SelectItemInfo key. */
                            public key: string;

                            /** SelectItemInfo synonyms. */
                            public synonyms: string[];

                            /**
                             * Creates a new SelectItemInfo instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns SelectItemInfo instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo): google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo;

                            /**
                             * Encodes the specified SelectItemInfo message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.verify|verify} messages.
                             * @param message SelectItemInfo message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified SelectItemInfo message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo.verify|verify} messages.
                             * @param message SelectItemInfo message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ISelectItemInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a SelectItemInfo message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns SelectItemInfo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo;

                            /**
                             * Decodes a SelectItemInfo message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns SelectItemInfo
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo;

                            /**
                             * Verifies a SelectItemInfo message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a SelectItemInfo message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns SelectItemInfo
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo;

                            /**
                             * Creates a plain object from a SelectItemInfo message. Also converts values to other types if specified.
                             * @param message SelectItemInfo
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this SelectItemInfo to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a MediaContent. */
                        interface IMediaContent {

                            /** MediaContent mediaType */
                            mediaType?: (google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType|keyof typeof google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType|null);

                            /** MediaContent mediaObjects */
                            mediaObjects?: (google.cloud.dialogflow.v2.Intent.Message.MediaContent.IResponseMediaObject[]|null);
                        }

                        /** Represents a MediaContent. */
                        class MediaContent implements IMediaContent {

                            /**
                             * Constructs a new MediaContent.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IMediaContent);

                            /** MediaContent mediaType. */
                            public mediaType: (google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType|keyof typeof google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType);

                            /** MediaContent mediaObjects. */
                            public mediaObjects: google.cloud.dialogflow.v2.Intent.Message.MediaContent.IResponseMediaObject[];

                            /**
                             * Creates a new MediaContent instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns MediaContent instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IMediaContent): google.cloud.dialogflow.v2.Intent.Message.MediaContent;

                            /**
                             * Encodes the specified MediaContent message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.MediaContent.verify|verify} messages.
                             * @param message MediaContent message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IMediaContent, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified MediaContent message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.MediaContent.verify|verify} messages.
                             * @param message MediaContent message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IMediaContent, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a MediaContent message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns MediaContent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.MediaContent;

                            /**
                             * Decodes a MediaContent message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns MediaContent
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.MediaContent;

                            /**
                             * Verifies a MediaContent message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a MediaContent message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns MediaContent
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.MediaContent;

                            /**
                             * Creates a plain object from a MediaContent message. Also converts values to other types if specified.
                             * @param message MediaContent
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.MediaContent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this MediaContent to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace MediaContent {

                            /** ResponseMediaType enum. */
                            enum ResponseMediaType {
                                RESPONSE_MEDIA_TYPE_UNSPECIFIED = 0,
                                AUDIO = 1
                            }

                            /** Properties of a ResponseMediaObject. */
                            interface IResponseMediaObject {

                                /** ResponseMediaObject name */
                                name?: (string|null);

                                /** ResponseMediaObject description */
                                description?: (string|null);

                                /** ResponseMediaObject largeImage */
                                largeImage?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /** ResponseMediaObject icon */
                                icon?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /** ResponseMediaObject contentUrl */
                                contentUrl?: (string|null);
                            }

                            /** Represents a ResponseMediaObject. */
                            class ResponseMediaObject implements IResponseMediaObject {

                                /**
                                 * Constructs a new ResponseMediaObject.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.MediaContent.IResponseMediaObject);

                                /** ResponseMediaObject name. */
                                public name: string;

                                /** ResponseMediaObject description. */
                                public description: string;

                                /** ResponseMediaObject largeImage. */
                                public largeImage?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /** ResponseMediaObject icon. */
                                public icon?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /** ResponseMediaObject contentUrl. */
                                public contentUrl: string;

                                /** ResponseMediaObject image. */
                                public image?: ("largeImage"|"icon");

                                /**
                                 * Creates a new ResponseMediaObject instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns ResponseMediaObject instance
                                 */
                                public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.MediaContent.IResponseMediaObject): google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject;

                                /**
                                 * Encodes the specified ResponseMediaObject message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject.verify|verify} messages.
                                 * @param message ResponseMediaObject message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: google.cloud.dialogflow.v2.Intent.Message.MediaContent.IResponseMediaObject, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified ResponseMediaObject message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject.verify|verify} messages.
                                 * @param message ResponseMediaObject message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.MediaContent.IResponseMediaObject, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a ResponseMediaObject message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns ResponseMediaObject
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject;

                                /**
                                 * Decodes a ResponseMediaObject message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns ResponseMediaObject
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject;

                                /**
                                 * Verifies a ResponseMediaObject message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a ResponseMediaObject message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns ResponseMediaObject
                                 */
                                public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject;

                                /**
                                 * Creates a plain object from a ResponseMediaObject message. Also converts values to other types if specified.
                                 * @param message ResponseMediaObject
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this ResponseMediaObject to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }
                        }

                        /** Properties of a BrowseCarouselCard. */
                        interface IBrowseCarouselCard {

                            /** BrowseCarouselCard items */
                            items?: (google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.IBrowseCarouselCardItem[]|null);

                            /** BrowseCarouselCard imageDisplayOptions */
                            imageDisplayOptions?: (google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.ImageDisplayOptions|keyof typeof google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.ImageDisplayOptions|null);
                        }

                        /** Represents a BrowseCarouselCard. */
                        class BrowseCarouselCard implements IBrowseCarouselCard {

                            /**
                             * Constructs a new BrowseCarouselCard.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IBrowseCarouselCard);

                            /** BrowseCarouselCard items. */
                            public items: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.IBrowseCarouselCardItem[];

                            /** BrowseCarouselCard imageDisplayOptions. */
                            public imageDisplayOptions: (google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.ImageDisplayOptions|keyof typeof google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.ImageDisplayOptions);

                            /**
                             * Creates a new BrowseCarouselCard instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns BrowseCarouselCard instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IBrowseCarouselCard): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard;

                            /**
                             * Encodes the specified BrowseCarouselCard message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.verify|verify} messages.
                             * @param message BrowseCarouselCard message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IBrowseCarouselCard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified BrowseCarouselCard message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.verify|verify} messages.
                             * @param message BrowseCarouselCard message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IBrowseCarouselCard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a BrowseCarouselCard message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns BrowseCarouselCard
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard;

                            /**
                             * Decodes a BrowseCarouselCard message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns BrowseCarouselCard
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard;

                            /**
                             * Verifies a BrowseCarouselCard message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a BrowseCarouselCard message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns BrowseCarouselCard
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard;

                            /**
                             * Creates a plain object from a BrowseCarouselCard message. Also converts values to other types if specified.
                             * @param message BrowseCarouselCard
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this BrowseCarouselCard to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace BrowseCarouselCard {

                            /** Properties of a BrowseCarouselCardItem. */
                            interface IBrowseCarouselCardItem {

                                /** BrowseCarouselCardItem openUriAction */
                                openUriAction?: (google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.IOpenUrlAction|null);

                                /** BrowseCarouselCardItem title */
                                title?: (string|null);

                                /** BrowseCarouselCardItem description */
                                description?: (string|null);

                                /** BrowseCarouselCardItem image */
                                image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /** BrowseCarouselCardItem footer */
                                footer?: (string|null);
                            }

                            /** Represents a BrowseCarouselCardItem. */
                            class BrowseCarouselCardItem implements IBrowseCarouselCardItem {

                                /**
                                 * Constructs a new BrowseCarouselCardItem.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.IBrowseCarouselCardItem);

                                /** BrowseCarouselCardItem openUriAction. */
                                public openUriAction?: (google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.IOpenUrlAction|null);

                                /** BrowseCarouselCardItem title. */
                                public title: string;

                                /** BrowseCarouselCardItem description. */
                                public description: string;

                                /** BrowseCarouselCardItem image. */
                                public image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                                /** BrowseCarouselCardItem footer. */
                                public footer: string;

                                /**
                                 * Creates a new BrowseCarouselCardItem instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns BrowseCarouselCardItem instance
                                 */
                                public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.IBrowseCarouselCardItem): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem;

                                /**
                                 * Encodes the specified BrowseCarouselCardItem message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.verify|verify} messages.
                                 * @param message BrowseCarouselCardItem message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.IBrowseCarouselCardItem, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified BrowseCarouselCardItem message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.verify|verify} messages.
                                 * @param message BrowseCarouselCardItem message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.IBrowseCarouselCardItem, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a BrowseCarouselCardItem message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns BrowseCarouselCardItem
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem;

                                /**
                                 * Decodes a BrowseCarouselCardItem message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns BrowseCarouselCardItem
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem;

                                /**
                                 * Verifies a BrowseCarouselCardItem message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a BrowseCarouselCardItem message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns BrowseCarouselCardItem
                                 */
                                public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem;

                                /**
                                 * Creates a plain object from a BrowseCarouselCardItem message. Also converts values to other types if specified.
                                 * @param message BrowseCarouselCardItem
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this BrowseCarouselCardItem to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }

                            namespace BrowseCarouselCardItem {

                                /** Properties of an OpenUrlAction. */
                                interface IOpenUrlAction {

                                    /** OpenUrlAction url */
                                    url?: (string|null);

                                    /** OpenUrlAction urlTypeHint */
                                    urlTypeHint?: (google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.UrlTypeHint|keyof typeof google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.UrlTypeHint|null);
                                }

                                /** Represents an OpenUrlAction. */
                                class OpenUrlAction implements IOpenUrlAction {

                                    /**
                                     * Constructs a new OpenUrlAction.
                                     * @param [properties] Properties to set
                                     */
                                    constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.IOpenUrlAction);

                                    /** OpenUrlAction url. */
                                    public url: string;

                                    /** OpenUrlAction urlTypeHint. */
                                    public urlTypeHint: (google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.UrlTypeHint|keyof typeof google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.UrlTypeHint);

                                    /**
                                     * Creates a new OpenUrlAction instance using the specified properties.
                                     * @param [properties] Properties to set
                                     * @returns OpenUrlAction instance
                                     */
                                    public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.IOpenUrlAction): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction;

                                    /**
                                     * Encodes the specified OpenUrlAction message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.verify|verify} messages.
                                     * @param message OpenUrlAction message or plain object to encode
                                     * @param [writer] Writer to encode to
                                     * @returns Writer
                                     */
                                    public static encode(message: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.IOpenUrlAction, writer?: $protobuf.Writer): $protobuf.Writer;

                                    /**
                                     * Encodes the specified OpenUrlAction message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.verify|verify} messages.
                                     * @param message OpenUrlAction message or plain object to encode
                                     * @param [writer] Writer to encode to
                                     * @returns Writer
                                     */
                                    public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.IOpenUrlAction, writer?: $protobuf.Writer): $protobuf.Writer;

                                    /**
                                     * Decodes an OpenUrlAction message from the specified reader or buffer.
                                     * @param reader Reader or buffer to decode from
                                     * @param [length] Message length if known beforehand
                                     * @returns OpenUrlAction
                                     * @throws {Error} If the payload is not a reader or valid buffer
                                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                     */
                                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction;

                                    /**
                                     * Decodes an OpenUrlAction message from the specified reader or buffer, length delimited.
                                     * @param reader Reader or buffer to decode from
                                     * @returns OpenUrlAction
                                     * @throws {Error} If the payload is not a reader or valid buffer
                                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                     */
                                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction;

                                    /**
                                     * Verifies an OpenUrlAction message.
                                     * @param message Plain object to verify
                                     * @returns `null` if valid, otherwise the reason why it is not
                                     */
                                    public static verify(message: { [k: string]: any }): (string|null);

                                    /**
                                     * Creates an OpenUrlAction message from a plain object. Also converts values to their respective internal types.
                                     * @param object Plain object
                                     * @returns OpenUrlAction
                                     */
                                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction;

                                    /**
                                     * Creates a plain object from an OpenUrlAction message. Also converts values to other types if specified.
                                     * @param message OpenUrlAction
                                     * @param [options] Conversion options
                                     * @returns Plain object
                                     */
                                    public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                    /**
                                     * Converts this OpenUrlAction to JSON.
                                     * @returns JSON object
                                     */
                                    public toJSON(): { [k: string]: any };
                                }

                                namespace OpenUrlAction {

                                    /** UrlTypeHint enum. */
                                    enum UrlTypeHint {
                                        URL_TYPE_HINT_UNSPECIFIED = 0,
                                        AMP_ACTION = 1,
                                        AMP_CONTENT = 2
                                    }
                                }
                            }

                            /** ImageDisplayOptions enum. */
                            enum ImageDisplayOptions {
                                IMAGE_DISPLAY_OPTIONS_UNSPECIFIED = 0,
                                GRAY = 1,
                                WHITE = 2,
                                CROPPED = 3,
                                BLURRED_BACKGROUND = 4
                            }
                        }

                        /** Properties of a TableCard. */
                        interface ITableCard {

                            /** TableCard title */
                            title?: (string|null);

                            /** TableCard subtitle */
                            subtitle?: (string|null);

                            /** TableCard image */
                            image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                            /** TableCard columnProperties */
                            columnProperties?: (google.cloud.dialogflow.v2.Intent.Message.IColumnProperties[]|null);

                            /** TableCard rows */
                            rows?: (google.cloud.dialogflow.v2.Intent.Message.ITableCardRow[]|null);

                            /** TableCard buttons */
                            buttons?: (google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton[]|null);
                        }

                        /** Represents a TableCard. */
                        class TableCard implements ITableCard {

                            /**
                             * Constructs a new TableCard.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ITableCard);

                            /** TableCard title. */
                            public title: string;

                            /** TableCard subtitle. */
                            public subtitle: string;

                            /** TableCard image. */
                            public image?: (google.cloud.dialogflow.v2.Intent.Message.IImage|null);

                            /** TableCard columnProperties. */
                            public columnProperties: google.cloud.dialogflow.v2.Intent.Message.IColumnProperties[];

                            /** TableCard rows. */
                            public rows: google.cloud.dialogflow.v2.Intent.Message.ITableCardRow[];

                            /** TableCard buttons. */
                            public buttons: google.cloud.dialogflow.v2.Intent.Message.BasicCard.IButton[];

                            /**
                             * Creates a new TableCard instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TableCard instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ITableCard): google.cloud.dialogflow.v2.Intent.Message.TableCard;

                            /**
                             * Encodes the specified TableCard message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.TableCard.verify|verify} messages.
                             * @param message TableCard message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ITableCard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TableCard message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.TableCard.verify|verify} messages.
                             * @param message TableCard message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ITableCard, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TableCard message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TableCard
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.TableCard;

                            /**
                             * Decodes a TableCard message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TableCard
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.TableCard;

                            /**
                             * Verifies a TableCard message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TableCard message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TableCard
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.TableCard;

                            /**
                             * Creates a plain object from a TableCard message. Also converts values to other types if specified.
                             * @param message TableCard
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.TableCard, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TableCard to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a ColumnProperties. */
                        interface IColumnProperties {

                            /** ColumnProperties header */
                            header?: (string|null);

                            /** ColumnProperties horizontalAlignment */
                            horizontalAlignment?: (google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.HorizontalAlignment|keyof typeof google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.HorizontalAlignment|null);
                        }

                        /** Represents a ColumnProperties. */
                        class ColumnProperties implements IColumnProperties {

                            /**
                             * Constructs a new ColumnProperties.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.IColumnProperties);

                            /** ColumnProperties header. */
                            public header: string;

                            /** ColumnProperties horizontalAlignment. */
                            public horizontalAlignment: (google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.HorizontalAlignment|keyof typeof google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.HorizontalAlignment);

                            /**
                             * Creates a new ColumnProperties instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns ColumnProperties instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.IColumnProperties): google.cloud.dialogflow.v2.Intent.Message.ColumnProperties;

                            /**
                             * Encodes the specified ColumnProperties message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.verify|verify} messages.
                             * @param message ColumnProperties message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.IColumnProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified ColumnProperties message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.verify|verify} messages.
                             * @param message ColumnProperties message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.IColumnProperties, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a ColumnProperties message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns ColumnProperties
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.ColumnProperties;

                            /**
                             * Decodes a ColumnProperties message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns ColumnProperties
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.ColumnProperties;

                            /**
                             * Verifies a ColumnProperties message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a ColumnProperties message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns ColumnProperties
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.ColumnProperties;

                            /**
                             * Creates a plain object from a ColumnProperties message. Also converts values to other types if specified.
                             * @param message ColumnProperties
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.ColumnProperties, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this ColumnProperties to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace ColumnProperties {

                            /** HorizontalAlignment enum. */
                            enum HorizontalAlignment {
                                HORIZONTAL_ALIGNMENT_UNSPECIFIED = 0,
                                LEADING = 1,
                                CENTER = 2,
                                TRAILING = 3
                            }
                        }

                        /** Properties of a TableCardRow. */
                        interface ITableCardRow {

                            /** TableCardRow cells */
                            cells?: (google.cloud.dialogflow.v2.Intent.Message.ITableCardCell[]|null);

                            /** TableCardRow dividerAfter */
                            dividerAfter?: (boolean|null);
                        }

                        /** Represents a TableCardRow. */
                        class TableCardRow implements ITableCardRow {

                            /**
                             * Constructs a new TableCardRow.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ITableCardRow);

                            /** TableCardRow cells. */
                            public cells: google.cloud.dialogflow.v2.Intent.Message.ITableCardCell[];

                            /** TableCardRow dividerAfter. */
                            public dividerAfter: boolean;

                            /**
                             * Creates a new TableCardRow instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TableCardRow instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ITableCardRow): google.cloud.dialogflow.v2.Intent.Message.TableCardRow;

                            /**
                             * Encodes the specified TableCardRow message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.TableCardRow.verify|verify} messages.
                             * @param message TableCardRow message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ITableCardRow, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TableCardRow message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.TableCardRow.verify|verify} messages.
                             * @param message TableCardRow message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ITableCardRow, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TableCardRow message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TableCardRow
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.TableCardRow;

                            /**
                             * Decodes a TableCardRow message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TableCardRow
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.TableCardRow;

                            /**
                             * Verifies a TableCardRow message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TableCardRow message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TableCardRow
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.TableCardRow;

                            /**
                             * Creates a plain object from a TableCardRow message. Also converts values to other types if specified.
                             * @param message TableCardRow
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.TableCardRow, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TableCardRow to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a TableCardCell. */
                        interface ITableCardCell {

                            /** TableCardCell text */
                            text?: (string|null);
                        }

                        /** Represents a TableCardCell. */
                        class TableCardCell implements ITableCardCell {

                            /**
                             * Constructs a new TableCardCell.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: google.cloud.dialogflow.v2.Intent.Message.ITableCardCell);

                            /** TableCardCell text. */
                            public text: string;

                            /**
                             * Creates a new TableCardCell instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns TableCardCell instance
                             */
                            public static create(properties?: google.cloud.dialogflow.v2.Intent.Message.ITableCardCell): google.cloud.dialogflow.v2.Intent.Message.TableCardCell;

                            /**
                             * Encodes the specified TableCardCell message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.TableCardCell.verify|verify} messages.
                             * @param message TableCardCell message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: google.cloud.dialogflow.v2.Intent.Message.ITableCardCell, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified TableCardCell message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.Message.TableCardCell.verify|verify} messages.
                             * @param message TableCardCell message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.Message.ITableCardCell, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a TableCardCell message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns TableCardCell
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.Message.TableCardCell;

                            /**
                             * Decodes a TableCardCell message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns TableCardCell
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.Message.TableCardCell;

                            /**
                             * Verifies a TableCardCell message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a TableCardCell message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns TableCardCell
                             */
                            public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.Message.TableCardCell;

                            /**
                             * Creates a plain object from a TableCardCell message. Also converts values to other types if specified.
                             * @param message TableCardCell
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: google.cloud.dialogflow.v2.Intent.Message.TableCardCell, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this TableCardCell to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }
                    }

                    /** Properties of a FollowupIntentInfo. */
                    interface IFollowupIntentInfo {

                        /** FollowupIntentInfo followupIntentName */
                        followupIntentName?: (string|null);

                        /** FollowupIntentInfo parentFollowupIntentName */
                        parentFollowupIntentName?: (string|null);
                    }

                    /** Represents a FollowupIntentInfo. */
                    class FollowupIntentInfo implements IFollowupIntentInfo {

                        /**
                         * Constructs a new FollowupIntentInfo.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.dialogflow.v2.Intent.IFollowupIntentInfo);

                        /** FollowupIntentInfo followupIntentName. */
                        public followupIntentName: string;

                        /** FollowupIntentInfo parentFollowupIntentName. */
                        public parentFollowupIntentName: string;

                        /**
                         * Creates a new FollowupIntentInfo instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns FollowupIntentInfo instance
                         */
                        public static create(properties?: google.cloud.dialogflow.v2.Intent.IFollowupIntentInfo): google.cloud.dialogflow.v2.Intent.FollowupIntentInfo;

                        /**
                         * Encodes the specified FollowupIntentInfo message. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.FollowupIntentInfo.verify|verify} messages.
                         * @param message FollowupIntentInfo message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.dialogflow.v2.Intent.IFollowupIntentInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified FollowupIntentInfo message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Intent.FollowupIntentInfo.verify|verify} messages.
                         * @param message FollowupIntentInfo message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.dialogflow.v2.Intent.IFollowupIntentInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a FollowupIntentInfo message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns FollowupIntentInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Intent.FollowupIntentInfo;

                        /**
                         * Decodes a FollowupIntentInfo message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns FollowupIntentInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Intent.FollowupIntentInfo;

                        /**
                         * Verifies a FollowupIntentInfo message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a FollowupIntentInfo message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns FollowupIntentInfo
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Intent.FollowupIntentInfo;

                        /**
                         * Creates a plain object from a FollowupIntentInfo message. Also converts values to other types if specified.
                         * @param message FollowupIntentInfo
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.dialogflow.v2.Intent.FollowupIntentInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this FollowupIntentInfo to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }
                }

                /** Properties of a ListIntentsRequest. */
                interface IListIntentsRequest {

                    /** ListIntentsRequest parent */
                    parent?: (string|null);

                    /** ListIntentsRequest languageCode */
                    languageCode?: (string|null);

                    /** ListIntentsRequest intentView */
                    intentView?: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView|null);

                    /** ListIntentsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListIntentsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListIntentsRequest. */
                class ListIntentsRequest implements IListIntentsRequest {

                    /**
                     * Constructs a new ListIntentsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListIntentsRequest);

                    /** ListIntentsRequest parent. */
                    public parent: string;

                    /** ListIntentsRequest languageCode. */
                    public languageCode: string;

                    /** ListIntentsRequest intentView. */
                    public intentView: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView);

                    /** ListIntentsRequest pageSize. */
                    public pageSize: number;

                    /** ListIntentsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListIntentsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListIntentsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListIntentsRequest): google.cloud.dialogflow.v2.ListIntentsRequest;

                    /**
                     * Encodes the specified ListIntentsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListIntentsRequest.verify|verify} messages.
                     * @param message ListIntentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListIntentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListIntentsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListIntentsRequest.verify|verify} messages.
                     * @param message ListIntentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListIntentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListIntentsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListIntentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListIntentsRequest;

                    /**
                     * Decodes a ListIntentsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListIntentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListIntentsRequest;

                    /**
                     * Verifies a ListIntentsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListIntentsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListIntentsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListIntentsRequest;

                    /**
                     * Creates a plain object from a ListIntentsRequest message. Also converts values to other types if specified.
                     * @param message ListIntentsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListIntentsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListIntentsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListIntentsResponse. */
                interface IListIntentsResponse {

                    /** ListIntentsResponse intents */
                    intents?: (google.cloud.dialogflow.v2.IIntent[]|null);

                    /** ListIntentsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListIntentsResponse. */
                class ListIntentsResponse implements IListIntentsResponse {

                    /**
                     * Constructs a new ListIntentsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListIntentsResponse);

                    /** ListIntentsResponse intents. */
                    public intents: google.cloud.dialogflow.v2.IIntent[];

                    /** ListIntentsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListIntentsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListIntentsResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListIntentsResponse): google.cloud.dialogflow.v2.ListIntentsResponse;

                    /**
                     * Encodes the specified ListIntentsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListIntentsResponse.verify|verify} messages.
                     * @param message ListIntentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListIntentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListIntentsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListIntentsResponse.verify|verify} messages.
                     * @param message ListIntentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListIntentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListIntentsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListIntentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListIntentsResponse;

                    /**
                     * Decodes a ListIntentsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListIntentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListIntentsResponse;

                    /**
                     * Verifies a ListIntentsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListIntentsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListIntentsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListIntentsResponse;

                    /**
                     * Creates a plain object from a ListIntentsResponse message. Also converts values to other types if specified.
                     * @param message ListIntentsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListIntentsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListIntentsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetIntentRequest. */
                interface IGetIntentRequest {

                    /** GetIntentRequest name */
                    name?: (string|null);

                    /** GetIntentRequest languageCode */
                    languageCode?: (string|null);

                    /** GetIntentRequest intentView */
                    intentView?: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView|null);
                }

                /** Represents a GetIntentRequest. */
                class GetIntentRequest implements IGetIntentRequest {

                    /**
                     * Constructs a new GetIntentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetIntentRequest);

                    /** GetIntentRequest name. */
                    public name: string;

                    /** GetIntentRequest languageCode. */
                    public languageCode: string;

                    /** GetIntentRequest intentView. */
                    public intentView: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView);

                    /**
                     * Creates a new GetIntentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetIntentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetIntentRequest): google.cloud.dialogflow.v2.GetIntentRequest;

                    /**
                     * Encodes the specified GetIntentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetIntentRequest.verify|verify} messages.
                     * @param message GetIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetIntentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetIntentRequest.verify|verify} messages.
                     * @param message GetIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetIntentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetIntentRequest;

                    /**
                     * Decodes a GetIntentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetIntentRequest;

                    /**
                     * Verifies a GetIntentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetIntentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetIntentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetIntentRequest;

                    /**
                     * Creates a plain object from a GetIntentRequest message. Also converts values to other types if specified.
                     * @param message GetIntentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetIntentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetIntentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a CreateIntentRequest. */
                interface ICreateIntentRequest {

                    /** CreateIntentRequest parent */
                    parent?: (string|null);

                    /** CreateIntentRequest intent */
                    intent?: (google.cloud.dialogflow.v2.IIntent|null);

                    /** CreateIntentRequest languageCode */
                    languageCode?: (string|null);

                    /** CreateIntentRequest intentView */
                    intentView?: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView|null);
                }

                /** Represents a CreateIntentRequest. */
                class CreateIntentRequest implements ICreateIntentRequest {

                    /**
                     * Constructs a new CreateIntentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICreateIntentRequest);

                    /** CreateIntentRequest parent. */
                    public parent: string;

                    /** CreateIntentRequest intent. */
                    public intent?: (google.cloud.dialogflow.v2.IIntent|null);

                    /** CreateIntentRequest languageCode. */
                    public languageCode: string;

                    /** CreateIntentRequest intentView. */
                    public intentView: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView);

                    /**
                     * Creates a new CreateIntentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateIntentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICreateIntentRequest): google.cloud.dialogflow.v2.CreateIntentRequest;

                    /**
                     * Encodes the specified CreateIntentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateIntentRequest.verify|verify} messages.
                     * @param message CreateIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICreateIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateIntentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateIntentRequest.verify|verify} messages.
                     * @param message CreateIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICreateIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateIntentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CreateIntentRequest;

                    /**
                     * Decodes a CreateIntentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CreateIntentRequest;

                    /**
                     * Verifies a CreateIntentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateIntentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateIntentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CreateIntentRequest;

                    /**
                     * Creates a plain object from a CreateIntentRequest message. Also converts values to other types if specified.
                     * @param message CreateIntentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CreateIntentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateIntentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an UpdateIntentRequest. */
                interface IUpdateIntentRequest {

                    /** UpdateIntentRequest intent */
                    intent?: (google.cloud.dialogflow.v2.IIntent|null);

                    /** UpdateIntentRequest languageCode */
                    languageCode?: (string|null);

                    /** UpdateIntentRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);

                    /** UpdateIntentRequest intentView */
                    intentView?: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView|null);
                }

                /** Represents an UpdateIntentRequest. */
                class UpdateIntentRequest implements IUpdateIntentRequest {

                    /**
                     * Constructs a new UpdateIntentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IUpdateIntentRequest);

                    /** UpdateIntentRequest intent. */
                    public intent?: (google.cloud.dialogflow.v2.IIntent|null);

                    /** UpdateIntentRequest languageCode. */
                    public languageCode: string;

                    /** UpdateIntentRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /** UpdateIntentRequest intentView. */
                    public intentView: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView);

                    /**
                     * Creates a new UpdateIntentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateIntentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IUpdateIntentRequest): google.cloud.dialogflow.v2.UpdateIntentRequest;

                    /**
                     * Encodes the specified UpdateIntentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateIntentRequest.verify|verify} messages.
                     * @param message UpdateIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IUpdateIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateIntentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateIntentRequest.verify|verify} messages.
                     * @param message UpdateIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IUpdateIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateIntentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.UpdateIntentRequest;

                    /**
                     * Decodes an UpdateIntentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.UpdateIntentRequest;

                    /**
                     * Verifies an UpdateIntentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateIntentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateIntentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.UpdateIntentRequest;

                    /**
                     * Creates a plain object from an UpdateIntentRequest message. Also converts values to other types if specified.
                     * @param message UpdateIntentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.UpdateIntentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateIntentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DeleteIntentRequest. */
                interface IDeleteIntentRequest {

                    /** DeleteIntentRequest name */
                    name?: (string|null);
                }

                /** Represents a DeleteIntentRequest. */
                class DeleteIntentRequest implements IDeleteIntentRequest {

                    /**
                     * Constructs a new DeleteIntentRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDeleteIntentRequest);

                    /** DeleteIntentRequest name. */
                    public name: string;

                    /**
                     * Creates a new DeleteIntentRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteIntentRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDeleteIntentRequest): google.cloud.dialogflow.v2.DeleteIntentRequest;

                    /**
                     * Encodes the specified DeleteIntentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteIntentRequest.verify|verify} messages.
                     * @param message DeleteIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDeleteIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteIntentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteIntentRequest.verify|verify} messages.
                     * @param message DeleteIntentRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDeleteIntentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteIntentRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DeleteIntentRequest;

                    /**
                     * Decodes a DeleteIntentRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteIntentRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DeleteIntentRequest;

                    /**
                     * Verifies a DeleteIntentRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteIntentRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteIntentRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DeleteIntentRequest;

                    /**
                     * Creates a plain object from a DeleteIntentRequest message. Also converts values to other types if specified.
                     * @param message DeleteIntentRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DeleteIntentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteIntentRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchUpdateIntentsRequest. */
                interface IBatchUpdateIntentsRequest {

                    /** BatchUpdateIntentsRequest parent */
                    parent?: (string|null);

                    /** BatchUpdateIntentsRequest intentBatchUri */
                    intentBatchUri?: (string|null);

                    /** BatchUpdateIntentsRequest intentBatchInline */
                    intentBatchInline?: (google.cloud.dialogflow.v2.IIntentBatch|null);

                    /** BatchUpdateIntentsRequest languageCode */
                    languageCode?: (string|null);

                    /** BatchUpdateIntentsRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);

                    /** BatchUpdateIntentsRequest intentView */
                    intentView?: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView|null);
                }

                /** Represents a BatchUpdateIntentsRequest. */
                class BatchUpdateIntentsRequest implements IBatchUpdateIntentsRequest {

                    /**
                     * Constructs a new BatchUpdateIntentsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchUpdateIntentsRequest);

                    /** BatchUpdateIntentsRequest parent. */
                    public parent: string;

                    /** BatchUpdateIntentsRequest intentBatchUri. */
                    public intentBatchUri?: (string|null);

                    /** BatchUpdateIntentsRequest intentBatchInline. */
                    public intentBatchInline?: (google.cloud.dialogflow.v2.IIntentBatch|null);

                    /** BatchUpdateIntentsRequest languageCode. */
                    public languageCode: string;

                    /** BatchUpdateIntentsRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /** BatchUpdateIntentsRequest intentView. */
                    public intentView: (google.cloud.dialogflow.v2.IntentView|keyof typeof google.cloud.dialogflow.v2.IntentView);

                    /** BatchUpdateIntentsRequest intentBatch. */
                    public intentBatch?: ("intentBatchUri"|"intentBatchInline");

                    /**
                     * Creates a new BatchUpdateIntentsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchUpdateIntentsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchUpdateIntentsRequest): google.cloud.dialogflow.v2.BatchUpdateIntentsRequest;

                    /**
                     * Encodes the specified BatchUpdateIntentsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateIntentsRequest.verify|verify} messages.
                     * @param message BatchUpdateIntentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchUpdateIntentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchUpdateIntentsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateIntentsRequest.verify|verify} messages.
                     * @param message BatchUpdateIntentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchUpdateIntentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchUpdateIntentsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchUpdateIntentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchUpdateIntentsRequest;

                    /**
                     * Decodes a BatchUpdateIntentsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchUpdateIntentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchUpdateIntentsRequest;

                    /**
                     * Verifies a BatchUpdateIntentsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchUpdateIntentsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchUpdateIntentsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchUpdateIntentsRequest;

                    /**
                     * Creates a plain object from a BatchUpdateIntentsRequest message. Also converts values to other types if specified.
                     * @param message BatchUpdateIntentsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchUpdateIntentsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchUpdateIntentsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchUpdateIntentsResponse. */
                interface IBatchUpdateIntentsResponse {

                    /** BatchUpdateIntentsResponse intents */
                    intents?: (google.cloud.dialogflow.v2.IIntent[]|null);
                }

                /** Represents a BatchUpdateIntentsResponse. */
                class BatchUpdateIntentsResponse implements IBatchUpdateIntentsResponse {

                    /**
                     * Constructs a new BatchUpdateIntentsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchUpdateIntentsResponse);

                    /** BatchUpdateIntentsResponse intents. */
                    public intents: google.cloud.dialogflow.v2.IIntent[];

                    /**
                     * Creates a new BatchUpdateIntentsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchUpdateIntentsResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchUpdateIntentsResponse): google.cloud.dialogflow.v2.BatchUpdateIntentsResponse;

                    /**
                     * Encodes the specified BatchUpdateIntentsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateIntentsResponse.verify|verify} messages.
                     * @param message BatchUpdateIntentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchUpdateIntentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchUpdateIntentsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateIntentsResponse.verify|verify} messages.
                     * @param message BatchUpdateIntentsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchUpdateIntentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchUpdateIntentsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchUpdateIntentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchUpdateIntentsResponse;

                    /**
                     * Decodes a BatchUpdateIntentsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchUpdateIntentsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchUpdateIntentsResponse;

                    /**
                     * Verifies a BatchUpdateIntentsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchUpdateIntentsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchUpdateIntentsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchUpdateIntentsResponse;

                    /**
                     * Creates a plain object from a BatchUpdateIntentsResponse message. Also converts values to other types if specified.
                     * @param message BatchUpdateIntentsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchUpdateIntentsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchUpdateIntentsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchDeleteIntentsRequest. */
                interface IBatchDeleteIntentsRequest {

                    /** BatchDeleteIntentsRequest parent */
                    parent?: (string|null);

                    /** BatchDeleteIntentsRequest intents */
                    intents?: (google.cloud.dialogflow.v2.IIntent[]|null);
                }

                /** Represents a BatchDeleteIntentsRequest. */
                class BatchDeleteIntentsRequest implements IBatchDeleteIntentsRequest {

                    /**
                     * Constructs a new BatchDeleteIntentsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchDeleteIntentsRequest);

                    /** BatchDeleteIntentsRequest parent. */
                    public parent: string;

                    /** BatchDeleteIntentsRequest intents. */
                    public intents: google.cloud.dialogflow.v2.IIntent[];

                    /**
                     * Creates a new BatchDeleteIntentsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchDeleteIntentsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchDeleteIntentsRequest): google.cloud.dialogflow.v2.BatchDeleteIntentsRequest;

                    /**
                     * Encodes the specified BatchDeleteIntentsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchDeleteIntentsRequest.verify|verify} messages.
                     * @param message BatchDeleteIntentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchDeleteIntentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchDeleteIntentsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchDeleteIntentsRequest.verify|verify} messages.
                     * @param message BatchDeleteIntentsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchDeleteIntentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchDeleteIntentsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchDeleteIntentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchDeleteIntentsRequest;

                    /**
                     * Decodes a BatchDeleteIntentsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchDeleteIntentsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchDeleteIntentsRequest;

                    /**
                     * Verifies a BatchDeleteIntentsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchDeleteIntentsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchDeleteIntentsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchDeleteIntentsRequest;

                    /**
                     * Creates a plain object from a BatchDeleteIntentsRequest message. Also converts values to other types if specified.
                     * @param message BatchDeleteIntentsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchDeleteIntentsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchDeleteIntentsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** IntentView enum. */
                enum IntentView {
                    INTENT_VIEW_UNSPECIFIED = 0,
                    INTENT_VIEW_FULL = 1
                }

                /** Properties of an IntentBatch. */
                interface IIntentBatch {

                    /** IntentBatch intents */
                    intents?: (google.cloud.dialogflow.v2.IIntent[]|null);
                }

                /** Represents an IntentBatch. */
                class IntentBatch implements IIntentBatch {

                    /**
                     * Constructs a new IntentBatch.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IIntentBatch);

                    /** IntentBatch intents. */
                    public intents: google.cloud.dialogflow.v2.IIntent[];

                    /**
                     * Creates a new IntentBatch instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns IntentBatch instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IIntentBatch): google.cloud.dialogflow.v2.IntentBatch;

                    /**
                     * Encodes the specified IntentBatch message. Does not implicitly {@link google.cloud.dialogflow.v2.IntentBatch.verify|verify} messages.
                     * @param message IntentBatch message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IIntentBatch, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified IntentBatch message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.IntentBatch.verify|verify} messages.
                     * @param message IntentBatch message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IIntentBatch, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an IntentBatch message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns IntentBatch
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.IntentBatch;

                    /**
                     * Decodes an IntentBatch message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns IntentBatch
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.IntentBatch;

                    /**
                     * Verifies an IntentBatch message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an IntentBatch message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns IntentBatch
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.IntentBatch;

                    /**
                     * Creates a plain object from an IntentBatch message. Also converts values to other types if specified.
                     * @param message IntentBatch
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.IntentBatch, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this IntentBatch to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents a SessionEntityTypes */
                class SessionEntityTypes extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new SessionEntityTypes service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new SessionEntityTypes service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): SessionEntityTypes;

                    /**
                     * Calls ListSessionEntityTypes.
                     * @param request ListSessionEntityTypesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListSessionEntityTypesResponse
                     */
                    public listSessionEntityTypes(request: google.cloud.dialogflow.v2.IListSessionEntityTypesRequest, callback: google.cloud.dialogflow.v2.SessionEntityTypes.ListSessionEntityTypesCallback): void;

                    /**
                     * Calls ListSessionEntityTypes.
                     * @param request ListSessionEntityTypesRequest message or plain object
                     * @returns Promise
                     */
                    public listSessionEntityTypes(request: google.cloud.dialogflow.v2.IListSessionEntityTypesRequest): Promise<google.cloud.dialogflow.v2.ListSessionEntityTypesResponse>;

                    /**
                     * Calls GetSessionEntityType.
                     * @param request GetSessionEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and SessionEntityType
                     */
                    public getSessionEntityType(request: google.cloud.dialogflow.v2.IGetSessionEntityTypeRequest, callback: google.cloud.dialogflow.v2.SessionEntityTypes.GetSessionEntityTypeCallback): void;

                    /**
                     * Calls GetSessionEntityType.
                     * @param request GetSessionEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public getSessionEntityType(request: google.cloud.dialogflow.v2.IGetSessionEntityTypeRequest): Promise<google.cloud.dialogflow.v2.SessionEntityType>;

                    /**
                     * Calls CreateSessionEntityType.
                     * @param request CreateSessionEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and SessionEntityType
                     */
                    public createSessionEntityType(request: google.cloud.dialogflow.v2.ICreateSessionEntityTypeRequest, callback: google.cloud.dialogflow.v2.SessionEntityTypes.CreateSessionEntityTypeCallback): void;

                    /**
                     * Calls CreateSessionEntityType.
                     * @param request CreateSessionEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public createSessionEntityType(request: google.cloud.dialogflow.v2.ICreateSessionEntityTypeRequest): Promise<google.cloud.dialogflow.v2.SessionEntityType>;

                    /**
                     * Calls UpdateSessionEntityType.
                     * @param request UpdateSessionEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and SessionEntityType
                     */
                    public updateSessionEntityType(request: google.cloud.dialogflow.v2.IUpdateSessionEntityTypeRequest, callback: google.cloud.dialogflow.v2.SessionEntityTypes.UpdateSessionEntityTypeCallback): void;

                    /**
                     * Calls UpdateSessionEntityType.
                     * @param request UpdateSessionEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public updateSessionEntityType(request: google.cloud.dialogflow.v2.IUpdateSessionEntityTypeRequest): Promise<google.cloud.dialogflow.v2.SessionEntityType>;

                    /**
                     * Calls DeleteSessionEntityType.
                     * @param request DeleteSessionEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteSessionEntityType(request: google.cloud.dialogflow.v2.IDeleteSessionEntityTypeRequest, callback: google.cloud.dialogflow.v2.SessionEntityTypes.DeleteSessionEntityTypeCallback): void;

                    /**
                     * Calls DeleteSessionEntityType.
                     * @param request DeleteSessionEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public deleteSessionEntityType(request: google.cloud.dialogflow.v2.IDeleteSessionEntityTypeRequest): Promise<google.protobuf.Empty>;
                }

                namespace SessionEntityTypes {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.SessionEntityTypes#listSessionEntityTypes}.
                     * @param error Error, if any
                     * @param [response] ListSessionEntityTypesResponse
                     */
                    type ListSessionEntityTypesCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListSessionEntityTypesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.SessionEntityTypes#getSessionEntityType}.
                     * @param error Error, if any
                     * @param [response] SessionEntityType
                     */
                    type GetSessionEntityTypeCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.SessionEntityType) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.SessionEntityTypes#createSessionEntityType}.
                     * @param error Error, if any
                     * @param [response] SessionEntityType
                     */
                    type CreateSessionEntityTypeCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.SessionEntityType) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.SessionEntityTypes#updateSessionEntityType}.
                     * @param error Error, if any
                     * @param [response] SessionEntityType
                     */
                    type UpdateSessionEntityTypeCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.SessionEntityType) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.SessionEntityTypes#deleteSessionEntityType}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteSessionEntityTypeCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;
                }

                /** Properties of a SessionEntityType. */
                interface ISessionEntityType {

                    /** SessionEntityType name */
                    name?: (string|null);

                    /** SessionEntityType entityOverrideMode */
                    entityOverrideMode?: (google.cloud.dialogflow.v2.SessionEntityType.EntityOverrideMode|keyof typeof google.cloud.dialogflow.v2.SessionEntityType.EntityOverrideMode|null);

                    /** SessionEntityType entities */
                    entities?: (google.cloud.dialogflow.v2.EntityType.IEntity[]|null);
                }

                /** Represents a SessionEntityType. */
                class SessionEntityType implements ISessionEntityType {

                    /**
                     * Constructs a new SessionEntityType.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ISessionEntityType);

                    /** SessionEntityType name. */
                    public name: string;

                    /** SessionEntityType entityOverrideMode. */
                    public entityOverrideMode: (google.cloud.dialogflow.v2.SessionEntityType.EntityOverrideMode|keyof typeof google.cloud.dialogflow.v2.SessionEntityType.EntityOverrideMode);

                    /** SessionEntityType entities. */
                    public entities: google.cloud.dialogflow.v2.EntityType.IEntity[];

                    /**
                     * Creates a new SessionEntityType instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns SessionEntityType instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ISessionEntityType): google.cloud.dialogflow.v2.SessionEntityType;

                    /**
                     * Encodes the specified SessionEntityType message. Does not implicitly {@link google.cloud.dialogflow.v2.SessionEntityType.verify|verify} messages.
                     * @param message SessionEntityType message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ISessionEntityType, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified SessionEntityType message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SessionEntityType.verify|verify} messages.
                     * @param message SessionEntityType message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ISessionEntityType, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a SessionEntityType message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns SessionEntityType
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.SessionEntityType;

                    /**
                     * Decodes a SessionEntityType message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns SessionEntityType
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.SessionEntityType;

                    /**
                     * Verifies a SessionEntityType message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a SessionEntityType message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns SessionEntityType
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.SessionEntityType;

                    /**
                     * Creates a plain object from a SessionEntityType message. Also converts values to other types if specified.
                     * @param message SessionEntityType
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.SessionEntityType, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this SessionEntityType to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace SessionEntityType {

                    /** EntityOverrideMode enum. */
                    enum EntityOverrideMode {
                        ENTITY_OVERRIDE_MODE_UNSPECIFIED = 0,
                        ENTITY_OVERRIDE_MODE_OVERRIDE = 1,
                        ENTITY_OVERRIDE_MODE_SUPPLEMENT = 2
                    }
                }

                /** Properties of a ListSessionEntityTypesRequest. */
                interface IListSessionEntityTypesRequest {

                    /** ListSessionEntityTypesRequest parent */
                    parent?: (string|null);

                    /** ListSessionEntityTypesRequest pageSize */
                    pageSize?: (number|null);

                    /** ListSessionEntityTypesRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListSessionEntityTypesRequest. */
                class ListSessionEntityTypesRequest implements IListSessionEntityTypesRequest {

                    /**
                     * Constructs a new ListSessionEntityTypesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListSessionEntityTypesRequest);

                    /** ListSessionEntityTypesRequest parent. */
                    public parent: string;

                    /** ListSessionEntityTypesRequest pageSize. */
                    public pageSize: number;

                    /** ListSessionEntityTypesRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListSessionEntityTypesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListSessionEntityTypesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListSessionEntityTypesRequest): google.cloud.dialogflow.v2.ListSessionEntityTypesRequest;

                    /**
                     * Encodes the specified ListSessionEntityTypesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListSessionEntityTypesRequest.verify|verify} messages.
                     * @param message ListSessionEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListSessionEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListSessionEntityTypesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListSessionEntityTypesRequest.verify|verify} messages.
                     * @param message ListSessionEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListSessionEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListSessionEntityTypesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListSessionEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListSessionEntityTypesRequest;

                    /**
                     * Decodes a ListSessionEntityTypesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListSessionEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListSessionEntityTypesRequest;

                    /**
                     * Verifies a ListSessionEntityTypesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListSessionEntityTypesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListSessionEntityTypesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListSessionEntityTypesRequest;

                    /**
                     * Creates a plain object from a ListSessionEntityTypesRequest message. Also converts values to other types if specified.
                     * @param message ListSessionEntityTypesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListSessionEntityTypesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListSessionEntityTypesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListSessionEntityTypesResponse. */
                interface IListSessionEntityTypesResponse {

                    /** ListSessionEntityTypesResponse sessionEntityTypes */
                    sessionEntityTypes?: (google.cloud.dialogflow.v2.ISessionEntityType[]|null);

                    /** ListSessionEntityTypesResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListSessionEntityTypesResponse. */
                class ListSessionEntityTypesResponse implements IListSessionEntityTypesResponse {

                    /**
                     * Constructs a new ListSessionEntityTypesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListSessionEntityTypesResponse);

                    /** ListSessionEntityTypesResponse sessionEntityTypes. */
                    public sessionEntityTypes: google.cloud.dialogflow.v2.ISessionEntityType[];

                    /** ListSessionEntityTypesResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListSessionEntityTypesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListSessionEntityTypesResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListSessionEntityTypesResponse): google.cloud.dialogflow.v2.ListSessionEntityTypesResponse;

                    /**
                     * Encodes the specified ListSessionEntityTypesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListSessionEntityTypesResponse.verify|verify} messages.
                     * @param message ListSessionEntityTypesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListSessionEntityTypesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListSessionEntityTypesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListSessionEntityTypesResponse.verify|verify} messages.
                     * @param message ListSessionEntityTypesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListSessionEntityTypesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListSessionEntityTypesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListSessionEntityTypesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListSessionEntityTypesResponse;

                    /**
                     * Decodes a ListSessionEntityTypesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListSessionEntityTypesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListSessionEntityTypesResponse;

                    /**
                     * Verifies a ListSessionEntityTypesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListSessionEntityTypesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListSessionEntityTypesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListSessionEntityTypesResponse;

                    /**
                     * Creates a plain object from a ListSessionEntityTypesResponse message. Also converts values to other types if specified.
                     * @param message ListSessionEntityTypesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListSessionEntityTypesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListSessionEntityTypesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetSessionEntityTypeRequest. */
                interface IGetSessionEntityTypeRequest {

                    /** GetSessionEntityTypeRequest name */
                    name?: (string|null);
                }

                /** Represents a GetSessionEntityTypeRequest. */
                class GetSessionEntityTypeRequest implements IGetSessionEntityTypeRequest {

                    /**
                     * Constructs a new GetSessionEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetSessionEntityTypeRequest);

                    /** GetSessionEntityTypeRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetSessionEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetSessionEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetSessionEntityTypeRequest): google.cloud.dialogflow.v2.GetSessionEntityTypeRequest;

                    /**
                     * Encodes the specified GetSessionEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetSessionEntityTypeRequest.verify|verify} messages.
                     * @param message GetSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetSessionEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetSessionEntityTypeRequest.verify|verify} messages.
                     * @param message GetSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetSessionEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetSessionEntityTypeRequest;

                    /**
                     * Decodes a GetSessionEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetSessionEntityTypeRequest;

                    /**
                     * Verifies a GetSessionEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetSessionEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetSessionEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetSessionEntityTypeRequest;

                    /**
                     * Creates a plain object from a GetSessionEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message GetSessionEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetSessionEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetSessionEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a CreateSessionEntityTypeRequest. */
                interface ICreateSessionEntityTypeRequest {

                    /** CreateSessionEntityTypeRequest parent */
                    parent?: (string|null);

                    /** CreateSessionEntityTypeRequest sessionEntityType */
                    sessionEntityType?: (google.cloud.dialogflow.v2.ISessionEntityType|null);
                }

                /** Represents a CreateSessionEntityTypeRequest. */
                class CreateSessionEntityTypeRequest implements ICreateSessionEntityTypeRequest {

                    /**
                     * Constructs a new CreateSessionEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICreateSessionEntityTypeRequest);

                    /** CreateSessionEntityTypeRequest parent. */
                    public parent: string;

                    /** CreateSessionEntityTypeRequest sessionEntityType. */
                    public sessionEntityType?: (google.cloud.dialogflow.v2.ISessionEntityType|null);

                    /**
                     * Creates a new CreateSessionEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateSessionEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICreateSessionEntityTypeRequest): google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest;

                    /**
                     * Encodes the specified CreateSessionEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest.verify|verify} messages.
                     * @param message CreateSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICreateSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateSessionEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest.verify|verify} messages.
                     * @param message CreateSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICreateSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateSessionEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest;

                    /**
                     * Decodes a CreateSessionEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest;

                    /**
                     * Verifies a CreateSessionEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateSessionEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateSessionEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest;

                    /**
                     * Creates a plain object from a CreateSessionEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message CreateSessionEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateSessionEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an UpdateSessionEntityTypeRequest. */
                interface IUpdateSessionEntityTypeRequest {

                    /** UpdateSessionEntityTypeRequest sessionEntityType */
                    sessionEntityType?: (google.cloud.dialogflow.v2.ISessionEntityType|null);

                    /** UpdateSessionEntityTypeRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateSessionEntityTypeRequest. */
                class UpdateSessionEntityTypeRequest implements IUpdateSessionEntityTypeRequest {

                    /**
                     * Constructs a new UpdateSessionEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IUpdateSessionEntityTypeRequest);

                    /** UpdateSessionEntityTypeRequest sessionEntityType. */
                    public sessionEntityType?: (google.cloud.dialogflow.v2.ISessionEntityType|null);

                    /** UpdateSessionEntityTypeRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateSessionEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateSessionEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IUpdateSessionEntityTypeRequest): google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest;

                    /**
                     * Encodes the specified UpdateSessionEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest.verify|verify} messages.
                     * @param message UpdateSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IUpdateSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateSessionEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest.verify|verify} messages.
                     * @param message UpdateSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IUpdateSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateSessionEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest;

                    /**
                     * Decodes an UpdateSessionEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest;

                    /**
                     * Verifies an UpdateSessionEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateSessionEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateSessionEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest;

                    /**
                     * Creates a plain object from an UpdateSessionEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message UpdateSessionEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateSessionEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DeleteSessionEntityTypeRequest. */
                interface IDeleteSessionEntityTypeRequest {

                    /** DeleteSessionEntityTypeRequest name */
                    name?: (string|null);
                }

                /** Represents a DeleteSessionEntityTypeRequest. */
                class DeleteSessionEntityTypeRequest implements IDeleteSessionEntityTypeRequest {

                    /**
                     * Constructs a new DeleteSessionEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDeleteSessionEntityTypeRequest);

                    /** DeleteSessionEntityTypeRequest name. */
                    public name: string;

                    /**
                     * Creates a new DeleteSessionEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteSessionEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDeleteSessionEntityTypeRequest): google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest;

                    /**
                     * Encodes the specified DeleteSessionEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest.verify|verify} messages.
                     * @param message DeleteSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDeleteSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteSessionEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest.verify|verify} messages.
                     * @param message DeleteSessionEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDeleteSessionEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteSessionEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest;

                    /**
                     * Decodes a DeleteSessionEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteSessionEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest;

                    /**
                     * Verifies a DeleteSessionEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteSessionEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteSessionEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest;

                    /**
                     * Creates a plain object from a DeleteSessionEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message DeleteSessionEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteSessionEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents an EntityTypes */
                class EntityTypes extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new EntityTypes service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new EntityTypes service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): EntityTypes;

                    /**
                     * Calls ListEntityTypes.
                     * @param request ListEntityTypesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListEntityTypesResponse
                     */
                    public listEntityTypes(request: google.cloud.dialogflow.v2.IListEntityTypesRequest, callback: google.cloud.dialogflow.v2.EntityTypes.ListEntityTypesCallback): void;

                    /**
                     * Calls ListEntityTypes.
                     * @param request ListEntityTypesRequest message or plain object
                     * @returns Promise
                     */
                    public listEntityTypes(request: google.cloud.dialogflow.v2.IListEntityTypesRequest): Promise<google.cloud.dialogflow.v2.ListEntityTypesResponse>;

                    /**
                     * Calls GetEntityType.
                     * @param request GetEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and EntityType
                     */
                    public getEntityType(request: google.cloud.dialogflow.v2.IGetEntityTypeRequest, callback: google.cloud.dialogflow.v2.EntityTypes.GetEntityTypeCallback): void;

                    /**
                     * Calls GetEntityType.
                     * @param request GetEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public getEntityType(request: google.cloud.dialogflow.v2.IGetEntityTypeRequest): Promise<google.cloud.dialogflow.v2.EntityType>;

                    /**
                     * Calls CreateEntityType.
                     * @param request CreateEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and EntityType
                     */
                    public createEntityType(request: google.cloud.dialogflow.v2.ICreateEntityTypeRequest, callback: google.cloud.dialogflow.v2.EntityTypes.CreateEntityTypeCallback): void;

                    /**
                     * Calls CreateEntityType.
                     * @param request CreateEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public createEntityType(request: google.cloud.dialogflow.v2.ICreateEntityTypeRequest): Promise<google.cloud.dialogflow.v2.EntityType>;

                    /**
                     * Calls UpdateEntityType.
                     * @param request UpdateEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and EntityType
                     */
                    public updateEntityType(request: google.cloud.dialogflow.v2.IUpdateEntityTypeRequest, callback: google.cloud.dialogflow.v2.EntityTypes.UpdateEntityTypeCallback): void;

                    /**
                     * Calls UpdateEntityType.
                     * @param request UpdateEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public updateEntityType(request: google.cloud.dialogflow.v2.IUpdateEntityTypeRequest): Promise<google.cloud.dialogflow.v2.EntityType>;

                    /**
                     * Calls DeleteEntityType.
                     * @param request DeleteEntityTypeRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Empty
                     */
                    public deleteEntityType(request: google.cloud.dialogflow.v2.IDeleteEntityTypeRequest, callback: google.cloud.dialogflow.v2.EntityTypes.DeleteEntityTypeCallback): void;

                    /**
                     * Calls DeleteEntityType.
                     * @param request DeleteEntityTypeRequest message or plain object
                     * @returns Promise
                     */
                    public deleteEntityType(request: google.cloud.dialogflow.v2.IDeleteEntityTypeRequest): Promise<google.protobuf.Empty>;

                    /**
                     * Calls BatchUpdateEntityTypes.
                     * @param request BatchUpdateEntityTypesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchUpdateEntityTypes(request: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesRequest, callback: google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypesCallback): void;

                    /**
                     * Calls BatchUpdateEntityTypes.
                     * @param request BatchUpdateEntityTypesRequest message or plain object
                     * @returns Promise
                     */
                    public batchUpdateEntityTypes(request: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls BatchDeleteEntityTypes.
                     * @param request BatchDeleteEntityTypesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchDeleteEntityTypes(request: google.cloud.dialogflow.v2.IBatchDeleteEntityTypesRequest, callback: google.cloud.dialogflow.v2.EntityTypes.BatchDeleteEntityTypesCallback): void;

                    /**
                     * Calls BatchDeleteEntityTypes.
                     * @param request BatchDeleteEntityTypesRequest message or plain object
                     * @returns Promise
                     */
                    public batchDeleteEntityTypes(request: google.cloud.dialogflow.v2.IBatchDeleteEntityTypesRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls BatchCreateEntities.
                     * @param request BatchCreateEntitiesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchCreateEntities(request: google.cloud.dialogflow.v2.IBatchCreateEntitiesRequest, callback: google.cloud.dialogflow.v2.EntityTypes.BatchCreateEntitiesCallback): void;

                    /**
                     * Calls BatchCreateEntities.
                     * @param request BatchCreateEntitiesRequest message or plain object
                     * @returns Promise
                     */
                    public batchCreateEntities(request: google.cloud.dialogflow.v2.IBatchCreateEntitiesRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls BatchUpdateEntities.
                     * @param request BatchUpdateEntitiesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchUpdateEntities(request: google.cloud.dialogflow.v2.IBatchUpdateEntitiesRequest, callback: google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntitiesCallback): void;

                    /**
                     * Calls BatchUpdateEntities.
                     * @param request BatchUpdateEntitiesRequest message or plain object
                     * @returns Promise
                     */
                    public batchUpdateEntities(request: google.cloud.dialogflow.v2.IBatchUpdateEntitiesRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls BatchDeleteEntities.
                     * @param request BatchDeleteEntitiesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public batchDeleteEntities(request: google.cloud.dialogflow.v2.IBatchDeleteEntitiesRequest, callback: google.cloud.dialogflow.v2.EntityTypes.BatchDeleteEntitiesCallback): void;

                    /**
                     * Calls BatchDeleteEntities.
                     * @param request BatchDeleteEntitiesRequest message or plain object
                     * @returns Promise
                     */
                    public batchDeleteEntities(request: google.cloud.dialogflow.v2.IBatchDeleteEntitiesRequest): Promise<google.longrunning.Operation>;
                }

                namespace EntityTypes {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#listEntityTypes}.
                     * @param error Error, if any
                     * @param [response] ListEntityTypesResponse
                     */
                    type ListEntityTypesCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListEntityTypesResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#getEntityType}.
                     * @param error Error, if any
                     * @param [response] EntityType
                     */
                    type GetEntityTypeCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.EntityType) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#createEntityType}.
                     * @param error Error, if any
                     * @param [response] EntityType
                     */
                    type CreateEntityTypeCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.EntityType) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#updateEntityType}.
                     * @param error Error, if any
                     * @param [response] EntityType
                     */
                    type UpdateEntityTypeCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.EntityType) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#deleteEntityType}.
                     * @param error Error, if any
                     * @param [response] Empty
                     */
                    type DeleteEntityTypeCallback = (error: (Error|null), response?: google.protobuf.Empty) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#batchUpdateEntityTypes}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchUpdateEntityTypesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#batchDeleteEntityTypes}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchDeleteEntityTypesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#batchCreateEntities}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchCreateEntitiesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#batchUpdateEntities}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchUpdateEntitiesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.EntityTypes#batchDeleteEntities}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type BatchDeleteEntitiesCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;
                }

                /** Properties of an EntityType. */
                interface IEntityType {

                    /** EntityType name */
                    name?: (string|null);

                    /** EntityType displayName */
                    displayName?: (string|null);

                    /** EntityType kind */
                    kind?: (google.cloud.dialogflow.v2.EntityType.Kind|keyof typeof google.cloud.dialogflow.v2.EntityType.Kind|null);

                    /** EntityType autoExpansionMode */
                    autoExpansionMode?: (google.cloud.dialogflow.v2.EntityType.AutoExpansionMode|keyof typeof google.cloud.dialogflow.v2.EntityType.AutoExpansionMode|null);

                    /** EntityType entities */
                    entities?: (google.cloud.dialogflow.v2.EntityType.IEntity[]|null);

                    /** EntityType enableFuzzyExtraction */
                    enableFuzzyExtraction?: (boolean|null);
                }

                /** Represents an EntityType. */
                class EntityType implements IEntityType {

                    /**
                     * Constructs a new EntityType.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IEntityType);

                    /** EntityType name. */
                    public name: string;

                    /** EntityType displayName. */
                    public displayName: string;

                    /** EntityType kind. */
                    public kind: (google.cloud.dialogflow.v2.EntityType.Kind|keyof typeof google.cloud.dialogflow.v2.EntityType.Kind);

                    /** EntityType autoExpansionMode. */
                    public autoExpansionMode: (google.cloud.dialogflow.v2.EntityType.AutoExpansionMode|keyof typeof google.cloud.dialogflow.v2.EntityType.AutoExpansionMode);

                    /** EntityType entities. */
                    public entities: google.cloud.dialogflow.v2.EntityType.IEntity[];

                    /** EntityType enableFuzzyExtraction. */
                    public enableFuzzyExtraction: boolean;

                    /**
                     * Creates a new EntityType instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EntityType instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IEntityType): google.cloud.dialogflow.v2.EntityType;

                    /**
                     * Encodes the specified EntityType message. Does not implicitly {@link google.cloud.dialogflow.v2.EntityType.verify|verify} messages.
                     * @param message EntityType message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IEntityType, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EntityType message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.EntityType.verify|verify} messages.
                     * @param message EntityType message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IEntityType, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EntityType message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EntityType
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.EntityType;

                    /**
                     * Decodes an EntityType message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EntityType
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.EntityType;

                    /**
                     * Verifies an EntityType message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EntityType message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EntityType
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.EntityType;

                    /**
                     * Creates a plain object from an EntityType message. Also converts values to other types if specified.
                     * @param message EntityType
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.EntityType, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EntityType to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace EntityType {

                    /** Kind enum. */
                    enum Kind {
                        KIND_UNSPECIFIED = 0,
                        KIND_MAP = 1,
                        KIND_LIST = 2,
                        KIND_REGEXP = 3
                    }

                    /** AutoExpansionMode enum. */
                    enum AutoExpansionMode {
                        AUTO_EXPANSION_MODE_UNSPECIFIED = 0,
                        AUTO_EXPANSION_MODE_DEFAULT = 1
                    }

                    /** Properties of an Entity. */
                    interface IEntity {

                        /** Entity value */
                        value?: (string|null);

                        /** Entity synonyms */
                        synonyms?: (string[]|null);
                    }

                    /** Represents an Entity. */
                    class Entity implements IEntity {

                        /**
                         * Constructs a new Entity.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: google.cloud.dialogflow.v2.EntityType.IEntity);

                        /** Entity value. */
                        public value: string;

                        /** Entity synonyms. */
                        public synonyms: string[];

                        /**
                         * Creates a new Entity instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Entity instance
                         */
                        public static create(properties?: google.cloud.dialogflow.v2.EntityType.IEntity): google.cloud.dialogflow.v2.EntityType.Entity;

                        /**
                         * Encodes the specified Entity message. Does not implicitly {@link google.cloud.dialogflow.v2.EntityType.Entity.verify|verify} messages.
                         * @param message Entity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: google.cloud.dialogflow.v2.EntityType.IEntity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Entity message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.EntityType.Entity.verify|verify} messages.
                         * @param message Entity message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: google.cloud.dialogflow.v2.EntityType.IEntity, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an Entity message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Entity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.EntityType.Entity;

                        /**
                         * Decodes an Entity message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Entity
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.EntityType.Entity;

                        /**
                         * Verifies an Entity message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an Entity message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Entity
                         */
                        public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.EntityType.Entity;

                        /**
                         * Creates a plain object from an Entity message. Also converts values to other types if specified.
                         * @param message Entity
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: google.cloud.dialogflow.v2.EntityType.Entity, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Entity to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }
                }

                /** Properties of a ListEntityTypesRequest. */
                interface IListEntityTypesRequest {

                    /** ListEntityTypesRequest parent */
                    parent?: (string|null);

                    /** ListEntityTypesRequest languageCode */
                    languageCode?: (string|null);

                    /** ListEntityTypesRequest pageSize */
                    pageSize?: (number|null);

                    /** ListEntityTypesRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListEntityTypesRequest. */
                class ListEntityTypesRequest implements IListEntityTypesRequest {

                    /**
                     * Constructs a new ListEntityTypesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListEntityTypesRequest);

                    /** ListEntityTypesRequest parent. */
                    public parent: string;

                    /** ListEntityTypesRequest languageCode. */
                    public languageCode: string;

                    /** ListEntityTypesRequest pageSize. */
                    public pageSize: number;

                    /** ListEntityTypesRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListEntityTypesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListEntityTypesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListEntityTypesRequest): google.cloud.dialogflow.v2.ListEntityTypesRequest;

                    /**
                     * Encodes the specified ListEntityTypesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListEntityTypesRequest.verify|verify} messages.
                     * @param message ListEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListEntityTypesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListEntityTypesRequest.verify|verify} messages.
                     * @param message ListEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListEntityTypesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListEntityTypesRequest;

                    /**
                     * Decodes a ListEntityTypesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListEntityTypesRequest;

                    /**
                     * Verifies a ListEntityTypesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListEntityTypesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListEntityTypesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListEntityTypesRequest;

                    /**
                     * Creates a plain object from a ListEntityTypesRequest message. Also converts values to other types if specified.
                     * @param message ListEntityTypesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListEntityTypesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListEntityTypesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListEntityTypesResponse. */
                interface IListEntityTypesResponse {

                    /** ListEntityTypesResponse entityTypes */
                    entityTypes?: (google.cloud.dialogflow.v2.IEntityType[]|null);

                    /** ListEntityTypesResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListEntityTypesResponse. */
                class ListEntityTypesResponse implements IListEntityTypesResponse {

                    /**
                     * Constructs a new ListEntityTypesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListEntityTypesResponse);

                    /** ListEntityTypesResponse entityTypes. */
                    public entityTypes: google.cloud.dialogflow.v2.IEntityType[];

                    /** ListEntityTypesResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListEntityTypesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListEntityTypesResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListEntityTypesResponse): google.cloud.dialogflow.v2.ListEntityTypesResponse;

                    /**
                     * Encodes the specified ListEntityTypesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListEntityTypesResponse.verify|verify} messages.
                     * @param message ListEntityTypesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListEntityTypesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListEntityTypesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListEntityTypesResponse.verify|verify} messages.
                     * @param message ListEntityTypesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListEntityTypesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListEntityTypesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListEntityTypesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListEntityTypesResponse;

                    /**
                     * Decodes a ListEntityTypesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListEntityTypesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListEntityTypesResponse;

                    /**
                     * Verifies a ListEntityTypesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListEntityTypesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListEntityTypesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListEntityTypesResponse;

                    /**
                     * Creates a plain object from a ListEntityTypesResponse message. Also converts values to other types if specified.
                     * @param message ListEntityTypesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListEntityTypesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListEntityTypesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetEntityTypeRequest. */
                interface IGetEntityTypeRequest {

                    /** GetEntityTypeRequest name */
                    name?: (string|null);

                    /** GetEntityTypeRequest languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a GetEntityTypeRequest. */
                class GetEntityTypeRequest implements IGetEntityTypeRequest {

                    /**
                     * Constructs a new GetEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetEntityTypeRequest);

                    /** GetEntityTypeRequest name. */
                    public name: string;

                    /** GetEntityTypeRequest languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new GetEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetEntityTypeRequest): google.cloud.dialogflow.v2.GetEntityTypeRequest;

                    /**
                     * Encodes the specified GetEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetEntityTypeRequest.verify|verify} messages.
                     * @param message GetEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetEntityTypeRequest.verify|verify} messages.
                     * @param message GetEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetEntityTypeRequest;

                    /**
                     * Decodes a GetEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetEntityTypeRequest;

                    /**
                     * Verifies a GetEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetEntityTypeRequest;

                    /**
                     * Creates a plain object from a GetEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message GetEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a CreateEntityTypeRequest. */
                interface ICreateEntityTypeRequest {

                    /** CreateEntityTypeRequest parent */
                    parent?: (string|null);

                    /** CreateEntityTypeRequest entityType */
                    entityType?: (google.cloud.dialogflow.v2.IEntityType|null);

                    /** CreateEntityTypeRequest languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a CreateEntityTypeRequest. */
                class CreateEntityTypeRequest implements ICreateEntityTypeRequest {

                    /**
                     * Constructs a new CreateEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICreateEntityTypeRequest);

                    /** CreateEntityTypeRequest parent. */
                    public parent: string;

                    /** CreateEntityTypeRequest entityType. */
                    public entityType?: (google.cloud.dialogflow.v2.IEntityType|null);

                    /** CreateEntityTypeRequest languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new CreateEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICreateEntityTypeRequest): google.cloud.dialogflow.v2.CreateEntityTypeRequest;

                    /**
                     * Encodes the specified CreateEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateEntityTypeRequest.verify|verify} messages.
                     * @param message CreateEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICreateEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateEntityTypeRequest.verify|verify} messages.
                     * @param message CreateEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICreateEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CreateEntityTypeRequest;

                    /**
                     * Decodes a CreateEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CreateEntityTypeRequest;

                    /**
                     * Verifies a CreateEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CreateEntityTypeRequest;

                    /**
                     * Creates a plain object from a CreateEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message CreateEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CreateEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an UpdateEntityTypeRequest. */
                interface IUpdateEntityTypeRequest {

                    /** UpdateEntityTypeRequest entityType */
                    entityType?: (google.cloud.dialogflow.v2.IEntityType|null);

                    /** UpdateEntityTypeRequest languageCode */
                    languageCode?: (string|null);

                    /** UpdateEntityTypeRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents an UpdateEntityTypeRequest. */
                class UpdateEntityTypeRequest implements IUpdateEntityTypeRequest {

                    /**
                     * Constructs a new UpdateEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IUpdateEntityTypeRequest);

                    /** UpdateEntityTypeRequest entityType. */
                    public entityType?: (google.cloud.dialogflow.v2.IEntityType|null);

                    /** UpdateEntityTypeRequest languageCode. */
                    public languageCode: string;

                    /** UpdateEntityTypeRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new UpdateEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns UpdateEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IUpdateEntityTypeRequest): google.cloud.dialogflow.v2.UpdateEntityTypeRequest;

                    /**
                     * Encodes the specified UpdateEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateEntityTypeRequest.verify|verify} messages.
                     * @param message UpdateEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IUpdateEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified UpdateEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateEntityTypeRequest.verify|verify} messages.
                     * @param message UpdateEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IUpdateEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an UpdateEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns UpdateEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.UpdateEntityTypeRequest;

                    /**
                     * Decodes an UpdateEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns UpdateEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.UpdateEntityTypeRequest;

                    /**
                     * Verifies an UpdateEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an UpdateEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns UpdateEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.UpdateEntityTypeRequest;

                    /**
                     * Creates a plain object from an UpdateEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message UpdateEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.UpdateEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this UpdateEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a DeleteEntityTypeRequest. */
                interface IDeleteEntityTypeRequest {

                    /** DeleteEntityTypeRequest name */
                    name?: (string|null);
                }

                /** Represents a DeleteEntityTypeRequest. */
                class DeleteEntityTypeRequest implements IDeleteEntityTypeRequest {

                    /**
                     * Constructs a new DeleteEntityTypeRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IDeleteEntityTypeRequest);

                    /** DeleteEntityTypeRequest name. */
                    public name: string;

                    /**
                     * Creates a new DeleteEntityTypeRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns DeleteEntityTypeRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IDeleteEntityTypeRequest): google.cloud.dialogflow.v2.DeleteEntityTypeRequest;

                    /**
                     * Encodes the specified DeleteEntityTypeRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteEntityTypeRequest.verify|verify} messages.
                     * @param message DeleteEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IDeleteEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified DeleteEntityTypeRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteEntityTypeRequest.verify|verify} messages.
                     * @param message DeleteEntityTypeRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IDeleteEntityTypeRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a DeleteEntityTypeRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns DeleteEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.DeleteEntityTypeRequest;

                    /**
                     * Decodes a DeleteEntityTypeRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns DeleteEntityTypeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.DeleteEntityTypeRequest;

                    /**
                     * Verifies a DeleteEntityTypeRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a DeleteEntityTypeRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns DeleteEntityTypeRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.DeleteEntityTypeRequest;

                    /**
                     * Creates a plain object from a DeleteEntityTypeRequest message. Also converts values to other types if specified.
                     * @param message DeleteEntityTypeRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.DeleteEntityTypeRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this DeleteEntityTypeRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchUpdateEntityTypesRequest. */
                interface IBatchUpdateEntityTypesRequest {

                    /** BatchUpdateEntityTypesRequest parent */
                    parent?: (string|null);

                    /** BatchUpdateEntityTypesRequest entityTypeBatchUri */
                    entityTypeBatchUri?: (string|null);

                    /** BatchUpdateEntityTypesRequest entityTypeBatchInline */
                    entityTypeBatchInline?: (google.cloud.dialogflow.v2.IEntityTypeBatch|null);

                    /** BatchUpdateEntityTypesRequest languageCode */
                    languageCode?: (string|null);

                    /** BatchUpdateEntityTypesRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents a BatchUpdateEntityTypesRequest. */
                class BatchUpdateEntityTypesRequest implements IBatchUpdateEntityTypesRequest {

                    /**
                     * Constructs a new BatchUpdateEntityTypesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesRequest);

                    /** BatchUpdateEntityTypesRequest parent. */
                    public parent: string;

                    /** BatchUpdateEntityTypesRequest entityTypeBatchUri. */
                    public entityTypeBatchUri?: (string|null);

                    /** BatchUpdateEntityTypesRequest entityTypeBatchInline. */
                    public entityTypeBatchInline?: (google.cloud.dialogflow.v2.IEntityTypeBatch|null);

                    /** BatchUpdateEntityTypesRequest languageCode. */
                    public languageCode: string;

                    /** BatchUpdateEntityTypesRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /** BatchUpdateEntityTypesRequest entityTypeBatch. */
                    public entityTypeBatch?: ("entityTypeBatchUri"|"entityTypeBatchInline");

                    /**
                     * Creates a new BatchUpdateEntityTypesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchUpdateEntityTypesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesRequest): google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest;

                    /**
                     * Encodes the specified BatchUpdateEntityTypesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest.verify|verify} messages.
                     * @param message BatchUpdateEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchUpdateEntityTypesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest.verify|verify} messages.
                     * @param message BatchUpdateEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchUpdateEntityTypesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchUpdateEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest;

                    /**
                     * Decodes a BatchUpdateEntityTypesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchUpdateEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest;

                    /**
                     * Verifies a BatchUpdateEntityTypesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchUpdateEntityTypesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchUpdateEntityTypesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest;

                    /**
                     * Creates a plain object from a BatchUpdateEntityTypesRequest message. Also converts values to other types if specified.
                     * @param message BatchUpdateEntityTypesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchUpdateEntityTypesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchUpdateEntityTypesResponse. */
                interface IBatchUpdateEntityTypesResponse {

                    /** BatchUpdateEntityTypesResponse entityTypes */
                    entityTypes?: (google.cloud.dialogflow.v2.IEntityType[]|null);
                }

                /** Represents a BatchUpdateEntityTypesResponse. */
                class BatchUpdateEntityTypesResponse implements IBatchUpdateEntityTypesResponse {

                    /**
                     * Constructs a new BatchUpdateEntityTypesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesResponse);

                    /** BatchUpdateEntityTypesResponse entityTypes. */
                    public entityTypes: google.cloud.dialogflow.v2.IEntityType[];

                    /**
                     * Creates a new BatchUpdateEntityTypesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchUpdateEntityTypesResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesResponse): google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse;

                    /**
                     * Encodes the specified BatchUpdateEntityTypesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse.verify|verify} messages.
                     * @param message BatchUpdateEntityTypesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchUpdateEntityTypesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse.verify|verify} messages.
                     * @param message BatchUpdateEntityTypesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchUpdateEntityTypesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchUpdateEntityTypesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchUpdateEntityTypesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse;

                    /**
                     * Decodes a BatchUpdateEntityTypesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchUpdateEntityTypesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse;

                    /**
                     * Verifies a BatchUpdateEntityTypesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchUpdateEntityTypesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchUpdateEntityTypesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse;

                    /**
                     * Creates a plain object from a BatchUpdateEntityTypesResponse message. Also converts values to other types if specified.
                     * @param message BatchUpdateEntityTypesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchUpdateEntityTypesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchDeleteEntityTypesRequest. */
                interface IBatchDeleteEntityTypesRequest {

                    /** BatchDeleteEntityTypesRequest parent */
                    parent?: (string|null);

                    /** BatchDeleteEntityTypesRequest entityTypeNames */
                    entityTypeNames?: (string[]|null);
                }

                /** Represents a BatchDeleteEntityTypesRequest. */
                class BatchDeleteEntityTypesRequest implements IBatchDeleteEntityTypesRequest {

                    /**
                     * Constructs a new BatchDeleteEntityTypesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchDeleteEntityTypesRequest);

                    /** BatchDeleteEntityTypesRequest parent. */
                    public parent: string;

                    /** BatchDeleteEntityTypesRequest entityTypeNames. */
                    public entityTypeNames: string[];

                    /**
                     * Creates a new BatchDeleteEntityTypesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchDeleteEntityTypesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchDeleteEntityTypesRequest): google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest;

                    /**
                     * Encodes the specified BatchDeleteEntityTypesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest.verify|verify} messages.
                     * @param message BatchDeleteEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchDeleteEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchDeleteEntityTypesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest.verify|verify} messages.
                     * @param message BatchDeleteEntityTypesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchDeleteEntityTypesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchDeleteEntityTypesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchDeleteEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest;

                    /**
                     * Decodes a BatchDeleteEntityTypesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchDeleteEntityTypesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest;

                    /**
                     * Verifies a BatchDeleteEntityTypesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchDeleteEntityTypesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchDeleteEntityTypesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest;

                    /**
                     * Creates a plain object from a BatchDeleteEntityTypesRequest message. Also converts values to other types if specified.
                     * @param message BatchDeleteEntityTypesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchDeleteEntityTypesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchCreateEntitiesRequest. */
                interface IBatchCreateEntitiesRequest {

                    /** BatchCreateEntitiesRequest parent */
                    parent?: (string|null);

                    /** BatchCreateEntitiesRequest entities */
                    entities?: (google.cloud.dialogflow.v2.EntityType.IEntity[]|null);

                    /** BatchCreateEntitiesRequest languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a BatchCreateEntitiesRequest. */
                class BatchCreateEntitiesRequest implements IBatchCreateEntitiesRequest {

                    /**
                     * Constructs a new BatchCreateEntitiesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchCreateEntitiesRequest);

                    /** BatchCreateEntitiesRequest parent. */
                    public parent: string;

                    /** BatchCreateEntitiesRequest entities. */
                    public entities: google.cloud.dialogflow.v2.EntityType.IEntity[];

                    /** BatchCreateEntitiesRequest languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new BatchCreateEntitiesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchCreateEntitiesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchCreateEntitiesRequest): google.cloud.dialogflow.v2.BatchCreateEntitiesRequest;

                    /**
                     * Encodes the specified BatchCreateEntitiesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchCreateEntitiesRequest.verify|verify} messages.
                     * @param message BatchCreateEntitiesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchCreateEntitiesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchCreateEntitiesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchCreateEntitiesRequest.verify|verify} messages.
                     * @param message BatchCreateEntitiesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchCreateEntitiesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchCreateEntitiesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchCreateEntitiesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchCreateEntitiesRequest;

                    /**
                     * Decodes a BatchCreateEntitiesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchCreateEntitiesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchCreateEntitiesRequest;

                    /**
                     * Verifies a BatchCreateEntitiesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchCreateEntitiesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchCreateEntitiesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchCreateEntitiesRequest;

                    /**
                     * Creates a plain object from a BatchCreateEntitiesRequest message. Also converts values to other types if specified.
                     * @param message BatchCreateEntitiesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchCreateEntitiesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchCreateEntitiesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchUpdateEntitiesRequest. */
                interface IBatchUpdateEntitiesRequest {

                    /** BatchUpdateEntitiesRequest parent */
                    parent?: (string|null);

                    /** BatchUpdateEntitiesRequest entities */
                    entities?: (google.cloud.dialogflow.v2.EntityType.IEntity[]|null);

                    /** BatchUpdateEntitiesRequest languageCode */
                    languageCode?: (string|null);

                    /** BatchUpdateEntitiesRequest updateMask */
                    updateMask?: (google.protobuf.IFieldMask|null);
                }

                /** Represents a BatchUpdateEntitiesRequest. */
                class BatchUpdateEntitiesRequest implements IBatchUpdateEntitiesRequest {

                    /**
                     * Constructs a new BatchUpdateEntitiesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchUpdateEntitiesRequest);

                    /** BatchUpdateEntitiesRequest parent. */
                    public parent: string;

                    /** BatchUpdateEntitiesRequest entities. */
                    public entities: google.cloud.dialogflow.v2.EntityType.IEntity[];

                    /** BatchUpdateEntitiesRequest languageCode. */
                    public languageCode: string;

                    /** BatchUpdateEntitiesRequest updateMask. */
                    public updateMask?: (google.protobuf.IFieldMask|null);

                    /**
                     * Creates a new BatchUpdateEntitiesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchUpdateEntitiesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchUpdateEntitiesRequest): google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest;

                    /**
                     * Encodes the specified BatchUpdateEntitiesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest.verify|verify} messages.
                     * @param message BatchUpdateEntitiesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchUpdateEntitiesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchUpdateEntitiesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest.verify|verify} messages.
                     * @param message BatchUpdateEntitiesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchUpdateEntitiesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchUpdateEntitiesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchUpdateEntitiesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest;

                    /**
                     * Decodes a BatchUpdateEntitiesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchUpdateEntitiesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest;

                    /**
                     * Verifies a BatchUpdateEntitiesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchUpdateEntitiesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchUpdateEntitiesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest;

                    /**
                     * Creates a plain object from a BatchUpdateEntitiesRequest message. Also converts values to other types if specified.
                     * @param message BatchUpdateEntitiesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchUpdateEntitiesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a BatchDeleteEntitiesRequest. */
                interface IBatchDeleteEntitiesRequest {

                    /** BatchDeleteEntitiesRequest parent */
                    parent?: (string|null);

                    /** BatchDeleteEntitiesRequest entityValues */
                    entityValues?: (string[]|null);

                    /** BatchDeleteEntitiesRequest languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a BatchDeleteEntitiesRequest. */
                class BatchDeleteEntitiesRequest implements IBatchDeleteEntitiesRequest {

                    /**
                     * Constructs a new BatchDeleteEntitiesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IBatchDeleteEntitiesRequest);

                    /** BatchDeleteEntitiesRequest parent. */
                    public parent: string;

                    /** BatchDeleteEntitiesRequest entityValues. */
                    public entityValues: string[];

                    /** BatchDeleteEntitiesRequest languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new BatchDeleteEntitiesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns BatchDeleteEntitiesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IBatchDeleteEntitiesRequest): google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest;

                    /**
                     * Encodes the specified BatchDeleteEntitiesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest.verify|verify} messages.
                     * @param message BatchDeleteEntitiesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IBatchDeleteEntitiesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified BatchDeleteEntitiesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest.verify|verify} messages.
                     * @param message BatchDeleteEntitiesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IBatchDeleteEntitiesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a BatchDeleteEntitiesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns BatchDeleteEntitiesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest;

                    /**
                     * Decodes a BatchDeleteEntitiesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns BatchDeleteEntitiesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest;

                    /**
                     * Verifies a BatchDeleteEntitiesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a BatchDeleteEntitiesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns BatchDeleteEntitiesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest;

                    /**
                     * Creates a plain object from a BatchDeleteEntitiesRequest message. Also converts values to other types if specified.
                     * @param message BatchDeleteEntitiesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this BatchDeleteEntitiesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an EntityTypeBatch. */
                interface IEntityTypeBatch {

                    /** EntityTypeBatch entityTypes */
                    entityTypes?: (google.cloud.dialogflow.v2.IEntityType[]|null);
                }

                /** Represents an EntityTypeBatch. */
                class EntityTypeBatch implements IEntityTypeBatch {

                    /**
                     * Constructs a new EntityTypeBatch.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IEntityTypeBatch);

                    /** EntityTypeBatch entityTypes. */
                    public entityTypes: google.cloud.dialogflow.v2.IEntityType[];

                    /**
                     * Creates a new EntityTypeBatch instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns EntityTypeBatch instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IEntityTypeBatch): google.cloud.dialogflow.v2.EntityTypeBatch;

                    /**
                     * Encodes the specified EntityTypeBatch message. Does not implicitly {@link google.cloud.dialogflow.v2.EntityTypeBatch.verify|verify} messages.
                     * @param message EntityTypeBatch message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IEntityTypeBatch, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified EntityTypeBatch message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.EntityTypeBatch.verify|verify} messages.
                     * @param message EntityTypeBatch message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IEntityTypeBatch, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an EntityTypeBatch message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns EntityTypeBatch
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.EntityTypeBatch;

                    /**
                     * Decodes an EntityTypeBatch message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns EntityTypeBatch
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.EntityTypeBatch;

                    /**
                     * Verifies an EntityTypeBatch message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an EntityTypeBatch message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns EntityTypeBatch
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.EntityTypeBatch;

                    /**
                     * Creates a plain object from an EntityTypeBatch message. Also converts values to other types if specified.
                     * @param message EntityTypeBatch
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.EntityTypeBatch, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this EntityTypeBatch to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents a Conversations */
                class Conversations extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new Conversations service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new Conversations service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Conversations;

                    /**
                     * Calls CreateConversation.
                     * @param request CreateConversationRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Conversation
                     */
                    public createConversation(request: google.cloud.dialogflow.v2.ICreateConversationRequest, callback: google.cloud.dialogflow.v2.Conversations.CreateConversationCallback): void;

                    /**
                     * Calls CreateConversation.
                     * @param request CreateConversationRequest message or plain object
                     * @returns Promise
                     */
                    public createConversation(request: google.cloud.dialogflow.v2.ICreateConversationRequest): Promise<google.cloud.dialogflow.v2.Conversation>;

                    /**
                     * Calls ListConversations.
                     * @param request ListConversationsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListConversationsResponse
                     */
                    public listConversations(request: google.cloud.dialogflow.v2.IListConversationsRequest, callback: google.cloud.dialogflow.v2.Conversations.ListConversationsCallback): void;

                    /**
                     * Calls ListConversations.
                     * @param request ListConversationsRequest message or plain object
                     * @returns Promise
                     */
                    public listConversations(request: google.cloud.dialogflow.v2.IListConversationsRequest): Promise<google.cloud.dialogflow.v2.ListConversationsResponse>;

                    /**
                     * Calls GetConversation.
                     * @param request GetConversationRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Conversation
                     */
                    public getConversation(request: google.cloud.dialogflow.v2.IGetConversationRequest, callback: google.cloud.dialogflow.v2.Conversations.GetConversationCallback): void;

                    /**
                     * Calls GetConversation.
                     * @param request GetConversationRequest message or plain object
                     * @returns Promise
                     */
                    public getConversation(request: google.cloud.dialogflow.v2.IGetConversationRequest): Promise<google.cloud.dialogflow.v2.Conversation>;

                    /**
                     * Calls CompleteConversation.
                     * @param request CompleteConversationRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Conversation
                     */
                    public completeConversation(request: google.cloud.dialogflow.v2.ICompleteConversationRequest, callback: google.cloud.dialogflow.v2.Conversations.CompleteConversationCallback): void;

                    /**
                     * Calls CompleteConversation.
                     * @param request CompleteConversationRequest message or plain object
                     * @returns Promise
                     */
                    public completeConversation(request: google.cloud.dialogflow.v2.ICompleteConversationRequest): Promise<google.cloud.dialogflow.v2.Conversation>;

                    /**
                     * Calls ListMessages.
                     * @param request ListMessagesRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListMessagesResponse
                     */
                    public listMessages(request: google.cloud.dialogflow.v2.IListMessagesRequest, callback: google.cloud.dialogflow.v2.Conversations.ListMessagesCallback): void;

                    /**
                     * Calls ListMessages.
                     * @param request ListMessagesRequest message or plain object
                     * @returns Promise
                     */
                    public listMessages(request: google.cloud.dialogflow.v2.IListMessagesRequest): Promise<google.cloud.dialogflow.v2.ListMessagesResponse>;
                }

                namespace Conversations {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Conversations#createConversation}.
                     * @param error Error, if any
                     * @param [response] Conversation
                     */
                    type CreateConversationCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Conversation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Conversations#listConversations}.
                     * @param error Error, if any
                     * @param [response] ListConversationsResponse
                     */
                    type ListConversationsCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListConversationsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Conversations#getConversation}.
                     * @param error Error, if any
                     * @param [response] Conversation
                     */
                    type GetConversationCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Conversation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Conversations#completeConversation}.
                     * @param error Error, if any
                     * @param [response] Conversation
                     */
                    type CompleteConversationCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.Conversation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.Conversations#listMessages}.
                     * @param error Error, if any
                     * @param [response] ListMessagesResponse
                     */
                    type ListMessagesCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListMessagesResponse) => void;
                }

                /** Properties of a Conversation. */
                interface IConversation {

                    /** Conversation name */
                    name?: (string|null);

                    /** Conversation lifecycleState */
                    lifecycleState?: (google.cloud.dialogflow.v2.Conversation.LifecycleState|keyof typeof google.cloud.dialogflow.v2.Conversation.LifecycleState|null);

                    /** Conversation conversationProfile */
                    conversationProfile?: (string|null);

                    /** Conversation phoneNumber */
                    phoneNumber?: (google.cloud.dialogflow.v2.IConversationPhoneNumber|null);

                    /** Conversation startTime */
                    startTime?: (google.protobuf.ITimestamp|null);

                    /** Conversation endTime */
                    endTime?: (google.protobuf.ITimestamp|null);

                    /** Conversation conversationStage */
                    conversationStage?: (google.cloud.dialogflow.v2.Conversation.ConversationStage|keyof typeof google.cloud.dialogflow.v2.Conversation.ConversationStage|null);
                }

                /** Represents a Conversation. */
                class Conversation implements IConversation {

                    /**
                     * Constructs a new Conversation.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IConversation);

                    /** Conversation name. */
                    public name: string;

                    /** Conversation lifecycleState. */
                    public lifecycleState: (google.cloud.dialogflow.v2.Conversation.LifecycleState|keyof typeof google.cloud.dialogflow.v2.Conversation.LifecycleState);

                    /** Conversation conversationProfile. */
                    public conversationProfile: string;

                    /** Conversation phoneNumber. */
                    public phoneNumber?: (google.cloud.dialogflow.v2.IConversationPhoneNumber|null);

                    /** Conversation startTime. */
                    public startTime?: (google.protobuf.ITimestamp|null);

                    /** Conversation endTime. */
                    public endTime?: (google.protobuf.ITimestamp|null);

                    /** Conversation conversationStage. */
                    public conversationStage: (google.cloud.dialogflow.v2.Conversation.ConversationStage|keyof typeof google.cloud.dialogflow.v2.Conversation.ConversationStage);

                    /**
                     * Creates a new Conversation instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns Conversation instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IConversation): google.cloud.dialogflow.v2.Conversation;

                    /**
                     * Encodes the specified Conversation message. Does not implicitly {@link google.cloud.dialogflow.v2.Conversation.verify|verify} messages.
                     * @param message Conversation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IConversation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified Conversation message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Conversation.verify|verify} messages.
                     * @param message Conversation message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IConversation, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a Conversation message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns Conversation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.Conversation;

                    /**
                     * Decodes a Conversation message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns Conversation
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.Conversation;

                    /**
                     * Verifies a Conversation message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a Conversation message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns Conversation
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.Conversation;

                    /**
                     * Creates a plain object from a Conversation message. Also converts values to other types if specified.
                     * @param message Conversation
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.Conversation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this Conversation to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                namespace Conversation {

                    /** LifecycleState enum. */
                    enum LifecycleState {
                        LIFECYCLE_STATE_UNSPECIFIED = 0,
                        IN_PROGRESS = 1,
                        COMPLETED = 2
                    }

                    /** ConversationStage enum. */
                    enum ConversationStage {
                        CONVERSATION_STAGE_UNSPECIFIED = 0,
                        VIRTUAL_AGENT_STAGE = 1,
                        HUMAN_ASSIST_STAGE = 2
                    }
                }

                /** Properties of a CreateConversationRequest. */
                interface ICreateConversationRequest {

                    /** CreateConversationRequest parent */
                    parent?: (string|null);

                    /** CreateConversationRequest conversation */
                    conversation?: (google.cloud.dialogflow.v2.IConversation|null);

                    /** CreateConversationRequest conversationId */
                    conversationId?: (string|null);
                }

                /** Represents a CreateConversationRequest. */
                class CreateConversationRequest implements ICreateConversationRequest {

                    /**
                     * Constructs a new CreateConversationRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICreateConversationRequest);

                    /** CreateConversationRequest parent. */
                    public parent: string;

                    /** CreateConversationRequest conversation. */
                    public conversation?: (google.cloud.dialogflow.v2.IConversation|null);

                    /** CreateConversationRequest conversationId. */
                    public conversationId: string;

                    /**
                     * Creates a new CreateConversationRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateConversationRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICreateConversationRequest): google.cloud.dialogflow.v2.CreateConversationRequest;

                    /**
                     * Encodes the specified CreateConversationRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateConversationRequest.verify|verify} messages.
                     * @param message CreateConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICreateConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateConversationRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateConversationRequest.verify|verify} messages.
                     * @param message CreateConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICreateConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateConversationRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CreateConversationRequest;

                    /**
                     * Decodes a CreateConversationRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CreateConversationRequest;

                    /**
                     * Verifies a CreateConversationRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateConversationRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateConversationRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CreateConversationRequest;

                    /**
                     * Creates a plain object from a CreateConversationRequest message. Also converts values to other types if specified.
                     * @param message CreateConversationRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CreateConversationRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateConversationRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListConversationsRequest. */
                interface IListConversationsRequest {

                    /** ListConversationsRequest parent */
                    parent?: (string|null);

                    /** ListConversationsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListConversationsRequest pageToken */
                    pageToken?: (string|null);

                    /** ListConversationsRequest filter */
                    filter?: (string|null);
                }

                /** Represents a ListConversationsRequest. */
                class ListConversationsRequest implements IListConversationsRequest {

                    /**
                     * Constructs a new ListConversationsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListConversationsRequest);

                    /** ListConversationsRequest parent. */
                    public parent: string;

                    /** ListConversationsRequest pageSize. */
                    public pageSize: number;

                    /** ListConversationsRequest pageToken. */
                    public pageToken: string;

                    /** ListConversationsRequest filter. */
                    public filter: string;

                    /**
                     * Creates a new ListConversationsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListConversationsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListConversationsRequest): google.cloud.dialogflow.v2.ListConversationsRequest;

                    /**
                     * Encodes the specified ListConversationsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListConversationsRequest.verify|verify} messages.
                     * @param message ListConversationsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListConversationsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListConversationsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListConversationsRequest.verify|verify} messages.
                     * @param message ListConversationsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListConversationsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListConversationsRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListConversationsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListConversationsRequest;

                    /**
                     * Decodes a ListConversationsRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListConversationsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListConversationsRequest;

                    /**
                     * Verifies a ListConversationsRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListConversationsRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListConversationsRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListConversationsRequest;

                    /**
                     * Creates a plain object from a ListConversationsRequest message. Also converts values to other types if specified.
                     * @param message ListConversationsRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListConversationsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListConversationsRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListConversationsResponse. */
                interface IListConversationsResponse {

                    /** ListConversationsResponse conversations */
                    conversations?: (google.cloud.dialogflow.v2.IConversation[]|null);

                    /** ListConversationsResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListConversationsResponse. */
                class ListConversationsResponse implements IListConversationsResponse {

                    /**
                     * Constructs a new ListConversationsResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListConversationsResponse);

                    /** ListConversationsResponse conversations. */
                    public conversations: google.cloud.dialogflow.v2.IConversation[];

                    /** ListConversationsResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListConversationsResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListConversationsResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListConversationsResponse): google.cloud.dialogflow.v2.ListConversationsResponse;

                    /**
                     * Encodes the specified ListConversationsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListConversationsResponse.verify|verify} messages.
                     * @param message ListConversationsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListConversationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListConversationsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListConversationsResponse.verify|verify} messages.
                     * @param message ListConversationsResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListConversationsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListConversationsResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListConversationsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListConversationsResponse;

                    /**
                     * Decodes a ListConversationsResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListConversationsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListConversationsResponse;

                    /**
                     * Verifies a ListConversationsResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListConversationsResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListConversationsResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListConversationsResponse;

                    /**
                     * Creates a plain object from a ListConversationsResponse message. Also converts values to other types if specified.
                     * @param message ListConversationsResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListConversationsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListConversationsResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetConversationRequest. */
                interface IGetConversationRequest {

                    /** GetConversationRequest name */
                    name?: (string|null);
                }

                /** Represents a GetConversationRequest. */
                class GetConversationRequest implements IGetConversationRequest {

                    /**
                     * Constructs a new GetConversationRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetConversationRequest);

                    /** GetConversationRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetConversationRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetConversationRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetConversationRequest): google.cloud.dialogflow.v2.GetConversationRequest;

                    /**
                     * Encodes the specified GetConversationRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetConversationRequest.verify|verify} messages.
                     * @param message GetConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetConversationRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetConversationRequest.verify|verify} messages.
                     * @param message GetConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetConversationRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetConversationRequest;

                    /**
                     * Decodes a GetConversationRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetConversationRequest;

                    /**
                     * Verifies a GetConversationRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetConversationRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetConversationRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetConversationRequest;

                    /**
                     * Creates a plain object from a GetConversationRequest message. Also converts values to other types if specified.
                     * @param message GetConversationRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetConversationRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetConversationRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a CompleteConversationRequest. */
                interface ICompleteConversationRequest {

                    /** CompleteConversationRequest name */
                    name?: (string|null);
                }

                /** Represents a CompleteConversationRequest. */
                class CompleteConversationRequest implements ICompleteConversationRequest {

                    /**
                     * Constructs a new CompleteConversationRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICompleteConversationRequest);

                    /** CompleteConversationRequest name. */
                    public name: string;

                    /**
                     * Creates a new CompleteConversationRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CompleteConversationRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICompleteConversationRequest): google.cloud.dialogflow.v2.CompleteConversationRequest;

                    /**
                     * Encodes the specified CompleteConversationRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CompleteConversationRequest.verify|verify} messages.
                     * @param message CompleteConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICompleteConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CompleteConversationRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CompleteConversationRequest.verify|verify} messages.
                     * @param message CompleteConversationRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICompleteConversationRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CompleteConversationRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CompleteConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CompleteConversationRequest;

                    /**
                     * Decodes a CompleteConversationRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CompleteConversationRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CompleteConversationRequest;

                    /**
                     * Verifies a CompleteConversationRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CompleteConversationRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CompleteConversationRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CompleteConversationRequest;

                    /**
                     * Creates a plain object from a CompleteConversationRequest message. Also converts values to other types if specified.
                     * @param message CompleteConversationRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CompleteConversationRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CompleteConversationRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListMessagesRequest. */
                interface IListMessagesRequest {

                    /** ListMessagesRequest parent */
                    parent?: (string|null);

                    /** ListMessagesRequest filter */
                    filter?: (string|null);

                    /** ListMessagesRequest pageSize */
                    pageSize?: (number|null);

                    /** ListMessagesRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListMessagesRequest. */
                class ListMessagesRequest implements IListMessagesRequest {

                    /**
                     * Constructs a new ListMessagesRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListMessagesRequest);

                    /** ListMessagesRequest parent. */
                    public parent: string;

                    /** ListMessagesRequest filter. */
                    public filter: string;

                    /** ListMessagesRequest pageSize. */
                    public pageSize: number;

                    /** ListMessagesRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListMessagesRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListMessagesRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListMessagesRequest): google.cloud.dialogflow.v2.ListMessagesRequest;

                    /**
                     * Encodes the specified ListMessagesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListMessagesRequest.verify|verify} messages.
                     * @param message ListMessagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListMessagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListMessagesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListMessagesRequest.verify|verify} messages.
                     * @param message ListMessagesRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListMessagesRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListMessagesRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListMessagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListMessagesRequest;

                    /**
                     * Decodes a ListMessagesRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListMessagesRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListMessagesRequest;

                    /**
                     * Verifies a ListMessagesRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListMessagesRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListMessagesRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListMessagesRequest;

                    /**
                     * Creates a plain object from a ListMessagesRequest message. Also converts values to other types if specified.
                     * @param message ListMessagesRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListMessagesRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListMessagesRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListMessagesResponse. */
                interface IListMessagesResponse {

                    /** ListMessagesResponse messages */
                    messages?: (google.cloud.dialogflow.v2.IMessage[]|null);

                    /** ListMessagesResponse nextPageToken */
                    nextPageToken?: (string|null);
                }

                /** Represents a ListMessagesResponse. */
                class ListMessagesResponse implements IListMessagesResponse {

                    /**
                     * Constructs a new ListMessagesResponse.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListMessagesResponse);

                    /** ListMessagesResponse messages. */
                    public messages: google.cloud.dialogflow.v2.IMessage[];

                    /** ListMessagesResponse nextPageToken. */
                    public nextPageToken: string;

                    /**
                     * Creates a new ListMessagesResponse instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListMessagesResponse instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListMessagesResponse): google.cloud.dialogflow.v2.ListMessagesResponse;

                    /**
                     * Encodes the specified ListMessagesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListMessagesResponse.verify|verify} messages.
                     * @param message ListMessagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListMessagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListMessagesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListMessagesResponse.verify|verify} messages.
                     * @param message ListMessagesResponse message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IListMessagesResponse, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ListMessagesResponse message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ListMessagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ListMessagesResponse;

                    /**
                     * Decodes a ListMessagesResponse message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ListMessagesResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ListMessagesResponse;

                    /**
                     * Verifies a ListMessagesResponse message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ListMessagesResponse message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ListMessagesResponse
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ListMessagesResponse;

                    /**
                     * Creates a plain object from a ListMessagesResponse message. Also converts values to other types if specified.
                     * @param message ListMessagesResponse
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ListMessagesResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ListMessagesResponse to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ConversationPhoneNumber. */
                interface IConversationPhoneNumber {

                    /** ConversationPhoneNumber phoneNumber */
                    phoneNumber?: (string|null);
                }

                /** Represents a ConversationPhoneNumber. */
                class ConversationPhoneNumber implements IConversationPhoneNumber {

                    /**
                     * Constructs a new ConversationPhoneNumber.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IConversationPhoneNumber);

                    /** ConversationPhoneNumber phoneNumber. */
                    public phoneNumber: string;

                    /**
                     * Creates a new ConversationPhoneNumber instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ConversationPhoneNumber instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IConversationPhoneNumber): google.cloud.dialogflow.v2.ConversationPhoneNumber;

                    /**
                     * Encodes the specified ConversationPhoneNumber message. Does not implicitly {@link google.cloud.dialogflow.v2.ConversationPhoneNumber.verify|verify} messages.
                     * @param message ConversationPhoneNumber message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IConversationPhoneNumber, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ConversationPhoneNumber message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ConversationPhoneNumber.verify|verify} messages.
                     * @param message ConversationPhoneNumber message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IConversationPhoneNumber, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ConversationPhoneNumber message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ConversationPhoneNumber
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ConversationPhoneNumber;

                    /**
                     * Decodes a ConversationPhoneNumber message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ConversationPhoneNumber
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ConversationPhoneNumber;

                    /**
                     * Verifies a ConversationPhoneNumber message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ConversationPhoneNumber message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ConversationPhoneNumber
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ConversationPhoneNumber;

                    /**
                     * Creates a plain object from a ConversationPhoneNumber message. Also converts values to other types if specified.
                     * @param message ConversationPhoneNumber
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ConversationPhoneNumber, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ConversationPhoneNumber to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Represents a ConversationDatasets */
                class ConversationDatasets extends $protobuf.rpc.Service {

                    /**
                     * Constructs a new ConversationDatasets service.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     */
                    constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                    /**
                     * Creates new ConversationDatasets service using the specified rpc implementation.
                     * @param rpcImpl RPC implementation
                     * @param [requestDelimited=false] Whether requests are length-delimited
                     * @param [responseDelimited=false] Whether responses are length-delimited
                     * @returns RPC service. Useful where requests and/or responses are streamed.
                     */
                    public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): ConversationDatasets;

                    /**
                     * Calls CreateConversationDataset.
                     * @param request CreateConversationDatasetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public createConversationDataset(request: google.cloud.dialogflow.v2.ICreateConversationDatasetRequest, callback: google.cloud.dialogflow.v2.ConversationDatasets.CreateConversationDatasetCallback): void;

                    /**
                     * Calls CreateConversationDataset.
                     * @param request CreateConversationDatasetRequest message or plain object
                     * @returns Promise
                     */
                    public createConversationDataset(request: google.cloud.dialogflow.v2.ICreateConversationDatasetRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls GetConversationDataset.
                     * @param request GetConversationDatasetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ConversationDataset
                     */
                    public getConversationDataset(request: google.cloud.dialogflow.v2.IGetConversationDatasetRequest, callback: google.cloud.dialogflow.v2.ConversationDatasets.GetConversationDatasetCallback): void;

                    /**
                     * Calls GetConversationDataset.
                     * @param request GetConversationDatasetRequest message or plain object
                     * @returns Promise
                     */
                    public getConversationDataset(request: google.cloud.dialogflow.v2.IGetConversationDatasetRequest): Promise<google.cloud.dialogflow.v2.ConversationDataset>;

                    /**
                     * Calls ListConversationDatasets.
                     * @param request ListConversationDatasetsRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and ListConversationDatasetsResponse
                     */
                    public listConversationDatasets(request: google.cloud.dialogflow.v2.IListConversationDatasetsRequest, callback: google.cloud.dialogflow.v2.ConversationDatasets.ListConversationDatasetsCallback): void;

                    /**
                     * Calls ListConversationDatasets.
                     * @param request ListConversationDatasetsRequest message or plain object
                     * @returns Promise
                     */
                    public listConversationDatasets(request: google.cloud.dialogflow.v2.IListConversationDatasetsRequest): Promise<google.cloud.dialogflow.v2.ListConversationDatasetsResponse>;

                    /**
                     * Calls DeleteConversationDataset.
                     * @param request DeleteConversationDatasetRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public deleteConversationDataset(request: google.cloud.dialogflow.v2.IDeleteConversationDatasetRequest, callback: google.cloud.dialogflow.v2.ConversationDatasets.DeleteConversationDatasetCallback): void;

                    /**
                     * Calls DeleteConversationDataset.
                     * @param request DeleteConversationDatasetRequest message or plain object
                     * @returns Promise
                     */
                    public deleteConversationDataset(request: google.cloud.dialogflow.v2.IDeleteConversationDatasetRequest): Promise<google.longrunning.Operation>;

                    /**
                     * Calls ImportConversationData.
                     * @param request ImportConversationDataRequest message or plain object
                     * @param callback Node-style callback called with the error, if any, and Operation
                     */
                    public importConversationData(request: google.cloud.dialogflow.v2.IImportConversationDataRequest, callback: google.cloud.dialogflow.v2.ConversationDatasets.ImportConversationDataCallback): void;

                    /**
                     * Calls ImportConversationData.
                     * @param request ImportConversationDataRequest message or plain object
                     * @returns Promise
                     */
                    public importConversationData(request: google.cloud.dialogflow.v2.IImportConversationDataRequest): Promise<google.longrunning.Operation>;
                }

                namespace ConversationDatasets {

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.ConversationDatasets#createConversationDataset}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type CreateConversationDatasetCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.ConversationDatasets#getConversationDataset}.
                     * @param error Error, if any
                     * @param [response] ConversationDataset
                     */
                    type GetConversationDatasetCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ConversationDataset) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.ConversationDatasets#listConversationDatasets}.
                     * @param error Error, if any
                     * @param [response] ListConversationDatasetsResponse
                     */
                    type ListConversationDatasetsCallback = (error: (Error|null), response?: google.cloud.dialogflow.v2.ListConversationDatasetsResponse) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.ConversationDatasets#deleteConversationDataset}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type DeleteConversationDatasetCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;

                    /**
                     * Callback as used by {@link google.cloud.dialogflow.v2.ConversationDatasets#importConversationData}.
                     * @param error Error, if any
                     * @param [response] Operation
                     */
                    type ImportConversationDataCallback = (error: (Error|null), response?: google.longrunning.Operation) => void;
                }

                /** Properties of a ConversationInfo. */
                interface IConversationInfo {

                    /** ConversationInfo languageCode */
                    languageCode?: (string|null);
                }

                /** Represents a ConversationInfo. */
                class ConversationInfo implements IConversationInfo {

                    /**
                     * Constructs a new ConversationInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IConversationInfo);

                    /** ConversationInfo languageCode. */
                    public languageCode: string;

                    /**
                     * Creates a new ConversationInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ConversationInfo instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IConversationInfo): google.cloud.dialogflow.v2.ConversationInfo;

                    /**
                     * Encodes the specified ConversationInfo message. Does not implicitly {@link google.cloud.dialogflow.v2.ConversationInfo.verify|verify} messages.
                     * @param message ConversationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IConversationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ConversationInfo message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ConversationInfo.verify|verify} messages.
                     * @param message ConversationInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IConversationInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ConversationInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ConversationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ConversationInfo;

                    /**
                     * Decodes a ConversationInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ConversationInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ConversationInfo;

                    /**
                     * Verifies a ConversationInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ConversationInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ConversationInfo
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ConversationInfo;

                    /**
                     * Creates a plain object from a ConversationInfo message. Also converts values to other types if specified.
                     * @param message ConversationInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ConversationInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ConversationInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of an InputConfig. */
                interface IInputConfig {

                    /** InputConfig gcsSource */
                    gcsSource?: (google.cloud.dialogflow.v2.IGcsSources|null);
                }

                /** Represents an InputConfig. */
                class InputConfig implements IInputConfig {

                    /**
                     * Constructs a new InputConfig.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IInputConfig);

                    /** InputConfig gcsSource. */
                    public gcsSource?: (google.cloud.dialogflow.v2.IGcsSources|null);

                    /** InputConfig source. */
                    public source?: "gcsSource";

                    /**
                     * Creates a new InputConfig instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns InputConfig instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IInputConfig): google.cloud.dialogflow.v2.InputConfig;

                    /**
                     * Encodes the specified InputConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.InputConfig.verify|verify} messages.
                     * @param message InputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IInputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified InputConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.InputConfig.verify|verify} messages.
                     * @param message InputConfig message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IInputConfig, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes an InputConfig message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns InputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.InputConfig;

                    /**
                     * Decodes an InputConfig message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns InputConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.InputConfig;

                    /**
                     * Verifies an InputConfig message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates an InputConfig message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns InputConfig
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.InputConfig;

                    /**
                     * Creates a plain object from an InputConfig message. Also converts values to other types if specified.
                     * @param message InputConfig
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.InputConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this InputConfig to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ConversationDataset. */
                interface IConversationDataset {

                    /** ConversationDataset name */
                    name?: (string|null);

                    /** ConversationDataset displayName */
                    displayName?: (string|null);

                    /** ConversationDataset description */
                    description?: (string|null);

                    /** ConversationDataset createTime */
                    createTime?: (google.protobuf.ITimestamp|null);

                    /** ConversationDataset inputConfig */
                    inputConfig?: (google.cloud.dialogflow.v2.IInputConfig|null);

                    /** ConversationDataset conversationInfo */
                    conversationInfo?: (google.cloud.dialogflow.v2.IConversationInfo|null);

                    /** ConversationDataset conversationCount */
                    conversationCount?: (number|Long|string|null);
                }

                /** Represents a ConversationDataset. */
                class ConversationDataset implements IConversationDataset {

                    /**
                     * Constructs a new ConversationDataset.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IConversationDataset);

                    /** ConversationDataset name. */
                    public name: string;

                    /** ConversationDataset displayName. */
                    public displayName: string;

                    /** ConversationDataset description. */
                    public description: string;

                    /** ConversationDataset createTime. */
                    public createTime?: (google.protobuf.ITimestamp|null);

                    /** ConversationDataset inputConfig. */
                    public inputConfig?: (google.cloud.dialogflow.v2.IInputConfig|null);

                    /** ConversationDataset conversationInfo. */
                    public conversationInfo?: (google.cloud.dialogflow.v2.IConversationInfo|null);

                    /** ConversationDataset conversationCount. */
                    public conversationCount: (number|Long|string);

                    /**
                     * Creates a new ConversationDataset instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ConversationDataset instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IConversationDataset): google.cloud.dialogflow.v2.ConversationDataset;

                    /**
                     * Encodes the specified ConversationDataset message. Does not implicitly {@link google.cloud.dialogflow.v2.ConversationDataset.verify|verify} messages.
                     * @param message ConversationDataset message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IConversationDataset, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ConversationDataset message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ConversationDataset.verify|verify} messages.
                     * @param message ConversationDataset message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IConversationDataset, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ConversationDataset message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ConversationDataset
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.ConversationDataset;

                    /**
                     * Decodes a ConversationDataset message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ConversationDataset
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.ConversationDataset;

                    /**
                     * Verifies a ConversationDataset message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ConversationDataset message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ConversationDataset
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.ConversationDataset;

                    /**
                     * Creates a plain object from a ConversationDataset message. Also converts values to other types if specified.
                     * @param message ConversationDataset
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.ConversationDataset, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ConversationDataset to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a CreateConversationDatasetRequest. */
                interface ICreateConversationDatasetRequest {

                    /** CreateConversationDatasetRequest parent */
                    parent?: (string|null);

                    /** CreateConversationDatasetRequest conversationDataset */
                    conversationDataset?: (google.cloud.dialogflow.v2.IConversationDataset|null);
                }

                /** Represents a CreateConversationDatasetRequest. */
                class CreateConversationDatasetRequest implements ICreateConversationDatasetRequest {

                    /**
                     * Constructs a new CreateConversationDatasetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.ICreateConversationDatasetRequest);

                    /** CreateConversationDatasetRequest parent. */
                    public parent: string;

                    /** CreateConversationDatasetRequest conversationDataset. */
                    public conversationDataset?: (google.cloud.dialogflow.v2.IConversationDataset|null);

                    /**
                     * Creates a new CreateConversationDatasetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns CreateConversationDatasetRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.ICreateConversationDatasetRequest): google.cloud.dialogflow.v2.CreateConversationDatasetRequest;

                    /**
                     * Encodes the specified CreateConversationDatasetRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateConversationDatasetRequest.verify|verify} messages.
                     * @param message CreateConversationDatasetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.ICreateConversationDatasetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified CreateConversationDatasetRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateConversationDatasetRequest.verify|verify} messages.
                     * @param message CreateConversationDatasetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.ICreateConversationDatasetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a CreateConversationDatasetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns CreateConversationDatasetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.CreateConversationDatasetRequest;

                    /**
                     * Decodes a CreateConversationDatasetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns CreateConversationDatasetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.CreateConversationDatasetRequest;

                    /**
                     * Verifies a CreateConversationDatasetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a CreateConversationDatasetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns CreateConversationDatasetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.CreateConversationDatasetRequest;

                    /**
                     * Creates a plain object from a CreateConversationDatasetRequest message. Also converts values to other types if specified.
                     * @param message CreateConversationDatasetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.CreateConversationDatasetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this CreateConversationDatasetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a GetConversationDatasetRequest. */
                interface IGetConversationDatasetRequest {

                    /** GetConversationDatasetRequest name */
                    name?: (string|null);
                }

                /** Represents a GetConversationDatasetRequest. */
                class GetConversationDatasetRequest implements IGetConversationDatasetRequest {

                    /**
                     * Constructs a new GetConversationDatasetRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IGetConversationDatasetRequest);

                    /** GetConversationDatasetRequest name. */
                    public name: string;

                    /**
                     * Creates a new GetConversationDatasetRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns GetConversationDatasetRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IGetConversationDatasetRequest): google.cloud.dialogflow.v2.GetConversationDatasetRequest;

                    /**
                     * Encodes the specified GetConversationDatasetRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetConversationDatasetRequest.verify|verify} messages.
                     * @param message GetConversationDatasetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IGetConversationDatasetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified GetConversationDatasetRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetConversationDatasetRequest.verify|verify} messages.
                     * @param message GetConversationDatasetRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: google.cloud.dialogflow.v2.IGetConversationDatasetRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a GetConversationDatasetRequest message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns GetConversationDatasetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.cloud.dialogflow.v2.GetConversationDatasetRequest;

                    /**
                     * Decodes a GetConversationDatasetRequest message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns GetConversationDatasetRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.cloud.dialogflow.v2.GetConversationDatasetRequest;

                    /**
                     * Verifies a GetConversationDatasetRequest message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a GetConversationDatasetRequest message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns GetConversationDatasetRequest
                     */
                    public static fromObject(object: { [k: string]: any }): google.cloud.dialogflow.v2.GetConversationDatasetRequest;

                    /**
                     * Creates a plain object from a GetConversationDatasetRequest message. Also converts values to other types if specified.
                     * @param message GetConversationDatasetRequest
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: google.cloud.dialogflow.v2.GetConversationDatasetRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this GetConversationDatasetRequest to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };
                }

                /** Properties of a ListConversationDatasetsRequest. */
                interface IListConversationDatasetsRequest {

                    /** ListConversationDatasetsRequest parent */
                    parent?: (string|null);

                    /** ListConversationDatasetsRequest pageSize */
                    pageSize?: (number|null);

                    /** ListConversationDatasetsRequest pageToken */
                    pageToken?: (string|null);
                }

                /** Represents a ListConversationDatasetsRequest. */
                class ListConversationDatasetsRequest implements IListConversationDatasetsRequest {

                    /**
                     * Constructs a new ListConversationDatasetsRequest.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: google.cloud.dialogflow.v2.IListConversationDatasetsRequest);

                    /** ListConversationDatasetsRequest parent. */
                    public parent: string;

                    /** ListConversationDatasetsRequest pageSize. */
                    public pageSize: number;

                    /** ListConversationDatasetsRequest pageToken. */
                    public pageToken: string;

                    /**
                     * Creates a new ListConversationDatasetsRequest instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ListConversationDatasetsRequest instance
                     */
                    public static create(properties?: google.cloud.dialogflow.v2.IListConversationDatasetsRequest): google.cloud.dialogflow.v2.ListConversationDatasetsRequest;

                    /**
                     * Encodes the specified ListConversationDatasetsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListConversationDatasetsRequest.verify|verify} messages.
                     * @param message ListConversationDatasetsRequest message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: google.cloud.dialogflow.v2.IListConversationDatasetsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ListConversationDatasetsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListConversationDatasetsRequest.verify|verify} messages.
                     * @param message ListConversationDatasetsReque