// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_dialogflow_protos || ($protobuf.roots._google_cloud_dialogflow_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.cloud = (function() {
    
            /**
             * Namespace cloud.
             * @memberof google
             * @namespace
             */
            var cloud = {};
    
            cloud.dialogflow = (function() {
    
                /**
                 * Namespace dialogflow.
                 * @memberof google.cloud
                 * @namespace
                 */
                var dialogflow = {};
    
                dialogflow.v2 = (function() {
    
                    /**
                     * Namespace v2.
                     * @memberof google.cloud.dialogflow
                     * @namespace
                     */
                    var v2 = {};
    
                    v2.Agents = (function() {
    
                        /**
                         * Constructs a new Agents service.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an Agents
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Agents(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (Agents.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Agents;
    
                        /**
                         * Creates new Agents service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Agents} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Agents.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#getAgent}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef GetAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.Agent} [response] Agent
                         */
    
                        /**
                         * Calls GetAgent.
                         * @function getAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IGetAgentRequest} request GetAgentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.GetAgentCallback} callback Node-style callback called with the error, if any, and Agent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.getAgent = function getAgent(request, callback) {
                            return this.rpcCall(getAgent, $root.google.cloud.dialogflow.v2.GetAgentRequest, $root.google.cloud.dialogflow.v2.Agent, request, callback);
                        }, "name", { value: "GetAgent" });
    
                        /**
                         * Calls GetAgent.
                         * @function getAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IGetAgentRequest} request GetAgentRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.Agent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#setAgent}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef SetAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.Agent} [response] Agent
                         */
    
                        /**
                         * Calls SetAgent.
                         * @function setAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISetAgentRequest} request SetAgentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.SetAgentCallback} callback Node-style callback called with the error, if any, and Agent
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.setAgent = function setAgent(request, callback) {
                            return this.rpcCall(setAgent, $root.google.cloud.dialogflow.v2.SetAgentRequest, $root.google.cloud.dialogflow.v2.Agent, request, callback);
                        }, "name", { value: "SetAgent" });
    
                        /**
                         * Calls SetAgent.
                         * @function setAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISetAgentRequest} request SetAgentRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.Agent>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#deleteAgent}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef DeleteAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.protobuf.Empty} [response] Empty
                         */
    
                        /**
                         * Calls DeleteAgent.
                         * @function deleteAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IDeleteAgentRequest} request DeleteAgentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.DeleteAgentCallback} callback Node-style callback called with the error, if any, and Empty
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.deleteAgent = function deleteAgent(request, callback) {
                            return this.rpcCall(deleteAgent, $root.google.cloud.dialogflow.v2.DeleteAgentRequest, $root.google.protobuf.Empty, request, callback);
                        }, "name", { value: "DeleteAgent" });
    
                        /**
                         * Calls DeleteAgent.
                         * @function deleteAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IDeleteAgentRequest} request DeleteAgentRequest message or plain object
                         * @returns {Promise<google.protobuf.Empty>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#searchAgents}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef SearchAgentsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.SearchAgentsResponse} [response] SearchAgentsResponse
                         */
    
                        /**
                         * Calls SearchAgents.
                         * @function searchAgents
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsRequest} request SearchAgentsRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.SearchAgentsCallback} callback Node-style callback called with the error, if any, and SearchAgentsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.searchAgents = function searchAgents(request, callback) {
                            return this.rpcCall(searchAgents, $root.google.cloud.dialogflow.v2.SearchAgentsRequest, $root.google.cloud.dialogflow.v2.SearchAgentsResponse, request, callback);
                        }, "name", { value: "SearchAgents" });
    
                        /**
                         * Calls SearchAgents.
                         * @function searchAgents
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsRequest} request SearchAgentsRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.SearchAgentsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#trainAgent}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef TrainAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls TrainAgent.
                         * @function trainAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ITrainAgentRequest} request TrainAgentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.TrainAgentCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.trainAgent = function trainAgent(request, callback) {
                            return this.rpcCall(trainAgent, $root.google.cloud.dialogflow.v2.TrainAgentRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "TrainAgent" });
    
                        /**
                         * Calls TrainAgent.
                         * @function trainAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ITrainAgentRequest} request TrainAgentRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#exportAgent}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef ExportAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ExportAgent.
                         * @function exportAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IExportAgentRequest} request ExportAgentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.ExportAgentCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.exportAgent = function exportAgent(request, callback) {
                            return this.rpcCall(exportAgent, $root.google.cloud.dialogflow.v2.ExportAgentRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ExportAgent" });
    
                        /**
                         * Calls ExportAgent.
                         * @function exportAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IExportAgentRequest} request ExportAgentRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#importAgent}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef ImportAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls ImportAgent.
                         * @function importAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IImportAgentRequest} request ImportAgentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.ImportAgentCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.importAgent = function importAgent(request, callback) {
                            return this.rpcCall(importAgent, $root.google.cloud.dialogflow.v2.ImportAgentRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "ImportAgent" });
    
                        /**
                         * Calls ImportAgent.
                         * @function importAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IImportAgentRequest} request ImportAgentRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#restoreAgent}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef RestoreAgentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.longrunning.Operation} [response] Operation
                         */
    
                        /**
                         * Calls RestoreAgent.
                         * @function restoreAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IRestoreAgentRequest} request RestoreAgentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.RestoreAgentCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.restoreAgent = function restoreAgent(request, callback) {
                            return this.rpcCall(restoreAgent, $root.google.cloud.dialogflow.v2.RestoreAgentRequest, $root.google.longrunning.Operation, request, callback);
                        }, "name", { value: "RestoreAgent" });
    
                        /**
                         * Calls RestoreAgent.
                         * @function restoreAgent
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IRestoreAgentRequest} request RestoreAgentRequest message or plain object
                         * @returns {Promise<google.longrunning.Operation>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Agents#getValidationResult}.
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @typedef GetValidationResultCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.ValidationResult} [response] ValidationResult
                         */
    
                        /**
                         * Calls GetValidationResult.
                         * @function getValidationResult
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IGetValidationResultRequest} request GetValidationResultRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Agents.GetValidationResultCallback} callback Node-style callback called with the error, if any, and ValidationResult
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Agents.prototype.getValidationResult = function getValidationResult(request, callback) {
                            return this.rpcCall(getValidationResult, $root.google.cloud.dialogflow.v2.GetValidationResultRequest, $root.google.cloud.dialogflow.v2.ValidationResult, request, callback);
                        }, "name", { value: "GetValidationResult" });
    
                        /**
                         * Calls GetValidationResult.
                         * @function getValidationResult
                         * @memberof google.cloud.dialogflow.v2.Agents
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IGetValidationResultRequest} request GetValidationResultRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.ValidationResult>} Promise
                         * @variation 2
                         */
    
                        return Agents;
                    })();
    
                    v2.Agent = (function() {
    
                        /**
                         * Properties of an Agent.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAgent
                         * @property {string|null} [parent] Agent parent
                         * @property {string|null} [displayName] Agent displayName
                         * @property {string|null} [defaultLanguageCode] Agent defaultLanguageCode
                         * @property {Array.<string>|null} [supportedLanguageCodes] Agent supportedLanguageCodes
                         * @property {string|null} [timeZone] Agent timeZone
                         * @property {string|null} [description] Agent description
                         * @property {string|null} [avatarUri] Agent avatarUri
                         * @property {boolean|null} [enableLogging] Agent enableLogging
                         * @property {google.cloud.dialogflow.v2.Agent.MatchMode|null} [matchMode] Agent matchMode
                         * @property {number|null} [classificationThreshold] Agent classificationThreshold
                         * @property {google.cloud.dialogflow.v2.Agent.ApiVersion|null} [apiVersion] Agent apiVersion
                         * @property {google.cloud.dialogflow.v2.Agent.Tier|null} [tier] Agent tier
                         */
    
                        /**
                         * Constructs a new Agent.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an Agent.
                         * @implements IAgent
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAgent=} [properties] Properties to set
                         */
                        function Agent(properties) {
                            this.supportedLanguageCodes = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Agent parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.parent = "";
    
                        /**
                         * Agent displayName.
                         * @member {string} displayName
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.displayName = "";
    
                        /**
                         * Agent defaultLanguageCode.
                         * @member {string} defaultLanguageCode
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.defaultLanguageCode = "";
    
                        /**
                         * Agent supportedLanguageCodes.
                         * @member {Array.<string>} supportedLanguageCodes
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.supportedLanguageCodes = $util.emptyArray;
    
                        /**
                         * Agent timeZone.
                         * @member {string} timeZone
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.timeZone = "";
    
                        /**
                         * Agent description.
                         * @member {string} description
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.description = "";
    
                        /**
                         * Agent avatarUri.
                         * @member {string} avatarUri
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.avatarUri = "";
    
                        /**
                         * Agent enableLogging.
                         * @member {boolean} enableLogging
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.enableLogging = false;
    
                        /**
                         * Agent matchMode.
                         * @member {google.cloud.dialogflow.v2.Agent.MatchMode} matchMode
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.matchMode = 0;
    
                        /**
                         * Agent classificationThreshold.
                         * @member {number} classificationThreshold
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.classificationThreshold = 0;
    
                        /**
                         * Agent apiVersion.
                         * @member {google.cloud.dialogflow.v2.Agent.ApiVersion} apiVersion
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.apiVersion = 0;
    
                        /**
                         * Agent tier.
                         * @member {google.cloud.dialogflow.v2.Agent.Tier} tier
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         */
                        Agent.prototype.tier = 0;
    
                        /**
                         * Creates a new Agent instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgent=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.Agent} Agent instance
                         */
                        Agent.create = function create(properties) {
                            return new Agent(properties);
                        };
    
                        /**
                         * Encodes the specified Agent message. Does not implicitly {@link google.cloud.dialogflow.v2.Agent.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgent} message Agent message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Agent.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.displayName);
                            if (message.defaultLanguageCode != null && Object.hasOwnProperty.call(message, "defaultLanguageCode"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.defaultLanguageCode);
                            if (message.supportedLanguageCodes != null && message.supportedLanguageCodes.length)
                                for (var i = 0; i < message.supportedLanguageCodes.length; ++i)
                                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.supportedLanguageCodes[i]);
                            if (message.timeZone != null && Object.hasOwnProperty.call(message, "timeZone"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.timeZone);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.description);
                            if (message.avatarUri != null && Object.hasOwnProperty.call(message, "avatarUri"))
                                writer.uint32(/* id 7, wireType 2 =*/58).string(message.avatarUri);
                            if (message.enableLogging != null && Object.hasOwnProperty.call(message, "enableLogging"))
                                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.enableLogging);
                            if (message.matchMode != null && Object.hasOwnProperty.call(message, "matchMode"))
                                writer.uint32(/* id 9, wireType 0 =*/72).int32(message.matchMode);
                            if (message.classificationThreshold != null && Object.hasOwnProperty.call(message, "classificationThreshold"))
                                writer.uint32(/* id 10, wireType 5 =*/85).float(message.classificationThreshold);
                            if (message.apiVersion != null && Object.hasOwnProperty.call(message, "apiVersion"))
                                writer.uint32(/* id 14, wireType 0 =*/112).int32(message.apiVersion);
                            if (message.tier != null && Object.hasOwnProperty.call(message, "tier"))
                                writer.uint32(/* id 15, wireType 0 =*/120).int32(message.tier);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Agent message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Agent.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgent} message Agent message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Agent.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an Agent message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.Agent} Agent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Agent.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.Agent();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.displayName = reader.string();
                                    break;
                                case 3:
                                    message.defaultLanguageCode = reader.string();
                                    break;
                                case 4:
                                    if (!(message.supportedLanguageCodes && message.supportedLanguageCodes.length))
                                        message.supportedLanguageCodes = [];
                                    message.supportedLanguageCodes.push(reader.string());
                                    break;
                                case 5:
                                    message.timeZone = reader.string();
                                    break;
                                case 6:
                                    message.description = reader.string();
                                    break;
                                case 7:
                                    message.avatarUri = reader.string();
                                    break;
                                case 8:
                                    message.enableLogging = reader.bool();
                                    break;
                                case 9:
                                    message.matchMode = reader.int32();
                                    break;
                                case 10:
                                    message.classificationThreshold = reader.float();
                                    break;
                                case 14:
                                    message.apiVersion = reader.int32();
                                    break;
                                case 15:
                                    message.tier = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an Agent message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.Agent} Agent
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Agent.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an Agent message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Agent.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.defaultLanguageCode != null && message.hasOwnProperty("defaultLanguageCode"))
                                if (!$util.isString(message.defaultLanguageCode))
                                    return "defaultLanguageCode: string expected";
                            if (message.supportedLanguageCodes != null && message.hasOwnProperty("supportedLanguageCodes")) {
                                if (!Array.isArray(message.supportedLanguageCodes))
                                    return "supportedLanguageCodes: array expected";
                                for (var i = 0; i < message.supportedLanguageCodes.length; ++i)
                                    if (!$util.isString(message.supportedLanguageCodes[i]))
                                        return "supportedLanguageCodes: string[] expected";
                            }
                            if (message.timeZone != null && message.hasOwnProperty("timeZone"))
                                if (!$util.isString(message.timeZone))
                                    return "timeZone: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.avatarUri != null && message.hasOwnProperty("avatarUri"))
                                if (!$util.isString(message.avatarUri))
                                    return "avatarUri: string expected";
                            if (message.enableLogging != null && message.hasOwnProperty("enableLogging"))
                                if (typeof message.enableLogging !== "boolean")
                                    return "enableLogging: boolean expected";
                            if (message.matchMode != null && message.hasOwnProperty("matchMode"))
                                switch (message.matchMode) {
                                default:
                                    return "matchMode: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.classificationThreshold != null && message.hasOwnProperty("classificationThreshold"))
                                if (typeof message.classificationThreshold !== "number")
                                    return "classificationThreshold: number expected";
                            if (message.apiVersion != null && message.hasOwnProperty("apiVersion"))
                                switch (message.apiVersion) {
                                default:
                                    return "apiVersion: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.tier != null && message.hasOwnProperty("tier"))
                                switch (message.tier) {
                                default:
                                    return "tier: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates an Agent message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.Agent} Agent
                         */
                        Agent.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.Agent)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.Agent();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.defaultLanguageCode != null)
                                message.defaultLanguageCode = String(object.defaultLanguageCode);
                            if (object.supportedLanguageCodes) {
                                if (!Array.isArray(object.supportedLanguageCodes))
                                    throw TypeError(".google.cloud.dialogflow.v2.Agent.supportedLanguageCodes: array expected");
                                message.supportedLanguageCodes = [];
                                for (var i = 0; i < object.supportedLanguageCodes.length; ++i)
                                    message.supportedLanguageCodes[i] = String(object.supportedLanguageCodes[i]);
                            }
                            if (object.timeZone != null)
                                message.timeZone = String(object.timeZone);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.avatarUri != null)
                                message.avatarUri = String(object.avatarUri);
                            if (object.enableLogging != null)
                                message.enableLogging = Boolean(object.enableLogging);
                            switch (object.matchMode) {
                            case "MATCH_MODE_UNSPECIFIED":
                            case 0:
                                message.matchMode = 0;
                                break;
                            case "MATCH_MODE_HYBRID":
                            case 1:
                                message.matchMode = 1;
                                break;
                            case "MATCH_MODE_ML_ONLY":
                            case 2:
                                message.matchMode = 2;
                                break;
                            }
                            if (object.classificationThreshold != null)
                                message.classificationThreshold = Number(object.classificationThreshold);
                            switch (object.apiVersion) {
                            case "API_VERSION_UNSPECIFIED":
                            case 0:
                                message.apiVersion = 0;
                                break;
                            case "API_VERSION_V1":
                            case 1:
                                message.apiVersion = 1;
                                break;
                            case "API_VERSION_V2":
                            case 2:
                                message.apiVersion = 2;
                                break;
                            case "API_VERSION_V2_BETA_1":
                            case 3:
                                message.apiVersion = 3;
                                break;
                            }
                            switch (object.tier) {
                            case "TIER_UNSPECIFIED":
                            case 0:
                                message.tier = 0;
                                break;
                            case "TIER_STANDARD":
                            case 1:
                                message.tier = 1;
                                break;
                            case "TIER_ENTERPRISE":
                            case 2:
                                message.tier = 2;
                                break;
                            case "TIER_ENTERPRISE_PLUS":
                            case 3:
                                message.tier = 3;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an Agent message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @static
                         * @param {google.cloud.dialogflow.v2.Agent} message Agent
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Agent.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.supportedLanguageCodes = [];
                            if (options.defaults) {
                                object.parent = "";
                                object.displayName = "";
                                object.defaultLanguageCode = "";
                                object.timeZone = "";
                                object.description = "";
                                object.avatarUri = "";
                                object.enableLogging = false;
                                object.matchMode = options.enums === String ? "MATCH_MODE_UNSPECIFIED" : 0;
                                object.classificationThreshold = 0;
                                object.apiVersion = options.enums === String ? "API_VERSION_UNSPECIFIED" : 0;
                                object.tier = options.enums === String ? "TIER_UNSPECIFIED" : 0;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.defaultLanguageCode != null && message.hasOwnProperty("defaultLanguageCode"))
                                object.defaultLanguageCode = message.defaultLanguageCode;
                            if (message.supportedLanguageCodes && message.supportedLanguageCodes.length) {
                                object.supportedLanguageCodes = [];
                                for (var j = 0; j < message.supportedLanguageCodes.length; ++j)
                                    object.supportedLanguageCodes[j] = message.supportedLanguageCodes[j];
                            }
                            if (message.timeZone != null && message.hasOwnProperty("timeZone"))
                                object.timeZone = message.timeZone;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.avatarUri != null && message.hasOwnProperty("avatarUri"))
                                object.avatarUri = message.avatarUri;
                            if (message.enableLogging != null && message.hasOwnProperty("enableLogging"))
                                object.enableLogging = message.enableLogging;
                            if (message.matchMode != null && message.hasOwnProperty("matchMode"))
                                object.matchMode = options.enums === String ? $root.google.cloud.dialogflow.v2.Agent.MatchMode[message.matchMode] : message.matchMode;
                            if (message.classificationThreshold != null && message.hasOwnProperty("classificationThreshold"))
                                object.classificationThreshold = options.json && !isFinite(message.classificationThreshold) ? String(message.classificationThreshold) : message.classificationThreshold;
                            if (message.apiVersion != null && message.hasOwnProperty("apiVersion"))
                                object.apiVersion = options.enums === String ? $root.google.cloud.dialogflow.v2.Agent.ApiVersion[message.apiVersion] : message.apiVersion;
                            if (message.tier != null && message.hasOwnProperty("tier"))
                                object.tier = options.enums === String ? $root.google.cloud.dialogflow.v2.Agent.Tier[message.tier] : message.tier;
                            return object;
                        };
    
                        /**
                         * Converts this Agent to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.Agent
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Agent.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * MatchMode enum.
                         * @name google.cloud.dialogflow.v2.Agent.MatchMode
                         * @enum {number}
                         * @property {number} MATCH_MODE_UNSPECIFIED=0 MATCH_MODE_UNSPECIFIED value
                         * @property {number} MATCH_MODE_HYBRID=1 MATCH_MODE_HYBRID value
                         * @property {number} MATCH_MODE_ML_ONLY=2 MATCH_MODE_ML_ONLY value
                         */
                        Agent.MatchMode = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "MATCH_MODE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "MATCH_MODE_HYBRID"] = 1;
                            values[valuesById[2] = "MATCH_MODE_ML_ONLY"] = 2;
                            return values;
                        })();
    
                        /**
                         * ApiVersion enum.
                         * @name google.cloud.dialogflow.v2.Agent.ApiVersion
                         * @enum {number}
                         * @property {number} API_VERSION_UNSPECIFIED=0 API_VERSION_UNSPECIFIED value
                         * @property {number} API_VERSION_V1=1 API_VERSION_V1 value
                         * @property {number} API_VERSION_V2=2 API_VERSION_V2 value
                         * @property {number} API_VERSION_V2_BETA_1=3 API_VERSION_V2_BETA_1 value
                         */
                        Agent.ApiVersion = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "API_VERSION_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "API_VERSION_V1"] = 1;
                            values[valuesById[2] = "API_VERSION_V2"] = 2;
                            values[valuesById[3] = "API_VERSION_V2_BETA_1"] = 3;
                            return values;
                        })();
    
                        /**
                         * Tier enum.
                         * @name google.cloud.dialogflow.v2.Agent.Tier
                         * @enum {number}
                         * @property {number} TIER_UNSPECIFIED=0 TIER_UNSPECIFIED value
                         * @property {number} TIER_STANDARD=1 TIER_STANDARD value
                         * @property {number} TIER_ENTERPRISE=2 TIER_ENTERPRISE value
                         * @property {number} TIER_ENTERPRISE_PLUS=3 TIER_ENTERPRISE_PLUS value
                         */
                        Agent.Tier = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "TIER_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "TIER_STANDARD"] = 1;
                            values[valuesById[2] = "TIER_ENTERPRISE"] = 2;
                            values[valuesById[3] = "TIER_ENTERPRISE_PLUS"] = 3;
                            return values;
                        })();
    
                        return Agent;
                    })();
    
                    v2.GetAgentRequest = (function() {
    
                        /**
                         * Properties of a GetAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IGetAgentRequest
                         * @property {string|null} [parent] GetAgentRequest parent
                         */
    
                        /**
                         * Constructs a new GetAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a GetAgentRequest.
                         * @implements IGetAgentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IGetAgentRequest=} [properties] Properties to set
                         */
                        function GetAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetAgentRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @instance
                         */
                        GetAgentRequest.prototype.parent = "";
    
                        /**
                         * Creates a new GetAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.GetAgentRequest} GetAgentRequest instance
                         */
                        GetAgentRequest.create = function create(properties) {
                            return new GetAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetAgentRequest} message GetAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetAgentRequest} message GetAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.GetAgentRequest} GetAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAgentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.GetAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.GetAgentRequest} GetAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.GetAgentRequest} GetAgentRequest
                         */
                        GetAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.GetAgentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.GetAgentRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.GetAgentRequest} message GetAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            return object;
                        };
    
                        /**
                         * Converts this GetAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.GetAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return GetAgentRequest;
                    })();
    
                    v2.SetAgentRequest = (function() {
    
                        /**
                         * Properties of a SetAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISetAgentRequest
                         * @property {google.cloud.dialogflow.v2.IAgent|null} [agent] SetAgentRequest agent
                         * @property {google.protobuf.IFieldMask|null} [updateMask] SetAgentRequest updateMask
                         */
    
                        /**
                         * Constructs a new SetAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SetAgentRequest.
                         * @implements ISetAgentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISetAgentRequest=} [properties] Properties to set
                         */
                        function SetAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SetAgentRequest agent.
                         * @member {google.cloud.dialogflow.v2.IAgent|null|undefined} agent
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @instance
                         */
                        SetAgentRequest.prototype.agent = null;
    
                        /**
                         * SetAgentRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @instance
                         */
                        SetAgentRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new SetAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISetAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SetAgentRequest} SetAgentRequest instance
                         */
                        SetAgentRequest.create = function create(properties) {
                            return new SetAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SetAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SetAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISetAgentRequest} message SetAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SetAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.agent != null && Object.hasOwnProperty.call(message, "agent"))
                                $root.google.cloud.dialogflow.v2.Agent.encode(message.agent, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SetAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SetAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISetAgentRequest} message SetAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SetAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SetAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SetAgentRequest} SetAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SetAgentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SetAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.agent = $root.google.cloud.dialogflow.v2.Agent.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SetAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SetAgentRequest} SetAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SetAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SetAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SetAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.agent != null && message.hasOwnProperty("agent")) {
                                var error = $root.google.cloud.dialogflow.v2.Agent.verify(message.agent);
                                if (error)
                                    return "agent." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SetAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SetAgentRequest} SetAgentRequest
                         */
                        SetAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SetAgentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SetAgentRequest();
                            if (object.agent != null) {
                                if (typeof object.agent !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SetAgentRequest.agent: object expected");
                                message.agent = $root.google.cloud.dialogflow.v2.Agent.fromObject(object.agent);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SetAgentRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SetAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.SetAgentRequest} message SetAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SetAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.agent = null;
                                object.updateMask = null;
                            }
                            if (message.agent != null && message.hasOwnProperty("agent"))
                                object.agent = $root.google.cloud.dialogflow.v2.Agent.toObject(message.agent, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this SetAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SetAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SetAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SetAgentRequest;
                    })();
    
                    v2.DeleteAgentRequest = (function() {
    
                        /**
                         * Properties of a DeleteAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IDeleteAgentRequest
                         * @property {string|null} [parent] DeleteAgentRequest parent
                         */
    
                        /**
                         * Constructs a new DeleteAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a DeleteAgentRequest.
                         * @implements IDeleteAgentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IDeleteAgentRequest=} [properties] Properties to set
                         */
                        function DeleteAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DeleteAgentRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @instance
                         */
                        DeleteAgentRequest.prototype.parent = "";
    
                        /**
                         * Creates a new DeleteAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDeleteAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.DeleteAgentRequest} DeleteAgentRequest instance
                         */
                        DeleteAgentRequest.create = function create(properties) {
                            return new DeleteAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DeleteAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDeleteAgentRequest} message DeleteAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DeleteAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DeleteAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDeleteAgentRequest} message DeleteAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DeleteAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.DeleteAgentRequest} DeleteAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAgentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.DeleteAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DeleteAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.DeleteAgentRequest} DeleteAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DeleteAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a DeleteAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.DeleteAgentRequest} DeleteAgentRequest
                         */
                        DeleteAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.DeleteAgentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.DeleteAgentRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DeleteAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.DeleteAgentRequest} message DeleteAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            return object;
                        };
    
                        /**
                         * Converts this DeleteAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.DeleteAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return DeleteAgentRequest;
                    })();
    
                    v2.SearchAgentsRequest = (function() {
    
                        /**
                         * Properties of a SearchAgentsRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISearchAgentsRequest
                         * @property {string|null} [parent] SearchAgentsRequest parent
                         * @property {number|null} [pageSize] SearchAgentsRequest pageSize
                         * @property {string|null} [pageToken] SearchAgentsRequest pageToken
                         */
    
                        /**
                         * Constructs a new SearchAgentsRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SearchAgentsRequest.
                         * @implements ISearchAgentsRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsRequest=} [properties] Properties to set
                         */
                        function SearchAgentsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchAgentsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @instance
                         */
                        SearchAgentsRequest.prototype.parent = "";
    
                        /**
                         * SearchAgentsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @instance
                         */
                        SearchAgentsRequest.prototype.pageSize = 0;
    
                        /**
                         * SearchAgentsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @instance
                         */
                        SearchAgentsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new SearchAgentsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsRequest} SearchAgentsRequest instance
                         */
                        SearchAgentsRequest.create = function create(properties) {
                            return new SearchAgentsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SearchAgentsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsRequest} message SearchAgentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchAgentsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchAgentsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsRequest} message SearchAgentsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchAgentsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchAgentsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsRequest} SearchAgentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchAgentsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SearchAgentsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.pageSize = reader.int32();
                                    break;
                                case 3:
                                    message.pageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchAgentsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsRequest} SearchAgentsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchAgentsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchAgentsRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchAgentsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchAgentsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsRequest} SearchAgentsRequest
                         */
                        SearchAgentsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SearchAgentsRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SearchAgentsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchAgentsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.SearchAgentsRequest} message SearchAgentsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchAgentsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this SearchAgentsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchAgentsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SearchAgentsRequest;
                    })();
    
                    v2.SearchAgentsResponse = (function() {
    
                        /**
                         * Properties of a SearchAgentsResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISearchAgentsResponse
                         * @property {Array.<google.cloud.dialogflow.v2.IAgent>|null} [agents] SearchAgentsResponse agents
                         * @property {string|null} [nextPageToken] SearchAgentsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new SearchAgentsResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SearchAgentsResponse.
                         * @implements ISearchAgentsResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsResponse=} [properties] Properties to set
                         */
                        function SearchAgentsResponse(properties) {
                            this.agents = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SearchAgentsResponse agents.
                         * @member {Array.<google.cloud.dialogflow.v2.IAgent>} agents
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @instance
                         */
                        SearchAgentsResponse.prototype.agents = $util.emptyArray;
    
                        /**
                         * SearchAgentsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @instance
                         */
                        SearchAgentsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new SearchAgentsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsResponse} SearchAgentsResponse instance
                         */
                        SearchAgentsResponse.create = function create(properties) {
                            return new SearchAgentsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified SearchAgentsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsResponse} message SearchAgentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchAgentsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.agents != null && message.agents.length)
                                for (var i = 0; i < message.agents.length; ++i)
                                    $root.google.cloud.dialogflow.v2.Agent.encode(message.agents[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SearchAgentsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SearchAgentsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISearchAgentsResponse} message SearchAgentsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SearchAgentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SearchAgentsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsResponse} SearchAgentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchAgentsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SearchAgentsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.agents && message.agents.length))
                                        message.agents = [];
                                    message.agents.push($root.google.cloud.dialogflow.v2.Agent.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.nextPageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SearchAgentsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsResponse} SearchAgentsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SearchAgentsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SearchAgentsResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SearchAgentsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.agents != null && message.hasOwnProperty("agents")) {
                                if (!Array.isArray(message.agents))
                                    return "agents: array expected";
                                for (var i = 0; i < message.agents.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.Agent.verify(message.agents[i]);
                                    if (error)
                                        return "agents." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SearchAgentsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SearchAgentsResponse} SearchAgentsResponse
                         */
                        SearchAgentsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SearchAgentsResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SearchAgentsResponse();
                            if (object.agents) {
                                if (!Array.isArray(object.agents))
                                    throw TypeError(".google.cloud.dialogflow.v2.SearchAgentsResponse.agents: array expected");
                                message.agents = [];
                                for (var i = 0; i < object.agents.length; ++i) {
                                    if (typeof object.agents[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.SearchAgentsResponse.agents: object expected");
                                    message.agents[i] = $root.google.cloud.dialogflow.v2.Agent.fromObject(object.agents[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SearchAgentsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.SearchAgentsResponse} message SearchAgentsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SearchAgentsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.agents = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.agents && message.agents.length) {
                                object.agents = [];
                                for (var j = 0; j < message.agents.length; ++j)
                                    object.agents[j] = $root.google.cloud.dialogflow.v2.Agent.toObject(message.agents[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this SearchAgentsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SearchAgentsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SearchAgentsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SearchAgentsResponse;
                    })();
    
                    v2.TrainAgentRequest = (function() {
    
                        /**
                         * Properties of a TrainAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ITrainAgentRequest
                         * @property {string|null} [parent] TrainAgentRequest parent
                         */
    
                        /**
                         * Constructs a new TrainAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a TrainAgentRequest.
                         * @implements ITrainAgentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ITrainAgentRequest=} [properties] Properties to set
                         */
                        function TrainAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * TrainAgentRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @instance
                         */
                        TrainAgentRequest.prototype.parent = "";
    
                        /**
                         * Creates a new TrainAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ITrainAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.TrainAgentRequest} TrainAgentRequest instance
                         */
                        TrainAgentRequest.create = function create(properties) {
                            return new TrainAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified TrainAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.TrainAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ITrainAgentRequest} message TrainAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TrainAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TrainAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.TrainAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ITrainAgentRequest} message TrainAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TrainAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TrainAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.TrainAgentRequest} TrainAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TrainAgentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.TrainAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TrainAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.TrainAgentRequest} TrainAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TrainAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TrainAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TrainAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a TrainAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.TrainAgentRequest} TrainAgentRequest
                         */
                        TrainAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.TrainAgentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.TrainAgentRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a TrainAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.TrainAgentRequest} message TrainAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TrainAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            return object;
                        };
    
                        /**
                         * Converts this TrainAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.TrainAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TrainAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return TrainAgentRequest;
                    })();
    
                    v2.ExportAgentRequest = (function() {
    
                        /**
                         * Properties of an ExportAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IExportAgentRequest
                         * @property {string|null} [parent] ExportAgentRequest parent
                         * @property {string|null} [agentUri] ExportAgentRequest agentUri
                         */
    
                        /**
                         * Constructs a new ExportAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an ExportAgentRequest.
                         * @implements IExportAgentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IExportAgentRequest=} [properties] Properties to set
                         */
                        function ExportAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExportAgentRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @instance
                         */
                        ExportAgentRequest.prototype.parent = "";
    
                        /**
                         * ExportAgentRequest agentUri.
                         * @member {string} agentUri
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @instance
                         */
                        ExportAgentRequest.prototype.agentUri = "";
    
                        /**
                         * Creates a new ExportAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IExportAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ExportAgentRequest} ExportAgentRequest instance
                         */
                        ExportAgentRequest.create = function create(properties) {
                            return new ExportAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ExportAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IExportAgentRequest} message ExportAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.agentUri != null && Object.hasOwnProperty.call(message, "agentUri"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.agentUri);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExportAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IExportAgentRequest} message ExportAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExportAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ExportAgentRequest} ExportAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAgentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ExportAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.agentUri = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExportAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ExportAgentRequest} ExportAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExportAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExportAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.agentUri != null && message.hasOwnProperty("agentUri"))
                                if (!$util.isString(message.agentUri))
                                    return "agentUri: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ExportAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ExportAgentRequest} ExportAgentRequest
                         */
                        ExportAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ExportAgentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ExportAgentRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.agentUri != null)
                                message.agentUri = String(object.agentUri);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExportAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ExportAgentRequest} message ExportAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExportAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.agentUri = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.agentUri != null && message.hasOwnProperty("agentUri"))
                                object.agentUri = message.agentUri;
                            return object;
                        };
    
                        /**
                         * Converts this ExportAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ExportAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExportAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ExportAgentRequest;
                    })();
    
                    v2.ExportAgentResponse = (function() {
    
                        /**
                         * Properties of an ExportAgentResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IExportAgentResponse
                         * @property {string|null} [agentUri] ExportAgentResponse agentUri
                         * @property {Uint8Array|null} [agentContent] ExportAgentResponse agentContent
                         */
    
                        /**
                         * Constructs a new ExportAgentResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an ExportAgentResponse.
                         * @implements IExportAgentResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IExportAgentResponse=} [properties] Properties to set
                         */
                        function ExportAgentResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ExportAgentResponse agentUri.
                         * @member {string|null|undefined} agentUri
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @instance
                         */
                        ExportAgentResponse.prototype.agentUri = null;
    
                        /**
                         * ExportAgentResponse agentContent.
                         * @member {Uint8Array|null|undefined} agentContent
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @instance
                         */
                        ExportAgentResponse.prototype.agentContent = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * ExportAgentResponse agent.
                         * @member {"agentUri"|"agentContent"|undefined} agent
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @instance
                         */
                        Object.defineProperty(ExportAgentResponse.prototype, "agent", {
                            get: $util.oneOfGetter($oneOfFields = ["agentUri", "agentContent"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ExportAgentResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IExportAgentResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ExportAgentResponse} ExportAgentResponse instance
                         */
                        ExportAgentResponse.create = function create(properties) {
                            return new ExportAgentResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ExportAgentResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IExportAgentResponse} message ExportAgentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAgentResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.agentUri != null && Object.hasOwnProperty.call(message, "agentUri"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.agentUri);
                            if (message.agentContent != null && Object.hasOwnProperty.call(message, "agentContent"))
                                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.agentContent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ExportAgentResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ExportAgentResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IExportAgentResponse} message ExportAgentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ExportAgentResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ExportAgentResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ExportAgentResponse} ExportAgentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAgentResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ExportAgentResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.agentUri = reader.string();
                                    break;
                                case 2:
                                    message.agentContent = reader.bytes();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ExportAgentResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ExportAgentResponse} ExportAgentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ExportAgentResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ExportAgentResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ExportAgentResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.agentUri != null && message.hasOwnProperty("agentUri")) {
                                properties.agent = 1;
                                if (!$util.isString(message.agentUri))
                                    return "agentUri: string expected";
                            }
                            if (message.agentContent != null && message.hasOwnProperty("agentContent")) {
                                if (properties.agent === 1)
                                    return "agent: multiple values";
                                properties.agent = 1;
                                if (!(message.agentContent && typeof message.agentContent.length === "number" || $util.isString(message.agentContent)))
                                    return "agentContent: buffer expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ExportAgentResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ExportAgentResponse} ExportAgentResponse
                         */
                        ExportAgentResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ExportAgentResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ExportAgentResponse();
                            if (object.agentUri != null)
                                message.agentUri = String(object.agentUri);
                            if (object.agentContent != null)
                                if (typeof object.agentContent === "string")
                                    $util.base64.decode(object.agentContent, message.agentContent = $util.newBuffer($util.base64.length(object.agentContent)), 0);
                                else if (object.agentContent.length)
                                    message.agentContent = object.agentContent;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ExportAgentResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ExportAgentResponse} message ExportAgentResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ExportAgentResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.agentUri != null && message.hasOwnProperty("agentUri")) {
                                object.agentUri = message.agentUri;
                                if (options.oneofs)
                                    object.agent = "agentUri";
                            }
                            if (message.agentContent != null && message.hasOwnProperty("agentContent")) {
                                object.agentContent = options.bytes === String ? $util.base64.encode(message.agentContent, 0, message.agentContent.length) : options.bytes === Array ? Array.prototype.slice.call(message.agentContent) : message.agentContent;
                                if (options.oneofs)
                                    object.agent = "agentContent";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ExportAgentResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ExportAgentResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ExportAgentResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ExportAgentResponse;
                    })();
    
                    v2.ImportAgentRequest = (function() {
    
                        /**
                         * Properties of an ImportAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IImportAgentRequest
                         * @property {string|null} [parent] ImportAgentRequest parent
                         * @property {string|null} [agentUri] ImportAgentRequest agentUri
                         * @property {Uint8Array|null} [agentContent] ImportAgentRequest agentContent
                         */
    
                        /**
                         * Constructs a new ImportAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an ImportAgentRequest.
                         * @implements IImportAgentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IImportAgentRequest=} [properties] Properties to set
                         */
                        function ImportAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ImportAgentRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @instance
                         */
                        ImportAgentRequest.prototype.parent = "";
    
                        /**
                         * ImportAgentRequest agentUri.
                         * @member {string|null|undefined} agentUri
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @instance
                         */
                        ImportAgentRequest.prototype.agentUri = null;
    
                        /**
                         * ImportAgentRequest agentContent.
                         * @member {Uint8Array|null|undefined} agentContent
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @instance
                         */
                        ImportAgentRequest.prototype.agentContent = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * ImportAgentRequest agent.
                         * @member {"agentUri"|"agentContent"|undefined} agent
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @instance
                         */
                        Object.defineProperty(ImportAgentRequest.prototype, "agent", {
                            get: $util.oneOfGetter($oneOfFields = ["agentUri", "agentContent"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new ImportAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IImportAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ImportAgentRequest} ImportAgentRequest instance
                         */
                        ImportAgentRequest.create = function create(properties) {
                            return new ImportAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ImportAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ImportAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IImportAgentRequest} message ImportAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.agentUri != null && Object.hasOwnProperty.call(message, "agentUri"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.agentUri);
                            if (message.agentContent != null && Object.hasOwnProperty.call(message, "agentContent"))
                                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.agentContent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ImportAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ImportAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IImportAgentRequest} message ImportAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ImportAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ImportAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ImportAgentRequest} ImportAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportAgentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ImportAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.agentUri = reader.string();
                                    break;
                                case 3:
                                    message.agentContent = reader.bytes();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ImportAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ImportAgentRequest} ImportAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ImportAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ImportAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ImportAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.agentUri != null && message.hasOwnProperty("agentUri")) {
                                properties.agent = 1;
                                if (!$util.isString(message.agentUri))
                                    return "agentUri: string expected";
                            }
                            if (message.agentContent != null && message.hasOwnProperty("agentContent")) {
                                if (properties.agent === 1)
                                    return "agent: multiple values";
                                properties.agent = 1;
                                if (!(message.agentContent && typeof message.agentContent.length === "number" || $util.isString(message.agentContent)))
                                    return "agentContent: buffer expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an ImportAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ImportAgentRequest} ImportAgentRequest
                         */
                        ImportAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ImportAgentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ImportAgentRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.agentUri != null)
                                message.agentUri = String(object.agentUri);
                            if (object.agentContent != null)
                                if (typeof object.agentContent === "string")
                                    $util.base64.decode(object.agentContent, message.agentContent = $util.newBuffer($util.base64.length(object.agentContent)), 0);
                                else if (object.agentContent.length)
                                    message.agentContent = object.agentContent;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ImportAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ImportAgentRequest} message ImportAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ImportAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.agentUri != null && message.hasOwnProperty("agentUri")) {
                                object.agentUri = message.agentUri;
                                if (options.oneofs)
                                    object.agent = "agentUri";
                            }
                            if (message.agentContent != null && message.hasOwnProperty("agentContent")) {
                                object.agentContent = options.bytes === String ? $util.base64.encode(message.agentContent, 0, message.agentContent.length) : options.bytes === Array ? Array.prototype.slice.call(message.agentContent) : message.agentContent;
                                if (options.oneofs)
                                    object.agent = "agentContent";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ImportAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ImportAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ImportAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ImportAgentRequest;
                    })();
    
                    v2.RestoreAgentRequest = (function() {
    
                        /**
                         * Properties of a RestoreAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IRestoreAgentRequest
                         * @property {string|null} [parent] RestoreAgentRequest parent
                         * @property {string|null} [agentUri] RestoreAgentRequest agentUri
                         * @property {Uint8Array|null} [agentContent] RestoreAgentRequest agentContent
                         */
    
                        /**
                         * Constructs a new RestoreAgentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a RestoreAgentRequest.
                         * @implements IRestoreAgentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IRestoreAgentRequest=} [properties] Properties to set
                         */
                        function RestoreAgentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * RestoreAgentRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @instance
                         */
                        RestoreAgentRequest.prototype.parent = "";
    
                        /**
                         * RestoreAgentRequest agentUri.
                         * @member {string|null|undefined} agentUri
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @instance
                         */
                        RestoreAgentRequest.prototype.agentUri = null;
    
                        /**
                         * RestoreAgentRequest agentContent.
                         * @member {Uint8Array|null|undefined} agentContent
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @instance
                         */
                        RestoreAgentRequest.prototype.agentContent = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * RestoreAgentRequest agent.
                         * @member {"agentUri"|"agentContent"|undefined} agent
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @instance
                         */
                        Object.defineProperty(RestoreAgentRequest.prototype, "agent", {
                            get: $util.oneOfGetter($oneOfFields = ["agentUri", "agentContent"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new RestoreAgentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IRestoreAgentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.RestoreAgentRequest} RestoreAgentRequest instance
                         */
                        RestoreAgentRequest.create = function create(properties) {
                            return new RestoreAgentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified RestoreAgentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.RestoreAgentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IRestoreAgentRequest} message RestoreAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        RestoreAgentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.agentUri != null && Object.hasOwnProperty.call(message, "agentUri"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.agentUri);
                            if (message.agentContent != null && Object.hasOwnProperty.call(message, "agentContent"))
                                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.agentContent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified RestoreAgentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.RestoreAgentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IRestoreAgentRequest} message RestoreAgentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        RestoreAgentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a RestoreAgentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.RestoreAgentRequest} RestoreAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        RestoreAgentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.RestoreAgentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.agentUri = reader.string();
                                    break;
                                case 3:
                                    message.agentContent = reader.bytes();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a RestoreAgentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.RestoreAgentRequest} RestoreAgentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        RestoreAgentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a RestoreAgentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        RestoreAgentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.agentUri != null && message.hasOwnProperty("agentUri")) {
                                properties.agent = 1;
                                if (!$util.isString(message.agentUri))
                                    return "agentUri: string expected";
                            }
                            if (message.agentContent != null && message.hasOwnProperty("agentContent")) {
                                if (properties.agent === 1)
                                    return "agent: multiple values";
                                properties.agent = 1;
                                if (!(message.agentContent && typeof message.agentContent.length === "number" || $util.isString(message.agentContent)))
                                    return "agentContent: buffer expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a RestoreAgentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.RestoreAgentRequest} RestoreAgentRequest
                         */
                        RestoreAgentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.RestoreAgentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.RestoreAgentRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.agentUri != null)
                                message.agentUri = String(object.agentUri);
                            if (object.agentContent != null)
                                if (typeof object.agentContent === "string")
                                    $util.base64.decode(object.agentContent, message.agentContent = $util.newBuffer($util.base64.length(object.agentContent)), 0);
                                else if (object.agentContent.length)
                                    message.agentContent = object.agentContent;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a RestoreAgentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.RestoreAgentRequest} message RestoreAgentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        RestoreAgentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.parent = "";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.agentUri != null && message.hasOwnProperty("agentUri")) {
                                object.agentUri = message.agentUri;
                                if (options.oneofs)
                                    object.agent = "agentUri";
                            }
                            if (message.agentContent != null && message.hasOwnProperty("agentContent")) {
                                object.agentContent = options.bytes === String ? $util.base64.encode(message.agentContent, 0, message.agentContent.length) : options.bytes === Array ? Array.prototype.slice.call(message.agentContent) : message.agentContent;
                                if (options.oneofs)
                                    object.agent = "agentContent";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this RestoreAgentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.RestoreAgentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        RestoreAgentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return RestoreAgentRequest;
                    })();
    
                    v2.GetValidationResultRequest = (function() {
    
                        /**
                         * Properties of a GetValidationResultRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IGetValidationResultRequest
                         * @property {string|null} [parent] GetValidationResultRequest parent
                         * @property {string|null} [languageCode] GetValidationResultRequest languageCode
                         */
    
                        /**
                         * Constructs a new GetValidationResultRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a GetValidationResultRequest.
                         * @implements IGetValidationResultRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IGetValidationResultRequest=} [properties] Properties to set
                         */
                        function GetValidationResultRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetValidationResultRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @instance
                         */
                        GetValidationResultRequest.prototype.parent = "";
    
                        /**
                         * GetValidationResultRequest languageCode.
                         * @member {string} languageCode
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @instance
                         */
                        GetValidationResultRequest.prototype.languageCode = "";
    
                        /**
                         * Creates a new GetValidationResultRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetValidationResultRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.GetValidationResultRequest} GetValidationResultRequest instance
                         */
                        GetValidationResultRequest.create = function create(properties) {
                            return new GetValidationResultRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetValidationResultRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetValidationResultRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetValidationResultRequest} message GetValidationResultRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetValidationResultRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.languageCode != null && Object.hasOwnProperty.call(message, "languageCode"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.languageCode);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetValidationResultRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetValidationResultRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetValidationResultRequest} message GetValidationResultRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetValidationResultRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetValidationResultRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.GetValidationResultRequest} GetValidationResultRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetValidationResultRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.GetValidationResultRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 3:
                                    message.languageCode = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetValidationResultRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.GetValidationResultRequest} GetValidationResultRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetValidationResultRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetValidationResultRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetValidationResultRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                if (!$util.isString(message.languageCode))
                                    return "languageCode: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetValidationResultRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.GetValidationResultRequest} GetValidationResultRequest
                         */
                        GetValidationResultRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.GetValidationResultRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.GetValidationResultRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.languageCode != null)
                                message.languageCode = String(object.languageCode);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetValidationResultRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.GetValidationResultRequest} message GetValidationResultRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetValidationResultRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.languageCode = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                object.languageCode = message.languageCode;
                            return object;
                        };
    
                        /**
                         * Converts this GetValidationResultRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.GetValidationResultRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetValidationResultRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return GetValidationResultRequest;
                    })();
    
                    v2.ValidationError = (function() {
    
                        /**
                         * Properties of a ValidationError.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IValidationError
                         * @property {google.cloud.dialogflow.v2.ValidationError.Severity|null} [severity] ValidationError severity
                         * @property {Array.<string>|null} [entries] ValidationError entries
                         * @property {string|null} [errorMessage] ValidationError errorMessage
                         */
    
                        /**
                         * Constructs a new ValidationError.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a ValidationError.
                         * @implements IValidationError
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IValidationError=} [properties] Properties to set
                         */
                        function ValidationError(properties) {
                            this.entries = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ValidationError severity.
                         * @member {google.cloud.dialogflow.v2.ValidationError.Severity} severity
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @instance
                         */
                        ValidationError.prototype.severity = 0;
    
                        /**
                         * ValidationError entries.
                         * @member {Array.<string>} entries
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @instance
                         */
                        ValidationError.prototype.entries = $util.emptyArray;
    
                        /**
                         * ValidationError errorMessage.
                         * @member {string} errorMessage
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @instance
                         */
                        ValidationError.prototype.errorMessage = "";
    
                        /**
                         * Creates a new ValidationError instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {google.cloud.dialogflow.v2.IValidationError=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ValidationError} ValidationError instance
                         */
                        ValidationError.create = function create(properties) {
                            return new ValidationError(properties);
                        };
    
                        /**
                         * Encodes the specified ValidationError message. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationError.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {google.cloud.dialogflow.v2.IValidationError} message ValidationError message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidationError.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.severity != null && Object.hasOwnProperty.call(message, "severity"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.severity);
                            if (message.entries != null && message.entries.length)
                                for (var i = 0; i < message.entries.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.entries[i]);
                            if (message.errorMessage != null && Object.hasOwnProperty.call(message, "errorMessage"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.errorMessage);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ValidationError message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationError.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {google.cloud.dialogflow.v2.IValidationError} message ValidationError message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidationError.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ValidationError message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ValidationError} ValidationError
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidationError.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ValidationError();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.severity = reader.int32();
                                    break;
                                case 3:
                                    if (!(message.entries && message.entries.length))
                                        message.entries = [];
                                    message.entries.push(reader.string());
                                    break;
                                case 4:
                                    message.errorMessage = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ValidationError message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ValidationError} ValidationError
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidationError.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ValidationError message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ValidationError.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.severity != null && message.hasOwnProperty("severity"))
                                switch (message.severity) {
                                default:
                                    return "severity: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                    break;
                                }
                            if (message.entries != null && message.hasOwnProperty("entries")) {
                                if (!Array.isArray(message.entries))
                                    return "entries: array expected";
                                for (var i = 0; i < message.entries.length; ++i)
                                    if (!$util.isString(message.entries[i]))
                                        return "entries: string[] expected";
                            }
                            if (message.errorMessage != null && message.hasOwnProperty("errorMessage"))
                                if (!$util.isString(message.errorMessage))
                                    return "errorMessage: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ValidationError message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ValidationError} ValidationError
                         */
                        ValidationError.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ValidationError)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ValidationError();
                            switch (object.severity) {
                            case "SEVERITY_UNSPECIFIED":
                            case 0:
                                message.severity = 0;
                                break;
                            case "INFO":
                            case 1:
                                message.severity = 1;
                                break;
                            case "WARNING":
                            case 2:
                                message.severity = 2;
                                break;
                            case "ERROR":
                            case 3:
                                message.severity = 3;
                                break;
                            case "CRITICAL":
                            case 4:
                                message.severity = 4;
                                break;
                            }
                            if (object.entries) {
                                if (!Array.isArray(object.entries))
                                    throw TypeError(".google.cloud.dialogflow.v2.ValidationError.entries: array expected");
                                message.entries = [];
                                for (var i = 0; i < object.entries.length; ++i)
                                    message.entries[i] = String(object.entries[i]);
                            }
                            if (object.errorMessage != null)
                                message.errorMessage = String(object.errorMessage);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ValidationError message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @static
                         * @param {google.cloud.dialogflow.v2.ValidationError} message ValidationError
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ValidationError.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.entries = [];
                            if (options.defaults) {
                                object.severity = options.enums === String ? "SEVERITY_UNSPECIFIED" : 0;
                                object.errorMessage = "";
                            }
                            if (message.severity != null && message.hasOwnProperty("severity"))
                                object.severity = options.enums === String ? $root.google.cloud.dialogflow.v2.ValidationError.Severity[message.severity] : message.severity;
                            if (message.entries && message.entries.length) {
                                object.entries = [];
                                for (var j = 0; j < message.entries.length; ++j)
                                    object.entries[j] = message.entries[j];
                            }
                            if (message.errorMessage != null && message.hasOwnProperty("errorMessage"))
                                object.errorMessage = message.errorMessage;
                            return object;
                        };
    
                        /**
                         * Converts this ValidationError to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ValidationError
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ValidationError.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Severity enum.
                         * @name google.cloud.dialogflow.v2.ValidationError.Severity
                         * @enum {number}
                         * @property {number} SEVERITY_UNSPECIFIED=0 SEVERITY_UNSPECIFIED value
                         * @property {number} INFO=1 INFO value
                         * @property {number} WARNING=2 WARNING value
                         * @property {number} ERROR=3 ERROR value
                         * @property {number} CRITICAL=4 CRITICAL value
                         */
                        ValidationError.Severity = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "SEVERITY_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "INFO"] = 1;
                            values[valuesById[2] = "WARNING"] = 2;
                            values[valuesById[3] = "ERROR"] = 3;
                            values[valuesById[4] = "CRITICAL"] = 4;
                            return values;
                        })();
    
                        return ValidationError;
                    })();
    
                    v2.ValidationResult = (function() {
    
                        /**
                         * Properties of a ValidationResult.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IValidationResult
                         * @property {Array.<google.cloud.dialogflow.v2.IValidationError>|null} [validationErrors] ValidationResult validationErrors
                         */
    
                        /**
                         * Constructs a new ValidationResult.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a ValidationResult.
                         * @implements IValidationResult
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IValidationResult=} [properties] Properties to set
                         */
                        function ValidationResult(properties) {
                            this.validationErrors = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ValidationResult validationErrors.
                         * @member {Array.<google.cloud.dialogflow.v2.IValidationError>} validationErrors
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @instance
                         */
                        ValidationResult.prototype.validationErrors = $util.emptyArray;
    
                        /**
                         * Creates a new ValidationResult instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.IValidationResult=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ValidationResult} ValidationResult instance
                         */
                        ValidationResult.create = function create(properties) {
                            return new ValidationResult(properties);
                        };
    
                        /**
                         * Encodes the specified ValidationResult message. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationResult.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.IValidationResult} message ValidationResult message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidationResult.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.validationErrors != null && message.validationErrors.length)
                                for (var i = 0; i < message.validationErrors.length; ++i)
                                    $root.google.cloud.dialogflow.v2.ValidationError.encode(message.validationErrors[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ValidationResult message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ValidationResult.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.IValidationResult} message ValidationResult message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidationResult.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ValidationResult message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ValidationResult} ValidationResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidationResult.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ValidationResult();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.validationErrors && message.validationErrors.length))
                                        message.validationErrors = [];
                                    message.validationErrors.push($root.google.cloud.dialogflow.v2.ValidationError.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ValidationResult message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ValidationResult} ValidationResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidationResult.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ValidationResult message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ValidationResult.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.validationErrors != null && message.hasOwnProperty("validationErrors")) {
                                if (!Array.isArray(message.validationErrors))
                                    return "validationErrors: array expected";
                                for (var i = 0; i < message.validationErrors.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.ValidationError.verify(message.validationErrors[i]);
                                    if (error)
                                        return "validationErrors." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ValidationResult message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ValidationResult} ValidationResult
                         */
                        ValidationResult.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ValidationResult)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ValidationResult();
                            if (object.validationErrors) {
                                if (!Array.isArray(object.validationErrors))
                                    throw TypeError(".google.cloud.dialogflow.v2.ValidationResult.validationErrors: array expected");
                                message.validationErrors = [];
                                for (var i = 0; i < object.validationErrors.length; ++i) {
                                    if (typeof object.validationErrors[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.ValidationResult.validationErrors: object expected");
                                    message.validationErrors[i] = $root.google.cloud.dialogflow.v2.ValidationError.fromObject(object.validationErrors[i]);
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ValidationResult message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.ValidationResult} message ValidationResult
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ValidationResult.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.validationErrors = [];
                            if (message.validationErrors && message.validationErrors.length) {
                                object.validationErrors = [];
                                for (var j = 0; j < message.validationErrors.length; ++j)
                                    object.validationErrors[j] = $root.google.cloud.dialogflow.v2.ValidationError.toObject(message.validationErrors[j], options);
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ValidationResult to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ValidationResult
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ValidationResult.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ValidationResult;
                    })();
    
                    v2.AnswerRecords = (function() {
    
                        /**
                         * Constructs a new AnswerRecords service.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AnswerRecords
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function AnswerRecords(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (AnswerRecords.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = AnswerRecords;
    
                        /**
                         * Creates new AnswerRecords service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AnswerRecords
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {AnswerRecords} RPC service. Useful where requests and/or responses are streamed.
                         */
                        AnswerRecords.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.AnswerRecords#listAnswerRecords}.
                         * @memberof google.cloud.dialogflow.v2.AnswerRecords
                         * @typedef ListAnswerRecordsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.ListAnswerRecordsResponse} [response] ListAnswerRecordsResponse
                         */
    
                        /**
                         * Calls ListAnswerRecords.
                         * @function listAnswerRecords
                         * @memberof google.cloud.dialogflow.v2.AnswerRecords
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsRequest} request ListAnswerRecordsRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.AnswerRecords.ListAnswerRecordsCallback} callback Node-style callback called with the error, if any, and ListAnswerRecordsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AnswerRecords.prototype.listAnswerRecords = function listAnswerRecords(request, callback) {
                            return this.rpcCall(listAnswerRecords, $root.google.cloud.dialogflow.v2.ListAnswerRecordsRequest, $root.google.cloud.dialogflow.v2.ListAnswerRecordsResponse, request, callback);
                        }, "name", { value: "ListAnswerRecords" });
    
                        /**
                         * Calls ListAnswerRecords.
                         * @function listAnswerRecords
                         * @memberof google.cloud.dialogflow.v2.AnswerRecords
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsRequest} request ListAnswerRecordsRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.ListAnswerRecordsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.AnswerRecords#updateAnswerRecord}.
                         * @memberof google.cloud.dialogflow.v2.AnswerRecords
                         * @typedef UpdateAnswerRecordCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.AnswerRecord} [response] AnswerRecord
                         */
    
                        /**
                         * Calls UpdateAnswerRecord.
                         * @function updateAnswerRecord
                         * @memberof google.cloud.dialogflow.v2.AnswerRecords
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest} request UpdateAnswerRecordRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.AnswerRecords.UpdateAnswerRecordCallback} callback Node-style callback called with the error, if any, and AnswerRecord
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AnswerRecords.prototype.updateAnswerRecord = function updateAnswerRecord(request, callback) {
                            return this.rpcCall(updateAnswerRecord, $root.google.cloud.dialogflow.v2.UpdateAnswerRecordRequest, $root.google.cloud.dialogflow.v2.AnswerRecord, request, callback);
                        }, "name", { value: "UpdateAnswerRecord" });
    
                        /**
                         * Calls UpdateAnswerRecord.
                         * @function updateAnswerRecord
                         * @memberof google.cloud.dialogflow.v2.AnswerRecords
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest} request UpdateAnswerRecordRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.AnswerRecord>} Promise
                         * @variation 2
                         */
    
                        return AnswerRecords;
                    })();
    
                    v2.AnswerRecord = (function() {
    
                        /**
                         * Properties of an AnswerRecord.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAnswerRecord
                         * @property {string|null} [name] AnswerRecord name
                         * @property {google.cloud.dialogflow.v2.IAnswerFeedback|null} [answerFeedback] AnswerRecord answerFeedback
                         * @property {google.cloud.dialogflow.v2.IAgentAssistantRecord|null} [agentAssistantRecord] AnswerRecord agentAssistantRecord
                         */
    
                        /**
                         * Constructs a new AnswerRecord.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AnswerRecord.
                         * @implements IAnswerRecord
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAnswerRecord=} [properties] Properties to set
                         */
                        function AnswerRecord(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnswerRecord name.
                         * @member {string} name
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @instance
                         */
                        AnswerRecord.prototype.name = "";
    
                        /**
                         * AnswerRecord answerFeedback.
                         * @member {google.cloud.dialogflow.v2.IAnswerFeedback|null|undefined} answerFeedback
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @instance
                         */
                        AnswerRecord.prototype.answerFeedback = null;
    
                        /**
                         * AnswerRecord agentAssistantRecord.
                         * @member {google.cloud.dialogflow.v2.IAgentAssistantRecord|null|undefined} agentAssistantRecord
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @instance
                         */
                        AnswerRecord.prototype.agentAssistantRecord = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AnswerRecord record.
                         * @member {"agentAssistantRecord"|undefined} record
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @instance
                         */
                        Object.defineProperty(AnswerRecord.prototype, "record", {
                            get: $util.oneOfGetter($oneOfFields = ["agentAssistantRecord"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AnswerRecord instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnswerRecord=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AnswerRecord} AnswerRecord instance
                         */
                        AnswerRecord.create = function create(properties) {
                            return new AnswerRecord(properties);
                        };
    
                        /**
                         * Encodes the specified AnswerRecord message. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerRecord.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnswerRecord} message AnswerRecord message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnswerRecord.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.answerFeedback != null && Object.hasOwnProperty.call(message, "answerFeedback"))
                                $root.google.cloud.dialogflow.v2.AnswerFeedback.encode(message.answerFeedback, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.agentAssistantRecord != null && Object.hasOwnProperty.call(message, "agentAssistantRecord"))
                                $root.google.cloud.dialogflow.v2.AgentAssistantRecord.encode(message.agentAssistantRecord, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnswerRecord message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerRecord.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnswerRecord} message AnswerRecord message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnswerRecord.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnswerRecord message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AnswerRecord} AnswerRecord
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnswerRecord.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AnswerRecord();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                case 2:
                                    message.answerFeedback = $root.google.cloud.dialogflow.v2.AnswerFeedback.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.agentAssistantRecord = $root.google.cloud.dialogflow.v2.AgentAssistantRecord.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnswerRecord message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AnswerRecord} AnswerRecord
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnswerRecord.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnswerRecord message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnswerRecord.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.answerFeedback != null && message.hasOwnProperty("answerFeedback")) {
                                var error = $root.google.cloud.dialogflow.v2.AnswerFeedback.verify(message.answerFeedback);
                                if (error)
                                    return "answerFeedback." + error;
                            }
                            if (message.agentAssistantRecord != null && message.hasOwnProperty("agentAssistantRecord")) {
                                properties.record = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.AgentAssistantRecord.verify(message.agentAssistantRecord);
                                    if (error)
                                        return "agentAssistantRecord." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnswerRecord message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AnswerRecord} AnswerRecord
                         */
                        AnswerRecord.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AnswerRecord)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AnswerRecord();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.answerFeedback != null) {
                                if (typeof object.answerFeedback !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnswerRecord.answerFeedback: object expected");
                                message.answerFeedback = $root.google.cloud.dialogflow.v2.AnswerFeedback.fromObject(object.answerFeedback);
                            }
                            if (object.agentAssistantRecord != null) {
                                if (typeof object.agentAssistantRecord !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnswerRecord.agentAssistantRecord: object expected");
                                message.agentAssistantRecord = $root.google.cloud.dialogflow.v2.AgentAssistantRecord.fromObject(object.agentAssistantRecord);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnswerRecord message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.AnswerRecord} message AnswerRecord
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnswerRecord.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.answerFeedback = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.answerFeedback != null && message.hasOwnProperty("answerFeedback"))
                                object.answerFeedback = $root.google.cloud.dialogflow.v2.AnswerFeedback.toObject(message.answerFeedback, options);
                            if (message.agentAssistantRecord != null && message.hasOwnProperty("agentAssistantRecord")) {
                                object.agentAssistantRecord = $root.google.cloud.dialogflow.v2.AgentAssistantRecord.toObject(message.agentAssistantRecord, options);
                                if (options.oneofs)
                                    object.record = "agentAssistantRecord";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AnswerRecord to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AnswerRecord
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnswerRecord.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return AnswerRecord;
                    })();
    
                    v2.ListAnswerRecordsRequest = (function() {
    
                        /**
                         * Properties of a ListAnswerRecordsRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IListAnswerRecordsRequest
                         * @property {string|null} [parent] ListAnswerRecordsRequest parent
                         * @property {string|null} [filter] ListAnswerRecordsRequest filter
                         * @property {number|null} [pageSize] ListAnswerRecordsRequest pageSize
                         * @property {string|null} [pageToken] ListAnswerRecordsRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListAnswerRecordsRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a ListAnswerRecordsRequest.
                         * @implements IListAnswerRecordsRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsRequest=} [properties] Properties to set
                         */
                        function ListAnswerRecordsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAnswerRecordsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @instance
                         */
                        ListAnswerRecordsRequest.prototype.parent = "";
    
                        /**
                         * ListAnswerRecordsRequest filter.
                         * @member {string} filter
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @instance
                         */
                        ListAnswerRecordsRequest.prototype.filter = "";
    
                        /**
                         * ListAnswerRecordsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @instance
                         */
                        ListAnswerRecordsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListAnswerRecordsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @instance
                         */
                        ListAnswerRecordsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListAnswerRecordsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsRequest} ListAnswerRecordsRequest instance
                         */
                        ListAnswerRecordsRequest.create = function create(properties) {
                            return new ListAnswerRecordsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListAnswerRecordsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsRequest} message ListAnswerRecordsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAnswerRecordsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.filter);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAnswerRecordsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsRequest} message ListAnswerRecordsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAnswerRecordsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAnswerRecordsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsRequest} ListAnswerRecordsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAnswerRecordsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ListAnswerRecordsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.filter = reader.string();
                                    break;
                                case 3:
                                    message.pageSize = reader.int32();
                                    break;
                                case 4:
                                    message.pageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAnswerRecordsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsRequest} ListAnswerRecordsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAnswerRecordsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAnswerRecordsRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAnswerRecordsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAnswerRecordsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsRequest} ListAnswerRecordsRequest
                         */
                        ListAnswerRecordsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ListAnswerRecordsRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ListAnswerRecordsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAnswerRecordsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ListAnswerRecordsRequest} message ListAnswerRecordsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAnswerRecordsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.filter = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.filter != null && message.hasOwnProperty("filter"))
                                object.filter = message.filter;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListAnswerRecordsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAnswerRecordsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ListAnswerRecordsRequest;
                    })();
    
                    v2.ListAnswerRecordsResponse = (function() {
    
                        /**
                         * Properties of a ListAnswerRecordsResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IListAnswerRecordsResponse
                         * @property {Array.<google.cloud.dialogflow.v2.IAnswerRecord>|null} [answerRecords] ListAnswerRecordsResponse answerRecords
                         * @property {string|null} [nextPageToken] ListAnswerRecordsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListAnswerRecordsResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a ListAnswerRecordsResponse.
                         * @implements IListAnswerRecordsResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsResponse=} [properties] Properties to set
                         */
                        function ListAnswerRecordsResponse(properties) {
                            this.answerRecords = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListAnswerRecordsResponse answerRecords.
                         * @member {Array.<google.cloud.dialogflow.v2.IAnswerRecord>} answerRecords
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @instance
                         */
                        ListAnswerRecordsResponse.prototype.answerRecords = $util.emptyArray;
    
                        /**
                         * ListAnswerRecordsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @instance
                         */
                        ListAnswerRecordsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListAnswerRecordsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsResponse} ListAnswerRecordsResponse instance
                         */
                        ListAnswerRecordsResponse.create = function create(properties) {
                            return new ListAnswerRecordsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListAnswerRecordsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsResponse} message ListAnswerRecordsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAnswerRecordsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.answerRecords != null && message.answerRecords.length)
                                for (var i = 0; i < message.answerRecords.length; ++i)
                                    $root.google.cloud.dialogflow.v2.AnswerRecord.encode(message.answerRecords[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListAnswerRecordsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListAnswerRecordsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListAnswerRecordsResponse} message ListAnswerRecordsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAnswerRecordsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListAnswerRecordsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsResponse} ListAnswerRecordsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAnswerRecordsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ListAnswerRecordsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.answerRecords && message.answerRecords.length))
                                        message.answerRecords = [];
                                    message.answerRecords.push($root.google.cloud.dialogflow.v2.AnswerRecord.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.nextPageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListAnswerRecordsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsResponse} ListAnswerRecordsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAnswerRecordsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListAnswerRecordsResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAnswerRecordsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.answerRecords != null && message.hasOwnProperty("answerRecords")) {
                                if (!Array.isArray(message.answerRecords))
                                    return "answerRecords: array expected";
                                for (var i = 0; i < message.answerRecords.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.AnswerRecord.verify(message.answerRecords[i]);
                                    if (error)
                                        return "answerRecords." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListAnswerRecordsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ListAnswerRecordsResponse} ListAnswerRecordsResponse
                         */
                        ListAnswerRecordsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ListAnswerRecordsResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ListAnswerRecordsResponse();
                            if (object.answerRecords) {
                                if (!Array.isArray(object.answerRecords))
                                    throw TypeError(".google.cloud.dialogflow.v2.ListAnswerRecordsResponse.answerRecords: array expected");
                                message.answerRecords = [];
                                for (var i = 0; i < object.answerRecords.length; ++i) {
                                    if (typeof object.answerRecords[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.ListAnswerRecordsResponse.answerRecords: object expected");
                                    message.answerRecords[i] = $root.google.cloud.dialogflow.v2.AnswerRecord.fromObject(object.answerRecords[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListAnswerRecordsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ListAnswerRecordsResponse} message ListAnswerRecordsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAnswerRecordsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.answerRecords = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.answerRecords && message.answerRecords.length) {
                                object.answerRecords = [];
                                for (var j = 0; j < message.answerRecords.length; ++j)
                                    object.answerRecords[j] = $root.google.cloud.dialogflow.v2.AnswerRecord.toObject(message.answerRecords[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListAnswerRecordsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ListAnswerRecordsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAnswerRecordsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ListAnswerRecordsResponse;
                    })();
    
                    v2.UpdateAnswerRecordRequest = (function() {
    
                        /**
                         * Properties of an UpdateAnswerRecordRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IUpdateAnswerRecordRequest
                         * @property {google.cloud.dialogflow.v2.IAnswerRecord|null} [answerRecord] UpdateAnswerRecordRequest answerRecord
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateAnswerRecordRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateAnswerRecordRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an UpdateAnswerRecordRequest.
                         * @implements IUpdateAnswerRecordRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest=} [properties] Properties to set
                         */
                        function UpdateAnswerRecordRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateAnswerRecordRequest answerRecord.
                         * @member {google.cloud.dialogflow.v2.IAnswerRecord|null|undefined} answerRecord
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @instance
                         */
                        UpdateAnswerRecordRequest.prototype.answerRecord = null;
    
                        /**
                         * UpdateAnswerRecordRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @instance
                         */
                        UpdateAnswerRecordRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateAnswerRecordRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.UpdateAnswerRecordRequest} UpdateAnswerRecordRequest instance
                         */
                        UpdateAnswerRecordRequest.create = function create(properties) {
                            return new UpdateAnswerRecordRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateAnswerRecordRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest} message UpdateAnswerRecordRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAnswerRecordRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.answerRecord != null && Object.hasOwnProperty.call(message, "answerRecord"))
                                $root.google.cloud.dialogflow.v2.AnswerRecord.encode(message.answerRecord, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateAnswerRecordRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IUpdateAnswerRecordRequest} message UpdateAnswerRecordRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateAnswerRecordRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateAnswerRecordRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.UpdateAnswerRecordRequest} UpdateAnswerRecordRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAnswerRecordRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.UpdateAnswerRecordRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.answerRecord = $root.google.cloud.dialogflow.v2.AnswerRecord.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateAnswerRecordRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.UpdateAnswerRecordRequest} UpdateAnswerRecordRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateAnswerRecordRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateAnswerRecordRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateAnswerRecordRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord")) {
                                var error = $root.google.cloud.dialogflow.v2.AnswerRecord.verify(message.answerRecord);
                                if (error)
                                    return "answerRecord." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateAnswerRecordRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.UpdateAnswerRecordRequest} UpdateAnswerRecordRequest
                         */
                        UpdateAnswerRecordRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.UpdateAnswerRecordRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.UpdateAnswerRecordRequest();
                            if (object.answerRecord != null) {
                                if (typeof object.answerRecord !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.answerRecord: object expected");
                                message.answerRecord = $root.google.cloud.dialogflow.v2.AnswerRecord.fromObject(object.answerRecord);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateAnswerRecordRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.UpdateAnswerRecordRequest} message UpdateAnswerRecordRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateAnswerRecordRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.answerRecord = null;
                                object.updateMask = null;
                            }
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord"))
                                object.answerRecord = $root.google.cloud.dialogflow.v2.AnswerRecord.toObject(message.answerRecord, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateAnswerRecordRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateAnswerRecordRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return UpdateAnswerRecordRequest;
                    })();
    
                    v2.AnswerFeedback = (function() {
    
                        /**
                         * Properties of an AnswerFeedback.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAnswerFeedback
                         * @property {google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel|null} [correctnessLevel] AnswerFeedback correctnessLevel
                         * @property {google.cloud.dialogflow.v2.IAgentAssistantFeedback|null} [agentAssistantDetailFeedback] AnswerFeedback agentAssistantDetailFeedback
                         * @property {boolean|null} [clicked] AnswerFeedback clicked
                         * @property {google.protobuf.ITimestamp|null} [clickTime] AnswerFeedback clickTime
                         * @property {boolean|null} [displayed] AnswerFeedback displayed
                         * @property {google.protobuf.ITimestamp|null} [displayTime] AnswerFeedback displayTime
                         */
    
                        /**
                         * Constructs a new AnswerFeedback.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AnswerFeedback.
                         * @implements IAnswerFeedback
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAnswerFeedback=} [properties] Properties to set
                         */
                        function AnswerFeedback(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnswerFeedback correctnessLevel.
                         * @member {google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel} correctnessLevel
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         */
                        AnswerFeedback.prototype.correctnessLevel = 0;
    
                        /**
                         * AnswerFeedback agentAssistantDetailFeedback.
                         * @member {google.cloud.dialogflow.v2.IAgentAssistantFeedback|null|undefined} agentAssistantDetailFeedback
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         */
                        AnswerFeedback.prototype.agentAssistantDetailFeedback = null;
    
                        /**
                         * AnswerFeedback clicked.
                         * @member {boolean} clicked
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         */
                        AnswerFeedback.prototype.clicked = false;
    
                        /**
                         * AnswerFeedback clickTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} clickTime
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         */
                        AnswerFeedback.prototype.clickTime = null;
    
                        /**
                         * AnswerFeedback displayed.
                         * @member {boolean} displayed
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         */
                        AnswerFeedback.prototype.displayed = false;
    
                        /**
                         * AnswerFeedback displayTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} displayTime
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         */
                        AnswerFeedback.prototype.displayTime = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AnswerFeedback detailFeedback.
                         * @member {"agentAssistantDetailFeedback"|undefined} detailFeedback
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         */
                        Object.defineProperty(AnswerFeedback.prototype, "detailFeedback", {
                            get: $util.oneOfGetter($oneOfFields = ["agentAssistantDetailFeedback"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AnswerFeedback instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnswerFeedback=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AnswerFeedback} AnswerFeedback instance
                         */
                        AnswerFeedback.create = function create(properties) {
                            return new AnswerFeedback(properties);
                        };
    
                        /**
                         * Encodes the specified AnswerFeedback message. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerFeedback.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnswerFeedback} message AnswerFeedback message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnswerFeedback.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.correctnessLevel != null && Object.hasOwnProperty.call(message, "correctnessLevel"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.correctnessLevel);
                            if (message.agentAssistantDetailFeedback != null && Object.hasOwnProperty.call(message, "agentAssistantDetailFeedback"))
                                $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.encode(message.agentAssistantDetailFeedback, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.clicked != null && Object.hasOwnProperty.call(message, "clicked"))
                                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.clicked);
                            if (message.displayed != null && Object.hasOwnProperty.call(message, "displayed"))
                                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.displayed);
                            if (message.clickTime != null && Object.hasOwnProperty.call(message, "clickTime"))
                                $root.google.protobuf.Timestamp.encode(message.clickTime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.displayTime != null && Object.hasOwnProperty.call(message, "displayTime"))
                                $root.google.protobuf.Timestamp.encode(message.displayTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnswerFeedback message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnswerFeedback.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnswerFeedback} message AnswerFeedback message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnswerFeedback.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnswerFeedback message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AnswerFeedback} AnswerFeedback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnswerFeedback.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AnswerFeedback();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.correctnessLevel = reader.int32();
                                    break;
                                case 2:
                                    message.agentAssistantDetailFeedback = $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.clicked = reader.bool();
                                    break;
                                case 5:
                                    message.clickTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.displayed = reader.bool();
                                    break;
                                case 6:
                                    message.displayTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnswerFeedback message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AnswerFeedback} AnswerFeedback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnswerFeedback.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnswerFeedback message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnswerFeedback.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.correctnessLevel != null && message.hasOwnProperty("correctnessLevel"))
                                switch (message.correctnessLevel) {
                                default:
                                    return "correctnessLevel: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.agentAssistantDetailFeedback != null && message.hasOwnProperty("agentAssistantDetailFeedback")) {
                                properties.detailFeedback = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.verify(message.agentAssistantDetailFeedback);
                                    if (error)
                                        return "agentAssistantDetailFeedback." + error;
                                }
                            }
                            if (message.clicked != null && message.hasOwnProperty("clicked"))
                                if (typeof message.clicked !== "boolean")
                                    return "clicked: boolean expected";
                            if (message.clickTime != null && message.hasOwnProperty("clickTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.clickTime);
                                if (error)
                                    return "clickTime." + error;
                            }
                            if (message.displayed != null && message.hasOwnProperty("displayed"))
                                if (typeof message.displayed !== "boolean")
                                    return "displayed: boolean expected";
                            if (message.displayTime != null && message.hasOwnProperty("displayTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.displayTime);
                                if (error)
                                    return "displayTime." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnswerFeedback message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AnswerFeedback} AnswerFeedback
                         */
                        AnswerFeedback.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AnswerFeedback)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AnswerFeedback();
                            switch (object.correctnessLevel) {
                            case "CORRECTNESS_LEVEL_UNSPECIFIED":
                            case 0:
                                message.correctnessLevel = 0;
                                break;
                            case "NOT_CORRECT":
                            case 1:
                                message.correctnessLevel = 1;
                                break;
                            case "PARTIALLY_CORRECT":
                            case 2:
                                message.correctnessLevel = 2;
                                break;
                            case "FULLY_CORRECT":
                            case 3:
                                message.correctnessLevel = 3;
                                break;
                            }
                            if (object.agentAssistantDetailFeedback != null) {
                                if (typeof object.agentAssistantDetailFeedback !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnswerFeedback.agentAssistantDetailFeedback: object expected");
                                message.agentAssistantDetailFeedback = $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.fromObject(object.agentAssistantDetailFeedback);
                            }
                            if (object.clicked != null)
                                message.clicked = Boolean(object.clicked);
                            if (object.clickTime != null) {
                                if (typeof object.clickTime !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnswerFeedback.clickTime: object expected");
                                message.clickTime = $root.google.protobuf.Timestamp.fromObject(object.clickTime);
                            }
                            if (object.displayed != null)
                                message.displayed = Boolean(object.displayed);
                            if (object.displayTime != null) {
                                if (typeof object.displayTime !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnswerFeedback.displayTime: object expected");
                                message.displayTime = $root.google.protobuf.Timestamp.fromObject(object.displayTime);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnswerFeedback message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.AnswerFeedback} message AnswerFeedback
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnswerFeedback.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.correctnessLevel = options.enums === String ? "CORRECTNESS_LEVEL_UNSPECIFIED" : 0;
                                object.clicked = false;
                                object.displayed = false;
                                object.clickTime = null;
                                object.displayTime = null;
                            }
                            if (message.correctnessLevel != null && message.hasOwnProperty("correctnessLevel"))
                                object.correctnessLevel = options.enums === String ? $root.google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel[message.correctnessLevel] : message.correctnessLevel;
                            if (message.agentAssistantDetailFeedback != null && message.hasOwnProperty("agentAssistantDetailFeedback")) {
                                object.agentAssistantDetailFeedback = $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.toObject(message.agentAssistantDetailFeedback, options);
                                if (options.oneofs)
                                    object.detailFeedback = "agentAssistantDetailFeedback";
                            }
                            if (message.clicked != null && message.hasOwnProperty("clicked"))
                                object.clicked = message.clicked;
                            if (message.displayed != null && message.hasOwnProperty("displayed"))
                                object.displayed = message.displayed;
                            if (message.clickTime != null && message.hasOwnProperty("clickTime"))
                                object.clickTime = $root.google.protobuf.Timestamp.toObject(message.clickTime, options);
                            if (message.displayTime != null && message.hasOwnProperty("displayTime"))
                                object.displayTime = $root.google.protobuf.Timestamp.toObject(message.displayTime, options);
                            return object;
                        };
    
                        /**
                         * Converts this AnswerFeedback to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AnswerFeedback
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnswerFeedback.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * CorrectnessLevel enum.
                         * @name google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel
                         * @enum {number}
                         * @property {number} CORRECTNESS_LEVEL_UNSPECIFIED=0 CORRECTNESS_LEVEL_UNSPECIFIED value
                         * @property {number} NOT_CORRECT=1 NOT_CORRECT value
                         * @property {number} PARTIALLY_CORRECT=2 PARTIALLY_CORRECT value
                         * @property {number} FULLY_CORRECT=3 FULLY_CORRECT value
                         */
                        AnswerFeedback.CorrectnessLevel = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "CORRECTNESS_LEVEL_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "NOT_CORRECT"] = 1;
                            values[valuesById[2] = "PARTIALLY_CORRECT"] = 2;
                            values[valuesById[3] = "FULLY_CORRECT"] = 3;
                            return values;
                        })();
    
                        return AnswerFeedback;
                    })();
    
                    v2.AgentAssistantFeedback = (function() {
    
                        /**
                         * Properties of an AgentAssistantFeedback.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAgentAssistantFeedback
                         * @property {google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance|null} [answerRelevance] AgentAssistantFeedback answerRelevance
                         * @property {google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness|null} [documentCorrectness] AgentAssistantFeedback documentCorrectness
                         * @property {google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency|null} [documentEfficiency] AgentAssistantFeedback documentEfficiency
                         */
    
                        /**
                         * Constructs a new AgentAssistantFeedback.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AgentAssistantFeedback.
                         * @implements IAgentAssistantFeedback
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantFeedback=} [properties] Properties to set
                         */
                        function AgentAssistantFeedback(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AgentAssistantFeedback answerRelevance.
                         * @member {google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance} answerRelevance
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @instance
                         */
                        AgentAssistantFeedback.prototype.answerRelevance = 0;
    
                        /**
                         * AgentAssistantFeedback documentCorrectness.
                         * @member {google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness} documentCorrectness
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @instance
                         */
                        AgentAssistantFeedback.prototype.documentCorrectness = 0;
    
                        /**
                         * AgentAssistantFeedback documentEfficiency.
                         * @member {google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency} documentEfficiency
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @instance
                         */
                        AgentAssistantFeedback.prototype.documentEfficiency = 0;
    
                        /**
                         * Creates a new AgentAssistantFeedback instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantFeedback=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantFeedback} AgentAssistantFeedback instance
                         */
                        AgentAssistantFeedback.create = function create(properties) {
                            return new AgentAssistantFeedback(properties);
                        };
    
                        /**
                         * Encodes the specified AgentAssistantFeedback message. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantFeedback.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantFeedback} message AgentAssistantFeedback message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AgentAssistantFeedback.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.answerRelevance != null && Object.hasOwnProperty.call(message, "answerRelevance"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.answerRelevance);
                            if (message.documentCorrectness != null && Object.hasOwnProperty.call(message, "documentCorrectness"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.documentCorrectness);
                            if (message.documentEfficiency != null && Object.hasOwnProperty.call(message, "documentEfficiency"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.documentEfficiency);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AgentAssistantFeedback message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantFeedback.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantFeedback} message AgentAssistantFeedback message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AgentAssistantFeedback.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AgentAssistantFeedback message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantFeedback} AgentAssistantFeedback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AgentAssistantFeedback.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AgentAssistantFeedback();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.answerRelevance = reader.int32();
                                    break;
                                case 2:
                                    message.documentCorrectness = reader.int32();
                                    break;
                                case 3:
                                    message.documentEfficiency = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AgentAssistantFeedback message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantFeedback} AgentAssistantFeedback
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AgentAssistantFeedback.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AgentAssistantFeedback message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AgentAssistantFeedback.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.answerRelevance != null && message.hasOwnProperty("answerRelevance"))
                                switch (message.answerRelevance) {
                                default:
                                    return "answerRelevance: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.documentCorrectness != null && message.hasOwnProperty("documentCorrectness"))
                                switch (message.documentCorrectness) {
                                default:
                                    return "documentCorrectness: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.documentEfficiency != null && message.hasOwnProperty("documentEfficiency"))
                                switch (message.documentEfficiency) {
                                default:
                                    return "documentEfficiency: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates an AgentAssistantFeedback message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantFeedback} AgentAssistantFeedback
                         */
                        AgentAssistantFeedback.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AgentAssistantFeedback)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AgentAssistantFeedback();
                            switch (object.answerRelevance) {
                            case "ANSWER_RELEVANCE_UNSPECIFIED":
                            case 0:
                                message.answerRelevance = 0;
                                break;
                            case "IRRELEVANT":
                            case 1:
                                message.answerRelevance = 1;
                                break;
                            case "RELEVANT":
                            case 2:
                                message.answerRelevance = 2;
                                break;
                            }
                            switch (object.documentCorrectness) {
                            case "DOCUMENT_CORRECTNESS_UNSPECIFIED":
                            case 0:
                                message.documentCorrectness = 0;
                                break;
                            case "INCORRECT":
                            case 1:
                                message.documentCorrectness = 1;
                                break;
                            case "CORRECT":
                            case 2:
                                message.documentCorrectness = 2;
                                break;
                            }
                            switch (object.documentEfficiency) {
                            case "DOCUMENT_EFFICIENCY_UNSPECIFIED":
                            case 0:
                                message.documentEfficiency = 0;
                                break;
                            case "INEFFICIENT":
                            case 1:
                                message.documentEfficiency = 1;
                                break;
                            case "EFFICIENT":
                            case 2:
                                message.documentEfficiency = 2;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AgentAssistantFeedback message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @static
                         * @param {google.cloud.dialogflow.v2.AgentAssistantFeedback} message AgentAssistantFeedback
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AgentAssistantFeedback.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.answerRelevance = options.enums === String ? "ANSWER_RELEVANCE_UNSPECIFIED" : 0;
                                object.documentCorrectness = options.enums === String ? "DOCUMENT_CORRECTNESS_UNSPECIFIED" : 0;
                                object.documentEfficiency = options.enums === String ? "DOCUMENT_EFFICIENCY_UNSPECIFIED" : 0;
                            }
                            if (message.answerRelevance != null && message.hasOwnProperty("answerRelevance"))
                                object.answerRelevance = options.enums === String ? $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance[message.answerRelevance] : message.answerRelevance;
                            if (message.documentCorrectness != null && message.hasOwnProperty("documentCorrectness"))
                                object.documentCorrectness = options.enums === String ? $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness[message.documentCorrectness] : message.documentCorrectness;
                            if (message.documentEfficiency != null && message.hasOwnProperty("documentEfficiency"))
                                object.documentEfficiency = options.enums === String ? $root.google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency[message.documentEfficiency] : message.documentEfficiency;
                            return object;
                        };
    
                        /**
                         * Converts this AgentAssistantFeedback to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantFeedback
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AgentAssistantFeedback.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * AnswerRelevance enum.
                         * @name google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance
                         * @enum {number}
                         * @property {number} ANSWER_RELEVANCE_UNSPECIFIED=0 ANSWER_RELEVANCE_UNSPECIFIED value
                         * @property {number} IRRELEVANT=1 IRRELEVANT value
                         * @property {number} RELEVANT=2 RELEVANT value
                         */
                        AgentAssistantFeedback.AnswerRelevance = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "ANSWER_RELEVANCE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "IRRELEVANT"] = 1;
                            values[valuesById[2] = "RELEVANT"] = 2;
                            return values;
                        })();
    
                        /**
                         * DocumentCorrectness enum.
                         * @name google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness
                         * @enum {number}
                         * @property {number} DOCUMENT_CORRECTNESS_UNSPECIFIED=0 DOCUMENT_CORRECTNESS_UNSPECIFIED value
                         * @property {number} INCORRECT=1 INCORRECT value
                         * @property {number} CORRECT=2 CORRECT value
                         */
                        AgentAssistantFeedback.DocumentCorrectness = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "DOCUMENT_CORRECTNESS_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "INCORRECT"] = 1;
                            values[valuesById[2] = "CORRECT"] = 2;
                            return values;
                        })();
    
                        /**
                         * DocumentEfficiency enum.
                         * @name google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency
                         * @enum {number}
                         * @property {number} DOCUMENT_EFFICIENCY_UNSPECIFIED=0 DOCUMENT_EFFICIENCY_UNSPECIFIED value
                         * @property {number} INEFFICIENT=1 INEFFICIENT value
                         * @property {number} EFFICIENT=2 EFFICIENT value
                         */
                        AgentAssistantFeedback.DocumentEfficiency = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "DOCUMENT_EFFICIENCY_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "INEFFICIENT"] = 1;
                            values[valuesById[2] = "EFFICIENT"] = 2;
                            return values;
                        })();
    
                        return AgentAssistantFeedback;
                    })();
    
                    v2.AgentAssistantRecord = (function() {
    
                        /**
                         * Properties of an AgentAssistantRecord.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAgentAssistantRecord
                         * @property {google.cloud.dialogflow.v2.IArticleAnswer|null} [articleSuggestionAnswer] AgentAssistantRecord articleSuggestionAnswer
                         * @property {google.cloud.dialogflow.v2.IFaqAnswer|null} [faqAnswer] AgentAssistantRecord faqAnswer
                         */
    
                        /**
                         * Constructs a new AgentAssistantRecord.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AgentAssistantRecord.
                         * @implements IAgentAssistantRecord
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantRecord=} [properties] Properties to set
                         */
                        function AgentAssistantRecord(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AgentAssistantRecord articleSuggestionAnswer.
                         * @member {google.cloud.dialogflow.v2.IArticleAnswer|null|undefined} articleSuggestionAnswer
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @instance
                         */
                        AgentAssistantRecord.prototype.articleSuggestionAnswer = null;
    
                        /**
                         * AgentAssistantRecord faqAnswer.
                         * @member {google.cloud.dialogflow.v2.IFaqAnswer|null|undefined} faqAnswer
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @instance
                         */
                        AgentAssistantRecord.prototype.faqAnswer = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AgentAssistantRecord answer.
                         * @member {"articleSuggestionAnswer"|"faqAnswer"|undefined} answer
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @instance
                         */
                        Object.defineProperty(AgentAssistantRecord.prototype, "answer", {
                            get: $util.oneOfGetter($oneOfFields = ["articleSuggestionAnswer", "faqAnswer"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AgentAssistantRecord instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantRecord=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantRecord} AgentAssistantRecord instance
                         */
                        AgentAssistantRecord.create = function create(properties) {
                            return new AgentAssistantRecord(properties);
                        };
    
                        /**
                         * Encodes the specified AgentAssistantRecord message. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantRecord.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantRecord} message AgentAssistantRecord message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AgentAssistantRecord.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.articleSuggestionAnswer != null && Object.hasOwnProperty.call(message, "articleSuggestionAnswer"))
                                $root.google.cloud.dialogflow.v2.ArticleAnswer.encode(message.articleSuggestionAnswer, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.faqAnswer != null && Object.hasOwnProperty.call(message, "faqAnswer"))
                                $root.google.cloud.dialogflow.v2.FaqAnswer.encode(message.faqAnswer, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AgentAssistantRecord message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AgentAssistantRecord.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAgentAssistantRecord} message AgentAssistantRecord message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AgentAssistantRecord.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AgentAssistantRecord message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantRecord} AgentAssistantRecord
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AgentAssistantRecord.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AgentAssistantRecord();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 5:
                                    message.articleSuggestionAnswer = $root.google.cloud.dialogflow.v2.ArticleAnswer.decode(reader, reader.uint32());
                                    break;
                                case 6:
                                    message.faqAnswer = $root.google.cloud.dialogflow.v2.FaqAnswer.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AgentAssistantRecord message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantRecord} AgentAssistantRecord
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AgentAssistantRecord.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AgentAssistantRecord message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AgentAssistantRecord.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.articleSuggestionAnswer != null && message.hasOwnProperty("articleSuggestionAnswer")) {
                                properties.answer = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.ArticleAnswer.verify(message.articleSuggestionAnswer);
                                    if (error)
                                        return "articleSuggestionAnswer." + error;
                                }
                            }
                            if (message.faqAnswer != null && message.hasOwnProperty("faqAnswer")) {
                                if (properties.answer === 1)
                                    return "answer: multiple values";
                                properties.answer = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.FaqAnswer.verify(message.faqAnswer);
                                    if (error)
                                        return "faqAnswer." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AgentAssistantRecord message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AgentAssistantRecord} AgentAssistantRecord
                         */
                        AgentAssistantRecord.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AgentAssistantRecord)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AgentAssistantRecord();
                            if (object.articleSuggestionAnswer != null) {
                                if (typeof object.articleSuggestionAnswer !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AgentAssistantRecord.articleSuggestionAnswer: object expected");
                                message.articleSuggestionAnswer = $root.google.cloud.dialogflow.v2.ArticleAnswer.fromObject(object.articleSuggestionAnswer);
                            }
                            if (object.faqAnswer != null) {
                                if (typeof object.faqAnswer !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AgentAssistantRecord.faqAnswer: object expected");
                                message.faqAnswer = $root.google.cloud.dialogflow.v2.FaqAnswer.fromObject(object.faqAnswer);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AgentAssistantRecord message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @static
                         * @param {google.cloud.dialogflow.v2.AgentAssistantRecord} message AgentAssistantRecord
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AgentAssistantRecord.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.articleSuggestionAnswer != null && message.hasOwnProperty("articleSuggestionAnswer")) {
                                object.articleSuggestionAnswer = $root.google.cloud.dialogflow.v2.ArticleAnswer.toObject(message.articleSuggestionAnswer, options);
                                if (options.oneofs)
                                    object.answer = "articleSuggestionAnswer";
                            }
                            if (message.faqAnswer != null && message.hasOwnProperty("faqAnswer")) {
                                object.faqAnswer = $root.google.cloud.dialogflow.v2.FaqAnswer.toObject(message.faqAnswer, options);
                                if (options.oneofs)
                                    object.answer = "faqAnswer";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AgentAssistantRecord to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AgentAssistantRecord
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AgentAssistantRecord.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return AgentAssistantRecord;
                    })();
    
                    v2.Participants = (function() {
    
                        /**
                         * Constructs a new Participants service.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a Participants
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Participants(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (Participants.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Participants;
    
                        /**
                         * Creates new Participants service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Participants} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Participants.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#createParticipant}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef CreateParticipantCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.Participant} [response] Participant
                         */
    
                        /**
                         * Calls CreateParticipant.
                         * @function createParticipant
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ICreateParticipantRequest} request CreateParticipantRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.CreateParticipantCallback} callback Node-style callback called with the error, if any, and Participant
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.createParticipant = function createParticipant(request, callback) {
                            return this.rpcCall(createParticipant, $root.google.cloud.dialogflow.v2.CreateParticipantRequest, $root.google.cloud.dialogflow.v2.Participant, request, callback);
                        }, "name", { value: "CreateParticipant" });
    
                        /**
                         * Calls CreateParticipant.
                         * @function createParticipant
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ICreateParticipantRequest} request CreateParticipantRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.Participant>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#getParticipant}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef GetParticipantCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.Participant} [response] Participant
                         */
    
                        /**
                         * Calls GetParticipant.
                         * @function getParticipant
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IGetParticipantRequest} request GetParticipantRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.GetParticipantCallback} callback Node-style callback called with the error, if any, and Participant
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.getParticipant = function getParticipant(request, callback) {
                            return this.rpcCall(getParticipant, $root.google.cloud.dialogflow.v2.GetParticipantRequest, $root.google.cloud.dialogflow.v2.Participant, request, callback);
                        }, "name", { value: "GetParticipant" });
    
                        /**
                         * Calls GetParticipant.
                         * @function getParticipant
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IGetParticipantRequest} request GetParticipantRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.Participant>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#listParticipants}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef ListParticipantsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.ListParticipantsResponse} [response] ListParticipantsResponse
                         */
    
                        /**
                         * Calls ListParticipants.
                         * @function listParticipants
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IListParticipantsRequest} request ListParticipantsRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.ListParticipantsCallback} callback Node-style callback called with the error, if any, and ListParticipantsResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.listParticipants = function listParticipants(request, callback) {
                            return this.rpcCall(listParticipants, $root.google.cloud.dialogflow.v2.ListParticipantsRequest, $root.google.cloud.dialogflow.v2.ListParticipantsResponse, request, callback);
                        }, "name", { value: "ListParticipants" });
    
                        /**
                         * Calls ListParticipants.
                         * @function listParticipants
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IListParticipantsRequest} request ListParticipantsRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.ListParticipantsResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#updateParticipant}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef UpdateParticipantCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.Participant} [response] Participant
                         */
    
                        /**
                         * Calls UpdateParticipant.
                         * @function updateParticipant
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IUpdateParticipantRequest} request UpdateParticipantRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.UpdateParticipantCallback} callback Node-style callback called with the error, if any, and Participant
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.updateParticipant = function updateParticipant(request, callback) {
                            return this.rpcCall(updateParticipant, $root.google.cloud.dialogflow.v2.UpdateParticipantRequest, $root.google.cloud.dialogflow.v2.Participant, request, callback);
                        }, "name", { value: "UpdateParticipant" });
    
                        /**
                         * Calls UpdateParticipant.
                         * @function updateParticipant
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IUpdateParticipantRequest} request UpdateParticipantRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.Participant>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#analyzeContent}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef AnalyzeContentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.AnalyzeContentResponse} [response] AnalyzeContentResponse
                         */
    
                        /**
                         * Calls AnalyzeContent.
                         * @function analyzeContent
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentRequest} request AnalyzeContentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.AnalyzeContentCallback} callback Node-style callback called with the error, if any, and AnalyzeContentResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.analyzeContent = function analyzeContent(request, callback) {
                            return this.rpcCall(analyzeContent, $root.google.cloud.dialogflow.v2.AnalyzeContentRequest, $root.google.cloud.dialogflow.v2.AnalyzeContentResponse, request, callback);
                        }, "name", { value: "AnalyzeContent" });
    
                        /**
                         * Calls AnalyzeContent.
                         * @function analyzeContent
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentRequest} request AnalyzeContentRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.AnalyzeContentResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#suggestArticles}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef SuggestArticlesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.SuggestArticlesResponse} [response] SuggestArticlesResponse
                         */
    
                        /**
                         * Calls SuggestArticles.
                         * @function suggestArticles
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesRequest} request SuggestArticlesRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.SuggestArticlesCallback} callback Node-style callback called with the error, if any, and SuggestArticlesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.suggestArticles = function suggestArticles(request, callback) {
                            return this.rpcCall(suggestArticles, $root.google.cloud.dialogflow.v2.SuggestArticlesRequest, $root.google.cloud.dialogflow.v2.SuggestArticlesResponse, request, callback);
                        }, "name", { value: "SuggestArticles" });
    
                        /**
                         * Calls SuggestArticles.
                         * @function suggestArticles
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesRequest} request SuggestArticlesRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.SuggestArticlesResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#suggestFaqAnswers}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef SuggestFaqAnswersCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.SuggestFaqAnswersResponse} [response] SuggestFaqAnswersResponse
                         */
    
                        /**
                         * Calls SuggestFaqAnswers.
                         * @function suggestFaqAnswers
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest} request SuggestFaqAnswersRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.SuggestFaqAnswersCallback} callback Node-style callback called with the error, if any, and SuggestFaqAnswersResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.suggestFaqAnswers = function suggestFaqAnswers(request, callback) {
                            return this.rpcCall(suggestFaqAnswers, $root.google.cloud.dialogflow.v2.SuggestFaqAnswersRequest, $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse, request, callback);
                        }, "name", { value: "SuggestFaqAnswers" });
    
                        /**
                         * Calls SuggestFaqAnswers.
                         * @function suggestFaqAnswers
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest} request SuggestFaqAnswersRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.SuggestFaqAnswersResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Participants#suggestSmartReplies}.
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @typedef SuggestSmartRepliesCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.SuggestSmartRepliesResponse} [response] SuggestSmartRepliesResponse
                         */
    
                        /**
                         * Calls SuggestSmartReplies.
                         * @function suggestSmartReplies
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest} request SuggestSmartRepliesRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Participants.SuggestSmartRepliesCallback} callback Node-style callback called with the error, if any, and SuggestSmartRepliesResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Participants.prototype.suggestSmartReplies = function suggestSmartReplies(request, callback) {
                            return this.rpcCall(suggestSmartReplies, $root.google.cloud.dialogflow.v2.SuggestSmartRepliesRequest, $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse, request, callback);
                        }, "name", { value: "SuggestSmartReplies" });
    
                        /**
                         * Calls SuggestSmartReplies.
                         * @function suggestSmartReplies
                         * @memberof google.cloud.dialogflow.v2.Participants
                         * @instance
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest} request SuggestSmartRepliesRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.SuggestSmartRepliesResponse>} Promise
                         * @variation 2
                         */
    
                        return Participants;
                    })();
    
                    v2.Participant = (function() {
    
                        /**
                         * Properties of a Participant.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IParticipant
                         * @property {string|null} [name] Participant name
                         * @property {google.cloud.dialogflow.v2.Participant.Role|null} [role] Participant role
                         * @property {string|null} [sipRecordingMediaLabel] Participant sipRecordingMediaLabel
                         * @property {Object.<string,string>|null} [documentsMetadataFilters] Participant documentsMetadataFilters
                         */
    
                        /**
                         * Constructs a new Participant.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a Participant.
                         * @implements IParticipant
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IParticipant=} [properties] Properties to set
                         */
                        function Participant(properties) {
                            this.documentsMetadataFilters = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Participant name.
                         * @member {string} name
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @instance
                         */
                        Participant.prototype.name = "";
    
                        /**
                         * Participant role.
                         * @member {google.cloud.dialogflow.v2.Participant.Role} role
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @instance
                         */
                        Participant.prototype.role = 0;
    
                        /**
                         * Participant sipRecordingMediaLabel.
                         * @member {string} sipRecordingMediaLabel
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @instance
                         */
                        Participant.prototype.sipRecordingMediaLabel = "";
    
                        /**
                         * Participant documentsMetadataFilters.
                         * @member {Object.<string,string>} documentsMetadataFilters
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @instance
                         */
                        Participant.prototype.documentsMetadataFilters = $util.emptyObject;
    
                        /**
                         * Creates a new Participant instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {google.cloud.dialogflow.v2.IParticipant=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.Participant} Participant instance
                         */
                        Participant.create = function create(properties) {
                            return new Participant(properties);
                        };
    
                        /**
                         * Encodes the specified Participant message. Does not implicitly {@link google.cloud.dialogflow.v2.Participant.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {google.cloud.dialogflow.v2.IParticipant} message Participant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Participant.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.role != null && Object.hasOwnProperty.call(message, "role"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.role);
                            if (message.sipRecordingMediaLabel != null && Object.hasOwnProperty.call(message, "sipRecordingMediaLabel"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.sipRecordingMediaLabel);
                            if (message.documentsMetadataFilters != null && Object.hasOwnProperty.call(message, "documentsMetadataFilters"))
                                for (var keys = Object.keys(message.documentsMetadataFilters), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 8, wireType 2 =*/66).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.documentsMetadataFilters[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Participant message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Participant.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {google.cloud.dialogflow.v2.IParticipant} message Participant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Participant.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Participant message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.Participant} Participant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Participant.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.Participant(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                case 2:
                                    message.role = reader.int32();
                                    break;
                                case 6:
                                    message.sipRecordingMediaLabel = reader.string();
                                    break;
                                case 8:
                                    if (message.documentsMetadataFilters === $util.emptyObject)
                                        message.documentsMetadataFilters = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.documentsMetadataFilters[key] = value;
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Participant message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.Participant} Participant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Participant.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Participant message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Participant.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.role != null && message.hasOwnProperty("role"))
                                switch (message.role) {
                                default:
                                    return "role: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.sipRecordingMediaLabel != null && message.hasOwnProperty("sipRecordingMediaLabel"))
                                if (!$util.isString(message.sipRecordingMediaLabel))
                                    return "sipRecordingMediaLabel: string expected";
                            if (message.documentsMetadataFilters != null && message.hasOwnProperty("documentsMetadataFilters")) {
                                if (!$util.isObject(message.documentsMetadataFilters))
                                    return "documentsMetadataFilters: object expected";
                                var key = Object.keys(message.documentsMetadataFilters);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.documentsMetadataFilters[key[i]]))
                                        return "documentsMetadataFilters: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Participant message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.Participant} Participant
                         */
                        Participant.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.Participant)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.Participant();
                            if (object.name != null)
                                message.name = String(object.name);
                            switch (object.role) {
                            case "ROLE_UNSPECIFIED":
                            case 0:
                                message.role = 0;
                                break;
                            case "HUMAN_AGENT":
                            case 1:
                                message.role = 1;
                                break;
                            case "AUTOMATED_AGENT":
                            case 2:
                                message.role = 2;
                                break;
                            case "END_USER":
                            case 3:
                                message.role = 3;
                                break;
                            }
                            if (object.sipRecordingMediaLabel != null)
                                message.sipRecordingMediaLabel = String(object.sipRecordingMediaLabel);
                            if (object.documentsMetadataFilters) {
                                if (typeof object.documentsMetadataFilters !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.Participant.documentsMetadataFilters: object expected");
                                message.documentsMetadataFilters = {};
                                for (var keys = Object.keys(object.documentsMetadataFilters), i = 0; i < keys.length; ++i)
                                    message.documentsMetadataFilters[keys[i]] = String(object.documentsMetadataFilters[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Participant message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @static
                         * @param {google.cloud.dialogflow.v2.Participant} message Participant
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Participant.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.documentsMetadataFilters = {};
                            if (options.defaults) {
                                object.name = "";
                                object.role = options.enums === String ? "ROLE_UNSPECIFIED" : 0;
                                object.sipRecordingMediaLabel = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.role != null && message.hasOwnProperty("role"))
                                object.role = options.enums === String ? $root.google.cloud.dialogflow.v2.Participant.Role[message.role] : message.role;
                            if (message.sipRecordingMediaLabel != null && message.hasOwnProperty("sipRecordingMediaLabel"))
                                object.sipRecordingMediaLabel = message.sipRecordingMediaLabel;
                            var keys2;
                            if (message.documentsMetadataFilters && (keys2 = Object.keys(message.documentsMetadataFilters)).length) {
                                object.documentsMetadataFilters = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.documentsMetadataFilters[keys2[j]] = message.documentsMetadataFilters[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this Participant to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.Participant
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Participant.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Role enum.
                         * @name google.cloud.dialogflow.v2.Participant.Role
                         * @enum {number}
                         * @property {number} ROLE_UNSPECIFIED=0 ROLE_UNSPECIFIED value
                         * @property {number} HUMAN_AGENT=1 HUMAN_AGENT value
                         * @property {number} AUTOMATED_AGENT=2 AUTOMATED_AGENT value
                         * @property {number} END_USER=3 END_USER value
                         */
                        Participant.Role = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "ROLE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "HUMAN_AGENT"] = 1;
                            values[valuesById[2] = "AUTOMATED_AGENT"] = 2;
                            values[valuesById[3] = "END_USER"] = 3;
                            return values;
                        })();
    
                        return Participant;
                    })();
    
                    v2.Message = (function() {
    
                        /**
                         * Properties of a Message.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IMessage
                         * @property {string|null} [name] Message name
                         * @property {string|null} [content] Message content
                         * @property {string|null} [languageCode] Message languageCode
                         * @property {string|null} [participant] Message participant
                         * @property {google.cloud.dialogflow.v2.Participant.Role|null} [participantRole] Message participantRole
                         * @property {google.protobuf.ITimestamp|null} [createTime] Message createTime
                         * @property {google.protobuf.ITimestamp|null} [sendTime] Message sendTime
                         * @property {google.cloud.dialogflow.v2.IMessageAnnotation|null} [messageAnnotation] Message messageAnnotation
                         * @property {google.cloud.dialogflow.v2.ISentimentAnalysisResult|null} [sentimentAnalysis] Message sentimentAnalysis
                         */
    
                        /**
                         * Constructs a new Message.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a Message.
                         * @implements IMessage
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IMessage=} [properties] Properties to set
                         */
                        function Message(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Message name.
                         * @member {string} name
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.name = "";
    
                        /**
                         * Message content.
                         * @member {string} content
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.content = "";
    
                        /**
                         * Message languageCode.
                         * @member {string} languageCode
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.languageCode = "";
    
                        /**
                         * Message participant.
                         * @member {string} participant
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.participant = "";
    
                        /**
                         * Message participantRole.
                         * @member {google.cloud.dialogflow.v2.Participant.Role} participantRole
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.participantRole = 0;
    
                        /**
                         * Message createTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} createTime
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.createTime = null;
    
                        /**
                         * Message sendTime.
                         * @member {google.protobuf.ITimestamp|null|undefined} sendTime
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.sendTime = null;
    
                        /**
                         * Message messageAnnotation.
                         * @member {google.cloud.dialogflow.v2.IMessageAnnotation|null|undefined} messageAnnotation
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.messageAnnotation = null;
    
                        /**
                         * Message sentimentAnalysis.
                         * @member {google.cloud.dialogflow.v2.ISentimentAnalysisResult|null|undefined} sentimentAnalysis
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         */
                        Message.prototype.sentimentAnalysis = null;
    
                        /**
                         * Creates a new Message instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {google.cloud.dialogflow.v2.IMessage=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.Message} Message instance
                         */
                        Message.create = function create(properties) {
                            return new Message(properties);
                        };
    
                        /**
                         * Encodes the specified Message message. Does not implicitly {@link google.cloud.dialogflow.v2.Message.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {google.cloud.dialogflow.v2.IMessage} message Message message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Message.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.content);
                            if (message.languageCode != null && Object.hasOwnProperty.call(message, "languageCode"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.languageCode);
                            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.participant);
                            if (message.participantRole != null && Object.hasOwnProperty.call(message, "participantRole"))
                                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.participantRole);
                            if (message.createTime != null && Object.hasOwnProperty.call(message, "createTime"))
                                $root.google.protobuf.Timestamp.encode(message.createTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.messageAnnotation != null && Object.hasOwnProperty.call(message, "messageAnnotation"))
                                $root.google.cloud.dialogflow.v2.MessageAnnotation.encode(message.messageAnnotation, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.sentimentAnalysis != null && Object.hasOwnProperty.call(message, "sentimentAnalysis"))
                                $root.google.cloud.dialogflow.v2.SentimentAnalysisResult.encode(message.sentimentAnalysis, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.sendTime != null && Object.hasOwnProperty.call(message, "sendTime"))
                                $root.google.protobuf.Timestamp.encode(message.sendTime, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified Message message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.Message.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {google.cloud.dialogflow.v2.IMessage} message Message message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Message.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a Message message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.Message} Message
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Message.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.Message();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                case 2:
                                    message.content = reader.string();
                                    break;
                                case 3:
                                    message.languageCode = reader.string();
                                    break;
                                case 4:
                                    message.participant = reader.string();
                                    break;
                                case 5:
                                    message.participantRole = reader.int32();
                                    break;
                                case 6:
                                    message.createTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                case 9:
                                    message.sendTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                case 7:
                                    message.messageAnnotation = $root.google.cloud.dialogflow.v2.MessageAnnotation.decode(reader, reader.uint32());
                                    break;
                                case 8:
                                    message.sentimentAnalysis = $root.google.cloud.dialogflow.v2.SentimentAnalysisResult.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a Message message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.Message} Message
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Message.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a Message message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Message.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.content != null && message.hasOwnProperty("content"))
                                if (!$util.isString(message.content))
                                    return "content: string expected";
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                if (!$util.isString(message.languageCode))
                                    return "languageCode: string expected";
                            if (message.participant != null && message.hasOwnProperty("participant"))
                                if (!$util.isString(message.participant))
                                    return "participant: string expected";
                            if (message.participantRole != null && message.hasOwnProperty("participantRole"))
                                switch (message.participantRole) {
                                default:
                                    return "participantRole: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.createTime != null && message.hasOwnProperty("createTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.createTime);
                                if (error)
                                    return "createTime." + error;
                            }
                            if (message.sendTime != null && message.hasOwnProperty("sendTime")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.sendTime);
                                if (error)
                                    return "sendTime." + error;
                            }
                            if (message.messageAnnotation != null && message.hasOwnProperty("messageAnnotation")) {
                                var error = $root.google.cloud.dialogflow.v2.MessageAnnotation.verify(message.messageAnnotation);
                                if (error)
                                    return "messageAnnotation." + error;
                            }
                            if (message.sentimentAnalysis != null && message.hasOwnProperty("sentimentAnalysis")) {
                                var error = $root.google.cloud.dialogflow.v2.SentimentAnalysisResult.verify(message.sentimentAnalysis);
                                if (error)
                                    return "sentimentAnalysis." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a Message message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.Message} Message
                         */
                        Message.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.Message)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.Message();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.content != null)
                                message.content = String(object.content);
                            if (object.languageCode != null)
                                message.languageCode = String(object.languageCode);
                            if (object.participant != null)
                                message.participant = String(object.participant);
                            switch (object.participantRole) {
                            case "ROLE_UNSPECIFIED":
                            case 0:
                                message.participantRole = 0;
                                break;
                            case "HUMAN_AGENT":
                            case 1:
                                message.participantRole = 1;
                                break;
                            case "AUTOMATED_AGENT":
                            case 2:
                                message.participantRole = 2;
                                break;
                            case "END_USER":
                            case 3:
                                message.participantRole = 3;
                                break;
                            }
                            if (object.createTime != null) {
                                if (typeof object.createTime !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.Message.createTime: object expected");
                                message.createTime = $root.google.protobuf.Timestamp.fromObject(object.createTime);
                            }
                            if (object.sendTime != null) {
                                if (typeof object.sendTime !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.Message.sendTime: object expected");
                                message.sendTime = $root.google.protobuf.Timestamp.fromObject(object.sendTime);
                            }
                            if (object.messageAnnotation != null) {
                                if (typeof object.messageAnnotation !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.Message.messageAnnotation: object expected");
                                message.messageAnnotation = $root.google.cloud.dialogflow.v2.MessageAnnotation.fromObject(object.messageAnnotation);
                            }
                            if (object.sentimentAnalysis != null) {
                                if (typeof object.sentimentAnalysis !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.Message.sentimentAnalysis: object expected");
                                message.sentimentAnalysis = $root.google.cloud.dialogflow.v2.SentimentAnalysisResult.fromObject(object.sentimentAnalysis);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a Message message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @static
                         * @param {google.cloud.dialogflow.v2.Message} message Message
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Message.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.content = "";
                                object.languageCode = "";
                                object.participant = "";
                                object.participantRole = options.enums === String ? "ROLE_UNSPECIFIED" : 0;
                                object.createTime = null;
                                object.messageAnnotation = null;
                                object.sentimentAnalysis = null;
                                object.sendTime = null;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.content != null && message.hasOwnProperty("content"))
                                object.content = message.content;
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                object.languageCode = message.languageCode;
                            if (message.participant != null && message.hasOwnProperty("participant"))
                                object.participant = message.participant;
                            if (message.participantRole != null && message.hasOwnProperty("participantRole"))
                                object.participantRole = options.enums === String ? $root.google.cloud.dialogflow.v2.Participant.Role[message.participantRole] : message.participantRole;
                            if (message.createTime != null && message.hasOwnProperty("createTime"))
                                object.createTime = $root.google.protobuf.Timestamp.toObject(message.createTime, options);
                            if (message.messageAnnotation != null && message.hasOwnProperty("messageAnnotation"))
                                object.messageAnnotation = $root.google.cloud.dialogflow.v2.MessageAnnotation.toObject(message.messageAnnotation, options);
                            if (message.sentimentAnalysis != null && message.hasOwnProperty("sentimentAnalysis"))
                                object.sentimentAnalysis = $root.google.cloud.dialogflow.v2.SentimentAnalysisResult.toObject(message.sentimentAnalysis, options);
                            if (message.sendTime != null && message.hasOwnProperty("sendTime"))
                                object.sendTime = $root.google.protobuf.Timestamp.toObject(message.sendTime, options);
                            return object;
                        };
    
                        /**
                         * Converts this Message to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.Message
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Message.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return Message;
                    })();
    
                    v2.CreateParticipantRequest = (function() {
    
                        /**
                         * Properties of a CreateParticipantRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ICreateParticipantRequest
                         * @property {string|null} [parent] CreateParticipantRequest parent
                         * @property {google.cloud.dialogflow.v2.IParticipant|null} [participant] CreateParticipantRequest participant
                         */
    
                        /**
                         * Constructs a new CreateParticipantRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a CreateParticipantRequest.
                         * @implements ICreateParticipantRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ICreateParticipantRequest=} [properties] Properties to set
                         */
                        function CreateParticipantRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * CreateParticipantRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @instance
                         */
                        CreateParticipantRequest.prototype.parent = "";
    
                        /**
                         * CreateParticipantRequest participant.
                         * @member {google.cloud.dialogflow.v2.IParticipant|null|undefined} participant
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @instance
                         */
                        CreateParticipantRequest.prototype.participant = null;
    
                        /**
                         * Creates a new CreateParticipantRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ICreateParticipantRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.CreateParticipantRequest} CreateParticipantRequest instance
                         */
                        CreateParticipantRequest.create = function create(properties) {
                            return new CreateParticipantRequest(properties);
                        };
    
                        /**
                         * Encodes the specified CreateParticipantRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.CreateParticipantRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ICreateParticipantRequest} message CreateParticipantRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateParticipantRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                                $root.google.cloud.dialogflow.v2.Participant.encode(message.participant, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified CreateParticipantRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.CreateParticipantRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ICreateParticipantRequest} message CreateParticipantRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateParticipantRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a CreateParticipantRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.CreateParticipantRequest} CreateParticipantRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateParticipantRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.CreateParticipantRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.participant = $root.google.cloud.dialogflow.v2.Participant.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a CreateParticipantRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.CreateParticipantRequest} CreateParticipantRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateParticipantRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a CreateParticipantRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateParticipantRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.participant != null && message.hasOwnProperty("participant")) {
                                var error = $root.google.cloud.dialogflow.v2.Participant.verify(message.participant);
                                if (error)
                                    return "participant." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a CreateParticipantRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.CreateParticipantRequest} CreateParticipantRequest
                         */
                        CreateParticipantRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.CreateParticipantRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.CreateParticipantRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.participant != null) {
                                if (typeof object.participant !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.CreateParticipantRequest.participant: object expected");
                                message.participant = $root.google.cloud.dialogflow.v2.Participant.fromObject(object.participant);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a CreateParticipantRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.CreateParticipantRequest} message CreateParticipantRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateParticipantRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.participant = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.participant != null && message.hasOwnProperty("participant"))
                                object.participant = $root.google.cloud.dialogflow.v2.Participant.toObject(message.participant, options);
                            return object;
                        };
    
                        /**
                         * Converts this CreateParticipantRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.CreateParticipantRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateParticipantRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return CreateParticipantRequest;
                    })();
    
                    v2.GetParticipantRequest = (function() {
    
                        /**
                         * Properties of a GetParticipantRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IGetParticipantRequest
                         * @property {string|null} [name] GetParticipantRequest name
                         */
    
                        /**
                         * Constructs a new GetParticipantRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a GetParticipantRequest.
                         * @implements IGetParticipantRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IGetParticipantRequest=} [properties] Properties to set
                         */
                        function GetParticipantRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * GetParticipantRequest name.
                         * @member {string} name
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @instance
                         */
                        GetParticipantRequest.prototype.name = "";
    
                        /**
                         * Creates a new GetParticipantRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetParticipantRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.GetParticipantRequest} GetParticipantRequest instance
                         */
                        GetParticipantRequest.create = function create(properties) {
                            return new GetParticipantRequest(properties);
                        };
    
                        /**
                         * Encodes the specified GetParticipantRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.GetParticipantRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetParticipantRequest} message GetParticipantRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetParticipantRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified GetParticipantRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.GetParticipantRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IGetParticipantRequest} message GetParticipantRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetParticipantRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a GetParticipantRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.GetParticipantRequest} GetParticipantRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetParticipantRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.GetParticipantRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a GetParticipantRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.GetParticipantRequest} GetParticipantRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetParticipantRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a GetParticipantRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetParticipantRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a GetParticipantRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.GetParticipantRequest} GetParticipantRequest
                         */
                        GetParticipantRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.GetParticipantRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.GetParticipantRequest();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a GetParticipantRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.GetParticipantRequest} message GetParticipantRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetParticipantRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };
    
                        /**
                         * Converts this GetParticipantRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.GetParticipantRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetParticipantRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return GetParticipantRequest;
                    })();
    
                    v2.ListParticipantsRequest = (function() {
    
                        /**
                         * Properties of a ListParticipantsRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IListParticipantsRequest
                         * @property {string|null} [parent] ListParticipantsRequest parent
                         * @property {number|null} [pageSize] ListParticipantsRequest pageSize
                         * @property {string|null} [pageToken] ListParticipantsRequest pageToken
                         */
    
                        /**
                         * Constructs a new ListParticipantsRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a ListParticipantsRequest.
                         * @implements IListParticipantsRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IListParticipantsRequest=} [properties] Properties to set
                         */
                        function ListParticipantsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListParticipantsRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @instance
                         */
                        ListParticipantsRequest.prototype.parent = "";
    
                        /**
                         * ListParticipantsRequest pageSize.
                         * @member {number} pageSize
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @instance
                         */
                        ListParticipantsRequest.prototype.pageSize = 0;
    
                        /**
                         * ListParticipantsRequest pageToken.
                         * @member {string} pageToken
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @instance
                         */
                        ListParticipantsRequest.prototype.pageToken = "";
    
                        /**
                         * Creates a new ListParticipantsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListParticipantsRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsRequest} ListParticipantsRequest instance
                         */
                        ListParticipantsRequest.create = function create(properties) {
                            return new ListParticipantsRequest(properties);
                        };
    
                        /**
                         * Encodes the specified ListParticipantsRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListParticipantsRequest} message ListParticipantsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListParticipantsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListParticipantsRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListParticipantsRequest} message ListParticipantsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListParticipantsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListParticipantsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsRequest} ListParticipantsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListParticipantsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ListParticipantsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.pageSize = reader.int32();
                                    break;
                                case 3:
                                    message.pageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListParticipantsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsRequest} ListParticipantsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListParticipantsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListParticipantsRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListParticipantsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                if (!$util.isInteger(message.pageSize))
                                    return "pageSize: integer expected";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListParticipantsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsRequest} ListParticipantsRequest
                         */
                        ListParticipantsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ListParticipantsRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ListParticipantsRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.pageSize != null)
                                message.pageSize = object.pageSize | 0;
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListParticipantsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ListParticipantsRequest} message ListParticipantsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListParticipantsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.pageSize = 0;
                                object.pageToken = "";
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                                object.pageSize = message.pageSize;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                                object.pageToken = message.pageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListParticipantsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListParticipantsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ListParticipantsRequest;
                    })();
    
                    v2.ListParticipantsResponse = (function() {
    
                        /**
                         * Properties of a ListParticipantsResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IListParticipantsResponse
                         * @property {Array.<google.cloud.dialogflow.v2.IParticipant>|null} [participants] ListParticipantsResponse participants
                         * @property {string|null} [nextPageToken] ListParticipantsResponse nextPageToken
                         */
    
                        /**
                         * Constructs a new ListParticipantsResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a ListParticipantsResponse.
                         * @implements IListParticipantsResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IListParticipantsResponse=} [properties] Properties to set
                         */
                        function ListParticipantsResponse(properties) {
                            this.participants = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ListParticipantsResponse participants.
                         * @member {Array.<google.cloud.dialogflow.v2.IParticipant>} participants
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @instance
                         */
                        ListParticipantsResponse.prototype.participants = $util.emptyArray;
    
                        /**
                         * ListParticipantsResponse nextPageToken.
                         * @member {string} nextPageToken
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @instance
                         */
                        ListParticipantsResponse.prototype.nextPageToken = "";
    
                        /**
                         * Creates a new ListParticipantsResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListParticipantsResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsResponse} ListParticipantsResponse instance
                         */
                        ListParticipantsResponse.create = function create(properties) {
                            return new ListParticipantsResponse(properties);
                        };
    
                        /**
                         * Encodes the specified ListParticipantsResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListParticipantsResponse} message ListParticipantsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListParticipantsResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.participants != null && message.participants.length)
                                for (var i = 0; i < message.participants.length; ++i)
                                    $root.google.cloud.dialogflow.v2.Participant.encode(message.participants[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ListParticipantsResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ListParticipantsResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IListParticipantsResponse} message ListParticipantsResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListParticipantsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ListParticipantsResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsResponse} ListParticipantsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListParticipantsResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ListParticipantsResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.participants && message.participants.length))
                                        message.participants = [];
                                    message.participants.push($root.google.cloud.dialogflow.v2.Participant.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.nextPageToken = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ListParticipantsResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsResponse} ListParticipantsResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListParticipantsResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ListParticipantsResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListParticipantsResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.participants != null && message.hasOwnProperty("participants")) {
                                if (!Array.isArray(message.participants))
                                    return "participants: array expected";
                                for (var i = 0; i < message.participants.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.Participant.verify(message.participants[i]);
                                    if (error)
                                        return "participants." + error;
                                }
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a ListParticipantsResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ListParticipantsResponse} ListParticipantsResponse
                         */
                        ListParticipantsResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ListParticipantsResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ListParticipantsResponse();
                            if (object.participants) {
                                if (!Array.isArray(object.participants))
                                    throw TypeError(".google.cloud.dialogflow.v2.ListParticipantsResponse.participants: array expected");
                                message.participants = [];
                                for (var i = 0; i < object.participants.length; ++i) {
                                    if (typeof object.participants[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.ListParticipantsResponse.participants: object expected");
                                    message.participants[i] = $root.google.cloud.dialogflow.v2.Participant.fromObject(object.participants[i]);
                                }
                            }
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ListParticipantsResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ListParticipantsResponse} message ListParticipantsResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListParticipantsResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.participants = [];
                            if (options.defaults)
                                object.nextPageToken = "";
                            if (message.participants && message.participants.length) {
                                object.participants = [];
                                for (var j = 0; j < message.participants.length; ++j)
                                    object.participants[j] = $root.google.cloud.dialogflow.v2.Participant.toObject(message.participants[j], options);
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                                object.nextPageToken = message.nextPageToken;
                            return object;
                        };
    
                        /**
                         * Converts this ListParticipantsResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ListParticipantsResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListParticipantsResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ListParticipantsResponse;
                    })();
    
                    v2.UpdateParticipantRequest = (function() {
    
                        /**
                         * Properties of an UpdateParticipantRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IUpdateParticipantRequest
                         * @property {google.cloud.dialogflow.v2.IParticipant|null} [participant] UpdateParticipantRequest participant
                         * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateParticipantRequest updateMask
                         */
    
                        /**
                         * Constructs a new UpdateParticipantRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an UpdateParticipantRequest.
                         * @implements IUpdateParticipantRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IUpdateParticipantRequest=} [properties] Properties to set
                         */
                        function UpdateParticipantRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * UpdateParticipantRequest participant.
                         * @member {google.cloud.dialogflow.v2.IParticipant|null|undefined} participant
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @instance
                         */
                        UpdateParticipantRequest.prototype.participant = null;
    
                        /**
                         * UpdateParticipantRequest updateMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @instance
                         */
                        UpdateParticipantRequest.prototype.updateMask = null;
    
                        /**
                         * Creates a new UpdateParticipantRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IUpdateParticipantRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.UpdateParticipantRequest} UpdateParticipantRequest instance
                         */
                        UpdateParticipantRequest.create = function create(properties) {
                            return new UpdateParticipantRequest(properties);
                        };
    
                        /**
                         * Encodes the specified UpdateParticipantRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateParticipantRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IUpdateParticipantRequest} message UpdateParticipantRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateParticipantRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                                $root.google.cloud.dialogflow.v2.Participant.encode(message.participant, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                                $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified UpdateParticipantRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.UpdateParticipantRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IUpdateParticipantRequest} message UpdateParticipantRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateParticipantRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an UpdateParticipantRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.UpdateParticipantRequest} UpdateParticipantRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateParticipantRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.UpdateParticipantRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.participant = $root.google.cloud.dialogflow.v2.Participant.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an UpdateParticipantRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.UpdateParticipantRequest} UpdateParticipantRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateParticipantRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an UpdateParticipantRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateParticipantRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.participant != null && message.hasOwnProperty("participant")) {
                                var error = $root.google.cloud.dialogflow.v2.Participant.verify(message.participant);
                                if (error)
                                    return "participant." + error;
                            }
                            if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                                if (error)
                                    return "updateMask." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an UpdateParticipantRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.UpdateParticipantRequest} UpdateParticipantRequest
                         */
                        UpdateParticipantRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.UpdateParticipantRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.UpdateParticipantRequest();
                            if (object.participant != null) {
                                if (typeof object.participant !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.UpdateParticipantRequest.participant: object expected");
                                message.participant = $root.google.cloud.dialogflow.v2.Participant.fromObject(object.participant);
                            }
                            if (object.updateMask != null) {
                                if (typeof object.updateMask !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.UpdateParticipantRequest.updateMask: object expected");
                                message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an UpdateParticipantRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.UpdateParticipantRequest} message UpdateParticipantRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateParticipantRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.participant = null;
                                object.updateMask = null;
                            }
                            if (message.participant != null && message.hasOwnProperty("participant"))
                                object.participant = $root.google.cloud.dialogflow.v2.Participant.toObject(message.participant, options);
                            if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                                object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this UpdateParticipantRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.UpdateParticipantRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateParticipantRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return UpdateParticipantRequest;
                    })();
    
                    v2.AnalyzeContentRequest = (function() {
    
                        /**
                         * Properties of an AnalyzeContentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAnalyzeContentRequest
                         * @property {string|null} [participant] AnalyzeContentRequest participant
                         * @property {google.cloud.dialogflow.v2.ITextInput|null} [textInput] AnalyzeContentRequest textInput
                         * @property {google.cloud.dialogflow.v2.IEventInput|null} [eventInput] AnalyzeContentRequest eventInput
                         * @property {google.cloud.dialogflow.v2.IOutputAudioConfig|null} [replyAudioConfig] AnalyzeContentRequest replyAudioConfig
                         * @property {google.cloud.dialogflow.v2.IQueryParameters|null} [queryParams] AnalyzeContentRequest queryParams
                         * @property {google.cloud.dialogflow.v2.IAssistQueryParameters|null} [assistQueryParams] AnalyzeContentRequest assistQueryParams
                         * @property {google.protobuf.IStruct|null} [cxParameters] AnalyzeContentRequest cxParameters
                         * @property {string|null} [requestId] AnalyzeContentRequest requestId
                         */
    
                        /**
                         * Constructs a new AnalyzeContentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AnalyzeContentRequest.
                         * @implements IAnalyzeContentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentRequest=} [properties] Properties to set
                         */
                        function AnalyzeContentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnalyzeContentRequest participant.
                         * @member {string} participant
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.participant = "";
    
                        /**
                         * AnalyzeContentRequest textInput.
                         * @member {google.cloud.dialogflow.v2.ITextInput|null|undefined} textInput
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.textInput = null;
    
                        /**
                         * AnalyzeContentRequest eventInput.
                         * @member {google.cloud.dialogflow.v2.IEventInput|null|undefined} eventInput
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.eventInput = null;
    
                        /**
                         * AnalyzeContentRequest replyAudioConfig.
                         * @member {google.cloud.dialogflow.v2.IOutputAudioConfig|null|undefined} replyAudioConfig
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.replyAudioConfig = null;
    
                        /**
                         * AnalyzeContentRequest queryParams.
                         * @member {google.cloud.dialogflow.v2.IQueryParameters|null|undefined} queryParams
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.queryParams = null;
    
                        /**
                         * AnalyzeContentRequest assistQueryParams.
                         * @member {google.cloud.dialogflow.v2.IAssistQueryParameters|null|undefined} assistQueryParams
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.assistQueryParams = null;
    
                        /**
                         * AnalyzeContentRequest cxParameters.
                         * @member {google.protobuf.IStruct|null|undefined} cxParameters
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.cxParameters = null;
    
                        /**
                         * AnalyzeContentRequest requestId.
                         * @member {string} requestId
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        AnalyzeContentRequest.prototype.requestId = "";
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * AnalyzeContentRequest input.
                         * @member {"textInput"|"eventInput"|undefined} input
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         */
                        Object.defineProperty(AnalyzeContentRequest.prototype, "input", {
                            get: $util.oneOfGetter($oneOfFields = ["textInput", "eventInput"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new AnalyzeContentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentRequest} AnalyzeContentRequest instance
                         */
                        AnalyzeContentRequest.create = function create(properties) {
                            return new AnalyzeContentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified AnalyzeContentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentRequest} message AnalyzeContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnalyzeContentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.participant);
                            if (message.replyAudioConfig != null && Object.hasOwnProperty.call(message, "replyAudioConfig"))
                                $root.google.cloud.dialogflow.v2.OutputAudioConfig.encode(message.replyAudioConfig, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.textInput != null && Object.hasOwnProperty.call(message, "textInput"))
                                $root.google.cloud.dialogflow.v2.TextInput.encode(message.textInput, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.eventInput != null && Object.hasOwnProperty.call(message, "eventInput"))
                                $root.google.cloud.dialogflow.v2.EventInput.encode(message.eventInput, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                            if (message.queryParams != null && Object.hasOwnProperty.call(message, "queryParams"))
                                $root.google.cloud.dialogflow.v2.QueryParameters.encode(message.queryParams, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            if (message.requestId != null && Object.hasOwnProperty.call(message, "requestId"))
                                writer.uint32(/* id 11, wireType 2 =*/90).string(message.requestId);
                            if (message.assistQueryParams != null && Object.hasOwnProperty.call(message, "assistQueryParams"))
                                $root.google.cloud.dialogflow.v2.AssistQueryParameters.encode(message.assistQueryParams, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                            if (message.cxParameters != null && Object.hasOwnProperty.call(message, "cxParameters"))
                                $root.google.protobuf.Struct.encode(message.cxParameters, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnalyzeContentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentRequest} message AnalyzeContentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnalyzeContentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnalyzeContentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentRequest} AnalyzeContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnalyzeContentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AnalyzeContentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.participant = reader.string();
                                    break;
                                case 6:
                                    message.textInput = $root.google.cloud.dialogflow.v2.TextInput.decode(reader, reader.uint32());
                                    break;
                                case 8:
                                    message.eventInput = $root.google.cloud.dialogflow.v2.EventInput.decode(reader, reader.uint32());
                                    break;
                                case 5:
                                    message.replyAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.decode(reader, reader.uint32());
                                    break;
                                case 9:
                                    message.queryParams = $root.google.cloud.dialogflow.v2.QueryParameters.decode(reader, reader.uint32());
                                    break;
                                case 14:
                                    message.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.decode(reader, reader.uint32());
                                    break;
                                case 18:
                                    message.cxParameters = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                                    break;
                                case 11:
                                    message.requestId = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnalyzeContentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentRequest} AnalyzeContentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnalyzeContentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnalyzeContentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnalyzeContentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.participant != null && message.hasOwnProperty("participant"))
                                if (!$util.isString(message.participant))
                                    return "participant: string expected";
                            if (message.textInput != null && message.hasOwnProperty("textInput")) {
                                properties.input = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.TextInput.verify(message.textInput);
                                    if (error)
                                        return "textInput." + error;
                                }
                            }
                            if (message.eventInput != null && message.hasOwnProperty("eventInput")) {
                                if (properties.input === 1)
                                    return "input: multiple values";
                                properties.input = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.EventInput.verify(message.eventInput);
                                    if (error)
                                        return "eventInput." + error;
                                }
                            }
                            if (message.replyAudioConfig != null && message.hasOwnProperty("replyAudioConfig")) {
                                var error = $root.google.cloud.dialogflow.v2.OutputAudioConfig.verify(message.replyAudioConfig);
                                if (error)
                                    return "replyAudioConfig." + error;
                            }
                            if (message.queryParams != null && message.hasOwnProperty("queryParams")) {
                                var error = $root.google.cloud.dialogflow.v2.QueryParameters.verify(message.queryParams);
                                if (error)
                                    return "queryParams." + error;
                            }
                            if (message.assistQueryParams != null && message.hasOwnProperty("assistQueryParams")) {
                                var error = $root.google.cloud.dialogflow.v2.AssistQueryParameters.verify(message.assistQueryParams);
                                if (error)
                                    return "assistQueryParams." + error;
                            }
                            if (message.cxParameters != null && message.hasOwnProperty("cxParameters")) {
                                var error = $root.google.protobuf.Struct.verify(message.cxParameters);
                                if (error)
                                    return "cxParameters." + error;
                            }
                            if (message.requestId != null && message.hasOwnProperty("requestId"))
                                if (!$util.isString(message.requestId))
                                    return "requestId: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an AnalyzeContentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentRequest} AnalyzeContentRequest
                         */
                        AnalyzeContentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AnalyzeContentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AnalyzeContentRequest();
                            if (object.participant != null)
                                message.participant = String(object.participant);
                            if (object.textInput != null) {
                                if (typeof object.textInput !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentRequest.textInput: object expected");
                                message.textInput = $root.google.cloud.dialogflow.v2.TextInput.fromObject(object.textInput);
                            }
                            if (object.eventInput != null) {
                                if (typeof object.eventInput !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentRequest.eventInput: object expected");
                                message.eventInput = $root.google.cloud.dialogflow.v2.EventInput.fromObject(object.eventInput);
                            }
                            if (object.replyAudioConfig != null) {
                                if (typeof object.replyAudioConfig !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentRequest.replyAudioConfig: object expected");
                                message.replyAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.fromObject(object.replyAudioConfig);
                            }
                            if (object.queryParams != null) {
                                if (typeof object.queryParams !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentRequest.queryParams: object expected");
                                message.queryParams = $root.google.cloud.dialogflow.v2.QueryParameters.fromObject(object.queryParams);
                            }
                            if (object.assistQueryParams != null) {
                                if (typeof object.assistQueryParams !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentRequest.assistQueryParams: object expected");
                                message.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.fromObject(object.assistQueryParams);
                            }
                            if (object.cxParameters != null) {
                                if (typeof object.cxParameters !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentRequest.cxParameters: object expected");
                                message.cxParameters = $root.google.protobuf.Struct.fromObject(object.cxParameters);
                            }
                            if (object.requestId != null)
                                message.requestId = String(object.requestId);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnalyzeContentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.AnalyzeContentRequest} message AnalyzeContentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnalyzeContentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.participant = "";
                                object.replyAudioConfig = null;
                                object.queryParams = null;
                                object.requestId = "";
                                object.assistQueryParams = null;
                                object.cxParameters = null;
                            }
                            if (message.participant != null && message.hasOwnProperty("participant"))
                                object.participant = message.participant;
                            if (message.replyAudioConfig != null && message.hasOwnProperty("replyAudioConfig"))
                                object.replyAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.toObject(message.replyAudioConfig, options);
                            if (message.textInput != null && message.hasOwnProperty("textInput")) {
                                object.textInput = $root.google.cloud.dialogflow.v2.TextInput.toObject(message.textInput, options);
                                if (options.oneofs)
                                    object.input = "textInput";
                            }
                            if (message.eventInput != null && message.hasOwnProperty("eventInput")) {
                                object.eventInput = $root.google.cloud.dialogflow.v2.EventInput.toObject(message.eventInput, options);
                                if (options.oneofs)
                                    object.input = "eventInput";
                            }
                            if (message.queryParams != null && message.hasOwnProperty("queryParams"))
                                object.queryParams = $root.google.cloud.dialogflow.v2.QueryParameters.toObject(message.queryParams, options);
                            if (message.requestId != null && message.hasOwnProperty("requestId"))
                                object.requestId = message.requestId;
                            if (message.assistQueryParams != null && message.hasOwnProperty("assistQueryParams"))
                                object.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.toObject(message.assistQueryParams, options);
                            if (message.cxParameters != null && message.hasOwnProperty("cxParameters"))
                                object.cxParameters = $root.google.protobuf.Struct.toObject(message.cxParameters, options);
                            return object;
                        };
    
                        /**
                         * Converts this AnalyzeContentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnalyzeContentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return AnalyzeContentRequest;
                    })();
    
                    v2.DtmfParameters = (function() {
    
                        /**
                         * Properties of a DtmfParameters.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IDtmfParameters
                         * @property {boolean|null} [acceptsDtmfInput] DtmfParameters acceptsDtmfInput
                         */
    
                        /**
                         * Constructs a new DtmfParameters.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a DtmfParameters.
                         * @implements IDtmfParameters
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IDtmfParameters=} [properties] Properties to set
                         */
                        function DtmfParameters(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DtmfParameters acceptsDtmfInput.
                         * @member {boolean} acceptsDtmfInput
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @instance
                         */
                        DtmfParameters.prototype.acceptsDtmfInput = false;
    
                        /**
                         * Creates a new DtmfParameters instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDtmfParameters=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.DtmfParameters} DtmfParameters instance
                         */
                        DtmfParameters.create = function create(properties) {
                            return new DtmfParameters(properties);
                        };
    
                        /**
                         * Encodes the specified DtmfParameters message. Does not implicitly {@link google.cloud.dialogflow.v2.DtmfParameters.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDtmfParameters} message DtmfParameters message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DtmfParameters.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.acceptsDtmfInput != null && Object.hasOwnProperty.call(message, "acceptsDtmfInput"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.acceptsDtmfInput);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DtmfParameters message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DtmfParameters.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDtmfParameters} message DtmfParameters message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DtmfParameters.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DtmfParameters message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.DtmfParameters} DtmfParameters
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DtmfParameters.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.DtmfParameters();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.acceptsDtmfInput = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DtmfParameters message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.DtmfParameters} DtmfParameters
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DtmfParameters.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DtmfParameters message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DtmfParameters.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.acceptsDtmfInput != null && message.hasOwnProperty("acceptsDtmfInput"))
                                if (typeof message.acceptsDtmfInput !== "boolean")
                                    return "acceptsDtmfInput: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a DtmfParameters message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.DtmfParameters} DtmfParameters
                         */
                        DtmfParameters.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.DtmfParameters)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.DtmfParameters();
                            if (object.acceptsDtmfInput != null)
                                message.acceptsDtmfInput = Boolean(object.acceptsDtmfInput);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DtmfParameters message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.DtmfParameters} message DtmfParameters
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DtmfParameters.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.acceptsDtmfInput = false;
                            if (message.acceptsDtmfInput != null && message.hasOwnProperty("acceptsDtmfInput"))
                                object.acceptsDtmfInput = message.acceptsDtmfInput;
                            return object;
                        };
    
                        /**
                         * Converts this DtmfParameters to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.DtmfParameters
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DtmfParameters.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return DtmfParameters;
                    })();
    
                    v2.AnalyzeContentResponse = (function() {
    
                        /**
                         * Properties of an AnalyzeContentResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAnalyzeContentResponse
                         * @property {string|null} [replyText] AnalyzeContentResponse replyText
                         * @property {google.cloud.dialogflow.v2.IOutputAudio|null} [replyAudio] AnalyzeContentResponse replyAudio
                         * @property {google.cloud.dialogflow.v2.IAutomatedAgentReply|null} [automatedAgentReply] AnalyzeContentResponse automatedAgentReply
                         * @property {google.cloud.dialogflow.v2.IMessage|null} [message] AnalyzeContentResponse message
                         * @property {Array.<google.cloud.dialogflow.v2.ISuggestionResult>|null} [humanAgentSuggestionResults] AnalyzeContentResponse humanAgentSuggestionResults
                         * @property {Array.<google.cloud.dialogflow.v2.ISuggestionResult>|null} [endUserSuggestionResults] AnalyzeContentResponse endUserSuggestionResults
                         * @property {google.cloud.dialogflow.v2.IDtmfParameters|null} [dtmfParameters] AnalyzeContentResponse dtmfParameters
                         */
    
                        /**
                         * Constructs a new AnalyzeContentResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AnalyzeContentResponse.
                         * @implements IAnalyzeContentResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentResponse=} [properties] Properties to set
                         */
                        function AnalyzeContentResponse(properties) {
                            this.humanAgentSuggestionResults = [];
                            this.endUserSuggestionResults = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnalyzeContentResponse replyText.
                         * @member {string} replyText
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         */
                        AnalyzeContentResponse.prototype.replyText = "";
    
                        /**
                         * AnalyzeContentResponse replyAudio.
                         * @member {google.cloud.dialogflow.v2.IOutputAudio|null|undefined} replyAudio
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         */
                        AnalyzeContentResponse.prototype.replyAudio = null;
    
                        /**
                         * AnalyzeContentResponse automatedAgentReply.
                         * @member {google.cloud.dialogflow.v2.IAutomatedAgentReply|null|undefined} automatedAgentReply
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         */
                        AnalyzeContentResponse.prototype.automatedAgentReply = null;
    
                        /**
                         * AnalyzeContentResponse message.
                         * @member {google.cloud.dialogflow.v2.IMessage|null|undefined} message
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         */
                        AnalyzeContentResponse.prototype.message = null;
    
                        /**
                         * AnalyzeContentResponse humanAgentSuggestionResults.
                         * @member {Array.<google.cloud.dialogflow.v2.ISuggestionResult>} humanAgentSuggestionResults
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         */
                        AnalyzeContentResponse.prototype.humanAgentSuggestionResults = $util.emptyArray;
    
                        /**
                         * AnalyzeContentResponse endUserSuggestionResults.
                         * @member {Array.<google.cloud.dialogflow.v2.ISuggestionResult>} endUserSuggestionResults
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         */
                        AnalyzeContentResponse.prototype.endUserSuggestionResults = $util.emptyArray;
    
                        /**
                         * AnalyzeContentResponse dtmfParameters.
                         * @member {google.cloud.dialogflow.v2.IDtmfParameters|null|undefined} dtmfParameters
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         */
                        AnalyzeContentResponse.prototype.dtmfParameters = null;
    
                        /**
                         * Creates a new AnalyzeContentResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentResponse} AnalyzeContentResponse instance
                         */
                        AnalyzeContentResponse.create = function create(properties) {
                            return new AnalyzeContentResponse(properties);
                        };
    
                        /**
                         * Encodes the specified AnalyzeContentResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentResponse} message AnalyzeContentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnalyzeContentResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.replyText != null && Object.hasOwnProperty.call(message, "replyText"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.replyText);
                            if (message.replyAudio != null && Object.hasOwnProperty.call(message, "replyAudio"))
                                $root.google.cloud.dialogflow.v2.OutputAudio.encode(message.replyAudio, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.automatedAgentReply != null && Object.hasOwnProperty.call(message, "automatedAgentReply"))
                                $root.google.cloud.dialogflow.v2.AutomatedAgentReply.encode(message.automatedAgentReply, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                                $root.google.cloud.dialogflow.v2.Message.encode(message.message, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.humanAgentSuggestionResults != null && message.humanAgentSuggestionResults.length)
                                for (var i = 0; i < message.humanAgentSuggestionResults.length; ++i)
                                    $root.google.cloud.dialogflow.v2.SuggestionResult.encode(message.humanAgentSuggestionResults[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.endUserSuggestionResults != null && message.endUserSuggestionResults.length)
                                for (var i = 0; i < message.endUserSuggestionResults.length; ++i)
                                    $root.google.cloud.dialogflow.v2.SuggestionResult.encode(message.endUserSuggestionResults[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.dtmfParameters != null && Object.hasOwnProperty.call(message, "dtmfParameters"))
                                $root.google.cloud.dialogflow.v2.DtmfParameters.encode(message.dtmfParameters, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnalyzeContentResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnalyzeContentResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnalyzeContentResponse} message AnalyzeContentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnalyzeContentResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnalyzeContentResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentResponse} AnalyzeContentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnalyzeContentResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AnalyzeContentResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.replyText = reader.string();
                                    break;
                                case 2:
                                    message.replyAudio = $root.google.cloud.dialogflow.v2.OutputAudio.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.automatedAgentReply = $root.google.cloud.dialogflow.v2.AutomatedAgentReply.decode(reader, reader.uint32());
                                    break;
                                case 5:
                                    message.message = $root.google.cloud.dialogflow.v2.Message.decode(reader, reader.uint32());
                                    break;
                                case 6:
                                    if (!(message.humanAgentSuggestionResults && message.humanAgentSuggestionResults.length))
                                        message.humanAgentSuggestionResults = [];
                                    message.humanAgentSuggestionResults.push($root.google.cloud.dialogflow.v2.SuggestionResult.decode(reader, reader.uint32()));
                                    break;
                                case 7:
                                    if (!(message.endUserSuggestionResults && message.endUserSuggestionResults.length))
                                        message.endUserSuggestionResults = [];
                                    message.endUserSuggestionResults.push($root.google.cloud.dialogflow.v2.SuggestionResult.decode(reader, reader.uint32()));
                                    break;
                                case 9:
                                    message.dtmfParameters = $root.google.cloud.dialogflow.v2.DtmfParameters.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnalyzeContentResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentResponse} AnalyzeContentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnalyzeContentResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnalyzeContentResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnalyzeContentResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.replyText != null && message.hasOwnProperty("replyText"))
                                if (!$util.isString(message.replyText))
                                    return "replyText: string expected";
                            if (message.replyAudio != null && message.hasOwnProperty("replyAudio")) {
                                var error = $root.google.cloud.dialogflow.v2.OutputAudio.verify(message.replyAudio);
                                if (error)
                                    return "replyAudio." + error;
                            }
                            if (message.automatedAgentReply != null && message.hasOwnProperty("automatedAgentReply")) {
                                var error = $root.google.cloud.dialogflow.v2.AutomatedAgentReply.verify(message.automatedAgentReply);
                                if (error)
                                    return "automatedAgentReply." + error;
                            }
                            if (message.message != null && message.hasOwnProperty("message")) {
                                var error = $root.google.cloud.dialogflow.v2.Message.verify(message.message);
                                if (error)
                                    return "message." + error;
                            }
                            if (message.humanAgentSuggestionResults != null && message.hasOwnProperty("humanAgentSuggestionResults")) {
                                if (!Array.isArray(message.humanAgentSuggestionResults))
                                    return "humanAgentSuggestionResults: array expected";
                                for (var i = 0; i < message.humanAgentSuggestionResults.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.SuggestionResult.verify(message.humanAgentSuggestionResults[i]);
                                    if (error)
                                        return "humanAgentSuggestionResults." + error;
                                }
                            }
                            if (message.endUserSuggestionResults != null && message.hasOwnProperty("endUserSuggestionResults")) {
                                if (!Array.isArray(message.endUserSuggestionResults))
                                    return "endUserSuggestionResults: array expected";
                                for (var i = 0; i < message.endUserSuggestionResults.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.SuggestionResult.verify(message.endUserSuggestionResults[i]);
                                    if (error)
                                        return "endUserSuggestionResults." + error;
                                }
                            }
                            if (message.dtmfParameters != null && message.hasOwnProperty("dtmfParameters")) {
                                var error = $root.google.cloud.dialogflow.v2.DtmfParameters.verify(message.dtmfParameters);
                                if (error)
                                    return "dtmfParameters." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnalyzeContentResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AnalyzeContentResponse} AnalyzeContentResponse
                         */
                        AnalyzeContentResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AnalyzeContentResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AnalyzeContentResponse();
                            if (object.replyText != null)
                                message.replyText = String(object.replyText);
                            if (object.replyAudio != null) {
                                if (typeof object.replyAudio !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.replyAudio: object expected");
                                message.replyAudio = $root.google.cloud.dialogflow.v2.OutputAudio.fromObject(object.replyAudio);
                            }
                            if (object.automatedAgentReply != null) {
                                if (typeof object.automatedAgentReply !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.automatedAgentReply: object expected");
                                message.automatedAgentReply = $root.google.cloud.dialogflow.v2.AutomatedAgentReply.fromObject(object.automatedAgentReply);
                            }
                            if (object.message != null) {
                                if (typeof object.message !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.message: object expected");
                                message.message = $root.google.cloud.dialogflow.v2.Message.fromObject(object.message);
                            }
                            if (object.humanAgentSuggestionResults) {
                                if (!Array.isArray(object.humanAgentSuggestionResults))
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.humanAgentSuggestionResults: array expected");
                                message.humanAgentSuggestionResults = [];
                                for (var i = 0; i < object.humanAgentSuggestionResults.length; ++i) {
                                    if (typeof object.humanAgentSuggestionResults[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.humanAgentSuggestionResults: object expected");
                                    message.humanAgentSuggestionResults[i] = $root.google.cloud.dialogflow.v2.SuggestionResult.fromObject(object.humanAgentSuggestionResults[i]);
                                }
                            }
                            if (object.endUserSuggestionResults) {
                                if (!Array.isArray(object.endUserSuggestionResults))
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.endUserSuggestionResults: array expected");
                                message.endUserSuggestionResults = [];
                                for (var i = 0; i < object.endUserSuggestionResults.length; ++i) {
                                    if (typeof object.endUserSuggestionResults[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.endUserSuggestionResults: object expected");
                                    message.endUserSuggestionResults[i] = $root.google.cloud.dialogflow.v2.SuggestionResult.fromObject(object.endUserSuggestionResults[i]);
                                }
                            }
                            if (object.dtmfParameters != null) {
                                if (typeof object.dtmfParameters !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnalyzeContentResponse.dtmfParameters: object expected");
                                message.dtmfParameters = $root.google.cloud.dialogflow.v2.DtmfParameters.fromObject(object.dtmfParameters);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnalyzeContentResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.AnalyzeContentResponse} message AnalyzeContentResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnalyzeContentResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.humanAgentSuggestionResults = [];
                                object.endUserSuggestionResults = [];
                            }
                            if (options.defaults) {
                                object.replyText = "";
                                object.replyAudio = null;
                                object.automatedAgentReply = null;
                                object.message = null;
                                object.dtmfParameters = null;
                            }
                            if (message.replyText != null && message.hasOwnProperty("replyText"))
                                object.replyText = message.replyText;
                            if (message.replyAudio != null && message.hasOwnProperty("replyAudio"))
                                object.replyAudio = $root.google.cloud.dialogflow.v2.OutputAudio.toObject(message.replyAudio, options);
                            if (message.automatedAgentReply != null && message.hasOwnProperty("automatedAgentReply"))
                                object.automatedAgentReply = $root.google.cloud.dialogflow.v2.AutomatedAgentReply.toObject(message.automatedAgentReply, options);
                            if (message.message != null && message.hasOwnProperty("message"))
                                object.message = $root.google.cloud.dialogflow.v2.Message.toObject(message.message, options);
                            if (message.humanAgentSuggestionResults && message.humanAgentSuggestionResults.length) {
                                object.humanAgentSuggestionResults = [];
                                for (var j = 0; j < message.humanAgentSuggestionResults.length; ++j)
                                    object.humanAgentSuggestionResults[j] = $root.google.cloud.dialogflow.v2.SuggestionResult.toObject(message.humanAgentSuggestionResults[j], options);
                            }
                            if (message.endUserSuggestionResults && message.endUserSuggestionResults.length) {
                                object.endUserSuggestionResults = [];
                                for (var j = 0; j < message.endUserSuggestionResults.length; ++j)
                                    object.endUserSuggestionResults[j] = $root.google.cloud.dialogflow.v2.SuggestionResult.toObject(message.endUserSuggestionResults[j], options);
                            }
                            if (message.dtmfParameters != null && message.hasOwnProperty("dtmfParameters"))
                                object.dtmfParameters = $root.google.cloud.dialogflow.v2.DtmfParameters.toObject(message.dtmfParameters, options);
                            return object;
                        };
    
                        /**
                         * Converts this AnalyzeContentResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AnalyzeContentResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnalyzeContentResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return AnalyzeContentResponse;
                    })();
    
                    v2.SuggestArticlesRequest = (function() {
    
                        /**
                         * Properties of a SuggestArticlesRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISuggestArticlesRequest
                         * @property {string|null} [parent] SuggestArticlesRequest parent
                         * @property {string|null} [latestMessage] SuggestArticlesRequest latestMessage
                         * @property {number|null} [contextSize] SuggestArticlesRequest contextSize
                         * @property {google.cloud.dialogflow.v2.IAssistQueryParameters|null} [assistQueryParams] SuggestArticlesRequest assistQueryParams
                         */
    
                        /**
                         * Constructs a new SuggestArticlesRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SuggestArticlesRequest.
                         * @implements ISuggestArticlesRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesRequest=} [properties] Properties to set
                         */
                        function SuggestArticlesRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SuggestArticlesRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @instance
                         */
                        SuggestArticlesRequest.prototype.parent = "";
    
                        /**
                         * SuggestArticlesRequest latestMessage.
                         * @member {string} latestMessage
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @instance
                         */
                        SuggestArticlesRequest.prototype.latestMessage = "";
    
                        /**
                         * SuggestArticlesRequest contextSize.
                         * @member {number} contextSize
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @instance
                         */
                        SuggestArticlesRequest.prototype.contextSize = 0;
    
                        /**
                         * SuggestArticlesRequest assistQueryParams.
                         * @member {google.cloud.dialogflow.v2.IAssistQueryParameters|null|undefined} assistQueryParams
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @instance
                         */
                        SuggestArticlesRequest.prototype.assistQueryParams = null;
    
                        /**
                         * Creates a new SuggestArticlesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesRequest} SuggestArticlesRequest instance
                         */
                        SuggestArticlesRequest.create = function create(properties) {
                            return new SuggestArticlesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SuggestArticlesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesRequest} message SuggestArticlesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestArticlesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.latestMessage != null && Object.hasOwnProperty.call(message, "latestMessage"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.latestMessage);
                            if (message.contextSize != null && Object.hasOwnProperty.call(message, "contextSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.contextSize);
                            if (message.assistQueryParams != null && Object.hasOwnProperty.call(message, "assistQueryParams"))
                                $root.google.cloud.dialogflow.v2.AssistQueryParameters.encode(message.assistQueryParams, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SuggestArticlesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesRequest} message SuggestArticlesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestArticlesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SuggestArticlesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesRequest} SuggestArticlesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestArticlesRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SuggestArticlesRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.latestMessage = reader.string();
                                    break;
                                case 3:
                                    message.contextSize = reader.int32();
                                    break;
                                case 4:
                                    message.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SuggestArticlesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesRequest} SuggestArticlesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestArticlesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SuggestArticlesRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SuggestArticlesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                if (!$util.isString(message.latestMessage))
                                    return "latestMessage: string expected";
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                if (!$util.isInteger(message.contextSize))
                                    return "contextSize: integer expected";
                            if (message.assistQueryParams != null && message.hasOwnProperty("assistQueryParams")) {
                                var error = $root.google.cloud.dialogflow.v2.AssistQueryParameters.verify(message.assistQueryParams);
                                if (error)
                                    return "assistQueryParams." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SuggestArticlesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesRequest} SuggestArticlesRequest
                         */
                        SuggestArticlesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SuggestArticlesRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SuggestArticlesRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.latestMessage != null)
                                message.latestMessage = String(object.latestMessage);
                            if (object.contextSize != null)
                                message.contextSize = object.contextSize | 0;
                            if (object.assistQueryParams != null) {
                                if (typeof object.assistQueryParams !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestArticlesRequest.assistQueryParams: object expected");
                                message.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.fromObject(object.assistQueryParams);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SuggestArticlesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.SuggestArticlesRequest} message SuggestArticlesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SuggestArticlesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.latestMessage = "";
                                object.contextSize = 0;
                                object.assistQueryParams = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                object.latestMessage = message.latestMessage;
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                object.contextSize = message.contextSize;
                            if (message.assistQueryParams != null && message.hasOwnProperty("assistQueryParams"))
                                object.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.toObject(message.assistQueryParams, options);
                            return object;
                        };
    
                        /**
                         * Converts this SuggestArticlesRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SuggestArticlesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SuggestArticlesRequest;
                    })();
    
                    v2.SuggestArticlesResponse = (function() {
    
                        /**
                         * Properties of a SuggestArticlesResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISuggestArticlesResponse
                         * @property {Array.<google.cloud.dialogflow.v2.IArticleAnswer>|null} [articleAnswers] SuggestArticlesResponse articleAnswers
                         * @property {string|null} [latestMessage] SuggestArticlesResponse latestMessage
                         * @property {number|null} [contextSize] SuggestArticlesResponse contextSize
                         */
    
                        /**
                         * Constructs a new SuggestArticlesResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SuggestArticlesResponse.
                         * @implements ISuggestArticlesResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesResponse=} [properties] Properties to set
                         */
                        function SuggestArticlesResponse(properties) {
                            this.articleAnswers = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SuggestArticlesResponse articleAnswers.
                         * @member {Array.<google.cloud.dialogflow.v2.IArticleAnswer>} articleAnswers
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @instance
                         */
                        SuggestArticlesResponse.prototype.articleAnswers = $util.emptyArray;
    
                        /**
                         * SuggestArticlesResponse latestMessage.
                         * @member {string} latestMessage
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @instance
                         */
                        SuggestArticlesResponse.prototype.latestMessage = "";
    
                        /**
                         * SuggestArticlesResponse contextSize.
                         * @member {number} contextSize
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @instance
                         */
                        SuggestArticlesResponse.prototype.contextSize = 0;
    
                        /**
                         * Creates a new SuggestArticlesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesResponse} SuggestArticlesResponse instance
                         */
                        SuggestArticlesResponse.create = function create(properties) {
                            return new SuggestArticlesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified SuggestArticlesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesResponse} message SuggestArticlesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestArticlesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.articleAnswers != null && message.articleAnswers.length)
                                for (var i = 0; i < message.articleAnswers.length; ++i)
                                    $root.google.cloud.dialogflow.v2.ArticleAnswer.encode(message.articleAnswers[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.latestMessage != null && Object.hasOwnProperty.call(message, "latestMessage"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.latestMessage);
                            if (message.contextSize != null && Object.hasOwnProperty.call(message, "contextSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.contextSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SuggestArticlesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestArticlesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestArticlesResponse} message SuggestArticlesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestArticlesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SuggestArticlesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesResponse} SuggestArticlesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestArticlesResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SuggestArticlesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.articleAnswers && message.articleAnswers.length))
                                        message.articleAnswers = [];
                                    message.articleAnswers.push($root.google.cloud.dialogflow.v2.ArticleAnswer.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.latestMessage = reader.string();
                                    break;
                                case 3:
                                    message.contextSize = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SuggestArticlesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesResponse} SuggestArticlesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestArticlesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SuggestArticlesResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SuggestArticlesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.articleAnswers != null && message.hasOwnProperty("articleAnswers")) {
                                if (!Array.isArray(message.articleAnswers))
                                    return "articleAnswers: array expected";
                                for (var i = 0; i < message.articleAnswers.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.ArticleAnswer.verify(message.articleAnswers[i]);
                                    if (error)
                                        return "articleAnswers." + error;
                                }
                            }
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                if (!$util.isString(message.latestMessage))
                                    return "latestMessage: string expected";
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                if (!$util.isInteger(message.contextSize))
                                    return "contextSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a SuggestArticlesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SuggestArticlesResponse} SuggestArticlesResponse
                         */
                        SuggestArticlesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SuggestArticlesResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SuggestArticlesResponse();
                            if (object.articleAnswers) {
                                if (!Array.isArray(object.articleAnswers))
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestArticlesResponse.articleAnswers: array expected");
                                message.articleAnswers = [];
                                for (var i = 0; i < object.articleAnswers.length; ++i) {
                                    if (typeof object.articleAnswers[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.SuggestArticlesResponse.articleAnswers: object expected");
                                    message.articleAnswers[i] = $root.google.cloud.dialogflow.v2.ArticleAnswer.fromObject(object.articleAnswers[i]);
                                }
                            }
                            if (object.latestMessage != null)
                                message.latestMessage = String(object.latestMessage);
                            if (object.contextSize != null)
                                message.contextSize = object.contextSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SuggestArticlesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.SuggestArticlesResponse} message SuggestArticlesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SuggestArticlesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.articleAnswers = [];
                            if (options.defaults) {
                                object.latestMessage = "";
                                object.contextSize = 0;
                            }
                            if (message.articleAnswers && message.articleAnswers.length) {
                                object.articleAnswers = [];
                                for (var j = 0; j < message.articleAnswers.length; ++j)
                                    object.articleAnswers[j] = $root.google.cloud.dialogflow.v2.ArticleAnswer.toObject(message.articleAnswers[j], options);
                            }
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                object.latestMessage = message.latestMessage;
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                object.contextSize = message.contextSize;
                            return object;
                        };
    
                        /**
                         * Converts this SuggestArticlesResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SuggestArticlesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SuggestArticlesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SuggestArticlesResponse;
                    })();
    
                    v2.SuggestFaqAnswersRequest = (function() {
    
                        /**
                         * Properties of a SuggestFaqAnswersRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISuggestFaqAnswersRequest
                         * @property {string|null} [parent] SuggestFaqAnswersRequest parent
                         * @property {string|null} [latestMessage] SuggestFaqAnswersRequest latestMessage
                         * @property {number|null} [contextSize] SuggestFaqAnswersRequest contextSize
                         * @property {google.cloud.dialogflow.v2.IAssistQueryParameters|null} [assistQueryParams] SuggestFaqAnswersRequest assistQueryParams
                         */
    
                        /**
                         * Constructs a new SuggestFaqAnswersRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SuggestFaqAnswersRequest.
                         * @implements ISuggestFaqAnswersRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest=} [properties] Properties to set
                         */
                        function SuggestFaqAnswersRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SuggestFaqAnswersRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @instance
                         */
                        SuggestFaqAnswersRequest.prototype.parent = "";
    
                        /**
                         * SuggestFaqAnswersRequest latestMessage.
                         * @member {string} latestMessage
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @instance
                         */
                        SuggestFaqAnswersRequest.prototype.latestMessage = "";
    
                        /**
                         * SuggestFaqAnswersRequest contextSize.
                         * @member {number} contextSize
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @instance
                         */
                        SuggestFaqAnswersRequest.prototype.contextSize = 0;
    
                        /**
                         * SuggestFaqAnswersRequest assistQueryParams.
                         * @member {google.cloud.dialogflow.v2.IAssistQueryParameters|null|undefined} assistQueryParams
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @instance
                         */
                        SuggestFaqAnswersRequest.prototype.assistQueryParams = null;
    
                        /**
                         * Creates a new SuggestFaqAnswersRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersRequest} SuggestFaqAnswersRequest instance
                         */
                        SuggestFaqAnswersRequest.create = function create(properties) {
                            return new SuggestFaqAnswersRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SuggestFaqAnswersRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest} message SuggestFaqAnswersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestFaqAnswersRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.latestMessage != null && Object.hasOwnProperty.call(message, "latestMessage"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.latestMessage);
                            if (message.contextSize != null && Object.hasOwnProperty.call(message, "contextSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.contextSize);
                            if (message.assistQueryParams != null && Object.hasOwnProperty.call(message, "assistQueryParams"))
                                $root.google.cloud.dialogflow.v2.AssistQueryParameters.encode(message.assistQueryParams, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SuggestFaqAnswersRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersRequest} message SuggestFaqAnswersRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestFaqAnswersRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SuggestFaqAnswersRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersRequest} SuggestFaqAnswersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestFaqAnswersRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SuggestFaqAnswersRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 2:
                                    message.latestMessage = reader.string();
                                    break;
                                case 3:
                                    message.contextSize = reader.int32();
                                    break;
                                case 4:
                                    message.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SuggestFaqAnswersRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersRequest} SuggestFaqAnswersRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestFaqAnswersRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SuggestFaqAnswersRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SuggestFaqAnswersRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                if (!$util.isString(message.latestMessage))
                                    return "latestMessage: string expected";
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                if (!$util.isInteger(message.contextSize))
                                    return "contextSize: integer expected";
                            if (message.assistQueryParams != null && message.hasOwnProperty("assistQueryParams")) {
                                var error = $root.google.cloud.dialogflow.v2.AssistQueryParameters.verify(message.assistQueryParams);
                                if (error)
                                    return "assistQueryParams." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SuggestFaqAnswersRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersRequest} SuggestFaqAnswersRequest
                         */
                        SuggestFaqAnswersRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SuggestFaqAnswersRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SuggestFaqAnswersRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.latestMessage != null)
                                message.latestMessage = String(object.latestMessage);
                            if (object.contextSize != null)
                                message.contextSize = object.contextSize | 0;
                            if (object.assistQueryParams != null) {
                                if (typeof object.assistQueryParams !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestFaqAnswersRequest.assistQueryParams: object expected");
                                message.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.fromObject(object.assistQueryParams);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SuggestFaqAnswersRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.SuggestFaqAnswersRequest} message SuggestFaqAnswersRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SuggestFaqAnswersRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.latestMessage = "";
                                object.contextSize = 0;
                                object.assistQueryParams = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                object.latestMessage = message.latestMessage;
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                object.contextSize = message.contextSize;
                            if (message.assistQueryParams != null && message.hasOwnProperty("assistQueryParams"))
                                object.assistQueryParams = $root.google.cloud.dialogflow.v2.AssistQueryParameters.toObject(message.assistQueryParams, options);
                            return object;
                        };
    
                        /**
                         * Converts this SuggestFaqAnswersRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SuggestFaqAnswersRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SuggestFaqAnswersRequest;
                    })();
    
                    v2.SuggestFaqAnswersResponse = (function() {
    
                        /**
                         * Properties of a SuggestFaqAnswersResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISuggestFaqAnswersResponse
                         * @property {Array.<google.cloud.dialogflow.v2.IFaqAnswer>|null} [faqAnswers] SuggestFaqAnswersResponse faqAnswers
                         * @property {string|null} [latestMessage] SuggestFaqAnswersResponse latestMessage
                         * @property {number|null} [contextSize] SuggestFaqAnswersResponse contextSize
                         */
    
                        /**
                         * Constructs a new SuggestFaqAnswersResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SuggestFaqAnswersResponse.
                         * @implements ISuggestFaqAnswersResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse=} [properties] Properties to set
                         */
                        function SuggestFaqAnswersResponse(properties) {
                            this.faqAnswers = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SuggestFaqAnswersResponse faqAnswers.
                         * @member {Array.<google.cloud.dialogflow.v2.IFaqAnswer>} faqAnswers
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @instance
                         */
                        SuggestFaqAnswersResponse.prototype.faqAnswers = $util.emptyArray;
    
                        /**
                         * SuggestFaqAnswersResponse latestMessage.
                         * @member {string} latestMessage
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @instance
                         */
                        SuggestFaqAnswersResponse.prototype.latestMessage = "";
    
                        /**
                         * SuggestFaqAnswersResponse contextSize.
                         * @member {number} contextSize
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @instance
                         */
                        SuggestFaqAnswersResponse.prototype.contextSize = 0;
    
                        /**
                         * Creates a new SuggestFaqAnswersResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersResponse} SuggestFaqAnswersResponse instance
                         */
                        SuggestFaqAnswersResponse.create = function create(properties) {
                            return new SuggestFaqAnswersResponse(properties);
                        };
    
                        /**
                         * Encodes the specified SuggestFaqAnswersResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse} message SuggestFaqAnswersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestFaqAnswersResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.faqAnswers != null && message.faqAnswers.length)
                                for (var i = 0; i < message.faqAnswers.length; ++i)
                                    $root.google.cloud.dialogflow.v2.FaqAnswer.encode(message.faqAnswers[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.latestMessage != null && Object.hasOwnProperty.call(message, "latestMessage"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.latestMessage);
                            if (message.contextSize != null && Object.hasOwnProperty.call(message, "contextSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.contextSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SuggestFaqAnswersResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse} message SuggestFaqAnswersResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestFaqAnswersResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SuggestFaqAnswersResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersResponse} SuggestFaqAnswersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestFaqAnswersResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.faqAnswers && message.faqAnswers.length))
                                        message.faqAnswers = [];
                                    message.faqAnswers.push($root.google.cloud.dialogflow.v2.FaqAnswer.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.latestMessage = reader.string();
                                    break;
                                case 3:
                                    message.contextSize = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SuggestFaqAnswersResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersResponse} SuggestFaqAnswersResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestFaqAnswersResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SuggestFaqAnswersResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SuggestFaqAnswersResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.faqAnswers != null && message.hasOwnProperty("faqAnswers")) {
                                if (!Array.isArray(message.faqAnswers))
                                    return "faqAnswers: array expected";
                                for (var i = 0; i < message.faqAnswers.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.FaqAnswer.verify(message.faqAnswers[i]);
                                    if (error)
                                        return "faqAnswers." + error;
                                }
                            }
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                if (!$util.isString(message.latestMessage))
                                    return "latestMessage: string expected";
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                if (!$util.isInteger(message.contextSize))
                                    return "contextSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a SuggestFaqAnswersResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SuggestFaqAnswersResponse} SuggestFaqAnswersResponse
                         */
                        SuggestFaqAnswersResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse();
                            if (object.faqAnswers) {
                                if (!Array.isArray(object.faqAnswers))
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.faqAnswers: array expected");
                                message.faqAnswers = [];
                                for (var i = 0; i < object.faqAnswers.length; ++i) {
                                    if (typeof object.faqAnswers[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.faqAnswers: object expected");
                                    message.faqAnswers[i] = $root.google.cloud.dialogflow.v2.FaqAnswer.fromObject(object.faqAnswers[i]);
                                }
                            }
                            if (object.latestMessage != null)
                                message.latestMessage = String(object.latestMessage);
                            if (object.contextSize != null)
                                message.contextSize = object.contextSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SuggestFaqAnswersResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.SuggestFaqAnswersResponse} message SuggestFaqAnswersResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SuggestFaqAnswersResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.faqAnswers = [];
                            if (options.defaults) {
                                object.latestMessage = "";
                                object.contextSize = 0;
                            }
                            if (message.faqAnswers && message.faqAnswers.length) {
                                object.faqAnswers = [];
                                for (var j = 0; j < message.faqAnswers.length; ++j)
                                    object.faqAnswers[j] = $root.google.cloud.dialogflow.v2.FaqAnswer.toObject(message.faqAnswers[j], options);
                            }
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                object.latestMessage = message.latestMessage;
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                object.contextSize = message.contextSize;
                            return object;
                        };
    
                        /**
                         * Converts this SuggestFaqAnswersResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SuggestFaqAnswersResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SuggestFaqAnswersResponse;
                    })();
    
                    v2.SuggestSmartRepliesRequest = (function() {
    
                        /**
                         * Properties of a SuggestSmartRepliesRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISuggestSmartRepliesRequest
                         * @property {string|null} [parent] SuggestSmartRepliesRequest parent
                         * @property {google.cloud.dialogflow.v2.ITextInput|null} [currentTextInput] SuggestSmartRepliesRequest currentTextInput
                         * @property {string|null} [latestMessage] SuggestSmartRepliesRequest latestMessage
                         * @property {number|null} [contextSize] SuggestSmartRepliesRequest contextSize
                         */
    
                        /**
                         * Constructs a new SuggestSmartRepliesRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SuggestSmartRepliesRequest.
                         * @implements ISuggestSmartRepliesRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest=} [properties] Properties to set
                         */
                        function SuggestSmartRepliesRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SuggestSmartRepliesRequest parent.
                         * @member {string} parent
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @instance
                         */
                        SuggestSmartRepliesRequest.prototype.parent = "";
    
                        /**
                         * SuggestSmartRepliesRequest currentTextInput.
                         * @member {google.cloud.dialogflow.v2.ITextInput|null|undefined} currentTextInput
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @instance
                         */
                        SuggestSmartRepliesRequest.prototype.currentTextInput = null;
    
                        /**
                         * SuggestSmartRepliesRequest latestMessage.
                         * @member {string} latestMessage
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @instance
                         */
                        SuggestSmartRepliesRequest.prototype.latestMessage = "";
    
                        /**
                         * SuggestSmartRepliesRequest contextSize.
                         * @member {number} contextSize
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @instance
                         */
                        SuggestSmartRepliesRequest.prototype.contextSize = 0;
    
                        /**
                         * Creates a new SuggestSmartRepliesRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesRequest} SuggestSmartRepliesRequest instance
                         */
                        SuggestSmartRepliesRequest.create = function create(properties) {
                            return new SuggestSmartRepliesRequest(properties);
                        };
    
                        /**
                         * Encodes the specified SuggestSmartRepliesRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest} message SuggestSmartRepliesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestSmartRepliesRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                            if (message.latestMessage != null && Object.hasOwnProperty.call(message, "latestMessage"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.latestMessage);
                            if (message.contextSize != null && Object.hasOwnProperty.call(message, "contextSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.contextSize);
                            if (message.currentTextInput != null && Object.hasOwnProperty.call(message, "currentTextInput"))
                                $root.google.cloud.dialogflow.v2.TextInput.encode(message.currentTextInput, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SuggestSmartRepliesRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesRequest} message SuggestSmartRepliesRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestSmartRepliesRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SuggestSmartRepliesRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesRequest} SuggestSmartRepliesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestSmartRepliesRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SuggestSmartRepliesRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.parent = reader.string();
                                    break;
                                case 4:
                                    message.currentTextInput = $root.google.cloud.dialogflow.v2.TextInput.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.latestMessage = reader.string();
                                    break;
                                case 3:
                                    message.contextSize = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SuggestSmartRepliesRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesRequest} SuggestSmartRepliesRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestSmartRepliesRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SuggestSmartRepliesRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SuggestSmartRepliesRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                if (!$util.isString(message.parent))
                                    return "parent: string expected";
                            if (message.currentTextInput != null && message.hasOwnProperty("currentTextInput")) {
                                var error = $root.google.cloud.dialogflow.v2.TextInput.verify(message.currentTextInput);
                                if (error)
                                    return "currentTextInput." + error;
                            }
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                if (!$util.isString(message.latestMessage))
                                    return "latestMessage: string expected";
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                if (!$util.isInteger(message.contextSize))
                                    return "contextSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a SuggestSmartRepliesRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesRequest} SuggestSmartRepliesRequest
                         */
                        SuggestSmartRepliesRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SuggestSmartRepliesRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SuggestSmartRepliesRequest();
                            if (object.parent != null)
                                message.parent = String(object.parent);
                            if (object.currentTextInput != null) {
                                if (typeof object.currentTextInput !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.currentTextInput: object expected");
                                message.currentTextInput = $root.google.cloud.dialogflow.v2.TextInput.fromObject(object.currentTextInput);
                            }
                            if (object.latestMessage != null)
                                message.latestMessage = String(object.latestMessage);
                            if (object.contextSize != null)
                                message.contextSize = object.contextSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SuggestSmartRepliesRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.SuggestSmartRepliesRequest} message SuggestSmartRepliesRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SuggestSmartRepliesRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.parent = "";
                                object.latestMessage = "";
                                object.contextSize = 0;
                                object.currentTextInput = null;
                            }
                            if (message.parent != null && message.hasOwnProperty("parent"))
                                object.parent = message.parent;
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                object.latestMessage = message.latestMessage;
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                object.contextSize = message.contextSize;
                            if (message.currentTextInput != null && message.hasOwnProperty("currentTextInput"))
                                object.currentTextInput = $root.google.cloud.dialogflow.v2.TextInput.toObject(message.currentTextInput, options);
                            return object;
                        };
    
                        /**
                         * Converts this SuggestSmartRepliesRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SuggestSmartRepliesRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SuggestSmartRepliesRequest;
                    })();
    
                    v2.SuggestSmartRepliesResponse = (function() {
    
                        /**
                         * Properties of a SuggestSmartRepliesResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISuggestSmartRepliesResponse
                         * @property {Array.<google.cloud.dialogflow.v2.ISmartReplyAnswer>|null} [smartReplyAnswers] SuggestSmartRepliesResponse smartReplyAnswers
                         * @property {string|null} [latestMessage] SuggestSmartRepliesResponse latestMessage
                         * @property {number|null} [contextSize] SuggestSmartRepliesResponse contextSize
                         */
    
                        /**
                         * Constructs a new SuggestSmartRepliesResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SuggestSmartRepliesResponse.
                         * @implements ISuggestSmartRepliesResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse=} [properties] Properties to set
                         */
                        function SuggestSmartRepliesResponse(properties) {
                            this.smartReplyAnswers = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SuggestSmartRepliesResponse smartReplyAnswers.
                         * @member {Array.<google.cloud.dialogflow.v2.ISmartReplyAnswer>} smartReplyAnswers
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @instance
                         */
                        SuggestSmartRepliesResponse.prototype.smartReplyAnswers = $util.emptyArray;
    
                        /**
                         * SuggestSmartRepliesResponse latestMessage.
                         * @member {string} latestMessage
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @instance
                         */
                        SuggestSmartRepliesResponse.prototype.latestMessage = "";
    
                        /**
                         * SuggestSmartRepliesResponse contextSize.
                         * @member {number} contextSize
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @instance
                         */
                        SuggestSmartRepliesResponse.prototype.contextSize = 0;
    
                        /**
                         * Creates a new SuggestSmartRepliesResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesResponse} SuggestSmartRepliesResponse instance
                         */
                        SuggestSmartRepliesResponse.create = function create(properties) {
                            return new SuggestSmartRepliesResponse(properties);
                        };
    
                        /**
                         * Encodes the specified SuggestSmartRepliesResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse} message SuggestSmartRepliesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestSmartRepliesResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.smartReplyAnswers != null && message.smartReplyAnswers.length)
                                for (var i = 0; i < message.smartReplyAnswers.length; ++i)
                                    $root.google.cloud.dialogflow.v2.SmartReplyAnswer.encode(message.smartReplyAnswers[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.latestMessage != null && Object.hasOwnProperty.call(message, "latestMessage"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.latestMessage);
                            if (message.contextSize != null && Object.hasOwnProperty.call(message, "contextSize"))
                                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.contextSize);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SuggestSmartRepliesResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse} message SuggestSmartRepliesResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestSmartRepliesResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SuggestSmartRepliesResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesResponse} SuggestSmartRepliesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestSmartRepliesResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.smartReplyAnswers && message.smartReplyAnswers.length))
                                        message.smartReplyAnswers = [];
                                    message.smartReplyAnswers.push($root.google.cloud.dialogflow.v2.SmartReplyAnswer.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.latestMessage = reader.string();
                                    break;
                                case 3:
                                    message.contextSize = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SuggestSmartRepliesResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesResponse} SuggestSmartRepliesResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestSmartRepliesResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SuggestSmartRepliesResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SuggestSmartRepliesResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.smartReplyAnswers != null && message.hasOwnProperty("smartReplyAnswers")) {
                                if (!Array.isArray(message.smartReplyAnswers))
                                    return "smartReplyAnswers: array expected";
                                for (var i = 0; i < message.smartReplyAnswers.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.SmartReplyAnswer.verify(message.smartReplyAnswers[i]);
                                    if (error)
                                        return "smartReplyAnswers." + error;
                                }
                            }
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                if (!$util.isString(message.latestMessage))
                                    return "latestMessage: string expected";
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                if (!$util.isInteger(message.contextSize))
                                    return "contextSize: integer expected";
                            return null;
                        };
    
                        /**
                         * Creates a SuggestSmartRepliesResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SuggestSmartRepliesResponse} SuggestSmartRepliesResponse
                         */
                        SuggestSmartRepliesResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse();
                            if (object.smartReplyAnswers) {
                                if (!Array.isArray(object.smartReplyAnswers))
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.smartReplyAnswers: array expected");
                                message.smartReplyAnswers = [];
                                for (var i = 0; i < object.smartReplyAnswers.length; ++i) {
                                    if (typeof object.smartReplyAnswers[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.smartReplyAnswers: object expected");
                                    message.smartReplyAnswers[i] = $root.google.cloud.dialogflow.v2.SmartReplyAnswer.fromObject(object.smartReplyAnswers[i]);
                                }
                            }
                            if (object.latestMessage != null)
                                message.latestMessage = String(object.latestMessage);
                            if (object.contextSize != null)
                                message.contextSize = object.contextSize | 0;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SuggestSmartRepliesResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.SuggestSmartRepliesResponse} message SuggestSmartRepliesResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SuggestSmartRepliesResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.smartReplyAnswers = [];
                            if (options.defaults) {
                                object.latestMessage = "";
                                object.contextSize = 0;
                            }
                            if (message.smartReplyAnswers && message.smartReplyAnswers.length) {
                                object.smartReplyAnswers = [];
                                for (var j = 0; j < message.smartReplyAnswers.length; ++j)
                                    object.smartReplyAnswers[j] = $root.google.cloud.dialogflow.v2.SmartReplyAnswer.toObject(message.smartReplyAnswers[j], options);
                            }
                            if (message.latestMessage != null && message.hasOwnProperty("latestMessage"))
                                object.latestMessage = message.latestMessage;
                            if (message.contextSize != null && message.hasOwnProperty("contextSize"))
                                object.contextSize = message.contextSize;
                            return object;
                        };
    
                        /**
                         * Converts this SuggestSmartRepliesResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SuggestSmartRepliesResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SuggestSmartRepliesResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SuggestSmartRepliesResponse;
                    })();
    
                    v2.OutputAudio = (function() {
    
                        /**
                         * Properties of an OutputAudio.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IOutputAudio
                         * @property {google.cloud.dialogflow.v2.IOutputAudioConfig|null} [config] OutputAudio config
                         * @property {Uint8Array|null} [audio] OutputAudio audio
                         */
    
                        /**
                         * Constructs a new OutputAudio.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an OutputAudio.
                         * @implements IOutputAudio
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IOutputAudio=} [properties] Properties to set
                         */
                        function OutputAudio(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OutputAudio config.
                         * @member {google.cloud.dialogflow.v2.IOutputAudioConfig|null|undefined} config
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @instance
                         */
                        OutputAudio.prototype.config = null;
    
                        /**
                         * OutputAudio audio.
                         * @member {Uint8Array} audio
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @instance
                         */
                        OutputAudio.prototype.audio = $util.newBuffer([]);
    
                        /**
                         * Creates a new OutputAudio instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {google.cloud.dialogflow.v2.IOutputAudio=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.OutputAudio} OutputAudio instance
                         */
                        OutputAudio.create = function create(properties) {
                            return new OutputAudio(properties);
                        };
    
                        /**
                         * Encodes the specified OutputAudio message. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudio.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {google.cloud.dialogflow.v2.IOutputAudio} message OutputAudio message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OutputAudio.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.config != null && Object.hasOwnProperty.call(message, "config"))
                                $root.google.cloud.dialogflow.v2.OutputAudioConfig.encode(message.config, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.audio != null && Object.hasOwnProperty.call(message, "audio"))
                                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.audio);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OutputAudio message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudio.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {google.cloud.dialogflow.v2.IOutputAudio} message OutputAudio message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OutputAudio.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OutputAudio message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.OutputAudio} OutputAudio
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OutputAudio.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.OutputAudio();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.config = $root.google.cloud.dialogflow.v2.OutputAudioConfig.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.audio = reader.bytes();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OutputAudio message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.OutputAudio} OutputAudio
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OutputAudio.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OutputAudio message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OutputAudio.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.config != null && message.hasOwnProperty("config")) {
                                var error = $root.google.cloud.dialogflow.v2.OutputAudioConfig.verify(message.config);
                                if (error)
                                    return "config." + error;
                            }
                            if (message.audio != null && message.hasOwnProperty("audio"))
                                if (!(message.audio && typeof message.audio.length === "number" || $util.isString(message.audio)))
                                    return "audio: buffer expected";
                            return null;
                        };
    
                        /**
                         * Creates an OutputAudio message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.OutputAudio} OutputAudio
                         */
                        OutputAudio.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.OutputAudio)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.OutputAudio();
                            if (object.config != null) {
                                if (typeof object.config !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.OutputAudio.config: object expected");
                                message.config = $root.google.cloud.dialogflow.v2.OutputAudioConfig.fromObject(object.config);
                            }
                            if (object.audio != null)
                                if (typeof object.audio === "string")
                                    $util.base64.decode(object.audio, message.audio = $util.newBuffer($util.base64.length(object.audio)), 0);
                                else if (object.audio.length)
                                    message.audio = object.audio;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OutputAudio message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @static
                         * @param {google.cloud.dialogflow.v2.OutputAudio} message OutputAudio
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OutputAudio.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.config = null;
                                if (options.bytes === String)
                                    object.audio = "";
                                else {
                                    object.audio = [];
                                    if (options.bytes !== Array)
                                        object.audio = $util.newBuffer(object.audio);
                                }
                            }
                            if (message.config != null && message.hasOwnProperty("config"))
                                object.config = $root.google.cloud.dialogflow.v2.OutputAudioConfig.toObject(message.config, options);
                            if (message.audio != null && message.hasOwnProperty("audio"))
                                object.audio = options.bytes === String ? $util.base64.encode(message.audio, 0, message.audio.length) : options.bytes === Array ? Array.prototype.slice.call(message.audio) : message.audio;
                            return object;
                        };
    
                        /**
                         * Converts this OutputAudio to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.OutputAudio
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OutputAudio.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return OutputAudio;
                    })();
    
                    v2.AutomatedAgentReply = (function() {
    
                        /**
                         * Properties of an AutomatedAgentReply.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAutomatedAgentReply
                         * @property {google.cloud.dialogflow.v2.IDetectIntentResponse|null} [detectIntentResponse] AutomatedAgentReply detectIntentResponse
                         * @property {google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType|null} [automatedAgentReplyType] AutomatedAgentReply automatedAgentReplyType
                         * @property {boolean|null} [allowCancellation] AutomatedAgentReply allowCancellation
                         */
    
                        /**
                         * Constructs a new AutomatedAgentReply.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AutomatedAgentReply.
                         * @implements IAutomatedAgentReply
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAutomatedAgentReply=} [properties] Properties to set
                         */
                        function AutomatedAgentReply(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AutomatedAgentReply detectIntentResponse.
                         * @member {google.cloud.dialogflow.v2.IDetectIntentResponse|null|undefined} detectIntentResponse
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @instance
                         */
                        AutomatedAgentReply.prototype.detectIntentResponse = null;
    
                        /**
                         * AutomatedAgentReply automatedAgentReplyType.
                         * @member {google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType} automatedAgentReplyType
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @instance
                         */
                        AutomatedAgentReply.prototype.automatedAgentReplyType = 0;
    
                        /**
                         * AutomatedAgentReply allowCancellation.
                         * @member {boolean} allowCancellation
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @instance
                         */
                        AutomatedAgentReply.prototype.allowCancellation = false;
    
                        /**
                         * Creates a new AutomatedAgentReply instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAutomatedAgentReply=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AutomatedAgentReply} AutomatedAgentReply instance
                         */
                        AutomatedAgentReply.create = function create(properties) {
                            return new AutomatedAgentReply(properties);
                        };
    
                        /**
                         * Encodes the specified AutomatedAgentReply message. Does not implicitly {@link google.cloud.dialogflow.v2.AutomatedAgentReply.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAutomatedAgentReply} message AutomatedAgentReply message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AutomatedAgentReply.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.detectIntentResponse != null && Object.hasOwnProperty.call(message, "detectIntentResponse"))
                                $root.google.cloud.dialogflow.v2.DetectIntentResponse.encode(message.detectIntentResponse, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.automatedAgentReplyType != null && Object.hasOwnProperty.call(message, "automatedAgentReplyType"))
                                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.automatedAgentReplyType);
                            if (message.allowCancellation != null && Object.hasOwnProperty.call(message, "allowCancellation"))
                                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.allowCancellation);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AutomatedAgentReply message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AutomatedAgentReply.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAutomatedAgentReply} message AutomatedAgentReply message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AutomatedAgentReply.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AutomatedAgentReply message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AutomatedAgentReply} AutomatedAgentReply
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AutomatedAgentReply.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AutomatedAgentReply();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.detectIntentResponse = $root.google.cloud.dialogflow.v2.DetectIntentResponse.decode(reader, reader.uint32());
                                    break;
                                case 7:
                                    message.automatedAgentReplyType = reader.int32();
                                    break;
                                case 8:
                                    message.allowCancellation = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AutomatedAgentReply message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AutomatedAgentReply} AutomatedAgentReply
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AutomatedAgentReply.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AutomatedAgentReply message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AutomatedAgentReply.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.detectIntentResponse != null && message.hasOwnProperty("detectIntentResponse")) {
                                var error = $root.google.cloud.dialogflow.v2.DetectIntentResponse.verify(message.detectIntentResponse);
                                if (error)
                                    return "detectIntentResponse." + error;
                            }
                            if (message.automatedAgentReplyType != null && message.hasOwnProperty("automatedAgentReplyType"))
                                switch (message.automatedAgentReplyType) {
                                default:
                                    return "automatedAgentReplyType: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                    break;
                                }
                            if (message.allowCancellation != null && message.hasOwnProperty("allowCancellation"))
                                if (typeof message.allowCancellation !== "boolean")
                                    return "allowCancellation: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates an AutomatedAgentReply message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AutomatedAgentReply} AutomatedAgentReply
                         */
                        AutomatedAgentReply.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AutomatedAgentReply)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AutomatedAgentReply();
                            if (object.detectIntentResponse != null) {
                                if (typeof object.detectIntentResponse !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AutomatedAgentReply.detectIntentResponse: object expected");
                                message.detectIntentResponse = $root.google.cloud.dialogflow.v2.DetectIntentResponse.fromObject(object.detectIntentResponse);
                            }
                            switch (object.automatedAgentReplyType) {
                            case "AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED":
                            case 0:
                                message.automatedAgentReplyType = 0;
                                break;
                            case "PARTIAL":
                            case 1:
                                message.automatedAgentReplyType = 1;
                                break;
                            case "FINAL":
                            case 2:
                                message.automatedAgentReplyType = 2;
                                break;
                            }
                            if (object.allowCancellation != null)
                                message.allowCancellation = Boolean(object.allowCancellation);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AutomatedAgentReply message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @static
                         * @param {google.cloud.dialogflow.v2.AutomatedAgentReply} message AutomatedAgentReply
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AutomatedAgentReply.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.detectIntentResponse = null;
                                object.automatedAgentReplyType = options.enums === String ? "AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED" : 0;
                                object.allowCancellation = false;
                            }
                            if (message.detectIntentResponse != null && message.hasOwnProperty("detectIntentResponse"))
                                object.detectIntentResponse = $root.google.cloud.dialogflow.v2.DetectIntentResponse.toObject(message.detectIntentResponse, options);
                            if (message.automatedAgentReplyType != null && message.hasOwnProperty("automatedAgentReplyType"))
                                object.automatedAgentReplyType = options.enums === String ? $root.google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType[message.automatedAgentReplyType] : message.automatedAgentReplyType;
                            if (message.allowCancellation != null && message.hasOwnProperty("allowCancellation"))
                                object.allowCancellation = message.allowCancellation;
                            return object;
                        };
    
                        /**
                         * Converts this AutomatedAgentReply to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AutomatedAgentReply
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AutomatedAgentReply.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * AutomatedAgentReplyType enum.
                         * @name google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType
                         * @enum {number}
                         * @property {number} AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED=0 AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED value
                         * @property {number} PARTIAL=1 PARTIAL value
                         * @property {number} FINAL=2 FINAL value
                         */
                        AutomatedAgentReply.AutomatedAgentReplyType = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED"] = 0;
                            values[valuesById[1] = "PARTIAL"] = 1;
                            values[valuesById[2] = "FINAL"] = 2;
                            return values;
                        })();
    
                        return AutomatedAgentReply;
                    })();
    
                    v2.ArticleAnswer = (function() {
    
                        /**
                         * Properties of an ArticleAnswer.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IArticleAnswer
                         * @property {string|null} [title] ArticleAnswer title
                         * @property {string|null} [uri] ArticleAnswer uri
                         * @property {Array.<string>|null} [snippets] ArticleAnswer snippets
                         * @property {number|null} [confidence] ArticleAnswer confidence
                         * @property {Object.<string,string>|null} [metadata] ArticleAnswer metadata
                         * @property {string|null} [answerRecord] ArticleAnswer answerRecord
                         */
    
                        /**
                         * Constructs a new ArticleAnswer.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an ArticleAnswer.
                         * @implements IArticleAnswer
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IArticleAnswer=} [properties] Properties to set
                         */
                        function ArticleAnswer(properties) {
                            this.snippets = [];
                            this.metadata = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ArticleAnswer title.
                         * @member {string} title
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @instance
                         */
                        ArticleAnswer.prototype.title = "";
    
                        /**
                         * ArticleAnswer uri.
                         * @member {string} uri
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @instance
                         */
                        ArticleAnswer.prototype.uri = "";
    
                        /**
                         * ArticleAnswer snippets.
                         * @member {Array.<string>} snippets
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @instance
                         */
                        ArticleAnswer.prototype.snippets = $util.emptyArray;
    
                        /**
                         * ArticleAnswer confidence.
                         * @member {number} confidence
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @instance
                         */
                        ArticleAnswer.prototype.confidence = 0;
    
                        /**
                         * ArticleAnswer metadata.
                         * @member {Object.<string,string>} metadata
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @instance
                         */
                        ArticleAnswer.prototype.metadata = $util.emptyObject;
    
                        /**
                         * ArticleAnswer answerRecord.
                         * @member {string} answerRecord
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @instance
                         */
                        ArticleAnswer.prototype.answerRecord = "";
    
                        /**
                         * Creates a new ArticleAnswer instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.IArticleAnswer=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.ArticleAnswer} ArticleAnswer instance
                         */
                        ArticleAnswer.create = function create(properties) {
                            return new ArticleAnswer(properties);
                        };
    
                        /**
                         * Encodes the specified ArticleAnswer message. Does not implicitly {@link google.cloud.dialogflow.v2.ArticleAnswer.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.IArticleAnswer} message ArticleAnswer message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ArticleAnswer.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
                            if (message.uri != null && Object.hasOwnProperty.call(message, "uri"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.uri);
                            if (message.snippets != null && message.snippets.length)
                                for (var i = 0; i < message.snippets.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.snippets[i]);
                            if (message.confidence != null && Object.hasOwnProperty.call(message, "confidence"))
                                writer.uint32(/* id 4, wireType 5 =*/37).float(message.confidence);
                            if (message.metadata != null && Object.hasOwnProperty.call(message, "metadata"))
                                for (var keys = Object.keys(message.metadata), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.metadata[keys[i]]).ldelim();
                            if (message.answerRecord != null && Object.hasOwnProperty.call(message, "answerRecord"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.answerRecord);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ArticleAnswer message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.ArticleAnswer.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.IArticleAnswer} message ArticleAnswer message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ArticleAnswer.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an ArticleAnswer message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.ArticleAnswer} ArticleAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ArticleAnswer.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.ArticleAnswer(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.title = reader.string();
                                    break;
                                case 2:
                                    message.uri = reader.string();
                                    break;
                                case 3:
                                    if (!(message.snippets && message.snippets.length))
                                        message.snippets = [];
                                    message.snippets.push(reader.string());
                                    break;
                                case 4:
                                    message.confidence = reader.float();
                                    break;
                                case 5:
                                    if (message.metadata === $util.emptyObject)
                                        message.metadata = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.metadata[key] = value;
                                    break;
                                case 6:
                                    message.answerRecord = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an ArticleAnswer message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.ArticleAnswer} ArticleAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ArticleAnswer.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an ArticleAnswer message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ArticleAnswer.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.title != null && message.hasOwnProperty("title"))
                                if (!$util.isString(message.title))
                                    return "title: string expected";
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                if (!$util.isString(message.uri))
                                    return "uri: string expected";
                            if (message.snippets != null && message.hasOwnProperty("snippets")) {
                                if (!Array.isArray(message.snippets))
                                    return "snippets: array expected";
                                for (var i = 0; i < message.snippets.length; ++i)
                                    if (!$util.isString(message.snippets[i]))
                                        return "snippets: string[] expected";
                            }
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                if (typeof message.confidence !== "number")
                                    return "confidence: number expected";
                            if (message.metadata != null && message.hasOwnProperty("metadata")) {
                                if (!$util.isObject(message.metadata))
                                    return "metadata: object expected";
                                var key = Object.keys(message.metadata);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.metadata[key[i]]))
                                        return "metadata: string{k:string} expected";
                            }
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord"))
                                if (!$util.isString(message.answerRecord))
                                    return "answerRecord: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an ArticleAnswer message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.ArticleAnswer} ArticleAnswer
                         */
                        ArticleAnswer.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.ArticleAnswer)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.ArticleAnswer();
                            if (object.title != null)
                                message.title = String(object.title);
                            if (object.uri != null)
                                message.uri = String(object.uri);
                            if (object.snippets) {
                                if (!Array.isArray(object.snippets))
                                    throw TypeError(".google.cloud.dialogflow.v2.ArticleAnswer.snippets: array expected");
                                message.snippets = [];
                                for (var i = 0; i < object.snippets.length; ++i)
                                    message.snippets[i] = String(object.snippets[i]);
                            }
                            if (object.confidence != null)
                                message.confidence = Number(object.confidence);
                            if (object.metadata) {
                                if (typeof object.metadata !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.ArticleAnswer.metadata: object expected");
                                message.metadata = {};
                                for (var keys = Object.keys(object.metadata), i = 0; i < keys.length; ++i)
                                    message.metadata[keys[i]] = String(object.metadata[keys[i]]);
                            }
                            if (object.answerRecord != null)
                                message.answerRecord = String(object.answerRecord);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an ArticleAnswer message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.ArticleAnswer} message ArticleAnswer
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ArticleAnswer.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.snippets = [];
                            if (options.objects || options.defaults)
                                object.metadata = {};
                            if (options.defaults) {
                                object.title = "";
                                object.uri = "";
                                object.confidence = 0;
                                object.answerRecord = "";
                            }
                            if (message.title != null && message.hasOwnProperty("title"))
                                object.title = message.title;
                            if (message.uri != null && message.hasOwnProperty("uri"))
                                object.uri = message.uri;
                            if (message.snippets && message.snippets.length) {
                                object.snippets = [];
                                for (var j = 0; j < message.snippets.length; ++j)
                                    object.snippets[j] = message.snippets[j];
                            }
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                object.confidence = options.json && !isFinite(message.confidence) ? String(message.confidence) : message.confidence;
                            var keys2;
                            if (message.metadata && (keys2 = Object.keys(message.metadata)).length) {
                                object.metadata = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.metadata[keys2[j]] = message.metadata[keys2[j]];
                            }
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord"))
                                object.answerRecord = message.answerRecord;
                            return object;
                        };
    
                        /**
                         * Converts this ArticleAnswer to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.ArticleAnswer
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ArticleAnswer.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return ArticleAnswer;
                    })();
    
                    v2.FaqAnswer = (function() {
    
                        /**
                         * Properties of a FaqAnswer.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IFaqAnswer
                         * @property {string|null} [answer] FaqAnswer answer
                         * @property {number|null} [confidence] FaqAnswer confidence
                         * @property {string|null} [question] FaqAnswer question
                         * @property {string|null} [source] FaqAnswer source
                         * @property {Object.<string,string>|null} [metadata] FaqAnswer metadata
                         * @property {string|null} [answerRecord] FaqAnswer answerRecord
                         */
    
                        /**
                         * Constructs a new FaqAnswer.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a FaqAnswer.
                         * @implements IFaqAnswer
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IFaqAnswer=} [properties] Properties to set
                         */
                        function FaqAnswer(properties) {
                            this.metadata = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * FaqAnswer answer.
                         * @member {string} answer
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @instance
                         */
                        FaqAnswer.prototype.answer = "";
    
                        /**
                         * FaqAnswer confidence.
                         * @member {number} confidence
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @instance
                         */
                        FaqAnswer.prototype.confidence = 0;
    
                        /**
                         * FaqAnswer question.
                         * @member {string} question
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @instance
                         */
                        FaqAnswer.prototype.question = "";
    
                        /**
                         * FaqAnswer source.
                         * @member {string} source
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @instance
                         */
                        FaqAnswer.prototype.source = "";
    
                        /**
                         * FaqAnswer metadata.
                         * @member {Object.<string,string>} metadata
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @instance
                         */
                        FaqAnswer.prototype.metadata = $util.emptyObject;
    
                        /**
                         * FaqAnswer answerRecord.
                         * @member {string} answerRecord
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @instance
                         */
                        FaqAnswer.prototype.answerRecord = "";
    
                        /**
                         * Creates a new FaqAnswer instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.IFaqAnswer=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.FaqAnswer} FaqAnswer instance
                         */
                        FaqAnswer.create = function create(properties) {
                            return new FaqAnswer(properties);
                        };
    
                        /**
                         * Encodes the specified FaqAnswer message. Does not implicitly {@link google.cloud.dialogflow.v2.FaqAnswer.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.IFaqAnswer} message FaqAnswer message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FaqAnswer.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.answer != null && Object.hasOwnProperty.call(message, "answer"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.answer);
                            if (message.confidence != null && Object.hasOwnProperty.call(message, "confidence"))
                                writer.uint32(/* id 2, wireType 5 =*/21).float(message.confidence);
                            if (message.question != null && Object.hasOwnProperty.call(message, "question"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.question);
                            if (message.source != null && Object.hasOwnProperty.call(message, "source"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.source);
                            if (message.metadata != null && Object.hasOwnProperty.call(message, "metadata"))
                                for (var keys = Object.keys(message.metadata), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.metadata[keys[i]]).ldelim();
                            if (message.answerRecord != null && Object.hasOwnProperty.call(message, "answerRecord"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.answerRecord);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified FaqAnswer message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.FaqAnswer.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.IFaqAnswer} message FaqAnswer message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FaqAnswer.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a FaqAnswer message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.FaqAnswer} FaqAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FaqAnswer.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.FaqAnswer(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.answer = reader.string();
                                    break;
                                case 2:
                                    message.confidence = reader.float();
                                    break;
                                case 3:
                                    message.question = reader.string();
                                    break;
                                case 4:
                                    message.source = reader.string();
                                    break;
                                case 5:
                                    if (message.metadata === $util.emptyObject)
                                        message.metadata = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.metadata[key] = value;
                                    break;
                                case 6:
                                    message.answerRecord = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a FaqAnswer message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.FaqAnswer} FaqAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FaqAnswer.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a FaqAnswer message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FaqAnswer.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.answer != null && message.hasOwnProperty("answer"))
                                if (!$util.isString(message.answer))
                                    return "answer: string expected";
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                if (typeof message.confidence !== "number")
                                    return "confidence: number expected";
                            if (message.question != null && message.hasOwnProperty("question"))
                                if (!$util.isString(message.question))
                                    return "question: string expected";
                            if (message.source != null && message.hasOwnProperty("source"))
                                if (!$util.isString(message.source))
                                    return "source: string expected";
                            if (message.metadata != null && message.hasOwnProperty("metadata")) {
                                if (!$util.isObject(message.metadata))
                                    return "metadata: object expected";
                                var key = Object.keys(message.metadata);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.metadata[key[i]]))
                                        return "metadata: string{k:string} expected";
                            }
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord"))
                                if (!$util.isString(message.answerRecord))
                                    return "answerRecord: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a FaqAnswer message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.FaqAnswer} FaqAnswer
                         */
                        FaqAnswer.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.FaqAnswer)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.FaqAnswer();
                            if (object.answer != null)
                                message.answer = String(object.answer);
                            if (object.confidence != null)
                                message.confidence = Number(object.confidence);
                            if (object.question != null)
                                message.question = String(object.question);
                            if (object.source != null)
                                message.source = String(object.source);
                            if (object.metadata) {
                                if (typeof object.metadata !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.FaqAnswer.metadata: object expected");
                                message.metadata = {};
                                for (var keys = Object.keys(object.metadata), i = 0; i < keys.length; ++i)
                                    message.metadata[keys[i]] = String(object.metadata[keys[i]]);
                            }
                            if (object.answerRecord != null)
                                message.answerRecord = String(object.answerRecord);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a FaqAnswer message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.FaqAnswer} message FaqAnswer
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FaqAnswer.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.metadata = {};
                            if (options.defaults) {
                                object.answer = "";
                                object.confidence = 0;
                                object.question = "";
                                object.source = "";
                                object.answerRecord = "";
                            }
                            if (message.answer != null && message.hasOwnProperty("answer"))
                                object.answer = message.answer;
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                object.confidence = options.json && !isFinite(message.confidence) ? String(message.confidence) : message.confidence;
                            if (message.question != null && message.hasOwnProperty("question"))
                                object.question = message.question;
                            if (message.source != null && message.hasOwnProperty("source"))
                                object.source = message.source;
                            var keys2;
                            if (message.metadata && (keys2 = Object.keys(message.metadata)).length) {
                                object.metadata = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.metadata[keys2[j]] = message.metadata[keys2[j]];
                            }
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord"))
                                object.answerRecord = message.answerRecord;
                            return object;
                        };
    
                        /**
                         * Converts this FaqAnswer to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.FaqAnswer
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FaqAnswer.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return FaqAnswer;
                    })();
    
                    v2.SmartReplyAnswer = (function() {
    
                        /**
                         * Properties of a SmartReplyAnswer.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISmartReplyAnswer
                         * @property {string|null} [reply] SmartReplyAnswer reply
                         * @property {number|null} [confidence] SmartReplyAnswer confidence
                         * @property {string|null} [answerRecord] SmartReplyAnswer answerRecord
                         */
    
                        /**
                         * Constructs a new SmartReplyAnswer.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SmartReplyAnswer.
                         * @implements ISmartReplyAnswer
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISmartReplyAnswer=} [properties] Properties to set
                         */
                        function SmartReplyAnswer(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SmartReplyAnswer reply.
                         * @member {string} reply
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @instance
                         */
                        SmartReplyAnswer.prototype.reply = "";
    
                        /**
                         * SmartReplyAnswer confidence.
                         * @member {number} confidence
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @instance
                         */
                        SmartReplyAnswer.prototype.confidence = 0;
    
                        /**
                         * SmartReplyAnswer answerRecord.
                         * @member {string} answerRecord
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @instance
                         */
                        SmartReplyAnswer.prototype.answerRecord = "";
    
                        /**
                         * Creates a new SmartReplyAnswer instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISmartReplyAnswer=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SmartReplyAnswer} SmartReplyAnswer instance
                         */
                        SmartReplyAnswer.create = function create(properties) {
                            return new SmartReplyAnswer(properties);
                        };
    
                        /**
                         * Encodes the specified SmartReplyAnswer message. Does not implicitly {@link google.cloud.dialogflow.v2.SmartReplyAnswer.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISmartReplyAnswer} message SmartReplyAnswer message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SmartReplyAnswer.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.reply != null && Object.hasOwnProperty.call(message, "reply"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.reply);
                            if (message.confidence != null && Object.hasOwnProperty.call(message, "confidence"))
                                writer.uint32(/* id 2, wireType 5 =*/21).float(message.confidence);
                            if (message.answerRecord != null && Object.hasOwnProperty.call(message, "answerRecord"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.answerRecord);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SmartReplyAnswer message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SmartReplyAnswer.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISmartReplyAnswer} message SmartReplyAnswer message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SmartReplyAnswer.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SmartReplyAnswer message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SmartReplyAnswer} SmartReplyAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SmartReplyAnswer.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SmartReplyAnswer();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.reply = reader.string();
                                    break;
                                case 2:
                                    message.confidence = reader.float();
                                    break;
                                case 3:
                                    message.answerRecord = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SmartReplyAnswer message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SmartReplyAnswer} SmartReplyAnswer
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SmartReplyAnswer.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SmartReplyAnswer message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SmartReplyAnswer.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.reply != null && message.hasOwnProperty("reply"))
                                if (!$util.isString(message.reply))
                                    return "reply: string expected";
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                if (typeof message.confidence !== "number")
                                    return "confidence: number expected";
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord"))
                                if (!$util.isString(message.answerRecord))
                                    return "answerRecord: string expected";
                            return null;
                        };
    
                        /**
                         * Creates a SmartReplyAnswer message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SmartReplyAnswer} SmartReplyAnswer
                         */
                        SmartReplyAnswer.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SmartReplyAnswer)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SmartReplyAnswer();
                            if (object.reply != null)
                                message.reply = String(object.reply);
                            if (object.confidence != null)
                                message.confidence = Number(object.confidence);
                            if (object.answerRecord != null)
                                message.answerRecord = String(object.answerRecord);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SmartReplyAnswer message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @static
                         * @param {google.cloud.dialogflow.v2.SmartReplyAnswer} message SmartReplyAnswer
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SmartReplyAnswer.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.reply = "";
                                object.confidence = 0;
                                object.answerRecord = "";
                            }
                            if (message.reply != null && message.hasOwnProperty("reply"))
                                object.reply = message.reply;
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                object.confidence = options.json && !isFinite(message.confidence) ? String(message.confidence) : message.confidence;
                            if (message.answerRecord != null && message.hasOwnProperty("answerRecord"))
                                object.answerRecord = message.answerRecord;
                            return object;
                        };
    
                        /**
                         * Converts this SmartReplyAnswer to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SmartReplyAnswer
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SmartReplyAnswer.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SmartReplyAnswer;
                    })();
    
                    v2.SuggestionResult = (function() {
    
                        /**
                         * Properties of a SuggestionResult.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISuggestionResult
                         * @property {google.rpc.IStatus|null} [error] SuggestionResult error
                         * @property {google.cloud.dialogflow.v2.ISuggestArticlesResponse|null} [suggestArticlesResponse] SuggestionResult suggestArticlesResponse
                         * @property {google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse|null} [suggestFaqAnswersResponse] SuggestionResult suggestFaqAnswersResponse
                         * @property {google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse|null} [suggestSmartRepliesResponse] SuggestionResult suggestSmartRepliesResponse
                         */
    
                        /**
                         * Constructs a new SuggestionResult.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SuggestionResult.
                         * @implements ISuggestionResult
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISuggestionResult=} [properties] Properties to set
                         */
                        function SuggestionResult(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SuggestionResult error.
                         * @member {google.rpc.IStatus|null|undefined} error
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @instance
                         */
                        SuggestionResult.prototype.error = null;
    
                        /**
                         * SuggestionResult suggestArticlesResponse.
                         * @member {google.cloud.dialogflow.v2.ISuggestArticlesResponse|null|undefined} suggestArticlesResponse
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @instance
                         */
                        SuggestionResult.prototype.suggestArticlesResponse = null;
    
                        /**
                         * SuggestionResult suggestFaqAnswersResponse.
                         * @member {google.cloud.dialogflow.v2.ISuggestFaqAnswersResponse|null|undefined} suggestFaqAnswersResponse
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @instance
                         */
                        SuggestionResult.prototype.suggestFaqAnswersResponse = null;
    
                        /**
                         * SuggestionResult suggestSmartRepliesResponse.
                         * @member {google.cloud.dialogflow.v2.ISuggestSmartRepliesResponse|null|undefined} suggestSmartRepliesResponse
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @instance
                         */
                        SuggestionResult.prototype.suggestSmartRepliesResponse = null;
    
                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;
    
                        /**
                         * SuggestionResult suggestionResponse.
                         * @member {"error"|"suggestArticlesResponse"|"suggestFaqAnswersResponse"|"suggestSmartRepliesResponse"|undefined} suggestionResponse
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @instance
                         */
                        Object.defineProperty(SuggestionResult.prototype, "suggestionResponse", {
                            get: $util.oneOfGetter($oneOfFields = ["error", "suggestArticlesResponse", "suggestFaqAnswersResponse", "suggestSmartRepliesResponse"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });
    
                        /**
                         * Creates a new SuggestionResult instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestionResult=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SuggestionResult} SuggestionResult instance
                         */
                        SuggestionResult.create = function create(properties) {
                            return new SuggestionResult(properties);
                        };
    
                        /**
                         * Encodes the specified SuggestionResult message. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestionResult.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestionResult} message SuggestionResult message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestionResult.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                                $root.google.rpc.Status.encode(message.error, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.suggestArticlesResponse != null && Object.hasOwnProperty.call(message, "suggestArticlesResponse"))
                                $root.google.cloud.dialogflow.v2.SuggestArticlesResponse.encode(message.suggestArticlesResponse, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.suggestFaqAnswersResponse != null && Object.hasOwnProperty.call(message, "suggestFaqAnswersResponse"))
                                $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.encode(message.suggestFaqAnswersResponse, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.suggestSmartRepliesResponse != null && Object.hasOwnProperty.call(message, "suggestSmartRepliesResponse"))
                                $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.encode(message.suggestSmartRepliesResponse, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SuggestionResult message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SuggestionResult.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISuggestionResult} message SuggestionResult message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SuggestionResult.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SuggestionResult message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SuggestionResult} SuggestionResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestionResult.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SuggestionResult();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.error = $root.google.rpc.Status.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.suggestArticlesResponse = $root.google.cloud.dialogflow.v2.SuggestArticlesResponse.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.suggestFaqAnswersResponse = $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.suggestSmartRepliesResponse = $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SuggestionResult message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SuggestionResult} SuggestionResult
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SuggestionResult.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SuggestionResult message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SuggestionResult.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.error != null && message.hasOwnProperty("error")) {
                                properties.suggestionResponse = 1;
                                {
                                    var error = $root.google.rpc.Status.verify(message.error);
                                    if (error)
                                        return "error." + error;
                                }
                            }
                            if (message.suggestArticlesResponse != null && message.hasOwnProperty("suggestArticlesResponse")) {
                                if (properties.suggestionResponse === 1)
                                    return "suggestionResponse: multiple values";
                                properties.suggestionResponse = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.SuggestArticlesResponse.verify(message.suggestArticlesResponse);
                                    if (error)
                                        return "suggestArticlesResponse." + error;
                                }
                            }
                            if (message.suggestFaqAnswersResponse != null && message.hasOwnProperty("suggestFaqAnswersResponse")) {
                                if (properties.suggestionResponse === 1)
                                    return "suggestionResponse: multiple values";
                                properties.suggestionResponse = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.verify(message.suggestFaqAnswersResponse);
                                    if (error)
                                        return "suggestFaqAnswersResponse." + error;
                                }
                            }
                            if (message.suggestSmartRepliesResponse != null && message.hasOwnProperty("suggestSmartRepliesResponse")) {
                                if (properties.suggestionResponse === 1)
                                    return "suggestionResponse: multiple values";
                                properties.suggestionResponse = 1;
                                {
                                    var error = $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.verify(message.suggestSmartRepliesResponse);
                                    if (error)
                                        return "suggestSmartRepliesResponse." + error;
                                }
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SuggestionResult message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SuggestionResult} SuggestionResult
                         */
                        SuggestionResult.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SuggestionResult)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SuggestionResult();
                            if (object.error != null) {
                                if (typeof object.error !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestionResult.error: object expected");
                                message.error = $root.google.rpc.Status.fromObject(object.error);
                            }
                            if (object.suggestArticlesResponse != null) {
                                if (typeof object.suggestArticlesResponse !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestionResult.suggestArticlesResponse: object expected");
                                message.suggestArticlesResponse = $root.google.cloud.dialogflow.v2.SuggestArticlesResponse.fromObject(object.suggestArticlesResponse);
                            }
                            if (object.suggestFaqAnswersResponse != null) {
                                if (typeof object.suggestFaqAnswersResponse !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestionResult.suggestFaqAnswersResponse: object expected");
                                message.suggestFaqAnswersResponse = $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.fromObject(object.suggestFaqAnswersResponse);
                            }
                            if (object.suggestSmartRepliesResponse != null) {
                                if (typeof object.suggestSmartRepliesResponse !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SuggestionResult.suggestSmartRepliesResponse: object expected");
                                message.suggestSmartRepliesResponse = $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.fromObject(object.suggestSmartRepliesResponse);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SuggestionResult message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @static
                         * @param {google.cloud.dialogflow.v2.SuggestionResult} message SuggestionResult
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SuggestionResult.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.error != null && message.hasOwnProperty("error")) {
                                object.error = $root.google.rpc.Status.toObject(message.error, options);
                                if (options.oneofs)
                                    object.suggestionResponse = "error";
                            }
                            if (message.suggestArticlesResponse != null && message.hasOwnProperty("suggestArticlesResponse")) {
                                object.suggestArticlesResponse = $root.google.cloud.dialogflow.v2.SuggestArticlesResponse.toObject(message.suggestArticlesResponse, options);
                                if (options.oneofs)
                                    object.suggestionResponse = "suggestArticlesResponse";
                            }
                            if (message.suggestFaqAnswersResponse != null && message.hasOwnProperty("suggestFaqAnswersResponse")) {
                                object.suggestFaqAnswersResponse = $root.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.toObject(message.suggestFaqAnswersResponse, options);
                                if (options.oneofs)
                                    object.suggestionResponse = "suggestFaqAnswersResponse";
                            }
                            if (message.suggestSmartRepliesResponse != null && message.hasOwnProperty("suggestSmartRepliesResponse")) {
                                object.suggestSmartRepliesResponse = $root.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.toObject(message.suggestSmartRepliesResponse, options);
                                if (options.oneofs)
                                    object.suggestionResponse = "suggestSmartRepliesResponse";
                            }
                            return object;
                        };
    
                        /**
                         * Converts this SuggestionResult to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SuggestionResult
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SuggestionResult.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SuggestionResult;
                    })();
    
                    v2.AnnotatedMessagePart = (function() {
    
                        /**
                         * Properties of an AnnotatedMessagePart.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAnnotatedMessagePart
                         * @property {string|null} [text] AnnotatedMessagePart text
                         * @property {string|null} [entityType] AnnotatedMessagePart entityType
                         * @property {google.protobuf.IValue|null} [formattedValue] AnnotatedMessagePart formattedValue
                         */
    
                        /**
                         * Constructs a new AnnotatedMessagePart.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AnnotatedMessagePart.
                         * @implements IAnnotatedMessagePart
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAnnotatedMessagePart=} [properties] Properties to set
                         */
                        function AnnotatedMessagePart(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AnnotatedMessagePart text.
                         * @member {string} text
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @instance
                         */
                        AnnotatedMessagePart.prototype.text = "";
    
                        /**
                         * AnnotatedMessagePart entityType.
                         * @member {string} entityType
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @instance
                         */
                        AnnotatedMessagePart.prototype.entityType = "";
    
                        /**
                         * AnnotatedMessagePart formattedValue.
                         * @member {google.protobuf.IValue|null|undefined} formattedValue
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @instance
                         */
                        AnnotatedMessagePart.prototype.formattedValue = null;
    
                        /**
                         * Creates a new AnnotatedMessagePart instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnnotatedMessagePart=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AnnotatedMessagePart} AnnotatedMessagePart instance
                         */
                        AnnotatedMessagePart.create = function create(properties) {
                            return new AnnotatedMessagePart(properties);
                        };
    
                        /**
                         * Encodes the specified AnnotatedMessagePart message. Does not implicitly {@link google.cloud.dialogflow.v2.AnnotatedMessagePart.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnnotatedMessagePart} message AnnotatedMessagePart message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotatedMessagePart.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
                            if (message.entityType != null && Object.hasOwnProperty.call(message, "entityType"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.entityType);
                            if (message.formattedValue != null && Object.hasOwnProperty.call(message, "formattedValue"))
                                $root.google.protobuf.Value.encode(message.formattedValue, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AnnotatedMessagePart message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AnnotatedMessagePart.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAnnotatedMessagePart} message AnnotatedMessagePart message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AnnotatedMessagePart.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AnnotatedMessagePart message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AnnotatedMessagePart} AnnotatedMessagePart
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotatedMessagePart.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AnnotatedMessagePart();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.text = reader.string();
                                    break;
                                case 2:
                                    message.entityType = reader.string();
                                    break;
                                case 3:
                                    message.formattedValue = $root.google.protobuf.Value.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AnnotatedMessagePart message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AnnotatedMessagePart} AnnotatedMessagePart
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AnnotatedMessagePart.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AnnotatedMessagePart message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AnnotatedMessagePart.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.text != null && message.hasOwnProperty("text"))
                                if (!$util.isString(message.text))
                                    return "text: string expected";
                            if (message.entityType != null && message.hasOwnProperty("entityType"))
                                if (!$util.isString(message.entityType))
                                    return "entityType: string expected";
                            if (message.formattedValue != null && message.hasOwnProperty("formattedValue")) {
                                var error = $root.google.protobuf.Value.verify(message.formattedValue);
                                if (error)
                                    return "formattedValue." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AnnotatedMessagePart message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AnnotatedMessagePart} AnnotatedMessagePart
                         */
                        AnnotatedMessagePart.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AnnotatedMessagePart)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AnnotatedMessagePart();
                            if (object.text != null)
                                message.text = String(object.text);
                            if (object.entityType != null)
                                message.entityType = String(object.entityType);
                            if (object.formattedValue != null) {
                                if (typeof object.formattedValue !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AnnotatedMessagePart.formattedValue: object expected");
                                message.formattedValue = $root.google.protobuf.Value.fromObject(object.formattedValue);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AnnotatedMessagePart message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @static
                         * @param {google.cloud.dialogflow.v2.AnnotatedMessagePart} message AnnotatedMessagePart
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AnnotatedMessagePart.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.text = "";
                                object.entityType = "";
                                object.formattedValue = null;
                            }
                            if (message.text != null && message.hasOwnProperty("text"))
                                object.text = message.text;
                            if (message.entityType != null && message.hasOwnProperty("entityType"))
                                object.entityType = message.entityType;
                            if (message.formattedValue != null && message.hasOwnProperty("formattedValue"))
                                object.formattedValue = $root.google.protobuf.Value.toObject(message.formattedValue, options);
                            return object;
                        };
    
                        /**
                         * Converts this AnnotatedMessagePart to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AnnotatedMessagePart
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AnnotatedMessagePart.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return AnnotatedMessagePart;
                    })();
    
                    v2.MessageAnnotation = (function() {
    
                        /**
                         * Properties of a MessageAnnotation.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IMessageAnnotation
                         * @property {Array.<google.cloud.dialogflow.v2.IAnnotatedMessagePart>|null} [parts] MessageAnnotation parts
                         * @property {boolean|null} [containEntities] MessageAnnotation containEntities
                         */
    
                        /**
                         * Constructs a new MessageAnnotation.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a MessageAnnotation.
                         * @implements IMessageAnnotation
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IMessageAnnotation=} [properties] Properties to set
                         */
                        function MessageAnnotation(properties) {
                            this.parts = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * MessageAnnotation parts.
                         * @member {Array.<google.cloud.dialogflow.v2.IAnnotatedMessagePart>} parts
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @instance
                         */
                        MessageAnnotation.prototype.parts = $util.emptyArray;
    
                        /**
                         * MessageAnnotation containEntities.
                         * @member {boolean} containEntities
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @instance
                         */
                        MessageAnnotation.prototype.containEntities = false;
    
                        /**
                         * Creates a new MessageAnnotation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {google.cloud.dialogflow.v2.IMessageAnnotation=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.MessageAnnotation} MessageAnnotation instance
                         */
                        MessageAnnotation.create = function create(properties) {
                            return new MessageAnnotation(properties);
                        };
    
                        /**
                         * Encodes the specified MessageAnnotation message. Does not implicitly {@link google.cloud.dialogflow.v2.MessageAnnotation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {google.cloud.dialogflow.v2.IMessageAnnotation} message MessageAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MessageAnnotation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.parts != null && message.parts.length)
                                for (var i = 0; i < message.parts.length; ++i)
                                    $root.google.cloud.dialogflow.v2.AnnotatedMessagePart.encode(message.parts[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.containEntities != null && Object.hasOwnProperty.call(message, "containEntities"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.containEntities);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified MessageAnnotation message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.MessageAnnotation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {google.cloud.dialogflow.v2.IMessageAnnotation} message MessageAnnotation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        MessageAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a MessageAnnotation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.MessageAnnotation} MessageAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MessageAnnotation.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.MessageAnnotation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.parts && message.parts.length))
                                        message.parts = [];
                                    message.parts.push($root.google.cloud.dialogflow.v2.AnnotatedMessagePart.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.containEntities = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a MessageAnnotation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.MessageAnnotation} MessageAnnotation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        MessageAnnotation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a MessageAnnotation message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        MessageAnnotation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.parts != null && message.hasOwnProperty("parts")) {
                                if (!Array.isArray(message.parts))
                                    return "parts: array expected";
                                for (var i = 0; i < message.parts.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.AnnotatedMessagePart.verify(message.parts[i]);
                                    if (error)
                                        return "parts." + error;
                                }
                            }
                            if (message.containEntities != null && message.hasOwnProperty("containEntities"))
                                if (typeof message.containEntities !== "boolean")
                                    return "containEntities: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a MessageAnnotation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.MessageAnnotation} MessageAnnotation
                         */
                        MessageAnnotation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.MessageAnnotation)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.MessageAnnotation();
                            if (object.parts) {
                                if (!Array.isArray(object.parts))
                                    throw TypeError(".google.cloud.dialogflow.v2.MessageAnnotation.parts: array expected");
                                message.parts = [];
                                for (var i = 0; i < object.parts.length; ++i) {
                                    if (typeof object.parts[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.MessageAnnotation.parts: object expected");
                                    message.parts[i] = $root.google.cloud.dialogflow.v2.AnnotatedMessagePart.fromObject(object.parts[i]);
                                }
                            }
                            if (object.containEntities != null)
                                message.containEntities = Boolean(object.containEntities);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a MessageAnnotation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @static
                         * @param {google.cloud.dialogflow.v2.MessageAnnotation} message MessageAnnotation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        MessageAnnotation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.parts = [];
                            if (options.defaults)
                                object.containEntities = false;
                            if (message.parts && message.parts.length) {
                                object.parts = [];
                                for (var j = 0; j < message.parts.length; ++j)
                                    object.parts[j] = $root.google.cloud.dialogflow.v2.AnnotatedMessagePart.toObject(message.parts[j], options);
                            }
                            if (message.containEntities != null && message.hasOwnProperty("containEntities"))
                                object.containEntities = message.containEntities;
                            return object;
                        };
    
                        /**
                         * Converts this MessageAnnotation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.MessageAnnotation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        MessageAnnotation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return MessageAnnotation;
                    })();
    
                    v2.AssistQueryParameters = (function() {
    
                        /**
                         * Properties of an AssistQueryParameters.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IAssistQueryParameters
                         * @property {Object.<string,string>|null} [documentsMetadataFilters] AssistQueryParameters documentsMetadataFilters
                         */
    
                        /**
                         * Constructs a new AssistQueryParameters.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an AssistQueryParameters.
                         * @implements IAssistQueryParameters
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IAssistQueryParameters=} [properties] Properties to set
                         */
                        function AssistQueryParameters(properties) {
                            this.documentsMetadataFilters = {};
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AssistQueryParameters documentsMetadataFilters.
                         * @member {Object.<string,string>} documentsMetadataFilters
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @instance
                         */
                        AssistQueryParameters.prototype.documentsMetadataFilters = $util.emptyObject;
    
                        /**
                         * Creates a new AssistQueryParameters instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAssistQueryParameters=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.AssistQueryParameters} AssistQueryParameters instance
                         */
                        AssistQueryParameters.create = function create(properties) {
                            return new AssistQueryParameters(properties);
                        };
    
                        /**
                         * Encodes the specified AssistQueryParameters message. Does not implicitly {@link google.cloud.dialogflow.v2.AssistQueryParameters.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAssistQueryParameters} message AssistQueryParameters message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AssistQueryParameters.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.documentsMetadataFilters != null && Object.hasOwnProperty.call(message, "documentsMetadataFilters"))
                                for (var keys = Object.keys(message.documentsMetadataFilters), i = 0; i < keys.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.documentsMetadataFilters[keys[i]]).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AssistQueryParameters message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.AssistQueryParameters.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.IAssistQueryParameters} message AssistQueryParameters message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AssistQueryParameters.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AssistQueryParameters message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.AssistQueryParameters} AssistQueryParameters
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AssistQueryParameters.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.AssistQueryParameters(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (message.documentsMetadataFilters === $util.emptyObject)
                                        message.documentsMetadataFilters = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.documentsMetadataFilters[key] = value;
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AssistQueryParameters message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.AssistQueryParameters} AssistQueryParameters
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AssistQueryParameters.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AssistQueryParameters message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AssistQueryParameters.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.documentsMetadataFilters != null && message.hasOwnProperty("documentsMetadataFilters")) {
                                if (!$util.isObject(message.documentsMetadataFilters))
                                    return "documentsMetadataFilters: object expected";
                                var key = Object.keys(message.documentsMetadataFilters);
                                for (var i = 0; i < key.length; ++i)
                                    if (!$util.isString(message.documentsMetadataFilters[key[i]]))
                                        return "documentsMetadataFilters: string{k:string} expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AssistQueryParameters message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.AssistQueryParameters} AssistQueryParameters
                         */
                        AssistQueryParameters.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.AssistQueryParameters)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.AssistQueryParameters();
                            if (object.documentsMetadataFilters) {
                                if (typeof object.documentsMetadataFilters !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.AssistQueryParameters.documentsMetadataFilters: object expected");
                                message.documentsMetadataFilters = {};
                                for (var keys = Object.keys(object.documentsMetadataFilters), i = 0; i < keys.length; ++i)
                                    message.documentsMetadataFilters[keys[i]] = String(object.documentsMetadataFilters[keys[i]]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AssistQueryParameters message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @static
                         * @param {google.cloud.dialogflow.v2.AssistQueryParameters} message AssistQueryParameters
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AssistQueryParameters.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.objects || options.defaults)
                                object.documentsMetadataFilters = {};
                            var keys2;
                            if (message.documentsMetadataFilters && (keys2 = Object.keys(message.documentsMetadataFilters)).length) {
                                object.documentsMetadataFilters = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.documentsMetadataFilters[keys2[j]] = message.documentsMetadataFilters[keys2[j]];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AssistQueryParameters to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.AssistQueryParameters
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AssistQueryParameters.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return AssistQueryParameters;
                    })();
    
                    /**
                     * AudioEncoding enum.
                     * @name google.cloud.dialogflow.v2.AudioEncoding
                     * @enum {number}
                     * @property {number} AUDIO_ENCODING_UNSPECIFIED=0 AUDIO_ENCODING_UNSPECIFIED value
                     * @property {number} AUDIO_ENCODING_LINEAR_16=1 AUDIO_ENCODING_LINEAR_16 value
                     * @property {number} AUDIO_ENCODING_FLAC=2 AUDIO_ENCODING_FLAC value
                     * @property {number} AUDIO_ENCODING_MULAW=3 AUDIO_ENCODING_MULAW value
                     * @property {number} AUDIO_ENCODING_AMR=4 AUDIO_ENCODING_AMR value
                     * @property {number} AUDIO_ENCODING_AMR_WB=5 AUDIO_ENCODING_AMR_WB value
                     * @property {number} AUDIO_ENCODING_OGG_OPUS=6 AUDIO_ENCODING_OGG_OPUS value
                     * @property {number} AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE=7 AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE value
                     */
                    v2.AudioEncoding = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "AUDIO_ENCODING_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "AUDIO_ENCODING_LINEAR_16"] = 1;
                        values[valuesById[2] = "AUDIO_ENCODING_FLAC"] = 2;
                        values[valuesById[3] = "AUDIO_ENCODING_MULAW"] = 3;
                        values[valuesById[4] = "AUDIO_ENCODING_AMR"] = 4;
                        values[valuesById[5] = "AUDIO_ENCODING_AMR_WB"] = 5;
                        values[valuesById[6] = "AUDIO_ENCODING_OGG_OPUS"] = 6;
                        values[valuesById[7] = "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE"] = 7;
                        return values;
                    })();
    
                    v2.SpeechContext = (function() {
    
                        /**
                         * Properties of a SpeechContext.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISpeechContext
                         * @property {Array.<string>|null} [phrases] SpeechContext phrases
                         * @property {number|null} [boost] SpeechContext boost
                         */
    
                        /**
                         * Constructs a new SpeechContext.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SpeechContext.
                         * @implements ISpeechContext
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISpeechContext=} [properties] Properties to set
                         */
                        function SpeechContext(properties) {
                            this.phrases = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SpeechContext phrases.
                         * @member {Array.<string>} phrases
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @instance
                         */
                        SpeechContext.prototype.phrases = $util.emptyArray;
    
                        /**
                         * SpeechContext boost.
                         * @member {number} boost
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @instance
                         */
                        SpeechContext.prototype.boost = 0;
    
                        /**
                         * Creates a new SpeechContext instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechContext=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SpeechContext} SpeechContext instance
                         */
                        SpeechContext.create = function create(properties) {
                            return new SpeechContext(properties);
                        };
    
                        /**
                         * Encodes the specified SpeechContext message. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechContext.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechContext} message SpeechContext message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SpeechContext.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.phrases != null && message.phrases.length)
                                for (var i = 0; i < message.phrases.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.phrases[i]);
                            if (message.boost != null && Object.hasOwnProperty.call(message, "boost"))
                                writer.uint32(/* id 2, wireType 5 =*/21).float(message.boost);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SpeechContext message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechContext.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechContext} message SpeechContext message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SpeechContext.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SpeechContext message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SpeechContext} SpeechContext
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SpeechContext.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SpeechContext();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.phrases && message.phrases.length))
                                        message.phrases = [];
                                    message.phrases.push(reader.string());
                                    break;
                                case 2:
                                    message.boost = reader.float();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SpeechContext message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SpeechContext} SpeechContext
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SpeechContext.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SpeechContext message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SpeechContext.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.phrases != null && message.hasOwnProperty("phrases")) {
                                if (!Array.isArray(message.phrases))
                                    return "phrases: array expected";
                                for (var i = 0; i < message.phrases.length; ++i)
                                    if (!$util.isString(message.phrases[i]))
                                        return "phrases: string[] expected";
                            }
                            if (message.boost != null && message.hasOwnProperty("boost"))
                                if (typeof message.boost !== "number")
                                    return "boost: number expected";
                            return null;
                        };
    
                        /**
                         * Creates a SpeechContext message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SpeechContext} SpeechContext
                         */
                        SpeechContext.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SpeechContext)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SpeechContext();
                            if (object.phrases) {
                                if (!Array.isArray(object.phrases))
                                    throw TypeError(".google.cloud.dialogflow.v2.SpeechContext.phrases: array expected");
                                message.phrases = [];
                                for (var i = 0; i < object.phrases.length; ++i)
                                    message.phrases[i] = String(object.phrases[i]);
                            }
                            if (object.boost != null)
                                message.boost = Number(object.boost);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SpeechContext message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @static
                         * @param {google.cloud.dialogflow.v2.SpeechContext} message SpeechContext
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SpeechContext.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.phrases = [];
                            if (options.defaults)
                                object.boost = 0;
                            if (message.phrases && message.phrases.length) {
                                object.phrases = [];
                                for (var j = 0; j < message.phrases.length; ++j)
                                    object.phrases[j] = message.phrases[j];
                            }
                            if (message.boost != null && message.hasOwnProperty("boost"))
                                object.boost = options.json && !isFinite(message.boost) ? String(message.boost) : message.boost;
                            return object;
                        };
    
                        /**
                         * Converts this SpeechContext to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SpeechContext
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SpeechContext.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SpeechContext;
                    })();
    
                    /**
                     * SpeechModelVariant enum.
                     * @name google.cloud.dialogflow.v2.SpeechModelVariant
                     * @enum {number}
                     * @property {number} SPEECH_MODEL_VARIANT_UNSPECIFIED=0 SPEECH_MODEL_VARIANT_UNSPECIFIED value
                     * @property {number} USE_BEST_AVAILABLE=1 USE_BEST_AVAILABLE value
                     * @property {number} USE_STANDARD=2 USE_STANDARD value
                     * @property {number} USE_ENHANCED=3 USE_ENHANCED value
                     */
                    v2.SpeechModelVariant = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "SPEECH_MODEL_VARIANT_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "USE_BEST_AVAILABLE"] = 1;
                        values[valuesById[2] = "USE_STANDARD"] = 2;
                        values[valuesById[3] = "USE_ENHANCED"] = 3;
                        return values;
                    })();
    
                    v2.SpeechWordInfo = (function() {
    
                        /**
                         * Properties of a SpeechWordInfo.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISpeechWordInfo
                         * @property {string|null} [word] SpeechWordInfo word
                         * @property {google.protobuf.IDuration|null} [startOffset] SpeechWordInfo startOffset
                         * @property {google.protobuf.IDuration|null} [endOffset] SpeechWordInfo endOffset
                         * @property {number|null} [confidence] SpeechWordInfo confidence
                         */
    
                        /**
                         * Constructs a new SpeechWordInfo.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SpeechWordInfo.
                         * @implements ISpeechWordInfo
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISpeechWordInfo=} [properties] Properties to set
                         */
                        function SpeechWordInfo(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SpeechWordInfo word.
                         * @member {string} word
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @instance
                         */
                        SpeechWordInfo.prototype.word = "";
    
                        /**
                         * SpeechWordInfo startOffset.
                         * @member {google.protobuf.IDuration|null|undefined} startOffset
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @instance
                         */
                        SpeechWordInfo.prototype.startOffset = null;
    
                        /**
                         * SpeechWordInfo endOffset.
                         * @member {google.protobuf.IDuration|null|undefined} endOffset
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @instance
                         */
                        SpeechWordInfo.prototype.endOffset = null;
    
                        /**
                         * SpeechWordInfo confidence.
                         * @member {number} confidence
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @instance
                         */
                        SpeechWordInfo.prototype.confidence = 0;
    
                        /**
                         * Creates a new SpeechWordInfo instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechWordInfo=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SpeechWordInfo} SpeechWordInfo instance
                         */
                        SpeechWordInfo.create = function create(properties) {
                            return new SpeechWordInfo(properties);
                        };
    
                        /**
                         * Encodes the specified SpeechWordInfo message. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechWordInfo.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechWordInfo} message SpeechWordInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SpeechWordInfo.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.startOffset != null && Object.hasOwnProperty.call(message, "startOffset"))
                                $root.google.protobuf.Duration.encode(message.startOffset, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.endOffset != null && Object.hasOwnProperty.call(message, "endOffset"))
                                $root.google.protobuf.Duration.encode(message.endOffset, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.word != null && Object.hasOwnProperty.call(message, "word"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.word);
                            if (message.confidence != null && Object.hasOwnProperty.call(message, "confidence"))
                                writer.uint32(/* id 4, wireType 5 =*/37).float(message.confidence);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SpeechWordInfo message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechWordInfo.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechWordInfo} message SpeechWordInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SpeechWordInfo.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SpeechWordInfo message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SpeechWordInfo} SpeechWordInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SpeechWordInfo.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SpeechWordInfo();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3:
                                    message.word = reader.string();
                                    break;
                                case 1:
                                    message.startOffset = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.endOffset = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.confidence = reader.float();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SpeechWordInfo message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SpeechWordInfo} SpeechWordInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SpeechWordInfo.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SpeechWordInfo message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SpeechWordInfo.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.word != null && message.hasOwnProperty("word"))
                                if (!$util.isString(message.word))
                                    return "word: string expected";
                            if (message.startOffset != null && message.hasOwnProperty("startOffset")) {
                                var error = $root.google.protobuf.Duration.verify(message.startOffset);
                                if (error)
                                    return "startOffset." + error;
                            }
                            if (message.endOffset != null && message.hasOwnProperty("endOffset")) {
                                var error = $root.google.protobuf.Duration.verify(message.endOffset);
                                if (error)
                                    return "endOffset." + error;
                            }
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                if (typeof message.confidence !== "number")
                                    return "confidence: number expected";
                            return null;
                        };
    
                        /**
                         * Creates a SpeechWordInfo message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SpeechWordInfo} SpeechWordInfo
                         */
                        SpeechWordInfo.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SpeechWordInfo)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SpeechWordInfo();
                            if (object.word != null)
                                message.word = String(object.word);
                            if (object.startOffset != null) {
                                if (typeof object.startOffset !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SpeechWordInfo.startOffset: object expected");
                                message.startOffset = $root.google.protobuf.Duration.fromObject(object.startOffset);
                            }
                            if (object.endOffset != null) {
                                if (typeof object.endOffset !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SpeechWordInfo.endOffset: object expected");
                                message.endOffset = $root.google.protobuf.Duration.fromObject(object.endOffset);
                            }
                            if (object.confidence != null)
                                message.confidence = Number(object.confidence);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SpeechWordInfo message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @static
                         * @param {google.cloud.dialogflow.v2.SpeechWordInfo} message SpeechWordInfo
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SpeechWordInfo.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.startOffset = null;
                                object.endOffset = null;
                                object.word = "";
                                object.confidence = 0;
                            }
                            if (message.startOffset != null && message.hasOwnProperty("startOffset"))
                                object.startOffset = $root.google.protobuf.Duration.toObject(message.startOffset, options);
                            if (message.endOffset != null && message.hasOwnProperty("endOffset"))
                                object.endOffset = $root.google.protobuf.Duration.toObject(message.endOffset, options);
                            if (message.word != null && message.hasOwnProperty("word"))
                                object.word = message.word;
                            if (message.confidence != null && message.hasOwnProperty("confidence"))
                                object.confidence = options.json && !isFinite(message.confidence) ? String(message.confidence) : message.confidence;
                            return object;
                        };
    
                        /**
                         * Converts this SpeechWordInfo to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SpeechWordInfo
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SpeechWordInfo.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SpeechWordInfo;
                    })();
    
                    v2.InputAudioConfig = (function() {
    
                        /**
                         * Properties of an InputAudioConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IInputAudioConfig
                         * @property {google.cloud.dialogflow.v2.AudioEncoding|null} [audioEncoding] InputAudioConfig audioEncoding
                         * @property {number|null} [sampleRateHertz] InputAudioConfig sampleRateHertz
                         * @property {string|null} [languageCode] InputAudioConfig languageCode
                         * @property {boolean|null} [enableWordInfo] InputAudioConfig enableWordInfo
                         * @property {Array.<string>|null} [phraseHints] InputAudioConfig phraseHints
                         * @property {Array.<google.cloud.dialogflow.v2.ISpeechContext>|null} [speechContexts] InputAudioConfig speechContexts
                         * @property {string|null} [model] InputAudioConfig model
                         * @property {google.cloud.dialogflow.v2.SpeechModelVariant|null} [modelVariant] InputAudioConfig modelVariant
                         * @property {boolean|null} [singleUtterance] InputAudioConfig singleUtterance
                         * @property {boolean|null} [disableNoSpeechRecognizedEvent] InputAudioConfig disableNoSpeechRecognizedEvent
                         */
    
                        /**
                         * Constructs a new InputAudioConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an InputAudioConfig.
                         * @implements IInputAudioConfig
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IInputAudioConfig=} [properties] Properties to set
                         */
                        function InputAudioConfig(properties) {
                            this.phraseHints = [];
                            this.speechContexts = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * InputAudioConfig audioEncoding.
                         * @member {google.cloud.dialogflow.v2.AudioEncoding} audioEncoding
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.audioEncoding = 0;
    
                        /**
                         * InputAudioConfig sampleRateHertz.
                         * @member {number} sampleRateHertz
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.sampleRateHertz = 0;
    
                        /**
                         * InputAudioConfig languageCode.
                         * @member {string} languageCode
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.languageCode = "";
    
                        /**
                         * InputAudioConfig enableWordInfo.
                         * @member {boolean} enableWordInfo
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.enableWordInfo = false;
    
                        /**
                         * InputAudioConfig phraseHints.
                         * @member {Array.<string>} phraseHints
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.phraseHints = $util.emptyArray;
    
                        /**
                         * InputAudioConfig speechContexts.
                         * @member {Array.<google.cloud.dialogflow.v2.ISpeechContext>} speechContexts
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.speechContexts = $util.emptyArray;
    
                        /**
                         * InputAudioConfig model.
                         * @member {string} model
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.model = "";
    
                        /**
                         * InputAudioConfig modelVariant.
                         * @member {google.cloud.dialogflow.v2.SpeechModelVariant} modelVariant
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.modelVariant = 0;
    
                        /**
                         * InputAudioConfig singleUtterance.
                         * @member {boolean} singleUtterance
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.singleUtterance = false;
    
                        /**
                         * InputAudioConfig disableNoSpeechRecognizedEvent.
                         * @member {boolean} disableNoSpeechRecognizedEvent
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         */
                        InputAudioConfig.prototype.disableNoSpeechRecognizedEvent = false;
    
                        /**
                         * Creates a new InputAudioConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.IInputAudioConfig=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.InputAudioConfig} InputAudioConfig instance
                         */
                        InputAudioConfig.create = function create(properties) {
                            return new InputAudioConfig(properties);
                        };
    
                        /**
                         * Encodes the specified InputAudioConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.InputAudioConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.IInputAudioConfig} message InputAudioConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        InputAudioConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.audioEncoding != null && Object.hasOwnProperty.call(message, "audioEncoding"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.audioEncoding);
                            if (message.sampleRateHertz != null && Object.hasOwnProperty.call(message, "sampleRateHertz"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.sampleRateHertz);
                            if (message.languageCode != null && Object.hasOwnProperty.call(message, "languageCode"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.languageCode);
                            if (message.phraseHints != null && message.phraseHints.length)
                                for (var i = 0; i < message.phraseHints.length; ++i)
                                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.phraseHints[i]);
                            if (message.model != null && Object.hasOwnProperty.call(message, "model"))
                                writer.uint32(/* id 7, wireType 2 =*/58).string(message.model);
                            if (message.singleUtterance != null && Object.hasOwnProperty.call(message, "singleUtterance"))
                                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.singleUtterance);
                            if (message.modelVariant != null && Object.hasOwnProperty.call(message, "modelVariant"))
                                writer.uint32(/* id 10, wireType 0 =*/80).int32(message.modelVariant);
                            if (message.speechContexts != null && message.speechContexts.length)
                                for (var i = 0; i < message.speechContexts.length; ++i)
                                    $root.google.cloud.dialogflow.v2.SpeechContext.encode(message.speechContexts[i], writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                            if (message.enableWordInfo != null && Object.hasOwnProperty.call(message, "enableWordInfo"))
                                writer.uint32(/* id 13, wireType 0 =*/104).bool(message.enableWordInfo);
                            if (message.disableNoSpeechRecognizedEvent != null && Object.hasOwnProperty.call(message, "disableNoSpeechRecognizedEvent"))
                                writer.uint32(/* id 14, wireType 0 =*/112).bool(message.disableNoSpeechRecognizedEvent);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified InputAudioConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.InputAudioConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.IInputAudioConfig} message InputAudioConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        InputAudioConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an InputAudioConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.InputAudioConfig} InputAudioConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        InputAudioConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.InputAudioConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.audioEncoding = reader.int32();
                                    break;
                                case 2:
                                    message.sampleRateHertz = reader.int32();
                                    break;
                                case 3:
                                    message.languageCode = reader.string();
                                    break;
                                case 13:
                                    message.enableWordInfo = reader.bool();
                                    break;
                                case 4:
                                    if (!(message.phraseHints && message.phraseHints.length))
                                        message.phraseHints = [];
                                    message.phraseHints.push(reader.string());
                                    break;
                                case 11:
                                    if (!(message.speechContexts && message.speechContexts.length))
                                        message.speechContexts = [];
                                    message.speechContexts.push($root.google.cloud.dialogflow.v2.SpeechContext.decode(reader, reader.uint32()));
                                    break;
                                case 7:
                                    message.model = reader.string();
                                    break;
                                case 10:
                                    message.modelVariant = reader.int32();
                                    break;
                                case 8:
                                    message.singleUtterance = reader.bool();
                                    break;
                                case 14:
                                    message.disableNoSpeechRecognizedEvent = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an InputAudioConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.InputAudioConfig} InputAudioConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        InputAudioConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an InputAudioConfig message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        InputAudioConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.audioEncoding != null && message.hasOwnProperty("audioEncoding"))
                                switch (message.audioEncoding) {
                                default:
                                    return "audioEncoding: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                    break;
                                }
                            if (message.sampleRateHertz != null && message.hasOwnProperty("sampleRateHertz"))
                                if (!$util.isInteger(message.sampleRateHertz))
                                    return "sampleRateHertz: integer expected";
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                if (!$util.isString(message.languageCode))
                                    return "languageCode: string expected";
                            if (message.enableWordInfo != null && message.hasOwnProperty("enableWordInfo"))
                                if (typeof message.enableWordInfo !== "boolean")
                                    return "enableWordInfo: boolean expected";
                            if (message.phraseHints != null && message.hasOwnProperty("phraseHints")) {
                                if (!Array.isArray(message.phraseHints))
                                    return "phraseHints: array expected";
                                for (var i = 0; i < message.phraseHints.length; ++i)
                                    if (!$util.isString(message.phraseHints[i]))
                                        return "phraseHints: string[] expected";
                            }
                            if (message.speechContexts != null && message.hasOwnProperty("speechContexts")) {
                                if (!Array.isArray(message.speechContexts))
                                    return "speechContexts: array expected";
                                for (var i = 0; i < message.speechContexts.length; ++i) {
                                    var error = $root.google.cloud.dialogflow.v2.SpeechContext.verify(message.speechContexts[i]);
                                    if (error)
                                        return "speechContexts." + error;
                                }
                            }
                            if (message.model != null && message.hasOwnProperty("model"))
                                if (!$util.isString(message.model))
                                    return "model: string expected";
                            if (message.modelVariant != null && message.hasOwnProperty("modelVariant"))
                                switch (message.modelVariant) {
                                default:
                                    return "modelVariant: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            if (message.singleUtterance != null && message.hasOwnProperty("singleUtterance"))
                                if (typeof message.singleUtterance !== "boolean")
                                    return "singleUtterance: boolean expected";
                            if (message.disableNoSpeechRecognizedEvent != null && message.hasOwnProperty("disableNoSpeechRecognizedEvent"))
                                if (typeof message.disableNoSpeechRecognizedEvent !== "boolean")
                                    return "disableNoSpeechRecognizedEvent: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates an InputAudioConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.InputAudioConfig} InputAudioConfig
                         */
                        InputAudioConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.InputAudioConfig)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.InputAudioConfig();
                            switch (object.audioEncoding) {
                            case "AUDIO_ENCODING_UNSPECIFIED":
                            case 0:
                                message.audioEncoding = 0;
                                break;
                            case "AUDIO_ENCODING_LINEAR_16":
                            case 1:
                                message.audioEncoding = 1;
                                break;
                            case "AUDIO_ENCODING_FLAC":
                            case 2:
                                message.audioEncoding = 2;
                                break;
                            case "AUDIO_ENCODING_MULAW":
                            case 3:
                                message.audioEncoding = 3;
                                break;
                            case "AUDIO_ENCODING_AMR":
                            case 4:
                                message.audioEncoding = 4;
                                break;
                            case "AUDIO_ENCODING_AMR_WB":
                            case 5:
                                message.audioEncoding = 5;
                                break;
                            case "AUDIO_ENCODING_OGG_OPUS":
                            case 6:
                                message.audioEncoding = 6;
                                break;
                            case "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE":
                            case 7:
                                message.audioEncoding = 7;
                                break;
                            }
                            if (object.sampleRateHertz != null)
                                message.sampleRateHertz = object.sampleRateHertz | 0;
                            if (object.languageCode != null)
                                message.languageCode = String(object.languageCode);
                            if (object.enableWordInfo != null)
                                message.enableWordInfo = Boolean(object.enableWordInfo);
                            if (object.phraseHints) {
                                if (!Array.isArray(object.phraseHints))
                                    throw TypeError(".google.cloud.dialogflow.v2.InputAudioConfig.phraseHints: array expected");
                                message.phraseHints = [];
                                for (var i = 0; i < object.phraseHints.length; ++i)
                                    message.phraseHints[i] = String(object.phraseHints[i]);
                            }
                            if (object.speechContexts) {
                                if (!Array.isArray(object.speechContexts))
                                    throw TypeError(".google.cloud.dialogflow.v2.InputAudioConfig.speechContexts: array expected");
                                message.speechContexts = [];
                                for (var i = 0; i < object.speechContexts.length; ++i) {
                                    if (typeof object.speechContexts[i] !== "object")
                                        throw TypeError(".google.cloud.dialogflow.v2.InputAudioConfig.speechContexts: object expected");
                                    message.speechContexts[i] = $root.google.cloud.dialogflow.v2.SpeechContext.fromObject(object.speechContexts[i]);
                                }
                            }
                            if (object.model != null)
                                message.model = String(object.model);
                            switch (object.modelVariant) {
                            case "SPEECH_MODEL_VARIANT_UNSPECIFIED":
                            case 0:
                                message.modelVariant = 0;
                                break;
                            case "USE_BEST_AVAILABLE":
                            case 1:
                                message.modelVariant = 1;
                                break;
                            case "USE_STANDARD":
                            case 2:
                                message.modelVariant = 2;
                                break;
                            case "USE_ENHANCED":
                            case 3:
                                message.modelVariant = 3;
                                break;
                            }
                            if (object.singleUtterance != null)
                                message.singleUtterance = Boolean(object.singleUtterance);
                            if (object.disableNoSpeechRecognizedEvent != null)
                                message.disableNoSpeechRecognizedEvent = Boolean(object.disableNoSpeechRecognizedEvent);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an InputAudioConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.InputAudioConfig} message InputAudioConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        InputAudioConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.phraseHints = [];
                                object.speechContexts = [];
                            }
                            if (options.defaults) {
                                object.audioEncoding = options.enums === String ? "AUDIO_ENCODING_UNSPECIFIED" : 0;
                                object.sampleRateHertz = 0;
                                object.languageCode = "";
                                object.model = "";
                                object.singleUtterance = false;
                                object.modelVariant = options.enums === String ? "SPEECH_MODEL_VARIANT_UNSPECIFIED" : 0;
                                object.enableWordInfo = false;
                                object.disableNoSpeechRecognizedEvent = false;
                            }
                            if (message.audioEncoding != null && message.hasOwnProperty("audioEncoding"))
                                object.audioEncoding = options.enums === String ? $root.google.cloud.dialogflow.v2.AudioEncoding[message.audioEncoding] : message.audioEncoding;
                            if (message.sampleRateHertz != null && message.hasOwnProperty("sampleRateHertz"))
                                object.sampleRateHertz = message.sampleRateHertz;
                            if (message.languageCode != null && message.hasOwnProperty("languageCode"))
                                object.languageCode = message.languageCode;
                            if (message.phraseHints && message.phraseHints.length) {
                                object.phraseHints = [];
                                for (var j = 0; j < message.phraseHints.length; ++j)
                                    object.phraseHints[j] = message.phraseHints[j];
                            }
                            if (message.model != null && message.hasOwnProperty("model"))
                                object.model = message.model;
                            if (message.singleUtterance != null && message.hasOwnProperty("singleUtterance"))
                                object.singleUtterance = message.singleUtterance;
                            if (message.modelVariant != null && message.hasOwnProperty("modelVariant"))
                                object.modelVariant = options.enums === String ? $root.google.cloud.dialogflow.v2.SpeechModelVariant[message.modelVariant] : message.modelVariant;
                            if (message.speechContexts && message.speechContexts.length) {
                                object.speechContexts = [];
                                for (var j = 0; j < message.speechContexts.length; ++j)
                                    object.speechContexts[j] = $root.google.cloud.dialogflow.v2.SpeechContext.toObject(message.speechContexts[j], options);
                            }
                            if (message.enableWordInfo != null && message.hasOwnProperty("enableWordInfo"))
                                object.enableWordInfo = message.enableWordInfo;
                            if (message.disableNoSpeechRecognizedEvent != null && message.hasOwnProperty("disableNoSpeechRecognizedEvent"))
                                object.disableNoSpeechRecognizedEvent = message.disableNoSpeechRecognizedEvent;
                            return object;
                        };
    
                        /**
                         * Converts this InputAudioConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.InputAudioConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        InputAudioConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return InputAudioConfig;
                    })();
    
                    /**
                     * SsmlVoiceGender enum.
                     * @name google.cloud.dialogflow.v2.SsmlVoiceGender
                     * @enum {number}
                     * @property {number} SSML_VOICE_GENDER_UNSPECIFIED=0 SSML_VOICE_GENDER_UNSPECIFIED value
                     * @property {number} SSML_VOICE_GENDER_MALE=1 SSML_VOICE_GENDER_MALE value
                     * @property {number} SSML_VOICE_GENDER_FEMALE=2 SSML_VOICE_GENDER_FEMALE value
                     * @property {number} SSML_VOICE_GENDER_NEUTRAL=3 SSML_VOICE_GENDER_NEUTRAL value
                     */
                    v2.SsmlVoiceGender = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "SSML_VOICE_GENDER_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "SSML_VOICE_GENDER_MALE"] = 1;
                        values[valuesById[2] = "SSML_VOICE_GENDER_FEMALE"] = 2;
                        values[valuesById[3] = "SSML_VOICE_GENDER_NEUTRAL"] = 3;
                        return values;
                    })();
    
                    v2.VoiceSelectionParams = (function() {
    
                        /**
                         * Properties of a VoiceSelectionParams.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IVoiceSelectionParams
                         * @property {string|null} [name] VoiceSelectionParams name
                         * @property {google.cloud.dialogflow.v2.SsmlVoiceGender|null} [ssmlGender] VoiceSelectionParams ssmlGender
                         */
    
                        /**
                         * Constructs a new VoiceSelectionParams.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a VoiceSelectionParams.
                         * @implements IVoiceSelectionParams
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IVoiceSelectionParams=} [properties] Properties to set
                         */
                        function VoiceSelectionParams(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * VoiceSelectionParams name.
                         * @member {string} name
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @instance
                         */
                        VoiceSelectionParams.prototype.name = "";
    
                        /**
                         * VoiceSelectionParams ssmlGender.
                         * @member {google.cloud.dialogflow.v2.SsmlVoiceGender} ssmlGender
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @instance
                         */
                        VoiceSelectionParams.prototype.ssmlGender = 0;
    
                        /**
                         * Creates a new VoiceSelectionParams instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {google.cloud.dialogflow.v2.IVoiceSelectionParams=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.VoiceSelectionParams} VoiceSelectionParams instance
                         */
                        VoiceSelectionParams.create = function create(properties) {
                            return new VoiceSelectionParams(properties);
                        };
    
                        /**
                         * Encodes the specified VoiceSelectionParams message. Does not implicitly {@link google.cloud.dialogflow.v2.VoiceSelectionParams.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {google.cloud.dialogflow.v2.IVoiceSelectionParams} message VoiceSelectionParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        VoiceSelectionParams.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.ssmlGender != null && Object.hasOwnProperty.call(message, "ssmlGender"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.ssmlGender);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified VoiceSelectionParams message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.VoiceSelectionParams.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {google.cloud.dialogflow.v2.IVoiceSelectionParams} message VoiceSelectionParams message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        VoiceSelectionParams.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a VoiceSelectionParams message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.VoiceSelectionParams} VoiceSelectionParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        VoiceSelectionParams.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.VoiceSelectionParams();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                case 2:
                                    message.ssmlGender = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a VoiceSelectionParams message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.VoiceSelectionParams} VoiceSelectionParams
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        VoiceSelectionParams.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a VoiceSelectionParams message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        VoiceSelectionParams.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.ssmlGender != null && message.hasOwnProperty("ssmlGender"))
                                switch (message.ssmlGender) {
                                default:
                                    return "ssmlGender: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a VoiceSelectionParams message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.VoiceSelectionParams} VoiceSelectionParams
                         */
                        VoiceSelectionParams.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.VoiceSelectionParams)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.VoiceSelectionParams();
                            if (object.name != null)
                                message.name = String(object.name);
                            switch (object.ssmlGender) {
                            case "SSML_VOICE_GENDER_UNSPECIFIED":
                            case 0:
                                message.ssmlGender = 0;
                                break;
                            case "SSML_VOICE_GENDER_MALE":
                            case 1:
                                message.ssmlGender = 1;
                                break;
                            case "SSML_VOICE_GENDER_FEMALE":
                            case 2:
                                message.ssmlGender = 2;
                                break;
                            case "SSML_VOICE_GENDER_NEUTRAL":
                            case 3:
                                message.ssmlGender = 3;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a VoiceSelectionParams message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @static
                         * @param {google.cloud.dialogflow.v2.VoiceSelectionParams} message VoiceSelectionParams
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        VoiceSelectionParams.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.ssmlGender = options.enums === String ? "SSML_VOICE_GENDER_UNSPECIFIED" : 0;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.ssmlGender != null && message.hasOwnProperty("ssmlGender"))
                                object.ssmlGender = options.enums === String ? $root.google.cloud.dialogflow.v2.SsmlVoiceGender[message.ssmlGender] : message.ssmlGender;
                            return object;
                        };
    
                        /**
                         * Converts this VoiceSelectionParams to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.VoiceSelectionParams
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        VoiceSelectionParams.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return VoiceSelectionParams;
                    })();
    
                    v2.SynthesizeSpeechConfig = (function() {
    
                        /**
                         * Properties of a SynthesizeSpeechConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISynthesizeSpeechConfig
                         * @property {number|null} [speakingRate] SynthesizeSpeechConfig speakingRate
                         * @property {number|null} [pitch] SynthesizeSpeechConfig pitch
                         * @property {number|null} [volumeGainDb] SynthesizeSpeechConfig volumeGainDb
                         * @property {Array.<string>|null} [effectsProfileId] SynthesizeSpeechConfig effectsProfileId
                         * @property {google.cloud.dialogflow.v2.IVoiceSelectionParams|null} [voice] SynthesizeSpeechConfig voice
                         */
    
                        /**
                         * Constructs a new SynthesizeSpeechConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SynthesizeSpeechConfig.
                         * @implements ISynthesizeSpeechConfig
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISynthesizeSpeechConfig=} [properties] Properties to set
                         */
                        function SynthesizeSpeechConfig(properties) {
                            this.effectsProfileId = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SynthesizeSpeechConfig speakingRate.
                         * @member {number} speakingRate
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @instance
                         */
                        SynthesizeSpeechConfig.prototype.speakingRate = 0;
    
                        /**
                         * SynthesizeSpeechConfig pitch.
                         * @member {number} pitch
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @instance
                         */
                        SynthesizeSpeechConfig.prototype.pitch = 0;
    
                        /**
                         * SynthesizeSpeechConfig volumeGainDb.
                         * @member {number} volumeGainDb
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @instance
                         */
                        SynthesizeSpeechConfig.prototype.volumeGainDb = 0;
    
                        /**
                         * SynthesizeSpeechConfig effectsProfileId.
                         * @member {Array.<string>} effectsProfileId
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @instance
                         */
                        SynthesizeSpeechConfig.prototype.effectsProfileId = $util.emptyArray;
    
                        /**
                         * SynthesizeSpeechConfig voice.
                         * @member {google.cloud.dialogflow.v2.IVoiceSelectionParams|null|undefined} voice
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @instance
                         */
                        SynthesizeSpeechConfig.prototype.voice = null;
    
                        /**
                         * Creates a new SynthesizeSpeechConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISynthesizeSpeechConfig=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SynthesizeSpeechConfig} SynthesizeSpeechConfig instance
                         */
                        SynthesizeSpeechConfig.create = function create(properties) {
                            return new SynthesizeSpeechConfig(properties);
                        };
    
                        /**
                         * Encodes the specified SynthesizeSpeechConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.SynthesizeSpeechConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISynthesizeSpeechConfig} message SynthesizeSpeechConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SynthesizeSpeechConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.speakingRate != null && Object.hasOwnProperty.call(message, "speakingRate"))
                                writer.uint32(/* id 1, wireType 1 =*/9).double(message.speakingRate);
                            if (message.pitch != null && Object.hasOwnProperty.call(message, "pitch"))
                                writer.uint32(/* id 2, wireType 1 =*/17).double(message.pitch);
                            if (message.volumeGainDb != null && Object.hasOwnProperty.call(message, "volumeGainDb"))
                                writer.uint32(/* id 3, wireType 1 =*/25).double(message.volumeGainDb);
                            if (message.voice != null && Object.hasOwnProperty.call(message, "voice"))
                                $root.google.cloud.dialogflow.v2.VoiceSelectionParams.encode(message.voice, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.effectsProfileId != null && message.effectsProfileId.length)
                                for (var i = 0; i < message.effectsProfileId.length; ++i)
                                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.effectsProfileId[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SynthesizeSpeechConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SynthesizeSpeechConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISynthesizeSpeechConfig} message SynthesizeSpeechConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SynthesizeSpeechConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SynthesizeSpeechConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SynthesizeSpeechConfig} SynthesizeSpeechConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SynthesizeSpeechConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.speakingRate = reader.double();
                                    break;
                                case 2:
                                    message.pitch = reader.double();
                                    break;
                                case 3:
                                    message.volumeGainDb = reader.double();
                                    break;
                                case 5:
                                    if (!(message.effectsProfileId && message.effectsProfileId.length))
                                        message.effectsProfileId = [];
                                    message.effectsProfileId.push(reader.string());
                                    break;
                                case 4:
                                    message.voice = $root.google.cloud.dialogflow.v2.VoiceSelectionParams.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SynthesizeSpeechConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SynthesizeSpeechConfig} SynthesizeSpeechConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SynthesizeSpeechConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SynthesizeSpeechConfig message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SynthesizeSpeechConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.speakingRate != null && message.hasOwnProperty("speakingRate"))
                                if (typeof message.speakingRate !== "number")
                                    return "speakingRate: number expected";
                            if (message.pitch != null && message.hasOwnProperty("pitch"))
                                if (typeof message.pitch !== "number")
                                    return "pitch: number expected";
                            if (message.volumeGainDb != null && message.hasOwnProperty("volumeGainDb"))
                                if (typeof message.volumeGainDb !== "number")
                                    return "volumeGainDb: number expected";
                            if (message.effectsProfileId != null && message.hasOwnProperty("effectsProfileId")) {
                                if (!Array.isArray(message.effectsProfileId))
                                    return "effectsProfileId: array expected";
                                for (var i = 0; i < message.effectsProfileId.length; ++i)
                                    if (!$util.isString(message.effectsProfileId[i]))
                                        return "effectsProfileId: string[] expected";
                            }
                            if (message.voice != null && message.hasOwnProperty("voice")) {
                                var error = $root.google.cloud.dialogflow.v2.VoiceSelectionParams.verify(message.voice);
                                if (error)
                                    return "voice." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a SynthesizeSpeechConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SynthesizeSpeechConfig} SynthesizeSpeechConfig
                         */
                        SynthesizeSpeechConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig();
                            if (object.speakingRate != null)
                                message.speakingRate = Number(object.speakingRate);
                            if (object.pitch != null)
                                message.pitch = Number(object.pitch);
                            if (object.volumeGainDb != null)
                                message.volumeGainDb = Number(object.volumeGainDb);
                            if (object.effectsProfileId) {
                                if (!Array.isArray(object.effectsProfileId))
                                    throw TypeError(".google.cloud.dialogflow.v2.SynthesizeSpeechConfig.effectsProfileId: array expected");
                                message.effectsProfileId = [];
                                for (var i = 0; i < object.effectsProfileId.length; ++i)
                                    message.effectsProfileId[i] = String(object.effectsProfileId[i]);
                            }
                            if (object.voice != null) {
                                if (typeof object.voice !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.SynthesizeSpeechConfig.voice: object expected");
                                message.voice = $root.google.cloud.dialogflow.v2.VoiceSelectionParams.fromObject(object.voice);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SynthesizeSpeechConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.SynthesizeSpeechConfig} message SynthesizeSpeechConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SynthesizeSpeechConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.effectsProfileId = [];
                            if (options.defaults) {
                                object.speakingRate = 0;
                                object.pitch = 0;
                                object.volumeGainDb = 0;
                                object.voice = null;
                            }
                            if (message.speakingRate != null && message.hasOwnProperty("speakingRate"))
                                object.speakingRate = options.json && !isFinite(message.speakingRate) ? String(message.speakingRate) : message.speakingRate;
                            if (message.pitch != null && message.hasOwnProperty("pitch"))
                                object.pitch = options.json && !isFinite(message.pitch) ? String(message.pitch) : message.pitch;
                            if (message.volumeGainDb != null && message.hasOwnProperty("volumeGainDb"))
                                object.volumeGainDb = options.json && !isFinite(message.volumeGainDb) ? String(message.volumeGainDb) : message.volumeGainDb;
                            if (message.voice != null && message.hasOwnProperty("voice"))
                                object.voice = $root.google.cloud.dialogflow.v2.VoiceSelectionParams.toObject(message.voice, options);
                            if (message.effectsProfileId && message.effectsProfileId.length) {
                                object.effectsProfileId = [];
                                for (var j = 0; j < message.effectsProfileId.length; ++j)
                                    object.effectsProfileId[j] = message.effectsProfileId[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this SynthesizeSpeechConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SynthesizeSpeechConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SynthesizeSpeechConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SynthesizeSpeechConfig;
                    })();
    
                    /**
                     * OutputAudioEncoding enum.
                     * @name google.cloud.dialogflow.v2.OutputAudioEncoding
                     * @enum {number}
                     * @property {number} OUTPUT_AUDIO_ENCODING_UNSPECIFIED=0 OUTPUT_AUDIO_ENCODING_UNSPECIFIED value
                     * @property {number} OUTPUT_AUDIO_ENCODING_LINEAR_16=1 OUTPUT_AUDIO_ENCODING_LINEAR_16 value
                     * @property {number} OUTPUT_AUDIO_ENCODING_MP3=2 OUTPUT_AUDIO_ENCODING_MP3 value
                     * @property {number} OUTPUT_AUDIO_ENCODING_MP3_64_KBPS=4 OUTPUT_AUDIO_ENCODING_MP3_64_KBPS value
                     * @property {number} OUTPUT_AUDIO_ENCODING_OGG_OPUS=3 OUTPUT_AUDIO_ENCODING_OGG_OPUS value
                     * @property {number} OUTPUT_AUDIO_ENCODING_MULAW=5 OUTPUT_AUDIO_ENCODING_MULAW value
                     */
                    v2.OutputAudioEncoding = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "OUTPUT_AUDIO_ENCODING_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "OUTPUT_AUDIO_ENCODING_LINEAR_16"] = 1;
                        values[valuesById[2] = "OUTPUT_AUDIO_ENCODING_MP3"] = 2;
                        values[valuesById[4] = "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS"] = 4;
                        values[valuesById[3] = "OUTPUT_AUDIO_ENCODING_OGG_OPUS"] = 3;
                        values[valuesById[5] = "OUTPUT_AUDIO_ENCODING_MULAW"] = 5;
                        return values;
                    })();
    
                    v2.OutputAudioConfig = (function() {
    
                        /**
                         * Properties of an OutputAudioConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IOutputAudioConfig
                         * @property {google.cloud.dialogflow.v2.OutputAudioEncoding|null} [audioEncoding] OutputAudioConfig audioEncoding
                         * @property {number|null} [sampleRateHertz] OutputAudioConfig sampleRateHertz
                         * @property {google.cloud.dialogflow.v2.ISynthesizeSpeechConfig|null} [synthesizeSpeechConfig] OutputAudioConfig synthesizeSpeechConfig
                         */
    
                        /**
                         * Constructs a new OutputAudioConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents an OutputAudioConfig.
                         * @implements IOutputAudioConfig
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IOutputAudioConfig=} [properties] Properties to set
                         */
                        function OutputAudioConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OutputAudioConfig audioEncoding.
                         * @member {google.cloud.dialogflow.v2.OutputAudioEncoding} audioEncoding
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @instance
                         */
                        OutputAudioConfig.prototype.audioEncoding = 0;
    
                        /**
                         * OutputAudioConfig sampleRateHertz.
                         * @member {number} sampleRateHertz
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @instance
                         */
                        OutputAudioConfig.prototype.sampleRateHertz = 0;
    
                        /**
                         * OutputAudioConfig synthesizeSpeechConfig.
                         * @member {google.cloud.dialogflow.v2.ISynthesizeSpeechConfig|null|undefined} synthesizeSpeechConfig
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @instance
                         */
                        OutputAudioConfig.prototype.synthesizeSpeechConfig = null;
    
                        /**
                         * Creates a new OutputAudioConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.IOutputAudioConfig=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.OutputAudioConfig} OutputAudioConfig instance
                         */
                        OutputAudioConfig.create = function create(properties) {
                            return new OutputAudioConfig(properties);
                        };
    
                        /**
                         * Encodes the specified OutputAudioConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudioConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.IOutputAudioConfig} message OutputAudioConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OutputAudioConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.audioEncoding != null && Object.hasOwnProperty.call(message, "audioEncoding"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.audioEncoding);
                            if (message.sampleRateHertz != null && Object.hasOwnProperty.call(message, "sampleRateHertz"))
                                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.sampleRateHertz);
                            if (message.synthesizeSpeechConfig != null && Object.hasOwnProperty.call(message, "synthesizeSpeechConfig"))
                                $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig.encode(message.synthesizeSpeechConfig, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OutputAudioConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.OutputAudioConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.IOutputAudioConfig} message OutputAudioConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OutputAudioConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OutputAudioConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.OutputAudioConfig} OutputAudioConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OutputAudioConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.OutputAudioConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.audioEncoding = reader.int32();
                                    break;
                                case 2:
                                    message.sampleRateHertz = reader.int32();
                                    break;
                                case 3:
                                    message.synthesizeSpeechConfig = $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OutputAudioConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.OutputAudioConfig} OutputAudioConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OutputAudioConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OutputAudioConfig message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OutputAudioConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.audioEncoding != null && message.hasOwnProperty("audioEncoding"))
                                switch (message.audioEncoding) {
                                default:
                                    return "audioEncoding: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 4:
                                case 3:
                                case 5:
                                    break;
                                }
                            if (message.sampleRateHertz != null && message.hasOwnProperty("sampleRateHertz"))
                                if (!$util.isInteger(message.sampleRateHertz))
                                    return "sampleRateHertz: integer expected";
                            if (message.synthesizeSpeechConfig != null && message.hasOwnProperty("synthesizeSpeechConfig")) {
                                var error = $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig.verify(message.synthesizeSpeechConfig);
                                if (error)
                                    return "synthesizeSpeechConfig." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates an OutputAudioConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.OutputAudioConfig} OutputAudioConfig
                         */
                        OutputAudioConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.OutputAudioConfig)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.OutputAudioConfig();
                            switch (object.audioEncoding) {
                            case "OUTPUT_AUDIO_ENCODING_UNSPECIFIED":
                            case 0:
                                message.audioEncoding = 0;
                                break;
                            case "OUTPUT_AUDIO_ENCODING_LINEAR_16":
                            case 1:
                                message.audioEncoding = 1;
                                break;
                            case "OUTPUT_AUDIO_ENCODING_MP3":
                            case 2:
                                message.audioEncoding = 2;
                                break;
                            case "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS":
                            case 4:
                                message.audioEncoding = 4;
                                break;
                            case "OUTPUT_AUDIO_ENCODING_OGG_OPUS":
                            case 3:
                                message.audioEncoding = 3;
                                break;
                            case "OUTPUT_AUDIO_ENCODING_MULAW":
                            case 5:
                                message.audioEncoding = 5;
                                break;
                            }
                            if (object.sampleRateHertz != null)
                                message.sampleRateHertz = object.sampleRateHertz | 0;
                            if (object.synthesizeSpeechConfig != null) {
                                if (typeof object.synthesizeSpeechConfig !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.OutputAudioConfig.synthesizeSpeechConfig: object expected");
                                message.synthesizeSpeechConfig = $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig.fromObject(object.synthesizeSpeechConfig);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OutputAudioConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.OutputAudioConfig} message OutputAudioConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OutputAudioConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.audioEncoding = options.enums === String ? "OUTPUT_AUDIO_ENCODING_UNSPECIFIED" : 0;
                                object.sampleRateHertz = 0;
                                object.synthesizeSpeechConfig = null;
                            }
                            if (message.audioEncoding != null && message.hasOwnProperty("audioEncoding"))
                                object.audioEncoding = options.enums === String ? $root.google.cloud.dialogflow.v2.OutputAudioEncoding[message.audioEncoding] : message.audioEncoding;
                            if (message.sampleRateHertz != null && message.hasOwnProperty("sampleRateHertz"))
                                object.sampleRateHertz = message.sampleRateHertz;
                            if (message.synthesizeSpeechConfig != null && message.hasOwnProperty("synthesizeSpeechConfig"))
                                object.synthesizeSpeechConfig = $root.google.cloud.dialogflow.v2.SynthesizeSpeechConfig.toObject(message.synthesizeSpeechConfig, options);
                            return object;
                        };
    
                        /**
                         * Converts this OutputAudioConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.OutputAudioConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OutputAudioConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return OutputAudioConfig;
                    })();
    
                    v2.SpeechToTextConfig = (function() {
    
                        /**
                         * Properties of a SpeechToTextConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface ISpeechToTextConfig
                         * @property {google.cloud.dialogflow.v2.SpeechModelVariant|null} [speechModelVariant] SpeechToTextConfig speechModelVariant
                         */
    
                        /**
                         * Constructs a new SpeechToTextConfig.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a SpeechToTextConfig.
                         * @implements ISpeechToTextConfig
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.ISpeechToTextConfig=} [properties] Properties to set
                         */
                        function SpeechToTextConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SpeechToTextConfig speechModelVariant.
                         * @member {google.cloud.dialogflow.v2.SpeechModelVariant} speechModelVariant
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @instance
                         */
                        SpeechToTextConfig.prototype.speechModelVariant = 0;
    
                        /**
                         * Creates a new SpeechToTextConfig instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechToTextConfig=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.SpeechToTextConfig} SpeechToTextConfig instance
                         */
                        SpeechToTextConfig.create = function create(properties) {
                            return new SpeechToTextConfig(properties);
                        };
    
                        /**
                         * Encodes the specified SpeechToTextConfig message. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechToTextConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechToTextConfig} message SpeechToTextConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SpeechToTextConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.speechModelVariant != null && Object.hasOwnProperty.call(message, "speechModelVariant"))
                                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.speechModelVariant);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SpeechToTextConfig message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.SpeechToTextConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.ISpeechToTextConfig} message SpeechToTextConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SpeechToTextConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SpeechToTextConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.SpeechToTextConfig} SpeechToTextConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SpeechToTextConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.SpeechToTextConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.speechModelVariant = reader.int32();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SpeechToTextConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.SpeechToTextConfig} SpeechToTextConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SpeechToTextConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SpeechToTextConfig message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SpeechToTextConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.speechModelVariant != null && message.hasOwnProperty("speechModelVariant"))
                                switch (message.speechModelVariant) {
                                default:
                                    return "speechModelVariant: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                    break;
                                }
                            return null;
                        };
    
                        /**
                         * Creates a SpeechToTextConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.SpeechToTextConfig} SpeechToTextConfig
                         */
                        SpeechToTextConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.SpeechToTextConfig)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.SpeechToTextConfig();
                            switch (object.speechModelVariant) {
                            case "SPEECH_MODEL_VARIANT_UNSPECIFIED":
                            case 0:
                                message.speechModelVariant = 0;
                                break;
                            case "USE_BEST_AVAILABLE":
                            case 1:
                                message.speechModelVariant = 1;
                                break;
                            case "USE_STANDARD":
                            case 2:
                                message.speechModelVariant = 2;
                                break;
                            case "USE_ENHANCED":
                            case 3:
                                message.speechModelVariant = 3;
                                break;
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SpeechToTextConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @static
                         * @param {google.cloud.dialogflow.v2.SpeechToTextConfig} message SpeechToTextConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SpeechToTextConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.speechModelVariant = options.enums === String ? "SPEECH_MODEL_VARIANT_UNSPECIFIED" : 0;
                            if (message.speechModelVariant != null && message.hasOwnProperty("speechModelVariant"))
                                object.speechModelVariant = options.enums === String ? $root.google.cloud.dialogflow.v2.SpeechModelVariant[message.speechModelVariant] : message.speechModelVariant;
                            return object;
                        };
    
                        /**
                         * Converts this SpeechToTextConfig to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.SpeechToTextConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SpeechToTextConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return SpeechToTextConfig;
                    })();
    
                    v2.Sessions = (function() {
    
                        /**
                         * Constructs a new Sessions service.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a Sessions
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Sessions(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }
    
                        (Sessions.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Sessions;
    
                        /**
                         * Creates new Sessions service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.Sessions
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Sessions} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Sessions.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Sessions#detectIntent}.
                         * @memberof google.cloud.dialogflow.v2.Sessions
                         * @typedef DetectIntentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.DetectIntentResponse} [response] DetectIntentResponse
                         */
    
                        /**
                         * Calls DetectIntent.
                         * @function detectIntent
                         * @memberof google.cloud.dialogflow.v2.Sessions
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IDetectIntentRequest} request DetectIntentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Sessions.DetectIntentCallback} callback Node-style callback called with the error, if any, and DetectIntentResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Sessions.prototype.detectIntent = function detectIntent(request, callback) {
                            return this.rpcCall(detectIntent, $root.google.cloud.dialogflow.v2.DetectIntentRequest, $root.google.cloud.dialogflow.v2.DetectIntentResponse, request, callback);
                        }, "name", { value: "DetectIntent" });
    
                        /**
                         * Calls DetectIntent.
                         * @function detectIntent
                         * @memberof google.cloud.dialogflow.v2.Sessions
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IDetectIntentRequest} request DetectIntentRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.DetectIntentResponse>} Promise
                         * @variation 2
                         */
    
                        /**
                         * Callback as used by {@link google.cloud.dialogflow.v2.Sessions#streamingDetectIntent}.
                         * @memberof google.cloud.dialogflow.v2.Sessions
                         * @typedef StreamingDetectIntentCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.dialogflow.v2.StreamingDetectIntentResponse} [response] StreamingDetectIntentResponse
                         */
    
                        /**
                         * Calls StreamingDetectIntent.
                         * @function streamingDetectIntent
                         * @memberof google.cloud.dialogflow.v2.Sessions
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IStreamingDetectIntentRequest} request StreamingDetectIntentRequest message or plain object
                         * @param {google.cloud.dialogflow.v2.Sessions.StreamingDetectIntentCallback} callback Node-style callback called with the error, if any, and StreamingDetectIntentResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Sessions.prototype.streamingDetectIntent = function streamingDetectIntent(request, callback) {
                            return this.rpcCall(streamingDetectIntent, $root.google.cloud.dialogflow.v2.StreamingDetectIntentRequest, $root.google.cloud.dialogflow.v2.StreamingDetectIntentResponse, request, callback);
                        }, "name", { value: "StreamingDetectIntent" });
    
                        /**
                         * Calls StreamingDetectIntent.
                         * @function streamingDetectIntent
                         * @memberof google.cloud.dialogflow.v2.Sessions
                         * @instance
                         * @param {google.cloud.dialogflow.v2.IStreamingDetectIntentRequest} request StreamingDetectIntentRequest message or plain object
                         * @returns {Promise<google.cloud.dialogflow.v2.StreamingDetectIntentResponse>} Promise
                         * @variation 2
                         */
    
                        return Sessions;
                    })();
    
                    v2.DetectIntentRequest = (function() {
    
                        /**
                         * Properties of a DetectIntentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IDetectIntentRequest
                         * @property {string|null} [session] DetectIntentRequest session
                         * @property {google.cloud.dialogflow.v2.IQueryParameters|null} [queryParams] DetectIntentRequest queryParams
                         * @property {google.cloud.dialogflow.v2.IQueryInput|null} [queryInput] DetectIntentRequest queryInput
                         * @property {google.cloud.dialogflow.v2.IOutputAudioConfig|null} [outputAudioConfig] DetectIntentRequest outputAudioConfig
                         * @property {google.protobuf.IFieldMask|null} [outputAudioConfigMask] DetectIntentRequest outputAudioConfigMask
                         * @property {Uint8Array|null} [inputAudio] DetectIntentRequest inputAudio
                         */
    
                        /**
                         * Constructs a new DetectIntentRequest.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a DetectIntentRequest.
                         * @implements IDetectIntentRequest
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IDetectIntentRequest=} [properties] Properties to set
                         */
                        function DetectIntentRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DetectIntentRequest session.
                         * @member {string} session
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @instance
                         */
                        DetectIntentRequest.prototype.session = "";
    
                        /**
                         * DetectIntentRequest queryParams.
                         * @member {google.cloud.dialogflow.v2.IQueryParameters|null|undefined} queryParams
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @instance
                         */
                        DetectIntentRequest.prototype.queryParams = null;
    
                        /**
                         * DetectIntentRequest queryInput.
                         * @member {google.cloud.dialogflow.v2.IQueryInput|null|undefined} queryInput
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @instance
                         */
                        DetectIntentRequest.prototype.queryInput = null;
    
                        /**
                         * DetectIntentRequest outputAudioConfig.
                         * @member {google.cloud.dialogflow.v2.IOutputAudioConfig|null|undefined} outputAudioConfig
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @instance
                         */
                        DetectIntentRequest.prototype.outputAudioConfig = null;
    
                        /**
                         * DetectIntentRequest outputAudioConfigMask.
                         * @member {google.protobuf.IFieldMask|null|undefined} outputAudioConfigMask
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @instance
                         */
                        DetectIntentRequest.prototype.outputAudioConfigMask = null;
    
                        /**
                         * DetectIntentRequest inputAudio.
                         * @member {Uint8Array} inputAudio
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @instance
                         */
                        DetectIntentRequest.prototype.inputAudio = $util.newBuffer([]);
    
                        /**
                         * Creates a new DetectIntentRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDetectIntentRequest=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.DetectIntentRequest} DetectIntentRequest instance
                         */
                        DetectIntentRequest.create = function create(properties) {
                            return new DetectIntentRequest(properties);
                        };
    
                        /**
                         * Encodes the specified DetectIntentRequest message. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDetectIntentRequest} message DetectIntentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DetectIntentRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.session != null && Object.hasOwnProperty.call(message, "session"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.session);
                            if (message.queryParams != null && Object.hasOwnProperty.call(message, "queryParams"))
                                $root.google.cloud.dialogflow.v2.QueryParameters.encode(message.queryParams, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.queryInput != null && Object.hasOwnProperty.call(message, "queryInput"))
                                $root.google.cloud.dialogflow.v2.QueryInput.encode(message.queryInput, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.outputAudioConfig != null && Object.hasOwnProperty.call(message, "outputAudioConfig"))
                                $root.google.cloud.dialogflow.v2.OutputAudioConfig.encode(message.outputAudioConfig, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.inputAudio != null && Object.hasOwnProperty.call(message, "inputAudio"))
                                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.inputAudio);
                            if (message.outputAudioConfigMask != null && Object.hasOwnProperty.call(message, "outputAudioConfigMask"))
                                $root.google.protobuf.FieldMask.encode(message.outputAudioConfigMask, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DetectIntentRequest message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDetectIntentRequest} message DetectIntentRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DetectIntentRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DetectIntentRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.DetectIntentRequest} DetectIntentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DetectIntentRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.DetectIntentRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.session = reader.string();
                                    break;
                                case 2:
                                    message.queryParams = $root.google.cloud.dialogflow.v2.QueryParameters.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.queryInput = $root.google.cloud.dialogflow.v2.QueryInput.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.outputAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.decode(reader, reader.uint32());
                                    break;
                                case 7:
                                    message.outputAudioConfigMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                case 5:
                                    message.inputAudio = reader.bytes();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DetectIntentRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.DetectIntentRequest} DetectIntentRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DetectIntentRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DetectIntentRequest message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DetectIntentRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.session != null && message.hasOwnProperty("session"))
                                if (!$util.isString(message.session))
                                    return "session: string expected";
                            if (message.queryParams != null && message.hasOwnProperty("queryParams")) {
                                var error = $root.google.cloud.dialogflow.v2.QueryParameters.verify(message.queryParams);
                                if (error)
                                    return "queryParams." + error;
                            }
                            if (message.queryInput != null && message.hasOwnProperty("queryInput")) {
                                var error = $root.google.cloud.dialogflow.v2.QueryInput.verify(message.queryInput);
                                if (error)
                                    return "queryInput." + error;
                            }
                            if (message.outputAudioConfig != null && message.hasOwnProperty("outputAudioConfig")) {
                                var error = $root.google.cloud.dialogflow.v2.OutputAudioConfig.verify(message.outputAudioConfig);
                                if (error)
                                    return "outputAudioConfig." + error;
                            }
                            if (message.outputAudioConfigMask != null && message.hasOwnProperty("outputAudioConfigMask")) {
                                var error = $root.google.protobuf.FieldMask.verify(message.outputAudioConfigMask);
                                if (error)
                                    return "outputAudioConfigMask." + error;
                            }
                            if (message.inputAudio != null && message.hasOwnProperty("inputAudio"))
                                if (!(message.inputAudio && typeof message.inputAudio.length === "number" || $util.isString(message.inputAudio)))
                                    return "inputAudio: buffer expected";
                            return null;
                        };
    
                        /**
                         * Creates a DetectIntentRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.DetectIntentRequest} DetectIntentRequest
                         */
                        DetectIntentRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.DetectIntentRequest)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.DetectIntentRequest();
                            if (object.session != null)
                                message.session = String(object.session);
                            if (object.queryParams != null) {
                                if (typeof object.queryParams !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.DetectIntentRequest.queryParams: object expected");
                                message.queryParams = $root.google.cloud.dialogflow.v2.QueryParameters.fromObject(object.queryParams);
                            }
                            if (object.queryInput != null) {
                                if (typeof object.queryInput !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.DetectIntentRequest.queryInput: object expected");
                                message.queryInput = $root.google.cloud.dialogflow.v2.QueryInput.fromObject(object.queryInput);
                            }
                            if (object.outputAudioConfig != null) {
                                if (typeof object.outputAudioConfig !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.DetectIntentRequest.outputAudioConfig: object expected");
                                message.outputAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.fromObject(object.outputAudioConfig);
                            }
                            if (object.outputAudioConfigMask != null) {
                                if (typeof object.outputAudioConfigMask !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.DetectIntentRequest.outputAudioConfigMask: object expected");
                                message.outputAudioConfigMask = $root.google.protobuf.FieldMask.fromObject(object.outputAudioConfigMask);
                            }
                            if (object.inputAudio != null)
                                if (typeof object.inputAudio === "string")
                                    $util.base64.decode(object.inputAudio, message.inputAudio = $util.newBuffer($util.base64.length(object.inputAudio)), 0);
                                else if (object.inputAudio.length)
                                    message.inputAudio = object.inputAudio;
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DetectIntentRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @static
                         * @param {google.cloud.dialogflow.v2.DetectIntentRequest} message DetectIntentRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DetectIntentRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.session = "";
                                object.queryParams = null;
                                object.queryInput = null;
                                object.outputAudioConfig = null;
                                if (options.bytes === String)
                                    object.inputAudio = "";
                                else {
                                    object.inputAudio = [];
                                    if (options.bytes !== Array)
                                        object.inputAudio = $util.newBuffer(object.inputAudio);
                                }
                                object.outputAudioConfigMask = null;
                            }
                            if (message.session != null && message.hasOwnProperty("session"))
                                object.session = message.session;
                            if (message.queryParams != null && message.hasOwnProperty("queryParams"))
                                object.queryParams = $root.google.cloud.dialogflow.v2.QueryParameters.toObject(message.queryParams, options);
                            if (message.queryInput != null && message.hasOwnProperty("queryInput"))
                                object.queryInput = $root.google.cloud.dialogflow.v2.QueryInput.toObject(message.queryInput, options);
                            if (message.outputAudioConfig != null && message.hasOwnProperty("outputAudioConfig"))
                                object.outputAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.toObject(message.outputAudioConfig, options);
                            if (message.inputAudio != null && message.hasOwnProperty("inputAudio"))
                                object.inputAudio = options.bytes === String ? $util.base64.encode(message.inputAudio, 0, message.inputAudio.length) : options.bytes === Array ? Array.prototype.slice.call(message.inputAudio) : message.inputAudio;
                            if (message.outputAudioConfigMask != null && message.hasOwnProperty("outputAudioConfigMask"))
                                object.outputAudioConfigMask = $root.google.protobuf.FieldMask.toObject(message.outputAudioConfigMask, options);
                            return object;
                        };
    
                        /**
                         * Converts this DetectIntentRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.DetectIntentRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DetectIntentRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return DetectIntentRequest;
                    })();
    
                    v2.DetectIntentResponse = (function() {
    
                        /**
                         * Properties of a DetectIntentResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IDetectIntentResponse
                         * @property {string|null} [responseId] DetectIntentResponse responseId
                         * @property {google.cloud.dialogflow.v2.IQueryResult|null} [queryResult] DetectIntentResponse queryResult
                         * @property {google.rpc.IStatus|null} [webhookStatus] DetectIntentResponse webhookStatus
                         * @property {Uint8Array|null} [outputAudio] DetectIntentResponse outputAudio
                         * @property {google.cloud.dialogflow.v2.IOutputAudioConfig|null} [outputAudioConfig] DetectIntentResponse outputAudioConfig
                         */
    
                        /**
                         * Constructs a new DetectIntentResponse.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a DetectIntentResponse.
                         * @implements IDetectIntentResponse
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IDetectIntentResponse=} [properties] Properties to set
                         */
                        function DetectIntentResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * DetectIntentResponse responseId.
                         * @member {string} responseId
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @instance
                         */
                        DetectIntentResponse.prototype.responseId = "";
    
                        /**
                         * DetectIntentResponse queryResult.
                         * @member {google.cloud.dialogflow.v2.IQueryResult|null|undefined} queryResult
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @instance
                         */
                        DetectIntentResponse.prototype.queryResult = null;
    
                        /**
                         * DetectIntentResponse webhookStatus.
                         * @member {google.rpc.IStatus|null|undefined} webhookStatus
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @instance
                         */
                        DetectIntentResponse.prototype.webhookStatus = null;
    
                        /**
                         * DetectIntentResponse outputAudio.
                         * @member {Uint8Array} outputAudio
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @instance
                         */
                        DetectIntentResponse.prototype.outputAudio = $util.newBuffer([]);
    
                        /**
                         * DetectIntentResponse outputAudioConfig.
                         * @member {google.cloud.dialogflow.v2.IOutputAudioConfig|null|undefined} outputAudioConfig
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @instance
                         */
                        DetectIntentResponse.prototype.outputAudioConfig = null;
    
                        /**
                         * Creates a new DetectIntentResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDetectIntentResponse=} [properties] Properties to set
                         * @returns {google.cloud.dialogflow.v2.DetectIntentResponse} DetectIntentResponse instance
                         */
                        DetectIntentResponse.create = function create(properties) {
                            return new DetectIntentResponse(properties);
                        };
    
                        /**
                         * Encodes the specified DetectIntentResponse message. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDetectIntentResponse} message DetectIntentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DetectIntentResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.responseId != null && Object.hasOwnProperty.call(message, "responseId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.responseId);
                            if (message.queryResult != null && Object.hasOwnProperty.call(message, "queryResult"))
                                $root.google.cloud.dialogflow.v2.QueryResult.encode(message.queryResult, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.webhookStatus != null && Object.hasOwnProperty.call(message, "webhookStatus"))
                                $root.google.rpc.Status.encode(message.webhookStatus, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.outputAudio != null && Object.hasOwnProperty.call(message, "outputAudio"))
                                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.outputAudio);
                            if (message.outputAudioConfig != null && Object.hasOwnProperty.call(message, "outputAudioConfig"))
                                $root.google.cloud.dialogflow.v2.OutputAudioConfig.encode(message.outputAudioConfig, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified DetectIntentResponse message, length delimited. Does not implicitly {@link google.cloud.dialogflow.v2.DetectIntentResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.IDetectIntentResponse} message DetectIntentResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DetectIntentResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a DetectIntentResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.dialogflow.v2.DetectIntentResponse} DetectIntentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DetectIntentResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.dialogflow.v2.DetectIntentResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.responseId = reader.string();
                                    break;
                                case 2:
                                    message.queryResult = $root.google.cloud.dialogflow.v2.QueryResult.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.webhookStatus = $root.google.rpc.Status.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.outputAudio = reader.bytes();
                                    break;
                                case 6:
                                    message.outputAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a DetectIntentResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.dialogflow.v2.DetectIntentResponse} DetectIntentResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DetectIntentResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a DetectIntentResponse message.
                         * @function verify
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DetectIntentResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.responseId != null && message.hasOwnProperty("responseId"))
                                if (!$util.isString(message.responseId))
                                    return "responseId: string expected";
                            if (message.queryResult != null && message.hasOwnProperty("queryResult")) {
                                var error = $root.google.cloud.dialogflow.v2.QueryResult.verify(message.queryResult);
                                if (error)
                                    return "queryResult." + error;
                            }
                            if (message.webhookStatus != null && message.hasOwnProperty("webhookStatus")) {
                                var error = $root.google.rpc.Status.verify(message.webhookStatus);
                                if (error)
                                    return "webhookStatus." + error;
                            }
                            if (message.outputAudio != null && message.hasOwnProperty("outputAudio"))
                                if (!(message.outputAudio && typeof message.outputAudio.length === "number" || $util.isString(message.outputAudio)))
                                    return "outputAudio: buffer expected";
                            if (message.outputAudioConfig != null && message.hasOwnProperty("outputAudioConfig")) {
                                var error = $root.google.cloud.dialogflow.v2.OutputAudioConfig.verify(message.outputAudioConfig);
                                if (error)
                                    return "outputAudioConfig." + error;
                            }
                            return null;
                        };
    
                        /**
                         * Creates a DetectIntentResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.dialogflow.v2.DetectIntentResponse} DetectIntentResponse
                         */
                        DetectIntentResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.dialogflow.v2.DetectIntentResponse)
                                return object;
                            var message = new $root.google.cloud.dialogflow.v2.DetectIntentResponse();
                            if (object.responseId != null)
                                message.responseId = String(object.responseId);
                            if (object.queryResult != null) {
                                if (typeof object.queryResult !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.DetectIntentResponse.queryResult: object expected");
                                message.queryResult = $root.google.cloud.dialogflow.v2.QueryResult.fromObject(object.queryResult);
                            }
                            if (object.webhookStatus != null) {
                                if (typeof object.webhookStatus !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.DetectIntentResponse.webhookStatus: object expected");
                                message.webhookStatus = $root.google.rpc.Status.fromObject(object.webhookStatus);
                            }
                            if (object.outputAudio != null)
                                if (typeof object.outputAudio === "string")
                                    $util.base64.decode(object.outputAudio, message.outputAudio = $util.newBuffer($util.base64.length(object.outputAudio)), 0);
                                else if (object.outputAudio.length)
                                    message.outputAudio = object.outputAudio;
                            if (object.outputAudioConfig != null) {
                                if (typeof object.outputAudioConfig !== "object")
                                    throw TypeError(".google.cloud.dialogflow.v2.DetectIntentResponse.outputAudioConfig: object expected");
                                message.outputAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.fromObject(object.outputAudioConfig);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a DetectIntentResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @static
                         * @param {google.cloud.dialogflow.v2.DetectIntentResponse} message DetectIntentResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DetectIntentResponse.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.responseId = "";
                                object.queryResult = null;
                                object.webhookStatus = null;
                                if (options.bytes === String)
                                    object.outputAudio = "";
                                else {
                                    object.outputAudio = [];
                                    if (options.bytes !== Array)
                                        object.outputAudio = $util.newBuffer(object.outputAudio);
                                }
                                object.outputAudioConfig = null;
                            }
                            if (message.responseId != null && message.hasOwnProperty("responseId"))
                                object.responseId = message.responseId;
                            if (message.queryResult != null && message.hasOwnProperty("queryResult"))
                                object.queryResult = $root.google.cloud.dialogflow.v2.QueryResult.toObject(message.queryResult, options);
                            if (message.webhookStatus != null && message.hasOwnProperty("webhookStatus"))
                                object.webhookStatus = $root.google.rpc.Status.toObject(message.webhookStatus, options);
                            if (message.outputAudio != null && message.hasOwnProperty("outputAudio"))
                                object.outputAudio = options.bytes === String ? $util.base64.encode(message.outputAudio, 0, message.outputAudio.length) : options.bytes === Array ? Array.prototype.slice.call(message.outputAudio) : message.outputAudio;
                            if (message.outputAudioConfig != null && message.hasOwnProperty("outputAudioConfig"))
                                object.outputAudioConfig = $root.google.cloud.dialogflow.v2.OutputAudioConfig.toObject(message.outputAudioConfig, options);
                            return object;
                        };
    
                        /**
                         * Converts this DetectIntentResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.dialogflow.v2.DetectIntentResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DetectIntentResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        return DetectIntentResponse;
                    })();
    
                    v2.QueryParameters = (function() {
    
                        /**
                         * Properties of a QueryParameters.
                         * @memberof google.cloud.dialogflow.v2
                         * @interface IQueryParameters
                         * @property {string|null} [timeZone] QueryParameters timeZone
                         * @property {google.type.ILatLng|null} [geoLocation] QueryParameters geoLocation
                         * @property {Array.<google.cloud.dialogflow.v2.IContext>|null} [contexts] QueryParameters contexts
                         * @property {boolean|null} [resetContexts] QueryParameters resetContexts
                         * @property {Array.<google.cloud.dialogflow.v2.ISessionEntityType>|null} [sessionEntityTypes] QueryParameters sessionEntityTypes
                         * @property {google.protobuf.IStruct|null} [payload] QueryParameters payload
                         * @property {google.cloud.dialogflow.v2.ISentimentAnalysisRequestConfig|null} [sentimentAnalysisRequestConfig] QueryParameters sentimentAnalysisRequestConfig
                         * @property {Object.<string,string>|null} [webhookHeaders] QueryParameters webhookHeaders
                         */
    
                        /**
                         * Constructs a new QueryParameters.
                         * @memberof google.cloud.dialogflow.v2
                         * @classdesc Represents a QueryParameters.
                         * @implements IQueryParameters
                         * @constructor
                         * @param {google.cloud.dialogflow.v2.IQueryParameters=} [properties] Properties to set
                         */
                        function QueryParameters(properties) {
                            this.contexts = [];
                            this.sessionEntityTypes = [];
                            this.webhookHeaders = {};
  