// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(conversationProfile, participantRole, suggestionFeatureConfig) {
  // [START dialogflow_v2_generated_ConversationProfiles_SetSuggestionFeatureConfig_async]
  /**
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Required. The Conversation Profile to add or update the suggestion feature
   *  config. Format: `projects/<Project ID>/locations/<Location
   *  ID>/conversationProfiles/<Conversation Profile ID>`.
   */
  // const conversationProfile = 'abc123'
  /**
   *  Required. The participant role to add or update the suggestion feature
   *  config. Only HUMAN_AGENT or END_USER can be used.
   */
  // const participantRole = {}
  /**
   *  Required. The suggestion feature config to add or update.
   */
  // const suggestionFeatureConfig = {}

  // Imports the Dialogflow library
  const {ConversationProfilesClient} = require('@google-cloud/dialogflow').v2;

  // Instantiates a client
  const dialogflowClient = new ConversationProfilesClient();

  async function callSetSuggestionFeatureConfig() {
    // Construct request
    const request = {
      conversationProfile,
      participantRole,
      suggestionFeatureConfig,
    };

    // Run request
    const [operation] = await dialogflowClient.setSuggestionFeatureConfig(request);
    const [response] = await operation.promise();
    console.log(response);
  }

  callSetSuggestionFeatureConfig();
  // [END dialogflow_v2_generated_ConversationProfiles_SetSuggestionFeatureConfig_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
