// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **



'use strict';

function main(parent, environment, environmentId) {
  // [START dialogflow_v2_generated_Environments_CreateEnvironment_async]
  /**
   * TODO(developer): Uncomment these variables before running the sample.
   */
  /**
   *  Required. The agent to create an environment for.
   *  Supported formats:
   *  - `projects/<Project ID>/agent`
   *  - `projects/<Project ID>/locations/<Location ID>/agent`
   */
  // const parent = 'abc123'
  /**
   *  Required. The environment to create.
   */
  // const environment = {}
  /**
   *  Required. The unique id of the new environment.
   */
  // const environmentId = 'abc123'

  // Imports the Dialogflow library
  const {EnvironmentsClient} = require('@google-cloud/dialogflow').v2;

  // Instantiates a client
  const dialogflowClient = new EnvironmentsClient();

  async function callCreateEnvironment() {
    // Construct request
    const request = {
      parent,
      environment,
      environmentId,
    };

    // Run request
    const response = await dialogflowClient.createEnvironment(request);
    console.log(response);
  }

  callCreateEnvironment();
  // [END dialogflow_v2_generated_Environments_CreateEnvironment_async]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
