// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

/* global window */
import * as gax from 'google-gax';
import {
  Callback,
  CallOptions,
  Descriptors,
  ClientOptions,
  GrpcClientOptions,
  PaginationCallback,
  GaxCall,
  LocationsClient,
  LocationProtos,
} from 'google-gax';

import {Transform} from 'stream';
import {RequestType} from 'google-gax/build/src/apitypes';
import * as protos from '../../protos/protos';
import jsonProtos = require('../../protos/protos.json');
/**
 * Client JSON configuration object, loaded from
 * `src/v2/versions_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
import * as gapicConfig from './versions_client_config.json';
import {operationsProtos} from 'google-gax';
const version = require('../../../package.json').version;

/**
 *  Service for managing {@link google.cloud.dialogflow.v2.Version|Versions}.
 * @class
 * @memberof v2
 */
export class VersionsClient {
  private _terminated = false;
  private _opts: ClientOptions;
  private _providedCustomServicePath: boolean;
  private _gaxModule: typeof gax | typeof gax.fallback;
  private _gaxGrpc: gax.GrpcClient | gax.fallback.GrpcClient;
  private _protos: {};
  private _defaults: {[method: string]: gax.CallSettings};
  auth: gax.GoogleAuth;
  descriptors: Descriptors = {
    page: {},
    stream: {},
    longrunning: {},
    batching: {},
  };
  warn: (code: string, message: string, warnType?: string) => void;
  innerApiCalls: {[name: string]: Function};
  locationsClient: LocationsClient;
  pathTemplates: {[name: string]: gax.PathTemplate};
  operationsClient: gax.OperationsClient;
  versionsStub?: Promise<{[name: string]: Function}>;

  /**
   * Construct an instance of VersionsClient.
   *
   * @param {object} [options] - The configuration object.
   * The options accepted by the constructor are described in detail
   * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
   * The common options are:
   * @param {object} [options.credentials] - Credentials object.
   * @param {string} [options.credentials.client_email]
   * @param {string} [options.credentials.private_key]
   * @param {string} [options.email] - Account email address. Required when
   *     using a .pem or .p12 keyFilename.
   * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
   *     .p12 key downloaded from the Google Developers Console. If you provide
   *     a path to a JSON file, the projectId option below is not necessary.
   *     NOTE: .pem and .p12 require you to specify options.email as well.
   * @param {number} [options.port] - The port on which to connect to
   *     the remote host.
   * @param {string} [options.projectId] - The project ID from the Google
   *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
   *     the environment variable GCLOUD_PROJECT for your project ID. If your
   *     app is running in an environment which supports
   *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
   *     your project ID will be detected automatically.
   * @param {string} [options.apiEndpoint] - The domain name of the
   *     API remote host.
   * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
   *     Follows the structure of {@link gapicConfig}.
   * @param {boolean | "rest"} [options.fallback] - Use HTTP fallback mode.
   *     Pass "rest" to use HTTP/1.1 REST API instead of gRPC.
   *     For more information, please check the
   *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
   */
  constructor(opts?: ClientOptions) {
    // Ensure that options include all the required fields.
    const staticMembers = this.constructor as typeof VersionsClient;
    const servicePath =
      opts?.servicePath || opts?.apiEndpoint || staticMembers.servicePath;
    this._providedCustomServicePath = !!(
      opts?.servicePath || opts?.apiEndpoint
    );
    const port = opts?.port || staticMembers.port;
    const clientConfig = opts?.clientConfig ?? {};
    const fallback =
      opts?.fallback ??
      (typeof window !== 'undefined' && typeof window?.fetch === 'function');
    opts = Object.assign({servicePath, port, clientConfig, fallback}, opts);

    // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
    if (servicePath !== staticMembers.servicePath && !('scopes' in opts)) {
      opts['scopes'] = staticMembers.scopes;
    }

    // Choose either gRPC or proto-over-HTTP implementation of google-gax.
    this._gaxModule = opts.fallback ? gax.fallback : gax;

    // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
    this._gaxGrpc = new this._gaxModule.GrpcClient(opts);

    // Save options to use in initialize() method.
    this._opts = opts;

    // Save the auth object to the client, for use by other methods.
    this.auth = this._gaxGrpc.auth as gax.GoogleAuth;

    // Set useJWTAccessWithScope on the auth object.
    this.auth.useJWTAccessWithScope = true;

    // Set defaultServicePath on the auth object.
    this.auth.defaultServicePath = staticMembers.servicePath;

    // Set the default scopes in auth client if needed.
    if (servicePath === staticMembers.servicePath) {
      this.auth.defaultScopes = staticMembers.scopes;
    }
    this.locationsClient = new LocationsClient(this._gaxGrpc, opts);

    // Determine the client header string.
    const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
    if (typeof process !== 'undefined' && 'versions' in process) {
      clientHeader.push(`gl-node/${process.versions.node}`);
    } else {
      clientHeader.push(`gl-web/${this._gaxModule.version}`);
    }
    if (!opts.fallback) {
      clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
    } else if (opts.fallback === 'rest') {
      clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
    }
    if (opts.libName && opts.libVersion) {
      clientHeader.push(`${opts.libName}/${opts.libVersion}`);
    }
    // Load the applicable protos.
    this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);

    // This API contains "path templates"; forward-slash-separated
    // identifiers to uniquely identify resources within the API.
    // Create useful helper objects for these.
    this.pathTemplates = {
      conversationDatasetPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/conversationDatasets/{conversation_dataset}'
      ),
      projectPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}'
      ),
      projectAgentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/agent'
      ),
      projectAgentEntityTypePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/agent/entityTypes/{entity_type}'
      ),
      projectAgentEnvironmentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/agent/environments/{environment}'
      ),
      projectAgentEnvironmentUserSessionContextPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}'
        ),
      projectAgentEnvironmentUserSessionEntityTypePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}'
        ),
      projectAgentFulfillmentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/agent/fulfillment'
      ),
      projectAgentIntentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/agent/intents/{intent}'
      ),
      projectAgentSessionContextPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/agent/sessions/{session}/contexts/{context}'
      ),
      projectAgentSessionEntityTypePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/agent/sessions/{session}/entityTypes/{entity_type}'
        ),
      projectAgentVersionPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/agent/versions/{version}'
      ),
      projectAnswerRecordPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/answerRecords/{answer_record}'
      ),
      projectConversationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/conversations/{conversation}'
      ),
      projectConversationMessagePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/conversations/{conversation}/messages/{message}'
      ),
      projectConversationModelPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/conversationModels/{conversation_model}'
      ),
      projectConversationModelEvaluationPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/conversationModels/{conversation_model}/evaluations/{evaluation}'
        ),
      projectConversationParticipantPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/conversations/{conversation}/participants/{participant}'
        ),
      projectConversationProfilePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/conversationProfiles/{conversation_profile}'
      ),
      projectKnowledgeBasePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/knowledgeBases/{knowledge_base}'
      ),
      projectKnowledgeBaseDocumentPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}'
        ),
      projectLocationAgentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/agent'
      ),
      projectLocationAgentEntityTypePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/agent/entityTypes/{entity_type}'
        ),
      projectLocationAgentEnvironmentPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/agent/environments/{environment}'
        ),
      projectLocationAgentEnvironmentUserSessionContextPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}'
        ),
      projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}'
        ),
      projectLocationAgentFulfillmentPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/agent/fulfillment'
        ),
      projectLocationAgentIntentPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/agent/intents/{intent}'
      ),
      projectLocationAgentSessionContextPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}'
        ),
      projectLocationAgentSessionEntityTypePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/agent/sessions/{session}/entityTypes/{entity_type}'
        ),
      projectLocationAgentVersionPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/agent/versions/{version}'
      ),
      projectLocationAnswerRecordPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/answerRecords/{answer_record}'
      ),
      projectLocationConversationPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/locations/{location}/conversations/{conversation}'
      ),
      projectLocationConversationMessagePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/conversations/{conversation}/messages/{message}'
        ),
      projectLocationConversationModelPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/conversationModels/{conversation_model}'
        ),
      projectLocationConversationModelEvaluationPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/conversationModels/{conversation_model}/evaluations/{evaluation}'
        ),
      projectLocationConversationParticipantPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}'
        ),
      projectLocationConversationProfilePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}'
        ),
      projectLocationKnowledgeBasePathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/knowledgeBases/{knowledge_base}'
        ),
      projectLocationKnowledgeBaseDocumentPathTemplate:
        new this._gaxModule.PathTemplate(
          'projects/{project}/locations/{location}/knowledgeBases/{knowledge_base}/documents/{document}'
        ),
    };

    // Some of the methods on this service return "paged" results,
    // (e.g. 50 results at a time, with tokens to get subsequent
    // pages). Denote the keys used for pagination and results.
    this.descriptors.page = {
      listVersions: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'versions'
      ),
    };

    const protoFilesRoot = this._gaxModule.protobuf.Root.fromJSON(jsonProtos);
    // This API contains "long-running operations", which return a
    // an Operation object that allows for tracking of the operation,
    // rather than holding a request open.
    const lroOptions: GrpcClientOptions = {
      auth: this.auth,
      grpc: 'grpc' in this._gaxGrpc ? this._gaxGrpc.grpc : undefined,
    };
    if (opts.fallback === 'rest') {
      lroOptions.protoJson = protoFilesRoot;
      lroOptions.httpRules = [
        {
          selector: 'google.cloud.location.Locations.GetLocation',
          get: '/v2/{name=projects/*/locations/*}',
        },
        {
          selector: 'google.cloud.location.Locations.ListLocations',
          get: '/v2/{name=projects/*}/locations',
        },
        {
          selector: 'google.longrunning.Operations.CancelOperation',
          post: '/v2/{name=projects/*/operations/*}:cancel',
          additional_bindings: [
            {post: '/v2/{name=projects/*/locations/*/operations/*}:cancel'},
          ],
        },
        {
          selector: 'google.longrunning.Operations.GetOperation',
          get: '/v2/{name=projects/*/operations/*}',
          additional_bindings: [
            {get: '/v2/{name=projects/*/locations/*/operations/*}'},
          ],
        },
        {
          selector: 'google.longrunning.Operations.ListOperations',
          get: '/v2/{name=projects/*}/operations',
          additional_bindings: [
            {get: '/v2/{name=projects/*/locations/*}/operations'},
          ],
        },
      ];
    }
    this.operationsClient = this._gaxModule
      .lro(lroOptions)
      .operationsClient(opts);

    this.descriptors.longrunning = {};

    // Put together the default options sent with requests.
    this._defaults = this._gaxGrpc.constructSettings(
      'google.cloud.dialogflow.v2.Versions',
      gapicConfig as gax.ClientConfig,
      opts.clientConfig || {},
      {'x-goog-api-client': clientHeader.join(' ')}
    );

    // Set up a dictionary of "inner API calls"; the core implementation
    // of calling the API is handled in `google-gax`, with this code
    // merely providing the destination and request information.
    this.innerApiCalls = {};

    // Add a warn function to the client constructor so it can be easily tested.
    this.warn = gax.warn;
  }

  /**
   * Initialize the client.
   * Performs asynchronous operations (such as authentication) and prepares the client.
   * This function will be called automatically when any class method is called for the
   * first time, but if you need to initialize it before calling an actual method,
   * feel free to call initialize() directly.
   *
   * You can await on this method if you want to make sure the client is initialized.
   *
   * @returns {Promise} A promise that resolves to an authenticated service stub.
   */
  initialize() {
    // If the client stub promise is already initialized, return immediately.
    if (this.versionsStub) {
      return this.versionsStub;
    }

    // Put together the "service stub" for
    // google.cloud.dialogflow.v2.Versions.
    this.versionsStub = this._gaxGrpc.createStub(
      this._opts.fallback
        ? (this._protos as protobuf.Root).lookupService(
            'google.cloud.dialogflow.v2.Versions'
          )
        : // eslint-disable-next-line @typescript-eslint/no-explicit-any
          (this._protos as any).google.cloud.dialogflow.v2.Versions,
      this._opts,
      this._providedCustomServicePath
    ) as Promise<{[method: string]: Function}>;

    // Iterate over each of the methods that the service provides
    // and create an API call method for each.
    const versionsStubMethods = [
      'listVersions',
      'getVersion',
      'createVersion',
      'updateVersion',
      'deleteVersion',
    ];
    for (const methodName of versionsStubMethods) {
      const callPromise = this.versionsStub.then(
        stub =>
          (...args: Array<{}>) => {
            if (this._terminated) {
              return Promise.reject('The client has already been closed.');
            }
            const func = stub[methodName];
            return func.apply(stub, args);
          },
        (err: Error | null | undefined) => () => {
          throw err;
        }
      );

      const descriptor = this.descriptors.page[methodName] || undefined;
      const apiCall = this._gaxModule.createApiCall(
        callPromise,
        this._defaults[methodName],
        descriptor
      );

      this.innerApiCalls[methodName] = apiCall;
    }

    return this.versionsStub;
  }

  /**
   * The DNS address for this API service.
   * @returns {string} The DNS address for this service.
   */
  static get servicePath() {
    return 'dialogflow.googleapis.com';
  }

  /**
   * The DNS address for this API service - same as servicePath(),
   * exists for compatibility reasons.
   * @returns {string} The DNS address for this service.
   */
  static get apiEndpoint() {
    return 'dialogflow.googleapis.com';
  }

  /**
   * The port for this API service.
   * @returns {number} The default port for this service.
   */
  static get port() {
    return 443;
  }

  /**
   * The scopes needed to make gRPC calls for every method defined
   * in this service.
   * @returns {string[]} List of default scopes.
   */
  static get scopes() {
    return [
      'https://www.googleapis.com/auth/cloud-platform',
      'https://www.googleapis.com/auth/dialogflow',
    ];
  }

  getProjectId(): Promise<string>;
  getProjectId(callback: Callback<string, undefined, undefined>): void;
  /**
   * Return the project ID used by this class.
   * @returns {Promise} A promise that resolves to string containing the project ID.
   */
  getProjectId(
    callback?: Callback<string, undefined, undefined>
  ): Promise<string> | void {
    if (callback) {
      this.auth.getProjectId(callback);
      return;
    }
    return this.auth.getProjectId();
  }

  // -------------------
  // -- Service calls --
  // -------------------
  /**
   * Retrieves the specified agent version.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the version.
   *   Supported formats:
   *
   *   - `projects/<Project ID>/agent/versions/<Version ID>`
   *   - `projects/<Project ID>/locations/<Location ID>/agent/versions/<Version
   *     ID>`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [Version]{@link google.cloud.dialogflow.v2.Version}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v2/versions.get_version.js</caption>
   * region_tag:dialogflow_v2_generated_Versions_GetVersion_async
   */
  getVersion(
    request?: protos.google.cloud.dialogflow.v2.IGetVersionRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.IGetVersionRequest | undefined,
      {} | undefined
    ]
  >;
  getVersion(
    request: protos.google.cloud.dialogflow.v2.IGetVersionRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.IGetVersionRequest | null | undefined,
      {} | null | undefined
    >
  ): void;
  getVersion(
    request: protos.google.cloud.dialogflow.v2.IGetVersionRequest,
    callback: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.IGetVersionRequest | null | undefined,
      {} | null | undefined
    >
  ): void;
  getVersion(
    request?: protos.google.cloud.dialogflow.v2.IGetVersionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.cloud.dialogflow.v2.IVersion,
          | protos.google.cloud.dialogflow.v2.IGetVersionRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.IGetVersionRequest | null | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.IGetVersionRequest | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.getVersion(request, options, callback);
  }
  /**
   * Creates an agent version.
   *
   * The new version points to the agent instance in the "default" environment.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The agent to create a version for.
   *   Supported formats:
   *
   *   - `projects/<Project ID>/agent`
   *   - `projects/<Project ID>/locations/<Location ID>/agent`
   * @param {google.cloud.dialogflow.v2.Version} request.version
   *   Required. The version to create.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [Version]{@link google.cloud.dialogflow.v2.Version}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v2/versions.create_version.js</caption>
   * region_tag:dialogflow_v2_generated_Versions_CreateVersion_async
   */
  createVersion(
    request?: protos.google.cloud.dialogflow.v2.ICreateVersionRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.ICreateVersionRequest | undefined,
      {} | undefined
    ]
  >;
  createVersion(
    request: protos.google.cloud.dialogflow.v2.ICreateVersionRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      | protos.google.cloud.dialogflow.v2.ICreateVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  createVersion(
    request: protos.google.cloud.dialogflow.v2.ICreateVersionRequest,
    callback: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      | protos.google.cloud.dialogflow.v2.ICreateVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  createVersion(
    request?: protos.google.cloud.dialogflow.v2.ICreateVersionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.cloud.dialogflow.v2.IVersion,
          | protos.google.cloud.dialogflow.v2.ICreateVersionRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      | protos.google.cloud.dialogflow.v2.ICreateVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.ICreateVersionRequest | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.createVersion(request, options, callback);
  }
  /**
   * Updates the specified agent version.
   *
   * Note that this method does not allow you to update the state of the agent
   * the given version points to. It allows you to update only mutable
   * properties of the version resource.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.cloud.dialogflow.v2.Version} request.version
   *   Required. The version to update.
   *   Supported formats:
   *
   *   - `projects/<Project ID>/agent/versions/<Version ID>`
   *   - `projects/<Project ID>/locations/<Location ID>/agent/versions/<Version
   *     ID>`
   * @param {google.protobuf.FieldMask} request.updateMask
   *   Required. The mask to control which fields get updated.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [Version]{@link google.cloud.dialogflow.v2.Version}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v2/versions.update_version.js</caption>
   * region_tag:dialogflow_v2_generated_Versions_UpdateVersion_async
   */
  updateVersion(
    request?: protos.google.cloud.dialogflow.v2.IUpdateVersionRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.IUpdateVersionRequest | undefined,
      {} | undefined
    ]
  >;
  updateVersion(
    request: protos.google.cloud.dialogflow.v2.IUpdateVersionRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      | protos.google.cloud.dialogflow.v2.IUpdateVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  updateVersion(
    request: protos.google.cloud.dialogflow.v2.IUpdateVersionRequest,
    callback: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      | protos.google.cloud.dialogflow.v2.IUpdateVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  updateVersion(
    request?: protos.google.cloud.dialogflow.v2.IUpdateVersionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.cloud.dialogflow.v2.IVersion,
          | protos.google.cloud.dialogflow.v2.IUpdateVersionRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.cloud.dialogflow.v2.IVersion,
      | protos.google.cloud.dialogflow.v2.IUpdateVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion,
      protos.google.cloud.dialogflow.v2.IUpdateVersionRequest | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        'version.name': request.version!.name || '',
      });
    this.initialize();
    return this.innerApiCalls.updateVersion(request, options, callback);
  }
  /**
   * Delete the specified agent version.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the version to delete.
   *   Supported formats:
   *
   *   - `projects/<Project ID>/agent/versions/<Version ID>`
   *   - `projects/<Project ID>/locations/<Location ID>/agent/versions/<Version
   *     ID>`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v2/versions.delete_version.js</caption>
   * region_tag:dialogflow_v2_generated_Versions_DeleteVersion_async
   */
  deleteVersion(
    request?: protos.google.cloud.dialogflow.v2.IDeleteVersionRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      protos.google.cloud.dialogflow.v2.IDeleteVersionRequest | undefined,
      {} | undefined
    ]
  >;
  deleteVersion(
    request: protos.google.cloud.dialogflow.v2.IDeleteVersionRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.cloud.dialogflow.v2.IDeleteVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  deleteVersion(
    request: protos.google.cloud.dialogflow.v2.IDeleteVersionRequest,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.cloud.dialogflow.v2.IDeleteVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): void;
  deleteVersion(
    request?: protos.google.cloud.dialogflow.v2.IDeleteVersionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.protobuf.IEmpty,
          | protos.google.cloud.dialogflow.v2.IDeleteVersionRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.cloud.dialogflow.v2.IDeleteVersionRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      protos.google.cloud.dialogflow.v2.IDeleteVersionRequest | undefined,
      {} | undefined
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        name: request.name || '',
      });
    this.initialize();
    return this.innerApiCalls.deleteVersion(request, options, callback);
  }

  /**
   * Returns the list of all versions of the specified agent.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The agent to list all versions from.
   *   Supported formats:
   *
   *   - `projects/<Project ID>/agent`
   *   - `projects/<Project ID>/locations/<Location ID>/agent`
   * @param {number} [request.pageSize]
   *   Optional. The maximum number of items to return in a single page. By default 100 and
   *   at most 1000.
   * @param {string} [request.pageToken]
   *   Optional. The next_page_token value returned from a previous list request.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of [Version]{@link google.cloud.dialogflow.v2.Version}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listVersionsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listVersions(
    request?: protos.google.cloud.dialogflow.v2.IListVersionsRequest,
    options?: CallOptions
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion[],
      protos.google.cloud.dialogflow.v2.IListVersionsRequest | null,
      protos.google.cloud.dialogflow.v2.IListVersionsResponse
    ]
  >;
  listVersions(
    request: protos.google.cloud.dialogflow.v2.IListVersionsRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.cloud.dialogflow.v2.IListVersionsRequest,
      | protos.google.cloud.dialogflow.v2.IListVersionsResponse
      | null
      | undefined,
      protos.google.cloud.dialogflow.v2.IVersion
    >
  ): void;
  listVersions(
    request: protos.google.cloud.dialogflow.v2.IListVersionsRequest,
    callback: PaginationCallback<
      protos.google.cloud.dialogflow.v2.IListVersionsRequest,
      | protos.google.cloud.dialogflow.v2.IListVersionsResponse
      | null
      | undefined,
      protos.google.cloud.dialogflow.v2.IVersion
    >
  ): void;
  listVersions(
    request?: protos.google.cloud.dialogflow.v2.IListVersionsRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.cloud.dialogflow.v2.IListVersionsRequest,
          | protos.google.cloud.dialogflow.v2.IListVersionsResponse
          | null
          | undefined,
          protos.google.cloud.dialogflow.v2.IVersion
        >,
    callback?: PaginationCallback<
      protos.google.cloud.dialogflow.v2.IListVersionsRequest,
      | protos.google.cloud.dialogflow.v2.IListVersionsResponse
      | null
      | undefined,
      protos.google.cloud.dialogflow.v2.IVersion
    >
  ): Promise<
    [
      protos.google.cloud.dialogflow.v2.IVersion[],
      protos.google.cloud.dialogflow.v2.IListVersionsRequest | null,
      protos.google.cloud.dialogflow.v2.IListVersionsResponse
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    this.initialize();
    return this.innerApiCalls.listVersions(request, options, callback);
  }

  /**
   * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The agent to list all versions from.
   *   Supported formats:
   *
   *   - `projects/<Project ID>/agent`
   *   - `projects/<Project ID>/locations/<Location ID>/agent`
   * @param {number} [request.pageSize]
   *   Optional. The maximum number of items to return in a single page. By default 100 and
   *   at most 1000.
   * @param {string} [request.pageToken]
   *   Optional. The next_page_token value returned from a previous list request.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing [Version]{@link google.cloud.dialogflow.v2.Version} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listVersionsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   */
  listVersionsStream(
    request?: protos.google.cloud.dialogflow.v2.IListVersionsRequest,
    options?: CallOptions
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listVersions'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listVersions.createStream(
      this.innerApiCalls.listVersions as gax.GaxCall,
      request,
      callSettings
    );
  }

  /**
   * Equivalent to `listVersions`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The agent to list all versions from.
   *   Supported formats:
   *
   *   - `projects/<Project ID>/agent`
   *   - `projects/<Project ID>/locations/<Location ID>/agent`
   * @param {number} [request.pageSize]
   *   Optional. The maximum number of items to return in a single page. By default 100 and
   *   at most 1000.
   * @param {string} [request.pageToken]
   *   Optional. The next_page_token value returned from a previous list request.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
   *   When you iterate the returned iterable, each element will be an object representing
   *   [Version]{@link google.cloud.dialogflow.v2.Version}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   * @example <caption>include:samples/generated/v2/versions.list_versions.js</caption>
   * region_tag:dialogflow_v2_generated_Versions_ListVersions_async
   */
  listVersionsAsync(
    request?: protos.google.cloud.dialogflow.v2.IListVersionsRequest,
    options?: CallOptions
  ): AsyncIterable<protos.google.cloud.dialogflow.v2.IVersion> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      gax.routingHeader.fromParams({
        parent: request.parent || '',
      });
    const defaultCallSettings = this._defaults['listVersions'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize();
    return this.descriptors.page.listVersions.asyncIterate(
      this.innerApiCalls['listVersions'] as GaxCall,
      request as unknown as RequestType,
      callSettings
    ) as AsyncIterable<protos.google.cloud.dialogflow.v2.IVersion>;
  }
  /**
   * Gets information about a location.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Resource name for the location.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing [Location]{@link google.cloud.location.Location}.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
   *   for more details and examples.
   * @example
   * ```
   * const [response] = await client.getLocation(request);
   * ```
   */
  getLocation(
    request: LocationProtos.google.cloud.location.IGetLocationRequest,
    options?:
      | gax.CallOptions
      | Callback<
          LocationProtos.google.cloud.location.ILocation,
          | LocationProtos.google.cloud.location.IGetLocationRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LocationProtos.google.cloud.location.ILocation,
      | LocationProtos.google.cloud.location.IGetLocationRequest
      | null
      | undefined,
      {} | null | undefined
    >
  ): Promise<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.getLocation(request, options, callback);
  }

  /**
   * Lists information about the supported locations for this service. Returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   The resource that owns the locations collection, if applicable.
   * @param {string} request.filter
   *   The standard list filter.
   * @param {number} request.pageSize
   *   The standard list page size.
   * @param {string} request.pageToken
   *   The standard list page token.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
   *   When you iterate the returned iterable, each element will be an object representing
   *   [Location]{@link google.cloud.location.Location}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the
   *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
   *   for more details and examples.
   * @example
   * ```
   * const iterable = client.listLocationsAsync(request);
   * for await (const response of iterable) {
   *   // process response
   * }
   * ```
   */
  listLocationsAsync(
    request: LocationProtos.google.cloud.location.IListLocationsRequest,
    options?: CallOptions
  ): AsyncIterable<LocationProtos.google.cloud.location.ILocation> {
    return this.locationsClient.listLocationsAsync(request, options);
  }

  /**
   * Gets the latest state of a long-running operation.  Clients can use this
   * method to poll the operation result at intervals as recommended by the API
   * service.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See [gax.CallOptions]{@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions} for the
   *   details.
   * @param {function(?Error, ?Object)=} callback
   *   The function which will be called with the result of the API call.
   *
   *   The second parameter to the callback is an object representing
   * [google.longrunning.Operation]{@link
   * external:"google.longrunning.Operation"}.
   * @return {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   * [google.longrunning.Operation]{@link
   * external:"google.longrunning.Operation"}. The promise has a method named
   * "cancel" which cancels the ongoing API call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * const name = '';
   * const [response] = await client.getOperation({name});
   * // doThingsWith(response)
   * ```
   */
  getOperation(
    request: protos.google.longrunning.GetOperationRequest,
    options?:
      | gax.CallOptions
      | Callback<
          protos.google.longrunning.Operation,
          protos.google.longrunning.GetOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.longrunning.Operation,
      protos.google.longrunning.GetOperationRequest,
      {} | null | undefined
    >
  ): Promise<[protos.google.longrunning.Operation]> {
    return this.operationsClient.getOperation(request, options, callback);
  }
  /**
   * Lists operations that match the specified filter in the request. If the
   * server doesn't support this method, it returns `UNIMPLEMENTED`. Returns an iterable object.
   *
   * For-await-of syntax is used with the iterable to recursively get response element on-demand.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation collection.
   * @param {string} request.filter - The standard list filter.
   * @param {number=} request.pageSize -
   *   The maximum number of resources contained in the underlying API
   *   response. If page streaming is performed per-resource, this
   *   parameter does not affect the return value. If page streaming is
   *   performed per-page, this determines the maximum number of
   *   resources in a page.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See [gax.CallOptions]{@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions} for the
   *   details.
   * @returns {Object}
   *   An iterable Object that conforms to @link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * for await (const response of client.listOperationsAsync(request));
   * // doThingsWith(response)
   * ```
   */
  listOperationsAsync(
    request: protos.google.longrunning.ListOperationsRequest,
    options?: gax.CallOptions
  ): AsyncIterable<protos.google.longrunning.ListOperationsResponse> {
    return this.operationsClient.listOperationsAsync(request, options);
  }
  /**
   * Starts asynchronous cancellation on a long-running operation.  The server
   * makes a best effort to cancel the operation, but success is not
   * guaranteed.  If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
   * {@link Operations.GetOperation} or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an {@link Operation.error} value with a {@link google.rpc.Status.code} of
   * 1, corresponding to `Code.CANCELLED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be cancelled.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See [gax.CallOptions]{@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions} for the
   * details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.cancelOperation({name: ''});
   * ```
   */
  cancelOperation(
    request: protos.google.longrunning.CancelOperationRequest,
    options?:
      | gax.CallOptions
      | Callback<
          protos.google.protobuf.Empty,
          protos.google.longrunning.CancelOperationRequest,
          {} | undefined | null
        >,
    callback?: Callback<
      protos.google.longrunning.CancelOperationRequest,
      protos.google.protobuf.Empty,
      {} | undefined | null
    >
  ): Promise<protos.google.protobuf.Empty> {
    return this.operationsClient.cancelOperation(request, options, callback);
  }

  /**
   * Deletes a long-running operation. This method indicates that the client is
   * no longer interested in the operation result. It does not cancel the
   * operation. If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be deleted.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See [gax.CallOptions]{@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions} for the
   * details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.deleteOperation({name: ''});
   * ```
   */
  deleteOperation(
    request: protos.google.longrunning.DeleteOperationRequest,
    options?:
      | gax.CallOptions
      | Callback<
          protos.google.protobuf.Empty,
          protos.google.longrunning.DeleteOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.Empty,
      protos.google.longrunning.DeleteOperationRequest,
      {} | null | undefined
    >
  ): Promise<protos.google.protobuf.Empty> {
    return this.operationsClient.deleteOperation(request, options, callback);
  }

  // --------------------
  // -- Path templates --
  // --------------------

  /**
   * Return a fully-qualified conversationDataset resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} conversation_dataset
   * @returns {string} Resource name string.
   */
  conversationDatasetPath(
    project: string,
    location: string,
    conversationDataset: string
  ) {
    return this.pathTemplates.conversationDatasetPathTemplate.render({
      project: project,
      location: location,
      conversation_dataset: conversationDataset,
    });
  }

  /**
   * Parse the project from ConversationDataset resource.
   *
   * @param {string} conversationDatasetName
   *   A fully-qualified path representing ConversationDataset resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromConversationDatasetName(conversationDatasetName: string) {
    return this.pathTemplates.conversationDatasetPathTemplate.match(
      conversationDatasetName
    ).project;
  }

  /**
   * Parse the location from ConversationDataset resource.
   *
   * @param {string} conversationDatasetName
   *   A fully-qualified path representing ConversationDataset resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromConversationDatasetName(conversationDatasetName: string) {
    return this.pathTemplates.conversationDatasetPathTemplate.match(
      conversationDatasetName
    ).location;
  }

  /**
   * Parse the conversation_dataset from ConversationDataset resource.
   *
   * @param {string} conversationDatasetName
   *   A fully-qualified path representing ConversationDataset resource.
   * @returns {string} A string representing the conversation_dataset.
   */
  matchConversationDatasetFromConversationDatasetName(
    conversationDatasetName: string
  ) {
    return this.pathTemplates.conversationDatasetPathTemplate.match(
      conversationDatasetName
    ).conversation_dataset;
  }

  /**
   * Return a fully-qualified project resource name string.
   *
   * @param {string} project
   * @returns {string} Resource name string.
   */
  projectPath(project: string) {
    return this.pathTemplates.projectPathTemplate.render({
      project: project,
    });
  }

  /**
   * Parse the project from Project resource.
   *
   * @param {string} projectName
   *   A fully-qualified path representing Project resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectName(projectName: string) {
    return this.pathTemplates.projectPathTemplate.match(projectName).project;
  }

  /**
   * Return a fully-qualified projectAgent resource name string.
   *
   * @param {string} project
   * @returns {string} Resource name string.
   */
  projectAgentPath(project: string) {
    return this.pathTemplates.projectAgentPathTemplate.render({
      project: project,
    });
  }

  /**
   * Parse the project from ProjectAgent resource.
   *
   * @param {string} projectAgentName
   *   A fully-qualified path representing project_agent resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentName(projectAgentName: string) {
    return this.pathTemplates.projectAgentPathTemplate.match(projectAgentName)
      .project;
  }

  /**
   * Return a fully-qualified projectAgentEntityType resource name string.
   *
   * @param {string} project
   * @param {string} entity_type
   * @returns {string} Resource name string.
   */
  projectAgentEntityTypePath(project: string, entityType: string) {
    return this.pathTemplates.projectAgentEntityTypePathTemplate.render({
      project: project,
      entity_type: entityType,
    });
  }

  /**
   * Parse the project from ProjectAgentEntityType resource.
   *
   * @param {string} projectAgentEntityTypeName
   *   A fully-qualified path representing project_agent_entity_type resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentEntityTypeName(
    projectAgentEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentEntityTypePathTemplate.match(
      projectAgentEntityTypeName
    ).project;
  }

  /**
   * Parse the entity_type from ProjectAgentEntityType resource.
   *
   * @param {string} projectAgentEntityTypeName
   *   A fully-qualified path representing project_agent_entity_type resource.
   * @returns {string} A string representing the entity_type.
   */
  matchEntityTypeFromProjectAgentEntityTypeName(
    projectAgentEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentEntityTypePathTemplate.match(
      projectAgentEntityTypeName
    ).entity_type;
  }

  /**
   * Return a fully-qualified projectAgentEnvironment resource name string.
   *
   * @param {string} project
   * @param {string} environment
   * @returns {string} Resource name string.
   */
  projectAgentEnvironmentPath(project: string, environment: string) {
    return this.pathTemplates.projectAgentEnvironmentPathTemplate.render({
      project: project,
      environment: environment,
    });
  }

  /**
   * Parse the project from ProjectAgentEnvironment resource.
   *
   * @param {string} projectAgentEnvironmentName
   *   A fully-qualified path representing project_agent_environment resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentEnvironmentName(
    projectAgentEnvironmentName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentPathTemplate.match(
      projectAgentEnvironmentName
    ).project;
  }

  /**
   * Parse the environment from ProjectAgentEnvironment resource.
   *
   * @param {string} projectAgentEnvironmentName
   *   A fully-qualified path representing project_agent_environment resource.
   * @returns {string} A string representing the environment.
   */
  matchEnvironmentFromProjectAgentEnvironmentName(
    projectAgentEnvironmentName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentPathTemplate.match(
      projectAgentEnvironmentName
    ).environment;
  }

  /**
   * Return a fully-qualified projectAgentEnvironmentUserSessionContext resource name string.
   *
   * @param {string} project
   * @param {string} environment
   * @param {string} user
   * @param {string} session
   * @param {string} context
   * @returns {string} Resource name string.
   */
  projectAgentEnvironmentUserSessionContextPath(
    project: string,
    environment: string,
    user: string,
    session: string,
    context: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionContextPathTemplate.render(
      {
        project: project,
        environment: environment,
        user: user,
        session: session,
        context: context,
      }
    );
  }

  /**
   * Parse the project from ProjectAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_agent_environment_user_session_context resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentEnvironmentUserSessionContextName(
    projectAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionContextPathTemplate.match(
      projectAgentEnvironmentUserSessionContextName
    ).project;
  }

  /**
   * Parse the environment from ProjectAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_agent_environment_user_session_context resource.
   * @returns {string} A string representing the environment.
   */
  matchEnvironmentFromProjectAgentEnvironmentUserSessionContextName(
    projectAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionContextPathTemplate.match(
      projectAgentEnvironmentUserSessionContextName
    ).environment;
  }

  /**
   * Parse the user from ProjectAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_agent_environment_user_session_context resource.
   * @returns {string} A string representing the user.
   */
  matchUserFromProjectAgentEnvironmentUserSessionContextName(
    projectAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionContextPathTemplate.match(
      projectAgentEnvironmentUserSessionContextName
    ).user;
  }

  /**
   * Parse the session from ProjectAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_agent_environment_user_session_context resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectAgentEnvironmentUserSessionContextName(
    projectAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionContextPathTemplate.match(
      projectAgentEnvironmentUserSessionContextName
    ).session;
  }

  /**
   * Parse the context from ProjectAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_agent_environment_user_session_context resource.
   * @returns {string} A string representing the context.
   */
  matchContextFromProjectAgentEnvironmentUserSessionContextName(
    projectAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionContextPathTemplate.match(
      projectAgentEnvironmentUserSessionContextName
    ).context;
  }

  /**
   * Return a fully-qualified projectAgentEnvironmentUserSessionEntityType resource name string.
   *
   * @param {string} project
   * @param {string} environment
   * @param {string} user
   * @param {string} session
   * @param {string} entity_type
   * @returns {string} Resource name string.
   */
  projectAgentEnvironmentUserSessionEntityTypePath(
    project: string,
    environment: string,
    user: string,
    session: string,
    entityType: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionEntityTypePathTemplate.render(
      {
        project: project,
        environment: environment,
        user: user,
        session: session,
        entity_type: entityType,
      }
    );
  }

  /**
   * Parse the project from ProjectAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentEnvironmentUserSessionEntityTypeName(
    projectAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectAgentEnvironmentUserSessionEntityTypeName
    ).project;
  }

  /**
   * Parse the environment from ProjectAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the environment.
   */
  matchEnvironmentFromProjectAgentEnvironmentUserSessionEntityTypeName(
    projectAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectAgentEnvironmentUserSessionEntityTypeName
    ).environment;
  }

  /**
   * Parse the user from ProjectAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the user.
   */
  matchUserFromProjectAgentEnvironmentUserSessionEntityTypeName(
    projectAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectAgentEnvironmentUserSessionEntityTypeName
    ).user;
  }

  /**
   * Parse the session from ProjectAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectAgentEnvironmentUserSessionEntityTypeName(
    projectAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectAgentEnvironmentUserSessionEntityTypeName
    ).session;
  }

  /**
   * Parse the entity_type from ProjectAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the entity_type.
   */
  matchEntityTypeFromProjectAgentEnvironmentUserSessionEntityTypeName(
    projectAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectAgentEnvironmentUserSessionEntityTypeName
    ).entity_type;
  }

  /**
   * Return a fully-qualified projectAgentFulfillment resource name string.
   *
   * @param {string} project
   * @returns {string} Resource name string.
   */
  projectAgentFulfillmentPath(project: string) {
    return this.pathTemplates.projectAgentFulfillmentPathTemplate.render({
      project: project,
    });
  }

  /**
   * Parse the project from ProjectAgentFulfillment resource.
   *
   * @param {string} projectAgentFulfillmentName
   *   A fully-qualified path representing project_agent_fulfillment resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentFulfillmentName(
    projectAgentFulfillmentName: string
  ) {
    return this.pathTemplates.projectAgentFulfillmentPathTemplate.match(
      projectAgentFulfillmentName
    ).project;
  }

  /**
   * Return a fully-qualified projectAgentIntent resource name string.
   *
   * @param {string} project
   * @param {string} intent
   * @returns {string} Resource name string.
   */
  projectAgentIntentPath(project: string, intent: string) {
    return this.pathTemplates.projectAgentIntentPathTemplate.render({
      project: project,
      intent: intent,
    });
  }

  /**
   * Parse the project from ProjectAgentIntent resource.
   *
   * @param {string} projectAgentIntentName
   *   A fully-qualified path representing project_agent_intent resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentIntentName(projectAgentIntentName: string) {
    return this.pathTemplates.projectAgentIntentPathTemplate.match(
      projectAgentIntentName
    ).project;
  }

  /**
   * Parse the intent from ProjectAgentIntent resource.
   *
   * @param {string} projectAgentIntentName
   *   A fully-qualified path representing project_agent_intent resource.
   * @returns {string} A string representing the intent.
   */
  matchIntentFromProjectAgentIntentName(projectAgentIntentName: string) {
    return this.pathTemplates.projectAgentIntentPathTemplate.match(
      projectAgentIntentName
    ).intent;
  }

  /**
   * Return a fully-qualified projectAgentSessionContext resource name string.
   *
   * @param {string} project
   * @param {string} session
   * @param {string} context
   * @returns {string} Resource name string.
   */
  projectAgentSessionContextPath(
    project: string,
    session: string,
    context: string
  ) {
    return this.pathTemplates.projectAgentSessionContextPathTemplate.render({
      project: project,
      session: session,
      context: context,
    });
  }

  /**
   * Parse the project from ProjectAgentSessionContext resource.
   *
   * @param {string} projectAgentSessionContextName
   *   A fully-qualified path representing project_agent_session_context resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentSessionContextName(
    projectAgentSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentSessionContextPathTemplate.match(
      projectAgentSessionContextName
    ).project;
  }

  /**
   * Parse the session from ProjectAgentSessionContext resource.
   *
   * @param {string} projectAgentSessionContextName
   *   A fully-qualified path representing project_agent_session_context resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectAgentSessionContextName(
    projectAgentSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentSessionContextPathTemplate.match(
      projectAgentSessionContextName
    ).session;
  }

  /**
   * Parse the context from ProjectAgentSessionContext resource.
   *
   * @param {string} projectAgentSessionContextName
   *   A fully-qualified path representing project_agent_session_context resource.
   * @returns {string} A string representing the context.
   */
  matchContextFromProjectAgentSessionContextName(
    projectAgentSessionContextName: string
  ) {
    return this.pathTemplates.projectAgentSessionContextPathTemplate.match(
      projectAgentSessionContextName
    ).context;
  }

  /**
   * Return a fully-qualified projectAgentSessionEntityType resource name string.
   *
   * @param {string} project
   * @param {string} session
   * @param {string} entity_type
   * @returns {string} Resource name string.
   */
  projectAgentSessionEntityTypePath(
    project: string,
    session: string,
    entityType: string
  ) {
    return this.pathTemplates.projectAgentSessionEntityTypePathTemplate.render({
      project: project,
      session: session,
      entity_type: entityType,
    });
  }

  /**
   * Parse the project from ProjectAgentSessionEntityType resource.
   *
   * @param {string} projectAgentSessionEntityTypeName
   *   A fully-qualified path representing project_agent_session_entity_type resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentSessionEntityTypeName(
    projectAgentSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentSessionEntityTypePathTemplate.match(
      projectAgentSessionEntityTypeName
    ).project;
  }

  /**
   * Parse the session from ProjectAgentSessionEntityType resource.
   *
   * @param {string} projectAgentSessionEntityTypeName
   *   A fully-qualified path representing project_agent_session_entity_type resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectAgentSessionEntityTypeName(
    projectAgentSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentSessionEntityTypePathTemplate.match(
      projectAgentSessionEntityTypeName
    ).session;
  }

  /**
   * Parse the entity_type from ProjectAgentSessionEntityType resource.
   *
   * @param {string} projectAgentSessionEntityTypeName
   *   A fully-qualified path representing project_agent_session_entity_type resource.
   * @returns {string} A string representing the entity_type.
   */
  matchEntityTypeFromProjectAgentSessionEntityTypeName(
    projectAgentSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectAgentSessionEntityTypePathTemplate.match(
      projectAgentSessionEntityTypeName
    ).entity_type;
  }

  /**
   * Return a fully-qualified projectAgentVersion resource name string.
   *
   * @param {string} project
   * @param {string} version
   * @returns {string} Resource name string.
   */
  projectAgentVersionPath(project: string, version: string) {
    return this.pathTemplates.projectAgentVersionPathTemplate.render({
      project: project,
      version: version,
    });
  }

  /**
   * Parse the project from ProjectAgentVersion resource.
   *
   * @param {string} projectAgentVersionName
   *   A fully-qualified path representing project_agent_version resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAgentVersionName(projectAgentVersionName: string) {
    return this.pathTemplates.projectAgentVersionPathTemplate.match(
      projectAgentVersionName
    ).project;
  }

  /**
   * Parse the version from ProjectAgentVersion resource.
   *
   * @param {string} projectAgentVersionName
   *   A fully-qualified path representing project_agent_version resource.
   * @returns {string} A string representing the version.
   */
  matchVersionFromProjectAgentVersionName(projectAgentVersionName: string) {
    return this.pathTemplates.projectAgentVersionPathTemplate.match(
      projectAgentVersionName
    ).version;
  }

  /**
   * Return a fully-qualified projectAnswerRecord resource name string.
   *
   * @param {string} project
   * @param {string} answer_record
   * @returns {string} Resource name string.
   */
  projectAnswerRecordPath(project: string, answerRecord: string) {
    return this.pathTemplates.projectAnswerRecordPathTemplate.render({
      project: project,
      answer_record: answerRecord,
    });
  }

  /**
   * Parse the project from ProjectAnswerRecord resource.
   *
   * @param {string} projectAnswerRecordName
   *   A fully-qualified path representing project_answer_record resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectAnswerRecordName(projectAnswerRecordName: string) {
    return this.pathTemplates.projectAnswerRecordPathTemplate.match(
      projectAnswerRecordName
    ).project;
  }

  /**
   * Parse the answer_record from ProjectAnswerRecord resource.
   *
   * @param {string} projectAnswerRecordName
   *   A fully-qualified path representing project_answer_record resource.
   * @returns {string} A string representing the answer_record.
   */
  matchAnswerRecordFromProjectAnswerRecordName(
    projectAnswerRecordName: string
  ) {
    return this.pathTemplates.projectAnswerRecordPathTemplate.match(
      projectAnswerRecordName
    ).answer_record;
  }

  /**
   * Return a fully-qualified projectConversation resource name string.
   *
   * @param {string} project
   * @param {string} conversation
   * @returns {string} Resource name string.
   */
  projectConversationPath(project: string, conversation: string) {
    return this.pathTemplates.projectConversationPathTemplate.render({
      project: project,
      conversation: conversation,
    });
  }

  /**
   * Parse the project from ProjectConversation resource.
   *
   * @param {string} projectConversationName
   *   A fully-qualified path representing project_conversation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectConversationName(projectConversationName: string) {
    return this.pathTemplates.projectConversationPathTemplate.match(
      projectConversationName
    ).project;
  }

  /**
   * Parse the conversation from ProjectConversation resource.
   *
   * @param {string} projectConversationName
   *   A fully-qualified path representing project_conversation resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromProjectConversationName(
    projectConversationName: string
  ) {
    return this.pathTemplates.projectConversationPathTemplate.match(
      projectConversationName
    ).conversation;
  }

  /**
   * Return a fully-qualified projectConversationMessage resource name string.
   *
   * @param {string} project
   * @param {string} conversation
   * @param {string} message
   * @returns {string} Resource name string.
   */
  projectConversationMessagePath(
    project: string,
    conversation: string,
    message: string
  ) {
    return this.pathTemplates.projectConversationMessagePathTemplate.render({
      project: project,
      conversation: conversation,
      message: message,
    });
  }

  /**
   * Parse the project from ProjectConversationMessage resource.
   *
   * @param {string} projectConversationMessageName
   *   A fully-qualified path representing project_conversation_message resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectConversationMessageName(
    projectConversationMessageName: string
  ) {
    return this.pathTemplates.projectConversationMessagePathTemplate.match(
      projectConversationMessageName
    ).project;
  }

  /**
   * Parse the conversation from ProjectConversationMessage resource.
   *
   * @param {string} projectConversationMessageName
   *   A fully-qualified path representing project_conversation_message resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromProjectConversationMessageName(
    projectConversationMessageName: string
  ) {
    return this.pathTemplates.projectConversationMessagePathTemplate.match(
      projectConversationMessageName
    ).conversation;
  }

  /**
   * Parse the message from ProjectConversationMessage resource.
   *
   * @param {string} projectConversationMessageName
   *   A fully-qualified path representing project_conversation_message resource.
   * @returns {string} A string representing the message.
   */
  matchMessageFromProjectConversationMessageName(
    projectConversationMessageName: string
  ) {
    return this.pathTemplates.projectConversationMessagePathTemplate.match(
      projectConversationMessageName
    ).message;
  }

  /**
   * Return a fully-qualified projectConversationModel resource name string.
   *
   * @param {string} project
   * @param {string} conversation_model
   * @returns {string} Resource name string.
   */
  projectConversationModelPath(project: string, conversationModel: string) {
    return this.pathTemplates.projectConversationModelPathTemplate.render({
      project: project,
      conversation_model: conversationModel,
    });
  }

  /**
   * Parse the project from ProjectConversationModel resource.
   *
   * @param {string} projectConversationModelName
   *   A fully-qualified path representing project_conversation_model resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectConversationModelName(
    projectConversationModelName: string
  ) {
    return this.pathTemplates.projectConversationModelPathTemplate.match(
      projectConversationModelName
    ).project;
  }

  /**
   * Parse the conversation_model from ProjectConversationModel resource.
   *
   * @param {string} projectConversationModelName
   *   A fully-qualified path representing project_conversation_model resource.
   * @returns {string} A string representing the conversation_model.
   */
  matchConversationModelFromProjectConversationModelName(
    projectConversationModelName: string
  ) {
    return this.pathTemplates.projectConversationModelPathTemplate.match(
      projectConversationModelName
    ).conversation_model;
  }

  /**
   * Return a fully-qualified projectConversationModelEvaluation resource name string.
   *
   * @param {string} project
   * @param {string} conversation_model
   * @param {string} evaluation
   * @returns {string} Resource name string.
   */
  projectConversationModelEvaluationPath(
    project: string,
    conversationModel: string,
    evaluation: string
  ) {
    return this.pathTemplates.projectConversationModelEvaluationPathTemplate.render(
      {
        project: project,
        conversation_model: conversationModel,
        evaluation: evaluation,
      }
    );
  }

  /**
   * Parse the project from ProjectConversationModelEvaluation resource.
   *
   * @param {string} projectConversationModelEvaluationName
   *   A fully-qualified path representing project_conversation_model_evaluation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectConversationModelEvaluationName(
    projectConversationModelEvaluationName: string
  ) {
    return this.pathTemplates.projectConversationModelEvaluationPathTemplate.match(
      projectConversationModelEvaluationName
    ).project;
  }

  /**
   * Parse the conversation_model from ProjectConversationModelEvaluation resource.
   *
   * @param {string} projectConversationModelEvaluationName
   *   A fully-qualified path representing project_conversation_model_evaluation resource.
   * @returns {string} A string representing the conversation_model.
   */
  matchConversationModelFromProjectConversationModelEvaluationName(
    projectConversationModelEvaluationName: string
  ) {
    return this.pathTemplates.projectConversationModelEvaluationPathTemplate.match(
      projectConversationModelEvaluationName
    ).conversation_model;
  }

  /**
   * Parse the evaluation from ProjectConversationModelEvaluation resource.
   *
   * @param {string} projectConversationModelEvaluationName
   *   A fully-qualified path representing project_conversation_model_evaluation resource.
   * @returns {string} A string representing the evaluation.
   */
  matchEvaluationFromProjectConversationModelEvaluationName(
    projectConversationModelEvaluationName: string
  ) {
    return this.pathTemplates.projectConversationModelEvaluationPathTemplate.match(
      projectConversationModelEvaluationName
    ).evaluation;
  }

  /**
   * Return a fully-qualified projectConversationParticipant resource name string.
   *
   * @param {string} project
   * @param {string} conversation
   * @param {string} participant
   * @returns {string} Resource name string.
   */
  projectConversationParticipantPath(
    project: string,
    conversation: string,
    participant: string
  ) {
    return this.pathTemplates.projectConversationParticipantPathTemplate.render(
      {
        project: project,
        conversation: conversation,
        participant: participant,
      }
    );
  }

  /**
   * Parse the project from ProjectConversationParticipant resource.
   *
   * @param {string} projectConversationParticipantName
   *   A fully-qualified path representing project_conversation_participant resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectConversationParticipantName(
    projectConversationParticipantName: string
  ) {
    return this.pathTemplates.projectConversationParticipantPathTemplate.match(
      projectConversationParticipantName
    ).project;
  }

  /**
   * Parse the conversation from ProjectConversationParticipant resource.
   *
   * @param {string} projectConversationParticipantName
   *   A fully-qualified path representing project_conversation_participant resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromProjectConversationParticipantName(
    projectConversationParticipantName: string
  ) {
    return this.pathTemplates.projectConversationParticipantPathTemplate.match(
      projectConversationParticipantName
    ).conversation;
  }

  /**
   * Parse the participant from ProjectConversationParticipant resource.
   *
   * @param {string} projectConversationParticipantName
   *   A fully-qualified path representing project_conversation_participant resource.
   * @returns {string} A string representing the participant.
   */
  matchParticipantFromProjectConversationParticipantName(
    projectConversationParticipantName: string
  ) {
    return this.pathTemplates.projectConversationParticipantPathTemplate.match(
      projectConversationParticipantName
    ).participant;
  }

  /**
   * Return a fully-qualified projectConversationProfile resource name string.
   *
   * @param {string} project
   * @param {string} conversation_profile
   * @returns {string} Resource name string.
   */
  projectConversationProfilePath(project: string, conversationProfile: string) {
    return this.pathTemplates.projectConversationProfilePathTemplate.render({
      project: project,
      conversation_profile: conversationProfile,
    });
  }

  /**
   * Parse the project from ProjectConversationProfile resource.
   *
   * @param {string} projectConversationProfileName
   *   A fully-qualified path representing project_conversation_profile resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectConversationProfileName(
    projectConversationProfileName: string
  ) {
    return this.pathTemplates.projectConversationProfilePathTemplate.match(
      projectConversationProfileName
    ).project;
  }

  /**
   * Parse the conversation_profile from ProjectConversationProfile resource.
   *
   * @param {string} projectConversationProfileName
   *   A fully-qualified path representing project_conversation_profile resource.
   * @returns {string} A string representing the conversation_profile.
   */
  matchConversationProfileFromProjectConversationProfileName(
    projectConversationProfileName: string
  ) {
    return this.pathTemplates.projectConversationProfilePathTemplate.match(
      projectConversationProfileName
    ).conversation_profile;
  }

  /**
   * Return a fully-qualified projectKnowledgeBase resource name string.
   *
   * @param {string} project
   * @param {string} knowledge_base
   * @returns {string} Resource name string.
   */
  projectKnowledgeBasePath(project: string, knowledgeBase: string) {
    return this.pathTemplates.projectKnowledgeBasePathTemplate.render({
      project: project,
      knowledge_base: knowledgeBase,
    });
  }

  /**
   * Parse the project from ProjectKnowledgeBase resource.
   *
   * @param {string} projectKnowledgeBaseName
   *   A fully-qualified path representing project_knowledge_base resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectKnowledgeBaseName(projectKnowledgeBaseName: string) {
    return this.pathTemplates.projectKnowledgeBasePathTemplate.match(
      projectKnowledgeBaseName
    ).project;
  }

  /**
   * Parse the knowledge_base from ProjectKnowledgeBase resource.
   *
   * @param {string} projectKnowledgeBaseName
   *   A fully-qualified path representing project_knowledge_base resource.
   * @returns {string} A string representing the knowledge_base.
   */
  matchKnowledgeBaseFromProjectKnowledgeBaseName(
    projectKnowledgeBaseName: string
  ) {
    return this.pathTemplates.projectKnowledgeBasePathTemplate.match(
      projectKnowledgeBaseName
    ).knowledge_base;
  }

  /**
   * Return a fully-qualified projectKnowledgeBaseDocument resource name string.
   *
   * @param {string} project
   * @param {string} knowledge_base
   * @param {string} document
   * @returns {string} Resource name string.
   */
  projectKnowledgeBaseDocumentPath(
    project: string,
    knowledgeBase: string,
    document: string
  ) {
    return this.pathTemplates.projectKnowledgeBaseDocumentPathTemplate.render({
      project: project,
      knowledge_base: knowledgeBase,
      document: document,
    });
  }

  /**
   * Parse the project from ProjectKnowledgeBaseDocument resource.
   *
   * @param {string} projectKnowledgeBaseDocumentName
   *   A fully-qualified path representing project_knowledge_base_document resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectKnowledgeBaseDocumentName(
    projectKnowledgeBaseDocumentName: string
  ) {
    return this.pathTemplates.projectKnowledgeBaseDocumentPathTemplate.match(
      projectKnowledgeBaseDocumentName
    ).project;
  }

  /**
   * Parse the knowledge_base from ProjectKnowledgeBaseDocument resource.
   *
   * @param {string} projectKnowledgeBaseDocumentName
   *   A fully-qualified path representing project_knowledge_base_document resource.
   * @returns {string} A string representing the knowledge_base.
   */
  matchKnowledgeBaseFromProjectKnowledgeBaseDocumentName(
    projectKnowledgeBaseDocumentName: string
  ) {
    return this.pathTemplates.projectKnowledgeBaseDocumentPathTemplate.match(
      projectKnowledgeBaseDocumentName
    ).knowledge_base;
  }

  /**
   * Parse the document from ProjectKnowledgeBaseDocument resource.
   *
   * @param {string} projectKnowledgeBaseDocumentName
   *   A fully-qualified path representing project_knowledge_base_document resource.
   * @returns {string} A string representing the document.
   */
  matchDocumentFromProjectKnowledgeBaseDocumentName(
    projectKnowledgeBaseDocumentName: string
  ) {
    return this.pathTemplates.projectKnowledgeBaseDocumentPathTemplate.match(
      projectKnowledgeBaseDocumentName
    ).document;
  }

  /**
   * Return a fully-qualified projectLocationAgent resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @returns {string} Resource name string.
   */
  projectLocationAgentPath(project: string, location: string) {
    return this.pathTemplates.projectLocationAgentPathTemplate.render({
      project: project,
      location: location,
    });
  }

  /**
   * Parse the project from ProjectLocationAgent resource.
   *
   * @param {string} projectLocationAgentName
   *   A fully-qualified path representing project_location_agent resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentName(projectLocationAgentName: string) {
    return this.pathTemplates.projectLocationAgentPathTemplate.match(
      projectLocationAgentName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgent resource.
   *
   * @param {string} projectLocationAgentName
   *   A fully-qualified path representing project_location_agent resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentName(projectLocationAgentName: string) {
    return this.pathTemplates.projectLocationAgentPathTemplate.match(
      projectLocationAgentName
    ).location;
  }

  /**
   * Return a fully-qualified projectLocationAgentEntityType resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} entity_type
   * @returns {string} Resource name string.
   */
  projectLocationAgentEntityTypePath(
    project: string,
    location: string,
    entityType: string
  ) {
    return this.pathTemplates.projectLocationAgentEntityTypePathTemplate.render(
      {
        project: project,
        location: location,
        entity_type: entityType,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationAgentEntityType resource.
   *
   * @param {string} projectLocationAgentEntityTypeName
   *   A fully-qualified path representing project_location_agent_entity_type resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentEntityTypeName(
    projectLocationAgentEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEntityTypePathTemplate.match(
      projectLocationAgentEntityTypeName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentEntityType resource.
   *
   * @param {string} projectLocationAgentEntityTypeName
   *   A fully-qualified path representing project_location_agent_entity_type resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentEntityTypeName(
    projectLocationAgentEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEntityTypePathTemplate.match(
      projectLocationAgentEntityTypeName
    ).location;
  }

  /**
   * Parse the entity_type from ProjectLocationAgentEntityType resource.
   *
   * @param {string} projectLocationAgentEntityTypeName
   *   A fully-qualified path representing project_location_agent_entity_type resource.
   * @returns {string} A string representing the entity_type.
   */
  matchEntityTypeFromProjectLocationAgentEntityTypeName(
    projectLocationAgentEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEntityTypePathTemplate.match(
      projectLocationAgentEntityTypeName
    ).entity_type;
  }

  /**
   * Return a fully-qualified projectLocationAgentEnvironment resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} environment
   * @returns {string} Resource name string.
   */
  projectLocationAgentEnvironmentPath(
    project: string,
    location: string,
    environment: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentPathTemplate.render(
      {
        project: project,
        location: location,
        environment: environment,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationAgentEnvironment resource.
   *
   * @param {string} projectLocationAgentEnvironmentName
   *   A fully-qualified path representing project_location_agent_environment resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentEnvironmentName(
    projectLocationAgentEnvironmentName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentPathTemplate.match(
      projectLocationAgentEnvironmentName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentEnvironment resource.
   *
   * @param {string} projectLocationAgentEnvironmentName
   *   A fully-qualified path representing project_location_agent_environment resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentEnvironmentName(
    projectLocationAgentEnvironmentName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentPathTemplate.match(
      projectLocationAgentEnvironmentName
    ).location;
  }

  /**
   * Parse the environment from ProjectLocationAgentEnvironment resource.
   *
   * @param {string} projectLocationAgentEnvironmentName
   *   A fully-qualified path representing project_location_agent_environment resource.
   * @returns {string} A string representing the environment.
   */
  matchEnvironmentFromProjectLocationAgentEnvironmentName(
    projectLocationAgentEnvironmentName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentPathTemplate.match(
      projectLocationAgentEnvironmentName
    ).environment;
  }

  /**
   * Return a fully-qualified projectLocationAgentEnvironmentUserSessionContext resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} environment
   * @param {string} user
   * @param {string} session
   * @param {string} context
   * @returns {string} Resource name string.
   */
  projectLocationAgentEnvironmentUserSessionContextPath(
    project: string,
    location: string,
    environment: string,
    user: string,
    session: string,
    context: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionContextPathTemplate.render(
      {
        project: project,
        location: location,
        environment: environment,
        user: user,
        session: session,
        context: context,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_location_agent_environment_user_session_context resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentEnvironmentUserSessionContextName(
    projectLocationAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionContextPathTemplate.match(
      projectLocationAgentEnvironmentUserSessionContextName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_location_agent_environment_user_session_context resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentEnvironmentUserSessionContextName(
    projectLocationAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionContextPathTemplate.match(
      projectLocationAgentEnvironmentUserSessionContextName
    ).location;
  }

  /**
   * Parse the environment from ProjectLocationAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_location_agent_environment_user_session_context resource.
   * @returns {string} A string representing the environment.
   */
  matchEnvironmentFromProjectLocationAgentEnvironmentUserSessionContextName(
    projectLocationAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionContextPathTemplate.match(
      projectLocationAgentEnvironmentUserSessionContextName
    ).environment;
  }

  /**
   * Parse the user from ProjectLocationAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_location_agent_environment_user_session_context resource.
   * @returns {string} A string representing the user.
   */
  matchUserFromProjectLocationAgentEnvironmentUserSessionContextName(
    projectLocationAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionContextPathTemplate.match(
      projectLocationAgentEnvironmentUserSessionContextName
    ).user;
  }

  /**
   * Parse the session from ProjectLocationAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_location_agent_environment_user_session_context resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectLocationAgentEnvironmentUserSessionContextName(
    projectLocationAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionContextPathTemplate.match(
      projectLocationAgentEnvironmentUserSessionContextName
    ).session;
  }

  /**
   * Parse the context from ProjectLocationAgentEnvironmentUserSessionContext resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionContextName
   *   A fully-qualified path representing project_location_agent_environment_user_session_context resource.
   * @returns {string} A string representing the context.
   */
  matchContextFromProjectLocationAgentEnvironmentUserSessionContextName(
    projectLocationAgentEnvironmentUserSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionContextPathTemplate.match(
      projectLocationAgentEnvironmentUserSessionContextName
    ).context;
  }

  /**
   * Return a fully-qualified projectLocationAgentEnvironmentUserSessionEntityType resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} environment
   * @param {string} user
   * @param {string} session
   * @param {string} entity_type
   * @returns {string} Resource name string.
   */
  projectLocationAgentEnvironmentUserSessionEntityTypePath(
    project: string,
    location: string,
    environment: string,
    user: string,
    session: string,
    entityType: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate.render(
      {
        project: project,
        location: location,
        environment: environment,
        user: user,
        session: session,
        entity_type: entityType,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentEnvironmentUserSessionEntityTypeName(
    projectLocationAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectLocationAgentEnvironmentUserSessionEntityTypeName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentEnvironmentUserSessionEntityTypeName(
    projectLocationAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectLocationAgentEnvironmentUserSessionEntityTypeName
    ).location;
  }

  /**
   * Parse the environment from ProjectLocationAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the environment.
   */
  matchEnvironmentFromProjectLocationAgentEnvironmentUserSessionEntityTypeName(
    projectLocationAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectLocationAgentEnvironmentUserSessionEntityTypeName
    ).environment;
  }

  /**
   * Parse the user from ProjectLocationAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the user.
   */
  matchUserFromProjectLocationAgentEnvironmentUserSessionEntityTypeName(
    projectLocationAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectLocationAgentEnvironmentUserSessionEntityTypeName
    ).user;
  }

  /**
   * Parse the session from ProjectLocationAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectLocationAgentEnvironmentUserSessionEntityTypeName(
    projectLocationAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectLocationAgentEnvironmentUserSessionEntityTypeName
    ).session;
  }

  /**
   * Parse the entity_type from ProjectLocationAgentEnvironmentUserSessionEntityType resource.
   *
   * @param {string} projectLocationAgentEnvironmentUserSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_environment_user_session_entity_type resource.
   * @returns {string} A string representing the entity_type.
   */
  matchEntityTypeFromProjectLocationAgentEnvironmentUserSessionEntityTypeName(
    projectLocationAgentEnvironmentUserSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentEnvironmentUserSessionEntityTypePathTemplate.match(
      projectLocationAgentEnvironmentUserSessionEntityTypeName
    ).entity_type;
  }

  /**
   * Return a fully-qualified projectLocationAgentFulfillment resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @returns {string} Resource name string.
   */
  projectLocationAgentFulfillmentPath(project: string, location: string) {
    return this.pathTemplates.projectLocationAgentFulfillmentPathTemplate.render(
      {
        project: project,
        location: location,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationAgentFulfillment resource.
   *
   * @param {string} projectLocationAgentFulfillmentName
   *   A fully-qualified path representing project_location_agent_fulfillment resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentFulfillmentName(
    projectLocationAgentFulfillmentName: string
  ) {
    return this.pathTemplates.projectLocationAgentFulfillmentPathTemplate.match(
      projectLocationAgentFulfillmentName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentFulfillment resource.
   *
   * @param {string} projectLocationAgentFulfillmentName
   *   A fully-qualified path representing project_location_agent_fulfillment resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentFulfillmentName(
    projectLocationAgentFulfillmentName: string
  ) {
    return this.pathTemplates.projectLocationAgentFulfillmentPathTemplate.match(
      projectLocationAgentFulfillmentName
    ).location;
  }

  /**
   * Return a fully-qualified projectLocationAgentIntent resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} intent
   * @returns {string} Resource name string.
   */
  projectLocationAgentIntentPath(
    project: string,
    location: string,
    intent: string
  ) {
    return this.pathTemplates.projectLocationAgentIntentPathTemplate.render({
      project: project,
      location: location,
      intent: intent,
    });
  }

  /**
   * Parse the project from ProjectLocationAgentIntent resource.
   *
   * @param {string} projectLocationAgentIntentName
   *   A fully-qualified path representing project_location_agent_intent resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentIntentName(
    projectLocationAgentIntentName: string
  ) {
    return this.pathTemplates.projectLocationAgentIntentPathTemplate.match(
      projectLocationAgentIntentName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentIntent resource.
   *
   * @param {string} projectLocationAgentIntentName
   *   A fully-qualified path representing project_location_agent_intent resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentIntentName(
    projectLocationAgentIntentName: string
  ) {
    return this.pathTemplates.projectLocationAgentIntentPathTemplate.match(
      projectLocationAgentIntentName
    ).location;
  }

  /**
   * Parse the intent from ProjectLocationAgentIntent resource.
   *
   * @param {string} projectLocationAgentIntentName
   *   A fully-qualified path representing project_location_agent_intent resource.
   * @returns {string} A string representing the intent.
   */
  matchIntentFromProjectLocationAgentIntentName(
    projectLocationAgentIntentName: string
  ) {
    return this.pathTemplates.projectLocationAgentIntentPathTemplate.match(
      projectLocationAgentIntentName
    ).intent;
  }

  /**
   * Return a fully-qualified projectLocationAgentSessionContext resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} session
   * @param {string} context
   * @returns {string} Resource name string.
   */
  projectLocationAgentSessionContextPath(
    project: string,
    location: string,
    session: string,
    context: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionContextPathTemplate.render(
      {
        project: project,
        location: location,
        session: session,
        context: context,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationAgentSessionContext resource.
   *
   * @param {string} projectLocationAgentSessionContextName
   *   A fully-qualified path representing project_location_agent_session_context resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentSessionContextName(
    projectLocationAgentSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionContextPathTemplate.match(
      projectLocationAgentSessionContextName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentSessionContext resource.
   *
   * @param {string} projectLocationAgentSessionContextName
   *   A fully-qualified path representing project_location_agent_session_context resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentSessionContextName(
    projectLocationAgentSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionContextPathTemplate.match(
      projectLocationAgentSessionContextName
    ).location;
  }

  /**
   * Parse the session from ProjectLocationAgentSessionContext resource.
   *
   * @param {string} projectLocationAgentSessionContextName
   *   A fully-qualified path representing project_location_agent_session_context resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectLocationAgentSessionContextName(
    projectLocationAgentSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionContextPathTemplate.match(
      projectLocationAgentSessionContextName
    ).session;
  }

  /**
   * Parse the context from ProjectLocationAgentSessionContext resource.
   *
   * @param {string} projectLocationAgentSessionContextName
   *   A fully-qualified path representing project_location_agent_session_context resource.
   * @returns {string} A string representing the context.
   */
  matchContextFromProjectLocationAgentSessionContextName(
    projectLocationAgentSessionContextName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionContextPathTemplate.match(
      projectLocationAgentSessionContextName
    ).context;
  }

  /**
   * Return a fully-qualified projectLocationAgentSessionEntityType resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} session
   * @param {string} entity_type
   * @returns {string} Resource name string.
   */
  projectLocationAgentSessionEntityTypePath(
    project: string,
    location: string,
    session: string,
    entityType: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionEntityTypePathTemplate.render(
      {
        project: project,
        location: location,
        session: session,
        entity_type: entityType,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationAgentSessionEntityType resource.
   *
   * @param {string} projectLocationAgentSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_session_entity_type resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentSessionEntityTypeName(
    projectLocationAgentSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionEntityTypePathTemplate.match(
      projectLocationAgentSessionEntityTypeName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentSessionEntityType resource.
   *
   * @param {string} projectLocationAgentSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_session_entity_type resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentSessionEntityTypeName(
    projectLocationAgentSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionEntityTypePathTemplate.match(
      projectLocationAgentSessionEntityTypeName
    ).location;
  }

  /**
   * Parse the session from ProjectLocationAgentSessionEntityType resource.
   *
   * @param {string} projectLocationAgentSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_session_entity_type resource.
   * @returns {string} A string representing the session.
   */
  matchSessionFromProjectLocationAgentSessionEntityTypeName(
    projectLocationAgentSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionEntityTypePathTemplate.match(
      projectLocationAgentSessionEntityTypeName
    ).session;
  }

  /**
   * Parse the entity_type from ProjectLocationAgentSessionEntityType resource.
   *
   * @param {string} projectLocationAgentSessionEntityTypeName
   *   A fully-qualified path representing project_location_agent_session_entity_type resource.
   * @returns {string} A string representing the entity_type.
   */
  matchEntityTypeFromProjectLocationAgentSessionEntityTypeName(
    projectLocationAgentSessionEntityTypeName: string
  ) {
    return this.pathTemplates.projectLocationAgentSessionEntityTypePathTemplate.match(
      projectLocationAgentSessionEntityTypeName
    ).entity_type;
  }

  /**
   * Return a fully-qualified projectLocationAgentVersion resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} version
   * @returns {string} Resource name string.
   */
  projectLocationAgentVersionPath(
    project: string,
    location: string,
    version: string
  ) {
    return this.pathTemplates.projectLocationAgentVersionPathTemplate.render({
      project: project,
      location: location,
      version: version,
    });
  }

  /**
   * Parse the project from ProjectLocationAgentVersion resource.
   *
   * @param {string} projectLocationAgentVersionName
   *   A fully-qualified path representing project_location_agent_version resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAgentVersionName(
    projectLocationAgentVersionName: string
  ) {
    return this.pathTemplates.projectLocationAgentVersionPathTemplate.match(
      projectLocationAgentVersionName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAgentVersion resource.
   *
   * @param {string} projectLocationAgentVersionName
   *   A fully-qualified path representing project_location_agent_version resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAgentVersionName(
    projectLocationAgentVersionName: string
  ) {
    return this.pathTemplates.projectLocationAgentVersionPathTemplate.match(
      projectLocationAgentVersionName
    ).location;
  }

  /**
   * Parse the version from ProjectLocationAgentVersion resource.
   *
   * @param {string} projectLocationAgentVersionName
   *   A fully-qualified path representing project_location_agent_version resource.
   * @returns {string} A string representing the version.
   */
  matchVersionFromProjectLocationAgentVersionName(
    projectLocationAgentVersionName: string
  ) {
    return this.pathTemplates.projectLocationAgentVersionPathTemplate.match(
      projectLocationAgentVersionName
    ).version;
  }

  /**
   * Return a fully-qualified projectLocationAnswerRecord resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} answer_record
   * @returns {string} Resource name string.
   */
  projectLocationAnswerRecordPath(
    project: string,
    location: string,
    answerRecord: string
  ) {
    return this.pathTemplates.projectLocationAnswerRecordPathTemplate.render({
      project: project,
      location: location,
      answer_record: answerRecord,
    });
  }

  /**
   * Parse the project from ProjectLocationAnswerRecord resource.
   *
   * @param {string} projectLocationAnswerRecordName
   *   A fully-qualified path representing project_location_answer_record resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationAnswerRecordName(
    projectLocationAnswerRecordName: string
  ) {
    return this.pathTemplates.projectLocationAnswerRecordPathTemplate.match(
      projectLocationAnswerRecordName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationAnswerRecord resource.
   *
   * @param {string} projectLocationAnswerRecordName
   *   A fully-qualified path representing project_location_answer_record resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationAnswerRecordName(
    projectLocationAnswerRecordName: string
  ) {
    return this.pathTemplates.projectLocationAnswerRecordPathTemplate.match(
      projectLocationAnswerRecordName
    ).location;
  }

  /**
   * Parse the answer_record from ProjectLocationAnswerRecord resource.
   *
   * @param {string} projectLocationAnswerRecordName
   *   A fully-qualified path representing project_location_answer_record resource.
   * @returns {string} A string representing the answer_record.
   */
  matchAnswerRecordFromProjectLocationAnswerRecordName(
    projectLocationAnswerRecordName: string
  ) {
    return this.pathTemplates.projectLocationAnswerRecordPathTemplate.match(
      projectLocationAnswerRecordName
    ).answer_record;
  }

  /**
   * Return a fully-qualified projectLocationConversation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} conversation
   * @returns {string} Resource name string.
   */
  projectLocationConversationPath(
    project: string,
    location: string,
    conversation: string
  ) {
    return this.pathTemplates.projectLocationConversationPathTemplate.render({
      project: project,
      location: location,
      conversation: conversation,
    });
  }

  /**
   * Parse the project from ProjectLocationConversation resource.
   *
   * @param {string} projectLocationConversationName
   *   A fully-qualified path representing project_location_conversation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationConversationName(
    projectLocationConversationName: string
  ) {
    return this.pathTemplates.projectLocationConversationPathTemplate.match(
      projectLocationConversationName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationConversation resource.
   *
   * @param {string} projectLocationConversationName
   *   A fully-qualified path representing project_location_conversation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationConversationName(
    projectLocationConversationName: string
  ) {
    return this.pathTemplates.projectLocationConversationPathTemplate.match(
      projectLocationConversationName
    ).location;
  }

  /**
   * Parse the conversation from ProjectLocationConversation resource.
   *
   * @param {string} projectLocationConversationName
   *   A fully-qualified path representing project_location_conversation resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromProjectLocationConversationName(
    projectLocationConversationName: string
  ) {
    return this.pathTemplates.projectLocationConversationPathTemplate.match(
      projectLocationConversationName
    ).conversation;
  }

  /**
   * Return a fully-qualified projectLocationConversationMessage resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} conversation
   * @param {string} message
   * @returns {string} Resource name string.
   */
  projectLocationConversationMessagePath(
    project: string,
    location: string,
    conversation: string,
    message: string
  ) {
    return this.pathTemplates.projectLocationConversationMessagePathTemplate.render(
      {
        project: project,
        location: location,
        conversation: conversation,
        message: message,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationConversationMessage resource.
   *
   * @param {string} projectLocationConversationMessageName
   *   A fully-qualified path representing project_location_conversation_message resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationConversationMessageName(
    projectLocationConversationMessageName: string
  ) {
    return this.pathTemplates.projectLocationConversationMessagePathTemplate.match(
      projectLocationConversationMessageName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationConversationMessage resource.
   *
   * @param {string} projectLocationConversationMessageName
   *   A fully-qualified path representing project_location_conversation_message resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationConversationMessageName(
    projectLocationConversationMessageName: string
  ) {
    return this.pathTemplates.projectLocationConversationMessagePathTemplate.match(
      projectLocationConversationMessageName
    ).location;
  }

  /**
   * Parse the conversation from ProjectLocationConversationMessage resource.
   *
   * @param {string} projectLocationConversationMessageName
   *   A fully-qualified path representing project_location_conversation_message resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromProjectLocationConversationMessageName(
    projectLocationConversationMessageName: string
  ) {
    return this.pathTemplates.projectLocationConversationMessagePathTemplate.match(
      projectLocationConversationMessageName
    ).conversation;
  }

  /**
   * Parse the message from ProjectLocationConversationMessage resource.
   *
   * @param {string} projectLocationConversationMessageName
   *   A fully-qualified path representing project_location_conversation_message resource.
   * @returns {string} A string representing the message.
   */
  matchMessageFromProjectLocationConversationMessageName(
    projectLocationConversationMessageName: string
  ) {
    return this.pathTemplates.projectLocationConversationMessagePathTemplate.match(
      projectLocationConversationMessageName
    ).message;
  }

  /**
   * Return a fully-qualified projectLocationConversationModel resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} conversation_model
   * @returns {string} Resource name string.
   */
  projectLocationConversationModelPath(
    project: string,
    location: string,
    conversationModel: string
  ) {
    return this.pathTemplates.projectLocationConversationModelPathTemplate.render(
      {
        project: project,
        location: location,
        conversation_model: conversationModel,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationConversationModel resource.
   *
   * @param {string} projectLocationConversationModelName
   *   A fully-qualified path representing project_location_conversation_model resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationConversationModelName(
    projectLocationConversationModelName: string
  ) {
    return this.pathTemplates.projectLocationConversationModelPathTemplate.match(
      projectLocationConversationModelName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationConversationModel resource.
   *
   * @param {string} projectLocationConversationModelName
   *   A fully-qualified path representing project_location_conversation_model resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationConversationModelName(
    projectLocationConversationModelName: string
  ) {
    return this.pathTemplates.projectLocationConversationModelPathTemplate.match(
      projectLocationConversationModelName
    ).location;
  }

  /**
   * Parse the conversation_model from ProjectLocationConversationModel resource.
   *
   * @param {string} projectLocationConversationModelName
   *   A fully-qualified path representing project_location_conversation_model resource.
   * @returns {string} A string representing the conversation_model.
   */
  matchConversationModelFromProjectLocationConversationModelName(
    projectLocationConversationModelName: string
  ) {
    return this.pathTemplates.projectLocationConversationModelPathTemplate.match(
      projectLocationConversationModelName
    ).conversation_model;
  }

  /**
   * Return a fully-qualified projectLocationConversationModelEvaluation resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} conversation_model
   * @param {string} evaluation
   * @returns {string} Resource name string.
   */
  projectLocationConversationModelEvaluationPath(
    project: string,
    location: string,
    conversationModel: string,
    evaluation: string
  ) {
    return this.pathTemplates.projectLocationConversationModelEvaluationPathTemplate.render(
      {
        project: project,
        location: location,
        conversation_model: conversationModel,
        evaluation: evaluation,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationConversationModelEvaluation resource.
   *
   * @param {string} projectLocationConversationModelEvaluationName
   *   A fully-qualified path representing project_location_conversation_model_evaluation resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationConversationModelEvaluationName(
    projectLocationConversationModelEvaluationName: string
  ) {
    return this.pathTemplates.projectLocationConversationModelEvaluationPathTemplate.match(
      projectLocationConversationModelEvaluationName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationConversationModelEvaluation resource.
   *
   * @param {string} projectLocationConversationModelEvaluationName
   *   A fully-qualified path representing project_location_conversation_model_evaluation resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationConversationModelEvaluationName(
    projectLocationConversationModelEvaluationName: string
  ) {
    return this.pathTemplates.projectLocationConversationModelEvaluationPathTemplate.match(
      projectLocationConversationModelEvaluationName
    ).location;
  }

  /**
   * Parse the conversation_model from ProjectLocationConversationModelEvaluation resource.
   *
   * @param {string} projectLocationConversationModelEvaluationName
   *   A fully-qualified path representing project_location_conversation_model_evaluation resource.
   * @returns {string} A string representing the conversation_model.
   */
  matchConversationModelFromProjectLocationConversationModelEvaluationName(
    projectLocationConversationModelEvaluationName: string
  ) {
    return this.pathTemplates.projectLocationConversationModelEvaluationPathTemplate.match(
      projectLocationConversationModelEvaluationName
    ).conversation_model;
  }

  /**
   * Parse the evaluation from ProjectLocationConversationModelEvaluation resource.
   *
   * @param {string} projectLocationConversationModelEvaluationName
   *   A fully-qualified path representing project_location_conversation_model_evaluation resource.
   * @returns {string} A string representing the evaluation.
   */
  matchEvaluationFromProjectLocationConversationModelEvaluationName(
    projectLocationConversationModelEvaluationName: string
  ) {
    return this.pathTemplates.projectLocationConversationModelEvaluationPathTemplate.match(
      projectLocationConversationModelEvaluationName
    ).evaluation;
  }

  /**
   * Return a fully-qualified projectLocationConversationParticipant resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} conversation
   * @param {string} participant
   * @returns {string} Resource name string.
   */
  projectLocationConversationParticipantPath(
    project: string,
    location: string,
    conversation: string,
    participant: string
  ) {
    return this.pathTemplates.projectLocationConversationParticipantPathTemplate.render(
      {
        project: project,
        location: location,
        conversation: conversation,
        participant: participant,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationConversationParticipant resource.
   *
   * @param {string} projectLocationConversationParticipantName
   *   A fully-qualified path representing project_location_conversation_participant resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationConversationParticipantName(
    projectLocationConversationParticipantName: string
  ) {
    return this.pathTemplates.projectLocationConversationParticipantPathTemplate.match(
      projectLocationConversationParticipantName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationConversationParticipant resource.
   *
   * @param {string} projectLocationConversationParticipantName
   *   A fully-qualified path representing project_location_conversation_participant resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationConversationParticipantName(
    projectLocationConversationParticipantName: string
  ) {
    return this.pathTemplates.projectLocationConversationParticipantPathTemplate.match(
      projectLocationConversationParticipantName
    ).location;
  }

  /**
   * Parse the conversation from ProjectLocationConversationParticipant resource.
   *
   * @param {string} projectLocationConversationParticipantName
   *   A fully-qualified path representing project_location_conversation_participant resource.
   * @returns {string} A string representing the conversation.
   */
  matchConversationFromProjectLocationConversationParticipantName(
    projectLocationConversationParticipantName: string
  ) {
    return this.pathTemplates.projectLocationConversationParticipantPathTemplate.match(
      projectLocationConversationParticipantName
    ).conversation;
  }

  /**
   * Parse the participant from ProjectLocationConversationParticipant resource.
   *
   * @param {string} projectLocationConversationParticipantName
   *   A fully-qualified path representing project_location_conversation_participant resource.
   * @returns {string} A string representing the participant.
   */
  matchParticipantFromProjectLocationConversationParticipantName(
    projectLocationConversationParticipantName: string
  ) {
    return this.pathTemplates.projectLocationConversationParticipantPathTemplate.match(
      projectLocationConversationParticipantName
    ).participant;
  }

  /**
   * Return a fully-qualified projectLocationConversationProfile resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} conversation_profile
   * @returns {string} Resource name string.
   */
  projectLocationConversationProfilePath(
    project: string,
    location: string,
    conversationProfile: string
  ) {
    return this.pathTemplates.projectLocationConversationProfilePathTemplate.render(
      {
        project: project,
        location: location,
        conversation_profile: conversationProfile,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationConversationProfile resource.
   *
   * @param {string} projectLocationConversationProfileName
   *   A fully-qualified path representing project_location_conversation_profile resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationConversationProfileName(
    projectLocationConversationProfileName: string
  ) {
    return this.pathTemplates.projectLocationConversationProfilePathTemplate.match(
      projectLocationConversationProfileName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationConversationProfile resource.
   *
   * @param {string} projectLocationConversationProfileName
   *   A fully-qualified path representing project_location_conversation_profile resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationConversationProfileName(
    projectLocationConversationProfileName: string
  ) {
    return this.pathTemplates.projectLocationConversationProfilePathTemplate.match(
      projectLocationConversationProfileName
    ).location;
  }

  /**
   * Parse the conversation_profile from ProjectLocationConversationProfile resource.
   *
   * @param {string} projectLocationConversationProfileName
   *   A fully-qualified path representing project_location_conversation_profile resource.
   * @returns {string} A string representing the conversation_profile.
   */
  matchConversationProfileFromProjectLocationConversationProfileName(
    projectLocationConversationProfileName: string
  ) {
    return this.pathTemplates.projectLocationConversationProfilePathTemplate.match(
      projectLocationConversationProfileName
    ).conversation_profile;
  }

  /**
   * Return a fully-qualified projectLocationKnowledgeBase resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} knowledge_base
   * @returns {string} Resource name string.
   */
  projectLocationKnowledgeBasePath(
    project: string,
    location: string,
    knowledgeBase: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBasePathTemplate.render({
      project: project,
      location: location,
      knowledge_base: knowledgeBase,
    });
  }

  /**
   * Parse the project from ProjectLocationKnowledgeBase resource.
   *
   * @param {string} projectLocationKnowledgeBaseName
   *   A fully-qualified path representing project_location_knowledge_base resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationKnowledgeBaseName(
    projectLocationKnowledgeBaseName: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBasePathTemplate.match(
      projectLocationKnowledgeBaseName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationKnowledgeBase resource.
   *
   * @param {string} projectLocationKnowledgeBaseName
   *   A fully-qualified path representing project_location_knowledge_base resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationKnowledgeBaseName(
    projectLocationKnowledgeBaseName: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBasePathTemplate.match(
      projectLocationKnowledgeBaseName
    ).location;
  }

  /**
   * Parse the knowledge_base from ProjectLocationKnowledgeBase resource.
   *
   * @param {string} projectLocationKnowledgeBaseName
   *   A fully-qualified path representing project_location_knowledge_base resource.
   * @returns {string} A string representing the knowledge_base.
   */
  matchKnowledgeBaseFromProjectLocationKnowledgeBaseName(
    projectLocationKnowledgeBaseName: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBasePathTemplate.match(
      projectLocationKnowledgeBaseName
    ).knowledge_base;
  }

  /**
   * Return a fully-qualified projectLocationKnowledgeBaseDocument resource name string.
   *
   * @param {string} project
   * @param {string} location
   * @param {string} knowledge_base
   * @param {string} document
   * @returns {string} Resource name string.
   */
  projectLocationKnowledgeBaseDocumentPath(
    project: string,
    location: string,
    knowledgeBase: string,
    document: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBaseDocumentPathTemplate.render(
      {
        project: project,
        location: location,
        knowledge_base: knowledgeBase,
        document: document,
      }
    );
  }

  /**
   * Parse the project from ProjectLocationKnowledgeBaseDocument resource.
   *
   * @param {string} projectLocationKnowledgeBaseDocumentName
   *   A fully-qualified path representing project_location_knowledge_base_document resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectLocationKnowledgeBaseDocumentName(
    projectLocationKnowledgeBaseDocumentName: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBaseDocumentPathTemplate.match(
      projectLocationKnowledgeBaseDocumentName
    ).project;
  }

  /**
   * Parse the location from ProjectLocationKnowledgeBaseDocument resource.
   *
   * @param {string} projectLocationKnowledgeBaseDocumentName
   *   A fully-qualified path representing project_location_knowledge_base_document resource.
   * @returns {string} A string representing the location.
   */
  matchLocationFromProjectLocationKnowledgeBaseDocumentName(
    projectLocationKnowledgeBaseDocumentName: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBaseDocumentPathTemplate.match(
      projectLocationKnowledgeBaseDocumentName
    ).location;
  }

  /**
   * Parse the knowledge_base from ProjectLocationKnowledgeBaseDocument resource.
   *
   * @param {string} projectLocationKnowledgeBaseDocumentName
   *   A fully-qualified path representing project_location_knowledge_base_document resource.
   * @returns {string} A string representing the knowledge_base.
   */
  matchKnowledgeBaseFromProjectLocationKnowledgeBaseDocumentName(
    projectLocationKnowledgeBaseDocumentName: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBaseDocumentPathTemplate.match(
      projectLocationKnowledgeBaseDocumentName
    ).knowledge_base;
  }

  /**
   * Parse the document from ProjectLocationKnowledgeBaseDocument resource.
   *
   * @param {string} projectLocationKnowledgeBaseDocumentName
   *   A fully-qualified path representing project_location_knowledge_base_document resource.
   * @returns {string} A string representing the document.
   */
  matchDocumentFromProjectLocationKnowledgeBaseDocumentName(
    projectLocationKnowledgeBaseDocumentName: string
  ) {
    return this.pathTemplates.projectLocationKnowledgeBaseDocumentPathTemplate.match(
      projectLocationKnowledgeBaseDocumentName
    ).document;
  }

  /**
   * Terminate the gRPC channel and close the client.
   *
   * The client will no longer be usable and all future behavior is undefined.
   * @returns {Promise} A promise that resolves when the client is closed.
   */
  close(): Promise<void> {
    if (this.versionsStub && !this._terminated) {
      return this.versionsStub.then(stub => {
        this._terminated = true;
        stub.close();
        this.locationsClient.close();
        this.operationsClient.close();
      });
    }
    return Promise.resolve();
  }
}
