import Foundation

public struct StorableColor: Codable, Equatable {
    public var red: Double
    public var green: Double
    public var blue: Double
    public var alpha: Double

    public init(red: Double, green: Double, blue: Double, alpha: Double) {
        self.red = red
        self.green = green
        self.blue = blue
        self.alpha = alpha
    }
}

#if canImport(SwiftUI)
import SwiftUI
public extension StorableColor {
    var swiftUIColor: SwiftUI.Color {
        SwiftUI.Color(CGColor(red: red, green: green, blue: blue, alpha: alpha))
    }
}
#endif

#if canImport(AppKit)
import AppKit
public extension StorableColor {
    var nsColor: NSColor {
        NSColor(
            srgbRed: CGFloat(red),
            green: CGFloat(green),
            blue: CGFloat(blue),
            alpha: CGFloat(alpha)
        )
    }
}
#endif

