# Node.js v7 ChangeLog

<table>
<tr>
<th title="Previously called 'Stable'">Current</th>
</tr>
<tr>
<td>
<a href="#7.2.0">7.2.0</a><br/>
<a href="#7.1.0">7.1.0</a><br/>
<a href="#7.0.0">7.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="7.2.0"></a>
## 2016-11-22, Version 7.2.0 (Current), @Fishrock123

_This is a security release impacting Windows 10 users._

### Notable changes

* **crypto**: The `Decipher` methods `setAuthTag()` and `setAAD` now return `this`. (Kirill Fomichev) [#9398](https://github.com/nodejs/node/pull/9398)
* **dns**: Implemented `{ttl: true}` for `resolve4()` and `resolve6()`. (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296) & [#9296](https://github.com/nodejs/node/pull/9296)
* **libuv**: Upgrade to v1.10.1 (cjihrig) [#9647](https://github.com/nodejs/node/pull/9647)
  - Fixed a potential buffer overflow when writing data to console on Windows 10. (CVE-2016-9551)
* **process**: Added a new `external` property to the data returned by `memoryUsage()`. (Fedor Indutny) [#9587](https://github.com/nodejs/node/pull/9587)
* **tls**: Fixed a memory leak when writes were queued on TLS connection that was destroyed during handshake. (Fedor Indutny) [#9626](https://github.com/nodejs/node/pull/9626)
* **V8 (dep)**: Upgrade to v5.4.500.43 (Michaël Zasso) [#9697](https://github.com/nodejs/node/pull/9697)
* **v8**: The data returned by `getHeapStatistics()` now includes three new fields: `malloced_memory`, `peak_malloced_memory`, and `does_zap_garbage`. (Gareth Ellis) [#8610](https://github.com/nodejs/node/pull/8610)

### Commits

* [[`819a38df96`](https://github.com/nodejs/node/commit/819a38df96)] - **benchmark**: split timers benchmark and refactor (Rich Trott) [#9497](https://github.com/nodejs/node/pull/9497)
* [[`0083bf2233`](https://github.com/nodejs/node/commit/0083bf2233)] - **build**: default to ppc64 on AIX (Gibson Fahnestock) [#9645](https://github.com/nodejs/node/pull/9645)
* [[`3efb43c8ba`](https://github.com/nodejs/node/commit/3efb43c8ba)] - **build**: Add option to compile for coverage reports (Wayne Andrews) [#9463](https://github.com/nodejs/node/pull/9463)
* [[`af74db3961`](https://github.com/nodejs/node/commit/af74db3961)] - **crypto**: use SSL_get_servername. (Adam Langley) [#9347](https://github.com/nodejs/node/pull/9347)
* [[`bcdbf22f0d`](https://github.com/nodejs/node/commit/bcdbf22f0d)] - **crypto**: fix handling of root_cert_store. (Adam Langley) [#9409](https://github.com/nodejs/node/pull/9409)
* [[`3f45cc19b0`](https://github.com/nodejs/node/commit/3f45cc19b0)] - **crypto**: Use reference count to manage cert_store (Adam Majer) [#9409](https://github.com/nodejs/node/pull/9409)
* [[`08a7e7b009`](https://github.com/nodejs/node/commit/08a7e7b009)] - **(SEMVER-MINOR)** **crypto**: return `this` in setAuthTag/setAAD (Kirill Fomichev) [#9398](https://github.com/nodejs/node/pull/9398)
* [[`786631c7b4`](https://github.com/nodejs/node/commit/786631c7b4)] - **deps**: upgrade libuv to 1.10.1 (cjihrig) [#9647](https://github.com/nodejs/node/pull/9647)
* [[`1520afd336`](https://github.com/nodejs/node/commit/1520afd336)] - **deps**: update V8 to 5.4.500.43 (Michaël Zasso) [#9697](https://github.com/nodejs/node/pull/9697)
* [[`33bcd6fec8`](https://github.com/nodejs/node/commit/33bcd6fec8)] - **deps**: update V8 to 5.4.500.41 (Michaël Zasso) [#9412](https://github.com/nodejs/node/pull/9412)
* [[`0a3e5cc57a`](https://github.com/nodejs/node/commit/0a3e5cc57a)] - **(SEMVER-MINOR)** **dns**: implement {ttl: true} for dns.resolve6() (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* [[`1bd79368cd`](https://github.com/nodejs/node/commit/1bd79368cd)] - **(SEMVER-MINOR)** **dns**: implement {ttl: true} for dns.resolve4() (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* [[`fa98eec410`](https://github.com/nodejs/node/commit/fa98eec410)] - **doc**: fix typo in assert code example (Vse Mozhet Byt) [#9704](https://github.com/nodejs/node/pull/9704)
* [[`409851427a`](https://github.com/nodejs/node/commit/409851427a)] - **doc**: fix typo in doc/tls.md (Syuhei Kobayashi) [#9566](https://github.com/nodejs/node/pull/9566)
* [[`ebc9c4ba97`](https://github.com/nodejs/node/commit/ebc9c4ba97)] - **doc**: add missing link in changelog (Evan Lucas) [#9540](https://github.com/nodejs/node/pull/9540)
* [[`bbd5853236`](https://github.com/nodejs/node/commit/bbd5853236)] - **doc**: v6 is now LTS rather than Current (Jeremiah Senkpiel) [#9182](https://github.com/nodejs/node/pull/9182)
* [[`8030994554`](https://github.com/nodejs/node/commit/8030994554)] - **doc**: fix some table problems in changelog.md (Jeremiah Senkpiel) [#9183](https://github.com/nodejs/node/pull/9183)
* [[`b070df8932`](https://github.com/nodejs/node/commit/b070df8932)] - **doc**: fix typo in BUILDING.md (monkick) [#9569](https://github.com/nodejs/node/pull/9569)
* [[`39f04829d6`](https://github.com/nodejs/node/commit/39f04829d6)] - **doc**: remove backtick escaping for manpage refs (Anna Henningsen) [#9632](https://github.com/nodejs/node/pull/9632)
* [[`159799aa1d`](https://github.com/nodejs/node/commit/159799aa1d)] - **doc**: improve description of urlObject.query (Rahat Ahmed) [#9625](https://github.com/nodejs/node/pull/9625)
* [[`d62376c8d6`](https://github.com/nodejs/node/commit/d62376c8d6)] - **doc**: small improvements in readline code examples (Vse Mozhet Byt) [#9628](https://github.com/nodejs/node/pull/9628)
* [[`69ffe0cf8c`](https://github.com/nodejs/node/commit/69ffe0cf8c)] - **doc**: child_process .stdio accepts a String type (Kenneth Skovhus) [#9637](https://github.com/nodejs/node/pull/9637)
* [[`c99fb1e0d2`](https://github.com/nodejs/node/commit/c99fb1e0d2)] - **doc**: remove invalid padding from privateEncrypt (JungMinu) [#9611](https://github.com/nodejs/node/pull/9611)
* [[`b258a70a40`](https://github.com/nodejs/node/commit/b258a70a40)] - **doc**: add return types and props types to OS module (imatvieiev) [#9648](https://github.com/nodejs/node/pull/9648)
* [[`425a8646e2`](https://github.com/nodejs/node/commit/425a8646e2)] - **doc**: add italoacasas to collaborators (Italo A. Casas) [#9677](https://github.com/nodejs/node/pull/9677)
* [[`8bf42b4ec4`](https://github.com/nodejs/node/commit/8bf42b4ec4)] - **doc**: strip trailing whitespace (Sam Roberts) [#9620](https://github.com/nodejs/node/pull/9620)
* [[`16819d29b0`](https://github.com/nodejs/node/commit/16819d29b0)] - **doc**: fix "either as either" typo (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`c18ca1593e`](https://github.com/nodejs/node/commit/c18ca1593e)] - **doc**: fix tls "the the" typo (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`f43e47aab2`](https://github.com/nodejs/node/commit/f43e47aab2)] - **doc**: describe when a tls server emits 'close' (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`a086566be6`](https://github.com/nodejs/node/commit/a086566be6)] - **doc**: fix an SNI mistyped as SNS (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`4ddc23828d`](https://github.com/nodejs/node/commit/4ddc23828d)] - **doc**: move TSC and CTC meeting minutes out of core repo (James M Snell) [#9503](https://github.com/nodejs/node/pull/9503)
* [[`474d4aa2e3`](https://github.com/nodejs/node/commit/474d4aa2e3)] - **doc**: fix typo in doc/repl.md line: 6 (Mitsuo Utano) [#9582](https://github.com/nodejs/node/pull/9582)
* [[`7af680e6fe`](https://github.com/nodejs/node/commit/7af680e6fe)] - **doc**: make comment indentation consistent (Daniel Bevenius) [#9518](https://github.com/nodejs/node/pull/9518)
* [[`d964eacd6a`](https://github.com/nodejs/node/commit/d964eacd6a)] - **doc**: remove redundant warning information (Brian White) [#9590](https://github.com/nodejs/node/pull/9590)
* [[`25a6f88d98`](https://github.com/nodejs/node/commit/25a6f88d98)] - **doc**: improve process.emitWarning() example (Brian White) [#9590](https://github.com/nodejs/node/pull/9590)
* [[`d5fa1d5307`](https://github.com/nodejs/node/commit/d5fa1d5307)] - **doc**: clarify eventType in fs.watch (Nikolai Vavilov) [#9318](https://github.com/nodejs/node/pull/9318)
* [[`3014dfd254`](https://github.com/nodejs/node/commit/3014dfd254)] - **doc**: wrap long lines in http.request (Timothy Gu) [#9584](https://github.com/nodejs/node/pull/9584)
* [[`89216a45b7`](https://github.com/nodejs/node/commit/89216a45b7)] - **doc**: fix type of http.request's `agent` option (Timothy Gu) [#9584](https://github.com/nodejs/node/pull/9584)
* [[`bff4e88f0b`](https://github.com/nodejs/node/commit/bff4e88f0b)] - **doc**: fix a typo in the assert.md (Vse Mozhet Byt) [#9598](https://github.com/nodejs/node/pull/9598)
* [[`d83cb48b3a`](https://github.com/nodejs/node/commit/d83cb48b3a)] - **doc**: fix typo e.g., => e.g. (Daijiro Yamada) [#9563](https://github.com/nodejs/node/pull/9563)
* [[`d532a57a4b`](https://github.com/nodejs/node/commit/d532a57a4b)] - **doc**: consistent 'Returns:' (Roman Reiss) [#9554](https://github.com/nodejs/node/pull/9554)
* [[`92bd19e0bd`](https://github.com/nodejs/node/commit/92bd19e0bd)] - **doc**: simplify process.memoryUsage() example code (Thomas Watson Steen) [#9560](https://github.com/nodejs/node/pull/9560)
* [[`4ae4e00ae9`](https://github.com/nodejs/node/commit/4ae4e00ae9)] - **doc**: fix typo about cluster doc, (eg. -> e.g.) (YutamaKotaro) [#9568](https://github.com/nodejs/node/pull/9568)
* [[`64dec14502`](https://github.com/nodejs/node/commit/64dec14502)] - **doc**: fix e.g., to e.g. in doc/http.md (ikasumi_wt) [#9564](https://github.com/nodejs/node/pull/9564)
* [[`7c9e8cbd76`](https://github.com/nodejs/node/commit/7c9e8cbd76)] - **doc**: fix the index order in pseudocode of modules (kohta ito) [#9562](https://github.com/nodejs/node/pull/9562)
* [[`d09a9f4d27`](https://github.com/nodejs/node/commit/d09a9f4d27)] - **doc**: remove Roadmap Working Group (William Kapke) [#9545](https://github.com/nodejs/node/pull/9545)
* [[`77aded3ba1`](https://github.com/nodejs/node/commit/77aded3ba1)] - **doc**: add process api data types to documentation (imatvieiev) [#9505](https://github.com/nodejs/node/pull/9505)
* [[`7488b0041f`](https://github.com/nodejs/node/commit/7488b0041f)] - **doc**: added types to path docs (imatvieiev) [#9514](https://github.com/nodejs/node/pull/9514)
* [[`549b6f23db`](https://github.com/nodejs/node/commit/549b6f23db)] - **doc**: fix fs constants link (Timothy) [#9508](https://github.com/nodejs/node/pull/9508)
* [[`31a34d7992`](https://github.com/nodejs/node/commit/31a34d7992)] - **doc**: fix minor style issue in code examples (Daniel Bevenius) [#9482](https://github.com/nodejs/node/pull/9482)
* [[`a412b9fa9a`](https://github.com/nodejs/node/commit/a412b9fa9a)] - **doc**: grammar and structure revisions of wg doc (Ryan Lewis) [#9495](https://github.com/nodejs/node/pull/9495)
* [[`92f163e465`](https://github.com/nodejs/node/commit/92f163e465)] - **doc**: clarify the exit code part of writing_tests (Jeremiah Senkpiel) [#9502](https://github.com/nodejs/node/pull/9502)
* [[`62478eb3d9`](https://github.com/nodejs/node/commit/62478eb3d9)] - **doc**: fix link to Event Loop page (timathon) [#9527](https://github.com/nodejs/node/pull/9527)
* [[`c07f648662`](https://github.com/nodejs/node/commit/c07f648662)] - **doc**: Fix inaccuracy in https.request docs (Andreas Lind) [#9453](https://github.com/nodejs/node/pull/9453)
* [[`6f513e0b46`](https://github.com/nodejs/node/commit/6f513e0b46)] - **doc**: add npm link to README (Oscar Morrison) [#7894](https://github.com/nodejs/node/pull/7894)
* [[`f0d40e8be3`](https://github.com/nodejs/node/commit/f0d40e8be3)] - **doc**: fix link to cli.md in vm.md (Daniel Bevenius) [#9481](https://github.com/nodejs/node/pull/9481)
* [[`8a9c45a4a9`](https://github.com/nodejs/node/commit/8a9c45a4a9)] - **fs**: Fix default params for fs.write(Sync) (Andreas Lind) [#7856](https://github.com/nodejs/node/pull/7856)
* [[`9a0bcfc452`](https://github.com/nodejs/node/commit/9a0bcfc452)] - **fs**: export `realpathCacheKey` from `internal/fs` (Anna Henningsen) [#8862](https://github.com/nodejs/node/pull/8862)
* [[`6b01bfa9d6`](https://github.com/nodejs/node/commit/6b01bfa9d6)] - **gitignore**: ignore all tap files (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`23584e4ec5`](https://github.com/nodejs/node/commit/23584e4ec5)] - **gtest**: output tap comments as yamlish (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`f5442ece33`](https://github.com/nodejs/node/commit/f5442ece33)] - **lib,test**: remove unneeded escaping of / (Rich Trott) [#9485](https://github.com/nodejs/node/pull/9485)
* [[`34c8b0b411`](https://github.com/nodejs/node/commit/34c8b0b411)] - **module**: check -e flag in debug break setup (Kelvin Jin) [#8876](https://github.com/nodejs/node/pull/8876)
* [[`163397a206`](https://github.com/nodejs/node/commit/163397a206)] - **(SEMVER-MINOR)** **process**: add `process.memoryUsage.external` (Fedor Indutny) [#9587](https://github.com/nodejs/node/pull/9587)
* [[`15af912ab5`](https://github.com/nodejs/node/commit/15af912ab5)] - **src**: fix memory leak introduced in 34febfbf4 (Ben Noordhuis) [#9604](https://github.com/nodejs/node/pull/9604)
* [[`30475beef6`](https://github.com/nodejs/node/commit/30475beef6)] - **src**: use ABORT() macro instead of abort() (Evan Lucas) [#9613](https://github.com/nodejs/node/pull/9613)
* [[`c4f33b48f7`](https://github.com/nodejs/node/commit/c4f33b48f7)] - **(SEMVER-MINOR)** **src**: extend `HeapStatistics` with new fields (Gareth Ellis) [#8610](https://github.com/nodejs/node/pull/8610)
* [[`4517276c74`](https://github.com/nodejs/node/commit/4517276c74)] - **src**: fix method name, output format (Josh Gavant) [#9627](https://github.com/nodejs/node/pull/9627)
* [[`7420ce8b7e`](https://github.com/nodejs/node/commit/7420ce8b7e)] - **src**: squelch unused function warnings in util.h (solebox) [#9115](https://github.com/nodejs/node/pull/9115)
* [[`a83a286631`](https://github.com/nodejs/node/commit/a83a286631)] - **test**: add test for broken child process stdio (cjihrig) [#9528](https://github.com/nodejs/node/pull/9528)
* [[`7c1a2f56fc`](https://github.com/nodejs/node/commit/7c1a2f56fc)] - **test**: add new.target add-on regression test (Ben Noordhuis) [#9689](https://github.com/nodejs/node/pull/9689)
* [[`a220170861`](https://github.com/nodejs/node/commit/a220170861)] - **test**: refactor test-async-wrap-* (Rich Trott) [#9663](https://github.com/nodejs/node/pull/9663)
* [[`6c63ab7c9a`](https://github.com/nodejs/node/commit/6c63ab7c9a)] - **test**: simplify test-http-client-unescaped-path (Rod Vagg) [#9649](https://github.com/nodejs/node/pull/9649)
* [[`731a1fa602`](https://github.com/nodejs/node/commit/731a1fa602)] - **test**: Use strictEqual in test-tls-writewrap-leak (Aaron Petcoff) [#9666](https://github.com/nodejs/node/pull/9666)
* [[`a29be5282e`](https://github.com/nodejs/node/commit/a29be5282e)] - **test**: fix memory leaks in malloc cctests (Ben Noordhuis) [#9667](https://github.com/nodejs/node/pull/9667)
* [[`776d291a07`](https://github.com/nodejs/node/commit/776d291a07)] - **test**: run tests even if os.cpus() fails (Bethany Griggs) [#9616](https://github.com/nodejs/node/pull/9616)
* [[`51e24e770a`](https://github.com/nodejs/node/commit/51e24e770a)] - **test**: use setImmediate() in test of stream2 (masashi.g) [#9583](https://github.com/nodejs/node/pull/9583)
* [[`875d1b93fc`](https://github.com/nodejs/node/commit/875d1b93fc)] - **test**: add test case of PassThrough (Yoshiya Hinosawa) [#9581](https://github.com/nodejs/node/pull/9581)
* [[`3b4ec5f6c5`](https://github.com/nodejs/node/commit/3b4ec5f6c5)] - **test**: check that `process.execPath` is a realpath (Anna Henningsen) [#9229](https://github.com/nodejs/node/pull/9229)
* [[`ccc6e75bea`](https://github.com/nodejs/node/commit/ccc6e75bea)] - **test**: ensure nextTick is not scheduled in exit (Jeremiah Senkpiel) [#9555](https://github.com/nodejs/node/pull/9555)
* [[`00a5490ecd`](https://github.com/nodejs/node/commit/00a5490ecd)] - **test**: increase coverage of process.emitWarning (Jeremiah Senkpiel) [#9556](https://github.com/nodejs/node/pull/9556)
* [[`f3db5e4720`](https://github.com/nodejs/node/commit/f3db5e4720)] - **test**: refactor test-zlib.js (Rich Trott) [#9544](https://github.com/nodejs/node/pull/9544)
* [[`58fc7a137c`](https://github.com/nodejs/node/commit/58fc7a137c)] - **test**: change from setTimeout to setImmediate (MURAKAMI Masahiko) [#9578](https://github.com/nodejs/node/pull/9578)
* [[`e7eb9ccdcf`](https://github.com/nodejs/node/commit/e7eb9ccdcf)] - **test**: improve test-stream2-objects.js (Yoshiya Hinosawa) [#9565](https://github.com/nodejs/node/pull/9565)
* [[`dae3d3e53c`](https://github.com/nodejs/node/commit/dae3d3e53c)] - **test**: refactor test-next-tick-error-spin (Rich Trott) [#9537](https://github.com/nodejs/node/pull/9537)
* [[`8c859d58ab`](https://github.com/nodejs/node/commit/8c859d58ab)] - **test**: refactor test-tls-inception (Rich Trott) [#9536](https://github.com/nodejs/node/pull/9536)
* [[`96471556b5`](https://github.com/nodejs/node/commit/96471556b5)] - **test**: move tick-processor tests to own directory (Rich Trott) [#9506](https://github.com/nodejs/node/pull/9506)
* [[`342d8e05cb`](https://github.com/nodejs/node/commit/342d8e05cb)] - **test**: refactor inspector-helper.js (Rich Trott) [#9499](https://github.com/nodejs/node/pull/9499)
* [[`dab3e451ac`](https://github.com/nodejs/node/commit/dab3e451ac)] - **test**: refactor make-callback-recurse test (Rich Trott) [#9498](https://github.com/nodejs/node/pull/9498)
* [[`2a9625656d`](https://github.com/nodejs/node/commit/2a9625656d)] - **test**: move timer-dependent test to sequential (Rich Trott) [#9487](https://github.com/nodejs/node/pull/9487)
* [[`ee7606940a`](https://github.com/nodejs/node/commit/ee7606940a)] - **test**: fix helper-debugger-repl.js (Rich Trott) [#9486](https://github.com/nodejs/node/pull/9486)
* [[`9491352b86`](https://github.com/nodejs/node/commit/9491352b86)] - **test**: remove watchdog in test-debug-signal-cluster (Rich Trott) [#9476](https://github.com/nodejs/node/pull/9476)
* [[`6a94ffb1cf`](https://github.com/nodejs/node/commit/6a94ffb1cf)] - **test**: output tap13 instead of almost-tap (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`02c2bf7d34`](https://github.com/nodejs/node/commit/02c2bf7d34)] - **timers**: use consistent checks for canceled timers (Jeremiah Senkpiel) [#9685](https://github.com/nodejs/node/pull/9685)
* [[`ee65b4872d`](https://github.com/nodejs/node/commit/ee65b4872d)] - **tls**: fix leak of WriteWrap+TLSWrap combination (Fedor Indutny) [#9586](https://github.com/nodejs/node/pull/9586)
* [[`19ca6cddcf`](https://github.com/nodejs/node/commit/19ca6cddcf)] - **tools**: disallow trailing whitespace for markdown (Sam Roberts) [#9676](https://github.com/nodejs/node/pull/9676)
* [[`29bf871977`](https://github.com/nodejs/node/commit/29bf871977)] - **tools**: use better regexp for manpage references (Anna Henningsen) [#9632](https://github.com/nodejs/node/pull/9632)
* [[`cc6901d482`](https://github.com/nodejs/node/commit/cc6901d482)] - **tools**: improve docopen target in Makefile (Sakthipriyan Vairamani (thefourtheye)) [#9436](https://github.com/nodejs/node/pull/9436)
* [[`deabb5cfaa`](https://github.com/nodejs/node/commit/deabb5cfaa)] - **tools**: make run-valgrind.py useful (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`887c76a664`](https://github.com/nodejs/node/commit/887c76a664)] - **tools**: fix run-valgrind.py script (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`65b60801ce`](https://github.com/nodejs/node/commit/65b60801ce)] - **tools**: copy run-valgrind.py to tools/ (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`45df0ee717`](https://github.com/nodejs/node/commit/45df0ee717)] - **v8**: update make-v8.sh to use git (Jaideep Bajwa) [#9393](https://github.com/nodejs/node/pull/9393)
* [[`adcc5b15f7`](https://github.com/nodejs/node/commit/adcc5b15f7)] - **zlib**: fix linting recently-introduced lint error (Rich Trott) [#9524](https://github.com/nodejs/node/pull/9524)
* [[`841a2c41d4`](https://github.com/nodejs/node/commit/841a2c41d4)] - **zlib**: name every function Ref: #8913 (solebox) [#9389](https://github.com/nodejs/node/pull/9389)

<a id="7.1.0"></a>
## 2016-11-08, Version 7.1.0 (Current), @evanlucas

### Notable changes

* **buffer**: add buffer.transcode to transcode a buffer's content from one encoding to another primarily using ICU (James M Snell) [#9038](https://github.com/nodejs/node/pull/9038)
* **child_process**: add public API for IPC channel (cjihrig) [#9322](https://github.com/nodejs/node/pull/9322)
* **icu**:
  * Upgraded to ICU 58 - small icu (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
  * Add `cldr`, `tz`, and `unicode` to `process.versions` (Steven R. Loomis) [#9266](https://github.com/nodejs/node/pull/9266)
* **lib**: make `String(global) === '\[object global\]'` (Anna Henningsen) [#9279](https://github.com/nodejs/node/pull/9279)
* **libuv**: Upgraded to 1.10.0 (cjihrig) [#9267](https://github.com/nodejs/node/pull/9267)
* **readline**: use icu based string width calculation (James M Snell) [#9040](https://github.com/nodejs/node/pull/9040)
* **src**:
  * add NODE_PRESERVE_SYMLINKS environment variable that has the same effect as the `--preserve-symlinks` flag (Marc Udoff) [#8749](https://github.com/nodejs/node/pull/8749)
  * Fix `String#toLocaleUpperCase()` and `String#toLocaleLowerCase()` (Steven R. Loomis)

### Commits

* [[`dafdb7b069`](https://github.com/nodejs/node/commit/dafdb7b069)] - **benchmark**: add trailing newline for consistency (Roman Reiss) [#9410](https://github.com/nodejs/node/pull/9410)
* [[`fab8eb660f`](https://github.com/nodejs/node/commit/fab8eb660f)] - **benchmark**: add microbenchmarks for ES Map (Rod Vagg) [#7581](https://github.com/nodejs/node/pull/7581)
* [[`44792f83bf`](https://github.com/nodejs/node/commit/44792f83bf)] - **benchmark,lib,test,tools**: remove unneeded . escape (Rich Trott) [#9449](https://github.com/nodejs/node/pull/9449)
* [[`c70c96a3e2`](https://github.com/nodejs/node/commit/c70c96a3e2)] - **buffer**: coerce offset using Math.trunc() (cjihrig) [#9341](https://github.com/nodejs/node/pull/9341)
* [[`212da12f45`](https://github.com/nodejs/node/commit/212da12f45)] - **buffer**: use correct name for custom inspect symbol (Charmander) [#9289](https://github.com/nodejs/node/pull/9289)
* [[`0939edd4ed`](https://github.com/nodejs/node/commit/0939edd4ed)] - **(SEMVER-MINOR)** **buffer**: add buffer.transcode (James M Snell) [#9038](https://github.com/nodejs/node/pull/9038)
* [[`ceec520aef`](https://github.com/nodejs/node/commit/ceec520aef)] - **build**: add MAKEFLAGS="-j1" to node-gyp (Daniel Bevenius) [#9450](https://github.com/nodejs/node/pull/9450)
* [[`1109d0b244`](https://github.com/nodejs/node/commit/1109d0b244)] - **build**: reduce noise from doc target (Daniel Bevenius) [#9457](https://github.com/nodejs/node/pull/9457)
* [[`90aac7ca28`](https://github.com/nodejs/node/commit/90aac7ca28)] - **build**: start comments at beginning of line (Sakthipriyan Vairamani (thefourtheye)) [#9375](https://github.com/nodejs/node/pull/9375)
* [[`b51db7120e`](https://github.com/nodejs/node/commit/b51db7120e)] - **build**: make node-gyp output silent (Sakthipriyan Vairamani (thefourtheye)) [#8990](https://github.com/nodejs/node/pull/8990)
* [[`d8eaa14c2d`](https://github.com/nodejs/node/commit/d8eaa14c2d)] - **build**: prioritise --shared-X-Y over pkg-config (Rod Vagg) [#9368](https://github.com/nodejs/node/pull/9368)
* [[`f7d8481ee2`](https://github.com/nodejs/node/commit/f7d8481ee2)] - **build**: use wxneeded on openbsd (Aaron Bieber) [#9232](https://github.com/nodejs/node/pull/9232)
* [[`7b0e93738b`](https://github.com/nodejs/node/commit/7b0e93738b)] - **(SEMVER-MINOR)** **child_process**: add public API for IPC channel (cjihrig) [#9322](https://github.com/nodejs/node/pull/9322)
* [[`4e3731c7e7`](https://github.com/nodejs/node/commit/4e3731c7e7)] - **child_process**: remove unreachable code (cjihrig) [#9307](https://github.com/nodejs/node/pull/9307)
* [[`d573acf96f`](https://github.com/nodejs/node/commit/d573acf96f)] - **child_process**: remove unreachable execSync() code (cjihrig) [#9209](https://github.com/nodejs/node/pull/9209)
* [[`f1f00df9bf`](https://github.com/nodejs/node/commit/f1f00df9bf)] - **deps**: upgrade npm to 3.10.9 (Kat Marchán) [#9286](https://github.com/nodejs/node/pull/9286)
* [[`3d1766f492`](https://github.com/nodejs/node/commit/3d1766f492)] - **(SEMVER-MINOR)** **deps**: Intl: ICU 58 bump - small icu (BIG COMMIT) (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
* [[`827000ee62`](https://github.com/nodejs/node/commit/827000ee62)] - **(SEMVER-MINOR)** **deps**: Intl: ICU 58 bump: configure/LICENSE/docs (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
* [[`0f871e1087`](https://github.com/nodejs/node/commit/0f871e1087)] - **deps**: back port OpenBSD fix in c-ares/c-ares (Aaron Bieber) [#9232](https://github.com/nodejs/node/pull/9232)
* [[`106d71914c`](https://github.com/nodejs/node/commit/106d71914c)] - **deps**: upgrade libuv to 1.10.0 (cjihrig) [#9267](https://github.com/nodejs/node/pull/9267)
* [[`4c4132e5d3`](https://github.com/nodejs/node/commit/4c4132e5d3)] - **doc**: update minute-taking procedure for CTC (Rich Trott) [#9425](https://github.com/nodejs/node/pull/9425)
* [[`ed8df17135`](https://github.com/nodejs/node/commit/ed8df17135)] - **doc**: note that tests should include a description (Gibson Fahnestock) [#9415](https://github.com/nodejs/node/pull/9415)
* [[`bc2d1c9d91`](https://github.com/nodejs/node/commit/bc2d1c9d91)] - **doc**: do not link in the headings (Sakthipriyan Vairamani (thefourtheye)) [#9416](https://github.com/nodejs/node/pull/9416)
* [[`4bb9d21d01`](https://github.com/nodejs/node/commit/4bb9d21d01)] - **doc**: update GOVERNANCE.md to use "meeting chair" (Rich Trott) [#9432](https://github.com/nodejs/node/pull/9432)
* [[`c2fab3c600`](https://github.com/nodejs/node/commit/c2fab3c600)] - **doc**: add Sakthipriyan to the CTC (Rod Vagg) [#9427](https://github.com/nodejs/node/pull/9427)
* [[`a8295d86d9`](https://github.com/nodejs/node/commit/a8295d86d9)] - **doc**: update Diagnostics WG info (Josh Gavant) [#9329](https://github.com/nodejs/node/pull/9329)
* [[`3af9453019`](https://github.com/nodejs/node/commit/3af9453019)] - **doc**: move stray sentences in zlib doc (Rich Trott) [#9365](https://github.com/nodejs/node/pull/9365)
* [[`d4b509584f`](https://github.com/nodejs/node/commit/d4b509584f)] - **doc**: use 'an' over 'a', remove redundant sentence (Zeke Sikelianos) [#9345](https://github.com/nodejs/node/pull/9345)
* [[`ff69e38070`](https://github.com/nodejs/node/commit/ff69e38070)] - **doc**: add more internal links to fs.Stats object (Zeke Sikelianos) [#9345](https://github.com/nodejs/node/pull/9345)
* [[`c554f090df`](https://github.com/nodejs/node/commit/c554f090df)] - **doc**: fix outdate ninja link (Yangyang Liu) [#9278](https://github.com/nodejs/node/pull/9278)
* [[`3d4a829d85`](https://github.com/nodejs/node/commit/3d4a829d85)] - **doc**: fix broken links to Buffer.from(string) (Jesse McCarthy) [#9294](https://github.com/nodejs/node/pull/9294)
* [[`225a9dfb00`](https://github.com/nodejs/node/commit/225a9dfb00)] - **doc**: fs: fix link to mkdtemp (coderaiser) [#9379](https://github.com/nodejs/node/pull/9379)
* [[`dbeadd363c`](https://github.com/nodejs/node/commit/dbeadd363c)] - **doc**: update OpenSSL links (kobelb) [#9338](https://github.com/nodejs/node/pull/9338)
* [[`eeabab3827`](https://github.com/nodejs/node/commit/eeabab3827)] - **doc**: add 2016-10-26 CTC meeting minutes (Rich Trott) [#9348](https://github.com/nodejs/node/pull/9348)
* [[`31690a690c`](https://github.com/nodejs/node/commit/31690a690c)] - **doc**: add 2016-10-05 CTC meeting minutes (Josh Gavant) [#9326](https://github.com/nodejs/node/pull/9326)
* [[`7f1a40dbcf`](https://github.com/nodejs/node/commit/7f1a40dbcf)] - **doc**: add 2016-09-28 CTC meeting minutes (Josh Gavant) [#9325](https://github.com/nodejs/node/pull/9325)
* [[`edd89265ba`](https://github.com/nodejs/node/commit/edd89265ba)] - **doc**: update CONTRIBUTING.md to address editing PRs (Gibson Fahnestock) [#9259](https://github.com/nodejs/node/pull/9259)
* [[`c7458909a7`](https://github.com/nodejs/node/commit/c7458909a7)] - **doc**: reference signal(7) for the list of signals (Emanuele DelBono) [#9323](https://github.com/nodejs/node/pull/9323)
* [[`a3f6854724`](https://github.com/nodejs/node/commit/a3f6854724)] - **doc**: more realistic custom inspect example (Ryan Scheel (Havvy)) [#8875](https://github.com/nodejs/node/pull/8875)
* [[`a0074e2232`](https://github.com/nodejs/node/commit/a0074e2232)] - **doc**: clarify buffer toString docs. (Olan Byrne) [#8984](https://github.com/nodejs/node/pull/8984)
* [[`3f90481e20`](https://github.com/nodejs/node/commit/3f90481e20)] - **doc**: clarify relation between a file and a module (marzelin) [#9026](https://github.com/nodejs/node/pull/9026)
* [[`82119049ef`](https://github.com/nodejs/node/commit/82119049ef)] - **doc**: fix typo in http.md (anu0012) [#9144](https://github.com/nodejs/node/pull/9144)
* [[`d2e7882723`](https://github.com/nodejs/node/commit/d2e7882723)] - **doc**: add 2016-10-19 CTC meeting minutes (Josh Gavant) [#9193](https://github.com/nodejs/node/pull/9193)
* [[`ce00a9d2b6`](https://github.com/nodejs/node/commit/ce00a9d2b6)] - **doc**: add performance warning to require.extensions (Ben Noordhuis) [#9196](https://github.com/nodejs/node/pull/9196)
* [[`d1c32aa335`](https://github.com/nodejs/node/commit/d1c32aa335)] - **doc**: mention case-insensitive env on windows (Oliver Salzburg) [#9166](https://github.com/nodejs/node/pull/9166)
* [[`c6e429a6bc`](https://github.com/nodejs/node/commit/c6e429a6bc)] - **doc**: add CTC meeting minutes for 2016-10-12 (Michael Dawson) [#9070](https://github.com/nodejs/node/pull/9070)
* [[`355041960d`](https://github.com/nodejs/node/commit/355041960d)] - **events**: remove unnecessary checks (cjihrig) [#9330](https://github.com/nodejs/node/pull/9330)
* [[`0ce0abf6cb`](https://github.com/nodejs/node/commit/0ce0abf6cb)] - **events,test**: fix TypeError in EventEmitter warning (jseagull) [#9021](https://github.com/nodejs/node/pull/9021)
* [[`6f35e4421a`](https://github.com/nodejs/node/commit/6f35e4421a)] - **http**: add debug message for invalid header value (Evan Lucas) [#9195](https://github.com/nodejs/node/pull/9195)
* [[`173b088e1a`](https://github.com/nodejs/node/commit/173b088e1a)] - **inspector**: do not prompt to use localhost (Eugene Ostroukhov) [#9451](https://github.com/nodejs/node/pull/9451)
* [[`939d1023c2`](https://github.com/nodejs/node/commit/939d1023c2)] - **inspector**: switch to new inspector APIs (Eugene Ostroukhov) [#9028](https://github.com/nodejs/node/pull/9028)
* [[`2e7b078e7b`](https://github.com/nodejs/node/commit/2e7b078e7b)] - **inspector**: fix request path nullptr dereference (Ben Noordhuis) [#9184](https://github.com/nodejs/node/pull/9184)
* [[`9940666c1b`](https://github.com/nodejs/node/commit/9940666c1b)] - **(SEMVER-MINOR)** **intl**: Add more versions from ICU (Steven R. Loomis) [#9266](https://github.com/nodejs/node/pull/9266)
* [[`5bfefa6063`](https://github.com/nodejs/node/commit/5bfefa6063)] - **lib**: change == to === in linkedlist (jedireza) [#9362](https://github.com/nodejs/node/pull/9362)
* [[`d24bd20d2b`](https://github.com/nodejs/node/commit/d24bd20d2b)] - **lib**: make `String(global) === '\[object global\]'` (Anna Henningsen) [#9279](https://github.com/nodejs/node/pull/9279)
* [[`9372aee4a3`](https://github.com/nodejs/node/commit/9372aee4a3)] - **lib**: fix beforeExit not working with -e (Ben Noordhuis) [#8821](https://github.com/nodejs/node/pull/8821)
* [[`c231130e06`](https://github.com/nodejs/node/commit/c231130e06)] - **module**: skip directories known not to exist (Ben Noordhuis) [#9196](https://github.com/nodejs/node/pull/9196)
* [[`d09eb9c6b2`](https://github.com/nodejs/node/commit/d09eb9c6b2)] - **net**: name anonymous functions (Pedro Victor) [#9357](https://github.com/nodejs/node/pull/9357)
* [[`a5c62cb4f2`](https://github.com/nodejs/node/commit/a5c62cb4f2)] - **(SEMVER-MINOR)** **readline**: use icu based string width calculation (James M Snell) [#9040](https://github.com/nodejs/node/pull/9040)
* [[`60461d2d90`](https://github.com/nodejs/node/commit/60461d2d90)] - **repl**: refactor lib/repl.js (Rich Trott) [#9374](https://github.com/nodejs/node/pull/9374)
* [[`071836aa42`](https://github.com/nodejs/node/commit/071836aa42)] - **repl**: name anonymous functions (Pedro Victor) [#9356](https://github.com/nodejs/node/pull/9356)
* [[`0b9d80a037`](https://github.com/nodejs/node/commit/0b9d80a037)] - **repl**: don’t write to input stream in editor mode (Anna Henningsen) [#9207](https://github.com/nodejs/node/pull/9207)
* [[`1c59cefc44`](https://github.com/nodejs/node/commit/1c59cefc44)] - **repl**: make `key` of `repl.write()` optional always (Anna Henningsen) [#9207](https://github.com/nodejs/node/pull/9207)
* [[`b1ef638de3`](https://github.com/nodejs/node/commit/b1ef638de3)] - **(SEMVER-MINOR)** **src**: default --icu_case_mapping on as a v8 option (Steven R. Loomis) [#9454](https://github.com/nodejs/node/pull/9454)
* [[`0c236d1d36`](https://github.com/nodejs/node/commit/0c236d1d36)] - **src**: replace SetNamedPropertyHandler() (AnnaMag) [#9062](https://github.com/nodejs/node/pull/9062)
* [[`5ab172ee8f`](https://github.com/nodejs/node/commit/5ab172ee8f)] - **src**: fix use of uninitialized variable (James M Snell) [#9281](https://github.com/nodejs/node/pull/9281)
* [[`57c0a9b5dc`](https://github.com/nodejs/node/commit/57c0a9b5dc)] - **src**: remove unused function (Brian White) [#9243](https://github.com/nodejs/node/pull/9243)
* [[`08e12c7809`](https://github.com/nodejs/node/commit/08e12c7809)] - **src**: remove superfluous env_string string (Ben Noordhuis) [#9213](https://github.com/nodejs/node/pull/9213)
* [[`c342bda49e`](https://github.com/nodejs/node/commit/c342bda49e)] - **src**: make cross-context MakeCallback() calls work (Ben Noordhuis) [#9221](https://github.com/nodejs/node/pull/9221)
* [[`60a5b515b8`](https://github.com/nodejs/node/commit/60a5b515b8)] - **(SEMVER-MINOR)** **src**: add NODE_PRESERVE_SYMLINKS environment variable (Marc Udoff) [#8749](https://github.com/nodejs/node/pull/8749)
* [[`f2a3b24611`](https://github.com/nodejs/node/commit/f2a3b24611)] - **src**: clean up program/isolate/env init logic (Ben Noordhuis) [#9224](https://github.com/nodejs/node/pull/9224)
* [[`9e753ba782`](https://github.com/nodejs/node/commit/9e753ba782)] - **src**: simplify code, remove NodeInstanceData (Ben Noordhuis) [#9224](https://github.com/nodejs/node/pull/9224)
* [[`8b53f3c41c`](https://github.com/nodejs/node/commit/8b53f3c41c)] - **src**: speed up module loading, don't resize buffer (Ben Noordhuis) [#9132](https://github.com/nodejs/node/pull/9132)
* [[`362c307f38`](https://github.com/nodejs/node/commit/362c307f38)] - **src**: speed up module loading, skip EOF read (Ben Noordhuis) [#9132](https://github.com/nodejs/node/pull/9132)
* [[`85a9295813`](https://github.com/nodejs/node/commit/85a9295813)] - **src,tools**: speed up startup by 2.5% (Ben Noordhuis) [#5458](https://github.com/nodejs/node/pull/5458)
* [[`6e1eb59fee`](https://github.com/nodejs/node/commit/6e1eb59fee)] - **test**: improve test-debugger-util-regression (Santiago Gimeno) [#9490](https://github.com/nodejs/node/pull/9490)
* [[`6eb6816e22`](https://github.com/nodejs/node/commit/6eb6816e22)] - **test**: fix flaky test-net-GH-5504 (Santiago Gimeno) [#9461](https://github.com/nodejs/node/pull/9461)
* [[`f640bafc58`](https://github.com/nodejs/node/commit/f640bafc58)] - **test**: fix flaky test-force-repl-with-eval (Santiago Gimeno) [#9460](https://github.com/nodejs/node/pull/9460)
* [[`675a4b20b6`](https://github.com/nodejs/node/commit/675a4b20b6)] - **test**: update http-header-obstext (Gibson Fahnestock) [#9415](https://github.com/nodejs/node/pull/9415)
* [[`9d9ea8127e`](https://github.com/nodejs/node/commit/9d9ea8127e)] - **test**: move timer-dependent test to sequential (Rich Trott) [#9431](https://github.com/nodejs/node/pull/9431)
* [[`1c3487b5c3`](https://github.com/nodejs/node/commit/1c3487b5c3)] - **test**: remove timers from streams test (Anna Henningsen)
* [[`e696bc33eb`](https://github.com/nodejs/node/commit/e696bc33eb)] - **test**: increase test coverage for lib/zlib.js (Rich Trott) [#9366](https://github.com/nodejs/node/pull/9366)
* [[`ed3f80a988`](https://github.com/nodejs/node/commit/ed3f80a988)] - **test**: add test for HTTP client "aborted" event (Kyle E. Mitchell) [#7376](https://github.com/nodejs/node/pull/7376)
* [[`d12ed29f6a`](https://github.com/nodejs/node/commit/d12ed29f6a)] - **test**: remove timer in test-dgram-send-empty-array (Rich Trott) [#9361](https://github.com/nodejs/node/pull/9361)
* [[`e451022dd9`](https://github.com/nodejs/node/commit/e451022dd9)] - **test**: refactor test-http-client-readable (Rich Trott) [#9344](https://github.com/nodejs/node/pull/9344)
* [[`01b626a45a`](https://github.com/nodejs/node/commit/01b626a45a)] - **test**: clean up dgram-broadcast-multi-process test (Isobel Redelmeier) [#9308](https://github.com/nodejs/node/pull/9308)
* [[`411b1339bc`](https://github.com/nodejs/node/commit/411b1339bc)] - **test**: fix freebsd10-64 CI failures (Rich Trott) [#9317](https://github.com/nodejs/node/pull/9317)
* [[`1037463604`](https://github.com/nodejs/node/commit/1037463604)] - **test**: add child_process customFds test (cjihrig) [#9307](https://github.com/nodejs/node/pull/9307)
* [[`bd9cb40977`](https://github.com/nodejs/node/commit/bd9cb40977)] - **test**: run all of test-timers-blocking-callback (Rich Trott) [#9305](https://github.com/nodejs/node/pull/9305)
* [[`8b7ce8bd11`](https://github.com/nodejs/node/commit/8b7ce8bd11)] - **test**: fix flaky test-fs-watch-recursive on OS X (Rich Trott) [#9303](https://github.com/nodejs/node/pull/9303)
* [[`6c9e4fddf0`](https://github.com/nodejs/node/commit/6c9e4fddf0)] - **test**: refactor test-async-wrap-check-providers (Gerges Beshay) [#9297](https://github.com/nodejs/node/pull/9297)
* [[`0ab008e50d`](https://github.com/nodejs/node/commit/0ab008e50d)] - **test**: fix lint error regarding unused commons const (Daniel Bevenius) [#9334](https://github.com/nodejs/node/pull/9334)
* [[`c9b67c6a91`](https://github.com/nodejs/node/commit/c9b67c6a91)] - **test**: writable stream needDrain state (Italo A. Casas) [#8799](https://github.com/nodejs/node/pull/8799)
* [[`248a3200b2`](https://github.com/nodejs/node/commit/248a3200b2)] - **test**: writable stream ending state (Italo A. Casas) [#8707](https://github.com/nodejs/node/pull/8707)
* [[`d6f688ae0d`](https://github.com/nodejs/node/commit/d6f688ae0d)] - **test**: writable stream finished state (Italo A. Casas) [#8791](https://github.com/nodejs/node/pull/8791)
* [[`d49d990c42`](https://github.com/nodejs/node/commit/d49d990c42)] - **test**: prevent workers outliving parent (Sam Roberts) [#9257](https://github.com/nodejs/node/pull/9257)
* [[`2ad81ed0e6`](https://github.com/nodejs/node/commit/2ad81ed0e6)] - **test**: refactor /parallel/test-cluster-uncaught-exception.js to ES6 (Deverick) [#9239](https://github.com/nodejs/node/pull/9239)
* [[`f39eb05946`](https://github.com/nodejs/node/commit/f39eb05946)] - **test**: use strict assertions in module loader test (Ben Noordhuis) [#9263](https://github.com/nodejs/node/pull/9263)
* [[`fc9e6a37fa`](https://github.com/nodejs/node/commit/fc9e6a37fa)] - **test**: remove err timer from test-http-set-timeout (BethGriggs) [#9264](https://github.com/nodejs/node/pull/9264)
* [[`53520f06f3`](https://github.com/nodejs/node/commit/53520f06f3)] - **test**: clean up `test-child-process-exec-cwd.js` (Jeena Lee) [#9231](https://github.com/nodejs/node/pull/9231)
* [[`deef2f6079`](https://github.com/nodejs/node/commit/deef2f6079)] - **test**: add child_process.exec() timeout coverage (cjihrig) [#9208](https://github.com/nodejs/node/pull/9208)
* [[`5e138fe768`](https://github.com/nodejs/node/commit/5e138fe768)] - **test**: skip whatwg url parse and setter tests when icu is missing (James M Snell) [#9246](https://github.com/nodejs/node/pull/9246)
* [[`a39b98ef73`](https://github.com/nodejs/node/commit/a39b98ef73)] - **test**: add common.hasIntl (James M Snell) [#9246](https://github.com/nodejs/node/pull/9246)
* [[`efb62aa146`](https://github.com/nodejs/node/commit/efb62aa146)] - **test**: fix flaky test by removing timer (Evan Lucas) [#9199](https://github.com/nodejs/node/pull/9199)
* [[`44427cc1f7`](https://github.com/nodejs/node/commit/44427cc1f7)] - **test**: case sensitivity of env variables (Oliver Salzburg) [#9166](https://github.com/nodejs/node/pull/9166)
* [[`63ef0990f3`](https://github.com/nodejs/node/commit/63ef0990f3)] - **test**: add coverage for execFileSync() errors (cjihrig) [#9211](https://github.com/nodejs/node/pull/9211)
* [[`06b414078e`](https://github.com/nodejs/node/commit/06b414078e)] - **test**: remove test-v8-inspector-json-protocol test (Ben Noordhuis) [#9184](https://github.com/nodejs/node/pull/9184)
* [[`21ba3e3b89`](https://github.com/nodejs/node/commit/21ba3e3b89)] - **test**: add more module loader test coverage (Ben Noordhuis) [#9196](https://github.com/nodejs/node/pull/9196)
* [[`204461925b`](https://github.com/nodejs/node/commit/204461925b)] - **test**: make flaky pummel test more reliable (Ben Noordhuis) [#9241](https://github.com/nodejs/node/pull/9241)
* [[`4be1ba582a`](https://github.com/nodejs/node/commit/4be1ba582a)] - **test**: move flaky test to test/pummel (Ben Noordhuis) [#9241](https://github.com/nodejs/node/pull/9241)
* [[`032533954b`](https://github.com/nodejs/node/commit/032533954b)] - **tools**: use long format for gpg fingerprint (Myles Borins) [#9258](https://github.com/nodejs/node/pull/9258)
* [[`aac4af2b26`](https://github.com/nodejs/node/commit/aac4af2b26)] - **tools**: enable final newline in .editorconfig (Roman Reiss) [#9410](https://github.com/nodejs/node/pull/9410)
* [[`513da404cb`](https://github.com/nodejs/node/commit/513da404cb)] - **tools**: enforce function name matching in linter (Rich Trott) [#9408](https://github.com/nodejs/node/pull/9408)
* [[`c23ece7056`](https://github.com/nodejs/node/commit/c23ece7056)] - **tools**: remove dangling eslint symlink (Sam Roberts) [#9299](https://github.com/nodejs/node/pull/9299)
* [[`bdad1e28fd`](https://github.com/nodejs/node/commit/bdad1e28fd)] - **tools**: make --repeat work with -j in test.py (Rich Trott) [#9249](https://github.com/nodejs/node/pull/9249)
* [[`4f0596fb03`](https://github.com/nodejs/node/commit/4f0596fb03)] - **util**: use template strings (Alejandro Oviedo Garcia) [#9120](https://github.com/nodejs/node/pull/9120)
* [[`b083086ff2`](https://github.com/nodejs/node/commit/b083086ff2)] - **vm**: name anonymous functions (solebox) [#9388](https://github.com/nodejs/node/pull/9388)


<a id="7.0.0"></a>
## 2016-10-25, Version 7.0.0 (Current), @jasnell

### Notable changes

* Buffer
  * Passing invalid input to Buffer.byteLength will now throw an error [#8946](https://github.com/nodejs/node/pull/8946).
  * Calling Buffer without new is now deprecated and will emit a process warning [#8169](https://github.com/nodejs/node/pull/8169).
  * Passing a negative number to allocUnsafe will now throw an error [#7079](https://github.com/nodejs/node/pull/7079).
* Child Process
  * The fork and execFile methods now have stronger argument validation [#7399](https://github.com/nodejs/node/pull/7399).
* Cluster
  * The worker.suicide method is deprecated and will emit a process warning [#3747](https://github.com/nodejs/node/pull/3747).
* Deps
  * V8 has been updated to 5.4.500.36 [#8317](https://github.com/nodejs/node/pull/8317), [#8852](https://github.com/nodejs/node/pull/8852),
  [#9253](https://github.com/nodejs/node/pull/9253).
  * NODE_MODULE_VERSION has been updated to 51 [#8808](https://github.com/nodejs/node/pull/8808).
* File System
  * A process warning is emitted if a callback is not passed to async file system methods [#7897](https://github.com/nodejs/node/pull/7897).
* Intl
  * Intl.v8BreakIterator constructor has been deprecated and will emit a process warning [#8908](https://github.com/nodejs/node/pull/8908).
* Promises
  * Unhandled Promise rejections have been deprecated and will emit a process warning [#8217](https://github.com/nodejs/node/pull/8217).
* Punycode
  * The `punycode` module has been deprecated [#7941](https://github.com/nodejs/node/pull/7941).
* URL
  * An Experimental WHATWG URL Parser has been introduced [#7448](https://github.com/nodejs/node/pull/7448).

### Commits

* [[`1043f5d08e`](https://github.com/nodejs/node/commit/1043f5d08e)] - **assert**: name anonymous functions (Miguel Angel Asencio Hurtado) [#9051](https://github.com/nodejs/node/pull/9051)
* [[`06f37471aa`](https://github.com/nodejs/node/commit/06f37471aa)] - **benchmark**: use node v4 syntax in common.js (Andreas Madsen) [#9064](https://github.com/nodejs/node/pull/9064)
* [[`8b152fcf47`](https://github.com/nodejs/node/commit/8b152fcf47)] - **benchmark**: change the execution order (Andreas Madsen) [#9064](https://github.com/nodejs/node/pull/9064)
* [[`a5046bf8ef`](https://github.com/nodejs/node/commit/a5046bf8ef)] - **benchmark**: fixes csv parsing given no parameters (Andreas Madsen) [#9064](https://github.com/nodejs/node/pull/9064)
* [[`af01865d66`](https://github.com/nodejs/node/commit/af01865d66)] - **benchmark**: add info about required Unix tools (Bartosz Sosnowski) [#8788](https://github.com/nodejs/node/pull/8788)
* [[`dfb5f301cf`](https://github.com/nodejs/node/commit/dfb5f301cf)] - **benchmark**: make v8-bench.js output consistent (Bartosz Sosnowski) [#8564](https://github.com/nodejs/node/pull/8564)
* [[`84481f9157`](https://github.com/nodejs/node/commit/84481f9157)] - **benchmark**: add --expose_internals switch (Bartosz Sosnowski) [#8547](https://github.com/nodejs/node/pull/8547)
* [[`d3834a1fa3`](https://github.com/nodejs/node/commit/d3834a1fa3)] - **benchmark**: ignore significance when using --runs 1 (Andreas Madsen) [#8299](https://github.com/nodejs/node/pull/8299)
* [[`b1bbc68fb1`](https://github.com/nodejs/node/commit/b1bbc68fb1)] - **benchmark**: support for multiple http benchmarkers (Bartosz Sosnowski) [#8140](https://github.com/nodejs/node/pull/8140)
* [[`474e629ddb`](https://github.com/nodejs/node/commit/474e629ddb)] - **benchmark**: add --format csv option (Adrian Nitu) [#7961](https://github.com/nodejs/node/pull/7961)
* [[`4b527a4129`](https://github.com/nodejs/node/commit/4b527a4129)] - **benchmark**: update compare.js exit method (Adrian Nitu) [#7961](https://github.com/nodejs/node/pull/7961)
* [[`9e7fd8e810`](https://github.com/nodejs/node/commit/9e7fd8e810)] - **benchmark**: fix comment typos and code format (Adrian Nitu) [#7961](https://github.com/nodejs/node/pull/7961)
* [[`d525e6c92a`](https://github.com/nodejs/node/commit/d525e6c92a)] - **(SEMVER-MAJOR)** **benchmark**: remove broken string-creation.js (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`6edef1deb9`](https://github.com/nodejs/node/commit/6edef1deb9)] - **(SEMVER-MAJOR)** **benchmark**: update docs after refactor (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`0c0f34e2fe`](https://github.com/nodejs/node/commit/0c0f34e2fe)] - **(SEMVER-MAJOR)** **benchmark**: add script for creating scatter plot (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`855009af7f`](https://github.com/nodejs/node/commit/855009af7f)] - **(SEMVER-MAJOR)** **benchmark**: use t-test for comparing node versions (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`8bb59fdb12`](https://github.com/nodejs/node/commit/8bb59fdb12)] - **(SEMVER-MAJOR)** **benchmark**: missing process.exit after bench.end (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`f99471b2ae`](https://github.com/nodejs/node/commit/f99471b2ae)] - **(SEMVER-MAJOR)** **benchmark**: refactor to use process.send (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`0f9bfaa7c5`](https://github.com/nodejs/node/commit/0f9bfaa7c5)] - **(SEMVER-MAJOR)** **benchmark**: move cli parts of common.js into run.js (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`edbed3f3fd`](https://github.com/nodejs/node/commit/edbed3f3fd)] - **(SEMVER-MAJOR)** **benchmark**: move http_simple.js to http directory (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`ee2843b4ea`](https://github.com/nodejs/node/commit/ee2843b4ea)] - **(SEMVER-MAJOR)** **benchmark**: remove unused files (Andreas Madsen) [#7094](https://github.com/nodejs/node/pull/7094)
* [[`60042ca70e`](https://github.com/nodejs/node/commit/60042ca70e)] - **buffer**: fix range checks for slice() (Trevor Norris) [#9174](https://github.com/nodejs/node/pull/9174)
* [[`14d1a8a631`](https://github.com/nodejs/node/commit/14d1a8a631)] - **buffer**: coerce slice parameters consistently (Sakthipriyan Vairamani (thefourtheye)) [#9101](https://github.com/nodejs/node/pull/9101)
* [[`96b501d338`](https://github.com/nodejs/node/commit/96b501d338)] - **(SEMVER-MAJOR)** **buffer**: make byteLength throw on invalid input (Brian White) [#8946](https://github.com/nodejs/node/pull/8946)
* [[`c21458a15d`](https://github.com/nodejs/node/commit/c21458a15d)] - **(SEMVER-MINOR)** **buffer**: expose underlying buffer object always (Sakthipriyan Vairamani) [#8311](https://github.com/nodejs/node/pull/8311)
* [[`2c9a86f01e`](https://github.com/nodejs/node/commit/2c9a86f01e)] - **buffer**: directly use ArrayBuffer as the pool (Anna Henningsen) [#8302](https://github.com/nodejs/node/pull/8302)
* [[`f2fe5583c4`](https://github.com/nodejs/node/commit/f2fe5583c4)] - **(SEMVER-MAJOR)** **buffer**: runtime deprecation of calling Buffer without new (Nikolai Vavilov) [#8169](https://github.com/nodejs/node/pull/8169)
* [[`9cee8b1b62`](https://github.com/nodejs/node/commit/9cee8b1b62)] - **(SEMVER-MAJOR)** **buffer**: alias toLocaleString to toString (James M Snell) [#8148](https://github.com/nodejs/node/pull/8148)
* [[`8f90dcc1b8`](https://github.com/nodejs/node/commit/8f90dcc1b8)] - **(SEMVER-MAJOR)** **buffer**: throw on negative .allocUnsafe() argument (Anna Henningsen) [#7079](https://github.com/nodejs/node/pull/7079)
* [[`bd23290657`](https://github.com/nodejs/node/commit/bd23290657)] - **buffer**: remove obsolete and confusing comment (Nikolai Vavilov) [#7264](https://github.com/nodejs/node/pull/7264)
* [[`5292a1358f`](https://github.com/nodejs/node/commit/5292a1358f)] - **buffer**: improve creation performance. (Ingvar Stepanyan) [#6893](https://github.com/nodejs/node/pull/6893)
* [[`c5f5bcb331`](https://github.com/nodejs/node/commit/c5f5bcb331)] - **build**: fix config.gypi target (Daniel Bevenius) [#9053](https://github.com/nodejs/node/pull/9053)
* [[`b311906abf`](https://github.com/nodejs/node/commit/b311906abf)] - **(SEMVER-MAJOR)** **build**: do not clean V8 gtest directory (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`94f68b5b97`](https://github.com/nodejs/node/commit/94f68b5b97)] - **(SEMVER-MAJOR)** **build**: fix mkpeephole configuration (Ali Ijaz Sheikh) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`8481ea1ca4`](https://github.com/nodejs/node/commit/8481ea1ca4)] - **(SEMVER-MAJOR)** **build**: use libc++ on OSX (Ali Ijaz Sheikh) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`197d18795e`](https://github.com/nodejs/node/commit/197d18795e)] - **(SEMVER-MAJOR)** **build**: define icu_use_data_file_flag (Ali Ijaz Sheikh) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`eab418f7f9`](https://github.com/nodejs/node/commit/eab418f7f9)] - **(SEMVER-MAJOR)** **build**: update V8 gypfile paths (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`88e862ba82`](https://github.com/nodejs/node/commit/88e862ba82)] - **build**: windows sharedlib support (Stefan Budeanu) [#7487](https://github.com/nodejs/node/pull/7487)
* [[`6eece7773e`](https://github.com/nodejs/node/commit/6eece7773e)] - **child_process**: update outdated comment (Tanuja-Sawant)
* [[`0548e5d12a`](https://github.com/nodejs/node/commit/0548e5d12a)] - **(SEMVER-MAJOR)** **child_process**: add fork/execFile arg validation (Rich Trott) [#7399](https://github.com/nodejs/node/pull/7399)
* [[`b90f3da9de`](https://github.com/nodejs/node/commit/b90f3da9de)] - **(SEMVER-MAJOR)** **child_process, win**: fix shell spawn with AutoRun (Bartosz Sosnowski) [#8063](https://github.com/nodejs/node/pull/8063)
* [[`f44b18f010`](https://github.com/nodejs/node/commit/f44b18f010)] - **(SEMVER-MAJOR)** **cluster**: deprecate worker.suicide (Evan Lucas) [#3747](https://github.com/nodejs/node/pull/3747)
* [[`bd7d7a7e17`](https://github.com/nodejs/node/commit/bd7d7a7e17)] - **console**: name anonymous functions (Tyler Brazier) [#9047](https://github.com/nodejs/node/pull/9047)
* [[`c60d43b6d9`](https://github.com/nodejs/node/commit/c60d43b6d9)] - **crypto**: fix faulty logic in iv size check (Ben Noordhuis) [#9032](https://github.com/nodejs/node/pull/9032)
* [[`72f1c41fb6`](https://github.com/nodejs/node/commit/72f1c41fb6)] - **crypto**: naming anonymous functions (solebox) [#8993](https://github.com/nodejs/node/pull/8993)
* [[`89643b645e`](https://github.com/nodejs/node/commit/89643b645e)] - **crypto**: use SSL_get_SSL_CTX. (Adam Langley) [#8995](https://github.com/nodejs/node/pull/8995)
* [[`f4aa2c2c93`](https://github.com/nodejs/node/commit/f4aa2c2c93)] - **(SEMVER-MAJOR)** **crypto**: remove POINT_CONVERSION_HYBRID from documentation. (Adam Langley) [#4956](https://github.com/nodejs/node/pull/4956)
* [[`6bbdd668bd`](https://github.com/nodejs/node/commit/6bbdd668bd)] - **deps**: update V8 to 5.4.500.36 (Michaël Zasso) [#9253](https://github.com/nodejs/node/pull/9253)
* [[`5e3a480ad5`](https://github.com/nodejs/node/commit/5e3a480ad5)] - **deps**: revert default gtest reporter change (Brian White) [#8948](https://github.com/nodejs/node/pull/8948)
* [[`c0a3ac2e94`](https://github.com/nodejs/node/commit/c0a3ac2e94)] - **deps**: cherry-pick missing v8 floating patch (Michael Dawson) [#8907](https://github.com/nodejs/node/pull/8907)
* [[`bef4b3bfda`](https://github.com/nodejs/node/commit/bef4b3bfda)] - **deps**: update V8 to 5.4.500.31 (Michaël Zasso) [#8852](https://github.com/nodejs/node/pull/8852)
* [[`a88bb3a758`](https://github.com/nodejs/node/commit/a88bb3a758)] - **(SEMVER-MAJOR)** **deps**: cherry-pick workaround for clang-3.4 ICE (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`90efff6000`](https://github.com/nodejs/node/commit/90efff6000)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.4.500.27 (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`245ac302f5`](https://github.com/nodejs/node/commit/245ac302f5)] - **(SEMVER-MINOR)** **deps**: update V8 to 5.1.281.75 (Ben Noordhuis) [#7615](https://github.com/nodejs/node/pull/7615)
* [[`dc17432208`](https://github.com/nodejs/node/commit/dc17432208)] - **deps**: fix V8 5.1 tests (Michaël Zasso) [#7488](https://github.com/nodejs/node/pull/7488)
* [[`2cc2951796`](https://github.com/nodejs/node/commit/2cc2951796)] - **(SEMVER-MINOR)** **deps**: update V8 to 5.1.281.69 (Michaël Zasso) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`e9b6fbbf17`](https://github.com/nodejs/node/commit/e9b6fbbf17)] - **(SEMVER-MAJOR)** **dgram**: prefer strict equality, type validation (Claudio Rodriguez) [#8011](https://github.com/nodejs/node/pull/8011)
* [[`260f41f2cc`](https://github.com/nodejs/node/commit/260f41f2cc)] - **dns**: name anonymous functions (Miguel Angel Asencio Hurtado) [#9052](https://github.com/nodejs/node/pull/9052)
* [[`3238f15234`](https://github.com/nodejs/node/commit/3238f15234)] - **doc**: change os x tag to macos (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`1794456ebc`](https://github.com/nodejs/node/commit/1794456ebc)] - **doc**: change solaris tag to smartos (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`98ca07bfe0`](https://github.com/nodejs/node/commit/98ca07bfe0)] - **doc**: add teams for platform-specific issues (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`e4e60b45e1`](https://github.com/nodejs/node/commit/e4e60b45e1)] - **doc**: add s390 and ppc architecture labels (Gibson Fahnestock) [#9009](https://github.com/nodejs/node/pull/9009)
* [[`3b580145c4`](https://github.com/nodejs/node/commit/3b580145c4)] - **doc**: fixes formatting in process (Rod Machen) [#9235](https://github.com/nodejs/node/pull/9235)
* [[`3e2bafe053`](https://github.com/nodejs/node/commit/3e2bafe053)] - **doc**: improve header styling for API docs (Jeremiah Senkpiel) [#8811](https://github.com/nodejs/node/pull/8811)
* [[`0a307f90cd`](https://github.com/nodejs/node/commit/0a307f90cd)] - **doc**: clarify fs.link and fs.linkSync arguments (Kyle E. Mitchell) [#9145](https://github.com/nodejs/node/pull/9145)
* [[`38cf1d4739`](https://github.com/nodejs/node/commit/38cf1d4739)] - **doc**: remove confusing reference in governance doc (Rich Trott) [#9073](https://github.com/nodejs/node/pull/9073)
* [[`5bf215d6b9`](https://github.com/nodejs/node/commit/5bf215d6b9)] - **doc**: suggest nodejs/help for general support (Myles Borins) [#9128](https://github.com/nodejs/node/pull/9128)
* [[`5e26980937`](https://github.com/nodejs/node/commit/5e26980937)] - **doc**: fix header level for crypto.constants (Evan Lucas) [#9187](https://github.com/nodejs/node/pull/9187)
* [[`89b920fead`](https://github.com/nodejs/node/commit/89b920fead)] - **doc**: add ctc-review label information (Rich Trott) [#9072](https://github.com/nodejs/node/pull/9072)
* [[`e6d1d54230`](https://github.com/nodejs/node/commit/e6d1d54230)] - **doc**: fix typo in zlib.md (Parambir Singh) [#9123](https://github.com/nodejs/node/pull/9123)
* [[`3b63b64992`](https://github.com/nodejs/node/commit/3b63b64992)] - **doc**: further improve child_process doc types (Indrek Ardel) [#9095](https://github.com/nodejs/node/pull/9095)
* [[`f56bdecde1`](https://github.com/nodejs/node/commit/f56bdecde1)] - **doc**: edit Stream api grammar (Benji Marinacci) [#9100](https://github.com/nodejs/node/pull/9100)
* [[`95d45d750a`](https://github.com/nodejs/node/commit/95d45d750a)] - **doc**: improved example for http.get (marzelin) [#9065](https://github.com/nodejs/node/pull/9065)
* [[`0022bfe42e`](https://github.com/nodejs/node/commit/0022bfe42e)] - **doc**: update reference to list hash algorithms in crypto.md (scott stern) [#9043](https://github.com/nodejs/node/pull/9043)
* [[`b0da43104f`](https://github.com/nodejs/node/commit/b0da43104f)] - **doc**: specify that errno is a number, not a string (John Vilk) [#9007](https://github.com/nodejs/node/pull/9007)
* [[`c258dc89d9`](https://github.com/nodejs/node/commit/c258dc89d9)] - **doc**: highlight deprecated API in ToC (Ilya Frolov) [#7189](https://github.com/nodejs/node/pull/7189)
* [[`d529a46416`](https://github.com/nodejs/node/commit/d529a46416)] - **doc**: explains why Reviewed-By is added in PRs (jessicaquynh) [#9044](https://github.com/nodejs/node/pull/9044)
* [[`482995e7cc`](https://github.com/nodejs/node/commit/482995e7cc)] - **doc**: explain why GitHub merge button is not used (jessicaquynh) [#9044](https://github.com/nodejs/node/pull/9044)
* [[`3735f22480`](https://github.com/nodejs/node/commit/3735f22480)] - **doc**: fix typo (Nikolai Vavilov) [#9089](https://github.com/nodejs/node/pull/9089)
* [[`839f1f02ed`](https://github.com/nodejs/node/commit/839f1f02ed)] - **doc**: fix broken links in changelogs (Evan Lucas) [#8122](https://github.com/nodejs/node/pull/8122)
* [[`8f6589a0ba`](https://github.com/nodejs/node/commit/8f6589a0ba)] - **doc**: revise http documentation (Timothy Gu) [#8486](https://github.com/nodejs/node/pull/8486)
* [[`f3f5a89a10`](https://github.com/nodejs/node/commit/f3f5a89a10)] - **doc**: *.md formatting fixes in the benchmark dir (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`9744928cf5`](https://github.com/nodejs/node/commit/9744928cf5)] - **doc**: fix layout problem in v4 changelog (Myles Borins) [#7394](https://github.com/nodejs/node/pull/7394)
* [[`d976d66cfc`](https://github.com/nodejs/node/commit/d976d66cfc)] - **doc**: clarify fs.access works on directories too. (Lance Ball) [#7113](https://github.com/nodejs/node/pull/7113)
* [[`8c1d5e58d4`](https://github.com/nodejs/node/commit/8c1d5e58d4)] - **doc**: improve rendering of v4.4.5 changelog entry (Myles Borins) [#6958](https://github.com/nodejs/node/pull/6958)
* [[`2bceda6493`](https://github.com/nodejs/node/commit/2bceda6493)] - **doc**: get rid of sneaky hard tabs in CHANGELOG (Myles Borins) [#6608](https://github.com/nodejs/node/pull/6608)
* [[`29e49fc286`](https://github.com/nodejs/node/commit/29e49fc286)] - **(SEMVER-MAJOR)** **doc, punycode**: soft-deprecation of the punycode module (James M Snell) [#7941](https://github.com/nodejs/node/pull/7941)
* [[`3b8ec68a3a`](https://github.com/nodejs/node/commit/3b8ec68a3a)] - **(SEMVER-MAJOR)** **domain**: add message for dispose deprecation (Brian White) [#7053](https://github.com/nodejs/node/pull/7053)
* [[`983775d457`](https://github.com/nodejs/node/commit/983775d457)] - **(SEMVER-MAJOR)** **events**: make memory leak warning name more verbose (Anna Henningsen) [#8341](https://github.com/nodejs/node/pull/8341)
* [[`b7a8a691b4`](https://github.com/nodejs/node/commit/b7a8a691b4)] - **(SEMVER-MAJOR)** **events**: unwrap #once listeners in #listeners (Owen Smith) [#6881](https://github.com/nodejs/node/pull/6881)
* [[`108c1fbbe2`](https://github.com/nodejs/node/commit/108c1fbbe2)] - **fs**: clarify fs.link and fs.linkSync arguments (Kyle E. Mitchell) [#9145](https://github.com/nodejs/node/pull/9145)
* [[`7f7d1d385d`](https://github.com/nodejs/node/commit/7f7d1d385d)] - **(SEMVER-MAJOR)** **fs**: move stringToFlags() to lib/internal (Ben Noordhuis) [#7162](https://github.com/nodejs/node/pull/7162)
* [[`fe9f5bcd75`](https://github.com/nodejs/node/commit/fe9f5bcd75)] - **fs**: don't alter user provided `options` object (Sakthipriyan Vairamani (thefourtheye)) [#7831](https://github.com/nodejs/node/pull/7831)
* [[`169f485289`](https://github.com/nodejs/node/commit/169f485289)] - **(SEMVER-MAJOR)** **fs**: refactor "options" processing as a function (Sakthipriyan Vairamani) [#7165](https://github.com/nodejs/node/pull/7165)
* [[`21124ba23a`](https://github.com/nodejs/node/commit/21124ba23a)] - **(SEMVER-MAJOR)** **fs**: do not emit 'stop' watch event synchronously (Claudio Rodriguez) [#8524](https://github.com/nodejs/node/pull/8524)
* [[`b50557b51b`](https://github.com/nodejs/node/commit/b50557b51b)] - **fs**: use process.emitWarning to print deprecation warning (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`dc7277909b`](https://github.com/nodejs/node/commit/dc7277909b)] - **fs**: move SyncWriteStream to internal/fs (James M Snell) [#6749](https://github.com/nodejs/node/pull/6749)
* [[`49ef3ae90a`](https://github.com/nodejs/node/commit/49ef3ae90a)] - **(SEMVER-MAJOR)** ***Revert*** "**fs**: add a temporary fix for re-evaluation support" (James M Snell) [#6413](https://github.com/nodejs/node/pull/6413)
* [[`f8f283b8f3`](https://github.com/nodejs/node/commit/f8f283b8f3)] - **(SEMVER-MAJOR)** **fs**: warn if no callback is passed to async calls (Sakthipriyan Vairamani) [#7897](https://github.com/nodejs/node/pull/7897)
* [[`6f27bedfba`](https://github.com/nodejs/node/commit/6f27bedfba)] - **governance**: expand use of CTC issue tracker (Rich Trott) [#8945](https://github.com/nodejs/node/pull/8945)
* [[`179150091f`](https://github.com/nodejs/node/commit/179150091f)] - **http**: name anonymous functions in http (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`73a8d3b0da`](https://github.com/nodejs/node/commit/73a8d3b0da)] - **http**: name anonymous functions in _http_server (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`ffa5c9ea30`](https://github.com/nodejs/node/commit/ffa5c9ea30)] - **http**: name anonymous functions in _http_outgoing (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`fa035ada90`](https://github.com/nodejs/node/commit/fa035ada90)] - **http**: name anonymous functions in _http_incoming (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`ec17e76656`](https://github.com/nodejs/node/commit/ec17e76656)] - **http**: name anonymous functions in _http_client (maasencioh) [#9055](https://github.com/nodejs/node/pull/9055)
* [[`9099a43073`](https://github.com/nodejs/node/commit/9099a43073)] - **http**: name anonymous functions (maasencioh) [#9054](https://github.com/nodejs/node/pull/9054)
* [[`cde2ca96e4`](https://github.com/nodejs/node/commit/cde2ca96e4)] - **http**: reject control characters in http.request() (Ben Noordhuis) [#8923](https://github.com/nodejs/node/pull/8923)
* [[`2cc7fa5e7d`](https://github.com/nodejs/node/commit/2cc7fa5e7d)] - **(SEMVER-MAJOR)** **http**: remove deprecated Client interface (Brian White) [#8104](https://github.com/nodejs/node/pull/8104)
* [[`31bef6b704`](https://github.com/nodejs/node/commit/31bef6b704)] - **(SEMVER-MAJOR)** **http**: correct error message for invalid trailer (Bryan English) [#6308](https://github.com/nodejs/node/pull/6308)
* [[`a54ec7f49c`](https://github.com/nodejs/node/commit/a54ec7f49c)] - **inspector**: no URLs when the debugger is connected (Eugene Ostroukhov) [#8919](https://github.com/nodejs/node/pull/8919)
* [[`626a07df5b`](https://github.com/nodejs/node/commit/626a07df5b)] - **inspector**: restore 9229 as a default port (Eugene Ostroukhov) [#8550](https://github.com/nodejs/node/pull/8550)
* [[`9f1f7e2a34`](https://github.com/nodejs/node/commit/9f1f7e2a34)] - **(SEMVER-MAJOR)** **inspector**: listen on process.debugPort (cjihrig) [#8386](https://github.com/nodejs/node/pull/8386)
* [[`7b73f55902`](https://github.com/nodejs/node/commit/7b73f55902)] - **internal/util**: remove printDeprecationWarning (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`9ad3082b1c`](https://github.com/nodejs/node/commit/9ad3082b1c)] - **(SEMVER-MAJOR)** **intl**: add deprecation warning for v8BreakIterator (Michaël Zasso) [#8908](https://github.com/nodejs/node/pull/8908)
* [[`15eaba98a1`](https://github.com/nodejs/node/commit/15eaba98a1)] - **lib**: use emitWarning instead of printDeprecationMessage (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`3a3996315c`](https://github.com/nodejs/node/commit/3a3996315c)] - **lib,src**: reset zero fill flag on exception (Ben Noordhuis) [#7093](https://github.com/nodejs/node/pull/7093)
* [[`27e84ddd4e`](https://github.com/nodejs/node/commit/27e84ddd4e)] - **lib,src**: clean up ArrayBufferAllocator (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`334ef4f19d`](https://github.com/nodejs/node/commit/334ef4f19d)] - **lib,src**: drop dependency on v8::Private::ForApi() (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`d582193613`](https://github.com/nodejs/node/commit/d582193613)] - **(SEMVER-MAJOR)** **module**: Remove deprecated function requireRepl. (Adri Van Houdt) [#8575](https://github.com/nodejs/node/pull/8575)
* [[`6f1cae70eb`](https://github.com/nodejs/node/commit/6f1cae70eb)] - **net**: fix ambiguity in EOF handling (Fedor Indutny) [#9066](https://github.com/nodejs/node/pull/9066)
* [[`fd6af98c2d`](https://github.com/nodejs/node/commit/fd6af98c2d)] - **(SEMVER-MAJOR)** **net**: refactor Server.prototype.listen (Jan Schär) [#4039](https://github.com/nodejs/node/pull/4039)
* [[`5e5ec2cd1e`](https://github.com/nodejs/node/commit/5e5ec2cd1e)] - **(SEMVER-MAJOR)** **os**: deprecate `tmpDir()` in favour of `tmpdir()` (Jeremiah Senkpiel) [#6739](https://github.com/nodejs/node/pull/6739)
* [[`aedb72e03b`](https://github.com/nodejs/node/commit/aedb72e03b)] - **process**: improve performance of nextTick (Evan Lucas) [#8932](https://github.com/nodejs/node/pull/8932)
* [[`bf91035364`](https://github.com/nodejs/node/commit/bf91035364)] - **process**: fix handling of process.noDeprecation in emitWarning (James M Snell) [#8166](https://github.com/nodejs/node/pull/8166)
* [[`62b544290a`](https://github.com/nodejs/node/commit/62b544290a)] - **(SEMVER-MAJOR)** **process**: remove deprecated process.EventEmitter (cjihrig) [#6862](https://github.com/nodejs/node/pull/6862)
* [[`07dbf7313d`](https://github.com/nodejs/node/commit/07dbf7313d)] - **(SEMVER-MAJOR)** **promise**: hard deprecation for unhandled promise rejection (James M Snell) [#8217](https://github.com/nodejs/node/pull/8217)
* [[`ecf474ceba`](https://github.com/nodejs/node/commit/ecf474ceba)] - **(SEMVER-MAJOR)** **promise**: warn on unhandled rejections (Benjamin Gruenbaum) [#8217](https://github.com/nodejs/node/pull/8217)
* [[`1a9e247c79`](https://github.com/nodejs/node/commit/1a9e247c79)] - **(SEMVER-MAJOR)** **readline**: show completions only after 2nd TAB (Anna Henningsen) [#7754](https://github.com/nodejs/node/pull/7754)
* [[`8a87b29034`](https://github.com/nodejs/node/commit/8a87b29034)] - **(SEMVER-MAJOR)** **readline**: remove deprecated methods (cjihrig) [#6423](https://github.com/nodejs/node/pull/6423)
* [[`488d28d391`](https://github.com/nodejs/node/commit/488d28d391)] - **(SEMVER-MAJOR)** **repl**: deprecate unused function convertToContext (Prince J Wesley) [#7829](https://github.com/nodejs/node/pull/7829)
* [[`b2be04ac85`](https://github.com/nodejs/node/commit/b2be04ac85)] - **src**: refactor contextify (Franziska Hinkelmann) [#8909](https://github.com/nodejs/node/pull/8909)
* [[`e175188a94`](https://github.com/nodejs/node/commit/e175188a94)] - **src**: fix typo rval to value (Miguel Angel Asencio Hurtado) [#9023](https://github.com/nodejs/node/pull/9023)
* [[`1fda657cac`](https://github.com/nodejs/node/commit/1fda657cac)] - **(SEMVER-MAJOR)** **src**: update module version mismatch error message (James M Snell) [#8391](https://github.com/nodejs/node/pull/8391)
* [[`96933df2ff`](https://github.com/nodejs/node/commit/96933df2ff)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 51 (Myles Borins) [#8808](https://github.com/nodejs/node/pull/8808)
* [[`b032f1cfc3`](https://github.com/nodejs/node/commit/b032f1cfc3)] - **(SEMVER-MAJOR)** **src**: no longer need to use std::tr1:: (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`ebad04326d`](https://github.com/nodejs/node/commit/ebad04326d)] - **src**: notify V8 for low memory when alloc fails (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`aed9792ff4`](https://github.com/nodejs/node/commit/aed9792ff4)] - **src**: provide allocation + nullptr check shortcuts (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`d2470d4dff`](https://github.com/nodejs/node/commit/d2470d4dff)] - **src**: pass desired return type to allocators (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`de946013c2`](https://github.com/nodejs/node/commit/de946013c2)] - **src**: add Malloc() size param + overflow detection (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`5bf94357a9`](https://github.com/nodejs/node/commit/5bf94357a9)] - **src**: remove unused StringValue macro parameters (Daniel Bevenius) [#7905](https://github.com/nodejs/node/pull/7905)
* [[`cc00be6ace`](https://github.com/nodejs/node/commit/cc00be6ace)] - **src**: fix -Wunused-result warning (Santiago Gimeno) [#8450](https://github.com/nodejs/node/pull/8450)
* [[`8e7cbe2546`](https://github.com/nodejs/node/commit/8e7cbe2546)] - **(SEMVER-MAJOR)** **src**: make debugger listen on 127.0.0.1 by default (Ben Noordhuis) [#8106](https://github.com/nodejs/node/pull/8106)
* [[`781713d5ef`](https://github.com/nodejs/node/commit/781713d5ef)] - **src**: remove unused isolate member (Ben Noordhuis) [#7334](https://github.com/nodejs/node/pull/7334)
* [[`de4161d367`](https://github.com/nodejs/node/commit/de4161d367)] - **src**: remove unused internals from node.cc (Anna Henningsen) [#7117](https://github.com/nodejs/node/pull/7117)
* [[`ac0665c908`](https://github.com/nodejs/node/commit/ac0665c908)] - **src**: fix ArrayBuffer size for zero fill flag (Anna Henningsen) [#7142](https://github.com/nodejs/node/pull/7142)
* [[`aac79dfd78`](https://github.com/nodejs/node/commit/aac79dfd78)] - **src**: use stack-allocated Environment instances (Ben Noordhuis) [#7090](https://github.com/nodejs/node/pull/7090)
* [[`58cec4e85b`](https://github.com/nodejs/node/commit/58cec4e85b)] - **src**: move env init logic into Environment class (Ben Noordhuis) [#7090](https://github.com/nodejs/node/pull/7090)
* [[`c3cd453cba`](https://github.com/nodejs/node/commit/c3cd453cba)] - **src**: make IsolateData creation explicit (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`0301ce9f55`](https://github.com/nodejs/node/commit/0301ce9f55)] - **src**: move IsolateData out of Environment (Ben Noordhuis) [#7082](https://github.com/nodejs/node/pull/7082)
* [[`a3c5567eb4`](https://github.com/nodejs/node/commit/a3c5567eb4)] - **(SEMVER-MAJOR)** **src,win**: use correct exit code in old versions (yorkie) [#8204](https://github.com/nodejs/node/pull/8204)
* [[`2f05af4c06`](https://github.com/nodejs/node/commit/2f05af4c06)] - **(SEMVER-MAJOR)** **stream**: improve stream error messages (Italo A. Casas) [#8801](https://github.com/nodejs/node/pull/8801)
* [[`9983af0347`](https://github.com/nodejs/node/commit/9983af0347)] - **(SEMVER-MAJOR)** **stream**: improve unimplemented _write() error (ratikesh9) [#7671](https://github.com/nodejs/node/pull/7671)
* [[`0cd0118334`](https://github.com/nodejs/node/commit/0cd0118334)] - **(SEMVER-MAJOR)** **stream**: 'data' argument on callback of Transform._flush() (Jesús Leganés Combarro "piranna) [#3708](https://github.com/nodejs/node/pull/3708)
* [[`a717be87a3`](https://github.com/nodejs/node/commit/a717be87a3)] - **test**: fix flaky test-timers-blocking-callback (Rich Trott) [#9198](https://github.com/nodejs/node/pull/9198)
* [[`5ba02bf5db`](https://github.com/nodejs/node/commit/5ba02bf5db)] - **test**: remove arbitrary timer (Rich Trott) [#9197](https://github.com/nodejs/node/pull/9197)
* [[`1518cc1e70`](https://github.com/nodejs/node/commit/1518cc1e70)] - **test**: remove duplicate required module (Rich Trott) [#9169](https://github.com/nodejs/node/pull/9169)
* [[`d62e7bd1f9`](https://github.com/nodejs/node/commit/d62e7bd1f9)] - **test**: add regression test for instanceof (Franziska Hinkelmann) [#9178](https://github.com/nodejs/node/pull/9178)
* [[`bb1e6064c1`](https://github.com/nodejs/node/commit/bb1e6064c1)] - **test**: rename target to exports for consistency (Daniel Bevenius) [#9135](https://github.com/nodejs/node/pull/9135)
* [[`8788d009f8`](https://github.com/nodejs/node/commit/8788d009f8)] - **test**: checking if error constructor is assert.AssertionError (larissayvette) [#9119](https://github.com/nodejs/node/pull/9119)
* [[`68157bd8b9`](https://github.com/nodejs/node/commit/68157bd8b9)] - **test**: remove unneeded escaping in template strings (Rich Trott) [#9112](https://github.com/nodejs/node/pull/9112)
* [[`0591362887`](https://github.com/nodejs/node/commit/0591362887)] - **test**: remove unused common.libDir (Rich Trott) [#9124](https://github.com/nodejs/node/pull/9124)
* [[`0f2f4d2425`](https://github.com/nodejs/node/commit/0f2f4d2425)] - **test**: fix flaky test-child-process-fork-dgram (Rich Trott) [#9098](https://github.com/nodejs/node/pull/9098)
* [[`47863a5837`](https://github.com/nodejs/node/commit/47863a5837)] - **test**: use npm sandbox in test-npm-install (João Reis) [#9079](https://github.com/nodejs/node/pull/9079)
* [[`67e2b92e21`](https://github.com/nodejs/node/commit/67e2b92e21)] - **test**: enable node-module-version/test.js with debug (Daniel Bevenius) [#9093](https://github.com/nodejs/node/pull/9093)
* [[`d5bdd65c6a`](https://github.com/nodejs/node/commit/d5bdd65c6a)] - **test**: move module out of fixture directory (Rich Trott) [#9022](https://github.com/nodejs/node/pull/9022)
* [[`0ad0e6addb`](https://github.com/nodejs/node/commit/0ad0e6addb)] - **test**: fix issues reported by Coverity (Eugene Ostroukhov) [#8870](https://github.com/nodejs/node/pull/8870)
* [[`aac93a5c64`](https://github.com/nodejs/node/commit/aac93a5c64)] - **test**: refactor test-file-* (Jenna Vuong) [#8999](https://github.com/nodejs/node/pull/8999)
* [[`1bb1b3abe4`](https://github.com/nodejs/node/commit/1bb1b3abe4)] - **test**: fixes that do not affect performance (larissayvette) [#9011](https://github.com/nodejs/node/pull/9011)
* [[`96faba6ad8`](https://github.com/nodejs/node/commit/96faba6ad8)] - **test**: add cluster inspector debug port test (cjihrig) [#8958](https://github.com/nodejs/node/pull/8958)
* [[`7926886bf3`](https://github.com/nodejs/node/commit/7926886bf3)] - **test**: fix test-debug-signal-cluster.js flakyness (Julien Gilli) [#8568](https://github.com/nodejs/node/pull/8568)
* [[`99cfd53097`](https://github.com/nodejs/node/commit/99cfd53097)] - **(SEMVER-MAJOR)** **test**: test execFile/fork arg validation (Chuck Langford) [#7399](https://github.com/nodejs/node/pull/7399)
* [[`15cd45c6fc`](https://github.com/nodejs/node/commit/15cd45c6fc)] - **test**: fix tests for non-crypto builds (Anna Henningsen) [#7056](https://github.com/nodejs/node/pull/7056)
* [[`fea3070ec4`](https://github.com/nodejs/node/commit/fea3070ec4)] - **test**: add buffer testcase for resetting kZeroFill (Сковорода Никита Андреевич) [#7093](https://github.com/nodejs/node/pull/7093)
* [[`2cdd5ccef9`](https://github.com/nodejs/node/commit/2cdd5ccef9)] - **test,lib,benchmark**: match function names (Rich Trott) [#9113](https://github.com/nodejs/node/pull/9113)
* [[`827660e03e`](https://github.com/nodejs/node/commit/827660e03e)] - **tools**: enable ES2016 syntax support in ESLint (Michaël Zasso) [#9218](https://github.com/nodejs/node/pull/9218)
* [[`a83354a567`](https://github.com/nodejs/node/commit/a83354a567)] - **tools**: replace custom lint rule for getter/setter (Rich Trott) [#9194](https://github.com/nodejs/node/pull/9194)
* [[`3ab8be07cb`](https://github.com/nodejs/node/commit/3ab8be07cb)] - **tools**: fix release script on macOS 10.12 (Evan Lucas) [#8824](https://github.com/nodejs/node/pull/8824)
* [[`72fa9f5663`](https://github.com/nodejs/node/commit/72fa9f5663)] - **tools**: update ESLint to v3.8.0 (Rich Trott) [#9112](https://github.com/nodejs/node/pull/9112)
* [[`8ac29bd7c1`](https://github.com/nodejs/node/commit/8ac29bd7c1)] - **tools**: avoid let in for loops (jessicaquynh) [#9049](https://github.com/nodejs/node/pull/9049)
* [[`1a93e03a0e`](https://github.com/nodejs/node/commit/1a93e03a0e)] - **(SEMVER-MAJOR)** **tools**: do not disable ICU's transliteration (Michaël Zasso) [#8317](https://github.com/nodejs/node/pull/8317)
* [[`6a3dbdacd6`](https://github.com/nodejs/node/commit/6a3dbdacd6)] - **(SEMVER-MAJOR)** **udp**: remove ancient check (Saúl Ibarra Corretgé) [#8088](https://github.com/nodejs/node/pull/8088)
* [[`1afd7c166e`](https://github.com/nodejs/node/commit/1afd7c166e)] - **url**: fix building when using --without-intl (James M Snell) [#9041](https://github.com/nodejs/node/pull/9041)
* [[`a8ece149e2`](https://github.com/nodejs/node/commit/a8ece149e2)] - **(SEMVER-MINOR)** **url**: adding WHATWG URL support (James M Snell) [#7448](https://github.com/nodejs/node/pull/7448)
* [[`336b027411`](https://github.com/nodejs/node/commit/336b027411)] - **(SEMVER-MAJOR)** **url**: return valid file: urls fom url.format() (Rich Trott) [#7234](https://github.com/nodejs/node/pull/7234)
* [[`197a465280`](https://github.com/nodejs/node/commit/197a465280)] - **(SEMVER-MAJOR)** **zlib**: move constants into zlib.constants (James M Snell) [#7203](https://github.com/nodejs/node/pull/7203)
