# Citizen and Contributor Code of Conduct

## 1. Purpose
A primary goal of NV Access and NVDA is to be inclusive to the largest number of contributors, with the most varied and diverse backgrounds possible. As such, we are committed to providing a friendly, safe and welcoming environment for all, regardless of gender, sexual orientation, ability, ethnicity, nationality, socioeconomic status, education, level of experience and religion (or lack thereof).
This code of conduct outlines our expectations for all those who participate in our community, as well as the consequences for unacceptable behaviour.
We invite all those who participate in the NVDA community to help us create safe and positive experiences for everyone. NVDA is a user driven initiative.

## 2. Open Source Citizenship
A supplemental goal of this Code of Conduct is to increase open source citizenship by encouraging participants to recognise and strengthen the relationships between our actions and their effects on our community.
Communities mirror the societies in which they exist and positive action is essential to counteract the many forms of inequality and abuses of power that exist in society.
If you see someone who is making an extra effort to ensure our community is welcoming, friendly, and encourages all participants to contribute to the fullest extent, we want to know.

## 3. Expected Behaviour
The following behaviours are expected and requested of all community members:
* To participate in an authentic and active way. In doing so, you contribute to the health and longevity of this community.
* To exercise consideration and respect in your speech and actions.
* To attempt collaboration before conflict.
* To provide helpful contributions to an issue in order to encourage its progression
* To be respectful of differing viewpoints and experiences
* To gracefully accept constructive criticism
* To respect the need to prioritise issues based on NV Access, user, and community priority
* To be aware that GitHub is a public forum and refrain from publishing personal or sensitive information (your own or others). For example, carefully consider the contents of debug logs when publishing.
* To refrain from demeaning, discriminatory, or harassing behaviour and speech.
* To be mindful of your surroundings and of your fellow participants. Alert NV Access staff if you notice a dangerous situation, someone in distress, or violations of this Code of Conduct, even if they seem inconsequential.

## 4. Unacceptable Behaviour
The following behaviours are considered harassment and are unacceptable within our community:
* Violence, threats of violence, inciting violence, glorifying violence, or violent language directed against another person.
* Sexist, racist, homophobic, transphobic, ableist or otherwise discriminatory jokes and language.
* Posting or displaying sexually explicit or violent material.
* Posting or threatening to post other people's personally identifying information ("doxing").
* Trolling, insulting/derogatory comments, and personal or political attacks
* Personal insults, particularly those related to gender, sexual orientation, race, religion, or disability.
* Inappropriate photography or recording.
* Unwelcome sexual attention. This includes sexualized comments or jokes, inappropriate touching, groping, and unwelcome sexual advances.
* Deliberate intimidation, stalking or following (online or in person).
* Advocating for, or encouraging, any of the above behaviour.
* Sustained disruption of community events, including talks and presentations.
* Religious or political proselytising.

## 5. Consequences of Unacceptable Behaviour
Unacceptable behaviour from any community member, including sponsors and those with decision-making authority, will not be tolerated.
Anyone asked to stop unacceptable behaviour is expected to comply immediately.
If a community member engages in unacceptable behaviour, NV Access Staff may take any action they deem appropriate, up to and including a temporary ban or permanent expulsion from the community without warning (and without refund in the case of a paid event).
NV Access Staff have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviours that they deem inappropriate, threatening, offensive, or harmful.

## 6. Reporting Guidelines
If you are subject to or witness unacceptable behaviour, or have any other concerns, please notify NV Access staff as soon as possible via info@nvaccess.org. The information required for notifications includes PR/Issue Number, nature of breach, community member responsible, date and time of breach. Please note that the details of the reporter will not be disclosed, unless required to by law.

## 7. Addressing Grievances
If you feel you have been falsely or unfairly accused of violating this Code of Conduct, you should notify NV Access at info@nvaccess.org with a concise description of your grievance.

## 8. Scope
We expect all community participants (contributors, paid or otherwise; sponsors; and other guests) to abide by this Code of Conduct in all community venues--online and in-person--as well as in all one-on-one communications pertaining to community business.
This code of conduct and its related procedures also applies to unacceptable behaviour occurring outside the scope of community activities when such behaviour has the potential to adversely affect the safety and well-being of community members.
For others setting up or running an NVDA group of any kind, it is strongly recommended that a complementary Citizen and Contributor Code of Conduct is adopted.

## 9. Contact info
info@nvaccess.org

## 10. License and attribution
The Citizen and Contributor Code of Conduct is distributed by NV Access Limited.
Portions of text were derived from the GitHub sample Citizen and Contributor Code of Conduct, which is distributed under a Creative Commons Attribution-ShareAlike license.

Revision history:
- Revision 1.0 adopted by NV Access Limited on 2020-09-23
- Revision 1.1 adopted by NV Access Limited on 2023-08-09
