## Product Vision
A world where blind and vision impaired people can independently and fully interact with the Windows Operating System and popular third party applications, enabling them to participate in and contribute to society.
Blind and vision impaired people are empowered to control their own destiny and ensure this vision, through being able to significantly contribute to the technology that makes this possible.
All blind and vision impaired people deserve these rights and opportunities, no matter the language they speak, their geographic location, economic status, or sensory, physical, cognitive, or mental abilities.

## Product description
NVDA (NonVisual Desktop Access) is software that allows blind and vision impaired people to independently interact with the Windows Operating System and popular third party applications by outputting content in either synthetic speech or via a refreshable Braille Display.
Developed by NV Access in partnership with a dedicated open source community, NVDA enables blind and vision impaired people to increase their chances at education and employment, and to participate in and contribute to society.

## Guiding Principles
1. Freely Available to all: To ensure that NVDA is available to anyone who needs to access the Windows Operating system, no matter their economic status:
    * NVDA is free of charge for anyone who needs to access a computer.
    * NVDA can be downloaded, copied, shared, and used on any amount of computers.
    * Future updates are free of charge.
2. By users for users: To allow and empower blind and vision impaired people to have a say in and directly contribute to NVDA, ensuring it meets their needs as a solution to technology access:
    * NVDA is an open source project, meaning that its source code is available to anyone who wishes to learn from and or contribute to the project.
    * Documentation is provided to ensure code can be understood and developers can get up and running with ease.
    * The vast majority of contributors to the NVDA project are blind or vision impaired, and are users of the product themselves.
3. Multilingual: Ensure that NVDA can be used by people no matter what language they speak:
    * NVDA provides mechanisms for volunteers to translate user interface messages and documentation.
    * Release processes provide time and reminders for volunteers to contribute translations to NVDA.
4. Stability: Ensure NVDA is stable, minimizes freezes, and avoids drastic updates that could disrupt user experience:
    * NVDA strives to support any breaking changes in Windows or supported popular third party applications before they reach the user.
    * NVDA updates should not drastically change or remove pre-existing features or defined behaviour without clearly warning the user first.
    * NVDA's code should do its best to recover from application freezes, allowing the user to still interact with the rest of the Operating System.
5. Quality: Ensure NVDA's code is high-quality, safe, and that bugs are caught before reaching a release:
    * All code is reviewed by at least one other core contributor.
    * Automated unit and system tests decrease the possibility of unwanted changes in behaviour.
    * Alpha and beta builds are provided for early testing by a large base of dedicated community testers
6. Security: Ensure that NVDA does not place a user at risk of security attacks:
    * NVDA prioritizes user security, striving to eliminate risks of remote control attacks or data leaks.
    * A strict process exists to follow a security report from implementation to rollout.
    * Critical security fixes are minimized in size and complexity to focus on the exact issue reported, which lessens the chance of other security or instabilities accidentally being introduced.
    * NVDA can optionally blank the screen while running, to make sure that another person cannot view personal or sensitive information without the blind or vision impaired user knowing.
7. Efficient: Ensure responsiveness to user input, but also energy efficiency where possible:
    * Make use of newer more efficient APIs where possible, at the same time falling back to older APIs to ensure functionality on older systems.
    * Periodically remove technical debt and refactor code to make code more efficient and understandable, making sure to maintain compatibility with existing scenarios and OS / application versions still supported.
8. Innovative: Strive to push the boundaries of what is possible and to avoid stagnation for both NVDA and its competitors:
    * Prototype new ideas and make them available through try builds.
    * Promote the sharing and healthy debate of ideas on developer email lists and GitHub Discussions.
9. Compliance: Ensure app / web developers can rely upon NVDA to make best use of the accessibility they implement:
    * NVDA strives to comply with all application and web accessibility standards where possible.
    * Where there is disagreement or inability to comply with an accessibility standard, clear reasoning and possible practical alternatives are documented.
    * Tools such as the NVDA speech viewer help application and web developers use NVDA to test and verify the accessibility of their products.
10. Collaboration: Ensure that blind and sighted people can collaborate together:
    * NVDA can clearly visually highlight the position at which the user is currently reading or navigating, to allow another person to be aware of exactly where the user is on the screen.
    * The NVDA speech viewer can be used to display the text currently being spoken, so that a sighted person who may have trouble understanding the synthesized speech can follow along.
11. Documentation: Ensure users have the knowledge to fully leverage NVDA's features for productivity in work and everyday life:
    * NVDA offers comprehensive, user-friendly documentation such as an official user guide free of charge.
    * User-level support is available via various community-run email lists.
12. Multimodal: Ensure that NVDA supports various modes of interaction, meeting the diverse needs and preferences of its users:
    * NVDA supports multiple input methods including the keyboard, mouse, touch, and braille input devices.
    * NVDA delivers output through both speech synthesis and braille displays.
    * NVDA strives to make all its features accessible through all input and output modalities. E.g. a deaf-blind user should be able to independently use NVDA through Braille alone.
13. Compatibility: Ensure that NVDA works with a wide range of software and hardware to provide maximum accessibility and to ensure users are not left behind in today's rapidly changing technology:
    * NVDA is regularly updated to be compatible with the latest versions of Windows and popular third-party applications.
    * NVDA also maintains compatibility with older versions of Windows and third-party applications that are still officially supported by their respective companies, providing accessibility solutions for users on older systems.
    * NVDA strives to support all common speech synthesizers and refreshable Braille displays that exist today.
14. Configurable: Ensure the user can configure NVDA to suit their own particular preferences and the task at hand:
    * NVDA contains many options for configuring what information is reported and how it is presented.
    * NVDA allows the user to configure attributes of the output such as the voice rate and pitch, punctuation, and what Braille standard is used.
    * NVDA allows the user to create configuration profiles, so that the user can easily switch configurations depending on the particular task they are performing.
15. Extendable: Ensure that NVDA can be easily enhanced and customized to meet specific user needs and requirements:
    * NVDA allows the creation and integration of community created add-ons, providing support for extra speech synthesizers, refreshable Braille displays, visual enhancements for low vision, and more third party applications.
    * NVDA allows the user to browse, download and install available add-ons from within NVDA itself.
    * NVDA provides freedom for add-ons to find innovative solutions by allowing them broad access to NVDA's internals.
    * NVDA ensures add-ons do not break by postponing API breakages to once per year, announcing these changes many months ahead of time.
    * NVDA Protects users from installing an add-on that is incompatible with the current version of NVDA, allowing the user to override this protection if they understand the risk.
16. Utility: NVDA provides solutions for blind and vision impaired people in accessing technology that:
    * provide utility to a significant proportion of users in day-to-day use.
    * are a necessity for a small subset of our users, without which NVDA would not be functional for them.
