# NVDA

NVDA (NonVisual Desktop Access) is a free, open source screen reader for Microsoft Windows.
It is developed by NV Access in collaboration with a global community of contributors.
To learn more about NVDA or download a copy, visit the main [NV Access](http://www.nvaccess.org/) website.

Please note: the NVDA project has a [Citizen and Contributor Code of Conduct](CODE_OF_CONDUCT.md). NV Access expects that all contributors and other community members will read and abide by the rules set out in this document while participating or contributing to this project.

The NVDA project is guided by a [product vision statement and set of principles](./projectDocs/product_vision.md).
The vision and principles should be always considered when planning features and prioritizing work.
NV Access also maintains a [development roadmap](https://www.nvaccess.org/post/nvda-roadmap/) of NVDA features and supporting infrastructure work.

NVDA is available under a modified GNU General Public License version 2.
Please refer to [our license](./copying.txt) for more information.

## Acknowledgements

We would like to extend our sincere gratitude to [SignPath](https://www.signpath.io/) for their generous support in providing code signing services to many open source projects, including NVDA.
Their contribution helps us maintain the security and integrity of our releases.

## NVDA Community

* [Support and information for NVDA users](https://www.nvaccess.org/get-help/)
* [Report an issue or feature request](./projectDocs/issues/readme.md)
* [Getting add-ons](https://download.nvaccess.org/documentation/userGuide.html#AddonsManager)
* [Contact list](./projectDocs/community/expertsList.md) for NV Access and community experts.
* [More important links and community information](./projectDocs/community/readme.md)

## Contributing to NVDA

If you would like to contribute to NVDA, you can read more information in our [contributing guide](./.github/CONTRIBUTING.md).
This includes information on reporting issues, triaging issues, testing, translating, contributing code/documentation and creating add-ons.

## Status checks

* AppVeyor
  * Alpha build status: [![view latest alpha builds](https://ci.appveyor.com/api/projects/status/sqeer6p8lc80lvqe/branch/master?svg=true)](https://ci.appveyor.com/project/NVAccess/nvda/branch/master)
  * Beta build status: [![view latest beta builds](https://ci.appveyor.com/api/projects/status/sqeer6p8lc80lvqe/branch/beta?svg=true)](https://ci.appveyor.com/project/NVAccess/nvda/branch/beta)
* Pre-commit status (master): [![view pre-commit checks on master](https://results.pre-commit.ci/badge/github/nvaccess/nvda/master.svg)](https://results.pre-commit.ci/latest/github/nvaccess/nvda/master)
* CodeQL security analysis status (master): [![view CodeQL security analysis checks on master](https://github.com/nvaccess/nvda/actions/workflows/github-code-scanning/codeql/badge.svg?branch=master)](https://github.com/nvaccess/nvda/actions/workflows/github-code-scanning/codeql?query=branch%3Amaster)
