# keyLabels.py
# A part of NonVisual Desktop Access (NVDA)
# This file is covered by the GNU General Public License.
# See the file COPYING for more details.
# Copyright (C) 2008-2016 NV Access Limited, Aleksey Sadovoy, Babbage B.v.

"""Contains mapping from the Windows key names to their localized labels.

As there are localizable strings at module level,
this can only be imported once localization is set up via `languageHandler.initialize`.
"""

localizedKeyLabels = {
	# Translators: This is the name of the back key found on multimedia keyboards for controlling the web-browser.
	"browserback": _("back"),
	# Translators: This is the name of the forward key found on multimedia keyboards for controlling the web-browser.
	"browserforward": _("forward"),
	# Translators: This is the name of the refresh key found on multimedia keyboards for controlling the web-browser.
	"browserrefresh": _("refresh"),
	# Translators: This is the name of the stop key found on multimedia keyboards for controlling the web-browser.
	"browserstop": _("browser stop"),
	# Translators: This is the name of the back key found on multimedia keyboards to goto the search page of the web-browser.
	"browsersearch": _("search page"),
	# Translators: This is the name of the favorites key found on multimedia keyboards to open favorites in the web-browser.
	"browserfavorites": _("favorites"),
	# Translators: This is the name of the home key found on multimedia keyboards to goto the home page in the web-browser.
	"browserhome": _("home page"),
	# Translators: This is the name of the mute key found on multimedia keyboards to control playback volume.
	"volumemute": _("mute"),
	# Translators: This is the name of the volume down key found on multimedia keyboards to reduce playback volume.
	"volumedown": _("volume down"),
	# Translators: This is the name of the volume up key found on multimedia keyboards to increase playback volume.
	"volumeup": _("volume up"),
	# Translators: This is the name of the next track key found on multimedia keyboards to skip to next track in the mediaplayer.
	"medianexttrack": _("next track"),
	# Translators: This is the name of the next track key found on multimedia keyboards to skip to next track in the mediaplayer.
	"mediaprevtrack": _("previous track"),
	# Translators: This is the name of the stop key found on multimedia keyboards to stop the current playing track in the mediaplayer.
	"mediastop": _("stop"),
	# Translators: This is the name of the play/pause key found on multimedia keyboards to play/pause the current playing track in the mediaplayer.
	"mediaplaypause": _("play pause"),
	# Translators: This is the name of the launch email key found on multimedia keyboards to open an email client.
	"launchmail": _("email"),
	# Translators: This is the name of the launch mediaplayer key found on multimedia keyboards to launch the mediaplayer.
	"launchmediaplayer": _("media player"),
	# Translators: This is the name of the launch custom application 1 key found on multimedia keyboards to launch a user-defined application.
	"launchapp1": _("custom application 1"),
	# Translators: This is the name of the launch custom application 2 key found on multimedia keyboards to launch a user-defined application.
	"launchapp2": _("custom application 2"),
	# Translators: This is the name of a key on the keyboard.
	"backspace": _("backspace"),
	# Translators: This is the name of a key on the keyboard.
	"capslock": _("caps lock"),
	# Translators: This is the name of a key on the keyboard.
	"control": _("ctrl"),
	# Translators: This is the name of a key on the keyboard.
	"alt": _("alt"),
	# Translators: This is the name of a key on the keyboard.
	"shift": _("shift"),
	# Translators: This is the name of a key on the keyboard.
	"windows": _("windows"),
	# Translators: This is the name of a key on the keyboard.
	"enter": _("enter"),
	# Translators: This is the name of a key on the keyboard.
	"numpadenter": _("numpad enter"),
	# Translators: This is the name of a key on the keyboard.
	"escape": _("escape"),
	# Translators: This is the name of a key on the keyboard.
	"space": _("space"),
	# Translators: This is the name of a key on the keyboard.
	"pageup": _("page up"),
	# Translators: This is the name of a key on the keyboard.
	"pagedown": _("page down"),
	# Translators: This is the name of a key on the keyboard.
	"end": _("end"),
	# Translators: This is the name of a key on the keyboard.
	"home": _("home"),
	# Translators: This is the name of a key on the keyboard.
	"delete": _("delete"),
	# Translators: This is the name of a key on the keyboard.
	"numpaddelete": _("numpad delete"),
	# Translators: This is the name of a key on the keyboard.
	"leftarrow": _("left arrow"),
	# Translators: This is the name of a key on the keyboard.
	"rightarrow": _("right arrow"),
	# Translators: This is the name of a key on the keyboard.
	"uparrow": _("up arrow"),
	# Translators: This is the name of a key on the keyboard.
	"downarrow": _("down arrow"),
	# Translators: This is the name of a key on the keyboard.
	"applications": _("applications"),
	# Translators: This is the name of a key on the keyboard.
	"numlock": _("num lock"),
	# Translators: This is the name of a key on the keyboard.
	"printscreen": _("print screen"),
	# Translators: This is the name of a key on the keyboard.
	"scrolllock": _("scroll lock"),
	# Translators: This is the name of a key on the keyboard.
	"numpad4": _("numpad 4"),
	# Translators: This is the name of a key on the keyboard.
	"numpad6": _("numpad 6"),
	# Translators: This is the name of a key on the keyboard.
	"numpad8": _("numpad 8"),
	# Translators: This is the name of a key on the keyboard.
	"numpad2": _("numpad 2"),
	# Translators: This is the name of a key on the keyboard.
	"numpad9": _("numpad 9"),
	# Translators: This is the name of a key on the keyboard.
	"numpad3": _("numpad 3"),
	# Translators: This is the name of a key on the keyboard.
	"numpad1": _("numpad 1"),
	# Translators: This is the name of a key on the keyboard.
	"numpad7": _("numpad 7"),
	# Translators: This is the name of a key on the keyboard.
	"numpad5": _("numpad 5"),
	# Translators: This is the name of a key on the keyboard.
	"numpaddivide": _("numpad divide"),
	# Translators: This is the name of a key on the keyboard.
	"numpadmultiply": _("numpad multiply"),
	# Translators: This is the name of a key on the keyboard.
	"numpadminus": _("numpad minus"),
	# Translators: This is the name of a key on the keyboard.
	"numpadplus": _("numpad plus"),
	# Translators: This is the name of a key on the keyboard.
	"numpaddecimal": _("numpad decimal"),
	# Translators: This is the name of a key on the keyboard.
	"numpadinsert": _("numpad insert"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad0": _("numLock numpad 0"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad1": _("numLock numpad 1"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad2": _("numLock numpad 2"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad3": _("numLock numpad 3"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad4": _("numLock numpad 4"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad5": _("numLock numpad 5"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad6": _("numLock numpad 6"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad7": _("numLock numpad 7"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad8": _("numLock numpad 8"),
	# Translators: This is the name of a key on the keyboard.
	"numlocknumpad9": _("numLock numpad 9"),
	# Translators: This is the name of a key on the keyboard.
	"insert": _("insert"),
	# Translators: This is the name of a key on the keyboard.
	"leftcontrol": _("left control"),
	# Translators: This is the name of a key on the keyboard.
	"rightcontrol": _("right control"),
	# Translators: This is the name of a key on the keyboard.
	"leftwindows": _("left windows"),
	# Translators: This is the name of a key on the keyboard.
	"leftshift": _("left shift"),
	# Translators: This is the name of a key on the keyboard.
	"rightshift": _("right shift"),
	# Translators: This is the name of a key on the keyboard.
	"leftalt": _("left alt"),
	# Translators: This is the name of a key on the keyboard.
	"rightalt": _("right alt"),
	# Translators: This is the name of a key on the keyboard.
	"rightwindows": _("right windows"),
	# Translators: This is the name of a key on the keyboard.
	"break": _("break"),
	# Translators: This is the name of a key on the keyboard.
	"tab": pgettext("keyLabel", "tab"),
}


def getKeyCombinationLabel(keyCombination):
	"""
	Fetches a localized label for a combination of multiple keys.
	@param keyCombination: The key combination identifier to get the localized label for, usually plus-separated key identifiers.
	@type keyCombination: string
	@returns: A localized key combination
	@rtype: string
	"""
	keys = keyCombination.lower().split("+")
	return "+".join(localizedKeyLabels.get(key, key) for key in keys)
