# Co je nového v programu NVDA 


## 2017.4

Nejvýznamnější funkce této verze jsou mnohá vylepšení podpory webu včetně výchozího prohlížení webových dialogů, zlepšení hlášení názvů skupin prvků v režimu prohlížení, podpora technologií ve Windows 10 jako strážce aplikace Windows Defender a Windows 10 na ARM64, a automatické hlášení pro otáčení obrazovky a stav baterie.
Tato verze již nepodporuje Windows XP a Vista. Minimálně se nyní vyžaduje Windows 7 s aktualizací Service Pack 1.

### Novinky

* V režimu prohlížení je možné posunovat se na konec či začátek oblastí pomocí příkazů čárka/shift+čárka pro přeskočení skupiny prvků. (#5842)
* Ve Firefoxu, Chrome a Internet Exploreru rychlá navigace po editačních polích a formulářových prvcích přechází i na upravitelný text (např. contentEditable). (#5534)
* Ve webových prohlížečích v seznamu prvků je teď možné najít formulářové prvky a tlačítka. (#588)
* Počáteční podpora Windows 10 na ARM64. (#7508)
* Raná podpora čtení a interaktivní navigace matematického obsahu pro knihy Kindle s přístupným matematickým obsahem. (#7536)
* Přidaná podpora pro čtečku e-knih Azardi. (#5848)
* Při aktualizaci doplňků NVDA oznámí verzi doplňku. (#5324)
* Přidaná podpora pro vytvoření přenosné kopie pomocí příkazového řádku. (#6329)
* Podpora Microsoft Edge přes strážce aplikace Windows Defender. (#7600)
* Pokud používáte laptop nebo tablet, NVDA oznámí, jestli se baterie nabíjí či nikoliv, a změny při otáčení obrazovky. (#4574, #4612)
* Nový jazyk: makedonština.
* Nové braillské tabulky: chorvatský plnopis, vietnamský plnopis. (#7518, #7565)
* Přidaná podpora braillského řádku Actilino společnosti Handy Tech. (#7590)
* Přidaná podpora vstupu braillských řádků Handy Tech. (#7590)

### Změny

* Minimálně podporovaný operační systém je nyní Windows 7 s aktualizací Service Pack 1 nebo Windows Server 2008 R2 s aktualizací Service Pack 1. (#7546)
* Dialogová okna ve Firefoxu a Chrome jsou automaticky v režimu prohlížení, pokud nejsou uvnitř webové aplikace. (#4493)
* Při pohybu klávesou tab nebo rychlé navigaci v režimu prohlížení se již neoznamuje vyskočení z prvků jako např. seznamu nebo tabulky, což zlepší účinnost navigace. (#2591)
* V režimu prohlížení ve Firefoxu a Chrome při pohybu klávesou tab nebo rychlé navigaci NVDA oznámí názvy skupin formulářových prvků. (#3321)
* V režimu prohlížení při pohybu po vnořených objektech (o a shift+o) jsou nyní podporovány prvky audio a video a prvky s Aria rolemi application a dialog. (#7239)
* Aktualizace Espeak-NG na verzi 1.49.2 řeší některé problémy při vytváření verzí. (#7385, #7583)
* Po třetí aktivaci příkazu pro oznámení stavového řádku se obsah stavového řádku zkopíruje do schránky. (#1785)
* U braillského řádku Baum je možné omezit příkazy kláves při jejich přiřazení na model řádku, který se právě používá (např. VarioUltra nebo Pronto). (#7517)
* Klávesová zkratka pro filtrování polí v seznamu prvků v režimu prohlížení změněna z alt+f na alt+e. (#7569)
* Přidaný nevázaný příkaz pro přepínání zahrnutí vzhledových tabulek v režimu prohlížení. Můžete ho najít v kategorii režimu prohlížení v dialogu vstupních příkazů. (#7634)
* Braillský překladač Liblouis aktualizován na verzi 3.3.0. (#7565)
* Klávesová zkratka pro přepínač regulárního výrazu v dialogu slovníků změněna z alt+r na alt+e. (#6782)
* Soubory pro hlasové slovníky jsou nazvány podle verzí a byly přesunuty do adresáře 'speechDicts/voiceDicts.v1'. (#7592)
* Úpravy souborů podle verzí (uživatelská nastavení, hlasové slovníky) se neukládají, pokud NVDA běží jako dočasná verze. (#7688)
* Starší braillské řádky Braillino, Bookworm a Modular společnosti Handy Tech nejsou již podporovány ve výchozím nastavení NVDA. Pro jejich použití je třeba nainstalovat Handy Tech Universal Driver a doplněk NVDA. (#7590)

### Opravy

* Odkazy jsou nyní zobrazeny v braillu v aplikacích jako Microsoft Word. (#6780)
* NVDA již není nápadně pomalý, pokud je otebřeno více záložek v prohlížečích Firefox nebo Chrome. (#3138)
* Při přesunutí kurzoru u braillského řádku MDV Lilly již nedochází k nesprávnému posunutí vpřed o jeden znak navíc. (#7469)
* V prohlížeči Internet Explorer a jiných dokumentech MSHTML je nyní podporován atribut HTML5 required pro zobrazení požadovaného stavu formulářového prvku. (#7321)
* Braillské řádky se nyní aktualizují při psaní arabských znaků ve Wordpadu v dokumentu se zarovnáním vlevo. (#511)
* Přístupné štítky pro ovládací prvky v prohlížeči Mozilla Firefox jsou rychleji oznámeny v režimu prohlížení, když se štítek neobjeví jako samotný obsah. (#4773)
* Ve Windows 10 Creators Update je Firefox znovu přístupný po restartu NVDA. (#7269)
* Při restartu NVDA, pokud je Mozilla Firefox v zaměření, režim prohlížení bude znovu dostupný, i když možná budete muset přejít sem a tam klávesami alt+tab. (#5758)
* Matematický obsah je nyní přístupný v Google Chrome, aniž by musel být v systému nainstalovaný Mozilla Firefox. (#7308)
* Operační systém a další aplikace by měly být stabilnější hned po instalaci NVDA před restartem ve srovnání s předchozími verzemi NVDA. (#7563)
* Při rozpoznávání obsahu (např. NVDA+r) NVDA ohlásí chybu, pokud není objekt již dostupný. (#7567)
* Funkčnost posunutí zpět byla opravena pro braillské řádky Freedom Scientific s levou lištou. (#7713)

## 2013.1

Highlights of this release include a more intuitive and consistent laptop keyboard layout; basic support for Microsoft PowerPoint; support for long descriptions in web browsers; and support for input of computer braille for braille displays which have a braille keyboard.

### Important

#### New Laptop Keyboard Layout

The laptop keyboard layout has been completely redesigned in order to make it more intuitive and consistent.
The new layout uses the arrow keys in combination with the NVDA key and other modifiers for review commands.

Please note the following changes to commonly used commands:

| Name |Key|
|---|---|
|Say all |NVDA+a|
|Read current line |NVDA+l|
|Read current text selection |NVDA+shift+s|
|Report status bar |NVDA+shift+end|

In addition, among other changes, all of the object navigation, text review, mouse click and synth settings ring commands have changed.
Please see the [Commands Quick Reference](keyCommands.html) document for the new keys.

### New Features

* Basic support for editing and reading Microsoft PowerPoint presentations. (#501)
* Basic support for reading and writing messages in Lotus Notes 8.5. (#543)
* Support for automatic language switching when reading documents in Microsoft Word. (#2047) 
* In Browse mode for MSHTML (e.g. Internet Explorer) and Gecko (e.g. Firefox), the existance of long descriptions are now announced. It's also possible to open the long description in a new window by pressing NVDA+d. (#809)
* Notifications in Internet Explorer 9 and above are now spoken (such as content blocking or file downloads). (#2343)
* Automatic reporting of table row and column headers is now supported for browse mode documents in Internet Explorer and other MSHTML controls. (#778)
* New language: Aragonese, Irish
* New braille translation tables: Danish grade 2, Korean grade 1. (#2737)
* Support for braille displays connected via bluetooth on a computer running the Bluetooth Stack for Windows by Toshiba. (#2419)
* Support for port selection when using Freedom Scientific displays (Automatic, USB or Bluetooth).
* Support for the BrailleNote family of notetakers from HumanWare when acting as a braille terminal for a screen reader. (#2012)
* Support for older models of Papenmeier BRAILLEX braille displays. (#2679)
* Support for input of computer braille for braille displays which have a braille keyboard. (#808)
* New keyboard settings that allow  the choice for whether NVDA should interrupt speech for typed characters and/or the Enter key. (#698)
* Support for several browsers based on Google Chrome: Rockmelt, BlackHawk, Comodo Dragon and SRWare Iron. (#2236, #2813, #2814, #2815)

### Changes

* Updated liblouis braille translator to 2.5.2. (#2737)
* The laptop keyboard layout has been completely redesigned in order to make it more intuitive and consistent. (#804)
* Updated eSpeak speech synthesizer to 1.47.11. (#2680, #3124, #3132, #3141, #3143, #3172)

### Bug Fixes

* The quick navigation keys for jumping to the next or previous separator in Browse Mode now work in Internet Explorer and other MSHTML controls. (#2781)
* If NVDA falls back to eSpeak or no speech due to the configured speech synthesizer failing when NVDA starts, the configured choice is no longer automatically set to the fallback synthesizer. This means that now, the original synthesizer will be tried again next time NVDA starts. (#2589)
* If NVDA falls back to no braille due to the configured braille display failing when NVDA starts, the configured display is no longer automatically set to no braille. This means that now, the original display will be tried again next time NVDA starts. (#2264)
* In browse mode in Mozilla applications, updates to tables are now rendered correctly. For example, in updated cells, row and column coordinates are reported and table navigation works as it should. (#2784)
* In browse mode in web browsers, certain clickable unlabelled graphics which weren't previously rendered are now rendered correctly. (#2838)
* Earlier and newer versions of SecureCRT are now supported. (#2800)
* For input  methods such as Easy Dots IME under XP, the reading string is now correctly reported.
* The candidate list in the Chinese Simplified Microsoft Pinyin input method under Windows 7 is now correctly read when changing pages with left and right arrow, and when first opening it with Home.
* When custom symbol pronunciation information is saved, the advanced "preserve" field is no longer removed. (#2852)
* When disabling automatic checking for updates, NVDA no longer has to be restarted in order for the change to fully take effect.
* NVDA no longer fails to start if an add-on cannot be removed due to its directory currently being in use by another application. (#2860)
* Tab labels in DropBox's preferences dialog can now be seen with Flat Review.
* If the input language is changed to something other than the default, NVDA now detects keys correctly for commands and input help mode.
* For languages such as German where the + (plus) sign is a single key on the keyboard, it is now possible to bind commands to it by using the word "plus". (#2898)
* In Internet Explorer and other MSHTML controls, block quotes are now reported where appropriate. (#2888)
* The HumanWare Brailliant BI/B series braille display driver can now be selected when the display is connected via Bluetooth but has never been connected via USB.
* Filtering elements in the Browse Mode Elements list with uppercase filter text now returns case-insensitive results just like lowercase rather than nothing at all. (#2951)
* In Mozilla browsers, browse mode can again be used when Flash content is focused. (#2546)
* When using a contracted braille table and expand to computer braille for the word at the cursor is enabled, the braille cursor is now positioned correctly when located after a word wherein a character is represented by multiple braille cells (e.g. capital sign, letter sign, number sign, etc.). (#2947)
* Text selection is now correctly shown on a braille display in applications such as Microsoft word 2003 and Internet Explorer edit controls.
* It is again possible to select text in a backward direction in Microsoft Word while Braille is enabled.
* When reviewing,  backspacing or deleting characters  In Scintilla edit controls, NVDA correctly announces multibyte characters. (#2855)
* NVDA will no longer fail to install when the user's profile path contains certain multibyte characters. (#2729)
* Reporting of groups for List View controls (SysListview32) in 64-bit applications no longer causes an error.
* In browse mode in Mozilla applications, text content is no longer incorrectly treated as editable in some rare cases. (#2959)
* In IBM Lotus Symphony and OpenOffice, moving the caret now moves the review cursor if appropriate.
* Adobe Flash content is now accessible in Internet Explorer in Windows 8. (#2454)
* Fixed Bluetooth support for Papenmeier Braillex Trio. (#2995)
* Fixed inability to use certain Microsoft Speech API version 5 voices such as Koba Speech 2 voices. (#2629)
* In applications using the Java Access Bridge, braille displays are now updated correctly when the caret moves in editable text fields . (#3107)
* Support the form landmark in browse mode documents that support landmarks. (#2997) 
* The eSpeak synthesizer driver now handles reading by character more appropriately (e.g. announcing a foreign letter's name or value rather than just its sound or generic name). (#3106)
* NVDA no longer fails to copy user settings for use on logon and other secure screens when the user's profile path contains non-ASCII characters. (#3092)
* NVDA no longer freezes when using Asian character input in some .NET applications. (#3005)
* it is now possible to use browse mode for pages in Internet Explorer 10 when in standards mode; e.g. [www.gmail.com](http://www.gmail.com) login page. (#3151)

## 2012.3

Highlights of this release include support for Asian character input; experimental support for touch screens on Windows 8; reporting of page numbers and improved support for tables in Adobe Reader; table navigation commands in focused table rows and Windows list-view controls; support for several more braille displays; and reporting of row and column headers in Microsoft Excel.

### New Features

* NVDA can now support Asian character input using IME and text service input methods in all applications, Including:
 * Reporting and navigation of candidate lists;
 * Reporting and navigation of composition strings; and
 * Reporting of reading strings.
* The presence of underline and strikethrough is now reported in Adobe Reader documents. (#2410)
* When the Windows Sticky Keys function is enabled, the NVDA modifier key will now behave like other modifier keys. This allows you to use the NVDA modifier key without needing to hold it down while you press other keys. (#230)
* Automatic reporting of column and row headers is now supported in Microsoft Excel. Press NVDA+shift+c to set the row containing column headers and NVDA+shift+r to set the column containing row headers. Press either command twice in quick succession to clear the setting. (#1519)
* Support for HIMS Braille Sense, Braille EDGE and SyncBraille braille displays. (#1266, #1267)
* When Windows 8 Toast notifications appear, NVDA will report them if reporting of help balloons is enabled. (#2143)
* Experimental support for Touch screens on Windows 8, including:
 * Reading text directly under your finger while moving it around
 * Many gestures for performing object navigation, text review, and other NVDA commands.
* Support for VIP Mud. (#1728)
* In Adobe Reader, if a table has a summary, it is now presented. (#2465)
* In Adobe Reader, table row and column headers can now be reported. (#2193, #2527, #2528)
* New languages: Amharic, Korean, Nepali, Slovenian.
* NVDA can now read auto complete suggestions when entering email addresses in Microsoft Outlook 2007. (#689)
* New eSpeak voice variants: Gene, Gene2. (#2512)
* In Adobe Reader, page numbers can now be reported. (#2534)
 * In Reader XI, page labels are reported where present, reflecting changes to page numbering in different sections, etc. In earlier versions, this is not possible and only sequential page numbers are reported.
* It is now possible to reset NVDA's configuration to factory defaults either by pressing NVDA+control+r three times quickly or by choosing Reset to Factory Defaults from the NVDA menu. (#2086)
* Support for the Seika Version 3, 4 and 5 and Seika80 braille displays from Nippon Telesoft. (#2452)
* The first and last top routing buttons on Freedom Scientific PAC Mate and Focus Braille displays can now be used to scroll  backward and forward. (#2556)
* Many more features are supported on Freedom Scientific Focus Braille displays such as advance bars, rocker bars and certain dot combinations for common actions. (#2516)
* In applications using IAccessible2 such as Mozilla applications, table row and column headers can now be reported outside of browse mode. (#926)
* Preliminary support for the document control in Microsoft Word 2013. (#2543)
* Text alignment can now be reported in applications using IAccessible2 such as Mozilla applications. (#2612)
* When a table row or standard Windows list-view control with multiple columns is focused, you can now use the table navigation commands to access individual cells. (#828)
* New braille translation tables: Estonian grade 0, Portuguese 8 dot computer braille, Italian 6 dot computer braille. (#2319, #2662)
* If NVDA is installed on the system, directly opening an NVDA add-on package (e.g. from Windows Explorer or after downloading in a web browser) will install it into NVDA. (#2306)
* Support for newer models of Papenmeier BRAILLEX braille displays. (#1265)
* Position information (e.g. 1 of 4) is now reported for Windows Explorer list items on Windows 7 and above. This also includes any UIAutomation controls that support the itemIndex and itemCount custom properties. (#2643)

### Changes

* In the NVDA Review Cursor preferences dialog, the Follow keyboard focus option has been renamed to Follow system focus for consistency with terminology used elsewhere in NVDA.
* When braille is tethered to review and the cursor is on an object which is not a text object (e.g. an editable text field), cursor routing keys will now activate the object. (#2386)
* The Save Settings On Exit option is now on by default for new configurations.
* When updating a previously installed copy of NVDA, the desktop shortcut key is no longer forced back to control+alt+n if it was manually changed to something different by the user. (#2572)
* The add-ons list in the Add-ons Manager now shows the package name before its status. (#2548)
* If installing the same or another version of a currently installed add-on, NVDA will ask if you wish to update the add-on, rather than just showing an error and aborting installation. (#2501)
* Object navigation commands (except the report current object command) now report with less verbosity. You can still obtain the extra information by using the report current object command. (#2560)
* Updated liblouis braille translator to 2.5.1. (#2319, #2480, #2662, #2672)
* The NVDA Key Commands Quick Reference document has been renamed to Commands Quick Reference, as it now includes touch commands as well as keyboard commands.
* The Elements list in Browse mode will now remember the last element type shown (e.g. links, headings or landmarks) each time the dialog is shown within the same session of NVDA. (#365)
* Most Metro apps in Windows 8 (e.g. Mail, Calendar) no longer activate Browse Mode for the entire app.
* Updated Handy Tech BrailleDriver COM-Server to 1.4.2.0.

### Bug Fixes

* In Windows Vista and later, NVDA no longer incorrectly treats the Windows key as being held down when unlocking Windows after locking it by pressing Windows+l. (#1856)
* In Adobe Reader, row headers are now correctly recognised as table cells; i.e. coordinates are reported and they can be accessed using table navigation commands. (#2444)
* In Adobe Reader, table cells spanning more than one column and/or row are now handled correctly. (#2437, #2438, #2450)
* The NVDA distribution package now checks its integrity before executing. (#2475)
* Temporary download files are now removed if downloading of an NVDA update fails. (#2477)
* NVDA will no longer freeze when it is running as an administrator while copying the user configuration to the system configuration (for use on Windows logon and other secure screens). (#2485)
* Tiles on the Windows 8 Start Screen are now presented better in speech and braille. The name is no longer repeated, unselected is no longer reported on all tiles, and live status information is presented  as the description of the tile (e.g. current temperature for the Weather tile).
* Passwords are no longer announced when reading password fields in Microsoft Outlook and other standard edit controls that are marked as protected. (#2021)
* In Adobe Reader, changes to form fields are now correctly reflected in browse mode. (#2529)
* Improvements to support for the Microsoft Word Spell Checker, including more accurate reading of the current spelling error, and the ability to support the spell checker when running an Installed copy of NVDA on Windows Vista or higher.
* Add-ons which include files containing non-English characters can now be installed correctly in most cases. (#2505)
* In Adobe Reader, the language of text is no longer lost when it is updated or scrolled to. (#2544)
* When installing an add-on, the confirmation dialog now correctly shows the localized name of the add-on if available. (#2422)
* In applications using UI Automation (such as .net and Silverlight applications), the calculation of numeric values for controls such as sliders has been corrected. (#2417)
* The configuration for reporting of progress bars is now honoured for the indeterminate progress bars displayed by NVDA when installing, creating a portable copy, etc. (#2574)
* NVDA commands can no longer be executed from a braille display while a secure Windows screen (such as the Lock screen) is active. (#2449)
* In browse mode, braille is now updated if the text being displayed changes. (#2074)
* When on a secure Windows screen such as the Lock screen, messages from applications speaking or displaying braille directly via NVDA are now ignored.
* In Browse mode, it is no longer possible to  fall off the bottom of the document with the right arrow key when on the final character, or by jumping to the end of a container when that container is the last item in the document. (#2463)
* Extraneous content is no longer incorrectly included when reporting the text of dialogs in web applications (specifically, ARIA dialogs with no aria-describedby attribute). (#2390)
* NVDA no longer incorrectly reports or locates certain edit fields in MSHTML documents (e.g. Internet Explorer), specifically where an explicit ARIA role has been used by the web page author. (#2435)
* The backspace key is now handled correctly when speaking typed words in Windows command consoles. (#2586)
* Cell coordinates in Microsoft Excel are now shown again in Braille.
* In Microsoft Word, NVDA no longer leaves you stuck on a paragraph with list formatting when trying to navigate out over a bullet or number with left arrow or control + left arrow. (#2402)
* In browse mode in Mozilla applications, the items in certain list boxes (specifically, ARIA list boxes) are no longer incorrectly rendered.
* In browse mode in Mozilla applications, certain controls that were rendered with an incorrect label or just whitespace are now rendered with the correct label.
* In browse mode in Mozilla applications, some extraneous whitespace has been eliminated.
* In browse mode in web browsers, certain graphics that are explicitly marked as presentational (specifically, with an alt="" attribute) are now correctly ignored.
* In web browsers, NVDA now hides content which is marked as hidden from screen readers (specifically, using the aria-hidden attribute). (#2117)
* Negative currency amounts (e.g. -$123) are now correctly spoken as negative, regardless of symbol level. (#2625)
* During say all, NVDA will no longer incorrectly revert to the default language where a line does not end a sentence. (#2630)
* Font information is now correctly detected in Adobe Reader 10.1 and later. (#2175)
* In Adobe Reader, if alternate text is provided, only that text will be rendered. Previously, extraneous text was sometimes included. (#2174)
* Where a document contains an application, the content of the application is no longer included in browse mode. This prevents unexpectedly moving inside the application when navigating. You can interact with the application in the same way as for embedded objects. (#990)
* In Mozilla applications, the value of spin buttons is now correctly reported when it changes. (#2653)
* Updated support for Adobe Digital Editions so that it works in version 2.0. (#2688)
* Pressing NVDA+upArrow while on a combo box in Internet Explorer and other MSHTML documents will no longer incorrectly read all items. Rather, just the active item will be read. (#2337)
* Speech dictionaries will now properly save when using a number (#) sign within the pattern or replacement fields. (#961)
* Browse mode for MSHTML documents (e.g. Internet Explorer) now correctly displays visible content contained within hidden content (specifically, elements with a style of visibility:visible inside an element with style visibility:hidden). (#2097)
* Links in Windows XP's Security Center no longer report random junk after their names. (#1331)
* UI Automation text controls (e.g.  the search field in the Windows 7 Start Menu) are now  correctly announced when moving the mouse over them rather than staying silent.
* Keyboard layout changes are no longer reported during say all, which was particularly problematic for multilingual documents including Arabic text. (#1676)
* The entire content of some UI Automation editable text controls (e.g. the Search Box in the Windows 7/8 Start Menu) is no longer announced every time it changes.
* When moving between groups on the Windows 8 start screen, unlabeled groups no longer announce their first tile as the name of the group. (#2658)
* When opening the Windows 8 start screen, the focus is correctly placed on the first tile, rather than jumping to the root of the start screen which can confuse navigation. (#2720)
* NVDA will no longer fail to start when the user's profile path contains certain multibyte characters. (#2729)
* In browse mode in Google Chrome, the text of tabs is now rendered correctly.
* In browse mode, menu buttons are now reported correctly.
* In OpenOffice.org/LibreOffice Calc, reading spreadsheet cells now works correctly. (#2765)
* NVDA can again function in the Yahoo! Mail message list when used from Internet Explorer. (#2780)

## 2012.2.1

This release addresses  several potential security issues (by upgrading Python to 2.7.3).

## 2012.2

Highlights of this release include an in-built installer and  portable  creation feature, automatic updates, easy management of new NVDA add-ons, announcement of graphics in Microsoft Word, support for Windows 8 Metro style apps, and several important bug fixes. 

### New Features

* NVDA can now automatically check for, download and install updates. (#73)
* Extending NVDA's functionality  has been made easier with the addition of an Add-ons Manager (found under Tools in the NVDA menu) allowing you to install and uninstall new NVDA add-on packages (.nvda-addon files) containing plugins and drivers. Note the Add-on manager does not show older custom plugins and drivers manually copied in to your configuration directory. (#213)
* Many more common NVDA features now work in Windows 8 Metro style apps when using an installed release  of NVDA, including speaking of typed characters, and browse mode for web documents (includes support for metro version of Internet Explorer 10). Portable copies of NVDA cannot access metro style apps. (#1801) 
* In browse mode documents (Internet Explorer, Firefox, etc.), you can now  jump to the start and past the end of certain containing elements (such as lists and tables) with shift+, and , respectively. (#123)
* New language: Greek.
* Graphics and alt text are now reported in Microsoft Word Documents. (#2282, #1541)

### Changes

* Announcement of cell coordinates in Microsoft Excel is now after the content rather than before, and is now only included   if the report tables and report table cell coordinates settings are enabled in the Document formatting settings dialog. (#320)
* NVDA is now distributed in one package. Rather than separate portable and installer versions, there is now just one file that, when run, will start a temporary copy of NVDA and will allow you to install or generate a portable distribution. (#1715)
* NVDA is now always installed in to Program Files on all systems. Updating a previous install will also automatically move it if it was not previously installed there.

### Bug Fixes

* With auto language switching enabled, Content such as alt text for graphics and labels for other certain controls in Mozilla Gecko (e.g. Firefox) are now reported in the correct language if marked up appropriately.
* SayAll in BibleSeeker (and other TRxRichEdit controls) no longer stops in the middle of a passage.
* Lists found in the Windows 8 Explorer file properties (permitions tab) and in Windows 8 Windows Update now read correctly.
* Fixed possible freezes in MS Word which would result when it took more than 2 seconds to fetch text from a document (extremely long lines or tables of contents). (#2191)
* Detection of word breaks now works correctly where whitespace is followed by certain punctuation. (#1656)
* In browse mode in Adobe Reader, it is now possible to navigate to headings without a level using quick navigation and the Elements List. (#2181)
* In Winamp, braille is now correctly updated when you move to a different item in the Playlist Editor. (#1912)
* The tree in the Elements List (available for browse mode documents) is now properly sized to show  the text of each element. (#2276)
* In applications using the Java Access Bridge, editable text fields are now presented correctly in braille. (#2284)
* In applications using the java Access Bridge, editable text fields no longer report strange characters in certain circumstances. (#1892)
* In applications using the Java Access Bridge, when at the end of an editable text field, the current line is now reported correctly. (#1892)
* In browse mode in applications using Mozilla Gecko 14 and later (e.g. Firefox 14), quick navigation now works for block quotes and embedded objects. (#2287)
* In Internet Explorer 9, NVDA no longer reads unwanted content when focus moves inside certain landmarks or focusable elements (specifically, a div element which is focusable or has an ARIA landmark role).
* The NVDA icon for the NVDA Desktop and Start Menu shortcuts is now displayed correctly on 64 bit editions of Windows. (#354)

## 2012.1

Highlights of this release include features for more fluent reading of braille; indication of document formatting in braille; access to much more formatting information and improved performance in Microsoft Word; and support for the iTunes Store.

### New Features

* NVDA can announce the number of leading tabs and spaces of the current line in the order that they are entered. This can be enabled by selecting report line indentation in the document formatting dialogue. (#373)
* NVDA can now detect key presses generated from alternative keyboard input emulation such as on-screen keyboards and speech recognition software.
* NVDA can now detect colors in Windows command consoles.
* Bold, italic and underline are now indicated in braille using signs appropriate to the configured translation table. (#538)
* Much more information is now reported in Microsoft Word documents, including:
 * Inline information such as footnote and endnote numbers, heading levels, the existance of comments, table nesting levels, links, and text color;
 * Reporting when entering document sections such as the comments story, footnotes and endnotes stories, and header and footer stories.
* Braille now indicates selected text using dots 7 and 8. (#889)
* Braille now reports information about controls within documents such as links, buttons and headings. (#202)
* Support for the hedo ProfiLine and MobilLine USB braille displays. (#1863, #1897)
* NVDA now avoids splitting words in braille when possible by default. This can be disabled in the Braille Settings dialog. (#1890, #1946)
* It is now possible to have braille displayed by paragraphs instead of lines, which may allow for more fluent reading of large amounts of text. This is configurable using the Read by paragraphs option in the Braille Settings dialog. (#1891)
* In browse mode, you can activate the object under the cursor using a braille display. This is done by pressing the cursor routing key where the cursor is located (which means pressing it twice if the cursor is not already there). (#1893)
* Basic support for web areas in iTunes such as the Store. Other applications using WebKit 1 may also be supported. (#734)
* In books in Adobe Digital Editions 1.8.1 and later, pages are now turned automatically when using say all. (#1978)
* New braille translation tables: Portuguese grade 2, Icelandic 8 dot computer braille, Tamil grade 1, Spanish 8 dot computer braille, Farsi grade 1. (#2014)
* You can now configure whether frames in documents are reported from the Document Formatting preferences dialog. (#1900)
* Sleep mode is automatically enabled when using OpenBook. (#1209)
* In Poedit, translators can now read translator added and automatically extracted comments. Messages that are untranslated or fuzzy are marked with a star and a beep is heard when you navigate onto them. (#1811)
* Support for the HumanWare Brailliant BI and B series displays. (#1990)
* New languages: Norwegian Bokmål, Traditional Chinese (Hong Kong).

### Changes

* Commands to describe the current character or to spell the current word or line now will spell in the appropriate language according to the text, if auto language switching is turned on and the appropriate language information is available.
* Updated eSpeak speech synthesizer to 1.46.02.
* NVDA will now truncate extremely long (30 characters or greater) names guessed from graphic and link URLs as they are most likely garbage that gets in the way of reading. (#1989)
* Some information displayed in braille has been abbreviated. (#1955, #2043)
* When the caret or review cursor moves, braille is now scrolled in the same way as when it is manually scrolled. This makes it more appropriate when braille is configured to read by paragraphs and/or avoid splitting words. (#1996)
* Updated to new Spanish grade 1 braille translation table.
* Updated liblouis braille translator to 2.4.1.

### Bug Fixes

* In Windows 8, focus is no longer incorrectly moved away from the Windows Explorer search field, which was not allowing NVDA to interact with it.
* Major performance improvements when reading and navigating Microsoft Word documents while automatic reporting of formatting is enabled, thus now making it quite comfortable to proof read formatting etc. Performance may be also improved over all for some users.
* Browse mode is now used for full screen Adobe Flash content.
* Fixed poor audio quality in some cases when using Microsoft Speech API version 5 voices with the audio output device set to something other than the default (Microsoft Sound Mapper). (#749)
* Again allow NVDA to be used with the "no speech" synthesizer, relying purely on braille or the speech viewer. (#1963)
* Object navigation commands no longer report "No children" and "No parents", but instead report messages consistent with the documentation.
* When NVDA is configured to use a language other than English, the name of the tab key is now reported in the correct language.
* In Mozilla Gecko (e.g. Firefox), NVDA no longer intermittently switches to browse mode while navigating menus in documents. (#2025)
* In Calculator, the backspace key now reports the updated result instead of reporting nothing. (#2030)
* In browse mode, the move mouse to current navigator object command now routes to the center of the object at the review cursor instead of the top left, making it more accurate it some cases. (#2029)
* In browse mode with automatic focus mode for focus changes enabled, focusing on a toolbar will now switch to focus mode. (#1339)
* The report title command works correctly again in Adobe Reader.
* With automatic focus mode for focus changes enabled, focus mode is now correctly used for focused table cells; e.g. in ARIA grids. (#1763)
* In iTunes, position information in certain lists is now reported correctly.
* In Adobe Reader, some links are no longer treated as containing read-only editable text fields.
* The labels of some editable text fields are no longer incorrectly included when reporting the text of a dialog. (#1960)
* The description of groupings is once again reported if reporting of object descriptions is enabled.
* The human readable sizes are now included in the text of the Windows Explorer drive properties dialog.
* Double reporting of property page text has been suppressed in some cases. (#218)
* Improved tracking of the caret in editable text fields which rely on text written to the screen. In particular, this improves editing in the Microsoft Excel cell editor and the Eudora message editor. (#1658)
* In Firefox 11, the move to containing virtual buffer command (NVDA+control+space) now works as it should to escape embedded objects such as Flash content.
* NVDA now restarts itself correctly (e.g. after changing the configured language) when it is located in a directory which contains non-ASCII characters. (#2079)
* Braille correctly respects the settings for reporting of object shortcut keys, position information and descriptions.
* In Mozilla applications, switching between browse and focus modes is no longer slow with braille enabled. (#2095)
* Routing the cursor to the space at the end of the line/paragraph using braille cursor routing keys in some editable text fields now works correctly instead of routing to the start of the text. (#2096)
* NVDA again works correctly with the Audiologic Tts3 synthesizer. (#2109)
* Microsoft Word documents are correctly treated as multi-line. This causes braille to behave more appropriately when a document is focused.
* In Microsoft Internet Explorer, errors no longer occur when focusing on certain rare controls. (#2121)
* Changing the pronunciation of punctuation/symbols by the user will now take effect straight away, rather than requiring NVDA to be restarted or auto language switching to be disabled.
* When using eSpeak, speech no longer goes silent in some cases in the Save As dialog of the NVDA Log Viewer. (#2145)

## 2011.3

### Novinky

-V aplikacích Mozilla Gecko je při použití objektové navigace ohlašovaná úroveň nadpisů. 
-V aplikacích Mozilla je v režimu prohlížení možné ohlašovat formátování textu. (#394) 
-NVDA dokáže detekovat podtržený a přeškrtnutý text v editačních polích IAccessible2 (např. v aplikacích Mozilla). 
-Po pádu se NVDA automaticky restartuje. 

### Opravy

•V programu internet explorer a ostatních prvcích MSHTML NVDA nebude oznamovat odrážky a číslování v seznamech, pokud autor nastavil, že se tyto informace nemají zobrazovat (styl seznamu je none). (#1671) 
-Restart NVDA po zamrznutí (např. stiskem kláves Ctrl+Alt+N) nespustí znovu NVDA dřív, než se ukončí zamrznutá kopie.

## 2011.2

Mezi hlavní novinky této verze patří četná vylepšení v oblasti vyslovování interpunkčních a dalších speciálních znaků; nastavitelné úrovně vyslovování interpunkce; vlastní pojmenování interpunkčních a dalších znaků; hláskování pomocí hláskovací tabulky; žádné pauzy na koncích řádků při plynulém čtení; vylepšená podpora ARIA v Internet Exploreru; vylepšená podpora pro PDF dokumenty XFA/LifeCycle v Adobe Readeru; přístup k textu vypsanému přímo na obrazovku ve více aplikacích než doposud; a přístup k informacím o formátování a barvě textu vypsaného na obrazovku.

### Novinky

* Pokud dvakrát rychle po sobě stisknete klávesu pro přečtení aktuálního znaku, znak bude vyhláskován pomocí hláskovací tabulky. 
V případě jazyků s obrázkovým písmem jako je tradiční čínština bude ohlášen jeden nebo více příkladů frází, které lze vyjádřit daným symbolem. Pokud třikrát Rychle po sobě stisknete klávesu pro přečtení aktuálního slova či řádku, bude slovo nebo řádek rovněž vyhláskován pomocí hláskovací tabulky.(#55)
* V režimu plošného prohlížení je nyní možné číst více textu v aplikacích jako je např. Mozilla Thunderbird.
* Nyní je možné vybrat si z několika úrovní vyslovování interpunkčních a dalších speciálních znaků. (#332)
* Pokud se interpunkční znaménko nebo jiný symbol opakuje více než čtyřikrát za sebou, je ohlášen počet opakování místo opakovaného čtení znaku. (#43)
* Nové braillské překladové tabulky: Norské - 8-bodové počítačové písmo, etiopský plnopis, slovinský plnopis, Srbský plnopis. (#1456)
* Při plynulém čtení byly odstraněny nepřirozené pauzy v řeči na konci řádků. (#149)
* NVDA nyní ve webových prohlížečích oznamuje seřazené položky (vlastnost aria-sort). (#1500)
* Braillské znaky zapsané v kódu unicode jsou nyní správně zobrazovány na braillských řádcích. (#1505)
* Když se v Internet Exploreru a nebo jiných MSHTML prvcích přesune fokus do seskupení prvků uzavřeného do tagu fieldset, NVDA ohlásí název seskupení (vlastnost legend). (#535)
* V Internet Exploreru a ostatních MSHTML prvcích je brán ohled na vlastnosti aria-labelledBy a aria-describedBy.
* V Internet Exploreru a ostatních MSHTML prvcích byla vylepšena podpora pro prvky aria seznam, buňku mřížky, posuvník a indikátor průběhu.
* Uživatelé mohou měnit jak vyslovování interpunkce a dalších znaků, Tak i úroveň výřečnosti, ve které mají být znaky ohlašovány. (#271, #1516)
* V aplikaci Microsoft Excel je nyní při pohybu po sešitech pomocí kláves Ctrl+PageUp a Ctrl+PageDown ohlašováno jméno aktuálního sešitu. (#760)
* V aplikaci Microsoft Word bude nyní při pohybu po tabulce pomocí klávesy Tab NVDA ohlašovat aktuální buňku. (#159)
* V dialogu ohlašování formátování dokumentu je možné nastavit oznamování souřadnic buněk v tabulkách. (#719)
* NVDA nyní dokáže detekovat formátování a barvu textu vypisovaného přímo na obrazovku.
* V seznamu správ v programech Outlook express, Windows mail a Windows live bude NVDA ohlašovat, že správa je nepřečtená a rovněž stav konverzací. (#868)
* Při použití hlasového výstupu eSpeak je v dialogu nastavení hlasu možné aktivovat volbu znásobit tempo, která trojnásobně zrychlí tempo řeči eSpeaku.
* Podpora pro prvek kalendář v dialogu datum a čas, který je  možné vyvolat z hodin v systému Windows 7. (#1637)
* Byly přidané klávesové zkratky pro braillský řádek MDV Lilli. (#241)
* Nové lokalizace: bulharština, albánština.

### Změny

* Pro přesunutí textového kurzoru na čtecí kurzor nyní použijte dvojitý stisk klávesové zkratky pro přesun fokusu na prohlížený objekt (desktop NVDA+Shift+numerické mínus, laptop NVDA+Shift+Backspace) Tím se uvolnilo více kláves pro případné použití do budoucna. (#837)
* Pro ohlášení desítkové a šestnáctkové ascii hodnoty znaku stiskněte klávesu pro přečtení aktuálního znaku třikrát. Dvojitý stisk je používán pro vyhláskování znaku pomocí hláskovací tabulky.
* Hlasový výstup eSpeak byl aktualizován na verzi 1.45.03. (#1465)
* V aplikacích Mozilla už při pohybu ve formulářovém režimu nejsou oznamovány vzhledové tabulky.
* V Internet Exploreru a dalších prvcích MSHTML funguje režim prohlížení i v dokumentech uvnitř ARIA aplikací. (#1452)
* Překladač do braillova písma liblouis byl aktualizován na verzi 2.3.0.
* Pokud v režimu prohlížení přejdete pomocí rychlé navigace nebo pomocí kurzoru na nějaký prvek, je ohlášen jeho popis, pokud nějaký má.
* V režimu prohlížení jsou nyní oznamovány indikátory průběhu.
* Prvky ARIA označené typem presentation nejsou v Internet Exploreru a ostatních MSHTML prvcích oznamovány ve zjednodušeném režimu objektové navigace ani při oznamování fokusu.
* Uživatelské rozhraní a dokumentace NVDA místo označení virtuální prohlížeč používá označení režim prohlížení, protože termín virtuální prohlížeč většině uživatelů nic neříká. (#1509)
* Pokud chcete zkopírovat své nastavení do systémového profilu např. pro použití na přihlašovací obrazovce a vaše nastavení obsahuje uživatelské zásuvné moduly, budete upozorněni, že se můžete vystavit bezpečnostnímu riziku. (#1426)
* Služba NVDA už nezastavuje a opětovně nnespouští NVDA na uživatelských vstupních plochách.
* Na systémech Windows XP a Windows Vista již NVDA nepoužívá UI automation, i když je tato funkce dostupná. Přestože UI automation vylepšuje přístupnost některých moderních aplikací, tak při jeho použití na těchto systémech docházelo k mrznutí, pádům a dalším problémům. (#1437)
* v Aplikacích používajících Mozilla Gecko 2 a novější, jako je např. Firefox od verze 4, může být dokument v režimu prohlížení přístupný už před tím, než je plně načten.
* NVDA hlásí stav okna, pokud se pohybujete po prvcích uvnitř. Např. pokud se pohybujete uvnitř dokumentu, který se teprve načítá, NVDA ohlásí "zaneprázdněn".
* Pro některé položky v nabídkách, které mají podnabídky už není hlášeno "sbaleno". 
* Příkaz pro ohlášení formátování NVDA+f už neoznamuje formátování na pozici textového, ale na pozici čtecího kurzoru. Ve výchozím nastavení se čtecí kurzor pohybuje spolu s textovým kurzorem, takže většina uživatelů si změny ani nevšimne. Nicméně díky této změně je nyní možné zjistit informace o formátování při čtení čtecím kurzorem např. v režimu plošného prohlížení

### Opravy

* Jestliže byl formulářový režim zapnut pomocí kláves NVDA+mezerník, sbalení rozbalovacího políčka už nepřepíná automaticky zpět do režimu prohlížení. (#1386)
* V dokumentech Gecko a MSHTML je nyní text nacházející se na jednom řádku správně interpretován rovněž na jednom řádku. Ve starších verzích NVDA byl rozdělen do více řádků. (#1378)
* Pokud je braillský kurzor propojen se čtecím kurzorem a prohlíženým objektem se ať už ručně nebo kvůli změně fokusu stane dokument v režimu prohlížení, na braillském řádku bude správně zobrazen obsah dokumentu. (#1406, #1407)
* Pokud je vypnuto čtení interpunkce, již není nesprávně čtena některými hlasovými výstupy. (#332)
* Byly odstraněny problémy při načítání nastavení hlasových výstupů, které nepodporují nastavení hlasu jako např. Audiologic Tts3. (#1347)
* Nabídka doplňky v programu Skype je nyní čtena správně. (#648)
* Zaškrtnutí políčka Úroveň jasu ovlivňuje hlasitost zvukové signalizace v dialogu nastavení myši už nezpůsobuje problémy při posouvání myši ve Windows vista / 7 se zapnutým aero. 
* Pokud používáte rozložení kláves pro laptop, klávesová zkratka NVDA+delete správně oznámí rozměry prohlíženého objektu.
* V dokumentech MSHTML už správně funguje atribut aria-selected.
* Když se NVDA automaticky přepne z režimu prohlížení do formulářového režimu, je nejprve ohlášena informace o zaměřeném objektu. Např. pokud se fokus nachází na seznamu, bude hned po aktivaci formulářového režimu ohlášen seznam. (#1491)
* V Internet Exploreru a ostatních MSHTML dokumentech jsou prvky aria listbox oznamovány jako seznamy a ne jako položky seznamu.
* Pokud se fokus nachází na editačním poli jen pro čtení, NVDA to ohlásí. (#1436)
* V režimu prohlížení NVDA nyní správně zpracovává editační pole jen pro čtení.
* Při práci s prvkem, který má nastaven atribut aria-activedescendant (automatické dokončování v některých seznamech a pod.), už NVDA chybně nepřepíná z formulářového režimu do režimu prohlížení.
* V programu adobe reader je nyní při změně fokusu nebo při použití příkazů rychlé navigace ohlašován název prvku.
* V dokumentech XFA PDF v Adobe Readeru jsou správně čtena tlačítka, odkazy a obrázky.
* V dokumentech XFA PDF v Adobe Readeru je nyní každý prvek zobrazen na odděleném řádku. Tato změna byla provedena protože kvůli špatnému strukturování těchto dokumentů byly někdy zobrazeny velké části i celé dokumenty na jednom řádku.
* Opraveny chyby při pohybu po editačních polích v XFA PDF v Adobe Readeru.
* Pokud v XFA PDF dokumentu dojde ke změně hodnoty rozbalovacího políčka, NVDA to ohlásí.
* Nyní jsou zpřístupněny nestandardní rozbalovací seznamy jako např. seznam určený pro výběr barvy v programu Outlook Express. (#1340)
* U jazyků, které používají mezeru jako oddělovač tisíců jsou mezerou oddělené skupiny číslic čteny jako samostatná čísla. Způsobovalo to problémy například v buňkách tabulky obsahujících čísla (#555)
* V dokumentech MSHTML jsou Prvky typu ARIA description zobrazeny jako text a ne jako editační pole.
* Opraveny různé problémy s klávesou Tab při fokusu v dokumentu Internet Exploreru v režimu prohlížení (např. nesprávný odskok do adresního řádku při stisku klávesy Tab)
* Ve výukovém režimu jsou do log souboru zaznamenávány i příkazy, jejichž skripty vynechávají výukový režim jako např. příkazy na posunutí braillského řádku vpřed či zpět.
* Pokud ve výukovém režimu držíte stisknutou NVDA klávesu , již nedochází k hlášení, jako by klávesa působila sama na sebe, např. NVDA+NVDA. To je nesmysl a bylo to opraveno.
* Přesun na další nebo předchozí rozbalovací políčko v dokumentech Adobe Reader pomocí kláves c nebo shift+c již funguje.
* Pokud je možno označit řádky tabulky, je oznámeno jestli jsou vybrány nebo ne, stejně jako tomu je u položek seznamů a stromových zobrazení.
* Ve Firefoxu a dalších Gecko aplikacích je možné v režimu prohlížení aktivovat prvek i když již není viditelný na obrazovce. (#801)
* Pokud je zobrazen dialog se zprávou, nemůžete vyvolat dialog s nastavením NVDA, protože v takovém případě okno s nastavením způsobovalo mrznutí programu. (#1451)
* V aplikaci Microsoft Excel již není patrná prodleva když rychle označujete nebo se pohybujete po buňkách.
* Opraveny občasné pády služby NVDA, které způsobovaly že NVDA nemluvilo na zabezpečených obrazovkách.
* Opraven problém s braillskými řádky, kdy změna způsobovala zmizení zobrazeného textu.
* Okno pro stahování v Internet Exploreru 9 je nyní možné používat s NVDA. (#1280)
* Bylo zabráněno nechtěným spuštěním více instancí NVDA současně. (#507)
* Na pomalých systémech již NVDA při běhu nezobrazuje své hlavní okno. (#726)
* Při spuštění WPF aplikace na systémech Windows XP již NVDA nepadá. (#1437)
* Plynulé čtení a plynulé čtení čtecím kurzorem funguje v některých textových prvcích, které podporují patřičné metody UI automation. Takže je třeba možné použít plynulé čtení čtecím kurzorem v dokumentech XPS.
* V aplikacích Outlook Express a Windows Live Mail v dialogu Použít Pravidla už NVDA chybně neoznačuje některé seznamy jako zaškrtávací políčka. (#576)
* U rozbalovacích políček už není chybně hlášena podnabídka.
* NVDA už dokáže číst příjemce v polích komu, kopie a skrytá kopie v aplikaci Microsoft Outlook. (#421)

= 2011.1.1 =
Tato verze opravuje některé bezpečnostní problémy a jiné závažné chyby ve verzi 2011.1.

== Opravy ==
* Položka darovat v nabídce NVDA není zobrazená na přihlašovací a ostatních zabezpečených obrazovkách Windows, protože je to bezpečnostní riziko. (#1419)
* Při běhu NVDA na přihlašovací nebo jiných zabezpečených obrazovkách Windows není možné používat funkce kopírovat, vyjmout a vložit, protože to představuje bezpečnostní riziko. (#1421)
* V programu Firefox 4 správně funguje klávesová zkratka NVDA+Ctrl+mezerník na přechod do nadřazeného virtuálního prohlížeče. Tímto způsobem je opět možné opustit vnořené objekty např. prvky Adobe flash. (#1429)
* Pokud je zapnuté ohlašování příkazových kláves, NVDA už nečte písmena stisknutá v kombinaci s klávesou Shift jako příkazové klávesy. (#1422)
* Pokud je zapnuté ohlašování příkazových kláves, NVDA nyní správně ohlašuje stisk mezerníku spolu s  jakoukoliv modifikační klávesou kromě shiftu jako příkaz. (#1424)
* Záznam logu do souboru je při běhu NVDA na přihlašovací a dalších zabezpečených obrazovkách Windows zakázaný, protože je to bezpečnostní riziko. (#1435)

## 2011.1

Nejvýznamnější novinky v této verzi jsou:
Automatické ohlašování nového výstupního textu v aplikacích mIRC, PuTTY, Tera Term a SecureCRT;
Podpora pro globální zásuvné moduly; Ohlašování odrážek a číslování v aplikaci Microsoft Word; Další vztupní příkazy pro braillské řádky včetně příkazů na posouvání po řádcích; podpora pro některé braillské řádky Baum, HumanWare a APH; a podpora ohlašování barev v některých prvcích např. v editačních polích programu IBM Lotus Symphony.

### Novinky

* Pro některé objekty lze nastavit ohlašování barev. Automatické oznamování změny barvy je možné nastavit v dialogu Ohlašování formátování dokumentu. Aktuální barvu je rovněž možné zjistit použitím funkce informace o formátování (NVDA+F)
 * Tato funkce je prozatím podporována ve standardních editačních polích IAccessible2 (např. v aplikacích Mozilla), prvcích RichEdit (např. Wordpad) a editačních polích IBM Lotus Symphony.
* Ve virtuálním prohlížeči nyní můžete označovat po stranách použitím kláves Shift+Pageup a Shift+Pagedown a po odstavcích klávesami Shift+Šipka nahoru a Shift+Šipka dolů. (#639)
* NVDA nyní automaticky ohlašuje nový text  v programech mIRC, PuTTY, Tera Term a SecureCRT. (#936)
* Uživatelé si mohou přidat nové nebo upravit existující klávesové zkratky k jakémukoli skriptu vytvořením uživatelské mapy vstupních příkazů. (#194)
* Podpora pro globální zásuvné moduly. Globální zásuvné moduly mohou přidat nové funkce do NVDA, které jsou potom k dispozici v jakékoli aplikaci (#281)
* Jestliže je při psaní zapnuta klávesa Caps lock a zároveň je přistisknuta klávesa Shift, NVDA krátce pípne. Tuto funkci lze vypnout odškrtnutím nové volby v dialogu nastavení klávesnice. (#663)
* Při pohybu po řádcích v programu Microsoft Word jsou nyní oznamovány pevné konce stránek. (#758)
* Při pohybu po řádcích v programu Microsoft Word jsou nyní čteny odrážky a číslování. (#208)
* Byl přidán klávesový příkaz na přepínání režimu spánku pro aktuální aplikaci (NVDA+Shift+S). Režim spánku pro aktuální aplikaci doposud známý jako režim samoozvučení pozastaví veškeré funkce odečítače obrazovky pro aplikaci, jejíž okno je v popředí. To je užitečné např. v samoozvučujících aplikacích, které poskytují svoji vlastní podporu pro hlasový výstup. Opětovným stiskem této klávesové zkratky režim spánku vypnete.
* Byly přidány další klávesové příkazy pro Braillské řádky. Více informací se dočtete v uživatelské příručce v kapitole podporované braillské řádky (#209)
* Abychom ulehčili práci případným dalšým vývojářům, lze nyní znovu načíst aplikační a globální zásuvné moduly bez nutnosti restartu NVDA. Použijte položku Znovu načíst zásuvné moduly z nabídky nástroje nebo klávesovou zkratku NVDA+Ctrl+F3. (#544)
* Nyní si NVDA pamatuje pozici ve virtuálním prohlížeči a při návratu na navštívenou stránku tuto pozici obnový. Toto platí, dokud neukončíte NVDA nebo prohlížeč. (#132)
* Brailské řádky Handy Tech lze nyní používat bez nutnosti instalace univerzálního ovladače Handy Tech. (#854)
* Podpora pro některé braillské řádky Baum, HumanWare a APH (#937)
* Stavový řádek v aplikaci Media Player Classic Home Cinema je nyní správně detekován. .
* Brailský řádek Freedom Scientific Focus 40 Blue lze nyní používat, i když je připojen přes Bluetooth. (#1345)

### Změny

* Informace o pozici pro některé prvky není standardně ohlašována , protože nebývá dostatečně přesná. Jedná se např. o některé nabídky nebo o úlohovou či systémovou lištu. Lze to ale povolit v dialogu Prezentace objektů.
* Klávesová nápověda byla přejmenovaná na výukový režim, protože poskytuje nápovědu nejen pro klávesnici, ale i pro ostatní vstupní zařízení.
* Ve výukovém režimu už není ohlašováno umístění skriptu, protože to pro uživatele není důležité. Nicméně pro vývojáře nebo pro pokročilé uživatele je tato informace dostupná v log souboru.
* Když NVDA detekuje zamrznutí, i nadále zachytává stisk NVDA klávesy, přičemž ostatní klávesy propouští do systému. To zabrání nechtěnnému přepínání klávesy Caps lock. (#939)
* Pokud po vyvolání příkazu pro propouštění kláves stisknete nějakou kombinaci více kláves a nějaké další přistisknete, nvda je všechny bude propouštět operačnímu systému, dokud neuvolníte poslední stisknutou klávesu
* Pokud stisknete klávesu NVDA dvakrát rychle po sobě, aby byla propuštěna, tak každé další stisknutí této klávesy bude rovněž propuštěné do operačního systému.
* Ve výukovém režimu jsou nyní ohlašované klávesy určené na ovládáníhlasitosti.

### Opravy

* Dialog pro přidání nové položky do řečového slovníku je nyní pojmenován Přidat položku do slovníku namísto původního názvu Upravit položku slovníku. (#924)
* V dialozích řečových slovníků je obsah sloupců Rozlišovat velikost písmen a Regulární výraz zobrazován v jazyce nastaveném v programu NVDA. Doposud byli tyto informace dostupné jen v angličtině.
* Ve stromových seznamech programu AIM je správně oznamovaná informace o pozici.
* V dialogu Nastavení hlasu je možné použít klávesy šipka nahoru a page up na zvíšení a šipka dolů a page down na snížení nastavení posuvníků. Doposud to fungovalo přesně naopak, což bylo nelogické a nezhodovalo se to s chováním kruhu nastavení hlasového výstupu. (#221)
* Je-li vypnutá volba zachovat stejný vzhled jako na obrazovce, tak se Ve virtuálním prohlížeči už nezobrazují nadbitečné prázdné řádky.
* Jestliže stisknete klávesu NVDA  dvakrát rychle po sobě a k tomu stisknete další klávesy, tak každé následné stisknutí klávesy NVDA nebude propuštěné do systému.
* Ve výukovém režimu jsou nyní čteny interpunkční znaky, i když je ohlašování interpunkce vypnuté. (#977)
* V dialogu nastavení klávesnice jsou názvy  rozložení klávesnice zobrazeny v jazyce nastaveném v programu NVDA a ne v angličtině. (#558)
* Byl opraven problém, který způsoboval, že některé prvky byli ve virtuálním prohlížeči adobe readeru zobrazené jako prázdné např. odkazy v uživatelské příručce Apple iPhone IOS 4.1.
* Tlačítko "Použít aktuální nastavení NVDA pro přihlašovací a další zabezpečené obrazovky" v dialogu obecné nastavení je možné použít hned po instalaci NVDA. Dříve, pokud nebyla před použitím tohoto tlačítka zobrazená zabezpečená obrazovka, NVDA oznámil, že kopírování bylo úspěšné, ale akce neměla žádný efekt. (#1194)
* V této verzi už není možné mít otevřených několik dialogů s nastavením NVDA současně. To opravuje problémy s nastaveními v otevřeném dialogu, která jsou závislá na nastaveních z druhého otevřeného dialogu (např. změna hlasového výstupu při otevřeném dialogu nastavení hlasu). (#603)
* V systémech se zapnutou kontrolou UAC už tlačítko "Použít aktuální nastavení NVDA pro přihlašovací a další zabezpečené obrazovky" po zobrazení dialogu UAC pracuje správně, i když jméno aktuálně přihlášeného uživatele systému obsahuje mezeru. (#918)
* V programu internet explorer a ostatních prvcích MSHTML NVDA použije URL odkazu v případě, že není k dispozici žádný text nebo název. (#633)
* NVDA už neignoruje fokus v nabídkách programu AOL Instant Messenger 7. (#655)
* NVDA nyní správně ohlašuje názvy chyb v dialogu kontrola pravopisu programu Microsoft word (např. není ve slovníku, pravopisná chyba, interpunkce). Doposud byly všechny chyby ohlašované jako pravopisná chyba. (#883)
* Psaní v programu microsoft word se zapnutým brailským řádkem by už nemělo způsobovat vkládání náhodného textu, a rovněž byla opravena chyba, která při stisku směrovacích tlačítek na braillském řádku způsobovala zamrznutí NVDA. (#1212) nicméně problémem zůstává fakt, že v programu Word 2003 a starších není možné číst text ve směru zprava do leva (např. arabský text) spolu s braillským řádkem. (#627)
* Po stisku klávesy delete v editačním poli je správně aktualizovaný text a pozice kurzoru na braillském řádku. (#947)
* Dynamické změny v gecko 2 dokumentech (např. Firefox 4) jsou nyní Programem NVDA správně zpracované. Doposud byli zpracované jen změny na první otevřené kartě. (Mozilla bug 610985)
* NVDA dokáže správně oznamovat seznam návrhů v dialogu kontrola pravopisu programu Microsoft word. (#704)
* V programu internet explorer a jiných prvcích MSHTML už NVDA ve virtuálním prohlížeči nezobrazuje cíle odkazů do této stránky , ale jsou správně skryté tak, jak by měli být. (#1326)
* Objektová navigace přes a uvnitř seskupení už není nesimetrická.
* Ve Firefoxu se již NVDA nezasekne ve vnořeném rámci pokud se jeho obsah načte dřív než obsah nadřazeného dokumentu.
* NVDA správně oznámí následující znak, pokud se pro vymazání aktuálního znaku použije numerický delete. (#286)
* na přihlašovací obrazovce Windows XP je při změně uživatele opět správně ohlášeno uživatelské jméno.
* Opraveny problémy při čtení textu z příkazového řádku, pokud je zapnuto ohlašování čísel řádků.
* Dialog seznam prvků ve virtuálním prohlížeči je nyní použitelný i pro vidící uživatele. Všechny prvky jsou viditelné na obrazovce. (#1321)
* Seznam položek v dialozích řečových slovníků je nyní lépe čitelný  pro vidící uživatele. Seznam je dostatečně široký, aby se všechny sloupce vešli na obrazovku. (#90)
* Na braillských řádcích ALVA BC640/BC680 už NVDA neopomíná klávesy, které zůstávají stisknuté i po uvolnění jiných kláves.
* Adobe Reader už nepadá po opuštění dialogu "neotagovaný dokument" před tím, než začne samotné zpracování dokumentu. (#1218)
* Při znovu načtení konfigurace NVDA je nyní načten správný ovladač braillského řádku. (#1346)
* průvodce projektem v programu Visual Studio 2008 je opět správně přečtený. (#974)
* NVDA už neodmítá pracovat v aplikacích, jejichž spustitelný soubor obsahuje v názvu jiné než ascii znaky. (#1352)
* Při zapnutém zalamování v programu Akelpad NVDA Při čtení po řádcích už nečte na konci řádku první písmeno následujícího řádku.
* V editoru kódu programů Visual Studio 2005/2008 NVDA už nečte celý text po každém napsaném znaku. (#975)
* Byl Opraven problém, když při změně braillského řádku nebo při ukončení NVDA nebyly některé řádky správně smazané.
* Po spuštění NVDA už čas od času není informace o aktivním prvku oznamovaná dvakrát. (#1359)

## 2010.2

K nejvýznamnějším změnám v této verzi patří výrazně zjednodušená objektová navigace; virtuální prohlížeč pro obsah Adobe flash; přístup k četným dosud nepřístupným prvkům získáváním textu vykresleného na obrazovku; možnost plošného prohlížení textu na obrazovce; podpora pro dokumenty IBM Lotus Symphony; ohlašování záhlaví řádků a sloupců tabulek v programu Mozilla Firefox; a výrazně přepracovaná uživatelská dokumentace.

### Novinky

* Prohlížení objektů čtecím kurzorem bylo výrazně zjednodušeno. Kurzor nyní ignoruje objekty, které nejsou pro uživatele důležité; tj. nepřístupné objekty a objekty, které plní pouze funkci vylepšení vzhledu.
* NVDA nyní umí ohlašovat formátování textových prvků i v aplikacích využívajících Java Access Bridge (včetně OpenOffice.org). (#358, #463)
* Při pohybu myší po buňkách v Microsoft Excelu bude nyní NVDA oznamovat jejich text.
* V aplikacích využívajících Java Access Bridge bude nyní hned při objevení dialogu přečten jeho text. (#554)
* Ve virtuálním prohlížeči je nyní možné pracovat také s obsahem Adobe Flash. Nadále je podporováno i prohlížení objektů a přímá interakce s prvky (pomocí formulářového režimu). (#453)
* Editační textové prvky ve vývojovém prostředí Eclipse jsou nyní přístupné včetně editoru kódu. Musíte však používat Eclipse 3.6 nebo novější. (#256, #641)
* NVDA již dokáže zachytit většinu textu vypisovaného na obrazovku. (#40, #643)

> - To umožňuje čtení i takových prvků, které nezobrazují informace žádným přímějším nebo spolehlivějším způsobem.
> - Mezi takto zpřístupněné prvky patří např.: některé položky nabídek, které zobrazují ikony (př. podnabídka otevřít v programu u souborů ve Windows Xp) (#151), editovatelná textová pole v aplikacích Windows Live (#200), seznam chyb v Outlook Expressu (#582), editovatelný textový prvek v TextPadu (#605), seznamy v Eudoře, řada prvků v australském E-taxu a lišta se vzorci v Microsoft Excelu.

* Doplněna podpora pro editor kódu v Microsoft Visual Studiu 2005 a 2008. Je třeba vlastnit alespoň Visual Studio Standard; tato podpora nefunguje v Express edicích. (#457)
* Podpora dokumentů IBM Lotus Symphony.
* Raná experimentální podpora Google Chrome. Berte, prosím, na vědomí, že podpora odečítačů obrazovky u samotného Chromu zatím zdaleka není kompletní, a tak může být v budoucnu potřeba ještě další práce i na straně NVDA. Abyste tuto podporu mohli vyzkoušet, budete potřebovat některé novější vývojové vydání Chromu.
* Při stisku přepínacích kláves jako je caps lock, num lock či scroll lock je jejich stav zobrazen i v braillu. (#620)
* Obsah bublinové nápovědy je nyní rovněž zobrazován v braillu. (#652)
* Byl Přidán ovladač pro braillský řádek MDV Lilli. (#241)
* Při označení celého řádku nebo sloupce v programu Microsoft excel stiskem kláves Shift+Mezerník a Ctrl+Mezerník NVDA nyní správně ohlašuje nový výběr. (#759)
* Byla přidaná možnost ohlašování záhlaví řádků a sloupců v tabulkách. Tuto volbu lze zapnout v dialogu Ohlašování formátování dokumentu.
 * Zatím je tato možnost dostupná jen v dokumentech aplikací Mozilla. (#361)
* Byly přidány klávesové zkratky pro plošné prohlížení: (#58)
 * NVDA+numerická 7 přepíná do plošného prohlížení. Nastaví čtecí kurzor na aktuální pozici právě zaměřeného objektu. Takto můžete začít prohlížet obsah obrazovky či dokumentu, (jste-li zrovna uvnitř nějakého) prostřednictvím příkazů pro prohlížení textu.
 * NVDA+numerická 1 Zapne objektové prohlížení na aktuální pozici čtecího kurzoru. Je vyhledán objekt, jehož text právě čtete v režimu plošného prohlížení a čtecí kurzor je umístěn do tohoto objektu, aby bylo možno daný objekt prohlížet a pohybovat se po dalších objektech.
* Aktuální uživatelské nastavení NVDA lze nyní stiskem tlačítka v dialogu Obecné nastavení zkopírovat pro použití na přihlašovací a dalších zabezpečených obrazovkách systému windows.
* Podpora pro Mozilla Firefox 4.
* Podpora pro Microsoft Internet Explorer 9.

### Změny

* Příkazy pro přečtení celého prohlíženého objektu (NVDA+numerické Plus), následujícího objektu v návaznosti (NVDA+Shift+numerická 6) a předchozího objektu v návaznosti (NVDA+Shift+numerická 4) byly prozatím odstraněny kvůli chybovosti a také, aby byly tyto klávesy uvolněny pro případné pozdější přiřazení k novým funkcím.
* V dialogu hlasové výstupy jsou nyní zobrazována pouze jména syntezátorů určená ke zobrazení uživatelům. Dříve jim předcházel ještě název ovladače, který je ale důležitý pouze pro samotný program.
* Pokud se fokus nachází uvnitř vnořené aplikace nebo ve virtuálním prohlížeči uvnitř jiného virtuálního prohlížeče (např. Flash), můžete nyní pro opuštění tohoto objektu a návrat do domovského dokumentu použít NVDA+Ctrl+mezerník. K tomuto účelu dříve sloužila kombinace pouze NVDA+mezerník, ta však nyní slouží výhradně pro přepínání mezi formulářovým režimem a režimem prohlížení.
* Pokud se fokus přesune do nástroje pro zobrazení řeči spouštěného z menu nástroje (např. přepnutím do jeho okna), nebude se už v tomto prvku objevovat další text, dokud se fokus opět nezmění. To umožňuje snadnější označování již přítomného textu (např. kvůli kopírování).
* Pokud bylo aktivováno zobrazení logu nebo Python konzole, budou spuštěny maximalizované.
* Pokud získá fokus list programu Microsoft Excel a je označeno více buněk, je oznámen rozsah výběru a ne jen aktivní buňka. (#763)
* Ukládání konfigurace a změna některých nastavení je zablokovaná, pokud NVDA běží na přihlašovací obrazovce.
* Hlasový výstup eSpeak byl aktualizován na verzi 1.44.03.
* Pokud je NVDA již spuštěn, aktivace zástupce na ploše nebo stisk klávesové zkratky Ctrl+Alt+N zajistí restart NVDA.
* Zaškrtávací políčko Oznamovat text pod kurzorem myši bylo v dialogu nastavení myši nahrazeno políčkem Povolit sledování myši, jehož popisek lépe vystihuje chování příslušné funkce.
* rozložení klávesnice pro laptop bylo aktualizováno tak, že obsahuje všechny klávesové příkazy dostupné v rozložení desktop a funguje i na jiných než anglických systémech. (#798, #800)
* Byly provedeny Výrazné změny a aktualizace uživatelské dokumentace, je zdokumentováno rozložení klávesnice pro laptop a je zajištěna synchronizace seznamu klávesových zkratek s uživatelskou příručkou. (#455)
* Překladač do braillova písma liblouis byl aktualizován na verzi 2.1.1. Opravuje to chyby v čínském brailu a zobrazování znaků, které nejsou definovány v aktuální překladové tabulce. (#484, #499)

### Opravy

* V programu µTorrent už nebude právě zaměřená položka v seznamu torrentů čtena dvakrát nebo přitahovat fokus při otevření nabídky.
* V µTorrentu budou nyní ohlašovány názvy souborů v seznamu s obsahem torrentu.
* V aplikacích Mozilla jsou nyní správně rozpoznávány změny fokusu, pokud je umístěn do prázdné tabulky nebo stromového seznamu.
* V aplikacích Mozilla je nyní správně oznamován stav "nezaškrtnuto" i pro nestandardní zaškrtnutelné prvky jako jsou např. buňky tabulky. (#571)
* V aplikacích Mozilla už nebude ignorován text náležitě implementovaných dialogů ARIA a bude při objevení takového dialogu přečten.
* ARIA atribut úrovně bude náležitě reflektován v Internet Exploreru a dalších prvcích MSHTML.
* V Internet Exploreru a dalších prvcích MSHTML je nyní atribut ARIA role upřednostňován před jinými informacemi o typu, aby tak NVDA umožňoval mnohem přesnější a intuitivnější práci s prvky ARIA.
* Odstraněno občasné padání Internet Exploreru při pohybu po rámcích nebo prvcích iFrame.
* V dokumentech Microsoft Wordu je opět možné číst řádky orientované zprava doleva jako je např. arabský text. (#627)
* Výrazně snížena prodleva při zobrazování velkého množství textu v 64-bitových konzolových aplikacích. (#622)
* Je-li při startu NVDA již spuštěn program Skype, není nutné ho restartovat, aby byl přístupný. To může platit i pro ostatní aplikace, které kontrolují systémovou značku přítomnosti odečítače.
* V aplikacích Microsoft Office už NVDA nepadá při pokusu o přečtení okna aplikace v popředí (NVDA+B) nebo při pohybu po některých objektech na panelu nástrojů. (#616)
* Bylo opraveno nesprávné vyslovování číslic s nulou po oddělovači jako např. 1,023. (#593)
* Programy Adobe Acrobat Pro a Reader 9 už nepadají při zavírání souboru a při některých dalších akcích. (#613)
* V některých editačních polích jako např. v programu Microsoft word je po stisku kláves Ctrl+a přečten označený text. (#761)
* V prvcích scintilla např. notepad++ už není při pohybu kurzorem nebo při plynulém čtení text nesprávně označován . (#746)
* Bunky programu Microsoft excel je možné opět číst čtecím kurzorem.
* NVDA opět dokáže v některých problematických víceřádkových editačních polích programu Internet explorer 8 číst po řádcích . (#467)
* Windows Live Messenger 2009  se už hned po spuštění automaticky neukončuje, jestliže je spuštěn NVDA. (#677)
* V internetových prohlížečích  už není nutné po přechodu do vnořeného objektu např. flash stisknout klávesu tab pro další navigaci. (#775)
* V prvcích scintilla (např. Notepad ++) už nedochází k osekání začátku dlouhých řádků, jestliže se nevejde na obrazovku. Také v brailu je výběr těchto dlouhých řádků správně zobrazován.
* V programu Loudtalks je nyní možné číst seznam kontaktů.
* v programu internet explorer a jiných dokumentech MSHTML už není zbytečně oznamovaná adresa dokumentu a "MSAAHTML Registered Handler". (#811)
* Ve stromových seznamech prostředí Eclipse už při změně fokusu nedochází ke čtení textu předchozí položky.
* NVDA nyní správně funguje v systému, kde byl z cesty  DLL search path (pomocí nastavení položky registry CWDIllegalInDllSearch na 0xFFFFFFFF) odstraněn aktuální adresář. Toto pro většinu uživatelů není důležité. (#907)
* Pokud jsou v programu Microsoft Word použity příkazy pro navigaci v tabulce vně tabulky, po hlášce mimo tabulku již není zbytečně vyslovován text okraj tabulky.
* Pokud pomocí navigačních kláves není možné přejít do další buňky v tabulce programu Microsoft word proto, že kurzor je na okraji tabulky, je hláška okraj tabulky přeložená do aktuálně nastaveného jazyka programu NVDA. Doposud byla tato informace vyslovována jen v angličtině. (#921)
* V programech Outlook Express, Windows Mail a Windows Live Mail je ohlašovaný stav zaškrtávacích políček v seznamu pravidel pošty. (#576)
* v programu Windows Live Mail 2010 je možné číst popis pravidel pošty.

## 2010.1

Toto vydání se zaměřuje především na opravy chyb a vylepšování uživatelského dojmu při práci s programem včetně několika výrazných zlepšení stability.

### Novinky

* Spuštění NVDA už nebude selhávat na systémech, které nemají žádná výstupní zvuková zařízení. Aby mohl v takovém případě NVDA předávat uživateli informace, bude pochopitelně třeba použít braillský řádek nebo výstup bez mluvení v kombinaci s novým nástrojem prozobrazení řeči, který nahrazuje předchozí virtuální hlasový výstup Display. (#425)
* Do dialogu ohlašování formátování dokumentu byla přidána volba hlásit oblasti stránky, která určuje, zda má NVDA při pohybu po webových stránkách ohlašovat tzv. oblasti stránky. Z důvodů zajištění kompatibility s předchozí verzí je tato funkce standardně zapnutá.
* Při zapnutém ohlašování příkazových kláves bude NVDA hlásit i názvy tzv. multimediálních kláves (např. přehrát, zastavit přehrávání, domovská stránka atd) na mnoha klávesnicích. (#472)
* NVDA od této verze ohlašuje při stisku control+backspace právě smazané slovo u těch prvků, které to umožňují. (#491)
* V okně Web formatoru lze nyní používat pro čtení a pohyb po textu i kurzorové šipky. (#452)
* Od nynějška je podporován seznam položek v adresáři Microsoft Office Outlooku.
* NVDA lépe podporuje vnořené editovatelné dokumenty v Internet Exploreru. (#402)
* Nový příkaz (NVDA+shift+numerické mínus) umožňuje přesunout systémový fokus na právě prohlížený objekt.
* Byly přidány nové příkazy pro uzamčení a odemčení levého či pravého tlačítka myši. Jde v podstatě o simulované přidržení daného tlačítka, užitečné zejména při přetahování objektů myší atd. Shift+numerické lomeno pro levé, shift+numerická hvězdička pro pravé tlačítko.
* Nové braillské překladové tabulky: německé - 8-bodové počítačové písmo, německý zkratkopis, finské - 8-bodové počítačové písmo, čínština (hong kongská, kantonská), čínština (taiwanská, mandarínská). (#344, #369, #415, #450)
* Nyní lze při instalaci NVDA zakázat vytvoření zástupce na ploše, a tedy i zkratkové klávesy. (#518)
* NVDA dovede pracovat s rozhraním Iaccessible2 i v 64 bitových aplikacích. (#479)
* Vylepšená podpora live regionů v aplikacích Mozilla. (#246)
* Bylo vyvinuto rozhraní, které umožňuje externím aplikacím pracovat s NVDA; např. přečíst text, přerušit řeč, zobrazit zprávu na braillském řádku atd.
* Informativní a chybová hlášení budou nyní čtena i na přihlašovacích obrazovkách systémů Windows Vista nebo Windows 7. (#506)
* V Adobe Readeru jsou nyní podporovány i PDF interaktivní formuláře vytvořené v programu Adobe LiveCycle. (#475)
* V programu Miranda IM nyní NVDA dokáže automaticky číst příchozí zprávy v oknech konverzace, pokud je zapnuto ohlašování dynamicky změněného obsahu (NVDA+5). Také byly přidány příkazy pro přečtení tří nejnovějších zpráv (NVDA+ctrl+číslo 1, 2, nebo 3).
* V obsahu Adobe Flash jsou nyní podporována textová vstupní pole. (#461)

### Změny

* V nabídce start systému Windows 7 už není oznamována extrémně obsáhlá zpráva klávesové nápovědy.
* Syntezátor Display, virtuální hlasový výstup, byl nyní nahrazen nástrojem nazvaným zobrazení řeči. Lze jej zapnout zvolením položky zobrazení řeči z nabídky NVDA, menu nástroje. Může být aktivní nezávisle na tom, který hlasový syntezátor právě používáte. (#44)
* Aktuální text viditelný na braillském řádku bude nyní automaticky odstraněn při stisku klávesy, která vyvolá pohyb fokusu. Dříve by poslední vypsaný úsek textu vždy zůstával zobrazený po nastavenou dobu.
* Nastavení, zda se má zobrazování na braillském řádku řídit systémovým či čtecím kurzorem (NVDA+ctrl+T), je nyní možné měnit také v dialogu braillské nastavení, a rovněž se ukládá do konfiguračního souboru.
* Hlasový výstup Espeak byl aktualizován na verzi 1.43.
* Překladač do braillova písma Liblouis byl aktualizován na verzi 1.8.0.
* Ve virtuálním prohlížeči bylo podstatně vylepšeno ohlašování prvků při pohybu po znacích či slovech. Dříve bylo v takovém případě oznamováno příliš mnoho nedůležitých informací a ohlašování bylo celkově velice odlišné od toho při pohybu po řádcích. (#490)
* Klávesa control nyní prostě přerušuje řeč jako ostatní klávesy, místo aby ji pozastavovala. Pro pozastavení či pokračování v řeči používejte klávesu shift.
* Při ohlašování změn fokusu už nebude oznamován počet řádků a sloupců tabulky, protože tato informace je velice obsáhlá a obvykle nebývá příliš užitečná.

### Opravy

* Spuštění NVDA už nebude selhávat v případě, kdy je zdánlivě dostupná podpora UI Automation, ale z nějakého důvodu se neinicializuje. (#483)
* Při přesunu fokusu v rámci buňky tabulky v dokumentech Mozilla už NVDA nebude číst celý řádek tabulky. (#482)
* Odstraněna dlouhá prodleva odezvy NVDA při rozbalování větví stromového seznamu, které obsahují velmi mnoho vnořených položek.
* Při vypisování SAPI 5 hlasů se NVDA nyní pokouší rozpoznat problémové hlasy a ty pak nezpřístupní v dialogu Nastavení hlasu  ani v kruhu nastavení hlasového výstupu. Pokud se v systému dříve vyskytoval byť jen jediný problémový hlas, NVDA někdy nedokázal načíst svůj SAPI 5 ovladač.
* Virtuální prohlížeč nyní skutečně respektuje volbu hlásit přístupové klávesy k objektům, která se nachází v dialogu prezentace objektů. (#486)
* Ve virtuálním prohlížeči už nebudou čteny souřadnice řádku či sloupce tabulky, pokud je ohlašování tabulek vypnuto a fokus se nachází v záhlaví tabulky. 
* Ve virtuálním prohlížeči budou nyní správně čteny souřadnice řádku a sloupce tabulky, pokud tabulku opustíte a poté se vrátíte na stejnou buňku, aniž byste předtím prohlíželi nějakou jinou buňku; např. při stisku horní a vzápětí dolní šipky na první buňce tabulky. (#378)
* Prázdné řádky v dokumentech Microsoft Wordu a v editovatelných prvcích Microsoft HTML jsou nyní náležitě reflektovány i na braillském řádku. NVDA v takových případech dříve zobrazoval aktuální větu, nikoli aktuální řádek. (#420)
* Několik bezpečnostních oprav v situaci, kdy NVDA běží při přihlašování do systému nebo na jiných zabezpečených obrazovkách. (#515)
* Při použití příkazu pro plynulé čtení je nyní ve standardních editačních prvcích Windows a v dokumentech Microsoft Wordu správně aktualizována pozice kurzoru. (#418)
* Ve virtuálním prohlížeči už NVDA nezobrazuje text obrázků uvnitř odkazů a ostatních kliknutelných objektů, které jsou označeny jako irelevantní pro odečítače obrazovky. (#423)
* Úpravy v rozložení klávesnice pro laptopy. (#517)
* Je-li braillský řádek propojen s čtecím kurzorem a fokus se nachází v okně dosovské konzole, čtecí kurzor se nyní dokáže po textu konzole správně pohybovat.
* Při práci s TeamTalkem 3 nebo TeamTalkem 4 Classic už NVDA neohlašuje změny indikátoru průběhu týkající se VU meteru v hlavním okně. Rovněž národní znaky jsou nyní správně čteny v okně příchozího chatu.
* Položky v nabídce start systému Windows 7 už nebudou čteny dvakrát. (#474)
* Aktivování odkazů v rámci stejné stránky ve Firefoxu 3.6 nyní správně přesune kurzor na příslušné místo na stránce.
* Opravena chyba, kdy v některých dokumentech PDF v Adobe Readeru nebyl vždy načítán všechen text.
* NVDA už nebude chybně číst určitá čísla oddělená pomlčkou, např. 500-1000. (#547)
* Ve Windows XP už NVDA nebude způsobovat zamrzání Internet Exploreru při přepínání zaškrtávacích políček na stránce Windows Update. (#477)
* Při používání vestavěného hlasového výstupu Espeak už nebude docházet k přerušovanému zamrzání při současném přehrávání pípání a řeči. Tento jev byl nejvíce patrný např. při kopírování velkého množství dat v Průzkumníku Windows.
* NVDA už neoznamuje, že dokument Firefoxu se stal zaneprázdněným (např. díky aktualizaci nebo obnovení), u dokumentů na pozadí. To také vedlo k mylnému ohlašování stavového řádku aplikace v popředí.
* Při přepínání rozložení klávesnice Windows (pomocí Ctrl+Shift nebo Alt+Shift) bude nyní ohlášeno plné jméno nového rozložení a to jak hlasem, tak Braillem. Dříve bylo ohlašováno pouze hlasem a alternativní rozložení (např. Dvorak) nebyla oznamována vůbec.
* Pokud je vypnuto ohlašování tabulek, nebudou už oznamovány informace o tabulce při změně fokusu.
* Určité standardní prvky stromového zobrazení v 64 bitových aplikacích (např. stromový seznam obsahu v Microsoft HTML nápovědě) jsou nyní přístupné. (#473)
* Opraveny problémy s logováním jiných než ascii znaků. Mohlo to způsobovat zbytečné chyby na neanglických systémech. (#581)

* Informace v dialogu O programu se nyní objevují v nastaveném jazyce uživatele, místo, aby byly vždy zobrazovány v angličtině. (#586
* Přepnutí pomocí kruhu nastavení hlasového výstupu na hlas, který podporuje méně parametrů než dosavadní hlas, už nezpůsobuje problémy.
* Ve Skype 4.2 už nejsou několikanásobně čteny položky v seznamu kontaktů.
* Opraveno několik potenciálně závažných paměťových úniků v kódu uživatelského rozhraní a virtuálního prohlížeče. (#590, #591)
* Dočasné řešení nepříjemné chyby v některých SAPI 4 hlasových výstupech, která působila časté potíže  a pády NVDA. (#597)

## 2009.1

Mezi největší přednosti této verze patří podpora pro 64 bitové edice systému Windows; výrazně lepší podpora Microsoft Internet Exploreru a Adobe Readeru; podpora pro Windows 7; schopnost číst i obrazovky Správce úloh, Nástroje pro řízení uživatelských účtů (UAC) a přihlašovací obrazovku systému; a možnost pracovat s obsahem Adobe Flash a Sun Java na webových stránkách. Dále byla provedena celá řada podstatných úprav stability programu a celkově vylepšen uživatelský dojem při práci s ním.

### Novinky

* Oficiální podpora pro 64 bitové edice systému Windows. (#309)
* Přidán ovladač pro hlasový výstup Newfon.
K tomuto účelu byla vytvořena speciální verze výstupu Newfon pro NVDA. (#206)
* Ve virtuálním prohlížeči může nyní být přepínání mezi formulářovým režimem a režimem prohlížení signalizováno zvukovým návěstím. Tato volba je implicitně zapnutá. Lze ji nastavit v dialogu virtuální prohlížeč. (#244)
* Při použití kláves pro změnu hlasitosti počítače NVDA už nepřerušuje řeč, takže změny jsou okamžitě slyšitelné. (#287)
* Kompletně byla přepracována podpora pro Microsoft Internet Explorer a Adobe Acrobat reader. Tato podpora je nyní jednotná se stávající podporou pro produkty Mozilla, což v praxi znamená téměř okamžité načítání stránek, rozšíření rychlé navigace, dialog se seznamem prvků, výběr a kopírování textu, automatické přepínání formulářového režimu a režimu prohlížení a podporu pro braillské řádky i v těchto dokumentech.
* Vylepšená podpora pro prvek zobrazení času a data v dialogu vlastnosti data a času systému Windows Vista.
* Vylepšená podpora pro Moderní nabídku start v systémech windows XP/Vista (konkrétně např. v podnabídce všechny programy jsou oznamovány úrovně vnoření dalších podnabídek).
* V dialogu nastavení myši lze nyní zvolit Množství textu, který bude vysloven při zaměření konkrétního objektu myší. Je možné zvolit buď znak, slovo, řádek či odstavec.
* V dialogu ohlašování formátování dokumentu lze nyní zapnout oznamování pravopisných chyb. To se týká především programu Microsoft Word.
* Podpora kontroly pravopisu v programu Microsoft Word 2007. U starších verzí Wordu je kontrola pravopisu podporována jen částečně.
* Vylepšena podpora programu Windows Live Mail. Nyní je možné číst zprávy v prostém textu a rovněž vytvářet zprávy jak ve formátu prostého textu, tak i HTML.
* Jestliže se v systému Windows Vista zobrazí UAC dialog, což  je dialog, který vyvolává zapnutý nástroj pro řízení uživatelských účtů, nebo jestliže uživatel přejde stiskem kláves ctrl+alt+del na zabezpečenou pracovní plochu, nvda je schopen s těmito obrazovkami systému pracovat a plně je ozvučit. Jsou podporovány i veškeré zabezpečené obrazovky v systému Windows XP včetně ozvučení přihlašovací obrazovky. To je možné zapnout či vypnout v dialogu obecné nastavení. Pro práci se zabezpečenými obrazovkami systému má NVDA zvláštní konfigurační soubor. Díky tomu je možné nastavit jiné chování NVDA pro běžnou práci v systému a pro práci se zabezpečenými obrazovkami. Pozor! Toto se netýká přenosné verze NVDA. (#97)
* V okně příkazového řádku dokáže nvda ohlašovat text pod kurzorem.
* Podpora pro UI Automation prostřednictvím klientského rozhraní UI Automation v systému Windows 7 a další opravy vylepšující kompatibilitu NVDA s tímto operačním systémem.
* V dialogu obecné nastavení přibyla položka pro nastavení automatického spouštění NVDA po přihlášení do systému. Pozor! Toto se netýká přenosné verze NVDA.
* Přidán ovladač pro braillské řádky Optelec ALVA BC6 series.
* Rychlá navigace ve virtuálním prohlížeči byla rozšířena o klávesy n a shift+n pro přeskočení na následující či předchozí text po skupině odkazů.
* Ve virtuálním prohlížeči jsou nyní oznamovány tzv. oblasti stránky, po kterých lze v požadovaném směru přecházet klávesami d a shift+d. (#192)
* Dialog seznam odkazů, jenž lze ve virtuálním prohlížeči vyvolat stiskem kláves NVDA+F7, byl přejmenován na  seznam prvků, ve kterém je možné krom odkazů zobrazit i nadpisy a oblasti stránky. Nadpisy a oblasti stránky jsou zobrazeny jako stromový seznam. (#363)
* Nový dialog seznam prvků obsahuje i políčko "filtrovat, podle", které umožňuje zobrazovat v seznamu pouze prvky obsahující vepsaný text. (#173)
* Přenosná verze NVDA nyní ukládá uživatelská nastavení do složky 'userConfig', která je umístěna ve složce programu NVDA. Uživatelská nastavení jsou tedy stejně jako u instalační verze NVDA oddělena od ostatních souborů programu.
* vlastní aplikační moduly, ovladače braillských řádků a ovladače hlasových výstupů jsou nyní ukládány do složky s uživatelským nastavením. (#337)
* Dokumenty virtuálního prohlížeče jsou nyní načítány na pozadí, což umožňuje do jisté míry pracovat se systémem i během procesu načítání. NVDA oznámí, že se zpracovává dokument, pokud to trvá déle než jednu sekundu.
* Jestliže NVDA zjistí, že z nějakého důvodu zamrzl, začne automaticky propouštět všechny klávesy do systému, takže uživatel může problém snadněji vyřešit.
* Podpora přetahování objektů ARIA v produktech Mozilla myší. (#239)
* Při přepnutí do okna s dokumentem virtuálního prohlížeče NVDA nyní oznámí jeho název a aktuální řádek, případně označený text. Chování při přepnutí do okna virtuálního prohlížeče je tedy stejné jako v případě oken běžných dokumentů. (#210)
* Ve virtuálním prohlížeči je nyní možné pracovat s vnořenými objekty (jako je obsah Adobe Flash nebo Sun Java), jestliže na takovém objektu stisknete enter. Je-li pro NVDA přístupný, můžete se po něm poté pohybovat šipkami jako v běžných aplikacích. Stiskem NVDA+mezerník se lze přepnout zpět do vlastního dokumentu. (#431)
* Ve virtuálním prohlížeči byly přidány klávesy o a shift+o, jimiž se lze přesunout na další či předchozí vnořený objekt.
* NVDA má nyní plný přístup i k aplikacím spuštěným jako administrátor v systému Windows Vista nebo 7. Pozor! Toto se netýká přenosné verze NVDA ani snapshotů, ale jen oficiálních verzí NVDA. (#397)

== Změny ==
* Po spuštění NVDA byla odstraněna hláška "NVDA spuštěn". Start NVDA je nyní signalizován pouze úvodní znělkou.
* Znělky při spuštění a ukončení NVDA jsou nyní přehrávány prostřednictvím výstupního zvukového zařízení nastaveného pro NVDA, nikoli pomocí výchozího výstupního zařízení Windows. Toto nastavení se nachází v dialogu hlasové výstupy, položka výstupní zařízení. (#164)
* Bylo vylepšeno ohlašování indikátorů průběhu. Nejpatrnější změnou je to, že nyní můžete NVDA nastavit, aby je oznamoval pípáním i hlasem zároveň.
* Některé obecné informace o typu prvku pod fokusem jakoje např. panel,aplikace nebo rám, už nejsou oznamovány, pokud je daný prvek pojmenovaný.
* Příkaz pro kopírování textu čtecím kurzorem (NVDA+F10) nyní zkopíruje text od nastavené počáteční značky až po momentální pozici kurzoru, kterou také do kopírovaného úseku textu zahrne, místo, aby ji ignoroval. Tak je nyní možné kopírovat i poslední znak daného řádku, což dříve možné nebylo. (#430)
* Příkaz pro zjištění aktuálně prohlíženého objektu (Ctrl+NVDA+numerická 5) byl odstraněn. Tato klávesová kombinace na některých klávesnicích nefungovala a příkaz ani nebyl shledán příliš užitečným.
* Příkaz pro zjištění rozměrů aktuálně prohlíženého objektu byl přemapován na NVDA+numerický delete neboli numerická desetinná čárka. Předchozí klávesová zkratka nefungovala na některých klávesnicích. Příkaz navíc také nyní oznamuje skutečnou výšku a šířku objektu namísto pouze pravé a dolní souřadnice.
* Zvýšen výkon (obzvláště na netboocích) v situacích, kdy se ozývá mnoho pípnutí v rychlém sledu po sobě; např. při pohybu myší se zapnutou zvukovou signalizací. (#397)
* V RC a finálních verzích už NVDA nepřehrává chybový zvuk, nicméně chyby jsou stále zaznamenávány.
* Namísto "propouštění zapnuto" a "propouštění vypnuto" NVDA nyní ohlašuje "formulářový režim" (místo propouštění zapnuto) a "režim prohlížení" (místo propouštění vypnuto).
* Dialog nastavení čtení formátování textu byl přejmenován na ohlašování formátování dokumentu

### Opravy

* Pokud je NVDA spuštěn z dosovské cesty 8.3, ale přitom je nainstalován ve složce s odpovídající dlouhou cestou (např. progra~1 proti program files), dokáže správně určit, že se jedná o instalovanou kopii a načíst uživatelská nastavení.
* Ohlašování titulku aktuálního okna v popředí pomocí NVDA+T nyní funguje správně i v nabídkách.
* Na braillském řádku se už nebudou zobrazovat zbytečné informace jako např. nepojmenované panely.
* Nejsou nadále oznamovány některé zbytečné informace při změně fokusu jako jsou třeba kořenové panely, vrstvené panely či posuvné panely v aplikacích Java nebo Lotus.
* Políčko pro vyhledávání klíčových slov v prohlížeči nápovědy (chm) Windows je nyní mnohem přístupnější. Díky chybovosti tohoto prvku by dříve nebylo možné políčko tak, jak bylo, vůbec číst, protože se neustále měnilo.
* V dokumentech Microsoft Wordu budou nyní oznamována správná čísla stránek, jestliže je číslování stránek v dokumentu konkrétně určeno.
* Lepší podpora pro editační políčka v dialozích Microsoft Wordu (např. dialog pro nastavení písma). Je nyní možné pohybovat se po těchto prvcích šipkami.
* Vylepšená podpora pro dosovské konzole. Konkrétně: NVDA nyní dokáže přečíst obsah i takových konzolí, o kterých si vždycky myslel, že jsou prázdné. Stisk ctrl+break už neukončí NVDA.
* Pokud při instalaci NVDA ve Windows Vista nebo 7 zaškrtnete na závěrečné obrazovce, aby byl po dokončení instalace NVDA spuštěn, spustí se s oprávněními přihlášeného uživatele.
* Klávesa backspace se nyní chová správně, i pokud je zapnutá volba hlásit psaná slova. (#306)
* Určité kontextové nabídky v průzkumníku či v okně tento počítač už nebudou nesprávně oznamovány jako nabídka start. #257)
* NVDA nyní dokáže správně pracovat s návěstími objektů ARIA v produktech Mozilla, jestliže nejsou dostupné žádné jiné použitelné informace. (#156)
* NVDA se již automaticky nepřepíná do formulářového režimu u editačních polí, která mění svou hodnotu při změně fokusu; např. https://tigerdirect.com/. (#220)
* NVDA se nyní bude pokoušet zotavit z některých situací, které by dříve způsobily jeho úplné zamrznutí. Zjištění a vyřešení takové situace může trvat až deset sekund.
* Je-li jazyk NVDA nastaven na "user default", použije se nastavený jazyk zobrazení Windows namísto místních nastavení uživatele. (#353)
* NVDA nyní dokáže rozpoznat existenci prvků v AIM7.
* Příkaz propustit následující klávesu se již nezasekne, pokud některou klávesu podržíte. Dříve by NVDA v takovém případě přestal přijímat jakékoli další příkazy a musel by být restartován. (#413)
* NVDA již neignoruje úlohovou lištu, pokud se na ni přesune fokus, což se často děje např. při ukončování aplikací. Dříve se NVDA choval, jako by se fokus vůbec nezměnil.
* Při čtení textových polí v aplikacích, které používají Java Access Bridge (včetně OpenOffice.org), NVDA nyní pracuje správněi při zapnutém ohlašování čísel řádků.
* Příkaz pro kopírování textu čtecím kurzorem (NVDA+F10) se nyní dokáže korektně vypořádat se situací, kdy je použit na pozici před počáteční značkou. To by dříve vedlo k problémům, jako je např. pád programu Notepad++.
* Určitý řídicí znak (0x1) už nezpůsobuje neočekávané chování eSpeaku (např. změny hlasitosti a výšky hlasu), jestliže se objeví v textu.
* Příkaz pro přečtení označeného textu (NVDA+shift+šipka nahoru) nyní správně ohlásí, že není vybrán žádný text, pokud daný objekt nepodporuje označování textu.
* Opravena chyba, kdy NVDA při stisku enteru na některých tlačítkách a odkazech v programu Miranda IM zamrzal. (#430)
* Při hláskování či kopírování právě prohlíženého objektu do schránky je skutečně brán v potaz jen právě prohlížený objekt a nikoli celý text jako tomu bylo doposud.
* NVDA nyní obchází chybu Windows, která způsobovala, že po názvu odkazů v dialozích Průzkumníku Windows a Internet Exploreru byly ohlašovány irelevantní informace navíc. (#451)
* Opraven problém s příkazem pro ohlášení času a data (NVDA+F¨12). Na některých systémech dříve nebylo ohlašováno datum. (#471)
* Opravena chyba, která způsobovala, že po ukončení práce se zabezpečenou obrazovkou Windows NVDA někdy náležitě neaktualizoval systémové nastavení odečítače obrazovky. To mohlo vést k problémům v aplikacích, které toto nastavení sledují jako je Skype, Adobe Reader nebo Jart. (#462)
* V rozbalovacích seznamech Internet Exploreru 6 budou nyní ohlašovány změny aktivní položky. (#342)

## 0.6p3

### Novinky

* Protože lišta se vzorci v Microsoft Excelu je pro NVDA nepřístupná, byl přidán vlastní NVDA editor buněk, který se spustí, pokud uživatel stiskne na kterékoli buňce F2.
* Podpora formátování v textových prvcích Iaccessible2, včetně aplikací Mozilla.
* NVDA nyní může oznamovat pravopisné chyby, kde je to možné.Toto nastavení se nachází v dialogu ohlašování formátování dokumentu.
* NVDA nyní lze nastavit tak, aby pípal buď pro všechny indikátory průběhu, nebo pouze pro ty v okně na popředí. Další možností je ohlašovat hodnotu indikátorů průběhu každých 10%.
* Ve víceřádkových textových polích jsou nyní správně identifikovány odkazy.
* Myš lze nyní u většiny editovatelných textových prvků přesunout na znak pod čtecím kurzorem. Dříve bylo možné umístit myš pouze na střed takového prvku.
* Čtecí kurzor ve virtuálním prohlížeči nyní zobrazuje samotný text dokumentu v prohlížeči namísto pouze interního textu právě prohlíženého objektu, který je často prouživatele nic neříkající. To znamená, že se můžete do virtuálního prohlížeče přepnout hierarchicky pomocí objektové navigace a čtecí kurzor se přesune na odpovídající místo v textu prohlíženého dokumentu.
* NVDA nyní umí zpracovat některé další stavy Java prvků.
* Je-li klávesová zkratka pro oznámení titulku okna (NVDA+t) stisknuta dvakrát, titulek bude vyhláskován. Pokud je stisknuta třikrát, bude titulek zkopírován do schránky.
* V klávesové nápovědě jsou nyní čteny názvy přeřazovacích kláves (control, shift, alt), pokud jsou stisknuty osamoceně.
* Názvy kláves oznamované v klávesové nápovědě je nyní možné překládat.
* Doplněna podpora pro políčko s rozpoznaným textem v programu SiRecognizer. (#198)
* Podpora braillských řádků!
* Přidán příkaz (NVDA+c) pro přečtení textu ve schránce. (#193)
* Pokud se NVDA ve virtuálním prohlížeči automaticky přepne do formulářového režimu, můžete se nyní vrátit do režimu prohlížení také stiskem klávesy escape. Stále je možné používat k tomuto účelu i kombinaci kláves NVDA+mezerník.
* Ve virtuálním prohlížeči se NVDA nyní může při změně fokusu nebo při pohybu textového kurzoru automaticky přepnout buď do formulářového režimu, nebo do režimu prohlížení, podle toho, jaký typ prvku se pod kurzorem nachází. Tuto volbu je možné nastavit v dialogu virtuální prohlížeč. (#157)
* Byl přepsán ovladač pro syntezátory SAPI4, který nahrazuje dříve používané ovladače sapi4serotek a sapi4activevoice a měl by odstranit problémy, které tyto ovladače vyvolávaly.
* Aplikace NVDA v sobě nyní obsahuje manifest, což znamená, že už se ve Windows Vista nespouští v režimu kompatibility.
* Instalační verze NVDA nyní ukládá konfigurační soubor a řečové slovníky do složky pro data aplikací aktuálního uživatele. To je nezbytné pro správnou funkčnost NVDA v systému Windows Vista a také to umožňuje více uživatelům najednou mít na jednom počítači uložena zvlášť svá individuální nastavení.
* Doplněna podpora pro informace o pozici u prvků Iaccessible2.
* Přidána možnost kopírovat text do schránky pomocí čtecího kurzoru. Nejprve nastavte zkratkou NVDA+F9 počáteční značku na aktuální pozici čtecího kurzoru. Poté stiskem NVDA+F10 zkopírujete blok textu mezi počáteční značkou a novou aktuální pozicí čtecího kurzoru, kde má kopírovaný úsek končit. Tuto funkci využijete zejména v situaci, kdy není možné text z daného prvku zkopírovat běžným způsobem pomocí zkratek ctrl+c a ctrl+v. (#240)
* Přidána podpora pro některé editovatelné prvky v softwaru pinacle tv.
* Pokud je označen dlouhý úsek textu (512 znaků nebo více), NVDA nyní pouze oznámí počet označených znaků, místo, aby četl celý text. (#249)

### Změny

* Pokud je NVDA nastaven, aby pro přehrávání zvuků a hlasový výstup používal výchozí zvukové zařízení Windows (např. Microsoft Sound Mapper), dokáže se přepnout na nově připojené výstupní zařízení, pokud se toto zařízení stane výchozím. NVDA se tedy dokáže automaticky přepnout třeba na USB zvukovou kartu, pokud ji systém po připojení registruje jako nové výchozí zařízení. Platí to pro zvuková návěstí NVDA a pro vestavěný hlasový výstup Espeak.
* Zlepšena práce eSpeaku s některými zvukovými ovladači systému Windows Vista.
* Oznamování odkazů, nadpisů, seznamů, tabulek a citací lze nyní nastavovat v dialogu ohlašování formátování dokumentu i pro dokumenty virtuálního prohlížeče (webové stránky). Tyto volby by pro virtuální prohlížeč dříve musely být nastaveny v dialogu virtuální prohlížeč. Teď sdílí všechny druhy dokumentů stejná nastavení.
* Tempo hlasu je nyní výchozím parametrem  v kruhu nastavení hlasového výstupu.
* Vylepšeno načítání a ukončování aplikačních modulů.
* Příkaz pro přečtení titulku okna (NVDA+t) nyní oznamuje pouze samotný název okna namísto celého objektu pro název. Pokud objekt v popředí nemá žádný název, bude oznámen název procesu aplikace, pod kterým je vidět např. ve Správci úloh.
* Hlasy jsou nyní v konfiguračním souboru ukládány podle jejich id a ne podle indexu. Tak bude nastavení hlasu spolehlivější i na různých verzích systému Windows a přizměnách nastavení. Nastavení hlasu ze starých konfiguračních souborů nebude zachováno a při prvním použití některého syntezátoru může být zaznamenána chyba. (#19)
* Úroveň položky stromového seznamu bude nyní oznámena jako první, jestliže se od posledního zaměření fokusu změnila, a to pro všechny stromové seznamy. Dříve to platilo pouze pro nativní stromové seznamy Windows (SysTreeView32). 

### Opravy

* Poslední část právě čteného textu už nebude usekávána při použití NVDA s eSpeakem na vzdáleném počítači.
* Odstraněny problémy s ukládáním řečových slovníků pro některé hlasy.
* Odstraněna prodleva odezvy při pohybu po jiných jednotkách, než znacích (po slovech, řádcích atd) ke konci velkých souborů ve formátu prostého textu ve virtuálním prohlížeči pro dokumenty aplikací Mozilla. (#155)
* Je-li zapnuta volba hlásit psaná slova, poslední slovo bude oznámeno i po stisku enteru.
* Opraveny určité problémy se znakovými sadami v editačních polích richedit.
* Prohlížeč log souborů NVDA nyní zobrazuje text v richedit poli namísto pouhého editačního políčka. Lze se nyní s NVDA lépe pohybovat v textu po slovech.
* Odstraněny jisté problémy s vnořenými objekty v richedit prvcích.
* NVDA nyní čte čísla stránek v Microsoft Wordu. (#120)
* Opraven problém ve virtuálním prohlížeči pro produkty Mozilla, kdy NVDA při stisku mezerníku na zaškrtnutém zaškrtávacím políčku neoznámil, že políčko bylo právě odškrtnuto.
* V aplikacích Mozilla již budou správně oznamována částečně zaškrtnutá zaškrtávací políčka.
* Pokud se označený text prodlouží či zkrátí v obou směrech, bude již přečten najednou a ne jako dvě části.
* Při čtení myší by nyní měl být čten i text v editačních polích produktů Mozilla.
* Příkaz pro plynulé čtení by už neměl způsobovat padání některých Sapi 5 syntezátorů.
* Opraven problém, který způsoboval, že označený text ve standardních editačních prvcích Windows nebyl čten, dokud se poprvé po spuštění NVDA nezměnil fokus.
* Opraveno sledování myši v objektech Java. (#185)
* NVDA už neohlašuje položky stromových seznamů Java bez dalších větví jako sbalené.
* Pokud se do popředí dostane aplikace Java, bude oznámen zaměřený objekt. Dříve by NVDA oznámil pouze Java objekt nejvyšší úrovně.
* eSpeak už nepřestane definitivně mluvit po jediné libovolné chybě.
* Opraven problém, kdy nebyly ukládány změněné parametry hlasu (tempo, výška atd) při změně těchto parametrů v kruhu nastavení hlasového výstupu.
* Vylepšeno čtení psaných znaků a slov.
* V textových konzolových aplikacích (jako jsou např. některé textové hry) dříve nebyl někdy čten nově přibývající text.
* NVDA nyní ignoruje změny fokusu v oknech na pozadí. Dříve by změnu fokusu v pozadí mohl pokládat za změnu skutečného fokusu.
* Vylepšeno vyhledání fokusu při opouštění kontextových nabídek. Dříve NVDA po opuštění kontextové nabídky často vůbec nezareagoval.
* NVDA nyní oznámí kontextovou nabídku, i pokud je vyvolána z nabídky start.
* Klasická nabídka start je nyní správně ohlašována jako nabídka start a ne jako aplikační menu.
* Zlepšeno čtení upozornění, jako jsou ta, s nimiž se můžete setkat v prohlížeči Mozilla Firefox. Jejich text už by neměl být čten víckrát po sobě a také už nebudou oznamovány další nadbytečné informace. (#248
* Text editačních polí pouze pro čtení už nyní nebude zahrnován do čtení textu celého dialogu. Takže už nebudou např. automaticky čteny celé licenční smlouvy v instalačních programech.
* NVDA už nadále neoznamuje odznačení textu při opuštění některých editovatelných prvků (příklad: adresní řádek Internet Exploreru, políčka pro e-mailovou adresu v Thunderbirdu 3).
* Při otevírání zpráv ve formátu prostého textu v Outlook Expressu nebo Windows Mailu bude fokus správně umístěn přímo do zprávy, aby si ji uživatel mohl ihned přečíst. Dříve bylo nutné stisknout tab nebo na zprávu kliknout, aby v ní začal fungovat pohyb kurzorovými šipkami.
* Opraveno několik podstatných problémů s funkcí ohlašování příkazových kláves.
* NVDA nyní dokáže přečíst text delší než 65535 znaků i ve standardních editovatelných prvcích (např. velký soubor v Poznámkovém bloku).
* Vylepšeno čtení po řádcích v editačních polích MSHTML (upravitelné zprávy v Outlook Expressu a pole pro vkládání textu v Internet Exploreru).
* NVDA už nebude občas kompletně zamrzat při editování textu v Open Office. (#148,#180)

## 0.6p2

* Vylepšen výchozí hlas eSpeaku pro NVDA.
* Přidáno rozložení klávesnice pro laptopy. Rozložení klávesnice lze nastavit v dialogu nastavení klávesnice. (#60)
* Podpora seskupování položek v prvcích SysListView32 (tj. seznamy), které se vyskytují hlavně ve Windows Vista. (#27)
* U položek stromových seznamů je nyní oznamováno zaškrtnutí.
* Přidány zkratkové klávesy pro většinu konfiguračních dialogů NVDA.
* Podpora aplikací využívajících standardu Iaccessible2 jako je Mozilla Firefox i při spouštění NVDA z výměnných médií bez nutnosti registrovat jakékoli speciální dll knihovny.
* Odstraněn problém s padajícím seznamem odkazů ve virtuálním prohlížeči v produktech Mozilla. (#48)
* NVDA by už neměl způsobovat pád aplikací Mozilla jako jsou třeba Firefox a Thunderbird, pokud běží s vyššími právy, než samotná aplikace Mozilla např. je-li NVDA spuštěn jako administrátor.
* Řečové slovníky (dříve uživatelské slovníky) nyní mohou buď rozlišovat, nebo ignorovat velikost písmen a vkládanými položkami mohou být i regulární výrazy. (#39)
* V dialogu virtuální prohlížeč je nyní možné nastavit, jestli se má NVDA u dokumentů virtuálního prohlížeče snažit zachovat stejný vzhled jako na obrazovce.
* HTML značky pro odkaz bez uvedeného atributu href, který určuje cíl, kam má odkaz vést, už nebudou v dokumentech Mozilla čteny jako odkazy. (#47)
* Příkaz NVDA pro vyhledávání zadaného textu si nyní bude pamatovat poslední výraz, který jste hledali a to ve všech aplikacích. (#53)
* Opraven problém, kdy u některých zaškrtávacích políček a přepínačů ve virtuálním prohlížeči NVDA neoznamoval stav zaškrtnutí.
* Formulářový režim ve virtuálním prohlížeči se nyní nastavuje konkrétně pro každý dokument zvlášť, nikoli globálně pro NVDA. (#33)
* Odstraněna určitá prodleva odezvy při změnách fokusu a nesprávné přerušování řeči, pokud byl NVDA používán v systému, který je velice pomalý nebose právě probudil z úsporného režimu.
* Vylepšena podpora rozbalovacích seznamů v Mozilla Firefoxu. Konkrétně, pokud se po nich pohybujete šipkami, nebude už opakován text a při jejich opuštění nebudou oznamovány nadřazené prvky. Také již fungují příkazy virtuálního prohlížeče i v případě, kdy je některý rozbalovací seznam pod fokusem.
* Zvýšena přesnost lokalizování stavového řádku v mnoha aplikacích. (#8)
* Přidán nástroj pro interaktivní Python konzoli NVDA, aby vývojáři mohli sledovat a upravovat funkce NVDA i za chodu.
* Příkazy pro plynulé čtení, čtení označeného textu a pro ohlášení aktuálního řádku nyní fungují správně i ve formulářovém režimu virtuálního prohlížeče. (#52)
* Odstraněny skripty pro zvýšení a snížení tempa hlasu. K tomuto účelu je nyní třeba použít buď příkazy pro nastavení parametrů v kruhu nastavení hlasového výstupu (Ctrl+NVDA+šipky,) nebo přímo dialog nastavení hlasu.
* Vylepšen rozsah a interval pípání pro ohlašování indikátorů průběhu.
* Do virtuálního prohlížeče byly přidány nové klávesy rychlé navigace: l pro seznam i pro položku seznamu, e pro editační pole, b pro tlačítko, x pro zaškrtávací políčko, r pro přepínač, g pro grafiku, c pro rozbalovací seznam, q pro citaci, 1 až 6 pro nadpis odpovídající úrovně, s pro oddělovač, m pro rám. Stiskem samotné klávesy se přesunete na další nejbližší prvek daného typu na stránce, stisknete-li klávesu spolu se shiftem, přesune se kurzor naopak na nejbližší předchozí prvek. (#67,#102,#108)
* Pokud zrušíte v Mozilla Firefoxu načítání stránky, můžete stále pracovat s posledním dokumentem načteným ve virtuálním prohlížeči, pokud již nebyl skutečně smazán. (#63)
* Pohyb po slovech ve virtuálním prohlížečije nyní přesnější, protože slova již nebudou nedopatřením obsahovat text z více různých polí najednou. (#70)
* Zvýšena přesnost sledování pohybu a změn fokusu ve virtuálním prohlížeči aplikací Mozilla.
* Do nového virtuálního prohlížeče byl přidán příkaz pro vyhledání předchozího výskytu naposledy hledaného textu (shift+NVDA+F3).
* Odstraněna pomalá odezva v dialozích Mozilla Firefoxu a Thunderbirdu. (#66)
* Přidána možnost zobrazit aktuální log soubor NVDA (zápis činnosti programu od posledního spuštění až do okamžiku ukončení). Tato volba se nachází v nabídce NVDA, menu nástroje.
* Příkazy jako např. ohlášení času a data nyní berou v potas nastavený jazyk; interpunkce a slovosled se přizpůsobuje jazyku.
* Pro snazší použití nyní rozbalovací seznam jazyků v NVDA dialogu obecné nastavení zobrazuje plné názvy jazyků.
* Při čtení textu právě prohlíženého objektu pomocí čtecího kurzoru bude text vždy aktuální, pokud se dynamicky mění. Např. prohlížení položky seznamu ve Správci úloh. (#15)
* Při pohybu myší nyní bude přečten vždy aktuální odstavec pod kurzorem namísto buď celého textu daného objektu nebo pouze aktuálního slova. Také je nyní možné zapnout či vypnout zvukovou signalizaci pohybu a ohlašování typu prvku pod kurzorem. Implicitně jsou tyto volby vypnuté.
* Podpora čtení textu myší v Microsoft Wordu.
* Opravena chyba, která při opuštění aplikačního menu v aplikacích jako např. Wordpad způsobovala, že NVDA přestával číst označený text.
* Ve Winampu už není název skladby při posunu na jinou skladbu a při pozastavení, zastavení či opětovném spuštění přehrávání čten stále dokola.
* Ve Winampu byla doplněna možnost ohlašovat, zdali je zapnuto či vypnuto náhodné nebo opakované přehrávání. Tuto funkci je možné použít v hlavním okně a editoru playlistů.
* Vylepšena možnost aktivovat ve virtuálním prohlížeči pro aplikace Mozilla určitá políčka. To se může vztahovat na kliknutelnou grafiku, odkazy obsahující odstavce a jiné netypické struktury.
* Odstraněna počáteční prodleva při otevírání dialogů NVDA na některých systémech. (#65)
* Přidána specifická podpora pro aplikaci Total Commander.
* Opraven problém s ovladačem sapi4serotek, kdy se výška hlasu zasekla na určité hodnotě např. hlas zůstal vysoký po vyhláskování velkého písmene. (#89)
* Kliknutelný text a další pole budou nyní ve virtuálním prohlížeči pro aplikace Mozilla skutečně oznamovány jako kliknutelné. Např. políčko s HTML atributem onclick (při kliknutí). (#91)
* Při pohybu ve virtuálním prohlížeči se bude posouvat i text na obrazovce, aby měli vidící uživatelé přehled, kde se právě v dokumentu nacházejí. (#57)
* Doplněna základní podpora pro ARIA "live region show" události. To je užitečné např. v aplikaci Chatzilla IrC, kde již budou automaticky čteny nové zprávy.
* Drobná vylepšení pro snazší používání webových aplikací ARIA např. Google Docs.
* Při kopírování textu z virtuálního prohlížeče již do něj nebudou přidávány prázdné řádky navíc.
* Mezerník v seznamu odkazů již nebude aktivovat právě označený odkaz. Místo toho lze nyní mezeru použít stejně jako ostatní klávesy pro vyhledávání konkrétního odkazu.
* Příkaz pro přesun myši na právě prohlížený objekt (NVDA+numerické lomeno) nyní přesune myš doprostřed objektu místo do levého horního rohu.
* Přidány příkazy pro kliknutí levým a pravým tlačítkem myši (numerické lomeno a numerická hvězdička).
* Vylepšen přístup k systémové liště. Fokus by již neměl nadále neustále přeskakovat zpátky na jednu konkrétní položku. Pro přesun na systémovou lištu použijte klávesy Windows+b. (#10)
* Pokud při pohybu v editačním poli držíte kurzorovou šipku a dostanete se tak na jeho konec, NVDA bude rychleji reagovat a již nebude číst nadbytečný text.
* Při čtení některých zpráv už není nutné čekat, než NVDA domluví. Tím bylo odstraněno padání a zamrzání některých hlasových výstupů. (#117)
* Doplněna podpora pro hlasový výstup Audiologic Tts3. Tuto úpravu provedl/a Gianluca Casalino. (#105)
* Zřejmě zvýšen výkon při pohybu v dokumentech Microsoft Wordu.
* Zvýšena přesnost při čtení upozornění v aplikacích Mozilla.
* Odstraněno případné padání NVDA při pokusu uložit nastavení na neanglických verzích Windows. (#114)
* Přidán uvítací dialog. Tento dialog má poskytnout novým uživatelům základnní informace o používání NVDA a také umožňuje nastavit capslock jako NVDA klávesu. Bude se zobrazovat při každém spuštění NVDA, pokud to uživatel nepřenastaví.
* Opravena základní podpora Adobe readeru, takže je možné číst dokumenty i ve verzích 8 a 9.
* Odstraněny určité chyby, ke kterým mohlo docházet, pokud uživatel stiskl některou klávesu ještě předtím, než byl NVDA náležitě inicializován.
* Jestliže je zapnutá volba, aby se při ukončení NVDA ukládala nastavení, NVDA se ujistí, že nastavení byla skutečně správně uložena i při vypínání počítače nebo odhlašování uživatele z Windows.
* Při spuštění instalačního programu se nyní přehraje nové zvukové logo NVDA vytvořené Victerem Tsaranem.
* Všechny verze NVDA, instalační i přenosná, by nyní měly při ukončení spolehlivě vymazat ze systémové lišty svou ikonu.
* Názvy standardních prvků v dialozích NVDA (jako jsou tlačítka ok a storno) by se nyní měly zobrazovat v nastaveném jazyce NVDA, místo, aby zůstávaly v angličtině.
* Ikona NVDA nyní bude použita pro zástupce NVDA v nabídce start a na ploše, místo výchozí ikony pro aplikace.
* Při pohybu klávesami tab a shift+tab v MS Excelu budou čteny buňky. (#146)
* V některých seznamech ve Skype už nebudou určité části textu čteny dvakrát.
* Zlepšeno sledování systémového kurzoru v aplikacích Iaccessible2 a Java; např. v Open Office nebo Lotus Symphony nyní NVDA skutečně počká, až se kurzor přestane pohybovat po dokumentu, místo, aby omylem přečetl jakékoli slovo nebo řádek na konci některého odstavce. (#119)
* Podpora pro prvky AkelEdit, které se nacházejí v programu Akelpad 4.0.
* NVDA se už nezasekne v Lotus Symphony při přesunu z dokumentu do aplikačního menu.
* NVDA už nezamrzne v ovládacím panelu přidat nebo odebrat programy systému Windows XP při spuštění odinstalace některého programu. (#30)
* NVDA už nezamrzá při spuštění Spybot Search and Destroy.

## 0.6p1

### Přístup k webovému obsahu díky novému, stále vyvíjenému virtuálnímu prohlížeči (zatím pro aplikace Mozilla včetně Firefoxu 3 a Thunderbirdu 3).

* Doba načítání byla téměř třicetkrát zkrácena (u většiny webových stránek teď už vůbec nemusíte čekat, než se načtou do prohlížeče).
* Přidán dialog pro seznam odkazů (NVDA+F7).
* Vylepšen NVDA dialog pro vyhledávání (Ctrl+nvda+F), takže nerozlišuje velikost písmen a opraveny jisté problémy s fokusem v tomto dialogu.
* V novém virtuálním prohlížeči je nyní možné označovat a kopírovat text.
* Nový virtuální prohlížeč standardně zobrazuje dokumenty ve stejné podobě jako na obrazovce - odkazy a prvky nejsou na samostatných řádcích, pokud tak skutečně nejsou umístěny vizuálně. Tuto funkci můžete přepínat klávesami NVDA+v.
* Lze se pohybovat po odstavcích pomocí zkratek Ctrl+šipka nahoru a ctrl+šipka dolů.
* Vylepšena podpora dynamického obsahu.
* Zvýšena celková přesnost čtení řádků a polí při pohybu šipkami nahoru a dolů.

== Internacionalizace ==
* Nyní je možné psát národní znaky, které závisí na tzv. mrtvém znaku i za chodu NVDA.
* NVDA nyní oznamuje změny rozložení klávesnice při stisku Alt+Shift.
* Oznamování data a času nyní bere v potas systémová místní a jazyková nastavení.
* Doplněna čeština od Tomáše Valůška za pomoci Jaromíra Víta.
* Doplněna vietnamština od Danga Hoai Phuc.
* Doplněna afrikánština (af_ZA) od Willema van der Walta.
* Doplněna ruština od Dmitryho Kaslina.
* Doplněna polština od DOROTY CZAJKY a přátel.
* Doplněna japonština od Katsutoshi Tsuji.
* Doplněna thajština od Amorna Kiattikhunrata.
* Doplněna chorvatština od Maria Percinice a Hrvoje Katic.
* Doplněna galijština od Juana C. buna.
* Doplněna ukrajinština od Alekseje Sadovoje.

### Řeč

* NVDA je nyní dodáván spolu s eSpeakem 1.33, který obsahuje mnoho vylepšení. K nim patří např. upravené jazykové verze, pojmenované varianty hlasů, možnost mluvit rychleji.
* V dialogu nastavení hlasu je nyní možné nastavit variantu hlasu, pokud daný hlas varianty podporuje. Varianta je v podstatě jen mírná úprava daného hlasu. eSpeak varianty podporuje (v české verzi je pojem varianta překládán jako osoba, vyskytuje se pouze v tomto dialogu).
* Přidána možnost změnit v dialogu nastavení hlasu intonaci, pokud tuto funkci právě používaný hlas podporuje. Espeak intonaci podporuje.
* Přidána možnost vypnout oznamování informací o pozici objektu (např. 1 z 4). Tuto volbu je možné nastavit v dialogu prezentace objektů.
* NVDA nyní může pípat při čtení velkých písmen. Toto nastavení lze ovlivnit zaškrtávacím políčkem v dialogu nastavení hlasu. Bylo také přidáno políčko "zvýšit hlas při čtení velkých písmen", kterým lze pro NVDA nastavit tuto dříve standardní interpretaci velkých písmen. Takže nyní mohou být velká písmena oznamována buď zvýšením hlasu, pípnutím, nebo jen slovem velké. Tyto možnosti mohou být libovolně kombinovány.
* Doplněna možnost pozastavit mluvení (jako je tomu u odečítače Voiceover pro operační systém Mac). Kdykoli NVDA něco říká, můžete stiskem klávesy Ctrl nebo shift přerušit řeč a pokud později opět stisknete shift, (jestliže jste do té doby nestiskli nic jiného), řeč bude pokračovat přesně od toho místa, kde byla přerušena.
* Přidán ovladač pro virtuální hlasový výstup, který vypisuje text do okna namísto předčítání hlasem. Tento způsob by měl být příjemnější pro vidící vývojáře, kteří nejsou zvyklí na hlasovou syntézu, ale chtějí vědět, co NVDA říká. Tato funkce má pravděpodobně ještě chyby, takže zpětná vazba je rozhodně velice vítána.
* NVDA už nadále nebude implicitně číst interpunkci. Čtení interpunkce můžete opět povolit zkratkou NVDA+p nebo přímo v dialogu nastavení hlasu.
* eSpeak nyní standardně mluví o dost pomaleji, takže noví uživatelé, kteří ho slyší poprvé při instalaci NVDA nebo celkově s NVDA teprve začínají, by mu nyní měli snáze rozumět.
* Do NVDA byly přidány uživatelské slovníky. S jejich pomocí můžete NVDA přimět, aby vyslovoval daný text určitým způsobem. Slovníky jsou celkem tři: výchozí, pro aktuální hlas a dočasný. Položky, které přidáte do výchozího slovníku, budou mít při běhu NVDA neustálou platnost. Slovník pro aktuální hlas je určen pouze pro hlasový výstup a konkrétní hlas, který je právě používán a dočasný slovník je navržen pro ty případy, kdy chcete rychle určit nějaké pravidlo při provádění konkrétního úkolu, ale nepřejete si, aby fungovalo stále (bude smazáno při ukončení NVDA). Prozatím musí být pravidla zadávána jako regulární výrazy, nikoli jako normální text.
* Hlasové výstupy mohou nyní používat kterékoli výstupní zvukové zařízení, pokud zvolíte požadované zařízení v příslušném rozbalovacím seznamu v dialogu hlasové výstupy ještě před samotným syntezátorem.

### Výkon

* NVDA už nezabírá podstatnou část systémové paměti při editaci zpráv v editovatelných prvcích mshtml.
* Zrychlena odezva při prohlížení textu mnohých prvků, které ve skutečnosti neobsahují žádný kurzor. Např. okno s historií programu MSN, položky stromových i běžných seznamů atd.
* Zrychlena odezva v richedit dokumentech.
* NVDA už by neměl postupně zabírat stále více místa v systémové paměti bez jakéhokoli důvodu.
* Odstraněny chyby při pokusu umístit fokus do okna dosovské konzole zhruba třikrát za sebou. NVDA měl v takových případech tendenci úplně padat.

### Klávesové příkazy

* Nové klávesové zkratky NVDA+Shift+numerická 6 a NVDA+Shift+numerická 4 umožňují přesun na další, resp. předchozí nejbližší objekt v řadě (na stejné úrovni jako aktuální objekt). To znamená, že nyní můžete veškerou objektovou navigaci po aplikaci provádět pouze těmito dvěma klávesami, bez nutnosti strachovat se, že se omylem při procházení objektovou hierarchií přesunete na nadřazený objekt nebo na první z podřazených vzhledem k úrovni aktuálního objektu. Například ve webovém prohlížeči, jako je Firefox, se nyní můžete pohybovat po dokumentu pomocí objektové navigace s využitím pouze těchto dvou kláves. Pokud vás posun po objektech v řadě přemístí v objektové struktuře o úroveň výš nebo níž, NVDA to dá najevo odpovídajícím pípnutím znázorňujícím pohyb v příslušném směru.
* Nyní je možné měnit nastavení hlasu přímo bez nutnosti otevírat dialog nastavení hlasu, použitím tzv. kruhu nastavení hlasového výstupu. Jedná se o skupinu jednotlivých parametrů hlasu, mezi nimiž se můžete přepínat kombinacemi kláves Ctrl+NVDA+šipka doprava a Ctrl+NVDA+šipka doleva. Každou z hodnot jednotlivých parametrů pak můžete nastavovat kombinacemi kláves Ctrl+NVDA+šipka nahoru a Ctrl+NVDA+šipka dolů. Změny se projeví okamžitě.
* Přidán příkaz pro přečtení aktuálně označeného textu v editačním poli (NVDA+Shift+šipka nahoru).
* Celá řada příkazů NVDA pro přečtení určitého úseku textu např. aktuální řádek atd nyní umí text vyhláskovat, pokud jejich zkratkovou klávesu stisknete dvakrát rychle po sobě.
* Klávesy capslock, numerický insert a insert nyní mohou být všechny použity jako NVDA klávesa. Pokud je takto některá z těchto kláves použita a stisknete-li ji dvakrát rychle za sebou bez použití dalších kláves, NVDA ji propustí do systému, jako byste ji stiskli, kdyby NVDA nebyl vůbec spuštěn. Pokud chcete kteroukoli z těchto kláves nastavit jako NVDA klávesu, zaškrtněte její odpovídající zaškrtávací políčko v dialogu nastavení klávesnice (dříve byl tento dialog pojmenován odezva klávesnice).

### Podpora aplikací

* V oknech s historií programů MSN Messenger a Windows Live Messenger je nyní možné označovat a kopírovat text.
* Vylepšena podpora pro aplikaci Audacity.
* Doplněna podpora pro několik editačních či textových prvků ve Skype.
* Vylepšena podpora pro aplikaci Miranda Instant Messenger.
* Opraveny některé problémy s fokusem při otevírání zpráv ve formátu prostého textu i HTML v Outlook Expressu.
* Políčka pro zprávy v diskusních skupinách v Outlook Expressu jsou nyní správně pojmenovávána.
* NVDA nyní dokáže číst e-mailové adresy v příslušných políčkách Outlook Expressu (komu, od, kopie atd).
* NVDA by nyní měl být přesnější při oznamování následující zprávy v Outlook Expressu po smazání některé zprávy ze seznamu zpráv.

### Rozhraní a vývojová prostředí

* Vylepšena objektová navigace pro objekty MSAA (Microsoft Active Accessibility). Pokud se v okně nachází systémová nabídka, titulkový pruh nebo lišty pro posun, můžete se na ně tímto způsobem dostat.
* Doplněna podpora pro rozhraní Iaccessible2 vylepšující přístupnost některých aplikací. Nejen, že tak NVDA může číst více typů prvků, ale také díky Iaccessible2 dokáže v aplikacích jako Firefox 3 či Thunderbird 3 manipulovat s kurzorem, což vám umožňuje čtení a označování textu.
* Přidána podpora pro editovatelné prvky typu Scintilla (takové prvky se nacházejí např. v programech Notepad++ nebo Tortoise SVN).
* Doplněna podpora pro aplikace Java prostřednictvím Java Access Bridge. Tak je zajištěna základní podpora pro Open Office, (pokud je Java povolena) a kteroukoli jinou samostatnou aplikaci Java. Berte, prosím, na vědomí, že Java applety ve webových prohlížečích ještě fungovat nemusí.

### Myš

* Vylepšené čtení textu pod ukazatelem myši při jeho pohybu. Je nyní mnohem rychlejší a také je u některých standardních editovatelných prvků a u prvků Java a Iaccessible2 možné přečíst aktuální slovo, ne jen aktuální objekt. Toho mohou využít slabozrací, kteří si myší chtějí přečíst jen určité místo v textu.
* Do dialogu nastavení myši byla přidána nová volba. Je-li zaškrtnuto "pohyb myši indikovat zvukovým signálem", pak se při každém pohybu myši přehraje 40 milisekund dlouhé pípnutí, jehož výška (mezi 220 a 1760 Hz) reprezentuje osu y (vertikální pozici na obrazovce) a hlasitost v levém a pravém kanále zase osu x (horizontální pozici na obrazovce). Tak může nevidomý člověk získat při pohybu myší přibližnou představu, kde na obrazovce se právě nachází. Tato funkce také závisí na tom, jestli je zapnuto ohlašování objektu pod kurzorem myši. Pokud budete potřebovat rychle vypnout jak ohlašování objektu pod myší, tak pípání, stačí stisknout NVDA+m. Pípání je také hlasitější nebo tišší podle toho, jaký jas má dané místo na obrazovce.

### Prezentace objektů a interakce s nimi

* Vylepšena podpora většiny standardních stromových seznamů. NVDA nyní při rozbalení kterékoli větve oznámí, kolik dalších položek obsahuje. Také při rozbalení či sbalení libovolné položky oznamuje úroveň vnoření, číslo aktuální položky a celkový počet všech položek v seznamu vzhledem k aktuální větvi, nikoli k celému seznamu.
* Vylepšeno oznamování změn fokusu při pohybu po aplikacích a v operačním systému. Nyní už namísto pouhého jména prvku, na němž je fokus nově umístěn, uslyšíte i informace o všech ostatních prvcích, uvnitř kterých se tento prvek nachází. Například, pokud umístíte fokus na tlačítko v rámci seskupení, NVDA nyní oznámí i toto seskupení.
* NVDA se nyní snaží číst při objevení dialogu i jeho obsah. Většinou se mu to daří poměrně přesně, i když ještě existuje mnoho dialogů, se kterými nepracuje tak dobře, jak by mohl.
* Do dialogu pro nastavení prezentace objektů byla přidána nová volba "hlásit popisky objektů: Pokročilí uživatelé si ji někdy mohou přát vypnout, aby zabránili NVDA ve čtení mnoha podrobných popisků u některých prvků jako např. v Java aplikacích.
* Pokud se fokus přemístí na editační políčko, NVDA nyní automaticky oznámí v tomto políčku označený text. Jestliže není označen žádný text, bude přečten aktuální řádek.
* NVDA nyní přehrává pípnutí pro oznámení hodnot indikátorů průběhu v různých aplikacích mnohem opatrněji. Nejvýrazněji to ovlivňuje práci v aplikacích od Eclipse např. Lotus Symphony nebo Accessibility Probe.

### Uživatelské rozhraní

* Okno aplikace NVDA bylo odstraněno a nahrazeno prostou kontextovou nabídkou NVDA.
* Dialog pro nastavení uživatelského rozhraní byl přejmenován na obecné nastavení. Obsahuje nyní také jednu novou volbu: rozbalovací seznam pro určení úrovně logování, tj. jaké zprávy se mají zapisovat do NVDA log souboru. Poznámka: NVDA log soubor se od této verze jmenuje nvda.log, nikoli debug.log.
* Z dialogu prezentace objektů bylo odstraněno zaškrtávací políčko "hlásit názvy skupin objektů". To je nyní řešeno jiným způsobem.

## 0.5

* NVDA nyní obsahuje vestavěný hlasový syntezátor nazvaný eSpeak, vyvíjený Jonathanem Duddingtonem. Má velice rychlou odezvu, je velmi kompaktní a podporuje mnoho různých jazyků. Je stále možné používat SAPI syntezátory, ale eSpeak bude používán jako výchozí hlas.
* Espeak není závislý na žádném dalším speciálním softwaru, takže ho můžete použít spolu s NVDA na kterémkoli počítači, na USB klíčence nebo prostě na čemkoli. Pro více informací o eSpeaku nebo pro stažení aktuální verze navštivte https://espeak.sourceforge.net/.
* Odstraněna chyba při mazání znaku v editačních polích Internet Exploreru a Outlook Expressu, kdy NVDA četl nesprávný znak.
* Ve Skype je nyní podporováno více editačních polí.
* Dokumenty do virtuálního prohlížeče budou nyní načítány teprve v případě, kdy se pod fokusem ocitne okno, které je třeba načíst. Tak byla odstraněna chyba v Outlook Expressu, kdy se tímto způsobem někdy v nesprávnou chvíli aktivoval panel náhledu.
* Přidány parametry pro spouštění NVDA z příkazového řádku: -m, --minimal: Nepřehrávat při spuštění a ukončení znělky a nezobrazovat po spuštění dialog rozhraní, pokud je NVDA takto nastaven. -q, --quit: Ukončit všechny případné běžící instance NVDA (nejprve všechny ostatní a poté tu aktuální). -s, --stderr-file název_souboru: určit, kam má NVDA ukládat nezachycené chyby a výjimky. -d, --debug-file název souboru: Určit, kam má NVDA ukládat ladicí zprávy. -c, --config-file: Určit alternativní konfigurační soubor. -h, -help: Zobrazit nápovědnou zprávu s výpisem parametrů pro spuštění NVDA z příkazového řádku.
* Odstraněna chyba, kdy interpunkční znaménka nebyla překládána do správného jazyka, pokud byl jazyk NVDA nastaven na jiný, než angličtinu, a pokud byla zapnuta volba hlásit psané znaky.
* Díky Peterovi Vágnerovi byly přidány jazykové soubory pro slovenštinu.
* Přidány dialogy pro nastavení virtuálního prohlížeče a ohlašování formátování dokumentu, vytvořené Peterem Vágnerem.
* Doplněna francouzština díky Micheli Suchovi.
* Přidán příkaz pro zapnutí nebo vypnutí pípání indikátorů průběhu (insert+u). Vytvořil Peter Vágner.
* Více zpráv NVDA bylo nyní uzpůsobeno pro překlad do jiných jazyků. Patří k nim i popisy příkazů v klávesové nápovědě.
* Do virtuálního prohlížeče (Internet Explorer a Firefox) byl přidán nový dialog pro vyhledávání textu. Stisk Ctrl+f při čtení webové stránky vyvolá dialog, kam můžete vepsat libovolný text, který má být vyhledán. Stiskem enteru pak bude zadaný text na stránce vyhledán a kurzor virtuálního prohlížeče se na něj přemístí. Po stisku F3 bude vyhledán následující výskyt hledaného výrazu. (Stejným způsobem funguje vyhledávání ve většině běžných aplikací.)
* Při zapnuté volbě hlásit psané znaky nyní může být oznamováno více znaků. Technicky řečeno nyní dokáže NVDA ohlásit při psaní ascii znaky s hodnotami v rozmezí 32 až 255.
* Některé typy prvků byly přejmenovány pro lepší čitelnost. Upravitelný text je nyní editační pole, přehled je stromový seznam a stisknutelné tlačítko je prostě tlačítko.
* Pro rychlejší navigaci už NVDA nehlásí typ prvku při pohybu šipkami popoložkách běžného či stromového seznamu (položka seznamu, položka stromového seznamu atd).
* Hláška "má podnabídku", která měla upozornit, že určitá položka nabídky obsahuje podnabídku, byla nahrazena prostým "podnabídka".
* V případě, kdy některé jazyky používají Ctrl nebo Alt (případně altGR) k zadávání speciálních znaků, bude NVDA tyto znaky hlásit při zapnuté volbě hlásit psané znaky.
* Opraveny problémy při prohlížení statických textových prvků.
* Doplněn překlad pro tradiční čínštinu, zásluhou Coscella Kaa.
* Byla přepracována důležitá část kódu NVDA, čímž by měly být eliminovány problémy s uživatelským rozhraním (včetně konfiguračních dialogů).
* Do NVDA byla doplněna podpora pro Sapi4. Můžete použít dva ovladače, jeden je založený na kódu od společnosti Serotek Corporation a druhý využívá standardního ActiveVoice.ActiveVoice com rozhraní. Zkuste, který vám bude fungovat lépe.
* Jestliže se nyní pokusíte spustit novou kopii NVDA, pokud zároveň ještě běží starší, nově spuštěná kopie bude zkrátka ukončena. Tím odpadá dřívější problém při spouštění více kopií NVDA najednou, jehož důsledkem byl pak systém prakticky nepoužitelný.
* Dialog uživatelského rozhraní byl přejmenován na "NVDA" místo "rozhraní NVDA".
* Opravena chyba při stisku backspace na začátku upravitelné zprávy v Outlook Expressu, která způsobovala chybu.
* Přidán patch od Ruie Batisty, který obsahuje nový příkaz pro zjištění aktuálního stavu baterie na laptopech (insert+shift+b).
* Přidán hlasový ovladač nazvaný Silence (bez mluvení). Při jeho používání NVDA nic neříká, čímž je možné zajistit jeho stálé mlčení. Tento ovladač by mohl být v budoucnu využit v kombinaci s podporou braillských řádků, až bude do NVDA doplněna.
* Přidáno nastavení pro zvýšení hlasu při čtení velkých písmen, zásluhou J.J. Meddaugha.
* Přidán patch od J.J. Meddaugha, díky němuž se teď volba "oznamovat text pod kurzorem myši" chová jako ostatní podobné přepínací volby (říká pouze zapnuto/vypnuto, namísto změny celé hlášky).
* Doplněn španělský překlad (es) od Juana C. Buna.
* Přidán maďarský jazykový soubor od Tamase Gczyho.
* Přidán portugalský jazykový soubor od Ruie Batisty.
* Při změně hlasu v dialogu nastavení hlasu jsou posuvníky pro  tempo, hlasitost a výšku hlasu nastaveny na nové hodnoty podle zvoleného hlasu, místo, aby byl hlas nucen přizpůsobit se starým hodnotám těchto nastavení. Tak je odstraněna chyba, kdy hlasové výstupy jako eloquence nebo viavoice zdánlivě mluvily rychleji než všechny ostatní syntezátory.
* Opravena chyba, kdy by NVDA buď přestal mluvit nebo by úplně spadl v okně dosovské konzole.
* Pokud existuje podpora pro konkrétní jazyk, NVDA nyní může automaticky zobrazovat své rozhraní a číst své zprávy v jazyce nastaveném ve Windows. Je však stále možné také zvolit určitý jazyk ručně v dialogu nastavení uživatelského rozhraní.
* Přidán nový příkaz "hlásit dynamicky změněný obsah" (NVDA+5); Přepíná, jestli má být automaticky oznamován nový text a další dynamické změny. Prozatím však funguje pouze v oknech dosovských konzolí.
* Přidán příkaz "textový kurzor pohybuje čtecím kurzorem" (NVDA+6). Přepíná, zda má být čtecí kurzor automaticky přizpůsobován poloze systémového kurzoru. Je užitečný při čtení textu v oknech dosovských konzolí, když se mění informace na obrazovce.
* Přidán příkaz "změna fokusu změní prohlížený objekt" (NVDA+7). Určuje, zda má být při změně fokusu právě prohlížený objekt nastaven na objekt pod fokusem.
* Doplněny překlady dokumentace do různých jazyků. Prozatím se to týká francouzštiny, španělštiny a finštiny.
* Odstraněna vývojářská dokumentace zbinární distribuce NVDA. Nyní je dostupná pouze v distribuci zdrojového kódu.
* Odstraněna potenciální chyba ve Windows Live Messengeru a MSN Messengeru, kde pohyb šipkami nahoru a dolů po seznamu kontaktů způsoboval problémy.
* Nové zprávy v okně konverzace MSN Messengeru budou nyní čteny automaticky. Toto zatím funguje pouze v anglické verzi NVDA.
* Okno historie v konverzaci Windows Live Messengeru je nyní čitelné. Toto zatím funguje pouze v anglické verzi NVDA.
* Přidán příkaz "propustit následující klávesu" (NVDA+F2). Stisknete-li tuto klávesu, tak jakákoli následující stisknutá klávesa bude odeslána přímo do Windows. To je užitečné, pokud potřebujete stisknout v nějaké aplikaci určitou klávesovou zkratku, ale NVDA ji používá k jinému účelu.
* NVDA už nebude zamrzat na déle než minutu při otevírání velmi rozsáhlých dokumentů v Microsoft Wordu.
* Odstraněna chyba, která při opuštění tabulky v MS Wordu a opětovném vstupu do ní způsobovala, že NVDA už nehlásil čísla aktuálního řádku a sloupce, pokud jste se vrátili přesně do téže buňky.
* Při spuštění NVDA s nastaveným hlasem, který neexistuje nebo nepracuje správně, se NVDA pokusí načíst výchozí hlas rozhraní Sapi5. Pokud ani to nefunguje, bude spuštěn bez mluvení.
* Příkazy pro zvýšení a snížení výšky hlasu nyní nemohou nastavit větší výšku než 100 nebo menší než 0.
* Pokud se při volbě jazyka v dialogu nastavení uživatelského rozhraní vyskytne chyba, objeví se zpráva, která na tuto skutečnost uživatele upozorní.
* NVDA se nyní při změně jazyka v dialogu nastavení uživatelského rozhraní zeptá, zda má uložit nastavení a restartovat se. ABy se změna jazyka plně projevila, musí být NVDA restartován.
* Pokud není možné při volbě hlasového výstupu v dialogu hlasové výstupy zvolený syntezátor načíst, NVDA na tuto skutečnost upozorní.
* Při prvním načítání zvoleného syntezátoru nechá NVDA syntezátor, aby si sám zvolil nejvíce vyhovující hlas, tempo a výšku, místo, aby mu vnutil svá výchozí nastavení, která mu připadají v pořádku. Tím je odstraněn problém, kdy Sapi4 syntezátory eloquence a viavoice začínaly na to, že byly spouštěny poprvé, mluvit příliš rychle.

