# NVDA NVDA_VERSION  Uživatelská příručka

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Přehled klávesových zkratek -->



## Úvod {#toc2}

Vítejte v NVDA!

NonVisual Desktop Access (NVDA) je otevřený a volně šiřitelný odečítač obrazovky pro operační systém Microsoft Windows.
Díky zpětné vazbě hlasových výstupů a braillských řádků zpřístupňuje NVDA nevidomým a zrakově postiženým práci na počítači s operačním systémem Windows za stejnou finanční částku jako vidícím osobám.
Vývoj NVDA zastřešuje organizace [NV Access](https://www.nvaccess.org/), za pomoci příspěvků od členů komunity.

### Základní  informace {#toc3}

NVDA umožňuje nevidomým a zrakově postiženým pracovat s operačním systémem Windows a mnoha aplikacemi třetích stran.

Nejvýznamnější přednosti programu: 

* Podpora pro populární aplikace včetně internetových prohlížečů, emailových klientů, programů sloužících na okamžitou komunikaci a kancelářských balíků
* Vestavěný hlasový výstup, s podporou více než 80 jazyků
* Oznamování informací o formátování textu jako např. název a velikost písma, styl textu či pravopisné chyby
* Automatické ohlašování textu pod kurzorem myši a volitelná akustická indikace pozice myši
* Podpora mnoha braillských řádků včetně vstupu pro počítačové Braillovo písmo pro řádky s braillskou klávesnicí
* Možnost spuštění programu z USB klíče nebo jiného přenosného zařízení bez nutnosti instalace
* Snadný ozvučený instalátor
* Přeložený do 51 jazyků
* Podpora pro moderní operační systémy Windows a to jak pro 32 bitové, tak i 64 bitové verze
* Možnost spouštění na přihlašovací a jiných zabezpečených obrazovkách systému Windows
* Kompatibilita s různými rozhraními sloužícími na spřístupnění aplikací: Microsoft Active Accessibility, Java Access Bridge, IAccessible2 a UI Automation
* Podpora prostředí příkazového řádku a konzolových aplikací

### Mezinárodní podpora {#toc4}

Je nezbytné, aby lidé, kdekoli na světě, hovořící jakýmkoli jazykem, měli stejný přístup k speciálním technologiím. 
Vedle angličtiny byl NVDA dodnes přeložen do těchto 51 jazyků: afrikánština, albánština, amharština, arabština, aragónština, barmština, brazilská portugalština, bulharština, čeština, dánština, finština, francouzština, galicijština, gruzínština, hebrejština, hindština, holandština, chorvatština, irština, islandština, italština, japonština, kannadština, katalánština, kolumbijská španělština, korejština, litevština, maďarština, makedonština, nepálština, němčina, norština, pandžábština, perština, polština, portugalština, rumunština, ruština, řečtina, slovenština, slovinština, srbština, španělština, švédština, tamilština, thajština, taiwanská čínština, tradiční čínština, turečtina, ukrajinština a vietnamština. 

### Podpora hlasového výstupu {#toc5}

Bez ohledu na poskytování hlášení a rozhraní v několika jazycích NVDA nabízí možnost čtení textů v jakémkoli jazyce, jestliže je dostupný hlasový výstup pro daný jazyk. 

NVDA je distribuován s vícejazyčným volně šiřitelným/open-source hlasovým výstupem [eSpeak NG](https://github.com/espeak-ng/espeak-ng).

Informace o dalších hlasových výstupech podporovaných programem NVDA naleznete v kapitole [Podporované Hlasové Výstupy](#SupportedSpeechSynths).

### Podpora braillských řádků {#toc6}

Pro uživatele, kteří vlastní braillský řádek, umožňuje NVDA hmatový výstup v braillově písmu. 
Je podporován braillský vstup pro plnopis i zkratkopis přes braillskou klávesnici.
Informace o podporovaných typech braillských řádků naleznete v kapitole [Podporované Braillské Řádky](#SupportedBrailleDisplays).

NVDA podporuje různé kódové tabulky včetně plnopisu, zkratkopisu a počítačového písma.

### Licence a autorská práva {#toc7}

NVDA je chráněn autorskými právy Copyright NVDA_COPYRIGHT_YEARS Tým NVDA 

NVDA je chráněn licencí GNU General Public License verze 2.0.
Program můžete libovolně šířit a upravovat za předpokladu, že k němu přiložíte tuto licenci a zpřístupníte jeho zdrojový kód všem zájemcům.
Toto se vztahuje jak na původní, tak upravené kopie tohoto programu a také na software užívající kód převzatý z tohoto programu.
Kompletní licenci najdete na [této stránce](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html).

## Systémové požadavky {#toc8}

* NVDA je možno spustit na všech 32 i 64 - bitových verzích systému Windows 7, Windows 8, Windows 8.1, Windows 10 a rovněž v serverových edicích Windows od verze Windows Server 2008 R2. 
 * Pro Windows 7 je vyžadována aktualizace Service Pack 1 nebo vyšší.
 * Pro Windows Server 2008 R2 je vyžadována aktualizace Service Pack 1 nebo vyšší.
* Měli byste mít nejméně 256 MB operační paměti.
* Výkonnost procesoru se odhaduje na 1 GHz nebo rychlejší.
* Měli byste mít aspoň 90 MB volného místa na disku.

## Jak získat  a nainstalovat NVDA {#toc9}

Pokud dosud nevlastníte kopii programu NVDA, můžete si ji stáhnout ze stránek: [www.nvaccess.org](NVDA_URL).

Vejděte do sekce Download, kde naleznete přímý odkaz ke stažení nejnovější verze NVDA. 

Při spuštění staženého souboru se spustí dočasná kopie NVDA.
Pak si můžete vybrat, jestli chcete NVDA nainstalovat, vytvořit přenosnou verzi nebo pokračovat v užívání dočasné kopie.

Pokud chcete NVDA používat na vašem počítači, budete ho chtít pravděpodobně nainstalovat.
Nainstalovaná kopie umožňuje přístup k funkcím, které nejsou dostupné s přenosnou nebo dočasnou kopií, jako automatické spuštění po přihlášení, možnost čtení přihlašovacích a zabezpečených obrazovek, také vytvoří odkazy v nabídce start a na ploše.
Je také možné kdykoliv vytvořit z nainstalované kopie přenosnou.

Pokud chcete NVDA vzít s sebou na USB klíč nebo jiné přepisovatelné médium, měli byste použít přenosnou kopii.
Také lze tuto verzi kdykoliv později běžně nainstalovat na počítač.
Pokud však chcete NVDA na CD a jiných médiích jen pročtení, měli byste pouze zkopírovat instalační balíček.
Momentálně není možné spustit přenosnou kopii na médiích jen pro čtení.

Je také možné používat dočasnou kopii pro demonstrační účely, ovšem spouštění NVDA pokaždé tímto způsobem může být zdlouhavé.

### Omezení přenosné a dočasné kopie {#toc10}

Kromě toho, že nelze spustit přenosné či dočasné kopie automaticky po přihlášení, mají ještě následující omezení:

* Nelze komunikovat s aplikacemi, které běží s administrátorským oprávněním, pokud NVDA sám nemá tato oprávnění (nedoporučuje se).
* Nelze číst obrazovku kontroly uživatelského účtu (UAC) při spuštění aplikace s administrátorským oprávněním.
* Windows 8 a pozdější: není podporován vstup z dotykové obrazovky.
* Windows 8 a pozdější: nelze zpřístupnit režim prohlížení a hlášení psaných znaků v aplikacích Windows Store.
* Windows 8 a pozdější: není podporováno tlumení zvuku.

### Instalace NVDA {#toc11}

Pokud instalujete NVDA přímo z instalačního balíčku, stiskněte tlačítko nainstalovat NVDA.
Pokud jste již zavřeli tento dialog nebo chcete instalovat z přenosné kopie, vyberte položku nainstalovat NVDA, kterou najdete v nástrojích v nabídce NVDA.

Objeví se instalační dialogpro potvrzení, jestli si přejete nainstalovat NVDA, a také oznámí, jestli se touto instalací bude aktualizovat předchozí verze.
Instalaci NVDA spustíte stisknutím tlačítka pokračovat.
Také je v tomto dialogu několik možností, které jsou vysvětleny níže.
Až instalace skončí, objeví se zpráva o úspěšné instalaci.
Stisknutím OK se nová instalace NVDA restartuje.

#### Spuštění při zobrazení přihlašovací obrazovky {#toc12}

Zde si můžete určit, jestli se má nebo nemá NVDA spustit automaticky při zobrazení přihlašovací obrazovky ještě než zadáte heslo.
Také jsou zde obsažena ovládání UAC a další zabezpečené obrazovky.

#### Vytvořit odkaz na ploše (ctrl+alt+n) {#toc13}

Zde si můžete určit, jestli NVDA má nebo nemá vytvořit odkaz na ploše pro spuštění NVDA.
Pokud bude vytvořen, bude přiřazena zkratková klávesa control+alt+n, kterou můžete NVDA kdykoli spustit.

#### Zkopírovat nastavení z přenosné verze do aktuálního uživatelského účtu {#toc14}

Zde si můžete určit, jestli NVDA má nebo nemá zkopírovat nastavení právě spuštěné verze NVDA do nastavení instalované verze právě přihlášeného uživatele.
Tímto se nezkopírují nastavení do dalších uživatelských účtů v systému nebo do systémového nastavení pro přihlášení do Windows a dalších zabezpečených obrazovek.
Tato možnost je dostupná jen, když instalujete z přenosné verze, nikoli při instalaci přímo ze staženého balíčku.

### Vytvoření přenosné kopie {#toc15}

Pro vytvoření přenosné kopie přímo z instalačního balíčku stiskněte tlačítko vytvořit přenosnou kopii.
Pokud jste už zavřeli tento dialog nebo máte spuštěnou nainstalovanou verzi NVDA, vyberte položku vytvořit přenosnou kopii, která se nachází v nástrojích v nabídce NVDA.

V následujícím dialogu si můžete vybrat, kde by se měla uložit přenosná kopie.
Může to být adresář na hard disku, USB disku nebo dalších přenosných médiích.
Také si můžete vybrat, jestli se mají zkopírovat aktuální uživatelská nastavení, aby se dala použít s nově vytvořenou přenosnou kopií.
 Tato možnost je k dispozici pouze při instalaci přenosné verze z nainstalované, nikoli při vytváření přenosné kopie přímo z instalačního balíčku.
Stisknutím tlačítka pokračovat se vytvoří přenosná kopie.
Když je hotová, potvrdí se úspěšná instalace.
Pro uzavření tohoto dialogu stiskněte tlačítko OK.

## Začínáme s NVDA {#toc16}
### Spuštění NVDA {#toc17}

Když už máte nainstalovaný NVDA podle pokynů instalátoru, spustit NVDA je velmi jednoduché. Stačí stisknout klávesovou zkratku Ctrl+Alt+N nebo zvolit položku NVDA z nabídky Start/Programy/NVDA. 
Nvda můžete rovněž spustit vepsáním "nvda" do políčka spustit z nabídky start.

Pokud chcete spustit přenosnou verzi NVDA, vejděte do adresáře, kam jste si ji rozbalili, a na souboru NVDA.exe stiskněte Enter nebo na něj klikněte myší. 

Jakmile se NVDA spustí, ozve se úvodní znělka signalizující načítání NVDA.
V závislosti na tom, jak rychlý je váš počítač, nebo médium, z kterého NVDA spouštíte, může chvíli trvat, než se program načte.
Pokud spouštění trvá příliš dlouho, NVDA by měl ohlásit "Načítám, prosím, čekejte". 

Pokud se objeví chyba ohlášená zvukem Windows, nebo ozve-li se znělka signalizující ukončení NVDA, znamená to, že NVDA má problém při spouštění. Tuto chybu, prosím, ohlaste tvůrcům programu.
Informace o tom, jak chybu ohlásit, najdete na stránkách NVDA. 

Při prvním spuštění NVDA  se objeví uvítací dialog se základními informacemi o nabídce NVDA a o použití tzv. klávesy NVDA.
Více podrobností si můžete přečíst v následující kapitole.
Dále toto okno obsahuje dvě zaškrtávací políčka.
První políčko umožní zvolit, zda chcete používat capslock jako klávesu NVDA. Jestliže toto políčko není zaškrtnuté, pak jako klávesa NVDA bude použit Insert. Druhé zaškrtávací políčko umožňuje nastavit, zda se uvítací dialog má zobrazit po každém startu NVDA. 

### Klávesové zkratky {#toc18}
#### Klávesa NVDA {#toc19}

Většina klávesových zkratek NVDA je tvořena kombinací klávesy NVDA plus jedné či několika dalších kláves.
Výjimkou jsou příkazy pro pohyb čtecím kurzorem, pro které se používají klávesy numerického bloku. 

NVDA lze nastavit, aby se jako klávesa NVDA daly použít jak numerický a alfanumerický insert tak i capslock.

Implicitně jsou oba Inserty alfanumericky i numerický nastaveny jako klávesa NVDA.

Pozor! Mějte na paměti, že dvojitý stisk kterékoli z přednastavených kláves NVDA vyvolá původní funkci dané klávesy (např. přepnutí velkých písmen v případě klávesy capslock).

#### rozložení kláves {#toc20}

NVDA nyní obsahuje dva typy rozložení kláves.
Desktop pro práci se stolním pc a laptop pro práci na přenosném počítači. 
Implicitně je NVDA nastaven na rozložení desktop, což lze přepnout v dialogu Nastavení klávesnice, který se nachází v možnostech v nabídce NVDA.

Rozložení kláves pro stolní počítače používá vesměs klávesy numerického bloku, ale musí být vypnutá klávesa numlock.
I když většina přenosných počítačů fyzicky numerický blok nemá, je téměř vždy možné klávesy numerického bloku emulovat soustiskem klávesy Fn a písmen nebo číslic v pravé části klávesnice (7 8 9 u i o j k l atd).
Jestliže toto Váš notebook nepodporuje nebo není možné vypnout klávesu Numlock, můžete použít rozložení kláves Laptop.

### Dotyková gesta NVDA {#toc21}

Pokud používáte NVDA na zařízení s dotykovou obrazovkou a máte nainstalovaný systém Windows 8 a novější, můžete NVDA ovládat přímo pomocí dotykové obrazovky.
Pokud je NVDA spuštěn, všechny dotykové vstupy jsou na něj přesměrovány.
Proto některé akce, co jsou normálně dostupné bez NVDA, nelze provést.

#### Zkoumání obrazovky {#toc22}

To nejzákladnější, co můžete provést na dotykové obrazovce, je oznámení objektu zobrazeného v jakémkoli bodě obrazovky.
Pro tuto akci položte jeden prst kamkoli na obrazovku.
Můžete také nechat prst na obrazovce a postupným posouváním si nechat přečíst prvky, přes které váš prst přechází, spolu s jejich textem.

#### Dotyková gesta {#toc23}

Když budou později v této příručce popisovány příkazy NVDA, mohou obsahovat i dotyková gesta, kterými lze příkaz aktivovat na dotykové obrazovce.
Následují instrukce, jak lze dotyková gesta provést.

##### Klepnutí {#toc24}

Poklepněte rychle na obrazovku jedním nebo více prsty.

Poklepání jednou jedním prstem se jednoduše říká klepnutí.
Poklepání dvěma prsty současně je klepnutí dvěma prsty atd.

Pokud se stejné klepnutí provede jednou nebo víckrát rychle za sebou, NVDA to rozpozná jako vícenásobné klepnutí.
Poklepáním dvakrát dojde k dvojitému klepnutí.
Poklepáním třikrát dojde k trojitému klepnutí atd.
Samozřejmě lze tato vícenásobná gesta provést i více prsty, takže jsou možná i taková gesta jako dvojité klepnutí třemi prsty, čtyřklepnutí atd.

##### Švihnutí {#toc25}

Rychlým pohybem posuňte prst po obrazovce.

Je možno provést čtyři gesta švihnutí podle směru: švihnutí vlevo, vpravo, nahoru a dolů.

Tak jako u klepnutí lze švihnutí provést více prsty.
Takže je možné provést gesta jako švihnutí nahoru dvěma prsty a švihnutí vlevo čtyřmi prsty.

#### Dotykové režimy {#toc26}

Jelikož je více příkazů NVDA než dotykových gest, NVDA má několik dotykových režimů, mezi kterými můžete přepínat a které zpřístupňují určité podmnožiny příkazů.
Jsou k dispozici dva režimy - textový a objektový.
U určitých příkazů v tomto dokumentu může být k dispozici i dotykový režim zadaný v závorkách za dotykovým gestem.
Například: švihnutí nahoru (textový režim) znamená, že příkaz lze provést jen v textovém režimu.
Jestliže u příkazu není zadaný režim, lze ho provést ve všech režimech.

<!-- KC:beginInclude -->
Mezi dotykovými režimy se přepíná trojitým klepnutím.
<!-- KC:endInclude -->

### Výukový režim {#toc27}

Většina klávesových zkratek je popsána v této příručce, nicméně pro více informací o každé z nich můžete kdykoli při práci použít výukový režim.

Výukový režim spustíte stiskem kombinace kláves NVDA+1.
Vypnete jej opět použitím kombinace kláves NVDA+1. 
V případě stisku kombinace kláves nebo dotykového gesta, které představují jakýkoli příkaz programu NVDA, budou postupně přečteny názvy jednotlivých kláves a potom NVDA oznámí, o jaký příkaz se jedná.
Ve výukovém režimu se příkazy nespustí.

### Nabídka NVDA {#toc28}

Z nabídky programu NVDA můžete upravovat nastavení, přistupovat k nápovědě, znovu načítat či ukládat konfiguraci, upravovat řečové slovníky, přistupovat k dalším nástrojům a samozřejmě NVDA ukončit. 

Pro vyvolání nabídky NVDA lze kdekoli v systému Windows použít klávesovou zkratku NVDA+N nebo na dotykové obrazovce poklepat dvakrát dvěma prsty.
Tutéž nabídku je možné vyvolat též přes ikonu NVDA na systémové liště buď pravým tlačítkem myši,  nebo přechodem na systémovou lištu stiskem tlačítka Windows+B a zde šipkou dojet na ikonu NVDA a stisknout klávesu pro kontextové menu, která bývá na většině klávesnic umístěna vedle pravého Altu.
V případě, že klávesa pro vyvolání kontextové nabídky na klávesnici chybí, lze ji nahradit kombinací kláves Shift+F10.
Po zobrazení nabídky programu NVDA můžete použít horní a dolní šipku pro pohyb po položkách. Klávesou Enter danou volbu aktivujete.

### Základní klávesové zkratky {#toc29}

<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop |Klávesová zkratka pro laptop |Dotyk |Popis|
|---|---|---|---|---|
|Zastavení řeči |Ctrl |Ctrl |Klepnutí dvěma prsty |Okamžitě zastaví řeč|
|Pozastavení řeči |Shift |Shift |Žádný |Okamžitě pozastaví řeč. Po opětovném stisku klávesy bude řeč pokračovat od místa, na němž byla pozastavena (pokud to Vámi používaný hlasový výstup podporuje).|
|Nabídka NVDA |NVDA+n |NVDA+n |Dvojité klepnutí dvěma prsty |Zobrazí nabídku, ve které najdete položky pro nastavení, nástroje, nápovědu a další funkce programu NVDA.|
|Režim řeči |NVDA+s |NVDA+s |Žádný |Přepíná režim řeči mezi mluvení, pípání a vypnuto. Při vypnuté řeči je NVDA zticha, při pípání jsou hlášení nahrazena pípnutím a režim mluvení zajišťuje normální hlasovou odezvu.|
|Výukový režim |NVDA+1 |NVDA+1 |Žádný |Tento příkaz zapíná a vypíná výukový režim. V tomto režimu NVDA oznámí název jakékoli stisknuté klávesy. V případě stisku kombinace kláves, která představuje jakýkoli příkaz programu NVDA, budou postupně přečteny názvy jednotlivých kláves a potom NVDA oznámí, o jaký příkaz se jedná.|
|Ukončení NVDA |NVDA+q |NVDA+q |Žádný |Zde jsou dvě možnosti nastavení. Buď při stisku klávesy NVDA+q zazní znělka a program je ukončen, nebo se zobrazí dotaz, zda chceme NVDA ukončit. V obecném nastavení programu NVDA lze potvrzovací dialog před ukončením zapnout nebo vypnout.|
|Propuštění následující klávesy |NVDA+F2 |NVDA+F2 |Žádný |Další stisknutá klávesa nebude interpretována programem NVDA, ale bude předána ke zpracování ve Windows.|
|Režim spánku |NVDA+Shift+s |NVDA+Shift+z |Žádný |Režim spánku deaktivuje všechny klávesové zkratky a hlasový i braillský výstup v aktuálně spuštěné aplikaci. Toto je užitečné např. v samoozvučujících aplikacích, které sami poskytují některý z těchto výstupů. Opětovným stiskem klávesové zkratky režim spánku deaktivujete.|

<!-- KC:endInclude -->

### Ohlašování systémových informací {#toc30}

<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Datum a čas |NVDA+F12 |Oznámí aktuální čas. Stiskne-li se dvakrát rychle po sobě, bude ohlášeno aktuální datum.|
|Stav baterie |NVDA+Shift+b |Oznámí informace o stavu napájení. Buď oznámí stav nabití baterie v procentech, nebo oznámí napájení zapnuto. Je-li odpojeno napájení zesítě, potom kromě stavu baterie oznámí i zbývající čas provozu.|
|Přečti text ve schránce |NVDA+c |Pokud je ve schránce windows nějaký text, NVDA jej přečte. Neobsahuje-li schránka žádný text, NVDA to oznámí.|

<!-- KC:endInclude -->

## Pohyb s NVDA {#toc31}

NVDA nabízí uživateli několik způsobů pro pohyb v systému včetně klasické interakce a prohlížení.

### Objekty {#Objects}

Každá aplikace, jakož i operační systém sám o sobě se skládá z mnoha objektů.
Objektem se v tomto případě rozumí jediná položka jako např. kousek textu, tlačítko, zaškrtávací políčko, posuvník, seznam, nebo editační pole.

### Pohyb pomocí zaměření fokusu {#SystemFocus}

Systémový fokus, též zkráceně jen fokus, je [objekt](#Objects), který reaguje na stisk kláves na klávesnici.
Například když píšete text do editačního pole, má fokus toto editační pole.

Nejjednodušším způsobem pohybu v systému Windows s NVDA je použití obvyklých klávesových příkazů pro pohyb po ovládacích prvcích jako například: Tab a Shift+Tab pro pohyb po položkách, vyvolání panelu nabídek pomocí klávesy Alt, pohyby v nabídkách prostřednictvím kurzorových šipek či přepínání se mezi spuštěnými aplikacemi klávesami Alt+Tab. Při každém takovémto pohybu vám NVDA ohlásí, kde se nachází fokus, resp aktuálně zaměřený objekt. 
Když NVDA ohlašuje zaměřený objekt, je obvykle oznámeno jeho jméno, typ, stav, hodnota, popis, klávesová zkratka či informace o pozici objektu. Toto chování se od ostatních odečítačů příliš neliší, nicméně jména objektů se mírně lišit mohou. 

Při pohybu po zaměřených objektech můžete použít několik užitečných příkazů: 
<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop |Klávesová zkratka pro laptop |Popis|
|---|---|---|---|
|Přečti fokus |NVDA+Tab |NVDA+Tab |ohlásí aktuálně zaměřený objekt, resp objekt, na kterém se nachází fokus. Stiskne-li se dvakrát rychle po sobě, informace bude vyhláskována.|
|Přečti titulek |NVDA+t |NVDA+t |Přečte titulek aktuálního aplikačního okna nebo okna v popředí. Stiskne-li se dvakrát rychle po sobě, titulek bude vyhláskován a trojitý stisk ho zkopíruje do schránky.|
|Přečti aktivní okno |NVDA+b |NVDA+b |Přečte obsah aktuálního okna v popředí. To může být užitečné např. při opětovném čtení informací v dialogových oknech.|
|Přečti stavový řádek |NVDA+End |NVDA+Shift+End |Přečte obsah stavového řádku aktuální aplikace, je-li dostupný. Tímto příkazem se ze stavového řádku stane prohlížený objekt.|

<!-- KC:endInclude -->

### Pohyb pomocí textového kurzoru {#SystemCaret}

Pokud má [fokus](#Systemfocus) [objekt](#Objects), který umožňuje pohyb po textu, nebo jeho editaci, mluvíme o pohybu pomocí textového kurzoru.

Jestliže se fokus nachází na objektu, který má textový kurzor, můžete pro pohyb po textu využít všechny běžně používané klávesy jako jsou kurzorové šipky, Page Up, Page Down, home, end, atd.
Jedná-li se o editační pole, můžete text také upravovat.
NVDA bude hlásit pohyb po znacích, slovech, řádcích, včetně označení a odoznačení textu. 

V souvislosti  s textovým kurzorem poskytuje NVDA následující klávesové zkratky:
<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop |Klávesová zkratka pro laptop |popis|
|---|---|---|---|
|Plynulé čtení |NVDA+šipka dolů |NVDA+a |V editačních polích a dokumentech přečte text od polohy textového kurzoru do konce, přičemž se textový kurzor plynule posouvá po řádcích.|
|Přečti aktuální řádek |NVDA+šipka nahoru |NVDA+l |V editačních polích a dokumentech přečte aktuální řádek pod textovým kurzorem. Stiskne-li se dvakrát rychle po sobě, řádek bude vyhláskován.|
|Přečti aktuální výběr |NVDA+Shift+šipka nahoru |NVDA+Shift+s |V editačních polích a dokumentech přečte označený text. Jestliže není označeno nic, NVDA to ohlásí.|

Při pohybu v tabulkách jsou dostupné následující klávesové příkazy:

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Předchozí sloupec |Ctrl+Alt+levá šipka |Přejde na předchozí sloupec na aktuálním řádku.|
|Následující sloupec |Ctrl+Alt+pravá šipka |Přejde na následující sloupec na aktuálním řádku.|
|Předchozí řádek |Ctrl+Alt+šipka nahoru |Přejde na předchozí řádek v aktuálním sloupci.|
|Následující řádek |Ctrl+Alt+šipka dolů |Přejde na následující řádek v aktuálním sloupci.|

<!-- KC:endInclude -->

### Objektová navigace {#ObjectNavigation}

Většinou budete pravdě+podobně pracovat s aplikacemi pomocí příkazů, které mění [fokus](#SystemFocus) nebo s takovými, co mají [textový kurzor](#SystemCaret).
Někdy však můžete potřebovat  prohlédnout si aktuálně spuštěnou aplikaci nebo položky operačního systému, ale nechcete při tom měnit pozici [fokusu](#SystemFocus).
Rovněž mohou nastat situace, kdy potřebujete pracovat s [objekty](#Objects), které nejsou běžně dostupné z klávesnice.
V těchto případech můžete využít objektovou navigaci NVDA.

Objektová navigace vám umožní pohyb  a získání informací o jednotlivých objektech.
Objekt zaměřený objektovou navigací oznámí NVDA podobně jako oznamuje systémový fokus.
Pokud si chcete jen přečíst veškerý text zobrazený na obrazovce, můžete použít rovněž režim [plošného prohlížení](#FlatReview).

Abyste nemuseli procházet všechny objekty jeden po druhém, jsou objekty hierarchicky seskupeny.
To znamená, že musíte vstoupit do některých objektů, abyste se dostali k těm položkám, jež jsou v objektu obsaženy.
Např. pokud byste při plošném uspořádání objektů narazili na seznam, vstoupíte do něj (tedy přejdete na první podřazený objekt seznamu) a pak si teprve můžete prohlédnout položky, které obsahuje
Když se dostanete k nějaké položce seznamu, přecházením na předchozí a následující objekt přejdete k dalším položkám seznamu.
Přejitím na nadřazený objekt se vrátíte zpátky na seznam.
Máte pak možnost pokračovat k objektu, který se nachází za seznamem.
Podobně, pokud narazíte na panel nástrojů, musíte vstoupit dovnitř (přejít na první podřazený objekt), abyste mohli zjistit obsah panelu nástrojů.

Objekt, který si tímto způsobem prohlížíte se nazývá prohlížený objekt.
Po zaměření objektu je možné [prohlédnout si text objektu](#ReviewingText).
Ve výchozím nastavení se prohlížený objekt mění spolu s pohybem systémového fokusu. Pokud ale chcete, aby se prohlížený objekt nepohyboval spolu s fokusem, lze  sledování systémového fokusu vypnout.

Pozor: Text na braillském řádku implicitně sleduje [systémový fokus](#SystemFocus) a [systémový kurzor](#SystemCaret).
Pokud chcete text na braillském řádku přizpůsobit objektové navigaci a čtecímu kurzoru, je potřeba nastavit [propojení braillského kurzoru](#BrailleTether).

Pro pohyb po objektech použijte následující klávesové zkratky: 

<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop |Klávesová zkratka pro laptop |Dotyk |Popis|
|---|---|---|---|---|
|aktuální prohlížený objekt |NVDA+numerická 5 |NVDA+Shift+o |Žádný |Ohlásí aktuální prohlížený objekt. Stiskne-li se dvakrát rychle po sobě, objekt bude vyhláskován a trojitý stisk ho zkopíruje do schránky.|
|Nadřazený objekt |NVDA+numerická 8 |NVDA+Shift+šipka nahoru |Švihnutí nahoru |Přejde o úroveň výš na nadřazený objekt právě prohlíženého objektu.|
|Předchozí objekt |NVDA+numerická 4 |NVDA+Shift+levá šipka |Švihnutí vlevo |Přejde na předchozí objekt od právě prohlíženého objektu.|
|Následující objekt |NVDA+numerická 6 |NVDA+Shift+pravá šipka |Švihnutí vpravo |Přejde na následující objekt od právě prohlíženého objektu.|
|Podřazený objekt |NVDA+numerická 2 |NVDA+Shift+šipka dolů |Švihnutí dolů |Přejde o úroveň níž na podřazený objekt právě prohlíženého objektu.|
|Prohlížený objekt na fokus |NVDA+numerické mínus |NVDA+Backspace |Žádný |Prohlíženým objektem se stane zaměřený objekt, neboli objekt, který má fokus a je-li zobrazen textový kurzor, pak na jeho pozici bude přemístěn i čtecí kurzor.|
|Předvolená akce |NVDA+numerický Enter |NVDA+Enter |Dvojité klepnutí |Provede výchozí akci právě prohlíženého objektu (např. je-li prohlíženým objektem tlačítko, tento příkaz simuluje stisk klávesy enter, či dvojklik)|
|Fokus nebo textový kurzor na pozici čtecího kurzoru |NVDA+Shift+numerické mínus |NVDA+Shift+Backspace |Žádný |Stiskne-li se jednou, nastaví fokus na prohlížený objekt, stiskne-li se dvakrát rychle za sebou, přesune textový kurzor na pozici čtecího kurzoru.|
|Poloha prohlíženého objektu |NVDA+numerická desetinná čárka |NVDA+Delete |Žádný |Ohlásí velikost a pozici prohlíženého objektu.|

<!-- KC:endInclude -->

Poznámka: Aby byla zajištěna správná funkčnost příkazů objektové navigace, musí být vypnuta klávesa Numlock. 

### Prohlížení textu v aktuálním objektu {#ReviewingText}

NVDA umožňuje číst obsah [právě prohlíženého objektu](#ObjectNavigation), ale i obsah [plošného prohlížení](#FlatReview) po znacích, slovech nebo po řádcích.
To může být užitečné v příkazovém řádku Windows nebo na jiných místech, kde není plně funkční nebo dostupný [textový kurzor](#SystemCaret).
Například můžete tímto prohlížet dlouhou zprávu v dialogovém okně.

Při pohybu čtecím kurzorem se textový kurzor nepohybuje, takže si můžete prohlížet text obrazovky, aniž byste ztratili pozici, na které se textový kurzor nachází.
Naopak při pohybu textovým kurzorem se čtecí kurzor automaticky přizpůsobuje pozici textového kurzoru.
Tuto vlastnost lze přepínat.

Pozor: Text na braillském řádku implicitně sleduje [systémový fokus](#SystemFocus) a [systémový kurzor](#SystemCaret).
Pokud chcete text na braillském řádku přizpůsobit objektové navigaci a čtecímu kurzoru, je potřeba nastavit [propojení braillského kurzoru](#BrailleTether).

Pro prohlížení textu můžete použít následující klávesové příkazy:
<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop |Klávesová zkratka pro laptop |Dotyk |Popis|
|---|---|---|---|---|
|Horní řádek |Shift+numerická 7 |NVDA+Ctrl+Home |Žádný |Přesune čtecí kurzor na horní řádek právě prohlíženého objektu.|
|Předchozí řádek |numerická 7 |NVDA+šipka nahoru |Švihnutí nahoru |Přesune čtecí kurzor na předchozí řádek právě prohlíženého objektu.|
|Aktuální řádek |numerická 8 |NVDA+Shift+tečka |Žádný |Přečte aktuální řádek, na němž se v rámci prohlíženého objektu nachází čtecí kurzor. Stiskne-li se dvakrát rychle po sobě, řádek bude vyhláskován a trojitý stisk ho vyhláskuje pomocí hláskovací tabulky.|
|Následující řádek |numerická 9 |NVDA+šipka dolů |Švihnutí dolů |Přesune čtecí kurzor na následující řádek právě prohlíženého objektu.|
|Spodní řádek |Shift+numerická 9 |NVDA+Ctrl+End |Žádný |Přesune čtecí kurzor na spodní řádek právě prohlíženého objektu.|
|Předchozí slovo |numerická 4 |NVDA+Ctrl+levá šipka |Švihnutí dvěma prsty vlevo |Přesune čtecí kurzor na předchozí slovo právě prohlíženého objektu.|
|Aktuální slovo |numerická 5 |NVDA+Ctrl+ tečka |Žádný |Přečte aktuální slovo, na němž se v rámci prohlíženého objektu nachází čtecí kurzor. Stiskne-li se dvakrát rychle po sobě, slovo bude vyhláskováno a trojitý stisk ho vyhláskuje pomocí hláskovací tabulky.|
|Následující slovo |numerická 6 |NVDA+Ctrl+pravá šipka |Švihnutí dvěma prsty vpravo |Přesune čtecí kurzor na následující slovo právě prohlíženého objektu.|
|Začátek řádku |Shift+numerická 1 |NVDA+Home |Žádný |Přesune čtecí kurzor na začátek aktuálního řádku v rámci prohlíženého objektu.|
|Předchozí znak |numerická 1 |NVDA+levá šipka |Švihnutí vlevo |Přesune čtecí kurzor na předchozí znak právě prohlíženého objektu.|
|Aktuální znak |numerická 2 |NVDA+tečka |Žádný |Přečte aktuální znak, na němž se v rámci prohlíženého objektu nachází čtecí kurzor. Stiskne-li se dvakrát za sebou, bude znak ohlášen pomocí hláskovací tabulky a trojitý stisk ohlásí jeho ascii a hexadecimální hodnotu.|
|Následující znak |numerická 3 |NVDA+pravá šipka |Švihnutí vpravo |Přesune čtecí kurzor na následující znak právě prohlíženého objektu.|
|Konec řádku |Shift+numerická 3 |NVDA+End |Žádný |Přesune čtecí kurzor na konec aktuálního řádku v rámci prohlíženého objektu.|
|Plynulé čtení čtecím kurzorem |numerické plus |NVDA+Shift+a |Švihnutí třemi prsty dolů |Přečte text od pozice čtecího kurzoru do konce, přičemž se čtecí kurzor plynule posouvá po řádcích.|
|nastav značku na pozici čtecího kurzoru |NVDA+F9 |NVDA+F9 |Žádný |Umístí značku na aktuální pozici čtecího kurzoru označující začátek úseku textu ke zkopírování.|
|Kopírování čtecím kurzorem |NVDA+F10 |NVDA+F10 |Žádný |Převezme text nacházející se mezi dříve umístěnou značkou a aktuální pozicí čtecího kurzoru včetně znaku na aktuální pozici a takto získaný úsek textu zkopíruje do schránky.|
|přečti formátování textu |NVDA+f |NVDA+f |Žádný |Ohlásí formátování textu na pozici čtecího kurzoru.|

<!-- KC:endInclude -->

Poznámka: Aby byla zajištěna správná funkčnost těchto příkazů, musí být vypnuta klávesa Numlock. 

Aby bylo možné si  příkazy lépe zapamatovat, všimněte si, že základní příkazy pro prohlížení textu jsou uspořádány do pomyslné tabulky tři krát tři, kde směrem zhora dolů jsou umístěny řádek, slovo a znak a směrem zleva doprava jsou umístěny předchozí, aktuální a následující.
Pro ilustraci tohoto rozložení je zde následující tabulka:

|předchozí řádek |aktuální řádek |následující řádek|
|předchozí slovo |aktuální slovo |následující slovo|
|předchozí znak |aktuální znak |následující znak|

### Plošné prohlížení {#FlatReview}

Obecně se dá říct, že je možné prohlížet obsah jen jednoho [objektu](#Objects).
Výjinku tvoří objekty, které obsahují vnořené objekty. V těchto případech máte možnost si prohlédnout i obsah těchto vnořených objektů.
V plošném prohlížení si můžete prohlédnout obsah celého dokumentu nebo okna aplikace tak, jak je rozmístěn po obrazovce.
Je to velmi podobné jako funkce na prohlížení obrazovky nebo funkce určené pro pohyb kurzoru myši, které používají jiné odečítače obrazovky.

Když se přepnete do režimu plošného prohlížení, nacházíte se na pozici [právě prohlíženého objektu](#ObjectNavigation).
Pokud jste před přepnutím do plošného prohlížení objektovou navigaci nepoužili, budete se pravděpodobně nacházet na prvku, který má [fokus](#SystemFocus).
Takže pokud bylo např. zaměřeno tlačítko, čtecí kurzor plošného prohlížení se bude nacházet na textu tlačítka.
Okolní Text pak můžete prohlížet pomocí [příkazů určených na prohlížení textu](#ReviewingText).
Rovněž je možné kdekoli v režimu plošného prohlížení přejít do objektové navigace. Objekt, jehož text jste si prohlíželi, se po přepnutí do objektové navigace stane právě prohlíženým objektem.

Pozor: Text na braillském řádku implicitně sleduje [systémový fokus](#SystemFocus) a [systémový kurzor](#SystemCaret).
Pokud chcete text na braillském řádku přizpůsobit objektové navigaci a čtecímu kurzoru, je potřeba nastavit [propojení braillského kurzoru](#BrailleTether).

Následující dva příkazy zapínají a vypínají režim plošného prohlížení: 
<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop |Klávesovázkratka pro laptop |Dotyk |Popis|
|---|---|---|---|---|
|Přepnout do plošného prohlížení |NVDA+numerická 7 |NVDA+PageUp |Švihnutí dvěma prsty nahoru |Přepne se do plošného prohlížení na pozici, kde se nachází právě prohlížený objekt. Takto můžete začít prohlížet obsah obrazovky či dokumentu (jste-li zrovna uvnitř nějakého) pomocí příkazů pro prohlížení textu.|
|Přepnout na objektovou navigaci |NVDA+numerická 1 |NVDA+PageDown |Švihnutí dvěma prsty dolů |Zapne objektovou navigaci na pozici čtecího kurzoru v režimu plošného prohlížení. Je vyhledán objekt, jehož text právě čtete v režimu plošného prohlížení a čtecí kurzor je umístěn do tohoto objektu, aby bylo možno daný objekt prohlížet a pohybovat se po dalších objektech.|

<!-- KC:endInclude -->

### Navigace pomocí myši {#toc38}

NVDA je standardně nastaven tak, aby při pohybu myší ohlašoval objekty, na kterých se právě nachází ukazatel myši.
V některých případech přečte NVDA celý odstavec, v jiných situacích jen aktuální řádek textu.

NVDA je možné nastavit tak, že kromě textu bude ohlašovat i typ prvku, na kterém se nachází kurzor myši jako např. tlačítko, seznam, atd.
To může být užitečné pro zcela nevidomé uživatele, protože někdy jenom text nestačí.

NVDA uživateli nabízí i možnost akustické signalizace polohy myši na základě vzdálenosti od okrajů obrazovky.
Čím výše se myš na obrazovce nachází, tím vyšší je pípání.
Pro pravou a levou stranu se pípání přesouvá z jednoho kanálu do druhého. Předpokládá se, že uživatel má stereo reproduktory.

Tyto funkce NVDA nejsou standardně zapnuty.
V dialogu [nastavení myši](#MouseSettings) se dají dodatečně aktivovat. 

Ačkoli se pro tenhle způsob navigace běžně používá trackpad nebo myš, NVDA poskytuje několik klávesových příkazů, které simulují některé její funkce.
<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop |Klávesová zkratka pro laptop |Popis|
|---|---|---|---|
|Levý klik |numerické lomeno |NVDA+[ |Klikne levým tlačítkem myši. Dvojkliku lze docílit dvojitým stiskem této klávesové zkratky.|
|Uzamknout levé tlačítko myši |Shift+numerické lomeno |NVDA+Ctrl+[ |Stiskne a uzamkne nebo opětovným stiskem uvolní levé tlačítko myši. Objekt přetáhnete tak, že stiskem této kombinace uzamknete (stisknete a podržíte) levé tlačítko myši, pak buď pohnete přímo myší, nebo použijete příkaz pro přesun ukazatele myši.|
|Pravý klik |numerická hvězdička |NVDA+] |Klikne pravým tlačítkem myši.|
|Uzamknout pravé tlačítko myši |Shift+numerická hvězdička |NVDA+Ctrl+] |Stiskne a uzamkne nebo opětovným stiskem uvolní pravé tlačítko myši. Objekt přetáhnete tak, že stiskem této kombinace uzamknete (stisknete a podržíte) pravé tlačítko myši, pak buď pohnete přímo myší, nebo použijete příkaz pro přesun ukazatele myši.|
|Myš na prohlížený objekt |NVDA+numerické lomeno |NVDA+Shift+m |Přesune kurzor myši na prohlížený objekt na pozici čtecího kurzoru.|
|Prohlížený objekt na myš |NVDA+numerická hvězdička |NVDA+Shift+n |Prohlíženým objektem se stane objekt pod kurzorem myši.|

<!-- KC:endInclude -->

## Režim prohlížení {#toc39}

Souhrnnější dokumenty jako jsou např. vebové stránky zobrazuje NVDA v TZV. režimu prohlížení. 
-Toto se týká dokumentů v programech Mozilla Firefox, Microsoft Internet Explorer, Google Chrome, Adobe Reader a Adobe Flash.

V režimu prohlížení je obsah dokumentu uspořádán v plošném zobrazení, takže pro pohyb po dokumentu můžete použít stejné příkazy jako při práci s běžnými textovými dokumenty.
V tomto režimu jsou funkční všechny standardní klávesové zkratky na čtení textu pomocí [textového kurzoru](#SystemCaret) jako např. plynulé čtení, informace o formátování a příkazy pro pohyb v tabulkách.
Při  čtení dokumentu jsou ohlašovány veškeré prvky jako např. odkazy, nadpisy, atd. 

V některých situacích je zapotřebí přímá interakce s prvky v dokumentu.
K tomuto účelu slouží formulářový režim, po jehož aktivaci jsou veškeré klávesové příkazy propuštěny přímo k prvku, který má fokus.
v tomto režimu tedy můžete např. upravovat obsah editačních polí, což v režimu prohlížení není možné z toho důvodu, že některé klávesy, které běžně vkládají znaky, jsou použity pro pohyb po různých prvcích dokumentu (viz následující kapitola). 
Jestliže v  režimu prohlížení kliknutím nebo stiskem klávesy Tab přejdete na jakýkoli formulářový prvek, NVDA automaticky aktivuje formulářový režim.
Naopak jestliže ve formulářovém režimu kliknutím nebo stiskem klávesy Tab přejdete na prvek, který formulářový režim nevyžaduje, NVDA se automaticky přepne do režimu prohlížení. 
Pro přepnutí z režimu prohlížení do formulářového režimu můžete rovněž  na konkrétním prvku použít klávesu Mezerník nebo enter.
Stiskem klávesy Esc se vrátíte do režimu prohlížení.
Kromě toho si Přechod do formulářového režimu můžete také vynutit stiskem kombinace kláves NVDA+Mezerník, a v tomto případě zůstane formulářový režim zapnutý do té doby, než ho opětovným stiskem kláves NVDA+Mezerník nepřepnete do režimu prohlížení.

<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Přepínání formulářového režimu a režimu prohlížení |NVDA+Mezerník |Přepíná mezi formulářovým režimem a režimem prohlížení|
|Ukončení formulářového režimu |Escape |Přepíná do režimu prohlížení, jestliže byl předtím formulářový režim automaticky aktivován|
|Obnovit obsah dokumentu v režimu prohlížení |NVDA+F5 |Obnoví obsah aktuálního dokumentu (užitečné, jestliže např. část dokumentu nebyla správně načtena)|
|Hledat |NVDA+Ctrl+F |Zobrazí dialog, ve kterém můžete zadat text pro vyhledávání v aktuálním dokumentu|
|Najít další |NVDA+F3 |Najde další výskyt textu, který byl předtím zadán při vyvolání dialogu hledat|
|Najít předchozí |NVDA+Shift+F3 |Najde předchozí výskyt textu, který byl předtím zadán při vyvolání dialogu hledat|
|dlouhý popis |NVDA+d |Otevře nové okno s dlouhým popisem pro prohlížený prvek, je-li k dispozici.|

<!-- KC:endInclude -->

### Příkazy rychlé navigace {#toc40}

V  režimu prohlížení NVDA podporuje jednoznakové příkazy pro rychlejší pohyb po prvcích obsažených v aktuálním dokumentu. 

<!-- KC:beginInclude -->
Pomocí následujících příkazů se můžete posunovat na následující prvek v dokumentu, v opačném směru se můžete pohybovat kombinací příkazů s klávesou Shift. 

* H: Nadpis
* L: Seznam
* I: Položka seznamu
* T: Tabulka
* K: Odkaz
* N: Text, jenž není odkaz
* F: Prvek formuláře
* U: Nenavštívený odkaz
* V: Navštívený odkaz
* E: Editační pole
* B: Tlačítko
* X: Zaškrtávací políčko
* C: Rozbalovací políčko
* R: Přepínač
* Q: Citace
* S: Oddělovač
* M: Rámec
* G: Grafika
* D: Oblast
* O: Vnořený objekt
* Klávesy + až ž, čili 1 až 6: Nadpis v příslušné úrovni.

Pro pohyb na začátek či konec seznamu více prvků, např. seznamu nebo tabulky:

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Začátek seznamu prvků |shift+čárka |Přesune se na začátek seznamu prvků (seznam, tabulka atd.) kde je umístěn čtecí kurzor|
|Konec seznamu prvků |čárka |Přesune se za seznam prvků (seznam, tabulka atd.) kde je umístěn čtecí kurzor|

<!-- KC:endInclude -->

### Seznam prvků {#toc41}

Dialog seznam prvků zobrazuje seznam odkazů, nadpisů či oblastí, které jsou k dispozici v aktuálním dokumentu.
Nadpisy a oblasti jsou zobrazeny ve stromovém seznamu. Je zde přepínač, pomocí něhož můžete vybírat typ prvků, které mají být zobrazeny. Standardně se po vyvolání tohoto dialogu zobrazí v seznamu odkazy.
Dialog obsahuje i editační pole, díky kterému je možné filtrovat aktuálně zobrazený seznam prvků. To může usnadnit hledání konkrétní položky v seznamu, resp. v aktuálním zobrazeném dokumentu. Jestliže je editační pole prázdné, v seznamu budou zobrazeny veškeré  zvolené prvky, které se vyskytují v aktuálním dokumentu. Pokud do políčka napíšete jeden či více znaků, v seznamu budou zobrazeny jen ty prvky, které obsahují vámi definovaný řetězec. V samotném seznamu je samozřejmě možné se pohybovat kurzorovými šipkami a nebo zadat první písmeno hledané položky a NVDA umístí kurzor na její první výskyt v seznamu.
Na konkrétní vyhledanou položku můžete přemístit kurzor nebo ji aktivovat použitím příslušných tlačítek v dialogu. 
<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Seznam prvků dokumentu |NVDA+F7 |Zobrazí dialog se seznamem všech odkazů, nadpisů, či oblastí nacházejících se v aktuálním dokumentu|

<!-- KC:endInclude -->

### Vnořené objekty {#toc42}

Moderní webové stránky mohou obsahovat prvky Adobe Flash nebo Sun Java, aplikace a dialogy.
Pokud se v dokumentu takový prvek objeví, NVDA ohlásí vnořený objekt, aplikaci nebo dialog.
Jestliže na tomto objektu stisknete klávesu enter, přemístíte do něj fokus.
Je-li objekt přístupný, můžete se v něm pohybovat klávesami tab či shift+tab.
Je samozřejmě možné použít klávesovou zkratku pro přepnutí zpět do původního dokumentu, který vnořený objekt obsahuje. 
<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Přejít do nadřazeného dokumentu |NVDA+Ctrl+Mezerník |Přemístí fokus z aktuálního vnořeného objektu do nadřazeného dokumentu, který tento objekt obsahuje|

<!-- KC:endInclude -->

## Příkazy NVDA specifické pro aplikace {#toc43}

Pro některé aplikace má NVDA k dispozici speciální příkazy pro usnadnění určitých úkolů nebo pokud nejsou funkce dostatečně dostupné pro uživatele odečítačů obrazovky.

### Microsoft Excel {#toc44}

<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Nastavení záhlaví sloupců |NVDA+shift+c |Jedním stisknutím informuje NVDA, že toto je řádek, který obsahuje záhlaví sloupců, která se mají oznamovat automaticky při pohybu mezi sloupci pod tímto řádkem. Dvojitým stiskem se nastavení zruší.|
|Nastavení záhlaví řádků |NVDA+shift+r |Jedním stisknutím informuje NVDA, že toto je sloupec, který obsahuje záhlaví řádků, která se mají oznamovat automaticky při pohybu mezi řádky za tímto sloupcem. Dvojitým stiskem se nastavení zruší.|

<!-- KC:endInclude -->

### foobar2000 {#toc45}

<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Zbývající čas |ctrl+shift+r |Oznámí zbývající čas stopy, která se právě přehrává.|

<!-- KC:endInclude -->

Poznámka: Klávesová zkratka pro oznámení zbývajícího času funguje jen, když je ve foobaru nastaveno výchozí zobrazení stavového řádku.

### Miranda IM {#toc46}

<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Poslední zpráva |NVDA+ctrl+1-4 |Přečte jednu z posledních zpráv podle toho, které číslo stisknete; např. NVDA+control+2 přečte předposlední zprávu.|

<!-- KC:endInclude -->

### Poedit {#toc47}

<!-- KC:beginInclude -->

| Název |Klávesová zkratka |Popis|
|---|---|---|
|Okno komentářů |ctrl+shift+c |Přečte komentáře v okně komentářů.|
|Okno automatických komentářů |ctrl+shift+a |Přečte komentáře v okně automatických komentářů.|

<!-- KC:endInclude -->

## Nastavení NVDA {#toc48}
### Nabídka možnosti {#toc49}

<!-- KC:settingsSection: || Název | Klávesová zkratka pro desktop | Klávesová zkratka pro laptop | Popis | -->
Většinu nastavení NVDA je možné měnit přímo v dialogových oknech dostupných z podnabídky Možnosti v nabídce NVDA.
Pro potvrzení změn můžete ve všech dialozích použít tlačítko OK.
Pro zrušení právě vykonaných změn můžete použít tlačítko Zrušit či klávesu Escape.
Některá nastavení lze měnit i pomocí klávesových příkazů, které jsou popsány níže v textu této příručky v kapitolách pro jednotlivá nastavení.

#### Obecné nastavení (NVDA+Ctrl+G) {#toc50}

Tento dialog najdete v nabídce možnosti. 
Obsahuje tyto funkce: 

##### Jazyk {#toc51}

Jedná se o seznam umožňující výběr jazyku rozhraní a zpráv programu. Jsou zde obsaženy veškeré jazyky, do kterých byl doposud program NVDA přeložen. Implicitně je NVDA přednastaven tak, aby si zvolil jazyk podle nastavení vašeho operačního systému. K tomu slouží poslední položka v seznamu jazyků nazvaná Windows.

Při změně jazyka si NVDA vyžádá restart programu. Po potvrzení se NVDA ukončí a spustí se ve vámi zvoleném jazyce. 

##### Uložit nastavení při ukončení {#toc52}

Zaškrtnete-li tuto volbu, NVDA vždy při ukončení automaticky uloží aktuální nastavení. 

##### Upozornit před ukončením NVDA {#toc53}

Je-li tato volba zaškrtnuta, NVDA se vás před každým ukončením programu zeptá, zda jej chcete opravdu ukončit. 

##### Úroveň logování {#toc54}

Rozbalovací seznam, který uživateli umožňuje zvolit, jaké množství informací má NVDA zaznamenat v době, kdy je spuštěn. Jedná se  o informace obsahující např. případná chybová hlášení NVDA, informace o korektním běhu programu atd. Většinou se uživatel tímto nastavením nemusí zabývat, nicméně chcete-li např. poskytnout informace vývojářům programu o chybových hlášeních, je nastavení této volby na vyšší úroveň jednoznačně lepší. 

##### Automaticky spustit NVDA po přihlášení do systému {#toc55}

Pokud je tato volba zaškrtnutá, NVDA se automaticky spustí, jakmile se přihlásíte do Windows. Pozor! Tato volba je dostupná jen v instalační verzi nvda a nemůže být tudíž použita při spuštěné přenosné verzi NVDA.

##### Spouštět NVDA při zobrazení přihlašovací obrazovky (vyžaduje administrátorská oprávnění) {#toc56}

Jestliže se do Windows přihlašujete zadáním vašeho uživatelského jména a hesla, zaškrtnutím této volby zajistíte, aby se NVDA spustil již při zobrazení přihlašovací obrazovky do systému. Pozor! Tato volba je dostupná jen v instalační verzi nvda a nemůže být tudíž použita při spuštěné přenosné verzi NVDA.

##### Použít aktuální nastavení NVDA pro přihlašovací a další zabezpečené obrazovky (vyžaduje administrátorská oprávnění) {#toc57}

Po stisku tohoto tlačítka NVDA zkopíruje aktuální konfiguraci do systémové složky, aby mohla být použita v případě, že je NVDA spuštěn na přihlašovací nebo na jiných zabezpečených obrazovkách systému.
Chcete-li se ujistit, že budou správně překopírována veškerá nastavení, můžete uložit aktuální nastavení stiskem kombinace kláves NVDA+Ctrl+C nebo můžete použít volbu Uložit nastavení z nabídky NVDA. Pozor! Tato volba je dostupná jen v instalační verzi nvda a nemůže být tudíž použita při spuštěné přenosné verzi NVDA.

#### Výběr hlasového výstupu (NVDA+Ctrl+S) {#toc58}

Položku hlasové výstupy najdete v nabídce Možnosti. Po aktivování je možné vybrat, který hlasový výstup bude NVDA používat. 

Dialogové okno obsahuje jednoduchý seznam, ve kterém se nachází dostupné hlasové výstupy. Vyberte si šipkami výstup a stiskněte tlačítko Ok. Pokud se při spuštění hlasového výstupu vyskytne chyba, program vás upozorní a zůstane zachováno původní nastavení. 

##### Hlasové výstupy {#toc59}

V tomto rozbalovacím seznamu můžete nastavit hlasový výstup, který bude NVDA používat pro syntézu řeči.

Seznam podporovaných hlasových výstupů naleznete v kapitole [Podporované hlasové výstupy](#SupportedSpeechSynths).

Mezi hlasovými výstupy najdete i položku bez mluvení, která umožňuje používat NVDA úplně bez hlasového výstupu.
To může být užitečné v případě, že chcete používat NVDA jen z braillským řádkem nebo se to může hodit vidícím vývojářům, kteří chtějí používat zobrazovač řeči.

##### Výstupní zařízení {#toc60}

zde si můžete vybrat zvukovou kartu, kterou bude NVDA používat jak pro přehrávání zvuků, tak pro hlasový výstup.

#### Nastavení hlasu (NVDA+Ctrl+V) {#VoiceSettings}

Dialog s nastaveními hlasu najdete v nabídce Možnosti. Obsahuje volby, které vám umožní nastavit jednotlivé parametry hlasu. 
Pro rychlejší alternativu, která umožňuje měnit parametry hlasu odkudkoli ze systému, si prosím přečtěte kapitolu [Kruh nastavení hlasového výstupu](#SynthSettingsRing).

Toto dialogové okno obsahuje následující prvky: 

##### Hlas {#toc62}

V tomto seznamu najdete všechny nainstalované hlasy kompatibilní se zvoleným hlasovým výstupem. Pomocí šipek můžete tento seznam prohlížet a poslechnout si všechny hlasy. Je-li zvoleným hlasovým výstupem espeak, pak v tomto seznamu najdete všechny eSpeakem podporované jazyky. Chcete-li např. pracovat s jiným než českým textem, přepnete si eSpeak na vámi požadovaný jazyk a eSpeak bude vše interpretovat dle výslovnostních zákonitostí daného jazyka. 

##### Osoba {#toc63}

Tato položka je přístupná jen v případě, že používáte hlasový výstup eSpeak. Espeak obsahuje mnoho rozličných typů hlasu. Jsou zde zastoupeny jak mužské, tak ženské hlasy a každý z nich má jiné hlasové vlastnosti jako např. výšku, barvu, tempo, intonaci atd. V tomto rozbalovacím políčku si tedy můžete kurzorovými šipkami vybrat ze všech aktuálně nabízených variant hlasového výstupu eSpeak. 

##### Tempo {#toc64}

Posuvník s rozsahem nula až sto, kterým nastavíte rychlost řeči. Nula je nejpomalejší rychlost řeči a sto nejrychlejší. 

##### Znásobit tempo {#toc65}

Tato položka je přístupná jen v případě, že používáte hlasový výstup eSpeak. 
Je-li tato položka zaškrtnutá, tempo řeči eSpeaku se ztrojnásobí.

##### Výška {#toc66}

Posuvník s rozsahem nula až sto, kterým nastavíte výšku hlasu. Nula je nejhlubší a sto nejvyšší hlas. Pozor! Některé hlasy změnu výšky nepodporují. Z českých hlasů se jedná např. o Elišku či Zuzanu. 

##### Intonace {#toc67}

Posuvník s rozsahem nula až sto, kterým nastavíte intonaci hlasu. Tato možnost je dostupná pouze s hlasovým výstupem eSpeak. 

##### Hlasitost {#toc68}

Posuvník s rozsahem nula až sto, kterým nastavíte hlasitost řeči. Nula je nejnižší a sto nejvyšší hlasitost. 

<!-- KC:setting -->

##### Úroveň interpunkce {#toc69}

Klávesová zkratka: NVDA+P

Tato volba umožňuje zvolit si úroveň vyslovování interpunkčních a dalších speciálních znaků.
Tak např. nastavíte-li úroveň interpunkce na všechna, budou čtena veškerá interpunkční znaménka.

Tato volba se vztahuje na všechny hlasové výstupy, nikoli jen na aktuálně spuštěný hlasový výstup.

##### Zvýšit hlas při čtení velkých písmen {#toc70}

Zaškrtnutím této volby zajistíte, aby NVDA u každého velkého písmene při psaní či při pohybu po znacích stoupl v intonaci. Jedná se o alternativu v kontrastu se standardním ohlašováním velkých písmen např. velké A, velké B, velké C apod. viz následující. 

##### Ohlásit velké písmeno slovem "velké" {#toc71}

Chcete-li nechat ohlásit velké písmeno slovem Velké, jenž bude předcházet vlastní písmeno, zaškrtněte toto políčko. Toto chování se uplatní při pohybu po znacích nebo při psaní. NVDA obvykle při velkém písmenu poněkud zvedne výšku hlasu, ale některé hlasové výstupy nemusejí na tento povel reagovat a pak může být tato možnost užitečná. 

##### Pípat před hláskováním velkých písmen {#toc72}

Je-li tato volba zaškrtnuta, NVDA před každým velkým písmenem v textu či při psaní krátce pípne. Tak jako možnost ohlašování velkého písmena slovem velké je tato volba důležitá u hlasových výstupů, které mají potíže se změnou výšky intonace u velkých písmen. 

##### Hláskování řídí hlasový výstup je-li podporováno {#VoiceSpellingFunctionality}

Některá slova se skládají jen z jednoho písmena, ale výslovnost tohoto písmena závisí na tom, kdy se takové písmeno použije. např. při vyslovování jednoho písmena se obvykle písmeno hláskuje zatímco  při čtení slova se jen přečte.
V češtině je příkladem tohoto znaku písmeno z.
Tato volba umožňuje na základě použitého hlasového výstupu rozlišovat tyto dva způsoby, pokud to hlasový výstup podporuje.
Většina hlasových výstupů tuto možnost podporuje.

Doporučuje se nechat tuto volbu zapnutou.
Bohužel některé hlasové výstupy Microsoft Speech API toto nastavení nepodporují správně a mohou se chovat poněkud zvláštně, je-li tato volba zaškrtnuta.
Pokud pozorujete problémy s vyslovováním jednotlivých písmen, zkuste tuto voľbu odškrtnout.

#### Kruh nastavení hlasového výstupu {#SynthSettingsRing}

Jestliže chcete změnit některé parametry hlasu, aniž byste museli vyvolávat dialog pro nastavení hlasu, můžete použít některé z klávesových zkratek dostupných kdekoli v systému při běhu NVDA.
<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop + Klávesová zkratka pro laptop |Popis|
|---|---|---|
|následující hlasový parametr |NVDA+Ctrl+šipka vpravo |NVDA+Shift+Ctrl+šipka vpravo |Přesune se na následující parametr v kruhu nastavení hlasového výstupu a oznámí jej. Z posledního parametru se NVDA automaticky přesune na první hlasový parametr.|
|předchozí hlasový parametr |NVDA+Ctrl+šipka vlevo |NVDA+Shift+Ctrl+šipka vlevo |Přesune se na předchozí parametr v kruhu nastavení hlasového výstupu a oznámí jej. Z prvního parametru se NVDA automaticky přesune na poslední hlasový parametr.|
|Zvýšit hodnotu hlasového parametru |NVDA+Ctrl+šipka nahoru |NVDA+Shift+Ctrl+šipka nahoru |Zvyšuje hodnotu aktuálně zvoleného parametru v kruhu nastavení hlasového výstupu. např. zrychlí tempo, vybere následující hlas, zesílí hlasitost|
|Snížit hodnotu hlasového parametru |NVDA+Ctrl+šipka dolů |NVDA+Shift+Ctrl+šipka dolů |snižuje hodnotu aktuálně zvoleného parametru v kruhu nastavení hlasového výstupu. např. zpomalí tempo, vybere předchozí hlas, zeslabí hlasitost|

<!-- KC:endInclude -->

#### Braillské nastavení {#toc75}

Dialog s braillskými nastaveními je dostupný z nabídky Možnosti. 

Najdete zde následující prvky: 

##### Braillský řádek {#toc76}

V tomto seznamu  budou vždy zobrazeny braillské řádky podle toho, jaké ovladače braillských zařízení jsou nainstalovány ve vašem systému.
Mezi jednotlivými typy braillských řádků se můžete pohybovat použitím kurzorových kláves. 

Žádný řádek znamená, že nepoužíváte žádný braillský řádek. 

Pro více informací o podporovaných typech braillských řádků si, prosím, přečtěte kapitolu [Podporované Braillské Řádky](#SupportedBrailleDisplays).

##### Překladová tabulka {#toc77}

Další volbou je překladová tabulka. Najdete zde tabulky pro různé jazyky. Tu správnou si vyberete listováním kurzorovými šipkami. 

##### Slovo, na kterém je kurzor, zobrazit počítačovým braillem {#toc78}

Toto zaškrtávací políčko umožní zobrazovat aktuální slovo pod kurzorem v počítačovém braillově písmu, což v mnohých jazycích odpovídá plnopisu. Je to užitečné, pokud nechceme aplikovat pravidla zkratkopisu tabulky vybrané v poli Překladová tabulka. 

##### Rychlost blikání kurzoru v milisekundách {#toc79}

Jedná se o číselnou hodnotu, která určuje frekvenci blikání kurzoru braillského řádku v milisekundách. 

##### Čas pro zobrazení systémových zpráv (v sekundách) {#toc80}

Tato numerická hodnota určuje, jak dlouho mají být na řádku zobrazované systémové zprávy. 

<!-- KC:setting -->

##### Propojit braillský kurzor s {#toc81}

Klávesová zkratka: NVDA+Ctrl+T

Zde je možné nastavit, zda se má zobrazování na braillském řádku řídit systémovým fokusem či čtecím kurzorem.

Systémový fokusreprezentuje navigaci v operačním systému, zatímco čtecí kurzor umožňuje prohlížet text objektu zaměřeného objektovou navigací.

#### Nastavení klávesnice (NVDA+Ctrl+K) {#toc82}

Toto dialogové okno naleznete pod stejnojmennou položkou v nabídce Možnosti. 

Obsahuje následující volby: 

##### Rozložení klávesnice {#toc83}

Tento rozbalovací seznam nám umožňuje vybrat typ klávesnice, kterou chceme používat, tedy desktop/stolní PC, nebo laptop/přenosné PC/notebooky. 

##### Použít Caps Lock jako NVDA klávesu {#toc84}

Pokud je toto políčko zaškrtnuté, můžete Caps Lock použít jako NVDA klávesu. 

##### Použít numerický Insert jako NVDA klávesu {#toc85}

Pokud je toto políčko zaškrtnuté, můžete numerický Insert použít jako NVDA klávesu. 

##### Použít Insert jako NVDA klávesu {#toc86}

Pokud je toto políčko zaškrtnuté, můžete klávesu Insert použít jako NVDA klávesu. 

<!-- KC:setting -->

##### Hlásit psané znaky {#toc87}

Klávesová zkratka: NVDA+2

Zapíná a vypíná ohlašování všech psaných znaků.

<!-- KC:setting -->

##### Hlásit psaná slova {#toc88}

Klávesová zkratka: NVDA+3

Zapíná a vypíná ohlašování všech psaných slov.

##### Pípat při psaní malých písmen, je-li zapnutý caps lock {#toc89}

Pokud je toto políčko zaškrtnuté, tak při psaní se zapnutým caps lockem uslyšíte krátké pípnutí, jestliže je přidržená i klávesa shift. Běžně se psaní se shiftem se zapnutým caps lockem nepoužívá a ve většině případů to znamená, že jste si neuvědomili, že je klávesa caps lock zapnutá, a proto může být vhodné, když vás NVDA na tuto skutečnost upozorní.

<!-- KC:setting -->

##### Hlásit příkazové klávesy {#toc90}

Klávesová zkratka: NVDA+4

Zapíná a vypíná ohlašování všech kláves, jež nevkládají znaky. Týká se to i všech vámi stisknutých kombinací kláves jako např. Ctrl+C, Ctrl+V, Alt+Tab, atd. 

#### Nastavení myši (NVDA+Ctrl+M) {#toc91}

Toto dialogové okno naleznete pod stejnojmennou položkou v nabídce Možnosti.

Dialog obsahuje následující prvky: 

##### Hlásit změny tvaru kurzoru myši {#toc92}

Zaškrtnutí tohoto políčka zajistí, že NVDA bude oznamovat tvar kurzoru myši vždy, když se změní. Změnou tvaru myši informuje systém mimo jiné o tom, že text je upravitelný, že se něco načítá atd. 

<!-- KC:setting -->

##### Oznamovat text pod kurzorem myši {#toc93}

|Klávesová zkratka pro desktop |NVDA+M|
|Klávesová zkratka pro laptop |NVDA+M|

Je-li tato volba zapnutá, NVDA bude oznamovat text, který se aktuálně nachází pod kurzorem myši. Takto můžete najít položky na obrazovce za pomoci myši a nemusíte použít objektovou navigaci. 

##### Jednotka ohlašování u zaměřeného textu {#toc94}

Pokud je zaškrtnutá volba Oznamovat text pod kurzorem myši, toto nastavení určuje, jaké množství textu bude přečteno. Lze vybrat buď: znak, slovo, řádek nebo odstavec. 

##### Hlásit typ prvku, na který ukazuje kurzor myši {#toc95}

Je-li tato volba zaškrtnutá, NVDA bude ohlašovat typ objektu při přechodu myší přes něj. 

##### Pohyb myši indikovat zvukovým signálem {#toc96}

Při zaškrtnutí této volby bude NVDA signalizovat pohyb myši krátkým pípáním. Uživatel tedy bude mít celkové povědomí o aktuální pozici myši. 

##### Úroveň jasu ovlivňuje hlasitost zvukové signalizace {#toc97}

Pokud máte zaškrtnuté políčko pohyb myši indikovat zvukovým signálem, potom po zaškrtnutí tohoto políčka bude hlasitost signalizace řízena úrovní jasu na místě obrazovky, kde se právě nachází ukazatel myši. To může negativně ovlivnit výkonnost v systému Windows Vista, proto je tato volba implicitně vypnutá.

#### Nastavení čtecího kurzoru {#toc98}

Položku čtecí kurzor najdete v nabídce Možnosti.

Toto dialogové okno obsahuje následující prvky: 

<!-- KC:setting -->

##### Sledovat systémový fokus {#toc99}

|Klávesová zkratka pro desktop |NVDA+7|
|Klávesová zkratka pro laptop |NVDA+7|

Jestliže je tato volba zapnutá, čtecí kurzor se bude pohybovat spolu se systémovým fokusem, takže bude vždy umístěn na stejném objektu, na kterém se fokus nachází.

<!-- KC:setting -->

##### Sledovat textový kurzor {#toc100}

Klávesová zkratka: NVDA+6

Jestliže je tato volba zapnutá, bude se čtecí kurzor pohybovat automaticky spolu s textovým kurzorem, takže bude vždy na stejné pozici, na které se textový kurzor nachází.

##### Sledovat kurzor myši {#toc101}

Je-li tato volba zapnutá, čtecí kurzor bude sledovat pohyb kurzoru myši.

##### Zjednodušený režim objektové navigace {#toc102}

Jestliže je tato volba zapnutá, NVDA bude filtrovat hierarchii zobrazených objektů tak, že vynechá nepoužitelné objekty.

#### Prezentace objektů (NVDA+Ctrl+O) {#toc103}

Tuto položku najdete v nabídce možnosti a obsahuje následující prvky:

##### Hlásit kontextovou nápovědu {#toc104}

Zaškrtnutí tohoto políčka zajistí, že  NVDA bude číst obsah kontextové nápovědy, je-li k dispozici. Řada oken a ovládacích prvků vyvolá malou textovou nápovědu, jestliže se nad ně přesune kurzor myši, nebo když se na ně přesune fokus. 

##### Hlásit obsah bublinové nápovědy {#toc105}

Při zaškrtnutí tohoto políčka bude NVDA ohlašovat obsah bublinové nápovědy, která se objeví na obrazovce. Bublinová nápověda je podobná kontextovým popiskům, ale plocha bubliny je obvykle větší a tato nápověda se používá vesměs pro sdělování systémových událostí jako je např. odpojení síťového kabelu, nalezení nového hardwaru, objevení se problémů se zabezpečením systému atd. 

##### Hlásit přístupové klávesy k objektům {#toc106}

Pokud je toto zaškrtávací políčko zaškrtnuto, NVDA bude ohlašovat klávesové zkratky, které jsou vázány k různým příkazům a objektům. Například: nabídka Soubor má přístupovou klávesu Alt+S, takže součástí informace při ohlášení nabídky bude i tato klávesová zkratka. 

##### Hlásit pozici objektu {#toc107}

Tato volba zapíná či vypíná ohlašování informací o pozici objektu, na kterém se nachází kurzor. Je to např. informace o položce seznamu (1 z 10) apod. 

##### Odhadnout pozici objektu, není-li dostupná {#toc108}

Pokud je zaškrtnutá volba hlásit pozici objektu, pak toto nastavení umožňuje NVDA odhadnout pozici aktuálně zaměřeného objektu, není-li informace o pozici standardně dostupná.
Jestliže je toto políčko zaškrtnuté, NVDA bude ohlašovat informace o pozici pro větší množství  prvků jako jsou např. položky v nabídkách či panely nástrojů, i když tyto informace nemusí být vždy úplně přesné.

> ==== Hlásit popisky objektů ====

Odškrtněte toto políčko, pokud si myslíte, že vás popisky objektů obtěžují. 

<!-- KC:setting -->

##### Indikátor průběhu {#toc109}

|Klávesová zkratka pro desktop |NVDA+U|
|Klávesová zkratka pro laptop |NVDA+u|

Indikátor průběhu je ovládací prvek, který vzhledem poněkud připomíná pravítko. Při průběhu déle trvajících akcí se postupně lišta zvýrazňuje nebo se též zobrazují procenta dané akce. Platí to např. pro načítání webových stránek, kontrolu pošty, kopírování souborů atd. 

V tomto rozbalovacím seznamu je tedy možné přizpůsobit ohlašování indikátoru průběhu. Aktuálně jsou dostupné tyto možnosti: 

* Vypnuto: Aktualizace indikátoru průběhu bude bez odezvy.
* Ohlašovat: Tato volba zajistí ohlašování hodnoty indikátoru průběhu v procentech. Vždy, když se hodnota změní, NVDA tuto změnu ohlásí.
* Pípat: Tato volba zajistí, že při každé změně indikátoru průběhu NVDA krátce pípne. Čím je tón pípání vyšší, tím vyšší je počet procent na indikátoru průběhu a  právě probíhající akce se blíží ke konci.
* Ohlašovat a pípat: Tato volba je kombinací obou předchozích možností. Změny indikátoru průběhu jsou oznamovány hlasem a zároveň jsou signalizovány krátkým pípáním.

##### Ohlašovat indikátor průběhu na pozadí {#toc110}

Pokud je tato volba zaškrtnuta, NVDA bude sledovat i průběh indikátorů, které nejsou zobrazeny v okně v popředí. Znamená to, že když minimalizujete okno, v němž je zobrazen indikátor průběhu, můžete dělat cokoli dalšího a NVDA bude i nadále sledovat aktualizaci tohoto průběhu a dle vámi zvoleného nastavení ji bude ohlašovat. 

Pozn. Pokud máte způsob ohlašování indikátoru průběhu nastaven na ohlašovat, NVDA bude u indikátorů průběhu na pozadí ohlašovat každých 10 procent, nikoli každé další procento.

<!-- KC:setting -->

##### Hlásit dynamicky měněný obsah {#toc111}

Klávesová zkratka: NVDA+5

Přepíná automatické ohlašování obsahu některých objektů jako např. terminály či příchozí text v chatovacích programech.

#### Nastavení režimu prohlížení (NVDA+Ctrl+B) {#toc112}

Tento dialog najdeme v nabídce Možnosti pod názvem Režim prohlížení a obsahuje následující nastavení: 

##### Maximální počet znaků na řádku {#toc113}

V tomto editačním poli nastavíte maximální počet znaků na jeden řádek v režimu prohlížení. 

##### Počet řádků na stránce {#toc114}

Toto nastavení určuje počet řádků, o které se posunete, když v režimu prohlížení stisknete klávesu Page Up či Page Down. 

<!-- KC:setting -->

##### Zachovat stejný vzhled jako na obrazovce {#toc115}

Klávesová zkratka: NVDA+V

Umožňuje nastavit zalamování obsahu dokumentu v režimu prohlížení. Pokud je tato volba zapnutá, všechny prvky budou zobrazeny tak, jak jsou rozmístěny na obrazovce. Pokud je tato volba vypnutá, odkazy a další prvky budou zobrazeny odděleně na samostatném řádku.

##### Hlásit vzhledové tabulky {#toc116}

Pokud je tato volba odškrtnuta, NVDA bude oznamovat jen klasické tabulky obsahující běžná tabulková data. Naopak když tuto volbu zaškrtnete, NVDA bude oznamovat i takové tabulky, které slouží čistě na dotvoření vizuální prezentace stránky. 

##### Nastavení oznamování prvků {#toc117}

V předchozích verzích NVDA bylo možné v tomto dialogu nastavovat oznamování prvků, které jsou standardní součástí webových stránek. Jedná se např. o oznamování odkazů, tabulek, seznamů, editačních polí a dalších. Nastavování oznamování těchto prvků je nyní společné pro všechny typy dokumentů, ve kterých mohou být tyto prvky obsaženy a samotná nastavení byla přesunuta do dialogu [Ohlašování formátování dokumentu](#DocumentFormattingSettings).

##### Automaticky přepínat formulářový režim při změně zaměření {#toc118}

Tato možnost umožňuje automatické zapínání formulářového režimu v případě, že se změní pozice fokusu. Např. když při prohlížení webové  stránky použijete klávesu tab a pod kurzorem se ocitne editační pole nebo jakýkoli jiný formulářový prvek, automaticky se zapne formulářový režim. Pokud se po dalším stisku klávesy tab objeví pod kurzorem odkaz, či jiný prvek, který už nemá s formulářovými prvky nic společného, automaticky se zapne režim prohlížení. 

##### Automaticky přepínat formulářový režim při pohybu šipkami {#toc119}

Jestliže je tato volba zaškrtnutá, NVDA bude přepínat mezi formulářovým režimem a režimem prohlížení při pohybu kurzorovými šipkami. Např. jestliže se při prohlížení webové stránky pod kurzorem objeví editační políčko, NVDA automaticky aktivuje formulářový režim a je tedy možné do políčka psát či libovolně upravovat jeho obsah. Pokud budete šipkou pokračovat v prohlížení stránky a kurzor opustí dané políčko, aktivuje se opět režim prohlížení. 

##### Zvuková indikace formulářového režimu a režimu prohlížení {#toc120}

Pokud je tato volba zaškrtnuta, NVDA bude přepínání mezi formulářovým režimem a režimem prohlížení signalizovat krátkými zvukovými návěstími. 

#### Ohlašování formátování dokumentu (NVDA+Ctrl+D) {#DocumentFormattingSettings}

Toto dialogové okno najdete v možnostech programu NVDA pod stejnojmenným názvem.

Téměř všechna zaškrtávací políčka slouží k nastavení ohlašování formátování, jehož změny mají být oznamovány při pohybu kurzorem v dokumentech či na webových stránkách. Jestliže např.  zaškrtnete ohlašování názvu písma, tak jakmile se při prohlížení jakéhokoli textu zobrazí jiný typ písma, NVDA danou změnu ohlásí.

Takto můžete nastavit:

* název písma- velikost písma
* vlastnosti písma
* zarovnání textu
* barvy
* styl textu
* pravopisné chyby
* číslování stran
* číslování řádků, 
* datové tabulky
* záhlaví řádků a sloupců v tabulkách
* souřadnice buněk v tabulkách
* odkazy
* nadpisy
* seznamy
* citace
* oblasti stránky

##### Při pohybu kurzoru oznamovat změny formátování {#toc122}

Jestliže je tato volba zapnutá, NVDA se pokusí detekovat změny formátování na celém řádku a při čtení je všechny oznámí, i když to může do jisté míry negativně ovlyvnit výkonnost NVDA.

Implicitně NVDA detekuje formátování na pozici textového či čtecího kurzoru a volitelně může detekovat formátování na celém aktuálním řádku, pokud to nezpůsobí příliž velké spomalení.

Tuto volbu doporučujeme použít, jestliže např. kontrolujete dokumenty v aplikacích jako Microsoft word a formátování je pro vás důležité.

#### Řečové slovníky {#toc123}

Podnabídka Řečové slovníky, která se nachází v nabídce Možnosti, obsahuje tři různé typy uživatelských slovníků, ve kterých lze nastavit, jak má NVDA vyslovovat konkrétní slova, či fráze. 

* Výchozí slovník: Výrazy uložené v tomto slovníku ovlivní veškeré řečové projevy NVDA.
* Slovník pro aktuální hlas: Výrazy uložené v tomto slovníku ovlivní veškeré řečové projevy aktuálně používaného hlasu.
* Dočasný slovník: Výrazy uložené v tomto slovníku ovlivní veškeré řečové projevy NVDA, ale jen dočasně. Po ukončení NVDA bude obsah slovníku vymazán.

V každém z těchto slovníků najdete seznam vámi uložených výrazů a tlačítka pro přidání, úpravu a odstranění položky ze slovníku. 

Pro přidání výrazu stiskněte tlačítko Přidat. V dialogu, který se objeví vyplňte příslušná políčka a stiskněte tlačítko Ok. Přidaný výraz se objeví v seznamu s uloženými položkami. Aby veškeré provedené úpravy slovníku byly korektně uloženy, stiskněte tlačítko Ok. Tím vstoupí v platnost veškeré provedené změny a zároveň se ukončí dialogové okno editovaného slovníku. 

Pravidla pro řečové slovníky NVDA vám umožní změnit jakýkoli řetězec znaků na zcela odlišný řetězec.
Představte si, že např. chcete, aby NVDA řekl slovo "žába" vždy, když se v textu objeví slovo "pták".
Nejpohodlněji toho docílíte tak, že v dialogu Přidat položku do slovníku do pole Vzor vložíte slovo pták a do pole Nahradit slovo žába.
Abyste se v seznamu pravidel neztratili, můžete si do políčka komentář zadat nějaký text vystihující aktuální pravidlo.

Řečové slovníky NVDA toho dokáží mnohem víc, než jen zaměňovat slova.
Dialog pro přidání položky do slovníku obsahuje zaškrtávací políčko Rozlišovat velká a malá písmena, kterým můžete NVDA donutit rozlišovat, jestli text je a nebo není napsaný velkými písmeny.
Standardně NVDA velikost písmen ignoruje.
Další zaškrtávací políčko s názvem Regulární výraz Vám umožní určit, jestli se v poli Vzor nachází jednoduchý text nebo tzv. regulární výraz.
Regulární výraz je speciální druh vzoru, který umožňuje filtrovat buď jenom znaky, nebo jenom čísla a nebo libovolný počet libovoľných znaků v různých kombinacích.
Regulární výrazy nejsou v této příručce podrobně vysvětleny, ale na internetu lze k tomuto tématu najít spoustu zajímavých článků.

#### Výslovnost interpunkčních znaků {#SymbolPronunciation}

V tomto dialogu můžete měnit nejen výslovnost interpunkčních a dalších speciálních znaků, ale i úroveň vyslovování interpunkce, při které bude NVDA tyto znaky číst.

Pokud chcete upravit výslovnost nějakého konkrétního znaku, musíte ho nejprve najít v seznamu znaků.
Do políčka nahradit vepište text, který má být vysloven při přečtení tohoto znaku.
V seznamu úrovní můžete určit nejnižší úroveň, ve které bude znak vyslovován.
Pokud jste skončili s úpravami, stiskněte tlačítko OK pro uložení nebo tlačítko Zrušit pro vrácení změn.

### Uložení a znovunačtení nastavení {#toc125}

NVDA automaticky vaše nastavení neukládá, takže pokud ukončíte program a pak ho znovu spustíte, nastavení se vrátí do původních hodnot. Pokud chcete, aby NVDA nastavení automaticky ukládal, zaškrtněte příslušnou položku v dialogu Obecné nastavení.
Pro uložení nastavení NVDA můžete rovněž použít položku uložit nastavení v nabídce NVDA.

Jestliže  je NVDA spuštěn z média, které má atribut "jen pro čtení" jako např. CD, nebude možné vaše nastavení uložit a o této skutečnosti vás program bude informovat. 

Pokud jste při nastavování programu udělali chybu a potřebujete se vrátit k uložené konfiguraci, můžete využít možnost znovu načíst nastavení, kterou najdete přímo v nabídce NVDA.

Užitečné mohou být rovněž následující klávesové příkazy:
<!-- KC:beginInclude -->

| Název |Klávesová zkratka pro desktop + Klávesová zkratka pro laptop |Popis|
|---|---|---|
|Uložit nastavení |NVDA+Ctrl+c |NVDA+Ctrl+c |Uloží aktuální nastavení NVDA tak, aby se při ukončení NVDA neztratila|
|Načíst uložené nastavení |NVDA+Ctrl+r |NVDA+Ctrl+r |Načte naposledy uložené nastavení programu NVDA|

<!-- KC:endInclude -->

++ Konfigurační soubory a uživatelské profily ++Qig, kterou najdete ve složce přenosné verze NVDA.

Instalační verze NVDA si všechna nastavení, vlastní aplikační moduly či ovladače hlasových a braillských výstupů ukládá do složky NVDA, kterou najdete v uživatelském profilu systému windows. To znamená, že každý uživatel systému může mít své vlastní nastavení NVDA.
Složku s Vaším nastavením NVDA můžete otevřít např. pomocí zástupce, který se nachází v nabídce start, v  podnabídce programy, ve složce NVDA.

Nastavení, která se použijí v případě, že NVDA běží na přihlašovací nebo jiné zabezpečené obrazovce jsou uložena ve složce systemConfig, která je podsložkou instalačního adresáře NVDA.
Běžně není nutné do této složky zasahovat.
Jestliže chcete změnit konfiguraci NVDA pro přihlašovací obrazovku, přihlašte se do systému windows, nastavte si NVDA podle vašich představ, konfiguraci si uložte a potom pomocí tlačítka v dialogu Obecné nastavení ji zkopírujte na přihlašovací obrazovku.

## Další nástroje {#toc126}
### Zobrazit log {#toc127}

Prohlížeč logu, který je možné spustit z nabídky nástroje, Vám umožní zobrazit veškerý zápis do log souboru, který se zaznamenal od posledního spuštění NVDA.

kromě čtení obsahu si můžete rovněž uložit kopii log souboru nebo můžete obnovit obsah prohlížeče, aby obsahoval i záznamy zapsané po otevření okna prohlížeče logu.
Tyto možnosti jsou dostupné z aplikačního menu prohlížeče logu.

### Zobrazení řeči {#toc128}

Pro vidící vývojáře software nebo pro lidi, kteří představují NVDA vidícím zájemcům, existuje plovoucí okno, které zobrazuje veškerý text, jenž NVDA posílá hlasovému výstupu.
Zobrazení řeči je možné aktivovat zaškrtnutím stejnojmenné položky v nabídce nástroje. Odškrtnutím stejné položky ho opět deaktivujete.

Po dobu, kdy je zobrazení řeči aktivní, se Jeho obsah neustále aktualizuje s právě čteným textem.
Pozastavit zobrazování aktuálního textu (např. užitečné pro kopírování) je možné kliknutím nebo přepnutím fokusu do okna se zobrazenou řečí.

### Python konzole {#toc129}

Python konzole programu NVDA, dostupná z nabídky nástroje, je nástroj určený především pro vývojáře, který umožňuje kontrolovat správnost běhu NVDA, zjišťovat stav vnitřních proměnných NVDA a také zkoumat hierarchii přístupnosti aplikací.
Pro více informací si, prosím, přečtěte [článek Python konzole (anglicky) na stránce NVDA](NVDA_URLwiki/PythonConsole).

### Znovu načíst zásuvné moduly {#toc130}

Tato položka aktivuje znovu načtení zásuvných a aplikačních modulů bez nutnosti restartovat NVDA. To může být užitečné pro vývojáře..

## Podporované hlasové výstupy {#SupportedSpeechSynths}

Tato kapitola obsahuje informace o hlasových výstupech podporovaných programem NVDA.

### eSpeak {#toc132}

Hlasový výstup [eSpeak](https://espeak.sourceforge.net/) je vestavěný přímo v programu NVDA a nepožaduje žádné speciální ovladače nebo jiné komponenty, které by se musely doinstalovávat.
Standardně se NVDA spouští s hlasovým výstupem eSpeak.
Tento hlasový výstup  by měl fungovat v každém systému, kde pracuje NVDA, což znamená, že NVDA můžete spouštět na libovoľném počítači, dokonce i z USB klíčenky nebo CD.

Každý hlas eSpeaku je určen pro jiný jazyk a najdete zde více než 20 hlasů pro různé jazyky¨, které eSpeak podporuje.

Existuje mnoho variant, kterými je možné změnit vlastnosti zvuku aktuálního hlasu.

### Microsoft Speech API verze 4 (SAPI 4) {#toc133}

SAPI 4 je starší standard vyvinutý společností Microsoft, který slouží na obsluhu softwarových hlasových výstupů v systému Windows.
Mnoho hlasových výstupů kompatibilních s tímto standardem je možné koupit nebo zdarma stáhnout od různých dodavatelů nebo z různých webových stránek.
Při použití SAPI 4 ovladače hlasových výstupů bude v [dialogu Nastavení hlasu](#VoiceSettings) nebo v [kruhu nastavení hlasového výstupu](#SynthSettingsRing) dostupný kompletní seznam všech SAPI 4 hlasů, které máte v systému nainstalované.

Pokud máte nainstalované nějaké SAPI4 hlasy, ale některý z nich se v seznamu dostupných hlasů neobjeví, zkuste nainstalovat balík SAPI 4.0 runtime ze stránky https://activex.microsoft.com/activex/controls/sapi/spchapi.exe.

### Microsoft Speech API verze 5 (SAPI 5) {#toc134}

SAPI 5 je standard vyvinutý společností Microsoft, který slouží na obsluhu softwarových hlasových výstupů v systému Windows.
Mnoho hlasových výstupů kompatibilních s tímto standardem je možné koupit nebo zdarma stáhnout od různých dodavatelů nebo z různých webových stránek, ale v systému už pravděpodobně máte alespoň jeden SAPI 5 kompatibilní hlas nainstalovaný.
Při použití SAPI 5 ovladače hlasových výstupů bude v [dialogu Nastavení hlasu](#VoiceSettings) nebo v [kruhu nastavení hlasového výstupu](#SynthSettingsRing) dostupný kompletní seznam všech SAPI 5 hlasů, které máte v systému nainstalované.

### Audiologic Tts3 {#toc135}

Toto je komerční hlasový výstup určený pouze pro italský jazyk.
Aby jej bylo možné používat s NVDA, musí být tento hlasový výstup nainstalovaný v systému.
Pro více informací, prosím, navštivte domovskou stránku Audiologic [www.audiologic.it](http://www.audiologic.it).

### Newfon {#toc136}

Newfon je volně dostupný komerční hlasový výstup Sergeye Šišminčeva, který podporuje ruský a ukrajinský jazyk.
Tento hlasový výstup můžete stáhnout v sekci ke stažení na stránkách ruské komunity NVDA: https://ru.nvda-community.org/?page_id=10.

## Podporované braillské řádky {#SupportedBrailleDisplays}

Tato kapitola obsahuje informace o braillských řádcích podporovaných programem NVDA..

### Řádky Focus/PAC Mate společnosti Freedom Scientific {#toc138}

NVDA podporuje všechny braillské řádky Focus a PAC Mate společnosti [Freedom Scientific](https://www.freedomscientific.com/).
Pro správnou funkčnost musíte mít v systému nainstalované ovladače braillských řádků Freedom scientific.
Jestliže je ještě nemáte, můžete je stáhnout ze stránky: shttps://[www.freedomscientific.com/downloads/focus-40-blue/focus-40-blue-downloads.asp](http://www.freedomscientific.com/downloads/focus-40-blue/focus-40-blue-downloads.asp).
I když se na stránce mluví jen o řádku Focus 40 Blue, ovladačspolupracuje se všemi řádky Freedom scientific.

### Optelec ALVA BC640/680 {#toc139}

NVDA podporuje oba řádky [Optelec](https://www.optelec.com/), jak ALVA BC640 tak BC680.
Pro použití těchto řádků se nemusí instalovat žádné ovladače.
Stačí řádek zapojit a nastavit NVDA na jeho používání.

### Braillské řádky společnosti Handy Tech {#toc140}

NVDA podporuje všechny braillské řádky společnosti [Handy Tech](https://www.handytech.de/).
Pro některé starší USB řádky je nutné do systému doinstalovat USB ovladače Handy Tech.

### MDV Lilli {#toc141}

Braillský řádek Lilli od [MDV](https://www.mdvbologna.it/) je programem NVDA plně podporovaný.
Pro použití tohoto řádku se nemusí instalovat žádné ovladače.
Stačí řádek zapojit a nastavit NVDA na jeho používání.

### Braillské řádky Baum/Humanware/APH {#toc142}

NVDA podporuje některé řádky od [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/) a [APH](https://www.aph.org/) připojené přez USB nebo bluetooth.
Podporované řádky jsou:

* Baum: SuperVario, PocketVario
* HumanWare: Brailliant, BrailleConnect
* APH: Refreshabraille

Pravděpodobně by mohly fungovat některé další řádky od Baum, ale zatím to nebylo řádně otestováno..

Pokud připojujete některý z těchto řádků přez USB, měli byste nejprve nainstalovat ovladače od výrobce..
V případě řádku APH Refreshabraille by měl režim USB být nastavený na serial.

### BRLTTY {#toc143}

[BRLTTY](https://mielke.cc/brltty/) je samostatná aplikace, jejímž prostřednictvím je možné použít mnoho dalších braillských řádků.
pro použití ovladače BRLTTY je nutné nainstalovat [BRLTTY pro Windows](https://brl.thefreecat.org/brltty/).
stáhněte si nejnovější instalační balíček, který najdete pod názvem např. brltty-win-4.2-3.exe.
Při konfiguraci řádku a portu dávejte velký pozor na přesné dodržení instrukcí, hlavně pokud připojujete řádek přez USB a už máte nainstalované ovladače od výrobce.

## Pro pokročilé uživatele {#toc144}
### Jak přizpůsobit klávesové zkratky a ostatní vstupní příkazy {#toc145}

Uživatelé si mohou vytvořit vlastní nebo pozměnit existující konfiguraci klávesových příkazů NVDA a to úpravou speciálně k tomu určeného souboru ve složce s uživatelským nastavením.
Název tohoto souboru je gestures.ini.

Pro zápis do tohoto souboru se používá standardní syntakse zápisu ini souborů.
Soubor může obsahovat vícero sekcí a každá sekce může obsahovat jednu nebo několik položek.

Každá sekce obsahuje mapování vstupních příkazů na skripty v jednom python modulu a třídě NVDA.

* Název sekce se skládá z názvu python modulu a názvu třídy oddělenými tečkou. 
* Klíčem každé položky je název skriptu, pro který chcete namapovat vstupní příkaz.
Můžete  rovněž odstranit mapování jakéhokoliv už použitého vstupního příkazu a místo názvu skriptu uvést slovo None.
* Hodnotou každého klíče je čárkou oddělený seznam identifikátorů vstupních příkazů, které mají být namapovány na skript uvedený v klíči.

Identifikátor vstupního příkazu se skládá z dvojznakového identifikátoru zařízení (kb pro klávesnici, br pro braillský řádek), nepovinného identifikátoru subzařízení nebo rozložení kláves v závorce, dvojtečky a seznamu identifikátorů kláves oddělených znakem +.

Pro zjištění identifikátorů vstupních příkazů, názvů modulů, tříd a skriptů můžete:

1. Aktivovat výukový režim.
1. Vyvolat požadovaný skript (stisknout klávesovou zkratku).
1. Deaktivovat výukový režim.
1. Z nabídky nástroje zobrazit log a přečíst si poslední řádky.
Jeden z nich by měl obsahovat vámi vyvolaný vstupní příkaz spolu s informacemi o modulu, třídě a skriptu, které jsou k němu momentálně přiřazeny.

Zde je příklad, který vysvětluje, jak můžete příkaz NVDA+Shift+T přiřadit skriptu datum a čas.

Abyste zjistili správný název skriptu, název třídy a modulu, spustíte výukový režim stiskem NVDA+1 a potom stisknete NVDA+F12, protože to je nynější příkaz pro skript datum a čas.
Potom opětovným stiskem NVDA+1 vypnete výukový režim a přečtete si poslední řádky v okně prohlížeče logu.

Téměř úplně na konci najdete něco jako:

    INFO - inputCore.InputManager._handleInputHelp (13:17:22):
    Input help: gesture kb(desktop):nvda+f12, bound to script dateTime on globalCommands.GlobalCommands

Z tohoto výpisu  můžete určit, že název skriptu je dateTime a názvy modulu.třídy jsou globalCommands.GlobalCommands.

Pokud tento soubor ještě neexistuje, vytvořte ve složce s uživatelským nastavením NVDA soubor gestures.ini s následujícím obsahem:

    [globalCommands.GlobalCommands]
    	dateTime = kb:NVDA+shift+t

Takto přiřadíte klávesový příkaz NVDA+Shift+T skriptu dateTime ve všech rozloženích klávesnice.

Všimněte si, že původní přiřazená klávesová zkratka NVDA+F12 bude stále funkční.
Pokud byste chtěli zrušit její namapování, můžete přidat následující řádek

    	None = kb:NVDA+f12

Ačkoli můžete při mapování vstupních příkazů použít  jakoukoli klávesu, tak použití klávesy alt může být v některých případech problematické.
NVDA posílá stisk modifikačních kláves jako je Ctrl, Shift a Alt operačnímu systému i v případě, že jsou namapované na nějaký skript programu NVDA. Jestliže tedy použijete ve vstupním příkazu klávesu alt, může jeho stisk kromě vyvolání požadovaného skriptu NVDA rovněž zobrazit panel nabídek.
Proto je jako modifikátory vhodné používat zejména klávesy NVDA, ctrl a shift.

## Jak získat více informací {#toc146}

Protože se NVDA neustále vyvíjí, není možné zajistit funkčnost všech klávesových příkazů a postupů tak, jak jsou popsány v této příručce.
Jestliže  se vyskytnou problémy s některými zde popsanými příkazy, navštivte, prosím, webovou stránku programu NVDA a zkuste vyhledat aktuální informace. 

Hledáte-li další informace o NVDA, o jeho vývoji nebo hledáte-li pomoc, můžete rovněž navštívit stránku projektu na adrese NVDA_URL.
Na této stránce můžete rovněž najít přístup k emailovým konferencím pojednávajících o NVDA a odkazy na další komunitní projekty a stránky o NVDA.
Můžete zde také najít informace o vývoji, zdrojové kódy a jiné související materiály.

