# NVDA NVDA_VERSION Εγχειρίδιο Χρήσης

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Γρήγορη Αναφορά Εντολών Πληκτρολογίου -->



## Εισαγωγή {#toc2}

Το NonVisual Desktop Access (NVDA) είναι ένας αναγνώστης οθόνης ανοικτού κώδικα για τα λειτουργικά συστήματα Microsoft Windows, ο οποίος διατίθεται δωρεάν.
Παρέχοντας ανάδραση μέσω συνθετικής ομιλίας και Braille, επιτρέπει σε τυφλούς ή μερικώς βλέποντες χρήστες να έχουν πρόσβαση σε υπολογιστές που τρέχουν τα Windows χωρίς επιπλέον κόστος σε σχέση με έναν βλέποντα.
Το NVDA αναπτύσσεται από την [NV Access](https://www.nvaccess.org/), με τη συμμετοχή της κοινότητας.

### Γενικά Χαρακτηριστικά {#toc3}

Το NVDA επιτρέπει στους τυφλούς και τους μερικώς βλέποντες να έχουν πρόσβαση και να αλληλεπιδρούν με τα λειτουργικά συστήματα των Windows και πολλές εφαρμογές τρίτων κατασκευαστών.

Κάποιες από τις βασικές δυνατότητες του προγράμματος περιλαμβάνουν:

* Υποστήριξη δημοφιλών εφαρμογών συμπεριλαμβανομένων πλοηγών διαδικτύου, προγράμματα ηλεκτρονικού ταχυδρομείου, προγράμματα συνομιλίας στο διαδίκτυο και εφαρμογές γραφείου
* Ενσωματωμένο συνθέτη  φωνής που υποστηρίζει περισσότερες από 80 γλώσσες
* Αναφορά για πληροφορίες μορφοποίησης κειμένου όπου είναι διαθέσιμες όπως το όνομα του φόντου και το μέγεθος του, στιλ και ορθογραφικά λάθη
* Αυτόματη αναφορά για το κείμενο που βρήσκεται κάτω από το ποντίκι καθώς και προαιρετικές ηχητικές ενδείξεις για την θέση που βρήσκεται αυτό
* Υποστήριξη μεγάλου αριθμού οθονών braille,  καθώς και εισαγωγή braille για υπολογιστές σε οθόνες που διαθέτουν braille πληκτρολόγιο.
* Η δυνατότητα το πρόγραμμα να τρέχει σε USB στικάκια ή σε άλλα φορητά μέσα χορίς να απαιτείται να γίνει εγκατάσταση
* Εύκολος στην χρήση οδηγός εγκατάστασης με ομιλία
* Είναι μεταφρασμένο σε 47 γλώσσες
* Υποστήριξη για πρόσφατες εκδόσεις των windows συμπεριλαμβανομένων των 32 και 64 bit
* Δυνατότητα να τρέχει στην οθόνη σύνδεσης για τα windows και σε άλλες ασφαλείς οθόνες
* Υποστήριξη για προγραμματιστικές διεπαφές για την προσβασιμότητα των windows όπως Microsoft Active Accessibility, Java Access Bridge, IAccessible2 και UI Automation. (Το UI Automation υποστηρίζεται μόνο σε windows 7 ή νεότερα.)
* Υποστήριξη για την γραμμή εντολών των windows και εφαρμογές κονσόλας

### Διεθνοποίηση {#toc4}

Είναι σημαντικό οι άνθρωποι στον κόσμο, σε όποια γλώσσα και αν μιλούν, να έχουν ίση πρόσβαση στην τεχνολογία.
Εκτός από τα Αγγλικά, το nvda έχει μεταφραστεί σε 47 γλώσσες που συμπεριλαμβάνουν: Τα Αφρικανικά, αλβανικά, Αμαρικά, αραβικά,  Αραγονίκά, Πορτογαλικά Βραζιλίας, Βουλγαρικά, Καταλανικά, Ισπανικά Κολομβίας, κροατικά, τσεχικά, δανικά, ολλανδικά, περσικά, Φινλανδικά, Γαλλικά, Γαλικιανά, ελληνικά, γεωργιανά, Γερμανικά, Εβραϊκά, Χίντι, Ουγγρικά, Ισλανδικά, Ιρλανδικά, Ιταλικά, Ιαπωνικά, Κορεατικά, Νεπάλ, Νορβηγικά, Πολωνικά, Πορτογαλικά, Παντζάμπι, ρουμανικά, ρωσικά, σερβικά, σλοβακικά, σλοβενικά, ισπανικά, σουηδικά, Ταμίλ, Ταϊλανδέζικα, Παραδοσιακά και Απλοποιημένα κινέζικα, Τουρκικά, Ουκρανικά και Βιετναμέζικα.

### Υποστήριξη συνθετών φωνής {#toc5}

Εκτός από το γεγονός πως το nvda παρέχει τα μηνύματα του καθώς και το περιβάλλον χρήσης του σε διάφορες γλώσσες, το nvda επίσης μπορεί να βοηθήσει τον χρήστη να διαβάσει περιεχόμενο σε οποιαδήποτε γλώσσα, φτάνει ο χρήστης να διαθέτει ένα συνθέτη φωνής που να μπορεί να μιλήσει την συγκεκριμένη γλώσσα.

Το nvda έρχεται ενσωματωμένο με το [eSpeak](https://espeak.sourceforge.net/), έναν δωρεάν, ανοιχτού κώδικα, πολύγλωσσο συνθέτη φωνής.

Πληροφορίες για άλλους συνθέτες φωνής που υποστηρίζει το nvda μπορείτε να βρείτε στο κεφάλαιο [Υποστηριζόμενοι Συνθέτες φωνής](#SupportedSpeechSynths).

### Υποστήριξη braille {#toc6}

Για χρήστες που διαθέτουν κάποια οθόνη braille, το nvda μπορεί να  εξάγει όλες του τις πληροφορίες σε μορφή braille.
Για περισσότερες πληροφορίες μπορείτε να δείτε το κεφάλεο [υποστηριζόμενες οθόνες braille](#SupportedBrailleDisplays).

Το nvda υποστηρίζει κώδικες braille σε διάφορες γλώσσες, που συμπεριλαμβάνου braille με συντομεύσεις, braille χωρίς συντομεύσεις και braille για υπολογιστές.

### άδεια και δικαιώματα χρήσης {#toc7}

Το nvda είναι nvda copyright NVDA_COPYRIGHT_YEARS και σε όσους συμβάλουν στην ανάπτυξη του.

Το nvda καλύπτεται από την άδεια GNU General Public License (έκδοση 2).
Είσαστε ελεύθεροι να μοιραστήτε ή να αλλάξετε αυτό το λογισμικό με όποιο τρόπο θέλετε φτάνει να συνοδεύεται από την άδεια και να δώσετε τον κώδικα του προγράμματος σε όποιον το θελήσει.
Αυτό ισχύει και για τα 2 το πρωτότυπο ή αλλαγμένα αντίγραφα αυτού του λογισμικού, ή τα παράγωγα τους
Για περισσότερες πληροφορίες μπορείτε να [Δείτε ολόκληρη την άδεια.](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html)

## Απαιτήσεις Συστήματος {#toc8}

* Λειτουργικά Συστήματα: όλες οι 32-bit και 64-bit εκδόσεις των Windows XP, Windows Vista, Windows 7, windows 8 και windows 10 (συμπεριλαμβανωμένων των λειτουργικών συστημάτων Server).
 * Για τα Windows XP 32-bit, το nvda χρειάζεται το Service Pack 2 ή νεότερο.
 * Για τα Windows Server 2003, το nvda χρειάζεται το Service Pack 1 ή νεότερο.
* Μνήμη: 256 MB ή περισσότερη RAM
* Ταχύτητα επεξεργαστή: 1.0 ghz ή παραπάνω
* Περίπου 50 MB αποθηκευτικού χώρου.

## Λήψη και Διαμόρφωση του NVDA {#toc9}

Αν δεν έχετε ακόμα στη κατοχή σας ένα αντίγραφο του NVDA, μπορείτε να το κατεβάσετε από το [www.nvaccess.org](NVDA_URL).

Πηγαίνετε στην περιοχή download και ακολουθήστε το σύνδεσμο που θα βρείτε για να κατεβάσετε την τελευταία έκδοση του NVDA.

Εάν εκτελέσετε το αρχείο που μόλις κατεβάσατε, θα ξεκινήσει η εκτέλεση ενός προσωρινού αντίγραφου του NVDA.
Στη συνέχεια θα ερωτηθείτε αν θέλετε να εγκαταστήσετε το NVDA, να δημιουργήσετε ένα φορητό αντίγραφο ή αν θέλετε απλώς να συνεχίσετε να χρησιμοποιείτε το προσωρινό  αντίγραφο.

Για να χρησιμοποιείτε πάντα το NVDA σε αυτόν τον υπολογιστή, επιλέξτε την εγκατάσταση του NVDA.
Η εγκατάσταση του NVDA θα σας επιτρέψει να έχετε πρόσθετες λειτουργίες όπως η αυτόματη εκκίνηση του μετά την είσοδο στα Windows, η δυνατότητα να σας διαβάζει τις οθόνες της εισόδου στα Windows και άλλες οθόνες ασφαλείας των Windows (που δεν μπορεί να γίνει με το φορητό και το προσωρινό αντίγραφο), και η δημιουργία συντομεύσεων στο μενού Έναρξη και στην επιφάνεια εργασίας.
Επίσης, το εγκατεστημένο αντίγραφο του NVDA έχει τη δυνατότητα να δημιουργεί το ίδιο ανά πάσα στιγμή ένα φορητό αντίγραφο.

Αν θέλετε να πάρετε το NVDA μαζί σας σε ένα δίσκο USB ή άλλο μέσο ανάγνωσης, τότε επιλέξτε τη δημιουργία ενός φορητού αντίγραφου.
Το φορητό αντίγραφο έχει επίσης τη δυνατότητα να εγκαθιστά τον εαυτό του σε οποιονδήποτε υπολογιστή σε μεταγενέστερο χρόνο.
Ωστόσο, αν θέλετε να αντιγράψετε το NVDA σε ένα μέσο που είναι μόνο για ανάγνωση, όπως ένα CD, τότε πρέπει απλά να αντιγράψετε το πακέτο που κατεβάσατε.
Η εκτέλεση της φορητής έκδοσης απευθείας από μέσο μόνο για ανάγνωση δεν υποστηρίζεται προς το παρόν.

Η χρήση του προσωρινού αντίγραφου του NVDA είναι επίσης μία επιλογή (π.χ. για σκοπούς επίδειξης), αν και η εκκίνηση του NVDA κάθε φορά με αυτό τον τρόπο μπορεί να γίνει πολύ χρονοβόρα.

### Περιορισμοί του φορητού και του προσωρινού αντίγραφου {#toc10}

Εκτός από το γεγονός πως δεν μπορούν να ξεκινήσουν αυτόματα κατά την διάρκεια ή μετά την οθόνη εισόδου των windows, το φορητό και το προσωρινό αντίγραφο του nvda έχουν τους ακόλουθους περιορισμούς:

* την αδυναμία να συνεργαστούν με εφαρμογές που τρέχουν με δικαιώματα διαχειριστή, εκτός και αν το nvda τρέχει με τα ίδια δικαιώματα (Κάτι που δεν συστήνεται).
* Την αδυναμία να διαβάσουν οθόνες ασφαλείας των Windows όταν μια εφαρμογή χρειάζεται να τρέξει με δικαιώματα διαχειριστή.
* Στα windows 8: Την αδυναμία να υπάρξει εισαγωγή από οθόνες αφής.
* Στα windows 8: την αδυναμία παροχής δυνατοτήτων, όπως η λειτουργία Περιήγησης και η εκφώνηση των πληκτρολογούμενων χαρακτήρων σε εφαρμογές που λήφθηκαν από το κατάστημα των windows.

### Εγκατάσταση του NVDA {#toc11}

Αν εγκαταστήσετε το NVDA απευθείας από το πακέτο που έχετε κατεβάσει, πατήστε το κουμπί Εγκατάσταση του NVDA.
Αν έχετε ήδη κλείσει αυτό το παράθυρο διαλόγου ή αν θέλετε να εγκαταστήσετε το NVDA από ένα φορητό αντίγραφο του, παρακαλώ επιλέξτε Εγκατάσταση του NVDA από το μενού που βρίσκεται κάτω από τα Εργαλεία στο μενού του NVDA.

Το παράθυρο διαλόγου της εγκατάστασης που θα εμφανιστεί θα επιβεβαιώσει αν θέλετε να εγκαταστήσετε το NVDA και επίσης θα σας αναφέρει αν αυτή η εγκατάσταση πρόκειται να ενημερώσει μία προηγούμενη εγκατάσταση.
Πατώντας το κουμπί Συνέχεια ξεκινάει η εγκατάσταση του NVDA.
Υπάρχουν επίσης μερικές επιλογές σε αυτό το παράθυρο διαλόγου, οι οποίες εξηγούνται παρακάτω.
Μόλις ολοκληρωθεί η εγκατάσταση, θα εμφανιστεί ένα μήνυμα που θα σας ενημερώνει ότι ήταν επιτυχής.
Πατώντας OK σε αυτό το σημείο, θα οδηγήσει σε επανεκκίνηση του νέου εγκατεστημένου αντιγράφου του NVDA.

#### Εκκίνηση στην Είσοδο των Windows (Windows Logon) {#toc12}

Αυτή η επιλογή σας επιτρέπει να επιλέξετε εάν το NVDA θα ξεκινάει αυτόματα στην οθόνη Εισόδου στα Windows, πριν σας ζητηθεί να πληκτρολογήσετε το συνθηματικό σας (password).
Αυτό περιλαμβάνει επίσης τον Έλεγχο Λογαριασμού Χρήστη (UAC) καθώς και άλλες οθόνες ασφαλείας.

#### Δημιουργία Συντόμευσης Επιφάνειας Εργασίας (ctrl+alt+n) {#toc13}

Αυτή η επιλογή σας επιτρέπει να επιλέξετε εάν το NVDA θα δημιουργήσει μία συντόμευση στην επιφάνεια εργασίας για την εκκίνηση του NVDA.
Αν δημιουργηθεί αυτή η συντόμευση, θα της ανατεθεί ο συνδυασμός συντόμευσης των πλήκτρων control+alt+n, η οποία θα σας επιτρέπει να ξεκινάτε ανά πάσα στιγμή το NVDA πατώντας αυτά τα πλήκτρα.

#### Αντιγραφή της Φορητής Διαμόρφωσης στο Λογαριασμό του Τρέχοντος Χρήστη {#toc14}

Αυτή η επιλογή σας επιτρέπει να επιλέξετε εάν το NVDA θα αντιγράψει τη διαμόρφωση χρήστη από το τρέχον εκτελούμενο αντίγραφο του NVDA στη διαμόρφωση για τον τρέχοντα συνδεδεμένο χρήστη, για το εγκατεστημένο αντίγραφο του NVDA.
Αυτό δεν θα αντιγράψει τη διαμόρφωση για οποιονδήποτε άλλο χρήστη του συστήματος ούτε στη διαμόρφωση συστήματος για να χρησιμοποιείτε κατά την Είσοδο στα Windows και τις άλλες οθόνες ασφαλείας.
Αυτή η επιλογή είναι διαθέσιμη μόνο όταν γίνεται εγκατάσταση από ένα φορητό αντίγραφο, και όχι όταν γίνεται εγκατάσταση απευθείας από το πακέτο που έχετε κατεβάσει.

### Δημιουργία ενός Φορητού Αντίγραφου {#toc15}

Αν δημιουργείτε ένα φορητό αντίγραφο απευθείας από το πακέτο του NVDA που έχετε κατεβάσει, απλά πατήστε το κουμπί Δημιουργία Φορητού Αντίγραφου.
Αν έχετε ήδη κλείσει αυτό το παράθυρο διαλόγου ή αν τρέχετε ένα εγκατεστημένο αντίγραφο του NVDA, επιλέξτε τη Δημιουργία Φορητού Αντίγραφου που βρίσκεται κάτω από τα Εργαλεία στο μενού του NVDA.

Το παράθυρο διαλόγου που εμφανίζεται σας επιτρέπει να επιλέξετε που θα δημιουργηθεί το φορητό αντίγραφο.
Αυτό μπορεί να είναι ένας φάκελος στο σκληρό σας δίσκο, ένα στικάκι usb ή κάποιο άλλο φορητό μέσο.
Επίσης, υπάρχει η επιλογή για το εάν το NVDA θα αντιγράψει τη διαμόρφωση NVDA του τρέχοντος συνδεδεμένου χρήστη, η οποία θα χρησιμοποιηθεί με το νέο φορητό αντίγραφο που θα δημιουργηθεί.
Αυτή η επιλογή είναι διαθέσιμη μόνο όταν δημιουργείτε ένα φορητό αντίγραφο από ένα εγκατεστημένο, και όχι όταν το δημιουργείτε από το   πακέτο που έχετε κατεβάσει.
Πατώντας Συνέχεια θα δημιουργηθεί το φορητό αντίγραφο.
Μόλις ολοκληρωθεί η δημιουργία, θα εμφανιστεί ένα μήνυμα που θα σας ενημερώνει ότι ήταν επιτυχής.
Πατήστε OK για να κλείσετε αυτό το παράθυρο διαλόγου.

## Γνωρίζοντας το NVDA {#toc16}
### Εκκίνηση του NVDA {#toc17}

Αν έχετε εγκαταστήσει το NVDA με τον οδηγό εγκατάστασης, τότε η εκκίνηση του NVDA είναι πανεύκολη, πατώντας control+alt+n ή επιλέγοντας NVDA από το μενού NVDA στο μενού Προγράμματα υπό το μενού Έναρξη. 
Επιπλέον, μπορείτε να πληκτρολογήσετε NVDA στο πλαίσιο διαλόγου Run και στη συνέχεια πατήστε Enter.
Μπορείτε επίσης να χρησιμοποιήσετε επιπρόσθετες εντολές οι οποίες σας επιτρέπουν να επανεκινήσετε το nvda (-r), να το κλείσετε (-q), να απενεργοποιήσετε τα πρόσθετα (--disable-addons), και λοιπά.

Για να εκκινήσετε τη φορητή έκδοση, πηγαίνετε στο φάκελο στον οποίο έχετε αποθηκεύσει το NVDA και πατήστε enter ή κάνετε διπλό κλικ στο nvda.exe.

Όταν αρχίσει η φόρτωση του NVDA, θα ακούσετε μια σειρά από αύξοντες τόνους που σας ενημερώνουν ότι έχει αρχίσει η φόρτωση. 
Ανάλογα με το πόσο γρήγορος είναι ο υπολογιστής σας ή αν τρέχετε το NVDA από USB ή από άλλο πιο αργό μέσο, μπορεί να διαρκέσει αρκετή ώρα η φόρτωση. 
Αν η φόρτωση αργεί πολύ, το NVDA πρέπει να πει “Φόρτωση του NVDA. Παρακαλώ περιμένετε…” 

Αν δεν ακούσετε τίποτα τέτοιο ή ακούσετε τον ήχο σφάλματος των Windows ή μια σειρά από φθίνοντες τόνους, αυτό σημαίνει ότι το NVDA παρουσιάζει σφάλμα και πιθανώς να χρειαστεί να το αναφέρετε στους δημιουργούς. 
Παρακαλούμε να επισκεφτείτε τη σελίδα του NVDA για να μάθετε πώς γίνεται αυτό.

Όταν ξεκινήσει το NVDA για πρώτη φορά, θα συναντήσετε ένα  παράθυρο διαλόγου που σας παρέχει κάποιες βασικές πληροφορίες για το πλήκτρο τροποποίησης του NVDA και το μενού του NVDA. 
(Παρακαλούμε να διαβάσετε περισσότερα για αυτά τα θέματα σε άλλες ενότητες). 
Το πλαίσιο διαλόγου περιέχει επίσης τρία κουμπιά επιλογής. 
Το πρώτο σας επιτρέπει να ελέγξετε αν το NVDA θα χρησιμοποιεί το Κλείδωμα Κεφαλαίων ως πλήκτρο τροποποίησης. 
Το δεύτερο καθορίζει αν το NVDA θα φορτώνει αυτόματα, μόλις συνδεθείτε στα Windows και διατίθεται μόνο για εγκατεστημένες εκδόσεις του NVDA. 
Το τρίτο σας επιτρέπει να ελέγξετε αν το πλαίσιο διαλόγου θα εμφανίζεται κάθε φορά που γίνεται φόρτωση του NVDA. 

### Σχετικά με τις εντολές πληκτρολογίου του NVDA {#toc18}
#### Το πλήκτρο τροποποίησης του NVDA {#toc19}

Οι περισσότερες εντολές του NVDA περιλαμβάνουν το πάτημα ενός συγκεκριμένου πλήκτρου, που ονομάζεται πλήκτρο τροποποίησης, σε συνδυασμό με ένα ή περισσότερα άλλα πλήκτρα. 
Σημαντικές εξαιρέσεις αποτελούν οι εντολές επανεξέτασης κειμένου για τη διάταξη πληκτρολογίου για επιτραπέζιο υπολογιστή, που χρησιμοποιούν μόνο τα πλήκτρα του αριθμητικού πληκτρολογίου, αλλά υπάρχουν και άλλες εξαιρέσεις.

Το NVDA μπορεί να ρυθμιστεί έτσι ώστε το Insert, το Insert του αριθμητικού πληκτρολογίου και/ή το Κλείδωμα Κεφαλαίων να μπορούν να χρησιμοποιηθούν ως πλήκτρα τροποποίησης του NVDA. Τόσο το Insert όσο και το Insert του αριθμητικού πληκτρολογίου είναι προεπιλεγμένα ως πλήκτρα τροποποίησης.

Αν επιθυμείτε να συμπεριφέρεται ένα από τα πλήκτρα τροποποίησης του NVDA όπως θα συμπεριφερόταν αν δεν έτρεχε το NVDA, για παράδειγμα αν θέλετε να ενεργοποιήσετε το Κλείδωμα Κεφαλαίων ενώ αυτό είναι πλήκτρο τροποποίησης του NVDA, μπορείτε να το πατήσετε δυο φορές γρήγορα. 

#### Διατάξεις πληκτρολογίου {#toc20}

Το NVDA έρχεται με δύο σειρές από εντολές πληκτρολογίου (γνωστές ως διατάξεις πληκτρολογίου): η διάταξη επιτραπέζιου υπολογιστή και η διάταξη φορητού υπολογιστή. Η διάταξη για επιτραπέζιο υπολογιστή είναι προεπιλεγμένη, αλλά μπορείτε να αλλάξετε τη διάταξη σε διάταξη για φορητό υπολογιστή στις Ρυθμίσεις Πληκτρολογίου που βρίσκονται στις Ρυθμίσεις στο μενού του NVDA.

Η διάταξη για επιτραπέζιο υπολογιστή χρησιμοποιεί πολύ το αριθμητικό πληκτρολόγιο (με απενεργοποιημένο το κλείδωμα του αριθμητικού πληκτρολογίου). 
Παρότι οι περισσότεροι φορητοί υπολογιστές δε διαθέτουν αριθμητικό πληκτρολόγιο, μερικοί φορητοί υπολογιστές μπορούν να το μιμηθούν, όταν κρατήσουμε πατημένο το πλήκτρο FN σε συνδυασμό με πλήκτρα και γράμματα στη δεξιά πλευρά του πληκτρολογίου (7, 8, 9, u, i, o, j, k, l, κ.λπ.). 
Αν ο φορητός σας υπολογιστής δε μπορεί να κάνει κάτι τέτοιο ή δε σας επιτρέπει να απενεργοποιήσετε το κλείδωμα του αριθμητικού πληκτρολογίου, θα ήταν προτιμότερο να χρησιμοποιήσετε τη διάταξη για φορητό υπολογιστή αντ’ αυτού.

### Χειρονομίες Αφής Του NVDA {#toc21}

Αν χρησιμοποιείτε το NVDA σε μια συσκευή με οθόνη αφής που τρέχει Windows 8 ή νεότερο, μπορείτε επίσης να ελέγξετε το NVDA απευθείας μέσω της οθόνης αφής. 
Όταν τρέχει το NVDA, όλες οι εισαγωγές μέσω αφής θα πάνε κατευθείαν στο NVDA. 
Ως εκ τούτου, ενέργειες που μπορούν να γίνουν κανονικά χωρίς το NVDA δε θα είναι εφικτές.

#### Εξερευνώντας Την Οθόνη {#toc22}

Η πιο βασική ενέργεια που μπορείτε να εκτελέσετε με την οθόνη αφής είναι να εκφωνηθεί το κουμπί ελέγχου ή το κείμενο σε οποιοδήποτε σημείο της οθόνης. 
Για να το κάνετε αυτό, τοποθετήστε ένα δάχτυλο οπουδήποτε στην οθόνη. 
Μπορείτε, επίσης, να κρατήσετε το δάχτυλό σας στην οθόνη και να το σύρετε πάνω στην οθόνη για να διαβάσετε άλλα κουμπιά ελέγχου και κείμενο πάνω στο οποίο βρίσκεται το δάχτυλό σας.

#### Χειρονομίες Αφής {#toc23}

Όταν οι εντολές του NVDA περιγραφούν αργότερα σε αυτό το εγχειρίδιο χρήσης, μπορεί να συνοδεύονται και από χειρονομία αφής που μπορεί να χρησιμοποιηθεί για να ενεργοποιηθεί αυτή η εντολή στην οθόνη αφής. 
Ακολουθούν οδηγίες για το πώς θα εκτελέσετε διάφορες χειρονομίες αφής. 

##### Αγγίγματα {#toc24}

Αγγίξτε την οθόνη γρήγορα με ένα ή περισσότερα δάχτυλα.

Το άγγιγμα της οθόνης με ένα δάχτυλο ονομάζεται απλό άγγιγμα. 
Το άγγιγμα της οθόνης με δύο δάχτυλα ταυτόχρονα, ονομάζεται άγγιγμα με δύο δάχτυλα, κ.ο.κ.

Αν το ίδιο άγγιγμα εκτελείται μια ή περισσότερες φορές, με διαδοχική γρήγορη κίνηση, το NVDA θα το θεωρήσει αυτό ως πολλαπλό άγγιγμα. 
Το άγγιγμα της οθόνης δύο φορές αποτελεί διπλό άγγιγμα. 
Το άγγιγμα της οθόνης τρεις φορές αποτελεί τριπλό άγγιγμα, κ.ο.κ. 
Φυσικά, αυτά τα πολλαπλά αγγίγματα αναγνωρίζουν πόσα δάχτυλα χρησιμοποιήθηκαν, συνεπώς είναι δυνατό να υπάρχουν χειρονομίες όπως ένα τριπλό άγγιγμα με δύο δάχτυλα, ένα απλό άγγιγμα με τέσσερα δάχτυλα, κ.λπ. 

##### Σάρωση {#toc25}

Σύρετε γρήγορα το δάχτυλό σας πάνω στην οθόνη.

Υπάρχουν τέσσερις πιθανές χειρονομίες σάρωσης, ανάλογα με την κατεύθυνση: σάρωση αριστερά, σάρωση δεξιά, σάρωση προς τα πάνω και σάρωση προς τα κάτω.

Όπως τα αγγίγματα, περισσότερα από ένα δάχτυλα μπορούν να χρησιμοποιηθούν για να εκτελεστεί η χειρονομία. 
Ως εκ τούτου, χειρονομίες όπως η σάρωση προς τα πάνω με δύο δάχτυλα και η σάρωση αριστερά με τέσσερα δάχτυλα, είναι όλες εφικτές.

#### Λειτουργίες Αφής {#toc26}

Καθώς υπάρχουν πολύ περισσότερες εντολές του NVDA σε σχέση με τις δυνατές χειρονομίες αφής, το NVDA έχει αρκετές λειτουργίες αφής τις οποίες μπορείτε να αλλάζετε και οι οποίες κάνουν διαθέσιμες συγκεκριμένες υποομάδες εντολών. 
Οι δύο λειτουργίες είναι η λειτουργία κειμένου και η λειτουργία αντικειμένου. 
Συγκεκριμένες εντολές του NVDA, που αναφέρονται σε αυτό το έγγραφο, μπορεί να αναφέρουν λειτουργία αφής μέσα σε αγκύλες, μετά τη χειρονομία αφής. 
Για παράδειγμα η σάρωση προς τα πάνω [λειτουργία κειμένου], σημαίνει ότι η εντολή θα εκτελεστεί αν σαρώσετε προς τα πάνω, αλλά μόνο όσο βρίσκεστε σε λειτουργία κειμένου. 
Εάν δίπλα στην εντολή δεν αναφέρεται συγκεκριμένη λειτουργία, θα δουλεύει σε οποιαδήποτε λειτουργία.
<!-- KC:beginInclude -->
Για να αλλάζετε λειτουργίες αφής, εκτελείται απλό άγγιγμα με τρία δάχτυλα.
<!-- KC:endInclude -->

### Λειτουργία Βοήθειας Εισαγωγής {#toc27}

Πολλές εντολές του NVDA αναφέρονται στη συνέχεια αυτού του εγχειριδίου, αλλά ένας εύκολος τρόπος να εξερευνήσετε όλες τις διαφορετικές εντολές είναι να ενεργοποιήσετε τη βοήθεια εισαγωγής.

Για να ενεργοποιήσετε τη βοήθεια εισαγωγής, πατήστε NVDA+1. 
Για να την απενεργοποιήσετε, πατήστε πάλι NVDA+1. 
Ενόσω βρίσκεστε στη βοήθεια εισαγωγής, η εκτέλεση οποιασδήποτε χειρονομίας εισαγωγής (όπως να πατήσετε ένα πλήκτρο ή να εκτελέσετε μια χειρονομία αφής) θα αναφέρει την ενέργεια και θα περιγράφει τί ακριβώς κάνει (αν κάνει). 
Οι εντολές καθ’ αυτές δε θα εκτελεστούν, ενόσω βρίσκεστε σε λειτουργία βοήθειας εισαγωγής.

### Το Μενού Του NVDA {#toc28}

Το μενού του NVDA σας επιτρέπει να ελέγξετε τις ρυθμίσεις του NVDA, να αποκτήσετε πρόσβαση στη βοήθεια, να αποθηκεύσετε/επαναφέρετε τη διαμόρφωσή σας, να τροποποιήσετε λεξικά εκφώνησης, να αποκτήσετε πρόσβαση σε πρόσθετα εργαλεία και να τερματίσετε το NVDA.

Για να εμφανίσετε το μενού του NVDA οπουδήποτε στα Windows, ενόσω εκτελείται το NVDA, πατήστε NVDA+n στο πληκτρολόγιο ή εκτελέστε διπλό άγγιγμα με δύο δάχτυλα στην οθόνη αφής. 
Μπορείτε, επίσης, να εμφανίσετε το μενού του NVDA μέσω της περιοχής συστήματος των Windows. 
Ή κάντε δεξί κλικ στο εικονίδιο του NVDA που βρίσκεται στην περιοχή συστήματος, ή πηγαίνετε στην περιοχή συστήματος πατώντας windows logo key+B. Πλοηγηθείτε με κάτω βέλος για να βρείτε το εικονίδιο του NVDA και πατήστε το πλήκτρο Applications που βρίσκεται δίπλα στο δεξί Control στα περισσότερα πληκτρολόγια. 
Όταν εμφανιστεί το μενού, μπορείτε να χρησιμοποιήσετε τα βελάκια για να πλοηγηθείτε στο μενού και το πλήκτρο Enter για να ενεργοποιήσετε κάποιο στοιχείο.

### Βασικές Εντολές Του NVDA {#toc29}

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο επιτραπέζιου υπολογιστή |Πλήκτρο φορητού υπολογιστή |Χειρονομία αφής |Περιγραφή|
|---|---|---|---|---|
|Διακοπή εκφώνησης |Control |Control |Απλό άγγιγμα με 2 δάχτυλα |Άμεση διακοπή εκφώνησης|
|Παύση εκφώνησης |Shift |Shift |Δεν υπάρχει |Άμεση παύση εκφώνησης. Ξαναπατώντας το Shift συνεχίζει εκεί που σταμάτησε (αν ο συνθέτης φωνής υποστηρίζει την παύση).|
|Μενού NVDA |NVDA+n |NVDA+n |Διπλό άγγιγμα με 2 δάχτυλα |Εμφανίζει το μενού του NVDA που σας επιτρέπει να έχετε πρόσβαση σε προτιμήσεις, εργαλεία, βοήθεια, κ.λπ.|
|Εναλλαγή Λειτουργίας Εκφώνησης |NVDA+s |NVDA+s |Δεν υπάρχει |Εναλλάσσει τη λειτουργία εκφώνησης μεταξύ εκφώνησης, ήχων μπιπ και χωρίς εκφώνηση.|
|Εναλλαγή Λειτουργίας Βοήθειας Εισαγωγής |NVDA+1 |NVDA+1 |Δεν υπάρχει |Με το πάτημα οποιουδήποτε πλήκτρου (ή πλήκτρων) σε αυτή τη λειτουργία, αναφέρεται το πλήκτρο (ή τα πλήκτρα) και η περιγραφή οποιασδήποτε εντολής του NVDA που αντιστοιχεί σε αυτό.|
|Έξοδος Από Το NVDA |NVDA+q |NVDA+q |Δεν υπάρχει |Τερματίζει το NVDA|
|Διέλευση Επόμενης Εντολής |NVDA+f2 |NVDA+f2 |Δεν υπάρχει |Το NVDA επιτρέπει τη διέλευση της επόμενης εντολής κατ’ ευθείαν στην τρέχουσα εφαρμογή, ακόμα κι αν χρησιμοποιείται συνήθως ως εντολή του NVDA.|
|Εναλλαγή Λειτουργίας Ύπνου Εφαρμογής |NVDA+shift+s |NVDA+shift+z |Δεν υπάρχει |Η λειτουργία ύπνου απενεργοποιεί όλες τις εντολές του NVDA, καθώς και την εκφώνηση και την εξαγωγή braille για την τρέχουσα εφαρμογή. Αυτό είναι πολύ χρήσιμο για εφαρμογές που παρέχουν οι ίδιες δυνατότητα εκφώνησης των στοιχείων της οθόνης. Εκτελέστε ξανά την εντολή για να απενεργοποιήσετε τη λειτουργία εκφώνησης που παρέχει η δεδομένη εφαρμογή.|

<!-- KC:endInclude -->

### Αναφορά Πληροφοριών Συστήματος {#toc30}

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Αναφορά ημερομηνίας/ώρας |NVDA+F12 |Πατώντας μια φορά αναφέρεται η τρέχουσα ώρα. Πατώντας δύο φορές αναφέρεται η ημερομηνία.|
|Αναφορά Κατάστασης Μπαταρίας. |NVDA+shift+b |Αναφέρει την κατάσταση της μπαταρίας, δηλ. αν χρησιμοποιείται το εναλλασόμενο ρεύμα ή το ποσοστό της μπαταρίας που έχει φορτιστεί.|
|Αναφέρει το κείμενο στο πρόχειρο |NVDA+c |Αναφέρει το κείμενο στο πρόχειρο, αν υπάρχει.|

## Πλοήγηση με το NVDA {#toc31}

Το NVDA σας επιτρέπει να εξερευνήσετε και να πλοηγηθείτε στο σύστημα με διάφορους τρόπους, συμπεριλαμβανομένης της κανονικής αλληλεπίδρασης και της εξέτασης.

### Αντικείμενα {#Objects}

Το λειτουργικό σύστημα και κάθε εφαρμογή αποτελούνται από αρκετά αντικείμενα.
Ένα αντικείμενο είναι ένα διακριτό στοιχείο όπως ένα τμήμα κειμένου, ένα κουμπί, ένα κουτί επιλογής, ένα ποτενσιόμετρο, μία λίστα ή ένα επεξεργάσιμο πεδίο κειμένου.

### Πλοήγηση με την Εστίαση Συστήματος {#SystemFocus}

Η Εστίαση Συστήματος, γνωστή επίσης και απλά σαν εστίαση, είναι το [αντικείμενο](#Objects) που δέχεται τις εντολές των πλήκτρων που πατιούνται στο πληκτρολόγιο.
Για παράδειγμα, αν πληκτρολογείτε μέσα σε ένα επεξεργάσιμο πεδίο κειμένου, το πεδίο αυτό έχει την εστίαση.

Ο πιο συνηθισμένος τρόπος πλοήγησης στα Windows με το NVDA είναι μέσω της απλής μετακίνησης της Εστίασης Συστήματος χρησιμοποιώντας τις τυποποιημένες εντολές πληκτρολογίου των Windows, όπως όταν πατάμε TAB και SHIFT+TAB για να μετακινηθούμε στο επόμενο και το προηγούμενο στοιχείο ελέγχου, όταν πατάμε ALT για να ενεργοποιηθεί η Λωρίδα Μενού και κατόπιν με τα βελάκια πλοηγούμαστε στο μενού, και πατώντας ALT+TAB για την εναλλαγή των εφαρμογών που εκτελούνται.
Κάνοντας αυτά, το NVDA αναφέρει πληροφορίες σχετικά με το αντικείμενο που έχει την εστίαση, όπως το όνομα του, ο τύπος του, η τιμή του, η κατάσταση του, η περιγραφή του, η συντόμευση πληκτρολογίου και πληροφορίες σχετικές με τη θέση του.

Υπάρχουν κάποιες εντολές πλήκτρων που είναι χρήσιμες όταν κινείστε με την Εστίαση Συστήματος:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο επιτραπέζιου υπολογιστή |Πλήκτρο φορητού υπολογιστή |Περιγραφή|
|---|---|---|---|
|Αναφορά τρέχουσας εστίασης |NVDA+tab |NVDA+tab |Αναφέρει το τρέχον αντικείμενο ή στοιχείο ελέγχου που έχει την Εστίαση Συστήματος. Πατώντας δύο φορές, συλαβίζει την πληροφορία.|
|Αναφορά τίτλου |NVDA+t |NVDA+t |Αναφέρει τον τίτλο του ενεργού παραθύρου. Πατώντας δύο φορές, συλαβίζει την πληροφορία. Πατώντας τρεις φορές, την αντιγράφει στο πρόχειρο.|
|Ανάγνωση τρέχοντος παραθύρου |NVDA+b |NVDA+b |Διαβάζει όλα τα στοιχεία ελέγχου στο ενεργό παράθυρο (χρήσιμο για διαλόγους).|
|Αναφορά Λωρίδας Κατάστασης |NVDA+end |nvda+shift+end |Αναφέρει τη Λωρίδα Κατάστασης, αν το NVDA βρει κάποια. Επιπλέον, μετακινεί το Αντικείμενο Πλοήγησης σε αυτή τη τοποθεσία.|

<!-- KC:endInclude -->

### Πλοήγηση με τον Κέρσορα Συστήματος {#SystemCaret}

Όταν ένα [αντικείμενο](#Objects) που επιτρέπει την πλοήγηση και/ή την επεξεργασία κειμένου είναι [εστιασμένο](#SystemFocus), μπορείτε να μετακινηθείτε μέσα στο κείμενο χρησιμοποιώντας τον Κέρσορα Συστήματος, γνωστό επίσης και σαν κέρσορας επεξεργασίας ή κέρσορας.

Όταν η εστίαση είναι σε ένα αντικείμενο που έχει τον Κέρσορα Συστήματος, μπορείτε να χρησιμοποιείτε τα πλήκτρα με τα βελάκια, page up, page down, home, end κλπ. για να μετακινείστε μέσα στο κείμενο.
Μπορείτε επίσης να αλλάξετε το κείμενο αν το στοιχείο ελέγχου υποστηρίζει λειτουργία επεξεργασίας κειμένου.
Κατά τη μετακίνηση σας με τον κέρσορα, το NVDA θα σας αναφέρει ανά χαρακτήρα, λέξη και γραμμή, και επίσης θα σας αναφέρει όταν επιλέγετε ή απο-επιλέγετε κείμενο.

Το NVDA παρέχει τις ακόλουθες εντολές πλήκτρων που σχετίζονται με τον Κέρσορα Συστήματος:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο επιτραπέζιου υπολογιστή |Πλήκτρο φορητού υπολογιστή |Περιγραφή|
|---|---|---|---|
|Εκφώνηση όλων |NVDA+κάτωΒέλος |nvda+a |Ξεκινά να διαβάζει από την τρέχουσα θέση του κέρσορα, μετακινώντας τον καθώς διαβάζει.|
|Εκφώνηση τρέχουσας γραμμής |NVDA+πάνωΒέλος |nvda+L |Διαβάζει τη γραμμή στην οποία βρίσκεται ο κέρσορας. Πατώντας δύο φορές, θα προφέρει τη γραμμή ανά χαρακτήρα.|
|Εκφώνηση τρέχουσας επιλογής κειμένου |NVDA+Shift+πάνωΒέλος |nvda+shift+s |Διαβάζει οποιοδήποτε επιλεγμένο κείμενο.|
|Επόμενη πρόταση |alt+κάτωβέλος |alt+κάτωβέλος |Μετακινεί τον κέρσορα στην επόμενη πρόταση και την διαβάζει. (υποστηρίζεται μόνο στο microsoft word)|
|Προηγούμενη πρόταση |alt+πάνωβέλος |alt+πάνωβέλος |Μετακινεί τον κέρσορα στην προηγούμενη πρόταση και την διαβάζει. (υποστηρίζεται μόνο στο microsoft word)|

Όταν ο κέρσορας βρίσκεται μέσα σε πίνακα, οι ακόλουθες εντολές πλήκτρων είναι επίσης διαθέσιμες:

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Μετακίνηση στην προηγούμενη στήλη |control+alt+αριστερόΒέλος |Μετακινεί τον κέρσορα στη προηγούμενη στήλη (κολόνα) παραμένοντας στην ίδια γραμμή.|
|Μετακίνηση στην επόμενη στήλη |control+alt+δεξίΒέλος |Μετακινεί τον κέρσορα στην επόμενη στήλη (κολόνα) παραμένοντας στην ίδια γραμμή.|
|Μετακίνηση στην προηγούμενη γραμμή |control+alt+πάνωΒέλος |Μετακινεί τον κέρσορα στην προηγούμενη γραμμή, παραμένοντας στην ίδια στήλη.|
|Μετακίνηση στην επόμενη γραμμή |control+alt+κάτωΒέλος |Μετακινεί στον κέρσορα στην επόμενη γραμμή, παραμένοντας στην ίδια στήλη.|

<!-- KC:endInclude -->

### Πλοήγηση Αντικειμένου {#toc35}

Τις περισσότερες φορές, θα δουλεύετε με τις εφαρμογές χρησιμοποιώντας εντολές που μετακινούν την [εστίαση](#SystemFocus) και τον [κέρσορα](#SystemCaret).
Ωστόσο, μερικές φορές, μπορεί να θελήσετε να εξερευνήσετε την τρέχουσα εφαρμογή ή το Λειτουργικό Σύστημα χωρίς να μετακινήσετε την εστίαση ή τον κέρσορα.
Μπορεί επίσης να θελήσετε να εργαστείτε με [αντικείμενα](#Objects) που δεν μπορούν να προσπελαθούν με τον συνήθη τρόπο χρήσης του πληκτρολογίου.
Σε αυτές τις περιπτώσεις, μπορείτε να χρησιμοποιήσετε την πλοήγηση αντικειμένου.

Η πλοήγηση αντικειμένου σας επιτρέπει να μετακινείστε ανάμεσα σε ανεξάρτητα [αντικείμενα](#Objects) και να λαμβάνετε πληροφορίες για αυτά.
Όταν μετακινείστε σε ένα αντικείμενο, το NVDA θα σας δώσει μία αναφορά για αυτό με τον ίδιο τρόπο που αναφέρει την εστίαση συστήματος.
Για να κάνετε ωστόσο εξέταση όλου του κειμένου που εμφανίζεται στην οθόνη, μπορείτε εναλλακτικά να χρησιμοποιήσετε την [ εξέταση οθόνης#ScreenReview].

Τα αντικείμενα οργανώνονται ιεραρχικά, ώστε να μην χρειάζεται να μετακινείτε πίσω και μπροστά μεταξύ κάθε διακριτού αντικειμένου στο σύστημα.
Αυτό σημαίνει ότι κάποια αντικείμενα περιέχουν άλλα αντικείμενα, οπότε και πρέπει να μετακινηθείτε εντός τους για να προσπελάστε τα αντικείμενα που περιέχουν.
Για παράδειγμα, μία λίστα περιέχει τα στοιχεία λίστας, οπότε πρέπει να μετακινηθείτε εντός της λίστας για να προσπελάσετε τα στοιχεία της.
Αν έχετε μετακινηθεί μέσα σε ένα στοιχείο της λίστας, πηγαίνοντας μπροστά και πίσω θα μεταφερθείτε σε άλλα στοιχεία της ίδιας λίστας.
Αν μετακινηθείτε στο περιέχον αντικείμενο ενός στοιχείου της λίστας, θα μεταφερθείτε πίσω στη λίστα.
Μπορείτε τότε να μετακινηθείτε έξω από το τέλος της λίστας αν επιθυμείτε να προσπελάσετε άλλα αντικείμενα.
Ομοίως, μία λωρίδα εργαλείων περιέχει στοιχεία ελέγχου, οπότε πρέπει να μετακινηθείτε εντός της λωρίδας για να προσπελάσετε τα στοιχεία ελέγχου της.

Το τρέχον αντικείμενο που εξετάζεται ονομάζεται Αντικείμενο Πλοήγησης.
Μόλις πλοηγηθείτε σε ένα αντικείμενο, μπορείτε να το εξετάσετε χρησιμοποιώντας τις [εντολές εξέτασης κειμένου](#ReviewingText).
Εξ ορισμού, το Αντικείμενο Πλοήγησης μετακινείται μαζί με την Εστίαση Συστήματος, αν και αυτή η συμπεριφορά μπορεί να ενεργοποιηθεί και να απενεργοποιηθεί.

Σημειώστε ότι εξ ορισμού το braille ακολουθεί την [εστίαση](#SystemFocus) και τον [κέρσορα](#SystemCaret), αντί για την πλοήγηση αντικειμένου και εξέταση κειμένου.
Αν θέλετε εναλλακτικά να ακολουθεί την πλοήγηση αντικειμένου και την εξέταση κειμένου, χρειάζεται να [διαμορφώσετε το braille ώστε να προσδεθεί](#BrailleTether) στην εξέταση.

Για να πλοηγηθείτε ανά αντικείμενο, χρησιμοποιείστε τα ακόλουθα πλήκτρα:

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο επιτραπέζιου Υπολογιστή |Πλήκτρο φορητού Υπολογιστή |χειρονομία αφής |Περιγραφή|
|---|---|---|---|---|
|Αναφορά τρέχοντος αντικειμένου |NVDA+αριθμητικό5 |nvda+shift+o |Μη διαθέσημο |Αναφέρει το τρέχον Αντικείμενο Πλοήγησης. Πατώντας δύο φορές συλαβίζει την πληροφορία ανά χαρακτήρα, και πατώντας τρεις φορές αντιγράφει το όνομα και την τιμή του αντικειμένου στο πρόχειρο.|
|Μετακίνηση στο περιέχον αντικείμενο |NVDA+αριθμητικό8 |NVDA+shift+πάνωβέλος |σάρωση προς τα πάνω (Λειτουργία αντικειμένου) |Μετακινείται στο αντικείμενο που περιέχει το τρέχον Αντικείμενο Πλοήγησης.|
|Μετακίνηση στο προηγούμενο αντικείμενο |NVDA+αριθμητικό4 |NVDA+shift+αριστερόβέλος |σάρωση αριστερά (λειτουργία αντικειμένου) |Μετακινείται στο αντικείμενο ακριβώς πριν το τρέχον Αντικείμενο Πλοήγησης.|
|Μετακίνηση στο επόμενο αντικείμενο |NVDA+αριθμητικό6 |nvda+shift+δεξίβέλος |σάρωση δεξιά (λειτουργία αντικειμένου) |Μετακινείται στο αντικείμενο ακριβώς μετά το τρέχον Αντικείμενο Πλοήγησης.|
|Μετακίνηση στο πρώτο περιεχόμενο αντικείμενο |NVDA+αριθμητικό2 |NVDA+shift+κάτωβέλος |σάρωση προς τα κάτω (Λειτουργία εξέτασης) |Μετακινείται στο πρώτο αντικείμενο που περιέχεται από το τρέχον Αντικείμενο Πλοήγησης.|
|Μετακίνηση στο αντικείμενο εστίασης |NVDA+αριθμητικόΜείον |NVDA+backspace |μη διαθέσιμο |Μετακινείται στο αντικείμενο που έχει την Εστίαση Συστήματος, και επιπλέον θέτει τον Δρομέα Εξέτασης στη θέση του Κέρσορα Συστήματος, αν είναι εμφανής.|
|Ενεργοποίηση του τρέχοντος αντικειμένου πλοήγησης |NVDA+αριθμητικόEnter |NVDA+enter |διπλό άγγιγμα |Ενεργοποιεί το τρέχον Αντικείμενο Πλοήγησης (όμοια με το κλικ του ποντικιού ή το πάτημα του πλήκτρου κενού διαστήματος (spacebar) όταν έχει την Εστίαση Συστήματος).|
|Μετακίνηση της Εστίασης Συστήματος ή του κέρσορα στην τρέχουσα θέση εξέτασης |NVDA+shift+αριθμητικόΜείον |NVDA+shift+backspace |μη διαθέσιμο |Πατώντας μία φορά μετακινεί την Εστίαση Συστήματος στο τρέχον Αντικείμενο Πλοήγησης. Πατώντας δύο φορές μετακινεί τον Κέρσορα Συστήματος στη θέση του Δρομέα Εξέτασης.|
|Αναφορά διαστάσεων αντικειμένου πλοήγησης |NVDA+αριθμητικόDelete |NVDA+delete |μη διαθέσιμο |Αναφέρει τις διαστάσεις του τρέχοντος αντικειμένου πλοήγησης στην οθόνη επί τοις εκατό (συμπεριλαμβανομένης της απόστασης από τα αριστερά και την κορυφή της οθόνης, το πλάτος και το ύψος).|

<!-- KC:endInclude -->

Σημείωση: για να λειτουργήσουν σωστά τα πλήκτρα του αριθμητικού πληκτρολογίου απαιτείται το πλήκτρο Κλείδωμα Αριθμητικού Πληκτρολογίου (Num Lock) να είναι απενεργοποιημένο.

### Εξέταση Κειμένου {#ReviewingText}

Το NVDA σας επιτρέπει να διαβάζετε το περιεχόμενο του τρέχοντος [αντικειμένου πλοήγησης](#ObjectNavigation) (συμπεριλαμβανομένης της [ εξέτασης οθόνης#ScreenReview]) ανά χαρακτήρα, λέξη ή γραμμή.
Αυτό είναι χρήσιμο κυρίως σε περιοχές (συμπεριλαμβανομένης της γραμμής εντολών των Windows) όπου δεν υπάρχει [Κέρσορας Συστήματος](#SystemCaret).
Για παράδειγμα, μπορείτε να το χρησιμοποιήσετε για να εξετάσετε το κείμενο ενός μεγάλου πληροφοριακού μηνύματος σε ένα παράθυρο διαλόγου.

Όταν μετακινείστε με το Δρομέα Εξέτασης, ο Κέρσορας Συστήματος δεν τον ακολουθεί, οπότε μπορείτε να εξετάσετε το κείμενο χωρίς να χάσετε τη θέση επεξεργασίας που βρίσκεστε.
Ωστόσο, εξ ορισμού, όταν ο Κέρσορας Συστήματος μετακινείτε, ο Δρομέας Εξέτασης τον ακολουθεί.
Αυτό όμως μπορεί να ενεργοποιηθεί ή να απενεργοποιηθεί.

Σημειώστε ότι εξ ορισμού το braille ακολουθεί την [εστίαση](#SystemFocus) και τον [κέρσορα](#SystemCaret), αντί για την πλοήγηση αντικειμένου και την εξέταση κειμένου.
Αν θέλετε εναλλακτικά να ακολουθεί την πλοήγηση αντικειμένου και την επανεξέταση κειμένου, χρειάζεται να [διαμορφώσετε το braille ώστε να προσδεθεί](#BrailleTether) στην επανεξέταση.

Οι ακόλουθες εντολές πληκτρολογίου είναι διαθέσιμες για την επανεξέταση κειμένου:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο Επιτραπέζιου Υπολογιστή |Πλήκτρο Φορητού Υπολογιστή |χειρονομία αφής |Περιγραφή|
|---|---|---|---|---|
|Μετακίνηση στην ανώτατη γραμμή εξέτασης |shift+αριθμητικό7 |NVDA+control+home |μη διαθέσιμο |Μετακινεί τον Δρομέα Εξέτασης στην ανώτατη γραμμή του κειμένου.|
|Μετακίνηση στην προηγούμενη γραμμή εξέτασης |αριθμητικό7 |NVDA+πάνωβέλος |σάρωση προς τα πάνω (Λειτουργία κειμένου) |Μετακινεί τον Δρομέα Εξέτασης στην προηγούμενη γραμμή του κειμένου.|
|Αναφορά τρέχουσας γραμμής εξέτασης |αριθμητικό8 |NVDA+shift+τελία |μη διαθέσιμο |Αναγγέλλει την τρέχουσα γραμμή κειμένου στην οποία βρίσκεται ο Δρομέας Εξέτασης. Πατώντας δύο φορές, προφέρει τη γραμμή ανά χαρακτήρα. Πατώντας τρεις φορές, προφέρει τη γραμμή ανά χαρακτήρα χρησιμοποιώντας τις περιγραφές των χαρακτήρων.|
|Μετακίνηση στην επόμενη γραμμή εξέτασης |αριθμητικό9 |NVDA+κάτωβέλος |σάρωση προς τα κάτω (Λειτουργία κειμένου) |Μετακινεί τον Δρομέα Εξέτασης στην επόμενη γραμμή του κειμένου.|
|Μετακίνηση στην κατώτατη γραμμή εξέτασης |shift+αριθμητικό9 |NVDA+control+end |μη διαθέσιμο |Μετακινεί τον Δρομέα Εξέτασης στην κατώτατη γραμμή του κειμένου.|
|Μετακίνηση στην προηγούμενη λέξη εξέτασης |αριθμητικό4 |NVDA+control+αριστερό βέλος |σάρωση αριστερά με δύο δάκτυλα (Λειτουργία κειμένου) |Μετακινεί τον Δρομέα Εξέτασης στην προηγούμενη λέξη του κειμένου.|
|Αναφορά τρέχουσας λέξης εξέτασης |αριθμητικό5 |NVDA+control+τελία |μη διαθέσιμο |Αναγγέλλει την τρέχουσα λέξη του κειμένου στην οποία βρίσκεται ο Δρομέας Εξέτασης. Πατώντας δύο φορές, προφέρει τη λέξη ανά χαρακτήρα. Πατώντας τρεις φορές, προφέρει τη λέξη ανά χαρακτήρα χρησιμοποιώντας τις περιγραφές των χαρακτήρων.|
|Μετακίνηση στην επόμενη λέξη της εξέτασης |αριθμητικό6 |NVDA+control+δεξίβέλος |σάρωση δεξιά με 2 δάκτυλα (Λειτουργία κειμένου) |Μετακινεί τον Δρομέα Εξέτασης στην επόμενη λέξη του κειμένου.|
|Μετακίνηση στην αρχή της γραμμής εξέτασης |shift+αριθμητικό1 |NVDA+home |μη διαθέσιμο |Μετακινεί τον Δρομέα Εξέτασης στην αρχή της τρέχουσας γραμμής του κειμένου.|
|Μετακίνηση στον προηγούμενο χαρακτήρα εξέτασης |αριθμητικό1 |NVDA+αριστερόβέλος |σάρωση αριστερά (Λειτουργία κειμένου) |Μετακινεί τον Δρομέα Εξέτασης στον προηγούμενο χαρακτήρα της τρέχουσας γραμμής του κειμένου.|
|Αναφορά του τρέχοντος χαρακτήρα εξέτασης |αριθμητικό2 |NVDA+τελία |μη διαθέσιμο |Αναγγέλλει τον τρέχοντα χαρακτήρα στη γραμμή του κειμένου στην οποία βρίσκεται ο Δρομέας Εξέτασης. Πατώντας δύο φορές, αναγγέλλει μία περιγραφή ή ένα παράδειγμα αυτού του χαρακτήρα. Πατώντας τρεις φορές, αναγγέλλει την αριθμητική τιμή του χαρακτήρα στο δεκαδικό και στο δεκαεξαδικό σύστημα.|
|Μετακίνηση στον επόμενο χαρακτήρα εξέτασης |αριθμητικό3 |NVDA+δεξίβέλος |σάρωση δεξιά (Λειτουργία κειμένου) |Μετακινεί τον Δρομέα Εξέτασης στον επόμενο χαρακτήρα της τρέχουσας γραμμής του κειμένου.|
|Μετακίνηση στο τέλος της γραμμής εξέτασης |shift+αριθμητικό3 |NVDA+end |μη διαθέσιμο |Μετακινεί τον Δρομέα Εξέτασης στο τέλος της τρέχουσας γραμμής του κειμένου.|
|Εκφώνηση όλων με εξέταση |αριθμητικόΣυν |NVDA+shift+a |σάρωση προς τα κάτω με 3 δάκτυλα (Λειτουργία κειμένου) |Διαβάζει από την τρέχουσα θέση του Δρομέα Εξέτασης και τον μετακινεί καθώς διαβάζει.|
|Αντιγραφή από τον Δρομέα Εξέτασης |NVDA+f9 |NVDA+f9 |μη διαθέσιμο |Ξεκινάει να αντιγράφει κείμενο από την τρέχουσα θέση του Δρομέα Εξέτασης. Ουσιαστικά, η αντιγραφή δεν πραγματοποιείται μέχρι εσείς να πείτε στο NVDA μέχρι που θα αντιγράψει.|
|Αντιγραφή μέχρι τον Δρομέα Εξέτασης |NVDA+f10 |NVDA+f10 |μη διαθέσιμο |Αντιγράφει από τη θέση του Δρομέα Εξέτασης που έχει οριστεί με την Αντιγραφή από τον Δρομέα Εξέτασης, στην τρέχουσα θέση του Δρομέα Εξέτασης. Αφού πατήσετε αυτό το πλήκτρο, το κείμενο θα αντιγραφεί στο πρόχειρο των Windows.|
|Αναφορά μορφοποίησης κειμένου |NVDA+f |NVDA+f |μη διαθέσιμο |Αναφέρει τη μορφοποίηση του κειμένου όπου βρίσκεται ο Δρομέας Εξέτασης|

<!-- KC:endInclude -->

Σημείωση: για να λειτουργήσουν σωστά τα πλήκτρα του αριθμητικού πληκτρολογίου απαιτείται το πλήκτρο Κλείδωμα Αριθμητικού Πληκτρολογίου (Num Lock) να είναι απενεργοποιημένο.

Για να βοηθηθείτε να θυμάστε αυτές τις εντολές, όταν χρησιμοποιήτε επιτραπέζιο υπολογιστή, σημειώστε ότι οι βασικές εντολές της επανεξέτασης κειμένου είναι οργανωμένες σε ένα πλέγμα τρία επί τρία, όπου από επάνω προς τα κάτω είναι η γραμμή, η λέξη και ο χαρακτήρας, και από αριστερά προς τα δεξιά είναι το προηγούμενο, το τρέχον και το επόμενο.
Η διάταξη αυτή παρουσιάζεται ως εξής:

|Προηγούμενη γραμμή |Τρέχουσα γραμμή |Επόμενη γραμμή|
|Προηγούμενη λέξη |Τρέχουσα λέξη |Επόμενη λέξη|
|Προηγούμενος χαρακτήρας |Τρέχων χαρακτήρας |Επόμενος χαρακτήρας|

### Μέθοδοι εξέτασης περιεχομένου {#ReviewModes}

Οι εντολές [εξέτασης κειμένου](#ReviewingText) μπορούν να εξετάσουν το περιεχόμενο του τρέχοντος αντικειμένου, του τρέχοντος εγγράφου ή και ολόκληρης της οθόνης, ανάλογα με την μέθοδο εξέτασης περιεχομένου που έχουμε επιλέξει.
Οι μέθοδοι εξέτασης αντικαθιστούν την επίπεδη εξέταση που υπήρχε σε προηγούμενες εκδόσεις.

Οι πιο κάτω εντολές αλλάζουν την τρέχουσα μέθοδο εξέτασης περιεχομένου:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο επιτραπέζιου Υπολογιστή |Πλήκτρο φορητού Υπολογιστή |χειρονομία αφής |Περιγραφή|
|---|---|---|---|---|
|Μετάβαση στην επόμενη μέθοδο εξέτασης περιεχομένου |NVDA+αριθμητικό7 |NVDA+pageUp |σάρωση προς τα πάνω με δύο δάκτυλα |Μεταβαίνεται στην επόμενη διαθέσιμη μέθοδο εξέτασης περιεχομένου|
|Μετάβαση στην προηγούμενη μέθοδο εξέτασης περιεχομένου |nvda+αριθμιτικό1 |nvda+page down |σάρωση προς τα κάτω με δύο δάκτυλα |Μεταβαίνετε στην προηγούμενη μέθοδο εξέτασης περιεχομένου|

<!-- KC:endInclude -->

#### Εξέταση αντικειμένου {#ObjectReview}

Όταν βρίσκεστε στην εξέταση αντικειμένου, μπορείτε να εξετάσετε μόνο το [αντικείμενο](#ObjectNavigation) στο οποίο εστιάζετε την δεδομένη στιγμή. Για αντικείμενα όπως πλαίσια επεξεργασίας κειμένου (Edid fields), η μέθοδος αυτή θα εξετάσει το περιεχόμενο του κειμένου.
Για οποιαδήποτε άλλα αντικείμενα, η μέθοδος αυτή θα σας δώσει το όνομα ή την αξία του εν λόγο αντικειμένου.

#### Εξέταση εγγράφου {#DocumentReview}

Όταν το [Τρέχον αντικείμενο](#ObjectNavigation) βρήσκεται σε ένα πολύπλοκο κείμενο (Για παράδειγμα ιστοσελίδα), τότε είναι δυνατό να μεταβούμε στην μέθοδο εξέτασης εγγράφου.
Η μέθοδος εξέτασης εγγράφου σας επιτρέπει να εξετάσετε ολόκληρο το περιεχόμενο ενός εγγράφου.

Όταν μεταβαίνετε από την εξέταση αντικειμένου στην εξέταση εγγράφου, ο δρομέας εξέτασης μεταβαίνει αυτόματα στην θέση που βρίσκεται το τρέχον αντικείμενο.
Όταν  μετακινήστε στο κείμενο με τις εντολές εξέτασης, το τρέχον αντικείμενο μεταβαίνει αυτόματα στην θέση που βρήσκεστε.

#### Εξέταση οθόνης {#ScreenReview}

Η μέθοδος εξέτασης της οθόνης, σας επιτρέπει να εξετάσετε το κείμενο της οθόνης όπως φαίνεται οπτικά σε κάποια εφαρμογή που τρέχετε. 
Η δυνατότητα αυτή μοιάζει με τους προσομοιωτές ποντικιού (Mouse cursors) που ενδέχεται να συναντήσουμε σε άλλους αναγνώστες οθόνης.

Όταν μεταβαίνουμε στην λειτουργία εξέτασης οθόνης, ο δρομέας εξέτασης τοποθετείται στην θέση που βρίσκεται το τρέχον [αντικείμενο πλοήγησης](#ObjectNavigation)
Όταν μετακινούμαστε στην οθόνη με τις εντολές εξέτασης, το αντικείμενο πλοήγησης αναβαθμίζεται αυτόματα στο αντικείμενο που βρίσκεται ο δρομέας εξέτασης.

Σημειώστε πως σε κάποιες καινούριες εφαρμογές, το nvda ενδέχεται να μην μπορεί να δει μέρος ή ολόκληρο το κείμενο που εμφανίζεται στην οθόνη, λόγο κάποιων καινούριων τεχνολογιών απεικόνισης που δεν είναι δυνατό να υποστηριχτούν στο παρόν στάδιο.

### Πλοήγηση με το Ποντίκι {#toc41}

Όταν κινείτε το Ποντίκι, το NVDA αναφέρει εξ ορισμού το κείμενο που βρίσκεται ακριβώς κάτω από τον δείκτη του ποντικιού, όπως ο δείκτης μετακινείται πάνω του.
Όπου υποστηρίζεται, το NVDA θα διαβάσει την περιβάλλουσα παράγραφο κειμένου, αν και μερικά στοιχεία ελέγχου μπορούν να διαβαστούν μόνο ανά γραμμή.

Το NVDA μπορεί να διαμορφωθεί ώστε να αναγγέλλει επίσης τον τύπο του [αντικειμένου](#Objects) κάτω από το ποντίκι όπως κινείται (π.χ. λίστα, κουμπί κλπ.).
Αυτό μπορεί να είναι χρήσιμο για ολικά τυφλούς χρήστες, καθώς μερικές φορές μόνο το κείμενο δεν είναι αρκετό.

Το NVDA παρέχει στους χρήστες έναν τρόπο για να καταλαβαίνουν που βρίσκεται το ποντίκι σε σχέση με τις διαστάσεις της οθόνης, παίζοντας κατάλληλους ήχους μπιπ που αντιστοιχούν στις τρέχουσες συντεταγμένες του ποντικιού.
Όσο πιο πάνω είναι το ποντίκι στην οθόνη, τόσο πιο ψηλός είναι ο τόνος των μπιπ.
Όσο πιο αριστερά ή δεξιά είναι το ποντίκι στην οθόνη, τόσο αριστερά ή δεξιά θα είναι ο ήχος που παίζεται από τα ηχεία (υποθέτοντας ότι ο χρήστης έχει στερεοφωνικά ηχεία ή ακουστικά).

Αυτά τα επιπρόσθετα χαρακτηριστικά του ποντικιού δεν είναι ενεργοποιημένα εξ ορισμού στο NVDA.
Αν επιθυμείτε να εκμεταλλευτείτε τις δυνατότητες τους, μπορείτε να τα διαμορφώσετε από τις [Ρυθμίσεις Ποντικιού](#MouseSettings) που βρίσκονται στο μενού Προτιμήσεων του NVDA.

Αν και απαιτείται ένα πραγματικό ποντίκι ή μία ιχνόσφαιρα για να πλοηγηθείτε με το ποντίκι, το NVDA έχει μερικές εντολές πλήκτρων που σχετίζονται με το ποντίκι:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο επιτραπέζιου Υπολογιστή |Πλήκτρο φορητού Υπολογιστή |Περιγραφή|
|---|---|---|---|
|Κλικ αριστερού πλήκτρου ποντικιού |αριθμητικόΔιαίρεση |NVDA+[ |Κλικάρει μία φορά το αριστερό πλήκτρο ποντικιού. Το γνωστό διπλό κλικ μπορεί να επιτευχθεί με το γρήγορο διαδοχικό διπλό πάτημα αυτού του πλήκτρου.|
|Κλείδωμα αριστερού πλήκτου ποντικιού |shift+αριθμητικόΔιαίρεση |NVDA+control+[ |Κλειδώνει κάτω το αριστερό πλήκτρο ποντικιού. Πατήστε ξανά για να το ελευθερώσετε. Για να σύρετε το ποντίκι, πατήστε αυτό το πλήκτρο για να κλειδώσετε κάτω το αριστερό πλήκτρο ποντικιού και κατόπιν μετακινείστε το ποντίκι είτε φυσικά είτε χρησιμοποιώντας μία από τις άλλες εντολές δρομολόγησης του ποντικιού.|
|Κλικ δεξιού πλήκτρου ποντικιού |αριθμητικόΕπί |NVDA+] |Κλικάρει μία φορά το δεξί πλήκτρο ποντικιού.|
|Κλείδωμα δεξιού πλήκτου ποντικιού |shift+αριθμητικόΕπί |NVDA+control+] |Κλειδώνει κάτω το δεξί πλήκτρο ποντικιού. Πατήστε ξανά για να το ελευθερώσετε. Για να σύρετε το ποντίκι, πατήστε αυτό το πλήκτρο για να κλειδώσετε κάτω το δεξί πλήκτρο ποντικιού και κατόπιν μετακινείστε το ποντίκι είτε φυσικά είτε χρησιμοποιώντας μία από τις άλλες εντολές δρομολόγησης του ποντικιού.|
|Μετακίνηση ποντικιού στο τρέχον Αντικείμενο Πλοήγησης |NVDA+αριθμητικόΔιαίρεση |NVDA+shift+m |Μετακινεί το ποντίκι στη θέση του τρέχοντος Αντικειμένου Πλοήγησης και του Δρομέα Εξέτασης.|
|Πλοήγηση στο αντικείμενο κάτω από το ποντίκι |NVDA+αριθμητικόΕπί |NVDA+shift+n |Θέτει το Αντικείμενο Πλοήγησης στο αντικείμενο που βρίσκεται στη θέση του ποντικιού.|

<!-- KC:endInclude -->

## Λειτουργία Περιήγησης {#toc42}

Η περιήγηση με το NVDA πολύπλοκων εγγράφων που είναι μόνο για ανάγνωση, όπως οι ιστοσελίδες, γίνεται με τη χρήση της Λειτουργίας Περιήγησης.
Αυτή περιλαμβάνει έγγραφα στα Mozilla Firefox, Microsoft Internet Explorer, Mozilla Thunderbird, μηνύματα σε μορφή html στο microsoft outlook, Google Chrome, Adobe Reader και Adobe Flash.
Η Λειτουργία Περιήγησης μπορεί επίσης να είναι διαθέσιμη κατ επιλογήν και για έγγραφα στο microsoft word.

Στη Λειτουργία Περιήγησης, το περιεχόμενο του εγγράφου γίνεται διαθέσιμο σε μία επίπεδη αναπαράσταση στην οποία μπορείτε να πλοηγηθείτε με τα βελάκια, όπως σε ένα κανονικό έγγραφο κειμένου.
Όλες οι εντολές πλήκτρων του [Κέρσορα Συστήματος](#SystemCaret) του NVDA δουλεύουν σε αυτή τη λειτουργία. Για παράδειγμα, εκφώνηση όλου, αναφορά μορφοποίησης, εντολές πλοήγησης πίνακα κλπ.
Πληροφορίες όπως αν το κείμενο είναι σύνδεσμος, επικεφαλίδα κλπ. αναφέρονται μαζί με το κείμενο όπως κινείστε.

Μερικές φορές, θα χρειαστεί να αλληλεπιδράσετε απευθείας με στοιχεία ελέγχου αυτών των εγγράφων.
Για παράδειγμα, θα χρειαστεί να το κάνετε αυτό για επεξεργάσιμα πεδία κειμένου και λιστών, ώστε να μπορέσετε να πληκτρολογήσετε χαρακτήρες και να χρησιμοποιήσετε τα βελάκια για να εργαστείτε με το στοιχείο ελέγχου.
Αυτό το επιτυγχάνετε με το να αλλάζετε σε Λειτουργία Εστίασης, όπου σχεδόν όλα τα πλήκτρα περνάνε στο στοιχείο ελέγχου.
Όταν βρίσκεστε σε Λειτουργία Περιήγησης, εξ ορισμού, το NVDA θα αλλάξει αυτόματα σε Λειτουργία Εστίασης αν μετακινηθείτε με το πλήτρο TAB ή κάνετε κλικ σε ένα στοιχείο ελέγχου που το απαιτεί.
Αντίστροφα, μετακινούμενοι με το TAB ή κάνοντας κλικ σε ένα στοιχείο ελέγχου που δεν απαιτεί τη Λειτουργία Εστίασης, θα αλλάξει σε Λειτουργία Περιήγησης.
Μπορείτε επίσης να πατήσετε ENTER ή SPACE για να αλλάξετε σε Λειτουργία Εστίασης στα στοιχεία ελέγχου που την απαιτούν.
Πατώντας ESCAPE θα αλλάξετε πίσω σε Λειτουργία Περιήγησης.
Επιπρόσθετα, μπορείτε χειροκίνητα να ενεργοποιήσετε τη Λειτουργία Εστίασης, η οποία θα παραμείνει ενεργή μέχρι εσείς να επιλέξετε να την απενεργοποιήσετε.

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Εναλλαγή Λειτουργιών Περιήγησης/Εστιάσης |NVDA+space |Εναλλάσσει μεταξύ των Λειτουργιών Εστίασης και Περιήγησης.|
|Έξοδος Λειτουργίας Εστίασης |escape |Αλλάζει πίσω σε Λειτουργία Περιήγησης, αν η Λειτουργία Εστίασης είχε προηγουμένως ενεργοποιηθεί αυτόματα.|
|Ανανέωση εγγράφου Λειτουργίας Περιήγησης |NVDA+f5 |Επαναφορτώνει το περιεχόμενο του τρέχοντος εγγράφου (χρήσιμο αν κάποιο περιεχόμενο φαίνεται να λείπει από το έγγραφο)|
|Εύρεση |NVDA+control+f |Εμφανίζει ένα παράθυρο διαλόγου όπου μπορείτε να πληκτρολογήσετε κάποιο κείμενο προς αναζήτηση στο τρέχον έγγραφο.|
|Εύρεση επόμενου |NVDA+f3 |Βρίσκει στο έγγραφο την επόμενη εμφάνιση του κειμένου που αναζητήσατε προηγουμένως.|
|Εύρεση προηγούμενου |NVDA+shift+f3 |Βρίσκει στο έγγραφο την προηγούμενη εμφάνιση του κειμένου που αναζητήσατε προηγουμένως.|
|άνοιγμα εκτεταμένης περιγραφής |nvda+d |Ανοίγει ένα καινούριο παράθυρο που περιλαμβάνει μια εκτεταμένη περιγραφή για το στοιχείο στο οποίο βρήσκεσται αν υπάρχει|

<!-- KC:endInclude -->

### Πλοήγηση Ενός Γράμματος {#toc43}

Όταν βρίσκεστε σε Λειτουργία Περιήγησης, για ταχύτερη πλοήγηση, το NVDA παρέχει επίσης πλήκτρα μονών χαρακτήρων για να μεταβαίνετε σε συγκεκριμένους τομείς στο έγγραφο.
Σημειώστε πως δεν υποστηρίζονται όλες οι εντολές σε συγκεκριμένους τύπους εγγράφων.

<!-- KC:beginInclude -->
Τα ακόλουθα πλήκτρα από μόνα τους σας μεταβιβάζουν στο επόμενο διαθέσιμο στοιχείο, ενώ η προσθήκη του πλήκτρου SHIFT προκαλεί τη μετάβαση στο προηγούμενο στοιχείο:

* h: επικεφαλίδα
* l: λίστα
* i: στοιχείο λίστας
* t: πίνακας
* k: σύνδεσμος
* n: μη-συνδεδεμένο κείμενο
* f: πεδίο φόρμας
* u: μη-διαβασμένος σύνδεσμος
* v: διαβασμένος σύνδεσμος
* e: πεδίο επεξεργασίας
* b: κουμπί
* x: κουτί επιλογής
* c: αναδυόμενο κουτί κειμένου
* r: κουμπί επιλογής
* q: μπλοκ παραπομπής
* s: διαχωριστής
* m: πλαίσιο
* g: γραφικό
* d: ορόσημο
* o: ενσωματωμένο αντικείμενο
* 1 μέχρι 6: επικεφαλίδες επιπέδου από 1 μέχρι 6 αντίστοιχα
* a: Σημείωση (σχόλιο, αναθεωρήσεων του συντάκτη και λοιπά).

Για να μετακινηθείτε στην αρχή ή στο τέλος των στοιχείων περιεκτών όπως οι λίστες και οι πίνακες:

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Μετακίνηση στην αρχή του περιέκτη |shift+κόμμα |Μετακινείται στην αρχή του περιέκτη (λίστα, πίνακας κλπ) όπου βρίσκεται ο κέρσορας.|
|Μετακίνηση μετά το τέλος του περιέκτη |κόμμα |Μετακινείται μετά το τέλος του περιέκτη (λίστα, πίνακας κλπ) όπου βρίσκεται ο κέρσορας.|

<!-- KC:endInclude -->

### Η Λίστα Στοιχείων {#toc44}

Η Λίστα Στοιχείων παρέχει πρόσβαση σε μία λίστα  διαφόρων στοιχίων στο έγγραφο ανάλογα με την τρέχουσα εφαρμογή.
Για παράδειγμα, σε πλοηγούς ιστοσελίδων η λίστα στοιχείων μπορεί να εμφανίσει συνδέσμους, επικεφαλίδες και ορόσημα.
Κουμπιά επιλογής σας επιτρέπουν να εναλλάσσετε ανάμεσα σε αυτούς τους τρεις τύπους πληροφορίας.
Επιπλέον, παρέχεται ένα πεδίο επεξεργασίας στο παράθυρο διαλόγου το οποίο σας επιτρέπει να φιλτράρετε τη λίστα ώστε να μπορέσετε να αναζητήσετε ένα συγκεκριμένο στοιχείο στη σελίδα.
Μόλις επιλέξετε ένα στοιχείο, μπορείτε να χρησιμοποιήσετε τα παρεχόμενα κουμπιά στο παράθυρο διαλόγου για να μεταφερθείτε στο στοιχείο ή να το ενεργοποιήσετε.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Λίστα στοιχείων λειτουργίας περιήγησης |NVDA+f7 |Εμφανίζει τη Λίστα Στοιχείων που περιέχει διάφορους τύπους στοιχείων από το τρέχον έγγραφο.|

<!-- KC:endInclude -->

### Ενσωματωμένα Αντικείμενα {#toc45}

Οι σελίδες μπορεί να περιέχουν εμπλουτισμένο περιεχόμενο βασισμένο σε τεχνολογίες όπως Adobe Flash και Sun Java, καθώς και εφαρμογές και διαλόγους.
Όταν εντοπίζονται τέτοια στοιχεία στη Λειτουργία Περιήγησης, το NVDA θα αναφέρει "ενσωματωμένο αντικείμενο", "εφαρμογή" ή "διάλογος" αντίστοιχα.
Για να αλληλεπιδράσετε με αυτά τα αντικείμενα, πρέπει να πατήσετε το ENTER σε αυτά.
Αν είναι προσβάσιμα, μπορείτε τότε με το TAB να τα περιδιαβείτε και να αλληλεπιδράσετε όπως με οποιαδήποτε άλλη εφαρμογή.
Παρέχεται μία εντολή πλήκτρου για να επιστρέψετε στην αρχική σελίδα που περιέχει το Ενσωματωμένο Αντικείμενο:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Μετακίνηση στο περιέχον έγγραφο της Λειτουργίας Περιήγησης |NVDA+control+space |Μετακινεί την εστίαση εκτός του τρέχοντος Ενσωματωμένου Αντικειμένου και εντός του εγγράφου που το περιέχει.|

<!-- KC:endInclude -->

## Ανάγνωση Μαθηματικού Περιεχομένου {#toc46}

Χρησιμοποιώντας το MathPlayer 4 από την Design Science, το NVDA μπορεί να διαβάσει και να πλοηγηθεί αλληλεπιδρώντας με υποστηριζόμενο μαθηματικό περιεχόμενο.
Αυτό προϋποθέτει ότι το MathPlayer 4 έχει εγκατασταθεί στον υπολογιστή.
Το MathPlayer διατίθεται δωρεάν στο: https://www.dessci.com/en/products/mathplayer/

Το NVDA υποστηρίζει τις ακόλουθες μορφές μαθηματικού περιεχομένου:

* MathML στον Mozilla Firefox και τον Microsoft Internet Explorer.
* Design Science MathType στο Microsoft Word και το PowerPoint.
* MathML στον Adobe Reader. Σημειώστε ότι αυτό δεν αποτελεί επίσημο στάνταρ ακόμα, ως εκ τούτου δεν διατίθεται δημόσια λογισμικό το οποίο να μπορεί να παράγει αυτό το περιεχόμενο.

Όταν διαβάζετε ένα έγγραφο, το NVDA θα εκφωνήσει οποιοδήποτε υποστηριζόμενο μαθηματικό περιεχόμενο εμφανιστεί.
Αν χρησιμοποιείτε οθόνη braille, θα εμφανιστεί και σε μορφή braille.

### Πλοήγηση Με Αλληλεπίδραση {#toc47}

Αν δουλεύετε πρωταρχικά με ομιλία, στις περισσότερες περιπτώσεις, μάλλον θα επιθυμείτε να εξετάσετε την έκφραση σε μικρότερα τμήματα, παρά να ακούσετε ολόκληρη την έκφραση.

Αν βρίσκεστε σε λειτουργία περιήγησης, μπορείτε να το κάνετε αυτό μετακινώντας το δρομέα στο μαθηματικό περιεχόμενο και πατώντας enter.

Αν δε βρίσκεστε σε λειτουργία περιήγησης:

1. μετακινήστε το δρομέα επανεξέτασης στο μαθηματικό περιεχόμενο.
Από προεπιλογή, ο δρομέας επανεξέτασης ακολουθεί τον κέρσορα του συστήματος, ως εκ τούτου συνήθως μπορείτε να χρησιμοποιήσετε τον κέρσορα του συστήματος για να μεταβείτε στο επιθυμητό περιεχόμενο.
1. Κατόπιν ενεργοποιήστε την ακόλουθη εντολή:

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Αλληλεπίδραση με μαθηματικό περιεχόμενο |NVDA+alt+m |Αρχίζει αλληλεπίδραση με μαθηματικό περιεχόμενο.|

<!-- KC:endInclude -->

Σε αυτό το σημείο, μπορείτε να χρησιμοποιήσετε τις εντολές του MathPlayer όπως τα πλήκτρα βέλους για να εξερευνήσετε την έκφραση.
Για παράδειγμα, μπορείτε να μετακινηθείτε μέσα στην έκφραση με το δεξί και αριστερό βέλος και να ζουμάρετε μέσα σε ένα μέρος της έκφρασης, όπως ένα κλάσμα, χρησιμοποιώντας το κάτω βέλος.
Παρακαλούμε να διαβάσετε την τεκμηρίωση για το MathPlayer για περισσότερες πληροφορίες.

Όταν επιθυμείτε να επιστρέψετε στο έγγραφο, απλά πατήστε το πλήκτρο escape.

## Αναγνώριση Περιεχομένου {#toc48}

Όταν οι δημιουργοί δεν παρέχουν επαρκείς πληροφορίες ώστε οι χρήστες αναγνωστών οθόνης να προσδιορίσουν το είδος του περιεχομένου, μπορούν να χρησιμοποιηθούν διάφορα εργαλεία με τα οποία επιχειρείται να αναγνωριστεί το περιεχόμενο μιας εικόνας.
Το NVDA υποστηρίζει τη δυνατότητα οπτικής αναγνώρισης χαρακτήρων (OCR) που έχει ενσωματωθεί στα Windows 10 προκειμένου να αναγνωρίσει κείμενο από εικόνες.
Επιπλέον αναγνώριση περιεχομένου είναι δυνατό να παρέχεται με τα πρόσθετα του NVDA.

Όταν χρησιμοποιείτε μια εντολή για αναγνώριση περιεχομένου, το NVDA αναγνωρίζει περιεχόμενο από το τρέχον αντικείμενο πλοήγησης #ObjectNavigation].
Από προεπιλογή, το αντικείμενο πλοήγησης ακολουθεί την εστίαση του συστήματος ή το δρομέα της λειτουργίας περιήγησης. Έτσι, μπορείτε απλά να εστιάσετε αλλού ή να μετακινήσετε το δρομέα περιήγησης εκεί που επιθυμείτε.
Για παράδειγμα, αν μετακινήσετε το δρομέα περιήγησης σε ένα γραφικό, από προεπιλογή θα γίνει αναγνώριση περιεχομένου από το γραφικό.
Ωστόσο, ίσως επιθυμείτε να χρησιμοποιήσετε την πλοήγηση αντικειμένου απευθείας, για παράδειγμα, προκειμένου να αναγνωρίσετε το περιεχόμενο ολόκληρου του παραθύρου μιας εφαρμογής.

Όταν ολοκληρωθεί η αναγνώριση, το αποτέλεσμα θα εμφανιστεί ως έγγραφο παρόμοιο με τη λειτουργία περιήγησης, επιτρέποντάς σας να διαβάσετε τις πληροφορίες με τα πλήκτρα δρομέα, κ.λπ.
Αν πατήσετε Enter ή Space θα ενεργοποιηθεί (κανονικά το κλικ) το κείμενο στο δρομέα, αν είναι δυνατό.
Αν πατήσετε Escape απορρίπτεται το αποτέλεσμα της αναγνώρισης.

### OCR στα Windows 10 {#Win10Ocr}

Τα Windows 10 συμπεριλαμβάνουν οπτική αναγνώριση χαρακτήρων για πολλές γλώσσες.
Το NVDA μπορεί να χρησιμοποιήσει αυτή τη δυνατότητα για να αναγνωρίσει κείμενο από εικόνες ή μη προσβάσιμες εφαρμογές.

Μπορείτε να ορίσετε τη γλώσσα που θα χρησιμοποιηθεί για την αναγνώριση κειμένου στο παράθυρο διαλόγου [Windows 10 OCR](#Win10OcrSettings).
Επιπλέον γλώσσες μπορούν να εγκατασταθούν αν πάτε στο μενού Έναρξη, Ρυθμίσεις, Ώρα & Γλώσσα -> Περιοχή & Γλώσσα και επιλέξετε Προσθήκη Γλώσσας.

<!-- KC:beginInclude -->
Για να αναγνωρίσετε το κείμενο στο τρέχον αντικείμενο πλοήγησης χρησιμοποιώντας την οπτική αναγνώριση χαρακτήρων στα Windows 10, πατήστε NVDA+r.
<!-- KC:endInclude -->

## Εντολές Του NVDA Για Συγκεκριμένες Εφαρμογές {#toc50}

Το NVDA παρέχει επιπλέον εντολές για κάποιες εφαρμογές, για να γίνουν ευκολότερα κάποιες εργασίες ή για να παρέχει πρόσβαση σε λειτουργίες που σε άλλη περίπτωση δεν είναι προσβάσιμες στους χρήστες αναγνωστών οθόνης.

### Microsoft Word {#toc51}

<!-- KC:beginInclude -->
||Όνομα | Πλήκτρο | Περιγραφή |

|Αναφορά τρέχοντος σχολίου |NVDA+Alt+c |Αναφέρει το κείμενο του σχολίου στη θέση του κέρσορα του συστήματος.|
|Ορισμός κεφαλίδων στήλης |NVDA+shift+c |Πατώντας το μια φορά, λέτε στο NVDA ότι αυτό είναι το πρώτο κελί της κεφαλίδας στη σειρά που περιλαμβάνει κεφαλίδες στήλης, οι οποίες θα πρέπει να αναγγέλλονται αυτόματα όταν μετακινήστε μεταξύ στηλών κάτω από αυτή τη σειρά. Πατώντας το δυο φορές, θα εκκαθαρίσει τη ρύθμιση.|
|Ορισμός κεφαλίδων σειράς |NVDA+shift+r |Πατώντας το μια φορά, λέτε στο NVDA ότι αυτό είναι το πρώτο κελί της κεφαλίδας στη στήλη που περιλαμβάνει κεφαλίδες σειράς, οι οποίες θα πρέπει να αναγγέλλονται αυτόματα όταν μετακινήστε μεταξύ σειρών μετά από αυτή τη στήλη. Πατώντας το δυο φορές, θα εκκαθαρίσει τη ρύθμιση.|

<!-- KC:endInclude -->

### Microsoft Excel {#toc52}

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Ορισμός κεφαλίδων στήλης |NVDA+shift+c |Πατώντας το μια φορά λέτε στο NVDA ότι αυτό είναι το πρώτο κελί της κεφαλίδας στη σειρά που περιλαμβάνει κεφαλίδες στήλης, οι οποίες θα πρέπει να αναγγέλλονται αυτόματα όταν μετακινήστε μεταξύ στηλών κάτω από αυτή τη σειρά. Πατώντας δυο φορές θα εκκαθαρίσει τη ρύθμιση.|
|Ορισμός κεφαλίδων σειράς |NVDA+shift+r |Πατώντας το μια φορά λέτε στο NVDA ότι αυτό είναι το πρώτο κελί της κεφαλίδας στη στήλη που περιλαμβάνει κεφαλίδες σειράς, οι οποίες θα πρέπει να αναγγέλλονται αυτόματα όταν μετακινήστε μεταξύ σειρών μετά από αυτή τη στήλη. Πατώντας δυο φορές θα εκκαθαρίσει τη ρύθμιση.|
|Αναφορά σχολίου |NVDA+alt+c |Αναφέρει το σχόλιο στο τρέχον κελί, αν υπάρχει.|

<!-- KC:endInclude -->

### Microsoft PowerPoint {#toc53}

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Εναλλαγή ανάγνωσης σημειώσεων ομιλητή |control+shift+s |Όταν τρέχει μια παρουσίαση διαφανειών, αυτή η εντολή εναλλάσσει μεταξύ των σημειώσεων του ομιλητή για τη διαφάνεια και του περιεχομένου της διαφάνειας. Αυτό επηρεάζει μόνο ό,τι διαβάζει το NVDA, όχι ό,τι εμφανίζεται στην οθόνη.|

<!-- KC:endInclude -->

### foobar2000 {#toc54}

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Αναφορά απομένουσας ώρας |control+shift+r |Αναφέρει την απομένουσα ώρα για το κομμάτι που παίζει τώρα, αν υπάρχει.|

<!-- KC:endInclude -->

Σημείωση: Η συντόμευση αναφοράς της απομένουσας ώρας δουλεύει μόνο με την προεπιλεγμένη  παράμετρο μορφοποίησης  για την γραμμή κατάστασης του foobar. 

### Miranda IM {#toc55}

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Αναφορά πρόσφατου μηνύματος |NVDA+control+1-4 |Αναφέρει ένα από τα πρόσφατα μηνύματα, ανάλογα με τον αριθμό που έχει πατηθεί; για παράδειγμα, το NVDA+control+2 διαβάζει το δεύτερο πιο πρόσφατο μήνυμα.|

<!-- KC:endInclude -->

### Poedit {#toc56}

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Αναφορά Παραθύρου Σχολίων |control+shift+c |Αναφέρει οποιαδήποτε σχόλια στο παράθυρο σχολίων.|
|Αναφορά σημειώσεων για μεταφραστές |control+shift+a |Αναφέρει οποιεσδήποτε σημειώσεις για τους μεταφραστές.|

<!-- KC:endInclude -->

### Skype {#toc57}

<!-- KC:beginInclude -->
Όταν βρησκόμαστε σε κάποια συνομιλία.

| Όνομα |Πλήκτρο |Περιγραφή|
|---|---|---|
|Εξέταση μηνύματος |NVDA+control+1-0 |Αναφέρει και μετακηνεί τον δρομέα εξέτασης σε ένα πρόσφατο μήνυμα, ανάλογα με τον αριθμό που θα πατήσουμε: Για παράδειγμα το NVDA+control+2 διαβάζει το δεύτερο πιο πρόσφατο μήνυμα.|

<!-- KC:endInclude -->

## Διαμόρφωση του NVDA {#toc58}
### Προτιμήσεις {#toc59}

<!-- KC:settingsSection: || Όνομα | Πλήκτρο Υπολογιστή Γραφείου | Πλήκτρο Υπολογιστή Laptop | Περιγραφή | -->
Οι περισσότερες ρυθμίσεις του NVDA μπορούν να αλλάξουν μέσα από διάφορα κουτιά διαλόγου που είναι προσβάσιμα από το υπό-μενού Προτιμήσεις του μενού του NVDA.
Σε όλα τα κουτιά διαλόγου των ρυθμίσεων του NVDA, πατώντας το OK εφαρμόζετε τις όποιες αλλαγές έχετε κάνει.
Για να ακυρώσετε οποιαδήποτε αλλαγή, πατήστε το κουμπί Άκυρο ή το ESCAPE.
Μπορείτε επίσης να αλλάξετε κάποιες από τις ρυθμίσεις χρησιμοποιώντας συντομεύσεις πλήκτρων, οι οποίες όπου υπάρχουν αναφέρονται στις επόμενες παραγράφους.

Να έχετε υπόψη σας ότι δεν μπορούν όλα τα κουτιά διαλόγου των ρυθμίσεων να έχουν πρόσβαση μέσω χειρονομιών εισόδου (Εντολές πληκτρολογίου, κινήσεις αφής, και λοιπά.)
Αν επιθυμείτε να έχετε πρόσβαση σε κουτιά διαλόγου που δεν έχουν καθορισμένες συντομεύσεις πληκτρολογίου, χρησιμοποιήστε το κουτί διαλόγου για την [Είσοδο χειρονομιών](#InputGestures) για να προσθέσετε μια δική σας χειρονομία για αυτό το κουτί διαλόγου.

#### Γενικές Ρυθμίσεις (NVDA+control+g) {#toc60}

Το κουτί διαλόγου των Γενικών Ρυθμίσεων βρίσκεται στο μενού Προτιμήσεις.
Περιέχει τις ακόλουθες επιλογές:

##### Γλώσσα {#toc61}

Ένα αναδυόμενο κουτί κειμένου σας επιτρέπει να επιλέξετε τη γλώσσα στην οποία θα εμφανίζεται η διεπαφή χρήστη του NVDA και τα μηνύματα.
Υπάρχουν πολλές γλώσσες, ωστόσο η εξ ορισμού επιλογή είναι "User Default, Windows".
Αυτή η επιλογή ορίζει στο NVDA να χρησιμοποιεί τη γλώσσα που είναι ρυθμισμένη στα Windows.

Σημειώστε ότι το NVDA πρέπει να επανεκκινηθεί όταν αλλάζετε τη γλώσσα.
Το NVDA θα σας ρωτήσει αν επιθυμείτε την επανεκκίνηση αν όντως αλλάξετε την επιλογή.
Πατήστε OK, και το NVDA θα επανεκκινηθεί.

##### Αποθήκευση Διαμόρφωσης κατά την Έξοδο {#toc62}

Αυτό είναι ένα κουτί επιλογής, το οποίο όταν είναι ενεργοπιημένο ορίζει στο NVDA να αποθηκεύει αυτόματα κατά την έξοδο την τρέχουσα διαμόρφωση.

##### Εμφάνιση επιλογών εξόδου κατά την έξοδο από το nvda {#toc63}

Αυτό είναι ένα κουτί επιλογής που σας επιτρέπει να επιλέξετε κατά πόσον θα εμφανίζεται ή όχι ένα κουτί διαλόγου όταν θέλετε να βγείτε από το nvda που θα σας ρωτά ποια λειτουργία θα θέλετε να πραγματοποιήσετε.
Όταν είναι ενεργοπιημένο, ένα παράθυρο διαλόγου θα εμφανιστεί όταν προσπαθήσετε να βγείτε από το nvda και θα σας ρωτά αν θέλετε να πραγματοποιήσετε έξοδο από το nvda, να κάνετε επανεκκίνηση ή να κάνετε επανεκκίνηση με όλα τα πρόσθετα απενεργοποιημένα.
Αν δεν είναι τσεκαρισμένο, το nvda θα πραγματοποιήσει έξοδο αμέσως.

##### Αναπαραγωγή ήχων κατά την εκκίνηση ή την έξοδο από το nvda {#toc64}

Αυτό είναι ένα κουτί επιλογής, το οποίο όταν είναι ενεργοποιημένο, ορίζει στο NVDA να αναπαράγει ήχους όταν πραγματοποιεί εκκίνηση ή έξοδο.

##### Επίπεδο Καταγραφής {#toc65}

Αυτό είναι ένα αναδυόμενο κουτί κειμένου που σας επιτρέπει να επιλέξετε τον όγκο καταγραφής του NVDA όταν αυτό εκτελείται.
Γενικά, οι χρήστες δεν χρειάζεται να αλλάξουν αυτή την επιλογή καθώς εξ ορισμού δεν καταγράφονται πολλά στοιχεία.
Ωστόσο, αν θέλετε να προσφέρετε πληροφορίες σε μία αναφορά σφάλματος (bug), τότε μπορεί να είναι χρήσιμη η αλλαγή αυτής της επιλογής.

##### Αυτόματη εκκίνηση του NVDA μετά την είσοδο στα Windows {#toc66}

Αν αυτή η επιλογή είναι ενεργοποιημένη, το NVDA θα ξεκινάει αυτόματα αμέσως μόλις κάνετε είσοδο στα Windows.
Αυτή η επιλογή είναι διαθέσιμη μόνο για εγκατεστημένα αντίγραφα του NVDA.

##### Χρήση του NVDA στην οθόνη εισόδου των Windows (απαιτεί δικαιώματα διαχειριστή) {#toc67}

Αν εισέρχεστε στα Windows δίνοντας ένα όνομα χρήστη (user name) και ένα συνθηματικό (password), τότε η ενεργοποίηση αυτής της επιλογής θα κάνει το NVDA να ξεκινάει αυτόματα και στην οθόνη εισόδου όταν αρχίζουν τα Windows.
Αυτή η επιλογή είναι διαθέσιμη μόνο για εγκατεστημένα αντίγραφα του NVDA.

##### Χρήση τρεχόντων αποθηκευμένων ρυθμίσεων στην είσοδο και σε άλλες οθόνες ασφαλείας (απαιτεί δικαιώματα διαχειριστή) {#toc68}

Με το πάτημα αυτού του κουμπιού, αντιγράφεται η τρέχουσα αποθηκευμένη διαμόρφωση χρήστη του NVDA στον φάκελο διαμόρφωσης συστήματος του NVDA, έτσι ώστε να την χρησιμοποιεί το NVDA όταν εκτελείται στις οθόνες εισόδου, Ελέγχου Λογαριασμού Χρήστη (UAC) και άλλες οθόνες ασφαλείας των Windows.
Για να είστε βέβαιοι ότι όλες οι ρυθμίσεις σας έχουν μεταφερθεί, φροντίστε ώστε πρώτα να αποθηκεύσετε την διαμόρφωση πατώντας control+NVDA+c ή την Αποθήκευση Διαμόρφωσης στο μενού του NVDA.
Αυτή η επιλογή είναι διαθέσιμη μόνο για εγκατεστημένα αντίγραφα του NVDA.

##### Αυτόματος έλεγχος ενημερώσεων του NVDA {#toc69}

Αν αυτή η επιλογή είναι ενεργοποιημένη, το NVDA θα ελέγχει αυτόματα για ενημερωμένες εκδόσεις του NVDA και θα σας πληροφορεί σχετικά.
Μπορείτε επίσης να ελέγχετε χειροκίνητα για ενημερώσεις επιλέγοντας Έλεγχος για νέα έκδοση κάτω από τη Βοήθεια στο μενού του NVDA.

#### Επιλογή Συνθέτη Ομιλίας (NVDA+control+s) {#toc70}

Ο διάλογος του Συνθέτη Ομιλίας, που βρίσκεται κάτω από το "Συνθέτης ομιλίας..." στο μενού Προτιμήσεις, σας επιτρέπει να επιλέξετε ποιό συνθέτη θα χρησιμοποιεί το NVDA για να μιλάει.
Μόλις επιλέξετε το συνθέτη της προτίμησης σας, μπορείτε να πατήσετε το OK και το NVDA θα τον φορτώσει προς χρήση.
Αν υπάρξει σφάλμα κατά τη φόρτωση του συνθέτη, το NVDA θα σας ενημερώσει με ένα μήνυμα και θα συνεχίσει χρησιμοποιώντας τον προηγούμενο συνθέτη.

##### Συνθέτης Ομιλίας {#toc71}

Αυτή η επιλογή σας επιτρέπει να διαλέξετε το συνθέτη που θέλετε να χρησιμοποιεί το NVDA για την έξοδο ομιλίας.

Για μία λίστα των συνθετών που υποστηρίζει το NVDA, δείτε τη παράγραφο [Υποστηριζόμενοι Συνθέτες φωνής](#SupportedSpeechSynths).

Ένα ειδικό στοιχείο που πάντα εμφανίζεται σε αυτή τη λίστα είναι το "Χωρίς ομιλία", που σας επιτρέπει να χρησιμοποιείτε το NVDA χωρίς έξοδο ομιλίας.
Κάτι τέτοιο μπορεί να είναι χρήσιμο για κάποιον που επιθυμεί να χρησιμοποιήσει το NVDA μόνο με συσκευή Braille, ή πιθανώς για βλέποντες προγραμματιστές που θέλουν να χρησιμοποιήσουν μόνο τον Προβολέα Ομιλίας.

##### Συσκευή Εξόδου {#toc72}

Αυτή η επιλογή σας επιτρέπει να διαλέξετε την κάρτα ήχου μέσω της οποίας θα σας μιλάει ο επιλεγμένος συνθέτης..

<!-- KC:setting -->

##### Κατάσταση βύθισης ήχου {#toc73}

Πλήκτρο: NVDA+shift+d

Στα windows 8 και μεταγενέστερα, αυτή η επιλογή σας επιτρέπει να διαλέξετε αν το nvda θα χαμηλώνει τον ήχο άλλων εφαρμογών όταν το nvda εκφωνεί κάτι, ή όλη την ώρα όσο το nvda τρέχει.

* Χωρίς βύθιση: Το nvda δεν θα χαμηλώνει ποτέ την ένταση άλλων ήχων.
* Βύθιση κατά την εκφώνηση και την αναπαραγωγή ήχων: Το nvda θα χαμηλώνει την ένταση άλλων ήχων μόνο όταν εκφωνεί κάτι ή παίζει ήχους. Αυτό ενδέχεται να μην δουλεύει με όλους τους συνθέτες.
* Πάντα βύθιση: Το nvda θα κρατήσει όλους τους άλλους ήχους χαμηλωμένους σε όλο το διάστημα κατά το οποίο τρέχει.

#### Ρυθμίσεις Φωνής (NVDA+control+v) {#VoiceSettings}

Το παράθυρο διαλόγου των Ρυθμίσεων Φωνής, που βρίσκεται στο μενού Προτιμήσεις, περιέχει επιλογές που σας επιτρέπει να αλλάξετε τον ήχο της ομιλίας.
Για έναν πιο γρήγορο εναλλακτικό τρόπο για τον έλεγχο των παραμέτρων ομιλίας από οπουδήποτε, δείτε τη παράγραφο του [Δακτυλίου Ρυθμίσεων Συνθέτη](#SynthSettingsRing).

Το κουτί διαλόγου των Ρυθμίσεων Φωνής περιέχει τις ακόλουθες επιλογές:

##### Φωνή {#toc75}

Η πρώτη επιλογή που συναντάτε σε αυτό το παράθυρο διαλόγου είναι ένα αναδυόμενο κουτί κειμένου που περιέχει λίστα με όλες της φωνές του τρέχοντος συνθέτη που έχετε εγκαταστήσει.
Μπορείτε να χρησιμοποιήσετε τα βελάκια για να ακούσετε όλες τις επιλογές.
Το Αριστερό και το Πάνω βελάκι σας πάνε πάνω στη λίστα, ενώ το Δεξιό και το Κάτω βελάκι σας πάνε κάτω στη λίστα.

##### Παραλλαγή {#toc76}

Αν χρησιμοποιείτε το συνθέτη eSpeak που έρχεται πακέτο μαζί με το NVDA, αυτό το αναδυόμενο κουτί κειμένου σας επιτρέπει να επιλέξετε μία Παραλλαγή με την οποία θα μιλήσει ο συνθέτης.
Οι Παραλλαγές του eSpeak είναι σαν τις φωνές, καθώς παρέχουν ελαφρώς διαφορετικά χαρακτηριστικά στη φωνή του eSpeak.
Κάποιες Παραλλαγές θα ακούγονται σαν αντρικές, κάποιες σαν γυναικείες και κάποιες ακόμα και σαν βάτραχοι.

##### Ρυθμός {#toc77}

Αυτή η επιλογή σας επιτρέπει να αλλάξετε τον ρυθμό της φωνής σας. 
Αυτό είναι ένα ποτενσιόμετρο που παίρνει τιμές από 0 μέχρι 100, (0 είναι ο πιο αργός και 100 ο πιο γρήγορος).

##### Ύψος Τόνου {#toc78}

Αυτή η επιλογή σας επιτρέπει να αλλάξετε το ύψος του τόνου της τρέχουσας φωνής.
Αυτό είναι ένα ποτενσιόμετρο που παίρνει τιμές από 0 μέχρι 100, (0 είναι ο χαμηλότερος τόνος και 100 ο υψηλότερος).

##### Ένταση {#toc79}

Αυτή η επιλογή είναι ένα ποτενσιόμετρο που παίρνει τιμές από 0 μέχρι 100, (0 είναι η χαμηλότερη ένταση και 100 η υψηλότερη).

##### Επιτονισμός {#toc80}

Αυτή η επιλογή είναι ένα ποτενσιόμετρο που σας επιτρέπει να επιλέξετε το εύρος του επιτονισμού (κάθοδοι και άνοδοι στο ύψος τόνου) της συνθετικής ομιλίας. (Ο μόνος συνθέτης που παρέχει αυτή την επιλογή προς το παρόν είναι το eSpeak).

##### Αυτόματη Εναλλαγή Γλώσσας {#toc81}

Αυτό το κουτί επιλογής σας επιτρέπει να ενεργοποιήσετε και να απενεργοποιήσετε την εν λειτουργία αυτόματη εναλλαγή των γλωσσών του συνθέτη ομιλίας, αν στο κείμενο που διαβάζεται παρέχεται επισημείωση με τη γλώσσα.
Αυτή η επιλογή είναι εξ ορισμού τσεκαρισμένη.
Επί του παρόντος, μόνο ο συνθέτης eSpeak υποστηρίζει την αυτόματη εναλλαγή γλώσσας.

##### Αυτόματη Εναλλαγή Διαλέκτου {#toc82}

Αν η Αυτόματη Εναλλαγή Γλώσσας είναι ενεργοποιημένη, αυτό το κουτί επιλογής σας επιτρέπει να διαλέξετε αν εκτός από τις αλλαγές γλώσσας θα γίνονται και αλλαγές διαλέκτου. Για παράδειγμα, αν η εκφώνηση γίνεται με φωνή Αγγλική Αμερικής αλλά το έγγραφο ορίζει κάποιο μέρος του κειμένου σαν Αγγλικά Ενωμένου Βασιλείου, τότε αν αυτό το χαρακτηριστικό είναι τσεκαρισμένο ο συνθέτης θα αλλάζει την προφορά του.
Αυτή η επιλογή είναι εξ ορισμού απενεργοποιημένη.

<!-- KC:setting -->

##### Επίπεδο Σημείων Στίξης/Συμβόλων {#toc83}

Πλήκτρο: NVDA+p

Αυτό σας επιτρέπει να επιλέξετε τη ποσότητα των σημείων στίξης και άλλων συμβόλων που θα πρέπει να εκφωνούνται σαν λέξεις.
Για παράδειγμα, όταν ορίζεται σε όλα, όλα τα σύμβολα θα διαβάζονται σαν λέξεις.
Αυτή η επιλογή εφαρμόζεται σε όλους τους συνθέτες, όχι μόνο στον τρέχον ενεργό συνθέτη.

##### Αποδοχή της γλώσσας της φωνής κατά την επεξεργασία χαρακτήρων και συμβόλων {#toc84}

Ενεργοποιημένη εξορισμού, αυτή η επιλογή ορίζει στο nvda αν θα πρέπει να εμπιστεύεται την γλώσσα της τρέχουσας φωνής κατά την επεξεργασία συμβόλων ή χαρακτήρων.
Αν εντοπίσετε πως το nvda διαβάζει σημεία στίξης σε λάθος γλώσσα για έναν συνθέτη ή φωνή, μπορείτε να απενεργοποιήσετε αυτή την επιλογή για να αναγκάσετε το nvda να χρησιμοποιήσει την γενική ρύθμιση γλώσσας.

##### Ποσοστό Αλλαγής Τόνου σε Κεφαλαία {#toc85}

Αυτό το πεδίο επεξεργασίας σας επιτρέπει να πληκτρολογήσετε τη ποσότητα με την οποία το ύψος του τόνου θα αλλάξει όταν εκφωνείται ένα κεφαλαίο γράμμα.
Αυτή η τιμή είναι ένα ποσοστό, όπου μία αρνητική τιμή χαμηλώνει τον τόνο και μία θετική τιμή τον ανεβάζει.
Για να ορίσετε καμία μεταβολή στον τόνο, βάλτε 0.

##### Λέγε "κεφαλαίο" μετά από κεφαλαίο χαρακτήρα {#toc86}

Αυτή η ρύθμιση είναι ένα κουτί επιλογής, το οποίο όταν είναι ενεργοποιημένο ορίζει στο NVDA να λέει τη λέξη "κεφαλαίο" μετά από κάθε κεφαλαίο γράμμα, όταν αυτό διαβάζεται σαν ένας ανεξάρτητος χαρακτήρας όπως στην περίπτωση της εκφώνησης ανά χαρακτήρα.
Συνήθως, το NVDA υψώνει λίγο τον τόνο σε κάθε κεφαλαίο γράμμα, αλλά μερικοί συνθέτες μπορεί να μην το υποστηρίζουν αυτό, οπότε αυτή η επιλογή μπορεί να χρησιμοποιηθεί.

##### Ήχος μπιπ για τα κεφαλαία {#toc87}

Αν αυτό το κουτί επιλογής είναι ενεργοποιημένο, το NVDA θα κάνει έναν μικρό ήχο μπιπ κάθε φορά που συναντάει ένα κεφαλαίο γράμμα μόνο του.
Όπως το κουτί επιλογής "λέγε κεφαλαίο μετά από κεφαλαίο χαρακτήρα", αυτό είναι χρήσιμο για συνθέτες που δεν μπορούν να αλλάξουν τον τόνο τους για τα κεφαλαία γράμματα.

##### Χρήση λειτουργίας προφοράς ανά χαρακτήρα αν υποστηρίζεται {#VoiceSpellingFunctionality}

Κάποιες λέξεις αποτελούνται από ένα μόνο γράμμα, αλλά η προφορά τους είναι διαφορετική αναλόγως με το αν το γράμμα διαβάζεται σαν ένας ανεξάρτητος χαρακτήρας (όπως κατά την προφορά ανά χαρακτήρα) ή σαν μία λέξη.
Για παράδειγμα, στα Αγγλικά το "a" είναι και γράμμα και λέξη, ενώ στα Ελληνικά το "ο" είναι και γράμμα και λέξη.
Αυτή η επιλογή επιτρέπει στο συνθέτη να διαφοροποιεί την προφορά ανάμεσα σε αυτές τις δύο περιπτώσεις, αν ο συνθέτης το υποστηρίζει αυτό.
Οι περισσότεροι συνθέτες το υποστηρίζουν.

Αυτή η επιλογή πρέπει γενικά να είναι ενεργοποιημένη.
Ωστόσο, κάποιοι συνθέτες που λειτουργούν μέσω του Microsoft Speech API (SAPI) δεν το υλοποιούν σωστά και συμπεριφέρονται περίεργα όταν είναι ενεργοποιημένο.
Αν έχετε προβλήματα με την προφορά ανεξάρτητων χαρακτήρων, δοκιμάστε να απενεργοποιήσετε αυτή την επιλογή.

#### Δακτύλιος Ρυθμίσεων Συνθέτη {#SynthSettingsRing}

Αν θέλετε να κάνετε γρήγορα αλλαγές στις ρυθμίσεις του συνθέτη χωρίς να πηγαίνεται στο διάλογο των Ρυθμίσεων Φωνής, υπάρχουν κάποιες εντολές πλήκτρων του NVDA που σας επιτρέπουν καθώς τρέχετε το NVDA να κινείστε από οπουδήποτε ανάμεσα στις πιο συνηθισμένες ρυθμίσεις:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο επιτραπέζιου Υπολογιστή |Πλήκτρο φορητού Υπολογιστή |Περιγραφή|
|---|---|---|---|
|Μετακίνηση στην επόμενη ρύθμιση συνθέτη |NVDA+control+δεξίΒέλος |NVDA+shift+control+δεξίΒέλος |Μετακινείται στην επόμενη μετά την τρέχουσα διαθέσιμη ρύθμιση της ομιλίας, κάνοντας κύκλο, αν τερματίσει, από την τελευταία ρύθμιση πάλι στην πρώτη.|
|Μετακίνηση στην προηγούμενη ρύθμιση συνθέτη |NVDA+control+αριστερόΒέλος |NVDA+shift+control+αριστερόΒέλος |Μετακινείται στην προηγούμενη μετά την τρέχουσα διαθέσιμη ρύθμιση της ομιλίας, κάνοντας κύκλο, αν φτάσει στην αρχή, από την πρώτη ρύθμιση πίσω στην τελευταία.|
|Αύξηση τρέχουσας ρύθμισης συνθέτη |NVDA+control+πάνωΒέλος |NVDA+shift+control+πάνωΒέλος |αυξάνει την τρέχουσα ρύθμιση ομιλίας στην οποία βρίσκεστε. Παράδειγμα, αυξάνει το ρυθμό, επιλέγει την επόμενη φωνή, αυξάνει την ένταση κλπ.|
|Μείωση τρέχουσας ρύθμισης συνθέτη |NVDA+control+κάτωΒέλος |NVDA+shift+control+κάτωΒέλος |μειώνει την τρέχουσα ρύθμιση ομιλίας στην οποία βρίσκεστε. Παράδειγμα, μειώνει το ρυθμό, επιλέγει την επόμενη φωνή, αυξάνει την ένταση κλπ.|

<!-- KC:endInclude -->

#### Ρυθμίσεις braille {#toc90}

Το πλαίσιο διαλόγου για τις ρυθμίσεις braille μπορεί να εμφανιστεί πηγαίνοντας στο μενού προτιμήσεων και ακολούθως στην επιλογή ρυθμίσεις braille.

##### Οθόνη braille {#toc91}

Η πρώτη επιλογή που θα συναντήσετε στο πλαίσιο διαλόγου για τις ρυθμίσεις braille είναι ένα αναδυόμενο κουτί που λέει "Οθόνη braille".
Θα σας παρουσιαστούν διάφορες επιλογές ανάλογα με τις οθόνες braille που είναι διαθέσιμες στο σύστημα σας.
Μετακινηθείτε μεταξύ αυτών των επιλογών με τα βελάκια.

Η επιλογή χωρίς braille σημαίνει ότι δεν χρησιμοποιείτε braille.

Παρακαλώ ελέγξτε την ενότητα [Υποστηριζόμενες οθόνες braille](#SupportedBrailleDisplays) για περισσότερες πληροφορίες σχετικά με υποστηριζόμενες οθόνες braille.

##### Θύρα {#toc92}

Αυτή η επιλογή, αν είναι διαθέσιμη, σας επιτρέπει να επιλέξετε ποια θύρα ή τι είδους σύνδεσης θα χρησιμοποιηθεί για να γίνει επικοινωνία με την οθόνη braille που έχετε επιλέξει.
Είναι ένα αναδυόμενο κουτί που περιλαμβάνει τις πιθανές επιλογές για την οθόνη braille σας.

Ως προεπιλογή, το nvda χρησιμοποιεί αυτόματη ανίχνευση θύρας, που σημαίνει ότι η σύνδεση με την οθόνη braille θα γίνει αυτόματα ψάχνοντας για διαθέσιμες συσκευές usb ή bluetooth στο σύστημα σας.
Παρόλα αυτά, για ορισμένες οθόνες braille, ενδέχεται να μπορείτε να καθορίσετε ποια θύρα θα χρησιμοποιηθεί.
Συνήθης επιλογές είναι "Αυτόματη" (Η οποία λέει στο nvda να χρησιμοποιήσει την προεπιλεγμένη διαδικασία για αυτόματη επιλογή θύρας), "USB", "Bluetooth" και θύρες legacy serial communication αν η οθόνη braille σας υποστηρίζει τέτοιου είδους σύνδεσης.

Η επιλογή αυτή δεν θα είναι διαθέσιμη αν η οθόνη braille σας υποστηρίζει μόνο αυτόματη ανίχνευση θύρας.

Μπορείτε να ελέγξετε την ενότητα [Υποστηριζόμενες οθόνες braille ##SupportedBrailleDisplays] για περισσότερες λεπτομέρειες σχετικά με τρόπους σύνδεσης και διαθέσημες θύρες για την οθόνη braille σας.

##### Πίνακας εξόδου {#toc93}

Η επόμενη επιλογή που θα συναντήσετε σε αυτό το πλαίσιο διαλόγου είναι το αναδυόμενο κουτί για επιλογή πίνακα εξόδου braille.
Σε αυτό το αναδυόμενο κουτί, θα βρείτε πίνακες braille για διάφορες γλώσσες, μεθόδους braille και επίπεδα.
Ο επιλεγόμενος πίνακας θα χρησιμοποιείται για να γίνεται μετάφραση κειμένου σε braille για να παρουσιάζεται στην οθόνη braille σας.
Μπορείτε να μετακινήστε από πίνακα σε πίνακα μέσα στην λίστα χρησιμοποιώντας τα βελάκια.

##### Πίνακας εισόδου {#toc94}

Ως συμπλήρωμα της προηγούμενης επιλογής, η επόμενη επιλογή που θα βρείτε είναι το αναδυόμενο κουτί για επιλογή πίνακα εισόδου.
Ο επιλεγόμενος πίνακας θα χρησιμοποιείται για να γίνεται μετάφραση του braille που θα γράφετε χρησιμοποιώντας το πληκτρολόγιο είδους Perkins της οθόνης braille σας σε κείμενο.
Το nvda στο παρών στάδιο υποστηρίζει μόνο είσοδο braille για υπολογιστές, έτσι μόνο πίνακες braille σε οκτάστιγμα θα εμφανίζονται.
Μπορείτε να μετακινήστε από πίνακα σε πίνακα στην λίστα χρησιμοποιώντας τα βελάκια.

Σημειώστε ότι η επιλογή αυτή είναι χρήσιμη μόνο αν η οθόνη braille σας περιλαμβάνει πληκτρολόγιο είδους Perkins και αν αυτή η δυνατότητα υποστηρίζεται από τον οδηγό της οθόνης braille.
Αν η είσοδος δεν υποστηρίζεται σε κάποια οθόνη που περιλαμβάνει πληκτρολόγιο braille, αυτό θα επισημαίνεται στην ενότητα [Υποστηριζόμενες οθόνες braille](#SupportedBrailleDisplays).

##### Επέκταση σε κώδικα υπολογιστών για την λέξη στην οποία βρίσκεται ο δρομέας {#toc95}

Αυτή η επιλογή επιτρέπει στην λέξη που βρίσκεται κάτω από τον δρομέα να εμφανίζεται σε braille για υπολογιστές χωρίς συντομεύσεις.

##### Εμφάνιση δρομέα {#toc96}

Η επιλογή αυτή επιτρέπει στον δρομέα braille να είναι ενεργοποιημένος ή απενεργοποιημένος.
Ισχύει για τον Κέρσορα Συστήματος και τον δρομέα εξέτασης, αλλά όχι για την ένδειξη επιλογής.

##### Ρυθμός εναλλαγής φωτεινότητας (ms) {#toc97}

Η επιλογή αυτή είναι ένα αριθμητικό πεδίο που σας επιτρέπει να αλλάξετε τον ρυθμό με τον οποίο θα εναλλάσσεται η φωτεινότητα του δρομέα σε χιλιοστά του δευτερολέπτου (mili seconds).

##### Σχήμα δρομέα {#toc98}

Η επιλογή αυτή σας επιτρέπει να επιλέξετε το σχήμα (αναπαράσταση σε κουκκίδες) του δρομέα braille.
Η ένδειξη επιλογής δεν επηρεάζεται από αυτή την ρύθμιση.

#### Ρυθμίσεις Πληκτρολογίου (NVDA+control+k) {#toc99}

Αυτό το κουτί διαλόγου βρίσκεται στο μενού Προτιμήσεις, κάτω από το "Ρυθμίσεις πληκτρολογίου...".
Περιέχει τις ακόλουθες επιλογές:

##### Διάταξη πληκτρολογίου {#toc100}

Αυτό το αναδυόμενο κουτί κειμένου σας επιτρέπει να επιλέξετε τον τύπο της διάταξης πληκτρολογίου που θα χρησιμοποιεί το NVDA. Προς το παρόν οι δύο διαθέσιμες επιλογές είναι επιτραπέζιος Υπολογιστής (desktop) και Φορητός Υπολογιστής (laptop).

##### Χρήση του πλήκτρου Κλείδωμα Κεφαλαίων (Caps Lock) σαν το πλήκτρο τροποποιητή NVDA {#toc101}

Αν αυτό το κουτί επιλογής είναι τσεκαρισμένο, το πλήκτρο Κλείδωμα Κεφαλαίων (Caps Lock) θα χρησιμοποιείται σαν το πλήκτρο τροποποιητή NVDA.

##### Χρήση του Insert σαν το πλήκτρο τροποποιητή NVDA {#toc102}

Αν αυτό το κουτί επιλογής είναι τσεκαρισμένο, το πλήκτρο Insert (συνήθως βρίσκεται πάνω από τα πλήκτρα με τα βέλη, κοντά στο HOME και στο END) θα χρησιμοποιείται σαν το πλήκτρο τροποποιητή NVDA.

##### Χρήση του Insert του αριθμητικού πληκτρολογίου σαν το πλήκτρο τροποποιητή NVDA {#toc103}

Αν αυτό το κουτί επιλογής είναι τσεκαρισμένο, το πλήκτρο Insert του αριθμητικού πληκτρολογίου θα χρησιμοποιείται σαν το πλήκτρο τροποποιητή NVDA.

Αν δεν έχει οριστεί κανένα πλήκτρο σαν πλήκτρο τροποποιητή του nvda, ενδέχεται να είναι αδύνατο να έχετε πρόσβαση σε κάποιες εντολές του nvda.
Ως εκ τούτου, το κουτί διαλόγου για τις ρυθμίσεις πληκτρολογίου θα παρουσιάσει ένα σφάλμα αν και οι τέσσερις επιλογές δεν είναι επιλεγμένες μόλις πατήσετε ok.
Αφού απομακρύνεται αυτό το μήνυμα σφάλματος, θα πρέπει να επιλέξετε τουλάχιστον 1 προτού να μπορέσετε να πατήσετε ok και να απομακρύνετε σωστά αυτό το κουτί διαλόγου.

<!-- KC:setting -->

##### Εκφώνηση πληκτρολογούμενων χαρακτήρων {#toc104}

Πλήκτρο: NVDA+2

Όταν είναι ενεργοποιημένο, το NVDA θα αναγγέλλει όλους τους χαρακτήρες που πατάτε στο πληκτρολόγιο.

<!-- KC:setting -->

##### Εκφώνηση πληκτρολογούμενων λέξεων {#toc105}

Πλήκτρο: NVDA+3

Όταν είναι ενεργοποιημένο, το NVDA θα αναγγέλλει όλες τις λέξεις που γράφετε στο πληκτρολόγιο.

##### Διακοπή εκφώνησης κατά την πληκτρολόγηση χαρακτήρων {#toc106}

Αν είναι ενεργοποιημένη, αυτή η επιλογή θα ορίσει στην ομιλία να διακόπτεται κάθε φορά που ένας χαρακτήρας θα πληκτρολογείται. Αυτό είναι ενεργοποιημένο εξορισμού.

##### Διακοπή εκφώνησης με το πλήκτρο enter {#toc107}

Αν είναι ενεργοποιημένη, η επιλογή αυτή θα ορίσει στην ομιλία να διακόπτεται κάθε φορά που χρησιμοποιείται το πλήκτρο enter. Αυτό είναι ενεργοποιημένο εξορισμού.

##### Να επιτρέπεται η γρήγορη πλοήγηση στην ανάγνωση όλων {#toc108}

Αν είναι ενεργοποιημένο, ορισμένες εντολές πλοήγησης (όπως η γρήγορη πλοήγηση στην λειτουργία περιήγησης ή η μετακίνηση ανά γραμμή ή παράγραφο) δεν διακόπτουν την ανάγνωση όλων, αντιθέτως η ανάγνωση όλων μεταφέρεται στην καινούρια θέση και συνεχίζεται η ανάγνωση.

##### Ήχος μπιπ σε περίπτωση πληκτρολόγησης πεζών γραμμάτων όταν το πλήκτρο Κλείδωμα Κεφαλαίων (Caps Lock) είναι ενεργό {#toc109}

Όταν είναι ενεργοποιημένο, ένα προειδοποιητικός ήχος θα ακούγεται όταν πληκτρολογείτε ένα γράμμα μαζί με το πλήκτρο SHIFT όταν το πλήκτρο Κλείδωμα Κεφαλαίων (Caps Lock) είναι ενεργό.
Γενικά, η πληκτρολόγηση γραμμάτων με το SHIFT όταν το Κλείδωμα Κεφαλαίων (Caps Lock) είναι ενεργό είναι μη-σκόπιμη και συνήθως οφείλεται στην παραμέληση απενεργοποίησης του πλήκτρου Κλειδώματος Κεφαλαίων.
Έτσι, μπορεί να είναι χρήσιμο να προειδοποιείστε σχετικά με αυτό.

<!-- KC:setting -->

##### Εκφώνηση πλήκτρων εντολών {#toc110}

Πλήκτρο: NVDA+4

Όταν είναι ενεργοποιημένο, το NVDA αναγγέλλει όλα τα πλήκτρα που πατάτε και που δεν είναι χαρακτήρες. Αυτά περιλαμβάνουν συνδυασμούς πλήκτρων όπως το CONTROL μαζί με κάποιο άλλο γράμμα.

##### Διαχείριση εντολών από άλλες εφαρμογές {#toc111}

η επιλογή αυτή επιτρέπει στον χρήστη να ελέγξει αν πατήματα πλήκτρων που ορίζονται από εφαρμογές όπως εικονικά πληκτρολόγια οθόνης ή λογισμικά αναγνώρισης ομιλίας αν θα πρέπει να επεξεργάζονται από το nvda.
Η επιλογή αυτή είναι ενεργοποιημένη εξορισμού, αν και κάποιοι χρήστες ίσως να επιθυμούν να την απενεργοποιήσουν, όπως αυτοί που γράφουν Βιετναμέζικα με το λογισμικό πληκτρολόγησης Unikey, αφού θα δημιουργήσει λανθασμένη πληκτρολόγηση.

#### Ρυθμίσεις ποντικιού (NVDA+control+m) {#MouseSettings}

Ο διάλογος των Ρυθμίσεων Ποντικιού βρίσκεται στο μενού Προτιμήσεις, κάτω από το "Ρυθμίσεις ποντικιού...".
Περιέχει τις ακόλουθες επιλογές:

##### Αναφορά Αλλαγών του Σχήματος Ποντικιού {#toc113}

Όταν αυτό το κουτί επιλογής είναι τσεκαρισμένο, το NVDA αναγγέλλει το σχήμα του δείκτη του ποντικιού κάθε φορά που αλλάζει.
Ο δείκτης ποντικιού στα Windows αλλάζει σχήμα για να μεταφέρει συγκεκριμένη πληροφορία όπως όταν κάτι είναι επεξεργάσιμο ή όταν κάτι φορτώνει κλπ.

<!-- KC:setting -->

##### Ενεργοποίηση παρακολούθησης ποντικιού {#toc114}

Πλήκτρο: NVDA+m

Όταν είναι ενεργοποιημένη, το NVDA αναγγέλλει το κείμενο που βρίσκεται κάτω από την τρέχουσα θέση του δείκτη ποντικιού. Αυτό σας επιτρέπει να βρίσκετε στοιχεία στην οθόνη, κουνώντας φυσικά το ποντίκι αντί να προσπαθείτε να τα βρείτε μέσω της πλοήγησης αντικειμένου.

##### Ανάλυση μονάδας κειμένου {#toc115}

Αν το NVDA είναι ρυθμισμένο να αναγγέλλει το κείμενο κάτω από το ποντίκι καθώς το κινείτε, αυτή η επιλογή σας επιτρέπει να επιλέξετε πόσο κείμενο θέλετε να εκφωνείται.
Οι επιλογές είναι χαρακτήρας, λέξη, γραμμή και παράγραφος.

##### Αναφορά ρόλου όταν το ποντίκι μπαίνει σε αντικείμενο {#toc116}

Όταν αυτό το κουτί επιλογής είναι τσεκαρισμένο, το NVDA αναγγέλλει τον ρόλο (τύπο) του αντικειμένου καθώς το ποντίκι κινείται μέσα του.

##### Αναπαραγωγή ακουστικών συντεταγμένων κατά την κίνηση του ποντικιού {#toc117}

Αν τσεκάρετε αυτό το κουτί επιλογής, το NVDA θα παίζει ήχους μπιπ καθώς θα κινείτε το ποντίκι, ώστε ο χρήστης να μπορεί να συμπεράνει που βρίσκεται το ποντίκι σε σχέση με τις διαστάσεις της οθόνης.
Όσο πιο ψηλά στην οθόνη βρίσκεται το ποντίκι, τόσο πιο ψηλός θα είναι ο τόνος των ήχων μπιπ.
Όσο πιο αριστερά ή δεξιά βρίσκεται το ποντίκι στην οθόνη, τόσο αριστερά ή δεξιά ο ήχος θα παίζει (υποθέτοντας πως ο χρήστης έχει στερεοφωνικά ηχεία ή ακουστικά.)

##### Έλεγχος της έντασης των ακουστικών συντεταγμένων από τη φωτεινότητα {#toc118}

Αν η επιλογή "αναπαραγωγή ακουστικών συντεταγμένων κατά την κίνηση του ποντικιού" είναι τσεκαρισμένη, τότε επιλέγοντας και αυτή τη ρύθμιση σημαίνει ότι η ένταση των ακουστικών συντεταγμένων θα ελέγχεται από το πόσο φωτεινή είναι η οθόνη στο σημείο κάτω από το δείκτη του ποντικιού.
Αυτή η ρύθμιση είναι εξ ορισμού μη επιλεγμένη.

#### Ρυθμίσεις Δρομέα Εξέτασης {#toc119}

Οι ρυθμίσεις αυτές βρίσκονται στο μενού Προτιμήσεις, κάτω από το "Δρομέας Εξέτασης...".
Ο διάλογος περιέχει τις ακόλουθες επιλογές:

<!-- KC:setting -->

##### Ακολούθηση Εστίασης Συστήματος {#toc120}

Πλήκτρο: NVDA+7

Όταν είναι ενεργοποιημένη, ο Δρομέας Εξέτασης θα τοποθετείται πάντα στο ίδιο αντικείμενο όπως η τρέχουσα Εστίαση Συστήματος όπως αλλάζει.

<!-- KC:setting -->

##### Ακολούθηση Κέρσορα {#toc121}

Πλήκτρο: NVDA+6

Όταν είναι ενεργοποιημένη, ο Δρομέας Εξέτασης θα μετακινείται αυτόματα στη θέση τ		ου Κέρσορα Συστήματος κάθε φορά που μετακινείται.

##### Ακολούθηση Ποντικιού {#toc122}

Όταν είναι ενεργοποιημένη, ο Δρομέας Εξέτασης θα ακολουθεί το ποντίκι όπως κινείται.

##### Λειτουργία Απλής Εξέτασης {#toc123}

Όταν είναι ενεργοποιημένη, το NVDA φιλτράρει την ιεραρχία των αντικειμένων που δύναται να πλοηγηθούν, ώστε να αποκλείσει τα μη χρήσιμα αντικείμενα, όπως για παράδειγμα τα μη-ορατά αντικείμενα ή τα αντικείμενα που χρησιμοποιούνται για σκοπούς οπτικής διάταξης.

#### Ρυθμίσεις Παρουσίασης Αντικειμένου (NVDA+control+o) {#toc124}

Βρίσκεται στο μενού Προτιμήσεις κάτω από το "Παρουσίαση Αντικειμένου...".
Αυτός ο διάλογος περιέχει τις ακόλουθες επιλογές:

##### Αναφορά Επεξηγήσεων (Tool Tips) {#toc125}

Όταν αυτό το κουτί είναι επιλεγμένο, το NVDA αναφέρει τις επεξηγήσεις όπως εμφανίζονται.
Πολλά παράθυρα και στοιχεία ελέγχου εμφανίζουν ένα μικρό πλαίσιο μηνύματος (επεξήγηση) όταν περνάει ο δείκτης του ποντικιού από πάνω τους, ή μερικές φορές το εμφανίζουν όταν μετακινείτε την εστίαση επάνω τους.

##### Αναφορά Μπαλονιών Βοήθειας {#toc126}

Όταν αυτό το κουτί είναι επιλεγμένο, το NVDA αναφέρει τα μπαλόνια βοήθειας όπως εμφανίζονται.
Τα Μπαλόνια Βοήθειας είναι σας τις επεξηγήσεις, αλλά είναι συνήθως μεγαλύτερα σε μέγεθος, και συνδέονται με γεγονότα του συστήματος όπως όταν το καλώδιο δικτύου βγαίνει από τη θέση του, ή πιθανώς για να σας προειδοποιήσουν για θέματα ασφάλειας των Windows.

##### Αναφορά Πλήκτρων Συντόμευσης Αντικειμένου {#toc127}

Όταν αυτό το κουτί είναι επιλεγμένο, το NVDA συμπεριλαμβάνει στην αναφορά των αντικειμένων και των στοιχείων ελέγχου τα πλήκτρα συντόμευσης που συνδέονται με αυτά.
Για παράδειγμα, το μενού Αρχείο σε μία λωρίδα μενού μπορεί να έχει για πλήκτρο συντόμευσης το alt+f.

##### Αναφορά Πληροφορίας Θέσης Αντικειμένου {#toc128}

Αυτή η επιλογή σας επιτρέπει να επιλέξετε αν θέλετε να σας αναφέρεται η θέση ενός αντικειμένου (π.χ. 1 από 4) όταν μετακινείστε στο αντικείμενο με την εστίασης ή την πλοήγηση αντικειμένου.

##### Εικασία Πληροφορίας Θέσης Αντικειμένου όταν δεν είναι διαθέσιμη {#toc129}

Αν η αναφορά της πληροφορίας θέσης αντικειμένου είναι ενεργοποιημένη, αυτή η επιλογή επιτρέπει στο NVDA να κάνει μία εικασία για την πληροφορία θέσης του αντικειμένου όταν αυτή δεν είναι διαθέσιμη με άλλο τρόπο για ένα συγκεκριμένο στοιχείο ελέγχου.

Όταν είναι ενεργοποιημένη, το NVDA αναφέρει την πληροφορία θέσης για περισσότερα στοιχεία ελέγχου όπως τα μενού και οι λωρίδες εργαλείων, ωστόσο αυτή η πληροφορία ενδέχεται να μην είναι ακριβής.

##### Αναφορά Περιγραφών Αντικειμένου {#toc130}

Από-επιλέξτε αυτό το κουτί αν δεν θέλετε να σας αναφέρονται οι περιγραφές μαζί με τα αντικείμενα.

<!-- KC:setting -->

##### Αναπαράσταση Λωρίδας Προόδου {#toc131}

Πλήκτρο: nvda+u

Αυτή η επιλογή ορίζει τον τρόπο με τον οποίο το NVDA θα αναφέρει τις ενημερώσεις Λωρίδων Προόδου σε εσάς.

Έχει τις ακόλουθες επιλογές:

* Απενεργοποιημένο: Οι Λωρίδες Προόδου δεν θα αναφέρονται όπως αλλάζουν.
* Εκφώνηση: Αυτή η επιλογή ορίζει στο NVDA να εκφωνεί τη Λωρίδα Προόδου σε ποσοστά. Κάθε φορά που αλλάζει η Λωρίδα Προόδου, το NVDA εκφωνεί τη νέα τιμή.
* Ήχος μπιπ: Αυτό ορίζει στο NVDA να αναπαράγει ένα μπιπ με αυξανόμενο τόνο κάθε φορά που αλλάζει η Λωρίδα Προόδου. Όσο υψηλότερος ο τόνος του μπιπ, τόσο η λωρίδα πλησιάζει την ολοκλήρωση.
* Ήχος μπιπ και εκφώνηση: Αυτή η επιλογή ορίζει στο NVDA να αναπαράγει ήχους μπιπ και να εκφωνεί τις αλλαγές της λωρίδας.

##### Αναφορά Λωρίδων Προόδου Υποβάθρου {#toc132}

Η επιλογή αυτού του κουτιού, ορίζει στο NVDA να εξακολουθεί να αναφέρει μία Λωρίδα Προόδου ακόμα και αν δεν είναι στο προσκήνιο.
Αν ελαχιστοποιήσετε ή φύγετε από ένα παράθυρο που περιέχει μία Λωρίδα Προόδου, το NVDA θα συνεχίσει να την παρακολουθεί και να την αναπαριστά, επιτρέποντας σας να κάνετε άλλες εργασίες όσο το NVDA παρακολουθεί την λωρίδα.

<!-- KC:setting -->

##### Αναφορά Αλλαγών Δυναμικού Περιεχομένου {#toc133}

Πλήκτρο: NVDA+5

Ενεργοποιεί την αναγγελία νέου περιεχομένου σε συγκεκριμένα αντικείμενα όπως τα τερματικά και το ιστορικό σε προγράμματα chat.

#### Ρυθμίσεις Εισόδου Κειμένου {#toc134}

Το πλαίσιο διαλόγου Ρυθμίσεις Εισόδου Κειμένου, μπορείτε να το βρείτε στο μενού Προτιμήσεις.
Αυτό το πλαίσιο διαλόγου σας επιτρέπει να ελέγξετε πώς το NVDA αναφέρει την είσοδο Ασιατικών χαρακτήρων, όπως με το INE  ή με μεθόδους εισόδου μέσω Υπηρεσιών Κειμένου.
Σημειώστε ότι, λόγω του ότι οι μέθοδοι εισόδου διαφέρουν σημαντικά ως προς τα διαθέσιμα χαρακτηριστικά τους και τον τρόπο που μεταφέρουν πληροφορίες, μάλλον θα χρειαστεί να προσαρμόσετε διαφορετικά αυτές τις επιλογές, για κάθε μέθοδο εισόδου, ώστε να έχετε την καλύτερη δυνατή εμπειρία πληκτρολόγησης.

##### Αυτόματη αναφορά όλων των διαθέσιμων υποψηφίων {#toc135}

Αυτή η επιλογή, η οποία είναι ενεργοποιημένη από προεπιλογή, σας επιτρέπει να επιλέξετε αν όλοι οι ορατοί υποψήφιοι θα πρέπει να αναφέρονται αυτόματα, όταν εμφανίζεται μια λίστα υποψηφίων ή αν η σελίδα τους έχει αλλάξει.
Το να είναι ενεργοποιημένη η επιλογή αυτή για μεθόδους εισόδου εικονογραμμάτων, όπως τα chinese New ChangJie ή τα Boshiami, είναι χρήσιμο, γιατί μπορείτε, αυτόματα, να ακούσετε όλα τα σύμβολα και τους αριθμούς τους, καθώς και να επιλέξετε κάποιο από αυτά αμέσως.
Ωστόσο, για μεθόδους φωνητικής εισόδου, όπως τα chinese New Phonetic, ίσως θα ήταν χρήσιμο να απενεργοποιήσετε αυτήν την επιλογή, καθώς όλα τα σύμβολα θα ακούγονται το ίδιο και θα πρέπει να χρησιμοποιήσετε τα πλήκτρα βέλους για να πλοηγηθείτε σε κάθε στοιχείο της λίστας ξεχωριστά, προκειμένου να λάβετε περισσότερες πληροφορίες από τις περιγραφές του χαρακτήρα, για κάθε υποψήφιο.

##### Αναγγελία Επιλεγμένου Υποψηφίου {#toc136}

Αυτή η επιλογή, που είναι ενεργοποιημένη από προεπιλογή, σας επιτρέπει να επιλέξετε αν το NVDA θα πρέπει να αναγγέλλει τον επιλεγμένο υποψήφιο, όταν εμφανίζεται μια λίστα υποψηφίων ή όταν αλλάζει η επιλογή.
Για μεθόδους εισόδου στις οποίες η επιλογή μπορεί να αλλάξει με τα πλήκτρα βέλους (όπως τα Chinese New Phonetic), αυτό είναι απαραίτητο, αλλά για κάποιες μεθόδους εισόδου, ίσως είναι πιο αποτελεσματικό να πληκτρολογείτε με αυτήν την επιλογή απενεργοποιημένη.
Σημειώστε ότι ακόμα κι αν είναι απενεργοποιημένη αυτή η επιλογή, ο δρομέας επανεξέτασης θα εξακολουθεί να βρίσκεται στον επιλεγμένο υποψήφιο, επιτρέποντάς σας να χρησιμοποιήσετε την πλοήγηση / επανεξέταση αντικειμένου, για να διαβάσετε χειροκίνητα αυτόν ή άλλους υποψηφίους.

##### Να συμπεριλαμβάνονται πάντα σύντομες περιγραφές χαρακτήρων για τους υποψηφίους {#toc137}

Αυτή η επιλογή, που είναι ενεργοποιημένη από προεπιλογή, σας επιτρέπει να επιλέξετε αν το NVDA θα παρέχει μια σύντομη περιγραφή για κάθε χαρακτήρα σε έναν υποψήφιο, είτε όταν είναι επιλεγμένος είτε όταν γίνεται ανάγνωση αυτού, όταν εμφανίζεται η λίστα υποψηφίου.
Σημειώστε ότι για συγκεκριμένες γλώσσες, όπως τα Κινεζικά, η αναγγελία επιπλέον περιγραφών χαρακτήρων για τον επιλεγμένο υποψήφιο, δεν επηρεάζεται από αυτήν την επιλογή.
Αυτή η επιλογή μπορεί να είναι χρήσιμη για μεθόδους εισόδου Κορεατικών ή Ιαπωνικών.

##### Αναφορά αλλαγών στον κώδικα ανάγνωσης {#toc138}

Κάποιες μέθοδοι εισόδου, όπως τα Chinese New Phonetic και τα New ChangJie, έχουν κώδικα ανάγνωσης (γνωστό και ως κώδικα προμεταγλώττισης).
Μπορείτε να επιλέξετε αν το NVDA θα πρέπει να αναγγέλλει νέους χαρακτήρες που εισάγονται σε αυτόν τον κώδικα ανάγνωσης, με αυτήν την επιλογή.
Αυτή η επιλογή είναι ενεργοποιημένη από προεπιλογή.
Σημειώστε ότι κάποιες παλαιότερες μέθοδοι εισόδου, όπως τα Chinese ChangJie, μπορεί να μη χρησιμοποιούν τον κώδικα ανάγνωσης για να κρατήσουν προμεταγλωττισμένους χαρακτήρες, αλλά αντ’ αυτού να χρησιμοποιούν τον κώδικα εισόδου απευθείας. Παρακαλώ δείτε την επόμενη επιλογή για τη διαμόρφωση αναφοράς του κώδικα εισόδου.

##### Αναφορά αλλαγών στον κώδικα εισόδου {#toc139}

Μετά την ανάγνωση, ή εφόσον τα δεδομένα προμεταγλώττισης έχουν συνδυαστεί σε έγκυρο σύμβολο εικονογράμματος, οι περισσότερες μέθοδοι τοποθετούν αυτό το σύμβολο σε κώδικα εισόδου για προσωρινή αποθήκευση, μαζί με άλλα συνδυασμένα σύμβολα, πριν τελικά εισαχθούν στο έγγραφο.
Αυτή η επιλογή σας επιτρέπει να επιλέξετε αν το NVDA θα πρέπει να αναφέρει τα νέα σύμβολα, καθώς εμφανίζονται στον κώδικα εισόδου.
Αυτή η επιλογή είναι ενεργοποιημένη από προεπιλογή.

#### Ρυθμίσεις Λειτουργίας Περιήγησης (NVDA+control+b) {#toc140}

Ο διάλογος ρυθμίσεων της Λειτουργίας Περιήγησης βρίσκεται στο μενού Προτιμήσεις, κάτω από το "Λειτουργία περιήγησης...".

Ο διάλογος περιέχει τις ακόλουθες επιλογές:

##### Μέγιστος Αριθμός Χαρακτήρων σε μία Γραμμή {#toc141}

Αυτό το πεδίο ορίζει το μέγιστο μήκος (σε χαρακτήρες) μίας γραμμής σε Λειτουργία Περιήγησης.

##### Μέγιστος Αριθμός Γραμμών ανά Σελίδα {#toc142}

Αυτό το πεδίο ορίζει τον αριθμό των γραμμών που θα κινείστε όταν πατάτε τα page up ή page down σε Λειτουργία Περιήγησης.

<!-- KC:setting -->

##### Χρήση Διάταξης Οθόνης {#toc143}

Πλήκτρο: NVDA+v

Αυτή η επιλογή σας επιτρέπει να διευκρινίσετε αν το περιεχόμενο στη Λειτουργία Περιήγησης μπορεί να τοποθετεί στοιχεία όπως οι σύνδεσμοι και άλλα πεδία σε δική τους ξεχωριστή γραμμή, ή αν θα πρέπει να τα κρατάει εντός της ροής του κειμένου όπως εμφανίζονται οπτικά. Αν η επιλογή είναι ενεργοποιημένη, τότε όλα θα μείνουν όπως φαίνονται οπτικά, ενώ αν είναι απενεργοποιημένη τότε τα πεδία θα τοποθετούνται σε δική τους γραμμή.

##### Αυτόματη Εκφώνηση Όλων κατά τη φόρτωση της σελίδας {#toc144}

Αυτή η επιλογή ενεργοποιεί και απενεργοποιεί την αυτόματη εκφώνηση μίας σελίδας αμέσως μόλις φορτωθεί σε Λειτουργία Περιήγησης.
Αυτή η επιλογή είναι εξ ορισμού ενεργοποιημένη.

##### Αναφορά Πινάκων Διάταξης {#toc145}

Όταν είναι απενεργοποιημένη, αυτή η επιλογή ορίζει στο NVDA να αναφέρει μόνο πίνακες που περιέχουν δεδομένα (δηλαδή, όπου έχει νόημα να ξέρετε ότι αυτό είναι πίνακας).
Όταν είναι ενεργοποιημένη, το NVDA αναφέρει επίσης πίνακες που χρησιμοποιούνται αποκλειστικά για την οπτική διάταξη στοιχείων της σελίδας.

##### Διαμόρφωση αναφοράς πεδίων όπως σύνδεσμοί και επικεφαλίδες {#toc146}

Δείτε τις επιλογές στο διάλογο [Ρυθμίσεις Μορφοποίησης Εγγράφου](#DocumentFormattingSettings) για να διαμορφώσετε τα πεδία που αναφέρονται κατά την πλοήγηση όπως οι σύνδεσμοι, οι επικεφαλίδες και οι πίνακες.

##### Αυτόματη Λειτουργία Εστίασης κατά τις αλλαγές εστίασης {#toc147}

Αυτή η επιλογή σας επιτρέπει να καλείτε τη Λειτουργία Εστίασης αν αλλάζει η εστίαση.
Για παράδειγμα, όταν βρίσκεστε σε μία ιστοσελίδα, αν πατήσετε TAB και τοποθετηθείτε σε μία φόρμα, με αυτή την επιλογή θα κληθεί αυτόματα η Λειτουργία Εστίασης.

##### Αυτόματη Λειτουργία Εστίασης κατά τις κινήσεις του κέρσορα {#toc148}

Η ενεργοποίηση αυτής της επιλογής επιτρέπει στο NVDA να εισέρχεται και να εξέρχεται από τη Λειτουργία Εστίασης όταν χρησιμοποιείτε τα πλήκτρα με τα βέλη.
Για παράδειγμα, αν σε μία ιστοσελίδα πηγαίνετε με τα βέλη προς τα κάτω και τοποθετηθείτε σε ένα κουτί επεξεργασίας κειμένου, το NVDA θα σας γυρίσει αυτόματα σε Λειτουργία Εστίασης. Αν με τα βέλη βγείτε έξω από το κουτί επεξεργασίας, το NVDA θα σας γυρίσει σε Λειτουργία Περιήγησης.

##### Ηχητική Ένδειξη των λειτουργιών Εστίασης και Περιήγησης {#toc149}

Αν αυτή η επιλογή είναι ενεργοποιημένη, το NVDA αναπαράγει ειδικούς ήχους όταν εναλλάσσει τις Λειτουργίες Περιήγησης και Εστίασης, αντί να εκφωνεί την αλλαγή.

##### Περιορισμός των χειρονομιών που δεν αφορούν σε εντολές για να μην επηρεάζεται το έγγραφο {#toc150}

Ενεργοποιημένη εξορισμού, η επιλογή αυτή σας επιτρέπει να επιλέξετε αν χειρονομίες (όπως πατήματα πλήκτρων) τα οποία δεν αποτελούν κάποια εντολή του nvda, και δεν θεωρούνται πλήκτρα εντολών γενικότερα, αν θα περιορίζονται στο να μεταβαίνουν στο έγγραφο στο οποίο εκείνη τη στιγμή εστιάζετε.
Ως ένα παράδειγμα, αν είναι ενεργοποιημένο, αν το γράμμα j πληκτρολογηθεί θα περιοριστεί στο να φτάσει στο έγγραφο έστο και αν το j δεν αποτελεί εντολή γρήγορης πλοήγησης και ούτε ενδέχεται να αποτελεί εντολή της καθαυτού εφαρμογής.

#### Ρυθμίσεις Μορφοποίησης Εγγράφων (NVDA+control+d) {#DocumentFormattingSettings}

Αυτός ο διάλογος βρίσκεται στο μενού Προτιμήσεις, κάτω από το "Μορφοποίηση εγγράφων...".

Οι περισσότερες επιλογές σε αυτόν τον διάλογο είναι για να ρυθμίσετε τα είδη μορφοποίησης που θέλετε να σας αναγγέλλονται καθώς μετακινείτε τον κέρσορα μέσα στα έγγραφα.
Για παράδειγμα, αν επιλέξετε το κουτί της αναφοράς του ονόματος γραμματοσειράς, κάθε φορά που μετακινείστε με τα βέλη σε κείμενο με διαφορετική γραμματοσειρά, θα αναγγέλλεται το όνομα της γραμματοσειράς

Μπορείτε να ρυθμίσετε την αναφορά των παρακάτω:

* Όνομα γραμματοσειράς
* Μέγεθος γραμματοσειράς
* Ιδιότητες γραμματοσειράς
* Στοίχιση κειμένου
* Χρώμα
* Στυλ κειμένου
* Ορθογραφικά λάθη
* Αριθμοί σελίδων
* Αριθμοί γραμμών
* Εσοχές γραμμών
* Πίνακες
* Επικεφαλίδες γραμμών/στηλών πινάκων
* Συντεταγμένες κελιών πινάκων
* Σύνδεσμοι
* Επικεφαλίδες
* Λίστες
* Μπλοκ παραπομπών
* Ορόσημα
* Πλαίσια

##### Αναγγελία Αλλαγών Μορφοποίησης μετά το δρομέα {#toc152}

Αν είναι ενεργοποιημένη, αυτή η επιλογή ορίζει στο NVDA να προσπαθεί να εντοπίσει όλες τις αλλαγές μορφοποίησης σε μία γραμμή καθώς τη διαβάζει, ακόμα και αν με τον τρόπο αυτό επιβραδύνεται η απόδοση του NVDA.

Εξ ορισμού, το NVDA θα εντοπίσει τη μορφοποίηση στη θέση του Κέρσορα Συστήματος / Δρομέα Εξέτασης, και σε μερικές περιπτώσεις μπορεί να εντοπίσει τη μορφοποίηση της υπόλοιπης γραμμής, μόνο αν κάτι τέτοιο δεν επιβαρύνει την απόδοση.

Ενεργοποιήστε αυτή την επιλογή όταν κάνετε τυπογραφική διόρθωση σε εφαρμογές όπως το Microsoft Word, όπου η μορφοποίηση είναι σημαντική.

### Προφίλ Διαμόρφωσης {#toc153}

Κάποιες φορές, ίσως επιθυμείτε να έχετε διαφορετικές ρυθμίσεις για διαφορετικές καταστάσεις.
Για παράδειγμα, ίσως επιθυμείτε να είναι ενεργή η αναφορά εσοχής, όταν επεξεργάζεστε, ή ενεργή η αναφορά χαρακτηριστικών κειμένου, όταν κάνετε γλωσσικό έλεγχο κειμένου.
Το NVDA σας επιτρέπει να το κάνετε αυτό χρησιμοποιώντας τα προφίλ διαμόρφωσης.

Ένα προφίλ διαμόρφωσης περιλαμβάνει μόνο εκείνες τις ρυθμίσεις που έχουν αλλάξει κατά το χρόνο επεξεργασίας του προφίλ.
Οι περισσότερες ρυθμίσεις μπορούν να αλλάξουν, στα προφίλ διαμόρφωσης, με εξαίρεση αυτές στο πλαίσιο διαλόγου των γενικών ρυθμίσεων, οι οποίες αφορούν σε ολόκληρο το NVDA.

Τα προφίλ διαμόρφωσης μπορούν να ενεργοποιηθούν χειροκίνητα.
Μπορούν, επίσης, να ενεργοποιηθούν αυτόματα λόγω σκανδαλισμών, όπως η αλλαγή σε μια συγκεκριμένη εφαρμογή.

#### Βασική Διαχείριση {#toc154}

Μπορείτε να διαχειριστείτε τα προφίλ διαμόρφωσης, επιλέγοντας “Προφίλ διαμόρφωσης“ στο μενού του NVDA.
Εναλλακτικά, μπορείτε να χρησιμοποιήσετε την ακόλουθη εντολή:
<!-- KC:beginInclude -->

* NVDA+control+p: Εμφάνιση του πλαισίου διαλόγου για τα προφίλ διαμόρφωσης.

<!-- KC:endInclude -->

Το πρώτο στοιχείο ελέγχου, σε αυτό το πλαίσιο διαλόγου, είναι η λίστα των προφίλ από την οποία μπορείτε να επιλέξετε ένα από τα διαθέσιμα προφίλ.
Όταν ανοίξετε το πλαίσιο διαλόγου, το προφίλ που επεξεργάζεστε είναι επιλεγμένο.
Επιπλέον πληροφορίες εμφανίζονται για ενεργά προφίλ, ενημερώνοντάς σας αν έχουν ενεργοποιηθεί χειροκίνητα, σκανδαλιστεί και/ή υφίστανται επεξεργασία.

Για να μετονομάσετε ή να διαγράψετε ένα προφίλ, πατήστε τα κουμπιά Μετονομασία ή Διαγραφή, αντίστοιχα.

Πατήστε το κουμπί Κλείσιμο για να κλείσετε το πλαίσιο διαλόγου.

#### Δημιουργία Προφίλ {#toc155}

Για να δημιουργήσετε ένα προφίλ, πατήστε το κουμπί Νέο.

Στο πλαίσιο διαλόγου Νέο Προφίλ, μπορείτε να εισάγετε ένα όνομα για το προφίλ.
Μπορείτε, επίσης, να επιλέξετε πώς θα πρέπει να χρησιμοποιηθεί αυτό το προφίλ.
Αν θέλετε να χρησιμοποιήσετε αυτό το προφίλ μόνο χειροκίνητα, επιλέξτε Χειροκίνητη Ενεργοποίηση, η οποία είναι και η προεπιλεγμένη ρύθμιση.
Διαφορετικά, επιλέξτε ένα σκανδαλισμό ο οποίος θα πρέπει να ενεργοποιεί αυτό το προφίλ.
Για δική σας ευκολία, αν δεν έχετε εισάγει όνομα για το προφίλ, η επιλογή σκανδαλισμού θα συμπληρώσει το όνομα ανάλογα.
Δείτε το τμήμα [below](#ConfigProfileTriggers) για περισσότερες πληροφορίες σχετικά με τους σκανδαλισμούς.

Αν πατήσετε OK, θα δημιουργηθεί το προφίλ και θα κλείσει το πλαίσιο διαλόγου Προφίλ Διαμόρφωσης, έτσι ώστε να μπορείτε να επεξεργαστείτε το προφίλ.

#### Χειροκίνητη Ενεργοποίηση {#ConfigProfileManual}

Μπορείτε χειροκίνητα να ενεργοποιήσετε ένα προφίλ, επιλέγοντας ένα προφίλ και πατώντας το κουμπί Χειροκίνητη Ενεργοποίηση.
Όταν ενεργοποιηθεί το προφίλ, κι άλλα προφίλ μπορούν ακόμα να ενεργοποιηθούν λόγω σκανδαλισμών, αλλά οι ρυθμίσεις στο χειροκίνητα ενεργοποιημένο προφίλ θα υπερισχύσουν.
Για παράδειγμα, αν ένα προφίλ ενεργοποιηθεί από σκανδαλισμό για την τρέχουσα εφαρμογή και η αναφορά συνδέσμων είναι ενεργή για αυτό το προφίλ, αλλά μη ενεργή στο χειροκίνητα ενεργοποιημένο προφίλ, οι σύνδεσμοι δε θα αναφέρονται.
Ωστόσο, αν έχετε αλλάξει τη φωνή στο προφίλ που ξεκίνησε, αλλά όχι στο χειροκίνητα ενεργοποιημένο προφίλ, θα χρησιμοποιηθεί η φωνή από το προφίλ που ξεκίνησε.
Όσες ρυθμίσεις αλλάξετε, θα αποθηκευτούν στο χειροκίνητα ενεργοποιημένο προφίλ.
Για να απενεργοποιήσετε ένα χειροκίνητα ενεργοποιημένο προφίλ, επιλέξτε το στο πλαίσιο διαλόγου Προφίλ Διαμόρφωσης και πατήστε το κουμπί Χειροκίνητη Απενεργοποίηση.

#### Σκανδαλισμοί {#ConfigProfileTriggers}

Πατώντας το κουμπί Σκανδαλισμοί, στο πλαίσιο διαλόγου Προφίλ Διαμόρφωσης, μπορείτε να αλλάξετε τα προφίλ που θα πρέπει να ενεργοποιούνται για διαφορετικά εναύσματα.

Η λίστα των σκανδαλισμών εμφανίζει τους διαθέσιμους σκανδαλισμούς, οι οποίοι έχουν ως εξής:

* Τρέχουσα εφαρμογή: Δίνεται έναυσμα όταν αλλάζετε στην τρέχουσα εφαρμογή.
* Ανάγνωση όλων: Δίνεται έναυσμα όταν γίνεται ανάγνωση με την εντολή Ανάγνωση Όλων.

Για να αλλάξετε το προφίλ που θα πρέπει να ενεργοποιείται αυτόματα για ένα έναυσμα, επιλέξτε το σκανδαλισμό και μετά επιλέξτε το επιθυμητό προφίλ από τη λίστα των προφίλ.
Μπορείτε να επιλέξετε (κανονική διαμόρφωση) αν δε θέλετε να χρησιμοποιηθεί κανένα προφίλ.

Πατήστε Κλείσιμο για να επιστρέψετε στο πλαίσιο διαλόγου Προφίλ Διαμόρφωσης.

#### Επεξεργασία Προφίλ {#toc158}

Αν έχετε ενεργοποιήσει χειροκίνητα ένα προφίλ, όσες ρυθμίσεις αλλάξετε θα αποθηκευτούν σε αυτό το προφίλ.
Διαφορετικά, όσες ρυθμίσεις αλλάξετε θα αποθηκευτούν στο πιο πρόσφατα ενεργοποιημένο προφίλ.
Για παράδειγμα, αν έχετε συνδέσει ένα προφίλ με την εφαρμογή Σημειωματάριο και αλλάξετε σε Σημειωματάριο, όσες ρυθμίσεις έχουν αλλάξει θα αποθηκευτούν σε αυτό το προφίλ.
Τέλος, αν δεν υπάρχει ούτε χειροκίνητα ενεργοποιημένο ούτε ενεργοποιημένο προφίλ, όσες ρυθμίσεις αλλάξετε θα αποθηκευτούν στην κανονική διαμόρφωση.

Για να επεξεργαστείτε το προφίλ που συνδέεται με την Ανάγνωση όλων, πρέπει χειροκίνητα να ενεργοποιήσετε #ConfigProfileManual] αυτό το προφίλ.

#### Προσωρινή Απενεργοποίηση Σκανδαλισμών {#toc159}

Κάποιες φορές, είναι χρήσιμο να απενεργοποιήσετε όλους τους σκανδαλισμούς.
Για παράδειγμα, ίσως επιθυμείτε να επεξεργαστείτε ένα χειροκίνητα ενεργοποιημένο προφίλ ή την κανονική διαμόρφωση χωρίς να παρεμβαίνουν ενεργοποιημένα προφίλ.
Μπορείτε να το κάνετε αυτό, επιλέγοντας το κουτί επιλογής Προσωρινή Απενεργοποίηση Όλων Των Σκανδαλισμών, στο πλαίσιο διαλόγου Προφίλ Διαμόρφωσης.

### Θέση Αρχείων Διαμόρφωσης {#toc160}

Οι φορητές εκδόσεις του NVDA αποθηκεύουν όλες τις ρυθμίσεις, τα προσαρμοσμένα appModules και τους προσαρμοσμένους οδηγούς σε ένα φάκελο που ονομάζεται userConfig, ο οποίος βρίσκεται στο φάκελο NVDA.

Οι εγκατεστημένες εκδόσεις του NVDA αποθηκεύουν όλες τις ρυθμίσεις, τα προσαρμοσμένα appModules και τους προσαρμοσμένους οδηγούς σε έναν ειδικό φάκελο του NVDA που βρίσκεται στο προφίλ χρήστη των Windows.
Αυτό σημαίνει ότι κάθε χρήστης στο σύστημα μπορεί να έχει τις δικές του ρυθμίσεις για το NVDA.
Για να μεταβείτε στο φάκελο των ρυθμίσεων για μια εγκατεστημένη έκδοση του NVDA, στο μενού Έναρξη πηγαίνετε στα Προγράμματα -> NVDA -> explore user configuration directory.

Οι ρυθμίσεις του NVDA, όταν τρέχει στις οθόνες σύνδεσης ή UAC, αποθηκεύονται στο φάκελο systemConfig, στο φάκελο εγκατάστασης του NVDA.
Συνήθως, αυτή η διαμόρφωση δε θα πρέπει να αγγίζεται.
Για να αλλάξετε τη διαμόρφωση του NVDA στις οθόνες σύνδεσης/UAC, διαμορφώστε το NVDA όπως επιθυμείτε, ενώ είστε συνδεδεμένοι στα Windows, αποθηκεύστε τη διαμόρφωση και πατήστε το κουμπί ”Χρήση αποθηκευμένων ρυθμίσεων στην οθόνη σύνδεσης και άλλες ασφαλείς οθόνες”, στο πλαίσιο διαλόγου Γενικές Ρυθμίσεις.

## Επιπλέον Εργαλεία {#toc161}
### Προβολέας Αρχείου Καταγραφής Συμβάντων {#toc162}

Ο προβολέας του αρχείου καταγραφής συμβάντων, που βρίσκεται κάτω από τα Εργαλεία στο μενού του NVDA, σας επιτρέπει να δείτε όλες τις εξαγωγές του αρχείου καταγραφής συμβάντων έως αυτή τη στιγμή από την τελευταία φορά που εκκινήσατε το NVDA..

Εκτός από την ανάγνωση του περιεχομένου, μπορείτε επίσης να αποθηκεύσετε ένα αντίγραφο του αρχείου καταγραφής συμβάντων ή να ανανεώσετε τον προβολέα, έτσι ώστε να εμφανίζεται η πιο πρόσφατη εξαγωγή από την τελευταία φορά που ανοίξατε τον προβολέα αρχείου καταγραφής συμβάντων.
Αυτές οι ενέργειες είναι διαθέσιμες στο μενού του προβολέα καταγραφής συμβάντων.

### Προβολέας Εκφώνησης {#toc163}

Για προγραμματιστές χωρίς πρόβλημα όρασης ή ανθρώπους που παρουσιάζουν το NVDA σε κοινό χωρίς πρόβλημα όρασης, διατίθεται αναδυόμενο παράθυρο που σας επιτρέπει να δείτε όλο το κείμενο που εκφωνεί το NVDA τη δεδομένη στιγμή.

Για να ενεργοποιήσετε τον προβολέα εκφώνησης, επιλέξετε προβολέας εκφώνησης στα Εργαλεία υπό το μενού του NVDA.

επιλέξετε το στοιχείο του μενού, για να το απενεργοποιήσετε.

Όταν ο προβολέας εκφώνησης είναι ενεργοποιημένος, ενημερώνεται συνεχώς για να σας δείξει το πιο πρόσφατο κείμενο που εκφωνείται.
Ωστόσο, αν κάνετε κλικ ή εστιάσετε εντός του προβολέα, το NVDA θα σταματήσει προσωρινά να ενημερώνει το κείμενο, έτσι ώστε εύκολα να μπορείτε να επιλέξετε ή να αντιγράψετε το τρέχον περιεχόμενο.

### Διαχειριστής Πρόσθετων {#toc164}

Ο διαχειριστής των πρόσθετων, ο οποίος ενεργοποιείται όταν επιλέξετε Διαχείριση Πρόσθετων κάτω από τα Εργαλεία στο μενού του NVDA, σας επιτρέπει να εγκαθιστάτε και να απεγκαθιστάτε πακέτα πρόσθετων για το NVDA.
Αυτά τα πακέτα προσφέρονται από την κοινότητα και περιέχουν κώδικα που μπορεί να προσθέσει ή να αλλάξει λειτουργίες για το NVDA ή ακόμα και να παρέχει υποστήριξη για επιπλέον οθόνες braille ή συνθέτες φωνής.

Ο διαχειριστής των πρόσθετων περιέχει μια λίστα που εμφανίζει όλα τα πρόσθετα που είναι εγκατεστημένα στη διαμόρφωση χρήστη του NVDA.
Το όνομα του πακέτου, η έκδοση και ο δημιουργός εμφανίζονται για κάθε πρόσθετο, αν και περισσότερες πληροφορίες όπως μια περιγραφή και ένα URL μπορούν να προβληθούν αφού επιλέξετε το πρόσθετο και πατήσετε το κουμπί Σχετικά.
Αν διατίθεται βοήθεια για το συγκεκριμένο πρόσθετο, μπορείτε να την εμφανίσετε αν πατήσετε το κουμπί Βοήθεια του πρόσθετου.

Για να αναζητήσετε και να κατεβάσετε διαθέσιμα πρόσθετα από το διαδίκτυο, πατήστε το κουμπί Λήψη Πρόσθετων.
Αυτό το κουμπί ανοίγει τη σελίδα των πρόσθετων του NVDA https://addons.nvda-project.org/].
Αν το NVDA είναι εγκατεστημένο και τρέχει στο σύστημά σας, μπορείτε να ανοίξετε το πρόσθετο κατ’ ευθείαν από τον περιηγητή για να αρχίσει η διαδικασία εγκατάστασης, όπως περιγράφεται παρακάτω.
Διαφορετικά, αποθηκεύσετε το πακέτο του πρόσθετου και ακολουθήστε τις παρακάτω οδηγίες.

Για να εγκαταστήσετε ένα πρόσθετο που έχετε ήδη αποκτήσει, πατήστε το κουμπί Εγκατάσταση.
Αυτό θα σας επιτρέψει να αναζητήσετε ένα πακέτο πρόσθετου (αρχείο .nvda-addon) κάπου στον υπολογιστή σας ή σε κάποιο δίκτυο.
Όταν πατήσετε Άνοιγμα, η διαδικασία της εγκατάστασης θα αρχίσει.

Όταν γίνεται η εγκατάσταση ενός πρόσθετου, το NVDA θα σας ζητήσει αρχικά να επιβεβαιώσετε ότι πράγματι επιθυμείτε να εγκαταστήσετε το πρόσθετο.
Καθώς η λειτουργικότητα των πρόσθετων είναι απεριόριστη εντός του NVDA, το οποίο θεωρητικά μπορεί να σημαίνει πρόσβαση σε προσωπικά σας στοιχεία ή ακόμα και σε όλο το σύστημα, αν το NVDA είναι εγκατεστημένο αντίγραφο, είναι πολύ σημαντικό να εγκαθιστάτε πρόσθετα από πηγές που εμπιστεύεστε.
Όταν εγκατασταθεί το πρόσθετο, πρέπει να γίνει επανεκκίνηση του NVDA για να αρχίσει να τρέχει το πρόσθετο.
Μέχρι να γίνει αυτό, ένα μήνυμα για την εγκατάσταση αυτού του πρόσθετου θα εμφανίζεται στη λίστα.

Για να αφαιρέσετε ένα πρόσθετο, επιλέξετε το πρόσθετο από τη λίστα και πατήστε το κουμπί Αφαίρεση.
Το NVDA θα ρωτήσει αν πράγματι θέλετε να το κάνετε αυτό.
Όπως και με την εγκατάσταση, πρέπει να γίνει επανεκκίνηση του NVDA για να αφαιρεθεί πλήρως το πρόσθετο.
Μέχρι να γίνει αυτό, ένα μήνυμα για την αφαίρεση αυτού του πρόσθετου θα εμφανίζεται στη λίστα.

Ο διαχειριστής έχει επίσης κουμπί Κλείσιμο για να κλείσετε το παράθυρο διαλόγου.
Αν έχετε εγκαταστήσει ή αφαιρέσει πρόσθετα, το NVDA αρχικά θα σας ρωτήσει αν θέλετε να γίνει επανεκκίνηση έτσι ώστε να ισχύσουν οι αλλαγές.

Στο παρελθόν ήταν δυνατό να επεκταθεί η λειτουργικότητα του NVDA με την αντιγραφή συγκεκριμένων πρόσθετων και οδηγών στο φάκελο της διαμόρφωσης χρήστη του NVDA.
Αν και η έκδοση αυτή του NVDA μπορεί ακόμα να τα φορτώνει, δε θα εμφανίζονται στο διαχειριστή των πρόσθετων.
Είναι προτιμότερο να αφαιρέσετε αυτά τα αρχεία από τη διαμόρφωσή σας και να εγκαταστήσετε το κατάλληλο πρόσθετο, αν διατίθεται.

### Κονσόλα Python {#toc165}

Η κονσόλα Python του NVDA, που βρίσκεται στα Εργαλεία στο μενού του NVDA, είναι ένα αναπτυξιακό εργαλείο χρήσιμο για την αποσφαλμάτωση, τη γενική επιθεώρηση του εσωτερικού του NVDA ή την εξέταση της ιεραρχίας στην προσβασιμότητα μιας εφαρμογής.
Για περισσότερες πληροφορίες, παρακαλώ επισκεφθείτε το εγχειρίδιο για προγραμματιστές που διατίθεται στο τμήμα ανάπτυξης της σελίδας του NVDA https://community.nvda-project.org/wiki/Development].

### Επαναφόρτωση plugins {#toc166}

Αυτό το στοιχείο, όταν ενεργοποιηθεί, επαναφορτώνει modules εφαρμογών και καθολικά plugins χωρίς επανεκκίνηση του NVDA, το οποίο μπορεί να φανεί χρήσιμο στους προγραμματιστές.

## Υποστηριζόμενοι Συνθέτες φωνής {#SupportedSpeechSynths}

Αυτό το κεφάλαιο περιέχει πληροφορίες σχετικές με τους συνθέτες ομιλίας που υποστηρίζει το NVDA.
Για μία πιο πλήρη λίστα δωρεάν και εμπορικών συνθετών που μπορείτε να αγοράσετε και κατεβάσετε για να τους χρησιμοποιήσετε με το NVDA, παρακαλούμε δείτε τη σελίδα [https://www.nvda-project.org/wiki/ExtraVoices](https://www.nvda-project.org/wiki/ExtraVoices).

### eSpeak {#toc168}

Ο συνθέτης [eSpeak](https://espeak.sourceforge.net/) είναι απευθείας ενσωματωμένος στο NVDA και δεν απαιτεί άλλους ειδικούς οδηγούς ή συστατικά για να εγκατασταθεί.
Το NVDA εξ ορισμού χρησιμοποιεί τον eSpeak.
Καθώς αυτός ο συνθέτης είναι ενσωματωμένος στο NVDA, αυτή είναι μία πολύ καλή επιλογή για όταν τρέχετε το NVDA από ένα USB δισκάκι σε άλλο σύστημα.

Κάθε φωνή που έχει το eSpeak μιλάει μία διαφορετική γλώσσα.
Υπάρχουν περισσότερες από 43 διαφορετικές γλώσσες που υποστηρίζονται από το eSpeak.

Υπάρχουν επίσης πολλές παραλλαγές οι οποίες μεταβάλουν τον ήχο της φωνής.

### Microsoft Speech API έκδοση 4 (SAPI 4) {#toc169}

Το SAPI 4 είναι ένα παλαιότερο πρότυπο της Microsoft για συνθέτες ομιλίας.
Πολλοί συνθέτες ομιλίας που συμμορφώνονται με αυτό το πρότυπο μπορούν να αγοραστούν ή να μεταφορτωθούν από διάφορες εταιρείες και ιστοσελίδες.
Όταν χρησιμοποιείτε αυτό το συνθέτη με το NVDA, η λίστα των διαθέσιμων φωνών (προσβάσιμες από το [διάλογο Ρυθμίσεων Φωνής](#VoiceSettings) ή από τον [Δακτύλιο Ρυθμίσεων Συνθέτη](#SynthSettingsRing)) θα περιλαμβάνει όλες τις φωνές από όλες τις εγκατεστημένες μηχανές SAPI 4 στο σύστημα σας.

Αν έχετε εγκαταστήσει φωνές SAPI 4 αλλά ο συνθέτης δεν εμφανίζεται στη λίστα των συνθετών του NVDA, παρακαλούμε να εγκαταστήσετε το αρχείο εκτέλεσης του SAPI 4, διαθέσιο από τη διεύθυνση https://activex.microsoft.com/activex/controls/sapi/spchapi.exe.

### Microsoft Speech API έκδοση 5 (SAPI 5) {#toc170}

Το SAPI 5 είναι ένα πρότυπο της Microsoft για συνθέτες ομιλίας.
Πολλοί συνθέτες ομιλίας που συμμορφώνονται με αυτό το πρότυπο μπορούν να αγοραστούν ή να μεταφορτωθούν από διάφορες εταιρείες και ιστοσελίδες, αν και το σύστημα σας πιθανώς να έχει τουλάχιστον μία φωνή SAPI 5 προ-εγκατεστημένη. Σημείωση μεταφραστή: Αυτό δεν ισχύει για τα Ελληνικά.
Όταν χρησιμοποιείτε αυτό το συνθέτη με το NVDA, η λίστα των διαθέσιμων φωνών (προσβάσιμες από το [διάλογο Ρυθμίσεων Φωνής](#VoiceSettings) ή από τον [Δακτύλιο Ρυθμίσεων Συνθέτη](#SynthSettingsRing)) θα περιλαμβάνει όλες τις φωνές από όλες τις εγκατεστημένες μηχανές SAPI 5 στο σύστημα σας.

### Microsoft Speech Platform {#toc171}

Η Microsoft Speech Platform παρέχει φωνές για πολλές γλώσσες (σημείωση μεταφραστή: όχι για τα Ελληνικά) που συνήθως χρησιμοποιούνται για την ανάπτυξη εφαρμογών ομιλίας που τρέχουν σε διακομιστές.
Αυτές οι φωνές μπορούν επίσης να χρησιμοποιηθούν με το NVDA.

Για να χρησιμοποιήσετε αυτές τις φωνές, χρειάζεται να εγκαταστήσετε δύο συστατικά:

* Microsoft Speech Platform - Runtime (Version 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Version 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * Αυτή η σελίδα περιλαμβάνει πολλά αρχεία τόσο για σύνθεση όσο και για αναγνώριση ομιλίας.
 Επιλέξτες τα αρχεία που περιλαμβάνουν τα δεδομένα TTS για τις επιθυμητές γλώσσες/φωνές.
 Για παράδειγμα, το αρχείο MSSpeech_TTS_en-US_ZiraPro.msi είναι μία φωνή για Αγγλικά Αμερικής.

## Υποστηριζόμενες Οθόνες Braille {#SupportedBrailleDisplays}

Το τμήμα αυτό περιλαμβάνει πληροφορίες για τις οθόνες braille που υποστηρίζονται από το NVDA.

### Σειρά Focus/PAC Mate από τη Freedom Scientific {#toc173}

Όλες οι οθόνες Focus και PAC Mate από τη [Freedom Scientific](https://www.freedomscientific.com/) υποστηρίζονται όταν συνδεθούν μέσω USB ή bluetooth. 
Θα χρειαστεί να εγκαταστήσετε τους οδηγούς της Freedom Scientific για τις οθόνες braille στο σύστημά σας. 
Αν δεν τους διαθέτετε ήδη, μπορείτε να τους αποκτήσετε από το https://www.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp.
Παρότι αυτή η σελίδα αναφέρει μόνο την οθόνη Focus Blue, οι οδηγοί υποστηρίζουν όλες τις οθόνες Focus και Pacmate της Freedom Scientific. 
Αν το σύστημά σας τρέχει Windows 64 bit και οι οδηγοί είχαν ήδη εγκατασταθεί από άλλον αναγνώστη οθόνης, πιθανώς πρέπει να εγκαταστήσετε τους οδηγούς από τον παραπάνω σύνδεσμο, καθώς τα αρχεία που απαιτούνται από το NVDA μάλλον δεν έχουν εγκατασταθεί από τον άλλον αναγνώστη οθόνης. 

Από προεπιλογή, το NVDA μπορεί να εντοπίσει και να συνδεθεί σε αυτές τις οθόνες είτε μέσω USB είτε μέσω bluetooth. 
Ωστόσο, όταν διαμορφώνετε την οθόνη, μπορείτε ρητώς να επιλέξετε θύρες "USB" ή "bluetooth", προκειμένου να καθορίσετε το είδος της σύνδεσης που θα χρησιμοποιηθεί. 
Αυτό μπορεί να είναι χρήσιμο αν θέλετε να συνδέσετε την οθόνη με το NVDA χρησιμοποιώντας bluetooth, αλλά να εξακολουθείτε να μπορείτε να τη φορτίσετε χρησιμοποιώντας USB ενέργεια από τον υπολογιστή σας.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για την οθόνη Focus με το NVDA. 
Παρακαλούμε να διαβάσετε τις πληροφορίες για την οθόνη για περιγραφές σχετικά με το πού θα βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |topRouting1 (πρώτο κελί στην οθόνη)|
|Κύλιση εμπρός οθόνης braille |topRouting20/40/80 (τελευταίο κελί στην οθόνη)|
|Κύλιση πίσω οθόνης braille |leftAdvanceBar|
|Κύλιση εμπρός οθόνης braille |rightAdvanceBar|
|Εναλλαγή braille tethered to |leftGDFButton+rightGDFButton|
|Εναλλαγή left wiz wheel action |leftWizWheelPress|
|Κίνηση πίσω χρησιμοποιώντας το left wiz wheel action |leftWizWheelUp|
|Κίνηση εμπρός χρησιμοποιώντας το left wiz wheel action |leftWizWheelDown|
|Εναλλαγή right wiz wheel action |rightWizWheelPress|
|Κίνηση πίσω χρησιμοποιώντας το right wiz wheel action |rightWizWheelUp|
|Κίνηση εμπρός χρησιμοποιώντας το right wiz wheel action |rightWizWheelDown|
|Route to braille cell |routing|
|Πλήκτρο backspace |κουκκίδα7|
|Πλήκτρο enter |κουκκίδα8|
|Πλήκτρο shift+tab |brailleSpaceBar+κουκκίδα1+κουκκίδα2|
|Πλήκτρο tab |brailleSpaceBar+κουκκίδα4+κουκκίδα5|
|Πλήκτρο πάνω βέλους |brailleSpaceBar+κουκκίδα1|
|Πλήκτρο κάτω βέλους |brailleSpaceBar+κουκκίδα4|
|Πλήκτρο control+αριστερό βέλος |brailleSpaceBar+κουκκίδα2|
|Πλήκτρο control+δεξί βέλος |brailleSpaceBar+κουκκίδα5|
|Πλήκτρο Αριστερού βέλους |brailleSpaceBar+κουκκίδα3|
|Πλήκτρο δεξιού βέλους |brailleSpaceBar+κουκκίδα6|
|Πλήκτρο home |brailleSpaceBar+κουκκίδα1+κουκκίδα3|
|Πλήκτρο end |brailleSpaceBar+κουκκίδα4+κουκκίδα6|
|Πλήκτρο control+home |brailleSpaceBar+κουκκίδα1+κουκκίδα2+κουκκίδα3|
|Πλήκτρο control+end |brailleSpaceBar+κουκκίδα4+κουκκίδα5+κουκκίδα6|
|Πλήκτρο alt |brailleSpaceBar+κουκκίδα1+κουκκίδα3+κουκκίδα4|
|Πλήκτρο alt+tab |brailleSpaceBar+κουκκίδα2+κουκκίδα3+κουκκίδα4+κουκκίδα5|
|Πλήκτρο escape |brailleSpaceBar+κουκκίδα1+κουκκίδα5|
|Πλήκτρο windows || brailleSpaceBar+κουκκίδα2+κουκκίδα4+κουκκίδα5+κουκκίδα6|
|Πλήκτρο space |brailleSpaceBar|
|windows+d key (ελαχιστοποίηση όλων των εφαρμογών) |brailleSpaceBar+κουκκίδα1+κουκκίδα2+κουκκίδα3+κουκκίδα4+κουκκίδα5+κουκκίδα6|
|Αναφορά Τρέχουσας Γραμμής |brailleSpaceBar+κουκκίδα1+κουκκίδα4|
|Μενού NVDA |brailleSpaceBar+κουκκίδα1+κουκκίδα3+κουκκίδα4+κουκκίδα5|

Για νεότερα μοντέλα Focus που περιλαμβάνουν πλήκτρα rocker bar (focus 40, focus 80 and focus blue):

| Όνομα |Πλήκτρο|
|---|---|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |leftRockerBarUp, rightRockerBarUp|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |leftRockerBarDown, rightRockerBarDown|

Μόνο για Focus 80:

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |leftBumperBarUp, rightBumperBarUp|
|Κύλιση εμπρός οθόνης braille |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA BC640/680 {#toc174}

Τόσο οι οθόνες ALVA BC640 όσο και οι BC680 από την [Optelec](https://www.optelec.com/) υποστηρίζονται, όταν συνδέονται μέσω USB ή bluetooth. 
Δε χρειάζεται να εγκαταστήσετε συγκεκριμένους οδηγούς, για να χρησιμοποιήσετε αυτές τις οθόνες. 
Απλά συνδέστε την οθόνη και διαμορφώστε το NVDA έτσι ώστε να τη χρησιμοποιήσει.

Ενώ οι οθόνες αυτές διαθέτουν braille πληκτρολόγιο, χειρίζονται οι ίδιες τη μετάφραση από το braille σε κείμενο. 
Ως εκ τούτου, η ρύθμιση του πίνακα εισαγωγής braille του NVDA δεν είναι ουσιώδης.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |t1|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |t2|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |t4|
|Κύλιση εμπρός οθόνης braille |t5|
|Route to braille cell |routing|
|Πλήκτρο shift+tab |sp1|
|Πλήκτρο alt |sp2|
|Πλήκτρο escape |sp3|
|Πλήκτρο tab |sp4|
|Πλήκτρο πάνω βέλους |spUp|
|Πλήκτρο κάτω βέλους |spDown|
|Πλήκτρο αριστερού βέλους |spLeft|
|Πλήκτρο δεξιού βέλους |spRight|
|Πλήκτρο enter |spEnter|
|Μενού NVDA |sp1+sp3|
|Πλήκτρο windows+d (ελαχιστοποίηση όλων των εφαρμογών) |sp1+sp4|
|Πλήκτρο windows |sp2+sp3|
|Πλήκτρο alt+tab |sp2+sp4|

<!-- KC:endInclude -->

### Οθόνες Handy Tech {#toc175}

Το NVDA υποστηρίζει όλες τις οθόνες της [Handy Tech](https://www.handytech.de/) όταν συνδεθούν μέσω USB ή bluetooth. 
Για παλαιότερες οθόνες USB, θα πρέπει να εγκαταστήσετε τους οδηγούς USB από τη Handy Tech στο σύστημά σας.

Η εισαγωγή braille δεν υποστηρίζεται μέχρι στιγμής.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |left, up|
|Κύλιση εμπρός οθόνης braille |right, down|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |b4|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |b5|
|Route to braille cell |routing|
|Πλήκτρο shift+tab |esc|
|Πλήκτρο alt |b2+b4+b5|
|Πλήκτρο escape |b4+b6|
|Πλήκτρο tab |enter|
|Πλήκτρο enter |esc+enter|
|Πλήκτρο πάνω βέλους |leftSpace|
|Πλήκτρο κάτω βέλους |rightSpace|
|Μενού NVDA |b2+b4+b5+b6|
|Διαμόρφωση Handy Tech |b4+b8|

<!-- KC:endInclude -->

### MDV Lilli {#toc176}

Η οθόνη Lilli από τη [MDV](https://www.mdvbologna.it/) υποστηρίζεται. 
Δε χρειάζεται να εγκαταστήσετε συγκεκριμένους οδηγούς για να χρησιμοποιήσετε αυτή την οθόνη. 
Απλά συνδέστε την οθόνη και διαμορφώστε το NVDA έτσι ώστε να τη χρησιμοποιεί.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης BRAILLE |LF|
|Κύλιση εμπρός οθόνης braille |RG|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |UP|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |DN|
|Route to braille cell |route|
|Πλήκτρο shift+tab |SLF|
|Πλήκτρο tab |SRGΠλήκτρο|
|alt+tab |SDN|
|Πλήκτρο alt+shift+tab |SUP|

<!-- KC:endInclude -->

### Οθόνες Braille Baum/Humanware/APH {#toc177}

Αρκετές οθόνες [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/) και [APH](https://www.aph.org/) υποστηρίζονται όταν συνδεθούν μέσω USB ή bluetooth. Στις οθόνες αυτές συμπεριλαμβάνονται οι οθόνες Baum, HumanWare και APH. 
Αυτές συμπεριλαμβάνουν:

* Baum: SuperVario, PocketVario
* HumanWare: Brailliant, BrailleConnect
* APH: Refreshabraille

Κάποιες άλλες οθόνες που κατασκευάζονται από τη Baum μπορεί επίσης να λειτουργούν, αν και δεν έχουν δοκιμαστεί.

Αν η οθόνη συνδεθεί μέσω USB, πρέπει πρώτα να εγκαταστήσετε τους οδηγούς USB που παρέχει ο κατασκευαστής. 
Για το APH Refreshabraille, η λειτουργία USB πρέπει να οριστεί ως serial.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |d2|
|Κύλιση εμπρός οθόνης braille |d5|
|Μετακίνηση οθόνης braille στην προηγούμενη οθόνη |d1|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |d3|
|Route to braille cell |routing|

Για οθόνες braille που διαθέτουν joystick:

| Όνομα |Πλήκτρο|
|---|---|
|Πλήκτρο πάνω βέλους |up|
|Πλήκτρο κάτω βέλους |down|
|Πλήκτρο αριστερού βέλους |left|
|Πλήκτρο δεξιού βέλους |right|
|Πλήκτρο enter |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#toc178}

Το hedo ProfiLine USB από τη [hedo Reha-Technik](https://www.hedo.de/) υποστηρίζεται. 
Πρέπει πρώτα να εγκαταστήσετε τους οδηγούς USB που παρέχει ο κατασκευαστής.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτές τις εντολές.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |K1|
|Κύλιση εμπρός οθόνης braille |K3|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |B2|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |B5|
|Route to braille cell |routing|
|Εναλλαγή braille tethered to |K2|
|Ανάγνωση όλων |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#toc179}

Το hedo MobilLine USB από τη [hedo Reha-Technik](https://www.hedo.de/) υποστηρίζεται. 
Πρέπει πρώτα να εγκαταστήσετε τους οδηγούς USB που παρέχει ο κατασκευαστής.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτές τις εντολές.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |K1|
|Κύλιση εμπρός οθόνης braille |K3|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |B2|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |B5|
|Route to braille cell |routing|
|Εναλλαγή braille tethered to |K2|
|Ανάγνωση όλων |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant BI/B Series {#toc180}

Η σειρά οθονών Brailliant BI και B από τη [HumanWare](https://www.humanware.com/), συμπεριλαμβανομένων των BI 32, BI 40 και B 80, υποστηρίζονται όταν συνδεθούν μέσω USB ή bluetooth. 
Αν η οθόνη έχει συνδεθεί μέσω USB, πρέπει πρώτα να εγκαταστήσετε τους οδηγούς USB που παρέχι ο κατασκευαστής.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |left|
|Κύλιση εμπρός οθόνης braille |right|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |up|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |down|
|Route to braille cell |routing|
|Εναλλαγή braille tethered to |up+down|
|Πλήκτρο πάνω βέλους |space+κουκκίδα1|
|Πλήκτρο κάτω βέλους |space+κουκκίδα4|
|Πλήκτρο αριστερού βέλους |space+κουκκίδα3|
|Πλήκτρο δεξιού βέλους |space+κουκκίδα6|
|Μενού NVDA |c1+c3+c4+c5 (command n)|
|Πλήκτρο shift+tab |space+κουκκίδα1+κουκκίδα3|
|Πλήκτρο tab |space+κουκκίδα4+κουκκίδα6|
|Πλήκτρο alt |space+κουκκίδα1+κουκκίδα3+κουκκίδα4 (space+m)|
|Πλήκτρο escape |space+κουκκίδα1+κουκκίδα5 (space+e)|
|Πλήκτρο enter |κουκκίδα8|
|Πλήκτρο windows+d (ελαχιστοποίηση όλων των εφαρμογών) |c1+c4+c5 (command d)|
|Πλήκτρο windows |space+κουκκίδα3+κουκκίδα4|
|Πλήκτρο alt+tab |space+κουκκίδα2+κουκκίδα3+κουκκίδα4+κουκκίδα5 (space+t)|
|Ανάγνωση όλων |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

### Σειρά HIMS Braille Sense/Braille EDGE {#toc181}

Το NVDA υποστηρίζει οθόνες Braille Sense και Braille EDGE displays από τη [Hims](https://www.hims-inc.com/) όταν συνδεθούν μέσω USB ή bluetooth. 
Αν η οθόνη συνδεθεί μέσω USB, πρέπει να εγκαταστήσετε τους οδηγούς USB από τη HIMS στο σύστημά σας. 
Μπορείτε να τους κατεβάσετε από το HIMS Resource Center: https://www.hims-inc.com/resource-center/ 
Σε αυτή τη σελίδα επιλέξτε τη συσκευή σας και κατεβάστε τον οδηγό στην περιοχή Window-Eyes. 
Παρότι στην περιοχή αυτή αναφέρεται μόνο το Window-Eyes, πρόκειται για ένα γενικό οδηγό USB που θα λειτουργήσει επίσης με το NVDA.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτές τις οθόνες με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |left side scroll down|
|Κύλιση εμπρός οθόνης braille |right side scroll down|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |left side scroll up|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |right side scroll up|
|Route to braille cell |routing|
|Πλήκτρο shift+tab |κουκκίδα1+κουκκίδα2+space|
|Πλήκτρο alt |κουκκίδα1+κουκκίδα3+κουκκίδα4+Space|
|Πλήκτρο escape |κουκκίδα1+κουκκίδα5+Space|
|Πλήκτρο tab |κουκκίδα4+κουκκίδα5+Space|
|Πλήκτρο enter |κουκκίδα8|
|Πλήκτρο backspace |κουκκίδα7|
|Πλήκτρο πάνω βέλους |κουκκίδα1+Space|
|Πλήκτρο κάτω βέλους |κουκκίδα4+Space|
|capsLock |κουκκίδα1+κουκκίδα3+κουκκίδα6+space|
|Πλήκτρο shift+alt+tab |advance2+advance3+advance1|
|Πλήκτρο alt+tab |advance2+advance3|
|Πλήκτρο end |κουκκίδα4+κουκκίδα6+space|
|Πλήκτρο Control+end |κουκκίδα4+κουκκίδα5+κουκκίδα6+space|
|Πλήκτρο home |κουκκίδα1+κουκκίδα3+space|
|Πλήκτρο control+home |κουκκίδα1+κουκκίδα2+κουκκίδα3+space|
|Πλήκτρο αριστερού βέλους |κουκκίδα3+space|
|Πλήκτρο control+shift+leftArrow |κουκκίδα2+κουκκίδα8+space+advance1|
|Πλήκτρο control+αριστερό βέλος |κουκκίδα2+space|
|Πλήκτρο shift+alt+αριστερό βέλος |κουκκίδα2+κουκκίδα7+advance1|
|Πλήκτρο alt+αριστερό βέλος |κουκκίδα2+κουκκίδα7|
|Πλήκτρο δεξιού βέλους |κουκκίδα6+space|
|Πλήκτρο control+shift+δεξί βέλος |κουκκίδα5+κουκκίδα8+space+advance1|
|Πλήκτρο control+δεξί βέλος |κουκκίδα5+space|
|Πλήκτρο shift+alt+δεξί βέλος |κουκκίδα5+κουκκίδα7+advance1|
|Πλήκτρο alt+δεξί βέλος |κουκκίδα5+κουκκίδα7|
|Πλήκτρο pageUp |κουκκίδα1+κουκκίδα2+κουκκίδα6+space|
|Πλήκτρο control+pageUp |κουκκίδα1+κουκκίδα2+κουκκίδα6+κουκκίδα8+space|
|Πλήκτρο control+shift+πάνω βέλος |κουκκίδα2+κουκκίδα3+κουκκίδα8+space+advance1|
|Πλήκτρο control+πάνω βέλος |κουκκίδα2+κουκκίδα3+space|
|Πλήκτρο shift+alt+πάνω βέλος |κουκκίδα2+κουκκίδα3+κουκκίδα7+advance1|
|Πλήκτρο alt+πάνω βέλος |κουκκίδα2+κουκκίδα3+κουκκίδα7|
|Πλήκτρο shift+πάνω βέλος |αριστερό scroll down + space|
|Πλήκτρο pageDown |κουκκίδα3+κουκκίδα4+κουκκίδα5+space|
|Πλήκτρο control+pagedown |κουκκίδα3+κουκκίδα4+κουκκίδα5+κουκκίδα8+space|
|Πλήκτρο control+shift+κάτω βέλος |κουκκίδα5+κουκκίδα6+κουκκίδα8+space+advance1|
|Πλήκτρο control+κάτω βέλος |κουκκίδα5+κουκκίδα6+space|
|Πλήκτρο shift+alt+κάτω βέλος |κουκκίδα5+κουκκίδα6+κουκκίδα7+advance1|
|Πλήκτρο alt+κάτω βέλος |κουκκίδα5+κουκκίδα6+κουκκίδα7|
|Πλήκτρο shift+κάτω βέλος |δεξιό scroll down + space|
|Πλήκτρο delete |κουκκίδα1+κουκκίδα3+κουκκίδα5+space|
|Πλήκτρο f1 |κουκκίδα1+κουκκίδα2+κουκκίδα5+space|
|Πλήκτρο f3 |κουκκίδα1+κουκκίδα2+κουκκίδα4+κουκκίδα8|
|Πλήκτρο f4 |κουκκίδα7+advance3|
|Πλήκτρο windows+b |κουκκίδα1+κουκκίδα2+advance1|
|Πλήκτρο windows+d |κουκκίδα1+κουκκίδα4+κουκκίδα5+advance1|

<!-- KC:endInclude -->

### HIMS SyncBraille {#toc182}

Το NVDA υποστηρίζει την οθόνη SyncBraille Display από τη  [HIMS](https://www.hims-inc.com/).
Θα πρέπει να εγκαταστήσετε τους USB οδηγούς από τη HIMS στο σύστημά σας.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |αριστερό scroll down|
|Κύλιση εμπρός οθόνης braille |δεξιό scroll down|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Οθόνες Braille Seika {#toc183}

Οι οθόνες braille Seika Έκδοση 3, 4 και 5 (40 κελιά) και Seika80 (80 κελιά) από τη [Nippon Telesoft](https://www.nippontelesoft.com/) υποστηρίζονται. 
Μπορείτε να βρείτε περισσότερες πληροφορίες για αυτές τις οθόνες στο https://www.seika-braille.com/. 
Πρέπει πρώτα να εγκαταστήσετε τους USB οδηγούς που παρέχει ο κατασκευαστής.

Ακολουθούν οι αντιστοιχήσεις των πλήκτρων για αυτή την οθόνη με το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση της οθόνης για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |αριστερά|
|Κύλιση εμπρός οθόνης braille |δεξιά|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |b3|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |b4|
|Εναλλαγή braille tethered to |b5|
|Εκφώνηση όλων |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|Μενού NVDA |αριστερό+δεξί|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Νεότερα Μοντέλα Papenmeier BRAILLEX {#toc184}

Οι επόμενες οθόνες braille υποστηρίζονται:

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB και bluetooth)
* BRAILLEX Live 20, BRAILLEX Live και BRAILLEX Live Plus (USB και bluetooth)

Αν είναι εγκατεστημένο το  BrxCom, το NVDA θα χρησιμοποιήσει το BrxCom. 
Το BrxCom είναι ένα εργαλείο που σας επιτρέπει να χρησιμοποιήσετε την εισαγωγή braille ανεξάρτητα από κάποιον αναγνώστη οθόνης. 
Μια νέα έκδοση του BrxCom που λειτουργεί με το NVDA θα γίνει διαθέσιμη από τη Papenmeier σύντομα. 
Ωστόσο, η εισαγωγή braill είναι δυνατή με τις συσκευές Trio, BRAILLEX Live 20 και Braillex Live χωρίς το BrxCom.
Η εισαγωγή braille είναι επίσης δυνατή με το μοντέλο Live Plus αλλά μόνο με την χρήση του BrxCom.

Οι περισσότερες συσκευές διαθέτουν Μπάρα Εύκολης Πρόσβασης (EAB)  που επιτρέπει διαισθητική και γρήγορη χρήση. 
Το EAB μπορεί να μετακινηθεί προς τέσσερις κατευθύνσεις και η κάθε κατεύθυνση έχει δύο θέσεις. 
Οι σειρές C και Live αποτελούν τη μόνη εξαίρεση σε αυτόν τον κανόνα.

Η σειρά c-series και κάποιες άλλες οθόνες έχουν δύο σειρές routing, εκ των οποίων η πάνω σειρά χρησιμοποιείται για την αναφορά πληροφοριών για τη μορφοποίηση. 
Κρατώντας ένα από τα πάνω πλήκτρα routing και πατώντας το EAB στη σειρά c-series, η συσκευή μιμείται τη δεύτερη θέση. 
Πατώντας και κρατώντας τα πλήκτρα πάνω, κάτω, δεξί και αριστερό (ή το EAB) γίνεται επανάληψη των αντίστοιχων ενεργειών.

Γενικά, τα ακόλουθα πλήκτρα είναι διαθέσιμα σε αυτές τις οθόνες braille:

| Όνομα |Πλήκτρο|
|---|---|
|l1 |Αριστερό front key|
|l2 |Αριστερό rear key|
|r1 |Δεξί front key|
|r2 |Δεξί rear key|
|up |1 Βήμα Πάνω|
|up2 |2 Βήματα Πάνω|
|left |1 Βήμα Αριστερά|
|left2 |2 Βήματα Αριστερά|
|right |1 Βήμα Δεξιά|
|right2 |2 Βήματα Δεξιά|
|dn |1 Βήμα κάτω|
|dn2 |2 Βήματα κάτω|

Ακολουθούν οι εντολές  του Papenmeier για το NVDA:
<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |left|
|Κύλιση εμπρός οθόνης braille |right|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |up|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |dn|
|Route to braille cell |routing|
|Αναφορά τρέχοντος χαρακτήρα υπό επανεξέταση |l1|
|Ενεργοποίηση τρέχοντος αντικειμένου πλοήγησης |l2|
|Αναφορά τίτλου |l1+up|
|Αναφορά γραμμής κατάστασης |l2+down|
|Μετακίνηση στο αντικείμενο του υποδοχέα |up2|
|Μετακίνηση στο πρώτο αντικείμενο του υποδοχέα |dn2|
|Μετακίνηση στο προηγούμενο αντικείμενο |left2|
|Μετακίνηση στο επόμενο αντικείμενο |right2|
|Αναφορά μορφοποίησης κειμένου |σειρά upper routing|

<!-- KC:endInclude -->

Το μοντέλο Trio διαθέτει επιπλέον πλήκτρα που βρίσκονται μπροστά από το braille πληκτρολόγιο. 
Αυτά είναι (κατά σειρά από τα αριστερά προς τα δεξιά):

* πλήκτρο left thumb (lt)
* space
* space
* πλήκτρο right thumb (rt)

Το πλήκτρο right thumb δε χρησιμοποιείται αυτή τη στιγμή. 
Τα δύο εσωτερικά πλήκτρα αντιστοιχούν στο space.

| Όνομα |Πλήκτρο|
|---|---|

<!-- KC:beginInclude -->

|Πλήκτρο backspace |κουκκίδα 7|
|Πλήκτρο enter |κουκκίδα 8|
|Πλήκτρο escape |space με κουκκίδα 7|
|πλήκτρο πάνω βέλους |space με κουκκίδα 2|
|πλήκτρο leftArrow |space με κουκκίδα 1|
|πλήκτρο δεξιού βέλους |space με κουκκίδα 4|
|κάτω βέλος |space με κουκκίδα 5|
|πλήκτρο control |lt+κουκκίδα2|
|πλήκτρο alt |lt+κουκκίδα3|
|πλήκτρο control+escape |space με κουκκίδες 1 2 3 4 5 6|
|πλήκτρο tab |space με κουκκίδες 3 7|

<!-- KC:endInclude  -->

### Παλαιότερα Μοντέλα Papenmeier Braille BRAILLEX {#toc185}

Οι παρακάτω οθόνες braille υποστηρίζονται:

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

Σημειώστε ότι αυτές οι οθόνες μπορούν να συνδεθούν μόνο μέσω συριακής θύρας. 
Ως εκ τούτου, θα πρέπει να επιλέξετε τη θύρα στην οποία έχει συνδεθεί η οθόνη, αφού πρώτα έχετε επιλέξει αυτόν τον οδηγό στο παράθυρο διαλόγου των ρυθμίσεων braille.

Κάποιες από αυτές τις συσκευές έχουν μπάρα εύκολης πρόσβασης (EAB) που επιτρέπει διαισθητική και γρήγορη χρήση. 
Το EAB μπορεί να μετακινηθεί προς τέσσερις κατευθύνσεις, κάθε μια εκ των οποίων διαθέτει δύο θέσεις. 
Πατώντας και κρατώντας το πάνω, κάτω, αριστερό και δεξί πλήκτρο (ή το EAB) γίνεται επανάληψη των αντίστοιχων ενεργειών. 
Παλαιότερες συσκευές δε διαθέτουν EAB; αντ’ αυτού χρησιμοποιούνται τα μπροστινά πλήκτρα.

Γενικά, διατίθενται τα παρακάτω πλήκτρα στις οθόνες braille:

| Όνομα |Πλήκτρο|
|---|---|
|l1 |Αριστερό front key|
|l2 |Αριστερό rear key|
|r1 |Δεξί front key|
|r2 |Δεξί rear key|
|up |1 Βήμα πάνω|
|up2 |2 Βήματα πάνω|
|left |1 Βήμα αριστερά|
|left2 |2 Βήματα αριστερά|
|right |1 Βήμα δεξιά|
|right2 |2 Βήματα δεξιά|
|dn |1 Βήμα κάτω|
|dn2 |2 Βήματα κάτω|

Ακολουθούν οι εντολές του Papenmeier για το NVDA:

<!-- KC:beginInclude -->
Συσκευές με EAB:

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |left|
|Κύλιση εμπρός οθόνης braille |right|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |up|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |dn|
|Route to braille cell |routing|
|Αναφορά τρέχοντος χαρακτήρα υπό επανεξέταση |l1|
|Ενεργοποίηση τρέχοντος αντικειμένου πλοήγησης |l2|
|Αναφορά τίτλου |l1up|
|Αναφορά γραμμής κατάστασης |l2down|
|Μετακίνηση σε αντικείμενο υποδοχέα |up2|
|Μετακίνηση στο πρώτο αντικείμενο του υποδοχέα |dn2|
|Μετακίνηση στο επόμενο αντικείμενο |right2|
|Μετακίνηση στο προηγούμενο αντικείμενο |left2|
|Αναφορά μορφοποίησης κειμένου |Upper routing strip|

BRAILLEX Tiny:

| Όνομα |Πλήκτρο|
|---|---|
|Αναφορά τρέχοντος χαρακτήρα υπό επανεξέταση |l1|
|Ενεργοποίηση τρέχοντος αντικειμένου πλοήγησης |l2|
|Κύλιση πίσω οθόνης braille |left|
|Κύλιση εμπρός οθόνης braille |right|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |up|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |dn|
|Εναλλαγή braille tethered to |r2|
|Μετακίνηση στο αντικείμενο του υποδοχέα |r1+up|
|Μετακίνηση στο πρώτο αντικείμενο του υποδοχέα |r1+dn|
|Μετακίνηση στο προηγούμενο αντικείμενο |r1+left|
|Μετακίνηση στο επόμενο αντικείμενο |r1+right|
|Αναφορά μορφοποίησης κειμένου |reportf|

BRAILLEX 2D Screen:

| Όνομα |Πλήκτρο|
|---|---|
|Αναφορά τρέχοντος χαρακτήρα υπό επανεξέταση |l1|
|Ενεργοποίηση τρέχοντος αντικειμένου πλοήγησης |l2|
|Εναλλαγή braille tethered to |r2|
|Αναφορά μορφοποίησης κειμένου |reportf|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |up|
|Κύλιση πίσω οθόνης braille |left|
|Κύλιση εμπρός οθόνης braille |right|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |dn|
|Μετακίνηση στο επόμενο αντικείμενο |left2|
|Μετακίνηση στο αντικείμενο του υποδοχέα |up2|
|Μετακίνηση στο πρώτο αντικείμενο του υποδοχέα |dn2|
|Μετακίνηση στο προηγούμενο αντικείμενο |right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#toc186}

Το NVDA υποστηρίζει τη σειρά BrailleNote από τη [Humanware](https://www.humanware.com), όταν λειτουργεί ως οθόνη τερματικού για έναν αναγνώστη οθόνης. 
Τα επόμενα μοντέλα υποστηρίζονται:

* BrailleNote Classic (μόνο συριακή σύνδεση)
* BrailleNote PK (συριακές και blue tooth σύνδέσεις)
* BrailleNote MPower (συριακές και blue tooth συνδέσεις)
* BrailleNote Apex (USB και blue tooth συνδέσεις)

Αν η σύνδεσή σας υποστηρίζει περισσότερους από έναν τύπο σύνδεσης, όταν συνδέετε το BrailleNote στο NVDA, πρέπει να ορίσετε τη θύρα τερματικού braille στις ρυθμίσεις τερματικού braille. 
Παρακαλώ ελέγξτε το εγχειρίδιο του BrailleNote για λεπτομέρειες σχετικά με το NVDA. 
Ίσως χρειαστεί να ορίσετε τη θύρα στο παράθυρο διαλόγου των ρυθμίσεων braille, αν συνδέεστε μέσω USB ή blue tooth. 
Μπορείτε να ορίσετε τη θύρα ως  "Automatic", "USB" or "Bluetooth", ανάλογα με τις διαθέσιμες επιλογές. 
Αν συνδέεστε μέσω legacy serial port (ή έναν μετατροπέα USB σε serial)ή αν δεν εμφανίζεται καμία από τις προηγούμενες επιλογές, θα πρέπει να ορίσετε σαφώς τη θύρα επικοινωνίας από τη λίστα θυρών του hardware.

Πριν συνδέσετε το BrailleNote Apex, χρησιμοποιώντας το εργαλείο διεπαφής USB της συσκευής, πρέπει να εγκαταστήσετε τους οδηγούς που παρέχει η HumanWare.

Ακολουθούν οι αντιστοιχήσεις των εντολών για το NVDA. 
Παρακαλούμε να διαβάσετε την τεκμηρίωση του BrailleNote για περιγραφές σχετικά με το πού μπορείτε να βρείτε αυτά τα πλήκτρα.

<!-- KC:beginInclude -->

| Όνομα |Πλήκτρο|
|---|---|
|Κύλιση πίσω οθόνης braille |back|
|Κύλιση εμπρός οθόνης braille |advance|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |previous|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |next|
|Route to braille cell |routing|
|Εναλλαγή braille tethered to |previous+next|
|Πλήκτρο πάνω βέλους |space+κουκκίδα1|
|Πλήκτρο κάτω βέλους |space+κουκκίδα4|
|Πλήκτρο αριστερού βέλους |space+κουκκίδα3|
|Πλήκτρο δεξιού βέλους |space+κουκκίδα6|
|Πλήκτρο Page up |space+κουκκίδα1+κουκκίδα3|
|Πλήκτρο Page down |space+κουκκίδα4+κουκκίδα6|
|Πλήκτρο Home |space+κουκκίδα1+κουκκίδα2|
|Πλήκτρο End |space+κουκκίδα4+κουκκίδα5|
|Πλήκτρα Control+home |space+κουκκίδα1+κουκκίδα2+κουκκίδα3|
|Πλήκτρα Control+end |space+κουκκίδα4+κουκκίδα5+κουκκίδα6|
|Πλήκτρο Space |space|
|Πλήκτρο Enter |space+κουκκίδα8|
|Πλήκτρο Backspace |space+κουκκίδα7|
|Πλήκτρο Tab |space+κουκκίδα2+κουκκίδα3+κουκκίδα4+κουκκίδα5 (space+t)|
|Πλήκτρα Shift+tab |space+κουκκίδα1+κουκκίδα2+κουκκίδα5+κουκκίδα6|
|Πλήκτρο Windows |space+κουκκίδα2+κουκκίδα4+κουκκίδα5+κουκκίδα6 (space+w)|
|Πλήκτρο Alt |space+κουκκίδα1+κουκκίδα3+κουκκίδα4 (space+m)|
|Εναλλαγή βοήθειας εισαγωγής |space+κουκκίδα2+κουκκίδα3+κουκκίδα6 (space+lower h)|

<!-- KC:endInclude -->

### BRLTTY {#toc187}

Το [BRLTTY](https://mielke.cc/brltty/) είναι ένα ξεχωριστό πρόγραμμα που μπορεί να χρησιμοποιηθεί για να υποστηρίξει πολλές περισσότερες οθόνες braille. 
Για να το χρησιμοποιήσετε, πρέπει να εγκαταστήσετε το [BRLTTY για Windows](https://brl.thefreecat.org/brltty/).
Θα πρέπει να κατεβάσετε και να εγκαταστήσετε τον πιο πρόσφατο οδηγό που θα λέγεται, για παράδειγμα, brltty-win-4.2-2.exe.
Όταν διαμορφώνετε την οθόνη και τη θύρα που θα χρησιμοποιήσετε, πρέπει να δώσετε μεγάλη προσοχή στις οδηγίες, ειδικά αν χρησιμοποιείτε μια USB οθόνη και έχετε ήδη εγκαταστήσει τους οδηγούς του κατασκευαστή.

Για οθόνες που διαθέτουν braille πληκτρολόγιο, το ίδιο το  BRLTTY αυτή τη στιγμή χειρίζεται την εισαγωγή braille. 
Ως εκ τούτου, η ρύθμιση του πίνακα εισαγωγής braille του NVDA δεν είναι ουσιώδης.

Ακολουθούν οι αντιστοιχήσεις εντολών του BRLTTY για το NVDA. 
Παρακαλούμε να διαβάσετε τους [πίνακες εντολών του BRLTTY](https://mielke.cc/brltty/doc/KeyTables/), σχετικά με το πώς οι εντολές του BRLTTY αντιστοιχούν σε πλήκτρα στις οθόνες braille.
<!-- KC:beginInclude -->

| Όνομα |Εντολή του BRLTTY|
|---|---|
|Κύλιση πίσω οθόνης braille |fwinlt (κίνηση αριστερά κατά ένα παράθυρο)|
|Κύλιση εμπρός οθόνης braille |fwinrt (κίνηση δεξιά κατά ένα παράθυρο)|
|Μετακίνηση οθόνης braille στην προηγούμενη γραμμή |lnup (κίνηση πάνω κατά μία γραμμή)|
|Μετακίνηση οθόνης braille στην επόμενη γραμμή |lndn (κίνηση κάτω κατά μία γραμμή)|
|Route to braille cell |route (μετακίνηση δρομέα σε χαρακτήρα)|

<!-- KC:endInclude -->

## Συντομεύσεις τύπου ελέγχου braille και κατάστασης {#toc188}

Προκειμένου να χωρέσουν όσο το δυνατό περισσότερες πληροφορίες σε μια οθόνη braille, οι παρακάτω συντομεύσεις έχουν οριστεί για τύπους ελέγχου και κατάστασης.

| Συντόμευση |Τύπος ελέγχου|
|---|---|
|btn |κουμπί|
|cbo |αναδυόμενο κουτί|
|chk |πλαίσιο ελέγχου|
|dlg |παράθυρο διαλόγου|
|edt |επεξεργάσιμο πεδίο κειμένου|
|gra |γραφικό|
|cN |αριθμός στήλης πίνακα n, π.χ. c1, c2.|
|rN |αριθμός γραμμής πίνακα n, π.χ. r1, r2.|
|hN |επίπεδο επικεφαλίδας n, π.χ. h1, h2.|
|lnk |σύνδεσμος|
|lst |λίστα|
|vlnk |σύνδεσμος που έχει δεχθεί επίσκεψη|
|mnu |μενού|
|mnubar |γραμμή μενού|
|rbtn |κουμπί επιλογής|
|tb |πίνακας|
|tv |προβολή δέντρου|
|lv N |ένα αντικείμενο στην προβολή δέντρου έχει επίπεδο N||
|`-----` |διαχωριστής|

Οι ακόλουθοι δείκτες κατάστασης έχουν επίσης οριστεί:

| Συντόμευση |Κατάσταση ελέγχου|
|---|---|
|... |εμφανίζεται όταν ένα αντικείμενο υποστηρίζει αυτόματη συμπλήρωση|
|( ) |εμφανίζεται όταν ένα αντικείμενο, π.χ. ένα πλαίσιο ελέγχου, δεν είναι επιλεγμένο|
|(x) |εμφανίζεται όταν ένα αντικείμενο, π.χ. ένα πλαίσιο ελέγχου, είναι επιλεγμένο|
|(-) |εμφανίζεται όταν ένα αντικείμενο, π.χ. ένα πλαίσιο ελέγχου, είναι μισοεπιλεγμένο|
|- |εμφανίζεται όταν ένα αντικείμενο, π.χ. μια προβολή δέντρου, μπορεί να συνεπτυχθεί|
|+ |εμφανίζεται όταν ένα αντικείμενο, π.χ. μια προβολή δέντρου, μπορεί να αναπτυχθεί|
|clk |εμφανίζεται όταν σε ένα αντικείμενο μπορεί να γίνει κλικ|
|ro |εμφανίζεται όταν, π.χ. ένα επεξεργάσιμο πεδίο κειμένου, είναι μόνο για ανάγνωση|
|sel |εμφανίζεται όταν ένα αντικείμενο είναι επιλεγμένο|
|submnu |εμφανίζεται όταν ένα αντικείμενο είναι αναδυόμενο, συνήθως έχει υπομενού|

## Προχωρημένα Θέματα {#toc189}
### Επιλογές Γραμμής Εντολών {#CommandLineOptions}

Το NVDA μπορεί να δεχθεί μία ή περισσότερες επιλογές κατά την εκκίνησή του, οι οποίες αλλάζουν τη συμπεριφορά του.
Μπορείτε να περάσετε όσες επιλογές χρειάζεστε.
Αυτές οι επιλογές μπορούν να περάσουν όταν γίνεται εκκίνηση από μια συντόμευση (στις ιδιότητες της συντόμευσης), από το παράθυρο διαλόγου εκτέλεσης (Μενού Έναρξη -> Εκτέλεση ή Windows+r) ή από μια κονσόλα εντολών των Windows.
Οι επιλογές πρέπει να χωρίζονται από το όνομα του εκτελέσιμου αρχείου του NVDA και από άλλες επιλογές με διαστήματα.
Για παράδειγμα, η συντόμευση στην επιφάνεια εργασίας που δημιουργεί το NVDA κατά την εγκατάσταση, έχει την επιλογή -r η οποία λέει στο NVDA να κλείσει το τρέχον αντίγραφο πριν ξεκινήσει το νέο.
Μια άλλη χρήσιμη επιλογή είναι η --disable-addons, η οποία λέει στο NVDA να αναστείλει όλα τα τρέχοντα πρόσθετα.
Αυτό σας επιτρέπει να εξακριβώσετε αν ένα πρόβλημα οφείλεται σε κάποιο πρόσθετο και να διορθώσετε σοβαρά προβλήματα που οφείλονται σε πρόσθετα.

Για παράδειγμα, μπορείτε να εξέλθετε από το τρέχον αντίγραφο του NVDA, εισάγοντας το παρακάτω στο παράθυρο διαλόγου εκτέλεση:

nvda -q

Κάποιες από τις επιλογές της γραμμής εντολών έχουν σύντομη και εκτενή περιγραφή, ενώ άλλες έχουν μόνο εκτενή περιγραφή.
Αυτές που έχουν μόνο σύντομη περιγραφή, μπορούν να συνδυαστούν ως εξής:

|nvda -rm |Με την εντολή αυτή πραγματοποιείται έξοδος από το τρέχον αντίγραφο του  NVDA και θα γίνει εκκίνηση ενός νέου αντιγράφου με απενεργοποιημένους τους ήχους εκκίνησης, κ.λπ.|
|nvda -rm --disable-addons |Το ίδιο με πριν, αλλά με απενεργοποιημένα τα πρόσθετα|

Κάποιες από τις επιλογές της γραμμής εντολών δέχονται επιπλέον παραμέτρους; π.χ. πόσο λεπτομερής πρέπει να είναι η καταγραφή ή τη διαδρομή για το φάκελο της διαμόρφωσης χρήστη.
Αυτές οι παράμετροι πρέπει να τοποθετηθούν μετά την επιλογή, να τις χωρίζει ένα διάστημα με την επιλογή όταν χρησιμοποιείται η σύντομη έκδοση, ή το σύμβολο ίσον (=) όταν χρησιμοποιείται η εκτενής έκδοση; π.χ.:

|nvda -l 10 |Λέει στο NVDA να αρχίσει με επίπεδο καταγραφής αποσφαλμάτωση|
|nvda --log-file=c:\nvda.log |Λέει στο NVDA να γράψει το αρχείο καταγραφής συμβάντων στο c:\nvda.log|
|nvda --log-level=20 -f c:\nvda.log |Λέει στο NVDA να αρχίσει με επίπεδο καταγραφής info και να γράψει το αρχείο καταγραφής συμβάντων στο c:\nvda.log|

Ακολουθούν οι επιλογές της γραμμής εντολών για το NVDA:

| Σύντομη |Εκτενής |Περιγραφή|
|---|---|---|
|-h |--help |Εμφάνιση βοήθειας γραμμής εντολών και έξοδος|
|-q |--quit |Κλείσιμο τρέχοντος αντιγράφου του NVDA|
|-r |--replace |Κλείσιμο τρέχοντος αντιγράφου του NVDA και έναρξη αυτού|
|-k |--check-running |Αναφορά αν το NVDA τρέχει μέσω του exit code; 0 αν ναι, 1 αν όχι|
|-f LOGFILENAME |--log-file=LOGFILENAME |Το αρχείο στο οποίο πρέπει να γράφονται μηνύματα καταγραφών|
|-l LOGLEVEL |--log-level=LOGLEVEL |Το χαμηλότερο επίπεδο καταγεγραμμένου μηνύματος (debug 10, info 20, warning 30, error 40, critical 50), προεπιλογή είναι η ειδοποίηση (warning)|
|-c CONFIGPATH |--config-path=CONFIGPATH |Η διαδρομή στην οποία αποθηκεύονται όλες οι ρυθμίσεις του NVDA|
|-m |--minimal |Χωρίς ήχους, χωρίς διεπαφή, χωρίς μήνυμα έναρξης, κ.λπ.|
|-s |--secure |Ασφαλής λειτουργία (απενεργοποίηση κονσόλας Python)|
|None |--disable-addons |Τα πρόσθετα δε θα έχουν καμία επίδραση|
|None |--no-sr-flag  | Μην αλλάξετε τη σημαία για το παγκόσμιο σύστημα αναγνωστών οθόνης|
|None |--install |Εγκαθιστά το NVDA (εκκίνηση του πρόσφατα εγκατεστημένου αντιγράφου)|
|None |--install-silent |Εγκαθιστά σιωπηλά το NVDA (δεν ξεκινά το πρόσφατα εγκατεστημένο αντίγραφο)|

### Προχωρημένη Διαμόρφωση Για Την Προφορά Συμβόλων {#toc191}

Είναι δυνατό να διαμορφώσετε την προφορά των σημείων στίξης και άλλων συμβόλων, πέρα από ό,τι είναι ήδη δυνατό με το παράθυρο διαλόγου [Punctuation/symbol pronunciation](#SymbolPronunciation).
Για παράδειγμα, μπορείτε να ορίσετε αν το σύμβολο καθεαυτό πρέπει να σταλεί στο συνθέτη φωνής, (π.χ. να προκαλέσει μια παύση ή επαύξηση) και μπορείτε να προσθέσετε άλλα σύμβολα.

Για να γίνει αυτό, θα πρέπει να επεξεργαστείτε το αρχείο πληροφοριών προφοράς συμβόλων στο φάκελό σας της διαμόρφωσης χρήστη του NVDA.
Το αρχείο ονομάζεται symbols-xx.dic, όπου xx είναι ο κώδικας της γλώσσας.
Η μορφή αυτού του αρχείου καταγράφεται στο τμήμα Προφορά Συμβόλων (Symbol Pronunciation) στον οδηγό του NVDA για τους προγραμματιστές που βρίσκεται στο τμήμα ανάπτυξης στη σελίδα του NVDA https://community.nvda-project.org/wiki/Development].
Ωστόσο, δεν είναι δυνατό οι χρήστες να ορίσουν περίπλοκα σύμβολα.

## Περισσότερες Πληροφορίες {#toc192}

Αν χρειάζεστε περισσότερες πληροφορίες ή βοήθεια σχετικά με το NVDA, παρακαλούμε να επισκεφθείτε την ιστοσελίδα του NVDA στο NVDA_URL.
Εδώ μπορείτε να βρείτε επιπλέον τεκμηρίωση, καθώς και τεχνική υποστήριξη και πηγές της κοινότητας των χρηστών.
Αυτή η ιστοσελίδα παρέχει επίσης πληροφορίες και πηγές που αφορούν στην ανάπτυξη του NVDA.

## Λεξικό Όρων {#toc193}

| Ελληνικά |Αγγλικά|
|---|---|
|αναδυόμενο κουτί |combo box|
|αντικείμενο πλοήγησης |navigator object|
|δακτύλιος ρυθμίσεων συνθέτη |synth settings ring|
|διέλευση |pass through|
|σύνδεση στα windows |windows logon/login|
|ενσωματωμένο αντικείμενο |embedded object|
|επίπεδη εξέταση |flat review|
|επεξήγηση |tool tip|
|εστίαση συστήματος - εστίαση |system focus|
|κέρσορας συστήματος - κέρσορας |system caret|
|κλείδωμα αριθμητικού πληκτρολογίου |num lock|
|κλείδωμα κεφαλαίων |caps lock|
|πλαίσιο διαλόγου |dialog box|
|λειτουργία βοήθειας πληκτρολογίου |keyboard help mode|
|λειτουργία εκφώνησης |speech mode|
|γραμμή εργαλείων |toolbar|
|γραμμή κατάστασης |status bar|
|γραμμή προόδου |progress bar|
|μεταφόρτωση |download|
|μπαλόνι βοήθειας |baloon help|
|πεδίο επεξεργασίας |edit field|
|υποδοχέας |container|
|περιέχει αντικείμενο |containing object|
|περιήγηση |browsing|
|αντικείμενο που περιέχεται |contained object|
|πλήκτρο τροποποίησης NVDA |NVDA modifier key|
|πλοήγηση |navigating|
|ρυθμιζόμενο |slider|
|προβολέας εκφώνησης |speech viewer|
|πρόχειρο |clipboard|
|σκανδαλισμός |trigger|
|στοιχείο ελέγχου |control|
|συνθέτης φωνής |synthesizer, speech synthesizer|
|συνθέτης |synthesizer ||

