# ﻿Guía del Usuario de NVDA NVDA_VERSION

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Referencia Rápida de Comandos  -->



## introducción {#introduction}

¡Bienvenido a NVDA!

NonVisual Desktop Access (NVDA) es un lector de pantallas libre y de código abierto  para el Sistema Operativo  Microsoft Windows.
Proporcionando retroalimentación mediante voz sintética y Braille, brinda la posibilidad a invidentes o deficientes visuales de acceder a ordenadores que ejecutan Windows por un costo no mayor al de una persona vidente.
NVDA es desarrollado por [NV Access](https://www.nvaccess.org/), con contribuciones de la comunidad.

### Características generales {#GeneralFeatures}

NVDA permite a invidentes y deficientes visuales acceder e interactuar con el Sistema Operativo Windows y muchas aplicaciones de terceros. 

Lo más reseñable incluye: 

* Soporte para aplicaciones populares incluyendo navegadores web, clientes de correo electrónico, programas de chat en internet y suites ofimáticas
* Sintetizador de voz integrado compatible con más de 80 idiomas
* Anunciado de formato de texto donde esté disponible tal como nombre y tamaño de fuente, estilo y errores ortográficos
* Anunciado automático de texto bajo el ratón e indicación opcional audible  de la posición del ratón
* Soporte para muchas líneas braille actualizables, incluyendo la capacidad de detectar automáticamente muchas de ellas así como la entrada de braille en líneas braille que tengan un teclado braille
* Capacidad para ejecutarse completamente desde una memoria USB u otros medios portables sin la necesidad de instalación
* Instalador parlante fácil de utilizar
* Traducido a 54 idiomas
* Soporte para Sistemas Operativos Windows modernos incluyendo variantes tanto de 32 como de 64 bit
* Capacidad para ejecutarse en el logueo de Windows  y otras pantallas seguras 
* Anunciado de controles y texto mientras se utilizan gestos táctiles
* Soporte para interfaces comunes de accesibilidad tales como Microsoft Active Accessibility, Java Access Bridge, IAccessible2 y UI Automation (UI Automation sólo es compatible con Windows 7 y versiones posteriores))
* Soporte para el símbolo del sistema de Windows y aplicaciones de consola

### Internacionalización {#Internationalization}

Es importante que la gente en cualquier parte del mundo, sin importar qué idioma hable, tenga un acceso equitativo a la tecnología. 
además del inglés, NVDA ha sido traducido a 54 idiomas incluyendo: Sudafricano, Albanés, Alemán (de Alemania y de Suiza), Birmano, Búlgaro, Catalán, Checo, Chino (simplificado y tradicional), Coreano, Croata, Danés, eslovaco, Esloveno, Español (Colombia y España), Farsi, Finlandés, Francés, Gallego, Georgiano, Griego, Hebreo, Hindi, Holandés, Húngaro, Irlandés, Islandés, Italiano, Japonés, Kannada, Kirguistaní, Lituano, Nepalí, Noruego, Macedonio, Mongol, Portugués(portugal y Brasil), Punjabi, Rumano, Ruso, Servio, Sueco, Tamil, Tailandés, turco, ucraniano y Vietnamita,.

### Soporte de Síntesis de Voz {#SpeechSynthesizerSupport}

Además de proporcionar sus mensajes y su interfaz en varias lenguas, NVDA también puede permitir al usuario leer contenidos en cualquier idioma, siempre y cuando disponga de un sintetizador de voz que pueda hablar en dicho idioma. 

NVDA se incluye con [eSpeak NG](https://github.com/espeak-ng/espeak-ng), un sintetizador de voz multilingüe, libre, de código abierto.

Se puede encontrar información acerca de otros sintetizadores de voz compatibles con NVDA en la sección [Sintetizadores de Voz soportados](#SupportedSpeechSynths).

### Soporte Braille {#BrailleSupport}

Para usuarios que posean una línea braille actualizable, NVDA puede mostrar su información en braille. 
También se soporta tanto la entrada de braille integral como estenográfico mediante un teclado braille.
Además, NVDA detectará muchas líneas braille automáticamente por defecto.
Por favor consulta la sección [líneas braille Soportadas](#SupportedBrailleDisplays) para información acerca de las líneas braille soportadas.

NVDA soporta códigos braille para muchos idiomas, incluyendo códigos braille estenográfico, integral e informático.

### Licencia y Copyright {#LicenseAndCopyright}

NVDA es propiedad intelectual de NVDA_COPYRIGHT_YEARS por los colaboradores de NVDA.

NVDA está cubierto por la GNU General Public License (Versión 2). 
Eres libre para compartir o modificar este programa de cualquier modo que quieras aunque debes distribuir la licencia junto con el programa, y hacer todo el código fuente disponible a quien lo desee. 
Esto se aplica tanto al original como a las copias modificadas del programa, más cualquier software que utilice código derivado de éste. 
Para más detalles, puedes [ver la licencia completa.](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html)

## Requisitos del Sistema {#SystemRequirements}

* Sistemas operativos: todas las ediciones de 32 y 64 bits de Windows 7, Windows 8, Windows 8.1, Windows 10 y todos los sistemas operativos servidor a partir de Windows Server 2008 R2..
 * Para Windows 7, NVDA requiere del Service Pack 1 o superior.
 * Para Windows Server 2008 R2, NVDA requiere del Service Pack 1 o superior.
* Memoria: 256 mb o más de RAM
* Velocidad de Procesador: 1.0 ghz o superior
* Aproximadamente 90 MB de espacio de almacenamiento.

## Obteniendo e Instalando NVDA {#GettingAndSettingUpNVDA}

Si todavía no tienes una copia de NVDA, puedes descargarla de [www.nvaccess.org](NVDA_URL).

Vé a la sección download y encontrarás un enlace para descargar la última versión de NVDA.

Al ejecutar el fichero que has descargado comenzará una copia temporal de NVDA.
Entonces se te preguntará si quieres instalar NVDA, crear una copia portable, o sólo continuar utilizando la copia temporal.

Si planeas utilizar siempre NVDA en este ordenador, elegirás instalarlo.
Al instalar NVDA permitirás funcionalidad adicional tal como el arrancado automático después del logueo, capacidad de leer las pantallas de logueo de Windows y las pantallas seguras (lo cual resulta imposible con las copias portables y temporales), y creación de atajos del menú Inicio y del Escritorio.
La copia instalada también es capaz de crear una copia portable por si misma en cualquier momento.

Si quieres tener a NVDA contigo en un lápiz USB u otro medio portátil, entonces deberías elegir crear una copia portable.
La copia portable también tiene la capacidad de instalarse en cualquier ordenador en un momento posterior.
Sin embargo, si deseas copiar a NVDA en un medio de sólo lectura tal como un CD, sólo deberías copiar el paquete descargado.
En este momento no se admite la ejecución de la versión portable directamente desde medios de sólo lectura.

Usar  la copia temporal de NVDA es también una opción, por ejemplo: con fines de demostración, aunque iniciar NVDA de este modo cada vez puede llegar a consumir mucho tiempo.

### Restricciones de la Copia Portable y Temporal {#PortableAndTemporaryCopyRestrictions}

Además de la imposibilidad de iniciarse automáticamente durante y/o después del logueo, las copias portables y temporales de NVDA también tienen las siguientes restricciones:

* La imposibilidad de interactuar con aplicaciones que se ejecuten con privilegios de administrador, a menos que, por supuesto, el mismo NVDA también haya sido ejecutado con estos privilegios (no recomendado).
* La imposibilidad de leer las pantallas del Control de Cuentas de Usuario (UAC) cuando se trate de iniciar una aplicación con privilegios de administrador.
* Windows 8 y posterior: la incapacidad para soportar la entrada desde una pantalla táctil.
* Windows 8 y posterior: la incapacidad de proporcionar características tales como modo exploración y verbalización de caracteres al escribir en aplicaciones de la tienda Windows.
* Windows 8 y posterior: No se soporta la atenuación de audio.

### Instalando NVDA {#InstallingNVDA}

Si se instala NVDA directamente desde el paquete descargado de NVDA, presiona el botón Instalar NVDA.
Si ya has cerrado este diálogo, o quieres instalar desde una copia portable, por favor elige el elemento de menú Instalar NVDA encontrado en Herramientas en el menú NVDA.

El diálogo de instalación que aparece confirmará si quieres instalar NVDA, y también te dirá si esta instalación actualizará una instalación anterior.
presionando el botón Continuar comenzará la Instalación de NVDA.
Hay también algunas opciones en este diálogo que se explican más abajo.
Una vez se haya completado la instalación, aparecerá un mensaje diciéndote que se ha realizado con éxito.
presionando Aceptar en este punto se reiniciará la copia nueva instalada de NVDA.

#### Advertencia sobre complementos incompatibles {#InstallWithIncompatibleAddons}

Si ya tienes complementos instalados también puede haber una advertencia de que se deshabilitarán los complementos incompatibles.
Antes de poder presionar el botón Continuar tendrás que utilizar la casilla de verificación para confirmar que comprendes que estos complementos serán desactivados.
También habrá presente un botón para revisar los complementos que se deshabilitarán.
Consulta la [sección diálogo complementos incompatibles](#incompatibleAddonsManager) para más ayuda sobre este botón.

#### Arrancar en el logueo de Windows {#StartAtWindowsLogon}

Esta opción te permite elegir si NVDA debería arrancar automáticamente o no mientras está en la ventana de logueo de Windows, antes de haber enterducido una clave.
Esto también incluye el control de cuentas de usuario y otras pantallas seguras.
Esta opción está habilitada por defecto para instalaciones nuevas.

#### Crear Atajos del Escritorio (ctrl+alt+n) {#CreateDesktopShortcut}

Esta opción te permite elegir si NVDA debería crear o no un atajo en el escritorio para iniciar NVDA. 
Si se creó, a este atajo  también se le asignará una tecla de atajo control+alt+n permitiéndote iniciar a NVDA en cualquier ocasión con esta combinación de teclas.

#### Copiar Configuración del Portable a la Cuenta de Usuario actual {#CopyPortableConfigurationToCurrentUserAccount}

Esta opción te permite elegir si NVDA debería copiar o no la configuración del usuario del  NVDA actualmente en ejecución a la configuración para el usuario actualmente logueado, para la copia instalada de NVDA. 
Esto no copiará la configuración para cualquier otro usuario de este sistema ni para la configuración del sistema para utilizar en el logueo de Windows y otras pantallas seguras.
Esta opción sólo está disponible cuando se instala desde una copia portable, no cuando se instala directamente desde el paquete Lanzador descargado.

### Creando una Copia Portable {#CreatingAPortableCopy}

Si se crea una copia portable directamente desde el paquete descargado de NVDA, simplemente presiona el botón Crear Copia Portable.
Si ya has cerrado este diálogo o estás ejecutando una copia instalada de NVDA, elige el elemento de menú Crear Copia Portable que se encuentra en Herramientas en el menú NVDA.

El diálogo que aparece te permite elegir dónde debería crearse la copia portable.
Esto puede ser un directorio en tu disco duro, o un lugar en un lápiz USB u otro medio portátil.
También hay una opción para elegir si NVDA debería copiar la sesión de configuración actual del usuario de NVDA para utilizarla con la nueva copia portable creada.
Esta opción sólo está disponible cuando se crea una copia portable desde una copia instalada, no cuando se crea desde el paquete descargado.
presionando Continuar crearás la copia portable.
Una vez la creación esté completada, aparecerá un mensaje diciéndote que se ha realizado con éxito.
presiona Aceptar para descartar este diálogo.

## Comenzando con NVDA {#GettingStartedWithNVDA}
### Lanzando NVDA {#LaunchingNVDA}

Si has instalado NVDA con el instalador, entonces iniciar NVDA es tan fácil como presionar control+Alt+n, o elegir NVDA desde el menú NVDA en Menú Inicio, submenú Programas. 
Además, puedes teclear NVDA en el diálogo Ejecutar y presionar enter. 
También puedes pasar algunas [opciones de línea de comandos](#CommandLineOptions) las cuales te permiten reiniciar NVDA (-r), salir (-q), deshabilitar complementos (--disable-addons), etc.

Para las copias instaladas, NVDA almacena la configuración en la carpeta roaming application data del usuario actual de forma predeterminada (por ejemplo: "C:\Users\<user>\AppData\Roaming").
Es posible cambiar esto de forma que NVDA cargue su configuración desde la carpeta local de datos de aplicación en su lugar.
Consulta la sección acerca de [parámetros del sistema](#SystemWideParameters) para más detalles.

Para iniciar la versión portable, vé al directorio en  el que descomprimiste NVDA, y presiona enter o haz doble clic en nvda.exe.

Cuando NVDA arranca, primero escucharás un grupo ascendente de tonos (que te dicen que NVDA está cargándose). 
Dependiendo cuán rápido sea tu ordenador, o si estás ejecutando NVDA desde un lápiz USB u otro medio más lento, podrá demorar un poco mientras arranca. 
Si se está tardando mucho tiempo, NVDA debería decir "Cargando NVDA. por favor aguarda...”

Si no escuchas nada de esto, o escuchas el sonido de error de Windows, o un grupo descendente de tonos, entonces esto significa que NVDA tiene un error, y posiblemente necesitarás informar de un fallo a los desarrolladores. 
Por favor investiga en el sitio Web de NVDA para saber cómo hacer esto.

#### Diálogo de Bienvenida {#WelcomeDialog}

Cuando NVDA arranque por primera vez, se te saludará mediante un cuadro de diálogo que te proporciona un poco de información básica acerca de la tecla modificadora de NVDA y del menú de NVDA. 
(consulta por favor secciones subsiguientes acerca de estos temas). 
El cuadro de diálogo también contiene un cuadro combinado y tres casillas de verificación. 
El cuadro combinado te permite seleccionar la distribución de teclado.
La primera casilla de verificación te permite controlar si NVDA debería utilizar BloqMayus como una tecla modificadora de NVDA. 
La segunda especifica si NVDA debería arrancar automáticamente después de loguearte en Windows y sólo está disponible para copias instaladas de NVDA.
La tercera te permite controlar si este cuadro de bienvenida debería aparecer cada vez que NVDA arranque.

++ Acerca de comandos de teclado de NVDA ++[AboutNVDAKeyboardCommands]2

#### La Tecla Modificadora NVDA {#TheNVDAModifierKey}

La mayoría de los comandos específicos de teclado de NVDA consisten normalmente en presionar la tecla modificadora de NVDA, junto con una o más teclas. 
Una notable excepción a  esto son los comandos de revisión de texto para la distribución de teclado de escritorio que sólo utilizan las teclas del teclado numérico en sí mismas, pero hay algunas otras excepciones también..

NVDA puede configurarse tal que o la tecla Insert del teclado numérico, o la Insert del extendido, y/o la BloqMayus puedan utilizarse como la tecla modificadora de NVDA.
De forma predeterminada tanto el insert del teclado numérico como el del teclado extendido pueden utilizarse como teclas modificadoras.

Si deseas hacer que una de las teclas modificadoras de NVDA se ccomporte como lo haría normalmente si NVDA no estuviese en marcha (por ejemplo deseas activar BloqMayus cuando tienes configurada BloqMayus para que sea una tecla modificadora de NVDA) puedes presionar la tecla dos veces seguidas.

#### Diseños de Teclado {#KeyboardLayouts}

Actualmente NVDA viene con dos conjuntos de  teclas de comandos conocidas como disposiciones de teclado. La disposición de escritorio y la disposición de portátil.
De forma predeterminada, NVDA está configurado para utilizar la disposición de escritorio, aunque puedes cambiar a la de portátil en la categoría Teclado del cuadro de diálogo [Opciones de NVDA](#NVDASettings) en Preferencias en el menú NVDA.

La disposición de escritorio hace un uso amplio del teclado numérico (con el bloqueo numérico desactivado).
Aunque la mayoría de los portátiles no tienen un teclado numérico físico, algunos portátiles pueden emularlo manteniendo presionada la tecla FN y presionando letras y números en el lado derecho del teclado (7 8 9 u i o j k l etc.).
Si tu portátil no puede hacer esto, o no te permite desactivar el bloqueo numérico, es posible que desees cambiar a la disposición Portátil en su lugar.

### Gestos táctiles de NVDA {#NVDATouchGestures}

Si estás ejecutando NVDA en un dispositivo con una pantalla táctil y con Windows 8 o superior, también puedes controlar a NVDA directamente a través de comandos táctiles.
Mientras NVDA esté en ejecución, toda la entrada táctil irá directamente a NVDA. 
Por lo tanto, las acciones que puedan efectuarse normalmente sin NVDA no funcionarán.

#### Explorando la Pantalla {#ExploringTheScreen}

La acción más básica que puedes realizar con la pantalla táctil es anunciar el control o el texto en cualquier punto en la pantalla.
Para hacer esto, pon un dedo en cualquier lugar sobre la pantalla.
También puedes mantener tu dedo sobre la pantalla y moverlo para leer otros controles y texto sobre los que vaya pasando.

#### Gestos Táctiles {#TouchGestures}

Cuando se describan los comandos de NVDA de ahora en adelante en esta guía del usuario, podrán listar un gesto táctil que se puede utilizar para activar esa orden con la pantalla táctil.
Seguidamente van algunas instrucciones sobre cómo llevar a cabo varios gestos táctiles.

##### Toques {#toc25}

Tocar la pantalla brevemente con uno o más dedos.

A tocar una vez con un dedo se le conoce como tocar.
Tocar con dos dedos al mismo tiempo es un toque de 2 dedos y así sucesivamente.

Si el mismo toque se realiza una o más veces en sucesión rápida, NVDA lo tratará en cambio como un gesto de presionación múltiple.
Tocar dos veces resultará en un doble toque.
Tocar tres veces resultará en un tripple toque y así sucesivamente.
Por supuesto, estos gestos de toque múltiple también reconocen cuántos dedos fueron utilizados, así es posible tener gestos como un toque triple con 2 dedos, o un toque con 4 dedos, etc. 

##### Deslizamientos {#toc26}

Desliza el dedo rápidamente por la pantalla.

Hay 4 gestos de deslizamiento posibles dependiendo de la dirección: deslizar a la izquierda, deslizar a la derecha, deslizar arriba y deslizar abajo.

Al igual que con los toques, se puede utilizar más de un dedo para realizar el gesto.
Por lo tanto, gestos tales como deslizar dos dedos arriba o deslizar 4 dedos a la izquierda son todos posibles.

#### Modos Táctiles {#TouchModes}

Como hay muchas más comandos de NVDA que los posibles gestos táctiles, NVDA tiene varios modos táctiles entre los que puedes cambiar, que hacen disponibles ciertos subconjuntos de comandos.
Los dos modos que existen por ahora son modo texto y modo objeto. 
Ciertas comandos de NVDA mostradas en este documento podrán tener un modo táctil mostrado entre paréntesis después del gesto táctil.
Por ejemplo: deslizar arriba (modo texto) significa que la orden se realizará si deslizas arriba, pero sólo mientras estés en modo texto.
Si la orden no tiene un modo asociado con ella, funcionará en cualquier modo.

<!-- KC:beginInclude -->
Para alternar entre los dos modos, realiza un toque con 3 dedos.
<!-- KC:endInclude -->

#### Teclado Táctil {#TouchKeyboard}

El teclado táctil se utiliza para enterducir texto y comandos desde una pantalla táctil.
Cuando se enfoque un campo de edición, puedes desplegar el teclado táctil tocando dos veces sobre el icono del teclado táctil en la parte inferior de la pantalla.
Para tablets tales como Microsoft Surface Pro, el teclado táctil siempre está disponible cuando se desacopla el teclado.
Para salir del teclado táctil, toca dos veces el icono del teclado táctil o sal fuera del campo de edición.

Mientras el teclado táctil esté activo, para localizar las teclas, mueve el dedo al lugar donde se encuentre el teclado táctil (normalmente en la parte inferior de la pantalla), y, a continuación, desplázate por él con un dedo.
Cuando encuentres la tecla que desees presionar, toca dos veces la tecla o levanta el dedo, según las opciones elegidas desde [la categoría Opciones de Interacción Táctil](#TouchInteraction).

### Modo de Ayuda de Entrada {#InputHelpMode}

Se mencionan muchas comandos de teclado y gestos a lo largo del resto de esta guía del usuario, pero una manera fácil de explorar todas las diferentes comandos es activar la ayuda de entrada.

Para activar la ayuda de entrada, presiona NVDA+1.
Para desactivarla, presiona NVDA+1 de nuevo.
Mientras estés en la ayuda de entrada, presionando cualquier tecla o realizando cualquier gesto táctil se anunciará la acción y se describirá qué hace (si es que hace algo).
los comandos reales no se ejecutarán mientras se esté en el modo de ayuda de entrada.

### El Menú NVDA {#TheNVDAMenu}

El menú NVDA te permite controlar las opciones de NVDA, acceder a la ayuda, guardar/volver a tu configuración, Modificar los diccionarios del habla, leer el fichero de registro, y salir de NVDA.

Para desplegar el menú NVDA desde cualquier lugar de Windows mientras NVDA se esté ejecutando, presiona NVDA+n en el teclado o realiza un doble toque con 2 dedos en la pantalla táctil. 
También puedes desplegar el menú NVDA a través de la bandeja de sistema de Windows. 
O haciendo clic con el botón derecho sobre el icono NVDA encontrado en la bandeja de sistema, o accediendo a la bandeja de sistema presionando la tecla con el logo de Windows+B, flecha abajo hasta el icono de  NVDA y presionando la tecla aplicaciones encontrada junto a la tecla de control de la derecha en la mayoría de los teclados. 
Cuando aparezca el menú, puedes utilizar las teclas de cursor para navegar por él, y la tecla enter para activar un elemento.

### comandos Básicas de NVDA {#BasicNVDACommands}

<!-- KC:beginInclude -->

| Nombre |Tecla escritorio |Tecla portátil |Táctil |Descripción|
|---|---|---|---|---|
|Detener voz |Control |control |toque con 2 dedos |Detiene la voz instantáneamente|
|Pausar Voz |Shift |shift |no |Pausa la voz instantáneamente, presionándola nuevamente continuará hablando donde se detuvo (si el pausado se soporta por el sintetizador actual)|
|Menú NVDA |NVDA+n |NVDA+n |doble toque con 2 dedos |despliega el menú NVDA para permitirte acceder a preferencias, herramientas, ayuda, etc.|
|Conmutar Modo Ayuda de entrada |NVDA+1 |NVDA+1 |no |presionando cualquier tecla  en este modo se anunciará la tecla, y la descripción de cualquier orden de NVDA asociada con ella|
|Conmutar Modo de Voz |NVDA+s |NVDA+s |no |Conmuta el modo voz entre verbalizar, pitidos y desactivado.|
|Salir de NVDA |NVDA+q |NVDA+q |no |Sale de NVDA|
|Dejar pasar siguiente tecla |NVDA+f2 |NVDA+f2 |no |Dice a NVDA que deje pasar la siguiente tecla presionada directamente a la aplicación activa, si está normalmente tratada como una tecla de comandos de NVDA|
|activar y desactivar modo de aplicación silencioso |NVDA+shift+s |NVDA+shift+z |no |el modo silencioso desactiva todas los comandos de NVDA y la salida de voz/braille para la aplicación actual. Esto es más útil en aplicaciones que proporcionan su propia voz o características de lectura de pantalla. presiona esta orden nuevamente para desactivar el modo silencioso.|

<!-- KC:endInclude -->

### Anunciando Información del Sistema {#ReportingSystemInformation}

<!-- KC:beginInclude -->

| Nombre |tecla |Descripción|
|---|---|---|
|Anunciar fecha/hora |NVDA+f12 |presionándola una vez anuncia la hora actual, presionándola dos veces anuncia la fecha.|
|Anunciar estado de la batería |NVDA+shift+b |Anuncia el estado de la batería, es decir si la electricidad está utilizándose o el porcentaje actual de la carga.|
|Anunciar el texto en el portapapeles |NVDA+c |Anuncia el Texto en el portapapeles si hay alguno.|

<!-- KC:endInclude -->

## Navegando con NVDA {#NavigatingWithNVDA}

NVDA te permite explorar y navegar por el sistema de varias maneras, incluyendo tanto la interacción normal como la revisión.

### Objetos {#Objects}

Cada Aplicación y el propio sistema operativo están formados por muchos objetos.
Un objeto es un único elemento tal como un fragmento de texto, un botón, una casilla de verificación, un deslizador, una lista o un campo de texto editable.

### Navegando con el Foco del Sistema {#SystemFocus}

El foco del sistema, también conocido simplemente como el foco, es el [objeto](#Objects) que recibe teclas escritas en el teclado.
Por ejemplo, si estás escribiendo en un campo de texto editable, el campo de texto editable tiene el foco.

El modo más común de navegar por Windows con NVDA, es sólo moverse con los comandos de teclado normales, tales como tab. Y shift tab. Para moverse adelante y atrás entre controles, presionando Alt. Para desplegar la barra de menú y luego utilizando las teclas de cursor para navegar por los menús, utilizando Alt-tab. Para moverse entre aplicaciones en ejecución. 
Cuando hagas esto, NVDA anunciará información sobre lo que tiene el foco, tal como su nombre, tipo, valor, estado, descripción, atajo de teclado e información posicional.

Hay algunas comandos de teclado útiles cuando nos movamos con el foco:
<!-- KC:beginInclude -->

| Nombre |tecla escritorio |tecla portátil |Descripción|
|---|---|---|---|
|Anunciar foco actual |NVDA+tab |NVDA+tab |anuncia el objeto actual o control que tenga el foco del sistema. presionando dos veces deletreará la información|
|Anunciar título |NVDA+t |NVDA+t |Anuncia el título de la ventana activa actualmente. presionando dos veces deletreará la información. presionándolo tres veces la copiará al portapapeles|
|Leer la ventana activa |NVDA+b |NVDA+b |lee todos los controles en la ventana actualmente activa (útil para diálogos)|
|Anunciar Barra de Estado |NVDA+fin |NVDA+shift+fin |Anuncia la barra de estado si NVDA encuentra una. También mueve el navegador de objetos a esta localización. presionándola dos veces deletreará la información. presionándola tres veces la copiará al portapapeles|

<!-- KC:endInclude -->

### Navegando con el Cursor del Sistema {#SystemCaret}

Cuando un [objeto](#Objects) que permite navegación y/o edición de texto se [enfoca](#SystemFocus), puedes moverte a través del texto utilizando el cursor del sistema, también conocido como el cursor de edición.

Cuando el foco esté sobre un objeto que tenga el cursor del sistema, puedes utilizar las teclas de cursor, retroceso de página, avance de página, inicio, fin, etc. para moverte a través del texto.
También puedes cambiar el texto si el control admite la edición.
NVDA anunciará a medida que te muevas por caráccteres, palabras, líneas, y también anunciará la selección y no selección de texto.

NVDA proporciona las siguientes teclas de comandos en relación al cursor del sistema:
<!-- KC:beginInclude -->

| Nombre |Tecla escritorio |Tecla portátil |Descripción|
|---|---|---|---|
|Leer todo |NVDA+Flecha Abajo |NVDA+a |Comienza la lectura desde la posición actual del cursor del sistema, moviéndolo según se desplaza|
|Leer línea actual |NVDA+Flecha Arriba |NVDA+l |Lee la línea donde esté situado actualmente el cursor del sistema. presionando dos veces deletrea la línea. presionando tres veces deletrea la línea utilizando descripciones de caracteres.|
|Leer la selección de texto actual |NVDA+Shift+Flecha Arriba |NVDA+shift+s |Lee cualquier texto seleccionado actualmente|
|frase siguiente |alt+flecha abajo |alt+flecha abajo |Mueve el cursor a la frase siguiente y la anuncia. (sólo se soporta en Microsoft Word y Outlook)|
|frase anterior |alt+flecha arriba |alt+flecha arriba |Mueve el cursor a la frase anterior y la anuncia. (sólo se soporta en Microsoft Word y Outlook)|

Cuando estés en una tabla, las siguientes teclas de comandos también están disponibles:

| Nombre |Tecla |Descripción|
|---|---|---|
|Moverse a la columna anterior |control+Alt+Flecha Izquierda |Mueve el cursor del sistema a la columna anterior (permaneciendo en la misma fila)|
|Moverse a la columna siguiente |control+Alt+Flecha Derecha |Mueve el cursor del sistema a la columna siguiente (permaneciendo en la misma fila)|
|Moverse a la fila anterior |control+Alt+Flecha Arriba |Mueve el cursor del sistema a la fila anterior (permaneciendo en la misma columna)|
|Moverse a la fila siguiente |control+Alt+Flecha Abajo |Mueve el cursor del sistema a la siguiente fila (permaneciendo en la misma columna)|

<!-- KC:endInclude -->

### Navegación de Objetos {#ObjectNavigation}

La mayor parte del tiempo, trabajarás con aplicaciones utilizando  comandos que muevan [el foco](#SystemFocus) y [el cursor](#SystemCaret).
Sin embargo, a veces, es posible que desees explorar la aplicación actual o el Sistema Operativo sin mover el foco o el cursor.
También es posible que desees trabajar con [objetos](#Objects) a los que no se pueda acceder normalmente utilizando el teclado.
En estos casos, puedes utilizar la navegación de objetos.

La navegación de objetos te permite desplazarte y obtener información acerca de [objetos](#Objects) individuales.
Cuando te muevas a un objeto, NVDA lo anunciará de modo similar a como anuncia el foco del sistema.
Para una forma de revisar todo el texto tal y como aparece en la pantalla, puedes utilizar a cambio [revisión de pantalla](#ScreenReview).

En lugar de tener que moverse atrás y adelante de un objeto a otro en el sistema, los objetos se agrupan jerárquicamente.
Esto significa que algunos objetos contienen otros objetos y debes moverte dentro de ellos para acceder a los objetos que contienen.
Por ejemplo, una lista contiene elementos de lista, por lo que debes moverte dentro de la lista para acceder a sus elementos.
Si te has movido a un elemento de lista, te puedes mover a su objeto contenedor para volver a la lista y entonces pasarla si lo deseas.
Moviéndote a un elemento de lista conteniendo un objeto te llevará atrás en la lista.
Entonces puedes pasar de la lista si deseas acceder a otros objetos.
Del mismo modo, en una barra de herramientas conteniendo controles, debes moverte dentro de la barra de herramientas para acceder a los controles de la misma.

El objeto actualmente en revisión se llama navegador de objetos.
Una vez que navegues a un objeto, puedes revisar su contenido utilizando las [comandos de revisión de texto](#ReviewingText) mientras se esté en [modo revisión de objetos](#ObjectReview).
De forma predeterminada, el navegador de objetos se mueve junto con el foco  del Sistema aunque este comportamiento puede activarse y desactivarse.

Ten en cuenta que el braille sigue al [foco](#SystemFocus) y al [cursor](#SystemCaret) así como por omisión a la navegación de objetos y a la revisión de texto.
Si quieres que siga sólo al foco y al cursor, necesitas [configurar que el braille siga al](#BrailleTether) foco.
En este caso, el braille no seguirá a la navegación de objetos ni a la revisión de texto.
Si quieres que el braille siga a la navegación de objetos y a la revisión de texto en su lugar, necesitas [configurar que el braille siga a la](#BrailleTether) revisión.

Para navegar por objetos, utiliza las siguientes comandos:

<!-- KC:beginInclude -->

| Nombre |Tecla Escritorio |Tecla Portátil |Táctil |Descripción|
|---|---|---|---|---|
|Anunciar objeto actual |NVDA+5 Teclado numérico |NVDA+shift+o |no |Anuncia el navegador de objetos actual. presionando dos veces deletrea la información y presionando 3 veces copia este nombre y valor del objeto al portapapeles.|
|Navegar a objeto contenedor |NVDA+8 teclado numérico |NVDA+shift+flecha arriba |deslizar arriba (Modo objeto) |Navega al contenedor del navegador de objetos actual|
|Navegar al objeto anterior |NVDA+4 teclado numérico |NVDA+shift+flecha izquierda |deslizar a la izquierda (modo objeto) |Navega al objeto directamente antes del actual navegador de objetos|
|Navegar al siguiente objeto |NVDA+6 teclado numérico |NVDA+shift+flecha derecha |deslizar a la derecha (modo objeto) |Navega al objeto directamente después del actual navegador de objetos|
|Navegar al primer objeto contenido |NVDA+2 teclado numérico |NVDA+shift+flecha abajo |deslizar abajo (modo objeto) |Navega al primer objeto contenido por el actual navegador de objetos|
|Navegar al objeto del foco |NVDA+Menos teclado numérico |NVDA+Retroceso |no |Navega al objeto que tiene actualmente el foco del sistema, y también coloca el cursor de revisión en la posición del cursor del Sistema, si se muestra|
|Activar actual navegador de objetos |NVDA+enter teclado numérico |NVDA+enter |doble toque |Activa el actual navegador de objetos (similar a hacer clic con el ratón o presionar espacio cuando tiene el foco del sistema)|
|Mover foco del Sistema a actual navegador de objetos |NVDA+shift+Menos teclado numérico |NVDA+shift+retroceso |no |presionado una vez Mueve el foco del Sistema al navegador de objetos actual, presionado dos veces mueve el cursor del sistema a la posición del cursor de revisión|
|Anunciar dimensiones del navegador de objetos |NVDA+Suprimir teclado numérico |NVDA+suprimir |no |Anuncia información acerca de la localización del texto u objeto EN EL cursor DE REVISIÓN. Por ejemplo, esto podría incluir el porcentaje del documento, la distancia desde el borde de la página o la posición exacta en la pantalla. Al presionar dos veces podrá  proporcionar detalles adicionales.|

<!-- KC:endInclude -->

nota: las teclas del teclado numérico requieren que la tecla BloqNum esté desactivada para funcionar apropiadamente.

### Revisando Texto {#ReviewingText}

NVDA te permite leer el contenido de la [pantalla](#ScreenReview), [documento actual](#DocumentReview) o [objeto actual](#ObjectReview) por caracteres, palabras o líneas.
Esto es muy útil en lugares (incluyendo la consola del Dos de Windows) donde no haya la existencia de un  [cursor del sistema](#SystemCaret).
Por ejemplo, puedes utilizarlo para revisar el texto de un largo mensaje de información en un diálogo.

Al mover el cursor de revisión, el cursor del Sistema no lo sigue, por lo que puedes revisar texto sin perder la posición de edición.
No obstante, de forma predeterminada, cuando el cursor del Sistema se mueve, el cursor de revisión lo sigue.
Esto puede activarse y desactivarse.

Ten en cuenta que el braille sigue al [foco](#SystemFocus) y al [cursor del sistema](#SystemCaret) de forma predeterminada, en lugar de al navegador de objetos y a la revisión de texto.
Si en su lugar quieres seguir al navegador de objetos y a la revisión de texto, necesitas [configurar que el braille siga](#BrailleTether) a la revisión.

Las siguientes comandos están disponibles para revisión de texto: 
<!-- KC:beginInclude -->

| Nombre |Tecla Escritorio |Tecla Portátil |Táctil |Descripción|
|---|---|---|---|---|
|mover a la línea superior en revisión |shift+7 teclado numérico |NVDA+control+inicio |no |Mueve el cursor de revisión a la línea superior del texto|
|Mover a la línea anterior en revisión |7 teclado numérico |NVDA+flecha arriba |deslizar arriba (modo texto) |Mueve el cursor de revisión a la línea anterior de texto|
|Anunciar línea actual en revisión |8 teclado numérico |NVDA+shift+. |no |Anuncia la línea actual de texto donde esté colocado el cursor de revisión. presionando dos veces deletrea la línea, presionando tres veces deletrea la línea utilizando descripciones de caracteres.|
|Mover a la línea siguiente en revisión |9 teclado numérico |NVDA+FLECHA abajo |deslizar abajo (modo texto) |Mueve el cursor de revisión a la línea siguiente de texto|
|Mover a la línea inferior en revisión |shift+9 teclado numérico |NVDA+control+fin |no |Mueve el cursor de revisión a la línea inferior de texto|
|Mover a la palabra anterior en revisión |4 teclado numérico |NVDA+control+flecha izquierda |deslizar con 2 dedos a la izquierda (modo texto) |Mueve el cursor de revisión a la palabra anterior en el texto|
|Anunciar palabra actual en revisión |5 teclado numérico |NVDA+control+. |no |Anuncia la palabra actual en el texto donde esté posicionado el cursor de revisión. presionando dos veces deletrea la palabra, presionando tres veces deletrea la palabra utilizando descripciones de caracteres.|
|Mover a la siguiente palabra en revisión |6 teclado numérico |NVDA+control+flecha derecha |desplazar con 2 dedos a la derecha (modo texto) |Mueve el cursor de revisión a la siguiente palabra en el texto|
|mover al inicio de la línea en revisión |shift+1 teclado numérico |NVDA+inicio |no |Mueve el cursor de revisión al comienzo de la línea actual en el texto|
|Mover al carácter anterior en revisión |1 teclado numérico |NVDA+flecha izquierda |deslizar a la izquierda (modo texto) |Mueve el cursor de revisión al carácter anterior en la línea actual en el texto|
|Anunciar carácter actual en revisión |2 teclado numérico |NVDA+. |no |Anuncia el carácter actual en la línea de texto donde esté posicionado el cursor de revisión. presionando dos veces anuncia una descripción o ejemplo de ese carácter. presionando tres veces anuncia el valor numérico del carácter en decimal y hexadecimal.|
|Mover al siguiente carácter en revisión |3 teclado numérico |NVDA+flecha derecha |deslizar a la derecha (modo texto) |Mueve el cursor de revisión al siguiente carácter en la línea actual de texto|
|Mover al final de la línea en revisión |shift+3 teclado numérico |NVDA+fin |no |Mueve el cursor de revisión al final de la línea actual de texto|
|Leer todo con revisión |Más teclado numérico |NVDA+shift+a |deslizar con 3 dedos abajo (modo texto) |Lee desde la posición actual del cursor de revisión, moviéndolo según baja|
|Seleccionar después Copiar desde cursor de revisión |NVDA+f9 |NVDA+f9 |none |Comienza la selección después procesa la copia desde la posición actual del cursor de revisión. La acción actual no se lleva a cabo hasta que digas a NVDA dónde está el final del rango de texto|
|Seleccionar después copiar a cursor de revisión |NVDA+f10 |NVDA+f10 |none |En la primera presionación, el texto se selecciona desde encima de la posición previamente fijada como marca de comienzo e incluyendo la posición actual del cursor de revisión. Después de presionar esta tecla una segunda vez, el texto se copiará al portapapeles de Windows|
|Anunciar formato del texto |NVDA+f |NVDA+f |no |Informa del formato del texto donde esté situado actualmente el cursor de revisión. presionando dos veces muestra la información en modo exploración|
|Anunciar reemplazo de símbolo actual |No |No |no |Verbaliza el símbolo donde esté colocado el cursor de revisión. presionado dos veces, muestra el símbolo y el texto utilizado para verbalizarlo en modo exploración.|

<!-- KC:endInclude -->

nota: las teclas del teclado numérico requieren que la tecla BloqNum esté desactivada para funcionar apropiadamente.

Una buena manera Para recordar  los comandos básicas de revisión de texsto cuando se utiliza la disposición de escritorio es imaginarlas en una rejilla de tres por tres, yendo de superior a inferior con línea, palabra y carácter y yendo de izquierda a derecha   con anterior, actual y siguiente.
La disposición está ilustrada como sigue:

|Línea anterior |Línea actual |Línea siguiente|
|Palabra anterior |Palabra actual |Palabra siguiente|
|carácter anterior |carácter actual |carácter siguiente|

### Modos de Revisión {#ReviewModes}

los comandos de revisión de texto de NVDA pueden revisar el contenido dentro del navegador de objetos actual, documento actual, o pantalla, dependiendo del modo de revisión seleccionado.
Los modos de revisión son un  reemplazo para el antiguo concepto de revisión plana de NVDA.

los comandos que siguen cambian entre los modos de revisión:
<!-- KC:beginInclude -->

| Nombre |Tecla Escritorio |Tecla Portátil |Táctil |Descripción|
|---|---|---|---|---|
|Cambiar al  modo de revisión siguiente |NVDA+7 teclado numérico |NVDA+repág |deslizar 2 dedos arriba |cambia al siguiente modo de revisión disponible.|
|cambiar al modo de revisión anterior |NVDA+1 teclado numérico |NVDA+avPág |deslizar 2 dedos hacia abajo |Cambia al siguiente modo de revisión disponible.|

<!-- KC:endInclude -->

#### Revisión de Objetos {#ObjectReview}

Mientras se esté en modo revisión de objetos, sólo podrás revisar el contenido del actual [navegador de objetos](#ObjectNavigation).
Para objetos tales como campos de edición u otros controles básicos de documento, Esto será generalmente el contenido de texto.
Para otros objetos, esto será el nombre y o valor.

#### Revisión de Documentos {#DocumentReview}

Cuando el [navegador de objetos](#ObjectNavigation) esté dentro de un documento en modo exploración (por ejemplo: página web) u otro documento complejo que contenga muchos objetos (por ejemplo: documentos de Lotus Symphony), es posible cambiar al modo revisión de documentos.
El modo revisión de documentos te permite revisar el texto del documento entero.

Cuando se cambie desde revisión de objetos a revisión de documentos, el cursor de revisión se coloca en el documento en la posición del navegador de objetos.
Al moverte por el documento con los comandos de revisión, el navegador de objetos se actualiza automáticamente al objeto que se encuentra en la  posición actual del cursor de revisión.

Ten en cuenta que NVDA cambiará a revisión de documentos desde revisión de objetos automáticamente cuando te muevas por documentos en modo exploración.

#### Revisión de Pantalla {#ScreenReview}

El modo revisión de pantalla te permite revisar el texto tal y como aparezca visualmente en la pantalla dentro de la aplicación actual.
Esto es similar a la funcionalidad de revisión de pantalla o cursor del ratón en muchos otros lectores de pantalla para Windows.

 Cuando se cambia al modo revisión de pantalla, el cursor de revisión se coloca en la posición de pantalla del actual [navegador de objetos](#ObjectNavigation).
 Cuando nos movamos por la pantalla con los comandos de revisión, el navegador de objetos se actualiza automáticamente al objeto encontrado en la posición de la pantalla del cursor de revisión.

 Ten en cuenta que en algunas aplicaciones modernas, NVDA podría no ver alguno o todo el texto disponible en la pantalla, debido al uso de las recientes tecnologías de dibujo en pantalla que son imposibles de soportar en estos momentos.

### Navegando con el Ratón {#NavigatingWithTheMouse}

Cuando mueves el ratón, NVDA informa de forma predeterminada del texto que esté directamente bajo el puntero del mismo, según se mueva sobre él. 
Donde se admita, NVDA leerá el valor de un párrafo de texto, aunque algunos controles sólo podrán leerse por líneas.

NVDA también puede configurarse para anunciar el tipo de control u objeto sobre el que esté actualmente el ratón según se mueva (por ejemplo: lista, botón etc.). 
Esto podrá ser útil para usuarios ciegos totales cuando algunas veces el texto no baste.

NVDA proporciona un modo para que los usuarios comprendan dónde está el ratón con respecto a las dimensiones de la pantalla, haciendo sonar las coordenadas actuales del ratón en forma de pitidos de audio. 
Cuanto más alto esté el ratón en la pantalla, más alto será El tono de los pitidos. 
Cuanto más a la izquierda o a la derecha esté el ratón en la pantalla, más a la izquierda o a la derecha parecerá ir el sonido (asumiendo que el usuario tenga altavoces estereofónicos).

Estas características extra del ratón no están activadas de forma predeterminada en NVDA. 
Si deseas sacar partido de ellas, puedes configurarlas desde la categoría [Opciones del Ratón](#MouseSettings), del diálogo [Opciones de NVDA](#NVDASettings) que se encuentra en el menú Preferencias de NVDA.

Si bien un ratón físico o un trackpad se podrían utilizar para navegar con el ratón, NVDA tiene unas pocas teclas de comandos relacionadas con el ratón:
<!-- KC:beginInclude -->

| Nombre |Tecla Escritorio |Tecla Portátil |Descripción|
|---|---|---|---|
|Clic botón izquierdo del ratón |Dividir teclado numérico |NVDA+` (acento grave) |Hace clic en el botón izquierdo del ratón una vez. El común doble clic puede llevarse a cabo presionando esta tecla dos veces en rápida sucesión|
|Bloquear botón izquierdo del ratón |shift+Dividir teclado numérico |NVDA+control+` (acento grave) |Mantiene presionado el botón izquierdo del ratón. Púlsalo de nuevo para liberarlo. Para arrastrar el ratón,  presiona esta tecla para bloquear el botón izquierdo y entonces mueve el ratón físicamente o utiliza una de las otras comandos de enrutamiento del ratón|
|Clic botón derecho del ratón |Multiplicar teclado numérico |NVDA++ (signo más) |Hace Clic en el botón derecho del ratón una vez.|
|Bloquear botón derecho del ratón |shift+Multiplicar teclado numérico |NVDA+control++ (signo más) |Mantiene presionado el botón derecho del ratón. presiona otra vez para liberarlo. Para arrastrar el ratón,  presiona esta tecla  para bloquear el botón derecho y entonces mueve el ratón físicamente o utiliza una de las otras comandos de enrutamiento del ratón|
|Mover ratón a navegador de objetos actual |NVDA+Dividir teclado numérico |NVDA+shift+m |Mueve el ratón a la posición del navegador de objetos actual y cursor de revisión|
|navegar al objeto bajo el ratón |NVDA+Multiplicar teclado numérico |NVDA+shift+n |Pone el navegador de objetos en el objeto localizado en la posición del ratón|

<!-- KC:endInclude -->

## Modo Exploración {#BrowseMode}

Los documentos complejos de sólo lectura, tales como páginas Web, se representan en NVDA con un Modo Exploración. 
Esto incluye documentos en las siguientes aplicaciones:

* Mozilla Firefox
* Microsoft Internet Explorer
* Mozilla Thunderbird
* Mmensajes HTML en Microsoft Outlook
* Google Chrome
* Microsoft Edge
* Adobe Reader
* Foxit Reader
* Adobe Flash.
* Libros admitidos en Amazon Kindle for PC

El modo Exploración también está opcionalmente disponible para documentos de Microsoft Word.

En el Modo Exploración, el contenido del documento está disponible mediante una representación plana por el que te puedes mover con las teclas de cursor como si se tratara de un documento de texto normal. 
Todas las teclas de comandos de [cursor del sistema](#SystemCaret) de NVDA funcionarán en este modo; por ejemplo: leer todo, anunciar formato, comandos de navegación de tabla, etc.
La información tal como si el texto es un enlace,  encabezado, etc. se anuncia junto con el texto según te muevas.

A veces, necesitarás interactuar directamente con controles en estos documentos.
+Por ejemplo, tendrás que hacer esto para campos de texto editable y listas tal que puedas escribir caracteres y utilizar las teclas de cursor para trabajar con el control.
Esto se hace cambiando a modo foco, donde casi todas las teclas se pasan al control.
Cuando se está en modo Exploración, por defecto, NVDA cambiará automáticamente a modo foco si tabulas a o haces clic sobre un control en particular que lo requiera.
En cambio, tabulando o haciendo clic sobre un control que no requiera modo foco retornará a modo exploración.
También puedes presionar enter o espacio para cambiar a modo foco en controles que lo requieran.
presionando escape volverás a modo exploración.
Además, puedes forzar manualmente el modo foco, después de lo cual permanecerá efectivo hasta que elijas desactivarlo.

<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Alternar modos exploración/foco |NVDA+espacio |Conmuta entre modo foco y modo Exploración|
|Salir de modo foco |escape |Cambia a modo exploración si el modo foco anteriormente estaba cambiado automáticamente|
|Refrescar documento en modo exploración |NVDA+f5 |Recarga el contenido del documento actual (útil si ciertos contenidos parecen estar desaparecidos del documento. No disponible en Microsoft Word y Outlook.)|
|Buscar |NVDA+control+f |Despliega un diálogo en el que puedes teclear algún texto a encontrar en el  documento actual. Consulta [buscar texto](#SearchingForText) para más información.|
|Buscar siguiente |NVDA+f3 |Encuentra la siguiente  ocurrencia del texto en el documento que buscaste anteriormente|
|Buscar anterior |NVDA+shift+f3 |Encuentra la ocurrencia anterior del texto en el documento buscado anteriormente|
|abrir descripción larga |NVDA+d |Abre una ventana nueva conteniendo una descripción larga para el elemento sobre el que esté si tiene una.|

<!-- KC:endInclude -->

### Navegación con una Sola Letra {#SingleLetterNavigation}

Mientras se esté en modo exploración, para una navegación más rápida NVDA también proporciona teclas de un solo carácter para saltar a ciertos campos en el documento.
Ten en cuenta que no todas estas comandos se soportan en cada tipo de documento.

<!-- KC:beginInclude -->
Las siguientes teclas por sí mismas saltan al siguiente campo, con la tecla shift saltan al anterior campo.

* h: Encabezado
* l: lista
* i: elemento de lista
* t: tabla
* k: enlace
* n: texto que no es enlace
* f: campo de formulario
* u: enlace no visitado
* v: enlace visitado
* e: campo de edición
* b: botón
* x: casilla de verificación
* c: cuadro combinado
* r: botón de opción
* q: cita
* s: separador
* m: marco
* g: gráfico
* d: región
* o: objeto integrado (reproductor de audio y vídeo, aplicación, diálogo, etc.)
* 1 a 6: encabezados de 1 a 6 respectivamente
* a: anotación (comentario, revisión del editor, etc.)
* w: error de ortografía

Para moverte al comienzo o final de elementos contenedores tales como listas y tablas:

| Nombre |Tecla |Descripción|
|---|---|---|
|Mover al comienzo de un contenedor |shift+coma |Se mueve al comienzo del contenedor (lista, tabla etc) donde esté situado el cursor|
|Mover al final del contenedor |coma |Se mueve al final del contenedor (lista, tabla etc) donde esté situado el cursor|

<!-- KC:endInclude -->

Algunas aplicaciones web tales como Gmail, Twitter y Facebook utilizan letras solas como atajos de teclado.
Si quieres utilizar éstas aún podrás usar las teclas de cursor para leer en modo exploración, puedes desactivar temporalmente  las teclas de navegación con una sola letra de NVDA.
<!-- KC:beginInclude -->
Para activar o desactivar la navegación con una sola letra para el documento actual, presiona NVDA+shift+espacio.
<!-- KC:endInclude -->

### La Lista de Elementos {#ElementsList}

La lista de elementos proporciona acceso a una lista de varios tipos de elementos en el documento según sea apropiado para la aplicación.
Por ejemplo, en navegadores web, la lista de elementos puede enumerar enlaces, encabezados, campos de formulario, botones o regiones.
Los botones de opción te permiten cambiar entre los diferentes tipos de elementos.
Se Proporciona también un campo de edición en el diálogo el cual te permite filtrar la lista para ayudarte a buscar un elemento en particular en la página. 
Una vez hayas elegido un elemento, puedes utilizar los botones proporcionados en el diálogo para moverte a, o activar, ese elemento.
<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Lista de elementos del Modo Exploración |NVDA+f7 |Lista  varios tipos de elementos en el documento actual|

<!-- KC:endInclude -->

### Buscar texto {#SearchingForText}

Este diálogo te permite buscar términos en el documento actual.
En el campo "Teclea el texto que desees encontrar", puede enterducirse el texto a encontrar.
La casilla de verificación "Sensible a las mayúsculas" hace que la búsqueda considere letras en mayúsculas y en minúsculas de modo diferente.
Por ejemplo, con "Sensible a las mayúsculas" seleccionada puedes encontrar "NV Access" pero no "nv access".
Utiliza las siguientes teclas para realizar  búsquedas:
<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Buscar texto |NVDA+control+f |Abre el diálogo buscar|
|Buscar siguiente |NVDA+f3 |Busca la siguiente ocurrencia del término buscado actual||
|Buscar anterior |NVDA+shift+f3 |Busca la ocurrencia anterior del término buscado actual|

<!-- KC:endInclude -->

### Objetos Integrados {#ImbeddedObjects}

Las páginas pueden incluir contenido enriquecido utilizando tecnologías tales como Adobe Flash, Oracle Java y HTML5, así como aplicaciones y diálogos. 
En los casos en que se encuentren en el modo de Navegación, NVDA anunciará "objeto integrado", "aplicación" o "diálogo", respectivamente.
Puedes moverte rápidamente a ellos utilizando las teclas de navegación de una sola tecla de objetos integrados o y shift+o.
Para interactuar con estos objetos, puedes presionar enter sobre ellos.
Si son accesibles, entonces puedes tabular por ellos e interactuar como con cualquier otra aplicación. 
Se proporciona una orden de teclado para regresar a la página original que contiene al objeto integrado.
<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Mover al contenido del modo de Navegación |NVDA+control+espacio |Mueve el foco fuera del actual objeto integrado y lo pone dentro del documento que lo contiene|

<!-- KC:endInclude -->

## Leyendo Contenido Matemático {#ReadingMath}

Utilizando MathPlayer 4 from Design Science, NVDA puede leer y navegar interactivamente por el contenido matemático soportado.
Esto requiere que MathPlayer 4 esté instalado en el ordenador.
MathPlayer está disponible como una descarga gratuita desde: https://www.dessci.com/en/products/mathplayer/

NVDA admite los siguientes tipos de contenidos matemáticos:

* MathML en Mozilla Firefox Microsoft Internet Explorer y Google Chrome..
* Design Science MathType en Microsoft Word y PowerPoint.
MathType tiene que estar instalado para que esto funcione. La versión de prueba es suficiente.
* MathML en Adobe Reader.
Ten en cuenta que esto no es un estándar official aún, así que no hay actualmente software disponible al público que pueda producir este contenido.
* Matemáticas en Kindle para PC para libros con matemáticas accesibles.

Al leer un documento, NVDA verbalizará cualquier contenido matemático compatible donde aparezca.
Si estás utilizando una pantalla braille, también se mostrará en braille.

### Navegación Interactiva {#InteractiveNavigation}

Si estás trabajando principalmente con voz, en la mayoría de los casos, probablemente desearás examinar la expresión en segmentos más pequeños, en lugar de escuchar la expresión entera de una vez.

Si estás en modo exploración, puedes hacer esto moviendo el cursor al contenido matemático y presionando enter.

Si no estás en modo exploración:

1. mueve el cursor de revisión al contenido matemático.
Por omisión, el cursor de revisión sigue al cursor del sistema, así puedes utilizar normalmente el cursor del sistema para moverte al contenido deseado.
1. A continuación, activa la siguiente orden:

<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Interactuar con contenido matemático |NVDA+alt+m |Comienza la interacción con el contenido matemático.|

<!-- KC:endInclude -->

En este punto, puedes utilizar comandos de MathPlayer tales como las teclas de cursor para explorar la  expresión.
Por ejemplo, puedes moverte a través de la expresión con las teclas de flecha  izquierda o derecha y acercarte a una porción de la expresión tal como una fracción utilizando la tecla de flecha abajo.
Por favor consulta la [documentación de MathPlayer acerca de comandos de navegación](https://www.dessci.com/en/products/mathplayer/navigation_commands.htm) para información adicional.

Cuando desees volver al documento, simplemente presiona la tecla escape.

## Braille {#Braille}

Si tienes una pantalla braille, NVDA puede mostrar información en braille.
Si tu pantalla braille tiene un teclado tipo Perkins, también puedes enterducir braille contraído o sin contraer.

Por favor consulta la sección [líneas braille admitidas](#SupportedBrailleDisplays) para información  acerca de las líneas braille soportadas.
Esta sección también contiene información sobre qué pantallas son compatibles con la función de detección automática de líneas braille de NVDA.
Puedes configurar el braille utilizando la [categoría Opciones de Braille](#BrailleSettings) del diálogo [Opciones de NVDA](#NVDASettings).

### Abreviaturas de tipos de Control, estado y regiones {#BrailleAbbreviations}

Con el fin de tener la mayor cantidad de información posible en una pantalla braille, se han definido las siguientes abreviaturas para indicar el tipo de control y el estado así como las regiones.

| Abreviatura |Tipo de Control|
|---|---|
|apl |aplicación|
|cit |cita|
|bt |botón|
|btdsp |botón desplegable|
|btrot |botón rotatorio|
|btdiv |botón divisor|
|btcom |botón conmutable|
|cc |cuadro combinado|
|cv |casilla de verificación|
|dlg |diálogo|
|doc |documento|
|ce |campo de texto editable|
|pwdedt |edición de contraseña|
|integrado |objeto integrado|
|notaf |nota final|
|notap |nota al pie|
|gra |gráfico|
|grp |grupo|
|enN |encabezado de nivel n, por ejemplo: h1, h2.|
|ayd |globo de ayuda|
|reg |región|
|enl |enlace|
|enlv |enlace visitado|
|lst |lista|
|mn |menú|
|bmn |barra de menú|
|btmn |botón de menú|
|elmn |elemento de menú|
|pnl |panel|
|barprg |barra de progreso|
|bto |botón de opción|
|bardsp |barra de desplazamiento|
|secc |sección|
|barst |barra de estado|
|ctrtab |control tab|
|tb |tabla|
|cN |número de columna de tabla n, por ejemplo: c1, c2.|
|fN |número de fila de tabla n, por ejemplo: r1, r2.|
|term |terminal|
|barher |barra de herramientas|
|cons |consejos|
|vár |vista en árbol|
|btvár |botón de vista en árbol|
|elvár |elemento de vista en árbol|
|nv N |un elemento de vista en árbol que tiene un nivel jerárquico N||
|vtn |ventana|
|`-----` |separador|

Los siguientes indicadores de estado  también están definidos:

| Abreviatura |Estado de Control|
|---|---|
|... |mostrado cuando un objeto soporta autocompletado|
|⢎⣿⡱ |mostrado cuando un objeto (por ejemplo un botón conmutable) está presionado|
|⢎⣀⡱ |mostrado cuando un objeto (por ejemplo un botón conmutable) no está presionado|
|⣏⣿⣹ |mostrado cuando un objeto (por ejemplo una casilla de verificación) está marcado|
|⣏⣸⣹ |mostrado cuando un objeto (por ejemplo una casilla de verificación) está parcialmente marcado|
|⣏⣀⣹ |mostrado cuando un objeto (por ejemplo: una casilla de verificación) no está marcado|
|- |mostrado cuando un objeto (por ejemplo: un elemento de vista en árbol) es contraíble|
|+ |mostrado cuando un objeto (por ejemplo: un elemento de vista de árbol) es Expandible|
|*** |mostrado cuando se encuentra un control o un documento protegido|
|clk |mostrado cuando un objeto es cliqueable|
|cmnt |mostrado cuando hay un comentario para una celda en una hoja de cálculo o en una pieza de texto en un documento|
|frml |mostrado cuando hay una fórmula en una celda de una hoja de cálculo|
|invalid |mostrado cuando se ha hecho una entrada inválida|
|ldesc |mostrado cuando un objeto (normalmente un gráfico) tiene una descripción larga|
|mln |mostrado cuando un campo de edición permite escribir varias líneas de texto tales como campos de comentarios en sitios web|
|req |mostrado cuando se encuentra un campo de edición obligatorio|
|ro |mostrado cuando un objeto (por ejemplo: un campo de texto editable) es de sólo lectura|
|sel |mostrado cuando un objeto está seleccionado|
|nsel |mostrado cuando un objeto no está seleccionado|
|ordenado asc |mostrado cuando un objeto se ordena ascendentemente|
|ordenado desc |mostrado cuando un objeto se ordena descendentemente|
|submnu |mostrado cuando un objeto tiene un desplegable (normalmente un submenú)|

Finalmente, se definieron las siguientes abreviaturas para regiones:

| Abreviatura |Región|
|---|---|
|tlo |título|
|cinf |info de contenido|
|cmpl |complementario|
|form |formulario|
|main |principal|
|nav |navegación|
|busq |búsqueda|
|rgn |región|

### Entrada Braille {#BrailleInput}

NVDA admite la entrada de braille  contraído y sin contraer a través de un teclado braille.
Puedes seleccionar la tabla de transcripción utilizada para transcribir braille en el texto utilizando la opción [Tabla de entrada](#BrailleSettingsInputTable) en la categoría de braille en el diálogo [Opciones de NVDA](#NVDASettings).

Cuando se esté utilizando braille sin contraer, el texto se inserta tan pronto como se enterduce.
Cuando se esté utilizando braille contraído, el texto se inserta al presionar espacio o enter al final de una palabra.
Ten en cuenta que la transcripción puede reflejar sólo la palabra braille que estés escribiendo y no se puede considerar el texto existente.
Por ejemplo, si estás utilizando un código braille que comienza los números con un signo de número y presionas retroceso para moverte al final de un número, necesitarás teclear el signo de número de nuevo para enterducir números adicionales.

<!-- KC:beginInclude -->
Al presionar el punto 7 borras la última celda o carácter enterducido.
El punto 8 transcribe cualquier entrada braille y presiona la tecla enter.
presionando los puntos 7 + 8 transcribe cualquier entrada braille, pero sin añadir un espacio o presionando enter.
<!-- KC:endInclude -->

## Reconocimiento de Contenidos {#ContentRecognition}

Cuando los autores no proporcionan suficiente información para que un usuario de lector de pantalla determine el contenido de algo, pueden utilizarse varias herramientas para intentar reconocer el contenido desde una imagen.
NVDA es compatible con la funcionalidad de reconocimiento óptico de caracteres (OCR) integrada en Windows 10 para reconocer texto desde imágenes.
Pueden proporcionarse reconocedores de contenido adicionales en complementos de NVDA.

Cuando utilices una orden de reconocimiento de contenido, NVDA reconoce contenido desde el [navegador de objetos](#ObjectNavigation) actual.
Por omisión, el navegador de objetos sigue al foco del sistema o al cursor del modo exploración, así puedes mover normalmente el foco o el cursor del modo exploración donde desees.
Por ejemplo, si mueves  el cursor del modo exploración a un gráfico, el reconocimiento reconocerá el contenido desde el gráfico por omisión.
Por lo tanto, es posible que desees utilizar la navegación de objetos directamente para, por ejemplo, reconocer el contenido de toda una ventana de aplicación.

Una vez el reconocimiento se complete, el resultado se presentará en un documento similar al modo exploración, permitiéndote leer la información con las teclas del cursor, etc.
presionando enter o espacio se activará (normalmente un clic) el texto en el cursor si es posible.
presionando escape se descarta el resultado del reconocimiento.

### OCR de Windows 10 {#Win10Ocr}

Windows 10 incluye un OCR para muchos idiomas.
NVDA puede utilizar esto para reconocer texto desde imágenes o aplicaciones inaccesibles.

Puedes configurar el idioma a utilizar para el reconocimiento de texto en la [categoría OCR de Windows 10](#Win10OcrSettings)del diálogo [Opciones de NVDA](#NVDASettings).
Pueden instalarse idiomas adicionales abriendo el menú Inicio, eligiendo Configuración, seleccionando Hora e Idioma -> Región e Idioma y luego eligiendo Añadir un Idioma.

<!-- KC:beginInclude -->
Para reconocer el texto en el actual navegador de objetos utilizando el OCR de Windows 10, presiona NVDA+r.
<!-- KC:endInclude -->

## Características Específicas para Aplicación {#ApplicationSpecificFeatures}

NVDA proporciona sus propias características adicionales para algunas aplicaciones con el fin de facilitar ciertas tareas o para proporcionar acceso a funciones que de otro modo no serían accesibles para los usuarios de lectores de pantalla.

### Microsoft Word {#MicrosoftWord}
#### Lectura Automática de Encabezados de Columna y Fila {#WordAutomaticColumnAndRowHeaderReading}

NVDA es capaz de anunciar automáticamente  los encabezados apropiados de fila y columna al navegar a través de tablas en Microsoft Word.
Esto requiere primero que la opción Anunciar  Encabezados de Filas y columnas en las ocpiones de NVDA Formateado de Documentos, que se encuentra en el diálogo [Opciones de NVDA](#NVDASettings), esté activada.
En segundo lugar, NVDA necesita saber qué fila o columna contiene el encabezado en cualquier tabla dada.
Después de moverse a la primera celda en la columna o fila que contenga los encabezados, utiliza una de los comandos siguientes:
<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Definir encabezados de columna |NVDA+shift+c |presionando esto una vez dice a NVDA que esta es la primera celda de encabezado en la fila que contiene encabezado de columna, que debería ser anunciada automáticamente al moverse entre columnas por debajo de esta fila. presionando dos veces eliminarás la opción.|
|Definir encabezados de fila |NVDA+shift+r |presionando esto una vez dices a NVDA que esta es la primera celda de encabezado en la columna que contiene encabezados de fila, la cual debería aunuciarse automáticamente al moverse entre filas después de esta columna. presionando dos veces eliminarás la opción.|

<!-- KC:endInclude -->
Estas opciones se almacenarán en el documento como marcadores compatibles con otros lectores de pantalla tales como Jaws.
Esto significa que otros usuarios de lectores de pantalla que abran este documento más tarde tendrán automáticamente los encabezados de fila y columna ya configurados. 

#### Modo Exploración en Microsoft Word {#BrowseModeInMicrosoftWord}

De manera similar a la web, el modo exploración puede utilizarse en Microsoft Word para permitirte utilizar características tales como navegación rápida y la Lista de Elementos
<!-- KC:beginInclude -->
Para activar o desactivar el modo Exploración en Microsoft Word, presiona NVDA+espacio.
<!-- KC:endInclude -->
Para información adicional acerca del modo Exploración y la Navegación Rápida, consulta la [sección Modo Exploración](#BrowseMode).

##### La Lista de Elementos {#WordElementsList}

<!-- KC:beginInclude -->
Mientras se esté en modo Exploración en Microsoft Word, puedes acceder a la Lista de Elementos presionando NVDA+f7.
<!-- KC:endInclude -->
La Lista de Elementos puede listar encabezados, enlaces, anotaciones (las cuales incluyen comentarios y seguimiento de cambios) y errores (actualmente limitados a errores de ortografía).

#### Anunciado de Comentarios {#WordReportingComments}

<!-- KC:beginInclude -->
Para anunciar cualquier comentario en la posición actual del cursor de edición, presiona NVDA+alt+c.
<!-- KC:endInclude -->
 Todos los comentarios para el documento con otro seguimiento de cambios también pueden listarse en la Lista de Elementos de NVDA al seleccionar Anotaciones según se teclea.

### Microsoft Excel {#MicrosoftExcel}
#### Lectura Automática de Encabezado de Columna y fila {#ExcelAutomaticColumnAndRowHeaderReading}

NVDA podrá anunciar automáticamente los encabezados apropiados de fila y columna al navegar a través de las hojas de cálculo de Excel.
Esto requiere en primer lugar que la opción Anunciar Encabezados de Fila y Columna de tabla en las opciones de NVDA Formateado de documentos, que se encuentra en el diálogo [Opciones de NVDA](#NVDASettings), esté activado.
En segundo lugar, NVDA necesita saber qué fila o columna contiene los encabezados.
Después de moverte a la primera celda en la columna o fila que contenga los encabezados, utiliza una de las siguientes comandos:
<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Definir encabezado de columnas |NVDA+shift+c |Al presionar esto una vez le dice a NVDA que es la primera celda de encabezado de la fila que contiene los encabezados de columna, que debería ser anunciado automáticamente cuando te desplaces entre las columnas por debajo de esta fila. presionando dos veces se eliminará la opción.|
|Definir encabezado de filas |NVDA+shift+r |Al presionar esto una vez le dice a NVDA que es la primera celda del encabezado de la columna que contiene los encabezados de fila, que debería ser anunciado automáticamente cuando te desplaces entre las filas después de esta columna. presionando dos veces eliminarás la opción.|

<!-- KC:endInclude -->
Estas opciones se almacenarán en el libro de trabajo como rangos de nombres definidos, compatibles con otros lectores de pantalla tales como Jaws.
Esto significa que otros usuarios de lectores de pantalla que abran este libro de trabajo más tarde tendrán automáticamente los encabezados de fila y columna ya configurados. 

#### La Lista de Elementos {#ExcelElementsList}

De modo similar a la web, NVDA tiene una Lista de Elementos para Microsoft Excel, que te permite listar y acceder a varios tipos diferentes de información.
<!-- KC:beginInclude -->
Para acceder a la Lista de Elementos en Excel, presiona NVDA+f7.
<!-- KC:endInclude -->
Los diversos tipos de información disponible en la Lista de Elementos son:

* Gráficos: esto lista todos los gráficos en la hoja de cálculo activa.
Seleccionando un gráfico y presionando enter o el botón Mover A enfoca el gráfico para navegar y leer con las teclas de cursor.
* Comentarios: esto lista todas las celdas en la hoja de cálculo activa que contengan comentarios. 
La dirección de la celda junto con sus comentarios se muestra para cada celda. 
presionando enter o el botón Mover a cuando se esté sobre un comentario listado se moverá directamente a esa celda.
* Fórmulas: esto lista todas las celdas en la hoja de cálculo activa que contengan una fórmula. 
La dirección de la celda junto con su fórmula se muestra para cada celda.
presionando enter o el botón Mover A sobre una fórmula listada se moverá directamente a esa celda. 
* Hojas: esto lista todas las hojas en el libro de trabajo. 
presionando f2 cuando se esté sobre una hoja listada te permite renombrar la hoja. 
presionando enter o el botón Mover A mientras se esté sobre la hoja listada cambiará a esa hoja.
* Campos de formulario: esto lista todos los campos de formulario en la hoja de cálculo activa.
Para cada campo de formulario, la Lista de Elementos muestra el texto alternativo del campo junto con las direcciones de las celdas que cubra.
Al seleccionar un campo de formulario y al presionar enter o el botón Mover te mueves a ese campo en modo exploración.

#### Anunciando Comentarios {#ExcelReportingComments}

<!-- KC:beginInclude -->
Para anunciar cualquier comentario para la celda actualmente enfocada, presiona NVDA+alt+c.
<!-- KC:endInclude -->
Todos los comentarios para la hoja de cálculo también pueden listarse en la Lista de Elementos de NVDA.

#### Leyendo Celdas Protegidas {#ExcelReadingProtectedCells}

Si un libro de trabajo ha sido protegido, podría no ser posible mover el foco a celdas en particular que hayan sido bloqueadas para edición.
<!-- KC:beginInclude -->
Para permitir el movimiento a celdas bloqueadas, cambia a modo Exploración presionando NVDA+espacio, y entonces utiliza los comandos estándar de movimiento de Excel  tales como las teclas de cursor para moverte por todas las celdas en la hoja de cálculo actual.
<!-- KC:endInclude -->

#### Campos de Formulario {#ExcelFormFields}

Las hojas de cálculo de Excel pueden incluir campos de formulario.
Puedes acceder a éstos utilizando la Lista de Elementos o las teclas de navegación con una sola letra para campos de formulario f y shift+f.
Una vez te hayas movido a un campo de formulario en modo exploración, puedes presionar enter o espacio para activarlo o cambiar a modo foco para poder interactuar con él, dependiendo del control.
Para información adicional acerca del modo exploración y de la navegación con una sola tecla, consulta la [sección Modo Exploración](#BrowseMode).

### Microsoft PowerPoint {#MicrosoftPowerPoint}

<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|conmutar lectura de notas del orador |control+shift+s |Cuando se está en una presentación en ejecución, esta orden conmutará entre las notas del orador para la diapositiva y el contenido de la diapositiva. Esto sólo afecta a lo que lee NVDA, no a lo que se muestra en la pantalla.|

<!-- KC:endInclude -->

### foobar2000 {#Foobar2000}

<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Anunciar tiempo restante |control+shift+r |Anuncia el tiempo restante de la pista actualmente en reproducción, si hay alguna.|
|Anunciar el tiempo transcurrido |control+shift+e |Anuncia el tiempo transcurrido de la pista actual en reproducción, si la hay.|
|Anunciar la longitud de la pista |control+shift+t |Anuncia la longitud de la pista actual en reproducción, si la hay.|

<!-- KC:endInclude -->

Nota: los atajos de teclado de arriba sólo funcionan con la cadena de formato predeterminada para la línea de estado de foobar.

### Miranda IM {#MirandaIM}

<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Anunciar mensaje reciente |NVDA+control+1-4 |Anuncia uno de los mensajes recientes, dependiendo del número presionado; por ejemplo: NVDA+control+2 lee el segundo mensaje más reciente.|

<!-- KC:endInclude -->

### Poedit {#Poedit}

<!-- KC:beginInclude -->

| Nombre |Tecla |Descripción|
|---|---|---|
|Anunciar ventana de Comentarios |control+shift+c |Anuncia cualquier comentario en la ventana de comentarios.|
|Anunciar notas para traductores |control+shift+a |Anuncia cualquier nota para los traductores.|

<!-- KC:endInclude -->

### Skype {#Skype}

<!-- KC:beginInclude -->
Cuando se está en una conversación:

| Nombre |Tecla |Descripción|
|---|---|---|
|Revisar mensaje |NVDA+control+1-0 |Anuncia y mueve el cursor de revisión a un mensaje reciente, dependiendo del número presionado; por por ejemplo: NVDA+control+2 lee el segundo mensaje más reciente.|

<!-- KC:endInclude -->

### Kindle para PC {#Kindle}

NVDA es compatible con la lectura y la navegación de libros en Amazon Kindle para PC.
Esta funcionalidad sólo está disponible en libros de Kindle designados con "Lector de Pantalla: Soportado" lo cual puedes verificar en la página de detalles para el libro.

Se utiliza el modo exploración para leer libros.
Se habilita automáticamente al abrir un libro o al enfocar el área del libro.
La página se pasará automáticamente según proceda cuando muevas el cursor o utilices la orden leer todo.
<!-- KC:beginInclude -->
Puedes pasar a la siguiente página manualmente con la tecla avPág y retroceder a la anterior con la tecla rePág.
<!-- KC:endInclude -->

Se admite la navegación con una sola tecla para enlaces y gráficos, pero sólo dentro de la página actual.
La navegación por enlaces también incluye notas al pie.

NVDA proporciona soporte preliminar para la lectura y la navegación interactiva de contenido matemático para libros con matemáticas accesibles.
Por favor consulta la sección [Leyendo Contenido Matemático](#ReadingMath) para información adicional.

#### Selección de Texto {#KindleTextSelection}

Kindle te permite realizar varias funciones en el texto seleccionado, incluyendo obtener una definición de diccionario, añadir notas y hacer resaltados, copiar el texto al portapapeles y buscar en la web.
Para hacer esto, primero selecciona texto como lo harías normalmente en modo exploración; por ejemplo: utilizando shift y las teclas de cursor.
<!-- KC:beginInclude -->
Una vez hayas seleccionado el texto, presiona la tecla aplicaciones o shift+f10 para mostrar las opciones disponibles para trabajar con la selección.
<!-- KC:endInclude -->
Si haces esto sin texto seleccionado, las opciones que se mostrarán serán para la palabra en el cursor.

#### Notas de Usuario {#KindleUserNotes}

Puedes añadir una nota con respecto a una palabra o a un pasaje de texto.
Para ello, primero selecciona el texto pertinente y accede a las opciones de la selección según se describió anteriormente.
A continuación, elige Añadir Nota.

Cuando se lee en el modo exploración, NVDA se refiere a estas notas como comentarios.

Para ver, editar o eliminar una nota:

1. Mueve el cursor al texto que contenga la nota.
1. Accede a las opciones para la selección según se describió anteriormente.
1. Elige Editar Nota.

### Azardi {#Azardi}

<!-- KC:beginInclude -->
Cuando se esté en la tabla de vista de libros añadidos:

| Nombre |Tecla |Descripción|
|---|---|---|
|Entrar |enter |Abre el libro seleccionado.|
|Menú de Contexto |aplicaciones |Abre el menú de contexto para el libro seleccionado.|

<!-- KC:endInclude -->

## Configurando NVDA {#ConfiguringNVDA}

La mayor parte de la configuración puede realizarse utilizando cuadros de diálogo a los que se accede mediante el submenú Preferencias del menú NVDA.
Muchas de estas opciones pueden encontrarse en el cuadro de diálogo multipágina [Opciones de NVDA](#NVDASettings).
En todos los cuadros de diálogo, presiona el botón Aceptar para acceptar cualquier cambio que hayas hecho.
Para cancelar cualquier cambio, presiona el botón Cancelar o la tecla escape.
Para ciertos cuadros de diálogo, puedes presionar el botón aplicar para hacer que las opciones tengan lugar imediatamente sin cerrarlo.
Algunas opciones también pueden cambiarse utilizando teclas de atajo,  que se enumeran donde sean relevantes en las secciones subsiguientes.

### Opciones de NVDA {#NVDASettings}

<!-- KC:settingsSection: || Nombre | Tecla Escritorio | Tecla Portátil | Descripción | -->
El cuadro de diálogo Opciones de NVDA contiene muchos parámetros de configuración que se pueden cambiar.
Este diálogo contiene una lista con varias categorías de opciones entre las que elegir.
Al seleccionar una categoría, se mostrarán varias opciones relacionadas con esta categoría en este cuadro de diálogo.
Estas opciones se pueden aplicar utilizando el botón aplicar, en cuyo caso el diálogo permanecerá abierto.
Si deseas guardar la configuración y cerrar el cuadro de diálogo Opciones de NVDA, puedes utilizar el botón Aceptar.

Algunas categorías de opciones tienen un atajo de teclado dedicado.
Si se presiona, este atajo de teclado abrirá  el diálogo Opciones de NVDA en esa categoría en particular.
De forma predeterminada, no se puede acceder a todas las categorías con comandos de teclado.
Si deseas acceder a categorías que no tengan atajos de teclado dedicados, utiliza el [cuadro de diálogo Gestos de Entrada](#InputGestures) para añadir un gesto personalizado tal como una orden de teclado o un gesto táctil para esa categoría.

Las diversas categorías  de opciones que se encuentran en el cuadro de diálogo Opciones de NVDA se describirán a continuación..

#### General (NVDA+control+g) {#GeneralSettings}

La categoría General del cuadro de diálogo Opciones de NVDA establece el comportamiento general de NVDA, como el idioma de la interfaz y si debería o no comprobar las actualizaciones.
Esta categoría contiene las siguientes opciones:

##### Idioma {#GeneralSettingsLanguage}

Este es un cuadro combinado que te permite seleccionar el idioma en que debería mostrarse la interface de usuario y los mensajes de NVDA. 
Hay muchos idiomas, no obstante la opción predeterminada es llamada "Predeterminado del usuario". 
Esta elección dirá a NVDA que utilice el idioma en el que Windows esté actualmente ajustado. 

Por favor ten en cuenta que NVDA debe reiniciarse cuando se cambie el idioma. 
Cuando aparezca el diálogo de confirmación, selecciona "reiniciar ahora" o "reiniciar más tarde" si deseas utilizar el idioma nuevo ahora o en un momento posterior, respectivamente. Si está seleccionado "reiniciar más tarde", la configuración debe guardarse (o manualmente o utilizando la funcionalidad guardar al salir).

##### Guardar Configuración al Salir {#GeneralSettingsSaveConfig}

Esta opción es una casilla de verificación que, cuando se marca, dice a NVDA que guarde automáticamente la actual configuración cuando se salga de NVDA. 

##### Mostrar opciones de salida al salir de NVDA {#GeneralSettingsShowExitOptions}

Esta opción es una casilla de verificación que te permite elegir si aparece o no un diálogo al salir de NVDA que te pregunta sobre qué acción quieres llebar a cabo.
Cuando se marque, aparecerá un diálogo al intentar salir de NVDA preguntándote si quieres salir, reiniciar, reiniciar con los complementos deshabilitados o instalar actualizaciones pendientes si las hay.
Cuando se desmarque, NVDA saldrá inmediatamente.

##### Reproducir sonidos al iniciar o salir de NVDA {#GeneralSettingsPlaySounds}

Esta Opción es una casilla de verificación que, cuando está marcada, dice a NVDA que reproduzca sonidos cuando se inicie o se cierre.

##### Nivel del Registro {#GeneralSettingsLogLevel}

Este es un cuadro combinado que te permite elegir cuánta info pondrá NVDA en el registro según se ejecute. 
Generalmente los usuarios no deberían necesitar tocar esto ya que no es demasiado amigable. 
Sin embargo, si deseas proporcionar información en un informe de fallos, o habilitar o deshabilitar todo el registro, entonces podrá ser una opción útil.

Los niveles disponibles del registro son:

* Deshabilitado: Aparte de un breve mensaje de inicio, NVDA no registrará nada mientras se ejecute.
* Información: NVDA registrará información básica tal como mensajes de inicio e información útil para los desarrolladores.
* Advertencia de depuración: se registrarán mensajes de advertencia que no sean causados por errores graves.
* Entrada/salida: se registrarán las entradas de las líneas braille y de los teclados, así como la salida de la voz y del braille. Si te preocupa la privacidad, no configures esta opción de nivel de registro.
* Depuración: además de los mensajes de información, advertencia y entrada/salida, se registrarán mensajes de depuración adicionales. Al igual que con la Entrada/salida, si te preocupa la privacidad, no deberías configurar el nivel de registro en esta opción.

##### Arrancar automáticamente NVDA después de Iniciar sesión en Windows {#GeneralSettingsStartAfterLogOn}

Si esta opción está activada, NVDA arrancará automáticamente tan pronto como inicies sesión en Windows. 
Esta opción sólo está disponible para copias instaladas de NVDA.

##### Utilizar NVDA en la pantalla de logueo de Windows (requiere privilegios de administrador) {#GeneralSettingsStartOnLogOnScreen}

Si inicias sesión en Windows proporcionando un nombre de usuario y una contraseña, entonces activando esta opción hará que NVDA se inicie automáticamente en la pantalla de logueo cuando Windows arranque. 
Esta opción sólo está disponible para copias instaladas de NVDA.

##### Utilizar Opciones guardadas actualmente en el logueo y otras pantallas seguras {#GeneralSettingsCopySettings}

presionando este botón copias tu configuración de usuario de NVDA actualmente guardada al directorio de sistema de configuración de NVDA, tal que NVDA lo utilizará cuando se ejecute en el logueo, Control de Cuentas de Usuario (UAC) y otras pantallas seguras de Windows.
Para estar seguro de que todas tus opciones se transfieren, asegúrate de guardar primeramente tu configuración con control+NVDA+c o guarda la configuración en el menú NVDA.
Esta opción sólo está disponible para copias instaladas de NVDA.

##### Buscar actualizaciones para NVDA automáticamente {#GeneralSettingsCheckForUpdates}

Si esto está activado, NVDA buscará automáticamente versiones actualizadas y te informará cuando una actualización esté disponible.
También puedes buscar actualizaciones manualmente seleccionando Buscar Actualizaciones en el submenú Ayuda en el menú NVDA.
Cuando se busquen actualizaciones manual o automáticamente, es necesario para NVDA enviar alguna información al servidor de actualizaciones para recibir la actualización correcta para tu sistema.
Se envía siempre la siguiente información: 

* Versión actual de NVDA
* Versión del Sistema Operativo
* Si el Sistema Operativo es de 64 o de 32 bits

##### Permitir que el Proyecto NVDA Recopile Estadísticas de Uso de NVDA {#GeneralSettingsGatherUsageStats}

Si esto está activado, NV Access utilizará la información de las búsquedas de actualizaciones para seguir el número de usuarios de NVDA incluyendo datos demográficos particulares tales como el Sistema Operativo y el país de origen.
Ten en cuenta que aunque tu dirección IP se utilizará para calcular tu país durante la búsqueda de actualizaciones, la dirección IP nunca se conservará.
Además de la información obligatoria necesaria para buscar actualizaciones, también se envía la siguiente información adicional actualmente:

* Idioma de la interfaz de NVDA
* Si esta copia de NVDA es portable o instalada
* El nombre del sintetizador de voz actual en uso (incluyendo el nombre del complemento que viene con el controlador)
* El nombre de la pantalla Braille actual en uso (incluyendo el nombre del complemento que viene con el controlador)
* La tabla de salida braille actual (si el Braille está en uso)

Esta información ayuda enormemente a NV Access a priorizar el desarrollo futuro de NVDA.

##### Notificar actualizaciones pendientes al arrancar {#GeneralSettingsNotifyPendingUpdates}

Si esto está habilitado, NVDA te informará cuando haya una actualización pendiente al arrancar, ofreciéndote la posibilidad de instalarla.
También puedes instalar manualmente la actualización pendiente desde el diálogo Salir de NVDA (si está habilitado), desde el menú NVDA, o al realizar una nueva búsqueda desde el menú Ayuda.

#### Opciones de Voz (NVDA+control+v) {#SpeechSettings}

La categoría voz en el cuadro de diálogo Opciones de NVDA contiene ajustes que te permiten cambiar el sintetizador de voz así como características de la voz para el sintetizador elegido.
Para una forma alternativa rápida de controlar los parámetros de voz desde cualquier lugar, por favor consulta la sección [Grupo de Opciones de Sintetizador](#SynthSettingsRing).

La categoría Opciones de voz contiene los siguientes ajustes:

##### Cambiar Sintetizador {#SpeechSettingsChange}

El primer ajuste en la categoría Opciones de Voz es el botón Cambiar... Este botón activa el cuadro de diálogo [Seleccionar Sintetizador](#SelectSynthesizer), el cual te permite seleccionar el sintetizador de voz activo y el dispositivo de sonido.
Este diálogo se abre por encima del cuadro de diálogo Opciones de NVDA.
Guardando o descartando los ajustes en el cuadro de diálogo Seleccionar Sintetizador volverás al diálogo Opciones de NVDA.

##### Voz {#SpeechSettingsVoice}

La opción voz es un cuadro combinado que enumera todas las voces del sintetizador actual que has instalado.
Puedes utilizar las teclas de cursor para escuchar todas las elecciones. 
Las flechas izquierda y arriba suben por la lista, mientras que las flechas derecha y abajo bajan por la lista.

##### Variante {#SpeechSettingsVariant}

Si estás utilizando el sintetizador Espeak NG empaquetado junto con NVDA, este es un cuadro combinado que te permite seleccionar la variante con la que el sintetizador debería hablar. 
Las variantes de Espeak NG son bastante parecidas a las voces, pero proporcionan atributos ligeramente diferentes para la voz de ESpeak NG. 
Algunas variantes sonarán como un hombre, algunas como una mujer, y algunas como si tuvieran carraspera.

##### Velocidad {#SpeechSettingsRate}

Esta opción te permite cambiar la velocidad de la voz. 
Este es un deslizador que va desde 0 hasta 100, (siendo 0 la velocidad más lenta y siendo 100 la más rápida).

##### Tono {#SpeechSettingsPitch}

Esta opción te permite cambiar el tono de la voz. 
Esto es un deslizador que va desde 0 hasta 100, (siendo 0 el tono más bajo y siendo 100 el más alto). 

##### Volumen {#SpeechSettingsVolume}

Esta opción es un deslizador que va desde 0 hasta 100, (siendo 0 el volumen más bajo y siendo 100 el más alto).

##### Entonación {#SpeechSettingsInflection}

Esta opción es un deslizador que te permite elegir cuánta entonación (subida y caída en el tono) el sintetizador debería utilizar para hablar. (Solamente el sintetizador Espeak NG proporciona esta opción actualmente).

##### Cambio Automático de Idioma {#SpeechSettingsLanguageSwitching}

Esta casilla de verificación te permite activar o desactivar si NVDA debería cambiar automáticamente los idiomas del sintetizador de voz si el texto a leer lo especifica .
Esta opción está activada de manera predeterminada.
Actualmente sólo el sintetizador eSpeak NG sopporta el cambio automático de idioma.

##### Cambio Automático de Dialecto {#SpeechSettingsDialectSwitching}

Esta casilla de verificación te permite activar o desactivar  si se deberían hacer los cambios de dialecto, en lugar de sólo cambiar el idioma actual. 
Por ejemplo: Si se está leyendo en una voz Inglés U.S. pero partes de un documento tienen algún texto en Inglés U.K. entonces si esta característica está activada el sintetizador cambiará su acento.
Esta opción está desactivada de forma predeterminada.

<!-- KC:setting -->

##### Nivel de Puntuación y símbolos {#SpeechSettingsSymbolLevel}

Tecla: NVDA+p

Esto te permite elegir la cantidad de puntuación y otros símbolos que deberían verbalizarse como palabras.
Por ejemplo, cuando se configura a toda, todos los símbolos se verbalizarán como palabras.
Esta opción se aplica a todos los sintetizadores, no sólo al sintetizador activo actualmente.

##### Confiar en el idioma de la voz al procesar símbolos y caracteres {#SpeechSettingsTrust}

Activada de manera predeterminada, esta opción dice a NVDA si el idioma de la voz actual puede ser de confianza al procesar símbolos y caracteres.
Si notas que NVDA está leyendo la puntuación en un idioma  incorrecto para un sintetizador o voz en particular, podrás querer desactivar esta opción para forzar a NVDA a utilizar su idioma global configurado en su lugar.

##### Incluir datos Unicode Consortium (incluyendo emoji) al procesar caracteres y símbolos {#SpeechSettingsCLDR}

Cuando esta casilla de verificación esté activada, NVDA incluirá los diccionarios de pronunciación de símbolos adicional cuando pronuncie caracteres y símbolos.
Estos diccionarios contienen descripciones para símbolos (en particular emoji) que se proporcionan por el [Unicode Consortium](http://www.unicode.org/consortium/) como parte de su [Common Locale Data Repository](http://cldr.unicode.org/).
Si quieres que NVDA verbalice descripciones de caracteres emoji basados en estos datos, deberías habilitar esta opción.
Por lo tanto, si estás utilizando un sintetizador de voz que admita la verbalización de descripciones de emoji nativamente, deberías desactivar esto.

Ten en cuenta que las descripciones de caracteres añadidas o editadas manualmente se guardan como parte de tus opciones de usuario.
Por lo tanto, si cambias la descripción de un emoji en particular, tu descripción personalizada se verbalizará para ese emoji sin importar si esta opción está habilitada.
Puedes añadir, editar o eliminar descripciones de símbolos en el [diálogo de pronunciación de puntuación y símbolos](#SymbolPronunciation) de NVDA.

##### Cambio de Porcentaje de Tono para Mayúsculas {#SpeechSettingsCapPitchChange}

Este campo de edición te permite teclear la cantidad en que el tono de la voz cambiará cuando se verbalice una letra mayúscula.
Este valor es un porcentaje, donde un valor negativo baja el tono y un valor positivo lo sube.
Para no cambiar el tono utilizarías el 0.

##### Decir" Mayus" antes de Mayúsculas {#SpeechSettingsSayCapBefore}

Esta opción es una casilla de verificación, que cuando está marcada dice a NVDA que diga la palabra "mayus" antes de cualquier letra en mayúscula, cuando se navega sobre ella o verbalizándolo cuando está siendo escrita. 
Normalmente, NVDA eleva el tono ligeramente para cualquier letra mayúscula, pero algunos sintetizadores podrán no soportar esto bien, así quizás esta opción podrá ser de utilidad.

##### Pitar para Mayúsculas {#SpeechSettingsBeepForCaps}

Si esta casilla de verificación está marcada, NVDA emitirá un pequeño pitido cada vez que esté verbalizando un carácter en mayúscula. 
Como la casilla de verificación 'decir mayus para mayúsculas', esta es útil para sintetizadores que no puedan modificar su tono para las letras mayúsculas.

##### Utilizar funcionalidad de deletreo si está soportada {#SpeechSettingsUseSpelling}

Algunas palabras consisten en sólo un carácter, pero la pronunciación es diferente dependiendo de si el carácter va a ser verbalizado como un carácter individual (tal como cuando se deletrea) o una palabra.
Por ejemplo, en español, "y" es tanto una letra como una palabra y se pronuncia de modo diferente en cada caso.
Esta opción permite al sintetizador diferenciar entre estos dos casos si el sintetizador lo soporta.
La mayoría de los sintetizadores lo soportan.

Esta opción generalmente debería activarse.
No obstante, algunos sintetizadores Microsoft Speech API no implementan esto correctamente y funciona anómalamente cuando se activa.
Si estás teniendo problemas con la pronunciación de caracteres individuales,  prueba desactivando esta opción.

#### Seleccionar Sintetizador (NVDA+control+s) {#SelectSynthesizer}

El cuadro de diálogo Sintetizador, el cual puede abrirse activando el botón Cambiar... en la categoría voz del diálogo Opciones de NVDA, te permite seleccionar qué Sintetizador debería utilizar NVDA para hablar.
Una vez hayas seleccionado el sintetizador de tu elección, puedes presionar Aceptar y NVDA cargará el sintetizador seleccionado.
Si hay un error cargando el sintetizador, NVDA te lo notificará con un mensaje, y continuará utilizando el anterior.

##### Sintetizador {#SelectSynthesizerSynthesizer}

Esta opción te permite elegir el sintetizador que deseas que NVDA utilice para la salida de voz.

Para obtener una lista de los sintetizadores que admite NVDA, por favor consulta la sección [Sintetizadores de Voz admitidos](#SupportedSpeechSynths).

Un elemento especial que siempre aparecerá en esta lista es "Sin voz", que te permite utilizar NVDA sin salida de voz.
Esto puede ser útil para alguien que sólo desee utilizar NVDA con braille, o quizás para desarrolladores videntes que sólo deseen utilizar el Visualizador de voz.

##### Dispositivo de Salida {#SelectSynthesizerOutputDevice}

Esta opción te permite elegir la tarjeta de sonido que NVDA debería indicar para que el sintetizador seleccionado hable.

<!-- KC:setting -->

##### Modo Atenuación de Audio {#SelectSynthesizerDuckingMode}

Key: NVDA+shift+d

En Windows 8 y superior, esta opción te permite elegir si NVDA debería reducir el volumen de otras aplicaciones mientras esté hablando, o todo el tiempo mientras NVDA se esté ejecutando.

* Sin Atenuación: NVDA nunca reducirá el volumen del otro audio. 
* Atenuar cuando salgan voz y sonidos: NVDA sólo reducirá el volumen del otro audio cuando NVDA esté hablando o reproduciendo sonidos. Esto puede no funcionar para todos los sintetizadores. 
* Atenuar Siempre: NVDA mantendrá el volumen del otro audio reducido durante todo el tiempo que esté en ejecución.

Esta opción sólo estará disponible si se ha instalado NVDA.
No es posible el soporte de la atenuación de audio para las copias portable y temporal de NVDA.

#### Anillo de Opciones de Sintetizador {#SynthSettingsRing}

Si deseas cambiar rápidamente opciones de voz  sin ir a la categoría de Voz del diálogo Opciones de NVDA, hay algunas teclas de comandos de que te permiten moverte a través de las opciones de voz más comunes, desde cualquier lugar mientras se ejecute NVDA:
<!-- KC:beginInclude -->

| Nombre |Tecla Escritorio |Tecla Portátil |Descripción|
|---|---|---|---|
|Mover a la siguiente opción de sintetizador |NVDA+control+Flecha derecha |NVDA+shift+control+Flecha derecha |Se mueve a la siguiente opción de voz disponible después de la actual, pasando por la primera opción de nuevo después de la última|
|Mover a la opción de sintetizador anterior |NVDA+control+Flecha izquierda |NVDA+shift+control+Flecha izquierda |Se mueve a la opción de voz anterior disponible después de la actual, pasando por la primera opción de nuevo después de la última|
|Incrementar actual opción de sintetizador |NVDA+control+Flecha arriba |NVDA+shift+control+Flecha arriba |incrementa la opción de voz actual sobre la que estés. por Ejemplo: incrementa la velocidad, elige la siguiente voz, incrementa el volumen|
|Decrementar actual opción de sintetizador |NVDA+control+Flecha abajo |NVDA+shift+control+Flecha abajo |decrementa la opción de voz actual sobre la que estés. por Ejemplo: decrementa la velocidad, elige  la voz anterior, decrementa el volumen|

<!-- KC:endInclude -->

#### Braille {#BrailleSettings}

La categoría Braille en el diálogo Opciones de NVDA contiene ajustes que te permiten cambiar varios aspectos de la entrada y salida braille.
Esta categoría contiene las siguientes opciones:

##### Cambiar pantalla braille {#BrailleSettingsChange}

El botón Cambiar... en la categoría Braille del cuadro de diálogo Opciones de NVDA activa el diálogo [Seleccionar Pantalla Braille](#SelectBrailleDisplay), el cual te permite seleccionar la pantalla braille activa.
Este cuadro de diálogo se abre sobre el diálogo Opciones de NVDA.
Guardando o descartando las opciones en el diálogo Seleccionar Pantalla Braille volverás al cuadro de diálogo Opciones de NVDA.

##### Tabla de Salida {#BrailleSettingsOutputTable}

La siguiente opción que vendrá en esta categoría es el cuadro combinado de la tabla de salida braille.
En este cuadro combinado, encontrarás tablas braille, estándares braille y grados para diferentes idiomas.
La tabla elegida se utilizará para transcribir texto a braille para presentarlo en la pantalla braille.
Puedes moverte entre las tablas braille en la lista utilizando las teclas de cursor.

##### Tabla de Entrada {#BrailleSettingsInputTable}

Complementariamente con la opción anterior, el siguiente ajuste que encontrarás es el cuadro combinado de la tabla de entrada braille.
La tabla elegida se utilizará para transcribir a texto el braille enterducido en el teclado tipo perkins de la pantalla braille.
Puedes moverte entre las tablas braille en la lista utilizando las teclas de cursor.

Ten en cuenta que esta opción sólo es útil si tu pantalla braille tiene un teclado tipo Perkins y si esta característica está admitida por el controlador de la pantalla braille.
Si la entrada no es compatible en una pantalla que tenga un teclado braille, esto se notificará en la sección [líneas braille Admitidas](#SupportedBrailleDisplays).

##### Expandir a braille de ordenador para la palabra en el cursor {#BrailleSettingsExpandToComputerBraille}

Esta opción permite a la palabra que está bajo el cursor ser mostrada en braille de ordenador no contraído.

##### Mostrar Cursor {#BrailleSettingsShowCursor}

Esta opción permite al cursor braille activarse y desactivarse.
Se aplica al cursor del sistema y al cursor de revisión, pero no al indicador de selección.

##### Parpadeo de Cursor {#BrailleSettingsBlinkCursor}

Esta opción permite al cursor braille parpadear.
Si el parpadeo está desactivado, el cursor braille estará constantemente en la posición "alzada".
El indicador de selección no está afectado por esta opción, siempre es con los puntos 7 y 8 sin parpadear.

##### Velocidad de Parpadeo del Cursor (ms) {#BrailleSettingsBlinkRate}

Esta opción es un campo numérico que te permite cambiar la velocidad de parpadeo del cursor en milésimas de segundo.

##### Forma del Cursor para el Foco {#BrailleSettingsCursorShapeForFocus}

Esta opción te permite elegir la forma (patrón de puntos) del cursor braille cuando el braille siga al foco.
El indicador de selección no está afectado por esta opción, siempre son los puntos 7 y 8 sin parpadear.

##### Forma del Cursor para la Revisión {#BrailleSettingsCursorShapeForReview}

Esta opción te permite elegir la forma (patrón de puntos) del cursor braille cuando el braille siga a la revisión.
El indicador de selección no está afectado por esta opción, siempre son los puntos 7 y 8 sin parpadear.

##### Duración del Mensaje (en seg) {#BrailleSettingsMessageTimeout}

Esta opción es un campo numérico que controla durante cuánto tiempo se muestran los mensajes del sistema en la pantalla braille.
Especifycando 0 se deshabilita el mostrado de estos mensajes completamente.

##### Mostrar Mensajes Indefinidamente {#BrailleSettingsNoMessageTimeout}

Esta opción permite a los mensajes de NVDA mostrarse en la pantalla braille indefinidamente.

<!-- KC:setting -->

##### Seguimiento Braille {#BrailleTether}

Tecla: NVDA+control+t

Esta opción te permite elegir si la pantalla braille seguirá al foco del sistema, o si seguirá al navegador de objetos / cursor de revisión, o a ambos.
Cuando se seleccione "automáticamente", NVDA seguirá al foco y al cursor del sistema por omisión.
En este caso, cuando se cambie la posición del navegador de objetos o del cursor de revisión mediante una interacción explícita del usuario, NVDA seguirá a la revisión temporalmente, hasta que el foco o el cursor cambie.

##### Leer por Párrafo {#BrailleSettingsReadByParagraph}

Si está activado, el braille se mostrará por párrafos en lugar de por líneas.
También, los comandos de línea siguiente y anterior moverán por párrafos en concordancia.
Esto significa que no tienes desplazamiento de la pantalla braille al final de cada línea incluso cuando haya más texto del que quepa en ella.
Esto podría permitir una lectura más fluida de grandes cantidades de texto.
Esto está desactivado de forma predeterminada.

##### Evitar separación de palabras cuando sea posible {#BrailleSettingsWordWrap}

Si esto está habilitado, una palabra que sea demasiado larga para caber en el final de la pantalla braille no se separará.
En su lugar, habrá algunos espacios en blanco al final de la pantalla.
Cuando desplaces la pantalla, podrás leer toda la palabra.
Esto se llama en ocasiones "ajuste de línea".
Ten en cuenta que si la palabra es demasiado larga para caber en la pantalla incluso por sí misma, ésta todavía debe ser partida.

Si esto está deshabilitado, se mostrará tanto como sea posible de la palabra, pero el resto se cortará.
Cuando desplaces la pantalla, entonces podrás leer el resto de la palabra.

Habilitar esto podría permitir una mayor fluidez en la lectura, pero normalmente requiere desplazar la pantalla más.

##### Presentación de Contexto de Foco {#BrailleSettingsFocusContextPresentation}

Esta opción te permite elegir qué información de contexto mostrará NVDA en la pantalla braille cuando un objeto obtenga el foco.
La información de contexto se refiere a la jerarquía de objetos que contengan el foco.
Por ejemplo, cuando enfoques un elemento de lista, este elemento de lista es parte de una lista.
Esta lista podría estar contenida en un diálogo, etc.
Por favor consulta la sección acercqa de [navegación de objetos](#ObjectNavigation) para más información acerca de la jerarquía que se aplica a los objetos en NVDA.

Cuando se configure en rellenar pantalla para cambios de contexto, NVDA tratará de mostrar tanta información de contexto como le sea posible en la pantalla braille, pero sólo para las partes del contexto que hayan cambiado.
Para el ejemplo de arriba, esto significa que cuando el foco cambie por la lista, NVDA mostrará el elemento de lista en la pantalla braille.
Además, si queda espacio suficiente en la pantalla braille, NVDA tratará de mostrar que el elemento de lista es parte de una lista.
Si, a continuación, comienzas a moverte por la lista con las teclas de cursor, se supone que eres consciente de estar todavía en la lista.
Por lo tanto, para los elementos de lista restantes que enfoques, NVDA sólo mostrará el elemento de lista enfocado en la pantalla.
Para leer el contexto de nuevo (es decir, que estás en una lista y que la lista es parte de un diálogo), tendrás que desplazar tu pantalla braille hacia atrás.

Cuando esta opción esté configurada a rellenar siempre la pantalla, NVDA tratará de mostrar tanta información de contexto como sea posible en la pantalla braille, independientemente de si has visto la misma información de contexto antes.
Esto tiene la ventaja de que NVDA ajustará tanta información como sea posible.
Por lo tanto, la desventaja es que siempre hay una diferencia en la posición donde comienza el enfoque en la pantalla braille.
Esto puede hacer difícil de navegar por una lista larga de elementos,  por ejemplo, ya que tendrás que mover contínuamente el dedo para encontrar el comienzo del elemento.
Este era el conmportamiento predeterminado para NVDA 2017.2 y anteriores.

Cuando configures la opción presentación de contexto del foco en mostrar sólo la información de contexto al desplazarse hacia atrás, NVDA nunca muestra información de contexto en la pantalla braille por omisión.
Así, en el ejemplo anterior, NVDA mostrará que enfocaste un elemento de lista.
Por lo tanto, para  leer el contexto (es decir, que estás en una lista y que esta lista es parte de un diálogo), habrás de desplazar la pantalla braille hacia atrás.

Para conmutar la presentación de contexto del foco desde cualquier lugar, por favor asigna un gesto personalizado utilizando el [diálogo Gestos de Entrada](#InputGestures).

#### Seleccionar Pantalla Braille (NVDA+control+a) {#SelectBrailleDisplay}

El cuadro de diálogo Seleccionar Pantalla Braille, el cual se puede abrir activando el botón Cambiar... en la categoría Braille del diálogo Opciones de NVDA, te permite seleccionar qué pantalla braille debería utilizar NVDA para la salida braille.
Una vez hayas seleccionado la pantalla braille de tu elección, puedes presionar Aceptar y NVDA cargará la pantalla seleccionada.
Si hay un error carghando el controlador de la pantalla, NVDA te lo notificará con un mensaje, y continuará utilizando la pantalla anterior, si hay alguna.

##### Pantalla Braille {#SelectBrailleDisplayDisplay}

Este cuadro combinado se te presenta con varias opciones dependiendo de qué controladores de pantalla braille estén disponibles en tu sistema.
Muévete entre estas opciones con las teclas de flechas.

La opción automático permitirá a NVDA buscar muchas líneas braille admitidas en segundo plano.
Cuando esta característica esté activada y conectes una pantalla admitida utilizando USB o bluetooth, NVDA conectará automáticamente con ella.

Sin braille significa que no estás utilizando braille.

Por favor consulta la sección [líneas braille Admitidas](#SupportedBrailleDisplays) para más información acerca de dichas líneas braille y de cuáles de ellas admiten la detección automática.

##### Puerto {#SelectBrailleDisplayPort}

Esta opción, si está disponible, te permite elegir qué puerto o tipo de conexión se utilizará para comunicar con la pantalla braille que has seleccionado.
Es un cuadro combinado que contiene las elecciones posibles para tu pantalla braille.

Por omisión, NVDA emplea la detección de puerto automática,  lo que significa que la conexión con el dispositivo braille se establecerá automáticamente buscando los dispositivos USB y bluetooth en tu sisttema.
Por lo tanto, para algunas líneas braille, podrás elegir explícitamente qué puerto debería utilizarse.
Las opciones comunes son "Automático" (la cual dice a NVDA que emplee el procedimiento de selección de puerto automático predeterminado), "USB", "Bluetooth" y puertos serie heredados si tu pantalla braille admite este tipo de comunicación.

Esta opción no estará disponible si tu pantalla braille sólo admite detección automática de puertos.

Puedes consultar la documentación para tu pantalla braille en la sección [líneas braille Admitidas](#SupportedBrailleDisplays) para buscar más detalles sobre los tipos compatibles de comunicación y puertos disponibles.

#### Teclado (NVDA+control+k) {#KeyboardSettings}

La categoría Teclado en el cuadro de diálogo Opciones de NVDA contiene ajustes que establecen el comportamiento de NVDA cuando usas y escribes en tu teclado.
Esta categoría Opciones contiene los siguientes ajustes:

##### Disposición del Teclado {#KeyboardSettingsLayout}

Este cuadro combinado te permite elegir qué tipo de disposición de teclado debería utilizar NVDA. Actualmente los dos que vienen con NVDA son Escritorio y Portátil.

##### Seleccionar Teclas Modificadoras de NVDA {#KeyboardSettingsModifiers}

Las casillas de verificación en esta lista controlan qué teclas pueden utilizarse como [teclas modificadoras de NVDA](#TheNVDAModifierKey). Las siguientes teclas están dispponibles para elegir:

* La tecla bloqueo de mayúsculas
* La tecla insertar en el tecládo numérico
* La tecla insertar extendida (encontrada normalmente encima de las teclas de flecha, cerca de inicio y fin)

Si no se elige ninguna tecla como la tecla NVDA podría ser imposible acceder a ciertas comandos de NVDA.
Por lo tanto, el diálogo Opciones de NVDA mostrará un mensaje de error si todas las teclas están sin seleccionar  cuando se presione Aceptar.
Después de descartar el mensaje de error, debes seleccionar al menos una antes de poder presionar Aceptar para cerrar el diálogo correctamente.

<!-- KC:setting -->

##### Verbalizar caracteres al escribir {#KeyboardSettingsSpeakTypedCharacters}

Tecla: NVDA+2

Cuando está marcada significa que NVDA anunciará todos los caracteres según los escribas en el teclado. 

<!-- KC:setting -->

##### Verbalizar palabras al escribir {#KeyboardSettingsSpeakTypedWords}

Tecla: NVDA+3

Cuando esté marcada significa que NVDA anunciará todas las palabras al escribirlas en el teclado. 

##### Interrupción de Voz para Caracteres Escritos {#KeyboardSettingsSpeechInteruptForCharacters}

Si está activada, esta opción hará que la voz se interrumpa cada vez que se escriba un carácter. Esto está activado de manera predeterminada.

##### Interrupción de Voz para la Tecla enter {#KeyboardSettingsSpeechInteruptForEnter}

Si está activada, esta opción hará que la voz se interrumpa cada vez que se presione la tecla enter. Esto está activado de manera predeterminada.

##### Permitir lectura superficial en Verbalizar Todo {#KeyboardSettingsSkimReading}

Si está activada, ciertas comandos de navegación (tales como la navegación rápida en modo exploración o el movimiento por líneas o por párrafos) no detienen  Verbalizar Todo, en su lugar Verbalizar Todo salta  a la nueva posición y continúa leyendo.

##### Pitar si se Teclean Letras Minúsculas Cuando BloqMayus está Activado {#KeyboardSettingsBeepLowercase}

Cuando está activada, se escuchará un pitido de aviso si se escribe una letra con la tecla shift mientras BloqMayus está activada.
Generalmente, escribir letras en mayúsculas con BloqMayus es inintencionado y normalmente es debido a no revisar que el BloqMayus esté activado.
Por lo tanto, puede ser bastante útil ser advertido acerca de esto.

<!-- KC:setting -->

##### Verbalizar teclas de comandos {#KeyboardSettingsSpeakCommandKeys}

Tecla: NVDA+4

Cuando está marcada significa que NVDA anunciará todas las teclas que no sean caracteres al escribirlas en el teclado. Esto incluye combinaciones de teclas tales como control más cualquier otra letra. 

##### Reproducir sonido para Errores de Ortografía mientras se escribe {#KeyboardSettingsAlertForSpellingErrors}

Al habilitarse, se reproducirá una breve señal acústica cuando una palabra que estés escribiendo contenga un error de ortografía.
Esta opción sólo está disponible si el anunciado de errores de ortografía está habilitado en el diálogo de NVDA [Opciones de Formateado de Documento](#DocumentFormattingSettings), encontrada en el cuadro de diálogo Opciones de NVDA.

##### Manejar teclas desde otras aplicaciones {#KeyboardSettingsHandleKeys}

Esta opción permite al usuario controlar si la presionación de las teclas generada por aplicaciones tales como teclados en pantalla y por el software de reconocimiento de voz debería procesarse por NVDA. 
Esta opción está activada por defecto, aunque algunos usuarios pueden necesitar deshabilitarla, como aquellos que escriban en vietnamita con el programa de escritura Unikey ya que hará que la entrada de caracteres sea incorrecta.

#### Ratón (NVDA+control+m) {#MouseSettings}

La categoría Ratón del cuadro de diálogo Opciones de NVDA permite a NVDA realizar un seguimiento del ratón, reproducir pitidos de sus coordenadas  y configurar otras opciones de uso del ratón.
Esta categoría contiene los siguientes ajustes:

##### Anunciar Cambios en la Forma del Ratón {#MouseSettingsShape}

Una casilla de verificación, que cuando se marca significa que NVDA anunciará la forma del puntero del ratón cada vez que cambie. 
El puntero del ratón en Windows cambia su forma para comunicar cierta información tal como cuando algo es editable, o cuando algo se está cargando, etc.

<!-- KC:setting -->

##### Habilitar Seguimiento del  Ratón {#MouseSettingsTracking}

Tecla: NVDA+m |

Cuando está marcada significa que NVDA anunciará el texto actualmente bajo el puntero del ratón, a medida que lo muevas por la pantalla. Esto te permite encontrar cosas en ella, moviendo físicamente el ratón, en lugar de tratar de encontrarlas a través del navegador de objetos.

##### Unidad de Resolución de Texto {#MouseSettingsTextUnit}

Si NVDA está configurado para anunciar el texto bajo el ratón según lo muevas, esta opción te permite elegir exactamente cuánto texto será verbalizado. 
Las opciones son carácter, palabra, línea y párrafo.

Para cambiar la unidad de resolución de texto desde cualquier lugar, por favor asigna un gesto personalizado utilizando el [Diálogo Gestos de entrada](#InputGestures).

##### Anunciar rol cuando el ratón entra en los Objetos {#MouseSettingsRole}

Si esta casilla de verificación está marcada, NVDA anunciará el rol (tipo) de objeto cuando el ratón se mueva dentro de él.

##### Reproducir audio de Coordenadas cuando se mueva el ratón {#MouseSettingsAudio}

Marcando esta casilla de verificación haces que NVDA reproduzca pitidos cuando el ratón se mueva, de modo que el usuario pueda averiguar dónde está el ratón con respecto a las dimensiones de la pantalla.
Cuanto más alto esté el ratón en la pantalla, más alto será el tono de los pitidos.
Cuanto más esté situado el ratón a la izquierda o a la derecha  en la pantalla, el sonido se reproducirá más a la izquierda o a la derecha (asumiendo que el usuario tenga unos altavoces o auriculares estéreo).

##### El Brillo controla el volumen del audio {#MouseSettingsBrightness}

Si la casilla de verificación 'reproducir audio cuando el ratón se mueva' está marcada, entonces marcando esta casilla de verificación significa que el volumen de los pitidos de audio está controlado por cómo el brillo de la pantalla esté bajo el ratón. 
Esta opción está desmarcada de forma predeterminada.

##### Ignorar la entrada del ratón desde otras aplicaciones {#MouseSettingsHandleMouseControl}

Esta opción permite al usuario ignorar los eventos del ratón (incluyendo el movimiento del ratón y las presionaciones de botones) generados por otras aplicaciones como TeamViewer y otros programas de control remoto.
Esta opción está desmarcada por defecto.
Si marcas esta opción y tienes activada la opción "Habilitar seguimiento del ratón", NVDA no anunciará lo que hay debajo del ratón si éste es movido por otra aplicación.

#### Interacción Táctil {#TouchInteraction}

Esta categoría de opciones, sólo disponible en ordenadores que ejecuten Windows 8 y posterior con capacidades táctiles, te permite configurar la forma en que NVDA interactúa con pantallas táctiles.
Esta Categoría contiene las siguientes opciones:

##### Modo de escritura táctil {#TouchTypingMode}

Esta casilla de verificación te permite especificar el método que deseas utilizar al enterducir texto usando el teclado táctil.
Si esta casilla de verificación está marcada, cuando localices una tecla en el teclado táctil, puedes levantar el dedo y la tecla seleccionada se presionará.
Si está desmarcada, deberás tocar dos veces la tecla en pantalla para presionar la tecla.

#### Cursor de Revisión {#ReviewCursorSettings}

La categoría Cursor de Revisión en el cuadro de diálogo Opciones de NVDA se utiliza para configurar el comportamiento del cursor de revisión de NVDA.
Esta categoría contiene las siguientes opciones:

<!-- KC:setting -->

##### Seguir al Foco Del sistema {#ReviewCursorFollowFocus}

Tecla: NVDA+7

Cuando se activa, el cursor de revisión siempre se colocará en el mismo objeto que el actual foco del sistema siempre que  éste  cambie.

<!-- KC:setting -->

##### Seguir al Cursor del Sistema {#ReviewCursorFollowCaret}

Tecla: NVDA+6

Cuando se activa, el cursor de revisión se moverá automáticamente a la posición del cursor del Sistema cada vez que se mueva.

##### Seguir al Cursor del Ratón {#ReviewCursorFollowMouse}

Cuando se activa, el cursor de revisión seguirá al ratón según se mueva.

##### Modo de Revisión Simple {#ReviewCursorSimple}

Cuando se activa, NVDA filtrará la jerarquía de objetos que puede navegarse, para excluir cualquier objeto que no sea del interés para el usuario; por ejemplo: objetos invisibles y objetos utilizados sólo con propósitos de diseño.

Para conmutar el modo de revisión simple desde cualquier sitio, por favor asigna un gesto personalizado utilizando el [diálogo Gestos de Entrada](#InputGestures).

#### Presentación de Objetos (NVDA+control+o) {#ObjectPresentationSettings}

La categoría Presentación de objetos del cuadro de diálogo Opciones de NVDA se utiliza para establecer la cantidad de información que NVDA presentará sobre controles tales como descripción, información de posición, etc.
Esta categoría contiene las siguientes opciones:

##### Anunciar Consejos {#ObjectPresentationReportToolTips}

Una casilla de verificación que cuando está marcada dice a NVDA que anuncie consejos según aparezcan. 
Muchas ventanas y controles muestran un pequeño mensaje (o consejo) cuando mueves el puntero del ratón sobre ellos, o algunas veces cuando te mueves con el foco por ellos.

##### Anunciar globos de ayuda {#ObjectPresentationReportBalloons}

Esta casilla de verificación cuando está marcada dice a NVDA que anuncie los globos de ayuda cuando aparezcan. 
Los globos de ayuda son como los consejos, pero normalmente son más grandes, y están asociados con eventos del Sistema tales como la desconexión de un cable de red, o quizás alertarte acerca de problemas de seguridad de Windows.

##### Anunciar Teclas de Atajo de los Objetos {#ObjectPresentationShortcutKeys}

Cuando esta casilla de verificación está verificada, NVDA incluirá la tecla de atajo que esté asociada con cierto objeto o control cuando sea anunciado. 
Por ejemplo el menú Archivo en una barra de menú podrá tener una tecla de atajo Alt+a.

##### Anunciar Información de la Posición del Objeto {#ObjectPresentationReportDescriptions}

Esta opción te permite elegir si deseas que se te informe sobre la posición del objeto (por ejemplo: 1 de 4) cuando te mueves al objeto con el foco o el navegador de objetos.

##### Deducir la información de Posición del Objeto cuando no esté disponible {#ObjectPresentationGuessPositionInfo}

Si el anunciado de información de posición del objeto está activado, esta opción permite a NVDA deducir la información de posición del objeto cuando no esté disponible para un control en particular.
Cuando esté activada, NVDA anunciará información de posición para más controles tales como menús y barras de herramientas, no obstante esta información podrá ser ligeramente incorrecta. 

==== Anunciar Descripciones de Objetos ========[ObjectPresentationReportDescriptions]
Desmarca esta casilla de verificación si crees que no necesitas escuchar la descripción anunciada junto con los objetos.

<!-- KC:setting -->

##### Salida en las Barras de Progreso {#ObjectPresentationProgressBarOutput}

Tecla: NVDA+u

Esta opción se te presenta con un cuadro combinado que controla cómo NVDA anuncia las actualizaciones de las barras de progreso. 

Tiene las siguientes opciones:

* Desactivado: Las barras de progreso no serán anunciadas según cambien.
* Verbalizar: Esta opción dice a NVDA que verbalice las barras de progreso en porcentajes. Cada vez que la barra de progreso cambie, NVDA verbalizará el valor nuevo. 
* Pitar: Esto dice a NVDA que pite cada vez que la barra de progreso cambie. Para un pitido más alto, el completado de la barra de progreso está más próximo
* Pitar y Verbalizar: Esta opción dice a NVDA que pite y verbalice cuando se actualiza una barra de progreso.

##### Anunciar Barras de Progreso en Segundo Plano {#ObjectPresentationReportBackgroundProgressBars}

Esta es una opción que, cuando está marcada, dice a NVDA que mantenga el anunciado de una barra de progreso, aún si no está físicamente visible en primer plano. 
Si minimizas o cambias a otra ventana que contenga una barra de progreso, NVDA mantendrá la pista de ella, permitiéndote hacer otras cosas mientras NVDA sigue a la barra de progreso.

<!-- KC:setting -->

##### Anunciar cambios de contenido dinámico {#ObjectPresentationReportDynamicContent}

Tecla: NVDA+5

Conmuta el anunciado de contenido nuevo en objetos particulares tales como terminales y el control de histórico en programas de chat.

##### Reproducir un sonido al aparecer autosugerencias {#ObjectPresentationSuggestionSounds}

Alterna el anunciado de la aparición de autosugerencias, y si está habilitado, NVDA reproducirá un sonido para indicar esto.
Las sugerencias automáticas son listas de entradas sugeridas basadas en texto enterducido en ciertos campos de edición y documentos.
por ejemplo, cuando enterduzcas texto en el cuadro de búsqueda en el menú inicio en Windows Vista y posteriores, Windows muestra una lista de sugerencias basadas en lo que escribiste.
Para algunos campos de edición  tales como campos de búsqueda en varias aplicaciones de Windows 10, NVDA puede notificarte que ha aparecido una lista de sugerencias al escribir texto.
La lista de autosugerencias se cerrará una vez te muevas por el campo de edición, y para algunos campos, NVDA puede notificarte de esto cuando ello ocurra.

#### Composición de Entrada {#InputCompositionSettings}

La categoría Composición de entrada te permite controlar cómo anuncia NVDA la entrada de Caracteres Asiáticos, tales como con IME o métodos de Servicio de entrada de texto .
Ten en cuenta que debido al hecho de que los métodos de entrada varían en gran medida por sus características disponibles y por cómo transmiten la información, lo más probable será que sea necesario configurar estas opciones de modo diferente para cada método de entrada para obtener la experiencia de escritura más eficiente.

##### Anunciar Automáticamente todos los Candidatos Disponibles {#InputCompositionReportAllCandidates}

Esta opción, que está activada de manera predeterminada, te permite elegir si todos los candidatos visibles deberían anunciarse automáticamente cuando aparezca una lista de candidatos o su página cambie.
Tener esta opción activada para métodos de entrada pictográfica tales como chino Nuevo ChangJie o Boshiami, es útil pues puedes escuchar todos los símbolos automáticamente y sus números y puedes elegir uno inmediatamente.
Sin embargo, para los métodos de entrada fonéticos tales como el Chinese New Phonetic, Podría ser más útil desactivar esta opción ya que todos los símbolos sonarán igual y tendrás que utilizar las teclas de cursor para navegar por los elementos de la lista individualmente para obtener más información de la descripción de caracteres para cada candidato.

##### Anunciar Candidato Seleccionado {#InputCompositionAnnounceSelectedCandidate}

Esta Opción, que está activada por omisión, te permite elegir si NVDA debería anunciar el candidato seleccionado cuando aparece una lista de candidatos o cuando la selección se cambió.
Para los métodos de entrada donde la selección se puede cambiar con las teclas de flechas (tal como el Chinese New Phonetic) esto es necesario, pero para algunos métodos de entrada podría ser más eficiente teclear con esta opción desactivada.
Ten en cuenta que aún con esta opción desactivada, el cursor de revisión todavía se colocará sobre el candidato seleccionado permitiéndote utilizar la navegación de objetos para revisar manualmente para leer este u otros candidatos.

##### Incluir siempre descripciones cortas de caracteres para los candidatos {#InputCompositionCandidateIncludesShortCharacterDescription}

Esta Opción, que está activada por omisión, te permite elegir si NVDA debería proporcionar o no una descripción corta para cada carácter en un candidato, o cuando se seleccione o cuando se lea automáticamente cuando aparezca la lista de candidatos.
Ten en cuenta que para localizaciones tales como Chino, el anunciado de descripciones extra de caracteres para el candidato seleccionado no está afectado por esta opción.
Esta opción podría ser útil para los métodos de entrada Coreano y japonés.

##### Anunciar Cambios para la Cadena de Lectura {#InputCompositionReadingStringChanges}

Algunos métodos de entrada como el Chinese New Phonetic y el New ChangJie tienen una cadena de lectura (conocida a veces como una cadena de precomposición).
Puedes elegir si NVDA debería anunciar caracteres nuevos al ser tecleados en esta cadena de lectura con esta opción.
Esta opción está activada de manera predeterminada.
Ten en cuenta que algunos métodos de entrada antiguos tales como Chino ChangJie podrían no utilizar la cadena de lectura para contener los caracteres de precomposición, en su lugar utiliza la cadena de composición directamente. Por favor consulta la siguiente opción para configurar el anunciado de la cadena de composición.

##### Anunciar Cambios a la cadena de composición {#InputCompositionCompositionStringChanges}

Después de que la lectura o los datos de precomposición hayan sido combinados dentro de un símbolo pictográfico válido, la mayoría de los métodos de entrada colocan este símbolo dentro de una cadena de composición para un almacenamiento temporal junto con otros símbolos combinados antes de que finalmente se inserten dentro del documento.
Esta Opción te permite elegir si NVDA debería anunciar o no símbolos nuevos según aparezcan en la cadena de composición.
Esta opción está activada por omisión.

#### Modo Exploración (NVDA+control+b) {#BrowseModeSettings}

La categoría Modo Exploración del cuadro de diálogo Opciones de NVDA se utiliza para configurar el comportamiento de NVDA al leer y al navegar por documentos complejos como páginas web.
Esta categoría contiene las siguientes opciones:

##### Máximo Número de Caracteres en Una Línea {#BrowseModeSettingsMaxLength}

Este campo establece la anchura máxima de una línea en el modo exploración (en caracteres).

##### Máximo número de Líneas por Página {#BrowseModeSettingsPageLines}

Este campo ajusta la cantidad de líneas que moverás cuando presiones Avance de página o Retroceso de página mientras estés en modo exploración.

<!-- KC:setting -->

##### Utilizar diseño de pantalla {#BrowseModeSettingsScreenLayout}

Tecla: NVDA+v

Esta opción te permite especificar si el contenido en el modo Exploración debería colocar cosas tales como enlaces y otros campos cada uno en su propia línea, o si debería conservarlos en el flujo de texto según sea mostrado visualmente.
Si la opción está activada, entonces las cosas permanecerán según sean mostradas visualmente, pero si está desactivada, entonces los campos serán colocados en su propia línea.

##### Habilitar modo Exploración al cargar Página {#BrowseModeSettingsEnableOnPageLoad}

Esta casilla de verificación conmuta si se debería habilitar automáticamente el modo exploración al cargar una página.
Cuando esta opción esté deshabilitada, el modo exploración todavía puede activarse manualmente en páginas o en documentos donde se admita el modo exploración.
Consulta la [Sección modo Exploración](#BrowseMode) para una lista de las aplicaciones admitidas por el modo Exploración.
Ten en cuenta que esta opción no se aplica a situaciones donde el modo exploración sea siempre opcional, por ejemplo, en Microsoft Word.
Esta opción está habilitada por defecto.

##### Verbalizar Todo Automáticamente al Cargar la Página {#BrowseModeSettingsAutoSayAll}

Esta casilla de verificación alterna la verbalización automática de una página después de cargarla en modo exploración.
Esta opción está activada por defecto.

##### Incluir Tablas de Diseño {#BrowseModeSettingsIncludeLayoutTables}

Esta opción afecta a cómo NVDA maneja las tablas utilizadas exclusivamente con fines de diseño.
Cuando está activada, NVDA las trata como tablas normales, anunciándolas basándose en las [Opciones de Formato de Documento](#DocumentFormattingSettings) y localizándolas con los comandos de navegación rápida.
Cuando está desactivada, no se anuncian ni se encuentran con la navegación rápida.
Sin embargo, el contenido de las tablas todavía se incluirá como texto normal.
Esta opción está desactivada de forma predeterminada.

Para conmutar la inclusión de tablas de diseño desde cualquier lugar, por favor asigna un gesto personalizado utilizando el diálogo `[Gestos de entrada](#InputGestures).

##### Configurando el anunciado de campos tales como enlaces y encabezados {#BrowseModeLinksAndHeadings}

Por favor consulta las opciones en la  [categoría Formateado de Documentos](#DocumentFormattingSettings) del diálogo [Opciones de NVDA](#NVDASettings) para configurar los campos que se anuncian cuando se navega, tales como enlaces, encabezados y tablas.

##### Modo de foco automático para cambios del foco {#BrowseModeSettingsAutoPassThroughOnFocusChange}

Esta opción permite al modo foco invocarse si el foco cambia. 
Por ejemplo, cuando estás en una página Web, si presionas tab. y caes sobre un formulario, si esta opción está verificada, el modo foco se invocará automáticamente.

##### Modo foco automático para movimiento de cursor {#BrowseModeSettingsAutoPassThroughOnCaretMove}

Esta opción, cuando está marcada, permite a NVDA entrar y salir del modo foco cuando se utilizan las flechas. 
Por ejemplo, si se va presionando flecha abajo por una página Web y caes sobre un cuadro de edición, NVDA activará automáticamente el modo foco. Si presionas las flechas para salir del cuadro de edición, NVDA te volverá a poner en modo revisión.

##### Indicación de Audio de los modos Foco y Navegación {#BrowseModeSettingsPassThroughAudioIndication}

Si esta opción está activada, NVDA reproducirá sonidos especiales cuando cambie entre modo exploración y modo foco en lugar de verbalizar el cambio.

##### Capturar los gestos que no sean de comandos  para que no alcancen el  documento {#BrowseModeSettingsTrapNonCommandGestures}

Habilitada de modo predeterminado, esta opción te permite elegir si los gestos (tales como la presionación de teclas) que no sean una orden de NVDA y que no se considere que sea una tecla de orden en general, deberían capturarse para no pasar al documento que esté en el foco actualmente. 
Como un ejemplo, al estar activada, si se presionó la letra j, debería capturarse para no alcanzar el documento, ya que no es ni una tecla de navegación rápida ni es probable que sea una orden de la misma aplicación.

#### Formateado de Documento (NVDA+control+d) {#DocumentFormattingSettings}

La mayoría de las casillas de verificación en este diálogo son para configurar qué tipo de formato deseas escuchar automáticamente cuando muevas el cursor por los documentos. 
Por Ejemplo, si marcas la casilla de verificación anunciar el nombre de la fuente, cada vez que navegues por el texto con una fuente diferente, el nombre de la fuente será anunciado.

Las opciones de formateado de documento se organizan en grupos.
Puedes configurar el anunciado de:

* Fuente
 * Nombre de fuente
 * Tamaño de fuente
 * Atributos de fuente
 * Énfasis
 * Estilo
 * Colores
* Información de documento
 * Comentarios
 * Revisiones del editor
 * Errores de ortografía
* Páginas y espaciado
 * Números de página
 * Números de línea
 * Anunciado de sangría de línea [(Desactivado, voz, Tonos, voz y tonos)](#lineIndentationOptions)
 * Sangría de párrafo (por ejemplo: sangría, sangría de primera línea)
 * Espaciado de línea (simple, doble etc)
 * Alineación
* Información de tabla
 * Tablas
 * Encabezados de fila/columna
 * Coordenadas de celda
 * Bordes de celdas [(desactivado, Estilos, Ambos Colores y Estilos)
* Elementos
 * Encabezados
 * Enlaces
 * Listas
 * Citas
 * Regiones
 * Marcos
 * Cliqueable

Para conmutar estas  opciones desde cualquier lugar, por favor asigna gestos personalizados utilizando el [diálogo Gestos de Entrada](#InputGestures).

##### Anunciar cambios de formato después del cursor {#DocumentFormattingDetectFormatAfterCursor}

Si está activada, esta opción dice a NVDA que pruebe y detecte todos los cambios de formato en una línea según la anuncia, si se hace esto podría enlentecerse la respuesta de NVDA.

De forma predeterminada, NVDA detectará el formato en la posición del cursor del Sistema / Revisión, y en algunos casos podría detectar el formato en el resto de la línea, sólo si no está causando una disminución del rendimiento.

Activa esta opción mientras compruebas la lectura de documentos en aplicaciones tales como Worpad, donde el formato sea importante.

##### Anunciado de sangría de líneas {#DocumentFormattingSettingsLineIndentation}

Esta opción te permite configurar cómo debe leerse la sangría del principio de las líneas.
El cuadro combinado Anunciar sangría de líneas con tiene cuatro opciones.

* Desactivado: NVDA no tratará la sangría especialmente.
* Voz: si se selecciona voz, cuando la cantidad de sangrado cambie, NVDA verbalizará algo como "doce espacios" o "cuatro tabuladores."
* Tonos: Si se selecciona Tonos, cuando la cantidad de sangrado cambie, los tonos indican la cantidad de cambios en la sangría.
El tono se incrementará en intensidad para cada espacio, y para el tabulador,se incrementará en intensidad equivalente de 4 espacios.
* Voz y Tonos: esta opción lee la sangría utilizando ambos métodos de arriba.

#### Opciones del OCR de Windows 10 {#Win10OcrSettings}

Las opciones en esta categoría te permiten configurar [el OCR de Windows 10](#Win10Ocr).
Esta categoría contiene las siguientes opciones:

##### Idioma de Reconocimiento {#Win10OcrSettingsRecognitionLanguage}

Este cuadro combinado te permite elegir el idioma para utilizar con el reconocimiento de texto.

#### Opciones Avanzadas {#AdvancedSettings}

¡Advertencia! Las opciones en esta categoría son para usuarios avanzados y pueden causar que NVDA no funcione correctamente si se configura de forma incorrecta.
Realiza cambios en estas opciones únicamente si estás seguro de que sabes lo que estás haciendo o si has recibido las instrucciones específicas de un desarrollador de NVDA.

##### Hacer cambios a opciones avanzadas {#AdvancedSettingsMakingChanges}

Para realizar cambios en las Opciones Avanzadas, los controles deben estar habilitados confirmando con la casilla de verificación, que comprendes los riesgos de modificar estas opciones.

##### Reestablecer las opciones predeterminadas {#AdvancedSettingsRestoringDefaults}

El botón reestablece los valores predeterminados para las opciones, incluso si la casilla de confirmación no está marcada.
Después de cambiar las opciones es posible que desees volver a los valores predeterminados.
Este también puede ser el caso si no estás seguro de que se hayan cambiado las opciones.

##### Habilitar la carga de código personalizado desde el directorio Developer Scratchpad {#AdvancedSettingsEnableScratchpad}

Al desarrollar complementos para NVDA, es útil poder probar el código a medida que lo escribes.
Esta opción al estar habilitada, permite a NVDA cargar appModules personalizados, globalPlugins, brailleDisplayDrivers y synthDrivers, desde un directorio especial de desarrolladores scratchpad de tu directorio de configuración de usuario de NVDA.
Anteriormente, NVDA cargaba código personalizado directamente desde el directorio de configuración del usuario, sin posibilidad de deshabilitarlo.
Esta opción está desactivada de forma predeterminada, lo que garantiza que nunca se ejecute ningún código no probado en NVDA sin el conocimiento explícito del usuario.
Si deseas distribuir código personalizado a otros, debes empaquetarlo como un complemento de NVDA.

##### Abrir el directorio Developer Scratchpad {#AdvancedSettingsOpenScratchpadDir}

Este botón abre el directorio donde puedes colocar el código personalizado mientras lo desarrollas.
Este botón sólo está habilitado si NVDA está configurado para permitir la carga de código personalizado desde el directorio de desarrolladores del Scratchpad.

##### Utilizar UI automation para acceder a controles de documento de Microsoft Word cuando esté disponible {#AdvancedSettingsUseUiaForWord}

Cuando esta opción esté activada, NVDA intentará utilizar la API de accesibilidad de Microsoft UI Automation para obtener información de los controles de documentos de Microsoft Word.
Esto incluye el mismo Microsoft Word, y también el visor de mensajes y el compositor de Microsoft Outlook.
 Para las versiones más recientes de Microsoft Office 2016/365 que se ejecutan en Windows 10, la compatibilidad con la UI Automation  es lo suficientemente completa como para proporcionar acceso a documentos de Microsoft Word casi igual a la compatibilidad con Microsoft Word existente de NVDA, con la ventaja añadida de que la capacidad de respuesta aumenta considerablemente.

Sin embargo, puede haber alguna información que no esté expuesta o que esté incorrectamente expuesta en algunas versiones de Microsoft Office, lo que significa que no siempre se puede confiar en este soporte de la UI automation.
Todavía no recomendamos que la mayoría de los usuarios activen esta opción de forma predeterminada, aunque invitamos a los usuarios de Office 2016/365 a que prueben esta función y nos envíen sus comentarios.

##### Utilizar UI Automation para acceder a la Consola de Windows cuando esté disponible {#AdvancedSettingsConsoleUIA}

Cuando esta opción esté activada, NVDA utilizará una versión nueva de trabajo en curso de su soporte para la Consola de Windows que aprovecha las ventajas de las [mejoras de accesibilidad hechas por Microsoft](https://devblogs.microsoft.com/commandline/whats-new-in-windows-console-in-windows-10-fall-creators-update/). Esta característica es altamente experimental y todavía incompleta, así que su uso aún no está recomendado. Sin embargo, una vez completado, se prevé que este nuevo soporte se convierta  en el predeterminado, mejorando el rendimiento y la estabilidad de NVDA en las consolas de comandos de Windows.

##### Verbalizar contraseñas en consolas UIA {#AdvancedSettingsWinConsoleSpeakPasswords}

Esta opción controla si se verbalizan los caracteres por [verbalizar caracteres al escribir](#KeyboardSettingsSpeakTypedCharacters) o [verbalizar palabras al escribir](#KeyboardSettingsSpeakTypedWords) en situaciones donde la pantalla no se actualice (tales como entrada de contraseña) en la Consola de Windows con el soporte UI automation activado. Por razones de seguridad, esta opción debería dejarse deshabilitada. Sin embargo, es posible que desees habilitarla si experimentas problemas de rendimiento o de inestabilidad con el anuncio de caracteres y/o palabras al escribir mientras utilizas el nuevo soporte experimental de NVDA para la Consola.

##### Poner Automáticamente el Foco del Sistema en los Elementos enfocables en Modo Exploración {#BrowseModeSettingsAutoFocusFocusableElements}

Tecla: NVDA+8

Habilitada por omisión, esta opción te permite elegir si el foco del sistema debería ponerse automáticamente en los elementos que puedan tenerlo (enlaces, campos de formulario, etc.) cuando se navegue por el contenido con el cursor del modo exploración.
Si se habilita, esto representa el comportamiento predeterminado de NVDA como la versión 2019.1 y anteriores.
Deshabilitando esta opción no se enfocarán automáticamente los elementos enfocables cuando se seleccionen con el cursor del modo exploración.
Esto podría resultar en una mejor experiencia de navegación y una mejor respuesta en el modo exploración.
El foco todavía se actualizará al elemento en particular cuando interactúes con él (por ejemplo, presionando un botón, marcando una casilla de verificación).
Esta funcionalidad es experimental a partir de NVDA 2019.2.

##### Tiempo de espera para el movimiento del cursor (en MS) {#AdvancedSettingsCaretMoveTimeout}

Esta opción te permite configurar el número de milésimas de segundo que NVDA esperará a que el cursor (punto de inserción) se mueva en los controles de texto editables.
Si ves que NVDA aparenta estar siguiendo incorrectamente el cursor, por ejemplo, parece estar siempre un carácter por detrás o repitiendo líneas, entonces puedes intentar aumentar este valor.

##### Categorías de registro de depuración {#AdvancedSettingsDebugLoggingCategories}

Las casillas de verificación de esta lista te permiten habilitar categorías específicas de mensajes de depuración en el registro de NVDA.
El registro de estos mensajes puede incurrir en un menor rendimiento y en archivos de registro de gran tamaño.
Activa sólo uno de ellos si un desarrollador de NVDA te ha dado instrucciones específicas, por ejemplo, al depurar por qué un controlador de pantalla braille no está funcionando correctamente.

### Miscelánea de Opciones {#MiscSettings}

Además del cuadro de diálogo [Opciones de NVDA](#NVDASettings), el submenú Preferencias del menú NVDA contiene otros elementos que se describen a continuación.

#### Diccionarios del Habla {#SpeechDictionaries}

El menú de Diccionarios del habla, (encontrado en el menú Preferencias) contiene diálogos que te permiten controlar el modo en que NVDA pronuncia palabras o frases particulares. 
Hay actualmente tres tipos diferentes de diccionarios del habla. 
son:

* Predeterminado: las reglas en este diccionario afectan a todas las voces en NVDA.
* Voz: un diccionario cuyas reglas afectan a la voz para el sintetizador que actualmente está siendo utilizado.
* Temporal: las reglas en este diccionario afectan a todas las voces en NVDA, pero sólo para la sesión actual. Estas reglas son temporales y se perderán si NVDA es reiniciado

Necesitas asignar gestos personalizados utilizando el [diálogo Gestos de Entrada](#InputGestures) si deseas abrir cualquiera de estos diálogos de diccionario desde cualquier lugar.

Todos los diálogos de diccionario contienen una lista de reglas que serán utilizadas para procesar la voz. 
El diálogo también contiene los botones Añadir, Editar y Eliminar.

Para añadir una nueva regla al diccionario, presiona el botón Añadir, y rellena los campos del cuadro de diálogo que aparece y entonces presiona Aceptar. 
A continuación berás tu nueva regla en la lista de reglas. 
Asimismo para asegurarte de que tu regla está actualmente guardada, asegúrate de presionar Aceptar para salir completamente del diálogo de diccionario Una vez hayas finalizado de añadir/editar reglas.

Las reglas para los diccionarios de voz de NVDA te permiten cambiar una cadena de caracteres por otra. 
Un ejemplo simple sería que quisieras tener a NVDA diciendo la palabra rana cada vez que tuviera que decir la palabra pájaro. 
En el diálogo de añadir regla, el modo más fácil de hacer esto es teclear la palabra pájaro en el campo Patrón, y la palabra rana en el campo de reemplazar. 
También puedes querer teclear una descripción de la regla en el campo Comentario (algo como: cambiar pájaro por rana).

Los diccionarios del habla de NVDA asimismo son mucho más poderosos que un simple reemplazo de palabras. 
El diálogo de Añadir reglas también contiene Una Casilla de verificación que dice si quieres o no que la regla sea sensible a las mayúsculas (significando que NVDA debería tener en cuenta si los caracteres están en mayúsculas o en minúsculas. 
NVDA ignora los casos de forma predeterminada). 

Finalmente, un conjunto de botones de opción te permiten decir a NVDA si tu patrón debería compararse con cualquier cosa, o sólo debería compararse si es una palabra completa o si debería tratarse como una "Expresión Regular".
Ajustar el patrón para comparar como una palabra completa significa que el reemplazo sólo se hará si el patrón no ocurre como parte de una palabra más larga; es decir, un carácter distinto a un carácter alfanumérico o un subrayado (o sin carácter) que venga inmediatamente antes y después del patrón.
Por lo tanto, utilizando el ejemplo anterior de la sustitución de la palabra "pájaro" con "rana", si fueras  a hacer de esto un reemplazo de palabra completa, no se compararía "pájaros" o "pájaroAzul".

Una expresión regular es un patrón que contiene símbolos especiales que te permiten emparejar más de un carácter al mismo tiempo, o emparejar solo números, o solo letras, según unos pocos ejemplos. 
Las expresiones regulares no están cubiertas en esta Guía del Usuario, pero hay muchos tutoriales en la Web que pueden proporcionarte más información.

#### Pronunciación de Puntuación/símbolos {#SymbolPronunciation}

Este diálogo te permite cambiar el modo en que son pronunciados la puntuación y otros símbolos, así como el nivel de los símbolos en el cual se verbalizan. 

El idioma cuya pronunciación de símbolo vaya a ser editada se mostrará en el título del diálogo.
Ten en cuenta que este diálogo respeta la opción "Confiar en el Idioma de la voz al procesar símbolos y caracteres" que se encuentra en la [Categoría Voz](#SpeechSettings) del diálogo [Opciones de NVDA](#NVDASettings) es decir, utiliza el idioma de la voz en lugar de la opción del idioma global de NVDA cuando esta opción esté habilitada.

Para cambiar un símbolo, primero selecciónalo en la lísta de Símbolos.
Puedes filtrar los símbolos enterduciendo el símbolo o una parte de su sustitución en el cuadro de edición Filtrar por.

* El campo Reemplazar te permite cambiar el texto que debería verbalizarse en lugar de este símbolo.
* Utilizando el campo Nivel, puedes ajustar el nivel más bajo del símbolo al cual este símbolo debería verbalizarse.
* El campo Enviar símbolo actual al sintetizador especifica cuando el propio símbolo (en contraposición con su reemplazo) debería enviarse al sintetizador.
Esto es útil si el símbolo causa que el sintetizador haga una pausa o cambie la entonación de la voz.
Por ejemplo, una coma causa que el sintetizador haga una pausa.
Hay tres opciones:
 * nunca: nunca envía el símbolo actual al sintetizador.
 * Siempre: envía siempre el símbolo actual al sintetizador.
 * sólo bajo Nivel de los símbolos: Envía el símbolo actual sólo si el nivel de voz de símbolo configurado es más bajo que el nivel puesto por este símbolo.
 Por ejemplo, podrías utilizar esto tal que un símbolo tendrá su reemplazo verbalizado en niveles más altos sin pausar, mientras todavía esté indicado con una pausa en los niveles más bajos.

Puedes añadir símbolos nuevos presionando el botón Añadir.
En el cuadro de diálogo que aparece, enterduce el símbolo y presiona el botón Aceptar.
Entonces, modifica los campos para el símbolo nuevo como lo harías para otros símbolos.

Puedes eliminar un símbolo que añadiste anteriormente presionando el botón Eliminar.

Cuando termines, presiona el botón Aceptar para guardar tus cambios o el botón Cancelar para descartarlos.

#### Gestos de Entrada {#InputGestures}

En este diálogo, puedes personalizar los gestos de entrada (teclas en el teclado, botones en la pantalla braille, etc.) para comandos de NVDA.

Sólo se muestran los comandos que se apliquen inmediatamente antes de que el diálogo se abra.
Por ejemplo, si quieres personalizar comandos relacionadas con el modo exploración, deberías abrir el diálogo Gestos de entrada mientras estés en modo exploración.

El árbol en este cuadro de diálogo muestra todas los comandos de NVDA aplicables agrupadas por categoría.
Puedes filtrarlos enterduciendo una o más palabras desde el nombre de los comandos dentro del cuadro de edición Filtrar por... en cualquier orden.
Cualquier gesto asociado con una orden se lista bajo la orden.

Para añadir un gesto de entrada a una orden, selecciona la orden y presiona el botón Añadir.
A continuación, realiza el gesto de entrada que desees asociar, por ejemplo, presiona una tecla del teclado o un botón en una pantalla Braille.
A menudo, un gesto puede interpretarse de más de una manera.
Por ejemplo, si has presionado una tecla en el teclado, puede que desees que sea específica para la disposición de teclado actual (por ejemplo, de escritorio o portátil) o puede que desees que se aplique a todas las disposiciones.
En este caso, aparecerá un menú que te permite seleccionar la opción deseada.

Para borrar un gesto de una orden, selecciona el gesto y presiona el botón Eliminar.

Cuando hayas terminado de realizar cambios, presiona el botón Aceptar para guardarlos o el botón Cancelar para descartarlos.

### Guardando y Recargando la configuración {#SavingAndReloading}

De forma predeterminada NVDA guardará automáticamente tus opciones al salir.
Ten en cuenta, no obstante, que esta opción predeterminada puede ser cambiada en las opciones generales en el menú preferencias. 
Para guardar las opciones manualmente en cualquier momento, elige el elemento Guardar configuración en el menú NVDA.

Si alguna vez cometes un error con las opciones y necesitas volver a las opciones guardadas, puedes elegir el elemento "volver a la configuración guardada" en el menú NVDA.
También puedes reiniciar las opciones a sus valores predeterminados de fábrica originales eligiendo Reiniciar Configuración a los Valores Predeterminados de Fábrica, que también se encuentra en el menú NVDA.

Las siguientes teclas de comandos de NVDA también son útiles:
<!-- KC:beginInclude -->

| Nombre |Tecla Escritorio |Tecla Portátil |Descripción|
|---|---|---|---|
|Guardar configuración |NVDA+control+c |NVDA+control+c |Guarda tu configuración actual tal que no se pierda cuando salgas de NVDA|
|Revertir configuración |NVDA+control+r |NVDA+control+r |presionando una vez reinicia tu configuración a cuando la guardaste por última vez. presionando tres veces la reiniciará a los valores predeterminados de fábrica.|

<!-- KC:endInclude -->

### Perfiles de Configuración {#ConfigurationProfiles}

A veces, es posible que desees tener diferentes configuraciones para diferentes situaciones.
Por ejemplo, es posible que desees tener el anunciado de sangría habilitado mientras estás editando o el anunciado de los atributos de la fuente activado mientras estás corrigiendo.
NVDA te permite hacer esto utilizando perfiles de configuración.

Un perfil de configuración contiene sólo las opciones que se cambian mientras que el perfil esté siendo editado.
La mayoría de las opciones se pueden cambiar en los perfiles de configuración con excepción de aquellas que estén en la categoría General del cuadro de diálogo [Opciones de NVDA](#NVDASettings) , las cuales se aplican a la totalidad de NVDA.

Los perfiles de configuración pueden ser activados manualmente, ya sea desde un cuadro de diálogo o utilizando gestos añadidos personalizados.
También se pueden activar de forma automática debido a disparadores tales como el cambio a una aplicación en particular.

#### Manejo Básico {#ProfilesBasicManagement}

Los perfiles de configuración se gestionan seleccionando "Perfiles de Configuración" en el menú NVDA.
También puedes hacer esto utilizando una orden de teclado:
<!-- KC:beginInclude -->

* NVDA+control+p: Muestra el cuadro de diálogo Perfiles de configuración.

<!-- KC:endInclude -->

El primer control de este diálogo es la lista de perfiles en la que se puede seleccionar uno de los perfiles disponibles.
Al abrir el diálogo, se selecciona el perfil que estés editando actualmente.
También se muestra información adicional para perfiles activos, indicando si se activaron manualmente, se dispararon y/o si están siendo editados.

Para cambiar el nombre de un perfil o eliminarlo, presiona los botones Renombrar o Eliminar, respectivamente.

presiona el botón Cerrar para cerrar el diálogo.

#### Creando un Perfil {#ProfilesCreating}

Para crear un perfil, presiona el botón Nuevo.

En el cuadro de diálogo Nuevo perfil, puedes enterducir un nombre para el perfil.
También puedes seleccionar cómo se debe usar este perfil.
Si sólo deseas utilizar este perfil manualmente, selecciona Activación manual, que es el valor predeterminado.
De lo contrario, selecciona el disparador que debería activar automáticamente este perfil.
Para mayor comodidad, si no se ha enterducido un nombre para el perfil, al seleccionar un disparador se rellenará un nombre en consecuencia.
Mira [más abajo](#ConfigProfileTriggers) para más información acerca de los disparadores.

presionando Aceptar se creará el perfil y se cerrará el cuadro de diálogo de configuración de perfiles para que puedas editarlo.

#### Activación Manual {#ConfigProfileManual}

Puedes activar manualmente un perfil seleccionándolo y presionando el botón Activación Manual.
Una vez activado, todavía se pueden activar otros perfiles debido a los disparadores, pero las opciones del perfil activado manualmente tienen prioridad.
Por ejemplo, si un perfil se dispara para la aplicación actual y el anunciado de enlaces está activado en ese perfil, pero desactivado en el perfil activado manualmente, los enlaces no se anunciarán.
Sin embargo, si has cambiado la voz en el perfil disparado, pero nunca se ha cambiado en el perfil activado manualmente, se utilizará la voz a partir del perfil disparado.
Los valores que se modifiquen se guardarán en el perfil activado manualmente.
Para desactivar un perfil activado manualmente, selecciónalo en el cuadro de diálogo Perfiles de configuración y presiona el botón desactivar Manual.

#### Disparadores {#ConfigProfileTriggers}

Al presionar el botón de Disparadores en el cuadro de diálogo Perfiles de configuración te permite cambiar los perfiles que deben ser activados automáticamente por diversos disparadores.

La lista de disparadores muestra los disparadores disponibles, que son los siguientes:

* Aplicación actual: Se dispara cuando se cambie a la aplicación actual.
* Verbalizar todo: Se dispara durante la lectura con la orden Verbalizar Todo.

Para cambiar el perfil que debe ser activado automáticamente por un disparador, selecciona el disparador y luego selecciona el perfil deseado en la lista de perfiles.
Puedes seleccionar (configuración normal) si no quieres utilizar un perfil.

presiona el botón Cerrar para volver al cuadro de diálogo de perfiles de configuración.

#### Editando un Perfil {#ConfigProfileEditing}

Si has activado manualmente un perfil, las opciones que modifiques se guardarán en ese perfil.
De lo contrario, las opciones que se modifiquen se guardarán en el perfil disparado más recientemente.
Por ejemplo, si has asociado un perfil con la aplicación Bloc de notas y cambias al Bloc de notas, las opciones modificadas se guardarán en ese perfil.
Por último, si no hay ni un perfil activado manualmente ni uno disparado, las opciones que se modifiquen se guardarán en la configuración normal.

Para editar el perfil asociado a verbalizar todo, debes [activar manualmente](#ConfigProfileManual) ese perfil.

#### Deshabilitar Temporalmente Disparadores {#ConfigProfileDisablingTriggers}

A veces, es útil desactivar temporalmente todos los disparadores.
Por ejemplo, puedes querer editar un perfil activado manualmente o la configuración normal, sin perfiles disparadores interfiriendo.
Puedes hacer esto marcando la casilla de verificación Desactivar Temporalmente Todos los Disparadores en el cuadro de diálogo  de perfiles de configuración.

Para activar o desactivar los disparadores desde cualquier lugar, por favor asigna un gesto personalizado utilizando el [Diálogo Gestos de Entrada](#InputGestures).

#### Activar un perfil utilizando gestos de entrada {#ConfigProfileGestures}

Para cada perfil que añadas, podrás asignar uno o más gestos de entrada para activarlo.
Por defecto, los perfiles de configuración no tienen gestos de entrada asignados.
Puedes añadir gestos para activar un perfil utilizando el [diálogo Gestos de Entrada](#InputGestures).
Cada perfil tiene su propia entrada en la categoría perfiles de configuración.
Cuando renombres un perfil, cualquier gesto que añadieras con anterioridad todavía estará disponible.
Borrar un perfil eliminará automáticamente el gesto asociado con él.

### Ubicación de los Ficheros de Configuración {#LocationOfConfigurationFiles}

Las versiones portables de NVDA almacenan todas sus opciones y complementos en un directorio llamado userConfig, que se encuentra en el directorio de NVDA.

Las versiones instaladas de NVDA almacenan todas sus opciones y complementos en un directorio especial de NVDA localizado en tu perfil de usuario de Windows. 
Esto significa que cada usuario en el sistema puede tener sus propias opciones de NVDA. 
Para optener tu directorio de opciones para una versión instalada de NVDA, en el menú de Inicio puedes ir a programas -> NVDA -> explorar directorio de configuración de usuario.

Las opciones para NVDA cuando se ejecuta en las pantallas de logueo o de UAC se almacenan en el directorio SystemConfig en el directorio de instalación de NVDA.
Normalmente esta configuración no debería ser tocada.
Para cambiar cómo se configura NVDA en las pantallas de logueo/UAC, configura a NVDA como desees mientras estás autentificado en Windows, guarda la configuración y luego presiona el botón "Utilizar ajustes guardados actualmente en el logueo y otras pantallas seguras en la categoría General del diálogo [Opciones de NVDA](#NVDASettings) .

## Herramientas Extra {#ExtraTools}
### Visualizador del Registro {#LogViewer}

El visualizador del Registro, encontrado en Herramientas en el menú NVDA, te permite ver toda la salida que haya ocurrido hasta ahora desde cuando iniciaste NVDA por última vez.
Utilizando NVDA+F1 se abrirá el visualizador del registro y se mostrará la información del desarrollador sobre el navegador de objetos actual.
Además de leer el contenido, también puedes guardar una copia del fichero de registro, o refrescar el visualizador tal que se muestre la salida más reciente desde que el visualizador de registro fue abierto.
Estas acciones están disponibles en el menú de visualizador de Registro.

### Visualizador de Voz {#SpeechViewer}

Para desarrolladores de Software videntes o gente demostrando NVDA a una audiencia vidente, está disponible una ventana flotante que te permite ver todo el texto que NVDA esté verbalizando actualmente.

Para activar el visualizador de voz, marca el elemento de menú "Visualizador de Voz" en Herramientas en el menú NVDA.
Desmarca el elemento de menú para desactivarlo.

La ventana del visualizador de voz contiene una casilla de verificación etiquetada "Mostrar visualizador de voz al arrancar".
Si esta está marcada, el visualizador de voz se abrirá cuando NVDA arranque.
La ventana del visualizador de voz siempre intentará reabrirse con las mismas dimensiones y localización que cuando se cerró.

Mientras el visualizador de voz está activado, se actualiza constantemente para mostrarte el texto más reciente que se esté verbalizando.
No obstante, si haces clic o colocas el foco dentro del visualizador,  NVDA detendrá temporalmente la actualización del texto, tal que podrás seleccionar o copiar fácilmente el contenido existente.

Para conmutar el visualizador de voz desde cualquier lugar, por favor asigna un gesto personalizado utilizando el [diálogo Gestos de Entrada](#InputGestures).

### Administrador de Complementos {#AddonsManager}

El Administrador de Complementos, al que se accede seleccionando Gestionar Complementos en Herramientas en el menú NVDA, te permite instalar, desinstalar, habilitar y deshabilitar paquetes de complementos para NVDA.
Estos paquetes se proporcionan por la comunidad y contienen código personalizado que podrá añadir o cambiar características en NVDA o también proporcionan soporte para líneas braille o sintetizadores de voz extra.

El Administrador de Complementos contiene una lista que muestra todos los complementos instalados actualmente en tu configuración de usuario de NVDA. 
Se muestra el nombre de paquete, el estado, la versión y el autor para cada complemento, aunque se puede ver más información tal como una descripción y una URL seleccionando el complemento y presionando el botón Acerca del complemento.
Si hay ayuda disponible para el complemento seleccionado, puedes acceder a ella presionando su botón de Ayuda.

Para examinar y descargar los complementos disponibles online, presiona el botón Obtener Complementos.
Este botón abre la [página de complementos de NVDA](https://addons.nvda-project.org/).
Si NVDA está instalado y ejecutándose en tu sistema, puedes abrir directamente el complemento desde el explorador para comenzar el proceso de instalación como se describe a continuación.
De lo contrario, guarda el paquete de complemento y sigue las instrucciones de más abajo.

Para instalar un complemento que obtuviste previamente, presiona el botón Instalar.
Esto te permitirá buscar un paquete de complemento (fichero .nvda-addon) en algún lugar de tu ordenador o en una red.
Una vez presiones Abrir, el proceso de instalación comenzará.

Cuando un complemento se va a instalar, NVDA primero te pedirá que confirmes que realmente deseas instalarlo.
Debido a que la funcionalidad de los complementos no tiene restricciones dentro de NVDA, lo cual en teoría podría incluir el acceso a tus datos personales o incluso a todo el sistema si NVDA es una copia instalada, es muy importante que instales sólo complementos desde fuentes fiables.
Una vez que el complemento esté instalado, NVDA debe reiniciarse para que el complemento comience su ejecución. 
Hasta que lo hagas, se mostrará un estado de "instalar" para ese complemento en la lista.

Para eliminar un complemento, selecciona el complemento desde la lista y presiona el botón Eliminar.
NVDA te preguntará si realmente deseas hacer esto.
Al igual que con la instalación, NVDA debe reiniciarse para que el complemento sea eliminado completamente.
Hasta que lo hagas, se mostrará un estado de "eliminar" para ese complemento en la lista.

Para deshabilitar un complemento, presiona el botón deshabilitar.
Para habilitar un comnplemento anteriormente deshabilitado, presiona el botón habilitar.
Puedes deshabilitar un complemento si su estado indica que está en ejecución o habilitado, o habilitarlo si el complemento está suspendido o deshabilitado.
Para cada presionación del botón habilitar/deshabilitar, el estado del complemento cambia para indicar qué ocurrirá al reiniciar NVDA.
Si el complemento fue deshabilitado anteriormente, se mostrará un estado "habilitado después de reiniciar".
Si el complemento fue anteriormente "Habilitado", se mostrará un estado "deshabilitado después de reiniciar"
Al igual que cuando instalas o eliminas complementos, tienes que reiniciar NVDA para que los cambios tengan efecto.

El administrador también tiene un botón Cerrar para cerrar el diálogo.
Si has instalado, eliminado o cambiado el estado de los complementos, NVDA primero te preguntará si deseas reiniciar para que los cambios puedan llevarse a cabo.

Algunos complementos antiguos pueden ya no ser compatibles con la versión de NVDA que tienes.
Cuando utilices una versión más antigua de NVDA, algunos complementos nuevos pueden no ser compatibles.
Intentar instalar un complemento incompatible resultará en un error explicando por qué el complemento se considera incompatible.

Para acceder al Administrador de Complementos desde cualquier lugar, por favor asigna un gesto personalizado utilizando el [diálogho Gestos de Entrada](#InputGestures).

### Administrador de Complementos Incompatibles {#incompatibleAddonsManager}

El Administrador de Complementos Incompatibles, al que se puede acceder a través de los botones "ver complementos incompatibles" en el Administrador de Complementos, te permite inspeccionar cualquier complemento incompatible y la razón por la que se consideran incompatibles.
Los complementos se consideran incompatibles cuando no han sido actualizados para funcionar con cambios significativos de NVDA, o cuando se basan en una característica no disponible en la versión de NVDA que estás utilizando.
El Administrador de Complementos Incompatibles tiene un mensaje breve para explicar su propósito así como la versión de NVDA.
Los complementos incompatibles se presentan en una lista con las siguientes columnas:

1. Paquete, el nombre del complemento
1. Versión, la versión del complemento
1. Razón de Incompatiblilidad, una explicación de por qué el complemento se considera incompatible

El Administrador de Complementos Incompatibles también tiene un botón "Acerca del complemento...".
Esto abre lo que te permitirá conocer todos los detalles del complemento, lo cual es de ayuda cuando contactes con el autor del complemento.

### Consola de Python {#PythonConsole}

La consola de Python de NVDA, encontrada en Herramientas en el menú NVDA, es una herramienta de desarrollo que es útil para depuración, inspección general del interior  de NVDA o inspeción de la jerarquía de accesibilidad  de una aplicación.
Para más información, por favor consulta la Guía del desarrollador disponible en [la sección de Desarrollo de la página web de NVDA](https://community.nvda-project.org/wiki/Development).

### Recargar plugins {#ReloadPlugins}

Este elemento, una vez activado, recarga app modules y plugins globales sin reiniciar a NVDA, lo cual es útil para desarrolladores.

## Sintetizadores de Voz Admitidos {#SupportedSpeechSynths}

Esta sección contiene información acerca de los sintetizadores de voz admitidos por NVDA.
Para una lista más extensa de los sintetizadores libres y comerciales que puedes comprar y descargar para utilizar con NVDA, por favor consulta la [página de voces extra](https://github.com/nvaccess/nvda/wiki/ExtraVoices).

### eSpeak NG {#eSpeakNG}

El sintetizador [Espeak NG](https://github.com/espeak-ng/espeak-ng) se compila directamente en NVDA y no requiere ningún otro controlador o componentes especiales para instalarse.
NVDA se inicia utilizando Espeak NG de forma predeterminada.
Como este sintetizador se compiló en NVDA, es una gran elección para cuando se ejecuta NVDA en  una memoria USB o en un CD en otros sistemas.

Cada voz que viene con Espeak NG habla un idioma diferente.
Hay sobre 43 idiomas diferentes soportados por Espeak NG.

También hay muchas variantes que pueden elegirse para alterar el sonido de la voz.

### Microsoft Speech API versión 4 (SAPI 4) {#SAPI4}

SAPI 4 es un antiguo estándar de Microsoft para sintetizadores de voz software.
NVDA todavía es compatible con esto para usuarios que aún tengan sintetizadores SAPI 4 instalados.
No obstante, Microsoft ya no da soporte para esto y se necesitan componentes que ya no están disponibles desde Microsoft.

Cuando utilices este sintetizador con NVDA, las voces disponibles (a las que se accede desde la  [categoría Voz](#SpeechSettings) del diálogo [Opciones de NVDA](#NVDASettings) o por el [Anillo de Opciones del Sintetizador](#SynthSettingsRing)) contendrán todas las voces de todos los motores instalados SAPI 4 encontrados en tu sistema.

### Microsoft Speech API versión 5 (SAPI 5) {#SAPI5}

SAPI 5 es un estándar de Microsoft para sintetizadores de voz software.
Muchos sintetizadores de voz que cumplen con este estándar podrán comprarse o descargarse gratuitamente desde varias compañías y sitios Web, aunque probablemente tu sistema ya vendrá con al menos una voz SAPI 5 preinstalada.
Cuando se utiliza este sintetizador con NVDA, las voces disponibles (a las que se accede desde la [categoría Voz](#SpeechSettings) del cuadro de diálogo [Opciones de NVDA](#NVDASettings) o por el [Anillo de Opciones del Sintetizador](#SynthSettingsRing)) contendrán todas las voces de todos los motores SAPI 5 instalados encontrados en tu sistema.

### Microsoft Speech Platform {#MicrosoftSpeechPlatform}

La Microsoft Speech Platform proporciona voces para muchos idiomas que se utilizan habitualmente en el desarrollo de aplicaciones basadas en servidores de habla. 
Estas voces también pueden utilizarse con NVDA.

Para utilizar estas voces, necesitarás instalar dos componentes:

* Microsoft Speech Platform - Runtime (Versión 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Versión 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * Esta página incluye muchos ficheros tanto de reconocimiento como de texto a voz.
 Elige los ficheros que contengan los datos TTS para los idiomas/voces deseados.
 Por ejemplo, el fichero MSSpeech_TTS_en-US_ZiraPro.msi es una voz inglesa U.S..

### Voces Windows OneCore {#OneCore}

Windows 10 incluye nuevas voces conocidas como voces "OneCore" o "mobile".
Se proporcionan voces para muchos idiomas y son más ágiles que las voces Microsoft disponibles al utilizar Microsoft Speech API versión 5.

Porfavor consulta este artículo de Microsoft para una lista de voces disponibles e instrucciones para instalarlas: https://support.microsoft.com/en-us/help/22797/windows-10-narrator-tts-voices

Por favor ten en cuenta que actualmente no están disponibles con NVDA las velocidades más rápidas disponibles con Narrator.
También, la velocidad seleccionada en la configuración de Windows afecta a la configurada en NVDA.
Estos problemas no se pueden resolver sin cambios en Windows.
Deseamos que esto se solucione en una actualización futura de Windows.

### Audiologic Tts3 {#Audiologic}

Este es un sintetizador de voz comercial específicamente para el idioma italiano.
Debes tener este sintetizador instalado en tu sistema para poder utilizarlo con NVDA.
Para más información, por favor visita el sitio Web de Audiologic en [www.audiologic.it](http://www.audiologic.it).

Este sintetizador no soporta la [funcionalidad de deletreo](#SpeechSettingsUseSpelling).

## líneas braille Admitidas {#SupportedBrailleDisplays}

Esta sección contiene información acerca de las líneas braille compatibles con NVDA.

### Pantallas que admiten la detección automática {#AutomaticDetection}

NVDA tiene la capacidad para detectar muchas líneas braille en segundo plano automáticamente, o a través de USB o de bluetooth.
Este comportamiento se logra seleccionando la opción Automático como la pantalla braille preferida desde el [cuadro de diálogo Opciones de Braille](#BrailleSettings) de NVDA.
Esta opción está seleccionada predeterminadamente.

Las siguientes pantallas admiten esta funcionalidad de detección automática.

* Pantallas Handy Tech
* Pantallas Baum/Humanware/APH/Orbit braille
* Series de las HumanWare Brailliant BI/B
* HumanWare BrailleNote
* SuperBraille
* Series de las Optelec ALVA 6
* Series de las HIMS Braille Sense/Braille EDGE/Smart Beetle/Sync Braille
* Pantallas Eurobraille Esys/Esytime/Iris

### Series de la Freedom Scientific Focus/PAC Mate {#FreedomScientificFocus}

Todas las pantallas Focus y PAC Mate de [Freedom Scientific](https://www.freedomscientific.com/) están admitidas.
Necesitarás los controladores de líneas braille de Freedom Scientific instalados en tu sistema.
Si no los tienes todavía, puedes obtenerlos desde https://www2.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp.
Aunque esta página sólo mencione la pantalla Focus 40 Blue, el controlador es compatible con todas las pantallas Focus y Pacmate de Freedom Scientific.

De manera predeterminada, NVDA puede detectar automáticamente y conectarse a estas pantallas tanto a través de USB como de bluetooth.
No obstante, cuando se configura la pantalla, puedes seleccionar explícitamente los puertos "USB" o "Bluetooth" para restringir el tipo de conexión a utilizar.
Esto podría ser útil si quieres conectar la pantalla focus a NVDA utilizando bluetooth, y todavía podrías cargarla utilizando la energía del USB desde tu ordenador.
La detección automática de líneas braille de NVDA también reconocerá la pantalla en USB o en Bluetooth.

Seguidamente van las asociaciones de teclas para esta pantalla con NVDA.
Por favor consulta la documentación de la pantalla para descripciones de dónde pueden encontrarse estas teclas.
<!-- KC:beginInclude -->

| Nombre |tecla|
|---|---|
|Desplazar pantalla braille atrás |sensorSuperior1 (primera celda en la pantalla)|
|Desplazar pantalla braille adelante |sensorSuperior20/40/80 (última celda en la pantalla)|
|Desplazar pantalla braille atrás |barraDeAvance izquierda|
|Desplazar pantalla braille adelante |barraDeAvance derecha|
|Conmutar seguimiento de braille |leftGDFButton+rightGDFButton|
|Conmutar acción de rueda izquierda |presionar rueda izquierda|
|Moverse hacia atrás utilizando acción de rueda izquierda |rueda izquierda hacia arriba|
|Moverse hacia adelante utilizando acción de rueda izquierda |rueda izquierda hacia abajo|
|Conmutar acción de rueda derecha |presionar rueda derecha|
|Moverse hacia atrás utilizando acción de rueda derecha |rueda derecha hacia arriba|
|Moverse hacia adelante  utilizando acción de rueda derecha |rueda derecha hacia abajo|
|Guiar hacia la celda braille |sensor|
|tecla shift+tab |barra espaciadora braille+punto1+punto2|
|tecla tab |barra espaciadora braille+punto4+punto5|
|tecla flecha abajo |barra espaciadora braille+punto1|
|tecla flecha arriba |barra espaciadora braille+punto4|
|tecla control+flecha izquierda |barra espaciadora braille+punto2|
|tecla control+flecha derecha |barra espaciadora braille+punto5|
|tecla flecha izquierda |barra espaciadora braille+punto3|
|tecla flecha derecha |barra espaciadora braille+punto6|
|tecla inicio |barra espaciadora braille+punto1+punto3|
|tecla fin |barra espaciadora braille+punto4+punto6|
|tecla control+inicio |barra espaciadora braille+punto1+punto2+punto3|
|tecla control+fin |barra espaciadora braille+punto4+punto5+punto6|
|tecla alt |barra espaciadora braille+punto1+punto3+punto4|
|tecla alt+tab |barra espaciadora braille+punto2+punto3+punto4+punto5|
|tecla alt+shift+tab |barra espaciadorabraille+punto1+punto2+punto5+punto6|
|tecla windows+tab |barra espaciadora braille+punto2+punto3+punto4|
|tecla escape |barra espaciadora braille+punto1+punto5|
|tecla windows |barra espaciadora braille+punto2+punto4+punto5+punto6|
|tecla espacio |barra espaciadora braille|
|tecla windows+d (minimizar todas las aplicaciones) |barra espaciadora braille+punto1+punto2+punto3+punto4+punto5+punto6|
|Anunciar Línea Actual |barra espaciadora braille+punto1+punto4|
|Menú NVDA |barra espaciadora braille+punto1+punto3+punto4+punto5|

Para los modelos más recientes de la Focus que contengan teclas de balancines (focus 40, focus 80 y focus blue):

| Nombre |Tecla|
|---|---|
|Mover pantalla braille a la línea anterior |balancín izquierdo arriba, balancín derecho arriba|
|Mover pantalla braille a la línea siguiente |balancín izquierdo abajo, balancín derecho abajo|

Sólo para la Focus 80:

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille atrás |barra frontal izquierda arriba, barra frontal derecha arriba|
|Desplazar pantalla braille adelante |barra frontal izquierda abajo, barra frontal derecha abajo|

<!-- KC:endInclude -->

### Series de la Optelec ALVA 6/conversor de protocolo {#OptelecALVA}

Ambas pantallas ALVA BC640 y BC680 de [Optelec](https://www.optelec.com/) están admitidas.
Alternativamente, puedes conectar una pantalla antigua de Optelec, tal como una Braille Voyager, utilizando un conversor de protocolo suministrado por Optelec.
No necesitas instalar ningún controlador en especial para utilizar estas pantallas.
Sólo enchufa la pantalla y configura NVDA para utilizarla.

Nota: NVDA podría no ser capaz de usar una pantalla ALVA BC6 con Bluetooth cuando se empareja utilizando la utilidad ALVA Bluetooth.
Cuando hayas emparejado tu dispositivo usando su utilidad y NVDA no pueda detectarlo, te recomendamos enparejar tu pantalla ALVA de la forma ordinaria utilizando las opciones de Bluetooth de Windows.

Nota: dado que algunas de estas pantallas tienen un teclado braille, manejan la transcripción de braille a texto por sí mismas por omisión.
Esto significa que el sistema de entrada braille de NVDA no se está utilizando en una situación predeterminada (es decir, la tabla de entrada braille configurada no tiene efecto).
Para pantallas ALVA con firmware reciente, es posible deshabilitar esta simulación de teclado HID utilizando un gesto de entrada.

Seguidamente van las asignaciones de teclas para esta pantalla con NVDA.
Por favor consulta la documentación de la pantalla para descripciones de dónde pueden encontrarse estas teclas.
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille hacia atrás |t1, etouch1|
|Mover la pantalla braille a la línea anterior |t2|
|Mover al foco actual |t3|
|Mover la pantalla braille a la línea siguiente |t4|
|Desplazar pantalla braille hacia adelante |t5, etouch3|
|Guiar a la celda braille |sensor|
|Anunciar formato de texto bajo la celda braille |sensores secundarios|
|Conmutar la simulación de teclado HID |t1+spEnter|
|Mover a la línea superior en revisión |t1+t2|
|Mover a la línea inferior en revisión |t4+t5|
|Conmutar el seguimiento braille |t1+t3|
|Anunciar el título |etouch2|
|Anunciar la barra de estado |etouch4|
|tecla shift+tab |sp1|
|tecla alt |sp2, alt|
|tecla escape |sp3|
|tecla tab |sp4|
|tecla flecha arriba |spUp|
|tecla flecha abajo |spDown|
|tecla flecha izquierda |spLeft|
|tecla flecha derecha |spRight|
|tecla enter |spEnter, enter|
|Anunciar fecha/hora |sp2+sp3|
|menú NVDA |sp1+sp3|
|tecla windows+d (minimizar todas las aplicaciones) |sp1+sp4|
|Tecla windows+b (enfocar la bandeja del sistema) |sp3+sp4|
|tecla windows |sp1+sp2, windows|
|tecla alt+tab |sp2+sp4|
|tecla control+inicio |t3+spArriba|
|tecla control+fin |t3+spAbajo|
|tecla inicio |t3+spIzquierda|
|tecla fin |t3+spDerecha|
|tecla control |control|

<!-- KC:endInclude -->

### Pantallas Handy Tech {#HandyTech}

NVDA admite la mayoría de las pantallas de [Handy Tech](https://www.handytech.de/) cuando se conecten por USB, puerto serie o bluetooth.
Para algunas pantallas antiguas USB, necesitarás instalar los controladores USB de Handy Tech en tu sistema.

Las siguientes pantallas no son compatibles al sacarlas de la caja, pero pueden utilizarse a través del [controlador universal de Handy Tech](https://handytech.de/en/service/downloads-and-manuals/handy-tech-software/braille-display-drivers) y el complemento de NVDA:

* Braillino
* Bookworm
* Pantallas modulares con la versión del firmware 1.13 o inferior. Por favor ten en cuenta que el firmware de estas pantallas puede actualizarse.

Seguidamente van las asignaciones de teclas para esta pantalla con NVDA.
Por favor conhsulta la documentación de la pantalla para descripciones de dónde pueden encontrarse estas teclas.
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar la pantalla braille hacia atrás |izquierda, arriba, b3|
|Desplazar la pantalla braille hacia adelante |Derecha, abajo, b6|
|Mover la pantalla braille a la línea anterior |b4|
|Mover la pantalla braille a la línea siguiente |b5|
|Guiar a la celda braille |sensor|
|tecla shift+tab |esc, triple acción  de la tecla izquierda arriba+abajo|
|tecla alt |b2+b4+b5|
|tecla escape |b4+b6|
|tecla tab |enter, triple acción  de la tecla derech arriba+abajo|
|tecla enter |esc+enter, triple acción  de la tecla derecha arriba+abajo, acción joystick|
|tecla flecha arriba |joystick arriba|
|tecla flecha abajo |joystick abajo|
|tecla flecha izquierda |joystick izquierda|
|tecla flecha derecha| joystick derecha|
|menú NVDA |b2+b4+b5+b6|
|Conmutar seguimiento de braille |b2|
|Conmutar el cursor braille |b1|
|Conmutar la presentación de contexto de foco |b7|
|Conmutar entrada braille |espacio+b1+b3+b4 (espacio+B mayúscula)|

<!-- KC:endInclude -->

### MDV Lilli {#MDVLilli}

La pantalla braille Lilli disponible desde [MDV](https://www.mdvbologna.it/) se admite.
No necesitas instalar ningún controlador específico para utilizar esta pantalla.
Solo enchufa la pantalla y configura NVDA para utilizarla.

Esta pantalla todavía no admite la funcionalidad de detección automática de NVDA.

Seguidamente van las asignaciones de teclas para esta pantalla con NVDA.
Por favor consulta la documentación de la pantalla para descripciones de dónde se pueden encontrar estas teclas.
<!-- KC:beginInclude -->

| Nombre |tecla|
|---|---|
|Desplazar hacia atrás pantalla braille |LF|
|Desplazar hacia adelante pantalla braille |RG|
|Mover pantalla braille a línea anterior |UP|
|Mover pantalla braille a línea siguiente |DN|
|Enrutar hacia la celda braille |route|
|Tecla shift+tab |SLF|
|Tecla tab |SRG|
|Tecla alt+tab |SDN|
|Tecla alt+shift+tab |SUP|

<!-- KC:endInclude -->

### líneas braille Baum/Humanware/APH/Orbit {#Baum}

Varias líneas braille de [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/), [APH](https://www.aph.org/) y [Orbit](https://www.orbitresearch.com/) se admiten cuando se conecten a través de los puertos USB, bluetooth o serie.
Estas incluyen:

* Baum: SuperVario, PocketVario, VarioUltra, Pronto!, SuperVario2, Vario 340
* HumanWare: Brailliant, BrailleConnect, Brailliant2
* APH: Refreshabraille
* Orbit: Orbit Reader 20

Algunas otras pantallas manufacturadas por Baum también podrían funcionar, aunque no han sido probadas.

Si conectas a través de USB otras pantallas que no utilicen HID, primero debes instalar los controladores USB proporcionados por el fabricante.
La VarioUltra y Pronto! utilizan HID.
La Refreshabraille y la Orbit Reader 20 pueden utilizar HID si se configuran apropiadamente.

El modo serie USB de la Orbit Reader 20 actualmente sólo es compatible en Windows 10.
Generalmente debería utilizarse USB HID  en su lugar.

Seguidamente van las asignaciones de teclas para esta pantalla con NVDA.
Por favor consulta la documentación de la pantalla braille para descripciones de dónde se pueden encontrar estas teclas.
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille hacia atrás |d2|
|Desplazar pantalla braille hacia adelante |d5|
|Mover la pantalla braille a la línea anterior |d1|
|Mover la pantalla braille a la línea siguiente |d3|
|Guiar a la celda braille |sensor|

Para pantallas que tengan un joystick:

| Nombre |Tecla|
|---|---|
|Tecla flecha arriba |arriba|
|Tecla flecha abajo |abajo|
|Tecla flecha izquierda |izquierda|
|Tecla flecha derecha |derecha|
|Tecla enter |seleccionar|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#HedoProfiLine}

La hedo ProfiLine USB de [hedo Reha-Technik](https://www.hedo.de/) está admitida.
Primero debes instalar los controladores USB proporcionados por el fabricante.

Esta pantalla todavía no admite la funcionalidad de detección automática de NVDA.

Seguidamente van las asignaciones de teclas para esta pantalla con NVDA.
Por favor consulta la documentación de la pantalla para descripciones de dónde se pueden encontrar estas teclas.
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille atrás |K1|
|Desplazar pantalla braille hacia adelante |K3|
|Mover pantalla braille a línea anterior |B2|
|Mover pantalla braille a siguiente línea |B5|
|Enrutar a la celda braille |sensores|
|Conmutar seguimiento braille |K2|
|Leer todo |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#HedoMobilLine}

Se admite la hedo MobilLine USB de [hedo Reha-Technik](https://www.hedo.de/).
Primero debes instalar los controladores USB proporcionados por el fabricante.

Esta pantalla todavía no admite la funcionalidad de detección automática de NVDA.

Seguidamente van las asignaciones de teclas para esta pantalla con NVDA.
Por favor consulta la documentación de la pantalla para descripciones de dónde pueden encontrarse estas teclas.
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille atrás |K1|
|Desplazar pantalla braille adelante |K3|
|Mover pantalla braille a línea anterior |B2|
|Mover pantalla braille a siguiente línea |B5|
|Ir a celda braille |sensores|
|Conmutar seguimiento de braille |K2|
|Leer todo |B6|

<!-- KC:endInclude -->

### Series de la HumanWare Brailliant BI/B / BrailleNote Touch {#HumanWareBrailliant}

Las líneas braille Brailliant series BI y B de [HumanWare](https://www.humanware.com/), incluyendo BI 14, BI 32, BI 40 y B 80, están admitidas cuando se conectan a través del USB o bluetooth.
Si la conectas a través de USB con el protocolo configurado a HumanWare, primero debes instalar los controladores USB proporcionados por el fabricante.
Los controladores USB no se requieren si el protocolo se configura a OpenBraille.

También se admite la BrailleNote Touch, y no requiere instalar ningún controlador.

Seguidamente van las asignaciones de teclas para las pantallas Brailliant BI/B y BrailleNote touch con NVDA.
Por favor conhsulta la documentación de la pantalla para descripciones de dónde pueden encontrarse estas teclas.

#### Asignaciones de teclas para todos los modelos {#toc241}

<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille hacia atrás |izquierda|
|Desplazar pantalla braille hacia adelante |derecha|
|Mover pantalla braille a la línea anterior |arriba|
|Mover pantalla braille a la línea siguiente |abajo|
|Guiar hasta la celda braille |sensores|
|Activar/desactivar seguimiento de braille |arriba+abajo|
|tecla flecha arriba |espacio+punto1|
|tecla flecha abajo |espacio+punto4|
|tecla flecha izquierda |espacio+punto3|
|tecla flecha derecha |espacio+punto6|
|tecla shift+tab |espacio+punto1+punto3|
|tecla tab |espacio+punto4+punto6|
|tecla alt |espacio+punto1+punto3+punto4 (espacio+m)|
|tecla escape |espacio+punto1+punto5 (espacio+e)|
|tecla enter |punto8|
|tecla windows |espacio+punto3+punto4|
|tecla alt+tab |espacio+punto2+punto3+punto4+punto5 (espacio+t)|
|Menú NVDA |espacio+punto1+punto3+punto4+punto5 (espacio+n)|
|tecla windows+d (minimizar todas las aplicaciones) |espacio+punto1+punto4+punto5 (espacio+d)|
|Leer todo |espacio+punto1+punto2+punto3+punto4+punto5+punto6|

<!-- KC:endInclude -->

#### Asignaciones de teclas para Brailliant BI 32, BI 40 y B 80 {#toc242}

<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Menú NVDA |c1+c3+c4+c5 (comando n)|
|tecla windows+d (minimizar todas las aplicaciones) |c1+c4+c5 (comando d)|
|Leer todo |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

#### Asignaciones de teclas para Brailliant BI 14 {#toc243}

<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|tecla flecha arriba |joystick arriba|
|tecla flecha abajo |joystick abajo|
|tecla flecha izquierda |joystick izquierda|
|tecla flecha derecha |joystick derecha|
|tecla enter |accionar joystick|

<!-- KC:endInclude -->

### Series de las HIMS Braille Sense/Braille EDGE/Smart Beetle/Sync Braille {#Hims}

NVDA es compatible con las líneas braille Sense, Braille EDGE, Smart Beetle y Sync Braille de [Hims](https://www.hims-inc.com/) cuando se conectan a través de USB o bluetooth. 
Si se conectan a través de USB, necesitarás instalar los controladores USB de HIMS en el sistema.
Puedes descargarlos de aquí: https://www.himsintl.com/upload/HIMS_USB_Driver_v25.zip

Seguidamente van las asignaciones de teclas para estas pantallas con NVDA.
Por favor consulta la documentación de las pantallas para descripciones de dónde pueden encontrarse estas teclas.
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Ir a la celda braille |sensores|
|Desplazar pantalla braille atrás |leftSideScrollUp, rightSideScrollUp, leftSideScroll|
|Desplazar pantalla braille adelante |leftSideScrollDown, rightSideScrollDown, rightSideScroll|
|Mover pantalla braille a línea anterior |leftSideScrollUp+rightSideScrollUp|
|Mover pantalla braille a línea siguiente |leftSideScrollDown+rightSideScrollDown|
|Mover a línea anterior en revisión |rightSideUpArrow|
|Mover a línea siguiente en revisión |rightSideDownArrow|
|Mover a carácter  anterior en revisión |rightSideLeftArrow|
|Mover a carácter siguiente en revisión |rightSideRightArrow|
|Mover a foco actual |leftSideScrollUp+leftSideScrollDown, rightSideScrollUp+rightSideScrollDown, leftSideScroll+rightSideScroll|
|Tecla control |smartbeetle:f1, brailleedge:f3|
|Tecla windows |f7, smartbeetle:f2|
|tecla alt |punto1+punto3+punto4+espacio, f2, smartbeetle:f3, brailleedge:f4|
|tecla shift |f5|
|tecla insert |punto2+punto4+espacio, f6|
|tecla aplicaciones |punto1+punto2+punto3+punto4+espacio, f8|
|tecla bloqueo de mayúsculas |punto1+punto3+punto6+espacio|
|tecla tab |punto4+punto5+espacio, f3, brailleedge:f2|
|teclas shift+alt+tab |f2+f3+f1|
|teclas alt+tab |f2+f3|
|teclas shift+tab |punto1+punto2+espacio|
|tecla fin |punto4+punto6+espacio|
|teclas control+fin |punto4+punto5+punto6+espacio|
|tecla inicio |punto1+punto3+espacio, smartbeetle:f4|
|teclas control+inicio |punto1+punto2+punto3+espacio|
|teclas alt+f4 |punto1+punto3+punto5+punto6+espacio|
|tecla flecha izquierda |punto3+espacio, leftSideLeftArrow|
|teclas control+shift+flecha izquierda |punto2+punto8+espacio+f1|
|teclas control+flecha izquierda |punto2+espacio|
|teclas shift+flecha izquierda |punto2+punto7+f1|
|teclas alt+flecha izquierda |punto2+punto7|
|tecla flecha derecha |punto6+espacio, leftSideRightArrow|
|teclas control+shift+flecha derecha |punto5+punto8+espacio+f1|
|teclas control+flecha derecha |punto5+espacio|
|teclas shift+alt+flecha derecha |punto5+punto7+f1|
|teclas alt+flecha derecha |punto5+punto7|
|tecla rePág |punto1+punto2+punto6+espacio|
|teclas control+rePág |punto1+punto2+punto6+punto8+espacio|
|tecla flecha arriba |punto1+espacio, leftSideUpArrow|
|teclas control+shift+flecha arriba |punto2+punto3+punto8+espacio+f1|
|teclas control+flecha arriba |punto2+punto3+espacio|
|teclas shift+alt+flecha arriba |punto2+punto3+punto7+f1|
|teclas alt+flecha arriba |punto2+punto3+punto7|
|teclas shift+flecha arriba |leftSideScrollDown+espacio|
|tecla avPág |punto3+punto4+punto5+espacio|
|teclas control+avPág |punto3+punto4+punto5+punto8+espacio|
|tecla flecha abajo |punto4+espacio, leftSideDownArrow|
|teclas control+shift+flecha abajo |punto5+punto6+punto8+espacio+f1|
|teclas control+flecha abajo |punto5+punto6+espacio|
|teclas shift+alt+flecha abajo |punto5+punto6+punto7+f1|
|teclas alt+flecha abajo |punto5+punto6+punto7|
|teclas shift+flecha abajo |espacio+rightSideScrollDown|
|tecla escape |punto1+punto5+espacio, f4, brailleedge:f1|
|tecla suprimir |punto1+punto3+punto5+espacio, punto1+punto4+punto5+espacio|
|tecla f1 |punto1+punto2+punto5+espacio|
|tecla f3 |punto1+punto2+punto4+punto8|
|tecla f4 |punto7+f3|
|teclas windows+b |punto1+punto2+f1|
|teclas windows+d |punto1+punto4+punto5+f1|
|teclas control+insert |smartbeetle:f1+rightSideScroll|
|teclas alt+insert |smartbeetle:f3+rightSideScroll|

<!-- KC:endInclude -->

### líneas braille Seika {#Seika}

Se admiten las líneas braille Seika Versión 3, 4 y 5 (40 celdas) y Seika80 (80 celdas) de [Nippon Telesoft](https://www.nippontelesoft.com/).
Puedes encontrar más información acerca de estas pantallas en https://www.seika-braille.com/.
Primero debes instalar los controladores USB proporcionados por el fabricante.

Estas pantallas todavía no admiten la funcionalidad de detección automática de NVDA.

Seguidamente van las asignaciones de teclas para estas pantallas con NVDA.
Por favor consulta la documentación de las pantallas para descripciones de dónde se encuentran estas teclas.
<!-- KC:beginInclude -->

| Nombre |tecla|
|---|---|
|Desplazar pantalla braille atrás |izquierda|
|Desplazar pantalla braille adelante |derecha|
|Mover pantalla braille a la línea anterior |b3|
|Mover pantalla braille a la siguiente línea |b4|
|Conmutar seguimiento del braille |b5|
|Leer todo |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|Menú NVDA |izquierda+derecha|
|Ir a la celda braille |sensores|

<!-- KC:endInclude -->

### Modelos modernos de Papenmeier BRAILLEX {#Papenmeier}

Se admiten las siguientes líneas braille: 

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB y bluetooth)
* BRAILLEX Live 20, BRAILLEX Live y BRAILLEX Live Plus (USB y bluetooth)

Estas pantallas no admiten la funcionalidad de detección automática de NVDA.

Si está instalado BrxCom, NVDA utilizará BrxCom.
BrxCom es una herramienta que te permite utilizar la entrada de teclado de la pantalla braille para funcionar independientemente de un lector de pantalla.
La entrada es posible con los modelos Trio y BRAILLEX Live.

La mayoría de los dispositivos tienen una Barra de Acceso Fácil (EAB) que permite operar rápida e intuitivamente.
La EAB puede moverse en cuatro direcciones donde en general cada dirección tiene dos posiciones.
La serie c es la única excepción a esta regla.

La serie c y algunas otras pantallas tienen dos filas de sensores por lo que la fila superior se utiliza para anunciar información de formato.
Manteniendo presionada una de las teclas superiores y presionando la EAB en los dispositivos de la serie c se emula la segunda posición.
Las series de las pantallas live tienen una fila de sensores sólo y la EAB tiene un paso por dirección.
El segundo paso podrá emularse presionando una de las teclas de sensor y presionando la EAB en la dirección correspondiente.
presionando y manteniendo las teclas arriba, abajo, derecha e izquierda (o la EAB) se causa que la acción correspondiente se repita. 

Generalmente, las siguientes teclas están disponibles en estas líneas braille:

| Nombre |Tecla|
|---|---|
|l1 |Tecla izquierda frontal|
|l2 |Tecla izquierda trasera|
|r1 |Tecla derecha frontal|
|r2 |Tecla derecha trasera|
|arriba |1 paso arriba|
|arriba2 |2 pasos arriba|
|izquierda |1 paso a la izquierda|
|izquierda2 |2 pasos a la izquierda|
|derecha |1 paso a la derecha|
|derecha2 |2 pasos a la derecha|
|dn |1 paso abajo|
|dn2 |2 pasos abajo|

Seguidamente van las asignaciones de comandos de la Papenmeier para NVDA:
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille atrás |izquierda|
|Desplazar pantalla braille adelante |derecha|
|Mover pantalla braille a la línea anterior |arriba|
|Mover pantalla braille a la línea siguiente |dn|
|Ir a la celda braille |sensores|
|Anunciar carácter actual en revisión |l1|
|Activar actual navegador de objetos |l2|
|Activar o desactivar seguimiento del braille |r2|
|Anunciar título |l1+arriba|
|Anunciar barra de estado |l2+abajo|
|Mover al objeto contenido |arriba2|
|Mover al primer objeto contenido |dn2|
|Mover al objeto anterior |derecha2|
|Mover al siguiente objeto |izquierda2|
|Anunciar formato de texto bajo la celda braille |fila de sensores superior|

<!-- KC:endInclude -->

El modelo Trio tiene cuatro teclas adicionales que están delante del teclado braille.
Estas están (ordenadas de izquierda a derecha):

* tecla de pulgar izquierdo (lt)
* espacio
* espacio
* tecla de pulgar derecho (rt)

Actualmente, la tecla pulgar derecho no se utiliza.
Las teclas interiores se mapean a espacio.

| Nombre |Tecla|
|---|---|

<!-- KC:beginInclude -->

|tecla escape |espacio con punto 7|
|tecla flecha arriba |espacio con punto  2|
|tecla flecha izquierda |espacio con punto 1|
|tecla flecha derecha |espacio con punto 4|
|tecla flecha abajo |espacio con punto 5|
|tecla control |lt+punto2|
|tecla alt |lt+punto3|
|tecla control+escape |espacio con puntos 1 2 3 4 5 6|
|tecla tab |espacio con puntos 3 7|

<!-- KC:endInclude  -->

### Modelos Antiguos Papenmeier Braille BRAILLEX {#PapenmeierOld}

Se admiten las siguientes líneas braille: 

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

Ten en cuenta que estas pantallas sólo se pueden conectar a través de un puerto serie.
Debido a esto, estas pantallas no admiten la funcionalidad de detección automática de NVDA.
Deberías  seleccionar el puerto al cual está conectada la pantalla después de haber elegido este controlador en el cuadro de diálogo [Seleccionar pantalla Braille](#SelectBrailleDisplay).

Algunos de estos dispositivos tienen una barra de acceso rápido (EAB) que permite un accionamiento rápido e intuitivo.
El EAB se puede mover en cuatro direcciones donde, generalmente, cada dirección tiene dos movimientos.
presionando y manteniendo las teclas Arriba, abajo, derecha e izquierda (o EAB) se hace que la acción correspondiente sea repetida.
Los dispositivos más antiguos no tienen una EAB; se utilizan, en su lugar, teclas frontales .

Generalmente, las siguientes teclas están disponibles en las líneas braille:

| Nombre |Tecla|
|---|---|
|l1 |Tecla frontal izquierda|
|l2 |Tecla trasera izquierda|
|r1 |Tecla frontal derecha|
|r2 |Tecla trasera derecha||
|up |1 paso arriba||
|up2 |2 pasos arriba|
|left |1 paso a la izquierda|
|left2 |2 pasos a la izquierda|
|right |1 paso a la derecha|
|right2 |2 pasos a la derecha|
|dn |1 paso abajo|
|dn2 |2 pasos abajo|

Seguidamente van las asignaciones de comandos de las Papenmeier para NVDA:

<!-- KC:beginInclude -->
Dispositivos con EAB:

| Nombre |Tecla|
|---|---|
|Desplazar la pantalla braille atrás |izquierda|
|Desplazar la pantalla braille adelante |derecha|
|Mover la pantalla braille a la línea anterior |arriba|
|Mover la pantalla braille a la línea siguiente |abajo|
|Ir a la celda braille |sensores|
|Anunciar carácter actual en revisión |l1|
|Activar navegador de objetos actual |l2|
|Anunciar título |l1up|
|Anunciar Barra de Estado| l2down|
|Moverse al objeto contenedor |up2|
|Moverse al primer objeto contenido |dn2|
|Moverse al siguiente objeto |left2|
|Moverse al objeto anterior |right2|
|Anunciar formato de texto bajo la celda braille |Upper routing strip|

BRAILLEX Tiny:

| Nombre |Tecla|
|---|---|
|Anunciar carácter actual en revisión |l1|
|Activar navegador de objetos actual |l2|
|Desplazar pantalla braille atrás |left|
|Desplazar pantalla braille adelante |right|
|Mover pantalla braille a la línea anterior |up|
|Mover pantalla braille a la línea siguiente |dn|
|Activar y desactivar seguimiento de braille |r2|
|Moverse al objeto contenedor |r1+up|
|Moverse al primer objeto contenido |r1+dn|
|Moverse al objeto anterior |r1+left|
|Moverse al siguiente objeto |r1+right|
|Anunciar formato de texto bajo la celda braille |sensores superiores|
|Anunciar título |l1+arriba|
|Anunciar barra de estado |l2+abajo|

BRAILLEX 2D Screen:

| Nombre |Tecla|
|---|---|
|Anunciar carácter actual en revisión |l1|
|Activar navegador de objetos actual |l2|
|Activar o desactivar seguimiento de braille |r2|
|Anunciar formato de texto bajo la celda braille |sensores superior|
|Mover pantalla braille a la línea anterior| up|
|Desplazar pantalla braille atrás |left|
|Desplazar pantalla braille adelante |right|
|Mover pantalla braille a la línea siguiente |dn|
|Moverse al objeto siguiente |left2|
|Moverse al objeto contenedor |up2|
|Moverse al primer objeto contenido |dn2|
|Moverse al objeto anterior |right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#HumanWareBrailleNote}

NVDA es compatible con los anotadores electrónicos BrailleNote de [Humanware](https://www.humanware.com) cuando actúen como un terminal braille para un lector de pantalla.
Se admiten los siguientes modelos:

* BrailleNote Classic (sólo conexión serie)
* BrailleNote PK (Conexiones serie y bluetooth)
* BrailleNote MPower (Conexiones serie y bluetooth)
* BrailleNote Apex (Conexiones USB y Bluetooth)

Para el BrailleNote Touch, por favor consulta la sección [series de las Brailliant BI / BrailleNote Touch](HumanWareBrailliant).

Excepto para el BrailleNote PK, se admiten ambos teclados braille (BT) y QWERTY (QT).
Para el BrailleNote QT, no se admite la emulación del teclado de PC.
También puedes enterducir puntos braille utilizando el teclado QT.
Por favor consulta la sección de terminal braille de la guía de manual del BrailleNote para detalles.

Si tu dispositivo admite más de un tipo de conexión, cuando conectes tu BrailleNote a NVDA, debes configurar el puerto de la terminal braille en las opciones de terminal braille.
Por favor consulta el manual del BrailleNote para detalles.
En NVDA, también podrías necesitar configurar el puerto en el cuadro de diálogo [Seleccionar Pantalla Braille](#SelectBrailleDisplay).
Si te estás conectando a través de USB o bluetooth, puedes configurar el puerto a "Automático", "USB" o "Bluetooth", dependiendo de las opciones disponibles.
Si te estás conectando utilizando un puerto serie (o un conversor de USB a serie) o si no aparece ninguna de las opciones anteriores, debes elegir explícitamente el puerto de comunicación a utilizarse desde la lista de puertos hardware.

Antes de conectar tu BrailleNote Apex utilizando su cliente de interface USB, debes instalar los controladores proporcionados por HumanWare.

En el BrailleNote Apex BT, puedes utilizar la rueda de desplazamiento ubicada entre los puntos 1 y 4 para varias comandos de NVDA.
La rueda consiste en  cuatro puntos direccionales, un clic en el botón central, y una rueda que gira en el sentido o contra el sentido de las agujas del reloj.

Seguidamente van las asignaciones de comandos del BrailleNote para NVDA.
Por favor consulta la documentación del BrailleNote para encontrar dónde se localizan estas teclas.

<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar atrás pantalla braille |retroceder|
|Desplazar adelante pantalla braille |avanzar|
|Mover pantalla braille a la línea anterior |anterior|
|Mover pantalla braille a la línea siguiente |siguiente|
|Llevar a la celda braille |sensores|
|menú NVDA |espacio+punto1+punto3+punto4+punto5 (espacio+n)|
|Activar y desactivar seguimiento de braille |anterior+siguiente|
|Tecla flecha arriba |espacio+punto1|
|Tecla flecha abajo |espacio+punto4|
|Tecla flecha izquierda |espacio+punmto3|
|Tecla flecha derecha |espacio+punto6|
|Tecla retroceso de página |espacio+punto1+punto3|
|Tecla avance de página |espacio+punto4+punto6|
|Tecla inicio |espacio+punto1+punto2|
|Tecla Fin |espacio+punto4+punto5|
|teclas Control+inicio |espacio+punto1+punto2+punto3|
|Teclas Control+fin |espacio+punto4+punto5+punto6|
|tecla espacio |espacio|
|enter |espacio+punto8|
|Retroceso |espacio+punto7|
|Tecla Tab |espacio+punto2+punto3+punto4+punto5 (espacio+t)|
|Teclas Shift+tab |espacio+punto1+punto2punto5+punto6|
|Tecla Windows |espacio+punto2+punto4+punto5+punto6 (espacio+w)|
|Tecla Alt |espacio+punto1+punto3+punto4 (espacio+m)|
|Activar y desactivar ayuda de entrada |espacio+punto2+punto3+punto6 (espacio+h abajo)|

Seguidamente van los comandos asignadas al BrailleNote QT cuando no está en modo de entrada braille.

| Nombre |Tecla|
|---|---|
|Menú NVDA |leer+n|
|Tecla flecha arriba |flecha arriba|
|Tecla flecha abajo |flecha abajo|
|Tecla flecha izquierda |flecha izquierda|
|Tecla flecha derecha |flecha derecha|
|Tecla retroceso de página |función+flecha arriba|
|Tecla avance de página |función+flecha abajo|
|Tecla inicio |función+flecha izquierda|
|Tecla fin |función+flecha derecha|
|Control+teclas inicio |leer+t|
|Control+teclas fin |leer+b|
|Tecla enter |enter|
|Tecla retroceso |retroceso|
|Tecla tab |tab|
|Teclas Shift+tab |shift+tab|
|Tecla Windows |leer+w|
|Tecla Alt |leer+m|
|Conmutar ayuda de entrada |leer+1|

Seguidamente van los comandos asignadas a la rueda de desplazamiento:

| Nombre |Tecla|
|---|---|
|Tecla flecha arriba |flecha arriba|
|Tecla flecha abajo |flecha abajo|
|Tecla flecha izquierda |flecha izquierda|
|Tecla flecha derecha |flecha derecha|
|Tecla enter |botón central|
|Tecla Tab |desplazar la rueda en el sentido de las agujas del reloj|
|tecla Shift+tab |desplazar la rueda en el sentido contrario a las agujas del reloj|

<!-- KC:endInclude -->

### EcoBraille {#EcoBraille}

NVDA admite las pantallas EcoBraille de [ONCE](https://www.once.es/).
Se soportan los siguientes modelos:

* EcoBraille 20
* EcoBraille 40
* EcoBraille 80
* EcoBraille Plus

En NVDA, puedes configurar el puerto serie al que se conecta la pantalla en el cuadro de diálogo [Seleccionar Pantalla Braille](#SelectBrailleDisplay).
Estas pantallas no admiten la funcionalidad de detección automática de NVDA.

Seguidamente van las asignaciones de teclas para las pantallas EcoBraille.
Por favor consulta la [documentación para EcoBraille](ftp://ftp.once.es/pub/utt/bibliotecnia/Lineas_Braille/ECO/) para descripciones de donde se pueden encontrar estas teclas.

<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar atrás pantalla braille |T2|
|Desplazar adelante pantalla braille |T4|
|Mover pantalla braille a línea anterior |T1|
|Mover pantalla braille a siguiente línea |T5|
|Llevar a la celda braille |Sensores|
|Activar actual navegador de objetos |T3|
|Cambiar  a siguiente modo de revisión |F1|
|Mover a objeto contenedor |F2|
|Cambiar  a anterior modo de revisión |F3|
|Mover a objeto anterior |F4|
|Anunciar objeto actual |F5|
|Mover a objeto siguiente |F6|
|Mover a objeto enfocado |F7|
|Mover a primer objeto contenido |F8|
|Mover foco del sistema o cursor a posición de revisión actual |F9|
|Anunciar posición del cursor de revisión |F0|
|conmutar el braille sigue a |A|

<!-- KC:endInclude -->

### SuperBraille {#SuperBraille}

El dispositivo SuperBraille, disponible principalmente en Taiwan, puede conectarse o por USB o por serie.
Como SuperBraille no tiene ninguna tecla física para escribir o botones de desplazamiento, toda la entrada debe realizarse a través de un teclado estándar de ordenador.
Debido a esto, y para mantener compatibilidad con otros lectores de pantalla en Taiwan, se proporcionan dos combinaciones de teclas para desplazamiento de la pantalla braille:
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar atrás pantalla braille |Menos teclado numérico|
|Desplazar adelante pantalla braille |Más teclado numérico|

<!-- KC:endInclude -->

### Pantallas Eurobraille Esys/Esytime/Iris {#Eurobraille}

Se admiten por NVDA las pantallas Esys, Esytime e Iris de [Eurobraille](https://www.eurobraille.fr/).
Los dispositivos Esys y Esytime-Evo son compatibles cuando se conecten a través de USB o bluetooth.
Los dispositivos Esytime antiguos sólo admiten USB.
Las pantallas Iris sólo se pueden conectar a través de un puerto serie.
Por lo tanto, para estas pantallas, deberías seleccionar el puerto al cual se conecta después de haber elegido este controlador en el diálogo Opciones de Braille.

Las pantallas Iris y Esys tienen un teclado braille con 10 teclas.
De las dos teclas colocadas como barra espaciadora, la tecla de la izquierda se corresponde con la tecla retroceso y la tecla derecha con la barra espaciadora.

Seguidamente van las asignaciones de teclas para estas pantallas con NVDA.
Por favor consulta la documentación de la pantalla para descripciones de dónde se pueden encontrar estas teclas.
<!-- KC:beginInclude -->

| Nombre |Tecla|
|---|---|
|Desplazar pantalla braille hacia atrás |switch1-6Izquierda, l1|
|Desplazar pantalla braille hacia adelante |switch1-6Derecha, l8|
|Mover al foco actual |switch1-6Izquierda+switch1-6Derecha, l1+l8|
|Enrutar a la celda braille |sensores|
|Anunciar formato de texto bajo la celda braille |dobleSensor|
|Mover a la línea anterior en revisión |joystick1Arriba|
|Mover a la siguiente línea en revisión |joystick1Abajo|
|Mover al carácter anterior en revisión |joystick1Izquierda|
|Mover al carácter siguiente en revisión |joystick1Derecha|
|Cambiar al modo de revisión anterior |joystick1Izquierda+joystick1Arriba|
|Cambiar al siguiente modo de revisión |joystick1Derecha+joystick1Abajo|
|Eliminar la última celda braille o carácter enterducido |retroceso|
|Transcribir cualquier entrada braille y presionar la tecla enter |retroceso+espacio|
|tecla insert |punto3+punto5+espacio, l7|
|tecla suprimir |punto3+punto6+espacio|
|tecla inicio |punto1+punto2+punto3+espacio, joystick2Izquierda+joystick2Arriba|
|tecla fin |punto4+punto5+punto6+espacio, joystick2Derecha+joystick2Abajo|
|tecla flecha izquierda |punto2+espacio, joystick2Izquierda, flecha izquierda|
|tecla flecha derecha |punto5+espacio, joystick2Derecha, flecha derecha|
|tecla flecha arriba |punto1+espacio, joystick2Arriba, flecha arriba|
|tecla flecha abajo |punto6+espacio, joystick2Abajo, flecha abajo|
|tecla enter |joystick2Centro|
|tecla RePág |punto1+punto3+espacio|
|tecla AvPág |punto4+punto6+espacio|
|tecla 1 numérico |punto1+punto6+retroceso|
|tecla 2 numérico |punto1+punto2+punto6+retroceso|
|tecla 3 numérico |punto1+punto4+punto6+retroceso|
|tecla 4 numérico |punto1+punto4+punto5+punto6+retroceso|
|tecla 5 numérico |punto1+punto5+punto6+retroceso|
|tecla 6 numérico |punto1+punto2+punto4+punto6+retroceso|
|tecla 7 numérico |punto1+punto2+punto4+punto5+punto6+retroceso|
|tecla 8 numérico |punto1+punto2+punto5+punto6+retroceso|
|tecla 9 numérico |punto2+punto4+punto6+retroceso|
|tecla Insert numérico |punto3+punto4+punto5+punto6+retroceso|
|tecla punto numérico |punto2+retroceso|
|tecla dividir numérico |punto3+punto4+retroceso|
|tecla multiplicar numérico |punto3+punto5+retroceso|
|tecla menos numérico |punto3+punto6+retroceso|
|tecla más numérico |punto2+punto3+punto5+retroceso|
|tecla enter numérico |punto3+punto4+punto5+retroceso|
|tecla escape |punto1+punto2+punto4+punto5+espacio, l2|
|tecla tab |punto2+punto5+punto6+espacio, l3|
|tecla shift+tab |punto2+punto3+punto5+espacio|
|tecla imprimir pantalla |punto1+punto3+punto4+punto6+espacio|
|tecla pausa |punto1+punto4+espacio|
|tecla aplicaciones |punto5+punto6+retroceso|
|tecla f1 |punto1+retroceso|
|tecla f2 |punto1+punto2+retroceso|
|tecla f3 |punto1+punto4+retroceso|
|tecla f4 |punto1+punto4+punto5+retroceso|
|tecla f5 |punto1+punto5+retroceso|
|tecla f6 |punto1+punto2+punto4+retroceso|
|tecla f7 |punto1+punto2+punto4+punto5+retroceso|
|tecla f8 |punto1+punto2+punto5+retroceso|
|tecla f9 |punto2+punto4+retroceso|
|tecla f10 |punto2+punto4+punto5+retroceso|
|tecla f11 |punto1+punto3+retroceso|
|tecla f12 |punto1+punto2+punto3+retroceso|
|tecla windows |punto1+punto2+punto3+punto4+retroceso|
|tecla bloqMayus |punto7+retroceso, punto8+retroceso|
|tecla BloqNum |punto3+retroceso, punto6+retroceso|
|tecla shift |punto7+espacio, l4|
|Conmutar tecla shift |punto1+punto7+espacio, punto4+punto7+espacio|
|tecla control |punto7+punto8+espacio, l5|
|Conmutar tecla control |punto1+punto7+punto8+espacio, punto4+punto7+punto8+espacio|
|Tecla alt |punto8+espacio, l6|
|Conmutar tecla alt |punto1+punto8+espacio, punto4+punto8+espacio|
|Conmutar simulación de entrada de teclado HID |esytime):l1+joystick1Abajo, esytime):l8+joystick1Abajo|

<!-- KC:endInclude -->

### BRLTTY {#BRLTTY}

[BRLTTY](https://www.brltty.com/) es un programa por separado que puede utilizarse para soportar muchas líneas braille.
Para utilizar esto, necesitas instalar [BRLTTY for Windows](https://www.brltty.com/download.html).
Deberías descargar e instalar el último paquete instalable, que se llamará, por ejemplo, brltty-win-4.2-2.exe.
Cuando configures la línea y puerto a utilizar,  asegúrate de prestar gran atención a las instrucciones, especialmente si estás utilizando una línea USB y ya tienes los controladores del fabricante instalados.

Para pantallas que tengan un teclado braille, BRLTTY actualmente maneja la entrada braille por sí mismo.
Por lo tanto, la opción tabla braille de entrada de NVDA es irrelevante.

BRLTTY no está involucrado en la funcionalidad de detección automática de líneas braille de NVDA.

Seguidamente van las asignaciones a comandos de BRLTTY para NVDA.
Por favor consulta las [listas de claves de vínculos de BRLTTY](https://mielke.cc/brltty/doc/KeyBindings/) para información acerca de cómo se mapean los comandos de BRLTTY para controlar las líneas braille.
<!-- KC:beginInclude -->

| Nombre |orden de BRLTTY|
|---|---|
|Desplazar pantalla braille hacia atrás |fwinlt (va a la izquierda una ventana)|
|Desplazar pantalla braille hacia la derecha |fwinrt (va una ventana hacia la derecha)|
|Mover la pantalla braille a la línea anterior |lnup (va una línea hacia arriba)|
|Mover pantalla braille a la siguiente línea |lndn (va una línea hacia abajo)|
|Guiar a la celda braille |route (lleva el cursor al carácter)|

<!-- KC:endInclude -->

## Temas Avanzados {#AdvancedTopics}
### Opciones de Línea de comandos {#CommandLineOptions}

NVDA puede aceptar una o más opciones adicionales al arrancar que alteren su comportamiento.
Puedes pasar tantas opciones como necesites.
Estas opciones pueden pasarse al arrancar desde un atajo de teclado (en las propiedades del atajo de teclado), desde el diálogo Ejecutar(Menú Inicio -> Ejecutar o Windows+r) o desde una consola de comandos de Windows.
Las opciones deberían separarse del nombre del fichero ejecutable de NVDA y de otras opciones por espacios.
Por ejemplo, el atajo de teclado del escritorio que crea NVDA durante la instalación tiene la opción -r, que dice a NVDA que cierre la copia actual en ejecucución antes de iniciar una nueva.
Otra opción útil es --disable-addons, que dice a NVDA que suspenda todos los complementos en ejecución.
Esto te permite determinar si un problema es causado por un complemento y recuperarte de problemas serios causados por complementos.

Como un ejemplo, puedes salir de la copia actualmente en ejecución de NVDA enterduciendo lo siguiente en el diálogo Ejecutar:

nvda -q

Algunas de las opciones de línea de comandos tienen una versión corta y una larga, mientras otras sólo tienen una versión larga.
Para aquellas que tengan una versión corta, puedes combinarlas así:

|nvda -rm |Esto saldrá de la copia actualmente en ejecución de NVDA e iniciará una copia nueva con los sonidos de inicio deshabilitados, etc.|
|nvda -rm --disable-addons |Igual que el anterior, pero con los complementos deshabilitados|

Algunas de las opciones de línea de comandos aceptan parámetros adicionales; por ejemplo: cómo debería ser el grado de detalle del registro o la ruta para el directorio de configuración del usuario.
Esos parámetros deberían colocarse después de la opción, separados de la opción por un espacio cuando se utiliza la versión o un signo igual (=) cuando se utiliza  la versión larga; por ejemplo:

|nvda -l 10 |dice a NVDA que se inicie con el nivel de registro puesto en depuración|
|nvda --log-file=c:\nvda.log |Dice a NVDA que escriba su registro en c:\nvda.log|
|nvda --log-level=20 -f c:\nvda.log |Dice a NVDA que arranque con el nivel de registro puesto en info y que escriba su registro en c:\nvda.log|

Seguidamente van las opciones de línea de comandos para NVDA:

| Corta |Larga |Descripción|
|---|---|---|
|-h |--help |muestra la ayuda en línea de comandos y sale|
|-q |--quit |Sale de la copia que ya se esté ejecutando de NVDA|
|-r |--replace |Sale de la copia que ya se esté ejecutando de NVDA y arranca esta otra|
|-k |--check-running |Informa si NVDA está en ejecución a través del código de salida; 0 si está en ejecución, 1 si no está en ejecución|
|-f LOGFILENAME |--log-file=LOGFILENAME |El fichero donde deberían escribirse los mensajes de registro|
|-l LOGLEVEL |--log-level=LOGLEVEL |El nivel más bajo de mensaje registrado (debug 10, input/output 12, debug warning 15, info 20, warning 30, error 40, critical 50, disabled 100), default is warning|
|-c CONFIGPATH |--config-path=CONFIGPATH |La ruta donde se almacenan todos los ajustes para NVDA|
|-m |--minimal |Sin sonidos, sin interface, sin mensaje de inicio etc|
|-s |--secure |Modo seguro (deshabilita la consola Python y las características de registro, a menudo utilizado en pantallas seguras)|
|None |--disable-addons |Los complementos no tendrán efecto|
|None |--debug-logging |Habilita el nivel de registro de depuración sólo para esta ejecución. Esta configuración sobreescribirá cualquier otro nivel de registro ( --loglevel, -l) argumento dado, incluyendo la opción no registro.|
|None |--no-logging |Deshabilita el registro durante el uso de NVDA. Esta opción puede sobreescribirse si se especifica un nivel de registro ( --loglevel, -l) desde la línea de comandos o si el registro de depuración está activado.|
|None |--no-sr-flag |No cambia la bandera global de sistema del lector de pantalla|
|None |--install |Se instala NVDA iniciando la nueva copia instalada|
|None |--install-silent |Instala en silencio NVDA (No inicia la nueva copia instalada)|
|None |--enable-start-on-logon=True|False |Al instalar, habilita [arrancar en la pantalla de inicio](#StartAtWindowsLogon) de NVDA|
|None |--create-portable |Crea una copia portable de NVDA (iniciando la copia recientemente creada). Requiere especificarse --portable-path|
|None |--create-portable-silent |Crea una copia portable de NVDA (no inicia la copia recientemente instalada). Requiere expecificarse --portable-path|
|None |--portable-path=PORTABLEPATH |La ruta donde se creará una copia portable|

### Parámetros del Sistema {#SystemWideParameters}

NVDA permite configurar algunos valores en el registro del sistema que alteran el comportamiento de todo el sistema de NVDA.
Estos valores se almacenan en el registro del sistema bajo una de las siguientes claves:

* Sistema de 32 bits: "HKEY_LOCAL_MACHINE\SOFTWARE\nvda"
* Sistema de 64 bits: "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\nvda"

Los siguientes valores pueden configurarse bajo estas claves del registro:

| Nombre |Tipo |Valores Posibles |Descripción|
|---|---|---|---|
|configInLocalAppData |DWORD |0 (predeterminado) para deshabilitado, 1 para habilitado |Si está habilitado, almacena la configuración de usuario de NVDA en la carpeta local de datos de aplicación en lugar de la roaming application data|
|serviceDebug |DWORD |0 (predeterminado) para deshabilitar, 1 para habilitar |Si se habilita, deshabilita el modo seguro en los escritorios seguros de windows, permitiendo la utilización de la consola de Python y del visualizador del Registro. Debido a varias implicaciones importantes de seguridad, la utilización de esta opción está altamente desaconsejada|

## Información Adicional {#FurtherInformation}

Si requieres de información adicional o asistencia con respecto a NVDA, por favor visita el sitio Web de NVDA en NVDA_URL.
Aquí, puedes encontrar documentación adicional, así como soporte técnico y recursos de la comunidad.
Este Sitio también proporciona información y recursos concernientes al desarrollo de NVDA.

