# NVDA NVDA_VERSION מדריך למשתמש

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Commands Quick Reference -->



## מבוא {#toc2}

NVDA, NonVisual Desktop Access,  היא תכנה קוראת מסך  בקוד פתוח הפועלת בסביבת מערכת ההפעלה Windows
היא מספקת מידע באמצעות ברייל ודיבור ומאפשרת לאנשים עם לקות ראייה ועיוורון לעבוד עם מחשב אישי תמורת אותו המחיר שאדם רואה נדרש לשלם בעת רכישת מחשב. 
NVDA היא פרי פיתוח של  [NV Access](https://www.nvaccess.org/),  חברה הפועלת בעזרת תרומות מהציבור.

### מאפיינים כלליים {#toc3}

NVDA מאפשרת לאנשים עם לקות ראיה לתקשר עם מערכת ההפעלה וכן עם היישומים המותקנים עליה באמצעות מפתחי צד שלישי. 

המאפיינים הבולטים כוללים :  

* תמיכה ביישומים נפוצים, כולל דפדפני אינטרנט, תוכנות דואר אלקטרוני, תוכנות צ'אט ויישומי אופיס. 
-  מנועי דיבור התומכים בכ80 שפות שונות  
* הקראת עיצוב הטקסט, כגון : שם הגופן וגודלו, הסגנון ושגיאות הכתיב  
* הקראה אוטומטית של הטקסט שהעכבר נמצא מעליו ואפשרות סימון מיקומו של  העכבר באמצעות צליל 
* תמיכה במגוון רחב של צגי ברייל, כולל אפשרות הפעלת מקלדת ברייל עבור  הצגים המצויידים בתכונה זו  
* יכולת ריצה מלאה מתוך דיסק נשלף ללא צורך בהתקנה מקדימה  
* מנגנון נוח של דיבור בעת ההתקנה 
* התאמה עבור 47 שפות שונות 
* תמיכה במערכות החלונות החדישות ביותר, בגרסאות 32 ו64 סיביות  
* ריצה במסך הכניסה לחלונות וכן במסכי תוכנות מוגנות  
* תמיכה במנגנוני הנגישות הנפוצים כגון : Microsoft Active   Accessibility, Java Access Bridge, IAccessible2 וכן UI Automation עבור מערכות Windows 7 לפחות  
* תמיכה במסך DOS וביישומי DOS  

### התאמה בינלאומית {#toc4}

חשוב מאוד שלכל אדם בעולם, תהא שפתו אשר תהא, תהיה גישה חופשית 
לטכנולוגיה . בנוסף לאנגלית  NVDA כבר הותאמה ל-47 שפות, כולל איטלקית, איסלנדית, אירית, אלבנית , אמהרית, אפריקנס, ארגונית , בולגרית, גליציאנית, גאורגית, גרמנית, דנית , הודית, הולנדית, הונגרית, וייטנאמית, טורקית, טמילית, יוונית, יפנית , נורבגית, נפלית, סינית מסורתית, סינית פשוטה , סלובקית סלובנית, ספרדית, ספרדית קולומביאנית, סרבית , עברית, ערבית, פנג'בית , פולנית, פורטוגזית , פורטוגזית בראזילאית, פינית, פרסית , צ'כית , צרפתית, קוראנית, קטלונית , קרואטית , רומנית, רוסית, שוודית, תאילנדית.

### תמיכה במנועי דיבור {#toc5}

NVDA מסוגלת לספק מידע מגוון בכל אחת מהשפות הנ"ל. בנוסף לכך , היא מאפשרת קריאה והצגה של המסמכים בכל שפה בתנאי שמותקן על המחשב מנוע דיבור המכיר את השפה .  

NVDA מופעלת מראש בעזרת   [eSpeak NG](https://github.com/espeak-ng/espeak-ng),  מנוע דיבור חינמי, רב לשוני וכתוב בקוד פתוח.

ניתן למצוא מידע נוסף לגבי מנועי הדיבור הנתמכים על ידי NVDA בפרק [אודות  מנועי הדיבור הנתמכים](#SupportedSpeechSynths) 

### תמיכה בברייל {#toc6}

NVDA  מסוגלת להציג מידע על גבי מגוון רחב של צגי ברייל. למידע נוסף, יש 
לעיין בפרק [צגי הברייל הנתמכים](#SupportedBrailleDisplays) 

NVDA  מותאמת לעבודה עם שיטות שונות של ברייל מקוצר, לא מקוצר וממוחשב  בשפות רבות. 

### רשיון וזכויות יוצרים {#toc7}

NVDA  מוגנת על ידי זכויות יוצרים על שם NVDA_COPYRIGHT_YEARS NVDA  Contributors

משנת 2006 ו2016, NVDA תואמת את הכללים של הרשיון הכללי, גרסה 2, של הGNU. 
אתם רשאיים להכניס שינויים לתכנה זו כל עוד השינויים כלולים ברישיון התכנה ואתם מאפשרים לכל אחד לגשת לקוד התכנה.
כלל זה חל על התכנה המקורית וכן על השינויים שבוצעו בה, לרבות כל מסמך נלווה. 
לפרטים נוספים, ניתן לעיין בכתובת [הרישיון המלא](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html)

## דרישות מערכת {#toc8}

* NVDA  רצה תחת גרסאות 32 סיביות ו64 סיביות של מערכות ההפעלה Windows Xp  Vista, 7, 8, 8.1 ו10 .  
 * עבור Windows XP 32 סיביות, יש צורך בהתקנת Service Pack 2 או יותר  
 * עבור Server 2003, יש צורך בהתקנת Service Pack 1 או יותר  
 * עבור Windows Vista 32 סיביות, יש צורך בהתקנת Service Pack 2 או יותר וכן דרוש עדכון [KB2763674](https://support.microsoft.com/en-us/kb/2763674) 
 בדרך כלל, שני העדכונים האלה כבר מותקנים אוטומטית על-ידי Windows   Update.  
* זיכרון : זיכרון RAM של לפחות 256 MB 
* מהירות המעבד : 1.0 GHz לפחות 
* נפח דיסק נדרש :  כ-390 MB.

## איך להשיג ולהתקין את NVDA {#toc9}

ניתן להוריד עותק של NVDA בכתובת  [[www.nvaccess.org](http://www.nvaccess.org)]

בפרק העוסק בהורדה מופיע קישור להורדת הגרסה העדכנית ביותר של -NVDA.

הרצת הקובץ שהורד תביא להעלאה מידית של גרסה זמנית של NVDA 
שלוש אפשרויות עומדות לרשותך : התקנת NVDA , יצירת עותק נייד של התכנה או המשך עבודה עם הגרסה הזמנית.

אם ברצונכם להפעיל את NVDA על בסיס קבוע במחשב זה, עליכם לבחור באפשרות ההתקנה.
ההתקנה הרגילה כוללת תכונות רבות העדיפות על פני הגרסאות האחרות. לדוגמה, היא מאפשרת הרצה אוטומטית של NVDA בעת עליית המחשב, הקראת מסך ההתחברות לרשת ומסכי אבטחה שונים (דבר שלא ניתן לעשות בעזרת העותק הנייד והגרסה הזמנית), וכן יצירת קיצורי דרך בתפרית התחל ובשולחן העבודה.
נוסף על כך, הגרסה המותקנת מאפשרת יצירת עותק נייד בכל עת. 

אם בכוונתכם לקחת את התכנה אתכם על דיסק נשלף או על כל מדיה אחרת, מומלץ להשתמש דווקא בעותק הנייד.
הגרסה הניידת מסוגלת גם היא להתקין את התכנה על מחשב אחר מאוחר יותר. 
אם ברצונכם להשתמש בדיסק צרוב עליכם לשמור עליו את ערכת ההתקנה. NVDA אינה יכולה 
לרוץ מתוך מדיה לקריאה בלבד.

השימוש בגרסה הזמנית מיועד בעיקר למטרות הדגמה. העלאת גרסה זו בכל פעם מחדש עלולה לגזול זמן רב.

### מגבלות הגרסה הניידת והעותקים הזמניים {#toc10}

כפי שכבר נאמר, הגרסה הניידת והגרסה הזמנית אינן מסוגלות לפעול בעת ההתחברות ולאחריה. בנוסף לכך, חלות עליהן המגבלות הבאות : 

* חוסר יכולת לתקשר עם יישומים הרצים תחת הרשאות מנהל, אלא אם NVDA רצה בעצמה באופן זה 
* חוסר יכולת לפעול במסכי הגדרת בקרת חשבון משתמש ( UAC ) 
* חוסר יכולת לעבוד עם מסכי המגע של מערכות הפעלה Windows 8 והלאה   
* Windows 8 and later: the inability to provide features such as browse mode and speaking of typed characters in Windows Store apps.
* חוסר יכולת להפעיל את מצב הגלישה ולהקריא הקשות במסכי החנות של  Windows  

### התקנת NVDA {#toc11}

אם אתם מבצעים התקנה ישירות מתוך ערכת ההתקנה של NVDA עליכם ללחוץ על 
כפתור "התקנה". אם כבר סגרתם את חלון ההתקנה או שהתכנה רצה מתוך העותק הנייד, באפשרותכם לבצע התקנה מתוך התפריט "כלים". 

תיבת הדו-שיח תבקש אישור על ההתקנה ותודיע אם ההתקנה תביא לעדכון 
הגרסה שברשותך. לחיצה על כפתור "המשך" תפעיל את ההתקנה. 
תיבת הדו-שיח מכילה אפשרויות נוספות שיפורטו להלן. 
בתום ההתקנה יופיע חלון המודיע כי ההתקנה הסתיימה בהצלחה. לחיצה על 
כפתור "אישור" תגרום להפעלת הגרסה המעודכנת. 

#### הפעלה בעת התחברות לרשת {#toc12}

אופציה המאפשרת לקבוע אם NVDA  תופעל אוטומטית בעת התחברות לרשת החלונות, לפני בקשת הקשת הסיסמה.
אם כן, התכנה תפעל גם במסכים המוגנים ובחלון בקרת חשבון המשתמש UAC

#### יצירת קיצור דרך על שולחן העבודה (ctrl+alt+n) {#toc13}

תיבה זו קובעת אם על NVDA ליצור קיצור דרך להפעלתה משולחן העבודה 
אם כן, צירוף מקשי ההפעלה יהיה (ctrl+alt+n)  ותוכלו להפעיל את התכנה מכל מקום במחשבכם.

#### העתקת ההגדרות מהעותק הנייד לתיקיית המשתמש {#toc14}

תיבה זו קובעת אם NVDA תעתיק את ההגדרות של העותק שכרגע בריצה אל תוך תיקיית המשתמש הנוכחי שבה נמצאת הגרסה המותקנת. 
ההגדרות לא יועתקו עבור המשתמשים האחרים במחשב ולא יחולו על מסך ההתחברות ועל המסכים המוגנים. 
אפשרות זו קיימת אך ורק עבור הגרסה הניידת ולא באמצעות ריצה מתוך הגרסה להורדה.

### יצירת עותק נייד {#toc15}

כדי ליצור עותק נייד מתוך ריצת תוכנית ההתקנה, מספיק ללחוץ על כפתור "צור עותק נייד". 
אם תיבת הגדרה זו כבר נסגרה, בחר בתפריט המתאים מתוך ריצת הגרסה המותקנת : "כלים", "יצירת עותק נייד". 

תפריט זה יפתח תיבת דו-שיח המאפשר לקבוע את המיקום של העותק הנייד 
ניתן לבחור תיקייה בדיסק הקשיח או בהתקן USB נשלף, או כל מדיה אחר. 
תיבת בקרה נוספת מאפשרת לקבוע אם על NVDA להעתיק את הגדרות העותק המותקן אל תוך גרסת העותק הנייד. 
אופציה זו אפשרית רק אם הריצה הנוכחית מתייחסת לגרסה המותקנת על המחשב ולא מתוך ריצת ההתקנה הראשונית. 
לחיצה על כפתור "המשך" תיצור את העותק הנייד. 
התהליך יסתיים בהודעה על הצלחתו. 
לחיצה על "אישור" תסגור את ההודעה.

## תחילת העבודה עם NVDA {#toc16}
### הרצת NVDA {#toc17}

אם NVDA הותקנה מתוך ערכת ההתקנה המקורית, ההרצה נעשית על ידי לחיצה על צירוף המקשים Ctrl+alt+n  או על ידי בחירת התוכנית מתוך תיקיית NVDA בתפריט התחל. ניתן גם לפתוח את תיבת החיפוש על ידי לחיצה על מקש Win ולהקיש את המונח NVDA
קיימת אפשרות להעביר מספר אופציות  #CommandLineOptions]  בשורת הפקודה . להלן מספר דוגמאות:
הפעלת NVDA מחדש : -R סגירת NVDA : -Q ביטול הפעלת התוספים : -disable-addons ועוד.

כדי להריץ את גרסת העותק הנייד, יש לגשת לתיקייה שלתוכה הותקנה התכנה ולהפעיל את nvda.exe.   על-ידי לחיצה על  Enter  או קליק כפול.

בעת הרצת התכנה תישמע סדרה של צלילים עולים. 
עליית NVDA על מחשב איטי יחסית או מתוך עותק נייד עשויה להימשך זמן מה. 
במקרה זה, תישמע הודעה המאשרת כי התכנה עולה כעת. 

אם שום צליל אינו מושמע, או שהמחשב משמיע את צליל השגיאות של Windows או שNVDA משמיעה סדרה של צלילים יורדים, זהו סימן כי התכנה נתקלה בשגיאה המונעת ממנה לפעול. במקרה זה, ייתכן כי תצטרכו לדווח על כך למפתחים. 
אנא עיינו באתר NVDA לגבי אופן הדיווח בעניין זה.  

בעת עליית NVDA בפעם הראשונה, תיפתח תיבת דו-שיח המתארת את המקש הייחודי של NVDA ואת התפריטים הבסיסיים של התכנה. 
(אנא עיינו להלן בפרקים אודות נושאים אלה.)
תיבה זו כוללת שלוש תיבות בקרה : 
הראשונה מאפשרת לקבוע אם מקש Caps Lock משמש כמקש יחודי לפקודות NVDA 
השניה קובעת אם NVDA תעלה אוטומטית לאחר ההתחברות לרשת. אופציה זו זמינה רק בגרסה המותקנת על המחשב. 
השלישית קובעת אם תיבת דו-שיח הפתיחה תופיע בכל הרצת NVDA מחדש.

### פקודות המקלדת של NVDA {#toc18}
#### המקש הייחודי של NVDA {#toc19}

רוב פקודות המקלדת של NVDA מופעלות באמצעות לחיצה על מקש ייחודי הנקרא מקש NVDA בצירוף עם מקש אחר אחד או יותר. 
פקודות יוצאות דופן הן פקודות סריקת המסך המתבצעות באמצעות לחיצה על מקשים בודדים בכרית המספרים של המחשבים הנייחים וכן פקודות מצב הגלישה. 

ניתן להקצות את שני מקשי ה - Insert וכן את מקש ה - Caps Lock - כמקשי NVDA. 
כברירת מחדל, רק שני מקשי ה - Insert ממלאים פונקציה זו, דבר המאפשר למקש ה - Caps Lock לתפקד על-פי ייעודו המקורי. 

אם מקש ה Caps Lock הוגדר כמקש NVDA ניתן ללחוץ עליו בשתי לחיצות תכופות כדי להעביר את המקלדת לאותיות לועזיות גדולות.  

#### המקלדות השונות {#toc20}

NVDA מספקת שתי סדרות של פקודות מקלדת המכונות "מקלדת מחשב נייח ו"מקלדת מחשב נייד". 
ככלל, הפקודות למחשב נייח משמשות כברירת מחדל אך ניתן לשנות זאת בתפריט "העדפות", "מקלדת". 

בערכה זו של פקודות, נעשה שימוש נרחב בכרית המספרים, כשמקש ה - Num Lock במצב 
כבוי. רוב המחשבים הניידים אינם מצוידים בכרית מספרים אך ניתן להדמות מקשים אלה על-ידי לחיצה על המקשים 7, 8, 9, U , I , O , J , K , L , וכו',  בצירוף עם מקש FN 2 
אם המחשב הנייד אינו מאפשר פעולות אלה או שאינו מתנהג בדומה לכרית המספרים עם NumLock כבוי, מומלץ לעבור ל"מקלדת מחשב נייד". 

### מחוות המגע של NVDA {#toc21}

אם NVDA רצה על מחשב בעל מסך מגע תחת Windows 8 או 10, 
ניתן להפעיל את התכנה בעזרת מחוות היד. 
במקרה זה, כל המחוות תתייחסנה ל NVDA ולא תבצענה את תפקידן המקורי.

#### סריקת המסך {#toc22}

הפעולה הבסיסית שניתן לבצע בעזרת מחוות היד היא הקראת הטקסט הנמצא במקום שבו היתה נגיעה במסך. 
הנחת אצבע והרמתה יביאו להקראה. 
כמו כן, הזזת האצבע ללא הרמה תבצע פעולה דומה.  

#### מחוות מגע {#toc23}

מדריך זה יפרט בהמשך את הפקודות בשימוש NVDA . הרשימה תכלול גם את המחווה המיועדת לביצוע פעולה ספציפית, במקרה שקיימת פעולה כזאת. 
להלן- הסברים לגבי אופן הביצוע של פעולות המחווה. 

##### הקשות על המסך {#toc24}

הקישו קלות על המסך בעזרת אצבע אחת או יותר. 

NVDA מסוגלת להבחין בין הקשות הנעשות בעזרת אצבע אחת, שתי אצבעות או יותר משתי אצבעות. 
הקשה עם אצבע אחת היא הקשה רגילה, והקשה עם 2 אצבעות היא הקשת-2-אצבעות. וכן הלאה.

כמו-כן, היא מזהה הקשות תכופות בתור פעולה אחת. 
כך ניתן להגדיר מספר רב של צירופי הקשות, 
לפי מספר האצבעות המשתתפות בתנועה ולפי מספר הההקשות. 
למשל: הקשה עם שתי אצבעות שלוש פעמים ברצף.

##### החלקות על המסך {#toc25}

העבירו את האצבע בזריזות לרוחב המסך. 

NVDA מזהה ארבעה סוגי החלקות שונות: משמאל לימין, מימין לשמאל, מלמעלה למטה ומלמטה למעלה.

התכנה מזהה גם את מספר האצבעות המשתתפות בהחלקה, 
כך שניתן להגדיר מספר לא קטן של פעולות שונות. 

#### מצבי המגע {#toc26}

כיוון שמספר הפעולות הקיימות עולה בהרבה על מספר המחוות האפשריות, NVDA  מציע שני מצבי מגע. אלה מאפשרים ביצוע של פעולות המשתייכות 
לשני סוגים שונים : מצב טקסט, ומצב אובייקטים. 
עבור פקודות NVDA שקימת עבורן מחווה, מחווה זו מסומנת על-ידי סוגר מרובע }{  ברשימת הפקודות שבמסמך זה. לדוגמה, הביטוי : 
"מחווה כלפי מעלה" (מצב טקסט) - פירושו כי הפעולה תתבצע בעת החלקה כלפי 
מעלה, בתנאי שמצב מחוות הטקסט יהיה פעיל. אם לא מסומן מצב המחווה, הפעולה תתבצע בכל אחד משני המצבים. 

<!-- KC:beginInclude -->
המעבר בין שני המצבים מתבצע באמצעות הקשה חד-פעמית בעזרת שלוש אצבעות  יחד. 
<!-- KC:endInclude -->

### מצב עזרה {#toc27}

פעולות רבות עוד יפורטו לאורך מדריך זה. אולם, כדאי לזכור כי קיימת שיטה  מעניינת מאד של לימוד צירופי המקשים, והיא כניסה ל"מצב עזרה" לפקודות.  

כדי להיכנס למצב העזרה, יש ללחוץ על מקש NVDA בצירוף הספרה 1 בשורה העליונה של המקלדת. 
כדי לצאת ממצב העזרה יש ללחוץ שוב על מקש NVDA בצירוף הספרה 1 בשורה העליונה של המקלדת. 
אם המערכת נכנסה למצב העזרה, לחיצה על צירוף מקשים וביצוע מחווה יביאו להקראת תיאור הפעולה הרלוונטית, 
אם ישנה כזאת, אך הפעולה בעצמה לא תתבצע. 

### תפריט NVDA {#toc28}

התפריט של NVDA מאפשר לקבוע את ההגדרות השונות של התכנה, להכנס לעזרה, לשמור ולשחזר את ההגדרות, להגדיר מונחים במילוני הדיבור, להשתמש בכלים שונים ולסגור את התכנה.

הכניסה לתפריט NVDA נעשית באמצעות צירוף המקשים NVDA N מכל מקום במחשב או על-ידי הקשה קלה עם שתי אצבעות על המסך. 
ניתן להגיע לתפריט גם מתוך מגש המערכת בתחתית המסך. 
ניתן להגיע למגש המערכת על-ידי לחיצה על הכפתור השמאלי של העכבר, או באמצעות הצירוף Win B. 
יש לאתר את NVDA במגש המערכת בעזרת החץ התחתון וללחוץ על מקש תפריט המשנה, ליד הקונטרול  הימני, ולבחור באפשרות הרצויה. 

### הפקודות הבסיסיות של NVDA {#toc29}

<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |מחווה |תיאור|
|---|---|---|---|---|
|הפסקת דיבור |Control |Control |הקשה בשתי אצבעות |מפסיק את שתף הדיבור הנוכחי|
|השהיית הדיבור |Shift |Shift |ללא |משהה את הדיבור. לחיצה חוזרת ממשיך ממקום ההפסקה אם מנוע הדיבור מאפשר זאת|
|תפריט NVDA |NVDA+n |NVDA+n |הקשה כפולה בשתי אצבעות |פותח את תפריט NVDA  ולגשת להעדפות, לכלים, לעזרה, וכו'|
|מיתוג הדיבור |NVDA+S |NVDA+S |ללא |מעבר בין המצבים השונים, דיבור פעיל, דיבור בצלילים, דיבור לא פעיל|
|מיתוג מצב עזרה |NVDA+1 |NVDA+1 |ללא |מעבר בין מצב ביצוע פעולות לבין הקראת תיאור הצירוף והפעולה המשויכת אליו|
|יציאה מNVDA |NVDA+Q |NVDA+Q |ללא |יציאה מNVDA|
|העברת הקשה |NVDA+F2 |NVDA+F2 |ללא |מעביר את ההקשה הבאה לתוכנית שבפוקוס אפילו אם מדובר בפקודה של NVDA בעצמה|
|מיתוג פעילות המקשים |NVDA+SHIFT+S |NVDA+SHIFT+Z |ללא |מבטל וממפעיל מחדש את צירופי המקשים לשימוש NVDA . פעולה זו חשובה בעת עבודה עם תוכנות המספקות בעצמן הקראות דיבור|

<!-- KC:endInclude -->

### דיווח על מצב המערכת {#toc30}

<!-- KC:beginInclude -->

| פעולה |צירופי מקשים |תיאור|
|---|---|---|
|הקראת התאריך והשעה |NVDA+f12 |לחיצה אחת : הקראת השעה לחיצה פעמיים  הקראת התאריך|
|מצב הסוללה |NVDA+shift+b |הקראת מצב הסוללה באחוזים או מצב החיבור לחשמל|
|הקראת טקסט הזכרון |NVDA+C |הקראת הטקסט שבזכרון אם יש כזה|

<!-- KC:endInclude -->

## הניווט בעזרת NVDA {#toc31}

NVDA מאפשרת לסייר ולנווט במחשב באופנים שונים, על-ידי ניווט או על-ידי סריקה. 

### אובייקטים {#Objects}

כל יישום של מערכת ההפעלה מכיל מספר אובייקטים.
אובייקט יחיד, פירושו קטע של טקסט, כפתור,  תיבת סימון,  פס התקדמות או עצמה, רשימה, תיבת עריכה ועוד. 

### ניווט בעזרת סמן הפוקוס {#SystemFocus}

סמן הפוקוס, המכונה סתם הפוקוס,  הוא (האובייקט  #Objects] המקבל את ההקשות במקלדת. 
לדוגמה, אם אתם מקישים טקסט אל תוך תיבת עריכה, תיבה זו היא האובייקט בפוקוס. 

הדרך הפשוטה ביותר לנווט במערכת  Windows היא הזזת הפוקוס בעזרת המקשים המיועדים לכך, כגון : מקש Tab  וצירוף Shift+Tab כדי לנוע קדימה ואחורה, מקש Alt  כדי לפתוח שורת תפריט, חץ מטה וחץ מעלה כדי לבחון את התפריטים הספציפיים, הצירוף Alt+Tab כדי לעבור מתכנית אחת לשנייה, ועוד. 
תוך כדי הניווט, NVDA תספק מידע לגבי האובייקטים שבפוקוס, כגון שם, סוג, ערך, מצב,  תיאור, קיצור דרך, מיקום ועוד.

NVDA מאפשרת שימוש נרחב יותר בניווט הפוקוס בעזרת פקודות יחודיות :
<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |תיאור|
|---|---|---|---|
|הקראת הטקסט שבפוקוס |NVDA+Tab |NVDA+Tab |הקראת הטקסט של האובייקט או הפקד שבפוקוס כעת. לחיצה פעמיים : איות המידע.|
|הקראת כותרת החלון |NVDA+T |NVDA+T |הקראת הטקסט של השורה העליונה ביותר בחלון. לחיצה פעמיים : איות המידע. לחיצה שלוש פעמים : הכנסת המידע לזכרון הזמני|
|הקראת חלון |NVDA+B |NVDA+B |הקראת המלל של כל האובייקטים שמכיל החלון שבפוקוס. אפשרות זו יעילה להבנת תוכנן של תיבות דו-שיח|
|הקראת שורת מצב |NVDA+End |NVDA+Shift+End |הקראת שורת המצב אם יש כזאת. לחיצה פעמיים : איות המידע|

<!-- KC:endInclude -->

### ניווט בעזרת סמן המערכת {#SystemCaret}

אם ניתן לנווט בתוך {אובייקט #Objects]  או אם ניתן לערוך טקסט בתוך האובייקט שב{פוקוס #SystemFocus], אזי ניתן לנוע בתוכו בעזרת סמן המערכת, המכונה גם סמן העריכה.

כדי לנוע בתוך אובייקט שנמצא כרגע בפוקוס, יש להשתמש במקשים המיועדים לכך, כגון חיצי הכיוון, PageUp, PageDown, Home, End  ועוד.
באותו רגע, ניתן גם לערוך את הטקסט, אם האובייקט מאפשר זאת.
NVDA תספק מידע לגבי התווים, המילים והשורות תוך כדי תנועה, ותודיע על סימון של קטעי טקסט ועל ביטול הסימון.

להלן פקודות NVDA הנוגעות לסמן המערכת :
<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |מחווה |תיאור|
|---|---|---|---|---|
|הקרא הכל |NVDA+חץ תחתון |NVDA+A |הקראה רציפה ממקום הסמן והלאה. הסמן זז תוך כדי ההקראה|
|הקראת השורה שבפוקוס |NVDA+חץ מעלה |NVDA+L |הקראת השורה המכילה את סמן המערכת כעת. לחיצה פעמיים : איות השורה|
|הקראת הטקסט הנבחר |NVDA+Shift+חץ מעלה |NVDA+Shift+S |הקראת הטקסט שנבחר כרגע.|
|הקראת המשפט הבא |Alt+חץ מטה |Alt+חץ מטה |הקראת המשפט הבא (ב-Word וב-Outlook  בלבד)|
|הקראת המשפט הקודם |Alt+חץ מעלה |Alt+חץ מעלה |הקראת המשפט הקודם (בWord ובOutlook  בלבד)|

קיימות מספר פקודות המאפשרות לנוע בתוך טבלאות :

| פעולה |צירוף |תיאור|
|---|---|---|
|מעבר לעמודה הקודמת |Alt+control+חץ שמאלה |העברת סמן המערכת לעמודה הקודמת באותה השורה|
|מעבר לעמודה הבאה |Alt+control+חץ ימינה |העברת סמן המערכת לעמודה הבאה באותה השורה|
|מעבר לשורה הקודמת |Alt+control+חץ מעלה |העברת סמן המערכת לשורה הקודמת באותה העמודה|
|מעבר לשורה הבאה |Alt+control+חץ מטה |העברת סמן המערכת לשורה הבאה באותה העמודה|

<!-- KC:endInclude -->

### ניווט לפי אובייקטים {#ObjectNavigation}

רוב הזמן, תעבדו עם יישומים המעבירים את [הפוקוס](#SystemFocus) ואת [סמן המערכת](#SystemCaret) ממקום למקום.
במצבים מסוימים תרצו לקבל תמונה לגבי היישום שבפוקוס או לגבי מערכת ההפעלה מבלי להזיז את הפוקוס או את סמן המקלדת. 
כמו כן, ייתכן שתרצו להפעיל [אובייקטים](#Objects) שסמן המקלדת לא יכול להגיע אליהם. 
הניווט לפי אובייקטים יאפשר לכם לבצע משימה זו. 

הניווט לפי אובייקטים מאפשר לנוע בין [האובייקטים השונים](#Objects) ולקבל מידע אודותיהם.
בעת הניווט, NVDA תספק מידע בדומה למה שקורה בעת ניווט לפי הפוקוס.
כדי לקבל תמונה כללית על מה שקורה על המסך, מומלץ לעבור למצב [סקירה](#ScreenReview).

במקום לעבור מאובייקט פרטני לאובייקט השני,תקבל תמונה היררכית של מה שמופיע על המסך. 
פירוש הדבר שעליכם להיכנס לאובייקטים פנימיים יותר כשתגיעו אליהם כדי לקבל מידע אודותיהם. 
לדוגמה, לגבי רשימה הכוללת פריטים, תצטרכו להכנס פנימה לתוך פריטים אלה כדי לבחון אותם. 
אם הגעתם לפריט מסוים ברשימה, הוראת מעבר קדימה או אחורה תציג את הפריט הבא או הקודם בהתאמה מתוך הרשימה.
המעבר לאובייקט המכיל פריטי רשימה תביא להצגת הרשימה. באותו רגע, תוכלו לעבור לאובייקטים אחרים מחוץ לרשימה המדוברת.
באופן דומה, סרגלי כלים הם אובייקט המכיל פקדים פנימיים יותר, 
כדי לבחון אותם, עליכם להכנס פנימה לסרגל הכלים.

האובייקט המוצג כעת נקרא אובייקט הניווט. 
כשהניווט מגיע לאובייקט, ניתן לקבל מידע לגביו באמצעות [פקודות סריקת הטקסט](ReviewingText) במצב [סריקת מסך](#ObjectReview). 
סמן הסריקה זז בדרך כלל בתיאום עם הפוקוס אך ניתן להפוך אפשרות זו לפעילה או לא פעילה.

כברירת מחדל, סרגל הברייל עוקב גם הוא אחר [הפוקוס](#SystemFocus) ואחר [סמן המקלדת](#SystemCaret) ולא אחר הניווט או סמן הסריקה. 
אם ברצונכם להצמיד את סרגל הברייל לניווט או לסריקה, עליך להגדיר זאת בפירוש [בתפריט](#BrailleTether) review.

כדי לנווט בין אובייקטים, יש להשתמש בפקודות הבאות :

<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |מחווה |תיאור|
|---|---|---|---|---|
|הקראת אובייקט |NVDA+numpad5 |NVDA+shift+o |ללא |הקראת תוכן האובייקט שהניווט עליו. לחיצה פעמיים : איות, לחיצה שלוש פעמים : הכנסת הטקסט לזיכרון הזמני.|
|מעבר לאובייקט כוללני יותר |NVDA+numpad8 |NVDA+shift+חץ למעלה |מחווה כלפי מעל (מצב אובייקטים) |העברה לאובייקט הכולל את האובייקט שהניווט עליו כרגע|
|מעבר לאובייקט הקודם |NVDA+numpad4 |NVDA+shift+חץ שמאלה |החלקה שמאלה (מצב אובייקטים) |מעבר לאובייקט הקודם לאובייקט שהניווט עומד עליו|
|מעבר לאובייקט הבא |NVDA+numpad6 |NVDA+shift+חץ ימינה |החלקה שמאלה (מצב אובייקטים) |מעבר לאובייקט הבא אחרי האובייקט שהניווט עומד עליו|
|מעבר לאובייקט הפנימי הראשון |NVDA+numpad2 |NVDA+shift+חץ למטה |החלקה מטה |מעבר אל האובייקט הראשון שבתוך האובייקט שהניווט עליו|
|מעבר לאובייקט שבפוקוס |NVDA+numpadMinus |NVDA+backspace |ללא |מעביר את הניווט לאובייקט שבפוקוס וממקם את הסמן במקום שסמן המקלדת מצביע עליו, אי הוא ניתן לאיתור|
|הפעלת אובייקט |NVDA+numpadEnter |NVDA+enter |הקשה כפולה |מפעיל את האובייקט המוצג (זהה לקליק עכבר או ללחיצה על מקש הרווח כשהאובייקט בפוקוס)|
|העברת הפוקוס או סמן המקלדת למקום סמן הסריקה |NVDA+shift+numpadMinus |NVDA+shift+backspace |ללא |לחיצה פעם אחת : העברת הפוקוס למקום סמן הסריקה, לחיצה פעמיים : העברת סמן המקלדת לאותו מקום|
|הקראת מיקום סמן הסריקה |NVDA+numpadDelete |NVDA+delete |ללא |מקריא מידע אודות מיקומו של הטקסט או האובייקט שמתחת לסמן הסריקה, לדוגמה אחוז ההתקדמות בתוך מסמך, או המרחק מהגבול התחתון של החלון או המסך. לחיצה פעמיים עשויה לספק מידע נוסף|

<!-- KC:endInclude -->

הערה : כדי שפקודות כרית המספרים תפעלנה כראוי, מקש NumLock  צריך להיות לא פעיל.

### סריקת הטקסט {#toc36}

NVDA מאפשרת סריקה של הטקסט שעל [המסך](#ScreenReview) ,  של תוכנו של[המסמך שבפוקוס](#DocumentReview) וכן של המלל של ה[אובייקט הנוכחי](#ObjectReview) , ברמת התווים, המילים והשורות.
תכונה זו יעילה בעיקר במקומות שבהם אין [סמן מקלדת](#SystemCaret). כגון מסך הפקודות של מערכת ההפעלה.
שיטה זו מאפשרת גם לעבור על המלל של הודעה ארוכה המלווה פתיחת תיבת דו-שיח.

התנועה לאורך המסך אינה מביאה לשינוי במיקומו של סמן המקלדת.  לכן, ניתן לחזור בקלות לנקודה שבה מתבצעת עריכת המלל.
לעומת זאת, כל תזוזה של סמן המקלדת מביאה לתנועה במקביל של סמן הסריקה. 
ניתן להפוך תכונה זו לפעילה או לא פעילה. #SystemFocus]  ואחר [סמן המקלדת 

באשר לסרגל הברייל, הוא עוקב כברירת מחדל אחר [הפוקוס#SystemFocus]  ואחר [סמן המקלדת](#SystemCaret) ולא אחר הניווט או הסריקה.
כדי להשיג תוצאה זו, עליכם לכוון את הגדרות [הצמדת הברייל](#BrailleTether) review.

להלן פקודות סריקת המסך :
<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |מחווה |תיאור|
|---|---|---|---|---|
|מעבר לשורת הסריקה הראשונה |shift+numpad7 |NVDA+control+home |ללא |העברת סמן הסריקה לשורת הטקסט הראשונה|
|מעבר לשורת הסריקה הקודמת |numpad7 |NVDA+חץ מעלה |החלקה מעלה (במצב טקסט) |העברת סמן הסריקה לשורת הטקסט העליונה יותר|
|הקראת שורת הסריקה הנוכחית |numpad8 |NVDA+shift+. |ללא |הקראת השורה שסמן הסריקה עומד עליו כרגע. לחיצה פעמיים : איות, לחיצה שלוש פעמים : איות במלל.|
|מעבר לשורת הסריקה הבאה |numpad9 |NVDA+חץ מטה |החלקה מטה (במצב טקסט) |העברת סמן הסריקה לשורת הטקסט התחתונה יותר|
|מעבר לשורה האחרונה |shift+numpad9 |NVDA+control+end |ללא |מעביר את סמן הסריקה לשורה התחתונה ביותר|
|מעבר למילה הקודמת |numpad4 |NVDA+control+חץ שמאל |החלקת שתי אצבעות שמאלה |מעביר את הסמן לתחילת המילה הקודמת|
|הקראת המילה הנוכחית |numpad5 |NVDA+control+. |ללא |הקראת המילה שסמן הסריקה עומד עליה. לחיצה פעמיים : איות, לחיצה שלוש פעמים : איות במלל.|
|מעבר למילה הבאה |numpad6 |NVDA+control+חץ ימין |החלקה בשתי אצבעות ימינה |העברת סמן הסריקה לתחילת המילה הבאה|
|מעבר לתחילת השורה |shift+numpad1 |NVDA+home |ללא |מעביר את סמן הסריקה לתחילת השורה הנוכחית|
|מעבר לתו הקודם |numpad1 |NVDA+חץ שמאל |החלקה שמאלה |מעביר את סמן הסריקה תו אחד שמאלה|
|הקראת התו הנוכחי |numpad2 |NVDA+. |הקראת התו שסמן הסריקה עומד עליו. לחיצה פעמיים : מלל שם התו, לחיצה שלוש פעמים : ערך יוניקוד כמספר עשרוני והקסא-דצימאלי ||
|מעבר לתו הבא |numpad3 |NVDA+חץ ימינה |החלקה ימינה |מעביר את סמן הסריקה לתו הבא|
|מעבר לתו האחרון בשורה |shift+numpad3 |NVDA+end |ללא |מעביר את סמן הסריקה לתו האחרון בשורה|
|הקראת הכל |numpadPlus |NVDA+shift+a |החלקה מטה בשלוש אצבעות |הקראה ממקום סמן הסריקה ועד לסוף המסך. תוך כדי הזזת הסמן|
|בחר ממקום סמן הסריקה |NVDA+F9 |NVDA+F9 |ללא |מתחיל סימון והעתקה ממקום סמן הסריקה. התהליך יימשך עד שתודיע לNVDA על נקודת הסיום.|
|העתקה לזיכרון הזמני |NVDA+f10 |NVDA+f10 |ללא |בלחיצה הראשונה, הטקסט ממקום הסמן ועד למקום הנוכחי יסומן. בלחיצה שנייה, הטקסט המסומן יועתק לזיכרון הזמני.|
|הקראת עיצוב הטקסט |NVDA+F |NVDA+F |ללא |מציג את העיצוב של הטקסט במקום סמן הסריקה. לחיצה פעמיים : הצגת העיצוב במבנה של מצב הגלישה.|

<!-- KC:endInclude -->

הערה : כדי שפקודות כרית המספרים תפעלנה כראוי, מקש NumLock  צריך להיות לא פעיל.

ישנה שיטה המאפשרת לזכור בקלות את פקודות הסריקה במקלדת המחשב הנייח : ניתן לראותן כשייכות לרשת של שלוש על שלוש.  מלמעלה למטה יופיעו פקודות השורות, המילים והתווים. משמאל לימין יופיעו "הקודם", "הנוכחי" ו"הבא". 
התמונה נראית כך :

|שורה קודמת |שורה נוכחית |שורה הבאה|
|מילה קודמת |מילה נוכחית |מילה הבאה|
|תו קודם |תו נוכחי |תו הבא|

### מצבי הסריקה {#ReviewModes}

[פקודות הסריקה](#ReviewingText)  של NVDA מאפשרות לבחון את הטקסט של האובייקטים השונים הנסרקים, של המסמכים ושל המסך בכלל, וזאת על-פי מצב הסריקה שנבחר.
המונח "מצבי סריקה"  מחליף את הביטוי הישן "סריקה שטוחה" שהיה פעם בשימוש ב-NVDA.

הפקודות הבאות מבצעות את המעבר משיטה לשיטה :
<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |מחווה |תיאור|
|---|---|---|---|---|
|מצב סריקה הבא |NVDA+numpad7 |NVDA+pageUp |החלקה מעלה בשתי אצבעות |קביעת המצב הבא הזמין|
|מצב סריקה הקודם |NVDA+numpad1 |NVDA+pageDown |החלקה מטה בשתי אצבעות |קביעת המצב הקודם הזמין|

<!-- KC:endInclude -->

#### סריקה לעפי אובייקטים {#ObjectReview}

במצב סריקה לפי אובייקטים, ניתן רק לסרוק את הרכיבים המוצגים על ידי [מנגנון הניווט](#ObjectNavigation).
עבור שדות הניתנים לעריכה או פקדים אחרים המכילים מלל,  תוכן מילולי זה הוא שיוצג.
עבור אובייקטים אחרים, ייתכן כי המלל המוצג יהיה שם האובייקט או ערכו.

#### מצב מסמך {#DocumentReview}

כש[סמן הניווט](#ObjectNavigation)  נמצא בתוך מסמך הנקרא במצב גלישה (כגון, דף אינטרנט או חלון מורכב אחר, למשל מסמך של Lotus Symphony(  ניתן לעבור למצב סריקת מסמך.
מצב סריקת המסמכים מאפשר קריאה רציפה של המסמכים מבלי לשנות את מקום הפוקוס.

בעת מעבר ממצב סריקת אובייקטים למצב סריקת מסמכים,  סמן הסריקה מתמקם במקום של סמן הניווט.
בעת הזזת סמן הסריקה, סמן הניווט נע אוטומטית בין האובייקטים יחד עם סמן הסריקה.  

NVDA תעבור אוטומטית ממצב סריקת האובייקטים למצב סריקת המסמכים ברגע שסמן הסריקה יגיע למסמכים הנקראים במצב גלישה.

#### סריקת המסך {#ScreenReview}

מצב סריקת המסך מאפשר t, קריאת הטקסט לפי סדר הופעתו על המסך. 
מצב זה דומה לתפקודם של קוראי מסך אחרים המאפשרים סריקת מסך או הצמדה לעכבר תחת מערכת ההפעלה Windows

בעת מעבר למצב סריקת מסך, סמן הסריקה מתמקם במקום סמן [הניווט](ObjectNavigation).
בתגובה לפקודות סריקת המסך,  סמן הניווט מתמקם אוטומטית על הנקודה שסמן הסריקה מצביע עליה בכל רגע. 

יש לשים לב לכך שלא תמיד NVDA מסוגלת להקריא את תוכנם של אובייקטים המשתייכים ליישומים חדישים, וזאת עקב המצב המתפתח של טכנולוגיות ציור המלל על המסך.

### ניווט עכבר {#toc41}

כברירת מחדל, NVDA מקריאה את מלל האובייקט שסמן העכבר מצביע עליו בכל רגע.  
במידת האפשר, הקריאה תתבצע על בסיס של פסקה אך ישנם פקדים שניתן לקרוא אותם רק שורה אחר שורה.

אפשר להגדיר את NVDA כך שהיא תקריא גם את סוג [האובייקטים](#Objects)  תוך כדי תנועה, כגון "רשימה", "כפתור",  וכו'.
תכונה זו מועילה בעיקר למשתמשי מחשב עם עיוורון מוחלט אם הקראת תוכן האובייקטים אינה מספקת.

NVDA מאפשרת לקבל מושג על מיקומו של העכבר ביחס למימדי המסך בעזרת השמעת צלילים מיוחדים.  
כל שמיקומו של העכבר גבוה ביחס למסך, כך יושמע צליל גבוה יותר.  
אם מותקנים על המחשב רמקולים או אוזניות סטריאופוניות, הצליל יישמע מצד שמאל או ימין בהתאמה על פי מיקומו האופקי של העכבר. 

תכונות אלה אינן מוגדרות כברירת מחדל של NVDA. 
אם ברצונך להפעיל אותן,  ניתן לעשות זאת בתפריט [הגדרות עכברים מותקנים על המחשב](#MouseSettings) שמופיעות תחת תפריט ההעדפות.

השימוש בטכניקות העכבר דורש חיבור של עכבר אמיתי או של מסך מגע. למרות זאת, NVDA מספקת מספר פקודות מקלדת השולטות על מכשיר זה.
<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |תיאור|
|---|---|---|---|
|קליק שמאל |numpad/ |NVDA+[ סוגר מרובע ימני |קליק.  לחיצה פעמיים מבצעת קליק כפול|
|קליק שמאל לחוץ |shift+numpad/ |NVDA+control+[ סוגר מרובע שמאלי |נעילה ושחרור קליק שמאל. במצב נעול, ניתן לבצע גרירה על ידי הזזת העכבר או הפעלת פקודת עכבר כלשהי|
|קליק ימין |numpad* |NVDA+] סוגר מרובע שמאלי |קליק ימין|
|קליק ימין לחוץ |shift+numpad* |NVDA+control+] סוגר מרובע שמאלי |נעילה ושחרור קליק ימין. במצב נעול, ניתן לבצע גרירה על ידי הזזת העכבר או הפעלת פקודת עכבר כלשהי|
|העברת  העכבר לסימן הניווט |NVDA+nupad/ |NVDA+shift+m |העברת העכבר למקום סמן הניווט או הסריקה|
|העברת סמן הניווט למקום העכבר |NVDA+numpad* |NVDA+shift+n |העברת סמן הניווט לאובייקט שהעכבר מצביע עליו|

<!-- KC:endInclude -->

## מצב גלישה {#BrowseMode}

מצב הגלישה של NVDA מאפשר קריאה של מסמכים מורכבים המוגדרים לקריאה בלבד, כגון דפי אינטרנט. מסמכים אלה מטופלים על-ידי תוכנות כמו :
Mozilla Firefox, Microsoft Internet Explorer, Mozilla Thunderbird, Microsoft Outlook, Google Chrome, Adobe Reader Adobe Flash.
ניתן להפעיל את מצב הגלישה גם לצורך קריאה של מסמכי Word.

במצב גלישה, ניתן לנוע בתוך מסמך בצורה שטוחה, בעזרת חיצי הכיוון בדומה לניווט בתוך מסמך פשוט.
במצב זה פועלות כל פקודות הניווט בעזרת [סמן המקלדת](#SystemCaret)   לרבות פקודות הקראת העיצוב,  הניווט בתוך טבלאות ועוד. 
נוסף על כך, המערכת מודיעה על קיומם של קישורים, כותרות, וכדומה, בתוכן המסמך תוך כדי תנועה.

לעתים מתעורר הצורך לתקשר עם אובייקטים אלה תוך כדי קריאה.
לדוגמה,  יש למלא שדות בתוך טפסים או להקיש על תווים מסויימים כדי לנוע בתוך רשימה.
הדרך הנוחה ביותר לעשות זאת היא באמצעות מעבר למצב פוקוס, שבו כל הקשה מועברת לתכנה הפעילה כעת. 
NVDA תעבור אוטומטית למצב פוקוס בעת הגעת הסמן לשדה הדורש הכנסת טקסט, בין אם כתוצאה מפעולת ניווט ובין אם לאחר לחיצה על מקש Tab
NVDA תחזור לפעול במצב גלישה לאחר לחיצה על  Tab או במקרה שהסמן יגיע לפקד שאינו דורש הכנסת טקסט.
ניתן ללחוץ על מקש Enter  או על מקש הרווח כדי לעבור למצב הפוקוס לצורך הקלדת מלל.
לחיצה על מקש  Escape  תפעיל מחדש את מצב הגלישה.
באפשרותך לכפות על המערכת להכנס למצב הפוקוס ולא לחזור למצב גלישה.

<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|מעבר בין פוקוס לגלישה |NVDA+רווח |עובר ממצב פוקוס למצב גלישה ובחזרה|
|יציאה ממצב פוקוס |Escape |מעבר ממצב הפוקוס חזרה למצב הגלישה|
|ריענון מסמך |NVDA+F5 |טוען את המסמך מחדש. ניתן לשימוש אם נראה כי חסר מידע. לא זמין ב Word וב Outlook|
|חיפוש |NVDA+control+f |פותח תיבת דו-שיח המאפשרת חיפוש מחרוזת בתוך המסמך|
|חיפוש חוזר |NVDA+F3 |מבצע חיפוש נוסף של אותה מחרוזת במסמך|
|חיפוש אחורה |NVDA+shift+f3 |מבצע חיפוש של המחרוזת למעלה יותר במסמך|
|תיאור ארוך |NVDA+D |מקריא הסבר ארוך אודות האובייקט שהסמן עומד עליו, אם קיים כזה|

<!-- KC:endInclude -->

### ניווט בעזרת תו אחד {#toc43}

במצב גלישה NVDA מאפשרת שימוש במספר מקשי קיצור לצורך ניווט מהיר בתוך המסמכים.
לא כל הפעולות האלה נתמכות בכל מסמך.

<!-- KC:beginInclude -->
לחיצה על תו בודד מאפשרת מעבר לאובייקט הבא העונה על הדרישה. בצירוף עם מקש  Shift הסמן יעבור לאובייקט הקודם המתאים.

* H: כותרת
* l: רשימה
* i: פריט ברשימה
* t: טבלה
* k: קישור
* n: טקסט שאינו קישור
* f: שדה טופס
* U :  קישור שלא הופעל בעבר
* v: קישור שהופעל בעבר
* e: תיבת עריכה
* b: כפתור
* x: תיבת סימון
* c: תיבה משולבת
* r: כפתור בחירה
* q: טקסט בגרשיים
* s: מפריד
* m: מסגרת
* g: תמונה
* d: ציון דרך
* o: אובייקט מוטמע
* 1 עד 6 מעבר לכותרת רמה 1 עד 6 בהתאמה
* a: הערה (תוספת או שינוי שבוצע במסמך)

כדי לעבור לתחילת או לסופו של אובייקט המכיל פריטים, כגון רשימות וטבלאות, אפשר להשתמש בפקודות הבאות :

| שם |צירוף |תיאור|
|---|---|---|
|מעבר לתחילת האובייקט |Shift+פסיק |מעביר את הסמן לחילת האובייקט המכיל פריטים בתוכו, כגון רשימה או טבלה|
|מעבר לסוף אובייקט |פסיק |מעביר את הסמן אל מעבר לסוף האובייקט|

<!-- KC:endInclude -->
מספר יישומים, כגון ,Gmail Twitter Facebook מאפשרים בעצמם את השימוש בקיצורים בני תו אחד. 
אם ברצונכם להשתמש בקיצורים אלה מבלי לצאת ממצב הגלישה,  באפשרותכם לבטל זמנית את פעולותיו של תו אחד של NVDA
<!-- KC:beginInclude -->
כדי לבטל את פעולות של תו אחד שבשימוש NVDA יש להקיש את צירוף המקשים NVDA+shift+רווח.
<!-- KC:endInclude -->

### רשימת הרכיבים {#toc44}

מנגנון רשימת הרכיבים מאפשר לקבל הקבצה של הרכיבים מסוג אחד המופיעים במסמך. 
לדוגמה, בדפי אינטרנט,  ניתן לקבל רשימה של כל הקישורים, של הכותרות או של ציוני הדרך.
בעזרת כפתורי בחירה, ניתן לבחור את סוג הרכיב הרצוי.
כמו כן, תיבת הדו-שיח כוללת תיבת עריכה המאפשרת להקליד טקסט לחיפוש של רכיב מסוים בתוך הדף.
לאחר בחירת הרכיב הרצוי,  יופיעו כפתורים שיסייעו לכם לעבור לרכיב או להפעיל אותו.
<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|רשימת רכיבים במצב גלישה |NVDA+F7 |מציג רשימה של הרכיבים הקיימים במסמך|

<!-- KC:endInclude -->

### אובייקטים מוטמעים {#toc45}

ישנם דפים המכילים לפעמים תוכן עשיר המבוסס על טכנולוגיות מתקדמות
כמו Adobe Flash או Sun Java, לעתים, הדף עשוי להכיל אפילו תיבות דו-שיח ויישומים פנימיים אחרים.
במקרה זה, מצב הגלישה יודיע על הימצאות "אובייקט מוטמע", "תיבת דו-שיח" או "יישום" בהתאמה.
אם רכיבים אלה בעלי נגישות, תוכל לסרוק אותם בעזרת מקש ה-Tab כנהוג בכל יישום אחר.
פקודה יחודית מאפשרת לחזור לדף המקורי המכיל את האובייקט המוטמע.
<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|חזרה למסמך במצב גלישה |NVDA+control+רווח |מעביר את הפוקוס בחזרה למסמך המכיל את האובייקט המוטמע ועובר למצב הגלישה|

<!-- KC:endInclude -->

## הקראת תוכן מתמטי {#toc46}

NVDA מסוגלת להקריא תוכן מתמטי ואף לעבור בין רכיבי נוסחאות בעזרת מנגנון MathPlayer 4 של חברת Design Science
לשם כך, יש צורך בהתקנת MathPlayer 4 על המחשב. 
ניתן להוריד את MathPlayer 4 בחינם מהכתובת : https://www.dessci.com/en/products/mathplayer/

NVDA תומכת בפיענוח הנושאים הבאים :

* MathML בתוכנות  Mozilla Firefox ו-  Microsoft Internet Explorer.
* Design Science MathType   בתוכנות Microsoft Word ו- PowerPoint. יש לדאוג להתקנת MathType  של Design Science  על המחשב, כשהגרסה הנסיונית מספיקה.
* MathML בתכנת Adobe Reader. שימו לב כי שיטה זו אינה עדיין תקן רשמי ואין כיום תכנה המסוגלת ליצור תוכן דומה לזה.

תוך כדי עבודה במסמך, NVDA תקריא כל רכיב מתמטי הנתמך על-ידי התכנה בעת הגעת הסמן אליו.
אם ברשותכם צג ברייל, המידע יוצג גם עליו.

### ניווט אינטראקטיבי {#toc47}

אם אתם עובדים בעיקר בדיבור עם NVDA תעדיפו לשמוע את פירוט הרכיבים המתמטיים על פני הקראת כל המשפט.  

במצב גלישה, ניתן לעשות זאת על-ידי ניווט עד למקום הביטוי ולחיצה על Enter

שלא במצב גלישה :

1. השתמשו בסמן הסריקה כדי לעבור לתוכן הביטוי המתמטי.
כברירת מחדל, סמן הסריקה עוקב אחר סמן המקלדת, כך שניתן להגיע בקלות  למקום הרצוי בעזרת חיצי המקלדת.
1. לאחר מכן, השתמשו בפקודה הבאה :

<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|עבודה עם ביטויים מתמאטיים |NVDA+alt+m |התחלת העבודה מול ביטויים מתמאטיים|

<!-- KC:endInclude -->

בשלב זה, ניתן להפעיל פקודות MathPlayer כגון חצי הכיוון כדי לנוע בתוך הביטוי.
לדוגמה, אפשר  לעבור בין רכיבי הביטוי על-ידי לחיצה על חץ ימינה או חץ שמאלה ולרדת לרמת תווי הביטוי באמצעות החצים מעלה ומטה.
נא לעיין במסמך ההדרכה של MathPlayer למידע נוסף.

לחיצה על מקש Escape  מחזירה את המערכת לגוף המסמך.

## מאפיני יישומים מיוחדים {#toc48}

NVDA  מתאפיינת במספר תכונות העשויות להקל את השימוש ביישומים מסוימים ולאפשר גישה למנגנונים שאינם נתמכים על-ידי קוראי מסך אחרים.

### Microsoft Word {#toc49}
#### זיהוי אוטומטי של כותרות שורות ועמודות {#toc50}

NVDA מסוגלת להקריא באופן אוטומטי את כותרות השורות והעמודות שהיא מזהה בטבלאות של Microsoft Word.  
כדי שהפעולה תתבצע, יש להפוך לזמינה את אפשרות ההקראה האוטומטית של כותרות שורות ועמודות בתיבת הדו-שיח, המתייחסת לעיצוב המסמכים.
יתר על כן, על NVDA לדעת מהן השורות והעמודות המכילות את הכותרות.
לאחר המעבר לתא הראשון המכיל כותרת שורה או עמודה, ניתן להפעיל את הפקודות הבאות :
<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|קביעת כותרת העמודות |NVDA+shift+C |לחיצה פעם אחת: הוראה לקבוע את השורה הנוכחית כשורה המכילה את כותרות העמודות. הכותרת תוקרא יחד עם תוכן התא בעת מעבר לעמודה אחרת. לחיצה פעמיים : ביטול קביעת כותרות העמודות.|
|קביעת כותרת השורות |NVDA+shift+R |לחיצה פעם אחת: הוראה לקבוע את העמודה הנוכחית כעמודה המכילה את כותרות השורות. הכותרת תוקרא יחד עם תוכן התא בעת מעבר לשורה אחרת. לחיצה פעמיים : ביטול קביעת כותרות השורות.|

<!-- KC:endInclude -->
הגדרות אלה תישמרנה בתוך המסמך כסימניות הניתנות לזיהוי גם בקוראי מסך אחרים, כגון JAWS
פירוש הדבר שמשתמשים בקורא מסך אחר יוכלו לקבל חיווי מידי על כותרות השורות והעמודות בעת קריאת המסמך.

#### מצב גלישה עבור }}Microsoft Word {#toc51}

בדומה להתנהגות של NVDA בדפי אינטרנט, ניתן להכנס למצב גלישה גם בתכנת Microsoft Word ולקבל חיווי  בעזרת פקודות תו אחד ורשימת אובייקטים.
<!-- KC:beginInclude -->
בMicrosoft Word הכניסה למצב גלישה והיציאה ממנו מתבצעות על-ידי לחיצה על NVDA+רווח
<!-- KC:endInclude -->
למידע נוסף אודות מצב הגלישה ופקודות תו אחד, יש לעיין בפרק על [מצב הגלישה](#BrowseMode).

##### רשימת הרכיבים {#toc52}

<!-- KC:beginInclude -->
ב Microsoft Word  הצגת רשימת הרכיבים וביטולה נעשית באמצעות הצירוף NVDA+F7
<!-- KC:endInclude -->
ניתן לקבל רשימת כותרות, קישורים והערות, כולל שינויים שבוצעו במסמך.

#### הקראת הערות {#toc53}

<!-- KC:beginInclude -->
כדי להקריא הערה השייכת למילה שבפוקוס, יש ללחוץ על הצירוף NVDA+alt+c.
<!-- KC:endInclude -->
ניתן לקבל רשימה של כל ההערות בתיבת הדו-שיח המתייחסת לרשימת האובייקטים במסמך.

### Microsoft Excel {#toc54}
#### זיהוי אוטומטי של כותרות שורות ועמודות {#toc55}

NVDA מסוגלת להקריא אוטומטית את כותרות השורות והעמודות שהיא מזהה בגליונות של Microsoft  Excel.
כדי שהפעולה תתבצע, יש להפוך לזמינה את אפשרות ההקראה האוטומטית של כותרות שורות ועמודות בתיבת הדו-שיח  המתייחסת לעיצוב המסמכים.
יתר על כן, על NVDA לדעת מהן השורות והעמודות המכילות את הכותרות.
לאחר המעבר לתא הראשון המכיל כותרת שורה או עמודה, ניתן להפעיל את הפקודות הבאות :
<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|קביעת כותרת העמודות |NVDA+shift+C |לחיצה פעם אחת: הוראה לקבוע את השורה הנוכחית כשורה המכילה את כותרות העמודות. הכותרת תוקרא יחד עם תוכן התא בעת מעבר לעמודה אחרת. לחיצה פעמיים : ביטול קביעת כותרות העמודות.|
|קביעת כותרת השורות |NVDA+shift+R |לחיצה פעם אחת: הוראה לקבוע את העמודה הנוכחית כעמודה המכילה את כותרות השורות. הכותרת תוקרא יחד עם תוכן התא בעת מעבר לשורה אחרת. לחיצה פעמיים : ביטול קביעת כותרות השורות.|

<!-- KC:endInclude -->
הגדרות אלה תישמרנה בתוך המסמך כסימניות מסוג Range הניתנות לזיהוי גם בקוראי מסך אחרים, כגון JAWS.
פירוש הדבר שמשתמשים בקורא מסך אחר יוכלו לקבל חיווי מידי על כותרות השורות והעמודות בעת קריאת הגליון.

#### רשימת הרכיבים {#toc56}

בדומה למצב של דפי האינטרנט, NVDA מסוגלת להציג רשימות של האובייקטים השונים המופיעים בגליונות של  Excel.
<!-- KC:beginInclude -->
ב Microsoft Excel  הצגת רשימת הרכיבים וביטולה נעשית על ידי הצירוף NVDA+F7.
<!-- KC:endInclude -->
להלן רשימת האובייקטים שניתן להציג עבורם רשימה כוללת :

* תרשימים: רשימת כל התרשימים בגליון הפעיל
בחירת הגליון ולחיצה על  Enter  או לחיצה על הכפתור "עבור אל" יביאו להצגת התרשים שנבחר וניתן יהיה לנווט בתוכו בעזרת חיצי הכיוון.
* הערות : רשימה זו מציגה את כל התאים המכילים הערות. 
תוכן התא והקואורדינטות שלו יוקראו יחד עם ההערה.
לחיצה על Enter  או על כפתור "עבור אל" תציב את הפוקוס על התא שנבחר.
* נוסחאות: רשימה זו תציג את כל התאים המכילים נוסחה.
תוכן התא והקואורדינטות שלו יוקראו יחד עם הנוסחה.
לחיצה על Enter  או על כפתור "עבור אל" תשים את הפוקוס על התא שנבחר.
* גליונות: רשימה זו מציגה את כל הגליונות הכלולים בחוברת העבודה.
ניתן לשנות את שמות הגליונות בלחיצה על מקש F2 
לחיצה על Enter  או על כפתור "עבור אל" תשים את הפוקוס על הגליון שנבחר.
* שדות טופס: רשימה זו מציגה את כל שדות הטופס הכלולים בגליון הפעיל. 
עבור כל שדה, מופיעות הקואורדינטות שלו בנוסף למלל החלופי שמלווה אותו.
לחיצה על Enter  או על כפתור "עבור אל" תציב את הפוקוס על שדה טופס זה במצב גלישה.

#### הקראת הערות {#toc57}

<!-- KC:beginInclude -->
כדי להקריא הערה השייכת לתא שבפוקוס, יש להקיש את צירוף המקשים NVDA+alt+c.
<!-- KC:endInclude -->
ניתן לקבל רשימה של כל ההערות בתיבת הדו-שיח המתייחסת לרשימת ההערות בגליון הנוכחי.

#### הקראת תאים מוגנים {#toc58}

אם הגליון מוגן, לא ניתן להעביר את הפוקוס אל תוך התאים שבו לצורך עריכה. 
<!-- KC:beginInclude -->
כדי לעקוף את הבעייה, מומלץ לעבור למצב גלישה על ידי הקשת צירוף המקשים NVDA+רווח, ולנווט בגליון בעזרת החיצים.
<!-- KC:endInclude -->

#### שדות טופס {#toc59}

גליונות Excel  מכילים לעיתים שדות טופס למילוי. 
ניתן להגיע לשדות הטופס מתוך רשימת האובייקטים או על ידי הקשה על האות F או צירוף המקשים  Shift+F  במצב גלישה.
אז ניתן להקיש על Enter  או על מקש הרווח כדי לאפשר עריכה או לעשות זאת מתוך מצב הפוקוס, בהתאם לצורך.
למידע נוסף, יש לעיין בפרק [מצב הגלישה](#BrowseMode).

### Microsoft PowerPoint {#toc60}

<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|מיתוג הערות הקריין |control+shift+s |כששקופית נפתחת על המסך,  צירוף זה יעביר את ההקראה מההערות לתוכן ובחזרה. פעולה זו חלה על ההקראות של NVDA ולא על מה שמוצג על המסך.|

<!-- KC:endInclude -->

### foobar2000 {#toc61}

<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|זמן נותר |control+shift+r |הקראת הזמן הנותר עבור הקטע המתנגן כרגע.|

<!-- KC:endInclude -->

הקראת הזמן הנותר אפשרית רק עם הגדרת ברירת המחדל של שורת המצב של תוכנת Foobar

### Miranda IM {#toc62}

<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|הקראת מסרים אחרונים |NVDA+control+1-4 |המספר שבצירוף מצביע על אחד מארבעת המסרים האחרונים שהתקבלו|

<!-- KC:endInclude -->

### Poedit {#toc63}

<!-- KC:beginInclude -->

| פעולה |צירוף |תיאור|
|---|---|---|
|הקראת חלון ההערות |control+shift+c |הקראת כל הערה שהיא|
|הקראת הערה למתרגמים |control+shift+a |הקראה למתרגמים כלשהי|

<!-- KC:endInclude -->

### Skype {#toc64}

<!-- KC:beginInclude -->
כאשר נמצאים בשיחה:

| פעולה |צירוף |תיאור|
|---|---|---|
|הודעות אחרונות |control+1-0 |לפי המספר שהוקש בצירוף, ההקראה תחול על ההודעה לפי סדר הופעתה|

<!-- KC:endInclude -->

### Kindle למחשב האישי {#toc65}

תכנת NVDA תומכת בקריאה וניווט בספרים בעזרת "קינדל" למחשב. 
פונקציונליות זו זמינה רק בספרי קינדל אשר תומכים ב- "עיבוד משופר", שבו הנכם יכולים לבדוק את פרטי העמוד עבור הספר.

מצב עיון משמש לקריאת ספרים.
היא מופעלת באופן אוטומטי כאשר הנכם פותחים ספר או מתמקדים באזור בספר.
הדף יופעל באופן אוטומטי על פי צורך כאשר הנכם מזיזים את הסמן או בשימוש בפקודה "אמור הכל".
<!-- KC:beginInclude -->
ניתן לעבור ידנית לדף הבא עם מקש PageDown ולעבור לדף הקודם עם מקש PageUp.
<!-- KC:endInclude -->

ניווט בדף יחיד נתמך עבור קישורים וגרפיקה, אבל רק בתוך הדף הנוכחי.
ניווט על ידי קישורים כולל גם הערות שוליים.

#### בחירת טקסט {#toc66}

קינדל מאפשר לך לבצע פעולות שונות על טקסט נבחר, לרבות קבלת הגדרה המילונית, הוספת הערות ונקודות מרכזיות, העתקת הטקסט ללוח וחיפוש באינטרנט.
כדי לעשות זאת, בחרו תחילה בטקסט כפי שאתם עושים בדרך כלל במצב עיון; לְמָשָׁל באמצעות Shift ועל מקשי החיצים.
<!-- KC:beginInclude -->
לאחר שבחרת את הטקסט, לחץ על מקש WIN או Shift+f10  להצגת האפשרויות הזמינות עבור עבודה עם הטקסט הנבחר.
<!-- KC:endInclude -->
אם תעשו זאת ללא טקסט נבחר, אפשרויות יוצגו עבור המילה על הסמן.

#### הערות משתמש {#toc67}

ניתן להוסיף הערה לגבי מילה או קטע של טקסט.
כדי לעשות זאת, בחרו תחילה את הטקסט הרלוונטי וגשו לאפשרויות הבחירה כמתואר לעיל.
לאחר מכן, בחרו להוסיף הערה.

בעת הקריאה במצב עיון, NVDA מתייחס להערות אלה כהערות.

כדי להציג, לערוך או למחוק פתק:

1. הזז את סמן הטקסט לפתק המכיל את ההערה.
1. גש לאפשרויות הבחירה כפי שתואר לעיל.
1. בחר ערוך הערה.

## הגדרות NVDA {#toc68}
### העדפות {#toc69}

<!-- KC:settingsSection: || פעולה | מחשב נייח | מחשב נייד | תיאור  | -->
רוב ההגדרות של NVDA  ניתנות לשינוי בתפריט ההעדפות של התפריט הכללי.
בכל תיבת דו-שיח של הגדרות, יש ללחוץ על כפתור האישור כדי שההגדרות יחולו. 
כדי לבטל את השינוי יש ללחוץ על כפתור הביטול או על מקש Escape.
הפרקים הבאים מפרטים מספר קיצורי דרך המאפשרים לבצע שינוי מידי בהגדרות.

קיימות אפשרויות רבות שלא ניתן להגיע אליהן באמצעות מחוות במסך (לדוגמא : הגדרות מקלדת, הגדרות מחוות מסך מגע ועוד).
כדי להכנס ישירות לתפריטים שאין להם קיצורי דרך, עליכם להגדיר [מחוות מגע](#InputGestures)  במסך המתאים.

#### הגדרות כלליות של NVDA (NVDA+control+g) {#toc70}

תיבת דו-שיח של ההגדרות הכלליות נמצאת תחת פריט ההעדפות.
היא כוללת את האפשרויות הבאות :

##### שפה {#toc71}

בתיבה משולבת זו, תוכל לבחור את שפת הממשק של NVDA וכן השפה שבה יוקראו הודעות התכנה.
קיימות אופציות רבות לכך, אולם ברירת המחדל היא שפת מערכת ההפעלה. 
אופציה זו מנחה את NVDA לבחור בשפת ברירת המחדל של  Windows  כשפת הממשק שלה.

שינוי השפה דורש הפעלה מחדש של NVDA.
במקרה של שינוי, NVDA שואלת אם להפעיל את עצמה מחדש.
יש ללחוץ על כפתור "אישור" כדי לבצע פעולה זו.

##### שמירת הגדרות בעת יציאה {#toc72}

תיבת סימון זו קובעת אם ההגדרות של NVDA תישמרנה בעת יציאה מהתכנה.

##### הצגת חלון אפשרויות בעת יציאה מ NVDA {#toc73}

תיבת סימון זו קובעת אם יוצג חלון המפרט מספר אפשרויות בעת יציאה מNVDA.
במצב פעיל, תיבה זו תגרום לNVDA לשאול אם ברצונך לצאת, להפעיל את NVDA מחדש או להפעיל אותה מחדש ללא תוספים.
במצב "לא פעיל", תיבה זו תגרום לNVDA להיסגר מיידית.

##### השמע צלילים בעת כניסה ויציאה {#toc74}

במצב "פעיל", תיבה זו תפעיל השמעת צלילים בעת הפעלת NVDA ובעת סגירתה.

##### רמת דיווח {#toc75}

תיבה משולבת זו קובעת את רמת רישום הדיווח תוך כדי פעולתה של NVDA
בדרך כלל, אין סיבה לגעת בהגדרה זו כל עוד שהמערכת מתפקדת כראוי. 
יש טעם לשנות אותה אם נדרש דיווח נרחב על באג בתכנה.

##### הפעלת NVDA באופן אוטומטי לאחר התחברות לרשת החלונות {#toc76}

אם תיבה זו מסומנת, NVDA תפעל תכף עם עליית המחשב. 
אופציה זו חלה רק על הגרסה המותקנת.

##### הפעלת NVDA  בעת הכניסה לחלון בחירת משתמש. אפשרות זו דורשת זכויות של מנהל על התחנה. {#toc77}

אם אתם מתחברים למחשב בעזרת שם משתמש וסיסמה ותיבה זו מסומנת, NVDA תעלה יחד עם מסך ההתחברות לחלונות.
אופציה זו פעילה אך ורק בגרסה המותקנת על המחשב.

##### השתמש בהגדרות הנוכחיות עבור מסך הפתיחה ועלייה במצב בטוח אופציה זו דורשת זכויות מנהל על התחנה {#toc78}

לחיצה על כפתור זה תביא להעתקת הגדרות NVDA השמורות בתיקית המשתמש לתוך תיקיית המערכת.
כתוצאה מכך, הגדרות אלה יפעלו מעתה גם בחלון ההתחברות לרשת, בחלון בקרת חשבון המשתמש UAC  ובחלונות המוגנים האחרים. כדי להבטיח כי הגדרות המשתמש אכן תופעלנה, דאג לשמור אותן תחילה בלחיצה על הצירוף control+NVDA+c  או דרך תפריט שמירת ההגדרות.
אופציה זו פעילה אך ורק בגרסה המותקנת של NVDA.

##### בדיקה אוטומטית של עדכוני NVDA {#toc79}

אם תיבה זו במצב "פעיל" NVDA תבדוק אוטומטית אם יש עדכונים זמינים לתכנה ותודיע על כך. 
ניתן לבצע את הבדיקה גם דרך התפריט המתאים בתפריט "עזרה".

#### בחירת מנוע דיבור NVDA+control+s) {#toc80}

תפריט בחירת מנוע הדיבור מאפשר להגדיר את המנגנון שבאמצעותו תקריא תכנת  NVDA את הודעותיה.
לאחר בחירת מנוע הדיבור הרצוי, לחיצה על כפתור "אישור" תעלה אותו לזיכרון.
במקרה של שגיאה בעת טעינת מנוע הדיבור, NVDA תודיע על כך ותפעיל את המנוע שהיה בשימוש קודם לכן.

##### מנוע דיבור {#toc81}

תיבה זו מאפשרת בחירה של מנוע הדיבור הרצוי. 

לרשימת מנוע הדיבור הנתמכים, יש לעיין בפרק [מנועי דיבור נתמכים](#SupportedSpeechSynths) section.

ברשימה זו תופיע תמיד אפשרות ההפעלה "ללא" מנוע דיבור.
אופציה זו רלוונטית בעיקר למשתמשים העובדים עם ברייל בלבד או למפתחים המעוניינים לבחון את דיווחי מנוע הדיבור מבלי לשמוע אותו.

##### התקן פלט {#toc82}

תיבה זו מאפשרת בחירה של כרטיס הקול שבאמצעותו תשמיע תכנת NVDA את הודעותיה.

<!-- KC:setting -->

##### מצבי הנמכת השמע {#toc83}

Key: NVDA+shift+d

מערכת ההפעלה Windows 8  והלאה, אופציה זו מאפשרת לקבוע אם צליל השמע של יישומים אחרים יונמך אוטומטית כשתכנת NVDA תקריא מלל כלשהו או כשהיא בכלל תהיה בריצה.

* ללא הנמכה: NVDA לעולם לא תנמיך את עצמת השמע של יישום אחר.
* הנמכת השמע כשתכנת NVDA משמיעה דיבור או צליל: ההנמכה תחול אך ורק כשתכנת NVDA תזדקק להשמעת מלל או צליל. לא כל מנועי הדיבור תומכים באפשרות זו.
* הנמך תמיד: NVDA תנמיך תמיד את עצמת השמע של יישומים אחרים כל עוד היא בריצה.

אפשרות זאת קיימת כאשר תכנת NVDA מותקנת בלבד.
זהו אינו אפשרי לתמוך בהנמכת שמע בגרסה הניידת.

#### הגדרות קול (NVDA+control+v) {#VoiceSettings}

תיבת הדו-שיח של הגדרות הקול, הנמצאת בתוך תפריט "העדפות", מאפשרת לשנות את התנהגות הדיבור והקול.
למידע נוסף לגבי השליטה הישירה בהגדרות הדיבור השונות, יש לעיין בפרק [בורר הגדרות הדיבור](#SynthSettingsRing)

תיבת דו-שיח של הגדרות הדיבור מכילה את האפשרויות הבאות :

##### קול {#toc85}

בעת פתיחת התיבה, הסמן מתמקם על תיבה משולבת המפרטת את הקולות לשירות מנוע הדיבור הפעיל.
ניתן לעבור מקול אחד למשנהו בעזרת חצי הכיוון. חץ שמאלה וחץ מעלה מקריאים את הקול הקודם. 
חץ ימינה וחץ מטה מקריאים את הקול הבא.

##### ניבים {#toc86}

מנוע הדיבור של Espeak  NG  שמופעל בעת התקנת NVDA  כולל מספר ניבים שונים המפורטים בתיבה משולבת זו. 
ניבים אלה די דומים לקולות שונים בכך שלכל אחד מהם מאפיינים ותכונות משלו.  
חלק מהניבים נשמעים כמו גברים, חלק כמו נשים ויש ניב אחד שקולו דומה לקולה של צפרדע.

##### מהירות {#toc87}

כאן ניתן לשנות את מהירות שטף הדיבור.
ניתן לכוון את המחוון לערכים הנעים בין 0 ל100, בעוד 0  קובע את המהירות הנמוכה ביותר ו-100, קובע את המהירות הגבוהה ביותר.

##### גובה {#toc88}

אופציה זו קובעת את גובה תדר הדיבור המושמע. 
ניתן לכוון את המחוון לערכים הנעים בין 0 ל100, בעוד 0 קובע את התדר הנמוך ביותר, ו-100, קובע את התדר הגבוה ביותר.

##### עצמה {#toc89}

ניתן לכוון את מחוון העצמה לערכים הנעים בין 0 ל100, בעוד 0 קובע את עצמת הדיבור הנמוכה ביותר, ו-100קובע את העצמה הגבוהה ביותר.

##### אינטונציה {#toc90}

אופציה זו מאפשרת לקבוע את מידת שינויי האינטונציה של הקול. לעת עתה, פעולה זו אפשרית רק עבור מנוע הדיבור של ESpeak NG.

##### שינוי שפה אוטומטי {#toc91}

תיבת סימון זו קובעת אם על NVDA לעבור לשפת דיבור אחרת בעת הקראת מילה המזוהה כשייכת לשפה זו.
התיבה מסומנת כברירת מחדל.
כרגע, רק מנוע הדיבור של ESpeak NG  מצויד במנגנון זה.

##### שינוי ניב אוטומטי {#toc92}

תיבה זו קובעת אם שינוי השפה יכלול גם שינוי ניב, אם הדבר אפשרי.
לדוגמה, אם מנוע הדיבור מכוון כרגע על קול אמריקאי והוא מזוהה על-ידי ביטוי השייך מפורשות לאנגלית בריטית, הוא יעבור אוטומטית לניב בריטי אם התיבה מסומנת.
האופציה אינה פעילה כברירת המחדל.

<!-- KC:setting -->

##### מידת ההקראה של סימנים ופיסוק {#toc93}

Key: NVDA+p

אופציה זו קובעת את רמת ההקראה של סימני הפיסוק במלל. 
אם תבחרו באפשרות "הכל", אזי כל הסימנים יוקראו בצורתם המילולית.
ההגדרה חלה על כל סוגי מנוע הדיבור ולא רק על זה שפעיל כרגע.

##### סמוך על מנוע הדיבור בעת הקראת סימני הפיסוק {#toc94}

מאפיין זה פעיל כברירת מחדל. הוא מורה לתכנת NVDA להעביר את הסימנים ואת התווים כפי שהם למנוע הדיבור ולסמוך עליו.
אם ההקראה על-פי יכולת מנוע הדיבור אינה משביעה רצון, יש להפוך את האופציה ללא-פעילה ולתת ל - NVDA להעביר למנוע הדיבור את המלל שהוגדר עבור הסימנים והתווים.

##### שינוי גובה הצליל עבור אותיות גדולות {#toc95}

בתיבת עריכה זו, תוכל לרשום מספר המבטא את אחוז שינוי גובה הצליל בעת חיווי קולי על אותיות לועזיות גדולות.
אם הערך הוא שלילי, הצליל יישמע עמוק יותר מהרגיל. אם הוא חיובי, הצליל יישמע גבוה יותר.
עליכם להקיש על 0 אם אינכם מעוניינים להרגיש בשינוי.

##### השמעת הביטוי "Cap" לפני הקראת אות לועזית גדולה {#toc96}

תיבת סימון זו קובעת אם NVDA תקריא את הביטוי "Cap" לפני הקראת אות גדולה, למשל בעת איות.
בדרך כלל NVDA מנסה להעלות את גובה הקול בעת הקראת אות גדולה. אם הדבר אינו אפשרי, סימון תיבה זו יכול להועיל.

##### השמעת צליל בעת הקראת אות גדולה {#toc97}

אם תיבה זו מסומנת, NVDA תשמיע צליל דק בעת הקראת אות לועזית גדולה.
אפשרות זו יעילה כמו הקראת הביטוי "Cap"  במקרה שמנוע דיבור שנבחר אינו תומך בשינוי גובה הצליל.

##### שימוש במנגנון איות אם נתמך {#VoiceSpellingFunctionality}

קיימות מילים בעלות אות אחת בלבד, כמו האות "a" באנגלית.
הגיית האות שונה אם מדובר בסימן בעצמו או במילה המסמלת עצם אחד בלבד. 
סימון התיבה יבטיח כי NVDA תשתדל להבחין בין שני המצבים אם מנוע הדיבור תומך בכך.
רוב המנועים אכן מבחינים בין שתי האפשרויות.

מומלץ לסמן תיבה זו. 
שימו לב שמספר קולות של מנגנון הדיבור SAPI של מייקרוסופט מתנהגים בצורה מוזרה במצב הנ"ל.
עדיף לבטל את הסימון אם התווים הבודדים נשמעים מוזרים.

#### בורר הגדרו הדיבור {#SynthSettingsRing}

אם אינכם מעוניינים להכנס לתפריט הראשי של NVDA כדי לשנות הגדרות בסיסיות של הדיבור, ניתן להפעיל מספר קיצורים שיעזרו לכם במשימה זו.
<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |תיאור|
|---|---|---|---|
|מעבר להגדרת הדיבור הבאה |NVDA+control+rightArrow |NVDA+shift+control+rightArrow |מחליף את ההגדרה לבאה בתור עד לחזרה להגדרה הראשונה|
|מעבר להגדרת הדיבור הקודמת |NVDA+control+LeftArrow |NVDA+shift+control+LeftArrow |מחליף את ההגדרה לקודמת בתור עד לחזרה להגדרה האחרונה|
|שינוי ערך כלפי מעלה |NVDA+control+upArrow |NVDA+shift+control+upArrow |הגברת הערך או מעבר לערך הבא, כגון הגברת המהירות, מעבר לקול הבא, הגברת העוצמה|
|שינוי ערך כלפי מטה |NVDA+control+DownArrow |NVDA+shift+control+DownArrow |הנמכת הערך או מעבר לערך הקודם, כגון האטת המהירות, מעבר לקול הקודם, הנמכת העוצמה|

<!-- KC:endInclude -->

#### הגדרות ברייל {#toc100}

כדי לשנות את הגדרות הברייל יש לפתוח את תפריט ההעדפות ובתוכו את אפשרויות הברייל.

##### צג ברייל {#toc101}

הגדרת צג הברייל היא הראשונה המופיעה בתפריט הברייל.
לפי בחירת הצג מתוך תיבה משולבת זו ובהתחשב ביכולות של התקן הצג שברשותכם, תוכלו להגדיר מספר מאפיינים שינויים הקשורים בתצוגת הברייל.
יש לנוע בין האפשרויות בעזרת חיצי הכיוון.

הביטוי "ללא", פירושו כי אין בכוונתכם להשתמש בצג ברייל.

למידע נוסף, יש לעיין בפרק [צגי הברייל הנתמכים](#SupportedBrailleDisplays) 

##### יציאה {#toc102}

אם קיימת הגדרה כזאת עבור הצג שבחרתם,  תוכלו להגדיר כאן את האופן שבו הצג מחובר למחשב.
תיבה משולבת זו מכילה את האופציות הרלוונטיות עבור הצג שלכם.

כברירת מחדל, NVDA מנסה להתחבר אוטומטית לצג הברייל על ידי סריקה שיטתית של כניסות הUSB והתקני ה-BlueTooth.
קיימים צגים המאפשרים למשתמש להגדיר בעצמו את היציאה שאליה מחובר המכשיר.
הביטוי "אוטומטי" מציין את השיטה המצויה ביותר שבה NVDA סורק בזה אחר זה את התקני ה-USB וה-BlueTooth וכן את היציאות הטוריות במקרה שהתקן הצג תומך בהן.

לא תתאפשר בחירה אם התקן הצג יתמוך רק בזיהוי האוטומטי.

למידע נוסף בנושא סוגי החיבורים השונים והיציאות השונות, יש לעיין בפרק [צגי הברייל הנתמכים](#SupportedBrailleDisplays) 

##### טבלת הברייל {#toc103}

העניין הבא בתיבת הדו-שיח הוא תיבה משולבת העוסקת בטבלת הברייל הרצויה.
רשימה זו מציגה טבלאות עבור שפות שונות וכן תקנים ושיטות ברייל שימושיות.
הטבלה שתיבחר כוללת את תצוגת הסימנים שיופיעו על צג הברייל. 
יש לנוע בתוך הרשימה בעזרת חצי הכיוון.

##### טבלת קלט ברייל {#toc104}

טבלת קלט הברייל היא הצד ההפוך והמשלים של טבלת פלט הברייל שתוארה לעיל.
הטבלה שתיבחר תשמש להפיכת הנקודות שיוקלדו על הצג בשיטת פרקינס לסימנים המוכרים על-ידי המחשב.
כרגע, NVDA מכירה אך ורק את שיטת הברייל הממוחשב לצורך הקשת נקודות. לכן, רק הטבלאות בנויות על יסוד 8 נקודות הברייל שיופיעו ברשימה.
יש להשתמש בחצי הכיוון כדי לנווט בין הטבלאות השונות.

שימו לב כי ניתן להקיש נקודות ברייל בשיטת פרקינס רק אם התקן צג הברייל תומך בכך.
אם קלט הברייל אינו נתמך אף על-פי שצג הברייל מצויד במקשים הנדרשים לכך, הודעה תופיע על כך בפרק [צגי הברייל הנתמכים](#SupportedBrailleDisplays) 

##### הרחבת המילה שבפוקוס בברייל ממוחשב {#toc105}

תיבה זו קובעת אם המילה שבפוקוס תוצג על צג הברייל בצורה מלאה של ברייל ממוחשב או בצורת המכווצת.

##### הצגת הסמן {#toc106}

תיבה זו קובעת אם מקום הסמן יוצג בברייל או לא.  
הגדרה זו חלה על סמן המקלדת ועל סמן הסריקה אך לא על הטקסט המסומן.

##### הבהוב הסמן {#toc107}

תיבה זו מאפשרת לסמן הברייל להבהב.
אם אפשרות זו כבויה, סמן הברייל יהיה במצב "למעלה" בצורה קבועה.

##### קצב הבהוב הסמן {#toc108}

תיבת עריכה זו מאפשרת להקיש מספר מילי-שניות שיקבע את הבהוב הסמן על סרגל הברייל.

##### צורת הסמן {#toc109}

אופציה זו מאפשרת לבחור את הצורה שבה יופיע הסמן על צג הברייל.
הגדרה זו אינה חלה על סימון הטקסט.

##### זמן הופעת מסרים {#toc110}

תיבת עריכה זו מאפשרת לקבוע את משך זמן הופעת המסרים הקצרים על גבי צג הברייל. 
הקשת 0 תבטל את הופעת המסרים על הצג.

<!-- KC:setting -->

##### הצמדת הברייל {#BrailleTether}

Key: NVDA+control+t

אופציה זו קובעת אם תצוגת הברייל תוצמד לסמן המקלדת או לסמן הניווט והסריקה.

##### הצגה לפי פיסקאות {#toc112}

אם תיבה זו מסומנת, סרגל הברייל יציג את תוכן הפיסקאות ולא רק את מלל השורות.
במקביל, פקודות הצגת השורה הבאה והשורה הקודמת יציגו את הפיסקה הבאה או הקודמת בהתאמה.
פירוש הדבר כי אין להזיז את סרגל הברייל בסוף שורה במקרה שנותר בו מקום למלל נוסף.
תכונה זו עשויה להקל בקריאת כמות גדולה של חומר.
כברירת מחדל האופציה אינה פעילה.

##### "הימנע מפיצול מילים עד כמה שאפשר" {#toc113}

אם התיבה מסומנת, מילה ארוכה מדי לא תפוצל ותועבר לשורת הברייל הבאה.
במקרה זה, הסרגל יציג מספר תאים ריקים בסוף השורה.
הזזת סרגל הברייל תביא להצגת המילה.
מנגנון זה נהוג לכנות לעתים בשם "שלישת שורות".
למרות האמור לעיל, הפיצול יחול אם הביטוי המוצג יהיה ארוך יותר מגודל הסרגל.

אם התיבה אינה מסומנת, המילים שלא ייכנסו לסרגל הברייל יקוצצו.
הזזת הסרגל תציג את יתר המילה.

הפיכת אופציה זו לפעילה תקל את שטף הקריאה אך תדרוש לחיצות תכופות יותר על הכפתורים למעבר בין שורות.

#### הגדרות מקלדת NVDA+control+k {#toc114}

ניתן למצוא את "הגדרות מקלדת" בתפריט "העדפות".
שם נמצאות האפשרויות הבאות :

##### סוג המקלדת {#toc115}

תיבה משולבת זו מאפשרת בחירה של סוג הפקודות לשימוש NVDA כעת, ניתן לבחור בין מקלדת מחשב נייח למקלדת מחשב נייד.

##### השתמש במקש CapsLock כמקש יחודי של NVDA {#toc116}

אם התיבה מסומנת, מקש CapsLock ישמש כמקש היחודי של פקודות NVDA

##### השתמש במקשInsert   כמקש יחודי של פקודות NVDA {#toc117}

אופציה זו קובעת אם מקש Insert הנמצא מעל למקשי החצים יאפשר ביצוע פקודות NVDA

##### השתמש במקש0 בכרית המספרים כמקש יחודי של פקודות NVDA {#toc118}

אופציה זו קובעת אם מקש ה0 שמימין לחצים יאפשר ביצוע פקודות NVDA

אם שום מקש לא נבחר כמקש יחודי, ייתכן שלא תתאפשר שום פקודת מקלדת של NVDA
במקרה זה NVDA תודיע על שגיאה בתגובה עם לחיצה על כפתור האישור.
לא ניתן לצאת מתיבת הדו-שיח אם לא נבחר מקש כלשהו.

<!-- KC:setting -->

##### הקראת תויים {#toc119}

Key: NVDA+2

סימון התיבה יגרום לתכנת NVDA להקריא את התווים המוקלדות.

<!-- KC:setting -->

##### הקראת מילים {#toc120}

Key: NVDA+3

סימון התיבה תגרום לNVDA להקריא את המילים המוקשות.

##### הפסקת הדיבור בעת הקשת תו {#toc121}

סימון התיבה יגרום להפסקת הדיבור הנוכחי בעת הקשת תו חדש. אופציה זו היא ברירת המחדל.

##### הפסקת הדיבור בעת לחיצה על מקש  Enter {#toc122}

סימון התיבה יפסיק את הדיבור הנוכחי בעת הקשה על Enter. אופציה זו היא ברירת המחדל.

##### קריאה מהירה {#toc123}

אם אופציה זו נבחרת,  מספר פקודות ניווט, כמו ניוט מהיר במצב גלישה או קריאה לפי שורות או פיסקאות, לא יפסיקו את שטף ההקראה הרציפה.הסמן יתמקם על האיזור החדש שסמן המחשב יהיה ממוקם עליו וההקראה תימשך מאותה הנקודה.

##### השמעת צליל בעת הקשת אות קטנה במצב CapsLock דלוק {#toc124}

במצב זה, צליל אזהרה יושמע אם מקש ה-Shift יילחץ בצירוף עם תו אחר במקרה שמקש ה- הCapsLock יהיה כבר במצב דלוק.
הסיבה לכך היא שאין היגיון בהקשת אותיות גדולות בעזרת Shift אם מקש CapsLock דלוק, פרט להקשת סימני ניקוד בעברית הדורשת את הצירוף המוזר הזה.
באופן רגיל, כל אחד יהיה מעוניין באזהרה שכזאת.

<!-- KC:setting -->

##### הקראת מקשי פקודות {#toc125}

Key: NVDA+4

אם האופציה פעילה, NVDA תקריא את ההקשות שאינן יוצרות תווים, כגון צירופי אותיות עם מקש Control   ועוד.

##### השמעת צליל בעת שגיאת איות או דקדוק {#toc126}

אם התיבה מסומנת, יישמע זמזום בעת שגיאת איות או דקדוק תוך כדי הקלדה.
תופעה זו תתרחש אך ורק אם אופציית הדיווח על שגיאות איות תהיה מסומנת ב[הגדרות עיצוב מסמך](#DocumentFormattingSettings) הגדרה זו קובעת אם על NVDA להתייחס להקשות הנוצרות על ידי תוכנות מקלדת וירטואלית ופיענוח גרפי. זוהי אכן ברירת המחדל אך ישנם משתמשים שיהיו מעוניינים לבטל אותה, לדוגמה, אלה המשתמשים בתוכנת Unikey בווייטנאמית, העלולה ליצור התנגשות עם פקודות NVDA

##### ניהול מקשים מיישומים אחרים {#toc127}

אפשרות זו מאפשרת למשתמש לשלוט באפשרות האם לחיצה על מקשים על ידי ישומים אחרים כגון מקלדת על המסך, ותוכנות לזיהוי קולי יתנהלו על ידי NVDA
אפשרות זו דלוקה במצב ברירת מחדל.

#### הגדרות עכבר NVDA+control+m {#MouseSettings}

תיבת הדו-שיח על הגדרות העכבר נמצאת בתוך תפריט "העדפות". 
היא כוללת את הנושאים הבאים :

##### דיווח על שינוי צורת סמן העכבר {#toc129}

סימון תיבה זו יגרום להקראת צורת העכבר בעת שינוי.
במערכת ההפעלה Windows  שינוי צורה נועד להודיע על אפשרות של ערכיה, ביצוע טעינה ועוד.

<!-- KC:setting -->

##### עקיבה אחר העכבר {#toc130}

Key: NVDA+M

סימון התיבה תגרום להקראת המלל הנמצא במקום שהעכבר מצביע עליו תוך כדי תנועה. שיטה זו מאפשרת קריאה תוך כדי ניווט על המסך ולא כתוצאה מניווט לפי אובייקטים.

##### יחידת טקסט להקראה {#toc131}

אם התיבה הקודמת מסומנת:
האופציה הזאת תאפשר להגדיר אם ההקראה תחול על תווים, מילים, שורות או פסקאות.

##### הקראת סוג האובייקטים תוך כדי ניווט {#toc132}

תיבת סימון זו קובעת אם על NVDA להקריא את סוג האובייקט שהעכבר נכנס אליהם.

##### השמעת צלילים המבטאים את קואורדינטות מיקום העכבר {#toc133}

סימון התיבה ינחה את NVDA להשמיע צלילים המאפשרים למשתמש לזהות את מיקום העכבר ביחס לגובה המסך ולרוחבו.
ככל שמיקומו של העכבר גבוה ביחס למסך, כך יושמע צליל גבוה יותר.
אם מותקנים על המחשב רמקולים או אוזניות סטריאופוניות, הצליל יישמע מצד שמאל או ימין בהתאמה על פי מיקומו האופקי של העכבר.

##### השמעת צלילים לזהוי הניגודיות של המסך {#toc134}

אם תיבת השמעת הצלילים בעת ניווט מסומנת, אזי ניתן לסמן את האופציה הזאת כדי להביא להשמעת צלילים המבטים את מידת הניגודיות של העצמים שהעכבר עובר אליהם. 
אין זו ברירת המחדל.

#### הגדרות סמן הסריקה {#toc135}

תיבת דו-שיח זו נמצאת גם היא בתפריט ההעדפות.
היא כוללת את הנושאים הבאים :

<!-- KC:setting -->

##### עקיבה אחר הפוקוס {#toc136}

Key: NVDA+7

סימון התיבה יגרום לסמן הסריקה לעקוב באופן אוטומטי אחר סמן המקלדת תוך כדי שינוי הפוקוס.

<!-- KC:setting -->

##### עקיבה אחר סמן המקלדת {#toc137}

Key: NVDA+6

אם התיבה מסומנת, סמן הסריקה יעקוב תמיד אחר סמן המקלדת,במקרה שהפעולה אפשרית.

##### עקיבה אחר העכבר {#toc138}

אם התיבה מסומנת, סמן הסריקה יעקוב תמיד אחר סמן העכבר, במקרה שהפעולה אפשרית.

##### מצב סריקה פשוט {#toc139}

אם תיבה זו מסומנת,  NVDA תציג את האובייקטים באופן היררכי, אך היא תתעלם מאלה שאינם בעלי משמעות עבור המשתמש או שנועדים לצורך עיצוב גראפי בלבד.

כדי להפוך מצב לזמין וללא זמין לסרוגין, מומלץ להקצות לפעולה מחווה כמפורט בפרק [תנועות המחווה](#InputGestures).

#### הגדרות הצגת אובייקטים NVDA+control+o {#toc140}

דו-שיח זה נמצא אף הוא בתפריט ההעדפות.
הוא כולל את הנושאים הבאים :

##### הקראת עזרה זמנית {#toc141}

סימון תיבה זו יגרום להשמעת בלוני העזר של המערכת.
אובייקטים אלה הם רמזים קצרים המוקפצים כשהעכבר עובר עליהם או כשסמן המקלדת עומד עליהם.

##### הקראת בלוני עזרה {#toc142}

התיבה קובעת את הקראת בלוני העזר. 
אובייקטים אלה דומים לבלוני הטולטיפים המוזכרים לעיל, פרט לכך שהתוכן שבהם מפורט הרבה יותר וקשור בדרך כלל  לאירועי מערכת ההפעלה כגון התנתקות של כבל רשת או אזהרת אבטחה כלשהי.

##### אות קיצור הדרך {#toc143}

אם תיבה זו מסומנת, NVDA תקריא את האותיות המשמשות כקיצורי דרך המפעילים אובייקטים מסויימים.
לדוגמה, תפריטי "קובץ" רבים מופעלים על ידי הצירוף Alt+F

##### הקראת מיקום האובייקטים {#toc144}

תיבה זו מאפשרת להגדיר אם מיקום האובייקט שהסמן ממוקם עליו יוקרא ביחס למספר הכולל של האובייקטים למשל 1 מתוך 4.

##### זיהוי מיקומם של אובייקטים {#toc145}

תיבה זו קובעת אם על NVDA לנסות ולזהות את מיקומם של אובייקטים שלא ניתן להשיג עבורם מידע בשיטות אחרות.

תכונה זו חלה על אובייקטים כגון תפריטים. מידת הדיוק של הזיהוי לוקה לפעמים בחסר.

##### תיאור אובייקטים {#toc146}

יש לבטל את הסימון מהתיבה אם אין ברצונך לשנות את סוג האובייקט ביחד עם תוכנו המילולי.

<!-- KC:setting -->

##### הקראת מצב פס ההתקדמות {#toc147}

Key: NVDA+U

תיבה זו קובעת את אופן הדיווח של NVDA לגבי פסי התקדמות.

האפשרויות הבאות עומדות לרשותך :

* ללא הקראה : לא יתקבל חיווי על התקדמותם של תהליכים
* הקראה : NVDA תקריא את מצב ההתקדמות באחוזים
* צליל :  NVDA תשמיע צליל המודיע על ההתקדמות. ככל שהצליל גבוה, התהליך קרוב יותר לסיום.
* צליל ודיבור : NVDA תשמיע צליל וכן תקריא את מצב ההתקדמות באחוזים

##### הודעה על התקדמות תהליכים ברקע {#toc148}

אם התיבה מסומנת, NVDA תודיע על התקדמותם של תהליכים גם אם אלה אינם בפוקוס כרגע.
אם תקטין את החלון שבתוכו מתחולל תהליך בהתקדמות או תעבור ליישום אחר, NVDA תמשיך לספק חיווים אודות ההתקדמות.

<!-- KC:setting -->

##### דיווח על שינוי תוכן דינמי {#toc149}

Key: NVDA+5

תיבה זו הופכת את ההקראה של שינויים החלים על פקדים כתוצאה מאירועים שונים, כגון חיבורי מסוף או חלונות של צ'אט, לזמינה או לא-זמינה.

#### הגדרות תבנית הקלט {#toc150}

תיבת דו-שיח של הגדרות תבנית הקלט נמצאת בתפריט ההעדפות. היא כוללת אפשרויות הקשורות להקשת תווים אסיאטים בשיטת IME   או תווים המחייבים שירותי טקסט מתקדמים. 
השיטות האלה שונות מאד משפה לשפה בכל הקשור לתכונות של כל שפה ולאופן העברת המידע.  
מומלץ להגדיר בנפרד את כל האפשרויות שאתה עתיד לעבוד מולן כדי לקבל חיווי אופטימאלי של הקשות הטקסט.

##### דיווח אוטומטי על המועמדים {#toc151}

תיבה זו מאפשרת לקבוע אם כל המועמדים  הנראים יופיעו ברשימה כשזו מוצגת או משתנה. זוהי ברירת המחדל.  תכונה זו עוזרת בבחירת סימנים פיקטוגראפיים השייכים לשפות כמו סינית צ'אנגג'י חדשה ובושיאמי.  במקרים אלה, ניתן לקבל רשימה של תמונות הסימנים ביחד עם מספרים, דבר המקל את הבחירה.
למרות זאת, עדיף להפוך את האופציה ללא זמינה עבור קלט פונטי של שפות כמו סינית פונטית החדשה. 
הסיבה לכך היא שכל הסימנים מסוג אחד נשמעים באותה הצורה, דבר המקשה על בחירת הסימן הנכון מתוך רשימת הגייה.

##### הקראת המועמד שנבחר {#toc152}

זו ברירת המחדל המאפשרת לקבוע אם על NVDA להקריא מידע על המועמדים המופיעים ברשימה תוך כדי ניווט. 
כדאי לסמן את התיבה עבור שפות כמו סינית פונטית החדשה,  אך ברוב המקרים, אין זה הכרחי.  
גם אם סמן הסריקה יתמקם על המועמדים השונים, עדיין ניתן לבחור את המועמד הרצוי על ידי סמן הפוקוס.

##### הקרא תמיד תיאור קצר עבור המועמדים {#toc153}

תיבה זו פעילה כברירת מחדל. 
היא קובעת אם NVDA תקריא תיאור קצר של התווים של מועמד מסויים בעת בחירה או כשהרשימה מוצגת.
תוספת זו אינה מופעלת עבור שפות כמו סינית, אבל יש היגיון בהפעלתה עבור קלט של קוראנית ושל יפנית.

##### הקראת השינויים במחרוזות {#toc154}

שיטות קלט מסויימות, כמו סינית פונטית חדשה וצ'נגג'י,  משתמשות במחרוזת קלט קריאה או קלט מקדימה.
תיבת הסימון קובעת אם התווים שיוקלדו את תוך מחרוזת זו יוקראו או לא.  זוהי ברירת המחדל. 
שיטול ישנות יותר של קלט, כמו סינית צ'נגג'י, אינן משתמשות במחרוזת הקריאה בתוך מחרושת מקדימה.
הןמלכתחילה משתמשות יותר במחרוזת המקדימה. למידע נוסף, יש עיין בשורות הבאות לפירוט הגדרת המחרוזת.

##### הודעה על שינוי המחרוזת המקדימה {#toc155}

לאחר שנתוני הקריאה או המחרוזת המקדימה הורכבו אל תוך סימן פיקטוגראפי  תקין, רוב שיטות הקלט מתייחסות לסימן זה כאל מחרוזת מורכבת שהן מעבירות לאוסף של סימנים זמניים העשויים להכנס לתוך מסמך.
אופציה זו קובעת אם על NVDA לדווח על כל שינוי שיחול בהרכב המחרוזות המורכבות.
אפשרות זו פעילה כברירת מחדל.

#### הגדרות מצב גלישה NVDA+control+b) {#toc156}

תיבת הדו-שיח של הגדרות מצב הגלישה נמצאת בתוך תפריט ההעדפות. 

היא כוללת את הנושאים הבאים :

##### מספר תווים בשורה {#toc157}

תיבת עריכה זו קובעת את מספר התווים שיופיעו בשורת טקסט במצב גלישה.

##### מספר שורות בדף {#toc158}

תיבה זו קובעת את מספר השורות שידולגו בעת לחיצה על מקשי PageUp או PageDown

<!-- KC:setting -->

##### Use screen layout {#toc159}

Key: NVDA+V

תיבה זו קובעת אם אובייקטים הניתנים להפעלה, כגון קישורים, יופיעו בשורה בפני עצמה או בגוף הטקסט, לפי מקום הופעתם.

##### הקראה אוטומטית בתוך טעינת דף {#toc160}

תיבה זו קובעת אם במצב גלישה תוכן המלל של דף נתון יוקרא באופן אוטומטי או לא. 
זוהי ברירת המחדל.

##### החל מבנה טבלאי {#toc161}

תיבה זו קובעת אם הטבלאות יופיעו באופן המשמר את המבנה שלהן, או לא.
אם כן, הן יטופלו לפי הכללים הרגילים שנקבעו עבור [עיצוב המסמכים](#DocumentFormattingSettings)
במקרה זה, ניתן יהיה להפעיל את הפקודות הישירות של ניווט בטבלאות.
אם לא, פעולות הניווט הישירות לא יפעלו אך התוכן המילולי של הטבלאות יופיע כסדרו.
ברירת המחדל היא לא לאפשר ניווט ישיר.

##### הגדרת אופן הקראת אובייקטים כגון קישורים וכותרות {#toc162}

יש לעיין בפרק הדן ב[עיצוב המסמכים](#DocumentFormattingSettings)  כדי  לקבל מידע אודות הגדרת אופן ההקראה של האובייקטים שניווט הגלישה מגיע אליהם, כגון קישורים, כותרות וטבלאות.

##### מעבר אוטומטי למצב פוקוס בעת שינוי פוקוס {#toc163}

תיבה זו קובעת אם יתבצע מעבר למצב פוקוס בעת שינוי הפוקוס.  
לדוגמה : אם לחיצה על מקש Tab  במצב גלישה מקפיצה את הסמן אל שדה למילוי בתוך טופס, המערכת עשויה לעבור באופן אוטומטי למצב פוקוס במקרה שהתיבה הזאת מסומנת.

##### מעבר למצב פוקוס בעת שינוי מיקום סמן {#toc164}

אם התיבה מסומנת, NVDA תעבור באופן אוטומטי למצב פוקוס אם חצי הכיוון יביאו את הסמן לתיבת עריכה והיא תחזור למצב גלישה עם היציאה ממנה.  
לדוגמה : אם נלחץ על חץ מטה במצב גלישה כדי לבחון את השורה הבאה והסמן יעמוד עתה על תיבת עריכה, המערכת תעבור אוטומטית למצב פוקוס. לחיצה נוספת על חץ מטה למעבר להמשך התוכן תחזיר את התפקוד למצב גלישה.

##### חיוויים קוליים בעת מעבר ממצב גלישה למצב פוקוס {#toc165}

אם תיבה זו מסומנת, NVDA תשמיע צליל בעת מעבר ממצב אחד לשני במקום להודיע מילולית על שינוי המצב.

##### לכידת מקשים לצורך קריאת מסמכים {#toc166}

אפשרות זו, הפעילה כברירת מחדל, קובעת כי הקשות שאינן פקודות NVDA  או פקודות מערכת ההפעלה יילכדו ולא יועברו אל תוך המסמך הפעיל. 
לדוגמה : אם האופציה פעילה, הקשה על האות J תפורש כפקודה ולא כתו להכנסה אל תוך המסמך, אף על פי שאות J אינה משויכת לשום פקודה.

#### הגדרות עיצוב מסמכים NVDA+control+d {#DocumentFormattingSettings}

תיבת דו-שיח זו מופיעה בתפריט ההעדפות.

תיבות הבקרה שבה מאפשרות להגדיר את העיצוב המתאים לך עבור הקראת המסמכים תוך כדי ניווט בתוכן.
לדוגמה, אם תיבת הקראת הגופן מסומנת, NVDA תקריא את שם הגופן כל אימת שחל שינוי עיצוב בטקסט.  

הגדרות המסמך מחולקות לפי קבוצות.
ניתן להגדיר את הנושאים הבאים :

* גופן
 * שם הגופן
 * גודל הגופן
 * מאפייני הגופן
 * הדגשת גופן
 * סגנון הטקסט
 * צבעים
* מידע על המסמך
 * הערות
 * שינויים של העורך
 * שגיאות איות
* עמודים ורווחים
 * מספור עמודים
 * מספרי שורות
 * אפשרויות הזחת שורות [(Off, Speech, Tones, Both Speech and Tones)](#lineIndentationOptions)
 * כניסת פסקאות, כולל כניסה תלויה, כניסה ראשונה.
 * מרווח של שורה אחת ועוד
 * הזחה
* מידע על טבלאות
 * טבלאות
 * שורות טבלה, כותרות טבלה
 * קואורדינטות התאים בטבלאות
* אלמנטים
 * קישורים
 * כותרות
 * רשימות
 * גושים בין מרחאות
 * ציוני דרך
 * מסגרות
 * אובייקטים הניתנים להפעלה

ניתן לשנות את האפשרויות האלה  על ידי כניסה לתיבת דו-שיח [בחירת מחווה קלט](#InputGestures)

##### שינויי עיצוב לאחר הסמן {#toc168}

תיבה זו קובעת כי על NVDA להודיע על כל שינויי העיצוב המופיעים בתוך שורה שהסמן בתוכה גם אם הם נמצאים מעבר למקומו הנוכחי. פעולה זו עלולה להאט את קצב ההקראה.

כברירת מחדל, NVDA מנסה לבצע פעולה זו אך ורק אם הדבר אינו גורם להאטה משמעותית של הקריאה.

יש להפוך אופציה זו לפעילה ביישומים שבהם בדיקת העיצוב חשובה במיוחד, כמו בMicrosoft Word

##### הקראת הכניסות {#toc169}

אפשרות זו קובעת את האופן שבו יוקראו כניסות השורות . 
תיבה משולבת זו מציגה 4 אפשרויות:

* ללא : NVDA לא תודיע על כניסת שורה
* דיבור : בעת שינוי כניסה, NVDA תודיע על מספר התווים או הטאבים המהווים את הכניסה
* צלילים : עומק הכניסה יבוטא באמצעות צליל. צליל גבוה יותר, פירושו - כניסה עמוקה יותר. 
טאב יבוטא באמצעות צליל הזהה לצליל המושמע בכניסה של 4 רווחים
* דיבור וצלילים : NVDA תפעיל את השיטות האחרונות לעיל

#### מילוני דיבור {#toc170}

תיבת דו-שיח של מילוני הדיבור נמצאת בתפריט העדפות.
המילונים קובעים את האופן שבו NVDA מבטאת מילים וביטויים שונים. 
קיימים כעת 3 סוגים של מילוני דיבור :

* ברירת מחדל : הכללים המוגדרים במילון זה חלים על כל ההקראות שלNVDA
* קול : הכללים במילון זה חלים על הקול של מנוע הדיבור הנמצא בפעולה כרגע
* מילון זמני :  הכללים המוגדרים במילון זה חלים על כל ההקראות אך רק כל עוד NVDA בריצה. ההגדרות מתאפסות בעת הרצה מחדש.

אם ברצונך לפתוח את המילים מכל מקום במחשב, עליך להגדיר מחוות מתאימות ב[הגדרת מחוות](#InputGestures)

כל הגדרות המילים כוללות כללים שיופעלו בעת כל הקראה.
תיבת הדו-שיח כוללת גם כפתורי הוספה, עריכה ומחיקה.

לצורך הוספת כלל, יש ללחוץ על כפתור "הוספה" ולמלא אחר הוראות תיבת הדו-שיח. לבסוף יש ללחוץ על  Enter.
הכלל החדש יופיע עתה ברשימת הכללים.
חשוב ללחוץ פעם נוספת על מקש הEnter כדי להבטיח כי ההוספה או העריכה או שתיהן אכן תקפות בעת יציאה מתיבת הדו-שיח.

הכללים של NVDA מאפשרים להמיר מחרוזת אחת ברצף אחר של תווים.  
לדוגמה : נניח כי ברצונכם לשמוע את המילה "צפרדע" כל פעם שהמחרוזת "ציפור" אמורה להישמע.  
לשם כך,יש להקיש את המילה "ציפור" בתיבת העריכה "מקור" והקש את המילה "צפרדע" בתיבת "החלף ב...".
קיימת גם תיבת הערות שבה ניתן לרשום משהו כמו "הציפור צריכה להישמע כמו צפרדע".

היכולות של מילוני הדיבור של NVDA חזקות הרבה יותר מסתם החלפה של מחרוזת אחת באחרת.  
תיבת סימון מאפשרת לקבוע אם ההגדרה חלה גם על האותיות הלועזיות הגדולות. 
ברירת המחדל היא חיובית.

לבסוף, כפתורי בחירה קובעים אם ההגדרה חלה בכל מקרה, עבור מילה שלמה או ברמה של ביטוי. 
אם בחרנו ב"מילה שלמה", ההחלפה לא תחול אם מילת המקור תופיע כחלק של מילה גדולה יותר, כגון "ציפורים" במקום "ציפור". 
מילה שלמה היא מילה שיש לפניה ולאחריה רווח, קו תחתי, סימן פיסוק או ספרה.

במונח ביטוי הכוונה להרכב תווים המכיל את מחרוזת המקור. 
מדריך זה אינו מכיל דוגמאות של ביטויים שכאלה אך ניתן למצוא באינטרנט חומר רב בנושא.

#### הקראת סימני פיסוק {#SymbolPronunciatiOn}

תיבת דו-שיח זו מאפשרת להגדיר את אופן הקראת סימני הפיסוק וסימנים אחרים וכן את רמת הפירוט של ההקראה.

כותרת תיבת הדו-שיח מפרטת את השפה שעבורה מתבצעת כעת עריכת סימני הפיסוק.
התהליך הגדרת סימני הפיסוק מסתמך על מנוע הדיבור כפי שנבחר ב[הגדרות הקול](#VoiceSettings);. בדו-שיח זה, אופן ההקראה של הקול שנבחר גובר על הגדרות  השפה הכלליות של NVDA אם התיבה המתאימה תסומן.

על מנת לשנות סימן, יש לבחור אותו תחילה מתוך רשימת הסימנים 

* יש לעבור לתיבת "החלף ב..."  והקש שם את המלל הרצוי עבור הקראת הסימן.
* יש לקבוע את רמת הפיסוק שממנה והלאה הסימן יוקרא.
* יש לבחור באפשרות "שלח את הסימן ישירות"  אם אין ברצונך לשמוע את מלל החלפה.
אופציה זו מומלצת עבור סימנים שמביאים שינויים מוזרים בהתנהגות של מנוע הדיבור.
לדוגמה, העברת הסימן "פסיק" ישירות מביאה להשהייה קצרה של הדיבור.
3 אפשרויות עומדות לרשותך :
 * אף פעם :  הסימן לא יועבר אף פעם ישירות למנוע הדיבור 
 * תמיד : הסימן יועבר  - תמיד ישירות למנוע הדיבור - ר - 
 * רק מרמת הפיסוק הקבועה לכך : 
 לדוגמה, ניתן להגדיר כי סימן מסויים יועבר כמות שהוא ברמת פיסוק מסויימת אך המחרוזת המוגדרת להחלפה תוקרא מרמה זו ומעלה.

יש ללחוץ על כפתור "הוספה" כדי להוסיף הגדרות חדשות.
לשם כך, יש להקיש את הסימן וללחוץ Enter . 
לאחר מכן, יש להגדיר את הסימן כפי שהוסבר לעיל.

ניתן למחוק הגדרה על ידי לחיצה על כפתור "מחיקה".

לחיצה על "אישור" תשמור את כל השינויים. לחיצה על "ביטול" תבטל את השמירה.

#### מחוות קלט {#InputGestures}

תיבת דו-שיח זו מאפשרת להגדיר פקודות עבור צירופי מקשים, כפתורי ברייל, ועוד.

רשימת הפקודות חלה אך ורק על אלה שזמינות לפני הופעת תיבת הדו-שיח.
לדוגמה : אם נכנסת לדו-שיח מתוך מצב גלישה, הרשימה תכלול רק את פעולות הגלישה בלבד.

הרשימה מופיעה כעץ המציג את סוגי הפעולות ואת פירוט הפעולות ברמה פנימית יותר.
ניתן לבצע סינון על ידי הכנסת מחרוזת מתאימה.
כל מחווה הקשורה לפקודה תופיע מתחתיה.

על מנת להוסיף מחוות קלט לפקודה מסוימת, יש לבחור זאת מהרשימה ולחץ על כפתור "הוספה".
לאחר מכן, יש לבצע את המחווה הרצויה להפעלת אותה פקודה, כגון, צירוף מקשים במקלדת או בצג הברייל.
צירוף מסויים עשוי להתפרש בצורות שונות, לפי סוג המקלדת שנבחר. 
ניתן לקבוע שהצירוף יחול על מקלדת המחשב הנייח, על מקלדת המחשב הנייד או על שתיהן.

הסרת צירוף או מחווה נעשית על ידי לחיצה על כפתור "מחיקה" לאחר בחירת הפעולה.

על מנת לשמור את השינויים שבוצעו, יש ללחווץ על כפתור האישור. יש ללחוץ על "ביטול" כדי לבטל את כל השינויים.

### שמירת ההגדרות וטעינה מחדש {#toc173}

כברירת מחדל NVDA שומרת את ההגדרות בעת יציאה מהתוכנית. 
ניתן לשנות זאת בתפריט ההגדרות הכלליות הנמצא בהעדפות. 
ניתן לשמור את ההגדרות ידנית מתוך התפריט הראשי בכל רגע.

אם שגינו בהגדרה מסויימת, ניתן להעלות את ההגדרות שנשמרו בפעם האחרונה מתוך התפריט הראשי.
אפשר גם להחזיר את ההגדרות לצורתן הבסיסית מתוך התפריט הראשי.

מספר פקודות עשויות לעזור בתהליך :
<!-- KC:beginInclude -->

| פעולה |מחשב נייח |מחשב נייד |תיאור|
|---|---|---|---|
|שמירת ההגדרות |NVDA+control+c |NVDA+control+c |שומר את ההגדרות הפעילות כרגע כך שהן יעלו בעת הפעלה מחדש|
|החזרת הגדרות |NVDA+control+r |NVDA+control+r |לחיצה פעם אחת : החזרת ההגדרות לאלה שנשמרו לאחרונה. לחיצה שלוש פעמים : החזרת ההגדרות הבסיסיות של התכנה|

<!-- KC:endInclude -->

### פרופילים {#toc174}

קיימים מצבים שבהם נרצה להחזיק בערכות הגדרות שונות.  
לדוגמה, בשלב עריכת מסמך, נרצה לקבל חיווי על כניסת הפיסקאות אך בשלב הבדיקה הסופית נהיה מעוניינים דווקא מעוניין בהקראת שינויי מאפייני העיצוב. 
הפרופילים של NVDA הם כלי נוח לבצע משימות אלה.

פרופיל ההגדרות מכיל אך ורק את אלה שהשתנו בעת עריכת הפרופיל. 
רוב הגדרות ניתנו לשינוי ולשמירה בפרופילים אך לא את אלה המופיעות בתפריט הכללי, שחלות על כל המערכת כולה.

ניתן להפעיל פרופיל באופן ידני. 
ניתן גם להפעיל את ההגדרות דרך מנגנון של תנאים הקשורים לריצת יישומים מסויימים.

#### ניהול בסיסי {#toc175}

מתוך התפריט הראשי, יש לבחור ב"פרופילים". 
ניתן גם לפתוח את תיבת הדו-שיח על ידי צירוף יחודי :
<!-- KC:beginInclude -->

* NVDA+control+p

<!-- KC:endInclude -->

הסמן מתמקם על רשימת הפרופילים הקיימים שממנה ניתן לבחור את הרצוי.
אם אתם עובדים תחת פרופיל מסוים, הוא זה שהסמן יעמוד עליו בעת פתיחת התיבה.
מידע נוסף מפרט אם פרופיל זה מופעל רק ידנית או בעת מילוי תנאים ואם הוא כרגע בעריכה.

הכפורים "מחיקה" ו"שינוי שם" מאפשרים להסיר את הפרופיל ולשנות את שמו בהתאמה.

לחיצה על כפתור "סגור" תביא לסגירת החלון.

#### יצירת פרופיל {#toc176}

כדי ליצור פרופיל חדש, יש ללחוץ על כפתור "חדש".

תתבקשו תחילה להקיש ש לפרופיל.  
לאחר מכן, עליכם להגדיר את אופן שימושו.  
אם ברצונכם להפעיל אותו בידני, סמנו זאת ישירות. 
זוהי ברירת המחדל.
אחרת, בחרו בסוג התנאי שיעלה את הפרופיל באופן אוטומטי. 
אם לא נתתם שם לפרופיל, שם התנאי ייכנס אל תוך שם הפרופיל. נושא התנאים יפורט להלן  [below](#ConfigProfileTriggers)

לחיצה על כפתור האישור תיצור את הפרופיל ותסגור את תיבת הדו-שיח. מכאן, תוכלו לעבור  לעריכה מחדש של הפרופיל.

#### הפעלה ידנית {#ConfigProfileManual}

ההפעלה הידנית של פרופיל נעשית על ידי לחיצה על הכפתור המתאים בתיבת הדו-שיח.
מרגע שפרופיל הופעל ידנית, פרופילים אחרים יוכלו עדיין לעלות בעקבות מילוי התנאים הקובעים את תפקודם אך הגדרות הפרופיל שנבחר ידנית יגברו על הגדרות פרופילים אלו.
נניח, לדוגמה, כי בפרופיל המופעל אוטומטית,  הגדרת הקראת הקישורים נמצאת במצב פעיל אך כבויה בהגדרות הפרופיל הידני. במצב זה, הקישורים לא יוקראו.
למרות זאת, אם הפרופיל האוטומטי כולל בחירת קול מסויים אך לא בוצעה בחירה כזאת בפרופיל הידני, הפעלת הפרופיל המותנה תשנה את קול הדיבור שבשימוש.
כל שינוי שתיצרו בהגדרות יחול על הפרופיל המופעל ידנית.
ניתן לבטל את פעילות הפרופיל הידני מתוך תפריט הפרופילים על ידי לחיצה על כפתור  הקובע את הפסקת פעילותו של הפרופיל.

#### תנאים {#ConfigProfileTriggers}

לחיצה על כפתור התנאים מאפשרת לבחור פרופילים שונים שיופעלו בעת מילוי התנאים הללו.

רשימת התנאים הקיימים כוללת את הרכיבים הבאים :

* יישום שבפוקוס : הפרופיל יופעל כשהיישום יתפוס פוקוס
* הקראה רציפה : הפרופיל יופעל בעת התחלת הקראה רציפה

כדי לשנות את הפרופיל שיופעל כתוצאה ממילוי התנאים, יש לבחור תחילה את התנאי הרצוי ולאחר מכן את הפרופיל שיופעל.
ניתן גם לבחור בהגדרות הרגילות אם שום פרופיל מיוחד אינו קשור לתנאים שנבחרו.

לחיצה על כפתור "סגור" תחזיר את הפוקוס להגדרת הפרופילים.

#### עריכת פרופיל {#toc179}

אם פרופיל הופעל ידנית, כל השינויים שיבוצעו בהגדרות יישמרו בתוכו.  
אחרת, השינויים שבוצעו יישמרו בפרופיל האחרון שהופעל על פי תנאים.
לדוגמה, אם שייכתם פרופיל לפינקס הרשימות ואתם מעבירים את הפוקוס ליישום זה,  כל השינויים שתבצע יישמרו לפרופיל זה. 
אם שום פרופיל לא הופעל, השינויים יישמרו אל תוך ההגדרות הכלליות הקיימות.

כדי לערוך פרופיל המשויך להקראה ברצף, עליכם לגרום תחילה ל[הפעלה ידנית](#ConfigProfileManual) של הפרופיל.

#### ביטול זמני של ההתניות {#toc180}

יש מצבים שבהם כדאי לבטל זמנית את כל ההתניות. 
לדוגמה,  אם ברצונכם לערוך את הפרופיל המופעל ידנית או את ההגדרות הכלליות, עדיף ששום התנייה לא תפריע לכם באמצע.
לשם כך, יש לפתוח את תיבת הדו-שיח של הגדרת הפרופילים, ולסמן את התיבה המתייחסת לביטול הזמני של כל ההתניות.

### מיקום קובצי ההגדרות {#toc181}

הגרסה הניידת של NVDA שומרת את כל קובצי ההגדרות, התוספים ומנהלי ההתקנים בתיקיה userConfig הנמצאת בתיקיית NVDA

הגרסה המותקנת שומרת את קובצי ההגדרות, התוספים ומנהלי ההתקנים בתיקיה מיוחדת ל- NVDA והנמצאת בתוך ספריית המשתמש של מערכת ההפעלה.
פירוש הדבר שכל משתמש אחר במחשב יכול להזיק את ההגדרות הפרטיות  שלו בתכנת NVDA
כדי לבחון את התיקייה הפרטית שלכם, יש לפתוח את תפריט התחל, לגשת לכל התוכניות,  ובספריית NVDA, למצוא את תיקיית הגדרות המשתמשים.

ההגדרות החלות על מסך ההתחברות ועל המסכים המוגנים שמורות בתיקיית userConfig בתוך תיקיית ההתקנה של NVDA
באופן כללי, אין לשנות דבר בתוך תיקייה זו.
כדי לשנות את ההגדרות החלות על מסך ההתחברות, עליכם לבחור את ההגדרות הרצויות לכם כאילו אתם מחוברים כבר למערכת ההפעלה, לשמור את ההגדרות, וללחוץ על הכפתור המתייחס ל"שימוש בהגדרות האחרונות שנשמרו גם בעת התחברות למערכת ההפעלה". כפתור הנמצא בהגדרות הכלליות.

## כלים נוספים {#toc182}
### מציג הדיווחים {#toc183}

כלי זה מאפשר לצפות בכל האירועים שקרו מאז שהרצת את NVDA ועד עכשיו. 

בנוסף לקריאה הסתמית, ניתן לשמור עותק של  הדו"ח ולרענן את מציג האירועים כך שהוא יציג מעתה רק את האירועים שקרו מאז הפתיחה האחרונה.
פעולות אלה אפשריות מתוך תפריט מציג הדיווחים.

### מציג ההקראות {#toc184}

כלי זה מאפשר למפתחים ולאנשים רואים להתרשם משטף מלל הדיבור שתכנת NVDA משמיע למשתמש עם עיוורון.

ניתן להפעיל את הכלי על ידי סימון התיבה המתאימה בתפריט "מציג ההקראות" בתפריט ,כלים".
יש לבטל את הסימון כדי לסגור את הכלי.

כשתכונה זו מופעלת, רשימת ההקראות מתעדכנת כל הזמן ומציגה תחילה את המחרוזות האחרונות שהוקראו. 
אם נלחץ על הרשימה או נעביר את הפוקוס אליה, המערכת תחדל להוסיף מחרוזות לרשימה וזאת כדי לאפשר בדיקה והעתקה של החומר ללא הפרעה. 
חלון מציג ההקראות ינסה להפתח באותו מיקום שבו נסגר לאחרונה.

בעת שמציג ההקראות מופעל, הוא מתעדכן כל זמן להציג את הטקסט העדכני ביותר שנאמר.
עם זאת, אם תלחצו או תתמקדו במציג, תכנת  NVDA תופסק זמנית מעדכון הטקסט, כך שהנכם יכולים לבחור בקלות או להעתיק את התוכן הקיים.

ניתן להגדיר קיצור דרך להפעלה ולביטול של התכנה בתפריט [הגדרת מחוות](#InputGestures).

### ניהול תוספים {#toc185}

בתפריט "כלים" תמצא את מנהל התוספים המאפשר להוסיף, למחוק, להפעיל ולבטל תוספים לשימוש NVDA.
תוספים אלה מפותחים על ידי הקהילה ומטרתם להוסיף תכונות חדשות לתפקוד של התכנה כולל יישומים נבחרים, תוך כדי שינוי ההקראה או שינוי תצוגת הברייל או שניהם יחד.

התפריט מציג רשימה של כל התוספים המותקנים כרגע בתיקיית המשתמש. 
עבור כל תוסף, מופיע שמו,  מצבו, מספר הגרסה ושם המפתח.  ניתן גם לקבל תיאור וכתובת אינטרנט עבור התוסף על ידי לחיצה על הכפתור "אודות" בתפריט התוספים.
כפתור "עזרה על התוסף" מציג מסך עזרה אם יש כזה.

כפתור "התקן תוספים" מאפשר לצפות במכלול התוספים הקיימים באינטרנט.  
הכפתור מביא לפתיחת [דף האינטרנט](https://addons.nvda-project.org/).
להלן השלבים להתקנת תוסף ישירות מתוך הדפדפן אם תכנת NVDA כבר מותקנת על המחשב. 
אם היא אינה מותקנת, יש לשמור את ערכת התקנת התוספים ולפעול בהתאם להנחיות הבאות.

אם כבר הורדת תוסף, לחץ על כפתור "התקן". 
תוכלו לעיין במחשב או ברשת כדי למצוא את ערכת ההתקנה עבור התוסף הרצוי.
לחצו על כפתור "פתח" כדי להתחיל בהתקנה.

לאחר ההורדה NVDA תבקש אישור על רצונכם להתקין את התוסף.
זכרו כי פעולת התוספים תחת NVDA  היא בלתי-מוגבלת. פירוש הדבר שבאופן תיאורטי, כל תוסף יכול לגשת לתיקיות הפרטיות שלך ולשלוף מידע משם. לכן,  עבור הגרסה המותקנת על המחשב, חשוב להתקין אך ורק את התוספים הבאים ממקורות נאמנים.
כדי שהתוסף יופעל, יש להריץ את NVDA מחדש.  
בינתיים, התוסף יופיע ברשימה במצב "מותקן"  בלבד.

כדי להסיר תוסף,  בחרו אותו מהרשימה ולחצו על כפתור "הסר". 
NVDA תבקש אישור על הפעולה.
בדומה למצב בהתקנה, הפעולה תושלם רק לאחר הרצת NVDA מחדש. 
בינתיים, התוסף יופיע ברשימה במצב "הוסר".

כדי לבטל פעולה של תוסף, בחרו אותו מהרשימה ולחצו "בטל"' NVDA תשאל האם אתם מעוניינים לעשות זאת.
כדי לחדש את פעולתו, לחצו על "הפעל".
ניתן לבטל פעולת תוסף במקרה שהוא במצב "בריצה" או "מופעל"  וניתן להפעיל אותו אם הוא במצב "מושהה" או "לא פעיל".
לחיצה על כפתור ההפעלה והביטול תביא להצגת המצב החדש של התוסף כשתכנת NVDA תופעל מחדש.
כל השינויים בעניין זה דורשים הפעלה מחדש של NVDA.

ניתן לסגור את מנהל התוספים בלחיצה על כפתור "סגור".
לאחר התקנה, הסרה או שינוי מצב של תוסף, NVDA שואלת אם ברצונכם להריץ אותה מחדש כדי שהשינויים יחולו.

בגרסאות קודמות של התכנה, היתה אפשרות להעתיק ערכות של תוספים ישירות אל תוך תיקיית NVDA. 
בגרסה הנוכחית, פעולה זו עדיין אפשרית אך התוספים החדשים לא יופיעו ברשימה. 
מומלץ תמיד להתקין את התוספים מתוך ערכות ההתקנה המקוריות. 

ניתן להגדיר קיצור דרך למנהל התוספים בתפריט [הגדרת מחוות](#InputGestures).

### פקודות פייתון {#toc186}

פקודות פייתון בתפריט "כלים" מאפשרות למפתחים לאתר באגים, לבדוק את תפקוד התכנה,  ולבחון את רמת הנגישות של יישומים שונים.
למידע נוסף בנושא פקודות פייתון, יש לעיין במדריך למפתחים ב[כתובת אתר NVDA](https://community.nvda-project.org/wiki/Development).

### טעינה מחדש של התקנים {#toc187}

תפריט זה מאפשר למפתחים לטעון מחדש את התוספים ואת ההתקנים מבלי להריץ את NVDA מחדש.

## מנועי דיבור נתמכים {#SupportedSpeechSynths}

השורות הבאות מספקות מידע לגבי מנועי הדיבור הנתמכים על ידי NVDA
ניתן לרכוש ולהוריד מנועי דיבור נוספים על בסיס מסחרי. למידע נוסף על כך, יש לעיין בכתובת [https://www.nvda-project.org/wiki/ExtraVoices](https://www.nvda-project.org/wiki/ExtraVoices).

### eSpeak NG {#toc189}

[מנוע הדיבור eSpeak NG](https://github.com/espeak-ng/espeak-ng)
אינו דורש התקנה מיוחדת והוא מופעל ישירות על ידי NVDA בעת ההתקנה. כברירת מחדל
היתרון בשימוש במנוע דיבור זה נעוץ בעובדה שהוא מאפשר עבודה ישירה מתוך התקן USB נשלף. גם על מחשבים אחרים.

eSpeak NG תומך בכ43 שפות שונות. 
עבור כל שפה, ניתן לבחור בניבים שונים המאפשרים לגוון את אופי הדיבור.

קיימות גם גרסאות רבות שניתן לשנות בהן את הצליל של הקול.

### Microsoft Speech API version 4 (SAPI 4) {#toc190}

זוהי השיטה הישנה של מייקרוסופט בתחום הדיבור. 
NVDA עדיין תומכת בה עבור המשתמשים שברשותם מנועי דיבור מסוג זה. 
יש לזכור כי מייקרוסופט אינה תומכת יותר בתקינה זו. 

אם בחרתם במנוע דיבור זה עבור NVDA, כל הקולות המוגדרים עבורו יופיעו בתוך תפריט [הגדרות קול](#VoiceSettings) וכן ב[בורר ההגדרות](#SynthSettingsRing)) 

### Microsoft Speech API version 5 (SAPI 5) {#toc191}

זוהי התקינה הקובעת כיום בחברת מייקרוסופט עבור מנועי הדיבור. אלה ניתנים לרכישה או להורדה ממספר רב של ספקי תכנה. סביר להניח כי מערכת ההפעלה שלכם מספקת מנוע דיבור אחד לפחות מסוג זה.
אם בחרתם במנוע דיבור זה עבור NVDA, כל הקולות המוגדרים עבורו יופיעו בתוך תפריט
[הגדרות קול](#VoiceSettings) וכן ב[בורר ההגדרות](#SynthSettingsRing)) 

### Microsoft Speech Platform {#toc192}

מטרת  Microsoft Speech Platform  היא לספק מסגרת לפיתוח תכנות דיבור מבוססות אינטרנט. 
הקולות המפותחים בשיטה זו נגישים לNVDA

כדי להשתמש בקולות אלה עליכם להתקין שני התקנים מהכתובות הבאות :

* Microsoft Speech Platform - Runtime (Version 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Version 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * דפי אינטרנט אלה כוללים מידע רב אודות זיהוי קולי וטקסט לדיבור. ניתן להוריד ערכת התקנת קולות, כגון :
 MSSpeech_TTS_en-US_ZiraPro.msi
 בניב עבור קול אמריקאי.

### Audiologic Tts3 {#toc193}

מנוע דיבור מסחרי זה מיועד לאיטלקית בלבד.  
NVDA יוכל להשתמש בו רק לאחר התקנתו.
למידע נוסף, יש לעיין בדף [www.audiologic.it](http://www.audiologic.it).

מנוע זה אינו מאפשר איות.

### Nuance Vocalizer for NVDA {#toc194}

מנוע הדיבור  Nuance Vocalizer מספק קולות איכותיים . הוא פרי עבודתה של חברת
Nuance Communications, Inc. 
חברת  Tiflotecnia, Lda פיתחה ערכת התקנה למנוע דיבור זה במיוחד עבור NVDA

מנוע דיבור זה מכיל כ50 קולות המסוגלים לדבר בכ30 שפות שונות.  כל הקולות ניתנים להפעלה על הגרסה הניידת של NVDA למידע נוסף, יש לעיין בכתובת :[www.vocalizer-nvda.com](https://www.vocalizer-nvda.com/). 
אחוז מסויים מפדיון המכירה של מנוע דיבור זה נתרם על ידי החברה ל NV Access  לשם פיתוח שוטף של תכנת NVDA

## צגי ברייל נתמכים {#SupportedBrailleDisplays}

פרק זה מכיל מידע לגבי צגי הברייל הנתמכים על ידי NVDA

### Freedom Scientific Focus/PAC Mate Series {#toc196}

כל הדגמים מסדרה זו של חברת [Freedom Scientific](https://www.freedomscientific.com/)
נתמכים והם מתחברים למחשב דרך USB  ו BlueTooth  נדרשת התקנת ההתקן של הצג. 
ניתן להוריד התקנים בכתובת :https://www2.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp. 
אף על פי בדף מוזכר אך ורק צג Focus Blue ההתקן תומך גם בצג הPacMate תחת Windows64 סיביות. 
ייתכן כי תצטרכו להתקין את ההתקן מחדש עבור NVDA גם אם קורא מסך אחר כבר עשה זאת.

כברירת מחדל, NVDA מזהה אוטומטית את הצגים האלה ומתחבר אליהם באמצעות חיבור USB או חיבור BlueTooth
למרות זאת, תוכל לאלץ את NVDA לעבוד עם החיבור שאתם מעוניינים בו. 
תכונה זו מועילה במקרה שאתם מעוניינים לעבוד עם הצג דרך חיבור אלחוטי תוך כדי טעינת המכשיר באמצעות - USB

להלן הגדרות המקשים והכפתורים עבור הצג. 
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל ברייל אחורה |מתג מס' 1 (מעל תא הברייל הראשון)|
|סרגל ברייל קדימה |מתג מס' 20 או 40 או 80 (מעל התא האחרון)|
|סרגל ברייל אחורה |LeftAdvanceBar|
|סרגל ברייל קדימה |RightAdvanceBar|
|מיתוג מצב ההצמדה |leftGDFButton+rightGDFButton|
|מיתוג גלגלת שמאל |leftWizWheelPress|
|מעבר אחורה בעזרת גלגלת שמאל |leftWizWheelUp|
|מעבר קדימה בעזרת גלגלת שמאל |leftWizWheelDown|
|מיתוג גלגלת ימין |RightWizWheelPress|
|מעבר אחורה בעזרת גלגלת ימין |RightWheelUp|
|מעבר קדימה בעזרת גלגלת ימין |RightWheelDown|
|גישה ישירה לתוים |מתגים מעל התאים|
|backspace |dot7|
|enter |dot8|
|shift+tab |brailleSpaceBar+dot1+dot2|
|tab |brailleSpaceBar+dot4+dot5|
|upArrow |brailleSpaceBar+dot1|
|downArrow |brailleSpaceBar+dot4|
|control+leftArrow |brailleSpaceBar+dot2|
|control+rightArrow |brailleSpaceBar+dot5|
|leftArrow |brailleSpaceBar+dot3|
|rightArrow |brailleSpaceBar+dot6|
|home |brailleSpaceBar+dot1+dot3|
|end |brailleSpaceBar+dot4+dot6|
|control+home |brailleSpaceBar+dot1+dot2+dot3|
|control+end |brailleSpaceBar+dot4+dot5+dot6|
|alt |brailleSpaceBar+dot1+dot3+dot4|
|alt+tab |brailleSpaceBar+dot2+dot3+dot4+dot5|
|escape |brailleSpaceBar+dot1+dot5|
|windows |brailleSpaceBar+dot2+dot4+dot5+dot6|
|רווח |brailleSpaceBar|
|windows+d  הקטנת כל החלונות |brailleSpaceBar+dot1+dot2+dot3+dot4+dot5+dot6|
|דיווח שורה נוכחית |brailleSpaceBar+dot1+dot4|
|NVDA |brailleSpaceBar+dot1+dot3+dot+dot5 ממשק|

הדגמים החדשים של Focus מצויידים עתה גם בפס מתנדנד מסול Rocker להלן הפעולות המוגדרות במקשים אלה :

| פעולה |מקש/כפתור|
|---|---|
|שורה קודמה |leftRockerBarUp, rightRockerBarUp|
|שורה הבאה |leftRockerBarDown, rightRockerBarDown|

לFocus 80 בלבד :

| פעולה |מקש/כפתור|
|---|---|
|סרגל ברייל אחורה |leftBumperBarUp, rightBumperBarUp|
|סרגל ברייל קדימה |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA BC640/680 {#toc197}

שני הצגים האלה  של  [Optelec](https://www.optelec.com/)
נתמכים הן באמצעות חיבור USB והן באמצעות חיבור BlueTooth
אין צורך בהתקנה כלשהי ומספיק לחבר את הצג למחשב ולהגדיר אותו בתכנת NVDA.

אף על פי שצגים אלה מצוידים במקלדת ברייל, לא ניתן להשתמש בה בעזרת NVDA
לכן אין עניין בטבלת קלט הברייל לגביהם.

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל ברייל אחורה |t1 or etouch1|
|שורה קודמת |T2|
|הצמדה לפוקוס |t3|
|שורה הבאה |T4|
|סרגל ברייל קדימה |t5 or etouch3|
|גישה ישירה לתווים |מתגים מעל התאים|
|תחילת מסך הסריקה |t1+t2|
|סוף מסך הסריקה |t4+t5|
|מתוג בין מצבי הניווט |t1+t3|
|שורת כותרת |etouch2|
|שורת מצב |etouch4|
|shift+tab key |sp1|
|alt |sp2|
|escape |sp3|
|tab |sp4|
|upArrow |spUp|
|downArrow |spDown|
|leftArrow |spLeft|
|rightArrow |spRight|
|enter |spEnter|
|תאריך ושעה |sp1+sp2|
|ממשק NVDA |sp1+sp3|
|Windows+D הקטנת כל החלונות |sp1+sp4|
|windows+b מעבר למגש המערכת |sp3+sp4|
|windows |sp2+sp3|
|alt+tab |sp2+sp4|
|control+home |t3+spUp|
|control+end |t3+spDown|
|home |t3+spLeft|
|end |t3+spRight|

<!-- KC:endInclude -->

### Handy Tech {#toc198}

NVDA תומכת בכל הצגים של  [Handy Tech](https://www.handytech.de/) 
בין בחיבור USB בין אם בחיבור BlueTooth, לחיבור USB דרושה התקנה של ההתקן המתאים.

לעת עתה, לא ניתן לבצע קלט ברייל.

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל ברייל אחורה |left, up|
|סרגל ברייל קדימה |right, down|
|שורה קודמת |b4|
|שורה הבאה |b5|
|גישה ישירה לתווים |מתגים מעל התאים|
|shift+tab |esc|
|alt |b2+b4+b5|
|escape |b4+b6|
|tab |enter|
|enter |esc+enter|
|upArrow |leftSpace|
|downArrow |rightSpace|
|ממשק NVDA |b2+b4+b5+b6|
|הגדרות של Handy Tech |b4+b8|

<!-- KC:endInclude -->

### MDV Lilli {#toc199}

NVDA תומכת בצג הברייל Lilli של   [MDV](https://www.mdvbologna.it/) 
אין צורך בהתקנת התקן עבור צג ומספיק לחבר אותו למחשב ולהגדיר אותו בתפריטי NVDA
אין צורך בהתקנה כלשהי ומספיק לחבר את הצג למחשב ולהגדירו בתכנת NVDA

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה || LF|
|סרגל הברייל קדימה |RG|
|שורה קודמת |UP|
|שורה הבאה |DN|
|גישה ישירה לתווים |מתגים מעל התאים|
|shift+tab key |SLF|
|tab key |SRG|
|alt+tab key |SDN|
|alt+shift+tab key |SUP|

<!-- KC:endInclude -->

### Baum/Humanware/APH/Orbit {#toc200}

מספר צגים של  [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/), [APH](https://www.aph.org/) וכן [Orbit](https://www.orbitresearch.com/) 
נתמכים באמצעות חיבור USB, BlueTooth  או טורי ואלה הם :

* Baum: SuperVario, PocketVario, VarioUltra, Pronto!
* HumanWare: Brailliant, BrailleConnect
* APH: Refreshabraille
* Orbit: Orbit Reader 20

ייתכן כי צגים נוספים של חברת Baum  עשויים לעבו  עם NVDA אך לא נעשו נסיונות לבדוק זאת.

עבור הצגים העובדים עם USB אבל לא עם HID,  עליכם להתקין תחילה את ההתקן המסופק על ידי היצרן.
VarioUltra וכן  Pronto! תומכים בשיטת  HID. Refreshabraille וכן Orbit Reader 20 
עשויים גם הם לעבוד עם יציאה זו אך יש להגדירה תחילה.

החיבור מסוג  USB serial של צג Orbit Reader 20 נתמך כרגע רק במערכת ההפעלה Windows 10.
מומלץ להשתמש בחיבור USB HID  עבור צג זה.

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |D2|
|סרגל הברייל קדימה |d5|
|שורה קודמת |d1|
|שורה הבאה |d3|
|גישה ישירה לתווים |מתגים מעל התאים|

עבור הצגים בעלי מוט חיווי :

| פעולה |מקש/כפתור|
|---|---|
|upArrow key |up|
|downArrow key |down|
|leftArrow key |left|
|rightArrow key |right|
|enter key |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#toc201}

NVDA תומכת בצג hedo ProfiLine USB  של  [hedo Reha-Technik](https://www.hedo.de/) 
עליכם להתקין תחילה את ההתקנים המסופקים על ידי היצרן.

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |K1|
|סרגל הברייל קדימה |K3|
|שורה קודמת |B2|
|שורה הבאה |B5|
|גישה ישירה לתווים |מתגים מעל התאים|
|מיתוג מצב ההצמדה |K2|
|הקראה רציפה |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#toc202}

NVDA תומכת בצג hedo MobilLine USB  של  [hedo Reha-Technik](https://www.hedo.de/) 
עליכם להתקין תחילה את ההתקנים המסופקים על ידי היצרן.

להלן פעולות עבור מסך עם NVIDIA. 
אנא עיינו בתיעוד התצוגה עבור תיאורים של המקומות שבהם ניתן למצוא מקשים אלו.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל ברייל אחורה |K1|
|סרגל הברייל קדימה |K3|
|שורה קודמת |B2|
|שורה הבאה |B5|
|גישה ישירה לתוים |מתגים מעל התאים|
|מיתוג מצב ההצמדה |K2|
|הקראה רציפה |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant BI/B Series {#toc203}

הצגים Brailliant BI  וB  של  [HumanWare](https://www.humanware.com/), לרבות BI 32, BI 40  B 80, מתחברים דרך USB או  BlueTooth עבור חיבור USB תחת פרוטוקול HumanWare, 
עליכם להתקין תחילה את ההתקן המסופק על ידי היצרן.
עבור פרוטוקול של OpenBraille אין צורך בהתקנת התקן נוסף.

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |left|
|סרגל הברייל קדימה |right|
|שורה קודמת |up|
|שורה הבאה |down|
|גישה ישירה לתווים |מתגים מעל התאים|
|מיתוג מצב ההצמדה |up+down|
|upArrow key |רווח+dot1|
|downArrow key |רווח+dot4|
|leftArrow key |רווח+dot3|
|rightArrow key |רווח+dot6|
|ממשקNVDA |c1+c3+c4+c5 (command n)|
|shift+tab key |רווח+dot1+dot3|
|tab key |רווח+dot4+dot6|
|alt key |רווח+dot1+dot3+dot4 (רווח+m)|
|escape key |רווח+dot1+dot5 (רווח+e)|
|enter key |dot8|
|windows+d key  הקטנת כל החלונות |c1+c4+c5 d)|
|windows key |רווח+dot3+dot4|
|alt+tab key |רווח+dot2+dot3+dot4+dot5 (רווח+t)|
|הקראה רציפה |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

### HIMS Braille Sense/Braille EDGE/Smart Beetle Series {#toc204}

NVDA  תומכת בצגים Braille Sense, Braille EDGE וכן Smart Beetle, של  [Hims](https://www.hims-inc.com/) בחיבור USB או BlueTooth.
עבור חיבור USB יש להתקין תחילה את ההתקן המסופק על ידי חברת HIMS  על המחשב.
ניתן למצוא את ההתקנה בכתובת : https://www.himsintl.com/?c=2/13&uid=2319

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |left side scroll down|
|סרגל הברייל קדימה |right side scroll down|
|שורה קודמת |left side scroll up|
|שורה הבאה |right side scroll up|
|גישה ישירה לתווים |מתגים מעל התא|
|shift+tab key |dot1+dot2+רווח|
|alt key |dot1+dot3+dot4+רווח|
|escape key |dot1+dot5+רווח|
|tab key |dot4+dot5+רווח|
|enter key |dot8|
|backspace key |dot7|
|upArrow key |dot1+רווח|
|downArrow key |dot4+רווח|
|capsLock |dot1+dot3+dot6+רווח|
|shift+alt+tab key |advance2+advance3+advance1|
|alt+tab key |advance2+advance3|
|end key |dot4+dot6+רווח|
|Control+end key |dot4+dot5+dot6+רווח|
|home key |dot1+dot3+רווח|
|control+home key |dot1+dot2+dot3+רווח|
|leftArrow key |dot3+רווח|
|control+shift+leftArrow key |dot2+dot8+רווח+advance1|
|control+leftArrow key |dot2+רווח|
|shift+alt+leftArrow key |dot2+dot7+advance1|
|alt+leftArrow key |dot2+dot7|
|rightArrow key |dot6+רווח|
|control+shift+rightArrow key |dot5+dot8+רווח+advance1|
|control+rightArrow key |dot5+רווח|
|shift+alt+rightArrow key |dot5+dot7+advance1|
|alt+rightArrow key |dot5+dot7|
|pageUp key |dot1+dot2+dot6+רווח|
|control+pageUp key |dot1+dot2+dot6+dot8+רווח|
|control+shift+upArrow key |dot2+dot3+dot8+רווח+advance1|
|control+upArrow key |dot2+dot3+רווח|
|shift+alt+upArrow key |dot2+dot3+dot7+advance1|
|alt+upArrow key |dot2+dot3+dot7|
|shift+upArrow key |left side scroll down + רווח|
|pageDown key |dot3+dot4+dot5+רווח|
|control+pagedown key |dot3+dot4+dot5+dot8+רווח|
|control+shift+downArrow key |dot5+dot6+dot8+רווח+advance1|
|control+downArrow key |dot5+dot6+רווח|
|shift+alt+downArrow key |dot5+dot6+dot7+advance1|
|alt+downArrow key |dot5+dot6+dot7|
|shift+downArrow key |right side scroll down + רווח|
|delete key |dot1+dot3+dot5+רווח|
|f1 key |dot1+dot2+dot5+רווח|
|f3 key |dot1+dot2+dot4+dot8|
|f4 key |dot7+advance3|
|windows+b key |dot1+dot2+advance1|
|windows+d key |dot1+dot4+dot5+advance1|

<!-- KC:endInclude -->

### HIMS SyncBraille {#toc205}

NVDA תומכת בצג  SyncBraille Display  של  [HIMS](https://www.hims-inc.com/).
עליכם להתקין את ההתקן המסופק על ידי Hims על המחשב.

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |left side scroll down|
|סרגל הברייל קדימה |right side scroll down|
|גישה ישירה לתווים |מתגים מעל התאים|

<!-- KC:endInclude -->

### Seika Braille Displays {#toc206}

הצגיםe Seika Version 3, 4 ו5 בעלי (40 תאים )  וכןSeika80 (80 תאים) של  [Nippon Telesoft](https://www.nippontelesoft.com/) are supported.
נתמכים על ידי NVDA למידע נוסף על צגים אלה, יש לעיין בכתובת : https://www.seika-braille.com/.
עליך להתקין תחילה את ההתקן המסופק על ידי היצרן.

להלן הפקודות של NVDA עם צגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |left|
|סרגל הברייל קדימה |right|
|שורה קודמת |b3|
|שורה הבאה |b4|
|מיתוג מצב ההצמדה |b5|
|הקראה רציפה |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|ממשק NVDA |left+right|
|גישה ישירה לתווים |מתגים מעל התאים|

<!-- KC:endInclude -->

### Papenmeier BRAILLEX Newer Models {#toc207}

הצגים הבאים נתמכים :

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB / Bluetooth)
* BRAILLEX Live 20, BRAILLEX Live / BRAILLEX Live Plus (USB / bluetooth)

אם תכנת  BrxCom מותקנת על המחשב, NVDA  ישתמש בה.
BrxCom  מאפשרת להכניס קלט למחשב ללא תלות בקורא מסך זה או אחר.
חברת Papenmeie עומדת לשחרר גרסה המסוגלת לעבוד יחד עם NVDA. 
ניתן להכניס קלט על צגי Trio ו BRAILLEX Live .

רוב הדגמים מצויידים במוט גישה מהירה (מג"מ)  המאפשר פעולה נוחה וקלה.
ניתן להזיז את המג"מ לארבעה כיוונים שבסופם שני חיישנים. 
יוצאי דופן בנושא זה הם הצגים מסדרה C וסדרה Live.

צגי סדרה C וכן חלק מהצגים האחרים  מצויידים בשורה כפולה של מתגים. העליונה מיועדת לספק מידע לגבי העיצוב. 
לחיצה על מתג משורה זו ביחד עם המג"מ מבצעת הדמיה של פעולת מצב החיישן השני. 
בצגים מסדרת  Live  ישנה רק שורה אחת של מתגים וניתן לבצע רק הדמיה של מצב החיישן הראשון בלבד.
אפשר לבצע הדמיה של מצב החיישן השני על לחיצה בו-זמנית על מתג וע מג"מ בוזמנית בכיוון הרצוי.
ניתן לבצע שוב את הפעולה על ידי לחיצה על חץ שמאלה, ימינה, מעלה או מטה על הצג.

הפעולות הבאות מוגדרות עבור רוב הצגים :

| פעולה |מקש/כפתור|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

להלן פקודות NVDA עבור הצגים של Papenmeier  :
<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |Left|
|סרגל הברייל קדימה |right|
|שורה קודמת |up|
|שורה הבאה |dn|
|גישה ישירה לתווים |מתגים מעל התאים|
|תיאור תו במצב סריקה |l1|
|הפעלת האובייקט שמתחת לסמן הניווט |l2|
|מיתוג מצב ההצמדה |r2|
|שורת כותרת |l1+up|
|שורת מצב |l2+down|
|מעבר לאובייקט הכוללני יותר |up2|
|מעבר לאובייקט הראשון הנכלל |dn2|
|מעבר לאובייקט הקודם |left2|
|מעבר לאובייקט הבא |right2|
|מידע על עיצוב התו |upper routing row|

<!-- KC:endInclude -->

הצג Trio מצויד ב4 מקשים נוספים הממקומים בחזית המכשיר.  
להלן הסדר שלהם משמאל לימין :

* lt  מקש אגודל שמאל
* רווח
* רווח
* rt מקש אגודל ימין

מקש הRT אינו מוגדר. 
ושני מקשי הרווח משמשים כמקשי רווח.

| פעולה |מקש/כפתור|
|---|---|

<!-- KC:beginInclude -->

|backspace key |dot 7|
|enter key |dot 8|
|escape key |רווח with dot 7|
|upArrow key |רווח with dot 2|
|leftArrow key |רווח with dot 1|
|rightArrow key |רווח with dot 4|
|downArrow |רווח with dot 5|
|control key |lt+dot2|
|alt key |lt+dot3|
|control+escape key |רווח with dot 1 2 3 4 5 6|
|tab key |רווח with dot 3 7|

<!-- KC:endInclude  -->

### Papenmeier Braille BRAILLEX דגמים ישנים {#toc208}

הצגים הבאים נתמכים :

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

צגים אלה ניתנים לחיבור אך ורק דרך יציאה טורית. 
לכן יש להגדיר את היציאה לאחר בחירת הצג מתוך הרשימה.

חלק מהדגמים מצוידים במוט גישה מהירה (מג"מ)  המאפשר פעולה נוחה וקלה.
ניתן להזיז את המג"מ בארבעה כיוונים שבסופם שני חיישנים. 
לחיצה על מקשי החצים מעלה, מטה, שמאלה או ימינה ביחד עם המג"מ מבצעת את הפעולה מחדש.
עבור הצגים שאינם מצויידים במג"מ, ניתן להשתמש במקשים הנמצאים בחזית המכשיר.

באופן כללי המקשים הבאים נמצאים על צגי הברייל :

| שם |תיאור|
|---|---|
|l1 |מקש שמאל קדמי|
|l2 |מקש שמאל אחורי|
|r1 |מקש ימני קדמי|
|r2 |מקש ימני אחורי|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

להלן פקודות NVDA לשימוש עם הצגים של  Papenmeier 

<!-- KC:beginInclude -->
עבור המכשירים המצויידים במג"מ :

| פעולה |כפתור/מקש|
|---|---|
|סרגל הברייל אחורה |Left|
|סרגל הברייל קדימה |right|
|שורה קודמת |up|
|שורה הבאה |dn|
|גישה ישירה לתווים |מתגים מעל התאים|
|התו שבסמן הסריקה |l1|
|הפעלת האובייקט שבניווט |l2|
|שורת כותרת |l1up|
|שורת מצב |l2down|
|מעבר לאובייקט המכיל |up2|
|מעבר לאובייקט הפנימי הראשון |dn2|
|מעבר לאובייקט הבא |right2|
|מעבר לאובייקט הקודם |left2|
|הקראת העיצוב |Upper routing strip|

BRAILLEX Tiny:

| פעולה |מקש/כפתור|
|---|---|
|הקראת התו בסמן הסריקה |L1|
|הפעלת האובייקט שבניווט |L2|
|סרגל הברייל אחורה |Left|
|סרגל הברייל קדימה |Right|
|שורה קודמת |Up|
|שורה הבאה |Dn|
|מיתוג מצב הברייל |R2|
|מעבר לאובייקט המכיל |r1+up|
|מעבר לאובייקט הפנימי הראשון |r1+dn|
|מעבר לאובייקט הקודם |r1+left|
|מעבר לאובייקט הבא |r1+right|
|הקראת העיצוב |reportf|
|שורת כותרת |l1+up|
|שורת מצב |l2+down|

BRAILLEX 2D Screen:

| פעולה |מקש/כפתור|
|---|---|
|הקראת התו בסמן הסריקה |L1|
|הפעלת האובייקט שבניווט |L2|
|מיתוג מצב הברייל |R2|
|הקראת העיצוב |reportf|
|שורה קודמת |Up|
|סרגל הברייל אחורה |Left|
|סרגל הברייל קדימה |Right|
|שורה הבאה |Dn|
|מעבר לאובייקט הבא |left2|
|מעבר לאובייקט המכיל |up1|
|מעבר לאובייקט הפנימי הראשון |dn2|
|מעבר לאובייקט הקודם |Right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#toc209}

NVDA תומכת בצג notetakers  של   [Humanwarehttps://[www.humanware.com](http://www.humanware.com)] כשהוא מכוון לעבוד כצג ברייל המשמש כתכנת קוראת מסך.
הדגמים הבאים נתמכים :

* BrailleNote Classic (חיבור טורי בלבד)
* BrailleNote PK (חיבור טורי וBlueTooth)
* BrailleNote MPower  (חיבור טורי וBlueTooth)
* BrailleNote Apex (חיבור USB וBlueTooth)

כדי לעבוד עם BrailleNote כצג ברייל תחת NVDA יש להגדיר זאת בתפריטים של המכשיר עצמו בסעיף b raille terminal port 
יש לעיין בחומר שסופק עם המכשיר.
יש לבצע פעולה מקבילה בתפריטים של NVDA . 
אם המכשיר מתחבר בUSB או בBlueToth  אפשר לכוון את ההגדרה ל"אוטומטי", "USB" או ""BlueTooth" לפי הצורך.
אם החיבור הנחוץ הוא יציאה טורי או התקן USB לטורי, ייתכן שתצטרכו לבצע הגדרה ידנית של היציאה מתוך רשימת היציאות הקיימות במחשב.

בחיבור USB יש להתקין את ההתקן שסופק על ידי היצרן, על מנת לחבר את BrailleNote Apex .

להלן פקודות NVDA לשימוש בצגים אלה :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן.

<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |Back|
|סרגל הברייל קדימה |Advance|
|שורה קודמת |Previous|
|שורה הבאה |Next|
|גישה ישירה לתווים |מתגים מעל התאים|
|מיתוג מצב הברייל |previous+next|
|Up arrow key |רווח+dot1|
|Down arrow key |רווח+dot4|
|Left Arrow key |רווח+dot3|
|Right arrow key |רווח+dot6|
|Page up key |רווח+dot1+dot3|
|Page down key |רווח+dot4+dot6|
|Home key |רווח+dot1+dot2|
|End key |רווח+dot4+dot5|
|Control+home keys |רווח+dot1+dot2+dot3|
|Control+end keys |רווח+dot4+dot5+dot6|
|רווח key |רווח|
|Enter key |רווח+dot8|
|Backרווח key |רווח+dot7|
|Tab key |רווח+dot2+dot3+dot4+dot5 (רווח+t)|
|Shift+tab keys |רווח+dot1+dot2+dot5+dot6|
|Windows key |רווח+dot2+dot4+dot5+dot6 (רווח+w)|
|Alt key |רווח+dot1+dot3+dot4 (רווח+m)|
|מיתוג מצב עזרה |רווח+dot2+dot3+dot6 (רווח+lower h)|

<!-- KC:endInclude -->

### EcoBraille {#toc210}

NVDA תומכת בצגים של EcoBraille [ONCE](https://www.once.es/).
הדגמים הבאים נתמכים :

* EcoBraille 20
* EcoBraille 40
* EcoBraille 80
* EcoBraille Plus

בהגדרות הברייל של NVDA ניתן להגדיר את היציאה הטורית שאליה מחובר הצג.

להלן הפקודות של NVDA לשימוש בצגים של EcoBraille :
יש לעיין בספרות המסופקת עם הצג כדי לאתר את המקשים או הכפתורים המוזכרים כאן. לשם כך, נא עיין [בכתובת](:ftp://ftp.once.es/pub/utt/bibliotecnia/Lineas_Braille/ECO/)

<!-- KC:beginInclude -->

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |T2|
|סרגל הברייל קדימה |T4|
|שורה קודמת |T1|
|שורה הבאה |T5|
|גישה ישירה לתווים |מתגים מעל התאים|
|הפעלת האובייקט שבניווט |T3|
|מצב סריקה הבא |F1|
|מעבר לאובייקט המכיל |F2|
|מצב סריקה הקודם |F3|
|מעבר לאובייקט הקודם |F4|
|הקראת האובייקט הנוכחי |F5|
|מעבר לאובייקט הבא |F6|
|מעבר לאובייקט שבפוקוס |F7|
|מעבר לאובייקט הפנימי הראשון |F8|
|העברת הפוקוס או סמן המקלדת לאובייקט שבניווט |F9|
|המיקום הנוכחי |F0|
|מיתוג בין מצבי הברייל |A|

<!-- KC:endInclude -->

### BRLTTY {#toc211}

[BRLTTY](https://mielke.cc/brltty/)  היא תכנית מחשב מיוחדת המאפשרת שימוש בצגים רבים נוספים. 
לשם כך, יש להוריד  אותה ב[כתובת BRLTTY for Windows](https://brl.thefreecat.org/brltty/).
יש להוריד את ערכת ההתקנה העדכנית ביותר תחת שם במבנה דומה לביטוי : brltty-win-4.2-2.exe.
בעת הגדרת היציאה הרצויה, יש לשים לב בדייקנות לדרישות של היצרן במקרה שהצג מחובר בחיבור USB או שההתקן למכשיר כבר הותקן על המחשב. 

לעת עתה, BRLTTY אינה תומכת בקלט ברייל עבור הצגים המצוידים במקלדת ברייל. 
לכן,אין משמעות לקיומה של טבלת קלט תחת NVDA.

להלן פעולות BRLTTY עבור NVDA
ניתן למצוא פירוט של המקשים לשימוש תחת  [BRLTTY בכתובת](https://mielke.cc/brltty/doc/KeyBindings/) 
kc:beginInclude

| פעולה |מקש/כפתור|
|---|---|
|סרגל הברייל אחורה |fwinlt  (סרגל לשמאל)|
|סרגל הברייל קדימה |fwinr (סרגל לימין)|
|שורה קודמת |lnup (סרגל למעלה)|
|שורה הבאה |lndn  (סרגל למטה)|
|גישה ישירה לתווים |מתגים מעל התאים|

<!-- KC:endInclude -->

## סוגי פקדים ומצבם {#toc212}

הקיצורים הבאים מסמלים את הפקדים ואת מצבם :

| קיצור |תיאור|
|---|---|
|כ |כפתור|
|ק |תיבה משולבת/קומבו|
|תס |תיבת סימון|
|תש |תיבת דו-שיח|
|תע |תיבת עריכה|
|תמ |תמונה/אובייקט גראפי|
|C1, C2... |מספר עמודה בטבלה|
|R1, R2 |מספר שורה בטבלה|
|H1, H2... |כותרת ברמה 1 וכו'|
|ק |קישור|
|רש |רשימה|
|קנ |קישור נשהופעל בעבר|
|תפ |תפריט|
|תפ |סרגל תפריט|
|כב |כפתור בחירה|
|טב |טבלה|
|עץ |עץ|
|עץ1, עץ2... |רמה 1,2... בעץ|
|`-----` |מפריד|

להלן קיצורי המצבים המוגדרים :

| קיצור |מצב|
|---|---|
|... |מופיע כשיש לאובייקט תכונה של השלמה אוטומטית|
|( ) |תצוגה עבור אובייקט לא פעיל או לא מסומן|
|(x) |תצוגה עבור אובייקט פעיל או מסומן|
|(-) |תצוגה עבור אובייקט פעיל או מסומן למחצה|
|- |תצוגה עבור אובייקט הניתן להרחבה|
|+ |תצוגה עבור אובייקט הניתן לכיווץ|
|CLK |תצוגה עבור אובייקט שניתן להפעיל אותו בעזרה קליק שמאל|
|לקב |תצוגה עבור אובייקט במצב לקריאה בלבד|
|(נ) |תצוגה עבור אובייקט נבחר|
|SubMnu |תצוגה עבור אובייקט המסוגל להקפיץ תפריט|

## הבטים מתקדמים {#toc213}
### אפשרויות שורת הפקודה {#CommandLineOptions}

ניתן להוסיף מספר אופציות לשורת הפקודה המריצה את NVDA. 
אין הגבלה למספר האפשרויות שניתן לכתוב בו זמנית בשורה. 
אפשר להגדיר את האוציות ביעד של סמל קיצור דרך על שולחן העבודה. 
ניתן לעשות זאת גם מתוך שורת ההרצה של Windows  או משורת הפקודה של DOS, יש להקיש רווח לפני כל אופציה.
לדוגמה, הרצת ההתקנה כוללת אופציה -R המנחה את התכנה לסגור את עצמה לפני ההרצה.
אופציה שימושית נוספת היא --disable-addons המורה לNVDA לרוץ ללא תוספים.
אפשרות זו שימושית אם אתם מעוניינים לבדוק אם תוסף מסויים גורם לתופעה בלתי רצויה בהתנהגותה של NVDA ולפתור את הבעיה בהתאם.

ניתן להפסיק את פעולתה של NVDA באמצעות הפקודה

nvda -q

לחלק מהאופציות יש גרסה מקוצרת וגרסה ארוכה. לחלק אחר מהן יש גרסה ארוכה בלבד.
עבור אלו עם הגרסה הקצרה ניתן להפעיל כך:

|NVDA -RM |שילוב זה מאפשר להריץ את NVDA מחדש ללא צלילי פתיחה ויציאה|
|nvda -rm --disable-addons  דומה לקודמת, אך ללא תוספים|

קיימות אופציות המאפשרות הקשת פרמטרים נוספים, לדוגמה, נתיב לתיקיה המכילה את הגדרות המשתמש.
לשם כך, יש להקיש את הפרמטר לאחר סימן רווח עבור הפקודות המקוצרות ולאחר סימן שווה עבור הפקודות הארוכות. להלן מספר דוגמאות :

|nvda -l 10 |הרצה במצב איתור באגים עבור המפתחים|
|nvda --log-file=c:\nvda.log |הפניית קובץ הדיווחים לנתיב שצויין|
|nvda --log-level=20 -f c:\nvda.log |הרצה במצב איתור באגים עבור המפתחים עם הפניית קובץ הדיווחים לנתיב שצויין|

להלן מספר אופציות נוספות להרצת NVDA

| מקוצר |ארוך |תיאור|
|---|---|---|
|-h |--help |הצגת מסך העזרה לשורת הפקודה ויציאה|
|-q |--quit |יציאה  וסגירה של NVDA|
|-r |--replace |סגירת הגרסה שכרגע בריצה והרצה מחדש על פי האופציות של הפקודה הנוכחית|
|-k |--check-running |בדיקת מצב הריצה של NVDA. מחזיר 0 אם התכנה מופעלת ו1 אם לא|
|-f LOGFILENAME |--log-file=LOGFILENAME |קביעת הנתיב לכתיבת קובץ הדיווחים|
|-l LOGLEVEL |--log-level=LOGLEVEL |קביעת רמת הדיווח לפי הערכים הבאים : 10 רמה נמוכה ביותר, 20 מידע, 30  הזהרה, 40  שגיאות, 50 שגיאות קריטיות. ברירת המחדל היא רמת ההזהרות.|
|-c CONFIGPATH |--config-path=CONFIGPATH |קביעת הנתיב שבו נמצא קובץ ההגדרות הרצוי להרצה הנוכחית|
|-m |--minimal |הרצה ללא צלילים, ללא ממשק, ללא הודעות פתיחה, וכו'|
|-s |--secure |מצב בטוח (ללא פקודות פייתון)|
|ללא |--disable-addons |הרצה ללא תוספים|
|ללא |--no-sr-flag |אל תשנה את הדגלים הבסיסיים של ההרצה|
|ללא |--install |התקנה והרצה של העותק שזה עתה הותקן|
|ללא |--install-silent |התקנה ללא הרצה מחדש|

## מידע נוסף {#toc215}

למידע נוסף, מומלץ לבקר באתר של NVDA בכתובת  NVDA_URL.
דף זה מספק תיעוד נוסף, תמיכה טכנית וקישורים לקהילת הידע.
כמו כן, האתר מספק מידע רב לגבי התפתחותה של NVDA ולגבי המשאבים העומדים לרשותה.

