# Újdonságok az NVDA-ban


## 2024.3

Az NVDA elindulás után most már figyelmeztet, ha frissítés érhető el valamelyik telepített bővítményéhez.

Az Unicode normalizáció elérhetővé vált a beszéd és a braille kimeneten egyaránt.
Ez olyankor lehet hasznos, amikor olyan karaktereket akarunk olvastatni, amelyeket az adott beszédszintetizátor vagy braille tábla alapvetően nem képes értelmezni, viszont rendelkeznek megfelelő, kompatibilis alternatívával.
  Egyúttal lehetővé teszi az egyenletek olvasását a Microsoft Word egyenletszerkesztőjében.
  
A Help Tech Activator Pro braille kijelzők már támogatottak.

Billentyűparancs rendelhető az egérgörgő függőleges és vízszintes mozgatásának emulálására.

Számos hibajavítás többek között a Windows 11 beviteli élmény paneléhez és a vágólap előzményeihez.
A böngészők hibajavításai között találjuk a  hibaüzenetek bejelentését. Ezen kívül az olyan elemek kezelése is javult, mint alakzatok, feliratok, táblázat címkék, illetve választógombokat és jelölőnégyzeteket tartalmazó menüelemek.

Frissült a LibLouis Braille fordító új táblák: Szerb (cirill), Jiddis, török, nemzetközi fonetikus ABC és még néhány ókori nyelvhez.
Frissült az eSpeak, új támogatott nyelv: karakalpak.
Frissült az Unicode CLDR is.

### Újdonságok

* Új billentyűparancsok:
  * Új parancsok az egérgörgő vízszintes és függőleges mozgatásához. Alapértelmezetten nincs billentyűparancs hozzárendelve. (#16462, @Cary-Rowen)
* Támogatás az Unicode normalizációhoz a beszéd és Braille kimeneten egyaránt. (#11570, #16466 @LeonarddeR).
  * Ez olyankor lehet hasznos, amikor olyan karaktereket akarunk olvastatni, amelyeket az adott beszédszintetizátor vagy braille tábla alapvetően nem képes értelmezni, viszont rendelkeznek megfelelő, kompatibilis alternatívával. Ilyenek pl. a közösségi médiában oly elterjedt félkövér és dőlt karakterek.
  * Egyúttal lehetővé teszi az egyenletek olvasását a Microsoft Word egyenletszerkesztőjében. (#4631)
  * A funkciót az NVDA beállításai között a kapcsolódó kategóriákban kezelhetjük. Értelemszerűen a beszédkimenet normalizációt a Beszéd kategóriában, a Braille kimenet normalizációját pedig a Braille kategóriában.
* Az NVDA az indulása után már figyelmeztet, ha valamely telepített bővítményhez frissítés áll rendelkezésre. (#15035)
  * Ez a funkció az NVDA beállításai között a Bővítménykezelő kategóriában szabályozható.
  * Az NVDA napi rendszerességgel ellenőrzi a bővítményfrissítéseket.
  * Csak az azonos csatornán elérhető frissítéseket ellenőrzi a rendszer. Pl. ha egy bővítmény béta verzióját telepítettük a béta csatornán keresztül, akkor az NVDA csak a béta csatornán elérhető frissítéseket fogja ellenőrizni az adott bővítményhez.
* Támogatás a Help Tech Activator Pro Braille kijelzőkhöz. (#16668)

### Változások

* Frissített összetevők:
  * Frissült az eSpeak NG, új verzió: 1.52-dev commit `54ee11a79`. (#16495)
    * Új nyelvet adtak hozzá: Karakalpak.
  * Frissült az Unicode CLDR, új verzió: 45.0. (#16507, @OzancanKaratas)
  * Frissült a fast_diff_match_patch (amit arra használnak, hogy detektálja a változásokat különböző terminál programokban ill. egyéb dinamikus tartalmak kezelésekor). Új verzió: 2.1.0. (#16508, @codeofdusk)
  * Frissült a LibLouis braille fordító, új verzió: [3.30.0](https://github.com/liblouis/liblouis/releases/tag/v3.30.0). (#16652, @codeofdusk)
    * Új braille táblák:
      * Szerb cirill betűs.
      * Jiddis.
      * Néhány ókori nyelv: Bibliai héber, akkád, szír, Ugarit és transzliterális ékírás.
      * Török, rövidítési fokozat 2. (#16735)
      * nemzetközi fonetikus ABC. (#16773)
  * Frissült az NSIS, új verzió: 3.10 (#16674, @dpy013)
  * Frissült a markdown, új verzió: 3.6 (#16725, @dpy013)
  * Frissült az nh3, új verzió: 0.2.17 (#16725, @dpy013)
* Az a Braille tábla,amihez az NVDA minden olyan esetben automatikusan visszatérhet, amikor bármi probléma adódik az aktuálisan beállított braille táblával mostantól az Egységesített angol braille kód a beviteli és a kimeneti tábla esetében egyaránt. (#9863, @JulienCochuyt, @LeonarddeR)
* Az NVDA már bemondja az olyan alakzatokat,amikhez nem tartozik gyerekelem, viszont felirat vagy leírás igen. (#14514)
* Böngészőmódban, soronkénti olvasás közben Már nem hangzik el minden egyes sorban a "felirat" szó az olyan alakzatok és táblázatok esetében, melyekhez hosszú, többsoros felirat tartozik. (#14874)
* Python konzol: Már nem veszik el az utolsó végre nem hajtott parancs, amikor belépünk a bevitel előzményei közé. (#16653, @CyrilleB79)
* Most már egy egyedi de továbbra is a névtelenséget biztosító azonosító is a része az NVDA által gyűjtött használati adatoknak. Az adatgyűjtés az NVDA Beállításai között az általános kategóriában kapcsolható be vagy ki. (#16266)
* Alapértelmezés szerint az NVDA már létrehoz egy új mappát amikor hordozható verziót készít.
Az NVDA már figyelmeztet, ha olyan mappában akarunk hordozható verziót létrehozni, ami nem üres. (#16686)

### Hibajavítások

* Windows 11 javítások:
  * Az NVDA már nem akad meg a vágólap előzményeinek és a Windows beviteli élmény panelének bezárásakor. (#16346, #16347, @josephsl)
  * Az NVDA már bemondja a megjelenő lehetőségeket a beviteli mód kiválasztására szolgáló panelen. (#14023, @josephsl)
  * Az NVDA már nem mondja be kétszer a vágólap előzményeit, amikor a Windows beviteli élmény panelének menüelemein navigálunk. (#16532, @josephsl)
  * Az NVDA már nem szakítja meg sem a beszédet sem a Braille-t, amikor a Windows beviteli élmény panelén a kaomojikon vagy szimbólumokon navigálunk. (#16533, @josephsl)
* Böngésző javítások:
  * Az "aria-errormessage" tulajdonsággal megjelölt hibaüzeneteket az NVDA már bemondja Google Chrome és Mozilla Firefox esetén is. (#8318)
  * Mozilla firefox: amennyiben rendelkezésre áll, az NVDA már az "aria-labelledby" tulajdonságot használja a táblázatok akadálymentes elnevezésének meghatározására. (#5183)
  * Az NVDA már helyesen jelenti be a választógombokat és jelölőnégyzeteket tartalmazó menüelemeket, amikor először nyitunk meg egy almenüt a Google Chrome és Mozilla Firefox böngészőkben. (#14550)
  * Az NVDA böngészőmódjának keresője most már  hatékonyabban működik az olyan lapokon is,amik emodzsikat tartalmaznak. (#16317, @LeonarddeR)
  * Mozilla Firefoxban az NVDA már helyesen jelenti be az aktuális karaktert, szót vagy sort amennyiben a kurzor a sor végén található beszúrási ponton van. (#3156, @jcsteh)
  * Már nem okozza a Chrome összeomlását egy dokumentum vagy magának a böngészőnek a bezárása. (#16893)
* Az NVDA már bejelenti az automatikus kiegészítési javaslatokat az Eclipse alkalmazásban és más Eclipse-alapú környezetekben windows 11 alatt. (#16416, @thgcode)
* Javult az automatikusan változó szövegek kezelése főleg különbőző terminál programokban. (#15850, #16027, @Danstiv)
* Ismét problémamentesen működik a konfiguráció visszaállítása a gyári értékekre. (#16755, @Emil-18)
* Microsoft Excel: Az NVDA már helyesen jelenti be a kijelölés változásait egy cella szövegének szerkesztése közben. (#15843)
* Java Access Bridge-t használó alkalmazások esetén az NVDA már helyesen jelenti be egy szöveg utolsó üres sorát, és már nem mondja be ilyenkor az előző sort. (#9376, @dmitrii-drobotov)
* LibreOffice Writer (24.8 és újabb verziók esetében), Ha billentyűparanccsal változtatunk meg olyan szövegformátum tulajdonságokat, mint félkövér, dőlt, aláhúzott, alsó index/felső index vagy igazítás, akkor az NVDA már bemondja a tulajdonság új állapotát. Pl. félkövér ki. (#4248, @michaelweghorn)
* Ha a kurzormozgató billentyűkkel navigálunk UI automationt használó alkalmazások szövegmezőiben, az NVDA már nem mond be helytelen karaktert vagy szót. (#16711, @jcsteh)
* Windows 10/11 Számológép: Számok beillesztése esetén az NVDA már helyesen jelenti be a teljes beillesztett számot. (#16573, @TristanBurchett)
* A beszéd már nem némul el ha csatlakozunk vagy éppen bontjuk a kapcsolatot egy távoli asztalkapcsolati folyamatban. (#16722, @jcsteh)
* Visual Studio Code: Támogatás objektumok nevének szövegáttekintő parancsokkal való eléréséhez. (#16248, @Cary-Rowen)
* Az NVDA hangjelzéseinek lejátszása már nem ütközik problémába mono hangeszközök esetén. (#16770, @jcsteh)
* Az NVDA már bejelenti a címeket amikor a Címzett, másolatot kap és a titkos másolatot kap címkéjű mezőkön navigálunk az Outlook webes felületén vagy a Modern Outlook alkalmazásban. (#16856)
* Az NVDA már sokkal jobban kezeli a bővítmények telepítése során esetlegesen fellépő hibákat. (#16704)

## 2024.2

Új opció az Audio beállítások között: osztott hang.
Lehetővé teszi, hogy beállítsuk, hogy az NVDA-t ill. a többi alkalmazás hangját melyik hangcsatornán halljuk. Megadható pl. hogy az NVDA-t kizárólag a bal oldali hangszórón, a többi alkalmazást meg kizárólag a jobb oldali hangszórón halljuk.

Új parancsok a szintetizátor beállító körhöz: ugrás az első és utolsó elemre, valamint az aktuális beállítás nagyobb léptékű növelése és csökkentése.
Új gyorsnavigációs parancsokat állíthatunk be az alábbi elemekhez: bekezdések, függőlegesen igazított bekezdések, azonos és eltérő stílusú szövegek, menüelemek, többállapotú gombok, folyamatjelzők, alakzatok és matematikai képletek.

Számos új Braille opció és javítás.
Új Braille mód: Beszéd kimenet megjelenítése.
Ebben a módban a Braille kijelzőn egészen pontosan az jelenik meg,amit az NVDA kimond.
Támogatás a BrailleEdgeS2 és BrailleEdgeS3 kijelzőkhöz.
Frissült a LibLouis Braille fordító, ukrán és fehérorosz részletes irodalmi táblákkal bővült.

Frissült az eSpeak, a Tigrinya nyelvvel bővült.

Számos hibajavítás különböző alkalmazásokhoz, mint Thunderbird, Adobe Reader, web böngészők, Nudi és Geekbench.

### Újdonságok

* Új billentyűparancsok:
  * új gyorsnavigációs parancs 'p' bekezdésenkénti navigációhoz böngészőmódban. (#15998, @mltony)
  * új, beállítható egykarakteres gyorsnavigációs parancsok az alábbi elemekhez
  :
    * alakzatok (#10826)
    * függőlegesen igazított bekezdések (#15999, @mltony)
    * menüelemek (#16001, @mltony)
    * többállapotú gombok (#16001, @mltony)
    * folyamatjelzők (#16001, @mltony)
    * matematikai képletek (#16001, @mltony)
    * azonos stílusú szövegek (#16000, @mltony)
    * eltérő stílusú szövegek (#16000, @mltony)
  * Most már nemcsak előre és hátra lehet mozogni a szintetizátor beállító körön, hanem az első és  az utolsó elemhez is lehet ugrani. (#13768, #16095, @rmcpantoja)
    * A szintetizátor beállító kör első és utolsó elemének beállításához nincs alapértelmezetten hozzárendelt parancs beállítva. (#13768)
    * Külön parancs az aktuális beállítás értékének nagyobb léptékű növelésére és csökkentésére. (#13768):
      * Asztali kiosztás: `NVDA+ctrl+pageUp` és 'NVDA+ctrl+pageDown'.
      * Laptop: `NVDA+ctrl+shift+pageUp` és `NVDA+ctrl+shift+pageDown`.
  * Beállítható parancs  az alakzatok és feliratok jelzésére. (#10826, #14349)
* Braille:
  * Támogatás a BrailleEdgeS2 és BrailleEdgeS3 kijelzőkhöz. (#16033, #16279, @EdKweon)
  * Új braillemód: "Beszéd kimenet megjelenítése". (#15898, @Emil-18)
    * Ebben a módban a Braille kijelző pontosan azt jeleníti meg,amit az NVDA beszél.
    * A mód bekapcsolható az NVDA Braille beállításai között vagy a következő billentyűparanccsal: 'NVDA+alt+t'.
* Osztott hang: (#12985, @mltony)
  * Lehetővé teszi, hogy beállítsuk, hogy az NVDA-t ill. a többi alkalmazás hangját melyik csatornán halljuk. Megadható pl. hogy az NVDA-t kizárólag a bal oldali hangszórón, a többi alkalmazást meg kizárólag a jobb oldali hangszórón halljuk.
  * Billentyűparancsa: 'NVDA+alt+s'.
* A sor- és oszlopfejlécek jelzése már támogatott a szerkeszthető tartalmú HTML elemeknél. (#14113)
* Új opció a Dokumentumformázási beállítások között: Alakzatok és feliratok. (#10826, #14349)
* Windows 11: Az NVDA már jelzi a diktálással és a javasolt műveletekkel kapcsolatos figyelmeztetéseket. Ide értve az első javaslatokat olyan adatok vágólapra másolásakor, mint pl. a telefonszám. (Windows 11 2022 frissítés és újabb verziók esetén). (#16009, @josephsl)
* Az NVDA "ébren" tartja az audió eszközt a beszéd befejezése után is. Ezzell elkerülhetők bizonyos technikai problémák olyan eszközöknél mint pl. a Bluetooth fejhallgatók. (#14386, @jcsteh, @mltony)
* Újonnan támogatott szoftver: HP Secure Browser. (#16377)

### Változások

* Bővítménykezelő:
  * A minimum szükséges és az utoljára tesztelt NVDA verzió most már megjelenik az egyes bővítményeknél a további részletek kategóriában. (#15776, @Nael-Sayegh)
  * A Közösségi értékelések művelet most már a bővítménykezelő minden lapfülén elérhető. (#16179, @nvdaes)
* Frissített összetevők:
  * A LibLouis Braille fordító új verziója: [3.29.0](https://github.com/liblouis/liblouis/releases/tag/v3.29.0). (#16259, @codeofdusk)
    * Új részletes irodalmi táblák (nagybetűk jelzésével) fehérorosz és ukrán nyelvekhez.
    * új  spanyol tábla görög szövegek olvasásához.
    * Új tábla: laoszi rövidítési fokozat 1. (#16470)
  * eSpeak NG új verziója 1.52-dev commit `cb62d93fd7`. (#15913)
    * Új nyelvet adtak hozzá: Tigrinya.
* A BrailleSense eszközöknél számos beviteli parancsot megváltoztattak, hogy elkerüljék az ütközést a francia braille tábla karaktereivel. (#15306)
  * `alt+BalNyíl` mostantól `2. pont+7. pont+szóköz`
  * `alt+JobbNyíl` mostantól `5. pont+7. pont+szóköz`
  * `alt+FelNyíl` mostantól `2. pont+3. pont+7. pont+szóköz`
  * `alt+LeNyíl` mostantól `5. pont+6. pont+7. pont+szóköz`
* Alacsony írásjelkiejtési szinten az NVDA már nem jelenti be a helykitöltő pontokat. Ilyenekkel döntően tartalomjegyzékekben lehet találkozni. (#15845, @CyrilleB79)

### Hibajavítások

* Windows 11 javítások:
  * Az NVDA ismét bejelenti a hardveres billentyűzethez a beviteli javaslatokat. (#16283, @josephsl)
  * 24H2 (2024 frissítés és Windows Server 2025) esetén az egér és az érintési beállítások most már használhatók a gyors beállítások között. (#16348, @josephsl)
* Bővítménykezelő:
  * 'ctrl+tab' lenyomásakor a fókusz most már az újonnan aktívvá vált lapfülre kerül, függetlenül attól, hogy melyik vezérlő volt az aktív elem korábban. (#14986, @ABuffEr)
  * Ha a cache fájlok nem megfelelőek az NVDA már nem indul újra. (#16362, @nvdaes)
* Javítások Chromium-alapú böngészőkhöz UIA használata esetén:
  * javítottak egy hibát, mely fennakadást okozott az NVDA működésében. (#16393, #16394)
  * A Backspace gomb most már megfelelően működik a Gmail bejelentkezési szövegmezőiben. (#16395)
* A Backspace gomb most már megfelelően működik a Nudi 6.1 programban,amennyiben az NVDA Billentyűzet beállításai között engedélyezve van az "Alkalmazások billentyűleütéseinek kezelése" opció. (#15822, @jcsteh)
* Javítottak egy hibát,ami azt okozta, hogy az NVDA alvó módban is lejátszotta az egérmutató képernyőn elfoglalt helyzetét leképző visszajelző hangokat, amikor az NVDA Egér beállításai között "Az egérmutató mozgásának jelzése hanggal" opció be volt kapcsolva. (#8059, @hwf1324)
* Adobe Reader: az NVDA már nem hagyja figyelmen kívül a pdf dokumentumokban a képletekhez megadott alternatív leíró szövegeket. (#12715)
* Geekbench: Javítottak egy hibát,ami azt okozta, hogy az NVDA nem tudta kezelni a szalagmenüt és az opciókat. (#16251, @mzanm)
* Javítottak egy ritkán előforduló hibát,ami azt okozta, hogy a konfiguráció mentésekor az NVDA nem mentett minden profilt megfelelően. (#16343, @CyrilleB79)
* Firefox és Chromium-alapú böngészők: Az NVDA fókuszmódra vált, amikor egy szerkeszthető mezőben lista bukkan fel. (#16325)
* Thunderbird: az oszlopok állapotának változását már megfelelően jelenti be az NVDA, amikor az üzenetlistánál beállítjuk a megjelenítendő oszlopokat. (#16323)
* A '-h'/'--help' parancssori kapcsolók ismét megfelelően működnek. (#16522, @XLTechie)
* Poedit 3.4 és újabb verzióiban az NVDA már megfelelően kezeli az olyan nyelvek fordítását, ahol 1 vagy kettőnél több többeszszámú alak is előfordulhat. (Pl. kínai vagy lengyel nyelv). (#16318)

## 2024.1

Új beszédmódot adtak hozzá: "On-demand".
Ebben a beszédmódban az NVDA nem beszél automatikusan, pl. a kurzor mozgásakor, de a szöveges visszajelzést adó billentyűparancsok a megszokott módon működnek. Például ha egy ablakra navigálunk, az NVDA nem mondja be automatikusan az ablak címsorát, de a lekérdező billentyűparancsra már válaszol.
Az NVDA beállítások Beszéd kategóriájában most már kiválaszthatjuk, hogy mely beszédmódok közt szeretnénk váltogatni a kapcsolódó billentyűparanccsal (alapértelmezetten `NVDA+s`).

Böngészőmódban elérhetővé vált a hagyományos kijelölési mód a Mozilla Firefoxban. Alapértelmezett billentyűparancsa: `NVDA+Shift+F10`.
Bekapcsolt állapotban böngészőmódban a szövegkijelölés egyúttal a Firefox saját szövegkijelölésére is hatással van.
A Ctrl+C billentyűparancsot az NVDA átadja a Firefoxnak, ezáltal lehetőség nyílik arra, hogy a másolás rich text formátumban történjen, és ne az NVDA által használt egyszerűbb Plain text formátumban.

A bővítménykezelő most már képes csoportos műveletvégrehajtásra. Ha egyszerre több bővítményt jelölünk ki, most már lehetséges csoportosan telepíteni vagy épp eltávolítani őket.
Új műveletet adtak hozzá, amely elvezet arra a webhelyre, ahol az adott bővítménnyről visszajelzést lehet adni/mások visszajelzését elolvasni.

A Beszédszintetizátor kiválasztására szolgáló párbeszédablakról eltávolították a kimeneti eszköz és a hangerő-igazítás beállítására szolgáló opciókat.
Ezeket mostantól az NVDA beállításai között az Audio kategóriában lehet elérni. Az Audio kategória megnyitható az `NVDA+ctrl+u` billentyűparanccsal.

Frissült az eSpeak-NG, a LibLouis braille fordító és a CLDR is.
Új Braille táblákat adtak hozzá thai, filippínó és román nyelvekhez.

További hibajavítások a Bővítménykezelőben, a braille és az audio kezelésében, ill. a Libre Officeban és a Microsoft Officeban.

### Fontos figyelmeztetések

* Ennél a kiadásnál szükség van a bővítmények kompatibilitásának újbóli ellenőrzésére.
* A Windows 7 és a Windows 8 már nem támogatott.
A Windows 8.1 a legrégebbi Windows verzió, amin az NVDA ezen kiadása még futtatható.

### Újdonságok

* Bővítménykezelő:
  * A bővítménykezelő most már képes csoportos műveletvégrehajtásra. Ha egyszerre több bővítményt jelölünk ki, most már lehetséges csoportosan telepíteni vagy épp eltávolítani őket. (#15350, #15623, @CyrilleB79)
  * Új műveletet adtak hozzá, amely elvezet arra a webhelyre, ahol az adott bővítménnyről visszajelzést lehet adni/mások visszajelzését elolvasni. (#15576, @nvdaes)
* Támogatás a Bluetooth Low Energy HID Braille kijelzőkhöz. (#15470)
* Mozilla Firefox: böngészőmódban elérhetővé vált a hagyományos kijelölési mód. Alapértelmezett billentyűparancsa: `NVDA+Shift+F10`.
Bekapcsolt állapotban böngészőmódban a szövegkijelölés egyúttal a Firefox saját szövegkijelölésére is hatással van.
A Ctrl+C billentyűparancsot az NVDA átadja a Firefoxnak, ezáltal lehetőség nyílik arra, hogy a másolás rich text formátumban történjen, és ne az NVDA által használt egyszerűbb Plain text formátumban.
Fontos tudni, hogy ebben a módban a Firefox kezeli a kijelölést, így az NVDA nem ad visszajelzést a szöveg vágólapra másolásáról. (#15830)
* Ha böngészőmódban használjuk a Microsoft Word alkalmazást, akkor a másolt szöveggel együtt másoljuk annak formátumát is.
Ennek a folyományaként az NVDA a Word és az Outlook böngészőmódú használata esetén sem ad visszajelzést a szöveg vágólapra másolásáról. A másolt szöveget ilyen esetekben is az említett alkalmazások kezelik és nem az NVDA. (#16129)
* Új beszédmódot adtak hozzá: "On-demand".
Ebben a beszédmódban az NVDA nem beszél automatikusan, pl. a kurzor mozgásakor, de a szöveges visszajelzést adó billentyűparancsok a megszokott módon működnek. Például ha egy ablakra navigálunk, az NVDA nem mondja be automatikusan az ablak címsorát, de a lekérdező billentyűparancsra már válaszol. (#481, @CyrilleB79)
* Az NVDA beállítások Beszéd kategóriájában most már kiválaszthatjuk, hogy mely beszédmódok közt szeretnénk váltogatni a kapcsolódó billentyűparanccsal (alapértelmezetten `NVDA+s`). (#15806, @lukaszgo1)
  * Ez a megoldás kiváltja a "Hangjelzés beszédmód kikapcsolása" nevű bővítményt, ezért azt javasoljuk, hogy azt távolítsa el az NVDA-ból. Könnyedén reprodukálhatjuk a bővítmény működését azzal, hogy a beállítások közt letiltjuk a "Hangjelzés" és "On-demand" beszédmódokat.

### Változások

* Az NVDA már nem futtatható Windows 7 és Windows 8 alatt.
Mostantól a Windows 8.1 a legrégebbi Windows kiadás,ami még támogatott. (#15544)
* Komponens frissítések:
  * Frissült a LibLouis braille fordító, új verzió: [3.28.0](https://github.com/liblouis/liblouis/releases/tag/v3.28.0). (#15435, #15876, @codeofdusk)
    * Új braille táblák thai román és filippínó nyelvekhez.
  * Frissült az eSpeak NG, új verzió: 1.52-dev commit `530bf0abf`. (#15036)
  * Frissült a CLDR, új verzió: 44.0. (#15712, @OzancanKaratas)
  * Frissült a Java Access Bridge, új verzió: 17.0.9+8Zulu (17.46.19). (#15744)
* Billentyűparancsok:
  * Az alábbi parancsok már támogatják a kétszeri és a háromszori lenyomást, amivel a visszajelzés betűzhető karakterleírások nélkül, ill. karakterleírások használatával: Kijelölés bemondása, Vágólap tartalmának bemondása, ill. Aktív elem bejelentése. (#15449, @CyrilleB79)
  * A Képernyőfüggöny kapcsolgatásának most már van alapértelmezetten hozzárendelt parancsa: `NVDA+ctrl+esc`. (#10560, @CyrilleB79)
  * Négyszeri lenyomásra a Kijelölés bemondása parancs böngészhető üzenetben ad visszajelzést. (#15858, @Emil-18)
* Microsoft Office:
  * Az Excelben cellaformátum lekérdezésekor csak akkor hangzik el a szegéllyel és a háttérrel kapcsolatos információ, ha azok be vannak állítva az adott cellához. (#15560, @CyrilleB79)
  * Az NVDA visszatért ahhoz a korábbi viselkedéshez, amikor nem mondja be a címkézetlen elemcsoportokat. Ennek pl. a Microsoft Office 365 menüjjében van jelentősége. (#15638)
* A Beszédszintetizátor kiválasztására szolgáló párbeszédablakról eltávolították a kimeneti eszköz és a hangerő-igazítás beállítására szolgáló opciókat.
Ezeket mostantól az NVDA beállításai között az Audio kategóriában lehet elérni. Az Audio kategória megnyitható az `NVDA+ctrl+u` billentyűparanccsal. (#15512, @codeofdusk)
* Az NVDA Egér beállítások között átneveztük "A vezérlőelem típusának bemondása az egérmutató mozgásakor" opciót, új neve "Elemek bemondása az egérmutató mozgásakor".
Az opció bekapcsolt állapotában a korábbinál több információhoz jutunk az egérmutató alatt található elemről. Ilyen információ például az elemek állapota (kiválasztva vagy lenyomva) ill. a cellák koordinátái egy táblázatban. (#15420, @LeonarddeR)
* Új opciókat adtak hozzá az NVDA Súgó menüjéhez. Mind az NV Access weboldalának más-más szekciójára visz. (#14631)
* Az NVDA [Poedit](https://poedit.net) támogatása frissült  a Poedit 3 és újabb verzióira.
A Poedit 1.x verziók támogatása ezzel együtt megszűnik, ezért szükségessé vált a frissítés a Poedit legújabb verziójára. (#15313, #7303, @LeonarddeR)
* A Braille-néző és a Beszédnéző már nem elérhető biztonsági képernyőről. (#15680)
* Elemnavigáció során az NVDA már nem hagyja figyelmen kívül a letiltott/nem elérhető elemeket. (#15477, @CyrilleB79)
* Tartalomjegyzéket adtak hozzá az NVDA parancsok listájához az angol nyelvű verzióban. (#16106)

### Hibajavítások

* Bővítménykezelő:
  * Ha a bővítmények listáján egy fókuszban lévő bővítmény állapota megváltozik, pl elkészül a letöltés, akkor az NVDA már bejelenti az új állapotot. (#15859, @LeonarddeR)
  * Bővítmények telepítése során az újraindításra figyelmeztető párbeszédablak már nem takarja el a telepítés állapotjelzőit. (#15613, @lukaszgo1)
  * Egy nem kompatibilis bővítmény újbóli telepítése után a bővítmény már nem lesz automatikusan letiltva. (#15584, @lukaszgo1)
  * Most már lehet frissíteni a letiltott és nem kompatibilis bővítményeket. (#15568, #15029)
  * Az NVDA visszaszerzi a fókuszt és hibaüzenetet ad, amikor egy bővítmény letöltése nem sikerült. (#15796)
  * Az NVDA az elvárásoknak megfelelően indul újra,amikor megnyitjuk és bezárjuk a Bővítménykezelőt. (#16019, @lukaszgo1)
* Audio:
  * Az NVDA már nem fagy le olyan esetekben, amikor többféle hangot kell lejátszania gyors egymásutánban. (#15311, #15757, @jcsteh)
  * Ha a kimeneti hangeszközt az alapértelmezettől elltérő  eszközre állítjuk, az NVDA már képes visszatérni az általunk beállított eszközhöz azután is, hogy az átmenetileg nem volt elérhető. Korábban ilyen esetekben az NVDA az alapértelmezett eszközt használta. (#15759, @jcsteh)
  * Az NVDA hangja most már magától visszatér olyankor is, amikor a kimeneti hangeszköz beállítása megváltozik, és olyankor is, amikor egy másik alkalmazás úgymond elengedi a kizárólagos módban használt hangeszközt. (#15758, #15775, @jcsteh)
* Braille:
  * A többsoros braille kijelzők már nem okoznak hibát a BRLTTY driver működésében, az NVDA már úgy kezeli őket, mintha egyetlen hosszú soruk lenne. (#15386)
  * Az NVDA a korábbinál több hasznos szöveget tartalmazó elemet képes azonosítani, ezeknek a szöveges tartalma már Brailleben is megjeleníthető. (#15605)
  * A rövidírásos braille bevitel ismét megfelelően működik. (#15773, @aaclause)
  * A Braille most már jobban követi a navigátorkurzor mozgását bizonyos táblázatokban. (#15755, @Emil-18)
  * Az aktív elem, a navigátorkurzornál található elem ill. a kijelölés lekérdezésére szolgáló parancsok eredménye már Braillben is megjeleníthető. (#15844, @Emil-18)
  * Az Albatross braille driver már nem kezeli az Esp32 microcontroller eszközt Albatross kijelzőként. (#15671)
* LibreOffice:
  * Az NVDA már bejelenti a "`ctrl+backspace" billentyűparanccsal törölt szavakat, olyan esetekben, amikor a törölt szó után úgynevezett whitespace karakter, azaz üres hely van. Ezek jellemzően olyan nem látható karakterek, mint a szóköz, vagy a tabulátor. (#15436, @michaelweghorn)
  * Az állapotsor lekérdezésére szolgáló billentyűparancs `NVDA+end` most már működik a LibreOffice 24.2 és újabb verzióinak párbeszédablakainál. (#15591, @michaelweghorn)
  * 24.2 és újabb verzióknál az NVDA már le tudja kérdezni egy szöveg minden olyan tulajdonságát, amit a Microsoft Wordben is.
  Ennek köszönhetően az NVDA már jelzi a hibás szavakat a Writerben. (#15648, @michaelweghorn)
  * 24.2 és újabb verziók esetén az NVDA már jelzi a címsorok szintjét is. (#15881, @michaelweghorn)
* Microsoft Office:
  * Excel UIA használata nélkül: a braille frissül, és az aktív cella tartalma is elhanggzik a következő billentyűparancsok használata után:  `ctrl+y`, `ctrl+z` és `alt+backspace`. (#15547)
  * Word UIA használata nélkül: a braille frissül a következő billentyűparancsok lenyomása után: `ctrl+v`, `ctrl+x`, `ctrl+y`, `ctrl+z`, `alt+backspace`, `backspace` és `ctrl+backspace`.
  UIA használatával is frissül a braille, szöveg beírásakor, amennyiben a Braille az áttekintőkurzor követésére van beállítva, ill. az áttekintőkurzor követi a rendszerkurzort. (#3276)
  * Word: Az NVDA már helyesen jelenti be a célcellát, amikor egy táblázatban a hagyományos Wordös navigációs parancsokkal navigálunk. (`alt+home`, `alt+end`, `alt+pageUp` és `alt+pageDown`). (#15805, @CyrilleB79)
* Javult az elemekhez tartozó gyorsbillentyűk jelzése. (#10807, #15816, @CyrilleB79)
* A SAPI4 beszédszintetizátor most már támogatja a beszédbe ágyazott hangerő-, beszédsebesség és hangmagasság-változásokat. (#15271, @LeonarddeR)
* A többsoros állapotot az NVDA most már helyesen jelenti be Java Access Bridge-t használó alkalmazásokban. (#14609)
* Windows 10 és 11: Az NVDA a korábbinál több párbeszédablak tartalmát képes kezelni. (#15729, @josephsl)
* Microsoft Edge UI Automation használatával: Az NVDA már bejelenti az újonnan betöltődő oldalakat. (#15736)
* Folyamatos felolvasásnál és betűzős parancsok használatakor a mondatok és karakterek közti szünetek hossza már nem rövidül az idő függvényében. (#15739, @jcsteh)
* Az NVDA már nem fagy le nagymennyiségű szöveg felolvasása közben. (#15752, @jcsteh)
* Microsoft Edge UI Automation használatával: Böngészőmódban az NVDA a korábbinál több vezérlőt képes kezelni. (#14612)
* Az NVDA mostantól akkor is elindul, ha hibás a konfigurációs fájl. Ilyenkor az alapértelmezett beállításokat tölti be, mintha csak aktiváltuk volna a "Gyári beállítások visszaállítása opciót. (#15690, @CyrilleB79)
* Javították a támogatást a Rendszer listanézet vezérlőkhöz ("SysListView32") a Windows Űrlap alkalmazásokban. (#15283, @LeonarddeR)
* Mostantól már nem lehet felülírni az NVDA Python konzolának előzményeit. (#15792, @CyrilleB79)
* Az NVDA most már nem kerül "nem válaszol" állapotba, amikor egyszerre nagymennyiségű UI automation eseménnyel kell megbirkóznia. Pl. ha nagymennyiségű szöveg kerül egy konzolra, vagy hangüzenetek hallgatásakor a WhatsApp messengerben. (#14888, #15169)
  * Ezt a viselkedést az NVDA haladó beállításai között lehet szabályozni a "Kiemelt eseményfeldolgozás használata" opcióval.
* Az NVDA már tudja követni a fókuszt a Windows Defender Application Guard (WDAG) azaz az alkalmazásőr keretein belül futtatott alkalmazásoknál. (#15164)
* A beszéd szövege már nem frissül, amikor az egeret mozgatjuk a Beszédnézőben. (#15952, @hwf1324)
* Firefox és Chrome: Az NVDA már automatikusan visszatér böngészőmódba, amikor egy kombinált listamezőt az Esc vagy az alt+felnyíl billentyűparanccsal zárunk be. (#15653)
* Itunes: felnyíl és lenyíl billentyűk használata kombinált listamezőkben már nem váltja át az NVDA-t kéretlenül böngészőmódra. (#15653)

## 2023.3

Ebben a kiadásban fejlesztették a hangkimenet kezelését, javult a reakcióidő, a teljesítmény és a stabilitás is.
Végre lehetővé vált  az NVDA hangjelzéseinek a hangerejét külön is szabályozni. De lehetőség van arra is, hogy a hangjelzések hangereje kövesse a beszéd hangerejét.
A Haladó beállítások között ez már korábban is elérhető volt, de most végre kiforrott és bekerült az alapbeállítások közé.

Az NVDA mostantól képes bizonyos időközönként automatikusan frissíteni az optikai karakterfelismerés eredményét és be is mondja az észlelt változásokat.
Ezt az új opciót az NVDA beállításai között a Windows OCR kategóriában lehet beállítani.

Számos Braille hibajavítás, beleértve a kurzor mozgatását és a Braille kijelzők automatikus észlelését.
A Braille kijelzők automatikus észlelése jelentősen javítható azáltal, hogy manuálisan megadható, hogy az észlelés során mely drivereket hagyja figyelmen kívül az NVDA.
Új BRLTTY parancsokat adtak hozzá.

További hibajavítások a Bővítménykezelőhöz, a Microsoft Office programcsomaghoz, a Microsoft Edge helyi menüihez és a Windows Számológép alkalmazáshoz.

### Újdonságok

* Fejlesztett hangkezelés:
  * Új, Audio kategória az NVDA beállításai közt a Hangkimenet kezelésére:
    * Az Audio kategória az "NVDA+CTRL+U" paranccsal közvetlenül is elérhető. (#15497)
    * "Az NVDA hangjelzéseinek hangereje követi a beszéd hangerejét" opció segítségével az NVDA hangjelzéseinek hangereje együtt mozog a beszéd hangerejével. (#1409)
    * Ha az opció ki van kapcsolva, akkor az NVDA hangjelzéseinek hangereje a beszéd hangerejétől függetlenül, külön is szabályozható. (#1409, #15038)
    * A kimeneti eszköz és a hangerő-igazítás beállítása mostantól az új, Audió beállítási kategóriában lehetséges. Korábban ezt a beszédszintetizátor kiválasztására szolgáló párbeszédablakon lehetett csak megtenni.
    Ezek az opciók az NVDA 2024.1 kiadásától kezdve el is tűnnek a Beszédszintetizátor ablakáról. (#15486, #8711)
  * Az NVDA a hangkimenetét mostantól WASAPI (Windows Audio Session API) használatával kezeli. Ettől javul a beszéd és egyéb hangok reakcióideje és stabilitása. (#14697, #11169, #11615, #5096, #10185, #11061)
  * Figyelem: a WASAPI bizonyos bővítményekkel nem kompatibilis.
  Az érintett bővítményekhez elérhetők kompatibilitást biztosító frissítések, telepítse őket az NVDA frissítése előtt!
  Az alábbi bővítmények nem kompatibilis kiadásai le lesznek tiltva az NVDA frissítése után:
    * Tony's Enhancements 1.15 verzió és régebbi kiadások. (#15402)
    * NVDA global commands extension 12.0.8 és régebbi kiadások. (#15443)
* Az NVDA mostantól képes bizonyos időközönként automatikusan frissíteni az optikai karakterfelismerés eredményét és be is mondja az észlelt változásokat. (#2797)
  * Ehhez aktiválja "A felismerés automatikusan ismétlődő frissítése" opciót a Windows OCR kategóriában az NVDA beállításai között.
  * Amennyiben az opció engedélyezve van, a változások bemondása szabályozható a "Frissülő tartalom bemondása" opcióval, ami az Objektumok megjelenítése kategóriában található.
* Braille kijelző driver automatikus felismerésekor már megadható, hogy az NVDA bizonyos drivereket ne vegyen figyelembe. (#15196)
* Új opció a Dokumentumformázás beállításai között: Üres sorok figyelmen kívül hagyása a behúzás bejelentésénél. (#13394)
* Új parancs adható hozzá a lapfül elemcsoportok közti navigációhoz böngészőmódban. (#15046)

### Változások

* Braille:
  * Ha egy terminálon megjelenített szöveg változik anélkül, hogy frissítené a kurzort, a Braille kijelzőn frissül a szöveg,amennyiben az érintett sorra van pozícionálva.
  Ez olyan szituációkban is működik,amikor a Braille kijelző az áttekintőkurzor követésére van állítva. (#15115)
  * További BRLTTY billentyűparancsokat adtak hozzá az NVDA-hoz (#6483):
    * `learn`: Az NVDA bevitelsúgó be- és kikapcsolása.
    * `prefmenu`: Az NVDA menüjének megnyitása
    * `prefload`/`prefsave`: Az NVDA beállításainak betöltése és mentése
    * `time`: Az idő mutatása.
    * `say_line`: Az áttekintőkurzor sorának felolvasása.
    * `say_below`: Folyamatos felolvasás az áttekintőkurzorral.
  * A BRLTTY driver csak akkor elérhető, ha  fut egy BRLTTY példány, ahol a  BrlAPI engedélyezve van. (#15335)
  * Eltávolították a HID braille támogatást lehetővé tevő haladó beállítást egy új opció kedvéért.
  Most már be lehet állítani, hogy a Braille kijelzők automatikus felismerése során az NVDA mely drivereket ne vegye figyelembe. (#15196)
* Bővítménykezelő: A telepített bővítmények már megjelennek az elérhető bővítmények kategóriában is, amennyiben azok szerepelnek az NVDA hivatalos bővítményoldalán. (#15374)
* Az angol verzióban változtattak néhány gyorsbillentyűn az NVDA menüjében. (#15364)

### Hibajavítások

* Microsoft Office:
  * Javítottak egy hibát a Wordben,mely akkor lépett fel, amikor az NVDA dokumentumformázási beállításai közt a Fejlécek illetve Jegyzetek és megjegyzések opciók ki voltak kapcsolva. (#15019)
  * A Wordben és az Excelben bővült azon szituációk köre,ahol az NVDA képes helyesen bejelenteni a szövegigazítás állapotát. (#15206, #15220)
  * Javították bizonyos cellaformázással kapcsolatos gyorsbillentyűk bejelentését az Excelben. (#15527)
* Microsoft Edge:
  * Edge: Az NVDA már nem ugrik vissza a legutolsó böngészőmódú pozícióra, amikor megnyitjuk a helyi menüt. (#15309)
  * Edge: az NVDA ismét képes kezelni a Letöltések ablakon előhívható helyi menüt. (#14916)
* Braille:
  * A Braille kurzor és a kijelölések megjelenítése most már mindig frissül olyan esetekben,amikor egy billentyűparanccsal változtatjuk a kijelölések megjelenítési módját. (#15115)
  * Javítottak egy hibát, amely azt okozta, hogy olyankor is az albatros kijelző drivere akart betöltődni,amikor egy másik típusú Braille kijelző volt csatlakoztatva. (#15226)
* Bővítménykezelő:
  * Javítottak egy hibát, melynek hatására a beállítás ellenére is megjelentek a nem kompatibilis bővítmények a listán. (#15411)
  * A kompatibilitási problémák miatt letiltott bővítmények most már szűrhetők az engedélyezett/letiltott állapotra vonatkozó feltétellel. (#15416)
  * javítottak egy hibát, mely megakadályozta, hogy egy, a kompatibilitási problémák ellenére, manuálisan engedélyezett bővítményt frissítsünk vagy lecseréljünk a külső telepítő eszközzel. (#15417)
  * Javítottak egy hibát, melynek hatására az NVDA bizonyos esetekben elnémult amíg újra nem lett indítva egy bővítmény telepítése után. (#14525)
  * Javítottak egy hibát, mely bizonyos esetekben megakadályozta az olyan bővítmények telepítését, amelyeknek korábban probléma adódott a letöltésével. (#15469)
  * Javítottak néhány, a nem kompatibilis bővítmények kezelésével kapcsolatos hibát, melyek bizonyos esetekben az NVDA frissítésénél jelentkeztek. (#15414, #15412, #15437)
* Az NVDA ismét bejelenti a számítás eredményét a 32bites Számológépben a Windows Server, LTSC és LTSB verzióiban. (#15230)
* Az NVDA már nem hagyja figyelmen kívül az aktív elem változását olyankor, amikor egy beágyazott ablak kerül fókuszba. (#15432)
* Javítottak egy hibát, mely bizonyos esetekben az NVDA indításakor lépett fel. (#15517)

## 2023.2

### Újdonságok

* Megújult a bővítménykezelő. (#13985)
  * Mostantól a bővítménykezelő keretei közt lehet böngészni és telepíteni a közreműködők által közzétett bővítményeket.
  * Manuálisan engedélyezni lehet a kompatibilitási problémák miatt letiltott régebbi bővítményeket.
    * Bővebb információk hamarosan bekerülnek a felhasználói útmutatóba.
  -
* Karakterleírást adtak bizonyos unikód szimbólumokhoz:
  * braille szimbólumok, mint pl. "⠐⠣⠃⠗⠇⠐⠜". (#14548)
  * Mac Option key szimbólum "⌥". (#14682)
* Új beviteli parancsok: (egyikhez sincs alapértelmezett billentyűparancs hozzárendelve)
  * Windows OCR felismerési nyelvének beállítása. (#13036)
  * Braille kijelzők üzenetmegjelenítési módjának beállítása. (#14864)
  * Braille kijelzőkön kijelölés megjelenítése. (#14948)
* Tivomatic Caiku Albatross Braille kijelző használatát megkönnyítő billentyűparancsokat adtak hozzá. (#14844, #15002)
  * Braille beállítási párbeszédablak megjelenítése
  * Állapotsor elérése
  * Braille kurzor alakjának beállítása
  * Braille üzenetmegjelenítési módjának beállítása
  * Braille kurzor be- és kikapcsolása
  * Braille kijelölés megjelenítés be- és kikapcsolása -
* Új opció a Braille beállítások közt: Kijelölés megjelenítése. Bekapcsolt állapotban a 7-es és 8-as pontot használja a szövegkijelölések jelzésére. (#14948)
* Mozilla Firefox és Google Chrome: Az NVDA már jelzi, ha egy vezérlő párbeszédablakot, rácsot, listát vagy fát nyit. De csak akkor, ha a weboldal készítője megfelelően beállította az aria-haspopup tulajdonságot. (#14709)
* Az NVDA hordozható verzió létrehozásánál a célhely elérési útvonala most már tartalmazhat bizonyos rendszerváltozókat, pl. "%temp%" vagy "%homepath%". (#14680)
* Az NVDA már figyelembe veszi az "aria-brailleroledescription" ARIA 1.3 attribútumot, ez lehetővé teszi, hogy a webes dokumentum fejlesztője felülírja a  Braille kijelzőn megjelenő elem típusát. (#14748)
* Microsoft word: Ha a dokumentumformázási beállítások közt be van kapcsolva a "Kiemelt" opció, az NVDA már bejelenti a kiemeléshez használt színt. (#7396, #12101, #5866)
* Microsoft word: Ha a dokumentumformázási beállítások közt be van kapcsolva a színek opció, az NVDA már bemondja a háttérszínt. (#5866)
* Az áttekintőkurzornál található karakter számbeli értékét bejelentő parancs (numpad2 háromszori lenyomása) most már brailleben is képes megjeleníteni az információt. (#14826)
* Az NVDA már képes a hangját WASAPI használatával megszólaltatni, ezzel javul a reakcióideje és javul a hangok kezelése és stabilitása.
Az opció a Haladó beállítások között található. (#14697)
* Microsoft Excel: Amennyiben billentyűparancsok használatával állítjuk be az olyan formátumokat, mint félkövér, dőlt, aláhúzott vagy áthúzott, az NVDA már bejelenti a változást. (#14923)
* Támogatás a Help Tech Activator Braille kijelzőhöz. (#14917)
* Windows 10 2019 májusi és újabb kiadások: Az NVDA már bejelenti a virtuális asztalok neveit amikor megnyitjuk, módosítjuk vagy bezárjuk őket. (#5641)
* Az NVDA hangjelzéseinek hangereje most már tudja követni a beszéd hangerejét.
Ezt az opciót a haladó beállítások közt lehet bekapcsolni. (#1409)
* Az opció bekapcsolásával mostantól külön is lehet szabályozni a hangjelzések hangerejét.
Az NVDA hangjelzések opció megjelenik a Windows hangerő-keverőjében. (#1409)

### Változások

* Frissült a LibLouis braille fordító, új verzió: [3.26.0](https://github.com/liblouis/liblouis/releases/tag/v3.26.0). (#14970)
* Frissült a CLDR, új verzió: 43.0. (#14918)
* A kötőjel szimbólum mostantól mindig el lesz küldve a beszédszintetizátornak. (#13830)
* Változások a LibreOffice programcsomagban:
  * LibreOffice Writer a LibreOffice 7.6 és újabb verzióiban: Az áttekintőkurzor helyzetének lekérdezésekor az NVDA bemondja a rendszerkurzor/rendszerfókusz relatív helyzetét a lapon, úgy mint a Microsoft Wordben. (#11696)
  * Az állapotsor tartalmát bejelentő billentyűparancs (NVDA+end) már működik a LibreOfficeban. (#11698)
* Microsoft Word: A távolságok bejelentése most már abban a mértékegységben történik,amit beállítunk a Word haladó beállításai közt. UIA használata esetén is működik. (#14542)
* Az NVDA már gyorsabban reagál, ha szerkesztőmezőben mozog a kurzor. (#14708)
* Baum Braille driver: Különböző összetett Braille parancsokat adtak hozzá bizonyos gyakran használt billentyűparancsok emulálására. Pl. windows+d, alt+tab stb.
A teljes lista az NVDA felhasználói útmutatójában tekinthető meg. (#14714)
* Braille kijelzők: Standard HID braille driver használatával a dpad képes a nyílbillentyűk és az enter emulálására. A szóköz+1. pont és Szóköz+4. pont parancsok  szintén a felnyíl és lenyíl lenyomását emulálják. (#14713)
* A hivatkozáshoz tartozó URL bejelentésére szolgáló szkript most már az aktív elemnél ill. a kurzor pozíciójában végzi a lekérdezést. Korábban a navigátor kurzor pozícióját vette alapul. (#14659)
* Az NVDA hordozható verziójának létrehozásakor szükséges abszolút elérési útvonalnak most már nem muszáj tartalmaznia a meghajtó betűjelét. (#14681)
* A Windows rendszeróra lekérdezésére használt parancs, NVDA+f12 most már képes bemondani a másodperceket is, amennyiben A másodpercek megjelenítése be van állítva a Windowsban. (#14742)
* Az NVDA már bejelenti az olyan címke nélküli elemcsoportokat, melyek hasznos pozícióinformációkat tartalmaznak. Ilyen elemcsoportok találhatók pl. a Microsoft Office 365 legújabb verzióinak menüjében. (#14878) 

### Hibajavítások

* Az NVDA automatikus érzékelés közben már nem vált át többször "Nincs braille" állapotra, ez mostantól már az Eseménynaplóba sem kerül teljesen feleslegesen, többször rögzítésre. (#14524)
* Az NVDA automatikusan visszavált USB portra, amikor egy HID Bluetooth eszköz (pl. HumanWare Brailliant vagy APH Mantis) automatikusan felismerésre kerül és az USB csatlakozás elérhetővé válik.
Korábban csak  Bluetooth soros csatlakozás esetén működött így. (#14524)
* Most már használható a \ (balra dőlő perjel) karakter egy kivételszótár behelyettesített kifejezés mezőjében, amennyiben a kifejezés típusa nincs regexre állítva. (#14556)
* Böngészőmódban az NVDA már nem hagyja figyelmen kívül a fókusz szülő- vagy gyerekelemre történő elmozdulását. Pl. egy vezérlő által megnyitott lista vagy rács elemeire lépéskor. (#14611)
  * Ez a javítás csak abban az esetben működik, ha a Böngészőmód beállításai közt az "Automatikus rendszerfókusz az aktiválható elemekre" opció ki van kapcsolva.
* Mozilla Firefox: Az NVDA már nem okozza a böngésző összeomlását, sem pedig a Nem válaszol állapotban ragadását. (#14647)
* Mozilla Firefox és Google Chrome: A beírt karakterek nem kerülnek bejelentésre több szövegmezőben. Korábban a beírt karaktereket akkor is jelezte az NVDA, ha ki volt kapcsolva a vonatkozó opció a Billentyűzet beállításai közt. (#14666)
* Most már hasznáható a böngészőmód olyan beágyazott chromium vezérlőkhöz, ahol ez korábban nem volt lehetséges. (#13493, #8553)
* Amennyiben egy szimbólumhoz nem tartozik karakterleírás egy honosításban, az NVDA az angol verzióban rögzített írásjelszintet fogja figyelembe venni. (#14558, #14417)
* Windows 11 hibajavítások:
  * Az NVDA újra bejelenti a jegyzettömb állapotsorának tartalmát. (#14573)
  * Fülek közötti váltásnál az NVDA már bemondja az újonnan megnyitott fül nevét és pozícióját  a Jegyzettömbben és a fájlkezelőben egyaránt. (#14587, #14388)
  * Kínai és japán nyelveken bevitt szövegeknél ismét megjelennek a javaslatok. (#14509)
  -- Mozilla Firefox: Ha az egérmutató áthalad egy link után található szövegen, akkor már helyesen jelenti be a szöveget. (#9235)
* Windows 10 és 11 Számológép: Az NVDA hordozható verziója már nem működik hibásan, amikor az Általános számológép kompakt nézetében kifejezéseket akarunk bevinni. (#14679)
* Ha egy href attribútum nélküli linkhez tartozó URL-t akarunk lekérdezni, az NVDA már jelzi, hogy nem található az URL. (#14723)
* Számos stabilitást elősegítő javítás braille kijelzőkhöz, ez csökkenti az NVDA működése során előforduló hibákat. (#14627)
* Az NVDA egyre több olyan helyzetből képes helyreállni, ami korábban a teljes lefagyását eredményezte. Ilyen eset pl. ha egy alkalmazás "nem válaszol" állapotban ragad. (#14759) 
* Chrome és Edge: Az ábrák linkjeihez tartozó URL-t már helyesen jelenti be az NVDA. (#14779)
* Windows 11: Ismét megnyitható a "Közreműködők" és a "Licensz szerződés" elem az NVDA súgó menüjéből. (#14725)
* Terminál és konzol programok: UIA támogatás használata már nem okoz fagyást ezáltal az eseménynapló sem telik meg felesleges bejegyzésekkel. (#14689)
* Az NVDA már bejelenti a fókuszba került jelszómezőket az Excelben és az Outlookban. (#14839)
* Gyári visszaállítás után most már el lehet menteni az NVDA beállításait. (#13187)
* Telepítés nélkül futtatott NVDA már nem kínálja fel a beállítások mentése lehetőséget. (#14914)
* Javult az elemek lekérdezésére szolgáló gyorsbillentyűk bemondása. (#10807)
* Microsoft Excel: ha gyorsan navigálunk a cellákon az NVDA most már sokkal gyorsabban reagál, és nagyobb valószínűséggel jelenti be a megfelelő cellát vagy kijelölést. (#14983, #12200, #12108)
* Az NVDA általánosságban gyorsabban reagál a beviteli parancsokra és az aktív elem megváltozására. (#14928)

## 2023.1

Új opció vált elérhetővé a beállítások Dokumentum-navigáció kategóriájában: Bekezdések stílusa.
Ez lehetővé teszi, hogy olyan szövegszerkesztő alkalmazásokban is működjön a bekezdésenkénti navigáció, amelyek alapvetően nem támogatják azt. Ilyen alkalmazás pl. a Jegyzettömb vagy a Notepad++.

Új beviteli parancs a hivatkozáshoz tartozó URL lekérdezésére. Alapértelmezés szerint: NVDA+k

Javult a mellékszövegekkel ellátott webes tartalom kezelhetősége. Ilyen mellékszöveg pl. a megjegyzés vagy a lábjegyzet.
Az NVDA+d navigációs paranccsal lehet elérni az ilyen tartalmakat.

Új támogatott Braille kijelzők: Tivomatic Caiku Albatross 46/80.

Javult a Windows ARM64 és AMD64 verzióinak támogatása.

Számos hibajavítás, különös tekintettel a Windows 11-re.

Frissült az eSpeak, a LibLouis braille fordító, a Sonic rate boost és a CLDR is.
Új Braille táblákat adtak hozzá grúz, szuahéli és csicseva nyelvekhez.

Figyelem!

* Ez a kiadás megköveteli a bővítmények kompatibilitásának a felülvizsgálatát.

### Újdonságok

* Microsoft Excel UI Automation használatával: Automatikus sor- és oszlopfejléc bejelentése a táblázatokban. (#14228)
  * A Beszúrás menü Táblázat opciójával táblázatként formázott adatsorok esetén működik.
  A táblázatstílus beállításai közt található "Fejlécsor" és "Első oszlop" opciók bekapcsolása esetén kezeli a program a táblázat első sorát oszlopfejlécként, ill. első oszlopát sorfejlécként.
  * Viszont nem tudja kezelni a kimondottan a képernyőolvasók számára beállított sor- és oszlopfejléceket. Ez jelenleg nem támogatott az UI automation használatával.
* Új szkript: Késleltetett betűzés a kurzor mozgásakor opció be- és kikapcsolására. Alapértelmezés szerint nincs hozzárendelve billentyűparancs. (#14267)
* Windows terminal: A haladó beállítások közt kísérleti jelleggel beállítható az UIA értesítés az újonnan megjelenő vagy megváltoztatott szövegek bejelentésére. (#13781)
  - 
* Windows 11 ARM64: Mostantól már böngészőmódban is kezelhetők  az AMD64 alkalmazások, mint pl. Firefox, Google Chrome és 1Password. (#14397)
* Új kategória és új opció a beállítások között: Dokumentum-navigáció, azon belül jelenleg az egyetlen opció a "Bekezdések stílusa".
 Ezzel az opcióval be lehet állítani a bekezdésenkénti navigáció stílusát. Választani lehet az egysoros azaz normál, ill. a többsoros bekezdésblokk közül.
Ez lehetővé teszi, hogy olyan szövegszerkesztő alkalmazásokban is működjön a bekezdésenkénti navigáció, amelyek alapvetően nem támogatják azt. Ilyen alkalmazás pl. a Jegyzettömb vagy a Notepad++. (#13797)
* Az NVDA már jelzi, ha egy elemhez több mellékszöveg is tartozik egyszerre.
A mellékszövegek navigációs parancsa (NVDA+D) már navigál az egyes szavak különböző típusú mellékszövegei között.
Például ha egy szöveghez rögzítve van egy megjegyzés és egy lábjegyzet is. (#14507, #14480)
* Támogatás a Tivomatic Caiku Albatross 46/80 braille kijelzőkhöz. (#13045)
* Új általános parancs: Hivatkozáshoz tartozó URL lekérdezése, alapértelmezett billentyűparancsa: `NVDA+k`.
Egyszeri lenyomásra bemondja a hivatkozáshoz tartozó URL címet.
Kétszeri lenyomásra egy szövegnavigációs parancsokkal kezelhető ablakban jeleníti meg. (#14583)
* Új szkript: Hivatkozáshoz tartozó URL megjelenítése egy szövegnavigációs parancsokkal kezelhető ablakban.
Ugyanaz, mint a Hivatkozáshoz tartozó URL lekérdezése parancs kétszeri lenyomása, de ebben a változatban hasznosabb a braille kijelzők tulajdonosainak. (#14583)

### Változások

* Frissült a LibLouis braille fordító, új verzió: [3.24.0](https://github.com/liblouis/liblouis/releases/tag/v3.24.0). (#14436)
  * Nagyobb frissítés a magyar, az egységesített angol és a kínai bopomofo braille táblákhoz.
  * Az NVDA mostantól támogatja a 2022-es dán braille szabványt.
  * Új braille táblák: Grúz irodalmi braille, Szuahéli (Kenya) és Csicseva (Malavi).
* Frissült a Sonic rate boost library, új verzió: commit `1d70513`. (#14180)
* Frissült a CLDR, új verzió: 42.0. (#14273)
* Frissült az eSpeak NG, új verzió: 1.52-dev commit `f520fecb`. (#14281, #14675)
  * Javult a hosszú számok bemondása. (#14241)
  * Java alkalmazásokban, ha egy vezérlő állapota kijelölhető, akkor az NVDA mostantól akkor jelenti be az állapotot, ha nincs kijelölve. (#14336)
-

### Hibajavítások

* Windows 11:
  * Az NVDA már bejelenti a kiemelt kereséseket a Start menü megnyitásakor. (#13841)
  * ARM rendszereken az x64 alkalmazások már nem ARM64 alkalmazásokként vannak azonosítva. (#14403)
  * A vágólap történet menüjének elemei már kezelhetők az NVDA-val. (#14508)
  * Windows 11 22H2 és újabb kiadásokban ismét lehetséges mind az egérrel, mind érintő parancsokkal kezelni az olyan helyeket, mint a Rendszertálca túlcsorduló területe, vagy a "Megnyitás a következővel" párbeszédablak. (#14538, #14539)
* Microsoft Excel: Ha egy hozzászólás írásakor @ jel használatával akarunk említeni valakit, most már megjelennek a javaslatok. (#13764)
* Google Chrome: Az NVDA már bejelenti  a címsávban megjelenő javaslat vezérlőket (pl. javaslat eltávolítása). (#13522)
* Formázási információk lekérdezésénél az NVDA már a tényleges színt mondja be, nem csak annyit, hogy "Alapértelmezett szín". A Wordpad és a Naplónéző esetében is működik. (#13959)
* Firefox: ?Most már megfelelően működik a "Show options" gomb a GitHub issue oldalain. (#14269)
* Outlook 2016 / 365: A Részletes keresés párbeszédablakán található dátumválasztó használatakor az NVDA már bejelenti a címkéket és értékeket. (#12726)
* Az ARIA kapcsoló vezérlőket már kapcsolóként azonosítja a Firefox, a Chrome és az Edge is. Korábban jelölőnégyzetként voltak kezelve. (#11310)
* Az NVDA már képes lekérdezni egy HTML táblázat oszlopának rendezési állapotát az oszlopfejlécből, amennyiben azt egy belső gomb lenyomásával megváltoztatták. (#10890)
* Az NVDA már automatikusan bejelenti egy jelzőpont vagy terület nevét, amennyiben gyorsnavigációs paranccsal ilyen elemre navigálunk az elemen kívülről. (#13307)
* Amennyiben a nagybetűk jelzése be van kapcsolva, akár beszéddel, akár hangjelzéssel, Késleltetett betűzésnél az NVDA már nem jelzi duplán a nagybetűket. (#14239)
* Java alkalmazások: Az NVDA már sokkal pontosabban jelenti be a táblázatban található vezérlőket. (#14347)
* Néhány, egyszerre több profilban is rögzített beállítás most már nem változik meg kéretlenül. (#14170)
  * Érintett beállítások:
    * Behúzások a dokumentumformázás beállításaiban
    * Cellaszegélyek a Dokumentumformázás beállításaiban
    * Üzenetmegjelenítés a Braille beállításokban.
    * A Braille követi a Braille beállításokban
  * Ritkán előforduló esetekben, amikor ezek a beállítások egy profilban is szerepeltek, az NVDA frissítése után megváltoztak.
  * Miután frissítette az NVDA-t erre a verzióra ellenőrizze azokat a profiljait, amelyekben a felsorolt beállítások szerepelhetnek!
* Az Emodzsikat az NVDA a korábbinál több nyelven tudja kezelni. (#14433)
* Braille: Több elem esetében most már braille-ben is megjeleníthetők a mellékszövegekre vonatkozó információk. (#13815)
* Javítottak egy hibát, mely azt okozta, hogy az "Alapértelmezett" beállítási lehetőséggel rendelkező opcióknál, amikor az értéket megváltoztattuk az "Alapértelmezett" beállításról az annak megfelelő értékre, a beállítások mentése nem az elvárásoknak megfelelően történt. (#14133)
* Az NVDA beállításakor legalább egy gombot mindenképpen meg kell adni,amit a program NVDA gombként használhat. Ha a felhasználó valamiért nem teszi meg ezt a beállítást, az NVDA a Caps Lock billentyűt fogja használni. (#14527)
* Ha az értesítési területen nyitjuk meg az NVDA menüjét, már nem fog hibásan függőben lévő telepítésre figyelmeztetni olyankor, amikor egyébként nincs is elérhető frissítés. (#14523)
* Foobar2000: Mostantól az 1 napnál hosszabb audiófájlok esetében is megfelelően működik a hátralévő, az eltelt és a teljes idő lekérdezése. (#14127)
* webböngészők (Chrome és Firefox): A figyelmeztetések már Brailleban is megjeleníthetők. (#14562)
* Firefox: Javítottak egy hibát, ami korábban a táblázatok első és utolsó oszlopára navigáláskor jelentkezett. (#14554)
* Amennyiben az NVDA "--lang=Windows" paraméterrel lett elindítva, ismét meg lehet nyitni az NVDA Általános beállítások ablakát. (#14407)
* Kindle for PC: Az NVDA már folytatja az olvasást új oldalra lapozás után is. (#14390)

## 2022.4

Ez a kiadás számos új billentyűparancsot tartalmaz, többek között folyamatos felolvasáshoz táblázatokban.
A hibajavítások sem maradhattak el.

Frissült az eSpeak és  a LibLouis Braille fordító.
Új kínai, svéd, Lugandai és ruandai braille táblák.

### Újdonságok

* Az angol nyelvű felhasználói útmutató kibővült egy "Quick Start Guide" szekcióval. (#13934)
* Új billentyűparancs az aktív elemhez tartozó gyorsbillentyű lekérdezésére. (#13960)
  * Asztali kiosztás esetén: `shift+numpad2`.
  * Laptop kiosztás esetén: `NVDA+ctrl+shift+.`.
* Új billentyűparancsok az áttekintőkurzor oldalankénti mozgatására, ahol ezt az alkalmazás támogatja. (#14021)
  * Az előző oldalra lép:
    * Asztali: `NVDA+pageUp`.
    * Laptop: `NVDA+shift+pageUp`.
  * A következő oldalra lép:
    * Asztali: `NVDA+pageDown`.
    * Laptop: `NVDA+shift+pageDown`.
* Új táblázatnavigációs parancsok. (#14070)
  * Folyamatos felolvasás az oszlopban: `NVDA+control+alt+downArrow`
  * Folyamatos felolvasás a sorban: `NVDA+control+alt+rightArrow`
  * Teljes oszlop felolvasása: `NVDA+control+alt+upArrow`
  * Teljes sor felolvasása: `NVDA+control+alt+leftArrow`
* Microsoft Excel UI Automation használatával: Az NVDA már bejelenti, ha egy munkalapon kilépünk egy táblázatból. (#14165)
* A táblázatfejlécek bejelentése már külön állítható a sorokhoz és oszlopokhoz. (#14075)

### Változások

* Frissült az eSpeak NG, új verzió: 1.52-dev commit `735ecdb8`. (#14060, #14079, #14118, #14203)
  * Mandarin nyelv használata esetén javították a latin betűk bemondását. (#12952, #13572, #14197)
* Frissült a LibLouis braille fordító, új verzió: [3.23.0](https://github.com/liblouis/liblouis/releases/tag/v3.23.0). (#14112)
  * Új Braille táblák:
    * Kínai általános braille (egyszerűsített kínai írásjelek)
    * ruandai irodalmi braille
    * Lugandai irodalmi braille
    * Svéd, rövidítési fokozat 1
    * Svéd, részben rövidírásos
    * Svéd, rövidítési fokozat 2
    * Kínai (Kína, mandarin) hagyományos Braille írásrendszer (hangzás nélkül) (#14138)
* Az NVDA által gyűjtött használati adatok közt most már az operációs rendszer architektúrája is szerepel. (#14019)

### Hibajavítások

* Ha az NVDA-t a Windows Package Manager CLI (winget) használatával frissítjük, az NVDA stabil verzióját nem fogja a rendszer indokolatlanul újabbnak érzékelni a tesztelésre szánt alpha verzióknál. (#12469)
* Java alkalmazások: Az NVDA már helyesen kezeli a csoport dobozokat. (#13962)
* A rendszerkurzor már helyesen követi a felolvasott szöveget "Folyamatos felolvasás" használatakor az olyan alkalmazásokban mint Bookworm, WordPad vagy az NVDA Naplónéző. (#13420, #9179)
* UI Automationt használó programokban az NVDA már helyesen jelenti be a félig bejelölt jelölőnégyzeteket. (#13975)
* Javult a kezelhetőség és a stabilitás Microsoft Visual Studioban, a Windows Terminalban, és más UI Automationt használó alkalmazásokban. (#11077, #11209)
  * Ezek a hibajavítások a Windows 11 Sun Valley 2 (22H2) és újabb verzióiban jelennek meg.
  * Haladó beállítások: "UI automation elemek és tulajdonságok regisztrálása" opció alapértelmezett értéke mostantól "Szelektív".
* Visual Studio 2022: a szövegfelolvasás , a Braille kimenet és a jelszavak kezelése is már az elvárt módon működik. (#14194)
* Az NVDA most már DPI képes többmonitoros használat esetén.
Számos hibajavítás történt, amikor a DPI értéke 100 százaléknál nagyobb, ill. többmonitoros használat esetén.
A hibák továbbra is fennállhatnak  Windows 10 1809 verziónál régebbi operációs rendszert futtató felhasználóknál.
Ezek a hibajavítások csak DPI képes alkalmazások kezelése esetén eredményesek.
Ismert problémák továbbra is fennállnak Chrome és Edge esetében. (#13254)
  * A vizuális kiemelőkeretek már az elvárt módon jelzik az aktív elemet a legtöbb alkalmazásban. (#13370, #3875, #12070)
  * Az érintési parancsok most már jól működnek a legtöbb alkalmazásban. Érintőképernyős használat esetén természetesen. (#7083)
  * Az egérmutató követése már helyesen működik a legtöbb alkalmazásban. (#6722)
* A képernyőtájolás (álló/fekvő) állapotát most már nem jelenti be az NVDA, ha nem történik tényleges változás a beállításban, pl. amikor új monitort kapcsolunk a rendszerre. (#14035)
* Az NVDA már bejelenti a drag & drop művelet eredményét az olyan átrendezhető helyeken, mint pl. a csempék a Windows 10 start menüjében, vagy a Windows 11 virtuális asztalai. (#12271, #14081)
* Haladó beállítások: Most már a "Hangjelzés naplózási hibánál" opció is visszaáll az alapértelmezett értékre, amikor visszaállítjuk az NVDA gyári beállításait. (#14149)
* Java alkalmazások: Az NVDA már ki tud jelölni szöveget az `NVDA+f10` billentyűparancs segítségével. (#14163)
* Microsoft Teams: Az NVDA már nem ragad benne egy menüben, amikor a beszélgetések között mozgunk a le- és felnyíl segítségével. (#14355)

## 2022.3.2

Ez egy köztes kiadás, melyben javítottak néhány   a 2022.3.1 kiadás által okozott hibát, illetve bezártak egy biztonsági rést is.

### Biztonsági javítások

* Ez a hibajavítás megakadályozza a nem hitelesített felhasználók esetleges rendszerszintű hozzáférését.
([GHSA-3jj9-295f-h69w](https://github.com/nvaccess/nvda/security/advisories/GHSA-3jj9-295f-h69w))

### Hibajavítások

* Javítottak egy a 2022.3.1 kiadás által okozott hibát, mely bizonyos funkciók használatát ellehetetlenítette a biztonsági képernyőn. (#14286)
* Javítottak egy a 2022.3.1 kiadás által okozott hibát, ami bizonyos funkciók működését ellehetetlenítette a bejelentkezés után,amennyiben az NVDA a zárolási képernyőn indult el. (#14301)

## 2022.3.1

Ez egy köztes kiadás, mely néhány biztonsági javítást tartalmaz.

### Biztonsági javítások

* Kiavították azt a sebezhetőséget, amely lehetővé tette, hogy illetéktelen felhasználó rendszerszintű hozzáféréshez jusson.
([GHSA-q7c2-pgqm-vvw5](https://github.com/nvaccess/nvda/security/advisories/GHSA-q7c2-pgqm-vvw5))
* Kijavították azt a sebezhetőséget, amely lehetővé tette, hogy egy NVDA indító paraméter segítségével az NVDA hozzáférjen a python konzolhoz a Windows zárolási képernyőjén.
([GHSA-72mj-mqhj-qh4w](https://github.com/nvaccess/nvda/security/advisories/GHSA-72mj-mqhj-qh4w))
* Kijavították azt a hibát, amely miatt a Beszédnéző tartalma gyorsítótárba került a Windows zárolásakor.
([GHSA-grvr-j2h8-3qm4](https://github.com/nvaccess/nvda/security/advisories/GHSA-grvr-j2h8-3qm4))
* Kijavították azt a sebezhetőséget, mely lehetővé tette, hogy egy illetéktelen felhasználó megváltoztassa a Beszédnéző és a Braille néző beállításait a zárolási képernyőn. ([GHSA-grvr-j2h8-3qm4](https://github.com/nvaccess/nvda/security/advisories/GHSA-grvr-j2h8-3qm4))

## 2022.3

E kiadás változásainak és hibajavításainak jelentős része az NVDA fejlesztői közösségének köszönhető.
Ezek közé tartozik a Késleltetett betűzés a kurzor mozgásakor opció, illetve a Windows konzol hatékonyabb kezelhetősége.

A hibajavítások sem maradhattak el.
Fontos javítás, hogy az Adobe Acrobat/Reader legújabb verzióit használva már nem okoz problémát egy PDF dokumentum olvasása.

Frissült az eSpeak, 3 új nyelvvel bővült: belarusz, luxemburgi és Totontepec Mixe.

### Újdonságok

* A parancssor, a PowerShell és a Linux futtatására szánt windows alrendszer által használt Windows konzol a Windows 11 22H2 (Sun Valley 2) és újabb verzióiban:
  * Jelentősen javult a kezelhetőség és a stabilitás. (#10964)
  * Szöveg keresésére szolgáló parancs (Ctrl+F) használatakor az áttekintő kurzor a találatra ugrik. (#11172)
  * A képernyőn meg nem jelenő beírt szöveget, pl. jelszót, alapértelmezés szerint már nem mondja be az NVDA.
Az opció visszakapcsolható az NVDA haladó beállításaiban. (#11554)
  * A képernyő látható részén kívüli szöveg már áttekinthető az Áttekintő kurzorral a konzol tényleges görgetése nélkül is. (#12669)
  * A korábbinál jóval részletesebb formázási információkat tud közölni az NVDA. ([microsoft/terminal PR 10336](https://github.com/microsoft/terminal/pull/10336))
* Új opció a Beszéd beállításai között: "Késleltetett betűzés a kurzor mozgásakor" (#13509)
* Új opció a Braille beállítások között: Beszéd megszakítása görgetéskor. (#2124)

### Változások

* Frissült az eSpeak NG, új verzió: 1.52-dev commit `9de65fcb`. (#13295)
  * Új nyelvek:
    * belarusz
    * luxemburgi
    * Totontepec Mixe
* Microsoft Excel UI Automation használatával: az NVDA már felismeri az egyesített cellákat. (#12843)
* Ha az NVDA be tudja azonosítani a cella jellegét, akkor mindenképpen azt fogja bemondani, pl. megjegyzés. (#13649)
* Az NVDA telepítési mérete már olvasható a telepített alkalmazások listáján. (#13909)

### Hibajavítások

* Az Adobe Acrobat / Reader 64 bit már nem omlik össze PDF dokumentum megnyitásakor. (#12920)
  * Fontos tudni, hogy csak az Adobe Acrobat / Reader legújabb verziója esetén lesz zavartalan a PDF olvasás.
* A betűméret mérési egységek már lefordíthatók az NVDA-ban. (#13573)
* az NVDA már figyelmen kívül hagyja az olyan Java Access Bridge eseményeket, amikor a Java alkalmazáshoz nem tartozik kezelőablak.
Ez javítja bizonyos Java alkalmazások kezelhetőségét, pl. IntelliJ IDEA. (#13039)
* LibreOffice Calc: Sokat  javult a kijelölt cellák bemondása és már nem okozza a Calc lefagyását, ha egyszerre sok cella van kijelölve. (#13232)
* Microsoft Edge: Ha másik felhasználóval jelentkezik be, már nem lesz elérhetetlen a böngésző. (#13032)
* Ha a "Sebességfokozás" opció ki van kapcsolva, az eSpeak beszédsebessége  már nem viselkedik furcsán 99% és 100% közti beállítás változtatásnál. (#13876)
* Javították azt a hibát, ami lehetővé tette, hogy a beviteli parancsok ablakából kettő is nyitva legyen egyszerre. (#13854)

## 2022.2.4

Ez egy köztes kiadás,melyben javítottak egy biztonsági hibát.

### Hibajavítások

* Kijavították azt a sebezhetőséget, mely lehetővé tette, hogy illetéktelen felhasználó megnyissa az NVDA python konzolát a Naplónézőből a Windows zárolási képernyőjén.
([GHSA-585m-rpvv-93qg](https://github.com/nvaccess/nvda/security/advisories/GHSA-585m-rpvv-93qg))

## 2022.2.3

Ez egy köztes kiadás, melyben kijavították a 2022.2.1 kiadás által okozott hibát.

### Hibajavítások

* Kijavították azt a hibát, ami miatt az NVDA nem jelentette be  a Biztonsági képernyőt, amikor épp egy olyan képernyőre került a fókusz.
Ennek hatására az NVDA remote nem volt képes beazonosítani a biztonsági képernyőt. (#14094)

## 2022.2.2

Ez egy köztes kiadás, melyben kijavították a 2022-2.1 kiadás által a beviteli parancsokkal kapcsolatban okozott hibát.

### Hibajavítások

* Kijavították azt a hibát, amely miatt a beviteli parancsok nem mindig működtek. (#14065)

## 2022.2.1

Ez egy köztes kiadás, melyben biztonsági hibákat javítottak.

### Biztonsági javítások

* Felszámolták azt a sebezhetőséget, amely lehetővé tette a python konzol futtatását a Windows zárolási képernyőjén. (GHSA-rmq3-vvhq-gp32)
* Felszámolták azt a sebezhetőséget, amely miatt elemnavigációval lehetséges volt elnavigálni a zárolási képernyőről jelszó beírása nélkül is. (GHSA-rmq3-vvhq-gp32)

## 2022.2

Ez a kiadás számos hibajavítást tartalmaz.
 Jelentős javítások a Java alapú alkalmazásokhoz, Braille kijelzőkhöz és a Windows funkcióihoz.

Új táblázatnavigációs parancsokat adtak hozzá.
Frissült az Unicode CLDR.
Frissült a LibLouis Braille fordító is, egy új német braille táblát adtak hozzá.

### Újdonságok

* Microsoft Office: támogatás a Microsoft Loop összetevők kezeléséhez. (#13617)
* Új táblázatnavigációs parancsokat adtak hozzá. (#957)
 * `ctrl+alt+home/end` az első és az utolsó oszlopra ugráshoz.
 * `ctrl+alt+pageUp/pageDown` az első és az utolsó sorra ugráshoz.
* Új szkript a nyelv és dialektusváltás beállítására. Alapértelmezés szerint nincs beviteli parancs hozzárendelve. (#10253)

### Változások

* Frissült az NSIS, új verzió: 3.08. (#9134)
* Frissült a CLDR, új verzió: 41.0. (#13582)
* Frissült a LibLouis braille fordító, új verzió: [3.22.0](https://github.com/liblouis/liblouis/releases/tag/v3.22.0). (#13775)
  * Új Braille tábla: Német rövidítési fokozat 2 (részletes)
* Meghatározhatatlan értékű folyamatjelzők kezelése. (#10644)
* Az NVDA már tudatja a felhasználóval, ha egy művelet nem hajtható végre. (#13500)
  * Ilyen esetek pl.:
    * az NVDA Microsoft Storeből telepített kiadásának használata.
    * Biztonsági képernyőn.
    * az NVDA egyik párbeszédablaka felhasználói beavatkozásra vár.

### Hibajavítások

* Javítások Java alapú alkalmazásokhoz:
  * az NVDA már bejelenti a csak olvasható állapotot. (#13692)
  * az NVDA már helyesen jelenti be az engedélyezett/letiltott állapotot. (#10993)
  * az NVDA már bejelenti a funkcióbillentyűkkel végrehajtott parancsokat. (#13643)
  * az NVDA már képes hangjelzést és beszédbeli visszajelzést is adni a folyamatjelzőkön. (#13594)
  * az NVDA már nem távolítja el a szöveget a widgetekről. (#13102)
  * az NVDA már bejelenti a többállapotú gombok állapotát. (#9728)
  * az NVDA már képes kezelni a többablakos Java alkalmazásokat. (#9184)
  * az NVDA már képes pozícióinformációkat adni a fülvezérlőkhöz. (#13744)
* Braille javítások:
  * Javították a Braille kimenetet Mozilla rich edit vezérlőben történő navigálás esetén pl. üzenetírás a thunderbirdben. (#12542)
  * Ha a Braille követés automatikusra van állítva és az egérkövetés is be van kapcsolva, akkor egér mozgatása esetén
   A szövegáttekintő parancsok használatakor a Braille kijelzőn is megjelennek a kimondott szavak. (#11519)
  * A Braille kijelzőn át lehet pásztázni a tartalmat szövegáttekintő parancsok használata után. (#8682)
* Az NVDA telepítője most már képes olyan mappából is elindulni,aminek a neve tartalmaz speciális karaktereket. (#13270)
* Firefox: Az NVDA már nem  mulasztja el bejelenteni az olyan elemeket a weblapokon, ahol aria-rowindex, aria-colindex, aria-rowcount és aria-colcount attribútum sincs megadva. (#13405)
* A kurzor már nem vált kéretlenül sort vagy oszlopot, ha egyesített cellákon navigálunk táblázatnavigációs parancsokkal. (#7278)
* Adobe Reader: Ha nem interaktív pdf dokumentumokat olvasunk az NVDA már bejelenti az űrlapmezők típusát és állapotát. (pl. jelölőnégyzetek és választógombok) (#13285)
* "A gyári beállítások visszaállítása" opció már elérhető az NVDA menüjéből, ha az NVDA csökkentett/biztonsági módban van. (#13547)
* Az NVDA bezárásakor az NVDA egérkezelő parancsaival nyomva tartott állapotba hozott egérgombnak feloldódik a nyomva tartása. Korábban a nyomva tartott állapot megmaradt az NVDA bezárása után is. (#13410)
* Visual Studio: Az NVDA már be tudja jelenteni a sorok számát. (#13604)
  * Az opció megfelelő működéséhez be kell kapcsolni a sorszámok megjelenítését mind a Visual Studioban mind az NVDA beállításai között a dokumentumformázás kategóriában.
* Visual Studio: Az NVDA már helyesen jelenti be a sorok behúzását. (#13574)
* Az NVDA ismét megfelelően jelenti be a start menüben történő keresés részleteit mind a windows 10, mind a Windows 11 legújabb verzióiban. (#13544)
* Windows 10 és 11 Számológép 10.1908 és újabb verziói: Az NVDA már bejelenti az eredményt akkor is, ha több parancs is le van nyomva, pl a tudományos mód parancsai. (#13383)
* Windows 11: Egérkezelő és érintési parancsokkal ismét kezelhetőek a felhasználói felület bizonyos elemei, a tálca és a feladatnézet. (#13506)
* Windows 11 Jegyzettömb: Az NVDA már bejelenti az állapotsor tartalmát. (#13688)
* A navigátor objektum vizuális kiemelése már közvetlenül az opció aktiválása után megjelenik. (#13641)
* Kijavították az egyoszlopos listanézet elemeinek olvasását. (#13659, #13735)
* Kijavították az eSpeak automatikus nyelvváltás során fennálló hibáját. Az angol megfelelően vált brit angolra, míg a francia franciaországi franciára. (#13727)
* Kijavították az OneCore beszédmotor automatikus nyelvváltása során előforduló hibát. (#13732)

## 2022.1

Ebben a kiadásban jelentős fejlesztések a Microsoft Office vezérlőinek UI automation használatával történő kezelésében.
A Microsoft Office 16.0.15000 és újabb verziók esetén Windows 11 alatt az NVDA alapértelmezés szerint már UI Automation használatával kezeli a Microsoft Word dokumentumokat.
Ez jelentős javulás a korábbi objektum alapú eléréshez képest.

Fejlesztések a következő braille kijelző driverekhez: Seika Notetaker, Papenmeier és HID Braille. 
Windows 11 hibajavítások a következő alkalmazásokhoz: Számológép, Konzol, Terminal, Posta és Emoji Panel.

Frissült az eSpeak-NG és a  LibLouis Braille fordító. Új Braille táblákat adtak hozzá japán, német és katalán nyelvekhez.

Megjegyzés:

 * Ez a kiadás  megköveteli a meglévő bővítmények kompatibilitásának elllenőrzését. Előfordulhat, hogy bizonyos bővítmények átmenetileg nem fognak működni.

### Újdonságok

* Ms Excel Ui automation használatával Windows 11 alatt: Az NVDA már bemondja, ha egy cella jegyzetet tartalmaz. (#12861)
* MS Word UI Automation használatával Windows 11 alatt: Az NVDA már felismeri a dokumentumban a könyvjelzőket, szerkesztés alatt álló megjegyzéseket és a lezárt beszélgetéseket. A visszajelzés beszédben és Braille-ben egyaránt elérhető. (#12861)
* Az új parancssori paraméter  `"--lang" használatával átmenetileg felülírható az NVDA felületének korábban beállított nyelve. (#10044)
* Az NVDA már figyelmeztet, ha olyan parancssori paraméterrel indítjuk el, amit nem képes kezelni. (#12795)
* MS Word UI Automation használatával: az NVDA már képes a mathPlayer-rel kezelni az Office matematikai kifejezéseit. (#12946)
  * Csak Microsoft Word 365/2016 build 14326 vagy újabb verziók esetén működik. 
  * A matematikai kifejezéseket manuálisan kell konvertálni Office Math formátumra. Ehhez a helyi menüből válassza az Egyenlet beállításai >> Konvertálás Office Math formátumba lehetőséget.
* A Bővebb leírás meglétének jelzését és a kapcsolódó billentyűparancsot frissítették, hogy működjön fókuszmódban is. (#13106)
* Braille: Az NVDA már képes automatikusan észlelni a Seika Notetaker kijelzőket akkor is, ha USb-n keresztül és akkor is ha bluetooth-on keresztül csatlakoztatja. (#13191, #13142)
  * Ez az alábbi kijelzőket érinti: MiniSeika (16, 24 cells), V6 és V6Pro (40 cells)
  * A bluetooth kommunikációs port kézi kiválasztása is lehetségessé vált.
* Billentyűparancs rendelhető a Braille-néző ki- és bekapcsolásához. Nincs alapértelmezett billentyűparancs hozzárendelve. (#13258)
* Braille: Most már módosítóbillentyűk különböző kombinációi is emulálhatók braille kijelzővel. (Ctrl+Alt, Alt+Shift, stb.) (#13152)
* A kivételszótárak párbeszédablakán most már lehetőség van a kivételszótár minden bejegyzésének egyidejű törlésére. Ehhez használja az új "Minden bejegyzés törlése" gombot. (#11802)
* Támogatás a Windows 11 Számológép alkalmazásához. (#13212)
* MS Word UI Automation használatával a  Windows 11 alatt: Az NVDA már bejelenti a sorok és a szakaszok számát. (#13283, #13515)
* Microsoft Office 16.0.15000 és újabb verzióinál Windows 11 alatt az NVDA most már alapértelmezetten UI automation használatával fér hozzá a dokumentumvezérlőkhöz. Ez jelentős javulást jelent a korábbi objektum-alapú eléréshez képest. (#13437)
 * Ez a metódus a Microsoft Word dokumentumaiban és az Outlook üzenetek olvasása és írása közben is működik. 

### Változások

* Frissült az Espeak-ng, új verzió: 1.51-dev commit `7e5457f91e10`. (#12950)
* Frissült a Liblouis braille fordító, új verzió: [3.21.0](https://github.com/liblouis/liblouis/releases/tag/v3.21.0). (#13141, #13438)
  * Új braille táblák: Japán (Kantenji) irodalmi braille, Német 6 pontos számítógépes braille, Katalán rövidítési fokozat 1. (#13408)
* LibreOffice Calc 7.3 és újabb verziói: Az NVDA már bejelenti a kijelölést és az egyesített cellákat. (#9310, #6897)
* Frissült az Unicode Common Locale Data Repository (CLDR), új verzió: 40.0. (#12999)
* Az NVDA+Numpad Delete billentyűparancs mostantól alapértelmezés szerint a kurzor vagy az aktív elem pozícióját közli. (#13060)
* Az NVDA+Shift+Numpad Delete mostantól alapértelmezés szerint az áttekintőkurzor pozícióját közli. (#13060)
* Braille: Billentyűparancsokat rendeltek módosító billentyűk emulálására a Freedom Scientific braille kijelzőkhöz. (#13152)
* A Formátum lekérdezésére szolgáló parancs (NVDA+F) már nem jelenti be az alapvonalat a formátum leírásában. (#11815)
* A "Megmutatja a bővebb leírást" szkripthez most már nincs alapértelmezetten parancs rendelve. (#13380)
* Új szkript: Összegzett leírás bejelentése a rendszerkurzornál található elemről. Alapértelmezett billentyűparancs: NVDA+d. (#13380)
* Az NVDA-t újra kell indítani a MathPlayer telepítése után. (#13486)

### Hibajavítások

* MS Office: az Office vágólap már nem ragadja magához kéretlenül a fókuszt a programok megnyitása után. (#12736)
* Ha a felhasználó a Windows egérbeállítások között felcserélte az egér gombjainak funkcióit, azaz a jobb egérgombot használja az alapértelmezetten a bal egérgombnak szánt funkciókra, akkor az NVDA most már  a felcserélésnek megfelelően jeleníti meg a helyi menüket bizonyos alkalmazásokban, pl.böngészőkben. (#12642)
* Ha az áttekintőkurzorral bizonyos szöveges vezérlők végéhez navigálunk, pl. a Microsoft Wordben UI Automation használatával, akkor az NVDA most már a korábbinál több esetben jelzi a vezérlő végét. (#12808)
* A 64 bites windowson futtatott 32 bites alkalmazások esetében az NVDA már bejelenti az alkalmazások nevét és verziószámát. Ez a system32 mappában található futtatható állományokra vonatkozik. (#12943)
* Javították a Terminál programok kimenetének felolvasását. (#12974)
  * Bizonyos esetekben,amikor egy sor belsejébe illesztünk be egy karaktert vagy épp törlünk onnan,akkor az NVDA bejelenti a kurzortól jobbra lévő karaktert.
* MS word UI Automation használatával: Böngészőmódban a címsorok közti navigáció gyorsbillentyűje már nem eredményezi azt, hogy a program leragadjon a dokumentum utolsó címsorán, illetve ez a címsor sem szerepel már duplán az NVDA elemlistában. (#9540)
* Windows 8 és újabb verziók: A Fájlkezelő állapotsora elérhető a kapcsolódó billentyűparanccsal. NVDA+end (asztali kiosztás) / NVDA+shift+end (laptop). (#12845)
* Skype for Business: Az NVDA ismét bejelenti egy beszélgetésben a bejövő üzeneteket. (#9295)
* Windows 11: A Hangerő-igazítás ismét működik SAPI5 beszédszintetizátor használatakor. (#12913)
* Windows 10 Számológép: az NVDA már bejelenti az Előzmények és a memória listaelemeinek címkéit. (#11858)
* HID Braille eszközök: A beviteli parancsok, mint pl a görgetés vagy routing ismét működnek. (#13228)
* Windows 11 Posta: Ha hosszú e-mailek olvasása közben programok közt váltogatunk, az NVDA már nem ragad le a levél egy soránál. (#13050)
* HID braille: Összetett beviteli parancsok mint pl. szóköz+4. pont most már végrehajthatók a braille kijelzőről. (#13326)
* Az NVDA beállítási ablakát már nem lehet több példányban megnyitni egyszerre. (#12818)
* Braille javítottak egy hibát,ami bizonyos Focus Blue Braille kijelzők működését megakasztotta miután alvó módból visszatért a Windows. (#9830)
* Az NVDA már nem jelenti be kéretlenül az "Alapvonal" szót a formázási információk között amennyiben a Felső és alsó index jelzése opció be van kapcsolva az NVDA Beállítások >> Dokumentumformázás ablakán. (#11078)
* Windows 11: A navigáció most már az elvártaknak megfelelően működik az Emoji panelen emodzsik kiválasztásakor. (#13104)
* Javították azt a hibát,ami miatt az NVDA dupla visszajelzést adott Windows konzol és Terminal használata során. (#13261)
* Javították azt a hibát,ami miatt bizonyos 64 bites alkalmazásokban (pl. a Reaper zeneszerkesztőben) az NVDA nem tudta megfelelően bejelenteni bizonyos listák elemeit. (#8175)
* Microsoft Edge: A letöltések listáján az NVDA automatikusan fókuszmódra vált,amikor a legutóbb letöltött elem a listán aktívvá válik. (#13221)
* Notepad++ 8.3 és újabb verziók: Az NVDA már nem okozza a 64 bites változat összeomlását. (#13311)
* Adobe Reader: Az NVDA már nem okoz hibát a program indulásakor, ha a védett mód engedélyezve van. (#11568)
* Kijavítottak egy hibát, mely a Papenmeier Braille kijelző driver kiválasztásakor az NVDA összeomlását okozta. (#13348)
* Microsoft word UI AUTOMATION használatával: Az NVDA már nem jelenti be kéretlenül az oldalszámot és más formázási információkat olyan esetekben,amikor  egy üres táblázatcellából navigálunk egy tartalommal rendelkező cellába, vagy ha a dokumentum végéről vissza a dokumentum tartalmához. (#13458, #13459)
* Google Chrome 100: Az NVDA ismét bemondja a címsort és nem kezdi el kéretlenül felolvasni az oldal tartalmát annak betöltődése után. (#13571)

## 2021.3.5

Ez egy köztes kiadás,amely biztonsági javítást tartalmaz.
 Ha a biztonságot érintő hiba jut a tudomására, haladéktalanul jelezze az <info@nvaccess.org> e-mail címen.

### Biztonsági hibajavítások

* Addressed security advisory `GHSA-xc5m-v23f-pgr7`.
  * Az Írásjelkiejtés ablaka le van tiltva csökkentett módban.

## 2021.3.4

Ez egy köztes kiadás,amely néhány biztonsági javítást tartalmaz.
 Ha a biztonságot érintő hiba jut a tudomására, haladéktalanul jelezze az <info@nvaccess.org> e-mail címen.

### Biztonsági hibajavítások

* Addressed security advisory `GHSA-354r-wr4v-cx28`. (#13488)
  * Ha az NVDA csökkentett módban fut, akkor nem lehet újraindítani Nyomkövetés naplózási szinttel.
  * Ha az NVDA csökkentett módban fut, nem lehet frissíteni.
* Addressed security advisory `GHSA-wg65-7r23-h6p9`. (#13489)
  * Ha az NVDA csökkentett módban fut, már nem lehet megnyitni a Beviteli parancsok ablakát.
  * Ha az NVDA csökkentett módban fut, a kivételszótárak ablakait nem lehet megnyitni.
* Addressed security advisory `GHSA-mvc8-5rv9-w3hx`. (#13487)
  * A wx GUI inspection tool már le van tiltva, ha az NVDA csökkentett módban fut.

## 2021.3.3

Ez a kiadás megegyezik a 2021.3.2 kiadással
Egy hiba miatt a 2021.3.2 kiadás 2021.3.1 verziószámmal azonosította magát. 
Jelen kiadás az elvárásnak megfelelően 2021.3.3 verzióként azonosítja magát.

## 2021.3.2

Ez egy köztes kiadás,amely néhány biztonsági javítást tartalmaz.
 Ha a biztonságot érintő hiba jut a tudomására, haladéktalanul jelezze az <info@nvaccess.org> e-mail címen.

### Hibajavítások

* Biztonsági javítás:: Most már elemnavigációval sem lehet a fókuszt kivinni a zárolási képernyőről. Windows 10 és Windows 11 alatt sem. (#13328)
* Biztonsági javítás: A Bővítménykezelő ablaka le van tiltva a biztonsági képernyőn. (#13059)
* Biztonsági javítás:: Az NVDA helyzetérzékeny súgója már nem érhető el a biztonsági képernyőn. (#13353)

## 2021.3.1

Ez egy köztes kiadás, amely kijavít néhány, a 2021.3 verzió által okozott hibát.

### Változások

* Az NVDA nem kényszeríti az új HID Braille protokoll használatát, amennyiben más alkalmas driver is elérhető. (#13153)
* A HID Braille protokoll már kikapcsolható a Haladó beállítások között. (#13180)

### Hibajavítások

* Az NVDA ismét bejelenti a helyjelzőket Braille-ben. (#13158)
* Kijavították az automatikus felismerés közben fellépő hibát az alábbi kijelzőknél:Humanware Brailliant és APH Mantis Q40. A probléma bluetoothos csatlakoztatás esetén lépett fel. (#13153)

## 2021.3

Ez a kiadás már támogatja az új HID Braille specifikációt.
Ez a specifikáció lehetővé teszi a különböző braille kijelzők egységes kezelését külön-külön driverek nélkül.
Frissült az eSpeak-NG és a LibLouis Braille fordító, orosz és venda braille táblákat adtak hozzá.
Egy új haladó beállításnak köszönhetően a hibajelző hangok már engedélyezhetők az NVDA stabil verzióiban is.
Ha folyamatos felolvasást használunk egy Microsoft Word dokumentumban az NVDA már automatikusan görgeti a dokumentumot, hogy az éppen felolvasott rész mindig látszódjon.
Számtalan fejlesztés történt az Office programcsomag UI Automationnal való használatában.
Egy ilyen UIA javítás, hogy az Outlook már többféle rétegződő táblázatot képes figyelmen kívül hagyni.

Fontos megjegyzések:

Az NVDA biztonsági tanusítványának frissítése néhány felhasználónál azt eredményezte, hogy az NVDA 2021.2 hibát jelzett programfrissítés keresésekor.
Az NVDA mostantól a Windowstól kéri a biztonsági tanusítványának frissítését, ez megelőzi a hasonló hibákat.
Az érintett felhasználóknak manuálisan kell letölteniük ezt a frissítést, a 2021.3 verziót.

### Újdonságok

* Új beviteli parancsot adtak hozzá, mellyel a cellaszegélyek bemondását lehet szabályozni. Szín és stílus, csak stílus, kikapcsolva. (#10408)
* Új HID Braille specifikáció támogatása, mely lehetővé teszi a Braille kijelzők egységes kezelését. (#12523)
  * A specifikációt támogató eszközöket az NVDA automatikusan észleli.
  * A specifikációval kapcsolatos további technikai részletekért keresse fel az alábbi oldalt: https://github.com/nvaccess/nvda/blob/master/devDocs/hidBrailleTechnicalNotes.md
* Támogatás a VisioBraille Vario 4 Braille eszközhöz. (#12607)
* Egy új haladó beállításnak köszönhetően a hibajelző hangok már engedélyezhetők az NVDA stabil verzióiban is. (#12672)
* Windows 10 és újabb kiadásokban az NVDA már bejelenti a javaslatok számát az olyan alkalmazások keresőmezőinél mint pl. a Gépház vagy a Microsoft Store. (#7330, #12758, #12790)
* A táblázatnavigáció már támogatott az olyan rácsvezérlőknél, melyeket Out-GridView parancsmag használatával hoztak létre a PowerShellben. (#12928)

### Változások

* Frissült az Espeak-ng, új verzió: 1.51-dev commit `74068b91bcd578bd7030a7a6cde2085114b79b44`. (#12665)
* Az NVDA alapértelmezés szerint az eSpeak beszédszintetizátorra vált, amennyiben a telepített OneCore hangok között nincs az NVDA-ban beállított nyelvnek megfelelő hangkarakter. (#10451)
* Amennyiben az OneCore hangok használata folyamatos problémákba ütközik az NVDA automatikusan átvált eSpeak beszédszintetizátorra. (#11544)
* Az állapotsor bemondása parancs használatakor (Alapértelmezés szerint: NVDA+end), az áttekintőkurzor már nem kerül az állapotsorra.
Amennyiben mégis szeretné ezt a korábbi viselkedést, beállíthat hozzá külön beviteli parancsot az NVDA beviteli parancsok párbeszédablakán. (#8600)
-  Ha valamilyen okból egy olyan NVDA beállítási ablakot akarunk megnyitni, amely már nyitva van, az NVDA hibajelzés helyett most már áthelyezi a fókuszt az ablakra. (#5383)
* Frissült a liblouis braille fordító, új verzió: [3.19.0](https://github.com/liblouis/liblouis/releases/tag/v3.19.0). (#12810)
  * Új braille táblák: orosz rövidítési fokozat 1, Venda rövidítési fokozat 1 és 2.  -
* A megjelölten kiemelt tartalmat mostantól "Kiemelt" tartalomként jelenti be az NVDA. A Braille kijelzőre a "kiem" jelzést küldi. (#12892)
* Az NVDA már nem záródik be, amennyiben egy párbeszédablaka még felhasználói beavatkozásra vár, pl. egy korábban végrehajtott változás megerősítésére vagy elvetésére. (#12984)

### Hibajavítások

* Javult a módosítóbillentyűk kezelése a Watchdog futása közben. (#12609)
* Újra működik az NVDA frissítések keresése bizonyos rendszereken, pl. tiszta Windows telepítés esetén. (#12729)
* Microsoft Word UI automation használatával: az NVDA már helyesen jelenti be az üres táblázatcellákat. (#11043)
* Webböngészés: ARIA adatrács cellákban az ESC gomb lenyomása a tartalom kezelését segíti és nem kapcsolja ki kéretlenül az NVDA fókuszmódját. (#12413)
* Google Chrome: Egy táblázat fejlécének olvasásakor az NVDA már nem jelenti be kétszer az oszlop nevét. (#10840)
* Az NVDA már nem jelenti be egy UIA csúszka értékét számként, amennyiben  bizonyos értékeihez szöveges reprezentáció tartozik. (A megfelelő érték bejelentéséhez most már az UIA ValuePattern paramétert veszik alapul a RangeValuePattern paraméter helyett). (#12724)
* Az NVDA már nem kezeli úgy az UIA csúszkákat, mintha azok csak százalékos értéket vehetnének fel.
* Microsoft Excel, Windows 11: az NVDA már helyesen jelenti be a cellák helyét UI automation használatával. (#12782)
* Az NVDA már nem állít be érvénytelen Python lokalizációt. (#12753)
* Amennyiben egy korábban letiltott bővítményt eltávolítunk majd később újra telepítünk a státusza engedélyezett lesz. Korábban az újratelepítés után az NVDA emlékezett az előzőleg letiltott állapotra, így a használat előtt a felhasználónak engedélyeznie kellett a kérdéses bővítményt. (#12792)
* Javítottak bizonyos hibákat melyek bővítmények frissítésekor és eltávolításakor léptek fel olyan esetekben, amikor a bővítmény mappáját átnevezték vagy az egyik fájlja éppen használatban volt. (#12792, #12629)
* Microsoft Excel UI Automation használatával: Az NVDA már nem ad kéretlenül többszöri visszajelzést egy cella kijelöléséről. (#12530)
* LibreOffice Writer: Az NVDA már több párbeszédablak szövegét képes automatikusan felolvasni, többek között a felhasználó megerősítését kérő párbeszédablakoknál is. (#11687)
* Microsoft Word UI Automation használatával: Böngészőmódban ha olvasunk vagy navigálunk egy dokumentumban, a Word mostantól már mindig görgetni fogja a dokumentumot úgy, hogy a böngészőmód kurzorának pozíciója mindig látszódjon a képernyőn. Ezen kívül a fókuszmód rendszerkurzora is az elvártaknak megfelelően követi a böngészőmód kurzorát. (#9611)
* Microsoft Word UI automation használatával: Folyamatos felolvasás közben a program automatikusan görgeti a dokumentumot és a kurzor pozíciója is mindig a felolvasással összhangban frissül. (#9611)
* Microsoft Outlook UI Automation használatával: E-mailek olvasása közben az NVDA már több táblázatot is rétegződőként azonosít, és alapértelmezés szerint nem jelent be táblázatként. Ez hatékonyabbá teszi a navigációt. (#11430)
* Javítottak egy audio eszközök váltásakor ritkán fellépő hibát. (#12620)
* Irodalmi Braille táblák használata esetén a bevitel jobban működik a szerkesztőmezőknél. (#12667)
* Windows rendszertálca naptára: az NVDA a hét napjait már teljes szóval jelenti be. (#12757)
* Microsoft Word: Kínai beviteli mód  használatakor a Braille kijelző görgetése során a kijelző nem ugrik vissza folyamatosan a rendszerkurzor korábbi pozíciójához. (#12855)
* Microsoft Word UI automation használatával: Ismét lehetséges a mondatonkénti navigáció. Navigációs parancs: Alt+Lenyíl és Alt+Felnyíl. (#9254)
* Microsoft Word UI Automation használatával: Az NVDA már bejelenti a bekezdések behúzását. (#12899)
* Microsoft Word UI Automation használatával: Az NVDA már ad visszajelzést a szerkesztői változások bejelentését vezérlő szkript és néhány más honosított szkript használatáról. (#12904)
* Már nem történik kétszeres bejelentés sem szóban, sem Brailleban, amennyiben a leírás paraméter értéke megegyezik a tartalom vagy a név paraméter értékével. (#12888)
* Microsoft Word UI Automation használatával: az NVDA sokkal pontosabban használja a gépelési hibát jelző hangot írás közben. (#12161)
* Windows 11: Miközben az Alt+Tab paranccsal váltogatunk a futó programok között az NVDA már nem jelenti be a "terület" szót. (#12648)
* Microsoft Word UI Automation használata nélkül: Az NVDA már képes kezelni az új, Modern megjegyzés követő terlületet. (#12982)

## 2021.2

Ez a kiadás az első, mely tartalmaz kezdetleges támogatást a Windows 11-hez.
Noha a Windows 11 hivatalosan még nem jelent meg, ezt a kiadást a Windows 11 bemutatóverzióin tesztelték. 
Ehhez kapcsolódóan fontos javítást végeztek a Képernyőfüggönyön.
A Rendszerkonfiguráció-helyreállító eszköz most már több problémát képes megoldani.
 Frissítették az eSpeak beszédszintetizátort és a LibLouis Braille fordítót.
Továbbá különböző hibajavítások és fejlesztések a Braille, Windows terminal programok, Számológép, emoji panel és Vágólap előzmények terén.

### Fontos megjegyzések

A Windows Nagyító API változásai miatt a képernyőfüggönyt frissíteni kellett, hogy megfelelően működhessen a windows legújabb verzióiban.
Az NVDA 2021.2 verziótól a képernyőfüggöny már működik a  Windows 10 21H2 (10.0.19044) és újabb verzióiban.
Ideértve a Windows 10 Insider verzióit és a Windows 11-et.
Biztonsági okokból a Windows legújabb verziójára való frissítés után ellenőrizze, hogy a Képernyőfüggöny tényleg elsötétíti-e az egész képernyőt!

### Újdonságok

* Kezdeti támogatás az ARIA mellékszövegekhez:
  * Hozzáadtak egy parancsot, amely képes bejelenteni az aria-details tulajdonsággal ellátott objektumokhoz tartozó további részleteket. (#12364)
  * A haladó beállítások között bekapcsolható a további részletek böngészőmódú megjelenítése. (#12439) 
  * Windows 10 1909 és újabb verziók (ideértve Windows 11): az NVDA már bejelenti a javaslatok számát, amikor a fájlkezelőben keresünk. (#10341, #12628)
* Microsoft Word: az NVDA már bejelenti az igazítás és a függő igazítás parancsait végrehajtásuk közben. (#6269)

### Változások

* Frissült az Espeak-ng, új verzió: 1.51-dev commit `ab11439b18238b7a08b965d1d5a6ef31cbb05cbb`. (#12449, #12202, #12280, #12568)
* Ha a cikkek bejelentése opció be van kapcsolva az NVDA >> Beállítások >> Dokumentumformázás ablakán, akkor a cikk megjelölés most már a tartalom után hangzik el. (#11103)
* Frissült a liblouis braille fordító, új verzió [3.18.0](https://github.com/liblouis/liblouis/releases/tag/v3.18.0). (#12526)
  * Új braille táblák: Bolgár rövidítési fokozat 1, Burmai rövidítési fokozat 1 és 2, Kazah rövidítési fokozat 1, Khmer rövidítési fokozat 1, Észak-Kurd rövidítési fokozat 0, Északi-szoto rövidítési fokozat 1 és 2, Déli-szoto rövidítési fokozat 1 és 2, Csvana rövidítési fokozat 1 és 2, Tatár rövidítési fokozat 1, Vietnami rövidítési fokozat 0 és 2, Dél-vietnami rövidítési fokozat 1, Xhosza  1 és 2, Jakut rövidítési fokozat 1, Zulu rövidítési fokozat 1 és 2
  * A Windows 10 OCR-t átnevezték, mostantól Windows OCR. (#12690)

### Hibajavítások

* Windows 10 számológép: az NVDA már képes megjeleníteni a számológép kifejezéseit Braille kijelzőkön. (#12268)
* terminal programok Windows 10 1607 és újabb verziókon ha karaktereket illesztünk be vagy törlünk egy sor belsejéből, a kurzortól jobbra található karaktert már nem jelenti be kéretlenül az NVDA.  (#3200)
  * a Diff Match Patch algoritmus mostantól az alapértelmezett. (#12485)
* A braille bevitel  most már megfelelően működik az alábbi rövidírásos táblákkal: 	Arab rövidítési fokozat 2, Spanyol rövidítési fokozat 2, Urdu rövidítési fokozat 2, Kínai (Kína, Mandarin) rövidítési fokozat 2. (#12541)
* A Rendszerkonfiguráció-helyreállító eszköz most már több problémát képes megoldani, különösen 64 bites Windowson. (#12560)
* Nippon Telesoft Seika Notetaker braille kijelző: javult a gombok kezelése. (#12598)
* Javult a Windows emoji panel és a Vágólap előzmények kezelése. (#11485)
* Frissítették a Bengáli betűzéshez használt karakterleírásokat. (#12502)
* Az NVDA biztonságosan bezárul mikor új NVDA folyamatot indítunk. (#12605)
* A Handy Tech braille kijelző driver újboli kiválasztása már nem okoz hibás működést. (#12618)
* A Windows 10.0.22000 és későbbi verzióit az NVDA már Windows 11-ként képes azonosítani. (#12626)
* A képernyőfüggöny opciót javították és tesztelték, már működik Windows 11 alatt is (Windows 10.0.22000). (#12684)
* Ha az NVDA Beviteli parancsok ablakán nincs a szűrésnek megfelelő megjeleníthető bejegyzés, az ablak most már megfelelően működik tovább. (#12673)
* Javították azt a hibát, amikor az NVDA elmulasztotta bejelenteni az almenük első elemét. (#12624)

## 2021.1

Ebben a kiadásban: Kezdetleges UI Automation támogatás az Excelben és  Chromium alapú böngészőkben.
Javítások különböző nyelvekhez, ill. a hivatkozások eléréséhez braille kijelzőről.
Frissült a CLDR és a matematikai jelek adatbázisa, ill. az eSpeak-NG és a LibLouis braille fordító.
Sok hibajavítás és fejlesztés az OFfice programcsomaghoz a Visual Studiohoz, ill. különböző nyelvekhez.
Figyelem: Ehhez a kiadáshoz ismét tesztelni és frissíteni kell a bővítményeket. Ez okozhat némi fennakadást bizonyos bővítmények használatában.
Ettől a kiadástól kezdve az NVDA már nem kezeli az Adobe Flash tartalmakat.

### Újdonságok

* Chromium alapú böngészők (pl. Edge): UI Automation Kezdetleges támogatása. (#12025)
* Microsoft Excel: UI Automation kezdetleges támogatása. Csak Microsoft Excel build 16.0.13522.10000 és újabb verziók esetén ajánlott. (#12210)
* Könnyebb navigáció az NVDA Python konzol kimenetén. (#9784)
  * alt+Felnyíl/Lenyíl: Ugrás az előző/következő kimeneti eredményre.
  * Shift+Alt+Felnyíl/Lenyíl: Kijelölés a kimeneti eredmény elejéig/végéig.  
  * control+l Törli a kimenetet.
* Microsoft Outlook: Az NVDA már bejelenti a találkozókhoz rendelt kategóriákat. (#11598)

### Változások

* Braille: böngészőmódban a vezérlők már aktiválhatók úgy is, ha a braille kurzort a vezérlők típusához navigáljuk (pl. gb, hv). Ilyen módon könnyebben aktiválhatók a hivatkozások ill. az olyan jelölőnégyzetek, amiknek nincs címkéjük. (#7447)
* Bekapcsolt képernyőfüggöny esetén az NVDA megakadályozza a Windows 10 OCR használatát. (#11911)
* Frissült a CLDR (Unicode Common Locale Data Repository), új verzió: 38.1. (#11943)
* Új matematikai jelekkel bővült az NVDA által felismert szimbólumok köre. (#11467)
* A felhasználói útmutató, az újdonságok és az NVDA parancsok listájának megjelenése kicsit módosul. (#12027)
* Az NVDA már bejelenti, ha olyan alkalmazásnál akarjuk aktiválni a Képernyő-elrendezést, ahol ez nem támogatott. A Microsoft Word pl. nem támogatja. (#7297)
* A Haladó beállítások között a "Beszéd megszakítása az időközben lejárt fókuszeseményeknél" opció mostantól alapértelmezés szerint be van kapcsolva. (#10885)
  * Ez a viselkedés bármikor kikapcsolható, ezesetben az opció értékét "nem"-re kell állítani.
  * Webes alkalmazások (pl. Gmail): az NVDA már nem mond be időközben megváltozott információkat amikor gyorsan változtatjuk a fókuszt.
* Frissült az Espeak-ng, új verzió: 1.51-dev commit cad1c8e87fcccf677a445202e340f61980450a84. (#12202, #12280)
* Frissült a liblouis braille fordító, új verzió: [3.17.0](https://github.com/liblouis/liblouis/releases/tag/v3.17.0). (#12137)
  * Új braille táblák: Fehérorosz irodalmi braille, Fehérorosz számítógépes braille, Urdu rövidítési fokozat 1 és 2.
* Az NVDA-ból eltávolították  az Adobe Flash tartalmak támogatását, miután már maga az Adobe sem támogatja annak használatát. (#11131)
* Az NVDA most már akkor is bezáródik, ha nyitva vannak bizonyos párbeszédablakai (pl. a Beállítások vagy a Kivételszótár). A kilépés folyamatába bekerült az esetlegesen nyitva hagyott ablakok bezárása. (#1740)
* A Beszédnézőt már be lehet zárni az Alt+F4 paranccsal, és kapott egy hagyományos Bezárás gombot is. (#12330)
* A Braille-néző kapott egy hagyományos Bezárás gombot. (#12328)
* Elemlista: Bizonyos nyelveknél eltávolították az Aktiválás gombhoz rendelt hívóbetűt, mert ütközött valamely elemkategória hívóbetűjével. Amikor az aktiválás gomb elérhető, továbbra is az a párbeszédablak alapértelmezetten aktív gombja, ezen kívül az egyes elemek közvetlenül a listából is aktiválhatók az enter lenyomásával. (#6167)

### Hibajavítások

* Outlook 2010: Az NVDA ismét képes olvasni az üzenetek listáját. (#12241)
* terminál programok Windows 10 1607 és újabb verziók esetén: Ha egy sorba illesztünk be, vagy onnan törlünk  egy karaktert, az NVDA már nem mondja be kéretlenül a kurzortól jobbra lévő karaktert. (#3200)
  * Ez a kísérleti opció bekapcsolható az NVDA Haladó beállításai között, a Frissülő tartalom követésénél a Diff Match Patch algoritmus kiválasztásával.
* MCS Electronics IDE: Javították a szerkesztőmezők kezelhetőségét. (#11966)
* Outlook: Kijavították azt a hibát, amikor üzenet írása közben Shift+Tab paranccsal visszafelé navigáltunk az üzenet tárgyához, az NVDA kéretlenül egy behúzási távolságértéket jelentett be. (#10254)
* Python konzol: már támogatott a nem üres beviteli soroknál a tab billentyű használata behúzások/térközök beillesztésére akár a sor elején, akár a közepén. (#11532)
* A formátuminformációknál és más böngészőmódú üzeneteknél az NVDA már nem mond be üres sorokat, amennyiben a Képernyő-elrendezés használata opció ki van kapcsolva. (#12004)
* Microsoft Word: az NVDA engedélyezett UIA támogatás esetén már képes olvasni a megjegyzéseket. (#9285)
* Visual Studio. Javult a kezelhetőség. (#12171)
* Jobbról balra író nyelvek esetén kijavítottak pár grafikai hibát, pl hiányzó elemeket. (#8859)
* Az elrendezés iránya most már az NVDA-ban beállított nyelven alapul és nem a Windows honosításán. (#638)
  * Ismert probléma a jobbról balra író nyelveknél: a vezérlők és címkék az elemcsoportok jobb széléhez igazodnak. (#12181)
* A python honosítása most már követi az NVDA beállításokban megadott nyelvet. (#12214)
* A TextInfo.getTextInChunks parancs futtatása már nem okoz fagyást az olyan rich text szerkesztőkben mint az NVDA naplónéző. (#11613)
* Az NVDA ismét használható olyan nyelveken,melyeknek a nevében _ (aláhúzás) jel szerepel, pl. de_CH. Windows 10 1803 és 1809 verziók esetén. (#12250)
* WordPad: A felső és alsó index formátum bemondása ismét a beállításnak megfelelően történik. (#12262)
* Egy weboldal böngészése közben az NVDA már nem mulasztja el bejelenteni az újonnan fókuszba került elemet, amennyiben az a korábban fókuszban lévő elem eltűnése után, annak helyén jelent meg. (#12147)
* Excel: Az NVDA már bejelenti az áthúzott ill. a felső- és alsó index formátumot a celláknál, amennyiben a kapcsolódó opciók be vannak kapcsolva az NVDA beállítások Dokumentumformázás kategóriájában. (#12264)
* NVDA hordozható verzió: Kijavították azt a hibát,ami a telepítésnél a konfiguráció másolása közben lépett fel olyan esetben, amikor az alapértelmezett konfigurációs mappa üres volt. (#12071, #12205)
* Javult bizonyos ékezetes és mellékjeles nagybetűk bejelentése olyankor, amikor be van kapcsolva a Nagybetűk szóbeli jelzése. (#11948)
* Kijavították a hangmagasság váltásával kapcsolatos problémát a SAPI4 beszédszintetizátorban. (#12311)
* Az NVDA telepítője már kezeli a --minimal parancssori paramétert és nem játssza le az indító hangot. A telepített és hordozható változat egyaránt így viselkedik. (#12289)
* MS Word és Outlook: A táblázatok közt navigáló egykarakteres gyorsnavigációs parancs (alapértelmezés szerint T) most már tartalmazza a rétegződő táblázatokat is,amennyiben a megfelelő opció be van kapcsolva. NVDA Beállítások >> Böngészőmód >> Rétegződő táblázatok jelzése. (#11899)

## 2020.4

Ebben a kiadásban: Az NVDA elemlista (NVDA+F7) már fókuszmódban is előhívható.
Az NVDA párbeszédablakain a súgó (F1) mostantól környezetérzékeny.
Fejlesztések az írásjelkiejtési szabályok megadásánál, a kivételszótáraknál, Braille üzenetek megjelenítésénél, és az átfutó olvasáshoz.
Hibajavítások és előrelépés Windows 10 Posta, Outlook, Teams, Visual Studio, Azure Data Studio és a Foobar2000 alkalmazások kezelésében.
Javult a google dokumentumok elérhetősége, ill. tovább fejlődött az Aria támogatás is.
És még sok más fontos hibajavítás és fejlesztés.

### Újdonságok

* Környezetérzékeny súgó: Az NVDA párbeszédablakain az F1 lenyomására a felhasználói útmutató a kapcsolódó szakasznál nyílik meg. (#7757)
* Microsoft SQL Server Management Studio plus Visual Studio 2017 és újabb kiadások: Az NVDA már kezeli  az automatikus kiegészítés javaslatait (IntelliSense). (#7504)
* Írásjelkiejtés: Már támogatott összetett írásjelek megadása, ill. a behelyettesített kifejezésben is használhatók már reguláris kifejezések. (#11107)
* Az NVDA már figyelmezteti a felhasználókat, amikor a kivételszótárban érvénytelen reguláris kifejezést adnak meg. (#11407)
  * Kifejezetten a csoportosítási hibákat jelzi a rendszer.
* Windows 10: Támogatás a kínai (hagyományos) nyelv gyors és Pinyin beviteli módjaihoz. (#11562)
* A webes dokumentumokon található lapfüleket az NVDA most már az űrlapmezők közt kezeli,  így most már lehet navigálni köztük a kapcsolódó egykarakteres navigációs paranccsal (F). (#10432)
* Billentyűparancs rendelhető a megjelölten kiemelt szövegek bemondásához. Alapértelmezés szerint nincs hozzárendelve parancs, de a Beviteli parancsok között bármikor beállítható. (#11807)
* Hozzáadták --a copy-portable-config parancssori paramétert, ami lehetővé teszi, hogy az NVDA háttérben történő telepítése közben a szükséges konfigurációs adatok automatikusan átmásolódjanak a felhasználói fiókba. (#9676)
* Már támogatott a Braille görgetés. A Braille kijelzőn az az üzenet jelenik meg,amire a Braille-nézőben ráviszik az egérkurzort. (#11804)
* Humanware Brailliant BI 40X és 20X Braille kijelzőket az NVDA már automatikusan érzékeli USB és Bluetooth kapcsolaton kereztül. (#11819)

### Változások

* Frissült a liblouis braille fordító, új verzió: 3.16.1:
 * Kijavítottak több hibát is.
 * Új braille tábla: Baskír rövidítési fokozat 1
 * Új braille tábla: Kopt 8 pontos számítógépes braille
 * Új braille táblák: Orosz irodalmi braille és Orosz irodalmi braille (részletes).
 * Eltávolították az orosz rövidítési fokozat 1 Braille táblát
* Böngészőmódban folyamatos felolvasásnál ha az átfutás engedélyezése opció be van kapcsolva, akkor a következő és az előző keresési találatra ugrás nem állítja le a folyamatos felolvasást. A felolvasás a keresési találatok után következő karakterrel folytatódik, megszakítás nélkül. (#11563)
* HIMS braille kijelzők: a korábban az F3 paranccsal elérhető opciót most már Szóköz + pontok 148 paranccsal lehet elérni. (#11710)
* A Braille beállítások között megváltozott az üzenetek megjelenítésének beállítása: Most már az "Üzenetek megjelenítése" címkével ellátott kombinált listamezőből lehet kiválasztani az üzenetek megjelenítésének időkorlátját. Korlátozott ideig és Időkorlát nélkül opciók közül lehet választani. (#11602)
* A böngészőmódot támogató webböngészőkben és alkalmazásokban az NVDA elemlista (billentyűparancs: NVDA+F7) már fókuszmódban is előhívható. (#10453)
* Ha a Frissülő tartalom felolvasása opció ki van kapcsolva az NVDA beállítások Objektumok megjelenítése kategóriában, akkor most már az ARIA élő területek frissülő tartalmát sem jelenti be az NVDA. (#9077)
* Az NVDA "A vágólapra másolva" üzenetet a másolt szöveg előtt jelenti be. (#6757)
* Javult a Windows Lemezkezelő grafikus táblázatnézetének kezelhetősége. (#10048)
* Az elérhetetlenné vált vezérlők címkéit nem jelenti be az NVDA. Vizuális megjelenítésben ezek a beszürkülő gombok. (#11809)
* Frissítették a CLDR emodzsikat, új verzió: 38. (#11817)
* A beépített fókuszkiemelő opciót átneveztük Vizuális kiemelésre. (#11700)

### Hibajavítások

* Fast Log Entry: Az NVDA ismét helyesen kezeli a szerkesztőmezőket. (#8996)
* Foobar 2000: Ha a teljes időt nem lehet lekérdezni (pl. élő streamek hallgatása közben) a program az eltelt időt jelenti be. (#11337)
* Az NVDA most már az aria-roledescription attribútumnak megfelelően kezeli a webes dokumentumok szerkeszthető tartalmainak elemeit. (#11607)
* Google Chrome: Google dokumentumokban és más szerkeszthető webes tartalmaknál az NVDA már nem jelenti be a "lista" elnevezést egy lista minden egyes sorában. (#7562)
* Ha karakterenkénti vagy szavankénti navigációval lépkedünk egy szerkeszthető webes tartalom listaelemei között, akkor az NVDA már bejelenti az új listaelemeket. (#11569)
* Google dokumentumok és más szerkeszthető webes tartalmak: Az NVDA már a megfelelő sort olvassa amikor a kurzor egy listaelem végén található link végén áll. (#11606)
* Windows 7: A start menü megnyitásakor és bezárásakor az NVDA már helyesen kezeli a fókuszt. (#10567)
* Ha a "Beszéd megszakítása az időközben lejárt fókuszeseményeknél" haladó beállítási opció be van kapcsolva az NVDA ismét felolvassa a Firefoxban a lapfülek címét a lapfülek váltásakor. (#11397)
* SAPI5 Ivona hangok használatakor az NVDA bejelenti a listaelemet miután egy karaktert viszünk be egy listába. (#11651)
* Posta alkalmazás Windows 10 16005.13110 és újabb kiadásokban: Levelek olvasásánál ismét működik a böngészőmód. (#11439)
* A harposoftware.com weboldalon elérhető SAPI5-ös Ivona hangok használatakor az NVDA már elmenti a konfigurációt, képes váltani a különböző szintetizátorok közt ill. az újraindítása után nem némul el. (#11650)
* HIMS braille kijelzők: Most már be lehet vinni számítógépes Braille használatakor a 6-os számot. (#11710)
* Azure Data Studio: Jelentős javulás a kezelésben. (#11533, #11715)
* ha a "Beszéd megszakítása az időközben lejárt fókuszeseményeknél" haladó beállítási opció be van kapcsolva az NVDA ismét felolvassa a keresési párbeszédablak címsorát. (#11632)
* Az NVDA már nem fagy le ha a számítógép hibernált állapotból visszatérése után a fókusz egy Microsoft Edge dokumentumra kerül. (#11576)
* Microsoft Edge: helyi menük bezárása után már nincs szükség a tab gomb lenyomására vagy az aktív elem más módon történő megváltoztatására ahhoz, hogy a böngészőmód az elvárásoknak megfelelően működjön. (#11202)
* Tortoise SVN és más 64 bites alkalmazások: Az NVDA már felolvassa a listaelemeket. (#8175)
* Böngészőmódban az ARIA treegrids objektumokat már normál táblázatként kezeli az NVDA Firefox és Chrome böngészőben egyaránt. (#9715)
* Az előző előfordulás keresése szkript (NVDA+Shift+F3) már az elvártaknak megfelelően működik. (#11770)
* Gyorsan ismételt lenyomást igénylő parancsok már nem aktiválódnak olyan esetekben,amikor a kétszeri lenyomás között egy szkripthez nem rendelt billentyűleütés történik. An NVDA script is no longer treated as being repeated if an unrelated key press happens in between the two executions of the script. (#11388) 
* Internet Explorer: A szövegek kiemelt állapotát már nem jelzi az NVDA, amennyiben kikapcsoljuk a kiemelt állapot jelzését a Dokumnetumformázás párbeszédablakán. (#11808)
* Excel: Már nem fordulhat elő pár másodperces megakadás cellák közti navigáció során. (#11818)
* Microsoft Teams 1.3.00.28xxx verziószámok esetén az NVDA felolvassa az üzeneteket a chaten és a Teams csatornákon. (#11821)
* Google Chrome: Ha a helyesírás-ellenőrző egy szót egyszerre jelöl meg gépelési és nyelvtani hibaként is, akkor az NVDA már helyesen bejelenti mindkét állapotot. (#11787)
* Outlook (csak a Francia nyelvű honosítást érinti): A "Válasz mindenkinek" opció billentyűparancsa (control+shift+R) most már az elvárásoknak megfelelően működik. (#11196)
* Visual Studio: az IntelliSense eszköztippeket már csak egyszer jelenti be az NVDA. (#11611)
* Windows 10 Számológép: az NVDA már nem jelenti be a számolás folyamatát ha a beírt karakterek bemondása opció ki van kapcsolva. (#9428)
* Az NVDA már nem okoz hibát, ha az Angol (egyesült államokbeli) rövidítési fokozat 2 braille táblát kiterjesztjük számítógépes braille táblára, olyan esetben amikor a braille kurzor megjelenítése be van kapcsolva ill. a kurzor bizonyos tartalmakon áll, pl egy URL címen. (#11754)
* Excel: Ismét megfelelően működik a formátuminformációk lekérdezése szkript (NVDA+F) az aktív cellákban. (#11914)

## 2020.3

Ebben a kiadásban jelentősen javul az NVDA stabilitása és kezelhetősége. Ez különösen Microsoft Office alkalmazások esetén érhető tetten. Bekerült néhány új opció, mint az érintőmód ki- és bekapcsolása, ill. az ábrák bejelentésének ki- és bekapcsolása.
Az NVDA már kezeli a kiemelt szövegeket a webes dokumentumokban.

### Újdonságok

* Új opció az NVDA Beállítások dokumentumformázás kategóriájában: Ábrák bejelentésének be- és kikapcsolása. Az ábrákhoz tartozó leírást az NVDA az opció kikapcsolt állapotában is felolvassa. (#4837)
* Most már ki- és bekapcsolható az érintőmód az érintőkijelzőt használó rendszereken. A beállítások közt az Érintőmód kategória csak az érintőkijelzős rendszereken jelenik meg. Alapértelmezett billentyűparancs: NVDA+ctrl+alt+t. (#9682)
* Új német braille táblákat adtak hozzá. (#11268)
* Az NVDA már kezeli a csak olvasható szöveges UIA vezérlőket. (#10494)
* Az NVDA már kezeli a kiemelt megjelöléssel ellátott szöveget a webes dokumentumokban. Beszéd és braille visszajelzést is képes adni róla. (#11436)
 * Ez az opció kezelhető az NVDA beállítások dokumentumformázás kategóriájában neve Kiemelés. A korábban kiemelés néven futó opció is megmaradt de mostantól hangsúlyozás néven fut, így talán jobban elkülönülnek az egyes kiemelések.
* Újabb rendszerbillentyűk emulálására van lehetőség az NVDA beviteli parancsai között. (#6060)
  * A beállításhoz keresse a Rendszerbillentyűk emulálása kategóriát.

### Változások

* A formátuminformációk lekérésére szolgáló szkriptet (NVDA+F) megváltoztatták. Mostantól a rendszerkurzornál található szövegről ad információt. A korábbi viselkedés, miszerint az áttekintőkurzornál található szövegről adott információt, most is elérhető a billentyűparancsa NVDA+Shift+F. (#9505)
* Az NVDA már nem helyezi a fókuszt automatikusan az aktiválható elemekre. A korábbi viselkedéshez be kell kapcsolni az "Automatikus rendszerfókusz az aktiválható elemekre opciót a böngészőmód beállításainál. De nem ajánlott bekapcsolni, mert az opciót azért változtatták meg, hogy javuljon az NVDA kezelhetősége és stabilitása. (#11190)
* Frissült a CLDR, új verzió: 37. (#11303)
* Frissült az eSpeak-NG, az új verzió: 1.51-dev, commit 1fb68ffffea4
* Már használhatók a táblázatnavigációs parancsok olyan listamezőknél, melyek több oszlopban tartalmaznak bejelölhető elemeket. (#8857)
* A bővítménykezelőben bővítmények eltávolításakor a párbeszédablakon mostantól a Nem válasz az alapértelmezés szerint aktív lehetőség. Ezzel elkerülhető a kéretlen eltávolítás. (#10015)
* Microsoft Excel: az elemlistában a képletek már az Excelben beállított nyelvnek megfelelően jelennek meg. Korábban nem vette figyelemmbe a honosítást. (#9144)
* Az NVDA már képes elkülöníteni az Excel új verzióiban a jegyzeteket és a megjegyzéseket. (#11311)
* Ha böngészőmódban használjuk az áttekintőkurzor áthelyezése az aktív elemhez parancsot, akkor az áttekintőkurzor mostantól már a böngészőmód virtuális kurzorához fog lépni. (#9622)
* A formátuminformációk böngészőmódú megjelenítésére szolgáló ablak a korábbinál nagyobb és a képernyő közepére van igazítva. (#9910)

### Hibajavítások

* Szavankénti navigációnál az NVDA most már mindig bemondja, a bőbeszédűségi beállításoktól függetlenül, az olyan szimbólumokat, melyeket szóköz követ. (#5133)
* QT 5.11 és újabb verzióit használó alkalmazásoknál az elemleírásokat ismét bejelenti az NVDA. (#8604)
* A szavak ctrl+delete paranccsal történő törlésekor az NVDA már az elvárásnak megfelelő visszajelzést ad. (#3298, #11029)
  * Most már a törölt szótól jobbra található szót jelenti be az NVDA.
* Az NVDA általános beállításai között a nyelvek listáján most már ABC-sorrendben jelennek meg a választható nyelvek. A sorrendet korábban a nyelvek ISO-kódjai alapján állította fel  a rendszer. (#10348)
* A beviteli parancsok párbeszédablakán most már sokkal gördülékenyebben működik a szűrés.  (#10307)
* Most már lehet unicode karaktert bevinni a braille kijelzőről. Korábban ezt csak U+FFFF formátumban jelenítette meg. (#10796)
* Windows 10 2020 májusi frissítés: Az NVDA ismét tudja kezelni a Hogyan szeretné megnyitni ezt a fájlt? című ablakot, ami olyankor jelenik meg, ha olyan fájltípust akarunk megnyitni,amihez nincs hozzárendelve program. (#11335)
* Új, kísérleti opció a Haladó beállítások között: Csak az UI Automation események és tulajdonságváltozások egy részének kezelése. Az opció bekapcsolásával jelentősen javítható a Microsoft Visual Studio és más,  UIAutomationt használó alkalmazások kezelhetősége. (#11077, #11209)
* Bejelölhető listaelemeknél a kijelölve állapotot már nem jelenti be az NVDA ismétlődően. helyette inkább a nincs kijelölve állapotot jelenti be,ahol az a megfelelő. (#8554)
* Windows 10 2020 májusi frissítés: az NVDA már a Microsoft Sound Mappert is megjeleníti a beszédszintetizátorhoz választható kimeneti hangeszközök listáján. (#11349)
* Internet Explorer: Az NVDA már helyesen jelenti be a számokat olyan rendezett listák esetében, melyek nem 1-gyel kezdődnek. (#8438)
* Google Chrome: az NVDA már képes minden nem bejelölt állapotú bejelölhető elem állapotát helyesen bejelenteni. Korábban csak a jelölőnégyzeteknél működött ez. (#11377)
* Akik az NVDA-t aragóniai nyelven használják mostantól ismét navigálhatnak bizonyos vezérlőkön. (#11384)
* Microsoft Word: Bekapcsolt braille esetén az NVDA már nem fagy le, amikor gyorsan használjuk a le- és felnyilat ill. gyorsan gépelünk be karaktereket. (#11431, #11425, #11414)
* Az NVDA már nem tesz kéretlen szóközt a vágólapra másolt navigátor objektum után. (#11438)
* Az NVDA már nem aktiválja a folyamatos felolvasás profilt, amikor nincs semmilyen felolvasható tartalom. (#10899, #9947)
* Internet Information Services (IIS) Manager: Az NVDA már képes kezelni a jellemzők listáját. (#11468)
* Az NVDA mostantól nyitva tartja a kimeneti hangeszközt. Ezzel javult az együttműködés bizonyos hangkártyákkal. (#5172, #10721)
* Microsoft Word: Az NVDA már nem fagy le és nem is záródik be a ctrl+shift+lenyíl billentyűparancs használatakor. (#9463)
* A Google Drive webes felületén az NVDA mostantól mindig bejelenti a mappák nyitott és zárt állapotát a navigációs fanézetben. (#11520)
* Az NVDA már automatikusan felismeri az NLS eReader Humanware braille kijelzőt Bluetooth-on keresztül.  A kijelző Bluethooth neve "NLS eReader Humanware". (#11561)

## 2020.2

Ebben a kiadásban: Egy új braille-kijelző támogatása a Nattiqtől; jobb támogatás az Eset Antivirushoz és a windows terminalhoz; sebességi optimalizálás az 1Password jelszókezelő programhoz és a Windows OneCore beszédszintetizátorhoz, és még sok javítás, és optimalizálás.

### Újdonságok

* Bővült a támogatott braille kijelzők köre:
  * Nattiq nBraille (#10778)
* Egy beviteli paranccsal megnyitható az NVDA felhasználói beállítások mappája. Alapértelmezés szerint nincs billentyűparancs hozzáadva. (#2214)
* Javított támogatás az ESET antivirus grafikus felületéhez. (#10894)
* Windows Terminal támogatása. (#10305)
* Egy beviteli paranccsal már lekérdezhető az aktív profil neve. Alapértelmezés szerint nincs hozzárendelve billlentyűparancs. (#9325)
* Felső és alsó index jelzése, beviteli parancs is beállítható az új opcióhoz. (#10985)
* Webes alkalmazások (pl. Gmail) használatakor az NVDA már nem mond elavult információkat, amikor a fókusz gyorsan változik. (#10885)
  * Ez a viselkedés egy új, kísérleti opció bekapcsolásával lehetséges. Az NVDA haladó beállításai között található, a neve: "Beszéd megszakítása az időközben lejárt fókuszeseményeknél".
* Sokkal több írásjelet adtak az alapértelmezett írásjelkiejtés szótárhoz. Ez azt jelenti, hogy a korábbinál több írásjelet tud kezelni az NVDA. (#11105)

### Változások

* Frissült a liblouis braille fordító [3.14.0](https://github.com/liblouis/liblouis/releases/tag/v3.14.0) (erről 3.12.0). (#10832, #11221)
* A felső és alsó indexet már a betűtípus paraméterektől külön kezeli a program. (#10919)
* VS Code: az NVDA már nem tiltja le alapértelmezés szerint a böngészőmódot kódolás nézetben. (#10888)
* Eltávolították a "Teteje" és "Alja" állapotjelzést olyankor,amikor az áttekintő kurzor eléri a navigátor objektum legfelső vagy a legalsó sorát. (#9551)
* Eltávolították a "Bal" és "Jobb" állapotjelzést olyankor,amikor az áttekintő kurzor eléri a navigátor objektum aktuális sorának elejét vagy végét. (#9551)

### Hibajavítások

* Az NVDA megfelelően indul akkor is, ha a naplófájlt nem sikerült létrehozni. (#6330)
* Microsoft Word 365: az NVDA már nem jelenti be a "szó visszatörlése" üzenetet, amikor a dokumentum szerkesztése közben a ctrl+Backspace parancsot használjuk. (#10851)
* Winamp: az NVDA ismét bejelenti az ismétlés és a véletlen lejátszás be- és kikapcsolását. (#10945)
* 1Password: az NVDA már nem reagál feltűnően lassan az elemek listáján történő navigáció során. (#10508)
* A Windows OneCore beszédszintetizátor már nem tart hosszú szüneteket érzelemkifejezések között. (#10721)
* 1Password: Az NVDA már nem fagy le, amikor megnyitjuk a helyi menüt a rendszer értesítési területen. (#11017)
* Office 2013 és régebbi verziók:
  * A szalagmenüt bejelenti az NVDA amikor a fókusz először kerül rá. (#4207)
  * A helyi menük elemeit ismét helyesen jelenti be az NVDA. (#9252)
  * A szalagmenü csoportjait következetesen jelenti be az NVDA, amikor Ctrl+nyílbillentyűk paranccsal navigálunk rajtuk. (#7067)
* Firefox és Chrome: böngészőmódban a szöveg nem jelenik meg kéretlenül külön sorban, ha a weboldal CSS megjelenítést használ inline-flex paraméterrel. (#11075)
* Böngészőmódban az Automatikus rendszerfókusz az aktiválható elemekre opció kikapcsolt állapotában... 
  * már aktiválhatók olyan elemek, amik normál esetben nem kerülhetnének fókuszba.
  * már aktiválhatók azok az elemek, amelyekre a tab billentyűvel navigáltunk. (#8528)
  * bizonyos elemek aktiválása már az elvárt helyen történik, nem mozdul el a fókusz egy egészen másik helyre. (#9886)
  * ha az  NVDA+szóköz paranccsal váltunk fókuszmódra, akkor a rendszerkurzornál lévő elem kerül fókuszba. (#11206)
* Már nem hallható hangjelzés, ha DevExpress szövegvezérlők kerülnek fókuszba. (#10918)
* Az elemleírások már nem hallhatók a rendszertálcán mozgáskor, amennyiben megegyeznek az ikonjuk nevével. Ezzel kerülhető el a többszörös bemondás. (#6656)
* Újra lehetséges NVDA-frissítéseket keresni olyany rendszereken, ahol ez korábban problémát okozott, pl. friss Windows telepítéseknél. (#11253)
* Java alkalmazásokban már nem mozdul el a fókusz , ha a kijelölés megváltozik fókuszban nem lévő fanézetben, táblázatban vagy listában. (#5989)

## 2020.1

Ebben a kiadásban: bővült a támogatott braille kijelzők köre a HumanWare és az APH néhány termékével; az NVDA újra kezeli a matematikai kifejezéseket a Microsoft Wordben  MathPlayer vagy MathType használatakor; és még néhány további fontos hibajavítás.

### Újdonságok

* Google Chrome: A listamezők kijelölt elemét ismét bejelenti a program. Most ismét úgy működik, mint az NVDA 2019.1 kiadásában. (#10713)
* Az érintőkijelzőkön már előhívható a helyi menü az egyujjas érintés és nyomvatartás mozdulattal. (#3886)
* Új, támogatott braille kijelzők: APH Chameleon 20, APH Mantis Q40, HumanWare BrailleOne, BrailleNote Touch v2, és NLS eReader. (#10830)

### Változások

* Folyamatos felolvasás közben az NVDA megakadályozza a Windows zárolását vagy alvó módba kapcsolását. (#10643)
* Mozilla firefox: támogatás out-of-process iframe elemekhez. (#10707)
-  A liblouis braille translator frissült a 3.12. verzióra. (#10161)

### Hibajavítások

* Az NVDA már bejelenti az Unicode minusz karaktert. (U+2212). (#10633)
* Bővítmények: Ha a bővítménykezelőből telepítünk egy bővítményt, a böngészőablakban az NVDA már nem jelenti be kétszer a fájlok és mappák nevét. (#10620, #2395)
* Firefox, ha a Mastodon az  advanced web interface opció engedélyezésével töltődik be, akkor böngészőmódban minden idővonal megfelelően jelenik meg. (#10776)
* Böngészőmódban az NVDA már bejelenti a nem bejelölt jelölőnégyzetek állapotát,ahol ezt korábban még nem tette. (#10781)
* Az ARIA kapcsoló vezérlők már nem adnak zavaró információkat az NVDA-nak, mint pl. "nincs lenyomva, bejelölt" és "lenyomva, bejelölt". (#9187)
* A SAPI4 hangok már nem némulnak el bizonyos szövegeknél. (#10792)
* Microsoft word: az NVDA ismét képes olvasni és kezelni a matematikai egyenleteket. (#10803)
* Böngészőmódban az NVDA ismét bejelenti a szöveg kijelölési állapotának megváltozását, amennyiben lenyomjuk valamelyik nyílbillentyűt. ilyenkor ismét bejelenti, hogy "nincs kielölve". (#10731).
* Az NVDA már nem zárul be, ha az eSpeak betöltése közben valami hiba lép fel. (#10607)
* Bizonyos nyelveknél, ahol a parancsikon létrehozásánál korábban hibát okozott az unicode, már nem áll le az NVDA telepítése hibaüzenettel. (#5166, #6326)
* Ha folyamatos felolvasás közben az átfutás engedélyezve van, a táblázatokból és listákból való kilépéskor az NVDA nem jelenti be a lista vége vagy a táblázat vége helyzetet. (#10706)

## 2019.3

Ebben a kiadásban jelentős változások a motorháztető alatt: az NVDA programkódja mostantól már nem a Python 2-es, hanem a 3-as verziójára épül, emellett jelentősen átírták a beszéd alrendszert is. 
A Python 3-ra való áttérést főleg biztonsági megfontolások indokolták, a beszéd alrendszer megváltoztatása pedig új, izgalmas fejlesztéseknek fog teret adni.
Az átállás fennakadásokat fog okozni a bővítmények használatában, de a bővítmények fejlesztői folyamatosan dolgoznak, hogy mihamarabb újra elérhető legyen minden népszerű bővítmény.
 Továbbá 64 bites Java VMs támogatás; képernyőfüggöny és kurzorkiemelés; újabb támogatott braille kijelzők és egy új Braille-néző és még sok-sok hibajavítás. 

### Újdonságok

* A parancssor, a PowerShell és a Windows Linuxhoz készült alrendszerének használhatósága és stabilitása is jelentősen javult   a Windows 10 2018 októberi  és újabb verziói alatt. (#9771)
 * A képernyőn meg nem jelenő (jellemzően jelszó beviteli mezők) karakterek bemondása már lehetséges az NVDA haladó beállításai közé bekerült új opcióval. (#9649)
* Java alkalmazások szövegmezőinél sokkal pontosabban működik már az egérmutató áthelyezése a navigátor kurzorhoz parancs. (#10157)
* Támogatás a következő Handy Tech Braille kijelzőkhöz (#8955):
 * Basic Braille Plus 40
 * Basic Braille Plus 32
 * Connect Braille
* Eltávolíthat minden egyénileg beállított beviteli parancsot a Beviteli parancsok párbeszédablakán található "Gyári beállítások visszaállítása" gomb segítségével. (#10293)
* Microsoft Word: A betűtípus bejelentésénél már jelzi a program azt is, ha a szöveg rejtett. (#8713)
* Új parancs,amivel az áttekintő kurzort a kijelölési kezdőponthoz mozgatja.NVDA+shift+F9. (#1969)
* Internet Explorer, Microsoft Edge, Firefox és Chrome: A jelzőpontokat már bejelenti az NVDA fókuszmódban és elemnavigáció során is. (#10101)
* Internet Explorer, Google Chrome és Mozilla Firefox: Új gyorsnavigációs parancsok: navigáció cikkek és elemcsoportok alapján. Alapértelmezés szerint nincs hozzárendelve parancs, de a beviteli parancsok párbeszédablakon bármikor, amikor böngészőmódú dokumentum van fókuszban, hozzárendelhet. (#9485, #9227)
 * Internet Explorer, Google Chrome és Mozilla Firefox: Cikk megjelöléssel ellátott elemeket már bejelent az NVDA elemmnavigáció során, ill. amennyiben a dokumentumformázás párbeszédablakon be van állítva, böngészőmódban is. (#10424)
* Mozilla Firefox: out-of-process iframe támogatás. (#9672)
* Új funkció Windows 8 és újabb rendszerek alatt. Képernyőfüggöny. Bekapcsolása esetén a monitor elsötétül. (#7857)
 * Egy szkripttel bekapcsolható csak a következő újraindításig, vagy kétszeri lenyomásra addig,amíg ki nem kapcsoljuk az opciót. Alapértelmezés szerint nincs hozzárendelve billentyűparancs, a Beviteli parancsok párbeszédablakon hozzárendelhet egyet.
 * Bekapcsolható és konfigurálható az NVDA beállítások közt újonnan felbukkant Vizuális kategóriában.
* Új opció: Képernyőkiemelő, ami vizuális visszajelzést ad a beállításokban megadott kurzorok képernyőn elfoglalt helyzetéről. (#971, #9064)
 * Az aktív elem, a navigátor kurzor, ill. a böngészőmód kurzorának kiemelésére van lehetőség az NVDA beállításai között a Vizuális kategóriában.
 * Figyelem: Ez az opció nem kompatibilis a Fókuszkiemelő bővítménnyel. A bővítmény használatához ki kell kapcsolni a beépített kiemelőt.
 * Új eszköz: Braillenéző. Segítségével az NVDA képes megjeleníteni a braille kimenetet látható formában a monitoron. Az NVDA menüjében az Eszközök között érhető el. (#7788)

### Változások

* A felhasználói útmutatóba bekerültek  információk az NVDA és a Windows parancssor együttműködéséről. (#9957)
* Az nvda.exe futtatásakor alapértelmezés szerint előbb kikapcsolja a futó példányt. Korábban ez csak a -r parancssori paraméterrel volt lehetséges. A paramétert most is elfogadja a program, de már figyelmen kívül hagyja. (#8320)
* Windows 8 és újabb verziók alatt az NVDA már bejelenti a Microsoft Storeből letöltött alkalmazások nevét és verziószámát. Az alkalmazások által rendelkezésre bocsátott információkat képes kiolvasni az NVDA (#4259, #10108)
* Amennyiben billentyűparanccsal kapcsolja ki és be a szerkesztői változások követése opciót, az NVDA már bejelenti az opció állapotát. (#942) 
* Az NVDA verziószáma lesz az első bejegyzés a naplóban. Akkor is, ha a beállításoknál le van tiltva a naplózás. (#9803)
* Az Általános beállítások közt nem lehet megváltoztatni a naplózás szintjét amennyiben az felül lett írva az NVDA indításakor egy parancssori paraméterrel. Olyankor mindenképpen a parancssori paraméterrel megadott beállítás lesz a mérvadó. (#10209)
* Microsoft Word: az NVDA már bejelenti a nem nyomtatható karaktereket, amennyiben az opciót bekapcsoljuk a Ctrl+Shift+8 billentyűparanccsal. (#10241)
* Frissült a Liblouis braille fordító a commit 58d67e63 verzióra. (#10094)
* Amennyiben a CLDR karakterek (pl. emodzsik) bemondása be van kapcsolva, akkor minden írásjelszinten bejelenti őket az NVDA. (#8826)
* A harmadik féltől származó python csomagok figyelmeztetéseiről és hibáiról szóló naplóbejegyzések már az NVDA központi naplófájljába kerülnek. (#10393)
* Frissült az Unicode Common Locale Data Repository (CLDR) emodzsi karakterkészlete a 36.0 verzióra. (#10426)
* ha böngészőmódban egy elemcsoport kerül fókuszba, az NVDA már bejelenti a hozzá tartozó leírást is. (#10095)
* A Java Access Bridge már az NVDA szerves része. Segítségével hozzáférhetők a java alapú alkalmazások többek közt a 64 bit Java VMs is. (#7724)
* Ha a felhasználó nem kapcsolta be a Java Access Bridge-t, az NVDA indulásakor automatikusan aktiválja azt. (#7952)
* Az  eSpeak-NG frissítve lett az alábbi verzióra: 1.51-dev, commit ca65812ac6019926f2fbd7f12c92d7edd3701e0c. (#10581)

### Hibajavítások

* Az Emodzsik és más 32 bites unicode karakterek már kevesebb helyet foglalnak a Braille kijelzőkön, amennyiben hexadecimális értékként vannak megjelenítve. (#6695)
* Windows 10: Az NVDA már bejelenti az univerzális alkalmazások vezérlőihez tartozó eszköztippeket, amennyiben az NVDA beállításai közt az Objektumok megjelenítése kategóriában be van kapcsolva az "Eszköztippek bemondása" opció. (#8118)
* Mintty: Windows 10 évfordulós frissítésétől kezdve az NVDA már bejelenti a beírt szöveget. (#1348)
* Windows 10 évfordulós frissítés és újabb kiadások: Parancssori alkalmazásokban a rendszerkurzorhoz közel érkező kimenetet már nem jelenti be az NVDA. (#513)
* Audacity: az NVDA már bejelenti a vezérlőket a kompresszor párbeszédablakán. (#10103)
* Scintilla alapú szerkesztők, mint  a Notepad++: Elemnavigáció során az NVDA már nem kezeli a szóközöket szavakként. (#8295)
* Az NVDA nem engedi a rendszert alvó módba kapcsolni, amikor egy braille kijelzőn navigálunk a kijelző billentyűparancsaival. (#9175)
* Windows 10: A braille visszajelzés ismét az elvártnak megfelelően működik a Microsoft Excel cellájának szerkesztése közben ill. más Ui Automation szöveges vezérlőknél. (#9749)
* Microsoft Edge: Az NVDA megint bejelenti a javaslatokat a címsorban. (#7554)
* Internet Explorer: az NVDA már nem némul el, ha egy HTML fül vezérlőelem fejlécére navigálunk. (#8898)
* Microsoft Edge: Az NVDA már nem adja ki a keresési javaslatok felbukkanásakor szokásos hangjelzését, amikor az ablakot teljes képernyőre nagyítjuk. (#9110, #10002)
* Mozilla Firefox és Google Chrome: Már támogatottak az ARIA 1.1 kombinált listamezők. (#9616)
* Az NVDA már nem jelenti be a listaelemek vizuálisan rejtett oszlopait SysListView32 vezérlők esetében. (#8268)
* Csökkentett módban az általános beállítások párbeszédablakán az NVDA már nem az Információ értéket jeleníti meg naplózási szintnek. (#10209)
* A Windows 10 évfordulós frissítésétől kezdve az NVDA már bejelenti a Start menü keresőmezőjében indított keresések részleteit. (#10232)
* Böngészőmódban, a kurzor mozgatásakor, ill. egykarakteres gyorsnavigáció használatakor ha megváltozik a dokumentum, az NVDA már nem jelent be nem megfelelő tartalmat. (#8831, #10343)
* Microsoft Word: javították bizonyos felsorolásjelek elnevezését. (#10399)
* Windows 10 2019 májusi frissítéstől kezdve az NVDA ismét bejelenti az első kijelölt elemet az emodzsi panelen és a vágólap történet panelen is. (#9204)
* Poedit: ismét olvashatók jobbról-balra írásmódú nyelvek bizonyos fordításai. (#9931)
* Windows 10 2018 áprilisi frissítés és újabb kiadások: Az NVDA már nem folyamatjelzőként kezeli a Windows gépház hangbeállítás párbeszédablakában található hangerőbeállító csúszkákat. (#10284)
* Érvénytelen reguláris kifejezés megadása az NVDA kivételszótáraiban már nem állítja le a beszédszintetizátort. (#10334)
* Microsoft Word bekapcsolt UI Automation opció esetén a felsorolás következő eleménél már nem jelenti be az NVDA megint a felsorolásjelet. (#9613)
* Liblouis: kijavítottak bizonyos ritka braille fordítási hibákat. (#9982)
* Az NVDA elindítása előtt elindított Java alkalmazások használatához már nem kell újraindítani az érintett alkalmazásokat. (#10296)
* Mozilla Firefox: amikor az aktuális elem jelenlegi megjelölést kap(aria-current), ezt a változást nem jelenti be a program egymás után többször. (#8960)
* Az NVDA bizonyos összetett unicode karaktereket már egyszerű karakterként kezel a szövegben való navigálás során. (#10550)
* Spring Tool Suite 4 már támogatott. (#10001)
* Az NVDA már nem mondja be duplán a megnevezést, ha az aria-labelledby opció egy belső elemhez kapcsolódik. (#10552)
* Windows 10 1607 és újabb kiadások: a braille billentyűzetről bevitt karaktereket már több esetben kimondja az NVDA. (#10569)
* A hangkimeneti eszköz megváltoztatásakor az NVDA hangjelzései is az új eszközön szólalnak meg. (#2167)

## 2019.2

Ebben a kiadásban: Freedom Scientific braille kijelzők automatikus felismerése; kísérleti opcióval kikapcsolható az a viselkedés, hogy a rendszerfókusz automatikusan kövesse a böngészőmód kurzorát, ez bizonyos esetekben hatékonyabbá teheti a böngészést; sebességfokozás opció a Windows OneCore hangokhoz és más hibajavítások.

### Újdonságok

* A keresés párbeszédablak már eltárolja a legutóbbi 20 keresést. (#8482)
 * A keresési előzmények törlődnek az NVDA bezárásakor és újraindításakor.
* Az NVDA már támogatja a Miranda NG kliens újabb verzióit is. (#9053) 
* Új opció a böngészőmód beállításai közt: Már kikapcsolható az automatikus böngészőmódra váltás lapok betöltésénél. ehhez meg kell szűntetni a "Böngészőmód engedélyezése lapok betöltésekor" opció bejelölt állapotát. (#8716) 
 * Ez az opció az alapértelmezett viselkedést szabályozza, a böngészőmód bármikor bekapcsolható a megfelelő billentyűparanccsal (alapértelmezés szerint: NVDA+szóköz).
* Most már az Írásjelkiejtés párbeszédablakon is van lehetőség szűrésre, hasonló módon, mint az elemlistában és a beviteli parancsok párbeszédablakán. (#5761)
* Billentyűparancs rendelhető az egér szövegfeldolgozási egységének beállításához. Nincs alapértelmezetten hozzárendelt parancs, aki használni szeretné, a beviteli parancsok közt beállíthatja. (#9056)
* A windows OneCore beszédszintetizátornál is működik már a Sebességfokozás opció, ami jelentősen felgyorsítja a beszédet. (#7498)
* Az eSpeak-NG és a Windows OneCore szintetizátorok használatakor a sebességfokozás beállítható a szintetizátor beállítási körön is. (#8934)
* A profilok már aktiválhatók billentyűparancsal is. A billentyűparancsok beállítására a Beviteli parancsok párbeszédablakában a Profilok kategóriában van lehetőség. (#4209)
 * Eclipse: Támogatás az automatikus kiegészítéshez a kódszerkesztőben. (#5667)
 * Ezenkívül Javadoc információk is kinyerhetők a szerkesztőből, amennyiben rendelkezésre állnak. Billentyűparancs: NVDA+d.
* Új, kísérleti opció a Haladó beállítások közt, mely lehetővé teszi, hogy a rendszerfókusz ne kövesse automatikusan a böngészőmód kurzorát. (Automatikus rendszerfókusz az aktiválható elemekre) (#2039) Ez a viselkedés nem kapcsolható ki minden weboldalon, de az alábbi problémákat orvosolhatja: 
 * Az NVDA visszavonja a legutóbb kiadott böngészőmódú parancsot, és a kurzor visszaugrik a parancs kiadását megelőző állapotba.
 * Böngészőmódú navigáció során egy szerkesztőmező magához ragadja a fókuszt, és kéretlenül aktív elemmé válik.
 * A böngészőmódú parancsok túl lassan reagálnak.
* Braille kijelzők: Amelyik driver támogatja, annak a beállításai már módosíthatók a Braille beállítások között. (#7452)

### Változások

* A beszédszintetizátor hangereje most már 5 egységenként állítható a szintetizátor beállítási körben. (#6754)
* A bővítménykezelő címsorában jelzi, hogy minden bővítmény le van tiltva, amikor az NVDA --disable-addons paraméterrel lett elindítva. (#9473)
* Frissült az Unikód CLDR, új emodzsi verzió: 35.0. (#9445)
* Frissült a liblouis braille fordító, új verzió: 3.9.0. (#9439)
* Az angol verzióban megváltoztatták az elemlista szűrőjének a gyorsgombját, mostantól alt+y. (#8728)

### Hibajavítások

* Az NVDA már nem fagy le, ha egy bővítmény mappája üres. (#7686)
* A tulajdonságok ablak megnyitásakor már nem jelennek meg LTR és RTL jelölők sem Brailleban, sem karakterenkénti olvasásnál. (#8361)
* Ha böngészőmódban gyorsnavigációval űrlapmezőre ugrunk, az NVDA már a mező teljes tartalmát bejelenti, nemcsak az első sorát. (#9388)
* Az NVDA már nem némul el a Windows 10 Posta alkalmazás bezárása után. (#9341)
* Az NVDA indulását már nem akadályozza meg, ha a felhasználó a Windows területi beállításaiban olyan területi formátumot adott meg,ami az NVDA számára ismeretlen, pl. Angol (Hollandia). (#8726)
* Ha a Microsoft excelben aktiválva van a böngészőmód, és átvált egy fókuszmódú böngészőre, vagy egy fókuszmódú böngészőről egy böngészőmódú Exceles dokumentumra, a böngészőmód bejelentése az elvártnak megfelelően történik. (#8846)
* Notepad++ és más Scintilla alapú szerkesztők: Az NVDA már helyesen jelenti be az egérkurzornál található sort. (#5450)
* Google Dokumentumok és más web-alapú szerkesztők: braille kijelzőkön nem jelenik meg egy lista vége előtt a lista végét jelző szimbólum. (#9477)
* Windows 10 2019 májusi frissítés: az NVDA már nem jelent be túl sok értesítést a hangerő változásáról, amennyiben azt hardveres gombokkal változtatják miközben a fájlkezelő az aktív alkalmazás. (#9466)
* Az Írásjelkiejtés párbeszédablak betöltődése sokkal gyorsabb lett ezernél is több elemet tartalmazó szimbólumszótárak használatakor. (#8790)
* Notepad++ és más Scintilla alapú szerkesztők: az NVDA helyesen jelenti be a sorokat, amennyiben a "Hosszú sorok tördelése" opció be van kapcsolva. (#9424)
* Microsoft Excel: az NVDA a shift+enter és a shift+numpadEnter parancsok használata után bejelenti az aktív cella koordinátáit. (#9499)
* Visual Studio 2017 és újabb verziók: az Objects Explorer ablakban az NVDA megfelelően jelenti be a fa struktúrák kijelölt elemeit. (#9311)
* Ha két bővítmény nevében csak kisbetűk-nagybetűk terén van eltérés, az NVDA nem fogja két különböző bővítménynek érzékelni azokat. (#9334)
* Windows OneCore hangok: Az NVDA-ban beállított beszédsebességet nem befolyásolja a Windows beszéd beállításaiban beállított beszédsebesség. (#7498)
* A napló akkor is megnyitható az NVDA+F1 paranccsal, amikor nem áll rendelkezésre fejlesztői információ a navigátorkurzor alatt található elemhez. (#8613)
* Újra használhatóak az NVDA táblázatnavigációs  parancsai  a Google Dokumentumokban, a Firefoxban és a Chromeban. (#9494)

## 2019.1.1

Ez a kiadás az alábbi hibajavításokat tartalmazza:

* Az Excel 2007 nem omlik össze és nem is utasítja vissza az elvárt visszajelzést, amennyiben képletet tartalmazó cellára navigálunk. (#9431)
* A Google Chrome nem omlik össze bizonyos listamezők használatakor. (#9364)
* javítottak egy hibát,ami megakadályozta, hogy egy felhasználó átmásolja a beállításait a rendszerkonfigurációs profilba. (#9448)
* Microsoft Excelben az NVDA a beállított nyelven jelzi az egyesített cellák koordinátáit. (#9471)

## 2019.1

 Ebben a kiadásban: Microsoft word és Excel kezelhetőségének javítása; stabilitási és biztonsági fejlesztések, mint pl. kompatibilitással kapcsolatos információkkal ellátott bővítmények; és sok más hibajavítás.

### Újdonságok

* Új braille táblák: Afrikansz, Arab 8 pontos számítógépes braille, Arab, rövidítési fokozat 2, Spanyol rövidítési fokozat 2. (#4435, #9186)
* Egy új beállítást adtunk az NVDA egérbeállításaihoz, amelynek következtében az NVDA észreveszi, ha egy másik kisegítő technológia vezérli az egeret. (#8452) 
 * Ez lehetővé teszi az NVDA számára az egér kezelését abban az esetben, ha egy rendszeren távvezérlés folyik a teamviewer, vagy más távvezérlő szoftver segítségével.
* A csendes telepítéshez hozzáadtuk az NVDA automatikus indítása paramétert, hogy be lehessen ezt állítani az ilyen jellegű telepítéseknél is.
Az érték igaz, ha a paraméter be van állítva, hamis, ha nincs.
Ha az automatikus indítási argumentum nincs beállítva, az NVDA alapértelmezetten bejelentkezés után fog elindulni, hacsak egy előző telepítés ezt már nem állította be. (#8574)
* Most már letiltható az NVDA naplózása az Általános beállítások párbeszédablakában. (#8516)
* LibreOffice és Apache OpenOffice: az NVDA már bejelenti a képleteket tartalmazó cellákat. (#860)
* Mozilla Firefox és Google Chrome: böngészőmódban az NVDA már bejelenti a kijelölt elemet a listákon és fa struktúrákon.
 * Firefox 66 és újabb verziók esetén működik.
 * Ez a beállítás google chrome-ban néhány listanézetre, és többválasztós listára nem alkalmazható.
Kezdeti támogatás ARM64 (pl. Qualcomm Snapdragon) processzorral ellátott rendszereken futó programokhoz. (#9216)
* Egy új haladó beállítások elem lett hozzáadva az NVDA beállítások párbeszédpaneljéhez, amely lehetővé teszi többek között a microsoft word dokumentumokhoz való hozzáférést a Microsoft UI Automation API felületen keresztül. (#9200)
* Támogatás a Windows lemezkezelőjének grafikus nézetéhez. (#1486)
* Új támogatott Braille kijelzők: Handy Tech Connect Braille és Basic Braille 84. (#9249)

### Változások

* Frissült a liblouis braille fordító, új verzió: 3.8.0. (#9013)
* A bővítmények fejlesztői már megadhatják a bővítmény futtatásához szükséges NVDA verziót. Amennyiben ennél régebbi verzióra kísérli meg a  bővítmény telepítését, az NVDA nem engedélyezi a telepítést.  (#6275)
* A bővítmények fejlesztői már megadhatják azt a legújabb NVDA verziót, amin tesztelték a bővítményt. Ha ennél újjabb verzióra kísérli meg a telepítést, az NVDA nem engedélyezi. (#6275)
* Ez az NVDA verzió még engedélyezi az olyan bővítmények telepítését és betöltését, ahol nincs megadva a szükséges NVDA verzió, és a tesztelt NVDA verzió. A következő verziók, már a 2019.2 is, automatikusan letiltja az ilyen bővítményeket.
* Az egérmutató navigátorkurzorhoz helyezése parancs már elérhető a Microsoft Wordben, ahogy más UIA vezérlőknél is, különösen a Microsoft Edge esetében. (#7916, #8371)
* Microsoft Edge és más UIA alkalmazások: Javították az egérkurzor alatt lévő szöveg bejelentését. (#8370)
* Ha az NVDA-t a "--portable-path" parancssori paraméterrel indítja, akkor az NVDA Eszközök menüjéből elindított hordozható verzió létrehozása párbeszédablakában az NVDA már automatikusan kitölti a hordozható verzió célkönyvtárát. (#8623)
* A norvég braille táblát frissítették a 2015-ös szabványhoz igazodva. (#9170)
* Bekezdésenkénti navigáció (ctrl+Felnyíl/Lenyíl) és a táblázatcellák közti navigáció (ctrl+alt+nyílbillentyűk), esetében a helyesírási hibákat már nem jelzi az NVDA, akkor sem, ha a Dokumentumformázás párbeszédablakon ez be van állítva. Erre azért volt szükség, mert a bekezdések és a táblázatcellák bizonyos esetekben elég nagyok lehetnek, és bizonyos alkalmazásokban a helyesírási hibák felismerése aránytalanul erőforrásigényes művelet, ez pedig jelentősen rontja a navigáció hatékonyságát. (#9217)
* Az NVDA már nem tölti be automatikusan az egyéni alkalmazásmodulokat, globális bővítményeket, sem pedig a braille és beszédszintetizátor drivereket az NVDA felhasználói mappájából. Ezek már csak szabványos NVDA bővítményként tölthetők be, ellátva a szükséges verzióinformációkkal. Erre azért van szükség, hogy ne futhasson az NVDA nem kompatibilis külső kódsorokkal. (#9238)
 * Azok a fejlesztők,akik tesztelni szeretnék a kódsoraikat az NVDA-val, az NVDA Beállítások haladó szekciójában engedélyezzék az NVDA developer scratchpad mappát, ezután elhelyezhetik a kódsoraikat az így létrejövő mappában az NVDA felhasználói mappáján belül.

### Hibajavítások

* Windows 10 2018. áprilisi frissítés:OneCore beszédszintetizátor használatakor már nem rontják a felolvasás minőségét indokolatlanul hosszú csendek. (#8985)
* Plain text vezérlőkben (pl. Jegyzettömb), és böngészőmódban karakterenkénti navigáció során a 32 bites emodzsi karakterek, melyek két   UTF-16 kódból állnak, már jól jelennek meg. (#8782)
* Egyszerűsítették az NVDA felület nyelvének megváltoztatásakor felbukkanó az újraindítás megerősítésére szolgáló párbeszédablakot. Két opció közül lehet választani: Újraindítás most vagy Újraindítás később. (#6416)
* Windows 10: Ha egy harmadik féltől származó beszédszintetizátor valami okból nem tud betöltődni, az NVDA a Windows OneCore beszédszintetizátort tölti be és nem  az espeak-et. (#9025)
* Eltávolították az NVDA üdvözlőpanelt a biztonsági képernyőn. (#8520)
* Ha tabbal lépkedünk, ill. gyorsnavigációs gombokat használunk böngésző módban, a vezérlőelemek gördülékenyen lesznek bejelentve. (#709)
* Az NVDA helyesen jelzi néhány órabeállítási párbeszédpanelt, mint az óra és ébresztés a windows 10-ben. (#5231)
* A windows 10 műveletközpontban az NVDA jelezni fogja az állapotüzeneteket, ha a gyorsműveleteket ki/bekapcsoljuk, mint a fényerőt és a fókusz segédet. (#8954)
* A windows 10 műveletközpontban, a 2018. októberi és régebbi frissítésekben, az NVDA gombként és nem kapcsológombként jelzi a fényerő gyorsműveleti gombját. (#8845)
* NVDA megint jelezni fogja a kurzor nyomát, és bejelenti a letörölt karaktereket a microsoft excel ugrás, és vagy keresés és csere párbeszédpanelén.  (#9042)
* Firefox: Javítottak egy ritka böngészőmódos hibát. (#9152)
* Az NVDA nem veszíti el a fókuszt a microsoft office 2016 menüszalagon, ha az be van zárva.
* Az NVDA nem felejti el a javasolt névjegyek bemondását, ha új E-mailt írunk Microsoft Outlook 2016-ban. (#8502)
* A néhány kurzormozgató billentyű a 80 cellás eurobraille kijelzőkön nem csak a sor elejére, ill. annak utána ugrasztja a kurzort. (#9160)
* Táblázatkezelés kijavítva a Mozilla Thunderbird szálszerinti nézetében. (#8396)
* Mozilla Firefox és Google Chrome: a fókuszmódra váltás már helyesen működik bizonyos listamezők és fa struktúrák esetében. Olyan esetekben, ahol a listamező vagy a fa struktúra maga nem kerülhet fókuszba, viszont az egyes elemei igen. (#3573, #9157)
* A böngészőmód az alapértelmezett, ha üzeneteket olvasunk az outlook 2016/365 verzióban, ha a kísérleti UIA módot használjuk a Word dokumentumok olvasásakor. (#9188)
* Az NVDA már kevesebbszer fog lefagyni oly módon, amikor az egyetlen megoldás kijelentkezni a Windowsból. (#6291)
* Windows 10 2018. októberi frissítés és újabb, ha a felhő alapú vágólapelőzményeket megnyitjuk üres vágólappal, az NVDA bejelenti a vágólap állapotát. (#9103)
* Windows 10 2018. októberi frissítés: emodzsi keresésénél az emodzsipanelen az NVDA már bejelenti a legfelső találatot. (#9105)
* Oracle VirtualBox 5.2 és újabb verziói: az NVDA már nem fagy le a főablakban. (#9202)
* Microsoft Word: jelentősen fejlődött a soronkénti, a bekezdésenkénti és a táblázatcellánkénti navigáció hatékonysága. A legjobb eredmény eléréséhez állítsa át a dokumentum nézetét a megnyitás után Piszkozat nézetre.(#9217) 
* Mozilla Firefox és Google Chrome: üres figyelmeztetéseket már nem jelent be az NVDA. (#5657)
* Microsoft Excel: Jelentős fejlesztések a cellák navigálásánál, különösen olyan esetekben,amikor a munkalap kommenteket és legördülő listákat tartalmaz. (#7348)
* Microsoft Excel 2016 és 365: Már nem szükséges kikapcsolni a "Közvetlen szerkesztés engedélyezése a cellákban" opciót az Excel beállításai közt ahhoz, hogy az NVDA-val a korábban megszokott módon lehessen szerkeszteni a cellákat. (#8146).
* Mozilla Firefox: Már nem fagy le az NVDA jelzőpontok közti navigáció során az Enhanced Aria bővítmény használatakor. (#8980)

## 2018.4

Ebben a kiadásban: Tovább javul a Firefox-élmény, emodzsik bejelentése minden beszédszintetizátorral, Megválaszolt/továbbított állapot jelzése az Outlookban, a kurzor távolságának jelzése az oldal széleitől a Microsoft Wordben, és sok hibajavítás.

### Újdonságok

* Új braille táblák: Kínai (Kína, Mandarin) Rövidítési fokozat 1 és 2 (#5553)
* Microsoft Outlook: Megválaszolt / továbbított állapot jelzése az üzenetlista elemeinél. (#6911)
* Az NVDA már képes kiolvasni és felhasználni az Unicode CLDR (Common Locale Data Repository) részét képező emodzsikhoz és más karakterekhez kapcsolódó leírásokat. (#6523)
* Microsoft Word: A kurzor távolságának jelzése az oldal tetejétől és bal oldalától a pozíció információk lekérdezésére szolgáló paranccsal, alapértelmezés szerint: NVDA+numerikus Delete. (#1939)
* Google Táblázatok: engedélyezett braille mód esetén az NVDA már nem jelent be minden cellát "kijelölve" állapotúként, amikor rá navigálunk. (#8879)
* Új támogatott szoftverek: Foxit Reader és Foxit Phantom PDF. (#8944)
* Új támogatott szoftver: DBeaver database tool. (#8905)

### Változások

* Az NVDA beállítások Objektumok megjelenítése szekciójában az "Eszköztippek bemondása" opciót megváltoztatták, új neve: "Értesítések bemondása". Erre azért volt szükség, mert mostantól ezzel az opcióval szabályozható a felugró értesítések bemondása is Windows 8 és újabb verziók esetén. (#5789)
* Az NVDA Billentyűzet beállítások párbeszédpanelén az NVDA módosítóbillentyűk kiválasztását most már egy lista segítségével lehet megtenni, és nem különálló jelölőnégyzetekkel.
* Bizonyos Windows verziók esetén az NVDA már nem jelent be redundáns információkat a rendszeróra bemondásakor. Alapértelmezés szerint NVDA+F12 (#4364)
* Frissült a liblouis braille fordító, új verziója: 3.7.0. (#8697)
* Frissült az eSpeak-NG, új verziója: commit 919f3240cbb.

### Hibajavítások

* Outlook 2016/365: A kategória és jelzők állapotának jelzése az üzeneteknél. (#8603)
* Ha az NVDA nyelvét Olyan nyelvekre állítjuk, mint  kirgiz, mongol vagy macedón, az NVDA indításakor nem jelenik meg egy párbeszédpanel, mely figyelmeztet, hogy a Windows nem támogatja az adott nyelvet. (#8064)
* Firefox, Google Chrome és Acrobat Reader DC: az egérkurzor navigátor objektumra mozgatásakor most már pontosabb a böngészőmódú pozíció követése. (#6460)
* Firefox, Chrome és Internet Explorer: javult a webes kombinált listamezők kezelése. (#8664)
* Japán verziójú Windows XP és Vista használatakor az NVDA az elvártaknak megfelelően megjeleníti a nem támogatott Windows verzióra figyelmeztető párbeszédpanelét. (#8771)
* Firefox: javult a nagy méretű, dinamikusan változó tartalmú lapok (pl. Facebook) kezelése. (#8678)
* Braille: nem jelennek meg betűtípus paraméterek, ha az opció ki van kapcsolva a dokumentumformázás beállításainak párbeszédpanelén. (#7615)
* Az NVDA már nem veszti el a fókusz irányítását a Fájlkezelőben és más UI Automationt használó alkalmazásokban, olyan esetben amikor más alkalmazás nagy erőkkel dolgozik (pl. kötegelt hangfeldolgozás zajlik a háttérben). (#7345)
* ARIA menüknél a weben az ESC gomb használata már nem eredményez fókuszmódból való kilépést. (#3215)
* Az NVDA már bejelenti az aktív elemet olyan weboldalaknál,ahol az előző aktív elem egy olyan vezérlő volt,ami időközben megszűnt. (#6606, #8341)
* Gmail: új webes kinézet használatakor, az üzenetek olvasása közben a gyorsnavigációs billentyűk csak a kívánt elemre navigálnak, az NVDA már nem olvassa fel kéretlenül az üzenet hátralévő részét. (#8887)
* Firefox és google Chrome: Az NVDA frissítése után a böngészést ott folytathatjuk, ahol a frisssítés megkezdése előtt abbahagytuk. (#7641) 
* Böngészőmódban az NVDA már nem jelenti be többször egymás után a kattintható állapotot, miközben kattintható elemek közt navigálunk. (#7430)
* baum Vario 40 braille kijelzők beviteli parancsai már az elvártaknak megfelelően működnek. (#8894)

## 2018.3.2

Ez egy hibajavító kiadás, ami megoldja a [www.twitter.com](http://www.twitter.com) oldalon fellépő navigációs problémát Google Chrome böngésző esetén. (#8777)

## 2018.3.1

Ez egy hibajavító kiadás, ami orvosol egy kritikus hibát a Mozilla Firefox 32 bites verziói esetén. (#8759)

## 2018.3

Főbb újdonságok: több braille-kijelző automatikus felismerése, több új windows 10-es tulajdonság, mint pl. a windows 10 hangulatjel-beviteli panelének támogatása és még sok más hibajavítás.

### Újdonságok

* Az NVDA már bejelenti a helyesírási hibákat, ha azokat a weboldalak megfelelően kijelzik a Firefoxban és Chrome-ban. (#8280)
* A Google Chrome-ban már megfelelően bejelenti az NVDA, ha egy tartalom megjelölése beszúrt vagy törölt. (#8558)
* Az NVDA már támogatja a BrailleNote QT és Apex BT görgőkerekének a használatát, ha a BrailleNote-t (braille jegyzetelőt) braille kijelzőként használják az NVDA-val. (#5992, #5993)
* Foobar2000: Hozzáadták azokat a szkripteket, melyek segítségével bemondatható a zeneszámból eltelt és hátralévő idő. (#6596)
* Az NVDA már bármely beszédszintetizátorral fel tudja olvasni a Mac parancsbillentyűjének jelét egy szöveg olvasásakor. (#8366)
* Minden böngészőben támogatottá váltak  a dokumentumokban az aria-roledescription attribútum segítségével definiált egyéni szerepek. (#8448)
* Új braille táblák: Cseh 8 pontos, közép-Kurd, Eszperantó, magyar, Svéd 8 pontos számítógépes braille. (#8226, #8437)
* Az NVDA már képes arra, hogy  a háttérben automatikusan felismerje a braille kijelzőket. (#1271)
 * Az NVDA jelenleg az ALVA, Baum/HumanWare/APH/Orbit, Eurobraille, Handy Tech, Hims, SuperBraille és HumanWare BrailleNote és Brailliant BI/B kijelzőket támogatja. Ezt a funkciót a braille kijelzők listájában az automatikus választási lehetőséggel lehet kiválasztani a braille kijelzők beállításai párbeszédpanelen. Kérjük, tanulmányozza a dokumentációt a további részletekért. 
* Számos új, az utóbbi kiadásokban megjelent  windows 10-es beviteli lehetőséget és egyéb funkciót támogat az NVDA, mint az emoji beviteli panel (Fall Creators Update), a diktálás (Fall Creators Update), a hardveres billentyűzeti beviteli javaslatokat (2018 áprilisi frissítés), valamint a felhős vágólapos beillesztést (2018 .októberi frissítés). (#7273)
* Firefox 63: Már támogatott az ARIA (role blockquote)segítségével idézetblokk megjelöléssel ellátott tartalom. (#8577)

### Változások

* Az NVDA általános beállítások párbeszédpanelén a nyelvek már név szerint vannak sorba rendezve, nem pedig az ISO-639 kódok szerint. (#7284)
* Alapértelmezett vezérlőparancsokat adtak hozzá a Freedom Scientific braille kijelzőkhöz az alt+shift+tab és a windows+tab billentyűparancs működtetésére. (#7387)
* ALVA BC680 és protocol converter kijelzők: Már lehetséges eltérő funkciókat rendelni a bal és jobb oldali smart pad, thumb és etouch gombokhoz. (#8230)
* ALVA BC6 kijelzők: az sp2+sp3 billentyűkombinációval megjeleníthető az aktuális dátum és idő. Az sp1+sp2 kombináció a windows gomb lenyomását emulálja. (#8230)
* Az NVDA első indításakor a program megkérdezi a felhasználót, hogy szeretne-e használati statisztikákat küldeni az NV Access részére. (#8217)
* Amennyiben a felhasználó engedélyezi a használati statisztikák küldését, az NVDA a frissítések keresése közben elküldi a használt beszédszintetizátor és braille kijelző nevét a fejlesztőknek, hogy jobban tudják rangsorolni a rájuk fordított munkát. (#8217)
* Frissült a liblouis braille fordító a 3.6.0-s verzióra. (#8365)
* Javították   az orosz nyolcpontos  Braille tábla elérési útját. (#8446)
* Frissült az  eSpeak-ng az 1.49.3 verzióra (lásd 910f4c2.  számú fejlesztői bejelentés). (#8561)

### Hibajavítások

* Googgle Chrome: Böngészőmódban  javult a vezérlők címkéinek bejelentése. (#4773)
* Zoom: már támogatott az értesítések bejelentése, pl. a némítás státusza, és bejövő üzenetek. (#7754)
* ha böngészőmódban megváltoztatja az aktív elemre vonatkozó információk bejelentési módját, a braille kimenet továbbra is a böngésző módú kurzort fogja követni. (#7741)
* ALVA BC680 braille kijelzők azonosítása során már nem lép fel időszakos hiba. (#8106)
* ALVA BC6 kijelzők: Alapértelmezés szerint a kijelző saját opcióit előhívó billentyűkombinációk, mint  sp2+sp3 már nem a rendszerbillentyűzet emulálására vannak beállítva. (#8230)
* ALVA BC6 kijelzők: az alt gomb emulálására szolgáló sp2 gomb már az elvártaknak megfelelően működik. (#8360)
* Az NVDA már nem jelent be feleslegesen billentyűzetkiosztás változásokat. (#7383, #8419)
* Az egérkurzor követése sokkal jobban működik  a Notepadnál és  más szerkeszthető szöveges vezérlőknél olyan dokumentumok esetén, amik több mint  65535 karaktert tartalmaznak. (#8397)
* Az NVDA már több párbeszédpanelt ismer fel a Windows 10-ben és más modern alkalmazásokban. (#8405)
* Windows 10 2018 októberi frissítés és Server 2019 és újabb kiadások: az NVDA már nem veszti el a rendszerfókuszt, ha egy alkalmazás lefagy, vagy túlterheli a rendszert az eseményeivel. (#7345, #8535)
* Az NVDA értesíti a felhasználókat amennyiben egy üres állapotsort akarnak olvasni vagy másolni. (#7789)
* ha nincs bejelölve állapotúra változik egy korábban félig bejelölt állapotú vezérlő, az NVDA már bejelenti a nincs bejelölve állapotot új állapotként. (#6946)
* Az NVDA általános beállítások párbeszédpanelén a nyelvek listájában már helyesen jelenik meg a burmai nyelv Windows 7 alatt. (#8544)
* Microsoft Edge: az NVDA már bejelent olyan értesítéseket, mint az olvasási nézet lehetősége, vagy az oldal betöltésének állapota. (#8423)
* A webes dokumentumokban az NVDA már bejelenti a listák címkéjét, amennyiben a fejlesztő megadta a megfelelő attribútumot. (#7652)
* Ha egy adott braille kijelzőnél beállítunk beviteli parancsokat, azokat az NVDA már csak az adott kijelzőre tekinti érvényesnek, korábban az így beállított beviteli parancsokat úgy kezelte az NVDA, mintha azt az aktuálisan csatlakoztatott kijelzőhöz állították volna be, függetlenül attól, hogy az volt-e csatlakoztatva a beviteli parancsok beállításakor, vagy sem. (#8108)
* Már támogatja az NVDA a MediaPlayer Classic 64 bites változatát. (#6066)
* Számos fejlesztés a Microsoft Word braille támogatásában UI Automation engedélyezése esetén:
 * hasonlóan más többsoros szerkeszthető szövegmezőkhöz, ha a dokumentum elejére navigál, a braille kijelző is úgy gördül, hogy a kijelző elején legyen a dokumentum kezdő karaktere. (#8406)
 * Reduced overly verbose focus presentation in both speech and braille when focusing a Word document. (#8407)
 * Word dokumentumokban listákon navigálás közben megfelelően működik a braille kijelzőn a kurzor vezetése. (#7971)
 * Microsoft Word: Az újonnan kijelölt  felsorolásjelek/számozások bejelentése már beszéd és braille visszajelzéssel is helyesen működik. (#7970)
* Windows 10 1803 és újabb kiadások: már lehetséges bővítményeket telepíteni, amennyiben az "Unicode UTF-8 használata a nyelvek támogatásához" opció be van kapcsolva. (#8599)

## 2018.2

Ebben a kiadásban: Táblázatok kezelése a Kindle for PC programban, támogatás a Humanwear BrailleNote Touch és BI14 Braille kijelzőkhöz, fejlesztések a Windows Onecore és a Sapi5 beszédszintetizátorokhoz, fejlesztések a Microsoft Outlook programban, és még sok más.

### Újdonságok

* Az NVDA hangos és Braille visszajelzést ad a táblázatok celláinak sor- és oszlopértékeiről. Egyesített cellák esetén történik pontosabb visszajelzés. (#2642)
* Google Dokumentumok (engedélyezett Braille móddal): Az NVDA táblázat navigációs parancsai már támogatottak. (#7946)
* Kindle for PC: Már lehetséges a táblázatokban navigálni. (#7977)
* Támogatás a HumanWare BrailleNote touch és Brailliant BI 14 braille kijelzőkhöz USB és bluetooth csatlakozással egyaránt. (#6524)
* Windows 10 Fall Creators Update és újabb kiadások: az NVDA már bejelenti az olyan alkalmazások értesítéseit, mint a Számológép, vagy a Microsoft Store. (#7984)
* Új braille fordítótáblák: Litván 8 pontos, Ukrán, Mongol Rövidítési fokozat 2. (#7839)
* Braille: Egy szkript lehetővé teszi formázási információk kinyerését egy meghatározott braille cellában található szövegről. (#7106)
* Az NVDA frissítési folyamat során az új verzió telepítése elhalasztható egy későbbi időpontra. (#4263) 
* Új nyelvek: mongol, német (svájci).
* A Braille billentyűzetről már emulálható a ctrl, shift, alt, windows és az NVDA gomb lenyomása. Ezen módosítógombok már kombinálhatók a braille bevitellel (pl. ctrl+s). (#7306) 
 * Ezen módosítógombok emulálásához beviteli parancsok rendelhetők a Beviteli parancsok Rendszerbillentyűk lenyomásának emulálása kategóriájában.
* Helyreállított támogatás a  Handy Tech Braillino és Modular régi firmware-rel rendelkező kijelzőkhöz. (#8016)
* Támogatott Handy Tech eszközöknél (mint az Active Braille és Active Star) az időt és a dátumot az NVDA 5 másodperc elteltével automatikusan szinkronizálja. (#8016)
* Microsoft Outlook: Az üzenetlistában az NVDA már jelzi, ha egy üzenetet megválaszoltak, vagy továbbítottak. (#6911)
* Beviteli parancs rendelhető a konfigurációs profilok feltételeinek ideiglenes kikapcsolásához. (#4935)

### Változások

* Bővítménykezelő: Az egyes bővítmények állapotát az NVDA már Engedélyezett és Letiltott jelöléssel illeti, korábban ez fut, és felfüggesztett volt. (#7929)
* liblouis braille fordító frissült a 3.5.0 verzióra. (#7839)
* A Litván braille táblát átnevezték  Litván 6 pontosra, hogy elkerüljék az összeütközést az új Litván 8 pontos táblával. (#7839)
* Braille: Eltávolították  a Francia (kanadai) Rövidítési fokozat 1 és rövidítési fokozat 2 fordítótáblákat. Ezek helyett a Francia (egységesített) 6 pontos számítógépes braille és Rövidítési fokozat 2 fordítótáblák használhatók. (#7839)
* Alva BC6, EuroBraille és Papenmeier braille kijelzők másodlagos routing gombja formázási információkat jelenít meg a gomb alatt található braille cella szövegéről. (#7106)
* A rövidírásos braille beviteli táblák automatikusan visszaállnak teljes írásos módba minden olyan esetben,ahol nem lehet szerkesztést végezni (pl. vezérlők,ahol nincs kurzor, vagy böngészőmódban). (#7306)
* Outlook naptár: Az NVDA már kevésbé bőbeszédű, ha egy találkozó, vagy más bejegyzés egész napra vonatkozik. (#7949)
* Az NVDA beállításai már egy közös Beállítások párbeszédablakon kaptak helyet. Ezt a párbeszédablakot az NVDA Menü -> Beállítások -> Beállítások menüpont alatt találja. (#577)
* Windows 10 alatt az alapértelmezett beszédszintetizátor az eSpeak helyett a Windows OneCore lesz. (#8176)

### Hibajavítások

* A Windows beállítási ablakában a Microsoft fiókba történő bejelentkezéskor e-mail cím beírása után az NVDA ismét tudja megfelelően kezelni az aktív vezérlőelemeket. (#7997)
* Microsoft Edge: Az NVDA ismét tudja olvasni az oldalt, amikor visszalépünk az előző oldalra. (#7997)
* Az NVDA már nem jelenti be kéretlenül a Windows 10 bejelentkezéséhez használt kód utolsó karakterét amikor a gépet feloldja. (#7908)
* Chrome és Firefox: az NVDA már nem jelenti be kétszer jelőlőnégyzetek és választógombok címkéit, ha a tab billentyűvel, vagy gyorsnavigációval lépkedünk rajtuk. (#7960)
* Hamis értékkel rendelkező aria-current elemek esetében az NVDA is hamis értéket jelent be, korábbban a hibás működés miatt ilyenkor igaz értéket jelzett. (#7892).
* A Windows OneCore hangok akkor is betöltődnek, ha a korábban konfigurált hangkaraktert eltávolították. (#7553)
* Windows OneCore hangok esetén a hangkarakterek váltása sokkal gyorsabb lett. (#7999)
* Javították a braille kimenetet az olyan különleges karakterek esetében, mint pl. nagybetűs jelek a 8 pontos rövidírásos dán fordítótábla esetén. (#7526, #7693)
* Microsoft Word: Az NVDA már többféle felsorolásjelet képes bejelenteni. (#6778)
* A formázási információk lekérdezésére szolgáló szkript már nem mozdítja el az áttekintőkurzort, így ugyanazon a helyen az egymás után többszöri lekérdezés nem okozhat eltérő eredményt. (#7869)
* A Braille bevitel során a program már nem enged rövidírásos braille fordítótáblákat használni az olyan esetekben,ahol ez nem támogatott. (pl. ahol a rendszer csak cellánként kezeli a bevitelt, és nem veszi figyelembe az egész szavakat, vagy böngészőmódban). (#7306)
* Handy Tech Easy Braille és Braille Wave kijelzők: Javítottak bizonyos, a kapcsolódás stabilitására kihatással lévő problémákat. (#8016)
* Windows 8 és újabb verziói: az NVDA már nem jelzi ismeretlenként a Windows gyorsmenüt (Windows+X) sem pedig a menüből kiválasztott menüpontokat. (#8137)
* Hims kijelzők: a modellspecifikus billentyűparancsok a felhasználói útmutatóban ígérteknek megfelelően működnek. (#8096)
* Az NVDA már helyre tudja állítani a rendszerkonfigurációját, ezáltal képes javítani olyan hibákat, melyek bizonyos tartalmak pl. Firefox, vagy internet Explorer dokumentumok hozzáférhetőségét ellehetetlenítették. (#2807)
* Javítottak egy Feladatkezelővel kapcsolatos hibát, mely megakadályozta az NVDA felhasználóit, hogy a folyamatok részletes információihoz hozzáférjenek. (#8147)
* Az újabb Microsoft SAPI5 hangok már nem késlekednek a beszéd végén, ezáltal hatékonyabbá vált a navigáció ilyen hangok használatával. (#8174)
* A Windows régebbi verzióiban az NVDA már nem jelent be kéretlen karaktereket a rendszeróra olvasásakor, sem braille, sem karakterenkénti olvasás esetén. (#5729)
* Hims Smart Beetle kijelzők: a görgetőgombok azonosítása ismét megbízhatóan működik. (#6086)
* Delphi-alapú alkalmazások esetében a szöveges vezérlők kapcsán a szerkeszthetőségre és a navigációra vonatkozó információk sokkal relevánsabbak. (#636, #8102)

## 2018.1.1

Ez egy hibajavító kiadás, mely orvosolja a   Windows Onecore  beszédszintetizátor hibáját. A  legfrissebb Windows 10 Redstone 4 (1803) kiadása esetén a beszédhangok magasabb hangon, és gyorsabb sebességgel beszéltek. (#8082)

## 2018.1

Ebben a kiadásban: Diagramok támogatása a Microsoft wordben és a PowerPointban, új támogatott braille kijelzők, többek közt Eurobraille és az Optelec protocol converter, fejlesztett támogatás a Hims és Optelec braille kijelzőkhöz, fejlesztések a Mozilla Firefox 58 és újabb verzióinak használatához, és még sok más.

### Újdonságok

* A Microsoft Excel után most már a Wordben és a PowerPointban is kezelhetők a diagramok. (#7046)
 * Microsoft Word:  böngészőmódban navigáljon egy beágyazott diagramra, az Enter bbillentyűvel aktiválhatja, azután kezelheti.
 * Microsoft PowerPoint: Diaszerkesztés közben navigáljon egy diagramobjektumra, az Enter vagy a szóköz billentyűvel aktiválhatja.
 * A diagramról kilépni az Esc gomb lenyomásával lehet.
* Új nyelv: Kirgiz.
* VitalSource Bookshelf támogatása. (#7155)
* Támogatás az Optelec protocol converterhez, ami lehetővé teszi a Braille Voyager és Satellite kijelzők használatát az ALVA BC6 kommunikációs protokol segítségével. (#6731)
* Már az ALVA 640 Comfort braille kijelzővel is támogatott a braille-bevitel. (#7733) 
 * A többi BC6 kijelzővel is elérhetők az NVDA braille-beviteli szolgáltatásai. Ehhez firmware 3.0.0 vagy újabb verzió szükséges.
* Kezdeti támogatás a Google Táblázatokhoz, ahol a Braille mód engedélyezett. (#7935)
* Új támogatott braille kijelzők: Eurobraille Esys, Esytime és Iris. (#7488)

### Változások

* A HIMS Braille Sense/Braille EDGE/Smart Beetle és Hims Sync Braille kijelzők drivereit lecserélték egy új közös driverre. Az új driver automatikusan aktiválódik a korábbi syncBraille driver felhasználók számára. (#7459) 
 * Néhány gomb hozzárendelését, főként a görgető gombokat, a Hims termékekben megszokottakhoz alakították. Részletekért keresse fel a felhasználói útmutató megfelelő szakaszát.
* Érintőmódban a képernyő-billentyűzettel történő bevitelhez alapértelmezés szerint duplakoppintásra van szükség, pontosan úgy, ahogy más vezérlőelemek aktiválásához. Pl. az a-betű beviteléhez duplán kell koppintani a képernyő-billentyűzet a-gombján. (#7309)
 * Egy másik beviteli mód is rendelkezésre áll, az úgynevezett Érintéses bevitel. Ezesetben nem kell duplán koppintani a képernyő-billentyűzet gombjain a bevitelhez, a megfelelő gomb aktiválásához elég felemelni róla az ujját. Ez az opció az érintőmód menüpontban az Érintéses bevitel jelölőnégyzet bejelölésével aktiválható az NVDA Beállítások menüjéből.
* Braille kijelzők: Már nem szükséges megszabni, hogy a braille az aktív elemet, vagy az áttekintő kurzort kövesse, alapértelmezés szerint a program automatikusan határozza meg, hogy épp melyiket követi. Ezzel együtt a korábbi beállítás is alkalmazható. (#2385) 
 * Az áttekintő kurzor automatikus követése csak valamelyik áttekintő parancs használatakor történhet, a görgetés nem aktiválja ezt az új viselkedést.

### Hibajavítások

* A böngészőmódú üzenetek, mint a formátuminformációk (NVDA+f kétszeri lenyomás) már nem működnek hibásan, ha az NVDA-t nem ASCII karaktereket tartalmazó elérési úttal telepíti. (#7474)
* Spotify: A program ismét megjegyzi a rendszerkurzor helyét, így ugyanoda térhetünk vissza más alkalmazásokból. (#7689)
* Windows 10 Fall Creaters Update: Az NVDA már gond nélkül frissül, abban az esetben is, amikor a Windows Defender biztonsági központban a Mappákhoz való hozzáférés szabályozása opció engedélyezve van. (#7696)
* Hims Smart Beetle kijelzők: A görgetőgombok észlelése már az elvártak szerint működik. (#6086)
* Mozilla Firefox 58 és újabb verziói: Kicsit javult a nagyméretű tartalmak kezelése. (#7719)
* Microsoft Outlook: A táblázatokat tartalmazó üzenetek olvasása már nem okoz hibát. (#6827)
* Braille kijelzők: a rendszerbillentyűzet módosítóbillentyűit emuláló beviteli parancsok már kombinálhatók más emulált billentyűkkel, akkor is ha az érintett beviteli parancsok közül egy vagy több modellspecifikus. (#7783)
* Mozilla Firefox: a böngészőmód már helyesen működik bizonyos bővítményekhez kapcsolódó felugró ablakokon. Ilyenek a LastPass és a bitwarden. (#7809)
* Firefox és Chrome: A fókusz váltása közben az NVDA már nem fagy le olyan esetekben,amikor a böngésző valamilyen okból nem válaszol. (#7818)
* Twitter kliensek, mint pl. a Chicken Nugget: az NVDA már nem hagyja figyelmen kívül a 280 karakteres tweetek utolsó 20 karakterét olvasás közben. (#7828)
* Szöveg kijelölésekor az NVDA már a megfelelő nyelvet használja a szimbólumok bejelentésére. (#7687)
* Office 365 legfrissebb verziói: az Exceles diagramokon ismét navigálhatunk a nyílbillentyűkkel. (#7046)
* Beszéd és braille visszajelzés esetén egyaránt azonos sorrendben jelenti be a program a vezérlők állapotinformációit függetlenül attól, hogy azok bejelöltek vagy sem. (#7076)
* Windows 10 alkalmazásokban, mint pl a Posta, az NVDA az elvártaknak megfelelően jelenti be a törölt karaktereket backspace használatakor. (#7456)
* Hims Braille Sense Polaris kijelzők: már minden gomb az elvártak szerint működik. (#7865)

## 2017.4

Ennek a kiadásnak a főbb újdonságai: sok hibajavítás és bővítés a webes technológiák támogatásában, beleértve a webes párbeszédpanelek böngésző módú használatát alapértelmezett beállításként, a mezők címkézésének megbízhatóbb bejelentését, új windows 10-es technológiák támogatását, mint a Windows Defender Application Guard, valamint az ARM-64-en futó windows 10 támogatását, ideértve a képernyő tájolásának automatikus meghatározását és az akkumulátor állapotának bejelentését. Vegyük figyelembe, hogy az NVDA jelen verziójától kezdve nem támogatja a Windows Xp-t vagy a Windows Vistát. Az NVDA használatához minimum Windows 7 service pack 1 szükséges.

### Újdonságok

* Böngészőmódban konténerparancsok használatakor a vessző és a shift vessző billentyűkkel lehetőség van a jelzőpontok átlépésére. (#5482)
* A Firefoxban, a Chrome-ban és az Internet explorerben a szerkesztőmezőkre, űrlapmezőkre lépő gyors navigációs billentyűk használatával már elérhetők a richtext típusú (pl. content editable) szerkeszthető tartalmak is. (#5534)
* A böngészőkben az elemlista már megjeleníti az űrlapmezőket és a gombokat is. (#588)
* A Windows 10 ARM-64 rendszer Alapvető támogatása (#7508)
* Kindle könyvekben a matematikai tartalom olvasása és interaktív navigáció kezdeti támogatása hozzáférhető matematikai képletekkel. (#7536)
* Az Azardi e-book reader támogatása megvalósult. (#5848)
* A program már megfelelően bejelenti a bővítmények verzióját, ha frissítik őket. (#5324)
* Új parancssori paramétereket adtak hozzá a fejlesztők, hogy hordozható NVDA-változatot készítsünk. (#6329)
* Megvalósult a Microsoft Edge támogatása abban az esetben, ha azt a Windows Defender elszigetelten, védett módban futtatja, feltéve, hogy Windows 10 Fall Creators Update van a gépen. (#7600)
* Ha az NVDA-t laptopon vagy tableten futtatjuk, most már bemondja azt is, ha csatlakoztatjuk vagy leválasztjuk a töltőt, valamint, ha a képernyőtájolás megváltozik. (#4574, #4612)
* Új nyelv: macedón.
* Új braille fordítási táblák: horvát 1-es fokozat, Vietnami 1-es fokozat. (#7518, #7565)
* Hozzáadták a Handy Tech Actilino braille kijelzőjének a támogatását. (#7590)
* Most már támogatják a Handitech braille kijelzőkön a braille bevitelt. (#7590)

### Változások

* Az NVDA legrégebbiként  a Windows 7 Service Pack 1, vagy a Windows Server 2008 R2 Service Pack 1 operációs rendszereket támogatja. (#7546)
* Az NVDA a webes párbeszédpaneleket most már Chrome-ban és Firefoxban automatikusan böngészőmódban jeleníti meg, kivéve a webes alkalmazásokat. (#4493)
* Ha a tabbal vagy a gyorsnavigációval mozgunk, az NVDA már nem mondja be, hogy kilépett a különféle konténerekből, mint a listák, táblázatok, így a navigációt sokkal hatékonyabbá teszi. (#2591)
* Firefoxban és Chrome-ban az NVDA már gyorsnavigáció vagy tab használata esetén is bemondja az űrlapmezők csoportjának nevét, ha rájuk lépünk. (#3321)
* A beágyazott objektumok gyorsnavigációs billentyűparancsa böngészőmódban (o és shift+o) már tartalmazza az audió- és videó-elemeket is, illetve az olyan objektumokat, ahol az Aria role alkalmazás vagy párbeszédpanel. (#7239)
* Az Espeak-ng frissült az  1.49.2 verzióra, ezzel sok olyan problémát oldottak meg, melyek a korábbi összeállítások készítésekor még megvoltak. (#7385, #7583)
* Ha az eszköztár felolvasása parancsot harmadjára is alkalmazzuk, a program a tartalmat kimásolja a vágólapra. (#1785)
* Ha egy Baum braille kijelzőn beviteli parancsokat adunk meg, azokat korlátozhatjuk az éppen használatban lévő modellre (pl. VarioUltra vagy Pronto). (#7517)
* Böngészőmódban az elemlista mezőszűrő-parancsa alt+f helyett alt+e. (#7569)
* Most már billentyűparanccsal is vezérelhető a rétegződő táblázatok jelzése opció. Alapértelmezés szerint nincs parancs hozzárendelve, de az opció megtalálható a beviteli parancsok párbeszédpanel böngészőmód kategóriájában. (#7634)
* Frissült a liblouis braille fordító a 3.3.0 verzióra. (#7565)
* A regex kifejezés rádiógombjának billentyűparancsa (angol nyelvű interfész használata esetén) a szótár párbeszédpanelen alt+e-ről alt+r-re változott. (#6782)
* A hangkarakter kivételszótár fájljai el lettek látva verziószámmal és átkerültek a 'speechDicts/voiceDicts.v1' könyvtárba. (#7592)
* A verziószámmal ellátott fájlokat (pl .konfigurációs fájlokat, hangkarakter kivételszótárakat) a program nem módosítja, ha az NVDA valamely verzióját telepítés nélkül futtatjuk.  (#7688)
* A Braillino, Bookworm és Modular (régi firmware-rel rendelkező) Handy Tech braille kijelzőket az NVDA már közvetlenül beépítve nem támogatja, telepíteni kell a Handy Tech Universal Drivert és NVDA bővítményt a használatukhoz. (#7590)

### Javítások

* A linkek már braille-ben is megjelennek az alkalmazásokban, pl. a Microsoft Wordben. (#6780)
* Az NVDA már nem lassul le érzékelhetően, ha a Firefoxban vagy a Chrome-ban több fület nyitunk meg. (#3138)
* Az MD V Lilli Braille kijelzők kurzormozgatása immár helyesen történik. (#7469)
* Az internet explorerben és más MSHTML dokumentumokban a program megfelelően kezeli a html5 "required" attribútumát, így egy űrlapmezőről megfelelően meg tudja állapítani, hogy kitöltése szükséges. (#7321)
* A braille kijelzők megfelelően frissülnek, ha arab karaktereket írunk egy balra igazított wordpad dokumentumban. (#511)
* A program most már sokkal megbízhatóbban jelenti be firefoxban a vezérlőelemek hozzáférhető címkéit, ha azok nem egymagukban állnak. (#4773)
* A Windows 10 Creators update esetén az NVDA most már újra hozzá tud férni a firefoxhoz, ha az nvda-t újraindítjuk. (#7269)
Ha a firefox van fókuszban és újraindítjuk az NVDA-t, a böngészőmód újra elérhető, de elképzelhető, hogy ehhez használni kell az alt+tabot, majd vissza kell térni a firefoxra. (#5758)
* Most már hozzáférhetünk Google Chrome-ban a matematikai képletekhez anélkül, hogy a firefoxot telepíteni kellene. (#7308)
* Ha ezt az NVDA-verziót összevetjük az előzőkkel, közvetlenül a telepítés után, a gép újraindítását megelőzően az NVDA sokkal stabilabb és megbízhatóbb lett. (#7563)
* Ha egy tartalomfelismerő parancsot használunk (pl. NVDA +r) miközben a navigátor kurzor eleme bármi okból eltűnik, az NVDA hibaüzenettel válaszol, korábban ilyen esetben nem jelzett semmit. (#7567)
* A baloldali ütközővel rendelkező Freedom Scientific Braille kijelzők visszafelé görgetése immár hibamentes. (#7713)

## 2017.3

Ebben a kiadásban: rövidírásos braille-bevitel, támogatás a Windows OneCore hangokhoz Windows 10 alatt, beépített támogatás a Windows 10 OCR használatához, és még sok fejlesztés a braille és a web kapcsán.

### Újdonságok

* Új Braille beállítási opció a megjelenő üzenetek időkorlát nélküli megjelenítéséhez. Az opció bekapcsolásához jelölje be az "Üzenetek megjelenítése időkorlát nélkül" címkéjű jelölőnégyzetet a braille beállítások párbeszédablakon. (#6669)
* Microsoft Outlook: Az üzenetlistában az NVDA már jelzi a megjelölt üzeneteket. (#6374)
* Microsoft PowerPoint: Az NVDA már jelzi az alakzatok konkrét típusait, (mint háromszög, kör, videó vagy nyíl). Korábban mindet egységesen alakzatként azonosította. (#7111)
* Google Chrome: Már hozzáférhető a MathML megjelölésű matematikai tartalom. (#7184)
* Új beszédszintetizátor: Az NVDA már támogatja a Windows OneCore hangokat, amik a Windows 10 részét képezik. Használatához válassza ki a Beszédszintetizátor párbeszédpanelen a listából a Windows OneCore hangokat. Magyar hangot is tartalmaz. (#6159)
* Az NVDA konfigurációs fájljai már a felhasználó helyi "application data" mappájába is menthetők. Ez a beállításszerkesztő megfelelő opciójával lehetséges. A rendszerparaméterekről részletesebb információt talál a felhasználói útmutatóban. (#6812)
* Webböngészők: Az NVDA már bejelenti a placeholder attribútumok értékeit a beviteli mezőknél  (aria-placeholder támogatott). (#7004)
* Microsoft Word: böngészőmódban egykarakteres gyorsnavigációval is navigálhat már a hibás szavak között. Billentyűparancsok: w és shift+w. (#6942)
* Microsoft Outlook: Támogatás a találkozók párbeszédablakain található dátumválasztó vezérlőkhöz. (#7217)
* Az NVDA bemondja az aktuálisan kijelölt javaslatot a Windows 10 Posta alkalmazás to/cc mezőinél, ill. a Windows 10 beállítások keresőmezőjénél. (#6241)
* Windows 10 alatt egy hangjelzés figyelmeztet a különböző keresőmezőkben megjelenő javaslatokra. (pl. kezdőképernyő, beállítás kereső, Posta to/cc mezők). (#6241)
* Skype for Business Desktop: az NVDA már automatikusan bejelenti az értesítéseket. Pl. ha valaki beszélgetést kezdeményez. (#7281)
* Skype for Business: Szöveges üzenetváltás közben az NVDA már automatikusan bemondja a bejövő üzeneteket. (#7286)
* Microsoft Edge: Az NVDA már automatikusan bejelenti az értesítéseket, pl ha elindul egy letöltés. (#7281)
* Braille kijelzők: Teljes írással és rövidírással is lehet szöveget bevinni braille billentyűzet segítségével. További információkért nézze meg a felhasználói útmutató Braille bevitel fejezetét. (#2439)
* Braille kijelzők: Már lehetséges Unicode braille karaktereket bevinni egy braille kijelző braille billentyűzetéről. Az opció eléréséhez a Braille beállítások párbeszédablakon válassza az Unicode braille beviteli táblát. (#6449)
* Új braille kijelző:  Támogatás a Tajvanon használt SuperBraille braille kijelzőhöz. (#7352)
* Új braille fordítótáblák: dán 8 pontos számítógépes braille, Litván, Perzsa 8 pontos számítógépes braille, Perzsa rövidítési fokozat 1, Szlovén 8 pontos számítógépes braille. (#6188, #6550, #6773, #7367)
* Frissült az angol (egyesült államokbeli) 8 pontos számítógépes braille tábla, elérhetők a felsorolásjelek, euro jel és ékezetes betűk. (#6836)
* Windows 10 OCR: Az NVDA már tudja használni a Windowsba beépített OCR funkciót képek és nem akadálymentes alkalmazások szöveges tartalmának felismeréséhez. (#7361)
 * A felismerési nyelv  beállítható a Windows 10 OCR almenüből,amit az NVDA Beállítások menüjéből érhet el. 
* A navigátor kurzornál található elem szöveges tartalmának felismeréséhez használja az NVDA+r billentyűparancsot.
 * További információkért nézze meg a felhasználói útmutató vonatkozó szakaszát.
* Braille-kijelzők: Már beállíthatja, hogy mennyi információt szeretne kapni az aktív elemről az új "Információk az aktív elemről" opcióval a Braille beállítások párbeszédablakon. (#217)
 * Pl. a Csak a változások, vagy a csak visszagörgetéssel opciók segítségével hatékonyabban dolgozhat listákkal és menükkel, mert az egyes elemek nem változtatják folyton a pozíciójukat a kijelzőn.
 * További információkért nézze meg a felhasználói útmutató vonatkozó fejezetét.
* Firefox és Chrome: Az NVDA már támogatja a komplex dinamikus rácsokat, közte az olyan táblázatos munkalapokat is, ahol a tartalomnak csak egy bizonyos része töltődik be és látszik. (aria-rowcount, aria-colcount, aria-rowindex és aria-colindex attribútumok az ARIA 1.1 verziójában). (#7410)

### Változások

* Új, nem hozzárendelt billentyűparancs az NVDA újraindítására. A beviteli parancsok közt az egyéb kategóriában található. (#6396)
* A billentyűzetkiosztás beállítható az NVDA üdvözlőképernyőjén. (#6863)
* Sokkal több vezérlőtípus, és állapot visszajelzésére képes a braille-kimenet. A jelzőpontok különböző formái is megjeleníthetők a braille kijelzőkön. Nézze meg a "Braille vezérlőtípus- és állapotrövidítések" című fejezetet a felhasználói útmutatóban. (#7188, #3975)
* Frissült az eSpeak NG az 1.49.1 verzióra. (#7280)
* A Braille beállítások párbeszédpanelen a kimeneti és beviteli braille táblák mostantól ABC-sorrendbe vannak rendezve. (#6113)
* Frissítették a liblouis braille fordítót a 3.2.0 verzióra. (#6935)
* Az alapértelmezett braille tábla mostantól az Egységes angol Braille kód rövidítési fokozat 1. (#6952)
* Braille kijelzők: Az aktív elem megváltozásakor alapértelmezés szerint az NVDA csak azokat az információkat jeleníti meg a braille kimeneten, amik megváltoztak. (#217)
 * Korábban a lehető legtöbb információt megjelenítette, attól függetlenül, hogy azok megjelentek-e már a kijelzőn.
 * A korábbi működéshez válassza "A lehető legtöbb információ" opciót a Braille beállítások információk az aktív elemről kombinált listamezőjében.
* Braille kijelzők: Már a kurzor alakjával is megkülönböztethető, hogy a braille kijelző a rendszerkurzort, vagy az áttekintőkurzort követi-e. E kétféle kurzor alakja külön-külön konfigurálható a Braille beállítások párbeszédpanel vonatkozó kombinált listamezőivel. (#7112)
* frissítették az NVDA logóját. Az új, stílusos logó az NVDA 4 betűje fehér színnel halványlila háttér előtt. Ezáltal jobban látható a logó bármilyen színű háttér előtt. Ugyanazt a lila színt használják, mint az NV Access logóján. (#7446)

### Hibajavítások

* Google Chrome: Böngészőmódban a szerkeszthető div elemek címkéjét már nem jelenti be a program úgy, mintha az az értékük lenne. (#7153)
* Microsoft Word: böngészőmódban egy üres dokumentum esetén az end billentyű leütése már nem okoz futási hibát. (#7009)
* Microsoft Edge: a böngészőmód megfelelően működik az olyan dokumentumoknál, ahol a dokumentum, mint szerep Aria-attribútummal jelezve van. (#6998)
* Böngészőmódban a sor végéig tartó kijelölés parancsa Shift+End akkor is az elvártaknak megfelelően működik, ha a kurzor a sor utolsó karakterénél áll. (#7157)
* Ha egy párbeszédablak folyamatjelzőt tartalmaz, az NVDA már braille-kimeneten is jelzi a párbeszédablakon a folyamatjelző változásával párhuzamosan frissülő szöveges tartalmat. Pl. visszajelzi a  hátralévő idő változását az NVDA frissítésének letöltése párbeszédablaknál. (#6862)
* Windows 10: Az NVDA már visszajelzi bizonyos kombinált listamezőknél a kijelölt elem megváltozását. Pl. az automatikus lejátszás beállításánál. (#6337).
* Microsoft Outlook: A találkozók létrehozása párbeszédablakainak megnyitásakor már nem jelent be az NVDA értelmetlen információkat. (#7216)
* A nem behatárolható folyamatjelzőknél (pl. frissítés keresése) az NVDA csak akkor ad hangjelzést, ha az Objektumok megjelenítése beállítási párbeszédablakon a folyamatjelzők visszajelzésénél az be van állítva. (#6759)
* Microsoft Excel 2003 és 2007: Az NVDA bejelenti a cellákat a munkalapon nyílbillentyűkkel történő navigáció esetén. (#8243)
* Windows 10 alkotói frissítés, és újabb frissítések: Az NVDA ismét automatikusan böngészőmódra vált a windows 10 posta alkalmazásában, amikor levelet olvas. (#7289)
* A legtöbb braille billentyűzettel rendelkező braille kijelzőnél a 7. pont törli a legutóbb bevitt braille cellát vagy karaktert, a 8. pont szimulálja az enter billentyű leütését. (#6054)
* Szerkeszthető szövegmezőkben kurzormozgatásnál (kurzormozgató gombok, backspace) az NVDA beszéd visszajelzése sokkal pontosabban működik. Elsősorban Chrome és parancssori alkalmazások esetén. (#6424)
* Microsoft Outlook 2016: Az NVDA már tudja olvasni az aláírás-szerkesztő tartalmát. (#7253)
* Java Swing alkalmazások: Az NVDA már nem okozza a program leállását néha,amikor táblázatokban navigál. (#6992)
* Windows 10 alkotói frissítés: Az NVDA már nem jelenti be kéretlenül többször egymás után a felugró értesítéseket. (#7128)
* Windows 10: A start menü enterrel történő bezárása egy keresés után már nem eredményezi a keresett szöveg bemondását. (#7370)
* Microsoft Edge: Lényegesen gyorsabban reagál a címsorok közti  gyorsnavigációs parancsokra. (#7343)
* Microsoft Edge: A böngészőmódú navigáció már nem hagyja figyelmen kívül hibásan bizonyos weboldalak tartalmának nagy részét.  Pl. a Wordpress 2015 témát alkalmazó weboldalaknál. (#7143)
* Microsoft Edge: A jelzőpontok visszajelzése már az elvártaknak megfelelően, az NVDA honosítás nyelvén történik,angolon kívül más nyelveken is. (#7328)
* Braille kijelzők: A braille már helyesen követi a kijelölést olyan esetekben, amikor a kijelölt szöveg egésze nem fér el a kijelzőn. Pl, ha több sort jelöl ki, a braille csak az utolsó sort jeleníti meg. (#5770)
* Firefox: Az NVDA már nem ismétli hibásan a "szakasz" bejelentést amikor megnyitja egy tweet részleteit a twitter.com weboldalon. (#5741)
* Böngészőmódban a táblázatnavigációs parancsok csak akkor működnek a rétegződő táblázatoknál, ha a Rétegződő táblázatok jelzése opció be van kapcsolva a böngészőmód beállításai párbeszédablakon. (#7382)
* Firefox és Chrome: böngészőmódban a táblázatnavigációs parancsok figyelmen kívül hagyják a rejtett cellákat. (#6652, #5655)

## 2017.2

Ebben a kiadásban: A hangerő-igazítás teljes támogatása a Windows 10 Alkotói frissítéséhez. Több, böngészőmódban jelentkező kijelőléssel kapcsolatos hiba javítása, orvosolták többek közt a minden kijelölése parancs problémáit is. Jelentősen javult a Microsoft Edge támogatása. Valamint fejlődött a webes dokumentumok kezelése, úgy mint az aktuális oldal jelzése (aria-current használata esetén).

### Újdonságok

* Microsoft Excel: A formázási információk lekérdezésére szolgáló paranccsal (NVDA+F) már elérhetők a cellaszegélyekre vonatkozó információk is, szín és vonaltípus. (#3044)
* Webböngészők esetén az NVDA már jelzi, ha a jelenlegi oldal meg van jelölve aktuálisnak az aria-current attribútum használatával. (#6358)
* Microsoft Edge: Már támogatott az automatikus nyelvváltás. (#6852)
* Windows 10 Enterprise LTSB (Long-Term Servicing Branch) és Server: Támogatás a számológéphez. (#6914)
* Az aktuális sor felolvasása parancs kibővült. Háromszori gyors lenyomásra az adott nyelvhez meglévő karakterleírásokkal betűzi az egész sort. (#6893)
* Új nyelv: burmai.
* Unicode fel és lenyíl ill. a törtszámokkal kapcsolatos szimbólumok felolvasása. (#3805)

### Változások

* UI Automationt használó alkalmazásokban egyszerű áttekintés esetén figyelmen kívül hagy az NVDA bizonyos lényegi információt nem hordozó elemeket a navigáció megkönnyítése érdekében. (#6948, #6950)

### Hibajavítások

* A weboldalakon már aktiválhatók a menüelemek böngészőmódban is. (#6735)
* Konfigurációs profil törlésekor amikor a törlés megerősítése párbeszédablak aktív, az ESC billentyű leütése bezárja azt, és nem hagyja jóvá a törlést. (#6851)
* Mozilla Firefox és más Gecko alkalmazások: javítottak több, a multi-process használata közben jelentkező hibát. (#6885)
* Képernyőáttekintés során már sokkal pontosabban működik a háttérszín lekérdezése olyan esetben, amikor a szöveghez átlátszó háttérszínt állítottak be. (#6467)
* Internet Explorer 11: Fejlesztett támogatás a weblapokon található vezérlők leírásához. (Támogatás az iframes aria-describedby elemeihez  ill. ha többszörös ID-t használnak). (#5784)
* Windows 10 Alkotói frissítés: A hangerő-igazítás ismét úgy működik, mint a korábbi Windows 10 kiadásokban. Ismét él mindhárom beállítási lehetőség: Mindig, soha, Csak amikor az NVDA használja a hangkimenetet. (#6933)
* UIA vezérlők: NVDA-navigációval  elérhető, és a program bemondja az olyan vezérllőket,amikhez nincs billentyűparancs beállítva. (#6779)
* UIA vezérlők: A program már nem ad hozzá két üres szóközt a billentyűparancs információkhoz. (#6790)
* HIMS braille-kijelzők: Bizonyos billentyűkombinációk (pl. space+4. pont) már nem működnek hibásan. (#3157)
* Braille-kijelzők: javítottak egy, bizonyos nem angol nyelvű rendszerekben, a soros port megnyitásakor fellépő hibát, mely megakadályozta a kijelző csatlakozását a számítógéphez. (#6845)
* Csökkentették a konfigurációs fájlok sérülésének esélyét a windows nem várt leállása esetén. Egy konfigurációs fájl módosítása először ideiglenes fájlban történik meg, és csak aztán írják felül az aktuális konfigurációs fájlt.  (#3165)
* Az aktuális sor felolvasására szolgáló parancs kétszeri gyors lenyomása esetén már a megfelelő nyelven történik a sor kibetűzése. (#6726)
* Microsoft Edge: A Windows 10 alkotói frissítés esetén akár háromszor gyorsabban működik a soronkénti navigáció. (#6994)
* Microsoft Edge, Windows 10 alkotói frissítés: Az NVDA már nem jelent be kéretlen információt ("Web Runtime grouping"), ha egy dokumentumra kerül a rendszerfókusz a böngészőben. (#6948)
* SecureCRT: minden elérhető verzió támogatott. (#6302)
* Adobe Acrobat Reader: Már nem omlik össze olyan PDF dokumentumok olvasása során, melyeknél az ActualText attribútum üres. (#7021, #7034)
* Microsoft Edge: Böngészőmódban lehet navigálni az interaktív táblázatok (ARIA grids) közt a táblázatokra vonatkozó egykarakteres gyorsnavigációval (t és shift+t). (#6977)
* Böngészőmódban, ha egy sort elkezdünk kijelölni balról jobbra,akkor a shift+home billentyűparancs hatására megszűnik a kijelölés a sor elejéig, mint ahogy az elvárható. (#5746)
* Böngészőmódban a minden kijelölése parancs (control+a) már akkor is kijelöl minden szöveget, ha a kurzor nem a szöveg elején áll. (#6909)
* Böngészőmódban néhány további kijelölési problémát javítottak. (#7131)

## 2017.1

Ebben a kiadásban: Szakasztörések és hasábok bemondása a Microsoft Wordben; Támogatás a Kindle for PC ebook olvasóhoz (Könyvek olvasása, navigálás, kiemelések, jegyzetek); és fejlődött a Microsoft Edge támogatása is.

### Újdonságok

* Microsoft Word: A szakasztörések típusát, és a szakaszok sorszámát már bemondja az NVDA. Ezzel az Oldalszámok bemondása opció bővült, ami elérhető a Dokumentumformázás párbeszédpanelen. (#5946)
* Microsoft Word: A hasábokat már jelzi az NVDA. Ezzel az Oldalszámok bemondása opció bővült, ami elérhető a Dokumentumformázás párbeszédpanelen. (#5946)
* WordPad: Az automatikus nyelvváltás már támogatott. (#6555)
* Microsoft Edge: Böngészőmódban az NVDA keresés parancs (NVDA+control+f) használata már támogatott. (#6580)
* Microsoft Edge: Böngészőmódban a gombok közti navigálásra szolgáló gyorsbillentyűk  (b és shift+b) használata már támogatott. (#6577)
* Microsoft Excel: Munkalapok másolása után a másolatban is működnek a korábban beállított oszlop- és sorfejlécek. (#6628)
* Kindle for PC 1.19 verzió: Már támogatott a könyvek olvasása és a navigálás. Kezelhetőek a hivatkozások, lábjegyzetek, ábrák, kiemelt szövegek és a jegyzetek. Az NVDA felhasználói útmutatójában bővebb információkat találhat a témáról. (#6247, #6638)
* Microsoft Edge: már támogatott a böngészőmódú táblázatnavigáció. (#6594)
* Microsoft Excel: Bővült az áttekintőkurzor pozícióinformációit lekérdező parancs (Asztali: NVDA+numerikus Delete, laptop: NVDA+delete). Már bemondja a munkalap nevét, és a cella koordinátáit. (#6613)
* Új opció a Kilépés az NVDA-ból párbeszédpanelen: Újraindítás nyomkövetés naplózási szinttel. (#6689)

### Változások

* Braille beállítások: A legkisebb kurzorvillogási érték most már 200 ms. Korábban ennél alacsonyabb érték megadása után a program automatikusan növelte az értéket erre a szintre. (#6470)
* Braille beállítások: Új opció: Villogó kurzor jelölőnégyzet. Engedélyezheti/letilthatja a kurzor villogását. Korábban az opciót letiltani a kurzor villogási sebességének 0-ra állításával lehetett. (#6470)
* eSpeak NG frissítése (commit e095f008, 2017. január 10.). (#6717)
* Windows 10 Creators update: A Mindig opció nem elérhető az NVDA hangerő-igazítás szolgáltatásában. A korábbi Windows 10 kiadásokban marad az opció és a megszokott viselkedés. (#6684) 
* Windows 10 Creators update: A Csak amikor az NVDA használja a hangkimenetet opció a hangerő-igazítás szolgáltatásban nem működik a korábban megszokott módon, később veszi le a hangerőt, és korábban állítja vissza. Ez gyakoribb hullámzást okoz a hangerőben. A korábbi Windows 10 kiadásokban marad a megszokott viselkedés. (#6684) 

### Hibajavítások

* Microsoft Word: Már nem fagy le az NVDA, ha böngészőmódban egy hosszabb dokumentumban bekezdésenként mozgunk. (#6368)
* MS office: A Microsoft Excelből a Microsoft wordbe beillesztett táblázatokat már jól kezeli az NVDA. (#5927)
* Microsoft Excel: Védett nézetben ha megkísérelünk karaktereket beírni, az NVDA hangjelzést ad. Korábban bemondta a leütött karaktereket, amik egyébként be sem kerültek a dokumentumba. (#6570)
* Microsoft Excel: Az Esc lenyomása már csak abban az esetben eredményezi a böngészőmódra váltást, amennyiben korábban az NVDA+Szóköz paranccsal léptünk böngészőmódba, és egy űrlapmezőn enterezve fókuszmódra váltott a program. Korábban az Esc lenyomására kéretlenül is böngészőmódba váltott a program. (#6569) 
* Microsoft Excel: Az NVDA már nem fagy le, ha egy egész sor vagy oszlop egyesítve van. (#6216)
* Microsoft Excel: Az átlógó és letakart szövegek jelzése pontosabb lett. (#6472)
* Az NVDA már jelzi ha egy jelölőnégyzet állapota csak olvasható. (#6563)
* Az NVDA már nem jelenít meg hibaüzenetet, ha az indító hangot nem tudja lejátszani megfelelő hangeszköz híján. (#6289)
* Microsoft Excel: A nem érhető el állapotú ribbon vezérlőelemeket az NVDA az elvártnak megfelelően jelenti be.  (#6430)
* Az NVDA már nem jelent be terület elemet az ablakok kis méretűre állításakor. (#6671)
* Windows 10 Creators Update: A beírt karakterek bemondása működni fog a Universal Windows Platform (UWP) alkalmazásokban (beleértve a Microsoft Edge-t is). (#6017)
* Az egérmutató követése most már a többmonitoros számítógépek minden képernyőjén működik. (#6598)
* Az NVDA már nem válik használhatatlanná, ha a Windows Media Playert úgy zárjuk be, hogy az aktív elem egy csúszka. (#5467) 

## 2016.4

Ebben a kiadásban: javított támogatás a Microsoft Edge-hez; böngészőmód a Win 10 Üzenetek alkalmazáshoz, ill. jelentős javítások az NVDA párbeszédpanelein.

### Újdonságok

* Az NVDA már képes hangjelzéssel is jelezni a behúzásokat. Ez beállítható az NVDA Dokumentumformázás párbeszédpanelén a "Behúzások jelzése" kombinált listamező segítségével. (#5906)
* Támogatás az Orbit Reader 20 braille kijelzőhöz. (#6007)
* Új opció a beszédnéző ablakán: A jelölőnégyzet bejelölésével a beszédnéző az NVDA indulásakor automatikusan megnyílik. (#5050)
* A Beszédnéző ablaka már megjegyzi a legutóbbi pozícióját és méretét. (#5050)
* Microsoft Word: Az NVDA most már a kereszthivatkozásokat is úgy kezeli, mint a hiperhivatkozásokat, linkként jelenti be őket, és aktiválhatók. (#6102)
* Támogatás a Baum SuperVario2, Baum Vario 340 és HumanWare Brailliant2 braille kijelzőkhöz. (#6116)
* Kezdeti támogatás a Microsoft Edge évfordulós frissítéséhez. (#6271)
* Win 10: Már böngészőmódban olvashatók az e-mailek az Üzenetek alkalmazásban. (#6271)

### Változások

* Frissítették a liblouis braille fordítót a 3.0.0 verzióra. Jelentős változások az egységes angol Braille kapcsán. (#6109, #4194, #6220, #6140)
* A Bővítménykezelő opcióihoz gyorsgombokat rendeltünk: e: engedélyezés, l: letiltás, t: eltávolítás, s: súgó, n: névjegy, h: hozzáadás, b: beszerzés a weboldalról. (#6388)
* Helykitöltési és igazítási hibákat javítottak az NVDA különböző párbeszédpanelein. (#6317, #5548, #6342, #6343, #6349)
* A Dokumentumformázás párbeszédpanel felépítésén sokat javítottak. (#6348)
* Javítottak az Írásjelkiejtés párbeszédpanel kinézetén, most már az ablak teljes szélességét kitölti az írásjelek listája. (#6101)
* Böngészőmódban a szerkesztőmezők (e és shift+e), ill. az űrlapmezők (f és shift+f) közti navigálásra szolgáló gyorsgombok mostantól a csak olvasható szerkesztőmezők közti navigálásra is képesek. (#4164)
* Dokumentumformázás párbeszédpanel: "A kurzor pozíciójánál lévő formázások változásának jelzése (a visszajelzés késését okozhatja)" opció korábbi elnevezésén finomítottunk, hogy egyaránt vonatkozzon a beszéd ill. a braille visszajelzésre is. (#6336)
* Javítottak az NVDA üdvözlőképernyő kinézetén. (#6350)
* Az NVDA párbeszédpanelein az "Ok" és a "Mégse" gombokat a jobb oldalra igazították. (#6333)
* Az NVDA most már léptetőgombokat használ a numerikus beviteli mezőkhöz a párbeszédpanelein, pl.: "Hangmagasság változtatása nagybetűknél" opció a Beszéd párbeszédpanelen. Beírhatja a kívánt értéket, vagy a fel és le nyilakkal változtathatja azt értelemszerűen. (#6099)
* Az IFrame objektumok jelzése egységesebb lett az egyes böngészőkben. A Firefoxban keretként jelzi az NVDA. (#6047)

### Hibajavítások

* Javítottak egy hibát, mely az NVDA bezárásakor jelentkezett olyankor, amikor nyitva volt a beszédnéző. (#5050)
* Mozilla Firefox: Böngészőmódban már az elvárt módon kezeli az NVDA az image map objektumokat (interaktív képek). (#6051)
* A kivételszótárak ablakában az enter lenyomása menti a változásokat, és bezárja az ablakot. Korábban az enter lenyomására nem történt semmi. (#6206)
* Az üzenetek megjelennek braille-ben, amikor összetett beviteli módra váltunk (alapértelmezett bevitel/alfanumerikus, teljes alakos/félalakos, stb.). (#5892, #5893)
* Ha egy bővítmény állapotát megváltoztatjuk (letiltjuk/engedélyezzük), majd gyorsan vissza is változtatjuk az eredeti állapotára, akkor az NVDA már helyesen jelzi az aktuális állapotot. (#6299)
* Microsoft Word: Az NVDA már jelzi az oldalszám mezőket a fejlécekben. (#6004)
* Írásjelkiejtés párbeszédpanel: Már az egérrel is áthelyezhető a fókusz az írásjelek listája és a szerkesztőmezők közt. (#6312)
* Microsoft Word: Böngészőmódban már nem akadályozza meg az elemlista megnyitását, ha a dokumentum tartalmaz egy érvénytelen hiperhivatkozást. (#5886)
* Ha a Beszédnézőt a tálcáról, vagy az alt+F4 paranccsal zárjuk be, a vonatkozó jelölőnégyzet az NVDA menüjében már az ablak aktuális állapotát jelzi. (#6340)
* A bővítmények újratöltése parancs már nem okoz problémákat a beállítási profiloknál, új dokumentumoknál webböngészőkben, és a képernyőáttekintésben sem. (#2892, #5380)
* Az NVDA általános beállítások párbeszédpanelén a nyelvek már helyesen jelennek meg Windows 10 alatt. (#6259)
* Az emulált rendszerbillentyűk (pl.: egy gomb a braille kijelzőn, ami a tab gomb lenyomását emulálja) már az NVDA-ban beállított nyelven jelennek meg a bevitelsúgóban és a beviteli parancsok párbeszédpanelen. Korábban ezek kizárólag angolul jelentek meg. (#6212)
* Az NVDA nyelvének megváltoztatása az általános beállítások párbeszédpanelen az NVDA újraindulásáig nem okoz semmilyen változást. (#4561)
* Már nem lehet üresen hagyni a tényleges kifejezést új kivételszótár-bejegyzéseknél. (#6412)
* Braille: Javítottak egy hibát, mely bizonyos rendszereken a soros port keresése közben jelentkezett. Emiatt használhatatlanok voltak bizonyos típusú braille kijelzők. (#6462)
* Microsoft Word: Az NVDA már jelzi a számozott felsorolást a táblázatcellákban, amennyiben a cellákon navigálunk. (#6446)
* Microsoft Excel: Amikor egy munkafüzetben navigálunk, az enter vagy a numpad enter lenyomása után az NVDA már bejelenti az aktív cellát. (#6500)
* iTunes: Böngészőmódban már nem fagy le a program, iTunes Store, Apple Music, stb. használatakor. (#6502)
* Hibajavítások 64 bites Mozilla és Chrome-alapú alkalmazásokban. (#6497)
* Mozilla Firefox: többfolyamatos futás engedélyezése esetén a böngészőmód és a szerkesztőmezők már helyesen működnek. (#6380)

## 2016.3

E kiadás főbb újdonságai: bővítmények külön-külön történő felfüggesztése, űrlapmezők támogatása Microsoft Excelben, jelentős fejlesztések a színek bemondása kapcsán, fejlesztések és javítások több braille kijelzőhöz, valamint a Microsoft Wordhöz.

### Újdonságok

* A Windows 10 éves frissítésében lehetővé válik a Microsoft Edge-ben a böngészőmód használata pdf dokumentumok olvasásakor. (#5740)
* A program Microsoft wordben már megfelelően jelenti be az áthúzott és duplán áthúzott formátumot. (#5800)
* Microsoft Word: Ha egy táblázatnak van címe, az NVDA azt már megfelelően jelenti be. Ha van hozzá leírás, az a hosszúleírás megnyitása (NVDA+d) billentyűparanccsal böngészőmódban elérhető. (#5943)
* Microsoft Word: Az NVDA már ad visszajelzést a bekezdések mozgatására szolgáló billentyűparancsok használatakor. (alt+shift+le vagy alt+shift+felnyíl). (#5945)
* Microsoft Word: Az NVDA már bemondja a sorközök nagyságát. Új opció a Dokumentumformázás párbeszédpanelen: Sorköz jelzése. (#2961)
* Az internet explorerben az NVDA már felismeri a html5 szerkezeti elemeket. (#5591)
* A megjegyzések jelzése (pl. Microsoft Wordben) már kikapcsolható  a megjegyzések jelzése jelölőnégyzettel a Dokumentumformázás párbeszédpanelen. (#5108)
* Most már lehetőség van a bővítmények külön-külön történő felfüggesztésére a bővítménykezelőben. (#3090)
* További billentyű-hozzárendeléseket adtak hozzá az ALVA BC640/680 sorozatba tartozó braille kijelzőkhöz. (#5206)
* Van egy új parancs, amellyel a braille kijelzőt az aktuális fókuszhoz lehet mozgatni. Jelenleg ez csak az ALVA BC640/680 sorozatú braille kijelzőkhöz van hozzárendelve, azonban a beviteli parancsok párbeszédpanelen kézzel igény szerint más kijelzőkhöz is hozzá rendelhető. (#5250)
* A Microsoft Excelben már lehetőség van kezelni az űrlapmezőket. Ehhez vagy az elemlistában, vagy böngészőmódban kell navigációs gyorsbillentyűvel megkeresni azokat. (#4953)
* A beviteli parancsok párbeszédpanelen most már billentyűparancsot lehet rendelni az egyszerű áttekintőmód bekapcsolásához. (#6173)

### Változások

* Változás a színek bemondásánál: Az NVDA innentől a színkör/színkerék logikáját követve kezeli a színeket. 9 szín, 3 árnyalat, kiegészítve fényes és fakó változatokkal. Ez talán jobban érthető, és kevésbé szubjektív rendszer. (#6029)
* Megváltozott az NVDA+F9 és NVDA+F10 parancs működése. Az NVDA+f9 továbbra is a kijelölés kezdetét határozza meg, az NVDA+F10 egyszer megnyomva a kijelölést befejezi abban a pozícióban, ahol az áttekintőkurzor van, kétszer megnyomva pedig a vágólapra másolja a szöveget. (#4636)
* Frissült  az eSpeak NG Master 11b1a7b (22 June 2016) verzióra. (#6037)

### Javítások

* Ha Microsoft Wordben böngészőmódban a vágólapra másolunk, a program már megőrzi a formázást. (#5956)
* Microsoft Word: Az NVDA már az elvárt módon működik a Word saját táblázat-navigációs parancsainak használatakor (alt+home, alt+end, alt+pageUp és alt+pageDown), ill. a táblázat kijelölésére szolgáló parancsok használatakor (Az iménti parancsok kiegészítve a shift billentyűvel). (#5961)
* Nagy mértékben fejlődött a Microsoft Word párbeszédpanelein az NVDA elemnavigációs képessége. (#6036)
* Bizonyos alkalmazásokban, mint pl. a Visual Studio 2015, a billentyűparancsokat, gyorsgombokat, mint pl. a kontroll +c-t másolásnál, az elvárásoknak megfelelően mondja be a program. (#6021)
* Braille kijelzők: Javítva egy, a soros portok keresésénél jelentkező hiba, mely bizonyos braille kijelzőket használhatatlanná tett. (#6015)
* Microsoft Word: A színek bemondása sokkal pontosabb lett dokumentumtémák alkalmazása esetén. (#5997)
* A Microsoft Edge-ben a böngészőmód, valamint a startmenü keresési javaslatainak a támogatása újra elérhető a windows 10 áprilisi kiadásától kezdve. (#5955)
* Microsoft wordben jobban működik a táblázatok fejléceinek automatikus felolvasása, ha egyesített cellákkal dolgozunk. (#5926)
* A Windows 10 levelezőprogramjában most már nem hiúsul meg az üzenetek tartalmának felolvasása. (#5635) 
* Ha a parancsbillentyűk bemondása be van kapcsolva, az NVDA most már nem mondja kétszer a zárolható billentyűket, pl. capslockot. (#5490)
* A Windows 10 éves frissítésekor a felhasználói felügyeleti párbeszédpaneleket az NVDA újra megfelelően olvassa fel. (#5942)
* A Webkonferencia bővítményben (pl. amit az out-of-sight.net weboldal is használ) az NVDA már nem jelzi sem beszéddel, sem hanggal a mikrofon bemenethez kapcsolódó folyamatjelző változását. (#5888)
* Most már az előző vagy következő keresés parancsok böngészőmódban figyelembe veszik a kis- és nagybetűket, ha eredetileg is kértük a kereséskor ezek megkülönböztetését. (#5522)
* Szótárbejegyzések szerkesztésekor az NVDA visszajelzést ad érvénytelen regex kifejezések esetén. Az NVDA már nem fagy le, ha egy szótárbejegyzés szabálytalan regex kifejezést tartalmaz. (#4834)
* Ha az NVDA nem tud kommunikálni egy braille kijelzővel például azért, mert azt eltávolították, a program tiltja a kijelző használatát. (#1555)
* Bizonyos esetekben kissé növekszik az NVDA teljesítménye böngészőmódban az elemek szűrésekor. (#6126)
* Microsoft Excel: A háttérmintázatok bejelentése összhangba került az Excelben használt elnevezésekkel. (megjegyzés: A honosított változatban ez eddig is így volt, változás csak az angol nyelvű felületen történt.) (#6092)
* Fejlődött a Windows 10 bejelentkező képernyő támogatása, ideértve az értesítések felolvasását, vagy a jelszó szerkesztőmező érintéssel történő aktiválását. (#6010)
* Braille kijelzők: Az NVDA helyesen érzékeli a másodlagos kurzormozgató gombokat az ALVA BC640/680 series braille kijelzőknél. (#5206)
* Az NVDA újra rendesen felolvassa a bejelentési értesítéseket a Windows 10 legújabb kiadásában. (#6096)
* Az NVDA most már nem mulasztja el felismerni a billentyűparancsokat alkalmanként a Baum kompatibilis és a HumanWare Brailliant B braille kijelzők használata során. (#6035)
* Ha a sorszámok bemondása be van kapcsolva a dokumentumformázás párbeszédpanelen, a sorszámok a braille kijelzőn is megjelennek. (#5941)
* Ha a beszéd ki van kapcsolva, az objektumok megjelenítése, mint pl. az NVDA+tab a fókusz bemondására, most már megjelennek a beszédnézőben, ahogy azt elvárnánk.(#6049)

## 2016.2.1

Ez a kiadás kijavít néhány súlyos hibát, mely a Microsoft Word összeomlását okozta:

* A Microsoft Word már nem omlik össze rögtön az induláskor Windows Xp használata esetén. (#6033)
* A nyelvhelyességi hibák jelzése eltávolításra került az NVDA-ból, ugyanis a Microsoft Word összeomlását okozta. (#5954, #5877)

## 2016.2

Ebben a kiadásban: Hangjelzés gépelési hibánál; nyelvhelyességi hibák jelzése a Microsoft Wordben; ill. kisebb-nagyobb fejlesztések a Microsoft Office támogatás terén.

### Újdonságok

* Internet Explorer és más MSHTML vezérlők: Böngészőmódban az annotációk navigációs gyorsbillentyűi (a és shift+a) már a  beszúrt és törölt szövegek közti navigálásra is használhatók. (#5691)
* Microsoft Excel: Az NVDA már bejelenti  a csoportosított cellák szintjét, legyenek akár becsukva,akár kinyitva. (#5690)
* A formázási információk lekérdezésére szolgáló billentyűparancs (NVDA+f) kétszeri lenyomásra böngészőmódban prezentálja az információkat, amik így áttekinthetők. (#4908)
* Microsoft Excel 2010 és újabb verziói: A cellák árnyékolását és színátmenetes kitöltését már jelzi az NVDA. Az automatikus bemondás a Dokumentum formázás párbeszédpanelen a Színek bemondása opcióval vezérelhető. (#3683)
* Új braille fordítótábla: Hellénisztikus görög (Koiné). (#5393)
* A Naplónézőben már használható a control+s billenytyűparancs a napló elmentésére. (#4532)
* Ha  a Helyesírási hibák jelzése opció be van kapcsolva, és a fókuszban lévő vezérlő támogatja, az NVDA egy hangjelzéssel figyelmeztet a gépelés közben ejtett hibára. Ez az új opció a Hangjelzés gépelési hibánál néven az NVDA Billentyűzet beállítások... párbeszédpanelén kapcsolható ki és be. (#2024)
* Microsoft Word: Új opció, a nyelvhelyességi hibák jelzése, az NVDA Dokumentum formázás párbeszédpanelén lehet ki- és bekapcsolni. (#5877)

### Változások

* Böngészőmódban, és szerkeszthető szövegmezőkben az NVDA már ugyanúgy kezeli a Numpad Enter billentyűt,mint az elsődleges Enter gombot. (#5385)
* Az NVDA mostantól az eSpeak NG beszédszintetizátort használja. (#5651)
* Microsoft Excel: Az NVDA már nem hagyja figyelmen kívül egy cella oszlopfejlécét, amennyiben az oszlopfejléc és a cella közt van egy üres sor. (#5396)
* Microsoft Excel: A fejléc és a tartalom összemosódását elkerülendő mostantól a cellakoordináták bemondása megelőzi a fejlécek bemondását. (#5396)

### Hibajavítások

* Böngészőmódban az egykarakteres gyorsgombok használatakor, az adott dokumentumban nem támogatott elemekre lépés kísérletekor az NVDA már bejelenti, hogy az adott elem nem támogatott, szemben a korábbi nincs előző/következő elem bejelentéssel. (#5691)
* Microsoft Excel: Az elemlistában már megjelennek a kizárólag diagramokat tartalmazó munkalapok is. (#5698)
* Többablakos Java-alkalmazásokban, mint az IntelliJ vagy az Android Studio az NVDA már nem jelent be oda nem illő információkat az ablakok közti váltásnál. (#5732)
* A Scintilla-alapú szerkesztőknél, Mint a Notepad++, a braille már helyesen frissül, amikor egy braille kijelző használatával mozgatják a kurzort. (#5678)
* Az NVDA már nem omlik össze bizonyos esetekben,braille kimenet engedélyezésekor. (#4457)
* Microsoft Word: A bekezdés igazítás mértékét az NVDA most már mindig a felhasználó által beállított mértékegységben jelenti be (pl. centiméter vagy hüvelyk). (#5804)
* Braille kijelzők: Sok korábban csak beszéddel bejelentett NVDA üzenet már megjelenik braille-ben is. (#5557)
* Akadálymentes Java alkalmazások: Az NVDA már bemondja a fanézetelemek szintjét. (#5766)
* Mozilla Firefox: Adobe Flash hibajavítások. (#5367)
* Google Chrome és Chrome-alapú böngészők: Párbeszédpaneleken és alkalmazásokon belül található dokumentumok már olvashatók böngészőmódban. (#5818)
* Google Chrome és Chrome-alapú böngészők: Webes párbeszédpanelek, és alkalmazások esetében már át lehet váltani böngészőmódra. (#5818)
* Internet Explorer és más MSHTML vezérlők: Bizonyos vezérlőkre navigáláskor (konkrétan ahol aria-activedescendant van használatban) már nem vált át az NVDA kéretlenül böngészőmódra. Ez Pl. a Gmail használatakor fordult elő, amikor üzenetírásnál a fókusz a címmezőknél az ajánlott címekre került. (#5676)
* Microsoft Word: Az NVDA már nem fagy le nagyméretű táblázatoknál, ha a táblázat sor/oszlopfejléceinek bemondása opció be van kapcsolva. (#5878)
* Microsoft word: Az NVDA már nem jelent be egy adott vázlatszinttel rendelkező szöveget címsorként,ha nincs a megfelelő beépített stílussal formázva. (#5186)
* Microsoft Word: Böngészőmódban az elemblokk elejére és végére navigáló billentyűparancsok (,(vessző) és  shift+,(vessző)) már táblázatoknál is működnek. (#5883)

## 2016.1

Ebben a kiadásban: Az NVDA-n kívüli hangok lehalkíthatósága; fejlesztések a Braille kimenethez és Braille kijelzőkhöz; számos fontos javítás a Microsoft Office támogatás terén; és a böngészőmód javítása iTunes alatt.

### Újdonságok

* Új braille fordító táblák: lengyel 8 pontos számítógépes braille, mongol. (#5537, #5574)
* Új opciók a Braille kijelző beállításai közt: Most már megváltoztathatja a Braille-kurzor alakját, és ki is kapcsolhatja az új opciók segítségével. Ezek: Mutassa a kurzort, ill. A kurzor alakja. (#5198)
* Az NVDA már Bluetoothon keresztül is képes kapcsolódni egy HIMS Smart Beetle braille kielzőhöz. (#5607)
* Az NVDA képes lehalkítani az NVDA-n kívüli hangokat Windows 8 és újabb verziói esetében. Ez az új, Hangerőigazítás opció beállításával lehetséges, ami az NVDA Beszédszintetizátor beállítási párbeszédpanelén, vagy pedig az NVDA+Shift+D billentyűparanccsal állítható. (#3830, #5575)
* Támogatás a HID módú APH Refreshabraille, a Baum VarioUltra, és Pronto! USB-n csatlakoztatható eszközökhöz. (#5609)
* Támogatás a HumanWare Brailliant BI/B braille kijelzőkhöz nyíltBraille protokol esetén. (#5612)

### Változások

* A Kiemelés jelzése innentől alapértelmezetten ki van kapcsolva. (#4920)
* Microsoft Excel: Az Elemlista párbeszédpanelén a Képletekhez tartozó gyorsbillentyűt megváltoztatták az alt+r billentyűkombinációra, így már különbözik a szűrőmezőhöz tartozó billentyűparancstól. (#5527)
* A Liblouis braille fordítót frissítették a 2.6.5 verzióra. (#5574)
* A "Szöveg" szó már nem hangzik el szöveges elemekre történő navigáláskor, a fókusz és az áttekintő kurzor esetében sem. (#5452)

### Hibajavítások

* iTunes 12: A böngészőmód már helyesen frissül amikor az iTunes Storeban új oldal töltődik be. (#5191)
* Internet Explorer és más MSHTML vezérlők: A meghatározott címsorszinteken történő egykarakteres navigálás ismét az elvártnak megfelelően működik olyankor, amikor a címsor szintjét figyelmen kívül hagyják akadálymentességi megfontolásokból. (Konkrétan az aria-szint erősebb a h-jelölő szintjénél). (#5434)
* Spotify: a fókusz már nem kerül folyton ismeretlen elemekre. (#5439)
* Spotify: A program már helyesen őrzi meg a fókusz legutóbbi helyét egy másik alkalmazásból való visszatéréskor. (#5439)
* A böngészőmód és fókuszmód közti váltást már Braille-ben is bejelenti a program. (#5239)
* A Windows bizonyos verzióiban a tálca Start gombját már nem jelzi az NVDA listaként és/vagy kijelöltként. (#5178)
* Microsoft Outlook: "Beszúrt" és hasonló információs üzeneteket már nem közöl az NVDA üzenetírás közben. (#5486)
* Braille kijelzők: Ha kijelölt szöveg van az aktuális sorban (pl. olyan szöveg keresésekor egy szövegszerkesztőben, ami ugyanabban a sorban található), a braille kijelző továbbgördül, ha szükséges. (#5410)
* Windows 10: Windows parancssor alt+F4 kombinációval történő bezárásakor már nem záródik be az NVDA hangtalanul. (#5343)
* Elemlista böngészőmódban: Amennyiben megváltoztatja az elem típusát a szűrőmező tartalma törlődik. (#5511)
* Mozilla alkalmazások: Szerkeszthető szövegeknél az egérmutató mozgása során ismét a megfelelő sor, vagy szó kerül bejelentésre a szerkesztőmező teljes tartalma helyett. (#5535)
* Mozilla alkalmazások: Szerkeszthető szövegekben az egérmutató mozgása során az olvasás nem áll le olyan elemeknél, mint az épp felolvasott szón, vagy soron belül található hivatkozás. (#2160, #5535)
* Internet Explorer: A shoprite.com weboldal már olvasható böngészőmódban, eddig üresként jelentette be az NVDA. (Konkrétan a hibás nyelvi attribútumok kezelése javult.) (#5569)
* Microsoft Word: A szerkesztői változásokat mint "Beszúrt" az NVDA már csak a szövegszerkesztő korrektúra nézetében mondja be. (#5566)
* Amikor egy többállapotú gomb fókuszba kerül, az NVDA már bejelenti ha az állapota megváltozik lenyomva-ról, nincs lenyomva-ra. (#5441)
* Az egérmutató alakjának megváltozásáról ismét helyesen tájékoztat az NVDA. (#5595)
* Behúzás felolvasása esetén az NVDA a nem törhető szóközöket normál szóközökként kezeli. Ez korábban előidézhette, hogy "szóköz szóköz szóköz" bejelentés hangozzon el a "három szóköz" helyett. (#5610)
* Egy modern Microsoft beviteli módok közti váltást lehetővé tevő lista bezárásakor a fókusz már helyesen visszatér akár a szerkesztéshez,akár a dokumentumhoz. (#4145)
* Microsoft Office 2013 és későbbi verziók: Ha a ribbon eszköztár beállítása szerint csak a füleket mutatja, a ribbon elemeit ismét bejelenti az NVDA, amikor egy fül aktiválva van. (#5504)
* Érintőképernyő: Javítások és fejlesztések az érintési parancsok felismerése terén. (#5652)
* Az érintőképernyő felderítést már nem jelenti be a beviteli súgó. (#5652)
* Microsoft Excel: Az NVDA már megjeleníti az elemlistában az olyan megjegyzéseket is, amik egyesített cellákhoz tartoznak. (#5704)
* Microsoft Excel: Kijavították azt a ritka esetben jelentkező hibát, hogy az NVDA nem olvasta fel bizonyos munkalapok tartalmát a táblázat sor/oszlopfejléceinek bemondása opció bekapcsolt állapotában. (#5705)
* Google Chrome: Kelet-ázsiai karakterek beírásakor a beviteli mezőben történő navigálás már az elvártaknak megfelelően működik. (#4080)
* iTunes: Apple zene keresésekor böngészőmódban az elvártaknak megfelelően frissül a keresési találatokat tartalmazó oldal. (#5659)
* Microsoft Excel: Az új munkalap létrehozására szolgáló billentyűparancs (shift+f11) használatakor a program a fókusz új pozícióját jelenti be, korábban ilyenkor néma maradt. (#5689)
* Javították a Braille kijelző kimenetével kapcsolatos problémákat, amik koreai karakterek beírásakor léptek fel. (#5640)

## 2015.4

Ebben a kiadásban: A Windows 10 kezelésének javítása; Beépülés a könnyű kezelés lehetőségei közé Windows 8 és újabb verziói alatt; Fejlesztések Microsoft Excelhez: A Munkalapok kilistázhatók és átnevezhetők az Elemlistában, navigáció a védett munkalapok zárolt celláin; és a rich text szerkesztés támogatása a Mozilla Firefox, Google Chrome és Mozilla Thunderbird programokban.

### Újdonságok

* Az NVDA már megjelenik a Windows 8 és újabb verziók könnyű kezelés kezelőközpontban. (#308)
* Microsoft Excel: A cellák közti mozgás során az NVDA már automatikusan bejelenti a formázás változásait, amennyiben a Dokumentum formázás párbeszédpanelen a megfelelő opciók be vannak kapcsolva. (#4878)
* A dokumentumformázás párbeszédpanelhez hozzáadták a kiemelés jelzését. Alapértelmezésben ez lehetővé teszi, hogy az NVDA jelezze, hogy kiemelt szöveg van a dokumentumban. Azonban ez egyelőre csak az "em" és "strong'" html jelölők esetén, csak böngészőmódban és csak Internet Explorer, illetve más MSHTML vezérlők esetén működik. (#4920)
* Az NVDA már jelzi a beszúrt és törölt szövegeket böngészőmódban internet explorerben és más MSHTML vezérlőkben, ha a szerkesztői változások jelzése be van kapcsolva. (#4920)
* Microsoft Word: Az Elemlistában a kilistázott szerkesztői változások már több információt tartalmaznak, pl. hogy milyen formázási tulajdonságok változtak. (#4920)
* Microsoft Excel: már az elemlistában is át lehet nevezni és listába lehet szedni a munkalapokat (NVDA+f7). (#4630, #4414)
* Az írásjelkiejtés párbeszédpanelen már meg lehet határozni, hogy az NVDA milyen jeleket küldjön ki közvetlenül a beszédszintetizátornak (például egy szünet beiktatása vagy a kiejtés megváltoztatása. (#5234)
* Microsoft Excel: az NVDA már bejelenti a munkalap készítője által a cellákhoz beállított beviteli üzeneteket. (#5051)
* A Baum Pronto! V4 és VarioUltra braille kijelzők támogatása Bluetooth kapcsolódás esetén. (#3717)
* Mozilla alkalmazások: Rich text szerkesztés támogatása. Pl. Google Dokumentumok Braille támogatással a Mozilla Firefoxban, és HTML szerkesztés a Mozilla Thunderbirdben. (#1668)
* Google Chrome és Chrome-alapú böngészők: Rich text szerkesztés támogatása, mint pl. Google Dokumentumok Braille támogatással. (#2634)
 * Ehhez a Chrome  47 vagy újabb verziója szükséges.
* Microsoft Excel: Böngészőmódban a védett munkalapokon már a zárolt cellákon is lehet navigálni. (#4952)

### Változások

* A Szerkesztői változások jelzése opció innentől alapértelmezés szerint be van kapcsolva az NVDA Dokumentum Formázás párbeszédpanelén. (#4920)
* Microsoft Word: A Szerkesztői változások jelzése opció bekapcsolt állapotában, ha karakterenként navigál, az NVDA már kevesebb információt közöl a változásokról, ami hatékonyabbá teszi a navigációt. A bővebb információk lekérdezésére használja az elemlistát. (#4920)
* A Liblouis braille fordító frissítve a 2.6.4 verzióra. (#5341)
* Számos szimbólum, köztük alapvető matematikai jelek, átkerült a Néhány írásjelszintre, így alapértelmezés szerint bemondásra kerülnek. (#3799)
* Amennyiben a szintetizátor támogatja, a beszédben szünetet iktat be a zárójelek, és a gondolatjel elé. (#3799)
* Szöveg kijelölésekor a kijelölt szöveg bemondása megelőzi a kijelölés, mint állapot bemondását. (#1707)

### Hibajavítások

* Outlook 2010/2013: Jelentős fejlesztés az üzenetlista használatához. (#5268)
* Microsoft Excel: Egy diagramban bizonyos navigációs billentyűk és billentyűparancsok már helyesen működnek. (Pl. a munkalapok közti váltásra szolgáló control+pageUp és control+pageDown) (#5336)
* Javították azon a figyelmeztető párbeszédpanelen a gombok megjelenítését, amely akkor jelenik meg, amikor az NVDA egy újabb verziójáról egy régebbire kívánunk áttérni. (#5325)
* A windows 8-ban és újabb verziókban az NVDA már sokkal gyorsabban indul, ha be van kapcsolva az NVDA automatikus indítása a Windows bejelentkezése után jelölőnégyzet. (#308)
 * Ahhoz, hogy ez a hatás életbe lépjen, ha korábbi NVDA verziókban ez a jelölőnégyzet be volt kapcsolva, az általános beállítások párbeszédpanelen a beállítást ki kell kapcsolni, utána újra be kell kapcsolni.
* Javult az UI automationnal való együttműködés, például intézőben, feladatkezelőben.(#5293)
* Mozilla Firefox és más Gecko-alapú vezérlők: Böngésző,módban az NVDA most már fókusz módra vált csak olvasható rács vezérlőkre navigáláskor. (#5118)
* Az NVDA már "Nincs előző elem" jelzést ad a "Nincs következő elem" jelzés helyett, amikor már nincs több elem az érintőképernyőn balra pöccintgetéskor.
* Az NVDA Beviteli parancsok párbeszédablakán orvosolták a szűrőmezőbe több szó beírásakor fellépő problémákat. (#5426)
* Az NVDA már nem fagy le, amikor USB-n keresztül újra csatlakozik egy HumanWare Brailliant BI/B series kijelzőhöz. (#5406)
* Az összetett karaktereket tartalmazó nyelveknél a betűzés már úgy működik, mint a nagybetűs angol karaktereknél. (#5375)
* Windows 10: Az NVDA már nem fagy le a Start menü előhívásakor. (#5417)
* Skype for Desktop: Az NVDA már helyesen bemondja a korábbi értesítések eltűnése előtt érkező új értesítéseket. (#4841)
* Skype for Desktop 7.12 és újabb verziók: Az értesítések bemondása már helyesen működik. (#5405)
* Az NVDA már helyesen jelenti be a fókuszt helyi menü elhagyásakor bizonyos alkalmazásokban, pl. Jart. (#5302)
* Windows 7 és újabb verziók: Az NVDA ismét bemondja a színeket bizonyos alkalmazásoknál, mint pl. Wordpad. (#5352)
* Microsoft PowerPoint: Szövegszerkesztés közben az enter lenyomása után az NVDA a beírt szöveget már az automatikus felsorolás és számozás következő elemeként fogja bejelenteni. (#5360)

## 2015.3

A 2015.3 verzió újdonságai: a Windows 10 kezdeti támogatása, az egygombos navigációs gyorsbillentyűk kikapcsolásának lehetősége, mely hasznos egyes webes alkalmazásokban, fejlesztések az internet explorerhez, javítások rontott szövegek esetén, ha gépelünk és a braille megjelenítés be van kapcsolva.

### Újdonságok

* Internet Explorer és más MSHTML vezérlők: Helyesírási hibák jelzése a szerkesztőmezőkben. (#4174)
* A korábbináll sokkal több a szövegekben előforduló unicode matematikai jel bemondása. (#3805)
* Windows 10: keresési javaslatok automatikus bemondása a kezdőképernyőn. (#5049)
* Támogatás az EcoBraille 20, EcoBraille 40, EcoBraille 80 és az EcoBraille Plus braille kijelzőkhöz. (#4078)
* Böngészőmód: Az egykarakteres gyorsnavigáció már ki- és bekapcsolható. az NVDA+shift+szóköz billentyűparanccsal. Kikapcsolt állapotban az egykarakteres navigáció billentyűit átadják az alkalmazásnak, ez hasznos lehet bizonyos webes alkalmazások esetében, mintGmail, Twitter és Facebook. (#3203)
* Új braille fordítótáblák: Finn 6 pontos, ír rövidítési fokozat 1, ír rövidítési fokozat 2, koreai rövidítési fokozat 1 (2006), koreai rövidítési fokozat 2 (2006). (#5137, #5074, #5097)
* Papenmeier BRAILLEX Live Plus braille kijelző: a QWERTY billentyűzet már támogatott. (#5181)
* Windows 10: Kísérleti támogatás a Microsoft Edge web böngészőhöz és böngészőmotorhoz. (#5212)

### Változások

* Liblouis braille fordító frissítve a 2.6.3 verzióra. (#5137)
* Az NVDA egy, a telepítettnél korábbi verziójának telepítése esetén a program figyelmeztet, hogy ez nem ajánlott, és a folyamathoz a telepített verzió teljes eltávolítására van szükség. (#5037)

### Hibajavítások

* Internet Explorer és más MSHTML vezérlők: Böngészőmódban az F, űrlapmezők közti navigálásra szolgáló gyorsbillentyűvel már nem lehet listaelemekre navigálni. (#4204)
* Firefox: az NVDA már nem olvassa fel kéretlenül egy ARIA tab panel tartalmát olyankor, amikor a fókusz a belsejébe kerül. (#4638)
* Internet explorerben és más MS-Html vezérlőkben szakaszokra, fejezetekre vagy párbeszédpanelekre lépéskor a program már nem olvassa fel kéretlenül a gyűjtő egész tartalmát (#5021, #5025). 
* A braille kijelzés nem omlik össze a kijelző egy másik gombjának megnyomásakor, ha a Baum/HumanWare/APH braille kijelzőket braille billentyűzettel használjuk (#3541).
* Windows 10: Az NVDA már nem jelent be oda nem tartozó információkat az alt+tab és az alt+shift+tab alkalmazások közti váltásra szolgáló billentyűparancsok használata során. (#5116)
* A beírt szöveg már nem jelenik meg hibásan, ha bizonyos alkalmazásokat, pl. Microsoft Outlookot braille kijelzővel használunk (#2953).
* Internet explorerben és más MS-HTML vezérlőkön böngészőmódban a tartalom már helyesen jelenik meg, ha egy vezérlőelem megjelenik vagy megváltozik és azonnal fókuszba is kerül (#5040).
* A Microsoft Wordben böngészőmódban az egygombos gyors navigációs billentyűk frissítik a braille kijelzőt és az áttekintő kurzort az elvárások szerint (#4968).
* Braille-ben a szükségtelen szóközök már nem jelennek meg a vezérlőelemek folyamatjelzői között vagy után, valamint formázás során (#5043).
* Ha egy alkalmazás túl lassan válaszol és továbblépünk egy másik alkalmazásra, az NVDA válaszideje a legtöbb esetben már sokkal gyorsabb (#3831).
* A Windows 10 tálcaértesítéseit az NVDA az elvárásoknak megfelelően olvassa fel (#5136).
* Egyes UI Automation alapú kombinált listákban az értékek már jól kerülnek felolvasásra ott is, ahol ez nem működött.
* Böngészőmódban webböngészők használatakor a tabbal történő navigáció már az elvártként viselkedik abban az esetben is, ha egy beágyazott dokumentumra kerül a fókusz. (#5227)
* A windows 10 zárolási képernyő már feloldható érintőképernyő használatával is. (#5220)
* Ha windows 7 vagy újabb rendszereken braille kijelzőt használunk, a szöveg már nem jelenik meg hibásan bizonyos alkalmazások, pl. skype-ba vagy wordpadbe való gépeléskor. (#4291)
* Már nem lehet a windows 10 zárolási képernyőjén olvasni a vágólapot, hozzáférni a futó programokhoz az áttekintő kurzorral, megváltoztatni az NVDA beállításait stb. (#5269)

## 2015.2

Ebben a kiadásban: Microsoft Excel diagramok felolvasása, és matematikai tartalmak kezelésének támogatása.

### Újdonságok

* Microsoft Word: Most már lehetséges mondatonként navigálni egy szövegben az alt+lenyíl és az alt+felnyíl billentyűparancsokkal. (#3288)
* Új braille fordító táblák számos indiai nyelvhez. (#4778)
* Microsoft Excel: Az NVDA már bejelenti egy cella tartalmának letakarva, vagy átlóg állapotát. (#3040)
* Microsoft Excel: Már használható az elemlista (NVDA+f7) a diagramok, megjegyzések és  a képletek kilistázására. (#1987)
* Microsoft Excel: A diagramok felolvasása már támogatott. Ehhez ki kell választani az Elemlistából (NVDA+f7) a megfelelő diagramot, majd az egyes adatpontok között a nyílbillentyűkkel lehet navigálni. (#1987)
* A Design Science MathPlayer 4 használatával az NVDA már fel tudja olvasni és képes interaktívan kezelni a webböngészők, a Microsoft Word és a PowerPoint matematikai tartalmait. (#4673)
* Az NVDA Beviteli parancsok párbeszédpanelén lehetővé vált az NVDA minden beállítási párbeszédpaneléhez, és a dokumentum formázási opciókhoz billentyűparancsot, vagy érintési parancsot hozzárendelni. (#4898)

### Változások

* NVDADokumentum formázás párbeszédpanel: Változtak a Listák jelzése, Hivatkozások jelzése, Sorszámok bemondása, és A betűtípus nevének bemondása opciókhoz tartozó gyorsgombok. (#4650)
* NVDA Egér párbeszédpanel: Gyorsgombot rendeltek Az egérmutató mozgásának jelzése hanggal, és A fényerő változtatja az egérmutató hangjának hangerejét opciókhoz. (#4916)
* Jelentősen javult a színek nevének bemondása. (#4984)
* A liblouis braille fordítót frissítették a 2.6.2 verzióra. (#4777)

### Hibajavítások

* Bizonyos indiai nyelveknél már jól működik a betűzés az összetett karakterek esetén is. (#4582)
* Ha a "Karakterek és írásjelek feldolgozása az aktív hangkarakter nyelvén" be van jelölve, az írásjel kiejtés ablakában az NVDA a kiejtés nyelvéhez tartozó beszédhangot használja. Ezen kívül az aktuális ablak címében megjelenik az épp szerkesztés alatt lévő nyelv megnevezése is. (#4930)
* Internet Explorer és más MSHTML vezérlők: A szerkeszthető kombinált listamezőkben, mint pl.: A Google keresési mezőjében a Google weboldalán, a beírt karaktereket már nem hibásan jelenti be az NVDA. (#4976)
* Microsoft Office: A kiválasztott szín nevét már bemondja az NVDA. (#3045)
* A dán braille kimenet ismét működik. (#4986)
* Microsoft PowerPoint: Diavetítés során a PageUp és pageDown billentyűk ismét használhatók az egyes diák közti váltásra. (#4850)
* A Skype for Desktop 7-es és újabb verzióiban a gépelést jelző üzenet bemondásra kerül, ezen felül ha a  fókusz elmozdul nem történik hibaüzenet küldés. (#4972)
* Javítva az a hiba, mely akkor jött elő ha a beviteli parancsok szűrésre szolgáló mezőjébe szimbólumot (pl. zárójel) gépelt be a felhasználó. (#5060)
* Internet explorer és a többi MSHTML kezelő használatakor a g és shift+g lenyomása esetén elérhetőek az Aria img szabály által definiált ábrák is. (#5062)

## 2015.1

A kiadás főbb elemei: böngészőmód a Microsoft Word és Outlook dokumentumokhoz; jelentős fejlesztések a Skype asztali változatának támogatása terén; és fontos javítások a Microsoft Internet Explorer jobb hozzáférhetősége érdekében.

### Újdonságok

* Az Írásjel-kiejtés párbeszédpanelen már van lehetőség új írásjelek hozzáadására. (#4354)
* A Beviteli parancsok párbeszédpanelen az újonnan hozzáadott "Szűrés" mező segítségével mód nyílik csak a megadott szavakat tartalmazó parancsok megjelenítésére. (#4458)
* Mintty: Az NVDA már automatikusan bejelenti az új szövegeket. (#4588)
* Böngészőmódban a keresés párbeszédpanelen lehetővé vált a kis- és nagybetűk figyelembevételével keresni. (#4584)
* Microsoft Word dokumentumok: A böngészőmód bekapcsolásával (NVDA+szóköz) már használhatók a navigációs gyorsbillentyűk (H a címsorokhoz, stb.), és elérhető az elemlista is (NVDA+f7). (#2975)
* Microsoft Outlook 2007 és újabb verziói: A HTML üzenetek olvasása jelentősen javult a böngészőmód automatikus bekapcsolásának köszönhetően. Bizonyos ritka esetekben, ha a böngészőmód mégsem aktiválódna automatikusan ezekhez az üzenetekhez, az NVDA+Szóköz billentyűparanccsal bekapcsolható. (#2975)
* Microsoft Word: Az NVDA automatikusan bejelenti a táblázatok oszlopfejléceit az olyan táblázatok esetében, ahol a készítő beállítja a fejléceket tartalmazó sort a táblázat tulajdonságai közt. (#4510)
 * Az olyan táblázatoknál, ahol a sorok egyesítve vannak ez nem működik automatikusan. Ilyen esetben az NVDA+shift+c billentyűparanccsal manuálisan megadható az NVDA számára az oszlopfejléceket tartalmazó sor.
* Skype asztali változat: Az NVDA már felolvassa az értesítéseket. (#4741)
* Skype asztali változat: Bemondathatók és áttekinthetők a legutóbbi üzenetek az NVDA+control+(számok 0-tól 9-ig) billentyűparancsokkal; pl. NVDA+control+1 a legutóbbi üzenet bemondásához, és NVDA+control+0 a 10. legújabbhoz. (#3210)
* Skype asztali változat: üzenetváltás közben az NVDA bemondja, ha a partner épp üzenetet ír. (#3506)
* Az NVDA már beszéd nélkül is telepíthető a parancssorból, anélkül, hogy a telepítés után elindulna a feltelepített változat. Ehhez az --install-silent parancssori opció szükséges. (#4206)
* Támogatás a Papenmeier BRAILLEX Live 20, BRAILLEX Live és BRAILLEX Live Plus braille kijelzőkhöz. (#4614)

### Változások

* Az NVDA Dokumentum formázás párbeszédpanelén a Helyesírási hibák jelzése opcióhoz gyorsbillentyűt rendeltek (alt+r). (#793)
* Az NVDA már az épp használatban lévő beszédszintetizátor/hangkarakter nyelvét használja a karakterek és írásjelek feldolgozásához (ide értve az írásjelek megnevezését is), attól függetlenül, hogy az automatikus nyelvváltás be van-e kapcsolva. Az opció kikapcsolásához, ezáltal a korábbi viselkedéshez, az NVDA felhasználói felület nyelvének használatához meg kell szűntetni a bejelölést a Beszéd párbeszédpanelen hozzáadott új opciónál: Karakterek és írásjelek feldolgozása az aktív hangkarakter nyelvén. (#4210)
* A Newfon beszédszintetizátor támogatása megszűnt, innentől a Newfon már csak NVDA-bővítményként érhető el. (#3184)
* Az NVDA már csak a Skype asztali változatának 7-es, vagy újabb verzióit támogatja, a korábbiakat már nem. (#4218)
* Az NVDA frissítéseinek letöltése már sokkal biztonságosabb. A frissítéshez már https protokollt használnak, illetve a fájl hash is ellenőrzésre kerül letöltés után. (#4716)
* Az Espeak frissítve az 1.48.04 verzióra. (#4325)

### Hibajavítások

* Microsoft Excel: Az NVDA már helyesen kezeli az egyesített sor- és oszlopfejléceket. Pl., ha az A1 és B1 cellát egyesítjük a B2 cella oszlopfejléce az A1:B1 egyesített cella lesz, szemben a korábbi működéssel, amikor ilyen esetben nem jelentett be fejlécet az NVDA. (#4617)
* Microsoft PowerPoint 2003: Egy szövegdoboz szerkesztése során az NVDA már helyesen olvassa fel az egyes sorok tartalmát. Korábban minden új bekezdés sorát fokozatosan egy-egy karakterrel rövidebbként kezelte az NVDA. (#4619)
* Az NVDA minden párbeszédpanele immár a képernyő közepén jelenik meg a jobb láthatóságot, és használhatóságot szem előtt tartva. (#3148)
* Skype asztali változat: Új partner hozzáadása során az üdvözlő üzenet írása és az üzeneten belüli mozgás már jól működik. (#3661)
* Eclipse IDE: Ha a fókusz egy fa nézetben új elemre mozdul, abban az esetben ha a korábbi elem egy jelölőnégyzet, akkor már nem kerül ez helytelenül bejelentésre. (#4586)
* Microsoft Word Helyesírás-ellenőrzés párbeszédpanel: A következő hiba automatikusan bejelentésre kerül, amennyiben a legutóbbi hibát javítjuk, vagy figyelmen kívül hagyjuk a megfelelő gyorsbillentyűk segítségével. (#1938)
* A szöveg ismét bejelentésre kerül a Tera Term Pro's terminal ablakában és a Balabolka dokumentumaiban. (#4229)
* Internet Explorer és más MSHTML dokumentumok: Egy kereten belül koreai és más kelet-ázsiai nyelveken történő szövegbevitel befejezése után a fókusz már visszatér a szerkesztett dokumentumhoz. (#4045)
* Beviteli parancsok párbeszédpanel: Új billentyűparancs hozzáadása során a billentyűzetkiosztás beállításakor az ESC gomb lenyomása most már helyesen csak a menüt zárja be, és nem az egész párbeszédpanelt. (#3617)
* Egy NVDA bővítmény eltávolítása esetén már törlődik a bővítmény könyvtára az NVDA újraindítása után, eddig ehhez kétszeri újraindításra volt szükség. (#3461)
* Skype asztali változat 7: komoly problémákat orvosoltak. (#4218)
* Skype asztali változat: Üzenetküldés esetén az NVDA már nem olvassa fel kétszer az üzenetet. (#3616)
* Skype asztali változat: Az NVDA már nem olvas fel kéretlenül nagy mennyiségű üzenetet, akár egy egész beszélgetést. (#4644)
* Kijavították azt a hibát, amely miatt bizonyos esetekben az NVDA dátum és idő lekérdezésére szolgáló parancsa nem vette figyelembe a felhasználó területi beállításait. (#2987)
* Böngészőmódban bizonyos ábráknál ( pl. Google csoportoknál) az NVDA már nem olvas akár több sorosra is nyúló értelmetlen szöveget. (Kifejezetten base64 kódolású képek esetében.) (#4793)
* Az NVDA már nem fagy le pár másodperccel azután, hogy a fókusz elmozdul egy Windows Store alkalmazásról. (#4572)
* Mozilla Firefox: Dinamikus területeken a program már figyelembe veszi az aria-atomic attribútumot, még akkor is, ha maga az atomic elem változik. Korábban ez csak a leszármazott elemeket érintette. (#4794)
* Internet Explorer és más MSHTML vezérlők: Böngészőmódú dokumentumba ágyazott ARIA alkalmazáson belül az NVDA már bejelenti a dinamikus területeket, és megjeleníti azok változásait. (#4798)
* Internet Explorer és más MSHTML vezérlők: Dinamikus területeken szöveg hozzáadása, vagy módosítása során a készítő által relevant-ként megjelölt szövegek esetében már csak az újonnan hozzáadott, vagy módosított szövegek fognak elhangozni, és nem az érintett elem teljes szövege. (#4800)
* Internet Explorer és más MSHTML vezérlők: Az egyes elemek aria-labelledby attribútummal megjelölt tartalmai már helyesen, a megfelelő helyen írják felül az eredeti tartalmat. (#4575)
* Microsoft Outlook 2013: Bekapcsolt helyesírás-ellenőrzés esetén az elgépelt szó már felolvasásra kerül. (#4848)

## 2014.4

### Újdonságok

* Új nyelvek: kolumbiai spanyol, pandzsábi
* Most már lehetőség van az NVDA újraindítására szokásos módon, és letiltott bővítményekkel is az NVDA Kilépés párbeszédpanelen. (#4057)
 * Az NVDA a --disable-addons parancssori opcióval is elindítható letiltott bővítményekkel.
* A kivétel szótárakban már megadható, hogy csak a tényleges kifejezés pontos egyezésekor történjen behelyettesítés. Tehát ha a tényleges kifejezés egy hosszabb szó részeként fordul elő, akkor a korábbiakkal ellentétben már ne történjen semmi. (#1704)

### Változások

* Elem navigációval egy böngésző módú dokumentumon kívülről annak egy elemére navigáláskor az áttekintő mód automatikusan dokumentum áttekintésre vált. Korábban ez csak akkor történt meg, amikor a navigátor kurzornál lévő elem változott a fókusz változásával párhuzamosan. (#4369)
* A braille kijelzők, és a beszédszintetizátorok listája a megfelelő párbeszédpanelen már ábécérendbe van rendezve, úgy, hogy a Nincs braille kijelző és a Csendes üzemmód opciók már mindenképpen a lista alján találhatók. (#2724)
* A liblouis braille-fordító frissítve lett a 2.6.0. verzióra (#4434, #3835)
* Böngészőmódban az e és shift+e szerkesztőmezők közti navigálásra szolgáló gyorsbillentyűk már a szerkeszthető kombinált listamezőket is kezelik, ezáltal a Googgle kereső legújabb változatának keresőmezőjét is. (#4436)
* A bal egérgombbal történő kattintás a Windows értesítési területén található NVDA ikonra már megnyitja az NVDA menüjét, korábban ilyen esetben nem történt semmi. (#4459)

### Hibajavítások

* Amikor egy böngésző módú dokumentum visszakapja a fókuszt (pl. alt+tabbal egy már megnyitott weboldal) az áttekintő kurzor már a virtuális kurzorhoz kerül, nem pedig a legközelebbi aktív vezérlőhöz (pl. egy közeli linkhez) (#4369)
* Powerpoint diavetítéseknél az áttekintő kurzor már a virtuális kurzort követi. (#4370)
* Mozilla Firefox és más Gecko-alapú böngészők: Az új tartalmakat a dinamikus területeken az NVDA már akkor is felolvassa, ha az új tartalom ARIA dinamikus típusa eltér a szülő dinamikus terület típusától. Pl. ha assertive megjelölésű tartalmat adnak hozzá polite megjelölésű dinamikus területhez. (#4169).
* Internet Explorer és más MSHTML vezérlők: Egyes esetekben amikor egy dokumentum egy másik dokumentumot tartalmaz, az már nem akadályozza meg a felhasználókat a tartalom bizonyos részeinek elérésében. (Kifejezetten keretkészleteken belüli keretkészletek esetében). (#4418)
* Az NVDA bizonyos esetekben már nem omlik össze a Handy Tech braille kijelző használatakor. (#3709)
* Windows Vista: Számos esetben már nem jelenik meg hibásan a "Belépési pont nem található" párbeszédpanel, pl. amikor az NVDA indítása asztali parancsikonról, vagy billentyűparanccsal történik. (#4235)
* Eclipse legújabb verziói: A párbeszédpaneleken található szerkeszthető szöveges vezérlőkkel kapcsolatos súlyos hibákat javítottak ki. (#3872)
* Outlook 2010: a kurzor mozgása az események, és találkozó felkérések területén már az elvárt módon működik. (#4126)
* Egy dinamikus területen belül a nem dinamikusnak megjelölt tartalmakat (pl. aria-live="off") az NVDA már helyesen kezeli. (#4405)
* Állapotsorról történő szövegfelolvasáskor, ha az adott szöveg névvel is el van látva, akkor már világosan elkülönül a név a szöveg első szavától. (#4430)
* A védett szerkesztőmezőkben beírt szavak bemondása opció bekapcsolt állapotában sem mondja már be az NVDA a helyettesítő karaktereket szavakként új szó kezdésekor. (#4402)
* Microsoft Outlook üzenetlista: az elemeket már nem adatelemekként jelenti be az NVDA. (#4439)
* Eclipse IDE: A kódszerkesztő vezérlőben szöveg kijelölése esetén az NVDA már nem mondja be az egész kijelölést a kijelölés minden változásakor. (#2314)
* Az Eclipse különböző verzióit - mint a Spring Tool Suite és az Android Developer Tools csomagban található verzió - az NVDA már Eclipse-ként azonosítja, és megfelelően kezeli. (#4360, #4454)
* Internet Explorer és más MSHTML vezérlők (beleértve számos Windows 8 alkalmazást is): Az egérmutató követése, és az érintési parancsok is sokkal pontosabban működnek nagy felbontású (magas DPI számmal rendelkező) kijelzőkön, és olyankor is, amikor a dokumentumok nagyítási szintje változik. (#3494) 
* Internet Explorer és más MSHTML vezérlők: Az egérmutató követése és az érintési parancsok használatával is már több gomb címkéje hangzik el. (#4173)

## 2014.3

### Újdonságok

* Az NVDA indításakor, és bezárásakor elhangzó hangjelzés már kikapcsolható az Általános Beállítások párbeszédpanelen elérhetővé vált új opció segítségével. (#834)
* A Bővítménykezelőben elérhető az olyan bővítmények súgója, amelyek támogatják ezt a lehetőséget. (#2694)
* A naptár használatának támogatása Microsoft Outlook 2007 és újabb verzióiban (#2943) Új lehetőségek:
 * Az aktuális idő bemondása nyilakkal történő navigálás során,
 * jelzés, ha a kijelölt időpont egy eseményen belül van,
 * a kijelölt esemény bemondása a tabgomb lenyomásakor
 * Dátumok intelligens szűrése, csak akkor mondja be a dátumot, ha az újonnan kijelölt időpont,vagy esemény eltérő napon van a korábban kielölthöz képest.
* Továbbfejlesztett támogatás a Bejövő üzenetek, és más üzenetlistákhoz az Outlook 2010 és újabb verzióiban (#3834) Új lehetőségek:
 * Lehetőség az oszlopfejlécek bemondásának kikapcsolására (feladó, tárgy, stb.) a táblázat sor/oszlop fejléceinek bemondása opció kikapcsolásával az NVDA dokumentum formázás párbeszédpanelén,
 * Használhatók a táblázat navigációs parancsok (control + nyilak) az egyes oszlopokon belüli mozgásra. 
* Microsoft word: Ha egy beágyazott képhez nem tartozik szöveges leírás, akkor az NVDA inkább a kép címét fogja bejelenteni, amennyiben a szerző azt megadta. (#4193)
* Microsoft Word: Bekezdés igazítás bemondása a formázási információk lekérdezésére szolgáló billentyűparanccsal (NVDA+f), és automatikusan az új, Bekezdés igazítás bemondása opció bekapcsolásával a dokumentum formázás párbeszédpanelen. (#4165).
* Szerkeszthető dokumentumok, és szövegmezők esetében az NVDA már bejelenti az enter billentyű lenyomása után az olyan, automatikusan beillesztett szövegrészeket, mint új felsorolásjel, szám, vagy tabulátor behúzás. (#4185)
* Microsoft word: Az NVDA+alt+c billentyűparancs hatására elhangzik a megjegyzés szövege, amennyiben a kurzor egy megjegyzésen belül áll. (#3528)
* Fejlesztett támogatás az automatikus oszlop-, és sorfejlécek felolvasásához a Microsoft Excelben. (#3568) Beleértve:
 * Az Excelben definiált névtartományok felhasználása a fejlécet tartalmazó cellák megállapításához, (ez kompatibilis a Jaws képernyőolvasóval) 
 * Az oszlopfejlécek  (NVDA+shift+c) és sorfejlécek (NVDA+shift+r) beállítására szolgáló parancsok már elmentik a szükséges információkat a munkalapon, így azok a munkalap későbbi megnyitásakor is elérhetők lesznek az NVDA számára, ill. azon képernyőolvasók számára is, amelyek támogatják a definiált névtartományok ezen rendszerét.
 * Ezek a parancsok most már többször is alkalmazhatók egy munkalapon belül, hogy különböző területekhez különböző fejléceket állítsanak be.
* Automatikus oszlop-, és sorfejlécek felolvasásának támogatása a Microsoft Word-ben (#3110) Beleértve:
 * Az MS Word könyvjelzők felhasználása a fejléc cellák megállapításához. (ez kompatibilis a Jaws képernyőolvasóval)
 * Az oszlopfejlécek  (NVDA+shift+c) és sorfejlécek (NVDA+shift+r) beállítására szolgáló parancsok használata az első fejléc cellákban meghatározza az NVDA számára az automatikusan bejelentendő fejlécek körét. Ezek a beállítások mentésre kerülnek a dokumentumban, így azok a dokumentum későbbi megnyitásakor is elérhetők lesznek az NVDA számára, ill. azon képernyőolvasók számára is, amelyek támogatják a könyvjelzők felhasználásának ezen formáját.
* Microsoft Word: Az NVDA bemondja a lap bal szélétől való távolságot a Tab billentyű lenyomása esetén. (#1353)
* Microsoft Word: beszéd, és braille visszajelzés a legtöbb elérhető formázási gyorsgombhoz (félkövér, dőlt, aláhúzott, igazítás, és vázlatszint). (#1353)
* Microsoft Excel: Ha a fókuszban lévő cella tartalmaz megjegyzéseket, akkor azok már meghallgathatók az NVDA+alt+c billentyűparancs használatával. (#2920)
* Microsoft Excel: Az Excel Shift+F2 megjegyzések szerkesztési módjába váltó billentyűparancsa hatására egy NVDA specifikus párbeszédpanel nyílik meg, ahol a fókuszban lévő cella megjegyzései szerkeszthetők. (#2920)
* Microsoft Excel: Beszéd és braille visszajelzés sokkal több a kijelölést megváltoztató gyorsgombhoz. (#4211) Beleértve:
 * Függőleges lapozás (pageUp és pageDown)
 * Vízszintes lapozás (alt+pageUp és alt+pageDown)
 * A kijelölés kiterjesztése (a fenti gombok a shift billentyűvel együtt történő használatával).
 * Az aktuális terület kijelölése (control+shift+8)
* Microsoft Excel: A cellák függőleges, és vízszintes igazításának bemondása a formázási információk lekérdezésére szolgáló billentyűparanccsal (NVDA+f), és automatikusan, amennyiben az igazítás bemondása opció be van kapcsolva az NVDA dokumentum formázás párbeszédpanelén. (#4212)
* Microsoft Excel: A cellák stílusának bemondása a formázási információk lekérdezésére szolgáló billentyűparanccsal (NVDA+f), és automatikusan, amennyiben a stílus bemondása opció be van kapcsolva az NVDA dokumentum formázás párbeszédpanelén. (#4213)
* Microsoft Powerpoint: Egy dián belül egy alakzat nyílbillentyűkkel történő mozgatása során már elhangzik annak aktuális pozíciója. (#4214) beleértve:
 * Az alakzat távolsága a dia széleitől
 * Ha az alakzat letakar egy másikat, vagy épp takarásba kerül, akkor az átfedő alakzatok távolsága. 
 * Ezek az információk bármikor lekérdezhetők az alakzatok mozgatása nélkül is az elemek pozíciójának lekérdezésére szolgáló billentyűparanccsal (NVDA+numerikus delete)
* Egy másik alakzat által takarásban lévő alakzat kijelölése esetén bejelenti az eltakart állapotot.
 Az elemek pozíciójának lekérdezésére szolgáló billentyűparancs
(NVDA+numerikus delete) bizonyos esetekben már sokkal inkább helyzetspecifikus információkat közöl. (#4219):
 * Szabványos szerkesztőmezőkben, és böngésző módban a kurzor elemen belüli pozícióját százalékban, és a képernyő koordinátáit is bejelenti.
 * Powerpoint bemutatókon bejelenti egy alakzat relatív pozícióját a dián belül, és más alakzatokhoz viszonyítva.
 * A parancs kétszeri lenyomása a korábbi viselkedést eredményezi, az egész objektum elhelyezkedését jelenti be.
 * Új nyelv: Katalán.

### Változások

* A liblouis braille fordítótábla frissült a  2.5.4 verzióra. (#4103)

### Hibajavítások

* A Google Chrome-ban, és a Chrome-alapú böngészőkben, bizonyos hangsúlyos kiemelési kóddal megjelölt szövegrészek már nem ismétlődnek meg egy figyelmeztetés, vagy párbeszédpanel szövegének felolvasásakor. (#4066)
* Ha a mozilla alkalmazásokban böngészőmódban entert nyomunk egy gombon stb., a program már megfelelően aktiválja azt, illetve már nem aktivál rossz vezérlőelemet, mint például bizonyos esetekben, például a Facebook tetején található gomboknál. (#4106)
* Már nem hangoznak el szükségtelen információk, ha az Itunesben a tabbal lépkedünk. (#4128)
* Az Itunes bizonyos listáiban, mint pl. a zenék listája, már megfelelően működik a következő elemre lépés funkciója elem navigációval. (#4129)
* HTML elemek WAI ARIA jelölővel is tekinthetők címsornak, most már részei a böngésző mód elemek listájának, és gyorsnavigációval is kezelhetőek az Internet Explorer dokumentumokban. (#4140)
* Az aktuális Internet Explorer verziókban, böngésző módú dokumentumok esetében az oldalhivatkozások követése már helyesen mozdítja el a fókuszt, és a hivatkozott hely bejelentése is megfelelő. (#4134)
* Microsoft Outlook 2010 és újabb verziói: Fejlesztett hozzáférés az olyan biztonsági párbeszédpanelekhez, mint a profilok, és a fiók beállítások. (#4090, #4091, #4095)
* Microsoft Outlook: Kevesebb felesleges információ hangzik el bizonyos párbeszédpanelek parancs eszköztárain való navigáláskor. (#4096, #3407)
* Microsoft word: egy üres táblázatcellába történő tabos navigálás során az NVDA már nem jelenti be a cellát tévesen a táblázat végeként. (#4151)
* Microsoft Word: A közvetlenül a táblázat után következő első karaktert, beleértve az új üres sort is, Az NVDA már nem jelzi hibásan úgy, minthaaz is a táblázat része lenne. (#4152)
* Microsoft Word 2010 nyelvi ellenőrzés párbeszédpanel: már csak a ténylegesen hibás szót jelenti be az első vastagbetűs szó helyett. (#3431) 
* Böngésző módban az Internet Explorerben és más MSHTML vezérlőkben egy űrlapmezőre lépéskor, akár tabbal, akár navigációs gyorsgombbal, ismét elhangzik annak a címkéje. (Különösen HTML címke elemek használata esetén.) (#4170)
* Microsoft Word: A megjegyzések, és azok helyének bejelentése már sokkal pontosabb. (#3528)
* Fejlesztett navigáció az MS Office termékek bizonyos párbeszédpanelein, (Word, Excel és Outlook). Az NVDA már nem jelenti be az olyan speciális vezérlő tároló eszköztárakat, amelyek a felhasználók számára irrelevánsak. (#4198) 
* Az olyan eszköztárak, mint a vágólap, vagy  a fájl visszaállítás panele a Microsoft word, vagy az Excel megnyitásakor már nem ragadják magukhoz a fókuszt, így a felhasználóknak nem kell a fókuszt áthelyezni, majd visszahozni a programra a dokumentum, vagy a munkafüzet szerkesztéséhez. (#4199)
* Az NVDA már fut az olyan új Windows operációs rendszereken, ahol a felhasználó a Windows nyelvét szerbre (latin) állítja. (#4203) 
* Már nem szükséges az alt billentyű többszöri lenyomása a Microsoft office ribbon első aktiválásához, Office programok (Word, Excel) megnyitása után már aktiválódik. (#4207)
* Beviteli súgó módban a numlock lenyomása már helyesen váltja a viselkedést és már nem okozza a billentyűzet, és az operációs rendszer a kijelzett állapottól eltérő viselkedését. (#4226)
* A Google Chrome-ban a lapfülek között történő váltás során a dokumentumok címe ismét bejelentésre kerül. Az NVDA 2014.2 verziójában bizonyos esetekben ez nem történt meg. (#4222)
* A Google Chrome-ban, és a Chrome-alapú böngészőkben a dokumentumok bejelentése során már nem hangzik el azok URL címe. (#4223)
* Csendes üzemmódban a folyamatos felolvasás már rendesen befejeződik, és nem áll le az első néhány sor után. Ez különösen automatizált tesztelés során hasznos. (#4225)
* Microsoft Outlook Aláírás párbeszédpanel: az aláírás megadására szolgáló szerkesztőmező már akadálymentes, már lehetséges a kurzor teljes körű követése, és a formátum meghatározása. (#3833) 
* Microsoft Word: Egy táblázatcella utolsó sorának olvasása során a program már nem kezdi el felolvasni az egész cella tartalmát. (#3421)
* Microsoft Word: A tartalomjegyzék első, és utolsó sorának olvasása során a program már nem kezdi el felolvasni az egész tartalomjegyzéket. (#3421)
* Az indoárja nyelveken Beírt szavak már nincsenek hibásan tördelve magánhangzó és virama jelnél a beírt karakterek bemondása lehetőség használatakor. (#4254) 
* A GoldWave számbevitelre alkalmas szerkesztőmezői már helyesen működnek. (#670) 
* Microsoft Word: Bekezdésenkénti mozgáskor már nem szükséges kétszer lenyomni a control+lenyíl vagy control+felnyíl billentyűket listák esetén. (#3290)

## 2014.2

### Újdonságok

* A szöveg kijelölések bejelentése már lehetséges néhány olyan egyedi szerkesztőmező esetében, ahol a megjelenő információkat használja az NVDA. (#770)
* Az akadálymentes Java alkalmazásokban az NVDA már bejelenti a választógombok, és más vezérlőelemek pozícióadatait, amennyiben azok rendelkeznek csoportinformációkkal. (#3754)
* Az akadálymentes java alkalmazásokban már elhangoznak a vezérlőelemekhez tartozó gyorsbillentyűk. (#3881)
* Böngészőmódban már elhangoznak a jelzőpontok címkéi. Már az elemlistában is szerepelnek. (#1195)
* Böngészőmódban a megcímkézett területeket már jelzőpontokként kezeli az NVDA. (#3741)
* Az Internet Explorer dokumentumokban, és alkalmazásokban a dinamikus területek (a W3c ARIA szabvány részeként) már támogatottak, ez lehetővé teszi, hogy ezeket a tartalmakat a webszerkesztők úgy jelöljék meg, hogy az NVDA automatikusan bejelentse azok változásait. (#1846)

### Változások

* Egy böngésző módú dokumentumban egy párbeszédpanel, vagy alkalmazás bezárása után már nem hangzik el a böngésző módú dokumentum neve és típusa. (#4069)

### Hiba javítások

* A szabványos Windows rendszer menü már nem hallgat el váratlanul a Java alkalmazásokban. (#3882)
* Szöveg másolása esetén képernyő áttekintés módban a sortörések már nincsenek figyelmen kívül hagyva. (#3900)
* Néhány alkalmazás esetében az NVDA már nem jelent be értelmetlen üres elemeket, amikor változik az aktív elem, vagy elem áttekintésnél egyszerű áttekintés engedélyezése mellett. (#3839)
* Az NVDA saját üzenetpanelei, és más párbeszédpanelei bejelentése előtt a korábbi beszéd ismét megáll.
* Böngészőmódban a vezérlőelemek (hivatkozások, gombok) címkéit már helyesen kezeli az NVDA, olyan esetekben, amikor a címkéket a készítő felülírja akadálymentesítés céljából. (Különösen aria-label és aria-labelledby használatával). (#1354)
* Böngészőmódban az Internet Explorerben a prezentációként megjelölt elemekben (ARIA role="presentation") található szövegek már nincsenek hibásan figyelmen kívül hagyva. (#4031)
* Ismét lehetséges vietnami nyelvű szöveg bevitele az Unikey szoftver használatával. Ehhez meg kell szűntetni a jelölőnégyzet bejelölését az Alkalmazások billentyűleütéseinek kezelése új opciónál az NVDA Billentyűzet beállításai párbeszédpanelén. (#4043)
* Böngészőmódban a választható, és bejelölhető menüelemek már vezérlőelemekként kerülnek bejelentésre, és nem csak kattintható szövegként. (#4092)
* Az NVDA már nem vált hibásan interaktív módból böngésző módba, amikor egy választható, vagy bejelölhető menüelem kerül fókuszba. (#4092)
* A Microsoft PowerPoint-ban a beírt szavak bemondása gépeléskor funkció bekapcsolt állapotában a backspace-szel kitörölt karaktereket az NVDA már nem jelenti be a begépelt szó részeként. (#3231)
* A Microsoft Office 2010 Beállítás párbeszédpanelein a kombinált listamezők címkéi már helyesen vannak bejelentve. (#4056)
* Böngészőmódban a Mozilla alkalmazásokban, a gombok, és űrlapmezők közti mozgásra szolgáló navigációs gyorsbillentyűkkel már a többállapotú gombok is kezelhetők, mint  ahogy az elvárható. (#4098)
* AMozilla alkalmazásokban a figyelmeztetések tartalma már nem kerül kétszer bejelentésre. (#3481)
* Böngészőmódban az NVDA már nem ismétli meg kéretlenül a tárolók és jelzőpontok tartalmát olyan esetben, amikor a bennük való navigálás közben a weboldal tartalma frissül. Például a Facebook, és a twitter weboldalak böngészésekor. (#2199)
* Az NVDA több esetben helyreáll, amikor egy lefagyott alkalmazásból kikerül a fókusz. (#3825)
* A beszúrási kurzor most már helyesen frissül folyamatos felolvasás közben olyan szerkesztőmezők esetén, melyek közvetlenül a képernyőre lettek rajzolva. (#4125)

## 2014.1

### Újdonságok

* A Microsoft PowerPoint 2013 program támogatása. Megjegyzés: A védett nézet nem támogatott (#3578)
* A Microsoft word és Excel programok esetén az NVDA fel tudja olvasni a kijelölt szimbólumot a szimbólum beszúrása párbeszédpanelen. (#3538)
* Új opció a dokumentum formázás párbeszédpanelen, most már állítható a Kattinthatóként azonosított tartalmak jelzése a dokumentumokban. Ez az opció alapértelmezés szerint be van kapcsolva összhangban a korábbi viselkedéssel. (#3556)
* A Bluetooth-on keresztül csatlakozó Braille kijelzők támogatása a Widcomm Bluetooth szoftvert futtató számítógépeken. (#2418)
* Ha a Powerpointban szerkesztünk szöveget, a program felolvassa a hivatkozásokat. (#3416)
* Egy ARIA alkalmazásban, vagy webes párbeszédpanelen lehetőségünk van böngészőmódra való váltásra az NVDA gomb + szóköz lenyomásával. Ekkor a dokumentumnavigációt tudjuk használni az adott alkalmazás, vagy a párbeszédpanel bejárására. (#2023)
* Az Outlook Expressben, Windows Mail-ben és Windows Live Mailben az NVDA már felolvassa, ha egy üzenetnek melléklete van, vagy ha az meg van jelölve. (#1594)
* Az akadálymentes Java alkalmazásokban már elhangoznak a táblázatok sor és oszlop koordinátái, és a sor és oszlop fejlécek (amennyiben elérhetőek). (#3756)

### Változások

* A Papenmeier braille kijelzők használata esetén a sík áttekintő módba lépésre szolgáló billentyűparancs eltávolításra került. A felhasználók hozzárendelhetik a kijelző billentyűit a beviteli parancsok párbeszédablakában. (#3652)
* Az NVDA már a Microsoft VC runtime 11 verzióra támaszkodik, ami azt jelenti, hogy már nem futtatható Windows XP Service Pack 2, vagy Windows Server 2003 Service Pack 1 verziónál régebbi operációs rendszereken.
* A "Néhány írásjel" szinten  már bemondásra kerülnek a csillag (*) és plusz (+) karakterek. (#3614)
* Az eSpeak frissült az 1.48.02 verzióra, ami számos nyelvi és egyéb hibajavítást tartalmaz. (#3842, #3739)

### Hiba javítások

* A Microsoft Excelben, ha cellák közt navigálunk, vagy cellákat jelölünk ki, az NVDA már helyesen az új értékeket jelenti be, amikor az Excel lassan reagál a kijelölés elmozdulására. (#3558)
* A Microsoft Excelben az NVDA megfelelően kezeli a legördülő lista megnyitását a cellákhoz a felugró menüből. (#3586)
* Az iTunes 11 áruház oldalainak tartalma mostmár helyesen, böngészőmódban jelenik meg, amennyiben egy hivatkozást követve megnyitjuk azokat, vagy belépünk az áruházba. (#3625)
* Az iTunes 11 áruházban a dalokba való belehallgatásra szolgáló gombok címkéi már megjelennek böngésző módban. (#3638)
* A Google Chrome-ban böngészőmódban a jelölőnégyzetek és választógombok címkéit a program most már helyesen rendezi el. (#1562)
* Az Instantbird programban az NVDA már nem mond be használhatatlan információkat akkor, amikor egy partnerre navigálunk a partnerlistán. (#2667)
* Az NVDA az adobe Reader programban böngészőmódban most már helyesen társítja a megfelelő szöveget az adott gombhoz még akkor is, ha a címkét egy eszköztipp vagy más hasonló szöveg írja felül. (#3640)
* Az Adobe Reader programban a program böngésző módban már nem rendereli a "mc-ref" szöveget tartalmazó ábrákat. (#3645)
* Az NVDA most már nem olvassa az Excelben az összes cella formázását aláhúzottnak. (#3669)
* Böngészőmódban az NVDA már nem mutatja a dokumentum jelentéssel nem bíró karaktereit, mint pl. az unikód kódtábla priváthasználatú blokkjainak karakterei. Néhány esetben ezek meggátolták azt, hogy fontos üzenetek jelenjenek meg. (#2963)
* A kelet-ázsiai karakterek bevitele már nem okoz hibát a PuTTY programban. (#3432)
* A megszakított folyamatos felolvasás után való dokumentum-navigáció már nem eredményezi azt, hogy az NVDA bejelenti egy mezőből való kilépést (mint pl. táblázatok esetében), holott a folyamatos felolvasás ezeket nem jelenti be. (#3688)
* Az NVDA most már sokkal pontosabban jelenti be az egyes vezérlőelemeket amikor böngészőmódban folyamatos átfutó olvasásnál a dokumentum-navigációs parancsokat használjuk. (Vagyis most már a címsor esetében címsort mond és nem azt, hogy "szöveg".) (#3689)
* Az elejére vagy végére ugrató navigációs parancsok most már figyelembe veszik az átfutó folyamatos felolvasás beállítást. (Vagyis nem szakítják meg a felolvasást.) (#3675)
* A használható gesztusok felhasználóbarát elnevezéseket kaptak és a gesztusok listájában az NVDA nyelvén olvashatók. (#3624)
* Az NVDA már nem okozza több program összeomlását, abban az esetben, ha az egér a RichhhEdit (TRichEdit) vezérlőelem felett mozog. Azokról a programokról van szó, melyek a Jarte 5.1 és a BRfácil-t használják. (#3693, #3603, #3581)
* Az Internet  Explorerben, vagy más MSHTML vezérlőelemekben, a konténerek, mint pl. az ARIA által prezentációként megjelölt táblázatok nem kerülnek bejelentésre. (#3713)
* Microsoft Word, az NVDA már nem ismétli meg kéretlenül egymás után többször egy táblázat cellájának sor-, és oszlopinformációit egy braille kijelzőn. (#3702)
* Az NVDA már nem olvassa különálló számként a számokat az olyan nyelvekben (mint pl. a francia és a német), amelyekben az ezres elválasztó a szóköz. Ez korábban főleg olyan táblázatoknál jelentett problémát, amelyekben számokat tartalmaztak a cellák. (#3698)
* A braille kijelző mostmár minden esetben megfelelően frissül, ha Word 2013-ban a rendszerkurzort mozgatjuk. (#3784)
* A braille kijelzőről nem tűnik el a címsorszint azonosító szövege amennyiben a Microsoft Word programban a kurzort a címsor első karakterére mozgatjuk. (#3701)
* Ha egy alkalmazáshoz felhasználói profilt társítottunk, és az alkalmazás kilépett, az NVDA most már minden esetben kikapcsolja az alkalmazás profilját. (#3732)
* Amennyiben az NVDA-ban magában ázsiai karakterbevitelt használunk (mint pl. böngészőmódban a keresőmezőbe való beíráskor), az NVDA már  helyesen jelenti be a karakter alkotóelemeinek helyzetét. (#3726)
* Az NVDA most már felolvassa az Outlook 2013 programban a Beállítások párbeszédpanel lapfüleit. (#3826)
Továbbfejlesztett ARIA dinamikus régió támogatás a Firefoxban és más Mozilla Gecko alkalmazásokban:
* Támogatja az ARIA elemi frissítéseket, valamint az "aria-busy" típusú frissítések szűrését  (#2640)
* Amennyiben nincs használható szöveg, úgy képes az ALT tulajdonság, vagy ARIA címke alapján alternatív szöveg létrehozására. (#3329)
* Az ARIA dinamikus régió frissítések, amenyiben a fókusz elmozdulásakor   történnek, már nem némák. (#3777)
* A Firefoxban és más Mozilla Gecko alkalmazásban néhány bemutatóelem már helyesen jelenik meg böngészőmódban, különösen akkor, ha bár ARIA prezentációként van jelölve, mégis képes a fókusz fogadására. (#3781)
* Bekapcsolt helyesírás ellenőrzés esetén javult az NvDA teljesítménye a word dokumentumokban való navigáláskor. (#3785)
Különböző, az akadálymentes Java alkalmazásokat érintő hibajavítások:
* Egy vezérlőelem-csoport vagy párbeszédpanel először fókuszba kerülő vezérlőelemének bejelentése nem marad el, ha az adott csoport, vagy párbeszédpanel előtérbe kerül. (#3753)
* A választógombok értelmetlen helyzetinformációi (mint pl. 1/1,) nem kerülnek bejelentésre. (#3754)
* A JComboBox  vezérlőelem jobb bejelentése. (A HTML már nem kerül bejelentésre, viszont pontosabban jelenti be a lista lenyitott és becsukott állapotát. (#3755)
* A párbeszédpanelek szövegének felolvasásakor több, eddig elhallgatott szöveget is bejelent az NVDA. (#3757)
* Az aktív vezérlőelem nevében, értékében, leírásában beálló változásokat az NVDA sokkal pontosabban jelenti (#3770)
* Ki Lett javítva az a hiba, Mely akkor okozta AZ NVDA összeomlását Windows 8 Alatt, ha Nagy menyiségű szöveget tartalmazó RichEdit vezérlőelem került a fókuszba. (Mint pl.: NVDA naplónéző, windbg). (# 3867)
* Az NVDA most már nem mozgatja hibás pozícióba az egeret, amennyiben magas DPI felbontással használjuk a monitort. (#3758, #3703)
* Ki lett javítva egy webböngészés közben, alkalmanként jelentkező probléma, mikoris az NVDA megfelelő működése leállt, és újra kellett indítani a programot, bár az nem fagyott le (#3804)
* Használható a Papenmeier braille kijelző abban az esetben is, ha a Papenmeier kijelző még nem volt usb-n csatlakoztatva. (#3712)

## 2013.3

### Újdonságok

* A Microsoft Word dokumentumokban az űrlapmezők már felolvasásra kerülnek. (#2295)
* Az NVDA képes jelezni a dokumentumban történt változásokat (ha ez engedélyezve van a Microsoft Word programban). Alapértelmezetten ezt az NVDA nem jelzi, bekapcsolni a Dokumentum formázás párbeszédpanelen lehet a szerkesztői változások jelölőnégyzet bepipálásával. (#1670)
* A legördülő listákat már jól kezeli az NVDA a Microsoft Excel 2003-2010 verziójú programokban. (#3382)
* Az átfutás engedélyezése a folyamatos felolvasáskor funkció használatakor lehetőség van a gyors navigációs billentyűkkel mozogni a dokumentumban úgy, hogy a felolvasás nem áll le. Alapértelmezetten ez a funkció ki van kapcsolva, bekapcsolható a billentyűzet beállítások párbeszédpanelén. (#2766) 
* Mostantól megváltoztathatóak az NVDA parancsai a beállítások - beviteli parancsok párbeszédpanelén. (#1532)
* Készíthet különböző szituációkhoz különböző beállításokat a profilok létrehozásával. Ezek kézzel is, de akár egy program fókuszba kerülésével is aktiválhatók. (#87, #667, #1913)
* Ha a Microsoft Excel cellájában link található, az mostantól hivatkozásként kerül bemondásra. (#3042)
* A Microsoft Excel programban, ha egy cellához tartozik megjegyzés, akkor ez bemondásra kerül. (#2921)

### Hiba javítások

* A Zend Studio mostantól ugyanúgy működik mint az Eclipse. (#3420)
* A Microsoft Outlook 2010-ben az üzenetszabály párbeszéd ablakán a változó állapotú jelölőnégyzetek már automatikusan elhangoznak. (#3063)
* Az NVDA már jelzi a rögzített állapotot az olyan rögzített vezérlőelemek esetében, mint például a lapfüleknél a Mozilla Firefoxban. (#3372)
* Most már lehetőség van a scriptekhez olyan billentyűparancsokat hozzárendelni, amelyek az Alt, és/vagy a Windows billentyűt tartalmazzák módosítóbillentyűként. Korábban egy ilyen script futtatása a Start menü, vagy a menüsor aktiválódását okozhatta. (#3472)
* A szöveg kijelölése böngésző módú dokumentumok esetében (pl.: ctrl+shift+end billentyűparanccsal) már nem okozza   a billentyűzetkiosztás megváltozását az olyan rendszerek esetében, ahol többféle billentyűzetkiosztás van telepítve. (#3472)
* Az Internet Explorer már nem omlik össze, már nem válik használhatatlanná az NVDA bezárásakor. (#3397)
* Physical movement and other events on some newer computers are no longer treated as inappropriate key presses. Previously, this silenced speech and sometimes triggered NVDA commands. (#3468)
* Az NVDA már az elvárt módon viselkedik a Poedit 1.5.7. verziójában, a korábbi verziókkal dolgozó felhasználóknak frissiteniük kell a szoftverüket. (#3485)
* Az NVDA már tudja olvasni a védett dokumentumokat a Microsoft Word 2010-ben,  már nem okozza a Microsoft Word összeomlását. (#1686)
* Ha az NVDA nem létező parancsori argumentumot kap az indításkor, már nem jelenik meg végtelenszer az ezt jelző hibaüzenet ablak. (#3463)
-Az NVDA már felolvassa a beágyazott objektum alt szövegét a Microsoft Word alkalmazásban akkor is, ha ez idézőjelet vagy egyéb nem szabványos karaktert tartalmaz. (#3579)
* Az elemek száma bizonyos vízszintes listák esetében böngésző módban már helyesen van jelezve. Korábban ez a valós érték duplája is lehetett. (#2151)
* A control+a billentyűparancs használatakor egy Microsoft Excel munkalapon már az új kijelölés van jelezve. (#3043)
* Az NVDA már helyesen olvassa az XHTML dokumentumokat a Microsoft Internet Explorer programban és más MSHTML vezérlőkben. (#3542)
* Billentyűzet beállítások párbeszédpanel: Amennyiben nincs kiválasztva az NVDA gombként használni kívánt billentyű, egy hibaüzenet figyelmezteti a felhasználót a párbeszédpanel elhagyásakor. Legalább egy billentyűt ki kell választani az NVDA rendeltetésszerű használatához. (#2871)
* A Microsoft Excel programban az NVDA most már egymástól megkülönböztetve jelzi az egyesített cellákat és az együttesen kijelölt cellákat. (#3567)
* A böngészőód kurzora most már jó helyre kerül egy a dokumentum belsejében található alkalmazás, vagy párbeszédablakból való visszalépéskor. (#3145)
* Javításra került az a hiba, ami miatt Egyes konfiguráción nem jelent meg a HumanWare Brailliant BI/B series braille kijelző a Braille beállítások párbeszédablakában.

## 2013.2

### Újdonságok

* A Chromium beágyazott keretrendszer támogatása, mely egy webböngésző-vezérlő (/ böngészőmotor /), ezt sok alkalmazás használja. (#3108)
* Új eSpeak hangváltozat: Iven3.
* A Skype-ban a program automatikusan felolvassa az új chatüzeneteket, ha a beszélgetésablak aktív. (#2298)
* A Tween támogatása: beleértve a fülek nevének felolvasását, valamint kevesebb beszédet a bejegyzések felolvasásakor.
* Tiltható az NVDA üzeneteinek a braille kijelzőn történő megjelenítése a braille beállítások párbeszédpanelen az "üzenet megjelenítésének időtartama másodpercben"  szerkesztőmezőben 0 másodperc megadásával. (#2482)
* A bővítménykezelőbe beépítették a "bővítmények beszerzése" gombot, mely megnyitja az NVDA bővítmények weboldalát, ahol megtekinthetők és ahonnan letölthetők az elérhető bővítmények. (#3209)
* Az NVDA üdvözlő képernyőjén, mely az NVDA első indításakor mindig megjelenik, most már beállítható, hogy az NVDA induljon el automatikusan a Windowsba történő bejelentkezés után. (#2234)
-  Az NVDA automatikusan alvó módba kapcsol Dolphin Cicero használatakor. (#2055)
* Az NVDA már támogatja a Miranda IM/Miranda NG Windows x64 alatt futó verzióját. (#3296)
* Az NVDA már automatikusan felolvassa a Windows 8.1 kezdőképernyőjén a keresési javaslatokat. (#3322)
* Az NVDA már támogatja Microsoft Excel 2013-ban a táblázatok / munkalapok szerkesztését és a rajtuk történő tájékozódást. (#3360)
* A Freedom Scientific Focus 14 Blue és Focus 80 Blue braille kijelzőket, akárcsak a Focus 40 Blue kijelzőt, az NVDA most már megfelelően támogatja. Korábban ezeknél a kijelzőknél bizonyos konfigurációknál előfordult, hogy bluetooth kapcsolat esetén az NVDA nem kezelte őket megfelelően. #3307)
* Az automatikus kiegészítés javaslatait az NVDA már felolvassa az Outlook 2010-ben. (#2816)
* Új braille fordítási táblák kerültek a programba: egyesült királyságbeli 2. fokozatú angol számítógépi braille, koreai 2-es fokozat, orosz braille számítógépi kódokhoz.
* Új nyelv: Farsi.

### Változások

* Érintő képernyőn az egy ujjas balra-jobbra pöccintés elemmód használatakor már az összes elem között mozog, nem csak az azonos szinten lévő között. Használja a két ujjas jobra-balra pöccintést az azonos szinten lévő elemek közötti mozgáshoz.
* A böngészőmód beállításaiban a Report layout tables jelölőnégyzet átnevezésre került rétegződő táblázatokra, mert így egyértelműbbé vált, hogy a gyors navigáció nem érzékeli ezeket, ha a jelölőnégyzet nincs bejelölve. (ez a magyar fordításban semmilyen változást nem eredményezett). (#3140)
* A sík áttekintést felváltották a dokumentum, elem és képernyőmódok. (#2996)
 * Az elemmód a navigátor kurzornál lévő elemet, a dokumentummód (ha ez elérhető) a böngészőmódban hozzáférhető szövegeket, a képernyőmód pedig az alkalmazás teljes képernyőjét mutatja.
 * Az eddigi sík áttekintésre használatos billentyűparancsok mostantól ezek között a módok között váltanak.
 * A navigátor kurzor automatikusan követi az áttekintő kurzort, úgy hogy az a legbelső objektumban maradjon dokumentummód és képernyőmód használatakor.
 * Képernyőmódra váltás után az NVDA ott fog maradni mindaddig, amíg vissza nem vált dokumentum vagy elemmódra.
 * ha dokumentum vagy elemmódban van, az NVDA automatikusan vált a két mód között attól függően, hogy az böngészőmódban olvasható-e vagy sem.
* A liblouis braille translatort a 2.5.3 verzióra frissítették. (#3371)

### Hibajavítások

* Egy elem aktiválásakor a művelet bemondása az aktiválás előtt történik, nem pedig utána, ahogyan az korábbi verziók esetén történt. Így mindig az elvégzett művelet neve hangzik el, nem pedig az elvégzés után elérhető művelet (pl. egy fanézet elemének kiterjesztésekor). (#2982)
* Hatékonyabb navigálás és felolvasás újabb Skype verziók szerkesztőmezői esetén, mint pl. a keresés és a chat. (#1601, #3036)
* Az NVDA már bemondja az elérhető új eseményeket a Skype korábbi beszélgetések listájában. (#1446)
* Hatékonyabb kurzor követés és olvasási sorrend megállapítás a képernyő jobbról balra írt szövegei esetén (pl. arab szövegek szerkesztésekor a Microsoft Excel programban). (#1601) 
* Gombokhoz, ill. űrlapmezőkhöz történő gyorsnavigáláskor az NVDA már helyesen határozza meg azokat a hivatkozásokat, melyek gombokként vannak megadva Internet Explorer esetén. (#2750)
* Böngésző módban a fanézetek elemeit már nem dolgozza fel a program, mivel az elemek síkbéli nézete nem használható. Nyomja meg az enter billentyűt a vezérlőelem interaktív módban történő hozzáféréséhez. (#3023)
* Az alt+le vagy alt+fel nyíl billentyűkombinációk, melyek egy kombinált listamezőt nyitnak vagy csuknak be, már nem váltanak interaktív módból böngésző módba. (#2340)
* Az Internet Explorer 10 program táblázatainak cellái már nem aktiválják az interaktív módot, hacsak azok nem rendelkeznek webszerkesztő által meghatározott fókuszálható tulajdonsággal. (#3248)
* Az NVDA most már helyesen elindul ha a rendszeridő régebbi, mint az utolsó frissítés ellenőrzésének ideje. (#3260)
* Ha egy folyamatjelző látható Braille kijelzőn, a kijelző helyesen frissül annak megváltozásakor. (#3258)
* Mozilla alkalmazások használatakor böngésző módban a táblázatok feliratai már nem jelennek meg kétszer. A táblázatok összegzése most már akkor is megjelenik, ha a táblázatok feliratot tartalmaznak. (#3196)
* A Beviteli nyelv megváltoztatása esetén az NVDA már a jelenlegi nyelv nevét olvassa fel, az előző helyett Windows 8 használatakor.
* Az NVDA már felolvassa az IME átalakítási módjait Windows 8 operációs rendszer használatakor.
* Az NVDA már nem mond be értelmetlen szöveget az asztalon, amikor a Google japán vagy Atok IME beviteli műveleteket használjuk. (#3234)
* Az NVDA már nem tekinti billentyűzet nyelvváltásnak a beszédfelismerési vagy az érintési bevitelt Windows 7 és újabb operációs rendszereken.
* Az NVDA már nem mond be egyes szerkesztőmezőkben egy speciális karaktert (0x7f) control+backspace lenyomása esetén. (#3315)
* Az espeak már nem változtat hangmagasságot, hangerőt, stb, egyes vezérlőkarakterek vagy XML felolvasásakor. (#3334) (a #437 változásai miatt)
* A fókuszban lévő vezérlőelem címkéjének, vagy értékének változásakor ezek automatikusan elhangzanak, majd a későbbi vezérlőelem lekérdezéskor helyesen jelennek meg a Java alkalmazásokban. (#3119)
* A Scintilla vezérlőelem sorai már helyesen hangzanak el ha a sortörés engedélyezve van. (#885)
* A csak olvasható listaelemek neve már helyesen hangzik el Mozilla alkalmazások használatakor (pl. tweetek közötti navigáláskor interaktív mód esetén a twitter.com oldalon). (#3327)
* A Microsoft Office 2013 megerősítő párbeszédpaneljeinek szövege most már automatikusan elhangzik.
* Hatékonyabb működés egyes táblázatok navigálásakor a Microsoft Word programban. (#3326)
* Az NVDA táblázat navigációs parancsai (control+alt+nyilak) hatékonyabban működnek egyes Microsoft Word táblázatok esetén, ahol a cellák több sorban helyezkednek el.
* Ha a bővítménykezelő már nyitva van, újbóli megnyitása (az eszközök menü vagy egy kiegészítő megnyitásával) már nem okoz hibát vagy teszi bezárhatatlanná a bővítménykezelő ablakot. (#3351)
* Az NVDA már nem fagy le egyes párbeszédpaneleken, ha japán vagy kínai Office 2010 IME van használatban. (#3064)
* A szóköz karakterek már nem tömörítődnek össze egy szóköz karakterré braille kijelzőkön. (#1366)
* A Zend Eclipse PHP Developer Tools már ugyanúgy működik, mint az Eclipse alkalmazás. (#3353)
* Már ismételten nem szükséges megnyomni a Tab billentyűt a beágyazott objektumok (pl. flash tartalom) hozzáféréséhez az enter billentyű megnyomása után az Internet Explorer programban. (#3364)
* Szöveg szerkesztésekor ha az utolsó sor üres, már nem hangzik el a felette lévő sor a Microsoft PowerPoint programban. (#3403)
* Az elemek már nem hangzanak el kétszer kijelöléskor, vagy szerkesztéskor a Microsoft PowerPoint programban. (#3394)
* Az NVDA már nem okozza az Adobe Reader lefagyását, vagy összeomlását egyes hibásan elkészített PDF dokumentumok esetén, ahol táblázatsorok a táblázaton kívül is szerepelnek. (#3399)
* Az NVDA már helyesen felismeri a fókuszban lévő következő diát a Microsoft PowerPoint mozaik nézetében egy dia törlésekor. (#3415)

## 2013.1.1

### Hiba javítások

* Gépeléskor már helyes betűk jelennek meg az NVDA saját felhasználói felületében, alapértelmezett Kóreai, vagy Japán beviteli nyelv esetén. (#2909)
* Az Internet Explorer és egyéb MSHTML vezérlők érvénytelen bevitelnek jelölt mezői már megfelelően működnek. (#3256)

## 2013.1

E kiadás főb újdonságai: egy sokkal eredetibb és logikusabb laptop billentyűzetkiosztás; a Microsoft Powerpoint alapvető támogatása; a hosszú leírások támogatása a webböngészőkben; valamint a számítógépes braille bevitel támogatása azoknál a braille kijelzőknél, melyeknek van braille billentyűzetük. 

### Fontos

#### Új Laptop Billentyűkiosztás

A laptop billentyűkiosztást teljesen újratervezték, hogy az minél kézreállóbb és logikusabb legyen.
Az új kiosztásban a nyilakat az NVDA és más módosító billentyűk kombinációjával kell használni az áttekintő parancsokhoz.

Kérjük, vegye figyelembe a változásokat a gyakran használt parancsoknál:

| Funkció |Billentyűparancs|
|---|---|
|Folyamatos felolvasás |NVDA+a|
|Sor felolvasása |NVDA+l|
|Kijelölt szövegrész felolvasása |NVDA+shift+s|
|Állapotsor felolvasása |NVDA+shift+end|

Ezzel összefüggésben más is változott, pl. az elemek közötti navigáció, az áttekintő kurzor, az egérkattintás, valamint a szintetizátor beállítási kör. 
Kérjük, tanulmányozza a billentyűparancsok jegyzékét (keycommands.html) az új billentyűparancsok elsajátításához!

### Újdonságok

* A Microsoft Powerpoint prezentációk szerkesztésének alapvető támogatása (#501),
* Üzenetek írásának és olvasásának alapvető támogatása a Lotus Notes 8.5-ben (#543)
* Böngészőmódban MS-HTML (pl. IE) és Gecko (Pl. Firefox) dokumentumokban az NVDA jelzi a hosszú leírásokat. Ezek külön ablakban is megnyithatók az NVDA+D billentyűparanccsal. (#809)
* Az internet explorer 9-ben és újabb verzióiban az NVDA most már felolvassa az értesítéseket (Pl. tartalom blokkolása vagy fájl letöltése). (#2343)
Az IE-ben és más MS-html vezérlőkön az NVDA már automatikusan felolvassa a sor- és oszlopfejeket. (#778)
* Új nyelv: Aragóniai
* Új Braille fordítótáblák: Dán 2. fokozat, Koreai 1. fokozat.(#2737)
* Bluetoothos braille kijelzők támogatása bluetooth kapcsolaton keresztül olyan gépeken, melyek a Toshiba által fejlesztett Bluetooth Stack for Windows szoftvert / drivert futtatják. (#2419)
* A portkijelölés támogatása Freedom Scientific-féle braille kijelzőkön (automatikus, usb vagy bluetooth).
* Papenmeier BRAILLEX braille kijelzők régebbi modelleinek támogatása (#2679).
* Számítógépes braille bevitel támogatása olyan braile kijelzőknél, melyeknek saját braille billentyűzetük van.(#808)
* A Humanware BrailleNote sorozat kijelzőinek támogatása, ha azok braille terminálként viselkednek képernyőolvasók használatakor. (#2012)
* Új billentyűzet-beállítások, melyek segítségével meghatározható, hogy az NVDA a beszédet megszakítsa-e billentyűleütéskor, illetve az enter használata során(#698).
* A program támogatja Google Chrome alapú böngészőket, pl. Rockmelt, BlackHawk, Comodo Dragon and SRWare Iron. (#2236, #2813, #2814, #2815)

### Változások

* Frissítették a Lib-Louis braille fordítót a 2.5.2. verzióra (#2737).
* A laptop billentyűkiosztást teljesen újratervezték, hogy az minél magától értetődőbb és logikusabb legyen. (#804)
* Az eSpeak beszédszintetizátor frissítve lett az 1.47.09-es verzióra. (#2680, #3124, #3132, #3141, #3143, #3172)

### Javítások

* Most már rendesen működik az előző és következő elválasztóra ugró navigációs gyorsbillentyű az internet explorerben és más MS-Html vezérlőkben.(#2781)
* Ha az NVDA egy hibás szintetizátor-beállítás miatt az Espeak-ez térne vissza vagy beszéd nélkül indulna, most már nem menti el a program a hibás beállítást, hanem a legközelebbi indításakor megpróbál visszatérni az eredetileg beállított beszédszintetizátorhoz. (#2589)
* Mozilla alkalmazásokban a táblázatok frissülésekor az NVDA most már helyesen rendezi el őket. Pl. helyesen olvassa fel a táblázatcellák sor- és oszlopkoordinátáit, és úgy működnek a táblázat-navigációs parancsok is, ahogy megszoktuk. (#2784)
* Böngészőmódban a webböngészőkben bizonyos kattintható címkézetlen ábrák, melyek korábban nem voltak jól megjeleníthetők és kezelhetők, most már megfelelően használhatók. (#2838)
* Most már a program egyaránt támogatja a biztonsági képernyők régebbi és újabb verzióit. (#2800)
* Az NVDA most már nem omlik össze induláskor ha egy bővítmény azért nem távolítható el, mert a mappáját egy másik folyamat használja. (#2860)
* A dropbox beálítások párbeszédpanelén a lapfülek címkéi immár sík áttekintéssel is felolvastathatók.
* Ha az NVDA nyelvét az alapértelmezettről valamilyen másikra állítjuk át, az NVDA helyesen észleli a billentyűparancsokat normál s beviteli módban is.
* Az olyan nyelvekben, mint a német, ahol a plusz billentyű egybillentyűs, a billentyűparancsok megadásánál már a "plus" szó is használható ehhez a billentyűhöz.#2898)
* Az internet explorerben és más MS-Html vezérlőkben az NVDA most már a megfelelő helyen jelzi az idézetblokkokat. (#2888)
* Mozilla böngészőkben a böngészőmód már újra használható, ha egy flash objektum volt megnyitva. (#2546)
* Most már helyesen jelzi az NVDA a braille kijelzőkön a szövegkijelöléseket pl. Ms Word 2003-ban, IE szerkesztőmezőkben.
* Ha scintilla szerkesztőmezőkben böngészünk, backspace-szel vagy delel karaktert törlünk, az NVDA most már helyesen olvassa fel a több-bájtos karaktereket. (#2855)
* Az NVDA telepítése most már nem hiúsul meg, ha a felhasználói profil útvonalában bizonyos többájtos karakterek vannak. (#2729)
* Mozila alkalmazásokban bizonyos szöveges tartalmakat a program már nem kezel szerkeszthetőként (ez korábban ritkán előfordult). (#2959)
* IBM Lotus Symphony-ban és Open Office-ban a kurzor mozgását megfelelően követi az áttekintőkurzor. if appropriate.
* Az Adobe Flash tartalom  már elérhető ie-ben windows 8 alatt. (#2454)
* Javították  a Papenmeier Braillex Trio bluetooth támogatását. (#2995)
* Javítva lett a Microsoft Sapi 5 hangok kezelése, úgy mint a Koba Speech 2 hangjai. (#2629)
* Azon alkalmazásoknál, amik a  Java AccessBridge kiegészítőt használják, a braille kijelző már frissül, ha az áttekintő kurzor egy szerkeszthető mezőbe lép.  (#3107)
* Az űrlap jelzőpont támogatása azon web-dokumentumokban, amik támogatják a jelzőpontokat. (#2997)
* Az olvasási szöveg most már helyesen hangzik el olyan beviteli módoknál, mint pl. az Easy Dots IME XP esetén.
* A javaslatlista  Windows 7 esetén mostantól már helyesen hangzik el a balra és jobbra nyilakkal történő oldalváltoztatáskor, valamint a legelső megnyitáskor a home billentyű segítségével, az egyszerűsített Kínai Microsoft Pinyin beviteli művelet használatakor.
* Testreszabott írásjelek mentése esetén a haladó "preserve" mező már nem törlődik. (#2852)
* A frissítések keresésének kikapcsolása esetén az NVDA-t már nem kell újraindítani a változások életbe léptetéséhez.
* A HumanWare Brailliant BI/B sorozatú braille kijelző driver most már akkor is kiválasztható Bluetooth használatakor, ha az előtte nem volt USB portra csatlakoztatva.
* Az elemlista nagybetűs szövegű szűrése esetén a találatok a kisbetűs szűréshez hasonlóan működnek, a kis- és nagybetűk figyelmen kívül hagyásával. Előzőleg az NVDA nem jelzett találatot. (#2951)
* Ha rövidítéseket tartalmazó braille tábla használatakor az a kurzornál lévő szó átalakítása számítógépes braille jelekké opció engedélyezve van, a braille kurzor pozíciója helyesen jelenik meg olyan szavak után, melyekben egy karakter brailleben több karakterként jelenik meg (pl. nagybetű, számjel, stb.). (#2947)
* Az elemcsoportok jelzése már nem okoz hibát listanézetek (SysListview32) esetén, 64 bites operációs rendszer használatakor.
* Az eSpeak szintetizátora mostantól jobban kezeli az ismeretlen karakterek bemondását (pl. elmondja az idegen betű nevét vagy értékét, annak generikus neve helyett).  (#3106)
* Az NVDA többé már nem fagy le a felhasználói beállítások átmásolásakor a bejelentkező és egyéb biztonsági képernyők használatához, ha a felhasználó neve tartalmaz nem-ascii karaktereket.  (#3092)
* Az NVDA már nem fagy le ázsiai karakterbevitel használatakor egyes .Net alkalmazásokban. (#3005)

## 2012.3

A 2012.3. verzió legfontosabb újdonságai: ázsiai karakterbevitel támogatása, a windows 8 érintő képernyők alapvető támogatása, az oldalszámok bemondása és a táblázatok jobb felolvasása az adobe readerben, valamint a windows listanézetekben és a fókuszban lévő táblázatsorokban táblázatnavigációs parancsok használata.

### Újdonságok

* Az NVDA most már támogat ázsiai karakterbevitelt az IME és szövegbeviteli szolgáltatások segítségével minden alkalmazásban, ideértve:
 * Navigálást és az elemek bemondását a javaslatok listában;
 * A szerkesztési és az olvasási szöveg navigálását/bemondását.
* Az áthúzást és aláhúzást a program felolvassa az Adobe Readerben. (#2410)
* Ha a Windowsban a beragadó billentyűk szolgáltatás be van kapcsolva, az NVDA módosító billentyűje is ennek megfelelően viselkedik, azaz nem kell az NVDA billentyűt nyomva tartani a hozzá tartozó billentyű megnyomásakor. (#230)
* Az NVDA támogatja a HIMS Braille Sense, Braille EDGE és SyncBraille braille kijelzőket. (#1266, #1267)
* Ha a Windows 8-ban értesítések jelennek meg, az NVDA felolvassa őket, és odateszi a navigátor kurzort további interakciók elvégzéséhez. (#2143)
* A windows 8 érintőképernyők alapvető támogatása, ideértve:
* az ujjak alatt lévő szöveg mozgás közben történő felolvasását;
* több megoldást az elemnavigációra, a szövegek áttekintésére és egyéb NVDA-parancsokra
* a VIP Mud támogatása. (#1728)
* Ha az adobe readerben a táblázatnak van összesítője, az NVDA felolvassa azt. (#2465)
* Az Adobe Readerben a program felolvassa a táblázatok sor- és oszlopfejléceit. (#2193, #2527, #2528)
* Új nyelv a programban az Amhara, Koreai, Nepáli.
* Az NVDA felolvassa az automatikus kiegészítési javaslatokat e-mailcímek bevitelekor a Microsoft outlook 2007-ben. (#689)
* Új eSpeak változatok: Gene, Gene2. (#2512)
* Az Adobe Readerben a program felolvassa az oldalszámokat. (#2534)
* Most már lehetőség van az NVDA alapértelmezett konfigurációjának visszaállítására az NVDA+kontroll+r billentyű háromszori megnyomásával, valamint az nvda menüből is. (#2086)
* A program támogatja a Nippon Telesoft által gyártott Seika Version 3, 4 és 5 és Seika80 braille kijelzőket. (#2452)
* Az első és utolsó kurzoráthelyező gombok a Freedom Scientific PAC Mate és Focus Braille kijelzőkön most már használhatóak előre és hátra görgetésre. (#2556)
* Rengeteg egyéb Freedom Scientific Focus Braille kijelző funkció támogatása mint pl. görgők és egyes pontkombinációk általános műveletek végrehajtásához. (#2516)
* Az IAccessible kisegítő technológiát használó alkalmazásokban, mint például a Mozilla alkalmazások, a táblázatok sor- és oszlopfejléceit helyesen olvassa a program az interaktív módban is. (#926)
* A dokumentumot megjelenítő vezérlőelem alapvető támogatása a Microsoft Word 2013 programban. (#2543)
* A program felolvassa a szövegigazítást az Iaccessible kisegítő technológiát használó alkalmazásokban (pl. mozilla alkalmazások). (#2612)
* Ha egy táblázat sora vagy egy többoszlopos szabványos lista van a fókuszban, már használhatók a táblázatfelolvasó navigációs parancsok bármely cella felolvasásához. (#828)
* Új braille fordítási táblák: észt 0. fokozat, Portugál 8 pontos számítógépes braille, olasz 6 pontos számítógépes braille. (#2139, #2662)
* Ha az NVDA telepítve van, és egy NVDA-bővítménycsomagot közvetlenül megnyitunk (pl. az intézőben vagy egy webböngészőben letöltéskor), az NVDA közvetlenül telepíti azt. (#2306)
* A program támogatja a Papenmeier BRAILLEX braille kijelzők újabb modelljeit. (#1265)
* Elérhető a Magyar irodalmi braille tábla, melyet az "Informatika a Látássérültekért" Alapítvány készített.
* Az NVDA bemondja a kurzor pozícióját (pl. 1 per 4) a Windows Explorer program listaelemei esetén Windows 7 (vagy újabb) operációs rendszer használatakor. Ez szintén működik olyan UIAutomation vezérlőelemekben is, melyek támogatják az itemIndex és itemCount tulajdonságokat. (#2643)

### Változások

* Ha a braille követi az áttekintő kurzort és az nem egy szöveges objektumon van (pl. szerkesztőmező), a kurzor áthelyező billentyűk aktiválják az objektumot. (#2386)
* A beállítások mentése kilépéskor lehetőség alapértelmezetten aktiválva van új konfiguráció esetén.
* Az NVDA egy előző verziójának frissítésekor a program parancsikonjának billentyűparancsa nem állítódik vissza a control+alt+n billentyűkombinációra, ha az előzőleg meg lett változtatva. (#2572)
* A bővítmények kezelése párbeszédpanel a bővítmények állapotát most már a név után jeleníti meg. (#2548)
* Ugyanaz, vagy egy más verziójú bővítmény frissítése esetén az NVDA most már rákérdez a felülírásra, hiba megjelenítése és a telepítés megszakítása helyett. (#2501)
* A navigátor kurzor parancsai, (az aktuális elem felolvasása parancsot kivéve) kevésbé részletesen közöl egy adott elemről információkat. Részletes információkért használja az aktuális elem felolvasása parancsot. (#2560)
* A liblouis braille fordító frissítve a 2.5.0 verzióra.
* A billentyűparancsok listája NVDA parancsok listájára lett átnevezve, mivel az NVDA most már érintőképernyőkre vonatkozó parancsokat is tartalmaz.
* Az elemek listája böngészőmódban most már megjegyzi az utoljára mutatott elem típusát, pl. hivatkozás, címsor, vagy jelzőpont, minden esetben, amikor a párbeszédpanelt megjelenítjük az nvda ugyanazon munkamenetében.
* A legtöbb metro alkalmazásban windows 8 használatakor, mint pl. mail, naptár, az NVDA nem aktiválja a böngészőmódot a teljes alkalmazás számára.

### Hibajavítások

* A Blio alkalmazásban a könyvek tartalma most már braille-ben is olvasható. (#2139)
* Windows Vista vagy újabb operációs rendszer esetén az NVDA már nem tekinti a Windows billentyűt úgy, mintha az nyomva lenne tartva a Windows feloldása után, ha azt előtte a Windows+l paranccsal zártuk le. (#1856)
* A táblázatok fejlécei helyesen kerülnek felolvasásra az Adobe Reader program használatakor. (#2444)
* A több sorból, vagy oszlopból álló táblázat cellákat az NVDA már helyesen kezeli az Adobe Reader programban. (#2437, #2438, #2450)
* Az NVDA telepítő ellenőrzi hibamentességét futtatás előtt. (#2475)
* Ha egy frissítés sikertelen, az NVDA eltávolítja az ideiglenes fájlokat. (#2477)
* Az NVDA most már helyesen működik a beállítások másolásakor Windows XP esetén. (#2485)
* A Windows 8 start képernyő elemei hatékonyabban olvashatóak Braille és beszéd használatakor. A név már nem ismétlődik, a kijelöletlen állapot nem hangzik el minden elem esetén, valamint a valós idejű információ az elem leírásaként szerepel (pl. az aktuális hőmérséklet az időjárás elem esetén).
* A jelszó most már nem olvasható a Microsoft Outlook és egyéb szokásos, védettként jelölt szerkesztőmezők esetén. (#2021)
* Egy űrlap változásai böngésző módban most már helyesen jelennek meg az Adobe Reader program használatakor. (#2529)
* Hatékonyabb helyesírás ellenőrzés használat a Microsoft Office programban. A helyesírási hibák megbízhatóbban hangzanak el, valamint a telepített NVDA helyesen működik Windows Vista vagy újabb operációs rendszer esetén is.
* A legtöbb esetben most már azok a bővítmények is telepíthetőek, melyek fájlnevei nem angol karaktereket tartalmaznak. (#2505)
* A szöveg nyelve megőrzésre kerül odagörgetéskor, vagy ha a szöveg tartalma megváltozik az Adobe Reader programban. (#2544)
* Egy bővítmény telepítésekor a megerősítő párbeszédpanel most már helyesen tartalmazza a bővítmény honosított nevét. (#2422)
* UI Automation-t használó alkalmazások esetén (pl. .net és Silverlight), a vezérlőelemek numerikus értékei helyesen vannak megállapítva. (#2417)
* A folyamatjelzőhöz kapcsolódó beállítások most már a végtelen folyamatjelzőkre is vonatkoznak, pl. hordozható verzió készítésekor, telepítéskor, stb. (#2574)
* NVDA parancsok már nem futtathatóak egy braille kijelzőn mialatt egy bisztonsági képernyő, pl. a Windows feloldóképernyő aktív. (#2449)
* Böngésző módban, braille esetén a megjelenített szöveg automatikusan frissül, ha időközben az megváltozott. (#2074)
* Bisztonsági képernyőkön, mint pl. a Windows feloldóképernyő, a közvetlenül az NVDA-nak kiküldött szövegeket mind braille, mind pedig beszéd esetén a program figyelmen kívül hagyja.
* Böngészőmódban most már nem lehet túlmenni egy dokumentum végén ha a kurzoraz utolsó karakteren, vagy elemen áll. (#2463)
* Extra tartalom nem kerül felolvasásra webalkalmazások esetén (ARIA párbeszédpaneleken, melyek nem rendelkeznek aria-describedby tulajdonsággal). (#2390)
* Az NVDA már nem talál, vagy jelez egyes szerkesztőmezőket MSHTML dokumentumok esetén (pl. az Internet Explorer programban, ha egy ARIA role meg van adva. (#2435)
* A backspace billentyű helyesen működik Windows parancssorok és szavak felolvasása esetén. (#2586)
* A cellák koordinátái ismét megjelennek brailleben a Microsoft Excel esetén.
* Microsoft Word használatakor az NVDA már nem szorul be egy formázást tartalmazó bekezdésbe ha azt balra nyíl vagy ctrl+balra nyíl billentyűparancsal szeretnénk elhagyni, és a bekezdés előtt egy listaelem vagy szám található. (#2402)
* Mozila alkalmazásokban böngésző módban bizonyos listaelemek, pl. aria listák esetén, már helyesen jelennek meg.
* Webböngészőkben az NVDA most már elrejti azokat a tartalmakat, amelyeket a képernyőolvasók számára rejtettnek jelöltek meg, (különösképpen az aria rejtett tartalmakat). (#2117)
* Negatív pénzösszeg feltüntetésekor, pl. -123 $, az NVDA most már helyesen olvassa fel a mínusz jelet függetlenül attól, hogy az írásjelek kimondási szintje milyenre van beállítva (#2625).
* Folyamatos felolvasás közben az NVDA most már nem vált vissza helytelenül az alapértelmezett nyelvre akkor, ha egy mondat nem ér véget egy sor végén. (#2630)
* Az adobe reader 10.1-ben és újabb verzióiban a betűtípus-információkat az NVDA most már helyesen észleli. (#2175)
* Ha egy dokumentum tartalmaz alternatív szöveget, kizárólag csak ez fog megjelenni az Adobe Reader programban. Előzőleg egyéb szöveg is megjelenhetett. (#2174)
* Ha egy dokumentum valamilyen belső alkalmazást tartalmaz, böngészőmódban az NVDA már nem jeleníti meg az alkalmazás tartalmát. Ezzel megelőzhető, hogy váratlanul az alkalmazás kódjába lépjünk böngészés közben. Az alkalmazásokkal ugyanúgy kommunikálhatunk, mint a beágyazott objektumokkal. (#990)
* A Mozilla alkalmazások léptethető gombjainak értéke helyesen hangzik el változáskor. (#2653)
* Frissült az Adobe Digital Editions támogatása, így már a 2.0-ás verzió is használható az NVDA-val. (#2688)
* Ha az internet explorerben és más MSHTML dokumentumban egy kombinált listamezőn nvda-felnyilat nyomunk, a program most már nem rossz információkat olvas fel, hanem azt az aktív elemet, amelyen állunk. (#2337)
* Az NVDA kivételszótárai helyesen elmentődnek ha a tényleges kifejezés vagy a behelyettesített kifejezés kettőskereszt jelet tartalmaz. (#961)
* Az NVDA már helyesen jelenít meg látható tartalmat rejtett tartalomban (pl. visibility:visible stílusú tartalom visibility:hidden stílusú tartalomon belül) MSHTML (pl. Internet Explorer) dokumentumokban. (#2097)
* A Windows XP Bisztonsági Központ hivatkozásai már nem tartalmaznak véletlenszerű karaktereket. (#1331)
* UI Automation szerkesztőmezők (pl. a Windows 7 Start Menü keresőmezője) helyesen hangoznak el ha az egérmutató föléjük kerül.
* A billentyűzetkiosztás változását a program most már többnyelvű dokumentumok folyamatos felolvasásakor nem olvassa fel (ez problémát jelentett pl. arab szövegeknél). (#1676)
* Az UI automationt használó szerkesztőmezők belső tartalmának megváltozásakor (pl. windows 7 vagy 8 startmenüjének keresője) most már nem olvassa fel a program a szerkesztőmező teljes tartalmát annak minden egyes változásakor. 
* Ha a windows 8 kezdő képernyőjén a programcsoportok között mozgunk, az NVDA most már nem olvassa fel a csoport első elemét a csoport neveként, ezzel is gyorsítva a navigációt. (#2658)
* A Windows 8 kezdőképernyőjének megnyitásakor a fókusz most már az első elemre kerül, nem pedig a kezdőképernyő gyökerére, megkönnyítve a navigációt. (#2720)
* Az NVDA most már rendesen indul akkor is, ha a felhasználói profil útvonala többájtos karaktereket tartalmaz. (#2729)
* Böngészőmódban a fülek szövegei helyesen jelennek meg a Google Chrome programban.

## 2012.2

Ennek a kiadásnak a főbb újdonságai a következők: egységes telepítőkészlet és hordozható változat, automatikus frissítő, az új NVDA-bővítmények könnyű kezelése, ábrák bemondása a Microsoft Wordben, a windows 8 metro stílusú alkalmazások támogatása, valamint több fontos hibajavítás.

### Újdonságok

* Az NVDA mostantól képes az új frissítések letöltésére, és feltelepítésére. (#73)
* Egyszerűbbé vált a különböző külső illesztőprogramok és bővítmények kezelése az NVDA bővítmény kezelőjével (amely az eszközök menüben található). Ennek segítségével feltelepítheti és eltávolíthatja az NVDA programhoz készült bővítményeket (.nvda-addon). (#213)
* A legtöbb közismert NVDA-funkció már windows 8 metro stílusú alkalmazásokban is működik, de csak az NVDA telepített változata esetén, ideértve a begépelt karakterek visszamondását, web dokumentumok esetén a böngészőmódot, valamint az internet explorer 10 metro felületének támogatását is. Az NVDA hordozható változatban nem fér hozzá a metro stílusú alkalmazásokhoz. (#1801) 
* A böngésző módú dokumentumokban (internet explorer, firefox stb.) az információkat tartalmazó elemek (listák, táblázatok) elejére és végére lehet ugrani a , és shift+, billentyűkombinációkkal.  (#123)
* Az NVDA most már görög nyelven is elérhető.
* Az ábrákat és az ábrafeliratokat (alt text) az NVDA már felolvassa a Microsoft Word dokumentumokban. (#2282, #1541)

### Változások

* A Microsoft Excelben az NVDA most már először a cella tartalmát olvassa és csak utána a cella koordinátáit, ha a táblázatok és a cellakoordináták felolvasása be van kapcsolva a dokumentum-formázási párbeszédpanelen.
* Az NVDA mostantól kizárólag egy telepítőcsomagként fog megjelenni. A program elindításakor egy átmeneti példányindul el, ekkor lehetőség van a program feltelepítésére, vagy a hordozható verzió elkészítésére is. (#1715)
* Az NVDA mostantól minden esetben a Program files mappába települ. Azon verzióknál ahol ez még nem így történt, automatikusan áthelyezi magát.

### Hibajavítások

* Ha az automatikus nyelvváltás be van kapcsolva, az NVDA most már a helyes nyelven olvassa fel az ábrák feliratait, a címkéket és bizonyos más vezérlőelemeket a mozilla gecko-t használó alkalmazásokban (pl. Firefoxban), feltéve, hogy ezeket helyesen jelölték meg.
* Már nem áll meg a folyamatos felolvasás a BibleSeekerben vagy más ún. trx-szerkesztőmezőkben egy szakasz közepén.
* A Windows 8 intézőben a fájltulajdonságok lap engedélyek lapfülén és a Windows 8 frissítőjében (windows update) az NVDA helyesen olvassa fel a megjelenő információkat.
* Ki lett javítva az a hiba, hogy a Microsoft Wordben az NVDA néha lefagyott, ha egy dokumentumból nagyon hosszú sorokat vagy tartalomjegyzéket emeltünk át. (#2191)
* Kijavították a szóhatárok hibás érzékelését, amikor nem törő szóközt tartalmaz a dokumentum bizonyos írásjelek után. 
* Az adobe readerben böngészőmódban már bármely szintű címsorra rá lehet ugorni navigációs gyorsbillentyűkkel és az elemlistával. (#2181)
* A winampban a braille kijelző most már megfelelően frissül, ha a lejátszólista-szerkesztőben új elemet jelölünk ki. (#1912)
* Az elemek listája fanézete (böngésző módú dokumentumok esetén) most már megfelelő méretre van beállítva ahhoz, hogy kiférjen az egyes elemek szövege (#2276)
* A java access bridge-et használó alkalmazásokban a szerkesztőmezőket a program jól jelzi a braille kijelzőn. (#2284)
* A Java access bridge-et használó alkalmazásokban a szerkesztőmezők már nem tartalmaznak furcsa karaktereket bizonyos előfordulásokban. (#1892)
* Ha egy szerkesztőmező végéhez új tartalmat adunk hozzá a Java access bridge-et használó alkalmazásokban, a program helyesen jeleníti meg az adott sort. (#1892)
* Az olyan böngésző módú alkalmazásokban, amelyek mozilla gecko 14-es vagy újabb böngészőmotort használnak (pl. 14-es Firefox) a gyors navigáció már használható idézetblokkok és beágyazott objektumok esetén is. (#2287)

## 2012.1

Ezen kiadás főbb újdonságai közé tartoznak a braille hatékonyabb olvasását segítő lehetőségek, a dokumentum formázásának hatékonyabb szöveges és braille hozzáférése, megnövelt Microsoft Word támogatás, valamint az iTunes Store támogatása.

### Újdonságok

* Az NVDA már bemondja a szóközös és tabulátoros igazítást az aktuális sor olvasásakor, a begépelt sorrendben. E lehetőség a Dokumentum formázás párbeszédpanel, igazítás bemondása jelölőnégyzetével szabályozható. (#373)
* Az NVDA már észleli a leütött billentyűket alternatív beviteli eszközöknél, pl. képernyőn megjelenő billentyűzet, vagy szövegfelismerő szoftver esetén.
* Az NVDA már felismeri a színeket a Windows parancssor használatakor.
* A félkövér, dőlt és aláhúzott betűparaméterek már braille-ben is megjelennek, a fordítási táblának megfelelően. (#538)
* Most már sokkal több információ hangzik el Microsoft Word dokumentumok használatakor, mint pl.:
 * Szövegszerkezeti információk, pl. a lábjegyzetek és végjegyzetek számai, címsorok, megjegyzések léte, táblázat beágyazási szintek, hivatkozások, valamint színfelismerés az egyes dokumentumrészekbe lépéskor, pl. lábjegyzetek, végjegyzetek, fej és láblécek, stb.
* Braille használatakor a hetes és nyolcas pont már jelzi a kijelölt szöveget. (#889)
* Braille használata esetén az NVDA információt nyújt egyes vezérlőelemekről, mint pl. hivatkozások, gombok, vagy címsorok. (#202)
* Az NVDA már támogatja a hedo ProfiLine és MobilLine USB braille kijelzőket. (#1863, #1897)
* Az NVDA alapértelmezetten igyekszik elkerülni a szavak tördelését braille esetén. Ez a Braille Kijelző Beállítások párbeszédpanelen kikapcsolható. (#1890, #1946)
* Most már lehetőség vanbraille esetén  bekezdéseket megjeleníteni sorok helyett, mely nagyméretű szöveg esetén fokozottabb olvasást eredményezhet. A beállítás a Braille Kijelző Beállítások párbeszédpanel Bekezdésenkénti olvasás jelölőnégyzetével szabályozható. (#1891)
* Braille használatakor most már lehetőség van egy elem aktiválására. Ez az elemnél található kurzoráthelyező gomb segítségével megtehető. Ha a kurzor még nem tartózkodik az elemnél, a gomb kétszeri lenyomása szükséges. (#1893)
* Alapvető webterületek támogatása az iTunes programban, pl. a Store. Egyéb, WebKit 1-et használó alkalmazások is működhetnek. (#734)
* Az Adobe Digital Editions 1.8.1 vagy későbbi verzióiban folyamatos felolvasás esetén az NVDA automatikusan képes lapozni. (#1978)
* Új braille fordítási tábla: Portugál, rövidítési fokozat 2. (#2014)
* A keretek bemondása most már szabályozható a Dokumentum Formázás párbeszédpanelen. (#1900)
* Az OpenBook használatakor az alvó mód már automatikusan engedélyezve van. (#1209)
* A Poedit alkalmazásban a fordítók már fel tudják olvastatni a fordítói, vagy az automatikus megjegyzéseket. A bizonytalan (fuzzy) vagy le nem fordított üzenetek csillaggal vannak megjelölve, és a listában a pozíciójukhoz érve hangjelzés hallható (#1811)
* A HumanWare Brailliant BI és B braille kijelzők támogatása. (#1990)
* A Norvég Bokmål nyelv hozzáadása.

### Változások

* Az NVDA már A karakter, szó vagy sor felolvasásakor az adott nyelvnek megfelelően betűz, ha ilyen információ elérhető és az automatikus nyelvváltás lehetőség engedélyezve van.
* Az eSpeak beszédszintetizátor 1.46.02-es verziójának használata.
* Az NVDA már kiszűri a 30 karakternél nagyobb névvel rendelkező hivatkozásokat, vagy képhivatkozásokat. Ezek nevei általában nem tartalmaznak használható információt. (#1989)
* Egyes braille információk le lettek rövidítve. (#1955, #2043)
* Az áttekintőkurzor vagy a kurzor mozgatása esetén a braille görgetése már a kézi görgetéshez hasonlóan történik. Ez eredményesebb a szótördelések elkerülésekor, vagy bekezdésenkénti olvasáskor. (#1996)
* A spanyol  grade 1 braille tábla frissítése.
* A liblouis braille fordító frissítése a  2.4.0 verzióra.

### Hibajavítások

* A Windows 8 operációs rendszerben a fókusz már nem mozdul el a Windows Explorer keresés mezőjéről, mely lehetetlenné tette annak használatát.
* Megnövelt hatékonyság Microsoft Word dokumentumok olvasása esetén ha a formázás automatikus bemondása engedélyezve van. Ez lehetővé teszi dokumentumok kényelmesebb átolvasását, és egyes felhasználók esetén általános hatékonyságnövelést eredményezhet.
* A böngészőmód használható teljes képernyős Adobe Flash tartalmak hozzáféréséhez.
* Az alacsony hangminőség hiba kijavítása Microsoft Speech API v5 hangok használatakor, ha a kimeneti hangeszköz nem a Microsoft Hangleképző. (#749)
* Ismét lehetőség van a csendes üzemmód használatára, mely esetén a Beszédnéző, vagy Braille használható. (#1963)
* Az objektumnavigációs parancsok a felhasználói útmutatóban szerepelteknek megfelelően tájékoztatnak, ha nem rendelkeznek szülő- vagy gyermekobjektummal.
* Az NVDA nem angol nyelvű használatakor a Tab billentyű neve a nyelvnek megfelelően hangzik el.
* Mozilla Gecko alkalmazásokban (pl. Firefox) az NVDA már nem vált át esetenként böngésző módba menük használatakor. (#2025)
* A számológép alkalmazásban a Backspace billentyű használatakor az NVDA már  bemondja a törlés eredményét. (#2030)
* Böngészőmódban az egér áthelyezése az aktuális elemhez parancs az elem közepéhez pozícionálja azt, a bal felső sarok helyett. Ez esetenként hatékonyabb működést eredményez. (#2029)
* Az automatikus interaktív mó dhasználatakor az NVDA már automatikusan interaktív módba vált eszköztárra lépéskor. (#1339)
* Az ablakcím parancs most már helyesen mondja be az Adobe Reader ablak címét.
* Az Automatikus interaktív mód használatakor az NVDA már automatikusan interaktív módba vált a fókuszban lévő táblázatcella esetén, pl. ARIA táblázatok jelenlétekor. (#1763)
* Az iTunes alkalmazásban egyes listák pozícióinformációi helyesen kerülnek felolvasásra.
* Az Adobe Reader programban az NVDA már nem észlel néhány hivatkozásban csak olvasható szerkesztőmezőt.
* Néhány szerkesztőmező címkéje már nem hangzik el egy párbeszédablak felolvasásakor. (#1960)
* Az elemcsoportok leírása ismét elhangzik ha az objektumok leírásabeállítás  engedélyezve van.
* A felkerekített méret már elhangzik a Windows Explorer meghajtó tulajdonságok párbeszédpanelen.
* A tulajdonságlapok szövegeinek esetenkénti kétszeri elhangzása már ritkábban történik. (#218)
* Hatékonyabb kurzorkövetés olyan szerkesztőmezők esetén, melyek közvetlenül a képernyőre írják szövegüket. Ez megnöveli a szerkesztést többek között a Microsoft Excel cellaszerkesztőben és az Eudora üzenetszerkesztőben. (#1658)
* A Firefox 11 programban a szülő virtuális kijelzőhöz ugrás parancs (NVDA+control+space) megfelelően működik beágyazott elemekből való kilépéskor, pl. Flash tartalom esetén.
* Az NVDA már helyesen indul újra (pl. nyelvváltoztatás esetén) ha nem ASCII karaktereket tartalmazó könyvtárban található. (#2079)
* A Braille megjelenítés már helyesen figyelembe veszi az elemek gyorsbillentyű, pozíció információ és leírás beállításait.
* A Mozilla alkalmazásokban váltás az interaktív és a böngészőmód között már nem eredményez lelassulást. (#2095)
* A kurzor egy sor vagy bekezdés végén lévő szóközhöz helyezése már megfelelően működik Braille esetén. Ez előzőleg néhány szerkesztőmezőben a kurzor a szöveg elejéhez kerülését eredményezte. (#2096)
* Az NVDA újra jól együttműködik az Audiologic beszédszintetizátorral. (#2109)
* A Microsoft Word dokumentumok most már helyesen több sorosként vannak felismerve. Így braille esetén a fókuszban lévő dokumentum is megfelelően használható.
* A Microsoft Internet Explorer most már nem okoz hibákat egyes ritka vezérlőelemek esetén. (#2121)
* Az írásjelek kiejtésének módosításakor a változások most már azonnal életbe lépnek, így az NVDA-t nem kell újraindítani, vagy az automatikus nyelvváltást kikapcsolni.
* Az eSpeak használatakor a beszéd már nem némul el az NVDA naplónézőjének mentés másként ablakában. (#2145)

## 2011.3

A 2011.3 verzió főbb újdonságai: Automatikus nyelvváltás olyan dokumentumoknál, melyek rendelkeznek a megfelelő nyelvi információkkal, a 64 bites java futtatókörnyezetek támogatása, formázás felolvasása a Mozilla-alkalmazásokban interaktív módban, az alkalmazások összeomlásának, lefagyásának jobb kezelése, hibajavítások windows 8-cal történő használathoz

### Újdonságok

* Az NVDA valós időben képes megváltoztatni az Espeak beszédszintetizátor nyelvét és dialektusát, ha olyan web/pdf dokumentumokat olvasunk, amelyek tartalmazzák a megfelelő nyelvi információkat. Az automatikus nyelv- és dialektus váltás be- és kikapcsolható a beszédbeállítások párbeszédpanelen. (#845)
* az NVDA már támogatja a Java Access Bridge 2.02 használatát, mely lehetővé teszi a 64 bites java futtatókörnyezetek használatát.
* A program már képes felolvasni a címsorokat a navigátorkurzor használatakor a Mozilla Gecko böngészőmotort (a továbbiakban: Mozilla Gecko) használó alkalmazásokban, pl. a Firefoxban.
* Az NVDA már észleli a szövegek formázását a Mozilla Gecko-t használó alkalmazásokban (pl. Firefox, Thunderbird) böngésző mód esetén is. (#394)
* Az alá- és áthúzást a program már érzékeli és felolvassa a hagyományos IAccessible2 szöveges vezérlőelemekben, mint pl. amilyenek a mozilla alkalmazásokban vannak.
* Az adobe readerben böngésző módban a program már felolvassa a táblázatok oszlopainak és sorainak számát.
* Az NVDA támogatja a Microsoft Speech Platform beszédszintetizátort (#1735).
* Az IBM Lotus Symphony alkalmazásban a program a kurzor mozgásakor felolvassa az oldalak és a sorok számát.
* A beszédbeállítások párbeszédpanelen százalékosan adható meg, hogy milyen magasan emelje meg a hangot a beszédszintetizátor nagybetű kimondásakor. Ez váltotta fel a korábban alkalmazott hangmagasság megemelése nagybetűk esetén jelölőnégyzetet. A funkció kikapcsolásához állítsuk be az értékét 0%-ra (#255).
* A Microsoft Excel programban a cella formázási információinál az NVDA már felolvassa a szöveg és háttér színét is (#1655).
* A Java Access Bridge-et használó alkalmazásokban a jelenlegi elem aktiválása parancs most már megfelelően használható a megfelelő vezérlőelemeken (#1744).
* Az NVDA már alap szintű támogatást nyújt a Design Science MathPlayerhez.

### Változások

* Az NVDA már újraindítja magát, ha összeomlik.
* Egyes braille-ban kiírandó információk lerövidültek (#1288).
* A teljes ablak felolvasása szkript (NVDA-b) tovább fejlődött úgy, hogy most már kiszűri a felesleges vezérlőelemeket, és sokkal könnyebb elnémítani (#1499).
* A dokumentumok automatikus folyamatos felolvasása betöltéskor opció most már tetszés szerint be- és kikapcsolható a böngésző mód párbeszédpanelen (#414).
* Amikor megpróbáljuk az állapotsort felolvastatni (asztali kiosztásnál NVDA+end), de az állapotsor nem található, az NVDA az aktív alkalmazásban kiírt szöveg utolsó sorát olvassa fel (#649).
* Böngészőmódban folyamatos felolvasáskor az NVDA szünetet tart a címsorok végén és más elkülöníthető (blokk szintű) elemeknél, nem olvassa össze az utána következő elemmel, mintha az egy hosszú mondat lenne.
* Böngésző módban folyamatos felolvasás közben egy vezérlőelemen szóközt vagy tabot nyomva a program aktiválja azt, nem pedig űrlap módba lép (#1760).
* Az Espeak beszédszintetizátort az 1.45.47 verzióra frissítették.

### Javítások

* Az NVDA már nem mutatja a listaelem szimbólumokat vagy számozást az internet explorerben vagy más MS HTML vezérlőkön, ha annak megjelenítését a dokumentum készítője letiltotta (pl. ha a lista stílusa "none" értékre van beállítva) (#1671).
* Az NVDA újraindításakor (pl. ha lefagy (kontroll+alt+N)) már nem zárja be úgy az előző másolatot, hogy az újat el ne indítaná.
* A backspace vagy a nyilak megnyomása a Windows parancssorban már nem okoz furcsa jelenségeket bizonyos esetekben (#1612).
* a WPF és esetleg más olyan kombinált listamezőkben, amelyek UI Automation megoldást használnak, ha nem engedélyezett a szöveg átírása, a program a kijelölt elemet helyesen olvassa fel.
* Az adobe readerben böngésző módban most már bármikor lehetőség van a fejlécről a sorra és a sorról a fejlécre lépni az előző és a következő sorra lépés paranccsal, valamint most már a fejlécet nem olvassa nulladik sornak a program (#1731).
* Az adobe readerben böngészőmódban most már egy táblázatban rá lehet lépni üres cellára is, így ez át is ugorható.
* A program már nem írja ki braille-ban a mutathatatlan pozícióinformációkat, pl. nulladik a nullából a nulladik szinten.
* Ha a braille kurzor követi az áttekintőkurzort, most már lehetséges sík áttekintésben átnézni az ablak tartalmát (#1711).
* Egy vezérlőelem szövegét a program már nem írja ki kétszer a braille kijelzőre bizonyos esetekben, pl. wordpadban a dokumentum elejére történő visszagörgetéskor.
* Az internet explorerben böngészőmódban nem lép interaktív módba  a program egy fájl feltöltésére szolgáló gomb aktiválásakor, hanem helyesen mutatja a fájlfeltöltő párbeszédpanelt (#1720).
* A program most már nem olvassa fel a dinamikusan változó tartalmakat alvó módban (pl. parancssorban), ha az alvó módot az adott alkalmazásban bekapcsoltuk (#1662)
* Böngésző módban a kombinált listamezők kinyitására és bezárására szolgáló alt+lenyíl és alt+felnyíl parancsok működése most már hatékonyabb (#1630).
* Az NVDA már sokkal több olyan esetben helyre tudja állítani magát lefagyott, vagy összeomlott alkalmazások esetén, melyek korábban az NVDA instabilitását eredményezték (#1408).
* Az NVDA a Mozilla Gecko-t használó alkalmazásokban (pl. firefox) böngésző módban már helyesen jeleníti meg a dokumentumot bizonyos igen speciális esetekben, pl. amikor egy elemet "display:table" stílusúnak határoztak meg (#1373).
* Az NVDA már nem olvassa fel a címke vezérlőelemeket, ha a fókusz azokban megváltozik. Így egyes űrlapok címkéi Nem kerülnek kétszeri bemondásra a Mozilla alkalmazásokban (Gecko) és az internet explorerben (MS-HTML vezérlőelemek) (#1650).
* Az NVDA már felolvassa egy cella tartalmát a Microsoft Excel programban, ha a control+v billentyűparanccsal beillesztés történik. (#1781).
* Az adobe readerben az NVDA interaktív módban már nem olvas fel a dokumentumhoz tartozó felesleges információkat egy másik lapon található vezérlőelemre lépéskor (#1659).
* A Mozilla Gecko alkalmazásokban (pl. Firefox) az NVDA a ki-be kapcsolható gombokat helyesen észleli és olvassa fel (#1757).
* Az NVDA helyesen olvassa fel az internet explorer címsorát a windows 8 fejlesztői verziójában.
* Az NVDA már nem omlaszt össze alkalmazásokat (pl. winver, wordpad) a windows 8 fejlesztői verziója alatt a rossz glyph fordítás miatt 
* A Gecko 10-et vagy újabb böngészőmotort használó alkalmazásokban (pl. Firefox 10) az NVDA már sokkal gyakrabban állítja be helyes pozícióba a kurzort horgonyt tartalmazó dokumentumok betöltésekor (#360).
* Mozilla Gecko-t használó alkalmazásokban (pl. Firefox) a képtérképek feliratait az NVDA most már helyesen értelmezi.
* Ha az egér követése be van kapcsolva, az egérmutatónak bizonyos szerkeszthető szövegmezők feletti átvitelekor (pl. Synaptics Pointing Device beállítások ablakában vagy SpeechLab speaktextnél) az NVDA már nem omlasztja össze ezeket az alkalmazásokat (#672).
* Az NVDA most már jól működik bizonyos névjegyablakokban, pl. a Windows Xp-hez mellékelt jegyzettömbben vagy a Windows Xp névjegyablakában (#1853, #1855).

### Változások fejlesztőknek

* Az NVDA most már képes átállítani a beszédszintetizátor nyelvét a szöveg bizonyos részeinek helyes felolvasásához.
* Ehhez a drivereknek kezelniük kell a speech.LangChangeCommand eseményt, mely a SynthDriver.speak() függvénynek adódik át.
* A SynthDriver objektumot öröklő objektumoknak rendelkezniük kell a VoiceInfo típusú nyelv argumentummal (vagy felül kell írnia a nyel attribútumot). Egyéb esetben az NVDA alapértelmezett felhasználói felület nyelve lesz használva.

## 2011.2

E kiadás főbb újdonságai: nagyobb fejlesztések, melyek a következők: a központozási és szimbólumok beállításai egyénileg beállítható szintekkel, az egyéni cimkézés és karakterleírások, folyamatos felolvasásnál a sorok végén a szünetek megszüntetése, az internet explorerben az "aria jobb támogatása", az XFA/LiveCycle PDF dokumentumok jobb támogatása az Adobe Readerben, több alkalmazásban a kiírt szövegekhez való jobb hozzáférés, az alkalmazások által a képernyőre írt szövegek formázási és betűszín-információinak felolvasása.

### Újdonságok

* Lehetővé vált bármely karakter leírásának felolvasása az áttekintő kurzor jelenlegi karakter parancsának kétszeri gyors megadásával. Angol nyelv esetén ez az általános angol fonetikus ábécé. Olyan kép / ékírásos nyelveknél, mint pl. a hagyományos kínai, egy-két esetben azt a szimbólumot olvassa fel, amely rendelkezésre áll. Az áttekintő kurzor jelenlegi szó vagy jelenlegi sor parancsának háromszori megnyomása esetén betűzi az adott szót vagy sort az első leírással kezdve. (#55)
* Sík áttekintésben több szöveg olvasható pl. az olyan alkalmazásokban, mint a Mozilla Thunderbirdben, melyek közvetlenül írják ki a szövegeiket a képernyőre rajzolt ikonok útján.
* Most már a központozási beállítások és a szimbólumok kimondásának több szintje közül lehet választani. (#332)
* Ha egy írásjel vagy más szimbólum több, mint négyszer ismétlődik, most már az ismétlések számát mondja be a program ahelyett, hogy azt többször ismételné. (#43)
* Új nyolcpontos norvég számítógépes braille fordítótáblát építettek be. (#1456) 
* Most már nincsenek zavaró szünetek a sorok végén folyamatos felolvasáskor. (#149)
* Az NVDA most már a webböngészőkben felolvassa, ha a tartalmat valamilyen módon rendezték (köszönhetően az "aria" rendezési tulajdonságnak). (#1500)
* A unicode braille alakzatokat a program helyesen jeleníti meg a braille kijelzőkön. (#1505)
* Internet explorerben és más MS-html vezérlőkön ha a fókusz olyan vezérlőelemek csoportjára lép, amely körül van határolva a 'fieldset' html elemmel, az NVDA az egész csoport nevét, illetőleg leírását  felolvassa. (#535)
* Az internet explorerben és más ms-html vezérlőkön az aria címkézési és leírási megoldások (aria-labelledBy és aria-describedBy) most már támogatottak.
* Továbbfejlesztett támogatás az internet explorerben és más ms-html vezérlőkön az aria lista, rácsozat, csúszka és folyamatjelző vezérlőelemekhez.
* A felhasználók most már megváltoztathatják az írásjelek és más szimbólumok kiejtését, a szimbólumok felolvasási szintjét. (#271 
* A Microsoft Excelben most már felolvassa az NVDA az aktív munkalap nevét, ha a kontroll-pageup / kontroll pagedown billentyűvel váltunk a munkalapok között. (#760)
* Ha a Microsoft Wordben egy táblázatban a tabbal lépkedünk, az NVDA felolvassa azt a cellát, amelyre lépünk. (#159)
* Most már be lehet állítani a táblázatcellák koordinátáinak felolvasását a dokumentumformázási beállítások párbeszédpanelen. (#719)
* Az NVDA most már felismeri a képernyőre közvetlenül írt szövegek színét és formázását.
* Az outlook express, windows mail, windows live mail üzenetlistájában az NVDA már felolvassa, ha egy üzenet olvasatlan, valamint, ha a hírcsoportban egy üzenet meg van nyitva vagy be van zárva. (#868)
* Az Espeak sebességfokozó beállításának támogatása, mely megháromszorozza a beszédtempót.
* A naptár vezérlőelem támogatása, mely többek között a Windows 7 óra aktiválásával is elérhető. (#1637)
* További billentyűparancsok érhetőek el az MDV Lilli braille kijelzőhöz. (#241)
* Új nyelvek érhetőek el: Bolgár és Albán.

### Változások

* A kurzor áttekintőkurzorhoz helyezéséhez mostantól használja asztali kiosztásban az NVDA+shift+numpad minusz, hordozható kiosztás esetén pedig az NVDA+shift+backspace billentyűket kétszer gyorsan lenyomva. Ezzel további később használható billentyűparancsok szabadultak fel. (#837)
* Egy karakter decimális és hexadecimális értékeinek bemondásához nyomja le kettő helyett háromszor az áttekintőkurzor aktuális karakterének bemondása billentyűparancsot. Kétszeri lenyomásra ugyanis most már a karakter leírása hangzik el.
* Az eSpeak beszédszintetizátor frissítése az 1.45.03-as verzióra. (#1465)
* A rétegződő táblázatok már nem hangzanak el a Mozilla Gecko alkalmazásokban interaktív módban, vagy egy dokumentumon kívül.
* Az Internet Explorer és egyéb MSHTML vezérlőelemeken a böngészőmód helyesen működik ARIA alkalmazásokban. (#1452)
* A liblouis braille fordító frissítése 2.3.0-s verzióra.
* Interaktív módban a gyors navigációs parancsokkal, vagy a fókuszt használva egy vezérlőelemre lépéskor a vezérlőelem leírása már elhangzik, ha rendelkezik ilyennel.
* A folyamatjelzők mostantól támogatottak böngészőmódban.
* Az ARIA presentation-nal rendelkező elemek az Internet Explorer és egyéb MSHTML vezérlőelemeken már nem láthatóak egyszerű áttekintőmódban.
* Az NVDA beépülőket tartalmazó felhasználói beállítások rendszerprofilba másolásakor, mely többek között a bejelentkező képernyőn töltődik be, figyelmeztetés jelenik meg, mivel ez bisztonsági kockázat lehet. (#1426)
* Az NVDA szolgáltatás nem állítja le és indítja el újra az NVDA-t felhasználói bevitelű számítógépeken.
* Windows XP és Windows Vista használatakor az NVDA már nem használ UI Automation-t, még akkor sem, ha ez elérhető frissítésen keresztül. Bár az UI Automation megnöveli egyes modern alkalmazások hozzáférését, XP és Vista rendszereken ez nagymértékű lefagyáshoz, hibákhoz és teljesítményvesztéshez vezet. (#1437)
* A Mozilla Gecko 2 és későbbi verzióit tartalmazó alkalmazásokban (pl. Firefox 4 és újabb) már lehetőség van a dokumentum olvasására annak teljes betöltése előtt.
* Az NVDA már bemondja a vezérlőelemet tartalmazó elem állapotát (pl. a fókusz mozgatásakor egy html dokumentumban az elfoglalt szó hallható betöltés közben).
* Néhány menü esetén ha az almenüvel rendelkezik, a bezárva állapot már nem hallható.
* A formázás bemondása parancs (NVDA+f) most már az áttekintő kurzor pozíciójánál található karaktert veszi figyelembe a rendszerkurzor helyett. Mivel a legtöbb felhasználó beállítása szerint az áttekintőkurzor követi a rendszerkurzort, ez nem észrevehető változás. Ezzel a lehetőséggel a formázás most már megállapítható pl. síkáttekintő módban.

### Hibajavítások

* Kombinált listamezők bezárása interaktív módban, ha az előtte az nvda+szóköz-zel volt aktiválva most már nem vált vissza automatikusan böngészőmódba. (#1386)
* A Gecko (pl. Firefox) és MSHTML (pl. Internet Explorer) vezérlőelemek dokumentumaiban az NVDA most már helyesen jeleníti meg az egy sorba tartozó elemeket, melyek előzőleg különböző sorokban jelentek meg. (#1378)
* Ha a Braille kijelző az áttekintőkurzort követi és a navigátor kurzor egy böngészőmódú dokumentumra lép, akár kézileg vagy fókuszváltozás esetén, a braille helyesen jeleníti meg a tartalmat. (#1406, #1407)
* Ha az írásjelek bemondása lehetőség nincs engedélyezve néhány szintetizátor már nem mond be egyes írásjeleket. (#332)
* Azok a beszédszintetizátorok, melyek nem támogatják a hangkarakter lehetőséget most már helyesen töltődnek be (pl. Audiologic Tts3). (#1347)
* A Skype Extrák menü most már helyesen kerül felolvasásra. (#648)
* A 'A fényerő változtatja az egérmutató hangjának hangerejét' beállítás bejelölése az egér beállítások párbeszédpanelén most már nem okoz késleltetett hangjelzést Windows Vista/Windows 7 rendszereken az Aero használatakor. (#1183)
* A hordozható kiosztás használatakor az NVDA+delete billentyűparancs most már helyesen működik. (#1498)
* Az NVDA most már helyesen dolgozza fel az aria-selected elemet az Internet Explorer dokumentumokban.
* Az NVDA automatikus interaktív módjának használatakor a fókuszban lévő elem környezete is elhangzik. Pl. egy lista esetén a lista hangzik el elsőként. (#1491)
* Internet Explorer és egyéb MSHTML vezérlőelemeken az ARIA lista vezérlőelemek listaként jelennek meg, listaelem helyett.
* Az NVDA most már bemondja egy csak olvasható szerkesztőmező csak olvasható állapotát fókuszváltozás esetén. (#1436)
* Az NVDA most már helyesen működik csak olvasható mezők esetén html dokumentumokban.
* Az NVDA már nem lép ki az interaktív módból az aria-activedescendant megadása esetén. Pl. automatikus kiegészítéssel rendelkező vezérlőelemekben.
* Az Adobe Reader programban a vezérlőelemek nevei helyesen hangzanak el gyorsnavigációs gombok vagy fókuszváltozás esetén.
* Az Adobe Reader programban az XFA PDF dokumentumok gombjai, hivatkozásai és képei helyesen kerülnek feldolgozásra.
* Az Adobe Reader programban az XFA PDF dokumentumok elemei külön sorba kerültek. Ez a változás szükséges volt, mert dokumentumok nagy részei (esetenként a teljes dokumentum) egy sorban jelent meg az elrendezés hiánya miatt.
* Az Adobe Reader programban az XFA PDF dokumentumok használatakor fókuszváltás szerkesztőmezőkről/re már helyesen működik.
* Az Adobe Reader programban az XFA PDF dokumentumok kombinált listamezőinek értékei már helyesen hangzanak el azok megváltozásakor.
* Egyénileg rajzolt kombinált listamezők, pl. az Outlook Express színválasztója már hozzáférhetőek az NVDA-val. (#1340)
* Azokban a nyelvekben amelyek szóközt használnak számelválasztóként, pl. Francia és Német, a számcsoportok nem külön számokként hangzanak el. Ez különösen problémákat okozott számokat tartalmazó táblázatok esetén. (#555)
* Aria description szerepet tartalmazó elemek az Internet Explorer és egyéb MSHTML vezérlőelemeken már statikus szövegként vannak kategorizálva, szerkesztőmező helyett.
-Különböző hibák javítása a tab billentyű használatakor ha a fókusz egy dokumentumon van (pl. szükségtelen ugrás a címsorra az Internet Explorer programban). (#720, #1367)
* Beviteli módban most már azok a parancsok is naplózva vannak, melyek megkerülik a bevitel módot. Pl. a Braille kijelző előre és hátra görgetés parancsai.
* Beviteli módban a módosítóbillentyűk most már nem hangzanak el úgy, mintha önmagukat módosítanák, pl. NVDA+NVDA.
* Az Adobe Reader dokumentumokban a shift+C vagy C billentyűk az előző és következő kombinált listamezőre ugráshoz már helyesen működnek.
* A táblázatok sorainak kijelölhető állapota most már ugyanúgy bemondásra kerül, mint listák vagy fanézetek esetén.
* A Firefox és egyéb Gecko alkalmazások vezérlőelemeinek elemei most már akkor is aktiválhatóak, ha azok valamiért a képernyőn kívülre kerültek. (#801)
-Az NVDA üzenetablakának jelenléte esetén már nem lehet beállítási párbeszédpaneleket megnyitni. Ezek ugyanis lefagyást eredményezhettek. (#1451)
* A Microsoft Excel programban most már nincs lelassulás cellák gyors kijelölése, vagy azok közötti mozgás esetén (pl. egy nyíl billentyű nyomvatartásakor).
* Az NVDA szolgáltatás hibáinak javítása, melyek az NVDA leállását eredményezték Windows bisztonsági képernyőkön.
* Egy hiba javítása, mely változás esetén a braille kijelző megjelenített szövegének eltűnését eredményezte. (#1377)
* Az Internet Explorer 9 letöltési ablaka most már helyesen működik az NVDA programmal. (#1280)
* Most már nem lehet több NVDA folyamatot elindítani. (#507)
* Lassúbb rendszereken az NVDA már nem jeleníti meg főablakát futás közben. (#726)
* Az NVDA már nem omlik össze Windows xp rendszereken WPF alkalmazások használatakor. (#1437)
* A folyamatos felolvasás és folyamatos felolvasás az áttekintőkurzorral már helyesen működik UI automation szerkesztőmezők esetén, melyek támogatják a szükséges funkciókat. Pl. mostantól lehetősége van XPS Viewer dokumentumokat folyamatosan felolvastatni.
* Az NVDA már nem kezel néhány Outlook Express / Windows Live Mail üzenetszabály listaelemet úgy mintha az jelölőnégyzet lenne. (#576)
* Kombinált listamezők most már nem kerülnek felolvasásra úgy, mintha almenüvel rendelkeznének.
* Az NVDA most már helyesen felolvassa a címzetteket a címzett, másolat és titkos másolat mezőkben a Microsoft Outlook programban. (#421)
* Egy probléma javítva, mely az NVDA hangkarakter beállítások párbeszédablakában a csúszkák nem minden változását olvasta. (#1411)
* Az NVDA most már helyesen olvassa fel az új cellatartalmat kivágás és beillesztés esetén. (#1567)
* Az NVDA egyik hibájának javítása, mely minnél több szín felolvasása után egyre helytelenebb információt közölt.
* Az Internet Explorer és egyéb MSHTML vezérlőelemeken most már azok a ritka oldalak is helyesen kerülnek feldolgozásra, melyek ARIA presentation szereppel rendelkező beágyazott kereteket tartalmaztak. (#1569)
* Az Internet Explorer és egyéb MSHTML vezérlőelemeken egy ritka hiba javítása, mely interaktív mód esetén egy többsoros szerkesztőmező és a dokumentum közötti gyors, többszöri fókuszváltozást eredményezett. (#1566)
* A Microsoft Word 2010 programban az NVDA most már helyesen olvassa fel a megerősítő párbeszédablakokat. (#1538)
* Az Internet Explorer és egyéb MSHTML vezérlőelemeken többsoros szerkesztőmezőkben szöveg kijelölése, mely az első sor utáni sorokat érintette most már helyesen kerül felolvasásra. (#1590)
* Szavak közti lépkedés hatékonyabbá tétele, beleértve a windows és html vezérlőelemeket. (#1580)
* Az NVDA telepítő már nem jelenít meg értelmetlen szöveget Hong Kong-i verziójú Windows Vista és Windows 7 használatakor. (#1596)
* Az NVDA már helyesen tölti be a Microsoft Speech API 5 beszédszintetizátort ha az nem rendelkezik hangkarakter lehetőséggel. (#1599)
* Az Internet Explorer és egyéb MSHTML vezérlőelemeken szerkesztőmezők esetén az NVDA már nem lassul le, vagy fagy le ha a braille támogatás engedélyezve van.
* A Firefox programban böngészőmód esetén az NVDA már helyesen dolgoz fel elemeket, melyek az ARIA presentation szereppel rendelkeznek.
* A Microsoft Word programban braille támogatás esetén az első oldal utáni oldalak sorai helyesen kerülnek bemondásra. (#1603)
* A Microsoft Word 2003-as verziójában jobbról balra haladó szöveg ismét felolvastattatható a braille támogatás bekapcsolása esetén. (#627)
* A Microsoft Word programban a folyamatos felolvasás már helyesen működik ha  a dokumentum nem ér véget mondatvégi írásjellel.
* Csak szöveg formátumú üzenet megnyitásakor a Windows Live Mail 2011 programban az NVDA már megfelelően helyezi a fókuszt az üzenetszövegre.
* Az NVDA már nem fagy le a Windows Live Mail másolás/áthelyezés párbeszédablakokban. (#574)
* Az Outlook 2010 programban az NVDA már helyesen követi a fókuszt az üzenetlistában. (#1285)
* Néhány USB kapcsolódási hiba javítva az MDV Lilli braille kijelző használatakor. (#241)
* Az Internet explorer programban és egyéb MSHTML vezérlőelemeken a szóközök már helyesen jelennek meg böngészőmódban. Néhány esetben hiányoztak (pl. egy hivatkozás után).
* Az Internet explorer programban és egyéb MSHTML vezérlőelemeken néhány szükségtelen sortörés már nem jelenik meg. Pl. HTML elemek None stílus esetén nem eredményeznek sortörést. (#1685)

## 2011.1.1

Ez a verzió a 2011.1 verzió több biztonsági és más egyéb hibáját javítja. Erősen ajánlott frissíteni.

### Hiba javítások

* Az adományozás menüpont tiltva lett, amikor az NVDA a bejelentkező paneleket, felhasználói felügyeleti ablakokat és vezérlőelemeket, egyéb biztonsági képernyőket olvassa fel, mivel ez biztonsági kockázatot jelentett. (#1419)
* Nem lehet a felhasználói felügyeleti, biztonsági és bejelentkező ablakokban az NVDA interfésze igénybevételével másolni vagy beilleszteni, mivel ez is biztonsági kockázatot jelentett. (#1421)
* A firefox 4-ben a visszalépés a virtuális kijelzőbe (NVDA+Kontrol+szóköz) most már használható, ez esetben most már rendesen ki kell lépnie a beágyazott objektumból (pl. flash tartalom). (#1429)
* Ha a parancsbillentyűk bemondása be van kapcsolva, az átváltott karaktereket most már nem olvassa fel rosszul vezérlőelemként. (#1422)
* Ha a parancsbillentyűk bemondása be van kapcsolva, most már a program helyesen olvassa a szóköz lenyomása mellett az altot, kontrollt is parancsbillentyűként, nem csupán a shiftet. (#1424)
* A naplózás most már teljesen ki van kapcsolva, ha az NVDA felhasználói felügyeleti, biztonsági vagy bejelentkező képernyők használatakor fut, mivel ez is biztonsági kockázat volt. (#1435)
* A bevitelsúgóban az egyedi billentyű-hozzárendelések is naplózva vannak még akkor is, ha nincsenek valamelyik szkripthez hozzárendelve. (#1425)

## 2011.1

A legfontosabb újdonságok közé tartozik egyes vezérlőelemek színének felolvasása; az új szövegkimenetek automatikus felolvasása a mIRC, PuTTY, Tera Term programokban és a biztonsági képernyőkön (secure crt); általános bővítmények támogatása; felsorolások és számozások felolvasása a Microsoft Wordben; egyéni billentyűparancsok braille kijelzőkhöz, ideértve pl. az egy sorral fel- és lelépést; több Baum, HumanWare és APH braille kijelző támogatása.

### Újdonságok

* Több vezérlőelem színét képes felolvasni a program. Az automatikus felolvasás a dokumentumformázási beálításoknál kapcsolható be. Igény szerint a dokumentum formátumának felolvasása - insert+f - paranccsal is lekérdezhető.
* A virtuális kijelzőkön egy-egy képernyőnyi (shift+pagedown/up) vagy bekezdésnyi (shift+kontroll+le/felnyíl) szöveg is kijelölhető (#639).
* Az NVDA most már automatikusan felolvassa a mIRC, PuTTY, Tera Term és SecureCRT termékekben az újonnan kimenő szövegeket. (#936)
* A felhasználók az NVDA bármely szkriptjében új billentyűparancsokat definiálhatnak vagy a régieket átírhatják egy egyszerű, felhasználóbarát felületen. (#194)
* Az általános bővítmények támogatása: az általános bővítmények új képességekkel ruházzák fel az NVDA-t, melyek bármely alkalmazásban használhatók. (#281)
* Ha a capslock be van kapcsolva és shifttel nagybetűt szeretnénk leütni, az NVDA egy rövid hangjelzéssel figyelmeztet a kisbetűkre. Ez a funkció a billentyűzetbeállításoknál kikapcsolható. (#663)
* Az NVDA felolvassa a Microsoft Wordben az [erős] oldaltöréseket, ha sorról sorra lépkedünk. (#758)
* A felsorolásokat és számozásokat felolvassa az NVDA a Microsoft Wordben, ha sorról sorra lépünk. (#208)
* Mostantól lehetőségünk van az NVDA+shift+S billentyűparanccsal az alvó mód ki- és bekapcsolására az aktív alkalmazásban. Alvó módban az NVDA minden képernyőolvasó funkciója leáll. Ez azoknál az alkalmazásoknál hasznos, melyeknek saját beszédtámogatása és képernyőolvasási funkciója van.
* Számos egyéni braille kijelzőn használható billentyűparancs került a programba. A részletek a kézikönyv Támogatott Braille-kijelzők c. fejezetében olvashatók. (#209)
* A külső fejlesztők igényeinek megfelelően az alkalmazás moduljai, pl. az általános bővítmények, újra betölthetők anélkül, hogy az NVDA-t újra kellene indítani. Ehez használjuk az NVDA menüben az eszközök menü bővítmények újratöltése, vagy az NVDA+Kontroll+F3 billentyűparancsot. (#544)
* Az NVDA már emlékszik egy korábban meglátogatott honlapon az utolsó pozíciónkra, ha visszatérünk  mind addig, amíg a böngészőből vagy az NVDA-ból ki nem lépünk. (#132)
* A Handy Tech braille kijelzők a Handy Tech általános illesztőprogram telepítése nélkül is használhatók. (#854)
* Több Baum, HumanWare és APH kijelzőt is támogat az NVDA. (#937)
* Az NVDA felismeri a media player Classic Home Cinema állapotsorát. 
* A Freedom Scientific Focus 40 Blue braille kijelzője már akkor is használható, ha az bluetoothon keresztül csatlakozik a számítógéphez. (#1345)

### Változások

* Az NVDA már nem olvassa a pozícióinformációkat a menükben, futó programoknál, az értesítési területen és másutt. Ezek gyakran nem a valóságnak megfelelően hangoztak el. Ez a funkció bekapcsolható az objektummegjelenítési beállításoknál.
* A billentyűzet súgót ettől kezdve beviteli súgónak hívják, tekintettel arra, hogy más forrásokból is történhet bevitel.
* A beviteli súgó már nem mondja és írja ki a braille kijelzőkre a szkriptek kódját és helyét, mert ez a felhasználók számára nem lényeges információ. A program ezeket a haladó felhasználók és fejlesztők számára naplózza.
* Ha az NVDA észleli, hogy lefagyott, továbbra is magánál tartja az NVDA módosító billentyűket, a többit viszont átengedi a rendszernek. Erre azért van szükség, hogy a felhasználó, aki nem is észlelte még az NVDA lefagyását, véletlenül ne kapcsolja be a capslock vagy más billentyűket. (#939)
* Ha a billentyűparancs átadása funkció használatát követően a felhasználó egy billentyűt lenyomva hagy, ideértve a billentyűismétléseket is, az NVDA az összes billentyűleütést átadja a rendszernek mind addig, amíg az utolsó billentyűt a felhasználó fel nem engedi. 
* Ha a felhasználó az NVDA módosító billentyűk bármelyikét kétszer gyorsan megnyomja, hogy az NVDA azt átadja a rendszernek és a második leütést nyomva tartja, akkor az összes további leütést át fogja adni a rendszernek az NVDA a nyomva tartás ideje alatt.
* A beviteli súgó már ismerteti a hangerő fel-le és a némító billentyűket. Ez hasznos, ha a felhasználó bizonytalan, hogy melyek ezek.

### Hibajavítások

* Új szótárbejegyzés hozzáadása esetén a párbeszédpanel most már "Új szótárbejegyzés hozzáadása" és nem "Új szótárbejegyzés szerkesztése" műveletet végez. (#924)
* A kivételszótárak párbeszédpanelein most már a helyettesítendő kifejezés és a helyettesítő kifejezés tartalma a szótárbejegyzések listájában nem angolul, hanem a beállított nyelven jelennek meg.
* Az AIMben az NVDA most már a pozícióinformációkat felolvassa a fanézetben .
* A hangbeállítási párbeszédpanelen most már a felnyíl, page up és home növeli, a lenyíl, page up és end csökkenti a beállítandó értéket. Régebben ez fordítva volt, ami nem volt logikus és ellentétes volt a beállítási körrel. 
* Ha az NVDA módosító billentyűt kétszer gyorsan megnyomjuk, de közben egy másik billentyűt is megnyomunk, a program nem adja át a módosító billentyűt a rendszernek a második megnyomásra.
* A központozási billentyűket - írásjeleket - a beviteli súgóban akkor is felolvassa a program, ha egyébként a központozás ki van kapcsolva. (#977)
* A billentyűzet beállításai párbeszédpanelen a billentyűzetkiosztást a program most már a beállított nyelven olvassa, nem pedig angolul. (#558)
* Javítva lett egy hiba, melynek során az NVDA több elemet üresnek észlelt adobe reader dokumentumokban; pl. az Iphone Ios 4.1 felhasználói kézikönyv tartalomjegyzékében a hivatkozásokat.
* "Az aktuális beállítások használata a bejelentkező és egyéb biztonsági képernyőkön" gomb az NVDA általános beállítások párbeszédpanelén most már rögtön az NVDA telepítése után is használható, még akkor is, ha előtte nem jelent még meg bisztonsági képernyő. Előzőleg az NVDA jelezte a művelet sikerességét, de a műveletnek ezen kívül semmi hatása nem volt. (#1194)
* A bekapcsolt UAC-kal rendelkező rendszereken a "Az aktuális beállítások használata a bejelentkező és egyéb biztonsági képernyőkön" gomb az NVDA most már akkor is működik, ha a felhasználó neve szóközt tartalmaz. (#918)
* Az Internet Explorer és egyéb MSHTML vezérlőelemek használatakor az NVDA végső megoldásként az URL címét használja a hivatkozás nevének megállapításakor, üres hivatkozások megjelenítése helyett. (#633)
* Az NVDA már nem hagyja figyelmen kívül a fókuszt az AOL Instant Messenger 7 menükben. (#655)
* A hibák címkéjének helyes bemondása a Microsoft Word helyesírás ellenőrző párbeszédablakában (pl. nincs a szótárban, nyelvtani hiba, írásjel). Előzőleg minden hiba nyelvtani hibaként jelent meg. (#883)
* Írás közben a Microsoft Word alkalmazásban, egy braille kijelző használatakor már nem íródik be értelmetlen szöveg. Ezen kívül egy ritka, lefagyást eredményező hiba is ki lett javítva, a braille kijelző kurzoráthelyező gombjainak használatakor. (#1212) A javítás nem teszi lehetővé Arab szövegek braille kijelzős olvasását a Word 2003 (és elődei) használatakor. (#627)
* A delete gomb használatakor a braille kijelző szövege és kurzora most már helyesen frissül. (#947)
* Dinamikus oldalak változásai Gecko2 dokumentumokban (pl. Firefox 4) az NVDA most már helyesen jeleníti meg a többdokumentumos tartalmat. Előzőleg csak az első dokumentum tartalma frissült. (Mozilla bug 610985)
* Az NVDA most már bemondja a nyelvtani és helyesírási hibákat a Microsoft Word helyesírásellenőrzés ablakában. (#704)
* Az Internet Explorer és egyéb MSHTML vezérlőelemekben az NVDA már nem jelenít meg üres hivatkozásokat helyjelző horgok használatakor. (#1326)
* Az objektum navigálás csoportosított elemekben és azok körül mos tmár helyesen működik és asszimetrikus.
* A Firefox és egyéb Gecko-ra épülő vezérlőelemekben az NVDA már nem szorul be egy alkeretbe, ha az hamarabb betöltődik mint a külső dokumentum.
* Az NVDA most már helyesen jelzi a következő karaktert a numerikus Delete billentyű használatakor. (#286)
* A Windows XP bejelentkező képernyőn a felhasználó ismét helyesen kerül felolvasásra ha az megváltozik.
* Szövegolvasási hibák javítása konzolos ablakokban ha a sorszám bemondás be van kapcsolva.
* Az elemlista most már használható látással rendelkező felhasználók számára is. Minden vezérlőelem megjelenik a képernyőn. (#1321)
* A kivételszótár lista most már használható látással rendelkező felhasználók számára is. A képernyőn megjelenő lista elég nagy minden oszlop megjelenítéséhez. (#90)
* Az ALVA BC640/BC680 braille kijelzők használatakor az NVDA nem hagyja figyelmen kívül a nyomva tartott braille kijelző billentyűket ha időközben egy másik billentyű is lenyomásra kerül.
* Az Adobe Reader X már nem omlik össze a címkézetlen dokumentumbeállítások ablak elhagyásakor, ha a dokumentum még feldolgozás alatt van. (#1218)
* Az NVDA a megfelelő braille kijelzőre vált a mentett beállítások betöltésekor. (#1346)
* A Visual Studio 2008 Project varázsló ismét helyesen működik. (#974)
* Az NVDA helyesen működik nem ASCII karaktereket tartalmazó fájlnevű alkalmazások használata esetén is. (#1352)
* Soronkénti felolvasáskor, sortörések használatakor az NVDA már nem olvassa fel a következő sor első karakterét a jelenlegi sor végén az AkelPad alkalmazásban.
* A Visual Studio 2005/2008 kódszerkesztőjében az NVDA már nem olvassa fel a teljes szöveget billentyűk leütésekor. (#975)
* Az NVDA most már helyesen törli a braille kijelző tartalmát új eszközre váltáskor és kilépéskor.
* A kezdeti fókusz már nem hangzik el kétszer az NVDA elindulásakor. (#1359)

## 2010.2

A jelenlegi kiadás főbb újdonságai közé tartozik az egyszerűbb és jóval hatékonyabb objektum navigálás, virtuális kijelző az Adobe Flash tartalmakhoz, megnövelt hatékonyságú működés és jobb vezérlőelem felismerés az új képernyőhurok technológiának köszönhetően, síkáttekintési mód a képernyő könnyebb áttekintéséhez, az IBM Lotus Symphony dokumentumok támogatása, táblázatfejlécek felismerése a Mozilla Firefox alkalmazásban, valamint hatékonyabb felhasználói útmutató.

### Újdonságok

* A navigátor kurzorral való mozgás egyszerűsítve lett, mert nem lehet már nem elérhető, vagy  csak a látványt segítő objektumokra ugrani.
* Azok az alkalmazások, melyek a Java Access bridge-t használják (ide tartozik az OpenOffice.org is), már ki tudják küldeni a szöveg formázási beállításait.  (#358, #463)
* Amikor az egér egy cella fölött van a Microsoft Excelben, az NVDA bemondja annak tartalmát.
* Azokban az alkalmazásokban, amik a Java Access Bridge-t használják, a párbeszédpanelek szövegei már a megjelenés pillanatában elhangoznak. (#554)
* A Virtuális kijelző mostantól használható adobe Flash tartalom megtekintéséhez. Az objektumok közötti mozgás és közvetlen interakció változatlanul elérhető (interaktív módban). (#453)
* A szerkeszthető mezők vezérlőelemeinek, és a kód szerkesztő teljeskörű támogatása az Eclipse IDE programban a 3.6-os verziótól felfelé. (#256, #641)
* Az NVDA már képes kinyerni a legtöbb, képernyőn megjelenő szöveget. (#40, #643)

> - Ez a funkció lehetővéteszi az NVDA számára az eddig nem elérhető vezérlőelemek szövegeinek felolvasását.
> - Ide tartozik néhány menüelem, ami ikonokat tartalmazott (pl. a Windows Xp társítás menüje) (#151), a szerkeszthető mezők a Windows Live alkalmazásban (#200), a hibák listája az Outlook Expressben (#582), a szerkeszthető mező vezérlőeleme a Textpad programban (#605), listák az Eudora programban, néhány vezérlőelem az Ausztrál E-tax programban és a Microsoft excel képletszerkesztőjében.

* A Visual Studio 2005-2008 kódszerkesztőjének támogatása. A standard verziók használata szükséges, mert ez a funkció az express verziókkal nem működik.  (#457)
* Az IBM Lotus Symphony dokumentumok támogatása.
* Kísérleti Google Chrome támogatás. Kérjük vegye figyelembe, hogy a Chrome képernyőolvasó támogatása messze nem teljes, ezért előfordulhat, hogy ennek javításához az NVDA ecélú továbbfejlesztése szükséges. Ennek kipróbálásához a  Google Chrome 7.0, vagy újabb verziója ajánlott.
* A ki-be kapcsolható gombok (caps lock, num lock és scroll lock) állapotai már megjelennek a braillle kijelzőn, ha be vannak kapcsolva.  (#620)
* A súgóbuborékok kijelzésre kerülnek a braille kijelzőn, amikor azok megjelennek.  (#652)
* Az MDV Lilli braille kijelző driver hozzáadása.  (#241)
* Egy teljes sor vagy oszlop kijelölésekor (shift+szóköz és control+szóköz) az új kijelölés már elhangzik az MS Excel programban. (#759)
* A táblázat sor- és oszlopfejlécek automatikusan felolvashatóak a táblázatok navigálásakor. Ez tetszőlegesen beállítható a dokumentum formázás párbeszédpanelen.
 * Ez jelenleg a Mozilla alkalmazásokban (Firefox 3.6.10 vagy újabb, és Thunderbird 3.1.5 vagy újabb) érhetőek el. (#361)
* Új parancsok a sík áttekintés használatához: (#58)
 * NVDA+7 a numerikus billentyűzeten átvált sík áttekintés módra, ezzel az áttekintő kurzor a jelenlegi objektum pozíciójához kerül. Ebben a módban, az áttekintő kurzor parancsainak használatával, áttekinthető a teljes képernyő (vagy egy dokumentum, ha épp abban tartózkodik).
 * Az NVDA+1 a numerikus számbillentyűzeten az áttekintő kurzornál található szöveg alapján annak objektumára lép, lehetővé téve az objektumok közötti ugrást.
* Az NVDA aktuális beállításai használhatóak a Windows biztonsági képernyőin, pl. a bejelentkező és az UAC képernyőkön. (#730)
* A Mozilla Firefox 4 támogatása
* A Microsoft Internet Explorer 9 támogatása

### Változások

* A folyamatos felolvasás a navigátor kurzorban (NVDA+ numerikus +), az előző térbeli elemre ugrás (NVDA +sift+ numerikus 4) és a következő térbeli elemre ugrás (NVDA+shift+numerikus 6) el lett távolítva a programból.
* Az NVDA szintetizátor választó ablakában már csak a szintetizátor neve jelenik meg a listában. Eddig a név elött a driver neve is megjelent.
* Beágyazott virtuális kijelzők esetén (pl. Flash), az nvda+control+szóköz billentyűparancs segítségével visszaléphet annak szülődokumentumába (pl. a Flash animációt tartalmazó oldalra). Előzőleg az nvda+szóköz volt használatban. Ez a parancs mostantól kizárólag a böngésző/interaktív módok közötti váltást teszi lehetővé.
* Ha a beszédnéző (elérhető az eszközök menüben) fókuszt kapott (pl. rákattintottak) új szöveg nem jelenik meg mindaddig, amíg a fókusz máshova nem kerül. Ez könnyebb kijelölést eredményez (pl. másoláskor).
* A napló néző és a Python konzol teljes méretüvé válik az aktiválásukkor.
* az MS Excel programban, ha a fókusz egy új munkalapra kerül ahol több cella is ki van jelölve, mostantól a kijelölés tartománya hangzik el, az aktív cella helyett. (#763)
* Az eSpeak beszédszintetizátor 1.44.03 verziójának használata.
* Ha az NVDA már fut, parancsikonjának aktiválása az NVDA újraindítását eredményezi.
* A 'az egérkurzornál lévő szöveg bemondása' jelölőnégyzet helyett a jelölőnégyzet 'az egérkurzor követése' nevet kapta, amely jobban illik a 'toggle mouse tracking' szkripthez (NVDA+m). 
* A laptop billentyűzetkiosztás frissítése, mely már tartalmazza az asztali billentyűzetkiosztásban megtalálható parancsokat, valamint jól működik nem angol billentyűzeteken is. (#798, #800)
* A felhasználói útmutató frissítése, melyben a laptop billentyűzetkiosztás dokumentálása mellett egy egységesített billentyűparancs lista is helyet kapott. (#455)
* A liblouis braille translator 2.1.1 verziójának használata. Ez a kínai braille és a nem definiált karakterkódok hatékonyabb kezelését eredményezi. (#484, #499)

### Hiba javítások

* A µTorrent alkalmazásban a torrentek listája nem ismétlődik folyamatosan, valamint nem változtatja meg a fókuszt.
* A torrent tartalmának listájában a fájlok nevei már elhangoznak a µTorrent alkalmazás használatakor.
* A Mozilla alkalmazásokban a kurzor pozíciója mostantól helyesen van felismerve ha az egy üres táblázathoz vagy fanézethez kerül.
* A Mozilla alkalmazásokban a "nincs bejelölve" már helyesen hangzik el bejelölhető vezérlőelemek, pl. Táblázatcellák használatakor. (#571)
* A Mozilla alkalmazásokban a helyesen megírt ARIA párbeszédablakok már nincsenek figyelmen kívül hagyva, és megjelenésükkor felolvasásra kerülnek. (#630)
* Az Internet Explorer és egyéb MSHTML vezérlőelemekben az ARIA level tulajdonság helyesen kerül feldolgozásra.
* Az Internet Explorer és egyéb MSHTML vezérlőelemekben az ARIA szerep kiválasztásra kerül más típusokkal szemben, a könnyebben használható és elvárható élmény fokozásaként.
* Egy ritka összeomlás kiküszöbölése az Internet Explorer programban keretek vagy beágyazott keretek navigálásakor.
* A Microsoft Word dokumentumokban a jobbról balra haladó szövegek (pl. arab) ismét olvashatóak. (#627)
* Jobb lefagyás elkerülés a 64 bites Windows konzolokban hosszú szöveg megjelenésekor. (#622)
* A Skype programot már nem kell újraindítani a kisegítő lehetőségek használatához, ha az előbb lett elindítva mint az NVDA. Előfordulhat, hogy ez a képernyőolvasó tulajdonságot használó programokban is javulást eredményez.
* A Microsoft Word programban az NVDA már nem fagy le az NVDA+b billentyűparancs használatakor, valamint az eszköztár gombjain való mozgáskor. (#616)
* A felolvasás javítása, ha egy szám tizedesvesszője után 0 található, pl. 1,023. (#593)
* Az Adobe Acrobat Pro és Reader 9 programok már nem eredményeznek instabilitást egy dokumentum bezárása, vagy más egyéb művelet elvégzése esetén. (#613)
* A kijelölés mostantól elhangzik a ctrl+a billentyűparancs használatakor egyes szerkeszthető mezőkben, pl. a Microsoft Word programban. (#761)
* A Scintilla vezérlőelemekben (pl. Notepad++), a szöveg már helyesen jelölődik ki, pl. folyamatos felolvasáskor. (#746)
* Ismét lehetőség van egy cella tartalmának felolvasására az áttekintő kurzorral.
* Az NVDA ismét képes soronkénti felolvasásra problémás vezérlőelemekben, pl. Internet Explorer 8 használatakor. (#467)
* A Windows Live Messenger 2009 program mostantól nem lép ki azonnal, ha az NVDA már fut. (#677)
* Webdokumentumok használatakor már nincs szükség a tab billentyű használatára beágyazott objektumokra lépéshez (pl. Flash tartalom), az enter billentyű megnyomása után, vagy ha visszatér egy webdokumentumhoz. (#775)
* Scintilla vezérlőelemekben (pl. Notepad++) a hosszú sorok most már helyesen kerülnek felolvasásra, ha azok a képernyő szélén túlhaladnak. Ez már Braille kijelzőkön is helyesen jelenik meg.
* A Loudtalks alkalmazásban a partnerlista most már hozzáférhető.
* Egy dokumentum URL és "MSAAHTML Registered Handler" attribútumai most már helyesen kerülnek felolvasásra az Internet Explorer és egyéb MSHTML vezérlőelemekben. (#811)
* Az Eclipse fejlesztői környezet fanézeteiben az előző elem most már nem hangzik el.
* Az NVDA most már helyesen működik ha az aktuális könyvtár útvonala nem található a Dll elérési útvonalon (a CWDIllegalInDllSearch registry bejegyzés 0xFFFFFFFF-re állításával). Ez a legtöbb felhasználót nem érinti. (#907)
* A Microsoft Word táblázatnavigációs billentyűparancsainak használatakor a "a táblázat széle" szöveg már nem hangzik el a "csak táblázatban használható" szöveg után. (#921)
* A Microsoft Word alkalmazásban "a táblázat széle" szöveg már helyesen hangzik el (a beállított nyelvnek megfelelően). Előzőleg ez az üzenet mindig angolul történt meg. (#921)
* A virtuális bufferekben az áttekintő kurzor mostantól a teljes dokumentumban mozog, nem pedig csak a fókuszban lévő objektumon belül.
* Az Outlook Express, Windows Mail és Windows Live Mail alkalmazásokban az üzenetszabályok jelölőnégyzet állapota most már helyesen hangzik el. (#576)
* A Windows Live Mail 2010 alkalmazásban az üzenetszabályok leírása most már helyesen hangzik el.

## 2010.1

A  kiadás elkészítésekor elsődleges szempont volt a hibák kijavítása, ezáltal megnövekedett a program stabilitása is.

### Újdonságok

* Az NVDA mostantól elindul hangeszközzel nem rendelkező számítógépeken is. Természetesen ilyenkor csak egy braille kijelzőt vagy a virtuális szintetizátort lehet használni. (#425)
* A jelzőpontok jelzése jelölőnégyzet bekerült a dokumentum formázási beállítások közé. Így a felhasználó ki és be tudja kapcsolni a jelzőpontok bemondását. Az előző stabil verzióban ez alapértelmezetten be volt kapcsolva.
* Az NVDA mostantól bemondja a multimédiás gombokat (pl. play, stop, home page stb) ha a parancsbillentyűk bemondása be van kapcsolva.
* Az NVDA bemondja a kitörölt szót a control+backspace billentyű használatakor a vezérlőelemekben, ha azok támogatják azt. (#491)
* A nyíl billentyűk működnek a Web formator ablakában a weboldalon való navigáláskor. (#452)
* Az NVDA most már képes felolvasni a Microsoft Office Outlook program címjegyzékében található elemek listáját.
* Az NVDA jobban kezeli a beágyazott szerkeszthető (tervező módú) dokumentumokat az Internet Explorer programban. (#402)
* Egy szkript segítségével a kurzor áthelyezhető a navigátor kurzorhoz (nvda+shift+numerikus minusz).
* Lehetőség van az egér jobb és bal gombjának zárolására és feloldására. A shift+numerikus per a bal, a shift+numerikus csillag pedig a jobb egérgombot zárolja és oldja fel.
* Új braille táblák: Német 8 pontos számítógépes braille, német rövidítési fokozat 2, finn 8 pontos számítógépes braille, kínai (Hong Kong, Cantonese), kínai (Taiwan, Mandarin).
* Mostantól lehetőség van az nvda parancsikon létrehozásának letiltására (így a billentyűparancs letiltására is) az NVDA telepítésekor. (#518)
* Az NVDA most már használja az Iaccessible2-t (ha létezik) 64 bites alkalmazásokban. (#479)
* Lehetőség van az NVDA API használatára, aminek segítségével az alkalmazások komunikálhatnak a képernyőolvasóval (pl. szöveg felolvasása és leállítása, a szöveg megjelenítése egy braille kijelzőn, stb)
* Mostantól az információkat és a hibaüzeneteket olvassa az NVDA a windows bejelentkező képernyő használatakor Windows Vista és Windows 7 operációs rendszerek alatt. (#506)
* Az NVDA már támogatja az Adobe Reader alkalmazásban az Adobe LiveCycle-lel fejlesztett interaktív PDF űrlapokat. (#475)
* A Miranda IM alkalmazásban az NVDA automatikusan fel tudja olvasni a chat üzeneteket ha a frissülő tartalom jelzése be van kapcsolva. Három új parancsbillentyű a három legfrissebb üzenetek felolvasására (NVDA+control+számok). (#546)
* Az NVDA már támogatja az Adobe Flash használatával készített szerkesztőmezőket. (#461)

### Változások

* Az NVDA már nem mondja be a kimondottan hosszú start menü billentyűzetsúgó üzenetet Windows 7 alatt.
* A virtuális szintetizátort egy új, beszédnéző váltotta fel. Aktiválásához használja a beszédnéző menüelemet az NVDA eszközök menüjében. A beszédnéző használható, független attól, milyen beszédszintetizátor van használatban.
* A braille kijelzőn lévő üzenetek automatikusan eltűnnek, ha a felhasználó egy változást eredményező billentyűt üt le (pl. fókuszváltozáskor). Előzőleg az üzenetek láthatóak voltak a beállított ideig.
* A fókusz vagy az áttekintő kurzor követése a braille kurzorral (NVDA+control+t) lehetőség most már a braille beállítások párbeszédpanelen is megadható, valamint a beállítások elmentésekor a beállítás is elmentésre kerül.
* Az Espeak beszédszintetizátor frissítve lett az 1.43.03-as verzióra.
* A Liblouis braille fordító frissítve lett az 1.8.0-s verzióra.
* A virtuális kijelzők elemeinek felolvasása az előző karakterre/szóra lépéskor jelentősen hatékonyabban működik. Előzőleg rengeteg szükségtelen információ hangzott el, melyek különböztek a sorok közti mozgáskor hallhatóaktól. (#490)
* A kontrol gomb csak leállítja a beszédet, úgy mint az összes többi gomb, a beszéd megállításához és újraindításához a shift gomb használható.
* A táblázat sor és oszlop száma nem hangzik el a fókusz változásakor, mivel ezek túl hosszuak, és legtöbbször zavaróak.

### Hiba javítások

* Az NVDA mostantól akkor is elindul, ha az UI Automation támogatás elérhető, de egyéb okok miatt nem lehet betölteni. (#483)
* Egy táblázat néha elhangzó teljes sora már nem hangzik el a Mozilla alkalmazásokban. (#482)
* Az NVDA már nem fagy le hosszú időre ha megnyit egy faszerkezetben egy sok elemet tartalmazó ágat.
* A SAPI 5 hangok kilistázásakor az NVDA megpróbálja kiszűrni a hibás hangokat. Előzőleg, ha egy problémás hang szerepelt a listában, az NVDA Sapi drivere néha nem töltődött be.
* A Virtuális kijelzők már figyelembe veszik az objektum billentyűparancsának bemondása lehetőséget (#486)
* A virtuális kijelzőkben egy táblázat fejléceinél a sor és oszlopkoordinátákat az NVDA már helyesen olvassa fel.
* A virtuális kijelzőkben a program most már helyesen mondja be a sor és oszlopkoordinátákat ha egy táblázatból kilépünk, majd ugyanabba a cellába lépünk vissza egy másik táblázatba lépés nélkül. (pl. a fel és le nyíl használatakor egy táblázat első celláján. (#378)
* Az üres sorok a Microsoft Word dokumentumokban és a Microsoft HTML vezérlőelemeken már helyesen jelennek meg egy braille kijelző használatakor. Előzőleg az NVDA az aktuális mondatot, nem pedig az aktuális sort jelenítette meg. (#420)
* Összetett hibajavítás történt a windows bejelentkező és a többi biztonsági képernyő kezelésében
* A kurzor követi a folyamatos felolvasáskor a szöveget a Windows szövegmezőiben, és a Microsoft Word dokumentumokban. (#418)
* A virtuális kijelzőkben a kattintható elemek és képhivatkozások szövegei már nem kerülnek felolvasásra ha azok a képernyőolvasók számára nem fontosként vannak megjelölve. (#423)
* Javítások a laptop billentyűzetkiosztáshoz. (#517)
* Ha a braille kurzor az áttekintőkurzort követi egy konzol ablakban, az áttekintő kurzor most már helyesen olvassa fel a szöveget.
* A teamtalk 3 és Teamtalk 4 Classic alkalmazásokban a főablakban található VU meter folyamatjelző változásait az NVDA most már nem olvassa fel, ahogy az változik. A program bejövő chatüzenetek ablakában a speciális karakterek most már helyesen felolvashatóak.
* A Firefox 3.6 alkalmazásban az ugyanarra az oldalra mutató hivatkozások aktiválásakor a kurzor a megfelelő pozícióhoz kerül.
* Az NVDA már nem olvassa fel kétszer a Windows 7 Start Menü elemeit. (#474)
* Néhány PDF dokumentum tartalma hibásan töltődött be az Adobe Reader alkalmazásban, a hiba javítva.
* Az NVDA mostantól nem mondja be hibásan a kötőjellel elválasztott számokat, pl. 500-1000. (#547)
* A Windows XP operációs rendszer használatakor az NVDA már nem okozza az Internet Explorer lefagyását a Windows Update jelölőnégyzeteinek használatakor. (#477)
* A beépített eSpeak szintetizátor és az NVDA hangjelzések együttes használata mostantól már nem eredményezik néhány rendszer lefagyását. Ez legfőképp nagyméretű adat másolásakor volt észrevehető a Windows Explorer alkalmazásban.
* Az NVDA már nem jelzi ha egy háttérben lévő Firefox dokumentum épp betöltés alatt áll (pl. az oldal frissülésekor). Ez az előtérben lévő alkalmazás állapotsorának felolvasását is eredményezte.
* Amikor megváltozik a billentyűzet kiosztás (alt+shift, vagy ctrl+shift), az NVDA az új kiosztás teljes nevét a braille kijelzőn is megjeleníti, ez eddig csak a beszédben történt meg. Ezen kívül néhány nyelvnek nem jelent meg a neve a billentyűzet kiosztás megváltozásakor.
* Ha a táblázatok jelzése ki van kapcsolva, a táblázat információi nem hangoznak el a fókusz változásakor.
* Néhány szokásos fanézet vezérlőelem a 64 bites alkalmazásokban (pl. A tartalom fanézet a Microsoft HTML súgóban) most már támogatott. (#473)
* Néhány a nem ASCII karaktereket tartalmazó üzenetek naplózásakor bekövetkező hiba javítva. Ezek a hibák esetenként téves információt naplózhatnak nem angol rendszereken. (#581)
* Az NVDA névjegye a felhasználó alapértelmezett nyelvi beállításai szerint jelenik meg, egy időben a nem angol rendszereken is angolul jelent meg.(#586)
* A hangkarakter megváltoztatása esetén az NVDA már nem jelez hibát, ha az aktuális hangkarakter kevesebb beállítási lehetőséggel rendelkezik, mint az előző.
* A Skype 4.2-es verziójában a partnerek nevei már nem hangoznak el többször a partnerlistában.
* Fontos javítások a virtuális kijelzők és a felhasználói felület memória kezelésében. (#590, #591)
* Hibajavítás Néhány sapi 4 szintetizátorhoz, melyek az NVDA instabilitását, esetenként lefagyását okozták. (#597)

## 2009.1

A legfontosabb fejlesztések közé tartozik a 64 bites  Windows támogatása; nagy mértékben fejlődött a Microsoft Internet Explorer és Adobe Reader dokumentumok használata; a Windows 7 támogatása; A Windows bejelentkező képernyő olvasása, control+alt+delete és az User Account Control (UAC) képernyők használata; az Adobe Flash és Sun Java tartalmak elérése a weboldalakon.   Stabilitási és egyéb javítások történtek a felhasználói élmény fokozása érdekében.

### Újdonságok

* A 64 bites operációs rendszerek támogatása (#309)
* A Newfon beszédszintetizátor drivere is hozzálett addva a programhoz. Megjegyzés: ez egy speciális változata a szintetizátornak(#206)
* A virtuális kijelzőknél a fókusz és az interaktív mód változását képes hangjelzéssel jelezni az NVDA. Ez egy alapértelmezett beállítás, de átállítható a Virtuális kijelző beállításánál.
* Az NVDA nem fejezi be a hosszabb szövegeket, amikor a felhasználó megváltoztatja a számítógépének hangerejét a billentyűzetről. Így mindig hallja az aktuális hangerőt. (#287)
* Teljesen újraíródott a Microsoft Internet explorer, és az Adobe Acrobat dokumentumok kezelése. Egységesítették a Mozilla Gecko motorjával, így gyorsabb lett az oldalak betöltése,  elérhetőek lettek az átfogó billentyű parancsok, a linkek listája, és a braille támogatás is.
* A vezérlőpulltban a dátum-idő beállításai párbeszédpanelen található dátumváltoztató vezérlőt a program jobban kezeli.
* A Vista és az XP modern startmenüjét a program jobban kezeli (különösen a "minden program" és a "helyek" menüt). Immár a megfelelő menüszint-információt is bemondja.
* Az egér beálításai párbeszédpanelen beállítható, hogy az egér mozgatásakor egyszerre mennyi szöveget mondjon a program: egy karaktert, szót, sort vagy egy egész bekezdést. 
* Már a kurzor alatti szövegben is jelzi az NVDA a helyesírási hibákat a Wordben.
* Már támogatja a program a Word 2007 helyesírás-ellenőrzőjét is. A későbbiekben részleges támogatás a korábbi Word-verziókhoz is készülhet.
* A Windows Live Mail támogatása: az egyszerű, és a html szöveges üzenetek is olvashatóak.
* Az NVDA jelzi, ha a felhasználó a Vistában az ún. "biztonságos asztal"-ra lép, mert például egy felhasználói fiók felügyeleti ablak felbukkan, vagy mert megnyomták a kontrol-alt-del kombinációt. Az NVDA még ezt a "biztonsági asztalt" nem tudja ugyan kezelni, de legalább tájékoztatja a felhasználót.
* AZ NVDA a parancssorablakban is képes felolvasni az egérmutató alatti szövegeket.
* Az UI Automation támogatása az elérhető UI Automation client API segítségével, valamint megnövelt hatékonyság Windows 7 alatt.
* Az NVDA beállítható úgy, hogy elinduljon a windows bejelentkezése után. A beállítás az általános beállítások párbeszédablakban található.
* Az NVDA képes felolvasni biztonsági képernyőket, pl. a Windows bejelentkezési képernyőjét, a control+alt+delete és UAC képernyőket a Windows XP-től kezdve. A windows bejelentkező képernyő felolvasása beállítható az általános beállítások párbeszédablakban. (#97)
* Driver az Optelec ALVA BC6 sorozatú braille kijelzőkhöz.
* Weboldalak böngészésekor az n és a shift+n billentyűkombinációk használhatóak hivatkozásblokkok átugrásához.
* A hivatkozáslista párbeszédpanel egy elemlista párbeszédablakká vált, amely szintén kilistázza a címsorokat és jelzőpontokat. Az elemek hierarchikusan vannak ábrázolva. (#363)
* Weboldalak böngészése közben az NVDA felismeri az ARIA jelzőpontokat, valamint a d és shift+d billentyűparancsok használhatóak a közöttük való mozgáshoz. (#192)
* Az új elemlista párbeszédablak gépeléskor szűri az elemeket. A backspace billentyűvel törölhető a szűrő tartalma. (#173)
* Az NVDA hordozható verziója az 'userConfig' könyvtárban tárolja a felhasználók beállításait. Csakúgy mint a telepíthető verzió, ezen túl a hordozható verzió is külön mappában tárolja a beállításokat.  
* Az egyéni szkriptek, braille kijelző driverek és a szintetizátor driverek a felhasználó beállításainak mappájában tárolódnak.
* A virtuális kijelzők a háttérben kerülnek feldolgozásra, hatékonyabb kommunikálást lehetővé téve a rendszerrel. Ha a kijelző feldolgozása több mint egy másodpercet vesz igénybe, az NVDA erről tájékoztat.
* Ha az NVDA valamilyen oknál fogva lefagy, a billentyűk automatikusan a rendszernek lesznek továbbítva, megnövelve a hatékonyabb helyreállást.
* Az ARIA fogd és vidd támogatása a Mozilla Gecko-ban. (#239)
* A dokumentum címe és a jelenlegi sor vagy a kijelölés felolvasásra kerül amikor a fókusz megváltozik egy virtuális kijelzőben. Ez a viselkedés megegyezik a normál dokumentum objektumokéival. (#210)
* Magyar 8 pontos braille támogatás
* A Java Access Bridge támogatással rendelkező alkalmazásokban (többek között az OpenOffice.org) az NVDA jól működik a sorszámok használatakor.
* A virtuális kijelzőkben az o és a shift+o billentyűkkel a beágyazott objektumok között lehet mozogni.
* Az NVDA együttműködik az adminisztrátori joggal futó alkalmazásokkal (Windows Vista és későbbi operációs rendszerek). Ez csak az NVDA hivatalos verziójában működik, hordozható és snapshot verziókban nem. (#397)

### Változások

* Az indító és a kilépő hangjelzések mostantól a kiválasztott hangeszközön hallhatók, az eddigi windows alapértelmezett hangeszköz helyett. (#164)
* Az NVDA nem mondja be a "Az NVDA elindult" szöveget induláskor.
* A folyamatjelzők felolvasását továbbfejlesztették. A legfontosabb, hogy most már be lehet állítani az NVDA-t úgy, hogy a folyamatjelzők változását egyszerre beszéddel és hanggal is jelezze.
* Néhány általános elem, pl. Ablak, alkalmazás és keret mostantól nem hangzik el, hacsak a vezérlőelem nincs feliratozva.
* Az áttekintő szöveg másolás parancs (NVDA+f10) mostantól nem okoz hibát ha a kijelölés vége a kijelölés kezdete előtt található. Előzőleg ez problémákat okozott egyes alkalmazásokban, mint pl. A Notepad++.
* A navigatorObject_currentDimentions szkript új billentyűparancsa a NVDA+numerikus Delete. A régi kombináció nem működött minden billentyűzeten. A szkript mostantól bemondja az objektum szélességi és magassági adatait, az alsó és a jobb oldali koordináták helyett.
* Hatékonyabb működés (különösen netbookokon) ha több hangjelzés hallható egyszerre, pl. Gyors egérmozgáskor ha a hangjelzés engedélyezve van. (#396).

### Hiba javítások

* Amikor az NVDA a 8.3-as Dos alól fut, aminek egy összefüggő hosszú címe van (pl progra~1 program files helyett), az NVDA felismeri ezt, és betölti helyesen a felhasználói beállításokat.
* A háttérben lévő ablak címének bemondása (NVDA+T) nem működött jól a menükben.
* Brailleben nem mutatja a használhatatlan információkat az összefüggő címkétlen mezőkben.
* A felesleges információk bemondásának leállítása, amikor a fókusz változik, ilyenek a root, a layered, és a scroll mezők a Java vagy a Lotus alkalmazásokban.
* A Windows súgó megjelenítőjében (Chm) a kulcsszókereső sokkal jobban használható. Már nem olvassa fel a program a kulcsszót gépelés közben, mintha az álandóan változó szöveg lenne.
* Helyesen olvassa az NVDA a Wordben az oldalszámozást, ha az az alapbeállítástól eltérően van megadva.
* A program jobban kezeli a Word párbeszédpanelein lévő szerkesztőmezőket, pl. a betűtípus-választót. Így már a nyilakkal is lehet vezérelni ezeket.
* Jobb támogatás a DOS parancssoros ablakokhoz. Az NVDA már képes felolvasni különleges ablakokat, melyeket üresnek vélt. A control+break megnyomásakor az NVDA már nem zárul be.
* Windows Vista alatt , az NVDA telepítő az nvda-t normál felhasználói jogokkal indítja el a befejező képernyőn lévő jelölőnégyzet bejelölésével.
* A Backspace megfelelően működik szavak bemondása esetén. (#306)
* Hibás "Start menü" bemondása egyes helyi menük esetén a Windows Explorer és a Windows shell használatakor. (#257)
* Az NVDA helyesen kezeli az ARIA címkéket a Mozilla Gecko-ban amikor nincs más hasznos tartalom. (#156)
* Az NVDA már nem engedélyezi automatikusan az interaktív módot olyan szerkesztőmezőknél, melyek dinamikusan frissítik tartalmukat amikor a fókusz megváltozik; pl. https://tigerdirect.com/. (#220)
* Az NVDA megpróbál helyreállni néhány esetben, amelyek ezelőtt a program teljes lefagyását eredményezték. Ez tíz másodpercet vehet igénybe.
* Az "User default" beállítása esetén az NVDA mostantól a Windows megjelenítési nyelvét veszi figyelembe, a területi beállítások helyett. (#353)
* Az NVDA mostantól felismeri a vezérlőelemeket az AIM 7 programban.
* A billentyűparancs átadása parancs nem aktiválódik végérvényesen egy billentyű nyomva tartásakor. Előzőleg, ha ez bekövetkezett, az NVDA nem vett figyelembe billentyűleütéseket és a hibát csak a program újraindításával lehetett orvosolni. (#413)
* A tálca mostantól nincs figyelmen kívül hagyva ha a fókusz rákerül, amely gyakran megtörténik egy alkalmazásból való kilépés esetén. Az NVDA előzőleg úgy viselkedett, mintha a fókusz nem változott volna meg.
* Egy adott vezérlőkarakter (0x1) többé nem okoz furcsa viselkedést (mint pl. A magasság és a hangerő megváltozása) ha előfordul egy szövegben. (#437).
* A kijelölt szöveg bemondása parancs (NVDA+shift+fel nyíl) közli ha egy objektumban a szövegkijelölés nem támogatott.
* Egy hiba kijavítva a Miranda-IM szkriptben. Miranda-IM specifikus gombokon vagy hivatkozásokon az enter megnyomása az NVDA lefagyását eredményezte. (#440)
* Az aktuális objektum betűzése vagy másolásakor a navigátor kurzor használata esetén az aktuális sor vagy kijelölés nem volt figyelembe véve.
* Egy hiba kijavítva ahol az NVDA értelmetlen szöveget olvasott fel hivatkozás vezérlőelemeknél a windows és az Internet explorerben. (#451)
* Egy hiba kijavítva a dátum bemondásakor (NVDA+F12), egyes rendszereken eddig csonkítva hangzott el (#471)

## 0.6 P3

### Újdonságok

* A Microsoft Excel képlet sáv nem használható az NVDA-val, ennek érdekében be lett építve egy párbeszédpanel, mely megjelenik, ha a felhasználó F2-t nyom egy cellában.
* Formázás támogatása IAccessibble2 szöveges vezérlők esetében, például Mozilla alkalmazások.
* Ahol lehetséges, jeleztethetők a gépelési hibák. A beállítás a dokumentum formázási beállításoknál érhető el.
* Beállítható, hogy mindegyik, vagy csak bizonyos folyamatjelzőket jelezze az NVDA hangokkal. Például megadható, hogy csak 10%os változásnál legyen hangjelzés.
* A hivatkozások felismerhetők richedit vezérlőkben.
* Az egérkurzor elmozdítható az áttekintő kurzor alatt lévő karakterhez a legtöbb szerkeszthető  szöveges vezérlő esetében. Korábban csupán a vezérlő közepére lehetett navigálni.
* A virtuális kijelzőkben az áttekintő kurzor mostantól képes felolvasni a kijelzőben lévő szöveget, az egy adott elemen lévő navigátor kurzor belső szövege helyett (amely gyakran nem túl hasznos a felhasználó számára). Ez azt jelenti, hogy mostantól lehetőség van hierarchikusan bejárni a kijelzőt a navigátor kurzorral, az áttekintő kurzor követni fogja azt.
* A Java vezérlőelemek további állapotainak támogatása.
* NVDA+t kétszeri gyors leütésre az NVDA lebetűzi az aktuális ablak címsorát, gyors háromszori leütésnél a vágólapra másolja azt.
* A billentyűzetsúgó felolvassa a módosító billentyűk nevét, amennyiben egyedüliként vannak lenyomva.
* A billentyűzetsúgó által használt billentyűnevek lefordíthatóak.
* SiRecognizer-ben a felismert szövegmező elérhető az NVDA-val. (#198)
* Braille kijelzők támogatása.
* NVDA+c felolvassa a vágólap szöveges tartalmát. (#193)
* Ha az nvda automatikusan interaktív módba vált, az escape billentyű használható a böngésző módba váltáshoz. Az NVDA+szóköz változatlanul használható. 
* A virtuális kijelzőben a fókusz megváltozásakor és kurzor mozgásakor az NVDA automatikusan vált a böngésző- és az interaktív módok között, a kurzor alatti vezérlőelemnek megfelelően. Ez beállítható a virtuális kijelző párbeszédablakban. (#157)
* Újraírt SAPI4 szintetizátor driver, amely a sapi4serotek és a sapi4activeVoice drivereket hivatott felváltani, valamint kijavítja az ezek használatából adódó hibákat.
* Az NVDA alkalmazás mostantól tartalmaz egy manifest-et, amely hatására a program már nem kell hogy kompatibilis módban fusson Windows Vista alatt.
* Néhány szerkesztőmező támogatása a pinacle tv szoftverben.
* Az NVDA a beállításfájlt és a kivételszótárak fájljait a felhasználó application data könyvtárába menti, ha az NVDA a telepítő verzióval lett feltelepítve. Ez Windows Vista alatt szükséges, valamint lehetővé teszi a többfelhasználós módot (külön beállítás minden NVDA felhasználónak).
* Pozícióinformáció az IAccessible2 vezérlőelemekhez.
* Mostantól lehetőség van az áttekintő kurzorral szöveget másolni a vágólapra. Az NVDA+f9 beállítja a kezdőpontot az áttekintő kurzor aktuális pozíciójához. Az NVDA+f10 kinyeri a szöveget a kezdőponttól az áttekintő kurzor aktuális pozíciójáig. (#240)
* A hosszabb kijelölések felolvasásakor (512 karakter vagy több), az NVDA a kijelölés szövege helyett a kijelölt karakterek számát olvassa fel. (#249)

### Változások

* Espeak támogatásának javítása néhány Windows Vista meghajtóprogrammal.
* Ha a beállított hangeszköz a beállítás szerint a Windows alapértelmezett hangeszközét használja (Microsoft hangleképző), az NVDA az alapértelmezett hangeszközre irányítja a beszédet és a hangokat, ha módosul a beállítás. Pl: az NVDA egy USB hangeszközt fog kimeneti eszközként használni, ha ez lesz az alapbeállítás, és csatlakoztatva van.
* A címsorok, hivatkozások, listák, táblázatok, idézet blokkok jelzésének beállítása a dokumentum formázási beállításoknál érhető el. Korábban a virtuális kijelzőkhöz ezen beállítások a virtuális kijelző beállításainál volt elérhető. Mostantól minden dokumentum ugyanazokat a beállításokat használja.
* A beszédsebesség mostantól az alapértelmezett beállítás a beszédszintetizátor beállításai körön.
* Szkriptek betöltésének és leállításának javítása.
* A virtuális kijelző megkerülése be- és kikapcsolva helyett az NVDA mostantól interaktív módot (megkerülés bekapcsolva) és böngésző módot (megkerülés kikapcsolva) mond.
* A beállításfájlban a hangok mostantól azonosítójuk alapján és nem az indexük alapján kapnak helyet. Ennek hatására a beállítás több számítógép használata esetén is megbízható. A változtatás hatására bekerülhet egy hiba a naplóba az első használatkor. (#19)
* A fanézet elemeinek szintje mostantól elsőként kerül felolvasásra minden fanézetben. Előzőleg ez csak windows (SysTreeView32) fanézeteknél működött.

### Hiba javítások

* Távoli asztali szerveren Espeakkal használva az NVDA-t, a hangok utolsó részei nem tűnnek el.
* Hibák javítása a kivétel szótárak mentésénél bizonyos hangokhoz.
* Mozilla Gecko virtuális kijelzőkben jobb navigálhatóság amennyiben nem soronként, szavanként, stb. navigál egy hosszú szöveges dokumentumban. (#155)
* Ha a begépelt szavak kimondása engedélyezve van, a szó felismerése "ENTER" leütésekor.
* Néhány karakterbeállítási hiba  javítva richedit dokumentumokban.
* Az NVDA naplómegjelenítő richedit vezérlőt használ a napló megjelenítéséhez. Ezáltal lehetőség van szavankénti léptetésre az NVDA-val.
* Hibák javítása beágyazott objektumoknál richedit vezérlők  esetében. 
* Oldalszámok jelzése Microsoft Word dokumentumokban. (#120)
* Mozilla Gecko virtuális kijelzőben tabbal navigálva egy bejelölt jelölőnégyzetre, azon szóközt ütve, az NVDA közli, hogy a jelölőnégyzet nincs bejelölve.
* Részlegesen jelölt jelölőnégyzetek jelzése Mozilla alkalmazásokban.
* Ha a kijelölt szöveg mérete lecsökken vagy megnövekedik, a kijelölést mostantól egy darabban olvassa fel, kettő helyett.
* Egérrel történő felolvasásnál a Mozilla Gecko szerkesztőmezők tartalma is felolvasásra kerül.
* Say all használatakor bizonyos Sapi5 beszédszintetizátorok korábban lefagytak.
* a szabványos windows vezérlőelemekben mostantól az NVDA felolvassa a kijelölést, ha a fókusz nem változott meg az nvda elindítása után.
* Egér görgetésének javítása Java objektumokban. (#185)
* Az NVDA már nem jelzi a Java fanézetekben, hogy egy objektumnak nincsenek gyermekelemei, ha az be van zárva.
* Az NVDA+t hatására csak az aktív alkalmazás címe lesz felolvasva, nem a teljes objektum. Amennyiben az előtérben lévő alkalmazásnak nincs látható címsora, annak folyamatneve kerül felolvasásra.
* Objektum jelzése ha egy Java alkalmazás kerül előtérbe. Korábban csak a felsőszintű Java objektum lett jelezve. 
* Az eSpeak szintetizátor nem némul el hiba esetén.
* A hangprobléma kijavítva, amely során a hangkarakter tulajdonságai (sebesség, magasság, stb.) nem lettek elmentve a szintetizátor gyorsbeállításának használatakor.
* A szavak és betűk megnövelt hatékonyságú felolvasása.
* néhány szöveg nem hangzott el néhány parancssoros alkalmazás használatakor (pl. kalandjátékok), kijavítva.
* Az NVDA mostantól figyelmen kívül hagyja a fókuszváltozást a háttérben lévő ablakokban. Előzőleg egy ilyen változás az igazi fókusz változását is eredményezhette.
* A kurzor hatékonyabb észlelése helyi menük bezárásakor. Előzőleg az NVDA gyakran nem reagált ilyen menük elhagyásakor.
* Az NVDA mostantól felolvassa ha a helyi menü aktiválódik a start menüben.
* A klasszikus start menü használatakor a start menü start menüként lesz felolvasva, alkalmazás menü helyett.
* A figyelmeztetések felolvasásának hatékonysága megnövekedett egyes alkalmazásokban, pl. Mozilla Firefox. A figyelmeztetés tartalma már nem fog többször elhangzani, valamint egyéb, felesleges információ is mellőzve lesz. (#248)
* A csak olvasható, fókuszálható szerkesztőmezők tartalma már nem lesz automatikusan felolvasva a párbeszédablakok szövegével. Ez kijavítja a licensz szerződés automatikus felolvasását telepítőprogramokban.
* Az NVDA már nem mondja be a kijelölés megszűnését néhány szerkesztőmezőben (pl. Internet Explorer címsor, Thunderbird 3 email címmezők).
* Szöveges emailek megnyitásakor az Outlook Express és Windows Mail programokban a fókusz már helyesen rákerül a szerkesztőmezőre. Előzőleg a felhasználó a tab billentyűvel, vagy egérkattintással a mezőn tudta használni a nyíl billentyűket.
* Több nagymértékű hiba kijavítva a "parancsbillentyűk bemondása" funkcióban.
* Az NVDA már képes 65535 karakternél több szöveg felolvasására szabványos szerkesztőmezőkben (pl. egy nagy fájl jegyzettömben).
* Megnövelt hatékonyságú sorfelolvasás az MSHTML szerkesztőmezőkben (Outlook Express szerkeszthető üzenetek és Internet Explorer beviteli mezők).
* Az NVDA már nem fagy le néha szövegszerkesztéskor az OpenOffice alkalmazásban. (#148, #180)

