# नेत्रवाणी NVDA_VERSION उपभोक्ता निर्देशिका

[TOC]

<!-- KC:title: नेत्रवाणी नेत्रवाणी_संस्करण कुञ्जीपाटी आदेशको छरितो सन्दर्भ -->



## परिचय {#toc2}

नदेख्नेहरूको डेस्कटपमा पहुँच (Non Visual Desktop Access) ले संश्लेषित वाचन एवम् ब्रेल पटलको माध्यमबाट पृष्ठपोषण प्रदान गर्दै सन्झ्याल सञ्चालन प्रणाली र अन्य
कतिपय अनुप्रयोगहरू समेतका पाठहरूलाई वाचन गर्छ । यसले दृश्य विहीन र अल्प दृष्यक व्यक्तिहरूलाई देख्ने व्यक्तिहरू सरह नै (कुनै थप लागत बिना) कल्पयन्त्रको माध्यमले आधुनिक सूचना प्रविधिमा पहुँच पुर्याउँछ ।
[NV Access](https://www.nvaccess.org/), ले यसमा आबद्ध समुदायको योगदानमा नेत्रवाणीको विकास गरेको हो ।

### सामान्य सुविधाहरू {#toc3}

नेत्रवाणीले दृश्य हीन र अल्प दृष्यक व्यक्तिहरूलाई कल्पयन्त्रमा विन्डो सञ्चालन प्रणाली र अरू धेरै तेस्रो पक्षका अनुप्रयोगहरूमा पहुँच र अन्तरक्रिया को सुविधा पुर्याउँछ

प्रमुख विशेषताहरू:

* अफिस प्याकेज, ईमेल, ईन्टरनेट र वेभ खोल्ने जस्ता लोकप्रिय अनुप्रयोगहरूलाई समर्थन गर्ने
* शंस्लेषित आवाजको माध्यमले ८०  भन्दा बढी भाषाहरूमा पहुँच पुर्याउन सकिने ।
* वर्णाकृतिको आकार, नाम, शैली र हिज्जे गल्ती जस्ता पाठहरूको स्वरूपको जानकारी दिने ।
* सुलसुलेको मुनि पर्ने पाठहरूलाई स्वतः वाचन गर्ने र ऐच्छिक रूपमा यसको स्थानको जानकारी लीन सकिने ।
* अधिकांश ब्रेल पटलहरूलाई समर्थन गर्ने ।
* स्थापकको अनिवार्य आवश्यकता नपर्ने । सबै कार्य छेस्को भकारीबाटै अथवा अन्य बहनीय माध्यमको पनि प्रयोग गरी चलाउन सकिने ।
* सहजै प्रयोग गर्न सकिने वाचक स्थापकको उपलब्धता ।
* ४७ भाषामा अनुवादित भई सकेको ।
* आधुनिक ३२ वीट वा ६४ वीटको सन्झ्याल सञ्चालन प्रणालीलाई समर्थन गर्ने ।
* सन्झ्याल आरम्भ र अरू सुरक्षित पर्दामा पनि उपलब्ध हुने ।
* माइक्रोसफ्ट सक्रिय पहुँच ता, जाभा पहुँच पुल र UI स्वचालित जस्ता सामान्य पहुँच ता प्रदर्शक लाई समर्थन गर्ने सन्झ्याल ७ र अरू प्रणालीमा समर्थन गर्ने ।
* सन्झ्याल आदेश Prompt र console अनुप्रयोगहरू लाई समर्थन गर्ने ।

### अन्तर राष्ट्रियकरण {#toc4}

यो कुरा महत् पूर्ण छ कि संसारको जुनसुकै भाषा बोल्ने मानिसहरू हुन् उनीहरूको भाषामा प्रविधिमा समान पहुँच हुनु पर्छ । 
नेत्रवाणी मूल रूपमा अंग्रेजी भाषामा विकास गरी नेपाली सहित ४७ भाषामा अनुवाद भई सकेको छ । :हाल सम्म अरबी, अफ्रिकी, अल्बानी, अम्हेरीक, अर्ग्यानिज, आइस्ल्याणडेली, ईटाली, क्याटानेली, कोरियाली, क्रोएशियाई, कोलम्बीयाली स्पेनी, ग्रिक, चेक, छिनिया (पारम्परिक र सरलीकृत दुबै), जर्मनी, जर्जियन, जापानी, डेनमार्केली, डच, तामिल, तुर्कि, थाई, नर्बेजीयाली, पञ्जाबी, पुर्तगाली, पोल्याण्डेली, फारसी, फिनिश, फ्रान्सेली, गैलिशियन्, ब्राजिलियन पुर्तगाली, बुल्गेरीयाली, वियतनामी, यूक्रेनी, रूसी, रोमानियाली, सर्भियालि, स्लोवाकी, स्भानेली, स्पेनिश, स्वडेनेली, हिन्दी, हङ्गेरीयाली, हिब्रु मा अनुवाद भई सकेको छ ।

### वाचन संश्लेषक समर्थन {#toc5}

नेत्रवाणीले धेरै भाषाहरूमा सन्देश, निर्देशन र अन्तराकृति का मेनुहरू, देखाउन वा बताउनका अतिरिक्त, यसले उपभोक्ताले चाहेको अरू धेरै भाषामा लेखिएका पाठहरू पढ्न सक्छ । तर यसका लागी उक्त भाषाका अक्षरहरूलाई पहिचान गरी पढ्न सक्ने शंश्लेषक वाचक भने राखेको हुनु पर्छ ।

नेत्रवाणी [eSpeak](https://espeak.sourceforge.net/) नामक एउटा निःशुल्क, खुल्ला श्रोत युक्त बहु भाषिक संश्लेषित वाचक सहित उपलब्ध हुन्छ ।

नेत्रवाणीले समर्थन गर्ने अरू संश्लेषित वाचकहरूको बारेमा 'समर्थित संश्लेषक वाचक खण्डमा हेर्नु होला ।

### ब्रेलको समर्थन {#toc6}

नेत्रवाणीले ताजकि योग्य ब्रेल पटलमा पाठ वा सूचनाहरू ब्रेल लिपिमा उपलब्ध गराउँछ ।
कृपया नेत्रवाणीले समर्थन गर्ने ब्रेलहरूको जानकारीको लागि [समर्थित ब्रेल पटल](#SupportedBrailleDisplays) खण्डमा हेर्नु होला ।

नेत्रवाणीले नेपालीका अतिरिक्त विभिन्न भाषाका खुम्चिएका अथवा नखुम्चिएका ब्रेल संहिता र कल्पयन्त्र ब्रेल संहिता लाई समर्थन गर्छ ।

### इजाजत र प्रतिलिपि अधिकार {#toc7}

नेत्रवाणी प्रतिलिपि अधिकार नेत्रवाणी योगदान कर्ताहरू ।

नेत्रवाणी GNU सामान्य सार्वजनिक इजाजत (संस्करण २) मातहतमा पर्दछ ।
तपाइ यही इजाजतका “ “सर्तहरू लागू हुने र चाहना गर्ने लाई उपलब्ध हुने गरी सबै श्रोत कोड खुल्ला राखेर यो “ “यन्त्र प्राणलाई आफूले चाहे अनुसार हेरफेर वा बाँडचुँड गर्न स्वतन्त्र हुनु हुन्छ । यो नियम यस यन्त्र “
“प्राणको सुरुको वा परिवर्तित दुबै प्रतिमा एवम् यसका कुनै पनि सह-उत्पादनमा उतिकै रूपमा लागू ““हुन्छ ।”
यो इजाजतको पूर्ण पाठ र “विस्तृत जानकारीका लागि https://www.gnu.org/licenses) मा भ्रमण गर्नु होला ।

## आवश्यक प्रणाली {#toc8}

* सञ्चालन प्रणाली 32-bit र 64-bit सन्झ्याल संस्करण, XP, Vista र सन्झ्याल ७, ८.१, १०  (सर्बर प्रणाली सहित) ।
 * सन्झ्याल XP ३२-विट का लागि, नेत्रवाणीलाई Service Pack २ अथवा पछिल्लो चाहिन्छ ।
 * सन्झ्याल सर्बर २००३ का लागि, नेत्रवाणीलाई Service Pack १ अथवा पछिल्लो चाहिन्छ ।
* भण्डार: २५६ mb अथवा बढी
* Processor को गति १.० ghz अथवा तीव्र
* कम्तीमा ५० MB को भकारी ।

## नेत्रवाणीको प्राप्ति र अनुकूलता {#toc9}

तपाइले हालसम्म नेत्रवाणीको प्रति पाउनु भएको छैन भने [www.nvaccess.org](NVDA_URL) ठेगानामा भ्रमण गर्नु होला ।

डाउनलोड भन्ने खण्डमा भ्रमण गर्नु भयो भने तपाइले डाउनलोडको लिङ्क पाउनु हुनेछ । सबै भन्दा पछिल्लो नेत्रवाणीलाई डाउन लोड गर्न उक्त लिङ्कमा किटिक्क पार्नु होला ।

डाउनलोड भएको फाइललाई पल्टाएमा नेत्रवाणी अस्थायी रूपमा चल्ने छ
र तपाइलाई आफ्नो कल्पयन्त्रमा यसलाई स्थायी रूपमा भित्र्याउने कि भनि सोधिनेछ । तपाइले यसलाई अस्थायी रूपमा एक पटक चलाउन, बहनीय प्रति बनाउन अथवा स्थायी रूपमा नै यसलाई भित्र्याउन सक्नु हुन्छ ।

यदि तपाइ नेत्रवाणीलाई यस कल्पयन्त्रमा चलाउन चाहनु हुन्छ भने तपाइले 'नेत्रवाणीलाई भित्र्याउ' भन्ने विकल्प रोज्नु पर्ने हुन्छ । नेत्रवाणीलाई स्थायी रूपमा भित्र्याएमा यसबाट कल्पयन्त्र आरम्भ हुँदा स्वतः
सुरुवात हुने, सन्झ्याल आरम्भ पातो पढ्न सक्ने, सन्झ्याल सुरक्षित पर्दा पढ्न सक्ने, आरम्भ मेनु र डेस्कटप द्रुतमार्ग को सिर्जना गर्ने जस्ता अतिरिक्त कार्यकुशलताहरू हासिल हुनेछ । जुन कुरा अस्थायी वा बहनीय प्रतिमा पाउन सकिँदैन ।
स्थायी रूपमा भित्र्याएको प्रतिबाट आफैले जुनसुकै समयमा बहनीय प्रति पनि सिर्जना गर्न सकिन्छ ।

यदी तपाइ नेत्रवाणीलाई आफूसित छेस्को भण्डार वा अरू बोक्न मिल्ने भण्डारमा राख्न चाहनु हुन्छ भने बहनीय प्रति जन्माउ भन्ने विकल्पको चयन गर्नु होला ।
बहनीय प्रतिमा चाहेको समयमा कुनै पनि कल्पयन्त्रमा नेत्रवाणीलाई स्थायी रूपमा भित्र्याउने क्षमता रहन्छ ।
तर तपाइ यदी पढ्न मात्र मिल्ने CD जस्ता भण्डारमा यसलाई राख्न चाहनु हुन्छ भने तपाइले डाउनलोड गरेको 'भित्र्याउने प्रति' नै राख्नु पर्ने हुन्छ ।
हालसम्म पढ् नमात्र मिल्ने भण्डारमा राखेर बहनीय प्रति बनाएर यसलाई चलाउन सकिँदैन ।

नेत्रवाणीको सुरुवात हुन समय लाग्ने भए पनि प्रदर्शनी जस्ता कार्यहरू गर्दा यसलाई अस्थायी रूपमा नै चलाउने विकल्प रोज्नु राम्रै हुन्छ ।

### बहनीय र अस्ताई प्रतिका सीमितहरू {#toc10}

सन्झ्याल आरम्भ हुनु अगावै वा पछि स्वचालित रूपमा सुरुवात हुन असक्षमता बाहेक, नेत्रवाणीका अस्ताई र बहनीय प्रतिहरूमा निम्न सीमितहरू पनि छन्:

* प्रशासकीय हैसियतमा सञ्चालित अनुप्रयोगहरू सित अन्तरक्रिया गर्न नसक्नू, यदि नेत्रवाणी आफैँ यही हैसियतमा (यस्तो सिफारिस गरिँदैन) छैन भने ।
* उपभोक्ता खाता नियन्त्रण (UAC) पर्दा पढ्न नसक्नू, यदि कुनै अनुप्रयोग प्रशासकीय हैसियतमा सुरु गर्न चाहेको खण्डमा ।
* सन्झ्याल 8: स्पर्श पर्दाबाट प्राप्त हुने लगानी बुझ्ने असक्षमता ।
* सन्झ्याल 8: सन्झ्याल भण्डार apps मा उघारने मुद्रा र टङ्कण गरेका वर्णहरू बताउने अनुप्रयोगहरूका गुणहरू उपलब्ध गराउने असक्षमता ।

### नेत्रवाणीको स्थापना {#toc11}

यदी तपाइ नेत्रवाणीलाई सोझै डाउनलोड गरेको पोको बाट स्थापना गर्न चाहनु हुन्छ भने नेत्रवाणीलाई भित्र्याउ भन्ने टाँकलाई दबाउनु होला ।
यदि तपाइले यो पातोलाई पहिले नै बन्द गर्नु भई सकेको छ भने अथवा बहनीय प्रति बाट स्थापना गर्न चाहनु भएको छ भने कृपया नेत्रवाणी मेनु को औजार मेनु भित्र रहेको नेत्रवाणीलाई 'भित्र्याउ' भन्ने टाँकलाई दबाउनु होला ।

स्थापनाको लागि देखा पर्ने पातोमा तपाइसित नेत्रवाणीलाई भित्र्याउन चाहनु भएको कुरा यकिन गर्न भनिने छ र तपाइलाई पहिले स्थापित गरिएको नेत्रवाणीको पुरानो संस्करणलाई अद्यावधिक गर्ने हो कि होइन भनि सोधिने छ ।
कार्य जारी राख भन्ने टाँकलाई दबाएमा नेत्रवाणीलाई भित्र्याउने कार्य सुरु हुनेछ ।
यो पातोमा अरू थप विकल्पहरू पनि रहने छन् जसलाई तल व्याख्या गरिएको छ ।
नेत्रवाणीको भित्रिने कार्य पुरा हुन साथ तपाइलाई सफलता पूर्वक कार्य सम्पन्न भएको सन्देश दिइने छ ।
यस पछि 'ठीक' टाँकलाई दबाउन साथ नयाँ नेत्रवाणीले कार्य सुरु गर्न थाल्ने छ ।

#### सन्झ्यालको आरम्भ र नेत्रवाणीको सुरुवात {#toc12}

यो विकल्पले तपाइलाई सन्झ्याल आरम्भ गर्नका लागी राखिएको गोप्य शब्द लेख्नु अगावै नेत्रवाणी स्वतः सुरुवात होस् कि नहोस् भनि रोज्ने विकल्प प्रदान गर्दछ ।
यसले उपभोक्ता खाताको नियन्त्रण र अरू सुरक्षित पर्दाको अवस्थालाई पनि समावेश गर्दछ ।

#### डेस्कटप द्रुत मार्गको सिर्जना (ctrl+alt+n) {#toc13}

यो विकल्पले नेत्रवाणीले आफ्नो प्रयोगको लागी डेस्कटपमा द्रुतमार्ग सिर्जना गर्ने कि नगर्ने भनि उपभोक्तालाई रोज्ने अवस्था प्रदान गर्दछ ।
यदि यस्तो द्रुतमार्ग सिर्जना गरियो भने यसले स्वतः control+alt+n कुञ्जी दबाउँदा कुनै पनि समयमा नेत्रवाणीको सुरुवात हुनेछ ।

#### चालू उपभोक्ता खातामा बहनीय प्रतिको अभियोजन प्रविष्टि {#toc14}

यो विकल्पले तपाइलाई नेत्रवाणीले चालू बहनीय प्रतिमा तय गरिएको अभियोजन उपभोक्ताको भित्रिन लागेको प्रतिमा पनि सार्ने कि नसार्ने भनि रोज्ने अवसर प्रदान गर्ने छ ।
यसै प्रणालीमा आबद्ध उपभोक्ताको अभियोजनको रूपमा र सन्झ्यालको आरम्भ अथवा अरू सुरक्षित पर्दाको अभियोजनको रूपमा भने बचत गर्ने छैन ।
यो विकल्प केवल बहनीय नेत्रवाणीमा मात्र लागू हुने छ तर सोझै डाउनलोड गरेको पोको बाट स्थापित नेत्रवाणीमा उपलब्ध हुने छैन ।

### बहनीय प्रतिको सिर्जना {#toc15}

यदी डाउनलोड गरेको स्थापक पोको बाट सोझै बहनीय प्रति सिर्जना गर्ने हो भने बहनीय प्रति बनाउ भन्ने विकल्प रोजी 'ठीक' टाँकलाई दबाउनु पर्ने छ ।
यदि भित्र्याउने सम्बन्धी पातो पहिले नै बन्द गरिएको छ अथवा पहिले नै भित्र्याएको नेत्रवाणीको प्रयोग भई रहेको छ भने नेत्रवाणी औजार menu भित्रको 'बहनीय प्रति बनाउ' भन्ने उप मेनुमा गएर किटिक्क पार्नु होला ।

यस पछि देखा पर्ने पातोले तपाइलाई बहनीय प्रति कहाँ जन्माउने हो भनि लेख्ने स्थान उपलब्ध गराउने छ । 
माग गरिएको स्थान स्थायी भकारी, छेस्को भकारी वा बोक्न मिल्ने भकारीहरू मद्ये कुनै एउटामारहेको घर्रा हो ।
यस पछि नेत्रवाणीले तपाइलाई चालू उपभोक्ताले तय गरेको अभियोजनलाई हालै जन्माएको बहनीय प्रतिमा पनि कायम गर्ने हो वा होइन भनि रोज्ने विकल्प उपलब्ध गराउने छ ।
यो सुविधा केवल स्थापित प्रतिबाट बहनीय प्रति जन्माउँदा मात्रै उपलब्ध हुने छ, डाउनलोड गरेको स्थापकको पोकोबाट जन्माउँदा होइन ।
जारी राख भन्ने टाँकलाई दबाएमा बहनीय प्रति जन्माउने काम सुरु हुन्छ ।
बहनीय प्रति जन्माउने कार्य पूरा भए पछि कार्य सफलतापूर्वक सम्पन्न भएको सन्देश प्राप्त हुने छ ।
यो सन्देश वाहक पातो हटाउन 'ठीक' भन्ने टाँकलाई दबाउनु होला ।

## नेत्रवाणीको सुरुवात {#toc16}
### नेत्रवाणीको प्रयोग {#toc17}

यदि तपाइले नेत्रवाणीलाई स्थापकको पोकोबाट भित्र्याउनु भएको छ भने यसको सुरुवात गर्न ज्यादै सजिलो छ । नेत्रवाणीलाई सुरु गर्न control+alt+n कुञ्जी दबाउनु होला अथवा सन्झ्यालको
सुरुवात टाँकलाई दबाएर कार्यक्रम भित्र गएर nvda.exe नामको फाइललाई किटिक्क गर्नु होला । यसका अतिरिक्त तपाइले Run आदेश पातोमा nvda टङ्कण गरेर Enter कुञ्जी दबाउन पनि सक्नु हुन्छ ।
तपाइले केही [आदेश रेखा विकल्प](#CommandLineOptions) दिन सक्नु हुन्छ  जसले नेत्रवाणीको सुरुवात (-r), बहिर्गमन (-q), उप-कर्मीको अयोग्यता (--उपकर्मिलाई अयोग्य बनाउ इत्यादी) ।

बहनीय प्रतिलाई सुरु गर्न, यो राखिएको घर्रा भित्र पसेर नेत्रवाणी.exe नामको फाइललाई किटिक्क गर्नु पर्ने हुन्छ ।

नेत्रवाणी सुरुवात हुँदा एउटा मलिन ध्वनि सुनिने छ जसको अर्थ हुन्छ यो सुरु हुँदै छ । सुरु गर्न लाग्ने समय तपाइको कल्पयन्त्रको गति, नेत्रवाणीको प्रकार जस्ता कुरामा भर पर्छ ।
तपाइको कल्पयन्त्रको गतिमा आधारित भएर, अथवा तपाइ USB कुञ्जी वा अरू सुस्त माध्यमहरूको प्रयोग गर्नु भएको भए, यसका आधारमा सुरुवातका लागि केही समय लाग्न सक्छ ।
केही समय लाग्ने भएमा 'पर्खनु होस् है, नेत्रवाणी सुरु हुँदैछ' भनेर सन्देश दिइनेछ ।

यदी तपाइले यस्तो सन्देश पाउनु भएन अथवा सन्झ्यालको त्रुटि ध्वनि सुनियो अथवा मलिन स्वर बन्द भयो र कुनै पनि सन्देश आएन भने निश्चय नै तपाइको कल्पयन्त्रमा समस्या आएको हुन्छ । यसो भएमा तपाइले तुरुन्तै यो समस्या विकास कर्तालाई जानकारी गराउनु होला ।
यस प्रकृतिका समस्याहरू विकास कर्ताहरूलाई कसरी पठाउने भनेर जान्नका लागी नेत्रवाणीको वेभ साईट भ्रमण गर्नु होला ।

नेत्रवाणी पहिलो पटक सुरुवात हुँदा यसले परिवर्तक कुञ्जी र नेत्रवाणीको मेनु जस्ता आधारभूत जानकारी दिँदै तपाइलाई स्वागत गर्ने छ ।
(कृपया सन्दर्भित विषयहरू सम्बन्धित खण्डमा हेर्नु होला )
स्वागत पाटीमा तीन वटा चिनो बाकसहरू हुने छन् ।
पहिलो चिनो बाकसले capsLock कुञ्जीलाई नेत्रवाणी कुञ्जी बनाउने कि नबनाउने भनेर रोजाउने छ ।
दोस्रो चिनो बाकसले, तपाइले सन्झ्याल सुरुवात गर्ना साथ नेत्रवाणी सुरु गर्ने कि न गर्ने भन्ने विकल्प चयन गराउने छ तर यो सुविधा केवल स्थापित प्रतिमा मात्र उपलब्ध हुन्छ ।
तेस्रो चिनो बाकसले स्वागत पाटी प्रत्येक पटक नेत्रवाणी सुरु हुँदा देखाउने कि नदेखाउने भनेर रोजाउने छ ।

### कुञ्जीपाटीको आदेश {#toc18}
#### नेत्रवाणी परिवर्तक कुञ्जी {#toc19}

अधिकांश कुञ्जी आदेशहरू एउटा निश्चित कुञ्जी सित अरू कुञ्जीहरू दबाएर दिने गरिन्छ । यो निश्चित कुञ्जीलाई नै नेत्रवाणी कुञ्जी भनिएको हो ।
'पाठ समीक्षा आदेश' मा भने यसको स्प्रष्ट अपवाद स्वरूप numpad कुञ्जीहरूलाई स्वयम् चलाइन्छ । तर यसमा अरू अपवादहरु पनि छन् ।

उपभोक्ताले numpad Insert, Extended Insert अथवा capslock कुञ्जी मद्ये कुनलाई नेत्रवाणी परिवर्तक कुञ्जी बनाउने भनेर स्वयम् अभियोजन गर्न सक्ने छ ।
numpad Insert र Extended Insert दुबै कुञ्जीलाई नेत्रवाणी परिवर्तक कुञ्जीको रूपमा निर्धारित गरिएको छ ।

नेत्रवाणी परिवर्तक कुञ्जीको रूपमा कुनै कुञ्जी लाई तय गरिएको छ भने पनि लगातार चाँडो चाँडो दुई पटक यसलाई दबाएमा यसले परिवर्तकको रूपमा नभइ आफ्नै प्रकृतिको काम गर्ने छ ।

#### कुञ्जीपाटीको रूपरेखा {#toc20}

नेत्रवाणी हाललाई दुई वटा कुञ्जी आदेश समूहमा उपलब्ध छ ।
पूर्व निर्धारित रूपमा, नेत्रवाणी खाटेपाटी रूपरेखामा राखिएको छ । तर तपाइले यसलाइ नेत्रवाणी मेनु भित्र रहेको प्राथमिकताहरू- कुञ्जीपाटीको अनुकूलतामा गएर काखेपाटी रुपरेखामा बदल्न सक्नु हुन्छ ।

डेस्कटप रूपरेखामा numlock कुञ्जीलाई बन्द मुद्रामा राखेर numpad कुञ्जीलाई ल्यापटप रूपमा प्रयोग गर्न सकिन्छ ।
धेरै जसो ल्यापटपमा भने भौतिक रूपमा numberpad, कुञ्जी हुँदैन तर कतिपय ल्यापटपमा भने FN कुञ्जीलाई दबाएर दाहिने तर्फका ७, ८, ९ नम्बर कुञ्जी र u i o j k l जस्ताकुञ्जीलाई NumPad कुञ्जी बनाउन सकिन्छ 
यदि तपाइको ल्यापटपमा यो प्रावधान छैन अथवा यसो गर्न मिल्दैन भने, तपाइले ल्यापटप रूपरेखाको अनुकूलतालाई तय गर्नु राम्रो हुन्छ ।

### नेत्रवाणी स्पर्श सङ्केत {#toc21}

यदि तपाई नेत्रवाणीलाई कुनै स्पर्श पर्दा प्रकृतिका उपकरण द्वारा चलाउँदै हुनु हुन्छ र सन्झ्याल८ वा यस पछिका संस्करण चलाउनु हुन्छ भने, नेत्रवाणीलाई प्रत्यक्ष रूपमा स्पर्श पर्दा मार्फत नियन्त्रण गर्न सक्नु हुन्छ ।
नेत्रवाणी चलेको बेला सबै स्पर्श लगानीहरू सोझै नेत्रवाणीमा जाने छन् ।
यस कारण, नेत्रवाणी बिना नै हुने कार्यहरू पनि सम्पादित हुने छैनन् ।

#### पर्दाको अन्वेषण {#toc22}

तपाइले आधारभूत रूपमा स्पर्श पर्दा द्वारा सम्पादन गर्न सक्ने कार्य भनेको पर्दाको कुनै विन्दुमा रहेको पाठ वा नियन्त्रकको जानकारी हासिल गर्नु नै हो ।
यसो गर्नका लागि, पर्दाको कुनै भागमा कुनै औँला राख्नु होस् ।
तपाइ आफ्नो औँला पर्दाको कुनै ठाउँमा राख्न सक्नु हुन्छ र औँला घुमाएर यसको मुनि पर्ने नियन्त्रक वा पाठहरू थाहा पाउन सक्नु हुन्छ ।

#### स्पर्श सङ्केत {#toc23}

जब यो उपभोक्ता निर्देशिकामा नेत्रवाणी कुञ्जी आदेशको बारेमा बताइन्छ, त्यहाँ स्पर्श पर्दामा यी आदेशहरूलाई सक्रिय बनाउने स्पर्श सङ्केत हुनेछन् ।
विभिन्न स्पर्श सङ्केतहरू कसरी चलाउने भनेर जान्ने तरीका निम्न अनुसार छन् ।

##### पकड {#toc24}

पर्दालाई एक वा दुई औँलाले पक्डनु होस् ।

एउटा औँलाले पर्दामा दबाउनु लाई साधारणतया 'पकड' भनिन्छ ।
दुई औँलाले पर्दामा एकै पटक दबाउनु लाई २-औले पकड भनिन्छ र यस्तै अरू पनि ...

यदि उही पकड एक वा अधिक पटक चाँडो चाँडो सम्पादन गरिन्छ भने, नेत्रवाणीले यसलाई बहु स्वरिक स्पर्श सङ्केत ठान्ने छ ।
दुई पटकको पकडले दोब्बर पकडको काम गर्नेछ ।
तिन पटकको पकडले तेब्बर पकडको काम गर्ने छ र यस्तै अरू पनि...
निश्चय नै, यी बहु पकड सङ्केतले कति वटा औँलाहरू भनेर पहिचान गर्ने छन् , यस कारण २-औले तेब्बर पकड, ४-औले पकड जस्ता कुरा जान्न सम्भव छ ।

##### घर्षण {#toc25}

पर्दाको चारै तिर चाँडो चाँडो औँलालाई घिसार्नु होस् ।

दिशाका आधारमा ४ प्रकारका घर्षण सम्भव छन्: बायाँ तिरको घर्षण, दायाँ तिरको घर्षण, उँभो तिरको घर्षण र उँधो तिरको घर्षण ।

पकडमा जस्तै एक भन्दा बढी सङ्केतहरू पनि सम्भव छन् ।
त्यस कारण, २-औले उँभो घर्षण र ४-औले बायाँ घर्षण जस्ता सङ्केतहरू सबै सम्भव छन् ।

#### स्पर्श मुद्रा {#toc26}

नेत्रवाणीका आदेशहरू सम्भावित स्पर्श सङ्केत भन्दा निकै बढि भएकोले, नेत्रवाणीका धेरै स्पर्श मुद्राहरूमा तपाई हेरफेर गर्न सक्नु हुन्छ र कतिपय उप-समूह आदेशहरू उपलब्ध छन् ।
यी दुई मुद्राहरू पाठ मुद्रा र वस्तु मुद्रा हुन् ।
यो कागजातमा सूचीकृत नेत्रवाणीका केही स्पर्श मुद्रा आदेशहरू स्पर्श सङ्केत पछि कोष्ठमा राखिएका हुन सक्छन् ।
उदाहरणका लागि, उँभो घर्षण (पाठ मुद्रा) को मतलब त्यो आदेश तपाइले उँभो घिसार्नु भयो भने सम्पादित हुन्छ, तर केवल पाठ मुद्रामा मात्रै
यदि आदेश मुद्रा कुनै पनि मुद्रामा सुची बद्ध छैन भने यो जुन सुकै मुद्रामा काम गर्छ ।

<!-- KC:beginInclude -->
स्पर्श मुद्रालाई साटो फेरो गर्न, ३-औले पकडको प्रयोग गर्नु होस् ।
<!-- KC:endInclude -->

### सहयोग लगानी मुद्रा {#toc27}

यो उपभोक्ता निर्देशिकामा धेरै कुञ्जी आदेश बारेमा बताएको छ । 'लगानी सहयोग को प्रयोग गर्दा यी सबै कुञ्जीहरूको बारेमा जानकारी हुनेछ ।'

'लगानी सहयोग ' हेर्न नेत्रवाणी+1 कुञ्जी दबाउनु होला ।
यसलाई बन्द गर्नका लागी फेरी नेत्रवाणी+1 कुञ्जीलाई नै दबाउनु होला ।
'लगानी सहयोग खुलेको बेला कुनै पनि कुञ्जी दबाउँदा यो कुञ्जीले के सन्देश दिन्छ अथवा के काम गर्छ भनेर बताउने छ तर साधारण अवस्थामा गर्ने कुनै पनि काम भने गर्ने छैन ।
वास्तवमा यस बेला कुञ्जीपाटीका कुनै पनि कुञ्जीले आफ्नो कार्य नगर्ने हुँदा तपाइले जुनसुकै कुञ्जीलाई निश्फिक्री दबाउन सक्नु हुन्छ ।

### नेत्रवाणी मेनु {#toc28}

नेत्रवाणी मेनु ले तपाइलाई यसको अनुकूलता मिलाउन, सहयोग लीन, अभियोजनलाई बचत गर्न वा उल्टाउन, आवाज परिवर्तन गर्न, ढुकुटीमा पहुँच, अतिरिक्त औजारको प्रयोग गर्न र यसलाई बन्द गर्न अनुमति प्रदान गर्दछ ।

तपाइले सन्झ्यालमा कुनै पनि अनुप्रयोग चलाई रहेको बेला नेत्रवाणी मेनुमा जान नेत्रवाणी+n कुञ्जी दबाउनु होला ।
तपाइ नेत्रवाणी मेनुमा जानका लागी प्रणाली थालि सुचीमा पनि जान सक्नु हुन्छ ।
सन्झ्याल+ B लाई दबाएर प्रणाली थालीमा रहेको नेत्रवाणी प्रतिमामा गएर धेरै जसो कुञ्जीपाटीमा दाहिने कन्ट्रोल कुञ्जीको दाहिने पट्टी राखिने गरेको app कुञ्जीलाई दबाउनु होला ।
जब उक्त मेनु देखा पर्छ , तपाइले तल, माथि, दायाँ र बायाँ गर्ने वाणहरू र Enter कुञ्जी दबाएर लक्षित सामाग्रीमा जान सक्नु हुन्छ ।

### कुञ्जीको आधारभूत आदेश {#toc29}

<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |स्पर्श |विवरण|
|---|---|---|---|---|
|बोली बन्द |Control |Control |२-औले स्पर्श |तुरुन्तै बोल्न बन्द हुने छ ।|
|वाचन स्थगन |Shift |Shift |केही छैन |तुरुन्तै बोल्न रोकिन्छ र फेरी यही कुञ्जी दबाएमा बोल्न रोकिएको स्थानबाट वाचन सुरु गर्छ (स्थगन चालू संश्लेषकले समर्थन गर्नु पर्छ) ।|
|नेत्रवाणी मेनु |नेत्रवाणी+n |नेत्रवाणी+n |२-औले दोब्बर स्पर्श |प्राथमिकताहरू, सहयोग, औजारहरू इत्यादि मा जानका लागी आवश्यक पातो पल्टाइ दिनेछ ।|
|वाचन मुद्राको साटो फेरो |नेत्रवाणी+s |नेत्रवाणी+s |केही छैन |वाचन मुद्रालाई मौनता, टीँ टीँ गर्ने अथवा वाचन गर्ने मुद्रामा फेरिदिन्छ ।|
|कुञ्जीपाटी सहयोग मुद्राको साटो फेरो |नेत्रवाणी+1 |नेत्रवाणी+1 |केही छैन |यो मुद्रामा कुनै पनि कुञ्जी दबाएमा कुञ्जीको नाम र यससित आबद्ध नेत्रवाणीका आदेशहरू को विवरण बताउने छ ।|
|नेत्रवाणीको बहिर्गमन |नेत्रवाणी+q |नेत्रवाणी+q |केही छैन |नेत्रवाणी बन्द हुनेछ ।|
|अर्को कुञ्जीलाई हस्तान्तरण |नेत्रवाणी+f2 |नेत्रवाणी+f2 |केही छैन |नेत्रवाणीलाई सक्रिय अनुप्रयोगबाट सोझै दबाएको कुञ्जीलाई पनि नेत्रवाणीको कुञ्जी आदेश सरह लीन अह्राउने छ ।|
|अनुप्रयोगको निद्रा खुल्ने/बन्द हुने मुद्राको साटो फेरो |नेत्रवाणी+shift+s |नेत्रवाणी+shift+z |केही छैन |निद्रा मुद्राले नेत्रवाणीका आदेशहरू एवम् वाचन/ब्रेल को प्रतिफललाई चालू अनुप्रयोगमा निकम्मा बनाउँछ । यो आफ्नै वाचन क्षमता भएका वा अलग्ग दृष्ट्रीवाचकको सुविधा भएका अनुप्रयोगहरूमा प्रयोग गरिन्छ । आफै बोल्ने क्षमता फर्काउन यही आदेशलाई फेरी दबाउनु होला ।|

<!-- KC:endInclude -->

### प्रणाली सम्बन्धी जानकारी {#toc30}

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|समय र मितिको जानकारी |नेत्रवाणी+f12 |एक पटक दबाएमा समय र लगातार दुई पटक दबाएमा मिति बताउने छ ।|
|ब्याट्री अवस्थाको जानकारी |नेत्रवाणी+shift+b |विद्युत् लाइनमा जोडिएको छ छैन, ब्याट्रीमा चार्जको भण्डार कुन अवस्थामा छ भन्ने जान्न प्रयोग गरिन्छ ।|
|क्लिपपाटीहरूको जानकारी |नेत्रवाणी+c |क्लिप पाटीमा केही सामाग्री राखिएको भए यसलाई बताइ दिनेछ ।|

<!-- KC:endInclude -->

## नेत्रवाणीको विचरण {#toc31}

नेत्रवाणीले तपाइलाई साधारण र समीक्षा दुबै किसिमले छानबिन गर्ने र विचरण गर्ने स्वतन्त्रता प्रदान गर्दछ ।

### वस्तुहरू {#Objects}

प्रत्येक अनुप्रयोगहरू र सञ्चालन प्रणाली दुबैले आ-आफ्नै खालका वस्तुहरू समावेश गरेका हुन्छन् ।
वस्तु भनेको एउटा एकल सामाग्री हो जस्तै पाठको एक टुक्रा,टाँक, चिनो बाकस, सू लुली, सुची, अथवा सम्पादन योग्य क्षेत्रहरू ।

### प्रणाली केन्द्रीयता सित विचरण {#SystemFocus}

प्रणालीको केन्द्रीयता जसलाई केन्द्रीयता मात्रै पनि भनिन्छ , [वस्तु](#Objects) ले कुञ्जीपाटीबाट कुञ्जीको आदेश प्राप्त गर्दछ ।
उदाहरणका लागी यदि तपाइ एउटा सम्पादन योग्य क्षेत्रमा टङ्कण गर्दै हुनु हुन्छ भने यतिखेर ‘सम्पादन योग्य पाठ क्षेत्र’ केन्द्रीयता भएको हुन्छ ।

नेत्रवाणी मार्फत सन्झ्यालमा विचरण गर्नका लागि सबै भन्दा सरल तरीका प्रणाली केन्द्री यतामा स्तरीय सन्झ्यालमा उपलब्ध कुञ्जी आदेशबाट जानु हो । जस्तै tab र shift+tab दबाएर अगाडिको कन्ट्रोल वा पछाडिको कन्ट्रोलमा जाने अथवा alt दबाएर वाण मार्फत दायाँ बायाँ मेनुमा भ्रमण गर्ने कार्य ।
तपाइले यसरी वस्तुमा विचरण गर्दा नेत्रवाणीले केन्द्रित हुन पुगेका वस्तुको नाम, किसिम, मान, अवस्था, विवरण, द्रुतमार्ग कुञ्जी र स्थान विशेषको सूचना र जानकारी दिने छ ।

प्रणाली केन्द्री यताद्वारा विचरण गर्न केही कुञ्जी आदेश उपलब्ध छन् ।
<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |विवरण|
|---|---|---|---|
|चालू केन्द्री यताको जानकारी |नेत्रवाणी+tab |नेत्रवाणी+tab |चालू वस्तुलाई अथवा प्रणाली केन्द्रीयता नियन्त्रकलाई बताउँछ दुई पटक दबाएमा उक्त जानकारीलाई हिज्जेमा बताउने छ ।|
|शीर्षकको जानकारी |नेत्रवाणी+t |नेत्रवाणी+t |चालू सन्झ्यालको शीर्षक बताउने छ । दुई पटक दबाएमा यसको जानकारी दिने छ र ती पटक दबाएमा यसलाई क्लिप पाटीमा उतार्ने छ ।|
|सक्रिय सन्झ्यालको वाचन |नेत्रवाणी+b |नेत्रवाणी+b |सक्रिय पातोका सबै नियन्त्रकहरूलाई पढ्ने छ ।|
|स्थितिपट्टीको जानकारी |नेत्रवाणी+end |नेत्रवाणी+Shift+end |स्थिति पट्टीमा केही पाएको खण्डमा यसलाई बताउने छ । यसले विचरण वस्तुलाई स्थिति पट्टीमा लैजान्छ। । दुई पटक दबाएमा सको हिज्जे बताउने छ ।|

<!-- KC:endInclude -->

### प्रणाली Caret सित विचरण {#SystemCaret}

जब विचरण वा/र सम्पादन समर्थन गर्ने एउटा [वस्तु](#Objects) पाठमा [केन्द्रित](#SystemFocus) हुन जान्छ, तपाइ यो पाठ प्रणाली caret, जसलाई सम्पादन कर्सर पनि भनिन्छ को माध्यम बाट विचरण गर्न सक्नु हुन्छ ।

जब केन्द्रीयता प्रणाली caret भएको वस्तुमा रहेको हुन्छ, तपाइ बाणकुञ्जीहरू, पृष्ठ माथि, पृष्ठ तल, घर, अन्त जस्ता कुञ्जीको प्रयोग गरी पाठमा जान सक्नु हुन्छ ।
यदि उक्त नियन्त्रकले समर्थन गर्छ भने तपाइ उक्त पाठलाई सम्पादन पनि गर्न सक्नु हुन्छ ।
नेत्रवाणीले तपाइले विचरण गरेको एक एक वर्ण, शब्द वा पङ्ति बताउने छ र चयन गरेका वा चयन हटाएका पाठहरू पनि बताउने छ ।

नेत्रवाणीले निम्न कुञ्जीलाई प्रणाली caret सित सम्बन्धित भएर समर्थन गर्छ:
<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |विवरण|
|---|---|---|---|
|सबै पाठको वाचन |नेत्रवाणी+downArrow |नेत्रवाणी+A |प्रणाली caret रहेको स्थानबाट क्रमै सितले पढ्दै पाठको अन्तसम्म जान्छ ।|
|हालको पङ्‌क्तिको वाचन |नेत्रवाणी+upArrow |नेत्रवाणी+l |प्रणाली caret रहेको पङ्तिका पाठहरूलाई पढ्ने छ र दुई पटक दबाएमा उक्त पङ्तिका पाठहरूको हिज्जे बताउने छ ।|
|चयन पाठको वाचन |नेत्रवाणी+Shift+upArrow |नेत्रवाणी+Shift+s |कुनै पङ्तिका पाठहरूलाई चयन गरिएको छ भने त्यसलाई पढ्ने छ ।|
|अघिल्लो वाक्य |alt+तलवाण |alt+तलवाण| क्यारेटलाई अघिल्लो वाक्यमा लैजान्छ  र पढ्छ । (माईक्रोसफ्ट वर्ड र आउटलुकमा मात्रै समर्थित)|
|पछिल्लो वाक्य |alt+माथिवाण |alt+माथिवाण| क्यारेटलाई पछिल्लो वाक्यमा लैजान्छ  र पढ्छ । (माईक्रोसफ्ट वर्ड र आउटलुकमा मात्रै समर्थित)|

तालिकामा रहेको बेला निम्न कुञ्जीहरू पनि प्रयोग गर्न सकिन्छ

| नाम |कुञ्जी |विवरण|
|---|---|---|
|बायाँ महलमा जान |control+alt+leftArrow |प्रणाली caret उही हरफको देब्रे पट्टीको महलमा सर्छ ।|
|दायाँ महलमा जान |control+alt+rightArrow |प्रणाली caret उही हरफको दाहिने पट्टीको महलमा सर्छ ।|
|माथिल्लो हरफमा जान |control+alt+upArrow |प्रणाली caret उही महलको माथिल्लो हरफमा सर्छ ।|
|तल्लो हरफमा जान |control+alt+downArrow |प्रणाली caret उही महलको तल्लो हरफमा सर्छ ।|

<!-- KC:endInclude -->

### वस्तुमा विचरण {#toc35}

धेरै जसो समय तपाइले [केन्द्रीयता](#SystemFocus) र [caret](#SystemCaret) लाई सार्न अनुप्रयोगका आदेशहरूको प्रयोग गर्नु हुन्छ ।
तर कहिले कही तपाइले अनुप्रयोगका अथवा सञ्चालन प्रणालीका आदेशहरू बाहेक पनि केन्द्री यतामा caret लान चाहना राख्न सक्नु हुन्छ ।
तपाइले साधारणतया कुञ्जीपाटीको माध्यमबाट पहुँच नहुने [वस्तुहरू](#Objects) मा पनि विचरण गर्ने चाहना राख्न सक्नु हुन्छ ।
यस्तो अवस्थामा तपाइले वस्तुको विचरणलाई प्रयोग गर्न सक्नु हुन्छ ।

वस्तुको विचरणले तपाइलाई प्रत्येक [वस्तुहरूको](#Objects) बीचमा जान र यसको बारेमा जानकारी लीन अनुमति दिनेछ ।
जब तपाइ कुनै वस्तुमा जानु हुन्छ, नेत्रवाणीले प्रणाली केन्द्री यतामा जस्तै यसको बारेमा जानकारी दिनेछ ।
पर्दामा देखा परेका सबै पाठहरूको समीक्षाको लागी भने तपाइले यसको सट्टा[पर्दा समीक्षा](#ScreenReview) को प्रयोग गर्नु पर्ने हुन्छ ।

प्रत्येक एकल वस्तुको बीचमा यता र उता घुम्नको सट्टा, वस्तुहरूलाई तह गत पद्धतिमा राखिएको छ जसको अर्थ हुन्छ कुनै वस्तुले अर्को वस्तुलाई आफू भित्र राखेका हुन्छन् र यस अवस्थामा तपाइले एउटा
वस्तुको भित्र पसेर अर्को वस्तुमा जानु पर्ने हुन्छ ।
उदाहरणका लागी एउटा पटल सुचीमा धेरै सामग्रीहरू हुन्छन् र कुनै सामाग्रीमा जान पटल सुचीमा पहिले जानु पर्ने हुन्छ ।
यदी तपाइ एउटा सुची सामाग्रीमा हुनु हुन्छ भने अगाडि वा पछाडिको सुची सामाग्रीमा जानु भनेको अर्को वस्तुमा जानु हो ।
सुची सामाग्रीमा जानु भनेको उक्त सामाग्री भएको स्थानमा जानु हो ।
तपाइ चाहनु हुन्छ भने यस पछि उक्त सुची छोडेर अर्को वस्तुमा जान सक्नु हुन्छ ।
यसै गरी एउटा औजार पट्टीमा रहेका नियन्त्रकहरूमा जान तपाइले औजार पट्टी भित्र पस्न पर्ने हुन्छ ।

हाल समीक्षामा रहेको वस्तुलाई नै विचरण वस्तु भनिन्छ ।
[वस्तु समीक्षा मुद्रामा](#ObjectReview) रहँदा एक पटक कुनै वस्तुमा तपाइले विचरण गर्नु भयो भने यसलाई [पाठ समीक्षा आदेश](#ReviewingText) प्रयोग गरेर समीक्षा गर्न सक्नु हुन्छ
हुन त प्रणाली केन्द्रीयता सित विचरण वस्तु सर्ने प्रक्रियालाई पूर्व निर्धारित गरिएको हुन्छ तर यो प्रक्रियालाई चालू राख्ने वा नराख्ने भनेर आफैले तय पनि गर्न सकिन्छ ।

ख्याल राखौं कि ब्रेलमा भने वस्तुको विचरण र पाठको समीक्षाको सट्टा [केन्द्रीयता](#SystemFocus) र [caret](#SystemCaret) बाट सोझै जाने गरिन्छ । यदि यसको सट्टा
विचरण वस्तुलाई र पाठ समीक्षालाई नै प्रयोग गर्ने हो भने ब्रेलको [अभियोजन](#BrailleTether) फेर्नका लागी समीक्षा गर्ने पर्ने हुन्छ ।

वस्तुबाट विचरण गर्नका लागी निम्न कुञ्जीको प्रयोग गर्नु होला ।

<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |स्पर्श |विवरण|
|---|---|---|---|---|
|चालू वस्तुको जानकारी |नेत्रवाणी+numpad5 |नेत्रवाणी+shift+o |केही छैन |विचरण वस्तुको बारेमा बताउने छ । दुई पटक दबाएमा यसको हिज्जे बताउने छ र तीन पटक दबाएमा यो वस्तुको नाम र मान क्लिप पाटीमा उतार्ने छ ।|
|उस्तै वस्तुमा जान |नेत्रवाणी+numpad8 |नेत्रवाणी+shift+UpArrow |उँभो घर्षण |चालू विचरण वस्तु जस्तै अर्कै वस्तुमा जानेछ ।|
|पछिल्लो वस्तुमा जान |नेत्रवाणी+numpad4 |नेत्रवाणी+shift+LeftArrow |बायाँ घर्षण |हालको विचरण वस्तुको पछाडिको वस्तुमा सर्ने छ ।|
|अघिल्लो वस्तुमा जान |नेत्रवाणी+numpad6 |नेत्रवाणी+Shift+RightArrow |दायाँ घर्षण |चालू विचरण वस्तुको अगाडी रहेको वस्तुमा सर्ने छ ।|
|पहिलो वस्तुमा जान |नेत्रवाणी+numpad2 |नेत्रवाणी+shift+DownArrow |उँधो घर्षण |चालू विचरण वस्तुसित भएको पहिलो वस्तुमा जानेछ ।|
|केन्द्रित वस्तुमा जान |नेत्रवाणी+numpadMinus |नेत्रवाणी+backspace |केही छैन |हाल प्रणाली केन्द्रीयता भएको वस्तुमा जान्छ र समीक्षा कर्सरलाई प्रणाली Caret छ भने यसको स्थानमा लगेर राखि दिन्छ ।|
|चालू विचरण वस्तुको सक्रियता |नेत्रवाणी+numpadEnter |नेत्रवाणी+enter |दोब्बर स्पर्श |सुलसुलेले किटिक्क पार्दा अथवा Space Var दबाउँदा जे हुने हो सोही काम गर्ने गरी विचरण वस्तुलाई सक्रिय बनाउ छ ।|
|प्रणाली केन्द्रीयता वा caret चालू समीक्षा स्थानमा जान |नेत्रवाणी+shift+numpadMinus |नेत्रवाणी+shift+backspace |केही छैन |एक पटक दबाउँदा प्रणाली केन्द्रीयता चालू विचरण वस्तुमा जान्छ दुई पटक दबाउँदा प्रणाली caret लाई समीक्षा कर्सरमा लैजान्छ ।|
|समीक्षा वस्तु अवस्थित स्थानको जानकारी |नेत्रवाणी+numpadDelete |नेत्रवाणी+delete |केही छैन |समीक्षा कर्सर अवस्थित स्थानमा रहेका पाठ अथवा वस्तुको बारेमा जानकारी दिनेछ । जस्तै कागजातहरूको स्थान देखि, किनाराको आधारमा वा पर्दाको निर्दिष्ठ स्थान आदी । दुइ पटक दबाएमा यसको विस्तृत रु बताउनेछ ।|

<!-- KC:endInclude -->

टिप्पणी: यहाँ उल्लिखित numpad कुञ्जीले कार्य गर्न numlock कुञ्जी बन्द गरेको हुनु पर्दछ ।

### पाठको समीक्षा {#ReviewingText}

नेत्रवाणीले तपाइलाई [पर्दा](#ScreenReview), चालू [कागजातहरू](#DocumentReview) [ अथवा [वस्तुमा](#ObjectReview) रहेका सामाग्रीहरूका वर्ण, शब्द अथवा पङ्ति पढ्ने अनुमति प्रदान गर्दछ ।
विचरणको निर्दिष्ट पद्धति नभएका सन्झ्याल आदेश कन्सोल जस्ता अनुप्रयोगहरू [caret](#SystemCaret) का लागि धेरै नै महत् पूर्ण छ ।
उदाहरणका लागि तपाइले कुनै पनि पातोमा भएको लामो सन्देशहरू सजिलै समीक्षा गर्न सक्नु हुन्छ ।

समीक्षा कर्सरलाई हिँडाउँदा प्रणाली caret न हिँड्ने भएकोले तपाइले सम्पादन गर्ने अवस्थालाई यथावत् राखेर पाठलाई समीक्षा गर्न सक्नु हुन्छ ।
तर जब प्रणाली caret हिँड्ने गर्छ, समीक्षा कर्सर ले भने यसलाई पछ्याउने गरी निर्धारण गरिएको हुन्छ ।
यो अनुकूलतालाई उल्टाउन भने सकिन्छ ।

स्मरणीय छ कि ब्रेलमा भने [केन्द्रीयता](#SystemFocus) र [caret](#SystemCaret) लाई क्रमशः पाठ समीक्षा र वस्तुको विचरण मा निर्धारित गरेको हुन्छ ।
यदि तपाइ यसको सट्टा वस्तुको विचरण र पाठको समीक्षा चाहनु हुन्छ भने ब्रेललाई [ब्रेलको मिलावट](#BrailleTether) मा अभियोजन गर्नु होला ।

पाठ समीक्षाको लागि निम्न अनुसारका कुञ्जीहरू उपलब्ध छन् ।
<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |स्पर्श |विवरण|
|---|---|---|---|---|
|समीक्षाको सिरानको पङ्तिमा जान |shift+numpad7 |नेत्रवाणी+Control+Home |केही छैन |समीक्षा कर्सर पाठको सिरानको पङ्तिमा जान्छ ।|
|समीक्षाको अघिल्लो पङ्तिमा जान |numpad7 |नेत्रवाणी+upArrow |उँभो घर्षण |समीक्षा कर्सर चालू पङ्तिको अघिल्लो पङ्तिमा जानेछ ।|
|चालू समीक्षाको जानकारी |numpad8 |नेत्रवाणी+. |केही छैन |समीक्षा कर्सर रहेको वर्तमान पङ्तिमा रहेको पाठको बारेमा बताउने छ । दुई पटक दबाएमा उक्त पङ्तिको हिज्जे बताउने छ । तीन पटक दबाएमा वर्णहरूको विवरण सहित उक्त पङ्तिको हिज्जे बताउने छ|
|समीक्षाको अगाडिको पङ्तिमा जान |numpad9 |नेत्रवाणी+DownArrow |उँधो घर्षण |वर्तमान पाठको अगाडीको पङ्तिमा जानेछ ।|
|समीक्षाको पुछारको पङ्तिमा जान |shift+numpad9 |नेत्रवाणी+Control+End |केही छैन |समीक्षा कर्सरलाई पुछारको पङ्तिमा ले जान्छ ।|
|समीक्षा पछाडिको शब्दमा जान |numpad4 |नेत्रवाणी+Control+LeftArrow |2-औले बायाँ घर्षण |समीक्षा कर्सर पाठको चालू अघिल्लो शब्दमा सर्छ ।|
|समीक्षामा रहेको शब्द जान्न |numpad5 |नेत्रवाणी+Control+. |केही छैन |हाल समीक्षा कर्सर रहेको शब्द बताउने छ । दुई पटक दबाएमा उक्त शब्दको हिज्जे भन्ने छ र तीन पटक दबाएमा वर्णको विवरण सहित शब्दको हिज्जे भन्ने छ ।|
|समीक्षा अगाडीको शब्दमा जान |numpad6 |नेत्रवाणी+Control+RightArrow |२-औले दायाँ घर्षण |वर्तमान पाठको अगाडीको शब्दमा जानेछ ।|
|समीक्षा पङ्तिको सुरुमा जान |shift+numpad1 |नेत्रवाणी+Home |केही छैन |चालू पङ्तिको सुरुमा कर्सरलाई ले जान्छ ।|
|समीक्षाको पछिल्लो वर्णमा जान |numpad1 |नेत्रवाणी+LeftArrow |बायाँ घर्षण |पाठको चालू पङ्तिमा रहेको समीक्षाको पछिल्लो वर्णमा जान्छ ।|
|समीक्षामा रहेको वर्ण जान्न |numpad2 |नेत्रवाणी+. |केही छैन |चालू पङ्तिमा समीक्षा कर्सर रहेको स्थानको वर्ण बताउने छ । दुई पटक दबाएमा वर्णको विवरण अथवा उदाहरण सहित उक्त वर्ण बताउने छ । तीन पटक दबाएमा उक्त वर्णको वर्ण संहिता सङ्ख्या बताउने छ ।|
|समीक्षामा रहेको वर्णको अगिल्लो वर्णमा जान |numpad3 |नेत्रवाणी+RightArrow |दायाँ घर्षण |पाठको चालू पङ्तिमा रहेको समीक्षाको अघिल्लो वर्णमा जान्छ ।|
|समीक्षा पङ्तिको अन्तिममा जान |shift+numpad3 |नेत्रवाणी+ End |केही छैन |चालू पङ्तिको अन्तिममा कर्सरलाई ले जान्छ ।|
|समीक्षामा रहेका सबैको वाचन |numpadPlus |नेत्रवाणी+shift+a |३-औले उँधो घर्षण |चालू समीक्षाबाट तलका पाठहरूलाई पढ्ने छ । जति जति पढ्दै जान्छ, त्यति त्यति कर्सर पनि तल तल सर्दै जान्छ ।|
|समीक्षा कर्सरबाट नक्कल उतार्ने कार्य |नेत्रवाणी+f9 |नेत्रवाणी+f9 |केही छैन |चालू समीक्षा कर्सर रहेको स्थानबाट अगाडिका पाठहरूको नक्कल सार्ने छ । नेत्रवाणीले यथार्थमा नक्कललाई तपाइले कहाँ टाँस्ने हो सो कुरा न बताए सम्म नक्कल उतार्ने काम भने गरेको हुँदैन ।|
|समीक्षा कर्सरमा नक्कल सार्ने काम |नेत्रवाणी+f10 |नेत्रवाणी+f10 |केही छैन |हाल समीक्षा कर्सर रहेको स्थानमा पहिले समीक्षा कर्सरबाट नक्कल उतार्न भनिएका पाठहरूको नक्कल टाँस्ने छ । यसलाई दबाए पछि मात्रै सन्झ्यालले क्लिप पाटीमा पाटहरूको नक्कल सार्ने छ ।|
|पाठको बनावटको जानकारी |नेत्रवाणी+f |नेत्रवाणी+f |केही छैन |हाल समीक्षा कर्सर रहेको स्थानका वर्णको बनावट बताउने छ ।|

<!-- KC:endInclude -->

टिप्पणी: यहाँ उल्लिखित numpad कुञ्जीले कार्य गर्न numlock कुञ्जी बन्द गरेको हुनु पर्दछ ।

डेस्कटप रूपरेखाको प्रयोग गर्दा आधारभूत पाठ समीक्षा आदेशहरूलाई सम्झने सरल तरीका यीनैहरू तीन हरफ र तीन महल भएको तालिकामा छन् भनेर ठान्नु पर्छ । तल देखि माथि पङ्ति, शब्द र वर्ण र दायाँ देखि बायाँ पछिल्लो, चालू र अघिल्लो रूपमा ।
यो रूपरेखा निम्न अनुसार छ ।

|पछिल्लो पङ्ति |चालू पङ्ति |अघिल्लो पङ्ति|
|पछिल्लो शब्द |चालू शब्द |अघिल्लो शब्द|
|पछिल्लो वर्ण |चालू वर्ण |अगिल्लो वर्ण|

### समीक्षामुद्रा {#ReviewModes}

नेत्रवाणीको [पाठ समीक्षा आदेशहरूले](#ReviewingText) चयनित समीक्षा मुद्राका आधारमा चालू विचरण वस्तु, चालू कागजात वा पर्दाका सामाग्रीहरूलाई समीक्षा गर्न सक्छ ।
नेत्रवाणीमा पाइने समीक्षा मुद्रा पुरानो पूर्ण समीक्षा अवधारणाको नयाँ रूप हो ।

निम्न आदेशहरू समीक्षा मुद्रा बीच फेरिन्छ ।
<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |स्पर्श |विवरण|
|---|---|---|---|---|
|अघिल्लो समीक्षा मुद्रामा जान |नेत्रवाणी + numpad7 |नेत्रवाणी + pageUp |दुई औंले माथि घर्षण |अघिल्लो समीक्षा मुद्रामा जान्छ ।|
|पछिल्लो समीक्षा मुद्रामा जान |नेत्रवाणी + numpad1 |नेत्रवाणी + pageDown |दुई औंले तल घर्षण |पछिल्लो समीक्षा मुद्रामा जान्छ ।|

<!-- KC:endInclude -->

#### वस्तुको समीक्षा {#ObjectReview}

वस्तु समीक्षा मुद्रामा हुँदा, तपाई केवल चालू [विचरण वस्तु](#ObjectNavigation) का सामाग्रीहरूलाई मात्र समिक्षा गर्न सक्नु हुन्छ ।
सम्पादन योग्य पाठ भूमी वा अरू आधारभूत पाट नियन्त्रक जस्ता वस्तुका लागि भने यो साधारणतया पाठ सामाग्री हुनेछ ।
अरु वस्तुको हकमा यसको नाम वा मान हुन सक्छ ।

#### कागजातको समीक्षा {#DocumentReview}

जब [विचरण वस्तु](#ObjectNavigation) कागजातहरू उघार्ने मुद्रा जस्तै वेभ पृष्ठ) वा अरू जटील कागजातहरू (जस्तै लोटस सिम्फनी) मा हुन्छ, कागजात समीक्षा मुद्रामा जान सकिन्छ ।
कागजात समीक्षा मुद्राले कागजातहरूका सम्पूर्ण पाठहरूलाई समिक्षा गर्न सकिन्छ ।

जब वस्तु समीक्षा बाट कागजात समीक्षामा प्रवेस गरिन्छ, समीक्षा क्रसर समीक्षा कागजातमा विचरण वस्तु रहेको स्थानमा हुनेछ ।
समीक्षा आदेसले कागजातमा घुमेको बेला, विचरण वस्तु वर्तमान समीक्षा क्रसर भएको स्थानमा पाइएको वस्तुमा स्वतः निर्धारित हुन्छ ।

ख्याल राखौं कि नेत्रवाणी कागजात उघआर्ने मुद्रामा फन्को मारेको बेला स्वतः वस्तु समीक्षा बाट कागजात समीक्षामा  जान्छ ।

#### पर्दा समीक्षा {#ScreenReview}

पर्दा समीक्षा मुद्राले तपाइलाई पर्दामा सक्रिय अनुप्रयोगका देखिएका पाठहरूलाई समिक्षा गर्ने अनुमति दिन्छ ।
यो अरू पर्दा वाचकहरूमा भएको पर्दा समीक्षा वा सुलसुलेको कार्यशैली जस्तै हो 

पर्दा समीक्षा मुद्रामा जाँदा समीक्षा क्रसर चालू [विचरण वस्तु](#ObjectNavigation) रहेको स्थानमा राखीने छ ।.
समीक्षा आदेसले पर्दामा घुमेको बेला, विचरण वस्तु वर्तमान पर्दा समीक्षा क्रसर भएको स्थानमा पाइएको वस्तुमा स्वतः निर्धारित हुन्छ ।

ख्याल राखौं कि नया पर्दा प्रविधीको कारणले केही नया अनुप्रयोगहरूमा नेत्रवाणीले पर्दामा देखिएका केही वा सम्पूर्ण पाठहरूलाई  न पढ्न सक्छ । यसलाई तुरुन्तै पढ्न सक्ने बनाउन सम्भव छैन ।

### सुलसुलेसित विचरण {#toc41}

जब सुलसुलेलाई तपाइले यता उता घुमाउनु हुन्छ, नेत्रवाणीले यसको चुच्चोको मुनि पर्ने पाठहरूलाई पढ्ने गर्दछ ।
नेत्रवाणीले समर्थन गरे सम्म केही नियन्त्रकमा उक्त परिच्छेद आसपासका पाठहरूलाई पनि पढ्ने गर्छ

नेत्रवाणीलाई सुलसुलेको चुच्चोको मुनि परेका [वस्तुको](#Objects) प्रकृति जस्तै सुची, टाँक आदी पनि बताउन सक्ने गरी अभियोजन गर्न सकिन्छ ।
यो सुविधाबाट कहिले कही पुरै नदेख्ने व्यक्तिहरूले पाठ मात्रै सुनेर सबै कुरा थाहा पाउन नसकेको अवस्थामा फाइदा जनक हुने छ ।

नेत्रवाणीमा चालू सुलसुले रहेको स्थानको को-अर्डिनेटहरूमा आधारित भएर पर्दाको सापेक्षतामा यसको स्थान आवाजमा आएको परिवर्तनको माध्यमले थाहा पाउन सक्ने व्यवस्था गरेको छ ।
सुलसुले जति जति माथि छ त्यसैकै आधारमा टीँ गर्ने आवाजको पिच बढ्ने छ र जति जति सुलसुले दाय वा बायाँ भाग्ने छ , सोही अनुसार आवाज बज्ने छ ।
सुलसुले जति जति पर्दाको दायाँ वा बायाँ टाढा रहन्छ, त्यति त्यति नै दायाँ वा बाँका पट्टी stereo speakers वा headphones बजेको आवाज जस्तो हुनेछ ।

यी अतिरिक्त सुविधाहरूलाई नेत्रवाणीमा पूर्व निर्धारित गरिएको छैन ।
यदि तपाइ यी सुविधाहरूको प्रयोग गर्न चाहनु हुन्छ भने तपाइ नेत्रवाणी प्राथमिकता मेनु भित्र [सुलसुलेको अनुकूलता](#MouseSettings) पातोमा गएर यसलाई अभियोजन गर्न सक्नु हुन्छ ।

यद्यपि सुलसुलेलाई भौतिक रूपमा नै यताउता घुमाइन्छ, तर नेत्रवाणीमा केही कुञ्जीलाई सुलसुलेका कुञ्जीको रूपमा पनि प्रयोग गर्न सकिन्छ ।:
<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |विवरण|
|---|---|---|---|
|देब्रे टाँक किटिक्क पार्न |numpadDivide |नेत्रवाणी+leftArrow |सुलसुलेको देब्रे टाँकलाई एक पटक किटिक्क गर्ने छ सामान्यतया गरिने दुई पटक किटिक्क गर्न यही कुञ्जीलाई दुई पटक लगातार दबाउनु पर्छ ।|
|देब्रे टाँक रोक्का गर्न |shift+numpadDivide |नेत्रवाणी+shift+leftArrow |देब्रे टाँकलाई रोक्का गर्ने छ यसलाई फुक्का गर्न उही कुञ्जी फेरि दबाउनु होला । सुलसुलेलाई घिसार्नु पर्दा यो कुञ्जी दबाएर देब्रे टाँक रोक्का गरी या त सुलसुलेलाई भौतिक रूपमा घिसार्नु होला अथवा यसका अरू कुञ्जी चलाउनु होला ।|
|दाहिने टाँक किटिक्क पार्न |numpadMultiply |नेत्रवाणी+rightArrow |सुलसुलेको देब्रे टाँकलाई एक पटक किटिक्क गर्ने छ|
|दाहिने टाँक रोक्का गर्न |shift+numpadMultiply |नेत्रवाणी+Control+] |दाहिने टाँकलाई रोक्का गर्ने छ यसलाई फुक्का गर्न उही कुञ्जी फेरि दबाउनु होला । सुलसुलेलाई घिसार्नु पर्दा यो कुञ्जी दबाएर दाहिने टाँक रोक्का गरी या त सुलसुलेलाई भौतिक रूपमा घिसार्नु होला अथवा यसका अरू कुञ्जी चलाउनु होला ।|
|चालू विचरण वस्तुमा सुलसुलेको प्रवेश |नेत्रवाणी+numpadDivide |नेत्रवाणी+shift+f9 |सुलसुलेलाई चालू विचरण वस्तु र समीक्षा कर्सर रहेको स्थानमा ले जान्छ ।|
|सुलसुलेको स्थानको वस्तुमा विचरण |नेत्रवाणी+numpadMultiply |नेत्रवाणी+shift+f10 |विचरण वस्तुलाई सुलसुले रहेको स्थानमा अवस्थित वस्तुमा पुर्याउँछ ।|

<!-- KC:endInclude -->

## उघारने मुद्रा {#toc42}

जटिल खालका पढ्न मात्रै मिल्ने कागजातहरू जस्तै वेभ पेज आदी लाई उघारने मुद्रामा खोल्न सकिन्छ ।
यसमा Mozilla Firefox, Microsoft Internet Explorer, माइक्रोसफ्ट आउटलुकमा HTML सन्देसहरू, Google Chrome, Adobe Reader र Adobe Flash जस्ता कागजातहरू पर्छन् ।
वैकल्पिक रुपमा   माइक्रोसफ्ट वर्ड कागजातमा उघार्ने मुद्रा उपलब्ध छ ।

उघारने मुद्रामा हुँदा कागजातहरूका सामाग्रीहरू सामान्य रूपमा नै उपलब्ध हुने छन् जसलाई कर्सर कुञ्जीद्वारा साधारण पाठमा जस्तै गरी विचरण गर्न सकिन्छ ।
यो मुद्रामा नेत्रवाणीका सबै [प्रणाली caret](#SystemCaret) कुञ्जी आदेशबाटै कार्य गर्न सकिन्छ । जस्तै सबै पाठको प्रवचन, बनावटको जानकारी, तालिकामा विचरण आदेश आदी इत्यादि ।
समीक्षा गर्दै जाँदा भेट हुने पाठ पढ्नका अतिरिक्त यसका लिङ्क, शीर्षक, जस्ता महत् पूर्ण सूचना को जानकारी पनि दिइन्छ ।

कहिले कहि तपाइले यी कागजातहरूका नियन्त्रकहरूमा सोझै प्रवेश गर्नु पर्ने पनि हुन्छ ।
उदाहरणका लागि, तपाइ कुनै कागजातमा कुनै कुरा लेख्न चाहनु हुन्छ भने सोझै सम्पादन कोठा वा सुची मा जानु हुन्छ यस अवस्थामा सामान्य कर्सरलाई प्रयोग गरिन्छ ।
तपाइ यो कार्य प्रायः सबै जसो कुञ्जीहरू नियन्त्रकमा प्रेषित हुने केन्द्रीयता मुद्रामा गएर गर्नु हुन्छ । उघारने मुद्रामा हुँदा नेत्रवाणी स्वतः केन्द्रीयता मुद्रामा जान्छ यदि तपाइले कुनै निर्दिष्ट नियन्त्रकमा रह दा
tab अथवा किटिक्क पार्नु भयो बने यसले सामान्य रूपमा कार्य गर्ने छ । यसको सट्टा कुनै पनि नियन्त्रकमा tab वा किटिक्क गर्दा यसलाई केन्द्रीयता मुद्रा बाट उघारने मुद्रामा फेरी फर्केर जानु पर्दैन ।
यसको उल्टो, केन्द्रीयता मुद्रा आवश्यक नपर्ने कुनै नियन्त्रकमा पकड वा किटिक्क गर्नु भयो भने फेरी उघारने मुद्रामा नै जान्छ ।
तपाइले केन्द्रीयता मुद्रामा जान enter अथवा space कुञ्जी दबाएर चाहेको नियन्त्रकमा आवश्यक कार्य गर्न सक्नु हुन्छ ।
escape कुञ्जीलाई दबाएमा फेरी उघारने मुद्रामा स्वतः फर्किन्छ ।
यसका अतिरिक्त तपाइ आफैले सोझै केन्द्रीयता मुद्रामा जान सक्नु हुन्छ । यदि यसरी मानवीय रूपले तय गरेको केन्द्रीयता मुद्रा फेरी मानवीय रूपले न उल्टाए सम्म कायम रहि रहन्छ ।

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|उघारने र केन्द्रीयता मुद्राको साटो फेरो |नेत्रवाणी+space |उघारने मुद्रा र केन्द्रीयता मुद्रामा साटिने गर्छ ।|
|केन्द्रीयता मुद्राको बहिर्गमन |escape |यदि यस अघि केन्द्रीयता मुद्रामा स्वतः आएको हो भने फेरी उघारने मुद्रामा नै फर्किन्छ|
|उघारने मुद्राका कागजातहरूको ताजकी करण |नेत्रवाणी+f5 |चालू कागजातहरूका सामाग्रीहरूलाई फेरी बहन गर्छ (यदी केही सामाग्रीहरू कागजातहरूबाट छुटे जस्तो लागेमा) । माइक्रोसफ्ट वर्ड एवम् आउटलुकमा उपलब्ध छैन ।|
|फेला पार्न |नेत्रवाणी+control+f |चालू कागजातमा भएका कुनै पाठहरू फेला पार्नु छ भने यसलाई लेख्न र खोज्नका लागि आवश्यक पर्ने पातो पल्टाउने छ ।|
|अर्को फेला पार्न |नेत्रवाणी+f3 |उही कागजातमा अगाडि ठाउँमा भएको विगतमा खोजिएको पाठ खोज्न यसको प्रयोग गरिन्छ ।|
|अघिल्लो फेला पार्न |नेत्रवाणी+shift+f3 |उही कागजातमा पछाडि ठाउँमा भएको विगतमा खोजिएको पाठ खोज्न यसको प्रयोग गरिन्छ ।|
|लामो विवरण पल्टाउन |नेत्रवाणी+d |यदि चालू तत्त्वमा आबद्ध लामो विवरण छ भने नयाँ सन्झ्याल खोल्ने छ ।|

<!-- KC:endInclude -->

### एक अक्षरीय विचरण {#toc43}

नेत्रवाणी उघारने मुद्रामा भएको बेला निश्चित कागजातहरूमा चाँडो विचरणको लागी भनेर सोझै उफ्रन मिल्ने गरी एक अक्षरीय विचरणको व्यवस्था पनि गरिएको छ ।
ख्याल राखौ कि सबै कागजातहरूले यी आदेसहरूलाई समर्थन गर्दैनन् ।

<!-- KC:beginInclude -->
तलका कुञ्जीहरूले उपलब्ध अगाडिको तत्त्वमा सर्ने अथवा shift सहित दबाएमा पछाडिको सोही तत्त्वमा सर्ने व्यवस्था गरेको छ ।

* h: शीर्षक
* l: सुची
* i: सुची सामाग्री
* t: तालिका
* k: लिङ्क
* n: लिङ्क नभएको पाठ
* f: लेख्ने कोठा
* u: नहेरेको लिङ्क
* v: हेरेको लिङ्क
* e: सम्पादन क्षेत्र
* b: टाँक
* x: चिनो बाकस
* c: संयोज्य बाकस
* r: रेडियो टाँक
* q: हिस्सा उद्धरण
* s: विभाजक
* m: फ्रेम
* g: चित्राङ्कित
* d: कित्ता
* o: गाँसिएको वस्तु
* १ देखि ६: क्रमै ले १ देखि ६ सम्मका उप शीर्षकहरू
* a: टिप्पणिहरू (समिक्षा, सम्पादन संसोधन इत्यादि)

तालिका र सुचीका सुरु अथवा अन्तिम तत्त्वहरूमा सोझै जानका लागी:

| नाम |कुञ्जी |विवरण|
|---|---|---|
|सुरुको एकाइमा जानका लागि |shift+अल्पविराम |तालिका सुची जस्ता लिङ्कहरूका सुरुका एकाइहरू स्थानमा कर्सर जाने छ ।|
|विगतको सामाग्रीको अन्तमा जान |comma |विगतमा गएका (सुची, तालिका, इत्यादि) वस्तुमा रहेको caret बसेको स्थानको अन्तिम सामाग्रीमा जान्छ ।|

<!-- KC:endInclude -->
Gmail, Twitter र फेसबुक जस्ता केहि वेभ अनुप्रयोगहरूले एकल वर्णलाई द्रुत कुञ्जी बनाएका छन् ।
यदि तपाइ उघार्ने मुद्रामा रहेर पड्दा पनि यी एकल वर्नलाई प्रयोग गर्न चाहनु हुन्छ भने नेत्रवाणीको एकल वर्ण विचरण सुविधालाई निस्क्रिय गर्न सक्नु हुन्छ ।
<!-- KC:beginInclude -->
सक्रिय कागजातमा हुँदा एकल वर्णको विचरणको अवस्थालाई साटोफेरो गर्न नेत्रवाणी+shift+Space दबाउनु होला ।
<!-- KC:endInclude -->

### तत्त्वहरूको सुची {#toc44}

तत्त्वहरूको सुचीले उपर्युक्त अनुप्रयोगका कागजातमा भएका विभिन्न तत्त्वहरू को सुचीमा पहुँचता  उपलब्ध गराउ छ ।
उदाहरणका लागि वेभ ब्राउजरमा सुची, शिर्षक वा कित्ताहरु हुन सक्छन् ।
रेडियो टाँकले फरक तत्त्वहरूमा फन्को मार्ने सुविधा उपलब्ध गराउ छ ।
उक्त पातोमा सम्पादन क्षेत्र पनि उपलब्ध हुनेछ जसले तपाइलाई निश्चित पृष्ठमा भएको वस्तु खोज्ने सुविधा पनि दिनेछ ।
तपाइले कुनै पातोमा भएका एउटा सामाग्रीलाई चयन गरे पछि सोही सामाग्रीलाई सक्रिय गराउन उपलब्ध गराएको टाँकलाई प्रयोग गर्न सक्नु हुन्छ
<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|उघारने मुद्राका तत्त्वहरू list |नेत्रवाणी+f7 |चालू कागजातमा भएका फरक तत्त्वहरू को सुची देखाउने छ ।|

<!-- KC:endInclude -->

### गाँसिएको वस्तु {#toc45}

Adobe Flash र Sun Java जस्ता प्रविधि को प्रयोग गरी पृष्ठहरूमा सामाग्रीहरूलाई समावेश गर्न सकिन्छ ।
उघारने मुद्रामा यस्ता सामाग्रीहरू सित जम्का भेट भएमा नेत्रवाणीले यस्ता गाँसिएका वस्तुको जानकारी दिने छ ।
यस्ता गाँसिएका वस्तु सित तपाइले enter कुञ्जी दबाएर अन्तर क्रिया गर्न सक्नु हुन्छ ।
यदि यी वस्तुहरू विचरण योग्य छन् भने तपाइ अरू सामान्य अनुप्रयोगमा जस्तै गरी यस सित अन्त्र क्रिया गर्न सक्नु हुन्छ ।
यस्ता गाँसिएका वस्तुहरू भएका पृष्ठहरूमा फर्किन अलग कुञ्जी आदेशको व्यवस्था पनि गरिएको छ ।
<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|उघारने मुद्राको कागजातमा फर्कन |नेत्रवाणी+control+space |चालू गाँसिएको वस्तुबाट यो वस्तुलाई टाँस्ने कागजातमा फर्कन्छ ।|

<!-- KC:endInclude -->

## गणितिय सामाग्रिको वाचन {#toc46}

Design Science को MathPlayer को प्रयोग गर्दा, समर्थन गर्ने गणितीय सामाग्रीहरुलाई नेत्रवाणीले पढ्न र अन्तरक्रियात्मक विचरण गर्न सक्छ ।
यसका लागि MathPlayer कल्पयन्त्रमा राखिएको हुनु पर्छ ।
MathPlayer अनुप्रयोग https://www.dessci.com/en/products/mathplayer/ मा निशुल्क अनुबहनका लागि उपलब्ध छ ।

नेत्रवाणीले तपसिलका गणीतिय सामाग्रिहरुलाई समर्थन गर्छ ।

* MathML Firefox र माइक्रोसफ्ट इन्टरनेट अन्वेषकमा 
* Design Science MathType माइक्रोसफ्ट वर्ड एवम् प्रस्तुती-पत्रमा
* MathML Adobe Reader मा । स्मरणीय छ कि यो अहिले सम्म आधिकारिक रूपमा उपलब्ध छैन । त्यसैले यो सामाग्री उत्पादन गर्ने सार्वजनिक अनुप्रयोग प्राप्त छैन ।

नेत्रवाणीले कागजातहरुमा विचरण गर्दा समर्थन गर्ने गणीतीय सामाग्रिहरूलाई भेट्टाउन साथ पढ्ने छ ।
यदि ब्रेल पटलको प्रयोग गरिएको छ भने यसलाई पनि देखाउने छ ।

### अन्त्ररक्रियात्मक विचरण {#toc47}

यदि तपाइ प्रारम्भिक रुपमा वाचन सित काम गर्दै हुनु हुन्छ भने अधिकांस रुपमा तपाइले सम्भवत पुरै सामाग्रिलाई एकै पटक सुन्नुको सट्टा अभिव्यक्तिको सानो हिस्सा जाँच्न चाहनु हुन्छ । 

यदि तपाइ उघार्ने मुद्रामा हुनु हुन्छ भने, तपाइले क्रसरलाई गणीतिय सामाग्रिमा पुर्याएर इन्टर कुञ्जी दबाउनु पर्छ । 

यदि तपाइ उघार्ने मुद्रामा हुनु हुन्न भने:

1. समीक्षा क्रसरलाई गणीतिय सामाग्रिमा लैजानु होस् ।
स्वनिर्धारित रुपमा समीक्षा क्रसर पद्धति क्यारेटलाई पछ्याउने भएकोले सामान्यतया पद्धति क्यारेटको प्रयोग गरि चाहेको सामाग्रिमा पहुँच गर्न सक्नु हुन्छ  ।
1. यस पछि निम्न आदेशलाई सक्रिय बनाउनु होस् ।

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|गणीतिय सामाग्रि सितको अन्तर्क्रिया |नेत्रवानी+alt+m |गणितिय सामाग्रिसित अन्तरक्रिया गर्ने छ ।|

<!-- KC:endInclude -->

यो विन्दुमा तपाइले गणीत सम्बन्धी अभिव्यक्तिको अन्वेषण गर्न वाण कुञ्जीहरू जस्ता आदेशहरू चलाउन सक्नु हुन्छ ।
उदाहरणका लागि तपाइले वाञा र दाया कुञ्जि र अभिवर्धकलाई अभिव्यक्तिको कुनै हिस्सामा जान प्रयोग गर्न सक्नु हुन्छ  जस्तै भिन्नमा पुग्न तल वाणको प्रयोग आदी ।
कृपया विस्तृत जानकारिको लागि MathPlayer को दस्तावेज अध्ययन गर्नु होला ।

चालू कागजातमा फर्कनका लागि केवल escape कुञ्जी दबाउनु होला ।

## अनुप्रयोग विशेष नेत्रवाणी आदेश {#toc48}

नेत्रवाणीमा केही अनुप्रयोग विशेष अतिरिक्त आदेशहरू पनि समाविष्ट गरिएका छन् । यसले सामान्य दृष्टि वाचकको सहयोगमा मात्रै कार्य सम्पादन गर्न नसकिने केही निर्दिष्ट कामलाई सहज बनाउन अथवा यीनैहरूमा पहुँच पुर्याउन सहयोग हुनेछ ।

### माइक्रोसफ्ट सब्द {#toc49}

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|चालू टिप्पणीको जानकारी |नेत्रवाणी+Alt+c |प्रणाली क्यारेट अवस्थित स्थानमा रहेको टिप्पणीको पाठ बताउने छ ।|
|महलको शिर्षक कायम |नेत्रवाणी+shift+c |एक पटक दबाउँदा, नेत्रवाणीलाई यो हरफका कोशिकाहरूका लागि प्रथम शिर्षकको रुपमा यस भन्दा तलका हरफहरुमा घुमफिर गर्दा शिर्षकको नाम सहित जानकारी दिनेछ । दुई पटक दबाउँदा यसलाई मेट्ने छ ।|
|हरफको शिर्षक कायम |नेत्रवाणी+shift+r |एक पटक दबाउँदा, नेत्रवाणीलाई यो महलका कोशिकाहरूका लागि प्रथम शिर्षकको रुपमा यस भन्दा दायाँ पट्टीका महलहरूमा घुमफिर गर्दा शिर्षकको नाम सहित जानकारी दिनेछ । दुई पटक दबाउँदा यसलाई मेट्ने छ ।|

<!-- KC:endInclude -->

### माइक्रोसफ्ट एक्सेल {#toc50}

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|महलको शीर्षक कायम |नेत्रवाणी+shift+c |यसलाई एक पटक दबाएमा नेत्रवाणीलाई महल शीर्षक भएको हरफ हो भनेर जानकारी दिने छ, जसले यो हरफ भन्दा तल रहेको महलहरूमा सर्दा स्वचालित रूपमा शीर्षक बताउने छ । दुई पटक दबाएमा यो अनुकूलता मेटिनेछ ।|
|हरफको शीर्षक कायम |नेत्रवाणी+shift+r |यसलाई एक पटक दबाएमा नेत्रवाणीलाई हरफ शीर्षक भएको महल हो भनेर जानकारी दिने छ, जसले यो महल भन्दा दायाँ रहेका हरफहरूमा सर्दा स्वचालित रूपमा शीर्षक बताउने छ । दुई पटक दबाएमा यो अनुकूलता मेटिनेछ ।|
|टिप्पणीको जानकारी |नेत्रवाणी+alt+c |यदी छ भने चालू कोसीमा रहेको टिप्पणी बताउने छ ।|
|तत्त्वहरूको सूची पातो |नेत्रवाणी+f7 |सूत्र, चार्ट अथवा टिप्पणी भएका कोशिकाहरूको सूची देखाउने छ ।|

<!-- KC:endInclude -->

### माइक्रोसफ्ट प्रस्तुति पत्र {#toc51}

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|स्पिकर नोट पढाइको साटोफेरो |control+shift+s |स्लाइड देखाएको बेला यो आदेशले स्लाइडको स्पिकर नोट र स्लाइडका सामाग्रीहरू मा साटो फेरो गर्छ । यसले नेत्रवाणी ले बोल्ने कुरालाई मात्रै प्रबाव पार्छ पर्दामा के देखाइएको छ त्यसलाई होइन ।|

<!-- KC:endInclude -->

### फूबार २००० {#toc52}

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|बाँकी समयको जानकारी |control+shift+r |यदी कुनै ट्रयाक हाल बजिरहेको छ भने यसको बज्न बाँकी समय बताउने छ ।|

<!-- KC:endInclude -->

टिप्पणी: बाँकी रहेको समय बताउने द्रुतमार्ग केवल फूबारमा निर्धारित गरिएको पदावली बनावटमा मात्रै काम गर्छ ।

### मिराण्डा IM {#toc53}

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|हालैका सन्देश बताउ |नेत्रवाणी+control+1-4 |१ देखि ४ सम्मका सङ्ख्या दबाएको आधारमा हालैका सन्देशहरू मद्ये जुन सङ्ख्या दबाएको हो उही स्थानको सन्देश बताउने छ । उदाहरणका लागि नेत्रवाणी+control+2 हालैका सन्देशहरू मद्य दोस्रो सन्देश बताउने छ ।|

<!-- KC:endInclude -->

### पोईडिट {#toc54}

<!-- KC:beginInclude -->

| नाम |कुञ्जी |विवरण|
|---|---|---|
|टिप्पणी सन्झ्यालको जानकारी |control+shift+c |टिप्पणी सन्झ्यालमा भएका टिप्पणीको बारेमा जानकारी दिनेछ ।|
|अनुवादकलाई टिप्पणी सन्झ्यालको जानकारी |control+shift+a |अनुवादकलाई टिप्पणी सन्झ्यालमा भएका टिप्पणीहरूको बारेमा जानकारी दिने छ ।|

<!-- KC:endInclude -->

### स्काइप {#toc55}

<!-- KC:beginInclude -->
बार्तालापमा हुँदा:

| नाम |कुञ्जी |विवरण|
|---|---|---|
|सन्देसको समीक्षा |नेत्रवाणी+control+1-0 |अङ्क दबाएको आधारमा समीक्षा कर्सर भरखरैको सन्देसमा जान्छ र पढ्छ ; जस्तै नेत्रवानी+control+2 ले दोस्रो तहमा रहेको ताजा सन्देस पढ्ने छ ।|

<!-- KC:endInclude -->

## नेत्रवाणीको अभियोजन {#toc56}
### प्राथमिकताहरू {#toc57}

<!-- KC:settingsSection: || नाम | डेस्कटप कुञ्जी | ल्यापटप कुञ्जी | विवरण | -->
अधिकांश अनुकूलताहरू नेत्रवाणी मेनु भित्रको प्राथमिकताहरू भन्ने उप-मेनु मा गएर परिवर्तन गर्न सकिन्छ ।
सबै नेत्रवाणी का अनुकूलताहरूको पातोमा परिवर्तन गरे पछि 'ठीक' टाँकलाई दबाउनु होला ।
कुनै परिवर्तनहरूलाई रद्द गर्नु परेमा 'रद्द गर' भन्ने टाँकलाई अथवा Escape कुञ्जीलाई दबाउनु होला ।
केही अनुकूलताहरूलाई तलका खण्डहरूमा सन्दर्भ मिलेको स्थानमा उल्लिखित गरे अनुसारका द्रुत मार्गको प्रयोग गर्न पनि सकिन्छ ।

स्मरणीय छ कि स्वनिर्धारित रुपमा सबै प्राथमिकता पातोहरूलाई लगानी सङ्केत (कुञ्जीपाटी आदेश र स्प्रर्श सङ्केत आदि) मार्फत पहुँच गर्न सकिदैन ।
यदि तपाइ आफ्नो निर्दिष्ट द्रुत कुञ्जी नभएको पातोमा पहुँच गर्न र आफ्नै सङ्केत थप गर्न  चाहनु हुन्छ  भने [लगानी सङ्केत पातो](#InputGestures) को प्रयोग गर्नु होस् ।

#### सामान्य अनुकूलताहरू (नेत्रवाणी+control+g) {#toc58}

सामान्य अनुकूलता प्राथमिकता पातोमा राखिएको छ ।
यसमा निम्न अनुसारका विकल्पहरूको व्यवस्था गरिएको छ ।

##### भाषा {#toc59}

नेत्रवाणीमा यसका अन्तराकृति र सन्देशहरू देखाउन वा वाचन गर्नका लागि प्रयोग गरिने भाषाको चयन गर्नका निमित्त संयोज्य बाकसमा भाषा चयन विकल्प रोज्ने प्रावधान राखिएको छ ।
यसमा धेरै भाषाहरू संलग्न छन् ।, तर उपभोक्ताले कायम गरेको सन्झ्यालको भाषा नेत्रवाणीको पूर्व निर्धारित भाषा हुने छ ।
यो विकल्पले नेत्रवाणीलाई चालू सन्झ्यालको भाषामा निर्धारित हुन अह्राउने छ ।

ख्याल राखौं कि भाषा परिवर्तन गरे पछि नेत्रवाणीलाई पुनः सुरुवात गर्नु पर्छ ।
नेत्रवाणीले भाषामा परिवर्तन गर्न साथ तपाइलाई पुनः सुरुवात गर्ने हो वा होइन भनी सोध्ने छ ।
'हो' भन्ने टाँकलाई दबाउनु होला, नेत्रवाणी स्वतः सुरुवात हुनेछ ।

##### बहिर्गमन गर्दा अभियोजनलाई बचत गर {#toc60}

चिनो बाकसको रूपमा रहेको यो विकल्प नेत्रवाणीलाई बन्द गर्दा चालू अवस्थामा रहेको अभियोजनलाई बचत गर्ने वा नगर्ने भनेर रोज्न प्रयोग गरिन्छ । यदी टिक लगाइयो भने अर्को पटक यसलाई खोल्दा यही

##### नेत्रवाणी बहिर्गमन गर्दा विकल्प देखाउ {#toc61}

नेत्रवाणीले बहिर्गमन गर्नु अगाडि तपाइले के गर्न चाहनु भएको हो भनि सोध्ने सन्देश पातो देखाउने कि नदेखाउने भनि रोज्ने यो विकल्प चिनो बाकसको रूपमा छ ।
यदी टिक लगाइयो भने बहिर्गमन हुनु पूर्व नेत्रवाणीले 'के तपाइले नेत्रवाणीलाई बन्द गर्न नै चाहनु भएको हो?” अथवा उप-कर्मीलाई असक्षम बनाउन नेत्रवाणी पुनरारम्भ गर्न चाहानु हुन्छ भनि सोध्ने छ ।
यदि टिक लगाइएन भने नेत्रवाणी तुरून्तै बन्द हुनेछ ।

##### नेत्रवाणी सुरु वा बन्द हुँदा आवाज बजाउ {#toc62}

यो विकल्प एउटा चिनो बाकस हो जसलाई चेक गरियो भने नेत्रवाणी सुरु र बन्द हुँदा आवाज बज्ने छ ।

##### आरम्भ तह {#toc63}

नेत्रवाणी कति बेला आरम्भ गर्ने भनि तय गर्ने यो विकल्प संयोज्य बाकसका सुचीको रूपमा रोज्न मिल्ने गरि राखिएको छ ।
सामान्यतया उपभोक्ताले यो विकल्पलाई रोजि रहनु पर्दैन ।
यदि तपाइ यसमा कतै उडुसहरू छन् कि भनि खान तलासी गरेर जानकारी दिन चाहनु हुन्छ भने यो विकल्पमा रोज्ने काम गर्नु होला ।

##### सन्झ्यालको आरम्भ र नेत्रवाणीको सुरुवात सम्बन्धी विकल्प {#toc64}

यदि यो विकल्पलाई सक्षम बनाइयो भने सन्झ्याल आरम्भ हुन साथ नेत्रवाणी पनि स्वतः सुरु हुने छ ।
यो विकल्प केवल कल्पयन्त्रमा भित्र्याइएको नेत्रवाणीको प्रतिमा मात्रै उपलब्ध हुनेछ ।

##### सन्झ्याल आरम्भ पर्दा सितै नेत्रवाणीको सुरुवात (प्रशासकीय अधिकार चाहिन्छ ) {#toc65}

यदि उपभोक्ताको नाम र गोप्य शब्द लेखे पछि मात्रै सन्झ्याल आरम्भ हुने गरि अभियोजन गरिएको छ र यो विकल्पलाई तपाईले सक्षम बनाउनु भयो भने नेत्रवाणी सन्झ्याल आरम्भ पर्दा सितै सुरु हुनेछ ।
यो विकल्प केवल कल्पयन्त्रमा भित्र्याइएको नेत्रवाणीको प्रतिमा मात्रै उपलब्ध हुनेछ ।

##### आरम्भ र सुरक्षित पर्दामा चालू अनुकूलताहरूको बचत सम्बन्धी विकल्प {#toc66}

यो विकल्पको टाँकलाई दबाइयो भने चालू नेत्रवाणी प्रयोग कर्ताको अभियोजनलाई यसले आफ्नो प्रणालीको अभियोजनहरू जस्तै नेत्रवाणीको आरम्भ, उपभोक्ता खाताको नियन्त्रण र अरू सुरक्षित सन्झ्याल पर्दा इत्यादि का अभियोजन थैलीहरूमा बचत गर्ने छ ।
यी सबै अभियोजनहरू प्रणाली थैलीमा हस्तान्तरित भएको यकिन गर्न पहिले चालू अभियोजनहरूलाई control+नेत्रवाणी+c कुञ्जी दबाएर अथवा नेत्रवाणी मेनुको 'अभियोजनलाई बचत गर' भन्ने उप-मेनुमा गएर बचत गर्नु होला ।
यो विकल्प केवल कल्पयन्त्रमा भित्र्याइएको नेत्रवाणीको प्रतिमा मात्रै उपलब्ध हुनेछ ।

##### नेत्रवाणीको स्वचालित अद्यावधि करण {#toc67}

यदि यो विकल्पलाई सक्षम बनाएको छ भने नेत्रवाणीको नयाँ संस्करण डाउनलोडका लागि वेभ साइटमा उपलब्ध हुन साथ तपाइलाई यसको जानकारी दिइने छ ।
तपाईले व्यक्तिगत रूपमा नेत्रवाणी मेनु भित्रको सहयोग उप-मेनुमा गएर 'अद्यावधिक जाँच' भन्ने विकल्प पनि रोज्न सक्नु हुन्छ ।

#### संश्लेषकको चयन (नेत्रवाणी+control+s) {#toc68}

नेत्रवाणीले प्रयोग गर्ने संश्लेषकको यकिन गर्न प्राथमिकता मेनु भित्रको संस्लेषक उप-मेनुमा गएर संस्लेषक पातोमा निर्धारित गर्नु पर्दछ ।
एक पटक आफूले चाहेको संश्लेषक छानेर 'ठीक' टाँकलाई दबाए पछि नेत्रवाणीले उक्त शंश्लेषकलाई बहन गर्ने छ ।
यदी चयन गरिएको संश्लेषकलाई बहन गर्न सकिएन भने तपाइलाई यसको सूचना दिइने छ र पुरानै संश्लेषकले निरन्तरता पाउनेछ ।

##### संश्लेषक {#toc69}

नेत्रवाणीले वाचन प्रतिफलका लागि प्रयोग गर्ने संश्लेषको चयन गर्न यो विकल्पले रोज्ने अवसर प्रदान गर्ने छ ।

नेत्रवाणीले समर्थन गर्ने संश्लेषको सुची जान्न कृपया [संश्लेषक समर्थित वाचन](#SupportedSpeechSynths) खण्डमा हेर्नु होला ।

यो सुचीमा सधैँ देखा पर्ने एउटा विशेष सामाग्री 'मौनता' हो जुन विकल्प नेत्रवाणीलाई मौन राख्नु पर्दा रोजिन्छ ।
यो विकल्प नेत्रवाणीलाई ब्रेलमा चलाउन चाहने अथवा नेत्रवाणीको विकासमा संलग्न देख्ने क्षमता भएका वाचन पटल चलाउन मन पराउने मानिसहरू लाई काम लाग्छ ।

##### प्रतिफल उपकरण {#toc70}

यो विकल्पले तपाइले रोजेको ध्वनि कार्ड मार्फत नेत्रवाणीले चयन गरिएको संश्लेषकलाई आवाजको प्रतिफल दिन अह्राउने छ ।

#### आवाजको अनुकूलता (नेत्रवाणी+control+v) {#VoiceSettings}

प्राथमिकता मेनु भित्र रहेको आवाजको अनुकूलता उप-मेनुमा जाँदा तपाइले चाहेको आवाज रोज्ने विकल्प पातो पाउनु हुनेछ ।
जहाँबाट पनि वाचनलाई वैकल्पिक रूपमा नियन्त्रण गर्ने उपाय हेर्न [संश्लेषक अनुकूलता चक्र](#SynthSettingsRing) खण्डमा जानु होला ।

आवाजको अनुकूलता पातोमा निम्न विकल्पहरू विद्यमान छन् ।

##### आवाज {#toc72}

यो पातो पल्टाउन साथ पहिलो विकल्प स्वरूप स्थापित संश्लेषकमा उपलब्ध सबै आवाजहरू संयोज्य बाकस सुचीको रूपमा उपलब्ध हुनेछन् ।
तपाइ वाण कुञ्जीहरूलाई चलाएर विभिन्न आवाजहरू सुन्न र रोज्न सक्नु हुन्छ ।
बायाँ र उँभो वाणको प्रयोग गरी सुचीमा माथि रहेका र दायाँ वा उँधो वाणको प्रयोग गरी उँधो रहेका आवाजहरूको चयन गर्न सकिन्छ ।

स्वरहरू
यदि तपाइ नेत्रवाणी सित पोको पारेर पठाएको ईइस्पिक् नामको संश्लेषको प्रयोग गर्दै हुनु हुन्छ भने यसमा उपलब्ध स्वरहरूको विकल्प रोज्न संयोज्य बाकस भित्रका विभिन्न स्वरहरू मध्ये कुनैलाई रोज्न सक्नु हुन्छ ।
ईइस्पिक् संश्लेषकमा उपलब्ध स्वरहरूले फरक शैलीको ध्वनि प्रदान गर्ने हुनाले झन्डै आवाज जस्तै मान्न सकिन्छ ।
केही स्वरहरू पुरुषको जस्तै, केही स्वरहरू महिलाको जस्तै, केही स्वरहरू भ्यागुतोको जस्तै र कानेखुसी गरेको जस्तै आवाज दिने छन्

##### दर {#toc73}

यो विकल्पले तपाइलाई आवाजको दर परिवर्तन गर्ने सुविधा प्रदान गर्दछ ।
यसमा ० देखि १०० सम्म चयन गर्न सकिने सूलुली राखिएको छ । ० भनेको सबै भन्दा ढिलो र १०० भनेको तिब्रतम दर हो ।

##### पीच {#toc74}

यो विकल्पले तपाइलाई चालू आवाजको पीच परिवर्तन गर्ने सुविधा प्रदान गर्दछ ।
यसमा ० देखि १०० सम्म चयन गर्न सकिने सूलुली राखिएको छ । ० भनेको सबै भन्दा मलिन र १०० भनेको सबै भन्दा चर्को पिच हो ।

##### आयतन {#toc75}

स्वरको आयतन रोज्ने यो विकल्पमा ० देखि १०० सम्म चयन गर्न सकिने सूलुली राखिएको छ । ० भनेको सबै भन्दा मसिनो आवाज र १०० भनेको सबै भन्दा चर्को आवाज हो ।

##### उतार-चढा व {#toc76}

पिचमा उतार चढा व रोज्ने यो विकल्प यहाँ सुलूलीको रूपमा राखिएको छ । यो विकल्पले तपाइलाई संश्लेषक वाचनको उतार-चढा व निर्धारण गर्न सुविधा प्रदान गर्छ । यस्तो सुविधा हाल केवल ईस्पीक संश्लेषकमा मात्रै उपलब्ध छ ।

##### स्वचालित भाषाको परिवर्तन {#toc77}

यो विकल्पले तपाइलाई नेत्रवाणीले पाठको भाषाको आधारमा स्वतः संश्लेषको भाषा पनि साटो फेरो गर्ने वा नगर्ने भनेर रोज्ने अवसर प्रदान गर्छ ।
यो विकल्प सक्षम अवस्थामा निर्धारित गरिएको छ ।
हाललाई केवल ईइस्पिकले मात्रै स्वतः भाषा अनुसारको संश्लेषको परिवर्तन गर्ने सुविधा उपलब्ध गराएको छ ।

##### स्वचालित भाषिकाको परिवर्तन {#toc78}

यदी स्वतः भाषाको परिवर्तनको विकल्प रोजिएको छ भने, यो चिनो बाकसमा टिक लगाएर तपाइले भाषिकामा साटो फेरो गर्न सक्नु हुन्छ ।
उदाहरणका लागी, यदि यो विकल्पलाई सक्षम गरियो भने, अमेरीकि आवाजमा पढि रहेको समयमा कुनै कागजातमा ब्रिट्रिस अङ्ग्रेजी छ भनेर उल्लेख भएमा संश्लेषक ब्रिट्रिस स्वादमा जानेछ  ।
यो विकल्पलाई असक्षम रूपमा पूर्व निर्धारित गरिएको छ ।

<!-- KC:setting -->

##### चिन्ह/सङ्केत तह {#toc79}

कुञ्जी: नेत्रवाणी+p

यो विकल्पले तपाइलाई कुन कुन चिन्ह र सङ्केतहरूलाई शब्दको रूपमा उच्चारण गर्ने भनि रोज्ने अवसर प्रदान गर्छ ।
जस्तै -यदि 'सबै' भन्ने विकल्प रोजियो भने सबै चिन्ह सङ्केतहरू शब्दको रूपमा नेत्रवाणीले वाचन गर्ने छ ।
यो विकल्प चालू संश्लेषकमा मात्रै नभएर सबैमा लागू हुन्छ ।

##### सङ्केत एवम् वर्णहरूको प्रसोधन गर्न आवाज भाषाको विश्वास {#toc80}

पूर्व निर्धारण गरिए अनुसार, यो विकल्पले नेत्रवाणीलाई चालू आवाज भाषालाई  सङ्केत एवम् वर्णहरूको प्रसोधन गर्दा भर पर्न सकिन्छ भनेर जनाउ दिनेछ ।
यदि नेत्रवाणीले कुनै निर्दिष्ट संश्लेषक वा आवाजमा चिन्हहरू गल्ती भाषामा पढि रहेको छ भने, तपाइले यो विकल्पलाई होइन मुद्रामा राखेर नेत्रवाणीलाई विस्वव्यापी भाषामा अनुकूलित हुन वाध्य पार्न सक्नु हुन्छ । 

##### Capital पिचको प्रतिशतमा परिवर्तन {#toc81}

यो विकल्पले नेत्रवाणीले capital अक्षर भेट्टाउँदा पिचमा कति प्रतिशत बढाएर आवाज दिइयोस् भनेर तपाइ चाहना राख्नु हुन्छ त्यही अङ्क लेख्ने सम्पादन कोठा प्रदान गर्दछ ।
यो अङ्क प्रतिशतमा हुन्छ जहाँ ऋणात्मक मानले पिच घटाउँछ र धनात्मक मानले यसलाई बढाउँछ ।
यदि पिचमा कुनै घट बढ गर्नु छैन भने ० प्रतिशत लेख्नु होला ।

##### capitals अगाडी हुँदा “cap” भन {#toc82}

चिनो बाकसको रूपमा उपलब्ध यो विकल्पलाई टिक लगायो भने नेत्रवाणीले capital भएको शब्दको हिज्जे आदी बताउँदा पहिले “cap” भन्ने छ ।
सामान्यतया नेत्रवाणीले capital भेट्टाउँदा पीचमा वृद्धि गरी वाचन गर्दछ तर कतिपय संश्लेषकमा यस्तो सुविधा हुँदैन । सायद यो सुविधा यस्ता संश्लेषकको प्रयोग हुँदा लाभदायक हुन्छ ।

##### capitals हुँदा टीँ गर {#toc83}

यदि यो चिनो बाकसमा टिक लगायो भने नेत्रवाणीले capital अक्षर भेट्टाउन साथ टीँ गर्ने छ ।
capital अक्षर भेट्टाउँदा सोको सङ्केत गर्न नसक्ने संश्लेषकहरूको प्रयोग हुँदा यो विकल्पले सो अभावको पूर्ति गर्ने छ ।

==== समर्थन गर्छ भने हिज्जे कार्यकुशलताको प्रयोग गर ==== [VoiceSpellingFunctionality]
कुनै कुनै शब्दहरू एक अक्षरका हुन्छन् । तर यस्ता शब्दहरूको उच्चारण शब्दको रूपमा र वर्णको रूपमा हुँदा फरक फरक हुन्छ ।
जस्तै अङ्ग्रेजी भाषाको पहिलो अक्षर “a” वर्ण र शब्द दुबै हो । वर्णको रूपमा यसलाई “ए” र शब्दको रूपमा यसलाई “अ” भनिन्छ तर यो नियम नेपालीमा लागू हुँदैन ।
यो विकल्प एउटै वर्णलाई शब्द र अक्षरको रूपमा फरक फरक किसिमले उच्चारण गर्न नसक्ने संश्लेषकमा काम लाग्छ तर यस्तो प्रावधान प्रायः सबै संश्लेषकमा पाइँदैन ।
प्राय सबै शंस्लेषकले यसलाई समर्थन गर्छन् ।

यो विकल्पलाई सामान्यतया सक्षम बनाएर राख्नु पर्छ ।
तर कतिपय माइक्रोसफ्टका संश्लेषकहरूले यस विकल्पमा काम गर्दैनन् ।
यदी एउटा अक्षरको उच्चारणमा समस्या आयो भने तपाइले यसलाई निष्क्रिय बनाउनु (टिक हटाउनु) होला ।

#### संश्लेषको अनुकूलता चक्र {#SynthSettingsRing}

यदी तपाई आवाजको अनुकूलता पातोमा नगई चाँडै वाचनको अनुकूलता परिवर्तन गर्न चाहनु हुन्छ भने केही नेत्रवाणी कुञ्जी आदेशले अधिकांश संशलेषकको अनुकूलता सोझै परिवर्तन गर्ने सुविधा प्रदान गर्छन् ।
<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |विवरण|
|---|---|---|---|
|अघिल्लो संश्लेषक अनुकूलतामा जान |नेत्रवाणी+control+rightArrow |नेत्रवाणी+control+rightArrow |चालू अवस्थामा रहेको संश्लेषकलाई पोको पारेर सुचीमा अगाडी रहेको (अन्तिम भए पहिलो) संश्लेषकको अनुकूलतामा जान्छ ।|
|पछिल्लो संश्लेषक अनुकूलतामा जान |नेत्रवाणी+control+leftArrow |नेत्रवाणी+control+leftArrow |चालू अवस्थामा रहेको संश्लेषकलाई पोको पारेर सुचीमा पछाडी रहेको (पहिलो भए अन्तिम) संश्लेषकको अनुकूलतामा जान्छ ।|
|चालू वाचनको अनुकूलतामा वृद्धि |नेत्रवाणी+control+upArrow |नेत्रवाणी+control+upArrow |चालू वाचन अनुकूलतामा वृद्धि गर्ने छ । जस्तै दरमा वृद्धि, अर्को आवाजको चयन, आयतनमा वृद्धि इत्यादि ।|
|चालू वाचनको अनुकूलतामा कमी |नेत्रवाणी+control+downArrow |नेत्रवाणी+control+downArrow |चालू वाचन अनुकूलतामा कमी ल्याउने छ । जस्तै दरमा कमी, पछिल्लो आवाजको चयन, आयतनमा कमी इत्यादि ।|

<!-- KC:endInclude -->

#### ब्रेलको अनुकूलता {#toc85}

ब्रेल सम्बन्धी पातो हेर्न प्राथमिकता मेनु भित्र रहेको ब्रेलको अनुकूलता विकल्पमा जानु पर्छ ।

##### ब्रेल पटल {#toc86}

ब्रेलको अनुकूलता पातोमा पहिलो विकल्पको रूपमा तपाइले ब्रेल पटल नामको संयोज्य बाकस पाउनु हुनेछ ।
तपाइको प्रणालीमा उपलब्ध ब्रेल पटल चालकहरूको सुची अनुसार विविध विकल्पहरू तपाइ समक्ष प्रस्तुत हुने छन् ।
वाण कुञ्जीको मद्दतले यी विकल्पहरूमा चहार्नु होस् ।

'ब्रेल छैन' को अर्थ तपाइ कुनै ब्रेलको प्रयोग गरी रहनु भएको छैन भन्ने हुन्छ ।

कृपया समर्थित ब्रेल पटलको बारेमा विस्तृत जानकारीका लागि [समर्थित ब्रेल पटल](#SupportedBrailleDisplays) खण्ड हेर्नु होला ।

##### स्थल {#toc87}

यदि, यो विकल्प उपलब्ध छ भने, चय नित ब्रेल पटलसित सम् वाद गर्न तपाइलाई कुन स्थल वा कस्तो किसिमको जडान भनि रोज्ने अनुमति प्रदान गर्नेछ ।
यो तपाइलाई उपलब्ध ब्रेल पटलहरू मद्ये सम्भावित रोजाइ गर्ने एउटा संयोज्य बाकस हो ।

निर्धारित गरे अनुसार, नेत्रवाणीले स्वचालित रूपमा नै स्थलको पता लगाउने छ, जसको अर्थ हुन्छ तपाइको प्रणालीमा उपलब्ध USB र bluetooth उपकरणहरूको चियो गरी ब्रेल उपकरण सित स्वतः जडान स्थापित गरिन्छ ।
यद्यपि, कुनै ब्रेल पटलमा भने, तपाइले कुन स्थल रोज्ने भनि स्वतन्त्र रूपमा रोज्न सक्नु हुन्छ ।
यदि तपाइको ब्रेल पटलले “स्वचालित” (जसले नेत्रवाणीलाई निर्धारित स्थल चयन प्रक्रिया बताउने छ), “USB”, “Bluetooth” र आगत क्रमाङ्क सम् वाद स्थल जस्ता प्रकृतिका सम् वादलाई समर्थन गर्छ भने; साझा उपकरण हुन सक्छन् ।

यदि तपाइको ब्रेल पटलले स्वतः स्थल पता लगाउन सक्छ भने यो विकल्प उपलब्ध हुने छैन ।

तपाइले ब्रेल सम्बन्धी खण्ड [समर्थित ब्रेल पटल](#SupportedBrailleDisplays) मा समर्थित सम् वाद र उपलब्ध स्थलको बारेमा विस्तृत जानकारी पाउन सक्नु हुन्छ ।

==== प्रतिफल तालिका ====क
यस पछिको विकल्पको रूपमा तपाइले यो पातोमा ब्रेल प्रतिफल तालिका संयोज्य बाकस पाउनु हुनेछ ।
यो संयोज्य बाकसमा, तपाइले विभिन्न भाषाका ब्रेल तालिका, ब्रेल स्तरीयता र तह पाउनु हुनेछ ।
चयन गरिएको तालिकाको प्रयोग गरी पाठहरूलाई ब्रेलमा अनुवाद गरेर तपाइको ब्रेल पटलमा प्रस्तुत गरिन्छ ।
तपाइ सुचीमा रहेका एउटा ब्रेल तालिका बाट अर्को ब्रेल तालिकामा वाणहरूको प्रयोग गरी घुम्न सक्नु हुन्छ ।

##### लगानी तालिका {#toc88}

यस अघिको विकल्पको पूरकको रूपमा, तपाइले अर्को ब्रेल लगानी तालिका संयोज्य बाकस अनुकूलता पाउनु हुनेछ ।
चय नित तालिका तपाइको ब्रेल पटलमा Perkins-शैलीको कुञ्जीपाटी द्वारा लेखिएका ब्रेल अक्षरहरूलाई सादा पाठमा अनुवाद गर्नका लागि प्रयोग गरिन्छ ।
नेत्रवाणीले हाल केवल कल्पयन्त्र ब्रेल लगानी मात्रै समर्थन गर्छ, यस कारण 8 dot कल्पयन्त्र ब्रेल तालिकाहरू मात्रै देखाइने छ ।
तपाइ सुचीमा रहेका एउटा ब्रेल तालिका बाट अर्को ब्रेल तालिकामा वाणहरूको प्रयोग गरी घुम्न सक्नु हुन्छ ।

ख्याल राखौं कि यो विकल्प यदि तपाइको ब्रेल पटलले Perkins-शैलीको कुञ्जीपाटीलाई र यो सुविधालाई उक्त ब्रेल पटलको चालकले समर्थन गर्छ भने मात्रै उपयोगी हुनेछ ।
यदि पटलमा जोडिएको कुञ्जीपाटीको लगानी समर्थन गरिएन भने, यसलाई [समर्थित ब्रेल पटल](#SupportedBrailleDisplays) खण्डमा हेर्नु पर्ने हुन्छ ।

##### कल्पयन्त्र ब्रेलको कर्सर भएको शब्द सम्म विस्तार {#toc89}

यो विकल्पले कर्सर मुनि रहेको शब्दलाई न खाँदिएको कल्पयन्त्र ब्रेलको रूपमा प्रस्तुत गर्ने अनुमति प्रदान गर्छ ।

##### कर्सर चम्किने दर {#toc90}

यो विकल्प सङ्ख्यात्मक भूमि हो जसले तपाइलाई प्रति मिलि सेकेन्डमा कर्सर चम्किने दर बताउने छ ।

##### सन्देश समाप्ति समय (सेकेन्ड) {#toc91}

यो विकल्प सङ्ख्यात्मक भूमि हो जसले नेत्रवाणीका सन्देसहरू लाई ब्रेल पटलमा कति बेर सम्म देखाउने भनि नियन्त्रण गर्छ ।
सुन्य मान दिनाले सन्देसको प्रदर्शणिलाई पुरै रुपमा निस्क्रिय बनाउने छ ।

<!-- KC:setting -->

##### ब्रेल समीक्षा {#BrailleTether}

कुञ्जी: नेत्रवाणी+control+t

यो विकल्पले तपाइलाई ब्रेल पटल प्रणाली केन्द्रीयता अथवा विचरण वस्तु / समीक्षा कर्सरमा जाने भनेर रोज्ने अवसर प्रदान गर्दछ ।

##### अनुच्छेद अनुरूप पढ {#toc93}

यदि सक्रिय बनाइयो भने ब्रेल पटलले पङ्‌क्तिको सट्टा अनुच्छेद देखाउने छ ।
यसका अतिरिक्त, अघिल्लो र पछिल्लो पङ्‌क्ति आदेशमा तद् अनुरूपको अनुच्छेदमा विचरण गर्ने छ ।
यसको मतलब यदी पटलमा धेरै पङ्‌क्तिहरू छन् भने तिनिहरूलाई एक एक गरेर सार्नु पर्दैन ।
यसले धेरै ठूलो पाठहरू पढ्न सजिलो बनाउने छ ।
यसलाई अक्षमतामा निर्धारित गरिएको छ ।

##### सम्भव भए सम्म शब्द न टुक्र्याउनु होस् । {#toc94}

यसलाई सक्रिय बनाइएको खण्डमा, ब्रेल पटलको छेउमा नअटाउने लामो शब्द टुक्रिने छैन । 
यसको सट्टा ब्रेल पटलमा  केही खाली भाग हुनेछ ।
यदि तपाइले त्यो पटललाई सार्नु भयो भने तपाइ त्यो पुरै सब्द पड्न सक्नु हुन्छ ।
यसलाई कहिले काही शब्द पट्याउने भनिन्छ ।
स्मरणीय छ कि  यदि सब्द पटलमा नअटाउने गरि निकै लामो छ भने स्वतः टुक्रिन्छ ।

यदि यसलाई असक्षम बनाइयो भने देखाउन सकिने सम्मको शब्द मात्र देखाई बाकिलाई  भने काटिने छ ।
जब तपाइले पटललाई सार्नु हुन्छ, सब्दको बाकि टुक्रा भने पढ्न सक्नु हुन्छ ।

यसलाई योग्य बनाउँदा पढ्न त सहज हुन्छ तर पटल भने निकै पटक सार्नु पर्छ ।

#### कुञ्जीपाटीको अनुकूलता (नेत्रवाणी+control+k) {#toc95}

कुञ्जीपाटीको अनुकूलता परिवर्तन गर्ने यो विकल्प प्राथमिकता मेनु भित्र 'कुञ्जीपाटीको अनुकूलता' भन्ने उप-मेनुको रूपमा उपलब्ध छ ।
यसमा निम्न अनुसारका विकल्पहरू विद्यमान छन् ।

##### कुञ्जीपाटीको रूपरेखा {#toc96}

नेत्रवाणीमा कुञ्जीको रूपरेखा रोज्न संयोज्य बाकसको रूपमा यो विकल्प उपलब्ध छ । हाल नेत्रवाणीमा डेस्कटप र ल्यापटप गरी दुई वटा विकल्पहरू उपलब्ध छन् ।

##### capslock कुञ्जीलाई नेत्रवाणी परिवर्तकमा नियुक्ति {#toc97}

यदी यो चिनो बाकसमा टिक लगाइयो भने capslock कुञ्जी नेत्रवाणी परिवर्तक कुञ्जीको रूपमा परिवर्तित हुनेछ ।

##### विस्तारित insert कुञ्जीलाई नेत्रवाणी परिवर्तकमा नियुक्ति {#toc98}

यदी यो चिनो बाकसमा टिक लगाइयो भने सामान्यतया वाण कुञ्जीहरू भन्दा माथि र home एवम् end) कुञ्जी नजिकै राखिने गरेको विस्तारित insert कुञ्जी नेत्रवाणी परिवर्तक कुञ्जी हुनेछ ।

##### numpad insert कुञ्जीलाई नेत्रवाणी परिवर्तकमा नियुक्ति {#toc99}

यदी यो चिनो बाकसमा टिक लगाइयो भने number pad को insert कुञ्जी नेत्रवाणी परिवर्तक कुञ्जीको रूपमा परिवर्तित हुनेछ ।

यदी कुनै पनि कुञ्जीलाई नेत्रवाणी कुञ्जी बनाइएको छैन भने केहि नेत्रवाणी आदेसहरूको पहुँच सम्भव हुनेछैन ।
यस कारण यदी कुनै पनि कुञ्जीलाई चयन नगरी ठिक टाँक दबाइयो भने कुञ्जीपाटीको अनुकूलता पातोमा त्रुटी सन्देस देखिने छ । 
यो त्रुटी सन्देस मेटेर तपाइले कुञ्जीपाटीको पातोलाई हटाउन कुनै एउटा कुञ्जी चयन गर्नु पर्ने हुन्छ 

<!-- KC:setting -->

##### टङ्कण गरेको वर्ण बताउ {#toc100}

कुञ्जी: नेत्रवाणी+2

सक्रिय बनाएको खण्डमा नेत्रवाणीले कुञ्जीपाटीमा टङ्कण गरेको वर्ण बताउने छ ।

<!-- KC:setting -->

##### टङ्कण गरेको शब्द बताउ {#toc101}

कुञ्जी: नेत्रवाणी+3

सक्रिय बनाएको खण्डमा नेत्रवाणीले कुञ्जीपाटीमा टङ्कण गरेको शब्द बताउने छ ।

##### टङ्कित वर्णहरूमा वाचनको अवरुद्धता {#toc102}

यदि खुल्ला छ भने, यो विकल्पले प्रत्येक पटक टङ्कण गर्दा वाचनलाई अवरुद्ध गर्ने छ । यो खुल्ला अवस्थामा निर्धारित हुन्छ ।

##### Enter कुञ्जीमा वाचनको अवरुद्धता {#toc103}

यदि खुल्ला छ भने, यो विकल्पले प्रत्येक पटक Enter कुञ्जी दबाउँदा वाचनलाई अवरुद्ध गर्ने छ । यो खुल्ला अवस्थामा निर्धारित हुन्छ ।

##### सम्पूर्ण पठनमा योजना पढाइको स्विकृति {#toc104}

यदी हुन्छ भएमा, केही विचरण आदेसहरू जस्तै उघार्ने मुद्राका छरितो आदेसहरू अथवा हरफ वा अनुच्छेदमा हिडेको बेला सबै पठनको प्रकृया रोकिने छैन बरू सबै पठनको प्रकृया नया स्थानमा सरेर जारी रहन्छ ।

##### Caps Lock लाई खुल्ला राखी साना वर्ण लेख्दा टीँ गर्ने {#toc105}

यदी यो विकल्पलाई योग्य बनाएको छ र caps lock कुञ्जीलाई खुल्ला राखी Shift कुञ्जी दबाउँदै साना अक्षर लेख्ने प्रयास गरियो भने नेत्रवाणीले टीँ गरेर सूचना दिनेछ ।
सामान्यतया caps lock लाई खुल्ला राखी Shift कुञ्जी दबाउने कार्य गरिँदैन ।
तर यस्तो नमिल्ने कुरा अनजानमा हुन जान्छ त्यसैले यो विकल्प राखिएको हो ।

<!-- KC:setting -->

##### आदेश कुञ्जीको वाचन {#toc106}

कुञ्जी: नेत्रवाणी+4

यदि यसलाई सक्षम बनाइयो भने नेत्रवाणीले गैह्र वर्ण टङ्कण कुञ्जीहरूलाई बताउने छ । मूलतः यो विकल्प control र अर्को अक्षरको समीकरण जस्ता कुञ्जी दबाउँदा सक्रिय हुन जान्छ ।

##### अन्य अनुप्रयोग द्वारा कुञ्जीको सञ्चालन {#toc107}

नेत्रवाणीले प्रसोधन गर्नु पर्ने वाचन पहिचान वा स्पर्श पर्दा जस्ता अनुप्रयोग द्वारा सक्रिय गराइने कुञ्जीलाई उपभोक्ताले नियन्त्रण गर्न यो विकल्पले अनुमति दिनेछ ।
यो विकल्पलाई पुर्व निर्धारित गरिएको छ । यद्यपि केही उपभोक्ताहरू जस्तै युनिकि यन्त्रप्राण द्वारा टङ्कण गर्ने भियतनामीहरू यसलाई निस्क्रिय गर्न पर्ने हुन्छ ।

#### सुलसुलेको अनुकूलता (नेत्रवाणी+control+m) {#MouseSettings}

सुलसुलेको अनुकूलता सम्बन्धी जानकारी प्राथमिकता मेनु भित्र सुलसुलेको अनुकूलता उप-मेनुमा राखिएको छ ।
यसमा निम्न अनुसारका सामाग्रीहरू राखिएका छन् ।

##### सुलसुलेको आकारमा भएको परिवर्तन बारे जानकारी {#toc109}

यो विकल्पमा एउटा चिनो बाकस राखिएको छ जसलाई टिक लगायो भने सुलसुलेको आकृतिमा परिवर्तन आएको खण्डमा नयाँ बनेको आकृति बताउने छ ।
कहिले कहीँ सन्झ्यालको कुनै एउटा नियन्त्रकबाट अर्को नितान्त फरक प्रकृतिको नियन्त्रकमा सुलसुलेको चुच्चोले प्रवेश गर्यो भने यसको आकृति फेरिन जान्छ ।

<!-- KC:setting -->

##### सुलसुले दौडाहा योग्य बनाउ {#toc110}

कुञ्जी: नेत्रवाणी+m

यदि योग्य बनाइयो भने, नेत्रवाणीले पर्दाको वरिपरि सुलसुलेको चुच्चो घुमफिर गर्दा यसको मुनि परेका पाठहरूलाई वाचन गर्ने छ । यसले तपाइलाई वस्तुको विचरण मार्फत खोजतलास गर्नु को सट्टा सुलसुलेलाई भौतिक रूपमा घुमाएर पर्दामा भएका चीजहरू पता लगाउन सहयोग गर्नेछ ।

##### पाठ एकाइ क्षेत्र {#toc111}

यदि नेत्रवाणीलाई सुलसुलेको मुनि परेका पाठहरूलाई वाचन गर्ने मुद्रामा कायम गरियो भने, यो विकल्पले तपाइलाई कति पाठहरूलाई वाचन गर्ने भनेर तोक्ने सुविधा दिनेछ ।
यसका विकल्पहरू वर्ण, शब्द, पङ्ति र अनुच्छेद हुन् ।

##### सुलसुले वस्तुमा पेस हुँदाको भूमिका बताउ {#toc112}

यदि यो चिनो बाकसलाई टिक लगाइयो भने, नेत्रवाणीले सुलसुले प्रवेश गरेको वस्तुको भूमिका (प्रकार) घोषणा गर्ने छ ।

##### सुलसुले हिँड्दा श्रव्य विन्दु बताउ {#toc113}

यो चिनो बाकसमा टिक लगाउँदा नेत्रवाणीले सुलसुले घुमेका आधारमा टीँ गर्ने छ, ताकि उपभोक्ताले पर्दाको आकारको परिप्रेक्ष्यमा सुलसुले कहाँ निर छ भनेर जान्न सकुन् ।
सुलसुले पर्दाको जति जति माथी हुन्छ उति कै हिसाबले पीच उच्च हुनेछ ।
सुलसुले पर्दाको जति जति देब्रे पट्टि हुन्छ उति कै हिसाबले देब्रे पट्टिको स्पिकरको आवाज ठूलो हुन्छ र जति जति दाहिने पट्डि हुन्छ उति कै हिसाबले दाहिने पट्टिको स्पिकरको आवाज ठुलो हुनेछ  (प्रयोग कर्ताले स्टेरियो अथवा हेडफोन प्रयोग गरेको खण्डमा!)

##### चहकले श्रव्य विन्दुहरूको आयतनलाई नियन्त्रण गर्छ {#toc114}

यदि 'श्रव्य विन्दुहरूको आयतन सुलसुलेको हिँडाइमा भर पर्छ' भन्ने विकल्पमा टिक लगाइयो भने, यसको मतलब श्रव्य विन्दुहरूको आयतन सुलसुलेको मुनि चम्किएको पर्दाको अवस्था सित सम्बन्धी हुन्छ ।
यो विकल्पलाई टिक नलगाइएको अनुकूलतामा निर्धारित गरिएको छ ।

#### समीक्षा कर्सरको अनुकूलता {#toc115}

प्राथमिकता मेनु भित्र समीक्षा कर्सरको अनुकूलता रहेको छ ।
यो पातोमा निम्न विकल्पहरू विद्यमान छन्:

<!-- KC:setting -->

##### प्रणाली केन्द्रीयता पछ्याउ {#toc116}

कुञ्जी: नेत्रवाणी+7

योग्य बनाएको खण्डमा, वर्तमान प्रणाली केन्द्रीयता हेरफेर हुँदा पनि समीक्षा कर्सर सधैँ उही वस्तुमा नै रहने छ ।

<!-- KC:setting -->

##### प्रणाली Caret लाई पछ्याउ {#toc117}

कुञ्जी: नेत्रवाणी+6

योग्य बनाएको खण्डमा, समीक्षा कर्सर प्रत्येक पटकको हिँडाइमा प्रणाली caret मा स्वतः जाने छ ।

##### सुलसुलेलाई पछ्याउ {#toc118}

योग्य बनाएको खण्डमा, समीक्षा कर्सरले सुलसुलेको हिँडाइलाई पछ्याउने छ ।

##### साधारण समीक्षा मुद्रा {#toc119}

योग्य बनाएको खण्डमा, नेत्रवाणीले वस्तुको तह बद्धता जसले उपभोक्ताले विचरण गर्न अनिच्छा गरेको वस्तु जस्तै अदृश्य वस्तु र रूपरेखा वस्तुहरू छान्ने छ

#### वस्तु प्रस्तुतीकरणको अनुकूलता (नेत्रवाणी+control+o) {#toc120}

प्राथमिकता मेनु भित्र वस्तु प्रस्तुतीकरण राखिएको छ ।
यो पातोमा निम्न विकल्पहरू विद्यमान छन्:

##### औजार चिनारी बताउ {#toc121}

एउटा चिनो बाकस जसलाई टिक लगायो भने नेत्रवाणीलाई औजार चिनारी देखा पर्नका साथ बताउन लगाउने छ ।
जब तपाइले सुलसुलेको चुच्चो सन्झ्यालहरू र नियन्त्रकहरूमा पुर्याउनु हुन्छ अथवा कहिले कहीँ यीनैहरूमा तपाइ केन्द्रीयता लैजानु हुन्छ, एउटा सानो सन्देश (अर्थात् औजार चिनारी देखा पर्छ ।

##### सहयोग चिनारी बताउ {#toc122}

एउटा चिनो बाकस जसलाई टिक लगायो भने नेत्रवाणीलाई सहयोग चिनारी सन्देश देखा पर्नका साथ बताउन लगाउने छ ।
सहयोग चिनारी औजार चिनारी जस्तै हो, तर सामान्यतया ठूलो आकारमा हुन्छन् र प्रणालीमा घटेका घटनाहरू जस्तै प्रणाली सञ्जालबाट अलग भएको, अथवा तपाइलाई सन्झ्यालको सुरक्षा बारे सतर्कता गराएको जस्तो कार्य सित आबद्ध हुन्छन् ।

##### वस्तुको द्रुत कुञ्जी बताउ {#toc123}

यदि यो चिनो बाकसलाई टिक लगाइयो भने, नेत्रवाणीले कुनै वस्तु वा नियन्त्रक बताउनु पर्दा यसको द्रुतमार्ग कुञ्जी समावेश गर्छ ।
उदाहरणका लागि, कुनै मेनु पट्टीमा रहेको फाइल मेनुको द्रुतमार्ग alt+f हुन सक्छ ।

##### वस्तुको अवस्थाको जानकारी देउ {#toc124}

यो विकल्पले तपाइलाई केन्द्रीयता बदलेर वा वस्तु विचरण गरेर चयन गरिएको वस्तुको जानकारी दिँदा वस्तुको स्थान (जस्तै ४ मद्ये १)जान्न चाहनु हुन्छ या हुन्न भनि रोज्ने मौका प्रदान गर्छ ।

##### वस्तुको अवस्थाको जानकारी नभए अनुमान लगाउ {#toc125}

यदि वस्तुको स्थानको जानकारी बताउने विकल्प रोजिएको छ भने, यो विकल्पले नेत्रवाणीलाई यदि कुनै निर्दिष्ट नियन्त्रकमा स्थानको जानकारी उपलब्ध छैन भने पनि अनुमान लगाउन अनुमति प्रदान गर्छ ।

यो विकल्प रोजियो भने, नेत्रवाणीले धेरै नियन्त्रकहरू जस्तै मेनुहरू र औजार पट्टीहरूको स्थानको जानकारी दिनेछ, यद्यपि यी जानकारीहरू केही हदसम्म ट्याक्कै नमिल्न सक्छन् ।

##### वस्तुको विवरण बताउ {#toc126}

वस्तु सँगै यसको विवरण बताउन पर्दैन भने यो चिनो बाकसलाई टिक नलगाउनू होस् ।

<!-- KC:setting -->

##### प्रगति पट्टी प्रतिफल {#toc127}

कुञ्जी : नेत्रवाणी+u

यो विकल्पले नेत्रवाणीले तपाइलाई प्रगति पट्टीको अद्यावधिक जानकारी दिने तरिका नियन्त्रण गर्छ ।

यसमा निम्न विकल्पहरू छन्:

* नबताउ: प्रगति पट्टीमा आएको परिवर्तनलाई बताइँदैन ।
* बताउ: यस विकल्पले नेत्रवाणीलाई प्रगति पट्टिमा आएको परिवर्तनलाई प्रतिशतमा बताउन लगाउने छ ।
* टीँ टीँ गर: यो विकल्पले नेत्रवाणीलाई प्रगति पट्टीमा परिवर्तन हुन साथ टीँ टीँ आवाज दिन लगाउने छ । जति जति चर्को आवाजले आउँछ, त्यति नै प्रगति पुरा हुन लागेको भनेर बुझ्नु पर्ने छ ।
* टीँ गर्दै बताउ: यो विकल्पले नेत्रवाणीलाई प्रगति पट्टीमा परिवर्तन हुन साथ टीँ गर्दै आङ कडा बताउन लगाउने छ ।

##### पृष्ठभूमिको प्रगति बताउ {#toc128}

यो विकल्पमा टिक लगाइयो भने, नेत्रवाणीलाई प्रगति पट्टी अग्रभूमिमा नभए पनि प्रगतिको जानकारी दिन लगाउने छ । ,
यदि प्रगति पट्टी भएको सन्झ्याललाई सुक्ष्मीकृथ गरियो वा यसबाट अन्त गइयो भने, नेत्रवाणीले यसलाई पछ्याउने छ । नेत्रवाणीले यसलाई पछ्याए पनि तपाइलाई अरू काम गर्न स्वीकृति हुनेछ ।

<!-- KC:setting -->

##### गति सिल सामाग्रीको परिवर्तन बताउ {#toc129}

कुञ्जी: नेत्रवाणी+5

कुनै निश्चित वस्तुका नयाँ सामाग्रीहरू जस्तै गफगाफ कार्यक्रमका किनारा र इतिहास नियन्त्रकहरूको घोषणा साटो फेरो गर्ने छ ।

#### मिलावट लगानी अनुकूलता {#toc130}

The Input Composition Settings dialog can be found under the Preferences menu.
This dialog allows you to control how NVDA reports the input of Asian characters, such as with IME or Text Service input methods.
Note that due to the fact that input methods vary greatly by available features and by how they convey information, it will most likely be necessary to configure these options differently for each input method to get the most efficient typing experience.

##### उपलब्ध सबै उम्मेदवारहरूको बारेमा स्वतः बताउ {#toc131}

This option, which is on by default, allows you to choose whether or not all visible candidates should be reported automatically when a candidate list appears or its page is changed.
Having this option on for pictographic input methods such as chinese New ChangJie or Boshiami is useful, as you can automatically hear all symbols and their numbers and you can choose one right away.
However, for phonetic input methods such as chinese New Phonetic, it may be more useful to turn this option off, as all the symbols will sound the same and you will have to use the arrow keys to navigate the list items individually to gain more information from the character descriptions for each candidate.

##### चय नीत उम्मेदवार बताउ {#toc132}

This option, which is on by default, allows you to choose whether NVDA should announce the selected candidate when a candidate list appears or when the selection is changed.
For input methods where the selection can be changed with the arrow keys (such as Chinese New Phonetic) this is necessary, but for some input methods it may be more efficient typing with this option turned off.
Note that even with this option off, the review cursor will still be placed on the selected candidate allowing you to use object navigation / review to manually read this or other candidates.

##### उम्मेदवारको घोषणा गर्दा सधैँ छोटो वर्ण र विवरण समावेश गर {#toc133}

This option, which is on by default, allows you to choose whether or not NVDA should provide a short description for each character in a candidate, either when its selected or when its automatically read when the candidate list appears.
Note that for locales such as Chinese, the announcement of extra character descriptions for the selected candidate is not affected by this option.
यो विकल्प कोरियाली र जापानी लगानी तरिकामा उपयोगी हुन सक्छ ।

##### पढिरहेको पदावलीमा आएको परिवर्तन बताउ {#toc134}

Some input methods such as Chinese New Phonetic and New ChangJie have a reading string (sometimes known as a precomposition string).
You can choose whether or not NVDA should announce new characters being typed into this reading string with this option.
यो विकल्प पढ्ने अवस्थामा निर्धारित गरिएको छ ।
Note some older input methods such as Chinese ChangJie may not use the reading string to hold precomposition characters, but instead use the composition string directly. Please see the next option for configuring reporting of the composition string.

##### बनावट पदावलीको परिवर्तन बताउ {#toc135}

After reading or precomposition data has been combined into a valid pictographic symbol, most input methods place this symbol into a composition string for temporary storage along with other combined symbols before they are finally inserted into the document.
This option allows you to choose whether or not NVDA should report new symbols as they appear in the composition string.
यो विकल्प जानकारि दिने अवस्थामा निर्धारित गरिएको छ ।

#### उघारने मुद्राको अनुकूलता (नेत्रवाणी+control+b) {#toc136}

उघारने मुद्रा अनुकूलताको पातो प्राथमिकता मेनु भित्र उघारने मुद्रा नामबाट राखिएको छ ।

उक्त पातोमा निम्न विकल्पहरू छन्:

##### एक पङ्तिमा अधिकतम वर्णहरूको सङ्ख्या {#toc137}

यो भूमि विकल्पले उघारने मुद्रामा अधिकतम (वर्णहरूको सङ्ख्या) उल्लेख गर्ने अवसर प्रदान गर्ने छ ।

##### प्रति पृष्ठ अधिकतम पङ्ति {#toc138}

उघारने मुद्रामा हुँदा यो भूमिले माथिल्लो पृष्ठ वा तल्लो पृष्ठमा जाँदा कति वटा पङ्ति देखाउने भनि तय गर्ने छ ।

<!-- KC:setting -->

##### पर्दाको रूपरेखाको प्रयोग गर {#toc139}

कुञ्जी: नेत्रवाणी+v

यो विकल्पले तपाइलाई उघारने मुद्राका सामाग्रीहरू जस्तै लिङ्कहरू र अरू भूमिहरूलाई उनीहरूकै पङ्तिमा अथवा यीनैहरू आँखाले देख्दा जहाँ छन् त्यही रहने सुचीको रूपमा राख्ने कि नराख्ने भनि यकिन गर्ने अनुमति प्रदान गर्ने छ । यदि यो विकल्पलाई योग्य बनाइयो भने चीजहरू देखिएकै रूपमा रहने छन्, तर यसलाई अयोग्य बनाइयो भने भूमिलाई उनीहरूकै पङ्ति अनुसार राखिनेछ ।

##### सुरु हुन साथ सबै पृष्ठ खुरुखुरु बताउ {#toc140}

यो चिनो बाकसले कुनै पृष्ठलाई उघारने मुद्रामा बहन गरे पछिको स्वचालित पठनलाई उल्टाइ दिन्छ ।
यो विकल्पलाई योग्य अवस्थामा निर्धारित गरिएको छ ।

==== रेखाङ्कन तालिका समावेस गर
यो विकल्पले शुद्ध रुपमा रुपरेखा उद्देश्यका लागि नेत्रवाणीले कसरी तालिकालाई सञ्चालन गर्छ भन्ने कुराको निर्धारण गर्दछ ।
हुन्छ भन्ने विकल्प रोजियो भने, नेत्रवाणीले यसलाई साधारण तालिकाको रूपमा लिई [कागजातको ढाँचा अनुकूलता](#DocumentFormattingSettings) का आधारमा प्रस्तुत गर्छ र छरितो आदेस अनुरु स्थान तय गर्छ ।
बन्द गरिएको अवस्थामा जानकारी दिईने वाछिटो विचरण पाइने छैन ।
जे भए पनि तालिकाका सामाग्रीहरूलाई सामान्य पाठको रुपमा भने समावेस गरिन्छ ।
यो विकल्पलाई बन्दको अवस्थामा निर्धारित गरिएको छ ।

##### भूमि जानकारी जस्तै लिङ्क वा शीर्षकको अभियोजन {#toc141}

कृपया विचरण गर्दा घोषणा गरिने भूमिहरू जस्तै लिङ्कहरू, शीर्षकहरू र तालिकाहरूलाई अभियोजन गर्न तरिका [कागजातहरूको स्वरूप अनुकूलता पातो](#DocumentFormattingSettings)मा हेर्नु होला ।

##### केन्द्रीयता फेर बदल अनुसार स्वचालित केन्द्रित मुद्रा {#toc142}

यो विकल्पले केन्द्रीयता बदलिँदा केन्द्रीयता मुद्रालाई फेर्न अनुमति प्रदान गर्ने छ ।
उदाहरणका लागि, वेभ पृष्ठमा हुँदा, यदि तपाइले tab दबाएर कुनै फाराममा पस्नु भयो भने, र यदि यो विकल्पमा टिक छ भने, केन्द्रीयता मुद्रा स्वतः फेरिने छ ।

##### caret को गति अनुसार स्वचालित केन्द्रीयता मुद्रा {#toc143}

यो विकल्प टिक लगाएको खण्डमा, नेत्रवाणीले उघारने मुद्रामा पनि वाण कुञ्जीहरूको प्रयोग गरी प्रवेश र बहिर्गमन गर्ने अनुमति प्रदान गर्छ
उदाहरणका लागि, कुनै वेभ पृष्ठमा तल वाण दबाएर तपाइ कुनै सम्पादन भूमि प्रवेश गर्नु भयो भने,नेत्रवाणी स्वतः केन्द्रीयता मुद्रामा जानेछ । यदि तपाइ उक्त सम्पादन बाकसबाट बाहिरिनु भयो भने, नेत्रवाणीले तपाइलाई स्वतः उघारने मुद्रामा लग्ने छ ।

##### केन्द्रीयता र उघारने मुद्रा अनुसारको श्रव्य सङ्केत {#toc144}

यदि यो विकल्पलाई योग्य बनाइयो भने, नेत्रवाणीले उघारने मुद्रा र केन्द्रीयता मुद्रामा बसाइ सर्दा परिवर्तनलाई बताउनू को सट्टा विशेष धुन बजाउने छ ।

##### गैह्र आदेश सङ्केतलाई  कागजातमा पुग्नबाट रोक {#toc145}

पूर्व निर्धारण गरिए अनुसार, यो विकल्पले तपाइलाई कुञ्जि दबाब जस्ता सङ्केतहरू जसले नेत्रवाणी आदेश एवम् सामान्यतया आदेश न मानिने सङ्केतहरूलाई तपाइ केन्द्रित् भएको कागजातमा जानबाट रोक्ने वा न रोक्ने भनेर छनोट गर्ने अवस्था दिनेछ ।
उदाहरणका लागि, योग्य भएको खण्डमा, यदि j अक्षर दबाइयो भने, यसलाइ कागजातमा जानबाट रोकिनेछ  भलै यो छोटो मार्ग आदेश होस् वा सक्रिय अनुप्रयोगमा कुनै आदेस नै होस् ।

#### कागजात स्वरूपको अनुकूलता (नेत्रवाणी+control+d) {#DocumentFormattingSettings}

यो पातो प्राथमिकता मेनु भित्र कागजातको स्वरूपको नामबाट राखिएको छ ।”.

यस पातोका अधिकांश चिनो बाकसहरू तपाइ कागजातमा घुमफिर गर्दा कुन किसिमको स्वरूपमा घोषणा गरियोस् भनेर चाहनु हुन्छ सोही अनुरूपको अभियोजन गर्न प्रयोग गरिन्छ ।
उदाहरणका लागि, यदि तपाइले वर्णाकृति बताउ विकल्पलाई टिक लगाउनु भयो भने; सक्रिय कागजातमा चालू कर्सरले फरक वर्णाकृति भेट्टाउनका साथ उक्त नयाँ वर्णाकृतिको नाम बताउने छ ।

तपाइले निम्न विषयमा अभियोजन गर्न सक्नु हुन्छ ।

* वर्णाकृतिको नाम
* वर्णाकृतिको आकार
* वर्णाकृतिका गुणहरू
* पाठको पङ्तिवद्धता
* रङ्गहरू
सम्पादकको पुनरावलोकन
* पाठ शैली
* हिज्जे त्रुटि
* पृष्ठ सङ्ख्या
* पङ्ति सङ्ख्या
* पङ्ति indentation
* अनुच्छेदको फड्को (जस्तै झुण्डिएको फड्को प्रथम फढ्को)
* तालिकाहरू
* तालिका हरफ/महल शीर्षक
* तालिका कोशीका स्थान
* लिङ्कहरू
* शीर्षकहरू
* सुचीहरू
* उद्धृत हिस्सा
* कित्ताहरू
* फ्रेमहरू
* यदि किटिक्क गर्न मिल्छ भने

यो अनुकूलतालाई जहाँबाट पनि उल्टाउन, [लगानी सङ्केत पातो](#InputGestures)को प्रयोग गरी आफ्नो सङ्केत कायम गर्नु होस् ।

##### कर्सर पछिका कागजातका स्वरूपमा आएको परिवर्तन बताउ {#toc147}

योग्य बनाइयो भने, यो अनुकूलताले नेत्रवाणीले सबै पङ्ति बताउँदा तिनिहरूको स्वरूपमा आएको परिवर्तनलाई पता लगाउन कोसिस गर्ने छ, यसो गर्दा नेत्रवाणीको कार्यदक्षतामा ढिलाई हुने छ ।

निर्धारित गरिए अनुसार, नेत्रवाणीले प्रणाली caret / समीक्षा कर्सरको स्थानको स्वरूप पता लगाउने छ , र कुनै अवस्थामा बाकी पङ्तिका स्वरूप पनि पता लगाउने छ, यदि यसको कार्यकुशलतामा ढिलाई भएन भने ।

शुद्धाशुद्धि जाँच गरिने कागजातहरू जस्तै माइक्रोसफ्ट वर्ड जसमा स्वरूपको खास महत्त्व हुन्छ मा यो विकल्पलाई योग्य बनाउनु होला,

#### वाचनको ढुकुटी {#toc148}

प्राथमिकता पातोमा रहेको वाचनको ढुकुटी मेनु पातोले नेत्रवाणीले खास शब्द वा वाक्यांशलाई कसरी वाचन गर्ने भनि नियन्त्रण गर्छ ।
हाल तिन किसिमका वाचनका ढुकुटीहरू छन् ।
तिनीहरू हुन्:

* पूर्व निर्धारित: यस ढुकुटीमा उल्लिखित नियमले नेत्रवाणीको सबै वाचनमा प्रभाव पार्छ
* आवाज: यो ढुकुटीका नियमहरूले हाल प्रयोगमा आएको संश्लेषकका आवाजलाई प्रभावित गर्छ ।
* अस्थाई: यो ढुकुटीका नियमहरूले नेत्रवाणीका सबै वाचनलाई प्रभावित गर्छ, तर केवल चालू सत्रमा मात्रै । यी नियमहरू अस्थाई हुन् र नेत्रवाणीलाई पुनराम्भ गर्न साथ मेटिने छन् ।

यदि तपाइ यी ढिकुटि पातोहरुलाई जहाँबाट पनि हेर्न चाहनु हुन्छ भने तपाइले [लगानी सङ्केत पातो](#InputGestures) को प्रयोग गरि आफ्नै द्रुत कुञ्जी तोक्न सक्नु हुन्छ । 

सबै वाचन ढुकुटीहरूका पातोमा नियमहरू लेखिएका हुन्छन् जसलाई वाचनको प्रशोधन गर्दा प्रयोग गरिन्छ ।
यो पातोमा थप, सम्पादन र हटाउ भन्ने टाँकहरू पनि रहने छन् ।

ढुकुटीमा नयाँ नियमहरू थप्नका लागि, थप भन्ने टाँकलाई दबाउनु होस्, देखा पर्न आएको पातोमा नियममा लेखि ठीक भन्ने टाँकलाई दबाउनु होला ।
यस पछि तपाइले यो नयाँ नियमलाई नियमको सुचीमा देख्नु हुनेछ ।
जे भए पनि तपाइले प्रविष्टि गर्नु भएको नियम बचत भएको पक्का पक्की गर्न , ढुकुटीमा थप/सम्पादन गर्ने कार्य सकिए पछि यस पातोलाई बन्द गर्न ठीक टाँकलाई दबाउनु होस् ।

नेत्रवाणी वाचन ढुकुटीका नियमहरूले एउटा पदावलीका वर्णहरूलाई अर्कोमा बदल्ने छन् ।
एउटा सामान्य उदाहरण, मानो कि तपाइ नेत्रवाणीले 'चरो' भन्नु पर्ने शब्दलाई 'भ्यागुतो' भनेर हरेक पटक पढोस् भन्ने चाहनु हुन्छ ।
यसका लागि सबै भन्दा सजिलो तरिका भनेको, नियमहरू थपि देउ भन्ने पातोको ढाँचा भूमिमा 'चरो' शब्द र प्रतिस्थापन भूमिमा भ्यागुतो शब्द टङ्कण गर्नु हो ।
तपाइले नियमको विवरण टिप्पणी भूमिमा लेख्न पनि सक्नु हुन्छ (: जस्तै: चरोलाई भ्यागुतो भनिने छ ) ।

नेत्रवाणीका वाचन ढुकुटीहरू सामान्य शब्द प्रतिस्थापन भन्दा धेरै शक्तिशाली छन् ।
थपि देउ भन्ने पातोमा एउटा चिनो बाकस पनि छ जसले वर्ण रूप संवेदनशील हो बा होइन भनि जनाउने छ (मतलब नेत्रवाणीले बोल्नु अघि वर्णहरू माथिल्लो वा तल्लो रूपका भनि खुट्याउनु पर्ने हुन्छ) ।
नेत्रवाणीमा यो वर्ण संवेदनशीलता निर्धारित गरिएको छैन ।

अन्तमा, उपलब्ध रेडियो टाँकहरू मध्ये केही लाइ रोजेर तपाइले नेत्रवाणीलाई आफ्नो इच्छा अनुसारको ढर्रा रोज्न सक्नु हुन्छ, यसले केवल पूरै शब्द भए मात्र जोडा मिलाउने वा नियमित रूपको जोडा मिलाउने भनेर रोज्ने अनुमति दिनेछ ।
पुरै सब्दको जोडा मिलाउ भनेर चयन गर्नु भनेको विस्थापनको कार्य त्यस अवस्ताम मात्र गर्नु यदी त्यो शब्द कुनै लामो शब्दको हिस्सा नभएर आफैमा सिङ्गो शब्द हो भने मात्र भनिएको हो । जस्तै वर्णसङ्ख्यकीय बाहेकका अदो रेखाङ्कन, जस्ता वर्णहरू त्यो ढर्राको अगाडी वा पछाडिका वर्णहरूको रूपमा छैनन् भने मात्र गर्ने भनिएको हो ।
पहिलेको उदाहरणमा देखाए जसरी यदी चरो भन्ने सब्दलाई भ्यागुतोमा बदल्दा, यदि तपाइले पुरै शब्द भनेर चयन गर्नु भयो भने यसले "चराहरू' वा निलाचरो" जस्ता शब्दलाई विस्थापन गर्ने छैन ।

नियमित अभिव्यक्ति भनेको विशेष चिन्ह भएको ढाँचा हो जसले तपाइलाई एकै पटक एक भन्दा बढि वर्णहरूको तुलना गर्ने , अथवा केवल सङ्ख्या मात्रै तुलना गर्ने , अथवा अक्षरमात्रै तुलना गर्ने अनुमति पर्दा गर्छ । यी केही उदाहरणहरू हुन् ।
यो उपभोक्ता निर्देशिकामा नियमित अभिव्यक्ति बारे केही उल्लेख गरिएको छैन, तर तपाइलाई प्रशस्त जानकारी दिने थुप्रै सहयोगी लेखहरू वेभमा सजिलै पाइन्छन् ।

#### सङ्केत र चिन्हहरूको उच्चारण {#SymbolPronunciation}

यो पातोले तपाइलाई चिन्हहरू र अन्य सङ्केतहरूको उच्चारण गर्ने शैलीका साथै यीनैहरूको तह कायम वा परिवर्तन गर्ने अनुमति प्रदान गर्छ ।

चिन्हको उच्चारणको सम्पादन गरिदै गरेको भाषाको पातोलाई शिर्षकमा देखाइने छ ।
स्मरणीय छ कि यो पातोले [आवाजको अनुकूलता पातो](#VoiceSettings) को विकल्पमा गएर विश्वासिलो आवाज भाषा सङ्केत र वर्नहरूको प्रसोधन गर्ने विकल्प रोज्दा आदर गर्छ । अर्थात् यदि योग्य बनाइएको खण्डमा यसले नेत्रवाणीको सर्वव्यापी भाषाको सट्टा आवाजको भाषाको अनुकूलतालाई चयन गर्छ ।

चिन्ह फेर्नका लागि, सबै भन्दा पहिले चिन्हहरूको सुचीबाट यसलाई चयन गर्नु होस् ।
प्रतिस्थापन भूमिले यो चिन्हको स्थानमा बोल्नु पर्ने पाठ लेख्ने भुमि प्रदान गर्छ ।
तह भूमिको प्रयोग गरी , तपाइले निम्न तहका चिन्हहरूलाई कायम गर्न सक्नु हुन्छ जसमा यो चिन्ह बोल्नु पर्ने छ ।

तपाइले थप भन्ने टाँकलाई दबाएर नयाँ चिन्ह थप्न सक्नु हुन्छ ।
देखा परेको पातोमा चिन्हलाइ लेखेर ठिक भन्ने टाँकलाई दबाउनु होला ।
त्यस पछि, अरू नयाँ चिन्हहरूको प्रतिस्थापन र सङ्केतलाई लेख्नु होला ।

तपाइले पहिले आफूले थप गरेको चिन्हलाई हटाउ भन्ने टाँक दबाएर हटाउन पनि सक्नु हुन्छ ।

कार्य सकिनासाथ, आफूले गरेको परिवर्तनलाई बचत गर्न ठीक अथवा बहिष्कार गर्न रद्द भन्ने टाँकलाई दबाउनु होस् ।

#### लगानी सङ्केत {#InputGestures}

यो पातोमा तपाइले नेत्रवाणी आदेसहरूका लागि कुञ्जीपाटीमा कुञ्जीहरू र ब्रेल पटलमा टाँकहरूलाई लगानी सङ्केतको रूपमा अभियोजन गर्न सक्नु हुन्छ ।

पातो पल्टाउनु अघि लागू हुने आदेसहरू मात्रै देखा पर्ने छन् ।
उदाहरणका लागि, तपाइ उघार्ने मुद्राका आदेसहरूलाई अभियोजन गर्न चाहनु हुन्छ भने, तपाइले उघार्ने मुद्रामा रही लगानी सङ्केत पातोलाइ पल्टाउनु पर्ने हुन्छ ।

यो पातोको बृक्षले यसमा लागू हुन सक्ने सबै नेत्रवाणी समूहिकृत आदेसहरू को सूची देखाउने छ ।
तपाइले आदेसको नामबाट जुन सुकै क्रममा पनि सम्पादन कोठामा  एउटा अथवा धेरै शब्द थप गरेर यिनिहरुलाइ छान्न पनि सक्नु हुन्छ । 
कुनै आदेससित सम्बद्ध सङ्केत सोही आदेसको तल सूचीकृत गरिएको हुन्छ ।

कुनै आदेसको लगानी सङ्केत थप्नका लागि उक्त आदेसलाइ चयन गरी थप भनेनेटाँकलाई दबाउनु होला ।
यस पछि तपाइले सम्वद्ध गर्न चाहेको कार्य गर्नु होला जस्तै कुञ्जीपाटिको कुञ्जी वा ब्रेल पटलको टाँकलाई दबाउने जस्ता कार्य गर्नु होला ।
साधारणतयाः सङ्केतलाई बहु प्रयोजनका रुपमा पनि चित्रण गरिन्छ ।
उदाहरणका लागी, यदी तपाइले कुञ्जीपाटीको कुनै कुञ्जीलाई चयन गर्नु भयो भने, तपाइले चालू कुञ्जीपाटीको रुपरेखा जस्तै डेस्कटप वा ल्यापटप वा सबै रुपरेखाहरूमा यसलाइ लागु गराउन सक्नु हुन्छ ।
यो अवस्थामा चाहेको विकल्प तय गर्न एउटा मेनु देखा पर्ने छ ।

कुनै आदेसको सङ्केतलाई हटाउनका लागीउक्त सङ्केत चयन गरी हटाउ भन्नेटाँकलाई दबाउनु होला ।

परिवर्तन गरी सके पछि बचत गर्ने भए ठीक र नगर्ने भए रद्द भन्ने टाँकलाई दबाउनु होला ।

### अभियोजनको बचत र पुनः बहन {#toc151}

बहिर्गमन हुँदा नेत्रवाणीले सबै परिवर्तनहरूलाई स्वतः बचत गर्ने गरी निर्धारण गरिएको छ ।
टिप्पणी, यद्यपि, यो विकल्पलाई प्राथमिकता भित्रको सामान्य अनुकूलतामा गएर परिवर्तन गर्न सकिन्छ ।
जुनसुकै समयमा आफूले गरेको परिवर्तनलाई बचत गर्न, नेत्रवाणीको 'अभियोजनलाई बचत गर' भन्ने मेनुको प्रयोग गर्नु होस् ।

यदि तपाइले परिवर्तन गरेको अभियोजन अनुकूलता त्रुटि पूर्ण हुन गई बचत गरिएकै लाई कायम राख्नु पर्ने भयो भने,, नेत्रवाणी मेनुको ' अभियोजन बचत रूपमै फर्काउ' विकल्प रोज्नु होला ।
तपाइले सबै अभियोजनहरूलाई सुरुको कारखाना निर्धारित अवस्थामा फर्काउन, नेत्रवाणी मेनु भित्र रहेको 'अभियोजन कारखाना निर्धारण अवस्थामा नै रहोस्' भन्ने विकल्पलाई रोज्नु होला ।

यी निम्न नेत्रवाणी कुञ्जी आदेशहरू पनि उपयोगी रहने छन् ।:
<!-- KC:beginInclude -->

| नाम |डेस्कटप कुञ्जी |ल्यापटप कुञ्जी |विवरण|
|---|---|---|---|
|अभियोजनको बचत |नेत्रवाणी+control+c |नेत्रवाणी+control+c |सक्रिय नेत्रवाणी बन्द हुँदा तपाइको चालू अभियोजन कायमै राख्नका लागि बचत गर्नेछ ।|
|अभियोजनलाई उल्टाउ |नेत्रवाणी+control+r |नेत्रवाणी+control+r |एक पटक दबाउँदा अन्तिम पटक बचत गरेको अभियोजनमा लेजान्छ । तिन पटक दबाउँदा कारखाना निर्धारित अभियोजन कायम गर्ने छ ।|

<!-- KC:endInclude -->

### अभियोजन पार्श्वचित्र {#toc152}

कहिले कहि तपाइ फरक स्थितिका लागी फरक अनुकूलन गर्न चाहनु हुन्छ ।
उदाहरणका लागि, तपाइ वर्णाकृति गुणहरू सक्रियता भएको अवस्थामा यदी प्रुफ रिडिङ् गर्दै हुनु हुन्छ भने सम्पादनको वा प्रतिवेदनको क्रममा indentation को अवस्था जानकारी हुने अभियोजन गर्न सक्नु हुन्छ ।
नेत्रवाणीमा तपाइलाई अभियोजन पार्श्वचित्र प्रयोग गरेर यसो गर्ने सुविधा हुनेछ ।

अभियोजन पार्श्वचित्रमा सम्पादीत हुँदा परिवर्तित हुने पार्श्वचित्र अनुकूलन मात्रै समावेस हुन्छ ।
अभियोजन पार्श्वचित्रमा सम्पूर्ण नेत्रवाणीमा लागू हुने सामान्य अनुकूलता पातोमा उल्लिखित बाहेक प्राय सबै अनुकूलन परिवर्तन गर्न सकिन्छ ।

अभियोजन पार्श्वचित्रलाई मानविय रुपले सक्रिय गर्न सकिन्छ ।
कुनै निश्चीत अनुप्रयोगमा गमन जस्ता उतेजकको प्रयोग गरी यीनिहरूलाई स्वचालित रूपमा सक्रिय गर्न सकिन्छ ।

#### आधारभूत व्यबस्थापन {#toc153}

तपाइले  नेत्रवाणी मेनुमा रहेको " पार्श्वचित्रको अभियोजन " लाई चयन गरी पार्श्वचित्र अभियोजनको व्यबस्थापन गर्न सक्नु हुन्छ ।
तपाइले यो कार्य कुञ्जी आदेसको पर्योग गरेर पनि गर्न सक्नु हुन्छ ।
<!-- KC:beginInclude -->

* नेत्रवाणी + control+p: पार्श्वचित्र अभियोजन पातोलाई देखाउने छ ।

<!-- KC:endInclude -->

यो पातोको पहिलो नियन्त्रक भनेको पार्श्वचित्र सूची हो जहाँ बाट तपाइले  उपलब्ध कुनै पनि पार्श्वचित्रलाई चयन गर्न सक्नु हुन्छ ।
तपाइले पातो पल्टाउनु भयो भने वर्तमान सम्पादीत पार्श्वचित्र चयनित हुन्छ ।
वर्तमान पार्स्वचित्र मानविय रूपले अथवा उतेजक द्वारा सक्रिय बनाइएका हुन् वा सम्पादित हुदै छन् भन्ने जस्ता सक्रिय पार्श्वचित्र सम्बन्धी अतिरिक्त सुचनालाई पनि देखाइने छ।

नाम बदल्न वा हटाउनका लागि, नामाकरण वा हटाउ भन्नेटाँकलाई क्रमशः दबाउनु होला ।

पातोलाई बन्द गर्न 'बन्द' भन्ने टाँकलाई दबाउनु होस् ।

#### पार्श्वचित्रको सिर्जना {#toc154}

पार्श्वचित्रको सिर्जना गर्न नयाँ टाँकलाई दबाउनु होस् ।

नयाँ पार्श्वचित्र पातोमा तपाई नयाँ पार्श्वचित्रको नाम लेख्न सक्नु हुन्छ ।
यो पार्श्वचित्रलाई कसरी प्रयोग गर्ने भनेर तपाइले चयन गर्न सक्नु हुन्छ ।
यदि तपाइ यो पार्श्वचित्रलाई मानविय रूपमा मात्र चलाउन चाहनु हुन्छ भने, मानविय सक्रियतालाई चयनगर्नु होला, जो पुर्व निर्धारित गरिएको छ ।
अन्यथा, उतेजकलाई चयन गर्नु होस्, जसले यो पार्स्वचित्रलाई स्वचालित रुपमा सक्रिय गरोस् ।
सजिलै बुझ्नका लागि, यदि तपाइले यो पार्श्वचित्रको नाम प्रविष्टि गर्नु भएको छैन भने, उतेजकलाई चयन गर्दा उक्त नामलाई चढाउँने छ ।
उतेजक सम्बन्धी थप जानकारीका लागि [तलको](#ConfigProfileTriggers) हेर्नु होला ।

ठीक' टाँकलाई दबाउँदा पार्श्वचित्रको सिर्जना गर्ने छ र यसलाई सम्पादन गर्न सकियोस् भनेर उक्त पार्श्वचित्रको अभियोजन पातोलाई बन्द गर्ने छ ।

#### मानवीय सक्रियता {#ConfigProfileManual}

तपाइले पार्श्वचित्रलाई चयन गरी मानवीय सक्रियता भन्ने  टाँकलाई दबाएर मानवीय रूपले कुनै पार्श्वचित्रलाई सक्रिय बनाउन सक्नु हुन्छ ।
यदी सक्रिय बनाइयो भने, अरू पार्श्वचित्र उतेजनाको कारणले सक्रिय बनाउन सकिन्छ, तर कुनै मानवीय सक्रियताको अनुकूलता भने स्वत हट्न जानेछ ।
उदाहरणका लागि, कुनै अनुप्रयोगमा यदि कुनै पार्श्वचित्र लाई लिङ्क बताउने गरी उतेजक द्वारा सक्रिय गरियो तर मानवीय सक्रियतामा अयोग्य बनाइयो भने, लिङ्कलाई बताइने छैन ।
यद्यपि, यदि तपाइले उतेजक पार्श्वचित्रमा आवाजलाई परिवर्तन गर्नु भयो तर यसलाई कहिल्यै पनि मानवीय सक्रियता पार्श्वचित्रमा गर्नु भएन भने, उतेजक पार्श्वचित्रको आवाजको प्रयोग हुनेछ ।
कुनै पनि अनुकूलताको परिवर्तन मानवीय सक्रियता पार्श्वचित्रमा बचत हुनेछ ।
मानवीय रुपले सक्रिय बनाइएको पार्श्वचित्रलाई निश्क्रिय पार्न, यसलाई अभियोजन पार्श्वचित्र पातोलाइ चयन गरी मानवीय निस्क्रियता टाँकलाई दबाउनु होला ।

#### उतेजकहरू {#ConfigProfileTriggers}

अभियोजन पार्श्वचित्र पातोमा रहेको उतेजक टाँकलाई दबाउँदा पार्श्वचित्र लाई परिवर्तन गरी विभिन्न उतेजक पार्श्वचित्रहरूलाई सक्रिय बनाउन सकिन्छ ।

उतेजक सूचीमा उपलब्ध उतेजकहरू निम्न अनुसार छन्:

* चालू अनुप्रयोग: चालू अनुप्रयोगमा विचरण हुन साथ स्वतः सक्रिय हुनेछ ।
* सम्पूर्ण वाचन: सम्पूर्ण वाचन आदेश सक्रिय हुना साथ उतेजित हुनेछ ।

स्वचालित सक्रिय हुने पार्श्वचित्र उतेजित गर्न, सम्बन्धीत उतेजकलाई चयन गरी निर्दिष्ट सुचीबाट लक्षित पार्श्वचित्रलाई चयन गर्नु होस् ।
तपाइ  यदि कुनै पार्श्वचित्रलाई चाहनु हुन्न भने सामान्य अभियोजनको चयन गर्न सक्नु हुन्छ ।

अभियोजन पातोमा जानका लागि बन्द भन्ने टाँकलाई दबाउनु होला ।

#### पार्श्वचित्रको सम्पादन {#toc157}

यदि तपाइले मानवीय पार्श्वचित्रलाई सक्रिय बनाउनु भएको छ भने, अनुकूलनको परिवर्तनलाई उक्त पार्श्वचित्रमा बचत गरिने छ ।
अन्यथा, तपाइले परिवर्तन गरेको  अनुकूलन हालै सक्रिय बनाएको उतेजक पार्श्वचित्रमा बचत गरिने छ ।
उदाहरणका लागि, कुनै पार्श्वचित्रलाई पाठ सम्पादक अनुप्रयोग (Notepad) सित आबद्ध गरिएको अनुप्रयोग सक्रिय गर्नु भयो भने परिवर्तित अनुकूलनहरू उक्त पार्श्वचित्रमा बचत हुने छन् ।
अन्तमा, यदि मानविय रूपले वा उतेजक द्वारा सक्रिय गरिएको पार्श्वचित्र छैन भने यो सामान्य अभियोजनको रूपमा बचत हुनेछ ।

सबै पढ भन्ने पार्श्वचित्रको सम्पादन गर्न, तपाइले [मानविय रूपले सक्रिय गर](#ConfigProfileManual) भन्ने पार्श्वचित्रलाई सक्रिय गर्नु पर्छ ।

#### उतेजकहरूको अस्थाई निस्क्रियकरण {#toc158}

कहिले कहीं उतेजकहरूलाई अस्थाइ रुपमा निस्क्रिय गर्नु उपयोगी हुन्छ ।
उदाहरणका लागि,, तपाइले कुनै मानविय रूपले सक्रिय पार्स्वचित्रलाई अथवा तपाइको सामान्य अभियोजन लाइ उतेजक पार्श्वचित्रको हस्तक्षेप बिना नै सम्पादन गर्ने चाहना राख्नु हुन्छ ।
तपाइले सबै उतेजकहरुलाई निस्क्रिय गर भन्ने चिनो बाकसमा टिक लगाएर यो कार्य गर्न सक्नु हुन्छ । the Temporarily disable all triggers checkbox in the Configuration Profiles dialog.

### अभियोजन फाइलहरूको स्थान {#toc159}

नेत्रवाणीको बहनीय संस्करणले सबै चल्तीका appModules र चल्तीका चालकहरूका अनुकूलताहरूलाई नेत्रवाणीका लागि निर्धारित थैली NVDA भित्र रहेको userConfig नामको घर्रामा बचत गर्ने छ ।

नेत्रवाणीको स्थापित संस्करणमा भने, चल्तीका appModules र चल्तीका चालकहरूका सबै अनुकूलताहरू तपाइको सन्झ्यालको उपभोक्ता पार्श्वचित्रमा रहेको विशेष घर्रा NVDA मा बचत हुने छ ।
यसको मतलब प्रत्येक उपभोक्ताको आ-आफ्नै नेत्रवाणी अनुकूलताहरू हुनेछन् ।
स्थापित नेत्रवाणीमा तपाइले तय गर्नु भएको अनुकूलता जान्न, सुरुवात मेनु भित्र programs -> NVDA -> उपभोक्ताको अभियोजन घर्रामा हेर्नु होला ।

नेत्रवाणीको आरम्भ तहको अथवा UAC पर्दाको अभियोजन नेत्रवाणी प्रणाली स्थापित NVDA\systemConfig नामको घर्रामा रहेको हुन्छ ।
सामान्यतया यो अभियोजनलाई चलाउनु हुँदैन ।
नेत्रवाणीको आरम्भ तहमा/UAC पर्दामा गरिएको अनुकूलता बदल्नका लागि, सन्झ्याल आरम्भ हुँदा कसरी अनुकूलित गर्नु पर्ने हो सोही अनुरूप गरेर सामान्य अनुकूलता पातोमा रहेको 'सन्झ्याल आरम्भ पर्दामा नेत्रवाणीलाई सक्रिय बनाउ 'भन्ने टाँकलाई दबाउनु होला ।

## अतिरिक्त औजारहरू {#toc160}
### दृश्य लगत पुस्तिका {#toc161}

नेत्रवाणी मेनु भित्रको औजार मेनुमा रहेको दृश्य लगत पुस्तिकाले तपाइलाई पछिल्लो पटक नेत्रवाणी सुरु भए पछि हाल सम्मका सबै गतिविधिहरूको प्रतिफलहरूको लगत उपलब्ध गराउने छ ।

यसमा रहेका सामाग्रीहरूलाई पढ्न सकिने अवस्थाका अतिरिक्त , तपाइले यो लगतको प्रतिलाई बचत गर्न अथवा उक्त दृश्य लगत पुस्तिकालाई ताजा गरेर पुस्तिका पल्टाए पछिका नविन तम घटनाहरूलाई अभिलेखन पनि गर्न सक्नु हुन्छ ।
यी विकल्पहरू दृश्य लगत पुस्ताका मेनु भित्र रहेका छन् ।

### वाचन दृश्यक {#toc162}

देख्ने प्रयोजनको विकल्पको रूपमा नभई नेत्रवाणीको विकासमा आबद्ध देख्ने व्यक्तिहरू अथवा देख्ने व्यक्तिलाई नमुना प्रदर्शन गर्नका लागि , एउटा वाचन दृश्यक नामक तरल सन्झ्याल देखा पर्ने छ जसले तपाइलाई नेत्रवाणीले पडेको पाठहरू देखाइ दिनेछ ।

वाचन दृश्यलाई सक्रिय बनाउन, नेत्रवाणीको औजार मेनु भित्र रहेको चिनो बाकसमा टिक लगाउनु होस् ।
यसलाई निष्क्रिय बनाउन टिक नलगाउनू होला ।

यदि वाचन दृश्यक सक्रिय छ भने हालसाल पढेको पाटलाई अद्यावधिक गरी प्रस्तुत गर्ने छ ।
तर यदि तपाइले उक्त वाचन दृश्यक भित्र किटिक्क गर्नु भयो वा केन्द्रीयता लैजानु भयो भने, नेत्रवाणीले अस्थआई रूपमा पाठको अद्यावधिकको कार्य रोक्ने छ , ताकि तपाई प्रस्तुत पाठहरूलाई सम्पादन गर्न सक्नु होस् ।

जहाँबाट पनि वाचन दृश्यकलाई साटोफेरो गर्न [लगानी सङ्केत पातो](#InputGestures)को प्रयोग गरि आफ्नै द्रुत कुञ्जी आदेश तोक्नु होस् ।

### उपकर्मी व्यवस्थापक {#toc163}

नेत्रवाणी मेनुको औजार मेनु भित्र रहेको उपकर्मीहरूको व्यवस्थापन भन्ने विकल्पको रूपमा उपलब्ध उपकर्मीको व्यवस्थापकले तपाइलाई नेत्रवाणीका उपकर्मीहरूलाई स्थापना वा बहिष्कार गर्ने अनुमति प्रदान गर्ने छ ।
उपकर्मीका पोकाहरूमा समुदाय र प्रचलित सामाग्री संहिताहरू हुन्छन् जसले नेत्रवाणीमा र अतिरिक्त ब्रेल पटल वा वाचन संश्लेषकहरूमा अतिरिक्त सुविधाहरू थप्ने वा परिवर्तन गर्ने छन् ।

उपकर्मी व्यवस्थापकमा तपाइको चालू नेत्रवाणीको उपभोक्ता अभियोजनमा रहेका उपकर्मीहरूको सुची प्रदर्शित हुन्छन् ।
सबै उपकर्मीहरूको नाम, संस्करण र लेखक को जानकारी यसमा रहनेछन्, विवरण र URL जस्ता थप जानकारी उपकर्मीको बारेमा भन्ने टाँकलाई दबाएर प्राप्त गर्न सकिन्छ ।
यदी चयनित उपकर्मीको सहयोग उपलब्ध छ भने, तपाइले उपकर्मी सहयोग भन्ने टाँकलाई दबाएर उक्त सहयोग पढ्न सक्नु हुन्छ ।

उपलब्ध उपकर्मीलाई उघार्न वा डाउनलोड गर्न उपकर्मी प्राप्ति टाँकलाई दबाउनु होस् ।
यो टाँकले [नेत्रवाणी उपकर्मी पृष्ठ page](https://addons.nvda-project.org/) लाई पल्टाइ दिनेछ ।
यदि तपाइको प्रणालीमा नेत्रवाणी भित्र्याएर चालू अवस्थाम छ भने छ भने उघार्ने मुद्राबाटै सोझै उपकर्मीलाई तलको तरिका अपनाई स्थापना गर्न सकिन्छ ।
अन्यथा उपकर्मीको पोकोलाई बचत गरी स्थापना गर्नु होस् ।

तपाइले प्राप्त गर्नु भएको उपकर्मीलाई भित्र्याउन, भित्र्याउ भन्ने टाँकलाई दबाउनु होला ।
यसले तपाइलाई आफ्नो कल्पयन्त्रमा वा सञ्जालमा कतै तिर राखिएको उपकर्मीको पोको (.nvda-addon फाइल)लाई उघारने अवसर प्रदान गर्ने छ ।
तपाइले पल्टाउ भन्ने विकल्प रोज्नु भयो भने,, भित्रयाउने कार्य प्रारम्भ हुनेछ ।

उपकर्मी भित्रयाउन लाग्दा नेत्रवाणीले तपाइलाई के साँच्चीकै उपकर्मी भित्र्याउन नै चाहेको हो भनेर सोध्ने छ ।
भित्र्याएका नेत्रवाणीका उपकर्मीहरूको कार्य क्षमतामा कुनै पनि रोकटोक हुने छैन, जसको मतलब हुन्छ यदि नेत्रवाणीलाई भित्र्याएको छ भने यसका उपकर्मीहरूको पहुँच तपाइको निजी अभिलेखमा र पुरै प्रणालीमा पनि पुग्ने छ । यो कुरा महत्त्वपूर्ण छ कि विश्वस्त श्रोतबाट प्राप्त उपकर्मीहरूलाई मात्रै भित्र्याउनु राम्रो हुन्छ ।
उपकर्मीलाई भित्र्याए पछि, उपकर्मीलाई सक्षम बनाउन नेत्रवाणीलाई पुनः आरम्भ गर्नु पर्छ ।
जब सम्म तपाइले समाप्त गर्नु हुन्न, सुचीमा नेत्रवाणी उपकर्मीको स्थापना स्थिति देखाउने छ ।

स्थापित उपकर्मीलाई हटाउन, सुचीबाट हटाउन चाहेको उपकर्मीलाई चयन गर्नु होस् र हटाउ भन्ने टाँकलाई दबाउनु होस् ।
नेत्रवाणीले तपाइलाई के साँच्चीकै हटाउन चाहेको हो भनि सोध्ने छ ।
भित्र्याउँदा जस्तै, उपकर्मीलाई हटाउने कार्यले पूर्णता पाउन नेत्रवाणी पुन सुरुवात गर्नु पर्छ ।
जब सम्म तपाइले समाप्त गर्नु हुन्न, सुचीमा नेत्रवाणी उपकर्मीलाई हटाएको स्थिति देखाउने छ ।

यस व्यवस्थापकमा यसको पातो बन् गर्नका लागि 'बन्द गर' भन्ने टाँक पनि मौजुद छ ।
तपाइले कुनै पनि उपकर्मीलाई भित्र्याउनु वा निष्कासन गर्नु भयो भने, नेत्रवाणी तपाइलाई परिवर्तनलाई लागू गर्न पुनरारम्भ गर्ने हो भनि सोध्ने छ ।

विगतमा तपाइको उपभोक्ता अभियोजन घर्रामा सोझै कुनै उपकर्मीहरू वा चालकहरू सम्बन्धी फाइलहरूको प्रतिलिपिक सारेर नेत्रवाणीलाई कार्यदक्ष बनाउन सम्भव थियो ।,
यद्यपि नेत्रवाणीको यो संस्करणले अझै पनि यीनैहरूलाई बहन गर्न सक्छ तर उपकर्मी व्यवस्थापकले यस्ता साधनलाई सुचीमा देखाउँदैन ।
उपलब्ध भएको खण्डमा यि फाइलहरूलाई तपाइको अभियोजन बाट हटाएर उपयुक्त उपकर्मीलाई भित्र्याउनु राम्रो हुन्छ ।

जहाँबाट पनि उपकर्मी व्यबस्थापकमा पहुँच गर्न [लगानी सङ्केत पातो](#InputGestures)को प्रयोग गरि आफ्नै द्रुत कुञ्जी आदेश तोक्नु होस् ।

### पाईथन कन्सोल {#toc164}

नेत्रवाणी मेनुको औजारमा पाइने नेत्रवाणी पाइथन कन्सोल एउटा विकास औजार हो जुन कार्यक्रमको खानतलासी, नेत्रवाणीको अन्तर छानबिन अथवा कुनै अनुप्रयोगमा पहुँच ता श्रेणि बद्धता को निरीक्षणमा उपयोगी छ
थप जानकारीका लागि, कृपया [नेत्रवाणी विकास खण्ड](https://community.nvda-project.org/wiki/Development) मा हेर्नुहोला ।

### चुकुलहरूको पुनः बहन {#toc165}

यो विकल्पलाई एक पटक सक्रिय बनाइयो भने, नेत्रवाणीलाई पुनः सुरुवात नगरि app modules र global pluginsलाई बहन गर्न सक्छ, जुन कुरा विकासकर्ताहरूलाई महत्त्वपूर्ण हुन्छ ।

## समर्थित वाचन संश्लेषक {#SupportedSpeechSynths}

यो खण्डमा नेत्रवाणीले समर्थन गर्ने संश्लेषकको बारेमा बताइएको छ ।
नेत्रवाणीमा प्रयोग हुने प्रकृतिका खरिद वा डाउनलोड गर्न सकिने निःशुल्क र व्यावसायिक संश्लेषकहरुको विस्तृत सुचीको लागि , कृपया [https://www.nvda-project.org/wiki/ExtraVoices](https://www.nvda-project.org/wiki/ExtraVoices) पृष्ठमा हेर्नु होला ।

### ईइस्पीक् {#toc167}

[ईइस्पीक](https://espeak.sourceforge.net/) नेत्रवाणी भित्रै निर्मित एउटा संस्लेषक हो जसलाई चलाउन अरू कुनै विशेष चालक वा सहभागीको स्थापना गरि रहनु पर्दैन ।
नेत्रवाणीमा ईइस्पीकलाई स्वतः प्रयोग गर्ने गरी निर्धारित गरिएको छ ।
यो संश्लेषकलाई नेत्रवाणी भित्रै निर्मित गरिएको हुँदा, नेत्रवाणीलाई छेस्को भकारीबाट अन्य प्रणालीमा चलाउनका लागि एउटा ठूलो अवसर मिल्ने छ ।

ईइस्पीकमा प्राप्त हुने हरेक आवाजले फरक फरक भाषाहरूका पाटहरू पढ्ने छ ।
हाल यसले नेपाली सहित ६० भन्दा बढी भाषाहरूलाई समर्थन गर्छ ।

विभिन्न ध्वनिमा आवाजहरू सुन्नका लागि यसमा धेरै स्वरहरू पनि राखिएका छन् ।

### माइक्रोसफ्ट वाचन API संस्करण ४ (SAPI 4) {#toc168}

साफी ४ माइक्रोसफ्टको स्तरीय यन्त्रप्राण मा चल्ने पुरानो संस्करण शंश्लेषक हो ।
धेरै वाचन संश्लेषकहरू जसले यसको स्तरीयता लागू गर्छन्, थुप्रै कम्पनीबाट खरिद गर्न वा विभिन्न वेभ साइटबाट निःशुल्क डाउनलोड गर्न सकिन्छ ।
यो संस्लेषकलाइ नेत्रवाणीमा प्रयोग गर्दा , तपाइको प्रणालीमा रहेका सबै साफी ४ मञ्चमा निर्मित आवाजहरू ( [आवाजको अनुकूलता](#VoiceSettings) अथवा [संश्लेषक अनुकूलता चक्र](#SynthSettingsRing) मार्फत पहुँच गर्न सकिन्छ) उपलब्ध हुने छन् ।

यदि तपाइको कल्पयन्त्रमा साफी ४ मञ्चमा निर्मित आवाज स्थापित छ तर यो शंस्लेषक नेत्रवाणीको संश्लेषकको सुचीमा देखा परेन भने, शाफि ४.० runtime binaries लाई https://activex.microsoft.com/activex/controls/sapi/spchapi.exe बाट डाउनलोड गरी भित्र्याउनु होस् ।

### माइक्रोसफ्ट वाचन API संस्करण ५ (SAPI 5) {#toc169}

साफि ५ माइक्रोसफ्टको स्तरीय संश्लेषक यन्त्रप्राण हो ।
यसको स्तरीयता लाई कायम राखेका धेरै वाचन संश्लेषकहरू वेभ साइटहरूबाट निःशुल्क डाउनलोड गर्न वा विविध कम्पनीहरूबाट खरिद गर्न सकिन्छ । तपाइको प्रणालीमा कम्तीमा एउटा साफी ५ आवाज भने भित्र्याइ एकै अवस्थामा हुनु पर्छ ।
नेत्रवाणीमा यो संस्लेषकको प्रयोग गर्दा, तपाइको प्रणालीमा स्थापित सबै साफी ५ पद्धतिका आवाजहरू (जसलाई[आवाजको अनुकूलता पातो](#VoiceSettings) अथवा [संश्लेषक अनुकूलता चक्र](#SynthSettingsRing) मार्फत पहुँच गर्न सकिन्छ) उपलब्ध हुने छन् ।

### माइक्रोसफ्ट वाचन मञ्च {#toc170}

माइक्रोसफ्ट वाचन मञ्च ले धेरै भाषाका संश्लेषकहरू उपलब्ध गराएको छ जसलाई सर् बरमा आधारित अनुप्रयोगहरूमा वाचनका लागि प्रयोग गरिन्छ ।
यी आवाजहरूलाई पनि नेत्रवाणीमा प्रयोग गर्न सकिन्छ ।

यी आवाजहरूलाई नेत्रवाणीमा प्रयोग गर्न तपाइले दुईवटा हिस्साहरू भित्र्याउनु पर्छ ।

* माइक्रोसफ्ट वाचन मञ्च - Runtime (Version 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* माइक्रोसफ्ट वाचन मञ्च - Runtime Languages (Version 11): https://www.microsoft.com/download/en/details.aspx?id=27224
* यो पृष्टमा धेरै वाचन पहिचान गर्ने र पाठ-वाचन गर्ने (TTS) फाइलहरू उपलब्ध छन् ।
चाहेको भाषा/आवाजहरूका TTS तथ्याङ्कहरू भएको फाइललाई छान्नु होला ।
उदाहरणका लागि, MSSpeech_TTS_en-US_ZiraPro.msi नामको फाइल अमेरिकी शैलीको अङ्ग्रेजी आवाजको स्थापक फाइल हो ।
 -

### अडियोलोजिक Tts३ {#toc171}

यो विशेषतः इटाली भाषाको व्यवसायी वाचन संस्लेषक हो ।
यसलाई नेत्रवाणीमा प्रयोग गर्न, तपाइको प्रणालीमा यो संश्लेषकलाई स्थापित गरेको हुनु पर्छ ।
थप जानकारीका लागि , यसको वेभ साइट [www.audiologic.it](http://www.audiologic.it) मा भ्रमण गर्नु होला ।

यो संश्लेषकले [हिज्जे कार्यदक्षता](#VoiceSpellingFunctionality) लाई समर्थन गर्दैन ।

### नेत्रवाणीका लागि न्युवान्स भोकलाइजर {#toc172}

न्युवान्स भोकलाइजर Nuance Communications, Inc. द्वारा निर्मित व्यवसायी र उच्च गुणस्तर युक्त आवाज संस्लेषक हो र नेत्रवाणीका लागि Tiflotecnia, Lda ले विशेष पोकोको रूपमा जारी गरि दिएको हो ।
यसमा ५० भन्दा बढी आवाजहरू समावेश छन् । तपाइ ३० भन्दा बढी भाषाका संश्लेषक भित्र्याउन सक्नु हुन्छ
सबै संश्लेषकका हिस्साहरू र आवाजहरू उपकर्मीको पोकोको रूपमा मुठ्ठी पारिएका छन्, जसले नेत्रवाणीको बहनीय प्रतिमा पनि पूर्ण रूपले काम गर्ने छ ।

नेत्रवाणीका लागि न्युवान्स भोकलाइजर कसरी किन्ने भन्ने कुरा र अन्य विस्तृत जानकारीका लागि यसको वेभ साइट [www.vocalizer.nvdacom](https://www.vocalizer-nvda.com/) मा हेर्नु होला ।
यो उत्पादन विक्रीको निश्चित हिस्सा , नेत्रवाणी स्क्रिन रिडरको थप विकासको लागी भनेर NV Access लाइ दान गरिन्छ ।
=======

## समर्थित ब्रेल पटलहरू {#SupportedBrailleDisplays}

यो खण्डमा नेत्रवाणीले समर्थन गर्ने ब्रेल पटलहरूको बारेमा बताइएको छ ।

### Freedom Scientific Focus/PAC Mate Series {#toc174}

पेनड्राइभ वा ब्लुटुथ भएमा यहा भएका  कुराहरूFreedom Scientific https://www.freedomscientific.com/] लिन सकिन्छ ।
तपाइले Freedom Scientific को चालक भित्र्याएको हुनुपर्छ ।
यदि तपाइ सित उपलब्ध छैनन् भने तपाइले यिनिहरुलाई https://www2.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp बाट प्राप्त गर्न सक्नु हुन्छ ।.
Although this page only mentions the Focus Blue display, the drivers support all Freedom Scientific Focus and Pacmate displays.
If your system is running 64 bit Windows and the drivers were already installed by another screen reader, you will probably still need to install the drivers from this link, as the files required by NVDA were probably not installed by the other screen reader.

By default, NVDA can automatically detect and connect to these displays either via USB or bluetooth.
However, when configuring the display, you can explicitly select “USB” or “Bluetooth” ports to restrict the connection type to be used.
This might be useful if you want to connect the focus display to NVDA using bluetooth, but still be able to charge it using USB power from your computer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |topRouting1 (first cell on display)|
|Scroll braille display forward |topRouting20/40/80 (last cell on display)|
|Scroll braille display back |leftAdvanceBar|
|Scroll braille display forward |rightAdvanceBar|
|Toggle braille tethered to |leftGDFButton+rightGDFButton|
|Toggle left wiz wheel action |leftWizWheelPress|
|Move back using left wiz wheel action |leftWizWheelUp|
|Move forward using left wiz wheel action |leftWizWheelDown|
|Toggle right wiz wheel action |rightWizWheelPress|
|Move back using right wiz wheel action |rightWizWheelUp|
|Move forward using right wiz wheel action |rightWizWheelDown|
|Route to braille cell |routing|
|backspace key |dot7|
|enter key |dot8|
|shift+tab key |brailleSpaceBar+dot1+dot2|
|tab key |brailleSpaceBar+dot4+dot5|
|upArrow key |brailleSpaceBar+dot1|
|downArrow key |brailleSpaceBar+dot4|
|control+leftArrow key |brailleSpaceBar+dot2|
|control+rightArrow key |brailleSpaceBar+dot5|
|leftArrow |brailleSpaceBar+dot3|
|rightArrow key |brailleSpaceBar+dot6|
|home key |brailleSpaceBar+dot1+dot3|
|end key |brailleSpaceBar+dot4+dot6|
|control+home key |brailleSpaceBar+dot1+dot2+dot3|
|control+end key |brailleSpaceBar+dot4+dot5+dot6|
|alt key |brailleSpaceBar+dot1+dot3+dot4|
|alt+tab key |brailleSpaceBar+dot2+dot3+dot4+dot5|
|escape key |brailleSpaceBar+dot1+dot5|
|windows key |brailleSpaceBar+dot2+dot4+dot5+dot6|
|space key |brailleSpaceBar|
|windows+d key (minimize all applications) |brailleSpaceBar+dot1+dot2+dot3+dot4+dot5+dot6|
|Report Current Line |brailleSpaceBar+dot1+dot4|
|NVDA menu |brailleSpaceBar+dot1+dot3+dot4+dot5|

For newer Focus models that contain rocker bar keys (focus 40, focus 80 and focus blue):

| नाम |कुञ्जी|
|---|---|
|Move braille display to previous line |leftRockerBarUp, rightRockerBarUp|
|Move braille display to next line |leftRockerBarDown, rightRockerBarDown|

For Focus 80 only:

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |leftBumperBarUp, rightBumperBarUp|
|Scroll braille display forward |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA BC640/680 {#toc175}

Both the ALVA BC640 and BC680 displays from [Optelec](https://www.optelec.com/) are supported when connected via USB or bluetooth.
You do not need any specific drivers to be installed to use these displays.
Just plug in the display and configure NVDA to use it.

While these displays do have a braille keyboard, they handle translation from braille to text themselves.
Therefore, NVDA's braille input table setting is not relevant.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |t1|
|Move braille display to previous line |t2|
|Move braille display to next line |t4|
|Scroll braille display forward |t5|
|Route to braille cell |routing|
|shift+tab key |sp1|
|alt key |sp2|
|escape key |sp3|
|tab key |sp4|
|upArrow key |spUp|
|downArrow key |spDown|
|leftArrow key |spLeft|
|rightArrow key |spRight|
|enter key |spEnter|
|NVDA Menu |sp1+sp3|
|windows+d key (minimize all applications) |sp1+sp4|
|windows key |sp2+sp3|
|alt+tab key |sp2+sp4|

<!-- KC:endInclude -->

### Handy Tech Displays {#toc176}

NVDA supports all displays from [Handy Tech](https://www.handytech.de/) when connected via USB or bluetooth.
For older USB displays, you will need to install the USB drivers from Handy Tech on your system.

Braille input is not yet supported.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |left, up|
|Scroll braille display forward |right, down|
|Move braille display to previous line |b4|
|Move braille display to next line |b5|
|Route to braille cell |routing|
|shift+tab key |esc|
|alt key |b2+b4+b5|
|escape key |b4+b6|
|tab key |enter|
|enter key |esc+enter|
|upArrow key |leftSpace|
|downArrow key |rightSpace|
|NVDA Menu |b2+b4+b5+b6|
|Handy Tech configuration |b4+b8|

<!-- KC:endInclude -->

### MDV Lilli {#toc177}

The Lilli braille display available from [MDV](https://www.mdvbologna.it/) is supported.
You do not need any specific drivers to be installed to use this display.
Just plug in the display and configure NVDA to use it.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display backward |LF|
|Scroll braille display forward |RG|
|Move braille display to previous line |UP|
|Move braille display to next line |DN|
|Route to braille cell |route|
|shift+tab key |SLF|
|tab key |SRG|
|alt+tab key |SDN|
|alt+shift+tab key |SUP|

<!-- KC:endInclude -->

### Baum/Humanware/APH Braille Displays {#toc178}

Several [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/) and [APH](https://www.aph.org/) displays are supported when connected via USB or bluetooth.
These include:

* Baum: SuperVario, PocketVario
* HumanWare: Brailliant, BrailleConnect
* APH: Refreshabraille

Some other displays manufactured by Baum may also work, though this has not been tested.

If connecting via USB, you must first install the USB drivers provided by the manufacturer.
For the APH Refreshabraille, the USB mode must be set to serial.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |d2|
|Scroll braille display forward |d5|
|Move braille display to previous line |d1|
|Move braille display to next line |d3|
|Route to braille cell |routing|

For displays which have a joystick:

| नाम |कुञ्जी|
|---|---|
|upArrow key |up|
|downArrow key |down|
|leftArrow key |left|
|rightArrow key |right|
|enter key |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#toc179}

The hedo ProfiLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
You must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Say all |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#toc180}

The hedo MobilLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
You must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Say all |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant BI/B Series {#toc181}

The Brailliant BI and B series of displays from [HumanWare](https://www.humanware.com/), including the BI 32, BI 40 and B 80, are supported when connected via USB or bluetooth.
If connecting via USB, you must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |down|
|Route to braille cell |routing|
|Toggle braille tethered to |up+down|
|upArrow key |space+dot1|
|downArrow key |space+dot4|
|leftArrow key |space+dot3|
|rightArrow key |space+dot6|
|NVDA Menu |c1+c3+c4+c5 (command n)|
|shift+tab key |space+dot1+dot3|
|tab key |space+dot4+dot6|
|alt key |space+dot1+dot3+dot4 (space+m)|
|escape key |space+dot1+dot5 (space+e)|
|enter key |dot8|
|windows+d key (minimize all applications) |c1+c4+c5 (command d)|
|windows key |space+dot3+dot4|
|alt+tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|Say all |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

### HIMS Braille Sense/Braille EDGE Series {#toc182}

NVDA supports Braille Sense and Braille EDGE displays from [Hims](https://www.hims-inc.com/) when connected via USB or bluetooth.
If connecting via USB, you will need to install the USB drivers from HIMS on your system.
You can download these from the HIMS Resource Center: https://www.hims-inc.com/resource-center/
On this page, select your device and download the driver in the Window-Eyes section.
Although the section only mentions Window-Eyes, this is a general USB driver which will work with NVDA as well.

Following are the key assignments for these displays with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |left side scroll down|
|Scroll braille display forward |right side scroll down|
|Move braille display to previous line |left side scroll up|
|Move braille display to next line |right side scroll up|
|Route to braille cell |routing|
|shift+tab key |dot1+dot2+space|
|alt key |dot1+dot3+dot4+Space|
|escape key |dot1+dot5+Space|
|tab key |dot4+dot5+Space|
|enter key |dot8|
|backspace key |dot7|
|upArrow key |dot1+Space|
|downArrow key |dot4+Space|
|capsLock |dot1+dot3+dot6+space|
|shift+alt+tab key |advance2+advance3+advance1|
|alt+tab key |advance2+advance3|
|end key |dot4+dot6+space|
|Control+end key |dot4+dot5+dot6+space|
|home key |dot1+dot3+space|
|control+home key |dot1+dot2+dot3+space|
|leftArrow key |dot3+space|
|control+shift+leftArrow key |dot2+dot8+space+advance1|
|control+leftArrow key |dot2+space|
|shift+alt+leftArrow key |dot2+dot7+advance1|
|alt+leftArrow key |dot2+dot7|
|rightArrow key |dot6+space|
|control+shift+rightArrow key |dot5+dot8+space+advance1|
|control+rightArrow key |dot5+space|
|shift+alt+rightArrow key |dot5+dot7+advance1|
|alt+rightArrow key |dot5+dot7|
|pageUp key |dot1+dot2+dot6+space|
|control+pageUp key |dot1+dot2+dot6+dot8+space|
|control+shift+upArrow key |dot2+dot3+dot8+space+advance1|
|control+upArrow key |dot2+dot3+space|
|shift+alt+upArrow key |dot2+dot3+dot7+advance1|
|alt+upArrow key |dot2+dot3+dot7|
|shift+upArrow key |left side scroll down+ space|
|pageDown key |dot3+dot4+dot5+space|
|control+pagedown key |dot3+dot4+dot5+dot8+space|
|control+shift+downArrow key |dot5+dot6+dot8+space+advance1|
|control+downArrow key |dot5+dot6+space|
|shift+alt+downArrow key |dot5+dot6+dot7+advance1|
|alt+downArrow key |dot5+dot6+dot7|
|shift+downArrow key |right side scroll down+ space|
|delete key |dot1+dot3+dot5+space|
|f1 key |dot1+dot2+dot5+space|
|f3 key |dot1+dot2+dot4+dot8|
|f4 key |dot7+advance3|
|windows+b key |dot1+dot2+advance1|
|windows+d key |dot1+dot4+dot5+advance1|

<!-- KC:endInclude -->

### HIMS SyncBraille {#toc183}

NVDA supports the SyncBraille Display from [HIMS](https://www.hims-inc.com/).
You will need to install the USB drivers from HIMS on your system.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |left side scroll down|
|Scroll braille display forward |right side scroll down|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Seika Braille Displays {#toc184}

The Seika Version 3, 4 and 5 (40 cells) and Seika80 (80 cells) braille displays from [Nippon Telesoft](https://www.nippontelesoft.com/) are supported.
You can find more information about these displays at https://www.seika-braille.com/.
You must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |b3|
|Move braille display to next line |b4|
|Toggle braille tethered to |b5|
|Say all |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|NVDA Menu |left+right|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Papenmeier BRAILLEX Newer Models {#toc185}

The following Braille displays are supported:

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB and bluetooth)
* BRAILLEX Live 20, BRAILLEX Live and BRAILLEX Live Plus (USB and bluetooth)

If BrxCom is installed, NVDA will use BrxCom.
BrxCom is a tool that allows keyboard input from the braille display to function independently from a screen reader.
A new version of BrxCom which works with NVDA will be released by Papenmeier soon.
Keyboard input is possible with the Trio and BRAILLEX Live models.

Most devices have an Easy Access Bar (EAB) that allows intuitive and fast operation.
The EAB can be moved in four directions where generally each direction has two switches.
The C and Live series are the only exceptions to this rule.

The c-series and some other displays have two routing rows whereby the upper row is used to report formatting information.
Holding one of the upper routing keys and pressing the EAB on c-series devices emulates the second switch state.
The live series displays have one routing row only and the EAB has one step per direction.
The second step may be emulated by pressing one of the routing keys and pressing the EAB in the corresponding direction.
Pressing and holding the up, down, right and left keys (or EAB) causes the corresponding action to be repeated.

Generally, the following keys are available on these braille displays:

| नाम |कुञ्जी|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

Following are the Papenmeier command assignments for NVDA:
<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Toggle braille tethered to |r2|
|Report title |l1+up|
|Report Status Bar |l2+down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |left2|
|Move to next object |right2|
|Report text formatting |upper routing row|

<!-- KC:endInclude -->

The Trio model has four additional keys which are in front of the braille keyboard.
These are (ordered from left to right):

* left thumb key (lt)
* space
* space
* right thumb key (rt)

Currently, the right thumb key is not in use.
The inner keys are both mapped to space.

| नाम |कुञ्जी|
|---|---|

<!-- KC:beginInclude -->

|backspace key |dot 7|
|enter key |dot 8|
|escape key |space with dot 7|
|upArrow key |space with dot 2|
|leftArrow key |space with dot 1|
|rightArrow key |space with dot 4|
|downArrow |space with dot 5|
|control key |lt+dot2|
|alt key |lt+dot3|
|control+escape key |space with dot 1 2 3 4 5 6|
|tab key |space with dot 3 7|

<!-- KC:endInclude -->

### Papenmeier Braille BRAILLEX Older Models {#toc186}

The following Braille displays are supported:

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

Note that these displays can only be connected via a serial port.
Therefore, you should select the port to which the display is connected after you have chosen this driver in the Braille Settings dialogue.

Some of these devices have an Easy Access Bar (EAB) that allows intuitive and fast operation.
The EAB can be moved in four directions where generally each direction has two switches.
Pressing and holding the up, down, right and left keys (or EAB) causes the corresponding action to be repeated.
Older devices do not have an EAB; front keys are used instead.

Generally, the following keys are available on braille displays:

| नाम |कुञ्जी|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

Following are the Papenmeier command assignments for NVDA:

<!-- KC:beginInclude -->
Devices with EAB:

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Report title |l1up|
|Report Status Bar |l2down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to next object |right2|
|Move to previous object |left2|
|Report text formatting |Upper routing strip|

BRAILLEX Tiny:

| नाम |कुञ्जी|
|---|---|
|समीक्षामा चयनीत वर्ण बताउ |l1|
|विचरक वस्तुलाई सक्रिय गर |l2|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Toggle braille tethered to |r2|
|Move to containing object |r1+up|
|Move to first contained object |r1+dn|
|Move to previous object |r1+left|
|Move to next object |r1+right|
|Report text formatting |reportf|
|Report title |l1+up|
|Report status bar |l2+down|

BRAILLEX 2D Screen:

| नाम |कुञ्जी|
|---|---|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Toggle braille tethered to |r2|
|Report text formatting |reportf|
|Move braille display to previous line |up|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to next line |dn|
|Move to next object |left2|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#toc187}

NVDA supports the BrailleNote notetakers from [Humanware](https://www.humanware.com) when acting as a display terminal for a screen reader.
The following models are supported:

* BrailleNote Classic (serial connection only)
* BrailleNote PK (Serial and bluetooth connections)
* BrailleNote MPower (Serial and bluetooth connections)
* BrailleNote Apex (USB and Bluetooth connections)

If your device supports more than one type of connection, when connecting your BrailleNote to NVDA, you must set the braille terminal port in braille terminal options.
Please check the BrailleNote manual for details.
In NVDA, you may also need to set the port in the Braille Settings dialog.
If you are connecting via USB or bluetooth, you can set the port to “Automatic”, “USB” or “Bluetooth”, depending on the available choices.
If connecting using a legacy serial port (or a USB to serial converter) or if none of the previous options appear, you must explicitly choose the communication port to be used from the list of hardware ports.

Before connecting your BrailleNote Apex using its USB client interface, you must install the drivers provided by HumanWare.

Following are the BrailleNote command assignments for NVDA.
Please check your BrailleNote's documentation to find where these keys are located.

<!-- KC:beginInclude -->

| नाम |कुञ्जी|
|---|---|
|Scroll braille display back |back|
|Scroll braille display forward |advance|
|Move braille display to previous line |previous|
|Move braille display to next line |next|
|Route to braille cell |routing|
|Toggle braille tethered to |previous+next|
|Up arrow key |space+dot1|
|Down arrow key |space+dot4|
|Left Arrow key |space+dot3|
|Right arrow key |space+dot6|
|Page up key |space+dot1+dot3|
|Page down key |space+dot4+dot6|
|Home key |space+dot1+dot2|
|End key |space+dot4+dot5|
|Control+home keys |space+dot1+dot2+dot3|
|Control+end keys |space+dot4+dot5+dot6|
|Space key |space|
|Enter key |space+dot8|
|Backspace key |space+dot7|
|Tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|Shift+tab keys |space+dot1+dot2+dot5+dot6|
|Windows key |space+dot2+dot4+dot5+dot6 (space+w)|
|Alt key |space+dot1+dot3+dot4 (space+m)|
|Toggle input help |space+dot1+dot2+dot5 (space+h)|

<!-- KC:endInclude -->

### EcoBraille {#toc188}

NVDA supports EcoBraille displays from [ONCE](https://www.once.es/).
The following models are supported:

* EcoBraille 20
* EcoBraille 40
* EcoBraille 80
* EcoBraille Plus

In NVDA, you can set the serial port to which the display is connected in the Braille Settings dialog.

Following are the key assignments for EcoBraille displays.
Please see the [EcoBraille documentation](ftp://ftp.once.es/pub/utt/bibliotecnia/Lineas_Braille/ECO/) for descriptions of where these keys can be found.

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |T2|
|Scroll braille display forward |T4|
|Move braille display to previous line |T1|
|Move braille display to next line |T5|
|Route to braille cell |Routing|
|Activate current navigator object |T3|
|Switch to next review mode |F1|
|Move to containing object |F2|
|Switch to previous review mode |F3|
|Move to previous object |F4|
|Report current object |F5|
|Move to next object |F6|
|Move to focus object |F7|
|Move to first contained object |F8|
|Move System focus or caret to current review position |F9|
|Report review cursor location |F0|
|Toggle braille tethered to |A|

<!-- KC:endInclude -->

### BRLTTY {#toc189}

[BRLTTY](https://mielke.cc/brltty/) is a separate program which can be used to support many more braille displays.
In order to use this, you need to install [BRLTTY for Windows](https://brl.thefreecat.org/brltty/).
You should download and install the latest installer package, which will be named, for example, brltty-win-4.2-2.exe.
When configuring the display and port to use, be sure to pay close attention to the instructions, especially if you are using a USB display and already have the manufacturer's drivers installed.

For displays which have a braille keyboard, BRLTTY currently handles braille input itself.
Therefore, NVDA's braille input table setting is not relevant.

Following are the BRLTTY command assignments for NVDA.
Please see the [BRLTTY key tables documentation](https://mielke.cc/brltty/doc/KeyTables/) for information about how BRLTTY commands are mapped to controls on braille displays.
<!-- KC:beginInclude -->

| Name |BRLTTY command|
|---|---|
|Scroll braille display back |fwinlt (go left one window)|
|Scroll braille display forward |fwinrt (go right one window)|
|Move braille display to previous line |lnup (go up one line)|
|Move braille display to next line |lndn (go down one line)|
|Route to braille cell |route (bring cursor to character)|

<!-- KC:endInclude -->

## Braille control type and state abbreviations {#toc190}

In order to fit as much information as possible on a braille display, The folowing abbreviations have been defined to indicate control type and state.

| Abbreviation |Control type|
|---|---|
|btn |button|
|cbo |combo box|
|chk |check box|
|dlg |dialog|
|edt |editable text field|
|gra |graphic|
|cN |table column number n, e.g. c1, c2.|
|rN |table row number n, e.g. r1, r2.|
|hN |heading at level n, e.g. h1, h2.|
|lnk |link|
|lst |list|
|vlnk |visited link|
|mnu |menu|
|mnubar |menu bar|
|rbtn |radio button|
|tb |table|
|tv |treeview|
|lv N |a tree view item has a hierarchical level N||
|`-----` |seperator|

The following state indicators are also defined:

| Abbreviation |Control state|
|---|---|
|... |displayed when an object supports autocompletion|
|( ) |displayed when an object (e.g. a check box) is not checked|
|(x) |displayed when an object (e.g. a check box) is checked|
|(-) |displayed when an object (e.g. a check box) is half checked|
|- |displayed when an object (e.g. a tree view item) is collapsible|
|+ |displayed when an object (e.g. a tree view item) is Expandable|
|clk |displayed when an object is clickable|
|ro |displayed when an object (e.g. an editable text field) is read-only|
|sel |displayed when an object is selected|
|submnu |displayed when an object has a popup (usually a sub-menu)|

## समृद्ध शीर्षकहरू {#toc191}
### आदेश रेखा विकल्प {#CommandLineOptions}

नेत्रवाणीले सुरुवात हुँदा एउटा वा धेरै अतिरिक्त विकल्पहरूलाई स्वीकार्न सक्छ जसले यसको आनी बानिमा हेर फेर ल्याउँछ ।You can pass as many options as you 
तपाइले आफूले चाहे जति विकल्पहरूलाई समाबेस गर्न सक्नु हुन्छ ।
These options can be passed when starting from a shortcut (in the shortcut properties), from the Run dialog (Start Menu -> Run or Windows+r) or from a Windows command console.
Options should be separated from the name of NVDA's executable file and from other options by spaces.
For example, the Desktop shortcut that NVDA creates during installation has the -r option, which tells NVDA to close the currently running copy before starting the new one.
Another useful option is --disable-addons, which tells NVDA to suspend all running add-ons.
This allows you to determine whether a problem is caused by an add-on and to recover from serious problems caused by add-ons.

As an example, you can exit the currently running copy of NVDA by entering the following in the Run dialog:

nvda -q

Some of the command line options have a short and a long version, while some of them have only a long version.
For those which have a short version, you can combine them like this:

|nvda -rm |This will exit the currently running copy of NVDA and will start a new copy with startup sounds disabled, etc.|
|nvda -rm --disable-addons |Same as above, but with add-ons disabled|

Some of the command line options accept additional parameters; e.g. how detailed the logging should be or the path to the user configuration directory.
Those parameters should be placed after the option, separated from the option by a space when using the short version or an equals sign (=) when using the long version; e.g.:

|nvda -l 10 |Tells NVDA to start with log level set to debug|
|nvda --log-file=c:\nvda.log |Tells NVDA to write its log to c:\nvda.log|
|nvda --log-level=20 -f c:\nvda.log |Tels NVDA to start with log level set to info and to write its log to c:\nvda.log|

नेत्रवाणी आदेश रेखाका आदेशहरू निम्न अनुसार छन् । 

| छोटो |लामो |विवरण|
|---|---|---|
|-h |--help |आदेश रेखा सहयोग देखाउ र बहिर्गमन गर|
|-q |--quit |चलिरहेको नेत्रवाणीलाई बन्द गर|
|-r |--replace |नेत्रवाणीलाई बन्द गरी पुनः सुरुवात गर|
|-k |--check-running |नेत्रवाणी चलिरहेको छ वा छैन भनि सङ्केत गर । न चलेको भए ० र चलेको भए १ देखाउ ।|
|-f LOGFILENAME |--log-file=LOGFILENAME |लगत विवरण लेख्ने फाइल लाइ देखाउ to|
|-l LOGLEVEL |--log-level=LOGLEVEL |The lowest level of message logged (debug 10, info 20, warning 30, error 40, critical 50), default is warning|
|-c CONFIGPATH |--config-path=CONFIGPATH |The path where all settings for NVDA are stored|
|-m |--minimal |No sounds, no interface, no start message etc|
|-s |--secure |Secure mode (disable Python console)|
|None |--disable-addons |Addons will have no effect|
|None |--no-sr-flag |Don't change the global system screen reader flag|
|None |--install |Installs NVDA (starting the newly installed copy)|
|None |--install-silent |Silently installs NVDA (does not start the newly installed copy)|

### चिन्हहरूको उच्चारणको समृद्ध अनुकूलता {#toc193}

[सङ्केत/चिन्ह उच्चारण](#SymbolPronunciation) पातोमा उपलब्ध सुविधा बाहेक यसबाट सङ्केतहरू अन्य चिन्हहरूको उच्चारणलाई अनुकूलन गर्न सम्भव छ ।
उदाहरणका लागि, तपाइले कच्चा चिन्ह लाई संश्लेषकमा पठाउने (जस्तै छोटो विश्राम लीन अथवा चर्को पना बदल्न) र प्रचलित चिन्हहरू थप्न सक्नु हुनेछ ।

यसका लागि, तपाइले आफ्नो नेत्रवाणी अभियोजन घर्रामा रहेको चिन्ह उच्चारण जानकारी फाइललाई सम्पादन गर्नु पर्छ ।
यो फाइललाई symbols-xx.dic नाम दिइएको छ, यहाँ xx को अर्थ भाषाको संहिता हो ।
यो फाइलको स्वरूप 'नेत्रवाणी विकास निर्देशिका' को चिन्ह उच्चारण खण्डमा वर्णन गरिएको छ, जसलाई [नेत्रवाणीको विकास खण्ड सम्बन्धी वेभ पृष्ठ](https://community.nvda-project.org/wiki/Development) मा पाउन सकिन्छ ।
तर उपभोक्ता आफै ले जटिल चिन्हहरूलाई परिभाषित गर्न भने सम्भव हुने छैन ।

## थप जानकारी {#toc194}

यदी तपाइ नेत्रवाणीको बारेमा यस भन्दा थप जानकारी वा सहयोग चाहनु हुन्छ भने कृपया नेत्रवाणी को वेभ साइट NVDA_URL को भ्रमण गर्नु होला ।
यहाँ तपाइले अतिरिक्त कागजातहरू, प्राविधिक सहयोग र समुदायका श्रोतहरू पाउन सक्नु हुनेछ ।
यो साइटले नेत्रवाणीको विकास सम्बन्धी जानकारी र सामाग्रीहरू उपलब्ध गराउने छ ।

