# ﻿NVDA NVDA_VERSION Udhëzues për përdorim

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Referenca të shpejta për urdhrat në tastierë -->



## Hyrje {#toc2}

Qasja jo-vizuale në desktop (NVDA) është lexues ekrani falas dhe prej burimeve të hapura për sistemin operativ Microsoft Windows.
Duke ofruar përgjigje përmes të folurit sintetik dhe shkrimit braille, programi NVDA u mundëson personave të verbër ose me dëmtime të shikimit që të kenë qasje në kompjuterët që operojnë me Windows, me koston e njëjtë si për personin jo të verbër.
Programi NVDA është krijuar nga [NV Access](http://www.nvaccess.org/), me kontributet e komunitetit.

### Karakteristikat e përgjithshme {#toc3}

Programi NVDA u mundëson të verbërve dhe personave me dëmtime të shikimit që të kenë qasje dhe të bashkëveprojnë me sistemin operativ Windows dhe shumë aplikacione të tjera.
Pjesët më interesante përfshijnë:

* Mbështetje për aplikacionet e popullarizuara, duke përfshirë shfletuesit e internetit, klientët e e-mailëve, programet për bisedë në internet dhe kompletet për zyra
* Sintetizuesin e inkorporuar të të folurit që mbështet më shumë se 20 gjuhë
* Njoftime për formatimin tekstual, kur është në dispozicion, siç janë emri dhe madhësia e fontit, stili dhe gabimet në drejtshkrim
* Njoftime automatike për tekstin e hijezuar me miun dhe treguesin opcional të pozicionit të miut, i cili mund të dëgjohet
* Mbështetje për shumë shpalosje të shkrimit braille që mund të freskohen
* Mundësi për ta përdorur programin nga USB dhe mediet e tjera portative pa pasur nevojë për instalimin e programit
* Lehtësi në përdorimin e instaluesit që flet
* Është përkthyer në shumë gjuhë
* Mbështetje për shumë Sisteme Operative moderne të Microsoft Windows-it, duke përfshirë dy versionet prej 32 dhe 64 bitësh
* Mundësi për ta përdorur me rastin e regjistrimit në Windows dhe ekrane tjera të siguruara 
* Mbështetje për ndërfaqet e zakonshme të qasshmërisë siç janë Microsoft Active Accessibility, Java Access Bridge, IAccessible2 and UI Automation
* Mbështetje për Paralajmërimin e Urdhrave të Microsoft-it dhe aplikacionet e konzolave

++ Ndërkombëtarizimi ++
Është e rëndësishme që njerëzit anekënd botës, pavarësisht nga gjuha që ata flasin, të kenë qasje të barabartë në teknologji.
Përveç gjuhës angleze, programi NVDA është përkthyer në më shumë se 20 gjuhë, duke përfshirë gjuhën arabe, portugeze të Brazilit, kroate, ceke, finlandeze, franceze, gale, gjermane, hungareze, italiane, japoneze, portugeze, ruse, sllovake, spanjolle, tajlandeze, kineze tradicionale, ukrainase, afrikane, polake dhe vietnameze.

++ Mbështetja e sintetizuesit të të folurit ++
Përveç ofrimit të porosive të tij dhe ndërfaqeve në shumë gjuhë, programi NVDA gjithashtu i mundëson përdoruesit që të lexojë përmbajtjen në çdo gjuhë, përderisa ata e kanë sintetizuesin e të folurit që mund të flasë atë gjuhë.
Programi NVDA shoqërohet me [eSpeak](http://espeak.sourceforge.net/), i cili është një sintetizues falas, nga burime të hapura dhe shumëgjuhësh i të folurit.
Informatat për sintetizuesit tjerë të të folurit që i mbështet programi NVDA mund të gjenden në pjesën [Sintetizuesit e mbështetur të të folurit](#SupportedSpeechSynths).

++ Mbështetja për gjuhën braille ++
Për shfrytëzuesit që posedojnë shpalosje të shkrimit braille të rifreskueshme, programi NVDA mund të nxjerrë informatat e tij në gjuhën braille.
 Shikoni pjesën [Shpalosjet e mbështetura të shkrimit braille](#SupportedBrailleDisplays) për informata mbi shpalosjet e mbështetura të shkrimit braille .
Programi NVDA mbështetë kode të shkrimit braille për shumë gjuhë, duke përfshirë kode të brailleit të kontraktuara, të pakontraktuara dhe kompjuterike për disa gjuhë.

++ Licenca dhe e drejta autoriale ++
E drejta e autorit për programin NVDA u takon kontribuuesve NVDA_COPYRIGHT_YEARS NVDA.
Programi NVDA mbulohet nga Licenca e Përgjithshme Publike GNU (versioni 2).
Jeni të lirë të shpërndani ose të ndryshoni këtë softuer si të dëshironi, përderisa ai të shoqërohet me licencën dhe të veni në dispozicion të gjitha kodet burimore për çdokënd që dëshiron të ketë softuerin.
Kjo vlen si për kopjet origjinale ashtu dhe për ato të modifikuara të këtij softueri, si dhe të gjitha veprat e derivuara.
Për më shumë hollësi, mund të [shihni licencën e plotë. http://ëëë.gnu.org/licenses/old-licenses/gpl-2.0.html]


1. Kërkesat e sistemit +

* Sistemet operative: të gjitha versionet 32 dhe 64 bitëshe të Windows XP, Windows Vista dhe Windows 7 (përfshirë sistemet operative të serverëve).
* Memoria: 256 mb ose më shumë memorie RAM
* Shpejtësia e procesorit: 1.0 ghz ose më shumë
* Përafërsisht 50 MB hapësirë për ruajtje.

## Si të merrni programin NVDA {#toc4}

Nëse ende nuk e keni një kopje të programit NVDA, atë mund ta shkarkoni nga [www.nvda-project.org](NVDA_URL).
Shkoni te seksioni i shkarkimeve dhe aty do të gjeni një vegëz për shkarkimin e versionit të fundit të programit NVDA.
Aktualisht programi NVDA mund të gjendet i paketuar në dy forma.
Njëra formë është Instaluesi i cili do t’ju udhëzojë se si të instaloni programin NVDA në mënyrë që të mund ta përdorni në çdo kohë nga menyja startuese (Start Menu).
Forma tjetër është një arkiv vetë-ekstraktues që përmban një version plotësisht portativ të programit NVDA, të cilin mund ta përdorni kudo, duke përfshirë USB ose CD.
Në mënyrë që të keni qasje në ekranin për regjistrimin në Windows, ekranin e Kontrollit të Llogarive të Përdoruesve (KLlP) ose ekranet e tjera të sigurisë së Windows-it, si dhe aplikacionet që operojnë si administratorë në Windows Vista dhe versionet e mëvonshme, duhet që programin NVDA ta instaloni në sistemin tuaj duke përdorur instaluesin.
Këto ekrane nuk mund të qasen duke përdorur kopjen portative të programit NVDA.

## Instalimi i NVDA {#toc5}
### Instaluesi i NVDA {#toc6}

Nëse keni instaluesin e programit NVDA, thjeshtë shtypni tastin enter ose klikoni dy herë në skedar dhe instaluesi do të iniciohet.
Derisa instaluesi ngarkohet ju do të dëgjoni muzikën e instalimit të NVDA.
Pas ngarkimit, një kopje e përkohshme e programit NVDA do t’ju mundësojë të zbatoni njoftimet e instaluesit dhe instaloni NVDA.
Mbani mend që nëse në momentin e startimit të instaluesit keni pasur ndonjë kopje tjetër të programit NVDA të ruajtur në kompjuter, instaluesi do të mbyll kopjen e mëhershme dhe do të fillojë instalimin.
Kjo është e nevojshme në mënyrë që instaluesi të mund të freskojë të gjithë skedarët e ndryshuar. 
Në këtë pikë, nëse keni ndonjë kopje tjetër të programit NVDA të instaluar në kompjuter, instaluesi i NVDA-së do ta çinstalojë atë për ju dhe pastaj do të fillojë instalimin e NVDA.
Pas përfundimit të suksesshëm të instalimit, instaluesi do t’ju njoftojë se instalimi i programit NVDA ka përfunduar.
Nëse jeni duke riinstaluar programin, instaluesi mund t’ju kërkojë që të ristartoni sistemin në këtë pikë.
Është shumë e rëndësishme që të ristartoni sistemin, sepse nëse nuk bëhet kjo do të ketë pasoja të padëshirueshme.
Nëse instaluesi nuk ju ka kërkuar që ta ristartoni sistemin, shtypja e tasti Finnish do të mbyllë instaluesin dhe do të startojë versionin e sapoinstaluar të NVDA.

### NVDA portative {#toc7}

Nëse keni versionin portativ të programit NVDA, atëherë gjithçka që duhet të bëni është të shtypni tastin Enter ose të klikoni dy herë mbi skedarin dhe të zbatoni udhëzimet.
Instaluesi do t’ju pyes ne ç’vend në sistemin tuaj dëshironi të vendosni skedarët.

#### NVDA portative në USB {#toc8}

Është e mundur që programin NVDA ta vendosni në një USB në mënyrë që të mund ta përdorni në sisteme kompjuterike tjera.
Nëse versioni Portativ ju pyet se ku dëshironi ta ç’paketoni atë, shtypni emrin e drajverit të USB-së suaj, si dhe të një nën-direktorie opsionale ku  dëshironi të vendosni programin NVDA.
Nëse, për shembull, drajveri për USB-në tuaj është në E:\, ju duhet të shtypni E:\nvda dhe programi NVDA do të vendoset në nën-direktorinë e NVDA-së në USB-në tuaj.
Mbani mend që megjithëse kjo do të thotë se mund ta bartni programin NVDA dhe konfigurimet e tij me vete kudo që të shkoni, kyçja e thjeshtë e USB-së nuk do të startojë NVDA-në automatikisht; ju do të duhet të startoni programin NVDA në mënyrë manuale nga Windows Explorer ose dialogu Run.
Për informata rreth startimit automatik të programit NVDA nga USB, shihni artikullin: http://ëëë.nvda-project.org/ëiki/RunningAutomaticallyFromAUSBDrive

## Startimi i programit NVDA {#toc9}
### Lansimi i programit NVDA {#toc10}

Nëse keni instaluar programin NVDA përmes instaluesit, atëherë startimi është i thjeshtë. Ju mund të shtypni control+alt+n ose të përzgjidhni NVDA nga menyja e programit NVDA në skedarin Programs në menynë startuese (Start Menu).
Gjithashtu, ju mund të shtypni NVDA në dialogun Run dhe të shtypni tastin Enter.
Për të startuar versionin portativ, shkoni në direktorinë në të cilën keni shpaketuar programin NVDA dhe shtypni tastin Enter ose klikoni dy herë në nvda.exe.
Kur të startojë programi do të dëgjoni një varg tingujsh me rend të rritjes (që ju tregon se po ngarkohet programi NVDA).
Varësisht prej shpejtësisë së kompjuterit tuaj, apo nëse e shfrytëzoni programin NVDA nga një USB ose medium tjetër më të ngadalshëm, do të kalojë pak kohë derisa NVDA të startojë.
Nëse startimi i programit NVDA zgjat për kohë më të gjatë, NVDA duhet të thotë “NVDA po ngarkohet. Ju lutem pritni…”
Nëse nuk dëgjoni asnjë nga këto fjalë, ose dëgjoni tingullin që sinjalizon gabim në Windows, ose një varg tingujsh me rend të zvogëlimit, atëherë kjo do të thotë që ka një gabim në programin NVDA dhe ju duhet t’ua raportoni defektin zhvilluesve të programit. 
Kontrolloni në ueb faqen e programit NVDA për mënyrën se si mund ta raportoni defektin.
Kur programi NVDA të startojë për herë të parë, ju do të përshëndeteni përmes një kutie dialogu që ju ofron disa informata themelore për tastin për modifikim të NVDA dhe menynë e NVDA-së.
 (Shihni udhëzimet shtesë për këto tema).
Kutia e dialogut gjithashtu përmban dy kuti opcionesh.
Kutia e parë ju lejon të zgjidhni nëse programi NVDA duhet të përdor tastin capslock si një tast modifikues të programit NVDA, ndërsa kutia e dytë ju lejon të kontrolloni nëse kutia paralajmëruese për Mirëseardhje duhet të shfaqet sa herë që NVDA të startohet.

### Rreth urdhrave të NVDA në tastierë {#toc11}
#### Tasti modifikues i NVDA {#toc12}

Shumica e urdhrave në tastierë që janë specifikë për programin NVDA zakonisht konsistojnë në shtypjen e një tasti të veçantë që quhet tast modifikues i NVDA, së bashku me një ose më shumë taste tjerë.
Përjashtim përbëjnë urdhrat për rishikimin e tekstit të cilat shfrytëzojnë vetëm tastet në pjesën e numrave (ang. numpad) vetvetiu. 
Programi NVDA mund të konfigurohet në atë mënyrë që të mundësojë shfrytëzimin e tasteve Insert, Extended Insert në numpad ose tastin capslock si taste modifikues të NVDA-së.
Tastet Insert dhe Extended Insert në numpad janë të konfiguruar në mënyrë automatike si taste modifikues të programit NVDA. 
Nëse dëshironi të shkaktoni që njëri nga tastet modifikues të programit NVDA të veprojë si tasti origjinal i tij (për shembull, dëshironi që të kyçni tastin capslock pasi të keni caktuar capslock si tast modifikues të programit NVDA) mund të shtyni dy herë tastin në mënyrë të njëpasnjëshme.

#### Gjendja e ndihmës hyrëse {#toc13}

Ne këtë udhëzues për përdorim janë përmendur shumë urdhra të dhënë përmes tasteve, por një mënyrë e lehtë për të eksploruar të gjithë urdhrat e ndryshëm të dhënë përmes tasteve është të kyçni ndihmën hyrëse.
Nëse dëshironi të kyçni ndihmën hyrëse, shtypni NVDA+1.
Nëse dëshironi të ç’kyçni ndihmën hyrëse, shtypni NVDA+1 përsëri.
Derisa të shfrytëzoni ndihmën hyrëse, shtypja e cilitdo tast do t’ju njoftojë me funksionin që ka ai (nëse ka ndonjë funksion).
Në të vërtetë tastet nuk do të kryejnë funksionin e tyre derisa ju jeni duke përdorur ndihmën hyrëse, kështu që mund të shtypni cilado taste që dëshironi.

#### Pamjet e tastierës {#toc14}

Aktualisht programi NVDA vjen me dy grupe të urdhrave që jepen përmes tasteve.
Programi ka një pamje të tastierës për kompjuterë Desktop dhe një pamje të tastierës për kompjuterë Laptop.
Programi NVDA është konfiguruar që në mënyrë automatike të përdorë pamjen për kompjuterë Desktop, megjithatë ju mund të kaloni në pamjen Laptop në Keyboard Settings të cilat gjenden në skedarin Preferences në menynë e NVDA.
Pamja Desktop i shfrytëzon shumë tastet në pjesën e numrave (me tastin numlock të ç’kyçur).
Edhe pse shumica e kompjuterëve laptop nuk kanë tastierë fizike të numrave, disa laptopë mund të emulojnë këtë tastierë nëse shtypet tasti FN dhe pastaj shtypen shkronjat dhe numrat në anën e djathtë të tastierës (7 8 9 u i o j k l etj).
Nëse laptopi juaj nuk mund të bëjë këtë, ose nuk ju lejon të ç’kyçni tastin numlock, në vend të kësaj ju mund të kaloni në pamjen Laptop.

### Menyja e programit NVDA {#toc15}

Menyja e programit NVDA ju lejon që të kontrolloni konfigurimet e NVDA, të keni qasje në ndihmën, të ruani/riktheni konfigurimin tuaj, modifikoni fjalorët e të folurit, keni qasje në vegla shtesë dhe të dilni nga programi NVDA.
Në mënyrë që të shkoni në menynë e programit NVDA prej çdo kund në Windows derisa NVDA është duke punuar, shtypni NVDA+n.
Në menynë e programit NVDA mund të shkoni edhe përmes panelin e punës (ang. System tray or taskbar) të Windows-it.
Mundeni ose të klikoni me pjesën e djathtë të miut në ikonën nvda që gjendet në panelin e punës ose të arrini te paneli i punës duke shtypur tastin që ka logon e Windows-it edhe shkronjën B, të shkoni me shigjetën poshtë deri te ikona NVDA dhe të shtypni tastin për aplikacione i cili në shumicën e tastierave gjendet në anën e djathtë të tastit Control.
Kur dritarja e menysë të shfaqet në ekran, ju mund të përdorni tastet e shigjetave për të naviguar nëpër meny dhe tastin Enter për të aktivizuar ndonjë gjë.

### Urdhra themelor të dhënë përmes tasteve {#toc16}

<!-- KC:beginInclude -->

| Emri |Tasti |Përshkrimi|
|---|---|---|
|Ndalo të folurit |Control |Të folurit ndalon menjëherë|
|Pauzo të folurit |Shift |Të folurit pauzon menjëherë. Nëse shtypet përsëri tasti, të folurit do të vazhdojë aty ku ka mbetur (nëse pauzimi mbështetet nga sintetizuesi aktual)|
|Menyja e programit NVDA |NVDA+n |Menyja e programit NVDA shfaqet duke ju mundësuar që të shkoni te preferencat, veglat dhe ndihma, etj.|
|Alterno gjendjen e të folurit| NVDA+s |Alternon gjendjen e të folurit ndërmjet të folurit, bipeve dhe ç’kyçjes.|
|Alterno gjendjen e ndihmës për tastierën |NVDA+1 |Shtypja e çdo tasti në këtë gjendje do të raportojë tastin dhe përshkrimin e çfarëdo urdhri të ndërlidhur me të|
|Mbyll programin NVDA |NVDA+q |Mbyllë programin NVDA|
|Kalo përmes tastit pasues |NVDA+f2 |I thotë programit NVDA që me shtypjen e tastit të radhës të kalojë drejtpërdrejtë te aplikacioni, edhe nëse zakonisht trajtohet si urdhër i NVDA i dhënë përmes tastit|

|Alterno aplikacionin e gjendjes së pushimit ndërmjet kyçjes dhe ç’kyçjes | NVDA+shift+s | gjendja e pushimit çaktivizon të gjithë urdhrat e programit NVDA dhe outputin e të folurit/shkrimit braille për aplikacionin aktual. Kjo është më së shumti e dobishme në aplikacionet që ofrojnë tiparet e tyre të të folurit ose leximit të ekranit. Për të çaktivizuar gjendjen e vetë-zërimit, shtyp këtë urdhër përsëri. |
<!-- KC:endInclude -->

### Raportimi i informatave të sistemit {#toc17}

<!-- KC:beginInclude -->

| Emri |Tasti |Përshkrimi|
|---|---|---|
|Raporto datën/kohën |NVDA+f12 |Nëse shtypet njëherë raporton kohën, nëse shtypet dy herë raporton datën|
|Raporto statusin e baterisë |NVDA+shift+b |Raporton statusin e baterisë d.m.th. nëse kompjuteri është duke punuar me rrymë elektrike ose përqindjen aktuale të baterisë së mbetur.|
|Raporto tekstin në clipboard |NVDA+c |Raporton tekstin në clipboard, nëse ka të tillë.|

<!-- KC:endInclude -->

## Navigimi me programin NVDA {#toc18}
### Navigimi me fokusin e sistemit {#toc19}

Mënyra më e zakonshme e navigimit nëpër Windows me programin NVDA është që thjesht të lëvizet me urdhrat standard të Windows-it të dhënë përmes tastierës, siç janë shtypja e tab dhe shift+tab për të lëvizur para dhe pas në mes të kontrolleve, shtypja e alt për të shkuar te paneli i menysë dhe, më pas, shfrytëzimi i shigjetave për të naviguar menytë, si dhe shfrytëzimi i alt+tab për të lëvizur nëpër aplikacionet aktive.
Kjo lëviz fokusin e sistemit;  d.m.th. objektin që pranon tastet e shtypur në tastierë.
Derisa jeni duke e bërë këtë, programi NVDA do të raportojë informata për objektin me fokusim, si janë emri, lloji, vlera, gjendja, përshkrimi, shkurtesa në tastierë dhe informatat pozicionuese të tij.
Ekzistojnë disa urdhra, të dhënë përmes tasteve, që janë të dobishëm gjatë lëvizjes me fokusin e Sistemit:
<!-- KC:beginInclude -->

| Emri |Tasti| Përshkrimi|
|---|---|
|Raporto fokusin aktual |NVDA+tab |njofton për objektin ose kontrollin aktual që ka fokusin e Sistemit. Nëse shtypet dy herë informacioni do të shqiptohet|
|Raporto titullin |NVDA+t |njofton titullin e dritares që aktualisht është aktive. Nëse shtypet dy herë informacioni do të shqiptohet. Nëse shtypet tre herë informacioni do të kopjohet në clipboard|
|Lexo dritaren aktive |NVDA+b |lexon të gjitha kontrollet në dritaren që aktualisht është aktive (e dobishme për dialogë)|
|Raporto panelin e statusit |NVDA+end |Raporton panelin e statusit nëse programi NVDA gjen një të tillë. Gjithashtu, lëvizë objektin navigues në këtë lokacion|

<!-- KC:endInclude -->

### Navigimi me kursorin për editim {#toc20}

Kur fokusi është mbi një objekt që ka një kursor të editimit (gjithashtu të njohur si kursori i sistemit), ju mund të lëvizni përreth me shigjetë dhe të editoni njëjtë si zakonisht.
Programi NVDA do t;ju njoftojë derisa lëvizni nëpër karaktere, fjalë dhe rreshta dhe gjithashtu do të njoftojë selektimin ose mos-selektimin e tesktit.
Në lidhje me kursorin për editim, programi NVDA ofron urdhrat, të dhënë përmes tasteve, në vijim:
<!-- KC:beginInclude -->

| Emri |Tasti |Përshkrimi|
|---|---|---|
|Thuaj të gjitha |NVDA+Shigjeta poshtë |Fillon leximin prej pozitës aktuale të kursorit për editim, duke e lëvizur me vete derisa vazhdon|
|Lexo rreshtin aktual |NVDA+Shigjeta lartë |Lexon rreshtin në të cilin gjendet aktualisht kursori për editim. Nëse shtypet dy herë rreshti do të shqiptohet.|
|Lexo tekstin e selektuar aktualisht |NVDA+Shift+ Shigjeta lartë |Lexon gjithë tekstin aktualisht të selektuar|
|Raporto formatimin e tekstit |NVDA+f |Njofton për formatimin e tekstit në pjesën ku është vendosur kursori për editim|

Nëse ka tabelë, urdhrat në vijim të dhënë përmes tasteve janë gjithashtu në dispozicion:

| Emri |Tasti |Përshkrimi|
|---|---|---|
|Kalo në kolonën e mëparshme |control+alt+Shigjeta majtas |Lëviz kursorin për editim në kolonën e mëparshme (duke qëndruar në rreshtin e njëjtë)|
|Kalo në kolonën e radhës |control+alt+Shigjeta djathtas |Lëviz kursorin për editim në kolonën e radhës (duke qëndruar në rreshtin e njëjtë)|
|Kalo në rreshtim e mëparshëm |control+alt+ Shigjeta lartë |Lëviz kursorin për editim në rreshtin e mëparshëm (duke qëndruar në kolonën e njëjtë)|
|Kalo në rreshtin e radhës |control+alt+ Shigjeta poshtë |Lëviz kursorin për editim në rreshtin e radhës (duke qëndruar në kolonën e njëjtë)|

<!-- KC:endInclude -->

### Navigimi i objekteve {#toc21}

Nëse dëshironi të eksploroni aplikacionin ose Sistemin Operativ aktual pa e lëvizur fokusin, mund të përdorni navigimin e objekteve të programit NVDA.
Kjo ju mundëson që të lëvizni ndërmjet objekteve individuale, siç janë teksti, butonat, kutitë për opsione, rrëshqitësit, listat dhe fushat tekstuale të editueshme si dhe të merrni informata për ato.
Kur të lëvizni tek një objekt, programi NVDA do ta raportojë këtë në mënyrë të ngjashme me raportimin e fokusit të sistemit.
Në vend se të lëvizet para dhe pas nëpër çdo objekt në sistem, objektet janë të grupuara sipas një hierarkie.
Kjo nënkupton që ju duhet të lëvizni përbrenda disa objekteve në mënyrë që të arrini te objektet që ata përmbajnë.
Për shembull, në vend se të lëvizni nëpër të gjithë pikat e listës kur kemi të bëjmë me një listë, duhet të lëvizni përbrenda listës (d.m.th. të navigoni te objekti bijë i parë i saj) në mënyrë që të keni qasje në përmbajtjen e saj.
Mund të lëvizni jashtë listës (të navigoni në objektin amë) për të vazhduar përtej listës.
Në mënyrë të ngjashme, nëse hasni në një panel të veglave, duhet të lëvizni brenda panelit (të navigoni në bijën e parë) për të pasur qasje në kontrollet në panelin e veglave.
Objekti navigues, në mënyrë automatike, lëviz së bashku me fokusin e sistemit, megjithëse kjo sjellje mund të alternohet në mes të kyçjes dhe ç’kyçjes.
Për të naviguar me objekte, përdorni tastet në vijim:
<!-- KC:beginInclude -->

| Emri |Tasti në desktop |Tasti në laptop |Përshkrimi|
|---|---|---|---|
|Raporto objektin aktual |NVDA+numpad5 |NVDA+control+i |Raporton objektin navigues aktual. Nëse shtypet dy herë do të shqiptohet informata, ndërsa nëse shtypet tre herë do të kopjohet emri dhe vlera e këtij objekti në clipboard.|
|Navigo te objekti amë |NVDA+numpad8 |NVDA+shift+i |Navigon te prindi (përmbajtësi) i objektit navigues aktual|
|Navigo te objekti i mëparshëm |NVDA+numpad4 |NVDA+control+j |Navigon drejtpërdrejtë te objekti para objektit navigues aktual|
|Navigo te objekti bijë i parë |NVDA+numpad2 |NVDA+shift+comma |Navigon te objekti bijë i parë të përmbajtur në objektin navigues aktual|
|Navigo të objekti në fokus |NVDA+numpadMinus |NVDA+backspace |Navigon te objekti që aktualisht ka fokusin e sistemit dhe gjithashtu vendos kursorin e rishikimit në pozitën e kursorit për editim, nëse është i shfaqur|
|Aktivizo objektin navigues aktual |NVDA+numpadEnter |NVDA+enter |Aktivizon objektin navigues aktual (ngjashëm me klikimin e miut ose shtypjen e ‘space’ kur ai ka fokusin e sistemit)|
|Lëviz fokusin e sistemit ose kursorin te pozita aktuale e rishikimit |NVDA+shift+numpadMinus |NVDA+shift+backspace |nëse shtypet një herë lëviz fokusin e sistemit te objekti navigues aktual, ndërsa nëse shtypet dy herë lëviz kursorin për editim te pozita e kursorit për rishikim|
|Raporto dimensionet e objektit navigues |NVDA+numpadDelete |NVDA+delete |Njofton në formë përqindjesh dimensionet e objektit navigues aktual në ekran (duke përfshirë distancën nga ana e majtë dhe e sipërme e ekranit, si dhe gjerësinë dhe lartësinë e tij)|

<!-- KC:endInclude -->
shënim: duhet të ç’kyçet tasti numlock në mënyrë që tastet numpad të punojnë në mënyrë të mirëfilltë.

### Rishikimi i tekstit në objektin aktual {#toc22}

Programi NVDA ju mundëson që të lexoni përmbajtjen e objektit navigues aktual në karaktere, fjalë ose rreshta.
Kjo është kryesisht e dobishme në faqet e konzolës së urdhrave të Windows-it dhe vendet tjera ku kursori për editim është i kufizuar ose jo-ekzistent.
Gjatë lëvizjes së kursorit për rishikim, kursori për editim nuk e përcjell atë, kështu që mundeni të rishikoni tekstin pa e humbur pozitën e editimit.
Ndërsa, në mënyrë të automatizuar, sa herë që kursori për editim lëvizet, lëvizë edhe kursori për rishikim.
Mund të alternohet në mes të kyçjes dhe ç’kyçjes.
Urdhrat në vijim, të dhënë përmes shtypjes së tasteve, janë në dispozicion për rishikimin e tekstit:
<!-- KC:beginInclude -->

| Emri |Tasti në desktop |Tasti në laptop |Përshkrimi|
|---|---|---|---|

|Lëviz te rreshti më i lartë në rishikim | shift+numpad7 | NVDA+7 | Lëvizë kursorin për rishikim tek rreshti i parë në tekst |

|Lëviz te rreshti i mëparshëm në rishikim |numpad7 |NVDA+u |Lëvizë kursorin për rishikim tek rreshti i mëparshëm në tekst|
|Raporto rreshtin aktual në rishikim |numpad8 |NVDA+i |Bën të ditur rreshtin aktual të tekstit në të cilin është pozicionuar kursori për rishikim. Nëse shtypet dy herë kursori për rishikim do të pozicionohet. Nëse shtypet tre herë rreshti do të shqiptohet duke përdorur përshkrime të karaktereve.|
|Lëviz te rreshti i radhës në rishikim| numpad9 |NVDA+o |Lëvizë kursorin për rishikim te rreshti i radhës në tekst|
|Lëviz te rreshti i fundit në rishikim| shift+numpad9 |NVDA+9 |Lëvizë kursorin për rishikim te rreshti i fundit në tekst|
|Lëviz te fjala e mëparshme në rishikim |numpad4 |NVDA+j || Lëvizë kursorin për rishikim te fjala e mëparshme në tekst|
|Raporto fjalën aktuale në rishikim |numpad5 |NVDA+k |Bën të ditur fjalën aktuale në tekst në të cilën është pozicionuar kursori për rishikim. Nëse shtypet dy herë fjala do të shqiptohet. Nëse shtypet tre herë fjala do të duke përdorur përshkrime të germave.|

|Lëviz te fjala e radhës në rishikim | numpad6 | NVDA+l | Lëvizë kursorin për rishikim tek fjala e radhës në tekst |

|Lëviz te fillimi i rreshtit në rishikim |shift+numpad1 |NVDA+shift+u |Lëvizë kursorin për rishikim tek fillimi i rreshtit aktual që po rishikohet|
|Lëviz te karakteri i mëparshëm në rishikim |numpad1 |NVDA+m |Lëvizë kursorin për rishikim te karakteri i mëparshëm në rreshtin actual në tekst|
|Raporto karakterin aktual në rishikim| numpad2 |NVDA+presje |Bën të ditur karakterin aktual në rreshtin ku është pozicionuar kursori për rishikim. Nëse shtypet dy herë, raportohet përshkrimi ose shembulli i atij karakteri. Nëse shtypet tre herë, raportohet vlera numerike e karakterit në decimale ose heksadecimale.|
|Lëviz te karakteri i radhës në rishikim| numpad3 |NVDA+dot |Lëvizë kursorin për rishikim te karakteri i radhës në rishikim|
|Lëviz në fund të rreshtit në rishikim |shift+numpad3 |NVDA+shift+o |Lëvizë kursorin për rishikim te fundi i rreshtit aktual të tekstit|
|Thuaj të gjitha me rishikimet |numpadPlus |NVDA+shift+doënArroë |Lexon prej pozitës aktuale të kursorit për rishikim, duke lëvizur derisa lexon|
|Kopjo nga kursori për rishikim |NVDA+f9 |NVDA+f9 |Fillon të kopjojë tekstin prej pozitës aktuale të kursorit për rishikim. Kopjimi nuk kryhet në të vërtetë derisa ju t’i tregoni programit NVDA ku duhet ta kopjojë atë|

|Kopjo te kursori për rishikim| NVDA+f10 | NVDA+f10 | Kopjon nga pozita e kursorit për rishikim të konfiguruar për kopjim, te pozita aktuale e kursorit për rishikim. Pas shtypjes së këtij tasti, teksti do të kopjohet në clipboard të Windows-it |
<!-- KC:endInclude -->
 shënim: duhet të ç’kyçet tasti numlock në mënyrë që tastet numpad të punojnë në mënyrë të mirëfilltë.
Për t’ju ndihmuar me mbajtjen mend të këtyre urdhrave, urdhrat  themelor për rishikim të tekstit janë organizuar në një tabelë të përbërë nga tre rreshta dhe tre kolona, ku nga lart-poshtë janë të radhitur rreshti, fjala dhe karakteret, ndërsa në drejtimin majtas-djathtas janë radhitur e mëparshme, aktuale dhe e radhës.
Pamja është ilustruar në vazhdim:

|Rreshti i mëparshëm |Rreshti aktual |Rreshti i radhës|
|Fjala e mëparshme |Fjala aktuale |Fjala e radhës|
|Karakteri i mëparshëm |Karakteri aktual |Karakteri i radhës|

### Rishikimi i tërësishëm {#toc23}

Përveç rishikimit të përmbajtjes së çdo objekti, programi NVDA ju mundëson që ta rishikoni tërë përmbajtjen e një dokumenti ose teksti të paraqitur në ekran.
Kjo quhet rishikim i tërësishëm.
Dy urdhrat në vijim përdoren për kyçjen/ ç’kyçjen e rishikimit të tërësishëm:
<!-- KC:beginInclude -->

| Emri |Tasti në desktop|Tasti në laptop |Përshkrimi|
|---|---|---|

|Kalo në rishikim të tërësishëm | NVDA+numpad7 | NVDA+pageUp | Kalon në rishikim të tërësishëm, duke ju vendosur në pozicionin e objektit navigues aktual dhe duke ju mundësuar të rishikoni ekranin (ose dokumentin, nëse aktualisht jeni brenda një dokumenti) me urdhrat për rishikim të tekstit. |

|Kalo nga rishikimi i tërësishëm në objektin| NVDA+numpad1 |NVDA+pageDown |Navigon te objekti i përfaqësuar nga teksti në pozicionin aktual të kursorit për rishikim në rishikimin e tërësishëm|

<!-- KC:endInclude -->

### Navigimi me miun {#toc24}

Kur të lëvizni miun, programi NVDA në mënyrë automatike raporton tekstin që është direkt nën kursorin e miut, ndërsa ky i fundit lëviz mbi atë.
Në rastet kur kjo mbështetet nga programi NVDA, NVDA do të lexojë një paragraf të tërë të tekstit, megjithëse disa kontrolle mund të lexojnë vetëm rresht për rresht.
Gjithashtu, programi NVDA mund të konfigurohet që të njoftojë për llojin e kontrollit ose objektit mbi të cilin gjendet miu derisa lëvizë (p.sh. listë, buton etj.), gjë që mund të jetë e dobishme për përdoruesit plotësisht të verbër, meqë ndonjëherë teksti nuk është i mjaftueshëm.
Programi NVDA ofron një mënyrë për përdoruesit që të dinë ku është miu në relacion me dimensionet e ekranit, duke njoftuar koordinatat aktuale të miut si bipe zanore.
Sa më lartë që të jetë në ekran miu, aq më i lartë do të jetë zëri i bipeve.
Sa më majtas ose djathtas të jetë miu në ekran, aq më majtas ose djathtas do të duket se dëgjohet tingulli (duke supozuar se shfrytëzuesi ka altoparlant stereo).
Këto karakteristika shtesë nuk janë të kyçura në mënyrë automatike në programin NVDA, por nëse dëshironi t’i shfrytëzoni ato mund t’i konfiguroni nga paneli i konfigurimeve për Mouse, që gjendet në menynë e Preferences në menynë e programit NVDA.
Megjithëse miu fizik ose pllaka lëvizëse duhet të përdoret për të naviguar me miun, programi NVDA ka disa urdhra për miun që jepen përmes shtypjes së tasteve:
<!-- KC:beginInclude -->

| Emri |Tasti në desktop |Tasti në laptop|Përshkrimi|
|---|---|---|
|Kliko butonin e majtë të miut |numpadThyesa |NVDA+shigjeta e majtë |klikon një herë butonin e majtë të miut. Klikimi i dyfishtë i zakonshëm mund të bëhet duke shtypur këtë tast dy herë në mënyrë të njëpasnjëshme||
|Blloko butonin e majtë të miut |shift+numpadThyesa |NVDA+shift+ shigjeta e majtë |Bllokon butonin e majtë të miut. Nëse shtypet edhe njëherë butoni ç’bllokohet. Për ta tërhequr miun, shtypni këtë tast për të bllokuar butonin e majtë dhe pastaj lëvizeni miun fizikisht ose duke përdorur njërin prej urdhrave për lëvizjen e miut|
|Kliko butonin e djathtë të miut |numpadShumëzim |NVDA+shigjeta e djathtë |Klikon njëherë butonin e djathtë të miut.|
|Blloko butonin e djathtë të miut |shift+numpadShumëzim |NVDA+shift+ shigjeta e djathtë |Bllokon butonin e djathtë të miut. Nëse shtypet edhe njëherë butoni ç’bllokohet. Për ta tërhequr miun, shtypni këtë tast për të bllokuar butonin e djathtë dhe pastaj lëvizeni miun fizikisht ose duke përdorur njërin prej urdhrave për lëvizjen e miut|
|Lëviz miun te objekti navigues aktual |NVDA+numpadThyesa |NVDA+shift+f9 |Lëvizë miun te vendndodhja e objektit aktual navigues dhe e kursorit për rishikim|
|Navigo te objekti mbi të cilin është pozicionuar miu| NVDA+numpadShumëzim |NVDA+shift+f10 |Vendosë objektin navigues te objekti i pozicionuar në pozitën e miut|

<!-- KC:endInclude -->

## Gjendja e shfletimit {#toc25}

Dokumentet komplekse që vetëm mund të lexohen, si p.sh. ueb faqet, mund të shfletohen në programin NVDA duke përdorur gjendjen e shfletimit.
Këtu përfshihen dokumentet në Mozilla Firefox, Microsoft Internet Explorer, Google Chrome, Adobe Reader dhe Adobe Flash.
Në gjendjen e shfletimit, përmbajtja e dokumentit vihet në dispozicion në një reprezentim të tërësishëm që mund të navigohet me tastet e kursorit sikurse të ishte dokument normal teksti. 
Në këtë gjendje do të punojnë Të gjithë urdhrat e kursorit për editim të programit NVDA; p.sh. thuaj të gjitha, raporto formatimin, urdhrat për të naviguar në tabela, etj.
Informatat që kanë të bëjnë me atë se a është teksti vegëz, titull, etj. njoftohen derisa lëvizni nëpër tekst. 
Ndonjëherë, do t’ju nevojitet të bashkëveproni drejtpërdrejt me kontrollet në këto dokumente.
Këtë do ta bëni duke kaluar në gjendjen e fokusimit, ku të gjithë tastet kalojnë te kontrolli. 
Gjatë gjendjes së shfletimit, në mënyrë automatike, programi NVDA do të kalojë në gjendjen e fokusit nëse e lidhni ose klikoni në ndonjë kontroll të veçantë që kërkon këtë.
Anasjelltas, lidhja ose klikimi në një kontroll për të cilën nuk kërkohet gjendja e fokusit do t’ju kthejë në gjendjen e shfletimit.
Gjithashtu, mund të shtypni enter ose space për të kaluar në gjendjen e fokusit në kontrollet që kërkojnë këtë.
Shtypja e escape do t’ju rikthejë në gjendjen e shfletimit.
Gjendjen e fokusit mund ta konfiguroni edhe në mënyrë manuale, pas së cilës gjendja do të jetë efektive derisa ju të mos e ç’kyçni atë.
<!-- KC:beginInclude -->

| Emri |Tasti |Përshkrimi|
|---|---|---|
|Alterno ndërmjet gjendjeve shfletim/fokusim |NVDA+space |Ndryshon prej gjendjes së fokusimit në gjendjen e shfletimit dhe anasjelltas|
|Dil nga gjendja e fokusimit |escape |Kalon në gjendjen e shfletimit, nëse më parë është kyçur automatikisht gjendja e fokusimit|
|Rifresko dokumentin në gjendjen e shfletimit |NVDA+f5 |Ringarkon përmbajtjen e dokumentit aktual (e dobishme nëse duket se në dokument po mungojnë pjesë të caktuara të përmbajtjes)|
|Gjej |NVDA+control+f |Shfaqet një dialog në të cilin mund të shtypni tekstin që dëshironi të gjeni në dokumentin aktual|
|Gjej më pas |NVDA+f3 |Gjen ndodhjen e radhës të tekstit të cilin e keni kërkuar më parë në dokument|
|Gjej të mëparshmin |NVDA+shift+f3 |Gjen ndodhjen e mëparshme të tekstit të cilin e keni kërkuar më parë në dokument|

<!-- KC:endInclude -->

### Navigimi përmes shkronjave {#toc26}

Në gjendjen e shfletimit, me qëllim të navigimit më të shpejtë, programi NVDA ofron gjithashtu mundësinë e shfrytëzimit të tasteve të shkronjave për të kaluar në fusha të caktuara të dokumentit.
<!-- KC:beginInclude -->
Tastet në vijim vetvetiu kalojnë te elementi i radhës në dispozicion, ndërsa nëse shtohet tasti shift ato kalojnë në elementin e mëparshëm:

* h: titulli
* l: lista
* i: elementi i listës
* t: tabela
* k: vegza
* n: teksti që nuk është i lidhur me vegëz
* f: fusha e formularit
* u: vegëza që nuk është vizituar
* v: vegëza që është vizituar
* e: fusha e editimit
* b: butoni
* x: kutia opsionale
* c: kutia kombo
* r: kutia për radio
* q: citati bllok
* s: ndarësi
* m: korniza
* g: grafikë
* d: pika e referimit ARIA 
* o: objekt i ndërvënë
* 1 deri 6: titujt 1 deri 6 

<!-- KC:endInclude -->

### Lista e elementëve {#toc27}

Lista e elementëve mundëson qasjen në listën e vegzave, titujve ose pikave të referimit ARIA në dokument.
Radio butonet mundësojnë që të kaloni nga njëri prej këtyre tre llojeve të informacionit në tjetrin.
Në dialog gjithashtu ofrohet një fushë për editim, e cila ju mundëson të filtroni listën për t’ju ndihmuar gjatë kërkimit të ndonjë elementi të caktuar në faqe.
Pasi të keni zgjedhur ndonjë element, mund të përdorni butonët e ofruar në dialog për të lëvizur te ose për të aktivizuar atë element.
<!-- KC:beginInclude -->

| Emri |Tasti| Përshkrimi|
|---|---|
|Lista e elementëve në gjendjen e shfletimit |NVDA+f7 |Shfaq listën e elementëve e cila përmban vegza, titujt dhe pika referimi nga dokumenti aktual|

<!-- KC:endInclude -->

### Objektet e ndërvëna {#toc28}

Faqet mund të përmbajnë përmbajtje të pasur duke shfrytëzuar teknologjitë siç janë Adobe Flash dhe Sun Java.
Nëse haset në elementë të tillë në gjendjen e shfletimit, programi NVDA do të njoftojë “objekt i ndërvënë”.
Ju mund të shtypni enter në këto objekte për të bashkëvepruar me ato.
Nëse keni qasje, atëherë ju mund të lëvizni dhe të bashkëveproni më atë si me çdo aplikacion tjetër.
Një urdhër i dhënë përmes tastit është ofruar për të mundësuar kthimin te faqja origjinale e cila përmban objektin e ndërvënë:
<!-- KC:beginInclude -->

| Emri |Tasti |Përshkrimi|
|---|---|---|
|Lëviz dokumenti në gjendjen e shfletimit që përmban objektin e ndërvënë |NVDA+control+space |Lëviz fokusin jashtë objektit aktual të ndërvënë dhe kalon te dokumenti që e përmban atë|

<!-- KC:endInclude -->

## Konfigurimi i programit NVDA {#toc29}
### Preferencat {#toc30}

<!-- KC:settingsSection: || Emri | Tasti në desktop | Tasti në laptop |Përshkrimi | -->
Shumica e konfigurimeve të programit NVDA mund të ndryshohen duke përdorur kutitë e dialogëve përmes nënmenysë Preferences në menynë e programit NVDA.
Në të gjithë panelet e konfigurimeve të programit NVDA shtypni butonin OK për të pranuar çfarëdo ndryshimesh që mund të keni bërë.
Për të anuluar ndryshimet, shtypni butonin Cancel ose tastin Escape.
Disa panele të konfigurimit gjithashtu mund të ndryshohen duke përdorur tastet për shkurtesa, të cilat janë paraqitur në pjesët përkatëse të mëposhtme.

#### Konfigurimet e përgjithshme (NVDA+control+g) {#toc31}

Kutia e panelit të konfigurimeve të përgjithshme gjendet në menynë Preferences.
Ajo përmban opsionet vijuese:

##### Gjuha {#toc32}

Duhet të paraqitet një kuti kombo që ju mundëson të përzgjidhni gjuhën për ndërfaqen dhe porositë në programin NVDA.
Ka shumë gjuhë, por opsioni automatik është “User Default, Windows".
Ky opsion i thotë programit NVDA që ta përdor gjuhën në të cilën aktualisht është konfiguruar Windows-i.
Mbani mend që programi NVDA duhet të ristartohet pas ndryshimit të gjuhës.
Pasi që të keni ndryshuar gjuhën, programi NVDA do t’ju pyes nëse dëshironi të ristartoni. 
Shtypni OK dhe programi NVDA do të ristartohet.

##### Ruaj konfigurimin me rastin e daljes nga programi NVDA {#toc33}

Ky opsion është një kuti opsionesh, që nëse klikohet i thotë programit NVDA që automatikisht që ruajë konfigurimin aktual kur ju të dilni nga NVDA.

##### Paralajmëro para daljes nga programi NVDA {#toc34}

Ky opsion është një kuti opsionesh që ju mundëson të zgjidhni që me rastin e daljes nga programi NVDA të paraqitet një dialog që ju pyet se a dëshironi që të dilni nga programi.
Nëse klikohet, sa herë që të tentoni të dilni nga programi NVDA do të paraqitet një dialog që ju pyet nëse dëshironi ose jo të dilni nga programi.

##### Niveli i regjistrimit {#toc35}

Kjo është një kuti kombo që ju lejon të zgjidhni sa do të regjistrojë programi NVDA derisa është i aktivizuar.
Në përgjithësi shfrytëzuesit nuk kanë nevojë të prekin këtë, sepse nuk regjistrohet aq shumë.
Por nëse dëshironi që të jepni informata në raportin për defekte, atëherë mund të jetë një opsion i dobishëm.

##### Starto programin NVDA në mënyrë automatikë pas regjistrimit në Windows {#toc36}

Nëse është aktivizuar ky opsion, programi NVDA do të startojë në mënyrë automatike menjëherë pas regjistrimit në Windows.
Ky opsion është i mundur vetëm për kopjet e instaluara të programit NVDA.

##### Përdor programin NVDA në ekranin për regjistrim në Windows (kërkohen privilegje të administratorit) {#toc37}

Nëse regjistroheni në Windows duke dhënë emrin dhe fjalëkalimin e përdoruesit, atëherë aktivizimi i këtij opsioni do të bëjë që programi NVDA të startojë në mënyrë automatike në ekranin e regjistrimit pas startimit të Windows-it.
Ky opsion është i mundur vetëm për kopjet e instaluara të programit NVDA.

##### Përdor konfigurimet aktualisht të ruajtura në ekranin e regjistrimit dhe ekranet tjera të sigurisë {#toc38}

Shtypja e këtij butoni kopjon konfigurimin aktual të ruajtur për përdoruesit e programit NVDA në direktorinë e konfigurimit të sistemit të NVDA, ashtu që programi NVDA do ta përdor gjatë aktivizimit me rastin e regjistrimit, Kontrollit të Llogarive të Përdoruesit (UAC) dhe ekraneve tjera të sigurisë të Windows-it.
Në mënyrë që të siguroheni që të gjitha konfigurimet tuaja do të transferohen, siguroni që pikësëpari të ruani konfigurimin tuaj me control+NVDA+c ose ruani konfigurimin  në menynë e programit NVDA.
Ky opsion është i mundur vetëm për kopjet e instaluara të programit NVDA.

#### Përzgjedhja e sintetizuesit (NVDA+control+s) {#toc39}

Dialogu i Sintetizuesit që gjendet në "Synthesizer..." në menynë Preferences, ju mundëson që të përzgjidhni cilin Sintetizues do ta përdorë për të folur programi NVDA.
Pasi të keni përzgjedhur sintetizuesin që dëshironi, mund të shtypni OK dhe programi NVDA do të ngarkojë Sintetizuesin e përzgjedhur.
Nëse ka ndonjë gabim gjatë ngarkimit të sintetizuesit, programi NVDA do t’ju njoftojë me një porosi dhe do të vazhdojë ta përdorë sintetizuesin e mëparshëm.

##### Sintetizuesi {#toc40}

Ky opsion ju mundëson që ta përzgjidhni sintetizuesin të cilin dëshironi që programi NVDA ta përdorë  gjatë të folurit.
Për të parë listën e sintetizuesve që përdor programi NVDA, ju lutem shihni pjesën [Sintetizuesit e mbështetur të të folurit](#SupportedSpeechSynths).
Një opsion i veçantë që gjithmonë do të paraqitet në listë është “Mos fol”, i cili ju mundëson që programin NVDA ta përdorni pa kurrfarë të foluri.
Kjo mund të jetë e dobishme për dikë që dëshiron ta përdorë programin NVDA vetëm me gjuhën braille, ose ndoshta për zhvilluesit që nuk janë të verbër dhe që vetëm dëshirojnë ta përdorin Shikuesin e të folurit.

##### Mekanizmi dalës {#toc41}

Ky opsion ju mundëson të zgjidhni kartën e zërimit të cilën programi NVDA do ta përdorë gjatë të folurit.

+++ Konfigurimet e zërit (NVDA+control+v) +++[ Konfigurimet e zërit]
Paneli i konfigurimeve të zërit, që gjendet në menynë Preferences, përmban opsione që ju mundësojnë të ndryshoni tingëllimin e të folurit.
Për rrugë alternative më të shpejta të kontrollimit të parametrave të të folurit, shihni pjesën [Unaza e konfigurimeve të sintetizuesit](#SynthSettingsRing).
Paneli i konfigurimeve të zërit përmban opsionet në vijim:

##### Zëri {#toc42}

Opsioni i parë që shfaqet në këtë dialog është një kuti kombo që renditë të gjithë zërat e sintetizuesit që aktualisht keni instaluar.
Ju mund të përdorni tastet e shigjetave për t’i dëgjuar të gjitha zgjedhjet e ndryshme. 
Shigjetat Majtas dhe Lartë do t’ju ndihmojnë që të lëvizni lartë në listë, ndërsa shigjetat Djathtas dhe Poshtë për të lëvizur më poshtë nëpër listë.

##### Varianti {#toc43}

Nëse jeni duke përdorur sintetizuesin Espeak, i cili vjen me pakon e programit NVDA, kjo është një kuti kombo që ju mundëson të përzgjidhni Variantin me të cilin duhet të flasë sintetizuesi.
Variantet e eSpeak ngjajnë me zërat e zakonshëm, sepse i japin atribute pak më të ndryshme zërit të eSpeak. 
Disa variante do të tingëllojnë si zë burri, disa të tjerë si zë femre, madje ka variant që tingëllon si zëri i bretkosës.

##### Ritmi {#toc44}

Ky opsion ju mundëson të ndryshoni ritmin e zërit tuaj.
Ky është një rrëshqitës që lëviz nga 0 deri në 100, (0 është ritmi më i ngadalshëm, 100 është më i shpejti).

##### Lartësia {#toc45}

Ky opsion ju mundëson të ndryshoni lartësinë e zërit aktual.
Ky është një rrëshqitës që lëviz nga 0 deri në 100, (0 është lartësia më e ulët dhe 100 është më e larta).

##### Vëllimi {#toc46}

Ky opsion është një rrëshqitës që lëviz nga 0 deri në 100, (0 është vëllimi më i ultë dhe 100 është vëllimi më i lartë).

##### Infleksioni {#toc47}

Ky opsion është një rrëshqitës që ju mundëson të zgjidhni nivelin e infleksionit (ngritja dhe rënia e lartësisë) që sintetizuesi duhet ta përdorë për të folur. (Për momentin i vetmi sintetizues që ofron këtë opsion është eSpeak).
<!-- KC:setting -->

##### Niveli i shenjave të pikësimit/simboleve {#toc48}

Tastet: NVDA+p

Kjo ju mundëson që të zgjidhni sasinë e shenjave të pikësimit ose simboleve të tjera që duhet të fliten si fjalë.
Për shembull, nëse është përzgjedhur opsioni të gjitha, të gjitha simbolet do të fliten si fjalë.

##### Lartësia e ngritur e zërit për shkronjat e mëdha {#toc49}

Nëse zgjidhet, ky konfigurim do të ngritë lartësinë e zërit për shkronjat e mëdha.

##### Thuaj "CAP" para shkronjave të mëdha {#toc50}

Ky konfigurim është kuti opsionesh, që nëse përzgjidhet, i thotë programit NVDA të thotë fjalën “cap;" para çdo shkronje të madhe, gjatë vendosjes së shigjetës mbi të ose kur të flitet derisa është duke u shtypur.
Zakonisht, programi NVDA e ngritë pakës zërin për çdo shkronjë të madhe por disa sintetizues mund të mos e mbështesin këtë, kështu që ky opsion ndoshta mund të jetë i dobishëm.

##### Bip për shkronjat e mëdha {#toc51}

Nëse kjo kuti opsionesh zgjidhet, programi NVDA vetvetiu do të jap një bip të vogël sa herë që të hasë në një  shkronjë të madhe.
Sikurse kutia opsionale “thuaj cap për shkronjat e mëdha”, kjo është e dobishme për Sintetizuesit që nuk mund ta ndryshojnë lartësinë e zërit për shkronjat e mëdha.

#### Unaza e konfigurimeve të sintetizuesit {#SynthSettingsRing}

Nëse dëshironi që të bëni ndryshime të shpejta të konfigurimeve të të folurit pa shkuari te paneli i konfigurimeve të Zërit, programi NVDA ka disa opsione për dhënien e urdhrave përmes tasteve të cilat ju mundësojnë të lëvizni nëpër shumicën e konfigurimeve të të folurit, prej kudo, gjatë punës me programit NVDA:
<!-- KC:beginInclude -->

| Emri |Tasti në desktop |Tasti në laptop |Përshkrimi|
|---|---|---|---|
|Kalo në konfigurimin e radhës të sintetizuesit |NVDA+control+Shigjeta e djathtë |NVDA+control+ Shigjeta e djathtë |Lëvizë prej konfigurimit aktual te konfigurimi i radhës në dispozicion për të folurit,  duke u kthyer prapë te konfigurimi i parë pas atij të fundit|
|Kalo në konfigurimin e mëparshëm të sintetizuesit |NVDA+control+Shigjeta e majtë |NVDA+control+ Shigjeta e majtë |Lëvizë prej konfigurimit aktual te konfigurimi i mëparshëm në dispozicion për të folurit, duke u kthyer prapë në konfigurimin e fundit pas të parit|

|Rrit konfigurimin aktual të sintetizuesit | NVDA+control+ Shigjeta lartë | NVDA+control+Shigjeta lartë | Rritë konfigurimin aktual të të folurit. P.sh. rritë lartësinë, zgjedh zërin e rradhës, rritë vëllimin |

|Zvogëlo konfigurimin aktual të sintetizuesit |NVDA+control+Shigjeta poshtë |NVDA+control+ Shigjeta poshtë |zvogëlon konfigurimin aktual të të folurit. P.sh. zvogëlon lartësinë, zgjedh zërin e mëparshëm, zvogëlon vëllimin|

<!-- KC:endInclude -->

#### Konfigurimet e shkrimit braille {#toc53}

Paneli i konfigurimeve të shkrimit braille mund të kërkohet duke shkuar te menyja Preferences dhe pastaj të opsioni i konfigurimit të shkrimit braille.

##### Shpalosja e shkrimit braille {#toc54}

Opsioni i parë në të cilin do të hasni në panelin e konfigurimeve të shkrimit braille është një kuti kombo që thotë “shpalos gjuhën braille”.
Do t’ju prezantohen disa opsione, varësisht prej asaj se çfarë drajvera për shfaqjen e shkrimit braille janë në sistemin tuaj.
Lëvizni ndërmjet këtyre opsioneve duke përdorur tastet e shigjetave.
"No Braille" nënkupton që nuk po përdorni gjuhën braille.
Për më shumë informata rreth shpalosjeve të mbështetura të shkrimit braille, shihni pjesën [Pamjet e mbështetura të shkrimit braille #](SupportedBrailleDisplays).

##### Tabela e përkthimit {#toc55}

Opsioni i radhës në të cilin do të hasni në këtë panel është kutia kombo me tabelat e shkrimit braille. 
Në këtë kuti kombo, do të gjeni tabelat e shkrimit braille për gjuhë të ndryshme. Duke përdorur tastet e shigjetave mund të lëvizni nga një tabelë e shkrimit braille në tabelën tjetër në këtë listë.

##### Shpalos gjuhën braille në kompjuter për fjalën në kursor {#toc56}

Ky opsion ju mundëson që fjala që gjendet nën kursor të shpaloset në gjuhën braille të pakontraktuar të kompjuterit.

##### Ritmi i dridhjes së kursorit {#toc57}

Ky opsion është një fushë numerike që ju mundëson të ndryshoni ritmin e dridhjes së kursorit në milisekonda. 

##### Koha e shfaqjes së porosive (sek.) {#toc58}

Ky opsion është një fushë numerike që kontrollon se sa gjatë porositë e sistemit do të shpalosen në gjuhën braille.

<!-- KC:setting -->

##### Lidhja me gjuhën braille {#toc59}

Tasti: NVDA+control+t

Ky opsion ju mundëson të zgjidhni nëse shpalosja e shkrimit braille do të përcjell fokusin e sistemit, ose do të përcjellë objektin navigues/ kursorin për rishikim.

#### Konfigurimet e tastierës (NVDA+control+k) {#toc60}

Ky panel i konfigurimeve gjendet në menynë Preferencës, te “Keyboard settings...".
Ajo përmban opsionet në vijim:

##### Pamja e tastierës {#toc61}

Kjo kuti kombo ju mundëson të zgjidhni cilin lloj të pamjes duhet ta përdorë programi NVDA. Për momentin, dy pamjet që vijnë me programin NVDA janë pamjet për Desktop dhe Laptop.

##### Përdor tastin capslock si tast modifikues të programit NVDA {#toc62}

Nëse zgjidhet kjo kuti opsionale, tasti capslock mund të përdoret si tast për modifikimin e programit NVDA.

##### Përdor tastin extended insert si tast modifikues të programit NVDA {#toc63}

Nëse zgjidhet kjo kuti opsionale, tasti extended insert (zakonisht gjendet mbi tastet e shigjetave, afër tasteve home dhe end) mund të përdoret si tast për modifikimin e programit NVDA.

##### Përdor tastin insert në pjesën e numrave në tastierë (numpad) si tast modifikues të programit NVDA {#toc64}

Nëse zgjidhet kjo kuti opsionale, tasti insert në numpad mund të përdoret si tast për modifikimin e programit NVDA.

<!-- KC:setting -->

##### Fol karakteret e shtypura {#toc65}

Tasti: NVDA+2

Kur aktivizohet, programi NVDA do të njoftojë të gjithë karakteret që shtypni në tastierë.

<!-- KC:setting -->

##### Fol fjalët e shtypura {#toc66}

Tasti: NVDA+3

Kur aktivizohet, programi NVDA do të njoftojë të gjitha fjalët që shtypni në tastierë.

##### Lajmëro me bip gjatë shtypjes së shkronjave të vogla kur tasti Caps Lock është i aktivizuar {#toc67}

Kur aktivizohet, do të dëgjohet një bip paralajmërues nëse shtypet një shkronjë me tastin shift derisa caps lock është i aktivizuar.
Në përgjithësi, shtypja e shkronjave përmes shiftit me caps lock është e paqëllimshme dhe zakonisht bëhet për shkak se personi ka harruar që caps lock-u është aktivizuar.
Rrjedhimisht, mund të jetë ndihmesë mjaft e madhe që paralajmërohet për këtë.

<!-- KC:setting -->

##### Fol tastet për dhënien e urdhrave {#toc68}

Tasti: NVDA+4

Kur aktivizohet, programi NVDA do t’ju njoftojë për të gjithë tastet që nuk janë karaktere e që shtypen në tastierë. Këtu përfshihen edhe kombinimet, si p.sh. tasti control, plus ndonjë shkronjë tjetër.

#### Konfigurimet e miut (NVDA+control+m) {#toc69}

Paneli për konfigurimet e miut gjendet në menynë Preferences, te "Mouse settings...".
Ai përmban opsionet në vijim:

##### Raporto ndryshimet e formës së miut {#toc70}

Kuti opsionale që, nëse zgjidhet, nënkupton se programi NVDA do t’ju njoftojë për formën e kursorit të miut sa herë që ajo ndryshon.
Kursori i miut në Windows ndryshon formën për të përcjellë informata të caktuara, siç janë rastet kur dika mund të editohet, ose diçka po ngarkohet etj.

<!-- KC:setting -->

##### Aktivizo gjurmuesin e miut {#toc71}

|Tasti në desktop |NVDA+m|
|Tasti në laptop |NVDA+shift+m|

Kur aktivizohet, programi NVDA do t’ju njoftojë për tekstin që gjendet nën kursorin e miut derisa ju e lëvizni miun nëpër ekran. Kjo ju mundëson që të gjeni gjëra në ekran duke e lëvizur fizikisht miun, në vend se të mundoheni t’i gjeni ato përmes navigimit të objektit.

##### Rezolucioni i njësisë së tekstit {#toc72}

Nëse programi NVDA është konfiguruar që të lajmërojë tekstin që është nën miun derisa ju e lëvizni atë, ky opsion do t’ju mundësojë të zgjidhni saktësisht sa tekst do të flitet.
Opsionet janë karakteri, fjala, rreshti dhe paragrafi.

##### Raporto rolin kur miu hyn në një objekt {#toc73}

Nëse kjo kuti opsionesh aktivizohet, programi NVDA do të lajmërojë rolin (llojin) e objektit derisa miu të lëvizë përbrenda tij.

##### Luaj koordinata zanore kur miu lëvizë {#toc74}

Zgjedhja e kësaj kutie opsionale bën që programi NVDA të jap bipe derisa miu lëvizet, në mënyrë që përdoruesi të mund ta kuptojë se ku është miu në relacion me dimensionet e ekranit.

##### Kontrollet e shkëlqimit për vëllimin e koordinatave zanore {#toc75}

Nëse zgjidhet kutia opsionale ‘luaj koordinatat zanore kur miu lëvizë”, atëherë zgjedhja e këtij opsioni nënkupton që vëllimi i bipeve të koordinatave zanore kontrollohet nga ajo se sa i zdritur është ekrani nën miun.
Ky konfigurim është çaktivizuar në mënyrë automatike.

#### Konfigurimet e kursorit për rishikim {#toc76}

Gjendet në menynë Preferences, te Review Cursor...
Paneli përmban opsionet në vijim:

<!-- KC:setting -->

##### Përcjell fokusin e sistemit {#toc77}

|Tasti në desktop |NVDA+7|
|Tasti në laptop |NVDA+control+7|

Kur aktivizohet, gjatë ndryshimeve kursori për rishikim gjithmonë do të vendoset në objektin e njëjtë sikurse fokusi i sistemit. 

<!-- KC:setting -->

##### Përcjell kursorin për editim {#toc78}

Tasti: NVDA+6

Kur aktivizohet, sa herë që të lëvizet kursori për editim, kursori për rishikim do të lëvizet në mënyrë automatike në pozitën e tij.

##### Përcjell miun {#toc79}

Kur aktivizohet, kursori për rishikim do të përcjell miun derisa ky i fundit lëviz.

##### Gjendja e rishikimit të thjeshtë {#toc80}

Kur aktivizohet, programi NVDA do të filtrojë hierarkinë e objekteve që mund të navigohen, në mënyrë që të përjashtojë të gjitha objektet e papërdorshme.

#### Konfigurimet e prezantimit të objektit (NVDA+control+o) {#toc81}

Gjendet në menynë Preferences, te "Object Presentation...".
Ky panel i konfigurimeve përmban opsionet në vijim:

##### Raporto këshillat për veglat {#toc82}

Një kuti opsionesh e cila, kur aktivizohet, i thotë programit NVDA që të lajmërojë këshilla për veglat derisa ato shfaqen.
Shumë kontrolle të Windows-it tregojnë një porosi të vogël (ose këshillë për veglën) kur ju lëvizni kursorin e miut përmbi ato, ose, ndonjëherë, kur ju lëvizni fokusin në ato.

##### Raporto balonat për ndihmë {#toc83}

Kjo kuti opsionale, nëse zgjidhet, i thotë programit NVDA që të lajmërojë shfaqjen e balonave për ndihmë.
Balonat për ndihmë janë sikurse këshillat për veglat, por zakonisht janë më të mëdha në madhësi dhe janë të ndërlidhura me ngjarje sistemore si p.sh. ç’kyçja e ndonjë kablloje të rrjetit, ose ndoshta për t’ju paralajmëruar për probleme të Windows-it në lidhje me sigurinë.

##### Raporto tastet për shkurtesa të objekteve {#toc84}

Kur kjo kuti opsionale zgjidhet, programi NVDA do të përfshijë tastin për shkurtesë të shoqëruar me një objekt ose kontroll të caktuar kur ai të lajmërohet.
Për shembull, menyja File në tabelën e menysë mund të ketë tastin alt+f për rrugën e shkurtë deri tek ajo.

##### Raporto informatat për pozitën e objektit {#toc85}

Ky opsion ju lejon që të zgjidhni nëse dëshironi që t’ju raportohet pozita e një objekti (p.sh. 1 prej 4) gjatë lëvizjes deri te objekti përmes fokusit ose navigimit të objektit.

##### Hamendëso për informatat për pozitën e objektit kur ato nuk janë të disponueshme {#toc86}

Nëse është i kyçur raportimi i informatave për pozitën e objektit, ky opsion i mundëson programit NVDA që të hamendësoj informatat për pozitën e objektit në rastet kur ato nuk janë në dispozicion për një kontroll të veçantë.
Kur është i kyçur, programi NVDA do të lajmërojë informatat rreth pozitës për më shumë kontrolle siç janë menytë dhe panelet e veglave, megjithatë këto informata mund të jenë pakëz të pasakta. 

##### Raporto përshkrimet e objektit {#toc87}

Çaktivizoni këtë kuti opsionale nëse mendoni se nuk keni nevojë që së bashku me objektet të dëgjoni edhe përshkrimin e tyre. 

<!-- KC:setting -->

##### Lajmërimi për paletën e progresit {#toc88}

|Tasti në desktop |NVDA+u|
|Tasti në laptop |NVDA+control+f2|

Ky opsion kontrollon mënyrën se si programi NVDA ua raporton rifreskimet e panelit të progresit.
Ai ka opsionet në vijim:

* E ç’kyçur (off): Paletat e progresit nuk do të raportohen gjatë ndryshimit të tyre.
* Fol: Ky opsion i tregon programit NVDA që të raportojë paletën e progresit në përqindje. Sa herë që ndryshon paleta e progresit, programi NVDA do të raportojë vlerën e re.
* Bip: Ky i tregon programit NVDA të bëjë bip sa herë që ndryshon paleta e progresit. Sa më i lartë të jetë bipi, më afër përfundimit është paleta e progresit.
* Bip dhe fol: Ky opsion i tregon programit NVDA që njëkohësisht të bëjë bip dhe flasë me rastin e rifreskimeve të paletës së progresit.

##### Raporto paletat e progresit në prapavijë {#toc89}

Ky është një opsion i cili, nëse zgjidhet, i thotë programit NVDA të vazhdojë raportimin e paletës së progresit edhe nëse ajo nuk shfaqet fizikisht në ekran.
Nëse minimizoni apo largoheni nga ndonjë dritare që përmban paletën e progresit, programi NVDA do ta përcjellë atë duke ju mundësuar që të bëni gjëra tjera ndërsa NVDA e përcjellë paletën e progresit.

<!-- KC:setting -->

##### Raporto ndryshimet dinamike të përmbajtjes {#toc90}

Tasti: NVDA+5

Kyçë lajmërimet për përmbajtje të re në objekte të veçanta siç janë terminalet dhe kontrolli i historisë në programet për bisedë.

#### Konfigurimi i gjendjes së shfletimit (NVDA+control+b) {#toc91}

Paneli i konfigurimeve të gjendjes së shfletimit mund të gjendet në menynë Preferences, te "Browse mode...".
Paneli përmban opsionet në vijim:

##### Numri maksimal i karaktereve në një rresht {#toc92}

Kjo fushë përcakton gjatësinë maksimale të një rreshti në gjendjen e shfletimit (në karaktere).

##### Numri maksimal i rreshtave për faqe {#toc93}

Kjo fushë përcakton numrin e rreshtave nëpër të cilat do të kaloni kur të shtypni tastet page up ose page down në gjendjen e shfletimit.

<!-- KC:setting -->

##### Përdor pamjen e ekranit {#toc94}

Tasti: NVDA+v

Ky opsion ju lejon të specifikoni nëse në përmbajtjen në gjendjen e shfletimit duhet të vendoset edhe përmbajtja sikurse vegzat dhe fushat tjera, në rreshtin e tyre, ose nëse duhet të ruhen në rrjedhën e tekstit ashtu si janë paraqitur në mënyrë vizuale. Nëse opsioni aktivizohet atëherë gjërat do të mbeten ashtu siç janë paraqitur në mënyrë vizuale, por, nëse çaktivizohet,  fushat do të vendosen nëpër rreshtat e tyre.

##### Raporto pamjen e tabelave {#toc95}

Kur çaktivizohet, ky opsion bën që programi NVDA të raportojë vetëm tabelat që raportojnë të dhëna tabulare (aty ku ka kuptim që të dihet se kjo është një tabelë).
Por nëse aktivizohet, programi NVDA gjithashtu do të raportojë tabelat që përdoren vetëm për prezantim vizual.

##### Konfigurimi i lajmërimit të fushave siç janë vegzat dhe titujt {#toc96}

Ju lutem shihni opsionet në [Paneli i konfigurimeve të formatimit të dokumenteve](#DocumentFormattingSettings) për konfigurimin e fushave të cilat fliten gjatë navigimit, sic janë vegzat, titujt dhe tabelat.

##### Gjendja e fokusimit automatik për ndryshimet e fokusit {#toc97}

Ky opsion mundëson paraqitjen e gjendjes së fokusit nëse fokusi ndryshohet.
Për shembull, gjatë shfletimit të një ueb faqeje, nëse shtypni tastin tab dhe përfundoni në një formular, nëse ky opsion zgjidhet automatikisht do të shfaqet gjendja e fokusimit.

##### Gjendja e fokusimit automatik për lëvizjen e kursorit {#toc98}

Ky opsion, nëse zgjidhet, i mundëson programit NVDA të hyjë dhe dal nga gjendja e fokusimit duke përdorur tastet e shigjetave.
Për shembull, gjatë lëvizjes me shigjetën poshtë nëpër ueb faqe përfundoni në një kuti të editimit, programi NVDA do t’ju sjell automatikisht në gjendjen e fokusimit. Nëse dilni nga kutia e editimit përmes shigjetave, programi NVDA do t’ju kthejë në gjendjen e shfletimit.

##### Treguesi zanor i gjendjeve të fokusimit dhe shfletimit {#toc99}

Nëse ky opsion aktivizohet, programi NVDA, në vend se ta thotë ndryshimin, do të lëshojë tinguj special kur të kalojë prej gjendjes së shfletimit në gjendjen e fokusimit dhe anasjelltas.

#### Konfigurimet e formatimit të dokumenteve (NVDA+control+d) {#DocumentFormattingSettings}

Kjo kuti dialogu gjendet në menynë Preferences, te "Document Formatting...".
Shumica e kutive opsionale në këtë dialog shërbejnë për të konfiguruar llojin e informatave që ju dëshironi t’i dëgjoni në mënyrë automatike derisa lëvizni kursorin nëpër dokumente.
Për shembull, nëse zgjidhni kutinë opsionale për raportimin e emrit të fontit, do të bëhet i ditur emri i fontit.
Ju mund të konfiguroni lajmërimin për:

* emrin e fontit
* madhësinë e fontit
* karakteristikat e fontit
* bashkërendimin e tekstit
* ngjyrat
* modelin e tekstit
* gabimet në drejtshkrim 
* numrat e faqeve
* numrat e rreshtave
* tabelat
* titujt e rreshtave/kolonave në tabelë
* vegzat
* titujt
* listat
* blloqet e citateve
* pikat e referimit

##### Njoftimi i ndryshimeve të formatit pas kursorit {#toc101}

Nëse aktivizohet, ky konfigurim i thotë programit NVDA që të mundohet dhe të detektojë të gjitha ndryshimet në formatin e një fjalie gjersa e thotë atë, edhe nëse të bërit e kësaj gjëje mund të ngadalësojë performansën e programit NVDA. 
Në mënyrë automatike programi NVDA do të detektojë formatin në pozitën e kursorit për editim/ kursorit për rishikim dhe, në disa raste, mund të detektojë edhe formatin në pjesën e mbetur të rreshtit vetëm nëse kjo nuk do të shkaktojë zvogëlimin e performansës.
Aktivizoni këtë opsion derisa jeni duke reviduar dokumente në aplikacionet siç janë Microsoft Word, ku formatimi është i rëndësishëm.

#### Fjalorët e të folurit {#toc102}

Menyja e fjalorëve të të folurit (gjendet në menynë Preferences) përmban kuti të dialogëve të cilat ju mundësojnë që të menaxhoni mënyrën se si programi NVDA flet fjalë ose fraza të veçanta. 
Për momentin, ekzistojnë tre lloje të ndryshme të fjalorëve.
Ata janë:

* Automatik: rregullat në këtë fjalor ndikojnë gjithë të folurit në programin NVDA.
* Zanor: rregullat në këtë fjalim ndikojnë në të folurit që përdoret për zërin e sintetizuesit.
* I përkohshëm: rregullat në këtë fjalor ndikojnë në të gjithë të folurit në NVDA, por vetëm për sesionin aktual. Këto rregulla janë të përkohshme dhe do të humbasin nëse programi NVDA ristartohet.

Të gjithë dialogët e fjalorëve përmbajnë një listë rregullash që përdoret për procesimin e të folurit.
Dialogu gjithashtu përmban butonët Add, Edit dhe remove.
Për të shtuar një rregull të ri në fjalor shtypni butonin Add, plotësoni fushat në kutinë e dialogut që paraqitet dhe shtypni Ok.
Pas kësaj ju do të mund të shihni rregullën tuaj të re në listën e rregullave.
Por, në mënyrë që të siguroheni se rregulla juaj vërtetë është ruajtur, pasi të keni përfunduar me shtimin/ editimin e rregullave sigurohuni që të shtypni Ok për të dalë plotësisht nga dialogu i fjalorit.
Rregullat për fjalorët e të folurit të programit NVDA ju mundësojnë që të ndryshoni një varg të karaktereve në një tjetër.
Një shembull i thjeshtë për këtë do të ishte kur ju dëshironi që programi NVDA të thotë fjalën bretkosë sa herë që duhet ta thotë fjalën zog.
Në dialogun Add rule, mënyra më e lehtë për ta bërë këtë është të shtypni fjalën zog në fushën  Pattern dhe fjalën bretkosë në fushën Replacement.
Gjithashtu, mund të shtypni një përshkrim të rregullës në fushën Comment (diçka e ngjashme me: ndryshon fjalën zog në bretkosë).
Fjalorët e të folurit të programit NVDA janë megjithatë shumë më të avancuar se zëvendësimi i thjeshtë i fjalëve.
Dialogu Add rule përmban edhe një kuti opsionale për të zgjedhur nëse dëshironi ose jo që rregulla të dallojë shkronjat e mëdha dhe të vogla (d.m.th. që programi NVDA të ketë parasysh nëse karakteret janë me shkronja të mëdha apo të vogla. Programi NVDA në mënyrë automatike injoron dallimin e shkronjave të mëdha dhe të vogla.
Një kuti opsionale tjetër ju mundëson që të deklaroni nëse modeli juaj është “Shprehje e zakonshme” (ang.Regular expression). 
Shprehja e zakonshme është një model i cili përmban simbole të veçanta që ju mundësojnë të korrespondoni më shumë se një karakter njëherësh, ose korrespondoni vetëm numrat, ose vetëm shkronjat.
Shprehjet e zakonshme nuk janë shtjelluar në këtë duehësues për përdoruesit, por në internet ka shumë ligjërata të cilat mund t’ju ofrojnë më shumë informata.

### Ruajtja dhe ringarkimi i konfigurimit {#toc103}

Programi NVDA nuk i ruan konfigurimet tuaja në mënyrë automatike, kështu nëse dilni nga programi NVDA dhe pastaj e ristartoni, konfigurimet do të rikthehen në vlerat origjinale.
Mbani mend që ky opsion megjithatë mund të ndryshohet në opsionet e përgjithshme në menynë Preferences.
Për të ruajtur konfigurimet, zgjidhni opsionin konfigurues Save në menynë e programit NVDA.
Nëse programi NVDA është sistem skedarësh që vetëm mund të lexohen, si p.sh. CD, ai nuk do të jetë në gjendje që të ruajë konfigurimet tuaja dhe do t’ju tregojë për këtë.
Nëse ndonjëherë gaboni me konfigurimet tuaja dhe ju nevojitet që të riktheheni në konfigurimet e ruajtura, zgjidhni opsionin "revert to saved configuration" në menynë e programit NVDA.
Urdhrat në vijim, të cilët jepen përmes tasteve, janë gjithashtu të dobishëm:
<!-- KC:beginInclude -->

| Emri |Tasti në desktop |Tasti në laptop |Përshkrimi|
|---|---|---|---|
|Ruaj konfigurimin |NVDA+control+c |NVDA+control+c |Ruan konfigurimin tuaj aktual në mënyrë që ai të mos humbet gjatë daljes nga programi NVDA|
|Rikthehu te konfigurimi i ruajtur |NVDA+control+r |NVDA+control+r |Kthen programin NVDA në konfigurimet që kanë ekzistuar kur ju keni ruajtur konfigurimin e NVDA për herë të fundit|

<!-- KC:endInclude -->

### Skedarët e konfigurimit dhe profilet e përdoruesve {#toc104}

Versionet portative të programit NVDA ruajnë të gjitha konfigurimet, modulet e përshtatura të aplikacioneve dhe drajverët e përshtatur në një direktori të quajtur userConfig që gjendet në direktorinë e programit NVDA.
Versionet e instaluara të programit NVDA ruajnë të gjitha konfigurimet, modulet e përshtatura të aplikacioneve dhe drajverët e përshtatur në një direktori të veçantë të programit NVDA që ndodhet në profilin tuaj të përdoruesit në Windows.
Kjo do të thotë që çdo përdorues në sistem mund të ketë konfigurimet e tij/saj të programit NVDA.
Për të arritur në direktorinë e konfigurimeve tuaja, për versionet e instaluar të programit NVDA, në menynë Start mund të shkoni te programs -> NVDA -> explore user configuration directory.
Konfigurimet për programin NVDA, deri sa operohet në ekranet për regjistrim ose UAC, ruhen në direktorinë systemConfig e cila gjendet në direktorinë për instalim të NVDA.
Zakonisht ky konfigurim nuk duhet të preket.
Për të ndryshuar mënyrën si është konfiguruar programi NVDA në ekranet për regjistrim/ UAC, konfiguroni programin ashtu si dëshironi derisa jeni të regjistruar në Windows dhe pastaj udhëzoni programin NVDA që të kopjojë konfigurimin në ekranin për regjistrim duke përdorur butonin në panelin e konfigurimeve të përgjithshme (ang. General settings).

## Veglat shtesë {#toc105}
### Shikuesi i regjistrave {#toc106}

Shikuesi i regjistrave që gjendet në Tools në menynë e programit NVDA, ju mundëson të shikoni të gjithë regjistrat dalës që janë mbledhur deri më tani që prej kohës kur keni startuar për herë të fundit programin NVDA.
Përveç leximit të përmbajtjes, gjithashtu mund të ruani një kopje të skedarit të regjistrave, ose të rifreskoni shikuesin ashtu që të paraqesë daljet më të fundit që prej kohës së hapjes së shikuesit të regjistrave.
Këto veprime janë në dispozicion në menynë e shikuesit Log.

### Shikuesi i fjalëve {#toc107}

Për zhvilluesit e softuerëve që nuk janë të verbër ose njerëzit që bëjnë demo të programit NVDA për një audiencë që nuk është e verbër, është në dispozicion një dritare lëvizëse që ju mundëson të shikoni tërë tekstin që për momentin e flet programi NVDA.
Për të aktivizuar shikuesin e fjalëve, përzgjidhni opsionin "Speech Viewer" në menynë Tools, e cila gjendet në menynë e programit NVDA.
Për ta çaktivizuar, ndaleni opsionin në meny.
Gjersa shikuesi i fjalëve është i aktivizuar, ai në mënyrë konstante rifreskohet dhe ju tregon tesktin që është folur për herë të fundit.
Megjithatë, nëse klikoni ose fokusoni përbrenda shikuesit, programi NVDA do të ndalojë përkohësisht rifreskimin e tekstit, ashtu që ju të mundeni të përzgjidhni ose kopjoni përmbajtjen ekzistuese në mënyrë të lehtë.

### Konzola Python {#toc108}

Konzola Python e programit NVDA, e cila gjendet në Tools në menynë e NVDA, është një vegël zhvilluese e dobishme për testimin e programit me korrigjim të gabimeve të paraqitura në të, inspektimin e përgjithshëm të brendësive të programit NVDA ose inspektimin e hierarkisë së qasshmërisë në një aplikacion.
Për më shumë informata shihni [artikullin për Konzolën Python në ueb faqen e NVDA_URLëiki/PythonConsole].

### Ringarkimi i shtesave {#toc109}

Ky opsion, pasi të aktivizohet, ringarkon modulet e aplikacioneve dhe shtesat globale pa pasur nevojë për ristartimin e programit NVDA, gjë që mund të jetë e dobishme për zhvilluesit e softuerëve.

1. Sintetizuesit e mbështetur të të folurit +[ SupportedSpeechSynths]
Kjo pjesë përmban informata për sintetizuesit e të folurit që mbështeten nga programi NVDA.

++ eSpeak ++
Sintetizuesi [eSpeak](http://espeak.sourceforge.net/) është inkorporuar në mënyrë të drejtpërdrejtë në programin NVDA dhe për instalimin e tij nuk nevojiten drajvera ose komponentë të tjerë të veçantë.
Programi NVDA në mënyrë automatike fillon të përdorë eSpeak.
Meqë ky sintetizues është i inkorporuar në programin NVDA, kjo është një zgjedhje e shkëlqyer për rastet kur programi NVDA përdoret prej USB ose CD në sisteme tjera.
Çdo zë që vjen me eSpeak flet një gjuhë tjetër.
ESpeak mbështetet mbi 20 gjuhë të ndryshme.
Gjithashtu, ka shumë variante të cila mund të zgjidhen për të ndryshuar tingëllimën e zërit.

++ Microsoft Speech API, versioni 4  (SAPI 4) ++
SAPI 4 është një standard më i vjetër i Microsoft-it për softuerët e sintetizuesve të të folurit.
Shumë sintetizues të të folurit që përputhen me këtë standard mund të blihen ose shkarkohen falas nga kompani dhe ueb faqe të ndryshme.
Gjatë përdorimit të këtij sintetizuesi me programin NVDA, zërat në dispozicion (tek të cilët mund të hyni nga [paneli për konfigurimet e zërit](#VoiceSettings) ose përmes [Unaza e konfigurimeve të sintetizuesit](#SynthSettingsRing)) do të përmbajnë të gjithë zërat nga të gjithë veglat e instaluara të SAPI 4 që gjenden në sistemin tuaj.
Nëse keni instaluar zërat e SAPI 4 por sintetizuesi nuk shfaqet në listën e sintetizuesve të programit NVDA, ju lutem instaloni shifrat binare të kohës së operimit SAPI 4.0, të cilat mund t’i gjeni në http://activex.microsoft.com/activex/controls/sapi/spchapi.exe.

++ Microsoft Speech API, versioni 5 (SAPI 5) ++
SAPI 5 është standard i Microsoft-it për softuerët e sintetizuesve të të folurit.
Shumë sintetizues të të folurit që përputhen me këtë standard mund të blihen ose shkarkohen falas nga kompani dhe ueb faqe të ndryshme, megjithëse sistemi juaj me siguri do të vijë me të paktën një SAPI 5 të instaluar paraprakisht.
Gjatë përdorimit të këtij sintetizuesi me programin NVDA, zërat në dispozicion (tek të cilët mund të hyni nga [paneli për konfigurimet e zërit](#VoiceSettings) ose përmes [Unaza e konfigurimeve të sintetizuesit](#SynthSettingsRing)) do të përmbajnë të gjithë zërat nga të gjithë veglat e instaluara të SAPI 5 që gjenden në sistemin tuaj.

++ Audiologic Tts3 ++
Ky është një sintetizues komercial i të folurit i zhvilluar në mënyrë specifike për gjuhën italiane.
Ju duhet të instaloni sintetizuesin në sistemin tuaj në mënyrë që ai të mund të përdoret me programin NVDA.
Për më shumë informata, ju lutem vizitoni ueb faqen e Audiologic në [www.audiologic.it](http://www.audiologic.it).

++ Newfon ++
Newfon është sintetizues komercial falas i zhvilluar nga Sergey Shishmintzev, i cili mbështet gjuhët ruse dhe ukrainase.
Për të shkarkuar këtë sintetizues vizitoni seksionin e shkarkimeve në ueb faqen e bashkësisë Ruse të NVDA: http://ru.nvda-community.org/?page_id=10

1. Shpalosjet e mbështetura të shkrimit braille +[SupportedBrailleDisplays]
Kjo pjesë përmban informata për shpalosjet e shkrimit braille që mbështeten nga programi NVDA.

++ Freedom Scientific Focus/PAC Mate Series ++
Të gjitha shpalosjet e Focus dhe PAC Mate nga [Freedom Scientific http://ëëë.freedomscientific.com/] mbështeten nga NVDA  kur lidhen përmes USB ose bluetooth-it.
Është e nevojshme që të instaloni drajverat për shpalosjet e shkrimit braille të Freedom Scientific në sistemin tuaj.
Nëse nuk i keni instaluar deri më tani, mund t’i gjeni në http://www.freedomscientific.com/doënloads/focus-40-blue/focus-40-blue-doënloads.asp.
Megjithëse kjo faqe përmend vetëm shpalosjen Focus 40 Blue, drajveri mbështet të gjithat shpalosjet e  Freedom Scientific.
Në vazhdim janë paraqitur taste me vlerat e dhëna për këtë shpalosje me programin NVDA.
Ju lutem shihni dokumentacionin e shpalosjes për përshkrimet e vendeve ku mund të gjenden këto taste.
<!-- KC:beginInclude -->

| Emri |Tasti|
|---|---|
|Alterno veprimin e wiz ëheel të majtë |leftWizWheelPress|
|Lëviz prapa duke përdorur veprimin e wiz ëheel të majtë |leftWizWheelUp|
|Lëviz para duke përdorur veprimin e wiz wheel të majtë |leftWizWheelDown|
|Alterno veprimin e wiz wheel të djathtë |rightWizWheelPress|
|Lëviz prapa duke përdorur veprimin e wiz wheel të djathtë |rightWizWheelUp|
|Lëviz para duke përdorur veprimin e wiz wheel të djathtë |rightWizWheelDown|
|Ço në qelizën e shkrimit braille |routing|

<!-- KC:endInclude -->

### Optelec ALVA BC640/680 {#toc110}

Të dy shpalosjet,  ALVA BC640 dhe BC680 nga [Optelec http://ëëë.optelec.com/] mbështeten kur lidhen përmes USB ose Bluetooth-it.
Nuk nevojitet të instaloni ndonjë drajver të veçantë për t’i përdorur këto shpalosje.
Vetëm kyçni shpalosjen dhe konfiguroni programin NVDA për ta përdorur.
Në vazhdim janë paraqitur taste me vlerat e dhëna për këtë pamje në programin NVDA.
Ju lutem shihni dokumentacionin e pamjes për përshkrimet e vendeve ku mund të gjenden këto taste.
<!-- KC:beginInclude -->

| Emri |Tasti|
|---|---|
|Tërhiq shpalosjen e shkrimit braille prapa |t1|
|Lëviz shpalosjen e shkrimit braille në rreshtin e mëparshëm |t2|
|Lëviz shpalosjen e shkrimit braille në rreshtin e radhës |t4|
|Tërhiq shpalosjen e shkrimit braille përpara |t5|
|Ço në qelizën e shkrimit braille |routing|
|tasti shift+tab |sp1|
|tasti alt |sp2|
|tasti escape |sp3|
|tasti tab |sp4|
|tasti shigjeta lartë |spUp|
|tasti shigjeta poshtë |spDown|
|tasti shigjeta majtas |spLeft|
|tasti shigjeta djathtas |spRight|
|tasti enter |spEnter|
|Menyja NVDA |sp1+sp3|
|tasti Windows+d (minimizo të gjitha aplikacionet) |sp1+sp4|
|tasti Windows |sp2+sp3|
|tasti alt+tab| sp2+sp4|

<!-- KC:endInclude -->

### Shpalosjet Handy Tech {#toc111}

Programi NVDA mbështet të gjitha shpalosjet nga [Handy Tech http://ëëë.handytech.de/] kur lidhet përmes USB ose Bluetooth-it.
Për shpalosje më të vjetra për UBS duhet të instaloni drajverët e USB-vë nga Handy Tech në sistemin tuaj.
Në vazhdim janë paraqitur taste me vlerat e dhëna për këtë shpalosje në programin NVDA.
Ju lutem shihni dokumentacionin e shpalosjes për përshkrimet e vendeve ku mund të gjenden këto taste.
<!-- KC:beginInclude -->

| Emri |Tasti|
|---|---|
|Tërhiq shpalosjen e shkrimit braille prapa |majtas, lart|
|Tërhiq shpalosjen e shkrimit braille përpara |djathtas, poshtë|
|Lëviz shpalosjen e shkrimit braille në rreshtin e mëparshëm |b4|
|Lëviz shpalosjen e shkrimit braille në rreshtin e rradhës |b5|
|Ço në qelizën e shkrimit braille |routing|
|tastet shift+tab |esc|

|tasti alt | b2+b4+b5 |

|tasti escape |b4+b6|
|tasti tab |enter|
|tasti enter |esc+enter|
|tasti shigjeta lartë |majtasSpace|
|tasti shigjeta poshtë |djathtasSpace|
|Menyja NVDA |b2+b4+b5+b6|
|Konfigurimi i Handy Tech |b4+b8|

<!-- KC:endInclude -->

### MDV Lilli {#toc112}

Shalosja Lilli e shkrimit braille është në dispozicion në [MDV http://ëëë.mdvbologna.it/].
Nuk nevojitet të instaloni ndonjë drajver të veçantë për ta përdorur këtë shpalosje.
Vetëm kyçni shpalosjen pamjen dhe konfiguroni programin NVDA për ta përdorur.

### Shpalosjet Baum/Humanware/APH e shkrimit braille {#toc113}

Shumë shpalosje [Baum](http://www.baum.de/cms/en/), [HumanWare http://www.humanëare.com/] dhe [APH](http://www.aph.org/) mbështeten nga programi NVDA kur të lidhen përmes USB ose Bluetooth-it.
Këto përfshijnë:

* Baum: SuperVario, PocketVario
* HumanWare: Brailliant, BrailleConnect
* APH: Refreshabraille

Disa shpalosje tjera që prodhohen nga Baum gjithashtu mund të funksionojnë, megjithëse kjo nuk është testuar.
Nëse lidheni përmes USB, duhet që së pari të instaloni drajverat e USB të ofruar nga prodhuesi.
Për APH Refreshabraille, gjendja e USB duhet të konfigurohet në serial.
Në vazhdim janë paraqitur taste me vlerat e dhëna për këtë shpalosje në programin NVDA.
Shihni dokumentacionin e pamjes për përshkrimet e vendeve ku mund të gjenden këto taste.
<!-- KC:beginInclude -->

| Emri |Tasti|
|---|---|
|Tërhiq shpalosjen e shkrimit braille prapa |d2|
|Tërhiq shpalosjen  e shkrimit braille përpara |d5|
|Lëviz shpalosjen e shkrimit braille në rreshtin e mëparshëm |d1|
|Lëviz shpalosjen e shkrimit braille në rreshtin e radhës |d3|
|Ço në qelizën e shkrimit braille |routing|

Për pamjet të cilat kanë xhoistik:

| Emri |Tasti|
|---|---|
|tasti shigjeta lartë |lartë|
|tasti shigjeta poshtë |poshtë|
|tasti shigjeta majtas |majtas|
|tasti shigjeta djathtas |djathtas|
|tasti key |përzgjedh|

<!-- KC:endInclude -->

### BRLTTY {#toc114}

[BRLTTY](http://mielke.cc/brltty/) është program i veçantë që mund të përdoret për të mbështetur më shumë pamje të shkrimit braille.
Në mënyrë që ta përdorni këtë program, duhet të instaloni [BRLTTY për Windows](http://brl.thefreecat.org/brltty/).
Duhet të shkarkoni dhe instaloni pakon më të fundit të instaluesit, e cila do të titullohet, për shembull, brltty-win-4.2-2.exe.
Gjatë konfigurimit të shpalosjeve dhe portit që do të përdoret, sigurohuni që t’i kushtoni vëmendje udhëzimeve, sidomos nëse përdorni shpalosje për USB dhe tanimë keni instaluar drajverat e prodhuesit.
Në vazhdim janë paraqitur urdhrat me vlerat e dhëna për BRLTTY në programin NVDA.
Shihni [dokumentacioni për tabelat e tasteve për BRLTTY në](http://mielke.cc/brltty/doc/drivers/) për informata rreth mënyrës se si urdhrat e BRLTTY janë hartëzuar në kontrollet në shpalosjet e shkrimit braille.
<!-- KC:beginInclude -->

| Emri |Urdhëri BRLTTY|
|---|---|
|Tërhiq shpalosjen e shkrimit braille prapa |fwsinlt (shko majtas për një dritare)|
|Tërhiq shpalosjen e shkrimit braille përpara |fwinrt (shko djathtas për një dritare)|
|Lëviz shpalosjen e shkrimit braille në rreshtin e mëparshëm |lnup (shko lart për një rresht)|
|Lëviz shpalosjen e shkrimit braille në rreshtin e radhës |lndn (shko lart për një rresht)|
|Ço në qelizën e shkrimit braille |route (sill kursorin te karakteri)|

<!-- KC:endInclude -->

## Tema të avancuara {#toc115}
### Ri-hartëzimi i e tasteve me vlerat e dhëna dhe i gjesteve tjera hyrëse {#toc116}

Përdoruesi mund të ofrojnë ose të refuzojnë hartëzimet e gjesteve hyrëse (si p.sh. shtypjet e tasteve) në skripte në një skedar të veçantë në direktorinë e konfigurimit të programit NVDA të përdoruesit.
 Ky skedar quhet  gestures.ini.
Ky skedar përdor sintaksën standarde ini.
Skedari mund të përmbajë seksione të shumta dhe çdo seksion mund të ketë një ose më shumë shënime.
Çdo seksion ofron hartëzime për skriptet në module dhe klasë të veçanta të Python-it përbrenda programit NVDA. 

* Emri i seksionit duhet të jetë moduli dhe klasa e Python-it e ndarë me një pikë (.).
* Tasti për secilën hyrje është emri i skriptit për të cilën duhet të jenë të lidhura gjestet hyrëse.
Në anën tjetër, mund të përdorni None për të liruar gjestet hyrëse nga një skript për të cilën kanë qenë të lidhura më parë.
Çdo tast hyrës mund të listohet vetëm njëherë për çdo seksion, duke përfshirë None.
* Vlera hyrëse është një listë e ndarë me presje (,)e identifikuesve të gjesteve për gjeste hyrëse që duhet të lidhe. 
Identifikuesit e gjesteve që përfundojnë me presje duhet të kenë thonjëza (" ose ').

Identifikuesit e gjesteve përbëhen nga një kod prej dy shkronjash (kb për tastierën dhe br për shpalosjen e shkrimit braille), një nën-vegël opsionale ose pamjet të tastierës në kllapa, kolonë dhe më pas në ose më shumë emra të tasteve të ndarë nga shenja plus (+).
Në mënyrë që të zbuloni identifikuesit e gjesteve, emrat e skripteve, si dhe klasën dhe modulin në të cilin gjenden, ju mund të :

1. Kyçni ndihmën.
1. Aktivizoni gjestin (shtypni tastin).
1. Ç’kyçni ndihmën.
1. Aktivizoni regjistrin e Shikimit në menynë Tools të programit NVDA.
1. Ekzaminoni shënimet e fundit në regjistër.
Një prej këtyre duhet të ofrojë informata për gjestin hyrës që keni dërguar, duke përfshirë modulin, klasën dhe skriptin nëse është e lidhur me një të tillë.

Në vazhdim është paraqitur një shembull i mënyrës se si mund të lidhni NVDA+shift+t me skriptin data dhe koha.
Për të gjetur emrin e saktë dhe modulin e klasën për datën dhe kohën, ju do të kyçnit Input Help dhe të shtypnit NVDA+f12 (pasi që ky është gjesti aktual për skriptin e datës dhe kohës).
Pastaj do të kyçnit Input Help dhe të ekzaminonit shikuesin e regjistrave.
Në fund do të shihnit:

    INFO - inputCore.InputManager._handleInputHelp (13:17:22):
    Input help: gesture kb(desktop):nvda+f12, bound to script dateTime on globalCommands.GlobalCommands

Nga ky shembull mund të shihni se emri i skriptit është dataKoha dhe klasa e modulit është globalCommands.GlobalCommands.
Nëse skedari nuk ekziston ende, ju do të krijonit një skedar të titulluar gestures.ini në direktorinë e konfigurimit të përdoruesit dhe do të shtonit përmbajtjen në vijim:

    [globalCommands.GlobalCommands]
    	dateTime = kb:NVDA+shift+t

Kjo do të lidhte shtypjen e tasteve NVDA+shift+t (në të gjitha pamjet e tastierës) me skriptin dataKoha.
Mbani mend që ende do të punonte lidhja origjinale NVDA+f12.
Nëse ju do të dëshironit që të largoni këtë lidhje, do të shtonit rreshtin në vijim:

    	None = kb:NVDA+f12

Edhe pse jeni të lirë që skriptet t’i lidhni me cilindo tast në dispozicion, mund të jetë problematike që të përdoret tasti alt në tastierë.
Programi NVDA vazhdon të dërgojë tastet modifikuese (si p.sh. shift, control dhe alt) në Sistemin Operativ edhe nëse ato paraqiten në një skript.
Kështu, nëse përdorni alt në një gjest, shtypja e këtij kombinimi tastesh mund të aktivizojë panelin e menysë, si dhe të ekzekutojë skriptin.
Rrjedhimisht, me siguri është më së miri që tastet Shift, control dhe tasti modifikues i NVDA të përdoren vetëm si modifikues.

## Informata të mëtejshme {#toc117}

Nëse ju nevojiten informata të mëtejshme ose ndihmë lidhur me programin NVDA, vizitoni ueb faqen e NVDA në NVDA_URL.
Këtu mund të gjeni dokumente shtesë, si dhe mbështetje teknike dhe burime për komunitetin.
Kjo ueb faqe gjithashtu ofron informata dhe burime lidhur me zhvillimin e programit NVDA.

